import glib, gobject, gio, gtk3

template exampleAppType: GType = exampleAppGetType()

type
  ExampleApp* = ptr ExampleAppObj
  ExampleAppObj = object of ApplicationObj

  ExampleAppClass = ptr ExampleAppClassObj
  ExampleAppClassObj = object of ApplicationClassObj

  ExampleAppPrivate = ptr ExampleAppPrivateObj
  ExampleAppPrivateObj = object

# exampleappwin does import ExampleApp
import exampleappwin, exampleappprefs

gDefineType(ExampleApp, gtk3.applicationGetType())

proc exampleApp(obj: GObject): ExampleApp =
  gTypeCheckInstanceCast(obj, exampleAppGetType(), ExampleAppObj)

proc exampleAppInit(self: ExampleApp) =
  discard

proc preferencesActivated(action: gio.GSimpleAction; parameter: glib.GVariant;
                            app: Gpointer) {.cdecl.} =
  var prefs: ExampleAppPrefs
  var win: Window
  win = getActiveWindow(application(app))
  prefs = exampleAppPrefsNew(exampleAppWindow(win))
  present(prefs)

proc quitActivated(action: gio.GSimpleAction; parameter: glib.GVariant;
                     app: Gpointer)  {.cdecl.} =
  quit(gApplication(app))

var appEntries = [
  gio.GActionEntryObj(name: "preferences", activate: preferencesActivated, parameterType: nil, state: nil, changeState: nil),
  gio.GActionEntryObj(name: "quit", activate: quitActivated, parameterType: nil, state: nil, changeState: nil)]

proc exampleAppStartup(app: gio.GApplication) {.cdecl.} =
  var
    builder: Builder
    appMenu: gio.GMenuModel
    quitAccels = [cstring "<Ctrl>Q", nil]
  gApplicationClass(exampleAppParentClass).startup(app)
  addActionEntries(gio.gActionMap(app), addr appEntries[0], cint(len(appEntries)), app)
  setAccelsForAction(application(app), "app.quit",
                                        cast[cstringArray](addr quitAccels))
  builder = newBuilder(resourcePath = "/org/gtk/exampleapp/app-menu.ui")
  #builder = builderNewFromFile("app-menu.ui")
  appMenu = gMenuModel(getObject(builder, "appmenu"))
  setAppMenu(application(app), appMenu)
  objectUnref(builder)

proc exampleAppActivate(app: gio.GApplication) {.cdecl.} =
  present(exampleAppWindowNew(exampleApp(app)))

proc exampleAppOpen(app: gio.GApplication; files: gio.GFileArray;
                       nFiles: cint; hint: cstring) {.cdecl.} =
  var
    windows: glib.GList
    win: ExampleAppWindow
    i: cint
  windows = getWindows(application(app))
  win =
    if windows != nil: exampleAppWindow(windows.data)
    else: exampleAppWindowNew(exampleApp(app))
  i = 0
  while i < nFiles:
    exampleAppWindowOpen(win, files[i])
    inc(i)
  present(win)

proc exampleAppClassInit(klass: ExampleAppClass) =
  klass.startup = exampleAppStartup
  klass.activate = exampleAppActivate
  klass.open = exampleAppOpen

proc exampleAppNew*(): ExampleApp {.cdecl.} =
  exampleApp(newObject(exampleAppType, "application-id", "org.gtk.exampleapp",
                      "flags", gio.GApplicationFlags.HANDLES_OPEN, nil))
