  {.deadCodeElim: on.}

{.pragma: libgdk, cdecl, dynlib: LIB_GDK.}

import gdk3 except deviceGetType, displayGetType, windowGetType, glContextGetType

from gobject import GType

type # wayland dummy objects
  WlSeat* = object
  WlPointer* = object
  WlKeyboard* = object
  WlDisplay* = object
  WlCompositor* = object
  WlSurface* = object
  XdgShell* = object

type
  WaylandDevice* =  ptr WaylandDeviceObj
  WaylandDevicePtr* = ptr WaylandDeviceObj
  WaylandDeviceObj* = DeviceObj

template typeWaylandDevice*(): expr =
  (waylandDeviceGetType())

template waylandDevice*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeWaylandDevice, WaylandDeviceObj))

template waylandDeviceClass*(c: expr): expr =
  (gTypeCheckClassCast(c, typeWaylandDevice, WaylandDeviceClass))

template isWaylandDevice*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeWaylandDevice))

template isWaylandDeviceClass*(c: expr): expr =
  (gTypeCheckClassType(c, typeWaylandDevice))

template waylandDeviceGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeWaylandDevice, WaylandDeviceClass))

proc deviceGetType*(): GType {.importc: "gdk_wayland_device_get_type",
                                      libgdk.}
proc getWlSeat*(device: Device): ptr WlSeat {.
    importc: "gdk_wayland_device_get_wl_seat", libgdk.}
proc getWlPointer*(device: Device): ptr WlPointer {.
    importc: "gdk_wayland_device_get_wl_pointer", libgdk.}
proc getWlKeyboard*(device: Device): ptr WlKeyboard {.
    importc: "gdk_wayland_device_get_wl_keyboard", libgdk.}
proc getWlSeat*(seat: Seat): ptr WlSeat {.
    importc: "gdk_wayland_seat_get_wl_seat", libgdk.}

type
  WaylandDisplay* =  ptr WaylandDisplayObj
  WaylandDisplayPtr* = ptr WaylandDisplayObj
  WaylandDisplayObj* = DisplayObj

template typeWaylandDisplay*(): expr =
  (waylandDisplayGetType())

template waylandDisplay*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeWaylandDisplay, WaylandDisplayObj))

template waylandDisplayClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeWaylandDisplay, WaylandDisplayClass))

template isWaylandDisplay*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeWaylandDisplay))

template isWaylandDisplayClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeWaylandDisplay))

template waylandDisplayGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeWaylandDisplay, WaylandDisplayClass))

proc displayGetType*(): GType {.importc: "gdk_wayland_display_get_type",
                                       libgdk.}
proc getWlDisplay*(display: Display): ptr WlDisplay {.
    importc: "gdk_wayland_display_get_wl_display", libgdk.}
proc getWlCompositor*(display: Display): ptr WlCompositor {.
    importc: "gdk_wayland_display_get_wl_compositor", libgdk.}
proc getXdgShell*(display: Display): ptr XdgShell {.
    importc: "gdk_wayland_display_get_xdg_shell", libgdk.}
proc setCursorTheme*(display: Display; theme: cstring;
                                     size: cint) {.
    importc: "gdk_wayland_display_set_cursor_theme", libgdk.}

when defined(gtk_Compilation) or defined(gdk_Compilation):
  const
    gdkWaylandSelectionAddTargets* = selectionAddTargetsLibgtkOnly
  proc selectionAddTargets*(window: Window; selection: Atom;
                                     ntargets: cuint; targets: var Atom) {.
      importc: "gdk_wayland_selection_add_targets", libgdk.}
  const
    gdkWaylandSelectionClearTargets* = selectionClearTargetsLibgtkOnly
  proc selectionClearTargets*(display: Display; selection: Atom) {.
      importc: "gdk_wayland_selection_clear_targets", libgdk.}

type
  WaylandWindow* =  ptr WaylandWindowObj
  WaylandWindowPtr* = ptr WaylandWindowObj
  WaylandWindowObj* = WindowObj

template typeWaylandWindow*(): expr =
  (waylandWindowGetType())

template waylandWindow*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeWaylandWindow, WaylandWindowObj))

template waylandWindowClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeWaylandWindow, WaylandWindowClass))

template isWaylandWindow*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeWaylandWindow))

template isWaylandWindowClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeWaylandWindow))

template waylandWindowGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeWaylandWindow, WaylandWindowClass))

proc windowGetType*(): GType {.importc: "gdk_wayland_window_get_type",
                                      libgdk.}
proc getWlSurface*(window: Window): ptr WlSurface {.
    importc: "gdk_wayland_window_get_wl_surface", libgdk.}
proc setUseCustomSurface*(window: Window) {.
    importc: "gdk_wayland_window_set_use_custom_surface", libgdk.}
proc setDbusPropertiesLibgtkOnly*(window: Window;
    applicationId: cstring; appMenuPath: cstring; menubarPath: cstring;
    windowObjectPath: cstring; applicationObjectPath: cstring;
    uniqueBusName: cstring) {.importc: "gdk_wayland_window_set_dbus_properties_libgtk_only",
                            libgdk.}

template typeWaylandGlContext*(): expr =
  (waylandGlContextGetType())

template waylandGlContext*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeWaylandGlContext, WaylandGLContext))

template waylandIsGlContext*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeWaylandGlContext))

proc glContextGetType*(): GType {.
    importc: "gdk_wayland_gl_context_get_type", libgdk.}
