import gtk3, gio, glib, gobject

from exampleappwin import ExampleAppWindow

template exampleAppPrefsType: expr = exampleAppPrefsGetType()

type
  ExampleAppPrefs* = ptr ExampleAppPrefsObj
  ExampleAppPrefsObj = object of gtk3.DialogObj

  ExampleAppPrefsClass = ptr ExampleAppPrefsClassObj
  ExampleAppPrefsClassObj = object of gtk3.DialogClassObj

  ExampleAppPrefsPrivate = ptr ExampleAppPrefsPrivateObj
  ExampleAppPrefsPrivateObj = object
    settings: gio.GSettings
    font: gtk3.Widget
    transition: gtk3.Widget

gDefineTypeWithPrivate(ExampleAppPrefs, dialogGetType())

proc exampleAppPrefs(obj: GObject): ExampleAppPrefs =
  gTypeCheckInstanceCast((obj), exampleAppPrefsGetType(), ExampleAppPrefsObj)

proc exampleAppPrefsInit(self: ExampleAppPrefs) =
  var priv: ExampleAppPrefsPrivate
  priv = exampleAppPrefsGetInstancePrivate(self)
  initTemplate(self)
  priv.settings = newSettings("org.gtk.exampleapp")
  `bind`(priv.settings, "font", priv.font, "font", gio.GSettingsBindFlags.DEFAULT)
  `bind`(priv.settings, "transition", priv.transition, "active-id", gio.GSettingsBindFlags.DEFAULT)

proc exampleAppPrefsDispose(obj: gobject.GObject) {.cdecl.} =
  var priv: ExampleAppPrefsPrivate
  priv = exampleAppPrefsGetInstancePrivate(exampleAppPrefs(obj))
  clearObject(GObject(priv.settings))
  priv.settings = nil # https://github.com/nim-lang/Nim/issues/3449
  gObjectClass(exampleAppPrefsParentClass).dispose(obj)

proc exampleAppPrefsClassInit(klass: ExampleAppPrefsClass) =
  klass.dispose = exampleAppPrefsDispose
  setTemplateFromResource(klass, "/org/gtk/exampleapp/prefs.ui")
  # we may replace function call above by this code to avoid use of resource:
  #var
  #  buffer: cstring
  #  length: gsize
  #  error: glib.GError = nil
  #  gbytes: glib.GBytes = nil
  #if not gFileGetContents("prefs.ui", buffer, length, error):
  #  gCritical("Unable to load prefs.ui \'%s\': %s", gObjectClassName(klass), error.message)
  #  free(error)
  #  return
  #gbytes = gBytesNew(buffer, length)
  #setTemplate(klass, gbytes)
  #gFree(buffer)
  # done
  widgetClassBindTemplateChildPrivate(klass, ExampleAppPrefs, font)
  widgetClassBindTemplateChildPrivate(klass, ExampleAppPrefs, transition)

proc exampleAppPrefsNew*(win: ExampleAppWindow): ExampleAppPrefs =
  exampleAppPrefs(newObject(exampleAppPrefsType, "transient-for", win,
                      "use-header-bar", true, nil))
