  {.deadCodeElim: on.}

{.pragma: libgdk, cdecl, dynlib: LIB_GDK.}

import gdk3

from gobject import GType

type # unity mir dummy objects
  MirConnection* = object
  MirSurface* = object

template typeMirDisplay*(): expr =
  (mirDisplayGetType())

template isMirDisplay*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeMirDisplay))

template typeMirGlContext*(): expr =
  (mirGlContextGetType())

template mirIsGlContext*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeMirGlContext))

template typeMirWindow*(): expr =
  (mirWindowGetType())

template isMirWindow*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeMirWindow))

proc mirDisplayGetType*(): GType {.importc: "gdk_mir_display_get_type",
                                   libgdk.}
proc mirDisplayGetMirConnection*(display: Display): ptr MirConnection {.
    importc: "gdk_mir_display_get_mir_connection", libgdk.}
proc mirWindowGetType*(): GType {.importc: "gdk_mir_window_get_type", libgdk.}
proc mirWindowGetMirSurface*(window: Window): ptr MirSurface {.
    importc: "gdk_mir_window_get_mir_surface", libgdk.}
proc mirGlContextGetType*(): GType {.importc: "gdk_mir_gl_context_get_type",
                                     libgdk.}
