  {.deadCodeElim: on.}

{.pragma: libgdk, cdecl, dynlib: LIB_GDK.}

import gdk3 except cursorGetType, displayGetType, displayManagerGetType, dragContextGetType, keymapGetType, screenGetType, visualGetType, windowGetType

from glib import Gunichar

from gobject import GType

from gdk_pixbuf import GdkPixbuf

type # macosx quartz dummy objects
  NSString* = object
  NSImage* = object
  NSEvent* = object
  NSWindow* = object
  NSView* = object
  Id* = culong

when not defined(NSINTEGER_DEFINED):
  type
    NSInteger* = cint
    NSUInteger* = cuint
when not defined(CGFLOAT_DEFINED):
  type
    CGFloat* = cfloat
type
  OSXVersion* {.size: sizeof(cint), pure.} = enum
    UNSUPPORTED = 0, MIN = 4, LEOPARD = 5,
    SNOW_LEOPARD = 6, LION = 7, MOUNTAIN_LION = 8,
    NEW = 99

const
  OSX_TIGER = OSXVersion.MIN
  OSX_CURRENT = OSXVersion.MOUNTAIN_LION

proc osxVersion*(): OSXVersion {.importc: "gdk_quartz_osx_version",
    libgdk.}
proc pasteboardTypeToAtomLibgtkOnly*(`type`: ptr NSString): Atom {.
    importc: "gdk_quartz_pasteboard_type_to_atom_libgtk_only", libgdk.}
proc targetToPasteboardTypeLibgtkOnly*(target: cstring): ptr NSString {.
    importc: "gdk_quartz_target_to_pasteboard_type_libgtk_only", libgdk.}
proc toPasteboardTypeLibgtkOnly*(atom: Atom): ptr NSString {.
    importc: "gdk_quartz_atom_to_pasteboard_type_libgtk_only", libgdk.}

template typeQuartzCursor*(): expr =
  (quartzCursorGetType())

template quartzCursor*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeQuartzCursor, QuartzCursorObj))

template quartzCursorClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeQuartzCursor, QuartzCursorClass))

template isQuartzCursor*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeQuartzCursor))

template isQuartzCursorClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeQuartzCursor))

template quartzCursorGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeQuartzCursor, QuartzCursorClass))

type
  QuartzCursor* =  ptr QuartzCursorObj
  QuartzCursorPtr* = ptr QuartzCursorObj
  QuartzCursorObj* = CursorObj

proc cursorGetType*(): GType {.importc: "gdk_quartz_cursor_get_type",
                                     libgdk.}

template typeQuartzDeviceCore*(): expr =
  (quartzDeviceCoreGetType())

template quartzDeviceCore*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeQuartzDeviceCore, QuartzDeviceCore))

template quartzDeviceCoreClass*(c: expr): expr =
  (gTypeCheckClassCast(c, typeQuartzDeviceCore, QuartzDeviceCoreClass))

template isQuartzDeviceCore*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeQuartzDeviceCore))

template isQuartzDeviceCoreClass*(c: expr): expr =
  (gTypeCheckClassType(c, typeQuartzDeviceCore))

template quartzDeviceCoreGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeQuartzDeviceCore, QuartzDeviceCoreClass))

proc deviceCoreGetType*(): GType {.
    importc: "gdk_quartz_device_core_get_type", libgdk.}

template typeQuartzDeviceManagerCore*(): expr =
  (quartzDeviceManagerCoreGetType())

template quartzDeviceManagerCore*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeQuartzDeviceManagerCore, QuartzDeviceManagerCore))

template quartzDeviceManagerCoreClass*(c: expr): expr =
  (gTypeCheckClassCast(c, typeQuartzDeviceManagerCore, QuartzDeviceManagerCoreClass))

template isQuartzDeviceManagerCore*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeQuartzDeviceManagerCore))

template isQuartzDeviceManagerCoreClass*(c: expr): expr =
  (gTypeCheckClassType(c, typeQuartzDeviceManagerCore))

template quartzDeviceManagerCoreGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeQuartzDeviceManagerCore, QuartzDeviceManagerCoreClass))

proc deviceManagerCoreGetType*(): GType {.
    importc: "gdk_quartz_device_manager_core_get_type", libgdk.}

template typeQuartzDisplay*(): expr =
  (quartzDisplayGetType())

template quartzDisplay*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeQuartzDisplay, QuartzDisplayObj))

template quartzDisplayClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeQuartzDisplay, QuartzDisplayClass))

template isQuartzDisplay*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeQuartzDisplay))

template isQuartzDisplayClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeQuartzDisplay))

template quartzDisplayGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeQuartzDisplay, QuartzDisplayClass))

type
  QuartzDisplay* =  ptr QuartzDisplayObj
  QuartzDisplayPtr* = ptr QuartzDisplayObj
  QuartzDisplayObj* = DisplayObj

proc displayGetType*(): GType {.importc: "gdk_quartz_display_get_type",
                                      libgdk.}

template typeQuartzDisplayManager*(): expr =
  (quartzDisplayManagerGetType())

template quartzDisplayManager*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeQuartzDisplayManager, QuartzDisplayManagerObj))

type
  QuartzDisplayManager* =  ptr QuartzDisplayManagerObj
  QuartzDisplayManagerPtr* = ptr QuartzDisplayManagerObj
  QuartzDisplayManagerObj* = DisplayManagerObj

proc displayManagerGetType*(): GType {.
    importc: "gdk_quartz_display_manager_get_type", libgdk.}

template typeQuartzDragContext*(): expr =
  (quartzDragContextGetType())

template quartzDragContext*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeQuartzDragContext, QuartzDragContextObj))

template quartzDragContextClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeQuartzDragContext, QuartzDragContextClass))

template isQuartzDragContext*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeQuartzDragContext))

template isQuartzDragContextClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeQuartzDragContext))

template quartzDragContextGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeQuartzDragContext, QuartzDragContextClass))

type
  QuartzDragContext* =  ptr QuartzDragContextObj
  QuartzDragContextPtr* = ptr QuartzDragContextObj
  QuartzDragContextObj* = DragContextObj

proc dragContextGetType*(): GType {.
    importc: "gdk_quartz_drag_context_get_type", libgdk.}
proc getDraggingInfoLibgtkOnly*(context: DragContext): Id {.
    importc: "gdk_quartz_drag_context_get_dragging_info_libgtk_only", libgdk.}

template typeQuartzKeymap*(): expr =
  (quartzKeymapGetType())

template quartzKeymap*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeQuartzKeymap, QuartzKeymapObj))

template quartzKeymapClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeQuartzKeymap, QuartzKeymapClass))

template isQuartzKeymap*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeQuartzKeymap))

template isQuartzKeymapClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeQuartzKeymap))

template quartzKeymapGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeQuartzKeymap, QuartzKeymapClass))

type
  QuartzKeymap* =  ptr QuartzKeymapObj
  QuartzKeymapPtr* = ptr QuartzKeymapObj
  QuartzKeymapObj* = KeymapObj

proc keymapGetType*(): GType {.importc: "gdk_quartz_keymap_get_type",
                                     libgdk.}

template typeQuartzScreen*(): expr =
  (quartzScreenGetType())

template quartzScreen*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeQuartzScreen, QuartzScreenObj))

template quartzScreenClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeQuartzScreen, QuartzScreenClass))

template isQuartzScreen*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeQuartzScreen))

template isQuartzScreenClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeQuartzScreen))

template quartzScreenGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeQuartzScreen, QuartzScreenClass))

type
  QuartzScreen* =  ptr QuartzScreenObj
  QuartzScreenPtr* = ptr QuartzScreenObj
  QuartzScreenObj* = ScreenObj

proc screenGetType*(): GType {.importc: "gdk_quartz_screen_get_type",
                                     libgdk.}

proc pixbufToNsImageLibgtkOnly*(pixbuf: GdkPixbuf): ptr NSImage {.
    importc: "gdk_quartz_pixbuf_to_ns_image_libgtk_only", libgdk.}
proc getNsevent*(event: Event): ptr NSEvent {.
    importc: "gdk_quartz_event_get_nsevent", libgdk.}
proc getKeyEquivalent*(key: cuint): Gunichar {.
    importc: "gdk_quartz_get_key_equivalent", libgdk.}

template typeQuartzVisual*(): expr =
  (quartzVisualGetType())

template quartzVisual*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeQuartzVisual, QuartzVisualObj))

template quartzVisualClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeQuartzVisual, QuartzVisualClass))

template isQuartzVisual*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeQuartzVisual))

template isQuartzVisualClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeQuartzVisual))

template quartzVisualGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeQuartzVisual, QuartzVisualClass))

type
  QuartzVisual* =  ptr QuartzVisualObj
  QuartzVisualPtr* = ptr QuartzVisualObj
  QuartzVisualObj* = VisualObj

proc visualGetType*(): GType {.importc: "gdk_quartz_visual_get_type",
                                     libgdk.}

template typeQuartzWindow*(): expr =
  (quartzWindowGetType())

template quartzWindow*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeQuartzWindow, QuartzWindowObj))

template quartzWindowClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeQuartzWindow, QuartzWindowClass))

template isQuartzWindow*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeQuartzWindow))

template isQuartzWindowClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeQuartzWindow))

template quartzWindowGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeQuartzWindow, QuartzWindowClass))

type
  QuartzWindow* =  ptr QuartzWindowObj
  QuartzWindowPtr* = ptr QuartzWindowObj
  QuartzWindowObj* = WindowObj

proc windowGetType*(): GType {.importc: "gdk_quartz_window_get_type",
                                     libgdk.}
proc getNswindow*(window: Window): ptr NSWindow {.
    importc: "gdk_quartz_window_get_nswindow", libgdk.}
proc getNsview*(window: Window): ptr NSView {.
    importc: "gdk_quartz_window_get_nsview", libgdk.}
