
#ifdef C2NIM
#  dynlib lib
#endif

#def G_DEFINE_AUTOPTR_CLEANUP_FUNC(i, j)
#def G_GNUC_PRINTF(i,j)
#def G_GNUC_NULL_TERMINATED
#def G_GNUC_CONST
#def G_GNUC_MALLOC
#def GDK_DEPRECATED_IN_3_0_FOR(x)
#def GDK_DEPRECATED_IN_3_0
#def G_DEPRECATED
#def G_GNUC_DEPRECATED
#def GDK_DEPRECATED
#def GDK_AVAILABLE_IN_ALL
#def G_END_DECLS
#def G_BEGIN_DECLS
#def GDK_AVAILABLE_IN_3_20
#def GDK_DEPRECATED_IN_3_20
#def GDK_DEPRECATED_IN_3_20_FOR(x)
#def GDK_AVAILABLE_IN_3_18
#def GDK_DEPRECATED_IN_3_18
#def GDK_DEPRECATED_IN_3_18_FOR(x)
#def GDK_AVAILABLE_IN_3_16
#def GDK_DEPRECATED_IN_3_16
#def GDK_DEPRECATED_IN_3_16_FOR(x)
#def GDK_AVAILABLE_IN_3_14
#def GDK_DEPRECATED_IN_3_14
#def GDK_DEPRECATED_IN_3_14_FOR(x)
#def GDK_AVAILABLE_IN_3_12
#def GDK_DEPRECATED_IN_3_12
#def GDK_DEPRECATED_IN_3_12_FOR(x)
#def GDK_AVAILABLE_IN_3_10
#def GDK_DEPRECATED_IN_3_10
#def GDK_DEPRECATED_IN_3_10_FOR(x)
#def GDK_AVAILABLE_IN_3_8
#def GDK_DEPRECATED_IN_3_8
#def GDK_DEPRECATED_IN_3_8_FOR(x)
#def GDK_AVAILABLE_IN_3_6
#def GDK_DEPRECATED_IN_3_6
#def GDK_DEPRECATED_IN_3_6_FOR(x)
#def GDK_AVAILABLE_IN_3_4
#def GDK_DEPRECATED_IN_3_4
#def GDK_DEPRECATED_IN_3_4_FOR(x)
#def GDK_AVAILABLE_IN_3_2
#def GDK_DEPRECATED_IN_3_2
#def GDK_DEPRECATED_IN_3_2_FOR(x)
#define headerfilename "gtk/./gtkenums.h"
/* file: gtk/./gtkenums.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_ENUMS_H__
#define __GTK_ENUMS_H__



#include <glib-object.h>


/**
 * SECTION:gtkenums
 * @Short_description: Public enumerated types used throughout GTK+
 * @Title: Standard Enumerations
 */


G_BEGIN_DECLS

/**
 * GtkAlign:
 * @GTK_ALIGN_FILL: stretch to fill all space if possible, center if
 *     no meaningful way to stretch
 * @GTK_ALIGN_START: snap to left or top side, leaving space on right
 *     or bottom
 * @GTK_ALIGN_END: snap to right or bottom side, leaving space on left
 *     or top
 * @GTK_ALIGN_CENTER: center natural width of widget inside the
 *     allocation
 * @GTK_ALIGN_BASELINE: align the widget according to the baseline. Since 3.10.
 *
 * Controls how a widget deals with extra space in a single (x or y)
 * dimension.
 *
 * Alignment only matters if the widget receives a “too large” allocation,
 * for example if you packed the widget with the #GtkWidget:expand
 * flag inside a #GtkBox, then the widget might get extra space.  If
 * you have for example a 16x16 icon inside a 32x32 space, the icon
 * could be scaled and stretched, it could be centered, or it could be
 * positioned to one side of the space.
 *
 * Note that in horizontal context @GTK_ALIGN_START and @GTK_ALIGN_END
 * are interpreted relative to text direction.
 *
 * GTK_ALIGN_BASELINE support for it is optional for containers and widgets, and
 * it is only supported for vertical alignment.  When its not supported by
 * a child or a container it is treated as @GTK_ALIGN_FILL.
 */
typedef enum
{
  GTK_ALIGN_FILL,
  GTK_ALIGN_START,
  GTK_ALIGN_END,
  GTK_ALIGN_CENTER,
  GTK_ALIGN_BASELINE
} GtkAlign;

/**
 * GtkArrowType:
 * @GTK_ARROW_UP: Represents an upward pointing arrow.
 * @GTK_ARROW_DOWN: Represents a downward pointing arrow.
 * @GTK_ARROW_LEFT: Represents a left pointing arrow.
 * @GTK_ARROW_RIGHT: Represents a right pointing arrow.
 * @GTK_ARROW_NONE: No arrow. Since 2.10.
 *
 * Used to indicate the direction in which an arrow should point.
 */
typedef enum
{
  GTK_ARROW_UP,
  GTK_ARROW_DOWN,
  GTK_ARROW_LEFT,
  GTK_ARROW_RIGHT,
  GTK_ARROW_NONE
} GtkArrowType;

/**
 * GtkBaselinePosition:
 * @GTK_BASELINE_POSITION_TOP: Align the baseline at the top
 * @GTK_BASELINE_POSITION_CENTER: Center the baseline
 * @GTK_BASELINE_POSITION_BOTTOM: Align the baseline at the bottom
 *
 * Whenever a container has some form of natural row it may align
 * children in that row along a common typographical baseline. If
 * the amount of verical space in the row is taller than the total
 * requested height of the baseline-aligned children then it can use a
 * #GtkBaselinePosition to select where to put the baseline inside the
 * extra availible space.
 *
 * Since: 3.10
 */
typedef enum
{
  GTK_BASELINE_POSITION_TOP,
  GTK_BASELINE_POSITION_CENTER,
  GTK_BASELINE_POSITION_BOTTOM
} GtkBaselinePosition;

/**
 * GtkDeleteType:
 * @GTK_DELETE_CHARS: Delete characters.
 * @GTK_DELETE_WORD_ENDS: Delete only the portion of the word to the
 *   left/right of cursor if we’re in the middle of a word.
 * @GTK_DELETE_WORDS: Delete words.
 * @GTK_DELETE_DISPLAY_LINES: Delete display-lines. Display-lines
 *   refers to the visible lines, with respect to to the current line
 *   breaks. As opposed to paragraphs, which are defined by line
 *   breaks in the input.
 * @GTK_DELETE_DISPLAY_LINE_ENDS: Delete only the portion of the
 *   display-line to the left/right of cursor.
 * @GTK_DELETE_PARAGRAPH_ENDS: Delete to the end of the
 *   paragraph. Like C-k in Emacs (or its reverse).
 * @GTK_DELETE_PARAGRAPHS: Delete entire line. Like C-k in pico.
 * @GTK_DELETE_WHITESPACE: Delete only whitespace. Like M-\ in Emacs.
 *
 * See also: #GtkEntry::delete-from-cursor.
 */
typedef enum
{
  GTK_DELETE_CHARS,
  GTK_DELETE_WORD_ENDS,
  GTK_DELETE_WORDS,
  GTK_DELETE_DISPLAY_LINES,
  GTK_DELETE_DISPLAY_LINE_ENDS,
  GTK_DELETE_PARAGRAPH_ENDS,
  GTK_DELETE_PARAGRAPHS,
  GTK_DELETE_WHITESPACE
} GtkDeleteType;

/* Focus movement types */
/**
 * GtkDirectionType:
 * @GTK_DIR_TAB_FORWARD: Move forward.
 * @GTK_DIR_TAB_BACKWARD: Move backward.
 * @GTK_DIR_UP: Move up.
 * @GTK_DIR_DOWN: Move down.
 * @GTK_DIR_LEFT: Move left.
 * @GTK_DIR_RIGHT: Move right.
 *
 * Focus movement types.
 */
typedef enum
{
  GTK_DIR_TAB_FORWARD,
  GTK_DIR_TAB_BACKWARD,
  GTK_DIR_UP,
  GTK_DIR_DOWN,
  GTK_DIR_LEFT,
  GTK_DIR_RIGHT
} GtkDirectionType;

/**
 * GtkIconSize:
 * @GTK_ICON_SIZE_INVALID: Invalid size.
 * @GTK_ICON_SIZE_MENU: Size appropriate for menus (16px).
 * @GTK_ICON_SIZE_SMALL_TOOLBAR: Size appropriate for small toolbars (16px).
 * @GTK_ICON_SIZE_LARGE_TOOLBAR: Size appropriate for large toolbars (24px)
 * @GTK_ICON_SIZE_BUTTON: Size appropriate for buttons (16px)
 * @GTK_ICON_SIZE_DND: Size appropriate for drag and drop (32px)
 * @GTK_ICON_SIZE_DIALOG: Size appropriate for dialogs (48px)
 *
 * Built-in stock icon sizes.
 */
typedef enum
{
  GTK_ICON_SIZE_INVALID,
  GTK_ICON_SIZE_MENU,
  GTK_ICON_SIZE_SMALL_TOOLBAR,
  GTK_ICON_SIZE_LARGE_TOOLBAR,
  GTK_ICON_SIZE_BUTTON,
  GTK_ICON_SIZE_DND,
  GTK_ICON_SIZE_DIALOG
} GtkIconSize;

/**
 * GtkSensitivityType:
 * @GTK_SENSITIVITY_AUTO: The arrow is made insensitive if the
 *   thumb is at the end
 * @GTK_SENSITIVITY_ON: The arrow is always sensitive
 * @GTK_SENSITIVITY_OFF: The arrow is always insensitive
 *
 * Determines how GTK+ handles the sensitivity of stepper arrows
 * at the end of range widgets.
 */
typedef enum
{
  GTK_SENSITIVITY_AUTO,
  GTK_SENSITIVITY_ON,
  GTK_SENSITIVITY_OFF
} GtkSensitivityType;

/* Reading directions for text */
/**
 * GtkTextDirection:
 * @GTK_TEXT_DIR_NONE: No direction.
 * @GTK_TEXT_DIR_LTR: Left to right text direction.
 * @GTK_TEXT_DIR_RTL: Right to left text direction.
 *
 * Reading directions for text.
 */
typedef enum
{
  GTK_TEXT_DIR_NONE,
  GTK_TEXT_DIR_LTR,
  GTK_TEXT_DIR_RTL
} GtkTextDirection;

/**
 * GtkJustification:
 * @GTK_JUSTIFY_LEFT: The text is placed at the left edge of the label.
 * @GTK_JUSTIFY_RIGHT: The text is placed at the right edge of the label.
 * @GTK_JUSTIFY_CENTER: The text is placed in the center of the label.
 * @GTK_JUSTIFY_FILL: The text is placed is distributed across the label.
 *
 * Used for justifying the text inside a #GtkLabel widget. (See also
 * #GtkAlignment).
 */
typedef enum
{
  GTK_JUSTIFY_LEFT,
  GTK_JUSTIFY_RIGHT,
  GTK_JUSTIFY_CENTER,
  GTK_JUSTIFY_FILL
} GtkJustification;

/**
 * GtkMenuDirectionType:
 * @GTK_MENU_DIR_PARENT: To the parent menu shell
 * @GTK_MENU_DIR_CHILD: To the submenu, if any, associated with the item
 * @GTK_MENU_DIR_NEXT: To the next menu item
 * @GTK_MENU_DIR_PREV: To the previous menu item
 *
 * An enumeration representing directional movements within a menu.
 */
typedef enum
{
  GTK_MENU_DIR_PARENT,
  GTK_MENU_DIR_CHILD,
  GTK_MENU_DIR_NEXT,
  GTK_MENU_DIR_PREV
} GtkMenuDirectionType;

/**
 * GtkMessageType:
 * @GTK_MESSAGE_INFO: Informational message
 * @GTK_MESSAGE_WARNING: Non-fatal warning message
 * @GTK_MESSAGE_QUESTION: Question requiring a choice
 * @GTK_MESSAGE_ERROR: Fatal error message
 * @GTK_MESSAGE_OTHER: None of the above
 *
 * The type of message being displayed in the dialog.
 */
typedef enum
{
  GTK_MESSAGE_INFO,
  GTK_MESSAGE_WARNING,
  GTK_MESSAGE_QUESTION,
  GTK_MESSAGE_ERROR,
  GTK_MESSAGE_OTHER
} GtkMessageType;

/**
 * GtkMovementStep:
 * @GTK_MOVEMENT_LOGICAL_POSITIONS: Move forward or back by graphemes
 * @GTK_MOVEMENT_VISUAL_POSITIONS:  Move left or right by graphemes
 * @GTK_MOVEMENT_WORDS:             Move forward or back by words
 * @GTK_MOVEMENT_DISPLAY_LINES:     Move up or down lines (wrapped lines)
 * @GTK_MOVEMENT_DISPLAY_LINE_ENDS: Move to either end of a line
 * @GTK_MOVEMENT_PARAGRAPHS:        Move up or down paragraphs (newline-ended lines)
 * @GTK_MOVEMENT_PARAGRAPH_ENDS:    Move to either end of a paragraph
 * @GTK_MOVEMENT_PAGES:             Move by pages
 * @GTK_MOVEMENT_BUFFER_ENDS:       Move to ends of the buffer
 * @GTK_MOVEMENT_HORIZONTAL_PAGES:  Move horizontally by pages
 */
typedef enum
{
  GTK_MOVEMENT_LOGICAL_POSITIONS,
  GTK_MOVEMENT_VISUAL_POSITIONS,
  GTK_MOVEMENT_WORDS,
  GTK_MOVEMENT_DISPLAY_LINES,
  GTK_MOVEMENT_DISPLAY_LINE_ENDS,
  GTK_MOVEMENT_PARAGRAPHS,
  GTK_MOVEMENT_PARAGRAPH_ENDS,
  GTK_MOVEMENT_PAGES,
  GTK_MOVEMENT_BUFFER_ENDS,
  GTK_MOVEMENT_HORIZONTAL_PAGES
} GtkMovementStep;

/**
 * GtkScrollStep:
 * @GTK_SCROLL_STEPS: Scroll in steps.
 * @GTK_SCROLL_PAGES: Scroll by pages.
 * @GTK_SCROLL_ENDS: Scroll to ends.
 * @GTK_SCROLL_HORIZONTAL_STEPS: Scroll in horizontal steps.
 * @GTK_SCROLL_HORIZONTAL_PAGES: Scroll by horizontal pages.
 * @GTK_SCROLL_HORIZONTAL_ENDS: Scroll to the horizontal ends.
 */
typedef enum
{
  GTK_SCROLL_STEPS,
  GTK_SCROLL_PAGES,
  GTK_SCROLL_ENDS,
  GTK_SCROLL_HORIZONTAL_STEPS,
  GTK_SCROLL_HORIZONTAL_PAGES,
  GTK_SCROLL_HORIZONTAL_ENDS
} GtkScrollStep;

/**
 * GtkOrientation:
 * @GTK_ORIENTATION_HORIZONTAL: The element is in horizontal orientation.
 * @GTK_ORIENTATION_VERTICAL: The element is in vertical orientation.
 *
 * Represents the orientation of widgets and other objects which can be switched
 * between horizontal and vertical orientation on the fly, like #GtkToolbar or
 * #GtkGesturePan.
 */
typedef enum
{
  GTK_ORIENTATION_HORIZONTAL,
  GTK_ORIENTATION_VERTICAL
} GtkOrientation;

/**
 * GtkPackType:
 * @GTK_PACK_START: The child is packed into the start of the box
 * @GTK_PACK_END: The child is packed into the end of the box
 *
 * Represents the packing location #GtkBox children. (See: #GtkVBox,
 * #GtkHBox, and #GtkButtonBox).
 */
typedef enum
{
  GTK_PACK_START,
  GTK_PACK_END
} GtkPackType;

/**
 * GtkPositionType:
 * @GTK_POS_LEFT: The feature is at the left edge.
 * @GTK_POS_RIGHT: The feature is at the right edge.
 * @GTK_POS_TOP: The feature is at the top edge.
 * @GTK_POS_BOTTOM: The feature is at the bottom edge.
 *
 * Describes which edge of a widget a certain feature is positioned at, e.g. the
 * tabs of a #GtkNotebook, the handle of a #GtkHandleBox or the label of a
 * #GtkScale.
 */
typedef enum
{
  GTK_POS_LEFT,
  GTK_POS_RIGHT,
  GTK_POS_TOP,
  GTK_POS_BOTTOM
} GtkPositionType;

/**
 * GtkReliefStyle:
 * @GTK_RELIEF_NORMAL: Draw a normal relief.
 * @GTK_RELIEF_HALF: A half relief. Deprecated in 3.14, does the same as @GTK_RELIEF_NORMAL
 * @GTK_RELIEF_NONE: No relief.
 *
 * Indicated the relief to be drawn around a #GtkButton.
 */
typedef enum
{
  GTK_RELIEF_NORMAL,
  GTK_RELIEF_HALF,
  GTK_RELIEF_NONE
} GtkReliefStyle;

/**
 * GtkScrollType:
 * @GTK_SCROLL_NONE: No scrolling.
 * @GTK_SCROLL_JUMP: Jump to new location.
 * @GTK_SCROLL_STEP_BACKWARD: Step backward.
 * @GTK_SCROLL_STEP_FORWARD: Step forward.
 * @GTK_SCROLL_PAGE_BACKWARD: Page backward.
 * @GTK_SCROLL_PAGE_FORWARD: Page forward.
 * @GTK_SCROLL_STEP_UP: Step up.
 * @GTK_SCROLL_STEP_DOWN: Step down.
 * @GTK_SCROLL_PAGE_UP: Page up.
 * @GTK_SCROLL_PAGE_DOWN: Page down.
 * @GTK_SCROLL_STEP_LEFT: Step to the left.
 * @GTK_SCROLL_STEP_RIGHT: Step to the right.
 * @GTK_SCROLL_PAGE_LEFT: Page to the left.
 * @GTK_SCROLL_PAGE_RIGHT: Page to the right.
 * @GTK_SCROLL_START: Scroll to start.
 * @GTK_SCROLL_END: Scroll to end.
 *
 * Scrolling types.
 */
typedef enum
{
  GTK_SCROLL_NONE,
  GTK_SCROLL_JUMP,
  GTK_SCROLL_STEP_BACKWARD,
  GTK_SCROLL_STEP_FORWARD,
  GTK_SCROLL_PAGE_BACKWARD,
  GTK_SCROLL_PAGE_FORWARD,
  GTK_SCROLL_STEP_UP,
  GTK_SCROLL_STEP_DOWN,
  GTK_SCROLL_PAGE_UP,
  GTK_SCROLL_PAGE_DOWN,
  GTK_SCROLL_STEP_LEFT,
  GTK_SCROLL_STEP_RIGHT,
  GTK_SCROLL_PAGE_LEFT,
  GTK_SCROLL_PAGE_RIGHT,
  GTK_SCROLL_START,
  GTK_SCROLL_END
} GtkScrollType;

/**
 * GtkSelectionMode:
 * @GTK_SELECTION_NONE: No selection is possible.
 * @GTK_SELECTION_SINGLE: Zero or one element may be selected.
 * @GTK_SELECTION_BROWSE: Exactly one element is selected.
 *     In some circumstances, such as initially or during a search
 *     operation, it’s possible for no element to be selected with
 *     %GTK_SELECTION_BROWSE. What is really enforced is that the user
 *     can’t deselect a currently selected element except by selecting
 *     another element.
 * @GTK_SELECTION_MULTIPLE: Any number of elements may be selected.
 *      The Ctrl key may be used to enlarge the selection, and Shift
 *      key to select between the focus and the child pointed to.
 *      Some widgets may also allow Click-drag to select a range of elements.
 *
 * Used to control what selections users are allowed to make.
 */
typedef enum
{
  GTK_SELECTION_NONE,
  GTK_SELECTION_SINGLE,
  GTK_SELECTION_BROWSE,
  GTK_SELECTION_MULTIPLE
} GtkSelectionMode;

/**
 * GtkShadowType:
 * @GTK_SHADOW_NONE: No outline.
 * @GTK_SHADOW_IN: The outline is bevelled inwards.
 * @GTK_SHADOW_OUT: The outline is bevelled outwards like a button.
 * @GTK_SHADOW_ETCHED_IN: The outline has a sunken 3d appearance.
 * @GTK_SHADOW_ETCHED_OUT: The outline has a raised 3d appearance.
 *
 * Used to change the appearance of an outline typically provided by a #GtkFrame.
 *
 * Note that many themes do not differentiate the appearance of the
 * various shadow types: Either their is no visible shadow (@GTK_SHADOW_NONE),
 * or there is (any other value).
 */
typedef enum
{
  GTK_SHADOW_NONE,
  GTK_SHADOW_IN,
  GTK_SHADOW_OUT,
  GTK_SHADOW_ETCHED_IN,
  GTK_SHADOW_ETCHED_OUT
} GtkShadowType;

/* Widget states */

/**
 * GtkStateType:
 * @GTK_STATE_NORMAL: State during normal operation.
 * @GTK_STATE_ACTIVE: State of a currently active widget, such as a depressed button.
 * @GTK_STATE_PRELIGHT: State indicating that the mouse pointer is over
 *                      the widget and the widget will respond to mouse clicks.
 * @GTK_STATE_SELECTED: State of a selected item, such the selected row in a list.
 * @GTK_STATE_INSENSITIVE: State indicating that the widget is
 *                         unresponsive to user actions.
 * @GTK_STATE_INCONSISTENT: The widget is inconsistent, such as checkbuttons
 *                          or radiobuttons that aren’t either set to %TRUE nor %FALSE,
 *                          or buttons requiring the user attention.
 * @GTK_STATE_FOCUSED: The widget has the keyboard focus.
 *
 * This type indicates the current state of a widget; the state determines how
 * the widget is drawn. The #GtkStateType enumeration is also used to
 * identify different colors in a #GtkStyle for drawing, so states can be
 * used for subparts of a widget as well as entire widgets.
 *
 * Deprecated: 3.14: All APIs that are using this enumeration have been deprecated
 *     in favor of alternatives using #GtkStateFlags.
 */
typedef enum
{
  GTK_STATE_NORMAL,
  GTK_STATE_ACTIVE,
  GTK_STATE_PRELIGHT,
  GTK_STATE_SELECTED,
  GTK_STATE_INSENSITIVE,
  GTK_STATE_INCONSISTENT,
  GTK_STATE_FOCUSED
} GtkStateType;

/**
 * GtkToolbarStyle:
 * @GTK_TOOLBAR_ICONS: Buttons display only icons in the toolbar.
 * @GTK_TOOLBAR_TEXT: Buttons display only text labels in the toolbar.
 * @GTK_TOOLBAR_BOTH: Buttons display text and icons in the toolbar.
 * @GTK_TOOLBAR_BOTH_HORIZ: Buttons display icons and text alongside each
 *  other, rather than vertically stacked
 *
 * Used to customize the appearance of a #GtkToolbar. Note that
 * setting the toolbar style overrides the user’s preferences
 * for the default toolbar style.  Note that if the button has only
 * a label set and GTK_TOOLBAR_ICONS is used, the label will be
 * visible, and vice versa.
 */
typedef enum
{
  GTK_TOOLBAR_ICONS,
  GTK_TOOLBAR_TEXT,
  GTK_TOOLBAR_BOTH,
  GTK_TOOLBAR_BOTH_HORIZ
} GtkToolbarStyle;

/**
 * GtkWrapMode:
 * @GTK_WRAP_NONE: do not wrap lines; just make the text area wider
 * @GTK_WRAP_CHAR: wrap text, breaking lines anywhere the cursor can
 *     appear (between characters, usually - if you want to be technical,
 *     between graphemes, see pango_get_log_attrs())
 * @GTK_WRAP_WORD: wrap text, breaking lines in between words
 * @GTK_WRAP_WORD_CHAR: wrap text, breaking lines in between words, or if
 *     that is not enough, also between graphemes
 *
 * Describes a type of line wrapping.
 */
typedef enum
{
  GTK_WRAP_NONE,
  GTK_WRAP_CHAR,
  GTK_WRAP_WORD,
  GTK_WRAP_WORD_CHAR
} GtkWrapMode;

/**
 * GtkSortType:
 * @GTK_SORT_ASCENDING: Sorting is in ascending order.
 * @GTK_SORT_DESCENDING: Sorting is in descending order.
 *
 * Determines the direction of a sort.
 */
typedef enum
{
  GTK_SORT_ASCENDING,
  GTK_SORT_DESCENDING
} GtkSortType;

/* Style for gtk input method preedit/status */
/**
 * GtkIMPreeditStyle:
 * @GTK_IM_PREEDIT_NOTHING: Deprecated
 * @GTK_IM_PREEDIT_CALLBACK: Deprecated
 * @GTK_IM_PREEDIT_NONE: Deprecated
 *
 * Style for input method preedit. See also
 * #GtkSettings:gtk-im-preedit-style
 *
 * Deprecated: 3.10
 */
typedef enum
{
  GTK_IM_PREEDIT_NOTHING,
  GTK_IM_PREEDIT_CALLBACK,
  GTK_IM_PREEDIT_NONE
} GtkIMPreeditStyle;

/**
 * GtkIMStatusStyle:
 * @GTK_IM_STATUS_NOTHING: Deprecated
 * @GTK_IM_STATUS_CALLBACK: Deprecated
 * @GTK_IM_STATUS_NONE: Deprecated
 *
 * Style for input method status. See also
 * #GtkSettings:gtk-im-status-style
 *
 * Deprecated: 3.10
 */
typedef enum
{
  GTK_IM_STATUS_NOTHING,
  GTK_IM_STATUS_CALLBACK,
  GTK_IM_STATUS_NONE
} GtkIMStatusStyle;

/**
 * GtkPackDirection:
 * @GTK_PACK_DIRECTION_LTR: Widgets are packed left-to-right
 * @GTK_PACK_DIRECTION_RTL: Widgets are packed right-to-left
 * @GTK_PACK_DIRECTION_TTB: Widgets are packed top-to-bottom
 * @GTK_PACK_DIRECTION_BTT: Widgets are packed bottom-to-top
 *
 * Determines how widgets should be packed inside menubars
 * and menuitems contained in menubars.
 */
typedef enum
{
  GTK_PACK_DIRECTION_LTR,
  GTK_PACK_DIRECTION_RTL,
  GTK_PACK_DIRECTION_TTB,
  GTK_PACK_DIRECTION_BTT
} GtkPackDirection;

/**
 * GtkPrintPages:
 * @GTK_PRINT_PAGES_ALL: All pages.
 * @GTK_PRINT_PAGES_CURRENT: Current page.
 * @GTK_PRINT_PAGES_RANGES: Range of pages.
 * @GTK_PRINT_PAGES_SELECTION: Selected pages.
 *
 * See also gtk_print_job_set_pages()
 */
typedef enum
{
  GTK_PRINT_PAGES_ALL,
  GTK_PRINT_PAGES_CURRENT,
  GTK_PRINT_PAGES_RANGES,
  GTK_PRINT_PAGES_SELECTION
} GtkPrintPages;

/**
 * GtkPageSet:
 * @GTK_PAGE_SET_ALL: All pages.
 * @GTK_PAGE_SET_EVEN: Even pages.
 * @GTK_PAGE_SET_ODD: Odd pages.
 *
 * See also gtk_print_job_set_page_set().
 */
typedef enum
{
  GTK_PAGE_SET_ALL,
  GTK_PAGE_SET_EVEN,
  GTK_PAGE_SET_ODD
} GtkPageSet;

/**
 * GtkNumberUpLayout:
 * @GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_TOP_TO_BOTTOM: ![](layout-lrtb.png)
 * @GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_BOTTOM_TO_TOP: ![](layout-lrbt.png)
 * @GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_TOP_TO_BOTTOM: ![](layout-rltb.png)
 * @GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_BOTTOM_TO_TOP: ![](layout-rlbt.png)
 * @GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_LEFT_TO_RIGHT: ![](layout-tblr.png)
 * @GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_RIGHT_TO_LEFT: ![](layout-tbrl.png)
 * @GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_LEFT_TO_RIGHT: ![](layout-btlr.png)
 * @GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_RIGHT_TO_LEFT: ![](layout-btrl.png)
 *
 * Used to determine the layout of pages on a sheet when printing
 * multiple pages per sheet.
 */
typedef enum
{
  GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_TOP_TO_BOTTOM, /*< nick=lrtb >*/
  GTK_NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_BOTTOM_TO_TOP, /*< nick=lrbt >*/
  GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_TOP_TO_BOTTOM, /*< nick=rltb >*/
  GTK_NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_BOTTOM_TO_TOP, /*< nick=rlbt >*/
  GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_LEFT_TO_RIGHT, /*< nick=tblr >*/
  GTK_NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_RIGHT_TO_LEFT, /*< nick=tbrl >*/
  GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_LEFT_TO_RIGHT, /*< nick=btlr >*/
  GTK_NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_RIGHT_TO_LEFT  /*< nick=btrl >*/
} GtkNumberUpLayout;

/**
 * GtkPageOrientation:
 * @GTK_PAGE_ORIENTATION_PORTRAIT: Portrait mode.
 * @GTK_PAGE_ORIENTATION_LANDSCAPE: Landscape mode.
 * @GTK_PAGE_ORIENTATION_REVERSE_PORTRAIT: Reverse portrait mode.
 * @GTK_PAGE_ORIENTATION_REVERSE_LANDSCAPE: Reverse landscape mode.
 *
 * See also gtk_print_settings_set_orientation().
 */
typedef enum
{
  GTK_PAGE_ORIENTATION_PORTRAIT,
  GTK_PAGE_ORIENTATION_LANDSCAPE,
  GTK_PAGE_ORIENTATION_REVERSE_PORTRAIT,
  GTK_PAGE_ORIENTATION_REVERSE_LANDSCAPE
} GtkPageOrientation;

/**
 * GtkPrintQuality:
 * @GTK_PRINT_QUALITY_LOW: Low quality.
 * @GTK_PRINT_QUALITY_NORMAL: Normal quality.
 * @GTK_PRINT_QUALITY_HIGH: High quality.
 * @GTK_PRINT_QUALITY_DRAFT: Draft quality.
 *
 * See also gtk_print_settings_set_quality().
 */
typedef enum
{
  GTK_PRINT_QUALITY_LOW,
  GTK_PRINT_QUALITY_NORMAL,
  GTK_PRINT_QUALITY_HIGH,
  GTK_PRINT_QUALITY_DRAFT
} GtkPrintQuality;

/**
 * GtkPrintDuplex:
 * @GTK_PRINT_DUPLEX_SIMPLEX: No duplex.
 * @GTK_PRINT_DUPLEX_HORIZONTAL: Horizontal duplex.
 * @GTK_PRINT_DUPLEX_VERTICAL: Vertical duplex.
 *
 * See also gtk_print_settings_set_duplex().
 */
typedef enum
{
  GTK_PRINT_DUPLEX_SIMPLEX,
  GTK_PRINT_DUPLEX_HORIZONTAL,
  GTK_PRINT_DUPLEX_VERTICAL
} GtkPrintDuplex;


/**
 * GtkUnit:
 * @GTK_UNIT_NONE: No units.
 * @GTK_UNIT_POINTS: Dimensions in points.
 * @GTK_UNIT_INCH: Dimensions in inches.
 * @GTK_UNIT_MM: Dimensions in millimeters
 *
 * See also gtk_print_settings_set_paper_width().
 */
typedef enum
{
  GTK_UNIT_NONE,
  GTK_UNIT_POINTS,
  GTK_UNIT_INCH,
  GTK_UNIT_MM
} GtkUnit;

#define GTK_UNIT_PIXEL GTK_UNIT_NONE

/**
 * GtkTreeViewGridLines:
 * @GTK_TREE_VIEW_GRID_LINES_NONE: No grid lines.
 * @GTK_TREE_VIEW_GRID_LINES_HORIZONTAL: Horizontal grid lines.
 * @GTK_TREE_VIEW_GRID_LINES_VERTICAL: Vertical grid lines.
 * @GTK_TREE_VIEW_GRID_LINES_BOTH: Horizontal and vertical grid lines.
 *
 * Used to indicate which grid lines to draw in a tree view.
 */
typedef enum
{
  GTK_TREE_VIEW_GRID_LINES_NONE,
  GTK_TREE_VIEW_GRID_LINES_HORIZONTAL,
  GTK_TREE_VIEW_GRID_LINES_VERTICAL,
  GTK_TREE_VIEW_GRID_LINES_BOTH
} GtkTreeViewGridLines;

/**
 * GtkDragResult:
 * @GTK_DRAG_RESULT_SUCCESS: The drag operation was successful.
 * @GTK_DRAG_RESULT_NO_TARGET: No suitable drag target.
 * @GTK_DRAG_RESULT_USER_CANCELLED: The user cancelled the drag operation.
 * @GTK_DRAG_RESULT_TIMEOUT_EXPIRED: The drag operation timed out.
 * @GTK_DRAG_RESULT_GRAB_BROKEN: The pointer or keyboard grab used
 *  for the drag operation was broken.
 * @GTK_DRAG_RESULT_ERROR: The drag operation failed due to some
 *  unspecified error.
 *
 * Gives an indication why a drag operation failed.
 * The value can by obtained by connecting to the
 * #GtkWidget::drag-failed signal.
 */
typedef enum
{
  GTK_DRAG_RESULT_SUCCESS,
  GTK_DRAG_RESULT_NO_TARGET,
  GTK_DRAG_RESULT_USER_CANCELLED,
  GTK_DRAG_RESULT_TIMEOUT_EXPIRED,
  GTK_DRAG_RESULT_GRAB_BROKEN,
  GTK_DRAG_RESULT_ERROR
} GtkDragResult;

/**
 * GtkSizeGroupMode:
 * @GTK_SIZE_GROUP_NONE: group has no effect
 * @GTK_SIZE_GROUP_HORIZONTAL: group affects horizontal requisition
 * @GTK_SIZE_GROUP_VERTICAL: group affects vertical requisition
 * @GTK_SIZE_GROUP_BOTH: group affects both horizontal and vertical requisition
 *
 * The mode of the size group determines the directions in which the size
 * group affects the requested sizes of its component widgets.
 **/
typedef enum {
  GTK_SIZE_GROUP_NONE,
  GTK_SIZE_GROUP_HORIZONTAL,
  GTK_SIZE_GROUP_VERTICAL,
  GTK_SIZE_GROUP_BOTH
} GtkSizeGroupMode;

/**
 * GtkSizeRequestMode:
 * @GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH: Prefer height-for-width geometry management
 * @GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT: Prefer width-for-height geometry management
 * @GTK_SIZE_REQUEST_CONSTANT_SIZE: Don’t trade height-for-width or width-for-height
 * 
 * Specifies a preference for height-for-width or
 * width-for-height geometry management.
 */
typedef enum
{
  GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH = 0,
  GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT,
  GTK_SIZE_REQUEST_CONSTANT_SIZE
} GtkSizeRequestMode;

/**
 * GtkScrollablePolicy:
 * @GTK_SCROLL_MINIMUM: Scrollable adjustments are based on the minimum size
 * @GTK_SCROLL_NATURAL: Scrollable adjustments are based on the natural size
 *
 * Defines the policy to be used in a scrollable widget when updating
 * the scrolled window adjustments in a given orientation.
 */
typedef enum
{
  GTK_SCROLL_MINIMUM = 0,
  GTK_SCROLL_NATURAL
} GtkScrollablePolicy;

/**
 * GtkStateFlags:
 * @GTK_STATE_FLAG_NORMAL: State during normal operation.
 * @GTK_STATE_FLAG_ACTIVE: Widget is active.
 * @GTK_STATE_FLAG_PRELIGHT: Widget has a mouse pointer over it.
 * @GTK_STATE_FLAG_SELECTED: Widget is selected.
 * @GTK_STATE_FLAG_INSENSITIVE: Widget is insensitive.
 * @GTK_STATE_FLAG_INCONSISTENT: Widget is inconsistent.
 * @GTK_STATE_FLAG_FOCUSED: Widget has the keyboard focus.
 * @GTK_STATE_FLAG_BACKDROP: Widget is in a background toplevel window.
 * @GTK_STATE_FLAG_DIR_LTR: Widget is in left-to-right text direction. Since 3.8
 * @GTK_STATE_FLAG_DIR_RTL: Widget is in right-to-left text direction. Since 3.8
 * @GTK_STATE_FLAG_LINK: Widget is a link. Since 3.12
 * @GTK_STATE_FLAG_VISITED: The location the widget points to has already been visited. Since 3.12
 * @GTK_STATE_FLAG_CHECKED: Widget is checked. Since 3.14
 * @GTK_STATE_FLAG_DROP_ACTIVE: Widget is highlighted as a drop target for DND. Since 3.20
 *
 * Describes a widget state. Widget states are used to match the widget
 * against CSS pseudo-classes. Note that GTK extends the regular CSS
 * classes and sometimes uses different names.
 */
typedef enum
{
  GTK_STATE_FLAG_NORMAL       = 0,
  GTK_STATE_FLAG_ACTIVE       = 1 << 0,
  GTK_STATE_FLAG_PRELIGHT     = 1 << 1,
  GTK_STATE_FLAG_SELECTED     = 1 << 2,
  GTK_STATE_FLAG_INSENSITIVE  = 1 << 3,
  GTK_STATE_FLAG_INCONSISTENT = 1 << 4,
  GTK_STATE_FLAG_FOCUSED      = 1 << 5,
  GTK_STATE_FLAG_BACKDROP     = 1 << 6,
  GTK_STATE_FLAG_DIR_LTR      = 1 << 7,
  GTK_STATE_FLAG_DIR_RTL      = 1 << 8,
  GTK_STATE_FLAG_LINK         = 1 << 9,
  GTK_STATE_FLAG_VISITED      = 1 << 10,
  GTK_STATE_FLAG_CHECKED      = 1 << 11,
  GTK_STATE_FLAG_DROP_ACTIVE  = 1 << 12
} GtkStateFlags;

/**
 * GtkRegionFlags:
 * @GTK_REGION_EVEN: Region has an even number within a set.
 * @GTK_REGION_ODD: Region has an odd number within a set.
 * @GTK_REGION_FIRST: Region is the first one within a set.
 * @GTK_REGION_LAST: Region is the last one within a set.
 * @GTK_REGION_ONLY: Region is the only one within a set.
 * @GTK_REGION_SORTED: Region is part of a sorted area.
 *
 * Describes a region within a widget.
 */
typedef enum {
  GTK_REGION_EVEN    = 1 << 0,
  GTK_REGION_ODD     = 1 << 1,
  GTK_REGION_FIRST   = 1 << 2,
  GTK_REGION_LAST    = 1 << 3,
  GTK_REGION_ONLY    = 1 << 4,
  GTK_REGION_SORTED  = 1 << 5
} GtkRegionFlags;

/**
 * GtkJunctionSides:
 * @GTK_JUNCTION_NONE: No junctions.
 * @GTK_JUNCTION_CORNER_TOPLEFT: Element connects on the top-left corner.
 * @GTK_JUNCTION_CORNER_TOPRIGHT: Element connects on the top-right corner.
 * @GTK_JUNCTION_CORNER_BOTTOMLEFT: Element connects on the bottom-left corner.
 * @GTK_JUNCTION_CORNER_BOTTOMRIGHT: Element connects on the bottom-right corner.
 * @GTK_JUNCTION_TOP: Element connects on the top side.
 * @GTK_JUNCTION_BOTTOM: Element connects on the bottom side.
 * @GTK_JUNCTION_LEFT: Element connects on the left side.
 * @GTK_JUNCTION_RIGHT: Element connects on the right side.
 *
 * Describes how a rendered element connects to adjacent elements.
 */
typedef enum {
  GTK_JUNCTION_NONE   = 0,
  GTK_JUNCTION_CORNER_TOPLEFT = 1 << 0,
  GTK_JUNCTION_CORNER_TOPRIGHT = 1 << 1,
  GTK_JUNCTION_CORNER_BOTTOMLEFT = 1 << 2,
  GTK_JUNCTION_CORNER_BOTTOMRIGHT = 1 << 3,
  GTK_JUNCTION_TOP    = (GTK_JUNCTION_CORNER_TOPLEFT | GTK_JUNCTION_CORNER_TOPRIGHT),
  GTK_JUNCTION_BOTTOM = (GTK_JUNCTION_CORNER_BOTTOMLEFT | GTK_JUNCTION_CORNER_BOTTOMRIGHT),
  GTK_JUNCTION_LEFT   = (GTK_JUNCTION_CORNER_TOPLEFT | GTK_JUNCTION_CORNER_BOTTOMLEFT),
  GTK_JUNCTION_RIGHT  = (GTK_JUNCTION_CORNER_TOPRIGHT | GTK_JUNCTION_CORNER_BOTTOMRIGHT)
} GtkJunctionSides;

/**
 * GtkBorderStyle:
 * @GTK_BORDER_STYLE_NONE: No visible border
 * @GTK_BORDER_STYLE_SOLID: A single line segment
 * @GTK_BORDER_STYLE_INSET: Looks as if the content is sunken into the canvas
 * @GTK_BORDER_STYLE_OUTSET: Looks as if the content is coming out of the canvas
 * @GTK_BORDER_STYLE_HIDDEN: Same as @GTK_BORDER_STYLE_NONE
 * @GTK_BORDER_STYLE_DOTTED: A series of round dots
 * @GTK_BORDER_STYLE_DASHED: A series of square-ended dashes
 * @GTK_BORDER_STYLE_DOUBLE: Two parallel lines with some space between them
 * @GTK_BORDER_STYLE_GROOVE: Looks as if it were carved in the canvas
 * @GTK_BORDER_STYLE_RIDGE: Looks as if it were coming out of the canvas
 *
 * Describes how the border of a UI element should be rendered.
 */
typedef enum {
  GTK_BORDER_STYLE_NONE,
  GTK_BORDER_STYLE_SOLID,
  GTK_BORDER_STYLE_INSET,
  GTK_BORDER_STYLE_OUTSET,
  GTK_BORDER_STYLE_HIDDEN,
  GTK_BORDER_STYLE_DOTTED,
  GTK_BORDER_STYLE_DASHED,
  GTK_BORDER_STYLE_DOUBLE,
  GTK_BORDER_STYLE_GROOVE,
  GTK_BORDER_STYLE_RIDGE
} GtkBorderStyle;

/**
 * GtkLevelBarMode:
 * @GTK_LEVEL_BAR_MODE_CONTINUOUS: the bar has a continuous mode
 * @GTK_LEVEL_BAR_MODE_DISCRETE: the bar has a discrete mode
 *
 * Describes how #GtkLevelBar contents should be rendered.
 * Note that this enumeration could be extended with additional modes
 * in the future.
 *
 * Since: 3.6
 */
typedef enum {
  GTK_LEVEL_BAR_MODE_CONTINUOUS,
  GTK_LEVEL_BAR_MODE_DISCRETE
} GtkLevelBarMode;

G_END_DECLS

/**
 * GtkInputPurpose:
 * @GTK_INPUT_PURPOSE_FREE_FORM: Allow any character
 * @GTK_INPUT_PURPOSE_ALPHA: Allow only alphabetic characters
 * @GTK_INPUT_PURPOSE_DIGITS: Allow only digits
 * @GTK_INPUT_PURPOSE_NUMBER: Edited field expects numbers
 * @GTK_INPUT_PURPOSE_PHONE: Edited field expects phone number
 * @GTK_INPUT_PURPOSE_URL: Edited field expects URL
 * @GTK_INPUT_PURPOSE_EMAIL: Edited field expects email address
 * @GTK_INPUT_PURPOSE_NAME: Edited field expects the name of a person
 * @GTK_INPUT_PURPOSE_PASSWORD: Like @GTK_INPUT_PURPOSE_FREE_FORM, but characters are hidden
 * @GTK_INPUT_PURPOSE_PIN: Like @GTK_INPUT_PURPOSE_DIGITS, but characters are hidden
 *
 * Describes primary purpose of the input widget. This information is
 * useful for on-screen keyboards and similar input methods to decide
 * which keys should be presented to the user.
 *
 * Note that the purpose is not meant to impose a totally strict rule
 * about allowed characters, and does not replace input validation.
 * It is fine for an on-screen keyboard to let the user override the
 * character set restriction that is expressed by the purpose. The
 * application is expected to validate the entry contents, even if
 * it specified a purpose.
 *
 * The difference between @GTK_INPUT_PURPOSE_DIGITS and
 * @GTK_INPUT_PURPOSE_NUMBER is that the former accepts only digits
 * while the latter also some punctuation (like commas or points, plus,
 * minus) and “e” or “E” as in 3.14E+000.
 *
 * This enumeration may be extended in the future; input methods should
 * interpret unknown values as “free form”.
 *
 * Since: 3.6
 */
typedef enum
{
  GTK_INPUT_PURPOSE_FREE_FORM,
  GTK_INPUT_PURPOSE_ALPHA,
  GTK_INPUT_PURPOSE_DIGITS,
  GTK_INPUT_PURPOSE_NUMBER,
  GTK_INPUT_PURPOSE_PHONE,
  GTK_INPUT_PURPOSE_URL,
  GTK_INPUT_PURPOSE_EMAIL,
  GTK_INPUT_PURPOSE_NAME,
  GTK_INPUT_PURPOSE_PASSWORD,
  GTK_INPUT_PURPOSE_PIN
} GtkInputPurpose;

/**
 * GtkInputHints:
 * @GTK_INPUT_HINT_NONE: No special behaviour suggested
 * @GTK_INPUT_HINT_SPELLCHECK: Suggest checking for typos
 * @GTK_INPUT_HINT_NO_SPELLCHECK: Suggest not checking for typos
 * @GTK_INPUT_HINT_WORD_COMPLETION: Suggest word completion
 * @GTK_INPUT_HINT_LOWERCASE: Suggest to convert all text to lowercase
 * @GTK_INPUT_HINT_UPPERCASE_CHARS: Suggest to capitalize all text
 * @GTK_INPUT_HINT_UPPERCASE_WORDS: Suggest to capitalize the first
 *     character of each word
 * @GTK_INPUT_HINT_UPPERCASE_SENTENCES: Suggest to capitalize the
 *     first word of each sentence
 * @GTK_INPUT_HINT_INHIBIT_OSK: Suggest to not show an onscreen keyboard
 *     (e.g for a calculator that already has all the keys).
 * @GTK_INPUT_HINT_VERTICAL_WRITING: The text is vertical. Since 3.18
 *
 * Describes hints that might be taken into account by input methods
 * or applications. Note that input methods may already tailor their
 * behaviour according to the #GtkInputPurpose of the entry.
 *
 * Some common sense is expected when using these flags - mixing
 * @GTK_INPUT_HINT_LOWERCASE with any of the uppercase hints makes no sense.
 *
 * This enumeration may be extended in the future; input methods should
 * ignore unknown values.
 *
 * Since: 3.6
 */
typedef enum
{
  GTK_INPUT_HINT_NONE                = 0,
  GTK_INPUT_HINT_SPELLCHECK          = 1 << 0,
  GTK_INPUT_HINT_NO_SPELLCHECK       = 1 << 1,
  GTK_INPUT_HINT_WORD_COMPLETION     = 1 << 2,
  GTK_INPUT_HINT_LOWERCASE           = 1 << 3,
  GTK_INPUT_HINT_UPPERCASE_CHARS     = 1 << 4,
  GTK_INPUT_HINT_UPPERCASE_WORDS     = 1 << 5,
  GTK_INPUT_HINT_UPPERCASE_SENTENCES = 1 << 6,
  GTK_INPUT_HINT_INHIBIT_OSK         = 1 << 7,
  GTK_INPUT_HINT_VERTICAL_WRITING    = 1 << 8
} GtkInputHints;

/**
 * GtkPropagationPhase:
 * @GTK_PHASE_NONE: Events are not delivered automatically. Those can be
 *   manually fed through gtk_event_controller_handle_event(). This should
 *   only be used when full control about when, or whether the controller
 *   handles the event is needed.
 * @GTK_PHASE_CAPTURE: Events are delivered in the capture phase. The
 *   capture phase happens before the bubble phase, runs from the toplevel down
 *   to the event widget. This option should only be used on containers that
 *   might possibly handle events before their children do.
 * @GTK_PHASE_BUBBLE: Events are delivered in the bubble phase. The bubble
 *   phase happens after the capture phase, and before the default handlers
 *   are run. This phase runs from the event widget, up to the toplevel.
 * @GTK_PHASE_TARGET: Events are delivered in the default widget event handlers,
 *   note that widget implementations must chain up on button, motion, touch and
 *   grab broken handlers for controllers in this phase to be run.
 *
 * Describes the stage at which events are fed into a #GtkEventController.
 *
 * Since: 3.14
 */
typedef enum
{
  GTK_PHASE_NONE,
  GTK_PHASE_CAPTURE,
  GTK_PHASE_BUBBLE,
  GTK_PHASE_TARGET
} GtkPropagationPhase;

/**
 * GtkEventSequenceState:
 * @GTK_EVENT_SEQUENCE_NONE: The sequence is handled, but not grabbed.
 * @GTK_EVENT_SEQUENCE_CLAIMED: The sequence is handled and grabbed.
 * @GTK_EVENT_SEQUENCE_DENIED: The sequence is denied.
 *
 * Describes the state of a #GdkEventSequence in a #GtkGesture.
 *
 * Since: 3.14
 */
typedef enum
{
  GTK_EVENT_SEQUENCE_NONE,
  GTK_EVENT_SEQUENCE_CLAIMED,
  GTK_EVENT_SEQUENCE_DENIED
} GtkEventSequenceState;

/**
 * GtkPanDirection:
 * @GTK_PAN_DIRECTION_LEFT: panned towards the left
 * @GTK_PAN_DIRECTION_RIGHT: panned towards the right
 * @GTK_PAN_DIRECTION_UP: panned upwards
 * @GTK_PAN_DIRECTION_DOWN: panned downwards
 *
 * Describes the panning direction of a #GtkGesturePan
 *
 * Since: 3.14
 */
typedef enum
{
  GTK_PAN_DIRECTION_LEFT,
  GTK_PAN_DIRECTION_RIGHT,
  GTK_PAN_DIRECTION_UP,
  GTK_PAN_DIRECTION_DOWN
} GtkPanDirection;

/**
 * GtkPopoverConstraint:
 * @GTK_POPOVER_CONSTRAINT_NONE: Don't constrain the popover position
 *   beyond what is imposed by the implementation
 * @GTK_POPOVER_CONSTRAINT_WINDOW: Constrain the popover to the boundaries
 *   of the window that it is attached to
 *
 * Describes constraints to positioning of popovers. More values
 * may be added to this enumeration in the future.
 *
 * Since: 3.20
 */
typedef enum
{
  GTK_POPOVER_CONSTRAINT_NONE,
  GTK_POPOVER_CONSTRAINT_WINDOW
} GtkPopoverConstraint;
typedef struct GtkAccelGroupPrivate{} GtkAccelGroupPrivate;
struct GtkAccelGroup
{
  GObject               parent;
  GtkAccelGroupPrivate *priv;
};
struct GtkAccelGroupClass
{
  GObjectClass parent_class;

  /*< public >*/

  void	(*accel_changed)	(GtkAccelGroup	*accel_group,
				 guint           keyval,
				 GdkModifierType modifier,
				 GClosure       *accel_closure);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


#endif /* __GTK_ENUMS_H__ */
#define headerfilename "gtk/./gtkaccelgroup.h"
/* file: gtk/./gtkaccelgroup.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1998, 2001 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_ACCEL_GROUP_H__
#define __GTK_ACCEL_GROUP_H__




#include <gdk/gdk.h>
#include <gtk/gtkenums.h>

G_BEGIN_DECLS


/* --- type macros --- */
#define GTK_TYPE_ACCEL_GROUP()              (gtk_accel_group_get_type ())
#define GTK_ACCEL_GROUP(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), GTK_TYPE_ACCEL_GROUP, GtkAccelGroup))
#define GTK_ACCEL_GROUP_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ACCEL_GROUP, GtkAccelGroupClass))
#define GTK_IS_ACCEL_GROUP(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), GTK_TYPE_ACCEL_GROUP))
#define GTK_IS_ACCEL_GROUP_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ACCEL_GROUP))
#define GTK_ACCEL_GROUP_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ACCEL_GROUP, GtkAccelGroupClass))


/* --- accel flags --- */
/**
 * GtkAccelFlags:
 * @GTK_ACCEL_VISIBLE: Accelerator is visible
 * @GTK_ACCEL_LOCKED: Accelerator not removable
 * @GTK_ACCEL_MASK: Mask
 *
 * Accelerator flags used with gtk_accel_group_connect().
 */
typedef enum
{
  GTK_ACCEL_VISIBLE        = 1 << 0,
  GTK_ACCEL_LOCKED         = 1 << 1,
  GTK_ACCEL_MASK           = 0x07
} GtkAccelFlags;
struct GtkAccelKey
{
  guint           accel_key;
  GdkModifierType accel_mods;
  guint           accel_flags : 16;
};


/* --- typedefs & structures --- */
typedef gboolean (*GtkAccelGroupActivate) (GtkAccelGroup  *accel_group,
					   GObject        *acceleratable,
					   guint           keyval,
					   GdkModifierType modifier);

/**
 * GtkAccelGroupFindFunc:
 * @key: 
 * @closure: 
 * @data: (closure):
 * 
 * Since: 2.2
 */
typedef gboolean (*GtkAccelGroupFindFunc) (GtkAccelKey    *key,
					   GClosure       *closure,
					   gpointer        data);

/**
 * GtkAccelGroup:
 * 
 * An object representing and maintaining a group of accelerators.
 */

/**
 * GtkAccelGroupClass:
 * @parent_class: The parent class.
 * @accel_changed: Signal emitted when an entry is added to or removed
 *    from the accel group.
 */

/**
 * GtkAccelKey:
 * @accel_key: The accelerator keyval
 * @accel_mods:The accelerator modifiers
 * @accel_flags: The accelerator flags
 */
struct GtkAccelGroupEntry
{
  GtkAccelKey  key;
  GClosure    *closure;
  GQuark       accel_path_quark;
};
typedef struct _GtkActivatable{} GtkActivatable; /* Dummy typedef */


/* -- Accelerator Groups --- */
GDK_AVAILABLE_IN_ALL
GType          gtk_accel_group_get_type           (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkAccelGroup* gtk_accel_group_new	      	  (void);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_accel_group_get_is_locked      (GtkAccelGroup  *accel_group);
GDK_AVAILABLE_IN_ALL
GdkModifierType 
               gtk_accel_group_get_modifier_mask  (GtkAccelGroup  *accel_group);
GDK_AVAILABLE_IN_ALL
void	       gtk_accel_group_lock		  (GtkAccelGroup  *accel_group);
GDK_AVAILABLE_IN_ALL
void	       gtk_accel_group_unlock		  (GtkAccelGroup  *accel_group);
GDK_AVAILABLE_IN_ALL
void	       gtk_accel_group_connect		  (GtkAccelGroup  *accel_group,
						   guint	   accel_key,
						   GdkModifierType accel_mods,
						   GtkAccelFlags   accel_flags,
						   GClosure	  *closure);
GDK_AVAILABLE_IN_ALL
void           gtk_accel_group_connect_by_path    (GtkAccelGroup  *accel_group,
						   const char	  *accel_path,
						   GClosure	  *closure);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_accel_group_disconnect	  (GtkAccelGroup  *accel_group,
						   GClosure	  *closure);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_accel_group_disconnect_key	  (GtkAccelGroup  *accel_group,
						   guint	   accel_key,
						   GdkModifierType accel_mods);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_accel_group_activate           (GtkAccelGroup   *accel_group,
                                                   GQuark	   accel_quark,
                                                   GObject	  *acceleratable,
                                                   guint	   accel_key,
                                                   GdkModifierType accel_mods);


/* --- GtkActivatable glue --- */
void		_gtk_accel_group_attach		(GtkAccelGroup	*accel_group,
						 GObject	*object);
void		_gtk_accel_group_detach		(GtkAccelGroup	*accel_group,
						 GObject	*object);
GDK_AVAILABLE_IN_ALL
gboolean        gtk_accel_groups_activate      	(GObject	*object,
						 guint		 accel_key,
						 GdkModifierType accel_mods);
GDK_AVAILABLE_IN_ALL
GSList*	        gtk_accel_groups_from_object    (GObject	*object);
GDK_AVAILABLE_IN_ALL
GtkAccelKey*	gtk_accel_group_find		(GtkAccelGroup	      *accel_group,
						 GtkAccelGroupFindFunc find_func,
						 gpointer              data);
GDK_AVAILABLE_IN_ALL
GtkAccelGroup*	gtk_accel_group_from_accel_closure (GClosure    *closure);


/* --- Accelerators--- */
GDK_AVAILABLE_IN_ALL
gboolean gtk_accelerator_valid		      (guint	        keyval,
					       GdkModifierType  modifiers) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
void	 gtk_accelerator_parse		      (const char     *accelerator,
					       guint	       *accelerator_key,
					       GdkModifierType *accelerator_mods);
GDK_AVAILABLE_IN_3_4
void gtk_accelerator_parse_with_keycode       (const char     *accelerator,
                                               guint           *accelerator_key,
                                               guint          **accelerator_codes,
                                               GdkModifierType *accelerator_mods);
GDK_AVAILABLE_IN_ALL
char*	 gtk_accelerator_name		      (guint	        accelerator_key,
					       GdkModifierType  accelerator_mods);
GDK_AVAILABLE_IN_3_4
char*	 gtk_accelerator_name_with_keycode    (GdkDisplay      *display,
                                               guint            accelerator_key,
                                               guint            keycode,
                                               GdkModifierType  accelerator_mods);
GDK_AVAILABLE_IN_ALL
char*   gtk_accelerator_get_label            (guint           accelerator_key,
                                               GdkModifierType accelerator_mods);
GDK_AVAILABLE_IN_3_4
char*   gtk_accelerator_get_label_with_keycode (GdkDisplay      *display,
                                                 guint            accelerator_key,
                                                 guint            keycode,
                                                 GdkModifierType  accelerator_mods);
GDK_AVAILABLE_IN_ALL
void	 gtk_accelerator_set_default_mod_mask (GdkModifierType  default_mod_mask);
GDK_AVAILABLE_IN_ALL
GdkModifierType
	 gtk_accelerator_get_default_mod_mask (void);

GDK_AVAILABLE_IN_ALL
GtkAccelGroupEntry*	gtk_accel_group_query	(GtkAccelGroup	*accel_group,
						 guint		 accel_key,
						 GdkModifierType accel_mods,
						 guint          *n_entries);


G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkAccelGroup, g_object_unref)

G_END_DECLS

#endif /* __GTK_ACCEL_GROUP_H__ */
#define headerfilename "gtk/./gtkborder.h"
/* file: gtk/./gtkborder.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_BORDER_H__
#define __GTK_BORDER_H__



#include <glib-object.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS


#define GTK_TYPE_BORDER() (gtk_border_get_type ())

/**
 * GtkBorder:
 * @left: The width of the left border
 * @right: The width of the right border
 * @top: The width of the top border
 * @bottom: The width of the bottom border
 *
 * A struct that specifies a border around a rectangular area
 * that can be of different width on each side.
 */
struct GtkBorder
{
  gint16 left;
  gint16 right;
  gint16 top;
  gint16 bottom;
};
typedef struct GtkBuilderPrivate{} GtkBuilderPrivate;
struct GtkBuilder
{
  GObject parent_instance;

  GtkBuilderPrivate *priv;
};

GDK_AVAILABLE_IN_ALL
GType      gtk_border_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkBorder *gtk_border_new      (void) G_GNUC_MALLOC;
GDK_AVAILABLE_IN_ALL
GtkBorder *gtk_border_copy     (const GtkBorder *border_);
GDK_AVAILABLE_IN_ALL
void       gtk_border_free     (GtkBorder       *border_);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkBorder, gtk_border_free)

G_END_DECLS

#endif /* __GTK_BORDER_H__ */
#define headerfilename "gtk/./gtktypes.h"
/* file: gtk/./gtktypes.h */
/* GDK - The GIMP Drawing Kit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_TYPES_H__
#define __GTK_TYPES_H__



G_BEGIN_DECLS

typedef struct _GtkClipboard{} GtkClipboard;
typedef struct _GtkIconSet{} GtkIconSet;
typedef struct _GtkIconSource{} GtkIconSource;
typedef struct _GtkSelectionData{} GtkSelectionData;
typedef struct _GtkTooltip{} GtkTooltip;
typedef struct GtkWidgetPath{} GtkWidgetPath;


typedef gboolean (*GtkRcPropertyParser) (const GParamSpec *pspec,
                                         const GString    *rc_string,
                                         GValue           *property_value);

typedef void (*GtkBuilderConnectFunc) (GtkBuilder    *builder,
				       GObject       *object,
				       const char   *signal_name,
				       const char   *handler_name,
				       GObject       *connect_object,
				       GConnectFlags  flags,
				       gpointer       user_data);

G_END_DECLS

#endif /* __GTK_TYPES_H__ */
#define headerfilename "gtk/./gtkwidget.h"
/* file: gtk/./gtkwidget.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_WIDGET_H__
#define __GTK_WIDGET_H__



#include <gdk/gdk.h>
#include <gtk/gtkaccelgroup.h>
#include <gtk/gtkborder.h>
#include <gtk/gtktypes.h>
#include <atk/atk.h>

G_BEGIN_DECLS

/* Kinds of widget-specific help */
/**
 * GtkWidgetHelpType:
 * @GTK_WIDGET_HELP_TOOLTIP: Tooltip.
 * @GTK_WIDGET_HELP_WHATS_THIS: What’s this.
 *
 * Kinds of widget-specific help. Used by the ::show-help signal.
 */
typedef enum
{
  GTK_WIDGET_HELP_TOOLTIP,
  GTK_WIDGET_HELP_WHATS_THIS
} GtkWidgetHelpType;
typedef struct GtkWidgetPrivate{} GtkWidgetPrivate;
struct GtkWidget
{
  GInitiallyUnowned parent_instance;

  /*< private >*/

  GtkWidgetPrivate *priv;
};
typedef struct GtkIconFactoryPrivate{} GtkIconFactoryPrivate;
struct GtkIconFactory
{
  GObject parent_instance;

  /*< private >*/
  GtkIconFactoryPrivate *priv;
};
struct GtkRcStyle
{
  GObject parent_instance;

  /*< public >*/

  char *name;
  char *bg_pixmap_name[5];
  PangoFontDescription *font_desc;

  GtkRcFlags color_flags[5];
  GdkColor   fg[5];
  GdkColor   bg[5];
  GdkColor   text[5];
  GdkColor   base[5];

  gint xthickness;
  gint ythickness;

  /*< private >*/
  GArray *rc_properties;

  /* list of RC style lists including this RC style */
  GSList *rc_style_lists;

  GSList *icon_factories;

  guint engine_specified : 1;   /* The RC file specified the engine */
};
struct GtkStyle
{
  /*< private >*/
  GObject parent_instance;

  /*< public >*/

  GdkColor fg[5];
  GdkColor bg[5];
  GdkColor light[5];
  GdkColor dark[5];
  GdkColor mid[5];
  GdkColor text[5];
  GdkColor base[5];
  GdkColor text_aa[5];          /* Halfway between text/base */

  GdkColor black;
  GdkColor white;
  PangoFontDescription *font_desc;

  gint xthickness;
  gint ythickness;

  cairo_pattern_t *background[5];

  /*< private >*/

  gint attach_count;

  GdkVisual *visual;
  PangoFontDescription *private_font_desc; /* Font description for style->private_font or %NULL */

  /* the RcStyle from which this style was created */
  GtkRcStyle     *rc_style;

  GSList         *styles;         /* of type GtkStyle* */
  GArray         *property_cache;
  GSList         *icon_factories; /* of type GtkIconFactory* */
};
typedef struct GtkWidgetClassPrivate{} GtkWidgetClassPrivate;
struct GtkWidgetClass
{
  GInitiallyUnownedClass parent_class;

  /*< public >*/

  guint activate_signal;

  /* seldomly overidden */
  void (*dispatch_child_properties_changed) (GtkWidget   *widget,
					     guint        n_pspecs,
					     GParamSpec **pspecs);

  /* basics */
  void (* destroy)             (GtkWidget        *widget);
  void (* show)		       (GtkWidget        *widget);
  void (* show_all)            (GtkWidget        *widget);
  void (* hide)		       (GtkWidget        *widget);
  void (* map)		       (GtkWidget        *widget);
  void (* unmap)	       (GtkWidget        *widget);
  void (* realize)	       (GtkWidget        *widget);
  void (* unrealize)	       (GtkWidget        *widget);
  void (* size_allocate)       (GtkWidget        *widget,
				GtkAllocation    *allocation);
  void (* state_changed)       (GtkWidget        *widget,
				GtkStateType   	  previous_state);
  void (* state_flags_changed) (GtkWidget        *widget,
				GtkStateFlags  	  previous_state_flags);
  void (* parent_set)	       (GtkWidget        *widget,
				GtkWidget        *previous_parent);
  void (* hierarchy_changed)   (GtkWidget        *widget,
				GtkWidget        *previous_toplevel);
  void (* style_set)	       (GtkWidget        *widget,
				GtkStyle         *previous_style);
  void (* direction_changed)   (GtkWidget        *widget,
				GtkTextDirection  previous_direction);
  void (* grab_notify)         (GtkWidget        *widget,
				gboolean          was_grabbed);
  void (* child_notify)        (GtkWidget	 *widget,
				GParamSpec       *child_property);
  gboolean (* draw)	       (GtkWidget	 *widget,
                                cairo_t          *cr);

  /* size requests */
  GtkSizeRequestMode (* get_request_mode)               (GtkWidget      *widget);

  void               (* get_preferred_height)           (GtkWidget       *widget,
                                                         gint            *minimum_height,
                                                         gint            *natural_height);
  void               (* get_preferred_width_for_height) (GtkWidget       *widget,
                                                         gint             height,
                                                         gint            *minimum_width,
                                                         gint            *natural_width);
  void               (* get_preferred_width)            (GtkWidget       *widget,
                                                         gint            *minimum_width,
                                                         gint            *natural_width);
  void               (* get_preferred_height_for_width) (GtkWidget       *widget,
                                                         gint             width,
                                                         gint            *minimum_height,
                                                         gint            *natural_height);

  /* Mnemonics */
  gboolean (* mnemonic_activate)        (GtkWidget           *widget,
                                         gboolean             group_cycling);

  /* explicit focus */
  void     (* grab_focus)               (GtkWidget           *widget);
  gboolean (* focus)                    (GtkWidget           *widget,
                                         GtkDirectionType     direction);

  /* keyboard navigation */
  void     (* move_focus)               (GtkWidget           *widget,
                                         GtkDirectionType     direction);
  gboolean (* keynav_failed)            (GtkWidget           *widget,
                                         GtkDirectionType     direction);

  /* events */
  gboolean (* event)			(GtkWidget	     *widget,
					 GdkEvent	     *event);
  gboolean (* button_press_event)	(GtkWidget	     *widget,
					 GdkEventButton      *event);
  gboolean (* button_release_event)	(GtkWidget	     *widget,
					 GdkEventButton      *event);
  gboolean (* scroll_event)		(GtkWidget           *widget,
					 GdkEventScroll      *event);
  gboolean (* motion_notify_event)	(GtkWidget	     *widget,
					 GdkEventMotion      *event);
  gboolean (* delete_event)		(GtkWidget	     *widget,
					 GdkEventAny	     *event);
  gboolean (* destroy_event)		(GtkWidget	     *widget,
					 GdkEventAny	     *event);
  gboolean (* key_press_event)		(GtkWidget	     *widget,
					 GdkEventKey	     *event);
  gboolean (* key_release_event)	(GtkWidget	     *widget,
					 GdkEventKey	     *event);
  gboolean (* enter_notify_event)	(GtkWidget	     *widget,
					 GdkEventCrossing    *event);
  gboolean (* leave_notify_event)	(GtkWidget	     *widget,
					 GdkEventCrossing    *event);
  gboolean (* configure_event)		(GtkWidget	     *widget,
					 GdkEventConfigure   *event);
  gboolean (* focus_in_event)		(GtkWidget	     *widget,
					 GdkEventFocus       *event);
  gboolean (* focus_out_event)		(GtkWidget	     *widget,
					 GdkEventFocus       *event);
  gboolean (* map_event)		(GtkWidget	     *widget,
					 GdkEventAny	     *event);
  gboolean (* unmap_event)		(GtkWidget	     *widget,
					 GdkEventAny	     *event);
  gboolean (* property_notify_event)	(GtkWidget	     *widget,
					 GdkEventProperty    *event);
  gboolean (* selection_clear_event)	(GtkWidget	     *widget,
					 GdkEventSelection   *event);
  gboolean (* selection_request_event)	(GtkWidget	     *widget,
					 GdkEventSelection   *event);
  gboolean (* selection_notify_event)	(GtkWidget	     *widget,
					 GdkEventSelection   *event);
  gboolean (* proximity_in_event)	(GtkWidget	     *widget,
					 GdkEventProximity   *event);
  gboolean (* proximity_out_event)	(GtkWidget	     *widget,
					 GdkEventProximity   *event);
  gboolean (* visibility_notify_event)	(GtkWidget	     *widget,
					 GdkEventVisibility  *event);
  gboolean (* window_state_event)	(GtkWidget	     *widget,
					 GdkEventWindowState *event);
  gboolean (* damage_event)             (GtkWidget           *widget,
                                         GdkEventExpose      *event);
  gboolean (* grab_broken_event)        (GtkWidget           *widget,
                                         GdkEventGrabBroken  *event);

  /* selection */
  void     (* selection_get)       (GtkWidget          *widget,
				    GtkSelectionData   *selection_data,
				    guint               info,
				    guint               time_);
  void     (* selection_received)  (GtkWidget          *widget,
				    GtkSelectionData   *selection_data,
				    guint               time_);

  /* Source side drag signals */
  void     (* drag_begin)          (GtkWidget         *widget,
				    GdkDragContext     *context);
  void     (* drag_end)	           (GtkWidget	       *widget,
				    GdkDragContext     *context);
  void     (* drag_data_get)       (GtkWidget          *widget,
				    GdkDragContext     *context,
				    GtkSelectionData   *selection_data,
				    guint               info,
				    guint               time_);
  void     (* drag_data_delete)    (GtkWidget          *widget,
				    GdkDragContext     *context);

  /* Target side drag signals */
  void     (* drag_leave)          (GtkWidget          *widget,
				    GdkDragContext     *context,
				    guint               time_);
  gboolean (* drag_motion)         (GtkWidget	       *widget,
				    GdkDragContext     *context,
				    gint                x,
				    gint                y,
				    guint               time_);
  gboolean (* drag_drop)           (GtkWidget	       *widget,
				    GdkDragContext     *context,
				    gint                x,
				    gint                y,
				    guint               time_);
  void     (* drag_data_received)  (GtkWidget          *widget,
				    GdkDragContext     *context,
				    gint                x,
				    gint                y,
				    GtkSelectionData   *selection_data,
				    guint               info,
				    guint               time_);
  gboolean (* drag_failed)         (GtkWidget          *widget,
                                    GdkDragContext     *context,
                                    GtkDragResult       result);

  /* Signals used only for keybindings */
  gboolean (* popup_menu)          (GtkWidget          *widget);

  /* If a widget has multiple tooltips/whatsthis, it should show the
   * one for the current focus location, or if that doesn't make
   * sense, should cycle through them showing each tip alongside
   * whatever piece of the widget it applies to.
   */
  gboolean (* show_help)           (GtkWidget          *widget,
                                    GtkWidgetHelpType   help_type);

  /* accessibility support
   */
  AtkObject *  (* get_accessible)     (GtkWidget *widget);

  void         (* screen_changed)     (GtkWidget *widget,
                                       GdkScreen *previous_screen);
  gboolean     (* can_activate_accel) (GtkWidget *widget,
                                       guint      signal_id);


  void         (* composited_changed) (GtkWidget *widget);

  gboolean     (* query_tooltip)      (GtkWidget  *widget,
				       gint        x,
				       gint        y,
				       gboolean    keyboard_tooltip,
				       GtkTooltip *tooltip);

  void         (* compute_expand)     (GtkWidget  *widget,
                                       gboolean   *hexpand_p,
                                       gboolean   *vexpand_p);

  void         (* adjust_size_request)    (GtkWidget         *widget,
                                           GtkOrientation     orientation,
                                           gint              *minimum_size,
                                           gint              *natural_size);
  void         (* adjust_size_allocation) (GtkWidget         *widget,
                                           GtkOrientation     orientation,
                                           gint              *minimum_size,
                                           gint              *natural_size,
                                           gint              *allocated_pos,
                                           gint              *allocated_size);

  void         (* style_updated)          (GtkWidget *widget);

  gboolean     (* touch_event)            (GtkWidget     *widget,
                                           GdkEventTouch *event);

  void         (* get_preferred_height_and_baseline_for_width)  (GtkWidget     *widget,
								 gint           width,
								 gint          *minimum_height,
								 gint          *natural_height,
								 gint          *minimum_baseline,
								 gint          *natural_baseline);
  void         (* adjust_baseline_request)(GtkWidget         *widget,
                                           gint              *minimum_baseline,
                                           gint              *natural_baseline);
  void         (* adjust_baseline_allocation) (GtkWidget         *widget,
					       gint              *baseline);
  void         (*queue_draw_region)           (GtkWidget         *widget,
					       const cairo_region_t *region);

  /*< private >*/

  GtkWidgetClassPrivate *priv;

  /* Padding for future expansion */
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
};

/* Macro for casting a pointer to a GtkWidget or GtkWidgetClass pointer.
 * Macros for testing whether widget or klass are of type GTK_TYPE_WIDGET.
 */
#define GTK_TYPE_WIDGET()			  (gtk_widget_get_type ())
#define GTK_WIDGET(widget)		  (G_TYPE_CHECK_INSTANCE_CAST ((widget), GTK_TYPE_WIDGET, GtkWidget))
#define GTK_WIDGET_CLASS(klass)		  (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_WIDGET, GtkWidgetClass))
#define GTK_IS_WIDGET(widget)		  (G_TYPE_CHECK_INSTANCE_TYPE ((widget), GTK_TYPE_WIDGET))
#define GTK_IS_WIDGET_CLASS(klass)	  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_WIDGET))
#define GTK_WIDGET_GET_CLASS(obj)         (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_WIDGET, GtkWidgetClass))

#define GTK_TYPE_REQUISITION()              (gtk_requisition_get_type ())


/**
 * GtkAllocation:
 * @x: the X position of the widget’s area relative to its parents allocation.
 * @y: the Y position of the widget’s area relative to its parents allocation.
 * @width: the width of the widget’s allocated area.
 * @height: the height of the widget’s allocated area.
 *
 * A #GtkAllocation-struct of a widget represents region
 * which has been allocated to the widget by its parent. It is a subregion
 * of its parents allocation. See
 * [GtkWidget’s geometry management section][geometry-management] for
 * more information.
 */
typedef 	GdkRectangle	   GtkAllocation;

/**
 * GtkCallback:
 * @widget: the widget to operate on
 * @data: (closure): user-supplied data
 *
 * The type of the callback functions used for e.g. iterating over
 * the children of a container, see gtk_container_foreach().
 */
typedef void    (*GtkCallback)     (GtkWidget        *widget,
				    gpointer          data);

/**
 * GtkTickCallback:
 * @widget: the widget
 * @frame_clock: the frame clock for the widget (same as calling gtk_widget_get_frame_clock())
 * @user_data: user data passed to gtk_widget_add_tick_callback().
 *
 * Callback type for adding a function to update animations. See gtk_widget_add_tick_callback().
 *
 * Returns: %G_SOURCE_CONTINUE if the tick callback should continue to be called,
 *  %G_SOURCE_REMOVE if the tick callback should be removed.
 *
 * Since: 3.8
 */
typedef gboolean (*GtkTickCallback) (GtkWidget     *widget,
                                     GdkFrameClock *frame_clock,
                                     gpointer       user_data);

/**
 * GtkRequisition:
 * @width: the widget’s desired width
 * @height: the widget’s desired height
 *
 * A #GtkRequisition-struct represents the desired size of a widget. See
 * [GtkWidget’s geometry management section][geometry-management] for
 * more information.
 */
struct GtkRequisition
{
  gint width;
  gint height;
};
typedef struct GtkApplicationPrivate{} GtkApplicationPrivate;

/* The widget is the base of the tree for displayable objects.
 *  (A displayable object is one which takes up some amount
 *  of screen real estate). It provides a common base and interface
 *  which actual widgets must adhere to.
 */

/**
 * GtkWidgetClass:
 * @parent_class: The object class structure needs to be the first
 *   element in the widget class structure in order for the class mechanism
 *   to work correctly. This allows a GtkWidgetClass pointer to be cast to
 *   a GObjectClass pointer.
 * @activate_signal: The signal to emit when a widget of this class is
 *   activated, gtk_widget_activate() handles the emission.
 *   Implementation of this signal is optional.
 * @dispatch_child_properties_changed: Seldomly overidden.
 * @destroy: Signals that all holders of a reference to the widget
 *   should release the reference that they hold.
 * @show: Signal emitted when widget is shown
 * @show_all: Recursively shows a widget, and any child widgets (if the widget is
 * a container).
 * @hide: Signal emitted when widget is hidden.
 * @map: Signal emitted when widget is going to be mapped, that is
 *   when the widget is visible (which is controlled with
 *   gtk_widget_set_visible()) and all its parents up to the toplevel
 *   widget are also visible.
 * @unmap: Signal emitted when widget is going to be unmapped, which
 *   means that either it or any of its parents up to the toplevel
 *   widget have been set as hidden.
 * @realize: Signal emitted when widget is associated with a
 *   #GdkWindow, which means that gtk_widget_realize() has been called or
 *   the widget has been mapped (that is, it is going to be drawn).
 * @unrealize: Signal emitted when the GdkWindow associated with
 *   widget is destroyed, which means that gtk_widget_unrealize() has
 *   been called or the widget has been unmapped (that is, it is going
 *   to be hidden).
 * @size_allocate: Signal emitted to get the widget allocation.
 * @state_changed: Signal emitted when the widget state
 *   changes. Deprecated: 3.0
 * @state_flags_changed: Signal emitted when the widget state changes,
 *   see gtk_widget_get_state_flags().
 * @parent_set: Signal emitted when a new parent has been set on a
 *   widget.
 * @hierarchy_changed: Signal emitted when the anchored state of a
 *   widget changes.
 * @style_set: Signal emitted when a new style has been set on a
 * widget. Deprecated: 3.0
 * @direction_changed: Signal emitted when the text direction of a
 *   widget changes.
 * @grab_notify: Signal emitted when a widget becomes shadowed by a
 *   GTK+ grab (not a pointer or keyboard grab) on another widget, or
 *   when it becomes unshadowed due to a grab being removed.
 * @child_notify: Signal emitted for each child property that has
 *   changed on an object.
 * @draw: Signal emitted when a widget is supposed to render itself.
 * @get_request_mode: This allows a widget to tell its parent container whether
 *   it prefers to be allocated in %GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH or
 *   %GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT mode.
 *   %GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH means the widget prefers to have
 *   #GtkWidgetClass.get_preferred_width() called and then
 *   #GtkWidgetClass.get_preferred_height_for_width().
 *   %GTK_SIZE_REQUEST_CONSTANT_SIZE disables any height-for-width or
 *   width-for-height geometry management for a said widget and is the
 *   default return.
 *   It’s important to note (as described below) that any widget
 *   which trades height-for-width or width-for-height must respond properly 
 *   to both of the virtual methods #GtkWidgetClass.get_preferred_height_for_width()
 *   and #GtkWidgetClass.get_preferred_width_for_height() since it might be 
 *   queried in either #GtkSizeRequestMode by its parent container.
 * @get_preferred_height: This is called by containers to obtain the minimum
 *   and natural height of a widget. A widget that does not actually trade
 *   any height for width or width for height only has to implement these
 *   two virtual methods (#GtkWidgetClass.get_preferred_width() and
 *   #GtkWidgetClass.get_preferred_height()).
 * @get_preferred_width_for_height: This is analogous to
 *   #GtkWidgetClass.get_preferred_height_for_width() except that it
 *   operates in the oposite orientation. It’s rare that a widget actually
 *   does %GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT requests but this can happen
 *   when, for example, a widget or container gets additional columns to
 *   compensate for a smaller allocated height.
 * @get_preferred_width: This is called by containers to obtain the minimum
 *   and natural width of a widget. A widget will never be allocated a width
 *   less than its minimum and will only ever be allocated a width greater
 *   than the natural width once all of the said widget’s siblings have
 *   received their natural widths.
 *   Furthermore, a widget will only ever be allocated a width greater than
 *   its natural width if it was configured to receive extra expand space
 *   from its parent container.
 * @get_preferred_height_for_width: This is similar to
 *   #GtkWidgetClass.get_preferred_height() except that it is passed a
 *   contextual width to request height for. By implementing this virtual
 *   method it is possible for a #GtkLabel to tell its parent how much height
 *   would be required if the label were to be allocated a said width.
 * @mnemonic_activate: Activates the @widget if @group_cycling is
 *   %FALSE, and just grabs the focus if @group_cycling is %TRUE.
 * @grab_focus: Causes @widget to have the keyboard focus for the
 *   #GtkWindow it’s inside.
 * @focus:
 * @move_focus: Signal emitted when a change of focus is requested
 * @keynav_failed: Signal emitted if keyboard navigation fails.
 * @event: The GTK+ main loop will emit three signals for each GDK
 *   event delivered to a widget: one generic ::event signal, another,
 *   more specific, signal that matches the type of event delivered
 *   (e.g. "key-press-event") and finally a generic "event-after"
 *   signal.
 * @button_press_event: Signal will be emitted when a button
 *   (typically from a mouse) is pressed.
 * @button_release_event: Signal will be emitted when a button
 *   (typically from a mouse) is released.
 * @scroll_event: Signal emitted when a button in the 4 to 7 range is
 *   pressed.
 * @motion_notify_event: Signal emitted when the pointer moves over
 *   the widget’s #GdkWindow.
 * @delete_event: Signal emitted if a user requests that a toplevel
 *   window is closed.
 * @destroy_event: Signal is emitted when a #GdkWindow is destroyed.
 * @key_press_event: Signal emitted when a key is pressed.
 * @key_release_event: Signal is emitted when a key is released.
 * @enter_notify_event: Signal event will be emitted when the pointer
 *   enters the widget’s window.
 * @leave_notify_event: Will be emitted when the pointer leaves the
 *   widget’s window.
 * @configure_event: Signal will be emitted when the size, position or
 *   stacking of the widget’s window has changed.
 * @focus_in_event: Signal emitted when the keyboard focus enters the
 * widget’s window.
 * @focus_out_event: Signal emitted when the keyboard focus leaves the
 * widget’s window.
 * @map_event: Signal emitted when the widget’s window is mapped.
 * @unmap_event: Signal will be emitted when the widget’s window is
 *   unmapped.
 * @property_notify_event: Signal will be emitted when a property on
 *   the widget’s window has been changed or deleted.
 * @selection_clear_event: Signal will be emitted when the the
 *   widget’s window has lost ownership of a selection.
 * @selection_request_event: Signal will be emitted when another
 *   client requests ownership of the selection owned by the widget's
 *   window.
 * @selection_notify_event:
 * @proximity_in_event:
 * @proximity_out_event:
 * @visibility_notify_event: Signal emitted when the widget’s window is
 *   obscured or unobscured.
 * @window_state_event: Signal emitted when the state of the toplevel
 *   window associated to the widget changes.
 * @damage_event: Signal emitted when a redirected window belonging to
 *   widget gets drawn into.
 * @grab_broken_event: Signal emitted when a pointer or keyboard grab
 *   on a window belonging to widget gets broken.
 * @selection_get:
 * @selection_received:
 * @drag_begin: Signal emitted on the drag source when a drag is
 *   started.
 * @drag_end: Signal emitted on the drag source when a drag is
 *   finished.
 * @drag_data_get: Signal emitted on the drag source when the drop
 *   site requests the data which is dragged.
 * @drag_data_delete: Signal emitted on the drag source when a drag
 *   with the action %GDK_ACTION_MOVE is successfully completed.
 * @drag_leave: Signal emitted on the drop site when the cursor leaves
 *   the widget.
 * @drag_motion: signal emitted on the drop site when the user moves
 *   the cursor over the widget during a drag.
 * @drag_drop: Signal emitted on the drop site when the user drops the
 *   data onto the widget.
 * @drag_data_received: Signal emitted on the drop site when the
 *   dragged data has been received.
 * @drag_failed: Signal emitted on the drag source when a drag has
 *   failed.
 * @popup_menu: Signal emitted whenever a widget should pop up a
 *   context menu.
 * @show_help:
 * @get_accessible: Returns the accessible object that describes the
 *   widget to an assistive technology.
 * @screen_changed: Signal emitted when the screen of a widget has
 *   changed.
 * @can_activate_accel: Signal allows applications and derived widgets
 *   to override the default GtkWidget handling for determining whether
 *   an accelerator can be activated.
 * @composited_changed: Signal emitted when the composited status of
 *   widgets screen changes. See gdk_screen_is_composited().
 * @query_tooltip: Signal emitted when “has-tooltip” is %TRUE and the
 *   hover timeout has expired with the cursor hovering “above”
 *   widget; or emitted when widget got focus in keyboard mode.
 * @compute_expand: Computes whether a container should give this
 *   widget extra space when possible.
 * @adjust_size_request: Convert an initial size request from a widget's
 *   #GtkSizeRequestMode virtual method implementations into a size request to
 *   be used by parent containers in laying out the widget.
 *   adjust_size_request adjusts from a child widget's
 *   original request to what a parent container should
 *   use for layout. The @for_size argument will be -1 if the request should
 *   not be for a particular size in the opposing orientation, i.e. if the
 *   request is not height-for-width or width-for-height. If @for_size is
 *   greater than -1, it is the proposed allocation in the opposing
 *   orientation that we need the request for. Implementations of
 *   adjust_size_request should chain up to the default implementation,
 *   which applies #GtkWidget’s margin properties and imposes any values
 *   from gtk_widget_set_size_request(). Chaining up should be last,
 *   after your subclass adjusts the request, so
 *   #GtkWidget can apply constraints and add the margin properly.
 * @adjust_size_allocation: Convert an initial size allocation assigned
 *   by a #GtkContainer using gtk_widget_size_allocate(), into an actual
 *   size allocation to be used by the widget. adjust_size_allocation
 *   adjusts to a child widget’s actual allocation
 *   from what a parent container computed for the
 *   child. The adjusted allocation must be entirely within the original
 *   allocation. In any custom implementation, chain up to the default
 *   #GtkWidget implementation of this method, which applies the margin
 *   and alignment properties of #GtkWidget. Chain up
 *   before performing your own adjustments so your
 *   own adjustments remove more allocation after the #GtkWidget base
 *   class has already removed margin and alignment. The natural size
 *   passed in should be adjusted in the same way as the allocated size,
 *   which allows adjustments to perform alignments or other changes
 *   based on natural size.
 * @style_updated: Signal emitted when the GtkStyleContext of a widget
 *   is changed.
 * @touch_event:
 * @get_preferred_height_and_baseline_for_width:
 * @adjust_baseline_request:
 * @adjust_baseline_allocation:
 * @queue_draw_region: Invalidates the area of widget defined by
 *   region by calling gdk_window_invalidate_region() on the widget's
 *   window and all its child windows.
 */
struct GtkApplication
{
  GApplication parent;

  /*< private >*/
  GtkApplicationPrivate *priv;
};
typedef struct GtkContainerPrivate{} GtkContainerPrivate;
struct GtkContainer
{
  GtkWidget widget;

  /*< private >*/
  GtkContainerPrivate *priv;
};
typedef struct GtkBinPrivate{} GtkBinPrivate;
struct GtkBin
{
  GtkContainer container;

  /*< private >*/
  GtkBinPrivate *priv;
};
typedef struct GtkWindowPrivate{} GtkWindowPrivate;
struct GtkWindow
{
  GtkBin bin;

  GtkWindowPrivate *priv;
};
struct GtkApplicationClass
{
  GApplicationClass parent_class;

  /*< public >*/

  void (*window_added)   (GtkApplication *application,
                          GtkWindow      *window);
  void (*window_removed) (GtkApplication *application,
                          GtkWindow      *window);

  /*< private >*/
  gpointer padding[12];
};
typedef struct GtkStyleContextPrivate{} GtkStyleContextPrivate;
struct GtkStyleContext
{
  GObject parent_object;
  GtkStyleContextPrivate *priv;
};
typedef struct GtkSettingsPrivate{} GtkSettingsPrivate;
struct GtkSettings
{
  GObject parent_instance;

  /*< private >*/
  GtkSettingsPrivate *priv;
};


GDK_AVAILABLE_IN_ALL
GType	   gtk_widget_get_type		  (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_widget_new		  (GType		type,
					   const char	       *first_property_name,
					   ...);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_destroy		  (GtkWidget	       *widget);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_destroyed		  (GtkWidget	       *widget,
					   GtkWidget	      **widget_pointer);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_unparent		  (GtkWidget	       *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_show                (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_hide                (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_show_now            (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_show_all            (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_set_no_show_all     (GtkWidget           *widget,
                                           gboolean             no_show_all);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_get_no_show_all     (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_map		  (GtkWidget	       *widget);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_unmap		  (GtkWidget	       *widget);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_realize		  (GtkWidget	       *widget);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_unrealize		  (GtkWidget	       *widget);

GDK_AVAILABLE_IN_ALL
void       gtk_widget_draw                (GtkWidget           *widget,
                                           cairo_t             *cr);
/* Queuing draws */
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_queue_draw	  (GtkWidget	       *widget);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_queue_draw_area	  (GtkWidget	       *widget,
					   gint                 x,
					   gint                 y,
					   gint                 width,
					   gint                 height);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_queue_draw_region   (GtkWidget	       *widget,
                                           const cairo_region_t*region);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_queue_resize	  (GtkWidget	       *widget);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_queue_resize_no_redraw (GtkWidget *widget);
GDK_AVAILABLE_IN_3_20
void       gtk_widget_queue_allocate      (GtkWidget           *widget);
GDK_AVAILABLE_IN_3_8
GdkFrameClock* gtk_widget_get_frame_clock (GtkWidget           *widget);

GDK_DEPRECATED_IN_3_0_FOR(gtk_widget_get_preferred_size)
void       gtk_widget_size_request        (GtkWidget           *widget,
                                           GtkRequisition      *requisition);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_size_allocate	  (GtkWidget	       *widget,
					   GtkAllocation       *allocation);
GDK_AVAILABLE_IN_3_10
void	   gtk_widget_size_allocate_with_baseline	  (GtkWidget	       *widget,
							   GtkAllocation       *allocation,
							   gint                 baseline);

GDK_AVAILABLE_IN_ALL
GtkSizeRequestMode  gtk_widget_get_request_mode               (GtkWidget      *widget);
GDK_AVAILABLE_IN_ALL
void                gtk_widget_get_preferred_width            (GtkWidget      *widget,
                                                               gint           *minimum_width,
                                                               gint           *natural_width);
GDK_AVAILABLE_IN_ALL
void                gtk_widget_get_preferred_height_for_width (GtkWidget      *widget,
                                                               gint            width,
                                                               gint           *minimum_height,
                                                               gint           *natural_height);
GDK_AVAILABLE_IN_ALL
void                gtk_widget_get_preferred_height           (GtkWidget      *widget,
                                                               gint           *minimum_height,
                                                               gint           *natural_height);
GDK_AVAILABLE_IN_ALL
void                gtk_widget_get_preferred_width_for_height (GtkWidget      *widget,
                                                               gint            height,
                                                               gint           *minimum_width,
                                                               gint           *natural_width);
GDK_AVAILABLE_IN_3_10
void   gtk_widget_get_preferred_height_and_baseline_for_width (GtkWidget     *widget,
							       gint           width,
							       gint          *minimum_height,
							       gint          *natural_height,
							       gint          *minimum_baseline,
							       gint          *natural_baseline);
GDK_AVAILABLE_IN_ALL
void                gtk_widget_get_preferred_size             (GtkWidget      *widget,
                                                               GtkRequisition *minimum_size,
                                                               GtkRequisition *natural_size);

GDK_DEPRECATED_IN_3_0_FOR(gtk_widget_get_preferred_size)
void       gtk_widget_get_child_requisition (GtkWidget         *widget,
                                             GtkRequisition    *requisition);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_add_accelerator	  (GtkWidget           *widget,
					   const char         *accel_signal,
					   GtkAccelGroup       *accel_group,
					   guint                accel_key,
					   GdkModifierType      accel_mods,
					   GtkAccelFlags        accel_flags);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_remove_accelerator  (GtkWidget           *widget,
					   GtkAccelGroup       *accel_group,
					   guint                accel_key,
					   GdkModifierType      accel_mods);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_set_accel_path      (GtkWidget           *widget,
					   const char         *accel_path,
					   GtkAccelGroup       *accel_group);
GDK_AVAILABLE_IN_ALL
GList*     gtk_widget_list_accel_closures (GtkWidget	       *widget);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_can_activate_accel  (GtkWidget           *widget,
                                           guint                signal_id);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_mnemonic_activate   (GtkWidget           *widget,
					   gboolean             group_cycling);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_event		  (GtkWidget	       *widget,
					   GdkEvent	       *event);
GDK_AVAILABLE_IN_ALL
gint       gtk_widget_send_expose         (GtkWidget           *widget,
					   GdkEvent            *event);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_send_focus_change   (GtkWidget           *widget,
                                           GdkEvent            *event);

GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_activate		     (GtkWidget	       *widget);
     
GDK_DEPRECATED_IN_3_14
void	   gtk_widget_reparent		  (GtkWidget	       *widget,
					   GtkWidget	       *new_parent);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_intersect		  (GtkWidget	       *widget,
					   const GdkRectangle  *area,
					   GdkRectangle	       *intersection);
GDK_DEPRECATED_IN_3_14
cairo_region_t *gtk_widget_region_intersect	  (GtkWidget	       *widget,
					   const cairo_region_t     *region);

GDK_AVAILABLE_IN_ALL
void	gtk_widget_freeze_child_notify	  (GtkWidget	       *widget);
GDK_AVAILABLE_IN_ALL
void	gtk_widget_child_notify		  (GtkWidget	       *widget,
					   const char	       *child_property);
GDK_AVAILABLE_IN_ALL
void	gtk_widget_thaw_child_notify	  (GtkWidget	       *widget);

GDK_AVAILABLE_IN_ALL
void       gtk_widget_set_can_focus       (GtkWidget           *widget,
                                           gboolean             can_focus);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_get_can_focus       (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_has_focus           (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_is_focus            (GtkWidget           *widget);
GDK_AVAILABLE_IN_3_2
gboolean   gtk_widget_has_visible_focus   (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_grab_focus          (GtkWidget           *widget);
GDK_AVAILABLE_IN_3_20
void       gtk_widget_set_focus_on_click  (GtkWidget           *widget,
                                           gboolean             focus_on_click);
GDK_AVAILABLE_IN_3_20
gboolean   gtk_widget_get_focus_on_click  (GtkWidget           *widget);

GDK_AVAILABLE_IN_ALL
void       gtk_widget_set_can_default     (GtkWidget           *widget,
                                           gboolean             can_default);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_get_can_default     (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_has_default         (GtkWidget           *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_grab_default        (GtkWidget           *widget);

GDK_AVAILABLE_IN_ALL
void      gtk_widget_set_receives_default (GtkWidget           *widget,
                                           gboolean             receives_default);
GDK_AVAILABLE_IN_ALL
gboolean  gtk_widget_get_receives_default (GtkWidget           *widget);

GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_has_grab            (GtkWidget           *widget);

GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_device_is_shadowed  (GtkWidget           *widget,
                                           GdkDevice           *device);


GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_name               (GtkWidget    *widget,
							 const char  *name);
GDK_AVAILABLE_IN_ALL
const char *         gtk_widget_get_name               (GtkWidget    *widget);

GDK_DEPRECATED_IN_3_0_FOR(gtk_widget_set_state_flags)
void                  gtk_widget_set_state              (GtkWidget    *widget,
							 GtkStateType  state);

GDK_DEPRECATED_IN_3_0_FOR(gtk_widget_get_state_flags)
GtkStateType          gtk_widget_get_state              (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_state_flags        (GtkWidget     *widget,
                                                         GtkStateFlags  flags,
                                                         gboolean       clear);
GDK_AVAILABLE_IN_ALL
void                  gtk_widget_unset_state_flags      (GtkWidget     *widget,
                                                         GtkStateFlags  flags);
GDK_AVAILABLE_IN_ALL
GtkStateFlags         gtk_widget_get_state_flags        (GtkWidget     *widget);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_sensitive          (GtkWidget    *widget,
							 gboolean      sensitive);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_get_sensitive          (GtkWidget    *widget);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_is_sensitive           (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_visible            (GtkWidget    *widget,
                                                         gboolean      visible);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_get_visible            (GtkWidget    *widget);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_is_visible             (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_has_window         (GtkWidget    *widget,
                                                         gboolean      has_window);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_get_has_window         (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_is_toplevel            (GtkWidget    *widget);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_is_drawable            (GtkWidget    *widget);
GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_realized           (GtkWidget    *widget,
                                                         gboolean      realized);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_get_realized           (GtkWidget    *widget);
GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_mapped             (GtkWidget    *widget,
                                                         gboolean      mapped);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_get_mapped             (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_app_paintable      (GtkWidget    *widget,
							 gboolean      app_paintable);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_get_app_paintable      (GtkWidget    *widget);

GDK_DEPRECATED_IN_3_14
void                  gtk_widget_set_double_buffered    (GtkWidget    *widget,
							 gboolean      double_buffered);
GDK_DEPRECATED_IN_3_14
gboolean              gtk_widget_get_double_buffered    (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_redraw_on_allocate (GtkWidget    *widget,
							 gboolean      redraw_on_allocate);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_parent             (GtkWidget    *widget,
							 GtkWidget    *parent);
GDK_AVAILABLE_IN_ALL
GtkWidget           * gtk_widget_get_parent             (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_parent_window      (GtkWidget    *widget,
							 GdkWindow    *parent_window);
GDK_AVAILABLE_IN_ALL
GdkWindow           * gtk_widget_get_parent_window      (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_child_visible      (GtkWidget    *widget,
							 gboolean      is_visible);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_widget_get_child_visible      (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_window             (GtkWidget    *widget,
                                                         GdkWindow    *window);
GDK_AVAILABLE_IN_ALL
GdkWindow           * gtk_widget_get_window             (GtkWidget    *widget);
GDK_AVAILABLE_IN_3_8
void                  gtk_widget_register_window        (GtkWidget    *widget,
                                                         GdkWindow    *window);
GDK_AVAILABLE_IN_3_8
void                  gtk_widget_unregister_window      (GtkWidget    *widget,
                                                         GdkWindow    *window);

GDK_AVAILABLE_IN_ALL
int                   gtk_widget_get_allocated_width    (GtkWidget     *widget);
GDK_AVAILABLE_IN_ALL
int                   gtk_widget_get_allocated_height   (GtkWidget     *widget);
GDK_AVAILABLE_IN_3_10
int                   gtk_widget_get_allocated_baseline (GtkWidget     *widget);
GDK_AVAILABLE_IN_3_20
void                  gtk_widget_get_allocated_size     (GtkWidget     *widget,
                                                         GtkAllocation *allocation,
                                                         int           *baseline);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_get_allocation         (GtkWidget     *widget,
                                                         GtkAllocation *allocation);
GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_allocation         (GtkWidget     *widget,
                                                         const GtkAllocation *allocation);
GDK_AVAILABLE_IN_3_14
void                  gtk_widget_set_clip               (GtkWidget     *widget,
                                                         const GtkAllocation *clip);
GDK_AVAILABLE_IN_3_14
void                  gtk_widget_get_clip               (GtkWidget     *widget,
                                                         GtkAllocation *clip);

GDK_DEPRECATED_IN_3_0_FOR(gtk_widget_get_preferred_width & gtk_widget_get_preferred_height)

void                  gtk_widget_get_requisition        (GtkWidget     *widget,
                                                         GtkRequisition *requisition);

GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_child_focus         (GtkWidget           *widget,
                                           GtkDirectionType     direction);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_keynav_failed       (GtkWidget           *widget,
                                           GtkDirectionType     direction);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_error_bell          (GtkWidget           *widget);

GDK_AVAILABLE_IN_ALL
void       gtk_widget_set_size_request    (GtkWidget           *widget,
                                           gint                 width,
                                           gint                 height);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_get_size_request    (GtkWidget           *widget,
                                           gint                *width,
                                           gint                *height);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_set_events	  (GtkWidget	       *widget,
					   gint			events);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_add_events          (GtkWidget           *widget,
					   gint	                events);
GDK_AVAILABLE_IN_ALL
void	   gtk_widget_set_device_events	  (GtkWidget	       *widget,
                                           GdkDevice           *device,
					   GdkEventMask		events);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_add_device_events   (GtkWidget           *widget,
                                           GdkDevice           *device,
					   GdkEventMask         events);
GDK_AVAILABLE_IN_3_8
void	   gtk_widget_set_opacity	  (GtkWidget	       *widget,
					   double		opacity);
GDK_AVAILABLE_IN_3_8
double	   gtk_widget_get_opacity	  (GtkWidget	       *widget);

GDK_AVAILABLE_IN_ALL
void       gtk_widget_set_device_enabled  (GtkWidget    *widget,
                                           GdkDevice    *device,
                                           gboolean      enabled);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_get_device_enabled  (GtkWidget    *widget,
                                           GdkDevice    *device);

GDK_AVAILABLE_IN_ALL
GtkWidget*   gtk_widget_get_toplevel	(GtkWidget	*widget);
GDK_AVAILABLE_IN_ALL
GtkWidget*   gtk_widget_get_ancestor	(GtkWidget	*widget,
					 GType		 widget_type);
GDK_AVAILABLE_IN_ALL
GdkVisual*   gtk_widget_get_visual	(GtkWidget	*widget);
GDK_AVAILABLE_IN_ALL
void         gtk_widget_set_visual	(GtkWidget	*widget,
                                         GdkVisual      *visual);

GDK_AVAILABLE_IN_ALL
GdkScreen *   gtk_widget_get_screen      (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_widget_has_screen      (GtkWidget *widget);
GDK_AVAILABLE_IN_3_10
gint          gtk_widget_get_scale_factor (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
GdkDisplay *  gtk_widget_get_display     (GtkWidget *widget);
GDK_DEPRECATED_IN_3_12
GdkWindow *   gtk_widget_get_root_window (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
GtkSettings*  gtk_widget_get_settings    (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
GtkClipboard *gtk_widget_get_clipboard   (GtkWidget *widget,
					  GdkAtom    selection);


/* Expand flags and related support */
GDK_AVAILABLE_IN_ALL
gboolean gtk_widget_get_hexpand          (GtkWidget      *widget);
GDK_AVAILABLE_IN_ALL
void     gtk_widget_set_hexpand          (GtkWidget      *widget,
                                          gboolean        expand);
GDK_AVAILABLE_IN_ALL
gboolean gtk_widget_get_hexpand_set      (GtkWidget      *widget);
GDK_AVAILABLE_IN_ALL
void     gtk_widget_set_hexpand_set      (GtkWidget      *widget,
                                          gboolean        set);
GDK_AVAILABLE_IN_ALL
gboolean gtk_widget_get_vexpand          (GtkWidget      *widget);
GDK_AVAILABLE_IN_ALL
void     gtk_widget_set_vexpand          (GtkWidget      *widget,
                                          gboolean        expand);
GDK_AVAILABLE_IN_ALL
gboolean gtk_widget_get_vexpand_set      (GtkWidget      *widget);
GDK_AVAILABLE_IN_ALL
void     gtk_widget_set_vexpand_set      (GtkWidget      *widget,
                                          gboolean        set);
GDK_AVAILABLE_IN_ALL
void     gtk_widget_queue_compute_expand (GtkWidget      *widget);
GDK_AVAILABLE_IN_ALL
gboolean gtk_widget_compute_expand       (GtkWidget      *widget,
                                          GtkOrientation  orientation);


/* Multidevice support */
GDK_AVAILABLE_IN_ALL
gboolean         gtk_widget_get_support_multidevice (GtkWidget      *widget);
GDK_AVAILABLE_IN_ALL
void             gtk_widget_set_support_multidevice (GtkWidget      *widget,
                                                     gboolean        support_multidevice);

/* Accessibility support */
GDK_AVAILABLE_IN_3_2
void             gtk_widget_class_set_accessible_type    (GtkWidgetClass     *widget_class,
                                                          GType               type);
GDK_AVAILABLE_IN_3_2
void             gtk_widget_class_set_accessible_role    (GtkWidgetClass     *widget_class,
                                                          AtkRole             role);
GDK_AVAILABLE_IN_ALL
AtkObject*       gtk_widget_get_accessible               (GtkWidget          *widget);


/* Margin and alignment */
GDK_AVAILABLE_IN_ALL
GtkAlign gtk_widget_get_halign        (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
void     gtk_widget_set_halign        (GtkWidget *widget,
                                       GtkAlign   align);
GDK_AVAILABLE_IN_ALL
GtkAlign gtk_widget_get_valign        (GtkWidget *widget);
GDK_AVAILABLE_IN_3_10
GtkAlign gtk_widget_get_valign_with_baseline (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
void     gtk_widget_set_valign        (GtkWidget *widget,
                                       GtkAlign   align);
GDK_DEPRECATED_IN_3_12_FOR(gtk_widget_get_margin_start)
gint     gtk_widget_get_margin_left   (GtkWidget *widget);
GDK_DEPRECATED_IN_3_12_FOR(gtk_widget_set_margin_start)
void     gtk_widget_set_margin_left   (GtkWidget *widget,
                                       gint       margin);
GDK_DEPRECATED_IN_3_12_FOR(gtk_widget_get_margin_end)
gint     gtk_widget_get_margin_right  (GtkWidget *widget);
GDK_DEPRECATED_IN_3_12_FOR(gtk_widget_set_margin_end)
void     gtk_widget_set_margin_right  (GtkWidget *widget,
                                       gint       margin);
GDK_AVAILABLE_IN_3_12
gint     gtk_widget_get_margin_start  (GtkWidget *widget);
GDK_AVAILABLE_IN_3_12
void     gtk_widget_set_margin_start  (GtkWidget *widget,
                                       gint       margin);
GDK_AVAILABLE_IN_3_12
gint     gtk_widget_get_margin_end    (GtkWidget *widget);
GDK_AVAILABLE_IN_3_12
void     gtk_widget_set_margin_end    (GtkWidget *widget,
                                       gint       margin);
GDK_AVAILABLE_IN_ALL
gint     gtk_widget_get_margin_top    (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
void     gtk_widget_set_margin_top    (GtkWidget *widget,
                                       gint       margin);
GDK_AVAILABLE_IN_ALL
gint     gtk_widget_get_margin_bottom (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
void     gtk_widget_set_margin_bottom (GtkWidget *widget,
                                       gint       margin);


GDK_AVAILABLE_IN_ALL
gint	     gtk_widget_get_events	(GtkWidget	*widget);
GDK_AVAILABLE_IN_ALL
GdkEventMask gtk_widget_get_device_events (GtkWidget	*widget,
                                           GdkDevice    *device);
GDK_DEPRECATED_IN_3_4_FOR(gdk_window_get_device_position)
void	     gtk_widget_get_pointer	(GtkWidget	*widget,
					 gint		*x,
					 gint		*y);

GDK_AVAILABLE_IN_ALL
gboolean     gtk_widget_is_ancestor	(GtkWidget	*widget,
					 GtkWidget	*ancestor);

GDK_AVAILABLE_IN_ALL
gboolean     gtk_widget_translate_coordinates (GtkWidget  *src_widget,
					       GtkWidget  *dest_widget,
					       gint        src_x,
					       gint        src_y,
					       gint       *dest_x,
					       gint       *dest_y);

/* Hide widget and return TRUE.
 */
GDK_AVAILABLE_IN_ALL
gboolean     gtk_widget_hide_on_delete	(GtkWidget	*widget);

/* Functions to override widget styling */
GDK_DEPRECATED_IN_3_16
void         gtk_widget_override_color            (GtkWidget     *widget,
                                                   GtkStateFlags  state,
                                                   const GdkRGBA *color);
GDK_DEPRECATED_IN_3_16
void         gtk_widget_override_background_color (GtkWidget     *widget,
                                                   GtkStateFlags  state,
                                                   const GdkRGBA *color);

GDK_DEPRECATED_IN_3_16
void         gtk_widget_override_font             (GtkWidget                  *widget,
                                                   const PangoFontDescription *font_desc);

GDK_DEPRECATED_IN_3_16
void         gtk_widget_override_symbolic_color   (GtkWidget     *widget,
                                                   const char   *name,
                                                   const GdkRGBA *color);
GDK_DEPRECATED_IN_3_16
void         gtk_widget_override_cursor           (GtkWidget       *widget,
                                                   const GdkRGBA   *cursor,
                                                   const GdkRGBA   *secondary_cursor);

GDK_AVAILABLE_IN_ALL
void       gtk_widget_reset_style       (GtkWidget      *widget);

GDK_AVAILABLE_IN_ALL
PangoContext *gtk_widget_create_pango_context (GtkWidget   *widget);
GDK_AVAILABLE_IN_ALL
PangoContext *gtk_widget_get_pango_context    (GtkWidget   *widget);
GDK_AVAILABLE_IN_3_18
void gtk_widget_set_font_options (GtkWidget                  *widget,
                                  const cairo_font_options_t *options);
GDK_AVAILABLE_IN_3_18
const cairo_font_options_t *gtk_widget_get_font_options (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
PangoLayout  *gtk_widget_create_pango_layout  (GtkWidget   *widget,
					       const char *text);

GDK_DEPRECATED_IN_3_10_FOR(gtk_icon_theme_load_icon)
GdkPixbuf    *gtk_widget_render_icon_pixbuf   (GtkWidget   *widget,
                                               const char *stock_id,
                                               GtkIconSize  size);

/* handle composite names for GTK_COMPOSITE_CHILD widgets,
 * the returned name is newly allocated.
 */
GDK_DEPRECATED_IN_3_10_FOR(gtk_widget_class_set_template)
void   gtk_widget_set_composite_name	(GtkWidget	*widget,
					 const char   	*name);
GDK_DEPRECATED_IN_3_10_FOR(gtk_widget_class_set_template)
char* gtk_widget_get_composite_name	(GtkWidget	*widget);
     
/* Push/pop pairs, to change default values upon a widget's creation.
 * This will override the values that got set by the
 * gtk_widget_set_default_* () functions.
 */
GDK_DEPRECATED_IN_3_10_FOR(gtk_widget_class_set_template)
void	     gtk_widget_push_composite_child (void);
GDK_DEPRECATED_IN_3_10_FOR(gtk_widget_class_set_template)
void	     gtk_widget_pop_composite_child  (void);

/* widget style properties
 */
GDK_AVAILABLE_IN_ALL
void gtk_widget_class_install_style_property        (GtkWidgetClass     *klass,
						     GParamSpec         *pspec);
GDK_AVAILABLE_IN_ALL
void gtk_widget_class_install_style_property_parser (GtkWidgetClass     *klass,
						     GParamSpec         *pspec,
						     GtkRcPropertyParser parser);
GDK_AVAILABLE_IN_ALL
GParamSpec*  gtk_widget_class_find_style_property   (GtkWidgetClass     *klass,
						     const char        *property_name);
GDK_AVAILABLE_IN_ALL
GParamSpec** gtk_widget_class_list_style_properties (GtkWidgetClass     *klass,
						     guint              *n_properties);
GDK_AVAILABLE_IN_ALL
void gtk_widget_style_get_property (GtkWidget	     *widget,
				    const char    *property_name,
				    GValue	     *value);
GDK_AVAILABLE_IN_ALL
void gtk_widget_style_get_valist   (GtkWidget	     *widget,
				    const char    *first_property_name,
				    va_list         var_args);
GDK_AVAILABLE_IN_ALL
void gtk_widget_style_get          (GtkWidget	     *widget,
				    const char    *first_property_name,
				    ...) G_GNUC_NULL_TERMINATED;

/* Functions for setting directionality for widgets */

GDK_AVAILABLE_IN_ALL
void             gtk_widget_set_direction         (GtkWidget        *widget,
						   GtkTextDirection  dir);
GDK_AVAILABLE_IN_ALL
GtkTextDirection gtk_widget_get_direction         (GtkWidget        *widget);

GDK_AVAILABLE_IN_ALL
void             gtk_widget_set_default_direction (GtkTextDirection  dir);
GDK_AVAILABLE_IN_ALL
GtkTextDirection gtk_widget_get_default_direction (void);

/* Compositing manager functionality */
GDK_AVAILABLE_IN_ALL
gboolean gtk_widget_is_composited (GtkWidget *widget);

/* Counterpart to gdk_window_shape_combine_region.
 */
GDK_AVAILABLE_IN_ALL
void	     gtk_widget_shape_combine_region (GtkWidget *widget,
                                              cairo_region_t *region);
GDK_AVAILABLE_IN_ALL
void	     gtk_widget_input_shape_combine_region (GtkWidget *widget,
                                                    cairo_region_t *region);

GDK_AVAILABLE_IN_ALL
GList* gtk_widget_list_mnemonic_labels  (GtkWidget *widget);
GDK_AVAILABLE_IN_ALL
void   gtk_widget_add_mnemonic_label    (GtkWidget *widget,
					 GtkWidget *label);
GDK_AVAILABLE_IN_ALL
void   gtk_widget_remove_mnemonic_label (GtkWidget *widget,
					 GtkWidget *label);

GDK_AVAILABLE_IN_ALL
void                  gtk_widget_set_tooltip_window    (GtkWidget   *widget,
                                                        GtkWindow   *custom_window);
GDK_AVAILABLE_IN_ALL
GtkWindow *gtk_widget_get_tooltip_window    (GtkWidget   *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_trigger_tooltip_query (GtkWidget   *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_set_tooltip_text      (GtkWidget   *widget,
                                             const char *text);
GDK_AVAILABLE_IN_ALL
char *    gtk_widget_get_tooltip_text      (GtkWidget   *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_set_tooltip_markup    (GtkWidget   *widget,
                                             const char *markup);
GDK_AVAILABLE_IN_ALL
char *    gtk_widget_get_tooltip_markup    (GtkWidget   *widget);
GDK_AVAILABLE_IN_ALL
void       gtk_widget_set_has_tooltip       (GtkWidget   *widget,
					     gboolean     has_tooltip);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_widget_get_has_tooltip       (GtkWidget   *widget);

GDK_AVAILABLE_IN_ALL
gboolean   gtk_cairo_should_draw_window     (cairo_t     *cr,
                                             GdkWindow   *window);
GDK_AVAILABLE_IN_ALL
void       gtk_cairo_transform_to_window    (cairo_t     *cr,
                                             GtkWidget   *widget,
                                             GdkWindow   *window);

GDK_AVAILABLE_IN_ALL
GType           gtk_requisition_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkRequisition *gtk_requisition_new      (void) G_GNUC_MALLOC;
GDK_AVAILABLE_IN_ALL
GtkRequisition *gtk_requisition_copy     (const GtkRequisition *requisition);
GDK_AVAILABLE_IN_ALL
void            gtk_requisition_free     (GtkRequisition       *requisition);

GDK_AVAILABLE_IN_ALL
gboolean     gtk_widget_in_destruction (GtkWidget *widget);

GDK_AVAILABLE_IN_ALL
GtkStyleContext * gtk_widget_get_style_context (GtkWidget *widget);

GDK_AVAILABLE_IN_ALL
GtkWidgetPath *   gtk_widget_get_path (GtkWidget *widget);

GDK_AVAILABLE_IN_3_20
void              gtk_widget_class_set_css_name (GtkWidgetClass *widget_class,
                                                 const char     *name);
GDK_AVAILABLE_IN_3_20
const char *      gtk_widget_class_get_css_name (GtkWidgetClass *widget_class);

GDK_AVAILABLE_IN_3_4
GdkModifierType   gtk_widget_get_modifier_mask (GtkWidget         *widget,
                                                GdkModifierIntent  intent);

GDK_AVAILABLE_IN_3_6
void                    gtk_widget_insert_action_group                  (GtkWidget    *widget,
                                                                         const char  *name,
                                                                         GActionGroup *group);



GDK_AVAILABLE_IN_3_8
guint gtk_widget_add_tick_callback (GtkWidget       *widget,
                                    GtkTickCallback  callback,
                                    gpointer         user_data,
                                    GDestroyNotify   notify);

GDK_AVAILABLE_IN_3_8
void gtk_widget_remove_tick_callback (GtkWidget       *widget,
                                      guint            id);

/**
 * gtk_widget_class_bind_template_callback:
 * @widget_class: a #GtkWidgetClass
 * @callback: the callback symbol
 *
 * Binds a callback function defined in a template to the @widget_class.
 *
 * This macro is a convenience wrapper around the
 * gtk_widget_class_bind_template_callback_full() function.
 *
 * Since: 3.10
 */

/**
 * gtk_widget_class_bind_template_child:
 * @widget_class: a #GtkWidgetClass
 * @TypeName: the type name of this widget
 * @member_name: name of the instance member in the instance struct for @data_type
 *
 * Binds a child widget defined in a template to the @widget_class.
 *
 * This macro is a convenience wrapper around the
 * gtk_widget_class_bind_template_child_full() function.
 *
 * This macro will use the offset of the @member_name inside the @TypeName
 * instance structure.
 *
 * Since: 3.10
 */

/**
 * gtk_widget_class_bind_template_child_internal:
 * @widget_class: a #GtkWidgetClass
 * @TypeName: the type name, in CamelCase
 * @member_name: name of the instance member in the instance struct for @data_type
 *
 * Binds a child widget defined in a template to the @widget_class, and
 * also makes it available as an internal child in GtkBuilder, under the
 * name @member_name.
 *
 * This macro is a convenience wrapper around the
 * gtk_widget_class_bind_template_child_full() function.
 *
 * This macro will use the offset of the @member_name inside the @TypeName
 * instance structure.
 *
 * Since: 3.10
 */

/**
 * gtk_widget_class_bind_template_child_private:
 * @widget_class: a #GtkWidgetClass
 * @TypeName: the type name of this widget
 * @member_name: name of the instance private member in the private struct for @data_type
 *
 * Binds a child widget defined in a template to the @widget_class.
 *
 * This macro is a convenience wrapper around the
 * gtk_widget_class_bind_template_child_full() function.
 *
 * This macro will use the offset of the @member_name inside the @TypeName
 * private data structure (it uses G_PRIVATE_OFFSET(), so the private struct
 * must be added with G_ADD_PRIVATE()).
 *
 * Since: 3.10
 */

/**
 * gtk_widget_class_bind_template_child_internal_private:
 * @widget_class: a #GtkWidgetClass
 * @TypeName: the type name, in CamelCase
 * @member_name: name of the instance private member on the private struct for @data_type
 *
 * Binds a child widget defined in a template to the @widget_class, and
 * also makes it available as an internal child in GtkBuilder, under the
 * name @member_name.
 *
 * This macro is a convenience wrapper around the
 * gtk_widget_class_bind_template_child_full() function.
 *
 * This macro will use the offset of the @member_name inside the @TypeName
 * private data structure.
 *
 * Since: 3.10
 */

GDK_AVAILABLE_IN_3_10
void    gtk_widget_init_template                        (GtkWidget             *widget);
GDK_AVAILABLE_IN_3_10
GObject *gtk_widget_get_template_child                  (GtkWidget             *widget,
						         GType                  widget_type,
						         const char           *name);
GDK_AVAILABLE_IN_3_10
void    gtk_widget_class_set_template                   (GtkWidgetClass        *widget_class,
						         GBytes                *template_bytes);
GDK_AVAILABLE_IN_3_10
void    gtk_widget_class_set_template_from_resource     (GtkWidgetClass        *widget_class,
						         const char           *resource_name);
GDK_AVAILABLE_IN_3_10
void    gtk_widget_class_bind_template_callback_full    (GtkWidgetClass        *widget_class,
						         const char           *callback_name,
						         GCallback              callback_symbol);
GDK_AVAILABLE_IN_3_10
void    gtk_widget_class_set_connect_func               (GtkWidgetClass        *widget_class,
						         GtkBuilderConnectFunc  connect_func,
						         gpointer               connect_data,
						         GDestroyNotify         connect_data_destroy);
GDK_AVAILABLE_IN_3_10
void    gtk_widget_class_bind_template_child_full       (GtkWidgetClass        *widget_class,
						         const char           *name,
						         gboolean               internal_child,
						         gssize                 struct_offset);

GDK_AVAILABLE_IN_3_16
GActionGroup           *gtk_widget_get_action_group     (GtkWidget             *widget,
                                                         const char           *prefix);

GDK_AVAILABLE_IN_3_16
const char **          gtk_widget_list_action_prefixes (GtkWidget             *widget);

GDK_AVAILABLE_IN_3_18
void                    gtk_widget_set_font_map         (GtkWidget             *widget,
                                                         PangoFontMap          *font_map);
GDK_AVAILABLE_IN_3_18
PangoFontMap *          gtk_widget_get_font_map         (GtkWidget             *widget);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkWidget, g_object_unref)
G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkRequisition, gtk_requisition_free)

G_END_DECLS

#endif /* __GTK_WIDGET_H__ */
#define headerfilename "gtk/./gtkapplication.h"
/* file: gtk/./gtkapplication.h */
/*
 * Copyright © 2010 Codethink Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#ifndef __GTK_APPLICATION_H__
#define __GTK_APPLICATION_H__



#include <gtk/gtkwidget.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define GTK_TYPE_APPLICATION()            (gtk_application_get_type ())
#define GTK_APPLICATION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_APPLICATION, GtkApplication))
#define GTK_APPLICATION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_APPLICATION, GtkApplicationClass))
#define GTK_IS_APPLICATION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_APPLICATION))
#define GTK_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_APPLICATION))
#define GTK_APPLICATION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_APPLICATION, GtkApplicationClass))



/**
 * GtkApplicationClass:
 * @parent_class: The parent class.
 * @window_added: Signal emitted when a #GtkWindow is added to
 *    application through gtk_application_add_window().
 * @window_removed: Signal emitted when a #GtkWindow is removed from
 *    application, either as a side-effect of being destroyed or
 *    explicitly through gtk_application_remove_window().
 */

GDK_AVAILABLE_IN_ALL
GType            gtk_application_get_type      (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkApplication * gtk_application_new           (const char       *application_id,
                                                GApplicationFlags  flags);

GDK_AVAILABLE_IN_ALL
void             gtk_application_add_window    (GtkApplication    *application,
                                                GtkWindow         *window);

GDK_AVAILABLE_IN_ALL
void             gtk_application_remove_window (GtkApplication    *application,
                                                GtkWindow         *window);
GDK_AVAILABLE_IN_ALL
GList *          gtk_application_get_windows   (GtkApplication    *application);

GDK_AVAILABLE_IN_3_4
GMenuModel *     gtk_application_get_app_menu  (GtkApplication    *application);
GDK_AVAILABLE_IN_3_4
void             gtk_application_set_app_menu  (GtkApplication    *application,
                                                GMenuModel        *app_menu);

GDK_AVAILABLE_IN_3_4
GMenuModel *     gtk_application_get_menubar   (GtkApplication    *application);
GDK_AVAILABLE_IN_3_4
void             gtk_application_set_menubar   (GtkApplication    *application,
                                                GMenuModel        *menubar);

GDK_DEPRECATED_IN_3_14_FOR(gtk_application_set_accels_for_action)
void             gtk_application_add_accelerator    (GtkApplication  *application,
                                                     const char     *accelerator,
                                                     const char     *action_name,
                                                     GVariant        *parameter);

GDK_DEPRECATED_IN_3_14_FOR(gtk_application_set_accels_for_action)
void             gtk_application_remove_accelerator (GtkApplication *application,
                                                     const char    *action_name,
                                                     GVariant       *parameter);

typedef enum
{
  GTK_APPLICATION_INHIBIT_LOGOUT  = (1 << 0),
  GTK_APPLICATION_INHIBIT_SWITCH  = (1 << 1),
  GTK_APPLICATION_INHIBIT_SUSPEND = (1 << 2),
  GTK_APPLICATION_INHIBIT_IDLE    = (1 << 3)
} GtkApplicationInhibitFlags;
struct GtkContainerClass
{
  GtkWidgetClass parent_class;

  /*< public >*/

  void    (*add)       		(GtkContainer	 *container,
				 GtkWidget	 *widget);
  void    (*remove)    		(GtkContainer	 *container,
				 GtkWidget	 *widget);
  void    (*check_resize)	(GtkContainer	 *container);
  void    (*forall)    		(GtkContainer	 *container,
				 gboolean	  include_internals,
				 GtkCallback	  callback,
				 gpointer	  callback_data);
  void    (*set_focus_child)	(GtkContainer	 *container,
				 GtkWidget	 *child);
  GType   (*child_type)		(GtkContainer	 *container);
  char*  (*composite_name)	(GtkContainer	 *container,
				 GtkWidget	 *child);
  void    (*set_child_property) (GtkContainer    *container,
				 GtkWidget       *child,
				 guint            property_id,
				 const GValue    *value,
				 GParamSpec      *pspec);
  void    (*get_child_property) (GtkContainer    *container,
                                 GtkWidget       *child,
				 guint            property_id,
				 GValue          *value,
				 GParamSpec      *pspec);
  GtkWidgetPath * (*get_path_for_child) (GtkContainer *container,
                                         GtkWidget    *child);


  /*< private >*/

  unsigned int _handle_border_width : 1;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};

GDK_AVAILABLE_IN_3_4
guint            gtk_application_inhibit            (GtkApplication             *application,
                                                     GtkWindow                  *window,
                                                     GtkApplicationInhibitFlags  flags,
                                                     const char                *reason);
GDK_AVAILABLE_IN_3_4
void             gtk_application_uninhibit          (GtkApplication             *application,
                                                     guint                       cookie);
GDK_AVAILABLE_IN_3_4
gboolean         gtk_application_is_inhibited       (GtkApplication             *application,
                                                     GtkApplicationInhibitFlags  flags);

GDK_AVAILABLE_IN_3_6
GtkWindow *      gtk_application_get_window_by_id   (GtkApplication             *application,
                                                     guint                       id);

GDK_AVAILABLE_IN_3_6
GtkWindow *      gtk_application_get_active_window  (GtkApplication             *application);

GDK_AVAILABLE_IN_3_12
char **         gtk_application_list_action_descriptions        (GtkApplication       *application);

GDK_AVAILABLE_IN_3_12
char **         gtk_application_get_accels_for_action           (GtkApplication       *application,
                                                                  const char          *detailed_action_name);
GDK_AVAILABLE_IN_3_14
char **         gtk_application_get_actions_for_accel           (GtkApplication       *application,
                                                                  const char          *accel);


GDK_AVAILABLE_IN_3_12
void             gtk_application_set_accels_for_action           (GtkApplication       *application,
                                                                  const char          *detailed_action_name,
                                                                  const char * const  *accels);

GDK_AVAILABLE_IN_3_14
gboolean         gtk_application_prefers_app_menu                (GtkApplication       *application);

GDK_AVAILABLE_IN_3_14
GMenu *          gtk_application_get_menu_by_id                  (GtkApplication       *application,
                                                                  const char          *id);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkApplication, g_object_unref)

G_END_DECLS

#endif /* __GTK_APPLICATION_H__ */
#define headerfilename "gtk/./gtkcontainer.h"
/* file: gtk/./gtkcontainer.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_CONTAINER_H__
#define __GTK_CONTAINER_H__




#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_CONTAINER()              (gtk_container_get_type ())
#define GTK_CONTAINER(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CONTAINER, GtkContainer))
#define GTK_CONTAINER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CONTAINER, GtkContainerClass))
#define GTK_IS_CONTAINER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CONTAINER))
#define GTK_IS_CONTAINER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CONTAINER))
#define GTK_CONTAINER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CONTAINER, GtkContainerClass))




/**
 * GtkContainerClass:
 * @parent_class: The parent class.
 * @add: Signal emitted when a widget is added to container.
 * @remove: Signal emitted when a widget is removed from container.
 * @check_resize: Signal emitted when a size recalculation is needed.
 * @forall: Invokes callback on each child of container.
 * @set_focus_child: Sets the focused child of container.
 * @child_type: Returns the type of the children supported by the container.
 * @composite_name: Gets a widget’s composite name. Deprecated: 3.10.
 * @set_child_property: Set a property on a child of container.
 * @get_child_property: Get a property from a child of container.
 * @get_path_for_child: Get path representing entire widget hierarchy
 *    from the toplevel down to and including @child.
 *
 * Base class for containers.
 */


/**
 * GtkResizeMode:
 * @GTK_RESIZE_PARENT: Pass resize request to the parent
 * @GTK_RESIZE_QUEUE: Queue resizes on this widget
 * @GTK_RESIZE_IMMEDIATE: Resize immediately. Deprecated.
 */
typedef enum
{
  GTK_RESIZE_PARENT,
  GTK_RESIZE_QUEUE,
  GTK_RESIZE_IMMEDIATE
} GtkResizeMode;
struct GtkBinClass
{
  GtkContainerClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};
typedef struct GtkAdjustmentPrivate{} GtkAdjustmentPrivate;
struct GtkAdjustment
{
  GInitiallyUnowned parent_instance;

  GtkAdjustmentPrivate *priv;
};


/* Application-level methods */

GDK_AVAILABLE_IN_ALL
GType   gtk_container_get_type		 (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
void    gtk_container_set_border_width	 (GtkContainer	   *container,
					  guint		    border_width);
GDK_AVAILABLE_IN_ALL
guint   gtk_container_get_border_width   (GtkContainer     *container);
GDK_AVAILABLE_IN_ALL
void    gtk_container_add		 (GtkContainer	   *container,
					  GtkWidget	   *widget);
GDK_AVAILABLE_IN_ALL
void    gtk_container_remove		 (GtkContainer	   *container,
					  GtkWidget	   *widget);

GDK_DEPRECATED_IN_3_12
void    gtk_container_set_resize_mode    (GtkContainer     *container,
					  GtkResizeMode     resize_mode);
GDK_DEPRECATED_IN_3_12
GtkResizeMode gtk_container_get_resize_mode (GtkContainer     *container);

GDK_AVAILABLE_IN_ALL
void    gtk_container_check_resize       (GtkContainer     *container);

GDK_AVAILABLE_IN_ALL
void     gtk_container_foreach      (GtkContainer       *container,
				     GtkCallback         callback,
				     gpointer            callback_data);
GDK_AVAILABLE_IN_ALL
GList*   gtk_container_get_children     (GtkContainer       *container);

GDK_AVAILABLE_IN_ALL
void     gtk_container_propagate_draw   (GtkContainer   *container,
					 GtkWidget      *child,
					 cairo_t        *cr);

GDK_AVAILABLE_IN_ALL
void     gtk_container_set_focus_chain  (GtkContainer   *container,
                                         GList          *focusable_widgets);
GDK_AVAILABLE_IN_ALL
gboolean gtk_container_get_focus_chain  (GtkContainer   *container,
					 GList         **focusable_widgets);
GDK_AVAILABLE_IN_ALL
void     gtk_container_unset_focus_chain (GtkContainer  *container);

#define GTK_IS_RESIZE_CONTAINER(widget) (GTK_IS_CONTAINER (widget) && \
                                        (gtk_container_get_resize_mode (GTK_CONTAINER (widget)) != GTK_RESIZE_PARENT))

/* Widget-level methods */

GDK_DEPRECATED_IN_3_14
void   gtk_container_set_reallocate_redraws (GtkContainer    *container,
					     gboolean         needs_redraws);
GDK_AVAILABLE_IN_ALL
void   gtk_container_set_focus_child	   (GtkContainer     *container,
					    GtkWidget	     *child);
GDK_AVAILABLE_IN_ALL
GtkWidget *
       gtk_container_get_focus_child	   (GtkContainer     *container);
GDK_AVAILABLE_IN_ALL
void   gtk_container_set_focus_vadjustment (GtkContainer     *container,
					    GtkAdjustment    *adjustment);
GDK_AVAILABLE_IN_ALL
GtkAdjustment *gtk_container_get_focus_vadjustment (GtkContainer *container);
GDK_AVAILABLE_IN_ALL
void   gtk_container_set_focus_hadjustment (GtkContainer     *container,
					    GtkAdjustment    *adjustment);
GDK_AVAILABLE_IN_ALL
GtkAdjustment *gtk_container_get_focus_hadjustment (GtkContainer *container);

GDK_DEPRECATED_IN_3_10
void    gtk_container_resize_children      (GtkContainer     *container);

GDK_AVAILABLE_IN_ALL
GType   gtk_container_child_type	   (GtkContainer     *container);


GDK_AVAILABLE_IN_ALL
void         gtk_container_class_install_child_property (GtkContainerClass *cclass,
							 guint		    property_id,
							 GParamSpec	   *pspec);
GDK_AVAILABLE_IN_3_18
void         gtk_container_class_install_child_properties (GtkContainerClass *cclass,
                                                           guint              n_pspecs,
                                                           GParamSpec       **pspecs);
GDK_AVAILABLE_IN_ALL
GParamSpec*  gtk_container_class_find_child_property	(GObjectClass	   *cclass,
							 const char	   *property_name);
GDK_AVAILABLE_IN_ALL
GParamSpec** gtk_container_class_list_child_properties	(GObjectClass	   *cclass,
							 guint		   *n_properties);
GDK_AVAILABLE_IN_ALL
void         gtk_container_add_with_properties		(GtkContainer	   *container,
							 GtkWidget	   *widget,
							 const char	   *first_prop_name,
							 ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
void         gtk_container_child_set			(GtkContainer	   *container,
							 GtkWidget	   *child,
							 const char	   *first_prop_name,
							 ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
void         gtk_container_child_get			(GtkContainer	   *container,
							 GtkWidget	   *child,
							 const char	   *first_prop_name,
							 ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
void         gtk_container_child_set_valist		(GtkContainer	   *container,
							 GtkWidget	   *child,
							 const char	   *first_property_name,
							 va_list	    var_args);
GDK_AVAILABLE_IN_ALL
void         gtk_container_child_get_valist		(GtkContainer	   *container,
							 GtkWidget	   *child,
							 const char	   *first_property_name,
							 va_list	    var_args);
GDK_AVAILABLE_IN_ALL
void	     gtk_container_child_set_property		(GtkContainer	   *container,
							 GtkWidget	   *child,
							 const char	   *property_name,
							 const GValue	   *value);
GDK_AVAILABLE_IN_ALL
void	     gtk_container_child_get_property		(GtkContainer	   *container,
							 GtkWidget	   *child,
							 const char	   *property_name,
	                                                 GValue		   *value);

GDK_AVAILABLE_IN_3_2
void gtk_container_child_notify (GtkContainer *container,
                                 GtkWidget    *child,
                                 const char  *child_property);

GDK_AVAILABLE_IN_3_18
void gtk_container_child_notify_by_pspec (GtkContainer *container,
                                          GtkWidget    *child,
                                          GParamSpec   *pspec);

/**
 * GTK_CONTAINER_WARN_INVALID_CHILD_PROPERTY_ID:
 * @object: the #GObject on which set_child_property() or get_child_property()
 *  was called
 * @property_id: the numeric id of the property
 * @pspec: the #GParamSpec of the property
 *
 * This macro should be used to emit a standard warning about unexpected
 * properties in set_child_property() and get_child_property() implementations.
 */
#define GTK_CONTAINER_WARN_INVALID_CHILD_PROPERTY_ID(object, property_id, pspec) \
    G_OBJECT_WARN_INVALID_PSPEC ((object), "child property", (property_id), (pspec))


GDK_AVAILABLE_IN_ALL
void    gtk_container_forall		     (GtkContainer *container,
					      GtkCallback   callback,
					      gpointer	    callback_data);

GDK_AVAILABLE_IN_ALL
void    gtk_container_class_handle_border_width (GtkContainerClass *klass);

GDK_AVAILABLE_IN_ALL
GtkWidgetPath * gtk_container_get_path_for_child (GtkContainer      *container,
                                                  GtkWidget         *child);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkContainer, g_object_unref)

G_END_DECLS

#endif /* __GTK_CONTAINER_H__ */
#define headerfilename "gtk/./gtkbin.h"
/* file: gtk/./gtkbin.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_BIN_H__
#define __GTK_BIN_H__




#include <gtk/gtkcontainer.h>

G_BEGIN_DECLS

#define GTK_TYPE_BIN()                  (gtk_bin_get_type ())
#define GTK_BIN(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_BIN, GtkBin))
#define GTK_BIN_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_BIN, GtkBinClass))
#define GTK_IS_BIN(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_BIN))
#define GTK_IS_BIN_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_BIN))
#define GTK_BIN_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_BIN, GtkBinClass))




/**
 * GtkBinClass:
 * @parent_class: The parent class.
 */
struct GtkWindowClass
{
  GtkBinClass parent_class;

  /*< public >*/

  void     (* set_focus)   (GtkWindow *window,
                            GtkWidget *focus);

  /* G_SIGNAL_ACTION signals for keybindings */

  void     (* activate_focus)   (GtkWindow *window);
  void     (* activate_default) (GtkWindow *window);
  void	   (* keys_changed)     (GtkWindow *window);
  gboolean (* enable_debugging) (GtkWindow *window,
                                 gboolean   toggle);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
};


GDK_AVAILABLE_IN_ALL
GType      gtk_bin_get_type  (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_bin_get_child (GtkBin *bin);

void       _gtk_bin_set_child (GtkBin    *bin,
                               GtkWidget *widget);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkBin, g_object_unref)

G_END_DECLS

#endif /* __GTK_BIN_H__ */
#define headerfilename "gtk/./gtkwindow.h"
/* file: gtk/./gtkwindow.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_WINDOW_H__
#define __GTK_WINDOW_H__




#include <gtk/gtkapplication.h>
#include <gtk/gtkaccelgroup.h>
#include <gtk/gtkbin.h>

G_BEGIN_DECLS

#define GTK_TYPE_WINDOW()			(gtk_window_get_type ())
#define GTK_WINDOW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_WINDOW, GtkWindow))
#define GTK_WINDOW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_WINDOW, GtkWindowClass))
#define GTK_IS_WINDOW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_WINDOW))
#define GTK_IS_WINDOW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_WINDOW))
#define GTK_WINDOW_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_WINDOW, GtkWindowClass))

typedef struct GtkWindowGeometryInfo{} GtkWindowGeometryInfo;
typedef struct GtkWindowGroupPrivate{} GtkWindowGroupPrivate;


/**
 * GtkWindowClass:
 * @parent_class: The parent class.
 * @set_focus: Sets child as the focus widget for the window.
 * @activate_focus: Activates the current focused widget within the window.
 * @activate_default: Activates the default widget for the window.
 * @keys_changed: Signal gets emitted when the set of accelerators or
 *   mnemonics that are associated with window changes.
 * @enable_debugging: Class handler for the #GtkWindow::enable-debugging
 *   keybinding signal. Since: 3.14
 */

/**
 * GtkWindowType:
 * @GTK_WINDOW_TOPLEVEL: A regular window, such as a dialog.
 * @GTK_WINDOW_POPUP: A special window such as a tooltip.
 *
 * A #GtkWindow can be one of these types. Most things you’d consider a
 * “window” should have type #GTK_WINDOW_TOPLEVEL; windows with this type
 * are managed by the window manager and have a frame by default (call
 * gtk_window_set_decorated() to toggle the frame).  Windows with type
 * #GTK_WINDOW_POPUP are ignored by the window manager; window manager
 * keybindings won’t work on them, the window manager won’t decorate the
 * window with a frame, many GTK+ features that rely on the window
 * manager will not work (e.g. resize grips and
 * maximization/minimization). #GTK_WINDOW_POPUP is used to implement
 * widgets such as #GtkMenu or tooltips that you normally don’t think of
 * as windows per se. Nearly all windows should be #GTK_WINDOW_TOPLEVEL.
 * In particular, do not use #GTK_WINDOW_POPUP just to turn off
 * the window borders; use gtk_window_set_decorated() for that.
 */
typedef enum
{
  GTK_WINDOW_TOPLEVEL,
  GTK_WINDOW_POPUP
} GtkWindowType;

/**
 * GtkWindowPosition:
 * @GTK_WIN_POS_NONE: No influence is made on placement.
 * @GTK_WIN_POS_CENTER: Windows should be placed in the center of the screen.
 * @GTK_WIN_POS_MOUSE: Windows should be placed at the current mouse position.
 * @GTK_WIN_POS_CENTER_ALWAYS: Keep window centered as it changes size, etc.
 * @GTK_WIN_POS_CENTER_ON_PARENT: Center the window on its transient
 *  parent (see gtk_window_set_transient_for()).
 *
 * Window placement can be influenced using this enumeration. Note that
 * using #GTK_WIN_POS_CENTER_ALWAYS is almost always a bad idea.
 * It won’t necessarily work well with all window managers or on all windowing systems.
 */
typedef enum
{
  GTK_WIN_POS_NONE,
  GTK_WIN_POS_CENTER,
  GTK_WIN_POS_MOUSE,
  GTK_WIN_POS_CENTER_ALWAYS,
  GTK_WIN_POS_CENTER_ON_PARENT
} GtkWindowPosition;
struct GtkWindowGroup
{
  GObject parent_instance;

  GtkWindowGroupPrivate *priv;
};


GDK_AVAILABLE_IN_ALL
GType      gtk_window_get_type                 (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_window_new                      (GtkWindowType        type);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_title                (GtkWindow           *window,
						const char         *title);
GDK_AVAILABLE_IN_ALL
const char * gtk_window_get_title             (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_wmclass              (GtkWindow           *window,
						const char         *wmclass_name,
						const char         *wmclass_class);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_role                 (GtkWindow           *window,
                                                const char         *role);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_startup_id           (GtkWindow           *window,
                                                const char         *startup_id);
GDK_AVAILABLE_IN_ALL
const char * gtk_window_get_role              (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_add_accel_group          (GtkWindow           *window,
						GtkAccelGroup	    *accel_group);
GDK_AVAILABLE_IN_ALL
void       gtk_window_remove_accel_group       (GtkWindow           *window,
						GtkAccelGroup	    *accel_group);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_position             (GtkWindow           *window,
						GtkWindowPosition    position);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_activate_focus	       (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_focus                (GtkWindow           *window,
						GtkWidget           *focus);
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_window_get_focus                (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_default              (GtkWindow           *window,
						GtkWidget           *default_widget);
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_window_get_default_widget       (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_activate_default	       (GtkWindow           *window);

GDK_AVAILABLE_IN_ALL
void       gtk_window_set_transient_for        (GtkWindow           *window, 
						GtkWindow           *parent);
GDK_AVAILABLE_IN_ALL
GtkWindow *gtk_window_get_transient_for        (GtkWindow           *window);
GDK_AVAILABLE_IN_3_4
void       gtk_window_set_attached_to          (GtkWindow           *window, 
                                                GtkWidget           *attach_widget);
GDK_AVAILABLE_IN_3_4
GtkWidget *gtk_window_get_attached_to          (GtkWindow           *window);
GDK_DEPRECATED_IN_3_8_FOR(gtk_widget_set_opacity)
void       gtk_window_set_opacity              (GtkWindow           *window, 
						gdouble              opacity);
GDK_DEPRECATED_IN_3_8_FOR(gtk_widget_get_opacity)
gdouble    gtk_window_get_opacity              (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_type_hint            (GtkWindow           *window, 
						GdkWindowTypeHint    hint);
GDK_AVAILABLE_IN_ALL
GdkWindowTypeHint gtk_window_get_type_hint     (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_skip_taskbar_hint    (GtkWindow           *window,
                                                gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_skip_taskbar_hint    (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_skip_pager_hint      (GtkWindow           *window,
                                                gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_skip_pager_hint      (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_urgency_hint         (GtkWindow           *window,
                                                gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_urgency_hint         (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_accept_focus         (GtkWindow           *window,
                                                gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_accept_focus         (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_focus_on_map         (GtkWindow           *window,
                                                gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_focus_on_map         (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_destroy_with_parent  (GtkWindow           *window,
                                                gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_destroy_with_parent  (GtkWindow           *window);
GDK_AVAILABLE_IN_3_4
void       gtk_window_set_hide_titlebar_when_maximized (GtkWindow   *window,
                                                        gboolean     setting);
GDK_AVAILABLE_IN_3_4
gboolean   gtk_window_get_hide_titlebar_when_maximized (GtkWindow   *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_mnemonics_visible    (GtkWindow           *window,
                                                gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_mnemonics_visible    (GtkWindow           *window);
GDK_AVAILABLE_IN_3_2
void       gtk_window_set_focus_visible        (GtkWindow           *window,
                                                gboolean             setting);
GDK_AVAILABLE_IN_3_2
gboolean   gtk_window_get_focus_visible        (GtkWindow           *window);

GDK_AVAILABLE_IN_ALL
void       gtk_window_set_resizable            (GtkWindow           *window,
                                                gboolean             resizable);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_resizable            (GtkWindow           *window);

GDK_AVAILABLE_IN_ALL
void       gtk_window_set_gravity              (GtkWindow           *window,
                                                GdkGravity           gravity);
GDK_AVAILABLE_IN_ALL
GdkGravity gtk_window_get_gravity              (GtkWindow           *window);


GDK_AVAILABLE_IN_ALL
void       gtk_window_set_geometry_hints       (GtkWindow           *window,
						GtkWidget           *geometry_widget,
						GdkGeometry         *geometry,
						GdkWindowHints       geom_mask);

GDK_AVAILABLE_IN_ALL
void	   gtk_window_set_screen	       (GtkWindow	    *window,
						GdkScreen	    *screen);
GDK_AVAILABLE_IN_ALL
GdkScreen* gtk_window_get_screen	       (GtkWindow	    *window);

GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_is_active                (GtkWindow           *window);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_has_toplevel_focus       (GtkWindow           *window);

GDK_AVAILABLE_IN_ALL
void       gtk_window_set_decorated            (GtkWindow *window,
                                                gboolean   setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_decorated            (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_deletable            (GtkWindow *window,
                                                gboolean   setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_deletable            (GtkWindow *window);

GDK_AVAILABLE_IN_ALL
void       gtk_window_set_icon_list                (GtkWindow  *window,
                                                    GList      *list);
GDK_AVAILABLE_IN_ALL
GList*     gtk_window_get_icon_list                (GtkWindow  *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_icon                     (GtkWindow  *window,
                                                    GdkPixbuf  *icon);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_icon_name                (GtkWindow   *window,
						    const char *name);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_set_icon_from_file           (GtkWindow   *window,
						    const char *filename,
						    GError     **err);
GDK_AVAILABLE_IN_ALL
GdkPixbuf* gtk_window_get_icon                     (GtkWindow  *window);
GDK_AVAILABLE_IN_ALL
const char * gtk_window_get_icon_name             (GtkWindow  *window);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_default_icon_list        (GList      *list);
GDK_AVAILABLE_IN_ALL
GList*     gtk_window_get_default_icon_list        (void);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_default_icon             (GdkPixbuf  *icon);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_default_icon_name        (const char *name);
GDK_AVAILABLE_IN_ALL
const char * gtk_window_get_default_icon_name     (void);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_set_default_icon_from_file   (const char *filename,
						    GError     **err);

GDK_AVAILABLE_IN_ALL
void       gtk_window_set_auto_startup_notification (gboolean setting);

/* If window is set modal, input will be grabbed when show and released when hide */
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_modal      (GtkWindow *window,
				      gboolean   modal);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_window_get_modal      (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
GList*     gtk_window_list_toplevels (void);
GDK_AVAILABLE_IN_ALL
void       gtk_window_set_has_user_ref_count (GtkWindow *window,
                                              gboolean   setting);

GDK_AVAILABLE_IN_ALL
void     gtk_window_add_mnemonic          (GtkWindow       *window,
					   guint            keyval,
					   GtkWidget       *target);
GDK_AVAILABLE_IN_ALL
void     gtk_window_remove_mnemonic       (GtkWindow       *window,
					   guint            keyval,
					   GtkWidget       *target);
GDK_AVAILABLE_IN_ALL
gboolean gtk_window_mnemonic_activate     (GtkWindow       *window,
					   guint            keyval,
					   GdkModifierType  modifier);
GDK_AVAILABLE_IN_ALL
void     gtk_window_set_mnemonic_modifier (GtkWindow       *window,
					   GdkModifierType  modifier);
GDK_AVAILABLE_IN_ALL
GdkModifierType gtk_window_get_mnemonic_modifier (GtkWindow *window);

GDK_AVAILABLE_IN_ALL
gboolean gtk_window_activate_key          (GtkWindow        *window,
					   GdkEventKey      *event);
GDK_AVAILABLE_IN_ALL
gboolean gtk_window_propagate_key_event   (GtkWindow        *window,
					   GdkEventKey      *event);

GDK_AVAILABLE_IN_ALL
void     gtk_window_present            (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void     gtk_window_present_with_time  (GtkWindow *window,
				        guint32    timestamp);
GDK_AVAILABLE_IN_ALL
void     gtk_window_iconify       (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void     gtk_window_deiconify     (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void     gtk_window_stick         (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void     gtk_window_unstick       (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void     gtk_window_maximize      (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void     gtk_window_unmaximize    (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void     gtk_window_fullscreen    (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void     gtk_window_unfullscreen  (GtkWindow *window);
GDK_AVAILABLE_IN_3_18
void     gtk_window_fullscreen_on_monitor(GtkWindow *window,
                                          GdkScreen *screen,
                                          gint monitor);
GDK_AVAILABLE_IN_3_10
void     gtk_window_close         (GtkWindow *window);
GDK_AVAILABLE_IN_ALL
void     gtk_window_set_keep_above    (GtkWindow *window, gboolean setting);
GDK_AVAILABLE_IN_ALL
void     gtk_window_set_keep_below    (GtkWindow *window, gboolean setting);

GDK_AVAILABLE_IN_ALL
void gtk_window_begin_resize_drag (GtkWindow     *window,
                                   GdkWindowEdge  edge,
                                   gint           button,
                                   gint           root_x,
                                   gint           root_y,
                                   guint32        timestamp);
GDK_AVAILABLE_IN_ALL
void gtk_window_begin_move_drag   (GtkWindow     *window,
                                   gint           button,
                                   gint           root_x,
                                   gint           root_y,
                                   guint32        timestamp);

/* Set initial default size of the window (does not constrain user
 * resize operations)
 */
GDK_AVAILABLE_IN_ALL
void     gtk_window_set_default_size (GtkWindow   *window,
                                      gint         width,
                                      gint         height);
GDK_AVAILABLE_IN_ALL
void     gtk_window_get_default_size (GtkWindow   *window,
                                      gint        *width,
                                      gint        *height);
GDK_AVAILABLE_IN_ALL
void     gtk_window_resize           (GtkWindow   *window,
                                      gint         width,
                                      gint         height);
GDK_AVAILABLE_IN_ALL
void     gtk_window_get_size         (GtkWindow   *window,
                                      gint        *width,
                                      gint        *height);
GDK_AVAILABLE_IN_ALL
void     gtk_window_move             (GtkWindow   *window,
                                      gint         x,
                                      gint         y);
GDK_AVAILABLE_IN_ALL
void     gtk_window_get_position     (GtkWindow   *window,
                                      gint        *root_x,
                                      gint        *root_y);
GDK_DEPRECATED_IN_3_20
gboolean gtk_window_parse_geometry   (GtkWindow   *window,
                                      const char *geometry);

GDK_DEPRECATED_IN_3_20_FOR(gtk_window_set_default_size)
void gtk_window_set_default_geometry (GtkWindow *window,
                                      gint       width,
                                      gint       height);
GDK_DEPRECATED_IN_3_20_FOR(gtk_window_resize)
void gtk_window_resize_to_geometry   (GtkWindow *window,
                                      gint       width,
                                      gint       height);

GDK_AVAILABLE_IN_ALL
GtkWindowGroup *gtk_window_get_group (GtkWindow   *window);
GDK_AVAILABLE_IN_ALL
gboolean gtk_window_has_group        (GtkWindow   *window);

/* Ignore this unless you are writing a GUI builder */
GDK_DEPRECATED_IN_3_10
void     gtk_window_reshow_with_initial_size (GtkWindow *window);

GDK_AVAILABLE_IN_ALL
GtkWindowType gtk_window_get_window_type     (GtkWindow     *window);


GDK_AVAILABLE_IN_ALL
GtkApplication *gtk_window_get_application      (GtkWindow          *window);
GDK_AVAILABLE_IN_ALL
void            gtk_window_set_application      (GtkWindow          *window,
                                                 GtkApplication     *application);


/* Window grips
 */
GDK_DEPRECATED_IN_3_14
void     gtk_window_set_has_resize_grip    (GtkWindow    *window,
                                            gboolean      value);
GDK_DEPRECATED_IN_3_14
gboolean gtk_window_get_has_resize_grip    (GtkWindow    *window);
GDK_DEPRECATED_IN_3_14
gboolean gtk_window_resize_grip_is_visible (GtkWindow    *window);
GDK_DEPRECATED_IN_3_14
gboolean gtk_window_get_resize_grip_area   (GtkWindow    *window,
                                            GdkRectangle *rect);

GDK_AVAILABLE_IN_3_10
void     gtk_window_set_titlebar           (GtkWindow    *window,
                                            GtkWidget    *titlebar);
GDK_AVAILABLE_IN_3_16
GtkWidget *gtk_window_get_titlebar         (GtkWindow    *window);

GDK_AVAILABLE_IN_3_12
gboolean gtk_window_is_maximized           (GtkWindow    *window);

GDK_AVAILABLE_IN_3_14
void     gtk_window_set_interactive_debugging (gboolean enable);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkWindow, g_object_unref)
G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkWindowGroup, g_object_unref)

G_END_DECLS

#endif /* __GTK_WINDOW_H__ */
#define headerfilename "gtk/./gtkdialog.h"
/* file: gtk/./gtkdialog.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_DIALOG_H__
#define __GTK_DIALOG_H__



#include <gtk/gtkwindow.h>

G_BEGIN_DECLS

/**
 * GtkDialogFlags:
 * @GTK_DIALOG_MODAL: Make the constructed dialog modal,
 *     see gtk_window_set_modal()
 * @GTK_DIALOG_DESTROY_WITH_PARENT: Destroy the dialog when its
 *     parent is destroyed, see gtk_window_set_destroy_with_parent()
 * @GTK_DIALOG_USE_HEADER_BAR: Create dialog with actions in header
 *     bar instead of action area. Since 3.12.
 *
 * Flags used to influence dialog construction.
 */
typedef enum
{
  GTK_DIALOG_MODAL               = 1 << 0,
  GTK_DIALOG_DESTROY_WITH_PARENT = 1 << 1,
  GTK_DIALOG_USE_HEADER_BAR      = 1 << 2
} GtkDialogFlags;

/**
 * GtkResponseType:
 * @GTK_RESPONSE_NONE: Returned if an action widget has no response id,
 *     or if the dialog gets programmatically hidden or destroyed
 * @GTK_RESPONSE_REJECT: Generic response id, not used by GTK+ dialogs
 * @GTK_RESPONSE_ACCEPT: Generic response id, not used by GTK+ dialogs
 * @GTK_RESPONSE_DELETE_EVENT: Returned if the dialog is deleted
 * @GTK_RESPONSE_OK: Returned by OK buttons in GTK+ dialogs
 * @GTK_RESPONSE_CANCEL: Returned by Cancel buttons in GTK+ dialogs
 * @GTK_RESPONSE_CLOSE: Returned by Close buttons in GTK+ dialogs
 * @GTK_RESPONSE_YES: Returned by Yes buttons in GTK+ dialogs
 * @GTK_RESPONSE_NO: Returned by No buttons in GTK+ dialogs
 * @GTK_RESPONSE_APPLY: Returned by Apply buttons in GTK+ dialogs
 * @GTK_RESPONSE_HELP: Returned by Help buttons in GTK+ dialogs
 *
 * Predefined values for use as response ids in gtk_dialog_add_button().
 * All predefined values are negative, GTK+ leaves positive values for
 * application-defined response ids.
 */
typedef enum
{
  GTK_RESPONSE_NONE         = -1,
  GTK_RESPONSE_REJECT       = -2,
  GTK_RESPONSE_ACCEPT       = -3,
  GTK_RESPONSE_DELETE_EVENT = -4,
  GTK_RESPONSE_OK           = -5,
  GTK_RESPONSE_CANCEL       = -6,
  GTK_RESPONSE_CLOSE        = -7,
  GTK_RESPONSE_YES          = -8,
  GTK_RESPONSE_NO           = -9,
  GTK_RESPONSE_APPLY        = -10,
  GTK_RESPONSE_HELP         = -11
} GtkResponseType;
typedef struct GtkDialogPrivate{} GtkDialogPrivate;
struct GtkDialog
{
  GtkWindow window;

  /*< private >*/
  GtkDialogPrivate *priv;
};
struct GtkDialogClass
{
  GtkWindowClass parent_class;

  /*< public >*/

  void (* response) (GtkDialog *dialog, gint response_id);

  /* Keybinding signals */

  void (* close)    (GtkDialog *dialog);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


#define GTK_TYPE_DIALOG()                  (gtk_dialog_get_type ())
#define GTK_DIALOG(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_DIALOG, GtkDialog))
#define GTK_DIALOG_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_DIALOG, GtkDialogClass))
#define GTK_IS_DIALOG(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_DIALOG))
#define GTK_IS_DIALOG_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_DIALOG))
#define GTK_DIALOG_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_DIALOG, GtkDialogClass))


typedef struct GtkAboutDialogPrivate{} GtkAboutDialogPrivate;

/**
 * GtkDialog:
 *
 * The #GtkDialog-struct contains only private fields
 * and should not be directly accessed.
 */

/**
 * GtkDialogClass:
 * @parent_class: The parent class.
 * @response: Signal emitted when an action widget is activated.
 * @close: Signal emitted when the user uses a keybinding to close the dialog.
 */
struct GtkAboutDialog
{
  GtkDialog parent_instance;

  /*< private >*/
  GtkAboutDialogPrivate *priv;
};
struct GtkAboutDialogClass
{
  GtkDialogClass parent_class;

  gboolean (*activate_link) (GtkAboutDialog *dialog,
                             const char    *uri);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType      gtk_dialog_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_dialog_new      (void);

GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_dialog_new_with_buttons (const char     *title,
                                        GtkWindow       *parent,
                                        GtkDialogFlags   flags,
                                        const char     *first_button_text,
                                        ...) G_GNUC_NULL_TERMINATED;

GDK_AVAILABLE_IN_ALL
void       gtk_dialog_add_action_widget (GtkDialog   *dialog,
                                         GtkWidget   *child,
                                         gint         response_id);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_dialog_add_button        (GtkDialog   *dialog,
                                         const char *button_text,
                                         gint         response_id);
GDK_AVAILABLE_IN_ALL
void       gtk_dialog_add_buttons       (GtkDialog   *dialog,
                                         const char *first_button_text,
                                         ...) G_GNUC_NULL_TERMINATED;

GDK_AVAILABLE_IN_ALL
void gtk_dialog_set_response_sensitive (GtkDialog *dialog,
                                        gint       response_id,
                                        gboolean   setting);
GDK_AVAILABLE_IN_ALL
void gtk_dialog_set_default_response   (GtkDialog *dialog,
                                        gint       response_id);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_dialog_get_widget_for_response (GtkDialog *dialog,
                                               gint       response_id);
GDK_AVAILABLE_IN_ALL
gint gtk_dialog_get_response_for_widget (GtkDialog *dialog,
                                         GtkWidget *widget);

GDK_DEPRECATED_IN_3_10
gboolean gtk_alternative_dialog_button_order (GdkScreen *screen);
GDK_DEPRECATED_IN_3_10
void     gtk_dialog_set_alternative_button_order (GtkDialog *dialog,
                                                  gint       first_response_id,
                                                  ...);
GDK_DEPRECATED_IN_3_10
void     gtk_dialog_set_alternative_button_order_from_array (GtkDialog *dialog,
                                                             gint       n_params,
                                                             gint      *new_order);

/* Emit response signal */
GDK_AVAILABLE_IN_ALL
void gtk_dialog_response           (GtkDialog *dialog,
                                    gint       response_id);

/* Returns response_id */
GDK_AVAILABLE_IN_ALL
gint gtk_dialog_run                (GtkDialog *dialog);

GDK_DEPRECATED_IN_3_10
GtkWidget * gtk_dialog_get_action_area  (GtkDialog *dialog);
GDK_AVAILABLE_IN_ALL
GtkWidget * gtk_dialog_get_content_area (GtkDialog *dialog);
GDK_AVAILABLE_IN_3_12
GtkWidget * gtk_dialog_get_header_bar   (GtkDialog *dialog);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkDialog, g_object_unref)

G_END_DECLS

#endif /* __GTK_DIALOG_H__ */
#define headerfilename "gtk/./gtkaboutdialog.h"
/* file: gtk/./gtkaboutdialog.h */
/* GTK - The GIMP Toolkit

   Copyright (C) 2001 CodeFactory AB
   Copyright (C) 2001 Anders Carlsson <andersca@codefactory.se>
   Copyright (C) 2003, 2004 Matthias Clasen <mclasen@redhat.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library. If not, see <http://www.gnu.org/licenses/>.

   Author: Anders Carlsson <andersca@codefactory.se>
*/

#ifndef __GTK_ABOUT_DIALOG_H__
#define __GTK_ABOUT_DIALOG_H__



#include <gtk/gtkdialog.h>

G_BEGIN_DECLS

#define GTK_TYPE_ABOUT_DIALOG()            (gtk_about_dialog_get_type ())
#define GTK_ABOUT_DIALOG(object)         (G_TYPE_CHECK_INSTANCE_CAST ((object), GTK_TYPE_ABOUT_DIALOG, GtkAboutDialog))
#define GTK_ABOUT_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ABOUT_DIALOG, GtkAboutDialogClass))
#define GTK_IS_ABOUT_DIALOG(object)      (G_TYPE_CHECK_INSTANCE_TYPE ((object), GTK_TYPE_ABOUT_DIALOG))
#define GTK_IS_ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ABOUT_DIALOG))
#define GTK_ABOUT_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ABOUT_DIALOG, GtkAboutDialogClass))


/**
 * GtkLicense:
 * @GTK_LICENSE_UNKNOWN: No license specified
 * @GTK_LICENSE_CUSTOM: A license text is going to be specified by the
 *   developer
 * @GTK_LICENSE_GPL_2_0: The GNU General Public License, version 2.0 or later
 * @GTK_LICENSE_GPL_3_0: The GNU General Public License, version 3.0 or later
 * @GTK_LICENSE_LGPL_2_1: The GNU Lesser General Public License, version 2.1 or later
 * @GTK_LICENSE_LGPL_3_0: The GNU Lesser General Public License, version 3.0 or later
 * @GTK_LICENSE_BSD: The BSD standard license
 * @GTK_LICENSE_MIT_X11: The MIT/X11 standard license
 * @GTK_LICENSE_ARTISTIC: The Artistic License, version 2.0
 * @GTK_LICENSE_GPL_2_0_ONLY: The GNU General Public License, version 2.0 only. Since 3.12.
 * @GTK_LICENSE_GPL_3_0_ONLY: The GNU General Public License, version 3.0 only. Since 3.12.
 * @GTK_LICENSE_LGPL_2_1_ONLY: The GNU Lesser General Public License, version 2.1 only. Since 3.12.
 * @GTK_LICENSE_LGPL_3_0_ONLY: The GNU Lesser General Public License, version 3.0 only. Since 3.12.
 *
 * The type of license for an application.
 *
 * This enumeration can be expanded at later date.
 *
 * Since: 3.0
 */
typedef enum {
  GTK_LICENSE_UNKNOWN,
  GTK_LICENSE_CUSTOM,

  GTK_LICENSE_GPL_2_0,
  GTK_LICENSE_GPL_3_0,

  GTK_LICENSE_LGPL_2_1,
  GTK_LICENSE_LGPL_3_0,

  GTK_LICENSE_BSD,
  GTK_LICENSE_MIT_X11,

  GTK_LICENSE_ARTISTIC,

  GTK_LICENSE_GPL_2_0_ONLY,
  GTK_LICENSE_GPL_3_0_ONLY,
  GTK_LICENSE_LGPL_2_1_ONLY,
  GTK_LICENSE_LGPL_3_0_ONLY
} GtkLicense;
typedef struct GtkMiscPrivate{} GtkMiscPrivate;

/**
 * GtkAboutDialog:
 *
 * The #GtkAboutDialog-struct contains
 * only private fields and should not be directly accessed.
 */

struct GtkMisc
{
  GtkWidget widget;

  /*< private >*/
  GtkMiscPrivate *priv;
};
struct GtkMiscClass
{
  GtkWidgetClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType                  gtk_about_dialog_get_type               (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget             *gtk_about_dialog_new                    (void);
GDK_AVAILABLE_IN_ALL
void                   gtk_show_about_dialog                   (GtkWindow       *parent,
                                                                const char     *first_property_name,
                                                                ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
const char *          gtk_about_dialog_get_program_name       (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_program_name       (GtkAboutDialog  *about,
                                                                const char     *name);
GDK_AVAILABLE_IN_ALL
const char *          gtk_about_dialog_get_version            (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_version            (GtkAboutDialog  *about,
                                                                const char     *version);
GDK_AVAILABLE_IN_ALL
const char *          gtk_about_dialog_get_copyright          (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_copyright          (GtkAboutDialog  *about,
                                                                const char     *copyright);
GDK_AVAILABLE_IN_ALL
const char *          gtk_about_dialog_get_comments           (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_comments           (GtkAboutDialog  *about,
                                                                const char     *comments);
GDK_AVAILABLE_IN_ALL
const char *          gtk_about_dialog_get_license            (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_license            (GtkAboutDialog  *about,
                                                                const char     *license);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_license_type       (GtkAboutDialog  *about,
                                                                GtkLicense       license_type);
GDK_AVAILABLE_IN_ALL
GtkLicense             gtk_about_dialog_get_license_type       (GtkAboutDialog  *about);

GDK_AVAILABLE_IN_ALL
gboolean               gtk_about_dialog_get_wrap_license       (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_wrap_license       (GtkAboutDialog  *about,
                                                                gboolean         wrap_license);

GDK_AVAILABLE_IN_ALL
const char *          gtk_about_dialog_get_website            (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_website            (GtkAboutDialog  *about,
                                                                const char     *website);
GDK_AVAILABLE_IN_ALL
const char *          gtk_about_dialog_get_website_label      (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_website_label      (GtkAboutDialog  *about,
                                                                const char     *website_label);
GDK_AVAILABLE_IN_ALL
const char* const *   gtk_about_dialog_get_authors            (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_authors            (GtkAboutDialog  *about,
                                                                const char    **authors);
GDK_AVAILABLE_IN_ALL
const char* const *   gtk_about_dialog_get_documenters        (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_documenters        (GtkAboutDialog  *about,
                                                                const char    **documenters);
GDK_AVAILABLE_IN_ALL
const char* const *   gtk_about_dialog_get_artists            (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_artists            (GtkAboutDialog  *about,
                                                                const char    **artists);
GDK_AVAILABLE_IN_ALL
const char *          gtk_about_dialog_get_translator_credits (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_translator_credits (GtkAboutDialog  *about,
                                                                const char     *translator_credits);
GDK_AVAILABLE_IN_ALL
GdkPixbuf             *gtk_about_dialog_get_logo               (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_logo               (GtkAboutDialog  *about,
                                                                GdkPixbuf       *logo);
GDK_AVAILABLE_IN_ALL
const char *          gtk_about_dialog_get_logo_icon_name     (GtkAboutDialog  *about);
GDK_AVAILABLE_IN_ALL
void                   gtk_about_dialog_set_logo_icon_name     (GtkAboutDialog  *about,
                                                                const char     *icon_name);
GDK_AVAILABLE_IN_3_4
void                  gtk_about_dialog_add_credit_section      (GtkAboutDialog  *about,
                                                                const char     *section_name,
                                                                const char    **people);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkAboutDialog, g_object_unref)

G_END_DECLS

#endif /* __GTK_ABOUT_DIALOG_H__ */


#define headerfilename "gtk/deprecated/gtkmisc.h"
/* file: gtk/deprecated/gtkmisc.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_MISC_H__
#define __GTK_MISC_H__




#include <gtk/gtkwidget.h>


G_BEGIN_DECLS

#define GTK_TYPE_MISC()		       (gtk_misc_get_type ())
#define GTK_MISC(obj)		       (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_MISC, GtkMisc))
#define GTK_MISC_CLASS(klass)	       (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_MISC, GtkMiscClass))
#define GTK_IS_MISC(obj)	       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_MISC))
#define GTK_IS_MISC_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MISC))
#define GTK_MISC_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MISC, GtkMiscClass))


typedef struct GtkMenuShellPrivate{} GtkMenuShellPrivate;


struct GtkMenuShell
{
  GtkContainer container;

  /*< private >*/
  GtkMenuShellPrivate *priv;
};
struct GtkMenuShellClass
{
  GtkContainerClass parent_class;

  guint submenu_placement : 1;

  void     (*deactivate)       (GtkMenuShell *menu_shell);
  void     (*selection_done)   (GtkMenuShell *menu_shell);

  void     (*move_current)     (GtkMenuShell *menu_shell,
                                GtkMenuDirectionType direction);
  void     (*activate_current) (GtkMenuShell *menu_shell,
                                gboolean      force_hide);
  void     (*cancel)           (GtkMenuShell *menu_shell);
  void     (*select_item)      (GtkMenuShell *menu_shell,
                                GtkWidget    *menu_item);
  void     (*insert)           (GtkMenuShell *menu_shell,
                                GtkWidget    *child,
                                gint          position);
  gint     (*get_popup_delay)  (GtkMenuShell *menu_shell);
  gboolean (*move_selected)    (GtkMenuShell *menu_shell,
                                gint          distance);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_DEPRECATED_IN_3_14
GType   gtk_misc_get_type      (void) G_GNUC_CONST;
GDK_DEPRECATED_IN_3_14
void	gtk_misc_set_alignment (GtkMisc *misc,
				gfloat	 xalign,
				gfloat	 yalign);
GDK_DEPRECATED_IN_3_14
void    gtk_misc_get_alignment (GtkMisc *misc,
				gfloat  *xalign,
				gfloat  *yalign);
GDK_DEPRECATED_IN_3_14
void	gtk_misc_set_padding   (GtkMisc *misc,
				gint	 xpad,
				gint	 ypad);
GDK_DEPRECATED_IN_3_14
void    gtk_misc_get_padding   (GtkMisc *misc,
				gint    *xpad,
				gint    *ypad);

void   _gtk_misc_get_padding_and_border	(GtkMisc   *misc,
					 GtkBorder *border);

G_END_DECLS

#endif /* __GTK_MISC_H__ */
#define headerfilename "gtk/./gtkmenushell.h"
/* file: gtk/./gtkmenushell.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_MENU_SHELL_H__
#define __GTK_MENU_SHELL_H__



#include <gtk/gtkcontainer.h>

G_BEGIN_DECLS

#define GTK_TYPE_MENU_SHELL()             (gtk_menu_shell_get_type ())
#define GTK_MENU_SHELL(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_MENU_SHELL, GtkMenuShell))
#define GTK_MENU_SHELL_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_MENU_SHELL, GtkMenuShellClass))
#define GTK_IS_MENU_SHELL(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_MENU_SHELL))
#define GTK_IS_MENU_SHELL_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MENU_SHELL))
#define GTK_MENU_SHELL_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MENU_SHELL, GtkMenuShellClass))


typedef struct GtkMenuPrivate{} GtkMenuPrivate;


struct GtkMenu
{
  GtkMenuShell menu_shell;

  /*< private >*/
  GtkMenuPrivate *priv;
};
struct GtkMenuClass
{
  GtkMenuShellClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType    gtk_menu_shell_get_type       (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_append         (GtkMenuShell *menu_shell,
                                        GtkWidget    *child);
GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_prepend        (GtkMenuShell *menu_shell,
                                        GtkWidget    *child);
GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_insert         (GtkMenuShell *menu_shell,
                                        GtkWidget    *child,
                                        gint          position);
GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_deactivate     (GtkMenuShell *menu_shell);
GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_select_item    (GtkMenuShell *menu_shell,
                                        GtkWidget    *menu_item);
GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_deselect       (GtkMenuShell *menu_shell);
GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_activate_item  (GtkMenuShell *menu_shell,
                                        GtkWidget    *menu_item,
                                        gboolean      force_deactivate);
GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_select_first   (GtkMenuShell *menu_shell,
                                        gboolean      search_sensitive);
GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_cancel         (GtkMenuShell *menu_shell);
GDK_AVAILABLE_IN_ALL
gboolean gtk_menu_shell_get_take_focus (GtkMenuShell *menu_shell);
GDK_AVAILABLE_IN_ALL
void     gtk_menu_shell_set_take_focus (GtkMenuShell *menu_shell,
                                        gboolean      take_focus);

GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_menu_shell_get_selected_item (GtkMenuShell *menu_shell);
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_menu_shell_get_parent_shell  (GtkMenuShell *menu_shell);

GDK_AVAILABLE_IN_3_6
void       gtk_menu_shell_bind_model   (GtkMenuShell *menu_shell,
                                        GMenuModel   *model,
                                        const char  *action_namespace,
                                        gboolean      with_separators);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkMenuShell, g_object_unref)

G_END_DECLS

#endif /* __GTK_MENU_SHELL_H__ */
#define headerfilename "gtk/./gtkmenu.h"
/* file: gtk/./gtkmenu.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_MENU_H__
#define __GTK_MENU_H__



#include <gtk/gtkaccelgroup.h>
#include <gtk/gtkmenushell.h>

G_BEGIN_DECLS

#define GTK_TYPE_MENU()			(gtk_menu_get_type ())
#define GTK_MENU(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_MENU, GtkMenu))
#define GTK_MENU_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_MENU, GtkMenuClass))
#define GTK_IS_MENU(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_MENU))
#define GTK_IS_MENU_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MENU))
#define GTK_MENU_GET_CLASS(obj)         (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MENU, GtkMenuClass))



/**
 * GtkArrowPlacement:
 * @GTK_ARROWS_BOTH: Place one arrow on each end of the menu.
 * @GTK_ARROWS_START: Place both arrows at the top of the menu.
 * @GTK_ARROWS_END: Place both arrows at the bottom of the menu.
 *
 * Used to specify the placement of scroll arrows in scrolling menus.
 */
typedef enum
{
  GTK_ARROWS_BOTH,
  GTK_ARROWS_START,
  GTK_ARROWS_END
} GtkArrowPlacement;
typedef struct GtkLabelPrivate{} GtkLabelPrivate;

/**
 * GtkMenuPositionFunc:
 * @menu: a #GtkMenu.
 * @x: (inout): address of the #gint representing the horizontal
 *     position where the menu shall be drawn.
 * @y: (inout): address of the #gint representing the vertical position
 *     where the menu shall be drawn.  This is an output parameter.
 * @push_in: (out): This parameter controls how menus placed outside
 *     the monitor are handled.  If this is set to %TRUE and part of
 *     the menu is outside the monitor then GTK+ pushes the window
 *     into the visible area, effectively modifying the popup
 *     position.  Note that moving and possibly resizing the menu
 *     around will alter the scroll position to keep the menu items
 *     “in place”, i.e. at the same monitor position they would have
 *     been without resizing.  In practice, this behavior is only
 *     useful for combobox popups or option menus and cannot be used
 *     to simply confine a menu to monitor boundaries.  In that case,
 *     changing the scroll offset is not desirable.
 * @user_data: the data supplied by the user in the gtk_menu_popup()
 *     @data parameter.
 *
 * A user function supplied when calling gtk_menu_popup() which
 * controls the positioning of the menu when it is displayed.  The
 * function sets the @x and @y parameters to the coordinates where the
 * menu is to be drawn.  To make the menu appear on a different
 * monitor than the mouse pointer, gtk_menu_set_monitor() must be
 * called.
 */
typedef void (*GtkMenuPositionFunc) (GtkMenu   *menu,
				     gint      *x,
				     gint      *y,
				     gboolean  *push_in,
				     gpointer	user_data);

/**
 * GtkMenuDetachFunc:
 * @attach_widget: the #GtkWidget that the menu is being detached from.
 * @menu: the #GtkMenu being detached.
 *
 * A user function supplied when calling gtk_menu_attach_to_widget() which 
 * will be called when the menu is later detached from the widget.
 */
typedef void (*GtkMenuDetachFunc)   (GtkWidget *attach_widget,
				     GtkMenu   *menu);


struct GtkLabel
{
  GtkMisc misc;

  /*< private >*/
  GtkLabelPrivate *priv;
};
struct GtkLabelClass
{
  GtkMiscClass parent_class;

  void (* move_cursor)     (GtkLabel       *label,
			    GtkMovementStep step,
			    gint            count,
			    gboolean        extend_selection);
  void (* copy_clipboard)  (GtkLabel       *label);

  /* Hook to customize right-click popup for selectable labels */
  void (* populate_popup)   (GtkLabel       *label,
                             GtkMenu        *menu);

  gboolean (*activate_link) (GtkLabel       *label,
                             const char    *uri);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};


GDK_AVAILABLE_IN_ALL
GType	   gtk_menu_get_type		  (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_menu_new			  (void);
GDK_AVAILABLE_IN_3_4
GtkWidget* gtk_menu_new_from_model        (GMenuModel *model);

/* Display the menu onscreen */
GDK_AVAILABLE_IN_ALL
void	   gtk_menu_popup		  (GtkMenu	       *menu,
					   GtkWidget	       *parent_menu_shell,
					   GtkWidget	       *parent_menu_item,
					   GtkMenuPositionFunc	func,
					   gpointer		data,
					   guint		button,
					   guint32		activate_time);
GDK_AVAILABLE_IN_ALL
void       gtk_menu_popup_for_device      (GtkMenu             *menu,
                                           GdkDevice           *device,
                                           GtkWidget           *parent_menu_shell,
                                           GtkWidget           *parent_menu_item,
                                           GtkMenuPositionFunc  func,
                                           gpointer             data,
                                           GDestroyNotify       destroy,
                                           guint                button,
                                           guint32              activate_time);

/* Position the menu according to its position function. Called
 * from gtkmenuitem.c when a menu-item changes its allocation
 */
GDK_AVAILABLE_IN_ALL
void	   gtk_menu_reposition		  (GtkMenu	       *menu);

GDK_AVAILABLE_IN_ALL
void	   gtk_menu_popdown		  (GtkMenu	       *menu);

/* Keep track of the last menu item selected. (For the purposes
 * of the option menu
 */
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_menu_get_active		  (GtkMenu	       *menu);
GDK_AVAILABLE_IN_ALL
void	   gtk_menu_set_active		  (GtkMenu	       *menu,
					   guint		index);

/* set/get the accelerator group that holds global accelerators (should
 * be added to the corresponding toplevel with gtk_window_add_accel_group().
 */
GDK_AVAILABLE_IN_ALL
void	       gtk_menu_set_accel_group	  (GtkMenu	       *menu,
					   GtkAccelGroup       *accel_group);
GDK_AVAILABLE_IN_ALL
GtkAccelGroup* gtk_menu_get_accel_group	  (GtkMenu	       *menu);
GDK_AVAILABLE_IN_ALL
void           gtk_menu_set_accel_path    (GtkMenu             *menu,
					   const char         *accel_path);
GDK_AVAILABLE_IN_ALL
const char*   gtk_menu_get_accel_path    (GtkMenu             *menu);

/* A reference count is kept for a widget when it is attached to
 * a particular widget. This is typically a menu item; it may also
 * be a widget with a popup menu - for instance, the Notebook widget.
 */
GDK_AVAILABLE_IN_ALL
void	   gtk_menu_attach_to_widget	  (GtkMenu	       *menu,
					   GtkWidget	       *attach_widget,
					   GtkMenuDetachFunc	detacher);
GDK_AVAILABLE_IN_ALL
void	   gtk_menu_detach		  (GtkMenu	       *menu);

/* This should be dumped in favor of data set when the menu is popped
 * up - that is currently in the ItemFactory code, but should be
 * in the Menu code.
 */
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_menu_get_attach_widget	  (GtkMenu	       *menu);

GDK_DEPRECATED_IN_3_10
void       gtk_menu_set_tearoff_state     (GtkMenu             *menu,
                                           gboolean             torn_off);
GDK_DEPRECATED_IN_3_10
gboolean   gtk_menu_get_tearoff_state     (GtkMenu             *menu);

/* This sets the window manager title for the window that
 * appears when a menu is torn off
 */
GDK_DEPRECATED_IN_3_10
void          gtk_menu_set_title          (GtkMenu             *menu,
                                           const char         *title);
GDK_DEPRECATED_IN_3_10
const char * gtk_menu_get_title          (GtkMenu             *menu);

GDK_AVAILABLE_IN_ALL
void       gtk_menu_reorder_child         (GtkMenu             *menu,
                                           GtkWidget           *child,
                                           gint                position);

GDK_AVAILABLE_IN_ALL
void	   gtk_menu_set_screen		  (GtkMenu	       *menu,
					   GdkScreen	       *screen);

GDK_AVAILABLE_IN_ALL
void       gtk_menu_attach                (GtkMenu             *menu,
                                           GtkWidget           *child,
                                           guint                left_attach,
                                           guint                right_attach,
                                           guint                top_attach,
                                           guint                bottom_attach);

GDK_AVAILABLE_IN_ALL
void       gtk_menu_set_monitor           (GtkMenu             *menu,
                                           gint                 monitor_num);
GDK_AVAILABLE_IN_ALL
gint       gtk_menu_get_monitor           (GtkMenu             *menu);
GDK_AVAILABLE_IN_ALL
GList*     gtk_menu_get_for_attach_widget (GtkWidget           *widget); 

GDK_AVAILABLE_IN_ALL
void     gtk_menu_set_reserve_toggle_size (GtkMenu  *menu,
                                          gboolean   reserve_toggle_size);
GDK_AVAILABLE_IN_ALL
gboolean gtk_menu_get_reserve_toggle_size (GtkMenu  *menu);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkMenu, g_object_unref)

G_END_DECLS

#endif /* __GTK_MENU_H__ */
#define headerfilename "gtk/./gtklabel.h"
/* file: gtk/./gtklabel.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_LABEL_H__
#define __GTK_LABEL_H__



#include <gtk/deprecated/gtkmisc.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtkmenu.h>

G_BEGIN_DECLS

#define GTK_TYPE_LABEL()		  (gtk_label_get_type ())
#define GTK_LABEL(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_LABEL, GtkLabel))
#define GTK_LABEL_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_LABEL, GtkLabelClass))
#define GTK_IS_LABEL(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_LABEL))
#define GTK_IS_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_LABEL))
#define GTK_LABEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_LABEL, GtkLabelClass))



typedef struct GtkLabelSelectionInfo{} GtkLabelSelectionInfo;
typedef struct GtkAccelLabelPrivate{} GtkAccelLabelPrivate;


struct GtkAccelLabel
{
  GtkLabel label;
  GtkAccelLabelPrivate *priv;
};
struct GtkAccelLabelClass
{
  GtkLabelClass	 parent_class;

  char		*signal_quote1;
  char		*signal_quote2;
  char		*mod_name_shift;
  char		*mod_name_control;
  char		*mod_name_alt;
  char		*mod_separator;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType                 gtk_label_get_type          (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget*            gtk_label_new               (const char   *str);
GDK_AVAILABLE_IN_ALL
GtkWidget*            gtk_label_new_with_mnemonic (const char   *str);
GDK_AVAILABLE_IN_ALL
void                  gtk_label_set_text          (GtkLabel      *label,
						   const char   *str);
GDK_AVAILABLE_IN_ALL
const char*          gtk_label_get_text          (GtkLabel      *label);
GDK_AVAILABLE_IN_ALL
void                  gtk_label_set_attributes    (GtkLabel      *label,
						   PangoAttrList *attrs);
GDK_AVAILABLE_IN_ALL
PangoAttrList        *gtk_label_get_attributes    (GtkLabel      *label);
GDK_AVAILABLE_IN_ALL
void                  gtk_label_set_label         (GtkLabel      *label,
						   const char   *str);
GDK_AVAILABLE_IN_ALL
const char *         gtk_label_get_label         (GtkLabel      *label);
GDK_AVAILABLE_IN_ALL
void                  gtk_label_set_markup        (GtkLabel      *label,
						   const char   *str);
GDK_AVAILABLE_IN_ALL
void                  gtk_label_set_use_markup    (GtkLabel      *label,
						   gboolean       setting);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_label_get_use_markup    (GtkLabel      *label);
GDK_AVAILABLE_IN_ALL
void                  gtk_label_set_use_underline (GtkLabel      *label,
						   gboolean       setting);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_label_get_use_underline (GtkLabel      *label);

GDK_AVAILABLE_IN_ALL
void     gtk_label_set_markup_with_mnemonic       (GtkLabel         *label,
						   const char      *str);
GDK_AVAILABLE_IN_ALL
guint    gtk_label_get_mnemonic_keyval            (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_mnemonic_widget            (GtkLabel         *label,
						   GtkWidget        *widget);
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_label_get_mnemonic_widget          (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_text_with_mnemonic         (GtkLabel         *label,
						   const char      *str);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_justify                    (GtkLabel         *label,
						   GtkJustification  jtype);
GDK_AVAILABLE_IN_ALL
GtkJustification gtk_label_get_justify            (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_ellipsize		  (GtkLabel         *label,
						   PangoEllipsizeMode mode);
GDK_AVAILABLE_IN_ALL
PangoEllipsizeMode gtk_label_get_ellipsize        (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_width_chars		  (GtkLabel         *label,
						   gint              n_chars);
GDK_AVAILABLE_IN_ALL
gint     gtk_label_get_width_chars                (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_max_width_chars    	  (GtkLabel         *label,
					  	   gint              n_chars);
GDK_AVAILABLE_IN_ALL
gint     gtk_label_get_max_width_chars  	  (GtkLabel         *label);
GDK_AVAILABLE_IN_3_10
void     gtk_label_set_lines                      (GtkLabel         *label,
                                                   gint              lines);
GDK_AVAILABLE_IN_3_10
gint     gtk_label_get_lines                      (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_pattern                    (GtkLabel         *label,
						   const char      *pattern);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_line_wrap                  (GtkLabel         *label,
						   gboolean          wrap);
GDK_AVAILABLE_IN_ALL
gboolean gtk_label_get_line_wrap                  (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_line_wrap_mode             (GtkLabel         *label,
						   PangoWrapMode     wrap_mode);
GDK_AVAILABLE_IN_ALL
PangoWrapMode gtk_label_get_line_wrap_mode        (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_selectable                 (GtkLabel         *label,
						   gboolean          setting);
GDK_AVAILABLE_IN_ALL
gboolean gtk_label_get_selectable                 (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_set_angle                      (GtkLabel         *label,
						   gdouble           angle);
GDK_AVAILABLE_IN_ALL
gdouble  gtk_label_get_angle                      (GtkLabel         *label);
GDK_AVAILABLE_IN_ALL
void     gtk_label_select_region                  (GtkLabel         *label,
						   gint              start_offset,
						   gint              end_offset);
GDK_AVAILABLE_IN_ALL
gboolean gtk_label_get_selection_bounds           (GtkLabel         *label,
                                                   gint             *start,
                                                   gint             *end);

GDK_AVAILABLE_IN_ALL
PangoLayout *gtk_label_get_layout         (GtkLabel *label);
GDK_AVAILABLE_IN_ALL
void         gtk_label_get_layout_offsets (GtkLabel *label,
                                           gint     *x,
                                           gint     *y);

GDK_AVAILABLE_IN_ALL
void         gtk_label_set_single_line_mode  (GtkLabel *label,
                                              gboolean single_line_mode);
GDK_AVAILABLE_IN_ALL
gboolean     gtk_label_get_single_line_mode  (GtkLabel *label);

GDK_AVAILABLE_IN_ALL
const char *gtk_label_get_current_uri (GtkLabel *label);
GDK_AVAILABLE_IN_ALL
void         gtk_label_set_track_visited_links  (GtkLabel *label,
                                                 gboolean  track_links);
GDK_AVAILABLE_IN_ALL
gboolean     gtk_label_get_track_visited_links  (GtkLabel *label);

GDK_AVAILABLE_IN_3_16
void         gtk_label_set_xalign (GtkLabel *label,
                                   gfloat    xalign);

GDK_AVAILABLE_IN_3_16
gfloat       gtk_label_get_xalign (GtkLabel *label);

GDK_AVAILABLE_IN_3_16
void         gtk_label_set_yalign (GtkLabel *label,
                                   gfloat    yalign);

GDK_AVAILABLE_IN_3_16
gfloat       gtk_label_get_yalign (GtkLabel *label);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkLabel, g_object_unref)

G_END_DECLS

#endif /* __GTK_LABEL_H__ */
#define headerfilename "gtk/./gtkaccellabel.h"
/* file: gtk/./gtkaccellabel.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * GtkAccelLabel: GtkLabel with accelerator monitoring facilities.
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2001.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_ACCEL_LABEL_H__
#define __GTK_ACCEL_LABEL_H__



#include <gtk/gtklabel.h>

G_BEGIN_DECLS

#define GTK_TYPE_ACCEL_LABEL()		(gtk_accel_label_get_type ())
#define GTK_ACCEL_LABEL(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ACCEL_LABEL, GtkAccelLabel))
#define GTK_ACCEL_LABEL_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ACCEL_LABEL, GtkAccelLabelClass))
#define GTK_IS_ACCEL_LABEL(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ACCEL_LABEL))
#define GTK_IS_ACCEL_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ACCEL_LABEL))
#define GTK_ACCEL_LABEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ACCEL_LABEL, GtkAccelLabelClass))


typedef struct GtkAccessiblePrivate{} GtkAccessiblePrivate;

/**
 * GtkAccelLabel:
 *
 * The #GtkAccelLabel-struct contains private data only, and
 * should be accessed using the functions below.
 */

struct GtkAccessible
{
  AtkObject parent;

  /*< private >*/
  GtkAccessiblePrivate *priv;
};
struct GtkAccessibleClass
{
  AtkObjectClass parent_class;

  void (*connect_widget_destroyed) (GtkAccessible *accessible);

  void (*widget_set)               (GtkAccessible *accessible);
  void (*widget_unset)             (GtkAccessible *accessible);
  /* Padding for future expansion */
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};
typedef struct _GtkAccelMap{} GtkAccelMap;
typedef struct _GtkAccelMapClass{} GtkAccelMapClass;


GDK_AVAILABLE_IN_ALL
GType	   gtk_accel_label_get_type	     (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_accel_label_new		     (const char   *string);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_accel_label_get_accel_widget  (GtkAccelLabel *accel_label);
GDK_AVAILABLE_IN_ALL
guint	   gtk_accel_label_get_accel_width   (GtkAccelLabel *accel_label);
GDK_AVAILABLE_IN_ALL
void	   gtk_accel_label_set_accel_widget  (GtkAccelLabel *accel_label,
					      GtkWidget	    *accel_widget);
GDK_AVAILABLE_IN_ALL
void	   gtk_accel_label_set_accel_closure (GtkAccelLabel *accel_label,
					      GClosure	    *accel_closure);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_accel_label_refetch           (GtkAccelLabel *accel_label);
GDK_AVAILABLE_IN_3_6
void       gtk_accel_label_set_accel         (GtkAccelLabel   *accel_label,
                                              guint            accelerator_key,
                                              GdkModifierType  accelerator_mods);
GDK_AVAILABLE_IN_3_12
void       gtk_accel_label_get_accel         (GtkAccelLabel   *accel_label,
                                              guint           *accelerator_key,
                                              GdkModifierType *accelerator_mods);

/* private */
char *    _gtk_accel_label_class_get_accelerator_label (GtkAccelLabelClass *klass,
							 guint               accelerator_key,
							 GdkModifierType     accelerator_mods);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkAccelLabel, g_object_unref)

G_END_DECLS

#endif /* __GTK_ACCEL_LABEL_H__ */
#define headerfilename "gtk/./gtkaccelmap.h"
/* file: gtk/./gtkaccelmap.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1998, 2001 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_ACCEL_MAP_H__
#define __GTK_ACCEL_MAP_H__




#include <gtk/gtkaccelgroup.h>

G_BEGIN_DECLS

/* --- global GtkAccelMap object --- */
#define GTK_TYPE_ACCEL_MAP()                (gtk_accel_map_get_type ())
#define GTK_ACCEL_MAP(accel_map)	  (G_TYPE_CHECK_INSTANCE_CAST ((accel_map), GTK_TYPE_ACCEL_MAP, GtkAccelMap))
#define GTK_ACCEL_MAP_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ACCEL_MAP, GtkAccelMapClass))
#define GTK_IS_ACCEL_MAP(accel_map)	  (G_TYPE_CHECK_INSTANCE_TYPE ((accel_map), GTK_TYPE_ACCEL_MAP))
#define GTK_IS_ACCEL_MAP_CLASS(klass)	  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ACCEL_MAP))
#define GTK_ACCEL_MAP_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ACCEL_MAP, GtkAccelMapClass))


/* --- notifier --- */
/**
 * GtkAccelMapForeach:
 * @data: User data passed to gtk_accel_map_foreach() or
 *  gtk_accel_map_foreach_unfiltered()
 * @accel_path: Accel path of the current accelerator
 * @accel_key: Key of the current accelerator
 * @accel_mods: Modifiers of the current accelerator
 * @changed: Changed flag of the accelerator (if %TRUE, accelerator has changed
 *  during runtime and would need to be saved during an accelerator dump)
 */
typedef void (*GtkAccelMapForeach)		(gpointer	 data,
						 const char	*accel_path,
						 guint           accel_key,
						 GdkModifierType accel_mods,
						 gboolean	 changed);


/* --- public API --- */

GDK_AVAILABLE_IN_ALL
void	   gtk_accel_map_add_entry	(const char		*accel_path,
					 guint			 accel_key,
					 GdkModifierType         accel_mods);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_accel_map_lookup_entry	(const char		*accel_path,
					 GtkAccelKey		*key);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_accel_map_change_entry	(const char		*accel_path,
					 guint			 accel_key,
					 GdkModifierType	 accel_mods,
					 gboolean		 replace);
GDK_AVAILABLE_IN_ALL
void	   gtk_accel_map_load		(const char		*file_name);
GDK_AVAILABLE_IN_ALL
void	   gtk_accel_map_save		(const char		*file_name);
GDK_AVAILABLE_IN_ALL
void	   gtk_accel_map_foreach	(gpointer		 data,
					 GtkAccelMapForeach	 foreach_func);
GDK_AVAILABLE_IN_ALL
void	   gtk_accel_map_load_fd	(gint			 fd);
GDK_AVAILABLE_IN_ALL
void	   gtk_accel_map_load_scanner	(GScanner		*scanner);
GDK_AVAILABLE_IN_ALL
void	   gtk_accel_map_save_fd	(gint			 fd);

GDK_AVAILABLE_IN_ALL
void       gtk_accel_map_lock_path      (const char            *accel_path);
GDK_AVAILABLE_IN_ALL
void       gtk_accel_map_unlock_path    (const char            *accel_path);

/* --- filter functions --- */
GDK_AVAILABLE_IN_ALL
void	gtk_accel_map_add_filter	 (const char		*filter_pattern);
GDK_AVAILABLE_IN_ALL
void	gtk_accel_map_foreach_unfiltered (gpointer		 data,
					  GtkAccelMapForeach	 foreach_func);

/* --- notification --- */
GDK_AVAILABLE_IN_ALL
GType        gtk_accel_map_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkAccelMap *gtk_accel_map_get      (void);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkAccelMap, g_object_unref)

G_END_DECLS

#endif /* __GTK_ACCEL_MAP_H__ */
#define headerfilename "gtk/./gtkaccessible.h"
/* file: gtk/./gtkaccessible.h */
/* GTK - The GIMP Toolkit
 * Copyright 2001 Sun Microsystems Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_ACCESSIBLE_H__
#define __GTK_ACCESSIBLE_H__



#include <atk/atk.h>
#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_ACCESSIBLE()                  (gtk_accessible_get_type ())
#define GTK_ACCESSIBLE(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ACCESSIBLE, GtkAccessible))
#define GTK_ACCESSIBLE_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ACCESSIBLE, GtkAccessibleClass))
#define GTK_IS_ACCESSIBLE(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ACCESSIBLE))
#define GTK_IS_ACCESSIBLE_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ACCESSIBLE))
#define GTK_ACCESSIBLE_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ACCESSIBLE, GtkAccessibleClass))

typedef struct GtkActionable{} GtkActionable;


struct GtkActionableInterface
{
  /*< private >*/
  GTypeInterface g_iface;

  /*< public >*/

  const char * (* get_action_name)             (GtkActionable *actionable);
  void          (* set_action_name)             (GtkActionable *actionable,
                                                 const char   *action_name);
  GVariant *    (* get_action_target_value)     (GtkActionable *actionable);
  void          (* set_action_target_value)     (GtkActionable *actionable,
                                                 GVariant      *target_value);
};

GDK_AVAILABLE_IN_ALL
GType      gtk_accessible_get_type                 (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
void       gtk_accessible_set_widget               (GtkAccessible *accessible,
                                                    GtkWidget     *widget);
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_accessible_get_widget               (GtkAccessible *accessible);

GDK_DEPRECATED_IN_3_4_FOR(gtk_accessible_set_widget)
void       gtk_accessible_connect_widget_destroyed (GtkAccessible *accessible);

G_END_DECLS

#endif /* __GTK_ACCESSIBLE_H__ */


#define headerfilename "gtk/./gtkactionable.h"
/* file: gtk/./gtkactionable.h */
/*
 * Copyright © 2012 Canonical Limited
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * licence or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Ryan Lortie <desrt@desrt.ca>
 */

#ifndef __GTK_ACTIONABLE_H__
#define __GTK_ACTIONABLE_H__

#include <glib-object.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define GTK_TYPE_ACTIONABLE()                                 (gtk_actionable_get_type ())
#define GTK_ACTIONABLE(inst)                                (G_TYPE_CHECK_INSTANCE_CAST ((inst),                     \
                                                             GTK_TYPE_ACTIONABLE, GtkActionable))
#define GTK_IS_ACTIONABLE(inst)                             (G_TYPE_CHECK_INSTANCE_TYPE ((inst),                     \
                                                             GTK_TYPE_ACTIONABLE))
#define GTK_ACTIONABLE_GET_IFACE(inst)                      (G_TYPE_INSTANCE_GET_INTERFACE ((inst),                  \
                                                             GTK_TYPE_ACTIONABLE, GtkActionableInterface))


struct GtkActionBar
{
  /*< private >*/
  GtkBin bin;
};
struct GtkActionBarClass
{
  /*< private >*/
  GtkBinClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_4
GType                   gtk_actionable_get_type                         (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_4
const char *           gtk_actionable_get_action_name                  (GtkActionable *actionable);
GDK_AVAILABLE_IN_3_4
void                    gtk_actionable_set_action_name                  (GtkActionable *actionable,
                                                                         const char   *action_name);

GDK_AVAILABLE_IN_3_4
GVariant *              gtk_actionable_get_action_target_value          (GtkActionable *actionable);
GDK_AVAILABLE_IN_3_4
void                    gtk_actionable_set_action_target_value          (GtkActionable *actionable,
                                                                         GVariant      *target_value);

GDK_AVAILABLE_IN_3_4
void                    gtk_actionable_set_action_target                (GtkActionable *actionable,
                                                                         const char   *format_string,
                                                                         ...);

GDK_AVAILABLE_IN_3_4
void                    gtk_actionable_set_detailed_action_name         (GtkActionable *actionable,
                                                                         const char   *detailed_action_name);

G_END_DECLS

#endif /* __GTK_ACTIONABLE_H__ */
#define headerfilename "gtk/./gtkactionbar.h"
/* file: gtk/./gtkactionbar.h */
/*
 * Copyright (c) 2013 - 2014 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __GTK_ACTION_BAR_H__
#define __GTK_ACTION_BAR_H__



#include <gtk/gtkbin.h>

G_BEGIN_DECLS

#define GTK_TYPE_ACTION_BAR()            (gtk_action_bar_get_type ())
#define GTK_ACTION_BAR(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ACTION_BAR, GtkActionBar))
#define GTK_ACTION_BAR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ACTION_BAR, GtkActionBarClass))
#define GTK_IS_ACTION_BAR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ACTION_BAR))
#define GTK_IS_ACTION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ACTION_BAR))
#define GTK_ACTION_BAR_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ACTION_BAR, GtkActionBarClass))

typedef struct GtkActionBarPrivate{} GtkActionBarPrivate;


struct GtkAdjustmentClass
{
  GInitiallyUnownedClass parent_class;

  void (* changed)       (GtkAdjustment *adjustment);
  void (* value_changed) (GtkAdjustment *adjustment);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_12
GType        gtk_action_bar_get_type          (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_12
GtkWidget   *gtk_action_bar_new               (void);
GDK_AVAILABLE_IN_3_12
GtkWidget   *gtk_action_bar_get_center_widget (GtkActionBar *action_bar);
GDK_AVAILABLE_IN_3_12
void         gtk_action_bar_set_center_widget (GtkActionBar *action_bar,
                                               GtkWidget    *center_widget);

GDK_AVAILABLE_IN_3_12
void         gtk_action_bar_pack_start        (GtkActionBar *action_bar,
                                               GtkWidget    *child);
GDK_AVAILABLE_IN_3_12
void         gtk_action_bar_pack_end          (GtkActionBar *action_bar,
                                               GtkWidget    *child);
G_END_DECLS

#endif /* __GTK_ACTION_BAR_H__ */
#define headerfilename "gtk/./gtkadjustment.h"
/* file: gtk/./gtkadjustment.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_ADJUSTMENT_H__
#define __GTK_ADJUSTMENT_H__



#include <gdk/gdk.h>
#include <gtk/gtktypes.h>

G_BEGIN_DECLS

#define GTK_TYPE_ADJUSTMENT()                  (gtk_adjustment_get_type ())
#define GTK_ADJUSTMENT(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ADJUSTMENT, GtkAdjustment))
#define GTK_ADJUSTMENT_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ADJUSTMENT, GtkAdjustmentClass))
#define GTK_IS_ADJUSTMENT(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ADJUSTMENT))
#define GTK_IS_ADJUSTMENT_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ADJUSTMENT))
#define GTK_ADJUSTMENT_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ADJUSTMENT, GtkAdjustmentClass))


typedef struct _GtkAppChooser{} GtkAppChooser;

/**
 * GtkAdjustment:
 *
 * The #GtkAdjustment-struct contains only private fields and
 * should not be directly accessed.
 */



GDK_AVAILABLE_IN_ALL
GType      gtk_adjustment_get_type              (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkAdjustment*   gtk_adjustment_new             (gdouble          value,
                                                 gdouble          lower,
                                                 gdouble          upper,
                                                 gdouble          step_increment,
                                                 gdouble          page_increment,
                                                 gdouble          page_size);

GDK_DEPRECATED_IN_3_18
void       gtk_adjustment_changed               (GtkAdjustment   *adjustment);
GDK_DEPRECATED_IN_3_18
void       gtk_adjustment_value_changed         (GtkAdjustment   *adjustment);
GDK_AVAILABLE_IN_ALL
void       gtk_adjustment_clamp_page            (GtkAdjustment   *adjustment,
                                                 gdouble          lower,
                                                 gdouble          upper);

GDK_AVAILABLE_IN_ALL
gdouble    gtk_adjustment_get_value             (GtkAdjustment   *adjustment);
GDK_AVAILABLE_IN_ALL
void       gtk_adjustment_set_value             (GtkAdjustment   *adjustment,
                                                 gdouble          value);
GDK_AVAILABLE_IN_ALL
gdouble    gtk_adjustment_get_lower             (GtkAdjustment   *adjustment);
GDK_AVAILABLE_IN_ALL
void       gtk_adjustment_set_lower             (GtkAdjustment   *adjustment,
                                                 gdouble          lower);
GDK_AVAILABLE_IN_ALL
gdouble    gtk_adjustment_get_upper             (GtkAdjustment   *adjustment);
GDK_AVAILABLE_IN_ALL
void       gtk_adjustment_set_upper             (GtkAdjustment   *adjustment,
                                                 gdouble          upper);
GDK_AVAILABLE_IN_ALL
gdouble    gtk_adjustment_get_step_increment    (GtkAdjustment   *adjustment);
GDK_AVAILABLE_IN_ALL
void       gtk_adjustment_set_step_increment    (GtkAdjustment   *adjustment,
                                                 gdouble          step_increment);
GDK_AVAILABLE_IN_ALL
gdouble    gtk_adjustment_get_page_increment    (GtkAdjustment   *adjustment);
GDK_AVAILABLE_IN_ALL
void       gtk_adjustment_set_page_increment    (GtkAdjustment   *adjustment,
                                                 gdouble          page_increment);
GDK_AVAILABLE_IN_ALL
gdouble    gtk_adjustment_get_page_size         (GtkAdjustment   *adjustment);
GDK_AVAILABLE_IN_ALL
void       gtk_adjustment_set_page_size         (GtkAdjustment   *adjustment,
                                                 gdouble          page_size);

GDK_AVAILABLE_IN_ALL
void       gtk_adjustment_configure             (GtkAdjustment   *adjustment,
                                                 gdouble          value,
                                                 gdouble          lower,
                                                 gdouble          upper,
                                                 gdouble          step_increment,
                                                 gdouble          page_increment,
                                                 gdouble          page_size);
GDK_AVAILABLE_IN_3_2
gdouble    gtk_adjustment_get_minimum_increment (GtkAdjustment   *adjustment);

G_END_DECLS

#endif /* __GTK_ADJUSTMENT_H__ */
#define headerfilename "gtk/./gtkappchooser.h"
/* file: gtk/./gtkappchooser.h */
/*
 * gtkappchooser.h: app-chooser interface
 *
 * Copyright (C) 2010 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Cosimo Cecchi <ccecchi@redhat.com>
 */

#ifndef __GTK_APP_CHOOSER_H__
#define __GTK_APP_CHOOSER_H__



#include <glib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define GTK_TYPE_APP_CHOOSER()    (gtk_app_chooser_get_type ())
#define GTK_APP_CHOOSER(obj)    (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_APP_CHOOSER, GtkAppChooser))
#define GTK_IS_APP_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_APP_CHOOSER))


GDK_AVAILABLE_IN_ALL
GType      gtk_app_chooser_get_type         (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GAppInfo * gtk_app_chooser_get_app_info     (GtkAppChooser *self);
GDK_AVAILABLE_IN_ALL
char *    gtk_app_chooser_get_content_type (GtkAppChooser *self);
GDK_AVAILABLE_IN_ALL
void       gtk_app_chooser_refresh          (GtkAppChooser *self);

G_END_DECLS

#endif /* __GTK_APP_CHOOSER_H__ */

#define headerfilename "gtk/./gtkappchooserdialog.h"
/* file: gtk/./gtkappchooserdialog.h */
/*
 * gtkappchooserdialog.h: an app-chooser dialog
 *
 * Copyright (C) 2004 Novell, Inc.
 * Copyright (C) 2007, 2010 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Dave Camp <dave@novell.com>
 *          Alexander Larsson <alexl@redhat.com>
 *          Cosimo Cecchi <ccecchi@redhat.com>
 */

#ifndef __GTK_APP_CHOOSER_DIALOG_H__
#define __GTK_APP_CHOOSER_DIALOG_H__



#include <gtk/gtkdialog.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define GTK_TYPE_APP_CHOOSER_DIALOG()            (gtk_app_chooser_dialog_get_type ())
#define GTK_APP_CHOOSER_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_APP_CHOOSER_DIALOG, GtkAppChooserDialog))
#define GTK_APP_CHOOSER_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_APP_CHOOSER_DIALOG, GtkAppChooserDialogClass))
#define GTK_IS_APP_CHOOSER_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_APP_CHOOSER_DIALOG))
#define GTK_IS_APP_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_APP_CHOOSER_DIALOG))
#define GTK_APP_CHOOSER_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_APP_CHOOSER_DIALOG, GtkAppChooserDialogClass))

typedef struct GtkAppChooserDialogPrivate{} GtkAppChooserDialogPrivate;

struct GtkAppChooserDialog {
  GtkDialog parent;

  /*< private >*/
  GtkAppChooserDialogPrivate *priv;
};

/**
 * GtkAppChooserDialogClass:
 * @parent_class: The parent class.
 */
struct GtkAppChooserDialogClass {
  GtkDialogClass parent_class;

  /*< private >*/

  /* padding for future class expansion */
  gpointer padding[16];
};
typedef struct GtkBoxPrivate{} GtkBoxPrivate;
struct GtkBox
{
  GtkContainer container;

  /*< private >*/
  GtkBoxPrivate *priv;
};
struct GtkBoxClass
{
  GtkContainerClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType         gtk_app_chooser_dialog_get_type             (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget *   gtk_app_chooser_dialog_new                  (GtkWindow           *parent,
                                                           GtkDialogFlags       flags,
                                                           GFile               *file);
GDK_AVAILABLE_IN_ALL
GtkWidget *   gtk_app_chooser_dialog_new_for_content_type (GtkWindow           *parent,
                                                           GtkDialogFlags       flags,
                                                           const char         *content_type);

GDK_AVAILABLE_IN_ALL
GtkWidget *   gtk_app_chooser_dialog_get_widget           (GtkAppChooserDialog *self);
GDK_AVAILABLE_IN_ALL
void          gtk_app_chooser_dialog_set_heading          (GtkAppChooserDialog *self,
                                                           const char         *heading);
GDK_AVAILABLE_IN_ALL
const char * gtk_app_chooser_dialog_get_heading          (GtkAppChooserDialog *self);

G_END_DECLS

#endif /* __GTK_APP_CHOOSER_DIALOG_H__ */
#define headerfilename "gtk/./gtkbox.h"
/* file: gtk/./gtkbox.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_BOX_H__
#define __GTK_BOX_H__




#include <gtk/gtkcontainer.h>


G_BEGIN_DECLS


#define GTK_TYPE_BOX()            (gtk_box_get_type ())
#define GTK_BOX(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_BOX, GtkBox))
#define GTK_BOX_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_BOX, GtkBoxClass))
#define GTK_IS_BOX(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_BOX))
#define GTK_IS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_BOX))
#define GTK_BOX_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_BOX, GtkBoxClass))




/**
 * GtkBoxClass:
 * @parent_class: The parent class.
 */


GDK_AVAILABLE_IN_ALL
GType       gtk_box_get_type            (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget*  gtk_box_new                 (GtkOrientation  orientation,
                                         gint            spacing);

GDK_AVAILABLE_IN_ALL
void        gtk_box_pack_start          (GtkBox         *box,
                                         GtkWidget      *child,
                                         gboolean        expand,
                                         gboolean        fill,
                                         guint           padding);
GDK_AVAILABLE_IN_ALL
void        gtk_box_pack_end            (GtkBox         *box,
                                         GtkWidget      *child,
                                         gboolean        expand,
                                         gboolean        fill,
                                         guint           padding);

GDK_AVAILABLE_IN_ALL
void        gtk_box_set_homogeneous     (GtkBox         *box,
                                         gboolean        homogeneous);
GDK_AVAILABLE_IN_ALL
gboolean    gtk_box_get_homogeneous     (GtkBox         *box);
GDK_AVAILABLE_IN_ALL
void        gtk_box_set_spacing         (GtkBox         *box,
                                         gint            spacing);
GDK_AVAILABLE_IN_ALL
gint        gtk_box_get_spacing         (GtkBox         *box);
GDK_AVAILABLE_IN_3_10
void        gtk_box_set_baseline_position (GtkBox             *box,
					   GtkBaselinePosition position);
GDK_AVAILABLE_IN_3_10
GtkBaselinePosition gtk_box_get_baseline_position (GtkBox         *box);

GDK_AVAILABLE_IN_ALL
void        gtk_box_reorder_child       (GtkBox         *box,
                                         GtkWidget      *child,
                                         gint            position);

GDK_AVAILABLE_IN_ALL
void        gtk_box_query_child_packing (GtkBox         *box,
                                         GtkWidget      *child,
                                         gboolean       *expand,
                                         gboolean       *fill,
                                         guint          *padding,
                                         GtkPackType    *pack_type);
GDK_AVAILABLE_IN_ALL
void        gtk_box_set_child_packing   (GtkBox         *box,
                                         GtkWidget      *child,
                                         gboolean        expand,
                                         gboolean        fill,
                                         guint           padding,
                                         GtkPackType     pack_type);

GDK_AVAILABLE_IN_3_12
void        gtk_box_set_center_widget   (GtkBox         *box,
                                         GtkWidget      *widget);
GDK_AVAILABLE_IN_3_12
GtkWidget  *gtk_box_get_center_widget   (GtkBox         *box);

G_END_DECLS

#endif /* __GTK_BOX_H__ */
#define headerfilename "gtk/./gtkappchooserwidget.h"
/* file: gtk/./gtkappchooserwidget.h */
/*
 * gtkappchooserwidget.h: an app-chooser widget
 *
 * Copyright (C) 2004 Novell, Inc.
 * Copyright (C) 2007, 2010 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Dave Camp <dave@novell.com>
 *          Alexander Larsson <alexl@redhat.com>
 *          Cosimo Cecchi <ccecchi@redhat.com>
 */

#ifndef __GTK_APP_CHOOSER_WIDGET_H__
#define __GTK_APP_CHOOSER_WIDGET_H__



#include <gtk/gtkbox.h>
#include <gtk/gtkmenu.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define GTK_TYPE_APP_CHOOSER_WIDGET()            (gtk_app_chooser_widget_get_type ())
#define GTK_APP_CHOOSER_WIDGET(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_APP_CHOOSER_WIDGET, GtkAppChooserWidget))
#define GTK_APP_CHOOSER_WIDGET_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_APP_CHOOSER_WIDGET, GtkAppChooserWidgetClass))
#define GTK_IS_APP_CHOOSER_WIDGET(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_APP_CHOOSER_WIDGET))
#define GTK_IS_APP_CHOOSER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_APP_CHOOSER_WIDGET))
#define GTK_APP_CHOOSER_WIDGET_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_APP_CHOOSER_WIDGET, GtkAppChooserWidgetClass))

typedef struct GtkAppChooserWidgetPrivate{} GtkAppChooserWidgetPrivate;

struct GtkAppChooserWidget {
  GtkBox parent;

  /*< private >*/
  GtkAppChooserWidgetPrivate *priv;
};

/**
 * GtkAppChooserWidgetClass:
 * @parent_class: The parent class.
 * @application_selected: Signal emitted when an application item is
 *    selected from the widget’s list.
 * @application_activated: Signal emitted when an application item is
 *    activated from the widget’s list.
 * @populate_popup: Signal emitted when a context menu is about to
 *    popup over an application item.
 */
struct GtkAppChooserWidgetClass {
  GtkBoxClass parent_class;

  /*< public >*/

  void (* application_selected)  (GtkAppChooserWidget *self,
                                  GAppInfo            *app_info);

  void (* application_activated) (GtkAppChooserWidget *self,
                                  GAppInfo            *app_info);

  void (* populate_popup)        (GtkAppChooserWidget *self,
                                  GtkMenu             *menu,
                                  GAppInfo            *app_info);

  /*< private >*/

  /* padding for future class expansion */
  gpointer padding[16];
};
struct GtkTreeIter
{
  gint stamp;
  gpointer user_data;
  gpointer user_data2;
  gpointer user_data3;
};
typedef struct _GtkTreePath{} GtkTreePath;
typedef struct _GtkTreeModel{} GtkTreeModel; /* Dummy typedef */
struct GtkTreeModelIface
{
  /*< private >*/
  GTypeInterface g_iface;

  /*< public >*/

  /* Signals */
  void         (* row_changed)           (GtkTreeModel *tree_model,
					  GtkTreePath  *path,
					  GtkTreeIter  *iter);
  void         (* row_inserted)          (GtkTreeModel *tree_model,
					  GtkTreePath  *path,
					  GtkTreeIter  *iter);
  void         (* row_has_child_toggled) (GtkTreeModel *tree_model,
					  GtkTreePath  *path,
					  GtkTreeIter  *iter);
  void         (* row_deleted)           (GtkTreeModel *tree_model,
					  GtkTreePath  *path);
  void         (* rows_reordered)        (GtkTreeModel *tree_model,
					  GtkTreePath  *path,
					  GtkTreeIter  *iter,
					  gint         *new_order);

  /* Virtual Table */
  GtkTreeModelFlags (* get_flags)  (GtkTreeModel *tree_model);

  gint         (* get_n_columns)   (GtkTreeModel *tree_model);
  GType        (* get_column_type) (GtkTreeModel *tree_model,
				    gint          index_);
  gboolean     (* get_iter)        (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter,
				    GtkTreePath  *path);
  GtkTreePath *(* get_path)        (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter);
  void         (* get_value)       (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter,
				    gint          column,
				    GValue       *value);
  gboolean     (* iter_next)       (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter);
  gboolean     (* iter_previous)   (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter);
  gboolean     (* iter_children)   (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter,
				    GtkTreeIter  *parent);
  gboolean     (* iter_has_child)  (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter);
  gint         (* iter_n_children) (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter);
  gboolean     (* iter_nth_child)  (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter,
				    GtkTreeIter  *parent,
				    gint          n);
  gboolean     (* iter_parent)     (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter,
				    GtkTreeIter  *child);
  void         (* ref_node)        (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter);
  void         (* unref_node)      (GtkTreeModel *tree_model,
				    GtkTreeIter  *iter);
};

GDK_AVAILABLE_IN_ALL
GType         gtk_app_chooser_widget_get_type             (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget *   gtk_app_chooser_widget_new                  (const char         *content_type);

GDK_AVAILABLE_IN_ALL
void          gtk_app_chooser_widget_set_show_default     (GtkAppChooserWidget *self,
                                                           gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_app_chooser_widget_get_show_default     (GtkAppChooserWidget *self);

GDK_AVAILABLE_IN_ALL
void          gtk_app_chooser_widget_set_show_recommended (GtkAppChooserWidget *self,
                                                           gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_app_chooser_widget_get_show_recommended (GtkAppChooserWidget *self);

GDK_AVAILABLE_IN_ALL
void          gtk_app_chooser_widget_set_show_fallback    (GtkAppChooserWidget *self,
                                                           gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_app_chooser_widget_get_show_fallback    (GtkAppChooserWidget *self);

GDK_AVAILABLE_IN_ALL
void          gtk_app_chooser_widget_set_show_other       (GtkAppChooserWidget *self,
                                                           gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_app_chooser_widget_get_show_other       (GtkAppChooserWidget *self);

GDK_AVAILABLE_IN_ALL
void          gtk_app_chooser_widget_set_show_all         (GtkAppChooserWidget *self,
                                                           gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_app_chooser_widget_get_show_all         (GtkAppChooserWidget *self);

GDK_AVAILABLE_IN_ALL
void          gtk_app_chooser_widget_set_default_text     (GtkAppChooserWidget *self,
                                                           const char         *text);
GDK_AVAILABLE_IN_ALL
const char * gtk_app_chooser_widget_get_default_text     (GtkAppChooserWidget *self);

G_END_DECLS

#endif /* __GTK_APP_CHOOSER_WIDGET_H__ */
#define headerfilename "gtk/./gtktreemodel.h"
/* file: gtk/./gtktreemodel.h */
/* gtktreemodel.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_TREE_MODEL_H__
#define __GTK_TREE_MODEL_H__



#include <glib-object.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define GTK_TYPE_TREE_MODEL()            (gtk_tree_model_get_type ())
#define GTK_TREE_MODEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TREE_MODEL, GtkTreeModel))
#define GTK_IS_TREE_MODEL(obj)	       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TREE_MODEL))
#define GTK_TREE_MODEL_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTK_TYPE_TREE_MODEL, GtkTreeModelIface))

#define GTK_TYPE_TREE_ITER()             (gtk_tree_iter_get_type ())
#define GTK_TYPE_TREE_PATH()             (gtk_tree_path_get_type ())
#define GTK_TYPE_TREE_ROW_REFERENCE()    (gtk_tree_row_reference_get_type ())

typedef struct _GtkTreeRowReference{} GtkTreeRowReference;

/**
 * GtkTreeModelForeachFunc:
 * @model: the #GtkTreeModel being iterated
 * @path: the current #GtkTreePath
 * @iter: the current #GtkTreeIter
 * @data: (closure): The user data passed to gtk_tree_model_foreach()
 *
 * Type of the callback passed to gtk_tree_model_foreach() to
 * iterate over the rows in a tree model.
 *
 * Returns: %TRUE to stop iterating, %FALSE to continue
 *
 */
typedef gboolean (* GtkTreeModelForeachFunc) (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data);

/**
 * GtkTreeModelFlags:
 * @GTK_TREE_MODEL_ITERS_PERSIST: iterators survive all signals
 *     emitted by the tree
 * @GTK_TREE_MODEL_LIST_ONLY: the model is a list only, and never
 *     has children
 *
 * These flags indicate various properties of a #GtkTreeModel.
 *
 * They are returned by gtk_tree_model_get_flags(), and must be
 * static for the lifetime of the object. A more complete description
 * of #GTK_TREE_MODEL_ITERS_PERSIST can be found in the overview of
 * this section.
 */
typedef enum
{
  GTK_TREE_MODEL_ITERS_PERSIST = 1 << 0,
  GTK_TREE_MODEL_LIST_ONLY = 1 << 1
} GtkTreeModelFlags;
typedef struct _GtkCellEditable{} GtkCellEditable; /* Dummy typedef */

/**
 * GtkTreeIter:
 * @stamp: a unique stamp to catch invalid iterators
 * @user_data: model-specific data
 * @user_data2: model-specific data
 * @user_data3: model-specific data
 *
 * The #GtkTreeIter is the primary structure
 * for accessing a #GtkTreeModel. Models are expected to put a unique
 * integer in the @stamp member, and put
 * model-specific data in the three @user_data
 * members.
 */

/**
 * GtkTreeModelIface:
 * @row_changed: Signal emitted when a row in the model has changed.
 * @row_inserted: Signal emitted when a new row has been inserted in
 *    the model.
 * @row_has_child_toggled: Signal emitted when a row has gotten the
 *    first child row or lost its last child row.
 * @row_deleted: Signal emitted when a row has been deleted.
 * @rows_reordered: Signal emitted when the children of a node in the
 *    GtkTreeModel have been reordered.
 * @get_flags: Get #GtkTreeModelFlags supported by this interface.
 * @get_n_columns: Get the number of columns supported by the model.
 * @get_column_type: Get the type of the column.
 * @get_iter: Sets iter to a valid iterator pointing to path.
 * @get_path: Gets a newly-created #GtkTreePath referenced by iter.
 * @get_value: Initializes and sets value to that at column.
 * @iter_next: Sets iter to point to the node following it at the
 *    current level.
 * @iter_previous: Sets iter to point to the previous node at the
 *    current level.
 * @iter_children: Sets iter to point to the first child of parent.
 * @iter_has_child: %TRUE if iter has children, %FALSE otherwise.
 * @iter_n_children: Gets the number of children that iter has.
 * @iter_nth_child: Sets iter to be the child of parent, using the
 *    given index.
 * @iter_parent: Sets iter to be the parent of child.
 * @ref_node: Lets the tree ref the node.
 * @unref_node: Lets the tree unref the node.
 */
struct GtkCellEditableIface
{
  /*< private >*/
  GTypeInterface g_iface;

  /*< public >*/

  /* signals */
  void (* editing_done)  (GtkCellEditable *cell_editable);
  void (* remove_widget) (GtkCellEditable *cell_editable);

  /* virtual table */
  void (* start_editing) (GtkCellEditable *cell_editable,
			  GdkEvent        *event);
};


/* GtkTreePath operations */
GDK_AVAILABLE_IN_ALL
GtkTreePath *gtk_tree_path_new              (void);
GDK_AVAILABLE_IN_ALL
GtkTreePath *gtk_tree_path_new_from_string  (const char       *path);
GDK_AVAILABLE_IN_ALL
GtkTreePath *gtk_tree_path_new_from_indices (gint               first_index,
					     ...);
GDK_AVAILABLE_IN_3_12
GtkTreePath *gtk_tree_path_new_from_indicesv (gint             *indices,
					      gsize             length);
GDK_AVAILABLE_IN_ALL
char       *gtk_tree_path_to_string        (GtkTreePath       *path);
GDK_AVAILABLE_IN_ALL
GtkTreePath *gtk_tree_path_new_first        (void);
GDK_AVAILABLE_IN_ALL
void         gtk_tree_path_append_index     (GtkTreePath       *path,
					     gint               index_);
GDK_AVAILABLE_IN_ALL
void         gtk_tree_path_prepend_index    (GtkTreePath       *path,
					     gint               index_);
GDK_AVAILABLE_IN_ALL
gint         gtk_tree_path_get_depth        (GtkTreePath       *path);
GDK_AVAILABLE_IN_ALL
gint        *gtk_tree_path_get_indices      (GtkTreePath       *path);

GDK_AVAILABLE_IN_ALL
gint        *gtk_tree_path_get_indices_with_depth (GtkTreePath *path,
						   gint        *depth);

GDK_AVAILABLE_IN_ALL
void         gtk_tree_path_free             (GtkTreePath       *path);
GDK_AVAILABLE_IN_ALL
GtkTreePath *gtk_tree_path_copy             (const GtkTreePath *path);
GDK_AVAILABLE_IN_ALL
GType        gtk_tree_path_get_type         (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
gint         gtk_tree_path_compare          (const GtkTreePath *a,
					     const GtkTreePath *b);
GDK_AVAILABLE_IN_ALL
void         gtk_tree_path_next             (GtkTreePath       *path);
GDK_AVAILABLE_IN_ALL
gboolean     gtk_tree_path_prev             (GtkTreePath       *path);
GDK_AVAILABLE_IN_ALL
gboolean     gtk_tree_path_up               (GtkTreePath       *path);
GDK_AVAILABLE_IN_ALL
void         gtk_tree_path_down             (GtkTreePath       *path);

GDK_AVAILABLE_IN_ALL
gboolean     gtk_tree_path_is_ancestor      (GtkTreePath       *path,
                                             GtkTreePath       *descendant);
GDK_AVAILABLE_IN_ALL
gboolean     gtk_tree_path_is_descendant    (GtkTreePath       *path,
                                             GtkTreePath       *ancestor);

/**
 * GtkTreeRowReference:
 *
 * A GtkTreeRowReference tracks model changes so that it always refers to the
 * same row (a #GtkTreePath refers to a position, not a fixed row). Create a
 * new GtkTreeRowReference with gtk_tree_row_reference_new().
 */

GDK_AVAILABLE_IN_ALL
GType                gtk_tree_row_reference_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkTreeRowReference *gtk_tree_row_reference_new       (GtkTreeModel        *model,
						       GtkTreePath         *path);
GDK_AVAILABLE_IN_ALL
GtkTreeRowReference *gtk_tree_row_reference_new_proxy (GObject             *proxy,
						       GtkTreeModel        *model,
						       GtkTreePath         *path);
GDK_AVAILABLE_IN_ALL
GtkTreePath         *gtk_tree_row_reference_get_path  (GtkTreeRowReference *reference);
GDK_AVAILABLE_IN_ALL
GtkTreeModel        *gtk_tree_row_reference_get_model (GtkTreeRowReference *reference);
GDK_AVAILABLE_IN_ALL
gboolean             gtk_tree_row_reference_valid     (GtkTreeRowReference *reference);
GDK_AVAILABLE_IN_ALL
GtkTreeRowReference *gtk_tree_row_reference_copy      (GtkTreeRowReference *reference);
GDK_AVAILABLE_IN_ALL
void                 gtk_tree_row_reference_free      (GtkTreeRowReference *reference);
/* These two functions are only needed if you created the row reference with a
 * proxy object */
GDK_AVAILABLE_IN_ALL
void                 gtk_tree_row_reference_inserted  (GObject     *proxy,
						       GtkTreePath *path);
GDK_AVAILABLE_IN_ALL
void                 gtk_tree_row_reference_deleted   (GObject     *proxy,
						       GtkTreePath *path);
GDK_AVAILABLE_IN_ALL
void                 gtk_tree_row_reference_reordered (GObject     *proxy,
						       GtkTreePath *path,
						       GtkTreeIter *iter,
						       gint        *new_order);

/* GtkTreeIter operations */
GDK_AVAILABLE_IN_ALL
GtkTreeIter *     gtk_tree_iter_copy             (GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void              gtk_tree_iter_free             (GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
GType             gtk_tree_iter_get_type         (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GType             gtk_tree_model_get_type        (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkTreeModelFlags gtk_tree_model_get_flags       (GtkTreeModel *tree_model);
GDK_AVAILABLE_IN_ALL
gint              gtk_tree_model_get_n_columns   (GtkTreeModel *tree_model);
GDK_AVAILABLE_IN_ALL
GType             gtk_tree_model_get_column_type (GtkTreeModel *tree_model,
						  gint          index_);


/* Iterator movement */
GDK_AVAILABLE_IN_ALL
gboolean          gtk_tree_model_get_iter        (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter,
						  GtkTreePath  *path);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_tree_model_get_iter_from_string (GtkTreeModel *tree_model,
						       GtkTreeIter  *iter,
						       const char  *path_string);
GDK_AVAILABLE_IN_ALL
char *           gtk_tree_model_get_string_from_iter (GtkTreeModel *tree_model,
                                                       GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_tree_model_get_iter_first  (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
GtkTreePath *     gtk_tree_model_get_path        (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void              gtk_tree_model_get_value       (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter,
						  gint          column,
						  GValue       *value);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_tree_model_iter_previous   (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_tree_model_iter_next       (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_tree_model_iter_children   (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter,
						  GtkTreeIter  *parent);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_tree_model_iter_has_child  (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
gint              gtk_tree_model_iter_n_children (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_tree_model_iter_nth_child  (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter,
						  GtkTreeIter  *parent,
						  gint          n);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_tree_model_iter_parent     (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter,
						  GtkTreeIter  *child);
GDK_AVAILABLE_IN_ALL
void              gtk_tree_model_ref_node        (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void              gtk_tree_model_unref_node      (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void              gtk_tree_model_get             (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter,
						  ...);
GDK_AVAILABLE_IN_ALL
void              gtk_tree_model_get_valist      (GtkTreeModel *tree_model,
						  GtkTreeIter  *iter,
						  va_list       var_args);


GDK_AVAILABLE_IN_ALL
void              gtk_tree_model_foreach         (GtkTreeModel            *model,
						  GtkTreeModelForeachFunc  func,
						  gpointer                 user_data);

/* Signals */
GDK_AVAILABLE_IN_ALL
void gtk_tree_model_row_changed           (GtkTreeModel *tree_model,
					   GtkTreePath  *path,
					   GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void gtk_tree_model_row_inserted          (GtkTreeModel *tree_model,
					   GtkTreePath  *path,
					   GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void gtk_tree_model_row_has_child_toggled (GtkTreeModel *tree_model,
					   GtkTreePath  *path,
					   GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void gtk_tree_model_row_deleted           (GtkTreeModel *tree_model,
					   GtkTreePath  *path);
GDK_AVAILABLE_IN_ALL
void gtk_tree_model_rows_reordered        (GtkTreeModel *tree_model,
					   GtkTreePath  *path,
					   GtkTreeIter  *iter,
					   gint         *new_order);
GDK_AVAILABLE_IN_3_10
void gtk_tree_model_rows_reordered_with_length (GtkTreeModel *tree_model,
						GtkTreePath  *path,
						GtkTreeIter  *iter,
						gint         *new_order,
						gint          length);

G_END_DECLS

#endif /* __GTK_TREE_MODEL_H__ */
#define headerfilename "gtk/./gtkcelleditable.h"
/* file: gtk/./gtkcelleditable.h */
/* gtkcelleditable.h
 * Copyright (C) 2001  Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_EDITABLE_H__
#define __GTK_CELL_EDITABLE_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_EDITABLE()            (gtk_cell_editable_get_type ())
#define GTK_CELL_EDITABLE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_EDITABLE, GtkCellEditable))
#define GTK_CELL_EDITABLE_CLASS(obj)      (G_TYPE_CHECK_CLASS_CAST ((obj), GTK_TYPE_CELL_EDITABLE, GtkCellEditableIface))
#define GTK_IS_CELL_EDITABLE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_EDITABLE))
#define GTK_CELL_EDITABLE_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTK_TYPE_CELL_EDITABLE, GtkCellEditableIface))


/**
 * GtkCellEditableIface:
 * @editing_done: Signal is a sign for the cell renderer to update its
 *    value from the cell_editable.
 * @remove_widget: Signal is meant to indicate that the cell is
 *    finished editing, and the widget may now be destroyed.
 * @start_editing: Begins editing on a cell_editable.
 */


GDK_AVAILABLE_IN_ALL
GType gtk_cell_editable_get_type      (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
void  gtk_cell_editable_start_editing (GtkCellEditable *cell_editable,
				       GdkEvent        *event);
GDK_AVAILABLE_IN_ALL
void  gtk_cell_editable_editing_done  (GtkCellEditable *cell_editable);
GDK_AVAILABLE_IN_ALL
void  gtk_cell_editable_remove_widget (GtkCellEditable *cell_editable);


G_END_DECLS

#endif /* __GTK_CELL_EDITABLE_H__ */
#define headerfilename "gtk/./gtkcellrenderer.h"
/* file: gtk/./gtkcellrenderer.h */
/* gtkcellrenderer.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_RENDERER_H__
#define __GTK_CELL_RENDERER_H__



#include <gtk/gtkcelleditable.h>

G_BEGIN_DECLS


/**
 * GtkCellRendererState:
 * @GTK_CELL_RENDERER_SELECTED: The cell is currently selected, and
 *  probably has a selection colored background to render to.
 * @GTK_CELL_RENDERER_PRELIT: The mouse is hovering over the cell.
 * @GTK_CELL_RENDERER_INSENSITIVE: The cell is drawn in an insensitive manner
 * @GTK_CELL_RENDERER_SORTED: The cell is in a sorted row
 * @GTK_CELL_RENDERER_FOCUSED: The cell is in the focus row.
 * @GTK_CELL_RENDERER_EXPANDABLE: The cell is in a row that can be expanded. Since 3.4
 * @GTK_CELL_RENDERER_EXPANDED: The cell is in a row that is expanded. Since 3.4
 *
 * Tells how a cell is to be rendered.
 */
typedef enum
{
  GTK_CELL_RENDERER_SELECTED    = 1 << 0,
  GTK_CELL_RENDERER_PRELIT      = 1 << 1,
  GTK_CELL_RENDERER_INSENSITIVE = 1 << 2,
  /* this flag means the cell is in the sort column/row */
  GTK_CELL_RENDERER_SORTED      = 1 << 3,
  GTK_CELL_RENDERER_FOCUSED     = 1 << 4,
  GTK_CELL_RENDERER_EXPANDABLE  = 1 << 5,
  GTK_CELL_RENDERER_EXPANDED    = 1 << 6
} GtkCellRendererState;

/**
 * GtkCellRendererMode:
 * @GTK_CELL_RENDERER_MODE_INERT: The cell is just for display
 *  and cannot be interacted with.  Note that this doesn’t mean that eg. the
 *  row being drawn can’t be selected -- just that a particular element of
 *  it cannot be individually modified.
 * @GTK_CELL_RENDERER_MODE_ACTIVATABLE: The cell can be clicked.
 * @GTK_CELL_RENDERER_MODE_EDITABLE: The cell can be edited or otherwise modified.
 *
 * Identifies how the user can interact with a particular cell.
 */
typedef enum
{
  GTK_CELL_RENDERER_MODE_INERT,
  GTK_CELL_RENDERER_MODE_ACTIVATABLE,
  GTK_CELL_RENDERER_MODE_EDITABLE
} GtkCellRendererMode;
typedef struct GtkCellRendererPrivate{} GtkCellRendererPrivate;
struct GtkCellRenderer
{
  GInitiallyUnowned parent_instance;

  /*< private >*/
  GtkCellRendererPrivate *priv;
};
typedef struct GtkCellRendererClassPrivate{} GtkCellRendererClassPrivate;
struct GtkCellRendererClass
{
  /*< private >*/
  GInitiallyUnownedClass parent_class;

  /*< public >*/

  /* vtable - not signals */
  GtkSizeRequestMode (* get_request_mode)                (GtkCellRenderer      *cell);
  void               (* get_preferred_width)             (GtkCellRenderer      *cell,
                                                          GtkWidget            *widget,
                                                          gint                 *minimum_size,
                                                          gint                 *natural_size);
  void               (* get_preferred_height_for_width)  (GtkCellRenderer      *cell,
                                                          GtkWidget            *widget,
                                                          gint                  width,
                                                          gint                 *minimum_height,
                                                          gint                 *natural_height);
  void               (* get_preferred_height)            (GtkCellRenderer      *cell,
                                                          GtkWidget            *widget,
                                                          gint                 *minimum_size,
                                                          gint                 *natural_size);
  void               (* get_preferred_width_for_height)  (GtkCellRenderer      *cell,
                                                          GtkWidget            *widget,
                                                          gint                  height,
                                                          gint                 *minimum_width,
                                                          gint                 *natural_width);
  void               (* get_aligned_area)                (GtkCellRenderer      *cell,
                                                          GtkWidget            *widget,
							  GtkCellRendererState  flags,
                                                          const GdkRectangle   *cell_area,
                                                          GdkRectangle         *aligned_area);
  void               (* get_size)                        (GtkCellRenderer      *cell,
                                                          GtkWidget            *widget,
                                                          const GdkRectangle   *cell_area,
                                                          gint                 *x_offset,
                                                          gint                 *y_offset,
                                                          gint                 *width,
                                                          gint                 *height);
  void               (* render)                          (GtkCellRenderer      *cell,
                                                          cairo_t              *cr,
                                                          GtkWidget            *widget,
                                                          const GdkRectangle   *background_area,
                                                          const GdkRectangle   *cell_area,
                                                          GtkCellRendererState  flags);
  gboolean           (* activate)                        (GtkCellRenderer      *cell,
                                                          GdkEvent             *event,
                                                          GtkWidget            *widget,
                                                          const char          *path,
                                                          const GdkRectangle   *background_area,
                                                          const GdkRectangle   *cell_area,
                                                          GtkCellRendererState  flags);
  GtkCellEditable *  (* start_editing)                   (GtkCellRenderer      *cell,
                                                          GdkEvent             *event,
                                                          GtkWidget            *widget,
                                                          const char          *path,
                                                          const GdkRectangle   *background_area,
                                                          const GdkRectangle   *cell_area,
                                                          GtkCellRendererState  flags);

  /* Signals */
  void (* editing_canceled) (GtkCellRenderer *cell);
  void (* editing_started)  (GtkCellRenderer *cell,
			     GtkCellEditable *editable,
			     const char     *path);

  /*< private >*/

  GtkCellRendererClassPrivate *priv;

  /* Padding for future expansion */
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

#define GTK_TYPE_CELL_RENDERER()		  (gtk_cell_renderer_get_type ())
#define GTK_CELL_RENDERER(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER, GtkCellRenderer))
#define GTK_CELL_RENDERER_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER, GtkCellRendererClass))
#define GTK_IS_CELL_RENDERER(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER))
#define GTK_IS_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_RENDERER))
#define GTK_CELL_RENDERER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER, GtkCellRendererClass))

typedef struct _GtkTreeSortable{} GtkTreeSortable; /* Dummy typedef */


/**
 * GtkCellRendererClass:
 * @get_request_mode: Called to gets whether the cell renderer prefers
 *    a height-for-width layout or a width-for-height layout.
 * @get_preferred_width: Called to get a renderer’s natural width.
 * @get_preferred_height_for_width: Called to get a renderer’s natural height for width.
 * @get_preferred_height: Called to get a renderer’s natural height.
 * @get_preferred_width_for_height: Called to get a renderer’s natural width for height.
 * @get_aligned_area: Called to get the aligned area used by @cell inside @cell_area.
 * @get_size: Called to get the width and height needed to render the cell. Deprecated: 3.0.
 * @render: Called to render the content of the #GtkCellRenderer.
 * @activate: Called to activate the content of the #GtkCellRenderer.
 * @start_editing: Called to initiate editing the content of the #GtkCellRenderer.
 * @editing_canceled: Signal gets emitted when the user cancels the process of editing a cell.
 * @editing_started: Signal gets emitted when a cell starts to be edited.
 */
struct GtkTreeSortableIface
{
  /*< private >*/
  GTypeInterface g_iface;

  /*< public >*/

  /* signals */
  void     (* sort_column_changed)   (GtkTreeSortable        *sortable);

  /* virtual table */
  gboolean (* get_sort_column_id)    (GtkTreeSortable        *sortable,
				      gint                   *sort_column_id,
				      GtkSortType            *order);
  void     (* set_sort_column_id)    (GtkTreeSortable        *sortable,
				      gint                    sort_column_id,
				      GtkSortType             order);
  void     (* set_sort_func)         (GtkTreeSortable        *sortable,
				      gint                    sort_column_id,
				      GtkTreeIterCompareFunc  sort_func,
				      gpointer                user_data,
				      GDestroyNotify          destroy);
  void     (* set_default_sort_func) (GtkTreeSortable        *sortable,
				      GtkTreeIterCompareFunc  sort_func,
				      gpointer                user_data,
				      GDestroyNotify          destroy);
  gboolean (* has_default_sort_func) (GtkTreeSortable        *sortable);
};
typedef struct GtkCellAreaPrivate{} GtkCellAreaPrivate;

GDK_AVAILABLE_IN_ALL
GType              gtk_cell_renderer_get_type       (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkSizeRequestMode gtk_cell_renderer_get_request_mode               (GtkCellRenderer    *cell);
GDK_AVAILABLE_IN_ALL
void               gtk_cell_renderer_get_preferred_width            (GtkCellRenderer    *cell,
                                                                     GtkWidget          *widget,
                                                                     gint               *minimum_size,
                                                                     gint               *natural_size);
GDK_AVAILABLE_IN_ALL
void               gtk_cell_renderer_get_preferred_height_for_width (GtkCellRenderer    *cell,
                                                                     GtkWidget          *widget,
                                                                     gint                width,
                                                                     gint               *minimum_height,
                                                                     gint               *natural_height);
GDK_AVAILABLE_IN_ALL
void               gtk_cell_renderer_get_preferred_height           (GtkCellRenderer    *cell,
                                                                     GtkWidget          *widget,
                                                                     gint               *minimum_size,
                                                                     gint               *natural_size);
GDK_AVAILABLE_IN_ALL
void               gtk_cell_renderer_get_preferred_width_for_height (GtkCellRenderer    *cell,
                                                                     GtkWidget          *widget,
                                                                     gint                height,
                                                                     gint               *minimum_width,
                                                                     gint               *natural_width);
GDK_AVAILABLE_IN_ALL
void               gtk_cell_renderer_get_preferred_size             (GtkCellRenderer    *cell,
                                                                     GtkWidget          *widget,
                                                                     GtkRequisition     *minimum_size,
                                                                     GtkRequisition     *natural_size);
GDK_AVAILABLE_IN_ALL
void               gtk_cell_renderer_get_aligned_area               (GtkCellRenderer    *cell,
								     GtkWidget          *widget,
								     GtkCellRendererState flags,
								     const GdkRectangle *cell_area,
								     GdkRectangle       *aligned_area);

GDK_DEPRECATED_IN_3_0_FOR(gtk_cell_renderer_get_preferred_size)
void             gtk_cell_renderer_get_size       (GtkCellRenderer      *cell,
                                                   GtkWidget            *widget,
                                                   const GdkRectangle   *cell_area,
                                                   gint                 *x_offset,
                                                   gint                 *y_offset,
                                                   gint                 *width,
                                                   gint                 *height);
GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_render         (GtkCellRenderer      *cell,
                                                   cairo_t              *cr,
						   GtkWidget            *widget,
						   const GdkRectangle   *background_area,
						   const GdkRectangle   *cell_area,
						   GtkCellRendererState  flags);
GDK_AVAILABLE_IN_ALL
gboolean         gtk_cell_renderer_activate       (GtkCellRenderer      *cell,
						   GdkEvent             *event,
						   GtkWidget            *widget,
						   const char          *path,
						   const GdkRectangle   *background_area,
						   const GdkRectangle   *cell_area,
						   GtkCellRendererState  flags);
GDK_AVAILABLE_IN_ALL
GtkCellEditable *gtk_cell_renderer_start_editing  (GtkCellRenderer      *cell,
						   GdkEvent             *event,
						   GtkWidget            *widget,
						   const char          *path,
						   const GdkRectangle   *background_area,
						   const GdkRectangle   *cell_area,
						   GtkCellRendererState  flags);

GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_set_fixed_size (GtkCellRenderer      *cell,
						   gint                  width,
						   gint                  height);
GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_get_fixed_size (GtkCellRenderer      *cell,
						   gint                 *width,
						   gint                 *height);

GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_set_alignment  (GtkCellRenderer      *cell,
                                                   gfloat                xalign,
                                                   gfloat                yalign);
GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_get_alignment  (GtkCellRenderer      *cell,
                                                   gfloat               *xalign,
                                                   gfloat               *yalign);

GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_set_padding    (GtkCellRenderer      *cell,
                                                   gint                  xpad,
                                                   gint                  ypad);
GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_get_padding    (GtkCellRenderer      *cell,
                                                   gint                 *xpad,
                                                   gint                 *ypad);

GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_set_visible    (GtkCellRenderer      *cell,
                                                   gboolean              visible);
GDK_AVAILABLE_IN_ALL
gboolean         gtk_cell_renderer_get_visible    (GtkCellRenderer      *cell);

GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_set_sensitive  (GtkCellRenderer      *cell,
                                                   gboolean              sensitive);
GDK_AVAILABLE_IN_ALL
gboolean         gtk_cell_renderer_get_sensitive  (GtkCellRenderer      *cell);

GDK_AVAILABLE_IN_ALL
gboolean         gtk_cell_renderer_is_activatable (GtkCellRenderer      *cell);

/* For use by cell renderer implementations only */
GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_stop_editing   (GtkCellRenderer      *cell,
                                                   gboolean              canceled);


void            _gtk_cell_renderer_calc_offset    (GtkCellRenderer      *cell,
                                                   const GdkRectangle   *cell_area,
                                                   GtkTextDirection      direction,
                                                   gint                  width,
                                                   gint                  height,
                                                   gint                 *x_offset,
                                                   gint                 *y_offset);

GDK_AVAILABLE_IN_ALL
GtkStateFlags   gtk_cell_renderer_get_state       (GtkCellRenderer      *cell,
                                                   GtkWidget            *widget,
                                                   GtkCellRendererState  cell_state);

GDK_AVAILABLE_IN_ALL
void            gtk_cell_renderer_class_set_accessible_type 
                                                  (GtkCellRendererClass *renderer_class,
                                                   GType                 type);
GType           _gtk_cell_renderer_get_accessible_type
                                                  (GtkCellRenderer *     renderer);

G_END_DECLS

#endif /* __GTK_CELL_RENDERER_H__ */
#define headerfilename "gtk/./gtktreesortable.h"
/* file: gtk/./gtktreesortable.h */
/* gtktreesortable.h
 * Copyright (C) 2001  Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_TREE_SORTABLE_H__
#define __GTK_TREE_SORTABLE_H__




#include <gtk/gtkenums.h>
#include <gtk/gtktreemodel.h>


G_BEGIN_DECLS

#define GTK_TYPE_TREE_SORTABLE()            (gtk_tree_sortable_get_type ())
#define GTK_TREE_SORTABLE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TREE_SORTABLE, GtkTreeSortable))
#define GTK_TREE_SORTABLE_CLASS(obj)      (G_TYPE_CHECK_CLASS_CAST ((obj), GTK_TYPE_TREE_SORTABLE, GtkTreeSortableIface))
#define GTK_IS_TREE_SORTABLE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TREE_SORTABLE))
#define GTK_TREE_SORTABLE_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTK_TYPE_TREE_SORTABLE, GtkTreeSortableIface))

/**
 * GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID:
 *
 * The GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID can be used to make a
 * #GtkTreeSortable use the default sort function.
 *
 * See also gtk_tree_sortable_set_sort_column_id()
 */
#define GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID (-1)

/**
 * GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID:
 *
 * The GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID can be used to make a
 * #GtkTreeSortable use no sorting.
 *
 * See also gtk_tree_sortable_set_sort_column_id()
 */
#define GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID (-2)


/**
 * GtkTreeIterCompareFunc:
 * @model: The #GtkTreeModel the comparison is within
 * @a: A #GtkTreeIter in @model
 * @b: Another #GtkTreeIter in @model
 * @user_data: Data passed when the compare func is assigned e.g. by
 *  gtk_tree_sortable_set_sort_func()
 *
 * A GtkTreeIterCompareFunc should return a negative integer, zero, or a positive
 * integer if @a sorts before @b, @a sorts with @b, or @a sorts after @b
 * respectively. If two iters compare as equal, their order in the sorted model
 * is undefined. In order to ensure that the #GtkTreeSortable behaves as
 * expected, the GtkTreeIterCompareFunc must define a partial order on
 * the model, i.e. it must be reflexive, antisymmetric and transitive.
 *
 * For example, if @model is a product catalogue, then a compare function
 * for the “price” column could be one which returns
 * `price_of(@a) - price_of(@b)`.
 *
 * Returns: a negative integer, zero or a positive integer depending on whether
 *   @a sorts before, with or after @b
 */
typedef gint (* GtkTreeIterCompareFunc) (GtkTreeModel *model,
					 GtkTreeIter  *a,
					 GtkTreeIter  *b,
					 gpointer      user_data);


/**
 * GtkTreeSortableIface:
 * @sort_column_changed: Signal emitted when the sort column or sort
 *    order of sortable is changed.
 * @get_sort_column_id: Fills in sort_column_id and order with the
 *    current sort column and the order.
 * @set_sort_column_id: Sets the current sort column to be
 *    sort_column_id.
 * @set_sort_func: Sets the comparison function used when sorting to
 *    be sort_func.
 * @set_default_sort_func: Sets the default comparison function used
 *    when sorting to be sort_func.
 * @has_default_sort_func: %TRUE if the model has a default sort
 * function.
 */
struct GtkCellArea
{
  /*< private >*/
  GInitiallyUnowned parent_instance;

  GtkCellAreaPrivate *priv;
};
typedef struct GtkCellAreaContextPrivate{} GtkCellAreaContextPrivate;
struct GtkCellAreaContext
{
  /*< private >*/
  GObject parent_instance;

  GtkCellAreaContextPrivate *priv;
};
struct GtkCellAreaClass
{
  /*< private >*/
  GInitiallyUnownedClass parent_class;

  /*< public >*/

  /* Basic methods */
  void               (* add)                             (GtkCellArea             *area,
                                                          GtkCellRenderer         *renderer);
  void               (* remove)                          (GtkCellArea             *area,
                                                          GtkCellRenderer         *renderer);
  void               (* foreach)                         (GtkCellArea             *area,
                                                          GtkCellCallback          callback,
                                                          gpointer                 callback_data);
  void               (* foreach_alloc)                   (GtkCellArea             *area,
                                                          GtkCellAreaContext      *context,
                                                          GtkWidget               *widget,
                                                          const GdkRectangle      *cell_area,
                                                          const GdkRectangle      *background_area,
                                                          GtkCellAllocCallback     callback,
                                                          gpointer                 callback_data);
  gint               (* event)                           (GtkCellArea             *area,
                                                          GtkCellAreaContext      *context,
                                                          GtkWidget               *widget,
                                                          GdkEvent                *event,
                                                          const GdkRectangle      *cell_area,
                                                          GtkCellRendererState     flags);
  void               (* render)                          (GtkCellArea             *area,
                                                          GtkCellAreaContext      *context,
                                                          GtkWidget               *widget,
                                                          cairo_t                 *cr,
                                                          const GdkRectangle      *background_area,
                                                          const GdkRectangle      *cell_area,
                                                          GtkCellRendererState     flags,
                                                          gboolean                 paint_focus);
  void               (* apply_attributes)                (GtkCellArea             *area,
                                                          GtkTreeModel            *tree_model,
                                                          GtkTreeIter             *iter,
                                                          gboolean                 is_expander,
                                                          gboolean                 is_expanded);

  /* Geometry */
  GtkCellAreaContext *(* create_context)                 (GtkCellArea             *area);
  GtkCellAreaContext *(* copy_context)                   (GtkCellArea             *area,
                                                          GtkCellAreaContext      *context);
  GtkSizeRequestMode (* get_request_mode)                (GtkCellArea             *area);
  void               (* get_preferred_width)             (GtkCellArea             *area,
                                                          GtkCellAreaContext      *context,
                                                          GtkWidget               *widget,
                                                          gint                    *minimum_width,
                                                          gint                    *natural_width);
  void               (* get_preferred_height_for_width)  (GtkCellArea             *area,
                                                          GtkCellAreaContext      *context,
                                                          GtkWidget               *widget,
                                                          gint                     width,
                                                          gint                    *minimum_height,
                                                          gint                    *natural_height);
  void               (* get_preferred_height)            (GtkCellArea             *area,
                                                          GtkCellAreaContext      *context,
                                                          GtkWidget               *widget,
                                                          gint                    *minimum_height,
                                                          gint                    *natural_height);
  void               (* get_preferred_width_for_height)  (GtkCellArea             *area,
                                                          GtkCellAreaContext      *context,
                                                          GtkWidget               *widget,
                                                          gint                     height,
                                                          gint                    *minimum_width,
                                                          gint                    *natural_width);

  /* Cell Properties */
  void               (* set_cell_property)               (GtkCellArea             *area,
                                                          GtkCellRenderer         *renderer,
                                                          guint                    property_id,
                                                          const GValue            *value,
                                                          GParamSpec              *pspec);
  void               (* get_cell_property)               (GtkCellArea             *area,
                                                          GtkCellRenderer         *renderer,
                                                          guint                    property_id,
                                                          GValue                  *value,
                                                          GParamSpec              *pspec);

  /* Focus */
  gboolean           (* focus)                           (GtkCellArea             *area,
                                                          GtkDirectionType         direction);
  gboolean           (* is_activatable)                  (GtkCellArea             *area);
  gboolean           (* activate)                        (GtkCellArea             *area,
                                                          GtkCellAreaContext      *context,
                                                          GtkWidget               *widget,
                                                          const GdkRectangle      *cell_area,
                                                          GtkCellRendererState     flags,
                                                          gboolean                 edit_only);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};


GDK_AVAILABLE_IN_ALL
GType    gtk_tree_sortable_get_type              (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
void     gtk_tree_sortable_sort_column_changed   (GtkTreeSortable        *sortable);
GDK_AVAILABLE_IN_ALL
gboolean gtk_tree_sortable_get_sort_column_id    (GtkTreeSortable        *sortable,
						  gint                   *sort_column_id,
						  GtkSortType            *order);
GDK_AVAILABLE_IN_ALL
void     gtk_tree_sortable_set_sort_column_id    (GtkTreeSortable        *sortable,
						  gint                    sort_column_id,
						  GtkSortType             order);
GDK_AVAILABLE_IN_ALL
void     gtk_tree_sortable_set_sort_func         (GtkTreeSortable        *sortable,
						  gint                    sort_column_id,
						  GtkTreeIterCompareFunc  sort_func,
						  gpointer                user_data,
						  GDestroyNotify          destroy);
GDK_AVAILABLE_IN_ALL
void     gtk_tree_sortable_set_default_sort_func (GtkTreeSortable        *sortable,
						  GtkTreeIterCompareFunc  sort_func,
						  gpointer                user_data,
						  GDestroyNotify          destroy);
GDK_AVAILABLE_IN_ALL
gboolean gtk_tree_sortable_has_default_sort_func (GtkTreeSortable        *sortable);

G_END_DECLS

#endif /* __GTK_TREE_SORTABLE_H__ */
#define headerfilename "gtk/./gtkcellarea.h"
/* file: gtk/./gtkcellarea.h */
/* gtkcellarea.h
 *
 * Copyright (C) 2010 Openismus GmbH
 *
 * Authors:
 *      Tristan Van Berkom <tristanvb@openismus.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_AREA_H__
#define __GTK_CELL_AREA_H__



#include <gtk/gtkcellrenderer.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtktreemodel.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_AREA()                (gtk_cell_area_get_type ())
#define GTK_CELL_AREA(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_AREA, GtkCellArea))
#define GTK_CELL_AREA_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_AREA, GtkCellAreaClass))
#define GTK_IS_CELL_AREA(obj)     (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_AREA))
#define GTK_IS_CELL_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_AREA))
#define GTK_CELL_AREA_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_AREA, GtkCellAreaClass))

typedef struct GtkTreeViewColumnPrivate{} GtkTreeViewColumnPrivate;

/**
 * GTK_CELL_AREA_WARN_INVALID_CELL_PROPERTY_ID:
 * @object: the #GObject on which set_cell_property() or get_cell_property()
 *     was called
 * @property_id: the numeric id of the property
 * @pspec: the #GParamSpec of the property
 *
 * This macro should be used to emit a standard warning about unexpected
 * properties in set_cell_property() and get_cell_property() implementations.
 */
#define GTK_CELL_AREA_WARN_INVALID_CELL_PROPERTY_ID(object, property_id, pspec) \
  G_OBJECT_WARN_INVALID_PSPEC ((object), "cell property id", (property_id), (pspec))

/**
 * GtkCellCallback:
 * @renderer: the cell renderer to operate on
 * @data: (closure): user-supplied data
 *
 * The type of the callback functions used for iterating over
 * the cell renderers of a #GtkCellArea, see gtk_cell_area_foreach().
 *
 * Returns: %TRUE to stop iterating over cells.
 */
typedef gboolean    (*GtkCellCallback) (GtkCellRenderer  *renderer,
                                        gpointer          data);

/**
 * GtkCellAllocCallback:
 * @renderer: the cell renderer to operate on
 * @cell_area: the area allocated to @renderer inside the rectangle
 *     provided to gtk_cell_area_foreach_alloc().
 * @cell_background: the background area for @renderer inside the
 *     background area provided to gtk_cell_area_foreach_alloc().
 * @data: (closure): user-supplied data
 *
 * The type of the callback functions used for iterating over the
 * cell renderers and their allocated areas inside a #GtkCellArea,
 * see gtk_cell_area_foreach_alloc().
 *
 * Returns: %TRUE to stop iterating over cells.
 */
typedef gboolean    (*GtkCellAllocCallback) (GtkCellRenderer    *renderer,
                                             const GdkRectangle *cell_area,
                                             const GdkRectangle *cell_background,
                                             gpointer            data);




/**
 * GtkCellAreaClass:
 * @add: adds a #GtkCellRenderer to the area.
 * @remove: removes a #GtkCellRenderer from the area.
 * @foreach: calls the #GtkCellCallback function on every #GtkCellRenderer in
 *     the area with the provided user data until the callback returns %TRUE.
 * @foreach_alloc: Calls the #GtkCellAllocCallback function on every
 *     #GtkCellRenderer in the area with the allocated area for the cell
 *     and the provided user data until the callback returns %TRUE.
 * @event: Handle an event in the area, this is generally used to activate
 *     a cell at the event location for button events but can also be used
 *     to generically pass events to #GtkWidgets drawn onto the area.
 * @render: Actually render the area’s cells to the specified rectangle,
 *     @background_area should be correctly distributed to the cells
 *     corresponding background areas.
 * @apply_attributes: Apply the cell attributes to the cells. This is
 *     implemented as a signal and generally #GtkCellArea subclasses don't
 *     need to implement it since it is handled by the base class.
 * @create_context: Creates and returns a class specific #GtkCellAreaContext
 *     to store cell alignment and allocation details for a said #GtkCellArea
 *     class.
 * @copy_context: Creates a new #GtkCellAreaContext in the same state as
 *     the passed @context with any cell alignment data and allocations intact.
 * @get_request_mode: This allows an area to tell its layouting widget whether
 *     it prefers to be allocated in %GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH or
 *     %GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT mode.
 * @get_preferred_width: Calculates the minimum and natural width of the
 *     areas cells with the current attributes applied while considering
 *     the particular layouting details of the said #GtkCellArea. While
 *     requests are performed over a series of rows, alignments and overall
 *     minimum and natural sizes should be stored in the corresponding
 *     #GtkCellAreaContext.
 * @get_preferred_height_for_width: Calculates the minimum and natural height
 *     for the area if the passed @context would be allocated the given width.
 *     When implementing this virtual method it is safe to assume that @context
 *     has already stored the aligned cell widths for every #GtkTreeModel row
 *     that @context will be allocated for since this information was stored
 *     at #GtkCellAreaClass.get_preferred_width() time. This virtual method
 *     should also store any necessary alignments of cell heights for the
 *     case that the context is allocated a height.
 * @get_preferred_height: Calculates the minimum and natural height of the
 *     areas cells with the current attributes applied. Essentially this is
 *     the same as #GtkCellAreaClass.get_preferred_width() only for areas
 *     that are being requested as %GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT.
 * @get_preferred_width_for_height: Calculates the minimum and natural width
 *     for the area if the passed @context would be allocated the given
 *     height. The same as #GtkCellAreaClass.get_preferred_height_for_width()
 *     only for handling requests in the %GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT
 *     mode.
 * @set_cell_property: This should be implemented to handle changes in child
 *     cell properties for a given #GtkCellRenderer that were previously
 *     installed on the #GtkCellAreaClass with gtk_cell_area_class_install_cell_property().
 * @get_cell_property: This should be implemented to report the values of
 *     child cell properties for a given child #GtkCellRenderer.
 * @focus: This virtual method should be implemented to navigate focus from
 *     cell to cell inside the #GtkCellArea. The #GtkCellArea should move
 *     focus from cell to cell inside the area and return %FALSE if focus
 *     logically leaves the area with the following exceptions: When the
 *     area contains no activatable cells, the entire area recieves focus.
 *     Focus should not be given to cells that are actually “focus siblings”
 *     of other sibling cells (see gtk_cell_area_get_focus_from_sibling()).
 *     Focus is set by calling gtk_cell_area_set_focus_cell().
 * @is_activatable: Returns whether the #GtkCellArea can respond to
 *     #GtkCellAreaClass.activate(), usually this does not need to be
 *     implemented since the base class takes care of this however it can
 *     be enhanced if the #GtkCellArea subclass can handle activation in
 *     other ways than activating its #GtkCellRenderers.
 * @activate: This is called when the layouting widget rendering the
 *     #GtkCellArea activates the focus cell (see gtk_cell_area_get_focus_cell()).
 */
struct GtkTreeViewColumn
{
  GInitiallyUnowned parent_instance;

  GtkTreeViewColumnPrivate *priv;
};
struct GtkTreeViewColumnClass
{
  GInitiallyUnownedClass parent_class;

  void (*clicked) (GtkTreeViewColumn *tree_column);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType                 gtk_cell_area_get_type                       (void) G_GNUC_CONST;

/* Basic methods */
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_add                            (GtkCellArea          *area,
                                                                    GtkCellRenderer      *renderer);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_remove                         (GtkCellArea          *area,
                                                                    GtkCellRenderer      *renderer);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_cell_area_has_renderer                   (GtkCellArea          *area,
                                                                    GtkCellRenderer      *renderer);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_foreach                        (GtkCellArea          *area,
                                                                    GtkCellCallback       callback,
                                                                    gpointer              callback_data);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_foreach_alloc                  (GtkCellArea          *area,
                                                                    GtkCellAreaContext   *context,
                                                                    GtkWidget            *widget,
                                                                    const GdkRectangle   *cell_area,
                                                                    const GdkRectangle   *background_area,
                                                                    GtkCellAllocCallback  callback,
                                                                    gpointer              callback_data);
GDK_AVAILABLE_IN_ALL
gint                  gtk_cell_area_event                          (GtkCellArea          *area,
                                                                    GtkCellAreaContext   *context,
                                                                    GtkWidget            *widget,
                                                                    GdkEvent             *event,
                                                                    const GdkRectangle   *cell_area,
                                                                    GtkCellRendererState  flags);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_render                         (GtkCellArea          *area,
                                                                    GtkCellAreaContext   *context,
                                                                    GtkWidget            *widget,
                                                                    cairo_t              *cr,
                                                                    const GdkRectangle   *background_area,
                                                                    const GdkRectangle   *cell_area,
                                                                    GtkCellRendererState  flags,
                                                                    gboolean              paint_focus);

GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_get_cell_allocation            (GtkCellArea          *area,
                                                                    GtkCellAreaContext   *context,
                                                                    GtkWidget            *widget,
                                                                    GtkCellRenderer      *renderer,
                                                                    const GdkRectangle   *cell_area,
                                                                    GdkRectangle         *allocation);
GDK_AVAILABLE_IN_ALL
GtkCellRenderer      *gtk_cell_area_get_cell_at_position           (GtkCellArea          *area,
                                                                    GtkCellAreaContext   *context,
                                                                    GtkWidget            *widget,
                                                                    const GdkRectangle   *cell_area,
                                                                    gint                  x,
                                                                    gint                  y,
                                                                    GdkRectangle         *alloc_area);

/* Geometry */
GDK_AVAILABLE_IN_ALL
GtkCellAreaContext   *gtk_cell_area_create_context                 (GtkCellArea        *area);
GDK_AVAILABLE_IN_ALL
GtkCellAreaContext   *gtk_cell_area_copy_context                   (GtkCellArea        *area,
                                                                    GtkCellAreaContext *context);
GDK_AVAILABLE_IN_ALL
GtkSizeRequestMode    gtk_cell_area_get_request_mode               (GtkCellArea        *area);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_get_preferred_width            (GtkCellArea        *area,
                                                                    GtkCellAreaContext *context,
                                                                    GtkWidget          *widget,
                                                                    gint               *minimum_width,
                                                                    gint               *natural_width);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_get_preferred_height_for_width (GtkCellArea        *area,
                                                                    GtkCellAreaContext *context,
                                                                    GtkWidget          *widget,
                                                                    gint                width,
                                                                    gint               *minimum_height,
                                                                    gint               *natural_height);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_get_preferred_height           (GtkCellArea        *area,
                                                                    GtkCellAreaContext *context,
                                                                    GtkWidget          *widget,
                                                                    gint               *minimum_height,
                                                                    gint               *natural_height);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_get_preferred_width_for_height (GtkCellArea        *area,
                                                                    GtkCellAreaContext *context,
                                                                    GtkWidget          *widget,
                                                                    gint                height,
                                                                    gint               *minimum_width,
                                                                    gint               *natural_width);
GDK_AVAILABLE_IN_ALL
const char *         gtk_cell_area_get_current_path_string        (GtkCellArea        *area);


/* Attributes */
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_apply_attributes               (GtkCellArea        *area,
                                                                    GtkTreeModel       *tree_model,
                                                                    GtkTreeIter        *iter,
                                                                    gboolean            is_expander,
                                                                    gboolean            is_expanded);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_attribute_connect              (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char        *attribute,
                                                                    gint                column);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_attribute_disconnect           (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char        *attribute);
GDK_AVAILABLE_IN_3_14
gint                  gtk_cell_area_attribute_get_column           (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char        *attribute);


/* Cell Properties */
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_class_install_cell_property    (GtkCellAreaClass   *aclass,
                                                                    guint               property_id,
                                                                    GParamSpec         *pspec);
GDK_AVAILABLE_IN_ALL
GParamSpec*           gtk_cell_area_class_find_cell_property       (GtkCellAreaClass   *aclass,
                                                                    const char        *property_name);
GDK_AVAILABLE_IN_ALL
GParamSpec**          gtk_cell_area_class_list_cell_properties     (GtkCellAreaClass   *aclass,
                                                                    guint                   *n_properties);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_add_with_properties            (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char     *first_prop_name,
                                                                    ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_cell_set                       (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char        *first_prop_name,
                                                                    ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_cell_get                       (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char        *first_prop_name,
                                                                    ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_cell_set_valist                (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char        *first_property_name,
                                                                    va_list             var_args);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_cell_get_valist                (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char        *first_property_name,
                                                                    va_list             var_args);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_cell_set_property              (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char        *property_name,
                                                                    const GValue       *value);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_cell_get_property              (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    const char        *property_name,
                                                                    GValue             *value);

/* Focus */
GDK_AVAILABLE_IN_ALL
gboolean              gtk_cell_area_is_activatable                 (GtkCellArea         *area);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_cell_area_activate                       (GtkCellArea         *area,
                                                                    GtkCellAreaContext  *context,
                                                                    GtkWidget           *widget,
                                                                    const GdkRectangle  *cell_area,
                                                                    GtkCellRendererState flags,
                                                                    gboolean             edit_only);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_cell_area_focus                          (GtkCellArea         *area,
                                                                    GtkDirectionType     direction);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_set_focus_cell                 (GtkCellArea          *area,
                                                                    GtkCellRenderer      *renderer);
GDK_AVAILABLE_IN_ALL
GtkCellRenderer      *gtk_cell_area_get_focus_cell                 (GtkCellArea          *area);


/* Focus siblings */
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_add_focus_sibling              (GtkCellArea          *area,
                                                                    GtkCellRenderer      *renderer,
                                                                    GtkCellRenderer      *sibling);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_remove_focus_sibling           (GtkCellArea          *area,
                                                                    GtkCellRenderer      *renderer,
                                                                    GtkCellRenderer      *sibling);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_cell_area_is_focus_sibling               (GtkCellArea          *area,
                                                                    GtkCellRenderer      *renderer,
                                                                    GtkCellRenderer      *sibling);
GDK_AVAILABLE_IN_ALL
const GList *         gtk_cell_area_get_focus_siblings             (GtkCellArea          *area,
                                                                    GtkCellRenderer      *renderer);
GDK_AVAILABLE_IN_ALL
GtkCellRenderer      *gtk_cell_area_get_focus_from_sibling         (GtkCellArea          *area,
                                                                    GtkCellRenderer      *renderer);

/* Cell Activation/Editing */
GDK_AVAILABLE_IN_ALL
GtkCellRenderer      *gtk_cell_area_get_edited_cell                (GtkCellArea          *area);
GDK_AVAILABLE_IN_ALL
GtkCellEditable      *gtk_cell_area_get_edit_widget                (GtkCellArea          *area);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_cell_area_activate_cell                  (GtkCellArea          *area,
                                                                    GtkWidget            *widget,
                                                                    GtkCellRenderer      *renderer,
                                                                    GdkEvent             *event,
                                                                    const GdkRectangle   *cell_area,
                                                                    GtkCellRendererState  flags);
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_stop_editing                   (GtkCellArea          *area,
                                                                    gboolean              canceled);

/* Functions for area implementations */

/* Distinguish the inner cell area from the whole requested area including margins */
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_inner_cell_area                (GtkCellArea        *area,
                                                                    GtkWidget          *widget,
                                                                    const GdkRectangle *cell_area,
                                                                    GdkRectangle       *inner_area);

/* Request the size of a cell while respecting the cell margins (requests are margin inclusive) */
GDK_AVAILABLE_IN_ALL
void                  gtk_cell_area_request_renderer               (GtkCellArea        *area,
                                                                    GtkCellRenderer    *renderer,
                                                                    GtkOrientation      orientation,
                                                                    GtkWidget          *widget,
                                                                    gint                for_size,
                                                                    gint               *minimum_size,
                                                                    gint               *natural_size);

/* For api stability, this is called from gtkcelllayout.c in order to ensure the correct
 * object is passed to the user function in gtk_cell_layout_set_cell_data_func.
 *
 * This private api takes gpointer & GFunc arguments to circumvent circular header file
 * dependancies.
 */
void                 _gtk_cell_area_set_cell_data_func_with_proxy  (GtkCellArea           *area,
								    GtkCellRenderer       *cell,
								    GFunc                  func,
								    gpointer               func_data,
								    GDestroyNotify         destroy,
								    gpointer               proxy);

G_END_DECLS

#endif /* __GTK_CELL_AREA_H__ */
#define headerfilename "gtk/./gtktreeviewcolumn.h"
/* file: gtk/./gtktreeviewcolumn.h */
/* gtktreeviewcolumn.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_TREE_VIEW_COLUMN_H__
#define __GTK_TREE_VIEW_COLUMN_H__



#include <gtk/gtkcellrenderer.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtktreesortable.h>
#include <gtk/gtkcellarea.h>


G_BEGIN_DECLS


#define GTK_TYPE_TREE_VIEW_COLUMN()	     (gtk_tree_view_column_get_type ())
#define GTK_TREE_VIEW_COLUMN(obj)	     (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TREE_VIEW_COLUMN, GtkTreeViewColumn))
#define GTK_TREE_VIEW_COLUMN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_TREE_VIEW_COLUMN, GtkTreeViewColumnClass))
#define GTK_IS_TREE_VIEW_COLUMN(obj)	     (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TREE_VIEW_COLUMN))
#define GTK_IS_TREE_VIEW_COLUMN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_TREE_VIEW_COLUMN))
#define GTK_TREE_VIEW_COLUMN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_TREE_VIEW_COLUMN, GtkTreeViewColumnClass))


/**
 * GtkTreeViewColumnSizing:
 * @GTK_TREE_VIEW_COLUMN_GROW_ONLY: Columns only get bigger in reaction to changes in the model
 * @GTK_TREE_VIEW_COLUMN_AUTOSIZE: Columns resize to be the optimal size everytime the model changes.
 * @GTK_TREE_VIEW_COLUMN_FIXED: Columns are a fixed numbers of pixels wide.
 *
 * The sizing method the column uses to determine its width.  Please note
 * that @GTK_TREE_VIEW_COLUMN_AUTOSIZE are inefficient for large views, and
 * can make columns appear choppy.
 */
typedef enum
{
  GTK_TREE_VIEW_COLUMN_GROW_ONLY,
  GTK_TREE_VIEW_COLUMN_AUTOSIZE,
  GTK_TREE_VIEW_COLUMN_FIXED
} GtkTreeViewColumnSizing;

/**
 * GtkTreeCellDataFunc:
 * @tree_column: A #GtkTreeViewColumn
 * @cell: The #GtkCellRenderer that is being rendered by @tree_column
 * @tree_model: The #GtkTreeModel being rendered
 * @iter: A #GtkTreeIter of the current row rendered
 * @data: (closure): user data
 *
 * A function to set the properties of a cell instead of just using the
 * straight mapping between the cell and the model.  This is useful for
 * customizing the cell renderer.  For example, a function might get an
 * integer from the @tree_model, and render it to the “text” attribute of
 * “cell” by converting it to its written equivilent.  This is set by
 * calling gtk_tree_view_column_set_cell_data_func()
 */
typedef void (* GtkTreeCellDataFunc) (GtkTreeViewColumn *tree_column,
				      GtkCellRenderer   *cell,
				      GtkTreeModel      *tree_model,
				      GtkTreeIter       *iter,
				      gpointer           data);




GDK_AVAILABLE_IN_ALL
GType                   gtk_tree_view_column_get_type            (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkTreeViewColumn      *gtk_tree_view_column_new                 (void);
GDK_AVAILABLE_IN_ALL
GtkTreeViewColumn      *gtk_tree_view_column_new_with_area       (GtkCellArea             *area);
GDK_AVAILABLE_IN_ALL
GtkTreeViewColumn      *gtk_tree_view_column_new_with_attributes (const char             *title,
								  GtkCellRenderer         *cell,
								  ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_pack_start          (GtkTreeViewColumn       *tree_column,
								  GtkCellRenderer         *cell,
								  gboolean                 expand);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_pack_end            (GtkTreeViewColumn       *tree_column,
								  GtkCellRenderer         *cell,
								  gboolean                 expand);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_clear               (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_add_attribute       (GtkTreeViewColumn       *tree_column,
								  GtkCellRenderer         *cell_renderer,
								  const char             *attribute,
								  gint                     column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_attributes      (GtkTreeViewColumn       *tree_column,
								  GtkCellRenderer         *cell_renderer,
								  ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_cell_data_func  (GtkTreeViewColumn       *tree_column,
								  GtkCellRenderer         *cell_renderer,
								  GtkTreeCellDataFunc      func,
								  gpointer                 func_data,
								  GDestroyNotify           destroy);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_clear_attributes    (GtkTreeViewColumn       *tree_column,
								  GtkCellRenderer         *cell_renderer);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_spacing         (GtkTreeViewColumn       *tree_column,
								  gint                     spacing);
GDK_AVAILABLE_IN_ALL
gint                    gtk_tree_view_column_get_spacing         (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_visible         (GtkTreeViewColumn       *tree_column,
								  gboolean                 visible);
GDK_AVAILABLE_IN_ALL
gboolean                gtk_tree_view_column_get_visible         (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_resizable       (GtkTreeViewColumn       *tree_column,
								  gboolean                 resizable);
GDK_AVAILABLE_IN_ALL
gboolean                gtk_tree_view_column_get_resizable       (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_sizing          (GtkTreeViewColumn       *tree_column,
								  GtkTreeViewColumnSizing  type);
GDK_AVAILABLE_IN_ALL
GtkTreeViewColumnSizing gtk_tree_view_column_get_sizing          (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_3_2
gint                    gtk_tree_view_column_get_x_offset        (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
gint                    gtk_tree_view_column_get_width           (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
gint                    gtk_tree_view_column_get_fixed_width     (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_fixed_width     (GtkTreeViewColumn       *tree_column,
								  gint                     fixed_width);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_min_width       (GtkTreeViewColumn       *tree_column,
								  gint                     min_width);
GDK_AVAILABLE_IN_ALL
gint                    gtk_tree_view_column_get_min_width       (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_max_width       (GtkTreeViewColumn       *tree_column,
								  gint                     max_width);
GDK_AVAILABLE_IN_ALL
gint                    gtk_tree_view_column_get_max_width       (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_clicked             (GtkTreeViewColumn       *tree_column);



/* Options for manipulating the column headers
 */
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_title           (GtkTreeViewColumn       *tree_column,
								  const char             *title);
GDK_AVAILABLE_IN_ALL
const char *           gtk_tree_view_column_get_title           (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_expand          (GtkTreeViewColumn       *tree_column,
								  gboolean                 expand);
GDK_AVAILABLE_IN_ALL
gboolean                gtk_tree_view_column_get_expand          (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_clickable       (GtkTreeViewColumn       *tree_column,
								  gboolean                 clickable);
GDK_AVAILABLE_IN_ALL
gboolean                gtk_tree_view_column_get_clickable       (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_widget          (GtkTreeViewColumn       *tree_column,
								  GtkWidget               *widget);
GDK_AVAILABLE_IN_ALL
GtkWidget              *gtk_tree_view_column_get_widget          (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_alignment       (GtkTreeViewColumn       *tree_column,
								  gfloat                   xalign);
GDK_AVAILABLE_IN_ALL
gfloat                  gtk_tree_view_column_get_alignment       (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_reorderable     (GtkTreeViewColumn       *tree_column,
								  gboolean                 reorderable);
GDK_AVAILABLE_IN_ALL
gboolean                gtk_tree_view_column_get_reorderable     (GtkTreeViewColumn       *tree_column);



/* You probably only want to use gtk_tree_view_column_set_sort_column_id.  The
 * other sorting functions exist primarily to let others do their own custom sorting.
 */
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_sort_column_id  (GtkTreeViewColumn       *tree_column,
								  gint                     sort_column_id);
GDK_AVAILABLE_IN_ALL
gint                    gtk_tree_view_column_get_sort_column_id  (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_sort_indicator  (GtkTreeViewColumn       *tree_column,
								  gboolean                 setting);
GDK_AVAILABLE_IN_ALL
gboolean                gtk_tree_view_column_get_sort_indicator  (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_set_sort_order      (GtkTreeViewColumn       *tree_column,
								  GtkSortType              order);
GDK_AVAILABLE_IN_ALL
GtkSortType             gtk_tree_view_column_get_sort_order      (GtkTreeViewColumn       *tree_column);


/* These functions are meant primarily for interaction between the GtkTreeView and the column.
 */
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_cell_set_cell_data  (GtkTreeViewColumn       *tree_column,
								  GtkTreeModel            *tree_model,
								  GtkTreeIter             *iter,
								  gboolean                 is_expander,
								  gboolean                 is_expanded);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_cell_get_size       (GtkTreeViewColumn       *tree_column,
								  const GdkRectangle      *cell_area,
								  gint                    *x_offset,
								  gint                    *y_offset,
								  gint                    *width,
								  gint                    *height);
GDK_AVAILABLE_IN_ALL
gboolean                gtk_tree_view_column_cell_is_visible     (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_focus_cell          (GtkTreeViewColumn       *tree_column,
								  GtkCellRenderer         *cell);
GDK_AVAILABLE_IN_ALL
gboolean                gtk_tree_view_column_cell_get_position   (GtkTreeViewColumn       *tree_column,
					                          GtkCellRenderer         *cell_renderer,
					                          gint                    *x_offset,
					                          gint                    *width);
GDK_AVAILABLE_IN_ALL
void                    gtk_tree_view_column_queue_resize        (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
GtkWidget              *gtk_tree_view_column_get_tree_view       (GtkTreeViewColumn       *tree_column);
GDK_AVAILABLE_IN_ALL
GtkWidget              *gtk_tree_view_column_get_button          (GtkTreeViewColumn       *tree_column);


G_END_DECLS


#endif /* __GTK_TREE_VIEW_COLUMN_H__ */
#define headerfilename "gtk/./gtktextattributes.h"
/* file: gtk/./gtktextattributes.h */
/* gtktextattributes.h - text attributes
 *
 * Copyright (c) 1992-1994 The Regents of the University of California.
 * Copyright (c) 1994-1997 Sun Microsystems, Inc.
 * Copyright (c) 2000      Red Hat, Inc.
 * Tk -> Gtk port by Havoc Pennington <hp@redhat.com>
 *
 * This software is copyrighted by the Regents of the University of
 * California, Sun Microsystems, Inc., and other parties.  The
 * following terms apply to all files associated with the software
 * unless explicitly disclaimed in individual files.
 *
 * The authors hereby grant permission to use, copy, modify,
 * distribute, and license this software and its documentation for any
 * purpose, provided that existing copyright notices are retained in
 * all copies and that this notice is included verbatim in any
 * distributions. No written agreement, license, or royalty fee is
 * required for any of the authorized uses.  Modifications to this
 * software may be copyrighted by their authors and need not follow
 * the licensing terms described here, provided that the new terms are
 * clearly indicated on the first page of each file where they apply.
 *
 * IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION,
 * OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
 * NON-INFRINGEMENT.  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS,
 * AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE
 * MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * GOVERNMENT USE: If you are acquiring this software on behalf of the
 * U.S. government, the Government shall have only "Restricted Rights"
 * in the software and related documentation as defined in the Federal
 * Acquisition Regulations (FARs) in Clause 52.227.19 (c) (2).  If you
 * are acquiring the software on behalf of the Department of Defense,
 * the software shall be classified as "Commercial Computer Software"
 * and the Government shall have only "Restricted Rights" as defined
 * in Clause 252.227-7013 (c) (1) of DFARs.  Notwithstanding the
 * foregoing, the authors grant the U.S. Government and others acting
 * in its behalf permission to use and distribute the software in
 * accordance with the terms specified in this license.
 *
 */

#ifndef __GTK_TEXT_ATTRIBUTES_H__
#define __GTK_TEXT_ATTRIBUTES_H__




#include <gdk/gdk.h>
#include <gtk/gtkenums.h>


G_BEGIN_DECLS


#define GTK_TYPE_TEXT_ATTRIBUTES()     (gtk_text_attributes_get_type ())


/**
 * GtkTextAppearance:
 * @bg_color: Background #GdkColor.
 * @fg_color: Foreground #GdkColor.
 * @rise: Super/subscript rise, can be negative.
 * @underline: #PangoUnderline
 * @strikethrough: Strikethrough style
 * @draw_bg: Whether to use background-related values; this is
 *   irrelevant for the values struct when in a tag, but is used for
 *   the composite values struct; it’s true if any of the tags being
 *   composited had background stuff set.
 * @inside_selection: This are only used when we are actually laying
 *   out and rendering a paragraph; not when a #GtkTextAppearance is
 *   part of a #GtkTextAttributes.
 * @is_text: This are only used when we are actually laying
 *   out and rendering a paragraph; not when a #GtkTextAppearance is
 *   part of a #GtkTextAttributes.
 * @rgba: #GdkRGBA
 */
struct GtkTextAppearance
{
  /*< public >*/
  GdkColor bg_color; /* pixel is taken for underline color */
  GdkColor fg_color; /* pixel is taken for strikethrough color */

  /* super/subscript rise, can be negative */
  gint rise;

  guint underline : 4;          /* PangoUnderline */
  guint strikethrough : 1;

  /* Whether to use background-related values; this is irrelevant for
   * the values struct when in a tag, but is used for the composite
   * values struct; it's true if any of the tags being composited
   * had background stuff set.
   */
  guint draw_bg : 1;

  /* These are only used when we are actually laying out and rendering
   * a paragraph; not when a GtkTextAppearance is part of a
   * GtkTextAttributes.
   */
  guint inside_selection : 1;
  guint is_text : 1;

  /* For the sad story of this bit of code, see
   * https://bugzilla.gnome.org/show_bug.cgi?id=711158
   */
  union {
    GdkRGBA *rgba[2];
    /*< private >*/
    guint padding[4];
  };
};

/**
 * GtkTextAttributes:
 * @appearance: #GtkTextAppearance for text.
 * @justification: #GtkJustification for text.
 * @direction: #GtkTextDirection for text.
 * @font: #PangoFontDescription for text.
 * @font_scale: Font scale factor.
 * @left_margin: Width of the left margin in pixels.
 * @right_margin: Width of the right margin in pixels.
 * @indent: Amount to indent the paragraph, in pixels.
 * @pixels_above_lines: Pixels of blank space above paragraphs.
 * @pixels_below_lines: Pixels of blank space below paragraphs.
 * @pixels_inside_wrap: Pixels of blank space between wrapped lines in
 *   a paragraph.
 * @tabs: Custom #PangoTabArray for this text.
 * @wrap_mode: #GtkWrapMode for text.
 * @language: #PangoLanguage for text.
 * @invisible: Hide the text.
 * @bg_full_height: Background is fit to full line height rather than
 *    baseline +/- ascent/descent (font height).
 * @editable: Can edit this text.
 * @no_fallback: Whether to disable font fallback.
 * @letter_spacing: Extra space to insert between graphemes, in Pango units
 *
 * Using #GtkTextAttributes directly should rarely be necessary.
 * It’s primarily useful with gtk_text_iter_get_attributes().
 * As with most GTK+ structs, the fields in this struct should only
 * be read, never modified directly.
 */
struct GtkTextAttributes
{
  /*< private >*/
  guint refcount;

  /*< public >*/
  GtkTextAppearance appearance;

  GtkJustification justification;
  GtkTextDirection direction;

  PangoFontDescription *font;

  gdouble font_scale;

  gint left_margin;
  gint right_margin;
  gint indent;

  gint pixels_above_lines;
  gint pixels_below_lines;
  gint pixels_inside_wrap;

  PangoTabArray *tabs;

  GtkWrapMode wrap_mode;

  PangoLanguage *language;

  /*< private >*/
  GdkColor *pg_bg_color;

  /*< public >*/
  guint invisible : 1;
  guint bg_full_height : 1;
  guint editable : 1;
  guint no_fallback: 1;

  /*< private >*/
  GdkRGBA *pg_bg_rgba;

  /*< public >*/
  gint letter_spacing;

  union {
    char *font_features;
    guint padding[2];
  };
};
struct GtkTextChildAnchor
{
  GObject parent_instance;

  /*< private >*/
  gpointer segment;
};
struct GtkTextChildAnchorClass
{
  GObjectClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};
typedef struct GtkTextTagPrivate{} GtkTextTagPrivate;

GDK_AVAILABLE_IN_ALL
GtkTextAttributes* gtk_text_attributes_new         (void);
GDK_AVAILABLE_IN_ALL
GtkTextAttributes* gtk_text_attributes_copy        (GtkTextAttributes *src);
GDK_AVAILABLE_IN_ALL
void               gtk_text_attributes_copy_values (GtkTextAttributes *src,
                                                    GtkTextAttributes *dest);
GDK_AVAILABLE_IN_ALL
void               gtk_text_attributes_unref       (GtkTextAttributes *values);
GDK_AVAILABLE_IN_ALL
GtkTextAttributes *gtk_text_attributes_ref         (GtkTextAttributes *values);

GDK_AVAILABLE_IN_ALL
GType              gtk_text_attributes_get_type    (void) G_GNUC_CONST;


G_END_DECLS

#endif

#define headerfilename "gtk/./gtktextchild.h"
/* file: gtk/./gtktextchild.h */
/* GTK - The GIMP Toolkit
 * gtktextchild.h Copyright (C) 2000 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_TEXT_CHILD_H__
#define __GTK_TEXT_CHILD_H__



#include <gdk/gdk.h>
#include <glib-object.h>

G_BEGIN_DECLS


/**
 * GtkTextChildAnchor:
 *
 * A #GtkTextChildAnchor is a spot in the buffer where child widgets can
 * be “anchored” (inserted inline, as if they were characters). The anchor
 * can have multiple widgets anchored, to allow for multiple views.
 */

#define GTK_TYPE_TEXT_CHILD_ANCHOR()              (gtk_text_child_anchor_get_type ())
#define GTK_TEXT_CHILD_ANCHOR(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), GTK_TYPE_TEXT_CHILD_ANCHOR, GtkTextChildAnchor))
#define GTK_TEXT_CHILD_ANCHOR_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_TEXT_CHILD_ANCHOR, GtkTextChildAnchorClass))
#define GTK_IS_TEXT_CHILD_ANCHOR(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), GTK_TYPE_TEXT_CHILD_ANCHOR))
#define GTK_IS_TEXT_CHILD_ANCHOR_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_TEXT_CHILD_ANCHOR))
#define GTK_TEXT_CHILD_ANCHOR_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_TEXT_CHILD_ANCHOR, GtkTextChildAnchorClass))


struct GtkTextTag
{
  GObject parent_instance;

  GtkTextTagPrivate *priv;
};
struct GtkTextIter
{
  /* GtkTextIter is an opaque datatype; ignore all these fields.
   * Initialize the iter with gtk_text_buffer_get_iter_*
   * functions
   */
  /*< private >*/
  gpointer dummy1;
  gpointer dummy2;
  gint dummy3;
  gint dummy4;
  gint dummy5;
  gint dummy6;
  gint dummy7;
  gint dummy8;
  gpointer dummy9;
  gpointer dummy10;
  gint dummy11;
  gint dummy12;
  /* padding */
  gint dummy13;
  gpointer dummy14;
};
struct GtkTextTagClass
{
  GObjectClass parent_class;

  gboolean (* event) (GtkTextTag        *tag,
                      GObject           *event_object, /* widget, canvas item, whatever */
                      GdkEvent          *event,        /* the event itself */
                      const GtkTextIter *iter);        /* location of event in buffer */

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType               gtk_text_child_anchor_get_type    (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkTextChildAnchor* gtk_text_child_anchor_new         (void);

GDK_AVAILABLE_IN_ALL
GList*              gtk_text_child_anchor_get_widgets (GtkTextChildAnchor *anchor);
GDK_AVAILABLE_IN_ALL
gboolean            gtk_text_child_anchor_get_deleted (GtkTextChildAnchor *anchor);

G_END_DECLS

#endif
#define headerfilename "gtk/./gtktexttag.h"
/* file: gtk/./gtktexttag.h */
/* gtktexttag.c - text tag object
 *
 * Copyright (c) 1992-1994 The Regents of the University of California.
 * Copyright (c) 1994-1997 Sun Microsystems, Inc.
 * Copyright (c) 2000      Red Hat, Inc.
 * Tk -> Gtk port by Havoc Pennington <hp@redhat.com>
 *
 * This software is copyrighted by the Regents of the University of
 * California, Sun Microsystems, Inc., and other parties.  The
 * following terms apply to all files associated with the software
 * unless explicitly disclaimed in individual files.
 *
 * The authors hereby grant permission to use, copy, modify,
 * distribute, and license this software and its documentation for any
 * purpose, provided that existing copyright notices are retained in
 * all copies and that this notice is included verbatim in any
 * distributions. No written agreement, license, or royalty fee is
 * required for any of the authorized uses.  Modifications to this
 * software may be copyrighted by their authors and need not follow
 * the licensing terms described here, provided that the new terms are
 * clearly indicated on the first page of each file where they apply.
 *
 * IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION,
 * OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
 * NON-INFRINGEMENT.  THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS,
 * AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE
 * MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * GOVERNMENT USE: If you are acquiring this software on behalf of the
 * U.S. government, the Government shall have only "Restricted Rights"
 * in the software and related documentation as defined in the Federal
 * Acquisition Regulations (FARs) in Clause 52.227.19 (c) (2).  If you
 * are acquiring the software on behalf of the Department of Defense,
 * the software shall be classified as "Commercial Computer Software"
 * and the Government shall have only "Restricted Rights" as defined
 * in Clause 252.227-7013 (c) (1) of DFARs.  Notwithstanding the
 * foregoing, the authors grant the U.S. Government and others acting
 * in its behalf permission to use and distribute the software in
 * accordance with the terms specified in this license.
 *
 */

#ifndef __GTK_TEXT_TAG_H__
#define __GTK_TEXT_TAG_H__




#include <gdk/gdk.h>
#include <gtk/gtkenums.h>


G_BEGIN_DECLS


#define GTK_TYPE_TEXT_TAG()            (gtk_text_tag_get_type ())
#define GTK_TEXT_TAG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TEXT_TAG, GtkTextTag))
#define GTK_TEXT_TAG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_TEXT_TAG, GtkTextTagClass))
#define GTK_IS_TEXT_TAG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TEXT_TAG))
#define GTK_IS_TEXT_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_TEXT_TAG))
#define GTK_TEXT_TAG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_TEXT_TAG, GtkTextTagClass))




GDK_AVAILABLE_IN_ALL
GType        gtk_text_tag_get_type     (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkTextTag  *gtk_text_tag_new          (const char       *name);
GDK_AVAILABLE_IN_ALL
gint         gtk_text_tag_get_priority (GtkTextTag        *tag);
GDK_AVAILABLE_IN_ALL
void         gtk_text_tag_set_priority (GtkTextTag        *tag,
                                        gint               priority);
GDK_AVAILABLE_IN_ALL
gboolean     gtk_text_tag_event        (GtkTextTag        *tag,
                                        GObject           *event_object,
                                        GdkEvent          *event,
                                        const GtkTextIter *iter);
GDK_AVAILABLE_IN_3_20
void         gtk_text_tag_changed      (GtkTextTag        *tag,
                                        gboolean           size_changed);

G_END_DECLS

#endif

#define headerfilename "gtk/./gtktextiter.h"
/* file: gtk/./gtktextiter.h */
/* GTK - The GIMP Toolkit
 * gtktextiter.h Copyright (C) 2000 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_TEXT_ITER_H__
#define __GTK_TEXT_ITER_H__



#include <gtk/gtktextattributes.h>
#include <gtk/gtktextchild.h>
#include <gtk/gtktexttag.h>

G_BEGIN_DECLS

/**
 * GtkTextSearchFlags:
 * @GTK_TEXT_SEARCH_VISIBLE_ONLY: Search only visible data. A search match may
 * have invisible text interspersed.
 * @GTK_TEXT_SEARCH_TEXT_ONLY: Search only text. A match may have pixbufs or
 * child widgets mixed inside the matched range.
 * @GTK_TEXT_SEARCH_CASE_INSENSITIVE: The text will be matched regardless of
 * what case it is in.
 *
 * Flags affecting how a search is done.
 *
 * If neither #GTK_TEXT_SEARCH_VISIBLE_ONLY nor #GTK_TEXT_SEARCH_TEXT_ONLY are
 * enabled, the match must be exact; the special 0xFFFC character will match
 * embedded pixbufs or child widgets.
 */
typedef enum {
  GTK_TEXT_SEARCH_VISIBLE_ONLY     = 1 << 0,
  GTK_TEXT_SEARCH_TEXT_ONLY        = 1 << 1,
  GTK_TEXT_SEARCH_CASE_INSENSITIVE = 1 << 2
  /* Possible future plans: SEARCH_REGEXP */
} GtkTextSearchFlags;
typedef struct GtkTextBufferPrivate{} GtkTextBufferPrivate;

/*
 * Iter: represents a location in the text. Becomes invalid if the
 * characters/pixmaps/widgets (indexable objects) in the text buffer
 * are changed.
 */


#define GTK_TYPE_TEXT_ITER()     (gtk_text_iter_get_type ())

struct GtkTextBuffer
{
  GObject parent_instance;

  GtkTextBufferPrivate *priv;
};


/* This is primarily intended for language bindings that want to avoid
   a "buffer" argument to text insertions, deletions, etc. */
GDK_AVAILABLE_IN_ALL
GtkTextBuffer *gtk_text_iter_get_buffer (const GtkTextIter *iter);

/*
 * Life cycle
 */

GDK_AVAILABLE_IN_ALL
GtkTextIter *gtk_text_iter_copy     (const GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
void         gtk_text_iter_free     (GtkTextIter       *iter);
GDK_AVAILABLE_IN_3_2
void         gtk_text_iter_assign   (GtkTextIter       *iter,
                                     const GtkTextIter *other);

GDK_AVAILABLE_IN_ALL
GType        gtk_text_iter_get_type (void) G_GNUC_CONST;

/*
 * Convert to different kinds of index
 */

GDK_AVAILABLE_IN_ALL
gint gtk_text_iter_get_offset      (const GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gint gtk_text_iter_get_line        (const GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gint gtk_text_iter_get_line_offset (const GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gint gtk_text_iter_get_line_index  (const GtkTextIter *iter);

GDK_AVAILABLE_IN_ALL
gint gtk_text_iter_get_visible_line_offset (const GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gint gtk_text_iter_get_visible_line_index (const GtkTextIter *iter);


/*
 * “Dereference” operators
 */
GDK_AVAILABLE_IN_ALL
gunichar gtk_text_iter_get_char          (const GtkTextIter  *iter);

/* includes the 0xFFFC char for pixmaps/widgets, so char offsets
 * into the returned string map properly into buffer char offsets
 */
GDK_AVAILABLE_IN_ALL
char   *gtk_text_iter_get_slice         (const GtkTextIter  *start,
                                          const GtkTextIter  *end);

/* includes only text, no 0xFFFC */
GDK_AVAILABLE_IN_ALL
char   *gtk_text_iter_get_text          (const GtkTextIter  *start,
                                          const GtkTextIter  *end);
/* exclude invisible chars */
GDK_AVAILABLE_IN_ALL
char   *gtk_text_iter_get_visible_slice (const GtkTextIter  *start,
                                          const GtkTextIter  *end);
GDK_AVAILABLE_IN_ALL
char   *gtk_text_iter_get_visible_text  (const GtkTextIter  *start,
                                          const GtkTextIter  *end);

GDK_AVAILABLE_IN_ALL
GdkPixbuf* gtk_text_iter_get_pixbuf (const GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
GSList  *  gtk_text_iter_get_marks  (const GtkTextIter *iter);

GDK_AVAILABLE_IN_ALL
GtkTextChildAnchor* gtk_text_iter_get_child_anchor (const GtkTextIter *iter);

/* Return list of tags toggled at this point (toggled_on determines
 * whether the list is of on-toggles or off-toggles)
 */
GDK_AVAILABLE_IN_ALL
GSList  *gtk_text_iter_get_toggled_tags  (const GtkTextIter  *iter,
                                          gboolean            toggled_on);

GDK_AVAILABLE_IN_3_20
gboolean gtk_text_iter_starts_tag        (const GtkTextIter  *iter,
                                          GtkTextTag         *tag);

GDK_DEPRECATED_IN_3_20_FOR(gtk_text_iter_starts_tag)
gboolean gtk_text_iter_begins_tag        (const GtkTextIter  *iter,
                                          GtkTextTag         *tag);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_ends_tag          (const GtkTextIter  *iter,
                                          GtkTextTag         *tag);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_toggles_tag       (const GtkTextIter  *iter,
                                          GtkTextTag         *tag);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_has_tag           (const GtkTextIter   *iter,
                                          GtkTextTag          *tag);
GDK_AVAILABLE_IN_ALL
GSList  *gtk_text_iter_get_tags          (const GtkTextIter   *iter);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_editable          (const GtkTextIter   *iter,
                                          gboolean             default_setting);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_can_insert        (const GtkTextIter   *iter,
                                          gboolean             default_editability);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_starts_word        (const GtkTextIter   *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_ends_word          (const GtkTextIter   *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_inside_word        (const GtkTextIter   *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_starts_sentence    (const GtkTextIter   *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_ends_sentence      (const GtkTextIter   *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_inside_sentence    (const GtkTextIter   *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_starts_line        (const GtkTextIter   *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_ends_line          (const GtkTextIter   *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_is_cursor_position (const GtkTextIter   *iter);

GDK_AVAILABLE_IN_ALL
gint     gtk_text_iter_get_chars_in_line (const GtkTextIter   *iter);
GDK_AVAILABLE_IN_ALL
gint     gtk_text_iter_get_bytes_in_line (const GtkTextIter   *iter);

GDK_AVAILABLE_IN_ALL
gboolean       gtk_text_iter_get_attributes (const GtkTextIter *iter,
					     GtkTextAttributes *values);
GDK_AVAILABLE_IN_ALL
PangoLanguage* gtk_text_iter_get_language   (const GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_text_iter_is_end         (const GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_text_iter_is_start       (const GtkTextIter *iter);

/*
 * Moving around the buffer
 */

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_char         (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_char        (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_chars        (GtkTextIter *iter,
                                             gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_chars       (GtkTextIter *iter,
                                             gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_line         (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_line        (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_lines        (GtkTextIter *iter,
                                             gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_lines       (GtkTextIter *iter,
                                             gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_word_end     (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_word_start  (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_word_ends    (GtkTextIter *iter,
                                             gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_word_starts (GtkTextIter *iter,
                                             gint         count);
                                             
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_visible_line   (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_visible_line  (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_visible_lines  (GtkTextIter *iter,
                                               gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_visible_lines (GtkTextIter *iter,
                                               gint         count);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_visible_word_end     (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_visible_word_start  (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_visible_word_ends    (GtkTextIter *iter,
                                             gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_visible_word_starts (GtkTextIter *iter,
                                             gint         count);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_sentence_end     (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_sentence_start  (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_sentence_ends    (GtkTextIter *iter,
                                                 gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_sentence_starts (GtkTextIter *iter,
                                                 gint         count);
/* cursor positions are almost equivalent to chars, but not quite;
 * in some languages, you can’t put the cursor between certain
 * chars. Also, you can’t put the cursor between \r\n at the end
 * of a line.
 */
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_cursor_position   (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_cursor_position  (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_cursor_positions  (GtkTextIter *iter,
                                                  gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_cursor_positions (GtkTextIter *iter,
                                                  gint         count);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_visible_cursor_position   (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_visible_cursor_position  (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_visible_cursor_positions  (GtkTextIter *iter,
                                                          gint         count);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_visible_cursor_positions (GtkTextIter *iter,
                                                          gint         count);

GDK_AVAILABLE_IN_ALL
void     gtk_text_iter_set_offset         (GtkTextIter *iter,
                                           gint         char_offset);
GDK_AVAILABLE_IN_ALL
void     gtk_text_iter_set_line           (GtkTextIter *iter,
                                           gint         line_number);
GDK_AVAILABLE_IN_ALL
void     gtk_text_iter_set_line_offset    (GtkTextIter *iter,
                                           gint         char_on_line);
GDK_AVAILABLE_IN_ALL
void     gtk_text_iter_set_line_index     (GtkTextIter *iter,
                                           gint         byte_on_line);
GDK_AVAILABLE_IN_ALL
void     gtk_text_iter_forward_to_end     (GtkTextIter *iter);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_to_line_end (GtkTextIter *iter);

GDK_AVAILABLE_IN_ALL
void     gtk_text_iter_set_visible_line_offset (GtkTextIter *iter,
                                                gint         char_on_line);
GDK_AVAILABLE_IN_ALL
void     gtk_text_iter_set_visible_line_index  (GtkTextIter *iter,
                                                gint         byte_on_line);

/* returns TRUE if a toggle was found; NULL for the tag pointer
 * means “any tag toggle”, otherwise the next toggle of the
 * specified tag is located.
 */
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_to_tag_toggle (GtkTextIter *iter,
                                              GtkTextTag  *tag);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_to_tag_toggle (GtkTextIter *iter,
                                               GtkTextTag  *tag);

typedef gboolean (* GtkTextCharPredicate) (gunichar ch, gpointer user_data);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_find_char  (GtkTextIter          *iter,
                                           GtkTextCharPredicate  pred,
                                           gpointer              user_data,
                                           const GtkTextIter    *limit);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_find_char (GtkTextIter          *iter,
                                           GtkTextCharPredicate  pred,
                                           gpointer              user_data,
                                           const GtkTextIter    *limit);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_forward_search  (const GtkTextIter *iter,
                                        const char       *str,
                                        GtkTextSearchFlags flags,
                                        GtkTextIter       *match_start,
                                        GtkTextIter       *match_end,
                                        const GtkTextIter *limit);

GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_backward_search (const GtkTextIter *iter,
                                        const char       *str,
                                        GtkTextSearchFlags flags,
                                        GtkTextIter       *match_start,
                                        GtkTextIter       *match_end,
                                        const GtkTextIter *limit);

/*
 * Comparisons
 */
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_equal           (const GtkTextIter *lhs,
                                        const GtkTextIter *rhs);
GDK_AVAILABLE_IN_ALL
gint     gtk_text_iter_compare         (const GtkTextIter *lhs,
                                        const GtkTextIter *rhs);
GDK_AVAILABLE_IN_ALL
gboolean gtk_text_iter_in_range        (const GtkTextIter *iter,
                                        const GtkTextIter *start,
                                        const GtkTextIter *end);

/* Put these two in ascending order */
GDK_AVAILABLE_IN_ALL
void     gtk_text_iter_order           (GtkTextIter *first,
                                        GtkTextIter *second);

G_END_DECLS

#endif
#define headerfilename "gtk/./gtkselection.h"
/* file: gtk/./gtkselection.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_SELECTION_H__
#define __GTK_SELECTION_H__



#include <gtk/gtkwidget.h>
#include <gtk/gtktextiter.h>

G_BEGIN_DECLS


/**
 * GtkTargetPair:
 * @target: #GdkAtom representation of the target type
 * @flags: #GtkTargetFlags for DND
 * @info: an application-assigned integer ID which will
 *     get passed as a parameter to e.g the #GtkWidget::selection-get
 *     signal. It allows the application to identify the target
 *     type without extensive string compares.
 *
 * A #GtkTargetPair is used to represent the same
 * information as a table of #GtkTargetEntry, but in
 * an efficient form.
 */
struct GtkTargetPair
{
  GdkAtom   target;
  guint     flags;
  guint     info;
};

/**
 * GtkTargetList:
 *
 * A #GtkTargetList-struct is a reference counted list
 * of #GtkTargetPair and should be treated as
 * opaque.
 */
typedef struct _GtkTargetList{} GtkTargetList;

#define GTK_TYPE_SELECTION_DATA() (gtk_selection_data_get_type ())
#define GTK_TYPE_TARGET_LIST()    (gtk_target_list_get_type ())

/**
 * GtkTargetEntry:
 * @target: a string representation of the target type
 * @flags: #GtkTargetFlags for DND
 * @info: an application-assigned integer ID which will
 *     get passed as a parameter to e.g the #GtkWidget::selection-get
 *     signal. It allows the application to identify the target
 *     type without extensive string compares.
 *
 * A #GtkTargetEntry represents a single type of
 * data than can be supplied for by a widget for a selection
 * or for supplied or received during drag-and-drop.
 */
struct GtkTargetEntry
{
  char *target;
  guint  flags;
  guint  info;
};

GDK_AVAILABLE_IN_ALL
GType          gtk_target_list_get_type  (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkTargetList *gtk_target_list_new       (const GtkTargetEntry *targets,
                                          guint                 ntargets);
GDK_AVAILABLE_IN_ALL
GtkTargetList *gtk_target_list_ref       (GtkTargetList  *list);
GDK_AVAILABLE_IN_ALL
void           gtk_target_list_unref     (GtkTargetList  *list);
GDK_AVAILABLE_IN_ALL
void           gtk_target_list_add       (GtkTargetList  *list,
                                          GdkAtom         target,
                                          guint           flags,
                                          guint           info);
GDK_AVAILABLE_IN_ALL
void           gtk_target_list_add_text_targets      (GtkTargetList  *list,
                                                      guint           info);
GDK_AVAILABLE_IN_ALL
void           gtk_target_list_add_rich_text_targets (GtkTargetList  *list,
                                                      guint           info,
                                                      gboolean        deserializable,
                                                      GtkTextBuffer  *buffer);
GDK_AVAILABLE_IN_ALL
void           gtk_target_list_add_image_targets     (GtkTargetList  *list,
                                                      guint           info,
                                                      gboolean        writable);
GDK_AVAILABLE_IN_ALL
void           gtk_target_list_add_uri_targets       (GtkTargetList  *list,
                                                      guint           info);
GDK_AVAILABLE_IN_ALL
void           gtk_target_list_add_table (GtkTargetList        *list,
                                          const GtkTargetEntry *targets,
                                          guint                 ntargets);
GDK_AVAILABLE_IN_ALL
void           gtk_target_list_remove    (GtkTargetList  *list,
                                          GdkAtom         target);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_target_list_find      (GtkTargetList  *list,
                                          GdkAtom         target,
                                          guint          *info);

GDK_AVAILABLE_IN_ALL
GtkTargetEntry * gtk_target_table_new_from_list (GtkTargetList  *list,
                                                 gint           *n_targets);
GDK_AVAILABLE_IN_ALL
void             gtk_target_table_free          (GtkTargetEntry *targets,
                                                 gint            n_targets);

GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_owner_set             (GtkWidget  *widget,
                                              GdkAtom     selection,
                                              guint32     time_);
GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_owner_set_for_display (GdkDisplay *display,
                                              GtkWidget  *widget,
                                              GdkAtom     selection,
                                              guint32     time_);

GDK_AVAILABLE_IN_ALL
void     gtk_selection_add_target    (GtkWidget            *widget,
                                      GdkAtom               selection,
                                      GdkAtom               target,
                                      guint                 info);
GDK_AVAILABLE_IN_ALL
void     gtk_selection_add_targets   (GtkWidget            *widget,
                                      GdkAtom               selection,
                                      const GtkTargetEntry *targets,
                                      guint                 ntargets);
GDK_AVAILABLE_IN_ALL
void     gtk_selection_clear_targets (GtkWidget            *widget,
                                      GdkAtom               selection);
GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_convert       (GtkWidget            *widget,
                                      GdkAtom               selection,
                                      GdkAtom               target,
                                      guint32               time_);
GDK_AVAILABLE_IN_ALL
void     gtk_selection_remove_all    (GtkWidget             *widget);

GDK_AVAILABLE_IN_ALL
GdkAtom       gtk_selection_data_get_selection (const GtkSelectionData *selection_data);
GDK_AVAILABLE_IN_ALL
GdkAtom       gtk_selection_data_get_target    (const GtkSelectionData *selection_data);
GDK_AVAILABLE_IN_ALL
GdkAtom       gtk_selection_data_get_data_type (const GtkSelectionData *selection_data);
GDK_AVAILABLE_IN_ALL
gint          gtk_selection_data_get_format    (const GtkSelectionData *selection_data);
GDK_AVAILABLE_IN_ALL
const guchar *gtk_selection_data_get_data      (const GtkSelectionData *selection_data);
GDK_AVAILABLE_IN_ALL
gint          gtk_selection_data_get_length    (const GtkSelectionData *selection_data);
GDK_AVAILABLE_IN_ALL
const guchar *gtk_selection_data_get_data_with_length
                                               (const GtkSelectionData *selection_data,
                                                gint                   *length);

GDK_AVAILABLE_IN_ALL
GdkDisplay   *gtk_selection_data_get_display   (const GtkSelectionData *selection_data);

GDK_AVAILABLE_IN_ALL
void     gtk_selection_data_set      (GtkSelectionData     *selection_data,
                                      GdkAtom               type,
                                      gint                  format,
                                      const guchar         *data,
                                      gint                  length);
GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_data_set_text (GtkSelectionData     *selection_data,
                                      const char          *str,
                                      gint                  len);
GDK_AVAILABLE_IN_ALL
guchar * gtk_selection_data_get_text (const GtkSelectionData     *selection_data);
GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_data_set_pixbuf   (GtkSelectionData  *selection_data,
                                          GdkPixbuf         *pixbuf);
GDK_AVAILABLE_IN_ALL
GdkPixbuf *gtk_selection_data_get_pixbuf (const GtkSelectionData  *selection_data);
GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_data_set_uris (GtkSelectionData     *selection_data,
                                      char               **uris);
GDK_AVAILABLE_IN_ALL
char  **gtk_selection_data_get_uris (const GtkSelectionData     *selection_data);

GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_data_get_targets          (const GtkSelectionData  *selection_data,
                                                  GdkAtom          **targets,
                                                  gint              *n_atoms);
GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_data_targets_include_text (const GtkSelectionData  *selection_data);
GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_data_targets_include_rich_text (const GtkSelectionData *selection_data,
                                                       GtkTextBuffer    *buffer);
GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_data_targets_include_image (const GtkSelectionData  *selection_data,
                                                   gboolean           writable);
GDK_AVAILABLE_IN_ALL
gboolean gtk_selection_data_targets_include_uri  (const GtkSelectionData  *selection_data);
GDK_AVAILABLE_IN_ALL
gboolean gtk_targets_include_text                (GdkAtom       *targets,
                                                  gint           n_targets);
GDK_AVAILABLE_IN_ALL
gboolean gtk_targets_include_rich_text           (GdkAtom       *targets,
                                                  gint           n_targets,
                                                  GtkTextBuffer *buffer);
GDK_AVAILABLE_IN_ALL
gboolean gtk_targets_include_image               (GdkAtom       *targets,
                                                  gint           n_targets,
                                                  gboolean       writable);
GDK_AVAILABLE_IN_ALL
gboolean gtk_targets_include_uri                 (GdkAtom       *targets,
                                                  gint           n_targets);


GDK_AVAILABLE_IN_ALL
GType             gtk_selection_data_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkSelectionData *gtk_selection_data_copy     (const GtkSelectionData *data);
GDK_AVAILABLE_IN_ALL
void              gtk_selection_data_free     (GtkSelectionData *data);

GDK_AVAILABLE_IN_ALL
GType             gtk_target_entry_get_type    (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkTargetEntry   *gtk_target_entry_new        (const char    *target,
                                               guint           flags,
                                               guint           info);
GDK_AVAILABLE_IN_ALL
GtkTargetEntry   *gtk_target_entry_copy       (GtkTargetEntry *data);
GDK_AVAILABLE_IN_ALL
void              gtk_target_entry_free       (GtkTargetEntry *data);

G_END_DECLS

#endif /* __GTK_SELECTION_H__ */
#define headerfilename "gtk/./gtkdnd.h"
/* file: gtk/./gtkdnd.h */
/* -*- Mode: C; c-file-style: "gnu"; tab-width: 8 -*- */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_DND_H__
#define __GTK_DND_H__




#include <gtk/gtkwidget.h>
#include <gtk/gtkselection.h>


G_BEGIN_DECLS

/**
 * GtkDestDefaults:
 * @GTK_DEST_DEFAULT_MOTION: If set for a widget, GTK+, during a drag over this
 *   widget will check if the drag matches this widget’s list of possible targets
 *   and actions.
 *   GTK+ will then call gdk_drag_status() as appropriate.
 * @GTK_DEST_DEFAULT_HIGHLIGHT: If set for a widget, GTK+ will draw a highlight on
 *   this widget as long as a drag is over this widget and the widget drag format
 *   and action are acceptable.
 * @GTK_DEST_DEFAULT_DROP: If set for a widget, when a drop occurs, GTK+ will
 *   will check if the drag matches this widget’s list of possible targets and
 *   actions. If so, GTK+ will call gtk_drag_get_data() on behalf of the widget.
 *   Whether or not the drop is successful, GTK+ will call gtk_drag_finish(). If
 *   the action was a move, then if the drag was successful, then %TRUE will be
 *   passed for the @delete parameter to gtk_drag_finish().
 * @GTK_DEST_DEFAULT_ALL: If set, specifies that all default actions should
 *   be taken.
 *
 * The #GtkDestDefaults enumeration specifies the various
 * types of action that will be taken on behalf
 * of the user for a drag destination site.
 */
typedef enum {
  GTK_DEST_DEFAULT_MOTION     = 1 << 0,
  GTK_DEST_DEFAULT_HIGHLIGHT  = 1 << 1,
  GTK_DEST_DEFAULT_DROP       = 1 << 2,
  GTK_DEST_DEFAULT_ALL        = 0x07
} GtkDestDefaults;

/**
 * GtkTargetFlags:
 * @GTK_TARGET_SAME_APP: If this is set, the target will only be selected
 *   for drags within a single application.
 * @GTK_TARGET_SAME_WIDGET: If this is set, the target will only be selected
 *   for drags within a single widget.
 * @GTK_TARGET_OTHER_APP: If this is set, the target will not be selected
 *   for drags within a single application.
 * @GTK_TARGET_OTHER_WIDGET: If this is set, the target will not be selected
 *   for drags withing a single widget.
 *
 * The #GtkTargetFlags enumeration is used to specify
 * constraints on a #GtkTargetEntry.
 */
typedef enum {
  GTK_TARGET_SAME_APP = 1 << 0,    /*< nick=same-app >*/
  GTK_TARGET_SAME_WIDGET = 1 << 1, /*< nick=same-widget >*/
  GTK_TARGET_OTHER_APP = 1 << 2,   /*< nick=other-app >*/
  GTK_TARGET_OTHER_WIDGET = 1 << 3 /*< nick=other-widget >*/
} GtkTargetFlags;
typedef struct _GtkEditable{} GtkEditable;         /* Dummy typedef */
struct GtkEditableInterface
{
  GTypeInterface		   base_iface;

  /* signals */
  void (* insert_text)              (GtkEditable    *editable,
				     const char    *new_text,
				     gint            new_text_length,
				     gint           *position);
  void (* delete_text)              (GtkEditable    *editable,
				     gint            start_pos,
				     gint            end_pos);
  void (* changed)                  (GtkEditable    *editable);

  /* vtable */
  void (* do_insert_text)           (GtkEditable    *editable,
				     const char    *new_text,
				     gint            new_text_length,
				     gint           *position);
  void (* do_delete_text)           (GtkEditable    *editable,
				     gint            start_pos,
				     gint            end_pos);

  char* (* get_chars)              (GtkEditable    *editable,
				     gint            start_pos,
				     gint            end_pos);
  void (* set_selection_bounds)     (GtkEditable    *editable,
				     gint            start_pos,
				     gint            end_pos);
  gboolean (* get_selection_bounds) (GtkEditable    *editable,
				     gint           *start_pos,
				     gint           *end_pos);
  void (* set_position)             (GtkEditable    *editable,
				     gint            position);
  gint (* get_position)             (GtkEditable    *editable);
};

/* Destination side */

GDK_AVAILABLE_IN_ALL
void gtk_drag_get_data (GtkWidget      *widget,
			GdkDragContext *context,
			GdkAtom         target,
			guint32         time_);
GDK_AVAILABLE_IN_ALL
void gtk_drag_finish   (GdkDragContext *context,
			gboolean        success,
			gboolean        del,
			guint32         time_);

GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_drag_get_source_widget (GdkDragContext *context);

GDK_AVAILABLE_IN_ALL
void gtk_drag_highlight   (GtkWidget  *widget);
GDK_AVAILABLE_IN_ALL
void gtk_drag_unhighlight (GtkWidget  *widget);

GDK_AVAILABLE_IN_ALL
void gtk_drag_dest_set   (GtkWidget            *widget,
			  GtkDestDefaults       flags,
  		          const GtkTargetEntry *targets,
			  gint                  n_targets,
			  GdkDragAction         actions);

GDK_AVAILABLE_IN_ALL
void gtk_drag_dest_set_proxy (GtkWidget      *widget,
			      GdkWindow      *proxy_window,
			      GdkDragProtocol protocol,
			      gboolean        use_coordinates);

GDK_AVAILABLE_IN_ALL
void gtk_drag_dest_unset (GtkWidget          *widget);

GDK_AVAILABLE_IN_ALL
GdkAtom        gtk_drag_dest_find_target     (GtkWidget      *widget,
                                              GdkDragContext *context,
                                              GtkTargetList  *target_list);
GDK_AVAILABLE_IN_ALL
GtkTargetList* gtk_drag_dest_get_target_list (GtkWidget      *widget);
GDK_AVAILABLE_IN_ALL
void           gtk_drag_dest_set_target_list (GtkWidget      *widget,
                                              GtkTargetList  *target_list);
GDK_AVAILABLE_IN_ALL
void           gtk_drag_dest_add_text_targets  (GtkWidget    *widget);
GDK_AVAILABLE_IN_ALL
void           gtk_drag_dest_add_image_targets (GtkWidget    *widget);
GDK_AVAILABLE_IN_ALL
void           gtk_drag_dest_add_uri_targets   (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void           gtk_drag_dest_set_track_motion  (GtkWidget *widget,
						gboolean   track_motion);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_drag_dest_get_track_motion  (GtkWidget *widget);

/* Source side */

GDK_AVAILABLE_IN_3_10
GdkDragContext *gtk_drag_begin_with_coordinates (GtkWidget         *widget,
                                                 GtkTargetList     *targets,
                                                 GdkDragAction      actions,
                                                 gint               button,
                                                 GdkEvent          *event,
                                                 gint               x,
                                                 gint               y);

GDK_DEPRECATED_IN_3_10_FOR(gtk_drag_begin_with_coordinates)
GdkDragContext *gtk_drag_begin (GtkWidget         *widget,
				GtkTargetList     *targets,
				GdkDragAction      actions,
				gint               button,
				GdkEvent          *event);

GDK_AVAILABLE_IN_3_16
void gtk_drag_cancel           (GdkDragContext *context);

GDK_AVAILABLE_IN_ALL
void gtk_drag_set_icon_widget (GdkDragContext *context,
			       GtkWidget      *widget,
			       gint            hot_x,
			       gint            hot_y);
GDK_AVAILABLE_IN_ALL
void gtk_drag_set_icon_pixbuf (GdkDragContext *context,
			       GdkPixbuf      *pixbuf,
			       gint            hot_x,
			       gint            hot_y);
GDK_DEPRECATED_IN_3_10_FOR(gtk_drag_set_icon_name)
void gtk_drag_set_icon_stock  (GdkDragContext *context,
			       const char    *stock_id,
			       gint            hot_x,
			       gint            hot_y);
GDK_AVAILABLE_IN_ALL
void gtk_drag_set_icon_surface(GdkDragContext *context,
			       cairo_surface_t *surface);
GDK_AVAILABLE_IN_ALL
void gtk_drag_set_icon_name   (GdkDragContext *context,
			       const char    *icon_name,
			       gint            hot_x,
			       gint            hot_y);
GDK_AVAILABLE_IN_3_2
void gtk_drag_set_icon_gicon  (GdkDragContext *context,
			       GIcon          *icon,
			       gint            hot_x,
			       gint            hot_y);

GDK_AVAILABLE_IN_ALL
void gtk_drag_set_icon_default (GdkDragContext    *context);

GDK_AVAILABLE_IN_ALL
gboolean gtk_drag_check_threshold (GtkWidget *widget,
				   gint       start_x,
				   gint       start_y,
				   gint       current_x,
				   gint       current_y);


G_END_DECLS

#endif /* __GTK_DND_H__ */
#define headerfilename "gtk/./gtkeditable.h"
/* file: gtk/./gtkeditable.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_EDITABLE_H__
#define __GTK_EDITABLE_H__




#include <gtk/gtkwidget.h>


G_BEGIN_DECLS

#define GTK_TYPE_EDITABLE()             (gtk_editable_get_type ())
#define GTK_EDITABLE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_EDITABLE, GtkEditable))
#define GTK_IS_EDITABLE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_EDITABLE))
#define GTK_EDITABLE_GET_IFACE(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), GTK_TYPE_EDITABLE, GtkEditableInterface))


struct GtkIMContext
{
  GObject parent_instance;
};
struct GtkIMContextClass
{
  /*< private >*/
  GObjectClass parent_class;

  /*< public >*/
  /* Signals */
  void     (*preedit_start)        (GtkIMContext *context);
  void     (*preedit_end)          (GtkIMContext *context);
  void     (*preedit_changed)      (GtkIMContext *context);
  void     (*commit)               (GtkIMContext *context, const char *str);
  gboolean (*retrieve_surrounding) (GtkIMContext *context);
  gboolean (*delete_surrounding)   (GtkIMContext *context,
				    gint          offset,
				    gint          n_chars);

  /* Virtual functions */
  void     (*set_client_window)   (GtkIMContext   *context,
				   GdkWindow      *window);
  void     (*get_preedit_string)  (GtkIMContext   *context,
				   char         **str,
				   PangoAttrList **attrs,
				   gint           *cursor_pos);
  gboolean (*filter_keypress)     (GtkIMContext   *context,
			           GdkEventKey    *event);
  void     (*focus_in)            (GtkIMContext   *context);
  void     (*focus_out)           (GtkIMContext   *context);
  void     (*reset)               (GtkIMContext   *context);
  void     (*set_cursor_location) (GtkIMContext   *context,
				   GdkRectangle   *area);
  void     (*set_use_preedit)     (GtkIMContext   *context,
				   gboolean        use_preedit);
  void     (*set_surrounding)     (GtkIMContext   *context,
				   const char    *text,
				   gint            len,
				   gint            cursor_index);
  gboolean (*get_surrounding)     (GtkIMContext   *context,
				   char         **text,
				   gint           *cursor_index);
  /*< private >*/
  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
};
typedef struct GtkEntryBufferPrivate{} GtkEntryBufferPrivate;

GDK_AVAILABLE_IN_ALL
GType    gtk_editable_get_type             (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
void     gtk_editable_select_region        (GtkEditable *editable,
					    gint         start_pos,
					    gint         end_pos);
GDK_AVAILABLE_IN_ALL
gboolean gtk_editable_get_selection_bounds (GtkEditable *editable,
					    gint        *start_pos,
					    gint        *end_pos);
GDK_AVAILABLE_IN_ALL
void     gtk_editable_insert_text          (GtkEditable *editable,
					    const char *new_text,
					    gint         new_text_length,
					    gint        *position);
GDK_AVAILABLE_IN_ALL
void     gtk_editable_delete_text          (GtkEditable *editable,
					    gint         start_pos,
					    gint         end_pos);
GDK_AVAILABLE_IN_ALL
char*   gtk_editable_get_chars            (GtkEditable *editable,
					    gint         start_pos,
					    gint         end_pos);
GDK_AVAILABLE_IN_ALL
void     gtk_editable_cut_clipboard        (GtkEditable *editable);
GDK_AVAILABLE_IN_ALL
void     gtk_editable_copy_clipboard       (GtkEditable *editable);
GDK_AVAILABLE_IN_ALL
void     gtk_editable_paste_clipboard      (GtkEditable *editable);
GDK_AVAILABLE_IN_ALL
void     gtk_editable_delete_selection     (GtkEditable *editable);
GDK_AVAILABLE_IN_ALL
void     gtk_editable_set_position         (GtkEditable *editable,
					    gint         position);
GDK_AVAILABLE_IN_ALL
gint     gtk_editable_get_position         (GtkEditable *editable);
GDK_AVAILABLE_IN_ALL
void     gtk_editable_set_editable         (GtkEditable *editable,
					    gboolean     is_editable);
GDK_AVAILABLE_IN_ALL
gboolean gtk_editable_get_editable         (GtkEditable *editable);

G_END_DECLS

#endif /* __GTK_EDITABLE_H__ */
#define headerfilename "gtk/./gtkimcontext.h"
/* file: gtk/./gtkimcontext.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat Software
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_IM_CONTEXT_H__
#define __GTK_IM_CONTEXT_H__




#include <gdk/gdk.h>


G_BEGIN_DECLS

#define GTK_TYPE_IM_CONTEXT()              (gtk_im_context_get_type ())
#define GTK_IM_CONTEXT(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_IM_CONTEXT, GtkIMContext))
#define GTK_IM_CONTEXT_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_IM_CONTEXT, GtkIMContextClass))
#define GTK_IS_IM_CONTEXT(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_IM_CONTEXT))
#define GTK_IS_IM_CONTEXT_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IM_CONTEXT))
#define GTK_IM_CONTEXT_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_IM_CONTEXT, GtkIMContextClass))




struct GtkEntryBuffer
{
  GObject parent_instance;

  /*< private >*/
  GtkEntryBufferPrivate *priv;
};
struct GtkEntryBufferClass
{
  GObjectClass parent_class;

  /* Signals */

  void         (*inserted_text)          (GtkEntryBuffer *buffer,
                                          guint           position,
                                          const char    *chars,
                                          guint           n_chars);

  void         (*deleted_text)           (GtkEntryBuffer *buffer,
                                          guint           position,
                                          guint           n_chars);

  /* Virtual Methods */

  const char* (*get_text)               (GtkEntryBuffer *buffer,
                                          gsize          *n_bytes);

  guint        (*get_length)             (GtkEntryBuffer *buffer);

  guint        (*insert_text)            (GtkEntryBuffer *buffer,
                                          guint           position,
                                          const char    *chars,
                                          guint           n_chars);

  guint        (*delete_text)            (GtkEntryBuffer *buffer,
                                          guint           position,
                                          guint           n_chars);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};

GDK_AVAILABLE_IN_ALL
GType    gtk_im_context_get_type            (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
void     gtk_im_context_set_client_window   (GtkIMContext       *context,
					     GdkWindow          *window);
GDK_AVAILABLE_IN_ALL
void     gtk_im_context_get_preedit_string  (GtkIMContext       *context,
					     char             **str,
					     PangoAttrList     **attrs,
					     gint               *cursor_pos);
GDK_AVAILABLE_IN_ALL
gboolean gtk_im_context_filter_keypress     (GtkIMContext       *context,
					     GdkEventKey        *event);
GDK_AVAILABLE_IN_ALL
void     gtk_im_context_focus_in            (GtkIMContext       *context);
GDK_AVAILABLE_IN_ALL
void     gtk_im_context_focus_out           (GtkIMContext       *context);
GDK_AVAILABLE_IN_ALL
void     gtk_im_context_reset               (GtkIMContext       *context);
GDK_AVAILABLE_IN_ALL
void     gtk_im_context_set_cursor_location (GtkIMContext       *context,
					     const GdkRectangle *area);
GDK_AVAILABLE_IN_ALL
void     gtk_im_context_set_use_preedit     (GtkIMContext       *context,
					     gboolean            use_preedit);
GDK_AVAILABLE_IN_ALL
void     gtk_im_context_set_surrounding     (GtkIMContext       *context,
					     const char        *text,
					     gint                len,
					     gint                cursor_index);
GDK_AVAILABLE_IN_ALL
gboolean gtk_im_context_get_surrounding     (GtkIMContext       *context,
					     char             **text,
					     gint               *cursor_index);
GDK_AVAILABLE_IN_ALL
gboolean gtk_im_context_delete_surrounding  (GtkIMContext       *context,
					     gint                offset,
					     gint                n_chars);

G_END_DECLS

#endif /* __GTK_IM_CONTEXT_H__ */
#define headerfilename "gtk/./gtkentrybuffer.h"
/* file: gtk/./gtkentrybuffer.h */
/* gtkentrybuffer.h
 * Copyright (C) 2009  Stefan Walter <stef@memberwebs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_ENTRY_BUFFER_H__
#define __GTK_ENTRY_BUFFER_H__



#include <glib-object.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

/* Maximum size of text buffer, in bytes */
#define GTK_ENTRY_BUFFER_MAX_SIZE        G_MAXUSHORT

#define GTK_TYPE_ENTRY_BUFFER()            (gtk_entry_buffer_get_type ())
#define GTK_ENTRY_BUFFER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ENTRY_BUFFER, GtkEntryBuffer))
#define GTK_ENTRY_BUFFER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ENTRY_BUFFER, GtkEntryBufferClass))
#define GTK_IS_ENTRY_BUFFER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ENTRY_BUFFER))
#define GTK_IS_ENTRY_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ENTRY_BUFFER))
#define GTK_ENTRY_BUFFER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ENTRY_BUFFER, GtkEntryBufferClass))

typedef struct GtkListStorePrivate{} GtkListStorePrivate;


struct GtkListStore
{
  GObject parent;

  /*< private >*/
  GtkListStorePrivate *priv;
};
struct GtkListStoreClass
{
  GObjectClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType                     gtk_entry_buffer_get_type               (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkEntryBuffer*           gtk_entry_buffer_new                    (const char     *initial_chars,
                                                                   gint             n_initial_chars);

GDK_AVAILABLE_IN_ALL
gsize                     gtk_entry_buffer_get_bytes              (GtkEntryBuffer  *buffer);

GDK_AVAILABLE_IN_ALL
guint                     gtk_entry_buffer_get_length             (GtkEntryBuffer  *buffer);

GDK_AVAILABLE_IN_ALL
const char*              gtk_entry_buffer_get_text               (GtkEntryBuffer  *buffer);

GDK_AVAILABLE_IN_ALL
void                      gtk_entry_buffer_set_text               (GtkEntryBuffer  *buffer,
                                                                   const char     *chars,
                                                                   gint             n_chars);

GDK_AVAILABLE_IN_ALL
void                      gtk_entry_buffer_set_max_length         (GtkEntryBuffer  *buffer,
                                                                   gint             max_length);

GDK_AVAILABLE_IN_ALL
gint                      gtk_entry_buffer_get_max_length         (GtkEntryBuffer  *buffer);

GDK_AVAILABLE_IN_ALL
guint                     gtk_entry_buffer_insert_text            (GtkEntryBuffer  *buffer,
                                                                   guint            position,
                                                                   const char     *chars,
                                                                   gint             n_chars);

GDK_AVAILABLE_IN_ALL
guint                     gtk_entry_buffer_delete_text            (GtkEntryBuffer  *buffer,
                                                                   guint            position,
                                                                   gint             n_chars);

GDK_AVAILABLE_IN_ALL
void                      gtk_entry_buffer_emit_inserted_text     (GtkEntryBuffer  *buffer,
                                                                   guint            position,
                                                                   const char     *chars,
                                                                   guint            n_chars);

GDK_AVAILABLE_IN_ALL
void                      gtk_entry_buffer_emit_deleted_text      (GtkEntryBuffer  *buffer,
                                                                   guint            position,
                                                                   guint            n_chars);

G_END_DECLS

#endif /* __GTK_ENTRY_BUFFER_H__ */
#define headerfilename "gtk/./gtkliststore.h"
/* file: gtk/./gtkliststore.h */
/* gtkliststore.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_LIST_STORE_H__
#define __GTK_LIST_STORE_H__



#include <gdk/gdk.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtktreesortable.h>


G_BEGIN_DECLS


#define GTK_TYPE_LIST_STORE()	       (gtk_list_store_get_type ())
#define GTK_LIST_STORE(obj)	       (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_LIST_STORE, GtkListStore))
#define GTK_LIST_STORE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_LIST_STORE, GtkListStoreClass))
#define GTK_IS_LIST_STORE(obj)	       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_LIST_STORE))
#define GTK_IS_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_LIST_STORE))
#define GTK_LIST_STORE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_LIST_STORE, GtkListStoreClass))

typedef struct GtkTreeModelFilterPrivate{} GtkTreeModelFilterPrivate;


struct GtkTreeModelFilter
{
  GObject parent;

  /*< private >*/
  GtkTreeModelFilterPrivate *priv;
};
struct GtkTreeModelFilterClass
{
  GObjectClass parent_class;

  gboolean (* visible) (GtkTreeModelFilter *self,
                        GtkTreeModel       *child_model,
                        GtkTreeIter        *iter);
  void (* modify) (GtkTreeModelFilter *self,
                   GtkTreeModel       *child_model,
                   GtkTreeIter        *iter,
                   GValue             *value,
                   gint                column);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType         gtk_list_store_get_type         (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkListStore *gtk_list_store_new              (gint          n_columns,
					       ...);
GDK_AVAILABLE_IN_ALL
GtkListStore *gtk_list_store_newv             (gint          n_columns,
					       GType        *types);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_set_column_types (GtkListStore *list_store,
					       gint          n_columns,
					       GType        *types);

/* NOTE: use gtk_tree_model_get to get values from a GtkListStore */

GDK_AVAILABLE_IN_ALL
void          gtk_list_store_set_value        (GtkListStore *list_store,
					       GtkTreeIter  *iter,
					       gint          column,
					       GValue       *value);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_set              (GtkListStore *list_store,
					       GtkTreeIter  *iter,
					       ...);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_set_valuesv      (GtkListStore *list_store,
					       GtkTreeIter  *iter,
					       gint         *columns,
					       GValue       *values,
					       gint          n_values);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_set_valist       (GtkListStore *list_store,
					       GtkTreeIter  *iter,
					       va_list       var_args);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_list_store_remove           (GtkListStore *list_store,
					       GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_insert           (GtkListStore *list_store,
					       GtkTreeIter  *iter,
					       gint          position);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_insert_before    (GtkListStore *list_store,
					       GtkTreeIter  *iter,
					       GtkTreeIter  *sibling);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_insert_after     (GtkListStore *list_store,
					       GtkTreeIter  *iter,
					       GtkTreeIter  *sibling);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_insert_with_values  (GtkListStore *list_store,
						  GtkTreeIter  *iter,
						  gint          position,
						  ...);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_insert_with_valuesv (GtkListStore *list_store,
						  GtkTreeIter  *iter,
						  gint          position,
						  gint         *columns,
						  GValue       *values,
						  gint          n_values);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_prepend          (GtkListStore *list_store,
					       GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_append           (GtkListStore *list_store,
					       GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_clear            (GtkListStore *list_store);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_list_store_iter_is_valid    (GtkListStore *list_store,
                                               GtkTreeIter  *iter);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_reorder          (GtkListStore *store,
                                               gint         *new_order);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_swap             (GtkListStore *store,
                                               GtkTreeIter  *a,
                                               GtkTreeIter  *b);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_move_after       (GtkListStore *store,
                                               GtkTreeIter  *iter,
                                               GtkTreeIter  *position);
GDK_AVAILABLE_IN_ALL
void          gtk_list_store_move_before      (GtkListStore *store,
                                               GtkTreeIter  *iter,
                                               GtkTreeIter  *position);


G_END_DECLS


#endif /* __GTK_LIST_STORE_H__ */
#define headerfilename "gtk/./gtktreemodelfilter.h"
/* file: gtk/./gtktreemodelfilter.h */
/* gtktreemodelfilter.h
 * Copyright (C) 2000,2001  Red Hat, Inc., Jonathan Blandford <jrb@redhat.com>
 * Copyright (C) 2001-2003  Kristian Rietveld <kris@gtk.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_TREE_MODEL_FILTER_H__
#define __GTK_TREE_MODEL_FILTER_H__



#include <gtk/gtktreemodel.h>

G_BEGIN_DECLS

#define GTK_TYPE_TREE_MODEL_FILTER()              (gtk_tree_model_filter_get_type ())
#define GTK_TREE_MODEL_FILTER(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TREE_MODEL_FILTER, GtkTreeModelFilter))
#define GTK_TREE_MODEL_FILTER_CLASS(vtable)     (G_TYPE_CHECK_CLASS_CAST ((vtable), GTK_TYPE_TREE_MODEL_FILTER, GtkTreeModelFilterClass))
#define GTK_IS_TREE_MODEL_FILTER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TREE_MODEL_FILTER))
#define GTK_IS_TREE_MODEL_FILTER_CLASS(vtable)  (G_TYPE_CHECK_CLASS_TYPE ((vtable), GTK_TYPE_TREE_MODEL_FILTER))
#define GTK_TREE_MODEL_FILTER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_TREE_MODEL_FILTER, GtkTreeModelFilterClass))

/**
 * GtkTreeModelFilterVisibleFunc:
 * @model: the child model of the #GtkTreeModelFilter
 * @iter: a #GtkTreeIter pointing to the row in @model whose visibility
 *   is determined
 * @data: (closure): user data given to gtk_tree_model_filter_set_visible_func()
 *
 * A function which decides whether the row indicated by @iter is visible.
 *
 * Returns: Whether the row indicated by @iter is visible.
 */
typedef gboolean (* GtkTreeModelFilterVisibleFunc) (GtkTreeModel *model,
                                                    GtkTreeIter  *iter,
                                                    gpointer      data);

/**
 * GtkTreeModelFilterModifyFunc:
 * @model: the #GtkTreeModelFilter
 * @iter: a #GtkTreeIter pointing to the row whose display values are determined
 * @value: (out caller-allocates): A #GValue which is already initialized for
 *  with the correct type for the column @column.
 * @column: the column whose display value is determined
 * @data: (closure): user data given to gtk_tree_model_filter_set_modify_func()
 *
 * A function which calculates display values from raw values in the model.
 * It must fill @value with the display value for the column @column in the
 * row indicated by @iter.
 *
 * Since this function is called for each data access, it’s not a
 * particularly efficient operation.
 */

typedef void (* GtkTreeModelFilterModifyFunc) (GtkTreeModel *model,
                                               GtkTreeIter  *iter,
                                               GValue       *value,
                                               gint          column,
                                               gpointer      data);

typedef struct GtkEntryCompletionPrivate{} GtkEntryCompletionPrivate;


struct GtkEntryCompletion
{
  GObject parent_instance;

  /*< private >*/
  GtkEntryCompletionPrivate *priv;
};
struct GtkEntryCompletionClass
{
  GObjectClass parent_class;

  gboolean (* match_selected)   (GtkEntryCompletion *completion,
                                 GtkTreeModel       *model,
                                 GtkTreeIter        *iter);
  void     (* action_activated) (GtkEntryCompletion *completion,
                                 gint                index_);
  gboolean (* insert_prefix)    (GtkEntryCompletion *completion,
                                 const char        *prefix);
  gboolean (* cursor_on_match)  (GtkEntryCompletion *completion,
                                 GtkTreeModel       *model,
                                 GtkTreeIter        *iter);
  void     (* no_matches)       (GtkEntryCompletion *completion);

  /* Padding for future expansion */
  void (*_gtk_reserved0) (void);
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
};

/* base */
GDK_AVAILABLE_IN_ALL
GType         gtk_tree_model_filter_get_type                   (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkTreeModel *gtk_tree_model_filter_new                        (GtkTreeModel                 *child_model,
                                                                GtkTreePath                  *root);
GDK_AVAILABLE_IN_ALL
void          gtk_tree_model_filter_set_visible_func           (GtkTreeModelFilter           *filter,
                                                                GtkTreeModelFilterVisibleFunc func,
                                                                gpointer                      data,
                                                                GDestroyNotify                destroy);
GDK_AVAILABLE_IN_ALL
void          gtk_tree_model_filter_set_modify_func            (GtkTreeModelFilter           *filter,
                                                                gint                          n_columns,
                                                                GType                        *types,
                                                                GtkTreeModelFilterModifyFunc  func,
                                                                gpointer                      data,
                                                                GDestroyNotify                destroy);
GDK_AVAILABLE_IN_ALL
void          gtk_tree_model_filter_set_visible_column         (GtkTreeModelFilter           *filter,
                                                                gint                          column);

GDK_AVAILABLE_IN_ALL
GtkTreeModel *gtk_tree_model_filter_get_model                  (GtkTreeModelFilter           *filter);

/* conversion */
GDK_AVAILABLE_IN_ALL
gboolean      gtk_tree_model_filter_convert_child_iter_to_iter (GtkTreeModelFilter           *filter,
                                                                GtkTreeIter                  *filter_iter,
                                                                GtkTreeIter                  *child_iter);
GDK_AVAILABLE_IN_ALL
void          gtk_tree_model_filter_convert_iter_to_child_iter (GtkTreeModelFilter           *filter,
                                                                GtkTreeIter                  *child_iter,
                                                                GtkTreeIter                  *filter_iter);
GDK_AVAILABLE_IN_ALL
GtkTreePath  *gtk_tree_model_filter_convert_child_path_to_path (GtkTreeModelFilter           *filter,
                                                                GtkTreePath                  *child_path);
GDK_AVAILABLE_IN_ALL
GtkTreePath  *gtk_tree_model_filter_convert_path_to_child_path (GtkTreeModelFilter           *filter,
                                                                GtkTreePath                  *filter_path);

/* extras */
GDK_AVAILABLE_IN_ALL
void          gtk_tree_model_filter_refilter                   (GtkTreeModelFilter           *filter);
GDK_AVAILABLE_IN_ALL
void          gtk_tree_model_filter_clear_cache                (GtkTreeModelFilter           *filter);

G_END_DECLS

#endif /* __GTK_TREE_MODEL_FILTER_H__ */
#define headerfilename "gtk/./gtkentrycompletion.h"
/* file: gtk/./gtkentrycompletion.h */
/* gtkentrycompletion.h
 * Copyright (C) 2003  Kristian Rietveld  <kris@gtk.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_ENTRY_COMPLETION_H__
#define __GTK_ENTRY_COMPLETION_H__



#include <gdk/gdk.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtkliststore.h>
#include <gtk/gtkcellarea.h>
#include <gtk/gtktreeviewcolumn.h>
#include <gtk/gtktreemodelfilter.h>

G_BEGIN_DECLS

#define GTK_TYPE_ENTRY_COMPLETION()            (gtk_entry_completion_get_type ())
#define GTK_ENTRY_COMPLETION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ENTRY_COMPLETION, GtkEntryCompletion))
#define GTK_ENTRY_COMPLETION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ENTRY_COMPLETION, GtkEntryCompletionClass))
#define GTK_IS_ENTRY_COMPLETION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ENTRY_COMPLETION))
#define GTK_IS_ENTRY_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ENTRY_COMPLETION))
#define GTK_ENTRY_COMPLETION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ENTRY_COMPLETION, GtkEntryCompletionClass))

typedef struct GtkImagePrivate{} GtkImagePrivate;

/**
 * GtkEntryCompletionMatchFunc:
 * @completion: the #GtkEntryCompletion
 * @key: the string to match, normalized and case-folded
 * @iter: a #GtkTreeIter indicating the row to match
 * @user_data: user data given to gtk_entry_completion_set_match_func()
 *
 * A function which decides whether the row indicated by @iter matches
 * a given @key, and should be displayed as a possible completion for @key.
 * Note that @key is normalized and case-folded (see g_utf8_normalize()
 * and g_utf8_casefold()). If this is not appropriate, match functions
 * have access to the unmodified key via
 * `gtk_entry_get_text (GTK_ENTRY (gtk_entry_completion_get_entry ()))`.
 *
 * Returns: %TRUE if @iter should be displayed as a possible completion
 *     for @key
 */
typedef gboolean (* GtkEntryCompletionMatchFunc) (GtkEntryCompletion *completion,
                                                  const char        *key,
                                                  GtkTreeIter        *iter,
                                                  gpointer            user_data);



struct GtkImage
{
  GtkMisc misc;

  /*< private >*/
  GtkImagePrivate *priv;
};
struct GtkImageClass
{
  GtkMiscClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

/* core */
GDK_AVAILABLE_IN_ALL
GType               gtk_entry_completion_get_type               (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkEntryCompletion *gtk_entry_completion_new                    (void);
GDK_AVAILABLE_IN_ALL
GtkEntryCompletion *gtk_entry_completion_new_with_area          (GtkCellArea                 *area);

GDK_AVAILABLE_IN_ALL
GtkWidget          *gtk_entry_completion_get_entry              (GtkEntryCompletion          *completion);

GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_set_model              (GtkEntryCompletion          *completion,
                                                                 GtkTreeModel                *model);
GDK_AVAILABLE_IN_ALL
GtkTreeModel       *gtk_entry_completion_get_model              (GtkEntryCompletion          *completion);

GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_set_match_func         (GtkEntryCompletion          *completion,
                                                                 GtkEntryCompletionMatchFunc  func,
                                                                 gpointer                     func_data,
                                                                 GDestroyNotify               func_notify);
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_set_minimum_key_length (GtkEntryCompletion          *completion,
                                                                 gint                         length);
GDK_AVAILABLE_IN_ALL
gint                gtk_entry_completion_get_minimum_key_length (GtkEntryCompletion          *completion);
GDK_AVAILABLE_IN_3_4
char *             gtk_entry_completion_compute_prefix         (GtkEntryCompletion          *completion,
                                                                 const char                  *key);
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_complete               (GtkEntryCompletion          *completion);
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_insert_prefix          (GtkEntryCompletion          *completion);

GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_insert_action_text     (GtkEntryCompletion          *completion,
                                                                 gint                         index_,
                                                                 const char                 *text);
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_insert_action_markup   (GtkEntryCompletion          *completion,
                                                                 gint                         index_,
                                                                 const char                 *markup);
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_delete_action          (GtkEntryCompletion          *completion,
                                                                 gint                         index_);

GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_set_inline_completion  (GtkEntryCompletion          *completion,
                                                                 gboolean                     inline_completion);
GDK_AVAILABLE_IN_ALL
gboolean            gtk_entry_completion_get_inline_completion  (GtkEntryCompletion          *completion);
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_set_inline_selection  (GtkEntryCompletion          *completion,
                                                                 gboolean                     inline_selection);
GDK_AVAILABLE_IN_ALL
gboolean            gtk_entry_completion_get_inline_selection  (GtkEntryCompletion          *completion);
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_set_popup_completion   (GtkEntryCompletion          *completion,
                                                                 gboolean                     popup_completion);
GDK_AVAILABLE_IN_ALL
gboolean            gtk_entry_completion_get_popup_completion   (GtkEntryCompletion          *completion);
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_set_popup_set_width    (GtkEntryCompletion          *completion,
                                                                 gboolean                     popup_set_width);
GDK_AVAILABLE_IN_ALL
gboolean            gtk_entry_completion_get_popup_set_width    (GtkEntryCompletion          *completion);
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_set_popup_single_match (GtkEntryCompletion          *completion,
                                                                 gboolean                     popup_single_match);
GDK_AVAILABLE_IN_ALL
gboolean            gtk_entry_completion_get_popup_single_match (GtkEntryCompletion          *completion);

GDK_AVAILABLE_IN_ALL
const char         *gtk_entry_completion_get_completion_prefix (GtkEntryCompletion *completion);
/* convenience */
GDK_AVAILABLE_IN_ALL
void                gtk_entry_completion_set_text_column        (GtkEntryCompletion          *completion,
                                                                 gint                         column);
GDK_AVAILABLE_IN_ALL
gint                gtk_entry_completion_get_text_column        (GtkEntryCompletion          *completion);

G_END_DECLS

#endif /* __GTK_ENTRY_COMPLETION_H__ */
#define headerfilename "gtk/./gtkimage.h"
/* file: gtk/./gtkimage.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_IMAGE_H__
#define __GTK_IMAGE_H__




#include <gio/gio.h>
#include <gtk/deprecated/gtkmisc.h>


G_BEGIN_DECLS

#define GTK_TYPE_IMAGE()                  (gtk_image_get_type ())
#define GTK_IMAGE(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_IMAGE, GtkImage))
#define GTK_IMAGE_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_IMAGE, GtkImageClass))
#define GTK_IS_IMAGE(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_IMAGE))
#define GTK_IS_IMAGE_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IMAGE))
#define GTK_IMAGE_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_IMAGE, GtkImageClass))



/**
 * GtkImageType:
 * @GTK_IMAGE_EMPTY: there is no image displayed by the widget
 * @GTK_IMAGE_PIXBUF: the widget contains a #GdkPixbuf
 * @GTK_IMAGE_STOCK: the widget contains a [stock item name][gtkstock]
 * @GTK_IMAGE_ICON_SET: the widget contains a #GtkIconSet
 * @GTK_IMAGE_ANIMATION: the widget contains a #GdkPixbufAnimation
 * @GTK_IMAGE_ICON_NAME: the widget contains a named icon.
 *  This image type was added in GTK+ 2.6
 * @GTK_IMAGE_GICON: the widget contains a #GIcon.
 *  This image type was added in GTK+ 2.14
 * @GTK_IMAGE_SURFACE: the widget contains a #cairo_surface_t.
 *  This image type was added in GTK+ 3.10
 *
 * Describes the image data representation used by a #GtkImage. If you
 * want to get the image from the widget, you can only get the
 * currently-stored representation. e.g.  if the
 * gtk_image_get_storage_type() returns #GTK_IMAGE_PIXBUF, then you can
 * call gtk_image_get_pixbuf() but not gtk_image_get_stock().  For empty
 * images, you can request any storage type (call any of the "get"
 * functions), but they will all return %NULL values.
 */
typedef enum
{
  GTK_IMAGE_EMPTY,
  GTK_IMAGE_PIXBUF,
  GTK_IMAGE_STOCK,
  GTK_IMAGE_ICON_SET,
  GTK_IMAGE_ANIMATION,
  GTK_IMAGE_ICON_NAME,
  GTK_IMAGE_GICON,
  GTK_IMAGE_SURFACE
} GtkImageType;
typedef struct GtkEntryPrivate{} GtkEntryPrivate;

/**
 * GtkImage:
 *
 * This struct contain private data only and should be accessed by the functions
 * below.
 */

struct GtkEntry
{
  /*< private >*/
  GtkWidget  parent_instance;

  GtkEntryPrivate *priv;
};
typedef struct GtkSpinButtonPrivate{} GtkSpinButtonPrivate;
struct GtkSpinButton
{
  GtkEntry entry;

  /*< private >*/
  GtkSpinButtonPrivate *priv;
};
struct GtkEntryClass
{
  GtkWidgetClass parent_class;

  /* Hook to customize right-click popup */
  void (* populate_popup)   (GtkEntry       *entry,
                             GtkWidget      *popup);

  /* Action signals
   */
  void (* activate)           (GtkEntry             *entry);
  void (* move_cursor)        (GtkEntry             *entry,
			       GtkMovementStep       step,
			       gint                  count,
			       gboolean              extend_selection);
  void (* insert_at_cursor)   (GtkEntry             *entry,
			       const char          *str);
  void (* delete_from_cursor) (GtkEntry             *entry,
			       GtkDeleteType         type,
			       gint                  count);
  void (* backspace)          (GtkEntry             *entry);
  void (* cut_clipboard)      (GtkEntry             *entry);
  void (* copy_clipboard)     (GtkEntry             *entry);
  void (* paste_clipboard)    (GtkEntry             *entry);
  void (* toggle_overwrite)   (GtkEntry             *entry);

  /* hooks to add other objects beside the entry (like in GtkSpinButton) */
  void (* get_text_area_size) (GtkEntry       *entry,
			       gint           *x,
			       gint           *y,
			       gint           *width,
			       gint           *height);
  void (* get_frame_size)     (GtkEntry       *entry,
                               gint           *x,
                               gint           *y,
			       gint           *width,
			       gint           *height);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1)      (void);
  void (*_gtk_reserved2)      (void);
  void (*_gtk_reserved3)      (void);
  void (*_gtk_reserved4)      (void);
  void (*_gtk_reserved5)      (void);
  void (*_gtk_reserved6)      (void);
  void (*_gtk_reserved7)      (void);
};

GDK_AVAILABLE_IN_ALL
GType      gtk_image_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_image_new                (void);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_image_new_from_file      (const char     *filename);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_image_new_from_resource  (const char     *resource_path);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_image_new_from_pixbuf    (GdkPixbuf       *pixbuf);
GDK_DEPRECATED_IN_3_10_FOR(gtk_image_new_from_icon_name)
GtkWidget* gtk_image_new_from_stock     (const char     *stock_id,
                                         GtkIconSize      size);
GDK_DEPRECATED_IN_3_10_FOR(gtk_image_new_from_icon_name)
GtkWidget* gtk_image_new_from_icon_set  (GtkIconSet      *icon_set,
                                         GtkIconSize      size);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_image_new_from_animation (GdkPixbufAnimation *animation);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_image_new_from_icon_name (const char     *icon_name,
					 GtkIconSize      size);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_image_new_from_gicon     (GIcon           *icon,
					 GtkIconSize      size);
GDK_AVAILABLE_IN_3_10
GtkWidget* gtk_image_new_from_surface   (cairo_surface_t *surface);

GDK_AVAILABLE_IN_ALL
void gtk_image_clear              (GtkImage        *image);
GDK_AVAILABLE_IN_ALL
void gtk_image_set_from_file      (GtkImage        *image,
                                   const char     *filename);
GDK_AVAILABLE_IN_ALL
void gtk_image_set_from_resource  (GtkImage        *image,
                                   const char     *resource_path);
GDK_AVAILABLE_IN_ALL
void gtk_image_set_from_pixbuf    (GtkImage        *image,
                                   GdkPixbuf       *pixbuf);
GDK_DEPRECATED_IN_3_10_FOR(gtk_image_set_from_icon_name)
void gtk_image_set_from_stock     (GtkImage        *image,
                                   const char     *stock_id,
                                   GtkIconSize      size);
GDK_DEPRECATED_IN_3_10_FOR(gtk_image_set_from_icon_name)
void gtk_image_set_from_icon_set  (GtkImage        *image,
                                   GtkIconSet      *icon_set,
                                   GtkIconSize      size);
GDK_AVAILABLE_IN_ALL
void gtk_image_set_from_animation (GtkImage           *image,
                                   GdkPixbufAnimation *animation);
GDK_AVAILABLE_IN_ALL
void gtk_image_set_from_icon_name (GtkImage        *image,
				   const char     *icon_name,
				   GtkIconSize      size);
GDK_AVAILABLE_IN_ALL
void gtk_image_set_from_gicon     (GtkImage        *image,
				   GIcon           *icon,
				   GtkIconSize      size);
GDK_AVAILABLE_IN_3_10
void gtk_image_set_from_surface   (GtkImage        *image,
				   cairo_surface_t *surface);
GDK_AVAILABLE_IN_ALL
void gtk_image_set_pixel_size     (GtkImage        *image,
				   gint             pixel_size);

GDK_AVAILABLE_IN_ALL
GtkImageType gtk_image_get_storage_type (GtkImage   *image);

GDK_AVAILABLE_IN_ALL
GdkPixbuf* gtk_image_get_pixbuf   (GtkImage         *image);
GDK_DEPRECATED_IN_3_10_FOR(gtk_image_get_icon_name)
void       gtk_image_get_stock    (GtkImage         *image,
                                   char           **stock_id,
                                   GtkIconSize      *size);
GDK_DEPRECATED_IN_3_10_FOR(gtk_image_get_icon_name)
void       gtk_image_get_icon_set (GtkImage         *image,
                                   GtkIconSet      **icon_set,
                                   GtkIconSize      *size);
GDK_AVAILABLE_IN_ALL
GdkPixbufAnimation* gtk_image_get_animation (GtkImage *image);
GDK_AVAILABLE_IN_ALL
void       gtk_image_get_icon_name (GtkImage     *image,
				    const char **icon_name,
				    GtkIconSize  *size);
GDK_AVAILABLE_IN_ALL
void       gtk_image_get_gicon     (GtkImage              *image,
				    GIcon                **gicon,
				    GtkIconSize           *size);
GDK_AVAILABLE_IN_ALL
gint       gtk_image_get_pixel_size (GtkImage             *image);

G_END_DECLS

#endif /* __GTK_IMAGE_H__ */
#define headerfilename "gtk/./gtkentry.h"
/* file: gtk/./gtkentry.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * Copyright (C) 2004-2006 Christian Hammond
 * Copyright (C) 2008 Cody Russell
 * Copyright (C) 2008 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_ENTRY_H__
#define __GTK_ENTRY_H__




#include <gtk/gtkeditable.h>
#include <gtk/gtkimcontext.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkentrybuffer.h>
#include <gtk/gtkentrycompletion.h>
#include <gtk/gtkimage.h>
#include <gtk/gtkselection.h>


G_BEGIN_DECLS

#define GTK_TYPE_ENTRY()                  (gtk_entry_get_type ())
#define GTK_ENTRY(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ENTRY, GtkEntry))
#define GTK_ENTRY_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ENTRY, GtkEntryClass))
#define GTK_IS_ENTRY(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ENTRY))
#define GTK_IS_ENTRY_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ENTRY))
#define GTK_ENTRY_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ENTRY, GtkEntryClass))

/**
 * GtkEntryIconPosition:
 * @GTK_ENTRY_ICON_PRIMARY: At the beginning of the entry (depending on the text direction).
 * @GTK_ENTRY_ICON_SECONDARY: At the end of the entry (depending on the text direction).
 *
 * Specifies the side of the entry at which an icon is placed.
 *
 * Since: 2.16
 */
typedef enum
{
  GTK_ENTRY_ICON_PRIMARY,
  GTK_ENTRY_ICON_SECONDARY
} GtkEntryIconPosition;



/**
 * GtkEntryClass:
 * @parent_class: The parent class.
 * @populate_popup: Class handler for the #GtkEntry::populate-popup signal. If
 *   non-%NULL, this will be called to add additional entries to the context
 *   menu when it is displayed.
 * @activate: Class handler for the #GtkEntry::activate signal. The default
 *   implementation calls gtk_window_activate_default() on the entry’s top-level
 *   window.
 * @move_cursor: Class handler for the #GtkEntry::move-cursor signal. The
 *   default implementation specifies the standard #GtkEntry cursor movement
 *   behavior.
 * @insert_at_cursor: Class handler for the #GtkEntry::insert-at-cursor signal.
 *   The default implementation inserts text at the cursor.
 * @delete_from_cursor: Class handler for the #GtkEntry::delete-from-cursor
 *   signal. The default implementation deletes the selection or the specified
 *   number of characters or words.
 * @backspace: Class handler for the #GtkEntry::backspace signal. The default
 *   implementation deletes the selection or a single character or word.
 * @cut_clipboard: Class handler for the #GtkEntry::cut-clipboard signal. The
 *   default implementation cuts the selection, if one exists.
 * @copy_clipboard: Class handler for the #GtkEntry::copy-clipboard signal. The
 *   default implementation copies the selection, if one exists.
 * @paste_clipboard: Class handler for the #GtkEntry::paste-clipboard signal.
 *   The default implementation pastes at the current cursor position or over
 *   the current selection if one exists.
 * @toggle_overwrite: Class handler for the #GtkEntry::toggle-overwrite signal.
 *   The default implementation toggles overwrite mode and blinks the cursor.
 * @get_text_area_size: Calculate the size of the text area, which is its
 *   allocated width and requested height, minus space for margins and borders.
 *   This virtual function must be non-%NULL.
 * @get_frame_size: Calculate the size of the text area frame, which is its
 *   allocated width and requested height, minus space for margins and borders,
 *   and taking baseline and text height into account. This virtual function
 *   must be non-%NULL.
 *
 * Class structure for #GtkEntry. All virtual functions have a default
 * implementation. Derived classes may set the virtual function pointers for the
 * signal handlers to %NULL, but must keep @get_text_area_size and
 * @get_frame_size non-%NULL; either use the default implementation, or provide
 * a custom one.
 */

GDK_AVAILABLE_IN_ALL
GType      gtk_entry_get_type       		(void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_entry_new            		(void);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_entry_new_with_buffer            (GtkEntryBuffer *buffer);

GDK_AVAILABLE_IN_ALL
GtkEntryBuffer* gtk_entry_get_buffer            (GtkEntry       *entry);
GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_buffer                 (GtkEntry       *entry,
                                                 GtkEntryBuffer *buffer);

GDK_AVAILABLE_IN_ALL
void       gtk_entry_get_text_area              (GtkEntry       *entry,
                                                 GdkRectangle   *text_area);

GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_visibility 		(GtkEntry      *entry,
						 gboolean       visible);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_entry_get_visibility             (GtkEntry      *entry);

GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_invisible_char         (GtkEntry      *entry,
                                                 gunichar       ch);
GDK_AVAILABLE_IN_ALL
gunichar   gtk_entry_get_invisible_char         (GtkEntry      *entry);
GDK_AVAILABLE_IN_ALL
void       gtk_entry_unset_invisible_char       (GtkEntry      *entry);

GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_has_frame              (GtkEntry      *entry,
                                                 gboolean       setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_entry_get_has_frame              (GtkEntry      *entry);

GDK_DEPRECATED_IN_3_4
void             gtk_entry_set_inner_border     (GtkEntry        *entry,
                                                 const GtkBorder *border);
GDK_DEPRECATED_IN_3_4
const GtkBorder* gtk_entry_get_inner_border     (GtkEntry        *entry);

GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_overwrite_mode         (GtkEntry      *entry,
                                                 gboolean       overwrite);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_entry_get_overwrite_mode         (GtkEntry      *entry);

/* text is truncated if needed */
GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_max_length 		(GtkEntry      *entry,
						 gint           max);
GDK_AVAILABLE_IN_ALL
gint       gtk_entry_get_max_length             (GtkEntry      *entry);
GDK_AVAILABLE_IN_ALL
guint16    gtk_entry_get_text_length            (GtkEntry      *entry);

GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_activates_default      (GtkEntry      *entry,
                                                 gboolean       setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_entry_get_activates_default      (GtkEntry      *entry);

GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_width_chars            (GtkEntry      *entry,
                                                 gint           n_chars);
GDK_AVAILABLE_IN_ALL
gint       gtk_entry_get_width_chars            (GtkEntry      *entry);

GDK_AVAILABLE_IN_3_12
void       gtk_entry_set_max_width_chars        (GtkEntry      *entry,
                                                 gint           n_chars);
GDK_AVAILABLE_IN_3_12
gint       gtk_entry_get_max_width_chars        (GtkEntry      *entry);

/* Somewhat more convenient than the GtkEditable generic functions
 */
GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_text                   (GtkEntry      *entry,
                                                 const char   *text);
/* returns a reference to the text */
GDK_AVAILABLE_IN_ALL
const char* gtk_entry_get_text        (GtkEntry      *entry);

GDK_AVAILABLE_IN_ALL
PangoLayout* gtk_entry_get_layout               (GtkEntry      *entry);
GDK_AVAILABLE_IN_ALL
void         gtk_entry_get_layout_offsets       (GtkEntry      *entry,
                                                 gint          *x,
                                                 gint          *y);
GDK_AVAILABLE_IN_ALL
void       gtk_entry_set_alignment              (GtkEntry      *entry,
                                                 gfloat         xalign);
GDK_AVAILABLE_IN_ALL
gfloat     gtk_entry_get_alignment              (GtkEntry      *entry);

GDK_AVAILABLE_IN_ALL
void                gtk_entry_set_completion (GtkEntry           *entry,
                                              GtkEntryCompletion *completion);
GDK_AVAILABLE_IN_ALL
GtkEntryCompletion *gtk_entry_get_completion (GtkEntry           *entry);

GDK_AVAILABLE_IN_ALL
gint       gtk_entry_layout_index_to_text_index (GtkEntry      *entry,
                                                 gint           layout_index);
GDK_AVAILABLE_IN_ALL
gint       gtk_entry_text_index_to_layout_index (GtkEntry      *entry,
                                                 gint           text_index);

/* For scrolling cursor appropriately
 */
GDK_AVAILABLE_IN_ALL
void           gtk_entry_set_cursor_hadjustment (GtkEntry      *entry,
                                                 GtkAdjustment *adjustment);
GDK_AVAILABLE_IN_ALL
GtkAdjustment* gtk_entry_get_cursor_hadjustment (GtkEntry      *entry);

/* Progress API
 */
GDK_AVAILABLE_IN_ALL
void           gtk_entry_set_progress_fraction   (GtkEntry     *entry,
                                                  gdouble       fraction);
GDK_AVAILABLE_IN_ALL
gdouble        gtk_entry_get_progress_fraction   (GtkEntry     *entry);

GDK_AVAILABLE_IN_ALL
void           gtk_entry_set_progress_pulse_step (GtkEntry     *entry,
                                                  gdouble       fraction);
GDK_AVAILABLE_IN_ALL
gdouble        gtk_entry_get_progress_pulse_step (GtkEntry     *entry);

GDK_AVAILABLE_IN_ALL
void           gtk_entry_progress_pulse          (GtkEntry     *entry);
GDK_AVAILABLE_IN_3_2
const char*   gtk_entry_get_placeholder_text    (GtkEntry             *entry);
GDK_AVAILABLE_IN_3_2
void           gtk_entry_set_placeholder_text    (GtkEntry             *entry,
                                                  const char          *text);
/* Setting and managing icons
 */
GDK_AVAILABLE_IN_ALL
void           gtk_entry_set_icon_from_pixbuf            (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos,
							  GdkPixbuf            *pixbuf);
GDK_DEPRECATED_IN_3_10_FOR(gtk_entry_set_icon_from_icon_name)
void           gtk_entry_set_icon_from_stock             (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos,
							  const char          *stock_id);
GDK_AVAILABLE_IN_ALL
void           gtk_entry_set_icon_from_icon_name         (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos,
							  const char          *icon_name);
GDK_AVAILABLE_IN_ALL
void           gtk_entry_set_icon_from_gicon             (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos,
							  GIcon                *icon);
GDK_AVAILABLE_IN_ALL
GtkImageType gtk_entry_get_icon_storage_type             (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos);
GDK_AVAILABLE_IN_ALL
GdkPixbuf*   gtk_entry_get_icon_pixbuf                   (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos);
GDK_DEPRECATED_IN_3_10_FOR(gtk_entry_get_icon_name)
const char* gtk_entry_get_icon_stock                    (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos);
GDK_AVAILABLE_IN_ALL
const char* gtk_entry_get_icon_name                     (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos);
GDK_AVAILABLE_IN_ALL
GIcon*       gtk_entry_get_icon_gicon                    (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos);
GDK_AVAILABLE_IN_ALL
void         gtk_entry_set_icon_activatable              (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos,
							  gboolean              activatable);
GDK_AVAILABLE_IN_ALL
gboolean     gtk_entry_get_icon_activatable              (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos);
GDK_AVAILABLE_IN_ALL
void         gtk_entry_set_icon_sensitive                (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos,
							  gboolean              sensitive);
GDK_AVAILABLE_IN_ALL
gboolean     gtk_entry_get_icon_sensitive                (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos);
GDK_AVAILABLE_IN_ALL
gint         gtk_entry_get_icon_at_pos                   (GtkEntry             *entry,
							  gint                  x,
							  gint                  y);
GDK_AVAILABLE_IN_ALL
void         gtk_entry_set_icon_tooltip_text             (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos,
							  const char          *tooltip);
GDK_AVAILABLE_IN_ALL
char *      gtk_entry_get_icon_tooltip_text             (GtkEntry             *entry,
                                                          GtkEntryIconPosition  icon_pos);
GDK_AVAILABLE_IN_ALL
void         gtk_entry_set_icon_tooltip_markup           (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos,
							  const char          *tooltip);
GDK_AVAILABLE_IN_ALL
char *      gtk_entry_get_icon_tooltip_markup           (GtkEntry             *entry,
                                                          GtkEntryIconPosition  icon_pos);
GDK_AVAILABLE_IN_ALL
void         gtk_entry_set_icon_drag_source              (GtkEntry             *entry,
							  GtkEntryIconPosition  icon_pos,
							  GtkTargetList        *target_list,
							  GdkDragAction         actions);
GDK_AVAILABLE_IN_ALL
gint         gtk_entry_get_current_icon_drag_source      (GtkEntry             *entry);
GDK_AVAILABLE_IN_ALL
void         gtk_entry_get_icon_area                     (GtkEntry             *entry,
                                                          GtkEntryIconPosition  icon_pos,
                                                          GdkRectangle         *icon_area);

GDK_AVAILABLE_IN_ALL
gboolean    gtk_entry_im_context_filter_keypress         (GtkEntry             *entry,
                                                          GdkEventKey          *event);
GDK_AVAILABLE_IN_ALL
void        gtk_entry_reset_im_context                   (GtkEntry             *entry);

GDK_AVAILABLE_IN_3_6
void            gtk_entry_set_input_purpose                  (GtkEntry             *entry,
                                                              GtkInputPurpose       purpose);
GDK_AVAILABLE_IN_3_6
GtkInputPurpose gtk_entry_get_input_purpose                  (GtkEntry             *entry);

GDK_AVAILABLE_IN_3_6
void            gtk_entry_set_input_hints                    (GtkEntry             *entry,
                                                              GtkInputHints         hints);
GDK_AVAILABLE_IN_3_6
GtkInputHints   gtk_entry_get_input_hints                    (GtkEntry             *entry);

GDK_AVAILABLE_IN_3_6
void            gtk_entry_set_attributes                     (GtkEntry             *entry,
                                                              PangoAttrList        *attrs);
GDK_AVAILABLE_IN_3_6
PangoAttrList  *gtk_entry_get_attributes                     (GtkEntry             *entry);

GDK_AVAILABLE_IN_3_10
void            gtk_entry_set_tabs                           (GtkEntry             *entry,
                                                              PangoTabArray        *tabs);

GDK_AVAILABLE_IN_3_10
PangoTabArray  *gtk_entry_get_tabs                           (GtkEntry             *entry);

GDK_AVAILABLE_IN_3_16
void           gtk_entry_grab_focus_without_selecting        (GtkEntry             *entry);

G_END_DECLS

#endif /* __GTK_ENTRY_H__ */
#define headerfilename "gtk/./gtktreeview.h"
/* file: gtk/./gtktreeview.h */
/* gtktreeview.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_TREE_VIEW_H__
#define __GTK_TREE_VIEW_H__



#include <gtk/gtkcontainer.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtktreeviewcolumn.h>
#include <gtk/gtkdnd.h>
#include <gtk/gtkentry.h>

G_BEGIN_DECLS

/**
 * GtkTreeViewDropPosition:
 * @GTK_TREE_VIEW_DROP_BEFORE: dropped row is inserted before
 * @GTK_TREE_VIEW_DROP_AFTER: dropped row is inserted after
 * @GTK_TREE_VIEW_DROP_INTO_OR_BEFORE: dropped row becomes a child or is inserted before
 * @GTK_TREE_VIEW_DROP_INTO_OR_AFTER: dropped row becomes a child or is inserted after
 *
 * An enum for determining where a dropped row goes.
 */
typedef enum
{
  /* drop before/after this row */
  GTK_TREE_VIEW_DROP_BEFORE,
  GTK_TREE_VIEW_DROP_AFTER,
  /* drop as a child of this row (with fallback to before or after
   * if into is not possible)
   */
  GTK_TREE_VIEW_DROP_INTO_OR_BEFORE,
  GTK_TREE_VIEW_DROP_INTO_OR_AFTER
} GtkTreeViewDropPosition;
typedef struct GtkTreeViewPrivate{} GtkTreeViewPrivate;
struct GtkTreeView
{
  GtkContainer parent;

  /*< private >*/
  GtkTreeViewPrivate *priv;
};
struct GtkTreeViewClass
{
  GtkContainerClass parent_class;

  void     (* row_activated)              (GtkTreeView       *tree_view,
				           GtkTreePath       *path,
					   GtkTreeViewColumn *column);
  gboolean (* test_expand_row)            (GtkTreeView       *tree_view,
				           GtkTreeIter       *iter,
				           GtkTreePath       *path);
  gboolean (* test_collapse_row)          (GtkTreeView       *tree_view,
				           GtkTreeIter       *iter,
				           GtkTreePath       *path);
  void     (* row_expanded)               (GtkTreeView       *tree_view,
				           GtkTreeIter       *iter,
				           GtkTreePath       *path);
  void     (* row_collapsed)              (GtkTreeView       *tree_view,
				           GtkTreeIter       *iter,
				           GtkTreePath       *path);
  void     (* columns_changed)            (GtkTreeView       *tree_view);
  void     (* cursor_changed)             (GtkTreeView       *tree_view);

  /* Key Binding signals */
  gboolean (* move_cursor)                (GtkTreeView       *tree_view,
				           GtkMovementStep    step,
				           gint               count);
  gboolean (* select_all)                 (GtkTreeView       *tree_view);
  gboolean (* unselect_all)               (GtkTreeView       *tree_view);
  gboolean (* select_cursor_row)          (GtkTreeView       *tree_view,
					   gboolean           start_editing);
  gboolean (* toggle_cursor_row)          (GtkTreeView       *tree_view);
  gboolean (* expand_collapse_cursor_row) (GtkTreeView       *tree_view,
					   gboolean           logical,
					   gboolean           expand,
					   gboolean           open_all);
  gboolean (* select_cursor_parent)       (GtkTreeView       *tree_view);
  gboolean (* start_interactive_search)   (GtkTreeView       *tree_view);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};

#define GTK_TYPE_TREE_VIEW()		(gtk_tree_view_get_type ())
#define GTK_TREE_VIEW(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TREE_VIEW, GtkTreeView))
#define GTK_TREE_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_TREE_VIEW, GtkTreeViewClass))
#define GTK_IS_TREE_VIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TREE_VIEW))
#define GTK_IS_TREE_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_TREE_VIEW))
#define GTK_TREE_VIEW_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_TREE_VIEW, GtkTreeViewClass))

typedef struct GtkComboBoxPrivate{} GtkComboBoxPrivate;


struct GtkComboBox
{
  GtkBin parent_instance;

  /*< private >*/
  GtkComboBoxPrivate *priv;
};
struct GtkComboBoxClass
{
  GtkBinClass parent_class;

  /*< public >*/

  /* signals */
  void     (* changed)           (GtkComboBox *combo_box);
  char   *(* format_entry_text) (GtkComboBox *combo_box,
				  const char *path);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
};
typedef struct GtkTreeSelectionPrivate{} GtkTreeSelectionPrivate;
struct GtkTreeSelection
{
  /*< private >*/
  GObject parent;

  GtkTreeSelectionPrivate *priv;
};

/**
 * GtkTreeViewColumnDropFunc:
 * @tree_view: A #GtkTreeView
 * @column: The #GtkTreeViewColumn being dragged
 * @prev_column: A #GtkTreeViewColumn on one side of @column
 * @next_column: A #GtkTreeViewColumn on the other side of @column
 * @data: (closure): user data
 *
 * Function type for determining whether @column can be dropped in a
 * particular spot (as determined by @prev_column and @next_column).  In
 * left to right locales, @prev_column is on the left of the potential drop
 * spot, and @next_column is on the right.  In right to left mode, this is
 * reversed.  This function should return %TRUE if the spot is a valid drop
 * spot.  Please note that returning %TRUE does not actually indicate that
 * the column drop was made, but is meant only to indicate a possible drop
 * spot to the user.
 *
 * Returns: %TRUE, if @column can be dropped in this spot
 */
typedef gboolean (* GtkTreeViewColumnDropFunc) (GtkTreeView             *tree_view,
						GtkTreeViewColumn       *column,
						GtkTreeViewColumn       *prev_column,
						GtkTreeViewColumn       *next_column,
						gpointer                 data);

/**
 * GtkTreeViewMappingFunc:
 * @tree_view: A #GtkTreeView
 * @path: The path that’s expanded
 * @user_data: user data
 *
 * Function used for gtk_tree_view_map_expanded_rows().
 */
typedef void     (* GtkTreeViewMappingFunc)    (GtkTreeView             *tree_view,
						GtkTreePath             *path,
						gpointer                 user_data);

/**
 * GtkTreeViewSearchEqualFunc:
 * @model: the #GtkTreeModel being searched
 * @column: the search column set by gtk_tree_view_set_search_column()
 * @key: the key string to compare with
 * @iter: a #GtkTreeIter pointing the row of @model that should be compared
 *  with @key.
 * @search_data: (closure): user data from gtk_tree_view_set_search_equal_func()
 *
 * A function used for checking whether a row in @model matches
 * a search key string entered by the user. Note the return value
 * is reversed from what you would normally expect, though it
 * has some similarity to strcmp() returning 0 for equal strings.
 *
 * Returns: %FALSE if the row matches, %TRUE otherwise.
 */
typedef gboolean (*GtkTreeViewSearchEqualFunc) (GtkTreeModel            *model,
						gint                     column,
						const char             *key,
						GtkTreeIter             *iter,
						gpointer                 search_data);

/**
 * GtkTreeViewRowSeparatorFunc:
 * @model: the #GtkTreeModel
 * @iter: a #GtkTreeIter pointing at a row in @model
 * @data: (closure): user data
 *
 * Function type for determining whether the row pointed to by @iter should
 * be rendered as a separator. A common way to implement this is to have a
 * boolean column in the model, whose values the #GtkTreeViewRowSeparatorFunc
 * returns.
 *
 * Returns: %TRUE if the row is a separator
 */
typedef gboolean (*GtkTreeViewRowSeparatorFunc) (GtkTreeModel      *model,
						 GtkTreeIter       *iter,
						 gpointer           data);
typedef void     (*GtkTreeViewSearchPositionFunc) (GtkTreeView  *tree_view,
						   GtkWidget    *search_dialog,
						   gpointer      user_data);


/* Creators */
GDK_AVAILABLE_IN_ALL
GType                  gtk_tree_view_get_type                      (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget             *gtk_tree_view_new                           (void);
GDK_AVAILABLE_IN_ALL
GtkWidget             *gtk_tree_view_new_with_model                (GtkTreeModel              *model);

/* Accessors */
GDK_AVAILABLE_IN_ALL
GtkTreeModel          *gtk_tree_view_get_model                     (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_set_model                     (GtkTreeView               *tree_view,
								    GtkTreeModel              *model);
GDK_AVAILABLE_IN_ALL
GtkTreeSelection      *gtk_tree_view_get_selection                 (GtkTreeView               *tree_view);

GDK_DEPRECATED_IN_3_0_FOR(gtk_scrollable_get_hadjustment)
GtkAdjustment         *gtk_tree_view_get_hadjustment               (GtkTreeView               *tree_view);
GDK_DEPRECATED_IN_3_0_FOR(gtk_scrollable_set_hadjustment)
void                   gtk_tree_view_set_hadjustment               (GtkTreeView               *tree_view,
								    GtkAdjustment             *adjustment);
GDK_DEPRECATED_IN_3_0_FOR(gtk_scrollable_get_vadjustment)
GtkAdjustment         *gtk_tree_view_get_vadjustment               (GtkTreeView               *tree_view);
GDK_DEPRECATED_IN_3_0_FOR(gtk_scrollable_set_vadjustment)
void                   gtk_tree_view_set_vadjustment               (GtkTreeView               *tree_view,
								    GtkAdjustment             *adjustment);


GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_get_headers_visible           (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_set_headers_visible           (GtkTreeView               *tree_view,
								    gboolean                   headers_visible);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_columns_autosize              (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_get_headers_clickable         (GtkTreeView *tree_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_set_headers_clickable         (GtkTreeView               *tree_view,
								    gboolean                   setting);
GDK_DEPRECATED_IN_3_14
void                   gtk_tree_view_set_rules_hint                (GtkTreeView               *tree_view,
								    gboolean                   setting);
GDK_DEPRECATED_IN_3_14
gboolean               gtk_tree_view_get_rules_hint                (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_3_8
gboolean               gtk_tree_view_get_activate_on_single_click  (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_3_8
void                   gtk_tree_view_set_activate_on_single_click  (GtkTreeView               *tree_view,
								    gboolean                   single);

/* Column funtions */
GDK_AVAILABLE_IN_ALL
gint                   gtk_tree_view_append_column                 (GtkTreeView               *tree_view,
								    GtkTreeViewColumn         *column);
GDK_AVAILABLE_IN_ALL
gint                   gtk_tree_view_remove_column                 (GtkTreeView               *tree_view,
								    GtkTreeViewColumn         *column);
GDK_AVAILABLE_IN_ALL
gint                   gtk_tree_view_insert_column                 (GtkTreeView               *tree_view,
								    GtkTreeViewColumn         *column,
								    gint                       position);
GDK_AVAILABLE_IN_ALL
gint                   gtk_tree_view_insert_column_with_attributes (GtkTreeView               *tree_view,
								    gint                       position,
								    const char               *title,
								    GtkCellRenderer           *cell,
								    ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
gint                   gtk_tree_view_insert_column_with_data_func  (GtkTreeView               *tree_view,
								    gint                       position,
								    const char               *title,
								    GtkCellRenderer           *cell,
                                                                    GtkTreeCellDataFunc        func,
                                                                    gpointer                   data,
                                                                    GDestroyNotify             dnotify);

GDK_AVAILABLE_IN_3_4
guint                  gtk_tree_view_get_n_columns                 (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
GtkTreeViewColumn     *gtk_tree_view_get_column                    (GtkTreeView               *tree_view,
								    gint                       n);
GDK_AVAILABLE_IN_ALL
GList                 *gtk_tree_view_get_columns                   (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_move_column_after             (GtkTreeView               *tree_view,
								    GtkTreeViewColumn         *column,
								    GtkTreeViewColumn         *base_column);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_set_expander_column           (GtkTreeView               *tree_view,
								    GtkTreeViewColumn         *column);
GDK_AVAILABLE_IN_ALL
GtkTreeViewColumn     *gtk_tree_view_get_expander_column           (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_set_column_drag_function      (GtkTreeView               *tree_view,
								    GtkTreeViewColumnDropFunc  func,
								    gpointer                   user_data,
								    GDestroyNotify             destroy);

/* Actions */
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_scroll_to_point               (GtkTreeView               *tree_view,
								    gint                       tree_x,
								    gint                       tree_y);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_scroll_to_cell                (GtkTreeView               *tree_view,
								    GtkTreePath               *path,
								    GtkTreeViewColumn         *column,
								    gboolean                   use_align,
								    gfloat                     row_align,
								    gfloat                     col_align);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_row_activated                 (GtkTreeView               *tree_view,
								    GtkTreePath               *path,
								    GtkTreeViewColumn         *column);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_expand_all                    (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_collapse_all                  (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_expand_to_path                (GtkTreeView               *tree_view,
								    GtkTreePath               *path);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_expand_row                    (GtkTreeView               *tree_view,
								    GtkTreePath               *path,
								    gboolean                   open_all);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_collapse_row                  (GtkTreeView               *tree_view,
								    GtkTreePath               *path);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_map_expanded_rows             (GtkTreeView               *tree_view,
								    GtkTreeViewMappingFunc     func,
								    gpointer                   data);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_row_expanded                  (GtkTreeView               *tree_view,
								    GtkTreePath               *path);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_set_reorderable               (GtkTreeView               *tree_view,
								    gboolean                   reorderable);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_get_reorderable               (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_set_cursor                    (GtkTreeView               *tree_view,
								    GtkTreePath               *path,
								    GtkTreeViewColumn         *focus_column,
								    gboolean                   start_editing);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_set_cursor_on_cell            (GtkTreeView               *tree_view,
								    GtkTreePath               *path,
								    GtkTreeViewColumn         *focus_column,
								    GtkCellRenderer           *focus_cell,
								    gboolean                   start_editing);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_get_cursor                    (GtkTreeView               *tree_view,
								    GtkTreePath              **path,
								    GtkTreeViewColumn        **focus_column);


/* Layout information */
GDK_AVAILABLE_IN_ALL
GdkWindow             *gtk_tree_view_get_bin_window                (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_get_path_at_pos               (GtkTreeView               *tree_view,
								    gint                       x,
								    gint                       y,
								    GtkTreePath              **path,
								    GtkTreeViewColumn        **column,
								    gint                      *cell_x,
								    gint                      *cell_y);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_get_cell_area                 (GtkTreeView               *tree_view,
								    GtkTreePath               *path,
								    GtkTreeViewColumn         *column,
								    GdkRectangle              *rect);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_get_background_area           (GtkTreeView               *tree_view,
								    GtkTreePath               *path,
								    GtkTreeViewColumn         *column,
								    GdkRectangle              *rect);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_get_visible_rect              (GtkTreeView               *tree_view,
								    GdkRectangle              *visible_rect);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_get_visible_range             (GtkTreeView               *tree_view,
								    GtkTreePath              **start_path,
								    GtkTreePath              **end_path);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_is_blank_at_pos               (GtkTreeView               *tree_view,
                                                                    gint                       x,
                                                                    gint                       y,
                                                                    GtkTreePath              **path,
                                                                    GtkTreeViewColumn        **column,
                                                                    gint                      *cell_x,
                                                                    gint                      *cell_y);

/* Drag-and-Drop support */
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_enable_model_drag_source      (GtkTreeView               *tree_view,
								    GdkModifierType            start_button_mask,
								    const GtkTargetEntry      *targets,
								    gint                       n_targets,
								    GdkDragAction              actions);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_enable_model_drag_dest        (GtkTreeView               *tree_view,
								    const GtkTargetEntry      *targets,
								    gint                       n_targets,
								    GdkDragAction              actions);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_unset_rows_drag_source        (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_unset_rows_drag_dest          (GtkTreeView               *tree_view);


/* These are useful to implement your own custom stuff. */
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_set_drag_dest_row             (GtkTreeView               *tree_view,
								    GtkTreePath               *path,
								    GtkTreeViewDropPosition    pos);
GDK_AVAILABLE_IN_ALL
void                   gtk_tree_view_get_drag_dest_row             (GtkTreeView               *tree_view,
								    GtkTreePath              **path,
								    GtkTreeViewDropPosition   *pos);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_tree_view_get_dest_row_at_pos           (GtkTreeView               *tree_view,
								    gint                       drag_x,
								    gint                       drag_y,
								    GtkTreePath              **path,
								    GtkTreeViewDropPosition   *pos);
GDK_AVAILABLE_IN_ALL
cairo_surface_t       *gtk_tree_view_create_row_drag_icon          (GtkTreeView               *tree_view,
								    GtkTreePath               *path);

/* Interactive search */
GDK_AVAILABLE_IN_ALL
void                       gtk_tree_view_set_enable_search     (GtkTreeView                *tree_view,
								gboolean                    enable_search);
GDK_AVAILABLE_IN_ALL
gboolean                   gtk_tree_view_get_enable_search     (GtkTreeView                *tree_view);
GDK_AVAILABLE_IN_ALL
gint                       gtk_tree_view_get_search_column     (GtkTreeView                *tree_view);
GDK_AVAILABLE_IN_ALL
void                       gtk_tree_view_set_search_column     (GtkTreeView                *tree_view,
								gint                        column);
GDK_AVAILABLE_IN_ALL
GtkTreeViewSearchEqualFunc gtk_tree_view_get_search_equal_func (GtkTreeView                *tree_view);
GDK_AVAILABLE_IN_ALL
void                       gtk_tree_view_set_search_equal_func (GtkTreeView                *tree_view,
								GtkTreeViewSearchEqualFunc  search_equal_func,
								gpointer                    search_user_data,
								GDestroyNotify              search_destroy);

GDK_AVAILABLE_IN_ALL
GtkEntry                     *gtk_tree_view_get_search_entry         (GtkTreeView                   *tree_view);
GDK_AVAILABLE_IN_ALL
void                          gtk_tree_view_set_search_entry         (GtkTreeView                   *tree_view,
								      GtkEntry                      *entry);
GDK_AVAILABLE_IN_ALL
GtkTreeViewSearchPositionFunc gtk_tree_view_get_search_position_func (GtkTreeView                   *tree_view);
GDK_AVAILABLE_IN_ALL
void                          gtk_tree_view_set_search_position_func (GtkTreeView                   *tree_view,
								      GtkTreeViewSearchPositionFunc  func,
								      gpointer                       data,
								      GDestroyNotify                 destroy);

/* Convert between the different coordinate systems */
GDK_AVAILABLE_IN_ALL
void gtk_tree_view_convert_widget_to_tree_coords       (GtkTreeView *tree_view,
							gint         wx,
							gint         wy,
							gint        *tx,
							gint        *ty);
GDK_AVAILABLE_IN_ALL
void gtk_tree_view_convert_tree_to_widget_coords       (GtkTreeView *tree_view,
							gint         tx,
							gint         ty,
							gint        *wx,
							gint        *wy);
GDK_AVAILABLE_IN_ALL
void gtk_tree_view_convert_widget_to_bin_window_coords (GtkTreeView *tree_view,
							gint         wx,
							gint         wy,
							gint        *bx,
							gint        *by);
GDK_AVAILABLE_IN_ALL
void gtk_tree_view_convert_bin_window_to_widget_coords (GtkTreeView *tree_view,
							gint         bx,
							gint         by,
							gint        *wx,
							gint        *wy);
GDK_AVAILABLE_IN_ALL
void gtk_tree_view_convert_tree_to_bin_window_coords   (GtkTreeView *tree_view,
							gint         tx,
							gint         ty,
							gint        *bx,
							gint        *by);
GDK_AVAILABLE_IN_ALL
void gtk_tree_view_convert_bin_window_to_tree_coords   (GtkTreeView *tree_view,
							gint         bx,
							gint         by,
							gint        *tx,
							gint        *ty);

/* This function should really never be used.  It is just for use by ATK.
 */
typedef void (* GtkTreeDestroyCountFunc)  (GtkTreeView             *tree_view,
					   GtkTreePath             *path,
					   gint                     children,
					   gpointer                 user_data);
GDK_DEPRECATED_IN_3_4
void gtk_tree_view_set_destroy_count_func (GtkTreeView             *tree_view,
					   GtkTreeDestroyCountFunc  func,
					   gpointer                 data,
					   GDestroyNotify           destroy);

GDK_AVAILABLE_IN_ALL
void     gtk_tree_view_set_fixed_height_mode (GtkTreeView          *tree_view,
					      gboolean              enable);
GDK_AVAILABLE_IN_ALL
gboolean gtk_tree_view_get_fixed_height_mode (GtkTreeView          *tree_view);
GDK_AVAILABLE_IN_ALL
void     gtk_tree_view_set_hover_selection   (GtkTreeView          *tree_view,
					      gboolean              hover);
GDK_AVAILABLE_IN_ALL
gboolean gtk_tree_view_get_hover_selection   (GtkTreeView          *tree_view);
GDK_AVAILABLE_IN_ALL
void     gtk_tree_view_set_hover_expand      (GtkTreeView          *tree_view,
					      gboolean              expand);
GDK_AVAILABLE_IN_ALL
gboolean gtk_tree_view_get_hover_expand      (GtkTreeView          *tree_view);
GDK_AVAILABLE_IN_ALL
void     gtk_tree_view_set_rubber_banding    (GtkTreeView          *tree_view,
					      gboolean              enable);
GDK_AVAILABLE_IN_ALL
gboolean gtk_tree_view_get_rubber_banding    (GtkTreeView          *tree_view);

GDK_AVAILABLE_IN_ALL
gboolean gtk_tree_view_is_rubber_banding_active (GtkTreeView       *tree_view);

GDK_AVAILABLE_IN_ALL
GtkTreeViewRowSeparatorFunc gtk_tree_view_get_row_separator_func (GtkTreeView               *tree_view);
GDK_AVAILABLE_IN_ALL
void                        gtk_tree_view_set_row_separator_func (GtkTreeView                *tree_view,
								  GtkTreeViewRowSeparatorFunc func,
								  gpointer                    data,
								  GDestroyNotify              destroy);

GDK_AVAILABLE_IN_ALL
GtkTreeViewGridLines        gtk_tree_view_get_grid_lines         (GtkTreeView                *tree_view);
GDK_AVAILABLE_IN_ALL
void                        gtk_tree_view_set_grid_lines         (GtkTreeView                *tree_view,
								  GtkTreeViewGridLines        grid_lines);
GDK_AVAILABLE_IN_ALL
gboolean                    gtk_tree_view_get_enable_tree_lines  (GtkTreeView                *tree_view);
GDK_AVAILABLE_IN_ALL
void                        gtk_tree_view_set_enable_tree_lines  (GtkTreeView                *tree_view,
								  gboolean                    enabled);
GDK_AVAILABLE_IN_ALL
void                        gtk_tree_view_set_show_expanders     (GtkTreeView                *tree_view,
								  gboolean                    enabled);
GDK_AVAILABLE_IN_ALL
gboolean                    gtk_tree_view_get_show_expanders     (GtkTreeView                *tree_view);
GDK_AVAILABLE_IN_ALL
void                        gtk_tree_view_set_level_indentation  (GtkTreeView                *tree_view,
								  gint                        indentation);
GDK_AVAILABLE_IN_ALL
gint                        gtk_tree_view_get_level_indentation  (GtkTreeView                *tree_view);

/* Convenience functions for setting tooltips */
GDK_AVAILABLE_IN_ALL
void          gtk_tree_view_set_tooltip_row    (GtkTreeView       *tree_view,
						GtkTooltip        *tooltip,
						GtkTreePath       *path);
GDK_AVAILABLE_IN_ALL
void          gtk_tree_view_set_tooltip_cell   (GtkTreeView       *tree_view,
						GtkTooltip        *tooltip,
						GtkTreePath       *path,
						GtkTreeViewColumn *column,
						GtkCellRenderer   *cell);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_tree_view_get_tooltip_context(GtkTreeView       *tree_view,
						gint              *x,
						gint              *y,
						gboolean           keyboard_tip,
						GtkTreeModel     **model,
						GtkTreePath      **path,
						GtkTreeIter       *iter);
GDK_AVAILABLE_IN_ALL
void          gtk_tree_view_set_tooltip_column (GtkTreeView       *tree_view,
					        gint               column);
GDK_AVAILABLE_IN_ALL
gint          gtk_tree_view_get_tooltip_column (GtkTreeView       *tree_view);

G_END_DECLS


#endif /* __GTK_TREE_VIEW_H__ */
#define headerfilename "gtk/./gtkcombobox.h"
/* file: gtk/./gtkcombobox.h */
/* gtkcombobox.h
 * Copyright (C) 2002, 2003  Kristian Rietveld <kris@gtk.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_COMBO_BOX_H__
#define __GTK_COMBO_BOX_H__



#include <gtk/gtkbin.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtktreeview.h>

G_BEGIN_DECLS

#define GTK_TYPE_COMBO_BOX()             (gtk_combo_box_get_type ())
#define GTK_COMBO_BOX(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_COMBO_BOX, GtkComboBox))
#define GTK_COMBO_BOX_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), GTK_TYPE_COMBO_BOX, GtkComboBoxClass))
#define GTK_IS_COMBO_BOX(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_COMBO_BOX))
#define GTK_IS_COMBO_BOX_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), GTK_TYPE_COMBO_BOX))
#define GTK_COMBO_BOX_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_CLASS ((inst), GTK_TYPE_COMBO_BOX, GtkComboBoxClass))



/**
 * GtkComboBoxClass:
 * @parent_class: The parent class.
 * @changed: Signal is emitted when the active item is changed.
 * @format_entry_text: Signal which allows you to change how the text
 *    displayed in a combo box’s entry is displayed.
 */


/* construction */
GDK_AVAILABLE_IN_ALL
GType         gtk_combo_box_get_type                 (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget    *gtk_combo_box_new                      (void);
GDK_AVAILABLE_IN_ALL
GtkWidget    *gtk_combo_box_new_with_area            (GtkCellArea  *area);
GDK_AVAILABLE_IN_ALL
GtkWidget    *gtk_combo_box_new_with_area_and_entry  (GtkCellArea  *area);
GDK_AVAILABLE_IN_ALL
GtkWidget    *gtk_combo_box_new_with_entry           (void);
GDK_AVAILABLE_IN_ALL
GtkWidget    *gtk_combo_box_new_with_model           (GtkTreeModel *model);
GDK_AVAILABLE_IN_ALL
GtkWidget    *gtk_combo_box_new_with_model_and_entry (GtkTreeModel *model);

/* grids */
GDK_AVAILABLE_IN_ALL
gint          gtk_combo_box_get_wrap_width         (GtkComboBox *combo_box);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_set_wrap_width         (GtkComboBox *combo_box,
                                                    gint         width);
GDK_AVAILABLE_IN_ALL
gint          gtk_combo_box_get_row_span_column    (GtkComboBox *combo_box);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_set_row_span_column    (GtkComboBox *combo_box,
                                                    gint         row_span);
GDK_AVAILABLE_IN_ALL
gint          gtk_combo_box_get_column_span_column (GtkComboBox *combo_box);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_set_column_span_column (GtkComboBox *combo_box,
                                                    gint         column_span);

GDK_DEPRECATED_IN_3_10
gboolean      gtk_combo_box_get_add_tearoffs       (GtkComboBox *combo_box);
GDK_DEPRECATED_IN_3_10
void          gtk_combo_box_set_add_tearoffs       (GtkComboBox *combo_box,
                                                    gboolean     add_tearoffs);

GDK_DEPRECATED_IN_3_10
const char * gtk_combo_box_get_title              (GtkComboBox *combo_box);
GDK_DEPRECATED_IN_3_10
void          gtk_combo_box_set_title              (GtkComboBox *combo_box,
                                                    const char *title);

GDK_DEPRECATED_IN_3_20_FOR(gtk_widget_get_focus_on_click)
gboolean      gtk_combo_box_get_focus_on_click     (GtkComboBox *combo);
GDK_DEPRECATED_IN_3_20_FOR(gtk_widget_set_focus_on_click)
void          gtk_combo_box_set_focus_on_click     (GtkComboBox *combo,
                                                    gboolean     focus_on_click);

/* get/set active item */
GDK_AVAILABLE_IN_ALL
gint          gtk_combo_box_get_active       (GtkComboBox     *combo_box);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_set_active       (GtkComboBox     *combo_box,
                                              gint             index_);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_combo_box_get_active_iter  (GtkComboBox     *combo_box,
                                              GtkTreeIter     *iter);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_set_active_iter  (GtkComboBox     *combo_box,
                                              GtkTreeIter     *iter);

/* getters and setters */
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_set_model        (GtkComboBox     *combo_box,
                                              GtkTreeModel    *model);
GDK_AVAILABLE_IN_ALL
GtkTreeModel *gtk_combo_box_get_model        (GtkComboBox     *combo_box);

GDK_AVAILABLE_IN_ALL
GtkTreeViewRowSeparatorFunc gtk_combo_box_get_row_separator_func (GtkComboBox                *combo_box);
GDK_AVAILABLE_IN_ALL
void                        gtk_combo_box_set_row_separator_func (GtkComboBox                *combo_box,
                                                                  GtkTreeViewRowSeparatorFunc func,
                                                                  gpointer                    data,
                                                                  GDestroyNotify              destroy);

GDK_AVAILABLE_IN_ALL
void               gtk_combo_box_set_button_sensitivity (GtkComboBox        *combo_box,
                                                         GtkSensitivityType  sensitivity);
GDK_AVAILABLE_IN_ALL
GtkSensitivityType gtk_combo_box_get_button_sensitivity (GtkComboBox        *combo_box);

GDK_AVAILABLE_IN_ALL
gboolean           gtk_combo_box_get_has_entry          (GtkComboBox        *combo_box);
GDK_AVAILABLE_IN_ALL
void               gtk_combo_box_set_entry_text_column  (GtkComboBox        *combo_box,
                                                         gint                text_column);
GDK_AVAILABLE_IN_ALL
gint               gtk_combo_box_get_entry_text_column  (GtkComboBox        *combo_box);

GDK_AVAILABLE_IN_ALL
void               gtk_combo_box_set_popup_fixed_width  (GtkComboBox      *combo_box,
                                                         gboolean          fixed);
GDK_AVAILABLE_IN_ALL
gboolean           gtk_combo_box_get_popup_fixed_width  (GtkComboBox      *combo_box);

/* programmatic control */
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_popup            (GtkComboBox     *combo_box);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_popup_for_device (GtkComboBox     *combo_box,
                                              GdkDevice       *device);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_popdown          (GtkComboBox     *combo_box);
GDK_AVAILABLE_IN_ALL
AtkObject*    gtk_combo_box_get_popup_accessible (GtkComboBox *combo_box);

GDK_AVAILABLE_IN_ALL
gint          gtk_combo_box_get_id_column        (GtkComboBox *combo_box);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_set_id_column        (GtkComboBox *combo_box,
                                                  gint         id_column);
GDK_AVAILABLE_IN_ALL
const char * gtk_combo_box_get_active_id        (GtkComboBox *combo_box);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_combo_box_set_active_id        (GtkComboBox *combo_box,
                                                  const char *active_id);

G_END_DECLS

#endif /* __GTK_COMBO_BOX_H__ */
#define headerfilename "gtk/./gtkappchooserbutton.h"
/* file: gtk/./gtkappchooserbutton.h */
/*
 * gtkappchooserbutton.h: an app-chooser combobox
 *
 * Copyright (C) 2010 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Cosimo Cecchi <ccecchi@redhat.com>
 */

#ifndef __GTK_APP_CHOOSER_BUTTON_H__
#define __GTK_APP_CHOOSER_BUTTON_H__



#include <gtk/gtkcombobox.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define GTK_TYPE_APP_CHOOSER_BUTTON()            (gtk_app_chooser_button_get_type ())
#define GTK_APP_CHOOSER_BUTTON(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_APP_CHOOSER_BUTTON, GtkAppChooserButton))
#define GTK_APP_CHOOSER_BUTTON_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_APP_CHOOSER_BUTTON, GtkAppChooserButtonClass))
#define GTK_IS_APP_CHOOSER_BUTTON(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_APP_CHOOSER_BUTTON))
#define GTK_IS_APP_CHOOSER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_APP_CHOOSER_BUTTON))
#define GTK_APP_CHOOSER_BUTTON_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_APP_CHOOSER_BUTTON, GtkAppChooserButtonClass))

typedef struct GtkAppChooserButtonPrivate{} GtkAppChooserButtonPrivate;

struct GtkAppChooserButton {
  GtkComboBox parent;

  /*< private >*/
  GtkAppChooserButtonPrivate *priv;
};

/**
 * GtkAppChooserButtonClass:
 * @parent_class: The parent class.
 * @custom_item_activated: Signal emitted when a custom item,
 *    previously added with gtk_app_chooser_button_append_custom_item(),
 *    is activated from the dropdown menu.
 */
struct GtkAppChooserButtonClass {
  GtkComboBoxClass parent_class;

  /*< public >*/

  void (* custom_item_activated) (GtkAppChooserButton *self,
                                  const char *item_name);

  /*< private >*/

  /* padding for future class expansion */
  gpointer padding[16];
};
struct GtkShortcutsWindow
{
  GtkWindow window;
};
struct GtkShortcutsWindowClass
{
  GtkWindowClass parent_class;

  void (*close)  (GtkShortcutsWindow *self);
  void (*search) (GtkShortcutsWindow *self);
};
typedef struct GtkApplicationWindowPrivate{} GtkApplicationWindowPrivate;

GDK_AVAILABLE_IN_ALL
GType       gtk_app_chooser_button_get_type           (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget * gtk_app_chooser_button_new                (const char         *content_type);

GDK_AVAILABLE_IN_ALL
void        gtk_app_chooser_button_append_separator   (GtkAppChooserButton *self);
GDK_AVAILABLE_IN_ALL
void        gtk_app_chooser_button_append_custom_item (GtkAppChooserButton *self,
                                                       const char         *name,
                                                       const char         *label,
                                                       GIcon               *icon);
GDK_AVAILABLE_IN_ALL
void     gtk_app_chooser_button_set_active_custom_item (GtkAppChooserButton *self,
                                                        const char         *name);

GDK_AVAILABLE_IN_ALL
void     gtk_app_chooser_button_set_show_dialog_item  (GtkAppChooserButton *self,
                                                       gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean gtk_app_chooser_button_get_show_dialog_item  (GtkAppChooserButton *self);
GDK_AVAILABLE_IN_ALL
void     gtk_app_chooser_button_set_heading           (GtkAppChooserButton *self,
                                                       const char         *heading);
GDK_AVAILABLE_IN_ALL
const char *
         gtk_app_chooser_button_get_heading           (GtkAppChooserButton *self);
GDK_AVAILABLE_IN_3_2
void     gtk_app_chooser_button_set_show_default_item (GtkAppChooserButton *self,
                                                       gboolean             setting);
GDK_AVAILABLE_IN_3_2
gboolean gtk_app_chooser_button_get_show_default_item (GtkAppChooserButton *self);

G_END_DECLS

#endif /* __GTK_APP_CHOOSER_BUTTON_H__ */
#define headerfilename "gtk/./gtkshortcutswindow.h"
/* file: gtk/./gtkshortcutswindow.h */
/* gtkshortcutswindow.h
 *
 * Copyright (C) 2015 Christian Hergert <christian@hergert.me>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License as
 *  published by the Free Software Foundation; either version 2 of the
 *  License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_SHORTCUTS_WINDOW_H__
#define __GTK_SHORTCUTS_WINDOW_H__

#include <gtk/gtkwindow.h>

G_BEGIN_DECLS

#define GTK_TYPE_SHORTCUTS_WINDOW()            (gtk_shortcuts_window_get_type ())
#define GTK_SHORTCUTS_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_SHORTCUTS_WINDOW, GtkShortcutsWindow))
#define GTK_SHORTCUTS_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_SHORTCUTS_WINDOW, GtkShortcutsWindowClass))
#define GTK_IS_SHORTCUTS_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_SHORTCUTS_WINDOW))
#define GTK_IS_SHORTCUTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SHORTCUTS_WINDOW))
#define GTK_SHORTCUTS_WINDOW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_SHORTCUTS_WINDOW, GtkShortcutsWindowClass))





struct GtkApplicationWindow
{
  GtkWindow parent_instance;

  /*< private >*/
  GtkApplicationWindowPrivate *priv;
};
struct GtkApplicationWindowClass
{
  GtkWindowClass parent_class;

  /*< private >*/
  gpointer padding[14];
};

GDK_AVAILABLE_IN_3_20
GType gtk_shortcuts_window_get_type (void) G_GNUC_CONST;

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkShortcutsWindow, g_object_unref)

G_END_DECLS

#endif /* GTK_SHORTCUTS_WINDOW _H */
#define headerfilename "gtk/./gtkapplicationwindow.h"
/* file: gtk/./gtkapplicationwindow.h */
/*
 * Copyright © 2011 Canonical Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#ifndef __GTK_APPLICATION_WINDOW_H__
#define __GTK_APPLICATION_WINDOW_H__



#include <gtk/gtkwindow.h>
#include <gtk/gtkshortcutswindow.h>

G_BEGIN_DECLS

#define GTK_TYPE_APPLICATION_WINDOW()            (gtk_application_window_get_type ())
#define GTK_APPLICATION_WINDOW(inst)           (G_TYPE_CHECK_INSTANCE_CAST ((inst), \
                                                GTK_TYPE_APPLICATION_WINDOW, GtkApplicationWindow))
#define GTK_APPLICATION_WINDOW_CLASS(class)    (G_TYPE_CHECK_CLASS_CAST ((class),   \
                                                GTK_TYPE_APPLICATION_WINDOW, GtkApplicationWindowClass))
#define GTK_IS_APPLICATION_WINDOW(inst)        (G_TYPE_CHECK_INSTANCE_TYPE ((inst), \
                                                GTK_TYPE_APPLICATION_WINDOW))
#define GTK_IS_APPLICATION_WINDOW_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class),   \
                                                GTK_TYPE_APPLICATION_WINDOW))
#define GTK_APPLICATION_WINDOW_GET_CLASS(inst) (G_TYPE_INSTANCE_GET_CLASS ((inst),  \
                                                GTK_TYPE_APPLICATION_WINDOW, GtkApplicationWindowClass))

typedef struct GtkFramePrivate{} GtkFramePrivate;


/**
 * GtkApplicationWindowClass:
 * @parent_class: The parent class.
 */
struct GtkFrame
{
  GtkBin bin;

  /*< private >*/
  GtkFramePrivate *priv;
};
struct GtkFrameClass
{
  GtkBinClass parent_class;

  /*< public >*/

  void (*compute_child_allocation) (GtkFrame *frame,
                                    GtkAllocation *allocation);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_4
GType       gtk_application_window_get_type          (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_4
GtkWidget * gtk_application_window_new               (GtkApplication      *application);

GDK_AVAILABLE_IN_3_4
void        gtk_application_window_set_show_menubar (GtkApplicationWindow *window,
                                                     gboolean              show_menubar);
GDK_AVAILABLE_IN_3_4
gboolean    gtk_application_window_get_show_menubar (GtkApplicationWindow *window);

GDK_AVAILABLE_IN_3_6
guint       gtk_application_window_get_id           (GtkApplicationWindow *window);

GDK_AVAILABLE_IN_3_20
void        gtk_application_window_set_help_overlay (GtkApplicationWindow *window,
                                                     GtkShortcutsWindow   *help_overlay);
GDK_AVAILABLE_IN_3_20
GtkShortcutsWindow *
            gtk_application_window_get_help_overlay (GtkApplicationWindow *window);

G_END_DECLS

#endif /* __GTK_APPLICATION_WINDOW_H__ */
#define headerfilename "gtk/./gtkframe.h"
/* file: gtk/./gtkframe.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_FRAME_H__
#define __GTK_FRAME_H__




#include <gtk/gtkbin.h>


G_BEGIN_DECLS


#define GTK_TYPE_FRAME()                  (gtk_frame_get_type ())
#define GTK_FRAME(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FRAME, GtkFrame))
#define GTK_FRAME_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FRAME, GtkFrameClass))
#define GTK_IS_FRAME(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FRAME))
#define GTK_IS_FRAME_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FRAME))
#define GTK_FRAME_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FRAME, GtkFrameClass))

typedef struct GtkAspectFramePrivate{} GtkAspectFramePrivate;


/**
 * GtkFrameClass:
 * @parent_class: The parent class.
 * @compute_child_allocation:
 */
struct GtkAspectFrame
{
  GtkFrame frame;

  /*< private >*/
  GtkAspectFramePrivate *priv;
};
struct GtkAspectFrameClass
{
  GtkFrameClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType      gtk_frame_get_type         (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_frame_new              (const char   *label);

GDK_AVAILABLE_IN_ALL
void          gtk_frame_set_label (GtkFrame    *frame,
                                   const char *label);
GDK_AVAILABLE_IN_ALL
const char * gtk_frame_get_label (GtkFrame    *frame);

GDK_AVAILABLE_IN_ALL
void       gtk_frame_set_label_widget (GtkFrame      *frame,
				       GtkWidget     *label_widget);
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_frame_get_label_widget (GtkFrame      *frame);
GDK_AVAILABLE_IN_ALL
void       gtk_frame_set_label_align  (GtkFrame      *frame,
				       gfloat         xalign,
				       gfloat         yalign);
GDK_AVAILABLE_IN_ALL
void       gtk_frame_get_label_align  (GtkFrame      *frame,
				       gfloat        *xalign,
				       gfloat        *yalign);
GDK_AVAILABLE_IN_ALL
void       gtk_frame_set_shadow_type  (GtkFrame      *frame,
				       GtkShadowType  type);
GDK_AVAILABLE_IN_ALL
GtkShadowType gtk_frame_get_shadow_type (GtkFrame    *frame);


G_END_DECLS


#endif /* __GTK_FRAME_H__ */
#define headerfilename "gtk/./gtkaspectframe.h"
/* file: gtk/./gtkaspectframe.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2001.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_ASPECT_FRAME_H__
#define __GTK_ASPECT_FRAME_H__




#include <gtk/gtkframe.h>


G_BEGIN_DECLS

#define GTK_TYPE_ASPECT_FRAME()            (gtk_aspect_frame_get_type ())
#define GTK_ASPECT_FRAME(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ASPECT_FRAME, GtkAspectFrame))
#define GTK_ASPECT_FRAME_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ASPECT_FRAME, GtkAspectFrameClass))
#define GTK_IS_ASPECT_FRAME(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ASPECT_FRAME))
#define GTK_IS_ASPECT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ASPECT_FRAME))
#define GTK_ASPECT_FRAME_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ASPECT_FRAME, GtkAspectFrameClass))

typedef struct GtkAssistantPrivate{} GtkAssistantPrivate;


/**
 * GtkAspectFrameClass:
 * @parent_class: The parent class.
 */
struct GtkAssistant
{
  GtkWindow  parent;

  /*< private >*/
  GtkAssistantPrivate *priv;
};
struct GtkAssistantClass
{
  GtkWindowClass parent_class;

  /*< public >*/

  void (* prepare) (GtkAssistant *assistant, GtkWidget *page);
  void (* apply)   (GtkAssistant *assistant);
  void (* close)   (GtkAssistant *assistant);
  void (* cancel)  (GtkAssistant *assistant);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
};


GDK_AVAILABLE_IN_ALL
GType      gtk_aspect_frame_get_type   (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_aspect_frame_new        (const char     *label,
					gfloat           xalign,
					gfloat           yalign,
					gfloat           ratio,
					gboolean         obey_child);
GDK_AVAILABLE_IN_ALL
void       gtk_aspect_frame_set        (GtkAspectFrame  *aspect_frame,
					gfloat           xalign,
					gfloat           yalign,
					gfloat           ratio,
					gboolean         obey_child);


G_END_DECLS

#endif /* __GTK_ASPECT_FRAME_H__ */
#define headerfilename "gtk/./gtkassistant.h"
/* file: gtk/./gtkassistant.h */
/* 
 * GTK - The GIMP Toolkit
 * Copyright (C) 1999  Red Hat, Inc.
 * Copyright (C) 2002  Anders Carlsson <andersca@gnu.org>
 * Copyright (C) 2003  Matthias Clasen <mclasen@redhat.com>
 * Copyright (C) 2005  Carlos Garnacho Parro <carlosg@gnome.org>
 *
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_ASSISTANT_H__
#define __GTK_ASSISTANT_H__



#include <gtk/gtkwindow.h>

G_BEGIN_DECLS

#define GTK_TYPE_ASSISTANT()         (gtk_assistant_get_type ())
#define GTK_ASSISTANT(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_ASSISTANT, GtkAssistant))
#define GTK_ASSISTANT_CLASS(c)     (G_TYPE_CHECK_CLASS_CAST    ((c), GTK_TYPE_ASSISTANT, GtkAssistantClass))
#define GTK_IS_ASSISTANT(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_ASSISTANT))
#define GTK_IS_ASSISTANT_CLASS(c)  (G_TYPE_CHECK_CLASS_TYPE    ((c), GTK_TYPE_ASSISTANT))
#define GTK_ASSISTANT_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS  ((o), GTK_TYPE_ASSISTANT, GtkAssistantClass))

/**
 * GtkAssistantPageType:
 * @GTK_ASSISTANT_PAGE_CONTENT: The page has regular contents. Both the
 *  Back and forward buttons will be shown.
 * @GTK_ASSISTANT_PAGE_INTRO: The page contains an introduction to the
 *  assistant task. Only the Forward button will be shown if there is a
 *   next page.
 * @GTK_ASSISTANT_PAGE_CONFIRM: The page lets the user confirm or deny the
 *  changes. The Back and Apply buttons will be shown.
 * @GTK_ASSISTANT_PAGE_SUMMARY: The page informs the user of the changes
 *  done. Only the Close button will be shown.
 * @GTK_ASSISTANT_PAGE_PROGRESS: Used for tasks that take a long time to
 *  complete, blocks the assistant until the page is marked as complete.
 *   Only the back button will be shown.
 * @GTK_ASSISTANT_PAGE_CUSTOM: Used for when other page types are not
 *  appropriate. No buttons will be shown, and the application must
 *  add its own buttons through gtk_assistant_add_action_widget().
 *
 * An enum for determining the page role inside the #GtkAssistant. It's
 * used to handle buttons sensitivity and visibility.
 *
 * Note that an assistant needs to end its page flow with a page of type
 * %GTK_ASSISTANT_PAGE_CONFIRM, %GTK_ASSISTANT_PAGE_SUMMARY or
 * %GTK_ASSISTANT_PAGE_PROGRESS to be correct.
 *
 * The Cancel button will only be shown if the page isn’t “committed”.
 * See gtk_assistant_commit() for details.
 */
typedef enum
{
  GTK_ASSISTANT_PAGE_CONTENT,
  GTK_ASSISTANT_PAGE_INTRO,
  GTK_ASSISTANT_PAGE_CONFIRM,
  GTK_ASSISTANT_PAGE_SUMMARY,
  GTK_ASSISTANT_PAGE_PROGRESS,
  GTK_ASSISTANT_PAGE_CUSTOM
} GtkAssistantPageType;

typedef struct GtkButtonBoxPrivate{} GtkButtonBoxPrivate;


/**
 * GtkAssistantClass:
 * @parent_class: The parent class.
 * @prepare: Signal emitted when a new page is set as the assistant’s current page, before making the new page visible.
 * @apply: Signal emitted when the apply button is clicked.
 * @close: Signal emitted either when the close button or last page apply button is clicked.
 * @cancel: Signal emitted when the cancel button is clicked.
 */
struct GtkButtonBox
{
  GtkBox box;

  /*< private >*/
  GtkButtonBoxPrivate *priv;
};
struct GtkButtonBoxClass
{
  GtkBoxClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

/**
 * GtkAssistantPageFunc:
 * @current_page: The page number used to calculate the next page.
 * @data: (closure): user data.
 *
 * A function used by gtk_assistant_set_forward_page_func() to know which
 * is the next page given a current one. It’s called both for computing the
 * next page when the user presses the “forward” button and for handling
 * the behavior of the “last” button.
 *
 * Returns: The next page number.
 */
typedef gint (*GtkAssistantPageFunc) (gint current_page, gpointer data);

GDK_AVAILABLE_IN_ALL
GType                 gtk_assistant_get_type              (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget            *gtk_assistant_new                   (void);
GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_next_page             (GtkAssistant         *assistant);
GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_previous_page         (GtkAssistant         *assistant);
GDK_AVAILABLE_IN_ALL
gint                  gtk_assistant_get_current_page      (GtkAssistant         *assistant);
GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_set_current_page      (GtkAssistant         *assistant,
                                                           gint                  page_num);
GDK_AVAILABLE_IN_ALL
gint                  gtk_assistant_get_n_pages           (GtkAssistant         *assistant);
GDK_AVAILABLE_IN_ALL
GtkWidget            *gtk_assistant_get_nth_page          (GtkAssistant         *assistant,
                                                           gint                  page_num);
GDK_AVAILABLE_IN_ALL
gint                  gtk_assistant_prepend_page          (GtkAssistant         *assistant,
                                                           GtkWidget            *page);
GDK_AVAILABLE_IN_ALL
gint                  gtk_assistant_append_page           (GtkAssistant         *assistant,
                                                           GtkWidget            *page);
GDK_AVAILABLE_IN_ALL
gint                  gtk_assistant_insert_page           (GtkAssistant         *assistant,
                                                           GtkWidget            *page,
                                                           gint                  position);
GDK_AVAILABLE_IN_3_2
void                  gtk_assistant_remove_page           (GtkAssistant         *assistant,
                                                           gint                  page_num);
GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_set_forward_page_func (GtkAssistant         *assistant,
                                                           GtkAssistantPageFunc  page_func,
                                                           gpointer              data,
                                                           GDestroyNotify        destroy);
GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_set_page_type         (GtkAssistant         *assistant,
                                                           GtkWidget            *page,
                                                           GtkAssistantPageType  type);
GDK_AVAILABLE_IN_ALL
GtkAssistantPageType  gtk_assistant_get_page_type         (GtkAssistant         *assistant,
                                                           GtkWidget            *page);
GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_set_page_title        (GtkAssistant         *assistant,
                                                           GtkWidget            *page,
                                                           const char          *title);
GDK_AVAILABLE_IN_ALL
const char *         gtk_assistant_get_page_title        (GtkAssistant         *assistant,
                                                           GtkWidget            *page);

GDK_DEPRECATED_IN_3_2
void                  gtk_assistant_set_page_header_image (GtkAssistant         *assistant,
                                                           GtkWidget            *page,
                                                           GdkPixbuf            *pixbuf);
GDK_DEPRECATED_IN_3_2
GdkPixbuf            *gtk_assistant_get_page_header_image (GtkAssistant         *assistant,
                                                           GtkWidget            *page);
GDK_DEPRECATED_IN_3_2
void                  gtk_assistant_set_page_side_image   (GtkAssistant         *assistant,
                                                           GtkWidget            *page,
                                                           GdkPixbuf            *pixbuf);
GDK_DEPRECATED_IN_3_2
GdkPixbuf            *gtk_assistant_get_page_side_image   (GtkAssistant         *assistant,
                                                           GtkWidget            *page);

GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_set_page_complete     (GtkAssistant         *assistant,
                                                           GtkWidget            *page,
                                                           gboolean              complete);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_assistant_get_page_complete     (GtkAssistant         *assistant,
                                                           GtkWidget            *page);
GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_add_action_widget     (GtkAssistant         *assistant,
                                                           GtkWidget            *child);
GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_remove_action_widget  (GtkAssistant         *assistant,
                                                           GtkWidget            *child);

GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_update_buttons_state  (GtkAssistant *assistant);
GDK_AVAILABLE_IN_ALL
void                  gtk_assistant_commit                (GtkAssistant *assistant);

GDK_AVAILABLE_IN_3_18
void                  gtk_assistant_set_page_has_padding  (GtkAssistant *assistant,
                                                           GtkWidget    *page,
                                                           gboolean      has_padding);
GDK_AVAILABLE_IN_3_18
gboolean              gtk_assistant_get_page_has_padding  (GtkAssistant *assistant,
                                                           GtkWidget    *page);

G_END_DECLS

#endif /* __GTK_ASSISTANT_H__ */
#define headerfilename "gtk/./gtkbbox.h"
/* file: gtk/./gtkbbox.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_BUTTON_BOX_H__
#define __GTK_BUTTON_BOX_H__



#include <gtk/gtkbox.h>


G_BEGIN_DECLS  

#define GTK_TYPE_BUTTON_BOX()             (gtk_button_box_get_type ())
#define GTK_BUTTON_BOX(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_BUTTON_BOX, GtkButtonBox))
#define GTK_BUTTON_BOX_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_BUTTON_BOX, GtkButtonBoxClass))
#define GTK_IS_BUTTON_BOX(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_BUTTON_BOX))
#define GTK_IS_BUTTON_BOX_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_BUTTON_BOX))
#define GTK_BUTTON_BOX_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_BUTTON_BOX, GtkButtonBoxClass))




/**
 * GtkButtonBoxClass:
 * @parent_class: The parent class.
 */


/**
 * GtkButtonBoxStyle:
 * @GTK_BUTTONBOX_SPREAD: Buttons are evenly spread across the box.
 * @GTK_BUTTONBOX_EDGE: Buttons are placed at the edges of the box.
 * @GTK_BUTTONBOX_START: Buttons are grouped towards the start of the box,
 *   (on the left for a HBox, or the top for a VBox).
 * @GTK_BUTTONBOX_END: Buttons are grouped towards the end of the box,
 *   (on the right for a HBox, or the bottom for a VBox).
 * @GTK_BUTTONBOX_CENTER: Buttons are centered in the box. Since 2.12.
 * @GTK_BUTTONBOX_EXPAND: Buttons expand to fill the box. This entails giving
 *   buttons a "linked" appearance, making button sizes homogeneous, and
 *   setting spacing to 0 (same as calling gtk_box_set_homogeneous() and
 *   gtk_box_set_spacing() manually). Since 3.12.
 *
 * Used to dictate the style that a #GtkButtonBox uses to layout the buttons it
 * contains.
 */
typedef enum
{
  GTK_BUTTONBOX_SPREAD = 1,
  GTK_BUTTONBOX_EDGE,
  GTK_BUTTONBOX_START,
  GTK_BUTTONBOX_END,
  GTK_BUTTONBOX_CENTER,
  GTK_BUTTONBOX_EXPAND
} GtkButtonBoxStyle;
struct GtkBindingSet
{
  char           *set_name;
  gint             priority;
  GSList          *widget_path_pspecs;
  GSList          *widget_class_pspecs;
  GSList          *class_branch_pspecs;
  GtkBindingEntry *entries;
  GtkBindingEntry *current;
  guint            parsed : 1;
};
struct GtkBindingSignal
{
  GtkBindingSignal *next;
  char            *signal_name;
  guint             n_args;
  GtkBindingArg    *args;
};
struct GtkBindingEntry
{
  /* key portion */
  guint             keyval;
  GdkModifierType   modifiers;

  GtkBindingSet    *binding_set;
  guint             destroyed     : 1;
  guint             in_emission   : 1;
  guint             marks_unbound : 1;
  GtkBindingEntry  *set_next;
  GtkBindingEntry  *hash_next;
  GtkBindingSignal *signals;
};
struct GtkBindingArg
{
  GType      arg_type;
  union {
    glong    long_data;
    gdouble  double_data;
    char   *string_data;
  } d;
};


GDK_AVAILABLE_IN_ALL
GType             gtk_button_box_get_type            (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget       * gtk_button_box_new                 (GtkOrientation     orientation);
GDK_AVAILABLE_IN_ALL
GtkButtonBoxStyle gtk_button_box_get_layout          (GtkButtonBox      *widget);
GDK_AVAILABLE_IN_ALL
void              gtk_button_box_set_layout          (GtkButtonBox      *widget,
                                                      GtkButtonBoxStyle  layout_style);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_button_box_get_child_secondary (GtkButtonBox      *widget,
                                                      GtkWidget         *child);
GDK_AVAILABLE_IN_ALL
void              gtk_button_box_set_child_secondary (GtkButtonBox      *widget,
                                                      GtkWidget         *child,
                                                      gboolean           is_secondary);
GDK_AVAILABLE_IN_3_2
gboolean          gtk_button_box_get_child_non_homogeneous (GtkButtonBox *widget,
                                                            GtkWidget    *child);
GDK_AVAILABLE_IN_3_2
void              gtk_button_box_set_child_non_homogeneous (GtkButtonBox *widget,
                                                            GtkWidget    *child,
                                                            gboolean      non_homogeneous);


G_END_DECLS

#endif /* __GTK_BUTTON_BOX_H__ */
#define headerfilename "gtk/./gtkbindings.h"
/* file: gtk/./gtkbindings.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * GtkBindingSet: Keybinding manager for GObjects.
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_BINDINGS_H__
#define __GTK_BINDINGS_H__




#include <gdk/gdk.h>
#include <gtk/gtkenums.h>

G_BEGIN_DECLS


/**
 * GtkBindingSet:
 * @set_name: unique name of this binding set
 * @priority: unused
 * @widget_path_pspecs: unused
 * @widget_class_pspecs: unused
 * @class_branch_pspecs: unused
 * @entries: the key binding entries in this binding set
 * @current: implementation detail
 * @parsed: whether this binding set stems from a CSS file and is reset upon theme changes
 *
 * A binding set maintains a list of activatable key bindings.
 * A single binding set can match multiple types of widgets.
 * Similar to style contexts, can be matched by any information contained
 * in a widgets #GtkWidgetPath. When a binding within a set is matched upon
 * activation, an action signal is emitted on the target widget to carry out
 * the actual activation.
 */

/**
 * GtkBindingEntry:
 * @keyval: key value to match
 * @modifiers: key modifiers to match
 * @binding_set: binding set this entry belongs to
 * @destroyed: implementation detail
 * @in_emission: implementation detail
 * @marks_unbound: implementation detail
 * @set_next: linked list of entries maintained by binding set
 * @hash_next: implementation detail
 * @signals: action signals of this entry
 *
 * Each key binding element of a binding sets binding list is
 * represented by a GtkBindingEntry.
 */

/**
 * GtkBindingArg:
 * @arg_type: implementation detail
 *
 * A #GtkBindingArg holds the data associated with
 * an argument for a key binding signal emission as
 * stored in #GtkBindingSignal.
 */

/**
 * GtkBindingSignal:
 * @next: implementation detail
 * @signal_name: the action signal to be emitted
 * @n_args: number of arguments specified for the signal
 * @args: (array length=n_args): the arguments specified for the signal
 *
 * A GtkBindingSignal stores the necessary information to
 * activate a widget in response to a key press via a signal
 * emission.
 */
struct GtkBuilderClass
{
  GObjectClass parent_class;
  
  GType (* get_type_from_name) (GtkBuilder *builder,
                                const char *type_name);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};

GDK_AVAILABLE_IN_ALL
GtkBindingSet *gtk_binding_set_new           (const char         *set_name);
GDK_AVAILABLE_IN_ALL
GtkBindingSet *gtk_binding_set_by_class      (gpointer             object_class);
GDK_AVAILABLE_IN_ALL
GtkBindingSet *gtk_binding_set_find          (const char         *set_name);

GDK_AVAILABLE_IN_ALL
gboolean       gtk_bindings_activate         (GObject             *object,
                                              guint                keyval,
                                              GdkModifierType      modifiers);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_bindings_activate_event   (GObject             *object,
                                              GdkEventKey         *event);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_binding_set_activate      (GtkBindingSet       *binding_set,
                                              guint                keyval,
                                              GdkModifierType      modifiers,
                                              GObject             *object);

GDK_AVAILABLE_IN_ALL
void           gtk_binding_entry_skip        (GtkBindingSet       *binding_set,
                                              guint                keyval,
                                              GdkModifierType      modifiers);
GDK_AVAILABLE_IN_ALL
void           gtk_binding_entry_add_signal  (GtkBindingSet       *binding_set,
                                              guint                keyval,
                                              GdkModifierType      modifiers,
                                              const char         *signal_name,
                                              guint                n_args,
                                              ...);
GDK_AVAILABLE_IN_ALL
void           gtk_binding_entry_add_signall (GtkBindingSet       *binding_set,
                                              guint                keyval,
                                              GdkModifierType      modifiers,
                                              const char         *signal_name,
                                              GSList              *binding_args);

GDK_AVAILABLE_IN_ALL
GTokenType     gtk_binding_entry_add_signal_from_string
                                             (GtkBindingSet       *binding_set,
                                              const char         *signal_desc);

GDK_AVAILABLE_IN_ALL
void           gtk_binding_entry_remove      (GtkBindingSet       *binding_set,
                                              guint                keyval,
                                              GdkModifierType      modifiers);

G_END_DECLS

#endif /* __GTK_BINDINGS_H__ */
#define headerfilename "gtk/./gtkbuilder.h"
/* file: gtk/./gtkbuilder.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2006-2007 Async Open Source,
 *                         Johan Dahlin <jdahlin@async.com.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_BUILDER_H__
#define __GTK_BUILDER_H__



#include <gtk/gtkapplication.h>
#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_BUILDER()                 (gtk_builder_get_type ())
#define GTK_BUILDER(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_BUILDER, GtkBuilder))
#define GTK_BUILDER_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_BUILDER, GtkBuilderClass))
#define GTK_IS_BUILDER(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_BUILDER))
#define GTK_IS_BUILDER_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_BUILDER))
#define GTK_BUILDER_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_BUILDER, GtkBuilderClass))

#define GTK_BUILDER_ERROR()                (gtk_builder_error_quark ())


/**
 * GtkBuilderError:
 * @GTK_BUILDER_ERROR_INVALID_TYPE_FUNCTION: A type-func attribute didn’t name
 *  a function that returns a #GType.
 * @GTK_BUILDER_ERROR_UNHANDLED_TAG: The input contained a tag that #GtkBuilder
 *  can’t handle.
 * @GTK_BUILDER_ERROR_MISSING_ATTRIBUTE: An attribute that is required by
 *  #GtkBuilder was missing.
 * @GTK_BUILDER_ERROR_INVALID_ATTRIBUTE: #GtkBuilder found an attribute that
 *  it doesn’t understand.
 * @GTK_BUILDER_ERROR_INVALID_TAG: #GtkBuilder found a tag that
 *  it doesn’t understand.
 * @GTK_BUILDER_ERROR_MISSING_PROPERTY_VALUE: A required property value was
 *  missing.
 * @GTK_BUILDER_ERROR_INVALID_VALUE: #GtkBuilder couldn’t parse
 *  some attribute value.
 * @GTK_BUILDER_ERROR_VERSION_MISMATCH: The input file requires a newer version
 *  of GTK+.
 * @GTK_BUILDER_ERROR_DUPLICATE_ID: An object id occurred twice.
 * @GTK_BUILDER_ERROR_OBJECT_TYPE_REFUSED: A specified object type is of the same type or
 *  derived from the type of the composite class being extended with builder XML.
 * @GTK_BUILDER_ERROR_TEMPLATE_MISMATCH: The wrong type was specified in a composite class’s template XML
 * @GTK_BUILDER_ERROR_INVALID_PROPERTY: The specified property is unknown for the object class.
 * @GTK_BUILDER_ERROR_INVALID_SIGNAL: The specified signal is unknown for the object class.
 * @GTK_BUILDER_ERROR_INVALID_ID: An object id is unknown
 *
 * Error codes that identify various errors that can occur while using
 * #GtkBuilder.
 */
typedef enum
{
  GTK_BUILDER_ERROR_INVALID_TYPE_FUNCTION,
  GTK_BUILDER_ERROR_UNHANDLED_TAG,
  GTK_BUILDER_ERROR_MISSING_ATTRIBUTE,
  GTK_BUILDER_ERROR_INVALID_ATTRIBUTE,
  GTK_BUILDER_ERROR_INVALID_TAG,
  GTK_BUILDER_ERROR_MISSING_PROPERTY_VALUE,
  GTK_BUILDER_ERROR_INVALID_VALUE,
  GTK_BUILDER_ERROR_VERSION_MISMATCH,
  GTK_BUILDER_ERROR_DUPLICATE_ID,
  GTK_BUILDER_ERROR_OBJECT_TYPE_REFUSED,
  GTK_BUILDER_ERROR_TEMPLATE_MISMATCH,
  GTK_BUILDER_ERROR_INVALID_PROPERTY,
  GTK_BUILDER_ERROR_INVALID_SIGNAL,
  GTK_BUILDER_ERROR_INVALID_ID
} GtkBuilderError;
typedef struct _GtkBuildable{} GtkBuildable; /* Dummy typedef */

GDK_AVAILABLE_IN_ALL
GQuark gtk_builder_error_quark (void);


struct GtkBuildableIface
{
  GTypeInterface g_iface;

  /* virtual table */
  void          (* set_name)               (GtkBuildable  *buildable,
                                            const char   *name);
  const char * (* get_name)               (GtkBuildable  *buildable);
  void          (* add_child)              (GtkBuildable  *buildable,
					    GtkBuilder    *builder,
					    GObject       *child,
					    const char   *type);
  void          (* set_buildable_property) (GtkBuildable  *buildable,
					    GtkBuilder    *builder,
					    const char   *name,
					    const GValue  *value);
  GObject *     (* construct_child)        (GtkBuildable  *buildable,
					    GtkBuilder    *builder,
					    const char   *name);
  gboolean      (* custom_tag_start)       (GtkBuildable  *buildable,
					    GtkBuilder    *builder,
					    GObject       *child,
					    const char   *tagname,
					    GMarkupParser *parser,
					    gpointer      *data);
  void          (* custom_tag_end)         (GtkBuildable  *buildable,
					    GtkBuilder    *builder,
					    GObject       *child,
					    const char   *tagname,
					    gpointer      *data);
  void          (* custom_finished)        (GtkBuildable  *buildable,
					    GtkBuilder    *builder,
					    GObject       *child,
					    const char   *tagname,
					    gpointer       data);
  void          (* parser_finished)        (GtkBuildable  *buildable,
					    GtkBuilder    *builder);

  GObject *     (* get_internal_child)     (GtkBuildable  *buildable,
					    GtkBuilder    *builder,
					    const char   *childname);
};
typedef struct GtkButtonPrivate{} GtkButtonPrivate;

GDK_AVAILABLE_IN_ALL
GType        gtk_builder_get_type                (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkBuilder*  gtk_builder_new                     (void);

GDK_AVAILABLE_IN_ALL
guint        gtk_builder_add_from_file           (GtkBuilder    *builder,
                                                  const char   *filename,
                                                  GError       **error);
GDK_AVAILABLE_IN_ALL
guint        gtk_builder_add_from_resource       (GtkBuilder    *builder,
                                                  const char   *resource_path,
                                                  GError       **error);
GDK_AVAILABLE_IN_ALL
guint        gtk_builder_add_from_string         (GtkBuilder    *builder,
                                                  const char   *buffer,
                                                  gsize          length,
                                                  GError       **error);
GDK_AVAILABLE_IN_ALL
guint        gtk_builder_add_objects_from_file   (GtkBuilder    *builder,
                                                  const char   *filename,
                                                  char        **object_ids,
                                                  GError       **error);
GDK_AVAILABLE_IN_3_4
guint        gtk_builder_add_objects_from_resource(GtkBuilder    *builder,
                                                  const char   *resource_path,
                                                  char        **object_ids,
                                                  GError       **error);
GDK_AVAILABLE_IN_ALL
guint        gtk_builder_add_objects_from_string (GtkBuilder    *builder,
                                                  const char   *buffer,
                                                  gsize          length,
                                                  char        **object_ids,
                                                  GError       **error);
GDK_AVAILABLE_IN_ALL
GObject*     gtk_builder_get_object              (GtkBuilder    *builder,
                                                  const char   *name);
GDK_AVAILABLE_IN_ALL
GSList*      gtk_builder_get_objects             (GtkBuilder    *builder);
GDK_AVAILABLE_IN_3_8
void         gtk_builder_expose_object           (GtkBuilder    *builder,
                                                  const char   *name,
                                                  GObject       *object);
GDK_AVAILABLE_IN_ALL
void         gtk_builder_connect_signals         (GtkBuilder    *builder,
						  gpointer       user_data);
GDK_AVAILABLE_IN_ALL
void         gtk_builder_connect_signals_full    (GtkBuilder    *builder,
                                                  GtkBuilderConnectFunc func,
						  gpointer       user_data);
GDK_AVAILABLE_IN_ALL
void         gtk_builder_set_translation_domain  (GtkBuilder   	*builder,
                                                  const char  	*domain);
GDK_AVAILABLE_IN_ALL
const char* gtk_builder_get_translation_domain  (GtkBuilder   	*builder);
GDK_AVAILABLE_IN_ALL
GType        gtk_builder_get_type_from_name      (GtkBuilder   	*builder,
                                                  const char   	*type_name);

GDK_AVAILABLE_IN_ALL
gboolean     gtk_builder_value_from_string       (GtkBuilder    *builder,
						  GParamSpec   	*pspec,
                                                  const char  	*string,
                                                  GValue       	*value,
						  GError       **error);
GDK_AVAILABLE_IN_ALL
gboolean     gtk_builder_value_from_string_type  (GtkBuilder    *builder,
						  GType        	 type,
                                                  const char  	*string,
                                                  GValue       	*value,
						  GError       **error);
GDK_AVAILABLE_IN_3_10
GtkBuilder * gtk_builder_new_from_file           (const char   *filename);
GDK_AVAILABLE_IN_3_10
GtkBuilder * gtk_builder_new_from_resource       (const char   *resource_path);
GDK_AVAILABLE_IN_3_10
GtkBuilder * gtk_builder_new_from_string         (const char   *string,
                                                  gssize         length);

GDK_AVAILABLE_IN_3_10
void         gtk_builder_add_callback_symbol     (GtkBuilder    *builder,
						  const char   *callback_name,
						  GCallback      callback_symbol);
GDK_AVAILABLE_IN_3_10
void         gtk_builder_add_callback_symbols    (GtkBuilder    *builder,
						  const char   *first_callback_name,
						  GCallback      first_callback_symbol,
						  ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_3_10
GCallback    gtk_builder_lookup_callback_symbol  (GtkBuilder    *builder,
						  const char   *callback_name);

GDK_AVAILABLE_IN_3_12
void         gtk_builder_set_application         (GtkBuilder     *builder,
                                                  GtkApplication *application);

GDK_AVAILABLE_IN_3_12
GtkApplication * gtk_builder_get_application     (GtkBuilder     *builder);


/**
 * GTK_BUILDER_WARN_INVALID_CHILD_TYPE:
 * @object: the #GtkBuildable on which the warning ocurred
 * @type: the unexpected type value
 *
 * This macro should be used to emit a warning about and unexpected @type value
 * in a #GtkBuildable add_child implementation.
 */
#define GTK_BUILDER_WARN_INVALID_CHILD_TYPE(object, type) \
  g_warning ("'%s' is not a valid child type of '%s'", type, g_type_name (G_OBJECT_TYPE (object)))

GDK_AVAILABLE_IN_3_18
guint     gtk_builder_extend_with_template  (GtkBuilder    *builder,
                                             GtkWidget     *widget,
                                             GType          template_type,                                                          const char   *buffer,
                                             gsize          length,
                                             GError       **error);

G_END_DECLS

#endif /* __GTK_BUILDER_H__ */
#define headerfilename "gtk/./gtkbuildable.h"
/* file: gtk/./gtkbuildable.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2006-2007 Async Open Source,
 *                         Johan Dahlin <jdahlin@async.com.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_BUILDABLE_H__
#define __GTK_BUILDABLE_H__



#include <gtk/gtkbuilder.h>

G_BEGIN_DECLS

#define GTK_TYPE_BUILDABLE()            (gtk_buildable_get_type ())
#define GTK_BUILDABLE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_BUILDABLE, GtkBuildable))
#define GTK_BUILDABLE_CLASS(obj)      (G_TYPE_CHECK_CLASS_CAST ((obj), GTK_TYPE_BUILDABLE, GtkBuildableIface))
#define GTK_IS_BUILDABLE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_BUILDABLE))
#define GTK_BUILDABLE_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTK_TYPE_BUILDABLE, GtkBuildableIface))



/**
 * GtkBuildableIface:
 * @g_iface: the parent class
 * @set_name: Stores the name attribute given in the GtkBuilder UI definition.
 *  #GtkWidget stores the name as object data. Implement this method if your
 *  object has some notion of “name” and it makes sense to map the XML name
 *  attribute to it.
 * @get_name: The getter corresponding to @set_name. Implement this
 *  if you implement @set_name.
 * @add_child: Adds a child. The @type parameter can be used to
 *  differentiate the kind of child. #GtkContainer implements this
 *  to add add a child widget to the container, #GtkNotebook uses
 *  the @type to distinguish between page labels (of type "page-label")
 *  and normal children.
 * @set_buildable_property: Sets a property of a buildable object.
 *  It is normally not necessary to implement this, g_object_set_property()
 *  is used by default. #GtkWindow implements this to delay showing itself
 *  (i.e. setting the #GtkWidget:visible property) until the whole interface
 *  is created.
 * @construct_child: Constructs a child of a buildable that has been
 *  specified as “constructor” in the UI definition. #GtkUIManager implements
 *  this to reference to a widget created in a <ui> tag which is outside
 *  of the normal GtkBuilder UI definition hierarchy.  A reference to the
 *  constructed object is returned and becomes owned by the caller.
 * @custom_tag_start: Implement this if the buildable needs to parse
 *  content below <child>. To handle an element, the implementation
 *  must fill in the @parser and @user_data and return %TRUE.
 *  #GtkWidget implements this to parse keyboard accelerators specified
 *  in <accelerator> elements. #GtkContainer implements it to map
 *  properties defined via <packing> elements to child properties.
 *  Note that @user_data must be freed in @custom_tag_end or @custom_finished.
 * @custom_tag_end: Called for the end tag of each custom element that is
 *  handled by the buildable (see @custom_tag_start).
 * @custom_finished: Called for each custom tag handled by the buildable
 *  when the builder finishes parsing (see @custom_tag_start)
 * @parser_finished: Called when a builder finishes the parsing
 *  of a UI definition. It is normally not necessary to implement this,
 *  unless you need to perform special cleanup actions. #GtkWindow sets
 *  the #GtkWidget:visible property here.
 * @get_internal_child: Returns an internal child of a buildable.
 *  #GtkDialog implements this to give access to its @vbox, making
 *  it possible to add children to the vbox in a UI definition.
 *  Implement this if the buildable has internal children that may
 *  need to be accessed from a UI definition.
 *
 * The #GtkBuildableIface interface contains method that are
 * necessary to allow #GtkBuilder to construct an object from
 * a #GtkBuilder UI definition.
 */
struct GtkButton
{
  /*< private >*/
  GtkBin bin;

  GtkButtonPrivate *priv;
};
struct GtkButtonClass
{
  GtkBinClass        parent_class;

  /*< public >*/

  void (* pressed)  (GtkButton *button);
  void (* released) (GtkButton *button);
  void (* clicked)  (GtkButton *button);
  void (* enter)    (GtkButton *button);
  void (* leave)    (GtkButton *button);
  void (* activate) (GtkButton *button);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType     gtk_buildable_get_type               (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
void      gtk_buildable_set_name               (GtkBuildable        *buildable,
						const char         *name);
GDK_AVAILABLE_IN_ALL
const char * gtk_buildable_get_name           (GtkBuildable        *buildable);
GDK_AVAILABLE_IN_ALL
void      gtk_buildable_add_child              (GtkBuildable        *buildable,
						GtkBuilder          *builder,
						GObject             *child,
						const char         *type);
GDK_AVAILABLE_IN_ALL
void      gtk_buildable_set_buildable_property (GtkBuildable        *buildable,
						GtkBuilder          *builder,
						const char         *name,
						const GValue        *value);
GDK_AVAILABLE_IN_ALL
GObject * gtk_buildable_construct_child        (GtkBuildable        *buildable,
						GtkBuilder          *builder,
						const char         *name);
GDK_AVAILABLE_IN_ALL
gboolean  gtk_buildable_custom_tag_start       (GtkBuildable        *buildable,
						GtkBuilder          *builder,
						GObject             *child,
						const char         *tagname,
						GMarkupParser       *parser,
						gpointer            *data);
GDK_AVAILABLE_IN_ALL
void      gtk_buildable_custom_tag_end         (GtkBuildable        *buildable,
						GtkBuilder          *builder,
						GObject             *child,
						const char         *tagname,
						gpointer            *data);
GDK_AVAILABLE_IN_ALL
void      gtk_buildable_custom_finished        (GtkBuildable        *buildable,
						GtkBuilder          *builder,
						GObject             *child,
						const char         *tagname,
						gpointer             data);
GDK_AVAILABLE_IN_ALL
void      gtk_buildable_parser_finished        (GtkBuildable        *buildable,
						GtkBuilder          *builder);
GDK_AVAILABLE_IN_ALL
GObject * gtk_buildable_get_internal_child     (GtkBuildable        *buildable,
						GtkBuilder          *builder,
						const char         *childname);

G_END_DECLS

#endif /* __GTK_BUILDABLE_H__ */
#define headerfilename "gtk/./gtkbutton.h"
/* file: gtk/./gtkbutton.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2001.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_BUTTON_H__
#define __GTK_BUTTON_H__




#include <gtk/gtkbin.h>
#include <gtk/gtkimage.h>


G_BEGIN_DECLS

#define GTK_TYPE_BUTTON()                 (gtk_button_get_type ())
#define GTK_BUTTON(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_BUTTON, GtkButton))
#define GTK_BUTTON_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_BUTTON, GtkButtonClass))
#define GTK_IS_BUTTON(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_BUTTON))
#define GTK_IS_BUTTON_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_BUTTON))
#define GTK_BUTTON_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_BUTTON, GtkButtonClass))

typedef struct GtkCalendarPrivate{} GtkCalendarPrivate;


/**
 * GtkButtonClass:
 * @parent_class: The parent class.
 * @pressed: Signal emitted when the button is pressed. Deprecated: 2.8.
 * @released: Signal emitted when the button is released. Deprecated: 2.8.
 * @clicked: Signal emitted when the button has been activated (pressed and released).
 * @enter: Signal emitted when the pointer enters the button. Deprecated: 2.8.
 * @leave: Signal emitted when the pointer leaves the button. Deprecated: 2.8.
 * @activate: Signal that causes the button to animate press then
 *    release. Applications should never connect to this signal, but use
 *    the @clicked signal.
 */
struct GtkCalendar
{
  GtkWidget widget;

  GtkCalendarPrivate *priv;
};
struct GtkCalendarClass
{
  GtkWidgetClass parent_class;
  
  /* Signal handlers */
  void (* month_changed)		(GtkCalendar *calendar);
  void (* day_selected)			(GtkCalendar *calendar);
  void (* day_selected_double_click)	(GtkCalendar *calendar);
  void (* prev_month)			(GtkCalendar *calendar);
  void (* next_month)			(GtkCalendar *calendar);
  void (* prev_year)			(GtkCalendar *calendar);
  void (* next_year)			(GtkCalendar *calendar);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType          gtk_button_get_type          (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget*     gtk_button_new               (void);
GDK_AVAILABLE_IN_ALL
GtkWidget*     gtk_button_new_with_label    (const char    *label);
GDK_AVAILABLE_IN_3_10
GtkWidget*     gtk_button_new_from_icon_name (const char    *icon_name,
					      GtkIconSize     size);
GDK_DEPRECATED_IN_3_10_FOR(gtk_button_new_with_label)
GtkWidget*     gtk_button_new_from_stock    (const char    *stock_id);
GDK_AVAILABLE_IN_ALL
GtkWidget*     gtk_button_new_with_mnemonic (const char    *label);
GDK_AVAILABLE_IN_ALL
void           gtk_button_clicked           (GtkButton      *button);
GDK_DEPRECATED
void           gtk_button_pressed           (GtkButton      *button);
GDK_DEPRECATED
void           gtk_button_released          (GtkButton      *button);
GDK_DEPRECATED
void           gtk_button_enter             (GtkButton      *button);
GDK_DEPRECATED
void           gtk_button_leave             (GtkButton      *button);

GDK_AVAILABLE_IN_ALL
void                  gtk_button_set_relief         (GtkButton      *button,
						     GtkReliefStyle  relief);
GDK_AVAILABLE_IN_ALL
GtkReliefStyle        gtk_button_get_relief         (GtkButton      *button);
GDK_AVAILABLE_IN_ALL
void                  gtk_button_set_label          (GtkButton      *button,
						     const char    *label);
GDK_AVAILABLE_IN_ALL
const char *         gtk_button_get_label          (GtkButton      *button);
GDK_AVAILABLE_IN_ALL
void                  gtk_button_set_use_underline  (GtkButton      *button,
						     gboolean        use_underline);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_button_get_use_underline  (GtkButton      *button);
GDK_DEPRECATED_IN_3_10
void                  gtk_button_set_use_stock      (GtkButton      *button,
						     gboolean        use_stock);
GDK_DEPRECATED_IN_3_10
gboolean              gtk_button_get_use_stock      (GtkButton      *button);
GDK_DEPRECATED_IN_3_20_FOR(gtk_widget_set_focus_on_click)
void                  gtk_button_set_focus_on_click (GtkButton      *button,
						     gboolean        focus_on_click);
GDK_DEPRECATED_IN_3_20_FOR(gtk_widget_get_focus_on_click)
gboolean              gtk_button_get_focus_on_click (GtkButton      *button);
GDK_DEPRECATED_IN_3_14
void                  gtk_button_set_alignment      (GtkButton      *button,
						     gfloat          xalign,
						     gfloat          yalign);
GDK_DEPRECATED_IN_3_14
void                  gtk_button_get_alignment      (GtkButton      *button,
						     gfloat         *xalign,
						     gfloat         *yalign);
GDK_AVAILABLE_IN_ALL
void                  gtk_button_set_image          (GtkButton      *button,
					             GtkWidget      *image);
GDK_AVAILABLE_IN_ALL
GtkWidget*            gtk_button_get_image          (GtkButton      *button);
GDK_AVAILABLE_IN_ALL
void                  gtk_button_set_image_position (GtkButton      *button,
						     GtkPositionType position);
GDK_AVAILABLE_IN_ALL
GtkPositionType       gtk_button_get_image_position (GtkButton      *button);
GDK_AVAILABLE_IN_3_6
void                  gtk_button_set_always_show_image (GtkButton   *button,
                                                        gboolean     always_show);
GDK_AVAILABLE_IN_3_6
gboolean              gtk_button_get_always_show_image (GtkButton   *button);

GDK_AVAILABLE_IN_ALL
GdkWindow*            gtk_button_get_event_window   (GtkButton      *button);


G_END_DECLS

#endif /* __GTK_BUTTON_H__ */
#define headerfilename "gtk/./gtkcalendar.h"
/* file: gtk/./gtkcalendar.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * GTK Calendar Widget
 * Copyright (C) 1998 Cesar Miquel and Shawn T. Amundson
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_CALENDAR_H__
#define __GTK_CALENDAR_H__




#include <gtk/gtkwidget.h>


G_BEGIN_DECLS

#define GTK_TYPE_CALENDAR()                  (gtk_calendar_get_type ())
#define GTK_CALENDAR(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CALENDAR, GtkCalendar))
#define GTK_CALENDAR_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CALENDAR, GtkCalendarClass))
#define GTK_IS_CALENDAR(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CALENDAR))
#define GTK_IS_CALENDAR_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CALENDAR))
#define GTK_CALENDAR_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CALENDAR, GtkCalendarClass))




/**
 * GtkCalendarDisplayOptions:
 * @GTK_CALENDAR_SHOW_HEADING: Specifies that the month and year should be displayed.
 * @GTK_CALENDAR_SHOW_DAY_NAMES: Specifies that three letter day descriptions should be present.
 * @GTK_CALENDAR_NO_MONTH_CHANGE: Prevents the user from switching months with the calendar.
 * @GTK_CALENDAR_SHOW_WEEK_NUMBERS: Displays each week numbers of the current year, down the
 * left side of the calendar.
 * @GTK_CALENDAR_SHOW_DETAILS: Just show an indicator, not the full details
 * text when details are provided. See gtk_calendar_set_detail_func().
 *
 * These options can be used to influence the display and behaviour of a #GtkCalendar.
 */
typedef enum
{
  GTK_CALENDAR_SHOW_HEADING		= 1 << 0,
  GTK_CALENDAR_SHOW_DAY_NAMES		= 1 << 1,
  GTK_CALENDAR_NO_MONTH_CHANGE		= 1 << 2,
  GTK_CALENDAR_SHOW_WEEK_NUMBERS	= 1 << 3,
  GTK_CALENDAR_SHOW_DETAILS		= 1 << 5
} GtkCalendarDisplayOptions;
typedef struct GtkCellAreaBoxPrivate{} GtkCellAreaBoxPrivate;

/**
 * GtkCalendarDetailFunc:
 * @calendar: a #GtkCalendar.
 * @year: the year for which details are needed.
 * @month: the month for which details are needed.
 * @day: the day of @month for which details are needed.
 * @user_data: the data passed with gtk_calendar_set_detail_func().
 *
 * This kind of functions provide Pango markup with detail information for the
 * specified day. Examples for such details are holidays or appointments. The
 * function returns %NULL when no information is available.
 *
 * Since: 2.14
 *
 * Returns: (nullable) (transfer full): Newly allocated string with Pango markup
 *     with details for the specified day or %NULL.
 */
typedef char* (*GtkCalendarDetailFunc) (GtkCalendar *calendar,
                                         guint        year,
                                         guint        month,
                                         guint        day,
                                         gpointer     user_data);


struct GtkCellAreaBox
{
  /*< private >*/
  GtkCellArea parent_instance;

  GtkCellAreaBoxPrivate *priv;
};
struct GtkCellAreaBoxClass
{
  /*< private >*/
  GtkCellAreaClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType	   gtk_calendar_get_type	(void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_calendar_new		(void);

GDK_AVAILABLE_IN_ALL
void       gtk_calendar_select_month	(GtkCalendar *calendar,
					 guint	      month,
					 guint	      year);
GDK_AVAILABLE_IN_ALL
void	   gtk_calendar_select_day	(GtkCalendar *calendar,
					 guint	      day);

GDK_AVAILABLE_IN_ALL
void       gtk_calendar_mark_day	(GtkCalendar *calendar,
					 guint	      day);
GDK_AVAILABLE_IN_ALL
void       gtk_calendar_unmark_day	(GtkCalendar *calendar,
					 guint	      day);
GDK_AVAILABLE_IN_ALL
void	   gtk_calendar_clear_marks	(GtkCalendar *calendar);


GDK_AVAILABLE_IN_ALL
void	   gtk_calendar_set_display_options (GtkCalendar    	      *calendar,
					     GtkCalendarDisplayOptions flags);
GDK_AVAILABLE_IN_ALL
GtkCalendarDisplayOptions
           gtk_calendar_get_display_options (GtkCalendar   	      *calendar);
GDK_AVAILABLE_IN_ALL
void	   gtk_calendar_get_date	(GtkCalendar *calendar, 
					 guint	     *year,
					 guint	     *month,
					 guint	     *day);

GDK_AVAILABLE_IN_ALL
void       gtk_calendar_set_detail_func (GtkCalendar           *calendar,
                                         GtkCalendarDetailFunc  func,
                                         gpointer               data,
                                         GDestroyNotify         destroy);

GDK_AVAILABLE_IN_ALL
void       gtk_calendar_set_detail_width_chars (GtkCalendar    *calendar,
                                                gint            chars);
GDK_AVAILABLE_IN_ALL
void       gtk_calendar_set_detail_height_rows (GtkCalendar    *calendar,
                                                gint            rows);

GDK_AVAILABLE_IN_ALL
gint       gtk_calendar_get_detail_width_chars (GtkCalendar    *calendar);
GDK_AVAILABLE_IN_ALL
gint       gtk_calendar_get_detail_height_rows (GtkCalendar    *calendar);

GDK_AVAILABLE_IN_ALL
gboolean   gtk_calendar_get_day_is_marked      (GtkCalendar    *calendar,
                                                guint           day);

G_END_DECLS

#endif /* __GTK_CALENDAR_H__ */
#define headerfilename "gtk/./gtkcellareabox.h"
/* file: gtk/./gtkcellareabox.h */
/* gtkcellareabox.h
 *
 * Copyright (C) 2010 Openismus GmbH
 *
 * Authors:
 *      Tristan Van Berkom <tristanvb@openismus.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_AREA_BOX_H__
#define __GTK_CELL_AREA_BOX_H__



#include <gtk/gtkcellarea.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_AREA_BOX()            (gtk_cell_area_box_get_type ())
#define GTK_CELL_AREA_BOX(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_AREA_BOX, GtkCellAreaBox))
#define GTK_CELL_AREA_BOX_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_AREA_BOX, GtkCellAreaBoxClass))
#define GTK_IS_CELL_AREA_BOX(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_AREA_BOX))
#define GTK_IS_CELL_AREA_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_AREA_BOX))
#define GTK_CELL_AREA_BOX_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_AREA_BOX, GtkCellAreaBoxClass))



/**
 * GtkCellAreaBoxClass:
 */
struct GtkCellAreaContextClass
{
  /*< private >*/
  GObjectClass parent_class;

  /*< public >*/
  void    (* allocate)                       (GtkCellAreaContext *context,
                                              gint                width,
                                              gint                height);
  void    (* reset)                          (GtkCellAreaContext *context);
  void    (* get_preferred_height_for_width) (GtkCellAreaContext *context,
                                              gint                width,
                                              gint               *minimum_height,
                                              gint               *natural_height);
  void    (* get_preferred_width_for_height) (GtkCellAreaContext *context,
                                              gint                height,
                                              gint               *minimum_width,
                                              gint               *natural_width);

  /*< private >*/
  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
};

GDK_AVAILABLE_IN_ALL
GType        gtk_cell_area_box_get_type    (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkCellArea *gtk_cell_area_box_new         (void);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_box_pack_start  (GtkCellAreaBox  *box,
                                            GtkCellRenderer *renderer,
                                            gboolean         expand,
                                            gboolean         align,
                                            gboolean         fixed);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_box_pack_end    (GtkCellAreaBox  *box,
                                            GtkCellRenderer *renderer,
                                            gboolean         expand,
                                            gboolean         align,
                                            gboolean         fixed);
GDK_AVAILABLE_IN_ALL
gint         gtk_cell_area_box_get_spacing (GtkCellAreaBox  *box);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_box_set_spacing (GtkCellAreaBox  *box,
                                            gint             spacing);

/* Private interaction with GtkCellAreaBoxContext */
gboolean    _gtk_cell_area_box_group_visible (GtkCellAreaBox  *box,
                                              gint             group_idx);

G_END_DECLS

#endif /* __GTK_CELL_AREA_BOX_H__ */
#define headerfilename "gtk/./gtkcellareacontext.h"
/* file: gtk/./gtkcellareacontext.h */
/* gtkcellareacontext.h
 *
 * Copyright (C) 2010 Openismus GmbH
 *
 * Authors:
 *      Tristan Van Berkom <tristanvb@openismus.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_AREA_CONTEXT_H__
#define __GTK_CELL_AREA_CONTEXT_H__



#include <gtk/gtkcellarea.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_AREA_CONTEXT()            (gtk_cell_area_context_get_type ())
#define GTK_CELL_AREA_CONTEXT(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_AREA_CONTEXT, GtkCellAreaContext))
#define GTK_CELL_AREA_CONTEXT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_AREA_CONTEXT, GtkCellAreaContextClass))
#define GTK_IS_CELL_AREA_CONTEXT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_AREA_CONTEXT))
#define GTK_IS_CELL_AREA_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_AREA_CONTEXT))
#define GTK_CELL_AREA_CONTEXT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_AREA_CONTEXT, GtkCellAreaContextClass))

typedef struct _GtkCellLayout{} GtkCellLayout; /* dummy typedef */


/**
 * GtkCellAreaContextClass:
 * @allocate: This tells the context that an allocation width or height
 *     (or both) have been decided for a group of rows. The context should
 *     store any allocations for internally aligned cells at this point so
 *     that they dont need to be recalculated at gtk_cell_area_render() time.
 * @reset: Clear any previously stored information about requested and
 *     allocated sizes for the context.
 * @get_preferred_height_for_width: Returns the aligned height for the given
 *     width that context must store while collecting sizes for it’s rows.
 * @get_preferred_width_for_height: Returns the aligned width for the given
 *     height that context must store while collecting sizes for it’s rows.
 */
struct GtkCellLayoutIface
{
  /*< private >*/
  GTypeInterface g_iface;

  /*< public >*/

  /* Virtual Table */
  void (* pack_start)         (GtkCellLayout         *cell_layout,
                               GtkCellRenderer       *cell,
                               gboolean               expand);
  void (* pack_end)           (GtkCellLayout         *cell_layout,
                               GtkCellRenderer       *cell,
                               gboolean               expand);
  void (* clear)              (GtkCellLayout         *cell_layout);
  void (* add_attribute)      (GtkCellLayout         *cell_layout,
                               GtkCellRenderer       *cell,
                               const char           *attribute,
                               gint                   column);
  void (* set_cell_data_func) (GtkCellLayout         *cell_layout,
                               GtkCellRenderer       *cell,
                               GtkCellLayoutDataFunc  func,
                               gpointer               func_data,
                               GDestroyNotify         destroy);
  void (* clear_attributes)   (GtkCellLayout         *cell_layout,
                               GtkCellRenderer       *cell);
  void (* reorder)            (GtkCellLayout         *cell_layout,
                               GtkCellRenderer       *cell,
                               gint                   position);
  GList* (* get_cells)        (GtkCellLayout         *cell_layout);

  GtkCellArea *(* get_area)   (GtkCellLayout         *cell_layout);
};
typedef struct GtkCellRendererTextPrivate{} GtkCellRendererTextPrivate;

GDK_AVAILABLE_IN_ALL
GType        gtk_cell_area_context_get_type              (void) G_GNUC_CONST;

/* Main apis */
GDK_AVAILABLE_IN_ALL
GtkCellArea *gtk_cell_area_context_get_area                        (GtkCellAreaContext *context);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_context_allocate                        (GtkCellAreaContext *context,
                                                                    gint                width,
                                                                    gint                height);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_context_reset                           (GtkCellAreaContext *context);

/* Apis for GtkCellArea clients to consult cached values
 * for a series of GtkTreeModel rows
 */
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_context_get_preferred_width            (GtkCellAreaContext *context,
                                                                   gint               *minimum_width,
                                                                   gint               *natural_width);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_context_get_preferred_height           (GtkCellAreaContext *context,
                                                                   gint               *minimum_height,
                                                                   gint               *natural_height);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_context_get_preferred_height_for_width (GtkCellAreaContext *context,
                                                                   gint                width,
                                                                   gint               *minimum_height,
                                                                   gint               *natural_height);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_context_get_preferred_width_for_height (GtkCellAreaContext *context,
                                                                   gint                height,
                                                                   gint               *minimum_width,
                                                                   gint               *natural_width);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_context_get_allocation                 (GtkCellAreaContext *context,
                                                                   gint               *width,
                                                                   gint               *height);

/* Apis for GtkCellArea implementations to update cached values
 * for multiple GtkTreeModel rows
 */
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_context_push_preferred_width  (GtkCellAreaContext *context,
                                                          gint                minimum_width,
                                                          gint                natural_width);
GDK_AVAILABLE_IN_ALL
void         gtk_cell_area_context_push_preferred_height (GtkCellAreaContext *context,
                                                          gint                minimum_height,
                                                          gint                natural_height);

G_END_DECLS

#endif /* __GTK_CELL_AREA_CONTEXT_H__ */
#define headerfilename "gtk/./gtkcelllayout.h"
/* file: gtk/./gtkcelllayout.h */
/* gtkcelllayout.h
 * Copyright (C) 2003  Kristian Rietveld  <kris@gtk.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_LAYOUT_H__
#define __GTK_CELL_LAYOUT_H__



#include <gtk/gtkcellrenderer.h>
#include <gtk/gtkcellarea.h>
#include <gtk/gtkbuildable.h>
#include <gtk/gtkbuilder.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_LAYOUT()            (gtk_cell_layout_get_type ())
#define GTK_CELL_LAYOUT(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_LAYOUT, GtkCellLayout))
#define GTK_IS_CELL_LAYOUT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_LAYOUT))
#define GTK_CELL_LAYOUT_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GTK_TYPE_CELL_LAYOUT, GtkCellLayoutIface))


/* keep in sync with GtkTreeCellDataFunc */
/**
 * GtkCellLayoutDataFunc:
 * @cell_layout: a #GtkCellLayout
 * @cell: the cell renderer whose value is to be set
 * @tree_model: the model
 * @iter: a #GtkTreeIter indicating the row to set the value for
 * @data: (closure): user data passed to gtk_cell_layout_set_cell_data_func()
 *
 * A function which should set the value of @cell_layout’s cell renderer(s)
 * as appropriate. 
 */
typedef void (* GtkCellLayoutDataFunc) (GtkCellLayout   *cell_layout,
                                        GtkCellRenderer *cell,
                                        GtkTreeModel    *tree_model,
                                        GtkTreeIter     *iter,
                                        gpointer         data);

/**
 * GtkCellLayoutIface:
 * @pack_start: Packs the cell into the beginning of cell_layout.
 * @pack_end: Adds the cell to the end of cell_layout.
 * @clear: Unsets all the mappings on all renderers on cell_layout and
 *    removes all renderers from cell_layout.
 * @add_attribute: Adds an attribute mapping to the list in
 *    cell_layout.
 * @set_cell_data_func: Sets the #GtkCellLayoutDataFunc to use for
 *    cell_layout.
 * @clear_attributes: Clears all existing attributes previously set
 *    with gtk_cell_layout_set_attributes().
 * @reorder: Re-inserts cell at position.
 * @get_cells: Get the cell renderers which have been added to
 *    cell_layout.
 * @get_area: Get the underlying #GtkCellArea which might be
 *    cell_layout if called on a #GtkCellArea or might be NULL if no
 *    #GtkCellArea is used by cell_layout.
 */
struct GtkCellRendererText
{
  GtkCellRenderer parent;

  /*< private >*/
  GtkCellRendererTextPrivate *priv;
};
struct GtkCellRendererTextClass
{
  GtkCellRendererClass parent_class;

  void (* edited) (GtkCellRendererText *cell_renderer_text,
		   const char         *path,
		   const char         *new_text);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType gtk_cell_layout_get_type           (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
void  gtk_cell_layout_pack_start         (GtkCellLayout         *cell_layout,
                                          GtkCellRenderer       *cell,
                                          gboolean               expand);
GDK_AVAILABLE_IN_ALL
void  gtk_cell_layout_pack_end           (GtkCellLayout         *cell_layout,
                                          GtkCellRenderer       *cell,
                                          gboolean               expand);
GDK_AVAILABLE_IN_ALL
GList *gtk_cell_layout_get_cells         (GtkCellLayout         *cell_layout);
GDK_AVAILABLE_IN_ALL
void  gtk_cell_layout_clear              (GtkCellLayout         *cell_layout);
GDK_AVAILABLE_IN_ALL
void  gtk_cell_layout_set_attributes     (GtkCellLayout         *cell_layout,
                                          GtkCellRenderer       *cell,
                                          ...) G_GNUC_NULL_TERMINATED;
GDK_AVAILABLE_IN_ALL
void  gtk_cell_layout_add_attribute      (GtkCellLayout         *cell_layout,
                                          GtkCellRenderer       *cell,
                                          const char           *attribute,
                                          gint                   column);
GDK_AVAILABLE_IN_ALL
void  gtk_cell_layout_set_cell_data_func (GtkCellLayout         *cell_layout,
                                          GtkCellRenderer       *cell,
                                          GtkCellLayoutDataFunc  func,
                                          gpointer               func_data,
                                          GDestroyNotify         destroy);
GDK_AVAILABLE_IN_ALL
void  gtk_cell_layout_clear_attributes   (GtkCellLayout         *cell_layout,
                                          GtkCellRenderer       *cell);
GDK_AVAILABLE_IN_ALL
void  gtk_cell_layout_reorder            (GtkCellLayout         *cell_layout,
                                          GtkCellRenderer       *cell,
                                          gint                   position);
GDK_AVAILABLE_IN_ALL
GtkCellArea *gtk_cell_layout_get_area    (GtkCellLayout         *cell_layout);

gboolean _gtk_cell_layout_buildable_custom_tag_start (GtkBuildable  *buildable,
						      GtkBuilder    *builder,
						      GObject       *child,
						      const char   *tagname,
						      GMarkupParser *parser,
						      gpointer      *data);
gboolean _gtk_cell_layout_buildable_custom_tag_end   (GtkBuildable  *buildable,
						      GtkBuilder    *builder,
						      GObject       *child,
						      const char   *tagname,
						      gpointer      *data);
void _gtk_cell_layout_buildable_add_child            (GtkBuildable  *buildable,
						      GtkBuilder    *builder,
						      GObject       *child,
						      const char   *type);

G_END_DECLS

#endif /* __GTK_CELL_LAYOUT_H__ */
#define headerfilename "gtk/./gtkcellrenderertext.h"
/* file: gtk/./gtkcellrenderertext.h */
/* gtkcellrenderertext.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_RENDERER_TEXT_H__
#define __GTK_CELL_RENDERER_TEXT_H__




#include <gtk/gtkcellrenderer.h>


G_BEGIN_DECLS


#define GTK_TYPE_CELL_RENDERER_TEXT()		(gtk_cell_renderer_text_get_type ())
#define GTK_CELL_RENDERER_TEXT(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER_TEXT, GtkCellRendererText))
#define GTK_CELL_RENDERER_TEXT_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER_TEXT, GtkCellRendererTextClass))
#define GTK_IS_CELL_RENDERER_TEXT(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER_TEXT))
#define GTK_IS_CELL_RENDERER_TEXT_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_RENDERER_TEXT))
#define GTK_CELL_RENDERER_TEXT_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER_TEXT, GtkCellRendererTextClass))

typedef struct GtkCellRendererAccelPrivate{} GtkCellRendererAccelPrivate;


struct GtkCellRendererAccel
{
  GtkCellRendererText parent;

  /*< private >*/
  GtkCellRendererAccelPrivate *priv;
};
struct GtkCellRendererAccelClass
{
  GtkCellRendererTextClass parent_class;

  void (* accel_edited)  (GtkCellRendererAccel *accel,
		 	  const char          *path_string,
			  guint                 accel_key,
			  GdkModifierType       accel_mods,
			  guint                 hardware_keycode);

  void (* accel_cleared) (GtkCellRendererAccel *accel,
			  const char          *path_string);

  /* Padding for future expansion */
  void (*_gtk_reserved0) (void);
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType            gtk_cell_renderer_text_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkCellRenderer *gtk_cell_renderer_text_new      (void);

GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_text_set_fixed_height_from_font (GtkCellRendererText *renderer,
								    gint                 number_of_rows);


G_END_DECLS

#endif /* __GTK_CELL_RENDERER_TEXT_H__ */
#define headerfilename "gtk/./gtkcellrendereraccel.h"
/* file: gtk/./gtkcellrendereraccel.h */
/* gtkcellrendereraccel.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_RENDERER_ACCEL_H__
#define __GTK_CELL_RENDERER_ACCEL_H__



#include <gtk/gtkcellrenderertext.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_RENDERER_ACCEL()            (gtk_cell_renderer_accel_get_type ())
#define GTK_CELL_RENDERER_ACCEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER_ACCEL, GtkCellRendererAccel))
#define GTK_CELL_RENDERER_ACCEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER_ACCEL, GtkCellRendererAccelClass))
#define GTK_IS_CELL_RENDERER_ACCEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER_ACCEL))
#define GTK_IS_CELL_RENDERER_ACCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_RENDERER_ACCEL))
#define GTK_CELL_RENDERER_ACCEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER_ACCEL, GtkCellRendererAccelClass))


/**
 * GtkCellRendererAccelMode:
 * @GTK_CELL_RENDERER_ACCEL_MODE_GTK: GTK+ accelerators mode
 * @GTK_CELL_RENDERER_ACCEL_MODE_OTHER: Other accelerator mode
 *
 * Determines if the edited accelerators are GTK+ accelerators. If
 * they are, consumed modifiers are suppressed, only accelerators
 * accepted by GTK+ are allowed, and the accelerators are rendered
 * in the same way as they are in menus.
 */
typedef enum
{
  GTK_CELL_RENDERER_ACCEL_MODE_GTK,
  GTK_CELL_RENDERER_ACCEL_MODE_OTHER
} GtkCellRendererAccelMode;
typedef struct GtkCellRendererComboPrivate{} GtkCellRendererComboPrivate;



struct GtkCellRendererCombo
{
  GtkCellRendererText parent;

  /*< private >*/
  GtkCellRendererComboPrivate *priv;
};
struct GtkCellRendererComboClass
{
  GtkCellRendererTextClass parent;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType            gtk_cell_renderer_accel_get_type        (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkCellRenderer *gtk_cell_renderer_accel_new             (void);


G_END_DECLS


#endif /* __GTK_CELL_RENDERER_ACCEL_H__ */
#define headerfilename "gtk/./gtkcellrenderercombo.h"
/* file: gtk/./gtkcellrenderercombo.h */
/* GtkCellRendererCombo
 * Copyright (C) 2004 Lorenzo Gil Sanchez
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_RENDERER_COMBO_H__
#define __GTK_CELL_RENDERER_COMBO_H__



#include <gtk/gtktreemodel.h>
#include <gtk/gtkcellrenderertext.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_RENDERER_COMBO()		(gtk_cell_renderer_combo_get_type ())
#define GTK_CELL_RENDERER_COMBO(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER_COMBO, GtkCellRendererCombo))
#define GTK_CELL_RENDERER_COMBO_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER_COMBO, GtkCellRendererComboClass))
#define GTK_IS_CELL_RENDERER_COMBO(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER_COMBO))
#define GTK_IS_CELL_RENDERER_COMBO_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_RENDERER_COMBO))
#define GTK_CELL_RENDERER_COMBO_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER_COMBO, GtkCellRendererTextClass))

typedef struct GtkCellRendererPixbufPrivate{} GtkCellRendererPixbufPrivate;


struct GtkCellRendererPixbuf
{
  GtkCellRenderer parent;

  /*< private >*/
  GtkCellRendererPixbufPrivate *priv;
};
struct GtkCellRendererPixbufClass
{
  GtkCellRendererClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType            gtk_cell_renderer_combo_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkCellRenderer *gtk_cell_renderer_combo_new      (void);

G_END_DECLS

#endif /* __GTK_CELL_RENDERER_COMBO_H__ */
#define headerfilename "gtk/./gtkcellrendererpixbuf.h"
/* file: gtk/./gtkcellrendererpixbuf.h */
/* gtkcellrendererpixbuf.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_RENDERER_PIXBUF_H__
#define __GTK_CELL_RENDERER_PIXBUF_H__



#include <gtk/gtkcellrenderer.h>


G_BEGIN_DECLS


#define GTK_TYPE_CELL_RENDERER_PIXBUF()			(gtk_cell_renderer_pixbuf_get_type ())
#define GTK_CELL_RENDERER_PIXBUF(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER_PIXBUF, GtkCellRendererPixbuf))
#define GTK_CELL_RENDERER_PIXBUF_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER_PIXBUF, GtkCellRendererPixbufClass))
#define GTK_IS_CELL_RENDERER_PIXBUF(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER_PIXBUF))
#define GTK_IS_CELL_RENDERER_PIXBUF_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_RENDERER_PIXBUF))
#define GTK_CELL_RENDERER_PIXBUF_GET_CLASS(obj)         (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER_PIXBUF, GtkCellRendererPixbufClass))

typedef struct GtkCellRendererProgressPrivate{} GtkCellRendererProgressPrivate;


struct GtkCellRendererProgress
{
  GtkCellRenderer parent_instance;

  /*< private >*/
  GtkCellRendererProgressPrivate *priv;
};
struct GtkCellRendererProgressClass
{
  GtkCellRendererClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType            gtk_cell_renderer_pixbuf_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkCellRenderer *gtk_cell_renderer_pixbuf_new      (void);


G_END_DECLS


#endif /* __GTK_CELL_RENDERER_PIXBUF_H__ */
#define headerfilename "gtk/./gtkcellrendererprogress.h"
/* file: gtk/./gtkcellrendererprogress.h */
/* gtkcellrendererprogress.h
 * Copyright (C) 2002 Naba Kumar <kh_naba@users.sourceforge.net>
 * modified by Jörgen Scheibengruber <mfcn@gmx.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2004.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_CELL_RENDERER_PROGRESS_H__
#define __GTK_CELL_RENDERER_PROGRESS_H__



#include <gtk/gtkcellrenderer.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_RENDERER_PROGRESS() (gtk_cell_renderer_progress_get_type ())
#define GTK_CELL_RENDERER_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER_PROGRESS, GtkCellRendererProgress))
#define GTK_CELL_RENDERER_PROGRESS_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER_PROGRESS, GtkCellRendererProgressClass))
#define GTK_IS_CELL_RENDERER_PROGRESS(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER_PROGRESS))
#define GTK_IS_CELL_RENDERER_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_RENDERER_PROGRESS))
#define GTK_CELL_RENDERER_PROGRESS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER_PROGRESS, GtkCellRendererProgressClass))

typedef struct GtkCellRendererSpinPrivate{} GtkCellRendererSpinPrivate;


struct GtkCellRendererSpin
{
  GtkCellRendererText parent;

  /*< private >*/
  GtkCellRendererSpinPrivate *priv;
};
struct GtkCellRendererSpinClass
{
  GtkCellRendererTextClass parent;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType		 gtk_cell_renderer_progress_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkCellRenderer* gtk_cell_renderer_progress_new      (void);

G_END_DECLS

#endif  /* __GTK_CELL_RENDERER_PROGRESS_H__ */
#define headerfilename "gtk/./gtkcellrendererspin.h"
/* file: gtk/./gtkcellrendererspin.h */
/* GtkCellRendererSpin
 * Copyright (C) 2004 Lorenzo Gil Sanchez
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_RENDERER_SPIN_H__
#define __GTK_CELL_RENDERER_SPIN_H__



#include <gtk/gtkcellrenderertext.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_RENDERER_SPIN()		(gtk_cell_renderer_spin_get_type ())
#define GTK_CELL_RENDERER_SPIN(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER_SPIN, GtkCellRendererSpin))
#define GTK_CELL_RENDERER_SPIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER_SPIN, GtkCellRendererSpinClass))
#define GTK_IS_CELL_RENDERER_SPIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER_SPIN))
#define GTK_IS_CELL_RENDERER_SPIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_RENDERER_SPIN))
#define GTK_CELL_RENDERER_SPIN_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER_SPIN, GtkCellRendererTextClass))

typedef struct GtkCellRendererSpinnerPrivate{} GtkCellRendererSpinnerPrivate;


struct GtkCellRendererSpinner
{
  GtkCellRenderer                parent;

  /*< private >*/
  GtkCellRendererSpinnerPrivate *priv;
};
struct GtkCellRendererSpinnerClass
{
  GtkCellRendererClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType            gtk_cell_renderer_spin_get_type (void);
GDK_AVAILABLE_IN_ALL
GtkCellRenderer *gtk_cell_renderer_spin_new      (void);

G_END_DECLS

#endif  /* __GTK_CELL_RENDERER_SPIN_H__ */
#define headerfilename "gtk/./gtkcellrendererspinner.h"
/* file: gtk/./gtkcellrendererspinner.h */
/* GTK - The GIMP Toolkit
 *
 * Copyright (C) 2009 Matthias Clasen <mclasen@redhat.com>
 * Copyright (C) 2008 Richard Hughes <richard@hughsie.com>
 * Copyright (C) 2009 Bastien Nocera <hadess@hadess.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.         See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_RENDERER_SPINNER_H__
#define __GTK_CELL_RENDERER_SPINNER_H__



#include <gtk/gtkcellrenderer.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_RENDERER_SPINNER()            (gtk_cell_renderer_spinner_get_type ())
#define GTK_CELL_RENDERER_SPINNER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER_SPINNER, GtkCellRendererSpinner))
#define GTK_CELL_RENDERER_SPINNER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER_SPINNER, GtkCellRendererSpinnerClass))
#define GTK_IS_CELL_RENDERER_SPINNER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER_SPINNER))
#define GTK_IS_CELL_RENDERER_SPINNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_RENDERER_SPINNER))
#define GTK_CELL_RENDERER_SPINNER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER_SPINNER, GtkCellRendererSpinnerClass))

typedef struct GtkCellRendererTogglePrivate{} GtkCellRendererTogglePrivate;


struct GtkCellRendererToggle
{
  GtkCellRenderer parent;

  /*< private >*/
  GtkCellRendererTogglePrivate *priv;
};
struct GtkCellRendererToggleClass
{
  GtkCellRendererClass parent_class;

  void (* toggled) (GtkCellRendererToggle *cell_renderer_toggle,
		    const char                 *path);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType            gtk_cell_renderer_spinner_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkCellRenderer *gtk_cell_renderer_spinner_new      (void);

G_END_DECLS

#endif /* __GTK_CELL_RENDERER_SPINNER_H__ */
#define headerfilename "gtk/./gtkcellrenderertoggle.h"
/* file: gtk/./gtkcellrenderertoggle.h */
/* gtkcellrenderertoggle.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_RENDERER_TOGGLE_H__
#define __GTK_CELL_RENDERER_TOGGLE_H__



#include <gtk/gtkcellrenderer.h>


G_BEGIN_DECLS


#define GTK_TYPE_CELL_RENDERER_TOGGLE()			(gtk_cell_renderer_toggle_get_type ())
#define GTK_CELL_RENDERER_TOGGLE(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER_TOGGLE, GtkCellRendererToggle))
#define GTK_CELL_RENDERER_TOGGLE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER_TOGGLE, GtkCellRendererToggleClass))
#define GTK_IS_CELL_RENDERER_TOGGLE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER_TOGGLE))
#define GTK_IS_CELL_RENDERER_TOGGLE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CELL_RENDERER_TOGGLE))
#define GTK_CELL_RENDERER_TOGGLE_GET_CLASS(obj)         (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER_TOGGLE, GtkCellRendererToggleClass))

typedef struct GtkCellViewPrivate{} GtkCellViewPrivate;


struct GtkCellView
{
  GtkWidget parent_instance;

  /*< private >*/
  GtkCellViewPrivate *priv;
};
struct GtkCellViewClass
{
  GtkWidgetClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType            gtk_cell_renderer_toggle_get_type       (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkCellRenderer *gtk_cell_renderer_toggle_new            (void);

GDK_AVAILABLE_IN_ALL
gboolean         gtk_cell_renderer_toggle_get_radio      (GtkCellRendererToggle *toggle);
GDK_AVAILABLE_IN_ALL
void             gtk_cell_renderer_toggle_set_radio      (GtkCellRendererToggle *toggle,
                                                          gboolean               radio);

GDK_AVAILABLE_IN_ALL
gboolean        gtk_cell_renderer_toggle_get_active      (GtkCellRendererToggle *toggle);
GDK_AVAILABLE_IN_ALL
void            gtk_cell_renderer_toggle_set_active      (GtkCellRendererToggle *toggle,
                                                          gboolean               setting);

GDK_AVAILABLE_IN_ALL
gboolean        gtk_cell_renderer_toggle_get_activatable (GtkCellRendererToggle *toggle);
GDK_AVAILABLE_IN_ALL
void            gtk_cell_renderer_toggle_set_activatable (GtkCellRendererToggle *toggle,
                                                          gboolean               setting);


G_END_DECLS

#endif /* __GTK_CELL_RENDERER_TOGGLE_H__ */
#define headerfilename "gtk/./gtkcellview.h"
/* file: gtk/./gtkcellview.h */
/* gtkcellview.h
 * Copyright (C) 2002, 2003  Kristian Rietveld <kris@gtk.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CELL_VIEW_H__
#define __GTK_CELL_VIEW_H__



#include <gtk/gtkwidget.h>
#include <gtk/gtkcellrenderer.h>
#include <gtk/gtkcellarea.h>
#include <gtk/gtkcellareacontext.h>
#include <gtk/gtktreemodel.h>

G_BEGIN_DECLS

#define GTK_TYPE_CELL_VIEW()                (gtk_cell_view_get_type ())
#define GTK_CELL_VIEW(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_VIEW, GtkCellView))
#define GTK_CELL_VIEW_CLASS(vtable)       (G_TYPE_CHECK_CLASS_CAST ((vtable), GTK_TYPE_CELL_VIEW, GtkCellViewClass))
#define GTK_IS_CELL_VIEW(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_VIEW))
#define GTK_IS_CELL_VIEW_CLASS(vtable)    (G_TYPE_CHECK_CLASS_TYPE ((vtable), GTK_TYPE_CELL_VIEW))
#define GTK_CELL_VIEW_GET_CLASS(inst)     (G_TYPE_INSTANCE_GET_CLASS ((inst), GTK_TYPE_CELL_VIEW, GtkCellViewClass))

typedef struct GtkToggleButtonPrivate{} GtkToggleButtonPrivate;


/**
 * GtkCellViewClass:
 * @parent_class: The parent class.
 */
struct GtkToggleButton
{
  /*< private >*/
  GtkButton button;

  GtkToggleButtonPrivate *priv;
};
struct GtkToggleButtonClass
{
  GtkButtonClass parent_class;

  void (* toggled) (GtkToggleButton *toggle_button);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType             gtk_cell_view_get_type                (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget        *gtk_cell_view_new                     (void);
GDK_AVAILABLE_IN_ALL
GtkWidget        *gtk_cell_view_new_with_context        (GtkCellArea        *area,
                                                         GtkCellAreaContext *context);
GDK_AVAILABLE_IN_ALL
GtkWidget        *gtk_cell_view_new_with_text           (const char     *text);
GDK_AVAILABLE_IN_ALL
GtkWidget        *gtk_cell_view_new_with_markup         (const char     *markup);
GDK_AVAILABLE_IN_ALL
GtkWidget        *gtk_cell_view_new_with_pixbuf         (GdkPixbuf       *pixbuf);
GDK_AVAILABLE_IN_ALL
void              gtk_cell_view_set_model               (GtkCellView     *cell_view,
                                                         GtkTreeModel    *model);
GDK_AVAILABLE_IN_ALL
GtkTreeModel     *gtk_cell_view_get_model               (GtkCellView     *cell_view);
GDK_AVAILABLE_IN_ALL
void              gtk_cell_view_set_displayed_row       (GtkCellView     *cell_view,
                                                         GtkTreePath     *path);
GDK_AVAILABLE_IN_ALL
GtkTreePath      *gtk_cell_view_get_displayed_row       (GtkCellView     *cell_view);
GDK_AVAILABLE_IN_ALL
void              gtk_cell_view_set_background_rgba     (GtkCellView     *cell_view,
                                                         const GdkRGBA   *rgba);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_cell_view_get_draw_sensitive      (GtkCellView     *cell_view);
GDK_AVAILABLE_IN_ALL
void              gtk_cell_view_set_draw_sensitive      (GtkCellView     *cell_view,
                                                         gboolean         draw_sensitive);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_cell_view_get_fit_model           (GtkCellView     *cell_view);
GDK_AVAILABLE_IN_ALL
void              gtk_cell_view_set_fit_model           (GtkCellView     *cell_view,
                                                         gboolean         fit_model);

GDK_DEPRECATED_IN_3_0_FOR(gtk_widget_get_preferred_size)
gboolean          gtk_cell_view_get_size_of_row         (GtkCellView     *cell_view,
                                                         GtkTreePath     *path,
                                                         GtkRequisition  *requisition);
GDK_DEPRECATED_IN_3_4_FOR(gtk_cell_view_set_background_rgba)
void              gtk_cell_view_set_background_color    (GtkCellView     *cell_view,
                                                         const GdkColor  *color);

G_END_DECLS

#endif /* __GTK_CELL_VIEW_H__ */
#define headerfilename "gtk/./gtktogglebutton.h"
/* file: gtk/./gtktogglebutton.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_TOGGLE_BUTTON_H__
#define __GTK_TOGGLE_BUTTON_H__




#include <gtk/gtkbutton.h>


G_BEGIN_DECLS

#define GTK_TYPE_TOGGLE_BUTTON()                  (gtk_toggle_button_get_type ())
#define GTK_TOGGLE_BUTTON(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TOGGLE_BUTTON, GtkToggleButton))
#define GTK_TOGGLE_BUTTON_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_TOGGLE_BUTTON, GtkToggleButtonClass))
#define GTK_IS_TOGGLE_BUTTON(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TOGGLE_BUTTON))
#define GTK_IS_TOGGLE_BUTTON_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_TOGGLE_BUTTON))
#define GTK_TOGGLE_BUTTON_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_TOGGLE_BUTTON, GtkToggleButtonClass))



struct GtkCheckButton
{
  GtkToggleButton toggle_button;
};
struct GtkCheckButtonClass
{
  GtkToggleButtonClass parent_class;

  void (* draw_indicator) (GtkCheckButton *check_button,
			   cairo_t        *cr);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};
typedef struct GtkMenuItemPrivate{} GtkMenuItemPrivate;


GDK_AVAILABLE_IN_ALL
GType      gtk_toggle_button_get_type          (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_toggle_button_new               (void);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_toggle_button_new_with_label    (const char     *label);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_toggle_button_new_with_mnemonic (const char     *label);
GDK_AVAILABLE_IN_ALL
void       gtk_toggle_button_set_mode          (GtkToggleButton *toggle_button,
                                                gboolean         draw_indicator);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_toggle_button_get_mode          (GtkToggleButton *toggle_button);
GDK_AVAILABLE_IN_ALL
void       gtk_toggle_button_set_active        (GtkToggleButton *toggle_button,
                                                gboolean         is_active);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_toggle_button_get_active        (GtkToggleButton *toggle_button);
GDK_AVAILABLE_IN_ALL
void       gtk_toggle_button_toggled           (GtkToggleButton *toggle_button);
GDK_AVAILABLE_IN_ALL
void       gtk_toggle_button_set_inconsistent  (GtkToggleButton *toggle_button,
                                                gboolean         setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_toggle_button_get_inconsistent  (GtkToggleButton *toggle_button);


G_END_DECLS

#endif /* __GTK_TOGGLE_BUTTON_H__ */
#define headerfilename "gtk/./gtkcheckbutton.h"
/* file: gtk/./gtkcheckbutton.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_CHECK_BUTTON_H__
#define __GTK_CHECK_BUTTON_H__




#include <gtk/gtktogglebutton.h>


G_BEGIN_DECLS

#define GTK_TYPE_CHECK_BUTTON()                  (gtk_check_button_get_type ())
#define GTK_CHECK_BUTTON(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CHECK_BUTTON, GtkCheckButton))
#define GTK_CHECK_BUTTON_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CHECK_BUTTON, GtkCheckButtonClass))
#define GTK_IS_CHECK_BUTTON(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CHECK_BUTTON))
#define GTK_IS_CHECK_BUTTON_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CHECK_BUTTON))
#define GTK_CHECK_BUTTON_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CHECK_BUTTON, GtkCheckButtonClass))




struct GtkMenuItem
{
  GtkBin bin;

  /*< private >*/
  GtkMenuItemPrivate *priv;
};
struct GtkMenuItemClass
{
  GtkBinClass parent_class;

  /*< public >*/

  /* If the following flag is true, then we should always
   * hide the menu when the MenuItem is activated. Otherwise,
   * it is up to the caller. For instance, when navigating
   * a menu with the keyboard, <Space> doesn't hide, but
   * <Return> does.
   */
  guint hide_on_activate : 1;

  void (* activate)             (GtkMenuItem *menu_item);
  void (* activate_item)        (GtkMenuItem *menu_item);
  void (* toggle_size_request)  (GtkMenuItem *menu_item,
                                 gint        *requisition);
  void (* toggle_size_allocate) (GtkMenuItem *menu_item,
                                 gint         allocation);
  void (* set_label)            (GtkMenuItem *menu_item,
                                 const char *label);
  const char * (* get_label)   (GtkMenuItem *menu_item);

  void (* select)               (GtkMenuItem *menu_item);
  void (* deselect)             (GtkMenuItem *menu_item);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType      gtk_check_button_get_type       (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_check_button_new               (void);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_check_button_new_with_label    (const char *label);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_check_button_new_with_mnemonic (const char *label);

void _gtk_check_button_get_props (GtkCheckButton *check_button,
				  gint           *indicator_size,
				  gint           *indicator_spacing);

G_END_DECLS

#endif /* __GTK_CHECK_BUTTON_H__ */
#define headerfilename "gtk/./gtkmenuitem.h"
/* file: gtk/./gtkmenuitem.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_MENU_ITEM_H__
#define __GTK_MENU_ITEM_H__



#include <gtk/gtkbin.h>


G_BEGIN_DECLS

#define GTK_TYPE_MENU_ITEM()            (gtk_menu_item_get_type ())
#define GTK_MENU_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_MENU_ITEM, GtkMenuItem))
#define GTK_MENU_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_MENU_ITEM, GtkMenuItemClass))
#define GTK_IS_MENU_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_MENU_ITEM))
#define GTK_IS_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MENU_ITEM))
#define GTK_MENU_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MENU_ITEM, GtkMenuItemClass))


typedef struct GtkCheckMenuItemPrivate{} GtkCheckMenuItemPrivate;


/**
 * GtkMenuItemClass:
 * @parent_class: The parent class.
 * @hide_on_activate: If %TRUE, then we should always
 *    hide the menu when the %GtkMenuItem is activated. Otherwise,
 *    it is up to the caller.
 * @activate: Signal emitted when the item is activated.
 * @activate_item: Signal emitted when the item is activated, but also
 *    if the menu item has a submenu.
 * @toggle_size_request: 
 * @toggle_size_allocate: 
 * @set_label: Sets @text on the #GtkMenuItem label
 * @get_label: Gets @text from the #GtkMenuItem label
 * @select: Signal emitted when the item is selected.
 * @deselect: Signal emitted when the item is deselected.
 */
struct GtkCheckMenuItem
{
  GtkMenuItem menu_item;

  /*< private >*/
  GtkCheckMenuItemPrivate *priv;
};
struct GtkCheckMenuItemClass
{
  GtkMenuItemClass parent_class;

  /*< public >*/

  void (* toggled)	  (GtkCheckMenuItem *check_menu_item);
  void (* draw_indicator) (GtkCheckMenuItem *check_menu_item,
			   cairo_t          *cr);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType      gtk_menu_item_get_type             (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_menu_item_new                  (void);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_menu_item_new_with_label       (const char         *label);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_menu_item_new_with_mnemonic    (const char         *label);
GDK_AVAILABLE_IN_ALL
void       gtk_menu_item_set_submenu          (GtkMenuItem         *menu_item,
                                               GtkWidget           *submenu);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_menu_item_get_submenu          (GtkMenuItem         *menu_item);
GDK_AVAILABLE_IN_ALL
void       gtk_menu_item_select               (GtkMenuItem         *menu_item);
GDK_AVAILABLE_IN_ALL
void       gtk_menu_item_deselect             (GtkMenuItem         *menu_item);
GDK_AVAILABLE_IN_ALL
void       gtk_menu_item_activate             (GtkMenuItem         *menu_item);
GDK_AVAILABLE_IN_ALL
void       gtk_menu_item_toggle_size_request  (GtkMenuItem         *menu_item,
                                               gint                *requisition);
GDK_AVAILABLE_IN_ALL
void       gtk_menu_item_toggle_size_allocate (GtkMenuItem         *menu_item,
                                               gint                 allocation);
GDK_DEPRECATED_IN_3_2
void       gtk_menu_item_set_right_justified  (GtkMenuItem         *menu_item,
                                               gboolean             right_justified);
GDK_DEPRECATED_IN_3_2
gboolean   gtk_menu_item_get_right_justified  (GtkMenuItem         *menu_item);
GDK_AVAILABLE_IN_ALL
void          gtk_menu_item_set_accel_path    (GtkMenuItem         *menu_item,
                                               const char         *accel_path);
GDK_AVAILABLE_IN_ALL
const char * gtk_menu_item_get_accel_path    (GtkMenuItem    *menu_item);

GDK_AVAILABLE_IN_ALL
void          gtk_menu_item_set_label         (GtkMenuItem         *menu_item,
                                               const char         *label);
GDK_AVAILABLE_IN_ALL
const char * gtk_menu_item_get_label         (GtkMenuItem         *menu_item);

GDK_AVAILABLE_IN_ALL
void       gtk_menu_item_set_use_underline    (GtkMenuItem         *menu_item,
                                               gboolean             setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_menu_item_get_use_underline    (GtkMenuItem         *menu_item);

GDK_AVAILABLE_IN_ALL
void       gtk_menu_item_set_reserve_indicator (GtkMenuItem        *menu_item,
                                                gboolean            reserve);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_menu_item_get_reserve_indicator (GtkMenuItem        *menu_item);

G_END_DECLS

#endif /* __GTK_MENU_ITEM_H__ */
#define headerfilename "gtk/./gtkcheckmenuitem.h"
/* file: gtk/./gtkcheckmenuitem.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2001.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_CHECK_MENU_ITEM_H__
#define __GTK_CHECK_MENU_ITEM_H__




#include <gtk/gtkmenuitem.h>


G_BEGIN_DECLS

#define GTK_TYPE_CHECK_MENU_ITEM()            (gtk_check_menu_item_get_type ())
#define GTK_CHECK_MENU_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CHECK_MENU_ITEM, GtkCheckMenuItem))
#define GTK_CHECK_MENU_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CHECK_MENU_ITEM, GtkCheckMenuItemClass))
#define GTK_IS_CHECK_MENU_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CHECK_MENU_ITEM))
#define GTK_IS_CHECK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CHECK_MENU_ITEM))
#define GTK_CHECK_MENU_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CHECK_MENU_ITEM, GtkCheckMenuItemClass))




/**
 * GtkCheckMenuItemClass:
 * @parent_class: The parent class.
 * @toggled: Signal emitted when the state of the check box is changed.
 * @draw_indicator: Called to draw the check indicator.
 */


GDK_AVAILABLE_IN_ALL
GType	   gtk_check_menu_item_get_type	         (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_check_menu_item_new               (void);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_check_menu_item_new_with_label    (const char      *label);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_check_menu_item_new_with_mnemonic (const char      *label);
GDK_AVAILABLE_IN_ALL
void       gtk_check_menu_item_set_active        (GtkCheckMenuItem *check_menu_item,
						  gboolean          is_active);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_check_menu_item_get_active        (GtkCheckMenuItem *check_menu_item);
GDK_AVAILABLE_IN_ALL
void       gtk_check_menu_item_toggled           (GtkCheckMenuItem *check_menu_item);
GDK_AVAILABLE_IN_ALL
void       gtk_check_menu_item_set_inconsistent  (GtkCheckMenuItem *check_menu_item,
						  gboolean          setting);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_check_menu_item_get_inconsistent  (GtkCheckMenuItem *check_menu_item);
GDK_AVAILABLE_IN_ALL
void       gtk_check_menu_item_set_draw_as_radio (GtkCheckMenuItem *check_menu_item,
						  gboolean          draw_as_radio);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_check_menu_item_get_draw_as_radio (GtkCheckMenuItem *check_menu_item);

G_END_DECLS

#endif /* __GTK_CHECK_MENU_ITEM_H__ */
#define headerfilename "gtk/./gtkclipboard.h"
/* file: gtk/./gtkclipboard.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Global clipboard abstraction.
 */

#ifndef __GTK_CLIPBOARD_H__
#define __GTK_CLIPBOARD_H__



#include <gtk/gtkselection.h>

G_BEGIN_DECLS

#define GTK_TYPE_CLIPBOARD()            (gtk_clipboard_get_type ())
#define GTK_CLIPBOARD(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CLIPBOARD, GtkClipboard))
#define GTK_IS_CLIPBOARD(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CLIPBOARD))

/**
 * GtkClipboardReceivedFunc:
 * @clipboard: the #GtkClipboard
 * @selection_data: a #GtkSelectionData containing the data was received.
 *   If retrieving the data failed, then then length field
 *   of @selection_data will be negative.
 * @data: (closure): the @user_data supplied to
 *   gtk_clipboard_request_contents().
 *
 * A function to be called when the results of gtk_clipboard_request_contents()
 * are received, or when the request fails.
 */
typedef void (* GtkClipboardReceivedFunc)         (GtkClipboard     *clipboard,
					           GtkSelectionData *selection_data,
					           gpointer          data);

/**
 * GtkClipboardTextReceivedFunc:
 * @clipboard: the #GtkClipboard
 * @text: (nullable): the text received, as a UTF-8 encoded string, or
 *   %NULL if retrieving the data failed.
 * @data: (closure): the @user_data supplied to
 *   gtk_clipboard_request_text().
 *
 * A function to be called when the results of gtk_clipboard_request_text()
 * are received, or when the request fails.
 */
typedef void (* GtkClipboardTextReceivedFunc)     (GtkClipboard     *clipboard,
					           const char      *text,
					           gpointer          data);

/**
 * GtkClipboardRichTextReceivedFunc:
 * @clipboard: the #GtkClipboard
 * @format: The format of the rich text
 * @text: (nullable) (type utf8): the rich text received, as
 *   a UTF-8 encoded string, or %NULL if retrieving the data failed.
 * @length: Length of the text.
 * @data: (closure): the @user_data supplied to
 *   gtk_clipboard_request_rich_text().
 *
 * A function to be called when the results of
 * gtk_clipboard_request_rich_text() are received, or when the request
 * fails.
 *
 * Since: 2.10
 */
typedef void (* GtkClipboardRichTextReceivedFunc) (GtkClipboard     *clipboard,
                                                   GdkAtom           format,
					           const guint8     *text,
                                                   gsize             length,
					           gpointer          data);

/**
 * GtkClipboardImageReceivedFunc:
 * @clipboard: the #GtkClipboard
 * @pixbuf: the received image
 * @data: (closure): the @user_data supplied to
 *   gtk_clipboard_request_image().
 *
 * A function to be called when the results of gtk_clipboard_request_image()
 * are received, or when the request fails.
 *
 * Since: 2.6
 */
typedef void (* GtkClipboardImageReceivedFunc)    (GtkClipboard     *clipboard,
						   GdkPixbuf        *pixbuf,
						   gpointer          data);

/**
 * GtkClipboardURIReceivedFunc:
 * @clipboard: the #GtkClipboard
 * @uris: (array zero-terminated=1): the received URIs
 * @data: (closure): the @user_data supplied to
 *   gtk_clipboard_request_uris().
 *
 * A function to be called when the results of
 * gtk_clipboard_request_uris() are received, or when the request
 * fails.
 *
 * Since: 2.14
 */
typedef void (* GtkClipboardURIReceivedFunc)      (GtkClipboard     *clipboard,
						   char           **uris,
						   gpointer          data);

/**
 * GtkClipboardTargetsReceivedFunc:
 * @clipboard: the #GtkClipboard
 * @atoms: (nullable) (array length=n_atoms): the supported targets,
 *   as array of #GdkAtom, or %NULL if retrieving the data failed.
 * @n_atoms: the length of the @atoms array.
 * @data: (closure): the @user_data supplied to
 *   gtk_clipboard_request_targets().
 *
 * A function to be called when the results of gtk_clipboard_request_targets()
 * are received, or when the request fails.
 *
 * Since: 2.4
 */
typedef void (* GtkClipboardTargetsReceivedFunc)  (GtkClipboard     *clipboard,
					           GdkAtom          *atoms,
						   gint              n_atoms,
					           gpointer          data);

/* Should these functions have GtkClipboard *clipboard as the first argument?
 * right now for ClearFunc, you may have trouble determining _which_ clipboard
 * was cleared, if you reuse your ClearFunc for multiple clipboards.
 */
/**
 * GtkClipboardGetFunc:
 * @clipboard: the #GtkClipboard
 * @selection_data: a #GtkSelectionData argument in which the requested
 *   data should be stored.
 * @info: the info field corresponding to the requested target from the
 *   #GtkTargetEntry array passed to gtk_clipboard_set_with_data() or
 *   gtk_clipboard_set_with_owner().
 * @user_data_or_owner: the @user_data argument passed to
 *   gtk_clipboard_set_with_data(), or the @owner argument passed to
 *   gtk_clipboard_set_with_owner()
 *
 * A function that will be called to provide the contents of the selection.
 * If multiple types of data were advertised, the requested type can
 * be determined from the @info parameter or by checking the target field
 * of @selection_data. If the data could successfully be converted into
 * then it should be stored into the @selection_data object by
 * calling gtk_selection_data_set() (or related functions such
 * as gtk_selection_data_set_text()). If no data is set, the requestor
 * will be informed that the attempt to get the data failed.
 */
typedef void (* GtkClipboardGetFunc)          (GtkClipboard     *clipboard,
					       GtkSelectionData *selection_data,
					       guint             info,
					       gpointer          user_data_or_owner);

/**
 * GtkClipboardClearFunc:
 * @clipboard: the #GtkClipboard
 * @user_data_or_owner: the @user_data argument passed to gtk_clipboard_set_with_data(),
 *   or the @owner argument passed to gtk_clipboard_set_with_owner()
 *
 * A function that will be called when the contents of the clipboard are changed
 * or cleared. Once this has called, the @user_data_or_owner argument
 * will not be used again.
 */
typedef void (* GtkClipboardClearFunc)        (GtkClipboard     *clipboard,
					       gpointer          user_data_or_owner);

GDK_AVAILABLE_IN_ALL
GType         gtk_clipboard_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkClipboard *gtk_clipboard_get_for_display (GdkDisplay   *display,
					     GdkAtom       selection);
GDK_AVAILABLE_IN_ALL
GtkClipboard *gtk_clipboard_get             (GdkAtom       selection);

GDK_AVAILABLE_IN_3_16
GtkClipboard *gtk_clipboard_get_default     (GdkDisplay    *display);

GDK_AVAILABLE_IN_ALL
GdkDisplay   *gtk_clipboard_get_display     (GtkClipboard *clipboard);


GDK_AVAILABLE_IN_ALL
gboolean gtk_clipboard_set_with_data  (GtkClipboard          *clipboard,
				       const GtkTargetEntry  *targets,
				       guint                  n_targets,
				       GtkClipboardGetFunc    get_func,
				       GtkClipboardClearFunc  clear_func,
				       gpointer               user_data);
GDK_AVAILABLE_IN_ALL
gboolean gtk_clipboard_set_with_owner (GtkClipboard          *clipboard,
				       const GtkTargetEntry  *targets,
				       guint                  n_targets,
				       GtkClipboardGetFunc    get_func,
				       GtkClipboardClearFunc  clear_func,
				       GObject               *owner);
GDK_AVAILABLE_IN_ALL
GObject *gtk_clipboard_get_owner      (GtkClipboard          *clipboard);
GDK_AVAILABLE_IN_ALL
void     gtk_clipboard_clear          (GtkClipboard          *clipboard);
GDK_AVAILABLE_IN_ALL
void     gtk_clipboard_set_text       (GtkClipboard          *clipboard,
				       const char           *text,
				       gint                   len);
GDK_AVAILABLE_IN_ALL
void     gtk_clipboard_set_image      (GtkClipboard          *clipboard,
				       GdkPixbuf             *pixbuf);

GDK_AVAILABLE_IN_ALL
void gtk_clipboard_request_contents  (GtkClipboard                     *clipboard,
                                      GdkAtom                           target,
                                      GtkClipboardReceivedFunc          callback,
                                      gpointer                          user_data);
GDK_AVAILABLE_IN_ALL
void gtk_clipboard_request_text      (GtkClipboard                     *clipboard,
                                      GtkClipboardTextReceivedFunc      callback,
                                      gpointer                          user_data);
GDK_AVAILABLE_IN_ALL
void gtk_clipboard_request_rich_text (GtkClipboard                     *clipboard,
                                      GtkTextBuffer                    *buffer,
                                      GtkClipboardRichTextReceivedFunc  callback,
                                      gpointer                          user_data);
GDK_AVAILABLE_IN_ALL
void gtk_clipboard_request_image     (GtkClipboard                     *clipboard,
                                      GtkClipboardImageReceivedFunc     callback,
                                      gpointer                          user_data);
GDK_AVAILABLE_IN_ALL
void gtk_clipboard_request_uris      (GtkClipboard                     *clipboard,
                                      GtkClipboardURIReceivedFunc       callback,
                                      gpointer                          user_data);
GDK_AVAILABLE_IN_ALL
void gtk_clipboard_request_targets   (GtkClipboard                     *clipboard,
                                      GtkClipboardTargetsReceivedFunc   callback,
                                      gpointer                          user_data);

GDK_AVAILABLE_IN_ALL
GtkSelectionData *gtk_clipboard_wait_for_contents  (GtkClipboard  *clipboard,
                                                    GdkAtom        target);
GDK_AVAILABLE_IN_ALL
char *           gtk_clipboard_wait_for_text      (GtkClipboard  *clipboard);
GDK_AVAILABLE_IN_ALL
guint8 *          gtk_clipboard_wait_for_rich_text (GtkClipboard  *clipboard,
                                                    GtkTextBuffer *buffer,
                                                    GdkAtom       *format,
                                                    gsize         *length);
GDK_AVAILABLE_IN_ALL
GdkPixbuf *       gtk_clipboard_wait_for_image     (GtkClipboard  *clipboard);
GDK_AVAILABLE_IN_ALL
char **          gtk_clipboard_wait_for_uris      (GtkClipboard  *clipboard);
GDK_AVAILABLE_IN_ALL
gboolean          gtk_clipboard_wait_for_targets   (GtkClipboard  *clipboard,
                                                    GdkAtom      **targets,
                                                    gint          *n_targets);

GDK_AVAILABLE_IN_ALL
gboolean gtk_clipboard_wait_is_text_available      (GtkClipboard  *clipboard);
GDK_AVAILABLE_IN_ALL
gboolean gtk_clipboard_wait_is_rich_text_available (GtkClipboard  *clipboard,
                                                    GtkTextBuffer *buffer);
GDK_AVAILABLE_IN_ALL
gboolean gtk_clipboard_wait_is_image_available     (GtkClipboard  *clipboard);
GDK_AVAILABLE_IN_ALL
gboolean gtk_clipboard_wait_is_uris_available      (GtkClipboard  *clipboard);
GDK_AVAILABLE_IN_ALL
gboolean gtk_clipboard_wait_is_target_available    (GtkClipboard  *clipboard,
                                                    GdkAtom        target);


GDK_AVAILABLE_IN_ALL
void gtk_clipboard_set_can_store (GtkClipboard         *clipboard,
				  const GtkTargetEntry *targets,
				  gint                  n_targets);

GDK_AVAILABLE_IN_ALL
void gtk_clipboard_store         (GtkClipboard   *clipboard);

/* private */
void     _gtk_clipboard_handle_event    (GdkEventOwnerChange *event);

void     _gtk_clipboard_store_all       (void);

G_END_DECLS

#endif /* __GTK_CLIPBOARD_H__ */
#define headerfilename "gtk/./gtkcolorbutton.h"
/* file: gtk/./gtkcolorbutton.h */
/*
 * GTK - The GIMP Toolkit
 * Copyright (C) 1998, 1999 Red Hat, Inc.
 * All rights reserved.
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/* Color picker button for GNOME
 *
 * Author: Federico Mena <federico@nuclecu.unam.mx>
 *
 * Modified by the GTK+ Team and others 2003.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_COLOR_BUTTON_H__
#define __GTK_COLOR_BUTTON_H__




#include <gtk/gtkbutton.h>

G_BEGIN_DECLS


#define GTK_TYPE_COLOR_BUTTON()             (gtk_color_button_get_type ())
#define GTK_COLOR_BUTTON(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_COLOR_BUTTON, GtkColorButton))
#define GTK_COLOR_BUTTON_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_COLOR_BUTTON, GtkColorButtonClass))
#define GTK_IS_COLOR_BUTTON(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_COLOR_BUTTON))
#define GTK_IS_COLOR_BUTTON_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_COLOR_BUTTON))
#define GTK_COLOR_BUTTON_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_COLOR_BUTTON, GtkColorButtonClass))

typedef struct GtkColorButtonPrivate{} GtkColorButtonPrivate;

struct GtkColorButton {
  GtkButton button;

  /*< private >*/
  GtkColorButtonPrivate *priv;
};

struct GtkColorButtonClass {
  GtkButtonClass parent_class;

  void (* color_set) (GtkColorButton *cp);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};
typedef struct _GtkColorChooser{} GtkColorChooser;
struct GtkColorChooserInterface
{
  GTypeInterface base_interface;

  /* Methods */
  void (* get_rgba)    (GtkColorChooser *chooser,
                        GdkRGBA         *color);
  void (* set_rgba)    (GtkColorChooser *chooser,
                        const GdkRGBA   *color);

  void (* add_palette) (GtkColorChooser *chooser,
                        GtkOrientation   orientation,
                        gint             colors_per_line,
                        gint             n_colors,
                        GdkRGBA         *colors);

  /* Signals */
  void (* color_activated) (GtkColorChooser *chooser,
                            const GdkRGBA   *color);

  /* Padding */
  gpointer padding[12];
};


GDK_AVAILABLE_IN_ALL
GType        gtk_color_button_get_type      (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget *  gtk_color_button_new           (void);
GDK_AVAILABLE_IN_ALL
GtkWidget *  gtk_color_button_new_with_rgba (const GdkRGBA  *rgba);
GDK_AVAILABLE_IN_ALL
void         gtk_color_button_set_title     (GtkColorButton *button,
                                             const char    *title);
GDK_AVAILABLE_IN_ALL
const char *gtk_color_button_get_title     (GtkColorButton *button);

GDK_DEPRECATED_IN_3_4_FOR(gtk_color_button_new_with_rgba)
GtkWidget *gtk_color_button_new_with_color (const GdkColor *color);
GDK_DEPRECATED_IN_3_4_FOR(gtk_color_chooser_set_rgba)
void       gtk_color_button_set_color      (GtkColorButton *button,
                                            const GdkColor *color);
GDK_DEPRECATED_IN_3_4_FOR(gtk_color_chooser_get_rgba)
void       gtk_color_button_get_color      (GtkColorButton *button,
                                            GdkColor       *color);
GDK_DEPRECATED_IN_3_4_FOR(gtk_color_chooser_set_rgba)
void       gtk_color_button_set_alpha      (GtkColorButton *button,
                                            guint16         alpha);
GDK_DEPRECATED_IN_3_4_FOR(gtk_color_chooser_get_rgba)
guint16    gtk_color_button_get_alpha      (GtkColorButton *button);
GDK_DEPRECATED_IN_3_4_FOR(gtk_color_chooser_set_use_alpha)
void         gtk_color_button_set_use_alpha (GtkColorButton *button,
                                             gboolean        use_alpha);
GDK_DEPRECATED_IN_3_4_FOR(gtk_color_chooser_get_use_alpha)
gboolean     gtk_color_button_get_use_alpha (GtkColorButton *button);
GDK_DEPRECATED_IN_3_4_FOR(gtk_color_chooser_set_rgba)
void         gtk_color_button_set_rgba      (GtkColorButton *button,
                                             const GdkRGBA  *rgba);
GDK_DEPRECATED_IN_3_4_FOR(gtk_color_chooser_get_rgba)
void         gtk_color_button_get_rgba      (GtkColorButton *button,
                                             GdkRGBA        *rgba);

G_END_DECLS

#endif  /* __GTK_COLOR_BUTTON_H__ */
#define headerfilename "gtk/./gtkcolorchooser.h"
/* file: gtk/./gtkcolorchooser.h */
/* GTK - The GIMP Toolkit
 *
 * Copyright (C) 2012 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_COLOR_CHOOSER_H__
#define __GTK_COLOR_CHOOSER_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_COLOR_CHOOSER()                  (gtk_color_chooser_get_type ())
#define GTK_COLOR_CHOOSER(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_COLOR_CHOOSER, GtkColorChooser))
#define GTK_IS_COLOR_CHOOSER(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_COLOR_CHOOSER))
#define GTK_COLOR_CHOOSER_GET_IFACE(inst)       (G_TYPE_INSTANCE_GET_INTERFACE ((inst), GTK_TYPE_COLOR_CHOOSER, GtkColorChooserInterface))

typedef struct GtkColorChooserDialogPrivate{} GtkColorChooserDialogPrivate;

struct GtkColorChooserDialog
{
  GtkDialog parent_instance;

  /*< private >*/
  GtkColorChooserDialogPrivate *priv;
};
struct GtkColorChooserDialogClass
{
  GtkDialogClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_4
GType    gtk_color_chooser_get_type        (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_4
void     gtk_color_chooser_get_rgba       (GtkColorChooser *chooser,
                                           GdkRGBA         *color);
GDK_AVAILABLE_IN_3_4
void     gtk_color_chooser_set_rgba       (GtkColorChooser *chooser,
                                           const GdkRGBA   *color);
GDK_AVAILABLE_IN_3_4
gboolean gtk_color_chooser_get_use_alpha  (GtkColorChooser *chooser);

GDK_AVAILABLE_IN_3_4
void     gtk_color_chooser_set_use_alpha  (GtkColorChooser *chooser,
                                           gboolean         use_alpha);

GDK_AVAILABLE_IN_3_4
void     gtk_color_chooser_add_palette    (GtkColorChooser *chooser,
                                           GtkOrientation   orientation,
                                           gint             colors_per_line,
                                           gint             n_colors,
                                           GdkRGBA         *colors);

G_END_DECLS

#endif /* __GTK_COLOR_CHOOSER_H__ */
#define headerfilename "gtk/./gtkcolorchooserdialog.h"
/* file: gtk/./gtkcolorchooserdialog.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2012 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_COLOR_CHOOSER_DIALOG_H__
#define __GTK_COLOR_CHOOSER_DIALOG_H__



#include <gtk/gtkdialog.h>

G_BEGIN_DECLS

#define GTK_TYPE_COLOR_CHOOSER_DIALOG()              (gtk_color_chooser_dialog_get_type ())
#define GTK_COLOR_CHOOSER_DIALOG(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_COLOR_CHOOSER_DIALOG, GtkColorChooserDialog))
#define GTK_COLOR_CHOOSER_DIALOG_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_COLOR_CHOOSER_DIALOG, GtkColorChooserDialogClass))
#define GTK_IS_COLOR_CHOOSER_DIALOG(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_COLOR_CHOOSER_DIALOG))
#define GTK_IS_COLOR_CHOOSER_DIALOG_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_COLOR_CHOOSER_DIALOG))
#define GTK_COLOR_CHOOSER_DIALOG_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_COLOR_CHOOSER_DIALOG, GtkColorChooserDialogClass))

typedef struct GtkColorChooserWidgetPrivate{} GtkColorChooserWidgetPrivate;


struct GtkColorChooserWidget
{
  GtkBox parent_instance;

  /*< private >*/
  GtkColorChooserWidgetPrivate *priv;
};
struct GtkColorChooserWidgetClass
{
  GtkBoxClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};

GDK_AVAILABLE_IN_3_4
GType       gtk_color_chooser_dialog_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_4
GtkWidget * gtk_color_chooser_dialog_new      (const char *title,
                                               GtkWindow   *parent);

G_END_DECLS

#endif /* __GTK_COLOR_CHOOSER_DIALOG_H__ */
#define headerfilename "gtk/./gtkcolorchooserwidget.h"
/* file: gtk/./gtkcolorchooserwidget.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2012 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_COLOR_CHOOSER_WIDGET_H__
#define __GTK_COLOR_CHOOSER_WIDGET_H__



#include <gtk/gtkbox.h>

G_BEGIN_DECLS

#define GTK_TYPE_COLOR_CHOOSER_WIDGET()              (gtk_color_chooser_widget_get_type ())
#define GTK_COLOR_CHOOSER_WIDGET(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_COLOR_CHOOSER_WIDGET, GtkColorChooserWidget))
#define GTK_COLOR_CHOOSER_WIDGET_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_COLOR_CHOOSER_WIDGET, GtkColorChooserWidgetClass))
#define GTK_IS_COLOR_CHOOSER_WIDGET(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_COLOR_CHOOSER_WIDGET))
#define GTK_IS_COLOR_CHOOSER_WIDGET_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_COLOR_CHOOSER_WIDGET))
#define GTK_COLOR_CHOOSER_WIDGET_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_COLOR_CHOOSER_WIDGET, GtkColorChooserWidgetClass))

typedef struct GtkComboBoxTextPrivate{} GtkComboBoxTextPrivate;


/**
 * GtkColorChooserWidgetClass:
 * @parent_class: The parent class.
 */
struct GtkComboBoxText
{
  /*< private >*/
  GtkComboBox parent_instance;

  GtkComboBoxTextPrivate *priv;
};
struct GtkComboBoxTextClass
{
  GtkComboBoxClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_4
GType       gtk_color_chooser_widget_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_4
GtkWidget * gtk_color_chooser_widget_new      (void);

G_END_DECLS

#endif /* __GTK_COLOR_CHOOSER_WIDGET_H__ */
#define headerfilename "gtk/./gtkcolorutils.h"
/* file: gtk/./gtkcolorutils.h */
/* Color utilties
 *
 * Copyright (C) 1999 The Free Software Foundation
 *
 * Authors: Simon Budig <Simon.Budig@unix-ag.org> (original code)
 *          Federico Mena-Quintero <federico@gimp.org> (cleanup for GTK+)
 *          Jonathan Blandford <jrb@redhat.com> (cleanup for GTK+)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_COLOR_UTILS_H__
#define __GTK_COLOR_UTILS_H__



#include <glib.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

GDK_AVAILABLE_IN_ALL
void gtk_hsv_to_rgb (gdouble  h, gdouble  s, gdouble  v,
                     gdouble *r, gdouble *g, gdouble *b);
GDK_AVAILABLE_IN_ALL
void gtk_rgb_to_hsv (gdouble  r, gdouble  g, gdouble  b,
                     gdouble *h, gdouble *s, gdouble *v);

G_END_DECLS

#endif /* __GTK_COLOR_UTILS_H__ */
#define headerfilename "gtk/./gtkcomboboxtext.h"
/* file: gtk/./gtkcomboboxtext.h */
/* GTK - The GIMP Toolkit
 *
 * Copyright (C) 2010 Christian Dywan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_COMBO_BOX_TEXT_H__
#define __GTK_COMBO_BOX_TEXT_H__



#include <gtk/gtkcombobox.h>

G_BEGIN_DECLS

#define GTK_TYPE_COMBO_BOX_TEXT()                 (gtk_combo_box_text_get_type ())
#define GTK_COMBO_BOX_TEXT(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_COMBO_BOX_TEXT, GtkComboBoxText))
#define GTK_COMBO_BOX_TEXT_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_COMBO_BOX_TEXT, GtkComboBoxTextClass))
#define GTK_IS_COMBO_BOX_TEXT(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_COMBO_BOX_TEXT))
#define GTK_IS_COMBO_BOX_TEXT_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_COMBO_BOX_TEXT))
#define GTK_COMBO_BOX_TEXT_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_COMBO_BOX_TEXT, GtkComboBoxTextClass))




GDK_AVAILABLE_IN_ALL
GType         gtk_combo_box_text_get_type        (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget*    gtk_combo_box_text_new             (void);
GDK_AVAILABLE_IN_ALL
GtkWidget*    gtk_combo_box_text_new_with_entry  (void);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_text_append_text     (GtkComboBoxText     *combo_box,
                                                  const char         *text);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_text_insert_text     (GtkComboBoxText     *combo_box,
                                                  gint                 position,
                                                  const char         *text);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_text_prepend_text    (GtkComboBoxText     *combo_box,
                                                  const char         *text);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_text_remove          (GtkComboBoxText     *combo_box,
                                                  gint                 position);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_text_remove_all      (GtkComboBoxText     *combo_box);
GDK_AVAILABLE_IN_ALL
char        *gtk_combo_box_text_get_active_text (GtkComboBoxText     *combo_box);

GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_text_insert          (GtkComboBoxText     *combo_box,
                                                  gint                 position,
                                                  const char         *id,
                                                  const char         *text);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_text_append          (GtkComboBoxText     *combo_box,
                                                  const char         *id,
                                                  const char         *text);
GDK_AVAILABLE_IN_ALL
void          gtk_combo_box_text_prepend         (GtkComboBoxText     *combo_box,
                                                  const char         *id,
                                                  const char         *text);

G_END_DECLS

#endif /* __GTK_COMBO_BOX_TEXT_H__ */
#define headerfilename "gtk/./gtkcsssection.h"
/* file: gtk/./gtkcsssection.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2011 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CSS_SECTION_H__
#define __GTK_CSS_SECTION_H__

#include <gio/gio.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define GTK_TYPE_CSS_SECTION()         (gtk_css_section_get_type ())

/**
 * GtkCssSectionType:
 * @GTK_CSS_SECTION_DOCUMENT: The section describes a complete document.
 *   This section time is the only one where gtk_css_section_get_parent()
 *   might return %NULL.
 * @GTK_CSS_SECTION_IMPORT: The section defines an import rule.
 * @GTK_CSS_SECTION_COLOR_DEFINITION: The section defines a color. This
 *   is a GTK extension to CSS.
 * @GTK_CSS_SECTION_BINDING_SET: The section defines a binding set. This
 *   is a GTK extension to CSS.
 * @GTK_CSS_SECTION_RULESET: The section defines a CSS ruleset.
 * @GTK_CSS_SECTION_SELECTOR: The section defines a CSS selector.
 * @GTK_CSS_SECTION_DECLARATION: The section defines the declaration of
 *   a CSS variable.
 * @GTK_CSS_SECTION_VALUE: The section defines the value of a CSS declaration.
 * @GTK_CSS_SECTION_KEYFRAMES: The section defines keyframes. See [CSS
 *   Animations](http://dev.w3.org/csswg/css3-animations/#keyframes) for details. Since 3.6
 *
 * The different types of sections indicate parts of a CSS document as
 * parsed by GTK’s CSS parser. They are oriented towards the
 * [CSS Grammar](http://www.w3.org/TR/CSS21/grammar.html),
 * but may contain extensions.
 *
 * More types might be added in the future as the parser incorporates
 * more features.
 *
 * Since: 3.2
 */
typedef enum
{
  GTK_CSS_SECTION_DOCUMENT,
  GTK_CSS_SECTION_IMPORT,
  GTK_CSS_SECTION_COLOR_DEFINITION,
  GTK_CSS_SECTION_BINDING_SET,
  GTK_CSS_SECTION_RULESET,
  GTK_CSS_SECTION_SELECTOR,
  GTK_CSS_SECTION_DECLARATION,
  GTK_CSS_SECTION_VALUE,
  GTK_CSS_SECTION_KEYFRAMES
} GtkCssSectionType;
typedef struct GtkCssProviderPrivate{} GtkCssProviderPrivate;
struct GtkCssProvider
{
  GObject parent_instance;
  GtkCssProviderPrivate *priv;
};
typedef struct _GtkCssSection{} GtkCssSection;
struct GtkCssProviderClass
{
  GObjectClass parent_class;

  void (* parsing_error)                        (GtkCssProvider  *provider,
                                                 GtkCssSection   *section,
                                                 const GError *   error);

  /* Padding for future expansion */
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

/**
 * GtkCssSection:
 *
 * GtkCssSection is an auxiliary object containing information about
 * the results of parsing a CSS style sheet.
 */

GDK_AVAILABLE_IN_3_2
GType              gtk_css_section_get_type            (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_2
GtkCssSection *    gtk_css_section_ref                 (GtkCssSection        *section);
GDK_AVAILABLE_IN_3_2
void               gtk_css_section_unref               (GtkCssSection        *section);

GDK_AVAILABLE_IN_3_2
GtkCssSectionType  gtk_css_section_get_section_type    (const GtkCssSection  *section);
GDK_AVAILABLE_IN_3_2
GtkCssSection *    gtk_css_section_get_parent          (const GtkCssSection  *section);
GDK_AVAILABLE_IN_3_2
GFile *            gtk_css_section_get_file            (const GtkCssSection  *section);
GDK_AVAILABLE_IN_3_2
guint              gtk_css_section_get_start_line      (const GtkCssSection  *section);
GDK_AVAILABLE_IN_3_2
guint              gtk_css_section_get_start_position  (const GtkCssSection  *section);
GDK_AVAILABLE_IN_3_2
guint              gtk_css_section_get_end_line        (const GtkCssSection  *section);
GDK_AVAILABLE_IN_3_2
guint              gtk_css_section_get_end_position    (const GtkCssSection  *section);

G_END_DECLS

#endif /* __GTK_CSS_SECTION_H__ */
#define headerfilename "gtk/./gtkcssprovider.h"
/* file: gtk/./gtkcssprovider.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2010 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_CSS_PROVIDER_H__
#define __GTK_CSS_PROVIDER_H__

#include <gio/gio.h>
#include <gtk/gtkcsssection.h>

G_BEGIN_DECLS

#define GTK_TYPE_CSS_PROVIDER()         (gtk_css_provider_get_type ())
#define GTK_CSS_PROVIDER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_CSS_PROVIDER, GtkCssProvider))
#define GTK_CSS_PROVIDER_CLASS(c)     (G_TYPE_CHECK_CLASS_CAST    ((c), GTK_TYPE_CSS_PROVIDER, GtkCssProviderClass))
#define GTK_IS_CSS_PROVIDER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_CSS_PROVIDER))
#define GTK_IS_CSS_PROVIDER_CLASS(c)  (G_TYPE_CHECK_CLASS_TYPE    ((c), GTK_TYPE_CSS_PROVIDER))
#define GTK_CSS_PROVIDER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS  ((o), GTK_TYPE_CSS_PROVIDER, GtkCssProviderClass))

/**
 * GTK_CSS_PROVIDER_ERROR:
 *
 * Domain for #GtkCssProvider errors.
 */
#define GTK_CSS_PROVIDER_ERROR() (gtk_css_provider_error_quark ())

/**
 * GtkCssProviderError:
 * @GTK_CSS_PROVIDER_ERROR_FAILED: Failed.
 * @GTK_CSS_PROVIDER_ERROR_SYNTAX: Syntax error.
 * @GTK_CSS_PROVIDER_ERROR_IMPORT: Import error.
 * @GTK_CSS_PROVIDER_ERROR_NAME: Name error.
 * @GTK_CSS_PROVIDER_ERROR_DEPRECATED: Deprecation error.
 * @GTK_CSS_PROVIDER_ERROR_UNKNOWN_VALUE: Unknown value.
 *
 * Error codes for %GTK_CSS_PROVIDER_ERROR.
 */
typedef enum
{
  GTK_CSS_PROVIDER_ERROR_FAILED,
  GTK_CSS_PROVIDER_ERROR_SYNTAX,
  GTK_CSS_PROVIDER_ERROR_IMPORT,
  GTK_CSS_PROVIDER_ERROR_NAME,
  GTK_CSS_PROVIDER_ERROR_DEPRECATED,
  GTK_CSS_PROVIDER_ERROR_UNKNOWN_VALUE
} GtkCssProviderError;

GDK_AVAILABLE_IN_ALL
GQuark gtk_css_provider_error_quark (void);




GDK_AVAILABLE_IN_ALL
GType gtk_css_provider_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkCssProvider * gtk_css_provider_new (void);

GDK_AVAILABLE_IN_3_2
char *           gtk_css_provider_to_string      (GtkCssProvider  *provider);

GDK_AVAILABLE_IN_ALL
gboolean         gtk_css_provider_load_from_data (GtkCssProvider  *css_provider,
                                                  const char     *data,
                                                  gssize           length,
                                                  GError         **error);
GDK_AVAILABLE_IN_ALL
gboolean         gtk_css_provider_load_from_file (GtkCssProvider  *css_provider,
                                                  GFile           *file,
                                                  GError         **error);
GDK_AVAILABLE_IN_ALL
gboolean         gtk_css_provider_load_from_path (GtkCssProvider  *css_provider,
                                                  const char     *path,
                                                  GError         **error);

GDK_AVAILABLE_IN_3_16
void             gtk_css_provider_load_from_resource (GtkCssProvider *css_provider,
                                                      const char    *resource_path);

GDK_AVAILABLE_IN_ALL
GtkCssProvider * gtk_css_provider_get_default (void);

GDK_AVAILABLE_IN_ALL
GtkCssProvider * gtk_css_provider_get_named (const char *name,
                                             const char *variant);

G_END_DECLS

#endif /* __GTK_CSS_PROVIDER_H__ */
#define headerfilename "gtk/./gtkdebug.h"
/* file: gtk/./gtkdebug.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_DEBUG_H__
#define __GTK_DEBUG_H__



#include <glib.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

typedef enum {
  GTK_DEBUG_MISC            = 1 << 0,
  GTK_DEBUG_PLUGSOCKET      = 1 << 1,
  GTK_DEBUG_TEXT            = 1 << 2,
  GTK_DEBUG_TREE            = 1 << 3,
  GTK_DEBUG_UPDATES         = 1 << 4,
  GTK_DEBUG_KEYBINDINGS     = 1 << 5,
  GTK_DEBUG_MULTIHEAD       = 1 << 6,
  GTK_DEBUG_MODULES         = 1 << 7,
  GTK_DEBUG_GEOMETRY        = 1 << 8,
  GTK_DEBUG_ICONTHEME       = 1 << 9,
  GTK_DEBUG_PRINTING        = 1 << 10,
  GTK_DEBUG_BUILDER         = 1 << 11,
  GTK_DEBUG_SIZE_REQUEST    = 1 << 12,
  GTK_DEBUG_NO_CSS_CACHE    = 1 << 13,
  GTK_DEBUG_BASELINES       = 1 << 14,
  GTK_DEBUG_PIXEL_CACHE     = 1 << 15,
  GTK_DEBUG_NO_PIXEL_CACHE  = 1 << 16,
  GTK_DEBUG_INTERACTIVE     = 1 << 17,
  GTK_DEBUG_TOUCHSCREEN     = 1 << 18,
  GTK_DEBUG_ACTIONS         = 1 << 19,
  GTK_DEBUG_RESIZE          = 1 << 20,
  GTK_DEBUG_LAYOUT          = 1 << 21
} GtkDebugFlag;
struct GtkDrawingArea
{
  GtkWidget widget;

  /*< private >*/
  gpointer dummy;
};
struct GtkDrawingAreaClass
{
  GtkWidgetClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};
typedef struct GtkEventBoxPrivate{} GtkEventBoxPrivate;

GDK_AVAILABLE_IN_ALL
guint gtk_get_debug_flags (void);
GDK_AVAILABLE_IN_ALL
void  gtk_set_debug_flags  (guint flags);

G_END_DECLS

#endif /* __GTK_DEBUG_H__ */
#define headerfilename "gtk/./gtkdragsource.h"
/* file: gtk/./gtkdragsource.h */
/* -*- Mode: C; c-file-style: "gnu"; tab-width: 8 -*- */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_DRAG_SOURCE_H__
#define __GTK_DRAG_SOURCE_H__




#include <gtk/gtkselection.h>
#include <gtk/gtkwidget.h>


G_BEGIN_DECLS

GDK_AVAILABLE_IN_ALL
void gtk_drag_source_set  (GtkWidget            *widget,
			   GdkModifierType       start_button_mask,
			   const GtkTargetEntry *targets,
			   gint                  n_targets,
			   GdkDragAction         actions);

GDK_AVAILABLE_IN_ALL
void gtk_drag_source_unset (GtkWidget        *widget);

GDK_AVAILABLE_IN_ALL
GtkTargetList* gtk_drag_source_get_target_list (GtkWidget     *widget);
GDK_AVAILABLE_IN_ALL
void           gtk_drag_source_set_target_list (GtkWidget     *widget,
                                                GtkTargetList *target_list);
GDK_AVAILABLE_IN_ALL
void           gtk_drag_source_add_text_targets  (GtkWidget     *widget);
GDK_AVAILABLE_IN_ALL
void           gtk_drag_source_add_image_targets (GtkWidget    *widget);
GDK_AVAILABLE_IN_ALL
void           gtk_drag_source_add_uri_targets   (GtkWidget    *widget);

GDK_AVAILABLE_IN_ALL
void gtk_drag_source_set_icon_pixbuf  (GtkWidget       *widget,
				       GdkPixbuf       *pixbuf);
GDK_DEPRECATED_IN_3_10_FOR(gtk_drag_source_set_icon_name)
void gtk_drag_source_set_icon_stock   (GtkWidget       *widget,
				       const char     *stock_id);
GDK_AVAILABLE_IN_ALL
void gtk_drag_source_set_icon_name    (GtkWidget       *widget,
				       const char     *icon_name);
GDK_AVAILABLE_IN_3_2
void gtk_drag_source_set_icon_gicon   (GtkWidget       *widget,
				       GIcon           *icon);


G_END_DECLS

#endif /* __GTK_DRAG_SOURCE_H__ */
#define headerfilename "gtk/./gtkdrawingarea.h"
/* file: gtk/./gtkdrawingarea.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_DRAWING_AREA_H__
#define __GTK_DRAWING_AREA_H__




#include <gtk/gtkwidget.h>


G_BEGIN_DECLS

#define GTK_TYPE_DRAWING_AREA()            (gtk_drawing_area_get_type ())
#define GTK_DRAWING_AREA(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_DRAWING_AREA, GtkDrawingArea))
#define GTK_DRAWING_AREA_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_DRAWING_AREA, GtkDrawingAreaClass))
#define GTK_IS_DRAWING_AREA(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_DRAWING_AREA))
#define GTK_IS_DRAWING_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_DRAWING_AREA))
#define GTK_DRAWING_AREA_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_DRAWING_AREA, GtkDrawingAreaClass))




struct GtkEventBox
{
  GtkBin bin;

  /*< private >*/
  GtkEventBoxPrivate *priv;
};
struct GtkEventBoxClass
{
  GtkBinClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType      gtk_drawing_area_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_drawing_area_new      (void);

G_END_DECLS

#endif /* __GTK_DRAWING_AREA_H__ */
#define headerfilename "gtk/./gtkeventbox.h"
/* file: gtk/./gtkeventbox.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_EVENT_BOX_H__
#define __GTK_EVENT_BOX_H__




#include <gtk/gtkbin.h>


G_BEGIN_DECLS

#define GTK_TYPE_EVENT_BOX()              (gtk_event_box_get_type ())
#define GTK_EVENT_BOX(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_EVENT_BOX, GtkEventBox))
#define GTK_EVENT_BOX_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_EVENT_BOX, GtkEventBoxClass))
#define GTK_IS_EVENT_BOX(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_EVENT_BOX))
#define GTK_IS_EVENT_BOX_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_EVENT_BOX))
#define GTK_EVENT_BOX_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_EVENT_BOX, GtkEventBoxClass))

typedef struct GtkExpanderPrivate{} GtkExpanderPrivate;


/**
 * GtkEventBoxClass:
 * @parent_class: The parent class.
 */
struct GtkExpander
{
  GtkBin              bin;

  GtkExpanderPrivate *priv;
};
struct GtkExpanderClass
{
  GtkBinClass    parent_class;

  /*< public >*/

  /* Key binding signal; to get notification on the expansion
   * state connect to notify:expanded.
   */
  void        (* activate) (GtkExpander *expander);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType      gtk_event_box_get_type           (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_event_box_new                (void);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_event_box_get_visible_window (GtkEventBox *event_box);
GDK_AVAILABLE_IN_ALL
void       gtk_event_box_set_visible_window (GtkEventBox *event_box,
                                             gboolean     visible_window);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_event_box_get_above_child    (GtkEventBox *event_box);
GDK_AVAILABLE_IN_ALL
void       gtk_event_box_set_above_child    (GtkEventBox *event_box,
                                             gboolean     above_child);

G_END_DECLS

#endif /* __GTK_EVENT_BOX_H__ */
#define headerfilename "gtk/./gtkeventcontroller.h"
/* file: gtk/./gtkeventcontroller.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2012, One Laptop Per Child.
 * Copyright (C) 2014, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */
#ifndef __GTK_EVENT_CONTROLLER_H__
#define __GTK_EVENT_CONTROLLER_H__



typedef struct _GtkEventController{} GtkEventController;
typedef struct _GtkEventControllerClass{} GtkEventControllerClass;

#include <gdk/gdk.h>
#include <gtk/gtktypes.h>
#include <gtk/gtkenums.h>

G_BEGIN_DECLS

#define GTK_TYPE_EVENT_CONTROLLER()         (gtk_event_controller_get_type ())
#define GTK_EVENT_CONTROLLER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_EVENT_CONTROLLER, GtkEventController))
#define GTK_EVENT_CONTROLLER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_EVENT_CONTROLLER, GtkEventControllerClass))
#define GTK_IS_EVENT_CONTROLLER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_EVENT_CONTROLLER))
#define GTK_IS_EVENT_CONTROLLER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_EVENT_CONTROLLER))
#define GTK_EVENT_CONTROLLER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_EVENT_CONTROLLER, GtkEventControllerClass))


GDK_AVAILABLE_IN_3_14
GType        gtk_event_controller_get_type       (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
GtkWidget  * gtk_event_controller_get_widget     (GtkEventController *controller);

GDK_AVAILABLE_IN_3_14
gboolean     gtk_event_controller_handle_event   (GtkEventController *controller,
                                                  const GdkEvent     *event);
GDK_AVAILABLE_IN_3_14
void         gtk_event_controller_reset          (GtkEventController *controller);

GDK_AVAILABLE_IN_3_14
GtkPropagationPhase gtk_event_controller_get_propagation_phase (GtkEventController *controller);

GDK_AVAILABLE_IN_3_14
void                gtk_event_controller_set_propagation_phase (GtkEventController  *controller,
                                                                GtkPropagationPhase  phase);

G_END_DECLS

#endif /* __GTK_EVENT_CONTROLLER_H__ */
#define headerfilename "gtk/./gtkexpander.h"
/* file: gtk/./gtkexpander.h */
/* GTK - The GIMP Toolkit
 *
 * Copyright (C) 2003 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *	Mark McLoughlin <mark@skynet.ie>
 */

#ifndef __GTK_EXPANDER_H__
#define __GTK_EXPANDER_H__



#include <gtk/gtkbin.h>

G_BEGIN_DECLS

#define GTK_TYPE_EXPANDER()            (gtk_expander_get_type ())
#define GTK_EXPANDER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_EXPANDER, GtkExpander))
#define GTK_EXPANDER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_EXPANDER, GtkExpanderClass))
#define GTK_IS_EXPANDER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_EXPANDER))
#define GTK_IS_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_EXPANDER))
#define GTK_EXPANDER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_EXPANDER, GtkExpanderClass))

typedef struct GtkFixedPrivate{} GtkFixedPrivate;


/**
 * GtkExpanderClass:
 * @parent_class: The parent class.
 * @activate: Keybinding signal is emitted when the user hits the Enter key.
 */
struct GtkFixed
{
  GtkContainer container;

  /*< private >*/
  GtkFixedPrivate *priv;
};
struct GtkFixedClass
{
  GtkContainerClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType                 gtk_expander_get_type            (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget            *gtk_expander_new                 (const char *label);
GDK_AVAILABLE_IN_ALL
GtkWidget            *gtk_expander_new_with_mnemonic   (const char *label);

GDK_AVAILABLE_IN_ALL
void                  gtk_expander_set_expanded        (GtkExpander *expander,
                                                        gboolean     expanded);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_expander_get_expanded        (GtkExpander *expander);

/* Spacing between the expander/label and the child */
GDK_AVAILABLE_IN_ALL
void                  gtk_expander_set_spacing         (GtkExpander *expander,
                                                        gint         spacing);
GDK_AVAILABLE_IN_ALL
gint                  gtk_expander_get_spacing         (GtkExpander *expander);

GDK_AVAILABLE_IN_ALL
void                  gtk_expander_set_label           (GtkExpander *expander,
                                                        const char *label);
GDK_AVAILABLE_IN_ALL
const char *         gtk_expander_get_label           (GtkExpander *expander);

GDK_AVAILABLE_IN_ALL
void                  gtk_expander_set_use_underline   (GtkExpander *expander,
                                                        gboolean     use_underline);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_expander_get_use_underline   (GtkExpander *expander);

GDK_AVAILABLE_IN_ALL
void                  gtk_expander_set_use_markup      (GtkExpander *expander,
                                                        gboolean    use_markup);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_expander_get_use_markup      (GtkExpander *expander);

GDK_AVAILABLE_IN_ALL
void                  gtk_expander_set_label_widget    (GtkExpander *expander,
						        GtkWidget   *label_widget);
GDK_AVAILABLE_IN_ALL
GtkWidget            *gtk_expander_get_label_widget    (GtkExpander *expander);
GDK_AVAILABLE_IN_ALL
void                  gtk_expander_set_label_fill      (GtkExpander *expander,
						        gboolean     label_fill);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_expander_get_label_fill      (GtkExpander *expander);
GDK_AVAILABLE_IN_3_2
void                  gtk_expander_set_resize_toplevel (GtkExpander *expander,
                                                        gboolean     resize_toplevel);
GDK_AVAILABLE_IN_3_2
gboolean              gtk_expander_get_resize_toplevel (GtkExpander *expander);

G_END_DECLS

#endif /* __GTK_EXPANDER_H__ */
#define headerfilename "gtk/./gtkfixed.h"
/* file: gtk/./gtkfixed.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_FIXED_H__
#define __GTK_FIXED_H__




#include <gtk/gtkcontainer.h>


G_BEGIN_DECLS

#define GTK_TYPE_FIXED()                  (gtk_fixed_get_type ())
#define GTK_FIXED(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FIXED, GtkFixed))
#define GTK_FIXED_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FIXED, GtkFixedClass))
#define GTK_IS_FIXED(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FIXED))
#define GTK_IS_FIXED_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FIXED))
#define GTK_FIXED_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FIXED, GtkFixedClass))




struct GtkFixedChild
{
  GtkWidget *widget;
  gint x;
  gint y;
};
typedef struct _GtkFileFilter{} GtkFileFilter;


GDK_AVAILABLE_IN_ALL
GType      gtk_fixed_get_type          (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_fixed_new               (void);
GDK_AVAILABLE_IN_ALL
void       gtk_fixed_put               (GtkFixed       *fixed,
                                        GtkWidget      *widget,
                                        gint            x,
                                        gint            y);
GDK_AVAILABLE_IN_ALL
void       gtk_fixed_move              (GtkFixed       *fixed,
                                        GtkWidget      *widget,
                                        gint            x,
                                        gint            y);


G_END_DECLS

#endif /* __GTK_FIXED_H__ */
#define headerfilename "gtk/./gtkfilefilter.h"
/* file: gtk/./gtkfilefilter.h */
/* GTK - The GIMP Toolkit
 * gtkfilefilter.h: Filters for selecting a file subset
 * Copyright (C) 2003, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_FILE_FILTER_H__
#define __GTK_FILE_FILTER_H__



#include <glib-object.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define GTK_TYPE_FILE_FILTER()              (gtk_file_filter_get_type ())
#define GTK_FILE_FILTER(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FILE_FILTER, GtkFileFilter))
#define GTK_IS_FILE_FILTER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FILE_FILTER))


/**
 * GtkFileFilterFlags:
 * @GTK_FILE_FILTER_FILENAME: the filename of the file being tested
 * @GTK_FILE_FILTER_URI: the URI for the file being tested
 * @GTK_FILE_FILTER_DISPLAY_NAME: the string that will be used to 
 *   display the file in the file chooser
 * @GTK_FILE_FILTER_MIME_TYPE: the mime type of the file
 * 
 * These flags indicate what parts of a #GtkFileFilterInfo struct
 * are filled or need to be filled. 
 */
typedef enum {
  GTK_FILE_FILTER_FILENAME     = 1 << 0,
  GTK_FILE_FILTER_URI          = 1 << 1,
  GTK_FILE_FILTER_DISPLAY_NAME = 1 << 2,
  GTK_FILE_FILTER_MIME_TYPE    = 1 << 3
} GtkFileFilterFlags;
struct GtkFileFilterInfo
{
  GtkFileFilterFlags contains;

  const char *filename;
  const char *uri;
  const char *display_name;
  const char *mime_type;
};
typedef struct _GtkFileChooser{} GtkFileChooser;

/**
 * GtkFileFilterFunc:
 * @filter_info: a #GtkFileFilterInfo that is filled according
 *   to the @needed flags passed to gtk_file_filter_add_custom()
 * @data: (closure): user data passed to gtk_file_filter_add_custom()
 *
 * The type of function that is used with custom filters, see
 * gtk_file_filter_add_custom().
 *
 * Returns: %TRUE if the file should be displayed
 */
typedef gboolean (*GtkFileFilterFunc) (const GtkFileFilterInfo *filter_info,
				       gpointer                 data);

/**
 * GtkFileFilterInfo:
 * @contains: Flags indicating which of the following fields need
 *   are filled
 * @filename: the filename of the file being tested
 * @uri: the URI for the file being tested
 * @display_name: the string that will be used to display the file
 *   in the file chooser
 * @mime_type: the mime type of the file
 *
 * A #GtkFileFilterInfo-struct is used to pass information about the
 * tested file to gtk_file_filter_filter().
 */

GDK_AVAILABLE_IN_ALL
GType gtk_file_filter_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkFileFilter *       gtk_file_filter_new      (void);
GDK_AVAILABLE_IN_ALL
void                  gtk_file_filter_set_name (GtkFileFilter *filter,
						const char   *name);
GDK_AVAILABLE_IN_ALL
const char *         gtk_file_filter_get_name (GtkFileFilter *filter);

GDK_AVAILABLE_IN_ALL
void gtk_file_filter_add_mime_type      (GtkFileFilter      *filter,
					 const char        *mime_type);
GDK_AVAILABLE_IN_ALL
void gtk_file_filter_add_pattern        (GtkFileFilter      *filter,
					 const char        *pattern);
GDK_AVAILABLE_IN_ALL
void gtk_file_filter_add_pixbuf_formats (GtkFileFilter      *filter);
GDK_AVAILABLE_IN_ALL
void gtk_file_filter_add_custom         (GtkFileFilter      *filter,
					 GtkFileFilterFlags  needed,
					 GtkFileFilterFunc   func,
					 gpointer            data,
					 GDestroyNotify      notify);

GDK_AVAILABLE_IN_ALL
GtkFileFilterFlags gtk_file_filter_get_needed (GtkFileFilter           *filter);
GDK_AVAILABLE_IN_ALL
gboolean           gtk_file_filter_filter     (GtkFileFilter           *filter,
					       const GtkFileFilterInfo *filter_info);

G_END_DECLS

#endif /* __GTK_FILE_FILTER_H__ */
#define headerfilename "gtk/./gtkfilechooser.h"
/* file: gtk/./gtkfilechooser.h */
/* GTK - The GIMP Toolkit
 * gtkfilechooser.h: Abstract interface for file selector GUIs
 * Copyright (C) 2003, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_FILE_CHOOSER_H__
#define __GTK_FILE_CHOOSER_H__



#include <gtk/gtkfilefilter.h>
#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_FILE_CHOOSER()             (gtk_file_chooser_get_type ())
#define GTK_FILE_CHOOSER(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FILE_CHOOSER, GtkFileChooser))
#define GTK_IS_FILE_CHOOSER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FILE_CHOOSER))


/**
 * GtkFileChooserAction:
 * @GTK_FILE_CHOOSER_ACTION_OPEN: Indicates open mode.  The file chooser
 *  will only let the user pick an existing file.
 * @GTK_FILE_CHOOSER_ACTION_SAVE: Indicates save mode.  The file chooser
 *  will let the user pick an existing file, or type in a new
 *  filename.
 * @GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER: Indicates an Open mode for
 *  selecting folders.  The file chooser will let the user pick an
 *  existing folder.
 * @GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER: Indicates a mode for creating a
 *  new folder.  The file chooser will let the user name an existing or
 *  new folder.
 *
 * Describes whether a #GtkFileChooser is being used to open existing files
 * or to save to a possibly new file.
 */
typedef enum
{
  GTK_FILE_CHOOSER_ACTION_OPEN,
  GTK_FILE_CHOOSER_ACTION_SAVE,
  GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
  GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER
} GtkFileChooserAction;

/**
 * GtkFileChooserConfirmation:
 * @GTK_FILE_CHOOSER_CONFIRMATION_CONFIRM: The file chooser will present
 *  its stock dialog to confirm about overwriting an existing file.
 * @GTK_FILE_CHOOSER_CONFIRMATION_ACCEPT_FILENAME: The file chooser will
 *  terminate and accept the user’s choice of a file name.
 * @GTK_FILE_CHOOSER_CONFIRMATION_SELECT_AGAIN: The file chooser will
 *  continue running, so as to let the user select another file name.
 *
 * Used as a return value of handlers for the
 * #GtkFileChooser::confirm-overwrite signal of a #GtkFileChooser. This
 * value determines whether the file chooser will present the stock
 * confirmation dialog, accept the user’s choice of a filename, or
 * let the user choose another filename.
 *
 * Since: 2.8
 */
typedef enum
{
  GTK_FILE_CHOOSER_CONFIRMATION_CONFIRM,
  GTK_FILE_CHOOSER_CONFIRMATION_ACCEPT_FILENAME,
  GTK_FILE_CHOOSER_CONFIRMATION_SELECT_AGAIN
} GtkFileChooserConfirmation;

GDK_AVAILABLE_IN_ALL
GType gtk_file_chooser_get_type (void) G_GNUC_CONST;

/* GError enumeration for GtkFileChooser */
/**
 * GTK_FILE_CHOOSER_ERROR:
 *
 * Used to get the #GError quark for #GtkFileChooser errors.
 */
#define GTK_FILE_CHOOSER_ERROR() (gtk_file_chooser_error_quark ())

/**
 * GtkFileChooserError:
 * @GTK_FILE_CHOOSER_ERROR_NONEXISTENT: Indicates that a file does not exist.
 * @GTK_FILE_CHOOSER_ERROR_BAD_FILENAME: Indicates a malformed filename.
 * @GTK_FILE_CHOOSER_ERROR_ALREADY_EXISTS: Indicates a duplicate path (e.g. when
 *  adding a bookmark).
 * @GTK_FILE_CHOOSER_ERROR_INCOMPLETE_HOSTNAME: Indicates an incomplete hostname (e.g. "http://foo" without a slash after that).
 *
 * These identify the various errors that can occur while calling
 * #GtkFileChooser functions.
 */
typedef enum {
  GTK_FILE_CHOOSER_ERROR_NONEXISTENT,
  GTK_FILE_CHOOSER_ERROR_BAD_FILENAME,
  GTK_FILE_CHOOSER_ERROR_ALREADY_EXISTS,
  GTK_FILE_CHOOSER_ERROR_INCOMPLETE_HOSTNAME
} GtkFileChooserError;
typedef struct GtkFileChooserButtonPrivate{} GtkFileChooserButtonPrivate;
struct GtkFileChooserButton
{
  GtkBox parent;

  /*< private >*/
  GtkFileChooserButtonPrivate *priv;
};
struct GtkFileChooserButtonClass
{
  GtkBoxClass parent_class;

  /*< public >*/

  void (* file_set) (GtkFileChooserButton *fc);

  /*< private >*/

  /* Padding for future expansion */
  void (*__gtk_reserved1);
  void (*__gtk_reserved2);
  void (*__gtk_reserved3);
  void (*__gtk_reserved4);
};

GDK_AVAILABLE_IN_ALL
GQuark gtk_file_chooser_error_quark (void);

/* Configuration
 */
GDK_AVAILABLE_IN_ALL
void                 gtk_file_chooser_set_action          (GtkFileChooser       *chooser,
							   GtkFileChooserAction  action);
GDK_AVAILABLE_IN_ALL
GtkFileChooserAction gtk_file_chooser_get_action          (GtkFileChooser       *chooser);
GDK_AVAILABLE_IN_ALL
void                 gtk_file_chooser_set_local_only      (GtkFileChooser       *chooser,
							   gboolean              local_only);
GDK_AVAILABLE_IN_ALL
gboolean             gtk_file_chooser_get_local_only      (GtkFileChooser       *chooser);
GDK_AVAILABLE_IN_ALL
void                 gtk_file_chooser_set_select_multiple (GtkFileChooser       *chooser,
							   gboolean              select_multiple);
GDK_AVAILABLE_IN_ALL
gboolean             gtk_file_chooser_get_select_multiple (GtkFileChooser       *chooser);
GDK_AVAILABLE_IN_ALL
void                 gtk_file_chooser_set_show_hidden     (GtkFileChooser       *chooser,
							   gboolean              show_hidden);
GDK_AVAILABLE_IN_ALL
gboolean             gtk_file_chooser_get_show_hidden     (GtkFileChooser       *chooser);

GDK_AVAILABLE_IN_ALL
void                 gtk_file_chooser_set_do_overwrite_confirmation (GtkFileChooser *chooser,
								     gboolean        do_overwrite_confirmation);
GDK_AVAILABLE_IN_ALL
gboolean             gtk_file_chooser_get_do_overwrite_confirmation (GtkFileChooser *chooser);

GDK_AVAILABLE_IN_ALL
void                 gtk_file_chooser_set_create_folders  (GtkFileChooser       *chooser,
							  gboolean               create_folders);
GDK_AVAILABLE_IN_ALL
gboolean             gtk_file_chooser_get_create_folders (GtkFileChooser *chooser);

/* Suggested name for the Save-type actions
 */
GDK_AVAILABLE_IN_ALL
void        gtk_file_chooser_set_current_name  (GtkFileChooser *chooser,
					        const char    *name);
GDK_AVAILABLE_IN_3_10
char *gtk_file_chooser_get_current_name (GtkFileChooser *chooser);

/* Filename manipulation
 */
GDK_AVAILABLE_IN_ALL
char *  gtk_file_chooser_get_filename       (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_set_filename       (GtkFileChooser *chooser,
					      const char     *filename);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_select_filename    (GtkFileChooser *chooser,
					      const char     *filename);
GDK_AVAILABLE_IN_ALL
void     gtk_file_chooser_unselect_filename  (GtkFileChooser *chooser,
					      const char     *filename);
GDK_AVAILABLE_IN_ALL
void     gtk_file_chooser_select_all         (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
void     gtk_file_chooser_unselect_all       (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
GSList * gtk_file_chooser_get_filenames      (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_set_current_folder (GtkFileChooser *chooser,
					      const char    *filename);
GDK_AVAILABLE_IN_ALL
char *  gtk_file_chooser_get_current_folder (GtkFileChooser *chooser);


/* URI manipulation
 */
GDK_AVAILABLE_IN_ALL
char *  gtk_file_chooser_get_uri                (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_set_uri                (GtkFileChooser *chooser,
						  const char     *uri);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_select_uri             (GtkFileChooser *chooser,
						  const char     *uri);
GDK_AVAILABLE_IN_ALL
void     gtk_file_chooser_unselect_uri           (GtkFileChooser *chooser,
						  const char     *uri);
GDK_AVAILABLE_IN_ALL
GSList * gtk_file_chooser_get_uris               (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_set_current_folder_uri (GtkFileChooser *chooser,
						  const char    *uri);
GDK_AVAILABLE_IN_ALL
char *  gtk_file_chooser_get_current_folder_uri (GtkFileChooser *chooser);

/* GFile manipulation */
GDK_AVAILABLE_IN_ALL
GFile *  gtk_file_chooser_get_file                (GtkFileChooser  *chooser);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_set_file                (GtkFileChooser  *chooser,
                                                   GFile           *file,
                                                   GError         **error);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_select_file             (GtkFileChooser  *chooser,
                                                   GFile           *file,
                                                   GError         **error);
GDK_AVAILABLE_IN_ALL
void     gtk_file_chooser_unselect_file           (GtkFileChooser  *chooser,
                                                   GFile           *file);
GDK_AVAILABLE_IN_ALL
GSList * gtk_file_chooser_get_files               (GtkFileChooser  *chooser);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_set_current_folder_file (GtkFileChooser  *chooser,
                                                   GFile           *file,
                                                   GError         **error);
GDK_AVAILABLE_IN_ALL
GFile *  gtk_file_chooser_get_current_folder_file (GtkFileChooser  *chooser);

/* Preview widget
 */
GDK_AVAILABLE_IN_ALL
void       gtk_file_chooser_set_preview_widget        (GtkFileChooser *chooser,
						       GtkWidget      *preview_widget);
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_file_chooser_get_preview_widget        (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
void       gtk_file_chooser_set_preview_widget_active (GtkFileChooser *chooser,
						       gboolean        active);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_file_chooser_get_preview_widget_active (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
void       gtk_file_chooser_set_use_preview_label     (GtkFileChooser *chooser,
						       gboolean        use_label);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_file_chooser_get_use_preview_label     (GtkFileChooser *chooser);

GDK_AVAILABLE_IN_ALL
char  *gtk_file_chooser_get_preview_filename (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
char  *gtk_file_chooser_get_preview_uri      (GtkFileChooser *chooser);
GDK_AVAILABLE_IN_ALL
GFile *gtk_file_chooser_get_preview_file     (GtkFileChooser *chooser);

/* Extra widget
 */
GDK_AVAILABLE_IN_ALL
void       gtk_file_chooser_set_extra_widget (GtkFileChooser *chooser,
					      GtkWidget      *extra_widget);
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_file_chooser_get_extra_widget (GtkFileChooser *chooser);

/* List of user selectable filters
 */
GDK_AVAILABLE_IN_ALL
void    gtk_file_chooser_add_filter    (GtkFileChooser *chooser,
					GtkFileFilter  *filter);
GDK_AVAILABLE_IN_ALL
void    gtk_file_chooser_remove_filter (GtkFileChooser *chooser,
					GtkFileFilter  *filter);
GDK_AVAILABLE_IN_ALL
GSList *gtk_file_chooser_list_filters  (GtkFileChooser *chooser);

/* Current filter
 */
GDK_AVAILABLE_IN_ALL
void           gtk_file_chooser_set_filter (GtkFileChooser *chooser,
					   GtkFileFilter  *filter);
GDK_AVAILABLE_IN_ALL
GtkFileFilter *gtk_file_chooser_get_filter (GtkFileChooser *chooser);

/* Per-application shortcut folders */

GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_add_shortcut_folder    (GtkFileChooser *chooser,
						  const char     *folder,
						  GError        **error);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_remove_shortcut_folder (GtkFileChooser *chooser,
						  const char     *folder,
						  GError        **error);
GDK_AVAILABLE_IN_ALL
GSList *gtk_file_chooser_list_shortcut_folders   (GtkFileChooser *chooser);

GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_add_shortcut_folder_uri    (GtkFileChooser *chooser,
						      const char     *uri,
						      GError        **error);
GDK_AVAILABLE_IN_ALL
gboolean gtk_file_chooser_remove_shortcut_folder_uri (GtkFileChooser *chooser,
						      const char     *uri,
						      GError        **error);
GDK_AVAILABLE_IN_ALL
GSList *gtk_file_chooser_list_shortcut_folder_uris   (GtkFileChooser *chooser);

G_END_DECLS

#endif /* __GTK_FILE_CHOOSER_H__ */
#define headerfilename "gtk/./gtkfilechooserbutton.h"
/* file: gtk/./gtkfilechooserbutton.h */
/* GTK+: gtkfilechooserbutton.h
 *
 * Copyright (c) 2004 James M. Cape <jcape@ignore-your.tv>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_FILE_CHOOSER_BUTTON_H__
#define __GTK_FILE_CHOOSER_BUTTON_H__



#include <gtk/gtkbox.h>
#include <gtk/gtkfilechooser.h>

G_BEGIN_DECLS

#define GTK_TYPE_FILE_CHOOSER_BUTTON()            (gtk_file_chooser_button_get_type ())
#define GTK_FILE_CHOOSER_BUTTON(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FILE_CHOOSER_BUTTON, GtkFileChooserButton))
#define GTK_FILE_CHOOSER_BUTTON_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FILE_CHOOSER_BUTTON, GtkFileChooserButtonClass))
#define GTK_IS_FILE_CHOOSER_BUTTON(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FILE_CHOOSER_BUTTON))
#define GTK_IS_FILE_CHOOSER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FILE_CHOOSER_BUTTON))
#define GTK_FILE_CHOOSER_BUTTON_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FILE_CHOOSER_BUTTON, GtkFileChooserButtonClass))

typedef struct GtkFileChooserDialogPrivate{} GtkFileChooserDialogPrivate;


/**
 * GtkFileChooserButtonClass:
 * @parent_class: The parent class.
 * @file_set: Signal emitted when the user selects a file.
 */
struct GtkFileChooserDialog
{
  GtkDialog parent_instance;

  GtkFileChooserDialogPrivate *priv;
};
struct GtkFileChooserDialogClass
{
  GtkDialogClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType                 gtk_file_chooser_button_get_type         (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget *           gtk_file_chooser_button_new              (const char          *title,
								GtkFileChooserAction  action);
GDK_AVAILABLE_IN_ALL
GtkWidget *           gtk_file_chooser_button_new_with_dialog  (GtkWidget            *dialog);
GDK_AVAILABLE_IN_ALL
const char *         gtk_file_chooser_button_get_title        (GtkFileChooserButton *button);
GDK_AVAILABLE_IN_ALL
void                  gtk_file_chooser_button_set_title        (GtkFileChooserButton *button,
								const char          *title);
GDK_AVAILABLE_IN_ALL
gint                  gtk_file_chooser_button_get_width_chars  (GtkFileChooserButton *button);
GDK_AVAILABLE_IN_ALL
void                  gtk_file_chooser_button_set_width_chars  (GtkFileChooserButton *button,
								gint                  n_chars);
GDK_DEPRECATED_IN_3_20_FOR(gtk_widget_get_focus_on_click)
gboolean              gtk_file_chooser_button_get_focus_on_click (GtkFileChooserButton *button);
GDK_DEPRECATED_IN_3_20_FOR(gtk_widget_set_focus_on_click)
void                  gtk_file_chooser_button_set_focus_on_click (GtkFileChooserButton *button,
                                                                  gboolean              focus_on_click);

G_END_DECLS

#endif /* !__GTK_FILE_CHOOSER_BUTTON_H__ */
#define headerfilename "gtk/./gtkfilechooserdialog.h"
/* file: gtk/./gtkfilechooserdialog.h */
/* GTK - The GIMP Toolkit
 * gtkfilechooserdialog.h: File selector dialog
 * Copyright (C) 2003, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_FILE_CHOOSER_DIALOG_H__
#define __GTK_FILE_CHOOSER_DIALOG_H__



#include <gtk/gtkdialog.h>
#include <gtk/gtkfilechooser.h>

G_BEGIN_DECLS

#define GTK_TYPE_FILE_CHOOSER_DIALOG()             (gtk_file_chooser_dialog_get_type ())
#define GTK_FILE_CHOOSER_DIALOG(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FILE_CHOOSER_DIALOG, GtkFileChooserDialog))
#define GTK_FILE_CHOOSER_DIALOG_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FILE_CHOOSER_DIALOG, GtkFileChooserDialogClass))
#define GTK_IS_FILE_CHOOSER_DIALOG(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FILE_CHOOSER_DIALOG))
#define GTK_IS_FILE_CHOOSER_DIALOG_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FILE_CHOOSER_DIALOG))
#define GTK_FILE_CHOOSER_DIALOG_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FILE_CHOOSER_DIALOG, GtkFileChooserDialogClass))




GDK_AVAILABLE_IN_ALL
GType      gtk_file_chooser_dialog_get_type         (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_file_chooser_dialog_new              (const char          *title,
						     GtkWindow            *parent,
						     GtkFileChooserAction  action,
						     const char          *first_button_text,
						     ...) G_GNUC_NULL_TERMINATED;

G_END_DECLS

#endif /* __GTK_FILE_CHOOSER_DIALOG_H__ */
#define headerfilename "gtk/./gtknativedialog.h"
/* file: gtk/./gtknativedialog.h */
/* GTK - The GIMP Toolkit
 * gtknativedialog.h: Native dialog
 * Copyright (C) 2015, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_NATIVE_DIALOG_H__
#define __GTK_NATIVE_DIALOG_H__



#include <gtk/gtkwindow.h>

G_BEGIN_DECLS

#define GTK_TYPE_NATIVE_DIALOG()             (gtk_native_dialog_get_type ())

GDK_AVAILABLE_IN_3_20
GType gtk_native_dialog_get_type (void);



struct GtkNativeDialog
{
	GObject parent_instance;
};
struct GtkNativeDialogClass
{
  GObjectClass parent_class;

  void (* response) (GtkNativeDialog *self, gint response_id);

  /* <private> */
  void (* show) (GtkNativeDialog *self);
  void (* hide) (GtkNativeDialog *self);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

static inline GtkNativeDialogClass * GTK_NATIVE_DIALOG_CLASS (gpointer ptr) {
	return (G_TYPE_CHECK_CLASS_CAST(ptr, gtk_native_dialog_get_type (), GtkNativeDialogClass));
}

static inline gboolean GTK_IS_NATIVE_DIALOG (gpointer ptr) {
	return (G_TYPE_CHECK_INSTANCE_TYPE (ptr, gtk_native_dialog_get_type ()));
}

static inline gboolean GTK_IS_NATIVE_DIALOG_CLASS (gpointer ptr) {
return (G_TYPE_CHECK_CLASS_TYPE(ptr, gtk_native_dialog_get_type ()));
}

static inline GtkNativeDialogClass * GTK_NATIVE_DIALOG_GET_CLASS (gpointer ptr) {
	return (G_TYPE_INSTANCE_GET_CLASS(ptr, gtk_native_dialog_get_type (), GtkNativeDialogClass));
}


GDK_AVAILABLE_IN_3_20
void                  gtk_native_dialog_show (GtkNativeDialog *self);
GDK_AVAILABLE_IN_3_20
void                  gtk_native_dialog_hide (GtkNativeDialog *self);
GDK_AVAILABLE_IN_3_20
void                  gtk_native_dialog_destroy (GtkNativeDialog *self);
GDK_AVAILABLE_IN_3_20
gboolean              gtk_native_dialog_get_visible (GtkNativeDialog *self);
GDK_AVAILABLE_IN_3_20
void                  gtk_native_dialog_set_modal (GtkNativeDialog *self,
                                                   gboolean modal);
GDK_AVAILABLE_IN_3_20
gboolean              gtk_native_dialog_get_modal (GtkNativeDialog *self);
GDK_AVAILABLE_IN_3_20
void                  gtk_native_dialog_set_title (GtkNativeDialog *self,
                                                   const char *title);
GDK_AVAILABLE_IN_3_20
const char *          gtk_native_dialog_get_title (GtkNativeDialog *self);
GDK_AVAILABLE_IN_3_20
void                  gtk_native_dialog_set_transient_for (GtkNativeDialog *self,
                                                           GtkWindow *parent);
GDK_AVAILABLE_IN_3_20
GtkWindow *           gtk_native_dialog_get_transient_for (GtkNativeDialog *self);

GDK_AVAILABLE_IN_3_20
gint                  gtk_native_dialog_run (GtkNativeDialog *self);

G_END_DECLS

#endif /* __GTK_NATIVE_DIALOG_H__ */
#define headerfilename "gtk/./gtkfilechoosernative.h"
/* file: gtk/./gtkfilechoosernative.h */
/* GTK - The GIMP Toolkit
 * gtkfilechoosernative.h: Native File selector dialog
 * Copyright (C) 2015, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_FILE_CHOOSER_NATIVE_H__
#define __GTK_FILE_CHOOSER_NATIVE_H__



#include <gtk/gtkfilechooser.h>
#include <gtk/gtknativedialog.h>

G_BEGIN_DECLS

#define GTK_TYPE_FILE_CHOOSER_NATIVE()             (gtk_file_chooser_native_get_type ())

GDK_AVAILABLE_IN_3_20
typedef struct _GtkFileChooserNative{} GtkFileChooserNative;

struct GtkFileChooserNativeClass
{
	GtkNativeDialogClass parent_class;
};
typedef struct GtkFileChooserWidgetPrivate{} GtkFileChooserWidgetPrivate;
struct GtkFileChooserWidget
{
  GtkBox parent_instance;

  GtkFileChooserWidgetPrivate *priv;
};
struct GtkFileChooserWidgetClass
{
  GtkBoxClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GType gtk_file_chooser_native_get_type (void);

#define GTK_IS_FILE_CHOOSER_NATIVE(o)        (GTK_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_FILE_CHOOSER_NATIVE))

GDK_AVAILABLE_IN_3_20
GtkFileChooserNative *gtk_file_chooser_native_new (const char          *title,
                                                   GtkWindow            *parent,
                                                   GtkFileChooserAction  action,
                                                   const char          *accept_label,
                                                   const char          *cancel_label);

GDK_AVAILABLE_IN_3_20
const char *gtk_file_chooser_native_get_accept_label (GtkFileChooserNative *self);
GDK_AVAILABLE_IN_3_20
void        gtk_file_chooser_native_set_accept_label (GtkFileChooserNative *self,
                                                      const char           *accept_label);
GDK_AVAILABLE_IN_3_20
const char *gtk_file_chooser_native_get_cancel_label (GtkFileChooserNative *self);
GDK_AVAILABLE_IN_3_20
void        gtk_file_chooser_native_set_cancel_label (GtkFileChooserNative *self,
                                                      const char           *cancel_label);

G_END_DECLS

#endif /* __GTK_FILE_CHOOSER_NATIVE_H__ */
#define headerfilename "gtk/./gtkfilechooserwidget.h"
/* file: gtk/./gtkfilechooserwidget.h */
/* GTK - The GIMP Toolkit
 * gtkfilechooserwidget.h: Embeddable file selector widget
 * Copyright (C) 2003, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_FILE_CHOOSER_WIDGET_H__
#define __GTK_FILE_CHOOSER_WIDGET_H__



#include <gtk/gtkfilechooser.h>
#include <gtk/gtkbox.h>

G_BEGIN_DECLS

#define GTK_TYPE_FILE_CHOOSER_WIDGET()             (gtk_file_chooser_widget_get_type ())
#define GTK_FILE_CHOOSER_WIDGET(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FILE_CHOOSER_WIDGET, GtkFileChooserWidget))
#define GTK_FILE_CHOOSER_WIDGET_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FILE_CHOOSER_WIDGET, GtkFileChooserWidgetClass))
#define GTK_IS_FILE_CHOOSER_WIDGET(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FILE_CHOOSER_WIDGET))
#define GTK_IS_FILE_CHOOSER_WIDGET_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FILE_CHOOSER_WIDGET))
#define GTK_FILE_CHOOSER_WIDGET_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FILE_CHOOSER_WIDGET, GtkFileChooserWidgetClass))



/**
 * GtkFileChooserWidgetClass:
 * @parent_class: The parent class.
 */
struct GtkFlowBox
{
  GtkContainer container;
};
struct GtkFlowBoxChild
{
  GtkBin parent_instance;
};
struct GtkFlowBoxClass
{
  GtkContainerClass parent_class;

  void (*child_activated)            (GtkFlowBox        *box,
                                      GtkFlowBoxChild   *child);
  void (*selected_children_changed)  (GtkFlowBox        *box);
  void (*activate_cursor_child)      (GtkFlowBox        *box);
  void (*toggle_cursor_child)        (GtkFlowBox        *box);
  gboolean (*move_cursor)            (GtkFlowBox        *box,
                                      GtkMovementStep    step,
                                      gint               count);
  void (*select_all)                 (GtkFlowBox        *box);
  void (*unselect_all)               (GtkFlowBox        *box);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
};

GDK_AVAILABLE_IN_ALL
GType      gtk_file_chooser_widget_get_type         (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_file_chooser_widget_new              (GtkFileChooserAction  action);

G_END_DECLS

#endif /* __GTK_FILE_CHOOSER_WIDGET_H__ */
#define headerfilename "gtk/./gtkflowbox.h"
/* file: gtk/./gtkflowbox.h */
/*
 * Copyright (C) 2010 Openismus GmbH
 * Copyright (C) 2013 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.

 *
 * Authors:
 *      Tristan Van Berkom <tristanvb@openismus.com>
 *      Matthias Clasen <mclasen@redhat.com>
 *      William Jon McCann <jmccann@redhat.com>
 */

#ifndef __GTK_FLOW_BOX_H__
#define __GTK_FLOW_BOX_H__



#include <gtk/gtkbin.h>

G_BEGIN_DECLS


#define GTK_TYPE_FLOW_BOX()                  (gtk_flow_box_get_type ())
#define GTK_FLOW_BOX(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FLOW_BOX, GtkFlowBox))
#define GTK_FLOW_BOX_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FLOW_BOX, GtkFlowBoxClass))
#define GTK_IS_FLOW_BOX(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FLOW_BOX))
#define GTK_IS_FLOW_BOX_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FLOW_BOX))
#define GTK_FLOW_BOX_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FLOW_BOX, GtkFlowBoxClass))




struct GtkFlowBoxChildClass
{
  GtkBinClass parent_class;

  void (* activate) (GtkFlowBoxChild *child);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
};

#define GTK_TYPE_FLOW_BOX_CHILD()            (gtk_flow_box_child_get_type ())
#define GTK_FLOW_BOX_CHILD(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FLOW_BOX_CHILD, GtkFlowBoxChild))
#define GTK_FLOW_BOX_CHILD_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FLOW_BOX_CHILD, GtkFlowBoxChildClass))
#define GTK_IS_FLOW_BOX_CHILD(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FLOW_BOX_CHILD))
#define GTK_IS_FLOW_BOX_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FLOW_BOX_CHILD))
#define GTK_FLOW_BOX_CHILD_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), EG_TYPE_FLOW_BOX_CHILD, GtkFlowBoxChildClass))



/**
 * GtkFlowBoxCreateWidgetFunc:
 * @item: the item from the model for which to create a widget for
 * @user_data: user data from gtk_flow_box_bind_model()
 *
 * Called for flow boxes that are bound to a #GListModel with
 * gtk_flow_box_bind_model() for each item that gets added to the model.
 *
 * Returns: a #GtkWidget that represents @item
 *
 * Since: 3.18
 */
typedef GtkWidget * (*GtkFlowBoxCreateWidgetFunc) (gpointer item,
                                                   gpointer  user_data);

GDK_AVAILABLE_IN_3_12
GType                 gtk_flow_box_child_get_type            (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_12
GtkWidget*            gtk_flow_box_child_new                 (void);
GDK_AVAILABLE_IN_3_12
gint                  gtk_flow_box_child_get_index           (GtkFlowBoxChild *child);
GDK_AVAILABLE_IN_3_12
gboolean              gtk_flow_box_child_is_selected         (GtkFlowBoxChild *child);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_child_changed             (GtkFlowBoxChild *child);


GDK_AVAILABLE_IN_3_12
GType                 gtk_flow_box_get_type                  (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_12
GtkWidget            *gtk_flow_box_new                       (void);

GDK_AVAILABLE_IN_3_18
void                  gtk_flow_box_bind_model                (GtkFlowBox                 *box,
                                                              GListModel                 *model,
                                                              GtkFlowBoxCreateWidgetFunc  create_widget_func,
                                                              gpointer                    user_data,
                                                              GDestroyNotify              user_data_free_func);

GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_homogeneous           (GtkFlowBox           *box,
                                                              gboolean              homogeneous);
GDK_AVAILABLE_IN_3_12
gboolean              gtk_flow_box_get_homogeneous           (GtkFlowBox           *box);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_row_spacing           (GtkFlowBox           *box,
                                                              guint                 spacing);
GDK_AVAILABLE_IN_3_12
guint                 gtk_flow_box_get_row_spacing           (GtkFlowBox           *box);

GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_column_spacing        (GtkFlowBox           *box,
                                                              guint                 spacing);
GDK_AVAILABLE_IN_3_12
guint                 gtk_flow_box_get_column_spacing        (GtkFlowBox           *box);

GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_min_children_per_line (GtkFlowBox           *box,
                                                              guint                 n_children);
GDK_AVAILABLE_IN_3_12
guint                 gtk_flow_box_get_min_children_per_line (GtkFlowBox           *box);

GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_max_children_per_line (GtkFlowBox           *box,
                                                              guint                 n_children);
GDK_AVAILABLE_IN_3_12
guint                 gtk_flow_box_get_max_children_per_line (GtkFlowBox           *box);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_activate_on_single_click (GtkFlowBox        *box,
                                                                 gboolean           single);
GDK_AVAILABLE_IN_3_12
gboolean              gtk_flow_box_get_activate_on_single_click (GtkFlowBox        *box);

GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_insert                       (GtkFlowBox        *box,
                                                                 GtkWidget         *widget,
                                                                 gint               position);
GDK_AVAILABLE_IN_3_12
GtkFlowBoxChild      *gtk_flow_box_get_child_at_index           (GtkFlowBox        *box,
                                                                 gint               idx);

typedef void (* GtkFlowBoxForeachFunc) (GtkFlowBox      *box,
                                        GtkFlowBoxChild *child,
                                        gpointer         user_data);

GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_selected_foreach             (GtkFlowBox        *box,
                                                                 GtkFlowBoxForeachFunc func,
                                                                 gpointer           data);
GDK_AVAILABLE_IN_3_12
GList                *gtk_flow_box_get_selected_children        (GtkFlowBox        *box);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_select_child                 (GtkFlowBox        *box,
                                                                 GtkFlowBoxChild   *child);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_unselect_child               (GtkFlowBox        *box,
                                                                 GtkFlowBoxChild   *child);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_select_all                   (GtkFlowBox        *box);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_unselect_all                 (GtkFlowBox        *box);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_selection_mode           (GtkFlowBox        *box,
                                                                 GtkSelectionMode   mode);
GDK_AVAILABLE_IN_3_12
GtkSelectionMode      gtk_flow_box_get_selection_mode           (GtkFlowBox        *box);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_hadjustment              (GtkFlowBox        *box,
                                                                 GtkAdjustment     *adjustment);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_vadjustment              (GtkFlowBox        *box,
                                                                 GtkAdjustment     *adjustment);

typedef gboolean (*GtkFlowBoxFilterFunc) (GtkFlowBoxChild *child,
                                          gpointer         user_data);

GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_filter_func              (GtkFlowBox        *box,
                                                                 GtkFlowBoxFilterFunc filter_func,
                                                                 gpointer             user_data,
                                                                 GDestroyNotify       destroy);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_invalidate_filter            (GtkFlowBox        *box);

typedef gint (*GtkFlowBoxSortFunc) (GtkFlowBoxChild *child1,
                                    GtkFlowBoxChild *child2,
                                    gpointer         user_data);

GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_set_sort_func                (GtkFlowBox        *box,
                                                                 GtkFlowBoxSortFunc  sort_func,
                                                                 gpointer            user_data,
                                                                 GDestroyNotify      destroy);
GDK_AVAILABLE_IN_3_12
void                  gtk_flow_box_invalidate_sort              (GtkFlowBox         *box);

G_END_DECLS


#endif /* __GTK_FLOW_BOX_H__ */
#define headerfilename "gtk/./gtkfontbutton.h"
/* file: gtk/./gtkfontbutton.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1998 David Abilleira Freijeiro <odaf@nexo.es>
 * All rights reserved
 * Based on gnome-color-picker by Federico Mena <federico@nuclecu.unam.mx>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Modified by the GTK+ Team and others 2003.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_FONT_BUTTON_H__
#define __GTK_FONT_BUTTON_H__



#include <gtk/gtkbutton.h>


G_BEGIN_DECLS

/* GtkFontButton is a button widget that allow user to select a font.
 */

#define GTK_TYPE_FONT_BUTTON()             (gtk_font_button_get_type ())
#define GTK_FONT_BUTTON(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FONT_BUTTON, GtkFontButton))
#define GTK_FONT_BUTTON_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FONT_BUTTON, GtkFontButtonClass))
#define GTK_IS_FONT_BUTTON(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FONT_BUTTON))
#define GTK_IS_FONT_BUTTON_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FONT_BUTTON))
#define GTK_FONT_BUTTON_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FONT_BUTTON, GtkFontButtonClass))

typedef struct GtkFontButtonPrivate{} GtkFontButtonPrivate;

struct GtkFontButton {
  GtkButton button;

  /*< private >*/
  GtkFontButtonPrivate *priv;
};

struct GtkFontButtonClass {
  GtkButtonClass parent_class;

  /* font_set signal is emitted when font is chosen */
  void (* font_set) (GtkFontButton *gfp);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};
typedef struct _GtkFontChooser{} GtkFontChooser; /* dummy */
struct GtkFontChooserIface
{
  GTypeInterface base_iface;

  /* Methods */
  PangoFontFamily * (* get_font_family)         (GtkFontChooser  *fontchooser);
  PangoFontFace *   (* get_font_face)           (GtkFontChooser  *fontchooser);
  gint              (* get_font_size)           (GtkFontChooser  *fontchooser);

  void              (* set_filter_func)         (GtkFontChooser   *fontchooser,
                                                 GtkFontFilterFunc filter,
                                                 gpointer          user_data,
                                                 GDestroyNotify    destroy);

  /* Signals */
  void (* font_activated) (GtkFontChooser *chooser,
                           const char    *fontname);

  /* More methods */
  void              (* set_font_map)            (GtkFontChooser   *fontchooser,
                                                 PangoFontMap     *fontmap);
  PangoFontMap *    (* get_font_map)            (GtkFontChooser   *fontchooser);

   /* Padding */
  gpointer padding[10];
};
typedef struct GtkFontChooserDialogPrivate{} GtkFontChooserDialogPrivate;


GDK_AVAILABLE_IN_ALL
GType                 gtk_font_button_get_type       (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget            *gtk_font_button_new            (void);
GDK_AVAILABLE_IN_ALL
GtkWidget            *gtk_font_button_new_with_font  (const char   *fontname);

GDK_AVAILABLE_IN_ALL
const char *         gtk_font_button_get_title      (GtkFontButton *font_button);
GDK_AVAILABLE_IN_ALL
void                  gtk_font_button_set_title      (GtkFontButton *font_button,
                                                      const char   *title);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_font_button_get_use_font   (GtkFontButton *font_button);
GDK_AVAILABLE_IN_ALL
void                  gtk_font_button_set_use_font   (GtkFontButton *font_button,
                                                      gboolean       use_font);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_font_button_get_use_size   (GtkFontButton *font_button);
GDK_AVAILABLE_IN_ALL
void                  gtk_font_button_set_use_size   (GtkFontButton *font_button,
                                                      gboolean       use_size);
GDK_AVAILABLE_IN_ALL
const char *         gtk_font_button_get_font_name  (GtkFontButton *font_button);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_font_button_set_font_name  (GtkFontButton *font_button,
                                                      const char   *fontname);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_font_button_get_show_style (GtkFontButton *font_button);
GDK_AVAILABLE_IN_ALL
void                  gtk_font_button_set_show_style (GtkFontButton *font_button,
                                                      gboolean       show_style);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_font_button_get_show_size  (GtkFontButton *font_button);
GDK_AVAILABLE_IN_ALL
void                  gtk_font_button_set_show_size  (GtkFontButton *font_button,
                                                      gboolean       show_size);

G_END_DECLS


#endif /* __GTK_FONT_BUTTON_H__ */
#define headerfilename "gtk/./gtkfontchooser.h"
/* file: gtk/./gtkfontchooser.h */
/* GTK - The GIMP Toolkit
 * gtkfontchooser.h - Abstract interface for font file selectors GUIs
 *
 * Copyright (C) 2006, Emmanuele Bassi
 * Copyright (C) 2011 Alberto Ruiz <aruiz@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_FONT_CHOOSER_H__
#define __GTK_FONT_CHOOSER_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

/**
 * GtkFontFilterFunc:
 * @family: a #PangoFontFamily
 * @face: a #PangoFontFace belonging to @family
 * @data: (closure): user data passed to gtk_font_chooser_set_filter_func()
 *
 * The type of function that is used for deciding what fonts get
 * shown in a #GtkFontChooser. See gtk_font_chooser_set_filter_func().
 *
 * Returns: %TRUE if the font should be displayed
 */
typedef gboolean (*GtkFontFilterFunc) (const PangoFontFamily *family,
                                       const PangoFontFace   *face,
                                       gpointer               data);

#define GTK_TYPE_FONT_CHOOSER()			(gtk_font_chooser_get_type ())
#define GTK_FONT_CHOOSER(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FONT_CHOOSER, GtkFontChooser))
#define GTK_IS_FONT_CHOOSER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FONT_CHOOSER))
#define GTK_FONT_CHOOSER_GET_IFACE(inst)	(G_TYPE_INSTANCE_GET_INTERFACE ((inst), GTK_TYPE_FONT_CHOOSER, GtkFontChooserIface))


struct GtkFontChooserDialog
{
  GtkDialog parent_instance;

  /*< private >*/
  GtkFontChooserDialogPrivate *priv;
};
struct GtkFontChooserDialogClass
{
  GtkDialogClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_2
GType            gtk_font_chooser_get_type                 (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_2
PangoFontFamily *gtk_font_chooser_get_font_family          (GtkFontChooser   *fontchooser);
GDK_AVAILABLE_IN_3_2
PangoFontFace   *gtk_font_chooser_get_font_face            (GtkFontChooser   *fontchooser);
GDK_AVAILABLE_IN_3_2
gint             gtk_font_chooser_get_font_size            (GtkFontChooser   *fontchooser);

GDK_AVAILABLE_IN_3_2
PangoFontDescription *
                 gtk_font_chooser_get_font_desc            (GtkFontChooser             *fontchooser);
GDK_AVAILABLE_IN_3_2
void             gtk_font_chooser_set_font_desc            (GtkFontChooser             *fontchooser,
                                                            const PangoFontDescription *font_desc);

GDK_AVAILABLE_IN_3_2
char*           gtk_font_chooser_get_font                 (GtkFontChooser   *fontchooser);

GDK_AVAILABLE_IN_3_2
void             gtk_font_chooser_set_font                 (GtkFontChooser   *fontchooser,
                                                            const char      *fontname);
GDK_AVAILABLE_IN_3_2
char*           gtk_font_chooser_get_preview_text         (GtkFontChooser   *fontchooser);
GDK_AVAILABLE_IN_3_2
void             gtk_font_chooser_set_preview_text         (GtkFontChooser   *fontchooser,
                                                            const char      *text);
GDK_AVAILABLE_IN_3_2
gboolean         gtk_font_chooser_get_show_preview_entry   (GtkFontChooser   *fontchooser);
GDK_AVAILABLE_IN_3_2
void             gtk_font_chooser_set_show_preview_entry   (GtkFontChooser   *fontchooser,
                                                            gboolean          show_preview_entry);
GDK_AVAILABLE_IN_3_2
void             gtk_font_chooser_set_filter_func          (GtkFontChooser   *fontchooser,
                                                            GtkFontFilterFunc filter,
                                                            gpointer          user_data,
                                                            GDestroyNotify    destroy);
GDK_AVAILABLE_IN_3_18
void             gtk_font_chooser_set_font_map             (GtkFontChooser   *fontchooser,
                                                            PangoFontMap     *fontmap);
GDK_AVAILABLE_IN_3_18
PangoFontMap *   gtk_font_chooser_get_font_map             (GtkFontChooser   *fontchooser);

G_END_DECLS

#endif /* __GTK_FONT_CHOOSER_H__ */
#define headerfilename "gtk/./gtkfontchooserdialog.h"
/* file: gtk/./gtkfontchooserdialog.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2011      Alberto Ruiz <aruiz@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_FONT_CHOOSER_DIALOG_H__
#define __GTK_FONT_CHOOSER_DIALOG_H__



#include <gtk/gtkdialog.h>

G_BEGIN_DECLS

#define GTK_TYPE_FONT_CHOOSER_DIALOG()              (gtk_font_chooser_dialog_get_type ())
#define GTK_FONT_CHOOSER_DIALOG(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FONT_CHOOSER_DIALOG, GtkFontChooserDialog))
#define GTK_FONT_CHOOSER_DIALOG_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FONT_CHOOSER_DIALOG, GtkFontChooserDialogClass))
#define GTK_IS_FONT_CHOOSER_DIALOG(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FONT_CHOOSER_DIALOG))
#define GTK_IS_FONT_CHOOSER_DIALOG_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FONT_CHOOSER_DIALOG))
#define GTK_FONT_CHOOSER_DIALOG_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FONT_CHOOSER_DIALOG, GtkFontChooserDialogClass))

typedef struct GtkFontChooserWidgetPrivate{} GtkFontChooserWidgetPrivate;


/**
 * GtkFontChooserDialogClass:
 * @parent_class: The parent class.
 */
struct GtkFontChooserWidget
{
  GtkBox parent_instance;

  /*< private >*/
  GtkFontChooserWidgetPrivate *priv;
};
struct GtkFontChooserWidgetClass
{
  GtkBoxClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};

GDK_AVAILABLE_IN_3_2
GType      gtk_font_chooser_dialog_get_type         (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_2
GtkWidget* gtk_font_chooser_dialog_new              (const char          *title,
                                                     GtkWindow            *parent);

G_END_DECLS

#endif /* __GTK_FONT_CHOOSER_DIALOG_H__ */
#define headerfilename "gtk/./gtkfontchooserwidget.h"
/* file: gtk/./gtkfontchooserwidget.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2011      Alberto Ruiz <aruiz@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_FONT_CHOOSER_WIDGET_H__
#define __GTK_FONT_CHOOSER_WIDGET_H__



#include <gtk/gtkbox.h>

G_BEGIN_DECLS

#define GTK_TYPE_FONT_CHOOSER_WIDGET()              (gtk_font_chooser_widget_get_type ())
#define GTK_FONT_CHOOSER_WIDGET(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FONT_CHOOSER_WIDGET, GtkFontChooserWidget))
#define GTK_FONT_CHOOSER_WIDGET_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FONT_CHOOSER_WIDGET, GtkFontChooserWidgetClass))
#define GTK_IS_FONT_CHOOSER_WIDGET(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FONT_CHOOSER_WIDGET))
#define GTK_IS_FONT_CHOOSER_WIDGET_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FONT_CHOOSER_WIDGET))
#define GTK_FONT_CHOOSER_WIDGET_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FONT_CHOOSER_WIDGET, GtkFontChooserWidgetClass))



/**
 * GtkFontChooserWidgetClass:
 * @parent_class: The parent class.
 */
struct GtkGLArea
{
  /*< private >*/
  GtkWidget parent_instance;
};
struct GtkGLAreaClass
{
  /*< private >*/
  GtkWidgetClass parent_class;

  /*< public >*/
  gboolean       (* render)         (GtkGLArea        *area,
                                     GdkGLContext     *context);
  void           (* resize)         (GtkGLArea        *area,
                                     int               width,
                                     int               height);
  GdkGLContext * (* create_context) (GtkGLArea        *area);

  /*< private >*/
  gpointer _padding[6];
};
typedef struct _GtkGesture{} GtkGesture;
typedef struct _GtkGestureClass{} GtkGestureClass;

GDK_AVAILABLE_IN_3_2
GType        gtk_font_chooser_widget_get_type                 (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_2
GtkWidget*   gtk_font_chooser_widget_new                      (void);

G_END_DECLS

#endif /* __GTK_FONT_CHOOSER_WIDGET_H__ */
#define headerfilename "gtk/./gtkgesture.h"
/* file: gtk/./gtkgesture.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2012, One Laptop Per Child.
 * Copyright (C) 2014, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */
#ifndef __GTK_GESTURE_H__
#define __GTK_GESTURE_H__



#include <gtk/gtkeventcontroller.h>
#include <gtk/gtkenums.h>

G_BEGIN_DECLS

#define GTK_TYPE_GESTURE()         (gtk_gesture_get_type ())
#define GTK_GESTURE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_GESTURE, GtkGesture))
#define GTK_GESTURE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_GESTURE, GtkGestureClass))
#define GTK_IS_GESTURE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_GESTURE))
#define GTK_IS_GESTURE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_GESTURE))
#define GTK_GESTURE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_GESTURE, GtkGestureClass))

typedef struct _GtkGestureSingle{} GtkGestureSingle;
typedef struct _GtkGestureSingleClass{} GtkGestureSingleClass;

GDK_AVAILABLE_IN_3_14
GType       gtk_gesture_get_type             (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
GdkDevice * gtk_gesture_get_device           (GtkGesture       *gesture);

GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_set_state            (GtkGesture            *gesture,
                                              GtkEventSequenceState  state);
GDK_AVAILABLE_IN_3_14
GtkEventSequenceState
            gtk_gesture_get_sequence_state   (GtkGesture            *gesture,
                                              GdkEventSequence      *sequence);
GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_set_sequence_state   (GtkGesture            *gesture,
                                              GdkEventSequence      *sequence,
                                              GtkEventSequenceState  state);
GDK_AVAILABLE_IN_3_14
GList     * gtk_gesture_get_sequences        (GtkGesture       *gesture);

GDK_AVAILABLE_IN_3_14
GdkEventSequence * gtk_gesture_get_last_updated_sequence
                                             (GtkGesture       *gesture);

GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_handles_sequence     (GtkGesture       *gesture,
                                              GdkEventSequence *sequence);
GDK_AVAILABLE_IN_3_14
const GdkEvent *
            gtk_gesture_get_last_event       (GtkGesture       *gesture,
                                              GdkEventSequence *sequence);
GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_get_point            (GtkGesture       *gesture,
                                              GdkEventSequence *sequence,
                                              gdouble          *x,
                                              gdouble          *y);
GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_get_bounding_box     (GtkGesture       *gesture,
                                              GdkRectangle     *rect);
GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_get_bounding_box_center
                                             (GtkGesture       *gesture,
                                              gdouble          *x,
                                              gdouble          *y);
GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_is_active            (GtkGesture       *gesture);

GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_is_recognized        (GtkGesture       *gesture);

GDK_AVAILABLE_IN_3_14
GdkWindow * gtk_gesture_get_window           (GtkGesture       *gesture);

GDK_AVAILABLE_IN_3_14
void        gtk_gesture_set_window           (GtkGesture       *gesture,
                                              GdkWindow        *window);

GDK_AVAILABLE_IN_3_14
void        gtk_gesture_group                (GtkGesture       *group_gesture,
                                              GtkGesture       *gesture);
GDK_AVAILABLE_IN_3_14
void        gtk_gesture_ungroup              (GtkGesture       *gesture);

GDK_AVAILABLE_IN_3_14
GList *     gtk_gesture_get_group            (GtkGesture       *gesture);

GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_is_grouped_with      (GtkGesture       *gesture,
                                              GtkGesture       *other);

G_END_DECLS

#endif /* __GTK_GESTURE_H__ */
#define headerfilename "gtk/./gtkgesturesingle.h"
/* file: gtk/./gtkgesturesingle.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2012, One Laptop Per Child.
 * Copyright (C) 2014, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */

#ifndef __GTK_GESTURE_SINGLE_H__
#define __GTK_GESTURE_SINGLE_H__



#include <gtk/gtkgesture.h>

G_BEGIN_DECLS

#define GTK_TYPE_GESTURE_SINGLE()         (gtk_gesture_single_get_type ())
#define GTK_GESTURE_SINGLE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_GESTURE_SINGLE, GtkGestureSingle))
#define GTK_GESTURE_SINGLE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_GESTURE_SINGLE, GtkGestureSingleClass))
#define GTK_IS_GESTURE_SINGLE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_GESTURE_SINGLE))
#define GTK_IS_GESTURE_SINGLE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_GESTURE_SINGLE))
#define GTK_GESTURE_SINGLE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_GESTURE_SINGLE, GtkGestureSingleClass))

typedef struct _GtkGestureDrag{} GtkGestureDrag;
typedef struct _GtkGestureDragClass{} GtkGestureDragClass;

GDK_AVAILABLE_IN_3_14
GType       gtk_gesture_single_get_type       (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_single_get_touch_only (GtkGestureSingle *gesture);

GDK_AVAILABLE_IN_3_14
void        gtk_gesture_single_set_touch_only (GtkGestureSingle *gesture,
                                               gboolean          touch_only);
GDK_AVAILABLE_IN_3_14
gboolean    gtk_gesture_single_get_exclusive  (GtkGestureSingle *gesture);

GDK_AVAILABLE_IN_3_14
void        gtk_gesture_single_set_exclusive  (GtkGestureSingle *gesture,
                                               gboolean          exclusive);

GDK_AVAILABLE_IN_3_14
guint       gtk_gesture_single_get_button     (GtkGestureSingle *gesture);

GDK_AVAILABLE_IN_3_14
void        gtk_gesture_single_set_button     (GtkGestureSingle *gesture,
                                               guint             button);

GDK_AVAILABLE_IN_3_14
guint       gtk_gesture_single_get_current_button
                                              (GtkGestureSingle *gesture);

GDK_AVAILABLE_IN_3_14
GdkEventSequence * gtk_gesture_single_get_current_sequence
                                              (GtkGestureSingle *gesture);

G_END_DECLS

#endif /* __GTK_GESTURE_SINGLE_H__ */
#define headerfilename "gtk/./gtkgesturedrag.h"
/* file: gtk/./gtkgesturedrag.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2014, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */
#ifndef __GTK_GESTURE_DRAG_H__
#define __GTK_GESTURE_DRAG_H__



#include <gtk/gtkwidget.h>
#include <gtk/gtkgesturesingle.h>

G_BEGIN_DECLS

#define GTK_TYPE_GESTURE_DRAG()         (gtk_gesture_drag_get_type ())
#define GTK_GESTURE_DRAG(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_GESTURE_DRAG, GtkGestureDrag))
#define GTK_GESTURE_DRAG_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_GESTURE_DRAG, GtkGestureDragClass))
#define GTK_IS_GESTURE_DRAG(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_GESTURE_DRAG))
#define GTK_IS_GESTURE_DRAG_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_GESTURE_DRAG))
#define GTK_GESTURE_DRAG_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_GESTURE_DRAG, GtkGestureDragClass))

typedef struct _GtkGestureLongPress{} GtkGestureLongPress;
typedef struct _GtkGestureLongPressClass{} GtkGestureLongPressClass;

GDK_AVAILABLE_IN_3_14
GType        gtk_gesture_drag_get_type          (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
GtkGesture * gtk_gesture_drag_new               (GtkWidget      *widget);

GDK_AVAILABLE_IN_3_14
gboolean     gtk_gesture_drag_get_start_point   (GtkGestureDrag *gesture,
                                                 gdouble        *x,
                                                 gdouble        *y);
GDK_AVAILABLE_IN_3_14
gboolean     gtk_gesture_drag_get_offset        (GtkGestureDrag *gesture,
                                                 gdouble        *x,
                                                 gdouble        *y);

G_END_DECLS

#endif /* __GTK_GESTURE_DRAG_H__ */
#define headerfilename "gtk/./gtkgesturelongpress.h"
/* file: gtk/./gtkgesturelongpress.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2012, One Laptop Per Child.
 * Copyright (C) 2014, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */
#ifndef __GTK_GESTURE_LONG_PRESS_H__
#define __GTK_GESTURE_LONG_PRESS_H__



#include <gtk/gtkgesturesingle.h>

G_BEGIN_DECLS

#define GTK_TYPE_GESTURE_LONG_PRESS()         (gtk_gesture_long_press_get_type ())
#define GTK_GESTURE_LONG_PRESS(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_GESTURE_LONG_PRESS, GtkGestureLongPress))
#define GTK_GESTURE_LONG_PRESS_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_GESTURE_LONG_PRESS, GtkGestureLongPressClass))
#define GTK_IS_GESTURE_LONG_PRESS(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_GESTURE_LONG_PRESS))
#define GTK_IS_GESTURE_LONG_PRESS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_GESTURE_LONG_PRESS))
#define GTK_GESTURE_LONG_PRESS_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_GESTURE_LONG_PRESS, GtkGestureLongPressClass))

typedef struct _GtkGestureMultiPress{} GtkGestureMultiPress;
typedef struct _GtkGestureMultiPressClass{} GtkGestureMultiPressClass;

GDK_AVAILABLE_IN_3_14
GType        gtk_gesture_long_press_get_type   (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
GtkGesture * gtk_gesture_long_press_new        (GtkWidget *widget);

G_END_DECLS

#endif /* __GTK_GESTURE_LONG_PRESS_H__ */
#define headerfilename "gtk/./gtkgesturemultipress.h"
/* file: gtk/./gtkgesturemultipress.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2014 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */
#ifndef __GTK_GESTURE_MULTI_PRESS_H__
#define __GTK_GESTURE_MULTI_PRESS_H__



#include <gtk/gtkwidget.h>
#include <gtk/gtkgesturesingle.h>

G_BEGIN_DECLS

#define GTK_TYPE_GESTURE_MULTI_PRESS()         (gtk_gesture_multi_press_get_type ())
#define GTK_GESTURE_MULTI_PRESS(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_GESTURE_MULTI_PRESS, GtkGestureMultiPress))
#define GTK_GESTURE_MULTI_PRESS_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_GESTURE_MULTI_PRESS, GtkGestureMultiPressClass))
#define GTK_IS_GESTURE_MULTI_PRESS(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_GESTURE_MULTI_PRESS))
#define GTK_IS_GESTURE_MULTI_PRESS_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_GESTURE_MULTI_PRESS))
#define GTK_GESTURE_MULTI_PRESS_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_GESTURE_MULTI_PRESS, GtkGestureMultiPressClass))

typedef struct _GtkGesturePan{} GtkGesturePan;
typedef struct _GtkGesturePanClass{} GtkGesturePanClass;

GDK_AVAILABLE_IN_3_14
GType        gtk_gesture_multi_press_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
GtkGesture * gtk_gesture_multi_press_new      (GtkWidget            *widget);

GDK_AVAILABLE_IN_3_14
void         gtk_gesture_multi_press_set_area (GtkGestureMultiPress *gesture,
					       const GdkRectangle   *rect);
GDK_AVAILABLE_IN_3_14
gboolean     gtk_gesture_multi_press_get_area (GtkGestureMultiPress *gesture,
                                               GdkRectangle         *rect);

G_END_DECLS

#endif /* __GTK_GESTURE_MULTI_PRESS_H__ */
#define headerfilename "gtk/./gtkgesturepan.h"
/* file: gtk/./gtkgesturepan.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2014, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */
#ifndef __GTK_GESTURE_PAN_H__
#define __GTK_GESTURE_PAN_H__



#include <gtk/gtkenums.h>
#include <gtk/gtkgesturedrag.h>

G_BEGIN_DECLS

#define GTK_TYPE_GESTURE_PAN()         (gtk_gesture_pan_get_type ())
#define GTK_GESTURE_PAN(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_GESTURE_PAN, GtkGesturePan))
#define GTK_GESTURE_PAN_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_GESTURE_PAN, GtkGesturePanClass))
#define GTK_IS_GESTURE_PAN(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_GESTURE_PAN))
#define GTK_IS_GESTURE_PAN_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_GESTURE_PAN))
#define GTK_GESTURE_PAN_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_GESTURE_PAN, GtkGesturePanClass))

typedef struct _GtkGestureRotate{} GtkGestureRotate;
typedef struct _GtkGestureRotateClass{} GtkGestureRotateClass;

GDK_AVAILABLE_IN_3_14
GType             gtk_gesture_pan_get_type        (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
GtkGesture *      gtk_gesture_pan_new             (GtkWidget      *widget,
                                                   GtkOrientation  orientation);

GDK_AVAILABLE_IN_3_14
GtkOrientation    gtk_gesture_pan_get_orientation (GtkGesturePan  *gesture);

GDK_AVAILABLE_IN_3_14
void              gtk_gesture_pan_set_orientation (GtkGesturePan  *gesture,
                                                   GtkOrientation  orientation);


G_END_DECLS

#endif /* __GTK_GESTURE_PAN_H__ */
#define headerfilename "gtk/./gtkgesturerotate.h"
/* file: gtk/./gtkgesturerotate.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2012, One Laptop Per Child.
 * Copyright (C) 2014, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */
#ifndef __GTK_GESTURE_ROTATE_H__
#define __GTK_GESTURE_ROTATE_H__



#include <gtk/gtkwidget.h>
#include <gtk/gtkgesture.h>

G_BEGIN_DECLS

#define GTK_TYPE_GESTURE_ROTATE()         (gtk_gesture_rotate_get_type ())
#define GTK_GESTURE_ROTATE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_GESTURE_ROTATE, GtkGestureRotate))
#define GTK_GESTURE_ROTATE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_GESTURE_ROTATE, GtkGestureRotateClass))
#define GTK_IS_GESTURE_ROTATE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_GESTURE_ROTATE))
#define GTK_IS_GESTURE_ROTATE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_GESTURE_ROTATE))
#define GTK_GESTURE_ROTATE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_GESTURE_ROTATE, GtkGestureRotateClass))

typedef struct _GtkGestureSwipe{} GtkGestureSwipe;
typedef struct _GtkGestureSwipeClass{} GtkGestureSwipeClass;

GDK_AVAILABLE_IN_3_14
GType        gtk_gesture_rotate_get_type        (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
GtkGesture * gtk_gesture_rotate_new             (GtkWidget        *widget);

GDK_AVAILABLE_IN_3_14
gdouble      gtk_gesture_rotate_get_angle_delta (GtkGestureRotate *gesture);

G_END_DECLS

#endif /* __GTK_GESTURE_ROTATE_H__ */
#define headerfilename "gtk/./gtkgestureswipe.h"
/* file: gtk/./gtkgestureswipe.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2012, One Laptop Per Child.
 * Copyright (C) 2014, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */
#ifndef __GTK_GESTURE_SWIPE_H__
#define __GTK_GESTURE_SWIPE_H__



#include <gtk/gtkwidget.h>
#include <gtk/gtkgesturesingle.h>

G_BEGIN_DECLS

#define GTK_TYPE_GESTURE_SWIPE()         (gtk_gesture_swipe_get_type ())
#define GTK_GESTURE_SWIPE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_GESTURE_SWIPE, GtkGestureSwipe))
#define GTK_GESTURE_SWIPE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_GESTURE_SWIPE, GtkGestureSwipeClass))
#define GTK_IS_GESTURE_SWIPE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_GESTURE_SWIPE))
#define GTK_IS_GESTURE_SWIPE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_GESTURE_SWIPE))
#define GTK_GESTURE_SWIPE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_GESTURE_SWIPE, GtkGestureSwipeClass))

typedef struct _GtkGestureZoom{} GtkGestureZoom;
typedef struct _GtkGestureZoomClass{} GtkGestureZoomClass;

GDK_AVAILABLE_IN_3_14
GType        gtk_gesture_swipe_get_type  (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
GtkGesture * gtk_gesture_swipe_new       (GtkWidget *widget);

GDK_AVAILABLE_IN_3_14
gboolean     gtk_gesture_swipe_get_velocity (GtkGestureSwipe *gesture,
                                             gdouble         *velocity_x,
                                             gdouble         *velocity_y);

G_END_DECLS

#endif /* __GTK_GESTURE_SWIPE_H__ */
#define headerfilename "gtk/./gtkgesturezoom.h"
/* file: gtk/./gtkgesturezoom.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2012, One Laptop Per Child.
 * Copyright (C) 2014, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author(s): Carlos Garnacho <carlosg@gnome.org>
 */
#ifndef __GTK_GESTURE_ZOOM_H__
#define __GTK_GESTURE_ZOOM_H__



#include <gtk/gtkgesture.h>
#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_GESTURE_ZOOM()         (gtk_gesture_zoom_get_type ())
#define GTK_GESTURE_ZOOM(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_GESTURE_ZOOM, GtkGestureZoom))
#define GTK_GESTURE_ZOOM_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_GESTURE_ZOOM, GtkGestureZoomClass))
#define GTK_IS_GESTURE_ZOOM(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_GESTURE_ZOOM))
#define GTK_IS_GESTURE_ZOOM_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_GESTURE_ZOOM))
#define GTK_GESTURE_ZOOM_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_GESTURE_ZOOM, GtkGestureZoomClass))

typedef struct GtkGridPrivate{} GtkGridPrivate;

GDK_AVAILABLE_IN_3_14
GType        gtk_gesture_zoom_get_type        (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_14
GtkGesture * gtk_gesture_zoom_new             (GtkWidget      *widget);

GDK_AVAILABLE_IN_3_14
gdouble      gtk_gesture_zoom_get_scale_delta (GtkGestureZoom *gesture);

G_END_DECLS

#endif /* __GTK_GESTURE_ZOOM_H__ */
#define headerfilename "gtk/./gtkglarea.h"
/* file: gtk/./gtkglarea.h */
/* GTK - The GIMP Toolkit
 *
 * gtkglarea.h: A GL drawing area
 *
 * Copyright © 2014  Emmanuele Bassi
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_GL_AREA_H__
#define __GTK_GL_AREA_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_GL_AREA()                (gtk_gl_area_get_type ())
#define GTK_GL_AREA(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_GL_AREA, GtkGLArea))
#define GTK_IS_GL_AREA(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_GL_AREA))
#define GTK_GL_AREA_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_GL_AREA, GtkGLAreaClass))
#define GTK_IS_GL_AREA_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_GL_AREA))
#define GTK_GL_AREA_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_GL_AREA, GtkGLAreaClass))


/**
 * GtkGLArea:
 *
 * A #GtkWidget used for drawing with OpenGL.
 *
 * Since: 3.16
 */

/**
 * GtkGLAreaClass:
 * @render: class closure for the #GtkGLArea::render signal
 * @resize: class closeure for the #GtkGLArea::resize signal
 * @create_context: class closure for the #GtkGLArea::create-context signal
 *
 * The `GtkGLAreaClass` structure contains only private data.
 *
 * Since: 3.16
 */
struct GtkGrid
{
  /*< private >*/
  GtkContainer container;

  GtkGridPrivate *priv;
};
struct GtkGridClass
{
  GtkContainerClass parent_class;

  /*< private >*/

  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};

GDK_AVAILABLE_IN_3_16
GType gtk_gl_area_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_16
GtkWidget *     gtk_gl_area_new                         (void);

GDK_AVAILABLE_IN_3_16
void            gtk_gl_area_set_required_version        (GtkGLArea    *area,
                                                         gint          major,
                                                         gint          minor);
GDK_AVAILABLE_IN_3_16
void            gtk_gl_area_get_required_version        (GtkGLArea    *area,
                                                         gint         *major,
                                                         gint         *minor);
GDK_AVAILABLE_IN_3_16
gboolean        gtk_gl_area_get_has_alpha               (GtkGLArea    *area);
GDK_AVAILABLE_IN_3_16
void            gtk_gl_area_set_has_alpha               (GtkGLArea    *area,
                                                         gboolean      has_alpha);
GDK_AVAILABLE_IN_3_16
gboolean        gtk_gl_area_get_has_depth_buffer        (GtkGLArea    *area);
GDK_AVAILABLE_IN_3_16
void            gtk_gl_area_set_has_depth_buffer        (GtkGLArea    *area,
                                                         gboolean      has_depth_buffer);
GDK_AVAILABLE_IN_3_16
gboolean        gtk_gl_area_get_has_stencil_buffer      (GtkGLArea    *area);
GDK_AVAILABLE_IN_3_16
void            gtk_gl_area_set_has_stencil_buffer      (GtkGLArea    *area,
                                                         gboolean      has_stencil_buffer);
GDK_AVAILABLE_IN_3_16
gboolean        gtk_gl_area_get_auto_render             (GtkGLArea    *area);
GDK_AVAILABLE_IN_3_16
void            gtk_gl_area_set_auto_render             (GtkGLArea    *area,
                                                         gboolean      auto_render);
GDK_AVAILABLE_IN_3_16
void           gtk_gl_area_queue_render                 (GtkGLArea    *area);


GDK_AVAILABLE_IN_3_16
GdkGLContext *  gtk_gl_area_get_context                 (GtkGLArea    *area);

GDK_AVAILABLE_IN_3_16
void            gtk_gl_area_make_current                (GtkGLArea    *area);
GDK_AVAILABLE_IN_3_16
void            gtk_gl_area_attach_buffers              (GtkGLArea    *area);

GDK_AVAILABLE_IN_3_16
void            gtk_gl_area_set_error                   (GtkGLArea    *area,
                                                         const GError *error);
GDK_AVAILABLE_IN_3_16
GError *        gtk_gl_area_get_error                   (GtkGLArea    *area);

G_END_DECLS

#endif /* __GTK_GL_AREA_H__ */
#define headerfilename "gtk/./gtkgrid.h"
/* file: gtk/./gtkgrid.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2010 Red Hat, Inc.
 * Author: Matthias Clasen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_GRID_H__
#define __GTK_GRID_H__




#include <gtk/gtkcontainer.h>


G_BEGIN_DECLS

#define GTK_TYPE_GRID()                   (gtk_grid_get_type ())
#define GTK_GRID(obj)                   (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_GRID, GtkGrid))
#define GTK_GRID_CLASS(klass)           (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_GRID, GtkGridClass))
#define GTK_IS_GRID(obj)                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_GRID))
#define GTK_IS_GRID_CLASS(klass)        (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_GRID))
#define GTK_GRID_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_GRID, GtkGridClass))




/**
 * GtkGridClass:
 * @parent_class: The parent class.
 */
struct GtkHeaderBar
{
  GtkContainer container;
};
struct GtkHeaderBarClass
{
  GtkContainerClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType      gtk_grid_get_type               (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_grid_new                    (void);
GDK_AVAILABLE_IN_ALL
void       gtk_grid_attach                 (GtkGrid         *grid,
                                            GtkWidget       *child,
                                            gint             left,
                                            gint             top,
                                            gint             width,
                                            gint             height);
GDK_AVAILABLE_IN_ALL
void       gtk_grid_attach_next_to         (GtkGrid         *grid,
                                            GtkWidget       *child,
                                            GtkWidget       *sibling,
                                            GtkPositionType  side,
                                            gint             width,
                                            gint             height);
GDK_AVAILABLE_IN_3_2
GtkWidget *gtk_grid_get_child_at           (GtkGrid         *grid,
                                            gint             left,
                                            gint             top);
GDK_AVAILABLE_IN_3_2
void       gtk_grid_insert_row             (GtkGrid         *grid,
                                            gint             position);
GDK_AVAILABLE_IN_3_2
void       gtk_grid_insert_column          (GtkGrid         *grid,
                                            gint             position);
GDK_AVAILABLE_IN_3_10
void       gtk_grid_remove_row             (GtkGrid         *grid,
                                            gint             position);
GDK_AVAILABLE_IN_3_10
void       gtk_grid_remove_column          (GtkGrid         *grid,
                                            gint             position);
GDK_AVAILABLE_IN_3_2
void       gtk_grid_insert_next_to         (GtkGrid         *grid,
                                            GtkWidget       *sibling,
                                            GtkPositionType  side);
GDK_AVAILABLE_IN_ALL
void       gtk_grid_set_row_homogeneous    (GtkGrid         *grid,
                                            gboolean         homogeneous);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_grid_get_row_homogeneous    (GtkGrid         *grid);
GDK_AVAILABLE_IN_ALL
void       gtk_grid_set_row_spacing        (GtkGrid         *grid,
                                            guint            spacing);
GDK_AVAILABLE_IN_ALL
guint      gtk_grid_get_row_spacing        (GtkGrid         *grid);
GDK_AVAILABLE_IN_ALL
void       gtk_grid_set_column_homogeneous (GtkGrid         *grid,
                                            gboolean         homogeneous);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_grid_get_column_homogeneous (GtkGrid         *grid);
GDK_AVAILABLE_IN_ALL
void       gtk_grid_set_column_spacing     (GtkGrid         *grid,
                                            guint            spacing);
GDK_AVAILABLE_IN_ALL
guint      gtk_grid_get_column_spacing     (GtkGrid         *grid);
GDK_AVAILABLE_IN_3_10
void       gtk_grid_set_row_baseline_position (GtkGrid      *grid,
					       gint          row,
					       GtkBaselinePosition pos);
GDK_AVAILABLE_IN_3_10
GtkBaselinePosition gtk_grid_get_row_baseline_position (GtkGrid      *grid,
							gint          row);
GDK_AVAILABLE_IN_3_10
void       gtk_grid_set_baseline_row       (GtkGrid         *grid,
					    gint             row);
GDK_AVAILABLE_IN_3_10
gint       gtk_grid_get_baseline_row       (GtkGrid         *grid);


G_END_DECLS

#endif /* __GTK_GRID_H__ */
#define headerfilename "gtk/./gtkheaderbar.h"
/* file: gtk/./gtkheaderbar.h */
/*
 * Copyright (c) 2013 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __GTK_HEADER_BAR_H__
#define __GTK_HEADER_BAR_H__



#include <gtk/gtkcontainer.h>

G_BEGIN_DECLS

#define GTK_TYPE_HEADER_BAR()            (gtk_header_bar_get_type ())
#define GTK_HEADER_BAR(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_HEADER_BAR, GtkHeaderBar))
#define GTK_HEADER_BAR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_HEADER_BAR, GtkHeaderBarClass))
#define GTK_IS_HEADER_BAR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_HEADER_BAR))
#define GTK_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_HEADER_BAR))
#define GTK_HEADER_BAR_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_HEADER_BAR, GtkHeaderBarClass))

typedef struct GtkHeaderBarPrivate{} GtkHeaderBarPrivate;


struct GtkIconFactoryClass
{
  GObjectClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_10
GType        gtk_header_bar_get_type          (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_10
GtkWidget   *gtk_header_bar_new               (void);
GDK_AVAILABLE_IN_3_10
void         gtk_header_bar_set_title         (GtkHeaderBar *bar,
                                               const char  *title);
GDK_AVAILABLE_IN_3_10
const char *gtk_header_bar_get_title         (GtkHeaderBar *bar);
GDK_AVAILABLE_IN_3_10
void         gtk_header_bar_set_subtitle      (GtkHeaderBar *bar,
                                               const char  *subtitle);
GDK_AVAILABLE_IN_3_10
const char *gtk_header_bar_get_subtitle      (GtkHeaderBar *bar);


GDK_AVAILABLE_IN_3_10
void         gtk_header_bar_set_custom_title  (GtkHeaderBar *bar,
                                               GtkWidget    *title_widget);
GDK_AVAILABLE_IN_3_10
GtkWidget   *gtk_header_bar_get_custom_title  (GtkHeaderBar *bar);
GDK_AVAILABLE_IN_3_10
void         gtk_header_bar_pack_start        (GtkHeaderBar *bar,
                                               GtkWidget    *child);
GDK_AVAILABLE_IN_3_10
void         gtk_header_bar_pack_end          (GtkHeaderBar *bar,
                                               GtkWidget    *child);

GDK_AVAILABLE_IN_3_10
gboolean     gtk_header_bar_get_show_close_button (GtkHeaderBar *bar);

GDK_AVAILABLE_IN_3_10
void         gtk_header_bar_set_show_close_button (GtkHeaderBar *bar,
                                                   gboolean      setting);

GDK_AVAILABLE_IN_3_12
void         gtk_header_bar_set_has_subtitle (GtkHeaderBar *bar,
                                              gboolean      setting);
GDK_AVAILABLE_IN_3_12
gboolean     gtk_header_bar_get_has_subtitle (GtkHeaderBar *bar);

GDK_AVAILABLE_IN_3_12
void         gtk_header_bar_set_decoration_layout (GtkHeaderBar *bar,
                                                   const char  *layout);
GDK_AVAILABLE_IN_3_12
const char *gtk_header_bar_get_decoration_layout (GtkHeaderBar *bar);

G_END_DECLS

#endif /* __GTK_HEADER_BAR_H__ */
#define headerfilename "gtk/deprecated/gtkiconfactory.h"
/* file: gtk/deprecated/gtkiconfactory.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_ICON_FACTORY_H__
#define __GTK_ICON_FACTORY_H__



#include <gdk/gdk.h>
#include <gtk/gtkenums.h>
#include <gtk/gtktypes.h>

G_BEGIN_DECLS


#define GTK_TYPE_ICON_FACTORY()              (gtk_icon_factory_get_type ())
#define GTK_ICON_FACTORY(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), GTK_TYPE_ICON_FACTORY, GtkIconFactory))
#define GTK_ICON_FACTORY_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ICON_FACTORY, GtkIconFactoryClass))
#define GTK_IS_ICON_FACTORY(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), GTK_TYPE_ICON_FACTORY))
#define GTK_IS_ICON_FACTORY_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ICON_FACTORY))
#define GTK_ICON_FACTORY_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ICON_FACTORY, GtkIconFactoryClass))
#define GTK_TYPE_ICON_SET()                  (gtk_icon_set_get_type ())
#define GTK_TYPE_ICON_SOURCE()               (gtk_icon_source_get_type ())

typedef struct GtkStylePropertiesPrivate{} GtkStylePropertiesPrivate;


/**
 * GtkIconFactoryClass:
 * @parent_class: The parent class.
 */
struct GtkStyleProperties
{
  /*< private >*/
  GObject parent_object;
  GtkStylePropertiesPrivate *priv;
};
struct GtkStylePropertiesClass
{
  /*< private >*/
  GObjectClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_DEPRECATED_IN_3_10
GType           gtk_icon_factory_get_type (void) G_GNUC_CONST;
GDK_DEPRECATED_IN_3_10
GtkIconFactory* gtk_icon_factory_new      (void);
GDK_DEPRECATED_IN_3_10
void            gtk_icon_factory_add      (GtkIconFactory *factory,
                                           const char    *stock_id,
                                           GtkIconSet     *icon_set);
GDK_DEPRECATED_IN_3_10
GtkIconSet*     gtk_icon_factory_lookup   (GtkIconFactory *factory,
                                           const char    *stock_id);

/* Manage the default icon factory stack */

GDK_DEPRECATED_IN_3_10
void        gtk_icon_factory_add_default     (GtkIconFactory  *factory);
GDK_DEPRECATED_IN_3_10
void        gtk_icon_factory_remove_default  (GtkIconFactory  *factory);
GDK_DEPRECATED_IN_3_10
GtkIconSet* gtk_icon_factory_lookup_default  (const char     *stock_id);

/* Get preferred real size from registered semantic size.  Note that
 * themes SHOULD use this size, but they aren’t required to; for size
 * requests and such, you should get the actual pixbuf from the icon
 * set and see what size was rendered.
 *
 * This function is intended for people who are scaling icons,
 * rather than for people who are displaying already-scaled icons.
 * That is, if you are displaying an icon, you should get the
 * size from the rendered pixbuf, not from here.
 */

#ifndef GDK_MULTIHEAD_SAFE
GDK_AVAILABLE_IN_ALL
gboolean gtk_icon_size_lookup              (GtkIconSize  size,
					    gint        *width,
					    gint        *height);
#endif /* GDK_MULTIHEAD_SAFE */
GDK_DEPRECATED_IN_3_10_FOR(gtk_icon_size_lookup)
gboolean gtk_icon_size_lookup_for_settings (GtkSettings *settings,
					    GtkIconSize  size,
					    gint        *width,
					    gint        *height);

GDK_DEPRECATED_IN_3_10
GtkIconSize           gtk_icon_size_register       (const char *name,
                                                    gint         width,
                                                    gint         height);
GDK_DEPRECATED_IN_3_10
void                  gtk_icon_size_register_alias (const char *alias,
                                                    GtkIconSize  target);
GDK_DEPRECATED_IN_3_10
GtkIconSize           gtk_icon_size_from_name      (const char *name);
GDK_DEPRECATED_IN_3_10
const char*          gtk_icon_size_get_name       (GtkIconSize  size);

/* Icon sets */

GDK_DEPRECATED_IN_3_10
GType       gtk_icon_set_get_type        (void) G_GNUC_CONST;
GDK_DEPRECATED_IN_3_10
GtkIconSet* gtk_icon_set_new             (void);
GDK_DEPRECATED_IN_3_10
GtkIconSet* gtk_icon_set_new_from_pixbuf (GdkPixbuf       *pixbuf);

GDK_DEPRECATED_IN_3_10
GtkIconSet* gtk_icon_set_ref             (GtkIconSet      *icon_set);
GDK_DEPRECATED_IN_3_10
void        gtk_icon_set_unref           (GtkIconSet      *icon_set);
GDK_DEPRECATED_IN_3_10
GtkIconSet* gtk_icon_set_copy            (GtkIconSet      *icon_set);

GDK_DEPRECATED_IN_3_0_FOR(gtk_icon_set_render_icon_pixbuf)
GdkPixbuf*  gtk_icon_set_render_icon     (GtkIconSet      *icon_set,
                                          GtkStyle        *style,
                                          GtkTextDirection direction,
                                          GtkStateType     state,
                                          GtkIconSize      size,
                                          GtkWidget       *widget,
                                          const char     *detail);

GDK_DEPRECATED_IN_3_10
void           gtk_icon_set_add_source   (GtkIconSet          *icon_set,
                                          const GtkIconSource *source);

GDK_DEPRECATED_IN_3_10
void           gtk_icon_set_get_sizes    (GtkIconSet          *icon_set,
                                          GtkIconSize        **sizes,
                                          gint                *n_sizes);

GDK_DEPRECATED_IN_3_10
GType          gtk_icon_source_get_type                 (void) G_GNUC_CONST;
GDK_DEPRECATED_IN_3_10
GtkIconSource* gtk_icon_source_new                      (void);
GDK_DEPRECATED_IN_3_10
GtkIconSource* gtk_icon_source_copy                     (const GtkIconSource *source);
GDK_DEPRECATED_IN_3_10
void           gtk_icon_source_free                     (GtkIconSource       *source);

GDK_DEPRECATED_IN_3_10
void           gtk_icon_source_set_filename             (GtkIconSource       *source,
                                                         const char         *filename);
GDK_DEPRECATED_IN_3_10
void           gtk_icon_source_set_icon_name            (GtkIconSource       *source,
                                                         const char         *icon_name);
GDK_DEPRECATED_IN_3_10
void           gtk_icon_source_set_pixbuf               (GtkIconSource       *source,
                                                         GdkPixbuf           *pixbuf);

GDK_DEPRECATED_IN_3_10
const char *    gtk_icon_source_get_filename             (const GtkIconSource *source);
GDK_DEPRECATED_IN_3_10
const char *    gtk_icon_source_get_icon_name            (const GtkIconSource *source);
GDK_DEPRECATED_IN_3_10
GdkPixbuf*       gtk_icon_source_get_pixbuf               (const GtkIconSource *source);

GDK_DEPRECATED_IN_3_10
void             gtk_icon_source_set_direction_wildcarded (GtkIconSource       *source,
                                                           gboolean             setting);
GDK_DEPRECATED_IN_3_10
void             gtk_icon_source_set_state_wildcarded     (GtkIconSource       *source,
                                                           gboolean             setting);
GDK_DEPRECATED_IN_3_10
void             gtk_icon_source_set_size_wildcarded      (GtkIconSource       *source,
                                                           gboolean             setting);
GDK_DEPRECATED_IN_3_10
gboolean         gtk_icon_source_get_size_wildcarded      (const GtkIconSource *source);
GDK_DEPRECATED_IN_3_10
gboolean         gtk_icon_source_get_state_wildcarded     (const GtkIconSource *source);
GDK_DEPRECATED_IN_3_10
gboolean         gtk_icon_source_get_direction_wildcarded (const GtkIconSource *source);
GDK_DEPRECATED_IN_3_10
void             gtk_icon_source_set_direction            (GtkIconSource       *source,
                                                           GtkTextDirection     direction);
GDK_DEPRECATED_IN_3_10
void             gtk_icon_source_set_state                (GtkIconSource       *source,
                                                           GtkStateType         state);
GDK_DEPRECATED_IN_3_10
void             gtk_icon_source_set_size                 (GtkIconSource       *source,
                                                           GtkIconSize          size);
GDK_DEPRECATED_IN_3_10
GtkTextDirection gtk_icon_source_get_direction            (const GtkIconSource *source);
GDK_DEPRECATED_IN_3_10
GtkStateType     gtk_icon_source_get_state                (const GtkIconSource *source);
GDK_DEPRECATED_IN_3_10
GtkIconSize      gtk_icon_source_get_size                 (const GtkIconSource *source);

G_END_DECLS

#endif /* __GTK_ICON_FACTORY_H__ */
#define headerfilename "gtk/deprecated/gtkstyleproperties.h"
/* file: gtk/deprecated/gtkstyleproperties.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2010 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_STYLE_PROPERTIES_H__
#define __GTK_STYLE_PROPERTIES_H__



#include <glib-object.h>
#include <gdk/gdk.h>
#include <gtk/gtkenums.h>

G_BEGIN_DECLS

#define GTK_TYPE_STYLE_PROPERTIES()         (gtk_style_properties_get_type ())
#define GTK_STYLE_PROPERTIES(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_STYLE_PROPERTIES, GtkStyleProperties))
#define GTK_STYLE_PROPERTIES_CLASS(c)     (G_TYPE_CHECK_CLASS_CAST    ((c), GTK_TYPE_STYLE_PROPERTIES, GtkStylePropertiesClass))
#define GTK_IS_STYLE_PROPERTIES(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_STYLE_PROPERTIES))
#define GTK_IS_STYLE_PROPERTIES_CLASS(c)  (G_TYPE_CHECK_CLASS_TYPE    ((c), GTK_TYPE_STYLE_PROPERTIES))
#define GTK_STYLE_PROPERTIES_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS  ((o), GTK_TYPE_STYLE_PROPERTIES, GtkStylePropertiesClass))


typedef struct _GtkSymbolicColor{} GtkSymbolicColor;
typedef struct _GtkGradient{} GtkGradient;
typedef struct GtkStyleProvider{} GtkStyleProvider; /* dummy typedef */


struct GtkStyleProviderIface
{
  /*< private >*/
  GTypeInterface g_iface;

  /*< public >*/

  GtkStyleProperties * (* get_style) (GtkStyleProvider *provider,
                                      GtkWidgetPath    *path);

  gboolean (* get_style_property) (GtkStyleProvider *provider,
                                   GtkWidgetPath    *path,
                                   GtkStateFlags     state,
                                   GParamSpec       *pspec,
                                   GValue           *value);

  GtkIconFactory * (* get_icon_factory) (GtkStyleProvider *provider,
					 GtkWidgetPath    *path);
};

typedef gboolean (* GtkStylePropertyParser) (const char  *string,
                                             GValue       *value,
                                             GError      **error);

GDK_DEPRECATED_IN_3_16
GType gtk_style_properties_get_type (void) G_GNUC_CONST;

/* Next 2 are implemented in gtkcsscustomproperty.c */
GDK_DEPRECATED_IN_3_8
void     gtk_style_properties_register_property (GtkStylePropertyParser  parse_func,
                                                 GParamSpec             *pspec);
GDK_DEPRECATED_IN_3_8
gboolean gtk_style_properties_lookup_property   (const char             *property_name,
                                                 GtkStylePropertyParser  *parse_func,
                                                 GParamSpec             **pspec);

GDK_DEPRECATED_IN_3_16
GtkStyleProperties * gtk_style_properties_new (void);

GDK_DEPRECATED_IN_3_8
void               gtk_style_properties_map_color    (GtkStyleProperties *props,
                                                      const char        *name,
                                                      GtkSymbolicColor   *color);
GDK_DEPRECATED_IN_3_8
GtkSymbolicColor * gtk_style_properties_lookup_color (GtkStyleProperties *props,
                                                      const char        *name);

GDK_DEPRECATED_IN_3_16
void     gtk_style_properties_set_property (GtkStyleProperties *props,
                                            const char        *property,
                                            GtkStateFlags       state,
                                            const GValue       *value);
GDK_DEPRECATED_IN_3_16
void     gtk_style_properties_set_valist   (GtkStyleProperties *props,
                                            GtkStateFlags       state,
                                            va_list             args);
GDK_DEPRECATED_IN_3_16
void     gtk_style_properties_set          (GtkStyleProperties *props,
                                            GtkStateFlags       state,
                                            ...) G_GNUC_NULL_TERMINATED;

GDK_DEPRECATED_IN_3_16
gboolean gtk_style_properties_get_property (GtkStyleProperties *props,
                                            const char        *property,
                                            GtkStateFlags       state,
                                            GValue             *value);
GDK_DEPRECATED_IN_3_16
void     gtk_style_properties_get_valist   (GtkStyleProperties *props,
                                            GtkStateFlags       state,
                                            va_list             args);
GDK_DEPRECATED_IN_3_16
void     gtk_style_properties_get          (GtkStyleProperties *props,
                                            GtkStateFlags       state,
                                            ...) G_GNUC_NULL_TERMINATED;

GDK_DEPRECATED_IN_3_16
void     gtk_style_properties_unset_property (GtkStyleProperties *props,
                                              const char        *property,
                                              GtkStateFlags       state);

GDK_DEPRECATED_IN_3_16
void     gtk_style_properties_clear          (GtkStyleProperties  *props);

GDK_DEPRECATED_IN_3_16
void     gtk_style_properties_merge          (GtkStyleProperties       *props,
                                              const GtkStyleProperties *props_to_merge,
                                              gboolean                  replace);

G_END_DECLS

#endif /* __GTK_STYLE_PROPERTIES_H__ */
#define headerfilename "gtk/./gtkstyleprovider.h"
/* file: gtk/./gtkstyleprovider.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2010 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_STYLE_PROVIDER_H__
#define __GTK_STYLE_PROVIDER_H__



#include <glib-object.h>
#include <gtk/gtkenums.h>
#include <gtk/deprecated/gtkiconfactory.h>
#include <gtk/deprecated/gtkstyleproperties.h>
#include <gtk/gtktypes.h>

G_BEGIN_DECLS

#define GTK_TYPE_STYLE_PROVIDER()          (gtk_style_provider_get_type ())
#define GTK_STYLE_PROVIDER(o)            (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_STYLE_PROVIDER, GtkStyleProvider))
#define GTK_IS_STYLE_PROVIDER(o)         (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_STYLE_PROVIDER))
#define GTK_STYLE_PROVIDER_GET_IFACE(o)  (G_TYPE_INSTANCE_GET_INTERFACE ((o), GTK_TYPE_STYLE_PROVIDER, GtkStyleProviderIface))

/**
 * GTK_STYLE_PROVIDER_PRIORITY_FALLBACK:
 *
 * The priority used for default style information
 * that is used in the absence of themes.
 *
 * Note that this is not very useful for providing default
 * styling for custom style classes - themes are likely to
 * override styling provided at this priority with
 * catch-all `* {...}` rules.
 */
#define GTK_STYLE_PROVIDER_PRIORITY_FALLBACK      1

/**
 * GTK_STYLE_PROVIDER_PRIORITY_THEME:
 *
 * The priority used for style information provided
 * by themes.
 */
#define GTK_STYLE_PROVIDER_PRIORITY_THEME     200

/**
 * GTK_STYLE_PROVIDER_PRIORITY_SETTINGS:
 *
 * The priority used for style information provided
 * via #GtkSettings.
 *
 * This priority is higher than #GTK_STYLE_PROVIDER_PRIORITY_THEME
 * to let settings override themes.
 */
#define GTK_STYLE_PROVIDER_PRIORITY_SETTINGS    400

/**
 * GTK_STYLE_PROVIDER_PRIORITY_APPLICATION:
 *
 * A priority that can be used when adding a #GtkStyleProvider
 * for application-specific style information.
 */
#define GTK_STYLE_PROVIDER_PRIORITY_APPLICATION 600

/**
 * GTK_STYLE_PROVIDER_PRIORITY_USER:
 *
 * The priority used for the style information from
 * `~/.gtk-3.0.css`.
 *
 * You should not use priorities higher than this, to
 * give the user the last word.
 */
#define GTK_STYLE_PROVIDER_PRIORITY_USER        800


/**
 * GtkStyleProviderIface:
 * @get_style: Gets a set of style information that applies to a widget path.
 * @get_style_property: Gets the value of a widget style property that applies to a widget path.
 * @get_icon_factory: Gets the icon factory that applies to a widget path.
 */
struct GtkStyleContextClass
{
  GObjectClass parent_class;

  void (* changed) (GtkStyleContext *context);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType gtk_style_provider_get_type (void) G_GNUC_CONST;

GDK_DEPRECATED_IN_3_8
GtkStyleProperties *gtk_style_provider_get_style (GtkStyleProvider *provider,
                                                  GtkWidgetPath    *path);

GDK_AVAILABLE_IN_ALL
gboolean gtk_style_provider_get_style_property (GtkStyleProvider *provider,
                                                GtkWidgetPath    *path,
                                                GtkStateFlags     state,
                                                GParamSpec       *pspec,
                                                GValue           *value);

GDK_DEPRECATED_IN_3_8_FOR(NULL)
GtkIconFactory * gtk_style_provider_get_icon_factory (GtkStyleProvider *provider,
						      GtkWidgetPath    *path);

G_END_DECLS

#endif /* __GTK_STYLE_PROVIDER_H__ */
#define headerfilename "gtk/./gtkstylecontext.h"
/* file: gtk/./gtkstylecontext.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2010 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_STYLE_CONTEXT_H__
#define __GTK_STYLE_CONTEXT_H__



#include <gtk/gtkborder.h>
#include <gtk/gtkcsssection.h>
#include <gtk/gtkstyleprovider.h>
#include <gtk/gtktypes.h>
#include <atk/atk.h>

G_BEGIN_DECLS

#define GTK_TYPE_STYLE_CONTEXT()         (gtk_style_context_get_type ())
#define GTK_STYLE_CONTEXT(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_STYLE_CONTEXT, GtkStyleContext))
#define GTK_STYLE_CONTEXT_CLASS(c)     (G_TYPE_CHECK_CLASS_CAST    ((c), GTK_TYPE_STYLE_CONTEXT, GtkStyleContextClass))
#define GTK_IS_STYLE_CONTEXT(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_STYLE_CONTEXT))
#define GTK_IS_STYLE_CONTEXT_CLASS(c)  (G_TYPE_CHECK_CLASS_TYPE    ((c), GTK_TYPE_STYLE_CONTEXT))
#define GTK_STYLE_CONTEXT_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS  ((o), GTK_TYPE_STYLE_CONTEXT, GtkStyleContextClass))




/* Default set of properties that GtkStyleContext may contain */

/**
 * GTK_STYLE_PROPERTY_BACKGROUND_COLOR:
 *
 * A property holding the background color of rendered elements as a #GdkRGBA.
 */
#define GTK_STYLE_PROPERTY_BACKGROUND_COLOR "background-color"

/**
 * GTK_STYLE_PROPERTY_COLOR:
 *
 * A property holding the foreground color of rendered elements as a #GdkRGBA.
 */
#define GTK_STYLE_PROPERTY_COLOR "color"

/**
 * GTK_STYLE_PROPERTY_FONT:
 *
 * A property holding the font properties used when rendering text
 * as a #PangoFontDescription.
 */
#define GTK_STYLE_PROPERTY_FONT "font"

/**
 * GTK_STYLE_PROPERTY_PADDING:
 *
 * A property holding the rendered element’s padding as a #GtkBorder. The
 * padding is defined as the spacing between the inner part of the element border
 * and its child. It’s the innermost spacing property of the padding/border/margin
 * series.
 */
#define GTK_STYLE_PROPERTY_PADDING "padding"

/**
 * GTK_STYLE_PROPERTY_BORDER_WIDTH:
 *
 * A property holding the rendered element’s border width in pixels as
 * a #GtkBorder. The border is the intermediary spacing property of the
 * padding/border/margin series.
 *
 * gtk_render_frame() uses this property to find out the frame line width,
 * so #GtkWidgets rendering frames may need to add up this padding when
 * requesting size
 */
#define GTK_STYLE_PROPERTY_BORDER_WIDTH "border-width"

/**
 * GTK_STYLE_PROPERTY_MARGIN:
 *
 * A property holding the rendered element’s margin as a #GtkBorder. The
 * margin is defined as the spacing between the border of the element
 * and its surrounding elements. It is external to #GtkWidget's
 * size allocations, and the most external spacing property of the
 * padding/border/margin series.
 */
#define GTK_STYLE_PROPERTY_MARGIN "margin"

/**
 * GTK_STYLE_PROPERTY_BORDER_RADIUS:
 *
 * A property holding the rendered element’s border radius in pixels as a #gint.
 */
#define GTK_STYLE_PROPERTY_BORDER_RADIUS "border-radius"

/**
 * GTK_STYLE_PROPERTY_BORDER_STYLE:
 *
 * A property holding the element’s border style as a #GtkBorderStyle.
 */
#define GTK_STYLE_PROPERTY_BORDER_STYLE "border-style"

/**
 * GTK_STYLE_PROPERTY_BORDER_COLOR:
 *
 * A property holding the element’s border color as a #GdkRGBA.
 */
#define GTK_STYLE_PROPERTY_BORDER_COLOR "border-color"

/**
 * GTK_STYLE_PROPERTY_BACKGROUND_IMAGE:
 *
 * A property holding the element’s background as a #cairo_pattern_t.
 */
#define GTK_STYLE_PROPERTY_BACKGROUND_IMAGE "background-image"

/* Predefined set of CSS classes */

/**
 * GTK_STYLE_CLASS_CELL:
 *
 * A CSS class to match content rendered in cell views.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_CELL "cell"

/**
 * GTK_STYLE_CLASS_DIM_LABEL:
 *
 * A CSS class to match dimmed labels.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_DIM_LABEL "dim-label"

/**
 * GTK_STYLE_CLASS_ENTRY:
 *
 * A CSS class to match text entries.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_ENTRY "entry"

/**
 * GTK_STYLE_CLASS_LABEL:
 *
 * A CSS class to match labels.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.16
 */
#define GTK_STYLE_CLASS_LABEL "label"

/**
 * GTK_STYLE_CLASS_COMBOBOX_ENTRY:
 *
 * A CSS class to match combobox entries.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_COMBOBOX_ENTRY "combobox-entry"

/**
 * GTK_STYLE_CLASS_BUTTON:
 *
 * A CSS class to match buttons.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_BUTTON "button"

/**
 * GTK_STYLE_CLASS_LIST:
 *
 * A CSS class to match lists.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_LIST "list"

/**
 * GTK_STYLE_CLASS_LIST_ROW:
 *
 * A CSS class to match list rowss.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_LIST_ROW "list-row"

/**
 * GTK_STYLE_CLASS_CALENDAR:
 *
 * A CSS class to match calendars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_CALENDAR "calendar"

/**
 * GTK_STYLE_CLASS_SLIDER:
 *
 * A CSS class to match sliders.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SLIDER "slider"

/**
 * GTK_STYLE_CLASS_BACKGROUND:
 *
 * A CSS class to match the window background.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_BACKGROUND "background"

/**
 * GTK_STYLE_CLASS_RUBBERBAND:
 *
 * A CSS class to match the rubberband selection rectangle.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_RUBBERBAND "rubberband"

/**
 * GTK_STYLE_CLASS_CSD:
 *
 * A CSS class that gets added to windows which have client-side decorations.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.14
 */
#define GTK_STYLE_CLASS_CSD "csd"

/**
 * GTK_STYLE_CLASS_TOOLTIP:
 *
 * A CSS class to match tooltip windows.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_TOOLTIP "tooltip"

/**
 * GTK_STYLE_CLASS_MENU:
 *
 * A CSS class to match menus.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_MENU "menu"

/**
 * GTK_STYLE_CLASS_CONTEXT_MENU:
 *
 * A CSS class to match context menus.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_CONTEXT_MENU "context-menu"

/**
 * GTK_STYLE_CLASS_TOUCH_SELECTION:
 *
 * A CSS class for touch selection popups on entries
 * and text views.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.16
 */
#define GTK_STYLE_CLASS_TOUCH_SELECTION "touch-selection"

/**
 * GTK_STYLE_CLASS_MENUBAR:
 *
 * A CSS class to menubars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_MENUBAR "menubar"

/**
 * GTK_STYLE_CLASS_MENUITEM:
 *
 * A CSS class to match menu items.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_MENUITEM "menuitem"

/**
 * GTK_STYLE_CLASS_TOOLBAR:
 *
 * A CSS class to match toolbars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_TOOLBAR "toolbar"

/**
 * GTK_STYLE_CLASS_PRIMARY_TOOLBAR:
 *
 * A CSS class to match primary toolbars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_PRIMARY_TOOLBAR "primary-toolbar"

/**
 * GTK_STYLE_CLASS_INLINE_TOOLBAR:
 *
 * A CSS class to match inline toolbars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_INLINE_TOOLBAR "inline-toolbar"

/**
 * GTK_STYLE_CLASS_STATUSBAR:
 *
 * A CSS class to match statusbars.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.16
 */
#define GTK_STYLE_CLASS_STATUSBAR "statusbar"

/**
 * GTK_STYLE_CLASS_RADIO:
 *
 * A CSS class to match radio buttons.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_RADIO "radio"

/**
 * GTK_STYLE_CLASS_CHECK:
 *
 * A CSS class to match check boxes.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_CHECK "check"

/**
 * GTK_STYLE_CLASS_DEFAULT:
 *
 * A CSS class to match the default widget.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_DEFAULT "default"

/**
 * GTK_STYLE_CLASS_TROUGH:
 *
 * A CSS class to match troughs, as in scrollbars and progressbars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_TROUGH "trough"

/**
 * GTK_STYLE_CLASS_SCROLLBAR:
 *
 * A CSS class to match scrollbars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SCROLLBAR "scrollbar"

/**
 * GTK_STYLE_CLASS_SCROLLBARS_JUNCTION:
 *
 * A CSS class to match the junction area between an horizontal
 * and vertical scrollbar, when they’re both shown.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SCROLLBARS_JUNCTION "scrollbars-junction"

/**
 * GTK_STYLE_CLASS_SCALE:
 *
 * A CSS class to match scale widgets.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SCALE "scale"

/**
 * GTK_STYLE_CLASS_SCALE_HAS_MARKS_ABOVE:
 *
 * A CSS class to match scale widgets with marks attached,
 * all the marks are above for horizontal #GtkScale.
 * left for vertical #GtkScale.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SCALE_HAS_MARKS_ABOVE "scale-has-marks-above"

/**
 * GTK_STYLE_CLASS_SCALE_HAS_MARKS_BELOW:
 *
 * A CSS class to match scale widgets with marks attached,
 * all the marks are below for horizontal #GtkScale,
 * right for vertical #GtkScale.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SCALE_HAS_MARKS_BELOW "scale-has-marks-below"

/**
 * GTK_STYLE_CLASS_HEADER:
 *
 * A CSS class to match a header element.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_HEADER "header"

/**
 * GTK_STYLE_CLASS_ACCELERATOR:
 *
 * A CSS class to match an accelerator.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_ACCELERATOR "accelerator"

/**
 * GTK_STYLE_CLASS_RAISED:
 *
 * A CSS class to match a raised control, such as a raised
 * button on a toolbar.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_RAISED "raised"

/**
 * GTK_STYLE_CLASS_LINKED:
 *
 * A CSS class to match a linked area, such as a box containing buttons
 * belonging to the same control.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_LINKED "linked"

/**
 * GTK_STYLE_CLASS_GRIP:
 *
 * A CSS class defining a resize grip.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_GRIP "grip"

/**
 * GTK_STYLE_CLASS_DOCK:
 *
 * A CSS class defining a dock area.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_DOCK "dock"

/**
 * GTK_STYLE_CLASS_PROGRESSBAR:
 *
 * A CSS class to use when rendering activity as a progressbar.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_PROGRESSBAR "progressbar"

/**
 * GTK_STYLE_CLASS_SPINNER:
 *
 * A CSS class to use when rendering activity as a “spinner”.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SPINNER "spinner"

/**
 * GTK_STYLE_CLASS_MARK:
 *
 * A CSS class defining marks in a widget, such as in scales.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_MARK "mark"

/**
 * GTK_STYLE_CLASS_EXPANDER:
 *
 * A CSS class defining an expander, such as those in treeviews.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_EXPANDER "expander"

/**
 * GTK_STYLE_CLASS_SPINBUTTON:
 *
 * A CSS class defining an spinbutton.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SPINBUTTON "spinbutton"

/**
 * GTK_STYLE_CLASS_NOTEBOOK:
 *
 * A CSS class defining a notebook.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_NOTEBOOK "notebook"

/**
 * GTK_STYLE_CLASS_VIEW:
 *
 * A CSS class defining a view, such as iconviews or treeviews.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_VIEW "view"

/**
 * GTK_STYLE_CLASS_SIDEBAR:
 *
 * A CSS class defining a sidebar, such as the left side in
 * a file chooser.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SIDEBAR "sidebar"

/**
 * GTK_STYLE_CLASS_IMAGE:
 *
 * A CSS class defining an image, such as the icon in an entry.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_IMAGE "image"

/**
 * GTK_STYLE_CLASS_HIGHLIGHT:
 *
 * A CSS class defining a highlighted area, such as headings in
 * assistants and calendars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_HIGHLIGHT "highlight"

/**
 * GTK_STYLE_CLASS_FRAME:
 *
 * A CSS class defining a frame delimiting content, such as
 * #GtkFrame or the scrolled window frame around the
 * scrollable area.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_FRAME "frame"

/**
 * GTK_STYLE_CLASS_DND:
 *
 * A CSS class for a drag-and-drop indicator.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_DND "dnd"

/**
 * GTK_STYLE_CLASS_PANE_SEPARATOR:
 *
 * A CSS class for a pane separator, such as those in #GtkPaned.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_PANE_SEPARATOR "pane-separator"

/**
 * GTK_STYLE_CLASS_SEPARATOR:
 *
 * A CSS class for a separator.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_SEPARATOR "separator"

/**
 * GTK_STYLE_CLASS_INFO:
 *
 * A CSS class for an area displaying an informational message,
 * such as those in infobars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_INFO "info"

/**
 * GTK_STYLE_CLASS_WARNING:
 *
 * A CSS class for an area displaying a warning message,
 * such as those in infobars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_WARNING "warning"

/**
 * GTK_STYLE_CLASS_QUESTION:
 *
 * A CSS class for an area displaying a question to the user,
 * such as those in infobars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_QUESTION "question"

/**
 * GTK_STYLE_CLASS_ERROR:
 *
 * A CSS class for an area displaying an error message,
 * such as those in infobars.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_ERROR "error"

/**
 * GTK_STYLE_CLASS_HORIZONTAL:
 *
 * A CSS class for horizontally layered widgets.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_HORIZONTAL "horizontal"

/**
 * GTK_STYLE_CLASS_VERTICAL:
 *
 * A CSS class for vertically layered widgets.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_VERTICAL "vertical"

/**
 * GTK_STYLE_CLASS_TOP:
 *
 * A CSS class to indicate an area at the top of a widget.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_TOP "top"

/**
 * GTK_STYLE_CLASS_BOTTOM:
 *
 * A CSS class to indicate an area at the bottom of a widget.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_BOTTOM "bottom"

/**
 * GTK_STYLE_CLASS_LEFT:
 *
 * A CSS class to indicate an area at the left of a widget.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_LEFT "left"

/**
 * GTK_STYLE_CLASS_RIGHT:
 *
 * A CSS class to indicate an area at the right of a widget.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_RIGHT "right"

/**
 * GTK_STYLE_CLASS_PULSE:
 *
 * A CSS class to use when rendering a pulse in an indeterminate progress bar.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_PULSE "pulse"

/**
 * GTK_STYLE_CLASS_ARROW:
 *
 * A CSS class used when rendering an arrow element.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_ARROW "arrow"

/**
 * GTK_STYLE_CLASS_OSD:
 *
 * A CSS class used when rendering an OSD (On Screen Display) element,
 * on top of another container.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_OSD "osd"

/**
 * GTK_STYLE_CLASS_LEVEL_BAR:
 *
 * A CSS class used when rendering a level indicator, such
 * as a battery charge level, or a password strength.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_LEVEL_BAR "level-bar"

/**
 * GTK_STYLE_CLASS_CURSOR_HANDLE:
 *
 * A CSS class used when rendering a drag handle for
 * text selection.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_CURSOR_HANDLE "cursor-handle"

/**
 * GTK_STYLE_CLASS_INSERTION_CURSOR:
 *
 * A CSS class used when rendering a drag handle for
 * the insertion cursor position.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_INSERTION_CURSOR "insertion-cursor"

/**
 * GTK_STYLE_CLASS_TITLEBAR:
 *
 * A CSS class used when rendering a titlebar in a toplevel window.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_TITLEBAR "titlebar"

/**
 * GTK_STYLE_CLASS_TITLE:
 *
 * A CSS class used for the title label in a titlebar in
 * a toplevel window.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.14
 */
#define GTK_STYLE_CLASS_TITLE "title"

/**
 * GTK_STYLE_CLASS_SUBTITLE:
 *
 * A CSS class used for the subtitle label in a titlebar in
 * a toplevel window.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.14
 */
#define GTK_STYLE_CLASS_SUBTITLE "subtitle"

/**
 * GTK_STYLE_CLASS_NEEDS_ATTENTION:
 *
 * A CSS class used when an element needs the user attention,
 * for instance a button in a stack switcher corresponding to
 * a hidden page that changed state.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.12
 */
#define GTK_STYLE_CLASS_NEEDS_ATTENTION "needs-attention"

/**
 * GTK_STYLE_CLASS_SUGGESTED_ACTION:
 *
 * A CSS class used when an action (usually a button) is the
 * primary suggested action in a specific context.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.12
 */
#define GTK_STYLE_CLASS_SUGGESTED_ACTION "suggested-action"

/**
 * GTK_STYLE_CLASS_DESTRUCTIVE_ACTION:
 *
 * A CSS class used when an action (usually a button) is
 * one that is expected to remove or destroy something visible
 * to the user.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.12
 */
#define GTK_STYLE_CLASS_DESTRUCTIVE_ACTION "destructive-action"

/**
 * GTK_STYLE_CLASS_POPOVER:
 *
 * A CSS class that matches popovers.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.14
 */
#define GTK_STYLE_CLASS_POPOVER "popover"

/* Predefined set of widget regions */

/**
 * GTK_STYLE_CLASS_POPUP:
 *
 * A CSS class that is added to the toplevel windows used for menus.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.14
 */
#define GTK_STYLE_CLASS_POPUP "popup"

/**
 * GTK_STYLE_CLASS_MESSAGE_DIALOG:
 *
 * A CSS class that is added to message dialogs.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.14
 */
#define GTK_STYLE_CLASS_MESSAGE_DIALOG "message-dialog"

/**
 * GTK_STYLE_CLASS_FLAT:
 *
 * A CSS class that is added when widgets that usually have
 * a frame or border (like buttons or entries) should appear
 * without it.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.14
 */
#define GTK_STYLE_CLASS_FLAT "flat"

/**
 * GTK_STYLE_CLASS_READ_ONLY:
 *
 * A CSS class used to indicate a read-only state.
 *
 * Refer to individual widget documentation for used style classes.
 */
#define GTK_STYLE_CLASS_READ_ONLY "read-only"

/**
 * GTK_STYLE_CLASS_OVERSHOOT:
 *
 * A CSS class that is added on the visual hints that happen
 * when scrolling is attempted past the limits of a scrollable
 * area.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.14
 */
#define GTK_STYLE_CLASS_OVERSHOOT "overshoot"

/**
 * GTK_STYLE_CLASS_UNDERSHOOT:
 *
 * A CSS class that is added on the visual hints that happen
 * where content is 'scrolled off' and can be made visible
 * by scrolling.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.16
 */
#define GTK_STYLE_CLASS_UNDERSHOOT "undershoot"

/**
 * GTK_STYLE_CLASS_PAPER:
 *
 * A CSS class that is added to areas that should look like paper.
 *
 * This is used in print previews and themes are encouraged to
 * style it as black text on white background.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.16
 */
#define GTK_STYLE_CLASS_PAPER "paper"

/**
 * GTK_STYLE_CLASS_MONOSPACE:
 *
 * A CSS class that is added to text view that should use
 * a monospace font.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.16
 */
#define GTK_STYLE_CLASS_MONOSPACE "monospace"

/**
 * GTK_STYLE_CLASS_WIDE:
 *
 * A CSS class to indicate that a UI element should be 'wide'.
 * Used by #GtkPaned.
 *
 * Refer to individual widget documentation for used style classes.
 *
 * Since: 3.16
 */
#define GTK_STYLE_CLASS_WIDE "wide"

/**
 * GTK_STYLE_REGION_ROW:
 *
 * A widget region name to define a treeview row.
 *
 * Deprecated: 3.20: Don't use regions.
 */
#define GTK_STYLE_REGION_ROW "row"

/**
 * GTK_STYLE_REGION_COLUMN:
 *
 * A widget region name to define a treeview column.
 *
 * Deprecated: 3.20: Don't use regions.
 */
#define GTK_STYLE_REGION_COLUMN "column"

/**
 * GTK_STYLE_REGION_COLUMN_HEADER:
 *
 * A widget region name to define a treeview column header.
 *
 * Deprecated: 3.20: Don't use regions.
 */
#define GTK_STYLE_REGION_COLUMN_HEADER "column-header"

/**
 * GTK_STYLE_REGION_TAB:
 *
 * A widget region name to define a notebook tab.
 *
 * Deprecated: 3.20: Don't use regions.
 */
#define GTK_STYLE_REGION_TAB "tab"

GDK_AVAILABLE_IN_ALL
GType gtk_style_context_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkStyleContext * gtk_style_context_new (void);

GDK_AVAILABLE_IN_ALL
void gtk_style_context_add_provider_for_screen    (GdkScreen        *screen,
                                                   GtkStyleProvider *provider,
                                                   guint             priority);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_remove_provider_for_screen (GdkScreen        *screen,
                                                   GtkStyleProvider *provider);

GDK_AVAILABLE_IN_ALL
void gtk_style_context_add_provider    (GtkStyleContext  *context,
                                        GtkStyleProvider *provider,
                                        guint             priority);

GDK_AVAILABLE_IN_ALL
void gtk_style_context_remove_provider (GtkStyleContext  *context,
                                        GtkStyleProvider *provider);

GDK_AVAILABLE_IN_ALL
void gtk_style_context_save    (GtkStyleContext *context);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_restore (GtkStyleContext *context);

GDK_AVAILABLE_IN_ALL
GtkCssSection * gtk_style_context_get_section (GtkStyleContext *context,
                                               const char     *property);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_get_property (GtkStyleContext *context,
                                     const char     *property,
                                     GtkStateFlags    state,
                                     GValue          *value);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_get_valist   (GtkStyleContext *context,
                                     GtkStateFlags    state,
                                     va_list          args);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_get          (GtkStyleContext *context,
                                     GtkStateFlags    state,
                                     ...) G_GNUC_NULL_TERMINATED;

GDK_AVAILABLE_IN_ALL
void          gtk_style_context_set_state    (GtkStyleContext *context,
                                              GtkStateFlags    flags);
GDK_AVAILABLE_IN_ALL
GtkStateFlags gtk_style_context_get_state    (GtkStyleContext *context);

GDK_AVAILABLE_IN_3_10
void          gtk_style_context_set_scale    (GtkStyleContext *context,
                                              gint             scale);
GDK_AVAILABLE_IN_3_10
gint          gtk_style_context_get_scale    (GtkStyleContext *context);

GDK_DEPRECATED_IN_3_6
gboolean      gtk_style_context_state_is_running (GtkStyleContext *context,
                                                  GtkStateType     state,
                                                  gdouble         *progress);

GDK_AVAILABLE_IN_ALL
void          gtk_style_context_set_path     (GtkStyleContext *context,
                                              GtkWidgetPath   *path);
GDK_AVAILABLE_IN_ALL
const GtkWidgetPath * gtk_style_context_get_path (GtkStyleContext *context);
GDK_AVAILABLE_IN_3_4
void          gtk_style_context_set_parent   (GtkStyleContext *context,
                                              GtkStyleContext *parent);
GDK_AVAILABLE_IN_ALL
GtkStyleContext *gtk_style_context_get_parent (GtkStyleContext *context);

GDK_AVAILABLE_IN_ALL
GList *  gtk_style_context_list_classes (GtkStyleContext *context);

GDK_AVAILABLE_IN_ALL
void     gtk_style_context_add_class    (GtkStyleContext *context,
                                         const char     *class_name);
GDK_AVAILABLE_IN_ALL
void     gtk_style_context_remove_class (GtkStyleContext *context,
                                         const char     *class_name);
GDK_AVAILABLE_IN_ALL
gboolean gtk_style_context_has_class    (GtkStyleContext *context,
                                         const char     *class_name);

GDK_DEPRECATED_IN_3_14
GList *  gtk_style_context_list_regions (GtkStyleContext *context);

GDK_DEPRECATED_IN_3_14
void     gtk_style_context_add_region    (GtkStyleContext    *context,
                                          const char        *region_name,
                                          GtkRegionFlags      flags);
GDK_DEPRECATED_IN_3_14
void     gtk_style_context_remove_region (GtkStyleContext    *context,
                                          const char        *region_name);
GDK_DEPRECATED_IN_3_14
gboolean gtk_style_context_has_region    (GtkStyleContext    *context,
                                          const char        *region_name,
                                          GtkRegionFlags     *flags_return);

GDK_AVAILABLE_IN_ALL
void gtk_style_context_get_style_property (GtkStyleContext *context,
                                           const char     *property_name,
                                           GValue          *value);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_get_style_valist   (GtkStyleContext *context,
                                           va_list          args);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_get_style          (GtkStyleContext *context,
                                           ...);

GDK_DEPRECATED_IN_3_10_FOR(gtk_icon_theme_lookup_icon)
GtkIconSet * gtk_style_context_lookup_icon_set (GtkStyleContext *context,
                                                const char     *stock_id);
GDK_DEPRECATED_IN_3_10
GdkPixbuf  * gtk_icon_set_render_icon_pixbuf   (GtkIconSet      *icon_set,
                                                GtkStyleContext *context,
                                                GtkIconSize      size);
GDK_DEPRECATED_IN_3_10
cairo_surface_t  *
gtk_icon_set_render_icon_surface               (GtkIconSet      *icon_set,
						GtkStyleContext *context,
						GtkIconSize      size,
						int              scale,
						GdkWindow       *for_window);

GDK_AVAILABLE_IN_ALL
void        gtk_style_context_set_screen (GtkStyleContext *context,
                                          GdkScreen       *screen);
GDK_AVAILABLE_IN_ALL
GdkScreen * gtk_style_context_get_screen (GtkStyleContext *context);

GDK_AVAILABLE_IN_3_8
void           gtk_style_context_set_frame_clock (GtkStyleContext *context,
                                                  GdkFrameClock   *frame_clock);
GDK_AVAILABLE_IN_3_8
GdkFrameClock *gtk_style_context_get_frame_clock (GtkStyleContext *context);

GDK_DEPRECATED_IN_3_8_FOR(gtk_style_context_set_state)
void             gtk_style_context_set_direction (GtkStyleContext  *context,
                                                  GtkTextDirection  direction);
GDK_DEPRECATED_IN_3_8_FOR(gtk_style_context_get_state)
GtkTextDirection gtk_style_context_get_direction (GtkStyleContext  *context);

GDK_AVAILABLE_IN_ALL
void             gtk_style_context_set_junction_sides (GtkStyleContext  *context,
                                                       GtkJunctionSides  sides);
GDK_AVAILABLE_IN_ALL
GtkJunctionSides gtk_style_context_get_junction_sides (GtkStyleContext  *context);

GDK_AVAILABLE_IN_ALL
gboolean gtk_style_context_lookup_color (GtkStyleContext *context,
                                         const char     *color_name,
                                         GdkRGBA         *color);

GDK_DEPRECATED_IN_3_6
void  gtk_style_context_notify_state_change (GtkStyleContext *context,
                                             GdkWindow       *window,
                                             gpointer         region_id,
                                             GtkStateType     state,
                                             gboolean         state_value);
GDK_DEPRECATED_IN_3_6
void  gtk_style_context_cancel_animations   (GtkStyleContext *context,
                                             gpointer         region_id);
GDK_DEPRECATED_IN_3_6
void  gtk_style_context_scroll_animations   (GtkStyleContext *context,
                                             GdkWindow       *window,
                                             gint             dx,
                                             gint             dy);

GDK_DEPRECATED_IN_3_6
void gtk_style_context_push_animatable_region (GtkStyleContext *context,
                                               gpointer         region_id);
GDK_DEPRECATED_IN_3_6
void gtk_style_context_pop_animatable_region  (GtkStyleContext *context);

/* Some helper functions to retrieve most common properties */
GDK_AVAILABLE_IN_ALL
void gtk_style_context_get_color            (GtkStyleContext *context,
                                             GtkStateFlags    state,
                                             GdkRGBA         *color);
GDK_DEPRECATED_IN_3_16_FOR(gtk_render_background)
void gtk_style_context_get_background_color (GtkStyleContext *context,
                                             GtkStateFlags    state,
                                             GdkRGBA         *color);
GDK_DEPRECATED_IN_3_16_FOR(gtk_render_frame)
void gtk_style_context_get_border_color     (GtkStyleContext *context,
                                             GtkStateFlags    state,
                                             GdkRGBA         *color);

GDK_DEPRECATED_IN_3_8_FOR(gtk_style_context_get)
const PangoFontDescription *
     gtk_style_context_get_font             (GtkStyleContext *context,
                                             GtkStateFlags    state);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_get_border           (GtkStyleContext *context,
                                             GtkStateFlags    state,
                                             GtkBorder       *border);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_get_padding          (GtkStyleContext *context,
                                             GtkStateFlags    state,
                                             GtkBorder       *padding);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_get_margin           (GtkStyleContext *context,
                                             GtkStateFlags    state,
                                             GtkBorder       *margin);

GDK_DEPRECATED_IN_3_12
void gtk_style_context_invalidate           (GtkStyleContext *context);
GDK_AVAILABLE_IN_ALL
void gtk_style_context_reset_widgets        (GdkScreen       *screen);

GDK_DEPRECATED_IN_3_18_FOR(gtk_render_background)
void gtk_style_context_set_background       (GtkStyleContext *context,
                                             GdkWindow       *window);

GDK_AVAILABLE_IN_3_4
void        gtk_render_insertion_cursor
                                   (GtkStyleContext     *context,
                                    cairo_t             *cr,
                                    gdouble              x,
                                    gdouble              y,
                                    PangoLayout         *layout,
                                    int                  index,
                                    PangoDirection       direction);
GDK_DEPRECATED_IN_3_4
void   gtk_draw_insertion_cursor    (GtkWidget          *widget,
                                     cairo_t            *cr,
                                     const GdkRectangle *location,
                                     gboolean            is_primary,
                                     GtkTextDirection    direction,
                                     gboolean            draw_arrow);

typedef enum {
  GTK_STYLE_CONTEXT_PRINT_NONE         = 0,
  GTK_STYLE_CONTEXT_PRINT_RECURSE      = 1 << 0,
  GTK_STYLE_CONTEXT_PRINT_SHOW_STYLE   = 1 << 1
} GtkStyleContextPrintFlags;
typedef struct GtkIconThemePrivate{} GtkIconThemePrivate;
struct GtkIconTheme
{
  /*< private >*/
  GObject parent_instance;

  GtkIconThemePrivate *priv;
};
struct GtkIconThemeClass
{
  GObjectClass parent_class;

  /*< public >*/

  void (* changed)  (GtkIconTheme *icon_theme);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};
typedef struct _GtkIconInfo{} GtkIconInfo;
typedef struct _GtkIconInfoClass{} GtkIconInfoClass;

GDK_AVAILABLE_IN_3_20
char * gtk_style_context_to_string (GtkStyleContext           *context,
                                    GtkStyleContextPrintFlags  flags);

G_END_DECLS

#endif /* __GTK_STYLE_CONTEXT_H__ */
#define headerfilename "gtk/./gtkicontheme.h"
/* file: gtk/./gtkicontheme.h */
/* GtkIconTheme - a loader for icon themes
 * gtk-icon-loader.h Copyright (C) 2002, 2003 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_ICON_THEME_H__
#define __GTK_ICON_THEME_H__



#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gtk/gtkstylecontext.h>

G_BEGIN_DECLS

#define GTK_TYPE_ICON_INFO()              (gtk_icon_info_get_type ())
#define GTK_ICON_INFO(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ICON_INFO, GtkIconInfo))
#define GTK_ICON_INFO_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ICON_INFO, GtkIconInfoClass))
#define GTK_IS_ICON_INFO(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ICON_INFO))
#define GTK_IS_ICON_INFO_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ICON_INFO))
#define GTK_ICON_INFO_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ICON_INFO, GtkIconInfoClass))

#define GTK_TYPE_ICON_THEME()             (gtk_icon_theme_get_type ())
#define GTK_ICON_THEME(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ICON_THEME, GtkIconTheme))
#define GTK_ICON_THEME_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ICON_THEME, GtkIconThemeClass))
#define GTK_IS_ICON_THEME(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ICON_THEME))
#define GTK_IS_ICON_THEME_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ICON_THEME))
#define GTK_ICON_THEME_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ICON_THEME, GtkIconThemeClass))

/**
 * GtkIconInfo:
 *
 * Contains information found when looking up an icon in
 * an icon theme.
 */

/**
 * GtkIconTheme:
 *
 * Acts as a database of information about an icon theme.
 * Normally, you retrieve the icon theme for a particular
 * screen using gtk_icon_theme_get_for_screen() and it
 * will contain information about current icon theme for
 * that screen, but you can also create a new #GtkIconTheme
 * object and set the icon theme name explicitly using
 * gtk_icon_theme_set_custom_theme().
 */

/**
 * GtkIconThemeClass:
 * @parent_class: The parent class.
 * @changed: Signal emitted when the current icon theme is switched or
 *    GTK+ detects that a change has occurred in the contents of the
 *    current icon theme.
 */

/**
 * GtkIconLookupFlags:
 * @GTK_ICON_LOOKUP_NO_SVG: Never get SVG icons, even if gdk-pixbuf
 *   supports them. Cannot be used together with %GTK_ICON_LOOKUP_FORCE_SVG.
 * @GTK_ICON_LOOKUP_FORCE_SVG: Get SVG icons, even if gdk-pixbuf
 *   doesn’t support them.
 *   Cannot be used together with %GTK_ICON_LOOKUP_NO_SVG.
 * @GTK_ICON_LOOKUP_USE_BUILTIN: When passed to
 *   gtk_icon_theme_lookup_icon() includes builtin icons
 *   as well as files. For a builtin icon, gtk_icon_info_get_filename()
 *   is %NULL and you need to call gtk_icon_info_get_builtin_pixbuf().
 * @GTK_ICON_LOOKUP_GENERIC_FALLBACK: Try to shorten icon name at '-'
 *   characters before looking at inherited themes. This flag is only
 *   supported in functions that take a single icon name. For more general
 *   fallback, see gtk_icon_theme_choose_icon(). Since 2.12.
 * @GTK_ICON_LOOKUP_FORCE_SIZE: Always get the icon scaled to the
 *   requested size. Since 2.14.
 * @GTK_ICON_LOOKUP_FORCE_REGULAR: Try to always load regular icons, even
 *   when symbolic icon names are given. Since 3.14.
 * @GTK_ICON_LOOKUP_FORCE_SYMBOLIC: Try to always load symbolic icons, even
 *   when regular icon names are given. Since 3.14.
 * @GTK_ICON_LOOKUP_DIR_LTR: Try to load a variant of the icon for left-to-right
 *   text direction. Since 3.14.
 * @GTK_ICON_LOOKUP_DIR_RTL: Try to load a variant of the icon for right-to-left
 *   text direction. Since 3.14.
 * 
 * Used to specify options for gtk_icon_theme_lookup_icon()
 */
typedef enum
{
  GTK_ICON_LOOKUP_NO_SVG           = 1 << 0,
  GTK_ICON_LOOKUP_FORCE_SVG        = 1 << 1,
  GTK_ICON_LOOKUP_USE_BUILTIN      = 1 << 2,
  GTK_ICON_LOOKUP_GENERIC_FALLBACK = 1 << 3,
  GTK_ICON_LOOKUP_FORCE_SIZE       = 1 << 4,
  GTK_ICON_LOOKUP_FORCE_REGULAR    = 1 << 5,
  GTK_ICON_LOOKUP_FORCE_SYMBOLIC   = 1 << 6,
  GTK_ICON_LOOKUP_DIR_LTR          = 1 << 7,
  GTK_ICON_LOOKUP_DIR_RTL          = 1 << 8
} GtkIconLookupFlags;

/**
 * GTK_ICON_THEME_ERROR:
 *
 * The #GQuark used for #GtkIconThemeError errors.
 */
#define GTK_ICON_THEME_ERROR() gtk_icon_theme_error_quark ()

/**
 * GtkIconThemeError:
 * @GTK_ICON_THEME_NOT_FOUND: The icon specified does not exist in the theme
 * @GTK_ICON_THEME_FAILED: An unspecified error occurred.
 * 
 * Error codes for GtkIconTheme operations.
 **/
typedef enum {
  GTK_ICON_THEME_NOT_FOUND,
  GTK_ICON_THEME_FAILED
} GtkIconThemeError;
typedef struct GtkIconViewPrivate{} GtkIconViewPrivate;
struct GtkIconView
{
  GtkContainer parent;

  /*< private >*/
  GtkIconViewPrivate *priv;
};
struct GtkIconViewClass
{
  GtkContainerClass parent_class;

  void    (* item_activated)         (GtkIconView      *icon_view,
				      GtkTreePath      *path);
  void    (* selection_changed)      (GtkIconView      *icon_view);

  /* Key binding signals */
  void    (* select_all)             (GtkIconView      *icon_view);
  void    (* unselect_all)           (GtkIconView      *icon_view);
  void    (* select_cursor_item)     (GtkIconView      *icon_view);
  void    (* toggle_cursor_item)     (GtkIconView      *icon_view);
  gboolean (* move_cursor)           (GtkIconView      *icon_view,
				      GtkMovementStep   step,
				      gint              count);
  gboolean (* activate_cursor_item)  (GtkIconView      *icon_view);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GQuark gtk_icon_theme_error_quark (void);

GDK_AVAILABLE_IN_ALL
GType         gtk_icon_theme_get_type              (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkIconTheme *gtk_icon_theme_new                   (void);
GDK_AVAILABLE_IN_ALL
GtkIconTheme *gtk_icon_theme_get_default           (void);
GDK_AVAILABLE_IN_ALL
GtkIconTheme *gtk_icon_theme_get_for_screen        (GdkScreen                   *screen);
GDK_AVAILABLE_IN_ALL
void          gtk_icon_theme_set_screen            (GtkIconTheme                *icon_theme,
						    GdkScreen                   *screen);

GDK_AVAILABLE_IN_ALL
void          gtk_icon_theme_set_search_path       (GtkIconTheme                *icon_theme,
						    const char                 *path[],
						    gint                         n_elements);
GDK_AVAILABLE_IN_ALL
void          gtk_icon_theme_get_search_path       (GtkIconTheme                *icon_theme,
						    char                      **path[],
						    gint                        *n_elements);
GDK_AVAILABLE_IN_ALL
void          gtk_icon_theme_append_search_path    (GtkIconTheme                *icon_theme,
						    const char                 *path);
GDK_AVAILABLE_IN_ALL
void          gtk_icon_theme_prepend_search_path   (GtkIconTheme                *icon_theme,
						    const char                 *path);

GDK_AVAILABLE_IN_3_14
void          gtk_icon_theme_add_resource_path     (GtkIconTheme                *icon_theme,
                                                    const char                 *path);

GDK_AVAILABLE_IN_ALL
void          gtk_icon_theme_set_custom_theme      (GtkIconTheme                *icon_theme,
						    const char                 *theme_name);

GDK_AVAILABLE_IN_ALL
gboolean      gtk_icon_theme_has_icon              (GtkIconTheme                *icon_theme,
						    const char                 *icon_name);
GDK_AVAILABLE_IN_ALL
gint         *gtk_icon_theme_get_icon_sizes        (GtkIconTheme                *icon_theme,
						    const char                 *icon_name);
GDK_AVAILABLE_IN_ALL
GtkIconInfo * gtk_icon_theme_lookup_icon           (GtkIconTheme                *icon_theme,
						    const char                 *icon_name,
						    gint                         size,
						    GtkIconLookupFlags           flags);
GDK_AVAILABLE_IN_3_10
GtkIconInfo * gtk_icon_theme_lookup_icon_for_scale (GtkIconTheme                *icon_theme,
                                                    const char                 *icon_name,
                                                    gint                         size,
                                                    gint                         scale,
                                                    GtkIconLookupFlags           flags);

GDK_AVAILABLE_IN_ALL
GtkIconInfo * gtk_icon_theme_choose_icon           (GtkIconTheme                *icon_theme,
						    const char                 *icon_names[],
						    gint                         size,
						    GtkIconLookupFlags           flags);
GDK_AVAILABLE_IN_3_10
GtkIconInfo * gtk_icon_theme_choose_icon_for_scale (GtkIconTheme                *icon_theme,
						    const char                 *icon_names[],
						    gint                         size,
                                                    gint                         scale,
						    GtkIconLookupFlags           flags);
GDK_AVAILABLE_IN_ALL
GdkPixbuf *   gtk_icon_theme_load_icon             (GtkIconTheme                *icon_theme,
						    const char                 *icon_name,
						    gint                         size,
						    GtkIconLookupFlags           flags,
						    GError                     **error);
GDK_AVAILABLE_IN_3_10
GdkPixbuf *   gtk_icon_theme_load_icon_for_scale   (GtkIconTheme                *icon_theme,
                                                    const char                 *icon_name,
                                                    gint                         size,
                                                    gint                         scale,
                                                    GtkIconLookupFlags           flags,
                                                    GError                     **error);
GDK_AVAILABLE_IN_3_10
cairo_surface_t * gtk_icon_theme_load_surface      (GtkIconTheme        *icon_theme,
						    const char         *icon_name,
						    gint                 size,
						    gint                 scale,
						    GdkWindow           *for_window,
						    GtkIconLookupFlags   flags,
						    GError             **error);

GDK_AVAILABLE_IN_ALL
GtkIconInfo * gtk_icon_theme_lookup_by_gicon       (GtkIconTheme                *icon_theme,
                                                    GIcon                       *icon,
                                                    gint                         size,
                                                    GtkIconLookupFlags           flags);
GDK_AVAILABLE_IN_3_10
GtkIconInfo * gtk_icon_theme_lookup_by_gicon_for_scale (GtkIconTheme             *icon_theme,
                                                        GIcon                    *icon,
                                                        gint                      size,
                                                        gint                      scale,
                                                        GtkIconLookupFlags        flags);


GDK_AVAILABLE_IN_ALL
GList *       gtk_icon_theme_list_icons            (GtkIconTheme                *icon_theme,
						    const char                 *context);
GDK_AVAILABLE_IN_ALL
GList *       gtk_icon_theme_list_contexts         (GtkIconTheme                *icon_theme);
GDK_AVAILABLE_IN_ALL
char *        gtk_icon_theme_get_example_icon_name (GtkIconTheme                *icon_theme);

GDK_AVAILABLE_IN_ALL
gboolean      gtk_icon_theme_rescan_if_needed      (GtkIconTheme                *icon_theme);

GDK_DEPRECATED_IN_3_14_FOR(gtk_icon_theme_add_resource_path)
void          gtk_icon_theme_add_builtin_icon      (const char *icon_name,
					            gint         size,
					            GdkPixbuf   *pixbuf);

GDK_AVAILABLE_IN_ALL
GType                 gtk_icon_info_get_type           (void) G_GNUC_CONST;
GDK_DEPRECATED_IN_3_8_FOR(g_object_ref)
GtkIconInfo *         gtk_icon_info_copy               (GtkIconInfo  *icon_info);
GDK_DEPRECATED_IN_3_8_FOR(g_object_unref)
void                  gtk_icon_info_free               (GtkIconInfo  *icon_info);

GDK_AVAILABLE_IN_ALL
GtkIconInfo *         gtk_icon_info_new_for_pixbuf     (GtkIconTheme  *icon_theme,
                                                        GdkPixbuf     *pixbuf);

GDK_AVAILABLE_IN_ALL
gint                  gtk_icon_info_get_base_size      (GtkIconInfo   *icon_info);
GDK_AVAILABLE_IN_3_10
gint                  gtk_icon_info_get_base_scale     (GtkIconInfo   *icon_info);
GDK_AVAILABLE_IN_ALL
const char *         gtk_icon_info_get_filename       (GtkIconInfo   *icon_info);
GDK_DEPRECATED_IN_3_14
GdkPixbuf *           gtk_icon_info_get_builtin_pixbuf (GtkIconInfo   *icon_info);
GDK_AVAILABLE_IN_3_12
gboolean              gtk_icon_info_is_symbolic        (GtkIconInfo   *icon_info);
GDK_AVAILABLE_IN_ALL
GdkPixbuf *           gtk_icon_info_load_icon          (GtkIconInfo   *icon_info,
							GError       **error);
GDK_AVAILABLE_IN_3_10
cairo_surface_t *     gtk_icon_info_load_surface       (GtkIconInfo   *icon_info,
							GdkWindow     *for_window,
							GError       **error);
GDK_AVAILABLE_IN_3_8
void                  gtk_icon_info_load_icon_async   (GtkIconInfo          *icon_info,
						       GCancellable         *cancellable,
						       GAsyncReadyCallback   callback,
						       gpointer              user_data);
GDK_AVAILABLE_IN_3_8
GdkPixbuf *           gtk_icon_info_load_icon_finish  (GtkIconInfo          *icon_info,
						       GAsyncResult         *res,
						       GError              **error);
GDK_AVAILABLE_IN_ALL
GdkPixbuf *           gtk_icon_info_load_symbolic      (GtkIconInfo   *icon_info,
                                                        const GdkRGBA *fg,
                                                        const GdkRGBA *success_color,
                                                        const GdkRGBA *warning_color,
                                                        const GdkRGBA *error_color,
                                                        gboolean      *was_symbolic,
                                                        GError       **error);
GDK_AVAILABLE_IN_3_8
void                  gtk_icon_info_load_symbolic_async (GtkIconInfo   *icon_info,
							 const GdkRGBA *fg,
							 const GdkRGBA *success_color,
							 const GdkRGBA *warning_color,
							 const GdkRGBA *error_color,
							 GCancellable         *cancellable,
							 GAsyncReadyCallback   callback,
							 gpointer              user_data);
GDK_AVAILABLE_IN_3_8
GdkPixbuf *           gtk_icon_info_load_symbolic_finish (GtkIconInfo   *icon_info,
							  GAsyncResult         *res,
							  gboolean      *was_symbolic,
							  GError       **error);
GDK_AVAILABLE_IN_ALL
GdkPixbuf *           gtk_icon_info_load_symbolic_for_context (GtkIconInfo      *icon_info,
                                                               GtkStyleContext  *context,
                                                               gboolean         *was_symbolic,
                                                               GError          **error);
GDK_AVAILABLE_IN_3_8
void                  gtk_icon_info_load_symbolic_for_context_async (GtkIconInfo      *icon_info,
								     GtkStyleContext  *context,
								     GCancellable     *cancellable,
								     GAsyncReadyCallback callback,
								     gpointer          user_data);
GDK_AVAILABLE_IN_3_8
GdkPixbuf *           gtk_icon_info_load_symbolic_for_context_finish (GtkIconInfo      *icon_info,
								      GAsyncResult     *res,
								      gboolean         *was_symbolic,
								      GError          **error);
GDK_DEPRECATED_IN_3_0_FOR(gtk_icon_info_load_symbol_for_context)
GdkPixbuf *           gtk_icon_info_load_symbolic_for_style  (GtkIconInfo   *icon_info,
                                                              GtkStyle      *style,
                                                              GtkStateType   state,
                                                              gboolean      *was_symbolic,
                                                              GError       **error);
GDK_DEPRECATED_IN_3_14
void                  gtk_icon_info_set_raw_coordinates (GtkIconInfo  *icon_info,
							 gboolean      raw_coordinates);

GDK_DEPRECATED_IN_3_14
gboolean              gtk_icon_info_get_embedded_rect (GtkIconInfo    *icon_info,
						       GdkRectangle   *rectangle);
GDK_DEPRECATED_IN_3_14
gboolean              gtk_icon_info_get_attach_points (GtkIconInfo    *icon_info,
						       GdkPoint      **points,
						       gint           *n_points);
GDK_DEPRECATED_IN_3_14
const char *         gtk_icon_info_get_display_name  (GtkIconInfo    *icon_info);

G_END_DECLS

#endif /* __GTK_ICON_THEME_H__ */
#define headerfilename "gtk/./gtktooltip.h"
/* file: gtk/./gtktooltip.h */
/* gtktooltip.h
 *
 * Copyright (C) 2006-2007 Imendio AB
 * Contact: Kristian Rietveld <kris@imendio.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_TOOLTIP_H__
#define __GTK_TOOLTIP_H__



#include <gtk/gtkwindow.h>

G_BEGIN_DECLS

#define GTK_TYPE_TOOLTIP()                 (gtk_tooltip_get_type ())
#define GTK_TOOLTIP(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TOOLTIP, GtkTooltip))
#define GTK_IS_TOOLTIP(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TOOLTIP))

GDK_AVAILABLE_IN_ALL
GType gtk_tooltip_get_type (void);

GDK_AVAILABLE_IN_ALL
void gtk_tooltip_set_markup              (GtkTooltip         *tooltip,
                                          const char        *markup);
GDK_AVAILABLE_IN_ALL
void gtk_tooltip_set_text                (GtkTooltip         *tooltip,
                                          const char        *text);
GDK_AVAILABLE_IN_ALL
void gtk_tooltip_set_icon                (GtkTooltip         *tooltip,
                                          GdkPixbuf          *pixbuf);
GDK_DEPRECATED_IN_3_10_FOR(gtk_tooltip_set_icon_from_icon_name)
void gtk_tooltip_set_icon_from_stock     (GtkTooltip         *tooltip,
                                          const char        *stock_id,
                                          GtkIconSize         size);
GDK_AVAILABLE_IN_ALL
void gtk_tooltip_set_icon_from_icon_name (GtkTooltip         *tooltip,
				          const char        *icon_name,
				          GtkIconSize         size);
GDK_AVAILABLE_IN_ALL
void gtk_tooltip_set_icon_from_gicon     (GtkTooltip         *tooltip,
					  GIcon              *gicon,
					  GtkIconSize         size);
GDK_AVAILABLE_IN_ALL
void gtk_tooltip_set_custom	         (GtkTooltip         *tooltip,
                                          GtkWidget          *custom_widget);

GDK_AVAILABLE_IN_ALL
void gtk_tooltip_set_tip_area            (GtkTooltip         *tooltip,
                                          const GdkRectangle *rect);

GDK_AVAILABLE_IN_ALL
void gtk_tooltip_trigger_tooltip_query   (GdkDisplay         *display);


G_END_DECLS

#endif /* __GTK_TOOLTIP_H__ */
#define headerfilename "gtk/./gtkiconview.h"
/* file: gtk/./gtkiconview.h */
/* gtkiconview.h
 * Copyright (C) 2002, 2004  Anders Carlsson <andersca@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_ICON_VIEW_H__
#define __GTK_ICON_VIEW_H__



#include <gtk/gtkcontainer.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtkcellrenderer.h>
#include <gtk/gtkcellarea.h>
#include <gtk/gtkselection.h>
#include <gtk/gtktooltip.h>

G_BEGIN_DECLS

#define GTK_TYPE_ICON_VIEW()            (gtk_icon_view_get_type ())
#define GTK_ICON_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ICON_VIEW, GtkIconView))
#define GTK_ICON_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ICON_VIEW, GtkIconViewClass))
#define GTK_IS_ICON_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ICON_VIEW))
#define GTK_IS_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ICON_VIEW))
#define GTK_ICON_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ICON_VIEW, GtkIconViewClass))


/**
 * GtkIconViewForeachFunc:
 * @icon_view: a #GtkIconView
 * @path: The #GtkTreePath of a selected row
 * @data: (closure): user data
 *
 * A function used by gtk_icon_view_selected_foreach() to map all
 * selected rows.  It will be called on every selected row in the view.
 */
typedef void (* GtkIconViewForeachFunc)     (GtkIconView      *icon_view,
					     GtkTreePath      *path,
					     gpointer          data);

/**
 * GtkIconViewDropPosition:
 * @GTK_ICON_VIEW_NO_DROP: no drop possible
 * @GTK_ICON_VIEW_DROP_INTO: dropped item replaces the item
 * @GTK_ICON_VIEW_DROP_LEFT: droppped item is inserted to the left
 * @GTK_ICON_VIEW_DROP_RIGHT: dropped item is inserted to the right
 * @GTK_ICON_VIEW_DROP_ABOVE: dropped item is inserted above
 * @GTK_ICON_VIEW_DROP_BELOW: dropped item is inserted below
 *
 * An enum for determining where a dropped item goes.
 */
typedef enum
{
  GTK_ICON_VIEW_NO_DROP,
  GTK_ICON_VIEW_DROP_INTO,
  GTK_ICON_VIEW_DROP_LEFT,
  GTK_ICON_VIEW_DROP_RIGHT,
  GTK_ICON_VIEW_DROP_ABOVE,
  GTK_ICON_VIEW_DROP_BELOW
} GtkIconViewDropPosition;



GDK_AVAILABLE_IN_ALL
GType          gtk_icon_view_get_type          (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget *    gtk_icon_view_new               (void);
GDK_AVAILABLE_IN_ALL
GtkWidget *    gtk_icon_view_new_with_area     (GtkCellArea    *area);
GDK_AVAILABLE_IN_ALL
GtkWidget *    gtk_icon_view_new_with_model    (GtkTreeModel   *model);

GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_model         (GtkIconView    *icon_view,
 					        GtkTreeModel   *model);
GDK_AVAILABLE_IN_ALL
GtkTreeModel * gtk_icon_view_get_model         (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_text_column   (GtkIconView    *icon_view,
	 	 			        gint            column);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_text_column   (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_markup_column (GtkIconView    *icon_view,
					        gint            column);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_markup_column (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_pixbuf_column (GtkIconView    *icon_view,
					        gint            column);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_pixbuf_column (GtkIconView    *icon_view);

GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_item_orientation (GtkIconView    *icon_view,
                                                   GtkOrientation  orientation);
GDK_AVAILABLE_IN_ALL
GtkOrientation gtk_icon_view_get_item_orientation (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_columns       (GtkIconView    *icon_view,
		 			        gint            columns);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_columns       (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_item_width    (GtkIconView    *icon_view,
					        gint            item_width);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_item_width    (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_spacing       (GtkIconView    *icon_view, 
		 			        gint            spacing);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_spacing       (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_row_spacing   (GtkIconView    *icon_view, 
					        gint            row_spacing);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_row_spacing   (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_column_spacing (GtkIconView    *icon_view, 
					        gint            column_spacing);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_column_spacing (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_margin        (GtkIconView    *icon_view, 
					        gint            margin);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_margin        (GtkIconView    *icon_view);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_item_padding  (GtkIconView    *icon_view, 
					        gint            item_padding);
GDK_AVAILABLE_IN_ALL
gint           gtk_icon_view_get_item_padding  (GtkIconView    *icon_view);

GDK_AVAILABLE_IN_ALL
GtkTreePath *  gtk_icon_view_get_path_at_pos   (GtkIconView     *icon_view,
						gint             x,
						gint             y);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_icon_view_get_item_at_pos   (GtkIconView     *icon_view,
						gint              x,
						gint              y,
						GtkTreePath     **path,
						GtkCellRenderer **cell);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_icon_view_get_visible_range (GtkIconView      *icon_view,
						GtkTreePath     **start_path,
						GtkTreePath     **end_path);
GDK_AVAILABLE_IN_3_8
void           gtk_icon_view_set_activate_on_single_click (GtkIconView  *icon_view,
                                                           gboolean      single);
GDK_AVAILABLE_IN_3_8
gboolean       gtk_icon_view_get_activate_on_single_click (GtkIconView  *icon_view);

GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_selected_foreach   (GtkIconView            *icon_view,
						 GtkIconViewForeachFunc  func,
						 gpointer                data);
GDK_AVAILABLE_IN_ALL
void           gtk_icon_view_set_selection_mode (GtkIconView            *icon_view,
						 GtkSelectionMode        mode);
GDK_AVAILABLE_IN_ALL
GtkSelectionMode gtk_icon_view_get_selection_mode (GtkIconView            *icon_view);
GDK_AVAILABLE_IN_ALL
void             gtk_icon_view_select_path        (GtkIconView            *icon_view,
						   GtkTreePath            *path);
GDK_AVAILABLE_IN_ALL
void             gtk_icon_view_unselect_path      (GtkIconView            *icon_view,
						   GtkTreePath            *path);
GDK_AVAILABLE_IN_ALL
gboolean         gtk_icon_view_path_is_selected   (GtkIconView            *icon_view,
						   GtkTreePath            *path);
GDK_AVAILABLE_IN_ALL
gint             gtk_icon_view_get_item_row       (GtkIconView            *icon_view,
                                                   GtkTreePath            *path);
GDK_AVAILABLE_IN_ALL
gint             gtk_icon_view_get_item_column    (GtkIconView            *icon_view,
                                                   GtkTreePath            *path);
GDK_AVAILABLE_IN_ALL
GList           *gtk_icon_view_get_selected_items (GtkIconView            *icon_view);
GDK_AVAILABLE_IN_ALL
void             gtk_icon_view_select_all         (GtkIconView            *icon_view);
GDK_AVAILABLE_IN_ALL
void             gtk_icon_view_unselect_all       (GtkIconView            *icon_view);
GDK_AVAILABLE_IN_ALL
void             gtk_icon_view_item_activated     (GtkIconView            *icon_view,
						   GtkTreePath            *path);
GDK_AVAILABLE_IN_ALL
void             gtk_icon_view_set_cursor         (GtkIconView            *icon_view,
						   GtkTreePath            *path,
						   GtkCellRenderer        *cell,
						   gboolean                start_editing);
GDK_AVAILABLE_IN_ALL
gboolean         gtk_icon_view_get_cursor         (GtkIconView            *icon_view,
						   GtkTreePath           **path,
						   GtkCellRenderer       **cell);
GDK_AVAILABLE_IN_ALL
void             gtk_icon_view_scroll_to_path     (GtkIconView            *icon_view,
                                                   GtkTreePath            *path,
						   gboolean                use_align,
						   gfloat                  row_align,
                                                   gfloat                  col_align);

/* Drag-and-Drop support */
GDK_AVAILABLE_IN_ALL
void                   gtk_icon_view_enable_model_drag_source (GtkIconView              *icon_view,
							       GdkModifierType           start_button_mask,
							       const GtkTargetEntry     *targets,
							       gint                      n_targets,
							       GdkDragAction             actions);
GDK_AVAILABLE_IN_ALL
void                   gtk_icon_view_enable_model_drag_dest   (GtkIconView              *icon_view,
							       const GtkTargetEntry     *targets,
							       gint                      n_targets,
							       GdkDragAction             actions);
GDK_AVAILABLE_IN_ALL
void                   gtk_icon_view_unset_model_drag_source  (GtkIconView              *icon_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_icon_view_unset_model_drag_dest    (GtkIconView              *icon_view);
GDK_AVAILABLE_IN_ALL
void                   gtk_icon_view_set_reorderable          (GtkIconView              *icon_view,
							       gboolean                  reorderable);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_icon_view_get_reorderable          (GtkIconView              *icon_view);


/* These are useful to implement your own custom stuff. */
GDK_AVAILABLE_IN_ALL
void                   gtk_icon_view_set_drag_dest_item       (GtkIconView              *icon_view,
							       GtkTreePath              *path,
							       GtkIconViewDropPosition   pos);
GDK_AVAILABLE_IN_ALL
void                   gtk_icon_view_get_drag_dest_item       (GtkIconView              *icon_view,
							       GtkTreePath             **path,
							       GtkIconViewDropPosition  *pos);
GDK_AVAILABLE_IN_ALL
gboolean               gtk_icon_view_get_dest_item_at_pos     (GtkIconView              *icon_view,
							       gint                      drag_x,
							       gint                      drag_y,
							       GtkTreePath             **path,
							       GtkIconViewDropPosition  *pos);
GDK_AVAILABLE_IN_ALL
cairo_surface_t       *gtk_icon_view_create_drag_icon         (GtkIconView              *icon_view,
							       GtkTreePath              *path);

GDK_AVAILABLE_IN_ALL
void    gtk_icon_view_convert_widget_to_bin_window_coords     (GtkIconView *icon_view,
                                                               gint         wx,
                                                               gint         wy,
                                                               gint        *bx,
                                                               gint        *by);
GDK_AVAILABLE_IN_3_6
gboolean gtk_icon_view_get_cell_rect                          (GtkIconView     *icon_view,
							       GtkTreePath     *path,
							       GtkCellRenderer *cell,
							       GdkRectangle    *rect);


GDK_AVAILABLE_IN_ALL
void    gtk_icon_view_set_tooltip_item                        (GtkIconView     *icon_view,
                                                               GtkTooltip      *tooltip,
                                                               GtkTreePath     *path);
GDK_AVAILABLE_IN_ALL
void    gtk_icon_view_set_tooltip_cell                        (GtkIconView     *icon_view,
                                                               GtkTooltip      *tooltip,
                                                               GtkTreePath     *path,
                                                               GtkCellRenderer *cell);
GDK_AVAILABLE_IN_ALL
gboolean gtk_icon_view_get_tooltip_context                    (GtkIconView       *icon_view,
                                                               gint              *x,
                                                               gint              *y,
                                                               gboolean           keyboard_tip,
                                                               GtkTreeModel     **model,
                                                               GtkTreePath      **path,
                                                               GtkTreeIter       *iter);
GDK_AVAILABLE_IN_ALL
void     gtk_icon_view_set_tooltip_column                     (GtkIconView       *icon_view,
                                                               gint               column);
GDK_AVAILABLE_IN_ALL
gint     gtk_icon_view_get_tooltip_column                     (GtkIconView       *icon_view);


G_END_DECLS

#endif /* __GTK_ICON_VIEW_H__ */
#define headerfilename "gtk/./gtkimcontextinfo.h"
/* file: gtk/./gtkimcontextinfo.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat Software
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_IM_CONTEXT_INFO_H__
#define __GTK_IM_CONTEXT_INFO_H__




#include <glib.h>

G_BEGIN_DECLS


struct GtkIMContextInfo
{
  const char *context_id;
  const char *context_name;
  const char *domain;
  const char *domain_dirname;
  const char *default_locales;
};
typedef struct GtkIMContextSimplePrivate{} GtkIMContextSimplePrivate;
struct GtkIMContextSimple
{
  GtkIMContext object;

  /*< private >*/
  GtkIMContextSimplePrivate *priv;
};
struct GtkIMContextSimpleClass
{
  GtkIMContextClass parent_class;
};


G_END_DECLS

#endif /* __GTK_IM_CONTEXT_INFO_H__ */
#define headerfilename "gtk/./gtkimcontextsimple.h"
/* file: gtk/./gtkimcontextsimple.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat Software
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_IM_CONTEXT_SIMPLE_H__
#define __GTK_IM_CONTEXT_SIMPLE_H__



#include <gtk/gtkimcontext.h>


G_BEGIN_DECLS

/**
 * GTK_MAX_COMPOSE_LEN:
 *
 * The maximum length of sequences in compose tables.
 */
#define GTK_MAX_COMPOSE_LEN 7

#define GTK_TYPE_IM_CONTEXT_SIMPLE()              (gtk_im_context_simple_get_type ())
#define GTK_IM_CONTEXT_SIMPLE(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_IM_CONTEXT_SIMPLE, GtkIMContextSimple))
#define GTK_IM_CONTEXT_SIMPLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_IM_CONTEXT_SIMPLE, GtkIMContextSimpleClass))
#define GTK_IS_IM_CONTEXT_SIMPLE(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_IM_CONTEXT_SIMPLE))
#define GTK_IS_IM_CONTEXT_SIMPLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IM_CONTEXT_SIMPLE))
#define GTK_IM_CONTEXT_SIMPLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_IM_CONTEXT_SIMPLE, GtkIMContextSimpleClass))


typedef struct GtkIMMulticontextPrivate{} GtkIMMulticontextPrivate;


struct GtkIMMulticontext
{
  GtkIMContext object;

  /*< private >*/
  GtkIMMulticontextPrivate *priv;
};
struct GtkIMMulticontextClass
{
  GtkIMContextClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType         gtk_im_context_simple_get_type  (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkIMContext *gtk_im_context_simple_new       (void);

GDK_AVAILABLE_IN_ALL
void          gtk_im_context_simple_add_table (GtkIMContextSimple *context_simple,
					       guint16            *data,
					       gint                max_seq_len,
					       gint                n_seqs);
GDK_AVAILABLE_IN_3_20
void          gtk_im_context_simple_add_compose_file (GtkIMContextSimple *context_simple,
                                                      const char        *compose_file);


G_END_DECLS


#endif /* __GTK_IM_CONTEXT_SIMPLE_H__ */
#define headerfilename "gtk/./gtkimmulticontext.h"
/* file: gtk/./gtkimmulticontext.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat Software
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_IM_MULTICONTEXT_H__
#define __GTK_IM_MULTICONTEXT_H__



#include <gtk/gtkimcontext.h>
#include <gtk/gtkmenushell.h>

G_BEGIN_DECLS

#define GTK_TYPE_IM_MULTICONTEXT()              (gtk_im_multicontext_get_type ())
#define GTK_IM_MULTICONTEXT(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_IM_MULTICONTEXT, GtkIMMulticontext))
#define GTK_IM_MULTICONTEXT_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_IM_MULTICONTEXT, GtkIMMulticontextClass))
#define GTK_IS_IM_MULTICONTEXT(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_IM_MULTICONTEXT))
#define GTK_IS_IM_MULTICONTEXT_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IM_MULTICONTEXT))
#define GTK_IM_MULTICONTEXT_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_IM_MULTICONTEXT, GtkIMMulticontextClass))


typedef struct GtkInfoBarPrivate{} GtkInfoBarPrivate;


struct GtkInfoBar
{
  GtkBox parent;

  /*< private > */
  GtkInfoBarPrivate *priv;
};
struct GtkInfoBarClass
{
  GtkBoxClass parent_class;

  /* Signals */
  void (* response) (GtkInfoBar *info_bar, gint response_id);

  /* Keybinding signals */
  void (* close)    (GtkInfoBar *info_bar);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType         gtk_im_multicontext_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkIMContext *gtk_im_multicontext_new      (void);

GDK_DEPRECATED_IN_3_10
void          gtk_im_multicontext_append_menuitems (GtkIMMulticontext *context,
						    GtkMenuShell      *menushell);
GDK_AVAILABLE_IN_ALL
const char  * gtk_im_multicontext_get_context_id   (GtkIMMulticontext *context);

GDK_AVAILABLE_IN_ALL
void          gtk_im_multicontext_set_context_id   (GtkIMMulticontext *context,
                                                    const char        *context_id);
 
G_END_DECLS

#endif /* __GTK_IM_MULTICONTEXT_H__ */
#define headerfilename "gtk/./gtkinfobar.h"
/* file: gtk/./gtkinfobar.h */
/*
 * gtkinfobar.h
 * This file is part of GTK+
 *
 * Copyright (C) 2005 - Paolo Maggi
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the gedit Team, 2005. See the gedit AUTHORS file for a
 * list of people on the gedit Team.
 * See the gedit ChangeLog files for a list of changes.
 *
 * Modified by the GTK+ Team, 2008-2009.
 */

#ifndef __GTK_INFO_BAR_H__
#define __GTK_INFO_BAR_H__



#include <gtk/gtkbox.h>
#include <gtk/gtkenums.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GTK_TYPE_INFO_BAR()              (gtk_info_bar_get_type())
#define GTK_INFO_BAR(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), GTK_TYPE_INFO_BAR, GtkInfoBar))
#define GTK_INFO_BAR_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), GTK_TYPE_INFO_BAR, GtkInfoBarClass))
#define GTK_IS_INFO_BAR(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), GTK_TYPE_INFO_BAR))
#define GTK_IS_INFO_BAR_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_INFO_BAR))
#define GTK_INFO_BAR_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), GTK_TYPE_INFO_BAR, GtkInfoBarClass))


typedef struct GtkInvisiblePrivate{} GtkInvisiblePrivate;




struct GtkInvisible
{
  GtkWidget widget;

  /*< private >*/
  GtkInvisiblePrivate *priv;
};
struct GtkInvisibleClass
{
  GtkWidgetClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType          gtk_info_bar_get_type               (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget     *gtk_info_bar_new                    (void);

GDK_AVAILABLE_IN_ALL
GtkWidget     *gtk_info_bar_new_with_buttons       (const char    *first_button_text,
                                                    ...);

GDK_AVAILABLE_IN_ALL
GtkWidget     *gtk_info_bar_get_action_area        (GtkInfoBar     *info_bar);
GDK_AVAILABLE_IN_ALL
GtkWidget     *gtk_info_bar_get_content_area       (GtkInfoBar     *info_bar);
GDK_AVAILABLE_IN_ALL
void           gtk_info_bar_add_action_widget      (GtkInfoBar     *info_bar,
                                                    GtkWidget      *child,
                                                    gint            response_id);
GDK_AVAILABLE_IN_ALL
GtkWidget     *gtk_info_bar_add_button             (GtkInfoBar     *info_bar,
                                                    const char    *button_text,
                                                    gint            response_id);
GDK_AVAILABLE_IN_ALL
void           gtk_info_bar_add_buttons            (GtkInfoBar     *info_bar,
                                                    const char    *first_button_text,
                                                    ...);
GDK_AVAILABLE_IN_ALL
void           gtk_info_bar_set_response_sensitive (GtkInfoBar     *info_bar,
                                                    gint            response_id,
                                                    gboolean        setting);
GDK_AVAILABLE_IN_ALL
void           gtk_info_bar_set_default_response   (GtkInfoBar     *info_bar,
                                                    gint            response_id);

/* Emit response signal */
GDK_AVAILABLE_IN_ALL
void           gtk_info_bar_response               (GtkInfoBar     *info_bar,
                                                    gint            response_id);

GDK_AVAILABLE_IN_ALL
void           gtk_info_bar_set_message_type       (GtkInfoBar     *info_bar,
                                                    GtkMessageType  message_type);
GDK_AVAILABLE_IN_ALL
GtkMessageType gtk_info_bar_get_message_type       (GtkInfoBar     *info_bar);

GDK_AVAILABLE_IN_3_10
void           gtk_info_bar_set_show_close_button  (GtkInfoBar     *info_bar,
                                                    gboolean        setting);
GDK_AVAILABLE_IN_3_10
gboolean       gtk_info_bar_get_show_close_button  (GtkInfoBar     *info_bar);

G_END_DECLS

#endif  /* __GTK_INFO_BAR_H__  */
#define headerfilename "gtk/./gtkinvisible.h"
/* file: gtk/./gtkinvisible.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_INVISIBLE_H__
#define __GTK_INVISIBLE_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_INVISIBLE()		(gtk_invisible_get_type ())
#define GTK_INVISIBLE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_INVISIBLE, GtkInvisible))
#define GTK_INVISIBLE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_INVISIBLE, GtkInvisibleClass))
#define GTK_IS_INVISIBLE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_INVISIBLE))
#define GTK_IS_INVISIBLE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_INVISIBLE))
#define GTK_INVISIBLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_INVISIBLE, GtkInvisibleClass))


typedef struct GtkLayoutPrivate{} GtkLayoutPrivate;


struct GtkLayout
{
  GtkContainer container;

  /*< private >*/
  GtkLayoutPrivate *priv;
};
struct GtkLayoutClass
{
  GtkContainerClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType gtk_invisible_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_invisible_new            (void);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_invisible_new_for_screen (GdkScreen    *screen);
GDK_AVAILABLE_IN_ALL
void	   gtk_invisible_set_screen	(GtkInvisible *invisible,
					 GdkScreen    *screen);
GDK_AVAILABLE_IN_ALL
GdkScreen* gtk_invisible_get_screen	(GtkInvisible *invisible);

G_END_DECLS

#endif /* __GTK_INVISIBLE_H__ */
#define headerfilename "gtk/./gtklayout.h"
/* file: gtk/./gtklayout.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * GtkLayout: Widget for scrolling of arbitrary-sized areas.
 *
 * Copyright Owen Taylor, 1998
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_LAYOUT_H__
#define __GTK_LAYOUT_H__




#include <gtk/gtkcontainer.h>


G_BEGIN_DECLS

#define GTK_TYPE_LAYOUT()            (gtk_layout_get_type ())
#define GTK_LAYOUT(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_LAYOUT, GtkLayout))
#define GTK_LAYOUT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_LAYOUT, GtkLayoutClass))
#define GTK_IS_LAYOUT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_LAYOUT))
#define GTK_IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_LAYOUT))
#define GTK_LAYOUT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_LAYOUT, GtkLayoutClass))





GDK_AVAILABLE_IN_ALL
GType          gtk_layout_get_type        (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget*     gtk_layout_new             (GtkAdjustment *hadjustment,
				           GtkAdjustment *vadjustment);
GDK_AVAILABLE_IN_ALL
GdkWindow*     gtk_layout_get_bin_window  (GtkLayout     *layout);
GDK_AVAILABLE_IN_ALL
void           gtk_layout_put             (GtkLayout     *layout,
		                           GtkWidget     *child_widget,
		                           gint           x,
		                           gint           y);

GDK_AVAILABLE_IN_ALL
void           gtk_layout_move            (GtkLayout     *layout,
		                           GtkWidget     *child_widget,
		                           gint           x,
		                           gint           y);

GDK_AVAILABLE_IN_ALL
void           gtk_layout_set_size        (GtkLayout     *layout,
			                   guint          width,
			                   guint          height);
GDK_AVAILABLE_IN_ALL
void           gtk_layout_get_size        (GtkLayout     *layout,
					   guint         *width,
					   guint         *height);

GDK_DEPRECATED_IN_3_0_FOR(gtk_scrollable_get_hadjustment)
GtkAdjustment* gtk_layout_get_hadjustment (GtkLayout     *layout);
GDK_DEPRECATED_IN_3_0_FOR(gtk_scrollable_get_vadjustment)
GtkAdjustment* gtk_layout_get_vadjustment (GtkLayout     *layout);
GDK_DEPRECATED_IN_3_0_FOR(gtk_scrollable_set_hadjustment)
void           gtk_layout_set_hadjustment (GtkLayout     *layout,
                                           GtkAdjustment *adjustment);
GDK_DEPRECATED_IN_3_0_FOR(gtk_scrollable_set_vadjustment)
void           gtk_layout_set_vadjustment (GtkLayout     *layout,
                                           GtkAdjustment *adjustment);


G_END_DECLS

#endif /* __GTK_LAYOUT_H__ */
#define headerfilename "gtk/./gtklevelbar.h"
/* file: gtk/./gtklevelbar.h */
/* GTK - The GIMP Toolkit
 * Copyright © 2012 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Cosimo Cecchi <cosimoc@gnome.org>
 *
 */

#ifndef __GTK_LEVEL_BAR_H__
#define __GTK_LEVEL_BAR_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_LEVEL_BAR()            (gtk_level_bar_get_type ())
#define GTK_LEVEL_BAR(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_LEVEL_BAR, GtkLevelBar))
#define GTK_LEVEL_BAR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_LEVEL_BAR, GtkLevelBarClass))
#define GTK_IS_LEVEL_BAR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_LEVEL_BAR))
#define GTK_IS_LEVEL_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_LEVEL_BAR))
#define GTK_LEVEL_BAR_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_LEVEL_BAR, GtkLevelBarClass))

/**
 * GTK_LEVEL_BAR_OFFSET_LOW:
 *
 * The name used for the stock low offset included by #GtkLevelBar.
 *
 * Since: 3.6
 */
#define GTK_LEVEL_BAR_OFFSET_LOW  "low"

/**
 * GTK_LEVEL_BAR_OFFSET_HIGH:
 *
 * The name used for the stock high offset included by #GtkLevelBar.
 *
 * Since: 3.6
 */
#define GTK_LEVEL_BAR_OFFSET_HIGH "high"

/**
 * GTK_LEVEL_BAR_OFFSET_FULL:
 *
 * The name used for the stock full offset included by #GtkLevelBar.
 *
 * Since: 3.20
 */
#define GTK_LEVEL_BAR_OFFSET_FULL "full"

typedef struct GtkLevelBarPrivate{} GtkLevelBarPrivate;

struct GtkLevelBar {
  /*< private >*/
  GtkWidget parent;

  GtkLevelBarPrivate *priv;
};

struct GtkLevelBarClass {
  /*< private >*/
  GtkWidgetClass parent_class;

  void (* offset_changed) (GtkLevelBar *self,
                           const char *name);

  /* padding for future class expansion */
  gpointer padding[16];
};
typedef struct GtkLinkButtonPrivate{} GtkLinkButtonPrivate;
struct GtkLinkButton
{
  /*< private >*/
  GtkButton parent_instance;

  GtkLinkButtonPrivate *priv;
};
struct GtkLinkButtonClass
{
  /*< private >*/
  GtkButtonClass parent_class;

  /*< public >*/
  gboolean (* activate_link) (GtkLinkButton *button);

  /*< private >*/
  /* Padding for future expansion */
  void (*_gtk_padding1) (void);
  void (*_gtk_padding2) (void);
  void (*_gtk_padding3) (void);
  void (*_gtk_padding4) (void);
};

GDK_AVAILABLE_IN_3_6
GType      gtk_level_bar_get_type           (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_6
GtkWidget *gtk_level_bar_new                (void);

GDK_AVAILABLE_IN_3_6
GtkWidget *gtk_level_bar_new_for_interval   (gdouble      min_value,
                                             gdouble      max_value);

GDK_AVAILABLE_IN_3_6
void       gtk_level_bar_set_mode           (GtkLevelBar *self,
                                             GtkLevelBarMode mode);
GDK_AVAILABLE_IN_3_6
GtkLevelBarMode gtk_level_bar_get_mode      (GtkLevelBar *self);

GDK_AVAILABLE_IN_3_6
void       gtk_level_bar_set_value          (GtkLevelBar *self,
                                             gdouble      value);
GDK_AVAILABLE_IN_3_6
gdouble    gtk_level_bar_get_value          (GtkLevelBar *self);

GDK_AVAILABLE_IN_3_6
void       gtk_level_bar_set_min_value      (GtkLevelBar *self,
                                             gdouble      value);
GDK_AVAILABLE_IN_3_6
gdouble    gtk_level_bar_get_min_value      (GtkLevelBar *self);

GDK_AVAILABLE_IN_3_6
void       gtk_level_bar_set_max_value      (GtkLevelBar *self,
                                             gdouble      value);
GDK_AVAILABLE_IN_3_6
gdouble    gtk_level_bar_get_max_value      (GtkLevelBar *self);

GDK_AVAILABLE_IN_3_8
void       gtk_level_bar_set_inverted       (GtkLevelBar *self,
                                             gboolean     inverted);

GDK_AVAILABLE_IN_3_8
gboolean   gtk_level_bar_get_inverted       (GtkLevelBar *self);

GDK_AVAILABLE_IN_3_6
void       gtk_level_bar_add_offset_value   (GtkLevelBar *self,
                                             const char *name,
                                             gdouble      value);
GDK_AVAILABLE_IN_3_6
void       gtk_level_bar_remove_offset_value (GtkLevelBar *self,
                                              const char *name);
GDK_AVAILABLE_IN_3_6
gboolean   gtk_level_bar_get_offset_value   (GtkLevelBar *self,
                                             const char *name,
                                             gdouble     *value);

G_END_DECLS

#endif /* __GTK_LEVEL_BAR_H__ */
#define headerfilename "gtk/./gtklinkbutton.h"
/* file: gtk/./gtklinkbutton.h */
/* GTK - The GIMP Toolkit
 * gtklinkbutton.h - an hyperlink-enabled button
 *
 * Copyright (C) 2005 Emmanuele Bassi <ebassi@gmail.com>
 * All rights reserved.
 *
 * Based on gnome-href code by:
 * 	James Henstridge <james@daa.com.au>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_LINK_BUTTON_H__
#define __GTK_LINK_BUTTON_H__



#include <gtk/gtkbutton.h>

G_BEGIN_DECLS

#define GTK_TYPE_LINK_BUTTON()		(gtk_link_button_get_type ())
#define GTK_LINK_BUTTON(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_LINK_BUTTON, GtkLinkButton))
#define GTK_IS_LINK_BUTTON(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_LINK_BUTTON))
#define GTK_LINK_BUTTON_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_LINK_BUTTON, GtkLinkButtonClass))
#define GTK_IS_LINK_BUTTON_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_LINK_BUTTON))
#define GTK_LINK_BUTTON_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_LINK_BUTTON, GtkLinkButtonClass))


/**
 * GtkLinkButton:
 *
 * The #GtkLinkButton-struct contains only
 * private data and should be accessed using the provided API.
 */

/**
 * GtkLinkButtonClass:
 * @activate_link: class handler for the #GtkLinkButton::activate-link signal
 *
 * The #GtkLinkButtonClass contains only
 * private data.
 */
struct GtkListBox
{
  GtkContainer parent_instance;
};
struct GtkListBoxRow
{
  GtkBin parent_instance;
};
struct GtkListBoxClass
{
  GtkContainerClass parent_class;

  /*< public >*/

  void (*row_selected)        (GtkListBox      *box,
                               GtkListBoxRow   *row);
  void (*row_activated)       (GtkListBox      *box,
                               GtkListBoxRow   *row);
  void (*activate_cursor_row) (GtkListBox      *box);
  void (*toggle_cursor_row)   (GtkListBox      *box);
  void (*move_cursor)         (GtkListBox      *box,
                               GtkMovementStep  step,
                               gint             count);
  void (*selected_rows_changed) (GtkListBox    *box);
  void (*select_all)            (GtkListBox    *box);
  void (*unselect_all)          (GtkListBox    *box);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
};

GDK_AVAILABLE_IN_ALL
GType                 gtk_link_button_get_type          (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget *           gtk_link_button_new               (const char   *uri);
GDK_AVAILABLE_IN_ALL
GtkWidget *           gtk_link_button_new_with_label    (const char   *uri,
						         const char   *label);

GDK_AVAILABLE_IN_ALL
const char *         gtk_link_button_get_uri           (GtkLinkButton *link_button);
GDK_AVAILABLE_IN_ALL
void                  gtk_link_button_set_uri           (GtkLinkButton *link_button,
						         const char   *uri);

GDK_AVAILABLE_IN_ALL
gboolean              gtk_link_button_get_visited       (GtkLinkButton *link_button);
GDK_AVAILABLE_IN_ALL
void                  gtk_link_button_set_visited       (GtkLinkButton *link_button,
                                                         gboolean       visited);


G_END_DECLS

#endif /* __GTK_LINK_BUTTON_H__ */
#define headerfilename "gtk/./gtklistbox.h"
/* file: gtk/./gtklistbox.h */
/*
 * Copyright (c) 2013 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Author: Alexander Larsson <alexl@redhat.com>
 *
 */

#ifndef __GTK_LIST_BOX_H__
#define __GTK_LIST_BOX_H__



#include <gtk/gtkbin.h>

G_BEGIN_DECLS


#define GTK_TYPE_LIST_BOX() (gtk_list_box_get_type ())
#define GTK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_LIST_BOX, GtkListBox))
#define GTK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_LIST_BOX, GtkListBoxClass))
#define GTK_IS_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_LIST_BOX))
#define GTK_IS_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_LIST_BOX))
#define GTK_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_LIST_BOX, GtkListBoxClass))




/**
 * GtkListBoxClass:
 * @parent_class: The parent class.
 * @row_selected: Class handler for the #GtkListBox::row-selected signal
 * @row_activated: Class handler for the #GtkListBox::row-activated signal
 * @activate_cursor_row: Class handler for the #GtkListBox::activate-cursor-row signal
 * @toggle_cursor_row: Class handler for the #GtkListBox::activate-cursor-row signal
 * @move_cursor: Class handler for the #GtkListBox::move-cursor signal
 * @selected_rows_changed: Class handler for the #GtkListBox::selected-rows-changed signal
 * @select_all: Class handler for the #GtkListBox::select-all signal
 * @unselect_all: Class handler for the #GtkListBox::unselect-all signal
 */
struct GtkListBoxRowClass
{
  GtkBinClass parent_class;

  /*< public >*/

  void (* activate) (GtkListBoxRow *row);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
};
typedef struct GtkLockButtonPrivate{} GtkLockButtonPrivate;

#define GTK_TYPE_LIST_BOX_ROW()            (gtk_list_box_row_get_type ())
#define GTK_LIST_BOX_ROW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_LIST_BOX_ROW, GtkListBoxRow))
#define GTK_LIST_BOX_ROW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_LIST_BOX_ROW, GtkListBoxRowClass))
#define GTK_IS_LIST_BOX_ROW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_LIST_BOX_ROW))
#define GTK_IS_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_LIST_BOX_ROW))
#define GTK_LIST_BOX_ROW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_LIST_BOX_ROW, GtkListBoxRowClass))


/**
 * GtkListBoxRowClass:
 * @parent_class: The parent class.
 * @activate: 
 */
struct GtkLockButton
{
  GtkButton parent;

  GtkLockButtonPrivate *priv;
};
struct GtkLockButtonClass
{
  GtkButtonClass parent_class;

  /*< private >*/

  void (*reserved0) (void);
  void (*reserved1) (void);
  void (*reserved2) (void);
  void (*reserved3) (void);
  void (*reserved4) (void);
  void (*reserved5) (void);
  void (*reserved6) (void);
  void (*reserved7) (void);
};

/**
 * GtkListBoxFilterFunc:
 * @row: the row that may be filtered
 * @user_data: (closure): user data
 *
 * Will be called whenever the row changes or is added and lets you control
 * if the row should be visible or not.
 *
 * Returns: %TRUE if the row should be visible, %FALSE otherwise
 *
 * Since: 3.10
 */
typedef gboolean (*GtkListBoxFilterFunc) (GtkListBoxRow *row,
                                          gpointer       user_data);

/**
 * GtkListBoxSortFunc:
 * @row1: the first row
 * @row2: the second row
 * @user_data: (closure): user data
 *
 * Compare two rows to determine which should be first.
 *
 * Returns: < 0 if @row1 should be before @row2, 0 if they are
 *     equal and > 0 otherwise
 *
 * Since: 3.10
 */
typedef gint (*GtkListBoxSortFunc) (GtkListBoxRow *row1,
                                    GtkListBoxRow *row2,
                                    gpointer       user_data);

/**
 * GtkListBoxUpdateHeaderFunc:
 * @row: the row to update
 * @before: (allow-none): the row before @row, or %NULL if it is first
 * @user_data: (closure): user data
 *
 * Whenever @row changes or which row is before @row changes this
 * is called, which lets you update the header on @row. You may
 * remove or set a new one via gtk_list_box_row_set_header() or
 * just change the state of the current header widget.
 *
 * Since: 3.10
 */
typedef void (*GtkListBoxUpdateHeaderFunc) (GtkListBoxRow *row,
                                            GtkListBoxRow *before,
                                            gpointer       user_data);

/**
 * GtkListBoxCreateWidgetFunc:
 * @item: (type GObject): the item from the model for which to create a widget for
 * @user_data: (closure): user data
 *
 * Called for list boxes that are bound to a #GListModel with
 * gtk_list_box_bind_model() for each item that gets added to the model.
 *
 * Versions of GTK+ prior to 3.18 called gtk_widget_show_all() on the rows
 * created by the GtkListBoxCreateWidgetFunc, but this forced all widgets
 * inside the row to be shown, and is no longer the case. Applications should
 * be updated to show the desired row widgets.
 *
 * Returns: (transfer full): a #GtkWidget that represents @item
 *
 * Since: 3.16
 */
typedef GtkWidget * (*GtkListBoxCreateWidgetFunc) (gpointer item,
                                                   gpointer user_data);

GDK_AVAILABLE_IN_3_10
GType      gtk_list_box_row_get_type      (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_10
GtkWidget* gtk_list_box_row_new           (void);
GDK_AVAILABLE_IN_3_10
GtkWidget* gtk_list_box_row_get_header    (GtkListBoxRow *row);
GDK_AVAILABLE_IN_3_10
void       gtk_list_box_row_set_header    (GtkListBoxRow *row,
                                           GtkWidget     *header);
GDK_AVAILABLE_IN_3_10
gint       gtk_list_box_row_get_index     (GtkListBoxRow *row);
GDK_AVAILABLE_IN_3_10
void       gtk_list_box_row_changed       (GtkListBoxRow *row);

GDK_AVAILABLE_IN_3_14
gboolean   gtk_list_box_row_is_selected   (GtkListBoxRow *row);

GDK_AVAILABLE_IN_3_14
void       gtk_list_box_row_set_selectable (GtkListBoxRow *row,
                                            gboolean       selectable);
GDK_AVAILABLE_IN_3_14
gboolean   gtk_list_box_row_get_selectable (GtkListBoxRow *row);


GDK_AVAILABLE_IN_3_14
void       gtk_list_box_row_set_activatable (GtkListBoxRow *row,
                                             gboolean       activatable);
GDK_AVAILABLE_IN_3_14
gboolean   gtk_list_box_row_get_activatable (GtkListBoxRow *row);

GDK_AVAILABLE_IN_3_10
GType          gtk_list_box_get_type                     (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_prepend                      (GtkListBox                    *box,
                                                          GtkWidget                     *child);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_insert                       (GtkListBox                    *box,
                                                          GtkWidget                     *child,
                                                          gint                           position);
GDK_AVAILABLE_IN_3_10
GtkListBoxRow* gtk_list_box_get_selected_row             (GtkListBox                    *box);
GDK_AVAILABLE_IN_3_10
GtkListBoxRow* gtk_list_box_get_row_at_index             (GtkListBox                    *box,
                                                          gint                           index_);
GDK_AVAILABLE_IN_3_10
GtkListBoxRow* gtk_list_box_get_row_at_y                 (GtkListBox                    *box,
                                                          gint                           y);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_select_row                   (GtkListBox                    *box,
                                                          GtkListBoxRow                 *row);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_set_placeholder              (GtkListBox                    *box,
                                                          GtkWidget                     *placeholder);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_set_adjustment               (GtkListBox                    *box,
                                                          GtkAdjustment                 *adjustment);
GDK_AVAILABLE_IN_3_10
GtkAdjustment *gtk_list_box_get_adjustment               (GtkListBox                    *box);

typedef void (* GtkListBoxForeachFunc) (GtkListBox      *box,
                                        GtkListBoxRow   *row,
                                        gpointer         user_data);

GDK_AVAILABLE_IN_3_14
void           gtk_list_box_selected_foreach             (GtkListBox                    *box,
                                                          GtkListBoxForeachFunc          func,
                                                          gpointer                       data);
GDK_AVAILABLE_IN_3_14
GList         *gtk_list_box_get_selected_rows            (GtkListBox                    *box);
GDK_AVAILABLE_IN_3_14
void           gtk_list_box_unselect_row                 (GtkListBox                    *box,
                                                          GtkListBoxRow                 *row);
GDK_AVAILABLE_IN_3_14
void           gtk_list_box_select_all                   (GtkListBox                    *box);
GDK_AVAILABLE_IN_3_14
void           gtk_list_box_unselect_all                 (GtkListBox                    *box);

GDK_AVAILABLE_IN_3_10
void           gtk_list_box_set_selection_mode           (GtkListBox                    *box,
                                                          GtkSelectionMode               mode);
GDK_AVAILABLE_IN_3_10
GtkSelectionMode gtk_list_box_get_selection_mode         (GtkListBox                    *box);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_set_filter_func              (GtkListBox                    *box,
                                                          GtkListBoxFilterFunc           filter_func,
                                                          gpointer                       user_data,
                                                          GDestroyNotify                 destroy);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_set_header_func              (GtkListBox                    *box,
                                                          GtkListBoxUpdateHeaderFunc     update_header,
                                                          gpointer                       user_data,
                                                          GDestroyNotify                 destroy);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_invalidate_filter            (GtkListBox                    *box);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_invalidate_sort              (GtkListBox                    *box);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_invalidate_headers           (GtkListBox                    *box);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_set_sort_func                (GtkListBox                    *box,
                                                          GtkListBoxSortFunc             sort_func,
                                                          gpointer                       user_data,
                                                          GDestroyNotify                 destroy);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_set_activate_on_single_click (GtkListBox                    *box,
                                                          gboolean                       single);
GDK_AVAILABLE_IN_3_10
gboolean       gtk_list_box_get_activate_on_single_click (GtkListBox                    *box);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_drag_unhighlight_row         (GtkListBox                    *box);
GDK_AVAILABLE_IN_3_10
void           gtk_list_box_drag_highlight_row           (GtkListBox                    *box,
                                                          GtkListBoxRow                 *row);
GDK_AVAILABLE_IN_3_10
GtkWidget*     gtk_list_box_new                          (void);


GDK_AVAILABLE_IN_3_16
void           gtk_list_box_bind_model                   (GtkListBox                   *box,
                                                          GListModel                   *model,
                                                          GtkListBoxCreateWidgetFunc    create_widget_func,
                                                          gpointer                      user_data,
                                                          GDestroyNotify                user_data_free_func);

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkListBox, g_object_unref)
G_DEFINE_AUTOPTR_CLEANUP_FUNC(GtkListBoxRow, g_object_unref)

G_END_DECLS

#endif
#define headerfilename "gtk/./gtklockbutton.h"
/* file: gtk/./gtklockbutton.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2010 Red Hat, Inc.
 * Author: Matthias Clasen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_LOCK_BUTTON_H__
#define __GTK_LOCK_BUTTON_H__

#include <gtk/gtkbutton.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#define GTK_TYPE_LOCK_BUTTON()         (gtk_lock_button_get_type ())
#define GTK_LOCK_BUTTON(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_LOCK_BUTTON, GtkLockButton))
#define GTK_LOCK_BUTTON_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_LOCK_BUTTON,  GtkLockButtonClass))
#define GTK_IS_LOCK_BUTTON(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_LOCK_BUTTON))
#define GTK_IS_LOCK_BUTTON_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_LOCK_BUTTON))
#define GTK_LOCK_BUTTON_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_LOCK_BUTTON, GtkLockButtonClass))

typedef struct GtkMenuBarPrivate{} GtkMenuBarPrivate;


/**
 * GtkLockButtonClass:
 * @parent_class: The parent class.
 */
struct GtkMenuBar
{
  GtkMenuShell menu_shell;

  /*< private >*/
  GtkMenuBarPrivate *priv;
};
struct GtkMenuBarClass
{
  GtkMenuShellClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_2
GType        gtk_lock_button_get_type       (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_2
GtkWidget   *gtk_lock_button_new            (GPermission   *permission);
GDK_AVAILABLE_IN_3_2
GPermission *gtk_lock_button_get_permission (GtkLockButton *button);
GDK_AVAILABLE_IN_3_2
void         gtk_lock_button_set_permission (GtkLockButton *button,
                                             GPermission   *permission);


G_END_DECLS

#endif  /* __GTK_LOCK_BUTTON_H__ */
#define headerfilename "gtk/./gtkmain.h"
/* file: gtk/./gtkmain.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_MAIN_H__
#define __GTK_MAIN_H__




#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

/**
 * GTK_PRIORITY_RESIZE:
 *
 * Use this priority for functionality related to size allocation.
 *
 * It is used internally by GTK+ to compute the sizes of widgets.
 * This priority is higher than %GDK_PRIORITY_REDRAW to avoid
 * resizing a widget which was just redrawn.
 */
#define GTK_PRIORITY_RESIZE (G_PRIORITY_HIGH_IDLE + 10)

/**
 * GtkKeySnoopFunc:
 * @grab_widget: the widget to which the event will be delivered
 * @event: the key event
 * @func_data: (closure): data supplied to gtk_key_snooper_install()
 *
 * Key snooper functions are called before normal event delivery.
 * They can be used to implement custom key event handling.
 *
 * Returns: %TRUE to stop further processing of @event, %FALSE to continue.
 */
typedef gint (*GtkKeySnoopFunc) (GtkWidget   *grab_widget,
                                 GdkEventKey *event,
                                 gpointer     func_data);

/* GTK+ version
 */
GDK_AVAILABLE_IN_ALL
guint gtk_get_major_version (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
guint gtk_get_minor_version (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
guint gtk_get_micro_version (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
guint gtk_get_binary_age    (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
guint gtk_get_interface_age (void) G_GNUC_CONST;

#define gtk_major_version gtk_get_major_version ()
#define gtk_minor_version gtk_get_minor_version ()
#define gtk_micro_version gtk_get_micro_version ()
#define gtk_binary_age gtk_get_binary_age ()
#define gtk_interface_age gtk_get_interface_age ()

GDK_AVAILABLE_IN_ALL
const char* gtk_check_version (guint   required_major,
                                guint   required_minor,
                                guint   required_micro);


/* Initialization, exit, mainloop and miscellaneous routines
 */

GDK_AVAILABLE_IN_ALL
gboolean gtk_parse_args           (int    *argc,
                                   char ***argv);

GDK_AVAILABLE_IN_ALL
void     gtk_init                 (int    *argc,
                                   char ***argv);

GDK_AVAILABLE_IN_ALL
gboolean gtk_init_check           (int    *argc,
                                   char ***argv);

GDK_AVAILABLE_IN_ALL
gboolean gtk_init_with_args       (gint                 *argc,
                                   char              ***argv,
                                   const char          *parameter_string,
                                   const GOptionEntry   *entries,
                                   const char          *translation_domain,
                                   GError              **error);

GDK_AVAILABLE_IN_ALL
GOptionGroup *gtk_get_option_group (gboolean open_default_display);

#ifdef G_OS_WIN32

/* Variants that are used to check for correct struct packing
 * when building GTK+-using code.
 */
GDK_AVAILABLE_IN_ALL
void     gtk_init_abi_check       (int    *argc,
                                   char ***argv,
                                   int     num_checks,
                                   size_t  sizeofGtkWindow,
                                   size_t  sizeofGtkBox);
GDK_AVAILABLE_IN_ALL
gboolean gtk_init_check_abi_check (int    *argc,
                                   char ***argv,
                                   int     num_checks,
                                   size_t  sizeofGtkWindow,
                                   size_t  sizeofGtkBox);

#define gtk_init(argc, argv) gtk_init_abi_check (argc, argv, 2, sizeof (GtkWindow), sizeof (GtkBox))
#define gtk_init_check(argc, argv) gtk_init_check_abi_check (argc, argv, 2, sizeof (GtkWindow), sizeof (GtkBox))

#endif

GDK_AVAILABLE_IN_ALL
void           gtk_disable_setlocale    (void);
GDK_AVAILABLE_IN_ALL
PangoLanguage *gtk_get_default_language (void);
GDK_AVAILABLE_IN_3_12
GtkTextDirection gtk_get_locale_direction (void);
GDK_AVAILABLE_IN_ALL
gboolean       gtk_events_pending       (void);

GDK_AVAILABLE_IN_ALL
void       gtk_main_do_event       (GdkEvent           *event);
GDK_AVAILABLE_IN_ALL
void       gtk_main                (void);
GDK_AVAILABLE_IN_ALL
guint      gtk_main_level          (void);
GDK_AVAILABLE_IN_ALL
void       gtk_main_quit           (void);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_main_iteration      (void);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_main_iteration_do   (gboolean            blocking);

GDK_AVAILABLE_IN_ALL
gboolean   gtk_true                (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
gboolean   gtk_false               (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
void       gtk_grab_add            (GtkWidget          *widget);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_grab_get_current    (void);
GDK_AVAILABLE_IN_ALL
void       gtk_grab_remove         (GtkWidget          *widget);

GDK_AVAILABLE_IN_ALL
void       gtk_device_grab_add     (GtkWidget          *widget,
                                    GdkDevice          *device,
                                    gboolean            block_others);
GDK_AVAILABLE_IN_ALL
void       gtk_device_grab_remove  (GtkWidget          *widget,
                                    GdkDevice          *device);

GDK_DEPRECATED_IN_3_4
guint      gtk_key_snooper_install (GtkKeySnoopFunc snooper,
                                    gpointer        func_data);
GDK_DEPRECATED_IN_3_4
void       gtk_key_snooper_remove  (guint           snooper_handler_id);

GDK_AVAILABLE_IN_ALL
GdkEvent * gtk_get_current_event        (void);
GDK_AVAILABLE_IN_ALL
guint32    gtk_get_current_event_time   (void);
GDK_AVAILABLE_IN_ALL
gboolean   gtk_get_current_event_state  (GdkModifierType *state);
GDK_AVAILABLE_IN_ALL
GdkDevice *gtk_get_current_event_device (void);

GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_get_event_widget         (GdkEvent        *event);

GDK_AVAILABLE_IN_ALL
void       gtk_propagate_event          (GtkWidget       *widget,
                                         GdkEvent        *event);


G_END_DECLS

#endif /* __GTK_MAIN_H__ */
#define headerfilename "gtk/./gtkmenubar.h"
/* file: gtk/./gtkmenubar.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_MENU_BAR_H__
#define __GTK_MENU_BAR_H__




#include <gtk/gtkmenushell.h>


G_BEGIN_DECLS


#define	GTK_TYPE_MENU_BAR()               (gtk_menu_bar_get_type ())
#define GTK_MENU_BAR(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_MENU_BAR, GtkMenuBar))
#define GTK_MENU_BAR_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_MENU_BAR, GtkMenuBarClass))
#define GTK_IS_MENU_BAR(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_MENU_BAR))
#define GTK_IS_MENU_BAR_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MENU_BAR))
#define GTK_MENU_BAR_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MENU_BAR, GtkMenuBarClass))

typedef struct GtkPopoverPrivate{} GtkPopoverPrivate;


struct GtkPopover
{
  GtkBin parent_instance;

  /*< private >*/

  GtkPopoverPrivate *priv;
};
struct GtkPopoverClass
{
  GtkBinClass parent_class;

  void (* closed) (GtkPopover *popover);

  /*< private >*/

  /* Padding for future expansion */
  gpointer reserved[10];
};


GDK_AVAILABLE_IN_ALL
GType      gtk_menu_bar_get_type        (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_menu_bar_new             (void);
GDK_AVAILABLE_IN_3_4
GtkWidget* gtk_menu_bar_new_from_model  (GMenuModel *model);

GDK_AVAILABLE_IN_ALL
GtkPackDirection gtk_menu_bar_get_pack_direction (GtkMenuBar       *menubar);
GDK_AVAILABLE_IN_ALL
void             gtk_menu_bar_set_pack_direction (GtkMenuBar       *menubar,
						  GtkPackDirection  pack_dir);
GDK_AVAILABLE_IN_ALL
GtkPackDirection gtk_menu_bar_get_child_pack_direction (GtkMenuBar       *menubar);
GDK_AVAILABLE_IN_ALL
void             gtk_menu_bar_set_child_pack_direction (GtkMenuBar       *menubar,
							GtkPackDirection  child_pack_dir);

/* Private functions */
void _gtk_menu_bar_cycle_focus (GtkMenuBar       *menubar,
				GtkDirectionType  dir);
GList* _gtk_menu_bar_get_viewable_menu_bars (GtkWindow *window);



G_END_DECLS


#endif /* __GTK_MENU_BAR_H__ */
#define headerfilename "gtk/./gtkpopover.h"
/* file: gtk/./gtkpopover.h */
/* GTK - The GIMP Toolkit
 * Copyright © 2013 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_POPOVER_H__
#define __GTK_POPOVER_H__



#include <gtk/gtkwindow.h>

G_BEGIN_DECLS

#define GTK_TYPE_POPOVER()           (gtk_popover_get_type ())
#define GTK_POPOVER(o)             (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_POPOVER, GtkPopover))
#define GTK_POPOVER_CLASS(c)       (G_TYPE_CHECK_CLASS_CAST ((c), GTK_TYPE_POPOVER, GtkPopoverClass))
#define GTK_IS_POPOVER(o)          (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_POPOVER))
#define GTK_IS_POPOVER_CLASS(o)    (G_TYPE_CHECK_CLASS_TYPE ((o), GTK_TYPE_POPOVER))
#define GTK_POPOVER_GET_CLASS(o)   (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_POPOVER, GtkPopoverClass))

typedef struct GtkMenuButtonPrivate{} GtkMenuButtonPrivate;


struct GtkMenuButton
{
  GtkToggleButton parent;

  /*< private >*/
  GtkMenuButtonPrivate *priv;
};
struct GtkMenuButtonClass
{
  GtkToggleButtonClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_12
GType           gtk_popover_get_type        (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_12
GtkWidget *     gtk_popover_new             (GtkWidget             *relative_to);

GDK_AVAILABLE_IN_3_12
GtkWidget *     gtk_popover_new_from_model  (GtkWidget             *relative_to,
                                             GMenuModel            *model);

GDK_AVAILABLE_IN_3_12
void            gtk_popover_set_relative_to (GtkPopover            *popover,
                                             GtkWidget             *relative_to);
GDK_AVAILABLE_IN_3_12
GtkWidget *     gtk_popover_get_relative_to (GtkPopover            *popover);

GDK_AVAILABLE_IN_3_12
void            gtk_popover_set_pointing_to (GtkPopover            *popover,
                                             const GdkRectangle    *rect);
GDK_AVAILABLE_IN_3_12
gboolean        gtk_popover_get_pointing_to (GtkPopover            *popover,
                                             GdkRectangle          *rect);
GDK_AVAILABLE_IN_3_12
void            gtk_popover_set_position    (GtkPopover            *popover,
                                             GtkPositionType        position);
GDK_AVAILABLE_IN_3_12
GtkPositionType gtk_popover_get_position    (GtkPopover            *popover);

GDK_AVAILABLE_IN_3_12
void            gtk_popover_set_modal       (GtkPopover            *popover,
                                             gboolean               modal);
GDK_AVAILABLE_IN_3_12
gboolean        gtk_popover_get_modal       (GtkPopover            *popover);

GDK_AVAILABLE_IN_3_12
void            gtk_popover_bind_model      (GtkPopover            *popover,
                                             GMenuModel            *model,
                                             const char           *action_namespace);

GDK_AVAILABLE_IN_3_16
void            gtk_popover_set_transitions_enabled (GtkPopover *popover,
                                                     gboolean    transitions_enabled);
GDK_AVAILABLE_IN_3_16
gboolean        gtk_popover_get_transitions_enabled (GtkPopover *popover);

GDK_AVAILABLE_IN_3_18
void            gtk_popover_set_default_widget (GtkPopover *popover,
                                                GtkWidget  *widget);
GDK_AVAILABLE_IN_3_18
GtkWidget *     gtk_popover_get_default_widget (GtkPopover *popover);

GDK_AVAILABLE_IN_3_20
void                 gtk_popover_set_constrain_to (GtkPopover           *popover,
                                                   GtkPopoverConstraint  constraint);

GDK_AVAILABLE_IN_3_20
GtkPopoverConstraint gtk_popover_get_constrain_to (GtkPopover           *popover);

G_END_DECLS

#endif /* __GTK_POPOVER_H__ */
#define headerfilename "gtk/./gtkmenubutton.h"
/* file: gtk/./gtkmenubutton.h */
/* GTK - The GIMP Toolkit
 *
 * Copyright (C) 2003 Ricardo Fernandez Pascual
 * Copyright (C) 2004 Paolo Borelli
 * Copyright (C) 2012 Bastien Nocera
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_MENU_BUTTON_H__
#define __GTK_MENU_BUTTON_H__



#include <gtk/gtktogglebutton.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkpopover.h>

G_BEGIN_DECLS

#define GTK_TYPE_MENU_BUTTON()            (gtk_menu_button_get_type ())
#define GTK_MENU_BUTTON(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_MENU_BUTTON, GtkMenuButton))
#define GTK_MENU_BUTTON_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_MENU_BUTTON, GtkMenuButtonClass))
#define GTK_IS_MENU_BUTTON(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_MENU_BUTTON))
#define GTK_IS_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MENU_BUTTON))
#define GTK_MENU_BUTTON_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MENU_BUTTON, GtkMenuButtonClass))

typedef struct GtkSizeGroupPrivate{} GtkSizeGroupPrivate;


struct GtkSizeGroup
{
  GObject parent_instance;

  /*< private >*/
  GtkSizeGroupPrivate *priv;
};
struct GtkSizeGroupClass
{
  GObjectClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_6
GType        gtk_menu_button_get_type       (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_6
GtkWidget   *gtk_menu_button_new            (void);

GDK_AVAILABLE_IN_3_6
void         gtk_menu_button_set_popup      (GtkMenuButton *menu_button,
                                             GtkWidget     *menu);
GDK_AVAILABLE_IN_3_6
GtkMenu     *gtk_menu_button_get_popup      (GtkMenuButton *menu_button);

GDK_AVAILABLE_IN_3_12
void         gtk_menu_button_set_popover    (GtkMenuButton *menu_button,
                                             GtkWidget     *popover);
GDK_AVAILABLE_IN_3_12
GtkPopover  *gtk_menu_button_get_popover    (GtkMenuButton *menu_button);

GDK_AVAILABLE_IN_3_6
void         gtk_menu_button_set_direction  (GtkMenuButton *menu_button,
                                             GtkArrowType   direction);
GDK_AVAILABLE_IN_3_6
GtkArrowType gtk_menu_button_get_direction  (GtkMenuButton *menu_button);

GDK_AVAILABLE_IN_3_6
void         gtk_menu_button_set_menu_model (GtkMenuButton *menu_button,
                                             GMenuModel    *menu_model);
GDK_AVAILABLE_IN_3_6
GMenuModel  *gtk_menu_button_get_menu_model (GtkMenuButton *menu_button);

GDK_AVAILABLE_IN_3_6
void         gtk_menu_button_set_align_widget (GtkMenuButton *menu_button,
                                               GtkWidget     *align_widget);
GDK_AVAILABLE_IN_3_6
GtkWidget   *gtk_menu_button_get_align_widget (GtkMenuButton *menu_button);

GDK_AVAILABLE_IN_3_12
void         gtk_menu_button_set_use_popover (GtkMenuButton *menu_button,
                                              gboolean       use_popover);

GDK_AVAILABLE_IN_3_12
gboolean     gtk_menu_button_get_use_popover (GtkMenuButton *menu_button);


G_END_DECLS

#endif /* __GTK_MENU_BUTTON_H__ */
#define headerfilename "gtk/./gtksizegroup.h"
/* file: gtk/./gtksizegroup.h */
/* GTK - The GIMP Toolkit
 * gtksizegroup.h:
 * Copyright (C) 2000 Red Hat Software
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_SIZE_GROUP_H__
#define __GTK_SIZE_GROUP_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_SIZE_GROUP()            (gtk_size_group_get_type ())
#define GTK_SIZE_GROUP(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_SIZE_GROUP, GtkSizeGroup))
#define GTK_SIZE_GROUP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_SIZE_GROUP, GtkSizeGroupClass))
#define GTK_IS_SIZE_GROUP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_SIZE_GROUP))
#define GTK_IS_SIZE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SIZE_GROUP))
#define GTK_SIZE_GROUP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_SIZE_GROUP, GtkSizeGroupClass))


typedef struct GtkToolItemPrivate{} GtkToolItemPrivate;


struct GtkToolItem
{
  GtkBin parent;

  /*< private >*/
  GtkToolItemPrivate *priv;
};
struct GtkToolItemClass
{
  GtkBinClass parent_class;

  /* signals */
  gboolean   (* create_menu_proxy)    (GtkToolItem *tool_item);
  void       (* toolbar_reconfigured) (GtkToolItem *tool_item);

  /*< private >*/

  /* Padding for future expansion */
  void (* _gtk_reserved1) (void);
  void (* _gtk_reserved2) (void);
  void (* _gtk_reserved3) (void);
  void (* _gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType            gtk_size_group_get_type      (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkSizeGroup *   gtk_size_group_new           (GtkSizeGroupMode  mode);
GDK_AVAILABLE_IN_ALL
void             gtk_size_group_set_mode      (GtkSizeGroup     *size_group,
					       GtkSizeGroupMode  mode);
GDK_AVAILABLE_IN_ALL
GtkSizeGroupMode gtk_size_group_get_mode      (GtkSizeGroup     *size_group);
GDK_AVAILABLE_IN_ALL
void             gtk_size_group_set_ignore_hidden (GtkSizeGroup *size_group,
						   gboolean      ignore_hidden);
GDK_AVAILABLE_IN_ALL
gboolean         gtk_size_group_get_ignore_hidden (GtkSizeGroup *size_group);
GDK_AVAILABLE_IN_ALL
void             gtk_size_group_add_widget    (GtkSizeGroup     *size_group,
					       GtkWidget        *widget);
GDK_AVAILABLE_IN_ALL
void             gtk_size_group_remove_widget (GtkSizeGroup     *size_group,
					       GtkWidget        *widget);
GDK_AVAILABLE_IN_ALL
GSList *         gtk_size_group_get_widgets   (GtkSizeGroup     *size_group);

G_END_DECLS

#endif /* __GTK_SIZE_GROUP_H__ */
#define headerfilename "gtk/./gtktoolitem.h"
/* file: gtk/./gtktoolitem.h */
/* gtktoolitem.c
 *
 * Copyright (C) 2002 Anders Carlsson <andersca@gnome.org>
 * Copyright (C) 2002 James Henstridge <james@daa.com.au>
 * Copyright (C) 2003 Soeren Sandmann <sandmann@daimi.au.dk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_TOOL_ITEM_H__
#define __GTK_TOOL_ITEM_H__



#include <gtk/gtkbin.h>
#include <gtk/gtkmenuitem.h>
#include <gtk/gtksizegroup.h>

G_BEGIN_DECLS

#define GTK_TYPE_TOOL_ITEM()            (gtk_tool_item_get_type ())
#define GTK_TOOL_ITEM(o)              (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_TOOL_ITEM, GtkToolItem))
#define GTK_TOOL_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_TOOL_ITEM, GtkToolItemClass))
#define GTK_IS_TOOL_ITEM(o)           (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_TOOL_ITEM))
#define GTK_IS_TOOL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_TOOL_ITEM))
#define GTK_TOOL_ITEM_GET_CLASS(o)    (G_TYPE_INSTANCE_GET_CLASS((o), GTK_TYPE_TOOL_ITEM, GtkToolItemClass))

typedef struct GtkToolButtonPrivate{} GtkToolButtonPrivate;


/**
 * GtkToolItemClass:
 * @parent_class: The parent class.
 * @create_menu_proxy: Signal emitted when the toolbar needs
 *    information from tool_item about whether the item should appear in
 *    the toolbar overflow menu.
 * @toolbar_reconfigured: Signal emitted when some property of the
 *    toolbar that the item is a child of changes.
 */
struct GtkToolButton
{
  GtkToolItem parent;

  /*< private >*/
  GtkToolButtonPrivate *priv;
};
struct GtkToolButtonClass
{
  GtkToolItemClass parent_class;

  GType button_type;

  /*< public >*/

  /* signal */
  void       (* clicked)             (GtkToolButton    *tool_item);

  /*< private >*/

  /* Padding for future expansion */
  void (* _gtk_reserved1) (void);
  void (* _gtk_reserved2) (void);
  void (* _gtk_reserved3) (void);
  void (* _gtk_reserved4) (void);
};


GDK_AVAILABLE_IN_ALL
GType        gtk_tool_item_get_type (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkToolItem *gtk_tool_item_new      (void);

GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_set_homogeneous          (GtkToolItem *tool_item,
							gboolean     homogeneous);
GDK_AVAILABLE_IN_ALL
gboolean        gtk_tool_item_get_homogeneous          (GtkToolItem *tool_item);

GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_set_expand               (GtkToolItem *tool_item,
							gboolean     expand);
GDK_AVAILABLE_IN_ALL
gboolean        gtk_tool_item_get_expand               (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_set_tooltip_text         (GtkToolItem *tool_item,
							const char *text);
GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_set_tooltip_markup       (GtkToolItem *tool_item,
							const char *markup);

GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_set_use_drag_window      (GtkToolItem *tool_item,
							gboolean     use_drag_window);
GDK_AVAILABLE_IN_ALL
gboolean        gtk_tool_item_get_use_drag_window      (GtkToolItem *tool_item);

GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_set_visible_horizontal   (GtkToolItem *tool_item,
							gboolean     visible_horizontal);
GDK_AVAILABLE_IN_ALL
gboolean        gtk_tool_item_get_visible_horizontal   (GtkToolItem *tool_item);

GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_set_visible_vertical     (GtkToolItem *tool_item,
							gboolean     visible_vertical);
GDK_AVAILABLE_IN_ALL
gboolean        gtk_tool_item_get_visible_vertical     (GtkToolItem *tool_item);

GDK_AVAILABLE_IN_ALL
gboolean        gtk_tool_item_get_is_important         (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_set_is_important         (GtkToolItem *tool_item,
							gboolean     is_important);

GDK_AVAILABLE_IN_ALL
PangoEllipsizeMode gtk_tool_item_get_ellipsize_mode    (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
GtkIconSize     gtk_tool_item_get_icon_size            (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
GtkOrientation  gtk_tool_item_get_orientation          (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
GtkToolbarStyle gtk_tool_item_get_toolbar_style        (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
GtkReliefStyle  gtk_tool_item_get_relief_style         (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
gfloat          gtk_tool_item_get_text_alignment       (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
GtkOrientation  gtk_tool_item_get_text_orientation     (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
GtkSizeGroup *  gtk_tool_item_get_text_size_group      (GtkToolItem *tool_item);

GDK_AVAILABLE_IN_ALL
GtkWidget *     gtk_tool_item_retrieve_proxy_menu_item (GtkToolItem *tool_item);
GDK_AVAILABLE_IN_ALL
GtkWidget *     gtk_tool_item_get_proxy_menu_item      (GtkToolItem *tool_item,
							const char *menu_item_id);
GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_set_proxy_menu_item      (GtkToolItem *tool_item,
							const char *menu_item_id,
							GtkWidget   *menu_item);
GDK_AVAILABLE_IN_ALL
void		gtk_tool_item_rebuild_menu	       (GtkToolItem *tool_item);

GDK_AVAILABLE_IN_ALL
void            gtk_tool_item_toolbar_reconfigured     (GtkToolItem *tool_item);

/* private */

gboolean       _gtk_tool_item_create_menu_proxy        (GtkToolItem *tool_item);

G_END_DECLS

#endif /* __GTK_TOOL_ITEM_H__ */
#define headerfilename "gtk/./gtktoolbutton.h"
/* file: gtk/./gtktoolbutton.h */
/* gtktoolbutton.h
 *
 * Copyright (C) 2002 Anders Carlsson <andersca@gnome.org>
 * Copyright (C) 2002 James Henstridge <james@daa.com.au>
 * Copyright (C) 2003 Soeren Sandmann <sandmann@daimi.au.dk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_TOOL_BUTTON_H__
#define __GTK_TOOL_BUTTON_H__



#include <gtk/gtktoolitem.h>

G_BEGIN_DECLS

#define GTK_TYPE_TOOL_BUTTON()            (gtk_tool_button_get_type ())
#define GTK_TOOL_BUTTON(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_TOOL_BUTTON, GtkToolButton))
#define GTK_TOOL_BUTTON_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_TOOL_BUTTON, GtkToolButtonClass))
#define GTK_IS_TOOL_BUTTON(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_TOOL_BUTTON))
#define GTK_IS_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_TOOL_BUTTON))
#define GTK_TOOL_BUTTON_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GTK_TYPE_TOOL_BUTTON, GtkToolButtonClass))

typedef struct GtkMenuToolButtonPrivate{} GtkMenuToolButtonPrivate;


/**
 * GtkToolButtonClass:
 * @parent_class: The parent class.
 * @button_type: 
 * @clicked: Signal emitted when the tool button is clicked with the
 *    mouse or activated with the keyboard.
 */
struct GtkMenuToolButton
{
  GtkToolButton parent;

  /*< private >*/
  GtkMenuToolButtonPrivate *priv;
};
struct GtkMenuToolButtonClass
{
  GtkToolButtonClass parent_class;

  /*< public >*/

  void (*show_menu) (GtkMenuToolButton *button);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType        gtk_tool_button_get_type       (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkToolItem *gtk_tool_button_new            (GtkWidget   *icon_widget,
					     const char *label);
GDK_DEPRECATED_IN_3_10_FOR(gtk_tool_button_new)
GtkToolItem *gtk_tool_button_new_from_stock (const char *stock_id);

GDK_AVAILABLE_IN_ALL
void                  gtk_tool_button_set_label         (GtkToolButton *button,
							 const char   *label);
GDK_AVAILABLE_IN_ALL
const char *         gtk_tool_button_get_label         (GtkToolButton *button);
GDK_AVAILABLE_IN_ALL
void                  gtk_tool_button_set_use_underline (GtkToolButton *button,
							 gboolean       use_underline);
GDK_AVAILABLE_IN_ALL
gboolean              gtk_tool_button_get_use_underline (GtkToolButton *button);
GDK_DEPRECATED_IN_3_10_FOR(gtk_tool_button_set_icon_name)
void                  gtk_tool_button_set_stock_id      (GtkToolButton *button,
							 const char   *stock_id);
GDK_DEPRECATED_IN_3_10_FOR(gtk_tool_button_get_icon_name)
const char *         gtk_tool_button_get_stock_id      (GtkToolButton *button);
GDK_AVAILABLE_IN_ALL
void                  gtk_tool_button_set_icon_name     (GtkToolButton *button,
							 const char   *icon_name);
GDK_AVAILABLE_IN_ALL
const char *         gtk_tool_button_get_icon_name     (GtkToolButton *button);
GDK_AVAILABLE_IN_ALL
void                  gtk_tool_button_set_icon_widget   (GtkToolButton *button,
							 GtkWidget     *icon_widget);
GDK_AVAILABLE_IN_ALL
GtkWidget *           gtk_tool_button_get_icon_widget   (GtkToolButton *button);
GDK_AVAILABLE_IN_ALL
void                  gtk_tool_button_set_label_widget  (GtkToolButton *button,
							 GtkWidget     *label_widget);
GDK_AVAILABLE_IN_ALL
GtkWidget *           gtk_tool_button_get_label_widget  (GtkToolButton *button);


/* internal function */
GtkWidget *_gtk_tool_button_get_button (GtkToolButton *button);

G_END_DECLS

#endif /* __GTK_TOOL_BUTTON_H__ */
#define headerfilename "gtk/./gtkmenutoolbutton.h"
/* file: gtk/./gtkmenutoolbutton.h */
/* GTK - The GIMP Toolkit
 *
 * Copyright (C) 2003 Ricardo Fernandez Pascual
 * Copyright (C) 2004 Paolo Borelli
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_MENU_TOOL_BUTTON_H__
#define __GTK_MENU_TOOL_BUTTON_H__



#include <gtk/gtkmenu.h>
#include <gtk/gtktoolbutton.h>

G_BEGIN_DECLS

#define GTK_TYPE_MENU_TOOL_BUTTON()         (gtk_menu_tool_button_get_type ())
#define GTK_MENU_TOOL_BUTTON(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_MENU_TOOL_BUTTON, GtkMenuToolButton))
#define GTK_MENU_TOOL_BUTTON_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), GTK_TYPE_MENU_TOOL_BUTTON, GtkMenuToolButtonClass))
#define GTK_IS_MENU_TOOL_BUTTON(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_MENU_TOOL_BUTTON))
#define GTK_IS_MENU_TOOL_BUTTON_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_MENU_TOOL_BUTTON))
#define GTK_MENU_TOOL_BUTTON_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_MENU_TOOL_BUTTON, GtkMenuToolButtonClass))

typedef struct GtkMessageDialogPrivate{} GtkMessageDialogPrivate;


/**
 * GtkMenuToolButtonClass:
 * @parent_class: The parent class.
 * @show_menu: Signal emitted before the menu is shown.
 */
struct GtkMessageDialog
{
  GtkDialog parent_instance;

  /*< private >*/
  GtkMessageDialogPrivate *priv;
};
struct GtkMessageDialogClass
{
  GtkDialogClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_ALL
GType         gtk_menu_tool_button_get_type       (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkToolItem  *gtk_menu_tool_button_new            (GtkWidget   *icon_widget,
                                                   const char *label);
GDK_DEPRECATED_IN_3_10_FOR(gtk_menu_tool_button_new)
GtkToolItem  *gtk_menu_tool_button_new_from_stock (const char *stock_id);

GDK_AVAILABLE_IN_ALL
void          gtk_menu_tool_button_set_menu       (GtkMenuToolButton *button,
                                                   GtkWidget         *menu);
GDK_AVAILABLE_IN_ALL
GtkWidget    *gtk_menu_tool_button_get_menu       (GtkMenuToolButton *button);
GDK_AVAILABLE_IN_ALL
void          gtk_menu_tool_button_set_arrow_tooltip_text   (GtkMenuToolButton *button,
							     const char       *text);
GDK_AVAILABLE_IN_ALL
void          gtk_menu_tool_button_set_arrow_tooltip_markup (GtkMenuToolButton *button,
							     const char       *markup);

G_END_DECLS

#endif /* __GTK_MENU_TOOL_BUTTON_H__ */
#define headerfilename "gtk/./gtkmessagedialog.h"
/* file: gtk/./gtkmessagedialog.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 2000 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2003.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_MESSAGE_DIALOG_H__
#define __GTK_MESSAGE_DIALOG_H__



#include <gtk/gtkdialog.h>
#include <gtk/gtkenums.h>

G_BEGIN_DECLS


#define GTK_TYPE_MESSAGE_DIALOG()                  (gtk_message_dialog_get_type ())
#define GTK_MESSAGE_DIALOG(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_MESSAGE_DIALOG, GtkMessageDialog))
#define GTK_MESSAGE_DIALOG_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_MESSAGE_DIALOG, GtkMessageDialogClass))
#define GTK_IS_MESSAGE_DIALOG(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_MESSAGE_DIALOG))
#define GTK_IS_MESSAGE_DIALOG_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MESSAGE_DIALOG))
#define GTK_MESSAGE_DIALOG_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MESSAGE_DIALOG, GtkMessageDialogClass))




/**
 * GtkButtonsType:
 * @GTK_BUTTONS_NONE: no buttons at all
 * @GTK_BUTTONS_OK: an OK button
 * @GTK_BUTTONS_CLOSE: a Close button
 * @GTK_BUTTONS_CANCEL: a Cancel button
 * @GTK_BUTTONS_YES_NO: Yes and No buttons
 * @GTK_BUTTONS_OK_CANCEL: OK and Cancel buttons
 *
 * Prebuilt sets of buttons for the dialog. If
 * none of these choices are appropriate, simply use %GTK_BUTTONS_NONE
 * then call gtk_dialog_add_buttons().
 *
 * > Please note that %GTK_BUTTONS_OK, %GTK_BUTTONS_YES_NO
 * > and %GTK_BUTTONS_OK_CANCEL are discouraged by the
 * > [GNOME Human Interface Guidelines](http://library.gnome.org/devel/hig-book/stable/).
 */
typedef enum
{
  GTK_BUTTONS_NONE,
  GTK_BUTTONS_OK,
  GTK_BUTTONS_CLOSE,
  GTK_BUTTONS_CANCEL,
  GTK_BUTTONS_YES_NO,
  GTK_BUTTONS_OK_CANCEL
} GtkButtonsType;
typedef struct _GtkModelButton{} GtkModelButton;

GDK_AVAILABLE_IN_ALL
GType      gtk_message_dialog_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_message_dialog_new      (GtkWindow      *parent,
                                        GtkDialogFlags  flags,
                                        GtkMessageType  type,
                                        GtkButtonsType  buttons,
                                        const char    *message_format,
                                        ...) G_GNUC_PRINTF (5, 6);

GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_message_dialog_new_with_markup   (GtkWindow      *parent,
                                                 GtkDialogFlags  flags,
                                                 GtkMessageType  type,
                                                 GtkButtonsType  buttons,
                                                 const char    *message_format,
                                                 ...) G_GNUC_PRINTF (5, 6);

GDK_DEPRECATED_IN_3_12
void       gtk_message_dialog_set_image    (GtkMessageDialog *dialog,
					    GtkWidget        *image);

GDK_DEPRECATED_IN_3_12
GtkWidget * gtk_message_dialog_get_image   (GtkMessageDialog *dialog);

GDK_AVAILABLE_IN_ALL
void       gtk_message_dialog_set_markup  (GtkMessageDialog *message_dialog,
                                           const char      *str);

GDK_AVAILABLE_IN_ALL
void       gtk_message_dialog_format_secondary_text (GtkMessageDialog *message_dialog,
                                                     const char      *message_format,
                                                     ...) G_GNUC_PRINTF (2, 3);

GDK_AVAILABLE_IN_ALL
void       gtk_message_dialog_format_secondary_markup (GtkMessageDialog *message_dialog,
                                                       const char      *message_format,
                                                       ...) G_GNUC_PRINTF (2, 3);

GDK_AVAILABLE_IN_ALL
GtkWidget *gtk_message_dialog_get_message_area (GtkMessageDialog *message_dialog);

G_END_DECLS

#endif /* __GTK_MESSAGE_DIALOG_H__ */
#define headerfilename "gtk/./gtkmodelbutton.h"
/* file: gtk/./gtkmodelbutton.h */
/*
 * Copyright © 2014 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Matthias Clasen
 */

#ifndef __GTK_MODEL_BUTTON_H__
#define __GTK_MODEL_BUTTON_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_MODEL_BUTTON()         (gtk_model_button_get_type ())
#define GTK_MODEL_BUTTON(inst)        (G_TYPE_CHECK_INSTANCE_CAST ((inst),                      \
                                      GTK_TYPE_MODEL_BUTTON, GtkModelButton))
#define GTK_IS_MODEL_BUTTON(inst)     (G_TYPE_CHECK_INSTANCE_TYPE ((inst),                      \
                                      GTK_TYPE_MODEL_BUTTON))


/**
 * GtkButtonRole:
 * @GTK_BUTTON_ROLE_NORMAL: A plain button
 * @GTK_BUTTON_ROLE_CHECK: A check button
 * @GTK_BUTTON_ROLE_RADIO: A radio button
 *
 * The role specifies the desired appearance of a #GtkModelButton.
 */
typedef enum {
  GTK_BUTTON_ROLE_NORMAL,
  GTK_BUTTON_ROLE_CHECK,
  GTK_BUTTON_ROLE_RADIO
} GtkButtonRole;
typedef struct GtkMountOperationPrivate{} GtkMountOperationPrivate;
struct GtkMountOperation
{
  GMountOperation parent_instance;

  GtkMountOperationPrivate *priv;
};
struct GtkMountOperationClass
{
  GMountOperationClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_16
GType       gtk_model_button_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_16
GtkWidget * gtk_model_button_new      (void);

G_END_DECLS

#endif /* __GTK_MODEL_BUTTON_H__ */
#define headerfilename "gtk/./gtkmodules.h"
/* file: gtk/./gtkmodules.h */
/* GTK - The GIMP Toolkit
 * Copyright 1998-2002 Tim Janik, Red Hat, Inc., and others.
 * Copyright (C) 2003 Alex Graveley
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_MODULES_H__
#define __GTK_MODULES_H__



#include <gdk/gdk.h>

G_BEGIN_DECLS

/**
 * GtkModuleInitFunc:
 * @argc: (allow-none): GTK+ always passes %NULL for this argument
 * @argv: (allow-none) (array length=argc): GTK+ always passes %NULL for this argument
 *
 * Each GTK+ module must have a function gtk_module_init() with this prototype.
 * This function is called after loading the module.
 */
typedef void     (*GtkModuleInitFunc)        (gint        *argc,
                                              char      ***argv);

/**
 * GtkModuleDisplayInitFunc:
 * @display: an open #GdkDisplay
 *
 * A multihead-aware GTK+ module may have a gtk_module_display_init() function
 * with this prototype. GTK+ calls this function for each opened display.
 *
 * Since: 2.2
 */
typedef void     (*GtkModuleDisplayInitFunc) (GdkDisplay   *display);


G_END_DECLS


#endif /* __GTK_MODULES_H__ */
#define headerfilename "gtk/./gtkmountoperation.h"
/* file: gtk/./gtkmountoperation.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) Christian Kellner <gicmo@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_MOUNT_OPERATION_H__
#define __GTK_MOUNT_OPERATION_H__



G_BEGIN_DECLS

#define GTK_TYPE_MOUNT_OPERATION()         (gtk_mount_operation_get_type ())
#define GTK_MOUNT_OPERATION(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_MOUNT_OPERATION, GtkMountOperation))
#define GTK_MOUNT_OPERATION_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), GTK_TYPE_MOUNT_OPERATION, GtkMountOperationClass))
#define GTK_IS_MOUNT_OPERATION(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_MOUNT_OPERATION))
#define GTK_IS_MOUNT_OPERATION_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_MOUNT_OPERATION))
#define GTK_MOUNT_OPERATION_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_MOUNT_OPERATION, GtkMountOperationClass))

typedef struct GtkNotebookPrivate{} GtkNotebookPrivate;

/**
 * GtkMountOperation:
 *
 * This should not be accessed directly. Use the accessor functions below.
 */

/**
 * GtkMountOperationClass:
 * @parent_class: The parent class.
 */
struct GtkNotebook
{
  /*< private >*/
  GtkContainer container;

  GtkNotebookPrivate *priv;
};
struct GtkNotebookClass
{
  GtkContainerClass parent_class;

  void (* switch_page)       (GtkNotebook     *notebook,
                              GtkWidget       *page,
			      guint            page_num);

  /* Action signals for keybindings */
  gboolean (* select_page)     (GtkNotebook       *notebook,
                                gboolean           move_focus);
  gboolean (* focus_tab)       (GtkNotebook       *notebook,
                                GtkNotebookTab     type);
  gboolean (* change_current_page) (GtkNotebook   *notebook,
                                gint               offset);
  void (* move_focus_out)      (GtkNotebook       *notebook,
				GtkDirectionType   direction);
  gboolean (* reorder_tab)     (GtkNotebook       *notebook,
				GtkDirectionType   direction,
				gboolean           move_to_last);

  /* More vfuncs */
  gint (* insert_page)         (GtkNotebook       *notebook,
			        GtkWidget         *child,
				GtkWidget         *tab_label,
				GtkWidget         *menu_label,
				gint               position);

  GtkNotebook * (* create_window) (GtkNotebook       *notebook,
                                   GtkWidget         *page,
                                   gint               x,
                                   gint               y);

  void (* page_reordered)      (GtkNotebook     *notebook,
                                GtkWidget       *child,
                                guint            page_num);

  void (* page_removed)        (GtkNotebook     *notebook,
                                GtkWidget       *child,
                                guint            page_num);

  void (* page_added)          (GtkNotebook     *notebook,
                                GtkWidget       *child,
                                guint            page_num);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};


GDK_AVAILABLE_IN_ALL
GType            gtk_mount_operation_get_type   (void);
GDK_AVAILABLE_IN_ALL
GMountOperation *gtk_mount_operation_new        (GtkWindow         *parent);
GDK_AVAILABLE_IN_ALL
gboolean         gtk_mount_operation_is_showing (GtkMountOperation *op);
GDK_AVAILABLE_IN_ALL
void             gtk_mount_operation_set_parent (GtkMountOperation *op,
                                                 GtkWindow         *parent);
GDK_AVAILABLE_IN_ALL
GtkWindow *      gtk_mount_operation_get_parent (GtkMountOperation *op);
GDK_AVAILABLE_IN_ALL
void             gtk_mount_operation_set_screen (GtkMountOperation *op,
                                                 GdkScreen         *screen);
GDK_AVAILABLE_IN_ALL
GdkScreen       *gtk_mount_operation_get_screen (GtkMountOperation *op);

G_END_DECLS

#endif /* __GTK_MOUNT_OPERATION_H__ */
#define headerfilename "gtk/./gtknotebook.h"
/* file: gtk/./gtknotebook.h */
/* -*- Mode: C; c-file-style: "gnu"; tab-width: 8 -*- */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_NOTEBOOK_H__
#define __GTK_NOTEBOOK_H__




#include <gtk/gtkcontainer.h>


G_BEGIN_DECLS

#define GTK_TYPE_NOTEBOOK()                  (gtk_notebook_get_type ())
#define GTK_NOTEBOOK(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_NOTEBOOK, GtkNotebook))
#define GTK_NOTEBOOK_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_NOTEBOOK, GtkNotebookClass))
#define GTK_IS_NOTEBOOK(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_NOTEBOOK))
#define GTK_IS_NOTEBOOK_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_NOTEBOOK))
#define GTK_NOTEBOOK_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_NOTEBOOK, GtkNotebookClass))


typedef enum
{
  GTK_NOTEBOOK_TAB_FIRST,
  GTK_NOTEBOOK_TAB_LAST
} GtkNotebookTab;



struct GtkOffscreenWindow
{
  GtkWindow parent_object;
};
struct GtkOffscreenWindowClass
{
  GtkWindowClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

/***********************************************************
 *           Creation, insertion, deletion                 *
 ***********************************************************/

GDK_AVAILABLE_IN_ALL
GType   gtk_notebook_get_type       (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget * gtk_notebook_new        (void);
GDK_AVAILABLE_IN_ALL
gint gtk_notebook_append_page       (GtkNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label);
GDK_AVAILABLE_IN_ALL
gint gtk_notebook_append_page_menu  (GtkNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label,
				     GtkWidget   *menu_label);
GDK_AVAILABLE_IN_ALL
gint gtk_notebook_prepend_page      (GtkNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label);
GDK_AVAILABLE_IN_ALL
gint gtk_notebook_prepend_page_menu (GtkNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label,
				     GtkWidget   *menu_label);
GDK_AVAILABLE_IN_ALL
gint gtk_notebook_insert_page       (GtkNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label,
				     gint         position);
GDK_AVAILABLE_IN_ALL
gint gtk_notebook_insert_page_menu  (GtkNotebook *notebook,
				     GtkWidget   *child,
				     GtkWidget   *tab_label,
				     GtkWidget   *menu_label,
				     gint         position);
GDK_AVAILABLE_IN_ALL
void gtk_notebook_remove_page       (GtkNotebook *notebook,
				     gint         page_num);

/***********************************************************
 *           Tabs drag and drop                            *
 ***********************************************************/

GDK_AVAILABLE_IN_ALL
void         gtk_notebook_set_group_name (GtkNotebook *notebook,
                                          const char *group_name);
GDK_AVAILABLE_IN_ALL
const char *gtk_notebook_get_group_name (GtkNotebook *notebook);



/***********************************************************
 *            query, set current NotebookPage              *
 ***********************************************************/

GDK_AVAILABLE_IN_ALL
gint       gtk_notebook_get_current_page (GtkNotebook *notebook);
GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_notebook_get_nth_page     (GtkNotebook *notebook,
					  gint         page_num);
GDK_AVAILABLE_IN_ALL
gint       gtk_notebook_get_n_pages      (GtkNotebook *notebook);
GDK_AVAILABLE_IN_ALL
gint       gtk_notebook_page_num         (GtkNotebook *notebook,
					  GtkWidget   *child);
GDK_AVAILABLE_IN_ALL
void       gtk_notebook_set_current_page (GtkNotebook *notebook,
					  gint         page_num);
GDK_AVAILABLE_IN_ALL
void       gtk_notebook_next_page        (GtkNotebook *notebook);
GDK_AVAILABLE_IN_ALL
void       gtk_notebook_prev_page        (GtkNotebook *notebook);

/***********************************************************
 *            set Notebook, NotebookTab style              *
 ***********************************************************/

GDK_AVAILABLE_IN_ALL
void     gtk_notebook_set_show_border      (GtkNotebook     *notebook,
					    gboolean         show_border);
GDK_AVAILABLE_IN_ALL
gboolean gtk_notebook_get_show_border      (GtkNotebook     *notebook);
GDK_AVAILABLE_IN_ALL
void     gtk_notebook_set_show_tabs        (GtkNotebook     *notebook,
					    gboolean         show_tabs);
GDK_AVAILABLE_IN_ALL
gboolean gtk_notebook_get_show_tabs        (GtkNotebook     *notebook);
GDK_AVAILABLE_IN_ALL
void     gtk_notebook_set_tab_pos          (GtkNotebook     *notebook,
				            GtkPositionType  pos);
GDK_AVAILABLE_IN_ALL
GtkPositionType gtk_notebook_get_tab_pos   (GtkNotebook     *notebook);
GDK_AVAILABLE_IN_ALL
void     gtk_notebook_set_scrollable       (GtkNotebook     *notebook,
					    gboolean         scrollable);
GDK_AVAILABLE_IN_ALL
gboolean gtk_notebook_get_scrollable       (GtkNotebook     *notebook);
GDK_DEPRECATED_IN_3_4
guint16  gtk_notebook_get_tab_hborder      (GtkNotebook     *notebook);
GDK_DEPRECATED_IN_3_4
guint16  gtk_notebook_get_tab_vborder      (GtkNotebook     *notebook);

/***********************************************************
 *               enable/disable PopupMenu                  *
 ***********************************************************/

GDK_AVAILABLE_IN_ALL
void gtk_notebook_popup_enable  (GtkNotebook *notebook);
GDK_AVAILABLE_IN_ALL
void gtk_notebook_popup_disable (GtkNotebook *notebook);

/***********************************************************
 *             query/set NotebookPage Properties           *
 ***********************************************************/

GDK_AVAILABLE_IN_ALL
GtkWidget * gtk_notebook_get_tab_label    (GtkNotebook *notebook,
					   GtkWidget   *child);
GDK_AVAILABLE_IN_ALL
void gtk_notebook_set_tab_label           (GtkNotebook *notebook,
					   GtkWidget   *child,
					   GtkWidget   *tab_label);
GDK_AVAILABLE_IN_ALL
void          gtk_notebook_set_tab_label_text (GtkNotebook *notebook,
                                               GtkWidget   *child,
                                               const char *tab_text);
GDK_AVAILABLE_IN_ALL
const char * gtk_notebook_get_tab_label_text (GtkNotebook *notebook,
                                               GtkWidget   *child);
GDK_AVAILABLE_IN_ALL
GtkWidget * gtk_notebook_get_menu_label   (GtkNotebook *notebook,
					   GtkWidget   *child);
GDK_AVAILABLE_IN_ALL
void gtk_notebook_set_menu_label          (GtkNotebook *notebook,
					   GtkWidget   *child,
					   GtkWidget   *menu_label);
GDK_AVAILABLE_IN_ALL
void          gtk_notebook_set_menu_label_text (GtkNotebook *notebook,
                                                GtkWidget   *child,
                                                const char *menu_text);
GDK_AVAILABLE_IN_ALL
const char * gtk_notebook_get_menu_label_text (GtkNotebook *notebook,
							GtkWidget   *child);
GDK_AVAILABLE_IN_ALL
void gtk_notebook_reorder_child           (GtkNotebook *notebook,
					   GtkWidget   *child,
					   gint         position);
GDK_AVAILABLE_IN_ALL
gboolean gtk_notebook_get_tab_reorderable (GtkNotebook *notebook,
					   GtkWidget   *child);
GDK_AVAILABLE_IN_ALL
void gtk_notebook_set_tab_reorderable     (GtkNotebook *notebook,
					   GtkWidget   *child,
					   gboolean     reorderable);
GDK_AVAILABLE_IN_ALL
gboolean gtk_notebook_get_tab_detachable  (GtkNotebook *notebook,
					   GtkWidget   *child);
GDK_AVAILABLE_IN_ALL
void gtk_notebook_set_tab_detachable      (GtkNotebook *notebook,
					   GtkWidget   *child,
					   gboolean     detachable);
GDK_AVAILABLE_IN_3_16
void gtk_notebook_detach_tab              (GtkNotebook *notebook,
                                           GtkWidget   *child);

GDK_AVAILABLE_IN_ALL
GtkWidget* gtk_notebook_get_action_widget (GtkNotebook *notebook,
                                           GtkPackType  pack_type);
GDK_AVAILABLE_IN_ALL
void       gtk_notebook_set_action_widget (GtkNotebook *notebook,
                                           GtkWidget   *widget,
                                           GtkPackType  pack_type);

G_END_DECLS

#endif /* __GTK_NOTEBOOK_H__ */
#define headerfilename "gtk/./gtkoffscreenwindow.h"
/* file: gtk/./gtkoffscreenwindow.h */
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Cody Russell <crussell@canonical.com>
 *          Alexander Larsson <alexl@redhat.com>
 */

#ifndef __GTK_OFFSCREEN_WINDOW_H__
#define __GTK_OFFSCREEN_WINDOW_H__



#include <gtk/gtkwindow.h>

G_BEGIN_DECLS

#define GTK_TYPE_OFFSCREEN_WINDOW()         (gtk_offscreen_window_get_type ())
#define GTK_OFFSCREEN_WINDOW(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_OFFSCREEN_WINDOW, GtkOffscreenWindow))
#define GTK_OFFSCREEN_WINDOW_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST ((k), GTK_TYPE_OFFSCREEN_WINDOW, GtkOffscreenWindowClass))
#define GTK_IS_OFFSCREEN_WINDOW(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_OFFSCREEN_WINDOW))
#define GTK_IS_OFFSCREEN_WINDOW_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GTK_TYPE_OFFSCREEN_WINDOW))
#define GTK_OFFSCREEN_WINDOW_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_OFFSCREEN_WINDOW, GtkOffscreenWindowClass))



/**
 * GtkOffscreenWindowClass:
 * @parent_class: The parent class.
 */
struct GtkOrientableIface
{
  GTypeInterface base_iface;
};
typedef struct _GtkOrientable{} GtkOrientable;         /* Dummy typedef */
typedef struct GtkOverlayPrivate{} GtkOverlayPrivate;

GDK_AVAILABLE_IN_ALL
GType            gtk_offscreen_window_get_type    (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkWidget       *gtk_offscreen_window_new         (void);
GDK_AVAILABLE_IN_ALL
cairo_surface_t *gtk_offscreen_window_get_surface (GtkOffscreenWindow *offscreen);
GDK_AVAILABLE_IN_ALL
GdkPixbuf       *gtk_offscreen_window_get_pixbuf  (GtkOffscreenWindow *offscreen);

G_END_DECLS

#endif /* __GTK_OFFSCREEN_WINDOW_H__ */
#define headerfilename "gtk/./gtkorientable.h"
/* file: gtk/./gtkorientable.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * gtkorientable.h
 * Copyright (C) 2008 Imendio AB
 * Contact: Michael Natterer <mitch@imendio.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_ORIENTABLE_H__
#define __GTK_ORIENTABLE_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_ORIENTABLE()             (gtk_orientable_get_type ())
#define GTK_ORIENTABLE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ORIENTABLE, GtkOrientable))
#define GTK_ORIENTABLE_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), GTK_TYPE_ORIENTABLE, GtkOrientableIface))
#define GTK_IS_ORIENTABLE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ORIENTABLE))
#define GTK_IS_ORIENTABLE_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), GTK_TYPE_ORIENTABLE))
#define GTK_ORIENTABLE_GET_IFACE(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), GTK_TYPE_ORIENTABLE, GtkOrientableIface))



struct GtkOverlay
{
  GtkBin parent;

  GtkOverlayPrivate *priv;
};
struct GtkOverlayClass
{
  GtkBinClass parent_class;

  /*< public >*/

  gboolean (*get_child_position) (GtkOverlay    *overlay,
                                  GtkWidget     *widget,
                                  GtkAllocation *allocation);

  /*< private >*/

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
  void (*_gtk_reserved8) (void);
};


GDK_AVAILABLE_IN_ALL
GType          gtk_orientable_get_type        (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
void           gtk_orientable_set_orientation (GtkOrientable  *orientable,
                                               GtkOrientation  orientation);
GDK_AVAILABLE_IN_ALL
GtkOrientation gtk_orientable_get_orientation (GtkOrientable  *orientable);

G_END_DECLS

#endif /* __GTK_ORIENTABLE_H__ */
#define headerfilename "gtk/./gtkoverlay.h"
/* file: gtk/./gtkoverlay.h */
/*
 * gtkoverlay.h
 * This file is part of gtk
 *
 * Copyright (C) 2011 - Ignacio Casal Quinteiro
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_OVERLAY_H__
#define __GTK_OVERLAY_H__



#include <gtk/gtkbin.h>

G_BEGIN_DECLS

#define GTK_TYPE_OVERLAY()             (gtk_overlay_get_type ())
#define GTK_OVERLAY(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_OVERLAY, GtkOverlay))
#define GTK_OVERLAY_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_OVERLAY, GtkOverlayClass))
#define GTK_IS_OVERLAY(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_OVERLAY))
#define GTK_IS_OVERLAY_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_OVERLAY))
#define GTK_OVERLAY_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_OVERLAY, GtkOverlayClass))

typedef struct GtkPanedPrivate{} GtkPanedPrivate;


/**
 * GtkOverlayClass:
 * @parent_class: The parent class.
 * @get_child_position: Signal emitted to determine the position and
 *    size of any overlay child widgets.
 */
struct GtkPaned
{
  GtkContainer container;

  /*< private >*/
  GtkPanedPrivate *priv;
};
struct GtkPanedClass
{
  GtkContainerClass parent_class;

  gboolean (* cycle_child_focus)   (GtkPaned      *paned,
				    gboolean       reverse);
  gboolean (* toggle_handle_focus) (GtkPaned      *paned);
  gboolean (* move_handle)         (GtkPaned      *paned,
				    GtkScrollType  scroll);
  gboolean (* cycle_handle_focus)  (GtkPaned      *paned,
				    gboolean       reverse);
  gboolean (* accept_position)     (GtkPaned	  *paned);
  gboolean (* cancel_position)     (GtkPaned	  *paned);

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};

GDK_AVAILABLE_IN_3_2
GType      gtk_overlay_get_type    (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_2
GtkWidget *gtk_overlay_new         (void);
GDK_AVAILABLE_IN_3_2
void       gtk_overlay_add_overlay (GtkOverlay *overlay,
                                    GtkWidget  *widget);
GDK_AVAILABLE_IN_3_18
void       gtk_overlay_reorder_overlay (GtkOverlay     *overlay,
					GtkWidget      *child,
					gint            position);
GDK_AVAILABLE_IN_3_18
gboolean   gtk_overlay_get_overlay_pass_through (GtkOverlay *overlay,
						 GtkWidget  *widget);
GDK_AVAILABLE_IN_3_18
void       gtk_overlay_set_overlay_pass_through (GtkOverlay *overlay,
						 GtkWidget  *widget,
						 gboolean    pass_through);

G_END_DECLS

#endif /* __GTK_OVERLAY_H__ */
#define headerfilename "gtk/./gtkpapersize.h"
/* file: gtk/./gtkpapersize.h */
/* GTK - The GIMP Toolkit
 * gtkpapersize.h: Paper Size
 * Copyright (C) 2006, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_PAPER_SIZE_H__
#define __GTK_PAPER_SIZE_H__




#include <gdk/gdk.h>
#include <gtk/gtkenums.h>


G_BEGIN_DECLS

typedef struct _GtkPaperSize{} GtkPaperSize;

#define GTK_TYPE_PAPER_SIZE()    (gtk_paper_size_get_type ())

/* Common names, from PWG 5101.1-2002 PWG: Standard for Media Standardized Names */
/**
 * GTK_PAPER_NAME_A3:
 *
 * Name for the A3 paper size.
 */
#define GTK_PAPER_NAME_A3 "iso_a3"

/**
 * GTK_PAPER_NAME_A4:
 *
 * Name for the A4 paper size.
 */
#define GTK_PAPER_NAME_A4 "iso_a4"

/**
 * GTK_PAPER_NAME_A5:
 *
 * Name for the A5 paper size.
 */
#define GTK_PAPER_NAME_A5 "iso_a5"

/**
 * GTK_PAPER_NAME_B5:
 *
 * Name for the B5 paper size.
 */
#define GTK_PAPER_NAME_B5 "iso_b5"

/**
 * GTK_PAPER_NAME_LETTER:
 *
 * Name for the Letter paper size.
 */
#define GTK_PAPER_NAME_LETTER "na_letter"

/**
 * GTK_PAPER_NAME_EXECUTIVE:
 *
 * Name for the Executive paper size.
 */
#define GTK_PAPER_NAME_EXECUTIVE "na_executive"

/**
 * GTK_PAPER_NAME_LEGAL:
 *
 * Name for the Legal paper size.
 */
#define GTK_PAPER_NAME_LEGAL "na_legal"

GDK_AVAILABLE_IN_ALL
GType gtk_paper_size_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_ALL
GtkPaperSize *gtk_paper_size_new          (const char  *name);
GDK_AVAILABLE_IN_ALL
GtkPaperSize *gtk_paper_size_new_from_ppd (const char  *ppd_name,
					   const char  *ppd_display_name,
					   gdouble       width,
					   gdouble       height);
GDK_AVAILABLE_IN_ALL
GtkPaperSize *gtk_paper_size_new_from_ipp (const char  *ipp_name,
					   gdouble       width,
					   gdouble       height);
GDK_AVAILABLE_IN_ALL
GtkPaperSize *gtk_paper_size_new_custom   (const char  *name,
					   const char  *display_name,
					   gdouble       width,
					   gdouble       height,
					   GtkUnit       unit);
GDK_AVAILABLE_IN_ALL
GtkPaperSize *gtk_paper_size_copy         (GtkPaperSize *other);
GDK_AVAILABLE_IN_ALL
void          gtk_paper_size_free         (GtkPaperSize *size);
GDK_AVAILABLE_IN_ALL
gboolean      gtk_paper_size_is_equal     (GtkPaperSize *size1,
					   GtkPaperSize *size2);

GDK_AVAILABLE_IN_ALL
GList        *gtk_paper_size_get_paper_sizes (gboolean include_custom);

/* The width is always the shortest side, measure in mm */
GDK_AVAILABLE_IN_ALL
const char *gtk_paper_size_get_name         (GtkPaperSize *size);
GDK_AVAILABLE_IN_ALL
const char *gtk_paper_size_get_display_name (GtkPaperSize *size);
GDK_AVAILABLE_IN_ALL
const char *gtk_paper_size_get_ppd_name     (GtkPaperSize *size);

GDK_AVAILABLE_IN_ALL
gdouble  gtk_paper_size_get_width        (GtkPaperSize *size, GtkUnit unit);
GDK_AVAILABLE_IN_ALL
gdouble  gtk_paper_size_get_height       (GtkPaperSize *size, GtkUnit unit);
GDK_AVAILABLE_IN_ALL
gboolean gtk_paper_size_is_custom        (GtkPaperSize *size);
GDK_AVAILABLE_IN_ALL
gboolean gtk_paper_size_is_ipp           (GtkPaperSize *size);

/* Only for custom sizes: */
GDK_AVAILABLE_IN_ALL
void    gtk_paper_size_set_size                  (GtkPaperSize *size, 
                                                  gdouble       width, 
                                                  gdouble       height, 
                                                  GtkUnit       unit);

GDK_AVAILABLE_IN_ALL
gdouble gtk_paper_size_get_default_top_margin    (GtkPaperSize *size,
						  GtkUnit       unit);
GDK_AVAILABLE_IN_ALL
gdouble gtk_paper_size_get_default_bottom_margin (GtkPaperSize *size,
						  GtkUnit       unit);
GDK_AVAILABLE_IN_ALL
gdouble gtk_paper_size_get_default_left_margin   (GtkPaperSize *size,
						  GtkUnit       unit);
GDK_AVAILABLE_IN_ALL
gdouble gtk_paper_size_get_default_right_margin  (GtkPaperSize *size,
						  GtkUnit       unit);

GDK_AVAILABLE_IN_ALL
const char *gtk_paper_size_get_default (void);

GDK_AVAILABLE_IN_ALL
GtkPaperSize *gtk_paper_size_new_from_key_file (GKeyFile    *key_file,
					        const char *group_name,
					        GError     **error);
GDK_AVAILABLE_IN_ALL
void     gtk_paper_size_to_key_file            (GtkPaperSize *size,
					        GKeyFile     *key_file,
					        const char  *group_name);

G_END_DECLS

#endif /* __GTK_PAPER_SIZE_H__ */
#define headerfilename "gtk/./gtkpagesetup.h"
/* file: gtk/./gtkpagesetup.h */
/* GTK - The GIMP Toolkit
 * gtkpagesetup.h: Page Setup
 * Copyright (C) 2006, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_PAGE_SETUP_H__
#define __GTK_PAGE_SETUP_H__




#include <gtk/gtkpapersize.h>


G_BEGIN_DECLS

typedef struct _GtkPageSetup{} GtkPageSetup;

#define GTK_TYPE_PAGE_SETUP()    (gtk_page_setup_get_type ())
#define GTK_PAGE_SETUP(obj)    (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_PAGE_SETUP, GtkPageSetup))
#define GTK_IS_PAGE_SETUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_PAGE_SETUP))

GDK_AVAILABLE_IN_ALL
GType              gtk_page_setup_get_type          (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkPageSetup *     gtk_page_setup_new               (void);
GDK_AVAILABLE_IN_ALL
GtkPageSetup *     gtk_page_setup_copy              (GtkPageSetup       *other);
GDK_AVAILABLE_IN_ALL
GtkPageOrientation gtk_page_setup_get_orientation   (GtkPageSetup       *setup);
GDK_AVAILABLE_IN_ALL
void               gtk_page_setup_set_orientation   (GtkPageSetup       *setup,
						     GtkPageOrientation  orientation);
GDK_AVAILABLE_IN_ALL
GtkPaperSize *     gtk_page_setup_get_paper_size    (GtkPageSetup       *setup);
GDK_AVAILABLE_IN_ALL
void               gtk_page_setup_set_paper_size    (GtkPageSetup       *setup,
						     GtkPaperSize       *size);
GDK_AVAILABLE_IN_ALL
gdouble            gtk_page_setup_get_top_margin    (GtkPageSetup       *setup,
						     GtkUnit             unit);
GDK_AVAILABLE_IN_ALL
void               gtk_page_setup_set_top_margin    (GtkPageSetup       *setup,
						     gdouble             margin,
						     GtkUnit             unit);
GDK_AVAILABLE_IN_ALL
gdouble            gtk_page_setup_get_bottom_margin (GtkPageSetup       *setup,
						     GtkUnit             unit);
GDK_AVAILABLE_IN_ALL
void               gtk_page_setup_set_bottom_margin (GtkPageSetup       *setup,
						     gdouble             margin,
						     GtkUnit             unit);
GDK_AVAILABLE_IN_ALL
gdouble            gtk_page_setup_get_left_margin   (GtkPageSetup       *setup,
						     GtkUnit             unit);
GDK_AVAILABLE_IN_ALL
void               gtk_page_setup_set_left_margin   (GtkPageSetup       *setup,
						     gdouble             margin,
						     GtkUnit             unit);
GDK_AVAILABLE_IN_ALL
gdouble            gtk_page_setup_get_right_margin  (GtkPageSetup       *setup,
						     GtkUnit             unit);
GDK_AVAILABLE_IN_ALL
void               gtk_page_setup_set_right_margin  (GtkPageSetup       *setup,
						     gdouble             margin,
						     GtkUnit             unit);

GDK_AVAILABLE_IN_ALL
void gtk_page_setup_set_paper_size_and_default_margins (GtkPageSetup    *setup,
							GtkPaperSize    *size);

/* These take orientation, but not margins into consideration */
GDK_AVAILABLE_IN_ALL
gdouble            gtk_page_setup_get_paper_width   (GtkPageSetup       *setup,
						     GtkUnit             unit);
GDK_AVAILABLE_IN_ALL
gdouble            gtk_page_setup_get_paper_height  (GtkPageSetup       *setup,
						     GtkUnit             unit);


/* These take orientation, and margins into consideration */
GDK_AVAILABLE_IN_ALL
gdouble            gtk_page_setup_get_page_width    (GtkPageSetup       *setup,
						     GtkUnit             unit);
GDK_AVAILABLE_IN_ALL
gdouble            gtk_page_setup_get_page_height   (GtkPageSetup       *setup,
						     GtkUnit             unit);

/* Saving and restoring page setup */
GDK_AVAILABLE_IN_ALL
GtkPageSetup	  *gtk_page_setup_new_from_file	    (const char         *file_name,
						     GError              **error);
GDK_AVAILABLE_IN_ALL
gboolean	   gtk_page_setup_load_file	    (GtkPageSetup        *setup,
						     const char          *file_name,
						     GError             **error);
GDK_AVAILABLE_IN_ALL
gboolean	   gtk_page_setup_to_file	    (GtkPageSetup        *setup,
						     const char          *file_name,
						     GError             **error);
GDK_AVAILABLE_IN_ALL
GtkPageSetup	  *gtk_page_setup_new_from_key_file (GKeyFile            *key_file,
						     const char         *group_name,
						     GError             **error);
GDK_AVAILABLE_IN_ALL
gboolean           gtk_page_setup_load_key_file     (GtkPageSetup        *setup,
				                     GKeyFile            *key_file,
				                     const char         *group_name,
				                     GError             **error);
GDK_AVAILABLE_IN_ALL
void		   gtk_page_setup_to_key_file	    (GtkPageSetup        *setup,
						     GKeyFile            *key_file,
						     const char         *group_name);

G_END_DECLS

#endif /* __GTK_PAGE_SETUP_H__ */
#define headerfilename "gtk/./gtkpaned.h"
/* file: gtk/./gtkpaned.h */
/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __GTK_PANED_H__
#define __GTK_PANED_H__



#include <gtk/gtkcontainer.h>

G_BEGIN_DECLS

#define GTK_TYPE_PANED()                  (gtk_paned_get_type ())
#define GTK_PANED(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_PANED, GtkPaned))
#define GTK_PANED_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_PANED, GtkPanedClass))
#define GTK_IS_PANED(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_PANED))
#define GTK_IS_PANED_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_PANED))
#define GTK_PANED_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_PANED, GtkPanedClass))


typedef struct _GtkPlacesSidebar{} GtkPlacesSidebar;
typedef struct _GtkPlacesSidebarClass{} GtkPlacesSidebarClass;




GDK_AVAILABLE_IN_ALL
GType       gtk_paned_get_type     (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_ALL
GtkWidget * gtk_paned_new          (GtkOrientation orientation);
GDK_AVAILABLE_IN_ALL
void        gtk_paned_add1         (GtkPaned       *paned,
                                    GtkWidget      *child);
GDK_AVAILABLE_IN_ALL
void        gtk_paned_add2         (GtkPaned       *paned,
                                    GtkWidget      *child);
GDK_AVAILABLE_IN_ALL
void        gtk_paned_pack1        (GtkPaned       *paned,
                                    GtkWidget      *child,
                                    gboolean        resize,
                                    gboolean        shrink);
GDK_AVAILABLE_IN_ALL
void        gtk_paned_pack2        (GtkPaned       *paned,
                                    GtkWidget      *child,
                                    gboolean        resize,
                                    gboolean        shrink);

GDK_AVAILABLE_IN_ALL
gint        gtk_paned_get_position (GtkPaned       *paned);
GDK_AVAILABLE_IN_ALL
void        gtk_paned_set_position (GtkPaned       *paned,
                                    gint            position);

GDK_AVAILABLE_IN_ALL
GtkWidget * gtk_paned_get_child1   (GtkPaned       *paned);
GDK_AVAILABLE_IN_ALL
GtkWidget * gtk_paned_get_child2   (GtkPaned       *paned);

GDK_AVAILABLE_IN_ALL
GdkWindow * gtk_paned_get_handle_window (GtkPaned  *paned);

GDK_AVAILABLE_IN_3_16
void        gtk_paned_set_wide_handle (GtkPaned    *paned,
                                       gboolean     wide);
GDK_AVAILABLE_IN_3_16
gboolean    gtk_paned_get_wide_handle (GtkPaned    *paned);


G_END_DECLS

#endif /* __GTK_PANED_H__ */
#define headerfilename "gtk/./gtkplacessidebar.h"
/* file: gtk/./gtkplacessidebar.h */
/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/* GtkPlacesSidebar - sidebar widget for places in the filesystem
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * This code comes from Nautilus, GNOME’s file manager.
 *
 * Authors : Mr Jamie McCracken (jamiemcc at blueyonder dot co dot uk)
 *           Federico Mena Quintero <federico@gnome.org>
 */

#ifndef __GTK_PLACES_SIDEBAR_H__
#define __GTK_PLACES_SIDEBAR_H__



#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define GTK_TYPE_PLACES_SIDEBAR()			(gtk_places_sidebar_get_type ())
#define GTK_PLACES_SIDEBAR(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_PLACES_SIDEBAR, GtkPlacesSidebar))
#define GTK_PLACES_SIDEBAR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_PLACES_SIDEBAR, GtkPlacesSidebarClass))
#define GTK_IS_PLACES_SIDEBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_PLACES_SIDEBAR))
#define GTK_IS_PLACES_SIDEBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_PLACES_SIDEBAR))
#define GTK_PLACES_SIDEBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_PLACES_SIDEBAR, GtkPlacesSidebarClass))


/**
 * GtkPlacesOpenFlags:
 * @GTK_PLACES_OPEN_NORMAL: This is the default mode that #GtkPlacesSidebar uses if no other flags
 *  are specified.  It indicates that the calling application should open the selected location
 *  in the normal way, for example, in the folder view beside the sidebar.
 * @GTK_PLACES_OPEN_NEW_TAB: When passed to gtk_places_sidebar_set_open_flags(), this indicates
 *  that the application can open folders selected from the sidebar in new tabs.  This value
 *  will be passed to the #GtkPlacesSidebar::open-location signal when the user selects
 *  that a location be opened in a new tab instead of in the standard fashion.
 * @GTK_PLACES_OPEN_NEW_WINDOW: Similar to @GTK_PLACES_OPEN_NEW_TAB, but indicates that the application
 *  can open folders in new windows.
 *
 * These flags serve two purposes.  First, the application can call gtk_places_sidebar_set_open_flags()
 * using these flags as a bitmask.  This tells the sidebar that the application is able to open
 * folders selected from the sidebar in various ways, for example, in new tabs or in new windows in
 * addition to the normal mode.
 *
 * Second, when one of these values gets passed back to the application in the
 * #GtkPlacesSidebar::open-location signal, it means that the application should
 * open the selected location in the normal way, in a new tab, or in a new
 * window.  The sidebar takes care of determining the desired way to open the location,
 * based on the modifier keys that the user is pressing at the time the selection is made.
 *
 * If the application never calls gtk_places_sidebar_set_open_flags(), then the sidebar will only
 * use #GTK_PLACES_OPEN_NORMAL in the #GtkPlacesSidebar::open-location signal.  This is the
 * default mode of operation.
 */
typedef enum {
  GTK_PLACES_OPEN_NORMAL     = 1 << 0,
  GTK_PLACES_OPEN_NEW_TAB    = 1 << 1,
  GTK_PLACES_OPEN_NEW_WINDOW = 1 << 2
} GtkPlacesOpenFlags;
struct GtkPopoverMenuClass
{
  GtkPopoverClass parent_class;

  /*< private >*/

  /* Padding for future expansion */
  gpointer reserved[10];
};
typedef struct GtkPopoverMenu{} GtkPopoverMenu;

GDK_AVAILABLE_IN_3_10
GType              gtk_places_sidebar_get_type                   (void) G_GNUC_CONST;
GDK_AVAILABLE_IN_3_10
GtkWidget *        gtk_places_sidebar_new                        (void);

GDK_AVAILABLE_IN_3_10
GtkPlacesOpenFlags gtk_places_sidebar_get_open_flags             (GtkPlacesSidebar   *sidebar);
GDK_AVAILABLE_IN_3_10
void               gtk_places_sidebar_set_open_flags             (GtkPlacesSidebar   *sidebar,
                                                                  GtkPlacesOpenFlags  flags);

GDK_AVAILABLE_IN_3_10
GFile *            gtk_places_sidebar_get_location               (GtkPlacesSidebar   *sidebar);
GDK_AVAILABLE_IN_3_10
void               gtk_places_sidebar_set_location               (GtkPlacesSidebar   *sidebar,
                                                                  GFile              *location);

GDK_AVAILABLE_IN_3_18
gboolean           gtk_places_sidebar_get_show_recent            (GtkPlacesSidebar   *sidebar);
GDK_AVAILABLE_IN_3_18
void               gtk_places_sidebar_set_show_recent            (GtkPlacesSidebar   *sidebar,
                                                                  gboolean            show_recent);

GDK_AVAILABLE_IN_3_10
gboolean           gtk_places_sidebar_get_show_desktop           (GtkPlacesSidebar   *sidebar);
GDK_AVAILABLE_IN_3_10
void               gtk_places_sidebar_set_show_desktop           (GtkPlacesSidebar   *sidebar,
                                                                  gboolean            show_desktop);

GDK_DEPRECATED_IN_3_18
gboolean           gtk_places_sidebar_get_show_connect_to_server (GtkPlacesSidebar   *sidebar);
GDK_DEPRECATED_IN_3_18
void               gtk_places_sidebar_set_show_connect_to_server (GtkPlacesSidebar   *sidebar,
                                                                  gboolean            show_connect_to_server);
GDK_AVAILABLE_IN_3_14
gboolean           gtk_places_sidebar_get_show_enter_location    (GtkPlacesSidebar   *sidebar);
GDK_AVAILABLE_IN_3_14
void               gtk_places_sidebar_set_show_enter_location    (GtkPlacesSidebar   *sidebar,
                                                                  gboolean            show_enter_location);

GDK_AVAILABLE_IN_3_12
void                 gtk_places_sidebar_set_local_only           (GtkPlacesSidebar   *sidebar,
                                                                  gboolean            local_only);
GDK_AVAILABLE_IN_3_12
gboolean             gtk_places_sidebar_get_local_only           (GtkPlacesSidebar   *sidebar);


GDK_AVAILABLE_IN_3_10
void               gtk_places_sidebar_add_shortcut               (GtkPlacesSidebar   *sidebar,
                                                                  GFile              *location);
GDK_AVAILABLE_IN_3_10
void               gtk_places_sidebar_remove_shortcut            (GtkPlacesSidebar   *sidebar,
                                                                  GFile              *location);
GDK_AVAILABLE_IN_3_10
GSList *           gtk_places_sidebar_list_shortcuts             (GtkPlacesSidebar   *sidebar);

GDK_AVAILABLE_IN_3_10
GFile *            gtk_places_sidebar_get_nth_bookmark           (GtkPlacesSidebar   *sidebar,
                                                                  gint                n);
GDK_AVAILABLE_IN_3_18
void               gtk_places_sidebar_set_drop_targets_visible   (GtkPlacesSidebar   *sidebar,
                                                                  gboolean            visible,
                                                                  GdkDragContext     *context);
GDK_AVAILABLE_IN_3_18
gboolean           gtk_places_sidebar_get_show_trash             (GtkPlacesSidebar   *sidebar);
GDK_AVAILABLE_IN_3_18
void               gtk_places_sidebar_set_show_trash             (GtkPlacesSidebar   *sidebar,
                                                                  gboolean            show_trash);

GDK_AVAILABLE_IN_3_18
void                 gtk_places_sidebar_set_show_other_locations (GtkPlacesSidebar   *sidebar,
                                                                  gboolean            show_other_locations);
GDK_AVAILABLE_IN_3_18
gboolean             gtk_places_sidebar_get_show_other_locations (GtkPlacesSidebar   *sidebar);

G_END_DECLS

#endif /* __GTK_PLACES_SIDEBAR_H__ */
#define headerfilename "gtk/./gtkpopovermenu.h"
/* file: gtk/./gtkpopovermenu.h */
/* GTK - The GIMP Toolkit
 * Copyright © 2014 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_POPOVER_MENU_H__
#define __GTK_POPOVER_MENU_H__



#include <gtk/gtkpopover.h>

G_BEGIN_DECLS

#define GTK_TYPE_POPOVER_MENU()           (gtk_popover_menu_get_type ())
#define GTK_POPOVER_MENU(o)             (G_TYPE_CHECK_INSTANCE_CAST ((o), GTK_TYPE_POPOVER_MENU, GtkPopoverMenu))
#define GTK_POPOVER_MENU_CLASS(c)       (G_TYPE_CHECK_CLASS_CAST ((c), GTK_TYPE_POPOVER_MENU, GtkPopoverMenuClass))
#define GTK_IS_POPOVER_MENU(o)          (G_TYPE_CHECK_INSTANCE_TYPE ((o), GTK_TYPE_POPOVER_MENU))
#define GTK_IS_POPOVER_MENU_CLASS(o)    (G_TYPE_CHECK_CLASS_TYPE ((o), GTK_TYPE_POPOVER_MENU))
#define GTK_POPOVER_MENU_GET_CLASS(o)   (G_TYPE_INSTANCE_GET_CLASS ((o), GTK_TYPE_POPOVER_MENU, GtkPopoverMenuClass))



GDK_AVAILABLE_IN_3_16
GType       gtk_popover_menu_get_type (void) G_GNUC_CONST;

GDK_AVAILABLE_IN_3_16
GtkWidget * gtk_popover_menu_new      (void);

GDK_AVAILABLE_IN_3_16
void        gtk_popover_menu_open_submenu (GtkPopoverMenu *popover,
                                           const char    *name);


G_END_DECLS

#endif /* __GTK_POPOVER_MENU_H__ */
#define headerfilename "gtk/./gtkprintcontext.h"
/* file: gtk/./gtkprintcontext.h */
/* GTK - The GIMP Toolkit
 * gtkprintcontext.h: Print Context
 * Copyright (C) 2006, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_PRINT_CONTEXT_H__
#define __GTK_PRINT_CONTEXT_H__




#include <pango/pango.h>
#include <gtk/gtkpagesetup.h>


G_BEGIN_DECLS

typedef struct _GtkPrintContext{} GtkPrintContext;

#define GTK_TYPE_PRINT_CONTEXT()    (gtk_print_context_get_type ())
#define GTK_PRINT_CONTEXT(obj)    (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_PRINT_CONTEXT, GtkPrintContext))
#define GTK_IS_PRINT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_PRINT_CONTEXT))

GDK_AVAILABLE_IN_ALL
GType          gtk_print_context_get_type (void) G_GNUC_CONST;


/* Rendering */
GDK_AVAILABLE_IN_ALL
cairo_t      *gtk_print_context_get_cairo_context    (GtkPrintContext *context);

GDK_AVAILABLE_IN_ALL
GtkPageSetup *gtk_print_context_get_page_setup       (GtkPrintContext *context);
GDK_AVAILABLE_IN_ALL
gdouble       gtk_print_context_get_width            (GtkPrintContext *context);
GDK_AVAILABLE_IN_ALL
gdouble       gtk_print_context_get_height           (GtkPrintContext *context);
GDK_AVAILABLE_IN_ALL
gdouble       gtk_print_context_get_dpi_x            (GtkPrintContext *context);
GDK_AVAILABLE_IN_ALL
gdouble       gtk_print_conte