{.deadCodeElim: on.}

when defined(windows):
  const LIB_GTK* = "libgtk-3-0.dll"
elif defined(gtk_quartz):
  const LIB_GTK* = "libgtk-3.0.dylib"
elif defined(macosx):
  const LIB_GTK* = "libgtk-x11-3.0.dylib"
else:
  const LIB_GTK* = "libgtk-3.so(|.0)"

{.pragma: libgtk, cdecl, dynlib: LIB_GTK.}

from gdk3 import Window

from glib import Gboolean, Gpointer, GQuark, GDestroyNotify, Gsize, Gssize, Gunichar,
  GTokenType, G_PRIORITY_HIGH_IDLE, G_MAXUSHORT, Time

from gobject import GClosure, GObjectClassObj, GObjectObj, GObject, GType, GConnectFlags, GCallback,
  gTypeCheckInstanceCast, gTypeCheckInstanceType, gTypeInstanceGetInterface, gTypeCheckClassCast, gTypeCheckClassType, gTypeInstanceGetClass, isA

from gdk_pixbuf import GdkPixbuf

from cairo import Pattern, Context, Region

from pango import FontDescription, Layout, AttrList, Context, EllipsizeMode, WrapMode, Direction

from gio import GFile, GMenu, GMenuModel, GActionGroup, GAppInfo, GApplication, GApplicationClass, GMountOperation, GAsyncReadyCallback,
  GMountOperationClass, GEmblemedIcon, GEmblemedIconClass, GIcon, GPermission, GAsyncResult, GCancellable, GApplicationFlags

from atk import Object, ObjectClass, RelationSet, Role, CoordType

const
  GDK_MULTIHEAD_SAFE = true
  DISABLE_DEPRECATED = false

type
  Align* {.size: sizeof(cint), pure.} = enum
    FILL, START, `END`, CENTER,
    BASELINE

type
  ArrowType* {.size: sizeof(cint), pure.} = enum
    UP, DOWN, LEFT, RIGHT, NONE

type
  BaselinePosition* {.size: sizeof(cint), pure.} = enum
    TOP, CENTER,
    BOTTOM

type
  DeleteType* {.size: sizeof(cint), pure.} = enum
    CHARS, WORD_ENDS, WORDS,
    DISPLAY_LINES, DISPLAY_LINE_ENDS,
    PARAGRAPH_ENDS, PARAGRAPHS, WHITESPACE

type
  DirectionType* {.size: sizeof(cint), pure.} = enum
    TAB_FORWARD, TAB_BACKWARD, UP, DOWN,
    LEFT, RIGHT

type
  IconSize* {.size: sizeof(cint), pure.} = enum
    INVALID, MENU, SMALL_TOOLBAR,
    LARGE_TOOLBAR, BUTTON, DND,
    DIALOG

type
  SensitivityType* {.size: sizeof(cint), pure.} = enum
    AUTO, ON, OFF

type
  TextDirection* {.size: sizeof(cint), pure.} = enum
    NONE, LTR, RTL

type
  Justification* {.size: sizeof(cint), pure.} = enum
    LEFT, RIGHT, CENTER, FILL

type
  MenuDirectionType* {.size: sizeof(cint), pure.} = enum
    DIR_PARENT, DIR_CHILD, DIR_NEXT, DIR_PREV

type
  MessageType* {.size: sizeof(cint), pure.} = enum
    INFO, WARNING, QUESTION, ERROR,
    OTHER

type
  MovementStep* {.size: sizeof(cint), pure.} = enum
    LOGICAL_POSITIONS, VISUAL_POSITIONS,
    WORDS, DISPLAY_LINES,
    DISPLAY_LINE_ENDS, PARAGRAPHS,
    PARAGRAPH_ENDS, PAGES, BUFFER_ENDS,
    HORIZONTAL_PAGES

type
  ScrollStep* {.size: sizeof(cint), pure.} = enum
    STEPS, PAGES, ENDS,
    HORIZONTAL_STEPS, HORIZONTAL_PAGES,
    HORIZONTAL_ENDS

type
  Orientation* {.size: sizeof(cint), pure.} = enum
    HORIZONTAL, VERTICAL

type
  PackType* {.size: sizeof(cint), pure.} = enum
    START, `END`

type
  PositionType* {.size: sizeof(cint), pure.} = enum
    LEFT, RIGHT, TOP, BOTTOM

type
  ReliefStyle* {.size: sizeof(cint), pure.} = enum
    NORMAL, HALF, NONE

type
  ScrollType* {.size: sizeof(cint), pure.} = enum
    NONE, JUMP, STEP_BACKWARD,
    STEP_FORWARD, PAGE_BACKWARD, PAGE_FORWARD,
    STEP_UP, STEP_DOWN, PAGE_UP,
    PAGE_DOWN, STEP_LEFT, STEP_RIGHT,
    PAGE_LEFT, PAGE_RIGHT, START, `END`

type
  SelectionMode* {.size: sizeof(cint), pure.} = enum
    NONE, SINGLE, BROWSE,
    MULTIPLE

type
  ShadowType* {.size: sizeof(cint), pure.} = enum
    NONE, `IN`, `OUT`, ETCHED_IN,
    ETCHED_OUT

type
  StateType* {.size: sizeof(cint), pure.} = enum
    NORMAL, ACTIVE, PRELIGHT, SELECTED,
    INSENSITIVE, INCONSISTENT, FOCUSED

type
  ToolbarStyle* {.size: sizeof(cint), pure.} = enum
    ICONS, TEXT, BOTH, BOTH_HORIZ

type
  WrapMode* {.size: sizeof(cint), pure.} = enum
    NONE, CHAR, WORD, WORD_CHAR

type
  SortType* {.size: sizeof(cint), pure.} = enum
    ASCENDING, DESCENDING

type
  IMPreeditStyle* {.size: sizeof(cint), pure.} = enum
    NOTHING, CALLBACK, NONE

type
  IMStatusStyle* {.size: sizeof(cint), pure.} = enum
    NOTHING, CALLBACK, NONE

type
  PackDirection* {.size: sizeof(cint), pure.} = enum
    LTR, RTL, TTB,
    BTT

type
  PrintPages* {.size: sizeof(cint), pure.} = enum
    ALL, CURRENT, RANGES,
    SELECTION

type
  PageSet* {.size: sizeof(cint), pure.} = enum
    ALL, EVEN, ODD

type
  NumberUpLayout* {.size: sizeof(cint), pure.} = enum
    LEFT_TO_RIGHT_TOP_TO_BOTTOM,
    LEFT_TO_RIGHT_BOTTOM_TO_TOP,
    RIGHT_TO_LEFT_TOP_TO_BOTTOM,
    RIGHT_TO_LEFT_BOTTOM_TO_TOP,
    TOP_TO_BOTTOM_LEFT_TO_RIGHT,
    TOP_TO_BOTTOM_RIGHT_TO_LEFT,
    BOTTOM_TO_TOP_LEFT_TO_RIGHT,
    BOTTOM_TO_TOP_RIGHT_TO_LEFT

type
  PageOrientation* {.size: sizeof(cint), pure.} = enum
    PORTRAIT, LANDSCAPE,
    REVERSE_PORTRAIT, REVERSE_LANDSCAPE

type
  PrintQuality* {.size: sizeof(cint), pure.} = enum
    LOW, NORMAL, HIGH,
    DRAFT

type
  PrintDuplex* {.size: sizeof(cint), pure.} = enum
    SIMPLEX, HORIZONTAL,
    VERTICAL

type
  Unit* {.size: sizeof(cint), pure.} = enum
    NONE, POINTS, INCH, MM

const
  UNIT_PIXEL* = Unit.NONE

type
  TreeViewGridLines* {.size: sizeof(cint), pure.} = enum
    NONE, HORIZONTAL,
    VERTICAL, BOTH

type
  DragResult* {.size: sizeof(cint), pure.} = enum
    SUCCESS, NO_TARGET,
    USER_CANCELLED, TIMEOUT_EXPIRED,
    GRAB_BROKEN, ERROR

type
  SizeGroupMode* {.size: sizeof(cint), pure.} = enum
    NONE, HORIZONTAL, VERTICAL,
    BOTH

type
  SizeRequestMode* {.size: sizeof(cint), pure.} = enum
    HEIGHT_FOR_WIDTH = 0, WIDTH_FOR_HEIGHT,
    CONSTANT_SIZE

type
  ScrollablePolicy* {.size: sizeof(cint), pure.} = enum
    SCROLL_MINIMUM = 0, SCROLL_NATURAL

type
  StateFlags* {.size: sizeof(cint), pure.} = enum
    FLAG_NORMAL = 0, FLAG_ACTIVE = 1 shl 0,
    FLAG_PRELIGHT = 1 shl 1, FLAG_SELECTED = 1 shl 2,
    FLAG_INSENSITIVE = 1 shl 3, FLAG_INCONSISTENT = 1 shl 4,
    FLAG_FOCUSED = 1 shl 5, FLAG_BACKDROP = 1 shl 6,
    FLAG_DIR_LTR = 1 shl 7, FLAG_DIR_RTL = 1 shl 8,
    FLAG_LINK = 1 shl 9, FLAG_VISITED = 1 shl 10,
    FLAG_CHECKED = 1 shl 11, FLAG_DROP_ACTIVE = 1 shl 12

type
  RegionFlags* {.size: sizeof(cint), pure.} = enum
    EVEN = 1 shl 0, ODD = 1 shl 1, FIRST = 1 shl 2,
    LAST = 1 shl 3, ONLY = 1 shl 4, SORTED = 1 shl 5

type
  JunctionSides* {.size: sizeof(cint), pure.} = enum
    NONE = 0,
    CORNER_TOPLEFT = 1 shl 0,
    CORNER_TOPRIGHT = 1 shl 1,
    TOP = (JunctionSides.CORNER_TOPLEFT.ord or JunctionSides.CORNER_TOPRIGHT.ord),
    CORNER_BOTTOMLEFT = 1 shl 2,
    LEFT = (JunctionSides.CORNER_TOPLEFT.ord or JunctionSides.CORNER_BOTTOMLEFT.ord),
    CORNER_BOTTOMRIGHT = 1 shl 3,
    RIGHT = (JunctionSides.CORNER_TOPRIGHT.ord or JunctionSides.CORNER_BOTTOMRIGHT.ord),
    BOTTOM = (JunctionSides.CORNER_BOTTOMLEFT.ord or JunctionSides.CORNER_BOTTOMRIGHT.ord)

type
  BorderStyle* {.size: sizeof(cint), pure.} = enum
    NONE, SOLID, INSET,
    OUTSET, HIDDEN, DOTTED,
    DASHED, DOUBLE, GROOVE,
    RIDGE

type
  LevelBarMode* {.size: sizeof(cint), pure.} = enum
    CONTINUOUS, DISCRETE

type
  InputPurpose* {.size: sizeof(cint), pure.} = enum
    FREE_FORM, ALPHA,
    DIGITS, NUMBER, PHONE,
    URL, EMAIL, NAME,
    PASSWORD, PIN

type
  InputHints* {.size: sizeof(cint), pure.} = enum
    NONE = 0, SPELLCHECK = 1 shl 0,
    NO_SPELLCHECK = 1 shl 1, WORD_COMPLETION = 1 shl 2,
    LOWERCASE = 1 shl 3, UPPERCASE_CHARS = 1 shl 4,
    UPPERCASE_WORDS = 1 shl 5,
    UPPERCASE_SENTENCES = 1 shl 6,
    INHIBIT_OSK = 1 shl 7, VERTICAL_WRITING = 1 shl 8

type
  PropagationPhase* {.size: sizeof(cint), pure.} = enum
    NONE, CAPTURE, BUBBLE, TARGET

type
  EventSequenceState* {.size: sizeof(cint), pure.} = enum
    NONE, CLAIMED, DENIED

type
  PanDirection* {.size: sizeof(cint), pure.} = enum
    LEFT, RIGHT, UP,
    DOWN

type
  PopoverConstraint* {.size: sizeof(cint), pure.} = enum
    NONE, WINDOW

type
  AccelGroup* =  ptr AccelGroupObj
  AccelGroupPtr* = ptr AccelGroupObj
  AccelGroupObj*{.final.} = object of GObjectObj
    priv1: pointer

  AccelGroupClass* =  ptr AccelGroupClassObj
  AccelGroupClassPtr* = ptr AccelGroupClassObj
  AccelGroupClassObj*{.final.} = object of GObjectClassObj
    accelChanged*: proc (accelGroup: AccelGroup; keyval: cuint;
                       modifier: gdk3.ModifierType; accelClosure: gobject.GClosure) {.cdecl.}
    gtkReserved11*: proc () {.cdecl.}
    gtkReserved12*: proc () {.cdecl.}
    gtkReserved13*: proc () {.cdecl.}
    gtkReserved14*: proc () {.cdecl.}

template typeAccelGroup*(): expr =
  (accelGroupGetType())

template accelGroup*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeAccelGroup, AccelGroupObj))

template accelGroupClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAccelGroup, AccelGroupClassObj))

template isAccelGroup*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeAccelGroup))

template isAccelGroupClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAccelGroup))

template accelGroupGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAccelGroup, AccelGroupClassObj))

type
  AccelFlags* {.size: sizeof(cint), pure.} = enum
    VISIBLE = 1 shl 0, LOCKED = 1 shl 1, MASK = 0x7

type
  AccelKey* =  ptr AccelKeyObj
  AccelKeyPtr* = ptr AccelKeyObj
  AccelKeyObj* = object
    accelKey*: cuint
    accelMods*: gdk3.ModifierType
    accelFlags* {.bitsize: 16.}: cuint

type
  AccelGroupActivate* = proc (accelGroup: AccelGroup;
                              acceleratable: GObject; keyval: cuint;
                              modifier: gdk3.ModifierType): Gboolean {.cdecl.}

type
  AccelGroupFindFunc* = proc (key: AccelKey; closure: gobject.GClosure;
                              data: Gpointer): Gboolean {.cdecl.}

type
  AccelGroupEntry* =  ptr AccelGroupEntryObj
  AccelGroupEntryPtr* = ptr AccelGroupEntryObj
  AccelGroupEntryObj* = object
    key*: AccelKeyObj
    closure*: gobject.GClosure
    accelPathQuark*: GQuark

  Activatable* =  ptr ActivatableObj
  ActivatablePtr* = ptr ActivatableObj
  ActivatableObj* = object

proc accelGroupGetType*(): GType {.importc: "gtk_accel_group_get_type",
                                   libgtk.}
proc newAccelGroup*(): AccelGroup {.importc: "gtk_accel_group_new",
    libgtk.}
proc getIsLocked*(accelGroup: AccelGroup): Gboolean {.
    importc: "gtk_accel_group_get_is_locked", libgtk.}
proc isLocked*(accelGroup: AccelGroup): Gboolean {.
    importc: "gtk_accel_group_get_is_locked", libgtk.}
proc getModifierMask*(accelGroup: AccelGroup): gdk3.ModifierType {.
    importc: "gtk_accel_group_get_modifier_mask", libgtk.}
proc modifierMask*(accelGroup: AccelGroup): gdk3.ModifierType {.
    importc: "gtk_accel_group_get_modifier_mask", libgtk.}
proc lock*(accelGroup: AccelGroup) {.
    importc: "gtk_accel_group_lock", libgtk.}
proc unlock*(accelGroup: AccelGroup) {.
    importc: "gtk_accel_group_unlock", libgtk.}
proc connect*(accelGroup: AccelGroup; accelKey: cuint;
                          accelMods: gdk3.ModifierType; accelFlags: AccelFlags;
                          closure: gobject.GClosure) {.
    importc: "gtk_accel_group_connect", libgtk.}
proc connectByPath*(accelGroup: AccelGroup; accelPath: cstring;
                                closure: gobject.GClosure) {.
    importc: "gtk_accel_group_connect_by_path", libgtk.}
proc disconnect*(accelGroup: AccelGroup; closure: gobject.GClosure): Gboolean {.
    importc: "gtk_accel_group_disconnect", libgtk.}
proc disconnectKey*(accelGroup: AccelGroup; accelKey: cuint;
                                accelMods: gdk3.ModifierType): Gboolean {.
    importc: "gtk_accel_group_disconnect_key", libgtk.}
proc activate*(accelGroup: AccelGroup; accelQuark: GQuark;
                           acceleratable: GObject; accelKey: cuint;
                           accelMods: gdk3.ModifierType): Gboolean {.
    importc: "gtk_accel_group_activate", libgtk.}

discard """ proc "attach*(accelGroup: AccelGroup; `object`: GObject) {.
    importc: "_gtk_accel_group_attach", libgtk.}"""

discard """ proc "detach*(accelGroup: AccelGroup; `object`: GObject) {.
    importc: "_gtk_accel_group_detach", libgtk.}"""

proc accelGroupsActivate*(`object`: GObject; accelKey: cuint;
                            accelMods: gdk3.ModifierType): Gboolean {.
    importc: "gtk_accel_groups_activate", libgtk.}
proc accelGroupsFromObject*(`object`: GObject): glib.GSList {.
    importc: "gtk_accel_groups_from_object", libgtk.}
proc find*(accelGroup: AccelGroup;
                       findFunc: AccelGroupFindFunc; data: Gpointer): AccelKey {.
    importc: "gtk_accel_group_find", libgtk.}
proc accelGroupFromAccelClosure*(closure: gobject.GClosure): AccelGroup {.
    importc: "gtk_accel_group_from_accel_closure", libgtk.}

proc acceleratorValid*(keyval: cuint; modifiers: gdk3.ModifierType): Gboolean {.
    importc: "gtk_accelerator_valid", libgtk.}
proc acceleratorParse*(accelerator: cstring; acceleratorKey: var cuint;
                         acceleratorMods: ptr gdk3.ModifierType) {.
    importc: "gtk_accelerator_parse", libgtk.}
proc acceleratorParseWithKeycode*(accelerator: cstring;
                                    acceleratorKey: var cuint;
                                    acceleratorCodes: var ptr cuint;
                                    acceleratorMods: ptr gdk3.ModifierType) {.
    importc: "gtk_accelerator_parse_with_keycode", libgtk.}
proc acceleratorName*(acceleratorKey: cuint; acceleratorMods: gdk3.ModifierType): cstring {.
    importc: "gtk_accelerator_name", libgtk.}
proc acceleratorNameWithKeycode*(display: gdk3.Display; acceleratorKey: cuint;
                                   keycode: cuint;
                                   acceleratorMods: gdk3.ModifierType): cstring {.
    importc: "gtk_accelerator_name_with_keycode", libgtk.}
proc acceleratorGetLabel*(acceleratorKey: cuint;
                            acceleratorMods: gdk3.ModifierType): cstring {.
    importc: "gtk_accelerator_get_label", libgtk.}
proc acceleratorGetLabelWithKeycode*(display: gdk3.Display;
                                       acceleratorKey: cuint; keycode: cuint;
                                       acceleratorMods: gdk3.ModifierType): cstring {.
    importc: "gtk_accelerator_get_label_with_keycode", libgtk.}
proc acceleratorSetDefaultModMask*(defaultModMask: gdk3.ModifierType) {.
    importc: "gtk_accelerator_set_default_mod_mask", libgtk.}
proc acceleratorGetDefaultModMask*(): gdk3.ModifierType {.
    importc: "gtk_accelerator_get_default_mod_mask", libgtk.}
proc query*(accelGroup: AccelGroup; accelKey: cuint;
                        accelMods: gdk3.ModifierType; nEntries: var cuint): AccelGroupEntry {.
    importc: "gtk_accel_group_query", libgtk.}

template typeBorder*(): expr =
  (borderGetType())

type
  Border* =  ptr BorderObj
  BorderPtr* = ptr BorderObj
  BorderObj* = object
    left*: int16
    right*: int16
    top*: int16
    bottom*: int16

  Builder* =  ptr BuilderObj
  BuilderPtr* = ptr BuilderObj
  BuilderObj*{.final.} = object of GObjectObj
    priv2: pointer

proc borderGetType*(): GType {.importc: "gtk_border_get_type", libgtk.}
proc newBorder*(): Border {.importc: "gtk_border_new", libgtk.}
proc copy*(border: Border): Border {.
    importc: "gtk_border_copy", libgtk.}
proc free*(border: Border) {.importc: "gtk_border_free", libgtk.}

type
  Clipboard* =  ptr ClipboardObj
  ClipboardPtr* = ptr ClipboardObj
  ClipboardObj* = object

  IconSet* =  ptr IconSetObj
  IconSetPtr* = ptr IconSetObj
  IconSetObj* = object

  IconSource* =  ptr IconSourceObj
  IconSourcePtr* = ptr IconSourceObj
  IconSourceObj* = object

  SelectionData* =  ptr SelectionDataObj
  SelectionDataPtr* = ptr SelectionDataObj
  SelectionDataObj* = object

  Tooltip* =  ptr TooltipObj
  TooltipPtr* = ptr TooltipObj
  TooltipObj* = object

  WidgetPath* =  ptr WidgetPathObj
  WidgetPathPtr* = ptr WidgetPathObj
  WidgetPathObj* = object

  RcPropertyParser* = proc (pspec: gobject.GParamSpec; rcString: glib.GString;
                            propertyValue: gobject.GValue): Gboolean {.cdecl.}
  BuilderConnectFunc* = proc (builder: Builder; `object`: GObject;
                              signalName: cstring; handlerName: cstring;
                              connectObject: GObject; flags: GConnectFlags;
                              userData: Gpointer) {.cdecl.}

type
  WidgetHelpType* {.size: sizeof(cint), pure.} = enum
    TOOLTIP, WHATS_THIS

type
  Widget* =  ptr WidgetObj
  WidgetPtr* = ptr WidgetObj
  WidgetObj = object of gobject.GInitiallyUnownedObj
    priv3: pointer

  IconFactory* =  ptr IconFactoryObj
  IconFactoryPtr* = ptr IconFactoryObj
  IconFactoryObj*{.final.} = object of GObjectObj
    priv4: pointer

type
  RcFlags* {.size: sizeof(cint), pure.} = enum
    FG = 1 shl 0, BG = 1 shl 1, TEXT = 1 shl 2, BASE = 1 shl 3

  RcStyle* =  ptr RcStyleObj
  RcStylePtr* = ptr RcStyleObj
  RcStyleObj*{.final.} = object of GObjectObj
    name*: cstring
    bgPixmapName*: array[5, cstring]
    fontDesc*: pango.FontDescription
    colorFlags*: array[5, RcFlags]
    fg*: array[5, gdk3.ColorObj]
    bg*: array[5, gdk3.ColorObj]
    text*: array[5, gdk3.ColorObj]
    base*: array[5, gdk3.ColorObj]
    xthickness*: cint
    ythickness*: cint
    rcProperties*: glib.GArray
    rcStyleLists*: glib.GSList
    iconFactories*: glib.GSList
    engineSpecified* {.bitsize: 1.}: cuint

  Style* =  ptr StyleObj
  StylePtr* = ptr StyleObj
  StyleObj*{.final.} = object of GObjectObj
    fg*: array[5, gdk3.ColorObj]
    bg*: array[5, gdk3.ColorObj]
    light*: array[5, gdk3.ColorObj]
    dark*: array[5, gdk3.ColorObj]
    mid*: array[5, gdk3.ColorObj]
    text*: array[5, gdk3.ColorObj]
    base*: array[5, gdk3.ColorObj]
    textAa*: array[5, gdk3.ColorObj]
    black*: gdk3.ColorObj
    white*: gdk3.ColorObj
    fontDesc*: pango.FontDescription
    xthickness*: cint
    ythickness*: cint
    background*: array[5, cairo.Pattern]
    attachCount*: cint
    visual*: gdk3.Visual
    privateFontDesc*: pango.FontDescription
    rcStyle*: RcStyle
    styles*: glib.GSList
    propertyCache*: glib.GArray
    iconFactories*: glib.GSList

type
  Allocation* =  ptr AllocationObj
  AllocationPtr* = ptr AllocationObj
  AllocationObj* = gdk3.RectangleObj

  WidgetClass* =  ptr WidgetClassObj
  WidgetClassPtr* = ptr WidgetClassObj
  WidgetClassObj = object of gobject.GInitiallyUnownedClassObj
    activateSignal*: cuint
    dispatchChildPropertiesChanged*: proc (widget: Widget; nPspecs: cuint;
        pspecs: var gobject.GParamSpec) {.cdecl.}
    destroy*: proc (widget: Widget) {.cdecl.}
    show*: proc (widget: Widget) {.cdecl.}
    showAll*: proc (widget: Widget) {.cdecl.}
    hide*: proc (widget: Widget) {.cdecl.}
    map*: proc (widget: Widget) {.cdecl.}
    unmap*: proc (widget: Widget) {.cdecl.}
    realize*: proc (widget: Widget) {.cdecl.}
    unrealize*: proc (widget: Widget) {.cdecl.}
    sizeAllocate*: proc (widget: Widget; allocation: Allocation) {.cdecl.}
    stateChanged*: proc (widget: Widget; previousState: StateType) {.cdecl.}
    stateFlagsChanged*: proc (widget: Widget;
                            previousStateFlags: StateFlags) {.cdecl.}
    parentSet*: proc (widget: Widget; previousParent: Widget) {.cdecl.}
    hierarchyChanged*: proc (widget: Widget; previousToplevel: Widget) {.cdecl.}
    styleSet*: proc (widget: Widget; previousStyle: Style) {.cdecl.}
    directionChanged*: proc (widget: Widget;
                           previousDirection: TextDirection) {.cdecl.}
    grabNotify*: proc (widget: Widget; wasGrabbed: Gboolean) {.cdecl.}
    childNotify*: proc (widget: Widget; childProperty: gobject.GParamSpec) {.cdecl.}
    draw*: proc (widget: Widget; cr: cairo.Context): Gboolean {.cdecl.}
    getRequestMode*: proc (widget: Widget): SizeRequestMode {.cdecl.}
    getPreferredHeight*: proc (widget: Widget; minimumHeight: var cint;
                             naturalHeight: var cint) {.cdecl.}
    getPreferredWidthForHeight*: proc (widget: Widget; height: cint;
                                     minimumWidth: var cint; naturalWidth: var cint) {.cdecl.}
    getPreferredWidth*: proc (widget: Widget; minimumWidth: var cint;
                            naturalWidth: var cint) {.cdecl.}
    getPreferredHeightForWidth*: proc (widget: Widget; width: cint;
                                     minimumHeight: var cint;
                                     naturalHeight: var cint) {.cdecl.}
    mnemonicActivate*: proc (widget: Widget; groupCycling: Gboolean): Gboolean {.cdecl.}
    grabFocus*: proc (widget: Widget) {.cdecl.}
    focus*: proc (widget: Widget; direction: DirectionType): Gboolean {.cdecl.}
    moveFocus*: proc (widget: Widget; direction: DirectionType) {.cdecl.}
    keynavFailed*: proc (widget: Widget; direction: DirectionType): Gboolean {.cdecl.}
    event*: proc (widget: Widget; event: gdk3.Event): Gboolean {.cdecl.}
    buttonPressEvent*: proc (widget: Widget; event: gdk3.EventButton): Gboolean {.cdecl.}
    buttonReleaseEvent*: proc (widget: Widget; event: gdk3.EventButton): Gboolean {.cdecl.}
    scrollEvent*: proc (widget: Widget; event: gdk3.EventScroll): Gboolean {.cdecl.}
    motionNotifyEvent*: proc (widget: Widget; event: gdk3.EventMotion): Gboolean {.cdecl.}
    deleteEvent*: proc (widget: Widget; event: gdk3.EventAny): Gboolean {.cdecl.}
    destroyEvent*: proc (widget: Widget; event: gdk3.EventAny): Gboolean {.cdecl.}
    keyPressEvent*: proc (widget: Widget; event: gdk3.EventKey): Gboolean {.cdecl.}
    keyReleaseEvent*: proc (widget: Widget; event: gdk3.EventKey): Gboolean {.cdecl.}
    enterNotifyEvent*: proc (widget: Widget; event: gdk3.EventCrossing): Gboolean {.cdecl.}
    leaveNotifyEvent*: proc (widget: Widget; event: gdk3.EventCrossing): Gboolean {.cdecl.}
    configureEvent*: proc (widget: Widget; event: gdk3.EventConfigure): Gboolean {.cdecl.}
    focusInEvent*: proc (widget: Widget; event: gdk3.EventFocus): Gboolean {.cdecl.}
    focusOutEvent*: proc (widget: Widget; event: gdk3.EventFocus): Gboolean {.cdecl.}
    mapEvent*: proc (widget: Widget; event: gdk3.EventAny): Gboolean {.cdecl.}
    unmapEvent*: proc (widget: Widget; event: gdk3.EventAny): Gboolean {.cdecl.}
    propertyNotifyEvent*: proc (widget: Widget; event: gdk3.EventProperty): Gboolean {.cdecl.}
    selectionClearEvent*: proc (widget: Widget; event: gdk3.EventSelection): Gboolean {.cdecl.}
    selectionRequestEvent*: proc (widget: Widget; event: gdk3.EventSelection): Gboolean {.cdecl.}
    selectionNotifyEvent*: proc (widget: Widget; event: gdk3.EventSelection): Gboolean {.cdecl.}
    proximityInEvent*: proc (widget: Widget; event: gdk3.EventProximity): Gboolean {.cdecl.}
    proximityOutEvent*: proc (widget: Widget; event: gdk3.EventProximity): Gboolean {.cdecl.}
    visibilityNotifyEvent*: proc (widget: Widget;
                                event: gdk3.EventVisibility): Gboolean {.cdecl.}
    windowStateEvent*: proc (widget: Widget; event: gdk3.EventWindowState): Gboolean {.cdecl.}
    damageEvent*: proc (widget: Widget; event: gdk3.EventExpose): Gboolean {.cdecl.}
    grabBrokenEvent*: proc (widget: Widget; event: gdk3.EventGrabBroken): Gboolean {.cdecl.}
    selectionGet*: proc (widget: Widget; selectionData: SelectionData;
                       info: cuint; time: cuint) {.cdecl.}
    selectionReceived*: proc (widget: Widget;
                            selectionData: SelectionData; time: cuint) {.cdecl.}
    dragBegin*: proc (widget: Widget; context: gdk3.DragContext) {.cdecl.}
    dragEnd*: proc (widget: Widget; context: gdk3.DragContext) {.cdecl.}
    dragDataGet*: proc (widget: Widget; context: gdk3.DragContext;
                      selectionData: SelectionData; info: cuint; time: cuint) {.cdecl.}
    dragDataDelete*: proc (widget: Widget; context: gdk3.DragContext) {.cdecl.}
    dragLeave*: proc (widget: Widget; context: gdk3.DragContext; time: cuint) {.cdecl.}
    dragMotion*: proc (widget: Widget; context: gdk3.DragContext; x: cint;
                     y: cint; time: cuint): Gboolean {.cdecl.}
    dragDrop*: proc (widget: Widget; context: gdk3.DragContext; x: cint; y: cint;
                   time: cuint): Gboolean {.cdecl.}
    dragDataReceived*: proc (widget: Widget; context: gdk3.DragContext;
                           x: cint; y: cint; selectionData: SelectionData;
                           info: cuint; time: cuint) {.cdecl.}
    dragFailed*: proc (widget: Widget; context: gdk3.DragContext;
                     result: DragResult): Gboolean {.cdecl.}
    popupMenu*: proc (widget: Widget): Gboolean {.cdecl.}
    showHelp*: proc (widget: Widget; helpType: WidgetHelpType): Gboolean {.cdecl.}
    getAccessible*: proc (widget: Widget): atk.Object {.cdecl.}
    screenChanged*: proc (widget: Widget; previousScreen: gdk3.Screen) {.cdecl.}
    canActivateAccel*: proc (widget: Widget; signalId: cuint): Gboolean {.cdecl.}
    compositedChanged*: proc (widget: Widget) {.cdecl.}
    queryTooltip*: proc (widget: Widget; x: cint; y: cint;
                       keyboardTooltip: Gboolean; tooltip: Tooltip): Gboolean {.cdecl.}
    computeExpand*: proc (widget: Widget; hexpandP: ptr Gboolean;
                        vexpandP: var Gboolean) {.cdecl.}
    adjustSizeRequest*: proc (widget: Widget; orientation: Orientation;
                            minimumSize: var cint; naturalSize: var cint) {.cdecl.}
    adjustSizeAllocation*: proc (widget: Widget; orientation: Orientation;
                               minimumSize: var cint; naturalSize: var cint;
                               allocatedPos: var cint; allocatedSize: var cint) {.cdecl.}
    styleUpdated*: proc (widget: Widget) {.cdecl.}
    touchEvent*: proc (widget: Widget; event: gdk3.EventTouch): Gboolean {.cdecl.}
    getPreferredHeightAndBaselineForWidth*: proc (widget: Widget; width: cint;
        minimumHeight: var cint; naturalHeight: var cint; minimumBaseline: var cint;
        naturalBaseline: var cint) {.cdecl.}
    adjustBaselineRequest*: proc (widget: Widget; minimumBaseline: var cint;
                                naturalBaseline: var cint) {.cdecl.}
    adjustBaselineAllocation*: proc (widget: Widget; baseline: var cint) {.cdecl.}
    queueDrawRegion*: proc (widget: Widget; region: cairo.Region) {.cdecl.}
    priv5: pointer
    gtkReserved26*: proc () {.cdecl.}
    gtkReserved27*: proc () {.cdecl.}

template typeWidget*(): expr =
  (widgetGetType())

template widget*(widget: expr): expr =
  (gTypeCheckInstanceCast(widget, typeWidget, WidgetObj))

template widgetClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeWidget, WidgetClassObj))

template isWidget*(widget: expr): expr =
  (gTypeCheckInstanceType(widget, typeWidget))

template isWidgetClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeWidget))

template widgetGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeWidget, WidgetClassObj))

template typeRequisition*(): expr =
  (requisitionGetType())

type
  Callback* = proc (widget: Widget; data: Gpointer) {.cdecl.}

type
  TickCallback* = proc (widget: Widget; frameClock: gdk3.FrameClock;
                        userData: Gpointer): Gboolean {.cdecl.}

type
  Requisition* =  ptr RequisitionObj
  RequisitionPtr* = ptr RequisitionObj
  RequisitionObj* = object
    width*: cint
    height*: cint

type
  Application* =  ptr ApplicationObj
  ApplicationPtr* = ptr ApplicationObj
  ApplicationObj* = object of gio.GApplicationObj
    priv6: pointer

  Container* =  ptr ContainerObj
  ContainerPtr* = ptr ContainerObj
  ContainerObj* = object of WidgetObj
    priv7: pointer

  Bin* =  ptr BinObj
  BinPtr* = ptr BinObj
  BinObj* = object of ContainerObj
    priv8: pointer

  Window* =  ptr WindowObj
  WindowPtr* = ptr WindowObj
  WindowObj* = object of BinObj
    priv9: pointer

  ApplicationClass* =  ptr ApplicationClassObj
  ApplicationClassPtr* = ptr ApplicationClassObj
  ApplicationClassObj* = object of gio.GApplicationClassObj
    windowAdded*: proc (application: Application; window: Window) {.cdecl.}
    windowRemoved*: proc (application: Application; window: Window) {.cdecl.}
    padding0: array[12, Gpointer]

  StyleContext* =  ptr StyleContextObj
  StyleContextPtr* = ptr StyleContextObj
  StyleContextObj*{.final.} = object of GObjectObj
    priv10: pointer

  Settings* =  ptr SettingsObj
  SettingsPtr* = ptr SettingsObj
  SettingsObj*{.final.} = object of GObjectObj
    priv11: pointer

proc widgetGetType*(): GType {.importc: "gtk_widget_get_type", libgtk.}
proc newWidget*(`type`: GType; firstPropertyName: cstring): Widget {.varargs,
    importc: "gtk_widget_new", libgtk.}
proc destroy*(widget: Widget) {.importc: "gtk_widget_destroy",
    libgtk.}
proc destroyed*(widget: Widget; widgetPointer: var Widget) {.
    importc: "gtk_widget_destroyed", libgtk.}
proc unparent*(widget: Widget) {.importc: "gtk_widget_unparent",
    libgtk.}
proc show*(widget: Widget) {.importc: "gtk_widget_show", libgtk.}
proc hide*(widget: Widget) {.importc: "gtk_widget_hide", libgtk.}
proc showNow*(widget: Widget) {.importc: "gtk_widget_show_now",
    libgtk.}
proc showAll*(widget: Widget) {.importc: "gtk_widget_show_all",
    libgtk.}
proc setNoShowAll*(widget: Widget; noShowAll: Gboolean) {.
    importc: "gtk_widget_set_no_show_all", libgtk.}
proc `noShowAll=`*(widget: Widget; noShowAll: Gboolean) {.
    importc: "gtk_widget_set_no_show_all", libgtk.}
proc getNoShowAll*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_no_show_all", libgtk.}
proc noShowAll*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_no_show_all", libgtk.}
proc map*(widget: Widget) {.importc: "gtk_widget_map", libgtk.}
proc unmap*(widget: Widget) {.importc: "gtk_widget_unmap", libgtk.}
proc realize*(widget: Widget) {.importc: "gtk_widget_realize",
    libgtk.}
proc unrealize*(widget: Widget) {.importc: "gtk_widget_unrealize",
    libgtk.}
proc draw*(widget: Widget; cr: cairo.Context) {.
    importc: "gtk_widget_draw", libgtk.}

proc queueDraw*(widget: Widget) {.importc: "gtk_widget_queue_draw",
    libgtk.}
proc queueDrawArea*(widget: Widget; x: cint; y: cint; width: cint;
                            height: cint) {.importc: "gtk_widget_queue_draw_area",
    libgtk.}
proc queueDrawRegion*(widget: Widget; region: cairo.Region) {.
    importc: "gtk_widget_queue_draw_region", libgtk.}
proc queueResize*(widget: Widget) {.
    importc: "gtk_widget_queue_resize", libgtk.}
proc queueResizeNoRedraw*(widget: Widget) {.
    importc: "gtk_widget_queue_resize_no_redraw", libgtk.}
proc queueAllocate*(widget: Widget) {.
    importc: "gtk_widget_queue_allocate", libgtk.}
proc getFrameClock*(widget: Widget): gdk3.FrameClock {.
    importc: "gtk_widget_get_frame_clock", libgtk.}
proc frameClock*(widget: Widget): gdk3.FrameClock {.
    importc: "gtk_widget_get_frame_clock", libgtk.}
proc sizeRequest*(widget: Widget; requisition: Requisition) {.
    importc: "gtk_widget_size_request", libgtk.}
proc sizeAllocate*(widget: Widget; allocation: Allocation) {.
    importc: "gtk_widget_size_allocate", libgtk.}
proc sizeAllocateWithBaseline*(widget: Widget;
                                       allocation: Allocation;
                                       baseline: cint) {.
    importc: "gtk_widget_size_allocate_with_baseline", libgtk.}
proc getRequestMode*(widget: Widget): SizeRequestMode {.
    importc: "gtk_widget_get_request_mode", libgtk.}
proc requestMode*(widget: Widget): SizeRequestMode {.
    importc: "gtk_widget_get_request_mode", libgtk.}
proc getPreferredWidth*(widget: Widget; minimumWidth: var cint;
                                naturalWidth: var cint) {.
    importc: "gtk_widget_get_preferred_width", libgtk.}
proc getPreferredHeightForWidth*(widget: Widget; width: cint;
    minimumHeight: var cint; naturalHeight: var cint) {.
    importc: "gtk_widget_get_preferred_height_for_width", libgtk.}
proc getPreferredHeight*(widget: Widget; minimumHeight: var cint;
                                 naturalHeight: var cint) {.
    importc: "gtk_widget_get_preferred_height", libgtk.}
proc getPreferredWidthForHeight*(widget: Widget; height: cint;
    minimumWidth: var cint; naturalWidth: var cint) {.
    importc: "gtk_widget_get_preferred_width_for_height", libgtk.}
proc getPreferredHeightAndBaselineForWidth*(widget: Widget;
    width: cint; minimumHeight: var cint; naturalHeight: var cint;
    minimumBaseline: var cint; naturalBaseline: var cint) {.
    importc: "gtk_widget_get_preferred_height_and_baseline_for_width", libgtk.}
proc getPreferredSize*(widget: Widget;
                               minimumSize: Requisition;
                               naturalSize: Requisition) {.
    importc: "gtk_widget_get_preferred_size", libgtk.}
proc getChildRequisition*(widget: Widget;
                                  requisition: Requisition) {.
    importc: "gtk_widget_get_child_requisition", libgtk.}
proc addAccelerator*(widget: Widget; accelSignal: cstring;
                             accelGroup: AccelGroup; accelKey: cuint;
                             accelMods: gdk3.ModifierType; accelFlags: AccelFlags) {.
    importc: "gtk_widget_add_accelerator", libgtk.}
proc removeAccelerator*(widget: Widget;
                                accelGroup: AccelGroup; accelKey: cuint;
                                accelMods: gdk3.ModifierType): Gboolean {.
    importc: "gtk_widget_remove_accelerator", libgtk.}
proc setAccelPath*(widget: Widget; accelPath: cstring;
                           accelGroup: AccelGroup) {.
    importc: "gtk_widget_set_accel_path", libgtk.}
proc `accelPath=`*(widget: Widget; accelPath: cstring;
                           accelGroup: AccelGroup) {.
    importc: "gtk_widget_set_accel_path", libgtk.}
proc listAccelClosures*(widget: Widget): glib.GList {.
    importc: "gtk_widget_list_accel_closures", libgtk.}
proc canActivateAccel*(widget: Widget; signalId: cuint): Gboolean {.
    importc: "gtk_widget_can_activate_accel", libgtk.}
proc mnemonicActivate*(widget: Widget; groupCycling: Gboolean): Gboolean {.
    importc: "gtk_widget_mnemonic_activate", libgtk.}
proc event*(widget: Widget; event: gdk3.Event): Gboolean {.
    importc: "gtk_widget_event", libgtk.}
proc sendExpose*(widget: Widget; event: gdk3.Event): cint {.
    importc: "gtk_widget_send_expose", libgtk.}
proc sendFocusChange*(widget: Widget; event: gdk3.Event): Gboolean {.
    importc: "gtk_widget_send_focus_change", libgtk.}
proc activate*(widget: Widget): Gboolean {.
    importc: "gtk_widget_activate", libgtk.}
proc reparent*(widget: Widget; newParent: Widget) {.
    importc: "gtk_widget_reparent", libgtk.}
proc intersect*(widget: Widget; area: gdk3.Rectangle;
                        intersection: gdk3.Rectangle): Gboolean {.
    importc: "gtk_widget_intersect", libgtk.}
proc regionIntersect*(widget: Widget; region: cairo.Region): cairo.Region {.
    importc: "gtk_widget_region_intersect", libgtk.}
proc freezeChildNotify*(widget: Widget) {.
    importc: "gtk_widget_freeze_child_notify", libgtk.}
proc childNotify*(widget: Widget; childProperty: cstring) {.
    importc: "gtk_widget_child_notify", libgtk.}
proc thawChildNotify*(widget: Widget) {.
    importc: "gtk_widget_thaw_child_notify", libgtk.}
proc setCanFocus*(widget: Widget; canFocus: Gboolean) {.
    importc: "gtk_widget_set_can_focus", libgtk.}
proc `canFocus=`*(widget: Widget; canFocus: Gboolean) {.
    importc: "gtk_widget_set_can_focus", libgtk.}
proc getCanFocus*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_can_focus", libgtk.}
proc canFocus*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_can_focus", libgtk.}
proc hasFocus*(widget: Widget): Gboolean {.
    importc: "gtk_widget_has_focus", libgtk.}
proc isFocus*(widget: Widget): Gboolean {.
    importc: "gtk_widget_is_focus", libgtk.}
proc hasVisibleFocus*(widget: Widget): Gboolean {.
    importc: "gtk_widget_has_visible_focus", libgtk.}
proc grabFocus*(widget: Widget) {.importc: "gtk_widget_grab_focus",
    libgtk.}
proc setFocusOnClick*(widget: Widget; focusOnClick: Gboolean) {.
    importc: "gtk_widget_set_focus_on_click", libgtk.}
proc `focusOnClick=`*(widget: Widget; focusOnClick: Gboolean) {.
    importc: "gtk_widget_set_focus_on_click", libgtk.}
proc getFocusOnClick*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_focus_on_click", libgtk.}
proc focusOnClick*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_focus_on_click", libgtk.}
proc setCanDefault*(widget: Widget; canDefault: Gboolean) {.
    importc: "gtk_widget_set_can_default", libgtk.}
proc `canDefault=`*(widget: Widget; canDefault: Gboolean) {.
    importc: "gtk_widget_set_can_default", libgtk.}
proc getCanDefault*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_can_default", libgtk.}
proc canDefault*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_can_default", libgtk.}
proc hasDefault*(widget: Widget): Gboolean {.
    importc: "gtk_widget_has_default", libgtk.}
proc grabDefault*(widget: Widget) {.
    importc: "gtk_widget_grab_default", libgtk.}
proc setReceivesDefault*(widget: Widget; receivesDefault: Gboolean) {.
    importc: "gtk_widget_set_receives_default", libgtk.}
proc `receivesDefault=`*(widget: Widget; receivesDefault: Gboolean) {.
    importc: "gtk_widget_set_receives_default", libgtk.}
proc getReceivesDefault*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_receives_default", libgtk.}
proc receivesDefault*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_receives_default", libgtk.}
proc hasGrab*(widget: Widget): Gboolean {.
    importc: "gtk_widget_has_grab", libgtk.}
proc deviceIsShadowed*(widget: Widget; device: gdk3.Device): Gboolean {.
    importc: "gtk_widget_device_is_shadowed", libgtk.}
proc setName*(widget: Widget; name: cstring) {.
    importc: "gtk_widget_set_name", libgtk.}
proc `name=`*(widget: Widget; name: cstring) {.
    importc: "gtk_widget_set_name", libgtk.}
proc getName*(widget: Widget): cstring {.
    importc: "gtk_widget_get_name", libgtk.}
proc name*(widget: Widget): cstring {.
    importc: "gtk_widget_get_name", libgtk.}
proc setState*(widget: Widget; state: StateType) {.
    importc: "gtk_widget_set_state", libgtk.}
proc `state=`*(widget: Widget; state: StateType) {.
    importc: "gtk_widget_set_state", libgtk.}
proc getState*(widget: Widget): StateType {.
    importc: "gtk_widget_get_state", libgtk.}
proc state*(widget: Widget): StateType {.
    importc: "gtk_widget_get_state", libgtk.}
proc setStateFlags*(widget: Widget; flags: StateFlags;
                            clear: Gboolean) {.
    importc: "gtk_widget_set_state_flags", libgtk.}
proc `stateFlags=`*(widget: Widget; flags: StateFlags;
                            clear: Gboolean) {.
    importc: "gtk_widget_set_state_flags", libgtk.}
proc unsetStateFlags*(widget: Widget; flags: StateFlags) {.
    importc: "gtk_widget_unset_state_flags", libgtk.}
proc getStateFlags*(widget: Widget): StateFlags {.
    importc: "gtk_widget_get_state_flags", libgtk.}
proc stateFlags*(widget: Widget): StateFlags {.
    importc: "gtk_widget_get_state_flags", libgtk.}
proc setSensitive*(widget: Widget; sensitive: Gboolean) {.
    importc: "gtk_widget_set_sensitive", libgtk.}
proc `sensitive=`*(widget: Widget; sensitive: Gboolean) {.
    importc: "gtk_widget_set_sensitive", libgtk.}
proc getSensitive*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_sensitive", libgtk.}
proc sensitive*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_sensitive", libgtk.}
proc isSensitive*(widget: Widget): Gboolean {.
    importc: "gtk_widget_is_sensitive", libgtk.}
proc setVisible*(widget: Widget; visible: Gboolean) {.
    importc: "gtk_widget_set_visible", libgtk.}
proc `visible=`*(widget: Widget; visible: Gboolean) {.
    importc: "gtk_widget_set_visible", libgtk.}
proc getVisible*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_visible", libgtk.}
proc visible*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_visible", libgtk.}
proc isVisible*(widget: Widget): Gboolean {.
    importc: "gtk_widget_is_visible", libgtk.}
proc setHasWindow*(widget: Widget; hasWindow: Gboolean) {.
    importc: "gtk_widget_set_has_window", libgtk.}
proc `hasWindow=`*(widget: Widget; hasWindow: Gboolean) {.
    importc: "gtk_widget_set_has_window", libgtk.}
proc getHasWindow*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_has_window", libgtk.}
proc hasWindow*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_has_window", libgtk.}
proc isToplevel*(widget: Widget): Gboolean {.
    importc: "gtk_widget_is_toplevel", libgtk.}
proc isDrawable*(widget: Widget): Gboolean {.
    importc: "gtk_widget_is_drawable", libgtk.}
proc setRealized*(widget: Widget; realized: Gboolean) {.
    importc: "gtk_widget_set_realized", libgtk.}
proc `realized=`*(widget: Widget; realized: Gboolean) {.
    importc: "gtk_widget_set_realized", libgtk.}
proc getRealized*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_realized", libgtk.}
proc realized*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_realized", libgtk.}
proc setMapped*(widget: Widget; mapped: Gboolean) {.
    importc: "gtk_widget_set_mapped", libgtk.}
proc `mapped=`*(widget: Widget; mapped: Gboolean) {.
    importc: "gtk_widget_set_mapped", libgtk.}
proc getMapped*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_mapped", libgtk.}
proc mapped*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_mapped", libgtk.}
proc setAppPaintable*(widget: Widget; appPaintable: Gboolean) {.
    importc: "gtk_widget_set_app_paintable", libgtk.}
proc `appPaintable=`*(widget: Widget; appPaintable: Gboolean) {.
    importc: "gtk_widget_set_app_paintable", libgtk.}
proc getAppPaintable*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_app_paintable", libgtk.}
proc appPaintable*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_app_paintable", libgtk.}
proc setDoubleBuffered*(widget: Widget; doubleBuffered: Gboolean) {.
    importc: "gtk_widget_set_double_buffered", libgtk.}
proc `doubleBuffered=`*(widget: Widget; doubleBuffered: Gboolean) {.
    importc: "gtk_widget_set_double_buffered", libgtk.}
proc getDoubleBuffered*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_double_buffered", libgtk.}
proc doubleBuffered*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_double_buffered", libgtk.}
proc setRedrawOnAllocate*(widget: Widget; redrawOnAllocate: Gboolean) {.
    importc: "gtk_widget_set_redraw_on_allocate", libgtk.}
proc `redrawOnAllocate=`*(widget: Widget; redrawOnAllocate: Gboolean) {.
    importc: "gtk_widget_set_redraw_on_allocate", libgtk.}
proc setParent*(widget: Widget; parent: Widget) {.
    importc: "gtk_widget_set_parent", libgtk.}
proc `parent=`*(widget: Widget; parent: Widget) {.
    importc: "gtk_widget_set_parent", libgtk.}
proc getParent*(widget: Widget): Widget {.
    importc: "gtk_widget_get_parent", libgtk.}
proc parent*(widget: Widget): Widget {.
    importc: "gtk_widget_get_parent", libgtk.}
proc setParentWindow*(widget: Widget; parentWindow: gdk3.Window) {.
    importc: "gtk_widget_set_parent_window", libgtk.}
proc `parentWindow=`*(widget: Widget; parentWindow: gdk3.Window) {.
    importc: "gtk_widget_set_parent_window", libgtk.}
proc getParentWindow*(widget: Widget): gdk3.Window {.
    importc: "gtk_widget_get_parent_window", libgtk.}
proc parentWindow*(widget: Widget): gdk3.Window {.
    importc: "gtk_widget_get_parent_window", libgtk.}
proc setChildVisible*(widget: Widget; isVisible: Gboolean) {.
    importc: "gtk_widget_set_child_visible", libgtk.}
proc `childVisible=`*(widget: Widget; isVisible: Gboolean) {.
    importc: "gtk_widget_set_child_visible", libgtk.}
proc getChildVisible*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_child_visible", libgtk.}
proc childVisible*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_child_visible", libgtk.}
proc setWindow*(widget: Widget; window: gdk3.Window) {.
    importc: "gtk_widget_set_window", libgtk.}
proc `window=`*(widget: Widget; window: gdk3.Window) {.
    importc: "gtk_widget_set_window", libgtk.}
proc getGdkWindow*(widget: Widget): gdk3.Window {.
    importc: "gtk_widget_get_window", libgtk.}
proc gdkWindow*(widget: Widget): gdk3.Window {.
    importc: "gtk_widget_get_window", libgtk.}
proc registerWindow*(widget: Widget; window: gdk3.Window) {.
    importc: "gtk_widget_register_window", libgtk.}
proc unregisterWindow*(widget: Widget; window: gdk3.Window) {.
    importc: "gtk_widget_unregister_window", libgtk.}
proc getAllocatedWidth*(widget: Widget): cint {.
    importc: "gtk_widget_get_allocated_width", libgtk.}
proc allocatedWidth*(widget: Widget): cint {.
    importc: "gtk_widget_get_allocated_width", libgtk.}
proc getAllocatedHeight*(widget: Widget): cint {.
    importc: "gtk_widget_get_allocated_height", libgtk.}
proc allocatedHeight*(widget: Widget): cint {.
    importc: "gtk_widget_get_allocated_height", libgtk.}
proc getAllocatedBaseline*(widget: Widget): cint {.
    importc: "gtk_widget_get_allocated_baseline", libgtk.}
proc allocatedBaseline*(widget: Widget): cint {.
    importc: "gtk_widget_get_allocated_baseline", libgtk.}
proc getAllocatedSize*(widget: Widget;
                               allocation: Allocation; baseline: var cint) {.
    importc: "gtk_widget_get_allocated_size", libgtk.}
proc getAllocation*(widget: Widget; allocation: var AllocationObj) {.
    importc: "gtk_widget_get_allocation", libgtk.}
proc setAllocation*(widget: Widget; allocation: Allocation) {.
    importc: "gtk_widget_set_allocation", libgtk.}
proc `allocation=`*(widget: Widget; allocation: Allocation) {.
    importc: "gtk_widget_set_allocation", libgtk.}
proc setClip*(widget: Widget; clip: Allocation) {.
    importc: "gtk_widget_set_clip", libgtk.}
proc `clip=`*(widget: Widget; clip: Allocation) {.
    importc: "gtk_widget_set_clip", libgtk.}
proc getClip*(widget: Widget; clip: var AllocationObj) {.
    importc: "gtk_widget_get_clip", libgtk.}
proc getRequisition*(widget: Widget; requisition: var RequisitionObj) {.
    importc: "gtk_widget_get_requisition", libgtk.}
proc childFocus*(widget: Widget; direction: DirectionType): Gboolean {.
    importc: "gtk_widget_child_focus", libgtk.}
proc keynavFailed*(widget: Widget; direction: DirectionType): Gboolean {.
    importc: "gtk_widget_keynav_failed", libgtk.}
proc errorBell*(widget: Widget) {.importc: "gtk_widget_error_bell",
    libgtk.}
proc setSizeRequest*(widget: Widget; width: cint; height: cint) {.
    importc: "gtk_widget_set_size_request", libgtk.}
proc `sizeRequest=`*(widget: Widget; width: cint; height: cint) {.
    importc: "gtk_widget_set_size_request", libgtk.}
proc getSizeRequest*(widget: Widget; width: var cint; height: var cint) {.
    importc: "gtk_widget_get_size_request", libgtk.}
proc setEvents*(widget: Widget; events: cint) {.
    importc: "gtk_widget_set_events", libgtk.}
proc `events=`*(widget: Widget; events: cint) {.
    importc: "gtk_widget_set_events", libgtk.}
proc addEvents*(widget: Widget; events: cint) {.
    importc: "gtk_widget_add_events", libgtk.}
proc setDeviceEvents*(widget: Widget; device: gdk3.Device;
                              events: gdk3.EventMask) {.
    importc: "gtk_widget_set_device_events", libgtk.}
proc `deviceEvents=`*(widget: Widget; device: gdk3.Device;
                              events: gdk3.EventMask) {.
    importc: "gtk_widget_set_device_events", libgtk.}
proc addDeviceEvents*(widget: Widget; device: gdk3.Device;
                              events: gdk3.EventMask) {.
    importc: "gtk_widget_add_device_events", libgtk.}
proc setOpacity*(widget: Widget; opacity: cdouble) {.
    importc: "gtk_widget_set_opacity", libgtk.}
proc `opacity=`*(widget: Widget; opacity: cdouble) {.
    importc: "gtk_widget_set_opacity", libgtk.}
proc getOpacity*(widget: Widget): cdouble {.
    importc: "gtk_widget_get_opacity", libgtk.}
proc opacity*(widget: Widget): cdouble {.
    importc: "gtk_widget_get_opacity", libgtk.}
proc setDeviceEnabled*(widget: Widget; device: gdk3.Device;
                               enabled: Gboolean) {.
    importc: "gtk_widget_set_device_enabled", libgtk.}
proc `deviceEnabled=`*(widget: Widget; device: gdk3.Device;
                               enabled: Gboolean) {.
    importc: "gtk_widget_set_device_enabled", libgtk.}
proc getDeviceEnabled*(widget: Widget; device: gdk3.Device): Gboolean {.
    importc: "gtk_widget_get_device_enabled", libgtk.}
proc deviceEnabled*(widget: Widget; device: gdk3.Device): Gboolean {.
    importc: "gtk_widget_get_device_enabled", libgtk.}
proc getToplevel*(widget: Widget): Widget {.
    importc: "gtk_widget_get_toplevel", libgtk.}
proc toplevel*(widget: Widget): Widget {.
    importc: "gtk_widget_get_toplevel", libgtk.}
proc getAncestor*(widget: Widget; widgetType: GType): Widget {.
    importc: "gtk_widget_get_ancestor", libgtk.}
proc ancestor*(widget: Widget; widgetType: GType): Widget {.
    importc: "gtk_widget_get_ancestor", libgtk.}
proc getVisual*(widget: Widget): gdk3.Visual {.
    importc: "gtk_widget_get_visual", libgtk.}
proc visual*(widget: Widget): gdk3.Visual {.
    importc: "gtk_widget_get_visual", libgtk.}
proc setVisual*(widget: Widget; visual: gdk3.Visual) {.
    importc: "gtk_widget_set_visual", libgtk.}
proc `visual=`*(widget: Widget; visual: gdk3.Visual) {.
    importc: "gtk_widget_set_visual", libgtk.}
proc getScreen*(widget: Widget): gdk3.Screen {.
    importc: "gtk_widget_get_screen", libgtk.}
proc screen*(widget: Widget): gdk3.Screen {.
    importc: "gtk_widget_get_screen", libgtk.}
proc hasScreen*(widget: Widget): Gboolean {.
    importc: "gtk_widget_has_screen", libgtk.}
proc getScaleFactor*(widget: Widget): cint {.
    importc: "gtk_widget_get_scale_factor", libgtk.}
proc scaleFactor*(widget: Widget): cint {.
    importc: "gtk_widget_get_scale_factor", libgtk.}
proc getDisplay*(widget: Widget): gdk3.Display {.
    importc: "gtk_widget_get_display", libgtk.}
proc display*(widget: Widget): gdk3.Display {.
    importc: "gtk_widget_get_display", libgtk.}
proc getRootWindow*(widget: Widget): gdk3.Window {.
    importc: "gtk_widget_get_root_window", libgtk.}
proc rootWindow*(widget: Widget): gdk3.Window {.
    importc: "gtk_widget_get_root_window", libgtk.}
proc getSettings*(widget: Widget): Settings {.
    importc: "gtk_widget_get_settings", libgtk.}
proc settings*(widget: Widget): Settings {.
    importc: "gtk_widget_get_settings", libgtk.}
proc getClipboard*(widget: Widget; selection: gdk3.Atom): Clipboard {.
    importc: "gtk_widget_get_clipboard", libgtk.}
proc clipboard*(widget: Widget; selection: gdk3.Atom): Clipboard {.
    importc: "gtk_widget_get_clipboard", libgtk.}

proc getHexpand*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_hexpand", libgtk.}

proc hexpand*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_hexpand", libgtk.}
proc setHexpand*(widget: Widget; expand: Gboolean) {.
    importc: "gtk_widget_set_hexpand", libgtk.}
proc `hexpand=`*(widget: Widget; expand: Gboolean) {.
    importc: "gtk_widget_set_hexpand", libgtk.}
proc getHexpandSet*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_hexpand_set", libgtk.}
proc hexpandSet*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_hexpand_set", libgtk.}
proc setHexpandSet*(widget: Widget; set: Gboolean) {.
    importc: "gtk_widget_set_hexpand_set", libgtk.}
proc `hexpandSet=`*(widget: Widget; set: Gboolean) {.
    importc: "gtk_widget_set_hexpand_set", libgtk.}
proc getVexpand*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_vexpand", libgtk.}
proc vexpand*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_vexpand", libgtk.}
proc setVexpand*(widget: Widget; expand: Gboolean) {.
    importc: "gtk_widget_set_vexpand", libgtk.}
proc `vexpand=`*(widget: Widget; expand: Gboolean) {.
    importc: "gtk_widget_set_vexpand", libgtk.}
proc getVexpandSet*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_vexpand_set", libgtk.}
proc vexpandSet*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_vexpand_set", libgtk.}
proc setVexpandSet*(widget: Widget; set: Gboolean) {.
    importc: "gtk_widget_set_vexpand_set", libgtk.}
proc `vexpandSet=`*(widget: Widget; set: Gboolean) {.
    importc: "gtk_widget_set_vexpand_set", libgtk.}
proc queueComputeExpand*(widget: Widget) {.
    importc: "gtk_widget_queue_compute_expand", libgtk.}
proc computeExpand*(widget: Widget; orientation: Orientation): Gboolean {.
    importc: "gtk_widget_compute_expand", libgtk.}

proc getSupportMultidevice*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_support_multidevice", libgtk.}

proc supportMultidevice*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_support_multidevice", libgtk.}
proc setSupportMultidevice*(widget: Widget;
                                    supportMultidevice: Gboolean) {.
    importc: "gtk_widget_set_support_multidevice", libgtk.}
proc `supportMultidevice=`*(widget: Widget;
                                    supportMultidevice: Gboolean) {.
    importc: "gtk_widget_set_support_multidevice", libgtk.}

proc setAccessibleType*(widgetClass: WidgetClass; `type`: GType) {.
    importc: "gtk_widget_class_set_accessible_type", libgtk.}

proc `accessibleType=`*(widgetClass: WidgetClass; `type`: GType) {.
    importc: "gtk_widget_class_set_accessible_type", libgtk.}
proc setAccessibleRole*(widgetClass: WidgetClass; role: atk.Role) {.
    importc: "gtk_widget_class_set_accessible_role", libgtk.}
proc `accessibleRole=`*(widgetClass: WidgetClass; role: atk.Role) {.
    importc: "gtk_widget_class_set_accessible_role", libgtk.}
proc getAccessible*(widget: Widget): atk.Object {.
    importc: "gtk_widget_get_accessible", libgtk.}
proc accessible*(widget: Widget): atk.Object {.
    importc: "gtk_widget_get_accessible", libgtk.}

proc getHalign*(widget: Widget): Align {.
    importc: "gtk_widget_get_halign", libgtk.}

proc halign*(widget: Widget): Align {.
    importc: "gtk_widget_get_halign", libgtk.}
proc setHalign*(widget: Widget; align: Align) {.
    importc: "gtk_widget_set_halign", libgtk.}
proc `halign=`*(widget: Widget; align: Align) {.
    importc: "gtk_widget_set_halign", libgtk.}
proc getValign*(widget: Widget): Align {.
    importc: "gtk_widget_get_valign", libgtk.}
proc valign*(widget: Widget): Align {.
    importc: "gtk_widget_get_valign", libgtk.}
proc getValignWithBaseline*(widget: Widget): Align {.
    importc: "gtk_widget_get_valign_with_baseline", libgtk.}
proc valignWithBaseline*(widget: Widget): Align {.
    importc: "gtk_widget_get_valign_with_baseline", libgtk.}
proc setValign*(widget: Widget; align: Align) {.
    importc: "gtk_widget_set_valign", libgtk.}
proc `valign=`*(widget: Widget; align: Align) {.
    importc: "gtk_widget_set_valign", libgtk.}
proc getMarginLeft*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_left", libgtk.}
proc marginLeft*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_left", libgtk.}
proc setMarginLeft*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_left", libgtk.}
proc `marginLeft=`*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_left", libgtk.}
proc getMarginRight*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_right", libgtk.}
proc marginRight*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_right", libgtk.}
proc setMarginRight*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_right", libgtk.}
proc `marginRight=`*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_right", libgtk.}
proc getMarginStart*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_start", libgtk.}
proc marginStart*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_start", libgtk.}
proc setMarginStart*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_start", libgtk.}
proc `marginStart=`*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_start", libgtk.}
proc getMarginEnd*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_end", libgtk.}
proc marginEnd*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_end", libgtk.}
proc setMarginEnd*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_end", libgtk.}
proc `marginEnd=`*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_end", libgtk.}
proc getMarginTop*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_top", libgtk.}
proc marginTop*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_top", libgtk.}
proc setMarginTop*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_top", libgtk.}
proc `marginTop=`*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_top", libgtk.}
proc getMarginBottom*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_bottom", libgtk.}
proc marginBottom*(widget: Widget): cint {.
    importc: "gtk_widget_get_margin_bottom", libgtk.}
proc setMarginBottom*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_bottom", libgtk.}
proc `marginBottom=`*(widget: Widget; margin: cint) {.
    importc: "gtk_widget_set_margin_bottom", libgtk.}
proc getEvents*(widget: Widget): cint {.
    importc: "gtk_widget_get_events", libgtk.}
proc events*(widget: Widget): cint {.
    importc: "gtk_widget_get_events", libgtk.}
proc getDeviceEvents*(widget: Widget; device: gdk3.Device): gdk3.EventMask {.
    importc: "gtk_widget_get_device_events", libgtk.}
proc deviceEvents*(widget: Widget; device: gdk3.Device): gdk3.EventMask {.
    importc: "gtk_widget_get_device_events", libgtk.}
proc getPointer*(widget: Widget; x: var cint; y: var cint) {.
    importc: "gtk_widget_get_pointer", libgtk.}
proc isAncestor*(widget: Widget; ancestor: Widget): Gboolean {.
    importc: "gtk_widget_is_ancestor", libgtk.}
proc translateCoordinates*(srcWidget: Widget;
                                   destWidget: Widget; srcX: cint; srcY: cint;
                                   destX: var cint; destY: var cint): Gboolean {.
    importc: "gtk_widget_translate_coordinates", libgtk.}

proc hideOnDelete*(widget: Widget): Gboolean {.
    importc: "gtk_widget_hide_on_delete", libgtk.}

proc overrideColor*(widget: Widget; state: StateFlags;
                            color: gdk3.RGBA) {.
    importc: "gtk_widget_override_color", libgtk.}
proc overrideBackgroundColor*(widget: Widget; state: StateFlags;
                                      color: gdk3.RGBA) {.
    importc: "gtk_widget_override_background_color", libgtk.}
proc overrideFont*(widget: Widget;
                           fontDesc: pango.FontDescription) {.
    importc: "gtk_widget_override_font", libgtk.}
proc overrideSymbolicColor*(widget: Widget; name: cstring;
                                    color: gdk3.RGBA) {.
    importc: "gtk_widget_override_symbolic_color", libgtk.}
proc overrideCursor*(widget: Widget; cursor: gdk3.RGBA;
                             secondaryCursor: gdk3.RGBA) {.
    importc: "gtk_widget_override_cursor", libgtk.}
proc resetStyle*(widget: Widget) {.
    importc: "gtk_widget_reset_style", libgtk.}
proc createPangoContext*(widget: Widget): pango.Context {.
    importc: "gtk_widget_create_pango_context", libgtk.}
proc getPangoContext*(widget: Widget): pango.Context {.
    importc: "gtk_widget_get_pango_context", libgtk.}
proc pangoContext*(widget: Widget): pango.Context {.
    importc: "gtk_widget_get_pango_context", libgtk.}
proc setFontOptions*(widget: Widget; options: cairo.FontOptions) {.
    importc: "gtk_widget_set_font_options", libgtk.}
proc `fontOptions=`*(widget: Widget; options: cairo.FontOptions) {.
    importc: "gtk_widget_set_font_options", libgtk.}
proc getFontOptions*(widget: Widget): cairo.FontOptions {.
    importc: "gtk_widget_get_font_options", libgtk.}
proc fontOptions*(widget: Widget): cairo.FontOptions {.
    importc: "gtk_widget_get_font_options", libgtk.}
proc createPangoLayout*(widget: Widget; text: cstring): pango.Layout {.
    importc: "gtk_widget_create_pango_layout", libgtk.}
proc renderIconPixbuf*(widget: Widget; stockId: cstring;
                               size: IconSize): GdkPixbuf {.
    importc: "gtk_widget_render_icon_pixbuf", libgtk.}

proc setCompositeName*(widget: Widget; name: cstring) {.
    importc: "gtk_widget_set_composite_name", libgtk.}

proc `compositeName=`*(widget: Widget; name: cstring) {.
    importc: "gtk_widget_set_composite_name", libgtk.}
proc getCompositeName*(widget: Widget): cstring {.
    importc: "gtk_widget_get_composite_name", libgtk.}
proc compositeName*(widget: Widget): cstring {.
    importc: "gtk_widget_get_composite_name", libgtk.}

proc widgetPushCompositeChild*() {.importc: "gtk_widget_push_composite_child",
                                    libgtk.}
proc widgetPopCompositeChild*() {.importc: "gtk_widget_pop_composite_child",
                                   libgtk.}

proc installStyleProperty*(klass: WidgetClass;
                                        pspec: gobject.GParamSpec) {.
    importc: "gtk_widget_class_install_style_property", libgtk.}
proc installStylePropertyParser*(klass: WidgetClass;
    pspec: gobject.GParamSpec; parser: RcPropertyParser) {.
    importc: "gtk_widget_class_install_style_property_parser", libgtk.}
proc findStyleProperty*(klass: WidgetClass;
                                     propertyName: cstring): gobject.GParamSpec {.
    importc: "gtk_widget_class_find_style_property", libgtk.}
proc listStyleProperties*(klass: WidgetClass;
                                       nProperties: var cuint): var gobject.GParamSpec {.
    importc: "gtk_widget_class_list_style_properties", libgtk.}
proc styleGetProperty*(widget: Widget; propertyName: cstring;
                               value: gobject.GValue) {.
    importc: "gtk_widget_style_get_property", libgtk.}

discard """ proc "styleGetValist*(widget: Widget; firstPropertyName: cstring;
                             varArgs: VaList) {.
    importc: "gtk_widget_style_get_valist", libgtk.}"""

proc styleGet*(widget: Widget; firstPropertyName: cstring) {.varargs,
    importc: "gtk_widget_style_get", libgtk.}

proc setDirection*(widget: Widget; dir: TextDirection) {.
    importc: "gtk_widget_set_direction", libgtk.}

proc `direction=`*(widget: Widget; dir: TextDirection) {.
    importc: "gtk_widget_set_direction", libgtk.}
proc getDirection*(widget: Widget): TextDirection {.
    importc: "gtk_widget_get_direction", libgtk.}
proc direction*(widget: Widget): TextDirection {.
    importc: "gtk_widget_get_direction", libgtk.}
proc widgetSetDefaultDirection*(dir: TextDirection) {.
    importc: "gtk_widget_set_default_direction", libgtk.}
proc widgetGetDefaultDirection*(): TextDirection {.
    importc: "gtk_widget_get_default_direction", libgtk.}

proc isComposited*(widget: Widget): Gboolean {.
    importc: "gtk_widget_is_composited", libgtk.}

proc shapeCombineRegion*(widget: Widget; region: cairo.Region) {.
    importc: "gtk_widget_shape_combine_region", libgtk.}
proc inputShapeCombineRegion*(widget: Widget;
                                      region: cairo.Region) {.
    importc: "gtk_widget_input_shape_combine_region", libgtk.}
proc listMnemonicLabels*(widget: Widget): glib.GList {.
    importc: "gtk_widget_list_mnemonic_labels", libgtk.}
proc addMnemonicLabel*(widget: Widget; label: Widget) {.
    importc: "gtk_widget_add_mnemonic_label", libgtk.}
proc removeMnemonicLabel*(widget: Widget; label: Widget) {.
    importc: "gtk_widget_remove_mnemonic_label", libgtk.}
proc setTooltipWindow*(widget: Widget; customWindow: Window) {.
    importc: "gtk_widget_set_tooltip_window", libgtk.}
proc `tooltipWindow=`*(widget: Widget; customWindow: Window) {.
    importc: "gtk_widget_set_tooltip_window", libgtk.}
proc getTooltipWindow*(widget: Widget): Window {.
    importc: "gtk_widget_get_tooltip_window", libgtk.}
proc tooltipWindow*(widget: Widget): Window {.
    importc: "gtk_widget_get_tooltip_window", libgtk.}
proc triggerTooltipQuery*(widget: Widget) {.
    importc: "gtk_widget_trigger_tooltip_query", libgtk.}
proc setTooltipText*(widget: Widget; text: cstring) {.
    importc: "gtk_widget_set_tooltip_text", libgtk.}
proc `tooltipText=`*(widget: Widget; text: cstring) {.
    importc: "gtk_widget_set_tooltip_text", libgtk.}
proc getTooltipText*(widget: Widget): cstring {.
    importc: "gtk_widget_get_tooltip_text", libgtk.}
proc tooltipText*(widget: Widget): cstring {.
    importc: "gtk_widget_get_tooltip_text", libgtk.}
proc setTooltipMarkup*(widget: Widget; markup: cstring) {.
    importc: "gtk_widget_set_tooltip_markup", libgtk.}
proc `tooltipMarkup=`*(widget: Widget; markup: cstring) {.
    importc: "gtk_widget_set_tooltip_markup", libgtk.}
proc getTooltipMarkup*(widget: Widget): cstring {.
    importc: "gtk_widget_get_tooltip_markup", libgtk.}
proc tooltipMarkup*(widget: Widget): cstring {.
    importc: "gtk_widget_get_tooltip_markup", libgtk.}
proc setHasTooltip*(widget: Widget; hasTooltip: Gboolean) {.
    importc: "gtk_widget_set_has_tooltip", libgtk.}
proc `hasTooltip=`*(widget: Widget; hasTooltip: Gboolean) {.
    importc: "gtk_widget_set_has_tooltip", libgtk.}
proc getHasTooltip*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_has_tooltip", libgtk.}
proc hasTooltip*(widget: Widget): Gboolean {.
    importc: "gtk_widget_get_has_tooltip", libgtk.}
proc cairoShouldDrawWindow*(cr: cairo.Context; window: gdk3.Window): Gboolean {.
    importc: "gtk_cairo_should_draw_window", libgtk.}
proc cairoTransformToWindow*(cr: cairo.Context; widget: Widget;
                               window: gdk3.Window) {.
    importc: "gtk_cairo_transform_to_window", libgtk.}
proc requisitionGetType*(): GType {.importc: "gtk_requisition_get_type",
                                    libgtk.}
proc newRequisition*(): Requisition {.importc: "gtk_requisition_new",
    libgtk.}
proc copy*(requisition: Requisition): Requisition {.
    importc: "gtk_requisition_copy", libgtk.}
proc free*(requisition: Requisition) {.
    importc: "gtk_requisition_free", libgtk.}
proc inDestruction*(widget: Widget): Gboolean {.
    importc: "gtk_widget_in_destruction", libgtk.}
proc getStyleContext*(widget: Widget): StyleContext {.
    importc: "gtk_widget_get_style_context", libgtk.}
proc styleContext*(widget: Widget): StyleContext {.
    importc: "gtk_widget_get_style_context", libgtk.}
proc getPath*(widget: Widget): WidgetPath {.
    importc: "gtk_widget_get_path", libgtk.}
proc path*(widget: Widget): WidgetPath {.
    importc: "gtk_widget_get_path", libgtk.}
proc setCssName*(widgetClass: WidgetClass; name: cstring) {.
    importc: "gtk_widget_class_set_css_name", libgtk.}
proc `cssName=`*(widgetClass: WidgetClass; name: cstring) {.
    importc: "gtk_widget_class_set_css_name", libgtk.}
proc getCssName*(widgetClass: WidgetClass): cstring {.
    importc: "gtk_widget_class_get_css_name", libgtk.}
proc cssName*(widgetClass: WidgetClass): cstring {.
    importc: "gtk_widget_class_get_css_name", libgtk.}
proc getModifierMask*(widget: Widget; intent: gdk3.ModifierIntent): gdk3.ModifierType {.
    importc: "gtk_widget_get_modifier_mask", libgtk.}
proc modifierMask*(widget: Widget; intent: gdk3.ModifierIntent): gdk3.ModifierType {.
    importc: "gtk_widget_get_modifier_mask", libgtk.}
proc insertActionGroup*(widget: Widget; name: cstring;
                                group: gio.GActionGroup) {.
    importc: "gtk_widget_insert_action_group", libgtk.}
proc addTickCallback*(widget: Widget; callback: TickCallback;
                              userData: Gpointer; notify: GDestroyNotify): cuint {.
    importc: "gtk_widget_add_tick_callback", libgtk.}
proc removeTickCallback*(widget: Widget; id: cuint) {.
    importc: "gtk_widget_remove_tick_callback", libgtk.}

proc initTemplate*(widget: Widget) {.
    importc: "gtk_widget_init_template", libgtk.}
proc getTemplateChild*(widget: Widget; widgetType: GType;
                               name: cstring): GObject {.
    importc: "gtk_widget_get_template_child", libgtk.}
proc templateChild*(widget: Widget; widgetType: GType;
                               name: cstring): GObject {.
    importc: "gtk_widget_get_template_child", libgtk.}
proc setTemplate*(widgetClass: WidgetClass;
                               templateBytes: glib.GBytes) {.
    importc: "gtk_widget_class_set_template", libgtk.}
proc `template=`*(widgetClass: WidgetClass;
                               templateBytes: glib.GBytes) {.
    importc: "gtk_widget_class_set_template", libgtk.}
proc setTemplateFromResource*(widgetClass: WidgetClass;
    resourceName: cstring) {.importc: "gtk_widget_class_set_template_from_resource",
                           libgtk.}
proc `templateFromResource=`*(widgetClass: WidgetClass;
    resourceName: cstring) {.importc: "gtk_widget_class_set_template_from_resource",
                           libgtk.}
proc bindTemplateCallbackFull*(widgetClass: WidgetClass;
    callbackName: cstring; callbackSymbol: GCallback) {.
    importc: "gtk_widget_class_bind_template_callback_full", libgtk.}
proc setConnectFunc*(widgetClass: WidgetClass;
                                  connectFunc: BuilderConnectFunc;
                                  connectData: Gpointer;
                                  connectDataDestroy: GDestroyNotify) {.
    importc: "gtk_widget_class_set_connect_func", libgtk.}
proc `connectFunc=`*(widgetClass: WidgetClass;
                                  connectFunc: BuilderConnectFunc;
                                  connectData: Gpointer;
                                  connectDataDestroy: GDestroyNotify) {.
    importc: "gtk_widget_class_set_connect_func", libgtk.}
proc bindTemplateChildFull*(widgetClass: WidgetClass;
    name: cstring; internalChild: Gboolean; structOffset: Gssize) {.
    importc: "gtk_widget_class_bind_template_child_full", libgtk.}
proc getActionGroup*(widget: Widget; prefix: cstring): gio.GActionGroup {.
    importc: "gtk_widget_get_action_group", libgtk.}
proc actionGroup*(widget: Widget; prefix: cstring): gio.GActionGroup {.
    importc: "gtk_widget_get_action_group", libgtk.}
proc listActionPrefixes*(widget: Widget): cstringArray {.
    importc: "gtk_widget_list_action_prefixes", libgtk.}
proc setFontMap*(widget: Widget; fontMap: pango.FontMap) {.
    importc: "gtk_widget_set_font_map", libgtk.}
proc `fontMap=`*(widget: Widget; fontMap: pango.FontMap) {.
    importc: "gtk_widget_set_font_map", libgtk.}
proc getFontMap*(widget: Widget): pango.FontMap {.
    importc: "gtk_widget_get_font_map", libgtk.}
proc fontMap*(widget: Widget): pango.FontMap {.
    importc: "gtk_widget_get_font_map", libgtk.}

template typeApplication*(): expr =
  gtk3.applicationGetType()

template application*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeApplication, ApplicationObj))

template applicationClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeApplication, ApplicationClassObj))

template isApplication*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeApplication))

template isApplicationClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeApplication))

template applicationGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeApplication, ApplicationClassObj))

proc applicationGetType*(): GType {.importc: "gtk_application_get_type",
                                    libgtk.}
proc newApplication*(applicationId: cstring; flags: GApplicationFlags): Application {.
    importc: "gtk_application_new", libgtk.}
proc addWindow*(application: Application; window: Window) {.
    importc: "gtk_application_add_window", libgtk.}
proc removeWindow*(application: Application;
                                window: Window) {.
    importc: "gtk_application_remove_window", libgtk.}
proc getWindows*(application: Application): glib.GList {.
    importc: "gtk_application_get_windows", libgtk.}
proc windows*(application: Application): glib.GList {.
    importc: "gtk_application_get_windows", libgtk.}
proc getAppMenu*(application: Application): gio.GMenuModel {.
    importc: "gtk_application_get_app_menu", libgtk.}
proc appMenu*(application: Application): gio.GMenuModel {.
    importc: "gtk_application_get_app_menu", libgtk.}
proc setAppMenu*(application: Application;
                              appMenu: gio.GMenuModel) {.
    importc: "gtk_application_set_app_menu", libgtk.}
proc `appMenu=`*(application: Application;
                              appMenu: gio.GMenuModel) {.
    importc: "gtk_application_set_app_menu", libgtk.}
proc getMenubar*(application: Application): gio.GMenuModel {.
    importc: "gtk_application_get_menubar", libgtk.}
proc menubar*(application: Application): gio.GMenuModel {.
    importc: "gtk_application_get_menubar", libgtk.}
proc setMenubar*(application: Application;
                              menubar: gio.GMenuModel) {.
    importc: "gtk_application_set_menubar", libgtk.}
proc `menubar=`*(application: Application;
                              menubar: gio.GMenuModel) {.
    importc: "gtk_application_set_menubar", libgtk.}
proc addAccelerator*(application: Application;
                                  accelerator: cstring; actionName: cstring;
                                  parameter: glib.GVariant) {.
    importc: "gtk_application_add_accelerator", libgtk.}
proc removeAccelerator*(application: Application;
                                     actionName: cstring; parameter: glib.GVariant) {.
    importc: "gtk_application_remove_accelerator", libgtk.}
type
  ApplicationInhibitFlags* {.size: sizeof(cint), pure.} = enum
    LOGOUT = 1 shl 0,
    SWITCH = 1 shl 1,
    SUSPEND = 1 shl 2,
    IDLE = 1 shl 3

type
  ContainerClass* =  ptr ContainerClassObj
  ContainerClassPtr* = ptr ContainerClassObj
  ContainerClassObj = object of WidgetClassObj
    add*: proc (container: Container; widget: Widget) {.cdecl.}
    remove*: proc (container: Container; widget: Widget) {.cdecl.}
    checkResize*: proc (container: Container) {.cdecl.}
    forall*: proc (container: Container; includeInternals: Gboolean;
                 callback: Callback; callbackData: Gpointer) {.cdecl.}
    setFocusChild*: proc (container: Container; child: Widget) {.cdecl.}
    childType*: proc (container: Container): GType {.cdecl.}
    compositeName*: proc (container: Container; child: Widget): cstring {.cdecl.}
    setChildProperty*: proc (container: Container; child: Widget;
                           propertyId: cuint; value: gobject.GValue;
                           pspec: gobject.GParamSpec) {.cdecl.}
    getChildProperty*: proc (container: Container; child: Widget;
                           propertyId: cuint; value: gobject.GValue;
                           pspec: gobject.GParamSpec) {.cdecl.}
    getPathForChild*: proc (container: Container; child: Widget): WidgetPath {.cdecl.}
    handleBorderWidth* {.bitsize: 1.}: cuint
    gtkReserved31*: proc () {.cdecl.}
    gtkReserved32*: proc () {.cdecl.}
    gtkReserved33*: proc () {.cdecl.}
    gtkReserved34*: proc () {.cdecl.}
    gtkReserved35*: proc () {.cdecl.}
    gtkReserved36*: proc () {.cdecl.}
    gtkReserved37*: proc () {.cdecl.}
    gtkReserved38*: proc () {.cdecl.}

proc inhibit*(application: Application; window: Window;
                           flags: ApplicationInhibitFlags; reason: cstring): cuint {.
    importc: "gtk_application_inhibit", libgtk.}
proc uninhibit*(application: Application; cookie: cuint) {.
    importc: "gtk_application_uninhibit", libgtk.}
proc isInhibited*(application: Application;
                               flags: ApplicationInhibitFlags): Gboolean {.
    importc: "gtk_application_is_inhibited", libgtk.}
proc getWindowById*(application: Application; id: cuint): Window {.
    importc: "gtk_application_get_window_by_id", libgtk.}
proc windowById*(application: Application; id: cuint): Window {.
    importc: "gtk_application_get_window_by_id", libgtk.}
proc getActiveWindow*(application: Application): Window {.
    importc: "gtk_application_get_active_window", libgtk.}
proc activeWindow*(application: Application): Window {.
    importc: "gtk_application_get_active_window", libgtk.}
proc listActionDescriptions*(application: Application): cstringArray {.
    importc: "gtk_application_list_action_descriptions", libgtk.}
proc getAccelsForAction*(application: Application;
                                      detailedActionName: cstring): cstringArray {.
    importc: "gtk_application_get_accels_for_action", libgtk.}
proc accelsForAction*(application: Application;
                                      detailedActionName: cstring): cstringArray {.
    importc: "gtk_application_get_accels_for_action", libgtk.}
proc getActionsForAccel*(application: Application;
                                      accel: cstring): cstringArray {.
    importc: "gtk_application_get_actions_for_accel", libgtk.}
proc actionsForAccel*(application: Application;
                                      accel: cstring): cstringArray {.
    importc: "gtk_application_get_actions_for_accel", libgtk.}
proc setAccelsForAction*(application: Application;
                                      detailedActionName: cstring;
                                      accels: cstringArray) {.
    importc: "gtk_application_set_accels_for_action", libgtk.}
proc `accelsForAction=`*(application: Application;
                                      detailedActionName: cstring;
                                      accels: cstringArray) {.
    importc: "gtk_application_set_accels_for_action", libgtk.}
proc prefersAppMenu*(application: Application): Gboolean {.
    importc: "gtk_application_prefers_app_menu", libgtk.}
proc getMenuById*(application: Application; id: cstring): gio.GMenu {.
    importc: "gtk_application_get_menu_by_id", libgtk.}
proc menuById*(application: Application; id: cstring): gio.GMenu {.
    importc: "gtk_application_get_menu_by_id", libgtk.}

template typeContainer*(): expr =
  (containerGetType())

template container*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeContainer, ContainerObj))

template containerClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeContainer, ContainerClassObj))

template isContainer*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeContainer))

template isContainerClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeContainer))

template containerGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeContainer, ContainerClassObj))

type
  ResizeMode* {.size: sizeof(cint), pure.} = enum
    PARENT, QUEUE, IMMEDIATE

type
  BinClass* =  ptr BinClassObj
  BinClassPtr* = ptr BinClassObj
  BinClassObj* = object of ContainerClassObj
    gtkReserved41*: proc () {.cdecl.}
    gtkReserved42*: proc () {.cdecl.}
    gtkReserved43*: proc () {.cdecl.}
    gtkReserved44*: proc () {.cdecl.}

  Adjustment* =  ptr AdjustmentObj
  AdjustmentPtr* = ptr AdjustmentObj
  AdjustmentObj*{.final.} = object of gobject.GInitiallyUnownedObj
    priv12: pointer

proc containerGetType*(): GType {.importc: "gtk_container_get_type", libgtk.}
proc setBorderWidth*(container: Container; borderWidth: cuint) {.
    importc: "gtk_container_set_border_width", libgtk.}
proc `borderWidth=`*(container: Container; borderWidth: cuint) {.
    importc: "gtk_container_set_border_width", libgtk.}
proc getBorderWidth*(container: Container): cuint {.
    importc: "gtk_container_get_border_width", libgtk.}
proc borderWidth*(container: Container): cuint {.
    importc: "gtk_container_get_border_width", libgtk.}
proc add*(container: Container; widget: Widget) {.
    importc: "gtk_container_add", libgtk.}
proc remove*(container: Container; widget: Widget) {.
    importc: "gtk_container_remove", libgtk.}
proc setResizeMode*(container: Container;
                               resizeMode: ResizeMode) {.
    importc: "gtk_container_set_resize_mode", libgtk.}
proc `resizeMode=`*(container: Container;
                               resizeMode: ResizeMode) {.
    importc: "gtk_container_set_resize_mode", libgtk.}
proc getResizeMode*(container: Container): ResizeMode {.
    importc: "gtk_container_get_resize_mode", libgtk.}
proc resizeMode*(container: Container): ResizeMode {.
    importc: "gtk_container_get_resize_mode", libgtk.}
proc checkResize*(container: Container) {.
    importc: "gtk_container_check_resize", libgtk.}
proc foreach*(container: Container; callback: Callback;
                         callbackData: Gpointer) {.
    importc: "gtk_container_foreach", libgtk.}
proc getChildren*(container: Container): glib.GList {.
    importc: "gtk_container_get_children", libgtk.}
proc children*(container: Container): glib.GList {.
    importc: "gtk_container_get_children", libgtk.}
proc propagateDraw*(container: Container; child: Widget;
                               cr: cairo.Context) {.
    importc: "gtk_container_propagate_draw", libgtk.}
proc setFocusChain*(container: Container;
                               focusableWidgets: glib.GList) {.
    importc: "gtk_container_set_focus_chain", libgtk.}
proc `focusChain=`*(container: Container;
                               focusableWidgets: glib.GList) {.
    importc: "gtk_container_set_focus_chain", libgtk.}
proc getFocusChain*(container: Container;
                               focusableWidgets: var glib.GList): Gboolean {.
    importc: "gtk_container_get_focus_chain", libgtk.}
proc focusChain*(container: Container;
                               focusableWidgets: var glib.GList): Gboolean {.
    importc: "gtk_container_get_focus_chain", libgtk.}
proc unsetFocusChain*(container: Container) {.
    importc: "gtk_container_unset_focus_chain", libgtk.}
template isResizeContainer*(widget: expr): expr =
  (isContainer(widget) and
      (gtkContainerGetResizeMode(container(widget)) != gtk_Resize_Parent))

proc setReallocateRedraws*(container: Container;
                                      needsRedraws: Gboolean) {.
    importc: "gtk_container_set_reallocate_redraws", libgtk.}

proc `reallocateRedraws=`*(container: Container;
                                      needsRedraws: Gboolean) {.
    importc: "gtk_container_set_reallocate_redraws", libgtk.}
proc setFocusChild*(container: Container; child: Widget) {.
    importc: "gtk_container_set_focus_child", libgtk.}
proc `focusChild=`*(container: Container; child: Widget) {.
    importc: "gtk_container_set_focus_child", libgtk.}
proc getFocusChild*(container: Container): Widget {.
    importc: "gtk_container_get_focus_child", libgtk.}
proc focusChild*(container: Container): Widget {.
    importc: "gtk_container_get_focus_child", libgtk.}
proc setFocusVadjustment*(container: Container;
                                     adjustment: Adjustment) {.
    importc: "gtk_container_set_focus_vadjustment", libgtk.}
proc `focusVadjustment=`*(container: Container;
                                     adjustment: Adjustment) {.
    importc: "gtk_container_set_focus_vadjustment", libgtk.}
proc getFocusVadjustment*(container: Container): Adjustment {.
    importc: "gtk_container_get_focus_vadjustment", libgtk.}
proc focusVadjustment*(container: Container): Adjustment {.
    importc: "gtk_container_get_focus_vadjustment", libgtk.}
proc setFocusHadjustment*(container: Container;
                                     adjustment: Adjustment) {.
    importc: "gtk_container_set_focus_hadjustment", libgtk.}
proc `focusHadjustment=`*(container: Container;
                                     adjustment: Adjustment) {.
    importc: "gtk_container_set_focus_hadjustment", libgtk.}
proc getFocusHadjustment*(container: Container): Adjustment {.
    importc: "gtk_container_get_focus_hadjustment", libgtk.}
proc focusHadjustment*(container: Container): Adjustment {.
    importc: "gtk_container_get_focus_hadjustment", libgtk.}
proc resizeChildren*(container: Container) {.
    importc: "gtk_container_resize_children", libgtk.}
proc childType*(container: Container): GType {.
    importc: "gtk_container_child_type", libgtk.}
proc installChildProperty*(cclass: ContainerClass;
    propertyId: cuint; pspec: gobject.GParamSpec) {.
    importc: "gtk_container_class_install_child_property", libgtk.}
proc installChildProperties*(cclass: ContainerClass;
    nPspecs: cuint; pspecs: var gobject.GParamSpec) {.
    importc: "gtk_container_class_install_child_properties", libgtk.}
proc containerClassFindChildProperty*(cclass: gobject.GObjectClass;
                                        propertyName: cstring): gobject.GParamSpec {.
    importc: "gtk_container_class_find_child_property", libgtk.}
proc containerClassListChildProperties*(cclass: gobject.GObjectClass;
    nProperties: var cuint): var gobject.GParamSpec {.
    importc: "gtk_container_class_list_child_properties", libgtk.}
proc addWithProperties*(container: Container;
                                   widget: Widget; firstPropName: cstring) {.
    varargs, importc: "gtk_container_add_with_properties", libgtk.}
proc childSet*(container: Container; child: Widget;
                          firstPropName: cstring) {.varargs,
    importc: "gtk_container_child_set", libgtk.}
proc childGet*(container: Container; child: Widget;
                          firstPropName: cstring) {.varargs,
    importc: "gtk_container_child_get", libgtk.}

discard """ proc "childSetValist*(container: Container; child: Widget;
                                firstPropertyName: cstring; varArgs: VaList) {.
    importc: "gtk_container_child_set_valist", libgtk.}"""

discard """ proc "childGetValist*(container: Container; child: Widget;
                                firstPropertyName: cstring; varArgs: VaList) {.
    importc: "gtk_container_child_get_valist", libgtk.}"""

proc childSetProperty*(container: Container;
                                  child: Widget; propertyName: cstring;
                                  value: gobject.GValue) {.
    importc: "gtk_container_child_set_property", libgtk.}
proc childGetProperty*(container: Container;
                                  child: Widget; propertyName: cstring;
                                  value: gobject.GValue) {.
    importc: "gtk_container_child_get_property", libgtk.}
proc childNotify*(container: Container; child: Widget;
                             childProperty: cstring) {.
    importc: "gtk_container_child_notify", libgtk.}
proc childNotifyByPspec*(container: Container;
                                    child: Widget; pspec: gobject.GParamSpec) {.
    importc: "gtk_container_child_notify_by_pspec", libgtk.}

template containerWarnInvalidChildPropertyId*(
    `object`, propertyId, pspec: expr): expr =
  g_Object_Warn_Invalid_Pspec(`object`, "child property", propertyId, pspec)

proc forall*(container: Container; callback: Callback;
                        callbackData: Gpointer) {.importc: "gtk_container_forall",
    libgtk.}
proc handleBorderWidth*(klass: ContainerClass) {.
    importc: "gtk_container_class_handle_border_width", libgtk.}
proc getPathForChild*(container: Container; child: Widget): WidgetPath {.
    importc: "gtk_container_get_path_for_child", libgtk.}
proc pathForChild*(container: Container; child: Widget): WidgetPath {.
    importc: "gtk_container_get_path_for_child", libgtk.}

template typeBin*(): expr =
  (binGetType())

template bin*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeBin, BinObj))

template binClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeBin, BinClassObj))

template isBin*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeBin))

template isBinClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeBin))

template binGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeBin, BinClassObj))

type
  WindowClass* =  ptr WindowClassObj
  WindowClassPtr* = ptr WindowClassObj
  WindowClassObj* = object of BinClassObj
    setFocus*: proc (window: Window; focus: Widget) {.cdecl.}
    activateFocus*: proc (window: Window) {.cdecl.}
    activateDefault*: proc (window: Window) {.cdecl.}
    keysChanged*: proc (window: Window) {.cdecl.}
    enableDebugging*: proc (window: Window; toggle: Gboolean): Gboolean {.cdecl.}
    gtkReserved51*: proc () {.cdecl.}
    gtkReserved52*: proc () {.cdecl.}
    gtkReserved53*: proc () {.cdecl.}

proc binGetType*(): GType {.importc: "gtk_bin_get_type", libgtk.}
proc getChild*(bin: Bin): Widget {.importc: "gtk_bin_get_child",
    libgtk.}
proc child*(bin: Bin): Widget {.importc: "gtk_bin_get_child",
    libgtk.}

discard """ proc "setChild*(bin: Bin; widget: Widget) {.
    importc: "_gtk_bin_set_child", libgtk.}"""

template typeWindow*(): expr =
  gtk3.windowGetType()

template window*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeWindow, WindowObj))

template windowClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeWindow, WindowClassObj))

template isWindow*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeWindow))

template isWindowClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeWindow))

template windowGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeWindow, WindowClassObj))

type
  WindowGeometryInfo* =  ptr WindowGeometryInfoObj
  WindowGeometryInfoPtr* = ptr WindowGeometryInfoObj
  WindowGeometryInfoObj* = object

type
  WindowType* {.size: sizeof(cint), pure.} = enum
    TOPLEVEL, POPUP

type
  WindowPosition* {.size: sizeof(cint), pure.} = enum
    NONE, CENTER, MOUSE,
    CENTER_ALWAYS, CENTER_ON_PARENT

type
  WindowGroup* =  ptr WindowGroupObj
  WindowGroupPtr* = ptr WindowGroupObj
  WindowGroupObj*{.final.} = object of GObjectObj
    priv13: pointer

proc windowGetType*(): GType {.importc: "gtk_window_get_type", libgtk.}
proc newWindow*(`type`: WindowType): Window {.importc: "gtk_window_new",
    libgtk.}
proc setTitle*(window: Window; title: cstring) {.
    importc: "gtk_window_set_title", libgtk.}
proc `title=`*(window: Window; title: cstring) {.
    importc: "gtk_window_set_title", libgtk.}
proc getTitle*(window: Window): cstring {.
    importc: "gtk_window_get_title", libgtk.}
proc title*(window: Window): cstring {.
    importc: "gtk_window_get_title", libgtk.}
proc setWmclass*(window: Window; wmclassName: cstring;
                         wmclassClass: cstring) {.
    importc: "gtk_window_set_wmclass", libgtk.}
proc `wmclass=`*(window: Window; wmclassName: cstring;
                         wmclassClass: cstring) {.
    importc: "gtk_window_set_wmclass", libgtk.}
proc setRole*(window: Window; role: cstring) {.
    importc: "gtk_window_set_role", libgtk.}
proc `role=`*(window: Window; role: cstring) {.
    importc: "gtk_window_set_role", libgtk.}
proc setStartupId*(window: Window; startupId: cstring) {.
    importc: "gtk_window_set_startup_id", libgtk.}
proc `startupId=`*(window: Window; startupId: cstring) {.
    importc: "gtk_window_set_startup_id", libgtk.}
proc getRole*(window: Window): cstring {.
    importc: "gtk_window_get_role", libgtk.}
proc role*(window: Window): cstring {.
    importc: "gtk_window_get_role", libgtk.}
proc addAccelGroup*(window: Window; accelGroup: AccelGroup) {.
    importc: "gtk_window_add_accel_group", libgtk.}
proc removeAccelGroup*(window: Window; accelGroup: AccelGroup) {.
    importc: "gtk_window_remove_accel_group", libgtk.}
proc setPosition*(window: Window; position: WindowPosition) {.
    importc: "gtk_window_set_position", libgtk.}
proc `position=`*(window: Window; position: WindowPosition) {.
    importc: "gtk_window_set_position", libgtk.}
proc activateFocus*(window: Window): Gboolean {.
    importc: "gtk_window_activate_focus", libgtk.}
proc setFocus*(window: Window; focus: Widget) {.
    importc: "gtk_window_set_focus", libgtk.}
proc `focus=`*(window: Window; focus: Widget) {.
    importc: "gtk_window_set_focus", libgtk.}
proc getFocus*(window: Window): Widget {.
    importc: "gtk_window_get_focus", libgtk.}
proc focus*(window: Window): Widget {.
    importc: "gtk_window_get_focus", libgtk.}
proc setDefault*(window: Window; defaultWidget: Widget) {.
    importc: "gtk_window_set_default", libgtk.}
proc `default=`*(window: Window; defaultWidget: Widget) {.
    importc: "gtk_window_set_default", libgtk.}
proc getDefaultWidget*(window: Window): Widget {.
    importc: "gtk_window_get_default_widget", libgtk.}
proc defaultWidget*(window: Window): Widget {.
    importc: "gtk_window_get_default_widget", libgtk.}
proc activateDefault*(window: Window): Gboolean {.
    importc: "gtk_window_activate_default", libgtk.}
proc setTransientFor*(window: Window; parent: Window) {.
    importc: "gtk_window_set_transient_for", libgtk.}
proc `transientFor=`*(window: Window; parent: Window) {.
    importc: "gtk_window_set_transient_for", libgtk.}
proc getTransientFor*(window: Window): Window {.
    importc: "gtk_window_get_transient_for", libgtk.}
proc transientFor*(window: Window): Window {.
    importc: "gtk_window_get_transient_for", libgtk.}
proc setAttachedTo*(window: Window; attachWidget: Widget) {.
    importc: "gtk_window_set_attached_to", libgtk.}
proc `attachedTo=`*(window: Window; attachWidget: Widget) {.
    importc: "gtk_window_set_attached_to", libgtk.}
proc getAttachedTo*(window: Window): Widget {.
    importc: "gtk_window_get_attached_to", libgtk.}
proc attachedTo*(window: Window): Widget {.
    importc: "gtk_window_get_attached_to", libgtk.}
proc setOpacity*(window: Window; opacity: cdouble) {.
    importc: "gtk_window_set_opacity", libgtk.}
proc `opacity=`*(window: Window; opacity: cdouble) {.
    importc: "gtk_window_set_opacity", libgtk.}
proc getOpacity*(window: Window): cdouble {.
    importc: "gtk_window_get_opacity", libgtk.}
proc opacity*(window: Window): cdouble {.
    importc: "gtk_window_get_opacity", libgtk.}
proc setTypeHint*(window: Window; hint: gdk3.WindowTypeHint) {.
    importc: "gtk_window_set_type_hint", libgtk.}
proc `typeHint=`*(window: Window; hint: gdk3.WindowTypeHint) {.
    importc: "gtk_window_set_type_hint", libgtk.}
proc getTypeHint*(window: Window): gdk3.WindowTypeHint {.
    importc: "gtk_window_get_type_hint", libgtk.}
proc typeHint*(window: Window): gdk3.WindowTypeHint {.
    importc: "gtk_window_get_type_hint", libgtk.}
proc setSkipTaskbarHint*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_skip_taskbar_hint", libgtk.}
proc `skipTaskbarHint=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_skip_taskbar_hint", libgtk.}
proc getSkipTaskbarHint*(window: Window): Gboolean {.
    importc: "gtk_window_get_skip_taskbar_hint", libgtk.}
proc skipTaskbarHint*(window: Window): Gboolean {.
    importc: "gtk_window_get_skip_taskbar_hint", libgtk.}
proc setSkipPagerHint*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_skip_pager_hint", libgtk.}
proc `skipPagerHint=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_skip_pager_hint", libgtk.}
proc getSkipPagerHint*(window: Window): Gboolean {.
    importc: "gtk_window_get_skip_pager_hint", libgtk.}
proc skipPagerHint*(window: Window): Gboolean {.
    importc: "gtk_window_get_skip_pager_hint", libgtk.}
proc setUrgencyHint*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_urgency_hint", libgtk.}
proc `urgencyHint=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_urgency_hint", libgtk.}
proc getUrgencyHint*(window: Window): Gboolean {.
    importc: "gtk_window_get_urgency_hint", libgtk.}
proc urgencyHint*(window: Window): Gboolean {.
    importc: "gtk_window_get_urgency_hint", libgtk.}
proc setAcceptFocus*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_accept_focus", libgtk.}
proc `acceptFocus=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_accept_focus", libgtk.}
proc getAcceptFocus*(window: Window): Gboolean {.
    importc: "gtk_window_get_accept_focus", libgtk.}
proc acceptFocus*(window: Window): Gboolean {.
    importc: "gtk_window_get_accept_focus", libgtk.}
proc setFocusOnMap*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_focus_on_map", libgtk.}
proc `focusOnMap=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_focus_on_map", libgtk.}
proc getFocusOnMap*(window: Window): Gboolean {.
    importc: "gtk_window_get_focus_on_map", libgtk.}
proc focusOnMap*(window: Window): Gboolean {.
    importc: "gtk_window_get_focus_on_map", libgtk.}
proc setDestroyWithParent*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_destroy_with_parent", libgtk.}
proc `destroyWithParent=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_destroy_with_parent", libgtk.}
proc getDestroyWithParent*(window: Window): Gboolean {.
    importc: "gtk_window_get_destroy_with_parent", libgtk.}
proc destroyWithParent*(window: Window): Gboolean {.
    importc: "gtk_window_get_destroy_with_parent", libgtk.}
proc setHideTitlebarWhenMaximized*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_hide_titlebar_when_maximized", libgtk.}
proc `hideTitlebarWhenMaximized=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_hide_titlebar_when_maximized", libgtk.}
proc getHideTitlebarWhenMaximized*(window: Window): Gboolean {.
    importc: "gtk_window_get_hide_titlebar_when_maximized", libgtk.}
proc hideTitlebarWhenMaximized*(window: Window): Gboolean {.
    importc: "gtk_window_get_hide_titlebar_when_maximized", libgtk.}
proc setMnemonicsVisible*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_mnemonics_visible", libgtk.}
proc `mnemonicsVisible=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_mnemonics_visible", libgtk.}
proc getMnemonicsVisible*(window: Window): Gboolean {.
    importc: "gtk_window_get_mnemonics_visible", libgtk.}
proc mnemonicsVisible*(window: Window): Gboolean {.
    importc: "gtk_window_get_mnemonics_visible", libgtk.}
proc setFocusVisible*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_focus_visible", libgtk.}
proc `focusVisible=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_focus_visible", libgtk.}
proc getFocusVisible*(window: Window): Gboolean {.
    importc: "gtk_window_get_focus_visible", libgtk.}
proc focusVisible*(window: Window): Gboolean {.
    importc: "gtk_window_get_focus_visible", libgtk.}
proc setResizable*(window: Window; resizable: Gboolean) {.
    importc: "gtk_window_set_resizable", libgtk.}
proc `resizable=`*(window: Window; resizable: Gboolean) {.
    importc: "gtk_window_set_resizable", libgtk.}
proc getResizable*(window: Window): Gboolean {.
    importc: "gtk_window_get_resizable", libgtk.}
proc resizable*(window: Window): Gboolean {.
    importc: "gtk_window_get_resizable", libgtk.}
proc setGravity*(window: Window; gravity: gdk3.Gravity) {.
    importc: "gtk_window_set_gravity", libgtk.}
proc `gravity=`*(window: Window; gravity: gdk3.Gravity) {.
    importc: "gtk_window_set_gravity", libgtk.}
proc getGravity*(window: Window): gdk3.Gravity {.
    importc: "gtk_window_get_gravity", libgtk.}
proc gravity*(window: Window): gdk3.Gravity {.
    importc: "gtk_window_get_gravity", libgtk.}
proc setGeometryHints*(window: Window;
                               geometryWidget: Widget;
                               geometry: gdk3.Geometry; geomMask: gdk3.WindowHints) {.
    importc: "gtk_window_set_geometry_hints", libgtk.}
proc `geometryHints=`*(window: Window;
                               geometryWidget: Widget;
                               geometry: gdk3.Geometry; geomMask: gdk3.WindowHints) {.
    importc: "gtk_window_set_geometry_hints", libgtk.}
proc setScreen*(window: Window; screen: gdk3.Screen) {.
    importc: "gtk_window_set_screen", libgtk.}
proc `screen=`*(window: Window; screen: gdk3.Screen) {.
    importc: "gtk_window_set_screen", libgtk.}
proc getScreen*(window: Window): gdk3.Screen {.
    importc: "gtk_window_get_screen", libgtk.}
proc screen*(window: Window): gdk3.Screen {.
    importc: "gtk_window_get_screen", libgtk.}
proc isActive*(window: Window): Gboolean {.
    importc: "gtk_window_is_active", libgtk.}
proc hasToplevelFocus*(window: Window): Gboolean {.
    importc: "gtk_window_has_toplevel_focus", libgtk.}
proc setDecorated*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_decorated", libgtk.}
proc `decorated=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_decorated", libgtk.}
proc getDecorated*(window: Window): Gboolean {.
    importc: "gtk_window_get_decorated", libgtk.}
proc decorated*(window: Window): Gboolean {.
    importc: "gtk_window_get_decorated", libgtk.}
proc setDeletable*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_deletable", libgtk.}
proc `deletable=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_deletable", libgtk.}
proc getDeletable*(window: Window): Gboolean {.
    importc: "gtk_window_get_deletable", libgtk.}
proc deletable*(window: Window): Gboolean {.
    importc: "gtk_window_get_deletable", libgtk.}
proc setIconList*(window: Window; list: glib.GList) {.
    importc: "gtk_window_set_icon_list", libgtk.}
proc `iconList=`*(window: Window; list: glib.GList) {.
    importc: "gtk_window_set_icon_list", libgtk.}
proc getIconList*(window: Window): glib.GList {.
    importc: "gtk_window_get_icon_list", libgtk.}
proc iconList*(window: Window): glib.GList {.
    importc: "gtk_window_get_icon_list", libgtk.}
proc setIcon*(window: Window; icon: GdkPixbuf) {.
    importc: "gtk_window_set_icon", libgtk.}
proc `icon=`*(window: Window; icon: GdkPixbuf) {.
    importc: "gtk_window_set_icon", libgtk.}
proc setIconName*(window: Window; name: cstring) {.
    importc: "gtk_window_set_icon_name", libgtk.}
proc `iconName=`*(window: Window; name: cstring) {.
    importc: "gtk_window_set_icon_name", libgtk.}
proc setIconFromFile*(window: Window; filename: cstring;
                              err: var glib.GError): Gboolean {.
    importc: "gtk_window_set_icon_from_file", libgtk.}
proc getIcon*(window: Window): GdkPixbuf {.
    importc: "gtk_window_get_icon", libgtk.}
proc icon*(window: Window): GdkPixbuf {.
    importc: "gtk_window_get_icon", libgtk.}
proc getIconName*(window: Window): cstring {.
    importc: "gtk_window_get_icon_name", libgtk.}
proc iconName*(window: Window): cstring {.
    importc: "gtk_window_get_icon_name", libgtk.}
proc windowSetDefaultIconList*(list: glib.GList) {.
    importc: "gtk_window_set_default_icon_list", libgtk.}
proc windowGetDefaultIconList*(): glib.GList {.
    importc: "gtk_window_get_default_icon_list", libgtk.}
proc windowSetDefaultIcon*(icon: GdkPixbuf) {.
    importc: "gtk_window_set_default_icon", libgtk.}
proc windowSetDefaultIconName*(name: cstring) {.
    importc: "gtk_window_set_default_icon_name", libgtk.}
proc windowGetDefaultIconName*(): cstring {.
    importc: "gtk_window_get_default_icon_name", libgtk.}
proc windowSetDefaultIconFromFile*(filename: cstring; err: var glib.GError): Gboolean {.
    importc: "gtk_window_set_default_icon_from_file", libgtk.}
proc windowSetAutoStartupNotification*(setting: Gboolean) {.
    importc: "gtk_window_set_auto_startup_notification", libgtk.}

proc setModal*(window: Window; modal: Gboolean) {.
    importc: "gtk_window_set_modal", libgtk.}

proc `modal=`*(window: Window; modal: Gboolean) {.
    importc: "gtk_window_set_modal", libgtk.}
proc getModal*(window: Window): Gboolean {.
    importc: "gtk_window_get_modal", libgtk.}
proc modal*(window: Window): Gboolean {.
    importc: "gtk_window_get_modal", libgtk.}
proc windowListToplevels*(): glib.GList {.importc: "gtk_window_list_toplevels",
                                        libgtk.}
proc setHasUserRefCount*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_has_user_ref_count", libgtk.}
proc `hasUserRefCount=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_has_user_ref_count", libgtk.}
proc addMnemonic*(window: Window; keyval: cuint; target: Widget) {.
    importc: "gtk_window_add_mnemonic", libgtk.}
proc removeMnemonic*(window: Window; keyval: cuint;
                             target: Widget) {.
    importc: "gtk_window_remove_mnemonic", libgtk.}
proc mnemonicActivate*(window: Window; keyval: cuint;
                               modifier: gdk3.ModifierType): Gboolean {.
    importc: "gtk_window_mnemonic_activate", libgtk.}
proc setMnemonicModifier*(window: Window; modifier: gdk3.ModifierType) {.
    importc: "gtk_window_set_mnemonic_modifier", libgtk.}
proc `mnemonicModifier=`*(window: Window; modifier: gdk3.ModifierType) {.
    importc: "gtk_window_set_mnemonic_modifier", libgtk.}
proc getMnemonicModifier*(window: Window): gdk3.ModifierType {.
    importc: "gtk_window_get_mnemonic_modifier", libgtk.}
proc mnemonicModifier*(window: Window): gdk3.ModifierType {.
    importc: "gtk_window_get_mnemonic_modifier", libgtk.}
proc activateKey*(window: Window; event: gdk3.EventKey): Gboolean {.
    importc: "gtk_window_activate_key", libgtk.}
proc propagateKeyEvent*(window: Window; event: gdk3.EventKey): Gboolean {.
    importc: "gtk_window_propagate_key_event", libgtk.}
proc present*(window: Window) {.importc: "gtk_window_present",
    libgtk.}
proc presentWithTime*(window: Window; timestamp: uint32) {.
    importc: "gtk_window_present_with_time", libgtk.}
proc iconify*(window: Window) {.importc: "gtk_window_iconify",
    libgtk.}
proc deiconify*(window: Window) {.importc: "gtk_window_deiconify",
    libgtk.}
proc stick*(window: Window) {.importc: "gtk_window_stick", libgtk.}
proc unstick*(window: Window) {.importc: "gtk_window_unstick",
    libgtk.}
proc maximize*(window: Window) {.importc: "gtk_window_maximize",
    libgtk.}
proc unmaximize*(window: Window) {.importc: "gtk_window_unmaximize",
    libgtk.}
proc fullscreen*(window: Window) {.importc: "gtk_window_fullscreen",
    libgtk.}
proc unfullscreen*(window: Window) {.
    importc: "gtk_window_unfullscreen", libgtk.}
proc fullscreenOnMonitor*(window: Window; screen: gdk3.Screen;
                                  monitor: cint) {.
    importc: "gtk_window_fullscreen_on_monitor", libgtk.}
proc close*(window: Window) {.importc: "gtk_window_close", libgtk.}
proc setKeepAbove*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_keep_above", libgtk.}
proc `keepAbove=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_keep_above", libgtk.}
proc setKeepBelow*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_keep_below", libgtk.}
proc `keepBelow=`*(window: Window; setting: Gboolean) {.
    importc: "gtk_window_set_keep_below", libgtk.}
proc beginResizeDrag*(window: Window; edge: gdk3.WindowEdge;
                              button: cint; rootX: cint; rootY: cint;
                              timestamp: uint32) {.
    importc: "gtk_window_begin_resize_drag", libgtk.}
proc beginMoveDrag*(window: Window; button: cint; rootX: cint;
                            rootY: cint; timestamp: uint32) {.
    importc: "gtk_window_begin_move_drag", libgtk.}

proc setDefaultSize*(window: Window; width: cint; height: cint) {.
    importc: "gtk_window_set_default_size", libgtk.}

proc `defaultSize=`*(window: Window; width: cint; height: cint) {.
    importc: "gtk_window_set_default_size", libgtk.}
proc getDefaultSize*(window: Window; width: var cint; height: var cint) {.
    importc: "gtk_window_get_default_size", libgtk.}
proc resize*(window: Window; width: cint; height: cint) {.
    importc: "gtk_window_resize", libgtk.}
proc getSize*(window: Window; width: var cint; height: var cint) {.
    importc: "gtk_window_get_size", libgtk.}
proc move*(window: Window; x: cint; y: cint) {.
    importc: "gtk_window_move", libgtk.}
proc getPosition*(window: Window; rootX: var cint; rootY: var cint) {.
    importc: "gtk_window_get_position", libgtk.}
proc parseGeometry*(window: Window; geometry: cstring): Gboolean {.
    importc: "gtk_window_parse_geometry", libgtk.}
proc setDefaultGeometry*(window: Window; width: cint; height: cint) {.
    importc: "gtk_window_set_default_geometry", libgtk.}
proc `defaultGeometry=`*(window: Window; width: cint; height: cint) {.
    importc: "gtk_window_set_default_geometry", libgtk.}
proc resizeToGeometry*(window: Window; width: cint; height: cint) {.
    importc: "gtk_window_resize_to_geometry", libgtk.}
proc getGroup*(window: Window): WindowGroup {.
    importc: "gtk_window_get_group", libgtk.}
proc group*(window: Window): WindowGroup {.
    importc: "gtk_window_get_group", libgtk.}
proc hasGroup*(window: Window): Gboolean {.
    importc: "gtk_window_has_group", libgtk.}

proc reshowWithInitialSize*(window: Window) {.
    importc: "gtk_window_reshow_with_initial_size", libgtk.}
proc getWindowType*(window: Window): WindowType {.
    importc: "gtk_window_get_window_type", libgtk.}
proc windowType*(window: Window): WindowType {.
    importc: "gtk_window_get_window_type", libgtk.}
proc getApplication*(window: Window): Application {.
    importc: "gtk_window_get_application", libgtk.}
proc application*(window: Window): Application {.
    importc: "gtk_window_get_application", libgtk.}
proc setApplication*(window: Window; application: Application) {.
    importc: "gtk_window_set_application", libgtk.}
proc `application=`*(window: Window; application: Application) {.
    importc: "gtk_window_set_application", libgtk.}

proc setHasResizeGrip*(window: Window; value: Gboolean) {.
    importc: "gtk_window_set_has_resize_grip", libgtk.}

proc `hasResizeGrip=`*(window: Window; value: Gboolean) {.
    importc: "gtk_window_set_has_resize_grip", libgtk.}
proc getHasResizeGrip*(window: Window): Gboolean {.
    importc: "gtk_window_get_has_resize_grip", libgtk.}
proc hasResizeGrip*(window: Window): Gboolean {.
    importc: "gtk_window_get_has_resize_grip", libgtk.}
proc resizeGripIsVisible*(window: Window): Gboolean {.
    importc: "gtk_window_resize_grip_is_visible", libgtk.}
proc getResizeGripArea*(window: Window; rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_window_get_resize_grip_area", libgtk.}
proc resizeGripArea*(window: Window; rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_window_get_resize_grip_area", libgtk.}
proc setTitlebar*(window: Window; titlebar: Widget) {.
    importc: "gtk_window_set_titlebar", libgtk.}
proc `titlebar=`*(window: Window; titlebar: Widget) {.
    importc: "gtk_window_set_titlebar", libgtk.}
proc getTitlebar*(window: Window): Widget {.
    importc: "gtk_window_get_titlebar", libgtk.}
proc titlebar*(window: Window): Widget {.
    importc: "gtk_window_get_titlebar", libgtk.}
proc isMaximized*(window: Window): Gboolean {.
    importc: "gtk_window_is_maximized", libgtk.}
proc windowSetInteractiveDebugging*(enable: Gboolean) {.
    importc: "gtk_window_set_interactive_debugging", libgtk.}

type
  DialogFlags* {.size: sizeof(cint), pure.} = enum
    MODAL = 1 shl 0, DESTROY_WITH_PARENT = 1 shl 1,
    USE_HEADER_BAR = 1 shl 2

type
  ResponseType* {.size: sizeof(cint), pure.} = enum
    HELP = - 11, APPLY = - 10, NO = - 9,
    YES = - 8, CLOSE = - 7, CANCEL = - 6,
    OK = - 5, DELETE_EVENT = - 4, ACCEPT = - 3,
    REJECT = - 2, NONE = - 1

type
  Dialog* =  ptr DialogObj
  DialogPtr* = ptr DialogObj
  DialogObj* = object of WindowObj
    priv14: pointer

  DialogClass* =  ptr DialogClassObj
  DialogClassPtr* = ptr DialogClassObj
  DialogClassObj* = object of WindowClassObj
    response*: proc (dialog: Dialog; responseId: cint) {.cdecl.}
    close*: proc (dialog: Dialog) {.cdecl.}
    gtkReserved61*: proc () {.cdecl.}
    gtkReserved62*: proc () {.cdecl.}
    gtkReserved63*: proc () {.cdecl.}
    gtkReserved64*: proc () {.cdecl.}

template typeDialog*(): expr =
  (dialogGetType())

template dialog*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeDialog, DialogObj))

template dialogClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeDialog, DialogClassObj))

template isDialog*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeDialog))

template isDialogClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeDialog))

template dialogGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeDialog, DialogClassObj))

type
  AboutDialog* =  ptr AboutDialogObj
  AboutDialogPtr* = ptr AboutDialogObj
  AboutDialogObj* = object of DialogObj
    priv15: pointer

  AboutDialogClass* =  ptr AboutDialogClassObj
  AboutDialogClassPtr* = ptr AboutDialogClassObj
  AboutDialogClassObj* = object of DialogClassObj
    activateLink*: proc (dialog: AboutDialog; uri: cstring): Gboolean {.cdecl.}
    gtkReserved71*: proc () {.cdecl.}
    gtkReserved72*: proc () {.cdecl.}
    gtkReserved73*: proc () {.cdecl.}
    gtkReserved74*: proc () {.cdecl.}

proc dialogGetType*(): GType {.importc: "gtk_dialog_get_type", libgtk.}
proc newDialog*(): Dialog {.importc: "gtk_dialog_new", libgtk.}
proc newDialog*(title: cstring; parent: Window;
                             flags: DialogFlags; firstButtonText: cstring): Dialog {.
    varargs, importc: "gtk_dialog_new_with_buttons", libgtk.}
proc addActionWidget*(dialog: Dialog; child: Widget;
                              responseId: cint) {.
    importc: "gtk_dialog_add_action_widget", libgtk.}
proc addButtons*(dialog: Dialog; firstButtonText: cstring) {.varargs,
    importc: "gtk_dialog_add_buttons", libgtk.}
proc setResponseSensitive*(dialog: Dialog; responseId: cint;
                                   setting: Gboolean) {.
    importc: "gtk_dialog_set_response_sensitive", libgtk.}
proc `responseSensitive=`*(dialog: Dialog; responseId: cint;
                                   setting: Gboolean) {.
    importc: "gtk_dialog_set_response_sensitive", libgtk.}
proc setDefaultResponse*(dialog: Dialog; responseId: cint) {.
    importc: "gtk_dialog_set_default_response", libgtk.}
proc `defaultResponse=`*(dialog: Dialog; responseId: cint) {.
    importc: "gtk_dialog_set_default_response", libgtk.}
proc getWidgetForResponse*(dialog: Dialog; responseId: cint): Widget {.
    importc: "gtk_dialog_get_widget_for_response", libgtk.}
proc widgetForResponse*(dialog: Dialog; responseId: cint): Widget {.
    importc: "gtk_dialog_get_widget_for_response", libgtk.}
proc getResponseForWidget*(dialog: Dialog; widget: Widget): cint {.
    importc: "gtk_dialog_get_response_for_widget", libgtk.}
proc responseForWidget*(dialog: Dialog; widget: Widget): cint {.
    importc: "gtk_dialog_get_response_for_widget", libgtk.}
proc alternativeDialogButtonOrder*(screen: gdk3.Screen): Gboolean {.
    importc: "gtk_alternative_dialog_button_order", libgtk.}
proc setAlternativeButtonOrder*(dialog: Dialog;
                                        firstResponseId: cint) {.varargs,
    importc: "gtk_dialog_set_alternative_button_order", libgtk.}
proc `alternativeButtonOrder=`*(dialog: Dialog;
                                        firstResponseId: cint) {.varargs,
    importc: "gtk_dialog_set_alternative_button_order", libgtk.}
proc setAlternativeButtonOrderFromArray*(dialog: Dialog;
    nParams: cint; newOrder: var cint) {.importc: "gtk_dialog_set_alternative_button_order_from_array",
                                    libgtk.}
proc `alternativeButtonOrderFromArray=`*(dialog: Dialog;
    nParams: cint; newOrder: var cint) {.importc: "gtk_dialog_set_alternative_button_order_from_array",
                                    libgtk.}

proc response*(dialog: Dialog; responseId: cint) {.
    importc: "gtk_dialog_response", libgtk.}

proc run*(dialog: Dialog): cint {.importc: "gtk_dialog_run",
    libgtk.}
proc getActionArea*(dialog: Dialog): Widget {.
    importc: "gtk_dialog_get_action_area", libgtk.}
proc actionArea*(dialog: Dialog): Widget {.
    importc: "gtk_dialog_get_action_area", libgtk.}
proc getContentArea*(dialog: Dialog): Widget {.
    importc: "gtk_dialog_get_content_area", libgtk.}
proc contentArea*(dialog: Dialog): Widget {.
    importc: "gtk_dialog_get_content_area", libgtk.}

template typeAboutDialog*(): expr =
  (aboutDialogGetType())

template aboutDialog*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeAboutDialog, AboutDialogObj))

template aboutDialogClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAboutDialog, AboutDialogClassObj))

template isAboutDialog*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeAboutDialog))

template isAboutDialogClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAboutDialog))

template aboutDialogGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAboutDialog, AboutDialogClassObj))

type
  License* {.size: sizeof(cint), pure.} = enum
    UNKNOWN, CUSTOM, GPL_2_0,
    GPL_3_0, LGPL_2_1, LGPL_3_0,
    BSD, MIT_X11, ARTISTIC,
    GPL_2_0_ONLY, GPL_3_0_ONLY, LGPL_2_1_ONLY,
    LGPL_3_0_ONLY

type
  Misc* =  ptr MiscObj
  MiscPtr* = ptr MiscObj
  MiscObj* = object of WidgetObj
    priv16: pointer

  MiscClass* =  ptr MiscClassObj
  MiscClassPtr* = ptr MiscClassObj
  MiscClassObj = object of WidgetClassObj
    gtkReserved81*: proc () {.cdecl.}
    gtkReserved82*: proc () {.cdecl.}
    gtkReserved83*: proc () {.cdecl.}
    gtkReserved84*: proc () {.cdecl.}

proc aboutDialogGetType*(): GType {.importc: "gtk_about_dialog_get_type",
                                    libgtk.}
proc newAboutDialog*(): AboutDialog {.importc: "gtk_about_dialog_new",
                                       libgtk.}
proc showAboutDialog*(parent: Window; firstPropertyName: cstring) {.varargs,
    importc: "gtk_show_about_dialog", libgtk.}
proc getProgramName*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_program_name", libgtk.}
proc programName*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_program_name", libgtk.}
proc setProgramName*(about: AboutDialog; name: cstring) {.
    importc: "gtk_about_dialog_set_program_name", libgtk.}
proc `programName=`*(about: AboutDialog; name: cstring) {.
    importc: "gtk_about_dialog_set_program_name", libgtk.}
proc getVersion*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_version", libgtk.}
proc version*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_version", libgtk.}
proc setVersion*(about: AboutDialog; version: cstring) {.
    importc: "gtk_about_dialog_set_version", libgtk.}
proc `version=`*(about: AboutDialog; version: cstring) {.
    importc: "gtk_about_dialog_set_version", libgtk.}
proc getCopyright*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_copyright", libgtk.}
proc copyright*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_copyright", libgtk.}
proc setCopyright*(about: AboutDialog; copyright: cstring) {.
    importc: "gtk_about_dialog_set_copyright", libgtk.}
proc `copyright=`*(about: AboutDialog; copyright: cstring) {.
    importc: "gtk_about_dialog_set_copyright", libgtk.}
proc getComments*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_comments", libgtk.}
proc comments*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_comments", libgtk.}
proc setComments*(about: AboutDialog; comments: cstring) {.
    importc: "gtk_about_dialog_set_comments", libgtk.}
proc `comments=`*(about: AboutDialog; comments: cstring) {.
    importc: "gtk_about_dialog_set_comments", libgtk.}
proc getLicense*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_license", libgtk.}
proc license*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_license", libgtk.}
proc setLicense*(about: AboutDialog; license: cstring) {.
    importc: "gtk_about_dialog_set_license", libgtk.}
proc `license=`*(about: AboutDialog; license: cstring) {.
    importc: "gtk_about_dialog_set_license", libgtk.}
proc setLicenseType*(about: AboutDialog;
                                  licenseType: License) {.
    importc: "gtk_about_dialog_set_license_type", libgtk.}
proc `licenseType=`*(about: AboutDialog;
                                  licenseType: License) {.
    importc: "gtk_about_dialog_set_license_type", libgtk.}
proc getLicenseType*(about: AboutDialog): License {.
    importc: "gtk_about_dialog_get_license_type", libgtk.}
proc licenseType*(about: AboutDialog): License {.
    importc: "gtk_about_dialog_get_license_type", libgtk.}
proc getWrapLicense*(about: AboutDialog): Gboolean {.
    importc: "gtk_about_dialog_get_wrap_license", libgtk.}
proc wrapLicense*(about: AboutDialog): Gboolean {.
    importc: "gtk_about_dialog_get_wrap_license", libgtk.}
proc setWrapLicense*(about: AboutDialog; wrapLicense: Gboolean) {.
    importc: "gtk_about_dialog_set_wrap_license", libgtk.}
proc `wrapLicense=`*(about: AboutDialog; wrapLicense: Gboolean) {.
    importc: "gtk_about_dialog_set_wrap_license", libgtk.}
proc getWebsite*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_website", libgtk.}
proc website*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_website", libgtk.}
proc setWebsite*(about: AboutDialog; website: cstring) {.
    importc: "gtk_about_dialog_set_website", libgtk.}
proc `website=`*(about: AboutDialog; website: cstring) {.
    importc: "gtk_about_dialog_set_website", libgtk.}
proc getWebsiteLabel*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_website_label", libgtk.}
proc websiteLabel*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_website_label", libgtk.}
proc setWebsiteLabel*(about: AboutDialog; websiteLabel: cstring) {.
    importc: "gtk_about_dialog_set_website_label", libgtk.}
proc `websiteLabel=`*(about: AboutDialog; websiteLabel: cstring) {.
    importc: "gtk_about_dialog_set_website_label", libgtk.}
proc getAuthors*(about: AboutDialog): cstringArray {.
    importc: "gtk_about_dialog_get_authors", libgtk.}
proc authors*(about: AboutDialog): cstringArray {.
    importc: "gtk_about_dialog_get_authors", libgtk.}
proc setAuthors*(about: AboutDialog; authors: cstringArray) {.
    importc: "gtk_about_dialog_set_authors", libgtk.}
proc `authors=`*(about: AboutDialog; authors: cstringArray) {.
    importc: "gtk_about_dialog_set_authors", libgtk.}
proc getDocumenters*(about: AboutDialog): cstringArray {.
    importc: "gtk_about_dialog_get_documenters", libgtk.}
proc documenters*(about: AboutDialog): cstringArray {.
    importc: "gtk_about_dialog_get_documenters", libgtk.}
proc setDocumenters*(about: AboutDialog;
                                  documenters: cstringArray) {.
    importc: "gtk_about_dialog_set_documenters", libgtk.}
proc `documenters=`*(about: AboutDialog;
                                  documenters: cstringArray) {.
    importc: "gtk_about_dialog_set_documenters", libgtk.}
proc getArtists*(about: AboutDialog): cstringArray {.
    importc: "gtk_about_dialog_get_artists", libgtk.}
proc artists*(about: AboutDialog): cstringArray {.
    importc: "gtk_about_dialog_get_artists", libgtk.}
proc setArtists*(about: AboutDialog; artists: cstringArray) {.
    importc: "gtk_about_dialog_set_artists", libgtk.}
proc `artists=`*(about: AboutDialog; artists: cstringArray) {.
    importc: "gtk_about_dialog_set_artists", libgtk.}
proc getTranslatorCredits*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_translator_credits", libgtk.}
proc translatorCredits*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_translator_credits", libgtk.}
proc setTranslatorCredits*(about: AboutDialog;
                                        translatorCredits: cstring) {.
    importc: "gtk_about_dialog_set_translator_credits", libgtk.}
proc `translatorCredits=`*(about: AboutDialog;
                                        translatorCredits: cstring) {.
    importc: "gtk_about_dialog_set_translator_credits", libgtk.}
proc getLogo*(about: AboutDialog): GdkPixbuf {.
    importc: "gtk_about_dialog_get_logo", libgtk.}
proc logo*(about: AboutDialog): GdkPixbuf {.
    importc: "gtk_about_dialog_get_logo", libgtk.}
proc setLogo*(about: AboutDialog; logo: GdkPixbuf) {.
    importc: "gtk_about_dialog_set_logo", libgtk.}
proc `logo=`*(about: AboutDialog; logo: GdkPixbuf) {.
    importc: "gtk_about_dialog_set_logo", libgtk.}
proc getLogoIconName*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_logo_icon_name", libgtk.}
proc logoIconName*(about: AboutDialog): cstring {.
    importc: "gtk_about_dialog_get_logo_icon_name", libgtk.}
proc setLogoIconName*(about: AboutDialog; iconName: cstring) {.
    importc: "gtk_about_dialog_set_logo_icon_name", libgtk.}
proc `logoIconName=`*(about: AboutDialog; iconName: cstring) {.
    importc: "gtk_about_dialog_set_logo_icon_name", libgtk.}
proc addCreditSection*(about: AboutDialog;
                                    sectionName: cstring; people: cstringArray) {.
    importc: "gtk_about_dialog_add_credit_section", libgtk.}

template typeMisc*(): expr =
  (miscGetType())

template misc*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeMisc, MiscObj))

template miscClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeMisc, MiscClassObj))

template isMisc*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeMisc))

template isMiscClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeMisc))

template miscGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeMisc, MiscClassObj))

type
  MenuShell* =  ptr MenuShellObj
  MenuShellPtr* = ptr MenuShellObj
  MenuShellObj* = object of ContainerObj
    priv17: pointer

  MenuShellClass* =  ptr MenuShellClassObj
  MenuShellClassPtr* = ptr MenuShellClassObj
  MenuShellClassObj = object of ContainerClassObj
    submenuPlacement* {.bitsize: 1.}: cuint
    deactivate*: proc (menuShell: MenuShell) {.cdecl.}
    selectionDone*: proc (menuShell: MenuShell) {.cdecl.}
    moveCurrent*: proc (menuShell: MenuShell; direction: MenuDirectionType) {.cdecl.}
    activateCurrent*: proc (menuShell: MenuShell; forceHide: Gboolean) {.cdecl.}
    cancel*: proc (menuShell: MenuShell) {.cdecl.}
    selectItem*: proc (menuShell: MenuShell; menuItem: Widget) {.cdecl.}
    insert*: proc (menuShell: MenuShell; child: Widget; position: cint) {.cdecl.}
    getPopupDelay*: proc (menuShell: MenuShell): cint {.cdecl.}
    moveSelected*: proc (menuShell: MenuShell; distance: cint): Gboolean {.cdecl.}
    gtkReserved91*: proc () {.cdecl.}
    gtkReserved92*: proc () {.cdecl.}
    gtkReserved93*: proc () {.cdecl.}
    gtkReserved94*: proc () {.cdecl.}

proc miscGetType*(): GType {.importc: "gtk_misc_get_type", libgtk.}
proc setAlignment*(misc: Misc; xalign: cfloat; yalign: cfloat) {.
    importc: "gtk_misc_set_alignment", libgtk.}
proc `alignment=`*(misc: Misc; xalign: cfloat; yalign: cfloat) {.
    importc: "gtk_misc_set_alignment", libgtk.}
proc getAlignment*(misc: Misc; xalign: var cfloat; yalign: var cfloat) {.
    importc: "gtk_misc_get_alignment", libgtk.}
proc setPadding*(misc: Misc; xpad: cint; ypad: cint) {.
    importc: "gtk_misc_set_padding", libgtk.}
proc `padding=`*(misc: Misc; xpad: cint; ypad: cint) {.
    importc: "gtk_misc_set_padding", libgtk.}
proc getPadding*(misc: Misc; xpad: var cint; ypad: var cint) {.
    importc: "gtk_misc_get_padding", libgtk.}

discard """ proc "getPaddingAndBorder*(misc: Misc; border: Border) {.
    importc: "_gtk_misc_get_padding_and_border", libgtk.}"""

template typeMenuShell*(): expr =
  (menuShellGetType())

template menuShell*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeMenuShell, MenuShellObj))

template menuShellClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeMenuShell, MenuShellClassObj))

template isMenuShell*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeMenuShell))

template isMenuShellClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeMenuShell))

template menuShellGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeMenuShell, MenuShellClassObj))

type
  Menu* =  ptr MenuObj
  MenuPtr* = ptr MenuObj
  MenuObj* = object of MenuShellObj
    priv18: pointer

  MenuClass* =  ptr MenuClassObj
  MenuClassPtr* = ptr MenuClassObj
  MenuClassObj = object of MenuShellClassObj
    gtkReserved101*: proc () {.cdecl.}
    gtkReserved102*: proc () {.cdecl.}
    gtkReserved103*: proc () {.cdecl.}
    gtkReserved104*: proc () {.cdecl.}

proc menuShellGetType*(): GType {.importc: "gtk_menu_shell_get_type", libgtk.}
proc append*(menuShell: MenuShell; child: Widget) {.
    importc: "gtk_menu_shell_append", libgtk.}
proc prepend*(menuShell: MenuShell; child: Widget) {.
    importc: "gtk_menu_shell_prepend", libgtk.}
proc insert*(menuShell: MenuShell; child: Widget;
                        position: cint) {.importc: "gtk_menu_shell_insert",
                                        libgtk.}
proc deactivate*(menuShell: MenuShell) {.
    importc: "gtk_menu_shell_deactivate", libgtk.}
proc selectItem*(menuShell: MenuShell; menuItem: Widget) {.
    importc: "gtk_menu_shell_select_item", libgtk.}
proc deselect*(menuShell: MenuShell) {.
    importc: "gtk_menu_shell_deselect", libgtk.}
proc activateItem*(menuShell: MenuShell; menuItem: Widget;
                              forceDeactivate: Gboolean) {.
    importc: "gtk_menu_shell_activate_item", libgtk.}
proc selectFirst*(menuShell: MenuShell; searchSensitive: Gboolean) {.
    importc: "gtk_menu_shell_select_first", libgtk.}
proc cancel*(menuShell: MenuShell) {.
    importc: "gtk_menu_shell_cancel", libgtk.}
proc getTakeFocus*(menuShell: MenuShell): Gboolean {.
    importc: "gtk_menu_shell_get_take_focus", libgtk.}
proc takeFocus*(menuShell: MenuShell): Gboolean {.
    importc: "gtk_menu_shell_get_take_focus", libgtk.}
proc setTakeFocus*(menuShell: MenuShell; takeFocus: Gboolean) {.
    importc: "gtk_menu_shell_set_take_focus", libgtk.}
proc `takeFocus=`*(menuShell: MenuShell; takeFocus: Gboolean) {.
    importc: "gtk_menu_shell_set_take_focus", libgtk.}
proc bindModel*(menuShell: MenuShell; model: gio.GMenuModel;
                           actionNamespace: cstring; withSeparators: Gboolean) {.
    importc: "gtk_menu_shell_bind_model", libgtk.}

template typeMenu*(): expr =
  (menuGetType())

template menu*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeMenu, MenuObj))

template menuClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeMenu, MenuClassObj))

template isMenu*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeMenu))

template isMenuClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeMenu))

template menuGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeMenu, MenuClassObj))

type
  ArrowPlacement* {.size: sizeof(cint), pure.} = enum
    BOTH, START, END

type
  MenuPositionFunc* = proc (menu: Menu; x: var cint; y: var cint;
                            pushIn: var Gboolean; userData: Gpointer) {.cdecl.}

type
  MenuDetachFunc* = proc (attachWidget: Widget; menu: Menu) {.cdecl.}
  Label* =  ptr LabelObj
  LabelPtr* = ptr LabelObj
  LabelObj* = object of MiscObj
    priv19: pointer

  LabelClass* =  ptr LabelClassObj
  LabelClassPtr* = ptr LabelClassObj
  LabelClassObj = object of MiscClassObj
    moveCursor*: proc (label: Label; step: MovementStep; count: cint;
                     extendSelection: Gboolean) {.cdecl.}
    copyClipboard*: proc (label: Label) {.cdecl.}
    populatePopup*: proc (label: Label; menu: Menu) {.cdecl.}
    activateLink*: proc (label: Label; uri: cstring): Gboolean {.cdecl.}
    gtkReserved111*: proc () {.cdecl.}
    gtkReserved112*: proc () {.cdecl.}
    gtkReserved113*: proc () {.cdecl.}
    gtkReserved114*: proc () {.cdecl.}
    gtkReserved115*: proc () {.cdecl.}
    gtkReserved116*: proc () {.cdecl.}
    gtkReserved117*: proc () {.cdecl.}
    gtkReserved118*: proc () {.cdecl.}

proc menuGetType*(): GType {.importc: "gtk_menu_get_type", libgtk.}
proc newMenu*(): Menu {.importc: "gtk_menu_new", libgtk.}

proc popup*(menu: Menu; parentMenuShell: Widget;
                  parentMenuItem: Widget; `func`: MenuPositionFunc;
                  data: Gpointer; button: cuint; activateTime: uint32) {.
    importc: "gtk_menu_popup", libgtk.}
proc popupForDevice*(menu: Menu; device: gdk3.Device;
                           parentMenuShell: Widget;
                           parentMenuItem: Widget;
                           `func`: MenuPositionFunc; data: Gpointer;
                           destroy: GDestroyNotify; button: cuint;
                           activateTime: uint32) {.
    importc: "gtk_menu_popup_for_device", libgtk.}

proc reposition*(menu: Menu) {.importc: "gtk_menu_reposition",
    libgtk.}
proc popdown*(menu: Menu) {.importc: "gtk_menu_popdown", libgtk.}

proc getActive*(menu: Menu): Widget {.
    importc: "gtk_menu_get_active", libgtk.}

proc active*(menu: Menu): Widget {.
    importc: "gtk_menu_get_active", libgtk.}
proc setActive*(menu: Menu; index: cuint) {.
    importc: "gtk_menu_set_active", libgtk.}
proc `active=`*(menu: Menu; index: cuint) {.
    importc: "gtk_menu_set_active", libgtk.}

proc setAccelGroup*(menu: Menu; accelGroup: AccelGroup) {.
    importc: "gtk_menu_set_accel_group", libgtk.}

proc `accelGroup=`*(menu: Menu; accelGroup: AccelGroup) {.
    importc: "gtk_menu_set_accel_group", libgtk.}
proc getAccelGroup*(menu: Menu): AccelGroup {.
    importc: "gtk_menu_get_accel_group", libgtk.}
proc accelGroup*(menu: Menu): AccelGroup {.
    importc: "gtk_menu_get_accel_group", libgtk.}
proc setAccelPath*(menu: Menu; accelPath: cstring) {.
    importc: "gtk_menu_set_accel_path", libgtk.}
proc `accelPath=`*(menu: Menu; accelPath: cstring) {.
    importc: "gtk_menu_set_accel_path", libgtk.}
proc getAccelPath*(menu: Menu): cstring {.
    importc: "gtk_menu_get_accel_path", libgtk.}
proc accelPath*(menu: Menu): cstring {.
    importc: "gtk_menu_get_accel_path", libgtk.}

proc attachToWidget*(menu: Menu; attachWidget: Widget;
                           detacher: MenuDetachFunc) {.
    importc: "gtk_menu_attach_to_widget", libgtk.}
proc detach*(menu: Menu) {.importc: "gtk_menu_detach", libgtk.}

proc getAttachWidget*(menu: Menu): Widget {.
    importc: "gtk_menu_get_attach_widget", libgtk.}

proc attachWidget*(menu: Menu): Widget {.
    importc: "gtk_menu_get_attach_widget", libgtk.}
proc setTearoffState*(menu: Menu; tornOff: Gboolean) {.
    importc: "gtk_menu_set_tearoff_state", libgtk.}
proc `tearoffState=`*(menu: Menu; tornOff: Gboolean) {.
    importc: "gtk_menu_set_tearoff_state", libgtk.}
proc getTearoffState*(menu: Menu): Gboolean {.
    importc: "gtk_menu_get_tearoff_state", libgtk.}
proc tearoffState*(menu: Menu): Gboolean {.
    importc: "gtk_menu_get_tearoff_state", libgtk.}

proc setTitle*(menu: Menu; title: cstring) {.
    importc: "gtk_menu_set_title", libgtk.}

proc `title=`*(menu: Menu; title: cstring) {.
    importc: "gtk_menu_set_title", libgtk.}
proc getTitle*(menu: Menu): cstring {.importc: "gtk_menu_get_title",
    libgtk.}
proc title*(menu: Menu): cstring {.importc: "gtk_menu_get_title",
    libgtk.}
proc reorderChild*(menu: Menu; child: Widget; position: cint) {.
    importc: "gtk_menu_reorder_child", libgtk.}
proc setScreen*(menu: Menu; screen: gdk3.Screen) {.
    importc: "gtk_menu_set_screen", libgtk.}
proc `screen=`*(menu: Menu; screen: gdk3.Screen) {.
    importc: "gtk_menu_set_screen", libgtk.}
proc attach*(menu: Menu; child: Widget; leftAttach: cuint;
                   rightAttach: cuint; topAttach: cuint; bottomAttach: cuint) {.
    importc: "gtk_menu_attach", libgtk.}
proc setMonitor*(menu: Menu; monitorNum: cint) {.
    importc: "gtk_menu_set_monitor", libgtk.}
proc `monitor=`*(menu: Menu; monitorNum: cint) {.
    importc: "gtk_menu_set_monitor", libgtk.}
proc getMonitor*(menu: Menu): cint {.importc: "gtk_menu_get_monitor",
    libgtk.}
proc monitor*(menu: Menu): cint {.importc: "gtk_menu_get_monitor",
    libgtk.}
proc menuGetForAttachWidget*(widget: Widget): glib.GList {.
    importc: "gtk_menu_get_for_attach_widget", libgtk.}
proc setReserveToggleSize*(menu: Menu; reserveToggleSize: Gboolean) {.
    importc: "gtk_menu_set_reserve_toggle_size", libgtk.}
proc `reserveToggleSize=`*(menu: Menu; reserveToggleSize: Gboolean) {.
    importc: "gtk_menu_set_reserve_toggle_size", libgtk.}
proc getReserveToggleSize*(menu: Menu): Gboolean {.
    importc: "gtk_menu_get_reserve_toggle_size", libgtk.}
proc reserveToggleSize*(menu: Menu): Gboolean {.
    importc: "gtk_menu_get_reserve_toggle_size", libgtk.}

template typeLabel*(): expr =
  (labelGetType())

template label*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeLabel, LabelObj))

template labelClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeLabel, LabelClassObj))

template isLabel*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeLabel))

template isLabelClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeLabel))

template labelGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeLabel, LabelClassObj))

type
  LabelSelectionInfo* =  ptr LabelSelectionInfoObj
  LabelSelectionInfoPtr* = ptr LabelSelectionInfoObj
  LabelSelectionInfoObj* = object

  AccelLabel* =  ptr AccelLabelObj
  AccelLabelPtr* = ptr AccelLabelObj
  AccelLabelObj* = object
    label*: LabelObj
    priv20: pointer

  AccelLabelClass* =  ptr AccelLabelClassObj
  AccelLabelClassPtr* = ptr AccelLabelClassObj
  AccelLabelClassObj*{.final.} = object of LabelClassObj
    signalQuote1*: cstring
    signalQuote2*: cstring
    modNameShift*: cstring
    modNameControl*: cstring
    modNameAlt*: cstring
    modSeparator*: cstring
    gtkReserved121*: proc () {.cdecl.}
    gtkReserved122*: proc () {.cdecl.}
    gtkReserved123*: proc () {.cdecl.}
    gtkReserved124*: proc () {.cdecl.}

proc labelGetType*(): GType {.importc: "gtk_label_get_type", libgtk.}
proc newLabel*(str: cstring): Label {.importc: "gtk_label_new", libgtk.}
proc newLabelWithMnemonic*(str: cstring): Label {.
    importc: "gtk_label_new_with_mnemonic", libgtk.}
proc setText*(label: Label; str: cstring) {.
    importc: "gtk_label_set_text", libgtk.}
proc `text=`*(label: Label; str: cstring) {.
    importc: "gtk_label_set_text", libgtk.}
proc getText*(label: Label): cstring {.importc: "gtk_label_get_text",
    libgtk.}
proc text*(label: Label): cstring {.importc: "gtk_label_get_text",
    libgtk.}
proc setAttributes*(label: Label; attrs: pango.AttrList) {.
    importc: "gtk_label_set_attributes", libgtk.}
proc `attributes=`*(label: Label; attrs: pango.AttrList) {.
    importc: "gtk_label_set_attributes", libgtk.}
proc getAttributes*(label: Label): pango.AttrList {.
    importc: "gtk_label_get_attributes", libgtk.}
proc attributes*(label: Label): pango.AttrList {.
    importc: "gtk_label_get_attributes", libgtk.}
proc setLabel*(label: Label; str: cstring) {.
    importc: "gtk_label_set_label", libgtk.}
proc `label=`*(label: Label; str: cstring) {.
    importc: "gtk_label_set_label", libgtk.}
proc getLabel*(label: Label): cstring {.
    importc: "gtk_label_get_label", libgtk.}
proc label*(label: Label): cstring {.
    importc: "gtk_label_get_label", libgtk.}
proc setMarkup*(label: Label; str: cstring) {.
    importc: "gtk_label_set_markup", libgtk.}
proc `markup=`*(label: Label; str: cstring) {.
    importc: "gtk_label_set_markup", libgtk.}
proc setUseMarkup*(label: Label; setting: Gboolean) {.
    importc: "gtk_label_set_use_markup", libgtk.}
proc `useMarkup=`*(label: Label; setting: Gboolean) {.
    importc: "gtk_label_set_use_markup", libgtk.}
proc getUseMarkup*(label: Label): Gboolean {.
    importc: "gtk_label_get_use_markup", libgtk.}
proc useMarkup*(label: Label): Gboolean {.
    importc: "gtk_label_get_use_markup", libgtk.}
proc setUseUnderline*(label: Label; setting: Gboolean) {.
    importc: "gtk_label_set_use_underline", libgtk.}
proc `useUnderline=`*(label: Label; setting: Gboolean) {.
    importc: "gtk_label_set_use_underline", libgtk.}
proc getUseUnderline*(label: Label): Gboolean {.
    importc: "gtk_label_get_use_underline", libgtk.}
proc useUnderline*(label: Label): Gboolean {.
    importc: "gtk_label_get_use_underline", libgtk.}
proc setMarkupWithMnemonic*(label: Label; str: cstring) {.
    importc: "gtk_label_set_markup_with_mnemonic", libgtk.}
proc `markupWithMnemonic=`*(label: Label; str: cstring) {.
    importc: "gtk_label_set_markup_with_mnemonic", libgtk.}
proc getMnemonicKeyval*(label: Label): cuint {.
    importc: "gtk_label_get_mnemonic_keyval", libgtk.}
proc mnemonicKeyval*(label: Label): cuint {.
    importc: "gtk_label_get_mnemonic_keyval", libgtk.}
proc setMnemonicWidget*(label: Label; widget: Widget) {.
    importc: "gtk_label_set_mnemonic_widget", libgtk.}
proc `mnemonicWidget=`*(label: Label; widget: Widget) {.
    importc: "gtk_label_set_mnemonic_widget", libgtk.}
proc getMnemonicWidget*(label: Label): Widget {.
    importc: "gtk_label_get_mnemonic_widget", libgtk.}
proc mnemonicWidget*(label: Label): Widget {.
    importc: "gtk_label_get_mnemonic_widget", libgtk.}
proc setTextWithMnemonic*(label: Label; str: cstring) {.
    importc: "gtk_label_set_text_with_mnemonic", libgtk.}
proc `textWithMnemonic=`*(label: Label; str: cstring) {.
    importc: "gtk_label_set_text_with_mnemonic", libgtk.}
proc setJustify*(label: Label; jtype: Justification) {.
    importc: "gtk_label_set_justify", libgtk.}
proc `justify=`*(label: Label; jtype: Justification) {.
    importc: "gtk_label_set_justify", libgtk.}
proc getJustify*(label: Label): Justification {.
    importc: "gtk_label_get_justify", libgtk.}
proc justify*(label: Label): Justification {.
    importc: "gtk_label_get_justify", libgtk.}
proc setEllipsize*(label: Label; mode: pango.EllipsizeMode) {.
    importc: "gtk_label_set_ellipsize", libgtk.}
proc `ellipsize=`*(label: Label; mode: pango.EllipsizeMode) {.
    importc: "gtk_label_set_ellipsize", libgtk.}
proc getEllipsize*(label: Label): pango.EllipsizeMode {.
    importc: "gtk_label_get_ellipsize", libgtk.}
proc ellipsize*(label: Label): pango.EllipsizeMode {.
    importc: "gtk_label_get_ellipsize", libgtk.}
proc setWidthChars*(label: Label; nChars: cint) {.
    importc: "gtk_label_set_width_chars", libgtk.}
proc `widthChars=`*(label: Label; nChars: cint) {.
    importc: "gtk_label_set_width_chars", libgtk.}
proc getWidthChars*(label: Label): cint {.
    importc: "gtk_label_get_width_chars", libgtk.}
proc widthChars*(label: Label): cint {.
    importc: "gtk_label_get_width_chars", libgtk.}
proc setMaxWidthChars*(label: Label; nChars: cint) {.
    importc: "gtk_label_set_max_width_chars", libgtk.}
proc `maxWidthChars=`*(label: Label; nChars: cint) {.
    importc: "gtk_label_set_max_width_chars", libgtk.}
proc getMaxWidthChars*(label: Label): cint {.
    importc: "gtk_label_get_max_width_chars", libgtk.}
proc maxWidthChars*(label: Label): cint {.
    importc: "gtk_label_get_max_width_chars", libgtk.}
proc setLines*(label: Label; lines: cint) {.
    importc: "gtk_label_set_lines", libgtk.}
proc `lines=`*(label: Label; lines: cint) {.
    importc: "gtk_label_set_lines", libgtk.}
proc getLines*(label: Label): cint {.importc: "gtk_label_get_lines",
    libgtk.}
proc lines*(label: Label): cint {.importc: "gtk_label_get_lines",
    libgtk.}
proc setPattern*(label: Label; pattern: cstring) {.
    importc: "gtk_label_set_pattern", libgtk.}
proc `pattern=`*(label: Label; pattern: cstring) {.
    importc: "gtk_label_set_pattern", libgtk.}
proc setLineWrap*(label: Label; wrap: Gboolean) {.
    importc: "gtk_label_set_line_wrap", libgtk.}
proc `lineWrap=`*(label: Label; wrap: Gboolean) {.
    importc: "gtk_label_set_line_wrap", libgtk.}
proc getLineWrap*(label: Label): Gboolean {.
    importc: "gtk_label_get_line_wrap", libgtk.}
proc lineWrap*(label: Label): Gboolean {.
    importc: "gtk_label_get_line_wrap", libgtk.}
proc setLineWrapMode*(label: Label; wrapMode: pango.WrapMode) {.
    importc: "gtk_label_set_line_wrap_mode", libgtk.}
proc `lineWrapMode=`*(label: Label; wrapMode: pango.WrapMode) {.
    importc: "gtk_label_set_line_wrap_mode", libgtk.}
proc getLineWrapMode*(label: Label): pango.WrapMode {.
    importc: "gtk_label_get_line_wrap_mode", libgtk.}
proc lineWrapMode*(label: Label): pango.WrapMode {.
    importc: "gtk_label_get_line_wrap_mode", libgtk.}
proc setSelectable*(label: Label; setting: Gboolean) {.
    importc: "gtk_label_set_selectable", libgtk.}
proc `selectable=`*(label: Label; setting: Gboolean) {.
    importc: "gtk_label_set_selectable", libgtk.}
proc getSelectable*(label: Label): Gboolean {.
    importc: "gtk_label_get_selectable", libgtk.}
proc selectable*(label: Label): Gboolean {.
    importc: "gtk_label_get_selectable", libgtk.}
proc setAngle*(label: Label; angle: cdouble) {.
    importc: "gtk_label_set_angle", libgtk.}
proc `angle=`*(label: Label; angle: cdouble) {.
    importc: "gtk_label_set_angle", libgtk.}
proc getAngle*(label: Label): cdouble {.
    importc: "gtk_label_get_angle", libgtk.}
proc angle*(label: Label): cdouble {.
    importc: "gtk_label_get_angle", libgtk.}
proc selectRegion*(label: Label; startOffset: cint; endOffset: cint) {.
    importc: "gtk_label_select_region", libgtk.}
proc getSelectionBounds*(label: Label; start: var cint; `end`: var cint): Gboolean {.
    importc: "gtk_label_get_selection_bounds", libgtk.}
proc selectionBounds*(label: Label; start: var cint; `end`: var cint): Gboolean {.
    importc: "gtk_label_get_selection_bounds", libgtk.}
proc getLayout*(label: Label): pango.Layout {.
    importc: "gtk_label_get_layout", libgtk.}
proc layout*(label: Label): pango.Layout {.
    importc: "gtk_label_get_layout", libgtk.}
proc getLayoutOffsets*(label: Label; x: var cint; y: var cint) {.
    importc: "gtk_label_get_layout_offsets", libgtk.}
proc setSingleLineMode*(label: Label; singleLineMode: Gboolean) {.
    importc: "gtk_label_set_single_line_mode", libgtk.}
proc `singleLineMode=`*(label: Label; singleLineMode: Gboolean) {.
    importc: "gtk_label_set_single_line_mode", libgtk.}
proc getSingleLineMode*(label: Label): Gboolean {.
    importc: "gtk_label_get_single_line_mode", libgtk.}
proc singleLineMode*(label: Label): Gboolean {.
    importc: "gtk_label_get_single_line_mode", libgtk.}
proc getCurrentUri*(label: Label): cstring {.
    importc: "gtk_label_get_current_uri", libgtk.}
proc currentUri*(label: Label): cstring {.
    importc: "gtk_label_get_current_uri", libgtk.}
proc setTrackVisitedLinks*(label: Label; trackLinks: Gboolean) {.
    importc: "gtk_label_set_track_visited_links", libgtk.}
proc `trackVisitedLinks=`*(label: Label; trackLinks: Gboolean) {.
    importc: "gtk_label_set_track_visited_links", libgtk.}
proc getTrackVisitedLinks*(label: Label): Gboolean {.
    importc: "gtk_label_get_track_visited_links", libgtk.}
proc trackVisitedLinks*(label: Label): Gboolean {.
    importc: "gtk_label_get_track_visited_links", libgtk.}
proc setXalign*(label: Label; xalign: cfloat) {.
    importc: "gtk_label_set_xalign", libgtk.}
proc `xalign=`*(label: Label; xalign: cfloat) {.
    importc: "gtk_label_set_xalign", libgtk.}
proc getXalign*(label: Label): cfloat {.
    importc: "gtk_label_get_xalign", libgtk.}
proc xalign*(label: Label): cfloat {.
    importc: "gtk_label_get_xalign", libgtk.}
proc setYalign*(label: Label; yalign: cfloat) {.
    importc: "gtk_label_set_yalign", libgtk.}
proc `yalign=`*(label: Label; yalign: cfloat) {.
    importc: "gtk_label_set_yalign", libgtk.}
proc getYalign*(label: Label): cfloat {.
    importc: "gtk_label_get_yalign", libgtk.}
proc yalign*(label: Label): cfloat {.
    importc: "gtk_label_get_yalign", libgtk.}

template typeAccelLabel*(): expr =
  (accelLabelGetType())

template accelLabel*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeAccelLabel, AccelLabelObj))

template accelLabelClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAccelLabel, AccelLabelClassObj))

template isAccelLabel*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeAccelLabel))

template isAccelLabelClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAccelLabel))

template accelLabelGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAccelLabel, AccelLabelClassObj))

type
  Accessible* =  ptr AccessibleObj
  AccessiblePtr* = ptr AccessibleObj
  AccessibleObj = object of atk.ObjectObj
    priv21: pointer

  AccessibleClass* =  ptr AccessibleClassObj
  AccessibleClassPtr* = ptr AccessibleClassObj
  AccessibleClassObj = object of atk.ObjectClassObj
    connectWidgetDestroyed*: proc (accessible: Accessible) {.cdecl.}
    widgetSet*: proc (accessible: Accessible) {.cdecl.}
    widgetUnset*: proc (accessible: Accessible) {.cdecl.}
    gtkReserved133*: proc () {.cdecl.}
    gtkReserved134*: proc () {.cdecl.}

  AccelMap* =  ptr AccelMapObj
  AccelMapPtr* = ptr AccelMapObj
  AccelMapObj* = object

  AccelMapClass* =  ptr AccelMapClassObj
  AccelMapClassPtr* = ptr AccelMapClassObj
  AccelMapClassObj* = object

proc accelLabelGetType*(): GType {.importc: "gtk_accel_label_get_type",
                                   libgtk.}
proc newAccelLabel*(string: cstring): AccelLabel {.
    importc: "gtk_accel_label_new", libgtk.}
proc getAccelWidget*(accelLabel: AccelLabel): Widget {.
    importc: "gtk_accel_label_get_accel_widget", libgtk.}
proc accelWidget*(accelLabel: AccelLabel): Widget {.
    importc: "gtk_accel_label_get_accel_widget", libgtk.}
proc getAccelWidth*(accelLabel: AccelLabel): cuint {.
    importc: "gtk_accel_label_get_accel_width", libgtk.}
proc accelWidth*(accelLabel: AccelLabel): cuint {.
    importc: "gtk_accel_label_get_accel_width", libgtk.}
proc setAccelWidget*(accelLabel: AccelLabel;
                                 accelWidget: Widget) {.
    importc: "gtk_accel_label_set_accel_widget", libgtk.}
proc `accelWidget=`*(accelLabel: AccelLabel;
                                 accelWidget: Widget) {.
    importc: "gtk_accel_label_set_accel_widget", libgtk.}
proc setAccelClosure*(accelLabel: AccelLabel;
                                  accelClosure: gobject.GClosure) {.
    importc: "gtk_accel_label_set_accel_closure", libgtk.}
proc `accelClosure=`*(accelLabel: AccelLabel;
                                  accelClosure: gobject.GClosure) {.
    importc: "gtk_accel_label_set_accel_closure", libgtk.}
proc refetch*(accelLabel: AccelLabel): Gboolean {.
    importc: "gtk_accel_label_refetch", libgtk.}
proc setAccel*(accelLabel: AccelLabel; acceleratorKey: cuint;
                           acceleratorMods: gdk3.ModifierType) {.
    importc: "gtk_accel_label_set_accel", libgtk.}
proc `accel=`*(accelLabel: AccelLabel; acceleratorKey: cuint;
                           acceleratorMods: gdk3.ModifierType) {.
    importc: "gtk_accel_label_set_accel", libgtk.}
proc getAccel*(accelLabel: AccelLabel;
                           acceleratorKey: var cuint;
                           acceleratorMods: ptr gdk3.ModifierType) {.
    importc: "gtk_accel_label_get_accel", libgtk.}

discard """ proc "getAcceleratorLabel*(klass: AccelLabelClass;
    acceleratorKey: cuint; acceleratorMods: gdk3.ModifierType): cstring {.
    importc: "_gtk_accel_label_class_get_accelerator_label", libgtk.}"""

template typeAccelMap*(): expr =
  (accelMapGetType())

template accelMap*(accelMap: expr): expr =
  (gTypeCheckInstanceCast(accelMap, typeAccelMap, AccelMapObj))

template accelMapClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAccelMap, AccelMapClassObj))

template isAccelMap*(accelMap: expr): expr =
  (gTypeCheckInstanceType(accelMap, typeAccelMap))

template isAccelMapClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAccelMap))

template accelMapGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAccelMap, AccelMapClassObj))

type
  AccelMapForeach* = proc (data: Gpointer; accelPath: cstring; accelKey: cuint;
                           accelMods: gdk3.ModifierType; changed: Gboolean) {.cdecl.}

proc accelMapAddEntry*(accelPath: cstring; accelKey: cuint;
                         accelMods: gdk3.ModifierType) {.
    importc: "gtk_accel_map_add_entry", libgtk.}
proc accelMapLookupEntry*(accelPath: cstring; key: AccelKey): Gboolean {.
    importc: "gtk_accel_map_lookup_entry", libgtk.}
proc accelMapChangeEntry*(accelPath: cstring; accelKey: cuint;
                            accelMods: gdk3.ModifierType; replace: Gboolean): Gboolean {.
    importc: "gtk_accel_map_change_entry", libgtk.}
proc accelMapLoad*(fileName: cstring) {.importc: "gtk_accel_map_load", libgtk.}
proc accelMapSave*(fileName: cstring) {.importc: "gtk_accel_map_save", libgtk.}
proc accelMapForeach*(data: Gpointer; foreachFunc: AccelMapForeach) {.
    importc: "gtk_accel_map_foreach", libgtk.}
proc accelMapLoadFd*(fd: cint) {.importc: "gtk_accel_map_load_fd", libgtk.}
proc accelMapLoadScanner*(scanner: glib.GScanner) {.
    importc: "gtk_accel_map_load_scanner", libgtk.}
proc accelMapSaveFd*(fd: cint) {.importc: "gtk_accel_map_save_fd", libgtk.}
proc accelMapLockPath*(accelPath: cstring) {.importc: "gtk_accel_map_lock_path",
    libgtk.}
proc accelMapUnlockPath*(accelPath: cstring) {.
    importc: "gtk_accel_map_unlock_path", libgtk.}

proc accelMapAddFilter*(filterPattern: cstring) {.
    importc: "gtk_accel_map_add_filter", libgtk.}
proc accelMapForeachUnfiltered*(data: Gpointer; foreachFunc: AccelMapForeach) {.
    importc: "gtk_accel_map_foreach_unfiltered", libgtk.}

proc accelMapGetType*(): GType {.importc: "gtk_accel_map_get_type", libgtk.}
proc accelMapGet*(): AccelMap {.importc: "gtk_accel_map_get", libgtk.}

template typeAccessible*(): expr =
  (accessibleGetType())

template accessible*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeAccessible, AccessibleObj))

template accessibleClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAccessible, AccessibleClassObj))

template isAccessible*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeAccessible))

template isAccessibleClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAccessible))

template accessibleGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAccessible, AccessibleClassObj))

type
  Actionable* =  ptr ActionableObj
  ActionablePtr* = ptr ActionableObj
  ActionableObj* = object

  ActionableInterface* =  ptr ActionableInterfaceObj
  ActionableInterfacePtr* = ptr ActionableInterfaceObj
  ActionableInterfaceObj* = object
    gIface*: gobject.GTypeInterfaceObj
    getActionName*: proc (actionable: Actionable): cstring {.cdecl.}
    setActionName*: proc (actionable: Actionable; actionName: cstring) {.cdecl.}
    getActionTargetValue*: proc (actionable: Actionable): glib.GVariant {.cdecl.}
    setActionTargetValue*: proc (actionable: Actionable;
                               targetValue: glib.GVariant) {.cdecl.}

proc accessibleGetType*(): GType {.importc: "gtk_accessible_get_type", libgtk.}
proc setWidget*(accessible: Accessible; widget: Widget) {.
    importc: "gtk_accessible_set_widget", libgtk.}
proc `widget=`*(accessible: Accessible; widget: Widget) {.
    importc: "gtk_accessible_set_widget", libgtk.}
proc getWidget*(accessible: Accessible): Widget {.
    importc: "gtk_accessible_get_widget", libgtk.}
proc widget*(accessible: Accessible): Widget {.
    importc: "gtk_accessible_get_widget", libgtk.}
proc connectWidgetDestroyed*(accessible: Accessible) {.
    importc: "gtk_accessible_connect_widget_destroyed", libgtk.}

template typeActionable*(): expr =
  (actionableGetType())

template actionable*(inst: expr): expr =
  (gTypeCheckInstanceCast(inst, typeActionable, ActionableObj))

template isActionable*(inst: expr): expr =
  (gTypeCheckInstanceType(inst, typeActionable))

template actionableGetIface*(inst: expr): expr =
  (gTypeInstanceGetInterface(inst, typeActionable, ActionableInterfaceObj))

type
  ActionBar* =  ptr ActionBarObj
  ActionBarPtr* = ptr ActionBarObj
  ActionBarObj*{.final.} = object of BinObj

  ActionBarClass* =  ptr ActionBarClassObj
  ActionBarClassPtr* = ptr ActionBarClassObj
  ActionBarClassObj*{.final.} = object of BinClassObj
    gtkReserved141*: proc () {.cdecl.}
    gtkReserved142*: proc () {.cdecl.}
    gtkReserved143*: proc () {.cdecl.}
    gtkReserved144*: proc () {.cdecl.}

proc actionableGetType*(): GType {.importc: "gtk_actionable_get_type", libgtk.}
proc getActionName*(actionable: Actionable): cstring {.
    importc: "gtk_actionable_get_action_name", libgtk.}
proc actionName*(actionable: Actionable): cstring {.
    importc: "gtk_actionable_get_action_name", libgtk.}
proc setActionName*(actionable: Actionable; actionName: cstring) {.
    importc: "gtk_actionable_set_action_name", libgtk.}
proc `actionName=`*(actionable: Actionable; actionName: cstring) {.
    importc: "gtk_actionable_set_action_name", libgtk.}
proc getActionTargetValue*(actionable: Actionable): glib.GVariant {.
    importc: "gtk_actionable_get_action_target_value", libgtk.}
proc actionTargetValue*(actionable: Actionable): glib.GVariant {.
    importc: "gtk_actionable_get_action_target_value", libgtk.}
proc setActionTargetValue*(actionable: Actionable;
                                       targetValue: glib.GVariant) {.
    importc: "gtk_actionable_set_action_target_value", libgtk.}
proc `actionTargetValue=`*(actionable: Actionable;
                                       targetValue: glib.GVariant) {.
    importc: "gtk_actionable_set_action_target_value", libgtk.}
proc setActionTarget*(actionable: Actionable;
                                  formatString: cstring) {.varargs,
    importc: "gtk_actionable_set_action_target", libgtk.}
proc `actionTarget=`*(actionable: Actionable;
                                  formatString: cstring) {.varargs,
    importc: "gtk_actionable_set_action_target", libgtk.}
proc setDetailedActionName*(actionable: Actionable;
                                        detailedActionName: cstring) {.
    importc: "gtk_actionable_set_detailed_action_name", libgtk.}
proc `detailedActionName=`*(actionable: Actionable;
                                        detailedActionName: cstring) {.
    importc: "gtk_actionable_set_detailed_action_name", libgtk.}

template typeActionBar*(): expr =
  (actionBarGetType())

template actionBar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeActionBar, ActionBarObj))

template actionBarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeActionBar, ActionBarClassObj))

template isActionBar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeActionBar))

template isActionBarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeActionBar))

template actionBarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeActionBar, ActionBarClassObj))

type
  AdjustmentClass* =  ptr AdjustmentClassObj
  AdjustmentClassPtr* = ptr AdjustmentClassObj
  AdjustmentClassObj*{.final.} = object of gobject.GInitiallyUnownedClassObj
    changed*: proc (adjustment: Adjustment) {.cdecl.}
    valueChanged*: proc (adjustment: Adjustment) {.cdecl.}
    gtkReserved151*: proc () {.cdecl.}
    gtkReserved152*: proc () {.cdecl.}
    gtkReserved153*: proc () {.cdecl.}
    gtkReserved154*: proc () {.cdecl.}

proc actionBarGetType*(): GType {.importc: "gtk_action_bar_get_type", libgtk.}
proc newActionBar*(): ActionBar {.importc: "gtk_action_bar_new", libgtk.}
proc getCenterWidget*(actionBar: ActionBar): Widget {.
    importc: "gtk_action_bar_get_center_widget", libgtk.}
proc centerWidget*(actionBar: ActionBar): Widget {.
    importc: "gtk_action_bar_get_center_widget", libgtk.}
proc setCenterWidget*(actionBar: ActionBar;
                                 centerWidget: Widget) {.
    importc: "gtk_action_bar_set_center_widget", libgtk.}
proc `centerWidget=`*(actionBar: ActionBar;
                                 centerWidget: Widget) {.
    importc: "gtk_action_bar_set_center_widget", libgtk.}
proc packStart*(actionBar: ActionBar; child: Widget) {.
    importc: "gtk_action_bar_pack_start", libgtk.}
proc packEnd*(actionBar: ActionBar; child: Widget) {.
    importc: "gtk_action_bar_pack_end", libgtk.}

template typeAdjustment*(): expr =
  (adjustmentGetType())

template adjustment*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeAdjustment, AdjustmentObj))

template adjustmentClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAdjustment, AdjustmentClassObj))

template isAdjustment*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeAdjustment))

template isAdjustmentClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAdjustment))

template adjustmentGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAdjustment, AdjustmentClassObj))

type
  AppChooser* =  ptr AppChooserObj
  AppChooserPtr* = ptr AppChooserObj
  AppChooserObj* = object

proc adjustmentGetType*(): GType {.importc: "gtk_adjustment_get_type", libgtk.}
proc newAdjustment*(value: cdouble; lower: cdouble; upper: cdouble;
                      stepIncrement: cdouble; pageIncrement: cdouble;
                      pageSize: cdouble): Adjustment {.
    importc: "gtk_adjustment_new", libgtk.}
proc changed*(adjustment: Adjustment) {.
    importc: "gtk_adjustment_changed", libgtk.}
proc valueChanged*(adjustment: Adjustment) {.
    importc: "gtk_adjustment_value_changed", libgtk.}
proc clampPage*(adjustment: Adjustment; lower: cdouble;
                            upper: cdouble) {.
    importc: "gtk_adjustment_clamp_page", libgtk.}
proc getValue*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_value", libgtk.}
proc value*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_value", libgtk.}
proc setValue*(adjustment: Adjustment; value: cdouble) {.
    importc: "gtk_adjustment_set_value", libgtk.}
proc `value=`*(adjustment: Adjustment; value: cdouble) {.
    importc: "gtk_adjustment_set_value", libgtk.}
proc getLower*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_lower", libgtk.}
proc lower*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_lower", libgtk.}
proc setLower*(adjustment: Adjustment; lower: cdouble) {.
    importc: "gtk_adjustment_set_lower", libgtk.}
proc `lower=`*(adjustment: Adjustment; lower: cdouble) {.
    importc: "gtk_adjustment_set_lower", libgtk.}
proc getUpper*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_upper", libgtk.}
proc upper*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_upper", libgtk.}
proc setUpper*(adjustment: Adjustment; upper: cdouble) {.
    importc: "gtk_adjustment_set_upper", libgtk.}
proc `upper=`*(adjustment: Adjustment; upper: cdouble) {.
    importc: "gtk_adjustment_set_upper", libgtk.}
proc getStepIncrement*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_step_increment", libgtk.}
proc stepIncrement*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_step_increment", libgtk.}
proc setStepIncrement*(adjustment: Adjustment;
                                   stepIncrement: cdouble) {.
    importc: "gtk_adjustment_set_step_increment", libgtk.}
proc `stepIncrement=`*(adjustment: Adjustment;
                                   stepIncrement: cdouble) {.
    importc: "gtk_adjustment_set_step_increment", libgtk.}
proc getPageIncrement*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_page_increment", libgtk.}
proc pageIncrement*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_page_increment", libgtk.}
proc setPageIncrement*(adjustment: Adjustment;
                                   pageIncrement: cdouble) {.
    importc: "gtk_adjustment_set_page_increment", libgtk.}
proc `pageIncrement=`*(adjustment: Adjustment;
                                   pageIncrement: cdouble) {.
    importc: "gtk_adjustment_set_page_increment", libgtk.}
proc getPageSize*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_page_size", libgtk.}
proc pageSize*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_page_size", libgtk.}
proc setPageSize*(adjustment: Adjustment; pageSize: cdouble) {.
    importc: "gtk_adjustment_set_page_size", libgtk.}
proc `pageSize=`*(adjustment: Adjustment; pageSize: cdouble) {.
    importc: "gtk_adjustment_set_page_size", libgtk.}
proc configure*(adjustment: Adjustment; value: cdouble;
                            lower: cdouble; upper: cdouble; stepIncrement: cdouble;
                            pageIncrement: cdouble; pageSize: cdouble) {.
    importc: "gtk_adjustment_configure", libgtk.}
proc getMinimumIncrement*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_minimum_increment", libgtk.}
proc minimumIncrement*(adjustment: Adjustment): cdouble {.
    importc: "gtk_adjustment_get_minimum_increment", libgtk.}

template typeAppChooser*(): expr =
  (appChooserGetType())

template appChooser*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeAppChooser, AppChooserObj))

template isAppChooser*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeAppChooser))

proc appChooserGetType*(): GType {.importc: "gtk_app_chooser_get_type",
                                   libgtk.}
proc getAppInfo*(self: AppChooser): gio.GAppInfo {.
    importc: "gtk_app_chooser_get_app_info", libgtk.}
proc appInfo*(self: AppChooser): gio.GAppInfo {.
    importc: "gtk_app_chooser_get_app_info", libgtk.}
proc getContentType*(self: AppChooser): cstring {.
    importc: "gtk_app_chooser_get_content_type", libgtk.}
proc contentType*(self: AppChooser): cstring {.
    importc: "gtk_app_chooser_get_content_type", libgtk.}
proc refresh*(self: AppChooser) {.
    importc: "gtk_app_chooser_refresh", libgtk.}

template typeAppChooserDialog*(): expr =
  (appChooserDialogGetType())

template appChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeAppChooserDialog, AppChooserDialogObj))

template appChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAppChooserDialog, AppChooserDialogClassObj))

template isAppChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeAppChooserDialog))

template isAppChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAppChooserDialog))

template appChooserDialogGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAppChooserDialog, AppChooserDialogClassObj))

type
  AppChooserDialog* =  ptr AppChooserDialogObj
  AppChooserDialogPtr* = ptr AppChooserDialogObj
  AppChooserDialogObj*{.final.} = object of DialogObj
    priv22: pointer

type
  AppChooserDialogClass* =  ptr AppChooserDialogClassObj
  AppChooserDialogClassPtr* = ptr AppChooserDialogClassObj
  AppChooserDialogClassObj*{.final.} = object of DialogClassObj
    padding*: array[16, Gpointer]

  Box* =  ptr BoxObj
  BoxPtr* = ptr BoxObj
  BoxObj* = object of ContainerObj
    priv23: pointer

  BoxClass* =  ptr BoxClassObj
  BoxClassPtr* = ptr BoxClassObj
  BoxClassObj = object of ContainerClassObj
    gtkReserved161*: proc () {.cdecl.}
    gtkReserved162*: proc () {.cdecl.}
    gtkReserved163*: proc () {.cdecl.}
    gtkReserved164*: proc () {.cdecl.}

proc appChooserDialogGetType*(): GType {.
    importc: "gtk_app_chooser_dialog_get_type", libgtk.}
proc newAppChooserDialog*(parent: Window; flags: DialogFlags;
                            file: gio.GFile): AppChooserDialog {.
    importc: "gtk_app_chooser_dialog_new", libgtk.}
proc getWidget*(self: AppChooserDialog): Widget {.
    importc: "gtk_app_chooser_dialog_get_widget", libgtk.}
proc widget*(self: AppChooserDialog): Widget {.
    importc: "gtk_app_chooser_dialog_get_widget", libgtk.}
proc setHeading*(self: AppChooserDialog; heading: cstring) {.
    importc: "gtk_app_chooser_dialog_set_heading", libgtk.}
proc `heading=`*(self: AppChooserDialog; heading: cstring) {.
    importc: "gtk_app_chooser_dialog_set_heading", libgtk.}
proc getHeading*(self: AppChooserDialog): cstring {.
    importc: "gtk_app_chooser_dialog_get_heading", libgtk.}
proc heading*(self: AppChooserDialog): cstring {.
    importc: "gtk_app_chooser_dialog_get_heading", libgtk.}

template typeBox*(): expr =
  (boxGetType())

template box*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeBox, BoxObj))

template boxClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeBox, BoxClassObj))

template isBox*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeBox))

template isBoxClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeBox))

template boxGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeBox, BoxClassObj))

proc boxGetType*(): GType {.importc: "gtk_box_get_type", libgtk.}
proc newBox*(orientation: Orientation; spacing: cint): Box {.
    importc: "gtk_box_new", libgtk.}
proc packStart*(box: Box; child: Widget; expand: Gboolean;
                     fill: Gboolean; padding: cuint) {.
    importc: "gtk_box_pack_start", libgtk.}
proc packEnd*(box: Box; child: Widget; expand: Gboolean;
                   fill: Gboolean; padding: cuint) {.importc: "gtk_box_pack_end",
    libgtk.}
proc setHomogeneous*(box: Box; homogeneous: Gboolean) {.
    importc: "gtk_box_set_homogeneous", libgtk.}
proc `homogeneous=`*(box: Box; homogeneous: Gboolean) {.
    importc: "gtk_box_set_homogeneous", libgtk.}
proc getHomogeneous*(box: Box): Gboolean {.
    importc: "gtk_box_get_homogeneous", libgtk.}
proc homogeneous*(box: Box): Gboolean {.
    importc: "gtk_box_get_homogeneous", libgtk.}
proc setSpacing*(box: Box; spacing: cint) {.
    importc: "gtk_box_set_spacing", libgtk.}
proc `spacing=`*(box: Box; spacing: cint) {.
    importc: "gtk_box_set_spacing", libgtk.}
proc getSpacing*(box: Box): cint {.importc: "gtk_box_get_spacing",
    libgtk.}
proc spacing*(box: Box): cint {.importc: "gtk_box_get_spacing",
    libgtk.}
proc setBaselinePosition*(box: Box; position: BaselinePosition) {.
    importc: "gtk_box_set_baseline_position", libgtk.}
proc `baselinePosition=`*(box: Box; position: BaselinePosition) {.
    importc: "gtk_box_set_baseline_position", libgtk.}
proc getBaselinePosition*(box: Box): BaselinePosition {.
    importc: "gtk_box_get_baseline_position", libgtk.}
proc baselinePosition*(box: Box): BaselinePosition {.
    importc: "gtk_box_get_baseline_position", libgtk.}
proc reorderChild*(box: Box; child: Widget; position: cint) {.
    importc: "gtk_box_reorder_child", libgtk.}
proc queryChildPacking*(box: Box; child: Widget;
                             expand: ptr Gboolean; fill: var Gboolean;
                             padding: var cuint; packType: ptr PackType) {.
    importc: "gtk_box_query_child_packing", libgtk.}
proc setChildPacking*(box: Box; child: Widget; expand: Gboolean;
                           fill: Gboolean; padding: cuint; packType: PackType) {.
    importc: "gtk_box_set_child_packing", libgtk.}
proc `childPacking=`*(box: Box; child: Widget; expand: Gboolean;
                           fill: Gboolean; padding: cuint; packType: PackType) {.
    importc: "gtk_box_set_child_packing", libgtk.}
proc setCenterWidget*(box: Box; widget: Widget) {.
    importc: "gtk_box_set_center_widget", libgtk.}
proc `centerWidget=`*(box: Box; widget: Widget) {.
    importc: "gtk_box_set_center_widget", libgtk.}
proc getCenterWidget*(box: Box): Widget {.
    importc: "gtk_box_get_center_widget", libgtk.}
proc centerWidget*(box: Box): Widget {.
    importc: "gtk_box_get_center_widget", libgtk.}

template typeAppChooserWidget*(): expr =
  (appChooserWidgetGetType())

template appChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeAppChooserWidget, AppChooserWidgetObj))

template appChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAppChooserWidget, AppChooserWidgetClassObj))

template isAppChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeAppChooserWidget))

template isAppChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAppChooserWidget))

template appChooserWidgetGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAppChooserWidget, AppChooserWidgetClassObj))

type
  AppChooserWidget* =  ptr AppChooserWidgetObj
  AppChooserWidgetPtr* = ptr AppChooserWidgetObj
  AppChooserWidgetObj*{.final.} = object of BoxObj
    priv24: pointer

type
  AppChooserWidgetClass* =  ptr AppChooserWidgetClassObj
  AppChooserWidgetClassPtr* = ptr AppChooserWidgetClassObj
  AppChooserWidgetClassObj*{.final.} = object of BoxClassObj
    applicationSelected*: proc (self: AppChooserWidget; appInfo: gio.GAppInfo) {.cdecl.}
    applicationActivated*: proc (self: AppChooserWidget; appInfo: gio.GAppInfo) {.cdecl.}
    populatePopup*: proc (self: AppChooserWidget; menu: Menu;
                        appInfo: gio.GAppInfo) {.cdecl.}
    padding*: array[16, Gpointer]

  TreeIter* =  ptr TreeIterObj
  TreeIterPtr* = ptr TreeIterObj
  TreeIterObj* = object
    stamp*: cint
    userData*: Gpointer
    userData2*: Gpointer
    userData3*: Gpointer

  TreePath* =  ptr TreePathObj
  TreePathPtr* = ptr TreePathObj
  TreePathObj* = object

  TreeModel* =  ptr TreeModelObj
  TreeModelPtr* = ptr TreeModelObj
  TreeModelObj* = object

type
  TreeModelFlags* {.size: sizeof(cint), pure.} = enum
    ITERS_PERSIST = 1 shl 0, LIST_ONLY = 1 shl 1
  TreeModelIface* =  ptr TreeModelIfaceObj
  TreeModelIfacePtr* = ptr TreeModelIfaceObj
  TreeModelIfaceObj* = object
    gIface*: gobject.GTypeInterfaceObj
    rowChanged*: proc (treeModel: TreeModel; path: TreePath;
                     iter: TreeIter) {.cdecl.}
    rowInserted*: proc (treeModel: TreeModel; path: TreePath;
                      iter: TreeIter) {.cdecl.}
    rowHasChildToggled*: proc (treeModel: TreeModel; path: TreePath;
                             iter: TreeIter) {.cdecl.}
    rowDeleted*: proc (treeModel: TreeModel; path: TreePath) {.cdecl.}
    rowsReordered*: proc (treeModel: TreeModel; path: TreePath;
                        iter: TreeIter; newOrder: var cint) {.cdecl.}
    getFlags*: proc (treeModel: TreeModel): TreeModelFlags {.cdecl.}
    getNColumns*: proc (treeModel: TreeModel): cint {.cdecl.}
    getColumnType*: proc (treeModel: TreeModel; index: cint): GType {.cdecl.}
    getIter*: proc (treeModel: TreeModel; iter: TreeIter;
                  path: TreePath): Gboolean {.cdecl.}
    getPath*: proc (treeModel: TreeModel; iter: TreeIter): TreePath {.cdecl.}
    getValue*: proc (treeModel: TreeModel; iter: TreeIter; column: cint;
                   value: gobject.GValue) {.cdecl.}
    iterNext*: proc (treeModel: TreeModel; iter: TreeIter): Gboolean {.cdecl.}
    iterPrevious*: proc (treeModel: TreeModel; iter: TreeIter): Gboolean {.cdecl.}
    iterChildren*: proc (treeModel: TreeModel; iter: TreeIter;
                       parent: TreeIter): Gboolean {.cdecl.}
    iterHasChild*: proc (treeModel: TreeModel; iter: TreeIter): Gboolean {.cdecl.}
    iterNChildren*: proc (treeModel: TreeModel; iter: TreeIter): cint {.cdecl.}
    iterNthChild*: proc (treeModel: TreeModel; iter: TreeIter;
                       parent: TreeIter; n: cint): Gboolean {.cdecl.}
    iterParent*: proc (treeModel: TreeModel; iter: TreeIter;
                     child: TreeIter): Gboolean {.cdecl.}
    refNode*: proc (treeModel: TreeModel; iter: TreeIter) {.cdecl.}
    unrefNode*: proc (treeModel: TreeModel; iter: TreeIter) {.cdecl.}

proc appChooserWidgetGetType*(): GType {.
    importc: "gtk_app_chooser_widget_get_type", libgtk.}
proc newAppChooserWidget*(contentType: cstring): AppChooserWidget {.
    importc: "gtk_app_chooser_widget_new", libgtk.}
proc setShowDefault*(self: AppChooserWidget;
                                       setting: Gboolean) {.
    importc: "gtk_app_chooser_widget_set_show_default", libgtk.}
proc `showDefault=`*(self: AppChooserWidget;
                                       setting: Gboolean) {.
    importc: "gtk_app_chooser_widget_set_show_default", libgtk.}
proc getShowDefault*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_default", libgtk.}
proc showDefault*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_default", libgtk.}
proc setShowRecommended*(self: AppChooserWidget;
    setting: Gboolean) {.importc: "gtk_app_chooser_widget_set_show_recommended",
                       libgtk.}
proc `showRecommended=`*(self: AppChooserWidget;
    setting: Gboolean) {.importc: "gtk_app_chooser_widget_set_show_recommended",
                       libgtk.}
proc getShowRecommended*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_recommended", libgtk.}
proc showRecommended*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_recommended", libgtk.}
proc setShowFallback*(self: AppChooserWidget;
                                        setting: Gboolean) {.
    importc: "gtk_app_chooser_widget_set_show_fallback", libgtk.}
proc `showFallback=`*(self: AppChooserWidget;
                                        setting: Gboolean) {.
    importc: "gtk_app_chooser_widget_set_show_fallback", libgtk.}
proc getShowFallback*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_fallback", libgtk.}
proc showFallback*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_fallback", libgtk.}
proc setShowOther*(self: AppChooserWidget;
                                     setting: Gboolean) {.
    importc: "gtk_app_chooser_widget_set_show_other", libgtk.}
proc `showOther=`*(self: AppChooserWidget;
                                     setting: Gboolean) {.
    importc: "gtk_app_chooser_widget_set_show_other", libgtk.}
proc getShowOther*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_other", libgtk.}
proc showOther*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_other", libgtk.}
proc setShowAll*(self: AppChooserWidget; setting: Gboolean) {.
    importc: "gtk_app_chooser_widget_set_show_all", libgtk.}
proc `showAll=`*(self: AppChooserWidget; setting: Gboolean) {.
    importc: "gtk_app_chooser_widget_set_show_all", libgtk.}
proc getShowAll*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_all", libgtk.}
proc showAll*(self: AppChooserWidget): Gboolean {.
    importc: "gtk_app_chooser_widget_get_show_all", libgtk.}
proc setDefaultText*(self: AppChooserWidget; text: cstring) {.
    importc: "gtk_app_chooser_widget_set_default_text", libgtk.}
proc `defaultText=`*(self: AppChooserWidget; text: cstring) {.
    importc: "gtk_app_chooser_widget_set_default_text", libgtk.}
proc getDefaultText*(self: AppChooserWidget): cstring {.
    importc: "gtk_app_chooser_widget_get_default_text", libgtk.}
proc defaultText*(self: AppChooserWidget): cstring {.
    importc: "gtk_app_chooser_widget_get_default_text", libgtk.}

template typeTreeModel*(): expr =
  (treeModelGetType())

template treeModel*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeModel, TreeModelObj))

template isTreeModel*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeModel))

template treeModelGetIface*(obj: expr): expr =
  (gTypeInstanceGetInterface(obj, typeTreeModel, TreeModelIfaceObj))

template typeTreeIter*(): expr =
  (treeIterGetType())

template typeTreePath*(): expr =
  (treePathGetType())

template typeTreeRowReference*(): expr =
  (treeRowReferenceGetType())

type
  TreeRowReference* =  ptr TreeRowReferenceObj
  TreeRowReferencePtr* = ptr TreeRowReferenceObj
  TreeRowReferenceObj* = object

type
  TreeModelForeachFunc* = proc (model: TreeModel; path: TreePath;
                                iter: TreeIter; data: Gpointer): Gboolean {.cdecl.}

type
  CellEditable* =  ptr CellEditableObj
  CellEditablePtr* = ptr CellEditableObj
  CellEditableObj* = object

type
  CellEditableIface* =  ptr CellEditableIfaceObj
  CellEditableIfacePtr* = ptr CellEditableIfaceObj
  CellEditableIfaceObj* = object of gobject.GTypeInterfaceObj
    editingDone*: proc (cellEditable: CellEditable) {.cdecl.}
    removeWidget*: proc (cellEditable: CellEditable) {.cdecl.}
    startEditing*: proc (cellEditable: CellEditable; event: gdk3.Event) {.cdecl.}

proc newTreePath*(): TreePath {.importc: "gtk_tree_path_new", libgtk.}
proc newTreePath*(path: cstring): TreePath {.
    importc: "gtk_tree_path_new_from_string", libgtk.}
proc newTreePath*(firstIndex: cint): TreePath {.varargs,
    importc: "gtk_tree_path_new_from_indices", libgtk.}
proc newTreePath*(indices: var cint; length: Gsize): TreePath {.
    importc: "gtk_tree_path_new_from_indicesv", libgtk.}
proc toString*(path: TreePath): cstring {.
    importc: "gtk_tree_path_to_string", libgtk.}
proc newTreePathFirst*(): TreePath {.importc: "gtk_tree_path_new_first", libgtk.}
proc appendIndex*(path: TreePath; index: cint) {.
    importc: "gtk_tree_path_append_index", libgtk.}
proc prependIndex*(path: TreePath; index: cint) {.
    importc: "gtk_tree_path_prepend_index", libgtk.}
proc getDepth*(path: TreePath): cint {.
    importc: "gtk_tree_path_get_depth", libgtk.}
proc depth*(path: TreePath): cint {.
    importc: "gtk_tree_path_get_depth", libgtk.}
proc getIndices*(path: TreePath): ptr cint {.
    importc: "gtk_tree_path_get_indices", libgtk.}
proc indices*(path: TreePath): ptr cint {.
    importc: "gtk_tree_path_get_indices", libgtk.}
proc getIndicesWithDepth*(path: TreePath; depth: var cint): ptr cint {.
    importc: "gtk_tree_path_get_indices_with_depth", libgtk.}
proc indicesWithDepth*(path: TreePath; depth: var cint): ptr cint {.
    importc: "gtk_tree_path_get_indices_with_depth", libgtk.}
proc free*(path: TreePath) {.importc: "gtk_tree_path_free",
    libgtk.}
proc copy*(path: TreePath): TreePath {.
    importc: "gtk_tree_path_copy", libgtk.}
proc treePathGetType*(): GType {.importc: "gtk_tree_path_get_type", libgtk.}
proc compare*(a: TreePath; b: TreePath): cint {.
    importc: "gtk_tree_path_compare", libgtk.}
proc next*(path: TreePath) {.importc: "gtk_tree_path_next",
    libgtk.}
proc prev*(path: TreePath): Gboolean {.
    importc: "gtk_tree_path_prev", libgtk.}
proc up*(path: TreePath): Gboolean {.importc: "gtk_tree_path_up",
    libgtk.}
proc down*(path: TreePath) {.importc: "gtk_tree_path_down",
    libgtk.}
proc isAncestor*(path: TreePath; descendant: TreePath): Gboolean {.
    importc: "gtk_tree_path_is_ancestor", libgtk.}
proc isDescendant*(path: TreePath; ancestor: TreePath): Gboolean {.
    importc: "gtk_tree_path_is_descendant", libgtk.}

proc treeRowReferenceGetType*(): GType {.
    importc: "gtk_tree_row_reference_get_type", libgtk.}
proc newTreeRowReference*(model: TreeModel; path: TreePath): TreeRowReference {.
    importc: "gtk_tree_row_reference_new", libgtk.}
proc newTreeRowReference*(proxy: GObject; model: TreeModel;
                                 path: TreePath): TreeRowReference {.
    importc: "gtk_tree_row_reference_new_proxy", libgtk.}
proc getPath*(reference: TreeRowReference): TreePath {.
    importc: "gtk_tree_row_reference_get_path", libgtk.}
proc path*(reference: TreeRowReference): TreePath {.
    importc: "gtk_tree_row_reference_get_path", libgtk.}
proc getModel*(reference: TreeRowReference): TreeModel {.
    importc: "gtk_tree_row_reference_get_model", libgtk.}
proc model*(reference: TreeRowReference): TreeModel {.
    importc: "gtk_tree_row_reference_get_model", libgtk.}
proc valid*(reference: TreeRowReference): Gboolean {.
    importc: "gtk_tree_row_reference_valid", libgtk.}
proc copy*(reference: TreeRowReference): TreeRowReference {.
    importc: "gtk_tree_row_reference_copy", libgtk.}
proc free*(reference: TreeRowReference) {.
    importc: "gtk_tree_row_reference_free", libgtk.}

proc treeRowReferenceInserted*(proxy: GObject; path: TreePath) {.
    importc: "gtk_tree_row_reference_inserted", libgtk.}
proc treeRowReferenceDeleted*(proxy: GObject; path: TreePath) {.
    importc: "gtk_tree_row_reference_deleted", libgtk.}
proc treeRowReferenceReordered*(proxy: GObject; path: TreePath;
                                  iter: TreeIter; newOrder: var cint) {.
    importc: "gtk_tree_row_reference_reordered", libgtk.}

proc copy*(iter: TreeIter): TreeIter {.
    importc: "gtk_tree_iter_copy", libgtk.}
proc free*(iter: TreeIter) {.importc: "gtk_tree_iter_free",
    libgtk.}
proc treeIterGetType*(): GType {.importc: "gtk_tree_iter_get_type", libgtk.}
proc treeModelGetType*(): GType {.importc: "gtk_tree_model_get_type", libgtk.}
proc getFlags*(treeModel: TreeModel): TreeModelFlags {.
    importc: "gtk_tree_model_get_flags", libgtk.}
proc flags*(treeModel: TreeModel): TreeModelFlags {.
    importc: "gtk_tree_model_get_flags", libgtk.}
proc getNColumns*(treeModel: TreeModel): cint {.
    importc: "gtk_tree_model_get_n_columns", libgtk.}
proc nColumns*(treeModel: TreeModel): cint {.
    importc: "gtk_tree_model_get_n_columns", libgtk.}
proc getColumnType*(treeModel: TreeModel; index: cint): GType {.
    importc: "gtk_tree_model_get_column_type", libgtk.}
proc columnType*(treeModel: TreeModel; index: cint): GType {.
    importc: "gtk_tree_model_get_column_type", libgtk.}

proc getIter*(treeModel: TreeModel; iter: TreeIter;
                         path: TreePath): Gboolean {.
    importc: "gtk_tree_model_get_iter", libgtk.}

proc iter*(treeModel: TreeModel; iter: TreeIter;
                         path: TreePath): Gboolean {.
    importc: "gtk_tree_model_get_iter", libgtk.}
proc getIterFromString*(treeModel: TreeModel;
                                   iter: TreeIter; pathString: cstring): Gboolean {.
    importc: "gtk_tree_model_get_iter_from_string", libgtk.}
proc iterFromString*(treeModel: TreeModel;
                                   iter: TreeIter; pathString: cstring): Gboolean {.
    importc: "gtk_tree_model_get_iter_from_string", libgtk.}
proc getStringFromIter*(treeModel: TreeModel;
                                   iter: TreeIter): cstring {.
    importc: "gtk_tree_model_get_string_from_iter", libgtk.}
proc stringFromIter*(treeModel: TreeModel;
                                   iter: TreeIter): cstring {.
    importc: "gtk_tree_model_get_string_from_iter", libgtk.}
proc getIterFirst*(treeModel: TreeModel; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_model_get_iter_first", libgtk.}
proc iterFirst*(treeModel: TreeModel; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_model_get_iter_first", libgtk.}
proc getPath*(treeModel: TreeModel; iter: TreeIter): TreePath {.
    importc: "gtk_tree_model_get_path", libgtk.}
proc path*(treeModel: TreeModel; iter: TreeIter): TreePath {.
    importc: "gtk_tree_model_get_path", libgtk.}
proc getValue*(treeModel: TreeModel; iter: TreeIter;
                          column: cint; value: gobject.GValue) {.
    importc: "gtk_tree_model_get_value", libgtk.}
proc iterPrevious*(treeModel: TreeModel; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_model_iter_previous", libgtk.}
proc iterNext*(treeModel: TreeModel; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_model_iter_next", libgtk.}
proc iterChildren*(treeModel: TreeModel; iter: TreeIter;
                              parent: TreeIter): Gboolean {.
    importc: "gtk_tree_model_iter_children", libgtk.}
proc iterHasChild*(treeModel: TreeModel; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_model_iter_has_child", libgtk.}
proc iterNChildren*(treeModel: TreeModel; iter: TreeIter): cint {.
    importc: "gtk_tree_model_iter_n_children", libgtk.}
proc iterNthChild*(treeModel: TreeModel; iter: TreeIter;
                              parent: TreeIter; n: cint): Gboolean {.
    importc: "gtk_tree_model_iter_nth_child", libgtk.}
proc iterParent*(treeModel: TreeModel; iter: TreeIter;
                            child: TreeIter): Gboolean {.
    importc: "gtk_tree_model_iter_parent", libgtk.}
proc refNode*(treeModel: TreeModel; iter: TreeIter) {.
    importc: "gtk_tree_model_ref_node", libgtk.}
proc unrefNode*(treeModel: TreeModel; iter: TreeIter) {.
    importc: "gtk_tree_model_unref_node", libgtk.}
proc get*(treeModel: TreeModel; iter: var TreeIterObj) {.varargs,
    importc: "gtk_tree_model_get", libgtk.}

discard """ proc "getValist*(treeModel: TreeModel; iter: TreeIter;
                           varArgs: VaList) {.
    importc: "gtk_tree_model_get_valist", libgtk.}"""

proc foreach*(model: TreeModel; `func`: TreeModelForeachFunc;
                         userData: Gpointer) {.importc: "gtk_tree_model_foreach",
    libgtk.}

proc rowChanged*(treeModel: TreeModel; path: TreePath;
                            iter: TreeIter) {.
    importc: "gtk_tree_model_row_changed", libgtk.}
proc rowInserted*(treeModel: TreeModel; path: TreePath;
                             iter: TreeIter) {.
    importc: "gtk_tree_model_row_inserted", libgtk.}
proc rowHasChildToggled*(treeModel: TreeModel;
                                    path: TreePath; iter: TreeIter) {.
    importc: "gtk_tree_model_row_has_child_toggled", libgtk.}
proc rowDeleted*(treeModel: TreeModel; path: TreePath) {.
    importc: "gtk_tree_model_row_deleted", libgtk.}
proc rowsReordered*(treeModel: TreeModel; path: TreePath;
                               iter: TreeIter; newOrder: var cint) {.
    importc: "gtk_tree_model_rows_reordered", libgtk.}
proc rowsReorderedWithLength*(treeModel: TreeModel;
    path: TreePath; iter: TreeIter; newOrder: var cint; length: cint) {.
    importc: "gtk_tree_model_rows_reordered_with_length", libgtk.}

template typeCellEditable*(): expr =
  (cellEditableGetType())

template cellEditable*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellEditable, CellEditableObj))

template cellEditableClass*(obj: expr): expr =
  (gTypeCheckClassCast(obj, typeCellEditable, CellEditableIfaceObj))

template isCellEditable*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellEditable))

template cellEditableGetIface*(obj: expr): expr =
  (gTypeInstanceGetInterface(obj, typeCellEditable, CellEditableIfaceObj))

proc cellEditableGetType*(): GType {.importc: "gtk_cell_editable_get_type",
                                     libgtk.}
proc startEditing*(cellEditable: CellEditable;
                                 event: gdk3.Event) {.
    importc: "gtk_cell_editable_start_editing", libgtk.}
proc editingDone*(cellEditable: CellEditable) {.
    importc: "gtk_cell_editable_editing_done", libgtk.}
proc removeWidget*(cellEditable: CellEditable) {.
    importc: "gtk_cell_editable_remove_widget", libgtk.}

type
  CellRendererState* {.size: sizeof(cint), pure.} = enum
    SELECTED = 1 shl 0, PRELIT = 1 shl 1,
    INSENSITIVE = 1 shl 2, SORTED = 1 shl 3,
    FOCUSED = 1 shl 4, EXPANDABLE = 1 shl 5,
    EXPANDED = 1 shl 6

type
  CellRendererMode* {.size: sizeof(cint), pure.} = enum
    INERT, ACTIVATABLE,
    EDITABLE

type
  CellRenderer* =  ptr CellRendererObj
  CellRendererPtr* = ptr CellRendererObj
  CellRendererObj = object of gobject.GInitiallyUnownedObj
    priv25: pointer

  CellRendererClass* =  ptr CellRendererClassObj
  CellRendererClassPtr* = ptr CellRendererClassObj
  CellRendererClassObj = object of gobject.GInitiallyUnownedClassObj
    getRequestMode*: proc (cell: CellRenderer): SizeRequestMode {.cdecl.}
    getPreferredWidth*: proc (cell: CellRenderer; widget: Widget;
                            minimumSize: var cint; naturalSize: var cint) {.cdecl.}
    getPreferredHeightForWidth*: proc (cell: CellRenderer;
                                     widget: Widget; width: cint;
                                     minimumHeight: var cint;
                                     naturalHeight: var cint) {.cdecl.}
    getPreferredHeight*: proc (cell: CellRenderer; widget: Widget;
                             minimumSize: var cint; naturalSize: var cint) {.cdecl.}
    getPreferredWidthForHeight*: proc (cell: CellRenderer;
                                     widget: Widget; height: cint;
                                     minimumWidth: var cint; naturalWidth: var cint) {.cdecl.}
    getAlignedArea*: proc (cell: CellRenderer; widget: Widget;
                         flags: CellRendererState; cellArea: gdk3.Rectangle;
                         alignedArea: gdk3.Rectangle) {.cdecl.}
    getSize*: proc (cell: CellRenderer; widget: Widget;
                  cellArea: gdk3.Rectangle; xOffset: var cint; yOffset: var cint;
                  width: var cint; height: var cint) {.cdecl.}
    render*: proc (cell: CellRenderer; cr: cairo.Context; widget: Widget;
                 backgroundArea: gdk3.Rectangle; cellArea: gdk3.Rectangle;
                 flags: CellRendererState) {.cdecl.}
    activate*: proc (cell: CellRenderer; event: gdk3.Event;
                   widget: Widget; path: cstring;
                   backgroundArea: gdk3.Rectangle; cellArea: gdk3.Rectangle;
                   flags: CellRendererState): Gboolean {.cdecl.}
    startEditing*: proc (cell: CellRenderer; event: gdk3.Event;
                       widget: Widget; path: cstring;
                       backgroundArea: gdk3.Rectangle;
                       cellArea: gdk3.Rectangle; flags: CellRendererState): CellEditable {.cdecl.}
    editingCanceled*: proc (cell: CellRenderer) {.cdecl.}
    editingStarted*: proc (cell: CellRenderer; editable: CellEditable;
                         path: cstring) {.cdecl.}
    priv26: pointer
    gtkReserved172*: proc () {.cdecl.}
    gtkReserved173*: proc () {.cdecl.}
    gtkReserved174*: proc () {.cdecl.}

template typeCellRenderer*(): expr =
  (cellRendererGetType())

template cellRenderer*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellRenderer, CellRendererObj))

template cellRendererClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellRenderer, CellRendererClassObj))

template isCellRenderer*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellRenderer))

template isCellRendererClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellRenderer))

template cellRendererGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellRenderer, CellRendererClassObj))

type
  TreeSortable* =  ptr TreeSortableObj
  TreeSortablePtr* = ptr TreeSortableObj
  TreeSortableObj* = object
type
  TreeIterCompareFunc* = proc (model: TreeModel; a: TreeIter;
                               b: TreeIter; userData: Gpointer): cint {.cdecl.}

type
  TreeSortableIface* =  ptr TreeSortableIfaceObj
  TreeSortableIfacePtr* = ptr TreeSortableIfaceObj
  TreeSortableIfaceObj* = object of gobject.GTypeInterfaceObj
    sortColumnChanged*: proc (sortable: TreeSortable) {.cdecl.}
    getSortColumnId*: proc (sortable: TreeSortable; sortColumnId: var cint;
                          order: var SortType): Gboolean {.cdecl.}
    setSortColumnId*: proc (sortable: TreeSortable; sortColumnId: cint;
                          order: SortType) {.cdecl.}
    setSortFunc*: proc (sortable: TreeSortable; sortColumnId: cint;
                      sortFunc: TreeIterCompareFunc; userData: Gpointer;
                      destroy: GDestroyNotify) {.cdecl.}
    setDefaultSortFunc*: proc (sortable: TreeSortable;
                             sortFunc: TreeIterCompareFunc; userData: Gpointer;
                             destroy: GDestroyNotify) {.cdecl.}
    hasDefaultSortFunc*: proc (sortable: TreeSortable): Gboolean {.cdecl.}

proc cellRendererGetType*(): GType {.importc: "gtk_cell_renderer_get_type",
                                     libgtk.}
proc getRequestMode*(cell: CellRenderer): SizeRequestMode {.
    importc: "gtk_cell_renderer_get_request_mode", libgtk.}
proc requestMode*(cell: CellRenderer): SizeRequestMode {.
    importc: "gtk_cell_renderer_get_request_mode", libgtk.}
proc getPreferredWidth*(cell: CellRenderer;
                                      widget: Widget; minimumSize: var cint;
                                      naturalSize: var cint) {.
    importc: "gtk_cell_renderer_get_preferred_width", libgtk.}
proc getPreferredHeightForWidth*(cell: CellRenderer;
    widget: Widget; width: cint; minimumHeight: var cint; naturalHeight: var cint) {.
    importc: "gtk_cell_renderer_get_preferred_height_for_width", libgtk.}
proc getPreferredHeight*(cell: CellRenderer;
                                       widget: Widget;
                                       minimumSize: var cint; naturalSize: var cint) {.
    importc: "gtk_cell_renderer_get_preferred_height", libgtk.}
proc getPreferredWidthForHeight*(cell: CellRenderer;
    widget: Widget; height: cint; minimumWidth: var cint; naturalWidth: var cint) {.
    importc: "gtk_cell_renderer_get_preferred_width_for_height", libgtk.}
proc getPreferredSize*(cell: CellRenderer;
                                     widget: Widget;
                                     minimumSize: Requisition;
                                     naturalSize: Requisition) {.
    importc: "gtk_cell_renderer_get_preferred_size", libgtk.}
proc getAlignedArea*(cell: CellRenderer;
                                   widget: Widget;
                                   flags: CellRendererState;
                                   cellArea: gdk3.Rectangle;
                                   alignedArea: gdk3.Rectangle) {.
    importc: "gtk_cell_renderer_get_aligned_area", libgtk.}
proc getSize*(cell: CellRenderer; widget: Widget;
                            cellArea: gdk3.Rectangle; xOffset: var cint;
                            yOffset: var cint; width: var cint; height: var cint) {.
    importc: "gtk_cell_renderer_get_size", libgtk.}
proc render*(cell: CellRenderer; cr: cairo.Context;
                           widget: Widget; backgroundArea: gdk3.Rectangle;
                           cellArea: gdk3.Rectangle; flags: CellRendererState) {.
    importc: "gtk_cell_renderer_render", libgtk.}
proc activate*(cell: CellRenderer; event: gdk3.Event;
                             widget: Widget; path: cstring;
                             backgroundArea: gdk3.Rectangle;
                             cellArea: gdk3.Rectangle;
                             flags: CellRendererState): Gboolean {.
    importc: "gtk_cell_renderer_activate", libgtk.}
proc startEditing*(cell: CellRenderer; event: gdk3.Event;
                                 widget: Widget; path: cstring;
                                 backgroundArea: gdk3.Rectangle;
                                 cellArea: gdk3.Rectangle;
                                 flags: CellRendererState): CellEditable {.
    importc: "gtk_cell_renderer_start_editing", libgtk.}
proc setFixedSize*(cell: CellRenderer; width: cint; height: cint) {.
    importc: "gtk_cell_renderer_set_fixed_size", libgtk.}
proc `fixedSize=`*(cell: CellRenderer; width: cint; height: cint) {.
    importc: "gtk_cell_renderer_set_fixed_size", libgtk.}
proc getFixedSize*(cell: CellRenderer; width: var cint;
                                 height: var cint) {.
    importc: "gtk_cell_renderer_get_fixed_size", libgtk.}
proc setAlignment*(cell: CellRenderer; xalign: cfloat;
                                 yalign: cfloat) {.
    importc: "gtk_cell_renderer_set_alignment", libgtk.}
proc `alignment=`*(cell: CellRenderer; xalign: cfloat;
                                 yalign: cfloat) {.
    importc: "gtk_cell_renderer_set_alignment", libgtk.}
proc getAlignment*(cell: CellRenderer; xalign: var cfloat;
                                 yalign: var cfloat) {.
    importc: "gtk_cell_renderer_get_alignment", libgtk.}
proc setPadding*(cell: CellRenderer; xpad: cint; ypad: cint) {.
    importc: "gtk_cell_renderer_set_padding", libgtk.}
proc `padding=`*(cell: CellRenderer; xpad: cint; ypad: cint) {.
    importc: "gtk_cell_renderer_set_padding", libgtk.}
proc getPadding*(cell: CellRenderer; xpad: var cint;
                               ypad: var cint) {.
    importc: "gtk_cell_renderer_get_padding", libgtk.}
proc setVisible*(cell: CellRenderer; visible: Gboolean) {.
    importc: "gtk_cell_renderer_set_visible", libgtk.}
proc `visible=`*(cell: CellRenderer; visible: Gboolean) {.
    importc: "gtk_cell_renderer_set_visible", libgtk.}
proc getVisible*(cell: CellRenderer): Gboolean {.
    importc: "gtk_cell_renderer_get_visible", libgtk.}
proc visible*(cell: CellRenderer): Gboolean {.
    importc: "gtk_cell_renderer_get_visible", libgtk.}
proc setSensitive*(cell: CellRenderer; sensitive: Gboolean) {.
    importc: "gtk_cell_renderer_set_sensitive", libgtk.}
proc `sensitive=`*(cell: CellRenderer; sensitive: Gboolean) {.
    importc: "gtk_cell_renderer_set_sensitive", libgtk.}
proc getSensitive*(cell: CellRenderer): Gboolean {.
    importc: "gtk_cell_renderer_get_sensitive", libgtk.}
proc sensitive*(cell: CellRenderer): Gboolean {.
    importc: "gtk_cell_renderer_get_sensitive", libgtk.}
proc isActivatable*(cell: CellRenderer): Gboolean {.
    importc: "gtk_cell_renderer_is_activatable", libgtk.}

proc stopEditing*(cell: CellRenderer; canceled: Gboolean) {.
    importc: "gtk_cell_renderer_stop_editing", libgtk.}

discard """ proc "calcOffset*(cell: CellRenderer;
                               cellArea: gdk3.Rectangle;
                               direction: TextDirection; width: cint;
                               height: cint; xOffset: ptr cint; yOffset: ptr cint) {.
    importc: "_gtk_cell_renderer_calc_offset", libgtk.}"""

proc getState*(cell: CellRenderer; widget: Widget;
                             cellState: CellRendererState): StateFlags {.
    importc: "gtk_cell_renderer_get_state", libgtk.}

proc state*(cell: CellRenderer; widget: Widget;
                             cellState: CellRendererState): StateFlags {.
    importc: "gtk_cell_renderer_get_state", libgtk.}
proc setAccessibleType*(
    rendererClass: CellRendererClass; `type`: GType) {.
    importc: "gtk_cell_renderer_class_set_accessible_type", libgtk.}
proc `accessibleType=`*(
    rendererClass: CellRendererClass; `type`: GType) {.
    importc: "gtk_cell_renderer_class_set_accessible_type", libgtk.}

discard """ proc "getAccessibleType*(renderer: CellRenderer): GType {.
    importc: "_gtk_cell_renderer_get_accessible_type", libgtk.}"""

template typeTreeSortable*(): expr =
  (treeSortableGetType())

template treeSortable*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeSortable, TreeSortableObj))

template treeSortableClass*(obj: expr): expr =
  (gTypeCheckClassCast(obj, typeTreeSortable, TreeSortableIfaceObj))

template isTreeSortable*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeSortable))

template treeSortableGetIface*(obj: expr): expr =
  (gTypeInstanceGetInterface(obj, typeTreeSortable, TreeSortableIfaceObj))

const
  TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID* = (- 1)

const
  TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID* = (- 2)

type
  CellCallback* = proc (renderer: CellRenderer; data: Gpointer): Gboolean {.cdecl.}
type
  CellArea* =  ptr CellAreaObj
  CellAreaPtr* = ptr CellAreaObj
  CellAreaObj = object of gobject.GInitiallyUnownedObj
    priv27: pointer
type
  CellAllocCallback* = proc (renderer: CellRenderer;
                             cellArea: gdk3.Rectangle;
                             cellBackground: gdk3.Rectangle; data: Gpointer): Gboolean {.cdecl.}

  CellAreaContext* =  ptr CellAreaContextObj
  CellAreaContextPtr* = ptr CellAreaContextObj
  CellAreaContextObj*{.final.} = object of GObjectObj
    priv28: pointer

  CellAreaClass* =  ptr CellAreaClassObj
  CellAreaClassPtr* = ptr CellAreaClassObj
  CellAreaClassObj = object of gobject.GInitiallyUnownedClassObj
    add*: proc (area: CellArea; renderer: CellRenderer) {.cdecl.}
    remove*: proc (area: CellArea; renderer: CellRenderer) {.cdecl.}
    foreach*: proc (area: CellArea; callback: CellCallback;
                  callbackData: Gpointer) {.cdecl.}
    foreachAlloc*: proc (area: CellArea; context: CellAreaContext;
                       widget: Widget; cellArea: gdk3.Rectangle;
                       backgroundArea: gdk3.Rectangle;
                       callback: CellAllocCallback; callbackData: Gpointer) {.cdecl.}
    event*: proc (area: CellArea; context: CellAreaContext;
                widget: Widget; event: gdk3.Event;
                cellArea: gdk3.Rectangle; flags: CellRendererState): cint {.cdecl.}
    render*: proc (area: CellArea; context: CellAreaContext;
                 widget: Widget; cr: cairo.Context;
                 backgroundArea: gdk3.Rectangle; cellArea: gdk3.Rectangle;
                 flags: CellRendererState; paintFocus: Gboolean) {.cdecl.}
    applyAttributes*: proc (area: CellArea; treeModel: TreeModel;
                          iter: TreeIter; isExpander: Gboolean;
                          isExpanded: Gboolean) {.cdecl.}
    createContext*: proc (area: CellArea): CellAreaContext {.cdecl.}
    copyContext*: proc (area: CellArea; context: CellAreaContext): CellAreaContext {.cdecl.}
    getRequestMode*: proc (area: CellArea): SizeRequestMode {.cdecl.}
    getPreferredWidth*: proc (area: CellArea; context: CellAreaContext;
                            widget: Widget; minimumWidth: var cint;
                            naturalWidth: var cint) {.cdecl.}
    getPreferredHeightForWidth*: proc (area: CellArea;
                                     context: CellAreaContext;
                                     widget: Widget; width: cint;
                                     minimumHeight: var cint;
                                     naturalHeight: var cint) {.cdecl.}
    getPreferredHeight*: proc (area: CellArea;
                             context: CellAreaContext;
                             widget: Widget; minimumHeight: var cint;
                             naturalHeight: var cint) {.cdecl.}
    getPreferredWidthForHeight*: proc (area: CellArea;
                                     context: CellAreaContext;
                                     widget: Widget; height: cint;
                                     minimumWidth: var cint; naturalWidth: var cint) {.cdecl.}
    setCellProperty*: proc (area: CellArea; renderer: CellRenderer;
                          propertyId: cuint; value: gobject.GValue; pspec: gobject.GParamSpec) {.cdecl.}
    getCellProperty*: proc (area: CellArea; renderer: CellRenderer;
                          propertyId: cuint; value: gobject.GValue; pspec: gobject.GParamSpec) {.cdecl.}
    focus*: proc (area: CellArea; direction: DirectionType): Gboolean {.cdecl.}
    isActivatable*: proc (area: CellArea): Gboolean {.cdecl.}
    activate*: proc (area: CellArea; context: CellAreaContext;
                   widget: Widget; cellArea: gdk3.Rectangle;
                   flags: CellRendererState; editOnly: Gboolean): Gboolean {.cdecl.}
    gtkReserved181*: proc () {.cdecl.}
    gtkReserved182*: proc () {.cdecl.}
    gtkReserved183*: proc () {.cdecl.}
    gtkReserved184*: proc () {.cdecl.}
    gtkReserved185*: proc () {.cdecl.}
    gtkReserved186*: proc () {.cdecl.}
    gtkReserved187*: proc () {.cdecl.}
    gtkReserved188*: proc () {.cdecl.}

proc treeSortableGetType*(): GType {.importc: "gtk_tree_sortable_get_type",
                                     libgtk.}
proc sortColumnChanged*(sortable: TreeSortable) {.
    importc: "gtk_tree_sortable_sort_column_changed", libgtk.}
proc getSortColumnId*(sortable: TreeSortable;
                                    sortColumnId: var cint; order: var SortType): Gboolean {.
    importc: "gtk_tree_sortable_get_sort_column_id", libgtk.}
proc sortColumnId*(sortable: TreeSortable;
                                    sortColumnId: var cint; order: var SortType): Gboolean {.
    importc: "gtk_tree_sortable_get_sort_column_id", libgtk.}
proc setSortColumnId*(sortable: TreeSortable;
                                    sortColumnId: cint; order: SortType) {.
    importc: "gtk_tree_sortable_set_sort_column_id", libgtk.}
proc `sortColumnId=`*(sortable: TreeSortable;
                                    sortColumnId: cint; order: SortType) {.
    importc: "gtk_tree_sortable_set_sort_column_id", libgtk.}
proc setSortFunc*(sortable: TreeSortable; sortColumnId: cint;
                                sortFunc: TreeIterCompareFunc;
                                userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_sortable_set_sort_func", libgtk.}
proc `sortFunc=`*(sortable: TreeSortable; sortColumnId: cint;
                                sortFunc: TreeIterCompareFunc;
                                userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_sortable_set_sort_func", libgtk.}
proc setDefaultSortFunc*(sortable: TreeSortable;
                                       sortFunc: TreeIterCompareFunc;
                                       userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_sortable_set_default_sort_func", libgtk.}
proc `defaultSortFunc=`*(sortable: TreeSortable;
                                       sortFunc: TreeIterCompareFunc;
                                       userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_sortable_set_default_sort_func", libgtk.}
proc hasDefaultSortFunc*(sortable: TreeSortable): Gboolean {.
    importc: "gtk_tree_sortable_has_default_sort_func", libgtk.}

template typeCellArea*(): expr =
  (cellAreaGetType())

template cellArea*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellArea, CellAreaObj))

template cellAreaClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellArea, CellAreaClassObj))

template isCellArea*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellArea))

template isCellAreaClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellArea))

template cellAreaGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellArea, CellAreaClassObj))

template cellAreaWarnInvalidCellPropertyId*(
    `object`, propertyId, pspec: expr): expr =
  g_Object_Warn_Invalid_Pspec(`object`, "cell property id", propertyId, pspec)

type
  TreeViewColumn* =  ptr TreeViewColumnObj
  TreeViewColumnPtr* = ptr TreeViewColumnObj
  TreeViewColumnObj*{.final.} = object of gobject.GInitiallyUnownedObj
    priv29: pointer

  TreeViewColumnClass* =  ptr TreeViewColumnClassObj
  TreeViewColumnClassPtr* = ptr TreeViewColumnClassObj
  TreeViewColumnClassObj*{.final.} = object of gobject.GInitiallyUnownedClassObj
    clicked*: proc (treeColumn: TreeViewColumn) {.cdecl.}
    gtkReserved191*: proc () {.cdecl.}
    gtkReserved192*: proc () {.cdecl.}
    gtkReserved193*: proc () {.cdecl.}
    gtkReserved194*: proc () {.cdecl.}

proc cellAreaGetType*(): GType {.importc: "gtk_cell_area_get_type", libgtk.}

proc add*(area: CellArea; renderer: CellRenderer) {.
    importc: "gtk_cell_area_add", libgtk.}
proc remove*(area: CellArea; renderer: CellRenderer) {.
    importc: "gtk_cell_area_remove", libgtk.}
proc hasRenderer*(area: CellArea; renderer: CellRenderer): Gboolean {.
    importc: "gtk_cell_area_has_renderer", libgtk.}
proc foreach*(area: CellArea; callback: CellCallback;
                        callbackData: Gpointer) {.
    importc: "gtk_cell_area_foreach", libgtk.}
proc foreachAlloc*(area: CellArea;
                             context: CellAreaContext;
                             widget: Widget; cellArea: gdk3.Rectangle;
                             backgroundArea: gdk3.Rectangle;
                             callback: CellAllocCallback;
                             callbackData: Gpointer) {.
    importc: "gtk_cell_area_foreach_alloc", libgtk.}
proc event*(area: CellArea; context: CellAreaContext;
                      widget: Widget; event: gdk3.Event;
                      cellArea: gdk3.Rectangle; flags: CellRendererState): cint {.
    importc: "gtk_cell_area_event", libgtk.}
proc render*(area: CellArea; context: CellAreaContext;
                       widget: Widget; cr: cairo.Context;
                       backgroundArea: gdk3.Rectangle;
                       cellArea: gdk3.Rectangle; flags: CellRendererState;
                       paintFocus: Gboolean) {.importc: "gtk_cell_area_render",
    libgtk.}
proc getCellAllocation*(area: CellArea;
                                  context: CellAreaContext;
                                  widget: Widget;
                                  renderer: CellRenderer;
                                  cellArea: gdk3.Rectangle;
                                  allocation: gdk3.Rectangle) {.
    importc: "gtk_cell_area_get_cell_allocation", libgtk.}
proc getCellAtPosition*(area: CellArea;
                                  context: CellAreaContext;
                                  widget: Widget;
                                  cellArea: gdk3.Rectangle; x: cint; y: cint;
                                  allocArea: gdk3.Rectangle): CellRenderer {.
    importc: "gtk_cell_area_get_cell_at_position", libgtk.}
proc cellAtPosition*(area: CellArea;
                                  context: CellAreaContext;
                                  widget: Widget;
                                  cellArea: gdk3.Rectangle; x: cint; y: cint;
                                  allocArea: gdk3.Rectangle): CellRenderer {.
    importc: "gtk_cell_area_get_cell_at_position", libgtk.}

proc createContext*(area: CellArea): CellAreaContext {.
    importc: "gtk_cell_area_create_context", libgtk.}
proc copyContext*(area: CellArea; context: CellAreaContext): CellAreaContext {.
    importc: "gtk_cell_area_copy_context", libgtk.}
proc getRequestMode*(area: CellArea): SizeRequestMode {.
    importc: "gtk_cell_area_get_request_mode", libgtk.}
proc requestMode*(area: CellArea): SizeRequestMode {.
    importc: "gtk_cell_area_get_request_mode", libgtk.}
proc getPreferredWidth*(area: CellArea;
                                  context: CellAreaContext;
                                  widget: Widget; minimumWidth: var cint;
                                  naturalWidth: var cint) {.
    importc: "gtk_cell_area_get_preferred_width", libgtk.}
proc getPreferredHeightForWidth*(area: CellArea;
    context: CellAreaContext; widget: Widget; width: cint;
    minimumHeight: var cint; naturalHeight: var cint) {.
    importc: "gtk_cell_area_get_preferred_height_for_width", libgtk.}
proc getPreferredHeight*(area: CellArea;
                                   context: CellAreaContext;
                                   widget: Widget; minimumHeight: var cint;
                                   naturalHeight: var cint) {.
    importc: "gtk_cell_area_get_preferred_height", libgtk.}
proc getPreferredWidthForHeight*(area: CellArea;
    context: CellAreaContext; widget: Widget; height: cint;
    minimumWidth: var cint; naturalWidth: var cint) {.
    importc: "gtk_cell_area_get_preferred_width_for_height", libgtk.}
proc getCurrentPathString*(area: CellArea): cstring {.
    importc: "gtk_cell_area_get_current_path_string", libgtk.}
proc currentPathString*(area: CellArea): cstring {.
    importc: "gtk_cell_area_get_current_path_string", libgtk.}

proc applyAttributes*(area: CellArea; treeModel: TreeModel;
                                iter: TreeIter; isExpander: Gboolean;
                                isExpanded: Gboolean) {.
    importc: "gtk_cell_area_apply_attributes", libgtk.}
proc attributeConnect*(area: CellArea;
                                 renderer: CellRenderer; attribute: cstring;
                                 column: cint) {.
    importc: "gtk_cell_area_attribute_connect", libgtk.}
proc attributeDisconnect*(area: CellArea;
                                    renderer: CellRenderer;
                                    attribute: cstring) {.
    importc: "gtk_cell_area_attribute_disconnect", libgtk.}
proc attributeGetColumn*(area: CellArea;
                                   renderer: CellRenderer;
                                   attribute: cstring): cint {.
    importc: "gtk_cell_area_attribute_get_column", libgtk.}

proc installCellProperty*(aclass: CellAreaClass;
    propertyId: cuint; pspec: gobject.GParamSpec) {.
    importc: "gtk_cell_area_class_install_cell_property", libgtk.}
proc findCellProperty*(aclass: CellAreaClass;
                                      propertyName: cstring): gobject.GParamSpec {.
    importc: "gtk_cell_area_class_find_cell_property", libgtk.}
proc listCellProperties*(aclass: CellAreaClass;
                                        nProperties: var cuint): var gobject.GParamSpec {.
    importc: "gtk_cell_area_class_list_cell_properties", libgtk.}
proc addWithProperties*(area: CellArea;
                                  renderer: CellRenderer;
                                  firstPropName: cstring) {.varargs,
    importc: "gtk_cell_area_add_with_properties", libgtk.}
proc cellSet*(area: CellArea; renderer: CellRenderer;
                        firstPropName: cstring) {.varargs,
    importc: "gtk_cell_area_cell_set", libgtk.}
proc cellGet*(area: CellArea; renderer: CellRenderer;
                        firstPropName: cstring) {.varargs,
    importc: "gtk_cell_area_cell_get", libgtk.}

discard """ proc "cellSetValist*(area: CellArea; renderer: CellRenderer;
                              firstPropertyName: cstring; varArgs: VaList) {.
    importc: "gtk_cell_area_cell_set_valist", libgtk.}"""

discard """ proc "cellGetValist*(area: CellArea; renderer: CellRenderer;
                              firstPropertyName: cstring; varArgs: VaList) {.
    importc: "gtk_cell_area_cell_get_valist", libgtk.}"""

proc cellSetProperty*(area: CellArea;
                                renderer: CellRenderer;
                                propertyName: cstring; value: gobject.GValue) {.
    importc: "gtk_cell_area_cell_set_property", libgtk.}
proc cellGetProperty*(area: CellArea;
                                renderer: CellRenderer;
                                propertyName: cstring; value: gobject.GValue) {.
    importc: "gtk_cell_area_cell_get_property", libgtk.}

proc isActivatable*(area: CellArea): Gboolean {.
    importc: "gtk_cell_area_is_activatable", libgtk.}
proc activate*(area: CellArea; context: CellAreaContext;
                         widget: Widget; cellArea: gdk3.Rectangle;
                         flags: CellRendererState; editOnly: Gboolean): Gboolean {.
    importc: "gtk_cell_area_activate", libgtk.}
proc focus*(area: CellArea; direction: DirectionType): Gboolean {.
    importc: "gtk_cell_area_focus", libgtk.}
proc setFocusCell*(area: CellArea; renderer: CellRenderer) {.
    importc: "gtk_cell_area_set_focus_cell", libgtk.}
proc `focusCell=`*(area: CellArea; renderer: CellRenderer) {.
    importc: "gtk_cell_area_set_focus_cell", libgtk.}
proc getFocusCell*(area: CellArea): CellRenderer {.
    importc: "gtk_cell_area_get_focus_cell", libgtk.}
proc focusCell*(area: CellArea): CellRenderer {.
    importc: "gtk_cell_area_get_focus_cell", libgtk.}

proc addFocusSibling*(area: CellArea;
                                renderer: CellRenderer;
                                sibling: CellRenderer) {.
    importc: "gtk_cell_area_add_focus_sibling", libgtk.}
proc removeFocusSibling*(area: CellArea;
                                   renderer: CellRenderer;
                                   sibling: CellRenderer) {.
    importc: "gtk_cell_area_remove_focus_sibling", libgtk.}
proc isFocusSibling*(area: CellArea;
                               renderer: CellRenderer;
                               sibling: CellRenderer): Gboolean {.
    importc: "gtk_cell_area_is_focus_sibling", libgtk.}
proc getFocusSiblings*(area: CellArea;
                                 renderer: CellRenderer): glib.GList {.
    importc: "gtk_cell_area_get_focus_siblings", libgtk.}
proc focusSiblings*(area: CellArea;
                                 renderer: CellRenderer): glib.GList {.
    importc: "gtk_cell_area_get_focus_siblings", libgtk.}
proc getFocusFromSibling*(area: CellArea;
                                    renderer: CellRenderer): CellRenderer {.
    importc: "gtk_cell_area_get_focus_from_sibling", libgtk.}
proc focusFromSibling*(area: CellArea;
                                    renderer: CellRenderer): CellRenderer {.
    importc: "gtk_cell_area_get_focus_from_sibling", libgtk.}

proc getEditedCell*(area: CellArea): CellRenderer {.
    importc: "gtk_cell_area_get_edited_cell", libgtk.}

proc editedCell*(area: CellArea): CellRenderer {.
    importc: "gtk_cell_area_get_edited_cell", libgtk.}
proc getEditWidget*(area: CellArea): CellEditable {.
    importc: "gtk_cell_area_get_edit_widget", libgtk.}
proc editWidget*(area: CellArea): CellEditable {.
    importc: "gtk_cell_area_get_edit_widget", libgtk.}
proc activateCell*(area: CellArea; widget: Widget;
                             renderer: CellRenderer; event: gdk3.Event;
                             cellArea: gdk3.Rectangle;
                             flags: CellRendererState): Gboolean {.
    importc: "gtk_cell_area_activate_cell", libgtk.}
proc stopEditing*(area: CellArea; canceled: Gboolean) {.
    importc: "gtk_cell_area_stop_editing", libgtk.}

proc innerCellArea*(area: CellArea; widget: Widget;
                              cellArea: gdk3.Rectangle;
                              innerArea: gdk3.Rectangle) {.
    importc: "gtk_cell_area_inner_cell_area", libgtk.}

proc requestRenderer*(area: CellArea;
                                renderer: CellRenderer;
                                orientation: Orientation;
                                widget: Widget; forSize: cint;
                                minimumSize: var cint; naturalSize: var cint) {.
    importc: "gtk_cell_area_request_renderer", libgtk.}

discard """ proc "setCellDataFuncWithProxy*(area: CellArea;
    cell: CellRenderer; `func`: GFunc; funcData: Gpointer;
    destroy: GDestroyNotify; proxy: Gpointer) {.
    importc: "_gtk_cell_area_set_cell_data_func_with_proxy", libgtk.}"""

template typeTreeViewColumn*(): expr =
  (treeViewColumnGetType())

template treeViewColumn*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeViewColumn, TreeViewColumnObj))

template treeViewColumnClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTreeViewColumn, TreeViewColumnClassObj))

template isTreeViewColumn*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeViewColumn))

template isTreeViewColumnClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTreeViewColumn))

template treeViewColumnGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTreeViewColumn, TreeViewColumnClassObj))

type
  TreeViewColumnSizing* {.size: sizeof(cint), pure.} = enum
    GROW_ONLY, AUTOSIZE,
    FIXED

type
  TreeCellDataFunc* = proc (treeColumn: TreeViewColumn;
                            cell: CellRenderer; treeModel: TreeModel;
                            iter: TreeIter; data: Gpointer) {.cdecl.}

proc treeViewColumnGetType*(): GType {.importc: "gtk_tree_view_column_get_type",
                                       libgtk.}
proc newTreeViewColumn*(): TreeViewColumn {.
    importc: "gtk_tree_view_column_new", libgtk.}
proc newTreeViewColumn*(area: CellArea): TreeViewColumn {.
    importc: "gtk_tree_view_column_new_with_area", libgtk.}
proc newTreeViewColumn*(title: cstring; cell: CellRenderer): TreeViewColumn {.
    varargs, importc: "gtk_tree_view_column_new_with_attributes", libgtk.}
proc packStart*(treeColumn: TreeViewColumn;
                                cell: CellRenderer; expand: Gboolean) {.
    importc: "gtk_tree_view_column_pack_start", libgtk.}
proc packEnd*(treeColumn: TreeViewColumn;
                              cell: CellRenderer; expand: Gboolean) {.
    importc: "gtk_tree_view_column_pack_end", libgtk.}
proc clear*(treeColumn: TreeViewColumn) {.
    importc: "gtk_tree_view_column_clear", libgtk.}
proc addAttribute*(treeColumn: TreeViewColumn;
                                   cellRenderer: CellRenderer;
                                   attribute: cstring; column: cint) {.
    importc: "gtk_tree_view_column_add_attribute", libgtk.}
proc setAttributes*(treeColumn: TreeViewColumn;
                                    cellRenderer: CellRenderer) {.varargs,
    importc: "gtk_tree_view_column_set_attributes", libgtk.}
proc `attributes=`*(treeColumn: TreeViewColumn;
                                    cellRenderer: CellRenderer) {.varargs,
    importc: "gtk_tree_view_column_set_attributes", libgtk.}
proc setCellDataFunc*(treeColumn: TreeViewColumn;
                                      cellRenderer: CellRenderer;
                                      `func`: TreeCellDataFunc;
                                      funcData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_column_set_cell_data_func", libgtk.}
proc `cellDataFunc=`*(treeColumn: TreeViewColumn;
                                      cellRenderer: CellRenderer;
                                      `func`: TreeCellDataFunc;
                                      funcData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_column_set_cell_data_func", libgtk.}
proc clearAttributes*(treeColumn: TreeViewColumn;
                                      cellRenderer: CellRenderer) {.
    importc: "gtk_tree_view_column_clear_attributes", libgtk.}
proc setSpacing*(treeColumn: TreeViewColumn; spacing: cint) {.
    importc: "gtk_tree_view_column_set_spacing", libgtk.}
proc `spacing=`*(treeColumn: TreeViewColumn; spacing: cint) {.
    importc: "gtk_tree_view_column_set_spacing", libgtk.}
proc getSpacing*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_spacing", libgtk.}
proc spacing*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_spacing", libgtk.}
proc setVisible*(treeColumn: TreeViewColumn;
                                 visible: Gboolean) {.
    importc: "gtk_tree_view_column_set_visible", libgtk.}
proc `visible=`*(treeColumn: TreeViewColumn;
                                 visible: Gboolean) {.
    importc: "gtk_tree_view_column_set_visible", libgtk.}
proc getVisible*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_visible", libgtk.}
proc visible*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_visible", libgtk.}
proc setResizable*(treeColumn: TreeViewColumn;
                                   resizable: Gboolean) {.
    importc: "gtk_tree_view_column_set_resizable", libgtk.}
proc `resizable=`*(treeColumn: TreeViewColumn;
                                   resizable: Gboolean) {.
    importc: "gtk_tree_view_column_set_resizable", libgtk.}
proc getResizable*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_resizable", libgtk.}
proc resizable*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_resizable", libgtk.}
proc setSizing*(treeColumn: TreeViewColumn;
                                `type`: TreeViewColumnSizing) {.
    importc: "gtk_tree_view_column_set_sizing", libgtk.}
proc `sizing=`*(treeColumn: TreeViewColumn;
                                `type`: TreeViewColumnSizing) {.
    importc: "gtk_tree_view_column_set_sizing", libgtk.}
proc getSizing*(treeColumn: TreeViewColumn): TreeViewColumnSizing {.
    importc: "gtk_tree_view_column_get_sizing", libgtk.}
proc sizing*(treeColumn: TreeViewColumn): TreeViewColumnSizing {.
    importc: "gtk_tree_view_column_get_sizing", libgtk.}
proc getXOffset*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_x_offset", libgtk.}
proc xOffset*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_x_offset", libgtk.}
proc getWidth*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_width", libgtk.}
proc width*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_width", libgtk.}
proc getFixedWidth*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_fixed_width", libgtk.}
proc fixedWidth*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_fixed_width", libgtk.}
proc setFixedWidth*(treeColumn: TreeViewColumn;
                                    fixedWidth: cint) {.
    importc: "gtk_tree_view_column_set_fixed_width", libgtk.}
proc `fixedWidth=`*(treeColumn: TreeViewColumn;
                                    fixedWidth: cint) {.
    importc: "gtk_tree_view_column_set_fixed_width", libgtk.}
proc setMinWidth*(treeColumn: TreeViewColumn; minWidth: cint) {.
    importc: "gtk_tree_view_column_set_min_width", libgtk.}
proc `minWidth=`*(treeColumn: TreeViewColumn; minWidth: cint) {.
    importc: "gtk_tree_view_column_set_min_width", libgtk.}
proc getMinWidth*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_min_width", libgtk.}
proc minWidth*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_min_width", libgtk.}
proc setMaxWidth*(treeColumn: TreeViewColumn; maxWidth: cint) {.
    importc: "gtk_tree_view_column_set_max_width", libgtk.}
proc `maxWidth=`*(treeColumn: TreeViewColumn; maxWidth: cint) {.
    importc: "gtk_tree_view_column_set_max_width", libgtk.}
proc getMaxWidth*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_max_width", libgtk.}
proc maxWidth*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_max_width", libgtk.}
proc clicked*(treeColumn: TreeViewColumn) {.
    importc: "gtk_tree_view_column_clicked", libgtk.}

proc setTitle*(treeColumn: TreeViewColumn; title: cstring) {.
    importc: "gtk_tree_view_column_set_title", libgtk.}

proc `title=`*(treeColumn: TreeViewColumn; title: cstring) {.
    importc: "gtk_tree_view_column_set_title", libgtk.}
proc getTitle*(treeColumn: TreeViewColumn): cstring {.
    importc: "gtk_tree_view_column_get_title", libgtk.}
proc title*(treeColumn: TreeViewColumn): cstring {.
    importc: "gtk_tree_view_column_get_title", libgtk.}
proc setExpand*(treeColumn: TreeViewColumn; expand: Gboolean) {.
    importc: "gtk_tree_view_column_set_expand", libgtk.}
proc `expand=`*(treeColumn: TreeViewColumn; expand: Gboolean) {.
    importc: "gtk_tree_view_column_set_expand", libgtk.}
proc getExpand*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_expand", libgtk.}
proc expand*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_expand", libgtk.}
proc setClickable*(treeColumn: TreeViewColumn;
                                   clickable: Gboolean) {.
    importc: "gtk_tree_view_column_set_clickable", libgtk.}
proc `clickable=`*(treeColumn: TreeViewColumn;
                                   clickable: Gboolean) {.
    importc: "gtk_tree_view_column_set_clickable", libgtk.}
proc getClickable*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_clickable", libgtk.}
proc clickable*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_clickable", libgtk.}
proc setWidget*(treeColumn: TreeViewColumn;
                                widget: Widget) {.
    importc: "gtk_tree_view_column_set_widget", libgtk.}
proc `widget=`*(treeColumn: TreeViewColumn;
                                widget: Widget) {.
    importc: "gtk_tree_view_column_set_widget", libgtk.}
proc getWidget*(treeColumn: TreeViewColumn): Widget {.
    importc: "gtk_tree_view_column_get_widget", libgtk.}
proc widget*(treeColumn: TreeViewColumn): Widget {.
    importc: "gtk_tree_view_column_get_widget", libgtk.}
proc setAlignment*(treeColumn: TreeViewColumn;
                                   xalign: cfloat) {.
    importc: "gtk_tree_view_column_set_alignment", libgtk.}
proc `alignment=`*(treeColumn: TreeViewColumn;
                                   xalign: cfloat) {.
    importc: "gtk_tree_view_column_set_alignment", libgtk.}
proc getAlignment*(treeColumn: TreeViewColumn): cfloat {.
    importc: "gtk_tree_view_column_get_alignment", libgtk.}
proc alignment*(treeColumn: TreeViewColumn): cfloat {.
    importc: "gtk_tree_view_column_get_alignment", libgtk.}
proc setReorderable*(treeColumn: TreeViewColumn;
                                     reorderable: Gboolean) {.
    importc: "gtk_tree_view_column_set_reorderable", libgtk.}
proc `reorderable=`*(treeColumn: TreeViewColumn;
                                     reorderable: Gboolean) {.
    importc: "gtk_tree_view_column_set_reorderable", libgtk.}
proc getReorderable*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_reorderable", libgtk.}
proc reorderable*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_reorderable", libgtk.}

proc setSortColumnId*(treeColumn: TreeViewColumn;
                                      sortColumnId: cint) {.
    importc: "gtk_tree_view_column_set_sort_column_id", libgtk.}

proc `sortColumnId=`*(treeColumn: TreeViewColumn;
                                      sortColumnId: cint) {.
    importc: "gtk_tree_view_column_set_sort_column_id", libgtk.}
proc getSortColumnId*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_sort_column_id", libgtk.}
proc sortColumnId*(treeColumn: TreeViewColumn): cint {.
    importc: "gtk_tree_view_column_get_sort_column_id", libgtk.}
proc setSortIndicator*(treeColumn: TreeViewColumn;
                                       setting: Gboolean) {.
    importc: "gtk_tree_view_column_set_sort_indicator", libgtk.}
proc `sortIndicator=`*(treeColumn: TreeViewColumn;
                                       setting: Gboolean) {.
    importc: "gtk_tree_view_column_set_sort_indicator", libgtk.}
proc getSortIndicator*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_sort_indicator", libgtk.}
proc sortIndicator*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_get_sort_indicator", libgtk.}
proc setSortOrder*(treeColumn: TreeViewColumn;
                                   order: SortType) {.
    importc: "gtk_tree_view_column_set_sort_order", libgtk.}
proc `sortOrder=`*(treeColumn: TreeViewColumn;
                                   order: SortType) {.
    importc: "gtk_tree_view_column_set_sort_order", libgtk.}
proc getSortOrder*(treeColumn: TreeViewColumn): SortType {.
    importc: "gtk_tree_view_column_get_sort_order", libgtk.}
proc sortOrder*(treeColumn: TreeViewColumn): SortType {.
    importc: "gtk_tree_view_column_get_sort_order", libgtk.}

proc cellSetCellData*(treeColumn: TreeViewColumn;
                                      treeModel: TreeModel;
                                      iter: TreeIter; isExpander: Gboolean;
                                      isExpanded: Gboolean) {.
    importc: "gtk_tree_view_column_cell_set_cell_data", libgtk.}
proc cellGetSize*(treeColumn: TreeViewColumn;
                                  cellArea: gdk3.Rectangle; xOffset: var cint;
                                  yOffset: var cint; width: var cint; height: var cint) {.
    importc: "gtk_tree_view_column_cell_get_size", libgtk.}
proc cellIsVisible*(treeColumn: TreeViewColumn): Gboolean {.
    importc: "gtk_tree_view_column_cell_is_visible", libgtk.}
proc focusCell*(treeColumn: TreeViewColumn;
                                cell: CellRenderer) {.
    importc: "gtk_tree_view_column_focus_cell", libgtk.}
proc cellGetPosition*(treeColumn: TreeViewColumn;
                                      cellRenderer: CellRenderer;
                                      xOffset: var cint; width: var cint): Gboolean {.
    importc: "gtk_tree_view_column_cell_get_position", libgtk.}
proc queueResize*(treeColumn: TreeViewColumn) {.
    importc: "gtk_tree_view_column_queue_resize", libgtk.}

template typeTextAttributes*(): expr =
  (textAttributesGetType())

type
  INNER_C_UNION_4069682962889904078* = object {.union.}
    rgba*: array[2, gdk3.RGBA]
    padding*: array[4, cuint]

  TextAppearance* =  ptr TextAppearanceObj
  TextAppearancePtr* = ptr TextAppearanceObj
  TextAppearanceObj* = object
    bgColor*: gdk3.ColorObj
    fgColor*: gdk3.ColorObj
    rise*: cint
    underline* {.bitsize: 4.}: cuint
    strikethrough* {.bitsize: 1.}: cuint
    drawBg* {.bitsize: 1.}: cuint
    insideSelection* {.bitsize: 1.}: cuint
    isText* {.bitsize: 1.}: cuint
    ano18295922875522257078*: INNER_C_UNION_4069682962889904078

type
  INNER_C_UNION_9580594885298540608* = object {.union.}
    fontFeatures*: cstring
    padding*: array[2, cuint]

  TextAttributes* =  ptr TextAttributesObj
  TextAttributesPtr* = ptr TextAttributesObj
  TextAttributesObj* = object
    refcount*: cuint
    appearance*: TextAppearanceObj
    justification*: Justification
    direction*: TextDirection
    font*: pango.FontDescription
    fontScale*: cdouble
    leftMargin*: cint
    rightMargin*: cint
    indent*: cint
    pixelsAboveLines*: cint
    pixelsBelowLines*: cint
    pixelsInsideWrap*: cint
    tabs*: pango.TabArray
    wrapMode*: WrapMode
    language*: pango.Language
    pgBgColor*: gdk3.Color
    invisible* {.bitsize: 1.}: cuint
    bgFullHeight* {.bitsize: 1.}: cuint
    editable* {.bitsize: 1.}: cuint
    noFallback* {.bitsize: 1.}: cuint
    pgBgRgba*: gdk3.RGBA
    letterSpacing*: cint
    ano9630908558484842749*: INNER_C_UNION_9580594885298540608

  TextChildAnchor* =  ptr TextChildAnchorObj
  TextChildAnchorPtr* = ptr TextChildAnchorObj
  TextChildAnchorObj*{.final.} = object of GObjectObj
    segment*: Gpointer

  TextChildAnchorClass* =  ptr TextChildAnchorClassObj
  TextChildAnchorClassPtr* = ptr TextChildAnchorClassObj
  TextChildAnchorClassObj*{.final.} = object of GObjectClassObj
    gtkReserved201*: proc () {.cdecl.}
    gtkReserved202*: proc () {.cdecl.}
    gtkReserved203*: proc () {.cdecl.}
    gtkReserved204*: proc () {.cdecl.}

proc newTextAttributes*(): TextAttributes {.
    importc: "gtk_text_attributes_new", libgtk.}
proc copy*(src: TextAttributes): TextAttributes {.
    importc: "gtk_text_attributes_copy", libgtk.}
proc copyValues*(src: TextAttributes;
                                 dest: TextAttributes) {.
    importc: "gtk_text_attributes_copy_values", libgtk.}
proc unref*(values: TextAttributes) {.
    importc: "gtk_text_attributes_unref", libgtk.}
proc `ref`*(values: TextAttributes): TextAttributes {.
    importc: "gtk_text_attributes_ref", libgtk.}
proc textAttributesGetType*(): GType {.importc: "gtk_text_attributes_get_type",
                                       libgtk.}

template typeTextChildAnchor*(): expr =
  (textChildAnchorGetType())

template textChildAnchor*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeTextChildAnchor, TextChildAnchorObj))

template textChildAnchorClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTextChildAnchor, TextChildAnchorClassObj))

template isTextChildAnchor*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeTextChildAnchor))

template isTextChildAnchorClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTextChildAnchor))

template textChildAnchorGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTextChildAnchor, TextChildAnchorClassObj))

type
  TextTag* =  ptr TextTagObj
  TextTagPtr* = ptr TextTagObj
  TextTagObj* = object of GObjectObj
    priv30: pointer

  TextIter* =  ptr TextIterObj
  TextIterPtr* = ptr TextIterObj
  TextIterObj* = object
    dummy1: Gpointer
    dummy2: Gpointer
    dummy3: cint
    dummy4: cint
    dummy5: cint
    dummy6: cint
    dummy7: cint
    dummy8: cint
    dummy9: Gpointer
    dummy10: Gpointer
    dummy11: cint
    dummy12: cint
    dummy13: cint
    dummy14: Gpointer

  TextTagClass* =  ptr TextTagClassObj
  TextTagClassPtr* = ptr TextTagClassObj
  TextTagClassObj* = object of GObjectClassObj
    event*: proc (tag: TextTag; eventObject: GObject; event: gdk3.Event;
                iter: TextIter): Gboolean {.cdecl.}
    gtkReserved211*: proc () {.cdecl.}
    gtkReserved212*: proc () {.cdecl.}
    gtkReserved213*: proc () {.cdecl.}
    gtkReserved214*: proc () {.cdecl.}

proc textChildAnchorGetType*(): GType {.importc: "gtk_text_child_anchor_get_type",
                                        libgtk.}
proc newTextChildAnchor*(): TextChildAnchor {.
    importc: "gtk_text_child_anchor_new", libgtk.}
proc getWidgets*(anchor: TextChildAnchor): glib.GList {.
    importc: "gtk_text_child_anchor_get_widgets", libgtk.}
proc widgets*(anchor: TextChildAnchor): glib.GList {.
    importc: "gtk_text_child_anchor_get_widgets", libgtk.}
proc getDeleted*(anchor: TextChildAnchor): Gboolean {.
    importc: "gtk_text_child_anchor_get_deleted", libgtk.}
proc deleted*(anchor: TextChildAnchor): Gboolean {.
    importc: "gtk_text_child_anchor_get_deleted", libgtk.}

template typeTextTag*(): expr =
  (textTagGetType())

template textTag*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTextTag, TextTagObj))

template textTagClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTextTag, TextTagClassObj))

template isTextTag*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTextTag))

template isTextTagClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTextTag))

template textTagGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTextTag, TextTagClassObj))

proc textTagGetType*(): GType {.importc: "gtk_text_tag_get_type", libgtk.}
proc newTextTag*(name: cstring): TextTag {.importc: "gtk_text_tag_new",
    libgtk.}
proc getPriority*(tag: TextTag): cint {.
    importc: "gtk_text_tag_get_priority", libgtk.}
proc priority*(tag: TextTag): cint {.
    importc: "gtk_text_tag_get_priority", libgtk.}
proc setPriority*(tag: TextTag; priority: cint) {.
    importc: "gtk_text_tag_set_priority", libgtk.}
proc `priority=`*(tag: TextTag; priority: cint) {.
    importc: "gtk_text_tag_set_priority", libgtk.}
proc event*(tag: TextTag; eventObject: GObject;
                     event: gdk3.Event; iter: TextIter): Gboolean {.
    importc: "gtk_text_tag_event", libgtk.}
proc changed*(tag: TextTag; sizeChanged: Gboolean) {.
    importc: "gtk_text_tag_changed", libgtk.}

type
  TextSearchFlags* {.size: sizeof(cint), pure.} = enum
    VISIBLE_ONLY = 1 shl 0, TEXT_ONLY = 1 shl 1,
    CASE_INSENSITIVE = 1 shl 2

template typeTextIter*(): expr =
  (textIterGetType())

type
  TextBuffer* =  ptr TextBufferObj
  TextBufferPtr* = ptr TextBufferObj
  TextBufferObj* = object of GObjectObj
    priv31: pointer

proc getBuffer*(iter: TextIter): TextBuffer {.
    importc: "gtk_text_iter_get_buffer", libgtk.}

proc buffer*(iter: TextIter): TextBuffer {.
    importc: "gtk_text_iter_get_buffer", libgtk.}

proc copy*(iter: TextIter): TextIter {.
    importc: "gtk_text_iter_copy", libgtk.}
proc free*(iter: TextIter) {.importc: "gtk_text_iter_free",
    libgtk.}
proc assign*(iter: TextIter; other: TextIter) {.
    importc: "gtk_text_iter_assign", libgtk.}
proc textIterGetType*(): GType {.importc: "gtk_text_iter_get_type", libgtk.}

proc getOffset*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_offset", libgtk.}

proc offset*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_offset", libgtk.}
proc getLine*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_line", libgtk.}
proc line*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_line", libgtk.}
proc getLineOffset*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_line_offset", libgtk.}
proc lineOffset*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_line_offset", libgtk.}
proc getLineIndex*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_line_index", libgtk.}
proc lineIndex*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_line_index", libgtk.}
proc getVisibleLineOffset*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_visible_line_offset", libgtk.}
proc visibleLineOffset*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_visible_line_offset", libgtk.}
proc getVisibleLineIndex*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_visible_line_index", libgtk.}
proc visibleLineIndex*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_visible_line_index", libgtk.}

proc getChar*(iter: TextIter): Gunichar {.
    importc: "gtk_text_iter_get_char", libgtk.}

proc char*(iter: TextIter): Gunichar {.
    importc: "gtk_text_iter_get_char", libgtk.}

proc getSlice*(start: TextIter; `end`: TextIter): cstring {.
    importc: "gtk_text_iter_get_slice", libgtk.}

proc slice*(start: TextIter; `end`: TextIter): cstring {.
    importc: "gtk_text_iter_get_slice", libgtk.}

proc getText*(start: TextIter; `end`: TextIter): cstring {.
    importc: "gtk_text_iter_get_text", libgtk.}

proc text*(start: TextIter; `end`: TextIter): cstring {.
    importc: "gtk_text_iter_get_text", libgtk.}

proc getVisibleSlice*(start: TextIter; `end`: TextIter): cstring {.
    importc: "gtk_text_iter_get_visible_slice", libgtk.}

proc visibleSlice*(start: TextIter; `end`: TextIter): cstring {.
    importc: "gtk_text_iter_get_visible_slice", libgtk.}
proc getVisibleText*(start: TextIter; `end`: TextIter): cstring {.
    importc: "gtk_text_iter_get_visible_text", libgtk.}
proc visibleText*(start: TextIter; `end`: TextIter): cstring {.
    importc: "gtk_text_iter_get_visible_text", libgtk.}
proc getPixbuf*(iter: TextIter): GdkPixbuf {.
    importc: "gtk_text_iter_get_pixbuf", libgtk.}
proc pixbuf*(iter: TextIter): GdkPixbuf {.
    importc: "gtk_text_iter_get_pixbuf", libgtk.}
proc getMarks*(iter: TextIter): glib.GSList {.
    importc: "gtk_text_iter_get_marks", libgtk.}
proc marks*(iter: TextIter): glib.GSList {.
    importc: "gtk_text_iter_get_marks", libgtk.}
proc getChildAnchor*(iter: TextIter): TextChildAnchor {.
    importc: "gtk_text_iter_get_child_anchor", libgtk.}
proc childAnchor*(iter: TextIter): TextChildAnchor {.
    importc: "gtk_text_iter_get_child_anchor", libgtk.}

proc getToggledTags*(iter: TextIter; toggledOn: Gboolean): glib.GSList {.
    importc: "gtk_text_iter_get_toggled_tags", libgtk.}

proc toggledTags*(iter: TextIter; toggledOn: Gboolean): glib.GSList {.
    importc: "gtk_text_iter_get_toggled_tags", libgtk.}
proc startsTag*(iter: TextIter; tag: TextTag): Gboolean {.
    importc: "gtk_text_iter_starts_tag", libgtk.}
proc beginsTag*(iter: TextIter; tag: TextTag): Gboolean {.
    importc: "gtk_text_iter_begins_tag", libgtk.}
proc endsTag*(iter: TextIter; tag: TextTag): Gboolean {.
    importc: "gtk_text_iter_ends_tag", libgtk.}
proc togglesTag*(iter: TextIter; tag: TextTag): Gboolean {.
    importc: "gtk_text_iter_toggles_tag", libgtk.}
proc hasTag*(iter: TextIter; tag: TextTag): Gboolean {.
    importc: "gtk_text_iter_has_tag", libgtk.}
proc getTags*(iter: TextIter): glib.GSList {.
    importc: "gtk_text_iter_get_tags", libgtk.}
proc tags*(iter: TextIter): glib.GSList {.
    importc: "gtk_text_iter_get_tags", libgtk.}
proc editable*(iter: TextIter; defaultSetting: Gboolean): Gboolean {.
    importc: "gtk_text_iter_editable", libgtk.}
proc canInsert*(iter: TextIter; defaultEditability: Gboolean): Gboolean {.
    importc: "gtk_text_iter_can_insert", libgtk.}
proc startsWord*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_starts_word", libgtk.}
proc endsWord*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_ends_word", libgtk.}
proc insideWord*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_inside_word", libgtk.}
proc startsSentence*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_starts_sentence", libgtk.}
proc endsSentence*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_ends_sentence", libgtk.}
proc insideSentence*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_inside_sentence", libgtk.}
proc startsLine*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_starts_line", libgtk.}
proc endsLine*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_ends_line", libgtk.}
proc isCursorPosition*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_is_cursor_position", libgtk.}
proc getCharsInLine*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_chars_in_line", libgtk.}
proc charsInLine*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_chars_in_line", libgtk.}
proc getBytesInLine*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_bytes_in_line", libgtk.}
proc bytesInLine*(iter: TextIter): cint {.
    importc: "gtk_text_iter_get_bytes_in_line", libgtk.}
proc getAttributes*(iter: TextIter; values: TextAttributes): Gboolean {.
    importc: "gtk_text_iter_get_attributes", libgtk.}
proc attributes*(iter: TextIter; values: TextAttributes): Gboolean {.
    importc: "gtk_text_iter_get_attributes", libgtk.}
proc getLanguage*(iter: TextIter): pango.Language {.
    importc: "gtk_text_iter_get_language", libgtk.}
proc language*(iter: TextIter): pango.Language {.
    importc: "gtk_text_iter_get_language", libgtk.}
proc isEnd*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_is_end", libgtk.}
proc isStart*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_is_start", libgtk.}

proc forwardChar*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_char", libgtk.}
proc backwardChar*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_char", libgtk.}
proc forwardChars*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_forward_chars", libgtk.}
proc backwardChars*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_backward_chars", libgtk.}
proc forwardLine*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_line", libgtk.}
proc backwardLine*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_line", libgtk.}
proc forwardLines*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_forward_lines", libgtk.}
proc backwardLines*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_backward_lines", libgtk.}
proc forwardWordEnd*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_word_end", libgtk.}
proc backwardWordStart*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_word_start", libgtk.}
proc forwardWordEnds*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_forward_word_ends", libgtk.}
proc backwardWordStarts*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_backward_word_starts", libgtk.}
proc forwardVisibleLine*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_visible_line", libgtk.}
proc backwardVisibleLine*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_visible_line", libgtk.}
proc forwardVisibleLines*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_forward_visible_lines", libgtk.}
proc backwardVisibleLines*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_backward_visible_lines", libgtk.}
proc forwardVisibleWordEnd*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_visible_word_end", libgtk.}
proc backwardVisibleWordStart*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_visible_word_start", libgtk.}
proc forwardVisibleWordEnds*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_forward_visible_word_ends", libgtk.}
proc backwardVisibleWordStarts*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_backward_visible_word_starts", libgtk.}
proc forwardSentenceEnd*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_sentence_end", libgtk.}
proc backwardSentenceStart*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_sentence_start", libgtk.}
proc forwardSentenceEnds*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_forward_sentence_ends", libgtk.}
proc backwardSentenceStarts*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_backward_sentence_starts", libgtk.}

proc forwardCursorPosition*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_cursor_position", libgtk.}
proc backwardCursorPosition*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_cursor_position", libgtk.}
proc forwardCursorPositions*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_forward_cursor_positions", libgtk.}
proc backwardCursorPositions*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_backward_cursor_positions", libgtk.}
proc forwardVisibleCursorPosition*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_visible_cursor_position", libgtk.}
proc backwardVisibleCursorPosition*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_visible_cursor_position", libgtk.}
proc forwardVisibleCursorPositions*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_forward_visible_cursor_positions", libgtk.}
proc backwardVisibleCursorPositions*(iter: TextIter; count: cint): Gboolean {.
    importc: "gtk_text_iter_backward_visible_cursor_positions", libgtk.}
proc setOffset*(iter: TextIter; charOffset: cint) {.
    importc: "gtk_text_iter_set_offset", libgtk.}
proc `offset=`*(iter: TextIter; charOffset: cint) {.
    importc: "gtk_text_iter_set_offset", libgtk.}
proc setLine*(iter: TextIter; lineNumber: cint) {.
    importc: "gtk_text_iter_set_line", libgtk.}
proc `line=`*(iter: TextIter; lineNumber: cint) {.
    importc: "gtk_text_iter_set_line", libgtk.}
proc setLineOffset*(iter: TextIter; charOnLine: cint) {.
    importc: "gtk_text_iter_set_line_offset", libgtk.}
proc `lineOffset=`*(iter: TextIter; charOnLine: cint) {.
    importc: "gtk_text_iter_set_line_offset", libgtk.}
proc setLineIndex*(iter: TextIter; byteOnLine: cint) {.
    importc: "gtk_text_iter_set_line_index", libgtk.}
proc `lineIndex=`*(iter: TextIter; byteOnLine: cint) {.
    importc: "gtk_text_iter_set_line_index", libgtk.}
proc forwardToEnd*(iter: TextIter) {.
    importc: "gtk_text_iter_forward_to_end", libgtk.}
proc forwardToLineEnd*(iter: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_to_line_end", libgtk.}
proc setVisibleLineOffset*(iter: TextIter; charOnLine: cint) {.
    importc: "gtk_text_iter_set_visible_line_offset", libgtk.}
proc `visibleLineOffset=`*(iter: TextIter; charOnLine: cint) {.
    importc: "gtk_text_iter_set_visible_line_offset", libgtk.}
proc setVisibleLineIndex*(iter: TextIter; byteOnLine: cint) {.
    importc: "gtk_text_iter_set_visible_line_index", libgtk.}
proc `visibleLineIndex=`*(iter: TextIter; byteOnLine: cint) {.
    importc: "gtk_text_iter_set_visible_line_index", libgtk.}

proc forwardToTagToggle*(iter: TextIter; tag: TextTag): Gboolean {.
    importc: "gtk_text_iter_forward_to_tag_toggle", libgtk.}
proc backwardToTagToggle*(iter: TextIter; tag: TextTag): Gboolean {.
    importc: "gtk_text_iter_backward_to_tag_toggle", libgtk.}
type
  TextCharPredicate* = proc (ch: Gunichar; userData: Gpointer): Gboolean {.cdecl.}

proc forwardFindChar*(iter: TextIter; pred: TextCharPredicate;
                                userData: Gpointer; limit: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_find_char", libgtk.}
proc backwardFindChar*(iter: TextIter; pred: TextCharPredicate;
                                 userData: Gpointer; limit: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_find_char", libgtk.}
proc forwardSearch*(iter: TextIter; str: cstring;
                              flags: TextSearchFlags;
                              matchStart: TextIter;
                              matchEnd: TextIter; limit: TextIter): Gboolean {.
    importc: "gtk_text_iter_forward_search", libgtk.}
proc backwardSearch*(iter: TextIter; str: cstring;
                               flags: TextSearchFlags;
                               matchStart: TextIter;
                               matchEnd: TextIter; limit: TextIter): Gboolean {.
    importc: "gtk_text_iter_backward_search", libgtk.}

proc equal*(lhs: TextIter; rhs: TextIter): Gboolean {.
    importc: "gtk_text_iter_equal", libgtk.}
proc compare*(lhs: TextIter; rhs: TextIter): cint {.
    importc: "gtk_text_iter_compare", libgtk.}
proc inRange*(iter: TextIter; start: TextIter;
                        `end`: TextIter): Gboolean {.
    importc: "gtk_text_iter_in_range", libgtk.}

proc order*(first: TextIter; second: TextIter) {.
    importc: "gtk_text_iter_order", libgtk.}

type
  TargetPair* =  ptr TargetPairObj
  TargetPairPtr* = ptr TargetPairObj
  TargetPairObj* = object
    target*: gdk3.Atom
    flags*: cuint
    info*: cuint

type
  TargetList* =  ptr TargetListObj
  TargetListPtr* = ptr TargetListObj
  TargetListObj* = object

template typeSelectionData*(): expr =
  (selectionDataGetType())

template typeTargetList*(): expr =
  (targetListGetType())

type
  TargetEntry* =  ptr TargetEntryObj
  TargetEntryPtr* = ptr TargetEntryObj
  TargetEntryObj* = object
    target*: cstring
    flags*: cuint
    info*: cuint

proc targetListGetType*(): GType {.importc: "gtk_target_list_get_type",
                                   libgtk.}
proc newTargetList*(targets: TargetEntry; ntargets: cuint): TargetList {.
    importc: "gtk_target_list_new", libgtk.}
proc `ref`*(list: TargetList): TargetList {.
    importc: "gtk_target_list_ref", libgtk.}
proc unref*(list: TargetList) {.
    importc: "gtk_target_list_unref", libgtk.}
proc add*(list: TargetList; target: gdk3.Atom; flags: cuint;
                      info: cuint) {.importc: "gtk_target_list_add", libgtk.}
proc addTextTargets*(list: TargetList; info: cuint) {.
    importc: "gtk_target_list_add_text_targets", libgtk.}
proc addRichTextTargets*(list: TargetList; info: cuint;
                                     deserializable: Gboolean;
                                     buffer: TextBuffer) {.
    importc: "gtk_target_list_add_rich_text_targets", libgtk.}
proc addImageTargets*(list: TargetList; info: cuint;
                                  writable: Gboolean) {.
    importc: "gtk_target_list_add_image_targets", libgtk.}
proc addUriTargets*(list: TargetList; info: cuint) {.
    importc: "gtk_target_list_add_uri_targets", libgtk.}
proc addTable*(list: TargetList; targets: TargetEntry;
                           ntargets: cuint) {.
    importc: "gtk_target_list_add_table", libgtk.}
proc remove*(list: TargetList; target: gdk3.Atom) {.
    importc: "gtk_target_list_remove", libgtk.}
proc find*(list: TargetList; target: gdk3.Atom; info: var cuint): Gboolean {.
    importc: "gtk_target_list_find", libgtk.}
proc newTargetTable*(list: TargetList; nTargets: var cint): TargetEntry {.
    importc: "gtk_target_table_new_from_list", libgtk.}
proc targetTableFree*(targets: TargetEntry; nTargets: cint) {.
    importc: "gtk_target_table_free", libgtk.}
proc selectionOwnerSet*(widget: Widget; selection: gdk3.Atom; time: uint32): Gboolean {.
    importc: "gtk_selection_owner_set", libgtk.}
proc selectionOwnerSetForDisplay*(display: gdk3.Display; widget: Widget;
                                    selection: gdk3.Atom; time: uint32): Gboolean {.
    importc: "gtk_selection_owner_set_for_display", libgtk.}
proc selectionAddTarget*(widget: Widget; selection: gdk3.Atom;
                           target: gdk3.Atom; info: cuint) {.
    importc: "gtk_selection_add_target", libgtk.}
proc selectionAddTargets*(widget: Widget; selection: gdk3.Atom;
                            targets: TargetEntry; ntargets: cuint) {.
    importc: "gtk_selection_add_targets", libgtk.}
proc selectionClearTargets*(widget: Widget; selection: gdk3.Atom) {.
    importc: "gtk_selection_clear_targets", libgtk.}
proc selectionConvert*(widget: Widget; selection: gdk3.Atom; target: gdk3.Atom;
                         time: uint32): Gboolean {.
    importc: "gtk_selection_convert", libgtk.}
proc selectionRemoveAll*(widget: Widget) {.
    importc: "gtk_selection_remove_all", libgtk.}
proc getSelection*(selectionData: SelectionData): gdk3.Atom {.
    importc: "gtk_selection_data_get_selection", libgtk.}
proc selection*(selectionData: SelectionData): gdk3.Atom {.
    importc: "gtk_selection_data_get_selection", libgtk.}
proc getTarget*(selectionData: SelectionData): gdk3.Atom {.
    importc: "gtk_selection_data_get_target", libgtk.}
proc target*(selectionData: SelectionData): gdk3.Atom {.
    importc: "gtk_selection_data_get_target", libgtk.}
proc getDataType*(selectionData: SelectionData): gdk3.Atom {.
    importc: "gtk_selection_data_get_data_type", libgtk.}
proc dataType*(selectionData: SelectionData): gdk3.Atom {.
    importc: "gtk_selection_data_get_data_type", libgtk.}
proc getFormat*(selectionData: SelectionData): cint {.
    importc: "gtk_selection_data_get_format", libgtk.}
proc format*(selectionData: SelectionData): cint {.
    importc: "gtk_selection_data_get_format", libgtk.}
proc getData*(selectionData: SelectionData): ptr cuchar {.
    importc: "gtk_selection_data_get_data", libgtk.}
proc data*(selectionData: SelectionData): ptr cuchar {.
    importc: "gtk_selection_data_get_data", libgtk.}
proc getLength*(selectionData: SelectionData): cint {.
    importc: "gtk_selection_data_get_length", libgtk.}
proc length*(selectionData: SelectionData): cint {.
    importc: "gtk_selection_data_get_length", libgtk.}
proc getDataWithLength*(selectionData: SelectionData;
                                       length: var cint): ptr cuchar {.
    importc: "gtk_selection_data_get_data_with_length", libgtk.}
proc dataWithLength*(selectionData: SelectionData;
                                       length: var cint): ptr cuchar {.
    importc: "gtk_selection_data_get_data_with_length", libgtk.}
proc getDisplay*(selectionData: SelectionData): gdk3.Display {.
    importc: "gtk_selection_data_get_display", libgtk.}
proc display*(selectionData: SelectionData): gdk3.Display {.
    importc: "gtk_selection_data_get_display", libgtk.}
proc set*(selectionData: SelectionData; `type`: gdk3.Atom;
                         format: cint; data: var cuchar; length: cint) {.
    importc: "gtk_selection_data_set", libgtk.}
proc setText*(selectionData: SelectionData; str: cstring;
                             len: cint): Gboolean {.
    importc: "gtk_selection_data_set_text", libgtk.}
proc getText*(selectionData: SelectionData): ptr cuchar {.
    importc: "gtk_selection_data_get_text", libgtk.}
proc text*(selectionData: SelectionData): ptr cuchar {.
    importc: "gtk_selection_data_get_text", libgtk.}
proc setPixbuf*(selectionData: SelectionData;
                               pixbuf: GdkPixbuf): Gboolean {.
    importc: "gtk_selection_data_set_pixbuf", libgtk.}
proc getPixbuf*(selectionData: SelectionData): GdkPixbuf {.
    importc: "gtk_selection_data_get_pixbuf", libgtk.}
proc pixbuf*(selectionData: SelectionData): GdkPixbuf {.
    importc: "gtk_selection_data_get_pixbuf", libgtk.}
proc setUris*(selectionData: SelectionData;
                             uris: cstringArray): Gboolean {.
    importc: "gtk_selection_data_set_uris", libgtk.}
proc getUris*(selectionData: SelectionData): cstringArray {.
    importc: "gtk_selection_data_get_uris", libgtk.}
proc uris*(selectionData: SelectionData): cstringArray {.
    importc: "gtk_selection_data_get_uris", libgtk.}
proc getTargets*(selectionData: SelectionData;
                                targets: ptr ptr gdk3.Atom; nAtoms: var cint): Gboolean {.
    importc: "gtk_selection_data_get_targets", libgtk.}
proc targets*(selectionData: SelectionData;
                                targets: ptr ptr gdk3.Atom; nAtoms: var cint): Gboolean {.
    importc: "gtk_selection_data_get_targets", libgtk.}
proc targetsIncludeText*(selectionData: SelectionData): Gboolean {.
    importc: "gtk_selection_data_targets_include_text", libgtk.}
proc targetsIncludeRichText*(selectionData: SelectionData;
    buffer: TextBuffer): Gboolean {.importc: "gtk_selection_data_targets_include_rich_text",
                                       libgtk.}
proc targetsIncludeImage*(selectionData: SelectionData;
    writable: Gboolean): Gboolean {.importc: "gtk_selection_data_targets_include_image",
                                 libgtk.}
proc targetsIncludeUri*(selectionData: SelectionData): Gboolean {.
    importc: "gtk_selection_data_targets_include_uri", libgtk.}
proc targetsIncludeText*(targets: ptr gdk3.Atom; nTargets: cint): Gboolean {.
    importc: "gtk_targets_include_text", libgtk.}
proc targetsIncludeRichText*(targets: ptr gdk3.Atom; nTargets: cint;
                               buffer: TextBuffer): Gboolean {.
    importc: "gtk_targets_include_rich_text", libgtk.}
proc targetsIncludeImage*(targets: ptr gdk3.Atom; nTargets: cint; writable: Gboolean): Gboolean {.
    importc: "gtk_targets_include_image", libgtk.}
proc targetsIncludeUri*(targets: ptr gdk3.Atom; nTargets: cint): Gboolean {.
    importc: "gtk_targets_include_uri", libgtk.}
proc selectionDataGetType*(): GType {.importc: "gtk_selection_data_get_type",
                                      libgtk.}
proc copy*(data: SelectionData): SelectionData {.
    importc: "gtk_selection_data_copy", libgtk.}
proc free*(data: SelectionData) {.
    importc: "gtk_selection_data_free", libgtk.}
proc targetEntryGetType*(): GType {.importc: "gtk_target_entry_get_type",
                                    libgtk.}
proc newTargetEntry*(target: cstring; flags: cuint; info: cuint): TargetEntry {.
    importc: "gtk_target_entry_new", libgtk.}
proc copy*(data: TargetEntry): TargetEntry {.
    importc: "gtk_target_entry_copy", libgtk.}
proc free*(data: TargetEntry) {.
    importc: "gtk_target_entry_free", libgtk.}

type
  DestDefaults* {.size: sizeof(cint), pure.} = enum
    MOTION = 1 shl 0, HIGHLIGHT = 1 shl 1,
    DROP = 1 shl 2, ALL = 0x7

type
  TargetFlags* {.size: sizeof(cint), pure.} = enum
    SAME_APP = 1 shl 0, SAME_WIDGET = 1 shl 1,
    OTHER_APP = 1 shl 2, OTHER_WIDGET = 1 shl 3
  Editable* =  ptr EditableObj
  EditablePtr* = ptr EditableObj
  EditableObj* = object

type
  EditableInterface* =  ptr EditableInterfaceObj
  EditableInterfacePtr* = ptr EditableInterfaceObj
  EditableInterfaceObj* = object of gobject.GTypeInterfaceObj
    insertText*: proc (editable: Editable; newText: cstring;
                     newTextLength: cint; position: var cint) {.cdecl.}
    deleteText*: proc (editable: Editable; startPos: cint; endPos: cint) {.cdecl.}
    changed*: proc (editable: Editable) {.cdecl.}
    doInsertText*: proc (editable: Editable; newText: cstring;
                       newTextLength: cint; position: var cint) {.cdecl.}
    doDeleteText*: proc (editable: Editable; startPos: cint; endPos: cint) {.cdecl.}
    getChars*: proc (editable: Editable; startPos: cint; endPos: cint): cstring {.cdecl.}
    setSelectionBounds*: proc (editable: Editable; startPos: cint; endPos: cint) {.cdecl.}
    getSelectionBounds*: proc (editable: Editable; startPos: var cint;
                             endPos: var cint): Gboolean {.cdecl.}
    setPosition*: proc (editable: Editable; position: cint) {.cdecl.}
    getPosition*: proc (editable: Editable): cint {.cdecl.}

proc dragGetData*(widget: Widget; context: gdk3.DragContext;
                    target: gdk3.Atom; time: uint32) {.importc: "gtk_drag_get_data",
    libgtk.}
proc dragFinish*(context: gdk3.DragContext; success: Gboolean; del: Gboolean;
                   time: uint32) {.importc: "gtk_drag_finish", libgtk.}
proc dragGetSourceWidget*(context: gdk3.DragContext): Widget {.
    importc: "gtk_drag_get_source_widget", libgtk.}
proc dragHighlight*(widget: Widget) {.importc: "gtk_drag_highlight",
    libgtk.}
proc dragUnhighlight*(widget: Widget) {.importc: "gtk_drag_unhighlight",
    libgtk.}
proc dragDestSet*(widget: Widget; flags: DestDefaults;
                    targets: TargetEntry; nTargets: cint;
                    actions: gdk3.DragAction) {.importc: "gtk_drag_dest_set",
    libgtk.}
proc dragDestSetProxy*(widget: Widget; proxyWindow: gdk3.Window;
                         protocol: gdk3.DragProtocol; useCoordinates: Gboolean) {.
    importc: "gtk_drag_dest_set_proxy", libgtk.}
proc dragDestUnset*(widget: Widget) {.importc: "gtk_drag_dest_unset",
    libgtk.}
proc dragDestFindTarget*(widget: Widget; context: gdk3.DragContext;
                           targetList: TargetList): gdk3.Atom {.
    importc: "gtk_drag_dest_find_target", libgtk.}
proc dragDestGetTargetList*(widget: Widget): TargetList {.
    importc: "gtk_drag_dest_get_target_list", libgtk.}
proc dragDestSetTargetList*(widget: Widget; targetList: TargetList) {.
    importc: "gtk_drag_dest_set_target_list", libgtk.}
proc dragDestAddTextTargets*(widget: Widget) {.
    importc: "gtk_drag_dest_add_text_targets", libgtk.}
proc dragDestAddImageTargets*(widget: Widget) {.
    importc: "gtk_drag_dest_add_image_targets", libgtk.}
proc dragDestAddUriTargets*(widget: Widget) {.
    importc: "gtk_drag_dest_add_uri_targets", libgtk.}
proc dragDestSetTrackMotion*(widget: Widget; trackMotion: Gboolean) {.
    importc: "gtk_drag_dest_set_track_motion", libgtk.}
proc dragDestGetTrackMotion*(widget: Widget): Gboolean {.
    importc: "gtk_drag_dest_get_track_motion", libgtk.}

proc dragBeginWithCoordinates*(widget: Widget; targets: TargetList;
                                 actions: gdk3.DragAction; button: cint;
                                 event: gdk3.Event; x: cint; y: cint): gdk3.DragContext {.
    importc: "gtk_drag_begin_with_coordinates", libgtk.}
proc dragBegin*(widget: Widget; targets: TargetList;
                  actions: gdk3.DragAction; button: cint; event: gdk3.Event): gdk3.DragContext {.
    importc: "gtk_drag_begin", libgtk.}
proc dragCancel*(context: gdk3.DragContext) {.importc: "gtk_drag_cancel",
    libgtk.}
proc dragSetIconWidget*(context: gdk3.DragContext; widget: Widget;
                          hotX: cint; hotY: cint) {.
    importc: "gtk_drag_set_icon_widget", libgtk.}
proc dragSetIconPixbuf*(context: gdk3.DragContext; pixbuf: GdkPixbuf;
                          hotX: cint; hotY: cint) {.
    importc: "gtk_drag_set_icon_pixbuf", libgtk.}
proc dragSetIconStock*(context: gdk3.DragContext; stockId: cstring; hotX: cint;
                         hotY: cint) {.importc: "gtk_drag_set_icon_stock",
                                     libgtk.}
proc dragSetIconSurface*(context: gdk3.DragContext; surface: cairo.Surface) {.
    importc: "gtk_drag_set_icon_surface", libgtk.}
proc dragSetIconName*(context: gdk3.DragContext; iconName: cstring; hotX: cint;
                        hotY: cint) {.importc: "gtk_drag_set_icon_name", libgtk.}
proc dragSetIconGicon*(context: gdk3.DragContext; icon: gio.GIcon; hotX: cint;
                         hotY: cint) {.importc: "gtk_drag_set_icon_gicon",
                                     libgtk.}
proc dragSetIconDefault*(context: gdk3.DragContext) {.
    importc: "gtk_drag_set_icon_default", libgtk.}
proc dragCheckThreshold*(widget: Widget; startX: cint; startY: cint;
                           currentX: cint; currentY: cint): Gboolean {.
    importc: "gtk_drag_check_threshold", libgtk.}

template typeEditable*(): expr =
  (editableGetType())

template editable*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeEditable, EditableObj))

template isEditable*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeEditable))

template editableGetIface*(inst: expr): expr =
  (gTypeInstanceGetInterface(inst, typeEditable, EditableInterfaceObj))

type
  IMContext* =  ptr IMContextObj
  IMContextPtr* = ptr IMContextObj
  IMContextObj = object of GObjectObj

  IMContextClass* =  ptr IMContextClassObj
  IMContextClassPtr* = ptr IMContextClassObj
  IMContextClassObj = object of GObjectClassObj
    preeditStart*: proc (context: IMContext) {.cdecl.}
    preeditEnd*: proc (context: IMContext) {.cdecl.}
    preeditChanged*: proc (context: IMContext) {.cdecl.}
    commit*: proc (context: IMContext; str: cstring) {.cdecl.}
    retrieveSurrounding*: proc (context: IMContext): Gboolean {.cdecl.}
    deleteSurrounding*: proc (context: IMContext; offset: cint; nChars: cint): Gboolean {.cdecl.}
    setClientWindow*: proc (context: IMContext; window: gdk3.Window) {.cdecl.}
    getPreeditString*: proc (context: IMContext; str: cstringArray;
                           attrs: var pango.AttrList; cursorPos: var cint) {.cdecl.}
    filterKeypress*: proc (context: IMContext; event: gdk3.EventKey): Gboolean {.cdecl.}
    focusIn*: proc (context: IMContext) {.cdecl.}
    focusOut*: proc (context: IMContext) {.cdecl.}
    reset*: proc (context: IMContext) {.cdecl.}
    setCursorLocation*: proc (context: IMContext; area: gdk3.Rectangle) {.cdecl.}
    setUsePreedit*: proc (context: IMContext; usePreedit: Gboolean) {.cdecl.}
    setSurrounding*: proc (context: IMContext; text: cstring; len: cint;
                         cursorIndex: cint) {.cdecl.}
    getSurrounding*: proc (context: IMContext; text: cstringArray;
                         cursorIndex: var cint): Gboolean {.cdecl.}
    gtkReserved221*: proc () {.cdecl.}
    gtkReserved222*: proc () {.cdecl.}
    gtkReserved223*: proc () {.cdecl.}
    gtkReserved224*: proc () {.cdecl.}
    gtkReserved225*: proc () {.cdecl.}
    gtkReserved226*: proc () {.cdecl.}

proc editableGetType*(): GType {.importc: "gtk_editable_get_type", libgtk.}
proc selectRegion*(editable: Editable; startPos: cint; endPos: cint) {.
    importc: "gtk_editable_select_region", libgtk.}
proc getSelectionBounds*(editable: Editable; startPos: var cint;
                                   endPos: var cint): Gboolean {.
    importc: "gtk_editable_get_selection_bounds", libgtk.}
proc selectionBounds*(editable: Editable; startPos: var cint;
                                   endPos: var cint): Gboolean {.
    importc: "gtk_editable_get_selection_bounds", libgtk.}
proc insertText*(editable: Editable; newText: cstring;
                           newTextLength: cint; position: var cint) {.
    importc: "gtk_editable_insert_text", libgtk.}
proc deleteText*(editable: Editable; startPos: cint; endPos: cint) {.
    importc: "gtk_editable_delete_text", libgtk.}
proc getChars*(editable: Editable; startPos: cint; endPos: cint): cstring {.
    importc: "gtk_editable_get_chars", libgtk.}
proc chars*(editable: Editable; startPos: cint; endPos: cint): cstring {.
    importc: "gtk_editable_get_chars", libgtk.}
proc cutClipboard*(editable: Editable) {.
    importc: "gtk_editable_cut_clipboard", libgtk.}
proc copyClipboard*(editable: Editable) {.
    importc: "gtk_editable_copy_clipboard", libgtk.}
proc pasteClipboard*(editable: Editable) {.
    importc: "gtk_editable_paste_clipboard", libgtk.}
proc deleteSelection*(editable: Editable) {.
    importc: "gtk_editable_delete_selection", libgtk.}
proc setPosition*(editable: Editable; position: cint) {.
    importc: "gtk_editable_set_position", libgtk.}
proc `position=`*(editable: Editable; position: cint) {.
    importc: "gtk_editable_set_position", libgtk.}
proc getPosition*(editable: Editable): cint {.
    importc: "gtk_editable_get_position", libgtk.}
proc position*(editable: Editable): cint {.
    importc: "gtk_editable_get_position", libgtk.}
proc setEditable*(editable: Editable; isEditable: Gboolean) {.
    importc: "gtk_editable_set_editable", libgtk.}
proc `editable=`*(editable: Editable; isEditable: Gboolean) {.
    importc: "gtk_editable_set_editable", libgtk.}
proc getEditable*(editable: Editable): Gboolean {.
    importc: "gtk_editable_get_editable", libgtk.}
proc editable*(editable: Editable): Gboolean {.
    importc: "gtk_editable_get_editable", libgtk.}

template typeImContext*(): expr =
  (imContextGetType())

template imContext*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeImContext, IMContextObj))

template imContextClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeImContext, IMContextClassObj))

template isImContext*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeImContext))

template isImContextClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeImContext))

template imContextGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeImContext, IMContextClassObj))

type
  EntryBuffer* =  ptr EntryBufferObj
  EntryBufferPtr* = ptr EntryBufferObj
  EntryBufferObj*{.final.} = object of GObjectObj
    priv32: pointer

  EntryBufferClass* =  ptr EntryBufferClassObj
  EntryBufferClassPtr* = ptr EntryBufferClassObj
  EntryBufferClassObj*{.final.} = object of GObjectClassObj
    insertedText*: proc (buffer: EntryBuffer; position: cuint; chars: cstring;
                       nChars: cuint) {.cdecl.}
    deletedText*: proc (buffer: EntryBuffer; position: cuint; nChars: cuint) {.cdecl.}
    getText*: proc (buffer: EntryBuffer; nBytes: ptr Gsize): cstring {.cdecl.}
    getLength*: proc (buffer: EntryBuffer): cuint {.cdecl.}
    insertText*: proc (buffer: EntryBuffer; position: cuint; chars: cstring;
                     nChars: cuint): cuint {.cdecl.}
    deleteText*: proc (buffer: EntryBuffer; position: cuint; nChars: cuint): cuint {.cdecl.}
    gtkReserved231*: proc () {.cdecl.}
    gtkReserved232*: proc () {.cdecl.}
    gtkReserved233*: proc () {.cdecl.}
    gtkReserved234*: proc () {.cdecl.}
    gtkReserved235*: proc () {.cdecl.}
    gtkReserved236*: proc () {.cdecl.}
    gtkReserved237*: proc () {.cdecl.}
    gtkReserved238*: proc () {.cdecl.}

proc imContextGetType*(): GType {.importc: "gtk_im_context_get_type", libgtk.}
proc imContextSetClientWindow*(context: IMContext; window: gdk3.Window) {.
    importc: "gtk_im_context_set_client_window", libgtk.}
proc imContextGetPreeditString*(context: IMContext; str: cstringArray;
                                  attrs: var pango.AttrList; cursorPos: var cint) {.
    importc: "gtk_im_context_get_preedit_string", libgtk.}
proc imContextFilterKeypress*(context: IMContext; event: gdk3.EventKey): Gboolean {.
    importc: "gtk_im_context_filter_keypress", libgtk.}
proc imContextFocusIn*(context: IMContext) {.
    importc: "gtk_im_context_focus_in", libgtk.}
proc imContextFocusOut*(context: IMContext) {.
    importc: "gtk_im_context_focus_out", libgtk.}
proc imContextReset*(context: IMContext) {.
    importc: "gtk_im_context_reset", libgtk.}
proc imContextSetCursorLocation*(context: IMContext;
                                   area: gdk3.Rectangle) {.
    importc: "gtk_im_context_set_cursor_location", libgtk.}
proc imContextSetUsePreedit*(context: IMContext; usePreedit: Gboolean) {.
    importc: "gtk_im_context_set_use_preedit", libgtk.}
proc imContextSetSurrounding*(context: IMContext; text: cstring; len: cint;
                                cursorIndex: cint) {.
    importc: "gtk_im_context_set_surrounding", libgtk.}
proc imContextGetSurrounding*(context: IMContext; text: cstringArray;
                                cursorIndex: var cint): Gboolean {.
    importc: "gtk_im_context_get_surrounding", libgtk.}
proc imContextDeleteSurrounding*(context: IMContext; offset: cint;
                                   nChars: cint): Gboolean {.
    importc: "gtk_im_context_delete_surrounding", libgtk.}

const
  ENTRY_BUFFER_MAX_SIZE* = G_MAXUSHORT

template typeEntryBuffer*(): expr =
  (entryBufferGetType())

template entryBuffer*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeEntryBuffer, EntryBufferObj))

template entryBufferClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeEntryBuffer, EntryBufferClassObj))

template isEntryBuffer*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeEntryBuffer))

template isEntryBufferClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeEntryBuffer))

template entryBufferGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeEntryBuffer, EntryBufferClassObj))

type
  ListStore* =  ptr ListStoreObj
  ListStorePtr* = ptr ListStoreObj
  ListStoreObj*{.final.} = object of GObjectObj
    priv33: pointer

  ListStoreClass* =  ptr ListStoreClassObj
  ListStoreClassPtr* = ptr ListStoreClassObj
  ListStoreClassObj*{.final.} = object of GObjectClassObj
    gtkReserved241*: proc () {.cdecl.}
    gtkReserved242*: proc () {.cdecl.}
    gtkReserved243*: proc () {.cdecl.}
    gtkReserved244*: proc () {.cdecl.}

proc entryBufferGetType*(): GType {.importc: "gtk_entry_buffer_get_type",
                                    libgtk.}
proc newEntryBuffer*(initialChars: cstring; nInitialChars: cint): EntryBuffer {.
    importc: "gtk_entry_buffer_new", libgtk.}
proc getBytes*(buffer: EntryBuffer): Gsize {.
    importc: "gtk_entry_buffer_get_bytes", libgtk.}
proc bytes*(buffer: EntryBuffer): Gsize {.
    importc: "gtk_entry_buffer_get_bytes", libgtk.}
proc getLength*(buffer: EntryBuffer): cuint {.
    importc: "gtk_entry_buffer_get_length", libgtk.}
proc length*(buffer: EntryBuffer): cuint {.
    importc: "gtk_entry_buffer_get_length", libgtk.}
proc getText*(buffer: EntryBuffer): cstring {.
    importc: "gtk_entry_buffer_get_text", libgtk.}
proc text*(buffer: EntryBuffer): cstring {.
    importc: "gtk_entry_buffer_get_text", libgtk.}
proc setText*(buffer: EntryBuffer; chars: cstring; nChars: cint) {.
    importc: "gtk_entry_buffer_set_text", libgtk.}
proc `text=`*(buffer: EntryBuffer; chars: cstring; nChars: cint) {.
    importc: "gtk_entry_buffer_set_text", libgtk.}
proc setMaxLength*(buffer: EntryBuffer; maxLength: cint) {.
    importc: "gtk_entry_buffer_set_max_length", libgtk.}
proc `maxLength=`*(buffer: EntryBuffer; maxLength: cint) {.
    importc: "gtk_entry_buffer_set_max_length", libgtk.}
proc getMaxLength*(buffer: EntryBuffer): cint {.
    importc: "gtk_entry_buffer_get_max_length", libgtk.}
proc maxLength*(buffer: EntryBuffer): cint {.
    importc: "gtk_entry_buffer_get_max_length", libgtk.}
proc insertText*(buffer: EntryBuffer; position: cuint;
                              chars: cstring; nChars: cint): cuint {.
    importc: "gtk_entry_buffer_insert_text", libgtk.}
proc deleteText*(buffer: EntryBuffer; position: cuint;
                              nChars: cint): cuint {.
    importc: "gtk_entry_buffer_delete_text", libgtk.}
proc emitInsertedText*(buffer: EntryBuffer; position: cuint;
                                    chars: cstring; nChars: cuint) {.
    importc: "gtk_entry_buffer_emit_inserted_text", libgtk.}
proc emitDeletedText*(buffer: EntryBuffer; position: cuint;
                                   nChars: cuint) {.
    importc: "gtk_entry_buffer_emit_deleted_text", libgtk.}

template typeListStore*(): expr =
  (listStoreGetType())

template listStore*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeListStore, ListStoreObj))

template listStoreClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeListStore, ListStoreClassObj))

template isListStore*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeListStore))

template isListStoreClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeListStore))

template listStoreGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeListStore, ListStoreClassObj))

type
  TreeModelFilter* =  ptr TreeModelFilterObj
  TreeModelFilterPtr* = ptr TreeModelFilterObj
  TreeModelFilterObj*{.final.} = object of GObjectObj
    priv34: pointer

  TreeModelFilterClass* =  ptr TreeModelFilterClassObj
  TreeModelFilterClassPtr* = ptr TreeModelFilterClassObj
  TreeModelFilterClassObj*{.final.} = object of GObjectClassObj
    visible*: proc (self: TreeModelFilter; childModel: TreeModel;
                  iter: TreeIter): Gboolean {.cdecl.}
    modify*: proc (self: TreeModelFilter; childModel: TreeModel;
                 iter: TreeIter; value: gobject.GValue; column: cint) {.cdecl.}
    gtkReserved251*: proc () {.cdecl.}
    gtkReserved252*: proc () {.cdecl.}
    gtkReserved253*: proc () {.cdecl.}
    gtkReserved254*: proc () {.cdecl.}

proc listStoreGetType*(): GType {.importc: "gtk_list_store_get_type", libgtk.}
proc newListStore*(nColumns: cint): ListStore {.varargs,
    importc: "gtk_list_store_new", libgtk.}
proc listStoreNewv*(nColumns: cint; types: ptr GType): ListStore {.
    importc: "gtk_list_store_newv", libgtk.}
proc setColumnTypes*(listStore: ListStore; nColumns: cint;
                                types: ptr GType) {.
    importc: "gtk_list_store_set_column_types", libgtk.}
proc `columnTypes=`*(listStore: ListStore; nColumns: cint;
                                types: ptr GType) {.
    importc: "gtk_list_store_set_column_types", libgtk.}

proc setValue*(listStore: ListStore; iter: TreeIter;
                          column: cint; value: gobject.GValue) {.
    importc: "gtk_list_store_set_value", libgtk.}

proc `value=`*(listStore: ListStore; iter: TreeIter;
                          column: cint; value: gobject.GValue) {.
    importc: "gtk_list_store_set_value", libgtk.}
proc set*(listStore: ListStore; iter: TreeIter) {.varargs,
    importc: "gtk_list_store_set", libgtk.}
proc setValuesv*(listStore: ListStore; iter: TreeIter;
                            columns: var cint; values: gobject.GValue; nValues: cint) {.
    importc: "gtk_list_store_set_valuesv", libgtk.}
proc `valuesv=`*(listStore: ListStore; iter: TreeIter;
                            columns: var cint; values: gobject.GValue; nValues: cint) {.
    importc: "gtk_list_store_set_valuesv", libgtk.}

discard """ proc "setValist*(listStore: ListStore; iter: TreeIter;
                           varArgs: VaList) {.
    importc: "gtk_list_store_set_valist", libgtk.}"""

proc remove*(listStore: ListStore; iter: TreeIter): Gboolean {.
    importc: "gtk_list_store_remove", libgtk.}
proc insert*(listStore: ListStore; iter: TreeIter;
                        position: cint) {.importc: "gtk_list_store_insert",
                                        libgtk.}
proc insertBefore*(listStore: ListStore; iter: TreeIter;
                              sibling: TreeIter) {.
    importc: "gtk_list_store_insert_before", libgtk.}
proc insertAfter*(listStore: ListStore; iter: TreeIter;
                             sibling: TreeIter) {.
    importc: "gtk_list_store_insert_after", libgtk.}
proc insertWithValues*(listStore: ListStore;
                                  iter: TreeIter; position: cint) {.varargs,
    importc: "gtk_list_store_insert_with_values", libgtk.}
proc insertWithValuesv*(listStore: ListStore;
                                   iter: TreeIter; position: cint;
                                   columns: var cint; values: gobject.GValue;
                                   nValues: cint) {.
    importc: "gtk_list_store_insert_with_valuesv", libgtk.}
proc prepend*(listStore: ListStore; iter: TreeIter) {.
    importc: "gtk_list_store_prepend", libgtk.}
proc append*(listStore: ListStore; iter: TreeIter) {.
    importc: "gtk_list_store_append", libgtk.}
proc clear*(listStore: ListStore) {.
    importc: "gtk_list_store_clear", libgtk.}
proc iterIsValid*(listStore: ListStore; iter: TreeIter): Gboolean {.
    importc: "gtk_list_store_iter_is_valid", libgtk.}
proc reorder*(store: ListStore; newOrder: var cint) {.
    importc: "gtk_list_store_reorder", libgtk.}
proc swap*(store: ListStore; a: TreeIter; b: TreeIter) {.
    importc: "gtk_list_store_swap", libgtk.}
proc moveAfter*(store: ListStore; iter: TreeIter;
                           position: TreeIter) {.
    importc: "gtk_list_store_move_after", libgtk.}
proc moveBefore*(store: ListStore; iter: TreeIter;
                            position: TreeIter) {.
    importc: "gtk_list_store_move_before", libgtk.}

template typeTreeModelFilter*(): expr =
  (treeModelFilterGetType())

template treeModelFilter*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeModelFilter, TreeModelFilterObj))

template treeModelFilterClass*(vtable: expr): expr =
  (gTypeCheckClassCast(vtable, typeTreeModelFilter, TreeModelFilterClassObj))

template isTreeModelFilter*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeModelFilter))

template isTreeModelFilterClass*(vtable: expr): expr =
  (gTypeCheckClassType(vtable, typeTreeModelFilter))

template treeModelFilterGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTreeModelFilter, TreeModelFilterClassObj))

type
  TreeModelFilterVisibleFunc* = proc (model: TreeModel;
                                      iter: TreeIter; data: Gpointer): Gboolean {.cdecl.}

type
  TreeModelFilterModifyFunc* = proc (model: TreeModel;
                                     iter: TreeIter; value: gobject.GValue;
                                     column: cint; data: Gpointer) {.cdecl.}

  EntryCompletion* =  ptr EntryCompletionObj
  EntryCompletionPtr* = ptr EntryCompletionObj
  EntryCompletionObj*{.final.} = object of GObjectObj
    priv35: pointer

  EntryCompletionClass* =  ptr EntryCompletionClassObj
  EntryCompletionClassPtr* = ptr EntryCompletionClassObj
  EntryCompletionClassObj*{.final.} = object of GObjectClassObj
    matchSelected*: proc (completion: EntryCompletion;
                        model: TreeModel; iter: TreeIter): Gboolean {.cdecl.}
    actionActivated*: proc (completion: EntryCompletion; index: cint) {.cdecl.}
    insertPrefix*: proc (completion: EntryCompletion; prefix: cstring): Gboolean {.cdecl.}
    cursorOnMatch*: proc (completion: EntryCompletion;
                        model: TreeModel; iter: TreeIter): Gboolean {.cdecl.}
    noMatches*: proc (completion: EntryCompletion) {.cdecl.}
    gtkReserved260*: proc () {.cdecl.}
    gtkReserved261*: proc () {.cdecl.}
    gtkReserved262*: proc () {.cdecl.}

proc treeModelFilterGetType*(): GType {.importc: "gtk_tree_model_filter_get_type",
                                        libgtk.}
proc newFilter*(childModel: TreeModel; root: TreePath): TreeModel {.
    importc: "gtk_tree_model_filter_new", libgtk.}
proc setVisibleFunc*(filter: TreeModelFilter;
                                      `func`: TreeModelFilterVisibleFunc;
                                      data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_model_filter_set_visible_func", libgtk.}
proc `visibleFunc=`*(filter: TreeModelFilter;
                                      `func`: TreeModelFilterVisibleFunc;
                                      data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_model_filter_set_visible_func", libgtk.}
proc setModifyFunc*(filter: TreeModelFilter;
                                     nColumns: cint; types: ptr GType;
                                     `func`: TreeModelFilterModifyFunc;
                                     data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_model_filter_set_modify_func", libgtk.}
proc `modifyFunc=`*(filter: TreeModelFilter;
                                     nColumns: cint; types: ptr GType;
                                     `func`: TreeModelFilterModifyFunc;
                                     data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_model_filter_set_modify_func", libgtk.}
proc setVisibleColumn*(filter: TreeModelFilter;
                                        column: cint) {.
    importc: "gtk_tree_model_filter_set_visible_column", libgtk.}
proc `visibleColumn=`*(filter: TreeModelFilter;
                                        column: cint) {.
    importc: "gtk_tree_model_filter_set_visible_column", libgtk.}
proc getModel*(filter: TreeModelFilter): TreeModel {.
    importc: "gtk_tree_model_filter_get_model", libgtk.}
proc model*(filter: TreeModelFilter): TreeModel {.
    importc: "gtk_tree_model_filter_get_model", libgtk.}

proc convertChildIterToIter*(filter: TreeModelFilter;
    filterIter: TreeIter; childIter: TreeIter): Gboolean {.
    importc: "gtk_tree_model_filter_convert_child_iter_to_iter", libgtk.}
proc convertIterToChildIter*(filter: TreeModelFilter;
    childIter: TreeIter; filterIter: TreeIter) {.
    importc: "gtk_tree_model_filter_convert_iter_to_child_iter", libgtk.}
proc convertChildPathToPath*(filter: TreeModelFilter;
    childPath: TreePath): TreePath {.
    importc: "gtk_tree_model_filter_convert_child_path_to_path", libgtk.}
proc convertPathToChildPath*(filter: TreeModelFilter;
    filterPath: TreePath): TreePath {.
    importc: "gtk_tree_model_filter_convert_path_to_child_path", libgtk.}

proc refilter*(filter: TreeModelFilter) {.
    importc: "gtk_tree_model_filter_refilter", libgtk.}
proc clearCache*(filter: TreeModelFilter) {.
    importc: "gtk_tree_model_filter_clear_cache", libgtk.}

template typeEntryCompletion*(): expr =
  (entryCompletionGetType())

template entryCompletion*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeEntryCompletion, EntryCompletionObj))

template entryCompletionClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeEntryCompletion, EntryCompletionClassObj))

template isEntryCompletion*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeEntryCompletion))

template isEntryCompletionClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeEntryCompletion))

template entryCompletionGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeEntryCompletion, EntryCompletionClassObj))

type
  EntryCompletionMatchFunc* = proc (completion: EntryCompletion;
                                    key: cstring; iter: TreeIter;
                                    userData: Gpointer): Gboolean {.cdecl.}
  Image* =  ptr ImageObj
  ImagePtr* = ptr ImageObj
  ImageObj*{.final.} = object of MiscObj
    priv36: pointer

  ImageClass* =  ptr ImageClassObj
  ImageClassPtr* = ptr ImageClassObj
  ImageClassObj*{.final.} = object of MiscClassObj
    gtkReserved271*: proc () {.cdecl.}
    gtkReserved272*: proc () {.cdecl.}
    gtkReserved273*: proc () {.cdecl.}
    gtkReserved274*: proc () {.cdecl.}

proc entryCompletionGetType*(): GType {.importc: "gtk_entry_completion_get_type",
                                        libgtk.}
proc newEntryCompletion*(): EntryCompletion {.
    importc: "gtk_entry_completion_new", libgtk.}
proc newEntryCompletion*(area: CellArea): EntryCompletion {.
    importc: "gtk_entry_completion_new_with_area", libgtk.}
proc setModel*(completion: EntryCompletion;
                                model: TreeModel) {.
    importc: "gtk_entry_completion_set_model", libgtk.}
proc `model=`*(completion: EntryCompletion;
                                model: TreeModel) {.
    importc: "gtk_entry_completion_set_model", libgtk.}
proc getModel*(completion: EntryCompletion): TreeModel {.
    importc: "gtk_entry_completion_get_model", libgtk.}
proc model*(completion: EntryCompletion): TreeModel {.
    importc: "gtk_entry_completion_get_model", libgtk.}
proc setMatchFunc*(completion: EntryCompletion;
                                    `func`: EntryCompletionMatchFunc;
                                    funcData: Gpointer; funcNotify: GDestroyNotify) {.
    importc: "gtk_entry_completion_set_match_func", libgtk.}
proc `matchFunc=`*(completion: EntryCompletion;
                                    `func`: EntryCompletionMatchFunc;
                                    funcData: Gpointer; funcNotify: GDestroyNotify) {.
    importc: "gtk_entry_completion_set_match_func", libgtk.}
proc setMinimumKeyLength*(completion: EntryCompletion;
    length: cint) {.importc: "gtk_entry_completion_set_minimum_key_length",
                  libgtk.}
proc `minimumKeyLength=`*(completion: EntryCompletion;
    length: cint) {.importc: "gtk_entry_completion_set_minimum_key_length",
                  libgtk.}
proc getMinimumKeyLength*(completion: EntryCompletion): cint {.
    importc: "gtk_entry_completion_get_minimum_key_length", libgtk.}
proc minimumKeyLength*(completion: EntryCompletion): cint {.
    importc: "gtk_entry_completion_get_minimum_key_length", libgtk.}
proc computePrefix*(completion: EntryCompletion;
                                     key: cstring): cstring {.
    importc: "gtk_entry_completion_compute_prefix", libgtk.}
proc complete*(completion: EntryCompletion) {.
    importc: "gtk_entry_completion_complete", libgtk.}
proc insertPrefix*(completion: EntryCompletion) {.
    importc: "gtk_entry_completion_insert_prefix", libgtk.}
proc insertActionText*(completion: EntryCompletion;
                                        index: cint; text: cstring) {.
    importc: "gtk_entry_completion_insert_action_text", libgtk.}
proc insertActionMarkup*(completion: EntryCompletion;
    index: cint; markup: cstring) {.importc: "gtk_entry_completion_insert_action_markup",
                                libgtk.}
proc deleteAction*(completion: EntryCompletion; index: cint) {.
    importc: "gtk_entry_completion_delete_action", libgtk.}
proc setInlineCompletion*(completion: EntryCompletion;
    inlineCompletion: Gboolean) {.importc: "gtk_entry_completion_set_inline_completion",
                                libgtk.}
proc `inlineCompletion=`*(completion: EntryCompletion;
    inlineCompletion: Gboolean) {.importc: "gtk_entry_completion_set_inline_completion",
                                libgtk.}
proc getInlineCompletion*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_inline_completion", libgtk.}
proc inlineCompletion*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_inline_completion", libgtk.}
proc setInlineSelection*(completion: EntryCompletion;
    inlineSelection: Gboolean) {.importc: "gtk_entry_completion_set_inline_selection",
                               libgtk.}
proc `inlineSelection=`*(completion: EntryCompletion;
    inlineSelection: Gboolean) {.importc: "gtk_entry_completion_set_inline_selection",
                               libgtk.}
proc getInlineSelection*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_inline_selection", libgtk.}
proc inlineSelection*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_inline_selection", libgtk.}
proc setPopupCompletion*(completion: EntryCompletion;
    popupCompletion: Gboolean) {.importc: "gtk_entry_completion_set_popup_completion",
                               libgtk.}
proc `popupCompletion=`*(completion: EntryCompletion;
    popupCompletion: Gboolean) {.importc: "gtk_entry_completion_set_popup_completion",
                               libgtk.}
proc getPopupCompletion*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_popup_completion", libgtk.}
proc popupCompletion*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_popup_completion", libgtk.}
proc setPopupSetWidth*(completion: EntryCompletion;
                                        popupSetWidth: Gboolean) {.
    importc: "gtk_entry_completion_set_popup_set_width", libgtk.}
proc `popupSetWidth=`*(completion: EntryCompletion;
                                        popupSetWidth: Gboolean) {.
    importc: "gtk_entry_completion_set_popup_set_width", libgtk.}
proc getPopupSetWidth*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_popup_set_width", libgtk.}
proc popupSetWidth*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_popup_set_width", libgtk.}
proc setPopupSingleMatch*(completion: EntryCompletion;
    popupSingleMatch: Gboolean) {.importc: "gtk_entry_completion_set_popup_single_match",
                                libgtk.}
proc `popupSingleMatch=`*(completion: EntryCompletion;
    popupSingleMatch: Gboolean) {.importc: "gtk_entry_completion_set_popup_single_match",
                                libgtk.}
proc getPopupSingleMatch*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_popup_single_match", libgtk.}
proc popupSingleMatch*(completion: EntryCompletion): Gboolean {.
    importc: "gtk_entry_completion_get_popup_single_match", libgtk.}
proc getCompletionPrefix*(completion: EntryCompletion): cstring {.
    importc: "gtk_entry_completion_get_completion_prefix", libgtk.}
proc completionPrefix*(completion: EntryCompletion): cstring {.
    importc: "gtk_entry_completion_get_completion_prefix", libgtk.}

proc setTextColumn*(completion: EntryCompletion;
                                     column: cint) {.
    importc: "gtk_entry_completion_set_text_column", libgtk.}

proc `textColumn=`*(completion: EntryCompletion;
                                     column: cint) {.
    importc: "gtk_entry_completion_set_text_column", libgtk.}
proc getTextColumn*(completion: EntryCompletion): cint {.
    importc: "gtk_entry_completion_get_text_column", libgtk.}
proc textColumn*(completion: EntryCompletion): cint {.
    importc: "gtk_entry_completion_get_text_column", libgtk.}

template typeImage*(): expr =
  (imageGetType())

template image*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeImage, ImageObj))

template imageClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeImage, ImageClassObj))

template isImage*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeImage))

template isImageClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeImage))

template imageGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeImage, ImageClassObj))

type
  ImageType* {.size: sizeof(cint), pure.} = enum
    EMPTY, PIXBUF, STOCK, ICON_SET,
    ANIMATION, ICON_NAME, GICON, SURFACE

type
  Entry* =  ptr EntryObj
  EntryPtr* = ptr EntryObj
  EntryObj = object of WidgetObj
    priv37: pointer

  SpinButton* =  ptr SpinButtonObj
  SpinButtonPtr* = ptr SpinButtonObj
  SpinButtonObj* = object of EntryObj
    priv38: pointer

  EntryClass* =  ptr EntryClassObj
  EntryClassPtr* = ptr EntryClassObj
  EntryClassObj = object of WidgetClassObj
    populatePopup*: proc (entry: Entry; popup: Widget) {.cdecl.}
    activate*: proc (entry: Entry) {.cdecl.}
    moveCursor*: proc (entry: Entry; step: MovementStep; count: cint;
                     extendSelection: Gboolean) {.cdecl.}
    insertAtCursor*: proc (entry: Entry; str: cstring) {.cdecl.}
    deleteFromCursor*: proc (entry: Entry; `type`: DeleteType; count: cint) {.cdecl.}
    backspace*: proc (entry: Entry) {.cdecl.}
    cutClipboard*: proc (entry: Entry) {.cdecl.}
    copyClipboard*: proc (entry: Entry) {.cdecl.}
    pasteClipboard*: proc (entry: Entry) {.cdecl.}
    toggleOverwrite*: proc (entry: Entry) {.cdecl.}
    getTextAreaSize*: proc (entry: Entry; x: var cint; y: var cint; width: var cint;
                          height: var cint) {.cdecl.}
    getFrameSize*: proc (entry: Entry; x: var cint; y: var cint; width: var cint;
                       height: var cint) {.cdecl.}
    gtkReserved281*: proc () {.cdecl.}
    gtkReserved282*: proc () {.cdecl.}
    gtkReserved283*: proc () {.cdecl.}
    gtkReserved284*: proc () {.cdecl.}
    gtkReserved285*: proc () {.cdecl.}
    gtkReserved286*: proc () {.cdecl.}
    gtkReserved287*: proc () {.cdecl.}

proc imageGetType*(): GType {.importc: "gtk_image_get_type", libgtk.}
proc newImage*(): Image {.importc: "gtk_image_new", libgtk.}
proc newImage*(pixbuf: GdkPixbuf): Widget {.
    importc: "gtk_image_new_from_pixbuf", libgtk.}
proc clear*(image: Image) {.importc: "gtk_image_clear", libgtk.}
proc setFromFile*(image: Image; filename: cstring) {.
    importc: "gtk_image_set_from_file", libgtk.}
proc `fromFile=`*(image: Image; filename: cstring) {.
    importc: "gtk_image_set_from_file", libgtk.}
proc setFromResource*(image: Image; resourcePath: cstring) {.
    importc: "gtk_image_set_from_resource", libgtk.}
proc `fromResource=`*(image: Image; resourcePath: cstring) {.
    importc: "gtk_image_set_from_resource", libgtk.}
proc setFromPixbuf*(image: Image; pixbuf: GdkPixbuf) {.
    importc: "gtk_image_set_from_pixbuf", libgtk.}
proc `fromPixbuf=`*(image: Image; pixbuf: GdkPixbuf) {.
    importc: "gtk_image_set_from_pixbuf", libgtk.}
proc setFromStock*(image: Image; stockId: cstring; size: IconSize) {.
    importc: "gtk_image_set_from_stock", libgtk.}
proc `fromStock=`*(image: Image; stockId: cstring; size: IconSize) {.
    importc: "gtk_image_set_from_stock", libgtk.}
proc setFromIconSet*(image: Image; iconSet: IconSet;
                            size: IconSize) {.
    importc: "gtk_image_set_from_icon_set", libgtk.}
proc `fromIconSet=`*(image: Image; iconSet: IconSet;
                            size: IconSize) {.
    importc: "gtk_image_set_from_icon_set", libgtk.}
proc setFromAnimation*(image: Image;
                              animation: gdk_pixbuf.Animation) {.
    importc: "gtk_image_set_from_animation", libgtk.}
proc `fromAnimation=`*(image: Image;
                              animation: gdk_pixbuf.Animation) {.
    importc: "gtk_image_set_from_animation", libgtk.}
proc setFromIconName*(image: Image; iconName: cstring;
                             size: IconSize) {.
    importc: "gtk_image_set_from_icon_name", libgtk.}
proc `fromIconName=`*(image: Image; iconName: cstring;
                             size: IconSize) {.
    importc: "gtk_image_set_from_icon_name", libgtk.}
proc setFromGicon*(image: Image; icon: gio.GIcon; size: IconSize) {.
    importc: "gtk_image_set_from_gicon", libgtk.}
proc `fromGicon=`*(image: Image; icon: gio.GIcon; size: IconSize) {.
    importc: "gtk_image_set_from_gicon", libgtk.}
proc setFromSurface*(image: Image; surface: cairo.Surface) {.
    importc: "gtk_image_set_from_surface", libgtk.}
proc `fromSurface=`*(image: Image; surface: cairo.Surface) {.
    importc: "gtk_image_set_from_surface", libgtk.}
proc setPixelSize*(image: Image; pixelSize: cint) {.
    importc: "gtk_image_set_pixel_size", libgtk.}
proc `pixelSize=`*(image: Image; pixelSize: cint) {.
    importc: "gtk_image_set_pixel_size", libgtk.}
proc getStorageType*(image: Image): ImageType {.
    importc: "gtk_image_get_storage_type", libgtk.}
proc storageType*(image: Image): ImageType {.
    importc: "gtk_image_get_storage_type", libgtk.}
proc getPixbuf*(image: Image): GdkPixbuf {.
    importc: "gtk_image_get_pixbuf", libgtk.}
proc pixbuf*(image: Image): GdkPixbuf {.
    importc: "gtk_image_get_pixbuf", libgtk.}
proc getStock*(image: Image; stockId: cstringArray;
                      size: var IconSize) {.importc: "gtk_image_get_stock",
    libgtk.}
proc getIconSet*(image: Image; iconSet: var IconSet;
                        size: var IconSize) {.importc: "gtk_image_get_icon_set",
    libgtk.}
proc getAnimation*(image: Image): gdk_pixbuf.Animation {.
    importc: "gtk_image_get_animation", libgtk.}
proc animation*(image: Image): gdk_pixbuf.Animation {.
    importc: "gtk_image_get_animation", libgtk.}
proc getIconName*(image: Image; iconName: cstringArray;
                         size: var IconSize) {.
    importc: "gtk_image_get_icon_name", libgtk.}
proc getGicon*(image: Image; gicon: var gio.GIcon; size: var IconSize) {.
    importc: "gtk_image_get_gicon", libgtk.}
proc getPixelSize*(image: Image): cint {.
    importc: "gtk_image_get_pixel_size", libgtk.}
proc pixelSize*(image: Image): cint {.
    importc: "gtk_image_get_pixel_size", libgtk.}

template typeEntry*(): expr =
  (entryGetType())

template entry*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeEntry, EntryObj))

template entryClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeEntry, EntryClassObj))

template isEntry*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeEntry))

template isEntryClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeEntry))

template entryGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeEntry, EntryClassObj))

type
  EntryIconPosition* {.size: sizeof(cint), pure.} = enum
    PRIMARY, SECONDARY

proc entryGetType*(): GType {.importc: "gtk_entry_get_type", libgtk.}
proc newEntry*(): Entry {.importc: "gtk_entry_new", libgtk.}
proc getBuffer*(entry: Entry): EntryBuffer {.
    importc: "gtk_entry_get_buffer", libgtk.}
proc buffer*(entry: Entry): EntryBuffer {.
    importc: "gtk_entry_get_buffer", libgtk.}
proc setBuffer*(entry: Entry; buffer: EntryBuffer) {.
    importc: "gtk_entry_set_buffer", libgtk.}
proc `buffer=`*(entry: Entry; buffer: EntryBuffer) {.
    importc: "gtk_entry_set_buffer", libgtk.}
proc getTextArea*(entry: Entry; textArea: var gdk3.RectangleObj) {.
    importc: "gtk_entry_get_text_area", libgtk.}
proc setVisibility*(entry: Entry; visible: Gboolean) {.
    importc: "gtk_entry_set_visibility", libgtk.}
proc `visibility=`*(entry: Entry; visible: Gboolean) {.
    importc: "gtk_entry_set_visibility", libgtk.}
proc getVisibility*(entry: Entry): Gboolean {.
    importc: "gtk_entry_get_visibility", libgtk.}
proc visibility*(entry: Entry): Gboolean {.
    importc: "gtk_entry_get_visibility", libgtk.}
proc setInvisibleChar*(entry: Entry; ch: Gunichar) {.
    importc: "gtk_entry_set_invisible_char", libgtk.}
proc `invisibleChar=`*(entry: Entry; ch: Gunichar) {.
    importc: "gtk_entry_set_invisible_char", libgtk.}
proc getInvisibleChar*(entry: Entry): Gunichar {.
    importc: "gtk_entry_get_invisible_char", libgtk.}
proc invisibleChar*(entry: Entry): Gunichar {.
    importc: "gtk_entry_get_invisible_char", libgtk.}
proc unsetInvisibleChar*(entry: Entry) {.
    importc: "gtk_entry_unset_invisible_char", libgtk.}
proc setHasFrame*(entry: Entry; setting: Gboolean) {.
    importc: "gtk_entry_set_has_frame", libgtk.}
proc `hasFrame=`*(entry: Entry; setting: Gboolean) {.
    importc: "gtk_entry_set_has_frame", libgtk.}
proc getHasFrame*(entry: Entry): Gboolean {.
    importc: "gtk_entry_get_has_frame", libgtk.}
proc hasFrame*(entry: Entry): Gboolean {.
    importc: "gtk_entry_get_has_frame", libgtk.}
proc setInnerBorder*(entry: Entry; border: Border) {.
    importc: "gtk_entry_set_inner_border", libgtk.}
proc `innerBorder=`*(entry: Entry; border: Border) {.
    importc: "gtk_entry_set_inner_border", libgtk.}
proc getInnerBorder*(entry: Entry): Border {.
    importc: "gtk_entry_get_inner_border", libgtk.}
proc innerBorder*(entry: Entry): Border {.
    importc: "gtk_entry_get_inner_border", libgtk.}
proc setOverwriteMode*(entry: Entry; overwrite: Gboolean) {.
    importc: "gtk_entry_set_overwrite_mode", libgtk.}
proc `overwriteMode=`*(entry: Entry; overwrite: Gboolean) {.
    importc: "gtk_entry_set_overwrite_mode", libgtk.}
proc getOverwriteMode*(entry: Entry): Gboolean {.
    importc: "gtk_entry_get_overwrite_mode", libgtk.}
proc overwriteMode*(entry: Entry): Gboolean {.
    importc: "gtk_entry_get_overwrite_mode", libgtk.}

proc setMaxLength*(entry: Entry; max: cint) {.
    importc: "gtk_entry_set_max_length", libgtk.}

proc `maxLength=`*(entry: Entry; max: cint) {.
    importc: "gtk_entry_set_max_length", libgtk.}
proc getMaxLength*(entry: Entry): cint {.
    importc: "gtk_entry_get_max_length", libgtk.}
proc maxLength*(entry: Entry): cint {.
    importc: "gtk_entry_get_max_length", libgtk.}
proc getTextLength*(entry: Entry): uint16 {.
    importc: "gtk_entry_get_text_length", libgtk.}
proc textLength*(entry: Entry): uint16 {.
    importc: "gtk_entry_get_text_length", libgtk.}
proc setActivatesDefault*(entry: Entry; setting: Gboolean) {.
    importc: "gtk_entry_set_activates_default", libgtk.}
proc `activatesDefault=`*(entry: Entry; setting: Gboolean) {.
    importc: "gtk_entry_set_activates_default", libgtk.}
proc getActivatesDefault*(entry: Entry): Gboolean {.
    importc: "gtk_entry_get_activates_default", libgtk.}
proc activatesDefault*(entry: Entry): Gboolean {.
    importc: "gtk_entry_get_activates_default", libgtk.}
proc setWidthChars*(entry: Entry; nChars: cint) {.
    importc: "gtk_entry_set_width_chars", libgtk.}
proc `widthChars=`*(entry: Entry; nChars: cint) {.
    importc: "gtk_entry_set_width_chars", libgtk.}
proc getWidthChars*(entry: Entry): cint {.
    importc: "gtk_entry_get_width_chars", libgtk.}
proc widthChars*(entry: Entry): cint {.
    importc: "gtk_entry_get_width_chars", libgtk.}
proc setMaxWidthChars*(entry: Entry; nChars: cint) {.
    importc: "gtk_entry_set_max_width_chars", libgtk.}
proc `maxWidthChars=`*(entry: Entry; nChars: cint) {.
    importc: "gtk_entry_set_max_width_chars", libgtk.}
proc getMaxWidthChars*(entry: Entry): cint {.
    importc: "gtk_entry_get_max_width_chars", libgtk.}
proc maxWidthChars*(entry: Entry): cint {.
    importc: "gtk_entry_get_max_width_chars", libgtk.}

proc setText*(entry: Entry; text: cstring) {.
    importc: "gtk_entry_set_text", libgtk.}

proc `text=`*(entry: Entry; text: cstring) {.
    importc: "gtk_entry_set_text", libgtk.}

proc getText*(entry: Entry): cstring {.importc: "gtk_entry_get_text",
    libgtk.}

proc text*(entry: Entry): cstring {.importc: "gtk_entry_get_text",
    libgtk.}
proc getLayout*(entry: Entry): pango.Layout {.
    importc: "gtk_entry_get_layout", libgtk.}
proc layout*(entry: Entry): pango.Layout {.
    importc: "gtk_entry_get_layout", libgtk.}
proc getLayoutOffsets*(entry: Entry; x: var cint; y: var cint) {.
    importc: "gtk_entry_get_layout_offsets", libgtk.}
proc setAlignment*(entry: Entry; xalign: cfloat) {.
    importc: "gtk_entry_set_alignment", libgtk.}
proc `alignment=`*(entry: Entry; xalign: cfloat) {.
    importc: "gtk_entry_set_alignment", libgtk.}
proc getAlignment*(entry: Entry): cfloat {.
    importc: "gtk_entry_get_alignment", libgtk.}
proc alignment*(entry: Entry): cfloat {.
    importc: "gtk_entry_get_alignment", libgtk.}
proc setCompletion*(entry: Entry; completion: EntryCompletion) {.
    importc: "gtk_entry_set_completion", libgtk.}
proc `completion=`*(entry: Entry; completion: EntryCompletion) {.
    importc: "gtk_entry_set_completion", libgtk.}
proc getCompletion*(entry: Entry): EntryCompletion {.
    importc: "gtk_entry_get_completion", libgtk.}
proc completion*(entry: Entry): EntryCompletion {.
    importc: "gtk_entry_get_completion", libgtk.}
proc layoutIndexToTextIndex*(entry: Entry; layoutIndex: cint): cint {.
    importc: "gtk_entry_layout_index_to_text_index", libgtk.}
proc textIndexToLayoutIndex*(entry: Entry; textIndex: cint): cint {.
    importc: "gtk_entry_text_index_to_layout_index", libgtk.}

proc setCursorHadjustment*(entry: Entry;
                                  adjustment: Adjustment) {.
    importc: "gtk_entry_set_cursor_hadjustment", libgtk.}

proc `cursorHadjustment=`*(entry: Entry;
                                  adjustment: Adjustment) {.
    importc: "gtk_entry_set_cursor_hadjustment", libgtk.}
proc getCursorHadjustment*(entry: Entry): Adjustment {.
    importc: "gtk_entry_get_cursor_hadjustment", libgtk.}
proc cursorHadjustment*(entry: Entry): Adjustment {.
    importc: "gtk_entry_get_cursor_hadjustment", libgtk.}

proc setProgressFraction*(entry: Entry; fraction: cdouble) {.
    importc: "gtk_entry_set_progress_fraction", libgtk.}

proc `progressFraction=`*(entry: Entry; fraction: cdouble) {.
    importc: "gtk_entry_set_progress_fraction", libgtk.}
proc getProgressFraction*(entry: Entry): cdouble {.
    importc: "gtk_entry_get_progress_fraction", libgtk.}
proc progressFraction*(entry: Entry): cdouble {.
    importc: "gtk_entry_get_progress_fraction", libgtk.}
proc setProgressPulseStep*(entry: Entry; fraction: cdouble) {.
    importc: "gtk_entry_set_progress_pulse_step", libgtk.}
proc `progressPulseStep=`*(entry: Entry; fraction: cdouble) {.
    importc: "gtk_entry_set_progress_pulse_step", libgtk.}
proc getProgressPulseStep*(entry: Entry): cdouble {.
    importc: "gtk_entry_get_progress_pulse_step", libgtk.}
proc progressPulseStep*(entry: Entry): cdouble {.
    importc: "gtk_entry_get_progress_pulse_step", libgtk.}
proc progressPulse*(entry: Entry) {.
    importc: "gtk_entry_progress_pulse", libgtk.}
proc getPlaceholderText*(entry: Entry): cstring {.
    importc: "gtk_entry_get_placeholder_text", libgtk.}
proc placeholderText*(entry: Entry): cstring {.
    importc: "gtk_entry_get_placeholder_text", libgtk.}
proc setPlaceholderText*(entry: Entry; text: cstring) {.
    importc: "gtk_entry_set_placeholder_text", libgtk.}
proc `placeholderText=`*(entry: Entry; text: cstring) {.
    importc: "gtk_entry_set_placeholder_text", libgtk.}

proc setIconFromPixbuf*(entry: Entry; iconPos: EntryIconPosition;
                               pixbuf: GdkPixbuf) {.
    importc: "gtk_entry_set_icon_from_pixbuf", libgtk.}

proc `iconFromPixbuf=`*(entry: Entry; iconPos: EntryIconPosition;
                               pixbuf: GdkPixbuf) {.
    importc: "gtk_entry_set_icon_from_pixbuf", libgtk.}
proc setIconFromStock*(entry: Entry; iconPos: EntryIconPosition;
                              stockId: cstring) {.
    importc: "gtk_entry_set_icon_from_stock", libgtk.}
proc `iconFromStock=`*(entry: Entry; iconPos: EntryIconPosition;
                              stockId: cstring) {.
    importc: "gtk_entry_set_icon_from_stock", libgtk.}
proc setIconFromIconName*(entry: Entry;
                                 iconPos: EntryIconPosition; iconName: cstring) {.
    importc: "gtk_entry_set_icon_from_icon_name", libgtk.}
proc `iconFromIconName=`*(entry: Entry;
                                 iconPos: EntryIconPosition; iconName: cstring) {.
    importc: "gtk_entry_set_icon_from_icon_name", libgtk.}
proc setIconFromGicon*(entry: Entry; iconPos: EntryIconPosition;
                              icon: gio.GIcon) {.
    importc: "gtk_entry_set_icon_from_gicon", libgtk.}
proc `iconFromGicon=`*(entry: Entry; iconPos: EntryIconPosition;
                              icon: gio.GIcon) {.
    importc: "gtk_entry_set_icon_from_gicon", libgtk.}
proc getIconStorageType*(entry: Entry; iconPos: EntryIconPosition): ImageType {.
    importc: "gtk_entry_get_icon_storage_type", libgtk.}
proc iconStorageType*(entry: Entry; iconPos: EntryIconPosition): ImageType {.
    importc: "gtk_entry_get_icon_storage_type", libgtk.}
proc getIconPixbuf*(entry: Entry; iconPos: EntryIconPosition): GdkPixbuf {.
    importc: "gtk_entry_get_icon_pixbuf", libgtk.}
proc iconPixbuf*(entry: Entry; iconPos: EntryIconPosition): GdkPixbuf {.
    importc: "gtk_entry_get_icon_pixbuf", libgtk.}
proc getIconStock*(entry: Entry; iconPos: EntryIconPosition): cstring {.
    importc: "gtk_entry_get_icon_stock", libgtk.}
proc iconStock*(entry: Entry; iconPos: EntryIconPosition): cstring {.
    importc: "gtk_entry_get_icon_stock", libgtk.}
proc getIconName*(entry: Entry; iconPos: EntryIconPosition): cstring {.
    importc: "gtk_entry_get_icon_name", libgtk.}
proc iconName*(entry: Entry; iconPos: EntryIconPosition): cstring {.
    importc: "gtk_entry_get_icon_name", libgtk.}
proc getIconGicon*(entry: Entry; iconPos: EntryIconPosition): gio.GIcon {.
    importc: "gtk_entry_get_icon_gicon", libgtk.}
proc iconGicon*(entry: Entry; iconPos: EntryIconPosition): gio.GIcon {.
    importc: "gtk_entry_get_icon_gicon", libgtk.}
proc setIconActivatable*(entry: Entry; iconPos: EntryIconPosition;
                                activatable: Gboolean) {.
    importc: "gtk_entry_set_icon_activatable", libgtk.}
proc `iconActivatable=`*(entry: Entry; iconPos: EntryIconPosition;
                                activatable: Gboolean) {.
    importc: "gtk_entry_set_icon_activatable", libgtk.}
proc getIconActivatable*(entry: Entry; iconPos: EntryIconPosition): Gboolean {.
    importc: "gtk_entry_get_icon_activatable", libgtk.}
proc iconActivatable*(entry: Entry; iconPos: EntryIconPosition): Gboolean {.
    importc: "gtk_entry_get_icon_activatable", libgtk.}
proc setIconSensitive*(entry: Entry; iconPos: EntryIconPosition;
                              sensitive: Gboolean) {.
    importc: "gtk_entry_set_icon_sensitive", libgtk.}
proc `iconSensitive=`*(entry: Entry; iconPos: EntryIconPosition;
                              sensitive: Gboolean) {.
    importc: "gtk_entry_set_icon_sensitive", libgtk.}
proc getIconSensitive*(entry: Entry; iconPos: EntryIconPosition): Gboolean {.
    importc: "gtk_entry_get_icon_sensitive", libgtk.}
proc iconSensitive*(entry: Entry; iconPos: EntryIconPosition): Gboolean {.
    importc: "gtk_entry_get_icon_sensitive", libgtk.}
proc getIconAtPos*(entry: Entry; x: cint; y: cint): cint {.
    importc: "gtk_entry_get_icon_at_pos", libgtk.}
proc iconAtPos*(entry: Entry; x: cint; y: cint): cint {.
    importc: "gtk_entry_get_icon_at_pos", libgtk.}
proc setIconTooltipText*(entry: Entry; iconPos: EntryIconPosition;
                                tooltip: cstring) {.
    importc: "gtk_entry_set_icon_tooltip_text", libgtk.}
proc `iconTooltipText=`*(entry: Entry; iconPos: EntryIconPosition;
                                tooltip: cstring) {.
    importc: "gtk_entry_set_icon_tooltip_text", libgtk.}
proc getIconTooltipText*(entry: Entry; iconPos: EntryIconPosition): cstring {.
    importc: "gtk_entry_get_icon_tooltip_text", libgtk.}
proc iconTooltipText*(entry: Entry; iconPos: EntryIconPosition): cstring {.
    importc: "gtk_entry_get_icon_tooltip_text", libgtk.}
proc setIconTooltipMarkup*(entry: Entry;
                                  iconPos: EntryIconPosition; tooltip: cstring) {.
    importc: "gtk_entry_set_icon_tooltip_markup", libgtk.}
proc `iconTooltipMarkup=`*(entry: Entry;
                                  iconPos: EntryIconPosition; tooltip: cstring) {.
    importc: "gtk_entry_set_icon_tooltip_markup", libgtk.}
proc getIconTooltipMarkup*(entry: Entry;
                                  iconPos: EntryIconPosition): cstring {.
    importc: "gtk_entry_get_icon_tooltip_markup", libgtk.}
proc iconTooltipMarkup*(entry: Entry;
                                  iconPos: EntryIconPosition): cstring {.
    importc: "gtk_entry_get_icon_tooltip_markup", libgtk.}
proc setIconDragSource*(entry: Entry; iconPos: EntryIconPosition;
                               targetList: TargetList;
                               actions: gdk3.DragAction) {.
    importc: "gtk_entry_set_icon_drag_source", libgtk.}
proc `iconDragSource=`*(entry: Entry; iconPos: EntryIconPosition;
                               targetList: TargetList;
                               actions: gdk3.DragAction) {.
    importc: "gtk_entry_set_icon_drag_source", libgtk.}
proc getCurrentIconDragSource*(entry: Entry): cint {.
    importc: "gtk_entry_get_current_icon_drag_source", libgtk.}
proc currentIconDragSource*(entry: Entry): cint {.
    importc: "gtk_entry_get_current_icon_drag_source", libgtk.}
proc getIconArea*(entry: Entry; iconPos: EntryIconPosition;
                         iconArea: gdk3.Rectangle) {.
    importc: "gtk_entry_get_icon_area", libgtk.}
proc imContextFilterKeypress*(entry: Entry; event: gdk3.EventKey): Gboolean {.
    importc: "gtk_entry_im_context_filter_keypress", libgtk.}
proc resetImContext*(entry: Entry) {.
    importc: "gtk_entry_reset_im_context", libgtk.}
proc setInputPurpose*(entry: Entry; purpose: InputPurpose) {.
    importc: "gtk_entry_set_input_purpose", libgtk.}
proc `inputPurpose=`*(entry: Entry; purpose: InputPurpose) {.
    importc: "gtk_entry_set_input_purpose", libgtk.}
proc getInputPurpose*(entry: Entry): InputPurpose {.
    importc: "gtk_entry_get_input_purpose", libgtk.}
proc inputPurpose*(entry: Entry): InputPurpose {.
    importc: "gtk_entry_get_input_purpose", libgtk.}
proc setInputHints*(entry: Entry; hints: InputHints) {.
    importc: "gtk_entry_set_input_hints", libgtk.}
proc `inputHints=`*(entry: Entry; hints: InputHints) {.
    importc: "gtk_entry_set_input_hints", libgtk.}
proc getInputHints*(entry: Entry): InputHints {.
    importc: "gtk_entry_get_input_hints", libgtk.}
proc inputHints*(entry: Entry): InputHints {.
    importc: "gtk_entry_get_input_hints", libgtk.}
proc setAttributes*(entry: Entry; attrs: pango.AttrList) {.
    importc: "gtk_entry_set_attributes", libgtk.}
proc `attributes=`*(entry: Entry; attrs: pango.AttrList) {.
    importc: "gtk_entry_set_attributes", libgtk.}
proc getAttributes*(entry: Entry): pango.AttrList {.
    importc: "gtk_entry_get_attributes", libgtk.}
proc attributes*(entry: Entry): pango.AttrList {.
    importc: "gtk_entry_get_attributes", libgtk.}
proc setTabs*(entry: Entry; tabs: pango.TabArray) {.
    importc: "gtk_entry_set_tabs", libgtk.}
proc `tabs=`*(entry: Entry; tabs: pango.TabArray) {.
    importc: "gtk_entry_set_tabs", libgtk.}
proc getTabs*(entry: Entry): pango.TabArray {.
    importc: "gtk_entry_get_tabs", libgtk.}
proc tabs*(entry: Entry): pango.TabArray {.
    importc: "gtk_entry_get_tabs", libgtk.}
proc grabFocusWithoutSelecting*(entry: Entry) {.
    importc: "gtk_entry_grab_focus_without_selecting", libgtk.}

type
  TreeViewDropPosition* {.size: sizeof(cint), pure.} = enum
    BEFORE, AFTER,
    INTO_OR_BEFORE, INTO_OR_AFTER

type
  TreeView* =  ptr TreeViewObj
  TreeViewPtr* = ptr TreeViewObj
  TreeViewObj*{.final.} = object of ContainerObj
    priv39: pointer

  TreeViewClass* =  ptr TreeViewClassObj
  TreeViewClassPtr* = ptr TreeViewClassObj
  TreeViewClassObj*{.final.} = object of ContainerClassObj
    rowActivated*: proc (treeView: TreeView; path: TreePath;
                       column: TreeViewColumn) {.cdecl.}
    testExpandRow*: proc (treeView: TreeView; iter: TreeIter;
                        path: TreePath): Gboolean {.cdecl.}
    testCollapseRow*: proc (treeView: TreeView; iter: TreeIter;
                          path: TreePath): Gboolean {.cdecl.}
    rowExpanded*: proc (treeView: TreeView; iter: TreeIter;
                      path: TreePath) {.cdecl.}
    rowCollapsed*: proc (treeView: TreeView; iter: TreeIter;
                       path: TreePath) {.cdecl.}
    columnsChanged*: proc (treeView: TreeView) {.cdecl.}
    cursorChanged*: proc (treeView: TreeView) {.cdecl.}
    moveCursor*: proc (treeView: TreeView; step: MovementStep; count: cint): Gboolean {.cdecl.}
    selectAll*: proc (treeView: TreeView): Gboolean {.cdecl.}
    unselectAll*: proc (treeView: TreeView): Gboolean {.cdecl.}
    selectCursorRow*: proc (treeView: TreeView; startEditing: Gboolean): Gboolean {.cdecl.}
    toggleCursorRow*: proc (treeView: TreeView): Gboolean {.cdecl.}
    expandCollapseCursorRow*: proc (treeView: TreeView; logical: Gboolean;
                                  expand: Gboolean; openAll: Gboolean): Gboolean {.cdecl.}
    selectCursorParent*: proc (treeView: TreeView): Gboolean {.cdecl.}
    startInteractiveSearch*: proc (treeView: TreeView): Gboolean {.cdecl.}
    gtkReserved291*: proc () {.cdecl.}
    gtkReserved292*: proc () {.cdecl.}
    gtkReserved293*: proc () {.cdecl.}
    gtkReserved294*: proc () {.cdecl.}
    gtkReserved295*: proc () {.cdecl.}
    gtkReserved296*: proc () {.cdecl.}
    gtkReserved297*: proc () {.cdecl.}
    gtkReserved298*: proc () {.cdecl.}

template typeTreeView*(): expr =
  (treeViewGetType())

template treeView*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeView, TreeViewObj))

template treeViewClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTreeView, TreeViewClassObj))

template isTreeView*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeView))

template isTreeViewClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTreeView))

template treeViewGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTreeView, TreeViewClassObj))

type
  ComboBox* =  ptr ComboBoxObj
  ComboBoxPtr* = ptr ComboBoxObj
  ComboBoxObj = object of BinObj
    priv40: pointer

  ComboBoxClass* =  ptr ComboBoxClassObj
  ComboBoxClassPtr* = ptr ComboBoxClassObj
  ComboBoxClassObj = object of BinClassObj
    changed*: proc (comboBox: ComboBox) {.cdecl.}
    formatEntryText*: proc (comboBox: ComboBox; path: cstring): cstring {.cdecl.}
    gtkReserved301*: proc () {.cdecl.}
    gtkReserved302*: proc () {.cdecl.}
    gtkReserved303*: proc () {.cdecl.}

  TreeSelection* =  ptr TreeSelectionObj
  TreeSelectionPtr* = ptr TreeSelectionObj
  TreeSelectionObj*{.final.} = object of GObjectObj
    priv41: pointer

type
  TreeViewColumnDropFunc* = proc (treeView: TreeView;
                                  column: TreeViewColumn;
                                  prevColumn: TreeViewColumn;
                                  nextColumn: TreeViewColumn; data: Gpointer): Gboolean {.cdecl.}

type
  TreeViewMappingFunc* = proc (treeView: TreeView; path: TreePath;
                               userData: Gpointer) {.cdecl.}

type
  TreeViewSearchEqualFunc* = proc (model: TreeModel; column: cint;
                                   key: cstring; iter: TreeIter;
                                   searchData: Gpointer): Gboolean {.cdecl.}

type
  TreeViewRowSeparatorFunc* = proc (model: TreeModel; iter: TreeIter;
                                    data: Gpointer): Gboolean {.cdecl.}
  TreeViewSearchPositionFunc* = proc (treeView: TreeView;
                                      searchDialog: Widget;
                                      userData: Gpointer) {.cdecl.}

proc treeViewGetType*(): GType {.importc: "gtk_tree_view_get_type", libgtk.}
proc newTreeView*(): TreeView {.importc: "gtk_tree_view_new", libgtk.}

proc getModel*(treeView: TreeView): TreeModel {.
    importc: "gtk_tree_view_get_model", libgtk.}

proc model*(treeView: TreeView): TreeModel {.
    importc: "gtk_tree_view_get_model", libgtk.}
proc setModel*(treeView: TreeView; model: TreeModel) {.
    importc: "gtk_tree_view_set_model", libgtk.}
proc `model=`*(treeView: TreeView; model: TreeModel) {.
    importc: "gtk_tree_view_set_model", libgtk.}
proc getSelection*(treeView: TreeView): TreeSelection {.
    importc: "gtk_tree_view_get_selection", libgtk.}
proc selection*(treeView: TreeView): TreeSelection {.
    importc: "gtk_tree_view_get_selection", libgtk.}
proc getHadjustment*(treeView: TreeView): Adjustment {.
    importc: "gtk_tree_view_get_hadjustment", libgtk.}
proc hadjustment*(treeView: TreeView): Adjustment {.
    importc: "gtk_tree_view_get_hadjustment", libgtk.}
proc setHadjustment*(treeView: TreeView;
                               adjustment: Adjustment) {.
    importc: "gtk_tree_view_set_hadjustment", libgtk.}
proc `hadjustment=`*(treeView: TreeView;
                               adjustment: Adjustment) {.
    importc: "gtk_tree_view_set_hadjustment", libgtk.}
proc getVadjustment*(treeView: TreeView): Adjustment {.
    importc: "gtk_tree_view_get_vadjustment", libgtk.}
proc vadjustment*(treeView: TreeView): Adjustment {.
    importc: "gtk_tree_view_get_vadjustment", libgtk.}
proc setVadjustment*(treeView: TreeView;
                               adjustment: Adjustment) {.
    importc: "gtk_tree_view_set_vadjustment", libgtk.}
proc `vadjustment=`*(treeView: TreeView;
                               adjustment: Adjustment) {.
    importc: "gtk_tree_view_set_vadjustment", libgtk.}
proc getHeadersVisible*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_headers_visible", libgtk.}
proc headersVisible*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_headers_visible", libgtk.}
proc setHeadersVisible*(treeView: TreeView;
                                  headersVisible: Gboolean) {.
    importc: "gtk_tree_view_set_headers_visible", libgtk.}
proc `headersVisible=`*(treeView: TreeView;
                                  headersVisible: Gboolean) {.
    importc: "gtk_tree_view_set_headers_visible", libgtk.}
proc columnsAutosize*(treeView: TreeView) {.
    importc: "gtk_tree_view_columns_autosize", libgtk.}
proc getHeadersClickable*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_headers_clickable", libgtk.}
proc headersClickable*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_headers_clickable", libgtk.}
proc setHeadersClickable*(treeView: TreeView; setting: Gboolean) {.
    importc: "gtk_tree_view_set_headers_clickable", libgtk.}
proc `headersClickable=`*(treeView: TreeView; setting: Gboolean) {.
    importc: "gtk_tree_view_set_headers_clickable", libgtk.}
proc setRulesHint*(treeView: TreeView; setting: Gboolean) {.
    importc: "gtk_tree_view_set_rules_hint", libgtk.}
proc `rulesHint=`*(treeView: TreeView; setting: Gboolean) {.
    importc: "gtk_tree_view_set_rules_hint", libgtk.}
proc getRulesHint*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_rules_hint", libgtk.}
proc rulesHint*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_rules_hint", libgtk.}
proc getActivateOnSingleClick*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_activate_on_single_click", libgtk.}
proc activateOnSingleClick*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_activate_on_single_click", libgtk.}
proc setActivateOnSingleClick*(treeView: TreeView;
    single: Gboolean) {.importc: "gtk_tree_view_set_activate_on_single_click",
                      libgtk.}
proc `activateOnSingleClick=`*(treeView: TreeView;
    single: Gboolean) {.importc: "gtk_tree_view_set_activate_on_single_click",
                      libgtk.}

proc appendColumn*(treeView: TreeView;
                             column: TreeViewColumn): cint {.
    importc: "gtk_tree_view_append_column", libgtk.}
proc removeColumn*(treeView: TreeView;
                             column: TreeViewColumn): cint {.
    importc: "gtk_tree_view_remove_column", libgtk.}
proc insertColumn*(treeView: TreeView;
                             column: TreeViewColumn; position: cint): cint {.
    importc: "gtk_tree_view_insert_column", libgtk.}
proc insertColumnWithAttributes*(treeView: TreeView;
    position: cint; title: cstring; cell: CellRenderer): cint {.varargs,
    importc: "gtk_tree_view_insert_column_with_attributes", libgtk.}
proc insertColumnWithDataFunc*(treeView: TreeView; position: cint;
    title: cstring; cell: CellRenderer; `func`: TreeCellDataFunc;
    data: Gpointer; dnotify: GDestroyNotify): cint {.
    importc: "gtk_tree_view_insert_column_with_data_func", libgtk.}
proc getNColumns*(treeView: TreeView): cuint {.
    importc: "gtk_tree_view_get_n_columns", libgtk.}
proc nColumns*(treeView: TreeView): cuint {.
    importc: "gtk_tree_view_get_n_columns", libgtk.}
proc getColumn*(treeView: TreeView; n: cint): TreeViewColumn {.
    importc: "gtk_tree_view_get_column", libgtk.}
proc column*(treeView: TreeView; n: cint): TreeViewColumn {.
    importc: "gtk_tree_view_get_column", libgtk.}
proc getColumns*(treeView: TreeView): glib.GList {.
    importc: "gtk_tree_view_get_columns", libgtk.}
proc columns*(treeView: TreeView): glib.GList {.
    importc: "gtk_tree_view_get_columns", libgtk.}
proc moveColumnAfter*(treeView: TreeView;
                                column: TreeViewColumn;
                                baseColumn: TreeViewColumn) {.
    importc: "gtk_tree_view_move_column_after", libgtk.}
proc setExpanderColumn*(treeView: TreeView;
                                  column: TreeViewColumn) {.
    importc: "gtk_tree_view_set_expander_column", libgtk.}
proc `expanderColumn=`*(treeView: TreeView;
                                  column: TreeViewColumn) {.
    importc: "gtk_tree_view_set_expander_column", libgtk.}
proc getExpanderColumn*(treeView: TreeView): TreeViewColumn {.
    importc: "gtk_tree_view_get_expander_column", libgtk.}
proc expanderColumn*(treeView: TreeView): TreeViewColumn {.
    importc: "gtk_tree_view_get_expander_column", libgtk.}
proc setColumnDragFunction*(treeView: TreeView;
                                      `func`: TreeViewColumnDropFunc;
                                      userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_column_drag_function", libgtk.}
proc `columnDragFunction=`*(treeView: TreeView;
                                      `func`: TreeViewColumnDropFunc;
                                      userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_column_drag_function", libgtk.}

proc scrollToPoint*(treeView: TreeView; treeX: cint; treeY: cint) {.
    importc: "gtk_tree_view_scroll_to_point", libgtk.}
proc scrollToCell*(treeView: TreeView; path: TreePath;
                             column: TreeViewColumn; useAlign: Gboolean;
                             rowAlign: cfloat; colAlign: cfloat) {.
    importc: "gtk_tree_view_scroll_to_cell", libgtk.}
proc rowActivated*(treeView: TreeView; path: TreePath;
                             column: TreeViewColumn) {.
    importc: "gtk_tree_view_row_activated", libgtk.}
proc expandAll*(treeView: TreeView) {.
    importc: "gtk_tree_view_expand_all", libgtk.}
proc collapseAll*(treeView: TreeView) {.
    importc: "gtk_tree_view_collapse_all", libgtk.}
proc expandToPath*(treeView: TreeView; path: TreePath) {.
    importc: "gtk_tree_view_expand_to_path", libgtk.}
proc expandRow*(treeView: TreeView; path: TreePath;
                          openAll: Gboolean): Gboolean {.
    importc: "gtk_tree_view_expand_row", libgtk.}
proc collapseRow*(treeView: TreeView; path: TreePath): Gboolean {.
    importc: "gtk_tree_view_collapse_row", libgtk.}
proc mapExpandedRows*(treeView: TreeView;
                                `func`: TreeViewMappingFunc; data: Gpointer) {.
    importc: "gtk_tree_view_map_expanded_rows", libgtk.}
proc rowExpanded*(treeView: TreeView; path: TreePath): Gboolean {.
    importc: "gtk_tree_view_row_expanded", libgtk.}
proc setReorderable*(treeView: TreeView; reorderable: Gboolean) {.
    importc: "gtk_tree_view_set_reorderable", libgtk.}
proc `reorderable=`*(treeView: TreeView; reorderable: Gboolean) {.
    importc: "gtk_tree_view_set_reorderable", libgtk.}
proc getReorderable*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_reorderable", libgtk.}
proc reorderable*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_reorderable", libgtk.}
proc setCursor*(treeView: TreeView; path: TreePath;
                          focusColumn: TreeViewColumn;
                          startEditing: Gboolean) {.
    importc: "gtk_tree_view_set_cursor", libgtk.}
proc `cursor=`*(treeView: TreeView; path: TreePath;
                          focusColumn: TreeViewColumn;
                          startEditing: Gboolean) {.
    importc: "gtk_tree_view_set_cursor", libgtk.}
proc setCursorOnCell*(treeView: TreeView; path: TreePath;
                                focusColumn: TreeViewColumn;
                                focusCell: CellRenderer;
                                startEditing: Gboolean) {.
    importc: "gtk_tree_view_set_cursor_on_cell", libgtk.}
proc `cursorOnCell=`*(treeView: TreeView; path: TreePath;
                                focusColumn: TreeViewColumn;
                                focusCell: CellRenderer;
                                startEditing: Gboolean) {.
    importc: "gtk_tree_view_set_cursor_on_cell", libgtk.}
proc getCursor*(treeView: TreeView; path: var TreePath;
                          focusColumn: var TreeViewColumn) {.
    importc: "gtk_tree_view_get_cursor", libgtk.}

proc getBinWindow*(treeView: TreeView): gdk3.Window {.
    importc: "gtk_tree_view_get_bin_window", libgtk.}

proc binWindow*(treeView: TreeView): gdk3.Window {.
    importc: "gtk_tree_view_get_bin_window", libgtk.}
proc getPathAtPos*(treeView: TreeView; x: cint; y: cint;
                             path: var TreePath;
                             column: var TreeViewColumn; cellX: var cint;
                             cellY: var cint): Gboolean {.
    importc: "gtk_tree_view_get_path_at_pos", libgtk.}
proc pathAtPos*(treeView: TreeView; x: cint; y: cint;
                             path: var TreePath;
                             column: var TreeViewColumn; cellX: var cint;
                             cellY: var cint): Gboolean {.
    importc: "gtk_tree_view_get_path_at_pos", libgtk.}
proc getCellArea*(treeView: TreeView; path: TreePath;
                            column: TreeViewColumn; rect: gdk3.Rectangle) {.
    importc: "gtk_tree_view_get_cell_area", libgtk.}
proc getBackgroundArea*(treeView: TreeView; path: TreePath;
                                  column: TreeViewColumn;
                                  rect: gdk3.Rectangle) {.
    importc: "gtk_tree_view_get_background_area", libgtk.}
proc getVisibleRect*(treeView: TreeView;
                               visibleRect: gdk3.Rectangle) {.
    importc: "gtk_tree_view_get_visible_rect", libgtk.}
proc getVisibleRange*(treeView: TreeView;
                                startPath: var TreePath;
                                endPath: var TreePath): Gboolean {.
    importc: "gtk_tree_view_get_visible_range", libgtk.}
proc visibleRange*(treeView: TreeView;
                                startPath: var TreePath;
                                endPath: var TreePath): Gboolean {.
    importc: "gtk_tree_view_get_visible_range", libgtk.}
proc isBlankAtPos*(treeView: TreeView; x: cint; y: cint;
                             path: var TreePath;
                             column: var TreeViewColumn; cellX: var cint;
                             cellY: var cint): Gboolean {.
    importc: "gtk_tree_view_is_blank_at_pos", libgtk.}

proc enableModelDragSource*(treeView: TreeView;
                                      startButtonMask: gdk3.ModifierType;
                                      targets: TargetEntry; nTargets: cint;
                                      actions: gdk3.DragAction) {.
    importc: "gtk_tree_view_enable_model_drag_source", libgtk.}
proc enableModelDragDest*(treeView: TreeView;
                                    targets: TargetEntry; nTargets: cint;
                                    actions: gdk3.DragAction) {.
    importc: "gtk_tree_view_enable_model_drag_dest", libgtk.}
proc unsetRowsDragSource*(treeView: TreeView) {.
    importc: "gtk_tree_view_unset_rows_drag_source", libgtk.}
proc unsetRowsDragDest*(treeView: TreeView) {.
    importc: "gtk_tree_view_unset_rows_drag_dest", libgtk.}

proc setDragDestRow*(treeView: TreeView; path: TreePath;
                               pos: TreeViewDropPosition) {.
    importc: "gtk_tree_view_set_drag_dest_row", libgtk.}

proc `dragDestRow=`*(treeView: TreeView; path: TreePath;
                               pos: TreeViewDropPosition) {.
    importc: "gtk_tree_view_set_drag_dest_row", libgtk.}
proc getDragDestRow*(treeView: TreeView;
                               path: var TreePath;
                               pos: var TreeViewDropPosition) {.
    importc: "gtk_tree_view_get_drag_dest_row", libgtk.}
proc getDestRowAtPos*(treeView: TreeView; dragX: cint; dragY: cint;
                                path: var TreePath;
                                pos: var TreeViewDropPosition): Gboolean {.
    importc: "gtk_tree_view_get_dest_row_at_pos", libgtk.}
proc destRowAtPos*(treeView: TreeView; dragX: cint; dragY: cint;
                                path: var TreePath;
                                pos: var TreeViewDropPosition): Gboolean {.
    importc: "gtk_tree_view_get_dest_row_at_pos", libgtk.}
proc createRowDragIcon*(treeView: TreeView; path: TreePath): cairo.Surface {.
    importc: "gtk_tree_view_create_row_drag_icon", libgtk.}

proc setEnableSearch*(treeView: TreeView; enableSearch: Gboolean) {.
    importc: "gtk_tree_view_set_enable_search", libgtk.}

proc `enableSearch=`*(treeView: TreeView; enableSearch: Gboolean) {.
    importc: "gtk_tree_view_set_enable_search", libgtk.}
proc getEnableSearch*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_enable_search", libgtk.}
proc enableSearch*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_enable_search", libgtk.}
proc getSearchColumn*(treeView: TreeView): cint {.
    importc: "gtk_tree_view_get_search_column", libgtk.}
proc searchColumn*(treeView: TreeView): cint {.
    importc: "gtk_tree_view_get_search_column", libgtk.}
proc setSearchColumn*(treeView: TreeView; column: cint) {.
    importc: "gtk_tree_view_set_search_column", libgtk.}
proc `searchColumn=`*(treeView: TreeView; column: cint) {.
    importc: "gtk_tree_view_set_search_column", libgtk.}
proc getSearchEqualFunc*(treeView: TreeView): TreeViewSearchEqualFunc {.
    importc: "gtk_tree_view_get_search_equal_func", libgtk.}
proc searchEqualFunc*(treeView: TreeView): TreeViewSearchEqualFunc {.
    importc: "gtk_tree_view_get_search_equal_func", libgtk.}
proc setSearchEqualFunc*(treeView: TreeView;
                                   searchEqualFunc: TreeViewSearchEqualFunc;
                                   searchUserData: Gpointer;
                                   searchDestroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_search_equal_func", libgtk.}
proc `searchEqualFunc=`*(treeView: TreeView;
                                   searchEqualFunc: TreeViewSearchEqualFunc;
                                   searchUserData: Gpointer;
                                   searchDestroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_search_equal_func", libgtk.}
proc getSearchEntry*(treeView: TreeView): Entry {.
    importc: "gtk_tree_view_get_search_entry", libgtk.}
proc searchEntry*(treeView: TreeView): Entry {.
    importc: "gtk_tree_view_get_search_entry", libgtk.}
proc setSearchEntry*(treeView: TreeView; entry: Entry) {.
    importc: "gtk_tree_view_set_search_entry", libgtk.}
proc `searchEntry=`*(treeView: TreeView; entry: Entry) {.
    importc: "gtk_tree_view_set_search_entry", libgtk.}
proc getSearchPositionFunc*(treeView: TreeView): TreeViewSearchPositionFunc {.
    importc: "gtk_tree_view_get_search_position_func", libgtk.}
proc searchPositionFunc*(treeView: TreeView): TreeViewSearchPositionFunc {.
    importc: "gtk_tree_view_get_search_position_func", libgtk.}
proc setSearchPositionFunc*(treeView: TreeView;
                                      `func`: TreeViewSearchPositionFunc;
                                      data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_search_position_func", libgtk.}
proc `searchPositionFunc=`*(treeView: TreeView;
                                      `func`: TreeViewSearchPositionFunc;
                                      data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_search_position_func", libgtk.}

proc convertWidgetToTreeCoords*(treeView: TreeView; wx: cint;
    wy: cint; tx: var cint; ty: var cint) {.importc: "gtk_tree_view_convert_widget_to_tree_coords",
                                    libgtk.}
proc convertTreeToWidgetCoords*(treeView: TreeView; tx: cint;
    ty: cint; wx: var cint; wy: var cint) {.importc: "gtk_tree_view_convert_tree_to_widget_coords",
                                    libgtk.}
proc convertWidgetToBinWindowCoords*(treeView: TreeView; wx: cint;
    wy: cint; bx: var cint; by: var cint) {.importc: "gtk_tree_view_convert_widget_to_bin_window_coords",
                                    libgtk.}
proc convertBinWindowToWidgetCoords*(treeView: TreeView; bx: cint;
    by: cint; wx: var cint; wy: var cint) {.importc: "gtk_tree_view_convert_bin_window_to_widget_coords",
                                    libgtk.}
proc convertTreeToBinWindowCoords*(treeView: TreeView; tx: cint;
    ty: cint; bx: var cint; by: var cint) {.importc: "gtk_tree_view_convert_tree_to_bin_window_coords",
                                    libgtk.}
proc convertBinWindowToTreeCoords*(treeView: TreeView; bx: cint;
    by: cint; tx: var cint; ty: var cint) {.importc: "gtk_tree_view_convert_bin_window_to_tree_coords",
                                    libgtk.}

type
  TreeDestroyCountFunc* = proc (treeView: TreeView; path: TreePath;
                                children: cint; userData: Gpointer) {.cdecl.}

proc setDestroyCountFunc*(treeView: TreeView;
                                    `func`: TreeDestroyCountFunc;
                                    data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_destroy_count_func", libgtk.}

proc `destroyCountFunc=`*(treeView: TreeView;
                                    `func`: TreeDestroyCountFunc;
                                    data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_destroy_count_func", libgtk.}
proc setFixedHeightMode*(treeView: TreeView; enable: Gboolean) {.
    importc: "gtk_tree_view_set_fixed_height_mode", libgtk.}
proc `fixedHeightMode=`*(treeView: TreeView; enable: Gboolean) {.
    importc: "gtk_tree_view_set_fixed_height_mode", libgtk.}
proc getFixedHeightMode*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_fixed_height_mode", libgtk.}
proc fixedHeightMode*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_fixed_height_mode", libgtk.}
proc setHoverSelection*(treeView: TreeView; hover: Gboolean) {.
    importc: "gtk_tree_view_set_hover_selection", libgtk.}
proc `hoverSelection=`*(treeView: TreeView; hover: Gboolean) {.
    importc: "gtk_tree_view_set_hover_selection", libgtk.}
proc getHoverSelection*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_hover_selection", libgtk.}
proc hoverSelection*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_hover_selection", libgtk.}
proc setHoverExpand*(treeView: TreeView; expand: Gboolean) {.
    importc: "gtk_tree_view_set_hover_expand", libgtk.}
proc `hoverExpand=`*(treeView: TreeView; expand: Gboolean) {.
    importc: "gtk_tree_view_set_hover_expand", libgtk.}
proc getHoverExpand*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_hover_expand", libgtk.}
proc hoverExpand*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_hover_expand", libgtk.}
proc setRubberBanding*(treeView: TreeView; enable: Gboolean) {.
    importc: "gtk_tree_view_set_rubber_banding", libgtk.}
proc `rubberBanding=`*(treeView: TreeView; enable: Gboolean) {.
    importc: "gtk_tree_view_set_rubber_banding", libgtk.}
proc getRubberBanding*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_rubber_banding", libgtk.}
proc rubberBanding*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_rubber_banding", libgtk.}
proc isRubberBandingActive*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_is_rubber_banding_active", libgtk.}
proc getRowSeparatorFunc*(treeView: TreeView): TreeViewRowSeparatorFunc {.
    importc: "gtk_tree_view_get_row_separator_func", libgtk.}
proc rowSeparatorFunc*(treeView: TreeView): TreeViewRowSeparatorFunc {.
    importc: "gtk_tree_view_get_row_separator_func", libgtk.}
proc setRowSeparatorFunc*(treeView: TreeView;
                                    `func`: TreeViewRowSeparatorFunc;
                                    data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_row_separator_func", libgtk.}
proc `rowSeparatorFunc=`*(treeView: TreeView;
                                    `func`: TreeViewRowSeparatorFunc;
                                    data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_view_set_row_separator_func", libgtk.}
proc getGridLines*(treeView: TreeView): TreeViewGridLines {.
    importc: "gtk_tree_view_get_grid_lines", libgtk.}
proc gridLines*(treeView: TreeView): TreeViewGridLines {.
    importc: "gtk_tree_view_get_grid_lines", libgtk.}
proc setGridLines*(treeView: TreeView;
                             gridLines: TreeViewGridLines) {.
    importc: "gtk_tree_view_set_grid_lines", libgtk.}
proc `gridLines=`*(treeView: TreeView;
                             gridLines: TreeViewGridLines) {.
    importc: "gtk_tree_view_set_grid_lines", libgtk.}
proc getEnableTreeLines*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_enable_tree_lines", libgtk.}
proc enableTreeLines*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_enable_tree_lines", libgtk.}
proc setEnableTreeLines*(treeView: TreeView; enabled: Gboolean) {.
    importc: "gtk_tree_view_set_enable_tree_lines", libgtk.}
proc `enableTreeLines=`*(treeView: TreeView; enabled: Gboolean) {.
    importc: "gtk_tree_view_set_enable_tree_lines", libgtk.}
proc setShowExpanders*(treeView: TreeView; enabled: Gboolean) {.
    importc: "gtk_tree_view_set_show_expanders", libgtk.}
proc `showExpanders=`*(treeView: TreeView; enabled: Gboolean) {.
    importc: "gtk_tree_view_set_show_expanders", libgtk.}
proc getShowExpanders*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_show_expanders", libgtk.}
proc showExpanders*(treeView: TreeView): Gboolean {.
    importc: "gtk_tree_view_get_show_expanders", libgtk.}
proc setLevelIndentation*(treeView: TreeView; indentation: cint) {.
    importc: "gtk_tree_view_set_level_indentation", libgtk.}
proc `levelIndentation=`*(treeView: TreeView; indentation: cint) {.
    importc: "gtk_tree_view_set_level_indentation", libgtk.}
proc getLevelIndentation*(treeView: TreeView): cint {.
    importc: "gtk_tree_view_get_level_indentation", libgtk.}
proc levelIndentation*(treeView: TreeView): cint {.
    importc: "gtk_tree_view_get_level_indentation", libgtk.}

proc setTooltipRow*(treeView: TreeView; tooltip: Tooltip;
                              path: TreePath) {.
    importc: "gtk_tree_view_set_tooltip_row", libgtk.}

proc `tooltipRow=`*(treeView: TreeView; tooltip: Tooltip;
                              path: TreePath) {.
    importc: "gtk_tree_view_set_tooltip_row", libgtk.}
proc setTooltipCell*(treeView: TreeView; tooltip: Tooltip;
                               path: TreePath;
                               column: TreeViewColumn;
                               cell: CellRenderer) {.
    importc: "gtk_tree_view_set_tooltip_cell", libgtk.}
proc `tooltipCell=`*(treeView: TreeView; tooltip: Tooltip;
                               path: TreePath;
                               column: TreeViewColumn;
                               cell: CellRenderer) {.
    importc: "gtk_tree_view_set_tooltip_cell", libgtk.}
proc getTooltipContext*(treeView: TreeView; x: var cint; y: var cint;
                                  keyboardTip: Gboolean;
                                  model: var TreeModel;
                                  path: var TreePath; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_view_get_tooltip_context", libgtk.}
proc tooltipContext*(treeView: TreeView; x: var cint; y: var cint;
                                  keyboardTip: Gboolean;
                                  model: var TreeModel;
                                  path: var TreePath; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_view_get_tooltip_context", libgtk.}
proc setTooltipColumn*(treeView: TreeView; column: cint) {.
    importc: "gtk_tree_view_set_tooltip_column", libgtk.}
proc `tooltipColumn=`*(treeView: TreeView; column: cint) {.
    importc: "gtk_tree_view_set_tooltip_column", libgtk.}
proc getTooltipColumn*(treeView: TreeView): cint {.
    importc: "gtk_tree_view_get_tooltip_column", libgtk.}
proc tooltipColumn*(treeView: TreeView): cint {.
    importc: "gtk_tree_view_get_tooltip_column", libgtk.}

template typeComboBox*(): expr =
  (comboBoxGetType())

template comboBox*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeComboBox, ComboBoxObj))

template comboBoxClass*(vtable: expr): expr =
  (gTypeCheckClassCast(vtable, typeComboBox, ComboBoxClassObj))

template isComboBox*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeComboBox))

template isComboBoxClass*(vtable: expr): expr =
  (gTypeCheckClassType(vtable, typeComboBox))

template comboBoxGetClass*(inst: expr): expr =
  (gTypeInstanceGetClass(inst, typeComboBox, ComboBoxClassObj))

proc comboBoxGetType*(): GType {.importc: "gtk_combo_box_get_type", libgtk.}
proc newComboBox*(): ComboBox {.importc: "gtk_combo_box_new", libgtk.}

proc getWrapWidth*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_wrap_width", libgtk.}

proc wrapWidth*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_wrap_width", libgtk.}
proc setWrapWidth*(comboBox: ComboBox; width: cint) {.
    importc: "gtk_combo_box_set_wrap_width", libgtk.}
proc `wrapWidth=`*(comboBox: ComboBox; width: cint) {.
    importc: "gtk_combo_box_set_wrap_width", libgtk.}
proc getRowSpanColumn*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_row_span_column", libgtk.}
proc rowSpanColumn*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_row_span_column", libgtk.}
proc setRowSpanColumn*(comboBox: ComboBox; rowSpan: cint) {.
    importc: "gtk_combo_box_set_row_span_column", libgtk.}
proc `rowSpanColumn=`*(comboBox: ComboBox; rowSpan: cint) {.
    importc: "gtk_combo_box_set_row_span_column", libgtk.}
proc getColumnSpanColumn*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_column_span_column", libgtk.}
proc columnSpanColumn*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_column_span_column", libgtk.}
proc setColumnSpanColumn*(comboBox: ComboBox; columnSpan: cint) {.
    importc: "gtk_combo_box_set_column_span_column", libgtk.}
proc `columnSpanColumn=`*(comboBox: ComboBox; columnSpan: cint) {.
    importc: "gtk_combo_box_set_column_span_column", libgtk.}
proc getAddTearoffs*(comboBox: ComboBox): Gboolean {.
    importc: "gtk_combo_box_get_add_tearoffs", libgtk.}
proc addTearoffs*(comboBox: ComboBox): Gboolean {.
    importc: "gtk_combo_box_get_add_tearoffs", libgtk.}
proc setAddTearoffs*(comboBox: ComboBox; addTearoffs: Gboolean) {.
    importc: "gtk_combo_box_set_add_tearoffs", libgtk.}
proc `addTearoffs=`*(comboBox: ComboBox; addTearoffs: Gboolean) {.
    importc: "gtk_combo_box_set_add_tearoffs", libgtk.}
proc getTitle*(comboBox: ComboBox): cstring {.
    importc: "gtk_combo_box_get_title", libgtk.}
proc title*(comboBox: ComboBox): cstring {.
    importc: "gtk_combo_box_get_title", libgtk.}
proc setTitle*(comboBox: ComboBox; title: cstring) {.
    importc: "gtk_combo_box_set_title", libgtk.}
proc `title=`*(comboBox: ComboBox; title: cstring) {.
    importc: "gtk_combo_box_set_title", libgtk.}
proc getFocusOnClick*(combo: ComboBox): Gboolean {.
    importc: "gtk_combo_box_get_focus_on_click", libgtk.}
proc focusOnClick*(combo: ComboBox): Gboolean {.
    importc: "gtk_combo_box_get_focus_on_click", libgtk.}
proc setFocusOnClick*(combo: ComboBox; focusOnClick: Gboolean) {.
    importc: "gtk_combo_box_set_focus_on_click", libgtk.}
proc `focusOnClick=`*(combo: ComboBox; focusOnClick: Gboolean) {.
    importc: "gtk_combo_box_set_focus_on_click", libgtk.}

proc getActive*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_active", libgtk.}

proc active*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_active", libgtk.}
proc setActive*(comboBox: ComboBox; index: cint) {.
    importc: "gtk_combo_box_set_active", libgtk.}
proc `active=`*(comboBox: ComboBox; index: cint) {.
    importc: "gtk_combo_box_set_active", libgtk.}
proc getActiveIter*(comboBox: ComboBox; iter: TreeIter): Gboolean {.
    importc: "gtk_combo_box_get_active_iter", libgtk.}
proc activeIter*(comboBox: ComboBox; iter: TreeIter): Gboolean {.
    importc: "gtk_combo_box_get_active_iter", libgtk.}
proc setActiveIter*(comboBox: ComboBox; iter: TreeIter) {.
    importc: "gtk_combo_box_set_active_iter", libgtk.}
proc `activeIter=`*(comboBox: ComboBox; iter: TreeIter) {.
    importc: "gtk_combo_box_set_active_iter", libgtk.}

proc setModel*(comboBox: ComboBox; model: TreeModel) {.
    importc: "gtk_combo_box_set_model", libgtk.}

proc `model=`*(comboBox: ComboBox; model: TreeModel) {.
    importc: "gtk_combo_box_set_model", libgtk.}
proc getModel*(comboBox: ComboBox): TreeModel {.
    importc: "gtk_combo_box_get_model", libgtk.}
proc model*(comboBox: ComboBox): TreeModel {.
    importc: "gtk_combo_box_get_model", libgtk.}
proc getRowSeparatorFunc*(comboBox: ComboBox): TreeViewRowSeparatorFunc {.
    importc: "gtk_combo_box_get_row_separator_func", libgtk.}
proc rowSeparatorFunc*(comboBox: ComboBox): TreeViewRowSeparatorFunc {.
    importc: "gtk_combo_box_get_row_separator_func", libgtk.}
proc setRowSeparatorFunc*(comboBox: ComboBox;
                                    `func`: TreeViewRowSeparatorFunc;
                                    data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_combo_box_set_row_separator_func", libgtk.}
proc `rowSeparatorFunc=`*(comboBox: ComboBox;
                                    `func`: TreeViewRowSeparatorFunc;
                                    data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_combo_box_set_row_separator_func", libgtk.}
proc setButtonSensitivity*(comboBox: ComboBox;
                                     sensitivity: SensitivityType) {.
    importc: "gtk_combo_box_set_button_sensitivity", libgtk.}
proc `buttonSensitivity=`*(comboBox: ComboBox;
                                     sensitivity: SensitivityType) {.
    importc: "gtk_combo_box_set_button_sensitivity", libgtk.}
proc getButtonSensitivity*(comboBox: ComboBox): SensitivityType {.
    importc: "gtk_combo_box_get_button_sensitivity", libgtk.}
proc buttonSensitivity*(comboBox: ComboBox): SensitivityType {.
    importc: "gtk_combo_box_get_button_sensitivity", libgtk.}
proc getHasEntry*(comboBox: ComboBox): Gboolean {.
    importc: "gtk_combo_box_get_has_entry", libgtk.}
proc hasEntry*(comboBox: ComboBox): Gboolean {.
    importc: "gtk_combo_box_get_has_entry", libgtk.}
proc setEntryTextColumn*(comboBox: ComboBox; textColumn: cint) {.
    importc: "gtk_combo_box_set_entry_text_column", libgtk.}
proc `entryTextColumn=`*(comboBox: ComboBox; textColumn: cint) {.
    importc: "gtk_combo_box_set_entry_text_column", libgtk.}
proc getEntryTextColumn*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_entry_text_column", libgtk.}
proc entryTextColumn*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_entry_text_column", libgtk.}
proc setPopupFixedWidth*(comboBox: ComboBox; fixed: Gboolean) {.
    importc: "gtk_combo_box_set_popup_fixed_width", libgtk.}
proc `popupFixedWidth=`*(comboBox: ComboBox; fixed: Gboolean) {.
    importc: "gtk_combo_box_set_popup_fixed_width", libgtk.}
proc getPopupFixedWidth*(comboBox: ComboBox): Gboolean {.
    importc: "gtk_combo_box_get_popup_fixed_width", libgtk.}
proc popupFixedWidth*(comboBox: ComboBox): Gboolean {.
    importc: "gtk_combo_box_get_popup_fixed_width", libgtk.}

proc popup*(comboBox: ComboBox) {.importc: "gtk_combo_box_popup",
    libgtk.}
proc popupForDevice*(comboBox: ComboBox; device: gdk3.Device) {.
    importc: "gtk_combo_box_popup_for_device", libgtk.}
proc popdown*(comboBox: ComboBox) {.
    importc: "gtk_combo_box_popdown", libgtk.}
proc getPopupAccessible*(comboBox: ComboBox): atk.Object {.
    importc: "gtk_combo_box_get_popup_accessible", libgtk.}
proc popupAccessible*(comboBox: ComboBox): atk.Object {.
    importc: "gtk_combo_box_get_popup_accessible", libgtk.}
proc getIdColumn*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_id_column", libgtk.}
proc idColumn*(comboBox: ComboBox): cint {.
    importc: "gtk_combo_box_get_id_column", libgtk.}
proc setIdColumn*(comboBox: ComboBox; idColumn: cint) {.
    importc: "gtk_combo_box_set_id_column", libgtk.}
proc `idColumn=`*(comboBox: ComboBox; idColumn: cint) {.
    importc: "gtk_combo_box_set_id_column", libgtk.}
proc getActiveId*(comboBox: ComboBox): cstring {.
    importc: "gtk_combo_box_get_active_id", libgtk.}
proc activeId*(comboBox: ComboBox): cstring {.
    importc: "gtk_combo_box_get_active_id", libgtk.}
proc setActiveId*(comboBox: ComboBox; activeId: cstring): Gboolean {.
    importc: "gtk_combo_box_set_active_id", libgtk.}

template typeAppChooserButton*(): expr =
  (appChooserButtonGetType())

template appChooserButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeAppChooserButton, AppChooserButtonObj))

template appChooserButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAppChooserButton, AppChooserButtonClassObj))

template isAppChooserButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeAppChooserButton))

template isAppChooserButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAppChooserButton))

template appChooserButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAppChooserButton, AppChooserButtonClassObj))

type
  AppChooserButton* =  ptr AppChooserButtonObj
  AppChooserButtonPtr* = ptr AppChooserButtonObj
  AppChooserButtonObj*{.final.} = object of ComboBoxObj
    priv42: pointer

type
  AppChooserButtonClass* =  ptr AppChooserButtonClassObj
  AppChooserButtonClassPtr* = ptr AppChooserButtonClassObj
  AppChooserButtonClassObj*{.final.} = object of ComboBoxClassObj
    customItemActivated*: proc (self: AppChooserButton; itemName: cstring) {.cdecl.}
    padding*: array[16, Gpointer]

  ShortcutsWindow* =  ptr ShortcutsWindowObj
  ShortcutsWindowPtr* = ptr ShortcutsWindowObj
  ShortcutsWindowObj* = object of WindowObj

  ShortcutsWindowClass* =  ptr ShortcutsWindowClassObj
  ShortcutsWindowClassPtr* = ptr ShortcutsWindowClassObj
  ShortcutsWindowClassObj*{.final.} = object of WindowClassObj
    close*: proc (self: ShortcutsWindow) {.cdecl.}
    search*: proc (self: ShortcutsWindow) {.cdecl.}

proc appChooserButtonGetType*(): GType {.
    importc: "gtk_app_chooser_button_get_type", libgtk.}
proc newAppChooserButton*(contentType: cstring): AppChooserButton {.
    importc: "gtk_app_chooser_button_new", libgtk.}
proc appendSeparator*(self: AppChooserButton) {.
    importc: "gtk_app_chooser_button_append_separator", libgtk.}
proc appendCustomItem*(self: AppChooserButton;
    name: cstring; label: cstring; icon: gio.GIcon) {.
    importc: "gtk_app_chooser_button_append_custom_item", libgtk.}
proc setActiveCustomItem*(self: AppChooserButton;
    name: cstring) {.importc: "gtk_app_chooser_button_set_active_custom_item",
                   libgtk.}
proc `activeCustomItem=`*(self: AppChooserButton;
    name: cstring) {.importc: "gtk_app_chooser_button_set_active_custom_item",
                   libgtk.}
proc setShowDialogItem*(self: AppChooserButton;
    setting: Gboolean) {.importc: "gtk_app_chooser_button_set_show_dialog_item",
                       libgtk.}
proc `showDialogItem=`*(self: AppChooserButton;
    setting: Gboolean) {.importc: "gtk_app_chooser_button_set_show_dialog_item",
                       libgtk.}
proc getShowDialogItem*(self: AppChooserButton): Gboolean {.
    importc: "gtk_app_chooser_button_get_show_dialog_item", libgtk.}
proc showDialogItem*(self: AppChooserButton): Gboolean {.
    importc: "gtk_app_chooser_button_get_show_dialog_item", libgtk.}
proc setHeading*(self: AppChooserButton; heading: cstring) {.
    importc: "gtk_app_chooser_button_set_heading", libgtk.}
proc `heading=`*(self: AppChooserButton; heading: cstring) {.
    importc: "gtk_app_chooser_button_set_heading", libgtk.}
proc getHeading*(self: AppChooserButton): cstring {.
    importc: "gtk_app_chooser_button_get_heading", libgtk.}
proc heading*(self: AppChooserButton): cstring {.
    importc: "gtk_app_chooser_button_get_heading", libgtk.}
proc setShowDefaultItem*(self: AppChooserButton;
    setting: Gboolean) {.importc: "gtk_app_chooser_button_set_show_default_item",
                       libgtk.}
proc `showDefaultItem=`*(self: AppChooserButton;
    setting: Gboolean) {.importc: "gtk_app_chooser_button_set_show_default_item",
                       libgtk.}
proc getShowDefaultItem*(self: AppChooserButton): Gboolean {.
    importc: "gtk_app_chooser_button_get_show_default_item", libgtk.}
proc showDefaultItem*(self: AppChooserButton): Gboolean {.
    importc: "gtk_app_chooser_button_get_show_default_item", libgtk.}

template typeShortcutsWindow*(): expr =
  (shortcutsWindowGetType())

template shortcutsWindow*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeShortcutsWindow, ShortcutsWindowObj))

template shortcutsWindowClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeShortcutsWindow, ShortcutsWindowClassObj))

template isShortcutsWindow*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeShortcutsWindow))

template isShortcutsWindowClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeShortcutsWindow))

template shortcutsWindowGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeShortcutsWindow, ShortcutsWindowClassObj))

type
  ApplicationWindow* =  ptr ApplicationWindowObj
  ApplicationWindowPtr* = ptr ApplicationWindowObj
  ApplicationWindowObj* = object of WindowObj
    priv43: pointer

  ApplicationWindowClass* =  ptr ApplicationWindowClassObj
  ApplicationWindowClassPtr* = ptr ApplicationWindowClassObj
  ApplicationWindowClassObj* = object of WindowClassObj
    padding*: array[14, Gpointer]

proc shortcutsWindowGetType*(): GType {.importc: "gtk_shortcuts_window_get_type",
                                        libgtk.}

template typeApplicationWindow*(): expr =
  (applicationWindowGetType())

template applicationWindow*(inst: expr): expr =
  (gTypeCheckInstanceCast(inst, typeApplicationWindow, ApplicationWindowObj))

template applicationWindowClass*(class: expr): expr =
  (gTypeCheckClassCast(class, typeApplicationWindow, ApplicationWindowClassObj))

template isApplicationWindow*(inst: expr): expr =
  (gTypeCheckInstanceType(inst, typeApplicationWindow))

template isApplicationWindowClass*(class: expr): expr =
  (gTypeCheckClassType(class, typeApplicationWindow))

template applicationWindowGetClass*(inst: expr): expr =
  (gTypeInstanceGetClass(inst, typeApplicationWindow, ApplicationWindowClassObj))

type
  Frame* =  ptr FrameObj
  FramePtr* = ptr FrameObj
  FrameObj* = object of BinObj
    priv44: pointer

  FrameClass* =  ptr FrameClassObj
  FrameClassPtr* = ptr FrameClassObj
  FrameClassObj = object of BinClassObj
    computeChildAllocation*: proc (frame: Frame; allocation: Allocation) {.cdecl.}
    gtkReserved311*: proc () {.cdecl.}
    gtkReserved312*: proc () {.cdecl.}
    gtkReserved313*: proc () {.cdecl.}
    gtkReserved314*: proc () {.cdecl.}

proc applicationWindowGetType*(): GType {.
    importc: "gtk_application_window_get_type", libgtk.}
proc newWindow*(application: Application): ApplicationWindow {.
    importc: "gtk_application_window_new", libgtk.}
proc setShowMenubar*(window: ApplicationWindow;
                                        showMenubar: Gboolean) {.
    importc: "gtk_application_window_set_show_menubar", libgtk.}
proc `showMenubar=`*(window: ApplicationWindow;
                                        showMenubar: Gboolean) {.
    importc: "gtk_application_window_set_show_menubar", libgtk.}
proc getShowMenubar*(window: ApplicationWindow): Gboolean {.
    importc: "gtk_application_window_get_show_menubar", libgtk.}
proc showMenubar*(window: ApplicationWindow): Gboolean {.
    importc: "gtk_application_window_get_show_menubar", libgtk.}
proc getId*(window: ApplicationWindow): cuint {.
    importc: "gtk_application_window_get_id", libgtk.}
proc id*(window: ApplicationWindow): cuint {.
    importc: "gtk_application_window_get_id", libgtk.}
proc setHelpOverlay*(window: ApplicationWindow;
                                        helpOverlay: ShortcutsWindow) {.
    importc: "gtk_application_window_set_help_overlay", libgtk.}
proc `helpOverlay=`*(window: ApplicationWindow;
                                        helpOverlay: ShortcutsWindow) {.
    importc: "gtk_application_window_set_help_overlay", libgtk.}
proc getHelpOverlay*(window: ApplicationWindow): ShortcutsWindow {.
    importc: "gtk_application_window_get_help_overlay", libgtk.}
proc helpOverlay*(window: ApplicationWindow): ShortcutsWindow {.
    importc: "gtk_application_window_get_help_overlay", libgtk.}

template typeFrame*(): expr =
  (frameGetType())

template frame*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFrame, FrameObj))

template frameClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFrame, FrameClassObj))

template isFrame*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFrame))

template isFrameClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFrame))

template frameGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeFrame, FrameClassObj))

type
  AspectFrame* =  ptr AspectFrameObj
  AspectFramePtr* = ptr AspectFrameObj
  AspectFrameObj*{.final.} = object of FrameObj
    priv45: pointer

  AspectFrameClass* =  ptr AspectFrameClassObj
  AspectFrameClassPtr* = ptr AspectFrameClassObj
  AspectFrameClassObj*{.final.} = object of FrameClassObj
    gtkReserved321*: proc () {.cdecl.}
    gtkReserved322*: proc () {.cdecl.}
    gtkReserved323*: proc () {.cdecl.}
    gtkReserved324*: proc () {.cdecl.}

proc frameGetType*(): GType {.importc: "gtk_frame_get_type", libgtk.}
proc newFrame*(label: cstring): Frame {.importc: "gtk_frame_new",
    libgtk.}
proc setLabel*(frame: Frame; label: cstring) {.
    importc: "gtk_frame_set_label", libgtk.}
proc `label=`*(frame: Frame; label: cstring) {.
    importc: "gtk_frame_set_label", libgtk.}
proc getLabel*(frame: Frame): cstring {.
    importc: "gtk_frame_get_label", libgtk.}
proc label*(frame: Frame): cstring {.
    importc: "gtk_frame_get_label", libgtk.}
proc setLabelWidget*(frame: Frame; labelWidget: Widget) {.
    importc: "gtk_frame_set_label_widget", libgtk.}
proc `labelWidget=`*(frame: Frame; labelWidget: Widget) {.
    importc: "gtk_frame_set_label_widget", libgtk.}
proc getLabelWidget*(frame: Frame): Widget {.
    importc: "gtk_frame_get_label_widget", libgtk.}
proc labelWidget*(frame: Frame): Widget {.
    importc: "gtk_frame_get_label_widget", libgtk.}
proc setLabelAlign*(frame: Frame; xalign: cfloat; yalign: cfloat) {.
    importc: "gtk_frame_set_label_align", libgtk.}
proc `labelAlign=`*(frame: Frame; xalign: cfloat; yalign: cfloat) {.
    importc: "gtk_frame_set_label_align", libgtk.}
proc getLabelAlign*(frame: Frame; xalign: var cfloat; yalign: var cfloat) {.
    importc: "gtk_frame_get_label_align", libgtk.}
proc setShadowType*(frame: Frame; `type`: ShadowType) {.
    importc: "gtk_frame_set_shadow_type", libgtk.}
proc `shadowType=`*(frame: Frame; `type`: ShadowType) {.
    importc: "gtk_frame_set_shadow_type", libgtk.}
proc getShadowType*(frame: Frame): ShadowType {.
    importc: "gtk_frame_get_shadow_type", libgtk.}
proc shadowType*(frame: Frame): ShadowType {.
    importc: "gtk_frame_get_shadow_type", libgtk.}

template typeAspectFrame*(): expr =
  (aspectFrameGetType())

template aspectFrame*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeAspectFrame, AspectFrameObj))

template aspectFrameClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeAspectFrame, AspectFrameClassObj))

template isAspectFrame*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeAspectFrame))

template isAspectFrameClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeAspectFrame))

template aspectFrameGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeAspectFrame, AspectFrameClassObj))

type
  Assistant* =  ptr AssistantObj
  AssistantPtr* = ptr AssistantObj
  AssistantObj*{.final.} = object of WindowObj
    priv46: pointer

  AssistantClass* =  ptr AssistantClassObj
  AssistantClassPtr* = ptr AssistantClassObj
  AssistantClassObj*{.final.} = object of WindowClassObj
    prepare*: proc (assistant: Assistant; page: Widget) {.cdecl.}
    apply*: proc (assistant: Assistant) {.cdecl.}
    close*: proc (assistant: Assistant) {.cdecl.}
    cancel*: proc (assistant: Assistant) {.cdecl.}
    gtkReserved331*: proc () {.cdecl.}
    gtkReserved332*: proc () {.cdecl.}
    gtkReserved333*: proc () {.cdecl.}
    gtkReserved334*: proc () {.cdecl.}
    gtkReserved335*: proc () {.cdecl.}

proc aspectFrameGetType*(): GType {.importc: "gtk_aspect_frame_get_type",
                                    libgtk.}
proc newAspectFrame*(label: cstring; xalign: cfloat; yalign: cfloat; ratio: cfloat;
                       obeyChild: Gboolean): AspectFrame {.
    importc: "gtk_aspect_frame_new", libgtk.}
proc set*(aspectFrame: AspectFrame; xalign: cfloat;
                       yalign: cfloat; ratio: cfloat; obeyChild: Gboolean) {.
    importc: "gtk_aspect_frame_set", libgtk.}

template typeAssistant*(): expr =
  (assistantGetType())

template assistant*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeAssistant, AssistantObj))

template assistantClass*(c: expr): expr =
  (gTypeCheckClassCast(c, typeAssistant, AssistantClassObj))

template isAssistant*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeAssistant))

template isAssistantClass*(c: expr): expr =
  (gTypeCheckClassType(c, typeAssistant))

template assistantGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeAssistant, AssistantClassObj))

type
  AssistantPageType* {.size: sizeof(cint), pure.} = enum
    CONTENT, INTRO,
    CONFIRM, SUMMARY,
    PROGRESS, CUSTOM

type
  ButtonBox* =  ptr ButtonBoxObj
  ButtonBoxPtr* = ptr ButtonBoxObj
  ButtonBoxObj* = object of BoxObj
    priv47: pointer

  ButtonBoxClass* =  ptr ButtonBoxClassObj
  ButtonBoxClassPtr* = ptr ButtonBoxClassObj
  ButtonBoxClassObj = object of BoxClassObj
    gtkReserved341*: proc () {.cdecl.}
    gtkReserved342*: proc () {.cdecl.}
    gtkReserved343*: proc () {.cdecl.}
    gtkReserved344*: proc () {.cdecl.}

type
  AssistantPageFunc* = proc (currentPage: cint; data: Gpointer): cint {.cdecl.}

proc assistantGetType*(): GType {.importc: "gtk_assistant_get_type", libgtk.}
proc newAssistant*(): Assistant {.importc: "gtk_assistant_new", libgtk.}
proc nextPage*(assistant: Assistant) {.
    importc: "gtk_assistant_next_page", libgtk.}
proc previousPage*(assistant: Assistant) {.
    importc: "gtk_assistant_previous_page", libgtk.}
proc getCurrentPage*(assistant: Assistant): cint {.
    importc: "gtk_assistant_get_current_page", libgtk.}
proc currentPage*(assistant: Assistant): cint {.
    importc: "gtk_assistant_get_current_page", libgtk.}
proc setCurrentPage*(assistant: Assistant; pageNum: cint) {.
    importc: "gtk_assistant_set_current_page", libgtk.}
proc `currentPage=`*(assistant: Assistant; pageNum: cint) {.
    importc: "gtk_assistant_set_current_page", libgtk.}
proc getNPages*(assistant: Assistant): cint {.
    importc: "gtk_assistant_get_n_pages", libgtk.}
proc nPages*(assistant: Assistant): cint {.
    importc: "gtk_assistant_get_n_pages", libgtk.}
proc getNthPage*(assistant: Assistant; pageNum: cint): Widget {.
    importc: "gtk_assistant_get_nth_page", libgtk.}
proc nthPage*(assistant: Assistant; pageNum: cint): Widget {.
    importc: "gtk_assistant_get_nth_page", libgtk.}
proc prependPage*(assistant: Assistant; page: Widget): cint {.
    importc: "gtk_assistant_prepend_page", libgtk.}
proc appendPage*(assistant: Assistant; page: Widget): cint {.
    importc: "gtk_assistant_append_page", libgtk.}
proc insertPage*(assistant: Assistant; page: Widget;
                            position: cint): cint {.
    importc: "gtk_assistant_insert_page", libgtk.}
proc removePage*(assistant: Assistant; pageNum: cint) {.
    importc: "gtk_assistant_remove_page", libgtk.}
proc setForwardPageFunc*(assistant: Assistant;
                                    pageFunc: AssistantPageFunc;
                                    data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_assistant_set_forward_page_func", libgtk.}
proc `forwardPageFunc=`*(assistant: Assistant;
                                    pageFunc: AssistantPageFunc;
                                    data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_assistant_set_forward_page_func", libgtk.}
proc setPageType*(assistant: Assistant; page: Widget;
                             `type`: AssistantPageType) {.
    importc: "gtk_assistant_set_page_type", libgtk.}
proc `pageType=`*(assistant: Assistant; page: Widget;
                             `type`: AssistantPageType) {.
    importc: "gtk_assistant_set_page_type", libgtk.}
proc getPageType*(assistant: Assistant; page: Widget): AssistantPageType {.
    importc: "gtk_assistant_get_page_type", libgtk.}
proc pageType*(assistant: Assistant; page: Widget): AssistantPageType {.
    importc: "gtk_assistant_get_page_type", libgtk.}
proc setPageTitle*(assistant: Assistant; page: Widget;
                              title: cstring) {.
    importc: "gtk_assistant_set_page_title", libgtk.}
proc `pageTitle=`*(assistant: Assistant; page: Widget;
                              title: cstring) {.
    importc: "gtk_assistant_set_page_title", libgtk.}
proc getPageTitle*(assistant: Assistant; page: Widget): cstring {.
    importc: "gtk_assistant_get_page_title", libgtk.}
proc pageTitle*(assistant: Assistant; page: Widget): cstring {.
    importc: "gtk_assistant_get_page_title", libgtk.}
proc setPageHeaderImage*(assistant: Assistant;
                                    page: Widget; pixbuf: GdkPixbuf) {.
    importc: "gtk_assistant_set_page_header_image", libgtk.}
proc `pageHeaderImage=`*(assistant: Assistant;
                                    page: Widget; pixbuf: GdkPixbuf) {.
    importc: "gtk_assistant_set_page_header_image", libgtk.}
proc getPageHeaderImage*(assistant: Assistant;
                                    page: Widget): GdkPixbuf {.
    importc: "gtk_assistant_get_page_header_image", libgtk.}
proc pageHeaderImage*(assistant: Assistant;
                                    page: Widget): GdkPixbuf {.
    importc: "gtk_assistant_get_page_header_image", libgtk.}
proc setPageSideImage*(assistant: Assistant; page: Widget;
                                  pixbuf: GdkPixbuf) {.
    importc: "gtk_assistant_set_page_side_image", libgtk.}
proc `pageSideImage=`*(assistant: Assistant; page: Widget;
                                  pixbuf: GdkPixbuf) {.
    importc: "gtk_assistant_set_page_side_image", libgtk.}
proc getPageSideImage*(assistant: Assistant; page: Widget): GdkPixbuf {.
    importc: "gtk_assistant_get_page_side_image", libgtk.}
proc pageSideImage*(assistant: Assistant; page: Widget): GdkPixbuf {.
    importc: "gtk_assistant_get_page_side_image", libgtk.}
proc setPageComplete*(assistant: Assistant; page: Widget;
                                 complete: Gboolean) {.
    importc: "gtk_assistant_set_page_complete", libgtk.}
proc `pageComplete=`*(assistant: Assistant; page: Widget;
                                 complete: Gboolean) {.
    importc: "gtk_assistant_set_page_complete", libgtk.}
proc getPageComplete*(assistant: Assistant; page: Widget): Gboolean {.
    importc: "gtk_assistant_get_page_complete", libgtk.}
proc pageComplete*(assistant: Assistant; page: Widget): Gboolean {.
    importc: "gtk_assistant_get_page_complete", libgtk.}
proc addActionWidget*(assistant: Assistant; child: Widget) {.
    importc: "gtk_assistant_add_action_widget", libgtk.}
proc removeActionWidget*(assistant: Assistant;
                                    child: Widget) {.
    importc: "gtk_assistant_remove_action_widget", libgtk.}
proc updateButtonsState*(assistant: Assistant) {.
    importc: "gtk_assistant_update_buttons_state", libgtk.}
proc commit*(assistant: Assistant) {.
    importc: "gtk_assistant_commit", libgtk.}
proc setPageHasPadding*(assistant: Assistant;
                                   page: Widget; hasPadding: Gboolean) {.
    importc: "gtk_assistant_set_page_has_padding", libgtk.}
proc `pageHasPadding=`*(assistant: Assistant;
                                   page: Widget; hasPadding: Gboolean) {.
    importc: "gtk_assistant_set_page_has_padding", libgtk.}
proc getPageHasPadding*(assistant: Assistant; page: Widget): Gboolean {.
    importc: "gtk_assistant_get_page_has_padding", libgtk.}
proc pageHasPadding*(assistant: Assistant; page: Widget): Gboolean {.
    importc: "gtk_assistant_get_page_has_padding", libgtk.}

template typeButtonBox*(): expr =
  (buttonBoxGetType())

template buttonBox*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeButtonBox, ButtonBoxObj))

template buttonBoxClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeButtonBox, ButtonBoxClassObj))

template isButtonBox*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeButtonBox))

template isButtonBoxClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeButtonBox))

template buttonBoxGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeButtonBox, ButtonBoxClassObj))

type
  ButtonBoxStyle* {.size: sizeof(cint), pure.} = enum
    SPREAD = 1, EDGE, START,
    END, CENTER, EXPAND

type
  BindingSet* =  ptr BindingSetObj
  BindingSetPtr* = ptr BindingSetObj
  BindingSetObj* = object
    setName*: cstring
    priority*: cint
    widgetPathPspecs*: glib.GSList
    widgetClassPspecs*: glib.GSList
    classBranchPspecs*: glib.GSList
    entries*: BindingEntry
    current*: BindingEntry
    parsed* {.bitsize: 1.}: cuint

  BindingSignal* =  ptr BindingSignalObj
  BindingSignalPtr* = ptr BindingSignalObj
  BindingSignalObj* = object
    next*: BindingSignal
    signalName*: cstring
    nArgs*: cuint
    args*: BindingArg

  BindingEntry* =  ptr BindingEntryObj
  BindingEntryPtr* = ptr BindingEntryObj
  BindingEntryObj* = object
    keyval*: cuint
    modifiers*: gdk3.ModifierType
    bindingSet*: BindingSet
    destroyed* {.bitsize: 1.}: cuint
    inEmission* {.bitsize: 1.}: cuint
    marksUnbound* {.bitsize: 1.}: cuint
    setNext*: BindingEntry
    hashNext*: BindingEntry
    signals*: BindingSignal

  INNER_C_UNION_11650982809616403195* = object {.union.}
    longData*: clong
    doubleData*: cdouble
    stringData*: cstring

  BindingArg* =  ptr BindingArgObj
  BindingArgPtr* = ptr BindingArgObj
  BindingArgObj* = object
    argType*: GType
    d*: INNER_C_UNION_11650982809616403195

proc buttonBoxGetType*(): GType {.importc: "gtk_button_box_get_type", libgtk.}
proc newButtonBox*(orientation: Orientation): ButtonBox {.
    importc: "gtk_button_box_new", libgtk.}
proc getLayout*(widget: ButtonBox): ButtonBoxStyle {.
    importc: "gtk_button_box_get_layout", libgtk.}
proc layout*(widget: ButtonBox): ButtonBoxStyle {.
    importc: "gtk_button_box_get_layout", libgtk.}
proc setLayout*(widget: ButtonBox; layoutStyle: ButtonBoxStyle) {.
    importc: "gtk_button_box_set_layout", libgtk.}
proc `layout=`*(widget: ButtonBox; layoutStyle: ButtonBoxStyle) {.
    importc: "gtk_button_box_set_layout", libgtk.}
proc getChildSecondary*(widget: ButtonBox; child: Widget): Gboolean {.
    importc: "gtk_button_box_get_child_secondary", libgtk.}
proc childSecondary*(widget: ButtonBox; child: Widget): Gboolean {.
    importc: "gtk_button_box_get_child_secondary", libgtk.}
proc setChildSecondary*(widget: ButtonBox; child: Widget;
                                   isSecondary: Gboolean) {.
    importc: "gtk_button_box_set_child_secondary", libgtk.}
proc `childSecondary=`*(widget: ButtonBox; child: Widget;
                                   isSecondary: Gboolean) {.
    importc: "gtk_button_box_set_child_secondary", libgtk.}
proc getChildNonHomogeneous*(widget: ButtonBox;
                                        child: Widget): Gboolean {.
    importc: "gtk_button_box_get_child_non_homogeneous", libgtk.}
proc childNonHomogeneous*(widget: ButtonBox;
                                        child: Widget): Gboolean {.
    importc: "gtk_button_box_get_child_non_homogeneous", libgtk.}
proc setChildNonHomogeneous*(widget: ButtonBox;
                                        child: Widget;
                                        nonHomogeneous: Gboolean) {.
    importc: "gtk_button_box_set_child_non_homogeneous", libgtk.}
proc `childNonHomogeneous=`*(widget: ButtonBox;
                                        child: Widget;
                                        nonHomogeneous: Gboolean) {.
    importc: "gtk_button_box_set_child_non_homogeneous", libgtk.}

type
  BuilderClass* =  ptr BuilderClassObj
  BuilderClassPtr* = ptr BuilderClassObj
  BuilderClassObj*{.final.} = object of GObjectClassObj
    getTypeFromName*: proc (builder: Builder; typeName: cstring): GType {.cdecl.}
    gtkReserved351*: proc () {.cdecl.}
    gtkReserved352*: proc () {.cdecl.}
    gtkReserved353*: proc () {.cdecl.}
    gtkReserved354*: proc () {.cdecl.}
    gtkReserved355*: proc () {.cdecl.}
    gtkReserved356*: proc () {.cdecl.}
    gtkReserved357*: proc () {.cdecl.}
    gtkReserved358*: proc () {.cdecl.}

proc newBindingSet*(setName: cstring): BindingSet {.
    importc: "gtk_binding_set_new", libgtk.}
proc bindingSetByClass*(objectClass: Gpointer): BindingSet {.
    importc: "gtk_binding_set_by_class", libgtk.}
proc bindingSetFind*(setName: cstring): BindingSet {.
    importc: "gtk_binding_set_find", libgtk.}
proc bindingsActivate*(`object`: GObject; keyval: cuint;
                         modifiers: gdk3.ModifierType): Gboolean {.
    importc: "gtk_bindings_activate", libgtk.}
proc bindingsActivateEvent*(`object`: GObject; event: gdk3.EventKey): Gboolean {.
    importc: "gtk_bindings_activate_event", libgtk.}
proc activate*(bindingSet: BindingSet; keyval: cuint;
                           modifiers: gdk3.ModifierType; `object`: GObject): Gboolean {.
    importc: "gtk_binding_set_activate", libgtk.}
proc bindingEntrySkip*(bindingSet: BindingSet; keyval: cuint;
                         modifiers: gdk3.ModifierType) {.
    importc: "gtk_binding_entry_skip", libgtk.}
proc bindingEntryAddSignal*(bindingSet: BindingSet; keyval: cuint;
                              modifiers: gdk3.ModifierType; signalName: cstring;
                              nArgs: cuint) {.varargs,
    importc: "gtk_binding_entry_add_signal", libgtk.}
proc bindingEntryAddSignall*(bindingSet: BindingSet; keyval: cuint;
                               modifiers: gdk3.ModifierType; signalName: cstring;
                               bindingArgs: glib.GSList) {.
    importc: "gtk_binding_entry_add_signall", libgtk.}
proc bindingEntryAddSignalFromString*(bindingSet: BindingSet;
                                        signalDesc: cstring): GTokenType {.
    importc: "gtk_binding_entry_add_signal_from_string", libgtk.}
proc bindingEntryRemove*(bindingSet: BindingSet; keyval: cuint;
                           modifiers: gdk3.ModifierType) {.
    importc: "gtk_binding_entry_remove", libgtk.}

template typeBuilder*(): expr =
  (builderGetType())

template builder*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeBuilder, BuilderObj))

template builderClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeBuilder, BuilderClassObj))

template isBuilder*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeBuilder))

template isBuilderClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeBuilder))

template builderGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeBuilder, BuilderClassObj))

template builderError*(): expr =
  (gtkBuilderErrorQuark())

type
  BuilderError* {.size: sizeof(cint), pure.} = enum
    INVALID_TYPE_FUNCTION, UNHANDLED_TAG,
    MISSING_ATTRIBUTE, INVALID_ATTRIBUTE,
    INVALID_TAG, MISSING_PROPERTY_VALUE,
    INVALID_VALUE, VERSION_MISMATCH,
    DUPLICATE_ID, OBJECT_TYPE_REFUSED,
    TEMPLATE_MISMATCH, INVALID_PROPERTY,
    INVALID_SIGNAL, INVALID_ID
  Buildable* =  ptr BuildableObj
  BuildablePtr* = ptr BuildableObj
  BuildableObj* = object

proc builderErrorQuark*(): GQuark {.importc: "gtk_builder_error_quark",
                                    libgtk.}
type
  BuildableIface* =  ptr BuildableIfaceObj
  BuildableIfacePtr* = ptr BuildableIfaceObj
  BuildableIfaceObj* = object of gobject.GTypeInterfaceObj
    setName*: proc (buildable: Buildable; name: cstring) {.cdecl.}
    getName*: proc (buildable: Buildable): cstring {.cdecl.}
    addChild*: proc (buildable: Buildable; builder: Builder;
                   child: GObject; `type`: cstring) {.cdecl.}
    setBuildableProperty*: proc (buildable: Buildable;
                               builder: Builder; name: cstring;
                               value: gobject.GValue) {.cdecl.}
    constructChild*: proc (buildable: Buildable; builder: Builder;
                         name: cstring): GObject {.cdecl.}
    customTagStart*: proc (buildable: Buildable; builder: Builder;
                         child: GObject; tagname: cstring;
                         parser: glib.GMarkupParser; data: var Gpointer): Gboolean {.cdecl.}
    customTagEnd*: proc (buildable: Buildable; builder: Builder;
                       child: GObject; tagname: cstring; data: var Gpointer) {.cdecl.}
    customFinished*: proc (buildable: Buildable; builder: Builder;
                         child: GObject; tagname: cstring; data: Gpointer) {.cdecl.}
    parserFinished*: proc (buildable: Buildable; builder: Builder) {.cdecl.}
    getInternalChild*: proc (buildable: Buildable; builder: Builder;
                           childname: cstring): GObject {.cdecl.}

proc builderGetType*(): GType {.importc: "gtk_builder_get_type", libgtk.}
proc newBuilder*(): Builder {.importc: "gtk_builder_new", libgtk.}
proc addFromFile*(builder: Builder; filename: cstring;
                           error: var glib.GError): cuint {.
    importc: "gtk_builder_add_from_file", libgtk.}
proc addFromResource*(builder: Builder; resourcePath: cstring;
                               error: var glib.GError): cuint {.
    importc: "gtk_builder_add_from_resource", libgtk.}
proc addFromString*(builder: Builder; buffer: cstring; length: Gsize;
                             error: var glib.GError): cuint {.
    importc: "gtk_builder_add_from_string", libgtk.}
proc addObjectsFromFile*(builder: Builder; filename: cstring;
                                  objectIds: cstringArray; error: var glib.GError): cuint {.
    importc: "gtk_builder_add_objects_from_file", libgtk.}
proc addObjectsFromResource*(builder: Builder;
                                      resourcePath: cstring;
                                      objectIds: cstringArray;
                                      error: var glib.GError): cuint {.
    importc: "gtk_builder_add_objects_from_resource", libgtk.}
proc addObjectsFromString*(builder: Builder; buffer: cstring;
                                    length: Gsize; objectIds: cstringArray;
                                    error: var glib.GError): cuint {.
    importc: "gtk_builder_add_objects_from_string", libgtk.}
proc getObject*(builder: Builder; name: cstring): GObject {.
    importc: "gtk_builder_get_object", libgtk.}
proc `object`*(builder: Builder; name: cstring): GObject {.
    importc: "gtk_builder_get_object", libgtk.}
proc getObjects*(builder: Builder): glib.GSList {.
    importc: "gtk_builder_get_objects", libgtk.}
proc objects*(builder: Builder): glib.GSList {.
    importc: "gtk_builder_get_objects", libgtk.}
proc exposeObject*(builder: Builder; name: cstring;
                            `object`: GObject) {.
    importc: "gtk_builder_expose_object", libgtk.}
proc connectSignals*(builder: Builder; userData: Gpointer) {.
    importc: "gtk_builder_connect_signals", libgtk.}
proc connectSignalsFull*(builder: Builder;
                                  `func`: BuilderConnectFunc;
                                  userData: Gpointer) {.
    importc: "gtk_builder_connect_signals_full", libgtk.}
proc setTranslationDomain*(builder: Builder; domain: cstring) {.
    importc: "gtk_builder_set_translation_domain", libgtk.}
proc `translationDomain=`*(builder: Builder; domain: cstring) {.
    importc: "gtk_builder_set_translation_domain", libgtk.}
proc getTranslationDomain*(builder: Builder): cstring {.
    importc: "gtk_builder_get_translation_domain", libgtk.}
proc translationDomain*(builder: Builder): cstring {.
    importc: "gtk_builder_get_translation_domain", libgtk.}
proc getTypeFromName*(builder: Builder; typeName: cstring): GType {.
    importc: "gtk_builder_get_type_from_name", libgtk.}
proc typeFromName*(builder: Builder; typeName: cstring): GType {.
    importc: "gtk_builder_get_type_from_name", libgtk.}
proc valueFromString*(builder: Builder; pspec: gobject.GParamSpec;
                               string: cstring; value: gobject.GValue;
                               error: var glib.GError): Gboolean {.
    importc: "gtk_builder_value_from_string", libgtk.}
proc valueFromStringType*(builder: Builder; `type`: GType;
                                   string: cstring; value: gobject.GValue;
                                   error: var glib.GError): Gboolean {.
    importc: "gtk_builder_value_from_string_type", libgtk.}
proc newBuilder*(filename: cstring): Builder {.
    importc: "gtk_builder_new_from_file", libgtk.}
proc newBuilder*(resourcePath: cstring): Builder {.
    importc: "gtk_builder_new_from_resource", libgtk.}
proc newBuilder*(string: cstring; length: Gssize): Builder {.
    importc: "gtk_builder_new_from_string", libgtk.}
proc addCallbackSymbol*(builder: Builder; callbackName: cstring;
                                 callbackSymbol: GCallback) {.
    importc: "gtk_builder_add_callback_symbol", libgtk.}
proc addCallbackSymbols*(builder: Builder;
                                  firstCallbackName: cstring;
                                  firstCallbackSymbol: GCallback) {.varargs,
    importc: "gtk_builder_add_callback_symbols", libgtk.}
proc lookupCallbackSymbol*(builder: Builder; callbackName: cstring): GCallback {.
    importc: "gtk_builder_lookup_callback_symbol", libgtk.}
proc setApplication*(builder: Builder;
                              application: Application) {.
    importc: "gtk_builder_set_application", libgtk.}
proc `application=`*(builder: Builder;
                              application: Application) {.
    importc: "gtk_builder_set_application", libgtk.}
proc getApplication*(builder: Builder): Application {.
    importc: "gtk_builder_get_application", libgtk.}
proc application*(builder: Builder): Application {.
    importc: "gtk_builder_get_application", libgtk.}

template builderWarnInvalidChildType*(`object`, `type`: expr): expr =
  gWarning("\'%s\' is not a valid child type of \'%s\'", `type`,
           gTypeName(g_Object_Type(`object`)))

proc extendWithTemplate*(builder: Builder; widget: Widget;
                                  templateType: GType; buffer: cstring;
                                  length: Gsize; error: var glib.GError): cuint {.
    importc: "gtk_builder_extend_with_template", libgtk.}

template typeBuildable*(): expr =
  (buildableGetType())

template buildable*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeBuildable, BuildableObj))

template buildableClass*(obj: expr): expr =
  (gTypeCheckClassCast(obj, typeBuildable, BuildableIfaceObj))

template isBuildable*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeBuildable))

template buildableGetIface*(obj: expr): expr =
  (gTypeInstanceGetInterface(obj, typeBuildable, BuildableIfaceObj))

type
  Button* =  ptr ButtonObj
  ButtonPtr* = ptr ButtonObj
  ButtonObj* = object of BinObj
    priv48: pointer

  ButtonClass* =  ptr ButtonClassObj
  ButtonClassPtr* = ptr ButtonClassObj
  ButtonClassObj* = object of BinClassObj
    pressed*: proc (button: Button) {.cdecl.}
    released*: proc (button: Button) {.cdecl.}
    clicked*: proc (button: Button) {.cdecl.}
    enter*: proc (button: Button) {.cdecl.}
    leave*: proc (button: Button) {.cdecl.}
    activate*: proc (button: Button) {.cdecl.}
    gtkReserved361*: proc () {.cdecl.}
    gtkReserved362*: proc () {.cdecl.}
    gtkReserved363*: proc () {.cdecl.}
    gtkReserved364*: proc () {.cdecl.}

proc buildableGetType*(): GType {.importc: "gtk_buildable_get_type", libgtk.}
proc setName*(buildable: Buildable; name: cstring) {.
    importc: "gtk_buildable_set_name", libgtk.}
proc `name=`*(buildable: Buildable; name: cstring) {.
    importc: "gtk_buildable_set_name", libgtk.}
proc getName*(buildable: Buildable): cstring {.
    importc: "gtk_buildable_get_name", libgtk.}
proc name*(buildable: Buildable): cstring {.
    importc: "gtk_buildable_get_name", libgtk.}
proc addChild*(buildable: Buildable; builder: Builder;
                          child: GObject; `type`: cstring) {.
    importc: "gtk_buildable_add_child", libgtk.}
proc setBuildableProperty*(buildable: Buildable;
                                      builder: Builder; name: cstring;
                                      value: gobject.GValue) {.
    importc: "gtk_buildable_set_buildable_property", libgtk.}
proc `buildableProperty=`*(buildable: Buildable;
                                      builder: Builder; name: cstring;
                                      value: gobject.GValue) {.
    importc: "gtk_buildable_set_buildable_property", libgtk.}
proc constructChild*(buildable: Buildable;
                                builder: Builder; name: cstring): GObject {.
    importc: "gtk_buildable_construct_child", libgtk.}
proc customTagStart*(buildable: Buildable;
                                builder: Builder; child: GObject;
                                tagname: cstring; parser: glib.GMarkupParser;
                                data: var Gpointer): Gboolean {.
    importc: "gtk_buildable_custom_tag_start", libgtk.}
proc customTagEnd*(buildable: Buildable; builder: Builder;
                              child: GObject; tagname: cstring;
                              data: var Gpointer) {.
    importc: "gtk_buildable_custom_tag_end", libgtk.}
proc customFinished*(buildable: Buildable;
                                builder: Builder; child: GObject;
                                tagname: cstring; data: Gpointer) {.
    importc: "gtk_buildable_custom_finished", libgtk.}
proc parserFinished*(buildable: Buildable;
                                builder: Builder) {.
    importc: "gtk_buildable_parser_finished", libgtk.}
proc getInternalChild*(buildable: Buildable;
                                  builder: Builder; childname: cstring): GObject {.
    importc: "gtk_buildable_get_internal_child", libgtk.}
proc internalChild*(buildable: Buildable;
                                  builder: Builder; childname: cstring): GObject {.
    importc: "gtk_buildable_get_internal_child", libgtk.}

template typeButton*(): expr =
  (buttonGetType())

template button*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeButton, ButtonObj))

template buttonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeButton, ButtonClassObj))

template isButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeButton))

template isButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeButton))

template buttonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeButton, ButtonClassObj))

type
  Calendar* =  ptr CalendarObj
  CalendarPtr* = ptr CalendarObj
  CalendarObj*{.final.} = object of WidgetObj
    priv49: pointer

  CalendarClass* =  ptr CalendarClassObj
  CalendarClassPtr* = ptr CalendarClassObj
  CalendarClassObj*{.final.} = object of WidgetClassObj
    monthChanged*: proc (calendar: Calendar) {.cdecl.}
    daySelected*: proc (calendar: Calendar) {.cdecl.}
    daySelectedDoubleClick*: proc (calendar: Calendar) {.cdecl.}
    prevMonth*: proc (calendar: Calendar) {.cdecl.}
    nextMonth*: proc (calendar: Calendar) {.cdecl.}
    prevYear*: proc (calendar: Calendar) {.cdecl.}
    nextYear*: proc (calendar: Calendar) {.cdecl.}
    gtkReserved371*: proc () {.cdecl.}
    gtkReserved372*: proc () {.cdecl.}
    gtkReserved373*: proc () {.cdecl.}
    gtkReserved374*: proc () {.cdecl.}

proc buttonGetType*(): GType {.importc: "gtk_button_get_type", libgtk.}
proc newButton*(): Button {.importc: "gtk_button_new", libgtk.}
proc clicked*(button: Button) {.importc: "gtk_button_clicked",
    libgtk.}
proc pressed*(button: Button) {.importc: "gtk_button_pressed",
    libgtk.}
proc released*(button: Button) {.importc: "gtk_button_released",
    libgtk.}
proc enter*(button: Button) {.importc: "gtk_button_enter", libgtk.}
proc leave*(button: Button) {.importc: "gtk_button_leave", libgtk.}
proc setRelief*(button: Button; relief: ReliefStyle) {.
    importc: "gtk_button_set_relief", libgtk.}
proc `relief=`*(button: Button; relief: ReliefStyle) {.
    importc: "gtk_button_set_relief", libgtk.}
proc getRelief*(button: Button): ReliefStyle {.
    importc: "gtk_button_get_relief", libgtk.}
proc relief*(button: Button): ReliefStyle {.
    importc: "gtk_button_get_relief", libgtk.}
proc setLabel*(button: Button; label: cstring) {.
    importc: "gtk_button_set_label", libgtk.}
proc `label=`*(button: Button; label: cstring) {.
    importc: "gtk_button_set_label", libgtk.}
proc getLabel*(button: Button): cstring {.
    importc: "gtk_button_get_label", libgtk.}
proc label*(button: Button): cstring {.
    importc: "gtk_button_get_label", libgtk.}
proc setUseUnderline*(button: Button; useUnderline: Gboolean) {.
    importc: "gtk_button_set_use_underline", libgtk.}
proc `useUnderline=`*(button: Button; useUnderline: Gboolean) {.
    importc: "gtk_button_set_use_underline", libgtk.}
proc getUseUnderline*(button: Button): Gboolean {.
    importc: "gtk_button_get_use_underline", libgtk.}
proc useUnderline*(button: Button): Gboolean {.
    importc: "gtk_button_get_use_underline", libgtk.}
proc setUseStock*(button: Button; useStock: Gboolean) {.
    importc: "gtk_button_set_use_stock", libgtk.}
proc `useStock=`*(button: Button; useStock: Gboolean) {.
    importc: "gtk_button_set_use_stock", libgtk.}
proc getUseStock*(button: Button): Gboolean {.
    importc: "gtk_button_get_use_stock", libgtk.}
proc useStock*(button: Button): Gboolean {.
    importc: "gtk_button_get_use_stock", libgtk.}
proc setFocusOnClick*(button: Button; focusOnClick: Gboolean) {.
    importc: "gtk_button_set_focus_on_click", libgtk.}
proc `focusOnClick=`*(button: Button; focusOnClick: Gboolean) {.
    importc: "gtk_button_set_focus_on_click", libgtk.}
proc getFocusOnClick*(button: Button): Gboolean {.
    importc: "gtk_button_get_focus_on_click", libgtk.}
proc focusOnClick*(button: Button): Gboolean {.
    importc: "gtk_button_get_focus_on_click", libgtk.}
proc setAlignment*(button: Button; xalign: cfloat; yalign: cfloat) {.
    importc: "gtk_button_set_alignment", libgtk.}
proc `alignment=`*(button: Button; xalign: cfloat; yalign: cfloat) {.
    importc: "gtk_button_set_alignment", libgtk.}
proc getAlignment*(button: Button; xalign: var cfloat;
                           yalign: var cfloat) {.
    importc: "gtk_button_get_alignment", libgtk.}
proc setImage*(button: Button; image: Widget) {.
    importc: "gtk_button_set_image", libgtk.}
proc `image=`*(button: Button; image: Widget) {.
    importc: "gtk_button_set_image", libgtk.}
proc setImagePosition*(button: Button; position: PositionType) {.
    importc: "gtk_button_set_image_position", libgtk.}
proc `imagePosition=`*(button: Button; position: PositionType) {.
    importc: "gtk_button_set_image_position", libgtk.}
proc getImagePosition*(button: Button): PositionType {.
    importc: "gtk_button_get_image_position", libgtk.}
proc imagePosition*(button: Button): PositionType {.
    importc: "gtk_button_get_image_position", libgtk.}
proc setAlwaysShowImage*(button: Button; alwaysShow: Gboolean) {.
    importc: "gtk_button_set_always_show_image", libgtk.}
proc `alwaysShowImage=`*(button: Button; alwaysShow: Gboolean) {.
    importc: "gtk_button_set_always_show_image", libgtk.}
proc getAlwaysShowImage*(button: Button): Gboolean {.
    importc: "gtk_button_get_always_show_image", libgtk.}
proc alwaysShowImage*(button: Button): Gboolean {.
    importc: "gtk_button_get_always_show_image", libgtk.}
proc getEventWindow*(button: Button): gdk3.Window {.
    importc: "gtk_button_get_event_window", libgtk.}
proc eventWindow*(button: Button): gdk3.Window {.
    importc: "gtk_button_get_event_window", libgtk.}

template typeCalendar*(): expr =
  (calendarGetType())

template calendar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCalendar, CalendarObj))

template calendarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCalendar, CalendarClassObj))

template isCalendar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCalendar))

template isCalendarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCalendar))

template calendarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCalendar, CalendarClassObj))

type
  CalendarDisplayOptions* {.size: sizeof(cint), pure.} = enum
    SHOW_HEADING = 1 shl 0, SHOW_DAY_NAMES = 1 shl 1,
    NO_MONTH_CHANGE = 1 shl 2, SHOW_WEEK_NUMBERS = 1 shl 3,
    SHOW_DETAILS = 1 shl 5

type
  CalendarDetailFunc* = proc (calendar: Calendar; year: cuint; month: cuint;
                              day: cuint; userData: Gpointer): cstring {.cdecl.}
  CellAreaBox* =  ptr CellAreaBoxObj
  CellAreaBoxPtr* = ptr CellAreaBoxObj
  CellAreaBoxObj*{.final.} = object of CellAreaObj
    priv50: pointer

  CellAreaBoxClass* =  ptr CellAreaBoxClassObj
  CellAreaBoxClassPtr* = ptr CellAreaBoxClassObj
  CellAreaBoxClassObj*{.final.} = object of CellAreaClassObj
    gtkReserved381*: proc () {.cdecl.}
    gtkReserved382*: proc () {.cdecl.}
    gtkReserved383*: proc () {.cdecl.}
    gtkReserved384*: proc () {.cdecl.}

proc calendarGetType*(): GType {.importc: "gtk_calendar_get_type", libgtk.}
proc newCalendar*(): Calendar {.importc: "gtk_calendar_new", libgtk.}
proc selectMonth*(calendar: Calendar; month: cuint; year: cuint) {.
    importc: "gtk_calendar_select_month", libgtk.}
proc selectDay*(calendar: Calendar; day: cuint) {.
    importc: "gtk_calendar_select_day", libgtk.}
proc markDay*(calendar: Calendar; day: cuint) {.
    importc: "gtk_calendar_mark_day", libgtk.}
proc unmarkDay*(calendar: Calendar; day: cuint) {.
    importc: "gtk_calendar_unmark_day", libgtk.}
proc clearMarks*(calendar: Calendar) {.
    importc: "gtk_calendar_clear_marks", libgtk.}
proc setDisplayOptions*(calendar: Calendar;
                                  flags: CalendarDisplayOptions) {.
    importc: "gtk_calendar_set_display_options", libgtk.}
proc `displayOptions=`*(calendar: Calendar;
                                  flags: CalendarDisplayOptions) {.
    importc: "gtk_calendar_set_display_options", libgtk.}
proc getDisplayOptions*(calendar: Calendar): CalendarDisplayOptions {.
    importc: "gtk_calendar_get_display_options", libgtk.}
proc displayOptions*(calendar: Calendar): CalendarDisplayOptions {.
    importc: "gtk_calendar_get_display_options", libgtk.}
proc getDate*(calendar: Calendar; year: var cuint; month: var cuint;
                        day: var cuint) {.importc: "gtk_calendar_get_date",
                                       libgtk.}
proc setDetailFunc*(calendar: Calendar;
                              `func`: CalendarDetailFunc; data: Gpointer;
                              destroy: GDestroyNotify) {.
    importc: "gtk_calendar_set_detail_func", libgtk.}
proc `detailFunc=`*(calendar: Calendar;
                              `func`: CalendarDetailFunc; data: Gpointer;
                              destroy: GDestroyNotify) {.
    importc: "gtk_calendar_set_detail_func", libgtk.}
proc setDetailWidthChars*(calendar: Calendar; chars: cint) {.
    importc: "gtk_calendar_set_detail_width_chars", libgtk.}
proc `detailWidthChars=`*(calendar: Calendar; chars: cint) {.
    importc: "gtk_calendar_set_detail_width_chars", libgtk.}
proc setDetailHeightRows*(calendar: Calendar; rows: cint) {.
    importc: "gtk_calendar_set_detail_height_rows", libgtk.}
proc `detailHeightRows=`*(calendar: Calendar; rows: cint) {.
    importc: "gtk_calendar_set_detail_height_rows", libgtk.}
proc getDetailWidthChars*(calendar: Calendar): cint {.
    importc: "gtk_calendar_get_detail_width_chars", libgtk.}
proc detailWidthChars*(calendar: Calendar): cint {.
    importc: "gtk_calendar_get_detail_width_chars", libgtk.}
proc getDetailHeightRows*(calendar: Calendar): cint {.
    importc: "gtk_calendar_get_detail_height_rows", libgtk.}
proc detailHeightRows*(calendar: Calendar): cint {.
    importc: "gtk_calendar_get_detail_height_rows", libgtk.}
proc getDayIsMarked*(calendar: Calendar; day: cuint): Gboolean {.
    importc: "gtk_calendar_get_day_is_marked", libgtk.}
proc dayIsMarked*(calendar: Calendar; day: cuint): Gboolean {.
    importc: "gtk_calendar_get_day_is_marked", libgtk.}

template typeCellAreaBox*(): expr =
  (cellAreaBoxGetType())

template cellAreaBox*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellAreaBox, CellAreaBoxObj))

template cellAreaBoxClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellAreaBox, CellAreaBoxClassObj))

template isCellAreaBox*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellAreaBox))

template isCellAreaBoxClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellAreaBox))

template cellAreaBoxGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellAreaBox, CellAreaBoxClassObj))

type
  CellAreaContextClass* =  ptr CellAreaContextClassObj
  CellAreaContextClassPtr* = ptr CellAreaContextClassObj
  CellAreaContextClassObj*{.final.} = object of GObjectClassObj
    allocate*: proc (context: CellAreaContext; width: cint; height: cint) {.cdecl.}
    reset*: proc (context: CellAreaContext) {.cdecl.}
    getPreferredHeightForWidth*: proc (context: CellAreaContext; width: cint;
                                     minimumHeight: var cint;
                                     naturalHeight: var cint) {.cdecl.}
    getPreferredWidthForHeight*: proc (context: CellAreaContext; height: cint;
                                     minimumWidth: var cint; naturalWidth: var cint) {.cdecl.}
    gtkReserved391*: proc () {.cdecl.}
    gtkReserved392*: proc () {.cdecl.}
    gtkReserved393*: proc () {.cdecl.}
    gtkReserved394*: proc () {.cdecl.}
    gtkReserved395*: proc () {.cdecl.}
    gtkReserved396*: proc () {.cdecl.}

proc cellAreaBoxGetType*(): GType {.importc: "gtk_cell_area_box_get_type",
                                    libgtk.}
proc newCellAreaBox*(): CellArea {.importc: "gtk_cell_area_box_new",
    libgtk.}
proc packStart*(box: CellAreaBox;
                             renderer: CellRenderer; expand: Gboolean;
                             align: Gboolean; fixed: Gboolean) {.
    importc: "gtk_cell_area_box_pack_start", libgtk.}
proc packEnd*(box: CellAreaBox; renderer: CellRenderer;
                           expand: Gboolean; align: Gboolean; fixed: Gboolean) {.
    importc: "gtk_cell_area_box_pack_end", libgtk.}
proc getSpacing*(box: CellAreaBox): cint {.
    importc: "gtk_cell_area_box_get_spacing", libgtk.}
proc spacing*(box: CellAreaBox): cint {.
    importc: "gtk_cell_area_box_get_spacing", libgtk.}
proc setSpacing*(box: CellAreaBox; spacing: cint) {.
    importc: "gtk_cell_area_box_set_spacing", libgtk.}
proc `spacing=`*(box: CellAreaBox; spacing: cint) {.
    importc: "gtk_cell_area_box_set_spacing", libgtk.}

discard """ proc "groupVisible*(box: CellAreaBox; groupIdx: cint): Gboolean {.
    importc: "_gtk_cell_area_box_group_visible", libgtk.}"""

template typeCellAreaContext*(): expr =
  (cellAreaContextGetType())

template cellAreaContext*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellAreaContext, CellAreaContextObj))

template cellAreaContextClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellAreaContext, CellAreaContextClassObj))

template isCellAreaContext*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellAreaContext))

template isCellAreaContextClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellAreaContext))

template cellAreaContextGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellAreaContext, CellAreaContextClassObj))

type
  CellLayout* =  ptr CellLayoutObj
  CellLayoutPtr* = ptr CellLayoutObj
  CellLayoutObj* = object
type
  CellLayoutDataFunc* = proc (cellLayout: CellLayout;
                              cell: CellRenderer;
                              treeModel: TreeModel; iter: TreeIter;
                              data: Gpointer) {.cdecl.}

type
  CellLayoutIface* =  ptr CellLayoutIfaceObj
  CellLayoutIfacePtr* = ptr CellLayoutIfaceObj
  CellLayoutIfaceObj* = object of gobject.GTypeInterfaceObj
    packStart*: proc (cellLayout: CellLayout; cell: CellRenderer;
                    expand: Gboolean) {.cdecl.}
    packEnd*: proc (cellLayout: CellLayout; cell: CellRenderer;
                  expand: Gboolean) {.cdecl.}
    clear*: proc (cellLayout: CellLayout) {.cdecl.}
    addAttribute*: proc (cellLayout: CellLayout; cell: CellRenderer;
                       attribute: cstring; column: cint) {.cdecl.}
    setCellDataFunc*: proc (cellLayout: CellLayout; cell: CellRenderer;
                          `func`: CellLayoutDataFunc; funcData: Gpointer;
                          destroy: GDestroyNotify) {.cdecl.}
    clearAttributes*: proc (cellLayout: CellLayout; cell: CellRenderer) {.cdecl.}
    reorder*: proc (cellLayout: CellLayout; cell: CellRenderer;
                  position: cint) {.cdecl.}
    getCells*: proc (cellLayout: CellLayout): glib.GList {.cdecl.}
    getArea*: proc (cellLayout: CellLayout): CellArea {.cdecl.}

proc cellAreaContextGetType*(): GType {.importc: "gtk_cell_area_context_get_type",
                                        libgtk.}

proc getArea*(context: CellAreaContext): CellArea {.
    importc: "gtk_cell_area_context_get_area", libgtk.}

proc area*(context: CellAreaContext): CellArea {.
    importc: "gtk_cell_area_context_get_area", libgtk.}
proc allocate*(context: CellAreaContext; width: cint;
                                height: cint) {.
    importc: "gtk_cell_area_context_allocate", libgtk.}
proc reset*(context: CellAreaContext) {.
    importc: "gtk_cell_area_context_reset", libgtk.}

proc getPreferredWidth*(context: CellAreaContext;
    minimumWidth: var cint; naturalWidth: var cint) {.
    importc: "gtk_cell_area_context_get_preferred_width", libgtk.}
proc getPreferredHeight*(context: CellAreaContext;
    minimumHeight: var cint; naturalHeight: var cint) {.
    importc: "gtk_cell_area_context_get_preferred_height", libgtk.}
proc getPreferredHeightForWidth*(
    context: CellAreaContext; width: cint; minimumHeight: var cint;
    naturalHeight: var cint) {.importc: "gtk_cell_area_context_get_preferred_height_for_width",
                            libgtk.}
proc getPreferredWidthForHeight*(
    context: CellAreaContext; height: cint; minimumWidth: var cint;
    naturalWidth: var cint) {.importc: "gtk_cell_area_context_get_preferred_width_for_height",
                           libgtk.}
proc getAllocation*(context: CellAreaContext;
                                     width: var cint; height: var cint) {.
    importc: "gtk_cell_area_context_get_allocation", libgtk.}

proc pushPreferredWidth*(context: CellAreaContext;
    minimumWidth: cint; naturalWidth: cint) {.
    importc: "gtk_cell_area_context_push_preferred_width", libgtk.}
proc pushPreferredHeight*(context: CellAreaContext;
    minimumHeight: cint; naturalHeight: cint) {.
    importc: "gtk_cell_area_context_push_preferred_height", libgtk.}

template typeCellLayout*(): expr =
  (cellLayoutGetType())

template cellLayout*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellLayout, CellLayoutObj))

template isCellLayout*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellLayout))

template cellLayoutGetIface*(obj: expr): expr =
  (gTypeInstanceGetInterface(obj, typeCellLayout, CellLayoutIfaceObj))

type
  CellRendererText* =  ptr CellRendererTextObj
  CellRendererTextPtr* = ptr CellRendererTextObj
  CellRendererTextObj = object of CellRendererObj
    priv51: pointer

  CellRendererTextClass* =  ptr CellRendererTextClassObj
  CellRendererTextClassPtr* = ptr CellRendererTextClassObj
  CellRendererTextClassObj = object of CellRendererClassObj
    edited*: proc (cellRendererText: CellRendererText; path: cstring;
                 newText: cstring) {.cdecl.}
    gtkReserved401*: proc () {.cdecl.}
    gtkReserved402*: proc () {.cdecl.}
    gtkReserved403*: proc () {.cdecl.}
    gtkReserved404*: proc () {.cdecl.}

proc cellLayoutGetType*(): GType {.importc: "gtk_cell_layout_get_type",
                                   libgtk.}
proc packStart*(cellLayout: CellLayout;
                            cell: CellRenderer; expand: Gboolean) {.
    importc: "gtk_cell_layout_pack_start", libgtk.}
proc packEnd*(cellLayout: CellLayout; cell: CellRenderer;
                          expand: Gboolean) {.importc: "gtk_cell_layout_pack_end",
    libgtk.}
proc getCells*(cellLayout: CellLayout): glib.GList {.
    importc: "gtk_cell_layout_get_cells", libgtk.}
proc cells*(cellLayout: CellLayout): glib.GList {.
    importc: "gtk_cell_layout_get_cells", libgtk.}
proc clear*(cellLayout: CellLayout) {.
    importc: "gtk_cell_layout_clear", libgtk.}
proc setAttributes*(cellLayout: CellLayout;
                                cell: CellRenderer) {.varargs,
    importc: "gtk_cell_layout_set_attributes", libgtk.}
proc `attributes=`*(cellLayout: CellLayout;
                                cell: CellRenderer) {.varargs,
    importc: "gtk_cell_layout_set_attributes", libgtk.}
proc addAttribute*(cellLayout: CellLayout;
                               cell: CellRenderer; attribute: cstring;
                               column: cint) {.
    importc: "gtk_cell_layout_add_attribute", libgtk.}
proc setCellDataFunc*(cellLayout: CellLayout;
                                  cell: CellRenderer;
                                  `func`: CellLayoutDataFunc;
                                  funcData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_cell_layout_set_cell_data_func", libgtk.}
proc `cellDataFunc=`*(cellLayout: CellLayout;
                                  cell: CellRenderer;
                                  `func`: CellLayoutDataFunc;
                                  funcData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_cell_layout_set_cell_data_func", libgtk.}
proc clearAttributes*(cellLayout: CellLayout;
                                  cell: CellRenderer) {.
    importc: "gtk_cell_layout_clear_attributes", libgtk.}
proc reorder*(cellLayout: CellLayout; cell: CellRenderer;
                          position: cint) {.importc: "gtk_cell_layout_reorder",
    libgtk.}
proc getArea*(cellLayout: CellLayout): CellArea {.
    importc: "gtk_cell_layout_get_area", libgtk.}
proc area*(cellLayout: CellLayout): CellArea {.
    importc: "gtk_cell_layout_get_area", libgtk.}

discard """ proc "cellLayoutBuildableCustomTagStart*(buildable: Buildable;
    builder: Builder; child: GObject; tagname: cstring;
    parser: glib.GMarkupParser; data: ptr Gpointer): Gboolean {.
    importc: "_gtk_cell_layout_buildable_custom_tag_start", libgtk.}"""

discard """ proc "cellLayoutBuildableCustomTagEnd*(buildable: Buildable;
                                        builder: Builder;
                                        child: GObject; tagname: cstring;
                                        data: ptr Gpointer): Gboolean {.
    importc: "_gtk_cell_layout_buildable_custom_tag_end", libgtk.}"""

discard """ proc "cellLayoutBuildableAddChild*(buildable: Buildable;
                                    builder: Builder; child: GObject;
                                    `type`: cstring) {.
    importc: "_gtk_cell_layout_buildable_add_child", libgtk.}"""

template typeCellRendererText*(): expr =
  (cellRendererTextGetType())

template cellRendererText*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellRendererText, CellRendererTextObj))

template cellRendererTextClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellRendererText, CellRendererTextClassObj))

template isCellRendererText*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellRendererText))

template isCellRendererTextClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellRendererText))

template cellRendererTextGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellRendererText, CellRendererTextClassObj))

type
  CellRendererAccel* =  ptr CellRendererAccelObj
  CellRendererAccelPtr* = ptr CellRendererAccelObj
  CellRendererAccelObj*{.final.} = object of CellRendererTextObj
    priv52: pointer

  CellRendererAccelClass* =  ptr CellRendererAccelClassObj
  CellRendererAccelClassPtr* = ptr CellRendererAccelClassObj
  CellRendererAccelClassObj*{.final.} = object of CellRendererTextClassObj
    accelEdited*: proc (accel: CellRendererAccel; pathString: cstring;
                      accelKey: cuint; accelMods: gdk3.ModifierType;
                      hardwareKeycode: cuint) {.cdecl.}
    accelCleared*: proc (accel: CellRendererAccel; pathString: cstring) {.cdecl.}
    gtkReserved410*: proc () {.cdecl.}
    gtkReserved411*: proc () {.cdecl.}
    gtkReserved412*: proc () {.cdecl.}
    gtkReserved413*: proc () {.cdecl.}
    gtkReserved414*: proc () {.cdecl.}

proc cellRendererTextGetType*(): GType {.
    importc: "gtk_cell_renderer_text_get_type", libgtk.}
proc newCellRendererText*(): CellRenderer {.
    importc: "gtk_cell_renderer_text_new", libgtk.}
proc setFixedHeightFromFont*(
    renderer: CellRendererText; numberOfRows: cint) {.
    importc: "gtk_cell_renderer_text_set_fixed_height_from_font", libgtk.}
proc `fixedHeightFromFont=`*(
    renderer: CellRendererText; numberOfRows: cint) {.
    importc: "gtk_cell_renderer_text_set_fixed_height_from_font", libgtk.}

template typeCellRendererAccel*(): expr =
  (cellRendererAccelGetType())

template cellRendererAccel*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellRendererAccel, CellRendererAccelObj))

template cellRendererAccelClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellRendererAccel, CellRendererAccelClassObj))

template isCellRendererAccel*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellRendererAccel))

template isCellRendererAccelClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellRendererAccel))

template cellRendererAccelGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellRendererAccel, CellRendererAccelClassObj))

type
  CellRendererAccelMode* {.size: sizeof(cint), pure.} = enum
    MODE_GTK, MODE_OTHER

type
  CellRendererCombo* =  ptr CellRendererComboObj
  CellRendererComboPtr* = ptr CellRendererComboObj
  CellRendererComboObj*{.final.} = object of CellRendererTextObj
    priv53: pointer

  CellRendererComboClass* =  ptr CellRendererComboClassObj
  CellRendererComboClassPtr* = ptr CellRendererComboClassObj
  CellRendererComboClassObj*{.final.} = object of CellRendererTextClassObj
    gtkReserved421*: proc () {.cdecl.}
    gtkReserved422*: proc () {.cdecl.}
    gtkReserved423*: proc () {.cdecl.}
    gtkReserved424*: proc () {.cdecl.}

proc cellRendererAccelGetType*(): GType {.
    importc: "gtk_cell_renderer_accel_get_type", libgtk.}
proc newCellRendererAccel*(): CellRenderer {.
    importc: "gtk_cell_renderer_accel_new", libgtk.}

template typeCellRendererCombo*(): expr =
  (cellRendererComboGetType())

template cellRendererCombo*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellRendererCombo, CellRendererComboObj))

template cellRendererComboClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellRendererCombo, CellRendererComboClassObj))

template isCellRendererCombo*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellRendererCombo))

template isCellRendererComboClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellRendererCombo))

template cellRendererComboGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellRendererCombo, CellRendererTextClassObj))

type
  CellRendererPixbuf* =  ptr CellRendererPixbufObj
  CellRendererPixbufPtr* = ptr CellRendererPixbufObj
  CellRendererPixbufObj*{.final.} = object of CellRendererObj
    priv54: pointer

  CellRendererPixbufClass* =  ptr CellRendererPixbufClassObj
  CellRendererPixbufClassPtr* = ptr CellRendererPixbufClassObj
  CellRendererPixbufClassObj*{.final.} = object of CellRendererClassObj
    gtkReserved431*: proc () {.cdecl.}
    gtkReserved432*: proc () {.cdecl.}
    gtkReserved433*: proc () {.cdecl.}
    gtkReserved434*: proc () {.cdecl.}

proc cellRendererComboGetType*(): GType {.
    importc: "gtk_cell_renderer_combo_get_type", libgtk.}
proc newCellRendererCombo*(): CellRenderer {.
    importc: "gtk_cell_renderer_combo_new", libgtk.}

template typeCellRendererPixbuf*(): expr =
  (cellRendererPixbufGetType())

template cellRendererPixbuf*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellRendererPixbuf, CellRendererPixbufObj))

template cellRendererPixbufClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellRendererPixbuf, CellRendererPixbufClassObj))

template isCellRendererPixbuf*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellRendererPixbuf))

template isCellRendererPixbufClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellRendererPixbuf))

template cellRendererPixbufGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellRendererPixbuf, CellRendererPixbufClassObj))

type
  CellRendererProgress* =  ptr CellRendererProgressObj
  CellRendererProgressPtr* = ptr CellRendererProgressObj
  CellRendererProgressObj*{.final.} = object of CellRendererObj
    priv55: pointer

  CellRendererProgressClass* =  ptr CellRendererProgressClassObj
  CellRendererProgressClassPtr* = ptr CellRendererProgressClassObj
  CellRendererProgressClassObj*{.final.} = object of CellRendererClassObj
    gtkReserved441*: proc () {.cdecl.}
    gtkReserved442*: proc () {.cdecl.}
    gtkReserved443*: proc () {.cdecl.}
    gtkReserved444*: proc () {.cdecl.}

proc cellRendererPixbufGetType*(): GType {.
    importc: "gtk_cell_renderer_pixbuf_get_type", libgtk.}
proc newCellRendererPixbuf*(): CellRenderer {.
    importc: "gtk_cell_renderer_pixbuf_new", libgtk.}

template typeCellRendererProgress*(): expr =
  (cellRendererProgressGetType())

template cellRendererProgress*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellRendererProgress, CellRendererProgressObj))

template cellRendererProgressClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellRendererProgress, CellRendererProgressClassObj))

template isCellRendererProgress*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellRendererProgress))

template isCellRendererProgressClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellRendererProgress))

template cellRendererProgressGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellRendererProgress, CellRendererProgressClassObj))

type
  CellRendererSpin* =  ptr CellRendererSpinObj
  CellRendererSpinPtr* = ptr CellRendererSpinObj
  CellRendererSpinObj*{.final.} = object of CellRendererTextObj
    priv56: pointer

  CellRendererSpinClass* =  ptr CellRendererSpinClassObj
  CellRendererSpinClassPtr* = ptr CellRendererSpinClassObj
  CellRendererSpinClassObj*{.final.} = object of CellRendererTextClassObj
    gtkReserved451*: proc () {.cdecl.}
    gtkReserved452*: proc () {.cdecl.}
    gtkReserved453*: proc () {.cdecl.}
    gtkReserved454*: proc () {.cdecl.}

proc cellRendererProgressGetType*(): GType {.
    importc: "gtk_cell_renderer_progress_get_type", libgtk.}
proc newCellRendererProgress*(): CellRenderer {.
    importc: "gtk_cell_renderer_progress_new", libgtk.}

template typeCellRendererSpin*(): expr =
  (cellRendererSpinGetType())

template cellRendererSpin*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellRendererSpin, CellRendererSpinObj))

template cellRendererSpinClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellRendererSpin, CellRendererSpinClassObj))

template isCellRendererSpin*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellRendererSpin))

template isCellRendererSpinClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellRendererSpin))

template cellRendererSpinGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellRendererSpin, CellRendererTextClassObj))

type
  CellRendererSpinner* =  ptr CellRendererSpinnerObj
  CellRendererSpinnerPtr* = ptr CellRendererSpinnerObj
  CellRendererSpinnerObj*{.final.} = object of CellRendererObj
    priv57: pointer

  CellRendererSpinnerClass* =  ptr CellRendererSpinnerClassObj
  CellRendererSpinnerClassPtr* = ptr CellRendererSpinnerClassObj
  CellRendererSpinnerClassObj*{.final.} = object of CellRendererClassObj
    gtkReserved461*: proc () {.cdecl.}
    gtkReserved462*: proc () {.cdecl.}
    gtkReserved463*: proc () {.cdecl.}
    gtkReserved464*: proc () {.cdecl.}

proc cellRendererSpinGetType*(): GType {.
    importc: "gtk_cell_renderer_spin_get_type", libgtk.}
proc newCellRendererSpin*(): CellRenderer {.
    importc: "gtk_cell_renderer_spin_new", libgtk.}

template typeCellRendererSpinner*(): expr =
  (cellRendererSpinnerGetType())

template cellRendererSpinner*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellRendererSpinner, CellRendererSpinnerObj))

template cellRendererSpinnerClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellRendererSpinner, CellRendererSpinnerClassObj))

template isCellRendererSpinner*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellRendererSpinner))

template isCellRendererSpinnerClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellRendererSpinner))

template cellRendererSpinnerGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellRendererSpinner, CellRendererSpinnerClassObj))

type
  CellRendererToggle* =  ptr CellRendererToggleObj
  CellRendererTogglePtr* = ptr CellRendererToggleObj
  CellRendererToggleObj*{.final.} = object of CellRendererObj
    priv58: pointer

  CellRendererToggleClass* =  ptr CellRendererToggleClassObj
  CellRendererToggleClassPtr* = ptr CellRendererToggleClassObj
  CellRendererToggleClassObj*{.final.} = object of CellRendererClassObj
    toggled*: proc (cellRendererToggle: CellRendererToggle; path: cstring) {.cdecl.}
    gtkReserved471*: proc () {.cdecl.}
    gtkReserved472*: proc () {.cdecl.}
    gtkReserved473*: proc () {.cdecl.}
    gtkReserved474*: proc () {.cdecl.}

proc cellRendererSpinnerGetType*(): GType {.
    importc: "gtk_cell_renderer_spinner_get_type", libgtk.}
proc newCellRendererSpinner*(): CellRenderer {.
    importc: "gtk_cell_renderer_spinner_new", libgtk.}

template typeCellRendererToggle*(): expr =
  (cellRendererToggleGetType())

template cellRendererToggle*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellRendererToggle, CellRendererToggleObj))

template cellRendererToggleClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCellRendererToggle, CellRendererToggleClassObj))

template isCellRendererToggle*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellRendererToggle))

template isCellRendererToggleClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCellRendererToggle))

template cellRendererToggleGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCellRendererToggle, CellRendererToggleClassObj))

type
  CellView* =  ptr CellViewObj
  CellViewPtr* = ptr CellViewObj
  CellViewObj*{.final.} = object of WidgetObj
    priv59: pointer

  CellViewClass* =  ptr CellViewClassObj
  CellViewClassPtr* = ptr CellViewClassObj
  CellViewClassObj*{.final.} = object of WidgetClassObj
    gtkReserved481*: proc () {.cdecl.}
    gtkReserved482*: proc () {.cdecl.}
    gtkReserved483*: proc () {.cdecl.}
    gtkReserved484*: proc () {.cdecl.}

proc cellRendererToggleGetType*(): GType {.
    importc: "gtk_cell_renderer_toggle_get_type", libgtk.}
proc newCellRendererToggle*(): CellRenderer {.
    importc: "gtk_cell_renderer_toggle_new", libgtk.}
proc getRadio*(toggle: CellRendererToggle): Gboolean {.
    importc: "gtk_cell_renderer_toggle_get_radio", libgtk.}
proc radio*(toggle: CellRendererToggle): Gboolean {.
    importc: "gtk_cell_renderer_toggle_get_radio", libgtk.}
proc setRadio*(toggle: CellRendererToggle;
                                   radio: Gboolean) {.
    importc: "gtk_cell_renderer_toggle_set_radio", libgtk.}
proc `radio=`*(toggle: CellRendererToggle;
                                   radio: Gboolean) {.
    importc: "gtk_cell_renderer_toggle_set_radio", libgtk.}
proc getActive*(toggle: CellRendererToggle): Gboolean {.
    importc: "gtk_cell_renderer_toggle_get_active", libgtk.}
proc active*(toggle: CellRendererToggle): Gboolean {.
    importc: "gtk_cell_renderer_toggle_get_active", libgtk.}
proc setActive*(toggle: CellRendererToggle;
                                    setting: Gboolean) {.
    importc: "gtk_cell_renderer_toggle_set_active", libgtk.}
proc `active=`*(toggle: CellRendererToggle;
                                    setting: Gboolean) {.
    importc: "gtk_cell_renderer_toggle_set_active", libgtk.}
proc getActivatable*(toggle: CellRendererToggle): Gboolean {.
    importc: "gtk_cell_renderer_toggle_get_activatable", libgtk.}
proc activatable*(toggle: CellRendererToggle): Gboolean {.
    importc: "gtk_cell_renderer_toggle_get_activatable", libgtk.}
proc setActivatable*(toggle: CellRendererToggle;
    setting: Gboolean) {.importc: "gtk_cell_renderer_toggle_set_activatable",
                       libgtk.}
proc `activatable=`*(toggle: CellRendererToggle;
    setting: Gboolean) {.importc: "gtk_cell_renderer_toggle_set_activatable",
                       libgtk.}

template typeCellView*(): expr =
  (cellViewGetType())

template cellView*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCellView, CellViewObj))

template cellViewClass*(vtable: expr): expr =
  (gTypeCheckClassCast(vtable, typeCellView, CellViewClassObj))

template isCellView*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCellView))

template isCellViewClass*(vtable: expr): expr =
  (gTypeCheckClassType(vtable, typeCellView))

template cellViewGetClass*(inst: expr): expr =
  (gTypeInstanceGetClass(inst, typeCellView, CellViewClassObj))

type
  ToggleButton* =  ptr ToggleButtonObj
  ToggleButtonPtr* = ptr ToggleButtonObj
  ToggleButtonObj* = object of ButtonObj
    priv60: pointer

  ToggleButtonClass* =  ptr ToggleButtonClassObj
  ToggleButtonClassPtr* = ptr ToggleButtonClassObj
  ToggleButtonClassObj = object of ButtonClassObj
    toggled*: proc (toggleButton: ToggleButton) {.cdecl.}
    gtkReserved491*: proc () {.cdecl.}
    gtkReserved492*: proc () {.cdecl.}
    gtkReserved493*: proc () {.cdecl.}
    gtkReserved494*: proc () {.cdecl.}

proc cellViewGetType*(): GType {.importc: "gtk_cell_view_get_type", libgtk.}
proc newCellView*(): CellView {.importc: "gtk_cell_view_new", libgtk.}
proc newCellView*(pixbuf: GdkPixbuf): Widget {.
    importc: "gtk_cell_view_new_with_pixbuf", libgtk.}
proc setModel*(cellView: CellView; model: TreeModel) {.
    importc: "gtk_cell_view_set_model", libgtk.}
proc `model=`*(cellView: CellView; model: TreeModel) {.
    importc: "gtk_cell_view_set_model", libgtk.}
proc getModel*(cellView: CellView): TreeModel {.
    importc: "gtk_cell_view_get_model", libgtk.}
proc model*(cellView: CellView): TreeModel {.
    importc: "gtk_cell_view_get_model", libgtk.}
proc setDisplayedRow*(cellView: CellView; path: TreePath) {.
    importc: "gtk_cell_view_set_displayed_row", libgtk.}
proc `displayedRow=`*(cellView: CellView; path: TreePath) {.
    importc: "gtk_cell_view_set_displayed_row", libgtk.}
proc getDisplayedRow*(cellView: CellView): TreePath {.
    importc: "gtk_cell_view_get_displayed_row", libgtk.}
proc displayedRow*(cellView: CellView): TreePath {.
    importc: "gtk_cell_view_get_displayed_row", libgtk.}
proc setBackgroundRgba*(cellView: CellView; rgba: gdk3.RGBA) {.
    importc: "gtk_cell_view_set_background_rgba", libgtk.}
proc `backgroundRgba=`*(cellView: CellView; rgba: gdk3.RGBA) {.
    importc: "gtk_cell_view_set_background_rgba", libgtk.}
proc getDrawSensitive*(cellView: CellView): Gboolean {.
    importc: "gtk_cell_view_get_draw_sensitive", libgtk.}
proc drawSensitive*(cellView: CellView): Gboolean {.
    importc: "gtk_cell_view_get_draw_sensitive", libgtk.}
proc setDrawSensitive*(cellView: CellView; drawSensitive: Gboolean) {.
    importc: "gtk_cell_view_set_draw_sensitive", libgtk.}
proc `drawSensitive=`*(cellView: CellView; drawSensitive: Gboolean) {.
    importc: "gtk_cell_view_set_draw_sensitive", libgtk.}
proc getFitModel*(cellView: CellView): Gboolean {.
    importc: "gtk_cell_view_get_fit_model", libgtk.}
proc fitModel*(cellView: CellView): Gboolean {.
    importc: "gtk_cell_view_get_fit_model", libgtk.}
proc setFitModel*(cellView: CellView; fitModel: Gboolean) {.
    importc: "gtk_cell_view_set_fit_model", libgtk.}
proc `fitModel=`*(cellView: CellView; fitModel: Gboolean) {.
    importc: "gtk_cell_view_set_fit_model", libgtk.}
proc getSizeOfRow*(cellView: CellView; path: TreePath;
                             requisition: Requisition): Gboolean {.
    importc: "gtk_cell_view_get_size_of_row", libgtk.}
proc sizeOfRow*(cellView: CellView; path: TreePath;
                             requisition: Requisition): Gboolean {.
    importc: "gtk_cell_view_get_size_of_row", libgtk.}
proc setBackgroundColor*(cellView: CellView; color: gdk3.Color) {.
    importc: "gtk_cell_view_set_background_color", libgtk.}
proc `backgroundColor=`*(cellView: CellView; color: gdk3.Color) {.
    importc: "gtk_cell_view_set_background_color", libgtk.}

template typeToggleButton*(): expr =
  (toggleButtonGetType())

template toggleButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeToggleButton, ToggleButtonObj))

template toggleButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeToggleButton, ToggleButtonClassObj))

template isToggleButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeToggleButton))

template isToggleButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeToggleButton))

template toggleButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeToggleButton, ToggleButtonClassObj))

type
  CheckButton* =  ptr CheckButtonObj
  CheckButtonPtr* = ptr CheckButtonObj
  CheckButtonObj* = object of ToggleButtonObj

  CheckButtonClass* =  ptr CheckButtonClassObj
  CheckButtonClassPtr* = ptr CheckButtonClassObj
  CheckButtonClassObj = object of ToggleButtonClassObj
    drawIndicator*: proc (checkButton: CheckButton; cr: cairo.Context) {.cdecl.}
    gtkReserved501*: proc () {.cdecl.}
    gtkReserved502*: proc () {.cdecl.}
    gtkReserved503*: proc () {.cdecl.}
    gtkReserved504*: proc () {.cdecl.}

proc toggleButtonGetType*(): GType {.importc: "gtk_toggle_button_get_type",
                                     libgtk.}
proc newToggleButton*(): ToggleButton {.importc: "gtk_toggle_button_new",
                                        libgtk.}
proc setMode*(toggleButton: ToggleButton;
                            drawIndicator: Gboolean) {.
    importc: "gtk_toggle_button_set_mode", libgtk.}
proc `mode=`*(toggleButton: ToggleButton;
                            drawIndicator: Gboolean) {.
    importc: "gtk_toggle_button_set_mode", libgtk.}
proc getMode*(toggleButton: ToggleButton): Gboolean {.
    importc: "gtk_toggle_button_get_mode", libgtk.}
proc mode*(toggleButton: ToggleButton): Gboolean {.
    importc: "gtk_toggle_button_get_mode", libgtk.}
proc setActive*(toggleButton: ToggleButton; isActive: Gboolean) {.
    importc: "gtk_toggle_button_set_active", libgtk.}
proc `active=`*(toggleButton: ToggleButton; isActive: Gboolean) {.
    importc: "gtk_toggle_button_set_active", libgtk.}
proc getActive*(toggleButton: ToggleButton): Gboolean {.
    importc: "gtk_toggle_button_get_active", libgtk.}
proc active*(toggleButton: ToggleButton): Gboolean {.
    importc: "gtk_toggle_button_get_active", libgtk.}
proc toggled*(toggleButton: ToggleButton) {.
    importc: "gtk_toggle_button_toggled", libgtk.}
proc setInconsistent*(toggleButton: ToggleButton;
                                    setting: Gboolean) {.
    importc: "gtk_toggle_button_set_inconsistent", libgtk.}
proc `inconsistent=`*(toggleButton: ToggleButton;
                                    setting: Gboolean) {.
    importc: "gtk_toggle_button_set_inconsistent", libgtk.}
proc getInconsistent*(toggleButton: ToggleButton): Gboolean {.
    importc: "gtk_toggle_button_get_inconsistent", libgtk.}
proc inconsistent*(toggleButton: ToggleButton): Gboolean {.
    importc: "gtk_toggle_button_get_inconsistent", libgtk.}

template typeCheckButton*(): expr =
  (checkButtonGetType())

template checkButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCheckButton, CheckButtonObj))

template checkButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCheckButton, CheckButtonClassObj))

template isCheckButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCheckButton))

template isCheckButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCheckButton))

template checkButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCheckButton, CheckButtonClassObj))

type
  MenuItem* =  ptr MenuItemObj
  MenuItemPtr* = ptr MenuItemObj
  MenuItemObj* = object of BinObj
    priv61: pointer

  MenuItemClass* =  ptr MenuItemClassObj
  MenuItemClassPtr* = ptr MenuItemClassObj
  MenuItemClassObj = object of BinClassObj
    hideOnActivate* {.bitsize: 1.}: cuint
    activate*: proc (menuItem: MenuItem) {.cdecl.}
    activateItem*: proc (menuItem: MenuItem) {.cdecl.}
    toggleSizeRequest*: proc (menuItem: MenuItem; requisition: var cint) {.cdecl.}
    toggleSizeAllocate*: proc (menuItem: MenuItem; allocation: cint) {.cdecl.}
    setLabel*: proc (menuItem: MenuItem; label: cstring) {.cdecl.}
    getLabel*: proc (menuItem: MenuItem): cstring {.cdecl.}
    select*: proc (menuItem: MenuItem) {.cdecl.}
    deselect*: proc (menuItem: MenuItem) {.cdecl.}
    gtkReserved511*: proc () {.cdecl.}
    gtkReserved512*: proc () {.cdecl.}
    gtkReserved513*: proc () {.cdecl.}
    gtkReserved514*: proc () {.cdecl.}

proc checkButtonGetType*(): GType {.importc: "gtk_check_button_get_type",
                                    libgtk.}
proc newCheckButton*(): CheckButton {.importc: "gtk_check_button_new",
                                       libgtk.}

discard """ proc "getProps*(checkButton: CheckButton;
                            indicatorSize: ptr cint; indicatorSpacing: ptr cint) {.
    importc: "_gtk_check_button_get_props", libgtk.}"""

template typeMenuItem*(): expr =
  (menuItemGetType())

template menuItem*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeMenuItem, MenuItemObj))

template menuItemClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeMenuItem, MenuItemClassObj))

template isMenuItem*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeMenuItem))

template isMenuItemClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeMenuItem))

template menuItemGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeMenuItem, MenuItemClassObj))

type
  CheckMenuItem* =  ptr CheckMenuItemObj
  CheckMenuItemPtr* = ptr CheckMenuItemObj
  CheckMenuItemObj* = object of MenuItemObj
    priv62: pointer

  CheckMenuItemClass* =  ptr CheckMenuItemClassObj
  CheckMenuItemClassPtr* = ptr CheckMenuItemClassObj
  CheckMenuItemClassObj = object of MenuItemClassObj
    toggled*: proc (checkMenuItem: CheckMenuItem) {.cdecl.}
    drawIndicator*: proc (checkMenuItem: CheckMenuItem; cr: cairo.Context) {.cdecl.}
    gtkReserved521*: proc () {.cdecl.}
    gtkReserved522*: proc () {.cdecl.}
    gtkReserved523*: proc () {.cdecl.}
    gtkReserved524*: proc () {.cdecl.}

proc menuItemGetType*(): GType {.importc: "gtk_menu_item_get_type", libgtk.}
proc newMenuItem*(): MenuItem {.importc: "gtk_menu_item_new", libgtk.}
proc setSubmenu*(menuItem: MenuItem; submenu: Widget) {.
    importc: "gtk_menu_item_set_submenu", libgtk.}
proc `submenu=`*(menuItem: MenuItem; submenu: Widget) {.
    importc: "gtk_menu_item_set_submenu", libgtk.}
proc getSubmenu*(menuItem: MenuItem): Widget {.
    importc: "gtk_menu_item_get_submenu", libgtk.}
proc submenu*(menuItem: MenuItem): Widget {.
    importc: "gtk_menu_item_get_submenu", libgtk.}
proc select*(menuItem: MenuItem) {.
    importc: "gtk_menu_item_select", libgtk.}
proc deselect*(menuItem: MenuItem) {.
    importc: "gtk_menu_item_deselect", libgtk.}
proc activate*(menuItem: MenuItem) {.
    importc: "gtk_menu_item_activate", libgtk.}
proc toggleSizeRequest*(menuItem: MenuItem; requisition: var cint) {.
    importc: "gtk_menu_item_toggle_size_request", libgtk.}
proc toggleSizeAllocate*(menuItem: MenuItem; allocation: cint) {.
    importc: "gtk_menu_item_toggle_size_allocate", libgtk.}
proc setRightJustified*(menuItem: MenuItem;
                                  rightJustified: Gboolean) {.
    importc: "gtk_menu_item_set_right_justified", libgtk.}
proc `rightJustified=`*(menuItem: MenuItem;
                                  rightJustified: Gboolean) {.
    importc: "gtk_menu_item_set_right_justified", libgtk.}
proc getRightJustified*(menuItem: MenuItem): Gboolean {.
    importc: "gtk_menu_item_get_right_justified", libgtk.}
proc rightJustified*(menuItem: MenuItem): Gboolean {.
    importc: "gtk_menu_item_get_right_justified", libgtk.}
proc setAccelPath*(menuItem: MenuItem; accelPath: cstring) {.
    importc: "gtk_menu_item_set_accel_path", libgtk.}
proc `accelPath=`*(menuItem: MenuItem; accelPath: cstring) {.
    importc: "gtk_menu_item_set_accel_path", libgtk.}
proc getAccelPath*(menuItem: MenuItem): cstring {.
    importc: "gtk_menu_item_get_accel_path", libgtk.}
proc accelPath*(menuItem: MenuItem): cstring {.
    importc: "gtk_menu_item_get_accel_path", libgtk.}
proc setLabel*(menuItem: MenuItem; label: cstring) {.
    importc: "gtk_menu_item_set_label", libgtk.}
proc `label=`*(menuItem: MenuItem; label: cstring) {.
    importc: "gtk_menu_item_set_label", libgtk.}
proc getLabel*(menuItem: MenuItem): cstring {.
    importc: "gtk_menu_item_get_label", libgtk.}
proc label*(menuItem: MenuItem): cstring {.
    importc: "gtk_menu_item_get_label", libgtk.}
proc setUseUnderline*(menuItem: MenuItem; setting: Gboolean) {.
    importc: "gtk_menu_item_set_use_underline", libgtk.}
proc `useUnderline=`*(menuItem: MenuItem; setting: Gboolean) {.
    importc: "gtk_menu_item_set_use_underline", libgtk.}
proc getUseUnderline*(menuItem: MenuItem): Gboolean {.
    importc: "gtk_menu_item_get_use_underline", libgtk.}
proc useUnderline*(menuItem: MenuItem): Gboolean {.
    importc: "gtk_menu_item_get_use_underline", libgtk.}
proc setReserveIndicator*(menuItem: MenuItem; reserve: Gboolean) {.
    importc: "gtk_menu_item_set_reserve_indicator", libgtk.}
proc `reserveIndicator=`*(menuItem: MenuItem; reserve: Gboolean) {.
    importc: "gtk_menu_item_set_reserve_indicator", libgtk.}
proc getReserveIndicator*(menuItem: MenuItem): Gboolean {.
    importc: "gtk_menu_item_get_reserve_indicator", libgtk.}
proc reserveIndicator*(menuItem: MenuItem): Gboolean {.
    importc: "gtk_menu_item_get_reserve_indicator", libgtk.}

template typeCheckMenuItem*(): expr =
  (checkMenuItemGetType())

template checkMenuItem*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeCheckMenuItem, CheckMenuItemObj))

template checkMenuItemClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeCheckMenuItem, CheckMenuItemClassObj))

template isCheckMenuItem*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeCheckMenuItem))

template isCheckMenuItemClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeCheckMenuItem))

template checkMenuItemGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeCheckMenuItem, CheckMenuItemClassObj))

proc checkMenuItemGetType*(): GType {.importc: "gtk_check_menu_item_get_type",
                                      libgtk.}
proc newCheckMenuItem*(): CheckMenuItem {.importc: "gtk_check_menu_item_new",
    libgtk.}
proc setActive*(checkMenuItem: CheckMenuItem;
                               isActive: Gboolean) {.
    importc: "gtk_check_menu_item_set_active", libgtk.}
proc `active=`*(checkMenuItem: CheckMenuItem;
                               isActive: Gboolean) {.
    importc: "gtk_check_menu_item_set_active", libgtk.}
proc getActive*(checkMenuItem: CheckMenuItem): Gboolean {.
    importc: "gtk_check_menu_item_get_active", libgtk.}
proc active*(checkMenuItem: CheckMenuItem): Gboolean {.
    importc: "gtk_check_menu_item_get_active", libgtk.}
proc toggled*(checkMenuItem: CheckMenuItem) {.
    importc: "gtk_check_menu_item_toggled", libgtk.}
proc setInconsistent*(checkMenuItem: CheckMenuItem;
                                     setting: Gboolean) {.
    importc: "gtk_check_menu_item_set_inconsistent", libgtk.}
proc `inconsistent=`*(checkMenuItem: CheckMenuItem;
                                     setting: Gboolean) {.
    importc: "gtk_check_menu_item_set_inconsistent", libgtk.}
proc getInconsistent*(checkMenuItem: CheckMenuItem): Gboolean {.
    importc: "gtk_check_menu_item_get_inconsistent", libgtk.}
proc inconsistent*(checkMenuItem: CheckMenuItem): Gboolean {.
    importc: "gtk_check_menu_item_get_inconsistent", libgtk.}
proc setDrawAsRadio*(checkMenuItem: CheckMenuItem;
                                    drawAsRadio: Gboolean) {.
    importc: "gtk_check_menu_item_set_draw_as_radio", libgtk.}
proc `drawAsRadio=`*(checkMenuItem: CheckMenuItem;
                                    drawAsRadio: Gboolean) {.
    importc: "gtk_check_menu_item_set_draw_as_radio", libgtk.}
proc getDrawAsRadio*(checkMenuItem: CheckMenuItem): Gboolean {.
    importc: "gtk_check_menu_item_get_draw_as_radio", libgtk.}
proc drawAsRadio*(checkMenuItem: CheckMenuItem): Gboolean {.
    importc: "gtk_check_menu_item_get_draw_as_radio", libgtk.}

template typeClipboard*(): expr =
  (clipboardGetType())

template clipboard*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeClipboard, ClipboardObj))

template isClipboard*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeClipboard))

type
  ClipboardReceivedFunc* = proc (clipboard: Clipboard;
                                 selectionData: SelectionData;
                                 data: Gpointer) {.cdecl.}

type
  ClipboardTextReceivedFunc* = proc (clipboard: Clipboard; text: cstring;
                                     data: Gpointer) {.cdecl.}

type
  ClipboardRichTextReceivedFunc* = proc (clipboard: Clipboard;
      format: gdk3.Atom; text: var uint8; length: Gsize; data: Gpointer) {.cdecl.}

type
  ClipboardImageReceivedFunc* = proc (clipboard: Clipboard;
                                      pixbuf: GdkPixbuf; data: Gpointer) {.cdecl.}

type
  ClipboardURIReceivedFunc* = proc (clipboard: Clipboard;
                                    uris: cstringArray; data: Gpointer) {.cdecl.}

type
  ClipboardTargetsReceivedFunc* = proc (clipboard: Clipboard;
                                        atoms: ptr gdk3.Atom; nAtoms: cint;
                                        data: Gpointer) {.cdecl.}

type
  ClipboardGetFunc* = proc (clipboard: Clipboard;
                            selectionData: SelectionData; info: cuint;
                            userDataOrOwner: Gpointer) {.cdecl.}

type
  ClipboardClearFunc* = proc (clipboard: Clipboard;
                              userDataOrOwner: Gpointer) {.cdecl.}

proc clipboardGetType*(): GType {.importc: "gtk_clipboard_get_type", libgtk.}
proc clipboardGetForDisplay*(display: gdk3.Display; selection: gdk3.Atom): Clipboard {.
    importc: "gtk_clipboard_get_for_display", libgtk.}
proc clipboardGet*(selection: gdk3.Atom): Clipboard {.
    importc: "gtk_clipboard_get", libgtk.}
proc clipboardGetDefault*(display: gdk3.Display): Clipboard {.
    importc: "gtk_clipboard_get_default", libgtk.}
proc getDisplay*(clipboard: Clipboard): gdk3.Display {.
    importc: "gtk_clipboard_get_display", libgtk.}
proc display*(clipboard: Clipboard): gdk3.Display {.
    importc: "gtk_clipboard_get_display", libgtk.}
proc setWithData*(clipboard: Clipboard;
                             targets: TargetEntry; nTargets: cuint;
                             getFunc: ClipboardGetFunc;
                             clearFunc: ClipboardClearFunc; userData: Gpointer): Gboolean {.
    importc: "gtk_clipboard_set_with_data", libgtk.}
proc setWithOwner*(clipboard: Clipboard;
                              targets: TargetEntry; nTargets: cuint;
                              getFunc: ClipboardGetFunc;
                              clearFunc: ClipboardClearFunc; owner: GObject): Gboolean {.
    importc: "gtk_clipboard_set_with_owner", libgtk.}
proc getOwner*(clipboard: Clipboard): GObject {.
    importc: "gtk_clipboard_get_owner", libgtk.}
proc owner*(clipboard: Clipboard): GObject {.
    importc: "gtk_clipboard_get_owner", libgtk.}
proc clear*(clipboard: Clipboard) {.
    importc: "gtk_clipboard_clear", libgtk.}
proc setText*(clipboard: Clipboard; text: cstring; len: cint) {.
    importc: "gtk_clipboard_set_text", libgtk.}
proc `text=`*(clipboard: Clipboard; text: cstring; len: cint) {.
    importc: "gtk_clipboard_set_text", libgtk.}
proc setImage*(clipboard: Clipboard; pixbuf: GdkPixbuf) {.
    importc: "gtk_clipboard_set_image", libgtk.}
proc `image=`*(clipboard: Clipboard; pixbuf: GdkPixbuf) {.
    importc: "gtk_clipboard_set_image", libgtk.}
proc requestContents*(clipboard: Clipboard; target: gdk3.Atom;
                                 callback: ClipboardReceivedFunc;
                                 userData: Gpointer) {.
    importc: "gtk_clipboard_request_contents", libgtk.}
proc requestText*(clipboard: Clipboard;
                             callback: ClipboardTextReceivedFunc;
                             userData: Gpointer) {.
    importc: "gtk_clipboard_request_text", libgtk.}
proc requestRichText*(clipboard: Clipboard;
                                 buffer: TextBuffer;
                                 callback: ClipboardRichTextReceivedFunc;
                                 userData: Gpointer) {.
    importc: "gtk_clipboard_request_rich_text", libgtk.}
proc requestImage*(clipboard: Clipboard;
                              callback: ClipboardImageReceivedFunc;
                              userData: Gpointer) {.
    importc: "gtk_clipboard_request_image", libgtk.}
proc requestUris*(clipboard: Clipboard;
                             callback: ClipboardURIReceivedFunc;
                             userData: Gpointer) {.
    importc: "gtk_clipboard_request_uris", libgtk.}
proc requestTargets*(clipboard: Clipboard;
                                callback: ClipboardTargetsReceivedFunc;
                                userData: Gpointer) {.
    importc: "gtk_clipboard_request_targets", libgtk.}
proc waitForContents*(clipboard: Clipboard; target: gdk3.Atom): SelectionData {.
    importc: "gtk_clipboard_wait_for_contents", libgtk.}
proc waitForText*(clipboard: Clipboard): cstring {.
    importc: "gtk_clipboard_wait_for_text", libgtk.}
proc waitForRichText*(clipboard: Clipboard;
                                 buffer: TextBuffer; format: ptr gdk3.Atom;
                                 length: ptr Gsize): ptr uint8 {.
    importc: "gtk_clipboard_wait_for_rich_text", libgtk.}
proc waitForImage*(clipboard: Clipboard): GdkPixbuf {.
    importc: "gtk_clipboard_wait_for_image", libgtk.}
proc waitForUris*(clipboard: Clipboard): cstringArray {.
    importc: "gtk_clipboard_wait_for_uris", libgtk.}
proc waitForTargets*(clipboard: Clipboard;
                                targets: ptr ptr gdk3.Atom; nTargets: var cint): Gboolean {.
    importc: "gtk_clipboard_wait_for_targets", libgtk.}
proc waitIsTextAvailable*(clipboard: Clipboard): Gboolean {.
    importc: "gtk_clipboard_wait_is_text_available", libgtk.}
proc waitIsRichTextAvailable*(clipboard: Clipboard;
    buffer: TextBuffer): Gboolean {.importc: "gtk_clipboard_wait_is_rich_text_available",
                                       libgtk.}
proc waitIsImageAvailable*(clipboard: Clipboard): Gboolean {.
    importc: "gtk_clipboard_wait_is_image_available", libgtk.}
proc waitIsUrisAvailable*(clipboard: Clipboard): Gboolean {.
    importc: "gtk_clipboard_wait_is_uris_available", libgtk.}
proc waitIsTargetAvailable*(clipboard: Clipboard; target: gdk3.Atom): Gboolean {.
    importc: "gtk_clipboard_wait_is_target_available", libgtk.}
proc setCanStore*(clipboard: Clipboard;
                             targets: TargetEntry; nTargets: cint) {.
    importc: "gtk_clipboard_set_can_store", libgtk.}
proc `canStore=`*(clipboard: Clipboard;
                             targets: TargetEntry; nTargets: cint) {.
    importc: "gtk_clipboard_set_can_store", libgtk.}
proc store*(clipboard: Clipboard) {.
    importc: "gtk_clipboard_store", libgtk.}

discard """ proc "clipboardHandleEvent*(event: gdk3.EventOwnerChange) {.
    importc: "_gtk_clipboard_handle_event", libgtk.}"""

discard """ proc "clipboardStoreAll*() {.importc: "_gtk_clipboard_store_all", libgtk.}"""

template typeColorButton*(): expr =
  (colorButtonGetType())

template colorButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeColorButton, ColorButtonObj))

template colorButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeColorButton, ColorButtonClassObj))

template isColorButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeColorButton))

template isColorButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeColorButton))

template colorButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeColorButton, ColorButtonClassObj))

type
  ColorButton* =  ptr ColorButtonObj
  ColorButtonPtr* = ptr ColorButtonObj
  ColorButtonObj* = object of ButtonObj
    priv63: pointer

  ColorButtonClass* =  ptr ColorButtonClassObj
  ColorButtonClassPtr* = ptr ColorButtonClassObj
  ColorButtonClassObj*{.final.} = object of ButtonClassObj
    colorSet*: proc (cp: ColorButton) {.cdecl.}
    gtkReserved531*: proc () {.cdecl.}
    gtkReserved532*: proc () {.cdecl.}
    gtkReserved533*: proc () {.cdecl.}
    gtkReserved534*: proc () {.cdecl.}

  ColorChooser* =  ptr ColorChooserObj
  ColorChooserPtr* = ptr ColorChooserObj
  ColorChooserObj* = object

  ColorChooserInterface* =  ptr ColorChooserInterfaceObj
  ColorChooserInterfacePtr* = ptr ColorChooserInterfaceObj
  ColorChooserInterfaceObj* = object of gobject.GTypeInterfaceObj
    getRgba*: proc (chooser: ColorChooser; color: gdk3.RGBA) {.cdecl.}
    setRgba*: proc (chooser: ColorChooser; color: gdk3.RGBA) {.cdecl.}
    addPalette*: proc (chooser: ColorChooser; orientation: Orientation;
                     colorsPerLine: cint; nColors: cint; colors: gdk3.RGBA) {.cdecl.}
    colorActivated*: proc (chooser: ColorChooser; color: gdk3.RGBA) {.cdecl.}
    padding*: array[12, Gpointer]

proc colorButtonGetType*(): GType {.importc: "gtk_color_button_get_type",
                                    libgtk.}
proc newColorButton*(): ColorButton {.importc: "gtk_color_button_new",
                                       libgtk.}
proc setTitle*(button: ColorButton; title: cstring) {.
    importc: "gtk_color_button_set_title", libgtk.}
proc `title=`*(button: ColorButton; title: cstring) {.
    importc: "gtk_color_button_set_title", libgtk.}
proc getTitle*(button: ColorButton): cstring {.
    importc: "gtk_color_button_get_title", libgtk.}
proc title*(button: ColorButton): cstring {.
    importc: "gtk_color_button_get_title", libgtk.}
proc setColor*(button: ColorButton; color: gdk3.Color) {.
    importc: "gtk_color_button_set_color", libgtk.}
proc `color=`*(button: ColorButton; color: gdk3.Color) {.
    importc: "gtk_color_button_set_color", libgtk.}
proc getColor*(button: ColorButton; color: var gdk3.ColorObj) {.
    importc: "gtk_color_button_get_color", libgtk.}
proc setAlpha*(button: ColorButton; alpha: uint16) {.
    importc: "gtk_color_button_set_alpha", libgtk.}
proc `alpha=`*(button: ColorButton; alpha: uint16) {.
    importc: "gtk_color_button_set_alpha", libgtk.}
proc getAlpha*(button: ColorButton): uint16 {.
    importc: "gtk_color_button_get_alpha", libgtk.}
proc alpha*(button: ColorButton): uint16 {.
    importc: "gtk_color_button_get_alpha", libgtk.}
proc setUseAlpha*(button: ColorButton; useAlpha: Gboolean) {.
    importc: "gtk_color_button_set_use_alpha", libgtk.}
proc `useAlpha=`*(button: ColorButton; useAlpha: Gboolean) {.
    importc: "gtk_color_button_set_use_alpha", libgtk.}
proc getUseAlpha*(button: ColorButton): Gboolean {.
    importc: "gtk_color_button_get_use_alpha", libgtk.}
proc useAlpha*(button: ColorButton): Gboolean {.
    importc: "gtk_color_button_get_use_alpha", libgtk.}
proc setRgba*(button: ColorButton; rgba: gdk3.RGBA) {.
    importc: "gtk_color_button_set_rgba", libgtk.}
proc `rgba=`*(button: ColorButton; rgba: gdk3.RGBA) {.
    importc: "gtk_color_button_set_rgba", libgtk.}
proc getRgba*(button: ColorButton; rgba: var gdk3.RGBAObj) {.
    importc: "gtk_color_button_get_rgba", libgtk.}

template typeColorChooser*(): expr =
  (colorChooserGetType())

template colorChooser*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeColorChooser, ColorChooserObj))

template isColorChooser*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeColorChooser))

template colorChooserGetIface*(inst: expr): expr =
  (gTypeInstanceGetInterface(inst, typeColorChooser, ColorChooserInterfaceObj))

type
  ColorChooserDialog* =  ptr ColorChooserDialogObj
  ColorChooserDialogPtr* = ptr ColorChooserDialogObj
  ColorChooserDialogObj*{.final.} = object of DialogObj
    priv64: pointer

  ColorChooserDialogClass* =  ptr ColorChooserDialogClassObj
  ColorChooserDialogClassPtr* = ptr ColorChooserDialogClassObj
  ColorChooserDialogClassObj*{.final.} = object of DialogClassObj
    gtkReserved541*: proc () {.cdecl.}
    gtkReserved542*: proc () {.cdecl.}
    gtkReserved543*: proc () {.cdecl.}
    gtkReserved544*: proc () {.cdecl.}

proc colorChooserGetType*(): GType {.importc: "gtk_color_chooser_get_type",
                                     libgtk.}
proc getRgba*(chooser: ColorChooser; color: var gdk3.RGBAObj) {.
    importc: "gtk_color_chooser_get_rgba", libgtk.}
proc setRgba*(chooser: ColorChooser; color: gdk3.RGBA) {.
    importc: "gtk_color_chooser_set_rgba", libgtk.}
proc `rgba=`*(chooser: ColorChooser; color: gdk3.RGBA) {.
    importc: "gtk_color_chooser_set_rgba", libgtk.}
proc getUseAlpha*(chooser: ColorChooser): Gboolean {.
    importc: "gtk_color_chooser_get_use_alpha", libgtk.}
proc useAlpha*(chooser: ColorChooser): Gboolean {.
    importc: "gtk_color_chooser_get_use_alpha", libgtk.}
proc setUseAlpha*(chooser: ColorChooser; useAlpha: Gboolean) {.
    importc: "gtk_color_chooser_set_use_alpha", libgtk.}
proc `useAlpha=`*(chooser: ColorChooser; useAlpha: Gboolean) {.
    importc: "gtk_color_chooser_set_use_alpha", libgtk.}
proc addPalette*(chooser: ColorChooser;
                               orientation: Orientation; colorsPerLine: cint;
                               nColors: cint; colors: gdk3.RGBA) {.
    importc: "gtk_color_chooser_add_palette", libgtk.}

template typeColorChooserDialog*(): expr =
  (colorChooserDialogGetType())

template colorChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeColorChooserDialog, ColorChooserDialogObj))

template colorChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeColorChooserDialog, ColorChooserDialogClassObj))

template isColorChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeColorChooserDialog))

template isColorChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeColorChooserDialog))

template colorChooserDialogGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeColorChooserDialog, ColorChooserDialogClassObj))

type
  ColorChooserWidget* =  ptr ColorChooserWidgetObj
  ColorChooserWidgetPtr* = ptr ColorChooserWidgetObj
  ColorChooserWidgetObj*{.final.} = object of BoxObj
    priv65: pointer

  ColorChooserWidgetClass* =  ptr ColorChooserWidgetClassObj
  ColorChooserWidgetClassPtr* = ptr ColorChooserWidgetClassObj
  ColorChooserWidgetClassObj*{.final.} = object of BoxClassObj
    gtkReserved551*: proc () {.cdecl.}
    gtkReserved552*: proc () {.cdecl.}
    gtkReserved553*: proc () {.cdecl.}
    gtkReserved554*: proc () {.cdecl.}
    gtkReserved555*: proc () {.cdecl.}
    gtkReserved556*: proc () {.cdecl.}
    gtkReserved557*: proc () {.cdecl.}
    gtkReserved558*: proc () {.cdecl.}

proc colorChooserDialogGetType*(): GType {.
    importc: "gtk_color_chooser_dialog_get_type", libgtk.}
proc newColorChooserDialog*(title: cstring; parent: Window): ColorChooserDialog {.
    importc: "gtk_color_chooser_dialog_new", libgtk.}

template typeColorChooserWidget*(): expr =
  (colorChooserWidgetGetType())

template colorChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeColorChooserWidget, ColorChooserWidgetObj))

template colorChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeColorChooserWidget, ColorChooserWidgetClassObj))

template isColorChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeColorChooserWidget))

template isColorChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeColorChooserWidget))

template colorChooserWidgetGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeColorChooserWidget, ColorChooserWidgetClassObj))

type
  ComboBoxText* =  ptr ComboBoxTextObj
  ComboBoxTextPtr* = ptr ComboBoxTextObj
  ComboBoxTextObj*{.final.} = object of ComboBoxObj
    priv66: pointer

  ComboBoxTextClass* =  ptr ComboBoxTextClassObj
  ComboBoxTextClassPtr* = ptr ComboBoxTextClassObj
  ComboBoxTextClassObj*{.final.} = object of ComboBoxClassObj
    gtkReserved561*: proc () {.cdecl.}
    gtkReserved562*: proc () {.cdecl.}
    gtkReserved563*: proc () {.cdecl.}
    gtkReserved564*: proc () {.cdecl.}

proc colorChooserWidgetGetType*(): GType {.
    importc: "gtk_color_chooser_widget_get_type", libgtk.}
proc newColorChooserWidget*(): ColorChooserWidget {.
    importc: "gtk_color_chooser_widget_new", libgtk.}

proc hsvToRgb*(h: cdouble; s: cdouble; v: cdouble; r: ptr cdouble; g: var cdouble;
                 b: var cdouble) {.importc: "gtk_hsv_to_rgb", libgtk.}
proc rgbToHsv*(r: cdouble; g: cdouble; b: cdouble; h: ptr cdouble; s: var cdouble;
                 v: var cdouble) {.importc: "gtk_rgb_to_hsv", libgtk.}

template typeComboBoxText*(): expr =
  (comboBoxTextGetType())

template comboBoxText*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeComboBoxText, ComboBoxTextObj))

template comboBoxTextClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeComboBoxText, ComboBoxTextClassObj))

template isComboBoxText*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeComboBoxText))

template isComboBoxTextClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeComboBoxText))

template comboBoxTextGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeComboBoxText, ComboBoxTextClassObj))

proc comboBoxTextGetType*(): GType {.importc: "gtk_combo_box_text_get_type",
                                     libgtk.}
proc newComboBoxText*(): ComboBoxText {.importc: "gtk_combo_box_text_new",
                                        libgtk.}
proc appendText*(comboBox: ComboBoxText; text: cstring) {.
    importc: "gtk_combo_box_text_append_text", libgtk.}
proc insertText*(comboBox: ComboBoxText; position: cint;
                               text: cstring) {.
    importc: "gtk_combo_box_text_insert_text", libgtk.}
proc prependText*(comboBox: ComboBoxText; text: cstring) {.
    importc: "gtk_combo_box_text_prepend_text", libgtk.}
proc remove*(comboBox: ComboBoxText; position: cint) {.
    importc: "gtk_combo_box_text_remove", libgtk.}
proc removeAll*(comboBox: ComboBoxText) {.
    importc: "gtk_combo_box_text_remove_all", libgtk.}
proc getActiveText*(comboBox: ComboBoxText): cstring {.
    importc: "gtk_combo_box_text_get_active_text", libgtk.}
proc activeText*(comboBox: ComboBoxText): cstring {.
    importc: "gtk_combo_box_text_get_active_text", libgtk.}
proc insert*(comboBox: ComboBoxText; position: cint;
                           id: cstring; text: cstring) {.
    importc: "gtk_combo_box_text_insert", libgtk.}
proc append*(comboBox: ComboBoxText; id: cstring; text: cstring) {.
    importc: "gtk_combo_box_text_append", libgtk.}
proc prepend*(comboBox: ComboBoxText; id: cstring; text: cstring) {.
    importc: "gtk_combo_box_text_prepend", libgtk.}

template typeCssSection*(): expr =
  (cssSectionGetType())

type
  CssSectionType* {.size: sizeof(cint), pure.} = enum
    DOCUMENT, `IMPORT`,
    COLOR_DEFINITION, BINDING_SET,
    RULESET, SELECTOR,
    DECLARATION, VALUE, KEYFRAMES

type
  CssProvider* =  ptr CssProviderObj
  CssProviderPtr* = ptr CssProviderObj
  CssProviderObj*{.final.} = object of GObjectObj
    priv67: pointer

  CssSection* =  ptr CssSectionObj
  CssSectionPtr* = ptr CssSectionObj
  CssSectionObj* = object

  CssProviderClass* =  ptr CssProviderClassObj
  CssProviderClassPtr* = ptr CssProviderClassObj
  CssProviderClassObj*{.final.} = object of GObjectClassObj
    parsingError*: proc (provider: CssProvider; section: CssSection;
                       error: glib.GError) {.cdecl.}
    gtkReserved572*: proc () {.cdecl.}
    gtkReserved573*: proc () {.cdecl.}
    gtkReserved574*: proc () {.cdecl.}

proc cssSectionGetType*(): GType {.importc: "gtk_css_section_get_type",
                                   libgtk.}
proc `ref`*(section: CssSection): CssSection {.
    importc: "gtk_css_section_ref", libgtk.}
proc unref*(section: CssSection) {.
    importc: "gtk_css_section_unref", libgtk.}
proc getSectionType*(section: CssSection): CssSectionType {.
    importc: "gtk_css_section_get_section_type", libgtk.}
proc sectionType*(section: CssSection): CssSectionType {.
    importc: "gtk_css_section_get_section_type", libgtk.}
proc getParent*(section: CssSection): CssSection {.
    importc: "gtk_css_section_get_parent", libgtk.}
proc parent*(section: CssSection): CssSection {.
    importc: "gtk_css_section_get_parent", libgtk.}
proc getFile*(section: CssSection): gio.GFile {.
    importc: "gtk_css_section_get_file", libgtk.}
proc file*(section: CssSection): gio.GFile {.
    importc: "gtk_css_section_get_file", libgtk.}
proc getStartLine*(section: CssSection): cuint {.
    importc: "gtk_css_section_get_start_line", libgtk.}
proc startLine*(section: CssSection): cuint {.
    importc: "gtk_css_section_get_start_line", libgtk.}
proc getStartPosition*(section: CssSection): cuint {.
    importc: "gtk_css_section_get_start_position", libgtk.}
proc startPosition*(section: CssSection): cuint {.
    importc: "gtk_css_section_get_start_position", libgtk.}
proc getEndLine*(section: CssSection): cuint {.
    importc: "gtk_css_section_get_end_line", libgtk.}
proc endLine*(section: CssSection): cuint {.
    importc: "gtk_css_section_get_end_line", libgtk.}
proc getEndPosition*(section: CssSection): cuint {.
    importc: "gtk_css_section_get_end_position", libgtk.}
proc endPosition*(section: CssSection): cuint {.
    importc: "gtk_css_section_get_end_position", libgtk.}

template typeCssProvider*(): expr =
  (cssProviderGetType())

template cssProvider*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeCssProvider, CssProviderObj))

template cssProviderClass*(c: expr): expr =
  (gTypeCheckClassCast(c, typeCssProvider, CssProviderClassObj))

template isCssProvider*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeCssProvider))

template isCssProviderClass*(c: expr): expr =
  (gTypeCheckClassType(c, typeCssProvider))

template cssProviderGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeCssProvider, CssProviderClassObj))

template cssProviderError*(): expr =
  (gtkCssProviderErrorQuark())

type
  CssProviderError* {.size: sizeof(cint), pure.} = enum
    FAILED, SYNTAX,
    `IMPORT`, NAME,
    DEPRECATED, UNKNOWN_VALUE

proc cssProviderErrorQuark*(): GQuark {.importc: "gtk_css_provider_error_quark",
                                        libgtk.}
proc cssProviderGetType*(): GType {.importc: "gtk_css_provider_get_type",
                                    libgtk.}
proc newCssProvider*(): CssProvider {.importc: "gtk_css_provider_new",
    libgtk.}
proc toString*(provider: CssProvider): cstring {.
    importc: "gtk_css_provider_to_string", libgtk.}
proc loadFromData*(cssProvider: CssProvider; data: cstring;
                                length: Gssize; error: var glib.GError): Gboolean {.
    importc: "gtk_css_provider_load_from_data", libgtk.}
proc loadFromFile*(cssProvider: CssProvider; file: gio.GFile;
                                error: var glib.GError): Gboolean {.
    importc: "gtk_css_provider_load_from_file", libgtk.}
proc loadFromPath*(cssProvider: CssProvider; path: cstring;
                                error: var glib.GError): Gboolean {.
    importc: "gtk_css_provider_load_from_path", libgtk.}
proc loadFromResource*(cssProvider: CssProvider;
                                    resourcePath: cstring) {.
    importc: "gtk_css_provider_load_from_resource", libgtk.}
proc cssProviderGetDefault*(): CssProvider {.
    importc: "gtk_css_provider_get_default", libgtk.}
proc cssProviderGetNamed*(name: cstring; variant: cstring): CssProvider {.
    importc: "gtk_css_provider_get_named", libgtk.}

type
  DebugFlag* {.size: sizeof(cint), pure.} = enum
    MISC = 1 shl 0, PLUGSOCKET = 1 shl 1, TEXT = 1 shl 2,
    TREE = 1 shl 3, UPDATES = 1 shl 4,
    KEYBINDINGS = 1 shl 5, MULTIHEAD = 1 shl 6,
    MODULES = 1 shl 7, GEOMETRY = 1 shl 8,
    ICONTHEME = 1 shl 9, PRINTING = 1 shl 10,
    BUILDER = 1 shl 11, SIZE_REQUEST = 1 shl 12,
    NO_CSS_CACHE = 1 shl 13, BASELINES = 1 shl 14,
    PIXEL_CACHE = 1 shl 15, NO_PIXEL_CACHE = 1 shl 16,
    INTERACTIVE = 1 shl 17, TOUCHSCREEN = 1 shl 18,
    ACTIONS = 1 shl 19, RESIZE = 1 shl 20, LAYOUT = 1 shl 21

type
  DrawingArea* =  ptr DrawingAreaObj
  DrawingAreaPtr* = ptr DrawingAreaObj
  DrawingAreaObj*{.final.} = object of WidgetObj
    dummy: Gpointer

  DrawingAreaClass* =  ptr DrawingAreaClassObj
  DrawingAreaClassPtr* = ptr DrawingAreaClassObj
  DrawingAreaClassObj*{.final.} = object of WidgetClassObj
    gtkReserved581*: proc () {.cdecl.}
    gtkReserved582*: proc () {.cdecl.}
    gtkReserved583*: proc () {.cdecl.}
    gtkReserved584*: proc () {.cdecl.}

proc getDebugFlags*(): cuint {.importc: "gtk_get_debug_flags", libgtk.}

proc debugFlags*(): cuint {.importc: "gtk_get_debug_flags", libgtk.}
proc setDebugFlags*(flags: cuint) {.importc: "gtk_set_debug_flags", libgtk.}
proc `debugFlags=`*(flags: cuint) {.importc: "gtk_set_debug_flags", libgtk.}

proc dragSourceSet*(widget: Widget; startButtonMask: gdk3.ModifierType;
                      targets: TargetEntry; nTargets: cint;
                      actions: gdk3.DragAction) {.importc: "gtk_drag_source_set",
    libgtk.}
proc dragSourceUnset*(widget: Widget) {.importc: "gtk_drag_source_unset",
    libgtk.}
proc dragSourceGetTargetList*(widget: Widget): TargetList {.
    importc: "gtk_drag_source_get_target_list", libgtk.}
proc dragSourceSetTargetList*(widget: Widget;
                                targetList: TargetList) {.
    importc: "gtk_drag_source_set_target_list", libgtk.}
proc dragSourceAddTextTargets*(widget: Widget) {.
    importc: "gtk_drag_source_add_text_targets", libgtk.}
proc dragSourceAddImageTargets*(widget: Widget) {.
    importc: "gtk_drag_source_add_image_targets", libgtk.}
proc dragSourceAddUriTargets*(widget: Widget) {.
    importc: "gtk_drag_source_add_uri_targets", libgtk.}
proc dragSourceSetIconPixbuf*(widget: Widget; pixbuf: GdkPixbuf) {.
    importc: "gtk_drag_source_set_icon_pixbuf", libgtk.}
proc dragSourceSetIconStock*(widget: Widget; stockId: cstring) {.
    importc: "gtk_drag_source_set_icon_stock", libgtk.}
proc dragSourceSetIconName*(widget: Widget; iconName: cstring) {.
    importc: "gtk_drag_source_set_icon_name", libgtk.}
proc dragSourceSetIconGicon*(widget: Widget; icon: gio.GIcon) {.
    importc: "gtk_drag_source_set_icon_gicon", libgtk.}

template typeDrawingArea*(): expr =
  (drawingAreaGetType())

template drawingArea*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeDrawingArea, DrawingAreaObj))

template drawingAreaClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeDrawingArea, DrawingAreaClassObj))

template isDrawingArea*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeDrawingArea))

template isDrawingAreaClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeDrawingArea))

template drawingAreaGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeDrawingArea, DrawingAreaClassObj))

type
  EventBox* =  ptr EventBoxObj
  EventBoxPtr* = ptr EventBoxObj
  EventBoxObj*{.final.} = object of BinObj
    priv68: pointer

  EventBoxClass* =  ptr EventBoxClassObj
  EventBoxClassPtr* = ptr EventBoxClassObj
  EventBoxClassObj*{.final.} = object of BinClassObj
    gtkReserved591*: proc () {.cdecl.}
    gtkReserved592*: proc () {.cdecl.}
    gtkReserved593*: proc () {.cdecl.}
    gtkReserved594*: proc () {.cdecl.}

proc drawingAreaGetType*(): GType {.importc: "gtk_drawing_area_get_type",
                                    libgtk.}
proc newDrawingArea*(): DrawingArea {.importc: "gtk_drawing_area_new",
                                       libgtk.}

template typeEventBox*(): expr =
  (eventBoxGetType())

template eventBox*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeEventBox, EventBoxObj))

template eventBoxClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeEventBox, EventBoxClassObj))

template isEventBox*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeEventBox))

template isEventBoxClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeEventBox))

template eventBoxGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeEventBox, EventBoxClassObj))

type
  Expander* =  ptr ExpanderObj
  ExpanderPtr* = ptr ExpanderObj
  ExpanderObj*{.final.} = object of BinObj
    priv69: pointer

  ExpanderClass* =  ptr ExpanderClassObj
  ExpanderClassPtr* = ptr ExpanderClassObj
  ExpanderClassObj*{.final.} = object of BinClassObj
    activate*: proc (expander: Expander) {.cdecl.}
    gtkReserved601*: proc () {.cdecl.}
    gtkReserved602*: proc () {.cdecl.}
    gtkReserved603*: proc () {.cdecl.}
    gtkReserved604*: proc () {.cdecl.}

proc eventBoxGetType*(): GType {.importc: "gtk_event_box_get_type", libgtk.}
proc newEventBox*(): EventBox {.importc: "gtk_event_box_new", libgtk.}
proc getVisibleWindow*(eventBox: EventBox): Gboolean {.
    importc: "gtk_event_box_get_visible_window", libgtk.}
proc visibleWindow*(eventBox: EventBox): Gboolean {.
    importc: "gtk_event_box_get_visible_window", libgtk.}
proc setVisibleWindow*(eventBox: EventBox; visibleWindow: Gboolean) {.
    importc: "gtk_event_box_set_visible_window", libgtk.}
proc `visibleWindow=`*(eventBox: EventBox; visibleWindow: Gboolean) {.
    importc: "gtk_event_box_set_visible_window", libgtk.}
proc getAboveChild*(eventBox: EventBox): Gboolean {.
    importc: "gtk_event_box_get_above_child", libgtk.}
proc aboveChild*(eventBox: EventBox): Gboolean {.
    importc: "gtk_event_box_get_above_child", libgtk.}
proc setAboveChild*(eventBox: EventBox; aboveChild: Gboolean) {.
    importc: "gtk_event_box_set_above_child", libgtk.}
proc `aboveChild=`*(eventBox: EventBox; aboveChild: Gboolean) {.
    importc: "gtk_event_box_set_above_child", libgtk.}

type
  EventController* =  ptr EventControllerObj
  EventControllerPtr* = ptr EventControllerObj
  EventControllerObj* = object

  EventControllerClass* =  ptr EventControllerClassObj
  EventControllerClassPtr* = ptr EventControllerClassObj
  EventControllerClassObj* = object

template typeEventController*(): expr =
  (eventControllerGetType())

template eventController*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeEventController, EventControllerObj))

template eventControllerClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeEventController, EventControllerClassObj))

template isEventController*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeEventController))

template isEventControllerClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeEventController))

template eventControllerGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeEventController, EventControllerClassObj))

proc eventControllerGetType*(): GType {.importc: "gtk_event_controller_get_type",
                                        libgtk.}
proc getWidget*(controller: EventController): Widget {.
    importc: "gtk_event_controller_get_widget", libgtk.}
proc widget*(controller: EventController): Widget {.
    importc: "gtk_event_controller_get_widget", libgtk.}
proc handleEvent*(controller: EventController;
                                   event: gdk3.Event): Gboolean {.
    importc: "gtk_event_controller_handle_event", libgtk.}
proc reset*(controller: EventController) {.
    importc: "gtk_event_controller_reset", libgtk.}
proc getPropagationPhase*(controller: EventController): PropagationPhase {.
    importc: "gtk_event_controller_get_propagation_phase", libgtk.}
proc propagationPhase*(controller: EventController): PropagationPhase {.
    importc: "gtk_event_controller_get_propagation_phase", libgtk.}
proc setPropagationPhase*(controller: EventController;
    phase: PropagationPhase) {.importc: "gtk_event_controller_set_propagation_phase",
                                libgtk.}
proc `propagationPhase=`*(controller: EventController;
    phase: PropagationPhase) {.importc: "gtk_event_controller_set_propagation_phase",
                                libgtk.}

template typeExpander*(): expr =
  (expanderGetType())

template expander*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeExpander, ExpanderObj))

template expanderClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeExpander, ExpanderClassObj))

template isExpander*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeExpander))

template isExpanderClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeExpander))

template expanderGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeExpander, ExpanderClassObj))

type
  Fixed* =  ptr FixedObj
  FixedPtr* = ptr FixedObj
  FixedObj*{.final.} = object of ContainerObj
    priv70: pointer

  FixedClass* =  ptr FixedClassObj
  FixedClassPtr* = ptr FixedClassObj
  FixedClassObj*{.final.} = object of ContainerClassObj
    gtkReserved611*: proc () {.cdecl.}
    gtkReserved612*: proc () {.cdecl.}
    gtkReserved613*: proc () {.cdecl.}
    gtkReserved614*: proc () {.cdecl.}

proc expanderGetType*(): GType {.importc: "gtk_expander_get_type", libgtk.}
proc newExpander*(label: cstring): Expander {.importc: "gtk_expander_new",
    libgtk.}
proc setExpanded*(expander: Expander; expanded: Gboolean) {.
    importc: "gtk_expander_set_expanded", libgtk.}
proc `expanded=`*(expander: Expander; expanded: Gboolean) {.
    importc: "gtk_expander_set_expanded", libgtk.}
proc getExpanded*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_expanded", libgtk.}
proc expanded*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_expanded", libgtk.}

proc setSpacing*(expander: Expander; spacing: cint) {.
    importc: "gtk_expander_set_spacing", libgtk.}

proc `spacing=`*(expander: Expander; spacing: cint) {.
    importc: "gtk_expander_set_spacing", libgtk.}
proc getSpacing*(expander: Expander): cint {.
    importc: "gtk_expander_get_spacing", libgtk.}
proc spacing*(expander: Expander): cint {.
    importc: "gtk_expander_get_spacing", libgtk.}
proc setLabel*(expander: Expander; label: cstring) {.
    importc: "gtk_expander_set_label", libgtk.}
proc `label=`*(expander: Expander; label: cstring) {.
    importc: "gtk_expander_set_label", libgtk.}
proc getLabel*(expander: Expander): cstring {.
    importc: "gtk_expander_get_label", libgtk.}
proc label*(expander: Expander): cstring {.
    importc: "gtk_expander_get_label", libgtk.}
proc setUseUnderline*(expander: Expander; useUnderline: Gboolean) {.
    importc: "gtk_expander_set_use_underline", libgtk.}
proc `useUnderline=`*(expander: Expander; useUnderline: Gboolean) {.
    importc: "gtk_expander_set_use_underline", libgtk.}
proc getUseUnderline*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_use_underline", libgtk.}
proc useUnderline*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_use_underline", libgtk.}
proc setUseMarkup*(expander: Expander; useMarkup: Gboolean) {.
    importc: "gtk_expander_set_use_markup", libgtk.}
proc `useMarkup=`*(expander: Expander; useMarkup: Gboolean) {.
    importc: "gtk_expander_set_use_markup", libgtk.}
proc getUseMarkup*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_use_markup", libgtk.}
proc useMarkup*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_use_markup", libgtk.}
proc setLabelWidget*(expander: Expander;
                               labelWidget: Widget) {.
    importc: "gtk_expander_set_label_widget", libgtk.}
proc `labelWidget=`*(expander: Expander;
                               labelWidget: Widget) {.
    importc: "gtk_expander_set_label_widget", libgtk.}
proc getLabelWidget*(expander: Expander): Widget {.
    importc: "gtk_expander_get_label_widget", libgtk.}
proc labelWidget*(expander: Expander): Widget {.
    importc: "gtk_expander_get_label_widget", libgtk.}
proc setLabelFill*(expander: Expander; labelFill: Gboolean) {.
    importc: "gtk_expander_set_label_fill", libgtk.}
proc `labelFill=`*(expander: Expander; labelFill: Gboolean) {.
    importc: "gtk_expander_set_label_fill", libgtk.}
proc getLabelFill*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_label_fill", libgtk.}
proc labelFill*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_label_fill", libgtk.}
proc setResizeToplevel*(expander: Expander;
                                  resizeToplevel: Gboolean) {.
    importc: "gtk_expander_set_resize_toplevel", libgtk.}
proc `resizeToplevel=`*(expander: Expander;
                                  resizeToplevel: Gboolean) {.
    importc: "gtk_expander_set_resize_toplevel", libgtk.}
proc getResizeToplevel*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_resize_toplevel", libgtk.}
proc resizeToplevel*(expander: Expander): Gboolean {.
    importc: "gtk_expander_get_resize_toplevel", libgtk.}

template typeFixed*(): expr =
  (fixedGetType())

template fixed*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFixed, FixedObj))

template fixedClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFixed, FixedClassObj))

template isFixed*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFixed))

template isFixedClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFixed))

template fixedGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeFixed, FixedClassObj))

type
  FixedChild* =  ptr FixedChildObj
  FixedChildPtr* = ptr FixedChildObj
  FixedChildObj* = object
    widget*: Widget
    x*: cint
    y*: cint

  FileFilter* =  ptr FileFilterObj
  FileFilterPtr* = ptr FileFilterObj
  FileFilterObj* = object

proc fixedGetType*(): GType {.importc: "gtk_fixed_get_type", libgtk.}
proc newFixed*(): Fixed {.importc: "gtk_fixed_new", libgtk.}
proc put*(fixed: Fixed; widget: Widget; x: cint; y: cint) {.
    importc: "gtk_fixed_put", libgtk.}
proc move*(fixed: Fixed; widget: Widget; x: cint; y: cint) {.
    importc: "gtk_fixed_move", libgtk.}

template typeFileFilter*(): expr =
  (fileFilterGetType())

template fileFilter*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFileFilter, FileFilterObj))

template isFileFilter*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFileFilter))

type
  FileFilterFlags* {.size: sizeof(cint), pure.} = enum
    FILENAME = 1 shl 0, URI = 1 shl 1,
    DISPLAY_NAME = 1 shl 2, MIME_TYPE = 1 shl 3

type
  FileFilterInfo* =  ptr FileFilterInfoObj
  FileFilterInfoPtr* = ptr FileFilterInfoObj
  FileFilterInfoObj* = object
    contains*: FileFilterFlags
    filename*: cstring
    uri*: cstring
    displayName*: cstring
    mimeType*: cstring

  FileChooser* =  ptr FileChooserObj
  FileChooserPtr* = ptr FileChooserObj
  FileChooserObj* = object

type
  FileFilterFunc* = proc (filterInfo: FileFilterInfo; data: Gpointer): Gboolean {.cdecl.}

proc fileFilterGetType*(): GType {.importc: "gtk_file_filter_get_type",
                                   libgtk.}
proc newFileFilter*(): FileFilter {.importc: "gtk_file_filter_new",
    libgtk.}
proc setName*(filter: FileFilter; name: cstring) {.
    importc: "gtk_file_filter_set_name", libgtk.}
proc `name=`*(filter: FileFilter; name: cstring) {.
    importc: "gtk_file_filter_set_name", libgtk.}
proc getName*(filter: FileFilter): cstring {.
    importc: "gtk_file_filter_get_name", libgtk.}
proc name*(filter: FileFilter): cstring {.
    importc: "gtk_file_filter_get_name", libgtk.}
proc addMimeType*(filter: FileFilter; mimeType: cstring) {.
    importc: "gtk_file_filter_add_mime_type", libgtk.}
proc addPattern*(filter: FileFilter; pattern: cstring) {.
    importc: "gtk_file_filter_add_pattern", libgtk.}
proc addPixbufFormats*(filter: FileFilter) {.
    importc: "gtk_file_filter_add_pixbuf_formats", libgtk.}
proc addCustom*(filter: FileFilter; needed: FileFilterFlags;
                            `func`: FileFilterFunc; data: Gpointer;
                            notify: GDestroyNotify) {.
    importc: "gtk_file_filter_add_custom", libgtk.}
proc getNeeded*(filter: FileFilter): FileFilterFlags {.
    importc: "gtk_file_filter_get_needed", libgtk.}
proc needed*(filter: FileFilter): FileFilterFlags {.
    importc: "gtk_file_filter_get_needed", libgtk.}
proc filter*(filter: FileFilter;
                         filterInfo: FileFilterInfo): Gboolean {.
    importc: "gtk_file_filter_filter", libgtk.}

template typeFileChooser*(): expr =
  (fileChooserGetType())

template fileChooser*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFileChooser, FileChooserObj))

template isFileChooser*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFileChooser))

type
  FileChooserAction* {.size: sizeof(cint), pure.} = enum
    OPEN, SAVE,
    SELECT_FOLDER, CREATE_FOLDER

type
  FileChooserConfirmation* {.size: sizeof(cint), pure.} = enum
    CONFIRM,
    ACCEPT_FILENAME,
    SELECT_AGAIN

proc fileChooserGetType*(): GType {.importc: "gtk_file_chooser_get_type",
                                    libgtk.}

template fileChooserError*(): expr =
  (gtkFileChooserErrorQuark())

type
  FileChooserError* {.size: sizeof(cint), pure.} = enum
    NONEXISTENT, BAD_FILENAME,
    ALREADY_EXISTS,
    INCOMPLETE_HOSTNAME

type
  FileChooserButton* =  ptr FileChooserButtonObj
  FileChooserButtonPtr* = ptr FileChooserButtonObj
  FileChooserButtonObj*{.final.} = object of BoxObj
    priv71: pointer

  FileChooserButtonClass* =  ptr FileChooserButtonClassObj
  FileChooserButtonClassPtr* = ptr FileChooserButtonClassObj
  FileChooserButtonClassObj*{.final.} = object of BoxClassObj
    fileSet*: proc (fc: FileChooserButton) {.cdecl.}
    gtkReserved621*: proc () {.cdecl.}
    gtkReserved622*: proc () {.cdecl.}
    gtkReserved623*: proc () {.cdecl.}
    gtkReserved624*: proc () {.cdecl.}

proc fileChooserErrorQuark*(): GQuark {.importc: "gtk_file_chooser_error_quark",
                                        libgtk.}

proc setAction*(chooser: FileChooser;
                             action: FileChooserAction) {.
    importc: "gtk_file_chooser_set_action", libgtk.}

proc `action=`*(chooser: FileChooser;
                             action: FileChooserAction) {.
    importc: "gtk_file_chooser_set_action", libgtk.}
proc getAction*(chooser: FileChooser): FileChooserAction {.
    importc: "gtk_file_chooser_get_action", libgtk.}
proc action*(chooser: FileChooser): FileChooserAction {.
    importc: "gtk_file_chooser_get_action", libgtk.}
proc setLocalOnly*(chooser: FileChooser; localOnly: Gboolean) {.
    importc: "gtk_file_chooser_set_local_only", libgtk.}
proc `localOnly=`*(chooser: FileChooser; localOnly: Gboolean) {.
    importc: "gtk_file_chooser_set_local_only", libgtk.}
proc getLocalOnly*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_local_only", libgtk.}
proc localOnly*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_local_only", libgtk.}
proc setSelectMultiple*(chooser: FileChooser;
                                     selectMultiple: Gboolean) {.
    importc: "gtk_file_chooser_set_select_multiple", libgtk.}
proc `selectMultiple=`*(chooser: FileChooser;
                                     selectMultiple: Gboolean) {.
    importc: "gtk_file_chooser_set_select_multiple", libgtk.}
proc getSelectMultiple*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_select_multiple", libgtk.}
proc selectMultiple*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_select_multiple", libgtk.}
proc setShowHidden*(chooser: FileChooser; showHidden: Gboolean) {.
    importc: "gtk_file_chooser_set_show_hidden", libgtk.}
proc `showHidden=`*(chooser: FileChooser; showHidden: Gboolean) {.
    importc: "gtk_file_chooser_set_show_hidden", libgtk.}
proc getShowHidden*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_show_hidden", libgtk.}
proc showHidden*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_show_hidden", libgtk.}
proc setDoOverwriteConfirmation*(chooser: FileChooser;
    doOverwriteConfirmation: Gboolean) {.importc: "gtk_file_chooser_set_do_overwrite_confirmation",
                                       libgtk.}
proc `doOverwriteConfirmation=`*(chooser: FileChooser;
    doOverwriteConfirmation: Gboolean) {.importc: "gtk_file_chooser_set_do_overwrite_confirmation",
                                       libgtk.}
proc getDoOverwriteConfirmation*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_do_overwrite_confirmation", libgtk.}
proc doOverwriteConfirmation*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_do_overwrite_confirmation", libgtk.}
proc setCreateFolders*(chooser: FileChooser;
                                    createFolders: Gboolean) {.
    importc: "gtk_file_chooser_set_create_folders", libgtk.}
proc `createFolders=`*(chooser: FileChooser;
                                    createFolders: Gboolean) {.
    importc: "gtk_file_chooser_set_create_folders", libgtk.}
proc getCreateFolders*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_create_folders", libgtk.}
proc createFolders*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_create_folders", libgtk.}

proc setCurrentName*(chooser: FileChooser; name: cstring) {.
    importc: "gtk_file_chooser_set_current_name", libgtk.}

proc `currentName=`*(chooser: FileChooser; name: cstring) {.
    importc: "gtk_file_chooser_set_current_name", libgtk.}
proc getCurrentName*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_current_name", libgtk.}
proc currentName*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_current_name", libgtk.}

proc getFilename*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_filename", libgtk.}

proc filename*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_filename", libgtk.}
proc setFilename*(chooser: FileChooser; filename: cstring): Gboolean {.
    importc: "gtk_file_chooser_set_filename", libgtk.}
proc selectFilename*(chooser: FileChooser; filename: cstring): Gboolean {.
    importc: "gtk_file_chooser_select_filename", libgtk.}
proc unselectFilename*(chooser: FileChooser; filename: cstring) {.
    importc: "gtk_file_chooser_unselect_filename", libgtk.}
proc selectAll*(chooser: FileChooser) {.
    importc: "gtk_file_chooser_select_all", libgtk.}
proc unselectAll*(chooser: FileChooser) {.
    importc: "gtk_file_chooser_unselect_all", libgtk.}
proc getFilenames*(chooser: FileChooser): glib.GSList {.
    importc: "gtk_file_chooser_get_filenames", libgtk.}
proc filenames*(chooser: FileChooser): glib.GSList {.
    importc: "gtk_file_chooser_get_filenames", libgtk.}
proc setCurrentFolder*(chooser: FileChooser; filename: cstring): Gboolean {.
    importc: "gtk_file_chooser_set_current_folder", libgtk.}
proc getCurrentFolder*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_current_folder", libgtk.}
proc currentFolder*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_current_folder", libgtk.}

proc getUri*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_uri", libgtk.}

proc uri*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_uri", libgtk.}
proc setUri*(chooser: FileChooser; uri: cstring): Gboolean {.
    importc: "gtk_file_chooser_set_uri", libgtk.}
proc selectUri*(chooser: FileChooser; uri: cstring): Gboolean {.
    importc: "gtk_file_chooser_select_uri", libgtk.}
proc unselectUri*(chooser: FileChooser; uri: cstring) {.
    importc: "gtk_file_chooser_unselect_uri", libgtk.}
proc getUris*(chooser: FileChooser): glib.GSList {.
    importc: "gtk_file_chooser_get_uris", libgtk.}
proc uris*(chooser: FileChooser): glib.GSList {.
    importc: "gtk_file_chooser_get_uris", libgtk.}
proc setCurrentFolderUri*(chooser: FileChooser; uri: cstring): Gboolean {.
    importc: "gtk_file_chooser_set_current_folder_uri", libgtk.}
proc getCurrentFolderUri*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_current_folder_uri", libgtk.}
proc currentFolderUri*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_current_folder_uri", libgtk.}

proc getFile*(chooser: FileChooser): gio.GFile {.
    importc: "gtk_file_chooser_get_file", libgtk.}

proc file*(chooser: FileChooser): gio.GFile {.
    importc: "gtk_file_chooser_get_file", libgtk.}
proc setFile*(chooser: FileChooser; file: gio.GFile;
                           error: var glib.GError): Gboolean {.
    importc: "gtk_file_chooser_set_file", libgtk.}
proc selectFile*(chooser: FileChooser; file: gio.GFile;
                              error: var glib.GError): Gboolean {.
    importc: "gtk_file_chooser_select_file", libgtk.}
proc unselectFile*(chooser: FileChooser; file: gio.GFile) {.
    importc: "gtk_file_chooser_unselect_file", libgtk.}
proc getFiles*(chooser: FileChooser): glib.GSList {.
    importc: "gtk_file_chooser_get_files", libgtk.}
proc files*(chooser: FileChooser): glib.GSList {.
    importc: "gtk_file_chooser_get_files", libgtk.}
proc setCurrentFolderFile*(chooser: FileChooser;
                                        file: gio.GFile; error: var glib.GError): Gboolean {.
    importc: "gtk_file_chooser_set_current_folder_file", libgtk.}
proc getCurrentFolderFile*(chooser: FileChooser): gio.GFile {.
    importc: "gtk_file_chooser_get_current_folder_file", libgtk.}
proc currentFolderFile*(chooser: FileChooser): gio.GFile {.
    importc: "gtk_file_chooser_get_current_folder_file", libgtk.}

proc setPreviewWidget*(chooser: FileChooser;
                                    previewWidget: Widget) {.
    importc: "gtk_file_chooser_set_preview_widget", libgtk.}

proc `previewWidget=`*(chooser: FileChooser;
                                    previewWidget: Widget) {.
    importc: "gtk_file_chooser_set_preview_widget", libgtk.}
proc getPreviewWidget*(chooser: FileChooser): Widget {.
    importc: "gtk_file_chooser_get_preview_widget", libgtk.}
proc previewWidget*(chooser: FileChooser): Widget {.
    importc: "gtk_file_chooser_get_preview_widget", libgtk.}
proc setPreviewWidgetActive*(chooser: FileChooser;
    active: Gboolean) {.importc: "gtk_file_chooser_set_preview_widget_active",
                      libgtk.}
proc `previewWidgetActive=`*(chooser: FileChooser;
    active: Gboolean) {.importc: "gtk_file_chooser_set_preview_widget_active",
                      libgtk.}
proc getPreviewWidgetActive*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_preview_widget_active", libgtk.}
proc previewWidgetActive*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_preview_widget_active", libgtk.}
proc setUsePreviewLabel*(chooser: FileChooser;
                                      useLabel: Gboolean) {.
    importc: "gtk_file_chooser_set_use_preview_label", libgtk.}
proc `usePreviewLabel=`*(chooser: FileChooser;
                                      useLabel: Gboolean) {.
    importc: "gtk_file_chooser_set_use_preview_label", libgtk.}
proc getUsePreviewLabel*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_use_preview_label", libgtk.}
proc usePreviewLabel*(chooser: FileChooser): Gboolean {.
    importc: "gtk_file_chooser_get_use_preview_label", libgtk.}
proc getPreviewFilename*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_preview_filename", libgtk.}
proc previewFilename*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_preview_filename", libgtk.}
proc getPreviewUri*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_preview_uri", libgtk.}
proc previewUri*(chooser: FileChooser): cstring {.
    importc: "gtk_file_chooser_get_preview_uri", libgtk.}
proc getPreviewFile*(chooser: FileChooser): gio.GFile {.
    importc: "gtk_file_chooser_get_preview_file", libgtk.}
proc previewFile*(chooser: FileChooser): gio.GFile {.
    importc: "gtk_file_chooser_get_preview_file", libgtk.}

proc setExtraWidget*(chooser: FileChooser;
                                  extraWidget: Widget) {.
    importc: "gtk_file_chooser_set_extra_widget", libgtk.}

proc `extraWidget=`*(chooser: FileChooser;
                                  extraWidget: Widget) {.
    importc: "gtk_file_chooser_set_extra_widget", libgtk.}
proc getExtraWidget*(chooser: FileChooser): Widget {.
    importc: "gtk_file_chooser_get_extra_widget", libgtk.}
proc extraWidget*(chooser: FileChooser): Widget {.
    importc: "gtk_file_chooser_get_extra_widget", libgtk.}

proc addFilter*(chooser: FileChooser; filter: FileFilter) {.
    importc: "gtk_file_chooser_add_filter", libgtk.}
proc removeFilter*(chooser: FileChooser;
                                filter: FileFilter) {.
    importc: "gtk_file_chooser_remove_filter", libgtk.}
proc listFilters*(chooser: FileChooser): glib.GSList {.
    importc: "gtk_file_chooser_list_filters", libgtk.}

proc setFilter*(chooser: FileChooser; filter: FileFilter) {.
    importc: "gtk_file_chooser_set_filter", libgtk.}

proc `filter=`*(chooser: FileChooser; filter: FileFilter) {.
    importc: "gtk_file_chooser_set_filter", libgtk.}
proc getFilter*(chooser: FileChooser): FileFilter {.
    importc: "gtk_file_chooser_get_filter", libgtk.}
proc filter*(chooser: FileChooser): FileFilter {.
    importc: "gtk_file_chooser_get_filter", libgtk.}

proc addShortcutFolder*(chooser: FileChooser; folder: cstring;
                                     error: var glib.GError): Gboolean {.
    importc: "gtk_file_chooser_add_shortcut_folder", libgtk.}
proc removeShortcutFolder*(chooser: FileChooser;
                                        folder: cstring; error: var glib.GError): Gboolean {.
    importc: "gtk_file_chooser_remove_shortcut_folder", libgtk.}
proc listShortcutFolders*(chooser: FileChooser): glib.GSList {.
    importc: "gtk_file_chooser_list_shortcut_folders", libgtk.}
proc addShortcutFolderUri*(chooser: FileChooser; uri: cstring;
                                        error: var glib.GError): Gboolean {.
    importc: "gtk_file_chooser_add_shortcut_folder_uri", libgtk.}
proc removeShortcutFolderUri*(chooser: FileChooser;
    uri: cstring; error: var glib.GError): Gboolean {.
    importc: "gtk_file_chooser_remove_shortcut_folder_uri", libgtk.}
proc listShortcutFolderUris*(chooser: FileChooser): glib.GSList {.
    importc: "gtk_file_chooser_list_shortcut_folder_uris", libgtk.}

template typeFileChooserButton*(): expr =
  (fileChooserButtonGetType())

template fileChooserButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFileChooserButton, FileChooserButtonObj))

template fileChooserButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFileChooserButton, FileChooserButtonClassObj))

template isFileChooserButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFileChooserButton))

template isFileChooserButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFileChooserButton))

template fileChooserButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeFileChooserButton, FileChooserButtonClassObj))

type
  FileChooserDialog* =  ptr FileChooserDialogObj
  FileChooserDialogPtr* = ptr FileChooserDialogObj
  FileChooserDialogObj*{.final.} = object of DialogObj
    priv72: pointer

  FileChooserDialogClass* =  ptr FileChooserDialogClassObj
  FileChooserDialogClassPtr* = ptr FileChooserDialogClassObj
  FileChooserDialogClassObj*{.final.} = object of DialogClassObj
    gtkReserved631*: proc () {.cdecl.}
    gtkReserved632*: proc () {.cdecl.}
    gtkReserved633*: proc () {.cdecl.}
    gtkReserved634*: proc () {.cdecl.}

proc fileChooserButtonGetType*(): GType {.
    importc: "gtk_file_chooser_button_get_type", libgtk.}
proc newFileChooserButton*(title: cstring; action: FileChooserAction): FileChooserButton {.
    importc: "gtk_file_chooser_button_new", libgtk.}
proc getTitle*(button: FileChooserButton): cstring {.
    importc: "gtk_file_chooser_button_get_title", libgtk.}
proc title*(button: FileChooserButton): cstring {.
    importc: "gtk_file_chooser_button_get_title", libgtk.}
proc setTitle*(button: FileChooserButton; title: cstring) {.
    importc: "gtk_file_chooser_button_set_title", libgtk.}
proc `title=`*(button: FileChooserButton; title: cstring) {.
    importc: "gtk_file_chooser_button_set_title", libgtk.}
proc getWidthChars*(button: FileChooserButton): cint {.
    importc: "gtk_file_chooser_button_get_width_chars", libgtk.}
proc widthChars*(button: FileChooserButton): cint {.
    importc: "gtk_file_chooser_button_get_width_chars", libgtk.}
proc setWidthChars*(button: FileChooserButton;
                                       nChars: cint) {.
    importc: "gtk_file_chooser_button_set_width_chars", libgtk.}
proc `widthChars=`*(button: FileChooserButton;
                                       nChars: cint) {.
    importc: "gtk_file_chooser_button_set_width_chars", libgtk.}
proc getFocusOnClick*(button: FileChooserButton): Gboolean {.
    importc: "gtk_file_chooser_button_get_focus_on_click", libgtk.}
proc focusOnClick*(button: FileChooserButton): Gboolean {.
    importc: "gtk_file_chooser_button_get_focus_on_click", libgtk.}
proc setFocusOnClick*(button: FileChooserButton;
    focusOnClick: Gboolean) {.importc: "gtk_file_chooser_button_set_focus_on_click",
                            libgtk.}
proc `focusOnClick=`*(button: FileChooserButton;
    focusOnClick: Gboolean) {.importc: "gtk_file_chooser_button_set_focus_on_click",
                            libgtk.}

template typeFileChooserDialog*(): expr =
  (fileChooserDialogGetType())

template fileChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFileChooserDialog, FileChooserDialogObj))

template fileChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFileChooserDialog, FileChooserDialogClassObj))

template isFileChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFileChooserDialog))

template isFileChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFileChooserDialog))

template fileChooserDialogGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeFileChooserDialog, FileChooserDialogClassObj))

proc fileChooserDialogGetType*(): GType {.
    importc: "gtk_file_chooser_dialog_get_type", libgtk.}

template typeNativeDialog*(): expr =
  (nativeDialogGetType())

proc nativeDialogGetType*(): GType {.importc: "gtk_native_dialog_get_type",
                                     libgtk.}
type
  NativeDialog* =  ptr NativeDialogObj
  NativeDialogPtr* = ptr NativeDialogObj
  NativeDialogObj*{.final.} = object of GObjectObj

  NativeDialogClass* =  ptr NativeDialogClassObj
  NativeDialogClassPtr* = ptr NativeDialogClassObj
  NativeDialogClassObj = object of GObjectClassObj
    response*: proc (self: NativeDialog; responseId: cint) {.cdecl.}
    show*: proc (self: NativeDialog) {.cdecl.}
    hide*: proc (self: NativeDialog) {.cdecl.}
    gtkReserved641*: proc () {.cdecl.}
    gtkReserved642*: proc () {.cdecl.}
    gtkReserved643*: proc () {.cdecl.}
    gtkReserved644*: proc () {.cdecl.}

proc nativeDialogClass*(`ptr`: Gpointer): NativeDialogClass =
  return gTypeCheckClassCast(`ptr`, nativeDialogGetType(),
                                NativeDialogClassObj)

proc isNativeDialog*(`ptr`: Gpointer): Gboolean =
  return gTypeCheckInstanceType(`ptr`, nativeDialogGetType())

proc isNativeDialogClass*(`ptr`: Gpointer): Gboolean =
  return gTypeCheckClassType(`ptr`, nativeDialogGetType())

proc nativeDialogGetClass*(`ptr`: Gpointer): NativeDialogClass =
  return gTypeInstanceGetClass(`ptr`, nativeDialogGetType(),
                                  NativeDialogClassObj)

proc show*(self: NativeDialog) {.
    importc: "gtk_native_dialog_show", libgtk.}
proc hide*(self: NativeDialog) {.
    importc: "gtk_native_dialog_hide", libgtk.}
proc destroy*(self: NativeDialog) {.
    importc: "gtk_native_dialog_destroy", libgtk.}
proc getVisible*(self: NativeDialog): Gboolean {.
    importc: "gtk_native_dialog_get_visible", libgtk.}
proc visible*(self: NativeDialog): Gboolean {.
    importc: "gtk_native_dialog_get_visible", libgtk.}
proc setModal*(self: NativeDialog; modal: Gboolean) {.
    importc: "gtk_native_dialog_set_modal", libgtk.}
proc `modal=`*(self: NativeDialog; modal: Gboolean) {.
    importc: "gtk_native_dialog_set_modal", libgtk.}
proc getModal*(self: NativeDialog): Gboolean {.
    importc: "gtk_native_dialog_get_modal", libgtk.}
proc modal*(self: NativeDialog): Gboolean {.
    importc: "gtk_native_dialog_get_modal", libgtk.}
proc setTitle*(self: NativeDialog; title: cstring) {.
    importc: "gtk_native_dialog_set_title", libgtk.}
proc `title=`*(self: NativeDialog; title: cstring) {.
    importc: "gtk_native_dialog_set_title", libgtk.}
proc getTitle*(self: NativeDialog): cstring {.
    importc: "gtk_native_dialog_get_title", libgtk.}
proc title*(self: NativeDialog): cstring {.
    importc: "gtk_native_dialog_get_title", libgtk.}
proc setTransientFor*(self: NativeDialog;
                                    parent: Window) {.
    importc: "gtk_native_dialog_set_transient_for", libgtk.}
proc `transientFor=`*(self: NativeDialog;
                                    parent: Window) {.
    importc: "gtk_native_dialog_set_transient_for", libgtk.}
proc getTransientFor*(self: NativeDialog): Window {.
    importc: "gtk_native_dialog_get_transient_for", libgtk.}
proc transientFor*(self: NativeDialog): Window {.
    importc: "gtk_native_dialog_get_transient_for", libgtk.}
proc run*(self: NativeDialog): cint {.
    importc: "gtk_native_dialog_run", libgtk.}

template typeFileChooserNative*(): expr =
  (fileChooserNativeGetType())

type
  FileChooserNative* =  ptr FileChooserNativeObj
  FileChooserNativePtr* = ptr FileChooserNativeObj
  FileChooserNativeObj* = object

  FileChooserNativeClass* =  ptr FileChooserNativeClassObj
  FileChooserNativeClassPtr* = ptr FileChooserNativeClassObj
  FileChooserNativeClassObj*{.final.} = object of NativeDialogClassObj

  FileChooserWidget* =  ptr FileChooserWidgetObj
  FileChooserWidgetPtr* = ptr FileChooserWidgetObj
  FileChooserWidgetObj*{.final.} = object of BoxObj
    priv73: pointer

  FileChooserWidgetClass* =  ptr FileChooserWidgetClassObj
  FileChooserWidgetClassPtr* = ptr FileChooserWidgetClassObj
  FileChooserWidgetClassObj*{.final.} = object of BoxClassObj
    gtkReserved651*: proc () {.cdecl.}
    gtkReserved652*: proc () {.cdecl.}
    gtkReserved653*: proc () {.cdecl.}
    gtkReserved654*: proc () {.cdecl.}

proc fileChooserNativeGetType*(): GType {.
    importc: "gtk_file_chooser_native_get_type", libgtk.}
template isFileChooserNative*(o: expr): expr =
  (gtk_Type_Check_Instance_Type(o, typeFileChooserNative))

proc newFileChooserNative*(title: cstring; parent: Window;
                             action: FileChooserAction; acceptLabel: cstring;
                             cancelLabel: cstring): FileChooserNative {.
    importc: "gtk_file_chooser_native_new", libgtk.}
proc getAcceptLabel*(self: FileChooserNative): cstring {.
    importc: "gtk_file_chooser_native_get_accept_label", libgtk.}
proc acceptLabel*(self: FileChooserNative): cstring {.
    importc: "gtk_file_chooser_native_get_accept_label", libgtk.}
proc setAcceptLabel*(self: FileChooserNative;
                                        acceptLabel: cstring) {.
    importc: "gtk_file_chooser_native_set_accept_label", libgtk.}
proc `acceptLabel=`*(self: FileChooserNative;
                                        acceptLabel: cstring) {.
    importc: "gtk_file_chooser_native_set_accept_label", libgtk.}
proc getCancelLabel*(self: FileChooserNative): cstring {.
    importc: "gtk_file_chooser_native_get_cancel_label", libgtk.}
proc cancelLabel*(self: FileChooserNative): cstring {.
    importc: "gtk_file_chooser_native_get_cancel_label", libgtk.}
proc setCancelLabel*(self: FileChooserNative;
                                        cancelLabel: cstring) {.
    importc: "gtk_file_chooser_native_set_cancel_label", libgtk.}
proc `cancelLabel=`*(self: FileChooserNative;
                                        cancelLabel: cstring) {.
    importc: "gtk_file_chooser_native_set_cancel_label", libgtk.}

template typeFileChooserWidget*(): expr =
  (fileChooserWidgetGetType())

template fileChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFileChooserWidget, FileChooserWidgetObj))

template fileChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFileChooserWidget, FileChooserWidgetClassObj))

template isFileChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFileChooserWidget))

template isFileChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFileChooserWidget))

template fileChooserWidgetGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeFileChooserWidget, FileChooserWidgetClassObj))

type
  FlowBox* =  ptr FlowBoxObj
  FlowBoxPtr* = ptr FlowBoxObj
  FlowBoxObj*{.final.} = object of ContainerObj

  FlowBoxChild* =  ptr FlowBoxChildObj
  FlowBoxChildPtr* = ptr FlowBoxChildObj
  FlowBoxChildObj*{.final.} = object of BinObj

  FlowBoxClass* =  ptr FlowBoxClassObj
  FlowBoxClassPtr* = ptr FlowBoxClassObj
  FlowBoxClassObj*{.final.} = object of ContainerClassObj
    childActivated*: proc (box: FlowBox; child: FlowBoxChild) {.cdecl.}
    selectedChildrenChanged*: proc (box: FlowBox) {.cdecl.}
    activateCursorChild*: proc (box: FlowBox) {.cdecl.}
    toggleCursorChild*: proc (box: FlowBox) {.cdecl.}
    moveCursor*: proc (box: FlowBox; step: MovementStep; count: cint): Gboolean {.cdecl.}
    selectAll*: proc (box: FlowBox) {.cdecl.}
    unselectAll*: proc (box: FlowBox) {.cdecl.}
    gtkReserved661*: proc () {.cdecl.}
    gtkReserved662*: proc () {.cdecl.}
    gtkReserved663*: proc () {.cdecl.}
    gtkReserved664*: proc () {.cdecl.}
    gtkReserved665*: proc () {.cdecl.}
    gtkReserved666*: proc () {.cdecl.}

proc fileChooserWidgetGetType*(): GType {.
    importc: "gtk_file_chooser_widget_get_type", libgtk.}
proc newFileChooserWidget*(action: FileChooserAction): FileChooserWidget {.
    importc: "gtk_file_chooser_widget_new", libgtk.}

template typeFlowBox*(): expr =
  (flowBoxGetType())

template flowBox*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFlowBox, FlowBoxObj))

template flowBoxClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFlowBox, FlowBoxClassObj))

template isFlowBox*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFlowBox))

template isFlowBoxClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFlowBox))

template flowBoxGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeFlowBox, FlowBoxClassObj))

type
  FlowBoxChildClass* =  ptr FlowBoxChildClassObj
  FlowBoxChildClassPtr* = ptr FlowBoxChildClassObj
  FlowBoxChildClassObj*{.final.} = object of BinClassObj
    activate*: proc (child: FlowBoxChild) {.cdecl.}
    gtkReserved671*: proc () {.cdecl.}
    gtkReserved672*: proc () {.cdecl.}

template typeFlowBoxChild*(): expr =
  (flowBoxChildGetType())

template flowBoxChild*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFlowBoxChild, FlowBoxChildObj))

template flowBoxChildClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFlowBoxChild, FlowBoxChildClassObj))

template isFlowBoxChild*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFlowBoxChild))

template isFlowBoxChildClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFlowBoxChild))

template flowBoxChildGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, eg_Type_Flow_Box_Child, gtkFlowBoxChildClass))

type
  FlowBoxCreateWidgetFunc* = proc (item: Gpointer; userData: Gpointer): Widget {.cdecl.}

proc flowBoxChildGetType*(): GType {.importc: "gtk_flow_box_child_get_type",
                                     libgtk.}
proc newFlowBoxChild*(): FlowBoxChild {.importc: "gtk_flow_box_child_new",
                                        libgtk.}
proc getIndex*(child: FlowBoxChild): cint {.
    importc: "gtk_flow_box_child_get_index", libgtk.}
proc index*(child: FlowBoxChild): cint {.
    importc: "gtk_flow_box_child_get_index", libgtk.}
proc isSelected*(child: FlowBoxChild): Gboolean {.
    importc: "gtk_flow_box_child_is_selected", libgtk.}
proc changed*(child: FlowBoxChild) {.
    importc: "gtk_flow_box_child_changed", libgtk.}
proc flowBoxGetType*(): GType {.importc: "gtk_flow_box_get_type", libgtk.}
proc newFlowBox*(): FlowBox {.importc: "gtk_flow_box_new", libgtk.}
proc bindModel*(box: FlowBox; model: gio.GListModel;
                         createWidgetFunc: FlowBoxCreateWidgetFunc;
                         userData: Gpointer; userDataFreeFunc: GDestroyNotify) {.
    importc: "gtk_flow_box_bind_model", libgtk.}
proc setHomogeneous*(box: FlowBox; homogeneous: Gboolean) {.
    importc: "gtk_flow_box_set_homogeneous", libgtk.}
proc `homogeneous=`*(box: FlowBox; homogeneous: Gboolean) {.
    importc: "gtk_flow_box_set_homogeneous", libgtk.}
proc getHomogeneous*(box: FlowBox): Gboolean {.
    importc: "gtk_flow_box_get_homogeneous", libgtk.}
proc homogeneous*(box: FlowBox): Gboolean {.
    importc: "gtk_flow_box_get_homogeneous", libgtk.}
proc setRowSpacing*(box: FlowBox; spacing: cuint) {.
    importc: "gtk_flow_box_set_row_spacing", libgtk.}
proc `rowSpacing=`*(box: FlowBox; spacing: cuint) {.
    importc: "gtk_flow_box_set_row_spacing", libgtk.}
proc getRowSpacing*(box: FlowBox): cuint {.
    importc: "gtk_flow_box_get_row_spacing", libgtk.}
proc rowSpacing*(box: FlowBox): cuint {.
    importc: "gtk_flow_box_get_row_spacing", libgtk.}
proc setColumnSpacing*(box: FlowBox; spacing: cuint) {.
    importc: "gtk_flow_box_set_column_spacing", libgtk.}
proc `columnSpacing=`*(box: FlowBox; spacing: cuint) {.
    importc: "gtk_flow_box_set_column_spacing", libgtk.}
proc getColumnSpacing*(box: FlowBox): cuint {.
    importc: "gtk_flow_box_get_column_spacing", libgtk.}
proc columnSpacing*(box: FlowBox): cuint {.
    importc: "gtk_flow_box_get_column_spacing", libgtk.}
proc setMinChildrenPerLine*(box: FlowBox; nChildren: cuint) {.
    importc: "gtk_flow_box_set_min_children_per_line", libgtk.}
proc `minChildrenPerLine=`*(box: FlowBox; nChildren: cuint) {.
    importc: "gtk_flow_box_set_min_children_per_line", libgtk.}
proc getMinChildrenPerLine*(box: FlowBox): cuint {.
    importc: "gtk_flow_box_get_min_children_per_line", libgtk.}
proc minChildrenPerLine*(box: FlowBox): cuint {.
    importc: "gtk_flow_box_get_min_children_per_line", libgtk.}
proc setMaxChildrenPerLine*(box: FlowBox; nChildren: cuint) {.
    importc: "gtk_flow_box_set_max_children_per_line", libgtk.}
proc `maxChildrenPerLine=`*(box: FlowBox; nChildren: cuint) {.
    importc: "gtk_flow_box_set_max_children_per_line", libgtk.}
proc getMaxChildrenPerLine*(box: FlowBox): cuint {.
    importc: "gtk_flow_box_get_max_children_per_line", libgtk.}
proc maxChildrenPerLine*(box: FlowBox): cuint {.
    importc: "gtk_flow_box_get_max_children_per_line", libgtk.}
proc setActivateOnSingleClick*(box: FlowBox; single: Gboolean) {.
    importc: "gtk_flow_box_set_activate_on_single_click", libgtk.}
proc `activateOnSingleClick=`*(box: FlowBox; single: Gboolean) {.
    importc: "gtk_flow_box_set_activate_on_single_click", libgtk.}
proc getActivateOnSingleClick*(box: FlowBox): Gboolean {.
    importc: "gtk_flow_box_get_activate_on_single_click", libgtk.}
proc activateOnSingleClick*(box: FlowBox): Gboolean {.
    importc: "gtk_flow_box_get_activate_on_single_click", libgtk.}
proc insert*(box: FlowBox; widget: Widget; position: cint) {.
    importc: "gtk_flow_box_insert", libgtk.}
proc getChildAtIndex*(box: FlowBox; idx: cint): FlowBoxChild {.
    importc: "gtk_flow_box_get_child_at_index", libgtk.}
proc childAtIndex*(box: FlowBox; idx: cint): FlowBoxChild {.
    importc: "gtk_flow_box_get_child_at_index", libgtk.}
type
  FlowBoxForeachFunc* = proc (box: FlowBox; child: FlowBoxChild;
                              userData: Gpointer) {.cdecl.}

proc selectedForeach*(box: FlowBox; `func`: FlowBoxForeachFunc;
                               data: Gpointer) {.
    importc: "gtk_flow_box_selected_foreach", libgtk.}
proc getSelectedChildren*(box: FlowBox): glib.GList {.
    importc: "gtk_flow_box_get_selected_children", libgtk.}
proc selectedChildren*(box: FlowBox): glib.GList {.
    importc: "gtk_flow_box_get_selected_children", libgtk.}
proc selectChild*(box: FlowBox; child: FlowBoxChild) {.
    importc: "gtk_flow_box_select_child", libgtk.}
proc unselectChild*(box: FlowBox; child: FlowBoxChild) {.
    importc: "gtk_flow_box_unselect_child", libgtk.}
proc selectAll*(box: FlowBox) {.importc: "gtk_flow_box_select_all",
    libgtk.}
proc unselectAll*(box: FlowBox) {.
    importc: "gtk_flow_box_unselect_all", libgtk.}
proc setSelectionMode*(box: FlowBox; mode: SelectionMode) {.
    importc: "gtk_flow_box_set_selection_mode", libgtk.}
proc `selectionMode=`*(box: FlowBox; mode: SelectionMode) {.
    importc: "gtk_flow_box_set_selection_mode", libgtk.}
proc getSelectionMode*(box: FlowBox): SelectionMode {.
    importc: "gtk_flow_box_get_selection_mode", libgtk.}
proc selectionMode*(box: FlowBox): SelectionMode {.
    importc: "gtk_flow_box_get_selection_mode", libgtk.}
proc setHadjustment*(box: FlowBox; adjustment: Adjustment) {.
    importc: "gtk_flow_box_set_hadjustment", libgtk.}
proc `hadjustment=`*(box: FlowBox; adjustment: Adjustment) {.
    importc: "gtk_flow_box_set_hadjustment", libgtk.}
proc setVadjustment*(box: FlowBox; adjustment: Adjustment) {.
    importc: "gtk_flow_box_set_vadjustment", libgtk.}
proc `vadjustment=`*(box: FlowBox; adjustment: Adjustment) {.
    importc: "gtk_flow_box_set_vadjustment", libgtk.}
type
  FlowBoxFilterFunc* = proc (child: FlowBoxChild; userData: Gpointer): Gboolean {.cdecl.}

proc setFilterFunc*(box: FlowBox; filterFunc: FlowBoxFilterFunc;
                             userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_flow_box_set_filter_func", libgtk.}

proc `filterFunc=`*(box: FlowBox; filterFunc: FlowBoxFilterFunc;
                             userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_flow_box_set_filter_func", libgtk.}
proc invalidateFilter*(box: FlowBox) {.
    importc: "gtk_flow_box_invalidate_filter", libgtk.}
type
  FlowBoxSortFunc* = proc (child1: FlowBoxChild;
                           child2: FlowBoxChild; userData: Gpointer): cint {.cdecl.}

proc setSortFunc*(box: FlowBox; sortFunc: FlowBoxSortFunc;
                           userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_flow_box_set_sort_func", libgtk.}

proc `sortFunc=`*(box: FlowBox; sortFunc: FlowBoxSortFunc;
                           userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_flow_box_set_sort_func", libgtk.}
proc invalidateSort*(box: FlowBox) {.
    importc: "gtk_flow_box_invalidate_sort", libgtk.}

template typeFontButton*(): expr =
  (fontButtonGetType())

template fontButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFontButton, FontButtonObj))

template fontButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFontButton, FontButtonClassObj))

template isFontButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFontButton))

template isFontButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFontButton))

template fontButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeFontButton, FontButtonClassObj))

type
  FontButton* =  ptr FontButtonObj
  FontButtonPtr* = ptr FontButtonObj
  FontButtonObj* = object of ButtonObj
    priv74: pointer

  FontButtonClass* =  ptr FontButtonClassObj
  FontButtonClassPtr* = ptr FontButtonClassObj
  FontButtonClassObj*{.final.} = object of ButtonClassObj
    fontSet*: proc (gfp: FontButton) {.cdecl.}
    gtkReserved681*: proc () {.cdecl.}
    gtkReserved682*: proc () {.cdecl.}
    gtkReserved683*: proc () {.cdecl.}
    gtkReserved684*: proc () {.cdecl.}

  FontChooser* =  ptr FontChooserObj
  FontChooserPtr* = ptr FontChooserObj
  FontChooserObj* = object
type
  FontFilterFunc* = proc (family: pango.FontFamily; face: pango.FontFace;
                          data: Gpointer): Gboolean {.cdecl.}

type
  FontChooserIface* =  ptr FontChooserIfaceObj
  FontChooserIfacePtr* = ptr FontChooserIfaceObj
  FontChooserIfaceObj* = object of gobject.GTypeInterfaceObj
    getFontFamily*: proc (fontchooser: FontChooser): pango.FontFamily {.cdecl.}
    getFontFace*: proc (fontchooser: FontChooser): pango.FontFace {.cdecl.}
    getFontSize*: proc (fontchooser: FontChooser): cint {.cdecl.}
    setFilterFunc*: proc (fontchooser: FontChooser; filter: FontFilterFunc;
                        userData: Gpointer; destroy: GDestroyNotify) {.cdecl.}
    fontActivated*: proc (chooser: FontChooser; fontname: cstring) {.cdecl.}
    setFontMap*: proc (fontchooser: FontChooser; fontmap: pango.FontMap) {.cdecl.}
    getFontMap*: proc (fontchooser: FontChooser): pango.FontMap {.cdecl.}
    padding*: array[10, Gpointer]

proc fontButtonGetType*(): GType {.importc: "gtk_font_button_get_type",
                                   libgtk.}
proc newFontButton*(): FontButton {.importc: "gtk_font_button_new", libgtk.}
proc getTitle*(fontButton: FontButton): cstring {.
    importc: "gtk_font_button_get_title", libgtk.}
proc title*(fontButton: FontButton): cstring {.
    importc: "gtk_font_button_get_title", libgtk.}
proc setTitle*(fontButton: FontButton; title: cstring) {.
    importc: "gtk_font_button_set_title", libgtk.}
proc `title=`*(fontButton: FontButton; title: cstring) {.
    importc: "gtk_font_button_set_title", libgtk.}
proc getUseFont*(fontButton: FontButton): Gboolean {.
    importc: "gtk_font_button_get_use_font", libgtk.}
proc useFont*(fontButton: FontButton): Gboolean {.
    importc: "gtk_font_button_get_use_font", libgtk.}
proc setUseFont*(fontButton: FontButton; useFont: Gboolean) {.
    importc: "gtk_font_button_set_use_font", libgtk.}
proc `useFont=`*(fontButton: FontButton; useFont: Gboolean) {.
    importc: "gtk_font_button_set_use_font", libgtk.}
proc getUseSize*(fontButton: FontButton): Gboolean {.
    importc: "gtk_font_button_get_use_size", libgtk.}
proc useSize*(fontButton: FontButton): Gboolean {.
    importc: "gtk_font_button_get_use_size", libgtk.}
proc setUseSize*(fontButton: FontButton; useSize: Gboolean) {.
    importc: "gtk_font_button_set_use_size", libgtk.}
proc `useSize=`*(fontButton: FontButton; useSize: Gboolean) {.
    importc: "gtk_font_button_set_use_size", libgtk.}
proc getFontName*(fontButton: FontButton): cstring {.
    importc: "gtk_font_button_get_font_name", libgtk.}
proc fontName*(fontButton: FontButton): cstring {.
    importc: "gtk_font_button_get_font_name", libgtk.}
proc setFontName*(fontButton: FontButton; fontname: cstring): Gboolean {.
    importc: "gtk_font_button_set_font_name", libgtk.}
proc getShowStyle*(fontButton: FontButton): Gboolean {.
    importc: "gtk_font_button_get_show_style", libgtk.}
proc showStyle*(fontButton: FontButton): Gboolean {.
    importc: "gtk_font_button_get_show_style", libgtk.}
proc setShowStyle*(fontButton: FontButton; showStyle: Gboolean) {.
    importc: "gtk_font_button_set_show_style", libgtk.}
proc `showStyle=`*(fontButton: FontButton; showStyle: Gboolean) {.
    importc: "gtk_font_button_set_show_style", libgtk.}
proc getShowSize*(fontButton: FontButton): Gboolean {.
    importc: "gtk_font_button_get_show_size", libgtk.}
proc showSize*(fontButton: FontButton): Gboolean {.
    importc: "gtk_font_button_get_show_size", libgtk.}
proc setShowSize*(fontButton: FontButton; showSize: Gboolean) {.
    importc: "gtk_font_button_set_show_size", libgtk.}
proc `showSize=`*(fontButton: FontButton; showSize: Gboolean) {.
    importc: "gtk_font_button_set_show_size", libgtk.}

template typeFontChooser*(): expr =
  (fontChooserGetType())

template fontChooser*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFontChooser, FontChooserObj))

template isFontChooser*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFontChooser))

template fontChooserGetIface*(inst: expr): expr =
  (gTypeInstanceGetInterface(inst, typeFontChooser, FontChooserIfaceObj))

type
  FontChooserDialog* =  ptr FontChooserDialogObj
  FontChooserDialogPtr* = ptr FontChooserDialogObj
  FontChooserDialogObj*{.final.} = object of DialogObj
    priv75: pointer

  FontChooserDialogClass* =  ptr FontChooserDialogClassObj
  FontChooserDialogClassPtr* = ptr FontChooserDialogClassObj
  FontChooserDialogClassObj*{.final.} = object of DialogClassObj
    gtkReserved691*: proc () {.cdecl.}
    gtkReserved692*: proc () {.cdecl.}
    gtkReserved693*: proc () {.cdecl.}
    gtkReserved694*: proc () {.cdecl.}

proc fontChooserGetType*(): GType {.importc: "gtk_font_chooser_get_type",
                                    libgtk.}
proc getFontFamily*(fontchooser: FontChooser): pango.FontFamily {.
    importc: "gtk_font_chooser_get_font_family", libgtk.}
proc fontFamily*(fontchooser: FontChooser): pango.FontFamily {.
    importc: "gtk_font_chooser_get_font_family", libgtk.}
proc getFontFace*(fontchooser: FontChooser): pango.FontFace {.
    importc: "gtk_font_chooser_get_font_face", libgtk.}
proc fontFace*(fontchooser: FontChooser): pango.FontFace {.
    importc: "gtk_font_chooser_get_font_face", libgtk.}
proc getFontSize*(fontchooser: FontChooser): cint {.
    importc: "gtk_font_chooser_get_font_size", libgtk.}
proc fontSize*(fontchooser: FontChooser): cint {.
    importc: "gtk_font_chooser_get_font_size", libgtk.}
proc getFontDesc*(fontchooser: FontChooser): pango.FontDescription {.
    importc: "gtk_font_chooser_get_font_desc", libgtk.}
proc fontDesc*(fontchooser: FontChooser): pango.FontDescription {.
    importc: "gtk_font_chooser_get_font_desc", libgtk.}
proc setFontDesc*(fontchooser: FontChooser;
                               fontDesc: pango.FontDescription) {.
    importc: "gtk_font_chooser_set_font_desc", libgtk.}
proc `fontDesc=`*(fontchooser: FontChooser;
                               fontDesc: pango.FontDescription) {.
    importc: "gtk_font_chooser_set_font_desc", libgtk.}
proc getFont*(fontchooser: FontChooser): cstring {.
    importc: "gtk_font_chooser_get_font", libgtk.}
proc font*(fontchooser: FontChooser): cstring {.
    importc: "gtk_font_chooser_get_font", libgtk.}
proc setFont*(fontchooser: FontChooser; fontname: cstring) {.
    importc: "gtk_font_chooser_set_font", libgtk.}
proc `font=`*(fontchooser: FontChooser; fontname: cstring) {.
    importc: "gtk_font_chooser_set_font", libgtk.}
proc getPreviewText*(fontchooser: FontChooser): cstring {.
    importc: "gtk_font_chooser_get_preview_text", libgtk.}
proc previewText*(fontchooser: FontChooser): cstring {.
    importc: "gtk_font_chooser_get_preview_text", libgtk.}
proc setPreviewText*(fontchooser: FontChooser; text: cstring) {.
    importc: "gtk_font_chooser_set_preview_text", libgtk.}
proc `previewText=`*(fontchooser: FontChooser; text: cstring) {.
    importc: "gtk_font_chooser_set_preview_text", libgtk.}
proc getShowPreviewEntry*(fontchooser: FontChooser): Gboolean {.
    importc: "gtk_font_chooser_get_show_preview_entry", libgtk.}
proc showPreviewEntry*(fontchooser: FontChooser): Gboolean {.
    importc: "gtk_font_chooser_get_show_preview_entry", libgtk.}
proc setShowPreviewEntry*(fontchooser: FontChooser;
                                       showPreviewEntry: Gboolean) {.
    importc: "gtk_font_chooser_set_show_preview_entry", libgtk.}
proc `showPreviewEntry=`*(fontchooser: FontChooser;
                                       showPreviewEntry: Gboolean) {.
    importc: "gtk_font_chooser_set_show_preview_entry", libgtk.}
proc setFilterFunc*(fontchooser: FontChooser;
                                 filter: FontFilterFunc; userData: Gpointer;
                                 destroy: GDestroyNotify) {.
    importc: "gtk_font_chooser_set_filter_func", libgtk.}
proc `filterFunc=`*(fontchooser: FontChooser;
                                 filter: FontFilterFunc; userData: Gpointer;
                                 destroy: GDestroyNotify) {.
    importc: "gtk_font_chooser_set_filter_func", libgtk.}
proc setFontMap*(fontchooser: FontChooser;
                              fontmap: pango.FontMap) {.
    importc: "gtk_font_chooser_set_font_map", libgtk.}
proc `fontMap=`*(fontchooser: FontChooser;
                              fontmap: pango.FontMap) {.
    importc: "gtk_font_chooser_set_font_map", libgtk.}
proc getFontMap*(fontchooser: FontChooser): pango.FontMap {.
    importc: "gtk_font_chooser_get_font_map", libgtk.}
proc fontMap*(fontchooser: FontChooser): pango.FontMap {.
    importc: "gtk_font_chooser_get_font_map", libgtk.}

template typeFontChooserDialog*(): expr =
  (fontChooserDialogGetType())

template fontChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFontChooserDialog, FontChooserDialogObj))

template fontChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFontChooserDialog, FontChooserDialogClassObj))

template isFontChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFontChooserDialog))

template isFontChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFontChooserDialog))

template fontChooserDialogGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeFontChooserDialog, FontChooserDialogClassObj))

type
  FontChooserWidget* =  ptr FontChooserWidgetObj
  FontChooserWidgetPtr* = ptr FontChooserWidgetObj
  FontChooserWidgetObj*{.final.} = object of BoxObj
    priv76: pointer

  FontChooserWidgetClass* =  ptr FontChooserWidgetClassObj
  FontChooserWidgetClassPtr* = ptr FontChooserWidgetClassObj
  FontChooserWidgetClassObj*{.final.} = object of BoxClassObj
    gtkReserved701*: proc () {.cdecl.}
    gtkReserved702*: proc () {.cdecl.}
    gtkReserved703*: proc () {.cdecl.}
    gtkReserved704*: proc () {.cdecl.}
    gtkReserved705*: proc () {.cdecl.}
    gtkReserved706*: proc () {.cdecl.}
    gtkReserved707*: proc () {.cdecl.}
    gtkReserved708*: proc () {.cdecl.}

proc fontChooserDialogGetType*(): GType {.
    importc: "gtk_font_chooser_dialog_get_type", libgtk.}
proc newFontChooserDialog*(title: cstring; parent: Window): FontChooserDialog {.
    importc: "gtk_font_chooser_dialog_new", libgtk.}

template typeFontChooserWidget*(): expr =
  (fontChooserWidgetGetType())

template fontChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeFontChooserWidget, FontChooserWidgetObj))

template fontChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeFontChooserWidget, FontChooserWidgetClassObj))

template isFontChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeFontChooserWidget))

template isFontChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeFontChooserWidget))

template fontChooserWidgetGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeFontChooserWidget, FontChooserWidgetClassObj))

type
  GLArea* =  ptr GLAreaObj
  GLAreaPtr* = ptr GLAreaObj
  GLAreaObj*{.final.} = object of WidgetObj

  GLAreaClass* =  ptr GLAreaClassObj
  GLAreaClassPtr* = ptr GLAreaClassObj
  GLAreaClassObj*{.final.} = object of WidgetClassObj
    render*: proc (area: GLArea; context: gdk3.GLContext): Gboolean {.cdecl.}
    resize*: proc (area: GLArea; width: cint; height: cint) {.cdecl.}
    createContext*: proc (area: GLArea): gdk3.GLContext {.cdecl.}
    padding*: array[6, Gpointer]

  Gesture* =  ptr GestureObj
  GesturePtr* = ptr GestureObj
  GestureObj* = object

  GestureClass* =  ptr GestureClassObj
  GestureClassPtr* = ptr GestureClassObj
  GestureClassObj* = object

proc fontChooserWidgetGetType*(): GType {.
    importc: "gtk_font_chooser_widget_get_type", libgtk.}
proc newFontChooserWidget*(): FontChooserWidget {.
    importc: "gtk_font_chooser_widget_new", libgtk.}

template typeGesture*(): expr =
  (gestureGetType())

template gesture*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeGesture, GestureObj))

template gestureClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeGesture, GestureClassObj))

template isGesture*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeGesture))

template isGestureClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeGesture))

template gestureGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeGesture, GestureClassObj))

type
  GestureSingle* =  ptr GestureSingleObj
  GestureSinglePtr* = ptr GestureSingleObj
  GestureSingleObj* = object

  GestureSingleClass* =  ptr GestureSingleClassObj
  GestureSingleClassPtr* = ptr GestureSingleClassObj
  GestureSingleClassObj* = object

proc gestureGetType*(): GType {.importc: "gtk_gesture_get_type", libgtk.}
proc getDevice*(gesture: Gesture): gdk3.Device {.
    importc: "gtk_gesture_get_device", libgtk.}
proc device*(gesture: Gesture): gdk3.Device {.
    importc: "gtk_gesture_get_device", libgtk.}
proc setState*(gesture: Gesture; state: EventSequenceState): Gboolean {.
    importc: "gtk_gesture_set_state", libgtk.}
proc getSequenceState*(gesture: Gesture;
                                sequence: gdk3.EventSequence): EventSequenceState {.
    importc: "gtk_gesture_get_sequence_state", libgtk.}
proc sequenceState*(gesture: Gesture;
                                sequence: gdk3.EventSequence): EventSequenceState {.
    importc: "gtk_gesture_get_sequence_state", libgtk.}
proc setSequenceState*(gesture: Gesture;
                                sequence: gdk3.EventSequence;
                                state: EventSequenceState): Gboolean {.
    importc: "gtk_gesture_set_sequence_state", libgtk.}
proc getSequences*(gesture: Gesture): glib.GList {.
    importc: "gtk_gesture_get_sequences", libgtk.}
proc sequences*(gesture: Gesture): glib.GList {.
    importc: "gtk_gesture_get_sequences", libgtk.}
proc getLastUpdatedSequence*(gesture: Gesture): gdk3.EventSequence {.
    importc: "gtk_gesture_get_last_updated_sequence", libgtk.}
proc lastUpdatedSequence*(gesture: Gesture): gdk3.EventSequence {.
    importc: "gtk_gesture_get_last_updated_sequence", libgtk.}
proc handlesSequence*(gesture: Gesture;
                               sequence: gdk3.EventSequence): Gboolean {.
    importc: "gtk_gesture_handles_sequence", libgtk.}
proc getLastEvent*(gesture: Gesture; sequence: gdk3.EventSequence): gdk3.Event {.
    importc: "gtk_gesture_get_last_event", libgtk.}
proc lastEvent*(gesture: Gesture; sequence: gdk3.EventSequence): gdk3.Event {.
    importc: "gtk_gesture_get_last_event", libgtk.}
proc getPoint*(gesture: Gesture; sequence: gdk3.EventSequence;
                        x: var cdouble; y: var cdouble): Gboolean {.
    importc: "gtk_gesture_get_point", libgtk.}
proc point*(gesture: Gesture; sequence: gdk3.EventSequence;
                        x: var cdouble; y: var cdouble): Gboolean {.
    importc: "gtk_gesture_get_point", libgtk.}
proc getBoundingBox*(gesture: Gesture; rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_gesture_get_bounding_box", libgtk.}
proc boundingBox*(gesture: Gesture; rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_gesture_get_bounding_box", libgtk.}
proc getBoundingBoxCenter*(gesture: Gesture; x: var cdouble;
                                    y: var cdouble): Gboolean {.
    importc: "gtk_gesture_get_bounding_box_center", libgtk.}
proc boundingBoxCenter*(gesture: Gesture; x: var cdouble;
                                    y: var cdouble): Gboolean {.
    importc: "gtk_gesture_get_bounding_box_center", libgtk.}
proc isActive*(gesture: Gesture): Gboolean {.
    importc: "gtk_gesture_is_active", libgtk.}
proc isRecognized*(gesture: Gesture): Gboolean {.
    importc: "gtk_gesture_is_recognized", libgtk.}
proc getWindow*(gesture: Gesture): gdk3.Window {.
    importc: "gtk_gesture_get_window", libgtk.}
proc window*(gesture: Gesture): gdk3.Window {.
    importc: "gtk_gesture_get_window", libgtk.}
proc setWindow*(gesture: Gesture; window: gdk3.Window) {.
    importc: "gtk_gesture_set_window", libgtk.}
proc `window=`*(gesture: Gesture; window: gdk3.Window) {.
    importc: "gtk_gesture_set_window", libgtk.}
proc group*(groupGesture: Gesture; gesture: Gesture) {.
    importc: "gtk_gesture_group", libgtk.}
proc ungroup*(gesture: Gesture) {.importc: "gtk_gesture_ungroup",
    libgtk.}
proc getGroup*(gesture: Gesture): glib.GList {.
    importc: "gtk_gesture_get_group", libgtk.}
proc group*(gesture: Gesture): glib.GList {.
    importc: "gtk_gesture_get_group", libgtk.}
proc isGroupedWith*(gesture: Gesture; other: Gesture): Gboolean {.
    importc: "gtk_gesture_is_grouped_with", libgtk.}

template typeGestureSingle*(): expr =
  (gestureSingleGetType())

template gestureSingle*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeGestureSingle, GestureSingleObj))

template gestureSingleClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeGestureSingle, GestureSingleClassObj))

template isGestureSingle*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeGestureSingle))

template isGestureSingleClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeGestureSingle))

template gestureSingleGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeGestureSingle, GestureSingleClassObj))

type
  GestureDrag* =  ptr GestureDragObj
  GestureDragPtr* = ptr GestureDragObj
  GestureDragObj* = object

  GestureDragClass* =  ptr GestureDragClassObj
  GestureDragClassPtr* = ptr GestureDragClassObj
  GestureDragClassObj* = object

proc gestureSingleGetType*(): GType {.importc: "gtk_gesture_single_get_type",
                                      libgtk.}
proc getTouchOnly*(gesture: GestureSingle): Gboolean {.
    importc: "gtk_gesture_single_get_touch_only", libgtk.}
proc touchOnly*(gesture: GestureSingle): Gboolean {.
    importc: "gtk_gesture_single_get_touch_only", libgtk.}
proc setTouchOnly*(gesture: GestureSingle;
                                  touchOnly: Gboolean) {.
    importc: "gtk_gesture_single_set_touch_only", libgtk.}
proc `touchOnly=`*(gesture: GestureSingle;
                                  touchOnly: Gboolean) {.
    importc: "gtk_gesture_single_set_touch_only", libgtk.}
proc getExclusive*(gesture: GestureSingle): Gboolean {.
    importc: "gtk_gesture_single_get_exclusive", libgtk.}
proc exclusive*(gesture: GestureSingle): Gboolean {.
    importc: "gtk_gesture_single_get_exclusive", libgtk.}
proc setExclusive*(gesture: GestureSingle;
                                  exclusive: Gboolean) {.
    importc: "gtk_gesture_single_set_exclusive", libgtk.}
proc `exclusive=`*(gesture: GestureSingle;
                                  exclusive: Gboolean) {.
    importc: "gtk_gesture_single_set_exclusive", libgtk.}
proc getButton*(gesture: GestureSingle): cuint {.
    importc: "gtk_gesture_single_get_button", libgtk.}
proc button*(gesture: GestureSingle): cuint {.
    importc: "gtk_gesture_single_get_button", libgtk.}
proc setButton*(gesture: GestureSingle; button: cuint) {.
    importc: "gtk_gesture_single_set_button", libgtk.}
proc `button=`*(gesture: GestureSingle; button: cuint) {.
    importc: "gtk_gesture_single_set_button", libgtk.}
proc getCurrentButton*(gesture: GestureSingle): cuint {.
    importc: "gtk_gesture_single_get_current_button", libgtk.}
proc currentButton*(gesture: GestureSingle): cuint {.
    importc: "gtk_gesture_single_get_current_button", libgtk.}
proc getCurrentSequence*(gesture: GestureSingle): gdk3.EventSequence {.
    importc: "gtk_gesture_single_get_current_sequence", libgtk.}
proc currentSequence*(gesture: GestureSingle): gdk3.EventSequence {.
    importc: "gtk_gesture_single_get_current_sequence", libgtk.}

template typeGestureDrag*(): expr =
  (gestureDragGetType())

template gestureDrag*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeGestureDrag, GestureDragObj))

template gestureDragClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeGestureDrag, GestureDragClassObj))

template isGestureDrag*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeGestureDrag))

template isGestureDragClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeGestureDrag))

template gestureDragGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeGestureDrag, GestureDragClassObj))

type
  GestureLongPress* =  ptr GestureLongPressObj
  GestureLongPressPtr* = ptr GestureLongPressObj
  GestureLongPressObj* = object

  GestureLongPressClass* =  ptr GestureLongPressClassObj
  GestureLongPressClassPtr* = ptr GestureLongPressClassObj
  GestureLongPressClassObj* = object

proc gestureDragGetType*(): GType {.importc: "gtk_gesture_drag_get_type",
                                    libgtk.}
proc newGestureDrag*(widget: Widget): Gesture {.
    importc: "gtk_gesture_drag_new", libgtk.}
proc getStartPoint*(gesture: GestureDrag; x: var cdouble;
                                 y: var cdouble): Gboolean {.
    importc: "gtk_gesture_drag_get_start_point", libgtk.}
proc startPoint*(gesture: GestureDrag; x: var cdouble;
                                 y: var cdouble): Gboolean {.
    importc: "gtk_gesture_drag_get_start_point", libgtk.}
proc getOffset*(gesture: GestureDrag; x: var cdouble;
                             y: var cdouble): Gboolean {.
    importc: "gtk_gesture_drag_get_offset", libgtk.}
proc offset*(gesture: GestureDrag; x: var cdouble;
                             y: var cdouble): Gboolean {.
    importc: "gtk_gesture_drag_get_offset", libgtk.}

template typeGestureLongPress*(): expr =
  (gestureLongPressGetType())

template gestureLongPress*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeGestureLongPress, GestureLongPressObj))

template gestureLongPressClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeGestureLongPress, GestureLongPressClassObj))

template isGestureLongPress*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeGestureLongPress))

template isGestureLongPressClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeGestureLongPress))

template gestureLongPressGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeGestureLongPress, GestureLongPressClassObj))

type
  GestureMultiPress* =  ptr GestureMultiPressObj
  GestureMultiPressPtr* = ptr GestureMultiPressObj
  GestureMultiPressObj* = object

  GestureMultiPressClass* =  ptr GestureMultiPressClassObj
  GestureMultiPressClassPtr* = ptr GestureMultiPressClassObj
  GestureMultiPressClassObj* = object

proc gestureLongPressGetType*(): GType {.
    importc: "gtk_gesture_long_press_get_type", libgtk.}
proc newGestureLongPress*(widget: Widget): Gesture {.
    importc: "gtk_gesture_long_press_new", libgtk.}

template typeGestureMultiPress*(): expr =
  (gestureMultiPressGetType())

template gestureMultiPress*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeGestureMultiPress, GestureMultiPressObj))

template gestureMultiPressClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeGestureMultiPress, GestureMultiPressClassObj))

template isGestureMultiPress*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeGestureMultiPress))

template isGestureMultiPressClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeGestureMultiPress))

template gestureMultiPressGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeGestureMultiPress, GestureMultiPressClassObj))

type
  GesturePan* =  ptr GesturePanObj
  GesturePanPtr* = ptr GesturePanObj
  GesturePanObj* = object

  GesturePanClass* =  ptr GesturePanClassObj
  GesturePanClassPtr* = ptr GesturePanClassObj
  GesturePanClassObj* = object

proc gestureMultiPressGetType*(): GType {.
    importc: "gtk_gesture_multi_press_get_type", libgtk.}
proc newGestureMultiPress*(widget: Widget): Gesture {.
    importc: "gtk_gesture_multi_press_new", libgtk.}
proc setArea*(gesture: GestureMultiPress;
                                 rect: gdk3.Rectangle) {.
    importc: "gtk_gesture_multi_press_set_area", libgtk.}
proc `area=`*(gesture: GestureMultiPress;
                                 rect: gdk3.Rectangle) {.
    importc: "gtk_gesture_multi_press_set_area", libgtk.}
proc getArea*(gesture: GestureMultiPress;
                                 rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_gesture_multi_press_get_area", libgtk.}
proc area*(gesture: GestureMultiPress;
                                 rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_gesture_multi_press_get_area", libgtk.}

template typeGesturePan*(): expr =
  (gesturePanGetType())

template gesturePan*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeGesturePan, GesturePanObj))

template gesturePanClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeGesturePan, GesturePanClassObj))

template isGesturePan*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeGesturePan))

template isGesturePanClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeGesturePan))

template gesturePanGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeGesturePan, GesturePanClassObj))

type
  GestureRotate* =  ptr GestureRotateObj
  GestureRotatePtr* = ptr GestureRotateObj
  GestureRotateObj* = object

  GestureRotateClass* =  ptr GestureRotateClassObj
  GestureRotateClassPtr* = ptr GestureRotateClassObj
  GestureRotateClassObj* = object

proc gesturePanGetType*(): GType {.importc: "gtk_gesture_pan_get_type",
                                   libgtk.}
proc newGesturePan*(widget: Widget; orientation: Orientation): Gesture {.
    importc: "gtk_gesture_pan_new", libgtk.}
proc getOrientation*(gesture: GesturePan): Orientation {.
    importc: "gtk_gesture_pan_get_orientation", libgtk.}
proc orientation*(gesture: GesturePan): Orientation {.
    importc: "gtk_gesture_pan_get_orientation", libgtk.}
proc setOrientation*(gesture: GesturePan;
                                 orientation: Orientation) {.
    importc: "gtk_gesture_pan_set_orientation", libgtk.}
proc `orientation=`*(gesture: GesturePan;
                                 orientation: Orientation) {.
    importc: "gtk_gesture_pan_set_orientation", libgtk.}

template typeGestureRotate*(): expr =
  (gestureRotateGetType())

template gestureRotate*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeGestureRotate, GestureRotateObj))

template gestureRotateClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeGestureRotate, GestureRotateClassObj))

template isGestureRotate*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeGestureRotate))

template isGestureRotateClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeGestureRotate))

template gestureRotateGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeGestureRotate, GestureRotateClassObj))

type
  GestureSwipe* =  ptr GestureSwipeObj
  GestureSwipePtr* = ptr GestureSwipeObj
  GestureSwipeObj* = object

  GestureSwipeClass* =  ptr GestureSwipeClassObj
  GestureSwipeClassPtr* = ptr GestureSwipeClassObj
  GestureSwipeClassObj* = object

proc gestureRotateGetType*(): GType {.importc: "gtk_gesture_rotate_get_type",
                                      libgtk.}
proc newGestureRotate*(widget: Widget): Gesture {.
    importc: "gtk_gesture_rotate_new", libgtk.}
proc getAngleDelta*(gesture: GestureRotate): cdouble {.
    importc: "gtk_gesture_rotate_get_angle_delta", libgtk.}
proc angleDelta*(gesture: GestureRotate): cdouble {.
    importc: "gtk_gesture_rotate_get_angle_delta", libgtk.}

template typeGestureSwipe*(): expr =
  (gestureSwipeGetType())

template gestureSwipe*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeGestureSwipe, GestureSwipeObj))

template gestureSwipeClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeGestureSwipe, GestureSwipeClassObj))

template isGestureSwipe*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeGestureSwipe))

template isGestureSwipeClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeGestureSwipe))

template gestureSwipeGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeGestureSwipe, GestureSwipeClassObj))

type
  GestureZoom* =  ptr GestureZoomObj
  GestureZoomPtr* = ptr GestureZoomObj
  GestureZoomObj* = object

  GestureZoomClass* =  ptr GestureZoomClassObj
  GestureZoomClassPtr* = ptr GestureZoomClassObj
  GestureZoomClassObj* = object

proc gestureSwipeGetType*(): GType {.importc: "gtk_gesture_swipe_get_type",
                                     libgtk.}
proc newGestureSwipe*(widget: Widget): Gesture {.
    importc: "gtk_gesture_swipe_new", libgtk.}
proc getVelocity*(gesture: GestureSwipe;
                                velocityX: var cdouble; velocityY: var cdouble): Gboolean {.
    importc: "gtk_gesture_swipe_get_velocity", libgtk.}
proc velocity*(gesture: GestureSwipe;
                                velocityX: var cdouble; velocityY: var cdouble): Gboolean {.
    importc: "gtk_gesture_swipe_get_velocity", libgtk.}

template typeGestureZoom*(): expr =
  (gestureZoomGetType())

template gestureZoom*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeGestureZoom, GestureZoomObj))

template gestureZoomClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeGestureZoom, GestureZoomClassObj))

template isGestureZoom*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeGestureZoom))

template isGestureZoomClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeGestureZoom))

template gestureZoomGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeGestureZoom, GestureZoomClassObj))

proc gestureZoomGetType*(): GType {.importc: "gtk_gesture_zoom_get_type",
                                    libgtk.}
proc newGestureZoom*(widget: Widget): Gesture {.
    importc: "gtk_gesture_zoom_new", libgtk.}
proc getScaleDelta*(gesture: GestureZoom): cdouble {.
    importc: "gtk_gesture_zoom_get_scale_delta", libgtk.}
proc scaleDelta*(gesture: GestureZoom): cdouble {.
    importc: "gtk_gesture_zoom_get_scale_delta", libgtk.}

template typeGlArea*(): expr =
  (glAreaGetType())

template glArea*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeGlArea, GLAreaObj))

template isGlArea*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeGlArea))

template glAreaClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeGlArea, GLAreaClassObj))

template isGlAreaClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeGlArea))

template glAreaGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeGlArea, GLAreaClassObj))

type
  Grid* =  ptr GridObj
  GridPtr* = ptr GridObj
  GridObj*{.final.} = object of ContainerObj
    priv77: pointer

  GridClass* =  ptr GridClassObj
  GridClassPtr* = ptr GridClassObj
  GridClassObj*{.final.} = object of ContainerClassObj
    gtkReserved711*: proc () {.cdecl.}
    gtkReserved712*: proc () {.cdecl.}
    gtkReserved713*: proc () {.cdecl.}
    gtkReserved714*: proc () {.cdecl.}
    gtkReserved715*: proc () {.cdecl.}
    gtkReserved716*: proc () {.cdecl.}
    gtkReserved717*: proc () {.cdecl.}
    gtkReserved718*: proc () {.cdecl.}

proc glAreaGetType*(): GType {.importc: "gtk_gl_area_get_type", libgtk.}
proc newGlArea*(): GlArea {.importc: "gtk_gl_area_new", libgtk.}
proc glAreaSetRequiredVersion*(area: GLArea; major: cint; minor: cint) {.
    importc: "gtk_gl_area_set_required_version", libgtk.}
proc glAreaGetRequiredVersion*(area: GLArea; major: var cint; minor: var cint) {.
    importc: "gtk_gl_area_get_required_version", libgtk.}
proc glAreaGetHasAlpha*(area: GLArea): Gboolean {.
    importc: "gtk_gl_area_get_has_alpha", libgtk.}
proc glAreaSetHasAlpha*(area: GLArea; hasAlpha: Gboolean) {.
    importc: "gtk_gl_area_set_has_alpha", libgtk.}
proc glAreaGetHasDepthBuffer*(area: GLArea): Gboolean {.
    importc: "gtk_gl_area_get_has_depth_buffer", libgtk.}
proc glAreaSetHasDepthBuffer*(area: GLArea; hasDepthBuffer: Gboolean) {.
    importc: "gtk_gl_area_set_has_depth_buffer", libgtk.}
proc glAreaGetHasStencilBuffer*(area: GLArea): Gboolean {.
    importc: "gtk_gl_area_get_has_stencil_buffer", libgtk.}
proc glAreaSetHasStencilBuffer*(area: GLArea; hasStencilBuffer: Gboolean) {.
    importc: "gtk_gl_area_set_has_stencil_buffer", libgtk.}
proc glAreaGetAutoRender*(area: GLArea): Gboolean {.
    importc: "gtk_gl_area_get_auto_render", libgtk.}
proc glAreaSetAutoRender*(area: GLArea; autoRender: Gboolean) {.
    importc: "gtk_gl_area_set_auto_render", libgtk.}
proc glAreaQueueRender*(area: GLArea) {.
    importc: "gtk_gl_area_queue_render", libgtk.}
proc glAreaGetContext*(area: GLArea): gdk3.GLContext {.
    importc: "gtk_gl_area_get_context", libgtk.}
proc glAreaMakeCurrent*(area: GLArea) {.
    importc: "gtk_gl_area_make_current", libgtk.}
proc glAreaAttachBuffers*(area: GLArea) {.
    importc: "gtk_gl_area_attach_buffers", libgtk.}
proc glAreaSetError*(area: GLArea; error: glib.GError) {.
    importc: "gtk_gl_area_set_error", libgtk.}
proc glAreaGetError*(area: GLArea): glib.GError {.
    importc: "gtk_gl_area_get_error", libgtk.}

template typeGrid*(): expr =
  (gridGetType())

template grid*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeGrid, GridObj))

template gridClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeGrid, GridClassObj))

template isGrid*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeGrid))

template isGridClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeGrid))

template gridGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeGrid, GridClassObj))

type
  HeaderBar* =  ptr HeaderBarObj
  HeaderBarPtr* = ptr HeaderBarObj
  HeaderBarObj*{.final.} = object of ContainerObj

  HeaderBarClass* =  ptr HeaderBarClassObj
  HeaderBarClassPtr* = ptr HeaderBarClassObj
  HeaderBarClassObj*{.final.} = object of ContainerClassObj
    gtkReserved721*: proc () {.cdecl.}
    gtkReserved722*: proc () {.cdecl.}
    gtkReserved723*: proc () {.cdecl.}
    gtkReserved724*: proc () {.cdecl.}

proc gridGetType*(): GType {.importc: "gtk_grid_get_type", libgtk.}
proc newGrid*(): Grid {.importc: "gtk_grid_new", libgtk.}
proc attach*(grid: Grid; child: Widget; left: cint; top: cint;
                   width: cint; height: cint) {.importc: "gtk_grid_attach",
    libgtk.}
proc attachNextTo*(grid: Grid; child: Widget;
                         sibling: Widget; side: PositionType; width: cint;
                         height: cint) {.importc: "gtk_grid_attach_next_to",
                                       libgtk.}
proc getChildAt*(grid: Grid; left: cint; top: cint): Widget {.
    importc: "gtk_grid_get_child_at", libgtk.}
proc childAt*(grid: Grid; left: cint; top: cint): Widget {.
    importc: "gtk_grid_get_child_at", libgtk.}
proc insertRow*(grid: Grid; position: cint) {.
    importc: "gtk_grid_insert_row", libgtk.}
proc insertColumn*(grid: Grid; position: cint) {.
    importc: "gtk_grid_insert_column", libgtk.}
proc removeRow*(grid: Grid; position: cint) {.
    importc: "gtk_grid_remove_row", libgtk.}
proc removeColumn*(grid: Grid; position: cint) {.
    importc: "gtk_grid_remove_column", libgtk.}
proc insertNextTo*(grid: Grid; sibling: Widget;
                         side: PositionType) {.
    importc: "gtk_grid_insert_next_to", libgtk.}
proc setRowHomogeneous*(grid: Grid; homogeneous: Gboolean) {.
    importc: "gtk_grid_set_row_homogeneous", libgtk.}
proc `rowHomogeneous=`*(grid: Grid; homogeneous: Gboolean) {.
    importc: "gtk_grid_set_row_homogeneous", libgtk.}
proc getRowHomogeneous*(grid: Grid): Gboolean {.
    importc: "gtk_grid_get_row_homogeneous", libgtk.}
proc rowHomogeneous*(grid: Grid): Gboolean {.
    importc: "gtk_grid_get_row_homogeneous", libgtk.}
proc setRowSpacing*(grid: Grid; spacing: cuint) {.
    importc: "gtk_grid_set_row_spacing", libgtk.}
proc `rowSpacing=`*(grid: Grid; spacing: cuint) {.
    importc: "gtk_grid_set_row_spacing", libgtk.}
proc getRowSpacing*(grid: Grid): cuint {.
    importc: "gtk_grid_get_row_spacing", libgtk.}
proc rowSpacing*(grid: Grid): cuint {.
    importc: "gtk_grid_get_row_spacing", libgtk.}
proc setColumnHomogeneous*(grid: Grid; homogeneous: Gboolean) {.
    importc: "gtk_grid_set_column_homogeneous", libgtk.}
proc `columnHomogeneous=`*(grid: Grid; homogeneous: Gboolean) {.
    importc: "gtk_grid_set_column_homogeneous", libgtk.}
proc getColumnHomogeneous*(grid: Grid): Gboolean {.
    importc: "gtk_grid_get_column_homogeneous", libgtk.}
proc columnHomogeneous*(grid: Grid): Gboolean {.
    importc: "gtk_grid_get_column_homogeneous", libgtk.}
proc setColumnSpacing*(grid: Grid; spacing: cuint) {.
    importc: "gtk_grid_set_column_spacing", libgtk.}
proc `columnSpacing=`*(grid: Grid; spacing: cuint) {.
    importc: "gtk_grid_set_column_spacing", libgtk.}
proc getColumnSpacing*(grid: Grid): cuint {.
    importc: "gtk_grid_get_column_spacing", libgtk.}
proc columnSpacing*(grid: Grid): cuint {.
    importc: "gtk_grid_get_column_spacing", libgtk.}
proc setRowBaselinePosition*(grid: Grid; row: cint;
                                   pos: BaselinePosition) {.
    importc: "gtk_grid_set_row_baseline_position", libgtk.}
proc `rowBaselinePosition=`*(grid: Grid; row: cint;
                                   pos: BaselinePosition) {.
    importc: "gtk_grid_set_row_baseline_position", libgtk.}
proc getRowBaselinePosition*(grid: Grid; row: cint): BaselinePosition {.
    importc: "gtk_grid_get_row_baseline_position", libgtk.}
proc rowBaselinePosition*(grid: Grid; row: cint): BaselinePosition {.
    importc: "gtk_grid_get_row_baseline_position", libgtk.}
proc setBaselineRow*(grid: Grid; row: cint) {.
    importc: "gtk_grid_set_baseline_row", libgtk.}
proc `baselineRow=`*(grid: Grid; row: cint) {.
    importc: "gtk_grid_set_baseline_row", libgtk.}
proc getBaselineRow*(grid: Grid): cint {.
    importc: "gtk_grid_get_baseline_row", libgtk.}
proc baselineRow*(grid: Grid): cint {.
    importc: "gtk_grid_get_baseline_row", libgtk.}

template typeHeaderBar*(): expr =
  (headerBarGetType())

template headerBar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeHeaderBar, HeaderBarObj))

template headerBarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeHeaderBar, HeaderBarClassObj))

template isHeaderBar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeHeaderBar))

template isHeaderBarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeHeaderBar))

template headerBarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeHeaderBar, HeaderBarClassObj))

type
  IconFactoryClass* =  ptr IconFactoryClassObj
  IconFactoryClassPtr* = ptr IconFactoryClassObj
  IconFactoryClassObj*{.final.} = object of GObjectClassObj
    gtkReserved731*: proc () {.cdecl.}
    gtkReserved732*: proc () {.cdecl.}
    gtkReserved733*: proc () {.cdecl.}
    gtkReserved734*: proc () {.cdecl.}

proc headerBarGetType*(): GType {.importc: "gtk_header_bar_get_type", libgtk.}
proc newHeaderBar*(): HeaderBar {.importc: "gtk_header_bar_new", libgtk.}
proc setTitle*(bar: HeaderBar; title: cstring) {.
    importc: "gtk_header_bar_set_title", libgtk.}
proc `title=`*(bar: HeaderBar; title: cstring) {.
    importc: "gtk_header_bar_set_title", libgtk.}
proc getTitle*(bar: HeaderBar): cstring {.
    importc: "gtk_header_bar_get_title", libgtk.}
proc title*(bar: HeaderBar): cstring {.
    importc: "gtk_header_bar_get_title", libgtk.}
proc setSubtitle*(bar: HeaderBar; subtitle: cstring) {.
    importc: "gtk_header_bar_set_subtitle", libgtk.}
proc `subtitle=`*(bar: HeaderBar; subtitle: cstring) {.
    importc: "gtk_header_bar_set_subtitle", libgtk.}
proc getSubtitle*(bar: HeaderBar): cstring {.
    importc: "gtk_header_bar_get_subtitle", libgtk.}
proc subtitle*(bar: HeaderBar): cstring {.
    importc: "gtk_header_bar_get_subtitle", libgtk.}
proc setCustomTitle*(bar: HeaderBar; titleWidget: Widget) {.
    importc: "gtk_header_bar_set_custom_title", libgtk.}
proc `customTitle=`*(bar: HeaderBar; titleWidget: Widget) {.
    importc: "gtk_header_bar_set_custom_title", libgtk.}
proc getCustomTitle*(bar: HeaderBar): Widget {.
    importc: "gtk_header_bar_get_custom_title", libgtk.}
proc customTitle*(bar: HeaderBar): Widget {.
    importc: "gtk_header_bar_get_custom_title", libgtk.}
proc packStart*(bar: HeaderBar; child: Widget) {.
    importc: "gtk_header_bar_pack_start", libgtk.}
proc packEnd*(bar: HeaderBar; child: Widget) {.
    importc: "gtk_header_bar_pack_end", libgtk.}
proc getShowCloseButton*(bar: HeaderBar): Gboolean {.
    importc: "gtk_header_bar_get_show_close_button", libgtk.}
proc showCloseButton*(bar: HeaderBar): Gboolean {.
    importc: "gtk_header_bar_get_show_close_button", libgtk.}
proc setShowCloseButton*(bar: HeaderBar; setting: Gboolean) {.
    importc: "gtk_header_bar_set_show_close_button", libgtk.}
proc `showCloseButton=`*(bar: HeaderBar; setting: Gboolean) {.
    importc: "gtk_header_bar_set_show_close_button", libgtk.}
proc setHasSubtitle*(bar: HeaderBar; setting: Gboolean) {.
    importc: "gtk_header_bar_set_has_subtitle", libgtk.}
proc `hasSubtitle=`*(bar: HeaderBar; setting: Gboolean) {.
    importc: "gtk_header_bar_set_has_subtitle", libgtk.}
proc getHasSubtitle*(bar: HeaderBar): Gboolean {.
    importc: "gtk_header_bar_get_has_subtitle", libgtk.}
proc hasSubtitle*(bar: HeaderBar): Gboolean {.
    importc: "gtk_header_bar_get_has_subtitle", libgtk.}
proc setDecorationLayout*(bar: HeaderBar; layout: cstring) {.
    importc: "gtk_header_bar_set_decoration_layout", libgtk.}
proc `decorationLayout=`*(bar: HeaderBar; layout: cstring) {.
    importc: "gtk_header_bar_set_decoration_layout", libgtk.}
proc getDecorationLayout*(bar: HeaderBar): cstring {.
    importc: "gtk_header_bar_get_decoration_layout", libgtk.}
proc decorationLayout*(bar: HeaderBar): cstring {.
    importc: "gtk_header_bar_get_decoration_layout", libgtk.}

template typeIconFactory*(): expr =
  (iconFactoryGetType())

template iconFactory*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeIconFactory, IconFactoryObj))

template iconFactoryClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeIconFactory, IconFactoryClassObj))

template isIconFactory*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeIconFactory))

template isIconFactoryClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeIconFactory))

template iconFactoryGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeIconFactory, IconFactoryClassObj))

template typeIconSet*(): expr =
  (iconSetGetType())

template typeIconSource*(): expr =
  (iconSourceGetType())

type
  StyleProperties* =  ptr StylePropertiesObj
  StylePropertiesPtr* = ptr StylePropertiesObj
  StylePropertiesObj*{.final.} = object of GObjectObj
    priv78: pointer

  StylePropertiesClass* =  ptr StylePropertiesClassObj
  StylePropertiesClassPtr* = ptr StylePropertiesClassObj
  StylePropertiesClassObj*{.final.} = object of GObjectClassObj
    gtkReserved741*: proc () {.cdecl.}
    gtkReserved742*: proc () {.cdecl.}
    gtkReserved743*: proc () {.cdecl.}
    gtkReserved744*: proc () {.cdecl.}

proc iconFactoryGetType*(): GType {.importc: "gtk_icon_factory_get_type",
                                    libgtk.}
proc newIconFactory*(): IconFactory {.importc: "gtk_icon_factory_new",
    libgtk.}
proc add*(factory: IconFactory; stockId: cstring;
                       iconSet: IconSet) {.importc: "gtk_icon_factory_add",
    libgtk.}
proc lookup*(factory: IconFactory; stockId: cstring): IconSet {.
    importc: "gtk_icon_factory_lookup", libgtk.}

proc addDefault*(factory: IconFactory) {.
    importc: "gtk_icon_factory_add_default", libgtk.}
proc removeDefault*(factory: IconFactory) {.
    importc: "gtk_icon_factory_remove_default", libgtk.}
proc iconFactoryLookupDefault*(stockId: cstring): IconSet {.
    importc: "gtk_icon_factory_lookup_default", libgtk.}

when not GDK_MULTIHEAD_SAFE:
  proc lookup*(size: IconSize; width: var cint; height: var cint): Gboolean {.
      importc: "gtk_icon_size_lookup", libgtk.}
proc iconSizeLookupForSettings*(settings: Settings; size: IconSize;
                                  width: var cint; height: var cint): Gboolean {.
    importc: "gtk_icon_size_lookup_for_settings", libgtk.}
proc iconSizeRegister*(name: cstring; width: cint; height: cint): IconSize {.
    importc: "gtk_icon_size_register", libgtk.}
proc iconSizeRegisterAlias*(alias: cstring; target: IconSize) {.
    importc: "gtk_icon_size_register_alias", libgtk.}
proc iconSizeFromName*(name: cstring): IconSize {.
    importc: "gtk_icon_size_from_name", libgtk.}
proc getName*(size: IconSize): cstring {.
    importc: "gtk_icon_size_get_name", libgtk.}
proc name*(size: IconSize): cstring {.
    importc: "gtk_icon_size_get_name", libgtk.}

proc iconSetGetType*(): GType {.importc: "gtk_icon_set_get_type", libgtk.}
proc newIconSet*(): IconSet {.importc: "gtk_icon_set_new", libgtk.}
proc newIconSet*(pixbuf: GdkPixbuf): IconSet {.
    importc: "gtk_icon_set_new_from_pixbuf", libgtk.}
proc `ref`*(iconSet: IconSet): IconSet {.
    importc: "gtk_icon_set_ref", libgtk.}
proc unref*(iconSet: IconSet) {.importc: "gtk_icon_set_unref",
    libgtk.}
proc copy*(iconSet: IconSet): IconSet {.
    importc: "gtk_icon_set_copy", libgtk.}
proc renderIcon*(iconSet: IconSet; style: Style;
                          direction: TextDirection; state: StateType;
                          size: IconSize; widget: Widget; detail: cstring): GdkPixbuf {.
    importc: "gtk_icon_set_render_icon", libgtk.}
proc addSource*(iconSet: IconSet; source: IconSource) {.
    importc: "gtk_icon_set_add_source", libgtk.}
proc getSizes*(iconSet: IconSet; sizes: var ptr IconSize;
                        nSizes: var cint) {.importc: "gtk_icon_set_get_sizes",
    libgtk.}
proc iconSourceGetType*(): GType {.importc: "gtk_icon_source_get_type",
                                   libgtk.}
proc newIconSource*(): IconSource {.importc: "gtk_icon_source_new",
    libgtk.}
proc copy*(source: IconSource): IconSource {.
    importc: "gtk_icon_source_copy", libgtk.}
proc free*(source: IconSource) {.
    importc: "gtk_icon_source_free", libgtk.}
proc setFilename*(source: IconSource; filename: cstring) {.
    importc: "gtk_icon_source_set_filename", libgtk.}
proc `filename=`*(source: IconSource; filename: cstring) {.
    importc: "gtk_icon_source_set_filename", libgtk.}
proc setIconName*(source: IconSource; iconName: cstring) {.
    importc: "gtk_icon_source_set_icon_name", libgtk.}
proc `iconName=`*(source: IconSource; iconName: cstring) {.
    importc: "gtk_icon_source_set_icon_name", libgtk.}
proc setPixbuf*(source: IconSource; pixbuf: GdkPixbuf) {.
    importc: "gtk_icon_source_set_pixbuf", libgtk.}
proc `pixbuf=`*(source: IconSource; pixbuf: GdkPixbuf) {.
    importc: "gtk_icon_source_set_pixbuf", libgtk.}
proc getFilename*(source: IconSource): cstring {.
    importc: "gtk_icon_source_get_filename", libgtk.}
proc filename*(source: IconSource): cstring {.
    importc: "gtk_icon_source_get_filename", libgtk.}
proc getIconName*(source: IconSource): cstring {.
    importc: "gtk_icon_source_get_icon_name", libgtk.}
proc iconName*(source: IconSource): cstring {.
    importc: "gtk_icon_source_get_icon_name", libgtk.}
proc getPixbuf*(source: IconSource): GdkPixbuf {.
    importc: "gtk_icon_source_get_pixbuf", libgtk.}
proc pixbuf*(source: IconSource): GdkPixbuf {.
    importc: "gtk_icon_source_get_pixbuf", libgtk.}
proc setDirectionWildcarded*(source: IconSource;
    setting: Gboolean) {.importc: "gtk_icon_source_set_direction_wildcarded",
                       libgtk.}
proc `directionWildcarded=`*(source: IconSource;
    setting: Gboolean) {.importc: "gtk_icon_source_set_direction_wildcarded",
                       libgtk.}
proc setStateWildcarded*(source: IconSource; setting: Gboolean) {.
    importc: "gtk_icon_source_set_state_wildcarded", libgtk.}
proc `stateWildcarded=`*(source: IconSource; setting: Gboolean) {.
    importc: "gtk_icon_source_set_state_wildcarded", libgtk.}
proc setSizeWildcarded*(source: IconSource; setting: Gboolean) {.
    importc: "gtk_icon_source_set_size_wildcarded", libgtk.}
proc `sizeWildcarded=`*(source: IconSource; setting: Gboolean) {.
    importc: "gtk_icon_source_set_size_wildcarded", libgtk.}
proc getSizeWildcarded*(source: IconSource): Gboolean {.
    importc: "gtk_icon_source_get_size_wildcarded", libgtk.}
proc sizeWildcarded*(source: IconSource): Gboolean {.
    importc: "gtk_icon_source_get_size_wildcarded", libgtk.}
proc getStateWildcarded*(source: IconSource): Gboolean {.
    importc: "gtk_icon_source_get_state_wildcarded", libgtk.}
proc stateWildcarded*(source: IconSource): Gboolean {.
    importc: "gtk_icon_source_get_state_wildcarded", libgtk.}
proc getDirectionWildcarded*(source: IconSource): Gboolean {.
    importc: "gtk_icon_source_get_direction_wildcarded", libgtk.}
proc directionWildcarded*(source: IconSource): Gboolean {.
    importc: "gtk_icon_source_get_direction_wildcarded", libgtk.}
proc setDirection*(source: IconSource;
                               direction: TextDirection) {.
    importc: "gtk_icon_source_set_direction", libgtk.}
proc `direction=`*(source: IconSource;
                               direction: TextDirection) {.
    importc: "gtk_icon_source_set_direction", libgtk.}
proc setState*(source: IconSource; state: StateType) {.
    importc: "gtk_icon_source_set_state", libgtk.}
proc `state=`*(source: IconSource; state: StateType) {.
    importc: "gtk_icon_source_set_state", libgtk.}
proc setSize*(source: IconSource; size: IconSize) {.
    importc: "gtk_icon_source_set_size", libgtk.}
proc `size=`*(source: IconSource; size: IconSize) {.
    importc: "gtk_icon_source_set_size", libgtk.}
proc getDirection*(source: IconSource): TextDirection {.
    importc: "gtk_icon_source_get_direction", libgtk.}
proc direction*(source: IconSource): TextDirection {.
    importc: "gtk_icon_source_get_direction", libgtk.}
proc getState*(source: IconSource): StateType {.
    importc: "gtk_icon_source_get_state", libgtk.}
proc state*(source: IconSource): StateType {.
    importc: "gtk_icon_source_get_state", libgtk.}
proc getSize*(source: IconSource): IconSize {.
    importc: "gtk_icon_source_get_size", libgtk.}
proc size*(source: IconSource): IconSize {.
    importc: "gtk_icon_source_get_size", libgtk.}

template typeStyleProperties*(): expr =
  (stylePropertiesGetType())

template styleProperties*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeStyleProperties, StylePropertiesObj))

template stylePropertiesClass*(c: expr): expr =
  (gTypeCheckClassCast(c, typeStyleProperties, StylePropertiesClassObj))

template isStyleProperties*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeStyleProperties))

template isStylePropertiesClass*(c: expr): expr =
  (gTypeCheckClassType(c, typeStyleProperties))

template stylePropertiesGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeStyleProperties, StylePropertiesClassObj))

type
  SymbolicColor* =  ptr SymbolicColorObj
  SymbolicColorPtr* = ptr SymbolicColorObj
  SymbolicColorObj* = object

  Gradient* =  ptr GradientObj
  GradientPtr* = ptr GradientObj
  GradientObj* = object

  StyleProvider* =  ptr StyleProviderObj
  StyleProviderPtr* = ptr StyleProviderObj
  StyleProviderObj* = object

type
  StyleProviderIface* =  ptr StyleProviderIfaceObj
  StyleProviderIfacePtr* = ptr StyleProviderIfaceObj
  StyleProviderIfaceObj* = object of gobject.GTypeInterfaceObj
    getStyle*: proc (provider: StyleProvider; path: WidgetPath): StyleProperties {.cdecl.}
    getStyleProperty*: proc (provider: StyleProvider; path: WidgetPath;
                           state: StateFlags; pspec: gobject.GParamSpec;
                           value: gobject.GValue): Gboolean {.cdecl.}
    getIconFactory*: proc (provider: StyleProvider; path: WidgetPath): IconFactory {.cdecl.}

  StylePropertyParser* = proc (string: cstring; value: gobject.GValue;
                               error: var glib.GError): Gboolean {.cdecl.}

proc stylePropertiesGetType*(): GType {.importc: "gtk_style_properties_get_type",
                                        libgtk.}

proc stylePropertiesRegisterProperty*(parseFunc: StylePropertyParser;
                                        pspec: gobject.GParamSpec) {.
    importc: "gtk_style_properties_register_property", libgtk.}
proc stylePropertiesLookupProperty*(propertyName: cstring;
                                      parseFunc: ptr StylePropertyParser;
                                      pspec: var gobject.GParamSpec): Gboolean {.
    importc: "gtk_style_properties_lookup_property", libgtk.}
proc newStyleProperties*(): StyleProperties {.
    importc: "gtk_style_properties_new", libgtk.}
proc mapColor*(props: StyleProperties; name: cstring;
                                color: SymbolicColor) {.
    importc: "gtk_style_properties_map_color", libgtk.}
proc lookupColor*(props: StyleProperties; name: cstring): SymbolicColor {.
    importc: "gtk_style_properties_lookup_color", libgtk.}
proc setProperty*(props: StyleProperties;
                                   property: cstring; state: StateFlags;
                                   value: gobject.GValue) {.
    importc: "gtk_style_properties_set_property", libgtk.}
proc `property=`*(props: StyleProperties;
                                   property: cstring; state: StateFlags;
                                   value: gobject.GValue) {.
    importc: "gtk_style_properties_set_property", libgtk.}

discard """ proc "setValist*(props: StyleProperties;
                                 state: StateFlags; args: VaList) {.
    importc: "gtk_style_properties_set_valist", libgtk.}"""

proc set*(props: StyleProperties; state: StateFlags) {.
    varargs, importc: "gtk_style_properties_set", libgtk.}
proc getProperty*(props: StyleProperties;
                                   property: cstring; state: StateFlags;
                                   value: gobject.GValue): Gboolean {.
    importc: "gtk_style_properties_get_property", libgtk.}
proc property*(props: StyleProperties;
                                   property: cstring; state: StateFlags;
                                   value: gobject.GValue): Gboolean {.
    importc: "gtk_style_properties_get_property", libgtk.}

discard """ proc "getValist*(props: StyleProperties;
                                 state: StateFlags; args: VaList) {.
    importc: "gtk_style_properties_get_valist", libgtk.}"""

proc get*(props: StyleProperties; state: StateFlags) {.
    varargs, importc: "gtk_style_properties_get", libgtk.}
proc unsetProperty*(props: StyleProperties;
                                     property: cstring; state: StateFlags) {.
    importc: "gtk_style_properties_unset_property", libgtk.}
proc clear*(props: StyleProperties) {.
    importc: "gtk_style_properties_clear", libgtk.}
proc merge*(props: StyleProperties;
                             propsToMerge: StyleProperties;
                             replace: Gboolean) {.
    importc: "gtk_style_properties_merge", libgtk.}

template typeStyleProvider*(): expr =
  (styleProviderGetType())

template styleProvider*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeStyleProvider, StyleProviderObj))

template isStyleProvider*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeStyleProvider))

template styleProviderGetIface*(o: expr): expr =
  (gTypeInstanceGetInterface(o, typeStyleProvider, StyleProviderIfaceObj))

const
  STYLE_PROVIDER_PRIORITY_FALLBACK* = 1

const
  STYLE_PROVIDER_PRIORITY_THEME* = 200

const
  STYLE_PROVIDER_PRIORITY_SETTINGS* = 400

const
  STYLE_PROVIDER_PRIORITY_APPLICATION* = 600

const
  STYLE_PROVIDER_PRIORITY_USER* = 800

type
  StyleContextClass* =  ptr StyleContextClassObj
  StyleContextClassPtr* = ptr StyleContextClassObj
  StyleContextClassObj*{.final.} = object of GObjectClassObj
    changed*: proc (context: StyleContext) {.cdecl.}
    gtkReserved751*: proc () {.cdecl.}
    gtkReserved752*: proc () {.cdecl.}
    gtkReserved753*: proc () {.cdecl.}
    gtkReserved754*: proc () {.cdecl.}

proc styleProviderGetType*(): GType {.importc: "gtk_style_provider_get_type",
                                      libgtk.}
proc getStyle*(provider: StyleProvider;
                              path: WidgetPath): StyleProperties {.
    importc: "gtk_style_provider_get_style", libgtk.}
proc style*(provider: StyleProvider;
                              path: WidgetPath): StyleProperties {.
    importc: "gtk_style_provider_get_style", libgtk.}
proc getStyleProperty*(provider: StyleProvider;
                                      path: WidgetPath;
                                      state: StateFlags; pspec: gobject.GParamSpec;
                                      value: gobject.GValue): Gboolean {.
    importc: "gtk_style_provider_get_style_property", libgtk.}
proc styleProperty*(provider: StyleProvider;
                                      path: WidgetPath;
                                      state: StateFlags; pspec: gobject.GParamSpec;
                                      value: gobject.GValue): Gboolean {.
    importc: "gtk_style_provider_get_style_property", libgtk.}
proc getIconFactory*(provider: StyleProvider;
                                    path: WidgetPath): IconFactory {.
    importc: "gtk_style_provider_get_icon_factory", libgtk.}
proc iconFactory*(provider: StyleProvider;
                                    path: WidgetPath): IconFactory {.
    importc: "gtk_style_provider_get_icon_factory", libgtk.}

template typeStyleContext*(): expr =
  (styleContextGetType())

template styleContext*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeStyleContext, StyleContextObj))

template styleContextClass*(c: expr): expr =
  (gTypeCheckClassCast(c, typeStyleContext, StyleContextClassObj))

template isStyleContext*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeStyleContext))

template isStyleContextClass*(c: expr): expr =
  (gTypeCheckClassType(c, typeStyleContext))

template styleContextGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeStyleContext, StyleContextClassObj))

const
  STYLE_PROPERTY_BACKGROUND_COLOR* = "background-color"

const
  STYLE_PROPERTY_COLOR* = "color"

const
  STYLE_PROPERTY_FONT* = "font"

const
  STYLE_PROPERTY_PADDING* = "padding"

const
  STYLE_PROPERTY_BORDER_WIDTH* = "border-width"

const
  STYLE_PROPERTY_MARGIN* = "margin"

const
  STYLE_PROPERTY_BORDER_RADIUS* = "border-radius"

const
  STYLE_PROPERTY_BORDER_STYLE* = "border-style"

const
  STYLE_PROPERTY_BORDER_COLOR* = "border-color"

const
  STYLE_PROPERTY_BACKGROUND_IMAGE* = "background-image"

const
  STYLE_CLASS_CELL* = "cell"

const
  STYLE_CLASS_DIM_LABEL* = "dim-label"

const
  STYLE_CLASS_ENTRY* = "entry"

const
  STYLE_CLASS_LABEL* = "label"

const
  STYLE_CLASS_COMBOBOX_ENTRY* = "combobox-entry"

const
  STYLE_CLASS_BUTTON* = "button"

const
  STYLE_CLASS_LIST* = "list"

const
  STYLE_CLASS_LIST_ROW* = "list-row"

const
  STYLE_CLASS_CALENDAR* = "calendar"

const
  STYLE_CLASS_SLIDER* = "slider"

const
  STYLE_CLASS_BACKGROUND* = "background"

const
  STYLE_CLASS_RUBBERBAND* = "rubberband"

const
  STYLE_CLASS_CSD* = "csd"

const
  STYLE_CLASS_TOOLTIP* = "tooltip"

const
  STYLE_CLASS_MENU* = "menu"

const
  STYLE_CLASS_CONTEXT_MENU* = "context-menu"

const
  STYLE_CLASS_TOUCH_SELECTION* = "touch-selection"

const
  STYLE_CLASS_MENUBAR* = "menubar"

const
  STYLE_CLASS_MENUITEM* = "menuitem"

const
  STYLE_CLASS_TOOLBAR* = "toolbar"

const
  STYLE_CLASS_PRIMARY_TOOLBAR* = "primary-toolbar"

const
  STYLE_CLASS_INLINE_TOOLBAR* = "inline-toolbar"

const
  STYLE_CLASS_STATUSBAR* = "statusbar"

const
  STYLE_CLASS_RADIO* = "radio"

const
  STYLE_CLASS_CHECK* = "check"

const
  STYLE_CLASS_DEFAULT* = "default"

const
  STYLE_CLASS_TROUGH* = "trough"

const
  STYLE_CLASS_SCROLLBAR* = "scrollbar"

const
  STYLE_CLASS_SCROLLBARS_JUNCTION* = "scrollbars-junction"

const
  STYLE_CLASS_SCALE* = "scale"

const
  STYLE_CLASS_SCALE_HAS_MARKS_ABOVE* = "scale-has-marks-above"

const
  STYLE_CLASS_SCALE_HAS_MARKS_BELOW* = "scale-has-marks-below"

const
  STYLE_CLASS_HEADER* = "header"

const
  STYLE_CLASS_ACCELERATOR* = "accelerator"

const
  STYLE_CLASS_RAISED* = "raised"

const
  STYLE_CLASS_LINKED* = "linked"

const
  STYLE_CLASS_GRIP* = "grip"

const
  STYLE_CLASS_DOCK* = "dock"

const
  STYLE_CLASS_PROGRESSBAR* = "progressbar"

const
  STYLE_CLASS_SPINNER* = "spinner"

const
  STYLE_CLASS_MARK* = "mark"

const
  STYLE_CLASS_EXPANDER* = "expander"

const
  STYLE_CLASS_SPINBUTTON* = "spinbutton"

const
  STYLE_CLASS_NOTEBOOK* = "notebook"

const
  STYLE_CLASS_VIEW* = "view"

const
  STYLE_CLASS_SIDEBAR* = "sidebar"

const
  STYLE_CLASS_IMAGE* = "image"

const
  STYLE_CLASS_HIGHLIGHT* = "highlight"

const
  STYLE_CLASS_FRAME* = "frame"

const
  STYLE_CLASS_DND* = "dnd"

const
  STYLE_CLASS_PANE_SEPARATOR* = "pane-separator"

const
  STYLE_CLASS_SEPARATOR* = "separator"

const
  STYLE_CLASS_INFO* = "info"

const
  STYLE_CLASS_WARNING* = "warning"

const
  STYLE_CLASS_QUESTION* = "question"

const
  STYLE_CLASS_ERROR* = "error"

const
  STYLE_CLASS_HORIZONTAL* = "horizontal"

const
  STYLE_CLASS_VERTICAL* = "vertical"

const
  STYLE_CLASS_TOP* = "top"

const
  STYLE_CLASS_BOTTOM* = "bottom"

const
  STYLE_CLASS_LEFT* = "left"

const
  STYLE_CLASS_RIGHT* = "right"

const
  STYLE_CLASS_PULSE* = "pulse"

const
  STYLE_CLASS_ARROW* = "arrow"

const
  STYLE_CLASS_OSD* = "osd"

const
  STYLE_CLASS_LEVEL_BAR* = "level-bar"

const
  STYLE_CLASS_CURSOR_HANDLE* = "cursor-handle"

const
  STYLE_CLASS_INSERTION_CURSOR* = "insertion-cursor"

const
  STYLE_CLASS_TITLEBAR* = "titlebar"

const
  STYLE_CLASS_TITLE* = "title"

const
  STYLE_CLASS_SUBTITLE* = "subtitle"

const
  STYLE_CLASS_NEEDS_ATTENTION* = "needs-attention"

const
  STYLE_CLASS_SUGGESTED_ACTION* = "suggested-action"

const
  STYLE_CLASS_DESTRUCTIVE_ACTION* = "destructive-action"

const
  STYLE_CLASS_POPOVER* = "popover"

const
  STYLE_CLASS_POPUP* = "popup"

const
  STYLE_CLASS_MESSAGE_DIALOG* = "message-dialog"

const
  STYLE_CLASS_FLAT* = "flat"

const
  STYLE_CLASS_READ_ONLY* = "read-only"

const
  STYLE_CLASS_OVERSHOOT* = "overshoot"

const
  STYLE_CLASS_UNDERSHOOT* = "undershoot"

const
  STYLE_CLASS_PAPER* = "paper"

const
  STYLE_CLASS_MONOSPACE* = "monospace"

const
  STYLE_CLASS_WIDE* = "wide"

const
  STYLE_REGION_ROW* = "row"

const
  STYLE_REGION_COLUMN* = "column"

const
  STYLE_REGION_COLUMN_HEADER* = "column-header"

const
  STYLE_REGION_TAB* = "tab"

proc styleContextGetType*(): GType {.importc: "gtk_style_context_get_type",
                                     libgtk.}
proc newStyleContext*(): StyleContext {.importc: "gtk_style_context_new",
    libgtk.}
proc styleContextAddProviderForScreen*(screen: gdk3.Screen;
    provider: StyleProvider; priority: cuint) {.
    importc: "gtk_style_context_add_provider_for_screen", libgtk.}
proc styleContextRemoveProviderForScreen*(screen: gdk3.Screen;
    provider: StyleProvider) {.importc: "gtk_style_context_remove_provider_for_screen",
                                   libgtk.}
proc addProvider*(context: StyleContext;
                                provider: StyleProvider; priority: cuint) {.
    importc: "gtk_style_context_add_provider", libgtk.}
proc removeProvider*(context: StyleContext;
                                   provider: StyleProvider) {.
    importc: "gtk_style_context_remove_provider", libgtk.}
proc save*(context: StyleContext) {.
    importc: "gtk_style_context_save", libgtk.}
proc restore*(context: StyleContext) {.
    importc: "gtk_style_context_restore", libgtk.}
proc getSection*(context: StyleContext; property: cstring): CssSection {.
    importc: "gtk_style_context_get_section", libgtk.}
proc section*(context: StyleContext; property: cstring): CssSection {.
    importc: "gtk_style_context_get_section", libgtk.}
proc getProperty*(context: StyleContext; property: cstring;
                                state: StateFlags; value: gobject.GValue) {.
    importc: "gtk_style_context_get_property", libgtk.}

discard """ proc "getValist*(context: StyleContext; state: StateFlags;
                              args: VaList) {.
    importc: "gtk_style_context_get_valist", libgtk.}"""

proc get*(context: StyleContext; state: StateFlags) {.
    varargs, importc: "gtk_style_context_get", libgtk.}
proc setState*(context: StyleContext; flags: StateFlags) {.
    importc: "gtk_style_context_set_state", libgtk.}
proc `state=`*(context: StyleContext; flags: StateFlags) {.
    importc: "gtk_style_context_set_state", libgtk.}
proc getState*(context: StyleContext): StateFlags {.
    importc: "gtk_style_context_get_state", libgtk.}
proc state*(context: StyleContext): StateFlags {.
    importc: "gtk_style_context_get_state", libgtk.}
proc setScale*(context: StyleContext; scale: cint) {.
    importc: "gtk_style_context_set_scale", libgtk.}
proc `scale=`*(context: StyleContext; scale: cint) {.
    importc: "gtk_style_context_set_scale", libgtk.}
proc getScale*(context: StyleContext): cint {.
    importc: "gtk_style_context_get_scale", libgtk.}
proc scale*(context: StyleContext): cint {.
    importc: "gtk_style_context_get_scale", libgtk.}
proc stateIsRunning*(context: StyleContext;
                                   state: StateType; progress: var cdouble): Gboolean {.
    importc: "gtk_style_context_state_is_running", libgtk.}
proc setPath*(context: StyleContext; path: WidgetPath) {.
    importc: "gtk_style_context_set_path", libgtk.}
proc `path=`*(context: StyleContext; path: WidgetPath) {.
    importc: "gtk_style_context_set_path", libgtk.}
proc getPath*(context: StyleContext): WidgetPath {.
    importc: "gtk_style_context_get_path", libgtk.}
proc path*(context: StyleContext): WidgetPath {.
    importc: "gtk_style_context_get_path", libgtk.}
proc setParent*(context: StyleContext;
                              parent: StyleContext) {.
    importc: "gtk_style_context_set_parent", libgtk.}
proc `parent=`*(context: StyleContext;
                              parent: StyleContext) {.
    importc: "gtk_style_context_set_parent", libgtk.}
proc getParent*(context: StyleContext): StyleContext {.
    importc: "gtk_style_context_get_parent", libgtk.}
proc parent*(context: StyleContext): StyleContext {.
    importc: "gtk_style_context_get_parent", libgtk.}
proc listClasses*(context: StyleContext): glib.GList {.
    importc: "gtk_style_context_list_classes", libgtk.}
proc addClass*(context: StyleContext; className: cstring) {.
    importc: "gtk_style_context_add_class", libgtk.}
proc removeClass*(context: StyleContext; className: cstring) {.
    importc: "gtk_style_context_remove_class", libgtk.}
proc hasClass*(context: StyleContext; className: cstring): Gboolean {.
    importc: "gtk_style_context_has_class", libgtk.}
proc listRegions*(context: StyleContext): glib.GList {.
    importc: "gtk_style_context_list_regions", libgtk.}
proc addRegion*(context: StyleContext; regionName: cstring;
                              flags: RegionFlags) {.
    importc: "gtk_style_context_add_region", libgtk.}
proc removeRegion*(context: StyleContext; regionName: cstring) {.
    importc: "gtk_style_context_remove_region", libgtk.}
proc hasRegion*(context: StyleContext; regionName: cstring;
                              flagsReturn: ptr RegionFlags): Gboolean {.
    importc: "gtk_style_context_has_region", libgtk.}
proc getStyleProperty*(context: StyleContext;
                                     propertyName: cstring; value: gobject.GValue) {.
    importc: "gtk_style_context_get_style_property", libgtk.}

discard """ proc "getStyleValist*(context: StyleContext; args: VaList) {.
    importc: "gtk_style_context_get_style_valist", libgtk.}"""

proc getStyle*(context: StyleContext) {.varargs,
    importc: "gtk_style_context_get_style", libgtk.}
proc lookupIconSet*(context: StyleContext; stockId: cstring): IconSet {.
    importc: "gtk_style_context_lookup_icon_set", libgtk.}
proc renderIconPixbuf*(iconSet: IconSet;
                                context: StyleContext; size: IconSize): GdkPixbuf {.
    importc: "gtk_icon_set_render_icon_pixbuf", libgtk.}
proc renderIconSurface*(iconSet: IconSet;
                                 context: StyleContext; size: IconSize;
                                 scale: cint; forWindow: gdk3.Window): cairo.Surface {.
    importc: "gtk_icon_set_render_icon_surface", libgtk.}
proc setScreen*(context: StyleContext; screen: gdk3.Screen) {.
    importc: "gtk_style_context_set_screen", libgtk.}
proc `screen=`*(context: StyleContext; screen: gdk3.Screen) {.
    importc: "gtk_style_context_set_screen", libgtk.}
proc getScreen*(context: StyleContext): gdk3.Screen {.
    importc: "gtk_style_context_get_screen", libgtk.}
proc screen*(context: StyleContext): gdk3.Screen {.
    importc: "gtk_style_context_get_screen", libgtk.}
proc setFrameClock*(context: StyleContext;
                                  frameClock: gdk3.FrameClock) {.
    importc: "gtk_style_context_set_frame_clock", libgtk.}
proc `frameClock=`*(context: StyleContext;
                                  frameClock: gdk3.FrameClock) {.
    importc: "gtk_style_context_set_frame_clock", libgtk.}
proc getFrameClock*(context: StyleContext): gdk3.FrameClock {.
    importc: "gtk_style_context_get_frame_clock", libgtk.}
proc frameClock*(context: StyleContext): gdk3.FrameClock {.
    importc: "gtk_style_context_get_frame_clock", libgtk.}
proc setDirection*(context: StyleContext;
                                 direction: TextDirection) {.
    importc: "gtk_style_context_set_direction", libgtk.}
proc `direction=`*(context: StyleContext;
                                 direction: TextDirection) {.
    importc: "gtk_style_context_set_direction", libgtk.}
proc getDirection*(context: StyleContext): TextDirection {.
    importc: "gtk_style_context_get_direction", libgtk.}
proc direction*(context: StyleContext): TextDirection {.
    importc: "gtk_style_context_get_direction", libgtk.}
proc setJunctionSides*(context: StyleContext;
                                     sides: JunctionSides) {.
    importc: "gtk_style_context_set_junction_sides", libgtk.}
proc `junctionSides=`*(context: StyleContext;
                                     sides: JunctionSides) {.
    importc: "gtk_style_context_set_junction_sides", libgtk.}
proc getJunctionSides*(context: StyleContext): JunctionSides {.
    importc: "gtk_style_context_get_junction_sides", libgtk.}
proc junctionSides*(context: StyleContext): JunctionSides {.
    importc: "gtk_style_context_get_junction_sides", libgtk.}
proc lookupColor*(context: StyleContext; colorName: cstring;
                                color: gdk3.RGBA): Gboolean {.
    importc: "gtk_style_context_lookup_color", libgtk.}
proc notifyStateChange*(context: StyleContext;
                                      window: gdk3.Window; regionId: Gpointer;
                                      state: StateType; stateValue: Gboolean) {.
    importc: "gtk_style_context_notify_state_change", libgtk.}
proc cancelAnimations*(context: StyleContext;
                                     regionId: Gpointer) {.
    importc: "gtk_style_context_cancel_animations", libgtk.}
proc scrollAnimations*(context: StyleContext;
                                     window: gdk3.Window; dx: cint; dy: cint) {.
    importc: "gtk_style_context_scroll_animations", libgtk.}
proc pushAnimatableRegion*(context: StyleContext;
    regionId: Gpointer) {.importc: "gtk_style_context_push_animatable_region",
                        libgtk.}
proc popAnimatableRegion*(context: StyleContext) {.
    importc: "gtk_style_context_pop_animatable_region", libgtk.}

proc getColor*(context: StyleContext; state: StateFlags;
                             color: gdk3.RGBA) {.
    importc: "gtk_style_context_get_color", libgtk.}
proc getBackgroundColor*(context: StyleContext;
                                       state: StateFlags; color: gdk3.RGBA) {.
    importc: "gtk_style_context_get_background_color", libgtk.}
proc getBorderColor*(context: StyleContext;
                                   state: StateFlags; color: gdk3.RGBA) {.
    importc: "gtk_style_context_get_border_color", libgtk.}
proc getFont*(context: StyleContext; state: StateFlags): pango.FontDescription {.
    importc: "gtk_style_context_get_font", libgtk.}
proc font*(context: StyleContext; state: StateFlags): pango.FontDescription {.
    importc: "gtk_style_context_get_font", libgtk.}
proc getBorder*(context: StyleContext; state: StateFlags;
                              border: Border) {.
    importc: "gtk_style_context_get_border", libgtk.}
proc getPadding*(context: StyleContext; state: StateFlags;
                               padding: Border) {.
    importc: "gtk_style_context_get_padding", libgtk.}
proc getMargin*(context: StyleContext; state: StateFlags;
                              margin: Border) {.
    importc: "gtk_style_context_get_margin", libgtk.}
proc invalidate*(context: StyleContext) {.
    importc: "gtk_style_context_invalidate", libgtk.}
proc styleContextResetWidgets*(screen: gdk3.Screen) {.
    importc: "gtk_style_context_reset_widgets", libgtk.}
proc setBackground*(context: StyleContext;
                                  window: gdk3.Window) {.
    importc: "gtk_style_context_set_background", libgtk.}
proc `background=`*(context: StyleContext;
                                  window: gdk3.Window) {.
    importc: "gtk_style_context_set_background", libgtk.}
proc renderInsertionCursor*(context: StyleContext; cr: cairo.Context;
                              x: cdouble; y: cdouble; layout: pango.Layout;
                              index: cint; direction: pango.Direction) {.
    importc: "gtk_render_insertion_cursor", libgtk.}
proc drawInsertionCursor*(widget: Widget; cr: cairo.Context;
                            location: gdk3.Rectangle; isPrimary: Gboolean;
                            direction: TextDirection; drawArrow: Gboolean) {.
    importc: "gtk_draw_insertion_cursor", libgtk.}
type
  StyleContextPrintFlags* {.size: sizeof(cint), pure.} = enum
    NONE = 0, RECURSE = 1 shl 0,
    SHOW_STYLE = 1 shl 1

type
  IconTheme* =  ptr IconThemeObj
  IconThemePtr* = ptr IconThemeObj
  IconThemeObj*{.final.} = object of GObjectObj
    priv79: pointer

  IconThemeClass* =  ptr IconThemeClassObj
  IconThemeClassPtr* = ptr IconThemeClassObj
  IconThemeClassObj*{.final.} = object of GObjectClassObj
    changed*: proc (iconTheme: IconTheme) {.cdecl.}
    gtkReserved761*: proc () {.cdecl.}
    gtkReserved762*: proc () {.cdecl.}
    gtkReserved763*: proc () {.cdecl.}
    gtkReserved764*: proc () {.cdecl.}

  IconInfo* =  ptr IconInfoObj
  IconInfoPtr* = ptr IconInfoObj
  IconInfoObj* = object

  IconInfoClass* =  ptr IconInfoClassObj
  IconInfoClassPtr* = ptr IconInfoClassObj
  IconInfoClassObj* = object

proc toString*(context: StyleContext;
                             flags: StyleContextPrintFlags): cstring {.
    importc: "gtk_style_context_to_string", libgtk.}

template typeIconInfo*(): expr =
  (iconInfoGetType())

template iconInfo*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeIconInfo, IconInfoObj))

template iconInfoClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeIconInfo, IconInfoClassObj))

template isIconInfo*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeIconInfo))

template isIconInfoClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeIconInfo))

template iconInfoGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeIconInfo, IconInfoClassObj))

template typeIconTheme*(): expr =
  (iconThemeGetType())

template iconTheme*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeIconTheme, IconThemeObj))

template iconThemeClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeIconTheme, IconThemeClassObj))

template isIconTheme*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeIconTheme))

template isIconThemeClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeIconTheme))

template iconThemeGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeIconTheme, IconThemeClassObj))

type
  IconLookupFlags* {.size: sizeof(cint), pure.} = enum
    NO_SVG = 1 shl 0, FORCE_SVG = 1 shl 1,
    USE_BUILTIN = 1 shl 2,
    GENERIC_FALLBACK = 1 shl 3, FORCE_SIZE = 1 shl 4,
    FORCE_REGULAR = 1 shl 5,
    FORCE_SYMBOLIC = 1 shl 6, DIR_LTR = 1 shl 7,
    DIR_RTL = 1 shl 8

template iconThemeError*(): expr =
  gtkIconThemeErrorQuark()

type
  IconThemeError* {.size: sizeof(cint), pure.} = enum
    NOT_FOUND, FAILED

type
  IconView* =  ptr IconViewObj
  IconViewPtr* = ptr IconViewObj
  IconViewObj*{.final.} = object of ContainerObj
    priv80: pointer

  IconViewClass* =  ptr IconViewClassObj
  IconViewClassPtr* = ptr IconViewClassObj
  IconViewClassObj*{.final.} = object of ContainerClassObj
    itemActivated*: proc (iconView: IconView; path: TreePath) {.cdecl.}
    selectionChanged*: proc (iconView: IconView) {.cdecl.}
    selectAll*: proc (iconView: IconView) {.cdecl.}
    unselectAll*: proc (iconView: IconView) {.cdecl.}
    selectCursorItem*: proc (iconView: IconView) {.cdecl.}
    toggleCursorItem*: proc (iconView: IconView) {.cdecl.}
    moveCursor*: proc (iconView: IconView; step: MovementStep; count: cint): Gboolean {.cdecl.}
    activateCursorItem*: proc (iconView: IconView): Gboolean {.cdecl.}
    gtkReserved771*: proc () {.cdecl.}
    gtkReserved772*: proc () {.cdecl.}
    gtkReserved773*: proc () {.cdecl.}
    gtkReserved774*: proc () {.cdecl.}

proc iconThemeErrorQuark*(): GQuark {.importc: "gtk_icon_theme_error_quark",
                                      libgtk.}
proc iconThemeGetType*(): GType {.importc: "gtk_icon_theme_get_type", libgtk.}
proc newIconTheme*(): IconTheme {.importc: "gtk_icon_theme_new", libgtk.}
proc iconThemeGetDefault*(): IconTheme {.
    importc: "gtk_icon_theme_get_default", libgtk.}
proc iconThemeGetForScreen*(screen: gdk3.Screen): IconTheme {.
    importc: "gtk_icon_theme_get_for_screen", libgtk.}
proc setScreen*(iconTheme: IconTheme; screen: gdk3.Screen) {.
    importc: "gtk_icon_theme_set_screen", libgtk.}
proc `screen=`*(iconTheme: IconTheme; screen: gdk3.Screen) {.
    importc: "gtk_icon_theme_set_screen", libgtk.}
proc setSearchPath*(iconTheme: IconTheme; path: var cstring;
                               nElements: cint) {.
    importc: "gtk_icon_theme_set_search_path", libgtk.}
proc `searchPath=`*(iconTheme: IconTheme; path: var cstring;
                               nElements: cint) {.
    importc: "gtk_icon_theme_set_search_path", libgtk.}
proc getSearchPath*(iconTheme: IconTheme; path: var cstringArray;
                               nElements: var cint) {.
    importc: "gtk_icon_theme_get_search_path", libgtk.}
proc appendSearchPath*(iconTheme: IconTheme; path: cstring) {.
    importc: "gtk_icon_theme_append_search_path", libgtk.}
proc prependSearchPath*(iconTheme: IconTheme; path: cstring) {.
    importc: "gtk_icon_theme_prepend_search_path", libgtk.}
proc addResourcePath*(iconTheme: IconTheme; path: cstring) {.
    importc: "gtk_icon_theme_add_resource_path", libgtk.}
proc setCustomTheme*(iconTheme: IconTheme; themeName: cstring) {.
    importc: "gtk_icon_theme_set_custom_theme", libgtk.}
proc `customTheme=`*(iconTheme: IconTheme; themeName: cstring) {.
    importc: "gtk_icon_theme_set_custom_theme", libgtk.}
proc hasIcon*(iconTheme: IconTheme; iconName: cstring): Gboolean {.
    importc: "gtk_icon_theme_has_icon", libgtk.}
proc getIconSizes*(iconTheme: IconTheme; iconName: cstring): ptr cint {.
    importc: "gtk_icon_theme_get_icon_sizes", libgtk.}
proc iconSizes*(iconTheme: IconTheme; iconName: cstring): ptr cint {.
    importc: "gtk_icon_theme_get_icon_sizes", libgtk.}
proc lookupIcon*(iconTheme: IconTheme; iconName: cstring;
                            size: cint; flags: IconLookupFlags): IconInfo {.
    importc: "gtk_icon_theme_lookup_icon", libgtk.}
proc lookupIconForScale*(iconTheme: IconTheme; iconName: cstring;
                                    size: cint; scale: cint;
                                    flags: IconLookupFlags): IconInfo {.
    importc: "gtk_icon_theme_lookup_icon_for_scale", libgtk.}
proc chooseIcon*(iconTheme: IconTheme; iconNames: var cstring;
                            size: cint; flags: IconLookupFlags): IconInfo {.
    importc: "gtk_icon_theme_choose_icon", libgtk.}
proc chooseIconForScale*(iconTheme: IconTheme;
                                    iconNames: var cstring; size: cint; scale: cint;
                                    flags: IconLookupFlags): IconInfo {.
    importc: "gtk_icon_theme_choose_icon_for_scale", libgtk.}
proc loadIcon*(iconTheme: IconTheme; iconName: cstring; size: cint;
                          flags: IconLookupFlags; error: var glib.GError): GdkPixbuf {.
    importc: "gtk_icon_theme_load_icon", libgtk.}
proc loadIconForScale*(iconTheme: IconTheme; iconName: cstring;
                                  size: cint; scale: cint;
                                  flags: IconLookupFlags; error: var glib.GError): GdkPixbuf {.
    importc: "gtk_icon_theme_load_icon_for_scale", libgtk.}
proc loadSurface*(iconTheme: IconTheme; iconName: cstring;
                             size: cint; scale: cint; forWindow: gdk3.Window;
                             flags: IconLookupFlags; error: var glib.GError): cairo.Surface {.
    importc: "gtk_icon_theme_load_surface", libgtk.}
proc lookupByGicon*(iconTheme: IconTheme; icon: gio.GIcon;
                               size: cint; flags: IconLookupFlags): IconInfo {.
    importc: "gtk_icon_theme_lookup_by_gicon", libgtk.}
proc lookupByGiconForScale*(iconTheme: IconTheme;
                                       icon: gio.GIcon; size: cint; scale: cint;
                                       flags: IconLookupFlags): IconInfo {.
    importc: "gtk_icon_theme_lookup_by_gicon_for_scale", libgtk.}
proc listIcons*(iconTheme: IconTheme; context: cstring): glib.GList {.
    importc: "gtk_icon_theme_list_icons", libgtk.}
proc listContexts*(iconTheme: IconTheme): glib.GList {.
    importc: "gtk_icon_theme_list_contexts", libgtk.}
proc getExampleIconName*(iconTheme: IconTheme): cstring {.
    importc: "gtk_icon_theme_get_example_icon_name", libgtk.}
proc exampleIconName*(iconTheme: IconTheme): cstring {.
    importc: "gtk_icon_theme_get_example_icon_name", libgtk.}
proc rescanIfNeeded*(iconTheme: IconTheme): Gboolean {.
    importc: "gtk_icon_theme_rescan_if_needed", libgtk.}
proc iconThemeAddBuiltinIcon*(iconName: cstring; size: cint; pixbuf: GdkPixbuf) {.
    importc: "gtk_icon_theme_add_builtin_icon", libgtk.}
proc iconInfoGetType*(): GType {.importc: "gtk_icon_info_get_type", libgtk.}
proc copy*(iconInfo: IconInfo): IconInfo {.
    importc: "gtk_icon_info_copy", libgtk.}
proc free*(iconInfo: IconInfo) {.importc: "gtk_icon_info_free",
    libgtk.}
proc newIconInfo*(iconTheme: IconTheme; pixbuf: GdkPixbuf): IconInfo {.
    importc: "gtk_icon_info_new_for_pixbuf", libgtk.}
proc getBaseSize*(iconInfo: IconInfo): cint {.
    importc: "gtk_icon_info_get_base_size", libgtk.}
proc baseSize*(iconInfo: IconInfo): cint {.
    importc: "gtk_icon_info_get_base_size", libgtk.}
proc getBaseScale*(iconInfo: IconInfo): cint {.
    importc: "gtk_icon_info_get_base_scale", libgtk.}
proc baseScale*(iconInfo: IconInfo): cint {.
    importc: "gtk_icon_info_get_base_scale", libgtk.}
proc getFilename*(iconInfo: IconInfo): cstring {.
    importc: "gtk_icon_info_get_filename", libgtk.}
proc filename*(iconInfo: IconInfo): cstring {.
    importc: "gtk_icon_info_get_filename", libgtk.}
proc getBuiltinPixbuf*(iconInfo: IconInfo): GdkPixbuf {.
    importc: "gtk_icon_info_get_builtin_pixbuf", libgtk.}
proc builtinPixbuf*(iconInfo: IconInfo): GdkPixbuf {.
    importc: "gtk_icon_info_get_builtin_pixbuf", libgtk.}
proc isSymbolic*(iconInfo: IconInfo): Gboolean {.
    importc: "gtk_icon_info_is_symbolic", libgtk.}
proc loadIcon*(iconInfo: IconInfo; error: var glib.GError): GdkPixbuf {.
    importc: "gtk_icon_info_load_icon", libgtk.}
proc loadSurface*(iconInfo: IconInfo; forWindow: gdk3.Window;
                            error: var glib.GError): cairo.Surface {.
    importc: "gtk_icon_info_load_surface", libgtk.}
proc loadIconAsync*(iconInfo: IconInfo;
                              cancellable: gio.GCancellable;
                              callback: GAsyncReadyCallback; userData: Gpointer) {.
    importc: "gtk_icon_info_load_icon_async", libgtk.}
proc loadIconFinish*(iconInfo: IconInfo; res: gio.GAsyncResult;
                               error: var glib.GError): GdkPixbuf {.
    importc: "gtk_icon_info_load_icon_finish", libgtk.}
proc loadSymbolic*(iconInfo: IconInfo; fg: gdk3.RGBA;
                             successColor: gdk3.RGBA; warningColor: gdk3.RGBA;
                             errorColor: gdk3.RGBA; wasSymbolic: var Gboolean;
                             error: var glib.GError): GdkPixbuf {.
    importc: "gtk_icon_info_load_symbolic", libgtk.}
proc loadSymbolicAsync*(iconInfo: IconInfo; fg: gdk3.RGBA;
                                  successColor: gdk3.RGBA;
                                  warningColor: gdk3.RGBA;
                                  errorColor: gdk3.RGBA;
                                  cancellable: gio.GCancellable;
                                  callback: GAsyncReadyCallback;
                                  userData: Gpointer) {.
    importc: "gtk_icon_info_load_symbolic_async", libgtk.}
proc loadSymbolicFinish*(iconInfo: IconInfo;
                                   res: gio.GAsyncResult;
                                   wasSymbolic: var Gboolean; error: var glib.GError): GdkPixbuf {.
    importc: "gtk_icon_info_load_symbolic_finish", libgtk.}
proc loadSymbolicForContext*(iconInfo: IconInfo;
                                       context: StyleContext;
                                       wasSymbolic: var Gboolean;
                                       error: var glib.GError): GdkPixbuf {.
    importc: "gtk_icon_info_load_symbolic_for_context", libgtk.}
proc loadSymbolicForContextAsync*(iconInfo: IconInfo;
    context: StyleContext; cancellable: gio.GCancellable;
    callback: GAsyncReadyCallback; userData: Gpointer) {.
    importc: "gtk_icon_info_load_symbolic_for_context_async", libgtk.}
proc loadSymbolicForContextFinish*(iconInfo: IconInfo;
    res: gio.GAsyncResult; wasSymbolic: var Gboolean; error: var glib.GError): GdkPixbuf {.
    importc: "gtk_icon_info_load_symbolic_for_context_finish", libgtk.}
proc loadSymbolicForStyle*(iconInfo: IconInfo;
                                     style: Style; state: StateType;
                                     wasSymbolic: var Gboolean;
                                     error: var glib.GError): GdkPixbuf {.
    importc: "gtk_icon_info_load_symbolic_for_style", libgtk.}
proc setRawCoordinates*(iconInfo: IconInfo;
                                  rawCoordinates: Gboolean) {.
    importc: "gtk_icon_info_set_raw_coordinates", libgtk.}
proc `rawCoordinates=`*(iconInfo: IconInfo;
                                  rawCoordinates: Gboolean) {.
    importc: "gtk_icon_info_set_raw_coordinates", libgtk.}
proc getEmbeddedRect*(iconInfo: IconInfo;
                                rectangle: gdk3.Rectangle): Gboolean {.
    importc: "gtk_icon_info_get_embedded_rect", libgtk.}
proc embeddedRect*(iconInfo: IconInfo;
                                rectangle: gdk3.Rectangle): Gboolean {.
    importc: "gtk_icon_info_get_embedded_rect", libgtk.}
proc getAttachPoints*(iconInfo: IconInfo;
                                points: var gdk3.Point; nPoints: var cint): Gboolean {.
    importc: "gtk_icon_info_get_attach_points", libgtk.}
proc attachPoints*(iconInfo: IconInfo;
                                points: var gdk3.Point; nPoints: var cint): Gboolean {.
    importc: "gtk_icon_info_get_attach_points", libgtk.}
proc getDisplayName*(iconInfo: IconInfo): cstring {.
    importc: "gtk_icon_info_get_display_name", libgtk.}
proc displayName*(iconInfo: IconInfo): cstring {.
    importc: "gtk_icon_info_get_display_name", libgtk.}

template typeTooltip*(): expr =
  (tooltipGetType())

template tooltip*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTooltip, TooltipObj))

template isTooltip*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTooltip))

proc tooltipGetType*(): GType {.importc: "gtk_tooltip_get_type", libgtk.}
proc setMarkup*(tooltip: Tooltip; markup: cstring) {.
    importc: "gtk_tooltip_set_markup", libgtk.}
proc `markup=`*(tooltip: Tooltip; markup: cstring) {.
    importc: "gtk_tooltip_set_markup", libgtk.}
proc setText*(tooltip: Tooltip; text: cstring) {.
    importc: "gtk_tooltip_set_text", libgtk.}
proc `text=`*(tooltip: Tooltip; text: cstring) {.
    importc: "gtk_tooltip_set_text", libgtk.}
proc setIcon*(tooltip: Tooltip; pixbuf: GdkPixbuf) {.
    importc: "gtk_tooltip_set_icon", libgtk.}
proc `icon=`*(tooltip: Tooltip; pixbuf: GdkPixbuf) {.
    importc: "gtk_tooltip_set_icon", libgtk.}
proc setIconFromStock*(tooltip: Tooltip; stockId: cstring;
                                size: IconSize) {.
    importc: "gtk_tooltip_set_icon_from_stock", libgtk.}
proc `iconFromStock=`*(tooltip: Tooltip; stockId: cstring;
                                size: IconSize) {.
    importc: "gtk_tooltip_set_icon_from_stock", libgtk.}
proc setIconFromIconName*(tooltip: Tooltip; iconName: cstring;
                                   size: IconSize) {.
    importc: "gtk_tooltip_set_icon_from_icon_name", libgtk.}
proc `iconFromIconName=`*(tooltip: Tooltip; iconName: cstring;
                                   size: IconSize) {.
    importc: "gtk_tooltip_set_icon_from_icon_name", libgtk.}
proc setIconFromGicon*(tooltip: Tooltip; gicon: gio.GIcon;
                                size: IconSize) {.
    importc: "gtk_tooltip_set_icon_from_gicon", libgtk.}
proc `iconFromGicon=`*(tooltip: Tooltip; gicon: gio.GIcon;
                                size: IconSize) {.
    importc: "gtk_tooltip_set_icon_from_gicon", libgtk.}
proc setCustom*(tooltip: Tooltip; customWidget: Widget) {.
    importc: "gtk_tooltip_set_custom", libgtk.}
proc `custom=`*(tooltip: Tooltip; customWidget: Widget) {.
    importc: "gtk_tooltip_set_custom", libgtk.}
proc setTipArea*(tooltip: Tooltip; rect: gdk3.Rectangle) {.
    importc: "gtk_tooltip_set_tip_area", libgtk.}
proc `tipArea=`*(tooltip: Tooltip; rect: gdk3.Rectangle) {.
    importc: "gtk_tooltip_set_tip_area", libgtk.}
proc tooltipTriggerTooltipQuery*(display: gdk3.Display) {.
    importc: "gtk_tooltip_trigger_tooltip_query", libgtk.}

template typeIconView*(): expr =
  (iconViewGetType())

template iconView*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeIconView, IconViewObj))

template iconViewClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeIconView, IconViewClassObj))

template isIconView*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeIconView))

template isIconViewClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeIconView))

template iconViewGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeIconView, IconViewClassObj))

type
  IconViewForeachFunc* = proc (iconView: IconView; path: TreePath;
                               data: Gpointer) {.cdecl.}

type
  IconViewDropPosition* {.size: sizeof(cint), pure.} = enum
    NO_DROP, DROP_INTO, DROP_LEFT,
    DROP_RIGHT, DROP_ABOVE, DROP_BELOW

proc iconViewGetType*(): GType {.importc: "gtk_icon_view_get_type", libgtk.}
proc newIconView*(): IconView {.importc: "gtk_icon_view_new", libgtk.}
proc setModel*(iconView: IconView; model: TreeModel) {.
    importc: "gtk_icon_view_set_model", libgtk.}
proc `model=`*(iconView: IconView; model: TreeModel) {.
    importc: "gtk_icon_view_set_model", libgtk.}
proc getModel*(iconView: IconView): TreeModel {.
    importc: "gtk_icon_view_get_model", libgtk.}
proc model*(iconView: IconView): TreeModel {.
    importc: "gtk_icon_view_get_model", libgtk.}
proc setTextColumn*(iconView: IconView; column: cint) {.
    importc: "gtk_icon_view_set_text_column", libgtk.}
proc `textColumn=`*(iconView: IconView; column: cint) {.
    importc: "gtk_icon_view_set_text_column", libgtk.}
proc getTextColumn*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_text_column", libgtk.}
proc textColumn*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_text_column", libgtk.}
proc setMarkupColumn*(iconView: IconView; column: cint) {.
    importc: "gtk_icon_view_set_markup_column", libgtk.}
proc `markupColumn=`*(iconView: IconView; column: cint) {.
    importc: "gtk_icon_view_set_markup_column", libgtk.}
proc getMarkupColumn*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_markup_column", libgtk.}
proc markupColumn*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_markup_column", libgtk.}
proc setPixbufColumn*(iconView: IconView; column: cint) {.
    importc: "gtk_icon_view_set_pixbuf_column", libgtk.}
proc `pixbufColumn=`*(iconView: IconView; column: cint) {.
    importc: "gtk_icon_view_set_pixbuf_column", libgtk.}
proc getPixbufColumn*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_pixbuf_column", libgtk.}
proc pixbufColumn*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_pixbuf_column", libgtk.}
proc setItemOrientation*(iconView: IconView;
                                   orientation: Orientation) {.
    importc: "gtk_icon_view_set_item_orientation", libgtk.}
proc `itemOrientation=`*(iconView: IconView;
                                   orientation: Orientation) {.
    importc: "gtk_icon_view_set_item_orientation", libgtk.}
proc getItemOrientation*(iconView: IconView): Orientation {.
    importc: "gtk_icon_view_get_item_orientation", libgtk.}
proc itemOrientation*(iconView: IconView): Orientation {.
    importc: "gtk_icon_view_get_item_orientation", libgtk.}
proc setColumns*(iconView: IconView; columns: cint) {.
    importc: "gtk_icon_view_set_columns", libgtk.}
proc `columns=`*(iconView: IconView; columns: cint) {.
    importc: "gtk_icon_view_set_columns", libgtk.}
proc getColumns*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_columns", libgtk.}
proc columns*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_columns", libgtk.}
proc setItemWidth*(iconView: IconView; itemWidth: cint) {.
    importc: "gtk_icon_view_set_item_width", libgtk.}
proc `itemWidth=`*(iconView: IconView; itemWidth: cint) {.
    importc: "gtk_icon_view_set_item_width", libgtk.}
proc getItemWidth*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_item_width", libgtk.}
proc itemWidth*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_item_width", libgtk.}
proc setSpacing*(iconView: IconView; spacing: cint) {.
    importc: "gtk_icon_view_set_spacing", libgtk.}
proc `spacing=`*(iconView: IconView; spacing: cint) {.
    importc: "gtk_icon_view_set_spacing", libgtk.}
proc getSpacing*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_spacing", libgtk.}
proc spacing*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_spacing", libgtk.}
proc setRowSpacing*(iconView: IconView; rowSpacing: cint) {.
    importc: "gtk_icon_view_set_row_spacing", libgtk.}
proc `rowSpacing=`*(iconView: IconView; rowSpacing: cint) {.
    importc: "gtk_icon_view_set_row_spacing", libgtk.}
proc getRowSpacing*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_row_spacing", libgtk.}
proc rowSpacing*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_row_spacing", libgtk.}
proc setColumnSpacing*(iconView: IconView; columnSpacing: cint) {.
    importc: "gtk_icon_view_set_column_spacing", libgtk.}
proc `columnSpacing=`*(iconView: IconView; columnSpacing: cint) {.
    importc: "gtk_icon_view_set_column_spacing", libgtk.}
proc getColumnSpacing*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_column_spacing", libgtk.}
proc columnSpacing*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_column_spacing", libgtk.}
proc setMargin*(iconView: IconView; margin: cint) {.
    importc: "gtk_icon_view_set_margin", libgtk.}
proc `margin=`*(iconView: IconView; margin: cint) {.
    importc: "gtk_icon_view_set_margin", libgtk.}
proc getMargin*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_margin", libgtk.}
proc margin*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_margin", libgtk.}
proc setItemPadding*(iconView: IconView; itemPadding: cint) {.
    importc: "gtk_icon_view_set_item_padding", libgtk.}
proc `itemPadding=`*(iconView: IconView; itemPadding: cint) {.
    importc: "gtk_icon_view_set_item_padding", libgtk.}
proc getItemPadding*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_item_padding", libgtk.}
proc itemPadding*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_item_padding", libgtk.}
proc getPathAtPos*(iconView: IconView; x: cint; y: cint): TreePath {.
    importc: "gtk_icon_view_get_path_at_pos", libgtk.}
proc pathAtPos*(iconView: IconView; x: cint; y: cint): TreePath {.
    importc: "gtk_icon_view_get_path_at_pos", libgtk.}
proc getItemAtPos*(iconView: IconView; x: cint; y: cint;
                             path: var TreePath;
                             cell: var CellRenderer): Gboolean {.
    importc: "gtk_icon_view_get_item_at_pos", libgtk.}
proc itemAtPos*(iconView: IconView; x: cint; y: cint;
                             path: var TreePath;
                             cell: var CellRenderer): Gboolean {.
    importc: "gtk_icon_view_get_item_at_pos", libgtk.}
proc getVisibleRange*(iconView: IconView;
                                startPath: var TreePath;
                                endPath: var TreePath): Gboolean {.
    importc: "gtk_icon_view_get_visible_range", libgtk.}
proc visibleRange*(iconView: IconView;
                                startPath: var TreePath;
                                endPath: var TreePath): Gboolean {.
    importc: "gtk_icon_view_get_visible_range", libgtk.}
proc setActivateOnSingleClick*(iconView: IconView;
    single: Gboolean) {.importc: "gtk_icon_view_set_activate_on_single_click",
                      libgtk.}
proc `activateOnSingleClick=`*(iconView: IconView;
    single: Gboolean) {.importc: "gtk_icon_view_set_activate_on_single_click",
                      libgtk.}
proc getActivateOnSingleClick*(iconView: IconView): Gboolean {.
    importc: "gtk_icon_view_get_activate_on_single_click", libgtk.}
proc activateOnSingleClick*(iconView: IconView): Gboolean {.
    importc: "gtk_icon_view_get_activate_on_single_click", libgtk.}
proc selectedForeach*(iconView: IconView;
                                `func`: IconViewForeachFunc; data: Gpointer) {.
    importc: "gtk_icon_view_selected_foreach", libgtk.}
proc setSelectionMode*(iconView: IconView; mode: SelectionMode) {.
    importc: "gtk_icon_view_set_selection_mode", libgtk.}
proc `selectionMode=`*(iconView: IconView; mode: SelectionMode) {.
    importc: "gtk_icon_view_set_selection_mode", libgtk.}
proc getSelectionMode*(iconView: IconView): SelectionMode {.
    importc: "gtk_icon_view_get_selection_mode", libgtk.}
proc selectionMode*(iconView: IconView): SelectionMode {.
    importc: "gtk_icon_view_get_selection_mode", libgtk.}
proc selectPath*(iconView: IconView; path: TreePath) {.
    importc: "gtk_icon_view_select_path", libgtk.}
proc unselectPath*(iconView: IconView; path: TreePath) {.
    importc: "gtk_icon_view_unselect_path", libgtk.}
proc pathIsSelected*(iconView: IconView; path: TreePath): Gboolean {.
    importc: "gtk_icon_view_path_is_selected", libgtk.}
proc getItemRow*(iconView: IconView; path: TreePath): cint {.
    importc: "gtk_icon_view_get_item_row", libgtk.}
proc itemRow*(iconView: IconView; path: TreePath): cint {.
    importc: "gtk_icon_view_get_item_row", libgtk.}
proc getItemColumn*(iconView: IconView; path: TreePath): cint {.
    importc: "gtk_icon_view_get_item_column", libgtk.}
proc itemColumn*(iconView: IconView; path: TreePath): cint {.
    importc: "gtk_icon_view_get_item_column", libgtk.}
proc getSelectedItems*(iconView: IconView): glib.GList {.
    importc: "gtk_icon_view_get_selected_items", libgtk.}
proc selectedItems*(iconView: IconView): glib.GList {.
    importc: "gtk_icon_view_get_selected_items", libgtk.}
proc selectAll*(iconView: IconView) {.
    importc: "gtk_icon_view_select_all", libgtk.}
proc unselectAll*(iconView: IconView) {.
    importc: "gtk_icon_view_unselect_all", libgtk.}
proc itemActivated*(iconView: IconView; path: TreePath) {.
    importc: "gtk_icon_view_item_activated", libgtk.}
proc setCursor*(iconView: IconView; path: TreePath;
                          cell: CellRenderer; startEditing: Gboolean) {.
    importc: "gtk_icon_view_set_cursor", libgtk.}
proc `cursor=`*(iconView: IconView; path: TreePath;
                          cell: CellRenderer; startEditing: Gboolean) {.
    importc: "gtk_icon_view_set_cursor", libgtk.}
proc getCursor*(iconView: IconView; path: var TreePath;
                          cell: var CellRenderer): Gboolean {.
    importc: "gtk_icon_view_get_cursor", libgtk.}
proc cursor*(iconView: IconView; path: var TreePath;
                          cell: var CellRenderer): Gboolean {.
    importc: "gtk_icon_view_get_cursor", libgtk.}
proc scrollToPath*(iconView: IconView; path: TreePath;
                             useAlign: Gboolean; rowAlign: cfloat; colAlign: cfloat) {.
    importc: "gtk_icon_view_scroll_to_path", libgtk.}

proc enableModelDragSource*(iconView: IconView;
                                      startButtonMask: gdk3.ModifierType;
                                      targets: TargetEntry; nTargets: cint;
                                      actions: gdk3.DragAction) {.
    importc: "gtk_icon_view_enable_model_drag_source", libgtk.}
proc enableModelDragDest*(iconView: IconView;
                                    targets: TargetEntry; nTargets: cint;
                                    actions: gdk3.DragAction) {.
    importc: "gtk_icon_view_enable_model_drag_dest", libgtk.}
proc unsetModelDragSource*(iconView: IconView) {.
    importc: "gtk_icon_view_unset_model_drag_source", libgtk.}
proc unsetModelDragDest*(iconView: IconView) {.
    importc: "gtk_icon_view_unset_model_drag_dest", libgtk.}
proc setReorderable*(iconView: IconView; reorderable: Gboolean) {.
    importc: "gtk_icon_view_set_reorderable", libgtk.}
proc `reorderable=`*(iconView: IconView; reorderable: Gboolean) {.
    importc: "gtk_icon_view_set_reorderable", libgtk.}
proc getReorderable*(iconView: IconView): Gboolean {.
    importc: "gtk_icon_view_get_reorderable", libgtk.}
proc reorderable*(iconView: IconView): Gboolean {.
    importc: "gtk_icon_view_get_reorderable", libgtk.}

proc setDragDestItem*(iconView: IconView; path: TreePath;
                                pos: IconViewDropPosition) {.
    importc: "gtk_icon_view_set_drag_dest_item", libgtk.}

proc `dragDestItem=`*(iconView: IconView; path: TreePath;
                                pos: IconViewDropPosition) {.
    importc: "gtk_icon_view_set_drag_dest_item", libgtk.}
proc getDragDestItem*(iconView: IconView;
                                path: var TreePath;
                                pos: ptr IconViewDropPosition) {.
    importc: "gtk_icon_view_get_drag_dest_item", libgtk.}
proc getDestItemAtPos*(iconView: IconView; dragX: cint; dragY: cint;
                                 path: var TreePath;
                                 pos: ptr IconViewDropPosition): Gboolean {.
    importc: "gtk_icon_view_get_dest_item_at_pos", libgtk.}
proc destItemAtPos*(iconView: IconView; dragX: cint; dragY: cint;
                                 path: var TreePath;
                                 pos: ptr IconViewDropPosition): Gboolean {.
    importc: "gtk_icon_view_get_dest_item_at_pos", libgtk.}
proc createDragIcon*(iconView: IconView; path: TreePath): cairo.Surface {.
    importc: "gtk_icon_view_create_drag_icon", libgtk.}
proc convertWidgetToBinWindowCoords*(iconView: IconView; wx: cint;
    wy: cint; bx: var cint; by: var cint) {.importc: "gtk_icon_view_convert_widget_to_bin_window_coords",
                                    libgtk.}
proc getCellRect*(iconView: IconView; path: TreePath;
                            cell: CellRenderer; rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_icon_view_get_cell_rect", libgtk.}
proc cellRect*(iconView: IconView; path: TreePath;
                            cell: CellRenderer; rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_icon_view_get_cell_rect", libgtk.}
proc setTooltipItem*(iconView: IconView; tooltip: Tooltip;
                               path: TreePath) {.
    importc: "gtk_icon_view_set_tooltip_item", libgtk.}
proc `tooltipItem=`*(iconView: IconView; tooltip: Tooltip;
                               path: TreePath) {.
    importc: "gtk_icon_view_set_tooltip_item", libgtk.}
proc setTooltipCell*(iconView: IconView; tooltip: Tooltip;
                               path: TreePath; cell: CellRenderer) {.
    importc: "gtk_icon_view_set_tooltip_cell", libgtk.}
proc `tooltipCell=`*(iconView: IconView; tooltip: Tooltip;
                               path: TreePath; cell: CellRenderer) {.
    importc: "gtk_icon_view_set_tooltip_cell", libgtk.}
proc getTooltipContext*(iconView: IconView; x: var cint; y: var cint;
                                  keyboardTip: Gboolean;
                                  model: var TreeModel;
                                  path: var TreePath; iter: TreeIter): Gboolean {.
    importc: "gtk_icon_view_get_tooltip_context", libgtk.}
proc tooltipContext*(iconView: IconView; x: var cint; y: var cint;
                                  keyboardTip: Gboolean;
                                  model: var TreeModel;
                                  path: var TreePath; iter: TreeIter): Gboolean {.
    importc: "gtk_icon_view_get_tooltip_context", libgtk.}
proc setTooltipColumn*(iconView: IconView; column: cint) {.
    importc: "gtk_icon_view_set_tooltip_column", libgtk.}
proc `tooltipColumn=`*(iconView: IconView; column: cint) {.
    importc: "gtk_icon_view_set_tooltip_column", libgtk.}
proc getTooltipColumn*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_tooltip_column", libgtk.}
proc tooltipColumn*(iconView: IconView): cint {.
    importc: "gtk_icon_view_get_tooltip_column", libgtk.}

type
  IMContextInfo* =  ptr IMContextInfoObj
  IMContextInfoPtr* = ptr IMContextInfoObj
  IMContextInfoObj* = object
    contextId*: cstring
    contextName*: cstring
    domain*: cstring
    domainDirname*: cstring
    defaultLocales*: cstring

  IMContextSimple* =  ptr IMContextSimpleObj
  IMContextSimplePtr* = ptr IMContextSimpleObj
  IMContextSimpleObj* = object of IMContextObj
    priv81: pointer

  IMContextSimpleClass* =  ptr IMContextSimpleClassObj
  IMContextSimpleClassPtr* = ptr IMContextSimpleClassObj
  IMContextSimpleClassObj*{.final.} = object of IMContextClassObj

const
  MAX_COMPOSE_LEN* = 7

template typeImContextSimple*(): expr =
  (imContextSimpleGetType())

template imContextSimple*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeImContextSimple, IMContextSimpleObj))

template imContextSimpleClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeImContextSimple, IMContextSimpleClassObj))

template isImContextSimple*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeImContextSimple))

template isImContextSimpleClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeImContextSimple))

template imContextSimpleGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeImContextSimple, IMContextSimpleClassObj))

type
  IMMulticontext* =  ptr IMMulticontextObj
  IMMulticontextPtr* = ptr IMMulticontextObj
  IMMulticontextObj* = object of IMContextObj
    priv82: pointer

  IMMulticontextClass* =  ptr IMMulticontextClassObj
  IMMulticontextClassPtr* = ptr IMMulticontextClassObj
  IMMulticontextClassObj*{.final.} = object of IMContextClassObj
    gtkReserved781*: proc () {.cdecl.}
    gtkReserved782*: proc () {.cdecl.}
    gtkReserved783*: proc () {.cdecl.}
    gtkReserved784*: proc () {.cdecl.}

proc imContextSimpleGetType*(): GType {.importc: "gtk_im_context_simple_get_type",
                                        libgtk.}
proc newImContextSimple*(): IMContext {.
    importc: "gtk_im_context_simple_new", libgtk.}
proc imContextSimpleAddTable*(contextSimple: IMContextSimple;
                                data: var uint16; maxSeqLen: cint; nSeqs: cint) {.
    importc: "gtk_im_context_simple_add_table", libgtk.}
proc imContextSimpleAddComposeFile*(contextSimple: IMContextSimple;
                                      composeFile: cstring) {.
    importc: "gtk_im_context_simple_add_compose_file", libgtk.}

template typeImMulticontext*(): expr =
  (imMulticontextGetType())

template imMulticontext*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeImMulticontext, IMMulticontextObj))

template imMulticontextClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeImMulticontext, IMMulticontextClassObj))

template isImMulticontext*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeImMulticontext))

template isImMulticontextClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeImMulticontext))

template imMulticontextGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeImMulticontext, IMMulticontextClassObj))

type
  InfoBar* =  ptr InfoBarObj
  InfoBarPtr* = ptr InfoBarObj
  InfoBarObj*{.final.} = object of BoxObj
    priv83: pointer

  InfoBarClass* =  ptr InfoBarClassObj
  InfoBarClassPtr* = ptr InfoBarClassObj
  InfoBarClassObj*{.final.} = object of BoxClassObj
    response*: proc (infoBar: InfoBar; responseId: cint) {.cdecl.}
    close*: proc (infoBar: InfoBar) {.cdecl.}
    gtkReserved791*: proc () {.cdecl.}
    gtkReserved792*: proc () {.cdecl.}
    gtkReserved793*: proc () {.cdecl.}
    gtkReserved794*: proc () {.cdecl.}

proc imMulticontextGetType*(): GType {.importc: "gtk_im_multicontext_get_type",
                                       libgtk.}
proc newImMulticontext*(): IMContext {.importc: "gtk_im_multicontext_new",
    libgtk.}
proc imMulticontextAppendMenuitems*(context: IMMulticontext;
                                      menushell: MenuShell) {.
    importc: "gtk_im_multicontext_append_menuitems", libgtk.}
proc imMulticontextGetContextId*(context: IMMulticontext): cstring {.
    importc: "gtk_im_multicontext_get_context_id", libgtk.}
proc imMulticontextSetContextId*(context: IMMulticontext;
                                   contextId: cstring) {.
    importc: "gtk_im_multicontext_set_context_id", libgtk.}

template typeInfoBar*(): expr =
  (infoBarGetType())

template infoBar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeInfoBar, InfoBarObj))

template infoBarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeInfoBar, InfoBarClassObj))

template isInfoBar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeInfoBar))

template isInfoBarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeInfoBar))

template infoBarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeInfoBar, InfoBarClassObj))

type
  Invisible* =  ptr InvisibleObj
  InvisiblePtr* = ptr InvisibleObj
  InvisibleObj* = object of WidgetObj
    priv84: pointer

  InvisibleClass* =  ptr InvisibleClassObj
  InvisibleClassPtr* = ptr InvisibleClassObj
  InvisibleClassObj*{.final.} = object of WidgetClassObj
    gtkReserved801*: proc () {.cdecl.}
    gtkReserved802*: proc () {.cdecl.}
    gtkReserved803*: proc () {.cdecl.}
    gtkReserved804*: proc () {.cdecl.}

proc infoBarGetType*(): GType {.importc: "gtk_info_bar_get_type", libgtk.}
proc newInfoBar*(): InfoBar {.importc: "gtk_info_bar_new", libgtk.}
proc getActionArea*(infoBar: InfoBar): Widget {.
    importc: "gtk_info_bar_get_action_area", libgtk.}
proc actionArea*(infoBar: InfoBar): Widget {.
    importc: "gtk_info_bar_get_action_area", libgtk.}
proc getContentArea*(infoBar: InfoBar): Widget {.
    importc: "gtk_info_bar_get_content_area", libgtk.}
proc contentArea*(infoBar: InfoBar): Widget {.
    importc: "gtk_info_bar_get_content_area", libgtk.}
proc addActionWidget*(infoBar: InfoBar; child: Widget;
                               responseId: cint) {.
    importc: "gtk_info_bar_add_action_widget", libgtk.}
proc addButtons*(infoBar: InfoBar; firstButtonText: cstring) {.
    varargs, importc: "gtk_info_bar_add_buttons", libgtk.}
proc setResponseSensitive*(infoBar: InfoBar; responseId: cint;
                                    setting: Gboolean) {.
    importc: "gtk_info_bar_set_response_sensitive", libgtk.}
proc `responseSensitive=`*(infoBar: InfoBar; responseId: cint;
                                    setting: Gboolean) {.
    importc: "gtk_info_bar_set_response_sensitive", libgtk.}
proc setDefaultResponse*(infoBar: InfoBar; responseId: cint) {.
    importc: "gtk_info_bar_set_default_response", libgtk.}
proc `defaultResponse=`*(infoBar: InfoBar; responseId: cint) {.
    importc: "gtk_info_bar_set_default_response", libgtk.}

proc response*(infoBar: InfoBar; responseId: cint) {.
    importc: "gtk_info_bar_response", libgtk.}
proc setMessageType*(infoBar: InfoBar; messageType: MessageType) {.
    importc: "gtk_info_bar_set_message_type", libgtk.}
proc `messageType=`*(infoBar: InfoBar; messageType: MessageType) {.
    importc: "gtk_info_bar_set_message_type", libgtk.}
proc getMessageType*(infoBar: InfoBar): MessageType {.
    importc: "gtk_info_bar_get_message_type", libgtk.}
proc messageType*(infoBar: InfoBar): MessageType {.
    importc: "gtk_info_bar_get_message_type", libgtk.}
proc setShowCloseButton*(infoBar: InfoBar; setting: Gboolean) {.
    importc: "gtk_info_bar_set_show_close_button", libgtk.}
proc `showCloseButton=`*(infoBar: InfoBar; setting: Gboolean) {.
    importc: "gtk_info_bar_set_show_close_button", libgtk.}
proc getShowCloseButton*(infoBar: InfoBar): Gboolean {.
    importc: "gtk_info_bar_get_show_close_button", libgtk.}
proc showCloseButton*(infoBar: InfoBar): Gboolean {.
    importc: "gtk_info_bar_get_show_close_button", libgtk.}

template typeInvisible*(): expr =
  (invisibleGetType())

template invisible*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeInvisible, InvisibleObj))

template invisibleClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeInvisible, InvisibleClassObj))

template isInvisible*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeInvisible))

template isInvisibleClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeInvisible))

template invisibleGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeInvisible, InvisibleClassObj))

type
  Layout* =  ptr LayoutObj
  LayoutPtr* = ptr LayoutObj
  LayoutObj* = object of ContainerObj
    priv85: pointer

  LayoutClass* =  ptr LayoutClassObj
  LayoutClassPtr* = ptr LayoutClassObj
  LayoutClassObj*{.final.} = object of ContainerClassObj
    gtkReserved811*: proc () {.cdecl.}
    gtkReserved812*: proc () {.cdecl.}
    gtkReserved813*: proc () {.cdecl.}
    gtkReserved814*: proc () {.cdecl.}

proc invisibleGetType*(): GType {.importc: "gtk_invisible_get_type", libgtk.}
proc newInvisible*(): Invisible {.importc: "gtk_invisible_new", libgtk.}
proc newInvisible*(screen: gdk3.Screen): Invisible {.
    importc: "gtk_invisible_new_for_screen", libgtk.}
proc setScreen*(invisible: Invisible; screen: gdk3.Screen) {.
    importc: "gtk_invisible_set_screen", libgtk.}
proc `screen=`*(invisible: Invisible; screen: gdk3.Screen) {.
    importc: "gtk_invisible_set_screen", libgtk.}
proc getScreen*(invisible: Invisible): gdk3.Screen {.
    importc: "gtk_invisible_get_screen", libgtk.}
proc screen*(invisible: Invisible): gdk3.Screen {.
    importc: "gtk_invisible_get_screen", libgtk.}

template typeLayout*(): expr =
  (layoutGetType())

template layout*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeLayout, LayoutObj))

template layoutClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeLayout, LayoutClassObj))

template isLayout*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeLayout))

template isLayoutClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeLayout))

template layoutGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeLayout, LayoutClassObj))

proc layoutGetType*(): GType {.importc: "gtk_layout_get_type", libgtk.}
proc newLayout*(hadjustment: Adjustment; vadjustment: Adjustment): Layout {.
    importc: "gtk_layout_new", libgtk.}
proc getBinWindow*(layout: Layout): gdk3.Window {.
    importc: "gtk_layout_get_bin_window", libgtk.}
proc binWindow*(layout: Layout): gdk3.Window {.
    importc: "gtk_layout_get_bin_window", libgtk.}
proc put*(layout: Layout; childWidget: Widget; x: cint; y: cint) {.
    importc: "gtk_layout_put", libgtk.}
proc move*(layout: Layout; childWidget: Widget; x: cint; y: cint) {.
    importc: "gtk_layout_move", libgtk.}
proc setSize*(layout: Layout; width: cuint; height: cuint) {.
    importc: "gtk_layout_set_size", libgtk.}
proc `size=`*(layout: Layout; width: cuint; height: cuint) {.
    importc: "gtk_layout_set_size", libgtk.}
proc getSize*(layout: Layout; width: var cuint; height: var cuint) {.
    importc: "gtk_layout_get_size", libgtk.}
proc getHadjustment*(layout: Layout): Adjustment {.
    importc: "gtk_layout_get_hadjustment", libgtk.}
proc hadjustment*(layout: Layout): Adjustment {.
    importc: "gtk_layout_get_hadjustment", libgtk.}
proc getVadjustment*(layout: Layout): Adjustment {.
    importc: "gtk_layout_get_vadjustment", libgtk.}
proc vadjustment*(layout: Layout): Adjustment {.
    importc: "gtk_layout_get_vadjustment", libgtk.}
proc setHadjustment*(layout: Layout; adjustment: Adjustment) {.
    importc: "gtk_layout_set_hadjustment", libgtk.}
proc `hadjustment=`*(layout: Layout; adjustment: Adjustment) {.
    importc: "gtk_layout_set_hadjustment", libgtk.}
proc setVadjustment*(layout: Layout; adjustment: Adjustment) {.
    importc: "gtk_layout_set_vadjustment", libgtk.}
proc `vadjustment=`*(layout: Layout; adjustment: Adjustment) {.
    importc: "gtk_layout_set_vadjustment", libgtk.}

template typeLevelBar*(): expr =
  (levelBarGetType())

template levelBar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeLevelBar, LevelBarObj))

template levelBarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeLevelBar, LevelBarClassObj))

template isLevelBar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeLevelBar))

template isLevelBarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeLevelBar))

template levelBarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeLevelBar, LevelBarClassObj))

const
  LEVEL_BAR_OFFSET_LOW* = "low"

const
  LEVEL_BAR_OFFSET_HIGH* = "high"

const
  LEVEL_BAR_OFFSET_FULL* = "full"

type
  LevelBar* =  ptr LevelBarObj
  LevelBarPtr* = ptr LevelBarObj
  LevelBarObj*{.final.} = object of WidgetObj
    priv86: pointer

  LevelBarClass* =  ptr LevelBarClassObj
  LevelBarClassPtr* = ptr LevelBarClassObj
  LevelBarClassObj*{.final.} = object of WidgetClassObj
    offsetChanged*: proc (self: LevelBar; name: cstring) {.cdecl.}
    padding*: array[16, Gpointer]

  LinkButton* =  ptr LinkButtonObj
  LinkButtonPtr* = ptr LinkButtonObj
  LinkButtonObj*{.final.} = object of ButtonObj
    priv87: pointer

  LinkButtonClass* =  ptr LinkButtonClassObj
  LinkButtonClassPtr* = ptr LinkButtonClassObj
  LinkButtonClassObj*{.final.} = object of ButtonClassObj
    activateLink*: proc (button: LinkButton): Gboolean {.cdecl.}
    gtkPadding1*: proc () {.cdecl.}
    gtkPadding2*: proc () {.cdecl.}
    gtkPadding3*: proc () {.cdecl.}
    gtkPadding4*: proc () {.cdecl.}

proc levelBarGetType*(): GType {.importc: "gtk_level_bar_get_type", libgtk.}
proc newLevelBar*(): LevelBar {.importc: "gtk_level_bar_new", libgtk.}
proc setMode*(self: LevelBar; mode: LevelBarMode) {.
    importc: "gtk_level_bar_set_mode", libgtk.}
proc `mode=`*(self: LevelBar; mode: LevelBarMode) {.
    importc: "gtk_level_bar_set_mode", libgtk.}
proc getMode*(self: LevelBar): LevelBarMode {.
    importc: "gtk_level_bar_get_mode", libgtk.}
proc mode*(self: LevelBar): LevelBarMode {.
    importc: "gtk_level_bar_get_mode", libgtk.}
proc setValue*(self: LevelBar; value: cdouble) {.
    importc: "gtk_level_bar_set_value", libgtk.}
proc `value=`*(self: LevelBar; value: cdouble) {.
    importc: "gtk_level_bar_set_value", libgtk.}
proc getValue*(self: LevelBar): cdouble {.
    importc: "gtk_level_bar_get_value", libgtk.}
proc value*(self: LevelBar): cdouble {.
    importc: "gtk_level_bar_get_value", libgtk.}
proc setMinValue*(self: LevelBar; value: cdouble) {.
    importc: "gtk_level_bar_set_min_value", libgtk.}
proc `minValue=`*(self: LevelBar; value: cdouble) {.
    importc: "gtk_level_bar_set_min_value", libgtk.}
proc getMinValue*(self: LevelBar): cdouble {.
    importc: "gtk_level_bar_get_min_value", libgtk.}
proc minValue*(self: LevelBar): cdouble {.
    importc: "gtk_level_bar_get_min_value", libgtk.}
proc setMaxValue*(self: LevelBar; value: cdouble) {.
    importc: "gtk_level_bar_set_max_value", libgtk.}
proc `maxValue=`*(self: LevelBar; value: cdouble) {.
    importc: "gtk_level_bar_set_max_value", libgtk.}
proc getMaxValue*(self: LevelBar): cdouble {.
    importc: "gtk_level_bar_get_max_value", libgtk.}
proc maxValue*(self: LevelBar): cdouble {.
    importc: "gtk_level_bar_get_max_value", libgtk.}
proc setInverted*(self: LevelBar; inverted: Gboolean) {.
    importc: "gtk_level_bar_set_inverted", libgtk.}
proc `inverted=`*(self: LevelBar; inverted: Gboolean) {.
    importc: "gtk_level_bar_set_inverted", libgtk.}
proc getInverted*(self: LevelBar): Gboolean {.
    importc: "gtk_level_bar_get_inverted", libgtk.}
proc inverted*(self: LevelBar): Gboolean {.
    importc: "gtk_level_bar_get_inverted", libgtk.}
proc addOffsetValue*(self: LevelBar; name: cstring; value: cdouble) {.
    importc: "gtk_level_bar_add_offset_value", libgtk.}
proc removeOffsetValue*(self: LevelBar; name: cstring) {.
    importc: "gtk_level_bar_remove_offset_value", libgtk.}
proc getOffsetValue*(self: LevelBar; name: cstring;
                               value: var cdouble): Gboolean {.
    importc: "gtk_level_bar_get_offset_value", libgtk.}
proc offsetValue*(self: LevelBar; name: cstring;
                               value: var cdouble): Gboolean {.
    importc: "gtk_level_bar_get_offset_value", libgtk.}

template typeLinkButton*(): expr =
  (linkButtonGetType())

template linkButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeLinkButton, LinkButtonObj))

template isLinkButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeLinkButton))

template linkButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeLinkButton, LinkButtonClassObj))

template isLinkButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeLinkButton))

template linkButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeLinkButton, LinkButtonClassObj))

type
  ListBox* =  ptr ListBoxObj
  ListBoxPtr* = ptr ListBoxObj
  ListBoxObj*{.final.} = object of ContainerObj

  ListBoxRow* =  ptr ListBoxRowObj
  ListBoxRowPtr* = ptr ListBoxRowObj
  ListBoxRowObj*{.final.} = object of BinObj

  ListBoxClass* =  ptr ListBoxClassObj
  ListBoxClassPtr* = ptr ListBoxClassObj
  ListBoxClassObj*{.final.} = object of ContainerClassObj
    rowSelected*: proc (box: ListBox; row: ListBoxRow) {.cdecl.}
    rowActivated*: proc (box: ListBox; row: ListBoxRow) {.cdecl.}
    activateCursorRow*: proc (box: ListBox) {.cdecl.}
    toggleCursorRow*: proc (box: ListBox) {.cdecl.}
    moveCursor*: proc (box: ListBox; step: MovementStep; count: cint) {.cdecl.}
    selectedRowsChanged*: proc (box: ListBox) {.cdecl.}
    selectAll*: proc (box: ListBox) {.cdecl.}
    unselectAll*: proc (box: ListBox) {.cdecl.}
    gtkReserved821*: proc () {.cdecl.}
    gtkReserved822*: proc () {.cdecl.}
    gtkReserved823*: proc () {.cdecl.}

proc linkButtonGetType*(): GType {.importc: "gtk_link_button_get_type",
                                   libgtk.}
proc newLinkButton*(uri: cstring): LinkButton {.importc: "gtk_link_button_new",
    libgtk.}
proc getUri*(linkButton: LinkButton): cstring {.
    importc: "gtk_link_button_get_uri", libgtk.}
proc uri*(linkButton: LinkButton): cstring {.
    importc: "gtk_link_button_get_uri", libgtk.}
proc setUri*(linkButton: LinkButton; uri: cstring) {.
    importc: "gtk_link_button_set_uri", libgtk.}
proc `uri=`*(linkButton: LinkButton; uri: cstring) {.
    importc: "gtk_link_button_set_uri", libgtk.}
proc getVisited*(linkButton: LinkButton): Gboolean {.
    importc: "gtk_link_button_get_visited", libgtk.}
proc visited*(linkButton: LinkButton): Gboolean {.
    importc: "gtk_link_button_get_visited", libgtk.}
proc setVisited*(linkButton: LinkButton; visited: Gboolean) {.
    importc: "gtk_link_button_set_visited", libgtk.}
proc `visited=`*(linkButton: LinkButton; visited: Gboolean) {.
    importc: "gtk_link_button_set_visited", libgtk.}

template typeListBox*(): expr =
  (listBoxGetType())

template listBox*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeListBox, ListBoxObj))

template listBoxClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeListBox, ListBoxClassObj))

template isListBox*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeListBox))

template isListBoxClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeListBox))

template listBoxGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeListBox, ListBoxClassObj))

type
  ListBoxRowClass* =  ptr ListBoxRowClassObj
  ListBoxRowClassPtr* = ptr ListBoxRowClassObj
  ListBoxRowClassObj*{.final.} = object of BinClassObj
    activate*: proc (row: ListBoxRow) {.cdecl.}
    gtkReserved831*: proc () {.cdecl.}
    gtkReserved832*: proc () {.cdecl.}

template typeListBoxRow*(): expr =
  (listBoxRowGetType())

template listBoxRow*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeListBoxRow, ListBoxRowObj))

template listBoxRowClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeListBoxRow, ListBoxRowClassObj))

template isListBoxRow*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeListBoxRow))

template isListBoxRowClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeListBoxRow))

template listBoxRowGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeListBoxRow, ListBoxRowClassObj))

type
  LockButton* =  ptr LockButtonObj
  LockButtonPtr* = ptr LockButtonObj
  LockButtonObj*{.final.} = object of ButtonObj
    priv88: pointer

  LockButtonClass* =  ptr LockButtonClassObj
  LockButtonClassPtr* = ptr LockButtonClassObj
  LockButtonClassObj*{.final.} = object of ButtonClassObj
    reserved0: proc () {.cdecl.}
    reserved1: proc () {.cdecl.}
    reserved2: proc () {.cdecl.}
    reserved3: proc () {.cdecl.}
    reserved4: proc () {.cdecl.}
    reserved5: proc () {.cdecl.}
    reserved6: proc () {.cdecl.}
    reserved7: proc () {.cdecl.}

type
  ListBoxFilterFunc* = proc (row: ListBoxRow; userData: Gpointer): Gboolean {.cdecl.}

type
  ListBoxSortFunc* = proc (row1: ListBoxRow; row2: ListBoxRow;
                           userData: Gpointer): cint {.cdecl.}

type
  ListBoxUpdateHeaderFunc* = proc (row: ListBoxRow;
                                   before: ListBoxRow; userData: Gpointer) {.cdecl.}

type
  ListBoxCreateWidgetFunc* = proc (item: Gpointer; userData: Gpointer): Widget {.cdecl.}

proc listBoxRowGetType*(): GType {.importc: "gtk_list_box_row_get_type",
                                   libgtk.}
proc newListBoxRow*(): ListBoxRow {.importc: "gtk_list_box_row_new", libgtk.}
proc getHeader*(row: ListBoxRow): Widget {.
    importc: "gtk_list_box_row_get_header", libgtk.}
proc header*(row: ListBoxRow): Widget {.
    importc: "gtk_list_box_row_get_header", libgtk.}
proc setHeader*(row: ListBoxRow; header: Widget) {.
    importc: "gtk_list_box_row_set_header", libgtk.}
proc `header=`*(row: ListBoxRow; header: Widget) {.
    importc: "gtk_list_box_row_set_header", libgtk.}
proc getIndex*(row: ListBoxRow): cint {.
    importc: "gtk_list_box_row_get_index", libgtk.}
proc index*(row: ListBoxRow): cint {.
    importc: "gtk_list_box_row_get_index", libgtk.}
proc changed*(row: ListBoxRow) {.
    importc: "gtk_list_box_row_changed", libgtk.}
proc isSelected*(row: ListBoxRow): Gboolean {.
    importc: "gtk_list_box_row_is_selected", libgtk.}
proc setSelectable*(row: ListBoxRow; selectable: Gboolean) {.
    importc: "gtk_list_box_row_set_selectable", libgtk.}
proc `selectable=`*(row: ListBoxRow; selectable: Gboolean) {.
    importc: "gtk_list_box_row_set_selectable", libgtk.}
proc getSelectable*(row: ListBoxRow): Gboolean {.
    importc: "gtk_list_box_row_get_selectable", libgtk.}
proc selectable*(row: ListBoxRow): Gboolean {.
    importc: "gtk_list_box_row_get_selectable", libgtk.}
proc setActivatable*(row: ListBoxRow; activatable: Gboolean) {.
    importc: "gtk_list_box_row_set_activatable", libgtk.}
proc `activatable=`*(row: ListBoxRow; activatable: Gboolean) {.
    importc: "gtk_list_box_row_set_activatable", libgtk.}
proc getActivatable*(row: ListBoxRow): Gboolean {.
    importc: "gtk_list_box_row_get_activatable", libgtk.}
proc activatable*(row: ListBoxRow): Gboolean {.
    importc: "gtk_list_box_row_get_activatable", libgtk.}
proc listBoxGetType*(): GType {.importc: "gtk_list_box_get_type", libgtk.}
proc prepend*(box: ListBox; child: Widget) {.
    importc: "gtk_list_box_prepend", libgtk.}
proc insert*(box: ListBox; child: Widget; position: cint) {.
    importc: "gtk_list_box_insert", libgtk.}
proc getSelectedRow*(box: ListBox): ListBoxRow {.
    importc: "gtk_list_box_get_selected_row", libgtk.}
proc selectedRow*(box: ListBox): ListBoxRow {.
    importc: "gtk_list_box_get_selected_row", libgtk.}
proc getRowAtIndex*(box: ListBox; index: cint): ListBoxRow {.
    importc: "gtk_list_box_get_row_at_index", libgtk.}
proc rowAtIndex*(box: ListBox; index: cint): ListBoxRow {.
    importc: "gtk_list_box_get_row_at_index", libgtk.}
proc getRowAtY*(box: ListBox; y: cint): ListBoxRow {.
    importc: "gtk_list_box_get_row_at_y", libgtk.}
proc rowAtY*(box: ListBox; y: cint): ListBoxRow {.
    importc: "gtk_list_box_get_row_at_y", libgtk.}
proc selectRow*(box: ListBox; row: ListBoxRow) {.
    importc: "gtk_list_box_select_row", libgtk.}
proc setPlaceholder*(box: ListBox; placeholder: Widget) {.
    importc: "gtk_list_box_set_placeholder", libgtk.}
proc `placeholder=`*(box: ListBox; placeholder: Widget) {.
    importc: "gtk_list_box_set_placeholder", libgtk.}
proc setAdjustment*(box: ListBox; adjustment: Adjustment) {.
    importc: "gtk_list_box_set_adjustment", libgtk.}
proc `adjustment=`*(box: ListBox; adjustment: Adjustment) {.
    importc: "gtk_list_box_set_adjustment", libgtk.}
proc getAdjustment*(box: ListBox): Adjustment {.
    importc: "gtk_list_box_get_adjustment", libgtk.}
proc adjustment*(box: ListBox): Adjustment {.
    importc: "gtk_list_box_get_adjustment", libgtk.}
type
  ListBoxForeachFunc* = proc (box: ListBox; row: ListBoxRow;
                              userData: Gpointer) {.cdecl.}

proc selectedForeach*(box: ListBox; `func`: ListBoxForeachFunc;
                               data: Gpointer) {.
    importc: "gtk_list_box_selected_foreach", libgtk.}
proc getSelectedRows*(box: ListBox): glib.GList {.
    importc: "gtk_list_box_get_selected_rows", libgtk.}
proc selectedRows*(box: ListBox): glib.GList {.
    importc: "gtk_list_box_get_selected_rows", libgtk.}
proc unselectRow*(box: ListBox; row: ListBoxRow) {.
    importc: "gtk_list_box_unselect_row", libgtk.}
proc selectAll*(box: ListBox) {.importc: "gtk_list_box_select_all",
    libgtk.}
proc unselectAll*(box: ListBox) {.
    importc: "gtk_list_box_unselect_all", libgtk.}
proc setSelectionMode*(box: ListBox; mode: SelectionMode) {.
    importc: "gtk_list_box_set_selection_mode", libgtk.}
proc `selectionMode=`*(box: ListBox; mode: SelectionMode) {.
    importc: "gtk_list_box_set_selection_mode", libgtk.}
proc getSelectionMode*(box: ListBox): SelectionMode {.
    importc: "gtk_list_box_get_selection_mode", libgtk.}
proc selectionMode*(box: ListBox): SelectionMode {.
    importc: "gtk_list_box_get_selection_mode", libgtk.}
proc setFilterFunc*(box: ListBox; filterFunc: ListBoxFilterFunc;
                             userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_list_box_set_filter_func", libgtk.}
proc `filterFunc=`*(box: ListBox; filterFunc: ListBoxFilterFunc;
                             userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_list_box_set_filter_func", libgtk.}
proc setHeaderFunc*(box: ListBox;
                             updateHeader: ListBoxUpdateHeaderFunc;
                             userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_list_box_set_header_func", libgtk.}
proc `headerFunc=`*(box: ListBox;
                             updateHeader: ListBoxUpdateHeaderFunc;
                             userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_list_box_set_header_func", libgtk.}
proc invalidateFilter*(box: ListBox) {.
    importc: "gtk_list_box_invalidate_filter", libgtk.}
proc invalidateSort*(box: ListBox) {.
    importc: "gtk_list_box_invalidate_sort", libgtk.}
proc invalidateHeaders*(box: ListBox) {.
    importc: "gtk_list_box_invalidate_headers", libgtk.}
proc setSortFunc*(box: ListBox; sortFunc: ListBoxSortFunc;
                           userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_list_box_set_sort_func", libgtk.}
proc `sortFunc=`*(box: ListBox; sortFunc: ListBoxSortFunc;
                           userData: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_list_box_set_sort_func", libgtk.}
proc setActivateOnSingleClick*(box: ListBox; single: Gboolean) {.
    importc: "gtk_list_box_set_activate_on_single_click", libgtk.}
proc `activateOnSingleClick=`*(box: ListBox; single: Gboolean) {.
    importc: "gtk_list_box_set_activate_on_single_click", libgtk.}
proc getActivateOnSingleClick*(box: ListBox): Gboolean {.
    importc: "gtk_list_box_get_activate_on_single_click", libgtk.}
proc activateOnSingleClick*(box: ListBox): Gboolean {.
    importc: "gtk_list_box_get_activate_on_single_click", libgtk.}
proc dragUnhighlightRow*(box: ListBox) {.
    importc: "gtk_list_box_drag_unhighlight_row", libgtk.}
proc dragHighlightRow*(box: ListBox; row: ListBoxRow) {.
    importc: "gtk_list_box_drag_highlight_row", libgtk.}
proc newListBox*(): ListBox {.importc: "gtk_list_box_new", libgtk.}
proc bindModel*(box: ListBox; model: gio.GListModel;
                         createWidgetFunc: ListBoxCreateWidgetFunc;
                         userData: Gpointer; userDataFreeFunc: GDestroyNotify) {.
    importc: "gtk_list_box_bind_model", libgtk.}

template typeLockButton*(): expr =
  (lockButtonGetType())

template lockButton*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeLockButton, LockButtonObj))

template lockButtonClass*(k: expr): expr =
  (gTypeCheckClassCast(k, lockButton, gtkLockButtonClass))

template isLockButton*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeLockButton))

template isLockButtonClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeLockButton))

template lockButtonGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeLockButton, LockButtonClassObj))

type
  MenuBar* =  ptr MenuBarObj
  MenuBarPtr* = ptr MenuBarObj
  MenuBarObj* = object
    menuShell*: MenuShellObj
    priv89: pointer

  MenuBarClass* =  ptr MenuBarClassObj
  MenuBarClassPtr* = ptr MenuBarClassObj
  MenuBarClassObj*{.final.} = object of MenuShellClassObj
    gtkReserved841*: proc () {.cdecl.}
    gtkReserved842*: proc () {.cdecl.}
    gtkReserved843*: proc () {.cdecl.}
    gtkReserved844*: proc () {.cdecl.}

proc lockButtonGetType*(): GType {.importc: "gtk_lock_button_get_type",
                                   libgtk.}
proc newLockButton*(permission: gio.GPermission): LockButton {.
    importc: "gtk_lock_button_new", libgtk.}
proc getPermission*(button: LockButton): gio.GPermission {.
    importc: "gtk_lock_button_get_permission", libgtk.}
proc permission*(button: LockButton): gio.GPermission {.
    importc: "gtk_lock_button_get_permission", libgtk.}
proc setPermission*(button: LockButton;
                                permission: gio.GPermission) {.
    importc: "gtk_lock_button_set_permission", libgtk.}
proc `permission=`*(button: LockButton;
                                permission: gio.GPermission) {.
    importc: "gtk_lock_button_set_permission", libgtk.}

type
  KeySnoopFunc* = proc (grabWidget: Widget; event: gdk3.EventKey;
                        funcData: Gpointer): cint {.cdecl.}

proc getMajorVersion*(): cuint {.importc: "gtk_get_major_version", libgtk.}

proc majorVersion*(): cuint {.importc: "gtk_get_major_version", libgtk.}
proc getMinorVersion*(): cuint {.importc: "gtk_get_minor_version", libgtk.}
proc minorVersion*(): cuint {.importc: "gtk_get_minor_version", libgtk.}
proc getMicroVersion*(): cuint {.importc: "gtk_get_micro_version", libgtk.}
proc microVersion*(): cuint {.importc: "gtk_get_micro_version", libgtk.}
proc getBinaryAge*(): cuint {.importc: "gtk_get_binary_age", libgtk.}
proc binaryAge*(): cuint {.importc: "gtk_get_binary_age", libgtk.}
proc getInterfaceAge*(): cuint {.importc: "gtk_get_interface_age", libgtk.}
proc interfaceAge*(): cuint {.importc: "gtk_get_interface_age", libgtk.}
proc checkVersion*(requiredMajor: cuint; requiredMinor: cuint;
                     requiredMicro: cuint): cstring {.importc: "gtk_check_version",
    libgtk.}

proc parseArgs*(argc: var cint; argv: var cstringArray): Gboolean {.
    importc: "gtk_parse_args", libgtk.}
proc init*(argc: var cint; argv: var cstringArray) {.importc: "gtk_init", libgtk.}
proc initCheck*(argc: var cint; argv: var cstringArray): Gboolean {.
    importc: "gtk_init_check", libgtk.}
proc initWithArgs*(argc: var cint; argv: var cstringArray; parameterString: cstring;
                     entries: glib.GOptionEntry; translationDomain: cstring;
                     error: var glib.GError): Gboolean {.
    importc: "gtk_init_with_args", libgtk.}
proc getOptionGroup*(openDefaultDisplay: Gboolean): glib.GOptionGroup {.
    importc: "gtk_get_option_group", libgtk.}
proc optionGroup*(openDefaultDisplay: Gboolean): glib.GOptionGroup {.
    importc: "gtk_get_option_group", libgtk.}
when defined(windows):
  proc initAbiCheck*(argc: var cint; argv: var cstringArray; numChecks: cint;
                       sizeofGtkWindow: csize; sizeofGtkBox: csize) {.
      importc: "gtk_init_abi_check", libgtk.}
  proc initCheckAbiCheck*(argc: var cint; argv: var cstringArray; numChecks: cint;
                            sizeofGtkWindow: csize; sizeofGtkBox: csize): Gboolean {.
      importc: "gtk_init_check_abi_check", libgtk.}
  template init*(argc, argv: expr): expr =
    gtkInitAbiCheck(argc, argv, 2, sizeof(gtkWindow), sizeof(gtkBox))

  template initCheck*(argc, argv: expr): expr =
    gtkInitCheckAbiCheck(argc, argv, 2, sizeof(gtkWindow), sizeof(gtkBox))

proc disableSetlocale*() {.importc: "gtk_disable_setlocale", libgtk.}
proc getDefaultLanguage*(): pango.Language {.
    importc: "gtk_get_default_language", libgtk.}
proc defaultLanguage*(): pango.Language {.
    importc: "gtk_get_default_language", libgtk.}
proc getLocaleDirection*(): TextDirection {.
    importc: "gtk_get_locale_direction", libgtk.}
proc localeDirection*(): TextDirection {.
    importc: "gtk_get_locale_direction", libgtk.}
proc eventsPending*(): Gboolean {.importc: "gtk_events_pending", libgtk.}
proc mainDoEvent*(event: gdk3.Event) {.importc: "gtk_main_do_event", libgtk.}
proc main*() {.importc: "gtk_main", libgtk.}
proc mainLevel*(): cuint {.importc: "gtk_main_level", libgtk.}
proc mainQuit*() {.importc: "gtk_main_quit", libgtk.}
proc mainIteration*(): Gboolean {.importc: "gtk_main_iteration", libgtk.}
proc mainIterationDo*(blocking: Gboolean): Gboolean {.
    importc: "gtk_main_iteration_do", libgtk.}
proc gtkTrue*(): Gboolean {.importc: "gtk_true", libgtk.}
proc gtkFalse*(): Gboolean {.importc: "gtk_false", libgtk.}
proc grabAdd*(widget: Widget) {.importc: "gtk_grab_add", libgtk.}
proc grabGetCurrent*(): Widget {.importc: "gtk_grab_get_current",
                                       libgtk.}
proc grabRemove*(widget: Widget) {.importc: "gtk_grab_remove", libgtk.}
proc deviceGrabAdd*(widget: Widget; device: gdk3.Device;
                      blockOthers: Gboolean) {.importc: "gtk_device_grab_add",
    libgtk.}
proc deviceGrabRemove*(widget: Widget; device: gdk3.Device) {.
    importc: "gtk_device_grab_remove", libgtk.}
proc keySnooperInstall*(snooper: KeySnoopFunc; funcData: Gpointer): cuint {.
    importc: "gtk_key_snooper_install", libgtk.}
proc keySnooperRemove*(snooperHandlerId: cuint) {.
    importc: "gtk_key_snooper_remove", libgtk.}
proc getCurrentEvent*(): gdk3.Event {.importc: "gtk_get_current_event",
                                       libgtk.}
proc currentEvent*(): gdk3.Event {.importc: "gtk_get_current_event",
                                       libgtk.}
proc getCurrentEventTime*(): uint32 {.importc: "gtk_get_current_event_time",
                                       libgtk.}
proc currentEventTime*(): uint32 {.importc: "gtk_get_current_event_time",
                                       libgtk.}
proc getCurrentEventState*(state: ptr gdk3.ModifierType): Gboolean {.
    importc: "gtk_get_current_event_state", libgtk.}
proc currentEventState*(state: ptr gdk3.ModifierType): Gboolean {.
    importc: "gtk_get_current_event_state", libgtk.}
proc getCurrentEventDevice*(): gdk3.Device {.
    importc: "gtk_get_current_event_device", libgtk.}
proc currentEventDevice*(): gdk3.Device {.
    importc: "gtk_get_current_event_device", libgtk.}
proc getEventWidget*(event: gdk3.Event): Widget {.
    importc: "gtk_get_event_widget", libgtk.}
proc eventWidget*(event: gdk3.Event): Widget {.
    importc: "gtk_get_event_widget", libgtk.}
proc propagateEvent*(widget: Widget; event: gdk3.Event) {.
    importc: "gtk_propagate_event", libgtk.}

template typeMenuBar*(): expr =
  (menuBarGetType())

template menuBar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeMenuBar, MenuBarObj))

template menuBarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeMenuBar, MenuBarClassObj))

template isMenuBar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeMenuBar))

template isMenuBarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeMenuBar))

template menuBarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeMenuBar, MenuBarClassObj))

type
  Popover* =  ptr PopoverObj
  PopoverPtr* = ptr PopoverObj
  PopoverObj*{.final.} = object of BinObj
    priv90: pointer

  PopoverClass* =  ptr PopoverClassObj
  PopoverClassPtr* = ptr PopoverClassObj
  PopoverClassObj = object of BinClassObj
    closed*: proc (popover: Popover) {.cdecl.}
    reserved: array[10, Gpointer]

proc menuBarGetType*(): GType {.importc: "gtk_menu_bar_get_type", libgtk.}
proc newMenuBar*(): MenuBar {.importc: "gtk_menu_bar_new", libgtk.}
proc getPackDirection*(menubar: MenuBar): PackDirection {.
    importc: "gtk_menu_bar_get_pack_direction", libgtk.}
proc packDirection*(menubar: MenuBar): PackDirection {.
    importc: "gtk_menu_bar_get_pack_direction", libgtk.}
proc setPackDirection*(menubar: MenuBar; packDir: PackDirection) {.
    importc: "gtk_menu_bar_set_pack_direction", libgtk.}
proc `packDirection=`*(menubar: MenuBar; packDir: PackDirection) {.
    importc: "gtk_menu_bar_set_pack_direction", libgtk.}
proc getChildPackDirection*(menubar: MenuBar): PackDirection {.
    importc: "gtk_menu_bar_get_child_pack_direction", libgtk.}
proc childPackDirection*(menubar: MenuBar): PackDirection {.
    importc: "gtk_menu_bar_get_child_pack_direction", libgtk.}
proc setChildPackDirection*(menubar: MenuBar;
                                     childPackDir: PackDirection) {.
    importc: "gtk_menu_bar_set_child_pack_direction", libgtk.}
proc `childPackDirection=`*(menubar: MenuBar;
                                     childPackDir: PackDirection) {.
    importc: "gtk_menu_bar_set_child_pack_direction", libgtk.}

discard """ proc "cycleFocus*(menubar: MenuBar; dir: DirectionType) {.
    importc: "_gtk_menu_bar_cycle_focus", libgtk.}"""

discard """ proc "menuBarGetViewableMenuBars*(window: Window): glib.GList {.
    importc: "_gtk_menu_bar_get_viewable_menu_bars", libgtk.}"""

template typePopover*(): expr =
  (popoverGetType())

template popover*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typePopover, PopoverObj))

template popoverClass*(c: expr): expr =
  (gTypeCheckClassCast(c, typePopover, PopoverClassObj))

template isPopover*(o: expr): expr =
  (gTypeCheckInstanceType(o, typePopover))

template isPopoverClass*(o: expr): expr =
  (gTypeCheckClassType(o, typePopover))

template popoverGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typePopover, PopoverClassObj))

type
  MenuButton* =  ptr MenuButtonObj
  MenuButtonPtr* = ptr MenuButtonObj
  MenuButtonObj*{.final.} = object of ToggleButtonObj
    priv91: pointer

  MenuButtonClass* =  ptr MenuButtonClassObj
  MenuButtonClassPtr* = ptr MenuButtonClassObj
  MenuButtonClassObj*{.final.} = object of ToggleButtonClassObj
    gtkReserved851*: proc () {.cdecl.}
    gtkReserved852*: proc () {.cdecl.}
    gtkReserved853*: proc () {.cdecl.}
    gtkReserved854*: proc () {.cdecl.}

proc popoverGetType*(): GType {.importc: "gtk_popover_get_type", libgtk.}
proc newPopover*(relativeTo: Widget): Popover {.
    importc: "gtk_popover_new", libgtk.}
proc setRelativeTo*(popover: Popover; relativeTo: Widget) {.
    importc: "gtk_popover_set_relative_to", libgtk.}
proc `relativeTo=`*(popover: Popover; relativeTo: Widget) {.
    importc: "gtk_popover_set_relative_to", libgtk.}
proc getRelativeTo*(popover: Popover): Widget {.
    importc: "gtk_popover_get_relative_to", libgtk.}
proc relativeTo*(popover: Popover): Widget {.
    importc: "gtk_popover_get_relative_to", libgtk.}
proc setPointingTo*(popover: Popover; rect: gdk3.Rectangle) {.
    importc: "gtk_popover_set_pointing_to", libgtk.}
proc `pointingTo=`*(popover: Popover; rect: gdk3.Rectangle) {.
    importc: "gtk_popover_set_pointing_to", libgtk.}
proc getPointingTo*(popover: Popover; rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_popover_get_pointing_to", libgtk.}
proc pointingTo*(popover: Popover; rect: gdk3.Rectangle): Gboolean {.
    importc: "gtk_popover_get_pointing_to", libgtk.}
proc setPosition*(popover: Popover; position: PositionType) {.
    importc: "gtk_popover_set_position", libgtk.}
proc `position=`*(popover: Popover; position: PositionType) {.
    importc: "gtk_popover_set_position", libgtk.}
proc getPosition*(popover: Popover): PositionType {.
    importc: "gtk_popover_get_position", libgtk.}
proc position*(popover: Popover): PositionType {.
    importc: "gtk_popover_get_position", libgtk.}
proc setModal*(popover: Popover; modal: Gboolean) {.
    importc: "gtk_popover_set_modal", libgtk.}
proc `modal=`*(popover: Popover; modal: Gboolean) {.
    importc: "gtk_popover_set_modal", libgtk.}
proc getModal*(popover: Popover): Gboolean {.
    importc: "gtk_popover_get_modal", libgtk.}
proc modal*(popover: Popover): Gboolean {.
    importc: "gtk_popover_get_modal", libgtk.}
proc bindModel*(popover: Popover; model: gio.GMenuModel;
                         actionNamespace: cstring) {.
    importc: "gtk_popover_bind_model", libgtk.}
proc setTransitionsEnabled*(popover: Popover;
                                     transitionsEnabled: Gboolean) {.
    importc: "gtk_popover_set_transitions_enabled", libgtk.}
proc `transitionsEnabled=`*(popover: Popover;
                                     transitionsEnabled: Gboolean) {.
    importc: "gtk_popover_set_transitions_enabled", libgtk.}
proc getTransitionsEnabled*(popover: Popover): Gboolean {.
    importc: "gtk_popover_get_transitions_enabled", libgtk.}
proc transitionsEnabled*(popover: Popover): Gboolean {.
    importc: "gtk_popover_get_transitions_enabled", libgtk.}
proc setDefaultWidget*(popover: Popover; widget: Widget) {.
    importc: "gtk_popover_set_default_widget", libgtk.}
proc `defaultWidget=`*(popover: Popover; widget: Widget) {.
    importc: "gtk_popover_set_default_widget", libgtk.}
proc getDefaultWidget*(popover: Popover): Widget {.
    importc: "gtk_popover_get_default_widget", libgtk.}
proc defaultWidget*(popover: Popover): Widget {.
    importc: "gtk_popover_get_default_widget", libgtk.}
proc setConstrainTo*(popover: Popover;
                              constraint: PopoverConstraint) {.
    importc: "gtk_popover_set_constrain_to", libgtk.}
proc `constrainTo=`*(popover: Popover;
                              constraint: PopoverConstraint) {.
    importc: "gtk_popover_set_constrain_to", libgtk.}
proc getConstrainTo*(popover: Popover): PopoverConstraint {.
    importc: "gtk_popover_get_constrain_to", libgtk.}
proc constrainTo*(popover: Popover): PopoverConstraint {.
    importc: "gtk_popover_get_constrain_to", libgtk.}

template typeMenuButton*(): expr =
  (menuButtonGetType())

template menuButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeMenuButton, MenuButtonObj))

template menuButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeMenuButton, MenuButtonClassObj))

template isMenuButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeMenuButton))

template isMenuButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeMenuButton))

template menuButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeMenuButton, MenuButtonClassObj))

type
  SizeGroup* =  ptr SizeGroupObj
  SizeGroupPtr* = ptr SizeGroupObj
  SizeGroupObj*{.final.} = object of GObjectObj
    priv92: pointer

  SizeGroupClass* =  ptr SizeGroupClassObj
  SizeGroupClassPtr* = ptr SizeGroupClassObj
  SizeGroupClassObj*{.final.} = object of GObjectClassObj
    gtkReserved861*: proc () {.cdecl.}
    gtkReserved862*: proc () {.cdecl.}
    gtkReserved863*: proc () {.cdecl.}
    gtkReserved864*: proc () {.cdecl.}

proc menuButtonGetType*(): GType {.importc: "gtk_menu_button_get_type",
                                   libgtk.}
proc newMenuButton*(): MenuButton {.importc: "gtk_menu_button_new", libgtk.}
proc setPopup*(menuButton: MenuButton; menu: Widget) {.
    importc: "gtk_menu_button_set_popup", libgtk.}
proc `popup=`*(menuButton: MenuButton; menu: Widget) {.
    importc: "gtk_menu_button_set_popup", libgtk.}
proc getPopup*(menuButton: MenuButton): Menu {.
    importc: "gtk_menu_button_get_popup", libgtk.}
proc popup*(menuButton: MenuButton): Menu {.
    importc: "gtk_menu_button_get_popup", libgtk.}
proc setPopover*(menuButton: MenuButton; popover: Widget) {.
    importc: "gtk_menu_button_set_popover", libgtk.}
proc `popover=`*(menuButton: MenuButton; popover: Widget) {.
    importc: "gtk_menu_button_set_popover", libgtk.}
proc getPopover*(menuButton: MenuButton): Popover {.
    importc: "gtk_menu_button_get_popover", libgtk.}
proc popover*(menuButton: MenuButton): Popover {.
    importc: "gtk_menu_button_get_popover", libgtk.}
proc setDirection*(menuButton: MenuButton;
                               direction: ArrowType) {.
    importc: "gtk_menu_button_set_direction", libgtk.}
proc `direction=`*(menuButton: MenuButton;
                               direction: ArrowType) {.
    importc: "gtk_menu_button_set_direction", libgtk.}
proc getDirection*(menuButton: MenuButton): ArrowType {.
    importc: "gtk_menu_button_get_direction", libgtk.}
proc direction*(menuButton: MenuButton): ArrowType {.
    importc: "gtk_menu_button_get_direction", libgtk.}
proc setMenuModel*(menuButton: MenuButton;
                               menuModel: gio.GMenuModel) {.
    importc: "gtk_menu_button_set_menu_model", libgtk.}
proc `menuModel=`*(menuButton: MenuButton;
                               menuModel: gio.GMenuModel) {.
    importc: "gtk_menu_button_set_menu_model", libgtk.}
proc getMenuModel*(menuButton: MenuButton): gio.GMenuModel {.
    importc: "gtk_menu_button_get_menu_model", libgtk.}
proc menuModel*(menuButton: MenuButton): gio.GMenuModel {.
    importc: "gtk_menu_button_get_menu_model", libgtk.}
proc setAlignWidget*(menuButton: MenuButton;
                                 alignWidget: Widget) {.
    importc: "gtk_menu_button_set_align_widget", libgtk.}
proc `alignWidget=`*(menuButton: MenuButton;
                                 alignWidget: Widget) {.
    importc: "gtk_menu_button_set_align_widget", libgtk.}
proc getAlignWidget*(menuButton: MenuButton): Widget {.
    importc: "gtk_menu_button_get_align_widget", libgtk.}
proc alignWidget*(menuButton: MenuButton): Widget {.
    importc: "gtk_menu_button_get_align_widget", libgtk.}
proc setUsePopover*(menuButton: MenuButton; usePopover: Gboolean) {.
    importc: "gtk_menu_button_set_use_popover", libgtk.}
proc `usePopover=`*(menuButton: MenuButton; usePopover: Gboolean) {.
    importc: "gtk_menu_button_set_use_popover", libgtk.}
proc getUsePopover*(menuButton: MenuButton): Gboolean {.
    importc: "gtk_menu_button_get_use_popover", libgtk.}
proc usePopover*(menuButton: MenuButton): Gboolean {.
    importc: "gtk_menu_button_get_use_popover", libgtk.}

template typeSizeGroup*(): expr =
  (sizeGroupGetType())

template sizeGroup*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSizeGroup, SizeGroupObj))

template sizeGroupClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeSizeGroup, SizeGroupClassObj))

template isSizeGroup*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSizeGroup))

template isSizeGroupClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeSizeGroup))

template sizeGroupGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSizeGroup, SizeGroupClassObj))

type
  ToolItem* =  ptr ToolItemObj
  ToolItemPtr* = ptr ToolItemObj
  ToolItemObj = object of BinObj
    priv93: pointer

  ToolItemClass* =  ptr ToolItemClassObj
  ToolItemClassPtr* = ptr ToolItemClassObj
  ToolItemClassObj = object of BinClassObj
    createMenuProxy*: proc (toolItem: ToolItem): Gboolean {.cdecl.}
    toolbarReconfigured*: proc (toolItem: ToolItem) {.cdecl.}
    gtkReserved871*: proc () {.cdecl.}
    gtkReserved872*: proc () {.cdecl.}
    gtkReserved873*: proc () {.cdecl.}
    gtkReserved874*: proc () {.cdecl.}

proc sizeGroupGetType*(): GType {.importc: "gtk_size_group_get_type", libgtk.}
proc newSizeGroup*(mode: SizeGroupMode): SizeGroup {.
    importc: "gtk_size_group_new", libgtk.}
proc setMode*(sizeGroup: SizeGroup; mode: SizeGroupMode) {.
    importc: "gtk_size_group_set_mode", libgtk.}
proc `mode=`*(sizeGroup: SizeGroup; mode: SizeGroupMode) {.
    importc: "gtk_size_group_set_mode", libgtk.}
proc getMode*(sizeGroup: SizeGroup): SizeGroupMode {.
    importc: "gtk_size_group_get_mode", libgtk.}
proc mode*(sizeGroup: SizeGroup): SizeGroupMode {.
    importc: "gtk_size_group_get_mode", libgtk.}
proc setIgnoreHidden*(sizeGroup: SizeGroup;
                                 ignoreHidden: Gboolean) {.
    importc: "gtk_size_group_set_ignore_hidden", libgtk.}
proc `ignoreHidden=`*(sizeGroup: SizeGroup;
                                 ignoreHidden: Gboolean) {.
    importc: "gtk_size_group_set_ignore_hidden", libgtk.}
proc getIgnoreHidden*(sizeGroup: SizeGroup): Gboolean {.
    importc: "gtk_size_group_get_ignore_hidden", libgtk.}
proc ignoreHidden*(sizeGroup: SizeGroup): Gboolean {.
    importc: "gtk_size_group_get_ignore_hidden", libgtk.}
proc addWidget*(sizeGroup: SizeGroup; widget: Widget) {.
    importc: "gtk_size_group_add_widget", libgtk.}
proc removeWidget*(sizeGroup: SizeGroup; widget: Widget) {.
    importc: "gtk_size_group_remove_widget", libgtk.}
proc getWidgets*(sizeGroup: SizeGroup): glib.GSList {.
    importc: "gtk_size_group_get_widgets", libgtk.}
proc widgets*(sizeGroup: SizeGroup): glib.GSList {.
    importc: "gtk_size_group_get_widgets", libgtk.}

template typeToolItem*(): expr =
  (toolItemGetType())

template toolItem*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeToolItem, ToolItemObj))

template toolItemClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeToolItem, ToolItemClassObj))

template isToolItem*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeToolItem))

template isToolItemClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeToolItem))

template toolItemGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeToolItem, ToolItemClassObj))

type
  ToolButton* =  ptr ToolButtonObj
  ToolButtonPtr* = ptr ToolButtonObj
  ToolButtonObj = object of ToolItemObj
    priv94: pointer

  ToolButtonClass* =  ptr ToolButtonClassObj
  ToolButtonClassPtr* = ptr ToolButtonClassObj
  ToolButtonClassObj = object of ToolItemClassObj
    buttonType*: GType
    clicked*: proc (toolItem: ToolButton) {.cdecl.}
    gtkReserved881*: proc () {.cdecl.}
    gtkReserved882*: proc () {.cdecl.}
    gtkReserved883*: proc () {.cdecl.}
    gtkReserved884*: proc () {.cdecl.}

proc toolItemGetType*(): GType {.importc: "gtk_tool_item_get_type", libgtk.}
proc newToolItem*(): ToolItem {.importc: "gtk_tool_item_new", libgtk.}
proc setHomogeneous*(toolItem: ToolItem; homogeneous: Gboolean) {.
    importc: "gtk_tool_item_set_homogeneous", libgtk.}
proc `homogeneous=`*(toolItem: ToolItem; homogeneous: Gboolean) {.
    importc: "gtk_tool_item_set_homogeneous", libgtk.}
proc getHomogeneous*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_homogeneous", libgtk.}
proc homogeneous*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_homogeneous", libgtk.}
proc setExpand*(toolItem: ToolItem; expand: Gboolean) {.
    importc: "gtk_tool_item_set_expand", libgtk.}
proc `expand=`*(toolItem: ToolItem; expand: Gboolean) {.
    importc: "gtk_tool_item_set_expand", libgtk.}
proc getExpand*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_expand", libgtk.}
proc expand*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_expand", libgtk.}
proc setTooltipText*(toolItem: ToolItem; text: cstring) {.
    importc: "gtk_tool_item_set_tooltip_text", libgtk.}
proc `tooltipText=`*(toolItem: ToolItem; text: cstring) {.
    importc: "gtk_tool_item_set_tooltip_text", libgtk.}
proc setTooltipMarkup*(toolItem: ToolItem; markup: cstring) {.
    importc: "gtk_tool_item_set_tooltip_markup", libgtk.}
proc `tooltipMarkup=`*(toolItem: ToolItem; markup: cstring) {.
    importc: "gtk_tool_item_set_tooltip_markup", libgtk.}
proc setUseDragWindow*(toolItem: ToolItem; useDragWindow: Gboolean) {.
    importc: "gtk_tool_item_set_use_drag_window", libgtk.}
proc `useDragWindow=`*(toolItem: ToolItem; useDragWindow: Gboolean) {.
    importc: "gtk_tool_item_set_use_drag_window", libgtk.}
proc getUseDragWindow*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_use_drag_window", libgtk.}
proc useDragWindow*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_use_drag_window", libgtk.}
proc setVisibleHorizontal*(toolItem: ToolItem;
                                     visibleHorizontal: Gboolean) {.
    importc: "gtk_tool_item_set_visible_horizontal", libgtk.}
proc `visibleHorizontal=`*(toolItem: ToolItem;
                                     visibleHorizontal: Gboolean) {.
    importc: "gtk_tool_item_set_visible_horizontal", libgtk.}
proc getVisibleHorizontal*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_visible_horizontal", libgtk.}
proc visibleHorizontal*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_visible_horizontal", libgtk.}
proc setVisibleVertical*(toolItem: ToolItem;
                                   visibleVertical: Gboolean) {.
    importc: "gtk_tool_item_set_visible_vertical", libgtk.}
proc `visibleVertical=`*(toolItem: ToolItem;
                                   visibleVertical: Gboolean) {.
    importc: "gtk_tool_item_set_visible_vertical", libgtk.}
proc getVisibleVertical*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_visible_vertical", libgtk.}
proc visibleVertical*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_visible_vertical", libgtk.}
proc getIsImportant*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_is_important", libgtk.}
proc isImportant*(toolItem: ToolItem): Gboolean {.
    importc: "gtk_tool_item_get_is_important", libgtk.}
proc setIsImportant*(toolItem: ToolItem; isImportant: Gboolean) {.
    importc: "gtk_tool_item_set_is_important", libgtk.}
proc `isImportant=`*(toolItem: ToolItem; isImportant: Gboolean) {.
    importc: "gtk_tool_item_set_is_important", libgtk.}
proc getEllipsizeMode*(toolItem: ToolItem): pango.EllipsizeMode {.
    importc: "gtk_tool_item_get_ellipsize_mode", libgtk.}
proc ellipsizeMode*(toolItem: ToolItem): pango.EllipsizeMode {.
    importc: "gtk_tool_item_get_ellipsize_mode", libgtk.}
proc getIconSize*(toolItem: ToolItem): IconSize {.
    importc: "gtk_tool_item_get_icon_size", libgtk.}
proc iconSize*(toolItem: ToolItem): IconSize {.
    importc: "gtk_tool_item_get_icon_size", libgtk.}
proc getOrientation*(toolItem: ToolItem): Orientation {.
    importc: "gtk_tool_item_get_orientation", libgtk.}
proc orientation*(toolItem: ToolItem): Orientation {.
    importc: "gtk_tool_item_get_orientation", libgtk.}
proc getToolbarStyle*(toolItem: ToolItem): ToolbarStyle {.
    importc: "gtk_tool_item_get_toolbar_style", libgtk.}
proc toolbarStyle*(toolItem: ToolItem): ToolbarStyle {.
    importc: "gtk_tool_item_get_toolbar_style", libgtk.}
proc getReliefStyle*(toolItem: ToolItem): ReliefStyle {.
    importc: "gtk_tool_item_get_relief_style", libgtk.}
proc reliefStyle*(toolItem: ToolItem): ReliefStyle {.
    importc: "gtk_tool_item_get_relief_style", libgtk.}
proc getTextAlignment*(toolItem: ToolItem): cfloat {.
    importc: "gtk_tool_item_get_text_alignment", libgtk.}
proc textAlignment*(toolItem: ToolItem): cfloat {.
    importc: "gtk_tool_item_get_text_alignment", libgtk.}
proc getTextOrientation*(toolItem: ToolItem): Orientation {.
    importc: "gtk_tool_item_get_text_orientation", libgtk.}
proc textOrientation*(toolItem: ToolItem): Orientation {.
    importc: "gtk_tool_item_get_text_orientation", libgtk.}
proc getTextSizeGroup*(toolItem: ToolItem): SizeGroup {.
    importc: "gtk_tool_item_get_text_size_group", libgtk.}
proc textSizeGroup*(toolItem: ToolItem): SizeGroup {.
    importc: "gtk_tool_item_get_text_size_group", libgtk.}
proc setProxyMenuItem*(toolItem: ToolItem; menuItemId: cstring;
                                 menuItem: Widget) {.
    importc: "gtk_tool_item_set_proxy_menu_item", libgtk.}
proc `proxyMenuItem=`*(toolItem: ToolItem; menuItemId: cstring;
                                 menuItem: Widget) {.
    importc: "gtk_tool_item_set_proxy_menu_item", libgtk.}
proc rebuildMenu*(toolItem: ToolItem) {.
    importc: "gtk_tool_item_rebuild_menu", libgtk.}
proc toolbarReconfigured*(toolItem: ToolItem) {.
    importc: "gtk_tool_item_toolbar_reconfigured", libgtk.}

discard """ proc "createMenuProxy*(toolItem: ToolItem): Gboolean {.
    importc: "_gtk_tool_item_create_menu_proxy", libgtk.}"""

template typeToolButton*(): expr =
  (toolButtonGetType())

template toolButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeToolButton, ToolButtonObj))

template toolButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeToolButton, ToolButtonClassObj))

template isToolButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeToolButton))

template isToolButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeToolButton))

template toolButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeToolButton, ToolButtonClassObj))

type
  MenuToolButton* =  ptr MenuToolButtonObj
  MenuToolButtonPtr* = ptr MenuToolButtonObj
  MenuToolButtonObj*{.final.} = object of ToolButtonObj
    priv95: pointer

  MenuToolButtonClass* =  ptr MenuToolButtonClassObj
  MenuToolButtonClassPtr* = ptr MenuToolButtonClassObj
  MenuToolButtonClassObj*{.final.} = object of ToolButtonClassObj
    showMenu*: proc (button: MenuToolButton) {.cdecl.}
    gtkReserved891*: proc () {.cdecl.}
    gtkReserved892*: proc () {.cdecl.}
    gtkReserved893*: proc () {.cdecl.}
    gtkReserved894*: proc () {.cdecl.}

proc toolButtonGetType*(): GType {.importc: "gtk_tool_button_get_type",
                                   libgtk.}
proc newToolButton*(iconWidget: Widget; label: cstring): ToolItem {.
    importc: "gtk_tool_button_new", libgtk.}
proc newToolButton*(stockId: cstring): ToolItem {.
    importc: "gtk_tool_button_new_from_stock", libgtk.}
proc setLabel*(button: ToolButton; label: cstring) {.
    importc: "gtk_tool_button_set_label", libgtk.}
proc `label=`*(button: ToolButton; label: cstring) {.
    importc: "gtk_tool_button_set_label", libgtk.}
proc getLabel*(button: ToolButton): cstring {.
    importc: "gtk_tool_button_get_label", libgtk.}
proc label*(button: ToolButton): cstring {.
    importc: "gtk_tool_button_get_label", libgtk.}
proc setUseUnderline*(button: ToolButton; useUnderline: Gboolean) {.
    importc: "gtk_tool_button_set_use_underline", libgtk.}
proc `useUnderline=`*(button: ToolButton; useUnderline: Gboolean) {.
    importc: "gtk_tool_button_set_use_underline", libgtk.}
proc getUseUnderline*(button: ToolButton): Gboolean {.
    importc: "gtk_tool_button_get_use_underline", libgtk.}
proc useUnderline*(button: ToolButton): Gboolean {.
    importc: "gtk_tool_button_get_use_underline", libgtk.}
proc setStockId*(button: ToolButton; stockId: cstring) {.
    importc: "gtk_tool_button_set_stock_id", libgtk.}
proc `stockId=`*(button: ToolButton; stockId: cstring) {.
    importc: "gtk_tool_button_set_stock_id", libgtk.}
proc getStockId*(button: ToolButton): cstring {.
    importc: "gtk_tool_button_get_stock_id", libgtk.}
proc stockId*(button: ToolButton): cstring {.
    importc: "gtk_tool_button_get_stock_id", libgtk.}
proc setIconName*(button: ToolButton; iconName: cstring) {.
    importc: "gtk_tool_button_set_icon_name", libgtk.}
proc `iconName=`*(button: ToolButton; iconName: cstring) {.
    importc: "gtk_tool_button_set_icon_name", libgtk.}
proc getIconName*(button: ToolButton): cstring {.
    importc: "gtk_tool_button_get_icon_name", libgtk.}
proc iconName*(button: ToolButton): cstring {.
    importc: "gtk_tool_button_get_icon_name", libgtk.}
proc setIconWidget*(button: ToolButton;
                                iconWidget: Widget) {.
    importc: "gtk_tool_button_set_icon_widget", libgtk.}
proc `iconWidget=`*(button: ToolButton;
                                iconWidget: Widget) {.
    importc: "gtk_tool_button_set_icon_widget", libgtk.}
proc getIconWidget*(button: ToolButton): Widget {.
    importc: "gtk_tool_button_get_icon_widget", libgtk.}
proc iconWidget*(button: ToolButton): Widget {.
    importc: "gtk_tool_button_get_icon_widget", libgtk.}
proc setLabelWidget*(button: ToolButton;
                                 labelWidget: Widget) {.
    importc: "gtk_tool_button_set_label_widget", libgtk.}
proc `labelWidget=`*(button: ToolButton;
                                 labelWidget: Widget) {.
    importc: "gtk_tool_button_set_label_widget", libgtk.}

discard """ proc "getButton*(button: ToolButton): Widget {.
    importc: "_gtk_tool_button_get_button", libgtk.}"""

template typeMenuToolButton*(): expr =
  (menuToolButtonGetType())

template menuToolButton*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeMenuToolButton, MenuToolButtonObj))

template menuToolButtonClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeMenuToolButton, MenuToolButtonClassObj))

template isMenuToolButton*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeMenuToolButton))

template isMenuToolButtonClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeMenuToolButton))

template menuToolButtonGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeMenuToolButton, MenuToolButtonClassObj))

type
  MessageDialog* =  ptr MessageDialogObj
  MessageDialogPtr* = ptr MessageDialogObj
  MessageDialogObj*{.final.} = object of DialogObj
    priv96: pointer

  MessageDialogClass* =  ptr MessageDialogClassObj
  MessageDialogClassPtr* = ptr MessageDialogClassObj
  MessageDialogClassObj*{.final.} = object of DialogClassObj
    gtkReserved901*: proc () {.cdecl.}
    gtkReserved902*: proc () {.cdecl.}
    gtkReserved903*: proc () {.cdecl.}
    gtkReserved904*: proc () {.cdecl.}

proc menuToolButtonGetType*(): GType {.importc: "gtk_menu_tool_button_get_type",
                                       libgtk.}
proc newMenuToolButton*(iconWidget: Widget; label: cstring): ToolItem {.
    importc: "gtk_menu_tool_button_new", libgtk.}
proc newMenuToolButton*(stockId: cstring): ToolItem {.
    importc: "gtk_menu_tool_button_new_from_stock", libgtk.}
proc setMenu*(button: MenuToolButton; menu: Widget) {.
    importc: "gtk_menu_tool_button_set_menu", libgtk.}
proc `menu=`*(button: MenuToolButton; menu: Widget) {.
    importc: "gtk_menu_tool_button_set_menu", libgtk.}
proc setArrowTooltipText*(button: MenuToolButton;
    text: cstring) {.importc: "gtk_menu_tool_button_set_arrow_tooltip_text",
                   libgtk.}
proc `arrowTooltipText=`*(button: MenuToolButton;
    text: cstring) {.importc: "gtk_menu_tool_button_set_arrow_tooltip_text",
                   libgtk.}
proc setArrowTooltipMarkup*(button: MenuToolButton;
    markup: cstring) {.importc: "gtk_menu_tool_button_set_arrow_tooltip_markup",
                     libgtk.}
proc `arrowTooltipMarkup=`*(button: MenuToolButton;
    markup: cstring) {.importc: "gtk_menu_tool_button_set_arrow_tooltip_markup",
                     libgtk.}

template typeMessageDialog*(): expr =
  (messageDialogGetType())

template messageDialog*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeMessageDialog, MessageDialogObj))

template messageDialogClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeMessageDialog, MessageDialogClassObj))

template isMessageDialog*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeMessageDialog))

template isMessageDialogClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeMessageDialog))

template messageDialogGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeMessageDialog, MessageDialogClassObj))

type
  ButtonsType* {.size: sizeof(cint), pure.} = enum
    NONE, OK, CLOSE, CANCEL,
    YES_NO, OK_CANCEL
  ModelButton* =  ptr ModelButtonObj
  ModelButtonPtr* = ptr ModelButtonObj
  ModelButtonObj* = object

proc messageDialogGetType*(): GType {.importc: "gtk_message_dialog_get_type",
                                      libgtk.}
proc setImage*(dialog: MessageDialog; image: Widget) {.
    importc: "gtk_message_dialog_set_image", libgtk.}
proc `image=`*(dialog: MessageDialog; image: Widget) {.
    importc: "gtk_message_dialog_set_image", libgtk.}
proc setMarkup*(messageDialog: MessageDialog; str: cstring) {.
    importc: "gtk_message_dialog_set_markup", libgtk.}
proc `markup=`*(messageDialog: MessageDialog; str: cstring) {.
    importc: "gtk_message_dialog_set_markup", libgtk.}
proc formatSecondaryText*(messageDialog: MessageDialog;
    messageFormat: cstring) {.varargs, importc: "gtk_message_dialog_format_secondary_text",
                            libgtk.}
proc formatSecondaryMarkup*(messageDialog: MessageDialog;
    messageFormat: cstring) {.varargs, importc: "gtk_message_dialog_format_secondary_markup",
                            libgtk.}
proc getMessageArea*(messageDialog: MessageDialog): Widget {.
    importc: "gtk_message_dialog_get_message_area", libgtk.}
proc messageArea*(messageDialog: MessageDialog): Widget {.
    importc: "gtk_message_dialog_get_message_area", libgtk.}

template typeModelButton*(): expr =
  (modelButtonGetType())

template modelButton*(inst: expr): expr =
  (gTypeCheckInstanceCast(inst, typeModelButton, ModelButtonObj))

template isModelButton*(inst: expr): expr =
  (gTypeCheckInstanceType(inst, typeModelButton))

type
  ButtonRole* {.size: sizeof(cint), pure.} = enum
    NORMAL, CHECK, RADIO

type
  MountOperation* =  ptr MountOperationObj
  MountOperationPtr* = ptr MountOperationObj
  MountOperationObj*{.final.} = object of gio.GMountOperationObj
    priv97: pointer

  MountOperationClass* =  ptr MountOperationClassObj
  MountOperationClassPtr* = ptr MountOperationClassObj
  MountOperationClassObj*{.final.} = object of gio.GMountOperationClassObj
    gtkReserved911*: proc () {.cdecl.}
    gtkReserved912*: proc () {.cdecl.}
    gtkReserved913*: proc () {.cdecl.}
    gtkReserved914*: proc () {.cdecl.}

proc modelButtonGetType*(): GType {.importc: "gtk_model_button_get_type",
                                    libgtk.}
proc newModelButton*(): ModelButton {.importc: "gtk_model_button_new",
                                       libgtk.}

type
  ModuleInitFunc* = proc (argc: var cint; argv: var cstringArray) {.cdecl.}

type
  ModuleDisplayInitFunc* = proc (display: gdk3.Display) {.cdecl.}

template typeMountOperation*(): expr =
  (mountOperationGetType())

template mountOperation*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeMountOperation, MountOperationObj))

template mountOperationClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeMountOperation, MountOperationClassObj))

template isMountOperation*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeMountOperation))

template isMountOperationClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeMountOperation))

template mountOperationGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeMountOperation, MountOperationClassObj))

type
  NotebookTab* {.size: sizeof(cint), pure.} = enum
    FIRST, LAST
type
  Notebook* =  ptr NotebookObj
  NotebookPtr* = ptr NotebookObj
  NotebookObj*{.final.} = object of ContainerObj
    priv98: pointer

  NotebookClass* =  ptr NotebookClassObj
  NotebookClassPtr* = ptr NotebookClassObj
  NotebookClassObj*{.final.} = object of ContainerClassObj
    switchPage*: proc (notebook: Notebook; page: Widget; pageNum: cuint) {.cdecl.}
    selectPage*: proc (notebook: Notebook; moveFocus: Gboolean): Gboolean {.cdecl.}
    focusTab*: proc (notebook: Notebook; `type`: NotebookTab): Gboolean {.cdecl.}
    changeCurrentPage*: proc (notebook: Notebook; offset: cint): Gboolean {.cdecl.}
    moveFocusOut*: proc (notebook: Notebook; direction: DirectionType) {.cdecl.}
    reorderTab*: proc (notebook: Notebook; direction: DirectionType;
                     moveToLast: Gboolean): Gboolean {.cdecl.}
    insertPage*: proc (notebook: Notebook; child: Widget;
                     tabLabel: Widget; menuLabel: Widget; position: cint): cint {.cdecl.}
    createWindow*: proc (notebook: Notebook; page: Widget; x: cint; y: cint): Notebook {.cdecl.}
    pageReordered*: proc (notebook: Notebook; child: Widget;
                        pageNum: cuint) {.cdecl.}
    pageRemoved*: proc (notebook: Notebook; child: Widget; pageNum: cuint) {.cdecl.}
    pageAdded*: proc (notebook: Notebook; child: Widget; pageNum: cuint) {.cdecl.}
    gtkReserved921*: proc () {.cdecl.}
    gtkReserved922*: proc () {.cdecl.}
    gtkReserved923*: proc () {.cdecl.}
    gtkReserved924*: proc () {.cdecl.}
    gtkReserved925*: proc () {.cdecl.}
    gtkReserved926*: proc () {.cdecl.}
    gtkReserved927*: proc () {.cdecl.}
    gtkReserved928*: proc () {.cdecl.}

proc mountOperationGetType*(): GType {.importc: "gtk_mount_operation_get_type",
                                       libgtk.}
proc newMountOperation*(parent: Window): gio.GMountOperation {.
    importc: "gtk_mount_operation_new", libgtk.}
proc isShowing*(op: MountOperation): Gboolean {.
    importc: "gtk_mount_operation_is_showing", libgtk.}
proc setParent*(op: MountOperation; parent: Window) {.
    importc: "gtk_mount_operation_set_parent", libgtk.}
proc `parent=`*(op: MountOperation; parent: Window) {.
    importc: "gtk_mount_operation_set_parent", libgtk.}
proc getParent*(op: MountOperation): Window {.
    importc: "gtk_mount_operation_get_parent", libgtk.}
proc parent*(op: MountOperation): Window {.
    importc: "gtk_mount_operation_get_parent", libgtk.}
proc setScreen*(op: MountOperation; screen: gdk3.Screen) {.
    importc: "gtk_mount_operation_set_screen", libgtk.}
proc `screen=`*(op: MountOperation; screen: gdk3.Screen) {.
    importc: "gtk_mount_operation_set_screen", libgtk.}
proc getScreen*(op: MountOperation): gdk3.Screen {.
    importc: "gtk_mount_operation_get_screen", libgtk.}
proc screen*(op: MountOperation): gdk3.Screen {.
    importc: "gtk_mount_operation_get_screen", libgtk.}

template typeNotebook*(): expr =
  (notebookGetType())

template notebook*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeNotebook, NotebookObj))

template notebookClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeNotebook, NotebookClassObj))

template isNotebook*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeNotebook))

template isNotebookClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeNotebook))

template notebookGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeNotebook, NotebookClassObj))

type
  OffscreenWindow* =  ptr OffscreenWindowObj
  OffscreenWindowPtr* = ptr OffscreenWindowObj
  OffscreenWindowObj*{.final.} = object of WindowObj

  OffscreenWindowClass* =  ptr OffscreenWindowClassObj
  OffscreenWindowClassPtr* = ptr OffscreenWindowClassObj
  OffscreenWindowClassObj*{.final.} = object of WindowClassObj
    gtkReserved931*: proc () {.cdecl.}
    gtkReserved932*: proc () {.cdecl.}
    gtkReserved933*: proc () {.cdecl.}
    gtkReserved934*: proc () {.cdecl.}

proc notebookGetType*(): GType {.importc: "gtk_notebook_get_type", libgtk.}
proc newNotebook*(): Notebook {.importc: "gtk_notebook_new", libgtk.}
proc appendPage*(notebook: Notebook; child: Widget;
                           tabLabel: Widget): cint {.
    importc: "gtk_notebook_append_page", libgtk.}
proc appendPageMenu*(notebook: Notebook; child: Widget;
                               tabLabel: Widget; menuLabel: Widget): cint {.
    importc: "gtk_notebook_append_page_menu", libgtk.}
proc prependPage*(notebook: Notebook; child: Widget;
                            tabLabel: Widget): cint {.
    importc: "gtk_notebook_prepend_page", libgtk.}
proc prependPageMenu*(notebook: Notebook; child: Widget;
                                tabLabel: Widget; menuLabel: Widget): cint {.
    importc: "gtk_notebook_prepend_page_menu", libgtk.}
proc insertPage*(notebook: Notebook; child: Widget;
                           tabLabel: Widget; position: cint): cint {.
    importc: "gtk_notebook_insert_page", libgtk.}
proc insertPageMenu*(notebook: Notebook; child: Widget;
                               tabLabel: Widget; menuLabel: Widget;
                               position: cint): cint {.
    importc: "gtk_notebook_insert_page_menu", libgtk.}
proc removePage*(notebook: Notebook; pageNum: cint) {.
    importc: "gtk_notebook_remove_page", libgtk.}

proc setGroupName*(notebook: Notebook; groupName: cstring) {.
    importc: "gtk_notebook_set_group_name", libgtk.}

proc `groupName=`*(notebook: Notebook; groupName: cstring) {.
    importc: "gtk_notebook_set_group_name", libgtk.}
proc getGroupName*(notebook: Notebook): cstring {.
    importc: "gtk_notebook_get_group_name", libgtk.}
proc groupName*(notebook: Notebook): cstring {.
    importc: "gtk_notebook_get_group_name", libgtk.}

proc getCurrentPage*(notebook: Notebook): cint {.
    importc: "gtk_notebook_get_current_page", libgtk.}

proc currentPage*(notebook: Notebook): cint {.
    importc: "gtk_notebook_get_current_page", libgtk.}
proc getNthPage*(notebook: Notebook; pageNum: cint): Widget {.
    importc: "gtk_notebook_get_nth_page", libgtk.}
proc nthPage*(notebook: Notebook; pageNum: cint): Widget {.
    importc: "gtk_notebook_get_nth_page", libgtk.}
proc getNPages*(notebook: Notebook): cint {.
    importc: "gtk_notebook_get_n_pages", libgtk.}
proc nPages*(notebook: Notebook): cint {.
    importc: "gtk_notebook_get_n_pages", libgtk.}
proc pageNum*(notebook: Notebook; child: Widget): cint {.
    importc: "gtk_notebook_page_num", libgtk.}
proc setCurrentPage*(notebook: Notebook; pageNum: cint) {.
    importc: "gtk_notebook_set_current_page", libgtk.}
proc `currentPage=`*(notebook: Notebook; pageNum: cint) {.
    importc: "gtk_notebook_set_current_page", libgtk.}
proc nextPage*(notebook: Notebook) {.
    importc: "gtk_notebook_next_page", libgtk.}
proc prevPage*(notebook: Notebook) {.
    importc: "gtk_notebook_prev_page", libgtk.}

proc setShowBorder*(notebook: Notebook; showBorder: Gboolean) {.
    importc: "gtk_notebook_set_show_border", libgtk.}

proc `showBorder=`*(notebook: Notebook; showBorder: Gboolean) {.
    importc: "gtk_notebook_set_show_border", libgtk.}
proc getShowBorder*(notebook: Notebook): Gboolean {.
    importc: "gtk_notebook_get_show_border", libgtk.}
proc showBorder*(notebook: Notebook): Gboolean {.
    importc: "gtk_notebook_get_show_border", libgtk.}
proc setShowTabs*(notebook: Notebook; showTabs: Gboolean) {.
    importc: "gtk_notebook_set_show_tabs", libgtk.}
proc `showTabs=`*(notebook: Notebook; showTabs: Gboolean) {.
    importc: "gtk_notebook_set_show_tabs", libgtk.}
proc getShowTabs*(notebook: Notebook): Gboolean {.
    importc: "gtk_notebook_get_show_tabs", libgtk.}
proc showTabs*(notebook: Notebook): Gboolean {.
    importc: "gtk_notebook_get_show_tabs", libgtk.}
proc setTabPos*(notebook: Notebook; pos: PositionType) {.
    importc: "gtk_notebook_set_tab_pos", libgtk.}
proc `tabPos=`*(notebook: Notebook; pos: PositionType) {.
    importc: "gtk_notebook_set_tab_pos", libgtk.}
proc getTabPos*(notebook: Notebook): PositionType {.
    importc: "gtk_notebook_get_tab_pos", libgtk.}
proc tabPos*(notebook: Notebook): PositionType {.
    importc: "gtk_notebook_get_tab_pos", libgtk.}
proc setScrollable*(notebook: Notebook; scrollable: Gboolean) {.
    importc: "gtk_notebook_set_scrollable", libgtk.}
proc `scrollable=`*(notebook: Notebook; scrollable: Gboolean) {.
    importc: "gtk_notebook_set_scrollable", libgtk.}
proc getScrollable*(notebook: Notebook): Gboolean {.
    importc: "gtk_notebook_get_scrollable", libgtk.}
proc scrollable*(notebook: Notebook): Gboolean {.
    importc: "gtk_notebook_get_scrollable", libgtk.}
proc getTabHborder*(notebook: Notebook): uint16 {.
    importc: "gtk_notebook_get_tab_hborder", libgtk.}
proc tabHborder*(notebook: Notebook): uint16 {.
    importc: "gtk_notebook_get_tab_hborder", libgtk.}
proc getTabVborder*(notebook: Notebook): uint16 {.
    importc: "gtk_notebook_get_tab_vborder", libgtk.}
proc tabVborder*(notebook: Notebook): uint16 {.
    importc: "gtk_notebook_get_tab_vborder", libgtk.}

proc popupEnable*(notebook: Notebook) {.
    importc: "gtk_notebook_popup_enable", libgtk.}
proc popupDisable*(notebook: Notebook) {.
    importc: "gtk_notebook_popup_disable", libgtk.}

proc getTabLabel*(notebook: Notebook; child: Widget): Widget {.
    importc: "gtk_notebook_get_tab_label", libgtk.}

proc tabLabel*(notebook: Notebook; child: Widget): Widget {.
    importc: "gtk_notebook_get_tab_label", libgtk.}
proc setTabLabel*(notebook: Notebook; child: Widget;
                            tabLabel: Widget) {.
    importc: "gtk_notebook_set_tab_label", libgtk.}
proc `tabLabel=`*(notebook: Notebook; child: Widget;
                            tabLabel: Widget) {.
    importc: "gtk_notebook_set_tab_label", libgtk.}
proc setTabLabelText*(notebook: Notebook; child: Widget;
                                tabText: cstring) {.
    importc: "gtk_notebook_set_tab_label_text", libgtk.}
proc `tabLabelText=`*(notebook: Notebook; child: Widget;
                                tabText: cstring) {.
    importc: "gtk_notebook_set_tab_label_text", libgtk.}
proc getTabLabelText*(notebook: Notebook; child: Widget): cstring {.
    importc: "gtk_notebook_get_tab_label_text", libgtk.}
proc tabLabelText*(notebook: Notebook; child: Widget): cstring {.
    importc: "gtk_notebook_get_tab_label_text", libgtk.}
proc getMenuLabel*(notebook: Notebook; child: Widget): Widget {.
    importc: "gtk_notebook_get_menu_label", libgtk.}
proc menuLabel*(notebook: Notebook; child: Widget): Widget {.
    importc: "gtk_notebook_get_menu_label", libgtk.}
proc setMenuLabel*(notebook: Notebook; child: Widget;
                             menuLabel: Widget) {.
    importc: "gtk_notebook_set_menu_label", libgtk.}
proc `menuLabel=`*(notebook: Notebook; child: Widget;
                             menuLabel: Widget) {.
    importc: "gtk_notebook_set_menu_label", libgtk.}
proc setMenuLabelText*(notebook: Notebook; child: Widget;
                                 menuText: cstring) {.
    importc: "gtk_notebook_set_menu_label_text", libgtk.}
proc `menuLabelText=`*(notebook: Notebook; child: Widget;
                                 menuText: cstring) {.
    importc: "gtk_notebook_set_menu_label_text", libgtk.}
proc getMenuLabelText*(notebook: Notebook; child: Widget): cstring {.
    importc: "gtk_notebook_get_menu_label_text", libgtk.}
proc menuLabelText*(notebook: Notebook; child: Widget): cstring {.
    importc: "gtk_notebook_get_menu_label_text", libgtk.}
proc reorderChild*(notebook: Notebook; child: Widget;
                             position: cint) {.
    importc: "gtk_notebook_reorder_child", libgtk.}
proc getTabReorderable*(notebook: Notebook; child: Widget): Gboolean {.
    importc: "gtk_notebook_get_tab_reorderable", libgtk.}
proc tabReorderable*(notebook: Notebook; child: Widget): Gboolean {.
    importc: "gtk_notebook_get_tab_reorderable", libgtk.}
proc setTabReorderable*(notebook: Notebook; child: Widget;
                                  reorderable: Gboolean) {.
    importc: "gtk_notebook_set_tab_reorderable", libgtk.}
proc `tabReorderable=`*(notebook: Notebook; child: Widget;
                                  reorderable: Gboolean) {.
    importc: "gtk_notebook_set_tab_reorderable", libgtk.}
proc getTabDetachable*(notebook: Notebook; child: Widget): Gboolean {.
    importc: "gtk_notebook_get_tab_detachable", libgtk.}
proc tabDetachable*(notebook: Notebook; child: Widget): Gboolean {.
    importc: "gtk_notebook_get_tab_detachable", libgtk.}
proc setTabDetachable*(notebook: Notebook; child: Widget;
                                 detachable: Gboolean) {.
    importc: "gtk_notebook_set_tab_detachable", libgtk.}
proc `tabDetachable=`*(notebook: Notebook; child: Widget;
                                 detachable: Gboolean) {.
    importc: "gtk_notebook_set_tab_detachable", libgtk.}
proc detachTab*(notebook: Notebook; child: Widget) {.
    importc: "gtk_notebook_detach_tab", libgtk.}
proc getActionWidget*(notebook: Notebook; packType: PackType): Widget {.
    importc: "gtk_notebook_get_action_widget", libgtk.}
proc actionWidget*(notebook: Notebook; packType: PackType): Widget {.
    importc: "gtk_notebook_get_action_widget", libgtk.}
proc setActionWidget*(notebook: Notebook; widget: Widget;
                                packType: PackType) {.
    importc: "gtk_notebook_set_action_widget", libgtk.}
proc `actionWidget=`*(notebook: Notebook; widget: Widget;
                                packType: PackType) {.
    importc: "gtk_notebook_set_action_widget", libgtk.}

template typeOffscreenWindow*(): expr =
  (offscreenWindowGetType())

template offscreenWindow*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typeOffscreenWindow, OffscreenWindowObj))

template offscreenWindowClass*(k: expr): expr =
  (gTypeCheckClassCast(k, typeOffscreenWindow, OffscreenWindowClassObj))

template isOffscreenWindow*(o: expr): expr =
  (gTypeCheckInstanceType(o, typeOffscreenWindow))

template isOffscreenWindowClass*(k: expr): expr =
  (gTypeCheckClassType(k, typeOffscreenWindow))

template offscreenWindowGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typeOffscreenWindow, OffscreenWindowClassObj))

type
  OrientableIface* =  ptr OrientableIfaceObj
  OrientableIfacePtr* = ptr OrientableIfaceObj
  OrientableIfaceObj* = object of gobject.GTypeInterfaceObj

  Orientable* =  ptr OrientableObj
  OrientablePtr* = ptr OrientableObj
  OrientableObj* = object

proc offscreenWindowGetType*(): GType {.importc: "gtk_offscreen_window_get_type",
                                        libgtk.}
proc newOffscreenWindow*(): OffscreenWindow {.importc: "gtk_offscreen_window_new",
    libgtk.}
proc getSurface*(offscreen: OffscreenWindow): cairo.Surface {.
    importc: "gtk_offscreen_window_get_surface", libgtk.}
proc surface*(offscreen: OffscreenWindow): cairo.Surface {.
    importc: "gtk_offscreen_window_get_surface", libgtk.}
proc getPixbuf*(offscreen: OffscreenWindow): GdkPixbuf {.
    importc: "gtk_offscreen_window_get_pixbuf", libgtk.}
proc pixbuf*(offscreen: OffscreenWindow): GdkPixbuf {.
    importc: "gtk_offscreen_window_get_pixbuf", libgtk.}

template typeOrientable*(): expr =
  (orientableGetType())

template orientable*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeOrientable, OrientableObj))

template orientableClass*(vtable: expr): expr =
  (gTypeCheckClassCast(vtable, typeOrientable, OrientableIfaceObj))

template isOrientable*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeOrientable))

template isOrientableClass*(vtable: expr): expr =
  (gTypeCheckClassType(vtable, typeOrientable))

template orientableGetIface*(inst: expr): expr =
  (gTypeInstanceGetInterface(inst, typeOrientable, OrientableIfaceObj))

type
  Overlay* =  ptr OverlayObj
  OverlayPtr* = ptr OverlayObj
  OverlayObj*{.final.} = object of BinObj
    priv99: pointer

  OverlayClass* =  ptr OverlayClassObj
  OverlayClassPtr* = ptr OverlayClassObj
  OverlayClassObj*{.final.} = object of BinClassObj
    getChildPosition*: proc (overlay: Overlay; widget: Widget;
                           allocation: Allocation): Gboolean {.cdecl.}
    gtkReserved941*: proc () {.cdecl.}
    gtkReserved942*: proc () {.cdecl.}
    gtkReserved943*: proc () {.cdecl.}
    gtkReserved944*: proc () {.cdecl.}
    gtkReserved945*: proc () {.cdecl.}
    gtkReserved946*: proc () {.cdecl.}
    gtkReserved947*: proc () {.cdecl.}
    gtkReserved948*: proc () {.cdecl.}

proc orientableGetType*(): GType {.importc: "gtk_orientable_get_type", libgtk.}
proc setOrientation*(orientable: Orientable;
                                 orientation: Orientation) {.
    importc: "gtk_orientable_set_orientation", libgtk.}
proc `orientation=`*(orientable: Orientable;
                                 orientation: Orientation) {.
    importc: "gtk_orientable_set_orientation", libgtk.}
proc getOrientation*(orientable: Orientable): Orientation {.
    importc: "gtk_orientable_get_orientation", libgtk.}
proc orientation*(orientable: Orientable): Orientation {.
    importc: "gtk_orientable_get_orientation", libgtk.}

template typeOverlay*(): expr =
  (overlayGetType())

template overlay*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeOverlay, OverlayObj))

template overlayClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeOverlay, OverlayClassObj))

template isOverlay*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeOverlay))

template isOverlayClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeOverlay))

template overlayGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeOverlay, OverlayClassObj))

type
  Paned* =  ptr PanedObj
  PanedPtr* = ptr PanedObj
  PanedObj* = object of ContainerObj
    priv100: pointer

  PanedClass* =  ptr PanedClassObj
  PanedClassPtr* = ptr PanedClassObj
  PanedClassObj = object of ContainerClassObj
    cycleChildFocus*: proc (paned: Paned; reverse: Gboolean): Gboolean {.cdecl.}
    toggleHandleFocus*: proc (paned: Paned): Gboolean {.cdecl.}
    moveHandle*: proc (paned: Paned; scroll: ScrollType): Gboolean {.cdecl.}
    cycleHandleFocus*: proc (paned: Paned; reverse: Gboolean): Gboolean {.cdecl.}
    acceptPosition*: proc (paned: Paned): Gboolean {.cdecl.}
    cancelPosition*: proc (paned: Paned): Gboolean {.cdecl.}
    gtkReserved951*: proc () {.cdecl.}
    gtkReserved952*: proc () {.cdecl.}
    gtkReserved953*: proc () {.cdecl.}
    gtkReserved954*: proc () {.cdecl.}

proc overlayGetType*(): GType {.importc: "gtk_overlay_get_type", libgtk.}
proc newOverlay*(): Overlay {.importc: "gtk_overlay_new", libgtk.}
proc addOverlay*(overlay: Overlay; widget: Widget) {.
    importc: "gtk_overlay_add_overlay", libgtk.}
proc reorderOverlay*(overlay: Overlay; child: Widget;
                              position: cint) {.
    importc: "gtk_overlay_reorder_overlay", libgtk.}
proc getOverlayPassThrough*(overlay: Overlay; widget: Widget): Gboolean {.
    importc: "gtk_overlay_get_overlay_pass_through", libgtk.}
proc overlayPassThrough*(overlay: Overlay; widget: Widget): Gboolean {.
    importc: "gtk_overlay_get_overlay_pass_through", libgtk.}
proc setOverlayPassThrough*(overlay: Overlay;
                                     widget: Widget; passThrough: Gboolean) {.
    importc: "gtk_overlay_set_overlay_pass_through", libgtk.}
proc `overlayPassThrough=`*(overlay: Overlay;
                                     widget: Widget; passThrough: Gboolean) {.
    importc: "gtk_overlay_set_overlay_pass_through", libgtk.}

type
  PaperSize* =  ptr PaperSizeObj
  PaperSizePtr* = ptr PaperSizeObj
  PaperSizeObj* = object

template typePaperSize*(): expr =
  (paperSizeGetType())

const
  PAPER_NAME_A3* = "iso_a3"

const
  PAPER_NAME_A4* = "iso_a4"

const
  PAPER_NAME_A5* = "iso_a5"

const
  PAPER_NAME_B5* = "iso_b5"

const
  PAPER_NAME_LETTER* = "na_letter"

const
  PAPER_NAME_EXECUTIVE* = "na_executive"

const
  PAPER_NAME_LEGAL* = "na_legal"

proc paperSizeGetType*(): GType {.importc: "gtk_paper_size_get_type", libgtk.}
proc newPaperSize*(name: cstring): PaperSize {.
    importc: "gtk_paper_size_new", libgtk.}
proc newPaperSize*(ppdName: cstring; ppdDisplayName: cstring;
                            width: cdouble; height: cdouble): PaperSize {.
    importc: "gtk_paper_size_new_from_ppd", libgtk.}
proc newPaperSize*(ippName: cstring; width: cdouble; height: cdouble): PaperSize {.
    importc: "gtk_paper_size_new_from_ipp", libgtk.}
proc newPaperSize*(name: cstring; displayName: cstring; width: cdouble;
                           height: cdouble; unit: Unit): PaperSize {.
    importc: "gtk_paper_size_new_custom", libgtk.}
proc copy*(other: PaperSize): PaperSize {.
    importc: "gtk_paper_size_copy", libgtk.}
proc free*(size: PaperSize) {.importc: "gtk_paper_size_free",
    libgtk.}
proc isEqual*(size1: PaperSize; size2: PaperSize): Gboolean {.
    importc: "gtk_paper_size_is_equal", libgtk.}
proc paperSizeGetPaperSizes*(includeCustom: Gboolean): glib.GList {.
    importc: "gtk_paper_size_get_paper_sizes", libgtk.}

proc getName*(size: PaperSize): cstring {.
    importc: "gtk_paper_size_get_name", libgtk.}

proc name*(size: PaperSize): cstring {.
    importc: "gtk_paper_size_get_name", libgtk.}
proc getDisplayName*(size: PaperSize): cstring {.
    importc: "gtk_paper_size_get_display_name", libgtk.}
proc displayName*(size: PaperSize): cstring {.
    importc: "gtk_paper_size_get_display_name", libgtk.}
proc getPpdName*(size: PaperSize): cstring {.
    importc: "gtk_paper_size_get_ppd_name", libgtk.}
proc ppdName*(size: PaperSize): cstring {.
    importc: "gtk_paper_size_get_ppd_name", libgtk.}
proc getWidth*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_width", libgtk.}
proc width*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_width", libgtk.}
proc getHeight*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_height", libgtk.}
proc height*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_height", libgtk.}
proc isCustom*(size: PaperSize): Gboolean {.
    importc: "gtk_paper_size_is_custom", libgtk.}
proc isIpp*(size: PaperSize): Gboolean {.
    importc: "gtk_paper_size_is_ipp", libgtk.}

proc setSize*(size: PaperSize; width: cdouble; height: cdouble;
                         unit: Unit) {.importc: "gtk_paper_size_set_size",
                                        libgtk.}

proc `size=`*(size: PaperSize; width: cdouble; height: cdouble;
                         unit: Unit) {.importc: "gtk_paper_size_set_size",
                                        libgtk.}
proc getDefaultTopMargin*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_default_top_margin", libgtk.}
proc defaultTopMargin*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_default_top_margin", libgtk.}
proc getDefaultBottomMargin*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_default_bottom_margin", libgtk.}
proc defaultBottomMargin*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_default_bottom_margin", libgtk.}
proc getDefaultLeftMargin*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_default_left_margin", libgtk.}
proc defaultLeftMargin*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_default_left_margin", libgtk.}
proc getDefaultRightMargin*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_default_right_margin", libgtk.}
proc defaultRightMargin*(size: PaperSize; unit: Unit): cdouble {.
    importc: "gtk_paper_size_get_default_right_margin", libgtk.}
proc paperSizeGetDefault*(): cstring {.importc: "gtk_paper_size_get_default",
                                       libgtk.}
proc newPaperSize*(keyFile: glib.GKeyFile; groupName: cstring;
                                error: var glib.GError): PaperSize {.
    importc: "gtk_paper_size_new_from_key_file", libgtk.}
proc toKeyFile*(size: PaperSize; keyFile: glib.GKeyFile;
                           groupName: cstring) {.
    importc: "gtk_paper_size_to_key_file", libgtk.}

type
  PageSetup* =  ptr PageSetupObj
  PageSetupPtr* = ptr PageSetupObj
  PageSetupObj* = object

template typePageSetup*(): expr =
  (pageSetupGetType())

template pageSetup*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typePageSetup, PageSetupObj))

template isPageSetup*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typePageSetup))

proc pageSetupGetType*(): GType {.importc: "gtk_page_setup_get_type", libgtk.}
proc newPageSetup*(): PageSetup {.importc: "gtk_page_setup_new", libgtk.}
proc copy*(other: PageSetup): PageSetup {.
    importc: "gtk_page_setup_copy", libgtk.}
proc getOrientation*(setup: PageSetup): PageOrientation {.
    importc: "gtk_page_setup_get_orientation", libgtk.}
proc orientation*(setup: PageSetup): PageOrientation {.
    importc: "gtk_page_setup_get_orientation", libgtk.}
proc setOrientation*(setup: PageSetup;
                                orientation: PageOrientation) {.
    importc: "gtk_page_setup_set_orientation", libgtk.}
proc `orientation=`*(setup: PageSetup;
                                orientation: PageOrientation) {.
    importc: "gtk_page_setup_set_orientation", libgtk.}
proc getPaperSize*(setup: PageSetup): PaperSize {.
    importc: "gtk_page_setup_get_paper_size", libgtk.}
proc paperSize*(setup: PageSetup): PaperSize {.
    importc: "gtk_page_setup_get_paper_size", libgtk.}
proc setPaperSize*(setup: PageSetup; size: PaperSize) {.
    importc: "gtk_page_setup_set_paper_size", libgtk.}
proc `paperSize=`*(setup: PageSetup; size: PaperSize) {.
    importc: "gtk_page_setup_set_paper_size", libgtk.}
proc getTopMargin*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_top_margin", libgtk.}
proc topMargin*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_top_margin", libgtk.}
proc setTopMargin*(setup: PageSetup; margin: cdouble; unit: Unit) {.
    importc: "gtk_page_setup_set_top_margin", libgtk.}
proc `topMargin=`*(setup: PageSetup; margin: cdouble; unit: Unit) {.
    importc: "gtk_page_setup_set_top_margin", libgtk.}
proc getBottomMargin*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_bottom_margin", libgtk.}
proc bottomMargin*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_bottom_margin", libgtk.}
proc setBottomMargin*(setup: PageSetup; margin: cdouble;
                                 unit: Unit) {.
    importc: "gtk_page_setup_set_bottom_margin", libgtk.}
proc `bottomMargin=`*(setup: PageSetup; margin: cdouble;
                                 unit: Unit) {.
    importc: "gtk_page_setup_set_bottom_margin", libgtk.}
proc getLeftMargin*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_left_margin", libgtk.}
proc leftMargin*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_left_margin", libgtk.}
proc setLeftMargin*(setup: PageSetup; margin: cdouble;
                               unit: Unit) {.
    importc: "gtk_page_setup_set_left_margin", libgtk.}
proc `leftMargin=`*(setup: PageSetup; margin: cdouble;
                               unit: Unit) {.
    importc: "gtk_page_setup_set_left_margin", libgtk.}
proc getRightMargin*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_right_margin", libgtk.}
proc rightMargin*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_right_margin", libgtk.}
proc setRightMargin*(setup: PageSetup; margin: cdouble;
                                unit: Unit) {.
    importc: "gtk_page_setup_set_right_margin", libgtk.}
proc `rightMargin=`*(setup: PageSetup; margin: cdouble;
                                unit: Unit) {.
    importc: "gtk_page_setup_set_right_margin", libgtk.}
proc setPaperSizeAndDefaultMargins*(setup: PageSetup;
    size: PaperSize) {.importc: "gtk_page_setup_set_paper_size_and_default_margins",
                           libgtk.}
proc `paperSizeAndDefaultMargins=`*(setup: PageSetup;
    size: PaperSize) {.importc: "gtk_page_setup_set_paper_size_and_default_margins",
                           libgtk.}

proc getPaperWidth*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_paper_width", libgtk.}

proc paperWidth*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_paper_width", libgtk.}
proc getPaperHeight*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_paper_height", libgtk.}
proc paperHeight*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_paper_height", libgtk.}

proc getPageWidth*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_page_width", libgtk.}

proc pageWidth*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_page_width", libgtk.}
proc getPageHeight*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_page_height", libgtk.}
proc pageHeight*(setup: PageSetup; unit: Unit): cdouble {.
    importc: "gtk_page_setup_get_page_height", libgtk.}

proc newPageSetup*(fileName: cstring; error: var glib.GError): PageSetup {.
    importc: "gtk_page_setup_new_from_file", libgtk.}
proc loadFile*(setup: PageSetup; fileName: cstring;
                          error: var glib.GError): Gboolean {.
    importc: "gtk_page_setup_load_file", libgtk.}
proc toFile*(setup: PageSetup; fileName: cstring;
                        error: var glib.GError): Gboolean {.
    importc: "gtk_page_setup_to_file", libgtk.}
proc newPageSetup*(keyFile: glib.GKeyFile; groupName: cstring;
                                error: var glib.GError): PageSetup {.
    importc: "gtk_page_setup_new_from_key_file", libgtk.}
proc loadKeyFile*(setup: PageSetup; keyFile: glib.GKeyFile;
                             groupName: cstring; error: var glib.GError): Gboolean {.
    importc: "gtk_page_setup_load_key_file", libgtk.}
proc toKeyFile*(setup: PageSetup; keyFile: glib.GKeyFile;
                           groupName: cstring) {.
    importc: "gtk_page_setup_to_key_file", libgtk.}

template typePaned*(): expr =
  (panedGetType())

template paned*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typePaned, PanedObj))

template panedClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typePaned, PanedClassObj))

template isPaned*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typePaned))

template isPanedClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typePaned))

template panedGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typePaned, PanedClassObj))

type
  PlacesSidebar* =  ptr PlacesSidebarObj
  PlacesSidebarPtr* = ptr PlacesSidebarObj
  PlacesSidebarObj* = object

  PlacesSidebarClass* =  ptr PlacesSidebarClassObj
  PlacesSidebarClassPtr* = ptr PlacesSidebarClassObj
  PlacesSidebarClassObj* = object

proc panedGetType*(): GType {.importc: "gtk_paned_get_type", libgtk.}
proc newPaned*(orientation: Orientation): Paned {.
    importc: "gtk_paned_new", libgtk.}
proc add1*(paned: Paned; child: Widget) {.
    importc: "gtk_paned_add1", libgtk.}
proc add2*(paned: Paned; child: Widget) {.
    importc: "gtk_paned_add2", libgtk.}
proc pack1*(paned: Paned; child: Widget; resize: Gboolean;
                   shrink: Gboolean) {.importc: "gtk_paned_pack1", libgtk.}
proc pack2*(paned: Paned; child: Widget; resize: Gboolean;
                   shrink: Gboolean) {.importc: "gtk_paned_pack2", libgtk.}
proc getPosition*(paned: Paned): cint {.
    importc: "gtk_paned_get_position", libgtk.}
proc position*(paned: Paned): cint {.
    importc: "gtk_paned_get_position", libgtk.}
proc setPosition*(paned: Paned; position: cint) {.
    importc: "gtk_paned_set_position", libgtk.}
proc `position=`*(paned: Paned; position: cint) {.
    importc: "gtk_paned_set_position", libgtk.}
proc getChild1*(paned: Paned): Widget {.
    importc: "gtk_paned_get_child1", libgtk.}
proc child1*(paned: Paned): Widget {.
    importc: "gtk_paned_get_child1", libgtk.}
proc getChild2*(paned: Paned): Widget {.
    importc: "gtk_paned_get_child2", libgtk.}
proc child2*(paned: Paned): Widget {.
    importc: "gtk_paned_get_child2", libgtk.}
proc getHandleWindow*(paned: Paned): gdk3.Window {.
    importc: "gtk_paned_get_handle_window", libgtk.}
proc handleWindow*(paned: Paned): gdk3.Window {.
    importc: "gtk_paned_get_handle_window", libgtk.}
proc setWideHandle*(paned: Paned; wide: Gboolean) {.
    importc: "gtk_paned_set_wide_handle", libgtk.}
proc `wideHandle=`*(paned: Paned; wide: Gboolean) {.
    importc: "gtk_paned_set_wide_handle", libgtk.}
proc getWideHandle*(paned: Paned): Gboolean {.
    importc: "gtk_paned_get_wide_handle", libgtk.}
proc wideHandle*(paned: Paned): Gboolean {.
    importc: "gtk_paned_get_wide_handle", libgtk.}

template typePlacesSidebar*(): expr =
  (placesSidebarGetType())

template placesSidebar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typePlacesSidebar, PlacesSidebarObj))

template placesSidebarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typePlacesSidebar, PlacesSidebarClassObj))

template isPlacesSidebar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typePlacesSidebar))

template isPlacesSidebarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typePlacesSidebar))

template placesSidebarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typePlacesSidebar, PlacesSidebarClassObj))

type
  PlacesOpenFlags* {.size: sizeof(cint), pure.} = enum
    NORMAL = 1 shl 0, NEW_TAB = 1 shl 1,
    NEW_WINDOW = 1 shl 2

type
  PopoverMenuClass* =  ptr PopoverMenuClassObj
  PopoverMenuClassPtr* = ptr PopoverMenuClassObj
  PopoverMenuClassObj*{.final.} = object of PopoverClassObj
    reserved00: array[10, Gpointer]

  PopoverMenu* =  ptr PopoverMenuObj
  PopoverMenuPtr* = ptr PopoverMenuObj
  PopoverMenuObj* = object

proc placesSidebarGetType*(): GType {.importc: "gtk_places_sidebar_get_type",
                                      libgtk.}
proc newPlacesSidebar*(): PlacesSidebar {.importc: "gtk_places_sidebar_new",
    libgtk.}
proc getOpenFlags*(sidebar: PlacesSidebar): PlacesOpenFlags {.
    importc: "gtk_places_sidebar_get_open_flags", libgtk.}
proc openFlags*(sidebar: PlacesSidebar): PlacesOpenFlags {.
    importc: "gtk_places_sidebar_get_open_flags", libgtk.}
proc setOpenFlags*(sidebar: PlacesSidebar;
                                  flags: PlacesOpenFlags) {.
    importc: "gtk_places_sidebar_set_open_flags", libgtk.}
proc `openFlags=`*(sidebar: PlacesSidebar;
                                  flags: PlacesOpenFlags) {.
    importc: "gtk_places_sidebar_set_open_flags", libgtk.}
proc getLocation*(sidebar: PlacesSidebar): gio.GFile {.
    importc: "gtk_places_sidebar_get_location", libgtk.}
proc location*(sidebar: PlacesSidebar): gio.GFile {.
    importc: "gtk_places_sidebar_get_location", libgtk.}
proc setLocation*(sidebar: PlacesSidebar; location: gio.GFile) {.
    importc: "gtk_places_sidebar_set_location", libgtk.}
proc `location=`*(sidebar: PlacesSidebar; location: gio.GFile) {.
    importc: "gtk_places_sidebar_set_location", libgtk.}
proc getShowRecent*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_recent", libgtk.}
proc showRecent*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_recent", libgtk.}
proc setShowRecent*(sidebar: PlacesSidebar;
                                   showRecent: Gboolean) {.
    importc: "gtk_places_sidebar_set_show_recent", libgtk.}
proc `showRecent=`*(sidebar: PlacesSidebar;
                                   showRecent: Gboolean) {.
    importc: "gtk_places_sidebar_set_show_recent", libgtk.}
proc getShowDesktop*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_desktop", libgtk.}
proc showDesktop*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_desktop", libgtk.}
proc setShowDesktop*(sidebar: PlacesSidebar;
                                    showDesktop: Gboolean) {.
    importc: "gtk_places_sidebar_set_show_desktop", libgtk.}
proc `showDesktop=`*(sidebar: PlacesSidebar;
                                    showDesktop: Gboolean) {.
    importc: "gtk_places_sidebar_set_show_desktop", libgtk.}
proc getShowConnectToServer*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_connect_to_server", libgtk.}
proc showConnectToServer*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_connect_to_server", libgtk.}
proc setShowConnectToServer*(sidebar: PlacesSidebar;
    showConnectToServer: Gboolean) {.importc: "gtk_places_sidebar_set_show_connect_to_server",
                                   libgtk.}
proc `showConnectToServer=`*(sidebar: PlacesSidebar;
    showConnectToServer: Gboolean) {.importc: "gtk_places_sidebar_set_show_connect_to_server",
                                   libgtk.}
proc getShowEnterLocation*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_enter_location", libgtk.}
proc showEnterLocation*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_enter_location", libgtk.}
proc setShowEnterLocation*(sidebar: PlacesSidebar;
    showEnterLocation: Gboolean) {.importc: "gtk_places_sidebar_set_show_enter_location",
                                 libgtk.}
proc `showEnterLocation=`*(sidebar: PlacesSidebar;
    showEnterLocation: Gboolean) {.importc: "gtk_places_sidebar_set_show_enter_location",
                                 libgtk.}
proc setLocalOnly*(sidebar: PlacesSidebar;
                                  localOnly: Gboolean) {.
    importc: "gtk_places_sidebar_set_local_only", libgtk.}
proc `localOnly=`*(sidebar: PlacesSidebar;
                                  localOnly: Gboolean) {.
    importc: "gtk_places_sidebar_set_local_only", libgtk.}
proc getLocalOnly*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_local_only", libgtk.}
proc localOnly*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_local_only", libgtk.}
proc addShortcut*(sidebar: PlacesSidebar; location: gio.GFile) {.
    importc: "gtk_places_sidebar_add_shortcut", libgtk.}
proc removeShortcut*(sidebar: PlacesSidebar;
                                    location: gio.GFile) {.
    importc: "gtk_places_sidebar_remove_shortcut", libgtk.}
proc listShortcuts*(sidebar: PlacesSidebar): glib.GSList {.
    importc: "gtk_places_sidebar_list_shortcuts", libgtk.}
proc getNthBookmark*(sidebar: PlacesSidebar; n: cint): gio.GFile {.
    importc: "gtk_places_sidebar_get_nth_bookmark", libgtk.}
proc nthBookmark*(sidebar: PlacesSidebar; n: cint): gio.GFile {.
    importc: "gtk_places_sidebar_get_nth_bookmark", libgtk.}
proc setDropTargetsVisible*(sidebar: PlacesSidebar;
    visible: Gboolean; context: gdk3.DragContext) {.
    importc: "gtk_places_sidebar_set_drop_targets_visible", libgtk.}
proc `dropTargetsVisible=`*(sidebar: PlacesSidebar;
    visible: Gboolean; context: gdk3.DragContext) {.
    importc: "gtk_places_sidebar_set_drop_targets_visible", libgtk.}
proc getShowTrash*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_trash", libgtk.}
proc showTrash*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_trash", libgtk.}
proc setShowTrash*(sidebar: PlacesSidebar;
                                  showTrash: Gboolean) {.
    importc: "gtk_places_sidebar_set_show_trash", libgtk.}
proc `showTrash=`*(sidebar: PlacesSidebar;
                                  showTrash: Gboolean) {.
    importc: "gtk_places_sidebar_set_show_trash", libgtk.}
proc setShowOtherLocations*(sidebar: PlacesSidebar;
    showOtherLocations: Gboolean) {.importc: "gtk_places_sidebar_set_show_other_locations",
                                  libgtk.}
proc `showOtherLocations=`*(sidebar: PlacesSidebar;
    showOtherLocations: Gboolean) {.importc: "gtk_places_sidebar_set_show_other_locations",
                                  libgtk.}
proc getShowOtherLocations*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_other_locations", libgtk.}
proc showOtherLocations*(sidebar: PlacesSidebar): Gboolean {.
    importc: "gtk_places_sidebar_get_show_other_locations", libgtk.}

template typePopoverMenu*(): expr =
  (popoverMenuGetType())

template popoverMenu*(o: expr): expr =
  (gTypeCheckInstanceCast(o, typePopoverMenu, PopoverMenuObj))

template popoverMenuClass*(c: expr): expr =
  (gTypeCheckClassCast(c, typePopoverMenu, PopoverMenuClassObj))

template isPopoverMenu*(o: expr): expr =
  (gTypeCheckInstanceType(o, typePopoverMenu))

template isPopoverMenuClass*(o: expr): expr =
  (gTypeCheckClassType(o, typePopoverMenu))

template popoverMenuGetClass*(o: expr): expr =
  (gTypeInstanceGetClass(o, typePopoverMenu, PopoverMenuClassObj))

proc popoverMenuGetType*(): GType {.importc: "gtk_popover_menu_get_type",
                                    libgtk.}
proc newPopoverMenu*(): PopoverMenu {.importc: "gtk_popover_menu_new",
                                       libgtk.}
proc openSubmenu*(popover: PopoverMenu; name: cstring) {.
    importc: "gtk_popover_menu_open_submenu", libgtk.}

type
  PrintContext* =  ptr PrintContextObj
  PrintContextPtr* = ptr PrintContextObj
  PrintContextObj* = object

template typePrintContext*(): expr =
  (printContextGetType())

template printContext*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typePrintContext, PrintContextObj))

template isPrintContext*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typePrintContext))

proc printContextGetType*(): GType {.importc: "gtk_print_context_get_type",
                                     libgtk.}

proc getCairoContext*(context: PrintContext): cairo.Context {.
    importc: "gtk_print_context_get_cairo_context", libgtk.}

proc cairoContext*(context: PrintContext): cairo.Context {.
    importc: "gtk_print_context_get_cairo_context", libgtk.}
proc getPageSetup*(context: PrintContext): PageSetup {.
    importc: "gtk_print_context_get_page_setup", libgtk.}
proc pageSetup*(context: PrintContext): PageSetup {.
    importc: "gtk_print_context_get_page_setup", libgtk.}
proc getWidth*(context: PrintContext): cdouble {.
    importc: "gtk_print_context_get_width", libgtk.}
proc width*(context: PrintContext): cdouble {.
    importc: "gtk_print_context_get_width", libgtk.}
proc getHeight*(context: PrintContext): cdouble {.
    importc: "gtk_print_context_get_height", libgtk.}
proc height*(context: PrintContext): cdouble {.
    importc: "gtk_print_context_get_height", libgtk.}
proc getDpiX*(context: PrintContext): cdouble {.
    importc: "gtk_print_context_get_dpi_x", libgtk.}
proc dpiX*(context: PrintContext): cdouble {.
    importc: "gtk_print_context_get_dpi_x", libgtk.}
proc getDpiY*(context: PrintContext): cdouble {.
    importc: "gtk_print_context_get_dpi_y", libgtk.}
proc dpiY*(context: PrintContext): cdouble {.
    importc: "gtk_print_context_get_dpi_y", libgtk.}
proc getHardMargins*(context: PrintContext; top: ptr cdouble;
                                   bottom: ptr cdouble; left: var cdouble;
                                   right: var cdouble): Gboolean {.
    importc: "gtk_print_context_get_hard_margins", libgtk.}
proc hardMargins*(context: PrintContext; top: ptr cdouble;
                                   bottom: ptr cdouble; left: var cdouble;
                                   right: var cdouble): Gboolean {.
    importc: "gtk_print_context_get_hard_margins", libgtk.}

proc getPangoFontmap*(context: PrintContext): pango.FontMap {.
    importc: "gtk_print_context_get_pango_fontmap", libgtk.}

proc pangoFontmap*(context: PrintContext): pango.FontMap {.
    importc: "gtk_print_context_get_pango_fontmap", libgtk.}
proc createPangoContext*(context: PrintContext): pango.Context {.
    importc: "gtk_print_context_create_pango_context", libgtk.}
proc createPangoLayout*(context: PrintContext): pango.Layout {.
    importc: "gtk_print_context_create_pango_layout", libgtk.}

proc setCairoContext*(context: PrintContext; cr: cairo.Context;
                                    dpiX: cdouble; dpiY: cdouble) {.
    importc: "gtk_print_context_set_cairo_context", libgtk.}

proc `cairoContext=`*(context: PrintContext; cr: cairo.Context;
                                    dpiX: cdouble; dpiY: cdouble) {.
    importc: "gtk_print_context_set_cairo_context", libgtk.}

type
  PrintSettings* =  ptr PrintSettingsObj
  PrintSettingsPtr* = ptr PrintSettingsObj
  PrintSettingsObj* = object

template typePrintSettings*(): expr =
  (printSettingsGetType())

template printSettings*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typePrintSettings, PrintSettingsObj))

template isPrintSettings*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typePrintSettings))

type
  PrintSettingsFunc* = proc (key: cstring; value: cstring; userData: Gpointer) {.cdecl.}

type
  PageRange* =  ptr PageRangeObj
  PageRangePtr* = ptr PageRangeObj
  PageRangeObj* = object
    start*: cint
    `end`*: cint

  PrintOperationPreview* =  ptr PrintOperationPreviewObj
  PrintOperationPreviewPtr* = ptr PrintOperationPreviewObj
  PrintOperationPreviewObj* = object

type
  PrintOperationPreviewIface* =  ptr PrintOperationPreviewIfaceObj
  PrintOperationPreviewIfacePtr* = ptr PrintOperationPreviewIfaceObj
  PrintOperationPreviewIfaceObj* = object of gobject.GTypeInterfaceObj
    ready*: proc (preview: PrintOperationPreview; context: PrintContext) {.cdecl.}
    gotPageSize*: proc (preview: PrintOperationPreview;
                      context: PrintContext; pageSetup: PageSetup) {.cdecl.}
    renderPage*: proc (preview: PrintOperationPreview; pageNr: cint) {.cdecl.}
    isSelected*: proc (preview: PrintOperationPreview; pageNr: cint): Gboolean {.cdecl.}
    endPreview*: proc (preview: PrintOperationPreview) {.cdecl.}
    gtkReserved961*: proc () {.cdecl.}
    gtkReserved962*: proc () {.cdecl.}
    gtkReserved963*: proc () {.cdecl.}
    gtkReserved964*: proc () {.cdecl.}
    gtkReserved965*: proc () {.cdecl.}
    gtkReserved966*: proc () {.cdecl.}
    gtkReserved967*: proc () {.cdecl.}
    gtkReserved968*: proc () {.cdecl.}

proc printSettingsGetType*(): GType {.importc: "gtk_print_settings_get_type",
                                      libgtk.}
proc newPrintSettings*(): PrintSettings {.
    importc: "gtk_print_settings_new", libgtk.}
proc copy*(other: PrintSettings): PrintSettings {.
    importc: "gtk_print_settings_copy", libgtk.}
proc newPrintSettings*(fileName: cstring; error: var glib.GError): PrintSettings {.
    importc: "gtk_print_settings_new_from_file", libgtk.}
proc loadFile*(settings: PrintSettings; fileName: cstring;
                              error: var glib.GError): Gboolean {.
    importc: "gtk_print_settings_load_file", libgtk.}
proc toFile*(settings: PrintSettings; fileName: cstring;
                            error: var glib.GError): Gboolean {.
    importc: "gtk_print_settings_to_file", libgtk.}
proc newPrintSettings*(keyFile: glib.GKeyFile; groupName: cstring;
                                    error: var glib.GError): PrintSettings {.
    importc: "gtk_print_settings_new_from_key_file", libgtk.}
proc loadKeyFile*(settings: PrintSettings;
                                 keyFile: glib.GKeyFile; groupName: cstring;
                                 error: var glib.GError): Gboolean {.
    importc: "gtk_print_settings_load_key_file", libgtk.}
proc toKeyFile*(settings: PrintSettings;
                               keyFile: glib.GKeyFile; groupName: cstring) {.
    importc: "gtk_print_settings_to_key_file", libgtk.}
proc hasKey*(settings: PrintSettings; key: cstring): Gboolean {.
    importc: "gtk_print_settings_has_key", libgtk.}
proc get*(settings: PrintSettings; key: cstring): cstring {.
    importc: "gtk_print_settings_get", libgtk.}
proc set*(settings: PrintSettings; key: cstring; value: cstring) {.
    importc: "gtk_print_settings_set", libgtk.}
proc unset*(settings: PrintSettings; key: cstring) {.
    importc: "gtk_print_settings_unset", libgtk.}
proc foreach*(settings: PrintSettings;
                             `func`: PrintSettingsFunc; userData: Gpointer) {.
    importc: "gtk_print_settings_foreach", libgtk.}
proc getBool*(settings: PrintSettings; key: cstring): Gboolean {.
    importc: "gtk_print_settings_get_bool", libgtk.}
#proc bool*(settings: PrintSettings; key: cstring): Gboolean {.importc: "gtk_print_settings_get_bool", libgtk.}
proc setBool*(settings: PrintSettings; key: cstring;
                             value: Gboolean) {.
    importc: "gtk_print_settings_set_bool", libgtk.}
#proc `bool=`*(settings: PrintSettings; key: cstring; value: Gboolean) {.importc: "gtk_print_settings_set_bool", libgtk.}
proc getDouble*(settings: PrintSettings; key: cstring): cdouble {.
    importc: "gtk_print_settings_get_double", libgtk.}
#proc double*(settings: PrintSettings; key: cstring): cdouble {.importc: "gtk_print_settings_get_double", libgtk.}
proc getDoubleWithDefault*(settings: PrintSettings;
    key: cstring; def: cdouble): cdouble {.importc: "gtk_print_settings_get_double_with_default",
                                      libgtk.}
proc doubleWithDefault*(settings: PrintSettings;
    key: cstring; def: cdouble): cdouble {.importc: "gtk_print_settings_get_double_with_default",
                                      libgtk.}
proc setDouble*(settings: PrintSettings; key: cstring;
                               value: cdouble) {.
    importc: "gtk_print_settings_set_double", libgtk.}
#proc `double=`*(settings: PrintSettings; key: cstring; value: cdouble) {.importc: "gtk_print_settings_set_double", libgtk.}
proc getLength*(settings: PrintSettings; key: cstring;
                               unit: Unit): cdouble {.
    importc: "gtk_print_settings_get_length", libgtk.}
proc length*(settings: PrintSettings; key: cstring;
                               unit: Unit): cdouble {.
    importc: "gtk_print_settings_get_length", libgtk.}
proc setLength*(settings: PrintSettings; key: cstring;
                               value: cdouble; unit: Unit) {.
    importc: "gtk_print_settings_set_length", libgtk.}
proc `length=`*(settings: PrintSettings; key: cstring;
                               value: cdouble; unit: Unit) {.
    importc: "gtk_print_settings_set_length", libgtk.}
proc getInt*(settings: PrintSettings; key: cstring): cint {.
    importc: "gtk_print_settings_get_int", libgtk.}
#proc int*(settings: PrintSettings; key: cstring): cint {.importc: "gtk_print_settings_get_int", libgtk.}
proc getIntWithDefault*(settings: PrintSettings;
                                       key: cstring; def: cint): cint {.
    importc: "gtk_print_settings_get_int_with_default", libgtk.}
proc intWithDefault*(settings: PrintSettings;
                                       key: cstring; def: cint): cint {.
    importc: "gtk_print_settings_get_int_with_default", libgtk.}
proc setInt*(settings: PrintSettings; key: cstring; value: cint) {.
    importc: "gtk_print_settings_set_int", libgtk.}
#proc `int=`*(settings: PrintSettings; key: cstring; value: cint) {.importc: "gtk_print_settings_set_int", libgtk.}
const
  PRINT_SETTINGS_PRINTER* = "printer"
  PRINT_SETTINGS_ORIENTATION* = "orientation"
  PRINT_SETTINGS_PAPER_FORMAT* = "paper-format"
  PRINT_SETTINGS_PAPER_WIDTH* = "paper-width"
  PRINT_SETTINGS_PAPER_HEIGHT* = "paper-height"
  PRINT_SETTINGS_N_COPIES* = "n-copies"
  PRINT_SETTINGS_DEFAULT_SOURCE* = "default-source"
  PRINT_SETTINGS_QUALITY* = "quality"
  PRINT_SETTINGS_RESOLUTION* = "resolution"
  PRINT_SETTINGS_USE_COLOR* = "use-color"
  PRINT_SETTINGS_DUPLEX* = "duplex"
  PRINT_SETTINGS_COLLATE* = "collate"
  PRINT_SETTINGS_REVERSE* = "reverse"
  PRINT_SETTINGS_MEDIA_TYPE* = "media-type"
  PRINT_SETTINGS_DITHER* = "dither"
  PRINT_SETTINGS_SCALE* = "scale"
  PRINT_SETTINGS_PRINT_PAGES* = "print-pages"
  PRINT_SETTINGS_PAGE_RANGES* = "page-ranges"
  PRINT_SETTINGS_PAGE_SET* = "page-set"
  PRINT_SETTINGS_FINISHINGS* = "finishings"
  PRINT_SETTINGS_NUMBER_UP* = "number-up"
  PRINT_SETTINGS_NUMBER_UP_LAYOUT* = "number-up-layout"
  PRINT_SETTINGS_OUTPUT_BIN* = "output-bin"
  PRINT_SETTINGS_RESOLUTION_X* = "resolution-x"
  PRINT_SETTINGS_RESOLUTION_Y* = "resolution-y"
  PRINT_SETTINGS_PRINTER_LPI* = "printer-lpi"

const
  PRINT_SETTINGS_OUTPUT_DIR* = "output-dir"

const
  PRINT_SETTINGS_OUTPUT_BASENAME* = "output-basename"

const
  PRINT_SETTINGS_OUTPUT_FILE_FORMAT* = "output-file-format"

const
  PRINT_SETTINGS_OUTPUT_URI* = "output-uri"
  PRINT_SETTINGS_WIN32_DRIVER_VERSION* = "win32-driver-version"
  PRINT_SETTINGS_WIN32_DRIVER_EXTRA* = "win32-driver-extra"

proc getPrinter*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_printer", libgtk.}

proc printer*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_printer", libgtk.}
proc setPrinter*(settings: PrintSettings; printer: cstring) {.
    importc: "gtk_print_settings_set_printer", libgtk.}
proc `printer=`*(settings: PrintSettings; printer: cstring) {.
    importc: "gtk_print_settings_set_printer", libgtk.}
proc getOrientation*(settings: PrintSettings): PageOrientation {.
    importc: "gtk_print_settings_get_orientation", libgtk.}
proc orientation*(settings: PrintSettings): PageOrientation {.
    importc: "gtk_print_settings_get_orientation", libgtk.}
proc setOrientation*(settings: PrintSettings;
                                    orientation: PageOrientation) {.
    importc: "gtk_print_settings_set_orientation", libgtk.}
proc `orientation=`*(settings: PrintSettings;
                                    orientation: PageOrientation) {.
    importc: "gtk_print_settings_set_orientation", libgtk.}
proc getPaperSize*(settings: PrintSettings): PaperSize {.
    importc: "gtk_print_settings_get_paper_size", libgtk.}
proc paperSize*(settings: PrintSettings): PaperSize {.
    importc: "gtk_print_settings_get_paper_size", libgtk.}
proc setPaperSize*(settings: PrintSettings;
                                  paperSize: PaperSize) {.
    importc: "gtk_print_settings_set_paper_size", libgtk.}
proc `paperSize=`*(settings: PrintSettings;
                                  paperSize: PaperSize) {.
    importc: "gtk_print_settings_set_paper_size", libgtk.}
proc getPaperWidth*(settings: PrintSettings; unit: Unit): cdouble {.
    importc: "gtk_print_settings_get_paper_width", libgtk.}
proc paperWidth*(settings: PrintSettings; unit: Unit): cdouble {.
    importc: "gtk_print_settings_get_paper_width", libgtk.}
proc setPaperWidth*(settings: PrintSettings; width: cdouble;
                                   unit: Unit) {.
    importc: "gtk_print_settings_set_paper_width", libgtk.}
proc `paperWidth=`*(settings: PrintSettings; width: cdouble;
                                   unit: Unit) {.
    importc: "gtk_print_settings_set_paper_width", libgtk.}
proc getPaperHeight*(settings: PrintSettings; unit: Unit): cdouble {.
    importc: "gtk_print_settings_get_paper_height", libgtk.}
proc paperHeight*(settings: PrintSettings; unit: Unit): cdouble {.
    importc: "gtk_print_settings_get_paper_height", libgtk.}
proc setPaperHeight*(settings: PrintSettings;
                                    height: cdouble; unit: Unit) {.
    importc: "gtk_print_settings_set_paper_height", libgtk.}
proc `paperHeight=`*(settings: PrintSettings;
                                    height: cdouble; unit: Unit) {.
    importc: "gtk_print_settings_set_paper_height", libgtk.}
proc getUseColor*(settings: PrintSettings): Gboolean {.
    importc: "gtk_print_settings_get_use_color", libgtk.}
proc useColor*(settings: PrintSettings): Gboolean {.
    importc: "gtk_print_settings_get_use_color", libgtk.}
proc setUseColor*(settings: PrintSettings; useColor: Gboolean) {.
    importc: "gtk_print_settings_set_use_color", libgtk.}
proc `useColor=`*(settings: PrintSettings; useColor: Gboolean) {.
    importc: "gtk_print_settings_set_use_color", libgtk.}
proc getCollate*(settings: PrintSettings): Gboolean {.
    importc: "gtk_print_settings_get_collate", libgtk.}
proc collate*(settings: PrintSettings): Gboolean {.
    importc: "gtk_print_settings_get_collate", libgtk.}
proc setCollate*(settings: PrintSettings; collate: Gboolean) {.
    importc: "gtk_print_settings_set_collate", libgtk.}
proc `collate=`*(settings: PrintSettings; collate: Gboolean) {.
    importc: "gtk_print_settings_set_collate", libgtk.}
proc getReverse*(settings: PrintSettings): Gboolean {.
    importc: "gtk_print_settings_get_reverse", libgtk.}
proc reverse*(settings: PrintSettings): Gboolean {.
    importc: "gtk_print_settings_get_reverse", libgtk.}
proc setReverse*(settings: PrintSettings; reverse: Gboolean) {.
    importc: "gtk_print_settings_set_reverse", libgtk.}
proc `reverse=`*(settings: PrintSettings; reverse: Gboolean) {.
    importc: "gtk_print_settings_set_reverse", libgtk.}
proc getDuplex*(settings: PrintSettings): PrintDuplex {.
    importc: "gtk_print_settings_get_duplex", libgtk.}
proc duplex*(settings: PrintSettings): PrintDuplex {.
    importc: "gtk_print_settings_get_duplex", libgtk.}
proc setDuplex*(settings: PrintSettings;
                               duplex: PrintDuplex) {.
    importc: "gtk_print_settings_set_duplex", libgtk.}
proc `duplex=`*(settings: PrintSettings;
                               duplex: PrintDuplex) {.
    importc: "gtk_print_settings_set_duplex", libgtk.}
proc getQuality*(settings: PrintSettings): PrintQuality {.
    importc: "gtk_print_settings_get_quality", libgtk.}
proc quality*(settings: PrintSettings): PrintQuality {.
    importc: "gtk_print_settings_get_quality", libgtk.}
proc setQuality*(settings: PrintSettings;
                                quality: PrintQuality) {.
    importc: "gtk_print_settings_set_quality", libgtk.}
proc `quality=`*(settings: PrintSettings;
                                quality: PrintQuality) {.
    importc: "gtk_print_settings_set_quality", libgtk.}
proc getNCopies*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_n_copies", libgtk.}
proc nCopies*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_n_copies", libgtk.}
proc setNCopies*(settings: PrintSettings; numCopies: cint) {.
    importc: "gtk_print_settings_set_n_copies", libgtk.}
proc `nCopies=`*(settings: PrintSettings; numCopies: cint) {.
    importc: "gtk_print_settings_set_n_copies", libgtk.}
proc getNumberUp*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_number_up", libgtk.}
proc numberUp*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_number_up", libgtk.}
proc setNumberUp*(settings: PrintSettings; numberUp: cint) {.
    importc: "gtk_print_settings_set_number_up", libgtk.}
proc `numberUp=`*(settings: PrintSettings; numberUp: cint) {.
    importc: "gtk_print_settings_set_number_up", libgtk.}
proc getNumberUpLayout*(settings: PrintSettings): NumberUpLayout {.
    importc: "gtk_print_settings_get_number_up_layout", libgtk.}
proc numberUpLayout*(settings: PrintSettings): NumberUpLayout {.
    importc: "gtk_print_settings_get_number_up_layout", libgtk.}
proc setNumberUpLayout*(settings: PrintSettings;
                                       numberUpLayout: NumberUpLayout) {.
    importc: "gtk_print_settings_set_number_up_layout", libgtk.}
proc `numberUpLayout=`*(settings: PrintSettings;
                                       numberUpLayout: NumberUpLayout) {.
    importc: "gtk_print_settings_set_number_up_layout", libgtk.}
proc getResolution*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_resolution", libgtk.}
proc resolution*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_resolution", libgtk.}
proc setResolution*(settings: PrintSettings; resolution: cint) {.
    importc: "gtk_print_settings_set_resolution", libgtk.}
proc `resolution=`*(settings: PrintSettings; resolution: cint) {.
    importc: "gtk_print_settings_set_resolution", libgtk.}
proc getResolutionX*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_resolution_x", libgtk.}
proc resolutionX*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_resolution_x", libgtk.}
proc getResolutionY*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_resolution_y", libgtk.}
proc resolutionY*(settings: PrintSettings): cint {.
    importc: "gtk_print_settings_get_resolution_y", libgtk.}
proc setResolutionXy*(settings: PrintSettings;
                                     resolutionX: cint; resolutionY: cint) {.
    importc: "gtk_print_settings_set_resolution_xy", libgtk.}
proc `resolutionXy=`*(settings: PrintSettings;
                                     resolutionX: cint; resolutionY: cint) {.
    importc: "gtk_print_settings_set_resolution_xy", libgtk.}
proc getPrinterLpi*(settings: PrintSettings): cdouble {.
    importc: "gtk_print_settings_get_printer_lpi", libgtk.}
proc printerLpi*(settings: PrintSettings): cdouble {.
    importc: "gtk_print_settings_get_printer_lpi", libgtk.}
proc setPrinterLpi*(settings: PrintSettings; lpi: cdouble) {.
    importc: "gtk_print_settings_set_printer_lpi", libgtk.}
proc `printerLpi=`*(settings: PrintSettings; lpi: cdouble) {.
    importc: "gtk_print_settings_set_printer_lpi", libgtk.}
proc getScale*(settings: PrintSettings): cdouble {.
    importc: "gtk_print_settings_get_scale", libgtk.}
proc scale*(settings: PrintSettings): cdouble {.
    importc: "gtk_print_settings_get_scale", libgtk.}
proc setScale*(settings: PrintSettings; scale: cdouble) {.
    importc: "gtk_print_settings_set_scale", libgtk.}
proc `scale=`*(settings: PrintSettings; scale: cdouble) {.
    importc: "gtk_print_settings_set_scale", libgtk.}
proc getPrintPages*(settings: PrintSettings): PrintPages {.
    importc: "gtk_print_settings_get_print_pages", libgtk.}
proc printPages*(settings: PrintSettings): PrintPages {.
    importc: "gtk_print_settings_get_print_pages", libgtk.}
proc setPrintPages*(settings: PrintSettings;
                                   pages: PrintPages) {.
    importc: "gtk_print_settings_set_print_pages", libgtk.}
proc `printPages=`*(settings: PrintSettings;
                                   pages: PrintPages) {.
    importc: "gtk_print_settings_set_print_pages", libgtk.}
proc getPageRanges*(settings: PrintSettings;
                                   numRanges: var cint): PageRange {.
    importc: "gtk_print_settings_get_page_ranges", libgtk.}
proc pageRanges*(settings: PrintSettings;
                                   numRanges: var cint): PageRange {.
    importc: "gtk_print_settings_get_page_ranges", libgtk.}
proc setPageRanges*(settings: PrintSettings;
                                   pageRanges: PageRange; numRanges: cint) {.
    importc: "gtk_print_settings_set_page_ranges", libgtk.}
proc `pageRanges=`*(settings: PrintSettings;
                                   pageRanges: PageRange; numRanges: cint) {.
    importc: "gtk_print_settings_set_page_ranges", libgtk.}
proc getPageSet*(settings: PrintSettings): PageSet {.
    importc: "gtk_print_settings_get_page_set", libgtk.}
proc pageSet*(settings: PrintSettings): PageSet {.
    importc: "gtk_print_settings_get_page_set", libgtk.}
proc setPageSet*(settings: PrintSettings; pageSet: PageSet) {.
    importc: "gtk_print_settings_set_page_set", libgtk.}
proc `pageSet=`*(settings: PrintSettings; pageSet: PageSet) {.
    importc: "gtk_print_settings_set_page_set", libgtk.}
proc getDefaultSource*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_default_source", libgtk.}
proc defaultSource*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_default_source", libgtk.}
proc setDefaultSource*(settings: PrintSettings;
                                      defaultSource: cstring) {.
    importc: "gtk_print_settings_set_default_source", libgtk.}
proc `defaultSource=`*(settings: PrintSettings;
                                      defaultSource: cstring) {.
    importc: "gtk_print_settings_set_default_source", libgtk.}
proc getMediaType*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_media_type", libgtk.}
proc mediaType*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_media_type", libgtk.}
proc setMediaType*(settings: PrintSettings;
                                  mediaType: cstring) {.
    importc: "gtk_print_settings_set_media_type", libgtk.}
proc `mediaType=`*(settings: PrintSettings;
                                  mediaType: cstring) {.
    importc: "gtk_print_settings_set_media_type", libgtk.}
proc getDither*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_dither", libgtk.}
proc dither*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_dither", libgtk.}
proc setDither*(settings: PrintSettings; dither: cstring) {.
    importc: "gtk_print_settings_set_dither", libgtk.}
proc `dither=`*(settings: PrintSettings; dither: cstring) {.
    importc: "gtk_print_settings_set_dither", libgtk.}
proc getFinishings*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_finishings", libgtk.}
proc finishings*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_finishings", libgtk.}
proc setFinishings*(settings: PrintSettings;
                                   finishings: cstring) {.
    importc: "gtk_print_settings_set_finishings", libgtk.}
proc `finishings=`*(settings: PrintSettings;
                                   finishings: cstring) {.
    importc: "gtk_print_settings_set_finishings", libgtk.}
proc getOutputBin*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_output_bin", libgtk.}
proc outputBin*(settings: PrintSettings): cstring {.
    importc: "gtk_print_settings_get_output_bin", libgtk.}
proc setOutputBin*(settings: PrintSettings;
                                  outputBin: cstring) {.
    importc: "gtk_print_settings_set_output_bin", libgtk.}
proc `outputBin=`*(settings: PrintSettings;
                                  outputBin: cstring) {.
    importc: "gtk_print_settings_set_output_bin", libgtk.}

template typePrintOperationPreview*(): expr =
  (printOperationPreviewGetType())

template printOperationPreview*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typePrintOperationPreview, PrintOperationPreviewObj))

template isPrintOperationPreview*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typePrintOperationPreview))

template printOperationPreviewGetIface*(obj: expr): expr =
  (gTypeInstanceGetInterface(obj, typePrintOperationPreview, PrintOperationPreviewIfaceObj))

type
  PrintOperationResult* {.size: sizeof(cint), pure.} = enum
    ERROR, APPLY,
    CANCEL, IN_PROGRESS
type
  PrintOperation* =  ptr PrintOperationObj
  PrintOperationPtr* = ptr PrintOperationObj
  PrintOperationObj*{.final.} = object of GObjectObj
    priv101: pointer

  PrintOperationClass* =  ptr PrintOperationClassObj
  PrintOperationClassPtr* = ptr PrintOperationClassObj
  PrintOperationClassObj*{.final.} = object of GObjectClassObj
    done*: proc (operation: PrintOperation; result: PrintOperationResult) {.cdecl.}
    beginPrint*: proc (operation: PrintOperation; context: PrintContext) {.cdecl.}
    paginate*: proc (operation: PrintOperation; context: PrintContext): Gboolean {.cdecl.}
    requestPageSetup*: proc (operation: PrintOperation;
                           context: PrintContext; pageNr: cint;
                           setup: PageSetup) {.cdecl.}
    drawPage*: proc (operation: PrintOperation; context: PrintContext;
                   pageNr: cint) {.cdecl.}
    endPrint*: proc (operation: PrintOperation; context: PrintContext) {.cdecl.}
    statusChanged*: proc (operation: PrintOperation) {.cdecl.}
    createCustomWidget*: proc (operation: PrintOperation): Widget {.cdecl.}
    customWidgetApply*: proc (operation: PrintOperation; widget: Widget) {.cdecl.}
    preview*: proc (operation: PrintOperation;
                  preview: PrintOperationPreview;
                  context: PrintContext; parent: Window): Gboolean {.cdecl.}
    updateCustomWidget*: proc (operation: PrintOperation;
                             widget: Widget; setup: PageSetup;
                             settings: PrintSettings) {.cdecl.}
    gtkReserved971*: proc () {.cdecl.}
    gtkReserved972*: proc () {.cdecl.}
    gtkReserved973*: proc () {.cdecl.}
    gtkReserved974*: proc () {.cdecl.}
    gtkReserved975*: proc () {.cdecl.}
    gtkReserved976*: proc () {.cdecl.}
    gtkReserved977*: proc () {.cdecl.}
    gtkReserved978*: proc () {.cdecl.}

proc printOperationPreviewGetType*(): GType {.
    importc: "gtk_print_operation_preview_get_type", libgtk.}
proc renderPage*(preview: PrintOperationPreview;
                                        pageNr: cint) {.
    importc: "gtk_print_operation_preview_render_page", libgtk.}
proc endPreview*(preview: PrintOperationPreview) {.
    importc: "gtk_print_operation_preview_end_preview", libgtk.}
proc isSelected*(preview: PrintOperationPreview;
                                        pageNr: cint): Gboolean {.
    importc: "gtk_print_operation_preview_is_selected", libgtk.}

template typePrintOperation*(): expr =
  (printOperationGetType())

template printOperation*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typePrintOperation, PrintOperationObj))

template printOperationClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typePrintOperation, PrintOperationClassObj))

template isPrintOperation*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typePrintOperation))

template isPrintOperationClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typePrintOperation))

template printOperationGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typePrintOperation, PrintOperationClassObj))

type
  PrintStatus* {.size: sizeof(cint), pure.} = enum
    INITIAL, PREPARING,
    GENERATING_DATA, SENDING_DATA,
    PENDING, PENDING_ISSUE,
    PRINTING, FINISHED,
    FINISHED_ABORTED

type
  PrintOperationAction* {.size: sizeof(cint), pure.} = enum
    PRINT_DIALOG, PRINT,
    PREVIEW, `EXPORT`

template printError*(): expr =
  gtkPrintErrorQuark()

type
  PrintError* {.size: sizeof(cint), pure.} = enum
    GENERAL, INTERNAL_ERROR,
    NOMEM, INVALID_FILE

type
  ProgressBar* =  ptr ProgressBarObj
  ProgressBarPtr* = ptr ProgressBarObj
  ProgressBarObj*{.final.} = object of WidgetObj
    priv102: pointer

  ProgressBarClass* =  ptr ProgressBarClassObj
  ProgressBarClassPtr* = ptr ProgressBarClassObj
  ProgressBarClassObj*{.final.} = object of WidgetClassObj
    gtkReserved981*: proc () {.cdecl.}
    gtkReserved982*: proc () {.cdecl.}
    gtkReserved983*: proc () {.cdecl.}
    gtkReserved984*: proc () {.cdecl.}

proc printErrorQuark*(): GQuark {.importc: "gtk_print_error_quark", libgtk.}
proc printOperationGetType*(): GType {.importc: "gtk_print_operation_get_type",
                                       libgtk.}
proc newPrintOperation*(): PrintOperation {.
    importc: "gtk_print_operation_new", libgtk.}
proc setDefaultPageSetup*(op: PrintOperation;
    defaultPageSetup: PageSetup) {.importc: "gtk_print_operation_set_default_page_setup",
                                       libgtk.}
proc `defaultPageSetup=`*(op: PrintOperation;
    defaultPageSetup: PageSetup) {.importc: "gtk_print_operation_set_default_page_setup",
                                       libgtk.}
proc getDefaultPageSetup*(op: PrintOperation): PageSetup {.
    importc: "gtk_print_operation_get_default_page_setup", libgtk.}
proc defaultPageSetup*(op: PrintOperation): PageSetup {.
    importc: "gtk_print_operation_get_default_page_setup", libgtk.}
proc setPrintSettings*(op: PrintOperation;
                                       printSettings: PrintSettings) {.
    importc: "gtk_print_operation_set_print_settings", libgtk.}
proc `printSettings=`*(op: PrintOperation;
                                       printSettings: PrintSettings) {.
    importc: "gtk_print_operation_set_print_settings", libgtk.}
proc getPrintSettings*(op: PrintOperation): PrintSettings {.
    importc: "gtk_print_operation_get_print_settings", libgtk.}
proc printSettings*(op: PrintOperation): PrintSettings {.
    importc: "gtk_print_operation_get_print_settings", libgtk.}
proc setJobName*(op: PrintOperation; jobName: cstring) {.
    importc: "gtk_print_operation_set_job_name", libgtk.}
proc `jobName=`*(op: PrintOperation; jobName: cstring) {.
    importc: "gtk_print_operation_set_job_name", libgtk.}
proc setNPages*(op: PrintOperation; nPages: cint) {.
    importc: "gtk_print_operation_set_n_pages", libgtk.}
proc `nPages=`*(op: PrintOperation; nPages: cint) {.
    importc: "gtk_print_operation_set_n_pages", libgtk.}
proc setCurrentPage*(op: PrintOperation; currentPage: cint) {.
    importc: "gtk_print_operation_set_current_page", libgtk.}
proc `currentPage=`*(op: PrintOperation; currentPage: cint) {.
    importc: "gtk_print_operation_set_current_page", libgtk.}
proc setUseFullPage*(op: PrintOperation; fullPage: Gboolean) {.
    importc: "gtk_print_operation_set_use_full_page", libgtk.}
proc `useFullPage=`*(op: PrintOperation; fullPage: Gboolean) {.
    importc: "gtk_print_operation_set_use_full_page", libgtk.}
proc setUnit*(op: PrintOperation; unit: Unit) {.
    importc: "gtk_print_operation_set_unit", libgtk.}
proc `unit=`*(op: PrintOperation; unit: Unit) {.
    importc: "gtk_print_operation_set_unit", libgtk.}
proc setExportFilename*(op: PrintOperation;
                                        filename: cstring) {.
    importc: "gtk_print_operation_set_export_filename", libgtk.}
proc `exportFilename=`*(op: PrintOperation;
                                        filename: cstring) {.
    importc: "gtk_print_operation_set_export_filename", libgtk.}
proc setTrackPrintStatus*(op: PrintOperation;
    trackStatus: Gboolean) {.importc: "gtk_print_operation_set_track_print_status",
                           libgtk.}
proc `trackPrintStatus=`*(op: PrintOperation;
    trackStatus: Gboolean) {.importc: "gtk_print_operation_set_track_print_status",
                           libgtk.}
proc setShowProgress*(op: PrintOperation;
                                      showProgress: Gboolean) {.
    importc: "gtk_print_operation_set_show_progress", libgtk.}
proc `showProgress=`*(op: PrintOperation;
                                      showProgress: Gboolean) {.
    importc: "gtk_print_operation_set_show_progress", libgtk.}
proc setAllowAsync*(op: PrintOperation; allowAsync: Gboolean) {.
    importc: "gtk_print_operation_set_allow_async", libgtk.}
proc `allowAsync=`*(op: PrintOperation; allowAsync: Gboolean) {.
    importc: "gtk_print_operation_set_allow_async", libgtk.}
proc setCustomTabLabel*(op: PrintOperation; label: cstring) {.
    importc: "gtk_print_operation_set_custom_tab_label", libgtk.}
proc `customTabLabel=`*(op: PrintOperation; label: cstring) {.
    importc: "gtk_print_operation_set_custom_tab_label", libgtk.}
proc run*(op: PrintOperation;
                          action: PrintOperationAction; parent: Window;
                          error: var glib.GError): PrintOperationResult {.
    importc: "gtk_print_operation_run", libgtk.}
proc getError*(op: PrintOperation; error: var glib.GError) {.
    importc: "gtk_print_operation_get_error", libgtk.}
proc getStatus*(op: PrintOperation): PrintStatus {.
    importc: "gtk_print_operation_get_status", libgtk.}
proc status*(op: PrintOperation): PrintStatus {.
    importc: "gtk_print_operation_get_status", libgtk.}
proc getStatusString*(op: PrintOperation): cstring {.
    importc: "gtk_print_operation_get_status_string", libgtk.}
proc statusString*(op: PrintOperation): cstring {.
    importc: "gtk_print_operation_get_status_string", libgtk.}
proc isFinished*(op: PrintOperation): Gboolean {.
    importc: "gtk_print_operation_is_finished", libgtk.}
proc cancel*(op: PrintOperation) {.
    importc: "gtk_print_operation_cancel", libgtk.}
proc drawPageFinish*(op: PrintOperation) {.
    importc: "gtk_print_operation_draw_page_finish", libgtk.}
proc setDeferDrawing*(op: PrintOperation) {.
    importc: "gtk_print_operation_set_defer_drawing", libgtk.}
proc `deferDrawing=`*(op: PrintOperation) {.
    importc: "gtk_print_operation_set_defer_drawing", libgtk.}
proc setSupportSelection*(op: PrintOperation;
    supportSelection: Gboolean) {.importc: "gtk_print_operation_set_support_selection",
                                libgtk.}
proc `supportSelection=`*(op: PrintOperation;
    supportSelection: Gboolean) {.importc: "gtk_print_operation_set_support_selection",
                                libgtk.}
proc getSupportSelection*(op: PrintOperation): Gboolean {.
    importc: "gtk_print_operation_get_support_selection", libgtk.}
proc supportSelection*(op: PrintOperation): Gboolean {.
    importc: "gtk_print_operation_get_support_selection", libgtk.}
proc setHasSelection*(op: PrintOperation;
                                      hasSelection: Gboolean) {.
    importc: "gtk_print_operation_set_has_selection", libgtk.}
proc `hasSelection=`*(op: PrintOperation;
                                      hasSelection: Gboolean) {.
    importc: "gtk_print_operation_set_has_selection", libgtk.}
proc getHasSelection*(op: PrintOperation): Gboolean {.
    importc: "gtk_print_operation_get_has_selection", libgtk.}
proc hasSelection*(op: PrintOperation): Gboolean {.
    importc: "gtk_print_operation_get_has_selection", libgtk.}
proc setEmbedPageSetup*(op: PrintOperation; embed: Gboolean) {.
    importc: "gtk_print_operation_set_embed_page_setup", libgtk.}
proc `embedPageSetup=`*(op: PrintOperation; embed: Gboolean) {.
    importc: "gtk_print_operation_set_embed_page_setup", libgtk.}
proc getEmbedPageSetup*(op: PrintOperation): Gboolean {.
    importc: "gtk_print_operation_get_embed_page_setup", libgtk.}
proc embedPageSetup*(op: PrintOperation): Gboolean {.
    importc: "gtk_print_operation_get_embed_page_setup", libgtk.}
proc getNPagesToPrint*(op: PrintOperation): cint {.
    importc: "gtk_print_operation_get_n_pages_to_print", libgtk.}
proc nPagesToPrint*(op: PrintOperation): cint {.
    importc: "gtk_print_operation_get_n_pages_to_print", libgtk.}
proc printRunPageSetupDialog*(parent: Window; pageSetup: PageSetup;
                                settings: PrintSettings): PageSetup {.
    importc: "gtk_print_run_page_setup_dialog", libgtk.}

type
  PageSetupDoneFunc* = proc (pageSetup: PageSetup; data: Gpointer) {.cdecl.}

proc printRunPageSetupDialogAsync*(parent: Window;
                                     pageSetup: PageSetup;
                                     settings: PrintSettings;
                                     doneCb: PageSetupDoneFunc; data: Gpointer) {.
    importc: "gtk_print_run_page_setup_dialog_async", libgtk.}

template typeProgressBar*(): expr =
  (progressBarGetType())

template progressBar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeProgressBar, ProgressBarObj))

template progressBarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeProgressBar, ProgressBarClassObj))

template isProgressBar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeProgressBar))

template isProgressBarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeProgressBar))

template progressBarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeProgressBar, ProgressBarClassObj))

type
  RadioButton* =  ptr RadioButtonObj
  RadioButtonPtr* = ptr RadioButtonObj
  RadioButtonObj* = object of CheckButtonObj
    priv103: pointer

  RadioButtonClass* =  ptr RadioButtonClassObj
  RadioButtonClassPtr* = ptr RadioButtonClassObj
  RadioButtonClassObj*{.final.} = object of CheckButtonClassObj
    groupChanged*: proc (radioButton: RadioButton) {.cdecl.}
    gtkReserved991*: proc () {.cdecl.}
    gtkReserved992*: proc () {.cdecl.}
    gtkReserved993*: proc () {.cdecl.}
    gtkReserved994*: proc () {.cdecl.}

proc progressBarGetType*(): GType {.importc: "gtk_progress_bar_get_type",
                                    libgtk.}
proc newProgressBar*(): ProgressBar {.importc: "gtk_progress_bar_new",
                                       libgtk.}
proc pulse*(pbar: ProgressBar) {.
    importc: "gtk_progress_bar_pulse", libgtk.}
proc setText*(pbar: ProgressBar; text: cstring) {.
    importc: "gtk_progress_bar_set_text", libgtk.}
proc `text=`*(pbar: ProgressBar; text: cstring) {.
    importc: "gtk_progress_bar_set_text", libgtk.}
proc setFraction*(pbar: ProgressBar; fraction: cdouble) {.
    importc: "gtk_progress_bar_set_fraction", libgtk.}
proc `fraction=`*(pbar: ProgressBar; fraction: cdouble) {.
    importc: "gtk_progress_bar_set_fraction", libgtk.}
proc setPulseStep*(pbar: ProgressBar; fraction: cdouble) {.
    importc: "gtk_progress_bar_set_pulse_step", libgtk.}
proc `pulseStep=`*(pbar: ProgressBar; fraction: cdouble) {.
    importc: "gtk_progress_bar_set_pulse_step", libgtk.}
proc setInverted*(pbar: ProgressBar; inverted: Gboolean) {.
    importc: "gtk_progress_bar_set_inverted", libgtk.}
proc `inverted=`*(pbar: ProgressBar; inverted: Gboolean) {.
    importc: "gtk_progress_bar_set_inverted", libgtk.}
proc getText*(pbar: ProgressBar): cstring {.
    importc: "gtk_progress_bar_get_text", libgtk.}
proc text*(pbar: ProgressBar): cstring {.
    importc: "gtk_progress_bar_get_text", libgtk.}
proc getFraction*(pbar: ProgressBar): cdouble {.
    importc: "gtk_progress_bar_get_fraction", libgtk.}
proc fraction*(pbar: ProgressBar): cdouble {.
    importc: "gtk_progress_bar_get_fraction", libgtk.}
proc getPulseStep*(pbar: ProgressBar): cdouble {.
    importc: "gtk_progress_bar_get_pulse_step", libgtk.}
proc pulseStep*(pbar: ProgressBar): cdouble {.
    importc: "gtk_progress_bar_get_pulse_step", libgtk.}
proc getInverted*(pbar: ProgressBar): Gboolean {.
    importc: "gtk_progress_bar_get_inverted", libgtk.}
proc inverted*(pbar: ProgressBar): Gboolean {.
    importc: "gtk_progress_bar_get_inverted", libgtk.}
proc setEllipsize*(pbar: ProgressBar; mode: pango.EllipsizeMode) {.
    importc: "gtk_progress_bar_set_ellipsize", libgtk.}
proc `ellipsize=`*(pbar: ProgressBar; mode: pango.EllipsizeMode) {.
    importc: "gtk_progress_bar_set_ellipsize", libgtk.}
proc getEllipsize*(pbar: ProgressBar): pango.EllipsizeMode {.
    importc: "gtk_progress_bar_get_ellipsize", libgtk.}
proc ellipsize*(pbar: ProgressBar): pango.EllipsizeMode {.
    importc: "gtk_progress_bar_get_ellipsize", libgtk.}
proc setShowText*(pbar: ProgressBar; showText: Gboolean) {.
    importc: "gtk_progress_bar_set_show_text", libgtk.}
proc `showText=`*(pbar: ProgressBar; showText: Gboolean) {.
    importc: "gtk_progress_bar_set_show_text", libgtk.}
proc getShowText*(pbar: ProgressBar): Gboolean {.
    importc: "gtk_progress_bar_get_show_text", libgtk.}
proc showText*(pbar: ProgressBar): Gboolean {.
    importc: "gtk_progress_bar_get_show_text", libgtk.}

template typeRadioButton*(): expr =
  (radioButtonGetType())

template radioButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRadioButton, RadioButtonObj))

template radioButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeRadioButton, RadioButtonClassObj))

template isRadioButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRadioButton))

template isRadioButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeRadioButton))

template radioButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeRadioButton, RadioButtonClassObj))

type
  RadioMenuItem* =  ptr RadioMenuItemObj
  RadioMenuItemPtr* = ptr RadioMenuItemObj
  RadioMenuItemObj* = object of CheckMenuItemObj
    priv104: pointer

  RadioMenuItemClass* =  ptr RadioMenuItemClassObj
  RadioMenuItemClassPtr* = ptr RadioMenuItemClassObj
  RadioMenuItemClassObj*{.final.} = object of CheckMenuItemClassObj
    groupChanged*: proc (radioMenuItem: RadioMenuItem) {.cdecl.}
    gtkReserved1001*: proc () {.cdecl.}
    gtkReserved1002*: proc () {.cdecl.}
    gtkReserved1003*: proc () {.cdecl.}
    gtkReserved1004*: proc () {.cdecl.}

proc radioButtonGetType*(): GType {.importc: "gtk_radio_button_get_type",
                                    libgtk.}
proc newRadioButton*(group: glib.GSList): RadioButton {.
    importc: "gtk_radio_button_new", libgtk.}
proc getGroup*(radioButton: RadioButton): glib.GSList {.
    importc: "gtk_radio_button_get_group", libgtk.}
proc group*(radioButton: RadioButton): glib.GSList {.
    importc: "gtk_radio_button_get_group", libgtk.}
proc setGroup*(radioButton: RadioButton; group: glib.GSList) {.
    importc: "gtk_radio_button_set_group", libgtk.}
proc `group=`*(radioButton: RadioButton; group: glib.GSList) {.
    importc: "gtk_radio_button_set_group", libgtk.}
proc joinGroup*(radioButton: RadioButton;
                             groupSource: RadioButton) {.
    importc: "gtk_radio_button_join_group", libgtk.}

template typeRadioMenuItem*(): expr =
  (radioMenuItemGetType())

template radioMenuItem*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRadioMenuItem, RadioMenuItemObj))

template radioMenuItemClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeRadioMenuItem, RadioMenuItemClassObj))

template isRadioMenuItem*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRadioMenuItem))

template isRadioMenuItemClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeRadioMenuItem))

template radioMenuItemGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeRadioMenuItem, RadioMenuItemClassObj))

type
  ToggleToolButton* =  ptr ToggleToolButtonObj
  ToggleToolButtonPtr* = ptr ToggleToolButtonObj
  ToggleToolButtonObj = object of ToolButtonObj
    priv105: pointer

  ToggleToolButtonClass* =  ptr ToggleToolButtonClassObj
  ToggleToolButtonClassPtr* = ptr ToggleToolButtonClassObj
  ToggleToolButtonClassObj = object of ToolButtonClassObj
    toggled*: proc (button: ToggleToolButton) {.cdecl.}
    gtkReserved1011*: proc () {.cdecl.}
    gtkReserved1012*: proc () {.cdecl.}
    gtkReserved1013*: proc () {.cdecl.}
    gtkReserved1014*: proc () {.cdecl.}

proc radioMenuItemGetType*(): GType {.importc: "gtk_radio_menu_item_get_type",
                                      libgtk.}
proc newRadioMenuItem*(group: glib.GSList): RadioMenuItem {.
    importc: "gtk_radio_menu_item_new", libgtk.}
proc getGroup*(radioMenuItem: RadioMenuItem): glib.GSList {.
    importc: "gtk_radio_menu_item_get_group", libgtk.}
proc group*(radioMenuItem: RadioMenuItem): glib.GSList {.
    importc: "gtk_radio_menu_item_get_group", libgtk.}
proc setGroup*(radioMenuItem: RadioMenuItem;
                              group: glib.GSList) {.
    importc: "gtk_radio_menu_item_set_group", libgtk.}
proc `group=`*(radioMenuItem: RadioMenuItem;
                              group: glib.GSList) {.
    importc: "gtk_radio_menu_item_set_group", libgtk.}
proc joinGroup*(radioMenuItem: RadioMenuItem;
                               groupSource: RadioMenuItem) {.
    importc: "gtk_radio_menu_item_join_group", libgtk.}

template typeToggleToolButton*(): expr =
  (toggleToolButtonGetType())

template toggleToolButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeToggleToolButton, ToggleToolButtonObj))

template toggleToolButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeToggleToolButton, ToggleToolButtonClassObj))

template isToggleToolButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeToggleToolButton))

template isToggleToolButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeToggleToolButton))

template toggleToolButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeToggleToolButton, ToggleToolButtonClassObj))

type
  RadioToolButton* =  ptr RadioToolButtonObj
  RadioToolButtonPtr* = ptr RadioToolButtonObj
  RadioToolButtonObj*{.final.} = object of ToggleToolButtonObj

  RadioToolButtonClass* =  ptr RadioToolButtonClassObj
  RadioToolButtonClassPtr* = ptr RadioToolButtonClassObj
  RadioToolButtonClassObj*{.final.} = object of ToggleToolButtonClassObj
    gtkReserved1021*: proc () {.cdecl.}
    gtkReserved1022*: proc () {.cdecl.}
    gtkReserved1023*: proc () {.cdecl.}
    gtkReserved1024*: proc () {.cdecl.}

proc toggleToolButtonGetType*(): GType {.
    importc: "gtk_toggle_tool_button_get_type", libgtk.}
proc newToggleToolButton*(): ToolItem {.
    importc: "gtk_toggle_tool_button_new", libgtk.}
proc newToggleToolButton*(stockId: cstring): ToolItem {.
    importc: "gtk_toggle_tool_button_new_from_stock", libgtk.}
proc setActive*(button: ToggleToolButton;
                                  isActive: Gboolean) {.
    importc: "gtk_toggle_tool_button_set_active", libgtk.}
proc `active=`*(button: ToggleToolButton;
                                  isActive: Gboolean) {.
    importc: "gtk_toggle_tool_button_set_active", libgtk.}
proc getActive*(button: ToggleToolButton): Gboolean {.
    importc: "gtk_toggle_tool_button_get_active", libgtk.}
proc active*(button: ToggleToolButton): Gboolean {.
    importc: "gtk_toggle_tool_button_get_active", libgtk.}

template typeRadioToolButton*(): expr =
  (radioToolButtonGetType())

template radioToolButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRadioToolButton, RadioToolButtonObj))

template radioToolButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeRadioToolButton, RadioToolButtonClassObj))

template isRadioToolButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRadioToolButton))

template isRadioToolButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeRadioToolButton))

template radioToolButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeRadioToolButton, RadioToolButtonClassObj))

type
  Range* =  ptr RangeObj
  RangePtr* = ptr RangeObj
  RangeObj* = object of WidgetObj
    priv106: pointer

  RangeClass* =  ptr RangeClassObj
  RangeClassPtr* = ptr RangeClassObj
  RangeClassObj = object of WidgetClassObj
    sliderDetail*: cstring
    stepperDetail*: cstring
    valueChanged*: proc (range: Range) {.cdecl.}
    adjustBounds*: proc (range: Range; newValue: cdouble) {.cdecl.}
    moveSlider*: proc (range: Range; scroll: ScrollType) {.cdecl.}
    getRangeBorder*: proc (range: Range; border: Border) {.cdecl.}
    changeValue*: proc (range: Range; scroll: ScrollType; newValue: cdouble): Gboolean {.cdecl.}
    gtkReserved1031*: proc () {.cdecl.}
    gtkReserved1032*: proc () {.cdecl.}
    gtkReserved1033*: proc () {.cdecl.}
    gtkReserved1034*: proc () {.cdecl.}

proc radioToolButtonGetType*(): GType {.importc: "gtk_radio_tool_button_get_type",
                                        libgtk.}
proc newRadioToolButton*(group: glib.GSList): ToolItem {.
    importc: "gtk_radio_tool_button_new", libgtk.}
proc newRadioToolButton*(group: glib.GSList; stockId: cstring): ToolItem {.
    importc: "gtk_radio_tool_button_new_from_stock", libgtk.}
proc newFromWidget*(group: RadioToolButton): ToolItem {.
    importc: "gtk_radio_tool_button_new_from_widget", libgtk.}
proc newWithStockFromWidget*(group: RadioToolButton;
    stockId: cstring): ToolItem {.importc: "gtk_radio_tool_button_new_with_stock_from_widget",
                                     libgtk.}
proc getGroup*(button: RadioToolButton): glib.GSList {.
    importc: "gtk_radio_tool_button_get_group", libgtk.}
proc group*(button: RadioToolButton): glib.GSList {.
    importc: "gtk_radio_tool_button_get_group", libgtk.}
proc setGroup*(button: RadioToolButton; group: glib.GSList) {.
    importc: "gtk_radio_tool_button_set_group", libgtk.}
proc `group=`*(button: RadioToolButton; group: glib.GSList) {.
    importc: "gtk_radio_tool_button_set_group", libgtk.}

template typeRange*(): expr =
  (rangeGetType())

template range*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRange, RangeObj))

template rangeClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeRange, RangeClassObj))

template isRange*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRange))

template isRangeClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeRange))

template rangeGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeRange, RangeClassObj))

type
  RecentManager* =  ptr RecentManagerObj
  RecentManagerPtr* = ptr RecentManagerObj
  RecentManagerObj*{.final.} = object of GObjectObj
    priv107: pointer

  RecentManagerClass* =  ptr RecentManagerClassObj
  RecentManagerClassPtr* = ptr RecentManagerClassObj
  RecentManagerClassObj*{.final.} = object of GObjectClassObj
    changed*: proc (manager: RecentManager) {.cdecl.}
    gtkRecent1*: proc () {.cdecl.}
    gtkRecent2*: proc () {.cdecl.}
    gtkRecent3*: proc () {.cdecl.}
    gtkRecent4*: proc () {.cdecl.}

proc rangeGetType*(): GType {.importc: "gtk_range_get_type", libgtk.}
proc setAdjustment*(range: Range; adjustment: Adjustment) {.
    importc: "gtk_range_set_adjustment", libgtk.}
proc `adjustment=`*(range: Range; adjustment: Adjustment) {.
    importc: "gtk_range_set_adjustment", libgtk.}
proc getAdjustment*(range: Range): Adjustment {.
    importc: "gtk_range_get_adjustment", libgtk.}
proc adjustment*(range: Range): Adjustment {.
    importc: "gtk_range_get_adjustment", libgtk.}
proc setInverted*(range: Range; setting: Gboolean) {.
    importc: "gtk_range_set_inverted", libgtk.}
proc `inverted=`*(range: Range; setting: Gboolean) {.
    importc: "gtk_range_set_inverted", libgtk.}
proc getInverted*(range: Range): Gboolean {.
    importc: "gtk_range_get_inverted", libgtk.}
proc inverted*(range: Range): Gboolean {.
    importc: "gtk_range_get_inverted", libgtk.}
proc setFlippable*(range: Range; flippable: Gboolean) {.
    importc: "gtk_range_set_flippable", libgtk.}
proc `flippable=`*(range: Range; flippable: Gboolean) {.
    importc: "gtk_range_set_flippable", libgtk.}
proc getFlippable*(range: Range): Gboolean {.
    importc: "gtk_range_get_flippable", libgtk.}
proc flippable*(range: Range): Gboolean {.
    importc: "gtk_range_get_flippable", libgtk.}
proc setSliderSizeFixed*(range: Range; sizeFixed: Gboolean) {.
    importc: "gtk_range_set_slider_size_fixed", libgtk.}
proc `sliderSizeFixed=`*(range: Range; sizeFixed: Gboolean) {.
    importc: "gtk_range_set_slider_size_fixed", libgtk.}
proc getSliderSizeFixed*(range: Range): Gboolean {.
    importc: "gtk_range_get_slider_size_fixed", libgtk.}
proc sliderSizeFixed*(range: Range): Gboolean {.
    importc: "gtk_range_get_slider_size_fixed", libgtk.}
proc setMinSliderSize*(range: Range; minSize: cint) {.
    importc: "gtk_range_set_min_slider_size", libgtk.}
proc `minSliderSize=`*(range: Range; minSize: cint) {.
    importc: "gtk_range_set_min_slider_size", libgtk.}
proc getMinSliderSize*(range: Range): cint {.
    importc: "gtk_range_get_min_slider_size", libgtk.}
proc minSliderSize*(range: Range): cint {.
    importc: "gtk_range_get_min_slider_size", libgtk.}
proc getRangeRect*(range: Range; rangeRect: var gdk3.RectangleObj) {.
    importc: "gtk_range_get_range_rect", libgtk.}
proc getSliderRange*(range: Range; sliderStart: var cint;
                            sliderEnd: var cint) {.
    importc: "gtk_range_get_slider_range", libgtk.}
proc setLowerStepperSensitivity*(range: Range;
                                        sensitivity: SensitivityType) {.
    importc: "gtk_range_set_lower_stepper_sensitivity", libgtk.}
proc `lowerStepperSensitivity=`*(range: Range;
                                        sensitivity: SensitivityType) {.
    importc: "gtk_range_set_lower_stepper_sensitivity", libgtk.}
proc getLowerStepperSensitivity*(range: Range): SensitivityType {.
    importc: "gtk_range_get_lower_stepper_sensitivity", libgtk.}
proc lowerStepperSensitivity*(range: Range): SensitivityType {.
    importc: "gtk_range_get_lower_stepper_sensitivity", libgtk.}
proc setUpperStepperSensitivity*(range: Range;
                                        sensitivity: SensitivityType) {.
    importc: "gtk_range_set_upper_stepper_sensitivity", libgtk.}
proc `upperStepperSensitivity=`*(range: Range;
                                        sensitivity: SensitivityType) {.
    importc: "gtk_range_set_upper_stepper_sensitivity", libgtk.}
proc getUpperStepperSensitivity*(range: Range): SensitivityType {.
    importc: "gtk_range_get_upper_stepper_sensitivity", libgtk.}
proc upperStepperSensitivity*(range: Range): SensitivityType {.
    importc: "gtk_range_get_upper_stepper_sensitivity", libgtk.}
proc setIncrements*(range: Range; step: cdouble; page: cdouble) {.
    importc: "gtk_range_set_increments", libgtk.}
proc `increments=`*(range: Range; step: cdouble; page: cdouble) {.
    importc: "gtk_range_set_increments", libgtk.}
proc setRange*(range: Range; min: cdouble; max: cdouble) {.
    importc: "gtk_range_set_range", libgtk.}
proc `range=`*(range: Range; min: cdouble; max: cdouble) {.
    importc: "gtk_range_set_range", libgtk.}
proc setValue*(range: Range; value: cdouble) {.
    importc: "gtk_range_set_value", libgtk.}
proc `value=`*(range: Range; value: cdouble) {.
    importc: "gtk_range_set_value", libgtk.}
proc getValue*(range: Range): cdouble {.
    importc: "gtk_range_get_value", libgtk.}
proc value*(range: Range): cdouble {.
    importc: "gtk_range_get_value", libgtk.}
proc setShowFillLevel*(range: Range; showFillLevel: Gboolean) {.
    importc: "gtk_range_set_show_fill_level", libgtk.}
proc `showFillLevel=`*(range: Range; showFillLevel: Gboolean) {.
    importc: "gtk_range_set_show_fill_level", libgtk.}
proc getShowFillLevel*(range: Range): Gboolean {.
    importc: "gtk_range_get_show_fill_level", libgtk.}
proc showFillLevel*(range: Range): Gboolean {.
    importc: "gtk_range_get_show_fill_level", libgtk.}
proc setRestrictToFillLevel*(range: Range;
                                    restrictToFillLevel: Gboolean) {.
    importc: "gtk_range_set_restrict_to_fill_level", libgtk.}
proc `restrictToFillLevel=`*(range: Range;
                                    restrictToFillLevel: Gboolean) {.
    importc: "gtk_range_set_restrict_to_fill_level", libgtk.}
proc getRestrictToFillLevel*(range: Range): Gboolean {.
    importc: "gtk_range_get_restrict_to_fill_level", libgtk.}
proc restrictToFillLevel*(range: Range): Gboolean {.
    importc: "gtk_range_get_restrict_to_fill_level", libgtk.}
proc setFillLevel*(range: Range; fillLevel: cdouble) {.
    importc: "gtk_range_set_fill_level", libgtk.}
proc `fillLevel=`*(range: Range; fillLevel: cdouble) {.
    importc: "gtk_range_set_fill_level", libgtk.}
proc getFillLevel*(range: Range): cdouble {.
    importc: "gtk_range_get_fill_level", libgtk.}
proc fillLevel*(range: Range): cdouble {.
    importc: "gtk_range_get_fill_level", libgtk.}
proc setRoundDigits*(range: Range; roundDigits: cint) {.
    importc: "gtk_range_set_round_digits", libgtk.}
proc `roundDigits=`*(range: Range; roundDigits: cint) {.
    importc: "gtk_range_set_round_digits", libgtk.}
proc getRoundDigits*(range: Range): cint {.
    importc: "gtk_range_get_round_digits", libgtk.}
proc roundDigits*(range: Range): cint {.
    importc: "gtk_range_get_round_digits", libgtk.}

template typeRecentInfo*(): expr =
  (recentInfoGetType())

template typeRecentManager*(): expr =
  (recentManagerGetType())

template recentManager*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRecentManager, RecentManagerObj))

template isRecentManager*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRecentManager))

template recentManagerClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeRecentManager, RecentManagerClassObj))

template isRecentManagerClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeRecentManager))

template recentManagerGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeRecentManager, RecentManagerClassObj))

type
  RecentInfo* =  ptr RecentInfoObj
  RecentInfoPtr* = ptr RecentInfoObj
  RecentInfoObj* = object

type
  RecentData* =  ptr RecentDataObj
  RecentDataPtr* = ptr RecentDataObj
  RecentDataObj* = object
    displayName*: cstring
    description*: cstring
    mimeType*: cstring
    appName*: cstring
    appExec*: cstring
    groups*: cstringArray
    isPrivate*: Gboolean

type
  RecentManagerError* {.size: sizeof(cint), pure.} = enum
    NOT_FOUND, INVALID_URI,
    INVALID_ENCODING,
    NOT_REGISTERED, READ,
    WRITE, UNKNOWN
  RecentFilter* =  ptr RecentFilterObj
  RecentFilterPtr* = ptr RecentFilterObj
  RecentFilterObj* = object

template recentManagerError*(): expr =
  (gtkRecentManagerErrorQuark())

proc recentManagerErrorQuark*(): GQuark {.
    importc: "gtk_recent_manager_error_quark", libgtk.}
proc recentManagerGetType*(): GType {.importc: "gtk_recent_manager_get_type",
                                      libgtk.}
proc newRecentManager*(): RecentManager {.
    importc: "gtk_recent_manager_new", libgtk.}
proc recentManagerGetDefault*(): RecentManager {.
    importc: "gtk_recent_manager_get_default", libgtk.}
proc addItem*(manager: RecentManager; uri: cstring): Gboolean {.
    importc: "gtk_recent_manager_add_item", libgtk.}
proc addFull*(manager: RecentManager; uri: cstring;
                             recentData: RecentData): Gboolean {.
    importc: "gtk_recent_manager_add_full", libgtk.}
proc removeItem*(manager: RecentManager; uri: cstring;
                                error: var glib.GError): Gboolean {.
    importc: "gtk_recent_manager_remove_item", libgtk.}
proc lookupItem*(manager: RecentManager; uri: cstring;
                                error: var glib.GError): RecentInfo {.
    importc: "gtk_recent_manager_lookup_item", libgtk.}
proc hasItem*(manager: RecentManager; uri: cstring): Gboolean {.
    importc: "gtk_recent_manager_has_item", libgtk.}
proc moveItem*(manager: RecentManager; uri: cstring;
                              newUri: cstring; error: var glib.GError): Gboolean {.
    importc: "gtk_recent_manager_move_item", libgtk.}
proc getItems*(manager: RecentManager): glib.GList {.
    importc: "gtk_recent_manager_get_items", libgtk.}
proc items*(manager: RecentManager): glib.GList {.
    importc: "gtk_recent_manager_get_items", libgtk.}
proc purgeItems*(manager: RecentManager;
                                error: var glib.GError): cint {.
    importc: "gtk_recent_manager_purge_items", libgtk.}
proc recentInfoGetType*(): GType {.importc: "gtk_recent_info_get_type",
                                   libgtk.}
proc `ref`*(info: RecentInfo): RecentInfo {.
    importc: "gtk_recent_info_ref", libgtk.}
proc unref*(info: RecentInfo) {.
    importc: "gtk_recent_info_unref", libgtk.}
proc getUri*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_uri", libgtk.}
proc uri*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_uri", libgtk.}
proc getDisplayName*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_display_name", libgtk.}
proc displayName*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_display_name", libgtk.}
proc getDescription*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_description", libgtk.}
proc description*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_description", libgtk.}
proc getMimeType*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_mime_type", libgtk.}
proc mimeType*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_mime_type", libgtk.}
proc getAdded*(info: RecentInfo): Time {.
    importc: "gtk_recent_info_get_added", libgtk.}
proc added*(info: RecentInfo): Time {.
    importc: "gtk_recent_info_get_added", libgtk.}
proc getModified*(info: RecentInfo): Time {.
    importc: "gtk_recent_info_get_modified", libgtk.}
proc modified*(info: RecentInfo): Time {.
    importc: "gtk_recent_info_get_modified", libgtk.}
proc getVisited*(info: RecentInfo): Time {.
    importc: "gtk_recent_info_get_visited", libgtk.}
proc visited*(info: RecentInfo): Time {.
    importc: "gtk_recent_info_get_visited", libgtk.}
proc getPrivateHint*(info: RecentInfo): Gboolean {.
    importc: "gtk_recent_info_get_private_hint", libgtk.}
proc privateHint*(info: RecentInfo): Gboolean {.
    importc: "gtk_recent_info_get_private_hint", libgtk.}
proc getApplicationInfo*(info: RecentInfo; appName: cstring;
                                     appExec: cstringArray; count: var cuint;
                                     time: ptr Time): Gboolean {.
    importc: "gtk_recent_info_get_application_info", libgtk.}
proc applicationInfo*(info: RecentInfo; appName: cstring;
                                     appExec: cstringArray; count: var cuint;
                                     time: ptr Time): Gboolean {.
    importc: "gtk_recent_info_get_application_info", libgtk.}
proc createAppInfo*(info: RecentInfo; appName: cstring;
                                error: var glib.GError): gio.GAppInfo {.
    importc: "gtk_recent_info_create_app_info", libgtk.}
proc getApplications*(info: RecentInfo; length: ptr Gsize): cstringArray {.
    importc: "gtk_recent_info_get_applications", libgtk.}
proc applications*(info: RecentInfo; length: ptr Gsize): cstringArray {.
    importc: "gtk_recent_info_get_applications", libgtk.}
proc lastApplication*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_last_application", libgtk.}
proc hasApplication*(info: RecentInfo; appName: cstring): Gboolean {.
    importc: "gtk_recent_info_has_application", libgtk.}
proc getGroups*(info: RecentInfo; length: ptr Gsize): cstringArray {.
    importc: "gtk_recent_info_get_groups", libgtk.}
proc groups*(info: RecentInfo; length: ptr Gsize): cstringArray {.
    importc: "gtk_recent_info_get_groups", libgtk.}
proc hasGroup*(info: RecentInfo; groupName: cstring): Gboolean {.
    importc: "gtk_recent_info_has_group", libgtk.}
proc getIcon*(info: RecentInfo; size: cint): GdkPixbuf {.
    importc: "gtk_recent_info_get_icon", libgtk.}
proc icon*(info: RecentInfo; size: cint): GdkPixbuf {.
    importc: "gtk_recent_info_get_icon", libgtk.}
proc getGicon*(info: RecentInfo): gio.GIcon {.
    importc: "gtk_recent_info_get_gicon", libgtk.}
proc gicon*(info: RecentInfo): gio.GIcon {.
    importc: "gtk_recent_info_get_gicon", libgtk.}
proc getShortName*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_short_name", libgtk.}
proc shortName*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_short_name", libgtk.}
proc getUriDisplay*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_uri_display", libgtk.}
proc uriDisplay*(info: RecentInfo): cstring {.
    importc: "gtk_recent_info_get_uri_display", libgtk.}
proc getAge*(info: RecentInfo): cint {.
    importc: "gtk_recent_info_get_age", libgtk.}
proc age*(info: RecentInfo): cint {.
    importc: "gtk_recent_info_get_age", libgtk.}
proc isLocal*(info: RecentInfo): Gboolean {.
    importc: "gtk_recent_info_is_local", libgtk.}
proc exists*(info: RecentInfo): Gboolean {.
    importc: "gtk_recent_info_exists", libgtk.}
proc match*(infoA: RecentInfo; infoB: RecentInfo): Gboolean {.
    importc: "gtk_recent_info_match", libgtk.}

discard """ proc "recentManagerSync*() {.importc: "_gtk_recent_manager_sync", libgtk.}"""

template typeRecentFilter*(): expr =
  (recentFilterGetType())

template recentFilter*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRecentFilter, RecentFilterObj))

template isRecentFilter*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRecentFilter))

type
  RecentFilterFlags* {.size: sizeof(cint), pure.} = enum
    URI = 1 shl 0, DISPLAY_NAME = 1 shl 1,
    MIME_TYPE = 1 shl 2, APPLICATION = 1 shl 3,
    GROUP = 1 shl 4, AGE = 1 shl 5

type
  RecentFilterInfo* =  ptr RecentFilterInfoObj
  RecentFilterInfoPtr* = ptr RecentFilterInfoObj
  RecentFilterInfoObj* = object
    contains*: RecentFilterFlags
    uri*: cstring
    displayName*: cstring
    mimeType*: cstring
    applications*: cstringArray
    groups*: cstringArray
    age*: cint

  RecentChooser* =  ptr RecentChooserObj
  RecentChooserPtr* = ptr RecentChooserObj
  RecentChooserObj* = object

type
  RecentFilterFunc* = proc (filterInfo: RecentFilterInfo; userData: Gpointer): Gboolean {.cdecl.}

type
  RecentSortType* {.size: sizeof(cint), pure.} = enum
    NONE = 0, MRU, LRU,
    CUSTOM
  RecentSortFunc* = proc (a: RecentInfo; b: RecentInfo;
                          userData: Gpointer): cint {.cdecl.}
type
  RecentChooserIface* =  ptr RecentChooserIfaceObj
  RecentChooserIfacePtr* = ptr RecentChooserIfaceObj
  RecentChooserIfaceObj* = object of gobject.GTypeInterfaceObj
    setCurrentUri*: proc (chooser: RecentChooser; uri: cstring;
                        error: var glib.GError): Gboolean {.cdecl.}
    getCurrentUri*: proc (chooser: RecentChooser): cstring {.cdecl.}
    selectUri*: proc (chooser: RecentChooser; uri: cstring;
                    error: var glib.GError): Gboolean {.cdecl.}
    unselectUri*: proc (chooser: RecentChooser; uri: cstring) {.cdecl.}
    selectAll*: proc (chooser: RecentChooser) {.cdecl.}
    unselectAll*: proc (chooser: RecentChooser) {.cdecl.}
    getItems*: proc (chooser: RecentChooser): glib.GList {.cdecl.}
    getRecentManager*: proc (chooser: RecentChooser): RecentManager {.cdecl.}
    addFilter*: proc (chooser: RecentChooser; filter: RecentFilter) {.cdecl.}
    removeFilter*: proc (chooser: RecentChooser; filter: RecentFilter) {.cdecl.}
    listFilters*: proc (chooser: RecentChooser): glib.GSList {.cdecl.}
    setSortFunc*: proc (chooser: RecentChooser; sortFunc: RecentSortFunc;
                      sortData: Gpointer; dataDestroy: GDestroyNotify) {.cdecl.}
    itemActivated*: proc (chooser: RecentChooser) {.cdecl.}
    selectionChanged*: proc (chooser: RecentChooser) {.cdecl.}

proc recentFilterGetType*(): GType {.importc: "gtk_recent_filter_get_type",
                                     libgtk.}
proc newRecentFilter*(): RecentFilter {.importc: "gtk_recent_filter_new",
    libgtk.}
proc setName*(filter: RecentFilter; name: cstring) {.
    importc: "gtk_recent_filter_set_name", libgtk.}
proc `name=`*(filter: RecentFilter; name: cstring) {.
    importc: "gtk_recent_filter_set_name", libgtk.}
proc getName*(filter: RecentFilter): cstring {.
    importc: "gtk_recent_filter_get_name", libgtk.}
proc name*(filter: RecentFilter): cstring {.
    importc: "gtk_recent_filter_get_name", libgtk.}
proc addMimeType*(filter: RecentFilter; mimeType: cstring) {.
    importc: "gtk_recent_filter_add_mime_type", libgtk.}
proc addPattern*(filter: RecentFilter; pattern: cstring) {.
    importc: "gtk_recent_filter_add_pattern", libgtk.}
proc addPixbufFormats*(filter: RecentFilter) {.
    importc: "gtk_recent_filter_add_pixbuf_formats", libgtk.}
proc addApplication*(filter: RecentFilter;
                                   application: cstring) {.
    importc: "gtk_recent_filter_add_application", libgtk.}
proc addGroup*(filter: RecentFilter; group: cstring) {.
    importc: "gtk_recent_filter_add_group", libgtk.}
proc addAge*(filter: RecentFilter; days: cint) {.
    importc: "gtk_recent_filter_add_age", libgtk.}
proc addCustom*(filter: RecentFilter;
                              needed: RecentFilterFlags;
                              `func`: RecentFilterFunc; data: Gpointer;
                              dataDestroy: GDestroyNotify) {.
    importc: "gtk_recent_filter_add_custom", libgtk.}
proc getNeeded*(filter: RecentFilter): RecentFilterFlags {.
    importc: "gtk_recent_filter_get_needed", libgtk.}
proc needed*(filter: RecentFilter): RecentFilterFlags {.
    importc: "gtk_recent_filter_get_needed", libgtk.}
proc filter*(filter: RecentFilter;
                           filterInfo: RecentFilterInfo): Gboolean {.
    importc: "gtk_recent_filter_filter", libgtk.}

template typeRecentChooser*(): expr =
  (recentChooserGetType())

template recentChooser*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRecentChooser, RecentChooserObj))

template isRecentChooser*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRecentChooser))

template recentChooserGetIface*(inst: expr): expr =
  (gTypeInstanceGetInterface(inst, typeRecentChooser, RecentChooserIfaceObj))

template recentChooserError*(): expr =
  (gtkRecentChooserErrorQuark())

type
  RecentChooserError* {.size: sizeof(cint), pure.} = enum
    NOT_FOUND, INVALID_URI

proc recentChooserErrorQuark*(): GQuark {.
    importc: "gtk_recent_chooser_error_quark", libgtk.}

type
  RecentChooserDialog* =  ptr RecentChooserDialogObj
  RecentChooserDialogPtr* = ptr RecentChooserDialogObj
  RecentChooserDialogObj*{.final.} = object of DialogObj
    priv108: pointer

  RecentChooserDialogClass* =  ptr RecentChooserDialogClassObj
  RecentChooserDialogClassPtr* = ptr RecentChooserDialogClassObj
  RecentChooserDialogClassObj*{.final.} = object of DialogClassObj
    gtkReserved1041*: proc () {.cdecl.}
    gtkReserved1042*: proc () {.cdecl.}
    gtkReserved1043*: proc () {.cdecl.}
    gtkReserved1044*: proc () {.cdecl.}

proc recentChooserGetType*(): GType {.importc: "gtk_recent_chooser_get_type",
                                      libgtk.}

proc setShowPrivate*(chooser: RecentChooser;
                                    showPrivate: Gboolean) {.
    importc: "gtk_recent_chooser_set_show_private", libgtk.}

proc `showPrivate=`*(chooser: RecentChooser;
                                    showPrivate: Gboolean) {.
    importc: "gtk_recent_chooser_set_show_private", libgtk.}
proc getShowPrivate*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_show_private", libgtk.}
proc showPrivate*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_show_private", libgtk.}
proc setShowNotFound*(chooser: RecentChooser;
                                     showNotFound: Gboolean) {.
    importc: "gtk_recent_chooser_set_show_not_found", libgtk.}
proc `showNotFound=`*(chooser: RecentChooser;
                                     showNotFound: Gboolean) {.
    importc: "gtk_recent_chooser_set_show_not_found", libgtk.}
proc getShowNotFound*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_show_not_found", libgtk.}
proc showNotFound*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_show_not_found", libgtk.}
proc setSelectMultiple*(chooser: RecentChooser;
                                       selectMultiple: Gboolean) {.
    importc: "gtk_recent_chooser_set_select_multiple", libgtk.}
proc `selectMultiple=`*(chooser: RecentChooser;
                                       selectMultiple: Gboolean) {.
    importc: "gtk_recent_chooser_set_select_multiple", libgtk.}
proc getSelectMultiple*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_select_multiple", libgtk.}
proc selectMultiple*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_select_multiple", libgtk.}
proc setLimit*(chooser: RecentChooser; limit: cint) {.
    importc: "gtk_recent_chooser_set_limit", libgtk.}
proc `limit=`*(chooser: RecentChooser; limit: cint) {.
    importc: "gtk_recent_chooser_set_limit", libgtk.}
proc getLimit*(chooser: RecentChooser): cint {.
    importc: "gtk_recent_chooser_get_limit", libgtk.}
proc limit*(chooser: RecentChooser): cint {.
    importc: "gtk_recent_chooser_get_limit", libgtk.}
proc setLocalOnly*(chooser: RecentChooser;
                                  localOnly: Gboolean) {.
    importc: "gtk_recent_chooser_set_local_only", libgtk.}
proc `localOnly=`*(chooser: RecentChooser;
                                  localOnly: Gboolean) {.
    importc: "gtk_recent_chooser_set_local_only", libgtk.}
proc getLocalOnly*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_local_only", libgtk.}
proc localOnly*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_local_only", libgtk.}
proc setShowTips*(chooser: RecentChooser; showTips: Gboolean) {.
    importc: "gtk_recent_chooser_set_show_tips", libgtk.}
proc `showTips=`*(chooser: RecentChooser; showTips: Gboolean) {.
    importc: "gtk_recent_chooser_set_show_tips", libgtk.}
proc getShowTips*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_show_tips", libgtk.}
proc showTips*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_show_tips", libgtk.}
proc setShowIcons*(chooser: RecentChooser;
                                  showIcons: Gboolean) {.
    importc: "gtk_recent_chooser_set_show_icons", libgtk.}
proc `showIcons=`*(chooser: RecentChooser;
                                  showIcons: Gboolean) {.
    importc: "gtk_recent_chooser_set_show_icons", libgtk.}
proc getShowIcons*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_show_icons", libgtk.}
proc showIcons*(chooser: RecentChooser): Gboolean {.
    importc: "gtk_recent_chooser_get_show_icons", libgtk.}
proc setSortType*(chooser: RecentChooser;
                                 sortType: RecentSortType) {.
    importc: "gtk_recent_chooser_set_sort_type", libgtk.}
proc `sortType=`*(chooser: RecentChooser;
                                 sortType: RecentSortType) {.
    importc: "gtk_recent_chooser_set_sort_type", libgtk.}
proc getSortType*(chooser: RecentChooser): RecentSortType {.
    importc: "gtk_recent_chooser_get_sort_type", libgtk.}
proc sortType*(chooser: RecentChooser): RecentSortType {.
    importc: "gtk_recent_chooser_get_sort_type", libgtk.}
proc setSortFunc*(chooser: RecentChooser;
                                 sortFunc: RecentSortFunc; sortData: Gpointer;
                                 dataDestroy: GDestroyNotify) {.
    importc: "gtk_recent_chooser_set_sort_func", libgtk.}
proc `sortFunc=`*(chooser: RecentChooser;
                                 sortFunc: RecentSortFunc; sortData: Gpointer;
                                 dataDestroy: GDestroyNotify) {.
    importc: "gtk_recent_chooser_set_sort_func", libgtk.}

proc setCurrentUri*(chooser: RecentChooser; uri: cstring;
                                   error: var glib.GError): Gboolean {.
    importc: "gtk_recent_chooser_set_current_uri", libgtk.}
proc getCurrentUri*(chooser: RecentChooser): cstring {.
    importc: "gtk_recent_chooser_get_current_uri", libgtk.}
proc currentUri*(chooser: RecentChooser): cstring {.
    importc: "gtk_recent_chooser_get_current_uri", libgtk.}
proc getCurrentItem*(chooser: RecentChooser): RecentInfo {.
    importc: "gtk_recent_chooser_get_current_item", libgtk.}
proc currentItem*(chooser: RecentChooser): RecentInfo {.
    importc: "gtk_recent_chooser_get_current_item", libgtk.}
proc selectUri*(chooser: RecentChooser; uri: cstring;
                               error: var glib.GError): Gboolean {.
    importc: "gtk_recent_chooser_select_uri", libgtk.}
proc unselectUri*(chooser: RecentChooser; uri: cstring) {.
    importc: "gtk_recent_chooser_unselect_uri", libgtk.}
proc selectAll*(chooser: RecentChooser) {.
    importc: "gtk_recent_chooser_select_all", libgtk.}
proc unselectAll*(chooser: RecentChooser) {.
    importc: "gtk_recent_chooser_unselect_all", libgtk.}
proc getItems*(chooser: RecentChooser): glib.GList {.
    importc: "gtk_recent_chooser_get_items", libgtk.}
proc items*(chooser: RecentChooser): glib.GList {.
    importc: "gtk_recent_chooser_get_items", libgtk.}
proc getUris*(chooser: RecentChooser; length: ptr Gsize): cstringArray {.
    importc: "gtk_recent_chooser_get_uris", libgtk.}
proc uris*(chooser: RecentChooser; length: ptr Gsize): cstringArray {.
    importc: "gtk_recent_chooser_get_uris", libgtk.}

proc addFilter*(chooser: RecentChooser;
                               filter: RecentFilter) {.
    importc: "gtk_recent_chooser_add_filter", libgtk.}
proc removeFilter*(chooser: RecentChooser;
                                  filter: RecentFilter) {.
    importc: "gtk_recent_chooser_remove_filter", libgtk.}
proc listFilters*(chooser: RecentChooser): glib.GSList {.
    importc: "gtk_recent_chooser_list_filters", libgtk.}
proc setFilter*(chooser: RecentChooser;
                               filter: RecentFilter) {.
    importc: "gtk_recent_chooser_set_filter", libgtk.}
proc `filter=`*(chooser: RecentChooser;
                               filter: RecentFilter) {.
    importc: "gtk_recent_chooser_set_filter", libgtk.}
proc getFilter*(chooser: RecentChooser): RecentFilter {.
    importc: "gtk_recent_chooser_get_filter", libgtk.}
proc filter*(chooser: RecentChooser): RecentFilter {.
    importc: "gtk_recent_chooser_get_filter", libgtk.}

template typeRecentChooserDialog*(): expr =
  (recentChooserDialogGetType())

template recentChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRecentChooserDialog, RecentChooserDialogObj))

template isRecentChooserDialog*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRecentChooserDialog))

template recentChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeRecentChooserDialog, RecentChooserDialogClassObj))

template isRecentChooserDialogClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeRecentChooserDialog))

template recentChooserDialogGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeRecentChooserDialog, RecentChooserDialogClassObj))

type
  RecentChooserMenu* =  ptr RecentChooserMenuObj
  RecentChooserMenuPtr* = ptr RecentChooserMenuObj
  RecentChooserMenuObj*{.final.} = object of MenuObj
    priv109: pointer

  RecentChooserMenuClass* =  ptr RecentChooserMenuClassObj
  RecentChooserMenuClassPtr* = ptr RecentChooserMenuClassObj
  RecentChooserMenuClassObj*{.final.} = object of MenuClassObj
    gtkRecent1*: proc () {.cdecl.}
    gtkRecent2*: proc () {.cdecl.}
    gtkRecent3*: proc () {.cdecl.}
    gtkRecent4*: proc () {.cdecl.}

proc recentChooserDialogGetType*(): GType {.
    importc: "gtk_recent_chooser_dialog_get_type", libgtk.}
proc newRecentChooserDialog*(title: cstring; parent: Window;
                               firstButtonText: cstring): RecentChooserDialog {.varargs,
    importc: "gtk_recent_chooser_dialog_new", libgtk.}
proc newRecentChooserDialog*(title: cstring; parent: Window;
    manager: RecentManager; firstButtonText: cstring): RecentChooserDialog {.varargs,
    importc: "gtk_recent_chooser_dialog_new_for_manager", libgtk.}

template typeRecentChooserMenu*(): expr =
  (recentChooserMenuGetType())

template recentChooserMenu*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRecentChooserMenu, RecentChooserMenuObj))

template isRecentChooserMenu*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRecentChooserMenu))

template recentChooserMenuClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeRecentChooserMenu, RecentChooserMenuClassObj))

template isRecentChooserMenuClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeRecentChooserMenu))

template recentChooserMenuGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeRecentChooserMenu, RecentChooserMenuClassObj))

type
  RecentChooserWidget* =  ptr RecentChooserWidgetObj
  RecentChooserWidgetPtr* = ptr RecentChooserWidgetObj
  RecentChooserWidgetObj*{.final.} = object of BoxObj
    priv110: pointer

  RecentChooserWidgetClass* =  ptr RecentChooserWidgetClassObj
  RecentChooserWidgetClassPtr* = ptr RecentChooserWidgetClassObj
  RecentChooserWidgetClassObj*{.final.} = object of BoxClassObj
    gtkReserved1051*: proc () {.cdecl.}
    gtkReserved1052*: proc () {.cdecl.}
    gtkReserved1053*: proc () {.cdecl.}
    gtkReserved1054*: proc () {.cdecl.}

proc recentChooserMenuGetType*(): GType {.
    importc: "gtk_recent_chooser_menu_get_type", libgtk.}
proc newRecentChooserMenu*(): RecentChooserMenu {.
    importc: "gtk_recent_chooser_menu_new", libgtk.}
proc newRecentChooserMenu*(manager: RecentManager): RecentChooserMenu {.
    importc: "gtk_recent_chooser_menu_new_for_manager", libgtk.}
proc getShowNumbers*(menu: RecentChooserMenu): Gboolean {.
    importc: "gtk_recent_chooser_menu_get_show_numbers", libgtk.}
proc showNumbers*(menu: RecentChooserMenu): Gboolean {.
    importc: "gtk_recent_chooser_menu_get_show_numbers", libgtk.}
proc setShowNumbers*(menu: RecentChooserMenu;
                                        showNumbers: Gboolean) {.
    importc: "gtk_recent_chooser_menu_set_show_numbers", libgtk.}
proc `showNumbers=`*(menu: RecentChooserMenu;
                                        showNumbers: Gboolean) {.
    importc: "gtk_recent_chooser_menu_set_show_numbers", libgtk.}

template typeRecentChooserWidget*(): expr =
  (recentChooserWidgetGetType())

template recentChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRecentChooserWidget, RecentChooserWidgetObj))

template isRecentChooserWidget*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRecentChooserWidget))

template recentChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeRecentChooserWidget, RecentChooserWidgetClassObj))

template isRecentChooserWidgetClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeRecentChooserWidget))

template recentChooserWidgetGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeRecentChooserWidget, RecentChooserWidgetClassObj))

proc recentChooserWidgetGetType*(): GType {.
    importc: "gtk_recent_chooser_widget_get_type", libgtk.}
proc newRecentChooserWidget*(): RecentChooserWidget {.
    importc: "gtk_recent_chooser_widget_new", libgtk.}
proc newRecentChooserWidget*(manager: RecentManager): RecentChooserWidget {.
    importc: "gtk_recent_chooser_widget_new_for_manager", libgtk.}

proc renderCheck*(context: StyleContext; cr: cairo.Context; x: cdouble;
                    y: cdouble; width: cdouble; height: cdouble) {.
    importc: "gtk_render_check", libgtk.}
proc renderOption*(context: StyleContext; cr: cairo.Context; x: cdouble;
                     y: cdouble; width: cdouble; height: cdouble) {.
    importc: "gtk_render_option", libgtk.}
proc renderArrow*(context: StyleContext; cr: cairo.Context; angle: cdouble;
                    x: cdouble; y: cdouble; size: cdouble) {.
    importc: "gtk_render_arrow", libgtk.}
proc renderBackground*(context: StyleContext; cr: cairo.Context; x: cdouble;
                         y: cdouble; width: cdouble; height: cdouble) {.
    importc: "gtk_render_background", libgtk.}
proc renderBackgroundGetClip*(context: StyleContext; x: cdouble; y: cdouble;
                                width: cdouble; height: cdouble;
                                outClip: gdk3.Rectangle) {.
    importc: "gtk_render_background_get_clip", libgtk.}
proc renderFrame*(context: StyleContext; cr: cairo.Context; x: cdouble;
                    y: cdouble; width: cdouble; height: cdouble) {.
    importc: "gtk_render_frame", libgtk.}
proc renderExpander*(context: StyleContext; cr: cairo.Context; x: cdouble;
                       y: cdouble; width: cdouble; height: cdouble) {.
    importc: "gtk_render_expander", libgtk.}
proc renderFocus*(context: StyleContext; cr: cairo.Context; x: cdouble;
                    y: cdouble; width: cdouble; height: cdouble) {.
    importc: "gtk_render_focus", libgtk.}
proc renderLayout*(context: StyleContext; cr: cairo.Context; x: cdouble;
                     y: cdouble; layout: pango.Layout) {.
    importc: "gtk_render_layout", libgtk.}
proc renderLine*(context: StyleContext; cr: cairo.Context; x0: cdouble;
                   y0: cdouble; x1: cdouble; y1: cdouble) {.
    importc: "gtk_render_line", libgtk.}
proc renderSlider*(context: StyleContext; cr: cairo.Context; x: cdouble;
                     y: cdouble; width: cdouble; height: cdouble;
                     orientation: Orientation) {.importc: "gtk_render_slider",
    libgtk.}
proc renderFrameGap*(context: StyleContext; cr: cairo.Context; x: cdouble;
                       y: cdouble; width: cdouble; height: cdouble;
                       gapSide: PositionType; xy0Gap: cdouble; xy1Gap: cdouble) {.
    importc: "gtk_render_frame_gap", libgtk.}
proc renderExtension*(context: StyleContext; cr: cairo.Context; x: cdouble;
                        y: cdouble; width: cdouble; height: cdouble;
                        gapSide: PositionType) {.
    importc: "gtk_render_extension", libgtk.}
proc renderHandle*(context: StyleContext; cr: cairo.Context; x: cdouble;
                     y: cdouble; width: cdouble; height: cdouble) {.
    importc: "gtk_render_handle", libgtk.}
proc renderActivity*(context: StyleContext; cr: cairo.Context; x: cdouble;
                       y: cdouble; width: cdouble; height: cdouble) {.
    importc: "gtk_render_activity", libgtk.}
proc renderIconPixbuf*(context: StyleContext; source: IconSource;
                         size: IconSize): GdkPixbuf {.
    importc: "gtk_render_icon_pixbuf", libgtk.}
proc renderIcon*(context: StyleContext; cr: cairo.Context;
                   pixbuf: GdkPixbuf; x: cdouble; y: cdouble) {.
    importc: "gtk_render_icon", libgtk.}
proc renderIconSurface*(context: StyleContext; cr: cairo.Context;
                          surface: cairo.Surface; x: cdouble; y: cdouble) {.
    importc: "gtk_render_icon_surface", libgtk.}

template typeRevealer*(): expr =
  (revealerGetType())

template revealer*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeRevealer, RevealerObj))

template revealerClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeRevealer, RevealerClassObj))

template isRevealer*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeRevealer))

template isRevealerClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeRevealer))

template revealerGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeRevealer, RevealerClassObj))

type
  RevealerTransitionType* {.size: sizeof(cint), pure.} = enum
    NONE, CROSSFADE,
    SLIDE_RIGHT,
    SLIDE_LEFT,
    SLIDE_UP,
    SLIDE_DOWN

type
  Revealer* =  ptr RevealerObj
  RevealerPtr* = ptr RevealerObj
  RevealerObj*{.final.} = object of BinObj

type
  RevealerClass* =  ptr RevealerClassObj
  RevealerClassPtr* = ptr RevealerClassObj
  RevealerClassObj*{.final.} = object of BinClassObj

  Scale* =  ptr ScaleObj
  ScalePtr* = ptr ScaleObj
  ScaleObj* = object of RangeObj
    priv111: pointer

  ScaleClass* =  ptr ScaleClassObj
  ScaleClassPtr* = ptr ScaleClassObj
  ScaleClassObj = object of RangeClassObj
    formatValue*: proc (scale: Scale; value: cdouble): cstring {.cdecl.}
    drawValue*: proc (scale: Scale) {.cdecl.}
    getLayoutOffsets*: proc (scale: Scale; x: var cint; y: var cint) {.cdecl.}
    gtkReserved1061*: proc () {.cdecl.}
    gtkReserved1062*: proc () {.cdecl.}
    gtkReserved1063*: proc () {.cdecl.}
    gtkReserved1064*: proc () {.cdecl.}

proc revealerGetType*(): GType {.importc: "gtk_revealer_get_type", libgtk.}
proc newRevealer*(): Revealer {.importc: "gtk_revealer_new", libgtk.}
proc getRevealChild*(revealer: Revealer): Gboolean {.
    importc: "gtk_revealer_get_reveal_child", libgtk.}
proc revealChild*(revealer: Revealer): Gboolean {.
    importc: "gtk_revealer_get_reveal_child", libgtk.}
proc setRevealChild*(revealer: Revealer; revealChild: Gboolean) {.
    importc: "gtk_revealer_set_reveal_child", libgtk.}
proc `revealChild=`*(revealer: Revealer; revealChild: Gboolean) {.
    importc: "gtk_revealer_set_reveal_child", libgtk.}
proc getChildRevealed*(revealer: Revealer): Gboolean {.
    importc: "gtk_revealer_get_child_revealed", libgtk.}
proc childRevealed*(revealer: Revealer): Gboolean {.
    importc: "gtk_revealer_get_child_revealed", libgtk.}
proc getTransitionDuration*(revealer: Revealer): cuint {.
    importc: "gtk_revealer_get_transition_duration", libgtk.}
proc transitionDuration*(revealer: Revealer): cuint {.
    importc: "gtk_revealer_get_transition_duration", libgtk.}
proc setTransitionDuration*(revealer: Revealer; duration: cuint) {.
    importc: "gtk_revealer_set_transition_duration", libgtk.}
proc `transitionDuration=`*(revealer: Revealer; duration: cuint) {.
    importc: "gtk_revealer_set_transition_duration", libgtk.}
proc setTransitionType*(revealer: Revealer;
                                  transition: RevealerTransitionType) {.
    importc: "gtk_revealer_set_transition_type", libgtk.}
proc `transitionType=`*(revealer: Revealer;
                                  transition: RevealerTransitionType) {.
    importc: "gtk_revealer_set_transition_type", libgtk.}
proc getTransitionType*(revealer: Revealer): RevealerTransitionType {.
    importc: "gtk_revealer_get_transition_type", libgtk.}
proc transitionType*(revealer: Revealer): RevealerTransitionType {.
    importc: "gtk_revealer_get_transition_type", libgtk.}

template typeScale*(): expr =
  (scaleGetType())

template scale*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeScale, ScaleObj))

template scaleClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeScale, ScaleClassObj))

template isScale*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeScale))

template isScaleClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeScale))

template scaleGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeScale, ScaleClassObj))

type
  ScaleButton* =  ptr ScaleButtonObj
  ScaleButtonPtr* = ptr ScaleButtonObj
  ScaleButtonObj = object of ButtonObj
    priv112: pointer

  ScaleButtonClass* =  ptr ScaleButtonClassObj
  ScaleButtonClassPtr* = ptr ScaleButtonClassObj
  ScaleButtonClassObj = object of ButtonClassObj
    valueChanged*: proc (button: ScaleButton; value: cdouble) {.cdecl.}
    gtkReserved1071*: proc () {.cdecl.}
    gtkReserved1072*: proc () {.cdecl.}
    gtkReserved1073*: proc () {.cdecl.}
    gtkReserved1074*: proc () {.cdecl.}

proc scaleGetType*(): GType {.importc: "gtk_scale_get_type", libgtk.}
proc newScale*(orientation: Orientation; adjustment: Adjustment): Scale {.
    importc: "gtk_scale_new", libgtk.}
proc setDigits*(scale: Scale; digits: cint) {.
    importc: "gtk_scale_set_digits", libgtk.}
proc `digits=`*(scale: Scale; digits: cint) {.
    importc: "gtk_scale_set_digits", libgtk.}
proc getDigits*(scale: Scale): cint {.importc: "gtk_scale_get_digits",
    libgtk.}
proc digits*(scale: Scale): cint {.importc: "gtk_scale_get_digits",
    libgtk.}
proc setDrawValue*(scale: Scale; drawValue: Gboolean) {.
    importc: "gtk_scale_set_draw_value", libgtk.}
proc `drawValue=`*(scale: Scale; drawValue: Gboolean) {.
    importc: "gtk_scale_set_draw_value", libgtk.}
proc getDrawValue*(scale: Scale): Gboolean {.
    importc: "gtk_scale_get_draw_value", libgtk.}
proc drawValue*(scale: Scale): Gboolean {.
    importc: "gtk_scale_get_draw_value", libgtk.}
proc setHasOrigin*(scale: Scale; hasOrigin: Gboolean) {.
    importc: "gtk_scale_set_has_origin", libgtk.}
proc `hasOrigin=`*(scale: Scale; hasOrigin: Gboolean) {.
    importc: "gtk_scale_set_has_origin", libgtk.}
proc getHasOrigin*(scale: Scale): Gboolean {.
    importc: "gtk_scale_get_has_origin", libgtk.}
proc hasOrigin*(scale: Scale): Gboolean {.
    importc: "gtk_scale_get_has_origin", libgtk.}
proc setValuePos*(scale: Scale; pos: PositionType) {.
    importc: "gtk_scale_set_value_pos", libgtk.}
proc `valuePos=`*(scale: Scale; pos: PositionType) {.
    importc: "gtk_scale_set_value_pos", libgtk.}
proc getValuePos*(scale: Scale): PositionType {.
    importc: "gtk_scale_get_value_pos", libgtk.}
proc valuePos*(scale: Scale): PositionType {.
    importc: "gtk_scale_get_value_pos", libgtk.}
proc getLayout*(scale: Scale): pango.Layout {.
    importc: "gtk_scale_get_layout", libgtk.}
proc layout*(scale: Scale): pango.Layout {.
    importc: "gtk_scale_get_layout", libgtk.}
proc getLayoutOffsets*(scale: Scale; x: var cint; y: var cint) {.
    importc: "gtk_scale_get_layout_offsets", libgtk.}
proc addMark*(scale: Scale; value: cdouble; position: PositionType;
                     markup: cstring) {.importc: "gtk_scale_add_mark", libgtk.}
proc clearMarks*(scale: Scale) {.importc: "gtk_scale_clear_marks",
    libgtk.}

template typeScaleButton*(): expr =
  (scaleButtonGetType())

template scaleButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeScaleButton, ScaleButtonObj))

template scaleButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeScaleButton, ScaleButtonClassObj))

template isScaleButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeScaleButton))

template isScaleButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeScaleButton))

template scaleButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeScaleButton, ScaleButtonClassObj))

type
  Scrollable* =  ptr ScrollableObj
  ScrollablePtr* = ptr ScrollableObj
  ScrollableObj* = object

type
  ScrollableInterface* =  ptr ScrollableInterfaceObj
  ScrollableInterfacePtr* = ptr ScrollableInterfaceObj
  ScrollableInterfaceObj* = object of gobject.GTypeInterfaceObj
    getBorder*: proc (scrollable: Scrollable; border: Border): Gboolean {.cdecl.}

proc scaleButtonGetType*(): GType {.importc: "gtk_scale_button_get_type",
                                    libgtk.}
proc newScaleButton*(size: IconSize; min: cdouble; max: cdouble; step: cdouble;
                       icons: cstringArray): ScaleButton {.
    importc: "gtk_scale_button_new", libgtk.}
proc setIcons*(button: ScaleButton; icons: cstringArray) {.
    importc: "gtk_scale_button_set_icons", libgtk.}
proc `icons=`*(button: ScaleButton; icons: cstringArray) {.
    importc: "gtk_scale_button_set_icons", libgtk.}
proc getValue*(button: ScaleButton): cdouble {.
    importc: "gtk_scale_button_get_value", libgtk.}
proc value*(button: ScaleButton): cdouble {.
    importc: "gtk_scale_button_get_value", libgtk.}
proc setValue*(button: ScaleButton; value: cdouble) {.
    importc: "gtk_scale_button_set_value", libgtk.}
proc `value=`*(button: ScaleButton; value: cdouble) {.
    importc: "gtk_scale_button_set_value", libgtk.}
proc getAdjustment*(button: ScaleButton): Adjustment {.
    importc: "gtk_scale_button_get_adjustment", libgtk.}
proc adjustment*(button: ScaleButton): Adjustment {.
    importc: "gtk_scale_button_get_adjustment", libgtk.}
proc setAdjustment*(button: ScaleButton;
                                 adjustment: Adjustment) {.
    importc: "gtk_scale_button_set_adjustment", libgtk.}
proc `adjustment=`*(button: ScaleButton;
                                 adjustment: Adjustment) {.
    importc: "gtk_scale_button_set_adjustment", libgtk.}
proc getPlusButton*(button: ScaleButton): Widget {.
    importc: "gtk_scale_button_get_plus_button", libgtk.}
proc plusButton*(button: ScaleButton): Widget {.
    importc: "gtk_scale_button_get_plus_button", libgtk.}
proc getMinusButton*(button: ScaleButton): Widget {.
    importc: "gtk_scale_button_get_minus_button", libgtk.}
proc minusButton*(button: ScaleButton): Widget {.
    importc: "gtk_scale_button_get_minus_button", libgtk.}
proc getPopup*(button: ScaleButton): Widget {.
    importc: "gtk_scale_button_get_popup", libgtk.}
proc popup*(button: ScaleButton): Widget {.
    importc: "gtk_scale_button_get_popup", libgtk.}

template typeScrollable*(): expr =
  (scrollableGetType())

template scrollable*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeScrollable, ScrollableObj))

template isScrollable*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeScrollable))

template scrollableGetIface*(inst: expr): expr =
  (gTypeInstanceGetInterface(inst, typeScrollable, ScrollableInterfaceObj))

type
  Scrollbar* =  ptr ScrollbarObj
  ScrollbarPtr* = ptr ScrollbarObj
  ScrollbarObj* = object of RangeObj

  ScrollbarClass* =  ptr ScrollbarClassObj
  ScrollbarClassPtr* = ptr ScrollbarClassObj
  ScrollbarClassObj = object of RangeClassObj
    gtkReserved1081*: proc () {.cdecl.}
    gtkReserved1082*: proc () {.cdecl.}
    gtkReserved1083*: proc () {.cdecl.}
    gtkReserved1084*: proc () {.cdecl.}

proc scrollableGetType*(): GType {.importc: "gtk_scrollable_get_type", libgtk.}
proc getHadjustment*(scrollable: Scrollable): Adjustment {.
    importc: "gtk_scrollable_get_hadjustment", libgtk.}
proc hadjustment*(scrollable: Scrollable): Adjustment {.
    importc: "gtk_scrollable_get_hadjustment", libgtk.}
proc setHadjustment*(scrollable: Scrollable;
                                 hadjustment: Adjustment) {.
    importc: "gtk_scrollable_set_hadjustment", libgtk.}
proc `hadjustment=`*(scrollable: Scrollable;
                                 hadjustment: Adjustment) {.
    importc: "gtk_scrollable_set_hadjustment", libgtk.}
proc getVadjustment*(scrollable: Scrollable): Adjustment {.
    importc: "gtk_scrollable_get_vadjustment", libgtk.}
proc vadjustment*(scrollable: Scrollable): Adjustment {.
    importc: "gtk_scrollable_get_vadjustment", libgtk.}
proc setVadjustment*(scrollable: Scrollable;
                                 vadjustment: Adjustment) {.
    importc: "gtk_scrollable_set_vadjustment", libgtk.}
proc `vadjustment=`*(scrollable: Scrollable;
                                 vadjustment: Adjustment) {.
    importc: "gtk_scrollable_set_vadjustment", libgtk.}
proc getHscrollPolicy*(scrollable: Scrollable): ScrollablePolicy {.
    importc: "gtk_scrollable_get_hscroll_policy", libgtk.}
proc hscrollPolicy*(scrollable: Scrollable): ScrollablePolicy {.
    importc: "gtk_scrollable_get_hscroll_policy", libgtk.}
proc setHscrollPolicy*(scrollable: Scrollable;
                                   policy: ScrollablePolicy) {.
    importc: "gtk_scrollable_set_hscroll_policy", libgtk.}
proc `hscrollPolicy=`*(scrollable: Scrollable;
                                   policy: ScrollablePolicy) {.
    importc: "gtk_scrollable_set_hscroll_policy", libgtk.}
proc getVscrollPolicy*(scrollable: Scrollable): ScrollablePolicy {.
    importc: "gtk_scrollable_get_vscroll_policy", libgtk.}
proc vscrollPolicy*(scrollable: Scrollable): ScrollablePolicy {.
    importc: "gtk_scrollable_get_vscroll_policy", libgtk.}
proc setVscrollPolicy*(scrollable: Scrollable;
                                   policy: ScrollablePolicy) {.
    importc: "gtk_scrollable_set_vscroll_policy", libgtk.}
proc `vscrollPolicy=`*(scrollable: Scrollable;
                                   policy: ScrollablePolicy) {.
    importc: "gtk_scrollable_set_vscroll_policy", libgtk.}
proc getBorder*(scrollable: Scrollable; border: Border): Gboolean {.
    importc: "gtk_scrollable_get_border", libgtk.}
proc border*(scrollable: Scrollable; border: Border): Gboolean {.
    importc: "gtk_scrollable_get_border", libgtk.}

template typeScrollbar*(): expr =
  (scrollbarGetType())

template scrollbar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeScrollbar, ScrollbarObj))

template scrollbarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeScrollbar, ScrollbarClassObj))

template isScrollbar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeScrollbar))

template isScrollbarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeScrollbar))

template scrollbarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeScrollbar, ScrollbarClassObj))

type
  ScrolledWindow* =  ptr ScrolledWindowObj
  ScrolledWindowPtr* = ptr ScrolledWindowObj
  ScrolledWindowObj* = object of BinObj
    priv113: pointer

  ScrolledWindowClass* =  ptr ScrolledWindowClassObj
  ScrolledWindowClassPtr* = ptr ScrolledWindowClassObj
  ScrolledWindowClassObj*{.final.} = object of BinClassObj
    scrollbarSpacing*: cint
    scrollChild*: proc (scrolledWindow: ScrolledWindow; scroll: ScrollType;
                      horizontal: Gboolean): Gboolean {.cdecl.}
    moveFocusOut*: proc (scrolledWindow: ScrolledWindow;
                       direction: DirectionType) {.cdecl.}
    gtkReserved1091*: proc () {.cdecl.}
    gtkReserved1092*: proc () {.cdecl.}
    gtkReserved1093*: proc () {.cdecl.}
    gtkReserved1094*: proc () {.cdecl.}

proc scrollbarGetType*(): GType {.importc: "gtk_scrollbar_get_type", libgtk.}
proc newScrollbar*(orientation: Orientation; adjustment: Adjustment): Scrollbar {.
    importc: "gtk_scrollbar_new", libgtk.}

template typeScrolledWindow*(): expr =
  (scrolledWindowGetType())

template scrolledWindow*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeScrolledWindow, ScrolledWindowObj))

template scrolledWindowClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeScrolledWindow, ScrolledWindowClassObj))

template isScrolledWindow*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeScrolledWindow))

template isScrolledWindowClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeScrolledWindow))

template scrolledWindowGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeScrolledWindow, ScrolledWindowClassObj))

type
  CornerType* {.size: sizeof(cint), pure.} = enum
    TOP_LEFT, BOTTOM_LEFT, TOP_RIGHT,
    BOTTOM_RIGHT

type
  PolicyType* {.size: sizeof(cint), pure.} = enum
    ALWAYS, AUTOMATIC, NEVER, EXTERNAL

type
  SearchBar* =  ptr SearchBarObj
  SearchBarPtr* = ptr SearchBarObj
  SearchBarObj*{.final.} = object of BinObj

  SearchBarClass* =  ptr SearchBarClassObj
  SearchBarClassPtr* = ptr SearchBarClassObj
  SearchBarClassObj*{.final.} = object of BinClassObj
    gtkReserved1101*: proc () {.cdecl.}
    gtkReserved1102*: proc () {.cdecl.}
    gtkReserved1103*: proc () {.cdecl.}
    gtkReserved1104*: proc () {.cdecl.}

proc scrolledWindowGetType*(): GType {.importc: "gtk_scrolled_window_get_type",
                                       libgtk.}
proc newScrolledWindow*(hadjustment: Adjustment;
                          vadjustment: Adjustment): ScrolledWindow {.
    importc: "gtk_scrolled_window_new", libgtk.}
proc setHadjustment*(scrolledWindow: ScrolledWindow;
                                     hadjustment: Adjustment) {.
    importc: "gtk_scrolled_window_set_hadjustment", libgtk.}
proc `hadjustment=`*(scrolledWindow: ScrolledWindow;
                                     hadjustment: Adjustment) {.
    importc: "gtk_scrolled_window_set_hadjustment", libgtk.}
proc setVadjustment*(scrolledWindow: ScrolledWindow;
                                     vadjustment: Adjustment) {.
    importc: "gtk_scrolled_window_set_vadjustment", libgtk.}
proc `vadjustment=`*(scrolledWindow: ScrolledWindow;
                                     vadjustment: Adjustment) {.
    importc: "gtk_scrolled_window_set_vadjustment", libgtk.}
proc getHadjustment*(scrolledWindow: ScrolledWindow): Adjustment {.
    importc: "gtk_scrolled_window_get_hadjustment", libgtk.}
proc hadjustment*(scrolledWindow: ScrolledWindow): Adjustment {.
    importc: "gtk_scrolled_window_get_hadjustment", libgtk.}
proc getVadjustment*(scrolledWindow: ScrolledWindow): Adjustment {.
    importc: "gtk_scrolled_window_get_vadjustment", libgtk.}
proc vadjustment*(scrolledWindow: ScrolledWindow): Adjustment {.
    importc: "gtk_scrolled_window_get_vadjustment", libgtk.}
proc setPolicy*(scrolledWindow: ScrolledWindow;
                                hscrollbarPolicy: PolicyType;
                                vscrollbarPolicy: PolicyType) {.
    importc: "gtk_scrolled_window_set_policy", libgtk.}
proc `policy=`*(scrolledWindow: ScrolledWindow;
                                hscrollbarPolicy: PolicyType;
                                vscrollbarPolicy: PolicyType) {.
    importc: "gtk_scrolled_window_set_policy", libgtk.}
proc getPolicy*(scrolledWindow: ScrolledWindow;
                                hscrollbarPolicy: ptr PolicyType;
                                vscrollbarPolicy: ptr PolicyType) {.
    importc: "gtk_scrolled_window_get_policy", libgtk.}
proc setPlacement*(scrolledWindow: ScrolledWindow;
                                   windowPlacement: CornerType) {.
    importc: "gtk_scrolled_window_set_placement", libgtk.}
proc `placement=`*(scrolledWindow: ScrolledWindow;
                                   windowPlacement: CornerType) {.
    importc: "gtk_scrolled_window_set_placement", libgtk.}
proc unsetPlacement*(scrolledWindow: ScrolledWindow) {.
    importc: "gtk_scrolled_window_unset_placement", libgtk.}
proc getPlacement*(scrolledWindow: ScrolledWindow): CornerType {.
    importc: "gtk_scrolled_window_get_placement", libgtk.}
proc placement*(scrolledWindow: ScrolledWindow): CornerType {.
    importc: "gtk_scrolled_window_get_placement", libgtk.}
proc setShadowType*(scrolledWindow: ScrolledWindow;
                                    `type`: ShadowType) {.
    importc: "gtk_scrolled_window_set_shadow_type", libgtk.}
proc `shadowType=`*(scrolledWindow: ScrolledWindow;
                                    `type`: ShadowType) {.
    importc: "gtk_scrolled_window_set_shadow_type", libgtk.}
proc getShadowType*(scrolledWindow: ScrolledWindow): ShadowType {.
    importc: "gtk_scrolled_window_get_shadow_type", libgtk.}
proc shadowType*(scrolledWindow: ScrolledWindow): ShadowType {.
    importc: "gtk_scrolled_window_get_shadow_type", libgtk.}
proc addWithViewport*(scrolledWindow: ScrolledWindow;
                                      child: Widget) {.
    importc: "gtk_scrolled_window_add_with_viewport", libgtk.}
proc getMinContentWidth*(scrolledWindow: ScrolledWindow): cint {.
    importc: "gtk_scrolled_window_get_min_content_width", libgtk.}
proc minContentWidth*(scrolledWindow: ScrolledWindow): cint {.
    importc: "gtk_scrolled_window_get_min_content_width", libgtk.}
proc setMinContentWidth*(scrolledWindow: ScrolledWindow;
    width: cint) {.importc: "gtk_scrolled_window_set_min_content_width", libgtk.}
proc `minContentWidth=`*(scrolledWindow: ScrolledWindow;
    width: cint) {.importc: "gtk_scrolled_window_set_min_content_width", libgtk.}
proc getMinContentHeight*(scrolledWindow: ScrolledWindow): cint {.
    importc: "gtk_scrolled_window_get_min_content_height", libgtk.}
proc minContentHeight*(scrolledWindow: ScrolledWindow): cint {.
    importc: "gtk_scrolled_window_get_min_content_height", libgtk.}
proc setMinContentHeight*(scrolledWindow: ScrolledWindow;
    height: cint) {.importc: "gtk_scrolled_window_set_min_content_height",
                  libgtk.}
proc `minContentHeight=`*(scrolledWindow: ScrolledWindow;
    height: cint) {.importc: "gtk_scrolled_window_set_min_content_height",
                  libgtk.}
proc setKineticScrolling*(scrolledWindow: ScrolledWindow;
    kineticScrolling: Gboolean) {.importc: "gtk_scrolled_window_set_kinetic_scrolling",
                                libgtk.}
proc `kineticScrolling=`*(scrolledWindow: ScrolledWindow;
    kineticScrolling: Gboolean) {.importc: "gtk_scrolled_window_set_kinetic_scrolling",
                                libgtk.}
proc getKineticScrolling*(scrolledWindow: ScrolledWindow): Gboolean {.
    importc: "gtk_scrolled_window_get_kinetic_scrolling", libgtk.}
proc kineticScrolling*(scrolledWindow: ScrolledWindow): Gboolean {.
    importc: "gtk_scrolled_window_get_kinetic_scrolling", libgtk.}
proc setCaptureButtonPress*(
    scrolledWindow: ScrolledWindow; captureButtonPress: Gboolean) {.
    importc: "gtk_scrolled_window_set_capture_button_press", libgtk.}
proc `captureButtonPress=`*(
    scrolledWindow: ScrolledWindow; captureButtonPress: Gboolean) {.
    importc: "gtk_scrolled_window_set_capture_button_press", libgtk.}
proc getCaptureButtonPress*(
    scrolledWindow: ScrolledWindow): Gboolean {.
    importc: "gtk_scrolled_window_get_capture_button_press", libgtk.}
proc captureButtonPress*(
    scrolledWindow: ScrolledWindow): Gboolean {.
    importc: "gtk_scrolled_window_get_capture_button_press", libgtk.}
proc setOverlayScrolling*(scrolledWindow: ScrolledWindow;
    overlayScrolling: Gboolean) {.importc: "gtk_scrolled_window_set_overlay_scrolling",
                                libgtk.}
proc `overlayScrolling=`*(scrolledWindow: ScrolledWindow;
    overlayScrolling: Gboolean) {.importc: "gtk_scrolled_window_set_overlay_scrolling",
                                libgtk.}
proc getOverlayScrolling*(scrolledWindow: ScrolledWindow): Gboolean {.
    importc: "gtk_scrolled_window_get_overlay_scrolling", libgtk.}
proc overlayScrolling*(scrolledWindow: ScrolledWindow): Gboolean {.
    importc: "gtk_scrolled_window_get_overlay_scrolling", libgtk.}

template typeSearchBar*(): expr =
  (searchBarGetType())

template searchBar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSearchBar, SearchBarObj))

template searchBarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeSearchBar, SearchBarClassObj))

template isSearchBar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSearchBar))

template isSearchBarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeSearchBar))

template searchBarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSearchBar, SearchBarClassObj))

type
  SearchEntry* =  ptr SearchEntryObj
  SearchEntryPtr* = ptr SearchEntryObj
  SearchEntryObj*{.final.} = object of EntryObj

  SearchEntryClass* =  ptr SearchEntryClassObj
  SearchEntryClassPtr* = ptr SearchEntryClassObj
  SearchEntryClassObj*{.final.} = object of EntryClassObj
    searchChanged*: proc (entry: SearchEntry) {.cdecl.}
    nextMatch*: proc (entry: SearchEntry) {.cdecl.}
    previousMatch*: proc (entry: SearchEntry) {.cdecl.}
    stopSearch*: proc (entry: SearchEntry) {.cdecl.}

proc searchBarGetType*(): GType {.importc: "gtk_search_bar_get_type", libgtk.}
proc newSearchBar*(): SearchBar {.importc: "gtk_search_bar_new", libgtk.}
proc connectEntry*(bar: SearchBar; entry: Entry) {.
    importc: "gtk_search_bar_connect_entry", libgtk.}
proc getSearchMode*(bar: SearchBar): Gboolean {.
    importc: "gtk_search_bar_get_search_mode", libgtk.}
proc searchMode*(bar: SearchBar): Gboolean {.
    importc: "gtk_search_bar_get_search_mode", libgtk.}
proc setSearchMode*(bar: SearchBar; searchMode: Gboolean) {.
    importc: "gtk_search_bar_set_search_mode", libgtk.}
proc `searchMode=`*(bar: SearchBar; searchMode: Gboolean) {.
    importc: "gtk_search_bar_set_search_mode", libgtk.}
proc getShowCloseButton*(bar: SearchBar): Gboolean {.
    importc: "gtk_search_bar_get_show_close_button", libgtk.}
proc showCloseButton*(bar: SearchBar): Gboolean {.
    importc: "gtk_search_bar_get_show_close_button", libgtk.}
proc setShowCloseButton*(bar: SearchBar; visible: Gboolean) {.
    importc: "gtk_search_bar_set_show_close_button", libgtk.}
proc `showCloseButton=`*(bar: SearchBar; visible: Gboolean) {.
    importc: "gtk_search_bar_set_show_close_button", libgtk.}
proc handleEvent*(bar: SearchBar; event: gdk3.Event): Gboolean {.
    importc: "gtk_search_bar_handle_event", libgtk.}

template typeSearchEntry*(): expr =
  (searchEntryGetType())

template searchEntry*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSearchEntry, SearchEntryObj))

template searchEntryClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeSearchEntry, SearchEntryClassObj))

template isSearchEntry*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSearchEntry))

template isSearchEntryClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeSearchEntry))

template searchEntryGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSearchEntry, SearchEntryClassObj))

type
  Separator* =  ptr SeparatorObj
  SeparatorPtr* = ptr SeparatorObj
  SeparatorObj* = object of WidgetObj
    priv114: pointer

  SeparatorClass* =  ptr SeparatorClassObj
  SeparatorClassPtr* = ptr SeparatorClassObj
  SeparatorClassObj = object of WidgetClassObj
    gtkReserved1111*: proc () {.cdecl.}
    gtkReserved1112*: proc () {.cdecl.}
    gtkReserved1113*: proc () {.cdecl.}
    gtkReserved1114*: proc () {.cdecl.}

proc searchEntryGetType*(): GType {.importc: "gtk_search_entry_get_type",
                                    libgtk.}
proc newSearchEntry*(): SearchEntry {.importc: "gtk_search_entry_new",
                                       libgtk.}
proc handleEvent*(entry: SearchEntry; event: gdk3.Event): Gboolean {.
    importc: "gtk_search_entry_handle_event", libgtk.}

template typeSeparator*(): expr =
  (separatorGetType())

template separator*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSeparator, SeparatorObj))

template separatorClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeSeparator, SeparatorClassObj))

template isSeparator*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSeparator))

template isSeparatorClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeSeparator))

template separatorGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSeparator, SeparatorClassObj))

type
  SeparatorMenuItem* =  ptr SeparatorMenuItemObj
  SeparatorMenuItemPtr* = ptr SeparatorMenuItemObj
  SeparatorMenuItemObj* = object of MenuItemObj

  SeparatorMenuItemClass* =  ptr SeparatorMenuItemClassObj
  SeparatorMenuItemClassPtr* = ptr SeparatorMenuItemClassObj
  SeparatorMenuItemClassObj*{.final.} = object of MenuItemClassObj
    gtkReserved1121*: proc () {.cdecl.}
    gtkReserved1122*: proc () {.cdecl.}
    gtkReserved1123*: proc () {.cdecl.}
    gtkReserved1124*: proc () {.cdecl.}

proc separatorGetType*(): GType {.importc: "gtk_separator_get_type", libgtk.}
proc newSeparator*(orientation: Orientation): Separator {.
    importc: "gtk_separator_new", libgtk.}

template typeSeparatorMenuItem*(): expr =
  (separatorMenuItemGetType())

template separatorMenuItem*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSeparatorMenuItem, SeparatorMenuItemObj))

template separatorMenuItemClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeSeparatorMenuItem, SeparatorMenuItemClassObj))

template isSeparatorMenuItem*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSeparatorMenuItem))

template isSeparatorMenuItemClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeSeparatorMenuItem))

template separatorMenuItemGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSeparatorMenuItem, SeparatorMenuItemClassObj))

type
  SeparatorToolItem* =  ptr SeparatorToolItemObj
  SeparatorToolItemPtr* = ptr SeparatorToolItemObj
  SeparatorToolItemObj*{.final.} = object of ToolItemObj
    priv115: pointer

  SeparatorToolItemClass* =  ptr SeparatorToolItemClassObj
  SeparatorToolItemClassPtr* = ptr SeparatorToolItemClassObj
  SeparatorToolItemClassObj*{.final.} = object of ToolItemClassObj
    gtkReserved1131*: proc () {.cdecl.}
    gtkReserved1132*: proc () {.cdecl.}
    gtkReserved1133*: proc () {.cdecl.}
    gtkReserved1134*: proc () {.cdecl.}

proc separatorMenuItemGetType*(): GType {.
    importc: "gtk_separator_menu_item_get_type", libgtk.}
proc newSeparatorMenuItem*(): SeparatorMenuItem {.
    importc: "gtk_separator_menu_item_new", libgtk.}

template typeSeparatorToolItem*(): expr =
  (separatorToolItemGetType())

template separatorToolItem*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSeparatorToolItem, SeparatorToolItemObj))

template separatorToolItemClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeSeparatorToolItem, SeparatorToolItemClassObj))

template isSeparatorToolItem*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSeparatorToolItem))

template isSeparatorToolItemClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeSeparatorToolItem))

template separatorToolItemGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSeparatorToolItem, SeparatorToolItemClassObj))

type
  SettingsClass* =  ptr SettingsClassObj
  SettingsClassPtr* = ptr SettingsClassObj
  SettingsClassObj*{.final.} = object of GObjectClassObj
    gtkReserved1141*: proc () {.cdecl.}
    gtkReserved1142*: proc () {.cdecl.}
    gtkReserved1143*: proc () {.cdecl.}
    gtkReserved1144*: proc () {.cdecl.}

proc separatorToolItemGetType*(): GType {.
    importc: "gtk_separator_tool_item_get_type", libgtk.}
proc newSeparatorToolItem*(): ToolItem {.
    importc: "gtk_separator_tool_item_new", libgtk.}
proc getDraw*(item: SeparatorToolItem): Gboolean {.
    importc: "gtk_separator_tool_item_get_draw", libgtk.}
proc draw*(item: SeparatorToolItem): Gboolean {.
    importc: "gtk_separator_tool_item_get_draw", libgtk.}
proc setDraw*(item: SeparatorToolItem; draw: Gboolean) {.
    importc: "gtk_separator_tool_item_set_draw", libgtk.}
proc `draw=`*(item: SeparatorToolItem; draw: Gboolean) {.
    importc: "gtk_separator_tool_item_set_draw", libgtk.}

template typeSettings*(): expr =
  (settingsGetType())

template settings*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSettings, SettingsObj))

template settingsClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeSettings, SettingsClassObj))

template isSettings*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSettings))

template isSettingsClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeSettings))

template settingsGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSettings, SettingsClassObj))

type
  SettingsValue* =  ptr SettingsValueObj
  SettingsValuePtr* = ptr SettingsValueObj
  SettingsValueObj* = object
    origin*: cstring
    value*: gobject.GValueObj

  ShortcutsGroup* =  ptr ShortcutsGroupObj
  ShortcutsGroupPtr* = ptr ShortcutsGroupObj
  ShortcutsGroupObj* = object

  ShortcutsGroupClass* =  ptr ShortcutsGroupClassObj
  ShortcutsGroupClassPtr* = ptr ShortcutsGroupClassObj
  ShortcutsGroupClassObj* = object

proc settingsGetType*(): GType {.importc: "gtk_settings_get_type", libgtk.}
proc settingsGetDefault*(): Settings {.
    importc: "gtk_settings_get_default", libgtk.}
proc settingsGetForScreen*(screen: gdk3.Screen): Settings {.
    importc: "gtk_settings_get_for_screen", libgtk.}
proc settingsInstallProperty*(pspec: gobject.GParamSpec) {.
    importc: "gtk_settings_install_property", libgtk.}
proc settingsInstallPropertyParser*(pspec: gobject.GParamSpec;
                                      parser: RcPropertyParser) {.
    importc: "gtk_settings_install_property_parser", libgtk.}

proc rcPropertyParseColor*(pspec: gobject.GParamSpec; gstring: glib.GString;
                             propertyValue: gobject.GValue): Gboolean {.
    importc: "gtk_rc_property_parse_color", libgtk.}
proc rcPropertyParseEnum*(pspec: gobject.GParamSpec; gstring: glib.GString;
                            propertyValue: gobject.GValue): Gboolean {.
    importc: "gtk_rc_property_parse_enum", libgtk.}
proc rcPropertyParseFlags*(pspec: gobject.GParamSpec; gstring: glib.GString;
                             propertyValue: gobject.GValue): Gboolean {.
    importc: "gtk_rc_property_parse_flags", libgtk.}
proc rcPropertyParseRequisition*(pspec: gobject.GParamSpec; gstring: glib.GString;
                                   propertyValue: gobject.GValue): Gboolean {.
    importc: "gtk_rc_property_parse_requisition", libgtk.}
proc rcPropertyParseBorder*(pspec: gobject.GParamSpec; gstring: glib.GString;
                              propertyValue: gobject.GValue): Gboolean {.
    importc: "gtk_rc_property_parse_border", libgtk.}
proc setPropertyValue*(settings: Settings; name: cstring;
                                 svalue: SettingsValue) {.
    importc: "gtk_settings_set_property_value", libgtk.}
proc `propertyValue=`*(settings: Settings; name: cstring;
                                 svalue: SettingsValue) {.
    importc: "gtk_settings_set_property_value", libgtk.}
proc setStringProperty*(settings: Settings; name: cstring;
                                  vString: cstring; origin: cstring) {.
    importc: "gtk_settings_set_string_property", libgtk.}
proc `stringProperty=`*(settings: Settings; name: cstring;
                                  vString: cstring; origin: cstring) {.
    importc: "gtk_settings_set_string_property", libgtk.}
proc setLongProperty*(settings: Settings; name: cstring;
                                vLong: clong; origin: cstring) {.
    importc: "gtk_settings_set_long_property", libgtk.}
proc `longProperty=`*(settings: Settings; name: cstring;
                                vLong: clong; origin: cstring) {.
    importc: "gtk_settings_set_long_property", libgtk.}
proc setDoubleProperty*(settings: Settings; name: cstring;
                                  vDouble: cdouble; origin: cstring) {.
    importc: "gtk_settings_set_double_property", libgtk.}
proc `doubleProperty=`*(settings: Settings; name: cstring;
                                  vDouble: cdouble; origin: cstring) {.
    importc: "gtk_settings_set_double_property", libgtk.}
proc resetProperty*(settings: Settings; name: cstring) {.
    importc: "gtk_settings_reset_property", libgtk.}

template typeShortcutsGroup*(): expr =
  (shortcutsGroupGetType())

template shortcutsGroup*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeShortcutsGroup, ShortcutsGroupObj))

template shortcutsGroupClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeShortcutsGroup, ShortcutsGroupClassObj))

template isShortcutsGroup*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeShortcutsGroup))

template isShortcutsGroupClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeShortcutsGroup))

template shortcutsGroupGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeShortcutsGroup, ShortcutsGroupClassObj))

type
  ShortcutsSection* =  ptr ShortcutsSectionObj
  ShortcutsSectionPtr* = ptr ShortcutsSectionObj
  ShortcutsSectionObj* = object

  ShortcutsSectionClass* =  ptr ShortcutsSectionClassObj
  ShortcutsSectionClassPtr* = ptr ShortcutsSectionClassObj
  ShortcutsSectionClassObj* = object

proc shortcutsGroupGetType*(): GType {.importc: "gtk_shortcuts_group_get_type",
                                       libgtk.}

template typeShortcutsSection*(): expr =
  (shortcutsSectionGetType())

template shortcutsSection*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeShortcutsSection, ShortcutsSectionObj))

template shortcutsSectionClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeShortcutsSection, ShortcutsSectionClassObj))

template isShortcutsSection*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeShortcutsSection))

template isShortcutsSectionClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeShortcutsSection))

template shortcutsSectionGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeShortcutsSection, ShortcutsSectionClassObj))

type
  ShortcutsShortcut* =  ptr ShortcutsShortcutObj
  ShortcutsShortcutPtr* = ptr ShortcutsShortcutObj
  ShortcutsShortcutObj* = object

  ShortcutsShortcutClass* =  ptr ShortcutsShortcutClassObj
  ShortcutsShortcutClassPtr* = ptr ShortcutsShortcutClassObj
  ShortcutsShortcutClassObj* = object

proc shortcutsSectionGetType*(): GType {.
    importc: "gtk_shortcuts_section_get_type", libgtk.}

template typeShortcutsShortcut*(): expr =
  (shortcutsShortcutGetType())

template shortcutsShortcut*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeShortcutsShortcut, ShortcutsShortcutObj))

template shortcutsShortcutClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeShortcutsShortcut, ShortcutsShortcutClassObj))

template isShortcutsShortcut*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeShortcutsShortcut))

template isShortcutsShortcutClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeShortcutsShortcut))

template shortcutsShortcutGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeShortcutsShortcut, ShortcutsShortcutClassObj))

type
  ShortcutType* {.size: sizeof(cint), pure.} = enum
    ACCELERATOR, GESTURE_PINCH,
    GESTURE_STRETCH, GESTURE_ROTATE_CLOCKWISE,
    GESTURE_ROTATE_COUNTERCLOCKWISE,
    GESTURE_TWO_FINGER_SWIPE_LEFT,
    GESTURE_TWO_FINGER_SWIPE_RIGHT, GESTURE

proc shortcutsShortcutGetType*(): GType {.
    importc: "gtk_shortcuts_shortcut_get_type", libgtk.}

proc showUri*(screen: gdk3.Screen; uri: cstring; timestamp: uint32;
                error: var glib.GError): Gboolean {.importc: "gtk_show_uri", libgtk.}

template typeStack*(): expr =
  (stackGetType())

template stack*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeStack, StackObj))

template stackClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeStack, StackClassObj))

template isStack*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeStack))

template isStackClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeStack))

template stackGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeStack, StackClassObj))

type
  StackTransitionType* {.size: sizeof(cint), pure.} = enum
    NONE, CROSSFADE,
    SLIDE_RIGHT, SLIDE_LEFT,
    SLIDE_UP, SLIDE_DOWN,
    SLIDE_LEFT_RIGHT,
    SLIDE_UP_DOWN, OVER_UP,
    OVER_DOWN, OVER_LEFT,
    OVER_RIGHT, UNDER_UP,
    UNDER_DOWN, UNDER_LEFT,
    UNDER_RIGHT,
    OVER_UP_DOWN,
    OVER_DOWN_UP,
    OVER_LEFT_RIGHT,
    OVER_RIGHT_LEFT

type
  Stack* =  ptr StackObj
  StackPtr* = ptr StackObj
  StackObj*{.final.} = object of ContainerObj

  StackClass* =  ptr StackClassObj
  StackClassPtr* = ptr StackClassObj
  StackClassObj*{.final.} = object of ContainerClassObj

  StackSidebar* =  ptr StackSidebarObj
  StackSidebarPtr* = ptr StackSidebarObj
  StackSidebarObj*{.final.} = object of BinObj

  StackSidebarClass* =  ptr StackSidebarClassObj
  StackSidebarClassPtr* = ptr StackSidebarClassObj
  StackSidebarClassObj*{.final.} = object of BinClassObj
    gtkReserved1151*: proc () {.cdecl.}
    gtkReserved1152*: proc () {.cdecl.}
    gtkReserved1153*: proc () {.cdecl.}
    gtkReserved1154*: proc () {.cdecl.}

proc stackGetType*(): GType {.importc: "gtk_stack_get_type", libgtk.}
proc newStack*(): Stack {.importc: "gtk_stack_new", libgtk.}
proc addNamed*(stack: Stack; child: Widget; name: cstring) {.
    importc: "gtk_stack_add_named", libgtk.}
proc addTitled*(stack: Stack; child: Widget; name: cstring;
                       title: cstring) {.importc: "gtk_stack_add_titled",
                                       libgtk.}
proc getChildByName*(stack: Stack; name: cstring): Widget {.
    importc: "gtk_stack_get_child_by_name", libgtk.}
proc childByName*(stack: Stack; name: cstring): Widget {.
    importc: "gtk_stack_get_child_by_name", libgtk.}
proc setVisibleChild*(stack: Stack; child: Widget) {.
    importc: "gtk_stack_set_visible_child", libgtk.}
proc `visibleChild=`*(stack: Stack; child: Widget) {.
    importc: "gtk_stack_set_visible_child", libgtk.}
proc getVisibleChild*(stack: Stack): Widget {.
    importc: "gtk_stack_get_visible_child", libgtk.}
proc visibleChild*(stack: Stack): Widget {.
    importc: "gtk_stack_get_visible_child", libgtk.}
proc setVisibleChildName*(stack: Stack; name: cstring) {.
    importc: "gtk_stack_set_visible_child_name", libgtk.}
proc `visibleChildName=`*(stack: Stack; name: cstring) {.
    importc: "gtk_stack_set_visible_child_name", libgtk.}
proc getVisibleChildName*(stack: Stack): cstring {.
    importc: "gtk_stack_get_visible_child_name", libgtk.}
proc visibleChildName*(stack: Stack): cstring {.
    importc: "gtk_stack_get_visible_child_name", libgtk.}
proc setVisibleChildFull*(stack: Stack; name: cstring;
                                 transition: StackTransitionType) {.
    importc: "gtk_stack_set_visible_child_full", libgtk.}
proc `visibleChildFull=`*(stack: Stack; name: cstring;
                                 transition: StackTransitionType) {.
    importc: "gtk_stack_set_visible_child_full", libgtk.}
proc setHomogeneous*(stack: Stack; homogeneous: Gboolean) {.
    importc: "gtk_stack_set_homogeneous", libgtk.}
proc `homogeneous=`*(stack: Stack; homogeneous: Gboolean) {.
    importc: "gtk_stack_set_homogeneous", libgtk.}
proc getHomogeneous*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_homogeneous", libgtk.}
proc homogeneous*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_homogeneous", libgtk.}
proc setHhomogeneous*(stack: Stack; hhomogeneous: Gboolean) {.
    importc: "gtk_stack_set_hhomogeneous", libgtk.}
proc `hhomogeneous=`*(stack: Stack; hhomogeneous: Gboolean) {.
    importc: "gtk_stack_set_hhomogeneous", libgtk.}
proc getHhomogeneous*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_hhomogeneous", libgtk.}
proc hhomogeneous*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_hhomogeneous", libgtk.}
proc setVhomogeneous*(stack: Stack; vhomogeneous: Gboolean) {.
    importc: "gtk_stack_set_vhomogeneous", libgtk.}
proc `vhomogeneous=`*(stack: Stack; vhomogeneous: Gboolean) {.
    importc: "gtk_stack_set_vhomogeneous", libgtk.}
proc getVhomogeneous*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_vhomogeneous", libgtk.}
proc vhomogeneous*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_vhomogeneous", libgtk.}
proc setTransitionDuration*(stack: Stack; duration: cuint) {.
    importc: "gtk_stack_set_transition_duration", libgtk.}
proc `transitionDuration=`*(stack: Stack; duration: cuint) {.
    importc: "gtk_stack_set_transition_duration", libgtk.}
proc getTransitionDuration*(stack: Stack): cuint {.
    importc: "gtk_stack_get_transition_duration", libgtk.}
proc transitionDuration*(stack: Stack): cuint {.
    importc: "gtk_stack_get_transition_duration", libgtk.}
proc setTransitionType*(stack: Stack;
                               transition: StackTransitionType) {.
    importc: "gtk_stack_set_transition_type", libgtk.}
proc `transitionType=`*(stack: Stack;
                               transition: StackTransitionType) {.
    importc: "gtk_stack_set_transition_type", libgtk.}
proc getTransitionType*(stack: Stack): StackTransitionType {.
    importc: "gtk_stack_get_transition_type", libgtk.}
proc transitionType*(stack: Stack): StackTransitionType {.
    importc: "gtk_stack_get_transition_type", libgtk.}
proc getTransitionRunning*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_transition_running", libgtk.}
proc transitionRunning*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_transition_running", libgtk.}
proc setInterpolateSize*(stack: Stack; interpolateSize: Gboolean) {.
    importc: "gtk_stack_set_interpolate_size", libgtk.}
proc `interpolateSize=`*(stack: Stack; interpolateSize: Gboolean) {.
    importc: "gtk_stack_set_interpolate_size", libgtk.}
proc getInterpolateSize*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_interpolate_size", libgtk.}
proc interpolateSize*(stack: Stack): Gboolean {.
    importc: "gtk_stack_get_interpolate_size", libgtk.}

template typeStackSidebar*(): expr =
  (stackSidebarGetType())

template stackSidebar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeStackSidebar, StackSidebarObj))

template isStackSidebar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeStackSidebar))

template stackSidebarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeStackSidebar, StackSidebarClassObj))

template isStackSidebarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeStackSidebar))

template stackSidebarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeStackSidebar, StackSidebarClassObj))

proc stackSidebarGetType*(): GType {.importc: "gtk_stack_sidebar_get_type",
                                     libgtk.}
proc newStackSidebar*(): StackSidebar {.importc: "gtk_stack_sidebar_new",
                                        libgtk.}
proc setStack*(sidebar: StackSidebar; stack: Stack) {.
    importc: "gtk_stack_sidebar_set_stack", libgtk.}
proc `stack=`*(sidebar: StackSidebar; stack: Stack) {.
    importc: "gtk_stack_sidebar_set_stack", libgtk.}
proc getStack*(sidebar: StackSidebar): Stack {.
    importc: "gtk_stack_sidebar_get_stack", libgtk.}
proc stack*(sidebar: StackSidebar): Stack {.
    importc: "gtk_stack_sidebar_get_stack", libgtk.}

type
  RequestedSize* =  ptr RequestedSizeObj
  RequestedSizePtr* = ptr RequestedSizeObj
  RequestedSizeObj* = object
    data*: Gpointer
    minimumSize*: cint
    naturalSize*: cint

  SpinButtonClass* =  ptr SpinButtonClassObj
  SpinButtonClassPtr* = ptr SpinButtonClassObj
  SpinButtonClassObj*{.final.} = object of EntryClassObj
    input*: proc (spinButton: SpinButton; newValue: var cdouble): cint {.cdecl.}
    output*: proc (spinButton: SpinButton): cint {.cdecl.}
    valueChanged*: proc (spinButton: SpinButton) {.cdecl.}
    changeValue*: proc (spinButton: SpinButton; scroll: ScrollType) {.cdecl.}
    wrapped*: proc (spinButton: SpinButton) {.cdecl.}
    gtkReserved1161*: proc () {.cdecl.}
    gtkReserved1162*: proc () {.cdecl.}
    gtkReserved1163*: proc () {.cdecl.}
    gtkReserved1164*: proc () {.cdecl.}

proc distributeNaturalAllocation*(extraSpace: cint; nRequestedSizes: cuint;
                                    sizes: RequestedSize): cint {.
    importc: "gtk_distribute_natural_allocation", libgtk.}

template typeSpinButton*(): expr =
  (spinButtonGetType())

template spinButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSpinButton, SpinButtonObj))

template spinButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeSpinButton, SpinButtonClassObj))

template isSpinButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSpinButton))

template isSpinButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeSpinButton))

template spinButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSpinButton, SpinButtonClassObj))

const
  INPUT_ERROR* = - 1

type
  SpinButtonUpdatePolicy* {.size: sizeof(cint), pure.} = enum
    ALWAYS, IF_VALID

type
  SpinType* {.size: sizeof(cint), pure.} = enum
    STEP_FORWARD, STEP_BACKWARD, PAGE_FORWARD,
    PAGE_BACKWARD, HOME, `END`, USER_DEFINED

type
  Spinner* =  ptr SpinnerObj
  SpinnerPtr* = ptr SpinnerObj
  SpinnerObj*{.final.} = object of WidgetObj
    priv116: pointer

  SpinnerClass* =  ptr SpinnerClassObj
  SpinnerClassPtr* = ptr SpinnerClassObj
  SpinnerClassObj*{.final.} = object of WidgetClassObj
    gtkReserved1171*: proc () {.cdecl.}
    gtkReserved1172*: proc () {.cdecl.}
    gtkReserved1173*: proc () {.cdecl.}
    gtkReserved1174*: proc () {.cdecl.}

proc spinButtonGetType*(): GType {.importc: "gtk_spin_button_get_type",
                                   libgtk.}
proc configure*(spinButton: SpinButton;
                            adjustment: Adjustment; climbRate: cdouble;
                            digits: cuint) {.importc: "gtk_spin_button_configure",
    libgtk.}
proc newSpinButton*(adjustment: Adjustment; climbRate: cdouble;
                      digits: cuint): SpinButton {.
    importc: "gtk_spin_button_new", libgtk.}
proc setAdjustment*(spinButton: SpinButton;
                                adjustment: Adjustment) {.
    importc: "gtk_spin_button_set_adjustment", libgtk.}
proc `adjustment=`*(spinButton: SpinButton;
                                adjustment: Adjustment) {.
    importc: "gtk_spin_button_set_adjustment", libgtk.}
proc getAdjustment*(spinButton: SpinButton): Adjustment {.
    importc: "gtk_spin_button_get_adjustment", libgtk.}
proc adjustment*(spinButton: SpinButton): Adjustment {.
    importc: "gtk_spin_button_get_adjustment", libgtk.}
proc setDigits*(spinButton: SpinButton; digits: cuint) {.
    importc: "gtk_spin_button_set_digits", libgtk.}
proc `digits=`*(spinButton: SpinButton; digits: cuint) {.
    importc: "gtk_spin_button_set_digits", libgtk.}
proc getDigits*(spinButton: SpinButton): cuint {.
    importc: "gtk_spin_button_get_digits", libgtk.}
proc digits*(spinButton: SpinButton): cuint {.
    importc: "gtk_spin_button_get_digits", libgtk.}
proc setIncrements*(spinButton: SpinButton; step: cdouble;
                                page: cdouble) {.
    importc: "gtk_spin_button_set_increments", libgtk.}
proc `increments=`*(spinButton: SpinButton; step: cdouble;
                                page: cdouble) {.
    importc: "gtk_spin_button_set_increments", libgtk.}
proc getIncrements*(spinButton: SpinButton; step: var cdouble;
                                page: var cdouble) {.
    importc: "gtk_spin_button_get_increments", libgtk.}
proc setRange*(spinButton: SpinButton; min: cdouble; max: cdouble) {.
    importc: "gtk_spin_button_set_range", libgtk.}
proc `range=`*(spinButton: SpinButton; min: cdouble; max: cdouble) {.
    importc: "gtk_spin_button_set_range", libgtk.}
proc getRange*(spinButton: SpinButton; min: var cdouble;
                           max: var cdouble) {.
    importc: "gtk_spin_button_get_range", libgtk.}
proc getValue*(spinButton: SpinButton): cdouble {.
    importc: "gtk_spin_button_get_value", libgtk.}
proc value*(spinButton: SpinButton): cdouble {.
    importc: "gtk_spin_button_get_value", libgtk.}
proc getValueAsInt*(spinButton: SpinButton): cint {.
    importc: "gtk_spin_button_get_value_as_int", libgtk.}
proc valueAsInt*(spinButton: SpinButton): cint {.
    importc: "gtk_spin_button_get_value_as_int", libgtk.}
proc setValue*(spinButton: SpinButton; value: cdouble) {.
    importc: "gtk_spin_button_set_value", libgtk.}
proc `value=`*(spinButton: SpinButton; value: cdouble) {.
    importc: "gtk_spin_button_set_value", libgtk.}
proc setUpdatePolicy*(spinButton: SpinButton;
                                  policy: SpinButtonUpdatePolicy) {.
    importc: "gtk_spin_button_set_update_policy", libgtk.}
proc `updatePolicy=`*(spinButton: SpinButton;
                                  policy: SpinButtonUpdatePolicy) {.
    importc: "gtk_spin_button_set_update_policy", libgtk.}
proc getUpdatePolicy*(spinButton: SpinButton): SpinButtonUpdatePolicy {.
    importc: "gtk_spin_button_get_update_policy", libgtk.}
proc updatePolicy*(spinButton: SpinButton): SpinButtonUpdatePolicy {.
    importc: "gtk_spin_button_get_update_policy", libgtk.}
proc setNumeric*(spinButton: SpinButton; numeric: Gboolean) {.
    importc: "gtk_spin_button_set_numeric", libgtk.}
proc `numeric=`*(spinButton: SpinButton; numeric: Gboolean) {.
    importc: "gtk_spin_button_set_numeric", libgtk.}
proc getNumeric*(spinButton: SpinButton): Gboolean {.
    importc: "gtk_spin_button_get_numeric", libgtk.}
proc numeric*(spinButton: SpinButton): Gboolean {.
    importc: "gtk_spin_button_get_numeric", libgtk.}
proc spin*(spinButton: SpinButton; direction: SpinType;
                       increment: cdouble) {.importc: "gtk_spin_button_spin",
    libgtk.}
proc setWrap*(spinButton: SpinButton; wrap: Gboolean) {.
    importc: "gtk_spin_button_set_wrap", libgtk.}
proc `wrap=`*(spinButton: SpinButton; wrap: Gboolean) {.
    importc: "gtk_spin_button_set_wrap", libgtk.}
proc getWrap*(spinButton: SpinButton): Gboolean {.
    importc: "gtk_spin_button_get_wrap", libgtk.}
proc wrap*(spinButton: SpinButton): Gboolean {.
    importc: "gtk_spin_button_get_wrap", libgtk.}
proc setSnapToTicks*(spinButton: SpinButton;
                                 snapToTicks: Gboolean) {.
    importc: "gtk_spin_button_set_snap_to_ticks", libgtk.}
proc `snapToTicks=`*(spinButton: SpinButton;
                                 snapToTicks: Gboolean) {.
    importc: "gtk_spin_button_set_snap_to_ticks", libgtk.}
proc getSnapToTicks*(spinButton: SpinButton): Gboolean {.
    importc: "gtk_spin_button_get_snap_to_ticks", libgtk.}
proc snapToTicks*(spinButton: SpinButton): Gboolean {.
    importc: "gtk_spin_button_get_snap_to_ticks", libgtk.}
proc update*(spinButton: SpinButton) {.
    importc: "gtk_spin_button_update", libgtk.}

discard """ proc "getPanels*(spinButton: SpinButton;
                            downPanel: var gdk3.Window; upPanel: var gdk3.Window) {.
    importc: "_gtk_spin_button_get_panels", libgtk.}"""

template typeSpinner*(): expr =
  (spinnerGetType())

template spinner*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSpinner, SpinnerObj))

template spinnerClass*(obj: expr): expr =
  (gTypeCheckClassCast(obj, typeSpinner, SpinnerClassObj))

template isSpinner*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSpinner))

template isSpinnerClass*(obj: expr): expr =
  (gTypeCheckClassType(obj, typeSpinner))

template spinnerGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSpinner, SpinnerClassObj))

type
  StackSwitcher* =  ptr StackSwitcherObj
  StackSwitcherPtr* = ptr StackSwitcherObj
  StackSwitcherObj*{.final.} = object of BoxObj

  StackSwitcherClass* =  ptr StackSwitcherClassObj
  StackSwitcherClassPtr* = ptr StackSwitcherClassObj
  StackSwitcherClassObj*{.final.} = object of BoxClassObj
    gtkReserved1181*: proc () {.cdecl.}
    gtkReserved1182*: proc () {.cdecl.}
    gtkReserved1183*: proc () {.cdecl.}
    gtkReserved1184*: proc () {.cdecl.}

proc spinnerGetType*(): GType {.importc: "gtk_spinner_get_type", libgtk.}
proc newSpinner*(): Spinner {.importc: "gtk_spinner_new", libgtk.}
proc start*(spinner: Spinner) {.importc: "gtk_spinner_start",
    libgtk.}
proc stop*(spinner: Spinner) {.importc: "gtk_spinner_stop",
    libgtk.}

template typeStackSwitcher*(): expr =
  (stackSwitcherGetType())

template stackSwitcher*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeStackSwitcher, StackSwitcherObj))

template stackSwitcherClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeStackSwitcher, StackSwitcherClassObj))

template isStackSwitcher*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeStackSwitcher))

template isStackSwitcherClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeStackSwitcher))

template stackSwitcherGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeStackSwitcher, StackSwitcherClassObj))

type
  Statusbar* =  ptr StatusbarObj
  StatusbarPtr* = ptr StatusbarObj
  StatusbarObj* = object of BoxObj
    priv117: pointer

  StatusbarClass* =  ptr StatusbarClassObj
  StatusbarClassPtr* = ptr StatusbarClassObj
  StatusbarClassObj*{.final.} = object of BoxClassObj
    reserved: Gpointer
    textPushed*: proc (statusbar: Statusbar; contextId: cuint; text: cstring) {.cdecl.}
    textPopped*: proc (statusbar: Statusbar; contextId: cuint; text: cstring) {.cdecl.}
    gtkReserved1191*: proc () {.cdecl.}
    gtkReserved1192*: proc () {.cdecl.}
    gtkReserved1193*: proc () {.cdecl.}
    gtkReserved1194*: proc () {.cdecl.}

proc stackSwitcherGetType*(): GType {.importc: "gtk_stack_switcher_get_type",
                                      libgtk.}
proc newStackSwitcher*(): StackSwitcher {.importc: "gtk_stack_switcher_new",
    libgtk.}
proc setStack*(switcher: StackSwitcher; stack: Stack) {.
    importc: "gtk_stack_switcher_set_stack", libgtk.}
proc `stack=`*(switcher: StackSwitcher; stack: Stack) {.
    importc: "gtk_stack_switcher_set_stack", libgtk.}
proc getStack*(switcher: StackSwitcher): Stack {.
    importc: "gtk_stack_switcher_get_stack", libgtk.}
proc stack*(switcher: StackSwitcher): Stack {.
    importc: "gtk_stack_switcher_get_stack", libgtk.}

template typeStatusbar*(): expr =
  (statusbarGetType())

template statusbar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeStatusbar, StatusbarObj))

template statusbarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeStatusbar, StatusbarClassObj))

template isStatusbar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeStatusbar))

template isStatusbarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeStatusbar))

template statusbarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeStatusbar, StatusbarClassObj))

type
  Switch* =  ptr SwitchObj
  SwitchPtr* = ptr SwitchObj
  SwitchObj*{.final.} = object of WidgetObj
    priv118: pointer

  SwitchClass* =  ptr SwitchClassObj
  SwitchClassPtr* = ptr SwitchClassObj
  SwitchClassObj*{.final.} = object of WidgetClassObj
    activate*: proc (sw: Switch) {.cdecl.}
    stateSet*: proc (sw: Switch; state: Gboolean): Gboolean {.cdecl.}
    switchPadding1*: proc () {.cdecl.}
    switchPadding2*: proc () {.cdecl.}
    switchPadding3*: proc () {.cdecl.}
    switchPadding4*: proc () {.cdecl.}
    switchPadding5*: proc () {.cdecl.}

proc statusbarGetType*(): GType {.importc: "gtk_statusbar_get_type", libgtk.}
proc newStatusbar*(): Statusbar {.importc: "gtk_statusbar_new", libgtk.}

proc getContextId*(statusbar: Statusbar;
                              contextDescription: cstring): cuint {.
    importc: "gtk_statusbar_get_context_id", libgtk.}

proc contextId*(statusbar: Statusbar;
                              contextDescription: cstring): cuint {.
    importc: "gtk_statusbar_get_context_id", libgtk.}

proc push*(statusbar: Statusbar; contextId: cuint; text: cstring): cuint {.
    importc: "gtk_statusbar_push", libgtk.}
proc pop*(statusbar: Statusbar; contextId: cuint) {.
    importc: "gtk_statusbar_pop", libgtk.}
proc remove*(statusbar: Statusbar; contextId: cuint;
                        messageId: cuint) {.importc: "gtk_statusbar_remove",
    libgtk.}
proc removeAll*(statusbar: Statusbar; contextId: cuint) {.
    importc: "gtk_statusbar_remove_all", libgtk.}
proc getMessageArea*(statusbar: Statusbar): Widget {.
    importc: "gtk_statusbar_get_message_area", libgtk.}
proc messageArea*(statusbar: Statusbar): Widget {.
    importc: "gtk_statusbar_get_message_area", libgtk.}

template typeSwitch*(): expr =
  (switchGetType())

template switch*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeSwitch, SwitchObj))

template isSwitch*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeSwitch))

template switchClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeSwitch, SwitchClassObj))

template isSwitchClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeSwitch))

template switchGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeSwitch, SwitchClassObj))

type
  TextTagTable* =  ptr TextTagTableObj
  TextTagTablePtr* = ptr TextTagTableObj
  TextTagTableObj*{.final.} = object of GObjectObj
    priv119: pointer

  TextTagTableClass* =  ptr TextTagTableClassObj
  TextTagTableClassPtr* = ptr TextTagTableClassObj
  TextTagTableClassObj*{.final.} = object of GObjectClassObj
    tagChanged*: proc (table: TextTagTable; tag: TextTag;
                     sizeChanged: Gboolean) {.cdecl.}
    tagAdded*: proc (table: TextTagTable; tag: TextTag) {.cdecl.}
    tagRemoved*: proc (table: TextTagTable; tag: TextTag) {.cdecl.}
    gtkReserved1201*: proc () {.cdecl.}
    gtkReserved1202*: proc () {.cdecl.}
    gtkReserved1203*: proc () {.cdecl.}
    gtkReserved1204*: proc () {.cdecl.}

proc switchGetType*(): GType {.importc: "gtk_switch_get_type", libgtk.}
proc newSwitch*(): Switch {.importc: "gtk_switch_new", libgtk.}
proc setActive*(sw: Switch; isActive: Gboolean) {.
    importc: "gtk_switch_set_active", libgtk.}
proc `active=`*(sw: Switch; isActive: Gboolean) {.
    importc: "gtk_switch_set_active", libgtk.}
proc getActive*(sw: Switch): Gboolean {.
    importc: "gtk_switch_get_active", libgtk.}
proc active*(sw: Switch): Gboolean {.
    importc: "gtk_switch_get_active", libgtk.}
proc setState*(sw: Switch; state: Gboolean) {.
    importc: "gtk_switch_set_state", libgtk.}
proc `state=`*(sw: Switch; state: Gboolean) {.
    importc: "gtk_switch_set_state", libgtk.}
proc getState*(sw: Switch): Gboolean {.
    importc: "gtk_switch_get_state", libgtk.}
proc state*(sw: Switch): Gboolean {.
    importc: "gtk_switch_get_state", libgtk.}

type
  TextTagTableForeach* = proc (tag: TextTag; data: Gpointer) {.cdecl.}

template typeTextTagTable*(): expr =
  (textTagTableGetType())

template textTagTable*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTextTagTable, TextTagTableObj))

template textTagTableClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTextTagTable, TextTagTableClassObj))

template isTextTagTable*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTextTagTable))

template isTextTagTableClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTextTagTable))

template textTagTableGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTextTagTable, TextTagTableClassObj))

type
  TextMark* =  ptr TextMarkObj
  TextMarkPtr* = ptr TextMarkObj
  TextMarkObj* = object of GObjectObj
    segment*: Gpointer

  TextMarkClass* =  ptr TextMarkClassObj
  TextMarkClassPtr* = ptr TextMarkClassObj
  TextMarkClassObj* = object of GObjectClassObj
    gtkReserved1211*: proc () {.cdecl.}
    gtkReserved1212*: proc () {.cdecl.}
    gtkReserved1213*: proc () {.cdecl.}
    gtkReserved1214*: proc () {.cdecl.}

proc textTagTableGetType*(): GType {.importc: "gtk_text_tag_table_get_type",
                                     libgtk.}
proc newTextTagTable*(): TextTagTable {.importc: "gtk_text_tag_table_new",
    libgtk.}
proc add*(table: TextTagTable; tag: TextTag): Gboolean {.
    importc: "gtk_text_tag_table_add", libgtk.}
proc remove*(table: TextTagTable; tag: TextTag) {.
    importc: "gtk_text_tag_table_remove", libgtk.}
proc lookup*(table: TextTagTable; name: cstring): TextTag {.
    importc: "gtk_text_tag_table_lookup", libgtk.}
proc foreach*(table: TextTagTable;
                            `func`: TextTagTableForeach; data: Gpointer) {.
    importc: "gtk_text_tag_table_foreach", libgtk.}
proc getSize*(table: TextTagTable): cint {.
    importc: "gtk_text_tag_table_get_size", libgtk.}
proc size*(table: TextTagTable): cint {.
    importc: "gtk_text_tag_table_get_size", libgtk.}

discard """ proc "addBuffer*(table: TextTagTable; buffer: Gpointer) {.
    importc: "_gtk_text_tag_table_add_buffer", libgtk.}"""

discard """ proc "removeBuffer*(table: TextTagTable; buffer: Gpointer) {.
    importc: "_gtk_text_tag_table_remove_buffer", libgtk.}"""

template typeTextMark*(): expr =
  (textMarkGetType())

template textMark*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeTextMark, TextMarkObj))

template textMarkClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTextMark, TextMarkClassObj))

template isTextMark*(`object`: expr): expr =
  (gTypeCheckInstanceType(`object`, typeTextMark))

template isTextMarkClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTextMark))

template textMarkGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTextMark, TextMarkClassObj))

proc textMarkGetType*(): GType {.importc: "gtk_text_mark_get_type", libgtk.}
proc newTextMark*(name: cstring; leftGravity: Gboolean): TextMark {.
    importc: "gtk_text_mark_new", libgtk.}
proc setVisible*(mark: TextMark; setting: Gboolean) {.
    importc: "gtk_text_mark_set_visible", libgtk.}
proc `visible=`*(mark: TextMark; setting: Gboolean) {.
    importc: "gtk_text_mark_set_visible", libgtk.}
proc getVisible*(mark: TextMark): Gboolean {.
    importc: "gtk_text_mark_get_visible", libgtk.}
proc visible*(mark: TextMark): Gboolean {.
    importc: "gtk_text_mark_get_visible", libgtk.}
proc getName*(mark: TextMark): cstring {.
    importc: "gtk_text_mark_get_name", libgtk.}
proc name*(mark: TextMark): cstring {.
    importc: "gtk_text_mark_get_name", libgtk.}
proc getDeleted*(mark: TextMark): Gboolean {.
    importc: "gtk_text_mark_get_deleted", libgtk.}
proc deleted*(mark: TextMark): Gboolean {.
    importc: "gtk_text_mark_get_deleted", libgtk.}
proc getBuffer*(mark: TextMark): TextBuffer {.
    importc: "gtk_text_mark_get_buffer", libgtk.}
proc buffer*(mark: TextMark): TextBuffer {.
    importc: "gtk_text_mark_get_buffer", libgtk.}
proc getLeftGravity*(mark: TextMark): Gboolean {.
    importc: "gtk_text_mark_get_left_gravity", libgtk.}
proc leftGravity*(mark: TextMark): Gboolean {.
    importc: "gtk_text_mark_get_left_gravity", libgtk.}

type
  TextBufferTargetInfo* {.size: sizeof(cint), pure.} = enum
    TEXT = - 3,
    RICH_TEXT = - 2,
    BUFFER_CONTENTS = - 1

type
  TextBufferClass* =  ptr TextBufferClassObj
  TextBufferClassPtr* = ptr TextBufferClassObj
  TextBufferClassObj* = object of GObjectClassObj
    insertText*: proc (buffer: TextBuffer; pos: TextIter;
                     newText: cstring; newTextLength: cint) {.cdecl.}
    insertPixbuf*: proc (buffer: TextBuffer; iter: TextIter;
                       pixbuf: GdkPixbuf) {.cdecl.}
    insertChildAnchor*: proc (buffer: TextBuffer; iter: TextIter;
                            anchor: TextChildAnchor) {.cdecl.}
    deleteRange*: proc (buffer: TextBuffer; start: TextIter;
                      `end`: TextIter) {.cdecl.}
    changed*: proc (buffer: TextBuffer) {.cdecl.}
    modifiedChanged*: proc (buffer: TextBuffer) {.cdecl.}
    markSet*: proc (buffer: TextBuffer; location: TextIter;
                  mark: TextMark) {.cdecl.}
    markDeleted*: proc (buffer: TextBuffer; mark: TextMark) {.cdecl.}
    applyTag*: proc (buffer: TextBuffer; tag: TextTag;
                   start: TextIter; `end`: TextIter) {.cdecl.}
    removeTag*: proc (buffer: TextBuffer; tag: TextTag;
                    start: TextIter; `end`: TextIter) {.cdecl.}
    beginUserAction*: proc (buffer: TextBuffer) {.cdecl.}
    endUserAction*: proc (buffer: TextBuffer) {.cdecl.}
    pasteDone*: proc (buffer: TextBuffer; clipboard: Clipboard) {.cdecl.}
    gtkReserved1221*: proc () {.cdecl.}
    gtkReserved1222*: proc () {.cdecl.}
    gtkReserved1223*: proc () {.cdecl.}
    gtkReserved1224*: proc () {.cdecl.}

  TextBTree* =  ptr TextBTreeObj
  TextBTreePtr* = ptr TextBTreeObj
  TextBTreeObj* = object

template typeTextBuffer*(): expr =
  (textBufferGetType())

template textBuffer*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTextBuffer, TextBufferObj))

template textBufferClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTextBuffer, TextBufferClassObj))

template isTextBuffer*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTextBuffer))

template isTextBufferClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTextBuffer))

template textBufferGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTextBuffer, TextBufferClassObj))

type
  TextViewLayer* {.size: sizeof(cint), pure.} = enum
    BELOW, ABOVE,
    BELOW_TEXT, ABOVE_TEXT
type
  TextExtendSelection* {.size: sizeof(cint), pure.} = enum
    WORD, LINE
type
  TextView* =  ptr TextViewObj
  TextViewPtr* = ptr TextViewObj
  TextViewObj* = object of ContainerObj
    priv120: pointer

  TextViewClass* =  ptr TextViewClassObj
  TextViewClassPtr* = ptr TextViewClassObj
  TextViewClassObj* = object of ContainerClassObj
    populatePopup*: proc (textView: TextView; popup: Widget) {.cdecl.}
    moveCursor*: proc (textView: TextView; step: MovementStep; count: cint;
                     extendSelection: Gboolean) {.cdecl.}
    setAnchor*: proc (textView: TextView) {.cdecl.}
    insertAtCursor*: proc (textView: TextView; str: cstring) {.cdecl.}
    deleteFromCursor*: proc (textView: TextView; `type`: DeleteType;
                           count: cint) {.cdecl.}
    backspace*: proc (textView: TextView) {.cdecl.}
    cutClipboard*: proc (textView: TextView) {.cdecl.}
    copyClipboard*: proc (textView: TextView) {.cdecl.}
    pasteClipboard*: proc (textView: TextView) {.cdecl.}
    toggleOverwrite*: proc (textView: TextView) {.cdecl.}
    createBuffer*: proc (textView: TextView): TextBuffer {.cdecl.}
    drawLayer*: proc (textView: TextView; layer: TextViewLayer;
                    cr: cairo.Context) {.cdecl.}
    extendSelection*: proc (textView: TextView;
                          granularity: TextExtendSelection;
                          location: TextIter; start: TextIter;
                          `end`: TextIter): Gboolean {.cdecl.}
    gtkReserved1231*: proc () {.cdecl.}
    gtkReserved1232*: proc () {.cdecl.}
    gtkReserved1233*: proc () {.cdecl.}
    gtkReserved1234*: proc () {.cdecl.}
    gtkReserved1235*: proc () {.cdecl.}

proc textBufferGetType*(): GType {.importc: "gtk_text_buffer_get_type",
                                   libgtk.}

proc newTextBuffer*(table: TextTagTable): TextBuffer {.
    importc: "gtk_text_buffer_new", libgtk.}
proc getLineCount*(buffer: TextBuffer): cint {.
    importc: "gtk_text_buffer_get_line_count", libgtk.}
proc lineCount*(buffer: TextBuffer): cint {.
    importc: "gtk_text_buffer_get_line_count", libgtk.}
proc getCharCount*(buffer: TextBuffer): cint {.
    importc: "gtk_text_buffer_get_char_count", libgtk.}
proc charCount*(buffer: TextBuffer): cint {.
    importc: "gtk_text_buffer_get_char_count", libgtk.}
proc getTagTable*(buffer: TextBuffer): TextTagTable {.
    importc: "gtk_text_buffer_get_tag_table", libgtk.}
proc tagTable*(buffer: TextBuffer): TextTagTable {.
    importc: "gtk_text_buffer_get_tag_table", libgtk.}

proc setText*(buffer: TextBuffer; text: cstring; len: cint) {.
    importc: "gtk_text_buffer_set_text", libgtk.}

proc `text=`*(buffer: TextBuffer; text: cstring; len: cint) {.
    importc: "gtk_text_buffer_set_text", libgtk.}

proc insert*(buffer: TextBuffer; iter: TextIter;
                         text: cstring; len: cint) {.
    importc: "gtk_text_buffer_insert", libgtk.}
proc insertAtCursor*(buffer: TextBuffer; text: cstring; len: cint) {.
    importc: "gtk_text_buffer_insert_at_cursor", libgtk.}
proc insertInteractive*(buffer: TextBuffer;
                                    iter: TextIter; text: cstring; len: cint;
                                    defaultEditable: Gboolean): Gboolean {.
    importc: "gtk_text_buffer_insert_interactive", libgtk.}
proc insertInteractiveAtCursor*(buffer: TextBuffer;
    text: cstring; len: cint; defaultEditable: Gboolean): Gboolean {.
    importc: "gtk_text_buffer_insert_interactive_at_cursor", libgtk.}
proc insertRange*(buffer: TextBuffer; iter: TextIter;
                              start: TextIter; `end`: TextIter) {.
    importc: "gtk_text_buffer_insert_range", libgtk.}
proc insertRangeInteractive*(buffer: TextBuffer;
    iter: TextIter; start: TextIter; `end`: TextIter;
    defaultEditable: Gboolean): Gboolean {.importc: "gtk_text_buffer_insert_range_interactive",
                                        libgtk.}
proc insertWithTags*(buffer: TextBuffer; iter: TextIter;
                                 text: cstring; len: cint; firstTag: TextTag) {.
    varargs, importc: "gtk_text_buffer_insert_with_tags", libgtk.}
proc insertWithTagsByName*(buffer: TextBuffer;
                                       iter: TextIter; text: cstring;
                                       len: cint; firstTagName: cstring) {.varargs,
    importc: "gtk_text_buffer_insert_with_tags_by_name", libgtk.}
proc insertMarkup*(buffer: TextBuffer; iter: TextIter;
                               markup: cstring; len: cint) {.
    importc: "gtk_text_buffer_insert_markup", libgtk.}

proc delete*(buffer: TextBuffer; start: TextIter;
                         `end`: TextIter) {.
    importc: "gtk_text_buffer_delete", libgtk.}
proc deleteInteractive*(buffer: TextBuffer;
                                    startIter: TextIter;
                                    endIter: TextIter;
                                    defaultEditable: Gboolean): Gboolean {.
    importc: "gtk_text_buffer_delete_interactive", libgtk.}
proc backspace*(buffer: TextBuffer; iter: TextIter;
                            interactive: Gboolean; defaultEditable: Gboolean): Gboolean {.
    importc: "gtk_text_buffer_backspace", libgtk.}

proc getText*(buffer: TextBuffer; start: TextIter;
                          `end`: TextIter; includeHiddenChars: Gboolean): cstring {.
    importc: "gtk_text_buffer_get_text", libgtk.}

proc text*(buffer: TextBuffer; start: TextIter;
                          `end`: TextIter; includeHiddenChars: Gboolean): cstring {.
    importc: "gtk_text_buffer_get_text", libgtk.}
proc getSlice*(buffer: TextBuffer; start: TextIter;
                           `end`: TextIter; includeHiddenChars: Gboolean): cstring {.
    importc: "gtk_text_buffer_get_slice", libgtk.}
proc slice*(buffer: TextBuffer; start: TextIter;
                           `end`: TextIter; includeHiddenChars: Gboolean): cstring {.
    importc: "gtk_text_buffer_get_slice", libgtk.}

proc insertPixbuf*(buffer: TextBuffer; iter: TextIter;
                               pixbuf: GdkPixbuf) {.
    importc: "gtk_text_buffer_insert_pixbuf", libgtk.}

proc insertChildAnchor*(buffer: TextBuffer;
                                    iter: TextIter;
                                    anchor: TextChildAnchor) {.
    importc: "gtk_text_buffer_insert_child_anchor", libgtk.}

proc createChildAnchor*(buffer: TextBuffer;
                                    iter: TextIter): TextChildAnchor {.
    importc: "gtk_text_buffer_create_child_anchor", libgtk.}

proc addMark*(buffer: TextBuffer; mark: TextMark;
                          where: TextIter) {.
    importc: "gtk_text_buffer_add_mark", libgtk.}
proc createMark*(buffer: TextBuffer; markName: cstring;
                             where: TextIter; leftGravity: Gboolean): TextMark {.
    importc: "gtk_text_buffer_create_mark", libgtk.}
proc moveMark*(buffer: TextBuffer; mark: TextMark;
                           where: TextIter) {.
    importc: "gtk_text_buffer_move_mark", libgtk.}
proc deleteMark*(buffer: TextBuffer; mark: TextMark) {.
    importc: "gtk_text_buffer_delete_mark", libgtk.}
proc getMark*(buffer: TextBuffer; name: cstring): TextMark {.
    importc: "gtk_text_buffer_get_mark", libgtk.}
proc mark*(buffer: TextBuffer; name: cstring): TextMark {.
    importc: "gtk_text_buffer_get_mark", libgtk.}
proc moveMarkByName*(buffer: TextBuffer; name: cstring;
                                 where: TextIter) {.
    importc: "gtk_text_buffer_move_mark_by_name", libgtk.}
proc deleteMarkByName*(buffer: TextBuffer; name: cstring) {.
    importc: "gtk_text_buffer_delete_mark_by_name", libgtk.}
proc getInsert*(buffer: TextBuffer): TextMark {.
    importc: "gtk_text_buffer_get_insert", libgtk.}
proc insert*(buffer: TextBuffer): TextMark {.
    importc: "gtk_text_buffer_get_insert", libgtk.}
proc getSelectionBound*(buffer: TextBuffer): TextMark {.
    importc: "gtk_text_buffer_get_selection_bound", libgtk.}
proc selectionBound*(buffer: TextBuffer): TextMark {.
    importc: "gtk_text_buffer_get_selection_bound", libgtk.}

proc placeCursor*(buffer: TextBuffer; where: TextIter) {.
    importc: "gtk_text_buffer_place_cursor", libgtk.}
proc selectRange*(buffer: TextBuffer; ins: TextIter;
                              bound: TextIter) {.
    importc: "gtk_text_buffer_select_range", libgtk.}

proc applyTag*(buffer: TextBuffer; tag: TextTag;
                           start: TextIter; `end`: TextIter) {.
    importc: "gtk_text_buffer_apply_tag", libgtk.}
proc removeTag*(buffer: TextBuffer; tag: TextTag;
                            start: TextIter; `end`: TextIter) {.
    importc: "gtk_text_buffer_remove_tag", libgtk.}
proc applyTagByName*(buffer: TextBuffer; name: cstring;
                                 start: TextIter; `end`: TextIter) {.
    importc: "gtk_text_buffer_apply_tag_by_name", libgtk.}
proc removeTagByName*(buffer: TextBuffer; name: cstring;
                                  start: TextIter; `end`: TextIter) {.
    importc: "gtk_text_buffer_remove_tag_by_name", libgtk.}
proc removeAllTags*(buffer: TextBuffer; start: TextIter;
                                `end`: TextIter) {.
    importc: "gtk_text_buffer_remove_all_tags", libgtk.}

proc createTag*(buffer: TextBuffer; tagName: cstring;
                            firstPropertyName: cstring): TextTag {.varargs,
    importc: "gtk_text_buffer_create_tag", libgtk.}

proc getIterAtLineOffset*(buffer: TextBuffer;
                                      iter: TextIter; lineNumber: cint;
                                      charOffset: cint) {.
    importc: "gtk_text_buffer_get_iter_at_line_offset", libgtk.}
proc getIterAtLineIndex*(buffer: TextBuffer;
                                     iter: TextIter; lineNumber: cint;
                                     byteIndex: cint) {.
    importc: "gtk_text_buffer_get_iter_at_line_index", libgtk.}
proc getIterAtOffset*(buffer: TextBuffer; iter: TextIter;
                                  charOffset: cint) {.
    importc: "gtk_text_buffer_get_iter_at_offset", libgtk.}
proc getIterAtLine*(buffer: TextBuffer; iter: TextIter;
                                lineNumber: cint) {.
    importc: "gtk_text_buffer_get_iter_at_line", libgtk.}
proc getStartIter*(buffer: TextBuffer; iter: var TextIterObj) {.
    importc: "gtk_text_buffer_get_start_iter", libgtk.}
proc getEndIter*(buffer: TextBuffer; iter: var TextIterObj) {.
    importc: "gtk_text_buffer_get_end_iter", libgtk.}
proc getBounds*(buffer: TextBuffer; start: TextIter;
                            `end`: TextIter) {.
    importc: "gtk_text_buffer_get_bounds", libgtk.}
proc getIterAtMark*(buffer: TextBuffer; iter: TextIter;
                                mark: TextMark) {.
    importc: "gtk_text_buffer_get_iter_at_mark", libgtk.}
proc getIterAtChildAnchor*(buffer: TextBuffer;
                                       iter: TextIter;
                                       anchor: TextChildAnchor) {.
    importc: "gtk_text_buffer_get_iter_at_child_anchor", libgtk.}

proc getModified*(buffer: TextBuffer): Gboolean {.
    importc: "gtk_text_buffer_get_modified", libgtk.}

proc modified*(buffer: TextBuffer): Gboolean {.
    importc: "gtk_text_buffer_get_modified", libgtk.}
proc setModified*(buffer: TextBuffer; setting: Gboolean) {.
    importc: "gtk_text_buffer_set_modified", libgtk.}
proc `modified=`*(buffer: TextBuffer; setting: Gboolean) {.
    importc: "gtk_text_buffer_set_modified", libgtk.}
proc getHasSelection*(buffer: TextBuffer): Gboolean {.
    importc: "gtk_text_buffer_get_has_selection", libgtk.}
proc hasSelection*(buffer: TextBuffer): Gboolean {.
    importc: "gtk_text_buffer_get_has_selection", libgtk.}
proc addSelectionClipboard*(buffer: TextBuffer;
                                        clipboard: Clipboard) {.
    importc: "gtk_text_buffer_add_selection_clipboard", libgtk.}
proc removeSelectionClipboard*(buffer: TextBuffer;
    clipboard: Clipboard) {.importc: "gtk_text_buffer_remove_selection_clipboard",
                                libgtk.}
proc cutClipboard*(buffer: TextBuffer;
                               clipboard: Clipboard;
                               defaultEditable: Gboolean) {.
    importc: "gtk_text_buffer_cut_clipboard", libgtk.}
proc copyClipboard*(buffer: TextBuffer;
                                clipboard: Clipboard) {.
    importc: "gtk_text_buffer_copy_clipboard", libgtk.}
proc pasteClipboard*(buffer: TextBuffer;
                                 clipboard: Clipboard;
                                 overrideLocation: TextIter;
                                 defaultEditable: Gboolean) {.
    importc: "gtk_text_buffer_paste_clipboard", libgtk.}
proc getSelectionBounds*(buffer: TextBuffer;
                                     start: TextIter; `end`: TextIter): Gboolean {.
    importc: "gtk_text_buffer_get_selection_bounds", libgtk.}
proc selectionBounds*(buffer: TextBuffer;
                                     start: TextIter; `end`: TextIter): Gboolean {.
    importc: "gtk_text_buffer_get_selection_bounds", libgtk.}
proc deleteSelection*(buffer: TextBuffer; interactive: Gboolean;
                                  defaultEditable: Gboolean): Gboolean {.
    importc: "gtk_text_buffer_delete_selection", libgtk.}

proc beginUserAction*(buffer: TextBuffer) {.
    importc: "gtk_text_buffer_begin_user_action", libgtk.}
proc endUserAction*(buffer: TextBuffer) {.
    importc: "gtk_text_buffer_end_user_action", libgtk.}
proc getCopyTargetList*(buffer: TextBuffer): TargetList {.
    importc: "gtk_text_buffer_get_copy_target_list", libgtk.}
proc copyTargetList*(buffer: TextBuffer): TargetList {.
    importc: "gtk_text_buffer_get_copy_target_list", libgtk.}
proc getPasteTargetList*(buffer: TextBuffer): TargetList {.
    importc: "gtk_text_buffer_get_paste_target_list", libgtk.}
proc pasteTargetList*(buffer: TextBuffer): TargetList {.
    importc: "gtk_text_buffer_get_paste_target_list", libgtk.}

type
  TextBufferSerializeFunc* = proc (registerBuffer: TextBuffer;
                                   contentBuffer: TextBuffer;
                                   start: TextIter; `end`: TextIter;
                                   length: ptr Gsize; userData: Gpointer): ptr uint8 {.cdecl.}

type
  TextBufferDeserializeFunc* = proc (registerBuffer: TextBuffer;
                                     contentBuffer: TextBuffer;
                                     iter: TextIter; data: var uint8;
                                     length: Gsize; createTags: Gboolean;
                                     userData: Gpointer; error: var glib.GError): Gboolean {.cdecl.}

proc registerSerializeFormat*(buffer: TextBuffer;
    mimeType: cstring; function: TextBufferSerializeFunc; userData: Gpointer;
    userDataDestroy: GDestroyNotify): gdk3.Atom {.
    importc: "gtk_text_buffer_register_serialize_format", libgtk.}
proc registerSerializeTagset*(buffer: TextBuffer;
    tagsetName: cstring): gdk3.Atom {.importc: "gtk_text_buffer_register_serialize_tagset",
                                 libgtk.}
proc registerDeserializeFormat*(buffer: TextBuffer;
    mimeType: cstring; function: TextBufferDeserializeFunc; userData: Gpointer;
    userDataDestroy: GDestroyNotify): gdk3.Atom {.
    importc: "gtk_text_buffer_register_deserialize_format", libgtk.}
proc registerDeserializeTagset*(buffer: TextBuffer;
    tagsetName: cstring): gdk3.Atom {.importc: "gtk_text_buffer_register_deserialize_tagset",
                                 libgtk.}
proc unregisterSerializeFormat*(buffer: TextBuffer;
    format: gdk3.Atom) {.importc: "gtk_text_buffer_unregister_serialize_format",
                     libgtk.}
proc unregisterDeserializeFormat*(buffer: TextBuffer;
    format: gdk3.Atom) {.importc: "gtk_text_buffer_unregister_deserialize_format",
                     libgtk.}
proc deserializeSetCanCreateTags*(buffer: TextBuffer;
    format: gdk3.Atom; canCreateTags: Gboolean) {.
    importc: "gtk_text_buffer_deserialize_set_can_create_tags", libgtk.}
proc deserializeGetCanCreateTags*(buffer: TextBuffer;
    format: gdk3.Atom): Gboolean {.importc: "gtk_text_buffer_deserialize_get_can_create_tags",
                              libgtk.}
proc getSerializeFormats*(buffer: TextBuffer; nFormats: var cint): ptr gdk3.Atom {.
    importc: "gtk_text_buffer_get_serialize_formats", libgtk.}
proc serializeFormats*(buffer: TextBuffer; nFormats: var cint): ptr gdk3.Atom {.
    importc: "gtk_text_buffer_get_serialize_formats", libgtk.}
proc getDeserializeFormats*(buffer: TextBuffer;
                                        nFormats: var cint): ptr gdk3.Atom {.
    importc: "gtk_text_buffer_get_deserialize_formats", libgtk.}
proc deserializeFormats*(buffer: TextBuffer;
                                        nFormats: var cint): ptr gdk3.Atom {.
    importc: "gtk_text_buffer_get_deserialize_formats", libgtk.}
proc serialize*(registerBuffer: TextBuffer;
                            contentBuffer: TextBuffer; format: gdk3.Atom;
                            start: TextIter; `end`: TextIter;
                            length: ptr Gsize): ptr uint8 {.
    importc: "gtk_text_buffer_serialize", libgtk.}
proc deserialize*(registerBuffer: TextBuffer;
                              contentBuffer: TextBuffer; format: gdk3.Atom;
                              iter: TextIter; data: var uint8; length: Gsize;
                              error: var glib.GError): Gboolean {.
    importc: "gtk_text_buffer_deserialize", libgtk.}

template typeTextView*(): expr =
  (textViewGetType())

template textView*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTextView, TextViewObj))

template textViewClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTextView, TextViewClassObj))

template isTextView*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTextView))

template isTextViewClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTextView))

template textViewGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTextView, TextViewClassObj))

type
  TextWindowType* {.size: sizeof(cint), pure.} = enum
    PRIVATE, WIDGET, TEXT,
    LEFT, RIGHT, TOP,
    BOTTOM

type
  Toolbar* =  ptr ToolbarObj
  ToolbarPtr* = ptr ToolbarObj
  ToolbarObj*{.final.} = object of ContainerObj
    priv121: pointer

  ToolbarClass* =  ptr ToolbarClassObj
  ToolbarClassPtr* = ptr ToolbarClassObj
  ToolbarClassObj*{.final.} = object of ContainerClassObj
    orientationChanged*: proc (toolbar: Toolbar; orientation: Orientation) {.cdecl.}
    styleChanged*: proc (toolbar: Toolbar; style: ToolbarStyle) {.cdecl.}
    popupContextMenu*: proc (toolbar: Toolbar; x: cint; y: cint;
                           buttonNumber: cint): Gboolean {.cdecl.}
    gtkReserved1241*: proc () {.cdecl.}
    gtkReserved1242*: proc () {.cdecl.}
    gtkReserved1243*: proc () {.cdecl.}
    gtkReserved1244*: proc () {.cdecl.}

proc textViewGetType*(): GType {.importc: "gtk_text_view_get_type", libgtk.}
proc newTextView*(): TextView {.importc: "gtk_text_view_new", libgtk.}
proc setBuffer*(textView: TextView; buffer: TextBuffer) {.
    importc: "gtk_text_view_set_buffer", libgtk.}
proc `buffer=`*(textView: TextView; buffer: TextBuffer) {.
    importc: "gtk_text_view_set_buffer", libgtk.}
proc getBuffer*(textView: TextView): TextBuffer {.
    importc: "gtk_text_view_get_buffer", libgtk.}
proc buffer*(textView: TextView): TextBuffer {.
    importc: "gtk_text_view_get_buffer", libgtk.}
proc scrollToIter*(textView: TextView; iter: TextIter;
                             withinMargin: cdouble; useAlign: Gboolean;
                             xalign: cdouble; yalign: cdouble): Gboolean {.
    importc: "gtk_text_view_scroll_to_iter", libgtk.}
proc scrollToMark*(textView: TextView; mark: TextMark;
                             withinMargin: cdouble; useAlign: Gboolean;
                             xalign: cdouble; yalign: cdouble) {.
    importc: "gtk_text_view_scroll_to_mark", libgtk.}
proc scrollMarkOnscreen*(textView: TextView; mark: TextMark) {.
    importc: "gtk_text_view_scroll_mark_onscreen", libgtk.}
proc moveMarkOnscreen*(textView: TextView; mark: TextMark): Gboolean {.
    importc: "gtk_text_view_move_mark_onscreen", libgtk.}
proc placeCursorOnscreen*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_place_cursor_onscreen", libgtk.}
proc getVisibleRect*(textView: TextView;
                               visibleRect: gdk3.Rectangle) {.
    importc: "gtk_text_view_get_visible_rect", libgtk.}
proc setCursorVisible*(textView: TextView; setting: Gboolean) {.
    importc: "gtk_text_view_set_cursor_visible", libgtk.}
proc `cursorVisible=`*(textView: TextView; setting: Gboolean) {.
    importc: "gtk_text_view_set_cursor_visible", libgtk.}
proc getCursorVisible*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_cursor_visible", libgtk.}
proc cursorVisible*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_cursor_visible", libgtk.}
proc resetCursorBlink*(textView: TextView) {.
    importc: "gtk_text_view_reset_cursor_blink", libgtk.}
proc getCursorLocations*(textView: TextView;
                                   iter: TextIter; strong: gdk3.Rectangle;
                                   weak: gdk3.Rectangle) {.
    importc: "gtk_text_view_get_cursor_locations", libgtk.}
proc getIterLocation*(textView: TextView; iter: TextIter;
                                location: gdk3.Rectangle) {.
    importc: "gtk_text_view_get_iter_location", libgtk.}
proc getIterAtLocation*(textView: TextView; iter: TextIter;
                                  x: cint; y: cint): Gboolean {.
    importc: "gtk_text_view_get_iter_at_location", libgtk.}
proc iterAtLocation*(textView: TextView; iter: TextIter;
                                  x: cint; y: cint): Gboolean {.
    importc: "gtk_text_view_get_iter_at_location", libgtk.}
proc getIterAtPosition*(textView: TextView; iter: TextIter;
                                  trailing: var cint; x: cint; y: cint): Gboolean {.
    importc: "gtk_text_view_get_iter_at_position", libgtk.}
proc iterAtPosition*(textView: TextView; iter: TextIter;
                                  trailing: var cint; x: cint; y: cint): Gboolean {.
    importc: "gtk_text_view_get_iter_at_position", libgtk.}
proc getLineYrange*(textView: TextView; iter: TextIter;
                              y: var cint; height: var cint) {.
    importc: "gtk_text_view_get_line_yrange", libgtk.}
proc getLineAtY*(textView: TextView; targetIter: TextIter;
                           y: cint; lineTop: var cint) {.
    importc: "gtk_text_view_get_line_at_y", libgtk.}
proc bufferToWindowCoords*(textView: TextView;
                                     win: TextWindowType; bufferX: cint;
                                     bufferY: cint; windowX: var cint;
                                     windowY: var cint) {.
    importc: "gtk_text_view_buffer_to_window_coords", libgtk.}
proc windowToBufferCoords*(textView: TextView;
                                     win: TextWindowType; windowX: cint;
                                     windowY: cint; bufferX: var cint;
                                     bufferY: var cint) {.
    importc: "gtk_text_view_window_to_buffer_coords", libgtk.}
proc getHadjustment*(textView: TextView): Adjustment {.
    importc: "gtk_text_view_get_hadjustment", libgtk.}
proc hadjustment*(textView: TextView): Adjustment {.
    importc: "gtk_text_view_get_hadjustment", libgtk.}
proc getVadjustment*(textView: TextView): Adjustment {.
    importc: "gtk_text_view_get_vadjustment", libgtk.}
proc vadjustment*(textView: TextView): Adjustment {.
    importc: "gtk_text_view_get_vadjustment", libgtk.}
proc getWindow*(textView: TextView; win: TextWindowType): gdk3.Window {.
    importc: "gtk_text_view_get_window", libgtk.}
proc window*(textView: TextView; win: TextWindowType): gdk3.Window {.
    importc: "gtk_text_view_get_window", libgtk.}
proc getWindowType*(textView: TextView; window: gdk3.Window): TextWindowType {.
    importc: "gtk_text_view_get_window_type", libgtk.}
proc windowType*(textView: TextView; window: gdk3.Window): TextWindowType {.
    importc: "gtk_text_view_get_window_type", libgtk.}
proc setBorderWindowSize*(textView: TextView;
                                    `type`: TextWindowType; size: cint) {.
    importc: "gtk_text_view_set_border_window_size", libgtk.}
proc `borderWindowSize=`*(textView: TextView;
                                    `type`: TextWindowType; size: cint) {.
    importc: "gtk_text_view_set_border_window_size", libgtk.}
proc getBorderWindowSize*(textView: TextView;
                                    `type`: TextWindowType): cint {.
    importc: "gtk_text_view_get_border_window_size", libgtk.}
proc borderWindowSize*(textView: TextView;
                                    `type`: TextWindowType): cint {.
    importc: "gtk_text_view_get_border_window_size", libgtk.}
proc forwardDisplayLine*(textView: TextView; iter: TextIter): Gboolean {.
    importc: "gtk_text_view_forward_display_line", libgtk.}
proc backwardDisplayLine*(textView: TextView;
                                    iter: TextIter): Gboolean {.
    importc: "gtk_text_view_backward_display_line", libgtk.}
proc forwardDisplayLineEnd*(textView: TextView;
                                      iter: TextIter): Gboolean {.
    importc: "gtk_text_view_forward_display_line_end", libgtk.}
proc backwardDisplayLineStart*(textView: TextView;
    iter: TextIter): Gboolean {.importc: "gtk_text_view_backward_display_line_start",
                                   libgtk.}
proc startsDisplayLine*(textView: TextView; iter: TextIter): Gboolean {.
    importc: "gtk_text_view_starts_display_line", libgtk.}
proc moveVisually*(textView: TextView; iter: TextIter;
                             count: cint): Gboolean {.
    importc: "gtk_text_view_move_visually", libgtk.}
proc imContextFilterKeypress*(textView: TextView;
                                        event: gdk3.EventKey): Gboolean {.
    importc: "gtk_text_view_im_context_filter_keypress", libgtk.}
proc resetImContext*(textView: TextView) {.
    importc: "gtk_text_view_reset_im_context", libgtk.}

proc addChildAtAnchor*(textView: TextView; child: Widget;
                                 anchor: TextChildAnchor) {.
    importc: "gtk_text_view_add_child_at_anchor", libgtk.}
proc addChildInWindow*(textView: TextView; child: Widget;
                                 whichWindow: TextWindowType; xpos: cint;
                                 ypos: cint) {.
    importc: "gtk_text_view_add_child_in_window", libgtk.}
proc moveChild*(textView: TextView; child: Widget; xpos: cint;
                          ypos: cint) {.importc: "gtk_text_view_move_child",
                                      libgtk.}

proc setWrapMode*(textView: TextView; wrapMode: WrapMode) {.
    importc: "gtk_text_view_set_wrap_mode", libgtk.}

proc `wrapMode=`*(textView: TextView; wrapMode: WrapMode) {.
    importc: "gtk_text_view_set_wrap_mode", libgtk.}
proc getWrapMode*(textView: TextView): WrapMode {.
    importc: "gtk_text_view_get_wrap_mode", libgtk.}
proc wrapMode*(textView: TextView): WrapMode {.
    importc: "gtk_text_view_get_wrap_mode", libgtk.}
proc setEditable*(textView: TextView; setting: Gboolean) {.
    importc: "gtk_text_view_set_editable", libgtk.}
proc `editable=`*(textView: TextView; setting: Gboolean) {.
    importc: "gtk_text_view_set_editable", libgtk.}
proc getEditable*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_editable", libgtk.}
proc editable*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_editable", libgtk.}
proc setOverwrite*(textView: TextView; overwrite: Gboolean) {.
    importc: "gtk_text_view_set_overwrite", libgtk.}
proc `overwrite=`*(textView: TextView; overwrite: Gboolean) {.
    importc: "gtk_text_view_set_overwrite", libgtk.}
proc getOverwrite*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_overwrite", libgtk.}
proc overwrite*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_overwrite", libgtk.}
proc setAcceptsTab*(textView: TextView; acceptsTab: Gboolean) {.
    importc: "gtk_text_view_set_accepts_tab", libgtk.}
proc `acceptsTab=`*(textView: TextView; acceptsTab: Gboolean) {.
    importc: "gtk_text_view_set_accepts_tab", libgtk.}
proc getAcceptsTab*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_accepts_tab", libgtk.}
proc acceptsTab*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_accepts_tab", libgtk.}
proc setPixelsAboveLines*(textView: TextView;
                                    pixelsAboveLines: cint) {.
    importc: "gtk_text_view_set_pixels_above_lines", libgtk.}
proc `pixelsAboveLines=`*(textView: TextView;
                                    pixelsAboveLines: cint) {.
    importc: "gtk_text_view_set_pixels_above_lines", libgtk.}
proc getPixelsAboveLines*(textView: TextView): cint {.
    importc: "gtk_text_view_get_pixels_above_lines", libgtk.}
proc pixelsAboveLines*(textView: TextView): cint {.
    importc: "gtk_text_view_get_pixels_above_lines", libgtk.}
proc setPixelsBelowLines*(textView: TextView;
                                    pixelsBelowLines: cint) {.
    importc: "gtk_text_view_set_pixels_below_lines", libgtk.}
proc `pixelsBelowLines=`*(textView: TextView;
                                    pixelsBelowLines: cint) {.
    importc: "gtk_text_view_set_pixels_below_lines", libgtk.}
proc getPixelsBelowLines*(textView: TextView): cint {.
    importc: "gtk_text_view_get_pixels_below_lines", libgtk.}
proc pixelsBelowLines*(textView: TextView): cint {.
    importc: "gtk_text_view_get_pixels_below_lines", libgtk.}
proc setPixelsInsideWrap*(textView: TextView;
                                    pixelsInsideWrap: cint) {.
    importc: "gtk_text_view_set_pixels_inside_wrap", libgtk.}
proc `pixelsInsideWrap=`*(textView: TextView;
                                    pixelsInsideWrap: cint) {.
    importc: "gtk_text_view_set_pixels_inside_wrap", libgtk.}
proc getPixelsInsideWrap*(textView: TextView): cint {.
    importc: "gtk_text_view_get_pixels_inside_wrap", libgtk.}
proc pixelsInsideWrap*(textView: TextView): cint {.
    importc: "gtk_text_view_get_pixels_inside_wrap", libgtk.}
proc setJustification*(textView: TextView;
                                 justification: Justification) {.
    importc: "gtk_text_view_set_justification", libgtk.}
proc `justification=`*(textView: TextView;
                                 justification: Justification) {.
    importc: "gtk_text_view_set_justification", libgtk.}
proc getJustification*(textView: TextView): Justification {.
    importc: "gtk_text_view_get_justification", libgtk.}
proc justification*(textView: TextView): Justification {.
    importc: "gtk_text_view_get_justification", libgtk.}
proc setLeftMargin*(textView: TextView; leftMargin: cint) {.
    importc: "gtk_text_view_set_left_margin", libgtk.}
proc `leftMargin=`*(textView: TextView; leftMargin: cint) {.
    importc: "gtk_text_view_set_left_margin", libgtk.}
proc getLeftMargin*(textView: TextView): cint {.
    importc: "gtk_text_view_get_left_margin", libgtk.}
proc leftMargin*(textView: TextView): cint {.
    importc: "gtk_text_view_get_left_margin", libgtk.}
proc setRightMargin*(textView: TextView; rightMargin: cint) {.
    importc: "gtk_text_view_set_right_margin", libgtk.}
proc `rightMargin=`*(textView: TextView; rightMargin: cint) {.
    importc: "gtk_text_view_set_right_margin", libgtk.}
proc getRightMargin*(textView: TextView): cint {.
    importc: "gtk_text_view_get_right_margin", libgtk.}
proc rightMargin*(textView: TextView): cint {.
    importc: "gtk_text_view_get_right_margin", libgtk.}
proc setTopMargin*(textView: TextView; topMargin: cint) {.
    importc: "gtk_text_view_set_top_margin", libgtk.}
proc `topMargin=`*(textView: TextView; topMargin: cint) {.
    importc: "gtk_text_view_set_top_margin", libgtk.}
proc getTopMargin*(textView: TextView): cint {.
    importc: "gtk_text_view_get_top_margin", libgtk.}
proc topMargin*(textView: TextView): cint {.
    importc: "gtk_text_view_get_top_margin", libgtk.}
proc setBottomMargin*(textView: TextView; bottomMargin: cint) {.
    importc: "gtk_text_view_set_bottom_margin", libgtk.}
proc `bottomMargin=`*(textView: TextView; bottomMargin: cint) {.
    importc: "gtk_text_view_set_bottom_margin", libgtk.}
proc getBottomMargin*(textView: TextView): cint {.
    importc: "gtk_text_view_get_bottom_margin", libgtk.}
proc bottomMargin*(textView: TextView): cint {.
    importc: "gtk_text_view_get_bottom_margin", libgtk.}
proc setIndent*(textView: TextView; indent: cint) {.
    importc: "gtk_text_view_set_indent", libgtk.}
proc `indent=`*(textView: TextView; indent: cint) {.
    importc: "gtk_text_view_set_indent", libgtk.}
proc getIndent*(textView: TextView): cint {.
    importc: "gtk_text_view_get_indent", libgtk.}
proc indent*(textView: TextView): cint {.
    importc: "gtk_text_view_get_indent", libgtk.}
proc setTabs*(textView: TextView; tabs: pango.TabArray) {.
    importc: "gtk_text_view_set_tabs", libgtk.}
proc `tabs=`*(textView: TextView; tabs: pango.TabArray) {.
    importc: "gtk_text_view_set_tabs", libgtk.}
proc getTabs*(textView: TextView): pango.TabArray {.
    importc: "gtk_text_view_get_tabs", libgtk.}
proc tabs*(textView: TextView): pango.TabArray {.
    importc: "gtk_text_view_get_tabs", libgtk.}

proc getDefaultAttributes*(textView: TextView): TextAttributes {.
    importc: "gtk_text_view_get_default_attributes", libgtk.}

proc defaultAttributes*(textView: TextView): TextAttributes {.
    importc: "gtk_text_view_get_default_attributes", libgtk.}
proc setInputPurpose*(textView: TextView; purpose: InputPurpose) {.
    importc: "gtk_text_view_set_input_purpose", libgtk.}
proc `inputPurpose=`*(textView: TextView; purpose: InputPurpose) {.
    importc: "gtk_text_view_set_input_purpose", libgtk.}
proc getInputPurpose*(textView: TextView): InputPurpose {.
    importc: "gtk_text_view_get_input_purpose", libgtk.}
proc inputPurpose*(textView: TextView): InputPurpose {.
    importc: "gtk_text_view_get_input_purpose", libgtk.}
proc setInputHints*(textView: TextView; hints: InputHints) {.
    importc: "gtk_text_view_set_input_hints", libgtk.}
proc `inputHints=`*(textView: TextView; hints: InputHints) {.
    importc: "gtk_text_view_set_input_hints", libgtk.}
proc getInputHints*(textView: TextView): InputHints {.
    importc: "gtk_text_view_get_input_hints", libgtk.}
proc inputHints*(textView: TextView): InputHints {.
    importc: "gtk_text_view_get_input_hints", libgtk.}
proc setMonospace*(textView: TextView; monospace: Gboolean) {.
    importc: "gtk_text_view_set_monospace", libgtk.}
proc `monospace=`*(textView: TextView; monospace: Gboolean) {.
    importc: "gtk_text_view_set_monospace", libgtk.}
proc getMonospace*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_monospace", libgtk.}
proc monospace*(textView: TextView): Gboolean {.
    importc: "gtk_text_view_get_monospace", libgtk.}

template typeToolbar*(): expr =
  (toolbarGetType())

template toolbar*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeToolbar, ToolbarObj))

template toolbarClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeToolbar, ToolbarClassObj))

template isToolbar*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeToolbar))

template isToolbarClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeToolbar))

template toolbarGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeToolbar, ToolbarClassObj))

type
  ToolbarSpaceStyle* {.size: sizeof(cint), pure.} = enum
    EMPTY, LINE

type
  ToolItemGroup* =  ptr ToolItemGroupObj
  ToolItemGroupPtr* = ptr ToolItemGroupObj
  ToolItemGroupObj*{.final.} = object of ContainerObj
    priv122: pointer

  ToolItemGroupClass* =  ptr ToolItemGroupClassObj
  ToolItemGroupClassPtr* = ptr ToolItemGroupClassObj
  ToolItemGroupClassObj*{.final.} = object of ContainerClassObj
    gtkReserved1251*: proc () {.cdecl.}
    gtkReserved1252*: proc () {.cdecl.}
    gtkReserved1253*: proc () {.cdecl.}
    gtkReserved1254*: proc () {.cdecl.}

proc toolbarGetType*(): GType {.importc: "gtk_toolbar_get_type", libgtk.}
proc newToolbar*(): Toolbar {.importc: "gtk_toolbar_new", libgtk.}
proc insert*(toolbar: Toolbar; item: ToolItem; pos: cint) {.
    importc: "gtk_toolbar_insert", libgtk.}
proc getItemIndex*(toolbar: Toolbar; item: ToolItem): cint {.
    importc: "gtk_toolbar_get_item_index", libgtk.}
proc itemIndex*(toolbar: Toolbar; item: ToolItem): cint {.
    importc: "gtk_toolbar_get_item_index", libgtk.}
proc getNItems*(toolbar: Toolbar): cint {.
    importc: "gtk_toolbar_get_n_items", libgtk.}
proc nItems*(toolbar: Toolbar): cint {.
    importc: "gtk_toolbar_get_n_items", libgtk.}
proc getNthItem*(toolbar: Toolbar; n: cint): ToolItem {.
    importc: "gtk_toolbar_get_nth_item", libgtk.}
proc nthItem*(toolbar: Toolbar; n: cint): ToolItem {.
    importc: "gtk_toolbar_get_nth_item", libgtk.}
proc getShowArrow*(toolbar: Toolbar): Gboolean {.
    importc: "gtk_toolbar_get_show_arrow", libgtk.}
proc showArrow*(toolbar: Toolbar): Gboolean {.
    importc: "gtk_toolbar_get_show_arrow", libgtk.}
proc setShowArrow*(toolbar: Toolbar; showArrow: Gboolean) {.
    importc: "gtk_toolbar_set_show_arrow", libgtk.}
proc `showArrow=`*(toolbar: Toolbar; showArrow: Gboolean) {.
    importc: "gtk_toolbar_set_show_arrow", libgtk.}
proc getStyle*(toolbar: Toolbar): ToolbarStyle {.
    importc: "gtk_toolbar_get_style", libgtk.}
proc style*(toolbar: Toolbar): ToolbarStyle {.
    importc: "gtk_toolbar_get_style", libgtk.}
proc setStyle*(toolbar: Toolbar; style: ToolbarStyle) {.
    importc: "gtk_toolbar_set_style", libgtk.}
proc `style=`*(toolbar: Toolbar; style: ToolbarStyle) {.
    importc: "gtk_toolbar_set_style", libgtk.}
proc unsetStyle*(toolbar: Toolbar) {.
    importc: "gtk_toolbar_unset_style", libgtk.}
proc getIconSize*(toolbar: Toolbar): IconSize {.
    importc: "gtk_toolbar_get_icon_size", libgtk.}
proc iconSize*(toolbar: Toolbar): IconSize {.
    importc: "gtk_toolbar_get_icon_size", libgtk.}
proc setIconSize*(toolbar: Toolbar; iconSize: IconSize) {.
    importc: "gtk_toolbar_set_icon_size", libgtk.}
proc `iconSize=`*(toolbar: Toolbar; iconSize: IconSize) {.
    importc: "gtk_toolbar_set_icon_size", libgtk.}
proc unsetIconSize*(toolbar: Toolbar) {.
    importc: "gtk_toolbar_unset_icon_size", libgtk.}
proc getReliefStyle*(toolbar: Toolbar): ReliefStyle {.
    importc: "gtk_toolbar_get_relief_style", libgtk.}
proc reliefStyle*(toolbar: Toolbar): ReliefStyle {.
    importc: "gtk_toolbar_get_relief_style", libgtk.}
proc getDropIndex*(toolbar: Toolbar; x: cint; y: cint): cint {.
    importc: "gtk_toolbar_get_drop_index", libgtk.}
proc dropIndex*(toolbar: Toolbar; x: cint; y: cint): cint {.
    importc: "gtk_toolbar_get_drop_index", libgtk.}
proc setDropHighlightItem*(toolbar: Toolbar;
                                    toolItem: ToolItem; index: cint) {.
    importc: "gtk_toolbar_set_drop_highlight_item", libgtk.}
proc `dropHighlightItem=`*(toolbar: Toolbar;
                                    toolItem: ToolItem; index: cint) {.
    importc: "gtk_toolbar_set_drop_highlight_item", libgtk.}

template typeToolItemGroup*(): expr =
  (toolItemGroupGetType())

template toolItemGroup*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeToolItemGroup, ToolItemGroupObj))

template toolItemGroupClass*(cls: expr): expr =
  (gTypeCheckClassCast(cls, typeToolItemGroup, ToolItemGroupClassObj))

template isToolItemGroup*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeToolItemGroup))

template isToolItemGroupClass*(obj: expr): expr =
  (gTypeCheckClassType(obj, typeToolItemGroup))

template toolItemGroupGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeToolItemGroup, ToolItemGroupClassObj))

type
  ToolPalette* =  ptr ToolPaletteObj
  ToolPalettePtr* = ptr ToolPaletteObj
  ToolPaletteObj*{.final.} = object of ContainerObj
    priv123: pointer

  ToolPaletteClass* =  ptr ToolPaletteClassObj
  ToolPaletteClassPtr* = ptr ToolPaletteClassObj
  ToolPaletteClassObj*{.final.} = object of ContainerClassObj
    gtkReserved1261*: proc () {.cdecl.}
    gtkReserved1262*: proc () {.cdecl.}
    gtkReserved1263*: proc () {.cdecl.}
    gtkReserved1264*: proc () {.cdecl.}

proc toolItemGroupGetType*(): GType {.importc: "gtk_tool_item_group_get_type",
                                      libgtk.}
proc newToolItemGroup*(label: cstring): ToolItemGroup {.
    importc: "gtk_tool_item_group_new", libgtk.}
proc setLabel*(group: ToolItemGroup; label: cstring) {.
    importc: "gtk_tool_item_group_set_label", libgtk.}
proc `label=`*(group: ToolItemGroup; label: cstring) {.
    importc: "gtk_tool_item_group_set_label", libgtk.}
proc setLabelWidget*(group: ToolItemGroup;
                                    labelWidget: Widget) {.
    importc: "gtk_tool_item_group_set_label_widget", libgtk.}
proc `labelWidget=`*(group: ToolItemGroup;
                                    labelWidget: Widget) {.
    importc: "gtk_tool_item_group_set_label_widget", libgtk.}
proc setCollapsed*(group: ToolItemGroup; collapsed: Gboolean) {.
    importc: "gtk_tool_item_group_set_collapsed", libgtk.}
proc `collapsed=`*(group: ToolItemGroup; collapsed: Gboolean) {.
    importc: "gtk_tool_item_group_set_collapsed", libgtk.}
proc setEllipsize*(group: ToolItemGroup;
                                  ellipsize: pango.EllipsizeMode) {.
    importc: "gtk_tool_item_group_set_ellipsize", libgtk.}
proc `ellipsize=`*(group: ToolItemGroup;
                                  ellipsize: pango.EllipsizeMode) {.
    importc: "gtk_tool_item_group_set_ellipsize", libgtk.}
proc setHeaderRelief*(group: ToolItemGroup;
                                     style: ReliefStyle) {.
    importc: "gtk_tool_item_group_set_header_relief", libgtk.}
proc `headerRelief=`*(group: ToolItemGroup;
                                     style: ReliefStyle) {.
    importc: "gtk_tool_item_group_set_header_relief", libgtk.}
proc getLabel*(group: ToolItemGroup): cstring {.
    importc: "gtk_tool_item_group_get_label", libgtk.}
proc label*(group: ToolItemGroup): cstring {.
    importc: "gtk_tool_item_group_get_label", libgtk.}
proc getLabelWidget*(group: ToolItemGroup): Widget {.
    importc: "gtk_tool_item_group_get_label_widget", libgtk.}
proc labelWidget*(group: ToolItemGroup): Widget {.
    importc: "gtk_tool_item_group_get_label_widget", libgtk.}
proc getCollapsed*(group: ToolItemGroup): Gboolean {.
    importc: "gtk_tool_item_group_get_collapsed", libgtk.}
proc collapsed*(group: ToolItemGroup): Gboolean {.
    importc: "gtk_tool_item_group_get_collapsed", libgtk.}
proc getEllipsize*(group: ToolItemGroup): pango.EllipsizeMode {.
    importc: "gtk_tool_item_group_get_ellipsize", libgtk.}
proc ellipsize*(group: ToolItemGroup): pango.EllipsizeMode {.
    importc: "gtk_tool_item_group_get_ellipsize", libgtk.}
proc getHeaderRelief*(group: ToolItemGroup): ReliefStyle {.
    importc: "gtk_tool_item_group_get_header_relief", libgtk.}
proc headerRelief*(group: ToolItemGroup): ReliefStyle {.
    importc: "gtk_tool_item_group_get_header_relief", libgtk.}
proc insert*(group: ToolItemGroup; item: ToolItem;
                            position: cint) {.
    importc: "gtk_tool_item_group_insert", libgtk.}
proc setItemPosition*(group: ToolItemGroup;
                                     item: ToolItem; position: cint) {.
    importc: "gtk_tool_item_group_set_item_position", libgtk.}
proc `itemPosition=`*(group: ToolItemGroup;
                                     item: ToolItem; position: cint) {.
    importc: "gtk_tool_item_group_set_item_position", libgtk.}
proc getItemPosition*(group: ToolItemGroup;
                                     item: ToolItem): cint {.
    importc: "gtk_tool_item_group_get_item_position", libgtk.}
proc itemPosition*(group: ToolItemGroup;
                                     item: ToolItem): cint {.
    importc: "gtk_tool_item_group_get_item_position", libgtk.}
proc getNItems*(group: ToolItemGroup): cuint {.
    importc: "gtk_tool_item_group_get_n_items", libgtk.}
proc nItems*(group: ToolItemGroup): cuint {.
    importc: "gtk_tool_item_group_get_n_items", libgtk.}
proc getNthItem*(group: ToolItemGroup; index: cuint): ToolItem {.
    importc: "gtk_tool_item_group_get_nth_item", libgtk.}
proc nthItem*(group: ToolItemGroup; index: cuint): ToolItem {.
    importc: "gtk_tool_item_group_get_nth_item", libgtk.}
proc getDropItem*(group: ToolItemGroup; x: cint; y: cint): ToolItem {.
    importc: "gtk_tool_item_group_get_drop_item", libgtk.}
proc dropItem*(group: ToolItemGroup; x: cint; y: cint): ToolItem {.
    importc: "gtk_tool_item_group_get_drop_item", libgtk.}

template typeToolPalette*(): expr =
  (toolPaletteGetType())

template toolPalette*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeToolPalette, ToolPaletteObj))

template toolPaletteClass*(cls: expr): expr =
  (gTypeCheckClassCast(cls, typeToolPalette, ToolPaletteClassObj))

template isToolPalette*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeToolPalette))

template isToolPaletteClass*(obj: expr): expr =
  (gTypeCheckClassType(obj, typeToolPalette))

template toolPaletteGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeToolPalette, ToolPaletteClassObj))

type
  ToolPaletteDragTargets* {.size: sizeof(cint), pure.} = enum
    ITEMS = 1 shl 0, GROUPS = 1 shl 1
  ToolShell* =  ptr ToolShellObj
  ToolShellPtr* = ptr ToolShellObj
  ToolShellObj* = object

type
  ToolShellIface* =  ptr ToolShellIfaceObj
  ToolShellIfacePtr* = ptr ToolShellIfaceObj
  ToolShellIfaceObj* = object of gobject.GTypeInterfaceObj
    getIconSize*: proc (shell: ToolShell): IconSize {.cdecl.}
    getOrientation*: proc (shell: ToolShell): Orientation {.cdecl.}
    getStyle*: proc (shell: ToolShell): ToolbarStyle {.cdecl.}
    getReliefStyle*: proc (shell: ToolShell): ReliefStyle {.cdecl.}
    rebuildMenu*: proc (shell: ToolShell) {.cdecl.}
    getTextOrientation*: proc (shell: ToolShell): Orientation {.cdecl.}
    getTextAlignment*: proc (shell: ToolShell): cfloat {.cdecl.}
    getEllipsizeMode*: proc (shell: ToolShell): pango.EllipsizeMode {.cdecl.}
    getTextSizeGroup*: proc (shell: ToolShell): SizeGroup {.cdecl.}

  TreeDragSource* =  ptr TreeDragSourceObj
  TreeDragSourcePtr* = ptr TreeDragSourceObj
  TreeDragSourceObj* = object

proc toolPaletteGetType*(): GType {.importc: "gtk_tool_palette_get_type",
                                    libgtk.}
proc newToolPalette*(): ToolPalette {.importc: "gtk_tool_palette_new",
                                       libgtk.}
proc setGroupPosition*(palette: ToolPalette;
                                    group: ToolItemGroup; position: cint) {.
    importc: "gtk_tool_palette_set_group_position", libgtk.}
proc `groupPosition=`*(palette: ToolPalette;
                                    group: ToolItemGroup; position: cint) {.
    importc: "gtk_tool_palette_set_group_position", libgtk.}
proc setExclusive*(palette: ToolPalette;
                                group: ToolItemGroup; exclusive: Gboolean) {.
    importc: "gtk_tool_palette_set_exclusive", libgtk.}
proc `exclusive=`*(palette: ToolPalette;
                                group: ToolItemGroup; exclusive: Gboolean) {.
    importc: "gtk_tool_palette_set_exclusive", libgtk.}
proc setExpand*(palette: ToolPalette;
                             group: ToolItemGroup; expand: Gboolean) {.
    importc: "gtk_tool_palette_set_expand", libgtk.}
proc `expand=`*(palette: ToolPalette;
                             group: ToolItemGroup; expand: Gboolean) {.
    importc: "gtk_tool_palette_set_expand", libgtk.}
proc getGroupPosition*(palette: ToolPalette;
                                    group: ToolItemGroup): cint {.
    importc: "gtk_tool_palette_get_group_position", libgtk.}
proc groupPosition*(palette: ToolPalette;
                                    group: ToolItemGroup): cint {.
    importc: "gtk_tool_palette_get_group_position", libgtk.}
proc getExclusive*(palette: ToolPalette;
                                group: ToolItemGroup): Gboolean {.
    importc: "gtk_tool_palette_get_exclusive", libgtk.}
proc exclusive*(palette: ToolPalette;
                                group: ToolItemGroup): Gboolean {.
    importc: "gtk_tool_palette_get_exclusive", libgtk.}
proc getExpand*(palette: ToolPalette;
                             group: ToolItemGroup): Gboolean {.
    importc: "gtk_tool_palette_get_expand", libgtk.}
proc expand*(palette: ToolPalette;
                             group: ToolItemGroup): Gboolean {.
    importc: "gtk_tool_palette_get_expand", libgtk.}
proc setIconSize*(palette: ToolPalette; iconSize: IconSize) {.
    importc: "gtk_tool_palette_set_icon_size", libgtk.}
proc `iconSize=`*(palette: ToolPalette; iconSize: IconSize) {.
    importc: "gtk_tool_palette_set_icon_size", libgtk.}
proc unsetIconSize*(palette: ToolPalette) {.
    importc: "gtk_tool_palette_unset_icon_size", libgtk.}
proc setStyle*(palette: ToolPalette; style: ToolbarStyle) {.
    importc: "gtk_tool_palette_set_style", libgtk.}
proc `style=`*(palette: ToolPalette; style: ToolbarStyle) {.
    importc: "gtk_tool_palette_set_style", libgtk.}
proc unsetStyle*(palette: ToolPalette) {.
    importc: "gtk_tool_palette_unset_style", libgtk.}
proc getIconSize*(palette: ToolPalette): IconSize {.
    importc: "gtk_tool_palette_get_icon_size", libgtk.}
proc iconSize*(palette: ToolPalette): IconSize {.
    importc: "gtk_tool_palette_get_icon_size", libgtk.}
proc getStyle*(palette: ToolPalette): ToolbarStyle {.
    importc: "gtk_tool_palette_get_style", libgtk.}
proc style*(palette: ToolPalette): ToolbarStyle {.
    importc: "gtk_tool_palette_get_style", libgtk.}
proc getDropItem*(palette: ToolPalette; x: cint; y: cint): ToolItem {.
    importc: "gtk_tool_palette_get_drop_item", libgtk.}
proc dropItem*(palette: ToolPalette; x: cint; y: cint): ToolItem {.
    importc: "gtk_tool_palette_get_drop_item", libgtk.}
proc getDropGroup*(palette: ToolPalette; x: cint; y: cint): ToolItemGroup {.
    importc: "gtk_tool_palette_get_drop_group", libgtk.}
proc dropGroup*(palette: ToolPalette; x: cint; y: cint): ToolItemGroup {.
    importc: "gtk_tool_palette_get_drop_group", libgtk.}
proc getDragItem*(palette: ToolPalette;
                               selection: SelectionData): Widget {.
    importc: "gtk_tool_palette_get_drag_item", libgtk.}
proc dragItem*(palette: ToolPalette;
                               selection: SelectionData): Widget {.
    importc: "gtk_tool_palette_get_drag_item", libgtk.}
proc setDragSource*(palette: ToolPalette;
                                 targets: ToolPaletteDragTargets) {.
    importc: "gtk_tool_palette_set_drag_source", libgtk.}
proc `dragSource=`*(palette: ToolPalette;
                                 targets: ToolPaletteDragTargets) {.
    importc: "gtk_tool_palette_set_drag_source", libgtk.}
proc addDragDest*(palette: ToolPalette; widget: Widget;
                               flags: DestDefaults;
                               targets: ToolPaletteDragTargets;
                               actions: gdk3.DragAction) {.
    importc: "gtk_tool_palette_add_drag_dest", libgtk.}
proc getHadjustment*(palette: ToolPalette): Adjustment {.
    importc: "gtk_tool_palette_get_hadjustment", libgtk.}
proc hadjustment*(palette: ToolPalette): Adjustment {.
    importc: "gtk_tool_palette_get_hadjustment", libgtk.}
proc getVadjustment*(palette: ToolPalette): Adjustment {.
    importc: "gtk_tool_palette_get_vadjustment", libgtk.}
proc vadjustment*(palette: ToolPalette): Adjustment {.
    importc: "gtk_tool_palette_get_vadjustment", libgtk.}
proc toolPaletteGetDragTargetItem*(): TargetEntry {.
    importc: "gtk_tool_palette_get_drag_target_item", libgtk.}
proc toolPaletteGetDragTargetGroup*(): TargetEntry {.
    importc: "gtk_tool_palette_get_drag_target_group", libgtk.}

template typeToolShell*(): expr =
  (toolShellGetType())

template toolShell*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeToolShell, ToolShellObj))

template isToolShell*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeToolShell))

template toolShellGetIface*(obj: expr): expr =
  (gTypeInstanceGetInterface(obj, typeToolShell, ToolShellIfaceObj))

type
  TreeDragSourceIface* =  ptr TreeDragSourceIfaceObj
  TreeDragSourceIfacePtr* = ptr TreeDragSourceIfaceObj
  TreeDragSourceIfaceObj* = object
    gIface*: gobject.GTypeInterfaceObj
    rowDraggable*: proc (dragSource: TreeDragSource; path: TreePath): Gboolean {.cdecl.}
    dragDataGet*: proc (dragSource: TreeDragSource; path: TreePath;
                      selectionData: SelectionData): Gboolean {.cdecl.}
    dragDataDelete*: proc (dragSource: TreeDragSource; path: TreePath): Gboolean {.cdecl.}

  TreeDragDest* =  ptr TreeDragDestObj
  TreeDragDestPtr* = ptr TreeDragDestObj
  TreeDragDestObj* = object

proc toolShellGetType*(): GType {.importc: "gtk_tool_shell_get_type", libgtk.}
proc getIconSize*(shell: ToolShell): IconSize {.
    importc: "gtk_tool_shell_get_icon_size", libgtk.}
proc iconSize*(shell: ToolShell): IconSize {.
    importc: "gtk_tool_shell_get_icon_size", libgtk.}
proc getOrientation*(shell: ToolShell): Orientation {.
    importc: "gtk_tool_shell_get_orientation", libgtk.}
proc orientation*(shell: ToolShell): Orientation {.
    importc: "gtk_tool_shell_get_orientation", libgtk.}
proc getStyle*(shell: ToolShell): ToolbarStyle {.
    importc: "gtk_tool_shell_get_style", libgtk.}
proc style*(shell: ToolShell): ToolbarStyle {.
    importc: "gtk_tool_shell_get_style", libgtk.}
proc getReliefStyle*(shell: ToolShell): ReliefStyle {.
    importc: "gtk_tool_shell_get_relief_style", libgtk.}
proc reliefStyle*(shell: ToolShell): ReliefStyle {.
    importc: "gtk_tool_shell_get_relief_style", libgtk.}
proc rebuildMenu*(shell: ToolShell) {.
    importc: "gtk_tool_shell_rebuild_menu", libgtk.}
proc getTextOrientation*(shell: ToolShell): Orientation {.
    importc: "gtk_tool_shell_get_text_orientation", libgtk.}
proc textOrientation*(shell: ToolShell): Orientation {.
    importc: "gtk_tool_shell_get_text_orientation", libgtk.}
proc getTextAlignment*(shell: ToolShell): cfloat {.
    importc: "gtk_tool_shell_get_text_alignment", libgtk.}
proc textAlignment*(shell: ToolShell): cfloat {.
    importc: "gtk_tool_shell_get_text_alignment", libgtk.}
proc getEllipsizeMode*(shell: ToolShell): pango.EllipsizeMode {.
    importc: "gtk_tool_shell_get_ellipsize_mode", libgtk.}
proc ellipsizeMode*(shell: ToolShell): pango.EllipsizeMode {.
    importc: "gtk_tool_shell_get_ellipsize_mode", libgtk.}
proc getTextSizeGroup*(shell: ToolShell): SizeGroup {.
    importc: "gtk_tool_shell_get_text_size_group", libgtk.}
proc textSizeGroup*(shell: ToolShell): SizeGroup {.
    importc: "gtk_tool_shell_get_text_size_group", libgtk.}

proc testInit*(argcp: var cint; argvp: var cstringArray) {.varargs,
    importc: "gtk_test_init", libgtk.}
proc testRegisterAllTypes*() {.importc: "gtk_test_register_all_types",
                                libgtk.}
proc testListAllTypes*(nTypes: var cuint): ptr GType {.
    importc: "gtk_test_list_all_types", libgtk.}
proc testFindWidget*(widget: Widget; labelPattern: cstring;
                       widgetType: GType): Widget {.
    importc: "gtk_test_find_widget", libgtk.}
proc testCreateWidget*(widgetType: GType; firstPropertyName: cstring): Widget {.
    varargs, importc: "gtk_test_create_widget", libgtk.}
proc testCreateSimpleWindow*(windowTitle: cstring; dialogText: cstring): Widget {.
    importc: "gtk_test_create_simple_window", libgtk.}
proc testDisplayButtonWindow*(windowTitle: cstring; dialogText: cstring): Widget {.
    varargs, importc: "gtk_test_display_button_window", libgtk.}

proc testSliderSetPerc*(widget: Widget; percentage: cdouble) {.
    importc: "gtk_test_slider_set_perc", libgtk.}
proc testSliderGetValue*(widget: Widget): cdouble {.
    importc: "gtk_test_slider_get_value", libgtk.}
proc testSpinButtonClick*(spinner: SpinButton; button: cuint;
                            upwards: Gboolean): Gboolean {.
    importc: "gtk_test_spin_button_click", libgtk.}
proc testWidgetWaitForDraw*(widget: Widget) {.
    importc: "gtk_test_widget_wait_for_draw", libgtk.}
proc testWidgetClick*(widget: Widget; button: cuint;
                        modifiers: gdk3.ModifierType): Gboolean {.
    importc: "gtk_test_widget_click", libgtk.}
proc testWidgetSendKey*(widget: Widget; keyval: cuint;
                          modifiers: gdk3.ModifierType): Gboolean {.
    importc: "gtk_test_widget_send_key", libgtk.}

proc testTextSet*(widget: Widget; string: cstring) {.
    importc: "gtk_test_text_set", libgtk.}
proc testTextGet*(widget: Widget): cstring {.importc: "gtk_test_text_get",
    libgtk.}

proc testFindSibling*(baseWidget: Widget; widgetType: GType): Widget {.
    importc: "gtk_test_find_sibling", libgtk.}
proc testFindLabel*(widget: Widget; labelPattern: cstring): Widget {.
    importc: "gtk_test_find_label", libgtk.}

template typeTreeDragSource*(): expr =
  (treeDragSourceGetType())

template treeDragSource*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeDragSource, TreeDragSourceObj))

template isTreeDragSource*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeDragSource))

template treeDragSourceGetIface*(obj: expr): expr =
  (gTypeInstanceGetInterface(obj, typeTreeDragSource, TreeDragSourceIfaceObj))

type
  TreeDragDestIface* =  ptr TreeDragDestIfaceObj
  TreeDragDestIfacePtr* = ptr TreeDragDestIfaceObj
  TreeDragDestIfaceObj* = object of gobject.GTypeInterfaceObj
    dragDataReceived*: proc (dragDest: TreeDragDest; dest: TreePath;
                           selectionData: SelectionData): Gboolean {.cdecl.}
    rowDropPossible*: proc (dragDest: TreeDragDest; destPath: TreePath;
                          selectionData: SelectionData): Gboolean {.cdecl.}

proc treeDragSourceGetType*(): GType {.importc: "gtk_tree_drag_source_get_type",
                                       libgtk.}

proc rowDraggable*(dragSource: TreeDragSource;
                                   path: TreePath): Gboolean {.
    importc: "gtk_tree_drag_source_row_draggable", libgtk.}

proc dragDataDelete*(dragSource: TreeDragSource;
                                     path: TreePath): Gboolean {.
    importc: "gtk_tree_drag_source_drag_data_delete", libgtk.}

proc dragDataGet*(dragSource: TreeDragSource;
                                  path: TreePath;
                                  selectionData: SelectionData): Gboolean {.
    importc: "gtk_tree_drag_source_drag_data_get", libgtk.}
template typeTreeDragDest*(): expr =
  (treeDragDestGetType())

template treeDragDest*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeDragDest, TreeDragDestObj))

template isTreeDragDest*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeDragDest))

template treeDragDestGetIface*(obj: expr): expr =
  (gTypeInstanceGetInterface(obj, typeTreeDragDest, TreeDragDestIfaceObj))

type
  TreeModelSort* =  ptr TreeModelSortObj
  TreeModelSortPtr* = ptr TreeModelSortObj
  TreeModelSortObj*{.final.} = object of GObjectObj
    priv124: pointer

  TreeModelSortClass* =  ptr TreeModelSortClassObj
  TreeModelSortClassPtr* = ptr TreeModelSortClassObj
  TreeModelSortClassObj*{.final.} = object of GObjectClassObj
    gtkReserved1271*: proc () {.cdecl.}
    gtkReserved1272*: proc () {.cdecl.}
    gtkReserved1273*: proc () {.cdecl.}
    gtkReserved1274*: proc () {.cdecl.}

proc treeDragDestGetType*(): GType {.importc: "gtk_tree_drag_dest_get_type",
                                     libgtk.}

proc dragDataReceived*(dragDest: TreeDragDest;
                                     dest: TreePath;
                                     selectionData: SelectionData): Gboolean {.
    importc: "gtk_tree_drag_dest_drag_data_received", libgtk.}

proc rowDropPossible*(dragDest: TreeDragDest;
                                    destPath: TreePath;
                                    selectionData: SelectionData): Gboolean {.
    importc: "gtk_tree_drag_dest_row_drop_possible", libgtk.}

proc treeSetRowDragData*(selectionData: SelectionData;
                           treeModel: TreeModel; path: TreePath): Gboolean {.
    importc: "gtk_tree_set_row_drag_data", libgtk.}
proc treeGetRowDragData*(selectionData: SelectionData;
                           treeModel: var TreeModel;
                           path: var TreePath): Gboolean {.
    importc: "gtk_tree_get_row_drag_data", libgtk.}

template typeTreeModelSort*(): expr =
  (treeModelSortGetType())

template treeModelSort*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeModelSort, TreeModelSortObj))

template treeModelSortClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTreeModelSort, TreeModelSortClassObj))

template isTreeModelSort*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeModelSort))

template isTreeModelSortClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTreeModelSort))

template treeModelSortGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTreeModelSort, TreeModelSortClassObj))

type
  TreeSelectionClass* =  ptr TreeSelectionClassObj
  TreeSelectionClassPtr* = ptr TreeSelectionClassObj
  TreeSelectionClassObj*{.final.} = object of GObjectClassObj
    changed*: proc (selection: TreeSelection) {.cdecl.}
    gtkReserved1281*: proc () {.cdecl.}
    gtkReserved1282*: proc () {.cdecl.}
    gtkReserved1283*: proc () {.cdecl.}
    gtkReserved1284*: proc () {.cdecl.}

proc treeModelSortGetType*(): GType {.importc: "gtk_tree_model_sort_get_type",
                                      libgtk.}
proc newSort*(childModel: TreeModel): TreeModel {.
    importc: "gtk_tree_model_sort_new_with_model", libgtk.}
proc getModel*(treeModel: TreeModelSort): TreeModel {.
    importc: "gtk_tree_model_sort_get_model", libgtk.}
proc model*(treeModel: TreeModelSort): TreeModel {.
    importc: "gtk_tree_model_sort_get_model", libgtk.}
proc convertChildPathToPath*(treeModelSort: TreeModelSort;
    childPath: TreePath): TreePath {.
    importc: "gtk_tree_model_sort_convert_child_path_to_path", libgtk.}
proc convertChildIterToIter*(treeModelSort: TreeModelSort;
    sortIter: TreeIter; childIter: TreeIter): Gboolean {.
    importc: "gtk_tree_model_sort_convert_child_iter_to_iter", libgtk.}
proc convertPathToChildPath*(treeModelSort: TreeModelSort;
    sortedPath: TreePath): TreePath {.
    importc: "gtk_tree_model_sort_convert_path_to_child_path", libgtk.}
proc convertIterToChildIter*(treeModelSort: TreeModelSort;
    childIter: TreeIter; sortedIter: TreeIter) {.
    importc: "gtk_tree_model_sort_convert_iter_to_child_iter", libgtk.}
proc resetDefaultSortFunc*(treeModelSort: TreeModelSort) {.
    importc: "gtk_tree_model_sort_reset_default_sort_func", libgtk.}
proc clearCache*(treeModelSort: TreeModelSort) {.
    importc: "gtk_tree_model_sort_clear_cache", libgtk.}
proc iterIsValid*(treeModelSort: TreeModelSort;
                                 iter: TreeIter): Gboolean {.
    importc: "gtk_tree_model_sort_iter_is_valid", libgtk.}

template typeTreeSelection*(): expr =
  (treeSelectionGetType())

template treeSelection*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeSelection, TreeSelectionObj))

template treeSelectionClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTreeSelection, TreeSelectionClassObj))

template isTreeSelection*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeSelection))

template isTreeSelectionClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTreeSelection))

template treeSelectionGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTreeSelection, TreeSelectionClassObj))

type
  TreeSelectionFunc* = proc (selection: TreeSelection;
                             model: TreeModel; path: TreePath;
                             pathCurrentlySelected: Gboolean; data: Gpointer): Gboolean {.cdecl.}

type
  TreeSelectionForeachFunc* = proc (model: TreeModel; path: TreePath;
                                    iter: TreeIter; data: Gpointer) {.cdecl.}

type
  TreeStore* =  ptr TreeStoreObj
  TreeStorePtr* = ptr TreeStoreObj
  TreeStoreObj*{.final.} = object of GObjectObj
    priv125: pointer

  TreeStoreClass* =  ptr TreeStoreClassObj
  TreeStoreClassPtr* = ptr TreeStoreClassObj
  TreeStoreClassObj*{.final.} = object of GObjectClassObj
    gtkReserved1291*: proc () {.cdecl.}
    gtkReserved1292*: proc () {.cdecl.}
    gtkReserved1293*: proc () {.cdecl.}
    gtkReserved1294*: proc () {.cdecl.}

proc treeSelectionGetType*(): GType {.importc: "gtk_tree_selection_get_type",
                                      libgtk.}
proc setMode*(selection: TreeSelection;
                             `type`: SelectionMode) {.
    importc: "gtk_tree_selection_set_mode", libgtk.}
proc `mode=`*(selection: TreeSelection;
                             `type`: SelectionMode) {.
    importc: "gtk_tree_selection_set_mode", libgtk.}
proc getMode*(selection: TreeSelection): SelectionMode {.
    importc: "gtk_tree_selection_get_mode", libgtk.}
proc mode*(selection: TreeSelection): SelectionMode {.
    importc: "gtk_tree_selection_get_mode", libgtk.}
proc setSelectFunction*(selection: TreeSelection;
                                       `func`: TreeSelectionFunc;
                                       data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_selection_set_select_function", libgtk.}
proc `selectFunction=`*(selection: TreeSelection;
                                       `func`: TreeSelectionFunc;
                                       data: Gpointer; destroy: GDestroyNotify) {.
    importc: "gtk_tree_selection_set_select_function", libgtk.}
proc getUserData*(selection: TreeSelection): Gpointer {.
    importc: "gtk_tree_selection_get_user_data", libgtk.}
proc userData*(selection: TreeSelection): Gpointer {.
    importc: "gtk_tree_selection_get_user_data", libgtk.}
proc getTreeView*(selection: TreeSelection): TreeView {.
    importc: "gtk_tree_selection_get_tree_view", libgtk.}
proc treeView*(selection: TreeSelection): TreeView {.
    importc: "gtk_tree_selection_get_tree_view", libgtk.}
proc getSelectFunction*(selection: TreeSelection): TreeSelectionFunc {.
    importc: "gtk_tree_selection_get_select_function", libgtk.}
proc selectFunction*(selection: TreeSelection): TreeSelectionFunc {.
    importc: "gtk_tree_selection_get_select_function", libgtk.}

proc getSelected*(selection: TreeSelection;
                                 model: var TreeModel; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_selection_get_selected", libgtk.}

proc selected*(selection: TreeSelection;
                                 model: var TreeModel; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_selection_get_selected", libgtk.}
proc getSelectedRows*(selection: TreeSelection;
                                     model: var TreeModel): glib.GList {.
    importc: "gtk_tree_selection_get_selected_rows", libgtk.}
proc selectedRows*(selection: TreeSelection;
                                     model: var TreeModel): glib.GList {.
    importc: "gtk_tree_selection_get_selected_rows", libgtk.}
proc countSelectedRows*(selection: TreeSelection): cint {.
    importc: "gtk_tree_selection_count_selected_rows", libgtk.}
proc selectedForeach*(selection: TreeSelection;
                                     `func`: TreeSelectionForeachFunc;
                                     data: Gpointer) {.
    importc: "gtk_tree_selection_selected_foreach", libgtk.}
proc selectPath*(selection: TreeSelection;
                                path: TreePath) {.
    importc: "gtk_tree_selection_select_path", libgtk.}
proc unselectPath*(selection: TreeSelection;
                                  path: TreePath) {.
    importc: "gtk_tree_selection_unselect_path", libgtk.}
proc selectIter*(selection: TreeSelection;
                                iter: TreeIter) {.
    importc: "gtk_tree_selection_select_iter", libgtk.}
proc unselectIter*(selection: TreeSelection;
                                  iter: TreeIter) {.
    importc: "gtk_tree_selection_unselect_iter", libgtk.}
proc pathIsSelected*(selection: TreeSelection;
                                    path: TreePath): Gboolean {.
    importc: "gtk_tree_selection_path_is_selected", libgtk.}
proc iterIsSelected*(selection: TreeSelection;
                                    iter: TreeIter): Gboolean {.
    importc: "gtk_tree_selection_iter_is_selected", libgtk.}
proc selectAll*(selection: TreeSelection) {.
    importc: "gtk_tree_selection_select_all", libgtk.}
proc unselectAll*(selection: TreeSelection) {.
    importc: "gtk_tree_selection_unselect_all", libgtk.}
proc selectRange*(selection: TreeSelection;
                                 startPath: TreePath;
                                 endPath: TreePath) {.
    importc: "gtk_tree_selection_select_range", libgtk.}
proc unselectRange*(selection: TreeSelection;
                                   startPath: TreePath;
                                   endPath: TreePath) {.
    importc: "gtk_tree_selection_unselect_range", libgtk.}

template typeTreeStore*(): expr =
  (treeStoreGetType())

template treeStore*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeTreeStore, TreeStoreObj))

template treeStoreClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeTreeStore, TreeStoreClassObj))

template isTreeStore*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeTreeStore))

template isTreeStoreClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeTreeStore))

template treeStoreGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeTreeStore, TreeStoreClassObj))

type
  Viewport* =  ptr ViewportObj
  ViewportPtr* = ptr ViewportObj
  ViewportObj* = object of BinObj
    priv126: pointer

  ViewportClass* =  ptr ViewportClassObj
  ViewportClassPtr* = ptr ViewportClassObj
  ViewportClassObj*{.final.} = object of BinClassObj
    gtkReserved1301*: proc () {.cdecl.}
    gtkReserved1302*: proc () {.cdecl.}
    gtkReserved1303*: proc () {.cdecl.}
    gtkReserved1304*: proc () {.cdecl.}

proc treeStoreGetType*(): GType {.importc: "gtk_tree_store_get_type", libgtk.}
proc newTreeStore*(nColumns: cint): TreeStore {.varargs,
    importc: "gtk_tree_store_new", libgtk.}
proc treeStoreNewv*(nColumns: cint; types: ptr GType): TreeStore {.
    importc: "gtk_tree_store_newv", libgtk.}
proc setColumnTypes*(treeStore: TreeStore; nColumns: cint;
                                types: ptr GType) {.
    importc: "gtk_tree_store_set_column_types", libgtk.}
proc `columnTypes=`*(treeStore: TreeStore; nColumns: cint;
                                types: ptr GType) {.
    importc: "gtk_tree_store_set_column_types", libgtk.}

proc setValue*(treeStore: TreeStore; iter: TreeIter;
                          column: cint; value: gobject.GValue) {.
    importc: "gtk_tree_store_set_value", libgtk.}

proc `value=`*(treeStore: TreeStore; iter: TreeIter;
                          column: cint; value: gobject.GValue) {.
    importc: "gtk_tree_store_set_value", libgtk.}
proc set*(treeStore: TreeStore; iter: TreeIter) {.varargs,
    importc: "gtk_tree_store_set", libgtk.}
proc setValuesv*(treeStore: TreeStore; iter: TreeIter;
                            columns: var cint; values: gobject.GValue; nValues: cint) {.
    importc: "gtk_tree_store_set_valuesv", libgtk.}
proc `valuesv=`*(treeStore: TreeStore; iter: TreeIter;
                            columns: var cint; values: gobject.GValue; nValues: cint) {.
    importc: "gtk_tree_store_set_valuesv", libgtk.}

discard """ proc "setValist*(treeStore: TreeStore; iter: TreeIter;
                           varArgs: VaList) {.
    importc: "gtk_tree_store_set_valist", libgtk.}"""

proc remove*(treeStore: TreeStore; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_store_remove", libgtk.}
proc insert*(treeStore: TreeStore; iter: TreeIter;
                        parent: TreeIter; position: cint) {.
    importc: "gtk_tree_store_insert", libgtk.}
proc insertBefore*(treeStore: TreeStore; iter: TreeIter;
                              parent: TreeIter; sibling: TreeIter) {.
    importc: "gtk_tree_store_insert_before", libgtk.}
proc insertAfter*(treeStore: TreeStore; iter: TreeIter;
                             parent: TreeIter; sibling: TreeIter) {.
    importc: "gtk_tree_store_insert_after", libgtk.}
proc insertWithValues*(treeStore: TreeStore;
                                  iter: TreeIter; parent: TreeIter;
                                  position: cint) {.varargs,
    importc: "gtk_tree_store_insert_with_values", libgtk.}
proc insertWithValuesv*(treeStore: TreeStore;
                                   iter: TreeIter; parent: TreeIter;
                                   position: cint; columns: var cint;
                                   values: gobject.GValue; nValues: cint) {.
    importc: "gtk_tree_store_insert_with_valuesv", libgtk.}
proc prepend*(treeStore: TreeStore; iter: TreeIter;
                         parent: TreeIter) {.
    importc: "gtk_tree_store_prepend", libgtk.}
proc append*(treeStore: TreeStore; iter: TreeIter;
                        parent: TreeIter) {.
    importc: "gtk_tree_store_append", libgtk.}
proc isAncestor*(treeStore: TreeStore; iter: TreeIter;
                            descendant: TreeIter): Gboolean {.
    importc: "gtk_tree_store_is_ancestor", libgtk.}
proc iterDepth*(treeStore: TreeStore; iter: TreeIter): cint {.
    importc: "gtk_tree_store_iter_depth", libgtk.}
proc clear*(treeStore: TreeStore) {.
    importc: "gtk_tree_store_clear", libgtk.}
proc iterIsValid*(treeStore: TreeStore; iter: TreeIter): Gboolean {.
    importc: "gtk_tree_store_iter_is_valid", libgtk.}
proc reorder*(treeStore: TreeStore; parent: TreeIter;
                         newOrder: var cint) {.importc: "gtk_tree_store_reorder",
    libgtk.}
proc swap*(treeStore: TreeStore; a: TreeIter;
                      b: TreeIter) {.importc: "gtk_tree_store_swap",
    libgtk.}
proc moveBefore*(treeStore: TreeStore; iter: TreeIter;
                            position: TreeIter) {.
    importc: "gtk_tree_store_move_before", libgtk.}
proc moveAfter*(treeStore: TreeStore; iter: TreeIter;
                           position: TreeIter) {.
    importc: "gtk_tree_store_move_after", libgtk.}

proc licenseGetType*(): GType {.importc: "gtk_license_get_type", libgtk.}
template typeLicense*(): expr =
  (licenseGetType())

proc accelFlagsGetType*(): GType {.importc: "gtk_accel_flags_get_type",
                                   libgtk.}
template typeAccelFlags*(): expr =
  (accelFlagsGetType())

proc applicationInhibitFlagsGetType*(): GType {.
    importc: "gtk_application_inhibit_flags_get_type", libgtk.}
template typeApplicationInhibitFlags*(): expr =
  (applicationInhibitFlagsGetType())

proc assistantPageTypeGetType*(): GType {.
    importc: "gtk_assistant_page_type_get_type", libgtk.}
template typeAssistantPageType*(): expr =
  (assistantPageTypeGetType())

proc buttonBoxStyleGetType*(): GType {.importc: "gtk_button_box_style_get_type",
                                       libgtk.}
template typeButtonBoxStyle*(): expr =
  (buttonBoxStyleGetType())

proc builderErrorGetType*(): GType {.importc: "gtk_builder_error_get_type",
                                     libgtk.}
template typeBuilderError*(): expr =
  (builderErrorGetType())

proc calendarDisplayOptionsGetType*(): GType {.
    importc: "gtk_calendar_display_options_get_type", libgtk.}
template typeCalendarDisplayOptions*(): expr =
  (calendarDisplayOptionsGetType())

proc cellRendererStateGetType*(): GType {.
    importc: "gtk_cell_renderer_state_get_type", libgtk.}
template typeCellRendererState*(): expr =
  (cellRendererStateGetType())

proc cellRendererModeGetType*(): GType {.
    importc: "gtk_cell_renderer_mode_get_type", libgtk.}
template typeCellRendererMode*(): expr =
  (cellRendererModeGetType())

proc cellRendererAccelModeGetType*(): GType {.
    importc: "gtk_cell_renderer_accel_mode_get_type", libgtk.}
template typeCellRendererAccelMode*(): expr =
  (cellRendererAccelModeGetType())

proc resizeModeGetType*(): GType {.importc: "gtk_resize_mode_get_type",
                                   libgtk.}
template typeResizeMode*(): expr =
  (resizeModeGetType())

proc cssProviderErrorGetType*(): GType {.
    importc: "gtk_css_provider_error_get_type", libgtk.}
template typeCssProviderError*(): expr =
  (cssProviderErrorGetType())

proc cssSectionTypeGetType*(): GType {.importc: "gtk_css_section_type_get_type",
                                       libgtk.}
template typeCssSectionType*(): expr =
  (cssSectionTypeGetType())

proc debugFlagGetType*(): GType {.importc: "gtk_debug_flag_get_type", libgtk.}
template typeDebugFlag*(): expr =
  (debugFlagGetType())

proc dialogFlagsGetType*(): GType {.importc: "gtk_dialog_flags_get_type",
                                    libgtk.}
template typeDialogFlags*(): expr =
  (dialogFlagsGetType())

proc responseTypeGetType*(): GType {.importc: "gtk_response_type_get_type",
                                     libgtk.}
template typeResponseType*(): expr =
  (responseTypeGetType())

proc destDefaultsGetType*(): GType {.importc: "gtk_dest_defaults_get_type",
                                     libgtk.}
template typeDestDefaults*(): expr =
  (destDefaultsGetType())

proc targetFlagsGetType*(): GType {.importc: "gtk_target_flags_get_type",
                                    libgtk.}
template typeTargetFlags*(): expr =
  (targetFlagsGetType())

proc entryIconPositionGetType*(): GType {.
    importc: "gtk_entry_icon_position_get_type", libgtk.}
template typeEntryIconPosition*(): expr =
  (entryIconPositionGetType())

proc alignGetType*(): GType {.importc: "gtk_align_get_type", libgtk.}
template typeAlign*(): expr =
  (alignGetType())

proc arrowTypeGetType*(): GType {.importc: "gtk_arrow_type_get_type", libgtk.}
template typeArrowType*(): expr =
  (arrowTypeGetType())

proc baselinePositionGetType*(): GType {.
    importc: "gtk_baseline_position_get_type", libgtk.}
template typeBaselinePosition*(): expr =
  (baselinePositionGetType())

proc deleteTypeGetType*(): GType {.importc: "gtk_delete_type_get_type",
                                   libgtk.}
template typeDeleteType*(): expr =
  (deleteTypeGetType())

proc directionTypeGetType*(): GType {.importc: "gtk_direction_type_get_type",
                                      libgtk.}
template typeDirectionType*(): expr =
  (directionTypeGetType())

proc iconSizeGetType*(): GType {.importc: "gtk_icon_size_get_type", libgtk.}
template typeIconSize*(): expr =
  (iconSizeGetType())

proc sensitivityTypeGetType*(): GType {.importc: "gtk_sensitivity_type_get_type",
                                        libgtk.}
template typeSensitivityType*(): expr =
  (sensitivityTypeGetType())

proc textDirectionGetType*(): GType {.importc: "gtk_text_direction_get_type",
                                      libgtk.}
template typeTextDirection*(): expr =
  (textDirectionGetType())

proc justificationGetType*(): GType {.importc: "gtk_justification_get_type",
                                      libgtk.}
template typeJustification*(): expr =
  (justificationGetType())

proc menuDirectionTypeGetType*(): GType {.
    importc: "gtk_menu_direction_type_get_type", libgtk.}
template typeMenuDirectionType*(): expr =
  (menuDirectionTypeGetType())

proc messageTypeGetType*(): GType {.importc: "gtk_message_type_get_type",
                                    libgtk.}
template typeMessageType*(): expr =
  (messageTypeGetType())

proc movementStepGetType*(): GType {.importc: "gtk_movement_step_get_type",
                                     libgtk.}
template typeMovementStep*(): expr =
  (movementStepGetType())

proc scrollStepGetType*(): GType {.importc: "gtk_scroll_step_get_type",
                                   libgtk.}
template typeScrollStep*(): expr =
  (scrollStepGetType())

proc orientationGetType*(): GType {.importc: "gtk_orientation_get_type",
                                    libgtk.}
template typeOrientation*(): expr =
  (orientationGetType())

proc packTypeGetType*(): GType {.importc: "gtk_pack_type_get_type", libgtk.}
template typePackType*(): expr =
  (packTypeGetType())

proc positionTypeGetType*(): GType {.importc: "gtk_position_type_get_type",
                                     libgtk.}
template typePositionType*(): expr =
  (positionTypeGetType())

proc reliefStyleGetType*(): GType {.importc: "gtk_relief_style_get_type",
                                    libgtk.}
template typeReliefStyle*(): expr =
  (reliefStyleGetType())

proc scrollTypeGetType*(): GType {.importc: "gtk_scroll_type_get_type",
                                   libgtk.}
template typeScrollType*(): expr =
  (scrollTypeGetType())

proc selectionModeGetType*(): GType {.importc: "gtk_selection_mode_get_type",
                                      libgtk.}
template typeSelectionMode*(): expr =
  (selectionModeGetType())

proc shadowTypeGetType*(): GType {.importc: "gtk_shadow_type_get_type",
                                   libgtk.}
template typeShadowType*(): expr =
  (shadowTypeGetType())

proc stateTypeGetType*(): GType {.importc: "gtk_state_type_get_type", libgtk.}
template typeStateType*(): expr =
  (stateTypeGetType())

proc toolbarStyleGetType*(): GType {.importc: "gtk_toolbar_style_get_type",
                                     libgtk.}
template typeToolbarStyle*(): expr =
  (toolbarStyleGetType())

proc wrapModeGetType*(): GType {.importc: "gtk_wrap_mode_get_type", libgtk.}
template typeWrapMode*(): expr =
  (wrapModeGetType())

proc sortTypeGetType*(): GType {.importc: "gtk_sort_type_get_type", libgtk.}
template typeSortType*(): expr =
  (sortTypeGetType())

proc imPreeditStyleGetType*(): GType {.importc: "gtk_im_preedit_style_get_type",
                                       libgtk.}
template typeImPreeditStyle*(): expr =
  (imPreeditStyleGetType())

proc imStatusStyleGetType*(): GType {.importc: "gtk_im_status_style_get_type",
                                      libgtk.}
template typeImStatusStyle*(): expr =
  (imStatusStyleGetType())

proc packDirectionGetType*(): GType {.importc: "gtk_pack_direction_get_type",
                                      libgtk.}
template typePackDirection*(): expr =
  (packDirectionGetType())

proc printPagesGetType*(): GType {.importc: "gtk_print_pages_get_type",
                                   libgtk.}
template typePrintPages*(): expr =
  (printPagesGetType())

proc pageSetGetType*(): GType {.importc: "gtk_page_set_get_type", libgtk.}
template typePageSet*(): expr =
  (pageSetGetType())

proc numberUpLayoutGetType*(): GType {.importc: "gtk_number_up_layout_get_type",
                                       libgtk.}
template typeNumberUpLayout*(): expr =
  (numberUpLayoutGetType())

proc pageOrientationGetType*(): GType {.importc: "gtk_page_orientation_get_type",
                                        libgtk.}
template typePageOrientation*(): expr =
  (pageOrientationGetType())

proc printQualityGetType*(): GType {.importc: "gtk_print_quality_get_type",
                                     libgtk.}
template typePrintQuality*(): expr =
  (printQualityGetType())

proc printDuplexGetType*(): GType {.importc: "gtk_print_duplex_get_type",
                                    libgtk.}
template typePrintDuplex*(): expr =
  (printDuplexGetType())

proc unitGetType*(): GType {.importc: "gtk_unit_get_type", libgtk.}
template typeUnit*(): expr =
  (unitGetType())

proc treeViewGridLinesGetType*(): GType {.
    importc: "gtk_tree_view_grid_lines_get_type", libgtk.}
template typeTreeViewGridLines*(): expr =
  (treeViewGridLinesGetType())

proc dragResultGetType*(): GType {.importc: "gtk_drag_result_get_type",
                                   libgtk.}
template typeDragResult*(): expr =
  (dragResultGetType())

proc sizeGroupModeGetType*(): GType {.importc: "gtk_size_group_mode_get_type",
                                      libgtk.}
template typeSizeGroupMode*(): expr =
  (sizeGroupModeGetType())

proc sizeRequestModeGetType*(): GType {.importc: "gtk_size_request_mode_get_type",
                                        libgtk.}
template typeSizeRequestMode*(): expr =
  (sizeRequestModeGetType())

proc scrollablePolicyGetType*(): GType {.
    importc: "gtk_scrollable_policy_get_type", libgtk.}
template typeScrollablePolicy*(): expr =
  (scrollablePolicyGetType())

proc stateFlagsGetType*(): GType {.importc: "gtk_state_flags_get_type",
                                   libgtk.}
template typeStateFlags*(): expr =
  (stateFlagsGetType())

proc regionFlagsGetType*(): GType {.importc: "gtk_region_flags_get_type",
                                    libgtk.}
template typeRegionFlags*(): expr =
  (regionFlagsGetType())

proc junctionSidesGetType*(): GType {.importc: "gtk_junction_sides_get_type",
                                      libgtk.}
template typeJunctionSides*(): expr =
  (junctionSidesGetType())

proc borderStyleGetType*(): GType {.importc: "gtk_border_style_get_type",
                                    libgtk.}
template typeBorderStyle*(): expr =
  (borderStyleGetType())

proc levelBarModeGetType*(): GType {.importc: "gtk_level_bar_mode_get_type",
                                     libgtk.}
template typeLevelBarMode*(): expr =
  (levelBarModeGetType())

proc inputPurposeGetType*(): GType {.importc: "gtk_input_purpose_get_type",
                                     libgtk.}
template typeInputPurpose*(): expr =
  (inputPurposeGetType())

proc inputHintsGetType*(): GType {.importc: "gtk_input_hints_get_type",
                                   libgtk.}
template typeInputHints*(): expr =
  (inputHintsGetType())

proc propagationPhaseGetType*(): GType {.
    importc: "gtk_propagation_phase_get_type", libgtk.}
template typePropagationPhase*(): expr =
  (propagationPhaseGetType())

proc eventSequenceStateGetType*(): GType {.
    importc: "gtk_event_sequence_state_get_type", libgtk.}
template typeEventSequenceState*(): expr =
  (eventSequenceStateGetType())

proc panDirectionGetType*(): GType {.importc: "gtk_pan_direction_get_type",
                                     libgtk.}
template typePanDirection*(): expr =
  (panDirectionGetType())

proc popoverConstraintGetType*(): GType {.
    importc: "gtk_popover_constraint_get_type", libgtk.}
template typePopoverConstraint*(): expr =
  (popoverConstraintGetType())

proc fileChooserActionGetType*(): GType {.
    importc: "gtk_file_chooser_action_get_type", libgtk.}
template typeFileChooserAction*(): expr =
  (fileChooserActionGetType())

proc fileChooserConfirmationGetType*(): GType {.
    importc: "gtk_file_chooser_confirmation_get_type", libgtk.}
template typeFileChooserConfirmation*(): expr =
  (fileChooserConfirmationGetType())

proc fileChooserErrorGetType*(): GType {.
    importc: "gtk_file_chooser_error_get_type", libgtk.}
template typeFileChooserError*(): expr =
  (fileChooserErrorGetType())

proc fileFilterFlagsGetType*(): GType {.importc: "gtk_file_filter_flags_get_type",
                                        libgtk.}
template typeFileFilterFlags*(): expr =
  (fileFilterFlagsGetType())

proc iconLookupFlagsGetType*(): GType {.importc: "gtk_icon_lookup_flags_get_type",
                                        libgtk.}
template typeIconLookupFlags*(): expr =
  (iconLookupFlagsGetType())

proc iconThemeErrorGetType*(): GType {.importc: "gtk_icon_theme_error_get_type",
                                       libgtk.}
template typeIconThemeError*(): expr =
  (iconThemeErrorGetType())

proc iconViewDropPositionGetType*(): GType {.
    importc: "gtk_icon_view_drop_position_get_type", libgtk.}
template typeIconViewDropPosition*(): expr =
  (iconViewDropPositionGetType())

proc imageTypeGetType*(): GType {.importc: "gtk_image_type_get_type", libgtk.}
template typeImageType*(): expr =
  (imageTypeGetType())

proc arrowPlacementGetType*(): GType {.importc: "gtk_arrow_placement_get_type",
                                       libgtk.}
template typeArrowPlacement*(): expr =
  (arrowPlacementGetType())

proc buttonsTypeGetType*(): GType {.importc: "gtk_buttons_type_get_type",
                                    libgtk.}
template typeButtonsType*(): expr =
  (buttonsTypeGetType())

proc buttonRoleGetType*(): GType {.importc: "gtk_button_role_get_type",
                                   libgtk.}
template typeButtonRole*(): expr =
  (buttonRoleGetType())

proc notebookTabGetType*(): GType {.importc: "gtk_notebook_tab_get_type",
                                    libgtk.}
template typeNotebookTab*(): expr =
  (notebookTabGetType())

proc placesOpenFlagsGetType*(): GType {.importc: "gtk_places_open_flags_get_type",
                                        libgtk.}
template typePlacesOpenFlags*(): expr =
  (placesOpenFlagsGetType())

proc printStatusGetType*(): GType {.importc: "gtk_print_status_get_type",
                                    libgtk.}
template typePrintStatus*(): expr =
  (printStatusGetType())

proc printOperationResultGetType*(): GType {.
    importc: "gtk_print_operation_result_get_type", libgtk.}
template typePrintOperationResult*(): expr =
  (printOperationResultGetType())

proc printOperationActionGetType*(): GType {.
    importc: "gtk_print_operation_action_get_type", libgtk.}
template typePrintOperationAction*(): expr =
  (printOperationActionGetType())

proc printErrorGetType*(): GType {.importc: "gtk_print_error_get_type",
                                   libgtk.}
template typePrintError*(): expr =
  (printErrorGetType())

proc recentSortTypeGetType*(): GType {.importc: "gtk_recent_sort_type_get_type",
                                       libgtk.}
template typeRecentSortType*(): expr =
  (recentSortTypeGetType())

proc recentChooserErrorGetType*(): GType {.
    importc: "gtk_recent_chooser_error_get_type", libgtk.}
template typeRecentChooserError*(): expr =
  (recentChooserErrorGetType())

proc recentFilterFlagsGetType*(): GType {.
    importc: "gtk_recent_filter_flags_get_type", libgtk.}
template typeRecentFilterFlags*(): expr =
  (recentFilterFlagsGetType())

proc recentManagerErrorGetType*(): GType {.
    importc: "gtk_recent_manager_error_get_type", libgtk.}
template typeRecentManagerError*(): expr =
  (recentManagerErrorGetType())

proc revealerTransitionTypeGetType*(): GType {.
    importc: "gtk_revealer_transition_type_get_type", libgtk.}
template typeRevealerTransitionType*(): expr =
  (revealerTransitionTypeGetType())

proc cornerTypeGetType*(): GType {.importc: "gtk_corner_type_get_type",
                                   libgtk.}
template typeCornerType*(): expr =
  (cornerTypeGetType())

proc policyTypeGetType*(): GType {.importc: "gtk_policy_type_get_type",
                                   libgtk.}
template typePolicyType*(): expr =
  (policyTypeGetType())

proc shortcutTypeGetType*(): GType {.importc: "gtk_shortcut_type_get_type",
                                     libgtk.}
template typeShortcutType*(): expr =
  (shortcutTypeGetType())

proc spinButtonUpdatePolicyGetType*(): GType {.
    importc: "gtk_spin_button_update_policy_get_type", libgtk.}
template typeSpinButtonUpdatePolicy*(): expr =
  (spinButtonUpdatePolicyGetType())

proc spinTypeGetType*(): GType {.importc: "gtk_spin_type_get_type", libgtk.}
template typeSpinType*(): expr =
  (spinTypeGetType())

proc stackTransitionTypeGetType*(): GType {.
    importc: "gtk_stack_transition_type_get_type", libgtk.}
template typeStackTransitionType*(): expr =
  (stackTransitionTypeGetType())

proc styleContextPrintFlagsGetType*(): GType {.
    importc: "gtk_style_context_print_flags_get_type", libgtk.}
template typeStyleContextPrintFlags*(): expr =
  (styleContextPrintFlagsGetType())

proc textBufferTargetInfoGetType*(): GType {.
    importc: "gtk_text_buffer_target_info_get_type", libgtk.}
template typeTextBufferTargetInfo*(): expr =
  (textBufferTargetInfoGetType())

proc textSearchFlagsGetType*(): GType {.importc: "gtk_text_search_flags_get_type",
                                        libgtk.}
template typeTextSearchFlags*(): expr =
  (textSearchFlagsGetType())

proc textWindowTypeGetType*(): GType {.importc: "gtk_text_window_type_get_type",
                                       libgtk.}
template typeTextWindowType*(): expr =
  (textWindowTypeGetType())

proc textViewLayerGetType*(): GType {.importc: "gtk_text_view_layer_get_type",
                                      libgtk.}
template typeTextViewLayer*(): expr =
  (textViewLayerGetType())

proc textExtendSelectionGetType*(): GType {.
    importc: "gtk_text_extend_selection_get_type", libgtk.}
template typeTextExtendSelection*(): expr =
  (textExtendSelectionGetType())

proc toolbarSpaceStyleGetType*(): GType {.
    importc: "gtk_toolbar_space_style_get_type", libgtk.}
template typeToolbarSpaceStyle*(): expr =
  (toolbarSpaceStyleGetType())

proc toolPaletteDragTargetsGetType*(): GType {.
    importc: "gtk_tool_palette_drag_targets_get_type", libgtk.}
template typeToolPaletteDragTargets*(): expr =
  (toolPaletteDragTargetsGetType())

proc treeModelFlagsGetType*(): GType {.importc: "gtk_tree_model_flags_get_type",
                                       libgtk.}
template typeTreeModelFlags*(): expr =
  (treeModelFlagsGetType())

proc treeViewDropPositionGetType*(): GType {.
    importc: "gtk_tree_view_drop_position_get_type", libgtk.}
template typeTreeViewDropPosition*(): expr =
  (treeViewDropPositionGetType())

proc treeViewColumnSizingGetType*(): GType {.
    importc: "gtk_tree_view_column_sizing_get_type", libgtk.}
template typeTreeViewColumnSizing*(): expr =
  (treeViewColumnSizingGetType())

proc widgetHelpTypeGetType*(): GType {.importc: "gtk_widget_help_type_get_type",
                                       libgtk.}
template typeWidgetHelpType*(): expr =
  (widgetHelpTypeGetType())

proc windowTypeGetType*(): GType {.importc: "gtk_window_type_get_type",
                                   libgtk.}
template typeWindowType*(): expr =
  (windowTypeGetType())

proc windowPositionGetType*(): GType {.importc: "gtk_window_position_get_type",
                                       libgtk.}
template typeWindowPosition*(): expr =
  (windowPositionGetType())

proc rcFlagsGetType*(): GType {.importc: "gtk_rc_flags_get_type", libgtk.}
template typeRcFlags*(): expr =
  (rcFlagsGetType())

proc rcTokenTypeGetType*(): GType {.importc: "gtk_rc_token_type_get_type",
                                    libgtk.}
template typeRcTokenType*(): expr =
  (rcTokenTypeGetType())

proc pathPriorityTypeGetType*(): GType {.
    importc: "gtk_path_priority_type_get_type", libgtk.}
template typePathPriorityType*(): expr =
  (pathPriorityTypeGetType())

proc pathTypeGetType*(): GType {.importc: "gtk_path_type_get_type", libgtk.}
template typePathType*(): expr =
  (pathTypeGetType())

proc expanderStyleGetType*(): GType {.importc: "gtk_expander_style_get_type",
                                      libgtk.}
template typeExpanderStyle*(): expr =
  (expanderStyleGetType())

proc attachOptionsGetType*(): GType {.importc: "gtk_attach_options_get_type",
                                      libgtk.}
template typeAttachOptions*(): expr =
  (attachOptionsGetType())

proc uiManagerItemTypeGetType*(): GType {.
    importc: "gtk_ui_manager_item_type_get_type", libgtk.}
template typeUiManagerItemType*(): expr =
  (uiManagerItemTypeGetType())

template typeViewport*(): expr =
  (viewportGetType())

template viewport*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeViewport, ViewportObj))

template viewportClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeViewport, ViewportClassObj))

template isViewport*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeViewport))

template isViewportClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeViewport))

template viewportGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeViewport, ViewportClassObj))

type
  VolumeButton* =  ptr VolumeButtonObj
  VolumeButtonPtr* = ptr VolumeButtonObj
  VolumeButtonObj*{.final.} = object of ScaleButtonObj

  VolumeButtonClass* =  ptr VolumeButtonClassObj
  VolumeButtonClassPtr* = ptr VolumeButtonClassObj
  VolumeButtonClassObj*{.final.} = object of ScaleButtonClassObj
    gtkReserved1311*: proc () {.cdecl.}
    gtkReserved1312*: proc () {.cdecl.}
    gtkReserved1313*: proc () {.cdecl.}
    gtkReserved1314*: proc () {.cdecl.}

proc viewportGetType*(): GType {.importc: "gtk_viewport_get_type", libgtk.}
proc newViewport*(hadjustment: Adjustment; vadjustment: Adjustment): Viewport {.
    importc: "gtk_viewport_new", libgtk.}
proc getHadjustment*(viewport: Viewport): Adjustment {.
    importc: "gtk_viewport_get_hadjustment", libgtk.}
proc hadjustment*(viewport: Viewport): Adjustment {.
    importc: "gtk_viewport_get_hadjustment", libgtk.}
proc getVadjustment*(viewport: Viewport): Adjustment {.
    importc: "gtk_viewport_get_vadjustment", libgtk.}
proc vadjustment*(viewport: Viewport): Adjustment {.
    importc: "gtk_viewport_get_vadjustment", libgtk.}
proc setHadjustment*(viewport: Viewport;
                               adjustment: Adjustment) {.
    importc: "gtk_viewport_set_hadjustment", libgtk.}
proc `hadjustment=`*(viewport: Viewport;
                               adjustment: Adjustment) {.
    importc: "gtk_viewport_set_hadjustment", libgtk.}
proc setVadjustment*(viewport: Viewport;
                               adjustment: Adjustment) {.
    importc: "gtk_viewport_set_vadjustment", libgtk.}
proc `vadjustment=`*(viewport: Viewport;
                               adjustment: Adjustment) {.
    importc: "gtk_viewport_set_vadjustment", libgtk.}
proc setShadowType*(viewport: Viewport; `type`: ShadowType) {.
    importc: "gtk_viewport_set_shadow_type", libgtk.}
proc `shadowType=`*(viewport: Viewport; `type`: ShadowType) {.
    importc: "gtk_viewport_set_shadow_type", libgtk.}
proc getShadowType*(viewport: Viewport): ShadowType {.
    importc: "gtk_viewport_get_shadow_type", libgtk.}
proc shadowType*(viewport: Viewport): ShadowType {.
    importc: "gtk_viewport_get_shadow_type", libgtk.}
proc getBinWindow*(viewport: Viewport): gdk3.Window {.
    importc: "gtk_viewport_get_bin_window", libgtk.}
proc binWindow*(viewport: Viewport): gdk3.Window {.
    importc: "gtk_viewport_get_bin_window", libgtk.}
proc getViewWindow*(viewport: Viewport): gdk3.Window {.
    importc: "gtk_viewport_get_view_window", libgtk.}
proc viewWindow*(viewport: Viewport): gdk3.Window {.
    importc: "gtk_viewport_get_view_window", libgtk.}

template typeVolumeButton*(): expr =
  (volumeButtonGetType())

template volumeButton*(obj: expr): expr =
  (gTypeCheckInstanceCast(obj, typeVolumeButton, VolumeButtonObj))

template volumeButtonClass*(klass: expr): expr =
  (gTypeCheckClassCast(klass, typeVolumeButton, VolumeButtonClassObj))

template isVolumeButton*(obj: expr): expr =
  (gTypeCheckInstanceType(obj, typeVolumeButton))

template isVolumeButtonClass*(klass: expr): expr =
  (gTypeCheckClassType(klass, typeVolumeButton))

template volumeButtonGetClass*(obj: expr): expr =
  (gTypeInstanceGetClass(obj, typeVolumeButton, VolumeButtonClassObj))

type
  WindowGroupClass* =  ptr WindowGroupClassObj
  WindowGroupClassPtr* = ptr WindowGroupClassObj
  WindowGroupClassObj*{.final.} = object of GObjectClassObj
    gtkReserved1321*: proc () {.cdecl.}
    gtkReserved1322*: proc () {.cdecl.}
    gtkReserved1323*: proc () {.cdecl.}
    gtkReserved1324*: proc () {.cdecl.}

proc volumeButtonGetType*(): GType {.importc: "gtk_volume_button_get_type",
                                     libgtk.}
proc newVolumeButton*(): VolumeButton {.importc: "gtk_volume_button_new",
                                        libgtk.}

template typeWidgetPath*(): expr =
  (widgetPathGetType())

proc widgetPathGetType*(): GType {.importc: "gtk_widget_path_get_type",
                                   libgtk.}
proc newWidgetPath*(): WidgetPath {.importc: "gtk_widget_path_new",
    libgtk.}
proc copy*(path: WidgetPath): WidgetPath {.
    importc: "gtk_widget_path_copy", libgtk.}
proc `ref`*(path: WidgetPath): WidgetPath {.
    importc: "gtk_widget_path_ref", libgtk.}
proc unref*(path: WidgetPath) {.
    importc: "gtk_widget_path_unref", libgtk.}
proc free*(path: WidgetPath) {.importc: "gtk_widget_path_free",
    libgtk.}
proc toString*(path: WidgetPath): cstring {.
    importc: "gtk_widget_path_to_string", libgtk.}
proc length*(path: WidgetPath): cint {.
    importc: "gtk_widget_path_length", libgtk.}
proc appendType*(path: WidgetPath; `type`: GType): cint {.
    importc: "gtk_widget_path_append_type", libgtk.}
proc prependType*(path: WidgetPath; `type`: GType) {.
    importc: "gtk_widget_path_prepend_type", libgtk.}
proc appendWithSiblings*(path: WidgetPath;
                                     siblings: WidgetPath;
                                     siblingIndex: cuint): cint {.
    importc: "gtk_widget_path_append_with_siblings", libgtk.}

proc appendForWidget*(path: WidgetPath; widget: Widget): cint {.
    importc: "gtk_widget_path_append_for_widget", libgtk.}
proc iterGetObjectType*(path: WidgetPath; pos: cint): GType {.
    importc: "gtk_widget_path_iter_get_object_type", libgtk.}
proc iterSetObjectType*(path: WidgetPath; pos: cint; `type`: GType) {.
    importc: "gtk_widget_path_iter_set_object_type", libgtk.}
proc iterGetObjectName*(path: WidgetPath; pos: cint): cstring {.
    importc: "gtk_widget_path_iter_get_object_name", libgtk.}
proc iterSetObjectName*(path: WidgetPath; pos: cint; name: cstring) {.
    importc: "gtk_widget_path_iter_set_object_name", libgtk.}
proc iterGetSiblings*(path: WidgetPath; pos: cint): WidgetPath {.
    importc: "gtk_widget_path_iter_get_siblings", libgtk.}
proc iterGetSiblingIndex*(path: WidgetPath; pos: cint): cuint {.
    importc: "gtk_widget_path_iter_get_sibling_index", libgtk.}
proc iterGetName*(path: WidgetPath; pos: cint): cstring {.
    importc: "gtk_widget_path_iter_get_name", libgtk.}
proc iterSetName*(path: WidgetPath; pos: cint; name: cstring) {.
    importc: "gtk_widget_path_iter_set_name", libgtk.}
proc iterHasName*(path: WidgetPath; pos: cint; name: cstring): Gboolean {.
    importc: "gtk_widget_path_iter_has_name", libgtk.}
proc iterHasQname*(path: WidgetPath; pos: cint; qname: GQuark): Gboolean {.
    importc: "gtk_widget_path_iter_has_qname", libgtk.}
proc iterGetState*(path: WidgetPath; pos: cint): StateFlags {.
    importc: "gtk_widget_path_iter_get_state", libgtk.}
proc iterSetState*(path: WidgetPath; pos: cint;
                               state: StateFlags) {.
    importc: "gtk_widget_path_iter_set_state", libgtk.}
proc iterAddClass*(path: WidgetPath; pos: cint; name: cstring) {.
    importc: "gtk_widget_path_iter_add_class", libgtk.}
proc iterRemoveClass*(path: WidgetPath; pos: cint; name: cstring) {.
    importc: "gtk_widget_path_iter_remove_class", libgtk.}
proc iterClearClasses*(path: WidgetPath; pos: cint) {.
    importc: "gtk_widget_path_iter_clear_classes", libgtk.}
proc iterListClasses*(path: WidgetPath; pos: cint): glib.GSList {.
    importc: "gtk_widget_path_iter_list_classes", libgtk.}
proc iterHasClass*(path: WidgetPath; pos: cint; name: cstring): Gboolean {.
    importc: "gtk_widget_path_iter_has_class", libgtk.}
proc iterHasQclass*(path: WidgetPath; pos: cint; qname: GQuark): Gboolean {.
    importc: "gtk_widget_path_iter_has_qclass", libgtk.}
proc iterAddRegion*(path: WidgetPath; pos: cint; name: cstring;
                                flags: RegionFlags) {.
    importc: "gtk_widget_path_iter_add_region", libgtk.}
proc iterRemoveRegion*(path: WidgetPath; pos: cint; name: cstring) {.
    importc: "gtk_widget_path_iter_remove_region", libgtk.}
proc iterClearRegions*(path: WidgetPath; pos: cint) {.
    importc: "gtk_widget_path_iter_clear_regions", libgtk.}
proc iterListRegions*(path: WidgetPath; pos: cint): glib.GSList {.
    importc: "gtk_widget_path_iter_list_regions", libgtk.}
proc iterHasRegion*(path: WidgetPath; pos: cint; name: cstring;
                                flags: ptr RegionFlags): Gboolean {.
    importc: "gtk_widget_path_iter_has_region", libgtk.}
proc iterHasQregion*(path: WidgetPath; pos: cint; qname: GQuark;
                                 flags: ptr RegionFlags): Gboolean {.
    importc: "gtk_widget_path_iter_has_qregion", libgtk.}
proc getObjectType*(path: WidgetPath): GType {.
    importc: "gtk_widget_path_get_object_type", libgtk.}
proc objectType*(path: WidgetPath): GType {.
    importc: "gtk_widget_path_get_object_type", libgtk.}
proc isType*(path: WidgetPath; `type`: GType): Gboolean {.
    importc: "gtk_widget_path_is_type", libgtk.}
proc hasParent*(path: WidgetPath; `type`: GType): Gboolean {.
    importc: "gtk_widget_path_has_parent", libgtk.}

template typeWindowGroup*(): expr =
  (windowGroupGetType())

template windowGroup*(`object`: expr): expr =
  (gTypeCheckInstanceCast(`object`, typeWindowGroup, WindowGroupObj))

template windowGroupClass*(klass: expr): expr =
  (gTypeCheckC