 {.deadCodeElim: on.}
import
  glib2, gdk2pixbuf, pango, cairo
when defined(win32): 
  const 
    lib* = "libgdk-win32-3.0-0.dll"
elif defined(macosx): 
  const 
    lib* = "libgdk-quartz-3.0.dylib"
else: 
  const 
    lib* = "libgdk-3.so(|.0)"
type 
  Pcairo_rectangle_int_t* = ptr Tcairo_rectangle_int_t
  Tcairo_rectangle_int_t*{.final, pure.} = object 
    x*: cint
    y*: cint
    width*: cint
    height*: cint

type 
  PGError* = ptr TGError
  TGError*{.final, pure.} = object 
    domain*: TGQuark
    code*: gint
    message*: CSTRING

type 
  PGIcon* = PGObject
type 
  PDisplay* = ptr TDisplay
  TDisplay* = object of TGObject 
  
type 
  PWindow* = ptr TWindow
  TWindow* = object of TGObject 
  
type 
  PVisual* = ptr TVisual
  TVisual* = object of TGObject 
  
type 
  PCursor* = ptr TCursor
  TCursor* = object of TGObject 
  
type 
  PScreen* = ptr TScreen
  TScreen* = object of TGObject 
  
type 
  Atom* = gulong
  XID* = gulong
  VisualID* = culong
  HWND* = ptr culong
  HGDIOBJ* = ptr culong
  Pwl_seat* = ptr culong
  Pwl_pointer* = ptr culong
  Pwl_keyboard* = ptr culong
  Pwl_display* = ptr culong
  Pwl_compositor* = ptr culong
  Pwl_surface* = ptr culong
  Pxdg_shell* = ptr culong
  PNSString* = ptr culong
  PNSImage* = ptr culong
  PNSEvent* = ptr culong
  PNSWindow* = ptr culong
  PNSView* = ptr culong
  id* = culong

const 
  KEY_VoidSymbol* = 0x00FFFFFF
  KEY_BackSpace* = 0x0000FF08
  KEY_Tab* = 0x0000FF09
  KEY_Linefeed* = 0x0000FF0A
  KEY_Clear* = 0x0000FF0B
  KEY_Return* = 0x0000FF0D
  KEY_Pause* = 0x0000FF13
  KEY_Scroll_Lock* = 0x0000FF14
  KEY_Sys_Req* = 0x0000FF15
  KEY_Escape* = 0x0000FF1B
  KEY_Delete* = 0x0000FFFF
  KEY_Multi_key* = 0x0000FF20
  KEY_Codeinput* = 0x0000FF37
  KEY_SingleCandidate* = 0x0000FF3C
  KEY_MultipleCandidate* = 0x0000FF3D
  KEY_PreviousCandidate* = 0x0000FF3E
  KEY_Kanji* = 0x0000FF21
  KEY_Muhenkan* = 0x0000FF22
  KEY_Henkan_Mode* = 0x0000FF23
  KEY_Henkan* = 0x0000FF23
  KEY_Romaji* = 0x0000FF24
  KEY_Hiragana* = 0x0000FF25
  KEY_Katakana* = 0x0000FF26
  KEY_Hiragana_Katakana* = 0x0000FF27
  KEY_Zenkaku* = 0x0000FF28
  KEY_Hankaku* = 0x0000FF29
  KEY_Zenkaku_Hankaku* = 0x0000FF2A
  KEY_Touroku* = 0x0000FF2B
  KEY_Massyo* = 0x0000FF2C
  KEY_Kana_Lock* = 0x0000FF2D
  KEY_Kana_Shift* = 0x0000FF2E
  KEY_Eisu_Shift* = 0x0000FF2F
  KEY_Eisu_toggle* = 0x0000FF30
  KEY_Kanji_Bangou* = 0x0000FF37
  KEY_Zen_Koho* = 0x0000FF3D
  KEY_Mae_Koho* = 0x0000FF3E
  KEY_Home* = 0x0000FF50
  KEY_Left* = 0x0000FF51
  KEY_Up* = 0x0000FF52
  KEY_Right* = 0x0000FF53
  KEY_Down* = 0x0000FF54
  KEY_Prior* = 0x0000FF55
  KEY_Page_Up* = 0x0000FF55
  KEY_Next* = 0x0000FF56
  KEY_Page_Down* = 0x0000FF56
  KEY_End* = 0x0000FF57
  KEY_Begin* = 0x0000FF58
  KEY_Select* = 0x0000FF60
  KEY_Print* = 0x0000FF61
  KEY_Execute* = 0x0000FF62
  KEY_Insert* = 0x0000FF63
  KEY_Undo* = 0x0000FF65
  KEY_Redo* = 0x0000FF66
  KEY_Menu* = 0x0000FF67
  KEY_Find* = 0x0000FF68
  KEY_Cancel* = 0x0000FF69
  KEY_Help* = 0x0000FF6A
  KEY_Break* = 0x0000FF6B
  KEY_Mode_switch* = 0x0000FF7E
  KEY_script_switch* = 0x0000FF7E
  KEY_Num_Lock* = 0x0000FF7F
  KEY_KP_Space* = 0x0000FF80
  KEY_KP_Tab* = 0x0000FF89
  KEY_KP_Enter* = 0x0000FF8D
  KEY_KP_F1* = 0x0000FF91
  KEY_KP_F2* = 0x0000FF92
  KEY_KP_F3* = 0x0000FF93
  KEY_KP_F4* = 0x0000FF94
  KEY_KP_Home* = 0x0000FF95
  KEY_KP_Left* = 0x0000FF96
  KEY_KP_Up* = 0x0000FF97
  KEY_KP_Right* = 0x0000FF98
  KEY_KP_Down* = 0x0000FF99
  KEY_KP_Prior* = 0x0000FF9A
  KEY_KP_Page_Up* = 0x0000FF9A
  KEY_KP_Next* = 0x0000FF9B
  KEY_KP_Page_Down* = 0x0000FF9B
  KEY_KP_End* = 0x0000FF9C
  KEY_KP_Begin* = 0x0000FF9D
  KEY_KP_Insert* = 0x0000FF9E
  KEY_KP_Delete* = 0x0000FF9F
  KEY_KP_Equal* = 0x0000FFBD
  KEY_KP_Multiply* = 0x0000FFAA
  KEY_KP_Add* = 0x0000FFAB
  KEY_KP_Separator* = 0x0000FFAC
  KEY_KP_Subtract* = 0x0000FFAD
  KEY_KP_Decimal* = 0x0000FFAE
  KEY_KP_Divide* = 0x0000FFAF
  KEY_KP_0* = 0x0000FFB0
  KEY_KP_1* = 0x0000FFB1
  KEY_KP_2* = 0x0000FFB2
  KEY_KP_3* = 0x0000FFB3
  KEY_KP_4* = 0x0000FFB4
  KEY_KP_5* = 0x0000FFB5
  KEY_KP_6* = 0x0000FFB6
  KEY_KP_7* = 0x0000FFB7
  KEY_KP_8* = 0x0000FFB8
  KEY_KP_9* = 0x0000FFB9
  KEY_F1* = 0x0000FFBE
  KEY_F2* = 0x0000FFBF
  KEY_F3* = 0x0000FFC0
  KEY_F4* = 0x0000FFC1
  KEY_F5* = 0x0000FFC2
  KEY_F6* = 0x0000FFC3
  KEY_F7* = 0x0000FFC4
  KEY_F8* = 0x0000FFC5
  KEY_F9* = 0x0000FFC6
  KEY_F10* = 0x0000FFC7
  KEY_F11* = 0x0000FFC8
  KEY_L1* = 0x0000FFC8
  KEY_F12* = 0x0000FFC9
  KEY_L2* = 0x0000FFC9
  KEY_F13* = 0x0000FFCA
  KEY_L3* = 0x0000FFCA
  KEY_F14* = 0x0000FFCB
  KEY_L4* = 0x0000FFCB
  KEY_F15* = 0x0000FFCC
  KEY_L5* = 0x0000FFCC
  KEY_F16* = 0x0000FFCD
  KEY_L6* = 0x0000FFCD
  KEY_F17* = 0x0000FFCE
  KEY_L7* = 0x0000FFCE
  KEY_F18* = 0x0000FFCF
  KEY_L8* = 0x0000FFCF
  KEY_F19* = 0x0000FFD0
  KEY_L9* = 0x0000FFD0
  KEY_F20* = 0x0000FFD1
  KEY_L10* = 0x0000FFD1
  KEY_F21* = 0x0000FFD2
  KEY_R1* = 0x0000FFD2
  KEY_F22* = 0x0000FFD3
  KEY_R2* = 0x0000FFD3
  KEY_F23* = 0x0000FFD4
  KEY_R3* = 0x0000FFD4
  KEY_F24* = 0x0000FFD5
  KEY_R4* = 0x0000FFD5
  KEY_F25* = 0x0000FFD6
  KEY_R5* = 0x0000FFD6
  KEY_F26* = 0x0000FFD7
  KEY_R6* = 0x0000FFD7
  KEY_F27* = 0x0000FFD8
  KEY_R7* = 0x0000FFD8
  KEY_F28* = 0x0000FFD9
  KEY_R8* = 0x0000FFD9
  KEY_F29* = 0x0000FFDA
  KEY_R9* = 0x0000FFDA
  KEY_F30* = 0x0000FFDB
  KEY_R10* = 0x0000FFDB
  KEY_F31* = 0x0000FFDC
  KEY_R11* = 0x0000FFDC
  KEY_F32* = 0x0000FFDD
  KEY_R12* = 0x0000FFDD
  KEY_F33* = 0x0000FFDE
  KEY_R13* = 0x0000FFDE
  KEY_F34* = 0x0000FFDF
  KEY_R14* = 0x0000FFDF
  KEY_F35* = 0x0000FFE0
  KEY_R15* = 0x0000FFE0
  KEY_Shift_L* = 0x0000FFE1
  KEY_Shift_R* = 0x0000FFE2
  KEY_Control_L* = 0x0000FFE3
  KEY_Control_R* = 0x0000FFE4
  KEY_Caps_Lock* = 0x0000FFE5
  KEY_Shift_Lock* = 0x0000FFE6
  KEY_Meta_L* = 0x0000FFE7
  KEY_Meta_R* = 0x0000FFE8
  KEY_Alt_L* = 0x0000FFE9
  KEY_Alt_R* = 0x0000FFEA
  KEY_Super_L* = 0x0000FFEB
  KEY_Super_R* = 0x0000FFEC
  KEY_Hyper_L* = 0x0000FFED
  KEY_Hyper_R* = 0x0000FFEE
  KEY_ISO_Lock* = 0x0000FE01
  KEY_ISO_Level2_Latch* = 0x0000FE02
  KEY_ISO_Level3_Shift* = 0x0000FE03
  KEY_ISO_Level3_Latch* = 0x0000FE04
  KEY_ISO_Level3_Lock* = 0x0000FE05
  KEY_ISO_Level5_Shift* = 0x0000FE11
  KEY_ISO_Level5_Latch* = 0x0000FE12
  KEY_ISO_Level5_Lock* = 0x0000FE13
  KEY_ISO_Group_Shift* = 0x0000FF7E
  KEY_ISO_Group_Latch* = 0x0000FE06
  KEY_ISO_Group_Lock* = 0x0000FE07
  KEY_ISO_Next_Group* = 0x0000FE08
  KEY_ISO_Next_Group_Lock* = 0x0000FE09
  KEY_ISO_Prev_Group* = 0x0000FE0A
  KEY_ISO_Prev_Group_Lock* = 0x0000FE0B
  KEY_ISO_First_Group* = 0x0000FE0C
  KEY_ISO_First_Group_Lock* = 0x0000FE0D
  KEY_ISO_Last_Group* = 0x0000FE0E
  KEY_ISO_Last_Group_Lock* = 0x0000FE0F
  KEY_ISO_Left_Tab* = 0x0000FE20
  KEY_ISO_Move_Line_Up* = 0x0000FE21
  KEY_ISO_Move_Line_Down* = 0x0000FE22
  KEY_ISO_Partial_Line_Up* = 0x0000FE23
  KEY_ISO_Partial_Line_Down* = 0x0000FE24
  KEY_ISO_Partial_Space_Left* = 0x0000FE25
  KEY_ISO_Partial_Space_Right* = 0x0000FE26
  KEY_ISO_Set_Margin_Left* = 0x0000FE27
  KEY_ISO_Set_Margin_Right* = 0x0000FE28
  KEY_ISO_Release_Margin_Left* = 0x0000FE29
  KEY_ISO_Release_Margin_Right* = 0x0000FE2A
  KEY_ISO_Release_Both_Margins* = 0x0000FE2B
  KEY_ISO_Fast_Cursor_Left* = 0x0000FE2C
  KEY_ISO_Fast_Cursor_Right* = 0x0000FE2D
  KEY_ISO_Fast_Cursor_Up* = 0x0000FE2E
  KEY_ISO_Fast_Cursor_Down* = 0x0000FE2F
  KEY_ISO_Continuous_Underline* = 0x0000FE30
  KEY_ISO_Discontinuous_Underline* = 0x0000FE31
  KEY_ISO_Emphasize* = 0x0000FE32
  KEY_ISO_Center_Object* = 0x0000FE33
  KEY_ISO_Enter* = 0x0000FE34
  KEY_dead_grave* = 0x0000FE50
  KEY_dead_acute* = 0x0000FE51
  KEY_dead_circumflex* = 0x0000FE52
  KEY_dead_tilde* = 0x0000FE53
  KEY_dead_perispomeni* = 0x0000FE53
  KEY_dead_macron* = 0x0000FE54
  KEY_dead_breve* = 0x0000FE55
  KEY_dead_abovedot* = 0x0000FE56
  KEY_dead_diaeresis* = 0x0000FE57
  KEY_dead_abovering* = 0x0000FE58
  KEY_dead_doubleacute* = 0x0000FE59
  KEY_dead_caron* = 0x0000FE5A
  KEY_dead_cedilla* = 0x0000FE5B
  KEY_dead_ogonek* = 0x0000FE5C
  KEY_dead_iota* = 0x0000FE5D
  KEY_dead_voiced_sound* = 0x0000FE5E
  KEY_dead_semivoiced_sound* = 0x0000FE5F
  KEY_dead_belowdot* = 0x0000FE60
  KEY_dead_hook* = 0x0000FE61
  KEY_dead_horn* = 0x0000FE62
  KEY_dead_stroke* = 0x0000FE63
  KEY_dead_abovecomma* = 0x0000FE64
  KEY_dead_psili* = 0x0000FE64
  KEY_dead_abovereversedcomma* = 0x0000FE65
  KEY_dead_dasia* = 0x0000FE65
  KEY_dead_doublegrave* = 0x0000FE66
  KEY_dead_belowring* = 0x0000FE67
  KEY_dead_belowmacron* = 0x0000FE68
  KEY_dead_belowcircumflex* = 0x0000FE69
  KEY_dead_belowtilde* = 0x0000FE6A
  KEY_dead_belowbreve* = 0x0000FE6B
  KEY_dead_belowdiaeresis* = 0x0000FE6C
  KEY_dead_invertedbreve* = 0x0000FE6D
  KEY_dead_belowcomma* = 0x0000FE6E
  KEY_dead_currency* = 0x0000FE6F
  KEY_dead_a* = 0x0000FE80
  KEY_CAPITAL_dead_A* = 0x0000FE81
  KEY_dead_e* = 0x0000FE82
  KEY_CAPITAL_dead_E* = 0x0000FE83
  KEY_dead_i* = 0x0000FE84
  KEY_CAPITAL_dead_I* = 0x0000FE85
  KEY_dead_o* = 0x0000FE86
  KEY_CAPITAL_dead_O* = 0x0000FE87
  KEY_dead_u* = 0x0000FE88
  KEY_CAPITAL_dead_U* = 0x0000FE89
  KEY_dead_small_schwa* = 0x0000FE8A
  KEY_dead_capital_schwa* = 0x0000FE8B
  KEY_dead_greek* = 0x0000FE8C
  KEY_First_Virtual_Screen* = 0x0000FED0
  KEY_Prev_Virtual_Screen* = 0x0000FED1
  KEY_Next_Virtual_Screen* = 0x0000FED2
  KEY_Last_Virtual_Screen* = 0x0000FED4
  KEY_Terminate_Server* = 0x0000FED5
  KEY_AccessX_Enable* = 0x0000FE70
  KEY_AccessX_Feedback_Enable* = 0x0000FE71
  KEY_RepeatKeys_Enable* = 0x0000FE72
  KEY_SlowKeys_Enable* = 0x0000FE73
  KEY_BounceKeys_Enable* = 0x0000FE74
  KEY_StickyKeys_Enable* = 0x0000FE75
  KEY_MouseKeys_Enable* = 0x0000FE76
  KEY_MouseKeys_Accel_Enable* = 0x0000FE77
  KEY_Overlay1_Enable* = 0x0000FE78
  KEY_Overlay2_Enable* = 0x0000FE79
  KEY_AudibleBell_Enable* = 0x0000FE7A
  KEY_Pointer_Left* = 0x0000FEE0
  KEY_Pointer_Right* = 0x0000FEE1
  KEY_Pointer_Up* = 0x0000FEE2
  KEY_Pointer_Down* = 0x0000FEE3
  KEY_Pointer_UpLeft* = 0x0000FEE4
  KEY_Pointer_UpRight* = 0x0000FEE5
  KEY_Pointer_DownLeft* = 0x0000FEE6
  KEY_Pointer_DownRight* = 0x0000FEE7
  KEY_Pointer_Button_Dflt* = 0x0000FEE8
  KEY_Pointer_Button1* = 0x0000FEE9
  KEY_Pointer_Button2* = 0x0000FEEA
  KEY_Pointer_Button3* = 0x0000FEEB
  KEY_Pointer_Button4* = 0x0000FEEC
  KEY_Pointer_Button5* = 0x0000FEED
  KEY_Pointer_DblClick_Dflt* = 0x0000FEEE
  KEY_Pointer_DblClick1* = 0x0000FEEF
  KEY_Pointer_DblClick2* = 0x0000FEF0
  KEY_Pointer_DblClick3* = 0x0000FEF1
  KEY_Pointer_DblClick4* = 0x0000FEF2
  KEY_Pointer_DblClick5* = 0x0000FEF3
  KEY_Pointer_Drag_Dflt* = 0x0000FEF4
  KEY_Pointer_Drag1* = 0x0000FEF5
  KEY_Pointer_Drag2* = 0x0000FEF6
  KEY_Pointer_Drag3* = 0x0000FEF7
  KEY_Pointer_Drag4* = 0x0000FEF8
  KEY_Pointer_Drag5* = 0x0000FEFD
  KEY_Pointer_EnableKeys* = 0x0000FEF9
  KEY_Pointer_Accelerate* = 0x0000FEFA
  KEY_Pointer_DfltBtnNext* = 0x0000FEFB
  KEY_Pointer_DfltBtnPrev* = 0x0000FEFC
  KEY_ch* = 0x0000FEA0
  KEY_CAPITAL_C_h* = 0x0000FEA1
  KEY_CAPITAL_C_CAPITAL_H* = 0x0000FEA2
  KEY_c_UNDERSCORE_h* = 0x0000FEA3
  KEY_CAPITAL_C_UNDERSCORE_h* = 0x0000FEA4
  KEY_CAPITAL_C_UNDERSCORE_CAPITAL_H* = 0x0000FEA5
  KEY_3270_Duplicate* = 0x0000FD01
  KEY_3270_FieldMark* = 0x0000FD02
  KEY_3270_Right2* = 0x0000FD03
  KEY_3270_Left2* = 0x0000FD04
  KEY_3270_BackTab* = 0x0000FD05
  KEY_3270_EraseEOF* = 0x0000FD06
  KEY_3270_EraseInput* = 0x0000FD07
  KEY_3270_Reset* = 0x0000FD08
  KEY_3270_Quit* = 0x0000FD09
  KEY_3270_PA1* = 0x0000FD0A
  KEY_3270_PA2* = 0x0000FD0B
  KEY_3270_PA3* = 0x0000FD0C
  KEY_3270_Test* = 0x0000FD0D
  KEY_3270_Attn* = 0x0000FD0E
  KEY_3270_CursorBlink* = 0x0000FD0F
  KEY_3270_AltCursor* = 0x0000FD10
  KEY_3270_KeyClick* = 0x0000FD11
  KEY_3270_Jump* = 0x0000FD12
  KEY_3270_Ident* = 0x0000FD13
  KEY_3270_Rule* = 0x0000FD14
  KEY_3270_Copy* = 0x0000FD15
  KEY_3270_Play* = 0x0000FD16
  KEY_3270_Setup* = 0x0000FD17
  KEY_3270_Record* = 0x0000FD18
  KEY_3270_ChangeScreen* = 0x0000FD19
  KEY_3270_DeleteWord* = 0x0000FD1A
  KEY_3270_ExSelect* = 0x0000FD1B
  KEY_3270_CursorSelect* = 0x0000FD1C
  KEY_3270_PrintScreen* = 0x0000FD1D
  KEY_3270_Enter* = 0x0000FD1E
  KEY_space* = 0x00000020
  KEY_exclam* = 0x00000021
  KEY_quotedbl* = 0x00000022
  KEY_numbersign* = 0x00000023
  KEY_dollar* = 0x00000024
  KEY_percent* = 0x00000025
  KEY_ampersand* = 0x00000026
  KEY_apostrophe* = 0x00000027
  KEY_quoteright* = 0x00000027
  KEY_parenleft* = 0x00000028
  KEY_parenright* = 0x00000029
  KEY_asterisk* = 0x0000002A
  KEY_plus* = 0x0000002B
  KEY_comma* = 0x0000002C
  KEY_minus* = 0x0000002D
  KEY_period* = 0x0000002E
  KEY_slash* = 0x0000002F
  KEY_0* = 0x00000030
  KEY_1* = 0x00000031
  KEY_2* = 0x00000032
  KEY_3* = 0x00000033
  KEY_4* = 0x00000034
  KEY_5* = 0x00000035
  KEY_6* = 0x00000036
  KEY_7* = 0x00000037
  KEY_8* = 0x00000038
  KEY_9* = 0x00000039
  KEY_colon* = 0x0000003A
  KEY_semicolon* = 0x0000003B
  KEY_less* = 0x0000003C
  KEY_equal* = 0x0000003D
  KEY_greater* = 0x0000003E
  KEY_question* = 0x0000003F
  KEY_at* = 0x00000040
  KEY_CAPITAL_A* = 0x00000041
  KEY_CAPITAL_B* = 0x00000042
  KEY_CAPITAL_C* = 0x00000043
  KEY_CAPITAL_D* = 0x00000044
  KEY_CAPITAL_E* = 0x00000045
  KEY_CAPITAL_F* = 0x00000046
  KEY_CAPITAL_G* = 0x00000047
  KEY_CAPITAL_H* = 0x00000048
  KEY_CAPITAL_I* = 0x00000049
  KEY_CAPITAL_J* = 0x0000004A
  KEY_CAPITAL_K* = 0x0000004B
  KEY_CAPITAL_L* = 0x0000004C
  KEY_CAPITAL_M* = 0x0000004D
  KEY_CAPITAL_N* = 0x0000004E
  KEY_CAPITAL_O* = 0x0000004F
  KEY_CAPITAL_P* = 0x00000050
  KEY_CAPITAL_Q* = 0x00000051
  KEY_CAPITAL_R* = 0x00000052
  KEY_CAPITAL_S* = 0x00000053
  KEY_CAPITAL_T* = 0x00000054
  KEY_CAPITAL_U* = 0x00000055
  KEY_CAPITAL_V* = 0x00000056
  KEY_CAPITAL_W* = 0x00000057
  KEY_CAPITAL_X* = 0x00000058
  KEY_CAPITAL_Y* = 0x00000059
  KEY_CAPITAL_Z* = 0x0000005A
  KEY_bracketleft* = 0x0000005B
  KEY_backslash* = 0x0000005C
  KEY_bracketright* = 0x0000005D
  KEY_asciicircum* = 0x0000005E
  KEY_underscore* = 0x0000005F
  KEY_grave* = 0x00000060
  KEY_quoteleft* = 0x00000060
  KEY_a* = 0x00000061
  KEY_b* = 0x00000062
  KEY_c* = 0x00000063
  KEY_d* = 0x00000064
  KEY_e* = 0x00000065
  KEY_f* = 0x00000066
  KEY_g* = 0x00000067
  KEY_h* = 0x00000068
  KEY_i* = 0x00000069
  KEY_j* = 0x0000006A
  KEY_k* = 0x0000006B
  KEY_l* = 0x0000006C
  KEY_m* = 0x0000006D
  KEY_n* = 0x0000006E
  KEY_o* = 0x0000006F
  KEY_p* = 0x00000070
  KEY_q* = 0x00000071
  KEY_r* = 0x00000072
  KEY_s* = 0x00000073
  KEY_t* = 0x00000074
  KEY_u* = 0x00000075
  KEY_v* = 0x00000076
  KEY_w* = 0x00000077
  KEY_x* = 0x00000078
  KEY_y* = 0x00000079
  KEY_z* = 0x0000007A
  KEY_braceleft* = 0x0000007B
  KEY_bar* = 0x0000007C
  KEY_braceright* = 0x0000007D
  KEY_asciitilde* = 0x0000007E
  KEY_nobreakspace* = 0x000000A0
  KEY_exclamdown* = 0x000000A1
  KEY_cent* = 0x000000A2
  KEY_sterling* = 0x000000A3
  KEY_currency* = 0x000000A4
  KEY_yen* = 0x000000A5
  KEY_brokenbar* = 0x000000A6
  KEY_section* = 0x000000A7
  KEY_diaeresis* = 0x000000A8
  KEY_copyright* = 0x000000A9
  KEY_ordfeminine* = 0x000000AA
  KEY_guillemotleft* = 0x000000AB
  KEY_notsign* = 0x000000AC
  KEY_hyphen* = 0x000000AD
  KEY_registered* = 0x000000AE
  KEY_macron* = 0x000000AF
  KEY_degree* = 0x000000B0
  KEY_plusminus* = 0x000000B1
  KEY_twosuperior* = 0x000000B2
  KEY_threesuperior* = 0x000000B3
  KEY_acute* = 0x000000B4
  KEY_mu* = 0x000000B5
  KEY_paragraph* = 0x000000B6
  KEY_periodcentered* = 0x000000B7
  KEY_cedilla* = 0x000000B8
  KEY_onesuperior* = 0x000000B9
  KEY_masculine* = 0x000000BA
  KEY_guillemotright* = 0x000000BB
  KEY_onequarter* = 0x000000BC
  KEY_onehalf* = 0x000000BD
  KEY_threequarters* = 0x000000BE
  KEY_questiondown* = 0x000000BF
  KEY_CAPITAL_Agrave* = 0x000000C0
  KEY_CAPITAL_Aacute* = 0x000000C1
  KEY_CAPITAL_Acircumflex* = 0x000000C2
  KEY_CAPITAL_Atilde* = 0x000000C3
  KEY_CAPITAL_Adiaeresis* = 0x000000C4
  KEY_CAPITAL_Aring* = 0x000000C5
  KEY_CAPITAL_AE* = 0x000000C6
  KEY_CAPITAL_Ccedilla* = 0x000000C7
  KEY_CAPITAL_Egrave* = 0x000000C8
  KEY_CAPITAL_Eacute* = 0x000000C9
  KEY_CAPITAL_Ecircumflex* = 0x000000CA
  KEY_CAPITAL_Ediaeresis* = 0x000000CB
  KEY_CAPITAL_Igrave* = 0x000000CC
  KEY_CAPITAL_Iacute* = 0x000000CD
  KEY_CAPITAL_Icircumflex* = 0x000000CE
  KEY_CAPITAL_Idiaeresis* = 0x000000CF
  KEY_CAPITAL_ETH* = 0x000000D0
  KEY_CAP_Eth* = 0x000000D0
  KEY_CAPITAL_Ntilde* = 0x000000D1
  KEY_CAPITAL_Ograve* = 0x000000D2
  KEY_CAPITAL_Oacute* = 0x000000D3
  KEY_CAPITAL_Ocircumflex* = 0x000000D4
  KEY_CAPITAL_Otilde* = 0x000000D5
  KEY_CAPITAL_Odiaeresis* = 0x000000D6
  KEY_multiply* = 0x000000D7
  KEY_CAPITAL_Oslash* = 0x000000D8
  KEY_CAPITAL_Ooblique* = 0x000000D8
  KEY_CAPITAL_Ugrave* = 0x000000D9
  KEY_CAPITAL_Uacute* = 0x000000DA
  KEY_CAPITAL_Ucircumflex* = 0x000000DB
  KEY_CAPITAL_Udiaeresis* = 0x000000DC
  KEY_CAPITAL_Yacute* = 0x000000DD
  KEY_CAPITAL_THORN* = 0x000000DE
  KEY_CAP_Thorn* = 0x000000DE
  KEY_ssharp* = 0x000000DF
  KEY_agrave* = 0x000000E0
  KEY_aacute* = 0x000000E1
  KEY_acircumflex* = 0x000000E2
  KEY_atilde* = 0x000000E3
  KEY_adiaeresis* = 0x000000E4
  KEY_aring* = 0x000000E5
  KEY_ae* = 0x000000E6
  KEY_ccedilla* = 0x000000E7
  KEY_egrave* = 0x000000E8
  KEY_eacute* = 0x000000E9
  KEY_ecircumflex* = 0x000000EA
  KEY_ediaeresis* = 0x000000EB
  KEY_igrave* = 0x000000EC
  KEY_iacute* = 0x000000ED
  KEY_icircumflex* = 0x000000EE
  KEY_idiaeresis* = 0x000000EF
  KEY_eth* = 0x000000F0
  KEY_ntilde* = 0x000000F1
  KEY_ograve* = 0x000000F2
  KEY_oacute* = 0x000000F3
  KEY_ocircumflex* = 0x000000F4
  KEY_otilde* = 0x000000F5
  KEY_odiaeresis* = 0x000000F6
  KEY_division* = 0x000000F7
  KEY_oslash* = 0x000000F8
  KEY_ooblique* = 0x000000F8
  KEY_ugrave* = 0x000000F9
  KEY_uacute* = 0x000000FA
  KEY_ucircumflex* = 0x000000FB
  KEY_udiaeresis* = 0x000000FC
  KEY_yacute* = 0x000000FD
  KEY_thorn* = 0x000000FE
  KEY_ydiaeresis* = 0x000000FF
  KEY_CAPITAL_Aogonek* = 0x000001A1
  KEY_breve* = 0x000001A2
  KEY_CAPITAL_Lstroke* = 0x000001A3
  KEY_CAPITAL_Lcaron* = 0x000001A5
  KEY_CAPITAL_Sacute* = 0x000001A6
  KEY_CAPITAL_Scaron* = 0x000001A9
  KEY_CAPITAL_Scedilla* = 0x000001AA
  KEY_CAPITAL_Tcaron* = 0x000001AB
  KEY_CAPITAL_Zacute* = 0x000001AC
  KEY_CAPITAL_Zcaron* = 0x000001AE
  KEY_CAPITAL_Zabovedot* = 0x000001AF
  KEY_aogonek* = 0x000001B1
  KEY_ogonek* = 0x000001B2
  KEY_lstroke* = 0x000001B3
  KEY_lcaron* = 0x000001B5
  KEY_sacute* = 0x000001B6
  KEY_caron* = 0x000001B7
  KEY_scaron* = 0x000001B9
  KEY_scedilla* = 0x000001BA
  KEY_tcaron* = 0x000001BB
  KEY_zacute* = 0x000001BC
  KEY_doubleacute* = 0x000001BD
  KEY_zcaron* = 0x000001BE
  KEY_zabovedot* = 0x000001BF
  KEY_CAPITAL_Racute* = 0x000001C0
  KEY_CAPITAL_Abreve* = 0x000001C3
  KEY_CAPITAL_Lacute* = 0x000001C5
  KEY_CAPITAL_Cacute* = 0x000001C6
  KEY_CAPITAL_Ccaron* = 0x000001C8
  KEY_CAPITAL_Eogonek* = 0x000001CA
  KEY_CAPITAL_Ecaron* = 0x000001CC
  KEY_CAPITAL_Dcaron* = 0x000001CF
  KEY_CAPITAL_Dstroke* = 0x000001D0
  KEY_CAPITAL_Nacute* = 0x000001D1
  KEY_CAPITAL_Ncaron* = 0x000001D2
  KEY_CAPITAL_Odoubleacute* = 0x000001D5
  KEY_CAPITAL_Rcaron* = 0x000001D8
  KEY_CAPITAL_Uring* = 0x000001D9
  KEY_CAPITAL_Udoubleacute* = 0x000001DB
  KEY_CAPITAL_Tcedilla* = 0x000001DE
  KEY_racute* = 0x000001E0
  KEY_abreve* = 0x000001E3
  KEY_lacute* = 0x000001E5
  KEY_cacute* = 0x000001E6
  KEY_ccaron* = 0x000001E8
  KEY_eogonek* = 0x000001EA
  KEY_ecaron* = 0x000001EC
  KEY_dcaron* = 0x000001EF
  KEY_dstroke* = 0x000001F0
  KEY_nacute* = 0x000001F1
  KEY_ncaron* = 0x000001F2
  KEY_odoubleacute* = 0x000001F5
  KEY_rcaron* = 0x000001F8
  KEY_uring* = 0x000001F9
  KEY_udoubleacute* = 0x000001FB
  KEY_tcedilla* = 0x000001FE
  KEY_abovedot* = 0x000001FF
  KEY_CAPITAL_Hstroke* = 0x000002A1
  KEY_CAPITAL_Hcircumflex* = 0x000002A6
  KEY_Iabovedot* = 0x000002A9
  KEY_CAPITAL_Gbreve* = 0x000002AB
  KEY_CAPITAL_Jcircumflex* = 0x000002AC
  KEY_hstroke* = 0x000002B1
  KEY_hcircumflex* = 0x000002B6
  KEY_idotless* = 0x000002B9
  KEY_gbreve* = 0x000002BB
  KEY_jcircumflex* = 0x000002BC
  KEY_CAPITAL_Cabovedot* = 0x000002C5
  KEY_CAPITAL_Ccircumflex* = 0x000002C6
  KEY_CAPITAL_Gabovedot* = 0x000002D5
  KEY_CAPITAL_Gcircumflex* = 0x000002D8
  KEY_CAPITAL_Ubreve* = 0x000002DD
  KEY_CAPITAL_Scircumflex* = 0x000002DE
  KEY_cabovedot* = 0x000002E5
  KEY_ccircumflex* = 0x000002E6
  KEY_gabovedot* = 0x000002F5
  KEY_gcircumflex* = 0x000002F8
  KEY_ubreve* = 0x000002FD
  KEY_scircumflex* = 0x000002FE
  KEY_kra* = 0x000003A2
  KEY_kappa* = 0x000003A2
  KEY_CAPITAL_Rcedilla* = 0x000003A3
  KEY_CAPITAL_Itilde* = 0x000003A5
  KEY_CAPITAL_Lcedilla* = 0x000003A6
  KEY_CAPITAL_Emacron* = 0x000003AA
  KEY_CAPITAL_Gcedilla* = 0x000003AB
  KEY_CAPITAL_Tslash* = 0x000003AC
  KEY_rcedilla* = 0x000003B3
  KEY_itilde* = 0x000003B5
  KEY_lcedilla* = 0x000003B6
  KEY_emacron* = 0x000003BA
  KEY_gcedilla* = 0x000003BB
  KEY_tslash* = 0x000003BC
  KEY_CAPITAL_ENG* = 0x000003BD
  KEY_eng* = 0x000003BF
  KEY_CAPITAL_Amacron* = 0x000003C0
  KEY_CAPITAL_Iogonek* = 0x000003C7
  KEY_CAPITAL_Eabovedot* = 0x000003CC
  KEY_CAPITAL_Imacron* = 0x000003CF
  KEY_CAPITAL_Ncedilla* = 0x000003D1
  KEY_CAPITAL_Omacron* = 0x000003D2
  KEY_CAPITAL_Kcedilla* = 0x000003D3
  KEY_CAPITAL_Uogonek* = 0x000003D9
  KEY_CAPITAL_Utilde* = 0x000003DD
  KEY_CAPITAL_Umacron* = 0x000003DE
  KEY_amacron* = 0x000003E0
  KEY_iogonek* = 0x000003E7
  KEY_eabovedot* = 0x000003EC
  KEY_imacron* = 0x000003EF
  KEY_ncedilla* = 0x000003F1
  KEY_omacron* = 0x000003F2
  KEY_kcedilla* = 0x000003F3
  KEY_uogonek* = 0x000003F9
  KEY_utilde* = 0x000003FD
  KEY_umacron* = 0x000003FE
  KEY_CAPITAL_Wcircumflex* = 0x01000174
  KEY_wcircumflex* = 0x01000175
  KEY_CAPITAL_Ycircumflex* = 0x01000176
  KEY_ycircumflex* = 0x01000177
  KEY_CAPITAL_Babovedot* = 0x01001E02
  KEY_babovedot* = 0x01001E03
  KEY_CAPITAL_Dabovedot* = 0x01001E0A
  KEY_dabovedot* = 0x01001E0B
  KEY_CAPITAL_Fabovedot* = 0x01001E1E
  KEY_fabovedot* = 0x01001E1F
  KEY_CAPITAL_Mabovedot* = 0x01001E40
  KEY_mabovedot* = 0x01001E41
  KEY_CAPITAL_Pabovedot* = 0x01001E56
  KEY_pabovedot* = 0x01001E57
  KEY_CAPITAL_Sabovedot* = 0x01001E60
  KEY_sabovedot* = 0x01001E61
  KEY_CAPITAL_Tabovedot* = 0x01001E6A
  KEY_tabovedot* = 0x01001E6B
  KEY_CAPITAL_Wgrave* = 0x01001E80
  KEY_wgrave* = 0x01001E81
  KEY_CAPITAL_Wacute* = 0x01001E82
  KEY_wacute* = 0x01001E83
  KEY_CAPITAL_Wdiaeresis* = 0x01001E84
  KEY_wdiaeresis* = 0x01001E85
  KEY_CAPITAL_Ygrave* = 0x01001EF2
  KEY_ygrave* = 0x01001EF3
  KEY_CAPITAL_OE* = 0x000013BC
  KEY_oe* = 0x000013BD
  KEY_CAPITAL_Ydiaeresis* = 0x000013BE
  KEY_overline* = 0x0000047E
  KEY_kana_fullstop* = 0x000004A1
  KEY_kana_openingbracket* = 0x000004A2
  KEY_kana_closingbracket* = 0x000004A3
  KEY_kana_comma* = 0x000004A4
  KEY_kana_conjunctive* = 0x000004A5
  KEY_kana_middledot* = 0x000004A5
  KEY_kana_WO* = 0x000004A6
  KEY_kana_a* = 0x000004A7
  KEY_kana_i* = 0x000004A8
  KEY_kana_u* = 0x000004A9
  KEY_kana_e* = 0x000004AA
  KEY_kana_o* = 0x000004AB
  KEY_kana_ya* = 0x000004AC
  KEY_kana_yu* = 0x000004AD
  KEY_kana_yo* = 0x000004AE
  KEY_kana_tsu* = 0x000004AF
  KEY_kana_tu* = 0x000004AF
  KEY_prolongedsound* = 0x000004B0
  KEY_CAPITAL_kana_A* = 0x000004B1
  KEY_CAPITAL_kana_I* = 0x000004B2
  KEY_CAPITAL_kana_U* = 0x000004B3
  KEY_CAPITAL_kana_E* = 0x000004B4
  KEY_CAPITAL_kana_O* = 0x000004B5
  KEY_kana_KA* = 0x000004B6
  KEY_kana_KI* = 0x000004B7
  KEY_kana_KU* = 0x000004B8
  KEY_kana_KE* = 0x000004B9
  KEY_kana_KO* = 0x000004BA
  KEY_kana_SA* = 0x000004BB
  KEY_kana_SHI* = 0x000004BC
  KEY_kana_SU* = 0x000004BD
  KEY_kana_SE* = 0x000004BE
  KEY_kana_SO* = 0x000004BF
  KEY_kana_TA* = 0x000004C0
  KEY_kana_CHI* = 0x000004C1
  KEY_kana_TI* = 0x000004C1
  KEY_CAPITAL_kana_TSU* = 0x000004C2
  KEY_CAPITAL_kana_TU* = 0x000004C2
  KEY_kana_TE* = 0x000004C3
  KEY_kana_TO* = 0x000004C4
  KEY_kana_NA* = 0x000004C5
  KEY_kana_NI* = 0x000004C6
  KEY_kana_NU* = 0x000004C7
  KEY_kana_NE* = 0x000004C8
  KEY_kana_NO* = 0x000004C9
  KEY_kana_HA* = 0x000004CA
  KEY_kana_HI* = 0x000004CB
  KEY_kana_FU* = 0x000004CC
  KEY_kana_HU* = 0x000004CC
  KEY_kana_HE* = 0x000004CD
  KEY_kana_HO* = 0x000004CE
  KEY_kana_MA* = 0x000004CF
  KEY_kana_MI* = 0x000004D0
  KEY_kana_MU* = 0x000004D1
  KEY_kana_ME* = 0x000004D2
  KEY_kana_MO* = 0x000004D3
  KEY_CAPITAL_kana_YA* = 0x000004D4
  KEY_CAPITAL_kana_YU* = 0x000004D5
  KEY_CAPITAL_kana_YO* = 0x000004D6
  KEY_kana_RA* = 0x000004D7
  KEY_kana_RI* = 0x000004D8
  KEY_kana_RU* = 0x000004D9
  KEY_kana_RE* = 0x000004DA
  KEY_kana_RO* = 0x000004DB
  KEY_kana_WA* = 0x000004DC
  KEY_kana_N* = 0x000004DD
  KEY_voicedsound* = 0x000004DE
  KEY_semivoicedsound* = 0x000004DF
  KEY_kana_switch* = 0x0000FF7E
  KEY_Farsi_0* = 0x010006F0
  KEY_Farsi_1* = 0x010006F1
  KEY_Farsi_2* = 0x010006F2
  KEY_Farsi_3* = 0x010006F3
  KEY_Farsi_4* = 0x010006F4
  KEY_Farsi_5* = 0x010006F5
  KEY_Farsi_6* = 0x010006F6
  KEY_Farsi_7* = 0x010006F7
  KEY_Farsi_8* = 0x010006F8
  KEY_Farsi_9* = 0x010006F9
  KEY_Arabic_percent* = 0x0100066A
  KEY_Arabic_superscript_alef* = 0x01000670
  KEY_Arabic_tteh* = 0x01000679
  KEY_Arabic_peh* = 0x0100067E
  KEY_Arabic_tcheh* = 0x01000686
  KEY_Arabic_ddal* = 0x01000688
  KEY_Arabic_rreh* = 0x01000691
  KEY_Arabic_comma* = 0x000005AC
  KEY_Arabic_fullstop* = 0x010006D4
  KEY_Arabic_0* = 0x01000660
  KEY_Arabic_1* = 0x01000661
  KEY_Arabic_2* = 0x01000662
  KEY_Arabic_3* = 0x01000663
  KEY_Arabic_4* = 0x01000664
  KEY_Arabic_5* = 0x01000665
  KEY_Arabic_6* = 0x01000666
  KEY_Arabic_7* = 0x01000667
  KEY_Arabic_8* = 0x01000668
  KEY_Arabic_9* = 0x01000669
  KEY_Arabic_semicolon* = 0x000005BB
  KEY_Arabic_question_mark* = 0x000005BF
  KEY_Arabic_hamza* = 0x000005C1
  KEY_Arabic_maddaonalef* = 0x000005C2
  KEY_Arabic_hamzaonalef* = 0x000005C3
  KEY_Arabic_hamzaonwaw* = 0x000005C4
  KEY_Arabic_hamzaunderalef* = 0x000005C5
  KEY_Arabic_hamzaonyeh* = 0x000005C6
  KEY_Arabic_alef* = 0x000005C7
  KEY_Arabic_beh* = 0x000005C8
  KEY_Arabic_tehmarbuta* = 0x000005C9
  KEY_Arabic_teh* = 0x000005CA
  KEY_Arabic_theh* = 0x000005CB
  KEY_Arabic_jeem* = 0x000005CC
  KEY_Arabic_hah* = 0x000005CD
  KEY_Arabic_khah* = 0x000005CE
  KEY_Arabic_dal* = 0x000005CF
  KEY_Arabic_thal* = 0x000005D0
  KEY_Arabic_ra* = 0x000005D1
  KEY_Arabic_zain* = 0x000005D2
  KEY_Arabic_seen* = 0x000005D3
  KEY_Arabic_sheen* = 0x000005D4
  KEY_Arabic_sad* = 0x000005D5
  KEY_Arabic_dad* = 0x000005D6
  KEY_Arabic_tah* = 0x000005D7
  KEY_Arabic_zah* = 0x000005D8
  KEY_Arabic_ain* = 0x000005D9
  KEY_Arabic_ghain* = 0x000005DA
  KEY_Arabic_tatweel* = 0x000005E0
  KEY_Arabic_feh* = 0x000005E1
  KEY_Arabic_qaf* = 0x000005E2
  KEY_Arabic_kaf* = 0x000005E3
  KEY_Arabic_lam* = 0x000005E4
  KEY_Arabic_meem* = 0x000005E5
  KEY_Arabic_noon* = 0x000005E6
  KEY_Arabic_ha* = 0x000005E7
  KEY_Arabic_heh* = 0x000005E7
  KEY_Arabic_waw* = 0x000005E8
  KEY_Arabic_alefmaksura* = 0x000005E9
  KEY_Arabic_yeh* = 0x000005EA
  KEY_Arabic_fathatan* = 0x000005EB
  KEY_Arabic_dammatan* = 0x000005EC
  KEY_Arabic_kasratan* = 0x000005ED
  KEY_Arabic_fatha* = 0x000005EE
  KEY_Arabic_damma* = 0x000005EF
  KEY_Arabic_kasra* = 0x000005F0
  KEY_Arabic_shadda* = 0x000005F1
  KEY_Arabic_sukun* = 0x000005F2
  KEY_Arabic_madda_above* = 0x01000653
  KEY_Arabic_hamza_above* = 0x01000654
  KEY_Arabic_hamza_below* = 0x01000655
  KEY_Arabic_jeh* = 0x01000698
  KEY_Arabic_veh* = 0x010006A4
  KEY_Arabic_keheh* = 0x010006A9
  KEY_Arabic_gaf* = 0x010006AF
  KEY_Arabic_noon_ghunna* = 0x010006BA
  KEY_Arabic_heh_doachashmee* = 0x010006BE
  KEY_Farsi_yeh* = 0x010006CC
  KEY_Arabic_farsi_yeh* = 0x010006CC
  KEY_Arabic_yeh_baree* = 0x010006D2
  KEY_Arabic_heh_goal* = 0x010006C1
  KEY_Arabic_switch* = 0x0000FF7E
  KEY_CAPITAL_Cyrillic_GHE_bar* = 0x01000492
  KEY_Cyrillic_ghe_bar* = 0x01000493
  KEY_CAPITAL_Cyrillic_ZHE_descender* = 0x01000496
  KEY_Cyrillic_zhe_descender* = 0x01000497
  KEY_CAPITAL_Cyrillic_KA_descender* = 0x0100049A
  KEY_Cyrillic_ka_descender* = 0x0100049B
  KEY_CAPITAL_Cyrillic_KA_vertstroke* = 0x0100049C
  KEY_Cyrillic_ka_vertstroke* = 0x0100049D
  KEY_CAPITAL_Cyrillic_EN_descender* = 0x010004A2
  KEY_Cyrillic_en_descender* = 0x010004A3
  KEY_CAPITAL_Cyrillic_U_straight* = 0x010004AE
  KEY_Cyrillic_u_straight* = 0x010004AF
  KEY_CAPITAL_Cyrillic_U_straight_bar* = 0x010004B0
  KEY_Cyrillic_u_straight_bar* = 0x010004B1
  KEY_CAPITAL_Cyrillic_HA_descender* = 0x010004B2
  KEY_Cyrillic_ha_descender* = 0x010004B3
  KEY_CAPITAL_Cyrillic_CHE_descender* = 0x010004B6
  KEY_Cyrillic_che_descender* = 0x010004B7
  KEY_CAPITAL_Cyrillic_CHE_vertstroke* = 0x010004B8
  KEY_Cyrillic_che_vertstroke* = 0x010004B9
  KEY_CAPITAL_Cyrillic_SHHA* = 0x010004BA
  KEY_Cyrillic_shha* = 0x010004BB
  KEY_CAPITAL_Cyrillic_SCHWA* = 0x010004D8
  KEY_Cyrillic_schwa* = 0x010004D9
  KEY_CAPITAL_Cyrillic_I_macron* = 0x010004E2
  KEY_Cyrillic_i_macron* = 0x010004E3
  KEY_CAPITAL_Cyrillic_O_bar* = 0x010004E8
  KEY_Cyrillic_o_bar* = 0x010004E9
  KEY_CAPITAL_Cyrillic_U_macron* = 0x010004EE
  KEY_Cyrillic_u_macron* = 0x010004EF
  KEY_Serbian_dje* = 0x000006A1
  KEY_Macedonia_gje* = 0x000006A2
  KEY_Cyrillic_io* = 0x000006A3
  KEY_Ukrainian_ie* = 0x000006A4
  KEY_Ukranian_je* = 0x000006A4
  KEY_Macedonia_dse* = 0x000006A5
  KEY_Ukrainian_i* = 0x000006A6
  KEY_Ukranian_i* = 0x000006A6
  KEY_Ukrainian_yi* = 0x000006A7
  KEY_Ukranian_yi* = 0x000006A7
  KEY_Cyrillic_je* = 0x000006A8
  KEY_Serbian_je* = 0x000006A8
  KEY_Cyrillic_lje* = 0x000006A9
  KEY_Serbian_lje* = 0x000006A9
  KEY_Cyrillic_nje* = 0x000006AA
  KEY_Serbian_nje* = 0x000006AA
  KEY_Serbian_tshe* = 0x000006AB
  KEY_Macedonia_kje* = 0x000006AC
  KEY_Ukrainian_ghe_with_upturn* = 0x000006AD
  KEY_Byelorussian_shortu* = 0x000006AE
  KEY_Cyrillic_dzhe* = 0x000006AF
  KEY_Serbian_dze* = 0x000006AF
  KEY_numerosign* = 0x000006B0
  KEY_CAPITAL_Serbian_DJE* = 0x000006B1
  KEY_CAPITAL_Macedonia_GJE* = 0x000006B2
  KEY_CAPITAL_Cyrillic_IO* = 0x000006B3
  KEY_CAPITAL_Ukrainian_IE* = 0x000006B4
  KEY_CAPITAL_Ukranian_JE* = 0x000006B4
  KEY_CAPITAL_Macedonia_DSE* = 0x000006B5
  KEY_CAPITAL_Ukrainian_I* = 0x000006B6
  KEY_CAPITAL_Ukranian_I* = 0x000006B6
  KEY_CAPITAL_Ukrainian_YI* = 0x000006B7
  KEY_CAPITAL_Ukranian_YI* = 0x000006B7
  KEY_CAPITAL_Cyrillic_JE* = 0x000006B8
  KEY_CAPITAL_Serbian_JE* = 0x000006B8
  KEY_CAPITAL_Cyrillic_LJE* = 0x000006B9
  KEY_CAPITAL_Serbian_LJE* = 0x000006B9
  KEY_CAPITAL_Cyrillic_NJE* = 0x000006BA
  KEY_CAPITAL_Serbian_NJE* = 0x000006BA
  KEY_CAPITAL_Serbian_TSHE* = 0x000006BB
  KEY_CAPITAL_Macedonia_KJE* = 0x000006BC
  KEY_CAPITAL_Ukrainian_GHE_WITH_UPTURN* = 0x000006BD
  KEY_CAPITAL_Byelorussian_SHORTU* = 0x000006BE
  KEY_CAPITAL_Cyrillic_DZHE* = 0x000006BF
  KEY_CAPITAL_Serbian_DZE* = 0x000006BF
  KEY_Cyrillic_yu* = 0x000006C0
  KEY_Cyrillic_a* = 0x000006C1
  KEY_Cyrillic_be* = 0x000006C2
  KEY_Cyrillic_tse* = 0x000006C3
  KEY_Cyrillic_de* = 0x000006C4
  KEY_Cyrillic_ie* = 0x000006C5
  KEY_Cyrillic_ef* = 0x000006C6
  KEY_Cyrillic_ghe* = 0x000006C7
  KEY_Cyrillic_ha* = 0x000006C8
  KEY_Cyrillic_i* = 0x000006C9
  KEY_Cyrillic_shorti* = 0x000006CA
  KEY_Cyrillic_ka* = 0x000006CB
  KEY_Cyrillic_el* = 0x000006CC
  KEY_Cyrillic_em* = 0x000006CD
  KEY_Cyrillic_en* = 0x000006CE
  KEY_Cyrillic_o* = 0x000006CF
  KEY_Cyrillic_pe* = 0x000006D0
  KEY_Cyrillic_ya* = 0x000006D1
  KEY_Cyrillic_er* = 0x000006D2
  KEY_Cyrillic_es* = 0x000006D3
  KEY_Cyrillic_te* = 0x000006D4
  KEY_Cyrillic_u* = 0x000006D5
  KEY_Cyrillic_zhe* = 0x000006D6
  KEY_Cyrillic_ve* = 0x000006D7
  KEY_Cyrillic_softsign* = 0x000006D8
  KEY_Cyrillic_yeru* = 0x000006D9
  KEY_Cyrillic_ze* = 0x000006DA
  KEY_Cyrillic_sha* = 0x000006DB
  KEY_Cyrillic_e* = 0x000006DC
  KEY_Cyrillic_shcha* = 0x000006DD
  KEY_Cyrillic_che* = 0x000006DE
  KEY_Cyrillic_hardsign* = 0x000006DF
  KEY_CAPITAL_Cyrillic_YU* = 0x000006E0
  KEY_CAPITAL_Cyrillic_A* = 0x000006E1
  KEY_CAPITAL_Cyrillic_BE* = 0x000006E2
  KEY_CAPITAL_Cyrillic_TSE* = 0x000006E3
  KEY_CAPITAL_Cyrillic_DE* = 0x000006E4
  KEY_CAPITAL_Cyrillic_IE* = 0x000006E5
  KEY_CAPITAL_Cyrillic_EF* = 0x000006E6
  KEY_CAPITAL_Cyrillic_GHE* = 0x000006E7
  KEY_CAPITAL_Cyrillic_HA* = 0x000006E8
  KEY_CAPITAL_Cyrillic_I* = 0x000006E9
  KEY_CAPITAL_Cyrillic_SHORTI* = 0x000006EA
  KEY_CAPITAL_Cyrillic_KA* = 0x000006EB
  KEY_CAPITAL_Cyrillic_EL* = 0x000006EC
  KEY_CAPITAL_Cyrillic_EM* = 0x000006ED
  KEY_CAPITAL_Cyrillic_EN* = 0x000006EE
  KEY_CAPITAL_Cyrillic_O* = 0x000006EF
  KEY_CAPITAL_Cyrillic_PE* = 0x000006F0
  KEY_CAPITAL_Cyrillic_YA* = 0x000006F1
  KEY_CAPITAL_Cyrillic_ER* = 0x000006F2
  KEY_CAPITAL_Cyrillic_ES* = 0x000006F3
  KEY_CAPITAL_Cyrillic_TE* = 0x000006F4
  KEY_CAPITAL_Cyrillic_U* = 0x000006F5
  KEY_CAPITAL_Cyrillic_ZHE* = 0x000006F6
  KEY_CAPITAL_Cyrillic_VE* = 0x000006F7
  KEY_CAPITAL_Cyrillic_SOFTSIGN* = 0x000006F8
  KEY_CAPITAL_Cyrillic_YERU* = 0x000006F9
  KEY_CAPITAL_Cyrillic_ZE* = 0x000006FA
  KEY_CAPITAL_Cyrillic_SHA* = 0x000006FB
  KEY_CAPITAL_Cyrillic_E* = 0x000006FC
  KEY_CAPITAL_Cyrillic_SHCHA* = 0x000006FD
  KEY_CAPITAL_Cyrillic_CHE* = 0x000006FE
  KEY_CAPITAL_Cyrillic_HARDSIGN* = 0x000006FF
  KEY_CAPITAL_Greek_ALPHAaccent* = 0x000007A1
  KEY_CAPITAL_Greek_EPSILONaccent* = 0x000007A2
  KEY_CAPITAL_Greek_ETAaccent* = 0x000007A3
  KEY_CAPITAL_Greek_IOTAaccent* = 0x000007A4
  KEY_CAPITAL_Greek_IOTAdieresis* = 0x000007A5
  KEY_Greek_IOTAdiaeresis* = 0x000007A5
  KEY_CAPITAL_Greek_OMICRONaccent* = 0x000007A7
  KEY_CAPITAL_Greek_UPSILONaccent* = 0x000007A8
  KEY_CAPITAL_Greek_UPSILONdieresis* = 0x000007A9
  KEY_CAPITAL_Greek_OMEGAaccent* = 0x000007AB
  KEY_Greek_accentdieresis* = 0x000007AE
  KEY_Greek_horizbar* = 0x000007AF
  KEY_Greek_alphaaccent* = 0x000007B1
  KEY_Greek_epsilonaccent* = 0x000007B2
  KEY_Greek_etaaccent* = 0x000007B3
  KEY_Greek_iotaaccent* = 0x000007B4
  KEY_Greek_iotadieresis* = 0x000007B5
  KEY_Greek_iotaaccentdieresis* = 0x000007B6
  KEY_Greek_omicronaccent* = 0x000007B7
  KEY_Greek_upsilonaccent* = 0x000007B8
  KEY_Greek_upsilondieresis* = 0x000007B9
  KEY_Greek_upsilonaccentdieresis* = 0x000007BA
  KEY_Greek_omegaaccent* = 0x000007BB
  KEY_CAPITAL_Greek_ALPHA* = 0x000007C1
  KEY_CAPITAL_Greek_BETA* = 0x000007C2
  KEY_CAPITAL_Greek_GAMMA* = 0x000007C3
  KEY_CAPITAL_Greek_DELTA* = 0x000007C4
  KEY_CAPITAL_Greek_EPSILON* = 0x000007C5
  KEY_CAPITAL_Greek_ZETA* = 0x000007C6
  KEY_CAPITAL_Greek_ETA* = 0x000007C7
  KEY_CAPITAL_Greek_THETA* = 0x000007C8
  KEY_CAPITAL_Greek_IOTA* = 0x000007C9
  KEY_CAPITAL_Greek_KAPPA* = 0x000007CA
  KEY_CAPITAL_Greek_LAMDA* = 0x000007CB
  KEY_CAPITAL_Greek_LAMBDA* = 0x000007CB
  KEY_CAPITAL_Greek_MU* = 0x000007CC
  KEY_CAPITAL_Greek_NU* = 0x000007CD
  KEY_CAPITAL_Greek_XI* = 0x000007CE
  KEY_CAPITAL_Greek_OMICRON* = 0x000007CF
  KEY_CAPITAL_Greek_PI* = 0x000007D0
  KEY_CAPITAL_Greek_RHO* = 0x000007D1
  KEY_CAPITAL_Greek_SIGMA* = 0x000007D2
  KEY_CAPITAL_Greek_TAU* = 0x000007D4
  KEY_CAPITAL_Greek_UPSILON* = 0x000007D5
  KEY_CAPITAL_Greek_PHI* = 0x000007D6
  KEY_CAPITAL_Greek_CHI* = 0x000007D7
  KEY_CAPITAL_Greek_PSI* = 0x000007D8
  KEY_CAPITAL_Greek_OMEGA* = 0x000007D9
  KEY_Greek_alpha* = 0x000007E1
  KEY_Greek_beta* = 0x000007E2
  KEY_Greek_gamma* = 0x000007E3
  KEY_Greek_delta* = 0x000007E4
  KEY_Greek_epsilon* = 0x000007E5
  KEY_Greek_zeta* = 0x000007E6
  KEY_Greek_eta* = 0x000007E7
  KEY_Greek_theta* = 0x000007E8
  KEY_Greek_iota* = 0x000007E9
  KEY_Greek_kappa* = 0x000007EA
  KEY_Greek_lamda* = 0x000007EB
  KEY_Greek_lambda* = 0x000007EB
  KEY_Greek_mu* = 0x000007EC
  KEY_Greek_nu* = 0x000007ED
  KEY_Greek_xi* = 0x000007EE
  KEY_Greek_omicron* = 0x000007EF
  KEY_Greek_pi* = 0x000007F0
  KEY_Greek_rho* = 0x000007F1
  KEY_Greek_sigma* = 0x000007F2
  KEY_Greek_finalsmallsigma* = 0x000007F3
  KEY_Greek_tau* = 0x000007F4
  KEY_Greek_upsilon* = 0x000007F5
  KEY_Greek_phi* = 0x000007F6
  KEY_Greek_chi* = 0x000007F7
  KEY_Greek_psi* = 0x000007F8
  KEY_Greek_omega* = 0x000007F9
  KEY_Greek_switch* = 0x0000FF7E
  KEY_leftradical* = 0x000008A1
  KEY_topleftradical* = 0x000008A2
  KEY_horizconnector* = 0x000008A3
  KEY_topintegral* = 0x000008A4
  KEY_botintegral* = 0x000008A5
  KEY_vertconnector* = 0x000008A6
  KEY_topleftsqbracket* = 0x000008A7
  KEY_botleftsqbracket* = 0x000008A8
  KEY_toprightsqbracket* = 0x000008A9
  KEY_botrightsqbracket* = 0x000008AA
  KEY_topleftparens* = 0x000008AB
  KEY_botleftparens* = 0x000008AC
  KEY_toprightparens* = 0x000008AD
  KEY_botrightparens* = 0x000008AE
  KEY_leftmiddlecurlybrace* = 0x000008AF
  KEY_rightmiddlecurlybrace* = 0x000008B0
  KEY_topleftsummation* = 0x000008B1
  KEY_botleftsummation* = 0x000008B2
  KEY_topvertsummationconnector* = 0x000008B3
  KEY_botvertsummationconnector* = 0x000008B4
  KEY_toprightsummation* = 0x000008B5
  KEY_botrightsummation* = 0x000008B6
  KEY_rightmiddlesummation* = 0x000008B7
  KEY_lessthanequal* = 0x000008BC
  KEY_notequal* = 0x000008BD
  KEY_greaterthanequal* = 0x000008BE
  KEY_integral* = 0x000008BF
  KEY_therefore* = 0x000008C0
  KEY_variation* = 0x000008C1
  KEY_infinity* = 0x000008C2
  KEY_nabla* = 0x000008C5
  KEY_approximate* = 0x000008C8
  KEY_similarequal* = 0x000008C9
  KEY_ifonlyif* = 0x000008CD
  KEY_implies* = 0x000008CE
  KEY_identical* = 0x000008CF
  KEY_radical* = 0x000008D6
  KEY_includedin* = 0x000008DA
  KEY_includes* = 0x000008DB
  KEY_intersection* = 0x000008DC
  KEY_union* = 0x000008DD
  KEY_logicaland* = 0x000008DE
  KEY_logicalor* = 0x000008DF
  KEY_partialderivative* = 0x000008EF
  KEY_function* = 0x000008F6
  KEY_leftarrow* = 0x000008FB
  KEY_uparrow* = 0x000008FC
  KEY_rightarrow* = 0x000008FD
  KEY_downarrow* = 0x000008FE
  KEY_blank* = 0x000009DF
  KEY_soliddiamond* = 0x000009E0
  KEY_checkerboard* = 0x000009E1
  KEY_ht* = 0x000009E2
  KEY_ff* = 0x000009E3
  KEY_cr* = 0x000009E4
  KEY_lf* = 0x000009E5
  KEY_nl* = 0x000009E8
  KEY_vt* = 0x000009E9
  KEY_lowrightcorner* = 0x000009EA
  KEY_uprightcorner* = 0x000009EB
  KEY_upleftcorner* = 0x000009EC
  KEY_lowleftcorner* = 0x000009ED
  KEY_crossinglines* = 0x000009EE
  KEY_horizlinescan1* = 0x000009EF
  KEY_horizlinescan3* = 0x000009F0
  KEY_horizlinescan5* = 0x000009F1
  KEY_horizlinescan7* = 0x000009F2
  KEY_horizlinescan9* = 0x000009F3
  KEY_leftt* = 0x000009F4
  KEY_rightt* = 0x000009F5
  KEY_bott* = 0x000009F6
  KEY_topt* = 0x000009F7
  KEY_vertbar* = 0x000009F8
  KEY_emspace* = 0x00000AA1
  KEY_enspace* = 0x00000AA2
  KEY_em3space* = 0x00000AA3
  KEY_em4space* = 0x00000AA4
  KEY_digitspace* = 0x00000AA5
  KEY_punctspace* = 0x00000AA6
  KEY_thinspace* = 0x00000AA7
  KEY_hairspace* = 0x00000AA8
  KEY_emdash* = 0x00000AA9
  KEY_endash* = 0x00000AAA
  KEY_signifblank* = 0x00000AAC
  KEY_ellipsis* = 0x00000AAE
  KEY_doubbaselinedot* = 0x00000AAF
  KEY_onethird* = 0x00000AB0
  KEY_twothirds* = 0x00000AB1
  KEY_onefifth* = 0x00000AB2
  KEY_twofifths* = 0x00000AB3
  KEY_threefifths* = 0x00000AB4
  KEY_fourfifths* = 0x00000AB5
  KEY_onesixth* = 0x00000AB6
  KEY_fivesixths* = 0x00000AB7
  KEY_careof* = 0x00000AB8
  KEY_figdash* = 0x00000ABB
  KEY_leftanglebracket* = 0x00000ABC
  KEY_decimalpoint* = 0x00000ABD
  KEY_rightanglebracket* = 0x00000ABE
  KEY_marker* = 0x00000ABF
  KEY_oneeighth* = 0x00000AC3
  KEY_threeeighths* = 0x00000AC4
  KEY_fiveeighths* = 0x00000AC5
  KEY_seveneighths* = 0x00000AC6
  KEY_trademark* = 0x00000AC9
  KEY_signaturemark* = 0x00000ACA
  KEY_trademarkincircle* = 0x00000ACB
  KEY_leftopentriangle* = 0x00000ACC
  KEY_rightopentriangle* = 0x00000ACD
  KEY_emopencircle* = 0x00000ACE
  KEY_emopenrectangle* = 0x00000ACF
  KEY_leftsinglequotemark* = 0x00000AD0
  KEY_rightsinglequotemark* = 0x00000AD1
  KEY_leftdoublequotemark* = 0x00000AD2
  KEY_rightdoublequotemark* = 0x00000AD3
  KEY_prescription* = 0x00000AD4
  KEY_permille* = 0x00000AD5
  KEY_minutes* = 0x00000AD6
  KEY_seconds* = 0x00000AD7
  KEY_latincross* = 0x00000AD9
  KEY_hexagram* = 0x00000ADA
  KEY_filledrectbullet* = 0x00000ADB
  KEY_filledlefttribullet* = 0x00000ADC
  KEY_filledrighttribullet* = 0x00000ADD
  KEY_emfilledcircle* = 0x00000ADE
  KEY_emfilledrect* = 0x00000ADF
  KEY_enopencircbullet* = 0x00000AE0
  KEY_enopensquarebullet* = 0x00000AE1
  KEY_openrectbullet* = 0x00000AE2
  KEY_opentribulletup* = 0x00000AE3
  KEY_opentribulletdown* = 0x00000AE4
  KEY_openstar* = 0x00000AE5
  KEY_enfilledcircbullet* = 0x00000AE6
  KEY_enfilledsqbullet* = 0x00000AE7
  KEY_filledtribulletup* = 0x00000AE8
  KEY_filledtribulletdown* = 0x00000AE9
  KEY_leftpointer* = 0x00000AEA
  KEY_rightpointer* = 0x00000AEB
  KEY_club* = 0x00000AEC
  KEY_diamond* = 0x00000AED
  KEY_heart* = 0x00000AEE
  KEY_maltesecross* = 0x00000AF0
  KEY_dagger* = 0x00000AF1
  KEY_doubledagger* = 0x00000AF2
  KEY_checkmark* = 0x00000AF3
  KEY_ballotcross* = 0x00000AF4
  KEY_musicalsharp* = 0x00000AF5
  KEY_musicalflat* = 0x00000AF6
  KEY_malesymbol* = 0x00000AF7
  KEY_femalesymbol* = 0x00000AF8
  KEY_telephone* = 0x00000AF9
  KEY_telephonerecorder* = 0x00000AFA
  KEY_phonographcopyright* = 0x00000AFB
  KEY_caret* = 0x00000AFC
  KEY_singlelowquotemark* = 0x00000AFD
  KEY_doublelowquotemark* = 0x00000AFE
  KEY_cursor* = 0x00000AFF
  KEY_leftcaret* = 0x00000BA3
  KEY_rightcaret* = 0x00000BA6
  KEY_downcaret* = 0x00000BA8
  KEY_upcaret* = 0x00000BA9
  KEY_overbar* = 0x00000BC0
  KEY_downtack* = 0x00000BC2
  KEY_upshoe* = 0x00000BC3
  KEY_downstile* = 0x00000BC4
  KEY_underbar* = 0x00000BC6
  KEY_jot* = 0x00000BCA
  KEY_quad* = 0x00000BCC
  KEY_uptack* = 0x00000BCE
  KEY_circle* = 0x00000BCF
  KEY_upstile* = 0x00000BD3
  KEY_downshoe* = 0x00000BD6
  KEY_rightshoe* = 0x00000BD8
  KEY_leftshoe* = 0x00000BDA
  KEY_lefttack* = 0x00000BDC
  KEY_righttack* = 0x00000BFC
  KEY_hebrew_doublelowline* = 0x00000CDF
  KEY_hebrew_aleph* = 0x00000CE0
  KEY_hebrew_bet* = 0x00000CE1
  KEY_hebrew_beth* = 0x00000CE1
  KEY_hebrew_gimel* = 0x00000CE2
  KEY_hebrew_gimmel* = 0x00000CE2
  KEY_hebrew_dalet* = 0x00000CE3
  KEY_hebrew_daleth* = 0x00000CE3
  KEY_hebrew_he* = 0x00000CE4
  KEY_hebrew_waw* = 0x00000CE5
  KEY_hebrew_zain* = 0x00000CE6
  KEY_hebrew_zayin* = 0x00000CE6
  KEY_hebrew_chet* = 0x00000CE7
  KEY_hebrew_het* = 0x00000CE7
  KEY_hebrew_tet* = 0x00000CE8
  KEY_hebrew_teth* = 0x00000CE8
  KEY_hebrew_yod* = 0x00000CE9
  KEY_hebrew_finalkaph* = 0x00000CEA
  KEY_hebrew_kaph* = 0x00000CEB
  KEY_hebrew_lamed* = 0x00000CEC
  KEY_hebrew_finalmem* = 0x00000CED
  KEY_hebrew_mem* = 0x00000CEE
  KEY_hebrew_finalnun* = 0x00000CEF
  KEY_hebrew_nun* = 0x00000CF0
  KEY_hebrew_samech* = 0x00000CF1
  KEY_hebrew_samekh* = 0x00000CF1
  KEY_hebrew_ayin* = 0x00000CF2
  KEY_hebrew_finalpe* = 0x00000CF3
  KEY_hebrew_pe* = 0x00000CF4
  KEY_hebrew_finalzade* = 0x00000CF5
  KEY_hebrew_finalzadi* = 0x00000CF5
  KEY_hebrew_zade* = 0x00000CF6
  KEY_hebrew_zadi* = 0x00000CF6
  KEY_hebrew_qoph* = 0x00000CF7
  KEY_hebrew_kuf* = 0x00000CF7
  KEY_hebrew_resh* = 0x00000CF8
  KEY_hebrew_shin* = 0x00000CF9
  KEY_hebrew_taw* = 0x00000CFA
  KEY_hebrew_taf* = 0x00000CFA
  KEY_Hebrew_switch* = 0x0000FF7E
  KEY_Thai_kokai* = 0x00000DA1
  KEY_Thai_khokhai* = 0x00000DA2
  KEY_Thai_khokhuat* = 0x00000DA3
  KEY_Thai_khokhwai* = 0x00000DA4
  KEY_Thai_khokhon* = 0x00000DA5
  KEY_Thai_khorakhang* = 0x00000DA6
  KEY_Thai_ngongu* = 0x00000DA7
  KEY_Thai_chochan* = 0x00000DA8
  KEY_Thai_choching* = 0x00000DA9
  KEY_Thai_chochang* = 0x00000DAA
  KEY_Thai_soso* = 0x00000DAB
  KEY_Thai_chochoe* = 0x00000DAC
  KEY_Thai_yoying* = 0x00000DAD
  KEY_Thai_dochada* = 0x00000DAE
  KEY_Thai_topatak* = 0x00000DAF
  KEY_Thai_thothan* = 0x00000DB0
  KEY_Thai_thonangmontho* = 0x00000DB1
  KEY_Thai_thophuthao* = 0x00000DB2
  KEY_Thai_nonen* = 0x00000DB3
  KEY_Thai_dodek* = 0x00000DB4
  KEY_Thai_totao* = 0x00000DB5
  KEY_Thai_thothung* = 0x00000DB6
  KEY_Thai_thothahan* = 0x00000DB7
  KEY_Thai_thothong* = 0x00000DB8
  KEY_Thai_nonu* = 0x00000DB9
  KEY_Thai_bobaimai* = 0x00000DBA
  KEY_Thai_popla* = 0x00000DBB
  KEY_Thai_phophung* = 0x00000DBC
  KEY_Thai_fofa* = 0x00000DBD
  KEY_Thai_phophan* = 0x00000DBE
  KEY_Thai_fofan* = 0x00000DBF
  KEY_Thai_phosamphao* = 0x00000DC0
  KEY_Thai_moma* = 0x00000DC1
  KEY_Thai_yoyak* = 0x00000DC2
  KEY_Thai_rorua* = 0x00000DC3
  KEY_Thai_ru* = 0x00000DC4
  KEY_Thai_loling* = 0x00000DC5
  KEY_Thai_lu* = 0x00000DC6
  KEY_Thai_wowaen* = 0x00000DC7
  KEY_Thai_sosala* = 0x00000DC8
  KEY_Thai_sorusi* = 0x00000DC9
  KEY_Thai_sosua* = 0x00000DCA
  KEY_Thai_hohip* = 0x00000DCB
  KEY_Thai_lochula* = 0x00000DCC
  KEY_Thai_oang* = 0x00000DCD
  KEY_Thai_honokhuk* = 0x00000DCE
  KEY_Thai_paiyannoi* = 0x00000DCF
  KEY_Thai_saraa* = 0x00000DD0
  KEY_Thai_maihanakat* = 0x00000DD1
  KEY_Thai_saraaa* = 0x00000DD2
  KEY_Thai_saraam* = 0x00000DD3
  KEY_Thai_sarai* = 0x00000DD4
  KEY_Thai_saraii* = 0x00000DD5
  KEY_Thai_saraue* = 0x00000DD6
  KEY_Thai_sarauee* = 0x00000DD7
  KEY_Thai_sarau* = 0x00000DD8
  KEY_Thai_sarauu* = 0x00000DD9
  KEY_Thai_phinthu* = 0x00000DDA
  KEY_Thai_maihanakat_maitho* = 0x00000DDE
  KEY_Thai_baht* = 0x00000DDF
  KEY_Thai_sarae* = 0x00000DE0
  KEY_Thai_saraae* = 0x00000DE1
  KEY_Thai_sarao* = 0x00000DE2
  KEY_Thai_saraaimaimuan* = 0x00000DE3
  KEY_Thai_saraaimaimalai* = 0x00000DE4
  KEY_Thai_lakkhangyao* = 0x00000DE5
  KEY_Thai_maiyamok* = 0x00000DE6
  KEY_Thai_maitaikhu* = 0x00000DE7
  KEY_Thai_maiek* = 0x00000DE8
  KEY_Thai_maitho* = 0x00000DE9
  KEY_Thai_maitri* = 0x00000DEA
  KEY_Thai_maichattawa* = 0x00000DEB
  KEY_Thai_thanthakhat* = 0x00000DEC
  KEY_Thai_nikhahit* = 0x00000DED
  KEY_Thai_leksun* = 0x00000DF0
  KEY_Thai_leknung* = 0x00000DF1
  KEY_Thai_leksong* = 0x00000DF2
  KEY_Thai_leksam* = 0x00000DF3
  KEY_Thai_leksi* = 0x00000DF4
  KEY_Thai_lekha* = 0x00000DF5
  KEY_Thai_lekhok* = 0x00000DF6
  KEY_Thai_lekchet* = 0x00000DF7
  KEY_Thai_lekpaet* = 0x00000DF8
  KEY_Thai_lekkao* = 0x00000DF9
  KEY_Hangul* = 0x0000FF31
  KEY_Hangul_Start* = 0x0000FF32
  KEY_Hangul_End* = 0x0000FF33
  KEY_Hangul_Hanja* = 0x0000FF34
  KEY_Hangul_Jamo* = 0x0000FF35
  KEY_Hangul_Romaja* = 0x0000FF36
  KEY_Hangul_Codeinput* = 0x0000FF37
  KEY_Hangul_Jeonja* = 0x0000FF38
  KEY_Hangul_Banja* = 0x0000FF39
  KEY_Hangul_PreHanja* = 0x0000FF3A
  KEY_Hangul_PostHanja* = 0x0000FF3B
  KEY_Hangul_SingleCandidate* = 0x0000FF3C
  KEY_Hangul_MultipleCandidate* = 0x0000FF3D
  KEY_Hangul_PreviousCandidate* = 0x0000FF3E
  KEY_Hangul_Special* = 0x0000FF3F
  KEY_Hangul_switch* = 0x0000FF7E
  KEY_Hangul_Kiyeog* = 0x00000EA1
  KEY_Hangul_SsangKiyeog* = 0x00000EA2
  KEY_Hangul_KiyeogSios* = 0x00000EA3
  KEY_Hangul_Nieun* = 0x00000EA4
  KEY_Hangul_NieunJieuj* = 0x00000EA5
  KEY_Hangul_NieunHieuh* = 0x00000EA6
  KEY_Hangul_Dikeud* = 0x00000EA7
  KEY_Hangul_SsangDikeud* = 0x00000EA8
  KEY_Hangul_Rieul* = 0x00000EA9
  KEY_Hangul_RieulKiyeog* = 0x00000EAA
  KEY_Hangul_RieulMieum* = 0x00000EAB
  KEY_Hangul_RieulPieub* = 0x00000EAC
  KEY_Hangul_RieulSios* = 0x00000EAD
  KEY_Hangul_RieulTieut* = 0x00000EAE
  KEY_Hangul_RieulPhieuf* = 0x00000EAF
  KEY_Hangul_RieulHieuh* = 0x00000EB0
  KEY_Hangul_Mieum* = 0x00000EB1
  KEY_Hangul_Pieub* = 0x00000EB2
  KEY_Hangul_SsangPieub* = 0x00000EB3
  KEY_Hangul_PieubSios* = 0x00000EB4
  KEY_Hangul_Sios* = 0x00000EB5
  KEY_Hangul_SsangSios* = 0x00000EB6
  KEY_Hangul_Ieung* = 0x00000EB7
  KEY_Hangul_Jieuj* = 0x00000EB8
  KEY_Hangul_SsangJieuj* = 0x00000EB9
  KEY_Hangul_Cieuc* = 0x00000EBA
  KEY_Hangul_Khieuq* = 0x00000EBB
  KEY_Hangul_Tieut* = 0x00000EBC
  KEY_Hangul_Phieuf* = 0x00000EBD
  KEY_Hangul_Hieuh* = 0x00000EBE
  KEY_Hangul_A* = 0x00000EBF
  KEY_Hangul_AE* = 0x00000EC0
  KEY_Hangul_YA* = 0x00000EC1
  KEY_Hangul_YAE* = 0x00000EC2
  KEY_Hangul_EO* = 0x00000EC3
  KEY_Hangul_E* = 0x00000EC4
  KEY_Hangul_YEO* = 0x00000EC5
  KEY_Hangul_YE* = 0x00000EC6
  KEY_Hangul_O* = 0x00000EC7
  KEY_Hangul_WA* = 0x00000EC8
  KEY_Hangul_WAE* = 0x00000EC9
  KEY_Hangul_OE* = 0x00000ECA
  KEY_Hangul_YO* = 0x00000ECB
  KEY_Hangul_U* = 0x00000ECC
  KEY_Hangul_WEO* = 0x00000ECD
  KEY_Hangul_WE* = 0x00000ECE
  KEY_Hangul_WI* = 0x00000ECF
  KEY_Hangul_YU* = 0x00000ED0
  KEY_Hangul_EU* = 0x00000ED1
  KEY_Hangul_YI* = 0x00000ED2
  KEY_Hangul_I* = 0x00000ED3
  KEY_Hangul_J_Kiyeog* = 0x00000ED4
  KEY_Hangul_J_SsangKiyeog* = 0x00000ED5
  KEY_Hangul_J_KiyeogSios* = 0x00000ED6
  KEY_Hangul_J_Nieun* = 0x00000ED7
  KEY_Hangul_J_NieunJieuj* = 0x00000ED8
  KEY_Hangul_J_NieunHieuh* = 0x00000ED9
  KEY_Hangul_J_Dikeud* = 0x00000EDA
  KEY_Hangul_J_Rieul* = 0x00000EDB
  KEY_Hangul_J_RieulKiyeog* = 0x00000EDC
  KEY_Hangul_J_RieulMieum* = 0x00000EDD
  KEY_Hangul_J_RieulPieub* = 0x00000EDE
  KEY_Hangul_J_RieulSios* = 0x00000EDF
  KEY_Hangul_J_RieulTieut* = 0x00000EE0
  KEY_Hangul_J_RieulPhieuf* = 0x00000EE1
  KEY_Hangul_J_RieulHieuh* = 0x00000EE2
  KEY_Hangul_J_Mieum* = 0x00000EE3
  KEY_Hangul_J_Pieub* = 0x00000EE4
  KEY_Hangul_J_PieubSios* = 0x00000EE5
  KEY_Hangul_J_Sios* = 0x00000EE6
  KEY_Hangul_J_SsangSios* = 0x00000EE7
  KEY_Hangul_J_Ieung* = 0x00000EE8
  KEY_Hangul_J_Jieuj* = 0x00000EE9
  KEY_Hangul_J_Cieuc* = 0x00000EEA
  KEY_Hangul_J_Khieuq* = 0x00000EEB
  KEY_Hangul_J_Tieut* = 0x00000EEC
  KEY_Hangul_J_Phieuf* = 0x00000EED
  KEY_Hangul_J_Hieuh* = 0x00000EEE
  KEY_Hangul_RieulYeorinHieuh* = 0x00000EEF
  KEY_Hangul_SunkyeongeumMieum* = 0x00000EF0
  KEY_Hangul_SunkyeongeumPieub* = 0x00000EF1
  KEY_Hangul_PanSios* = 0x00000EF2
  KEY_Hangul_KkogjiDalrinIeung* = 0x00000EF3
  KEY_Hangul_SunkyeongeumPhieuf* = 0x00000EF4
  KEY_Hangul_YeorinHieuh* = 0x00000EF5
  KEY_Hangul_AraeA* = 0x00000EF6
  KEY_Hangul_AraeAE* = 0x00000EF7
  KEY_Hangul_J_PanSios* = 0x00000EF8
  KEY_Hangul_J_KkogjiDalrinIeung* = 0x00000EF9
  KEY_Hangul_J_YeorinHieuh* = 0x00000EFA
  KEY_Korean_Won* = 0x00000EFF
  KEY_Armenian_ligature_ew* = 0x01000587
  KEY_Armenian_full_stop* = 0x01000589
  KEY_Armenian_verjaket* = 0x01000589
  KEY_Armenian_separation_mark* = 0x0100055D
  KEY_Armenian_but* = 0x0100055D
  KEY_Armenian_hyphen* = 0x0100058A
  KEY_Armenian_yentamna* = 0x0100058A
  KEY_Armenian_exclam* = 0x0100055C
  KEY_Armenian_amanak* = 0x0100055C
  KEY_Armenian_accent* = 0x0100055B
  KEY_Armenian_shesht* = 0x0100055B
  KEY_Armenian_question* = 0x0100055E
  KEY_Armenian_paruyk* = 0x0100055E
  KEY_CAPITAL_Armenian_AYB* = 0x01000531
  KEY_Armenian_ayb* = 0x01000561
  KEY_CAPITAL_Armenian_BEN* = 0x01000532
  KEY_Armenian_ben* = 0x01000562
  KEY_CAPITAL_Armenian_GIM* = 0x01000533
  KEY_Armenian_gim* = 0x01000563
  KEY_CAPITAL_Armenian_DA* = 0x01000534
  KEY_Armenian_da* = 0x01000564
  KEY_CAPITAL_Armenian_YECH* = 0x01000535
  KEY_Armenian_yech* = 0x01000565
  KEY_CAPITAL_Armenian_ZA* = 0x01000536
  KEY_Armenian_za* = 0x01000566
  KEY_CAPITAL_Armenian_E* = 0x01000537
  KEY_Armenian_e* = 0x01000567
  KEY_CAPITAL_Armenian_AT* = 0x01000538
  KEY_Armenian_at* = 0x01000568
  KEY_CAPITAL_Armenian_TO* = 0x01000539
  KEY_Armenian_to* = 0x01000569
  KEY_CAPITAL_Armenian_ZHE* = 0x0100053A
  KEY_Armenian_zhe* = 0x0100056A
  KEY_CAPITAL_Armenian_INI* = 0x0100053B
  KEY_Armenian_ini* = 0x0100056B
  KEY_CAPITAL_Armenian_LYUN* = 0x0100053C
  KEY_Armenian_lyun* = 0x0100056C
  KEY_CAPITAL_Armenian_KHE* = 0x0100053D
  KEY_Armenian_khe* = 0x0100056D
  KEY_CAPITAL_Armenian_TSA* = 0x0100053E
  KEY_Armenian_tsa* = 0x0100056E
  KEY_CAPITAL_Armenian_KEN* = 0x0100053F
  KEY_Armenian_ken* = 0x0100056F
  KEY_CAPITAL_Armenian_HO* = 0x01000540
  KEY_Armenian_ho* = 0x01000570
  KEY_CAPITAL_Armenian_DZA* = 0x01000541
  KEY_Armenian_dza* = 0x01000571
  KEY_CAPITAL_Armenian_GHAT* = 0x01000542
  KEY_Armenian_ghat* = 0x01000572
  KEY_CAPITAL_Armenian_TCHE* = 0x01000543
  KEY_Armenian_tche* = 0x01000573
  KEY_CAPITAL_Armenian_MEN* = 0x01000544
  KEY_Armenian_men* = 0x01000574
  KEY_CAPITAL_Armenian_HI* = 0x01000545
  KEY_Armenian_hi* = 0x01000575
  KEY_CAPITAL_Armenian_NU* = 0x01000546
  KEY_Armenian_nu* = 0x01000576
  KEY_CAPITAL_Armenian_SHA* = 0x01000547
  KEY_Armenian_sha* = 0x01000577
  KEY_CAPITAL_Armenian_VO* = 0x01000548
  KEY_Armenian_vo* = 0x01000578
  KEY_CAPITAL_Armenian_CHA* = 0x01000549
  KEY_Armenian_cha* = 0x01000579
  KEY_CAPITAL_Armenian_PE* = 0x0100054A
  KEY_Armenian_pe* = 0x0100057A
  KEY_CAPITAL_Armenian_JE* = 0x0100054B
  KEY_Armenian_je* = 0x0100057B
  KEY_CAPITAL_Armenian_RA* = 0x0100054C
  KEY_Armenian_ra* = 0x0100057C
  KEY_CAPITAL_Armenian_SE* = 0x0100054D
  KEY_Armenian_se* = 0x0100057D
  KEY_CAPITAL_Armenian_VEV* = 0x0100054E
  KEY_Armenian_vev* = 0x0100057E
  KEY_CAPITAL_Armenian_TYUN* = 0x0100054F
  KEY_Armenian_tyun* = 0x0100057F
  KEY_CAPITAL_Armenian_RE* = 0x01000550
  KEY_Armenian_re* = 0x01000580
  KEY_CAPITAL_Armenian_TSO* = 0x01000551
  KEY_Armenian_tso* = 0x01000581
  KEY_CAPITAL_Armenian_VYUN* = 0x01000552
  KEY_Armenian_vyun* = 0x01000582
  KEY_CAPITAL_Armenian_PYUR* = 0x01000553
  KEY_Armenian_pyur* = 0x01000583
  KEY_CAPITAL_Armenian_KE* = 0x01000554
  KEY_Armenian_ke* = 0x01000584
  KEY_CAPITAL_Armenian_O* = 0x01000555
  KEY_Armenian_o* = 0x01000585
  KEY_CAPITAL_Armenian_FE* = 0x01000556
  KEY_Armenian_fe* = 0x01000586
  KEY_Armenian_apostrophe* = 0x0100055A
  KEY_Georgian_an* = 0x010010D0
  KEY_Georgian_ban* = 0x010010D1
  KEY_Georgian_gan* = 0x010010D2
  KEY_Georgian_don* = 0x010010D3
  KEY_Georgian_en* = 0x010010D4
  KEY_Georgian_vin* = 0x010010D5
  KEY_Georgian_zen* = 0x010010D6
  KEY_Georgian_tan* = 0x010010D7
  KEY_Georgian_in* = 0x010010D8
  KEY_Georgian_kan* = 0x010010D9
  KEY_Georgian_las* = 0x010010DA
  KEY_Georgian_man* = 0x010010DB
  KEY_Georgian_nar* = 0x010010DC
  KEY_Georgian_on* = 0x010010DD
  KEY_Georgian_par* = 0x010010DE
  KEY_Georgian_zhar* = 0x010010DF
  KEY_Georgian_rae* = 0x010010E0
  KEY_Georgian_san* = 0x010010E1
  KEY_Georgian_tar* = 0x010010E2
  KEY_Georgian_un* = 0x010010E3
  KEY_Georgian_phar* = 0x010010E4
  KEY_Georgian_khar* = 0x010010E5
  KEY_Georgian_ghan* = 0x010010E6
  KEY_Georgian_qar* = 0x010010E7
  KEY_Georgian_shin* = 0x010010E8
  KEY_Georgian_chin* = 0x010010E9
  KEY_Georgian_can* = 0x010010EA
  KEY_Georgian_jil* = 0x010010EB
  KEY_Georgian_cil* = 0x010010EC
  KEY_Georgian_char* = 0x010010ED
  KEY_Georgian_xan* = 0x010010EE
  KEY_Georgian_jhan* = 0x010010EF
  KEY_Georgian_hae* = 0x010010F0
  KEY_Georgian_he* = 0x010010F1
  KEY_Georgian_hie* = 0x010010F2
  KEY_Georgian_we* = 0x010010F3
  KEY_Georgian_har* = 0x010010F4
  KEY_Georgian_hoe* = 0x010010F5
  KEY_Georgian_fi* = 0x010010F6
  KEY_CAPITAL_Xabovedot* = 0x01001E8A
  KEY_CAPITAL_Ibreve* = 0x0100012C
  KEY_CAPITAL_Zstroke* = 0x010001B5
  KEY_CAPITAL_Gcaron* = 0x010001E6
  KEY_CAPITAL_Ocaron* = 0x010001D1
  KEY_CAPITAL_Obarred* = 0x0100019F
  KEY_xabovedot* = 0x01001E8B
  KEY_ibreve* = 0x0100012D
  KEY_zstroke* = 0x010001B6
  KEY_gcaron* = 0x010001E7
  KEY_ocaron* = 0x010001D2
  KEY_obarred* = 0x01000275
  KEY_CAPITAL_SCHWA* = 0x0100018F
  KEY_schwa* = 0x01000259
  KEY_CAPITAL_EZH* = 0x010001B7
  KEY_ezh* = 0x01000292
  KEY_CAPITAL_Lbelowdot* = 0x01001E36
  KEY_lbelowdot* = 0x01001E37
  KEY_CAPITAL_Abelowdot* = 0x01001EA0
  KEY_abelowdot* = 0x01001EA1
  KEY_CAPITAL_Ahook* = 0x01001EA2
  KEY_ahook* = 0x01001EA3
  KEY_CAPITAL_Acircumflexacute* = 0x01001EA4
  KEY_acircumflexacute* = 0x01001EA5
  KEY_CAPITAL_Acircumflexgrave* = 0x01001EA6
  KEY_acircumflexgrave* = 0x01001EA7
  KEY_CAPITAL_Acircumflexhook* = 0x01001EA8
  KEY_acircumflexhook* = 0x01001EA9
  KEY_CAPITAL_Acircumflextilde* = 0x01001EAA
  KEY_acircumflextilde* = 0x01001EAB
  KEY_CAPITAL_Acircumflexbelowdot* = 0x01001EAC
  KEY_acircumflexbelowdot* = 0x01001EAD
  KEY_CAPITAL_Abreveacute* = 0x01001EAE
  KEY_abreveacute* = 0x01001EAF
  KEY_CAPITAL_Abrevegrave* = 0x01001EB0
  KEY_abrevegrave* = 0x01001EB1
  KEY_CAPITAL_Abrevehook* = 0x01001EB2
  KEY_abrevehook* = 0x01001EB3
  KEY_CAPITAL_Abrevetilde* = 0x01001EB4
  KEY_abrevetilde* = 0x01001EB5
  KEY_CAPITAL_Abrevebelowdot* = 0x01001EB6
  KEY_abrevebelowdot* = 0x01001EB7
  KEY_CAPITAL_Ebelowdot* = 0x01001EB8
  KEY_ebelowdot* = 0x01001EB9
  KEY_CAPITAL_Ehook* = 0x01001EBA
  KEY_ehook* = 0x01001EBB
  KEY_CAPITAL_Etilde* = 0x01001EBC
  KEY_etilde* = 0x01001EBD
  KEY_CAPITAL_Ecircumflexacute* = 0x01001EBE
  KEY_ecircumflexacute* = 0x01001EBF
  KEY_CAPITAL_Ecircumflexgrave* = 0x01001EC0
  KEY_ecircumflexgrave* = 0x01001EC1
  KEY_CAPITAL_Ecircumflexhook* = 0x01001EC2
  KEY_ecircumflexhook* = 0x01001EC3
  KEY_CAPITAL_Ecircumflextilde* = 0x01001EC4
  KEY_ecircumflextilde* = 0x01001EC5
  KEY_CAPITAL_Ecircumflexbelowdot* = 0x01001EC6
  KEY_ecircumflexbelowdot* = 0x01001EC7
  KEY_CAPITAL_Ihook* = 0x01001EC8
  KEY_ihook* = 0x01001EC9
  KEY_CAPITAL_Ibelowdot* = 0x01001ECA
  KEY_ibelowdot* = 0x01001ECB
  KEY_CAPITAL_Obelowdot* = 0x01001ECC
  KEY_obelowdot* = 0x01001ECD
  KEY_CAPITAL_Ohook* = 0x01001ECE
  KEY_ohook* = 0x01001ECF
  KEY_CAPITAL_Ocircumflexacute* = 0x01001ED0
  KEY_ocircumflexacute* = 0x01001ED1
  KEY_CAPITAL_Ocircumflexgrave* = 0x01001ED2
  KEY_ocircumflexgrave* = 0x01001ED3
  KEY_CAPITAL_Ocircumflexhook* = 0x01001ED4
  KEY_ocircumflexhook* = 0x01001ED5
  KEY_CAPITAL_Ocircumflextilde* = 0x01001ED6
  KEY_ocircumflextilde* = 0x01001ED7
  KEY_CAPITAL_Ocircumflexbelowdot* = 0x01001ED8
  KEY_ocircumflexbelowdot* = 0x01001ED9
  KEY_CAPITAL_Ohornacute* = 0x01001EDA
  KEY_ohornacute* = 0x01001EDB
  KEY_CAPITAL_Ohorngrave* = 0x01001EDC
  KEY_ohorngrave* = 0x01001EDD
  KEY_CAPITAL_Ohornhook* = 0x01001EDE
  KEY_ohornhook* = 0x01001EDF
  KEY_CAPITAL_Ohorntilde* = 0x01001EE0
  KEY_ohorntilde* = 0x01001EE1
  KEY_CAPITAL_Ohornbelowdot* = 0x01001EE2
  KEY_ohornbelowdot* = 0x01001EE3
  KEY_CAPITAL_Ubelowdot* = 0x01001EE4
  KEY_ubelowdot* = 0x01001EE5
  KEY_CAPITAL_Uhook* = 0x01001EE6
  KEY_uhook* = 0x01001EE7
  KEY_CAPITAL_Uhornacute* = 0x01001EE8
  KEY_uhornacute* = 0x01001EE9
  KEY_CAPITAL_Uhorngrave* = 0x01001EEA
  KEY_uhorngrave* = 0x01001EEB
  KEY_CAPITAL_Uhornhook* = 0x01001EEC
  KEY_uhornhook* = 0x01001EED
  KEY_CAPITAL_Uhorntilde* = 0x01001EEE
  KEY_uhorntilde* = 0x01001EEF
  KEY_CAPITAL_Uhornbelowdot* = 0x01001EF0
  KEY_uhornbelowdot* = 0x01001EF1
  KEY_CAPITAL_Ybelowdot* = 0x01001EF4
  KEY_ybelowdot* = 0x01001EF5
  KEY_CAPITAL_Yhook* = 0x01001EF6
  KEY_yhook* = 0x01001EF7
  KEY_CAPITAL_Ytilde* = 0x01001EF8
  KEY_ytilde* = 0x01001EF9
  KEY_CAPITAL_Ohorn* = 0x010001A0
  KEY_ohorn* = 0x010001A1
  KEY_CAPITAL_Uhorn* = 0x010001AF
  KEY_uhorn* = 0x010001B0
  KEY_EcuSign* = 0x010020A0
  KEY_ColonSign* = 0x010020A1
  KEY_CruzeiroSign* = 0x010020A2
  KEY_FFrancSign* = 0x010020A3
  KEY_LiraSign* = 0x010020A4
  KEY_MillSign* = 0x010020A5
  KEY_NairaSign* = 0x010020A6
  KEY_PesetaSign* = 0x010020A7
  KEY_RupeeSign* = 0x010020A8
  KEY_WonSign* = 0x010020A9
  KEY_NewSheqelSign* = 0x010020AA
  KEY_DongSign* = 0x010020AB
  KEY_EuroSign* = 0x000020AC
  KEY_zerosuperior* = 0x01002070
  KEY_foursuperior* = 0x01002074
  KEY_fivesuperior* = 0x01002075
  KEY_sixsuperior* = 0x01002076
  KEY_sevensuperior* = 0x01002077
  KEY_eightsuperior* = 0x01002078
  KEY_ninesuperior* = 0x01002079
  KEY_zerosubscript* = 0x01002080
  KEY_onesubscript* = 0x01002081
  KEY_twosubscript* = 0x01002082
  KEY_threesubscript* = 0x01002083
  KEY_foursubscript* = 0x01002084
  KEY_fivesubscript* = 0x01002085
  KEY_sixsubscript* = 0x01002086
  KEY_sevensubscript* = 0x01002087
  KEY_eightsubscript* = 0x01002088
  KEY_ninesubscript* = 0x01002089
  KEY_partdifferential* = 0x01002202
  KEY_emptyset* = 0x01002205
  KEY_elementof* = 0x01002208
  KEY_notelementof* = 0x01002209
  KEY_containsas* = 0x0100220B
  KEY_squareroot* = 0x0100221A
  KEY_cuberoot* = 0x0100221B
  KEY_fourthroot* = 0x0100221C
  KEY_dintegral* = 0x0100222C
  KEY_tintegral* = 0x0100222D
  KEY_because* = 0x01002235
  KEY_approxeq* = 0x01002248
  KEY_notapproxeq* = 0x01002247
  KEY_notidentical* = 0x01002262
  KEY_stricteq* = 0x01002263
  KEY_braille_dot_1* = 0x0000FFF1
  KEY_braille_dot_2* = 0x0000FFF2
  KEY_braille_dot_3* = 0x0000FFF3
  KEY_braille_dot_4* = 0x0000FFF4
  KEY_braille_dot_5* = 0x0000FFF5
  KEY_braille_dot_6* = 0x0000FFF6
  KEY_braille_dot_7* = 0x0000FFF7
  KEY_braille_dot_8* = 0x0000FFF8
  KEY_braille_dot_9* = 0x0000FFF9
  KEY_braille_dot_10* = 0x0000FFFA
  KEY_braille_blank* = 0x01002800
  KEY_braille_dots_1* = 0x01002801
  KEY_braille_dots_2* = 0x01002802
  KEY_braille_dots_12* = 0x01002803
  KEY_braille_dots_3* = 0x01002804
  KEY_braille_dots_13* = 0x01002805
  KEY_braille_dots_23* = 0x01002806
  KEY_braille_dots_123* = 0x01002807
  KEY_braille_dots_4* = 0x01002808
  KEY_braille_dots_14* = 0x01002809
  KEY_braille_dots_24* = 0x0100280A
  KEY_braille_dots_124* = 0x0100280B
  KEY_braille_dots_34* = 0x0100280C
  KEY_braille_dots_134* = 0x0100280D
  KEY_braille_dots_234* = 0x0100280E
  KEY_braille_dots_1234* = 0x0100280F
  KEY_braille_dots_5* = 0x01002810
  KEY_braille_dots_15* = 0x01002811
  KEY_braille_dots_25* = 0x01002812
  KEY_braille_dots_125* = 0x01002813
  KEY_braille_dots_35* = 0x01002814
  KEY_braille_dots_135* = 0x01002815
  KEY_braille_dots_235* = 0x01002816
  KEY_braille_dots_1235* = 0x01002817
  KEY_braille_dots_45* = 0x01002818
  KEY_braille_dots_145* = 0x01002819
  KEY_braille_dots_245* = 0x0100281A
  KEY_braille_dots_1245* = 0x0100281B
  KEY_braille_dots_345* = 0x0100281C
  KEY_braille_dots_1345* = 0x0100281D
  KEY_braille_dots_2345* = 0x0100281E
  KEY_braille_dots_12345* = 0x0100281F
  KEY_braille_dots_6* = 0x01002820
  KEY_braille_dots_16* = 0x01002821
  KEY_braille_dots_26* = 0x01002822
  KEY_braille_dots_126* = 0x01002823
  KEY_braille_dots_36* = 0x01002824
  KEY_braille_dots_136* = 0x01002825
  KEY_braille_dots_236* = 0x01002826
  KEY_braille_dots_1236* = 0x01002827
  KEY_braille_dots_46* = 0x01002828
  KEY_braille_dots_146* = 0x01002829
  KEY_braille_dots_246* = 0x0100282A
  KEY_braille_dots_1246* = 0x0100282B
  KEY_braille_dots_346* = 0x0100282C
  KEY_braille_dots_1346* = 0x0100282D
  KEY_braille_dots_2346* = 0x0100282E
  KEY_braille_dots_12346* = 0x0100282F
  KEY_braille_dots_56* = 0x01002830
  KEY_braille_dots_156* = 0x01002831
  KEY_braille_dots_256* = 0x01002832
  KEY_braille_dots_1256* = 0x01002833
  KEY_braille_dots_356* = 0x01002834
  KEY_braille_dots_1356* = 0x01002835
  KEY_braille_dots_2356* = 0x01002836
  KEY_braille_dots_12356* = 0x01002837
  KEY_braille_dots_456* = 0x01002838
  KEY_braille_dots_1456* = 0x01002839
  KEY_braille_dots_2456* = 0x0100283A
  KEY_braille_dots_12456* = 0x0100283B
  KEY_braille_dots_3456* = 0x0100283C
  KEY_braille_dots_13456* = 0x0100283D
  KEY_braille_dots_23456* = 0x0100283E
  KEY_braille_dots_123456* = 0x0100283F
  KEY_braille_dots_7* = 0x01002840
  KEY_braille_dots_17* = 0x01002841
  KEY_braille_dots_27* = 0x01002842
  KEY_braille_dots_127* = 0x01002843
  KEY_braille_dots_37* = 0x01002844
  KEY_braille_dots_137* = 0x01002845
  KEY_braille_dots_237* = 0x01002846
  KEY_braille_dots_1237* = 0x01002847
  KEY_braille_dots_47* = 0x01002848
  KEY_braille_dots_147* = 0x01002849
  KEY_braille_dots_247* = 0x0100284A
  KEY_braille_dots_1247* = 0x0100284B
  KEY_braille_dots_347* = 0x0100284C
  KEY_braille_dots_1347* = 0x0100284D
  KEY_braille_dots_2347* = 0x0100284E
  KEY_braille_dots_12347* = 0x0100284F
  KEY_braille_dots_57* = 0x01002850
  KEY_braille_dots_157* = 0x01002851
  KEY_braille_dots_257* = 0x01002852
  KEY_braille_dots_1257* = 0x01002853
  KEY_braille_dots_357* = 0x01002854
  KEY_braille_dots_1357* = 0x01002855
  KEY_braille_dots_2357* = 0x01002856
  KEY_braille_dots_12357* = 0x01002857
  KEY_braille_dots_457* = 0x01002858
  KEY_braille_dots_1457* = 0x01002859
  KEY_braille_dots_2457* = 0x0100285A
  KEY_braille_dots_12457* = 0x0100285B
  KEY_braille_dots_3457* = 0x0100285C
  KEY_braille_dots_13457* = 0x0100285D
  KEY_braille_dots_23457* = 0x0100285E
  KEY_braille_dots_123457* = 0x0100285F
  KEY_braille_dots_67* = 0x01002860
  KEY_braille_dots_167* = 0x01002861
  KEY_braille_dots_267* = 0x01002862
  KEY_braille_dots_1267* = 0x01002863
  KEY_braille_dots_367* = 0x01002864
  KEY_braille_dots_1367* = 0x01002865
  KEY_braille_dots_2367* = 0x01002866
  KEY_braille_dots_12367* = 0x01002867
  KEY_braille_dots_467* = 0x01002868
  KEY_braille_dots_1467* = 0x01002869
  KEY_braille_dots_2467* = 0x0100286A
  KEY_braille_dots_12467* = 0x0100286B
  KEY_braille_dots_3467* = 0x0100286C
  KEY_braille_dots_13467* = 0x0100286D
  KEY_braille_dots_23467* = 0x0100286E
  KEY_braille_dots_123467* = 0x0100286F
  KEY_braille_dots_567* = 0x01002870
  KEY_braille_dots_1567* = 0x01002871
  KEY_braille_dots_2567* = 0x01002872
  KEY_braille_dots_12567* = 0x01002873
  KEY_braille_dots_3567* = 0x01002874
  KEY_braille_dots_13567* = 0x01002875
  KEY_braille_dots_23567* = 0x01002876
  KEY_braille_dots_123567* = 0x01002877
  KEY_braille_dots_4567* = 0x01002878
  KEY_braille_dots_14567* = 0x01002879
  KEY_braille_dots_24567* = 0x0100287A
  KEY_braille_dots_124567* = 0x0100287B
  KEY_braille_dots_34567* = 0x0100287C
  KEY_braille_dots_134567* = 0x0100287D
  KEY_braille_dots_234567* = 0x0100287E
  KEY_braille_dots_1234567* = 0x0100287F
  KEY_braille_dots_8* = 0x01002880
  KEY_braille_dots_18* = 0x01002881
  KEY_braille_dots_28* = 0x01002882
  KEY_braille_dots_128* = 0x01002883
  KEY_braille_dots_38* = 0x01002884
  KEY_braille_dots_138* = 0x01002885
  KEY_braille_dots_238* = 0x01002886
  KEY_braille_dots_1238* = 0x01002887
  KEY_braille_dots_48* = 0x01002888
  KEY_braille_dots_148* = 0x01002889
  KEY_braille_dots_248* = 0x0100288A
  KEY_braille_dots_1248* = 0x0100288B
  KEY_braille_dots_348* = 0x0100288C
  KEY_braille_dots_1348* = 0x0100288D
  KEY_braille_dots_2348* = 0x0100288E
  KEY_braille_dots_12348* = 0x0100288F
  KEY_braille_dots_58* = 0x01002890
  KEY_braille_dots_158* = 0x01002891
  KEY_braille_dots_258* = 0x01002892
  KEY_braille_dots_1258* = 0x01002893
  KEY_braille_dots_358* = 0x01002894
  KEY_braille_dots_1358* = 0x01002895
  KEY_braille_dots_2358* = 0x01002896
  KEY_braille_dots_12358* = 0x01002897
  KEY_braille_dots_458* = 0x01002898
  KEY_braille_dots_1458* = 0x01002899
  KEY_braille_dots_2458* = 0x0100289A
  KEY_braille_dots_12458* = 0x0100289B
  KEY_braille_dots_3458* = 0x0100289C
  KEY_braille_dots_13458* = 0x0100289D
  KEY_braille_dots_23458* = 0x0100289E
  KEY_braille_dots_123458* = 0x0100289F
  KEY_braille_dots_68* = 0x010028A0
  KEY_braille_dots_168* = 0x010028A1
  KEY_braille_dots_268* = 0x010028A2
  KEY_braille_dots_1268* = 0x010028A3
  KEY_braille_dots_368* = 0x010028A4
  KEY_braille_dots_1368* = 0x010028A5
  KEY_braille_dots_2368* = 0x010028A6
  KEY_braille_dots_12368* = 0x010028A7
  KEY_braille_dots_468* = 0x010028A8
  KEY_braille_dots_1468* = 0x010028A9
  KEY_braille_dots_2468* = 0x010028AA
  KEY_braille_dots_12468* = 0x010028AB
  KEY_braille_dots_3468* = 0x010028AC
  KEY_braille_dots_13468* = 0x010028AD
  KEY_braille_dots_23468* = 0x010028AE
  KEY_braille_dots_123468* = 0x010028AF
  KEY_braille_dots_568* = 0x010028B0
  KEY_braille_dots_1568* = 0x010028B1
  KEY_braille_dots_2568* = 0x010028B2
  KEY_braille_dots_12568* = 0x010028B3
  KEY_braille_dots_3568* = 0x010028B4
  KEY_braille_dots_13568* = 0x010028B5
  KEY_braille_dots_23568* = 0x010028B6
  KEY_braille_dots_123568* = 0x010028B7
  KEY_braille_dots_4568* = 0x010028B8
  KEY_braille_dots_14568* = 0x010028B9
  KEY_braille_dots_24568* = 0x010028BA
  KEY_braille_dots_124568* = 0x010028BB
  KEY_braille_dots_34568* = 0x010028BC
  KEY_braille_dots_134568* = 0x010028BD
  KEY_braille_dots_234568* = 0x010028BE
  KEY_braille_dots_1234568* = 0x010028BF
  KEY_braille_dots_78* = 0x010028C0
  KEY_braille_dots_178* = 0x010028C1
  KEY_braille_dots_278* = 0x010028C2
  KEY_braille_dots_1278* = 0x010028C3
  KEY_braille_dots_378* = 0x010028C4
  KEY_braille_dots_1378* = 0x010028C5
  KEY_braille_dots_2378* = 0x010028C6
  KEY_braille_dots_12378* = 0x010028C7
  KEY_braille_dots_478* = 0x010028C8
  KEY_braille_dots_1478* = 0x010028C9
  KEY_braille_dots_2478* = 0x010028CA
  KEY_braille_dots_12478* = 0x010028CB
  KEY_braille_dots_3478* = 0x010028CC
  KEY_braille_dots_13478* = 0x010028CD
  KEY_braille_dots_23478* = 0x010028CE
  KEY_braille_dots_123478* = 0x010028CF
  KEY_braille_dots_578* = 0x010028D0
  KEY_braille_dots_1578* = 0x010028D1
  KEY_braille_dots_2578* = 0x010028D2
  KEY_braille_dots_12578* = 0x010028D3
  KEY_braille_dots_3578* = 0x010028D4
  KEY_braille_dots_13578* = 0x010028D5
  KEY_braille_dots_23578* = 0x010028D6
  KEY_braille_dots_123578* = 0x010028D7
  KEY_braille_dots_4578* = 0x010028D8
  KEY_braille_dots_14578* = 0x010028D9
  KEY_braille_dots_24578* = 0x010028DA
  KEY_braille_dots_124578* = 0x010028DB
  KEY_braille_dots_34578* = 0x010028DC
  KEY_braille_dots_134578* = 0x010028DD
  KEY_braille_dots_234578* = 0x010028DE
  KEY_braille_dots_1234578* = 0x010028DF
  KEY_braille_dots_678* = 0x010028E0
  KEY_braille_dots_1678* = 0x010028E1
  KEY_braille_dots_2678* = 0x010028E2
  KEY_braille_dots_12678* = 0x010028E3
  KEY_braille_dots_3678* = 0x010028E4
  KEY_braille_dots_13678* = 0x010028E5
  KEY_braille_dots_23678* = 0x010028E6
  KEY_braille_dots_123678* = 0x010028E7
  KEY_braille_dots_4678* = 0x010028E8
  KEY_braille_dots_14678* = 0x010028E9
  KEY_braille_dots_24678* = 0x010028EA
  KEY_braille_dots_124678* = 0x010028EB
  KEY_braille_dots_34678* = 0x010028EC
  KEY_braille_dots_134678* = 0x010028ED
  KEY_braille_dots_234678* = 0x010028EE
  KEY_braille_dots_1234678* = 0x010028EF
  KEY_braille_dots_5678* = 0x010028F0
  KEY_braille_dots_15678* = 0x010028F1
  KEY_braille_dots_25678* = 0x010028F2
  KEY_braille_dots_125678* = 0x010028F3
  KEY_braille_dots_35678* = 0x010028F4
  KEY_braille_dots_135678* = 0x010028F5
  KEY_braille_dots_235678* = 0x010028F6
  KEY_braille_dots_1235678* = 0x010028F7
  KEY_braille_dots_45678* = 0x010028F8
  KEY_braille_dots_145678* = 0x010028F9
  KEY_braille_dots_245678* = 0x010028FA
  KEY_braille_dots_1245678* = 0x010028FB
  KEY_braille_dots_345678* = 0x010028FC
  KEY_braille_dots_1345678* = 0x010028FD
  KEY_braille_dots_2345678* = 0x010028FE
  KEY_braille_dots_12345678* = 0x010028FF
  KEY_Sinh_ng* = 0x01000D82
  KEY_Sinh_h2* = 0x01000D83
  KEY_Sinh_a* = 0x01000D85
  KEY_Sinh_aa* = 0x01000D86
  KEY_Sinh_ae* = 0x01000D87
  KEY_Sinh_aee* = 0x01000D88
  KEY_Sinh_i* = 0x01000D89
  KEY_Sinh_ii* = 0x01000D8A
  KEY_Sinh_u* = 0x01000D8B
  KEY_Sinh_uu* = 0x01000D8C
  KEY_Sinh_ri* = 0x01000D8D
  KEY_Sinh_rii* = 0x01000D8E
  KEY_Sinh_lu* = 0x01000D8F
  KEY_Sinh_luu* = 0x01000D90
  KEY_Sinh_e* = 0x01000D91
  KEY_Sinh_ee* = 0x01000D92
  KEY_Sinh_ai* = 0x01000D93
  KEY_Sinh_o* = 0x01000D94
  KEY_Sinh_oo* = 0x01000D95
  KEY_Sinh_au* = 0x01000D96
  KEY_Sinh_ka* = 0x01000D9A
  KEY_Sinh_kha* = 0x01000D9B
  KEY_Sinh_ga* = 0x01000D9C
  KEY_Sinh_gha* = 0x01000D9D
  KEY_Sinh_ng2* = 0x01000D9E
  KEY_Sinh_nga* = 0x01000D9F
  KEY_Sinh_ca* = 0x01000DA0
  KEY_Sinh_cha* = 0x01000DA1
  KEY_Sinh_ja* = 0x01000DA2
  KEY_Sinh_jha* = 0x01000DA3
  KEY_Sinh_nya* = 0x01000DA4
  KEY_Sinh_jnya* = 0x01000DA5
  KEY_Sinh_nja* = 0x01000DA6
  KEY_Sinh_tta* = 0x01000DA7
  KEY_Sinh_ttha* = 0x01000DA8
  KEY_Sinh_dda* = 0x01000DA9
  KEY_Sinh_ddha* = 0x01000DAA
  KEY_Sinh_nna* = 0x01000DAB
  KEY_Sinh_ndda* = 0x01000DAC
  KEY_Sinh_tha* = 0x01000DAD
  KEY_Sinh_thha* = 0x01000DAE
  KEY_Sinh_dha* = 0x01000DAF
  KEY_Sinh_dhha* = 0x01000DB0
  KEY_Sinh_na* = 0x01000DB1
  KEY_Sinh_ndha* = 0x01000DB3
  KEY_Sinh_pa* = 0x01000DB4
  KEY_Sinh_pha* = 0x01000DB5
  KEY_Sinh_ba* = 0x01000DB6
  KEY_Sinh_bha* = 0x01000DB7
  KEY_Sinh_ma* = 0x01000DB8
  KEY_Sinh_mba* = 0x01000DB9
  KEY_Sinh_ya* = 0x01000DBA
  KEY_Sinh_ra* = 0x01000DBB
  KEY_Sinh_la* = 0x01000DBD
  KEY_Sinh_va* = 0x01000DC0
  KEY_Sinh_sha* = 0x01000DC1
  KEY_Sinh_ssha* = 0x01000DC2
  KEY_Sinh_sa* = 0x01000DC3
  KEY_Sinh_ha* = 0x01000DC4
  KEY_Sinh_lla* = 0x01000DC5
  KEY_Sinh_fa* = 0x01000DC6
  KEY_Sinh_al* = 0x01000DCA
  KEY_Sinh_aa2* = 0x01000DCF
  KEY_Sinh_ae2* = 0x01000DD0
  KEY_Sinh_aee2* = 0x01000DD1
  KEY_Sinh_i2* = 0x01000DD2
  KEY_Sinh_ii2* = 0x01000DD3
  KEY_Sinh_u2* = 0x01000DD4
  KEY_Sinh_uu2* = 0x01000DD6
  KEY_Sinh_ru2* = 0x01000DD8
  KEY_Sinh_e2* = 0x01000DD9
  KEY_Sinh_ee2* = 0x01000DDA
  KEY_Sinh_ai2* = 0x01000DDB
  KEY_Sinh_o2* = 0x01000DDC
  KEY_Sinh_oo2* = 0x01000DDD
  KEY_Sinh_au2* = 0x01000DDE
  KEY_Sinh_lu2* = 0x01000DDF
  KEY_Sinh_ruu2* = 0x01000DF2
  KEY_Sinh_luu2* = 0x01000DF3
  KEY_Sinh_kunddaliya* = 0x01000DF4
  KEY_ModeLock* = 0x1008FF01
  KEY_MonBrightnessUp* = 0x1008FF02
  KEY_MonBrightnessDown* = 0x1008FF03
  KEY_KbdLightOnOff* = 0x1008FF04
  KEY_KbdBrightnessUp* = 0x1008FF05
  KEY_KbdBrightnessDown* = 0x1008FF06
  KEY_Standby* = 0x1008FF10
  KEY_AudioLowerVolume* = 0x1008FF11
  KEY_AudioMute* = 0x1008FF12
  KEY_AudioRaiseVolume* = 0x1008FF13
  KEY_AudioPlay* = 0x1008FF14
  KEY_AudioStop* = 0x1008FF15
  KEY_AudioPrev* = 0x1008FF16
  KEY_AudioNext* = 0x1008FF17
  KEY_HomePage* = 0x1008FF18
  KEY_Mail* = 0x1008FF19
  KEY_Start* = 0x1008FF1A
  KEY_Search* = 0x1008FF1B
  KEY_AudioRecord* = 0x1008FF1C
  KEY_Calculator* = 0x1008FF1D
  KEY_Memo* = 0x1008FF1E
  KEY_ToDoList* = 0x1008FF1F
  KEY_Calendar* = 0x1008FF20
  KEY_PowerDown* = 0x1008FF21
  KEY_ContrastAdjust* = 0x1008FF22
  KEY_RockerUp* = 0x1008FF23
  KEY_RockerDown* = 0x1008FF24
  KEY_RockerEnter* = 0x1008FF25
  KEY_Back* = 0x1008FF26
  KEY_Forward* = 0x1008FF27
  KEY_Stop* = 0x1008FF28
  KEY_Refresh* = 0x1008FF29
  KEY_PowerOff* = 0x1008FF2A
  KEY_WakeUp* = 0x1008FF2B
  KEY_Eject* = 0x1008FF2C
  KEY_ScreenSaver* = 0x1008FF2D
  KEY_WWW* = 0x1008FF2E
  KEY_Sleep* = 0x1008FF2F
  KEY_Favorites* = 0x1008FF30
  KEY_AudioPause* = 0x1008FF31
  KEY_AudioMedia* = 0x1008FF32
  KEY_MyComputer* = 0x1008FF33
  KEY_VendorHome* = 0x1008FF34
  KEY_LightBulb* = 0x1008FF35
  KEY_Shop* = 0x1008FF36
  KEY_History* = 0x1008FF37
  KEY_OpenURL* = 0x1008FF38
  KEY_AddFavorite* = 0x1008FF39
  KEY_HotLinks* = 0x1008FF3A
  KEY_BrightnessAdjust* = 0x1008FF3B
  KEY_Finance* = 0x1008FF3C
  KEY_Community* = 0x1008FF3D
  KEY_AudioRewind* = 0x1008FF3E
  KEY_BackForward* = 0x1008FF3F
  KEY_Launch0* = 0x1008FF40
  KEY_Launch1* = 0x1008FF41
  KEY_Launch2* = 0x1008FF42
  KEY_Launch3* = 0x1008FF43
  KEY_Launch4* = 0x1008FF44
  KEY_Launch5* = 0x1008FF45
  KEY_Launch6* = 0x1008FF46
  KEY_Launch7* = 0x1008FF47
  KEY_Launch8* = 0x1008FF48
  KEY_Launch9* = 0x1008FF49
  KEY_LaunchA* = 0x1008FF4A
  KEY_LaunchB* = 0x1008FF4B
  KEY_LaunchC* = 0x1008FF4C
  KEY_LaunchD* = 0x1008FF4D
  KEY_LaunchE* = 0x1008FF4E
  KEY_LaunchF* = 0x1008FF4F
  KEY_ApplicationLeft* = 0x1008FF50
  KEY_ApplicationRight* = 0x1008FF51
  KEY_Book* = 0x1008FF52
  KEY_CD* = 0x1008FF53
  KEY_WindowClear* = 0x1008FF55
  KEY_Close* = 0x1008FF56
  KEY_Copy* = 0x1008FF57
  KEY_Cut* = 0x1008FF58
  KEY_Display* = 0x1008FF59
  KEY_DOS* = 0x1008FF5A
  KEY_Documents* = 0x1008FF5B
  KEY_Excel* = 0x1008FF5C
  KEY_Explorer* = 0x1008FF5D
  KEY_Game* = 0x1008FF5E
  KEY_Go* = 0x1008FF5F
  KEY_iTouch* = 0x1008FF60
  KEY_LogOff* = 0x1008FF61
  KEY_Market* = 0x1008FF62
  KEY_Meeting* = 0x1008FF63
  KEY_MenuKB* = 0x1008FF65
  KEY_MenuPB* = 0x1008FF66
  KEY_MySites* = 0x1008FF67
  KEY_New* = 0x1008FF68
  KEY_News* = 0x1008FF69
  KEY_OfficeHome* = 0x1008FF6A
  KEY_Open* = 0x1008FF6B
  KEY_Option* = 0x1008FF6C
  KEY_Paste* = 0x1008FF6D
  KEY_Phone* = 0x1008FF6E
  KEY_Reply* = 0x1008FF72
  KEY_Reload* = 0x1008FF73
  KEY_RotateWindows* = 0x1008FF74
  KEY_RotationPB* = 0x1008FF75
  KEY_RotationKB* = 0x1008FF76
  KEY_Save* = 0x1008FF77
  KEY_ScrollUp* = 0x1008FF78
  KEY_ScrollDown* = 0x1008FF79
  KEY_ScrollClick* = 0x1008FF7A
  KEY_Send* = 0x1008FF7B
  KEY_Spell* = 0x1008FF7C
  KEY_SplitScreen* = 0x1008FF7D
  KEY_Support* = 0x1008FF7E
  KEY_TaskPane* = 0x1008FF7F
  KEY_Terminal* = 0x1008FF80
  KEY_Tools* = 0x1008FF81
  KEY_Travel* = 0x1008FF82
  KEY_UserPB* = 0x1008FF84
  KEY_User1KB* = 0x1008FF85
  KEY_User2KB* = 0x1008FF86
  KEY_Video* = 0x1008FF87
  KEY_WheelButton* = 0x1008FF88
  KEY_Word* = 0x1008FF89
  KEY_Xfer* = 0x1008FF8A
  KEY_ZoomIn* = 0x1008FF8B
  KEY_ZoomOut* = 0x1008FF8C
  KEY_Away* = 0x1008FF8D
  KEY_Messenger* = 0x1008FF8E
  KEY_WebCam* = 0x1008FF8F
  KEY_MailForward* = 0x1008FF90
  KEY_Pictures* = 0x1008FF91
  KEY_Music* = 0x1008FF92
  KEY_Battery* = 0x1008FF93
  KEY_Bluetooth* = 0x1008FF94
  KEY_WLAN* = 0x1008FF95
  KEY_UWB* = 0x1008FF96
  KEY_AudioForward* = 0x1008FF97
  KEY_AudioRepeat* = 0x1008FF98
  KEY_AudioRandomPlay* = 0x1008FF99
  KEY_Subtitle* = 0x1008FF9A
  KEY_AudioCycleTrack* = 0x1008FF9B
  KEY_CycleAngle* = 0x1008FF9C
  KEY_FrameBack* = 0x1008FF9D
  KEY_FrameForward* = 0x1008FF9E
  KEY_Time* = 0x1008FF9F
  KEY_SelectButton* = 0x1008FFA0
  KEY_View* = 0x1008FFA1
  KEY_TopMenu* = 0x1008FFA2
  KEY_Red* = 0x1008FFA3
  KEY_Green* = 0x1008FFA4
  KEY_Yellow* = 0x1008FFA5
  KEY_Blue* = 0x1008FFA6
  KEY_Suspend* = 0x1008FFA7
  KEY_Hibernate* = 0x1008FFA8
  KEY_TouchpadToggle* = 0x1008FFA9
  KEY_TouchpadOn* = 0x1008FFB0
  KEY_TouchpadOff* = 0x1008FFB1
  KEY_AudioMicMute* = 0x1008FFB2
  KEY_Switch_VT_1* = 0x1008FE01
  KEY_Switch_VT_2* = 0x1008FE02
  KEY_Switch_VT_3* = 0x1008FE03
  KEY_Switch_VT_4* = 0x1008FE04
  KEY_Switch_VT_5* = 0x1008FE05
  KEY_Switch_VT_6* = 0x1008FE06
  KEY_Switch_VT_7* = 0x1008FE07
  KEY_Switch_VT_8* = 0x1008FE08
  KEY_Switch_VT_9* = 0x1008FE09
  KEY_Switch_VT_10* = 0x1008FE0A
  KEY_Switch_VT_11* = 0x1008FE0B
  KEY_Switch_VT_12* = 0x1008FE0C
  KEY_Ungrab* = 0x1008FE20
  KEY_ClearGrab* = 0x1008FE21
  KEY_Next_VMode* = 0x1008FE22
  KEY_Prev_VMode* = 0x1008FE23
  KEY_LogWindowTree* = 0x1008FE24
  KEY_LogGrabInfo* = 0x1008FE25

when defined(ENABLE_NLS): 
  template P_UNDERSCORE*(String: expr): expr = 
    dgettext(GETTEXT_PACKAGE, "-properties", String)

else: 
  template P_UNDERSCORE*(String: expr): expr = 
    (String)


const 
  CURRENT_TIME* = 0
const 
  PARENT_RELATIVE* = 1
type 
  PRectangle* = ptr TRectangle
  TRectangle* = Tcairo_rectangle_int_t
type 
  PGdkAtom* = ptr TGdkAtom
  TGdkAtom* = ptr object
template ATOM_TO_POINTER*(atom: expr): expr = 
  (atom)

template POINTER_TO_ATOM*(val: expr): expr = 
  (cast[TGdkAtom](val))

template MAKE_ATOM*(val: expr): expr = 
  (cast[TGdkAtom](GUINT_TO_POINTER(val)))

template NONE*(): expr = 
  MAKE_ATOM(0)

type 
  TByteOrder* {.size: sizeof(cint).} = enum 
    LSB_FIRST, MSB_FIRST
type 
  PModifierType* = ptr TModifierType 
  TModifierType* {.size: sizeof(cint).} = enum 
    SHIFT_MASK = 1 shl 0, LOCK_MASK = 1 shl 1, 
    CONTROL_MASK = 1 shl 2, MOD1_MASK = 1 shl 3, 
    MOD2_MASK = 1 shl 4, MOD3_MASK = 1 shl 5, MOD4_MASK = 1 shl
        6, MOD5_MASK = 1 shl 7, BUTTON1_MASK = 1 shl 8, 
    BUTTON2_MASK = 1 shl 9, BUTTON3_MASK = 1 shl 10, 
    BUTTON4_MASK = 1 shl 11, BUTTON5_MASK = 1 shl 12, 
    MODIFIER_RESERVED_13_MASK = 1 shl 13, 
    MODIFIER_RESERVED_14_MASK = 1 shl 14, 
    MODIFIER_RESERVED_15_MASK = 1 shl 15, 
    MODIFIER_RESERVED_16_MASK = 1 shl 16, 
    MODIFIER_RESERVED_17_MASK = 1 shl 17, 
    MODIFIER_RESERVED_18_MASK = 1 shl 18, 
    MODIFIER_RESERVED_19_MASK = 1 shl 19, 
    MODIFIER_RESERVED_20_MASK = 1 shl 20, 
    MODIFIER_RESERVED_21_MASK = 1 shl 21, 
    MODIFIER_RESERVED_22_MASK = 1 shl 22, 
    MODIFIER_RESERVED_23_MASK = 1 shl 23, 
    MODIFIER_RESERVED_24_MASK = 1 shl 24, 
    MODIFIER_RESERVED_25_MASK = 1 shl 25, SUPER_MASK = 1 shl 26, 
    HYPER_MASK = 1 shl 27, META_MASK = 1 shl 28, 
    MODIFIER_RESERVED_29_MASK = 1 shl 29, RELEASE_MASK = 1 shl 30, 
    MODIFIER_MASK = 0x5C001FFF
type 
  TModifierIntent* {.size: sizeof(cint).} = enum 
    MODIFIER_INTENT_PRIMARY_ACCELERATOR, MODIFIER_INTENT_CONTEXT_MENU, 
    MODIFIER_INTENT_EXTEND_SELECTION, 
    MODIFIER_INTENT_MODIFY_SELECTION, MODIFIER_INTENT_NO_TEXT_INPUT, 
    MODIFIER_INTENT_SHIFT_GROUP
  TStatus* {.size: sizeof(cint).} = enum 
    ERROR_MEM = - 4, ERROR_FILE = - 3, ERROR_PARAM = - 2, ERROR = - 1, OK = 0
type 
  TGrabStatus* {.size: sizeof(cint).} = enum 
    GRAB_SUCCESS = 0, GRAB_ALREADY_GRABBED = 1, 
    GRAB_INVALID_TIME = 2, GRAB_NOT_VIEWABLE = 3, GRAB_FROZEN = 4
type 
  TGrabOwnership* {.size: sizeof(cint).} = enum 
    OWNERSHIP_NONE, OWNERSHIP_WINDOW, OWNERSHIP_APPLICATION
type
  PEventMask* = ptr TEventMask
  TEventMask* {.size: sizeof(cint).} = enum 
    EXPOSURE_MASK = 1 shl 1, POINTER_MOTION_MASK = 1 shl 2, 
    POINTER_MOTION_HINT_MASK = 1 shl 3, BUTTON_MOTION_MASK = 1 shl
        4, BUTTON1_MOTION_MASK = 1 shl 5, 
    BUTTON2_MOTION_MASK = 1 shl 6, BUTTON3_MOTION_MASK = 1 shl 7, 
    BUTTON_PRESS_MASK = 1 shl 8, BUTTON_RELEASE_MASK = 1 shl 9, 
    KEY_PRESS_MASK = 1 shl 10, KEY_RELEASE_MASK = 1 shl 11, 
    ENTER_NOTIFY_MASK = 1 shl 12, LEAVE_NOTIFY_MASK = 1 shl 13, 
    FOCUS_CHANGE_MASK = 1 shl 14, STRUCTURE_MASK = 1 shl 15, 
    PROPERTY_CHANGE_MASK = 1 shl 16, 
    VISIBILITY_NOTIFY_MASK = 1 shl 17, PROXIMITY_IN_MASK = 1 shl 18, 
    PROXIMITY_OUT_MASK = 1 shl 19, SUBSTRUCTURE_MASK = 1 shl 20, 
    SCROLL_MASK = 1 shl 21, TOUCH_MASK = 1 shl 22, 
    SMOOTH_SCROLL_MASK = 1 shl 23, ALL_EVENTS_MASK = 0x00FFFFFE
type 
  PPoint* = ptr TPoint
  TPoint*{.final, pure.} = object 
    x*: gint
    y*: gint


type 
  PColor* = ptr TColor
  TColor*{.final, pure.} = object 
    pixel*: guint32
    red*: guint16
    green*: guint16
    blue*: guint16

template TYPE_COLOR*(): expr = 
  (gdk_color_get_type())

proc color_get_type*(): GType {.cdecl, importc: "gdk_color_get_type", 
                                    dynlib: lib.}
proc copy*(color: PColor): PColor {.cdecl, 
    importc: "gdk_color_copy", dynlib: lib.}
proc free*(color: PColor) {.cdecl, importc: "gdk_color_free", 
    dynlib: lib.}
proc hash*(color: PColor): guint {.cdecl, 
    importc: "gdk_color_hash", dynlib: lib.}
proc equal*(colora: PColor; colorb: PColor): gboolean {.
    cdecl, importc: "gdk_color_equal", dynlib: lib.}
proc color_parse*(spec: CSTRING; color: PColor): gboolean {.cdecl, 
    importc: "gdk_color_parse", dynlib: lib.}
proc to_string*(color: PColor): CSTRING {.cdecl, 
    importc: "gdk_color_to_string", dynlib: lib.}

type 
  P_cairo_region_t* = ptr T_cairo_region_t
  T_cairo_region_t*{.final, pure.} = object 
  
type 
  P_cairo_t* = ptr T_cairo_t
  T_cairo_t*{.final, pure.} = object 
  
type 
  PBroadwayOutput* = ptr TBroadwayOutput
  TBroadwayOutput*{.final, pure.} = object 
  
type 
  PBroadwayServer* = ptr TBroadwayServer
  TBroadwayServer*{.final, pure.} = object 
  
type 
  PGdkBroadwayServer* = ptr TGdkBroadwayServer
  TGdkBroadwayServer*{.final, pure.} = object 
  
type 
  PBroadwayBuffer* = ptr TBroadwayBuffer
  TBroadwayBuffer*{.final, pure.} = object 
  
type 
  PGOutputStream* = ptr TGOutputStream
  TGOutputStream* = object of TGObject 
  
type 
  PGOptionGroup* = ptr TGOptionGroup
  TGOptionGroup*{.final, pure.} = object 
  
type 
  PKeymap* = ptr TKeymap
  TKeymap* = object of TGObject 
  
type 
  PFrameClock* = ptr TFrameClock
  TFrameClock* = object of TGObject 
  
type 
  PFrameTimings* = ptr TFrameTimings
  TFrameTimings*{.final, pure.} = object 
  
type 
  PGdkDisplayManagerClass* = ptr TGdkDisplayManagerClass
  TGdkDisplayManagerClass* = object of TGObjectClass 
  
type 
  PGdkDisplayManager* = ptr TGdkDisplayManager
  TGdkDisplayManager*{.final, pure.} = object 
  
type 
  PDeviceManager* = ptr TDeviceManager
  TDeviceManager* = object of TGObject 
  
type 
  PEventSequence* = ptr TEventSequence
  TEventSequence*{.final, pure.} = object 
  
type 
  PAppLaunchContext* = ptr TAppLaunchContext
  TAppLaunchContext* = object of TGObject 
  
type 
  PDragContext* = ptr TDragContext
  TDragContext* = object of TGObject 
  
type 
  PGdkCursor* = ptr TGdkCursor
  TGdkCursor* = object of TGObject 
  
type 
  PGdkVisual* = ptr TGdkVisual
  TGdkVisual* = object of TGObject 
  
type 
  PGdkDisplay* = ptr TGdkDisplay
  TGdkDisplay* = object of TGObject 
  
type 
  PGdkScreen* = ptr TGdkScreen
  TGdkScreen* = object of TGObject 
  
type 
  PGdkWindow* = ptr TGdkWindow
  TGdkWindow* = object of TGObject 
  
type 
  PDevice* = ptr TDevice
  TDevice*{.final, pure.} = object 
  
template TYPE_DEVICE*(): expr = 
  (gdk_device_get_type())

template DEVICE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_DEVICE, TDevice))

template IS_DEVICE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_DEVICE))

type 
  TInputSource* {.size: sizeof(cint).} = enum 
    SOURCE_MOUSE, SOURCE_PEN, SOURCE_ERASER, SOURCE_CURSOR, 
    SOURCE_KEYBOARD, SOURCE_TOUCHSCREEN, SOURCE_TOUCHPAD
type 
  TInputMode* {.size: sizeof(cint).} = enum 
    MODE_DISABLED, MODE_SCREEN, MODE_WINDOW
type 
  TAxisUse* {.size: sizeof(cint).} = enum 
    AXIS_IGNORE, AXIS_X, AXIS_Y, AXIS_PRESSURE, 
    AXIS_XTILT, AXIS_YTILT, AXIS_WHEEL, AXIS_LAST
type 
  TDeviceType* {.size: sizeof(cint).} = enum 
    DEVICE_TYPE_MASTER, DEVICE_TYPE_SLAVE, DEVICE_TYPE_FLOATING
const 
  MAX_TIMECOORD_AXES* = 128
type 
  PTimeCoord* = ptr TTimeCoord
  TTimeCoord*{.final, pure.} = object 
    time*: guint32
    axes*: array[MAX_TIMECOORD_AXES, gdouble]

proc device_get_type*(): GType {.cdecl, importc: "gdk_device_get_type", 
                                     dynlib: lib.}
proc get_name*(device: PDevice): CSTRING {.cdecl, 
    importc: "gdk_device_get_name", dynlib: lib.}
proc get_has_cursor*(device: PDevice): gboolean {.cdecl, 
    importc: "gdk_device_get_has_cursor", dynlib: lib.}
proc get_source*(device: PDevice): TInputSource {.cdecl, 
    importc: "gdk_device_get_source", dynlib: lib.}
proc get_mode*(device: PDevice): TInputMode {.cdecl, 
    importc: "gdk_device_get_mode", dynlib: lib.}
proc set_mode*(device: PDevice; mode: TInputMode): gboolean {.
    cdecl, importc: "gdk_device_set_mode", dynlib: lib.}
proc get_n_keys*(device: PDevice): gint {.cdecl, 
    importc: "gdk_device_get_n_keys", dynlib: lib.}
proc get_key*(device: PDevice; index: guint; 
                         keyval: Pguint; modifiers: PModifierType): gboolean {.
    cdecl, importc: "gdk_device_get_key", dynlib: lib.}
proc set_key*(device: PDevice; index: guint; keyval: guint; 
                         modifiers: TModifierType) {.cdecl, 
    importc: "gdk_device_set_key", dynlib: lib.}
proc get_axis_use*(device: PDevice; index: guint): TAxisUse {.
    cdecl, importc: "gdk_device_get_axis_use", dynlib: lib.}
proc set_axis_use*(device: PDevice; index: guint; 
                              use: TAxisUse) {.cdecl, 
    importc: "gdk_device_set_axis_use", dynlib: lib.}
proc get_state*(device: PDevice; window: PGdkWindow; 
                           axes: Pgdouble; mask: PModifierType) {.
    cdecl, importc: "gdk_device_get_state", dynlib: lib.}
proc get_position*(device: PDevice; 
                              screen: ptr PGdkScreen; x: Pgint; 
                              y: Pgint) {.cdecl, 
    importc: "gdk_device_get_position", dynlib: lib.}
proc get_window_at_position*(device: PDevice; 
    win_x: Pgint; win_y: Pgint): PGdkWindow {.cdecl, 
    importc: "gdk_device_get_window_at_position", dynlib: lib.}
proc get_position_double*(device: PDevice; 
                                     screen: ptr PGdkScreen; 
                                     x: Pgdouble; y: Pgdouble) {.cdecl, 
    importc: "gdk_device_get_position_double", dynlib: lib.}
proc get_window_at_position_double*(device: PDevice; 
    win_x: Pgdouble; win_y: Pgdouble): PGdkWindow {.cdecl, 
    importc: "gdk_device_get_window_at_position_double", dynlib: lib.}
proc get_history*(device: PDevice; window: PGdkWindow; 
                             start: guint32; stop: guint32; 
                             events: ptr ptr PTimeCoord; 
                             n_events: Pgint): gboolean {.cdecl, 
    importc: "gdk_device_get_history", dynlib: lib.}
proc device_free_history*(events: ptr PTimeCoord; n_events: gint) {.
    cdecl, importc: "gdk_device_free_history", dynlib: lib.}
proc get_n_axes*(device: PDevice): gint {.cdecl, 
    importc: "gdk_device_get_n_axes", dynlib: lib.}
proc list_axes*(device: PDevice): PGList {.cdecl, 
    importc: "gdk_device_list_axes", dynlib: lib.}
proc get_axis_value*(device: PDevice; axes: Pgdouble; 
                                axis_label: TGdkAtom; value: Pgdouble): gboolean {.
    cdecl, importc: "gdk_device_get_axis_value", dynlib: lib.}
proc get_axis*(device: PDevice; axes: Pgdouble; 
                          use: TAxisUse; value: Pgdouble): gboolean {.
    cdecl, importc: "gdk_device_get_axis", dynlib: lib.}
proc get_display*(device: PDevice): PGdkDisplay {.cdecl, 
    importc: "gdk_device_get_display", dynlib: lib.}
proc get_associated_device*(device: PDevice): PDevice {.
    cdecl, importc: "gdk_device_get_associated_device", dynlib: lib.}
proc list_slave_devices*(device: PDevice): PGList {.cdecl, 
    importc: "gdk_device_list_slave_devices", dynlib: lib.}
proc get_device_type*(device: PDevice): TDeviceType {.
    cdecl, importc: "gdk_device_get_device_type", dynlib: lib.}
proc grab*(device: PDevice; window: PGdkWindow; 
                      grab_ownership: TGrabOwnership; 
                      owner_events: gboolean; event_mask: TEventMask; 
                      cursor: PGdkCursor; time: guint32): TGrabStatus {.
    cdecl, importc: "gdk_device_grab", dynlib: lib.}
proc ungrab*(device: PDevice; time: guint32) {.cdecl, 
    importc: "gdk_device_ungrab", dynlib: lib.}
proc warp*(device: PDevice; screen: PGdkScreen; x: gint; 
                      y: gint) {.cdecl, importc: "gdk_device_warp", 
                                 dynlib: lib.}
proc device_grab_info_libgtk_only*(display: PGdkDisplay; 
    device: PDevice; grab_window: ptr PGdkWindow; 
    owner_events: Pgboolean): gboolean {.cdecl, 
    importc: "gdk_device_grab_info_libgtk_only", dynlib: lib.}
proc get_last_event_window*(device: PDevice): PGdkWindow {.
    cdecl, importc: "gdk_device_get_last_event_window", dynlib: lib.}

template TYPE_DRAG_CONTEXT*(): expr = 
  (gdk_drag_context_get_type())

template DRAG_CONTEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_DRAG_CONTEXT, TDragContext))

template IS_DRAG_CONTEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_DRAG_CONTEXT))

type 
  TDragAction* {.size: sizeof(cint).} = enum 
    ACTION_DEFAULT = 1 shl 0, ACTION_COPY = 1 shl 1, 
    ACTION_MOVE = 1 shl 2, ACTION_LINK = 1 shl 3, 
    ACTION_PRIVATE = 1 shl 4, ACTION_ASK = 1 shl 5
type
  PDragProtocol* = ptr TDragProtocol
  TDragProtocol* {.size: sizeof(cint).} = enum 
    DRAG_PROTO_NONE = 0, DRAG_PROTO_MOTIF, DRAG_PROTO_XDND, 
    DRAG_PROTO_ROOTWIN, DRAG_PROTO_WIN32_DROPFILES, 
    DRAG_PROTO_OLE2, DRAG_PROTO_LOCAL
proc drag_context_get_type*(): GType {.cdecl, 
    importc: "gdk_drag_context_get_type", dynlib: lib.}
proc set_device*(context: PDragContext; 
                                  device: PDevice) {.cdecl, 
    importc: "gdk_drag_context_set_device", dynlib: lib.}
proc get_device*(context: PDragContext): PDevice {.
    cdecl, importc: "gdk_drag_context_get_device", dynlib: lib.}
proc list_targets*(context: PDragContext): PGList {.
    cdecl, importc: "gdk_drag_context_list_targets", dynlib: lib.}
proc get_actions*(context: PDragContext): TDragAction {.
    cdecl, importc: "gdk_drag_context_get_actions", dynlib: lib.}
proc get_suggested_action*(context: PDragContext): TDragAction {.
    cdecl, importc: "gdk_drag_context_get_suggested_action", dynlib: lib.}
proc get_selected_action*(context: PDragContext): TDragAction {.
    cdecl, importc: "gdk_drag_context_get_selected_action", dynlib: lib.}
proc get_source_window*(context: PDragContext): PGdkWindow {.
    cdecl, importc: "gdk_drag_context_get_source_window", dynlib: lib.}
proc get_dest_window*(context: PDragContext): PGdkWindow {.
    cdecl, importc: "gdk_drag_context_get_dest_window", dynlib: lib.}
proc get_protocol*(context: PDragContext): TDragProtocol {.
    cdecl, importc: "gdk_drag_context_get_protocol", dynlib: lib.}
proc gdk_drag_status*(context: PDragContext; action: TDragAction; 
                      time: guint32) {.cdecl, importc: "gdk_drag_status", 
    dynlib: lib.}
proc drop_reply*(context: PDragContext; accepted: gboolean; 
                     time: guint32) {.cdecl, importc: "gdk_drop_reply", 
    dynlib: lib.}
proc drop_finish*(context: PDragContext; success: gboolean; 
                      time: guint32) {.cdecl, importc: "gdk_drop_finish", 
    dynlib: lib.}
proc drag_get_selection*(context: PDragContext): TGdkAtom {.cdecl, 
    importc: "gdk_drag_get_selection", dynlib: lib.}
proc drag_begin*(window: PGdkWindow; targets: PGList): PDragContext {.
    cdecl, importc: "gdk_drag_begin", dynlib: lib.}
proc drag_begin_for_device*(window: PGdkWindow; device: PDevice; 
                                targets: PGList): PDragContext {.
    cdecl, importc: "gdk_drag_begin_for_device", dynlib: lib.}
proc drag_find_window_for_screen*(context: PDragContext; 
                                      drag_window: PGdkWindow; 
                                      screen: PGdkScreen; x_root: gint; 
                                      y_root: gint; 
                                      dest_window: ptr PGdkWindow; 
                                      protocol: PDragProtocol) {.cdecl, 
    importc: "gdk_drag_find_window_for_screen", dynlib: lib.}
proc gdk_drag_motion*(context: PDragContext; dest_window: PGdkWindow; 
                      protocol: TDragProtocol; x_root: gint; y_root: gint; 
                      suggested_action: TDragAction; 
                      possible_actions: TDragAction; time: guint32): gboolean {.
    cdecl, importc: "gdk_drag_motion", dynlib: lib.}
proc drag_drop*(context: PDragContext; time: guint32) {.cdecl, 
    importc: "gdk_drag_drop", dynlib: lib.}
proc drag_abort*(context: PDragContext; time: guint32) {.cdecl, 
    importc: "gdk_drag_abort", dynlib: lib.}
proc drag_drop_succeeded*(context: PDragContext): gboolean {.cdecl, 
    importc: "gdk_drag_drop_succeeded", dynlib: lib.}

template TYPE_EVENT*(): expr = 
  (gdk_event_get_type())

const 
  PRIORITY_EVENTS* = (G_PRIORITY_DEFAULT)
const 
  PRIORITY_REDRAW* = (G_PRIORITY_HIGH_IDLE + 20)
const 
  EVENT_PROPAGATE* = (FALSE)
const 
  EVENT_STOP* = (TRUE)
const 
  BUTTON_PRIMARY* = (1)
const 
  BUTTON_MIDDLE* = (2)
const 
  BUTTON_SECONDARY* = (3)
type 
  PXEvent* = ptr TXEvent
  TXEvent* = proc () {.cdecl.}
type 
  TFilterReturn* {.size: sizeof(cint).} = enum 
    FILTER_CONTINUE, FILTER_TRANSLATE, FILTER_REMOVE
type 
  TEventType* {.size: sizeof(cint).} = enum 
    NOTHING = - 1, DELETE = 0, DESTROY = 1, EXPOSE = 2, 
    MOTION_NOTIFY = 3, BUTTON_PRESS = 4, BUTTON2_PRESS = 5, 
    BUTTON3_PRESS = 6, 
    BUTTON_RELEASE = 7, 
    KEY_PRESS = 8, KEY_RELEASE = 9, ENTER_NOTIFY = 10, 
    LEAVE_NOTIFY = 11, FOCUS_CHANGE = 12, CONFIGURE = 13, 
    MAP = 14, UNMAP = 15, PROPERTY_NOTIFY = 16, 
    SELECTION_CLEAR = 17, SELECTION_REQUEST = 18, 
    SELECTION_NOTIFY = 19, PROXIMITY_IN = 20, PROXIMITY_OUT = 21, 
    DRAG_ENTER = 22, DRAG_LEAVE = 23, DRAG_MOTION = 24, 
    DRAG_STATUS = 25, DROP_START = 26, DROP_FINISHED = 27, 
    CLIENT_EVENT = 28, VISIBILITY_NOTIFY = 29, SCROLL = 31, 
    WINDOW_STATE = 32, SETTING = 33, OWNER_CHANGE = 34, 
    GRAB_BROKEN = 35, DAMAGE = 36, TOUCH_BEGIN = 37, 
    TOUCH_UPDATE = 38, TOUCH_END = 39, TOUCH_CANCEL = 40, 
    EVENT_LAST
type 
  TVisibilityState* {.size: sizeof(cint).} = enum 
    VISIBILITY_UNOBSCURED, VISIBILITY_PARTIAL, 
    VISIBILITY_FULLY_OBSCURED
type 
  PScrollDirection* = ptr TScrollDirection 
  TScrollDirection* {.size: sizeof(cint).} = enum 
    SCROLL_UP, SCROLL_DOWN, SCROLL_LEFT, SCROLL_RIGHT, 
    SCROLL_SMOOTH
type 
  TNotifyType* {.size: sizeof(cint).} = enum 
    NOTIFY_ANCESTOR = 0, NOTIFY_VIRTUAL = 1, NOTIFY_INFERIOR = 2, 
    NOTIFY_NONLINEAR = 3, NOTIFY_NONLINEAR_VIRTUAL = 4, 
    NOTIFY_UNKNOWN = 5
type 
  TCrossingMode* {.size: sizeof(cint).} = enum 
    CROSSING_NORMAL, CROSSING_GRAB, CROSSING_UNGRAB, 
    CROSSING_GTK_GRAB, CROSSING_GTK_UNGRAB, 
    CROSSING_STATE_CHANGED, CROSSING_TOUCH_BEGIN, 
    CROSSING_TOUCH_END, CROSSING_DEVICE_SWITCH
type 
  TPropertyState* {.size: sizeof(cint).} = enum 
    PROPERTY_NEW_VALUE, PROPERTY_DELETE
type 
  TGdkWindowState* {.size: sizeof(cint).} = enum 
    WINDOW_STATE_WITHDRAWN = 1 shl 0, 
    WINDOW_STATE_ICONIFIED = 1 shl 1, 
    WINDOW_STATE_MAXIMIZED = 1 shl 2, WINDOW_STATE_STICKY = 1 shl 3, 
    WINDOW_STATE_FULLSCREEN = 1 shl 4, WINDOW_STATE_ABOVE = 1 shl 5, 
    WINDOW_STATE_BELOW = 1 shl 6, WINDOW_STATE_FOCUSED = 1 shl 7, 
    WINDOW_STATE_TILED = 1 shl 8
type 
  TSettingAction* {.size: sizeof(cint).} = enum 
    SETTING_ACTION_NEW, SETTING_ACTION_CHANGED, 
    SETTING_ACTION_DELETED
type 
  TOwnerChange* {.size: sizeof(cint).} = enum 
    OWNER_CHANGE_NEW_OWNER, OWNER_CHANGE_DESTROY, 
    OWNER_CHANGE_CLOSE
type 
  PEventAny* = ptr TEventAny
  TEventAny*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8

type 
  PEventExpose* = ptr TEventExpose
  TEventExpose*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    area*: TRectangle
    region*: Pcairo_region_t
    count*: gint

type 
  PEventVisibility* = ptr TEventVisibility
  TEventVisibility*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    state*: TVisibilityState

type 
  PEventMotion* = ptr TEventMotion
  TEventMotion*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    time*: guint32
    x*: gdouble
    y*: gdouble
    axes*: Pgdouble
    state*: guint
    is_hint*: gint16
    device*: PDevice
    x_root*: gdouble
    y_root*: gdouble

type 
  PEventButton* = ptr TEventButton
  TEventButton*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    time*: guint32
    x*: gdouble
    y*: gdouble
    axes*: Pgdouble
    state*: guint
    button*: guint
    device*: PDevice
    x_root*: gdouble
    y_root*: gdouble

type 
  PEventTouch* = ptr TEventTouch
  TEventTouch*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    time*: guint32
    x*: gdouble
    y*: gdouble
    axes*: Pgdouble
    state*: guint
    sequence*: PEventSequence
    emulating_pointer*: gboolean
    device*: PDevice
    x_root*: gdouble
    y_root*: gdouble

type 
  PEventScroll* = ptr TEventScroll
  TEventScroll*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    time*: guint32
    x*: gdouble
    y*: gdouble
    state*: guint
    direction*: TScrollDirection
    device*: PDevice
    x_root*: gdouble
    y_root*: gdouble
    delta_x*: gdouble
    delta_y*: gdouble

type 
  PEventKey* = ptr TEventKey
  TEventKey*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    time*: guint32
    state*: guint
    keyval*: guint
    length*: gint
    string*: CSTRING
    hardware_keycode*: guint16
    group*: guint8
    is_modifier*: guint

type 
  PEventCrossing* = ptr TEventCrossing
  TEventCrossing*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    subwindow*: PGdkWindow
    time*: guint32
    x*: gdouble
    y*: gdouble
    x_root*: gdouble
    y_root*: gdouble
    mode*: TCrossingMode
    detail*: TNotifyType
    focus*: gboolean
    state*: guint

type 
  PEventFocus* = ptr TEventFocus
  TEventFocus*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    inner*: gint16

type 
  PEventConfigure* = ptr TEventConfigure
  TEventConfigure*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    x*: gint
    y*: gint
    width*: gint
    height*: gint

type 
  PEventProperty* = ptr TEventProperty
  TEventProperty*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    atom*: TGdkAtom
    time*: guint32
    state*: guint

type 
  PEventSelection* = ptr TEventSelection
  TEventSelection*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    selection*: TGdkAtom
    target*: TGdkAtom
    property*: TGdkAtom
    time*: guint32
    requestor*: PGdkWindow

type 
  PEventOwnerChange* = ptr TEventOwnerChange
  TEventOwnerChange*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    owner*: PGdkWindow
    reason*: TOwnerChange
    selection*: TGdkAtom
    time*: guint32
    selection_time*: guint32

type 
  PEventProximity* = ptr TEventProximity
  TEventProximity*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    time*: guint32
    device*: PDevice

type 
  PEventSetting* = ptr TEventSetting
  TEventSetting*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    action*: TSettingAction
    name*: cstring

type 
  PEventWindowState* = ptr TEventWindowState
  TEventWindowState*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    changed_mask*: TGdkWindowState
    new_window_state*: TGdkWindowState

type 
  PEventGrabBroken* = ptr TEventGrabBroken
  TEventGrabBroken*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    keyboard*: gboolean
    implicit*: gboolean
    grab_window*: PGdkWindow

type 
  PEventDND* = ptr TEventDND
  TEventDND*{.final, pure.} = object 
    typ*: TEventType
    window*: PGdkWindow
    send_event*: gint8
    context*: PDragContext
    time*: guint32
    x_root*: gshort
    y_root*: gshort

type 
  PEvent* = ptr TEvent
  TEvent* = object  {.union.}
    typ*: TEventType
    any*: TEventAny
    expose*: TEventExpose
    visibility*: TEventVisibility
    motion*: TEventMotion
    button*: TEventButton
    touch*: TEventTouch
    scroll*: TEventScroll
    key*: TEventKey
    crossing*: TEventCrossing
    focus_change*: TEventFocus
    configure*: TEventConfigure
    property*: TEventProperty
    selection*: TEventSelection
    owner_change*: TEventOwnerChange
    proximity*: TEventProximity
    dnd*: TEventDND
    window_state*: TEventWindowState
    setting*: TEventSetting
    grab_broken*: TEventGrabBroken

type 
  TEventFunc* = proc (event: PEvent; data: gpointer) {.cdecl.}
type 
  TFilterFunc* = proc (xevent: PXEvent; event: PEvent; 
                         data: gpointer): TFilterReturn {.cdecl.}
proc event_get_type*(): GType {.cdecl, importc: "gdk_event_get_type", 
                                    dynlib: lib.}
proc events_pending*(): gboolean {.cdecl, importc: "gdk_events_pending", 
    dynlib: lib.}
proc event_get*(): PEvent {.cdecl, importc: "gdk_event_get", 
                                      dynlib: lib.}
proc event_peek*(): PEvent {.cdecl, importc: "gdk_event_peek", 
    dynlib: lib.}
proc put*(event: PEvent) {.cdecl, importc: "gdk_event_put", 
    dynlib: lib.}
proc event_new*(typ: TEventType): PEvent {.cdecl, 
    importc: "gdk_event_new", dynlib: lib.}
proc copy*(event: PEvent): PEvent {.cdecl, 
    importc: "gdk_event_copy", dynlib: lib.}
proc free*(event: PEvent) {.cdecl, importc: "gdk_event_free", 
    dynlib: lib.}
proc get_window*(event: PEvent): PGdkWindow {.cdecl, 
    importc: "gdk_event_get_window", dynlib: lib.}
proc get_time*(event: PEvent): guint32 {.cdecl, 
    importc: "gdk_event_get_time", dynlib: lib.}
proc get_state*(event: PEvent; state: PModifierType): gboolean {.
    cdecl, importc: "gdk_event_get_state", dynlib: lib.}
proc get_coords*(event: PEvent; x_win: Pgdouble; 
                           y_win: Pgdouble): gboolean {.cdecl, 
    importc: "gdk_event_get_coords", dynlib: lib.}
proc get_root_coords*(event: PEvent; x_root: Pgdouble; 
                                y_root: Pgdouble): gboolean {.cdecl, 
    importc: "gdk_event_get_root_coords", dynlib: lib.}
proc get_button*(event: PEvent; button: Pguint): gboolean {.
    cdecl, importc: "gdk_event_get_button", dynlib: lib.}
proc get_click_count*(event: PEvent; click_count: Pguint): gboolean {.
    cdecl, importc: "gdk_event_get_click_count", dynlib: lib.}
proc get_keyval*(event: PEvent; keyval: Pguint): gboolean {.
    cdecl, importc: "gdk_event_get_keyval", dynlib: lib.}
proc get_keycode*(event: PEvent; keycode: Pguint16): gboolean {.
    cdecl, importc: "gdk_event_get_keycode", dynlib: lib.}
proc get_scroll_direction*(event: PEvent; 
                                     direction: PScrollDirection): gboolean {.
    cdecl, importc: "gdk_event_get_scroll_direction", dynlib: lib.}
proc get_scroll_deltas*(event: PEvent; delta_x: Pgdouble; 
                                  delta_y: Pgdouble): gboolean {.cdecl, 
    importc: "gdk_event_get_scroll_deltas", dynlib: lib.}
proc get_axis*(event: PEvent; axis_use: TAxisUse; 
                         value: Pgdouble): gboolean {.cdecl, 
    importc: "gdk_event_get_axis", dynlib: lib.}
proc set_device*(event: PEvent; device: PDevice) {.
    cdecl, importc: "gdk_event_set_device", dynlib: lib.}
proc get_device*(event: PEvent): PDevice {.cdecl, 
    importc: "gdk_event_get_device", dynlib: lib.}
proc set_source_device*(event: PEvent; device: PDevice) {.
    cdecl, importc: "gdk_event_set_source_device", dynlib: lib.}
proc get_source_device*(event: PEvent): PDevice {.cdecl, 
    importc: "gdk_event_get_source_device", dynlib: lib.}
proc request_motions*(event: PEventMotion) {.cdecl, 
    importc: "gdk_event_request_motions", dynlib: lib.}
proc triggers_context_menu*(event: PEvent): gboolean {.cdecl, 
    importc: "gdk_event_triggers_context_menu", dynlib: lib.}
proc events_get_distance*(event1: PEvent; event2: PEvent; 
                              distance: Pgdouble): gboolean {.cdecl, 
    importc: "gdk_events_get_distance", dynlib: lib.}
proc events_get_angle*(event1: PEvent; event2: PEvent; 
                           angle: Pgdouble): gboolean {.cdecl, 
    importc: "gdk_events_get_angle", dynlib: lib.}
proc events_get_center*(event1: PEvent; event2: PEvent; 
                            x: Pgdouble; y: Pgdouble): gboolean {.cdecl, 
    importc: "gdk_events_get_center", dynlib: lib.}
proc event_handler_set*(func: TEventFunc; data: gpointer; 
                            notify: TGDestroyNotify) {.cdecl, 
    importc: "gdk_event_handler_set", dynlib: lib.}
proc set_screen*(event: PEvent; screen: PGdkScreen) {.
    cdecl, importc: "gdk_event_set_screen", dynlib: lib.}
proc get_screen*(event: PEvent): PGdkScreen {.cdecl, 
    importc: "gdk_event_get_screen", dynlib: lib.}
proc get_event_sequence*(event: PEvent): PEventSequence {.
    cdecl, importc: "gdk_event_get_event_sequence", dynlib: lib.}
proc get_event_type*(event: PEvent): TEventType {.cdecl, 
    importc: "gdk_event_get_event_type", dynlib: lib.}
proc set_show_events*(show_events: gboolean) {.cdecl, 
    importc: "gdk_set_show_events", dynlib: lib.}
proc get_show_events*(): gboolean {.cdecl, importc: "gdk_get_show_events", 
    dynlib: lib.}
when not(defined(MULTIHEAD_SAFE)): 
  proc setting_get*(name: CSTRING; value: PGValue): gboolean {.cdecl, 
      importc: "gdk_setting_get", dynlib: lib.}

template TYPE_DEVICE_MANAGER*(): expr = 
  (gdk_device_manager_get_type())

template DEVICE_MANAGER*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_DEVICE_MANAGER, TDeviceManager))

template IS_DEVICE_MANAGER*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_DEVICE_MANAGER))

proc device_manager_get_type*(): GType {.cdecl, 
    importc: "gdk_device_manager_get_type", dynlib: lib.}
proc get_display*(device_manager: PDeviceManager): PGdkDisplay {.
    cdecl, importc: "gdk_device_manager_get_display", dynlib: lib.}
proc list_devices*(device_manager: PDeviceManager; 
                                      typ: TDeviceType): PGList {.cdecl, 
    importc: "gdk_device_manager_list_devices", dynlib: lib.}
proc get_client_pointer*(
    device_manager: PDeviceManager): PDevice {.cdecl, 
    importc: "gdk_device_manager_get_client_pointer", dynlib: lib.}

template TYPE_DISPLAY*(): expr = 
  (gdk_display_get_type())

template DISPLAY*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_DISPLAY, TGdkDisplay))

template IS_DISPLAY*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_DISPLAY))

when not(defined(DISABLE_DEPRECATED)): 
  template DISPLAY_OBJECT*(obj: expr): expr = 
    DISPLAY(obj)

proc display_get_type*(): GType {.cdecl, importc: "gdk_display_get_type", 
                                      dynlib: lib.}
proc display_open*(display_name: CSTRING): PGdkDisplay {.cdecl, 
    importc: "gdk_display_open", dynlib: lib.}
proc get_name*(display: PGdkDisplay): CSTRING {.cdecl, 
    importc: "gdk_display_get_name", dynlib: lib.}
proc get_n_screens*(display: PGdkDisplay): gint {.cdecl, 
    importc: "gdk_display_get_n_screens", dynlib: lib.}
proc get_screen*(display: PGdkDisplay; screen_num: gint): PGdkScreen {.
    cdecl, importc: "gdk_display_get_screen", dynlib: lib.}
proc get_default_screen*(display: PGdkDisplay): PGdkScreen {.
    cdecl, importc: "gdk_display_get_default_screen", dynlib: lib.}
when not(defined(MULTIDEVICE_SAFE)): 
  proc pointer_ungrab*(display: PGdkDisplay; time: guint32) {.
      cdecl, importc: "gdk_display_pointer_ungrab", dynlib: lib.}
  proc keyboard_ungrab*(display: PGdkDisplay; time: guint32) {.
      cdecl, importc: "gdk_display_keyboard_ungrab", dynlib: lib.}
  proc pointer_is_grabbed*(display: PGdkDisplay): gboolean {.
      cdecl, importc: "gdk_display_pointer_is_grabbed", dynlib: lib.}
proc device_is_grabbed*(display: PGdkDisplay; 
                                    device: PDevice): gboolean {.cdecl, 
    importc: "gdk_display_device_is_grabbed", dynlib: lib.}
proc beep*(display: PGdkDisplay) {.cdecl, 
    importc: "gdk_display_beep", dynlib: lib.}
proc sync*(display: PGdkDisplay) {.cdecl, 
    importc: "gdk_display_sync", dynlib: lib.}
proc flush*(display: PGdkDisplay) {.cdecl, 
    importc: "gdk_display_flush", dynlib: lib.}
proc close*(display: PGdkDisplay) {.cdecl, 
    importc: "gdk_display_close", dynlib: lib.}
proc is_closed*(display: PGdkDisplay): gboolean {.cdecl, 
    importc: "gdk_display_is_closed", dynlib: lib.}
proc list_devices*(display: PGdkDisplay): PGList {.cdecl, 
    importc: "gdk_display_list_devices", dynlib: lib.}
proc get_event*(display: PGdkDisplay): PEvent {.cdecl, 
    importc: "gdk_display_get_event", dynlib: lib.}
proc peek_event*(display: PGdkDisplay): PEvent {.cdecl, 
    importc: "gdk_display_peek_event", dynlib: lib.}
proc put_event*(display: PGdkDisplay; event: PEvent) {.
    cdecl, importc: "gdk_display_put_event", dynlib: lib.}
proc has_pending*(display: PGdkDisplay): gboolean {.cdecl, 
    importc: "gdk_display_has_pending", dynlib: lib.}
proc set_double_click_time*(display: PGdkDisplay; msec: guint) {.
    cdecl, importc: "gdk_display_set_double_click_time", dynlib: lib.}
proc set_double_click_distance*(display: PGdkDisplay; 
    distance: guint) {.cdecl, 
                       importc: "gdk_display_set_double_click_distance", 
                       dynlib: lib.}
proc display_get_default*(): PGdkDisplay {.cdecl, 
    importc: "gdk_display_get_default", dynlib: lib.}
when not(defined(MULTIDEVICE_SAFE)): 
  proc get_pointer*(display: PGdkDisplay; 
                                screen: ptr PGdkScreen; x: Pgint; 
                                y: Pgint; mask: PModifierType) {.
      cdecl, importc: "gdk_display_get_pointer", dynlib: lib.}
  proc get_window_at_pointer*(display: PGdkDisplay; 
      win_x: Pgint; win_y: Pgint): PGdkWindow {.cdecl, 
      importc: "gdk_display_get_window_at_pointer", dynlib: lib.}
  proc warp_pointer*(display: PGdkDisplay; 
                                 screen: PGdkScreen; x: gint; y: gint) {.
      cdecl, importc: "gdk_display_warp_pointer", dynlib: lib.}
proc display_open_default_libgtk_only*(): PGdkDisplay {.cdecl, 
    importc: "gdk_display_open_default_libgtk_only", dynlib: lib.}
proc supports_cursor_alpha*(display: PGdkDisplay): gboolean {.
    cdecl, importc: "gdk_display_supports_cursor_alpha", dynlib: lib.}
proc supports_cursor_color*(display: PGdkDisplay): gboolean {.
    cdecl, importc: "gdk_display_supports_cursor_color", dynlib: lib.}
proc get_default_cursor_size*(display: PGdkDisplay): guint {.
    cdecl, importc: "gdk_display_get_default_cursor_size", dynlib: lib.}
proc get_maximal_cursor_size*(display: PGdkDisplay; 
    width: Pguint; height: Pguint) {.cdecl, 
    importc: "gdk_display_get_maximal_cursor_size", dynlib: lib.}
proc get_default_group*(display: PGdkDisplay): PGdkWindow {.
    cdecl, importc: "gdk_display_get_default_group", dynlib: lib.}
proc supports_selection_notification*(display: PGdkDisplay): gboolean {.
    cdecl, importc: "gdk_display_supports_selection_notification", dynlib: lib.}
proc request_selection_notification*(display: PGdkDisplay; 
    selection: TGdkAtom): gboolean {.cdecl, importc: "gdk_display_request_selection_notification", 
                                    dynlib: lib.}
proc supports_clipboard_persistence*(display: PGdkDisplay): gboolean {.
    cdecl, importc: "gdk_display_supports_clipboard_persistence", dynlib: lib.}
proc store_clipboard*(display: PGdkDisplay; 
                                  clipboard_window: PGdkWindow; 
                                  time: guint32; targets: PGdkAtom; 
                                  n_targets: gint) {.cdecl, 
    importc: "gdk_display_store_clipboard", dynlib: lib.}
proc supports_shapes*(display: PGdkDisplay): gboolean {.cdecl, 
    importc: "gdk_display_supports_shapes", dynlib: lib.}
proc supports_input_shapes*(display: PGdkDisplay): gboolean {.
    cdecl, importc: "gdk_display_supports_input_shapes", dynlib: lib.}
proc supports_composite*(display: PGdkDisplay): gboolean {.
    cdecl, importc: "gdk_display_supports_composite", dynlib: lib.}
proc notify_startup_complete*(display: PGdkDisplay; 
    startup_id: CSTRING) {.cdecl, 
                             importc: "gdk_display_notify_startup_complete", 
                             dynlib: lib.}
proc get_device_manager*(display: PGdkDisplay): PDeviceManager {.
    cdecl, importc: "gdk_display_get_device_manager", dynlib: lib.}
proc get_app_launch_context*(display: PGdkDisplay): PAppLaunchContext {.
    cdecl, importc: "gdk_display_get_app_launch_context", dynlib: lib.}

template TYPE_SCREEN*(): expr = 
  (gdk_screen_get_type())

template SCREEN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SCREEN, TGdkScreen))

template IS_SCREEN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SCREEN))

proc screen_get_type*(): GType {.cdecl, importc: "gdk_screen_get_type", 
                                     dynlib: lib.}
proc get_system_visual*(screen: PGdkScreen): PGdkVisual {.
    cdecl, importc: "gdk_screen_get_system_visual", dynlib: lib.}
proc get_rgba_visual*(screen: PGdkScreen): PGdkVisual {.
    cdecl, importc: "gdk_screen_get_rgba_visual", dynlib: lib.}
proc is_composited*(screen: PGdkScreen): gboolean {.cdecl, 
    importc: "gdk_screen_is_composited", dynlib: lib.}
proc get_root_window*(screen: PGdkScreen): PGdkWindow {.
    cdecl, importc: "gdk_screen_get_root_window", dynlib: lib.}
proc get_display*(screen: PGdkScreen): PGdkDisplay {.cdecl, 
    importc: "gdk_screen_get_display", dynlib: lib.}
proc get_number*(screen: PGdkScreen): gint {.cdecl, 
    importc: "gdk_screen_get_number", dynlib: lib.}
proc get_width*(screen: PGdkScreen): gint {.cdecl, 
    importc: "gdk_screen_get_width", dynlib: lib.}
proc get_height*(screen: PGdkScreen): gint {.cdecl, 
    importc: "gdk_screen_get_height", dynlib: lib.}
proc get_width_mm*(screen: PGdkScreen): gint {.cdecl, 
    importc: "gdk_screen_get_width_mm", dynlib: lib.}
proc get_height_mm*(screen: PGdkScreen): gint {.cdecl, 
    importc: "gdk_screen_get_height_mm", dynlib: lib.}
proc list_visuals*(screen: PGdkScreen): PGList {.cdecl, 
    importc: "gdk_screen_list_visuals", dynlib: lib.}
proc get_toplevel_windows*(screen: PGdkScreen): PGList {.
    cdecl, importc: "gdk_screen_get_toplevel_windows", dynlib: lib.}
proc make_display_name*(screen: PGdkScreen): CSTRING {.cdecl, 
    importc: "gdk_screen_make_display_name", dynlib: lib.}
proc get_n_monitors*(screen: PGdkScreen): gint {.cdecl, 
    importc: "gdk_screen_get_n_monitors", dynlib: lib.}
proc get_primary_monitor*(screen: PGdkScreen): gint {.cdecl, 
    importc: "gdk_screen_get_primary_monitor", dynlib: lib.}
proc get_monitor_geometry*(screen: PGdkScreen; 
                                      monitor_num: gint; 
                                      dest: PRectangle) {.cdecl, 
    importc: "gdk_screen_get_monitor_geometry", dynlib: lib.}
proc get_monitor_workarea*(screen: PGdkScreen; 
                                      monitor_num: gint; 
                                      dest: PRectangle) {.cdecl, 
    importc: "gdk_screen_get_monitor_workarea", dynlib: lib.}
proc get_monitor_at_point*(screen: PGdkScreen; x: gint; y: gint): gint {.
    cdecl, importc: "gdk_screen_get_monitor_at_point", dynlib: lib.}
proc get_monitor_at_window*(screen: PGdkScreen; 
    window: PGdkWindow): gint {.cdecl, importc: "gdk_screen_get_monitor_at_window", 
                                   dynlib: lib.}
proc get_monitor_width_mm*(screen: PGdkScreen; monitor_num: gint): gint {.
    cdecl, importc: "gdk_screen_get_monitor_width_mm", dynlib: lib.}
proc get_monitor_height_mm*(screen: PGdkScreen; 
    monitor_num: gint): gint {.cdecl, 
                               importc: "gdk_screen_get_monitor_height_mm", 
                               dynlib: lib.}
proc get_monitor_plug_name*(screen: PGdkScreen; 
    monitor_num: gint): CSTRING {.cdecl, importc: "gdk_screen_get_monitor_plug_name", 
                                    dynlib: lib.}
proc get_monitor_scale_factor*(screen: PGdkScreen; 
    monitor_num: gint): gint {.cdecl, importc: "gdk_screen_get_monitor_scale_factor", 
                               dynlib: lib.}
proc screen_get_default*(): PGdkScreen {.cdecl, 
    importc: "gdk_screen_get_default", dynlib: lib.}
proc get_setting*(screen: PGdkScreen; name: CSTRING; 
                             value: PGValue): gboolean {.cdecl, 
    importc: "gdk_screen_get_setting", dynlib: lib.}
proc set_font_options*(screen: PGdkScreen; 
                                  options: PFontOptions) {.cdecl, 
    importc: "gdk_screen_set_font_options", dynlib: lib.}
proc get_font_options*(screen: PGdkScreen): PFontOptions {.
    cdecl, importc: "gdk_screen_get_font_options", dynlib: lib.}
proc set_resolution*(screen: PGdkScreen; dpi: gdouble) {.cdecl, 
    importc: "gdk_screen_set_resolution", dynlib: lib.}
proc get_resolution*(screen: PGdkScreen): gdouble {.cdecl, 
    importc: "gdk_screen_get_resolution", dynlib: lib.}
proc get_active_window*(screen: PGdkScreen): PGdkWindow {.
    cdecl, importc: "gdk_screen_get_active_window", dynlib: lib.}
proc get_window_stack*(screen: PGdkScreen): PGList {.cdecl, 
    importc: "gdk_screen_get_window_stack", dynlib: lib.}

template TYPE_APP_LAUNCH_CONTEXT*(): expr = 
  (gdk_app_launch_context_get_type())

template APP_LAUNCH_CONTEXT*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_APP_LAUNCH_CONTEXT, 
                              TAppLaunchContext))

template IS_APP_LAUNCH_CONTEXT*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_APP_LAUNCH_CONTEXT))

proc app_launch_context_get_type*(): GType {.cdecl, 
    importc: "gdk_app_launch_context_get_type", dynlib: lib.}
proc app_launch_context_new*(): PAppLaunchContext {.cdecl, 
    importc: "gdk_app_launch_context_new", dynlib: lib.}
proc set_display*(context: PAppLaunchContext; 
    display: PGdkDisplay) {.cdecl, 
                               importc: "gdk_app_launch_context_set_display", 
                               dynlib: lib.}
proc set_screen*(context: PAppLaunchContext; 
    screen: PGdkScreen) {.cdecl, 
                             importc: "gdk_app_launch_context_set_screen", 
                             dynlib: lib.}
proc set_desktop*(context: PAppLaunchContext; 
    desktop: gint) {.cdecl, importc: "gdk_app_launch_context_set_desktop", 
                     dynlib: lib.}
proc set_timestamp*(context: PAppLaunchContext; 
    timestamp: guint32) {.cdecl, 
                          importc: "gdk_app_launch_context_set_timestamp", 
                          dynlib: lib.}
proc set_icon*(context: PAppLaunchContext; 
                                      icon: PGIcon) {.cdecl, 
    importc: "gdk_app_launch_context_set_icon", dynlib: lib.}
proc set_icon_name*(context: PAppLaunchContext; 
    icon_name: cstring) {.cdecl, 
                          importc: "gdk_app_launch_context_set_icon_name", 
                          dynlib: lib.}

type 
  PRGBA* = ptr TRGBA
  TRGBA*{.final, pure.} = object 
    red*: gdouble
    green*: gdouble
    blue*: gdouble
    alpha*: gdouble

template TYPE_RGBA*(): expr = 
  (gdk_rgba_get_type())

proc rgba_get_type*(): GType {.cdecl, importc: "gdk_rgba_get_type", 
                                   dynlib: lib.}
proc copy*(rgba: PRGBA): PRGBA {.cdecl, 
    importc: "gdk_rgba_copy", dynlib: lib.}
proc free*(rgba: PRGBA) {.cdecl, importc: "gdk_rgba_free", 
    dynlib: lib.}
proc rgba_hash*(p: gconstpointer): guint {.cdecl, 
    importc: "gdk_rgba_hash", dynlib: lib.}
proc rgba_equal*(p1: gconstpointer; p2: gconstpointer): gboolean {.cdecl, 
    importc: "gdk_rgba_equal", dynlib: lib.}
proc parse*(rgba: PRGBA; spec: CSTRING): gboolean {.cdecl, 
    importc: "gdk_rgba_parse", dynlib: lib.}
proc to_string*(rgba: PRGBA): CSTRING {.cdecl, 
    importc: "gdk_rgba_to_string", dynlib: lib.}

proc pixbuf_get_from_window*(window: PGdkWindow; src_x: gint; 
                                 src_y: gint; width: gint; height: gint): PPixbuf {.
    cdecl, importc: "gdk_pixbuf_get_from_window", dynlib: lib.}
proc pixbuf_get_from_surface*(surface: PSurface; src_x: gint; 
                                  src_y: gint; width: gint; height: gint): PPixbuf {.
    cdecl, importc: "gdk_pixbuf_get_from_surface", dynlib: lib.}

proc cairo_create*(window: PGdkWindow): Pcairo_t {.cdecl, 
    importc: "gdk_cairo_create", dynlib: lib.}
proc cairo_get_clip_rectangle*(cr: Pcairo_t; rect: PRectangle): gboolean {.
    cdecl, importc: "gdk_cairo_get_clip_rectangle", dynlib: lib.}
proc cairo_set_source_rgba*(cr: Pcairo_t; rgba: PRGBA) {.cdecl, 
    importc: "gdk_cairo_set_source_rgba", dynlib: lib.}
proc cairo_set_source_pixbuf*(cr: Pcairo_t; pixbuf: PPixbuf; 
                                  pixbuf_x: gdouble; pixbuf_y: gdouble) {.
    cdecl, importc: "gdk_cairo_set_source_pixbuf", dynlib: lib.}
proc cairo_set_source_window*(cr: Pcairo_t; window: PGdkWindow; 
                                  x: gdouble; y: gdouble) {.cdecl, 
    importc: "gdk_cairo_set_source_window", dynlib: lib.}
proc cairo_rectangle*(cr: Pcairo_t; rectangle: PRectangle) {.
    cdecl, importc: "gdk_cairo_rectangle", dynlib: lib.}
proc cairo_region*(cr: Pcairo_t; region: Pcairo_region_t) {.cdecl, 
    importc: "gdk_cairo_region", dynlib: lib.}
proc cairo_region_create_from_surface*(surface: PSurface): Pcairo_region_t {.
    cdecl, importc: "gdk_cairo_region_create_from_surface", dynlib: lib.}
proc cairo_set_source_color*(cr: Pcairo_t; color: PColor) {.
    cdecl, importc: "gdk_cairo_set_source_color", dynlib: lib.}
proc cairo_surface_create_from_pixbuf*(pixbuf: PPixbuf; scale: cint; 
    for_window: PGdkWindow): PSurface {.cdecl, 
    importc: "gdk_cairo_surface_create_from_pixbuf", dynlib: lib.}

template TYPE_CURSOR*(): expr = 
  (gdk_cursor_get_type())

template CURSOR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CURSOR, TGdkCursor))

template IS_CURSOR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CURSOR))

type 
  TGdkCursorType* {.size: sizeof(cint).} = enum 
    BLANK_CURSOR = - 2, CURSOR_IS_PIXMAP = - 1,
    X_CURSOR = 0, ARROW = 2, BASED_ARROW_DOWN = 4, 
    BASED_ARROW_UP = 6, BOAT = 8, BOGOSITY = 10, 
    BOTTOM_LEFT_CORNER = 12, BOTTOM_RIGHT_CORNER = 14, 
    BOTTOM_SIDE = 16, BOTTOM_TEE = 18, BOX_SPIRAL = 20, 
    CENTER_PTR = 22, CIRCLE = 24, CLOCK = 26, COFFEE_MUG = 28, 
    CROSS = 30, CROSS_REVERSE = 32, CROSSHAIR = 34, 
    DIAMOND_CROSS = 36, DOT = 38, DOTBOX = 40, 
    DOUBLE_ARROW = 42, DRAFT_LARGE = 44, DRAFT_SMALL = 46, 
    DRAPED_BOX = 48, EXCHANGE = 50, FLEUR = 52, GOBBLER = 54, 
    GUMBY = 56, HAND1 = 58, HAND2 = 60, HEART = 62, 
    ICON = 64, IRON_CROSS = 66, LEFT_PTR = 68, LEFT_SIDE = 70, 
    LEFT_TEE = 72, LEFTBUTTON = 74, LL_ANGLE = 76, 
    LR_ANGLE = 78, MAN = 80, MIDDLEBUTTON = 82, MOUSE = 84, 
    PENCIL = 86, PIRATE = 88, PLUS = 90, QUESTION_ARROW = 92, 
    RIGHT_PTR = 94, RIGHT_SIDE = 96, RIGHT_TEE = 98, 
    RIGHTBUTTON = 100, RTL_LOGO = 102, SAILBOAT = 104, 
    SB_DOWN_ARROW = 106, SB_H_DOUBLE_ARROW = 108, 
    SB_LEFT_ARROW = 110, SB_RIGHT_ARROW = 112, SB_UP_ARROW = 114, 
    SB_V_DOUBLE_ARROW = 116, SHUTTLE = 118, SIZING = 120, 
    SPIDER = 122, SPRAYCAN = 124, STAR = 126, TARGET = 128, 
    TCROSS = 130, TOP_LEFT_ARROW = 132, TOP_LEFT_CORNER = 134, 
    TOP_RIGHT_CORNER = 136, TOP_SIDE = 138, TOP_TEE = 140, 
    TREK = 142, UL_ANGLE = 144, UMBRELLA = 146, 
    UR_ANGLE = 148, WATCH = 150, XTERM = 152, LAST_CURSOR, 
proc cursor_get_type*(): GType {.cdecl, importc: "gdk_cursor_get_type", 
                                     dynlib: lib.}
proc cursor_new_for_display*(display: PGdkDisplay; 
                                 cursor_type: TGdkCursorType): PGdkCursor {.
    cdecl, importc: "gdk_cursor_new_for_display", dynlib: lib.}
when not(defined(MULTIHEAD_SAFE)): 
  proc cursor_new*(cursor_type: TGdkCursorType): PGdkCursor {.cdecl, 
      importc: "gdk_cursor_new", dynlib: lib.}
proc cursor_new_from_pixbuf*(display: PGdkDisplay; 
                                 pixbuf: PPixbuf; x: gint; y: gint): PGdkCursor {.
    cdecl, importc: "gdk_cursor_new_from_pixbuf", dynlib: lib.}
proc cursor_new_from_surface*(display: PGdkDisplay; 
                                  surface: PSurface; x: gdouble; 
                                  y: gdouble): PGdkCursor {.cdecl, 
    importc: "gdk_cursor_new_from_surface", dynlib: lib.}
proc cursor_new_from_name*(display: PGdkDisplay; name: CSTRING): PGdkCursor {.
    cdecl, importc: "gdk_cursor_new_from_name", dynlib: lib.}
proc get_display*(cursor: PGdkCursor): PGdkDisplay {.cdecl, 
    importc: "gdk_cursor_get_display", dynlib: lib.}
proc re*(cursor: PGdkCursor): PGdkCursor {.cdecl, 
    importc: "gdk_cursor_ref", dynlib: lib.}
proc unref*(cursor: PGdkCursor) {.cdecl, 
    importc: "gdk_cursor_unref", dynlib: lib.}
proc get_image*(cursor: PGdkCursor): PPixbuf {.cdecl, 
    importc: "gdk_cursor_get_image", dynlib: lib.}
proc get_surface*(cursor: PGdkCursor; x_hot: Pgdouble; 
                             y_hot: Pgdouble): PSurface {.cdecl, 
    importc: "gdk_cursor_get_surface", dynlib: lib.}
proc get_cursor_type*(cursor: PGdkCursor): TGdkCursorType {.
    cdecl, importc: "gdk_cursor_get_cursor_type", dynlib: lib.}

template TYPE_DISPLAY_MANAGER*(): expr = 
  (gdk_display_manager_get_type())

template DISPLAY_MANAGER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_DISPLAY_MANAGER, 
                              TGdkDisplayManager))

template IS_DISPLAY_MANAGER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_DISPLAY_MANAGER))

proc display_manager_get_type*(): GType {.cdecl, 
    importc: "gdk_display_manager_get_type", dynlib: lib.}
proc display_manager_get*(): PGdkDisplayManager {.cdecl, 
    importc: "gdk_display_manager_get", dynlib: lib.}
proc display_manager_get_default_display*(manager: PGdkDisplayManager): PGdkDisplay {.
    cdecl, importc: "gdk_display_manager_get_default_display", dynlib: lib.}
proc display_manager_set_default_display*(manager: PGdkDisplayManager; 
    display: PGdkDisplay) {.cdecl, importc: "gdk_display_manager_set_default_display", 
                               dynlib: lib.}
proc display_manager_list_displays*(manager: PGdkDisplayManager): PGSList {.
    cdecl, importc: "gdk_display_manager_list_displays", dynlib: lib.}
proc display_manager_open_display*(manager: PGdkDisplayManager; 
    name: CSTRING): PGdkDisplay {.cdecl, 
    importc: "gdk_display_manager_open_display", dynlib: lib.}

proc cursor_type_get_type*(): GType {.cdecl, 
    importc: "gdk_cursor_type_get_type", dynlib: lib.}
template TYPE_CURSOR_TYPE*(): expr = 
  (gdk_cursor_type_get_type())

proc input_source_get_type*(): GType {.cdecl, 
    importc: "gdk_input_source_get_type", dynlib: lib.}
template TYPE_INPUT_SOURCE*(): expr = 
  (gdk_input_source_get_type())

proc input_mode_get_type*(): GType {.cdecl, 
    importc: "gdk_input_mode_get_type", dynlib: lib.}
template TYPE_INPUT_MODE*(): expr = 
  (gdk_input_mode_get_type())

proc axis_use_get_type*(): GType {.cdecl, 
    importc: "gdk_axis_use_get_type", dynlib: lib.}
template TYPE_AXIS_USE*(): expr = 
  (gdk_axis_use_get_type())

proc device_type_get_type*(): GType {.cdecl, 
    importc: "gdk_device_type_get_type", dynlib: lib.}
template TYPE_DEVICE_TYPE*(): expr = 
  (gdk_device_type_get_type())

proc drag_action_get_type*(): GType {.cdecl, 
    importc: "gdk_drag_action_get_type", dynlib: lib.}
template TYPE_DRAG_ACTION*(): expr = 
  (gdk_drag_action_get_type())

proc drag_protocol_get_type*(): GType {.cdecl, 
    importc: "gdk_drag_protocol_get_type", dynlib: lib.}
template TYPE_DRAG_PROTOCOL*(): expr = 
  (gdk_drag_protocol_get_type())

proc filter_return_get_type*(): GType {.cdecl, 
    importc: "gdk_filter_return_get_type", dynlib: lib.}
template TYPE_FILTER_RETURN*(): expr = 
  (gdk_filter_return_get_type())

proc event_type_get_type*(): GType {.cdecl, 
    importc: "gdk_event_type_get_type", dynlib: lib.}
template TYPE_EVENT_TYPE*(): expr = 
  (gdk_event_type_get_type())

proc visibility_state_get_type*(): GType {.cdecl, 
    importc: "gdk_visibility_state_get_type", dynlib: lib.}
template TYPE_VISIBILITY_STATE*(): expr = 
  (gdk_visibility_state_get_type())

proc scroll_direction_get_type*(): GType {.cdecl, 
    importc: "gdk_scroll_direction_get_type", dynlib: lib.}
template TYPE_SCROLL_DIRECTION*(): expr = 
  (gdk_scroll_direction_get_type())

proc notify_type_get_type*(): GType {.cdecl, 
    importc: "gdk_notify_type_get_type", dynlib: lib.}
template TYPE_NOTIFY_TYPE*(): expr = 
  (gdk_notify_type_get_type())

proc crossing_mode_get_type*(): GType {.cdecl, 
    importc: "gdk_crossing_mode_get_type", dynlib: lib.}
template TYPE_CROSSING_MODE*(): expr = 
  (gdk_crossing_mode_get_type())

proc property_state_get_type*(): GType {.cdecl, 
    importc: "gdk_property_state_get_type", dynlib: lib.}
template TYPE_PROPERTY_STATE*(): expr = 
  (gdk_property_state_get_type())

proc window_state_get_type*(): GType {.cdecl, 
    importc: "gdk_window_state_get_type", dynlib: lib.}
template TYPE_WINDOW_STATE*(): expr = 
  (gdk_window_state_get_type())

proc setting_action_get_type*(): GType {.cdecl, 
    importc: "gdk_setting_action_get_type", dynlib: lib.}
template TYPE_SETTING_ACTION*(): expr = 
  (gdk_setting_action_get_type())

proc owner_change_get_type*(): GType {.cdecl, 
    importc: "gdk_owner_change_get_type", dynlib: lib.}
template TYPE_OWNER_CHANGE*(): expr = 
  (gdk_owner_change_get_type())

proc frame_clock_phase_get_type*(): GType {.cdecl, 
    importc: "gdk_frame_clock_phase_get_type", dynlib: lib.}
template TYPE_FRAME_CLOCK_PHASE*(): expr = 
  (gdk_frame_clock_phase_get_type())

proc prop_mode_get_type*(): GType {.cdecl, 
    importc: "gdk_prop_mode_get_type", dynlib: lib.}
template TYPE_PROP_MODE*(): expr = 
  (gdk_prop_mode_get_type())

proc byte_order_get_type*(): GType {.cdecl, 
    importc: "gdk_byte_order_get_type", dynlib: lib.}
template TYPE_BYTE_ORDER*(): expr = 
  (gdk_byte_order_get_type())

proc modifier_type_get_type*(): GType {.cdecl, 
    importc: "gdk_modifier_type_get_type", dynlib: lib.}
template TYPE_MODIFIER_TYPE*(): expr = 
  (gdk_modifier_type_get_type())

proc modifier_intent_get_type*(): GType {.cdecl, 
    importc: "gdk_modifier_intent_get_type", dynlib: lib.}
template TYPE_MODIFIER_INTENT*(): expr = 
  (gdk_modifier_intent_get_type())

proc status_get_type*(): GType {.cdecl, importc: "gdk_status_get_type", 
                                     dynlib: lib.}
template TYPE_STATUS*(): expr = 
  (gdk_status_get_type())

proc grab_status_get_type*(): GType {.cdecl, 
    importc: "gdk_grab_status_get_type", dynlib: lib.}
template TYPE_GRAB_STATUS*(): expr = 
  (gdk_grab_status_get_type())

proc grab_ownership_get_type*(): GType {.cdecl, 
    importc: "gdk_grab_ownership_get_type", dynlib: lib.}
template TYPE_GRAB_OWNERSHIP*(): expr = 
  (gdk_grab_ownership_get_type())

proc event_mask_get_type*(): GType {.cdecl, 
    importc: "gdk_event_mask_get_type", dynlib: lib.}
template TYPE_EVENT_MASK*(): expr = 
  (gdk_event_mask_get_type())

proc visual_type_get_type*(): GType {.cdecl, 
    importc: "gdk_visual_type_get_type", dynlib: lib.}
template TYPE_VISUAL_TYPE*(): expr = 
  (gdk_visual_type_get_type())

proc window_window_class_get_type*(): GType {.cdecl, 
    importc: "gdk_window_window_class_get_type", dynlib: lib.}
template TYPE_WINDOW_WINDOW_CLASS*(): expr = 
  (gdk_window_window_class_get_type())

proc window_type_get_type*(): GType {.cdecl, 
    importc: "gdk_window_type_get_type", dynlib: lib.}
template TYPE_WINDOW_TYPE*(): expr = 
  (gdk_window_type_get_type())

proc window_attributes_type_get_type*(): GType {.cdecl, 
    importc: "gdk_window_attributes_type_get_type", dynlib: lib.}
template TYPE_WINDOW_ATTRIBUTES_TYPE*(): expr = 
  (gdk_window_attributes_type_get_type())

proc window_hints_get_type*(): GType {.cdecl, 
    importc: "gdk_window_hints_get_type", dynlib: lib.}
template TYPE_WINDOW_HINTS*(): expr = 
  (gdk_window_hints_get_type())

proc window_type_hint_get_type*(): GType {.cdecl, 
    importc: "gdk_window_type_hint_get_type", dynlib: lib.}
template TYPE_WINDOW_TYPE_HINT*(): expr = 
  (gdk_window_type_hint_get_type())

proc wm_decoration_get_type*(): GType {.cdecl, 
    importc: "gdk_wm_decoration_get_type", dynlib: lib.}
template TYPE_WM_DECORATION*(): expr = 
  (gdk_wm_decoration_get_type())

proc wm_function_get_type*(): GType {.cdecl, 
    importc: "gdk_wm_function_get_type", dynlib: lib.}
template TYPE_WM_FUNCTION*(): expr = 
  (gdk_wm_function_get_type())

proc gravity_get_type*(): GType {.cdecl, importc: "gdk_gravity_get_type", 
                                      dynlib: lib.}
template TYPE_GRAVITY*(): expr = 
  (gdk_gravity_get_type())

proc window_edge_get_type*(): GType {.cdecl, 
    importc: "gdk_window_edge_get_type", dynlib: lib.}
template TYPE_WINDOW_EDGE*(): expr = 
  (gdk_window_edge_get_type())

proc fullscreen_mode_get_type*(): GType {.cdecl, 
    importc: "gdk_fullscreen_mode_get_type", dynlib: lib.}
template TYPE_FULLSCREEN_MODE*(): expr = 
  (gdk_fullscreen_mode_get_type())


proc frame_timings_get_type*(): GType {.cdecl, 
    importc: "gdk_frame_timings_get_type", dynlib: lib.}
proc re*(timings: PFrameTimings): PFrameTimings {.
    cdecl, importc: "gdk_frame_timings_ref", dynlib: lib.}
proc unref*(timings: PFrameTimings) {.cdecl, 
    importc: "gdk_frame_timings_unref", dynlib: lib.}
proc get_frame_counter*(timings: PFrameTimings): gint64 {.
    cdecl, importc: "gdk_frame_timings_get_frame_counter", dynlib: lib.}
proc get_complete*(timings: PFrameTimings): gboolean {.
    cdecl, importc: "gdk_frame_timings_get_complete", dynlib: lib.}
proc get_frame_time*(timings: PFrameTimings): gint64 {.
    cdecl, importc: "gdk_frame_timings_get_frame_time", dynlib: lib.}
proc get_presentation_time*(timings: PFrameTimings): gint64 {.
    cdecl, importc: "gdk_frame_timings_get_presentation_time", dynlib: lib.}
proc get_refresh_interval*(timings: PFrameTimings): gint64 {.
    cdecl, importc: "gdk_frame_timings_get_refresh_interval", dynlib: lib.}
proc get_predicted_presentation_time*(
    timings: PFrameTimings): gint64 {.cdecl, 
    importc: "gdk_frame_timings_get_predicted_presentation_time", dynlib: lib.}

template TYPE_FRAME_CLOCK*(): expr = 
  (gdk_frame_clock_get_type())

template FRAME_CLOCK*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FRAME_CLOCK, TFrameClock))

template FRAME_CLOCK_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FRAME_CLOCK, FrameClockClass))

template IS_FRAME_CLOCK*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FRAME_CLOCK))

template IS_FRAME_CLOCK_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FRAME_CLOCK))

template FRAME_CLOCK_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FRAME_CLOCK, FrameClockClass))

type 
  TFrameClockPhase* {.size: sizeof(cint).} = enum 
    FRAME_CLOCK_PHASE_NONE = 0, 
    FRAME_CLOCK_PHASE_FLUSH_EVENTS = 1 shl 0, 
    FRAME_CLOCK_PHASE_BEFORE_PAINT = 1 shl 1, 
    FRAME_CLOCK_PHASE_UPDATE = 1 shl 2, 
    FRAME_CLOCK_PHASE_LAYOUT = 1 shl 3, 
    FRAME_CLOCK_PHASE_PAINT = 1 shl 4, 
    FRAME_CLOCK_PHASE_RESUME_EVENTS = 1 shl 5, 
    FRAME_CLOCK_PHASE_AFTER_PAINT = 1 shl 6
proc frame_clock_get_type*(): GType {.cdecl, 
    importc: "gdk_frame_clock_get_type", dynlib: lib.}
proc get_frame_time*(frame_clock: PFrameClock): gint64 {.
    cdecl, importc: "gdk_frame_clock_get_frame_time", dynlib: lib.}
proc request_phase*(frame_clock: PFrameClock; 
                                    phase: TFrameClockPhase) {.cdecl, 
    importc: "gdk_frame_clock_request_phase", dynlib: lib.}
proc begin_updating*(frame_clock: PFrameClock) {.cdecl, 
    importc: "gdk_frame_clock_begin_updating", dynlib: lib.}
proc end_updating*(frame_clock: PFrameClock) {.cdecl, 
    importc: "gdk_frame_clock_end_updating", dynlib: lib.}
proc get_frame_counter*(frame_clock: PFrameClock): gint64 {.
    cdecl, importc: "gdk_frame_clock_get_frame_counter", dynlib: lib.}
proc get_history_start*(frame_clock: PFrameClock): gint64 {.
    cdecl, importc: "gdk_frame_clock_get_history_start", dynlib: lib.}
proc get_timings*(frame_clock: PFrameClock; 
                                  frame_counter: gint64): PFrameTimings {.
    cdecl, importc: "gdk_frame_clock_get_timings", dynlib: lib.}
proc get_current_timings*(frame_clock: PFrameClock): PFrameTimings {.
    cdecl, importc: "gdk_frame_clock_get_current_timings", dynlib: lib.}
proc get_refresh_info*(frame_clock: PFrameClock; 
    base_time: gint64; refresh_interval_return: Pgint64; 
    presentation_time_return: Pgint64) {.cdecl, 
    importc: "gdk_frame_clock_get_refresh_info", dynlib: lib.}

type 
  PKeymapKey* = ptr TKeymapKey
  TKeymapKey*{.final, pure.} = object 
    keycode*: guint
    group*: gint
    level*: gint

template TYPE_KEYMAP*(): expr = 
  (gdk_keymap_get_type())

template KEYMAP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_KEYMAP, TKeymap))

template IS_KEYMAP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_KEYMAP))

proc keymap_get_type*(): GType {.cdecl, importc: "gdk_keymap_get_type", 
                                     dynlib: lib.}
when not(defined(MULTIHEAD_SAFE)): 
  proc keymap_get_default*(): PKeymap {.cdecl, 
      importc: "gdk_keymap_get_default", dynlib: lib.}
proc keymap_get_for_display*(display: PGdkDisplay): PKeymap {.
    cdecl, importc: "gdk_keymap_get_for_display", dynlib: lib.}
proc lookup_key*(keymap: PKeymap; key: PKeymapKey): guint {.
    cdecl, importc: "gdk_keymap_lookup_key", dynlib: lib.}
proc translate_keyboard_state*(keymap: PKeymap; 
    hardware_keycode: guint; state: TModifierType; group: gint; 
    keyval: Pguint; effective_group: Pgint; level: Pgint; 
    consumed_modifiers: PModifierType): gboolean {.cdecl, 
    importc: "gdk_keymap_translate_keyboard_state", dynlib: lib.}
proc get_entries_for_keyval*(keymap: PKeymap; keyval: guint; 
    keys: ptr PKeymapKey; n_keys: Pgint): gboolean {.cdecl, 
    importc: "gdk_keymap_get_entries_for_keyval", dynlib: lib.}
proc get_entries_for_keycode*(keymap: PKeymap; 
    hardware_keycode: guint; keys: ptr PKeymapKey; 
    keyvals: ptr Pguint; n_entries: Pgint): gboolean {.cdecl, 
    importc: "gdk_keymap_get_entries_for_keycode", dynlib: lib.}
proc get_direction*(keymap: PKeymap): TDirection {.cdecl, 
    importc: "gdk_keymap_get_direction", dynlib: lib.}
proc have_bidi_layouts*(keymap: PKeymap): gboolean {.cdecl, 
    importc: "gdk_keymap_have_bidi_layouts", dynlib: lib.}
proc get_caps_lock_state*(keymap: PKeymap): gboolean {.cdecl, 
    importc: "gdk_keymap_get_caps_lock_state", dynlib: lib.}
proc get_num_lock_state*(keymap: PKeymap): gboolean {.cdecl, 
    importc: "gdk_keymap_get_num_lock_state", dynlib: lib.}
proc get_modifier_state*(keymap: PKeymap): guint {.cdecl, 
    importc: "gdk_keymap_get_modifier_state", dynlib: lib.}
proc add_virtual_modifiers*(keymap: PKeymap; 
    state: PModifierType) {.cdecl, importc: "gdk_keymap_add_virtual_modifiers", 
                                  dynlib: lib.}
proc map_virtual_modifiers*(keymap: PKeymap; 
    state: PModifierType): gboolean {.cdecl, 
    importc: "gdk_keymap_map_virtual_modifiers", dynlib: lib.}
proc get_modifier_mask*(keymap: PKeymap; 
                                   intent: TModifierIntent): TModifierType {.
    cdecl, importc: "gdk_keymap_get_modifier_mask", dynlib: lib.}
proc name*(keyval: guint): CSTRING {.cdecl, 
    importc: "gdk_keyval_name", dynlib: lib.}
proc keyval_from_name*(keyval_name: CSTRING): guint {.cdecl, 
    importc: "gdk_keyval_from_name", dynlib: lib.}
proc keyval_convert_case*(symbol: guint; lower: Pguint; 
                              upper: Pguint) {.cdecl, 
    importc: "gdk_keyval_convert_case", dynlib: lib.}
proc to_upper*(keyval: guint): guint {.cdecl, 
    importc: "gdk_keyval_to_upper", dynlib: lib.}
proc to_lower*(keyval: guint): guint {.cdecl, 
    importc: "gdk_keyval_to_lower", dynlib: lib.}
proc is_upper*(keyval: guint): gboolean {.cdecl, 
    importc: "gdk_keyval_is_upper", dynlib: lib.}
proc is_lower*(keyval: guint): gboolean {.cdecl, 
    importc: "gdk_keyval_is_lower", dynlib: lib.}
proc to_unicode*(keyval: guint): guint32 {.cdecl, 
    importc: "gdk_keyval_to_unicode", dynlib: lib.}
proc unicode_to_keyval*(wc: guint32): guint {.cdecl, 
    importc: "gdk_unicode_to_keyval", dynlib: lib.}

proc parse_args*(argc: Pgint; v: var PPgchar) {.cdecl, 
    importc: "gdk_parse_args", dynlib: lib.}
proc init*(argc: Pgint; v: var PPgchar) {.cdecl, 
    importc: "gdk_init", dynlib: lib.}
proc init_check*(argc: Pgint; v: var PPgchar): gboolean {.
    cdecl, importc: "gdk_init_check", dynlib: lib.}
proc add_option_entries_libgtk_only*(group: PGOptionGroup) {.cdecl, 
    importc: "gdk_add_option_entries_libgtk_only", dynlib: lib.}
proc pre_parse_libgtk_only*() {.cdecl, 
                                    importc: "gdk_pre_parse_libgtk_only", 
                                    dynlib: lib.}
proc get_program_class*(): CSTRING {.cdecl, 
    importc: "gdk_get_program_class", dynlib: lib.}
proc set_program_class*(program_class: CSTRING) {.cdecl, 
    importc: "gdk_set_program_class", dynlib: lib.}
proc notify_startup_complete*() {.cdecl, 
                                      importc: "gdk_notify_startup_complete", 
                                      dynlib: lib.}
proc notify_startup_complete_with_id*(startup_id: CSTRING) {.cdecl, 
    importc: "gdk_notify_startup_complete_with_id", dynlib: lib.}
proc error_trap_push*() {.cdecl, importc: "gdk_error_trap_push", 
                              dynlib: lib.}
proc error_trap_pop*(): gint {.cdecl, importc: "gdk_error_trap_pop", 
                                   dynlib: lib.}
proc error_trap_pop_ignored*() {.cdecl, 
                                     importc: "gdk_error_trap_pop_ignored", 
                                     dynlib: lib.}
proc get_display_arg_name*(): CSTRING {.cdecl, 
    importc: "gdk_get_display_arg_name", dynlib: lib.}
proc get_display*(): CSTRING {.cdecl, importc: "gdk_get_display", 
                                     dynlib: lib.}
when not(defined(MULTIDEVICE_SAFE)): 
  proc pointer_grab*(window: PGdkWindow; owner_events: gboolean; 
                         event_mask: TEventMask; confine_to: PGdkWindow; 
                         cursor: PGdkCursor; time: guint32): TGrabStatus {.
      cdecl, importc: "gdk_pointer_grab", dynlib: lib.}
  proc keyboard_grab*(window: PGdkWindow; owner_events: gboolean; 
                          time: guint32): TGrabStatus {.cdecl, 
      importc: "gdk_keyboard_grab", dynlib: lib.}
when not(defined(MULTIHEAD_SAFE)): 
  when not(defined(MULTIDEVICE_SAFE)): 
    proc pointer_ungrab*(time: guint32) {.cdecl, 
        importc: "gdk_pointer_ungrab", dynlib: lib.}
    proc keyboard_ungrab*(time: guint32) {.cdecl, 
        importc: "gdk_keyboard_ungrab", dynlib: lib.}
    proc pointer_is_grabbed*(): gboolean {.cdecl, 
        importc: "gdk_pointer_is_grabbed", dynlib: lib.}
  proc screen_width*(): gint {.cdecl, importc: "gdk_screen_width", 
                                   dynlib: lib.}
  proc screen_height*(): gint {.cdecl, importc: "gdk_screen_height", 
                                    dynlib: lib.}
  proc screen_width_mm*(): gint {.cdecl, importc: "gdk_screen_width_mm", 
                                      dynlib: lib.}
  proc screen_height_mm*(): gint {.cdecl, importc: "gdk_screen_height_mm", 
      dynlib: lib.}
  proc set_double_click_time*(msec: guint) {.cdecl, 
      importc: "gdk_set_double_click_time", dynlib: lib.}
  proc beep*() {.cdecl, importc: "gdk_beep", dynlib: lib.}
proc flush*() {.cdecl, importc: "gdk_flush", dynlib: lib.}
proc disable_multidevice*() {.cdecl, importc: "gdk_disable_multidevice", 
                                  dynlib: lib.}
proc set_allowed_backends*(backends: CSTRING) {.cdecl, 
    importc: "gdk_set_allowed_backends", dynlib: lib.}

proc pango_context_get_for_screen*(screen: PGdkScreen): Pango.PContext {.
    cdecl, importc: "gdk_pango_context_get_for_screen", dynlib: lib.}
when not(defined(MULTIHEAD_SAFE)): 
  proc pango_context_get*(): Pango.PContext {.cdecl, 
      importc: "gdk_pango_context_get", dynlib: lib.}
proc pango_layout_line_get_clip_region*(line: PLayoutLine; 
    x_origin: gint; y_origin: gint; index_ranges: Pgint; n_ranges: gint): Pcairo_region_t {.
    cdecl, importc: "gdk_pango_layout_line_get_clip_region", dynlib: lib.}
proc pango_layout_get_clip_region*(layout: PLayout; 
    x_origin: gint; y_origin: gint; index_ranges: Pgint; n_ranges: gint): Pcairo_region_t {.
    cdecl, importc: "gdk_pango_layout_get_clip_region", dynlib: lib.}

type 
  TPropMode* {.size: sizeof(cint).} = enum 
    PROP_MODE_REPLACE, PROP_MODE_PREPEND, PROP_MODE_APPEND
proc atom_intern*(atom_name: CSTRING; only_if_exists: gboolean): TGdkAtom {.
    cdecl, importc: "gdk_atom_intern", dynlib: lib.}
proc atom_intern_static_string*(atom_name: CSTRING): TGdkAtom {.cdecl, 
    importc: "gdk_atom_intern_static_string", dynlib: lib.}
proc name*(atom: TGdkAtom): CSTRING {.cdecl, 
    importc: "gdk_atom_name", dynlib: lib.}
proc property_get*(window: PGdkWindow; property: TGdkAtom; 
                       typ: TGdkAtom; offset: gulong; length: gulong; 
                       pdelete: gint; actual_property_type: PGdkAtom; 
                       actual_format: Pgint; actual_length: Pgint; 
                       data: ptr Pguchar): gboolean {.cdecl, 
    importc: "gdk_property_get", dynlib: lib.}
proc property_change*(window: PGdkWindow; property: TGdkAtom; 
                          typ: TGdkAtom; format: gint; mode: TPropMode; 
                          data: Pguchar; nelements: gint) {.cdecl, 
    importc: "gdk_property_change", dynlib: lib.}
proc gdk_property_delete*(window: PGdkWindow; property: TGdkAtom) {.cdecl, 
    importc: "gdk_property_delete", dynlib: lib.}
proc text_property_to_utf8_list_for_display*(display: PGdkDisplay; 
    encoding: TGdkAtom; format: gint; text: Pguchar; length: gint; 
    t: var PPgchar): gint {.cdecl, importc: "gdk_text_property_to_utf8_list_for_display", 
                                     dynlib: lib.}
proc utf8_to_string_target*(str: CSTRING): CSTRING {.cdecl, 
    importc: "gdk_utf8_to_string_target", dynlib: lib.}

proc intersect*(src1: PRectangle; src2: PRectangle; 
                              dest: PRectangle): gboolean {.cdecl, 
    importc: "gdk_rectangle_intersect", dynlib: lib.}
proc union*(src1: PRectangle; src2: PRectangle; 
                          dest: PRectangle) {.cdecl, 
    importc: "gdk_rectangle_union", dynlib: lib.}
proc rectangle_get_type*(): GType {.cdecl, 
    importc: "gdk_rectangle_get_type", dynlib: lib.}
template TYPE_RECTANGLE*(): expr = 
  (gdk_rectangle_get_type())


template SELECTION_PRIMARY*(): expr = 
  MAKE_ATOM(1)

template SELECTION_SECONDARY*(): expr = 
  MAKE_ATOM(2)

template SELECTION_CLIPBOARD*(): expr = 
  MAKE_ATOM(69)

template TARGET_BITMAP*(): expr = 
  MAKE_ATOM(5)

template TARGET_COLORMAP*(): expr = 
  MAKE_ATOM(7)

template TARGET_DRAWABLE*(): expr = 
  MAKE_ATOM(17)

template TARGET_PIXMAP*(): expr = 
  MAKE_ATOM(20)

template TARGET_STRING*(): expr = 
  MAKE_ATOM(31)

template SELECTION_TYPE_ATOM*(): expr = 
  MAKE_ATOM(4)

template SELECTION_TYPE_BITMAP*(): expr = 
  MAKE_ATOM(5)

template SELECTION_TYPE_COLORMAP*(): expr = 
  MAKE_ATOM(7)

template SELECTION_TYPE_DRAWABLE*(): expr = 
  MAKE_ATOM(17)

template SELECTION_TYPE_INTEGER*(): expr = 
  MAKE_ATOM(19)

template SELECTION_TYPE_PIXMAP*(): expr = 
  MAKE_ATOM(20)

template SELECTION_TYPE_WINDOW*(): expr = 
  MAKE_ATOM(33)

template SELECTION_TYPE_STRING*(): expr = 
  MAKE_ATOM(31)

when not(defined(MULTIHEAD_SAFE)): 
  proc selection_owner_set*(owner: PGdkWindow; selection: TGdkAtom; 
                                time: guint32; send_event: gboolean): gboolean {.
      cdecl, importc: "gdk_selection_owner_set", dynlib: lib.}
  proc owner_get*(selection: TGdkAtom): PGdkWindow {.cdecl, 
      importc: "gdk_selection_owner_get", dynlib: lib.}
proc selection_owner_set_for_display*(display: PGdkDisplay; 
    owner: PGdkWindow; selection: TGdkAtom; time: guint32; 
    send_event: gboolean): gboolean {.cdecl, importc: "gdk_selection_owner_set_for_display", 
                                      dynlib: lib.}
proc selection_owner_get_for_display*(display: PGdkDisplay; 
    selection: TGdkAtom): PGdkWindow {.cdecl, 
    importc: "gdk_selection_owner_get_for_display", dynlib: lib.}
proc selection_convert*(requestor: PGdkWindow; selection: TGdkAtom; 
                            target: TGdkAtom; time: guint32) {.cdecl, 
    importc: "gdk_selection_convert", dynlib: lib.}
proc selection_property_get*(requestor: PGdkWindow; 
                                 data: ptr Pguchar; prop_type: PGdkAtom; 
                                 prop_format: Pgint): gint {.cdecl, 
    importc: "gdk_selection_property_get", dynlib: lib.}
proc selection_send_notify*(requestor: PGdkWindow; selection: TGdkAtom; 
                                target: TGdkAtom; property: TGdkAtom; 
                                time: guint32) {.cdecl, 
    importc: "gdk_selection_send_notify", dynlib: lib.}
proc selection_send_notify_for_display*(display: PGdkDisplay; 
    requestor: PGdkWindow; selection: TGdkAtom; target: TGdkAtom; 
    property: TGdkAtom; time: guint32) {.cdecl, 
    importc: "gdk_selection_send_notify_for_display", dynlib: lib.}

type 
  TGdkWindowWindowClass* {.size: sizeof(cint).} = enum 
    INPUT_OUTPUT, INPUT_ONLY
type 
  TGdkWindowType* {.size: sizeof(cint).} = enum 
    WINDOW_ROOT, WINDOW_TOPLEVEL, WINDOW_CHILD, WINDOW_TEMP, 
    WINDOW_FOREIGN, WINDOW_OFFSCREEN
type 
  TGdkWindowAttributesType* {.size: sizeof(cint).} = enum 
    WA_TITLE = 1 shl 1, WA_X = 1 shl 2, WA_Y = 1 shl 3, 
    WA_CURSOR = 1 shl 4, WA_VISUAL = 1 shl 5, 
    WA_WMCLASS = 1 shl 6, WA_NOREDIR = 1 shl 7, 
    WA_TYPE_HINT = 1 shl 8
type 
  TWindowHints* {.size: sizeof(cint).} = enum 
    HINT_POS = 1 shl 0, HINT_MIN_SIZE = 1 shl 1, 
    HINT_MAX_SIZE = 1 shl 2, HINT_BASE_SIZE = 1 shl 3, 
    HINT_ASPECT = 1 shl 4, HINT_RESIZE_INC = 1 shl 5, 
    HINT_WIN_GRAVITY = 1 shl 6, HINT_USER_POS = 1 shl 7, 
    HINT_USER_SIZE = 1 shl 8
type 
  TGdkWindowTypeHint* {.size: sizeof(cint).} = enum 
    WINDOW_TYPE_HINT_NORMAL, WINDOW_TYPE_HINT_DIALOG, 
    WINDOW_TYPE_HINT_MENU, WINDOW_TYPE_HINT_TOOLBAR, 
    WINDOW_TYPE_HINT_SPLASHSCREEN, WINDOW_TYPE_HINT_UTILITY, 
    WINDOW_TYPE_HINT_DOCK, WINDOW_TYPE_HINT_DESKTOP, 
    WINDOW_TYPE_HINT_DROPDOWN_MENU, WINDOW_TYPE_HINT_POPUP_MENU, 
    WINDOW_TYPE_HINT_TOOLTIP, WINDOW_TYPE_HINT_NOTIFICATION, 
    WINDOW_TYPE_HINT_COMBO, WINDOW_TYPE_HINT_DND
type 
  PWMDecoration* = ptr TWMDecoration
  TWMDecoration* {.size: sizeof(cint).} = enum 
    DECOR_ALL = 1 shl 0, DECOR_BORDER = 1 shl 1, 
    DECOR_RESIZEH = 1 shl 2, DECOR_TITLE = 1 shl 3, 
    DECOR_MENU = 1 shl 4, DECOR_MINIMIZE = 1 shl 5, 
    DECOR_MAXIMIZE = 1 shl 6
type 
  TWMFunction* {.size: sizeof(cint).} = enum 
    FUNC_ALL = 1 shl 0, FUNC_RESIZE = 1 shl 1, 
    FUNC_MOVE = 1 shl 2, FUNC_MINIMIZE = 1 shl 3, 
    FUNC_MAXIMIZE = 1 shl 4, FUNC_CLOSE = 1 shl 5
type 
  TGravity* {.size: sizeof(cint).} = enum 
    GRAVITY_NORTH_WEST = 1, GRAVITY_NORTH, GRAVITY_NORTH_EAST, 
    GRAVITY_WEST, GRAVITY_CENTER, GRAVITY_EAST, 
    GRAVITY_SOUTH_WEST, GRAVITY_SOUTH, GRAVITY_SOUTH_EAST, 
    GRAVITY_STATIC
type 
  TWindowEdge* {.size: sizeof(cint).} = enum 
    WINDOW_EDGE_NORTH_WEST, WINDOW_EDGE_NORTH, 
    WINDOW_EDGE_NORTH_EAST, WINDOW_EDGE_WEST, WINDOW_EDGE_EAST, 
    WINDOW_EDGE_SOUTH_WEST, WINDOW_EDGE_SOUTH, 
    WINDOW_EDGE_SOUTH_EAST
type 
  TFullscreenMode* {.size: sizeof(cint).} = enum 
    FULLSCREEN_ON_CURRENT_MONITOR, FULLSCREEN_ON_ALL_MONITORS
type 
  PGdkWindowAttr* = ptr TGdkWindowAttr
  TGdkWindowAttr*{.final, pure.} = object 
    title*: CSTRING
    event_mask*: gint
    x*: gint
    y*: gint
    width*: gint
    height*: gint
    wclass*: TGdkWindowWindowClass
    visual*: PGdkVisual
    window_type*: TGdkWindowType
    cursor*: PGdkCursor
    wmclass_name*: CSTRING
    wmclass_class*: CSTRING
    override_redirect*: gboolean
    type_hint*: TGdkWindowTypeHint

type 
  PGeometry* = ptr TGeometry
  TGeometry*{.final, pure.} = object 
    min_width*: gint
    min_height*: gint
    max_width*: gint
    max_height*: gint
    base_width*: gint
    base_height*: gint
    width_inc*: gint
    height_inc*: gint
    min_aspect*: gdouble
    max_aspect*: gdouble
    win_gravity*: TGravity

template TYPE_WINDOW*(): expr = 
  (gdk_window_get_type())

template WINDOW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WINDOW, TGdkWindow))

template WINDOW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WINDOW, TGdkWindowClass))

template IS_WINDOW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WINDOW))

template IS_WINDOW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WINDOW))

template WINDOW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WINDOW, TGdkWindowClass))

type 
  PGdkWindowClass* = ptr TGdkWindowClass
  TGdkWindowClass* = object of TGObjectClass
    pick_embedded_child*: proc (window: PGdkWindow; x: gdouble; y: gdouble): PGdkWindow {.
        cdecl.}
    to_embedder*: proc (window: PGdkWindow; offscreen_x: gdouble; 
                        offscreen_y: gdouble; embedder_x: Pgdouble; 
                        embedder_y: Pgdouble) {.cdecl.}
    from_embedder*: proc (window: PGdkWindow; embedder_x: gdouble; 
                          embedder_y: gdouble; offscreen_x: Pgdouble; 
                          offscreen_y: Pgdouble) {.cdecl.}
    create_surface*: proc (window: PGdkWindow; width: gint; height: gint): PSurface {.
        cdecl.}
    gdk_reserved1: proc () {.cdecl.}
    gdk_reserved2: proc () {.cdecl.}
    gdk_reserved3: proc () {.cdecl.}
    gdk_reserved4: proc () {.cdecl.}
    gdk_reserved5: proc () {.cdecl.}
    gdk_reserved6: proc () {.cdecl.}
    gdk_reserved7: proc () {.cdecl.}
    gdk_reserved8: proc () {.cdecl.}

proc window_get_type*(): GType {.cdecl, importc: "gdk_window_get_type", 
                                     dynlib: lib.}
proc window_new*(parent: PGdkWindow; attributes: PGdkWindowAttr; 
                     attributes_mask: gint): PGdkWindow {.cdecl, 
    importc: "gdk_window_new", dynlib: lib.}
proc window_destroy*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_destroy", dynlib: lib.}
proc get_window_type*(window: PGdkWindow): TGdkWindowType {.
    cdecl, importc: "gdk_window_get_window_type", dynlib: lib.}
proc is_destroyed*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_is_destroyed", dynlib: lib.}
proc get_visual*(window: PGdkWindow): PGdkVisual {.cdecl, 
    importc: "gdk_window_get_visual", dynlib: lib.}
proc get_screen*(window: PGdkWindow): PGdkScreen {.cdecl, 
    importc: "gdk_window_get_screen", dynlib: lib.}
proc get_display*(window: PGdkWindow): PGdkDisplay {.cdecl, 
    importc: "gdk_window_get_display", dynlib: lib.}
when not(defined(MULTIDEVICE_SAFE)): 
  proc window_at_pointer*(win_x: Pgint; win_y: Pgint): PGdkWindow {.
      cdecl, importc: "gdk_window_at_pointer", dynlib: lib.}
proc show*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_show", dynlib: lib.}
proc hide*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_hide", dynlib: lib.}
proc withdraw*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_withdraw", dynlib: lib.}
proc show_unraised*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_show_unraised", dynlib: lib.}
proc move*(window: PGdkWindow; x: gint; y: gint) {.cdecl, 
    importc: "gdk_window_move", dynlib: lib.}
proc resize*(window: PGdkWindow; width: gint; height: gint) {.
    cdecl, importc: "gdk_window_resize", dynlib: lib.}
proc move_resize*(window: PGdkWindow; x: gint; y: gint; 
                             width: gint; height: gint) {.cdecl, 
    importc: "gdk_window_move_resize", dynlib: lib.}
proc reparent*(window: PGdkWindow; new_parent: PGdkWindow; 
                          x: gint; y: gint) {.cdecl, 
    importc: "gdk_window_reparent", dynlib: lib.}
proc window_raise*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_raise", dynlib: lib.}
proc lower*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_lower", dynlib: lib.}
proc restack*(window: PGdkWindow; sibling: PGdkWindow; 
                         above: gboolean) {.cdecl, 
    importc: "gdk_window_restack", dynlib: lib.}
proc focus*(window: PGdkWindow; timestamp: guint32) {.cdecl, 
    importc: "gdk_window_focus", dynlib: lib.}
proc set_user_data*(window: PGdkWindow; user_data: gpointer) {.
    cdecl, importc: "gdk_window_set_user_data", dynlib: lib.}
proc set_override_redirect*(window: PGdkWindow; 
    override_redirect: gboolean) {.cdecl, importc: "gdk_window_set_override_redirect", 
                                   dynlib: lib.}
proc get_accept_focus*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_get_accept_focus", dynlib: lib.}
proc set_accept_focus*(window: PGdkWindow; 
                                  accept_focus: gboolean) {.cdecl, 
    importc: "gdk_window_set_accept_focus", dynlib: lib.}
proc get_focus_on_map*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_get_focus_on_map", dynlib: lib.}
proc set_focus_on_map*(window: PGdkWindow; 
                                  focus_on_map: gboolean) {.cdecl, 
    importc: "gdk_window_set_focus_on_map", dynlib: lib.}
proc add_filter*(window: PGdkWindow; function: TFilterFunc; 
                            data: gpointer) {.cdecl, 
    importc: "gdk_window_add_filter", dynlib: lib.}
proc remove_filter*(window: PGdkWindow; function: TFilterFunc; 
                               data: gpointer) {.cdecl, 
    importc: "gdk_window_remove_filter", dynlib: lib.}
proc window_scroll*(window: PGdkWindow; dx: gint; dy: gint) {.cdecl, 
    importc: "gdk_window_scroll", dynlib: lib.}
proc move_region*(window: PGdkWindow; 
                             region: Pcairo_region_t; dx: gint; dy: gint) {.
    cdecl, importc: "gdk_window_move_region", dynlib: lib.}
proc ensure_native*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_ensure_native", dynlib: lib.}
proc shape_combine_region*(window: PGdkWindow; 
                                      shape_region: Pcairo_region_t; 
                                      offset_x: gint; offset_y: gint) {.cdecl, 
    importc: "gdk_window_shape_combine_region", dynlib: lib.}
proc set_child_shapes*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_set_child_shapes", dynlib: lib.}
proc get_composited*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_get_composited", dynlib: lib.}
proc set_composited*(window: PGdkWindow; composited: gboolean) {.
    cdecl, importc: "gdk_window_set_composited", dynlib: lib.}
proc merge_child_shapes*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_merge_child_shapes", dynlib: lib.}
proc input_shape_combine_region*(window: PGdkWindow; 
    shape_region: Pcairo_region_t; offset_x: gint; offset_y: gint) {.cdecl, 
    importc: "gdk_window_input_shape_combine_region", dynlib: lib.}
proc set_child_input_shapes*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_set_child_input_shapes", dynlib: lib.}
proc merge_child_input_shapes*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_merge_child_input_shapes", dynlib: lib.}
proc is_visible*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_is_visible", dynlib: lib.}
proc is_viewable*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_is_viewable", dynlib: lib.}
proc is_input_only*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_is_input_only", dynlib: lib.}
proc is_shaped*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_is_shaped", dynlib: lib.}
proc get_state*(window: PGdkWindow): TGdkWindowState {.cdecl, 
    importc: "gdk_window_get_state", dynlib: lib.}
proc set_static_gravities*(window: PGdkWindow; 
                                      use_static: gboolean): gboolean {.cdecl, 
    importc: "gdk_window_set_static_gravities", dynlib: lib.}
type 
  TGdkWindowInvalidateHandlerFunc* = proc (window: PGdkWindow; 
      region: Pcairo_region_t) {.cdecl.}
proc set_invalidate_handler*(window: PGdkWindow; 
    handler: TGdkWindowInvalidateHandlerFunc) {.cdecl, 
    importc: "gdk_window_set_invalidate_handler", dynlib: lib.}
proc has_native*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_has_native", dynlib: lib.}
proc set_type_hint*(window: PGdkWindow; hint: TGdkWindowTypeHint) {.
    cdecl, importc: "gdk_window_set_type_hint", dynlib: lib.}
proc get_type_hint*(window: PGdkWindow): TGdkWindowTypeHint {.
    cdecl, importc: "gdk_window_get_type_hint", dynlib: lib.}
proc get_modal_hint*(window: PGdkWindow): gboolean {.cdecl, 
    importc: "gdk_window_get_modal_hint", dynlib: lib.}
proc set_modal_hint*(window: PGdkWindow; modal: gboolean) {.
    cdecl, importc: "gdk_window_set_modal_hint", dynlib: lib.}
proc set_skip_taskbar_hint*(window: PGdkWindow; 
    skips_taskbar: gboolean) {.cdecl, 
                               importc: "gdk_window_set_skip_taskbar_hint", 
                               dynlib: lib.}
proc set_skip_pager_hint*(window: PGdkWindow; 
                                     skips_pager: gboolean) {.cdecl, 
    importc: "gdk_window_set_skip_pager_hint", dynlib: lib.}
proc set_urgency_hint*(window: PGdkWindow; urgent: gboolean) {.
    cdecl, importc: "gdk_window_set_urgency_hint", dynlib: lib.}
proc set_geometry_hints*(window: PGdkWindow; 
                                    geometry: PGeometry; 
                                    geom_mask: TWindowHints) {.cdecl, 
    importc: "gdk_window_set_geometry_hints", dynlib: lib.}
proc get_clip_region*(window: PGdkWindow): Pcairo_region_t {.
    cdecl, importc: "gdk_window_get_clip_region", dynlib: lib.}
proc get_visible_region*(window: PGdkWindow): Pcairo_region_t {.
    cdecl, importc: "gdk_window_get_visible_region", dynlib: lib.}
proc begin_paint_rect*(window: PGdkWindow; 
                                  rectangle: PRectangle) {.cdecl, 
    importc: "gdk_window_begin_paint_rect", dynlib: lib.}
proc begin_paint_region*(window: PGdkWindow; 
                                    region: Pcairo_region_t) {.cdecl, 
    importc: "gdk_window_begin_paint_region", dynlib: lib.}
proc end_paint*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_end_paint", dynlib: lib.}
proc flush*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_flush", dynlib: lib.}
proc set_title*(window: PGdkWindow; title: CSTRING) {.cdecl, 
    importc: "gdk_window_set_title", dynlib: lib.}
proc set_role*(window: PGdkWindow; role: CSTRING) {.cdecl, 
    importc: "gdk_window_set_role", dynlib: lib.}
proc set_startup_id*(window: PGdkWindow; startup_id: CSTRING) {.
    cdecl, importc: "gdk_window_set_startup_id", dynlib: lib.}
proc set_transient_for*(window: PGdkWindow; 
                                   parent: PGdkWindow) {.cdecl, 
    importc: "gdk_window_set_transient_for", dynlib: lib.}
proc set_background*(window: PGdkWindow; color: PColor) {.
    cdecl, importc: "gdk_window_set_background", dynlib: lib.}
proc set_background_rgba*(window: PGdkWindow; rgba: PRGBA) {.
    cdecl, importc: "gdk_window_set_background_rgba", dynlib: lib.}
proc set_background_pattern*(window: PGdkWindow; 
    pattern: PPattern) {.cdecl, importc: "gdk_window_set_background_pattern", 
                                    dynlib: lib.}
proc get_background_pattern*(window: PGdkWindow): PPattern {.
    cdecl, importc: "gdk_window_get_background_pattern", dynlib: lib.}
proc set_cursor*(window: PGdkWindow; cursor: PGdkCursor) {.
    cdecl, importc: "gdk_window_set_cursor", dynlib: lib.}
proc get_cursor*(window: PGdkWindow): PGdkCursor {.cdecl, 
    importc: "gdk_window_get_cursor", dynlib: lib.}
proc set_device_cursor*(window: PGdkWindow; 
                                   device: PDevice; 
                                   cursor: PGdkCursor) {.cdecl, 
    importc: "gdk_window_set_device_cursor", dynlib: lib.}
proc get_device_cursor*(window: PGdkWindow; 
                                   device: PDevice): PGdkCursor {.
    cdecl, importc: "gdk_window_get_device_cursor", dynlib: lib.}
proc get_user_data*(window: PGdkWindow; data: Pgpointer) {.
    cdecl, importc: "gdk_window_get_user_data", dynlib: lib.}
proc get_geometry*(window: PGdkWindow; x: Pgint; y: Pgint; 
                              width: Pgint; height: Pgint) {.cdecl, 
    importc: "gdk_window_get_geometry", dynlib: lib.}
proc get_width*(window: PGdkWindow): cint {.cdecl, 
    importc: "gdk_window_get_width", dynlib: lib.}
proc get_height*(window: PGdkWindow): cint {.cdecl, 
    importc: "gdk_window_get_height", dynlib: lib.}
proc get_position*(window: PGdkWindow; x: Pgint; y: Pgint) {.
    cdecl, importc: "gdk_window_get_position", dynlib: lib.}
proc get_origin*(window: PGdkWindow; x: Pgint; y: Pgint): gint {.
    cdecl, importc: "gdk_window_get_origin", dynlib: lib.}
proc get_root_coords*(window: PGdkWindow; x: gint; y: gint; 
                                 root_x: Pgint; root_y: Pgint) {.cdecl, 
    importc: "gdk_window_get_root_coords", dynlib: lib.}
proc coords_to_parent*(window: PGdkWindow; x: gdouble; 
                                  y: gdouble; parent_x: Pgdouble; 
                                  parent_y: Pgdouble) {.cdecl, 
    importc: "gdk_window_coords_to_parent", dynlib: lib.}
proc coords_from_parent*(window: PGdkWindow; parent_x: gdouble; 
                                    parent_y: gdouble; x: Pgdouble; 
                                    y: Pgdouble) {.cdecl, 
    importc: "gdk_window_coords_from_parent", dynlib: lib.}
proc get_root_origin*(window: PGdkWindow; x: Pgint; 
                                 y: Pgint) {.cdecl, 
    importc: "gdk_window_get_root_origin", dynlib: lib.}
proc get_frame_extents*(window: PGdkWindow; 
                                   rect: PRectangle) {.cdecl, 
    importc: "gdk_window_get_frame_extents", dynlib: lib.}
proc get_scale_factor*(window: PGdkWindow): gint {.cdecl, 
    importc: "gdk_window_get_scale_factor", dynlib: lib.}
when not(defined(MULTIDEVICE_SAFE)): 
  proc get_pointer*(window: PGdkWindow; x: Pgint; 
                               y: Pgint; mask: PModifierType): PGdkWindow {.
      cdecl, importc: "gdk_window_get_pointer", dynlib: lib.}
proc get_device_position*(window: PGdkWindow; 
                                     device: PDevice; x: Pgint; 
                                     y: Pgint; mask: PModifierType): PGdkWindow {.
    cdecl, importc: "gdk_window_get_device_position", dynlib: lib.}
proc get_device_position_double*(window: PGdkWindow; 
    device: PDevice; x: Pgdouble; y: Pgdouble; 
    mask: PModifierType): PGdkWindow {.cdecl, 
    importc: "gdk_window_get_device_position_double", dynlib: lib.}
proc get_parent*(window: PGdkWindow): PGdkWindow {.cdecl, 
    importc: "gdk_window_get_parent", dynlib: lib.}
proc get_toplevel*(window: PGdkWindow): PGdkWindow {.cdecl, 
    importc: "gdk_window_get_toplevel", dynlib: lib.}
proc get_effective_parent*(window: PGdkWindow): PGdkWindow {.
    cdecl, importc: "gdk_window_get_effective_parent", dynlib: lib.}
proc get_effective_toplevel*(window: PGdkWindow): PGdkWindow {.
    cdecl, importc: "gdk_window_get_effective_toplevel", dynlib: lib.}
proc get_children*(window: PGdkWindow): PGList {.cdecl, 
    importc: "gdk_window_get_children", dynlib: lib.}
proc peek_children*(window: PGdkWindow): PGList {.cdecl, 
    importc: "gdk_window_peek_children", dynlib: lib.}
proc get_children_with_user_data*(window: PGdkWindow; 
    user_data: gpointer): PGList {.cdecl, importc: "gdk_window_get_children_with_user_data", 
                                      dynlib: lib.}
proc get_events*(window: PGdkWindow): TEventMask {.cdecl, 
    importc: "gdk_window_get_events", dynlib: lib.}
proc set_events*(window: PGdkWindow; event_mask: TEventMask) {.
    cdecl, importc: "gdk_window_set_events", dynlib: lib.}
proc set_device_events*(window: PGdkWindow; 
                                   device: PDevice; 
                                   event_mask: TEventMask) {.cdecl, 
    importc: "gdk_window_set_device_events", dynlib: lib.}
proc get_device_events*(window: PGdkWindow; 
                                   device: PDevice): TEventMask {.
    cdecl, importc: "gdk_window_get_device_events", dynlib: lib.}
proc set_source_events*(window: PGdkWindow; 
                                   source: TInputSource; 
                                   event_mask: TEventMask) {.cdecl, 
    importc: "gdk_window_set_source_events", dynlib: lib.}
proc get_source_events*(window: PGdkWindow; 
                                   source: TInputSource): TEventMask {.
    cdecl, importc: "gdk_window_get_source_events", dynlib: lib.}
proc set_icon_list*(window: PGdkWindow; pixbufs: PGList) {.
    cdecl, importc: "gdk_window_set_icon_list", dynlib: lib.}
proc set_icon_name*(window: PGdkWindow; name: CSTRING) {.
    cdecl, importc: "gdk_window_set_icon_name", dynlib: lib.}
proc set_group*(window: PGdkWindow; leader: PGdkWindow) {.
    cdecl, importc: "gdk_window_set_group", dynlib: lib.}
proc get_group*(window: PGdkWindow): PGdkWindow {.cdecl, 
    importc: "gdk_window_get_group", dynlib: lib.}
proc set_decorations*(window: PGdkWindow; 
                                 decorations: TWMDecoration) {.cdecl, 
    importc: "gdk_window_set_decorations", dynlib: lib.}
proc get_decorations*(window: PGdkWindow; 
                                 decorations: PWMDecoration): gboolean {.
    cdecl, importc: "gdk_window_get_decorations", dynlib: lib.}
proc set_functions*(window: PGdkWindow; functions: TWMFunction) {.
    cdecl, importc: "gdk_window_set_functions", dynlib: lib.}
proc create_similar_surface*(window: PGdkWindow; 
    content: TContent; width: cint; height: cint): PSurface {.
    cdecl, importc: "gdk_window_create_similar_surface", dynlib: lib.}
proc create_similar_image_surface*(window: PGdkWindow; 
    format: TFormat; width: cint; height: cint; scale: cint): PSurface {.
    cdecl, importc: "gdk_window_create_similar_image_surface", dynlib: lib.}
proc beep*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_beep", dynlib: lib.}
proc iconify*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_iconify", dynlib: lib.}
proc deiconify*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_deiconify", dynlib: lib.}
proc stick*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_stick", dynlib: lib.}
proc unstick*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_unstick", dynlib: lib.}
proc maximize*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_maximize", dynlib: lib.}
proc unmaximize*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_unmaximize", dynlib: lib.}
proc fullscreen*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_fullscreen", dynlib: lib.}
proc set_fullscreen_mode*(window: PGdkWindow; 
                                     mode: TFullscreenMode) {.cdecl, 
    importc: "gdk_window_set_fullscreen_mode", dynlib: lib.}
proc get_fullscreen_mode*(window: PGdkWindow): TFullscreenMode {.
    cdecl, importc: "gdk_window_get_fullscreen_mode", dynlib: lib.}
proc unfullscreen*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_unfullscreen", dynlib: lib.}
proc set_keep_above*(window: PGdkWindow; setting: gboolean) {.
    cdecl, importc: "gdk_window_set_keep_above", dynlib: lib.}
proc set_keep_below*(window: PGdkWindow; setting: gboolean) {.
    cdecl, importc: "gdk_window_set_keep_below", dynlib: lib.}
proc set_opacity*(window: PGdkWindow; opacity: gdouble) {.cdecl, 
    importc: "gdk_window_set_opacity", dynlib: lib.}
proc register_dnd*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_register_dnd", dynlib: lib.}
proc get_drag_protocol*(window: PGdkWindow; 
                                   target: ptr PGdkWindow): TDragProtocol {.
    cdecl, importc: "gdk_window_get_drag_protocol", dynlib: lib.}
proc begin_resize_drag*(window: PGdkWindow; edge: TWindowEdge; 
                                   button: gint; root_x: gint; root_y: gint; 
                                   timestamp: guint32) {.cdecl, 
    importc: "gdk_window_begin_resize_drag", dynlib: lib.}
proc begin_resize_drag_for_device*(window: PGdkWindow; 
    edge: TWindowEdge; device: PDevice; button: gint; root_x: gint; 
    root_y: gint; timestamp: guint32) {.cdecl, 
    importc: "gdk_window_begin_resize_drag_for_device", dynlib: lib.}
proc begin_move_drag*(window: PGdkWindow; button: gint; 
                                 root_x: gint; root_y: gint; 
                                 timestamp: guint32) {.cdecl, 
    importc: "gdk_window_begin_move_drag", dynlib: lib.}
proc begin_move_drag_for_device*(window: PGdkWindow; 
    device: PDevice; button: gint; root_x: gint; root_y: gint; 
    timestamp: guint32) {.cdecl, 
                          importc: "gdk_window_begin_move_drag_for_device", 
                          dynlib: lib.}
proc invalidate_rect*(window: PGdkWindow; 
                                 rect: PRectangle; 
                                 invalidate_children: gboolean) {.cdecl, 
    importc: "gdk_window_invalidate_rect", dynlib: lib.}
proc invalidate_region*(window: PGdkWindow; 
                                   region: Pcairo_region_t; 
                                   invalidate_children: gboolean) {.cdecl, 
    importc: "gdk_window_invalidate_region", dynlib: lib.}
type 
  TGdkWindowChildFunc* = proc (window: PGdkWindow; user_data: gpointer): gboolean {.
      cdecl.}
proc invalidate_maybe_recurse*(window: PGdkWindow; 
    region: Pcairo_region_t; child_func: TGdkWindowChildFunc; 
    user_data: gpointer) {.cdecl, 
                           importc: "gdk_window_invalidate_maybe_recurse", 
                           dynlib: lib.}
proc get_update_area*(window: PGdkWindow): Pcairo_region_t {.
    cdecl, importc: "gdk_window_get_update_area", dynlib: lib.}
proc freeze_updates*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_freeze_updates", dynlib: lib.}
proc thaw_updates*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_thaw_updates", dynlib: lib.}
proc freeze_toplevel_updates_libgtk_only*(window: PGdkWindow) {.
    cdecl, importc: "gdk_window_freeze_toplevel_updates_libgtk_only", 
    dynlib: lib.}
proc thaw_toplevel_updates_libgtk_only*(window: PGdkWindow) {.
    cdecl, importc: "gdk_window_thaw_toplevel_updates_libgtk_only", 
    dynlib: lib.}
proc window_process_all_updates*() {.cdecl, 
    importc: "gdk_window_process_all_updates", dynlib: lib.}
proc process_updates*(window: PGdkWindow; 
                                 update_children: gboolean) {.cdecl, 
    importc: "gdk_window_process_updates", dynlib: lib.}
proc window_set_debug_updates*(setting: gboolean) {.cdecl, 
    importc: "gdk_window_set_debug_updates", dynlib: lib.}
proc window_constrain_size*(geometry: PGeometry; 
                                flags: TWindowHints; width: gint; 
                                height: gint; new_width: Pgint; 
                                new_height: Pgint) {.cdecl, 
    importc: "gdk_window_constrain_size", dynlib: lib.}
proc enable_synchronized_configure*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_enable_synchronized_configure", dynlib: lib.}
proc configure_finished*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_configure_finished", dynlib: lib.}
proc get_default_root_window*(): PGdkWindow {.cdecl, 
    importc: "gdk_get_default_root_window", dynlib: lib.}
proc offscreen_window_get_surface*(window: PGdkWindow): PSurface {.
    cdecl, importc: "gdk_offscreen_window_get_surface", dynlib: lib.}
proc offscreen_window_set_embedder*(window: PGdkWindow; 
    embedder: PGdkWindow) {.cdecl, 
                               importc: "gdk_offscreen_window_set_embedder", 
                               dynlib: lib.}
proc offscreen_window_get_embedder*(window: PGdkWindow): PGdkWindow {.
    cdecl, importc: "gdk_offscreen_window_get_embedder", dynlib: lib.}
proc geometry_changed*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_window_geometry_changed", dynlib: lib.}
proc set_support_multidevice*(window: PGdkWindow; 
    support_multidevice: gboolean) {.cdecl, importc: "gdk_window_set_support_multidevice", 
                                     dynlib: lib.}
proc get_support_multidevice*(window: PGdkWindow): gboolean {.
    cdecl, importc: "gdk_window_get_support_multidevice", dynlib: lib.}
proc get_frame_clock*(window: PGdkWindow): PFrameClock {.
    cdecl, importc: "gdk_window_get_frame_clock", dynlib: lib.}
proc set_opaque_region*(window: PGdkWindow; 
                                   region: Pcairo_region_t) {.cdecl, 
    importc: "gdk_window_set_opaque_region", dynlib: lib.}
proc set_event_compression*(window: PGdkWindow; 
    event_compression: gboolean) {.cdecl, importc: "gdk_window_set_event_compression", 
                                   dynlib: lib.}
proc get_event_compression*(window: PGdkWindow): gboolean {.
    cdecl, importc: "gdk_window_get_event_compression", dynlib: lib.}
proc set_shadow_width*(window: PGdkWindow; left: gint; 
                                  right: gint; top: gint; bottom: gint) {.
    cdecl, importc: "gdk_window_set_shadow_width", dynlib: lib.}

proc test_render_sync*(window: PGdkWindow) {.cdecl, 
    importc: "gdk_test_render_sync", dynlib: lib.}
proc test_simulate_key*(window: PGdkWindow; x: gint; y: gint; 
                            keyval: guint; modifiers: TModifierType; 
                            key_pressrelease: TEventType): gboolean {.cdecl, 
    importc: "gdk_test_simulate_key", dynlib: lib.}
proc test_simulate_button*(window: PGdkWindow; x: gint; y: gint; 
                               button: guint; modifiers: TModifierType; 
                               button_pressrelease: TEventType): gboolean {.
    cdecl, importc: "gdk_test_simulate_button", dynlib: lib.}

template TYPE_VISUAL*(): expr = 
  (gdk_visual_get_type())

template VISUAL*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_VISUAL, TGdkVisual))

template IS_VISUAL*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_VISUAL))

type 
  PGdkVisualType* = ptr TGdkVisualType
  TGdkVisualType* {.size: sizeof(cint).} = enum
    VISUAL_STATIC_GRAY, VISUAL_GRAYSCALE, VISUAL_STATIC_COLOR, 
    VISUAL_PSEUDO_COLOR, VISUAL_TRUE_COLOR, VISUAL_DIRECT_COLOR
proc visual_get_type*(): GType {.cdecl, importc: "gdk_visual_get_type", 
                                     dynlib: lib.}
when not(defined(MULTIHEAD_SAFE)): 
  proc visual_get_best_depth*(): gint {.cdecl, 
      importc: "gdk_visual_get_best_depth", dynlib: lib.}
  proc visual_get_best_type*(): TGdkVisualType {.cdecl, 
      importc: "gdk_visual_get_best_type", dynlib: lib.}
  proc visual_get_system*(): PGdkVisual {.cdecl, 
      importc: "gdk_visual_get_system", dynlib: lib.}
  proc visual_get_best*(): PGdkVisual {.cdecl, 
      importc: "gdk_visual_get_best", dynlib: lib.}
  proc visual_get_best_with_depth*(depth: gint): PGdkVisual {.cdecl, 
      importc: "gdk_visual_get_best_with_depth", dynlib: lib.}
  proc visual_get_best_with_type*(visual_type: TGdkVisualType): PGdkVisual {.
      cdecl, importc: "gdk_visual_get_best_with_type", dynlib: lib.}
  proc visual_get_best_with_both*(depth: gint; visual_type: TGdkVisualType): PGdkVisual {.
      cdecl, importc: "gdk_visual_get_best_with_both", dynlib: lib.}
  proc query_depths*(depths: ptr Pgint; count: Pgint) {.cdecl, 
      importc: "gdk_query_depths", dynlib: lib.}
  proc query_visual_types*(visual_types: ptr PGdkVisualType; 
                               count: Pgint) {.cdecl, 
      importc: "gdk_query_visual_types", dynlib: lib.}
  proc list_visuals*(): PGList {.cdecl, importc: "gdk_list_visuals", 
      dynlib: lib.}
proc get_screen*(visual: PGdkVisual): PGdkScreen {.cdecl, 
    importc: "gdk_visual_get_screen", dynlib: lib.}
proc get_visual_type*(visual: PGdkVisual): TGdkVisualType {.
    cdecl, importc: "gdk_visual_get_visual_type", dynlib: lib.}
proc get_depth*(visual: PGdkVisual): gint {.cdecl, 
    importc: "gdk_visual_get_depth", dynlib: lib.}
proc get_byte_order*(visual: PGdkVisual): TByteOrder {.cdecl, 
    importc: "gdk_visual_get_byte_order", dynlib: lib.}
proc get_colormap_size*(visual: PGdkVisual): gint {.cdecl, 
    importc: "gdk_visual_get_colormap_size", dynlib: lib.}
proc get_bits_per_rgb*(visual: PGdkVisual): gint {.cdecl, 
    importc: "gdk_visual_get_bits_per_rgb", dynlib: lib.}
proc get_red_pixel_details*(visual: PGdkVisual; 
    mask: Pguint32; shift: Pgint; precision: Pgint) {.cdecl, 
    importc: "gdk_visual_get_red_pixel_details", dynlib: lib.}
proc get_green_pixel_details*(visual: PGdkVisual; 
    mask: Pguint32; shift: Pgint; precision: Pgint) {.cdecl, 
    importc: "gdk_visual_get_green_pixel_details", dynlib: lib.}
proc get_blue_pixel_details*(visual: PGdkVisual; 
    mask: Pguint32; shift: Pgint; precision: Pgint) {.cdecl, 
    importc: "gdk_visual_get_blue_pixel_details", dynlib: lib.}
when defined(x11): 
  template TYPE_X11_APP_LAUNCH_CONTEXT*(): expr = 
    (gdk_x11_app_launch_context_get_type())

  template X11_APP_LAUNCH_CONTEXT*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_X11_APP_LAUNCH_CONTEXT, 
                                TX11AppLaunchContext))

  template X11_APP_LAUNCH_CONTEXT_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_X11_APP_LAUNCH_CONTEXT, 
                             TX11AppLaunchContextClass))

  template IS_X11_APP_LAUNCH_CONTEXT*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_X11_APP_LAUNCH_CONTEXT))

  template IS_X11_APP_LAUNCH_CONTEXT_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_X11_APP_LAUNCH_CONTEXT))

  template X11_APP_LAUNCH_CONTEXT_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_X11_APP_LAUNCH_CONTEXT, 
                               TX11AppLaunchContextClass))

  type 
    TX11AppLaunchContext* = TAppLaunchContext
  proc x11_app_launch_context_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_app_launch_context_get_type", dynlib: lib.}
  template TYPE_X11_CURSOR*(): expr = 
    (gdk_x11_cursor_get_type())

  template X11_CURSOR*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_X11_CURSOR, TX11Cursor))

  template X11_CURSOR_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_X11_CURSOR, TX11CursorClass))

  template IS_X11_CURSOR*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_X11_CURSOR))

  template IS_X11_CURSOR_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_X11_CURSOR))

  template X11_CURSOR_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_X11_CURSOR, TX11CursorClass))

  type 
    TX11Cursor* = TGdkCursor
  proc x11_cursor_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_cursor_get_type", dynlib: lib.}
  proc get_xdisplay*(cursor: PGdkCursor): PDisplay {.
      cdecl, importc: "gdk_x11_cursor_get_xdisplay", dynlib: lib.}
  proc get_xcursor*(cursor: PGdkCursor): TCursor {.cdecl, 
      importc: "gdk_x11_cursor_get_xcursor", dynlib: lib.}
  template CURSOR_XDISPLAY*(cursor: expr): expr = 
    (gdk_x11_cursor_get_xdisplay(cursor))

  template CURSOR_XCURSOR*(cursor: expr): expr = 
    (gdk_x11_cursor_get_xcursor(cursor))

  proc get_id*(device: PDevice): gint {.cdecl, 
      importc: "gdk_x11_device_get_id", dynlib: lib.}
  template TYPE_X11_DEVICE_CORE*(): expr = 
    (gdk_x11_device_core_get_type())

  template X11_DEVICE_CORE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_X11_DEVICE_CORE, 
                                X11DeviceCore))

  template X11_DEVICE_CORE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((c), TYPE_X11_DEVICE_CORE, 
                             X11DeviceCoreClass))

  template IS_X11_DEVICE_CORE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_X11_DEVICE_CORE))

  template IS_X11_DEVICE_CORE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_X11_DEVICE_CORE))

  template X11_DEVICE_CORE_GET_CLASS*(o: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_X11_DEVICE_CORE, 
                               X11DeviceCoreClass))

  proc x11_device_core_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_device_core_get_type", dynlib: lib.}
  template TYPE_X11_DEVICE_XI2*(): expr = 
    (gdk_x11_device_xi2_get_type())

  template X11_DEVICE_XI2*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_X11_DEVICE_XI2, X11DeviceXI2))

  template X11_DEVICE_XI2_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((c), TYPE_X11_DEVICE_XI2, 
                             X11DeviceXI2Class))

  template IS_X11_DEVICE_XI2*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_X11_DEVICE_XI2))

  template IS_X11_DEVICE_XI2_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_X11_DEVICE_XI2))

  template X11_DEVICE_XI2_GET_CLASS*(o: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_X11_DEVICE_XI2, 
                               X11DeviceXI2Class))

  proc x11_device_xi2_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_device_xi2_get_type", dynlib: lib.}
  proc lookup*(device_manager: PDeviceManager; 
                                      device_id: gint): PDevice {.cdecl, 
      importc: "gdk_x11_device_manager_lookup", dynlib: lib.}
  template TYPE_X11_DEVICE_MANAGER_CORE*(): expr = 
    (gdk_x11_device_manager_core_get_type())

  template X11_DEVICE_MANAGER_CORE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_X11_DEVICE_MANAGER_CORE, 
                                X11DeviceManagerCore))

  template X11_DEVICE_MANAGER_CORE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((c), TYPE_X11_DEVICE_MANAGER_CORE, 
                             X11DeviceManagerCoreClass))

  template IS_X11_DEVICE_MANAGER_CORE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_X11_DEVICE_MANAGER_CORE))

  template IS_X11_DEVICE_MANAGER_CORE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_X11_DEVICE_MANAGER_CORE))

  template X11_DEVICE_MANAGER_CORE_GET_CLASS*(o: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_X11_DEVICE_MANAGER_CORE, 
                               X11DeviceManagerCoreClass))

  proc x11_device_manager_core_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_device_manager_core_get_type", dynlib: lib.}
  template TYPE_X11_DEVICE_MANAGER_XI2*(): expr = 
    (gdk_x11_device_manager_xi2_get_type())

  template X11_DEVICE_MANAGER_XI2*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_X11_DEVICE_MANAGER_XI2, 
                                X11DeviceManagerXI2))

  template X11_DEVICE_MANAGER_XI2_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((c), TYPE_X11_DEVICE_MANAGER_XI2, 
                             X11DeviceManagerXI2Class))

  template IS_X11_DEVICE_MANAGER_XI2*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_X11_DEVICE_MANAGER_XI2))

  template IS_X11_DEVICE_MANAGER_XI2_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_X11_DEVICE_MANAGER_XI2))

  template X11_DEVICE_MANAGER_XI2_GET_CLASS*(o: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_X11_DEVICE_MANAGER_XI2, 
                               X11DeviceManagerXI2Class))

  proc x11_device_manager_xi2_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_device_manager_xi2_get_type", dynlib: lib.}
  type 
    TX11Display* = TGdkDisplay
  template TYPE_X11_DISPLAY*(): expr = 
    (gdk_x11_display_get_type())

  template X11_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_X11_DISPLAY, TX11Display))

  template X11_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_X11_DISPLAY, TX11DisplayClass))

  template IS_X11_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_X11_DISPLAY))

  template IS_X11_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_X11_DISPLAY))

  template X11_DISPLAY_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_X11_DISPLAY, TX11DisplayClass))

  proc x11_display_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_display_get_type", dynlib: lib.}
  proc get_xdisplay*(display: PGdkDisplay): PDisplay {.
      cdecl, importc: "gdk_x11_display_get_xdisplay", dynlib: lib.}
  template DISPLAY_XDISPLAY*(display: expr): expr = 
    (gdk_x11_display_get_xdisplay(display))

  proc get_user_time*(display: PGdkDisplay): guint32 {.
      cdecl, importc: "gdk_x11_display_get_user_time", dynlib: lib.}
  proc get_startup_notification_id*(display: PGdkDisplay): CSTRING {.
      cdecl, importc: "gdk_x11_display_get_startup_notification_id", 
      dynlib: lib.}
  proc set_startup_notification_id*(display: PGdkDisplay; 
      startup_id: CSTRING) {.cdecl, importc: "gdk_x11_display_set_startup_notification_id", 
                               dynlib: lib.}
  proc set_cursor_theme*(display: PGdkDisplay; 
      theme: CSTRING; size: gint) {.cdecl, importc: "gdk_x11_display_set_cursor_theme", 
                                      dynlib: lib.}
  proc broadcast_startup_message*(display: PGdkDisplay; 
      message_type: cstring) {.varargs, cdecl, importc: "gdk_x11_display_broadcast_startup_message", 
                               dynlib: lib.}
  proc x11_lookup_xdisplay*(xdisplay: PDisplay): PGdkDisplay {.
      cdecl, importc: "gdk_x11_lookup_xdisplay", dynlib: lib.}
  proc grab*(display: PGdkDisplay) {.cdecl, 
      importc: "gdk_x11_display_grab", dynlib: lib.}
  proc ungrab*(display: PGdkDisplay) {.cdecl, 
      importc: "gdk_x11_display_ungrab", dynlib: lib.}
  proc set_window_scale*(display: PGdkDisplay; scale: gint) {.
      cdecl, importc: "gdk_x11_display_set_window_scale", dynlib: lib.}
  proc error_trap_push*(display: PGdkDisplay) {.cdecl, 
      importc: "gdk_x11_display_error_trap_push", dynlib: lib.}
  proc error_trap_pop*(display: PGdkDisplay): gint {.cdecl, 
      importc: "gdk_x11_display_error_trap_pop", dynlib: lib.}
  proc error_trap_pop_ignored*(display: PGdkDisplay) {.
      cdecl, importc: "gdk_x11_display_error_trap_pop_ignored", dynlib: lib.}
  proc x11_register_standard_event_type*(display: PGdkDisplay; 
      event_base: gint; n_events: gint) {.cdecl, 
      importc: "gdk_x11_register_standard_event_type", dynlib: lib.}
  proc x11_set_sm_client_id*(sm_client_id: CSTRING) {.cdecl, 
      importc: "gdk_x11_set_sm_client_id", dynlib: lib.}
  type 
    TX11DisplayManager* = TGdkDisplayManager
  template TYPE_X11_DISPLAY_MANAGER*(): expr = 
    (gdk_x11_display_manager_get_type())

  template X11_DISPLAY_MANAGER*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_X11_DISPLAY_MANAGER, 
                                TX11DisplayManager))

  template X11_DISPLAY_MANAGER_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_X11_DISPLAY_MANAGER, 
                             TX11DisplayManagerClass))

  template IS_X11_DISPLAY_MANAGER*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_X11_DISPLAY_MANAGER))

  template IS_X11_DISPLAY_MANAGER_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_X11_DISPLAY_MANAGER))

  template X11_DISPLAY_MANAGER_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_X11_DISPLAY_MANAGER, 
                               TX11DisplayManagerClass))

  proc x11_display_manager_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_display_manager_get_type", dynlib: lib.}
  template TYPE_X11_DRAG_CONTEXT*(): expr = 
    (gdk_x11_drag_context_get_type())

  template X11_DRAG_CONTEXT*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_X11_DRAG_CONTEXT, 
                                TX11DragContext))

  template X11_DRAG_CONTEXT_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_X11_DRAG_CONTEXT, 
                             TX11DragContextClass))

  template IS_X11_DRAG_CONTEXT*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_X11_DRAG_CONTEXT))

  template IS_X11_DRAG_CONTEXT_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_X11_DRAG_CONTEXT))

  template X11_DRAG_CONTEXT_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_X11_DRAG_CONTEXT, 
                               TX11DragContextClass))

  type 
    TX11DragContext* = TDragContext
  proc x11_drag_context_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_drag_context_get_type", dynlib: lib.}
  type 
    TX11Keymap* = TKeymap
  template TYPE_X11_KEYMAP*(): expr = 
    (gdk_x11_keymap_get_type())

  template X11_KEYMAP*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_X11_KEYMAP, TX11Keymap))

  template X11_KEYMAP_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_X11_KEYMAP, TX11KeymapClass))

  template IS_X11_KEYMAP*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_X11_KEYMAP))

  template IS_X11_KEYMAP_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_X11_KEYMAP))

  template X11_KEYMAP_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_X11_KEYMAP, TX11KeymapClass))

  proc x11_keymap_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_keymap_get_type", dynlib: lib.}
  proc get_group_for_state*(keymap: PKeymap; state: guint): gint {.
      cdecl, importc: "gdk_x11_keymap_get_group_for_state", dynlib: lib.}
  proc key_is_modifier*(keymap: PKeymap; keycode: guint): gboolean {.
      cdecl, importc: "gdk_x11_keymap_key_is_modifier", dynlib: lib.}
  proc x11_atom_to_xatom_for_display*(display: PGdkDisplay; 
      atom: TGdkAtom): Atom {.cdecl, 
                             importc: "gdk_x11_atom_to_xatom_for_display", 
                             dynlib: lib.}
  proc x11_xatom_to_atom_for_display*(display: PGdkDisplay; xatom: Atom): TGdkAtom {.
      cdecl, importc: "gdk_x11_xatom_to_atom_for_display", dynlib: lib.}
  proc x11_get_xatom_by_name_for_display*(display: PGdkDisplay; 
      atom_name: CSTRING): Atom {.cdecl, importc: "gdk_x11_get_xatom_by_name_for_display", 
                                    dynlib: lib.}
  proc x11_get_xatom_name_for_display*(display: PGdkDisplay; 
      xatom: Atom): CSTRING {.cdecl, importc: "gdk_x11_get_xatom_name_for_display", 
                                dynlib: lib.}
  when not(defined(MULTIHEAD_SAFE)): 
    proc to_xatom*(atom: TGdkAtom): Atom {.cdecl, 
        importc: "gdk_x11_atom_to_xatom", dynlib: lib.}
    proc to_atom*(xatom: Atom): TGdkAtom {.cdecl, 
        importc: "gdk_x11_xatom_to_atom", dynlib: lib.}
    proc x11_get_xatom_by_name*(atom_name: CSTRING): Atom {.cdecl, 
        importc: "gdk_x11_get_xatom_by_name", dynlib: lib.}
    proc x11_get_xatom_name*(xatom: Atom): CSTRING {.cdecl, 
        importc: "gdk_x11_get_xatom_name", dynlib: lib.}
  template TYPE_X11_SCREEN*(): expr = 
    (gdk_x11_screen_get_type())

  template X11_SCREEN*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_X11_SCREEN, TX11Screen))

  template X11_SCREEN_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_X11_SCREEN, TX11ScreenClass))

  template IS_X11_SCREEN*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_X11_SCREEN))

  template IS_X11_SCREEN_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_X11_SCREEN))

  template X11_SCREEN_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_X11_SCREEN, TX11ScreenClass))

  type 
    TX11Screen* = TGdkScreen
  proc x11_screen_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_screen_get_type", dynlib: lib.}
  proc get_xscreen*(screen: PGdkScreen): PScreen {.cdecl, 
      importc: "gdk_x11_screen_get_xscreen", dynlib: lib.}
  proc get_screen_number*(screen: PGdkScreen): cint {.cdecl, 
      importc: "gdk_x11_screen_get_screen_number", dynlib: lib.}
  proc get_window_manager_name*(screen: PGdkScreen): cstring {.
      cdecl, importc: "gdk_x11_screen_get_window_manager_name", dynlib: lib.}
  when not(defined(MULTIHEAD_SAFE)): 
    proc x11_get_default_screen*(): gint {.cdecl, 
        importc: "gdk_x11_get_default_screen", dynlib: lib.}
  template SCREEN_XDISPLAY*(screen: expr): expr = 
    (gdk_x11_display_get_xdisplay(gdk_screen_get_display(screen)))

  template SCREEN_XSCREEN*(screen: expr): expr = 
    (gdk_x11_screen_get_xscreen(screen))

  template SCREEN_XNUMBER*(screen: expr): expr = 
    (gdk_x11_screen_get_screen_number(screen))

  proc supports_net_wm_hint*(screen: PGdkScreen; 
      property: TGdkAtom): gboolean {.cdecl, importc: "gdk_x11_screen_supports_net_wm_hint", 
                                     dynlib: lib.}
  proc get_monitor_output*(screen: PGdkScreen; 
      monitor_num: gint): XID {.cdecl, 
                                importc: "gdk_x11_screen_get_monitor_output", 
                                dynlib: lib.}
  proc get_number_of_desktops*(screen: PGdkScreen): guint32 {.
      cdecl, importc: "gdk_x11_screen_get_number_of_desktops", dynlib: lib.}
  proc get_current_desktop*(screen: PGdkScreen): guint32 {.
      cdecl, importc: "gdk_x11_screen_get_current_desktop", dynlib: lib.}
  proc text_property_to_text_list*(display: PGdkDisplay; 
      encoding: TGdkAtom; format: gint; text: Pguchar; length: gint; 
      t: var PPgchar): gint {.cdecl, 
      importc: "gdk_x11_display_text_property_to_text_list", dynlib: lib.}
  proc x11_free_text_list*(list: ptr CSTRING) {.cdecl, 
      importc: "gdk_x11_free_text_list", dynlib: lib.}
  proc string_to_compound_text*(display: PGdkDisplay; 
      str: CSTRING; encoding: PGdkAtom; format: Pgint; 
      ctext: ptr Pguchar; length: Pgint): gint {.cdecl, 
      importc: "gdk_x11_display_string_to_compound_text", dynlib: lib.}
  proc utf8_to_compound_text*(display: PGdkDisplay; 
      str: CSTRING; encoding: PGdkAtom; format: Pgint; 
      ctext: ptr Pguchar; length: Pgint): gboolean {.cdecl, 
      importc: "gdk_x11_display_utf8_to_compound_text", dynlib: lib.}
  proc x11_free_compound_text*(ctext: Pguchar) {.cdecl, 
      importc: "gdk_x11_free_compound_text", dynlib: lib.}
  when not(defined(MULTIHEAD_SAFE)): 
    proc x11_get_default_root_xwindow*(): TWindow {.cdecl, 
        importc: "gdk_x11_get_default_root_xwindow", dynlib: lib.}
    proc x11_get_default_xdisplay*(): PDisplay {.cdecl, 
        importc: "gdk_x11_get_default_xdisplay", dynlib: lib.}
  when not(defined(MULTIHEAD_SAFE)): 
    template ROOT_WINDOW*(): expr = 
      (gdk_x11_get_default_root_xwindow())

  template XID_TO_POINTER*(xid: expr): expr = 
    GUINT_TO_POINTER(xid)

  template POINTER_TO_XID*(pointer: expr): expr = 
    GPOINTER_TO_UINT(pointer)

  when not(defined(MULTIHEAD_SAFE)): 
    proc x11_grab_server*() {.cdecl, importc: "gdk_x11_grab_server", 
                                  dynlib: lib.}
    proc x11_ungrab_server*() {.cdecl, importc: "gdk_x11_ungrab_server", 
                                    dynlib: lib.}
  template TYPE_X11_VISUAL*(): expr = 
    (gdk_x11_visual_get_type())

  template X11_VISUAL*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_X11_VISUAL, TX11Visual))

  template X11_VISUAL_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_X11_VISUAL, TX11VisualClass))

  template IS_X11_VISUAL*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_X11_VISUAL))

  template IS_X11_VISUAL_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_X11_VISUAL))

  template X11_VISUAL_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_X11_VISUAL, TX11VisualClass))

  type 
    TX11Visual* = TGdkVisual
  proc x11_visual_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_visual_get_type", dynlib: lib.}
  proc get_xvisual*(visual: PGdkVisual): PVisual {.cdecl, 
      importc: "gdk_x11_visual_get_xvisual", dynlib: lib.}
  template VISUAL_XVISUAL*(visual: expr): expr = 
    (gdk_x11_visual_get_xvisual(visual))

  proc lookup_visual*(screen: PGdkScreen; 
                                     xvisualid: VisualID): PGdkVisual {.
      cdecl, importc: "gdk_x11_screen_lookup_visual", dynlib: lib.}
  template TYPE_X11_WINDOW*(): expr = 
    (gdk_x11_window_get_type())

  template X11_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_X11_WINDOW, TX11Window))

  template X11_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_X11_WINDOW, TX11WindowClass))

  template IS_X11_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_X11_WINDOW))

  template IS_X11_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_X11_WINDOW))

  template X11_WINDOW_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_X11_WINDOW, TX11WindowClass))

  type 
    TX11Window* = TGdkWindow
  proc x11_window_get_type*(): GType {.cdecl, 
      importc: "gdk_x11_window_get_type", dynlib: lib.}
  proc get_xid*(window: PGdkWindow): TWindow {.cdecl, 
      importc: "gdk_x11_window_get_xid", dynlib: lib.}
  proc set_user_time*(window: PGdkWindow; timestamp: guint32) {.
      cdecl, importc: "gdk_x11_window_set_user_time", dynlib: lib.}
  proc set_utf8_property*(window: PGdkWindow; 
      name: CSTRING; value: CSTRING) {.cdecl, 
      importc: "gdk_x11_window_set_utf8_property", dynlib: lib.}
  proc set_theme_variant*(window: PGdkWindow; 
      variant: cstring) {.cdecl, importc: "gdk_x11_window_set_theme_variant", 
                          dynlib: lib.}
  proc set_frame_extents*(window: PGdkWindow; left: cint; 
      right: cint; top: cint; bottom: cint) {.cdecl, 
      importc: "gdk_x11_window_set_frame_extents", dynlib: lib.}
  proc set_hide_titlebar_when_maximized*(window: PGdkWindow; 
      hide_titlebar_when_maximized: gboolean) {.cdecl, 
      importc: "gdk_x11_window_set_hide_titlebar_when_maximized", dynlib: lib.}
  proc move_to_current_desktop*(window: PGdkWindow) {.cdecl, 
      importc: "gdk_x11_window_move_to_current_desktop", dynlib: lib.}
  proc get_desktop*(window: PGdkWindow): guint32 {.cdecl, 
      importc: "gdk_x11_window_get_desktop", dynlib: lib.}
  proc move_to_desktop*(window: PGdkWindow; desktop: guint32) {.
      cdecl, importc: "gdk_x11_window_move_to_desktop", dynlib: lib.}
  proc set_frame_sync_enabled*(window: PGdkWindow; 
      frame_sync_enabled: gboolean) {.cdecl, importc: "gdk_x11_window_set_frame_sync_enabled", 
                                      dynlib: lib.}
  template WINDOW_XDISPLAY*(win: expr): expr = 
    (DISPLAY_XDISPLAY(gdk_window_get_display(win)))

  template WINDOW_XID*(win: expr): expr = 
    (gdk_x11_window_get_xid(win))

  proc x11_get_server_time*(window: PGdkWindow): guint32 {.cdecl, 
      importc: "gdk_x11_get_server_time", dynlib: lib.}
  proc x11_window_foreign_new_for_display*(display: PGdkDisplay; 
      window: TWindow): PGdkWindow {.cdecl, 
      importc: "gdk_x11_window_foreign_new_for_display", dynlib: lib.}
  proc x11_window_lookup_for_display*(display: PGdkDisplay; 
      window: TWindow): PGdkWindow {.cdecl, 
      importc: "gdk_x11_window_lookup_for_display", dynlib: lib.}
when defined(win32): 
  template TYPE_WIN32_CURSOR*(): expr = 
    (gdk_win32_cursor_get_type())

  template WIN32_CURSOR*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WIN32_CURSOR, TWin32Cursor))

  template WIN32_CURSOR_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WIN32_CURSOR, 
                             TWin32CursorClass))

  template IS_WIN32_CURSOR*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WIN32_CURSOR))

  template IS_WIN32_CURSOR_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WIN32_CURSOR))

  template WIN32_CURSOR_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WIN32_CURSOR, 
                               TWin32CursorClass))

  type 
    TWin32Cursor* = TGdkCursor
  proc win32_cursor_get_type*(): GType {.cdecl, 
      importc: "gdk_win32_cursor_get_type", dynlib: lib.}
  type 
    TWin32Display* = TGdkDisplay
  template TYPE_WIN32_DISPLAY*(): expr = 
    (gdk_win32_display_get_type())

  template WIN32_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WIN32_DISPLAY, TWin32Display))

  template WIN32_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WIN32_DISPLAY, 
                             TWin32DisplayClass))

  template IS_WIN32_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WIN32_DISPLAY))

  template IS_WIN32_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WIN32_DISPLAY))

  template WIN32_DISPLAY_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WIN32_DISPLAY, 
                               TWin32DisplayClass))

  proc win32_display_get_type*(): GType {.cdecl, 
      importc: "gdk_win32_display_get_type", dynlib: lib.}
  type 
    TWin32DisplayManager* = TGdkDisplayManager
  template TYPE_WIN32_DISPLAY_MANAGER*(): expr = 
    (gdk_win32_display_manager_get_type())

  template WIN32_DISPLAY_MANAGER*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WIN32_DISPLAY_MANAGER, 
                                TWin32DisplayManager))

  template WIN32_DISPLAY_MANAGER_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WIN32_DISPLAY_MANAGER, 
                             TWin32DisplayManagerClass))

  template IS_WIN32_DISPLAY_MANAGER*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WIN32_DISPLAY_MANAGER))

  template IS_WIN32_DISPLAY_MANAGER_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WIN32_DISPLAY_MANAGER))

  template WIN32_DISPLAY_MANAGER_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WIN32_DISPLAY_MANAGER, 
                               TWin32DisplayManagerClass))

  proc win32_display_manager_get_type*(): GType {.cdecl, 
      importc: "gdk_win32_display_manager_get_type", dynlib: lib.}
  template TYPE_WIN32_DRAG_CONTEXT*(): expr = 
    (gdk_win32_drag_context_get_type())

  template WIN32_DRAG_CONTEXT*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WIN32_DRAG_CONTEXT, 
                                TWin32DragContext))

  template WIN32_DRAG_CONTEXT_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WIN32_DRAG_CONTEXT, 
                             TWin32DragContextClass))

  template IS_WIN32_DRAG_CONTEXT*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WIN32_DRAG_CONTEXT))

  template IS_WIN32_DRAG_CONTEXT_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WIN32_DRAG_CONTEXT))

  template WIN32_DRAG_CONTEXT_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WIN32_DRAG_CONTEXT, 
                               TWin32DragContextClass))

  type 
    TWin32DragContext* = TDragContext
  proc win32_drag_context_get_type*(): GType {.cdecl, 
      importc: "gdk_win32_drag_context_get_type", dynlib: lib.}
  type 
    TWin32Keymap* = TKeymap
  template TYPE_WIN32_KEYMAP*(): expr = 
    (gdk_win32_keymap_get_type())

  template WIN32_KEYMAP*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WIN32_KEYMAP, TWin32Keymap))

  template WIN32_KEYMAP_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WIN32_KEYMAP, 
                             TWin32KeymapClass))

  template IS_WIN32_KEYMAP*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WIN32_KEYMAP))

  template IS_WIN32_KEYMAP_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WIN32_KEYMAP))

  template WIN32_KEYMAP_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WIN32_KEYMAP, 
                               TWin32KeymapClass))

  proc win32_keymap_get_type*(): GType {.cdecl, 
      importc: "gdk_win32_keymap_get_type", dynlib: lib.}
  template TYPE_WIN32_SCREEN*(): expr = 
    (gdk_win32_screen_get_type())

  template WIN32_SCREEN*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WIN32_SCREEN, TWin32Screen))

  template WIN32_SCREEN_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WIN32_SCREEN, 
                             TWin32ScreenClass))

  template IS_WIN32_SCREEN*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WIN32_SCREEN))

  template IS_WIN32_SCREEN_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WIN32_SCREEN))

  template WIN32_SCREEN_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WIN32_SCREEN, 
                               TWin32ScreenClass))

  type 
    TWin32Screen* = TGdkScreen
  proc win32_screen_get_type*(): GType {.cdecl, 
      importc: "gdk_win32_screen_get_type", dynlib: lib.}
  template TYPE_WIN32_WINDOW*(): expr = 
    (gdk_win32_window_get_type())

  template WIN32_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WIN32_WINDOW, TWin32Window))

  template WIN32_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WIN32_WINDOW, 
                             TWin32WindowClass))

  template IS_WIN32_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WIN32_WINDOW))

  template IS_WIN32_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WIN32_WINDOW))

  template WIN32_WINDOW_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WIN32_WINDOW, 
                               TWin32WindowClass))

  type 
    TWin32Window* = TGdkWindow
  proc win32_window_get_type*(): GType {.cdecl, 
      importc: "gdk_win32_window_get_type", dynlib: lib.}
  when not(defined(STRICT)): 
    const 
      STRICT* = true
  when defined(INSIDE_WIN32): 
    template WINDOW_HWND*(win: expr): expr = 
      (WINDOW_IMPL_WIN32(win.impl).handle)

  else: 
    template WINDOW_HWND*(d: expr): expr = 
      (gdk_win32_window_get_handle(d))

  when not(defined(WM_XBUTTONDOWN)): 
    const 
      WM_XBUTTONDOWN* = 0x0000020B
  when not(defined(WM_XBUTTONUP)): 
    const 
      WM_XBUTTONUP* = 0x0000020C
  when not(defined(GET_XBUTTON_WPARAM)): 
    template GET_XBUTTON_WPARAM*(w: expr): expr = 
      (HIWORD(w))

  when not(defined(XBUTTON1)): 
    const 
      XBUTTON1* = 1
  when not(defined(XBUTTON2)): 
    const 
      XBUTTON2* = 2
  proc win32_window_is_win32*(window: PGdkWindow): gboolean {.cdecl, 
      importc: "gdk_win32_window_is_win32", dynlib: lib.}
  proc win32_window_get_impl_hwnd*(window: PGdkWindow): HWND {.cdecl, 
      importc: "gdk_win32_window_get_impl_hwnd", dynlib: lib.}
  proc win32_handle_table_lookup*(handle: HWND): gpointer {.cdecl, 
      importc: "gdk_win32_handle_table_lookup", dynlib: lib.}
  proc win32_window_get_handle*(window: PGdkWindow): HGDIOBJ {.cdecl, 
      importc: "gdk_win32_window_get_handle", dynlib: lib.}
  proc win32_selection_add_targets*(owner: PGdkWindow; 
      selection: TGdkAtom; n_targets: gint; targets: PGdkAtom) {.cdecl, 
      importc: "gdk_win32_selection_add_targets", dynlib: lib.}
  proc win32_window_foreign_new_for_display*(display: PGdkDisplay; 
      anid: HWND): PGdkWindow {.cdecl, importc: "gdk_win32_window_foreign_new_for_display", 
                                   dynlib: lib.}
  proc win32_window_lookup_for_display*(display: PGdkDisplay; 
      anid: HWND): PGdkWindow {.cdecl, importc: "gdk_win32_window_lookup_for_display", 
                                   dynlib: lib.}
  type 
    TWaylandDevice* = TDevice
  template TYPE_WAYLAND_DEVICE*(): expr = 
    (gdk_wayland_device_get_type())

  template WAYLAND_DEVICE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_WAYLAND_DEVICE, TWaylandDevice))

  template WAYLAND_DEVICE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((c), TYPE_WAYLAND_DEVICE, 
                             TWaylandDeviceClass))

  template IS_WAYLAND_DEVICE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_WAYLAND_DEVICE))

  template IS_WAYLAND_DEVICE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_WAYLAND_DEVICE))

  template WAYLAND_DEVICE_GET_CLASS*(o: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_WAYLAND_DEVICE, 
                               TWaylandDeviceClass))

  proc wayland_device_get_type*(): GType {.cdecl, 
      importc: "gdk_wayland_device_get_type", dynlib: lib.}
  proc wayland_device_get_wl_seat*(device: PDevice): Pwl_seat {.
      cdecl, importc: "gdk_wayland_device_get_wl_seat", dynlib: lib.}
  proc wayland_device_get_wl_pointer*(device: PDevice): Pwl_pointer {.
      cdecl, importc: "gdk_wayland_device_get_wl_pointer", dynlib: lib.}
  proc wayland_device_get_wl_keyboard*(device: PDevice): Pwl_keyboard {.
      cdecl, importc: "gdk_wayland_device_get_wl_keyboard", dynlib: lib.}
when defined(wayland): 
  type 
    TWaylandDisplay* = TGdkDisplay
  template TYPE_WAYLAND_DISPLAY*(): expr = 
    (gdk_wayland_display_get_type())

  template WAYLAND_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WAYLAND_DISPLAY, 
                                TWaylandDisplay))

  template WAYLAND_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WAYLAND_DISPLAY, 
                             TWaylandDisplayClass))

  template IS_WAYLAND_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WAYLAND_DISPLAY))

  template IS_WAYLAND_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WAYLAND_DISPLAY))

  template WAYLAND_DISPLAY_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WAYLAND_DISPLAY, 
                               TWaylandDisplayClass))

  proc wayland_display_get_type*(): GType {.cdecl, 
      importc: "gdk_wayland_display_get_type", dynlib: lib.}
  proc wayland_display_get_wl_display*(display: PGdkDisplay): Pwl_display {.
      cdecl, importc: "gdk_wayland_display_get_wl_display", dynlib: lib.}
  proc wayland_display_get_wl_compositor*(display: PGdkDisplay): Pwl_compositor {.
      cdecl, importc: "gdk_wayland_display_get_wl_compositor", dynlib: lib.}
  proc wayland_display_get_xdg_shell*(display: PGdkDisplay): Pxdg_shell {.
      cdecl, importc: "gdk_wayland_display_get_xdg_shell", dynlib: lib.}
  proc wayland_display_set_cursor_theme*(display: PGdkDisplay; 
      theme: CSTRING; size: gint) {.cdecl, importc: "gdk_wayland_display_set_cursor_theme", 
                                      dynlib: lib.}
  type 
    TWaylandWindow* = TGdkWindow
  template TYPE_WAYLAND_WINDOW*(): expr = 
    (gdk_wayland_window_get_type())

  template WAYLAND_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WAYLAND_WINDOW, 
                                TWaylandWindow))

  template WAYLAND_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WAYLAND_WINDOW, 
                             TWaylandWindowClass))

  template IS_WAYLAND_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WAYLAND_WINDOW))

  template IS_WAYLAND_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WAYLAND_WINDOW))

  template WAYLAND_WINDOW_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WAYLAND_WINDOW, 
                               TWaylandWindowClass))

  proc wayland_window_get_type*(): GType {.cdecl, 
      importc: "gdk_wayland_window_get_type", dynlib: lib.}
  proc wayland_window_get_wl_surface*(window: PGdkWindow): Pwl_surface {.
      cdecl, importc: "gdk_wayland_window_get_wl_surface", dynlib: lib.}
  proc wayland_window_set_use_custom_surface*(window: PGdkWindow) {.
      cdecl, importc: "gdk_wayland_window_set_use_custom_surface", dynlib: lib.}
  proc wayland_window_set_dbus_properties_libgtk_only*(
      window: PGdkWindow; application_id: cstring; app_menu_path: cstring; 
      menubar_path: cstring; window_object_path: cstring; 
      application_object_path: cstring; unique_bus_name: cstring) {.cdecl, 
      importc: "gdk_wayland_window_set_dbus_properties_libgtk_only", 
      dynlib: lib.}
  proc name_const*(atom: TGdkAtom): cstring {.cdecl, 
      importc: "_gdk_atom_name_const", dynlib: lib.}
  proc destroy_notify*(window: PGdkWindow) {.cdecl, 
      importc: "gdk_window_destroy_notify", dynlib: lib.}
  proc synthesize_window_state*(window: PGdkWindow; 
                                    unset_flags: TGdkWindowState; 
                                    set_flags: TGdkWindowState) {.cdecl, 
      importc: "gdk_synthesize_window_state", dynlib: lib.}
when defined(quartz): 
  when not(defined(NSINTEGER_DEFINED)): 
    type 
      NSInteger* = cint
      NSUInteger* = cuint
  when not(defined(CGFLOAT_DEFINED)): 
    type 
      CGFloat* = cfloat
  type 
    TOSXVersion* {.size: sizeof(cint).} = enum 
      OSX_UNSUPPORTED = 0, OSX_TIGER = 4, 
      OSX_LEOPARD = 5, OSX_SNOW_LEOPARD = 6, OSX_LION = 7, 
      OSX_MOUNTAIN_LION = 8, OSX_NEW = 99
  proc quartz_osx_version*(): TOSXVersion {.cdecl, 
      importc: "gdk_quartz_osx_version", dynlib: lib.}
  proc quartz_pasteboard_type_to_atom_libgtk_only*(typ: PNSString): TGdkAtom {.
      cdecl, importc: "gdk_quartz_pasteboard_type_to_atom_libgtk_only", 
      dynlib: lib.}
  proc quartz_target_to_pasteboard_type_libgtk_only*(target: CSTRING): PNSString {.
      cdecl, importc: "gdk_quartz_target_to_pasteboard_type_libgtk_only", 
      dynlib: lib.}
  proc quartz_atom_to_pasteboard_type_libgtk_only*(atom: TGdkAtom): PNSString {.
      cdecl, importc: "gdk_quartz_atom_to_pasteboard_type_libgtk_only", 
      dynlib: lib.}
  template TYPE_QUARTZ_CURSOR*(): expr = 
    (gdk_quartz_cursor_get_type())

  template QUARTZ_CURSOR*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_QUARTZ_CURSOR, TQuartzCursor))

  template QUARTZ_CURSOR_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_QUARTZ_CURSOR, 
                             TQuartzCursorClass))

  template IS_QUARTZ_CURSOR*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_QUARTZ_CURSOR))

  template IS_QUARTZ_CURSOR_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_QUARTZ_CURSOR))

  template QUARTZ_CURSOR_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_QUARTZ_CURSOR, 
                               TQuartzCursorClass))

  type 
    TQuartzCursor* = TGdkCursor
  proc quartz_cursor_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_cursor_get_type", dynlib: lib.}
  template TYPE_QUARTZ_DEVICE_CORE*(): expr = 
    (gdk_quartz_device_core_get_type())

  template QUARTZ_DEVICE_CORE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_QUARTZ_DEVICE_CORE, 
                                QuartzDeviceCore))

  template QUARTZ_DEVICE_CORE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((c), TYPE_QUARTZ_DEVICE_CORE, 
                             QuartzDeviceCoreClass))

  template IS_QUARTZ_DEVICE_CORE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_QUARTZ_DEVICE_CORE))

  template IS_QUARTZ_DEVICE_CORE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_QUARTZ_DEVICE_CORE))

  template QUARTZ_DEVICE_CORE_GET_CLASS*(o: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_QUARTZ_DEVICE_CORE, 
                               QuartzDeviceCoreClass))

  proc quartz_device_core_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_device_core_get_type", dynlib: lib.}
  template TYPE_QUARTZ_DEVICE_MANAGER_CORE*(): expr = 
    (gdk_quartz_device_manager_core_get_type())

  template QUARTZ_DEVICE_MANAGER_CORE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_QUARTZ_DEVICE_MANAGER_CORE, 
                                QuartzDeviceManagerCore))

  template QUARTZ_DEVICE_MANAGER_CORE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((c), TYPE_QUARTZ_DEVICE_MANAGER_CORE, 
                             QuartzDeviceManagerCoreClass))

  template IS_QUARTZ_DEVICE_MANAGER_CORE*(o: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_QUARTZ_DEVICE_MANAGER_CORE))

  template IS_QUARTZ_DEVICE_MANAGER_CORE_CLASS*(c: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_QUARTZ_DEVICE_MANAGER_CORE))

  template QUARTZ_DEVICE_MANAGER_CORE_GET_CLASS*(o: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_QUARTZ_DEVICE_MANAGER_CORE, 
                               QuartzDeviceManagerCoreClass))

  proc quartz_device_manager_core_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_device_manager_core_get_type", dynlib: lib.}
  template TYPE_QUARTZ_DISPLAY*(): expr = 
    (gdk_quartz_display_get_type())

  template QUARTZ_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_QUARTZ_DISPLAY, 
                                TQuartzDisplay))

  template QUARTZ_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_QUARTZ_DISPLAY, 
                             TQuartzDisplayClass))

  template IS_QUARTZ_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_QUARTZ_DISPLAY))

  template IS_QUARTZ_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_QUARTZ_DISPLAY))

  template QUARTZ_DISPLAY_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_QUARTZ_DISPLAY, 
                               TQuartzDisplayClass))

  type 
    TQuartzDisplay* = TGdkDisplay
  proc quartz_display_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_display_get_type", dynlib: lib.}
  template TYPE_QUARTZ_DISPLAY_MANAGER*(): expr = 
    (gdk_quartz_display_manager_get_type())

  template QUARTZ_DISPLAY_MANAGER*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_QUARTZ_DISPLAY_MANAGER, 
                                TQuartzDisplayManager))

  type 
    TQuartzDisplayManager* = TGdkDisplayManager
    TQuartzDisplayManagerClass* = TGdkDisplayManagerClass
  proc quartz_display_manager_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_display_manager_get_type", dynlib: lib.}
  template TYPE_QUARTZ_DRAG_CONTEXT*(): expr = 
    (gdk_quartz_drag_context_get_type())

  template QUARTZ_DRAG_CONTEXT*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_QUARTZ_DRAG_CONTEXT, 
                                TQuartzDragContext))

  template QUARTZ_DRAG_CONTEXT_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_QUARTZ_DRAG_CONTEXT, 
                             TQuartzDragContextClass))

  template IS_QUARTZ_DRAG_CONTEXT*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_QUARTZ_DRAG_CONTEXT))

  template IS_QUARTZ_DRAG_CONTEXT_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_QUARTZ_DRAG_CONTEXT))

  template QUARTZ_DRAG_CONTEXT_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_QUARTZ_DRAG_CONTEXT, 
                               TQuartzDragContextClass))

  type 
    TQuartzDragContext* = TDragContext
  proc quartz_drag_context_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_drag_context_get_type", dynlib: lib.}
  proc quartz_drag_context_get_dragging_info_libgtk_only*(
      context: PDragContext): id {.cdecl, 
      importc: "gdk_quartz_drag_context_get_dragging_info_libgtk_only", 
      dynlib: lib.}
  template TYPE_QUARTZ_KEYMAP*(): expr = 
    (gdk_quartz_keymap_get_type())

  template QUARTZ_KEYMAP*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_QUARTZ_KEYMAP, TQuartzKeymap))

  template QUARTZ_KEYMAP_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_QUARTZ_KEYMAP, 
                             TQuartzKeymapClass))

  template IS_QUARTZ_KEYMAP*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_QUARTZ_KEYMAP))

  template IS_QUARTZ_KEYMAP_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_QUARTZ_KEYMAP))

  template QUARTZ_KEYMAP_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_QUARTZ_KEYMAP, 
                               TQuartzKeymapClass))

  type 
    TQuartzKeymap* = TKeymap
  proc quartz_keymap_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_keymap_get_type", dynlib: lib.}
  template TYPE_QUARTZ_SCREEN*(): expr = 
    (gdk_quartz_screen_get_type())

  template QUARTZ_SCREEN*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_QUARTZ_SCREEN, TQuartzScreen))

  template QUARTZ_SCREEN_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_QUARTZ_SCREEN, 
                             TQuartzScreenClass))

  template IS_QUARTZ_SCREEN*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_QUARTZ_SCREEN))

  template IS_QUARTZ_SCREEN_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_QUARTZ_SCREEN))

  template QUARTZ_SCREEN_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_QUARTZ_SCREEN, 
                               TQuartzScreenClass))

  type 
    TQuartzScreen* = TGdkScreen
  proc quartz_screen_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_screen_get_type", dynlib: lib.}
  proc quartz_pixbuf_to_ns_image_libgtk_only*(pixbuf: PPixbuf): PNSImage {.
      cdecl, importc: "gdk_quartz_pixbuf_to_ns_image_libgtk_only", dynlib: lib.}
  proc quartz_event_get_nsevent*(event: PEvent): PNSEvent {.
      cdecl, importc: "gdk_quartz_event_get_nsevent", dynlib: lib.}
  proc quartz_get_key_equivalent*(key: guint): gunichar {.cdecl, 
      importc: "gdk_quartz_get_key_equivalent", dynlib: lib.}
  template TYPE_QUARTZ_VISUAL*(): expr = 
    (gdk_quartz_visual_get_type())

  template QUARTZ_VISUAL*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_QUARTZ_VISUAL, TQuartzVisual))

  template QUARTZ_VISUAL_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_QUARTZ_VISUAL, 
                             TQuartzVisualClass))

  template IS_QUARTZ_VISUAL*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_QUARTZ_VISUAL))

  template IS_QUARTZ_VISUAL_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_QUARTZ_VISUAL))

  template QUARTZ_VISUAL_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_QUARTZ_VISUAL, 
                               TQuartzVisualClass))

  type 
    TQuartzVisual* = TGdkVisual
  proc quartz_visual_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_visual_get_type", dynlib: lib.}
  template TYPE_QUARTZ_WINDOW*(): expr = 
    (gdk_quartz_window_get_type())

  template QUARTZ_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_QUARTZ_WINDOW, TQuartzWindow))

  template QUARTZ_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_QUARTZ_WINDOW, 
                             TQuartzWindowClass))

  template IS_QUARTZ_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_QUARTZ_WINDOW))

  template IS_QUARTZ_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_QUARTZ_WINDOW))

  template QUARTZ_WINDOW_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_QUARTZ_WINDOW, 
                               TQuartzWindowClass))

  type 
    TQuartzWindow* = TGdkWindow
  proc quartz_window_get_type*(): GType {.cdecl, 
      importc: "gdk_quartz_window_get_type", dynlib: lib.}
  proc quartz_window_get_nswindow*(window: PGdkWindow): PNSWindow {.
      cdecl, importc: "gdk_quartz_window_get_nswindow", dynlib: lib.}
  proc quartz_window_get_nsview*(window: PGdkWindow): PNSView {.
      cdecl, importc: "gdk_quartz_window_get_nsview", dynlib: lib.}
when defined(broadway): 
  type 
    TGdkBroadwayDisplay* = TGdkDisplay
  template TYPE_BROADWAY_DISPLAY*(): expr = 
    (gdk_broadway_display_get_type())

  template GDK_BROADWAY_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BROADWAY_DISPLAY, 
                                TGdkBroadwayDisplay))

  template GDK_BROADWAY_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BROADWAY_DISPLAY, 
                             TGdkBroadwayDisplayClass))

  template IS_BROADWAY_DISPLAY*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BROADWAY_DISPLAY))

  template IS_BROADWAY_DISPLAY_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BROADWAY_DISPLAY))

  template GDK_BROADWAY_DISPLAY_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BROADWAY_DISPLAY, 
                               TGdkBroadwayDisplayClass))

  proc broadway_display_get_type*(): GType {.cdecl, 
      importc: "gdk_broadway_display_get_type", dynlib: lib.}
  proc broadway_display_show_keyboard*(display: PGdkBroadwayDisplay) {.
      cdecl, importc: "gdk_broadway_display_show_keyboard", dynlib: lib.}
  proc broadway_display_hide_keyboard*(display: PGdkBroadwayDisplay) {.
      cdecl, importc: "gdk_broadway_display_hide_keyboard", dynlib: lib.}
  template TYPE_BROADWAY_WINDOW*(): expr = 
    (gdk_broadway_window_get_type())

  template GDK_BROADWAY_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BROADWAY_WINDOW, 
                                TGdkBroadwayWindow))

  template GDK_BROADWAY_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BROADWAY_WINDOW, 
                             TGdkBroadwayWindowClass))

  template IS_BROADWAY_WINDOW*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BROADWAY_WINDOW))

  template IS_BROADWAY_WINDOW_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BROADWAY_WINDOW))

  template GDK_BROADWAY_WINDOW_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BROADWAY_WINDOW, 
                               TGdkBroadwayWindowClass))

  type 
    TGdkBroadwayWindow* = TGdkWindow
  proc broadway_window_get_type*(): GType {.cdecl, 
      importc: "gdk_broadway_window_get_type", dynlib: lib.}
  proc broadway_get_last_seen_time*(window: PGdkWindow): guint32 {.
      cdecl, importc: "gdk_broadway_get_last_seen_time", dynlib: lib.}
  template TYPE_BROADWAY_CURSOR*(): expr = 
    (gdk_broadway_cursor_get_type())

  template GDK_BROADWAY_CURSOR*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BROADWAY_CURSOR, 
                                TGdkBroadwayCursor))

  template GDK_BROADWAY_CURSOR_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BROADWAY_CURSOR, 
                             TGdkBroadwayCursorClass))

  template IS_BROADWAY_CURSOR*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BROADWAY_CURSOR))

  template IS_BROADWAY_CURSOR_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BROADWAY_CURSOR))

  template GDK_BROADWAY_CURSOR_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BROADWAY_CURSOR, 
                               TGdkBroadwayCursorClass))

  type 
    TGdkBroadwayCursor* = TGdkCursor
  proc broadway_cursor_get_type*(): GType {.cdecl, 
      importc: "gdk_broadway_cursor_get_type", dynlib: lib.}
  template TYPE_BROADWAY_VISUAL*(): expr = 
    (gdk_broadway_visual_get_type())

  template GDK_BROADWAY_VISUAL*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BROADWAY_VISUAL, 
                                TGdkBroadwayVisual))

  template GDK_BROADWAY_VISUAL_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BROADWAY_VISUAL, 
                             TGdkBroadwayVisualClass))

  template IS_BROADWAY_VISUAL*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BROADWAY_VISUAL))

  template IS_BROADWAY_VISUAL_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BROADWAY_VISUAL))

  template GDK_BROADWAY_VISUAL_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BROADWAY_VISUAL, 
                               TGdkBroadwayVisualClass))

  type 
    TGdkBroadwayVisual* = TGdkVisual
  proc broadway_visual_get_type*(): GType {.cdecl, 
      importc: "gdk_broadway_visual_get_type", dynlib: lib.}
when not(defined(UNDERSCORE_BROADWAY_BUFFER_UNDERSCORE)): 
  const 
    UNDERSCORE_BROADWAY_BUFFER_UNDERSCORE* = true
  proc broadway_buffer_create*(width: cint; height: cint; data: Pguint8; 
                               stride: cint): PBroadwayBuffer {.cdecl, 
      importc: "broadway_buffer_create", dynlib: lib.}
  proc broadway_buffer_destroy*(buffer: PBroadwayBuffer) {.cdecl, 
      importc: "broadway_buffer_destroy", dynlib: lib.}
  proc broadway_buffer_encode*(buffer: PBroadwayBuffer; 
                               prev: PBroadwayBuffer; dest: PGString) {.
      cdecl, importc: "broadway_buffer_encode", dynlib: lib.}
  proc broadway_buffer_get_width*(buffer: PBroadwayBuffer): cint {.cdecl, 
      importc: "broadway_buffer_get_width", dynlib: lib.}
  proc broadway_buffer_get_height*(buffer: PBroadwayBuffer): cint {.cdecl, 
      importc: "broadway_buffer_get_height", dynlib: lib.}
  type 
    PBroadwayRect* = ptr TBroadwayRect
    TBroadwayRect*{.final, pure.} = object 
      x*: gint32
      y*: gint32
      width*: gint32
      height*: gint32

    TBroadwayEventType* {.size: sizeof(cint).} = enum 
      BROADWAY_EVENT_BUTTON_RELEASE = 'B',
      BROADWAY_EVENT_KEY_RELEASE = 'K',
      BROADWAY_EVENT_DELETE_NOTIFY = 'W', 
      BROADWAY_EVENT_BUTTON_PRESS = 'b', 
      BROADWAY_EVENT_SCREEN_SIZE_CHANGED = 'd',
      BROADWAY_EVENT_ENTER = 'e',
      BROADWAY_EVENT_FOCUS = 'f',
      BROADWAY_EVENT_GRAB_NOTIFY = 'g', 
      BROADWAY_EVENT_KEY_PRESS = 'k', 
      BROADWAY_EVENT_LEAVE = 'l', 
      BROADWAY_EVENT_POINTER_MOVE = 'm',
      BROADWAY_EVENT_SCROLL = 's',
      BROADWAY_EVENT_TOUCH = 't', 
      BROADWAY_EVENT_UNGRAB_NOTIFY = 'u', 
      BROADWAY_EVENT_CONFIGURE_NOTIFY = 'w', 
    TBroadwayOpType* {.size: sizeof(cint).} = enum 
      BROADWAY_OP_DISCONNECTED = 'D', 
      BROADWAY_OP_HIDE_SURFACE = 'H',
      BROADWAY_OP_AUTH_OK = 'L',
      BROADWAY_OP_LOWER_SURFACE = 'R',
      BROADWAY_OP_SHOW_SURFACE = 'S', 
      BROADWAY_OP_PUT_BUFFER = 'b',
      BROADWAY_OP_DESTROY_SURFACE = 'd', 
      BROADWAY_OP_GRAB_POINTER = 'g',
      BROADWAY_OP_PUT_RGB = 'i',
      BROADWAY_OP_SET_SHOW_KEYBOARD = 'k',
      BROADWAY_OP_REQUEST_AUTH = 'l', 
      BROADWAY_OP_MOVE_RESIZE = 'm',
      BROADWAY_OP_SET_TRANSIENT_FOR = 'p', 
      BROADWAY_OP_RAISE_SURFACE = 'r', 
      BROADWAY_OP_NEW_SURFACE = 's',
      BROADWAY_OP_UNGRAB_POINTER = 'u', 
    PBroadwayInputBaseMsg* = ptr TBroadwayInputBaseMsg
    TBroadwayInputBaseMsg*{.final, pure.} = object 
      typ*: guint32
      serial*: guint32
      time*: guint64

    PBroadwayInputPointerMsg* = ptr TBroadwayInputPointerMsg
    TBroadwayInputPointerMsg*{.final, pure.} = object 
      base*: TBroadwayInputBaseMsg
      mouse_window_id*: guint32
      event_window_id*: guint32
      root_x*: gint32
      root_y*: gint32
      win_x*: gint32
      win_y*: gint32
      state*: guint32

    PBroadwayInputCrossingMsg* = ptr TBroadwayInputCrossingMsg
    TBroadwayInputCrossingMsg*{.final, pure.} = object 
      pointer*: TBroadwayInputPointerMsg
      mode*: guint32

    PBroadwayInputButtonMsg* = ptr TBroadwayInputButtonMsg
    TBroadwayInputButtonMsg*{.final, pure.} = object 
      pointer*: TBroadwayInputPointerMsg
      button*: guint32

    PBroadwayInputScrollMsg* = ptr TBroadwayInputScrollMsg
    TBroadwayInputScrollMsg*{.final, pure.} = object 
      pointer*: TBroadwayInputPointerMsg
      dir*: gint32

    PBroadwayInputTouchMsg* = ptr TBroadwayInputTouchMsg
    TBroadwayInputTouchMsg*{.final, pure.} = object 
      base*: TBroadwayInputBaseMsg
      touch_type*: guint32
      event_window_id*: guint32
      sequence_id*: guint32
      is_emulated*: guint32
      root_x*: gint32
      root_y*: gint32
      win_x*: gint32
      win_y*: gint32
      state*: guint32

    PBroadwayInputKeyMsg* = ptr TBroadwayInputKeyMsg
    TBroadwayInputKeyMsg*{.final, pure.} = object 
      base*: TBroadwayInputBaseMsg
      window_id*: guint32
      state*: guint32
      key*: gint32

    PBroadwayInputGrabReply* = ptr TBroadwayInputGrabReply
    TBroadwayInputGrabReply*{.final, pure.} = object 
      base*: TBroadwayInputBaseMsg
      res*: gint32

    PBroadwayInputConfigureNotify* = ptr TBroadwayInputConfigureNotify
    TBroadwayInputConfigureNotify*{.final, pure.} = object 
      base*: TBroadwayInputBaseMsg
      id*: gint32
      x*: gint32
      y*: gint32
      width*: gint32
      height*: gint32

    PBroadwayInputScreenResizeNotify* = ptr TBroadwayInputScreenResizeNotify
    TBroadwayInputScreenResizeNotify*{.final, pure.} = object 
      base*: TBroadwayInputBaseMsg
      width*: guint32
      height*: guint32

    PBroadwayInputDeleteNotify* = ptr TBroadwayInputDeleteNotify
    TBroadwayInputDeleteNotify*{.final, pure.} = object 
      base*: TBroadwayInputBaseMsg
      id*: gint32

    PBroadwayInputFocusMsg* = ptr TBroadwayInputFocusMsg
    TBroadwayInputFocusMsg*{.final, pure.} = object 
      base*: TBroadwayInputBaseMsg
      new_id*: gint32
      old_id*: gint32

    PBroadwayInputMsg* = ptr TBroadwayInputMsg
    TBroadwayInputMsg* = object  {.union.}
      base*: TBroadwayInputBaseMsg
      pointer*: TBroadwayInputPointerMsg
      crossing*: TBroadwayInputCrossingMsg
      button*: TBroadwayInputButtonMsg
      scroll*: TBroadwayInputScrollMsg
      touch*: TBroadwayInputTouchMsg
      key*: TBroadwayInputKeyMsg
      grab_reply*: TBroadwayInputGrabReply
      configure_notify*: TBroadwayInputConfigureNotify
      delete_notify*: TBroadwayInputDeleteNotify
      screen_resize_notify*: TBroadwayInputScreenResizeNotify
      focus*: TBroadwayInputFocusMsg

    TBroadwayRequestType* {.size: sizeof(cint).} = enum 
      BROADWAY_REQUEST_NEW_WINDOW_ENUM, BROADWAY_REQUEST_FLUSH_ENUM, 
      BROADWAY_REQUEST_SYNC_ENUM, BROADWAY_REQUEST_QUERY_MOUSE_ENUM, 
      BROADWAY_REQUEST_DESTROY_WINDOW_ENUM, BROADWAY_REQUEST_SHOW_WINDOW_ENUM, 
      BROADWAY_REQUEST_HIDE_WINDOW_ENUM, BROADWAY_REQUEST_SET_TRANSIENT_FOR_ENUM, 
      BROADWAY_REQUEST_UPDATE_ENUM, BROADWAY_REQUEST_MOVE_RESIZE_ENUM, 
      BROADWAY_REQUEST_GRAB_POINTER_ENUM, BROADWAY_REQUEST_UNGRAB_POINTER_ENUM, 
      BROADWAY_REQUEST_FOCUS_WINDOW_ENUM, BROADWAY_REQUEST_SET_SHOW_KEYBOARD_ENUM
    PBroadwayRequestBase* = ptr TBroadwayRequestBase
    TBroadwayRequestBase*{.final, pure.} = object 
      size*: guint32
      serial*: guint32
      typ*: guint32

    BroadwayRequestFlush* = TBroadwayRequestBase
    BroadwayRequestSync* = TBroadwayRequestBase
    BroadwayRequestQueryMouse* = TBroadwayRequestBase
    PBroadwayRequestDestroyWindow* = ptr TBroadwayRequestDestroyWindow
    TBroadwayRequestDestroyWindow*{.final, pure.} = object 
      base*: TBroadwayRequestBase
      id*: guint32

    BroadwayRequestShowWindow* = TBroadwayRequestDestroyWindow
    BroadwayRequestHideWindow* = TBroadwayRequestDestroyWindow
    BroadwayRequestFocusWindow* = TBroadwayRequestDestroyWindow
    PBroadwayRequestSetTransientFor* = ptr TBroadwayRequestSetTransientFor
    TBroadwayRequestSetTransientFor*{.final, pure.} = object 
      base*: TBroadwayRequestBase
      id*: guint32
      parent*: guint32

    PBroadwayRequestTranslate* = ptr TBroadwayRequestTranslate
    TBroadwayRequestTranslate*{.final, pure.} = object 
      base*: TBroadwayRequestBase
      id*: guint32
      dx*: gint32
      dy*: gint32
      n_rects*: guint32
      rects*: array[1, TBroadwayRect]

    PBroadwayRequestUpdate* = ptr TBroadwayRequestUpdate
    TBroadwayRequestUpdate*{.final, pure.} = object 
      base*: TBroadwayRequestBase
      id*: guint32
      name*: array[36, char]
      width*: guint32
      height*: guint32

    PBroadwayRequestGrabPointer* = ptr TBroadwayRequestGrabPointer
    TBroadwayRequestGrabPointer*{.final, pure.} = object 
      base*: TBroadwayRequestBase
      id*: guint32
      owner_events*: guint32
      event_mask*: guint32
      time_underscore*: guint32

    PBroadwayRequestUngrabPointer* = ptr TBroadwayRequestUngrabPointer
    TBroadwayRequestUngrabPointer*{.final, pure.} = object 
      base*: TBroadwayRequestBase
      time_underscore*: guint32

    PBroadwayRequestNewWindow* = ptr TBroadwayRequestNewWindow
    TBroadwayRequestNewWindow*{.final, pure.} = object 
      base*: TBroadwayRequestBase
      x*: gint32
      y*: gint32
      width*: guint32
      height*: guint32
      is_temp*: guint32

    PBroadwayRequestMoveResize* = ptr TBroadwayRequestMoveResize
    TBroadwayRequestMoveResize*{.final, pure.} = object 
      base*: TBroadwayRequestBase
      id*: guint32
      with_move*: guint32
      x*: gint32
      y*: gint32
      width*: guint32
      height*: guint32

    PBroadwayRequestSetShowKeyboard* = ptr TBroadwayRequestSetShowKeyboard
    TBroadwayRequestSetShowKeyboard*{.final, pure.} = object 
      base*: TBroadwayRequestBase
      show_keyboard*: guint32

    BroadwayRequest* = object  {.union.}
      base*: TBroadwayRequestBase
      new_window*: TBroadwayRequestNewWindow
      flush*: BroadwayRequestFlush
      sync*: BroadwayRequestSync
      query_mouse*: BroadwayRequestQueryMouse
      destroy_window*: TBroadwayRequestDestroyWindow
      show_window*: BroadwayRequestShowWindow
      hide_window*: BroadwayRequestHideWindow
      set_transient_for*: TBroadwayRequestSetTransientFor
      update*: TBroadwayRequestUpdate
      move_resize*: TBroadwayRequestMoveResize
      grab_pointer*: TBroadwayRequestGrabPointer
      ungrab_pointer*: TBroadwayRequestUngrabPointer
      translate*: TBroadwayRequestTranslate
      focus_window*: BroadwayRequestFocusWindow
      set_show_keyboard*: TBroadwayRequestSetShowKeyboard

    TBroadwayReplyType* {.size: sizeof(cint).} = enum 
      BROADWAY_REPLY_EVENT_ENUM, BROADWAY_REPLY_SYNC_ENUM, BROADWAY_REPLY_QUERY_MOUSE_ENUM, 
      BROADWAY_REPLY_NEW_WINDOW_ENUM, BROADWAY_REPLY_GRAB_POINTER_ENUM, 
      BROADWAY_REPLY_UNGRAB_POINTER_ENUM
    PBroadwayReplyBase* = ptr TBroadwayReplyBase
    TBroadwayReplyBase*{.final, pure.} = object 
      size*: guint32
      in_reply_to*: guint32
      typ*: guint32

    BroadwayReplySync* = TBroadwayReplyBase
    PBroadwayReplyNewWindow* = ptr TBroadwayReplyNewWindow
    TBroadwayReplyNewWindow*{.final, pure.} = object 
      base*: TBroadwayReplyBase
      id*: guint32

    PBroadwayReplyGrabPointer* = ptr TBroadwayReplyGrabPointer
    TBroadwayReplyGrabPointer*{.final, pure.} = object 
      base*: TBroadwayReplyBase
      status*: guint32

    BroadwayReplyUngrabPointer* = TBroadwayReplyGrabPointer
    PBroadwayReplyQueryMouse* = ptr TBroadwayReplyQueryMouse
    TBroadwayReplyQueryMouse*{.final, pure.} = object 
      base*: TBroadwayReplyBase
      toplevel*: guint32
      root_x*: gint32
      root_y*: gint32
      mask*: guint32

    PBroadwayReplyEvent* = ptr TBroadwayReplyEvent
    TBroadwayReplyEvent*{.final, pure.} = object 
      base*: TBroadwayReplyBase
      msg*: TBroadwayInputMsg

    BroadwayReply* = object  {.union.}
      base*: TBroadwayReplyBase
      event*: TBroadwayReplyEvent
      query_mouse*: TBroadwayReplyQueryMouse
      new_window*: TBroadwayReplyNewWindow
      grab_pointer*: TBroadwayReplyGrabPointer
      ungrab_pointer*: BroadwayReplyUngrabPointer

  type 
    TBroadwayWSOpCode* {.size: sizeof(cint).} = enum 
      BROADWAY_WS_CONTINUATION = 0, BROADWAY_WS_TEXT = 1, 
      BROADWAY_WS_BINARY = 2, BROADWAY_WS_CNX_CLOSE = 8, 
      BROADWAY_WS_CNX_PING = 9, BROADWAY_WS_CNX_PONG = 0x0000000A
  proc broadway_output_new*(output: PGOutputStream; serial: guint32): PBroadwayOutput {.
      cdecl, importc: "broadway_output_new", dynlib: lib.}
  proc broadway_output_free*(output: PBroadwayOutput) {.cdecl, 
      importc: "broadway_output_free", dynlib: lib.}
  proc broadway_output_flush*(output: PBroadwayOutput): cint {.cdecl, 
      importc: "broadway_output_flush", dynlib: lib.}
  proc broadway_output_has_error*(output: PBroadwayOutput): cint {.cdecl, 
      importc: "broadway_output_has_error", dynlib: lib.}
  proc broadway_output_set_next_serial*(output: PBroadwayOutput; 
      serial: guint32) {.cdecl, importc: "broadway_output_set_next_serial", 
                         dynlib: lib.}
  proc broadway_output_get_next_serial*(output: PBroadwayOutput): guint32 {.
      cdecl, importc: "broadway_output_get_next_serial", dynlib: lib.}
  proc broadway_output_new_surface*(output: PBroadwayOutput; id: cint; 
                                    x: cint; y: cint; w: cint; h: cint; 
                                    is_temp: gboolean) {.cdecl, 
      importc: "broadway_output_new_surface", dynlib: lib.}
  proc broadway_output_disconnected*(output: PBroadwayOutput) {.cdecl, 
      importc: "broadway_output_disconnected", dynlib: lib.}
  proc broadway_output_show_surface*(output: PBroadwayOutput; id: cint) {.
      cdecl, importc: "broadway_output_show_surface", dynlib: lib.}
  proc broadway_output_hide_surface*(output: PBroadwayOutput; id: cint) {.
      cdecl, importc: "broadway_output_hide_surface", dynlib: lib.}
  proc broadway_output_raise_surface*(output: PBroadwayOutput; id: cint) {.
      cdecl, importc: "broadway_output_raise_surface", dynlib: lib.}
  proc broadway_output_lower_surface*(output: PBroadwayOutput; id: cint) {.
      cdecl, importc: "broadway_output_lower_surface", dynlib: lib.}
  proc broadway_output_destroy_surface*(output: PBroadwayOutput; id: cint) {.
      cdecl, importc: "broadway_output_destroy_surface", dynlib: lib.}
  proc broadway_output_move_resize_surface*(output: PBroadwayOutput; 
      id: cint; has_pos: gboolean; x: cint; y: cint; has_size: gboolean; 
      w: cint; h: cint) {.cdecl, 
                          importc: "broadway_output_move_resize_surface", 
                          dynlib: lib.}
  proc broadway_output_set_transient_for*(output: PBroadwayOutput; 
      id: cint; parent_id: cint) {.cdecl, importc: "broadway_output_set_transient_for", 
                                   dynlib: lib.}
  proc broadway_output_put_buffer*(output: PBroadwayOutput; id: cint; 
                                   prev_buffer: PBroadwayBuffer; 
                                   buffer: PBroadwayBuffer) {.cdecl, 
      importc: "broadway_output_put_buffer", dynlib: lib.}
  proc broadway_output_grab_pointer*(output: PBroadwayOutput; id: cint; 
                                     owner_event: gboolean) {.cdecl, 
      importc: "broadway_output_grab_pointer", dynlib: lib.}
  proc broadway_output_ungrab_pointer*(output: PBroadwayOutput): guint32 {.
      cdecl, importc: "broadway_output_ungrab_pointer", dynlib: lib.}
  proc broadway_output_pong*(output: PBroadwayOutput) {.cdecl, 
      importc: "broadway_output_pong", dynlib: lib.}
  proc broadway_output_set_show_keyboard*(output: PBroadwayOutput; 
      show: gboolean) {.cdecl, importc: "broadway_output_set_show_keyboard", 
                        dynlib: lib.}
when not(defined(UNDERSCORE_BROADWAY_SERVER_UNDERSCORE)): 
  const 
    UNDERSCORE_BROADWAY_SERVER_UNDERSCORE* = true
  proc broadway_events_got_input*(message: PBroadwayInputMsg; 
                                  client_id: gint32) {.cdecl, 
      importc: "broadway_events_got_input", dynlib: lib.}
  template BROADWAY_TYPE_SERVER*(): expr = 
    (broadway_server_get_type())

  template BROADWAY_SERVER*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), BROADWAY_TYPE_SERVER, TBroadwayServer))

  template BROADWAY_SERVER_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), BROADWAY_TYPE_SERVER, 
                             BroadwayServerClass))

  template BROADWAY_IS_SERVER*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), BROADWAY_TYPE_SERVER))

  template BROADWAY_IS_SERVER_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), BROADWAY_TYPE_SERVER))

  template BROADWAY_SERVER_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), BROADWAY_TYPE_SERVER, 
                               BroadwayServerClass))

  proc broadway_server_new*(address: cstring; port: cint; 
                            error: ptr PGError): PBroadwayServer {.
      cdecl, importc: "broadway_server_new", dynlib: lib.}
  proc broadway_server_has_client*(server: PBroadwayServer): gboolean {.
      cdecl, importc: "broadway_server_has_client", dynlib: lib.}
  proc broadway_server_flush*(server: PBroadwayServer) {.cdecl, 
      importc: "broadway_server_flush", dynlib: lib.}
  proc broadway_server_sync*(server: PBroadwayServer) {.cdecl, 
      importc: "broadway_server_sync", dynlib: lib.}
  proc broadway_server_get_screen_size*(server: PBroadwayServer; 
      width: Pguint32; height: Pguint32) {.cdecl, 
      importc: "broadway_server_get_screen_size", dynlib: lib.}
  proc broadway_server_get_next_serial*(server: PBroadwayServer): guint32 {.
      cdecl, importc: "broadway_server_get_next_serial", dynlib: lib.}
  proc broadway_server_get_last_seen_time*(server: PBroadwayServer): guint32 {.
      cdecl, importc: "broadway_server_get_last_seen_time", dynlib: lib.}
  proc broadway_server_lookahead_event*(server: PBroadwayServer; 
      types: cstring): gboolean {.cdecl, 
                                  importc: "broadway_server_lookahead_event", 
                                  dynlib: lib.}
  proc broadway_server_query_mouse*(server: PBroadwayServer; 
                                    toplevel: Pguint32; root_x: Pgint32; 
                                    root_y: Pgint32; mask: Pguint32) {.
      cdecl, importc: "broadway_server_query_mouse", dynlib: lib.}
  proc broadway_server_grab_pointer*(server: PBroadwayServer; 
                                     client_id: gint; id: gint; 
                                     owner_events: gboolean; 
                                     event_mask: guint32; time: guint32): guint32 {.
      cdecl, importc: "broadway_server_grab_pointer", dynlib: lib.}
  proc broadway_server_ungrab_pointer*(server: PBroadwayServer; 
      time: guint32): guint32 {.cdecl, 
                                 importc: "broadway_server_ungrab_pointer", 
                                 dynlib: lib.}
  proc broadway_server_get_mouse_toplevel*(server: PBroadwayServer): gint32 {.
      cdecl, importc: "broadway_server_get_mouse_toplevel", dynlib: lib.}
  proc broadway_server_set_show_keyboard*(server: PBroadwayServer; 
      show: gboolean) {.cdecl, importc: "broadway_server_set_show_keyboard", 
                        dynlib: lib.}
  proc broadway_server_new_window*(server: PBroadwayServer; x: cint; 
                                   y: cint; width: cint; height: cint; 
                                   is_temp: gboolean): guint32 {.cdecl, 
      importc: "broadway_server_new_window", dynlib: lib.}
  proc broadway_server_destroy_window*(server: PBroadwayServer; id: gint) {.
      cdecl, importc: "broadway_server_destroy_window", dynlib: lib.}
  proc broadway_server_window_show*(server: PBroadwayServer; id: gint): gboolean {.
      cdecl, importc: "broadway_server_window_show", dynlib: lib.}
  proc broadway_server_window_hide*(server: PBroadwayServer; id: gint): gboolean {.
      cdecl, importc: "broadway_server_window_hide", dynlib: lib.}
  proc broadway_server_window_raise*(server: PBroadwayServer; id: gint) {.
      cdecl, importc: "broadway_server_window_raise", dynlib: lib.}
  proc broadway_server_window_lower*(server: PBroadwayServer; id: gint) {.
      cdecl, importc: "broadway_server_window_lower", dynlib: lib.}
  proc broadway_server_window_set_transient_for*(server: PBroadwayServer; 
      id: gint; parent: gint) {.cdecl, importc: "broadway_server_window_set_transient_for", 
                                dynlib: lib.}
  proc broadway_server_window_translate*(server: PBroadwayServer; id: gint; 
      area: Pcairo_region_t; dx: gint; dy: gint): gboolean {.cdecl, 
      importc: "broadway_server_window_translate", dynlib: lib.}
  proc broadway_server_create_surface*(width: cint; height: cint): PSurface {.
      cdecl, importc: "broadway_server_create_surface", dynlib: lib.}
  proc broadway_server_window_update*(server: PBroadwayServer; id: gint; 
                                      surface: PSurface) {.cdecl, 
      importc: "broadway_server_window_update", dynlib: lib.}
  proc broadway_server_window_move_resize*(server: PBroadwayServer; 
      id: gint; with_move: gboolean; x: cint; y: cint; width: cint; 
      height: cint): gboolean {.cdecl, importc: "broadway_server_window_move_resize", 
                                dynlib: lib.}
  proc broadway_server_focus_window*(server: PBroadwayServer; 
                                     new_focused_window: gint) {.cdecl, 
      importc: "broadway_server_focus_window", dynlib: lib.}
  proc broadway_server_open_surface*(server: PBroadwayServer; id: guint32; 
                                     name: cstring; width: cint; height: cint): PSurface {.
      cdecl, importc: "broadway_server_open_surface", dynlib: lib.}
when not(defined(UNDERSCORE_GDK_BROADWAY_SERVER_UNDERSCORE)): 
  const 
    UNDERSCORE_GDK_BROADWAY_SERVER_UNDERSCORE* = true
  template TYPE_BROADWAY_SERVER*(): expr = 
    (gdk_broadway_server_get_type())

  template GDK_BROADWAY_SERVER*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BROADWAY_SERVER, 
                                TGdkBroadwayServer))

  template GDK_BROADWAY_SERVER_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BROADWAY_SERVER, 
                             TGdkBroadwayServerClass))

  template IS_BROADWAY_SERVER*(obj: expr): expr = 
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BROADWAY_SERVER))

  template IS_BROADWAY_SERVER_CLASS*(klass: expr): expr = 
    (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BROADWAY_SERVER))

  template GDK_BROADWAY_SERVER_GET_CLASS*(obj: expr): expr = 
    (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BROADWAY_SERVER, 
                               TGdkBroadwayServerClass))

  proc underscore_gdk_broadway_server_new*(display: cstring; error: ptr PGError): PGdkBroadwayServer {.
      cdecl, importc: "_gdk_broadway_server_new", dynlib: lib.}
  proc underscore_gdk_broadway_server_flush*(server: PGdkBroadwayServer) {.cdecl, 
      importc: "_gdk_broadway_server_flush", dynlib: lib.}
  proc underscore_gdk_broadway_server_sync*(server: PGdkBroadwayServer) {.cdecl, 
      importc: "_gdk_broadway_server_sync", dynlib: lib.}
  proc underscore_gdk_broadway_server_get_next_serial*(server: PGdkBroadwayServer): gulong {.
      cdecl, importc: "_gdk_broadway_server_get_next_serial", dynlib: lib.}
  proc underscore_gdk_broadway_server_get_last_seen_time*(server: PGdkBroadwayServer): guint32 {.
      cdecl, importc: "_gdk_broadway_server_get_last_seen_time", dynlib: lib.}
  proc underscore_gdk_broadway_server_lookahead_event*(server: PGdkBroadwayServer; 
      types: cstring): gboolean {.cdecl, importc: "_gdk_broadway_server_lookahead_event", 
                                  dynlib: lib.}
  proc underscore_gdk_broadway_server_query_mouse*(server: PGdkBroadwayServer; 
      toplevel: Pguint32; root_x: Pgint32; root_y: Pgint32; 
      mask: Pguint32) {.cdecl, importc: "_gdk_broadway_server_query_mouse", 
                           dynlib: lib.}
  proc underscore_gdk_broadway_server_grab_pointer*(server: PGdkBroadwayServer; 
      id: gint; owner_events: gboolean; event_mask: guint32; time: guint32): TGrabStatus {.
      cdecl, importc: "_gdk_broadway_server_grab_pointer", dynlib: lib.}
  proc underscore_gdk_broadway_server_ungrab_pointer*(server: PGdkBroadwayServer; 
      time: guint32): guint32 {.cdecl, importc: "_gdk_broadway_server_ungrab_pointer", 
                                 dynlib: lib.}
  proc underscore_gdk_broadway_server_get_mouse_toplevel*(server: PGdkBroadwayServer): gint32 {.
      cdecl, importc: "_gdk_broadway_server_get_mouse_toplevel", dynlib: lib.}
  proc underscore_gdk_broadway_server_new_window*(server: PGdkBroadwayServer; 
      x: cint; y: cint; width: cint; height: cint; is_temp: gboolean): guint32 {.
      cdecl, importc: "_gdk_broadway_server_new_window", dynlib: lib.}
  proc underscore_gdk_broadway_server_destroy_window*(server: PGdkBroadwayServer; 
      id: gint) {.cdecl, importc: "_gdk_broadway_server_destroy_window", 
                  dynlib: lib.}
  proc underscore_gdk_broadway_server_window_show*(server: PGdkBroadwayServer; 
      id: gint): gboolean {.cdecl, 
                            importc: "_gdk_broadway_server_window_show", 
                            dynlib: lib.}
  proc underscore_gdk_broadway_server_window_hide*(server: PGdkBroadwayServer; 
      id: gint): gboolean {.cdecl, 
                            importc: "_gdk_broadway_server_window_hide", 
                            dynlib: lib.}
  proc underscore_gdk_broadway_server_window_focus*(server: PGdkBroadwayServer; 
      id: gint) {.cdecl, importc: "_gdk_broadway_server_window_focus", 
                  dynlib: lib.}
  proc underscore_gdk_broadway_server_window_set_transient_for*(
      server: PGdkBroadwayServer; id: gint; parent: gint) {.cdecl, 
      importc: "_gdk_broadway_server_window_set_transient_for", dynlib: lib.}
  proc underscore_gdk_broadway_server_set_show_keyboard*(server: PGdkBroadwayServer; 
      show_keyboard: gboolean) {.cdecl, importc: "_gdk_broadway_server_set_show_keyboard", 
                                 dynlib: lib.}
  proc underscore_gdk_broadway_server_window_translate*(server: PGdkBroadwayServer; 
      id: gint; area: Pcairo_region_t; dx: gint; dy: gint): gboolean {.
      cdecl, importc: "_gdk_broadway_server_window_translate", dynlib: lib.}
  proc underscore_gdk_broadway_server_create_surface*(width: cint; height: cint): PSurface {.
      cdecl, importc: "_gdk_broadway_server_create_surface", dynlib: lib.}
  proc underscore_gdk_broadway_server_window_update*(server: PGdkBroadwayServer; 
      id: gint; surface: PSurface) {.cdecl, 
      importc: "_gdk_broadway_server_window_update", dynlib: lib.}
  proc underscore_gdk_broadway_server_window_move_resize*(server: PGdkBroadwayServer; 
      id: gint; with_move: gboolean; x: cint; y: cint; width: cint; 
      height: cint): gboolean {.cdecl, importc: "_gdk_broadway_server_window_move_resize", 
                                dynlib: lib.}
