 {.deadCodeElim: on.}
import
  glib2, atk, gdk3, gdk2pixbuf, pango, cairo
when defined(win32): 
  const 
    lib* = "libgdk-win32-3.0-0.dll"
elif defined(macosx): 
  const 
    lib* = "libgdk-quartz-3.0.dylib"
else: 
  const 
    lib* = "libgtk-3.so(|.0)"
type 
  Pregion* = ptr Tregion
  Tregion*{.final, pure.} = object 
  
type 
  TGInitiallyUnowned* = TGObject
  TGInitiallyUnownedClass* = TGObjectClass
  PGFile* = PGObject
  PGIcon* = PGObject
  PGMenuModel* = PGObject
  PGVariant* = PGObject
  PGActionGroup* = PGObject
  va_list* = PGObject
  PGBytes* = PGObject
  PGAppInfo* = PGObject
  TGApplication* = TGObject
  TGApplicationClass* = TGObjectClass
  PGCancellable* = PGObject
  TGMountOperation* = TGObject
  PGMountOperation* = PGObject
  TGMountOperationClass* = TGObjectClass
  TGEmblemedIconClass* = TGObjectClass
  TGEmblemedIcon* = TGObject
  PGAsyncResult* = PGObject
  PGPermission* = PGObject
  PGOptionGroup* = PGObject
  PGKeyFile* = PGObject
  time_t* = culong
  Ptime_t* = ptr culong
  TEllipsizeMode* {.size: sizeof(cint).} = enum 
    PANGO_ELLIPSIZE_NONE, PANGO_ELLIPSIZE_START, PANGO_ELLIPSIZE_MIDDLE, 
    PANGO_ELLIPSIZE_END
  TGApplicationFlags* {.size: sizeof(cint).} = enum 
    G_APPLICATION_FLAGS_NONE, G_APPLICATION_IS_SERVICE = (1 shl 0), 
    G_APPLICATION_IS_LAUNCHER = (1 shl 1), 
    G_APPLICATION_HANDLES_OPEN = (1 shl 2), 
    G_APPLICATION_HANDLES_COMMAND_LINE = (1 shl 3), 
    G_APPLICATION_SEND_ENVIRONMENT = (1 shl 4), 
    G_APPLICATION_NON_UNIQUE = (1 shl 5)
  TGAsyncReadyCallback* = proc (source_obj: PGObject; 
                               res: PGAsyncResult; user_data: gpointer) {.
      cdecl.}
  TGOptionArg* {.size: sizeof(cint).} = enum 
    G_OPTION_ARG_NONE, G_OPTION_ARG_STRING, G_OPTION_ARG_INT, 
    G_OPTION_ARG_CALLBACK, G_OPTION_ARG_FILENAME, G_OPTION_ARG_STRING_ARRAY, 
    G_OPTION_ARG_FILENAME_ARRAY, G_OPTION_ARG_DOUBLE, G_OPTION_ARG_INT64
type 
  PGOptionEntry* = ptr TGOptionEntry
  TGOptionEntry*{.final, pure.} = object 
    long_name*: CSTRING
    short_name*: gchar
    flags*: gint
    arg*: TGOptionArg
    arg_data*: gpointer
    description*: CSTRING
    arg_description*: CSTRING

type 
  PGArray* = ptr TGArray
  TGArray*{.final, pure.} = object 
    data*: CSTRING
    len*: guint


type 
  TAlign* {.size: sizeof(cint).} = enum 
    ALIGN_FILL, ALIGN_START, ALIGN_END, ALIGN_CENTER, 
    ALIGN_BASELINE
type 
  TArrowPlacement* {.size: sizeof(cint).} = enum 
    ARROWS_BOTH, ARROWS_START, ARROWS_END
type 
  TArrowType* {.size: sizeof(cint).} = enum 
    ARROW_UP, ARROW_DOWN, ARROW_LEFT, ARROW_RIGHT, 
    ARROW_NONE
type 
  TAttachOptions* {.size: sizeof(cint).} = enum 
    EXPAND = 1 shl 0, SHRINK = 1 shl 1, FILL = 1 shl 2
type 
  TBaselinePosition* {.size: sizeof(cint).} = enum 
    BASELINE_POSITION_TOP, BASELINE_POSITION_CENTER, 
    BASELINE_POSITION_BOTTOM
type 
  TButtonBoxStyle* {.size: sizeof(cint).} = enum 
    BUTTONBOX_SPREAD = 1, BUTTONBOX_EDGE, BUTTONBOX_START, 
    BUTTONBOX_END, BUTTONBOX_CENTER, BUTTONBOX_EXPAND
type 
  TDeleteType* {.size: sizeof(cint).} = enum 
    DELETE_CHARS, DELETE_WORD_ENDS, DELETE_WORDS, 
    DELETE_DISPLAY_LINES, DELETE_DISPLAY_LINE_ENDS, 
    DELETE_PARAGRAPH_ENDS, DELETE_PARAGRAPHS, DELETE_WHITESPACE
type 
  TDirectionType* {.size: sizeof(cint).} = enum 
    DIR_TAB_FORWARD, DIR_TAB_BACKWARD, DIR_UP, DIR_DOWN, 
    DIR_LEFT, DIR_RIGHT
type 
  TExpanderStyle* {.size: sizeof(cint).} = enum 
    EXPANDER_COLLAPSED, EXPANDER_SEMI_COLLAPSED, 
    EXPANDER_SEMI_EXPANDED, EXPANDER_EXPANDED
type
  PPIconSize* = ptr PIconSize
  PIconSize* = ptr TIconSize
  TIconSize* {.size: sizeof(cint).} = enum 
    ICON_SIZE_INVALID, ICON_SIZE_MENU, ICON_SIZE_SMALL_TOOLBAR, 
    ICON_SIZE_LARGE_TOOLBAR, ICON_SIZE_BUTTON, ICON_SIZE_DND, 
    ICON_SIZE_DIALOG
type 
  TSensitivityType* {.size: sizeof(cint).} = enum 
    SENSITIVITY_AUTO, SENSITIVITY_ON, SENSITIVITY_OFF
type 
  TTextDirection* {.size: sizeof(cint).} = enum 
    TEXT_DIR_NONE, TEXT_DIR_LTR, TEXT_DIR_RTL
type 
  TJustification* {.size: sizeof(cint).} = enum 
    JUSTIFY_LEFT, JUSTIFY_RIGHT, JUSTIFY_CENTER, JUSTIFY_FILL
type 
  TMenuDirectionType* {.size: sizeof(cint).} = enum 
    MENU_DIR_PARENT, MENU_DIR_CHILD, MENU_DIR_NEXT, 
    MENU_DIR_PREV
type 
  TMessageType* {.size: sizeof(cint).} = enum 
    MESSAGE_INFO, MESSAGE_WARNING, MESSAGE_QUESTION, 
    MESSAGE_ERROR, MESSAGE_OTHER
type 
  TMovementStep* {.size: sizeof(cint).} = enum 
    MOVEMENT_LOGICAL_POSITIONS, MOVEMENT_VISUAL_POSITIONS, 
    MOVEMENT_WORDS, MOVEMENT_DISPLAY_LINES, 
    MOVEMENT_DISPLAY_LINE_ENDS, MOVEMENT_PARAGRAPHS, 
    MOVEMENT_PARAGRAPH_ENDS, MOVEMENT_PAGES, MOVEMENT_BUFFER_ENDS, 
    MOVEMENT_HORIZONTAL_PAGES
type 
  TScrollStep* {.size: sizeof(cint).} = enum 
    SCROLL_STEPS, SCROLL_PAGES, SCROLL_ENDS, 
    SCROLL_HORIZONTAL_STEPS, SCROLL_HORIZONTAL_PAGES, 
    SCROLL_HORIZONTAL_ENDS
type
  POrientation* = ptr TOrientation
  TOrientation* {.size: sizeof(cint).} = enum 
    ORIENTATION_HORIZONTAL, ORIENTATION_VERTICAL
type 
  TCornerType* {.size: sizeof(cint).} = enum 
    CORNER_TOP_LEFT, CORNER_BOTTOM_LEFT, CORNER_TOP_RIGHT, 
    CORNER_BOTTOM_RIGHT
type 
  TPackType* {.size: sizeof(cint).} = enum 
    PACK_START, PACK_END
type 
  TPathPriorityType* {.size: sizeof(cint).} = enum 
    PATH_PRIO_LOWEST = 0, PATH_PRIO_GTK = 4, 
    PATH_PRIO_APPLICATION = 8, PATH_PRIO_THEME = 10, 
    PATH_PRIO_RC = 12, PATH_PRIO_HIGHEST = 15
const 
  PATH_PRIO_MASK* = 0x0000000F
type 
  TPathType* {.size: sizeof(cint).} = enum 
    PATH_WIDGET, PATH_WIDGET_CLASS, PATH_CLASS
type 
  TPolicyType* {.size: sizeof(cint).} = enum 
    POLICY_ALWAYS, POLICY_AUTOMATIC, POLICY_NEVER
type 
  TPositionType* {.size: sizeof(cint).} = enum 
    POS_LEFT, POS_RIGHT, POS_TOP, POS_BOTTOM
type 
  TReliefStyle* {.size: sizeof(cint).} = enum 
    RELIEF_NORMAL, RELIEF_HALF, RELIEF_NONE
type 
  TResizeMode* {.size: sizeof(cint).} = enum 
    RESIZE_PARENT, RESIZE_QUEUE, RESIZE_IMMEDIATE
type 
  TScrollType* {.size: sizeof(cint).} = enum 
    SCROLL_NONE, SCROLL_JUMP, SCROLL_STEP_BACKWARD, 
    SCROLL_STEP_FORWARD, SCROLL_PAGE_BACKWARD, 
    SCROLL_PAGE_FORWARD, SCROLL_STEP_UP, SCROLL_STEP_DOWN, 
    SCROLL_PAGE_UP, SCROLL_PAGE_DOWN, SCROLL_STEP_LEFT, 
    SCROLL_STEP_RIGHT, SCROLL_PAGE_LEFT, SCROLL_PAGE_RIGHT, 
    SCROLL_START, SCROLL_END
type 
  TSelectionMode* {.size: sizeof(cint).} = enum 
    SELECTION_NONE, SELECTION_SINGLE, SELECTION_BROWSE, 
    SELECTION_MULTIPLE
type 
  TShadowType* {.size: sizeof(cint).} = enum 
    SHADOW_NONE, SHADOW_IN, SHADOW_OUT, SHADOW_ETCHED_IN, 
    SHADOW_ETCHED_OUT
type 
  TStateType* {.size: sizeof(cint).} = enum 
    STATE_NORMAL, STATE_ACTIVE, STATE_PRELIGHT, 
    STATE_SELECTED, STATE_INSENSITIVE, STATE_INCONSISTENT, 
    STATE_FOCUSED
type 
  TToolbarStyle* {.size: sizeof(cint).} = enum 
    TOOLBAR_ICONS, TOOLBAR_TEXT, TOOLBAR_BOTH, 
    TOOLBAR_BOTH_HORIZ
type 
  TWindowPosition* {.size: sizeof(cint).} = enum 
    WIN_POS_NONE, WIN_POS_CENTER, WIN_POS_MOUSE, 
    WIN_POS_CENTER_ALWAYS, WIN_POS_CENTER_ON_PARENT
type 
  TWindowType* {.size: sizeof(cint).} = enum 
    WINDOW_TOPLEVEL, WINDOW_POPUP
type 
  TWrapMode* {.size: sizeof(cint).} = enum 
    WRAP_NONE, WRAP_CHAR, WRAP_WORD, WRAP_WORD_CHAR
type 
  TSortType* {.size: sizeof(cint).} = enum 
    SORT_ASCENDING, SORT_DESCENDING
type 
  TIMPreeditStyle* {.size: sizeof(cint).} = enum 
    IM_PREEDIT_NOTHING, IM_PREEDIT_CALLBACK, IM_PREEDIT_NONE
type 
  TIMStatusStyle* {.size: sizeof(cint).} = enum 
    IM_STATUS_NOTHING, IM_STATUS_CALLBACK, IM_STATUS_NONE
type 
  TPackDirection* {.size: sizeof(cint).} = enum 
    PACK_DIRECTION_LTR, PACK_DIRECTION_RTL, PACK_DIRECTION_TTB, 
    PACK_DIRECTION_BTT
type 
  TPrintPages* {.size: sizeof(cint).} = enum 
    PRINT_PAGES_ALL, PRINT_PAGES_CURRENT, PRINT_PAGES_RANGES, 
    PRINT_PAGES_SELECTION
type 
  TPageSet* {.size: sizeof(cint).} = enum 
    PAGE_SET_ALL, PAGE_SET_EVEN, PAGE_SET_ODD
type 
  TNumberUpLayout* {.size: sizeof(cint).} = enum 
    NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_TOP_TO_BOTTOM, 
    NUMBER_UP_LAYOUT_LEFT_TO_RIGHT_BOTTOM_TO_TOP, 
    NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_TOP_TO_BOTTOM, 
    NUMBER_UP_LAYOUT_RIGHT_TO_LEFT_BOTTOM_TO_TOP, 
    NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_LEFT_TO_RIGHT, 
    NUMBER_UP_LAYOUT_TOP_TO_BOTTOM_RIGHT_TO_LEFT, 
    NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_LEFT_TO_RIGHT, 
    NUMBER_UP_LAYOUT_BOTTOM_TO_TOP_RIGHT_TO_LEFT
type 
  TPageOrientation* {.size: sizeof(cint).} = enum 
    PAGE_ORIENTATION_PORTRAIT, PAGE_ORIENTATION_LANDSCAPE, 
    PAGE_ORIENTATION_REVERSE_PORTRAIT, 
    PAGE_ORIENTATION_REVERSE_LANDSCAPE
type 
  TPrintQuality* {.size: sizeof(cint).} = enum 
    PRINT_QUALITY_LOW, PRINT_QUALITY_NORMAL, PRINT_QUALITY_HIGH, 
    PRINT_QUALITY_DRAFT
type 
  TPrintDuplex* {.size: sizeof(cint).} = enum 
    PRINT_DUPLEX_SIMPLEX, PRINT_DUPLEX_HORIZONTAL, 
    PRINT_DUPLEX_VERTICAL
type 
  TUnit* {.size: sizeof(cint).} = enum 
    UNIT_NONE, UNIT_POINTS, UNIT_INCH, UNIT_MM
const 
  UNIT_PIXEL* = UNIT_NONE
type 
  TTreeViewGridLines* {.size: sizeof(cint).} = enum 
    TREE_VIEW_GRID_LINES_NONE, TREE_VIEW_GRID_LINES_HORIZONTAL, 
    TREE_VIEW_GRID_LINES_VERTICAL, TREE_VIEW_GRID_LINES_BOTH
type 
  TDragResult* {.size: sizeof(cint).} = enum 
    DRAG_RESULT_SUCCESS, DRAG_RESULT_NO_TARGET, 
    DRAG_RESULT_USER_CANCELLED, DRAG_RESULT_TIMEOUT_EXPIRED, 
    DRAG_RESULT_GRAB_BROKEN, DRAG_RESULT_ERROR
type 
  TSizeGroupMode* {.size: sizeof(cint).} = enum 
    SIZE_GROUP_NONE, SIZE_GROUP_HORIZONTAL, SIZE_GROUP_VERTICAL, 
    SIZE_GROUP_BOTH
type 
  TSizeRequestMode* {.size: sizeof(cint).} = enum 
    SIZE_REQUEST_HEIGHT_FOR_WIDTH = 0, SIZE_REQUEST_WIDTH_FOR_HEIGHT, 
    SIZE_REQUEST_CONSTANT_SIZE
type 
  TScrollablePolicy* {.size: sizeof(cint).} = enum 
    SCROLL_MINIMUM = 0, SCROLL_NATURAL
type 
  TStateFlags* {.size: sizeof(cint).} = enum 
    STATE_FLAG_NORMAL = 0, STATE_FLAG_ACTIVE = 1 shl 0, 
    STATE_FLAG_PRELIGHT = 1 shl 1, STATE_FLAG_SELECTED = 1 shl 2, 
    STATE_FLAG_INSENSITIVE = 1 shl 3, 
    STATE_FLAG_INCONSISTENT = 1 shl 4, STATE_FLAG_FOCUSED = 1 shl 5, 
    STATE_FLAG_BACKDROP = 1 shl 6, STATE_FLAG_DIR_LTR = 1 shl 7, 
    STATE_FLAG_DIR_RTL = 1 shl 8, STATE_FLAG_LINK = 1 shl 9, 
    STATE_FLAG_VISITED = 1 shl 10
type 
  TRegionFlags* {.size: sizeof(cint).} = enum 
    REGION_EVEN = 1 shl 0, REGION_ODD = 1 shl 1, 
    REGION_FIRST = 1 shl 2, REGION_LAST = 1 shl 3, 
    REGION_ONLY = 1 shl 4, REGION_SORTED = 1 shl 5
type 
  TJunctionSides* {.size: sizeof(cint).} = enum 
    JUNCTION_NONE = 0,
    JUNCTION_CORNER_TOPLEFT = 1 shl 0, 
    JUNCTION_CORNER_TOPRIGHT = 1 shl 1, 
    #JUNCTION_TOP = (JUNCTION_CORNER_TOPLEFT or JUNCTION_CORNER_TOPRIGHT),
    JUNCTION_TOP = (1 shl 0) or (1 shl 1),
    JUNCTION_CORNER_BOTTOMLEFT = 1 shl 2,
    #JUNCTION_LEFT = (JUNCTION_CORNER_TOPLEFT or JUNCTION_CORNER_BOTTOMLEFT),
    JUNCTION_LEFT = (1 shl 0) or (1 shl 2),
    JUNCTION_CORNER_BOTTOMRIGHT = 1 shl 3,
    JUNCTION_RIGHT = (1 shl 1) or (1 shl 3)
    JUNCTION_BOTTOM = (1 shl 2) or (1 shl 3),
type 
  TBorderStyle* {.size: sizeof(cint).} = enum 
    BORDER_STYLE_NONE, BORDER_STYLE_SOLID, BORDER_STYLE_INSET, 
    BORDER_STYLE_OUTSET, BORDER_STYLE_HIDDEN, BORDER_STYLE_DOTTED, 
    BORDER_STYLE_DASHED, BORDER_STYLE_DOUBLE, BORDER_STYLE_GROOVE, 
    BORDER_STYLE_RIDGE
type 
  TLevelBarMode* {.size: sizeof(cint).} = enum 
    LEVEL_BAR_MODE_CONTINUOUS, LEVEL_BAR_MODE_DISCRETE
type 
  TInputPurpose* {.size: sizeof(cint).} = enum 
    INPUT_PURPOSE_FREE_FORM, INPUT_PURPOSE_ALPHA, 
    INPUT_PURPOSE_DIGITS, INPUT_PURPOSE_NUMBER, 
    INPUT_PURPOSE_PHONE, INPUT_PURPOSE_URL, INPUT_PURPOSE_EMAIL, 
    INPUT_PURPOSE_NAME, INPUT_PURPOSE_PASSWORD, INPUT_PURPOSE_PIN
type 
  TInputHints* {.size: sizeof(cint).} = enum 
    INPUT_HINT_NONE = 0, INPUT_HINT_SPELLCHECK = 1 shl 0, 
    INPUT_HINT_NO_SPELLCHECK = 1 shl 1, 
    INPUT_HINT_WORD_COMPLETION = 1 shl 2, 
    INPUT_HINT_LOWERCASE = 1 shl 3, 
    INPUT_HINT_UPPERCASE_CHARS = 1 shl 4, 
    INPUT_HINT_UPPERCASE_WORDS = 1 shl 5, 
    INPUT_HINT_UPPERCASE_SENTENCES = 1 shl 6, 
    INPUT_HINT_INHIBIT_OSK = 1 shl 7

type 
  PMenuTracker* = ptr TMenuTracker
  TMenuTracker*{.final, pure.} = object 
  
type 
  PActionObservable* = ptr TActionObservable
  TActionObservable*{.final, pure.} = object 
  
type 
  PMenuTrackerItem* = ptr TMenuTrackerItem
  TMenuTrackerItem*{.final, pure.} = object 
  
type 
  PGradient* = ptr TGradient
  TGradient*{.final, pure.} = object 
  
type 
  PActivatable* = ptr TActivatable
  TActivatable*{.final, pure.} = object 
  
type 
  PTreeDragDest* = ptr TTreeDragDest
  TTreeDragDest*{.final, pure.} = object 
  
type 
  PTreeDragSource* = ptr TTreeDragSource
  TTreeDragSource*{.final, pure.} = object 
  
type 
  PToolShell* = ptr TToolShell
  TToolShell*{.final, pure.} = object 
  
type 
  PTextBTree* = ptr TTextBTree
  TTextBTree*{.final, pure.} = object 
  
type 
  PScrollable* = ptr TScrollable
  TScrollable*{.final, pure.} = object 
  
type 
  PRecentFilter* = ptr TRecentFilter
  TRecentFilter*{.final, pure.} = object 
  
type 
  PRecentInfo* = ptr TRecentInfo
  TRecentInfo*{.final, pure.} = object 
  
type 
  PPrintOperationPreview* = ptr TPrintOperationPreview
  TPrintOperationPreview*{.final, pure.} = object 
  
type 
  PPrintSettings* = ptr TPrintSettings
  TPrintSettings*{.final, pure.} = object 
  
type 
  PPlacesSidebar* = ptr TPlacesSidebar
  TPlacesSidebar*{.final, pure.} = object 
  
type 
  PPrintContext* = ptr TPrintContext
  TPrintContext*{.final, pure.} = object 
  
type 
  PPageSetup* = ptr TPageSetup
  TPageSetup*{.final, pure.} = object 
  
type 
  PPaperSize* = ptr TPaperSize
  TPaperSize*{.final, pure.} = object 
  
type 
  POrientable* = ptr TOrientable
  TOrientable*{.final, pure.} = object 
  
type 
  PStyleProvider* = ptr TStyleProvider
  TStyleProvider*{.final, pure.} = object 
  
type 
  PSizeGroupPrivate* = ptr TSizeGroupPrivate
  TSizeGroupPrivate*{.final, pure.} = object 
  
type 
  PRecentManagerPrivate* = ptr TRecentManagerPrivate
  TRecentManagerPrivate*{.final, pure.} = object 
  
type 
  PUIManagerPrivate* = ptr TUIManagerPrivate
  TUIManagerPrivate*{.final, pure.} = object 
  
type 
  PTearoffMenuItemPrivate* = ptr TTearoffMenuItemPrivate
  TTearoffMenuItemPrivate*{.final, pure.} = object 
  
type 
  PTablePrivate* = ptr TTablePrivate
  TTablePrivate*{.final, pure.} = object 
  
type 
  PRecentActionPrivate* = ptr TRecentActionPrivate
  TRecentActionPrivate*{.final, pure.} = object 
  
type 
  PRadioActionPrivate* = ptr TRadioActionPrivate
  TRadioActionPrivate*{.final, pure.} = object 
  
type 
  PToggleActionPrivate* = ptr TToggleActionPrivate
  TToggleActionPrivate*{.final, pure.} = object 
  
type 
  PImageMenuItemPrivate* = ptr TImageMenuItemPrivate
  TImageMenuItemPrivate*{.final, pure.} = object 
  
type 
  PHSVPrivate* = ptr THSVPrivate
  THSVPrivate*{.final, pure.} = object 
  
type 
  PHandleBoxPrivate* = ptr THandleBoxPrivate
  THandleBoxPrivate*{.final, pure.} = object 
  
type 
  PFontSelectionPrivate* = ptr TFontSelectionPrivate
  TFontSelectionPrivate*{.final, pure.} = object 
  
type 
  PFontSelectionDialogPrivate* = ptr TFontSelectionDialogPrivate
  TFontSelectionDialogPrivate*{.final, pure.} = object 
  
type 
  PColorSelectionDialogPrivate* = ptr TColorSelectionDialogPrivate
  TColorSelectionDialogPrivate*{.final, pure.} = object 
  
type 
  PColorSelectionPrivate* = ptr TColorSelectionPrivate
  TColorSelectionPrivate*{.final, pure.} = object 
  
type 
  PActionGroupPrivate* = ptr TActionGroupPrivate
  TActionGroupPrivate*{.final, pure.} = object 
  
type 
  PActionPrivate* = ptr TActionPrivate
  TActionPrivate*{.final, pure.} = object 
  
type 
  PViewportPrivate* = ptr TViewportPrivate
  TViewportPrivate*{.final, pure.} = object 
  
type 
  PTreeStorePrivate* = ptr TTreeStorePrivate
  TTreeStorePrivate*{.final, pure.} = object 
  
type 
  PTreeModelSortPrivate* = ptr TTreeModelSortPrivate
  TTreeModelSortPrivate*{.final, pure.} = object 
  
type 
  PToolPalettePrivate* = ptr TToolPalettePrivate
  TToolPalettePrivate*{.final, pure.} = object 
  
type 
  PToolItemGroupPrivate* = ptr TToolItemGroupPrivate
  TToolItemGroupPrivate*{.final, pure.} = object 
  
type 
  PToolbarPrivate* = ptr TToolbarPrivate
  TToolbarPrivate*{.final, pure.} = object 
  
type 
  PThemingEnginePrivate* = ptr TThemingEnginePrivate
  TThemingEnginePrivate*{.final, pure.} = object 
  
type 
  PTextViewPrivate* = ptr TTextViewPrivate
  TTextViewPrivate*{.final, pure.} = object 
  
type 
  PTextTagTablePrivate* = ptr TTextTagTablePrivate
  TTextTagTablePrivate*{.final, pure.} = object 
  
type 
  PSwitchPrivate* = ptr TSwitchPrivate
  TSwitchPrivate*{.final, pure.} = object 
  
type 
  PStatusIconPrivate* = ptr TStatusIconPrivate
  TStatusIconPrivate*{.final, pure.} = object 
  
type 
  PStatusbarPrivate* = ptr TStatusbarPrivate
  TStatusbarPrivate*{.final, pure.} = object 
  
type 
  PSpinnerPrivate* = ptr TSpinnerPrivate
  TSpinnerPrivate*{.final, pure.} = object 
  
type 
  PSpinButtonPrivate* = ptr TSpinButtonPrivate
  TSpinButtonPrivate*{.final, pure.} = object 
  
type 
  PSeparatorToolItemPrivate* = ptr TSeparatorToolItemPrivate
  TSeparatorToolItemPrivate*{.final, pure.} = object 
  
type 
  PSeparatorPrivate* = ptr TSeparatorPrivate
  TSeparatorPrivate*{.final, pure.} = object 
  
type 
  PScrolledWindowPrivate* = ptr TScrolledWindowPrivate
  TScrolledWindowPrivate*{.final, pure.} = object 
  
type 
  PScaleButtonPrivate* = ptr TScaleButtonPrivate
  TScaleButtonPrivate*{.final, pure.} = object 
  
type 
  PScalePrivate* = ptr TScalePrivate
  TScalePrivate*{.final, pure.} = object 
  
type 
  PRecentChooser* = ptr TRecentChooser
  TRecentChooser*{.final, pure.} = object 
  
type 
  PRecentChooserMenuPrivate* = ptr TRecentChooserMenuPrivate
  TRecentChooserMenuPrivate*{.final, pure.} = object 
  
type 
  PRecentChooserDialogPrivate* = ptr TRecentChooserDialogPrivate
  TRecentChooserDialogPrivate*{.final, pure.} = object 
  
type 
  PRecentChooserWidgetPrivate* = ptr TRecentChooserWidgetPrivate
  TRecentChooserWidgetPrivate*{.final, pure.} = object 
  
type 
  PRangePrivate* = ptr TRangePrivate
  TRangePrivate*{.final, pure.} = object 
  
type 
  PToggleToolButtonPrivate* = ptr TToggleToolButtonPrivate
  TToggleToolButtonPrivate*{.final, pure.} = object 
  
type 
  PRadioMenuItemPrivate* = ptr TRadioMenuItemPrivate
  TRadioMenuItemPrivate*{.final, pure.} = object 
  
type 
  PRadioButtonPrivate* = ptr TRadioButtonPrivate
  TRadioButtonPrivate*{.final, pure.} = object 
  
type 
  PProgressBarPrivate* = ptr TProgressBarPrivate
  TProgressBarPrivate*{.final, pure.} = object 
  
type 
  PPrintOperationPrivate* = ptr TPrintOperationPrivate
  TPrintOperationPrivate*{.final, pure.} = object 
  
type 
  PPanedPrivate* = ptr TPanedPrivate
  TPanedPrivate*{.final, pure.} = object 
  
type 
  POverlayPrivate* = ptr TOverlayPrivate
  TOverlayPrivate*{.final, pure.} = object 
  
type 
  PNumerableIconPrivate* = ptr TNumerableIconPrivate
  TNumerableIconPrivate*{.final, pure.} = object 
  
type 
  PNotebookPrivate* = ptr TNotebookPrivate
  TNotebookPrivate*{.final, pure.} = object 
  
type 
  PMountOperationPrivate* = ptr TMountOperationPrivate
  TMountOperationPrivate*{.final, pure.} = object 
  
type 
  PMessageDialogPrivate* = ptr TMessageDialogPrivate
  TMessageDialogPrivate*{.final, pure.} = object 
  
type 
  PMenuToolButtonPrivate* = ptr TMenuToolButtonPrivate
  TMenuToolButtonPrivate*{.final, pure.} = object 
  
type 
  PToolButtonPrivate* = ptr TToolButtonPrivate
  TToolButtonPrivate*{.final, pure.} = object 
  
type 
  PToolItemPrivate* = ptr TToolItemPrivate
  TToolItemPrivate*{.final, pure.} = object 
  
type 
  PMenuButtonPrivate* = ptr TMenuButtonPrivate
  TMenuButtonPrivate*{.final, pure.} = object 
  
type 
  PPopoverPrivate* = ptr TPopoverPrivate
  TPopoverPrivate*{.final, pure.} = object 
  
type 
  PMenuBarPrivate* = ptr TMenuBarPrivate
  TMenuBarPrivate*{.final, pure.} = object 
  
type 
  PLockButtonPrivate* = ptr TLockButtonPrivate
  TLockButtonPrivate*{.final, pure.} = object 
  
type 
  PLinkButtonPrivate* = ptr TLinkButtonPrivate
  TLinkButtonPrivate*{.final, pure.} = object 
  
type 
  PLevelBarPrivate* = ptr TLevelBarPrivate
  TLevelBarPrivate*{.final, pure.} = object 
  
type 
  PLayoutPrivate* = ptr TLayoutPrivate
  TLayoutPrivate*{.final, pure.} = object 
  
type 
  PInvisiblePrivate* = ptr TInvisiblePrivate
  TInvisiblePrivate*{.final, pure.} = object 
  
type 
  PInfoBarPrivate* = ptr TInfoBarPrivate
  TInfoBarPrivate*{.final, pure.} = object 
  
type 
  PIMMulticontextPrivate* = ptr TIMMulticontextPrivate
  TIMMulticontextPrivate*{.final, pure.} = object 
  
type 
  PIMContextSimplePrivate* = ptr TIMContextSimplePrivate
  TIMContextSimplePrivate*{.final, pure.} = object 
  
type 
  PIconViewPrivate* = ptr TIconViewPrivate
  TIconViewPrivate*{.final, pure.} = object 
  
type 
  PIconThemePrivate* = ptr TIconThemePrivate
  TIconThemePrivate*{.final, pure.} = object 
  
type 
  PStyleContextPrivate* = ptr TStyleContextPrivate
  TStyleContextPrivate*{.final, pure.} = object 
  
type 
  PStylePropertiesPrivate* = ptr TStylePropertiesPrivate
  TStylePropertiesPrivate*{.final, pure.} = object 
  
type 
  PIconFactoryPrivate* = ptr TIconFactoryPrivate
  TIconFactoryPrivate*{.final, pure.} = object 
  
type 
  PGridPrivate* = ptr TGridPrivate
  TGridPrivate*{.final, pure.} = object 
  
type 
  PFileChooserWidgetPrivate* = ptr TFileChooserWidgetPrivate
  TFileChooserWidgetPrivate*{.final, pure.} = object 
  
type 
  PSymbolicColor* = ptr TSymbolicColor
  TSymbolicColor*{.final, pure.} = object 
  
type 
  PFontChooserDialogPrivate* = ptr TFontChooserDialogPrivate
  TFontChooserDialogPrivate*{.final, pure.} = object 
  
type 
  PFontButtonPrivate* = ptr TFontButtonPrivate
  TFontButtonPrivate*{.final, pure.} = object 
  
type 
  PIconInfo* = ptr TIconInfo
  TIconInfo*{.final, pure.} = object 
  
type 
  PIconSource* = ptr TIconSource
  TIconSource*{.final, pure.} = object 
  
type 
  PFileChooserDialogPrivate* = ptr TFileChooserDialogPrivate
  TFileChooserDialogPrivate*{.final, pure.} = object 
  
type 
  PFileChooserButtonPrivate* = ptr TFileChooserButtonPrivate
  TFileChooserButtonPrivate*{.final, pure.} = object 
  
type 
  PFileChooser* = ptr TFileChooser
  TFileChooser*{.final, pure.} = object 
  
type 
  PFileFilter* = ptr TFileFilter
  TFileFilter*{.final, pure.} = object 
  
type 
  PCssSection* = ptr TCssSection
  TCssSection*{.final, pure.} = object 
  
type 
  PColorChooser* = ptr TColorChooser
  TColorChooser*{.final, pure.} = object 
  
type 
  PCellLayout* = ptr TCellLayout
  TCellLayout*{.final, pure.} = object 
  
type 
  PCssProviderPrivate* = ptr TCssProviderPrivate
  TCssProviderPrivate*{.final, pure.} = object 
  
type 
  PEventBoxPrivate* = ptr TEventBoxPrivate
  TEventBoxPrivate*{.final, pure.} = object 
  
type 
  PComboBoxTextPrivate* = ptr TComboBoxTextPrivate
  TComboBoxTextPrivate*{.final, pure.} = object 
  
type 
  PCellRendererTogglePrivate* = ptr TCellRendererTogglePrivate
  TCellRendererTogglePrivate*{.final, pure.} = object 
  
type 
  PCheckMenuItemPrivate* = ptr TCheckMenuItemPrivate
  TCheckMenuItemPrivate*{.final, pure.} = object 
  
type 
  PMenuItemPrivate* = ptr TMenuItemPrivate
  TMenuItemPrivate*{.final, pure.} = object 
  
type 
  PFixedPrivate* = ptr TFixedPrivate
  TFixedPrivate*{.final, pure.} = object 
  
type 
  PExpanderPrivate* = ptr TExpanderPrivate
  TExpanderPrivate*{.final, pure.} = object 
  
type 
  PCellViewPrivate* = ptr TCellViewPrivate
  TCellViewPrivate*{.final, pure.} = object 
  
type 
  PColorButtonPrivate* = ptr TColorButtonPrivate
  TColorButtonPrivate*{.final, pure.} = object 
  
type 
  PColorChooserDialogPrivate* = ptr TColorChooserDialogPrivate
  TColorChooserDialogPrivate*{.final, pure.} = object 
  
type 
  PToggleButtonPrivate* = ptr TToggleButtonPrivate
  TToggleButtonPrivate*{.final, pure.} = object 
  
type 
  PCellRendererSpinnerPrivate* = ptr TCellRendererSpinnerPrivate
  TCellRendererSpinnerPrivate*{.final, pure.} = object 
  
type 
  PCellRendererSpinPrivate* = ptr TCellRendererSpinPrivate
  TCellRendererSpinPrivate*{.final, pure.} = object 
  
type 
  PCellRendererProgressPrivate* = ptr TCellRendererProgressPrivate
  TCellRendererProgressPrivate*{.final, pure.} = object 
  
type 
  PCellRendererPixbufPrivate* = ptr TCellRendererPixbufPrivate
  TCellRendererPixbufPrivate*{.final, pure.} = object 
  
type 
  PCellRendererComboPrivate* = ptr TCellRendererComboPrivate
  TCellRendererComboPrivate*{.final, pure.} = object 
  
type 
  PCellRendererAccelPrivate* = ptr TCellRendererAccelPrivate
  TCellRendererAccelPrivate*{.final, pure.} = object 
  
type 
  PCellRendererTextPrivate* = ptr TCellRendererTextPrivate
  TCellRendererTextPrivate*{.final, pure.} = object 
  
type 
  PButtonPrivate* = ptr TButtonPrivate
  TButtonPrivate*{.final, pure.} = object 
  
type 
  PBuildable* = ptr TBuildable
  TBuildable*{.final, pure.} = object 
  
type 
  PIconSet* = ptr TIconSet
  TIconSet*{.final, pure.} = object 
  
type 
  PCellAreaBoxPrivate* = ptr TCellAreaBoxPrivate
  TCellAreaBoxPrivate*{.final, pure.} = object 
  
type 
  PAssistantPrivate* = ptr TAssistantPrivate
  TAssistantPrivate*{.final, pure.} = object 
  
type 
  PButtonBoxPrivate* = ptr TButtonBoxPrivate
  TButtonBoxPrivate*{.final, pure.} = object 
  
type 
  PAspectFramePrivate* = ptr TAspectFramePrivate
  TAspectFramePrivate*{.final, pure.} = object 
  
type 
  PCalendarPrivate* = ptr TCalendarPrivate
  TCalendarPrivate*{.final, pure.} = object 
  
type 
  PFramePrivate* = ptr TFramePrivate
  TFramePrivate*{.final, pure.} = object 
  
type 
  PTreeSelectionPrivate* = ptr TTreeSelectionPrivate
  TTreeSelectionPrivate*{.final, pure.} = object 
  
type 
  PApplicationWindowPrivate* = ptr TApplicationWindowPrivate
  TApplicationWindowPrivate*{.final, pure.} = object 
  
type 
  PArrowPrivate* = ptr TArrowPrivate
  TArrowPrivate*{.final, pure.} = object 
  
type 
  PAppChooserButtonPrivate* = ptr TAppChooserButtonPrivate
  TAppChooserButtonPrivate*{.final, pure.} = object 
  
type 
  PComboBoxPrivate* = ptr TComboBoxPrivate
  TComboBoxPrivate*{.final, pure.} = object 
  
type 
  PTreeViewPrivate* = ptr TTreeViewPrivate
  TTreeViewPrivate*{.final, pure.} = object 
  
type 
  PEntryPrivate* = ptr TEntryPrivate
  TEntryPrivate*{.final, pure.} = object 
  
type 
  PImagePrivate* = ptr TImagePrivate
  TImagePrivate*{.final, pure.} = object 
  
type 
  PEntryCompletionPrivate* = ptr TEntryCompletionPrivate
  TEntryCompletionPrivate*{.final, pure.} = object 
  
type 
  PEditable* = ptr TEditable
  TEditable*{.final, pure.} = object 
  
type 
  PTargetList* = ptr TTargetList
  TTargetList*{.final, pure.} = object 
  
type 
  PTreeModelFilterPrivate* = ptr TTreeModelFilterPrivate
  TTreeModelFilterPrivate*{.final, pure.} = object 
  
type 
  PEntryBufferPrivate* = ptr TEntryBufferPrivate
  TEntryBufferPrivate*{.final, pure.} = object 
  
type 
  PListStorePrivate* = ptr TListStorePrivate
  TListStorePrivate*{.final, pure.} = object 
  
type 
  PTextBufferPrivate* = ptr TTextBufferPrivate
  TTextBufferPrivate*{.final, pure.} = object 
  
type 
  PTextTagPrivate* = ptr TTextTagPrivate
  TTextTagPrivate*{.final, pure.} = object 
  
type 
  PTreeViewColumnPrivate* = ptr TTreeViewColumnPrivate
  TTreeViewColumnPrivate*{.final, pure.} = object 
  
type 
  PTreeSortable* = ptr TTreeSortable
  TTreeSortable*{.final, pure.} = object 
  
type 
  PCellAreaContextPrivate* = ptr TCellAreaContextPrivate
  TCellAreaContextPrivate*{.final, pure.} = object 
  
type 
  PCellAreaPrivate* = ptr TCellAreaPrivate
  TCellAreaPrivate*{.final, pure.} = object 
  
type 
  PCellRendererClassPrivate* = ptr TCellRendererClassPrivate
  TCellRendererClassPrivate*{.final, pure.} = object 
  
type 
  PCellRendererPrivate* = ptr TCellRendererPrivate
  TCellRendererPrivate*{.final, pure.} = object 
  
type 
  PCellEditable* = ptr TCellEditable
  TCellEditable*{.final, pure.} = object 
  
type 
  PTreeRowReference* = ptr TTreeRowReference
  TTreeRowReference*{.final, pure.} = object 
  
type 
  PTreePath* = ptr TTreePath
  TTreePath*{.final, pure.} = object 
  
type 
  PTreeModel* = ptr TTreeModel
  TTreeModel*{.final, pure.} = object 
  
type 
  PActionable* = ptr TActionable
  TActionable*{.final, pure.} = object 
  
type 
  PAppChooserDialogPrivate* = ptr TAppChooserDialogPrivate
  TAppChooserDialogPrivate*{.final, pure.} = object 
  
type 
  PAppChooser* = ptr TAppChooser
  TAppChooser*{.final, pure.} = object 
  
type 
  PAccelMap* = ptr TAccelMap
  TAccelMap*{.final, pure.} = object 
  
type 
  PBoxPrivate* = ptr TBoxPrivate
  TBoxPrivate*{.final, pure.} = object 
  
type 
  PAlignmentPrivate* = ptr TAlignmentPrivate
  TAlignmentPrivate*{.final, pure.} = object 
  
type 
  PAccelLabelPrivate* = ptr TAccelLabelPrivate
  TAccelLabelPrivate*{.final, pure.} = object 
  
type 
  PAccessiblePrivate* = ptr TAccessiblePrivate
  TAccessiblePrivate*{.final, pure.} = object 
  
type 
  PLabelPrivate* = ptr TLabelPrivate
  TLabelPrivate*{.final, pure.} = object 
  
type 
  PMenuShellPrivate* = ptr TMenuShellPrivate
  TMenuShellPrivate*{.final, pure.} = object 
  
type 
  PMenuPrivate* = ptr TMenuPrivate
  TMenuPrivate*{.final, pure.} = object 
  
type 
  PMiscPrivate* = ptr TMiscPrivate
  TMiscPrivate*{.final, pure.} = object 
  
type 
  PAboutDialogPrivate* = ptr TAboutDialogPrivate
  TAboutDialogPrivate*{.final, pure.} = object 
  
type 
  PDialogPrivate* = ptr TDialogPrivate
  TDialogPrivate*{.final, pure.} = object 
  
type 
  PWindowGroupPrivate* = ptr TWindowGroupPrivate
  TWindowGroupPrivate*{.final, pure.} = object 
  
type 
  PWindowPrivate* = ptr TWindowPrivate
  TWindowPrivate*{.final, pure.} = object 
  
type 
  PBinPrivate* = ptr TBinPrivate
  TBinPrivate*{.final, pure.} = object 
  
type 
  PAdjustmentPrivate* = ptr TAdjustmentPrivate
  TAdjustmentPrivate*{.final, pure.} = object 
  
type 
  PContainerPrivate* = ptr TContainerPrivate
  TContainerPrivate*{.final, pure.} = object 
  
type 
  PApplicationPrivate* = ptr TApplicationPrivate
  TApplicationPrivate*{.final, pure.} = object 
  
type 
  PSettingsPrivate* = ptr TSettingsPrivate
  TSettingsPrivate*{.final, pure.} = object 
  
type 
  PWidgetClassPrivate* = ptr TWidgetClassPrivate
  TWidgetClassPrivate*{.final, pure.} = object 
  
type 
  PFontChooserWidgetPrivate* = ptr TFontChooserWidgetPrivate
  TFontChooserWidgetPrivate*{.final, pure.} = object 
  
type 
  PFontChooser* = ptr TFontChooser
  TFontChooser*{.final, pure.} = object 
  
type 
  PColorChooserWidgetPrivate* = ptr TColorChooserWidgetPrivate
  TColorChooserWidgetPrivate*{.final, pure.} = object 
  
type 
  PAppChooserWidgetPrivate* = ptr TAppChooserWidgetPrivate
  TAppChooserWidgetPrivate*{.final, pure.} = object 
  
type 
  PWidgetPath* = ptr TWidgetPath
  TWidgetPath*{.final, pure.} = object 
  
type 
  PClipboard* = ptr TClipboard
  TClipboard*{.final, pure.} = object 
  
type 
  PTooltip* = ptr TTooltip
  TTooltip*{.final, pure.} = object 
  
type 
  PSelectionData* = ptr TSelectionData
  TSelectionData*{.final, pure.} = object 
  
type 
  PWidgetPrivate* = ptr TWidgetPrivate
  TWidgetPrivate*{.final, pure.} = object 
  
type 
  PBuilderPrivate* = ptr TBuilderPrivate
  TBuilderPrivate*{.final, pure.} = object 
  
type 
  PAccelGroupPrivate* = ptr TAccelGroupPrivate
  TAccelGroupPrivate*{.final, pure.} = object 
  
template TYPE_ACCEL_GROUP*(): expr = 
  (gtk_accel_group_get_type())

template ACCEL_GROUP_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ACCEL_GROUP, TAccelGroup))

template ACCEL_GROUP_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ACCEL_GROUP, TAccelGroupClass))

template IS_ACCEL_GROUP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ACCEL_GROUP))

template IS_ACCEL_GROUP_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ACCEL_GROUP))

template ACCEL_GROUP_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ACCEL_GROUP, TAccelGroupClass))

type 
  TAccelFlags* {.size: sizeof(cint).} = enum 
    ACCEL_VISIBLE = 1 shl 0, ACCEL_LOCKED = 1 shl 1, 
    ACCEL_MASK = 0x00000007
type 
  PAccelGroup* = ptr TAccelGroup
  TAccelGroup* = object of TGObject
    priv1: PAccelGroupPrivate

type 
  PAccelGroupClass* = ptr TAccelGroupClass
  TAccelGroupClass* = object of TGObjectClass
    accel_changed*: proc (accel_group: PAccelGroup; keyval: guint; 
                          modifier: gdk3.TModifierType; 
                          accel_closure: PGClosure) {.cdecl.}
    ugtk_reserved11: proc () {.cdecl.}
    ugtk_reserved12: proc () {.cdecl.}
    ugtk_reserved13: proc () {.cdecl.}
    ugtk_reserved14: proc () {.cdecl.}

type 
  PAccelKey* = ptr TAccelKey
  TAccelKey*{.final, pure.} = object 
    accel_key*: guint
    accel_mods*: gdk3.TModifierType
    accel_flags*: guint

type 
  TAccelGroupActivate* = proc (accel_group: PAccelGroup; 
                                 acceleratable: PGObject; keyval: guint; 
                                 modifier: gdk3.TModifierType): gboolean {.cdecl.}
type 
  TAccelGroupFindFunc* = proc (key: PAccelKey; closure: PGClosure; 
                                 data: gpointer): gboolean {.cdecl.}

proc accel_group_get_type*(): GType {.cdecl, 
    importc: "gtk_accel_group_get_type", dynlib: lib.}
proc accel_group_new*(): PAccelGroup {.cdecl, 
    importc: "gtk_accel_group_new", dynlib: lib.}
proc get_is_locked*(accel_group: PAccelGroup): gboolean {.
    cdecl, importc: "gtk_accel_group_get_is_locked", dynlib: lib.}
proc get_modifier_mask*(accel_group: PAccelGroup): gdk3.TModifierType {.
    cdecl, importc: "gtk_accel_group_get_modifier_mask", dynlib: lib.}
proc lock*(accel_group: PAccelGroup) {.cdecl, 
    importc: "gtk_accel_group_lock", dynlib: lib.}
proc unlock*(accel_group: PAccelGroup) {.cdecl, 
    importc: "gtk_accel_group_unlock", dynlib: lib.}
proc connect*(accel_group: PAccelGroup; 
                              accel_key: guint; accel_mods: gdk3.TModifierType; 
                              accel_flags: TAccelFlags; 
                              closure: PGClosure) {.cdecl, 
    importc: "gtk_accel_group_connect", dynlib: lib.}
proc connect_by_path*(accel_group: PAccelGroup; 
                                      accel_path: CSTRING; 
                                      closure: PGClosure) {.cdecl, 
    importc: "gtk_accel_group_connect_by_path", dynlib: lib.}
proc disconnect*(accel_group: PAccelGroup; 
                                 closure: PGClosure): gboolean {.cdecl, 
    importc: "gtk_accel_group_disconnect", dynlib: lib.}
proc disconnect_key*(accel_group: PAccelGroup; 
                                     accel_key: guint; 
                                     accel_mods: gdk3.TModifierType): gboolean {.
    cdecl, importc: "gtk_accel_group_disconnect_key", dynlib: lib.}
proc activate*(accel_group: PAccelGroup; 
                               accel_quark: TGQuark; 
                               acceleratable: PGObject; accel_key: guint; 
                               accel_mods: gdk3.TModifierType): gboolean {.cdecl, 
    importc: "gtk_accel_group_activate", dynlib: lib.}
proc underscore_gtk_accel_group_attach*(accel_group: PAccelGroup; 
                              obj: PGObject) {.cdecl, 
    importc: "_gtk_accel_group_attach", dynlib: lib.}
proc underscore_gtk_accel_group_detach*(accel_group: PAccelGroup; 
                              obj: PGObject) {.cdecl, 
    importc: "_gtk_accel_group_detach", dynlib: lib.}
proc accel_groups_activate*(obj: PGObject; accel_key: guint; 
                                accel_mods: gdk3.TModifierType): gboolean {.
    cdecl, importc: "gtk_accel_groups_activate", dynlib: lib.}
proc accel_groups_from_object*(obj: PGObject): PGSList {.cdecl, 
    importc: "gtk_accel_groups_from_object", dynlib: lib.}
proc find*(accel_group: PAccelGroup; 
                           find_func: TAccelGroupFindFunc; data: gpointer): PAccelKey {.
    cdecl, importc: "gtk_accel_group_find", dynlib: lib.}
proc accel_group_from_accel_closure*(closure: PGClosure): PAccelGroup {.
    cdecl, importc: "gtk_accel_group_from_accel_closure", dynlib: lib.}
proc accelerator_valid*(keyval: guint; modifiers: gdk3.TModifierType): gboolean {.
    cdecl, importc: "gtk_accelerator_valid", dynlib: lib.}
proc parse*(accelerator: CSTRING; 
                            accelerator_key: Pguint; 
                            accelerator_mods: PModifierType) {.cdecl, 
    importc: "gtk_accelerator_parse", dynlib: lib.}
proc parse_with_keycode*(accelerator: CSTRING; 
    accelerator_key: Pguint; accelerator_codes: ptr Pguint; 
    accelerator_mods: PModifierType) {.cdecl, 
    importc: "gtk_accelerator_parse_with_keycode", dynlib: lib.}
proc accelerator_name*(accelerator_key: guint; 
                           accelerator_mods: gdk3.TModifierType): CSTRING {.
    cdecl, importc: "gtk_accelerator_name", dynlib: lib.}
proc accelerator_name_with_keycode*(display: PGdkDisplay; 
    accelerator_key: guint; keycode: guint; accelerator_mods: gdk3.TModifierType): CSTRING {.
    cdecl, importc: "gtk_accelerator_name_with_keycode", dynlib: lib.}
proc accelerator_get_label*(accelerator_key: guint; 
                                accelerator_mods: gdk3.TModifierType): CSTRING {.
    cdecl, importc: "gtk_accelerator_get_label", dynlib: lib.}
proc accelerator_get_label_with_keycode*(display: PGdkDisplay; 
    accelerator_key: guint; keycode: guint; accelerator_mods: gdk3.TModifierType): CSTRING {.
    cdecl, importc: "gtk_accelerator_get_label_with_keycode", dynlib: lib.}
proc accelerator_set_default_mod_mask*(default_mod_mask: gdk3.TModifierType) {.
    cdecl, importc: "gtk_accelerator_set_default_mod_mask", dynlib: lib.}
proc accelerator_get_default_mod_mask*(): gdk3.TModifierType {.cdecl, 
    importc: "gtk_accelerator_get_default_mod_mask", dynlib: lib.}
type 
  PAccelGroupEntry* = ptr TAccelGroupEntry
  TAccelGroupEntry*{.final, pure.} = object 
    key*: TAccelKey
    closure*: PGClosure
    accel_path_quark*: TGQuark
proc query*(accel_group: PAccelGroup; accel_key: guint; 
                            accel_mods: gdk3.TModifierType; n_entries: Pguint): PAccelGroupEntry {.
    cdecl, importc: "gtk_accel_group_query", dynlib: lib.}


template TYPE_BORDER*(): expr = 
  (gtk_border_get_type())

type 
  PBorder* = ptr TBorder
  TBorder*{.final, pure.} = object 
    left*: gint16
    right*: gint16
    top*: gint16
    bottom*: gint16

proc border_get_type*(): GType {.cdecl, importc: "gtk_border_get_type", 
                                     dynlib: lib.}
proc border_new*(): PBorder {.cdecl, importc: "gtk_border_new", 
    dynlib: lib.}
proc copy*(border: PBorder): PBorder {.cdecl, 
    importc: "gtk_border_copy", dynlib: lib.}
proc free*(border: PBorder) {.cdecl, 
    importc: "gtk_border_free", dynlib: lib.}

type 
  TRcPropertyParser* = proc (pspec: PGParamSpec; rc_string: PGString; 
                               property_value: PGValue): gboolean {.cdecl.}
type 
  PBuilder* = ptr TBuilder
  TBuilder* = object of TGObject
    priv2: PBuilderPrivate
  TBuilderConnectFunc* = proc (builder: PBuilder; obj: PGObject; 
                                 signal_name: CSTRING; 
                                 handler_name: CSTRING; 
                                 connect_obj: PGObject; 
                                 flags: TGConnectFlags; user_data: gpointer) {.
      cdecl.}

type 
  TWidgetHelpType* {.size: sizeof(cint).} = enum 
    WIDGET_HELP_TOOLTIP, WIDGET_HELP_WHATS_THIS
template TYPE_WIDGET*(): expr = 
  (gtk_widget_get_type())

template WIDGET_TEMPLATE*(widget: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((widget), TYPE_WIDGET, TWidget))

template WIDGET_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WIDGET, TWidgetClass))

template IS_WIDGET*(widget: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((widget), TYPE_WIDGET))

template IS_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WIDGET))

template WIDGET_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WIDGET, TWidgetClass))

template TYPE_REQUISITION*(): expr = 
  (gtk_requisition_get_type())

type 
  PAllocation* = gdk3.PRectangle
  TAllocation* = gdk3.TRectangle
type 
  PRequisition* = ptr TRequisition
  TRequisition*{.final, pure.} = object 
    width*: gint
    height*: gint

type 
  PWidget* = ptr TWidget
  TWidget* = object of TGInitiallyUnowned
    priv3: PWidgetPrivate
type 
  TCallback* = proc (widget: PWidget; data: gpointer) {.cdecl.}
type 
  TTickCallback* = proc (widget: PWidget; 
                           frame_clock: PFrameClock; user_data: gpointer): gboolean {.
      cdecl.}

type 
  PWidgetClass* = ptr TWidgetClass
  TWidgetClass* = object of TGInitiallyUnownedClass
    activate_signal*: guint
    dispatch_child_properties_changed*: proc (widget: PWidget; 
        n_pspecs: guint; pspecs: ptr PGParamSpec) {.cdecl.}
    destroy*: proc (widget: PWidget) {.cdecl.}
    show*: proc (widget: PWidget) {.cdecl.}
    show_all*: proc (widget: PWidget) {.cdecl.}
    hide*: proc (widget: PWidget) {.cdecl.}
    map*: proc (widget: PWidget) {.cdecl.}
    unmap*: proc (widget: PWidget) {.cdecl.}
    realize*: proc (widget: PWidget) {.cdecl.}
    unrealize*: proc (widget: PWidget) {.cdecl.}
    size_allocate*: proc (widget: PWidget; allocation: PAllocation) {.
        cdecl.}
    state_changed*: proc (widget: PWidget; previous_state: TStateType) {.
        cdecl.}
    state_flags_changed*: proc (widget: PWidget; 
                                previous_state_flags: TStateFlags) {.cdecl.}
    parent_set*: proc (widget: PWidget; previous_parent: PWidget) {.
        cdecl.}
    hierarchy_changed*: proc (widget: PWidget; 
                              previous_toplevel: PWidget) {.cdecl.}
    style_set*: proc (widget: PWidget; previous_style: PStyle) {.
        cdecl.}
    direction_changed*: proc (widget: PWidget; 
                              previous_direction: TTextDirection) {.cdecl.}
    grab_notify*: proc (widget: PWidget; was_grabbed: gboolean) {.cdecl.}
    child_notify*: proc (widget: PWidget; child_property: PGParamSpec) {.
        cdecl.}
    draw*: proc (widget: PWidget; cr: cairo.Pcontext): gboolean {.cdecl.}
    get_request_mode*: proc (widget: PWidget): TSizeRequestMode {.
        cdecl.}
    get_preferred_height*: proc (widget: PWidget; 
                                 minimum_height: Pgint; 
                                 natural_height: Pgint) {.cdecl.}
    get_preferred_width_for_height*: proc (widget: PWidget; 
        height: gint; minimum_width: Pgint; natural_width: Pgint) {.
        cdecl.}
    get_preferred_width*: proc (widget: PWidget; 
                                minimum_width: Pgint; 
                                natural_width: Pgint) {.cdecl.}
    get_preferred_height_for_width*: proc (widget: PWidget; width: gint; 
        minimum_height: Pgint; natural_height: Pgint) {.cdecl.}
    mnemonic_activate*: proc (widget: PWidget; group_cycling: gboolean): gboolean {.
        cdecl.}
    grab_focus*: proc (widget: PWidget) {.cdecl.}
    focus*: proc (widget: PWidget; direction: TDirectionType): gboolean {.
        cdecl.}
    move_focus*: proc (widget: PWidget; direction: TDirectionType) {.
        cdecl.}
    keynav_failed*: proc (widget: PWidget; direction: TDirectionType): gboolean {.
        cdecl.}
    event*: proc (widget: PWidget; event: PEvent): gboolean {.
        cdecl.}
    button_press_event*: proc (widget: PWidget; 
                               event: PEventButton): gboolean {.cdecl.}
    button_release_event*: proc (widget: PWidget; 
                                 event: PEventButton): gboolean {.cdecl.}
    scroll_event*: proc (widget: PWidget; event: PEventScroll): gboolean {.
        cdecl.}
    motion_notify_event*: proc (widget: PWidget; 
                                event: PEventMotion): gboolean {.cdecl.}
    delete_event*: proc (widget: PWidget; event: PEventAny): gboolean {.
        cdecl.}
    destroy_event*: proc (widget: PWidget; event: PEventAny): gboolean {.
        cdecl.}
    key_press_event*: proc (widget: PWidget; event: PEventKey): gboolean {.
        cdecl.}
    key_release_event*: proc (widget: PWidget; event: PEventKey): gboolean {.
        cdecl.}
    enter_notify_event*: proc (widget: PWidget; 
                               event: PEventCrossing): gboolean {.cdecl.}
    leave_notify_event*: proc (widget: PWidget; 
                               event: PEventCrossing): gboolean {.cdecl.}
    configure_event*: proc (widget: PWidget; 
                            event: PEventConfigure): gboolean {.cdecl.}
    focus_in_event*: proc (widget: PWidget; event: PEventFocus): gboolean {.
        cdecl.}
    focus_out_event*: proc (widget: PWidget; event: PEventFocus): gboolean {.
        cdecl.}
    map_event*: proc (widget: PWidget; event: PEventAny): gboolean {.
        cdecl.}
    unmap_event*: proc (widget: PWidget; event: PEventAny): gboolean {.
        cdecl.}
    property_notify_event*: proc (widget: PWidget; 
                                  event: PEventProperty): gboolean {.
        cdecl.}
    selection_clear_event*: proc (widget: PWidget; 
                                  event: PEventSelection): gboolean {.
        cdecl.}
    selection_request_event*: proc (widget: PWidget; 
                                    event: PEventSelection): gboolean {.
        cdecl.}
    selection_notify_event*: proc (widget: PWidget; 
                                   event: PEventSelection): gboolean {.
        cdecl.}
    proximity_in_event*: proc (widget: PWidget; 
                               event: PEventProximity): gboolean {.cdecl.}
    proximity_out_event*: proc (widget: PWidget; 
                                event: PEventProximity): gboolean {.
        cdecl.}
    visibility_notify_event*: proc (widget: PWidget; 
                                    event: PEventVisibility): gboolean {.
        cdecl.}
    window_state_event*: proc (widget: PWidget; 
                               event: PEventWindowState): gboolean {.
        cdecl.}
    damage_event*: proc (widget: PWidget; event: PEventExpose): gboolean {.
        cdecl.}
    grab_broken_event*: proc (widget: PWidget; 
                              event: PEventGrabBroken): gboolean {.cdecl.}
    selection_get*: proc (widget: PWidget; 
                          selection_data: PSelectionData; info: guint; 
                          time: guint) {.cdecl.}
    selection_received*: proc (widget: PWidget; 
                               selection_data: PSelectionData; 
                               time: guint) {.cdecl.}
    drag_begin*: proc (widget: PWidget; context: PDragContext) {.
        cdecl.}
    drag_end*: proc (widget: PWidget; context: PDragContext) {.
        cdecl.}
    drag_data_get*: proc (widget: PWidget; context: PDragContext; 
                          selection_data: PSelectionData; info: guint; 
                          time: guint) {.cdecl.}
    drag_data_delete*: proc (widget: PWidget; 
                             context: PDragContext) {.cdecl.}
    drag_leave*: proc (widget: PWidget; context: PDragContext; 
                       time: guint) {.cdecl.}
    drag_motion*: proc (widget: PWidget; context: PDragContext; 
                        x: gint; y: gint; time: guint): gboolean {.cdecl.}
    drag_drop*: proc (widget: PWidget; context: PDragContext; 
                      x: gint; y: gint; time: guint): gboolean {.cdecl.}
    drag_data_received*: proc (widget: PWidget; 
                               context: PDragContext; x: gint; y: gint; 
                               selection_data: PSelectionData; 
                               info: guint; time: guint) {.cdecl.}
    drag_failed*: proc (widget: PWidget; context: PDragContext; 
                        result: TDragResult): gboolean {.cdecl.}
    popup_menu*: proc (widget: PWidget): gboolean {.cdecl.}
    show_help*: proc (widget: PWidget; help_type: TWidgetHelpType): gboolean {.
        cdecl.}
    get_accessible*: proc (widget: PWidget): atk.PObject {.cdecl.}
    screen_changed*: proc (widget: PWidget; 
                           previous_screen: PGdkScreen) {.cdecl.}
    can_activate_accel*: proc (widget: PWidget; signal_id: guint): gboolean {.
        cdecl.}
    composited_changed*: proc (widget: PWidget) {.cdecl.}
    query_tooltip*: proc (widget: PWidget; x: gint; y: gint; 
                          keyboard_tooltip: gboolean; tooltip: PTooltip): gboolean {.
        cdecl.}
    compute_expand*: proc (widget: PWidget; hexpand_p: Pgboolean; 
                           vexpand_p: Pgboolean) {.cdecl.}
    adjust_size_request*: proc (widget: PWidget; 
                                orientation: TOrientation; 
                                minimum_size: Pgint; natural_size: Pgint) {.
        cdecl.}
    adjust_size_allocation*: proc (widget: PWidget; 
                                   orientation: TOrientation; 
                                   minimum_size: Pgint; 
                                   natural_size: Pgint; 
                                   allocated_pos: Pgint; 
                                   allocated_size: Pgint) {.cdecl.}
    style_updated*: proc (widget: PWidget) {.cdecl.}
    touch_event*: proc (widget: PWidget; event: PEventTouch): gboolean {.
        cdecl.}
    get_preferred_height_and_baseline_for_width*: proc (widget: PWidget; 
        width: gint; minimum_height: Pgint; natural_height: Pgint; 
        minimum_baseline: Pgint; natural_baseline: Pgint) {.cdecl.}
    adjust_baseline_request*: proc (widget: PWidget; 
                                    minimum_baseline: Pgint; 
                                    natural_baseline: Pgint) {.cdecl.}
    adjust_baseline_allocation*: proc (widget: PWidget; 
        baseline: Pgint) {.cdecl.}
    queue_draw_region*: proc (widget: PWidget; 
                              Tregion: Pregion) {.cdecl.}
    priv4: PWidgetClassPrivate
    ugtk_reserved26: proc () {.cdecl.}
    ugtk_reserved27: proc () {.cdecl.}

type 
  PWidgetAuxInfo* = ptr TWidgetAuxInfo
  TWidgetAuxInfo*{.final, pure.} = object 
    width*: gint
    height*: gint
    halign4valign4*: guint
    margin*: TBorder
type 
  PSettings* = ptr TSettings
  TSettings* = object of TGObject
    priv5: PSettingsPrivate
type 
  PStyleContext* = ptr TStyleContext
  TStyleContext* = object of TGObject
    priv6: PStyleContextPrivate

type 
  PStyleContextClass* = ptr TStyleContextClass
  TStyleContextClass* = object of TGObjectClass
    changed*: proc (context: PStyleContext) {.cdecl.}
    ugtk_reserved31: proc () {.cdecl.}
    ugtk_reserved32: proc () {.cdecl.}
    ugtk_reserved33: proc () {.cdecl.}
    ugtk_reserved34: proc () {.cdecl.}

proc widget_get_type*(): GType {.cdecl, importc: "gtk_widget_get_type", 
                                     dynlib: lib.}
proc widget_new*(typ: GType; first_property_name: CSTRING): PWidget {.
    varargs, cdecl, importc: "gtk_widget_new", dynlib: lib.}
proc destroy*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_destroy", dynlib: lib.}
proc destroyed*(widget: PWidget; 
                           widget_pointer: ptr PWidget) {.cdecl, 
    importc: "gtk_widget_destroyed", dynlib: lib.}
proc unparent*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_unparent", dynlib: lib.}
proc show*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_show", dynlib: lib.}
proc hide*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_hide", dynlib: lib.}
proc show_now*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_show_now", dynlib: lib.}
proc show_all*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_show_all", dynlib: lib.}
proc set_no_show_all*(widget: PWidget; no_show_all: gboolean) {.
    cdecl, importc: "gtk_widget_set_no_show_all", dynlib: lib.}
proc get_no_show_all*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_no_show_all", dynlib: lib.}
proc map*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_map", dynlib: lib.}
proc unmap*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_unmap", dynlib: lib.}
proc realize*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_realize", dynlib: lib.}
proc unrealize*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_unrealize", dynlib: lib.}
proc draw*(widget: PWidget; cr: cairo.Pcontext) {.cdecl, 
    importc: "gtk_widget_draw", dynlib: lib.}
proc queue_draw*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_queue_draw", dynlib: lib.}
proc queue_draw_area*(widget: PWidget; x: gint; y: gint; 
                                 width: gint; height: gint) {.cdecl, 
    importc: "gtk_widget_queue_draw_area", dynlib: lib.}
proc queue_draw_region*(widget: PWidget; 
                                   Tregion: Pregion) {.cdecl, 
    importc: "gtk_widget_queue_draw_region", dynlib: lib.}
proc queue_resize*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_queue_resize", dynlib: lib.}
proc queue_resize_no_redraw*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_queue_resize_no_redraw", dynlib: lib.}
proc get_frame_clock*(widget: PWidget): PFrameClock {.
    cdecl, importc: "gtk_widget_get_frame_clock", dynlib: lib.}
proc size_request*(widget: PWidget; 
                              requisition: PRequisition) {.cdecl, 
    importc: "gtk_widget_size_request", dynlib: lib.}
proc size_allocate*(widget: PWidget; 
                               allocation: PAllocation) {.cdecl, 
    importc: "gtk_widget_size_allocate", dynlib: lib.}
proc size_allocate_with_baseline*(widget: PWidget; 
    allocation: PAllocation; baseline: gint) {.cdecl, 
    importc: "gtk_widget_size_allocate_with_baseline", dynlib: lib.}
proc get_request_mode*(widget: PWidget): TSizeRequestMode {.
    cdecl, importc: "gtk_widget_get_request_mode", dynlib: lib.}
proc get_preferred_width*(widget: PWidget; 
                                     minimum_width: Pgint; 
                                     natural_width: Pgint) {.cdecl, 
    importc: "gtk_widget_get_preferred_width", dynlib: lib.}
proc get_preferred_height_for_width*(widget: PWidget; 
    width: gint; minimum_height: Pgint; natural_height: Pgint) {.cdecl, 
    importc: "gtk_widget_get_preferred_height_for_width", dynlib: lib.}
proc get_preferred_height*(widget: PWidget; 
                                      minimum_height: Pgint; 
                                      natural_height: Pgint) {.cdecl, 
    importc: "gtk_widget_get_preferred_height", dynlib: lib.}
proc get_preferred_width_for_height*(widget: PWidget; 
    height: gint; minimum_width: Pgint; natural_width: Pgint) {.cdecl, 
    importc: "gtk_widget_get_preferred_width_for_height", dynlib: lib.}
proc get_preferred_height_and_baseline_for_width*(
    widget: PWidget; width: gint; minimum_height: Pgint; 
    natural_height: Pgint; minimum_baseline: Pgint; 
    natural_baseline: Pgint) {.cdecl, importc: "gtk_widget_get_preferred_height_and_baseline_for_width", 
                                  dynlib: lib.}
proc get_preferred_size*(widget: PWidget; 
                                    minimum_size: PRequisition; 
                                    natural_size: PRequisition) {.cdecl, 
    importc: "gtk_widget_get_preferred_size", dynlib: lib.}
proc get_child_requisition*(widget: PWidget; 
    requisition: PRequisition) {.cdecl, 
    importc: "gtk_widget_get_child_requisition", dynlib: lib.}
proc add_accelerator*(widget: PWidget; 
                                 accel_signal: CSTRING; 
                                 accel_group: PAccelGroup; 
                                 accel_key: guint; 
                                 accel_mods: gdk3.TModifierType; 
                                 accel_flags: TAccelFlags) {.cdecl, 
    importc: "gtk_widget_add_accelerator", dynlib: lib.}
proc remove_accelerator*(widget: PWidget; 
                                    accel_group: PAccelGroup; 
                                    accel_key: guint; 
                                    accel_mods: gdk3.TModifierType): gboolean {.
    cdecl, importc: "gtk_widget_remove_accelerator", dynlib: lib.}
proc set_accel_path*(widget: PWidget; accel_path: CSTRING; 
                                accel_group: PAccelGroup) {.cdecl, 
    importc: "gtk_widget_set_accel_path", dynlib: lib.}
proc list_accel_closures*(widget: PWidget): PGList {.
    cdecl, importc: "gtk_widget_list_accel_closures", dynlib: lib.}
proc can_activate_accel*(widget: PWidget; signal_id: guint): gboolean {.
    cdecl, importc: "gtk_widget_can_activate_accel", dynlib: lib.}
proc mnemonic_activate*(widget: PWidget; 
                                   group_cycling: gboolean): gboolean {.cdecl, 
    importc: "gtk_widget_mnemonic_activate", dynlib: lib.}
proc event*(widget: PWidget; event: PEvent): gboolean {.
    cdecl, importc: "gtk_widget_event", dynlib: lib.}
proc send_expose*(widget: PWidget; event: PEvent): gint {.
    cdecl, importc: "gtk_widget_send_expose", dynlib: lib.}
proc send_focus_change*(widget: PWidget; event: PEvent): gboolean {.
    cdecl, importc: "gtk_widget_send_focus_change", dynlib: lib.}
proc activate*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_activate", dynlib: lib.}
proc reparent*(widget: PWidget; new_parent: PWidget) {.
    cdecl, importc: "gtk_widget_reparent", dynlib: lib.}
proc intersect*(widget: PWidget; area: gdk3.PRectangle; 
                           intersection: gdk3.PRectangle): gboolean {.cdecl, 
    importc: "gtk_widget_intersect", dynlib: lib.}
proc region_intersect*(widget: PWidget; 
                                  Tregion: Pregion): Pregion {.
    cdecl, importc: "gtk_widget_region_intersect", dynlib: lib.}
proc freeze_child_notify*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_freeze_child_notify", dynlib: lib.}
proc child_notify*(widget: PWidget; child_property: CSTRING) {.
    cdecl, importc: "gtk_widget_child_notify", dynlib: lib.}
proc thaw_child_notify*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_thaw_child_notify", dynlib: lib.}
proc set_can_focus*(widget: PWidget; can_focus: gboolean) {.
    cdecl, importc: "gtk_widget_set_can_focus", dynlib: lib.}
proc get_can_focus*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_can_focus", dynlib: lib.}
proc has_focus*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_has_focus", dynlib: lib.}
proc is_focus*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_is_focus", dynlib: lib.}
proc has_visible_focus*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_has_visible_focus", dynlib: lib.}
proc grab_focus*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_grab_focus", dynlib: lib.}
proc set_can_default*(widget: PWidget; can_default: gboolean) {.
    cdecl, importc: "gtk_widget_set_can_default", dynlib: lib.}
proc get_can_default*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_can_default", dynlib: lib.}
proc has_default*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_has_default", dynlib: lib.}
proc grab_default*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_grab_default", dynlib: lib.}
proc set_receives_default*(widget: PWidget; 
                                      receives_default: gboolean) {.cdecl, 
    importc: "gtk_widget_set_receives_default", dynlib: lib.}
proc get_receives_default*(widget: PWidget): gboolean {.
    cdecl, importc: "gtk_widget_get_receives_default", dynlib: lib.}
proc has_grab*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_has_grab", dynlib: lib.}
proc device_is_shadowed*(widget: PWidget; 
                                    device: PDevice): gboolean {.cdecl, 
    importc: "gtk_widget_device_is_shadowed", dynlib: lib.}
proc set_name*(widget: PWidget; name: CSTRING) {.cdecl, 
    importc: "gtk_widget_set_name", dynlib: lib.}
proc get_name*(widget: PWidget): CSTRING {.cdecl, 
    importc: "gtk_widget_get_name", dynlib: lib.}
proc set_state*(widget: PWidget; state: TStateType) {.
    cdecl, importc: "gtk_widget_set_state", dynlib: lib.}
proc get_state*(widget: PWidget): TStateType {.cdecl, 
    importc: "gtk_widget_get_state", dynlib: lib.}
proc set_state_flags*(widget: PWidget; flags: TStateFlags; 
                                 clear: gboolean) {.cdecl, 
    importc: "gtk_widget_set_state_flags", dynlib: lib.}
proc unset_state_flags*(widget: PWidget; flags: TStateFlags) {.
    cdecl, importc: "gtk_widget_unset_state_flags", dynlib: lib.}
proc get_state_flags*(widget: PWidget): TStateFlags {.
    cdecl, importc: "gtk_widget_get_state_flags", dynlib: lib.}
proc set_sensitive*(widget: PWidget; sensitive: gboolean) {.
    cdecl, importc: "gtk_widget_set_sensitive", dynlib: lib.}
proc get_sensitive*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_sensitive", dynlib: lib.}
proc is_sensitive*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_is_sensitive", dynlib: lib.}
proc set_visible*(widget: PWidget; visible: gboolean) {.
    cdecl, importc: "gtk_widget_set_visible", dynlib: lib.}
proc get_visible*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_visible", dynlib: lib.}
proc is_visible*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_is_visible", dynlib: lib.}
proc set_has_window*(widget: PWidget; has_window: gboolean) {.
    cdecl, importc: "gtk_widget_set_has_window", dynlib: lib.}
proc get_has_window*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_has_window", dynlib: lib.}
proc is_toplevel*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_is_toplevel", dynlib: lib.}
proc is_drawable*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_is_drawable", dynlib: lib.}
proc set_realized*(widget: PWidget; realized: gboolean) {.
    cdecl, importc: "gtk_widget_set_realized", dynlib: lib.}
proc get_realized*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_realized", dynlib: lib.}
proc set_mapped*(widget: PWidget; mapped: gboolean) {.cdecl, 
    importc: "gtk_widget_set_mapped", dynlib: lib.}
proc get_mapped*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_mapped", dynlib: lib.}
proc set_app_paintable*(widget: PWidget; 
                                   app_paintable: gboolean) {.cdecl, 
    importc: "gtk_widget_set_app_paintable", dynlib: lib.}
proc get_app_paintable*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_app_paintable", dynlib: lib.}
proc set_double_buffered*(widget: PWidget; 
                                     double_buffered: gboolean) {.cdecl, 
    importc: "gtk_widget_set_double_buffered", dynlib: lib.}
proc get_double_buffered*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_double_buffered", dynlib: lib.}
proc set_redraw_on_allocate*(widget: PWidget; 
    redraw_on_allocate: gboolean) {.cdecl, importc: "gtk_widget_set_redraw_on_allocate", 
                                    dynlib: lib.}
proc set_parent*(widget: PWidget; parent: PWidget) {.
    cdecl, importc: "gtk_widget_set_parent", dynlib: lib.}
proc get_parent*(widget: PWidget): PWidget {.cdecl, 
    importc: "gtk_widget_get_parent", dynlib: lib.}
proc set_parent_window*(widget: PWidget; 
                                   parent_window: PGdkWindow) {.cdecl, 
    importc: "gtk_widget_set_parent_window", dynlib: lib.}
proc get_parent_window*(widget: PWidget): PGdkWindow {.
    cdecl, importc: "gtk_widget_get_parent_window", dynlib: lib.}
proc set_child_visible*(widget: PWidget; is_visible: gboolean) {.
    cdecl, importc: "gtk_widget_set_child_visible", dynlib: lib.}
proc get_child_visible*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_child_visible", dynlib: lib.}
proc set_window*(widget: PWidget; window: PGdkWindow) {.
    cdecl, importc: "gtk_widget_set_window", dynlib: lib.}
proc get_window*(widget: PWidget): PGdkWindow {.cdecl, 
    importc: "gtk_widget_get_window", dynlib: lib.}
proc register_window*(widget: PWidget; window: PGdkWindow) {.
    cdecl, importc: "gtk_widget_register_window", dynlib: lib.}
proc unregister_window*(widget: PWidget; 
                                   window: PGdkWindow) {.cdecl, 
    importc: "gtk_widget_unregister_window", dynlib: lib.}
proc get_allocated_width*(widget: PWidget): cint {.cdecl, 
    importc: "gtk_widget_get_allocated_width", dynlib: lib.}
proc get_allocated_height*(widget: PWidget): cint {.cdecl, 
    importc: "gtk_widget_get_allocated_height", dynlib: lib.}
proc get_allocated_baseline*(widget: PWidget): cint {.cdecl, 
    importc: "gtk_widget_get_allocated_baseline", dynlib: lib.}
proc get_allocation*(widget: PWidget; 
                                allocation: PAllocation) {.cdecl, 
    importc: "gtk_widget_get_allocation", dynlib: lib.}
proc set_allocation*(widget: PWidget; 
                                allocation: PAllocation) {.cdecl, 
    importc: "gtk_widget_set_allocation", dynlib: lib.}
proc get_requisition*(widget: PWidget; 
                                 requisition: PRequisition) {.cdecl, 
    importc: "gtk_widget_get_requisition", dynlib: lib.}
proc child_focus*(widget: PWidget; 
                             direction: TDirectionType): gboolean {.cdecl, 
    importc: "gtk_widget_child_focus", dynlib: lib.}
proc keynav_failed*(widget: PWidget; 
                               direction: TDirectionType): gboolean {.cdecl, 
    importc: "gtk_widget_keynav_failed", dynlib: lib.}
proc error_bell*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_error_bell", dynlib: lib.}
proc set_size_request*(widget: PWidget; width: gint; 
                                  height: gint) {.cdecl, 
    importc: "gtk_widget_set_size_request", dynlib: lib.}
proc get_size_request*(widget: PWidget; width: Pgint; 
                                  height: Pgint) {.cdecl, 
    importc: "gtk_widget_get_size_request", dynlib: lib.}
proc set_events*(widget: PWidget; events: gint) {.cdecl, 
    importc: "gtk_widget_set_events", dynlib: lib.}
proc add_events*(widget: PWidget; events: gint) {.cdecl, 
    importc: "gtk_widget_add_events", dynlib: lib.}
proc set_device_events*(widget: PWidget; 
                                   device: PDevice; events: TEventMask) {.
    cdecl, importc: "gtk_widget_set_device_events", dynlib: lib.}
proc add_device_events*(widget: PWidget; 
                                   device: PDevice; events: TEventMask) {.
    cdecl, importc: "gtk_widget_add_device_events", dynlib: lib.}
proc set_opacity*(widget: PWidget; opacity: cdouble) {.cdecl, 
    importc: "gtk_widget_set_opacity", dynlib: lib.}
proc get_opacity*(widget: PWidget): cdouble {.cdecl, 
    importc: "gtk_widget_get_opacity", dynlib: lib.}
proc set_device_enabled*(widget: PWidget; 
                                    device: PDevice; enabled: gboolean) {.
    cdecl, importc: "gtk_widget_set_device_enabled", dynlib: lib.}
proc get_device_enabled*(widget: PWidget; 
                                    device: PDevice): gboolean {.cdecl, 
    importc: "gtk_widget_get_device_enabled", dynlib: lib.}
proc get_toplevel*(widget: PWidget): PWidget {.cdecl, 
    importc: "gtk_widget_get_toplevel", dynlib: lib.}
proc get_ancestor*(widget: PWidget; widget_type: GType): PWidget {.
    cdecl, importc: "gtk_widget_get_ancestor", dynlib: lib.}
proc get_visual*(widget: PWidget): PGdkVisual {.cdecl, 
    importc: "gtk_widget_get_visual", dynlib: lib.}
proc set_visual*(widget: PWidget; visual: PGdkVisual) {.
    cdecl, importc: "gtk_widget_set_visual", dynlib: lib.}
proc get_screen*(widget: PWidget): PGdkScreen {.cdecl, 
    importc: "gtk_widget_get_screen", dynlib: lib.}
proc has_screen*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_has_screen", dynlib: lib.}
proc get_scale_factor*(widget: PWidget): gint {.cdecl, 
    importc: "gtk_widget_get_scale_factor", dynlib: lib.}
proc get_display*(widget: PWidget): PGdkDisplay {.cdecl, 
    importc: "gtk_widget_get_display", dynlib: lib.}
proc get_root_window*(widget: PWidget): PGdkWindow {.
    cdecl, importc: "gtk_widget_get_root_window", dynlib: lib.}
proc get_settings*(widget: PWidget): PSettings {.cdecl, 
    importc: "gtk_widget_get_settings", dynlib: lib.}
proc get_clipboard*(widget: PWidget; selection: TGdkAtom): PClipboard {.
    cdecl, importc: "gtk_widget_get_clipboard", dynlib: lib.}
proc get_hexpand*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_hexpand", dynlib: lib.}
proc set_hexpand*(widget: PWidget; expand: gboolean) {.cdecl, 
    importc: "gtk_widget_set_hexpand", dynlib: lib.}
proc get_hexpand_set*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_hexpand_set", dynlib: lib.}
proc set_hexpand_set*(widget: PWidget; set: gboolean) {.
    cdecl, importc: "gtk_widget_set_hexpand_set", dynlib: lib.}
proc get_vexpand*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_vexpand", dynlib: lib.}
proc set_vexpand*(widget: PWidget; expand: gboolean) {.cdecl, 
    importc: "gtk_widget_set_vexpand", dynlib: lib.}
proc get_vexpand_set*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_vexpand_set", dynlib: lib.}
proc set_vexpand_set*(widget: PWidget; set: gboolean) {.
    cdecl, importc: "gtk_widget_set_vexpand_set", dynlib: lib.}
proc queue_compute_expand*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_queue_compute_expand", dynlib: lib.}
proc compute_expand*(widget: PWidget; 
                                orientation: TOrientation): gboolean {.
    cdecl, importc: "gtk_widget_compute_expand", dynlib: lib.}
proc get_support_multidevice*(widget: PWidget): gboolean {.
    cdecl, importc: "gtk_widget_get_support_multidevice", dynlib: lib.}
proc set_support_multidevice*(widget: PWidget; 
    support_multidevice: gboolean) {.cdecl, importc: "gtk_widget_set_support_multidevice", 
                                     dynlib: lib.}
proc set_accessible_type*(widget_class: PWidgetClass; 
    typ: GType) {.cdecl, importc: "gtk_widget_class_set_accessible_type", 
                   dynlib: lib.}
proc set_accessible_role*(widget_class: PWidgetClass; 
    role: TRole) {.cdecl, importc: "gtk_widget_class_set_accessible_role", 
                     dynlib: lib.}
proc get_accessible*(widget: PWidget): atk.PObject {.cdecl, 
    importc: "gtk_widget_get_accessible", dynlib: lib.}
proc get_halign*(widget: PWidget): TAlign {.cdecl, 
    importc: "gtk_widget_get_halign", dynlib: lib.}
proc set_halign*(widget: PWidget; align: TAlign) {.cdecl, 
    importc: "gtk_widget_set_halign", dynlib: lib.}
proc get_valign*(widget: PWidget): TAlign {.cdecl, 
    importc: "gtk_widget_get_valign", dynlib: lib.}
proc get_valign_with_baseline*(widget: PWidget): TAlign {.
    cdecl, importc: "gtk_widget_get_valign_with_baseline", dynlib: lib.}
proc set_valign*(widget: PWidget; align: TAlign) {.cdecl, 
    importc: "gtk_widget_set_valign", dynlib: lib.}
proc get_margin_left*(widget: PWidget): gint {.cdecl, 
    importc: "gtk_widget_get_margin_left", dynlib: lib.}
proc set_margin_left*(widget: PWidget; margin: gint) {.cdecl, 
    importc: "gtk_widget_set_margin_left", dynlib: lib.}
proc get_margin_right*(widget: PWidget): gint {.cdecl, 
    importc: "gtk_widget_get_margin_right", dynlib: lib.}
proc set_margin_right*(widget: PWidget; margin: gint) {.
    cdecl, importc: "gtk_widget_set_margin_right", dynlib: lib.}
proc get_margin_start*(widget: PWidget): gint {.cdecl, 
    importc: "gtk_widget_get_margin_start", dynlib: lib.}
proc set_margin_start*(widget: PWidget; margin: gint) {.
    cdecl, importc: "gtk_widget_set_margin_start", dynlib: lib.}
proc get_margin_end*(widget: PWidget): gint {.cdecl, 
    importc: "gtk_widget_get_margin_end", dynlib: lib.}
proc set_margin_end*(widget: PWidget; margin: gint) {.cdecl, 
    importc: "gtk_widget_set_margin_end", dynlib: lib.}
proc get_margin_top*(widget: PWidget): gint {.cdecl, 
    importc: "gtk_widget_get_margin_top", dynlib: lib.}
proc set_margin_top*(widget: PWidget; margin: gint) {.cdecl, 
    importc: "gtk_widget_set_margin_top", dynlib: lib.}
proc get_margin_bottom*(widget: PWidget): gint {.cdecl, 
    importc: "gtk_widget_get_margin_bottom", dynlib: lib.}
proc set_margin_bottom*(widget: PWidget; margin: gint) {.
    cdecl, importc: "gtk_widget_set_margin_bottom", dynlib: lib.}
proc get_events*(widget: PWidget): gint {.cdecl, 
    importc: "gtk_widget_get_events", dynlib: lib.}
proc get_device_events*(widget: PWidget; 
                                   device: PDevice): TEventMask {.
    cdecl, importc: "gtk_widget_get_device_events", dynlib: lib.}
proc get_pointer*(widget: PWidget; x: Pgint; y: Pgint) {.
    cdecl, importc: "gtk_widget_get_pointer", dynlib: lib.}
proc is_ancestor*(widget: PWidget; ancestor: PWidget): gboolean {.
    cdecl, importc: "gtk_widget_is_ancestor", dynlib: lib.}
proc translate_coordinates*(src_widget: PWidget; 
    dest_widget: PWidget; src_x: gint; src_y: gint; dest_x: Pgint; 
    dest_y: Pgint): gboolean {.cdecl, importc: "gtk_widget_translate_coordinates", 
                                  dynlib: lib.}
proc hide_on_delete*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_hide_on_delete", dynlib: lib.}
proc override_color*(widget: PWidget; state: TStateFlags; 
                                color: PRGBA) {.cdecl, 
    importc: "gtk_widget_override_color", dynlib: lib.}
proc override_background_color*(widget: PWidget; 
    state: TStateFlags; color: PRGBA) {.cdecl, 
    importc: "gtk_widget_override_background_color", dynlib: lib.}
proc override_font*(widget: PWidget; 
                               font_desc: PFontDescription) {.cdecl, 
    importc: "gtk_widget_override_font", dynlib: lib.}
proc override_symbolic_color*(widget: PWidget; 
    name: CSTRING; color: PRGBA) {.cdecl, 
    importc: "gtk_widget_override_symbolic_color", dynlib: lib.}
proc override_cursor*(widget: PWidget; cursor: PRGBA; 
                                 secondary_cursor: PRGBA) {.cdecl, 
    importc: "gtk_widget_override_cursor", dynlib: lib.}
proc reset_style*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_reset_style", dynlib: lib.}
proc create_pango_context*(widget: PWidget): pango.Pcontext {.
    cdecl, importc: "gtk_widget_create_pango_context", dynlib: lib.}
proc get_pango_context*(widget: PWidget): pango.Pcontext {.
    cdecl, importc: "gtk_widget_get_pango_context", dynlib: lib.}
proc create_pango_layout*(widget: PWidget; text: CSTRING): Playout {.
    cdecl, importc: "gtk_widget_create_pango_layout", dynlib: lib.}
proc render_icon_pixbuf*(widget: PWidget; 
                                    stock_id: CSTRING; size: TIconSize): PPixbuf {.
    cdecl, importc: "gtk_widget_render_icon_pixbuf", dynlib: lib.}
proc set_composite_name*(widget: PWidget; name: CSTRING) {.
    cdecl, importc: "gtk_widget_set_composite_name", dynlib: lib.}
proc get_composite_name*(widget: PWidget): CSTRING {.cdecl, 
    importc: "gtk_widget_get_composite_name", dynlib: lib.}
proc widget_push_composite_child*() {.cdecl, 
    importc: "gtk_widget_push_composite_child", dynlib: lib.}
proc widget_pop_composite_child*() {.cdecl, 
    importc: "gtk_widget_pop_composite_child", dynlib: lib.}
proc install_style_property*(klass: PWidgetClass; 
    pspec: PGParamSpec) {.cdecl, importc: "gtk_widget_class_install_style_property", 
                             dynlib: lib.}
proc install_style_property_parser*(
    klass: PWidgetClass; pspec: PGParamSpec; 
    parser: TRcPropertyParser) {.cdecl, importc: "gtk_widget_class_install_style_property_parser", 
                                   dynlib: lib.}
proc find_style_property*(klass: PWidgetClass; 
    property_name: CSTRING): PGParamSpec {.cdecl, 
    importc: "gtk_widget_class_find_style_property", dynlib: lib.}
proc list_style_properties*(klass: PWidgetClass; 
    n_properties: Pguint): ptr PGParamSpec {.cdecl, 
    importc: "gtk_widget_class_list_style_properties", dynlib: lib.}
proc style_get_property*(widget: PWidget; 
                                    property_name: CSTRING; 
                                    value: PGValue) {.cdecl, 
    importc: "gtk_widget_style_get_property", dynlib: lib.}
proc style_get_valist*(widget: PWidget; 
                                  first_property_name: CSTRING; 
                                  var_args: va_list) {.cdecl, 
    importc: "gtk_widget_style_get_valist", dynlib: lib.}
proc style_get*(widget: PWidget; 
                           first_property_name: CSTRING) {.varargs, cdecl, 
    importc: "gtk_widget_style_get", dynlib: lib.}
proc set_direction*(widget: PWidget; dir: TTextDirection) {.
    cdecl, importc: "gtk_widget_set_direction", dynlib: lib.}
proc get_direction*(widget: PWidget): TTextDirection {.
    cdecl, importc: "gtk_widget_get_direction", dynlib: lib.}
proc widget_set_default_direction*(dir: TTextDirection) {.cdecl, 
    importc: "gtk_widget_set_default_direction", dynlib: lib.}
proc widget_get_default_direction*(): TTextDirection {.cdecl, 
    importc: "gtk_widget_get_default_direction", dynlib: lib.}
proc is_composited*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_is_composited", dynlib: lib.}
proc shape_combine_region*(widget: PWidget; 
                                      Tregion: Pregion) {.cdecl, 
    importc: "gtk_widget_shape_combine_region", dynlib: lib.}
proc input_shape_combine_region*(widget: PWidget; 
    Tregion: Pregion) {.cdecl, importc: "gtk_widget_input_shape_combine_region", 
                                  dynlib: lib.}
proc list_mnemonic_labels*(widget: PWidget): PGList {.
    cdecl, importc: "gtk_widget_list_mnemonic_labels", dynlib: lib.}
proc add_mnemonic_label*(widget: PWidget; 
                                    label: PWidget) {.cdecl, 
    importc: "gtk_widget_add_mnemonic_label", dynlib: lib.}
proc remove_mnemonic_label*(widget: PWidget; 
    label: PWidget) {.cdecl, 
                            importc: "gtk_widget_remove_mnemonic_label", 
                            dynlib: lib.}
proc set_tooltip_window*(widget: PWidget; 
                                    custom_window: PWindow) {.cdecl, 
    importc: "gtk_widget_set_tooltip_window", dynlib: lib.}
proc get_tooltip_window*(widget: PWidget): PWindow {.
    cdecl, importc: "gtk_widget_get_tooltip_window", dynlib: lib.}
proc trigger_tooltip_query*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_trigger_tooltip_query", dynlib: lib.}
proc set_tooltip_text*(widget: PWidget; text: CSTRING) {.
    cdecl, importc: "gtk_widget_set_tooltip_text", dynlib: lib.}
proc get_tooltip_text*(widget: PWidget): CSTRING {.cdecl, 
    importc: "gtk_widget_get_tooltip_text", dynlib: lib.}
proc set_tooltip_markup*(widget: PWidget; markup: CSTRING) {.
    cdecl, importc: "gtk_widget_set_tooltip_markup", dynlib: lib.}
proc get_tooltip_markup*(widget: PWidget): CSTRING {.cdecl, 
    importc: "gtk_widget_get_tooltip_markup", dynlib: lib.}
proc set_has_tooltip*(widget: PWidget; has_tooltip: gboolean) {.
    cdecl, importc: "gtk_widget_set_has_tooltip", dynlib: lib.}
proc get_has_tooltip*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_get_has_tooltip", dynlib: lib.}
proc cairo_should_draw_window*(cr: cairo.Pcontext; window: PGdkWindow): gboolean {.
    cdecl, importc: "gtk_cairo_should_draw_window", dynlib: lib.}
proc cairo_transform_to_window*(cr: cairo.Pcontext; widget: PWidget; 
                                    window: PGdkWindow) {.cdecl, 
    importc: "gtk_cairo_transform_to_window", dynlib: lib.}
proc requisition_get_type*(): GType {.cdecl, 
    importc: "gtk_requisition_get_type", dynlib: lib.}
proc requisition_new*(): PRequisition {.cdecl, 
    importc: "gtk_requisition_new", dynlib: lib.}
proc copy*(requisition: PRequisition): PRequisition {.
    cdecl, importc: "gtk_requisition_copy", dynlib: lib.}
proc free*(requisition: PRequisition) {.cdecl, 
    importc: "gtk_requisition_free", dynlib: lib.}
proc in_destruction*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_in_destruction", dynlib: lib.}
proc get_style_context*(widget: PWidget): PStyleContext {.
    cdecl, importc: "gtk_widget_get_style_context", dynlib: lib.}
proc get_path*(widget: PWidget): PWidgetPath {.cdecl, 
    importc: "gtk_widget_get_path", dynlib: lib.}
proc get_modifier_mask*(widget: PWidget; 
                                   intent: TModifierIntent): gdk3.TModifierType {.
    cdecl, importc: "gtk_widget_get_modifier_mask", dynlib: lib.}
proc insert_action_group*(widget: PWidget; name: CSTRING; 
                                     group: PGActionGroup) {.cdecl, 
    importc: "gtk_widget_insert_action_group", dynlib: lib.}
proc add_tick_callback*(widget: PWidget; 
                                   callback: TTickCallback; 
                                   user_data: gpointer; notify: TGDestroyNotify): guint {.
    cdecl, importc: "gtk_widget_add_tick_callback", dynlib: lib.}
proc remove_tick_callback*(widget: PWidget; id: guint) {.
    cdecl, importc: "gtk_widget_remove_tick_callback", dynlib: lib.}
proc init_template*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_init_template", dynlib: lib.}
proc get_template_child*(widget: PWidget; widget_type: GType; 
                                    name: CSTRING): PGObject {.cdecl, 
    importc: "gtk_widget_get_template_child", dynlib: lib.}
proc set_template*(widget_class: PWidgetClass; 
                                    template_bytes: PGBytes) {.cdecl, 
    importc: "gtk_widget_class_set_template", dynlib: lib.}
proc set_template_from_resource*(
    widget_class: PWidgetClass; resource_name: CSTRING) {.cdecl, 
    importc: "gtk_widget_class_set_template_from_resource", dynlib: lib.}
proc bind_template_callback_full*(
    widget_class: PWidgetClass; callback_name: CSTRING; 
    callback_symbol: TGCallback) {.cdecl, importc: "gtk_widget_class_bind_template_callback_full", 
                                  dynlib: lib.}
proc set_connect_func*(widget_class: PWidgetClass; 
    connect_func: TBuilderConnectFunc; connect_data: gpointer; 
    connect_data_destroy: TGDestroyNotify) {.cdecl, 
    importc: "gtk_widget_class_set_connect_func", dynlib: lib.}
proc bind_template_child_full*(
    widget_class: PWidgetClass; name: CSTRING; 
    internal_child: gboolean; struct_offset: gssize) {.cdecl, 
    importc: "gtk_widget_class_bind_template_child_full", dynlib: lib.}

template TYPE_APPLICATION*(): expr = 
  (gtk_application_get_type())

template APPLICATION_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_APPLICATION, TApplication))

template APPLICATION_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_APPLICATION, TApplicationClass))

template IS_APPLICATION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_APPLICATION))

template IS_APPLICATION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_APPLICATION))

template APPLICATION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_APPLICATION, TApplicationClass))

type 
  PApplication* = ptr TApplication
  TApplication* = object of TGApplication
    priv7: PApplicationPrivate

type 
  PApplicationClass* = ptr TApplicationClass
  TApplicationClass* = object of TGApplicationClass
    window_added*: proc (application: PApplication; 
                         window: PWindow) {.cdecl.}
    window_removed*: proc (application: PApplication; 
                           window: PWindow) {.cdecl.}
    padding*: array[12, gpointer]

proc application_get_type*(): GType {.cdecl, 
    importc: "gtk_application_get_type", dynlib: lib.}
proc application_new*(application_id: CSTRING; flags: TGApplicationFlags): PApplication {.
    cdecl, importc: "gtk_application_new", dynlib: lib.}
proc add_window*(application: PApplication; 
                                 window: PWindow) {.cdecl, 
    importc: "gtk_application_add_window", dynlib: lib.}
proc remove_window*(application: PApplication; 
                                    window: PWindow) {.cdecl, 
    importc: "gtk_application_remove_window", dynlib: lib.}
proc get_windows*(application: PApplication): PGList {.
    cdecl, importc: "gtk_application_get_windows", dynlib: lib.}
proc get_app_menu*(application: PApplication): PGMenuModel {.
    cdecl, importc: "gtk_application_get_app_menu", dynlib: lib.}
proc set_app_menu*(application: PApplication; 
                                   app_menu: PGMenuModel) {.cdecl, 
    importc: "gtk_application_set_app_menu", dynlib: lib.}
proc get_menubar*(application: PApplication): PGMenuModel {.
    cdecl, importc: "gtk_application_get_menubar", dynlib: lib.}
proc set_menubar*(application: PApplication; 
                                  menubar: PGMenuModel) {.cdecl, 
    importc: "gtk_application_set_menubar", dynlib: lib.}
proc add_accelerator*(application: PApplication; 
                                      accelerator: CSTRING; 
                                      action_name: CSTRING; 
                                      parameter: PGVariant) {.cdecl, 
    importc: "gtk_application_add_accelerator", dynlib: lib.}
proc remove_accelerator*(application: PApplication; 
    action_name: CSTRING; parameter: PGVariant) {.cdecl, 
    importc: "gtk_application_remove_accelerator", dynlib: lib.}
type 
  TApplicationInhibitFlags* {.size: sizeof(cint).} = enum 
    APPLICATION_INHIBIT_LOGOUT = (1 shl 0), 
    APPLICATION_INHIBIT_SWITCH = (1 shl 1), 
    APPLICATION_INHIBIT_SUSPEND = (1 shl 2), 
    APPLICATION_INHIBIT_IDLE = (1 shl 3)
proc inhibit*(application: PApplication; 
                              window: PWindow; 
                              flags: TApplicationInhibitFlags; 
                              reason: CSTRING): guint {.cdecl, 
    importc: "gtk_application_inhibit", dynlib: lib.}
proc uninhibit*(application: PApplication; cookie: guint) {.
    cdecl, importc: "gtk_application_uninhibit", dynlib: lib.}
proc is_inhibited*(application: PApplication; 
                                   flags: TApplicationInhibitFlags): gboolean {.
    cdecl, importc: "gtk_application_is_inhibited", dynlib: lib.}
proc get_window_by_id*(application: PApplication; 
    id: guint): PWindow {.cdecl, 
                                importc: "gtk_application_get_window_by_id", 
                                dynlib: lib.}
proc get_active_window*(application: PApplication): PWindow {.
    cdecl, importc: "gtk_application_get_active_window", dynlib: lib.}
proc list_action_descriptions*(application: PApplication): ptr CSTRING {.
    cdecl, importc: "gtk_application_list_action_descriptions", dynlib: lib.}
proc get_accels_for_action*(application: PApplication; 
    detailed_action_name: CSTRING): ptr CSTRING {.cdecl, 
    importc: "gtk_application_get_accels_for_action", dynlib: lib.}
proc set_accels_for_action*(application: PApplication; 
    detailed_action_name: CSTRING; accels: ptr CSTRING) {.cdecl, 
    importc: "gtk_application_set_accels_for_action", dynlib: lib.}

template TYPE_CONTAINER*(): expr = 
  (gtk_container_get_type())

template CONTAINER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CONTAINER, TContainer))

template CONTAINER_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CONTAINER, TContainerClass))

template IS_CONTAINER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CONTAINER))

template IS_CONTAINER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CONTAINER))

template CONTAINER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CONTAINER, TContainerClass))

type 
  PContainer* = ptr TContainer
  TContainer* = object of TWidget
    priv8: PContainerPrivate
type 
  PAdjustment* = ptr TAdjustment
  TAdjustment* = object of TGInitiallyUnowned
    priv9: PAdjustmentPrivate

type 
  PContainerClass* = ptr TContainerClass
  TContainerClass* = object of TWidgetClass
    add*: proc (container: PContainer; widget: PWidget) {.cdecl.}
    remove*: proc (container: PContainer; widget: PWidget) {.cdecl.}
    check_resize*: proc (container: PContainer) {.cdecl.}
    forall*: proc (container: PContainer; include_internals: gboolean; 
                   callback: TCallback; callback_data: gpointer) {.cdecl.}
    set_focus_child*: proc (container: PContainer; child: PWidget) {.
        cdecl.}
    child_type*: proc (container: PContainer): GType {.cdecl.}
    composite_name*: proc (container: PContainer; child: PWidget): CSTRING {.
        cdecl.}
    set_child_property*: proc (container: PContainer; 
                               child: PWidget; property_id: guint; 
                               value: PGValue; pspec: PGParamSpec) {.
        cdecl.}
    get_child_property*: proc (container: PContainer; 
                               child: PWidget; property_id: guint; 
                               value: PGValue; pspec: PGParamSpec) {.
        cdecl.}
    get_path_for_child*: proc (container: PContainer; 
                               child: PWidget): PWidgetPath {.
        cdecl.}
    handle_border_width*: cuint
    ugtk_reserved41: proc () {.cdecl.}
    ugtk_reserved42: proc () {.cdecl.}
    ugtk_reserved43: proc () {.cdecl.}
    ugtk_reserved44: proc () {.cdecl.}
    ugtk_reserved45: proc () {.cdecl.}
    ugtk_reserved46: proc () {.cdecl.}
    ugtk_reserved47: proc () {.cdecl.}
    ugtk_reserved48: proc () {.cdecl.}

proc container_get_type*(): GType {.cdecl, 
    importc: "gtk_container_get_type", dynlib: lib.}
proc set_border_width*(container: PContainer; 
                                     border_width: guint) {.cdecl, 
    importc: "gtk_container_set_border_width", dynlib: lib.}
proc get_border_width*(container: PContainer): guint {.
    cdecl, importc: "gtk_container_get_border_width", dynlib: lib.}
proc add*(container: PContainer; widget: PWidget) {.
    cdecl, importc: "gtk_container_add", dynlib: lib.}
proc remove*(container: PContainer; widget: PWidget) {.
    cdecl, importc: "gtk_container_remove", dynlib: lib.}
proc set_resize_mode*(container: PContainer; 
                                    resize_mode: TResizeMode) {.cdecl, 
    importc: "gtk_container_set_resize_mode", dynlib: lib.}
proc get_resize_mode*(container: PContainer): TResizeMode {.
    cdecl, importc: "gtk_container_get_resize_mode", dynlib: lib.}
proc check_resize*(container: PContainer) {.cdecl, 
    importc: "gtk_container_check_resize", dynlib: lib.}
proc foreach*(container: PContainer; 
                            callback: TCallback; callback_data: gpointer) {.
    cdecl, importc: "gtk_container_foreach", dynlib: lib.}
proc get_children*(container: PContainer): PGList {.
    cdecl, importc: "gtk_container_get_children", dynlib: lib.}
proc propagate_draw*(container: PContainer; 
                                   child: PWidget; cr: cairo.Pcontext) {.
    cdecl, importc: "gtk_container_propagate_draw", dynlib: lib.}
proc set_focus_chain*(container: PContainer; 
                                    focusable_widgets: PGList) {.cdecl, 
    importc: "gtk_container_set_focus_chain", dynlib: lib.}
proc get_focus_chain*(container: PContainer; 
                                    focusable_widgets: ptr PGList): gboolean {.
    cdecl, importc: "gtk_container_get_focus_chain", dynlib: lib.}
proc unset_focus_chain*(container: PContainer) {.cdecl, 
    importc: "gtk_container_unset_focus_chain", dynlib: lib.}
template IS_RESIZE_CONTAINER*(widget: expr): expr = 
  (IS_CONTAINER(widget) and
      (gtk_container_get_resize_mode(CONTAINER(widget)) !=
      RESIZE_PARENT))

proc set_reallocate_redraws*(container: PContainer; 
    needs_redraws: gboolean) {.cdecl, importc: "gtk_container_set_reallocate_redraws", 
                               dynlib: lib.}
proc set_focus_child*(container: PContainer; 
                                    child: PWidget) {.cdecl, 
    importc: "gtk_container_set_focus_child", dynlib: lib.}
proc get_focus_child*(container: PContainer): PWidget {.
    cdecl, importc: "gtk_container_get_focus_child", dynlib: lib.}
proc set_focus_vadjustment*(container: PContainer; 
    adjustment: PAdjustment) {.cdecl, importc: "gtk_container_set_focus_vadjustment", 
                                     dynlib: lib.}
proc get_focus_vadjustment*(container: PContainer): PAdjustment {.
    cdecl, importc: "gtk_container_get_focus_vadjustment", dynlib: lib.}
proc set_focus_hadjustment*(container: PContainer; 
    adjustment: PAdjustment) {.cdecl, importc: "gtk_container_set_focus_hadjustment", 
                                     dynlib: lib.}
proc get_focus_hadjustment*(container: PContainer): PAdjustment {.
    cdecl, importc: "gtk_container_get_focus_hadjustment", dynlib: lib.}
proc resize_children*(container: PContainer) {.cdecl, 
    importc: "gtk_container_resize_children", dynlib: lib.}
proc child_type*(container: PContainer): GType {.cdecl, 
    importc: "gtk_container_child_type", dynlib: lib.}
proc install_child_property*(
    cclass: PContainerClass; property_id: guint; pspec: PGParamSpec) {.
    cdecl, importc: "gtk_container_class_install_child_property", dynlib: lib.}
proc container_class_find_child_property*(cclass: PGObjectClass; 
    property_name: CSTRING): PGParamSpec {.cdecl, 
    importc: "gtk_container_class_find_child_property", dynlib: lib.}
proc container_class_list_child_properties*(cclass: PGObjectClass; 
    n_properties: Pguint): ptr PGParamSpec {.cdecl, 
    importc: "gtk_container_class_list_child_properties", dynlib: lib.}
proc add_with_properties*(container: PContainer; 
    widget: PWidget; first_prop_name: CSTRING) {.varargs, cdecl, 
    importc: "gtk_container_add_with_properties", dynlib: lib.}
proc child_set*(container: PContainer; 
                              child: PWidget; first_prop_name: CSTRING) {.
    varargs, cdecl, importc: "gtk_container_child_set", dynlib: lib.}
proc child_get*(container: PContainer; 
                              child: PWidget; first_prop_name: CSTRING) {.
    varargs, cdecl, importc: "gtk_container_child_get", dynlib: lib.}
proc child_set_valist*(container: PContainer; 
                                     child: PWidget; 
                                     first_property_name: CSTRING; 
                                     var_args: va_list) {.cdecl, 
    importc: "gtk_container_child_set_valist", dynlib: lib.}
proc child_get_valist*(container: PContainer; 
                                     child: PWidget; 
                                     first_property_name: CSTRING; 
                                     var_args: va_list) {.cdecl, 
    importc: "gtk_container_child_get_valist", dynlib: lib.}
proc child_set_property*(container: PContainer; 
    child: PWidget; property_name: CSTRING; value: PGValue) {.
    cdecl, importc: "gtk_container_child_set_property", dynlib: lib.}
proc child_get_property*(container: PContainer; 
    child: PWidget; property_name: CSTRING; value: PGValue) {.
    cdecl, importc: "gtk_container_child_get_property", dynlib: lib.}
proc child_notify*(container: PContainer; 
                                 child: PWidget; 
                                 child_property: CSTRING) {.cdecl, 
    importc: "gtk_container_child_notify", dynlib: lib.}
template CONTAINER_WARN_INVALID_CHILD_PROPERTY_ID*(
    obj, property_id, pspec: expr): expr = 
  G_OBJECT_WARN_INVALID_PSPEC((obj), "child property", (property_id), 
                              (pspec))

proc forall*(container: PContainer; callback: TCallback; 
                           callback_data: gpointer) {.cdecl, 
    importc: "gtk_container_forall", dynlib: lib.}
proc handle_border_width*(klass: PContainerClass) {.
    cdecl, importc: "gtk_container_class_handle_border_width", dynlib: lib.}
proc get_path_for_child*(container: PContainer; 
    child: PWidget): PWidgetPath {.cdecl, 
    importc: "gtk_container_get_path_for_child", dynlib: lib.}

template TYPE_BIN*(): expr = 
  (gtk_bin_get_type())

template BIN_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BIN, TBin))

template BIN_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BIN, TBinClass))

template IS_BIN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BIN))

template IS_BIN_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BIN))

template BIN_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BIN, TBinClass))

type 
  PBin* = ptr TBin
  TBin* = object of TContainer
    priv10: PBinPrivate

type 
  PBinClass* = ptr TBinClass
  TBinClass* = object of TContainerClass
    ugtk_reserved51: proc () {.cdecl.}
    ugtk_reserved52: proc () {.cdecl.}
    ugtk_reserved53: proc () {.cdecl.}
    ugtk_reserved54: proc () {.cdecl.}

proc bin_get_type*(): GType {.cdecl, importc: "gtk_bin_get_type", 
                                  dynlib: lib.}
proc get_child*(bin: PBin): PWidget {.cdecl, 
    importc: "gtk_bin_get_child", dynlib: lib.}
proc underscore_gtk_bin_set_child*(bin: PBin; widget: PWidget) {.cdecl, 
    importc: "_gtk_bin_set_child", dynlib: lib.}

template TYPE_WINDOW*(): expr = 
  (gtk_window_get_type())

template WINDOW_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WINDOW, TWindow))

template WINDOW_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WINDOW, TWindowClass))

template IS_WINDOW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WINDOW))

template IS_WINDOW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WINDOW))

template WINDOW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WINDOW, TWindowClass))

type 
  PWindow* = ptr TWindow
  TWindow* = object of TBin
    priv11: PWindowPrivate

type 
  PWindowClass* = ptr TWindowClass
  TWindowClass* = object of TBinClass
    set_focus*: proc (window: PWindow; focus: PWidget) {.cdecl.}
    activate_focus*: proc (window: PWindow) {.cdecl.}
    activate_default*: proc (window: PWindow) {.cdecl.}
    keys_changed*: proc (window: PWindow) {.cdecl.}
    ugtk_reserved61: proc () {.cdecl.}
    ugtk_reserved62: proc () {.cdecl.}
    ugtk_reserved63: proc () {.cdecl.}
    ugtk_reserved64: proc () {.cdecl.}

template TYPE_WINDOW_GROUP*(): expr = 
  (gtk_window_group_get_type())

template WINDOW_GROUP_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WINDOW_GROUP, TWindowGroup))

template WINDOW_GROUP_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WINDOW_GROUP, TWindowGroupClass))

template IS_WINDOW_GROUP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WINDOW_GROUP))

template IS_WINDOW_GROUP_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WINDOW_GROUP))

template WINDOW_GROUP_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WINDOW_GROUP, TWindowGroupClass))

type 
  PWindowGroup* = ptr TWindowGroup
  TWindowGroup* = object of TGObject
    priv12: PWindowGroupPrivate

type 
  PWindowGroupClass* = ptr TWindowGroupClass
  TWindowGroupClass* = object of TGObjectClass
    ugtk_reserved71: proc () {.cdecl.}
    ugtk_reserved72: proc () {.cdecl.}
    ugtk_reserved73: proc () {.cdecl.}
    ugtk_reserved74: proc () {.cdecl.}

proc window_get_type*(): GType {.cdecl, importc: "gtk_window_get_type", 
                                     dynlib: lib.}
proc window_new*(typ: TWindowType): PWidget {.cdecl, 
    importc: "gtk_window_new", dynlib: lib.}
proc set_title*(window: PWindow; title: CSTRING) {.cdecl, 
    importc: "gtk_window_set_title", dynlib: lib.}
proc get_title*(window: PWindow): CSTRING {.cdecl, 
    importc: "gtk_window_get_title", dynlib: lib.}
proc set_wmclass*(window: PWindow; wmclass_name: CSTRING; 
                             wmclass_class: CSTRING) {.cdecl, 
    importc: "gtk_window_set_wmclass", dynlib: lib.}
proc set_role*(window: PWindow; role: CSTRING) {.cdecl, 
    importc: "gtk_window_set_role", dynlib: lib.}
proc set_startup_id*(window: PWindow; startup_id: CSTRING) {.
    cdecl, importc: "gtk_window_set_startup_id", dynlib: lib.}
proc get_role*(window: PWindow): CSTRING {.cdecl, 
    importc: "gtk_window_get_role", dynlib: lib.}
proc add_accel_group*(window: PWindow; 
                                 accel_group: PAccelGroup) {.cdecl, 
    importc: "gtk_window_add_accel_group", dynlib: lib.}
proc remove_accel_group*(window: PWindow; 
                                    accel_group: PAccelGroup) {.cdecl, 
    importc: "gtk_window_remove_accel_group", dynlib: lib.}
proc set_position*(window: PWindow; 
                              position: TWindowPosition) {.cdecl, 
    importc: "gtk_window_set_position", dynlib: lib.}
proc activate_focus*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_activate_focus", dynlib: lib.}
proc set_focus*(window: PWindow; focus: PWidget) {.
    cdecl, importc: "gtk_window_set_focus", dynlib: lib.}
proc get_focus*(window: PWindow): PWidget {.cdecl, 
    importc: "gtk_window_get_focus", dynlib: lib.}
proc set_default*(window: PWindow; 
                             default_widget: PWidget) {.cdecl, 
    importc: "gtk_window_set_default", dynlib: lib.}
proc get_default_widget*(window: PWindow): PWidget {.
    cdecl, importc: "gtk_window_get_default_widget", dynlib: lib.}
proc activate_default*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_activate_default", dynlib: lib.}
proc set_transient_for*(window: PWindow; 
                                   parent: PWindow) {.cdecl, 
    importc: "gtk_window_set_transient_for", dynlib: lib.}
proc get_transient_for*(window: PWindow): PWindow {.
    cdecl, importc: "gtk_window_get_transient_for", dynlib: lib.}
proc set_attached_to*(window: PWindow; 
                                 attach_widget: PWidget) {.cdecl, 
    importc: "gtk_window_set_attached_to", dynlib: lib.}
proc get_attached_to*(window: PWindow): PWidget {.
    cdecl, importc: "gtk_window_get_attached_to", dynlib: lib.}
proc set_opacity*(window: PWindow; opacity: gdouble) {.cdecl, 
    importc: "gtk_window_set_opacity", dynlib: lib.}
proc get_opacity*(window: PWindow): gdouble {.cdecl, 
    importc: "gtk_window_get_opacity", dynlib: lib.}
proc set_type_hint*(window: PWindow; hint: TGdkWindowTypeHint) {.
    cdecl, importc: "gtk_window_set_type_hint", dynlib: lib.}
proc get_type_hint*(window: PWindow): TGdkWindowTypeHint {.
    cdecl, importc: "gtk_window_get_type_hint", dynlib: lib.}
proc set_skip_taskbar_hint*(window: PWindow; 
    setting: gboolean) {.cdecl, importc: "gtk_window_set_skip_taskbar_hint", 
                         dynlib: lib.}
proc get_skip_taskbar_hint*(window: PWindow): gboolean {.
    cdecl, importc: "gtk_window_get_skip_taskbar_hint", dynlib: lib.}
proc set_skip_pager_hint*(window: PWindow; setting: gboolean) {.
    cdecl, importc: "gtk_window_set_skip_pager_hint", dynlib: lib.}
proc get_skip_pager_hint*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_skip_pager_hint", dynlib: lib.}
proc set_urgency_hint*(window: PWindow; setting: gboolean) {.
    cdecl, importc: "gtk_window_set_urgency_hint", dynlib: lib.}
proc get_urgency_hint*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_urgency_hint", dynlib: lib.}
proc set_accept_focus*(window: PWindow; setting: gboolean) {.
    cdecl, importc: "gtk_window_set_accept_focus", dynlib: lib.}
proc get_accept_focus*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_accept_focus", dynlib: lib.}
proc set_focus_on_map*(window: PWindow; setting: gboolean) {.
    cdecl, importc: "gtk_window_set_focus_on_map", dynlib: lib.}
proc get_focus_on_map*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_focus_on_map", dynlib: lib.}
proc set_destroy_with_parent*(window: PWindow; 
    setting: gboolean) {.cdecl, importc: "gtk_window_set_destroy_with_parent", 
                         dynlib: lib.}
proc get_destroy_with_parent*(window: PWindow): gboolean {.
    cdecl, importc: "gtk_window_get_destroy_with_parent", dynlib: lib.}
proc set_hide_titlebar_when_maximized*(window: PWindow; 
    setting: gboolean) {.cdecl, importc: "gtk_window_set_hide_titlebar_when_maximized", 
                         dynlib: lib.}
proc get_hide_titlebar_when_maximized*(window: PWindow): gboolean {.
    cdecl, importc: "gtk_window_get_hide_titlebar_when_maximized", dynlib: lib.}
proc set_mnemonics_visible*(window: PWindow; 
    setting: gboolean) {.cdecl, importc: "gtk_window_set_mnemonics_visible", 
                         dynlib: lib.}
proc get_mnemonics_visible*(window: PWindow): gboolean {.
    cdecl, importc: "gtk_window_get_mnemonics_visible", dynlib: lib.}
proc set_focus_visible*(window: PWindow; setting: gboolean) {.
    cdecl, importc: "gtk_window_set_focus_visible", dynlib: lib.}
proc get_focus_visible*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_focus_visible", dynlib: lib.}
proc set_resizable*(window: PWindow; resizable: gboolean) {.
    cdecl, importc: "gtk_window_set_resizable", dynlib: lib.}
proc get_resizable*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_resizable", dynlib: lib.}
proc set_gravity*(window: PWindow; gravity: TGravity) {.
    cdecl, importc: "gtk_window_set_gravity", dynlib: lib.}
proc get_gravity*(window: PWindow): TGravity {.cdecl, 
    importc: "gtk_window_get_gravity", dynlib: lib.}
proc set_geometry_hints*(window: PWindow; 
                                    geometry_widget: PWidget; 
                                    geometry: PGeometry; 
                                    geom_mask: TWindowHints) {.cdecl, 
    importc: "gtk_window_set_geometry_hints", dynlib: lib.}
proc set_screen*(window: PWindow; screen: PGdkScreen) {.
    cdecl, importc: "gtk_window_set_screen", dynlib: lib.}
proc get_screen*(window: PWindow): PGdkScreen {.cdecl, 
    importc: "gtk_window_get_screen", dynlib: lib.}
proc is_active*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_is_active", dynlib: lib.}
proc has_toplevel_focus*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_has_toplevel_focus", dynlib: lib.}
proc set_decorated*(window: PWindow; setting: gboolean) {.
    cdecl, importc: "gtk_window_set_decorated", dynlib: lib.}
proc get_decorated*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_decorated", dynlib: lib.}
proc set_deletable*(window: PWindow; setting: gboolean) {.
    cdecl, importc: "gtk_window_set_deletable", dynlib: lib.}
proc get_deletable*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_deletable", dynlib: lib.}
proc set_icon_list*(window: PWindow; list: PGList) {.
    cdecl, importc: "gtk_window_set_icon_list", dynlib: lib.}
proc get_icon_list*(window: PWindow): PGList {.cdecl, 
    importc: "gtk_window_get_icon_list", dynlib: lib.}
proc set_icon*(window: PWindow; icon: PPixbuf) {.cdecl, 
    importc: "gtk_window_set_icon", dynlib: lib.}
proc set_icon_name*(window: PWindow; name: CSTRING) {.
    cdecl, importc: "gtk_window_set_icon_name", dynlib: lib.}
proc set_icon_from_file*(window: PWindow; 
                                    filename: CSTRING; err: ptr PGError): gboolean {.
    cdecl, importc: "gtk_window_set_icon_from_file", dynlib: lib.}
proc get_icon*(window: PWindow): PPixbuf {.cdecl, 
    importc: "gtk_window_get_icon", dynlib: lib.}
proc get_icon_name*(window: PWindow): CSTRING {.cdecl, 
    importc: "gtk_window_get_icon_name", dynlib: lib.}
proc window_set_default_icon_list*(list: PGList) {.cdecl, 
    importc: "gtk_window_set_default_icon_list", dynlib: lib.}
proc window_get_default_icon_list*(): PGList {.cdecl, 
    importc: "gtk_window_get_default_icon_list", dynlib: lib.}
proc window_set_default_icon*(icon: PPixbuf) {.cdecl, 
    importc: "gtk_window_set_default_icon", dynlib: lib.}
proc window_set_default_icon_name*(name: CSTRING) {.cdecl, 
    importc: "gtk_window_set_default_icon_name", dynlib: lib.}
proc window_get_default_icon_name*(): CSTRING {.cdecl, 
    importc: "gtk_window_get_default_icon_name", dynlib: lib.}
proc window_set_default_icon_from_file*(filename: CSTRING; 
    err: ptr PGError): gboolean {.cdecl, importc: "gtk_window_set_default_icon_from_file", 
                                     dynlib: lib.}
proc window_set_auto_startup_notification*(setting: gboolean) {.cdecl, 
    importc: "gtk_window_set_auto_startup_notification", dynlib: lib.}
proc set_modal*(window: PWindow; modal: gboolean) {.cdecl, 
    importc: "gtk_window_set_modal", dynlib: lib.}
proc get_modal*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_modal", dynlib: lib.}
proc window_list_toplevels*(): PGList {.cdecl, 
    importc: "gtk_window_list_toplevels", dynlib: lib.}
proc set_has_user_ref_count*(window: PWindow; 
    setting: gboolean) {.cdecl, importc: "gtk_window_set_has_user_ref_count", 
                         dynlib: lib.}
proc add_mnemonic*(window: PWindow; keyval: guint; 
                              target: PWidget) {.cdecl, 
    importc: "gtk_window_add_mnemonic", dynlib: lib.}
proc remove_mnemonic*(window: PWindow; keyval: guint; 
                                 target: PWidget) {.cdecl, 
    importc: "gtk_window_remove_mnemonic", dynlib: lib.}
proc mnemonic_activate*(window: PWindow; keyval: guint; 
                                   modifier: gdk3.TModifierType): gboolean {.
    cdecl, importc: "gtk_window_mnemonic_activate", dynlib: lib.}
proc set_mnemonic_modifier*(window: PWindow; 
    modifier: gdk3.TModifierType) {.cdecl, 
                                 importc: "gtk_window_set_mnemonic_modifier", 
                                 dynlib: lib.}
proc get_mnemonic_modifier*(window: PWindow): gdk3.TModifierType {.
    cdecl, importc: "gtk_window_get_mnemonic_modifier", dynlib: lib.}
proc activate_key*(window: PWindow; event: PEventKey): gboolean {.
    cdecl, importc: "gtk_window_activate_key", dynlib: lib.}
proc propagate_key_event*(window: PWindow; 
                                     event: PEventKey): gboolean {.
    cdecl, importc: "gtk_window_propagate_key_event", dynlib: lib.}
proc present*(window: PWindow) {.cdecl, 
    importc: "gtk_window_present", dynlib: lib.}
proc present_with_time*(window: PWindow; timestamp: guint32) {.
    cdecl, importc: "gtk_window_present_with_time", dynlib: lib.}
proc iconify*(window: PWindow) {.cdecl, 
    importc: "gtk_window_iconify", dynlib: lib.}
proc deiconify*(window: PWindow) {.cdecl, 
    importc: "gtk_window_deiconify", dynlib: lib.}
proc stick*(window: PWindow) {.cdecl, 
    importc: "gtk_window_stick", dynlib: lib.}
proc unstick*(window: PWindow) {.cdecl, 
    importc: "gtk_window_unstick", dynlib: lib.}
proc maximize*(window: PWindow) {.cdecl, 
    importc: "gtk_window_maximize", dynlib: lib.}
proc unmaximize*(window: PWindow) {.cdecl, 
    importc: "gtk_window_unmaximize", dynlib: lib.}
proc fullscreen*(window: PWindow) {.cdecl, 
    importc: "gtk_window_fullscreen", dynlib: lib.}
proc unfullscreen*(window: PWindow) {.cdecl, 
    importc: "gtk_window_unfullscreen", dynlib: lib.}
proc close*(window: PWindow) {.cdecl, 
    importc: "gtk_window_close", dynlib: lib.}
proc set_keep_above*(window: PWindow; setting: gboolean) {.
    cdecl, importc: "gtk_window_set_keep_above", dynlib: lib.}
proc set_keep_below*(window: PWindow; setting: gboolean) {.
    cdecl, importc: "gtk_window_set_keep_below", dynlib: lib.}
proc begin_resize_drag*(window: PWindow; edge: TWindowEdge; 
                                   button: gint; root_x: gint; root_y: gint; 
                                   timestamp: guint32) {.cdecl, 
    importc: "gtk_window_begin_resize_drag", dynlib: lib.}
proc begin_move_drag*(window: PWindow; button: gint; 
                                 root_x: gint; root_y: gint; 
                                 timestamp: guint32) {.cdecl, 
    importc: "gtk_window_begin_move_drag", dynlib: lib.}
proc set_default_size*(window: PWindow; width: gint; 
                                  height: gint) {.cdecl, 
    importc: "gtk_window_set_default_size", dynlib: lib.}
proc get_default_size*(window: PWindow; width: Pgint; 
                                  height: Pgint) {.cdecl, 
    importc: "gtk_window_get_default_size", dynlib: lib.}
proc resize*(window: PWindow; width: gint; height: gint) {.
    cdecl, importc: "gtk_window_resize", dynlib: lib.}
proc get_size*(window: PWindow; width: Pgint; 
                          height: Pgint) {.cdecl, 
    importc: "gtk_window_get_size", dynlib: lib.}
proc move*(window: PWindow; x: gint; y: gint) {.cdecl, 
    importc: "gtk_window_move", dynlib: lib.}
proc get_position*(window: PWindow; root_x: Pgint; 
                              root_y: Pgint) {.cdecl, 
    importc: "gtk_window_get_position", dynlib: lib.}
proc parse_geometry*(window: PWindow; geometry: CSTRING): gboolean {.
    cdecl, importc: "gtk_window_parse_geometry", dynlib: lib.}
proc set_default_geometry*(window: PWindow; width: gint; 
                                      height: gint) {.cdecl, 
    importc: "gtk_window_set_default_geometry", dynlib: lib.}
proc resize_to_geometry*(window: PWindow; width: gint; 
                                    height: gint) {.cdecl, 
    importc: "gtk_window_resize_to_geometry", dynlib: lib.}
proc get_group*(window: PWindow): PWindowGroup {.cdecl, 
    importc: "gtk_window_get_group", dynlib: lib.}
proc has_group*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_has_group", dynlib: lib.}
proc reshow_with_initial_size*(window: PWindow) {.cdecl, 
    importc: "gtk_window_reshow_with_initial_size", dynlib: lib.}
proc get_window_type*(window: PWindow): TWindowType {.
    cdecl, importc: "gtk_window_get_window_type", dynlib: lib.}
proc window_group_get_type*(): GType {.cdecl, 
    importc: "gtk_window_group_get_type", dynlib: lib.}
proc window_group_new*(): PWindowGroup {.cdecl, 
    importc: "gtk_window_group_new", dynlib: lib.}
proc add_window*(window_group: PWindowGroup; 
                                  window: PWindow) {.cdecl, 
    importc: "gtk_window_group_add_window", dynlib: lib.}
proc remove_window*(window_group: PWindowGroup; 
                                     window: PWindow) {.cdecl, 
    importc: "gtk_window_group_remove_window", dynlib: lib.}
proc list_windows*(window_group: PWindowGroup): PGList {.
    cdecl, importc: "gtk_window_group_list_windows", dynlib: lib.}
proc get_current_grab*(window_group: PWindowGroup): PWidget {.
    cdecl, importc: "gtk_window_group_get_current_grab", dynlib: lib.}
proc get_current_device_grab*(
    window_group: PWindowGroup; device: PDevice): PWidget {.
    cdecl, importc: "gtk_window_group_get_current_device_grab", dynlib: lib.}
proc get_application*(window: PWindow): PApplication {.
    cdecl, importc: "gtk_window_get_application", dynlib: lib.}
proc set_application*(window: PWindow; 
                                 application: PApplication) {.cdecl, 
    importc: "gtk_window_set_application", dynlib: lib.}
proc set_has_resize_grip*(window: PWindow; value: gboolean) {.
    cdecl, importc: "gtk_window_set_has_resize_grip", dynlib: lib.}
proc get_has_resize_grip*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_get_has_resize_grip", dynlib: lib.}
proc resize_grip_is_visible*(window: PWindow): gboolean {.
    cdecl, importc: "gtk_window_resize_grip_is_visible", dynlib: lib.}
proc get_resize_grip_area*(window: PWindow; 
                                      rect: gdk3.PRectangle): gboolean {.
    cdecl, importc: "gtk_window_get_resize_grip_area", dynlib: lib.}
proc set_titlebar*(window: PWindow; titlebar: PWidget) {.
    cdecl, importc: "gtk_window_set_titlebar", dynlib: lib.}
proc is_maximized*(window: PWindow): gboolean {.cdecl, 
    importc: "gtk_window_is_maximized", dynlib: lib.}

type 
  TDialogFlags* {.size: sizeof(cint).} = enum 
    DIALOG_MODAL = 1 shl 0, DIALOG_DESTROY_WITH_PARENT = 1 shl 1, 
    DIALOG_USE_HEADER_BAR = 1 shl 2
type 
  TResponseType* {.size: sizeof(cint).} = enum 
    RESPONSE_HELP = - 11
    RESPONSE_APPLY = - 10,
    RESPONSE_NO = - 9, 
    RESPONSE_YES = - 8,
    RESPONSE_CLOSE = - 7,
    RESPONSE_CANCEL = - 6, 
    RESPONSE_OK = - 5,
    RESPONSE_DELETE_EVENT = - 4, 
    RESPONSE_ACCEPT = - 3,
    RESPONSE_REJECT = - 2, 
    RESPONSE_NONE = - 1,
template TYPE_DIALOG*(): expr = 
  (gtk_dialog_get_type())

template DIALOG_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_DIALOG, TDialog))

template DIALOG_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_DIALOG, TDialogClass))

template IS_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_DIALOG))

template IS_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_DIALOG))

template DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_DIALOG, TDialogClass))

type 
  PDialog* = ptr TDialog
  TDialog* = object of TWindow
    priv13: PDialogPrivate

type 
  PDialogClass* = ptr TDialogClass
  TDialogClass* = object of TWindowClass
    response*: proc (dialog: PDialog; response_id: gint) {.cdecl.}
    close*: proc (dialog: PDialog) {.cdecl.}
    ugtk_reserved81: proc () {.cdecl.}
    ugtk_reserved82: proc () {.cdecl.}
    ugtk_reserved83: proc () {.cdecl.}
    ugtk_reserved84: proc () {.cdecl.}

proc dialog_get_type*(): GType {.cdecl, importc: "gtk_dialog_get_type", 
                                     dynlib: lib.}
proc dialog_new*(): PWidget {.cdecl, importc: "gtk_dialog_new", 
    dynlib: lib.}
proc dialog_new_with_buttons*(title: CSTRING; parent: PWindow; 
                                  flags: TDialogFlags; 
                                  first_button_text: CSTRING): PWidget {.
    varargs, cdecl, importc: "gtk_dialog_new_with_buttons", dynlib: lib.}
proc add_action_widget*(dialog: PDialog; 
                                   child: PWidget; response_id: gint) {.
    cdecl, importc: "gtk_dialog_add_action_widget", dynlib: lib.}
proc add_button*(dialog: PDialog; button_text: CSTRING; 
                            response_id: gint): PWidget {.cdecl, 
    importc: "gtk_dialog_add_button", dynlib: lib.}
proc add_buttons*(dialog: PDialog; 
                             first_button_text: CSTRING) {.varargs, cdecl, 
    importc: "gtk_dialog_add_buttons", dynlib: lib.}
proc set_response_sensitive*(dialog: PDialog; 
    response_id: gint; setting: gboolean) {.cdecl, 
    importc: "gtk_dialog_set_response_sensitive", dynlib: lib.}
proc set_default_response*(dialog: PDialog; response_id: gint) {.
    cdecl, importc: "gtk_dialog_set_default_response", dynlib: lib.}
proc get_widget_for_response*(dialog: PDialog; 
    response_id: gint): PWidget {.cdecl, 
    importc: "gtk_dialog_get_widget_for_response", dynlib: lib.}
proc get_response_for_widget*(dialog: PDialog; 
    widget: PWidget): gint {.cdecl, importc: "gtk_dialog_get_response_for_widget", 
                                   dynlib: lib.}
proc alternative_dialog_button_order*(screen: PGdkScreen): gboolean {.
    cdecl, importc: "gtk_alternative_dialog_button_order", dynlib: lib.}
proc set_alternative_button_order*(dialog: PDialog; 
    first_response_id: gint) {.varargs, cdecl, importc: "gtk_dialog_set_alternative_button_order", 
                               dynlib: lib.}
proc set_alternative_button_order_from_array*(
    dialog: PDialog; n_params: gint; new_order: Pgint) {.cdecl, 
    importc: "gtk_dialog_set_alternative_button_order_from_array", dynlib: lib.}
proc response*(dialog: PDialog; response_id: gint) {.cdecl, 
    importc: "gtk_dialog_response", dynlib: lib.}
proc run*(dialog: PDialog): gint {.cdecl, 
    importc: "gtk_dialog_run", dynlib: lib.}
proc get_action_area*(dialog: PDialog): PWidget {.
    cdecl, importc: "gtk_dialog_get_action_area", dynlib: lib.}
proc get_content_area*(dialog: PDialog): PWidget {.
    cdecl, importc: "gtk_dialog_get_content_area", dynlib: lib.}
proc get_header_bar*(dialog: PDialog): PWidget {.cdecl, 
    importc: "gtk_dialog_get_header_bar", dynlib: lib.}

template TYPE_ABOUT_DIALOG*(): expr = 
  (gtk_about_dialog_get_type())

template ABOUT_DIALOG_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ABOUT_DIALOG, TAboutDialog))

template ABOUT_DIALOG_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ABOUT_DIALOG, TAboutDialogClass))

template IS_ABOUT_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ABOUT_DIALOG))

template IS_ABOUT_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ABOUT_DIALOG))

template ABOUT_DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ABOUT_DIALOG, TAboutDialogClass))

type 
  TLicense* {.size: sizeof(cint).} = enum 
    LICENSE_UNKNOWN, LICENSE_CUSTOM, LICENSE_GPL_2_0, 
    LICENSE_GPL_3_0, LICENSE_LGPL_2_1, LICENSE_LGPL_3_0, 
    LICENSE_BSD, LICENSE_MIT_X11, LICENSE_ARTISTIC, 
    LICENSE_GPL_2_0_ONLY, LICENSE_GPL_3_0_ONLY, 
    LICENSE_LGPL_2_1_ONLY, LICENSE_LGPL_3_0_ONLY
type 
  PAboutDialog* = ptr TAboutDialog
  TAboutDialog* = object of TDialog
    priv14: PAboutDialogPrivate

type 
  PAboutDialogClass* = ptr TAboutDialogClass
  TAboutDialogClass* = object of TDialogClass
    activate_link*: proc (dialog: PAboutDialog; uri: CSTRING): gboolean {.
        cdecl.}
    ugtk_reserved91: proc () {.cdecl.}
    ugtk_reserved92: proc () {.cdecl.}
    ugtk_reserved93: proc () {.cdecl.}
    ugtk_reserved94: proc () {.cdecl.}

proc about_dialog_get_type*(): GType {.cdecl, 
    importc: "gtk_about_dialog_get_type", dynlib: lib.}
proc about_dialog_new*(): PWidget {.cdecl, 
    importc: "gtk_about_dialog_new", dynlib: lib.}
proc show_about_dialog*(parent: PWindow; 
                            first_property_name: CSTRING) {.varargs, cdecl, 
    importc: "gtk_show_about_dialog", dynlib: lib.}
proc get_program_name*(about: PAboutDialog): CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_program_name", dynlib: lib.}
proc set_program_name*(about: PAboutDialog; 
    name: CSTRING) {.cdecl, importc: "gtk_about_dialog_set_program_name", 
                       dynlib: lib.}
proc get_version*(about: PAboutDialog): CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_version", dynlib: lib.}
proc set_version*(about: PAboutDialog; 
                                   version: CSTRING) {.cdecl, 
    importc: "gtk_about_dialog_set_version", dynlib: lib.}
proc get_copyright*(about: PAboutDialog): CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_copyright", dynlib: lib.}
proc set_copyright*(about: PAboutDialog; 
                                     copyright: CSTRING) {.cdecl, 
    importc: "gtk_about_dialog_set_copyright", dynlib: lib.}
proc get_comments*(about: PAboutDialog): CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_comments", dynlib: lib.}
proc set_comments*(about: PAboutDialog; 
                                    comments: CSTRING) {.cdecl, 
    importc: "gtk_about_dialog_set_comments", dynlib: lib.}
proc get_license*(about: PAboutDialog): CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_license", dynlib: lib.}
proc set_license*(about: PAboutDialog; 
                                   license: CSTRING) {.cdecl, 
    importc: "gtk_about_dialog_set_license", dynlib: lib.}
proc set_license_type*(about: PAboutDialog; 
    license_type: TLicense) {.cdecl, 
                                importc: "gtk_about_dialog_set_license_type", 
                                dynlib: lib.}
proc get_license_type*(about: PAboutDialog): TLicense {.
    cdecl, importc: "gtk_about_dialog_get_license_type", dynlib: lib.}
proc get_wrap_license*(about: PAboutDialog): gboolean {.
    cdecl, importc: "gtk_about_dialog_get_wrap_license", dynlib: lib.}
proc set_wrap_license*(about: PAboutDialog; 
    wrap_license: gboolean) {.cdecl, 
                              importc: "gtk_about_dialog_set_wrap_license", 
                              dynlib: lib.}
proc get_website*(about: PAboutDialog): CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_website", dynlib: lib.}
proc set_website*(about: PAboutDialog; 
                                   website: CSTRING) {.cdecl, 
    importc: "gtk_about_dialog_set_website", dynlib: lib.}
proc get_website_label*(about: PAboutDialog): CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_website_label", dynlib: lib.}
proc set_website_label*(about: PAboutDialog; 
    website_label: CSTRING) {.cdecl, importc: "gtk_about_dialog_set_website_label", 
                                dynlib: lib.}
proc get_authors*(about: PAboutDialog): ptr CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_authors", dynlib: lib.}
proc set_authors*(about: PAboutDialog; 
                                   authors: ptr CSTRING) {.cdecl, 
    importc: "gtk_about_dialog_set_authors", dynlib: lib.}
proc get_documenters*(about: PAboutDialog): ptr CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_documenters", dynlib: lib.}
proc set_documenters*(about: PAboutDialog; 
    documenters: ptr CSTRING) {.cdecl, importc: "gtk_about_dialog_set_documenters", 
                                  dynlib: lib.}
proc get_artists*(about: PAboutDialog): ptr CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_artists", dynlib: lib.}
proc set_artists*(about: PAboutDialog; 
                                   artists: ptr CSTRING) {.cdecl, 
    importc: "gtk_about_dialog_set_artists", dynlib: lib.}
proc get_translator_credits*(about: PAboutDialog): CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_translator_credits", dynlib: lib.}
proc set_translator_credits*(about: PAboutDialog; 
    translator_credits: CSTRING) {.cdecl, importc: "gtk_about_dialog_set_translator_credits", 
                                     dynlib: lib.}
proc get_logo*(about: PAboutDialog): PPixbuf {.
    cdecl, importc: "gtk_about_dialog_get_logo", dynlib: lib.}
proc set_logo*(about: PAboutDialog; logo: PPixbuf) {.
    cdecl, importc: "gtk_about_dialog_set_logo", dynlib: lib.}
proc get_logo_icon_name*(about: PAboutDialog): CSTRING {.
    cdecl, importc: "gtk_about_dialog_get_logo_icon_name", dynlib: lib.}
proc set_logo_icon_name*(about: PAboutDialog; 
    icon_name: CSTRING) {.cdecl, 
                            importc: "gtk_about_dialog_set_logo_icon_name", 
                            dynlib: lib.}
proc add_credit_section*(about: PAboutDialog; 
    section_name: CSTRING; people: ptr CSTRING) {.cdecl, 
    importc: "gtk_about_dialog_add_credit_section", dynlib: lib.}

template TYPE_MISC*(): expr = 
  (gtk_misc_get_type())

template MISC_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MISC, TMisc))

template MISC_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MISC, TMiscClass))

template IS_MISC*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MISC))

template IS_MISC_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MISC))

template MISC_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MISC, TMiscClass))

type 
  PMisc* = ptr TMisc
  TMisc* = object of TWidget
    priv15: PMiscPrivate

type 
  PMiscClass* = ptr TMiscClass
  TMiscClass* = object of TWidgetClass
    ugtk_reserved101: proc () {.cdecl.}
    ugtk_reserved102: proc () {.cdecl.}
    ugtk_reserved103: proc () {.cdecl.}
    ugtk_reserved104: proc () {.cdecl.}

proc misc_get_type*(): GType {.cdecl, importc: "gtk_misc_get_type", 
                                   dynlib: lib.}
proc set_alignment*(misc: PMisc; xalign: gfloat; yalign: gfloat) {.
    cdecl, importc: "gtk_misc_set_alignment", dynlib: lib.}
proc get_alignment*(misc: PMisc; xalign: Pgfloat; 
                             yalign: Pgfloat) {.cdecl, 
    importc: "gtk_misc_get_alignment", dynlib: lib.}
proc set_padding*(misc: PMisc; xpad: gint; ypad: gint) {.cdecl, 
    importc: "gtk_misc_set_padding", dynlib: lib.}
proc get_padding*(misc: PMisc; xpad: Pgint; ypad: Pgint) {.
    cdecl, importc: "gtk_misc_get_padding", dynlib: lib.}
proc underscore_gtk_misc_get_padding_and_border*(misc: PMisc; 
    border: PBorder) {.cdecl, 
                             importc: "_gtk_misc_get_padding_and_border", 
                             dynlib: lib.}

template TYPE_MENU_SHELL*(): expr = 
  (gtk_menu_shell_get_type())

template MENU_SHELL_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MENU_SHELL, TMenuShell))

template MENU_SHELL_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MENU_SHELL, TMenuShellClass))

template IS_MENU_SHELL*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MENU_SHELL))

template IS_MENU_SHELL_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MENU_SHELL))

template MENU_SHELL_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MENU_SHELL, TMenuShellClass))

type 
  PMenuShell* = ptr TMenuShell
  TMenuShell* = object of  TContainer
    priv16: PMenuShellPrivate

type 
  PMenuShellClass* = ptr TMenuShellClass
  TMenuShellClass* = object of TContainerClass
    submenu_placement*: guint
    deactivate*: proc (menu_shell: PMenuShell) {.cdecl.}
    selection_done*: proc (menu_shell: PMenuShell) {.cdecl.}
    move_current*: proc (menu_shell: PMenuShell; 
                         direction: TMenuDirectionType) {.cdecl.}
    activate_current*: proc (menu_shell: PMenuShell; 
                             force_hide: gboolean) {.cdecl.}
    cancel*: proc (menu_shell: PMenuShell) {.cdecl.}
    select_item*: proc (menu_shell: PMenuShell; menu_item: PWidget) {.
        cdecl.}
    insert*: proc (menu_shell: PMenuShell; child: PWidget; 
                   position: gint) {.cdecl.}
    get_popup_delay*: proc (menu_shell: PMenuShell): gint {.cdecl.}
    move_selected*: proc (menu_shell: PMenuShell; distance: gint): gboolean {.
        cdecl.}
    ugtk_reserved111: proc () {.cdecl.}
    ugtk_reserved112: proc () {.cdecl.}
    ugtk_reserved113: proc () {.cdecl.}
    ugtk_reserved114: proc () {.cdecl.}

proc menu_shell_get_type*(): GType {.cdecl, 
    importc: "gtk_menu_shell_get_type", dynlib: lib.}
proc append*(menu_shell: PMenuShell; child: PWidget) {.
    cdecl, importc: "gtk_menu_shell_append", dynlib: lib.}
proc prepend*(menu_shell: PMenuShell; 
                             child: PWidget) {.cdecl, 
    importc: "gtk_menu_shell_prepend", dynlib: lib.}
proc insert*(menu_shell: PMenuShell; 
                            child: PWidget; position: gint) {.cdecl, 
    importc: "gtk_menu_shell_insert", dynlib: lib.}
proc deactivate*(menu_shell: PMenuShell) {.cdecl, 
    importc: "gtk_menu_shell_deactivate", dynlib: lib.}
proc select_item*(menu_shell: PMenuShell; 
                                 menu_item: PWidget) {.cdecl, 
    importc: "gtk_menu_shell_select_item", dynlib: lib.}
proc deselect*(menu_shell: PMenuShell) {.cdecl, 
    importc: "gtk_menu_shell_deselect", dynlib: lib.}
proc activate_item*(menu_shell: PMenuShell; 
                                   menu_item: PWidget; 
                                   force_deactivate: gboolean) {.cdecl, 
    importc: "gtk_menu_shell_activate_item", dynlib: lib.}
proc select_first*(menu_shell: PMenuShell; 
                                  search_sensitive: gboolean) {.cdecl, 
    importc: "gtk_menu_shell_select_first", dynlib: lib.}
proc cancel*(menu_shell: PMenuShell) {.cdecl, 
    importc: "gtk_menu_shell_cancel", dynlib: lib.}
proc get_take_focus*(menu_shell: PMenuShell): gboolean {.
    cdecl, importc: "gtk_menu_shell_get_take_focus", dynlib: lib.}
proc set_take_focus*(menu_shell: PMenuShell; 
                                    take_focus: gboolean) {.cdecl, 
    importc: "gtk_menu_shell_set_take_focus", dynlib: lib.}
proc get_selected_item*(menu_shell: PMenuShell): PWidget {.
    cdecl, importc: "gtk_menu_shell_get_selected_item", dynlib: lib.}
proc get_parent_shell*(menu_shell: PMenuShell): PWidget {.
    cdecl, importc: "gtk_menu_shell_get_parent_shell", dynlib: lib.}
proc bind_model*(menu_shell: PMenuShell; 
                                model: PGMenuModel; 
                                action_namespace: CSTRING; 
                                with_separators: gboolean) {.cdecl, 
    importc: "gtk_menu_shell_bind_model", dynlib: lib.}

template TYPE_MENU*(): expr = 
  (gtk_menu_get_type())

template MENU_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MENU, TMenu))

template MENU_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MENU, TMenuClass))

template IS_MENU*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MENU))

template IS_MENU_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MENU))

template MENU_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MENU, TMenuClass))

type 
  PMenu* = ptr TMenu
  TMenu* = object of TMenuShell
    priv17: PMenuPrivate
type 
  TMenuPositionFunc* = proc (menu: PMenu; x: Pgint; y: Pgint; 
                               push_in: Pgboolean; user_data: gpointer) {.
      cdecl.}
type 
  TMenuDetachFunc* = proc (attach_widget: PWidget; menu: PMenu) {.
      cdecl.}

type 
  PMenuClass* = ptr TMenuClass
  TMenuClass* = object of TMenuShellClass
    ugtk_reserved121: proc () {.cdecl.}
    ugtk_reserved122: proc () {.cdecl.}
    ugtk_reserved123: proc () {.cdecl.}
    ugtk_reserved124: proc () {.cdecl.}

proc menu_get_type*(): GType {.cdecl, importc: "gtk_menu_get_type", 
                                   dynlib: lib.}
proc menu_new*(): PWidget {.cdecl, importc: "gtk_menu_new", 
                                      dynlib: lib.}
proc menu_new_from_model*(model: PGMenuModel): PWidget {.cdecl, 
    importc: "gtk_menu_new_from_model", dynlib: lib.}
proc popup*(menu: PMenu; parent_menu_shell: PWidget; 
                     parent_menu_item: PWidget; 
                     func: TMenuPositionFunc; data: gpointer; button: guint; 
                     activate_time: guint32) {.cdecl, 
    importc: "gtk_menu_popup", dynlib: lib.}
proc popup_for_device*(menu: PMenu; device: PDevice; 
                                parent_menu_shell: PWidget; 
                                parent_menu_item: PWidget; 
                                func: TMenuPositionFunc; data: gpointer; 
                                destroy: TGDestroyNotify; button: guint; 
                                activate_time: guint32) {.cdecl, 
    importc: "gtk_menu_popup_for_device", dynlib: lib.}
proc reposition*(menu: PMenu) {.cdecl, 
    importc: "gtk_menu_reposition", dynlib: lib.}
proc popdown*(menu: PMenu) {.cdecl, 
    importc: "gtk_menu_popdown", dynlib: lib.}
proc get_active*(menu: PMenu): PWidget {.cdecl, 
    importc: "gtk_menu_get_active", dynlib: lib.}
proc set_active*(menu: PMenu; index: guint) {.cdecl, 
    importc: "gtk_menu_set_active", dynlib: lib.}
proc set_accel_group*(menu: PMenu; 
                               accel_group: PAccelGroup) {.cdecl, 
    importc: "gtk_menu_set_accel_group", dynlib: lib.}
proc get_accel_group*(menu: PMenu): PAccelGroup {.cdecl, 
    importc: "gtk_menu_get_accel_group", dynlib: lib.}
proc set_accel_path*(menu: PMenu; accel_path: CSTRING) {.
    cdecl, importc: "gtk_menu_set_accel_path", dynlib: lib.}
proc get_accel_path*(menu: PMenu): CSTRING {.cdecl, 
    importc: "gtk_menu_get_accel_path", dynlib: lib.}
proc attach_to_widget*(menu: PMenu; 
                                attach_widget: PWidget; 
                                detacher: TMenuDetachFunc) {.cdecl, 
    importc: "gtk_menu_attach_to_widget", dynlib: lib.}
proc detach*(menu: PMenu) {.cdecl, importc: "gtk_menu_detach", 
    dynlib: lib.}
proc get_attach_widget*(menu: PMenu): PWidget {.cdecl, 
    importc: "gtk_menu_get_attach_widget", dynlib: lib.}
proc set_tearoff_state*(menu: PMenu; torn_off: gboolean) {.
    cdecl, importc: "gtk_menu_set_tearoff_state", dynlib: lib.}
proc get_tearoff_state*(menu: PMenu): gboolean {.cdecl, 
    importc: "gtk_menu_get_tearoff_state", dynlib: lib.}
proc set_title*(menu: PMenu; title: CSTRING) {.cdecl, 
    importc: "gtk_menu_set_title", dynlib: lib.}
proc get_title*(menu: PMenu): CSTRING {.cdecl, 
    importc: "gtk_menu_get_title", dynlib: lib.}
proc reorder_child*(menu: PMenu; child: PWidget; 
                             position: gint) {.cdecl, 
    importc: "gtk_menu_reorder_child", dynlib: lib.}
proc set_screen*(menu: PMenu; screen: PGdkScreen) {.cdecl, 
    importc: "gtk_menu_set_screen", dynlib: lib.}
proc attach*(menu: PMenu; child: PWidget; 
                      left_attach: guint; right_attach: guint; 
                      top_attach: guint; bottom_attach: guint) {.cdecl, 
    importc: "gtk_menu_attach", dynlib: lib.}
proc set_monitor*(menu: PMenu; monitor_num: gint) {.cdecl, 
    importc: "gtk_menu_set_monitor", dynlib: lib.}
proc get_monitor*(menu: PMenu): gint {.cdecl, 
    importc: "gtk_menu_get_monitor", dynlib: lib.}
proc menu_get_for_attach_widget*(widget: PWidget): PGList {.
    cdecl, importc: "gtk_menu_get_for_attach_widget", dynlib: lib.}
proc set_reserve_toggle_size*(menu: PMenu; 
    reserve_toggle_size: gboolean) {.cdecl, importc: "gtk_menu_set_reserve_toggle_size", 
                                     dynlib: lib.}
proc get_reserve_toggle_size*(menu: PMenu): gboolean {.cdecl, 
    importc: "gtk_menu_get_reserve_toggle_size", dynlib: lib.}

template TYPE_LABEL*(): expr = 
  (gtk_label_get_type())

template LABEL_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_LABEL, TLabel))

template LABEL_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_LABEL, TLabelClass))

template IS_LABEL*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_LABEL))

template IS_LABEL_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_LABEL))

template LABEL_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_LABEL, TLabelClass))

type 
  PLabel* = ptr TLabel
  TLabel* = object of TMisc
    priv18: PLabelPrivate

type 
  PLabelClass* = ptr TLabelClass
  TLabelClass* = object of TMiscClass
    move_cursor*: proc (label: PLabel; step: TMovementStep; 
                        count: gint; extend_selection: gboolean) {.cdecl.}
    copy_clipboard*: proc (label: PLabel) {.cdecl.}
    populate_popup*: proc (label: PLabel; menu: PMenu) {.cdecl.}
    activate_link*: proc (label: PLabel; uri: CSTRING): gboolean {.
        cdecl.}
    ugtk_reserved131: proc () {.cdecl.}
    ugtk_reserved132: proc () {.cdecl.}
    ugtk_reserved133: proc () {.cdecl.}
    ugtk_reserved134: proc () {.cdecl.}
    ugtk_reserved135: proc () {.cdecl.}
    ugtk_reserved136: proc () {.cdecl.}
    ugtk_reserved137: proc () {.cdecl.}
    ugtk_reserved138: proc () {.cdecl.}

proc label_get_type*(): GType {.cdecl, importc: "gtk_label_get_type", 
                                    dynlib: lib.}
proc label_new*(str: CSTRING): PWidget {.cdecl, 
    importc: "gtk_label_new", dynlib: lib.}
proc label_new_with_mnemonic*(str: CSTRING): PWidget {.cdecl, 
    importc: "gtk_label_new_with_mnemonic", dynlib: lib.}
proc set_text*(label: PLabel; str: CSTRING) {.cdecl, 
    importc: "gtk_label_set_text", dynlib: lib.}
proc get_text*(label: PLabel): CSTRING {.cdecl, 
    importc: "gtk_label_get_text", dynlib: lib.}
proc set_attributes*(label: PLabel; attrs: PAttrList) {.
    cdecl, importc: "gtk_label_set_attributes", dynlib: lib.}
proc get_attributes*(label: PLabel): PAttrList {.
    cdecl, importc: "gtk_label_get_attributes", dynlib: lib.}
proc set_label*(label: PLabel; str: CSTRING) {.cdecl, 
    importc: "gtk_label_set_label", dynlib: lib.}
proc get_label*(label: PLabel): CSTRING {.cdecl, 
    importc: "gtk_label_get_label", dynlib: lib.}
proc set_markup*(label: PLabel; str: CSTRING) {.cdecl, 
    importc: "gtk_label_set_markup", dynlib: lib.}
proc set_use_markup*(label: PLabel; setting: gboolean) {.
    cdecl, importc: "gtk_label_set_use_markup", dynlib: lib.}
proc get_use_markup*(label: PLabel): gboolean {.cdecl, 
    importc: "gtk_label_get_use_markup", dynlib: lib.}
proc set_use_underline*(label: PLabel; setting: gboolean) {.
    cdecl, importc: "gtk_label_set_use_underline", dynlib: lib.}
proc get_use_underline*(label: PLabel): gboolean {.cdecl, 
    importc: "gtk_label_get_use_underline", dynlib: lib.}
proc set_markup_with_mnemonic*(label: PLabel; str: CSTRING) {.
    cdecl, importc: "gtk_label_set_markup_with_mnemonic", dynlib: lib.}
proc get_mnemonic_keyval*(label: PLabel): guint {.cdecl, 
    importc: "gtk_label_get_mnemonic_keyval", dynlib: lib.}
proc set_mnemonic_widget*(label: PLabel; widget: PWidget) {.
    cdecl, importc: "gtk_label_set_mnemonic_widget", dynlib: lib.}
proc get_mnemonic_widget*(label: PLabel): PWidget {.
    cdecl, importc: "gtk_label_get_mnemonic_widget", dynlib: lib.}
proc set_text_with_mnemonic*(label: PLabel; str: CSTRING) {.
    cdecl, importc: "gtk_label_set_text_with_mnemonic", dynlib: lib.}
proc set_justify*(label: PLabel; jtype: TJustification) {.
    cdecl, importc: "gtk_label_set_justify", dynlib: lib.}
proc get_justify*(label: PLabel): TJustification {.cdecl, 
    importc: "gtk_label_get_justify", dynlib: lib.}
proc set_ellipsize*(label: PLabel; mode: TEllipsizeMode) {.
    cdecl, importc: "gtk_label_set_ellipsize", dynlib: lib.}
proc get_ellipsize*(label: PLabel): TEllipsizeMode {.
    cdecl, importc: "gtk_label_get_ellipsize", dynlib: lib.}
proc set_width_chars*(label: PLabel; n_chars: gint) {.cdecl, 
    importc: "gtk_label_set_width_chars", dynlib: lib.}
proc get_width_chars*(label: PLabel): gint {.cdecl, 
    importc: "gtk_label_get_width_chars", dynlib: lib.}
proc set_max_width_chars*(label: PLabel; n_chars: gint) {.
    cdecl, importc: "gtk_label_set_max_width_chars", dynlib: lib.}
proc get_max_width_chars*(label: PLabel): gint {.cdecl, 
    importc: "gtk_label_get_max_width_chars", dynlib: lib.}
proc set_lines*(label: PLabel; lines: gint) {.cdecl, 
    importc: "gtk_label_set_lines", dynlib: lib.}
proc get_lines*(label: PLabel): gint {.cdecl, 
    importc: "gtk_label_get_lines", dynlib: lib.}
proc set_pattern*(label: PLabel; pattern: CSTRING) {.cdecl, 
    importc: "gtk_label_set_pattern", dynlib: lib.}
proc set_line_wrap*(label: PLabel; wrap: gboolean) {.cdecl, 
    importc: "gtk_label_set_line_wrap", dynlib: lib.}
proc get_line_wrap*(label: PLabel): gboolean {.cdecl, 
    importc: "gtk_label_get_line_wrap", dynlib: lib.}
proc set_line_wrap_mode*(label: PLabel; 
                                   wrap_mode: TWrapMode) {.cdecl, 
    importc: "gtk_label_set_line_wrap_mode", dynlib: lib.}
proc get_line_wrap_mode*(label: PLabel): TWrapMode {.
    cdecl, importc: "gtk_label_get_line_wrap_mode", dynlib: lib.}
proc set_selectable*(label: PLabel; setting: gboolean) {.
    cdecl, importc: "gtk_label_set_selectable", dynlib: lib.}
proc get_selectable*(label: PLabel): gboolean {.cdecl, 
    importc: "gtk_label_get_selectable", dynlib: lib.}
proc set_angle*(label: PLabel; angle: gdouble) {.cdecl, 
    importc: "gtk_label_set_angle", dynlib: lib.}
proc get_angle*(label: PLabel): gdouble {.cdecl, 
    importc: "gtk_label_get_angle", dynlib: lib.}
proc select_region*(label: PLabel; start_offset: gint; 
                              end_offset: gint) {.cdecl, 
    importc: "gtk_label_select_region", dynlib: lib.}
proc get_selection_bounds*(label: PLabel; start: Pgint; 
                                     e: Pgint): gboolean {.cdecl, 
    importc: "gtk_label_get_selection_bounds", dynlib: lib.}
proc get_layout*(label: PLabel): Playout {.cdecl, 
    importc: "gtk_label_get_layout", dynlib: lib.}
proc get_layout_offsets*(label: PLabel; x: Pgint; 
                                   y: Pgint) {.cdecl, 
    importc: "gtk_label_get_layout_offsets", dynlib: lib.}
proc set_single_line_mode*(label: PLabel; 
                                     single_line_mode: gboolean) {.cdecl, 
    importc: "gtk_label_set_single_line_mode", dynlib: lib.}
proc get_single_line_mode*(label: PLabel): gboolean {.cdecl, 
    importc: "gtk_label_get_single_line_mode", dynlib: lib.}
proc get_current_uri*(label: PLabel): CSTRING {.cdecl, 
    importc: "gtk_label_get_current_uri", dynlib: lib.}
proc set_track_visited_links*(label: PLabel; 
    track_links: gboolean) {.cdecl, 
                             importc: "gtk_label_set_track_visited_links", 
                             dynlib: lib.}
proc get_track_visited_links*(label: PLabel): gboolean {.
    cdecl, importc: "gtk_label_get_track_visited_links", dynlib: lib.}

template TYPE_ACCEL_LABEL*(): expr = 
  (gtk_accel_label_get_type())

template ACCEL_LABEL_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ACCEL_LABEL, TAccelLabel))

template ACCEL_LABEL_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ACCEL_LABEL, TAccelLabelClass))

template IS_ACCEL_LABEL*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ACCEL_LABEL))

template IS_ACCEL_LABEL_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ACCEL_LABEL))

template ACCEL_LABEL_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ACCEL_LABEL, TAccelLabelClass))

type 
  PAccelLabel* = ptr TAccelLabel
  TAccelLabel* = object of TLabel
    priv19: PAccelLabelPrivate

type 
  PAccelLabelClass* = ptr TAccelLabelClass
  TAccelLabelClass* = object of TLabelClass
    signal_quote1*: CSTRING
    signal_quote2*: CSTRING
    mod_name_shift*: CSTRING
    mod_name_control*: CSTRING
    mod_name_alt*: CSTRING
    mod_separator*: CSTRING
    ugtk_reserved141: proc () {.cdecl.}
    ugtk_reserved142: proc () {.cdecl.}
    ugtk_reserved143: proc () {.cdecl.}
    ugtk_reserved144: proc () {.cdecl.}

proc accel_label_get_type*(): GType {.cdecl, 
    importc: "gtk_accel_label_get_type", dynlib: lib.}
proc accel_label_new*(string: CSTRING): PWidget {.cdecl, 
    importc: "gtk_accel_label_new", dynlib: lib.}
proc get_accel_widget*(accel_label: PAccelLabel): PWidget {.
    cdecl, importc: "gtk_accel_label_get_accel_widget", dynlib: lib.}
proc get_accel_width*(accel_label: PAccelLabel): guint {.
    cdecl, importc: "gtk_accel_label_get_accel_width", dynlib: lib.}
proc set_accel_widget*(accel_label: PAccelLabel; 
    accel_widget: PWidget) {.cdecl, importc: "gtk_accel_label_set_accel_widget", 
                                   dynlib: lib.}
proc set_accel_closure*(accel_label: PAccelLabel; 
    accel_closure: PGClosure) {.cdecl, importc: "gtk_accel_label_set_accel_closure", 
                                   dynlib: lib.}
proc refetch*(accel_label: PAccelLabel): gboolean {.
    cdecl, importc: "gtk_accel_label_refetch", dynlib: lib.}
proc set_accel*(accel_label: PAccelLabel; 
                                accelerator_key: guint; 
                                accelerator_mods: gdk3.TModifierType) {.cdecl, 
    importc: "gtk_accel_label_set_accel", dynlib: lib.}
proc get_accel*(accel_label: PAccelLabel; 
                                accelerator_key: Pguint; 
                                accelerator_mods: PModifierType) {.
    cdecl, importc: "gtk_accel_label_get_accel", dynlib: lib.}
proc underscore_gtk_accel_label_class_get_accelerator_label*(
    klass: PAccelLabelClass; accelerator_key: guint; 
    accelerator_mods: gdk3.TModifierType): CSTRING {.cdecl, 
    importc: "_gtk_accel_label_class_get_accelerator_label", dynlib: lib.}

template TYPE_ACCEL_MAP*(): expr = 
  (gtk_accel_map_get_type())

template ACCEL_MAP_TEMPLATE*(accel_map: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((accel_map), TYPE_ACCEL_MAP, TAccelMap))

template ACCEL_MAP_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ACCEL_MAP, AccelMapClass))

template IS_ACCEL_MAP*(accel_map: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((accel_map), TYPE_ACCEL_MAP))

template IS_ACCEL_MAP_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ACCEL_MAP))

template ACCEL_MAP_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ACCEL_MAP, AccelMapClass))

type 
  TAccelMapForeach* = proc (data: gpointer; accel_path: CSTRING; 
                              accel_key: guint; accel_mods: gdk3.TModifierType; 
                              changed: gboolean) {.cdecl.}
proc accel_map_add_entry*(accel_path: CSTRING; accel_key: guint; 
                              accel_mods: gdk3.TModifierType) {.cdecl, 
    importc: "gtk_accel_map_add_entry", dynlib: lib.}
proc accel_map_lookup_entry*(accel_path: CSTRING; key: PAccelKey): gboolean {.
    cdecl, importc: "gtk_accel_map_lookup_entry", dynlib: lib.}
proc accel_map_change_entry*(accel_path: CSTRING; accel_key: guint; 
                                 accel_mods: gdk3.TModifierType; 
                                 replace: gboolean): gboolean {.cdecl, 
    importc: "gtk_accel_map_change_entry", dynlib: lib.}
proc accel_map_load*(file_name: CSTRING) {.cdecl, 
    importc: "gtk_accel_map_load", dynlib: lib.}
proc accel_map_save*(file_name: CSTRING) {.cdecl, 
    importc: "gtk_accel_map_save", dynlib: lib.}
proc accel_map_foreach*(data: gpointer; foreach_func: TAccelMapForeach) {.
    cdecl, importc: "gtk_accel_map_foreach", dynlib: lib.}
proc accel_map_load_fd*(fd: gint) {.cdecl, 
    importc: "gtk_accel_map_load_fd", dynlib: lib.}
proc accel_map_load_scanner*(scanner: PGScanner) {.cdecl, 
    importc: "gtk_accel_map_load_scanner", dynlib: lib.}
proc accel_map_save_fd*(fd: gint) {.cdecl, 
    importc: "gtk_accel_map_save_fd", dynlib: lib.}
proc accel_map_lock_path*(accel_path: CSTRING) {.cdecl, 
    importc: "gtk_accel_map_lock_path", dynlib: lib.}
proc accel_map_unlock_path*(accel_path: CSTRING) {.cdecl, 
    importc: "gtk_accel_map_unlock_path", dynlib: lib.}
proc accel_map_add_filter*(filter_pattern: CSTRING) {.cdecl, 
    importc: "gtk_accel_map_add_filter", dynlib: lib.}
proc accel_map_foreach_unfiltered*(data: gpointer; 
    foreach_func: TAccelMapForeach) {.cdecl, 
    importc: "gtk_accel_map_foreach_unfiltered", dynlib: lib.}
proc accel_map_get_type*(): GType {.cdecl, 
    importc: "gtk_accel_map_get_type", dynlib: lib.}
proc accel_map_get*(): PAccelMap {.cdecl, 
    importc: "gtk_accel_map_get", dynlib: lib.}

template TYPE_ACCESSIBLE*(): expr = 
  (gtk_accessible_get_type())

template ACCESSIBLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ACCESSIBLE, TAccessible))

template ACCESSIBLE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ACCESSIBLE, TAccessibleClass))

template IS_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ACCESSIBLE))

template IS_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ACCESSIBLE))

template ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ACCESSIBLE, TAccessibleClass))

type 
  PAccessible* = ptr TAccessible
  TAccessible* = object of atk.TObject
    priv20: PAccessiblePrivate

type 
  PAccessibleClass* = ptr TAccessibleClass
  TAccessibleClass* = object of atk.TObjectClass
    connect_widget_destroyed*: proc (accessible: PAccessible) {.cdecl.}
    widget_set*: proc (accessible: PAccessible) {.cdecl.}
    widget_unset*: proc (accessible: PAccessible) {.cdecl.}
    ugtk_reserved153: proc () {.cdecl.}
    ugtk_reserved154: proc () {.cdecl.}

proc accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_accessible_get_type", dynlib: lib.}
proc set_widget*(accessible: PAccessible; 
                                widget: PWidget) {.cdecl, 
    importc: "gtk_accessible_set_widget", dynlib: lib.}
proc get_widget*(accessible: PAccessible): PWidget {.
    cdecl, importc: "gtk_accessible_get_widget", dynlib: lib.}
proc connect_widget_destroyed*(accessible: PAccessible) {.
    cdecl, importc: "gtk_accessible_connect_widget_destroyed", dynlib: lib.}

template TYPE_ACTIONABLE*(): expr = 
  (gtk_actionable_get_type())

template ACTIONABLE_TEMPLATE*(inst: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((inst), TYPE_ACTIONABLE, TActionable))

template IS_ACTIONABLE*(inst: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((inst), TYPE_ACTIONABLE))

template ACTIONABLE_GET_IFACE*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((inst), TYPE_ACTIONABLE, 
                                 TActionableInterface))

type 
  PActionableInterface* = ptr TActionableInterface
  TActionableInterface* = object of TGTypeInterface
    get_action_name*: proc (actionable: PActionable): CSTRING {.cdecl.}
    set_action_name*: proc (actionable: PActionable; 
                            action_name: CSTRING) {.cdecl.}
    get_action_target_value*: proc (actionable: PActionable): PGVariant {.
        cdecl.}
    set_action_target_value*: proc (actionable: PActionable; 
                                    target_value: PGVariant) {.cdecl.}

proc actionable_get_type*(): GType {.cdecl, 
    importc: "gtk_actionable_get_type", dynlib: lib.}
proc get_action_name*(actionable: PActionable): CSTRING {.
    cdecl, importc: "gtk_actionable_get_action_name", dynlib: lib.}
proc set_action_name*(actionable: PActionable; 
                                     action_name: CSTRING) {.cdecl, 
    importc: "gtk_actionable_set_action_name", dynlib: lib.}
proc get_action_target_value*(actionable: PActionable): PGVariant {.
    cdecl, importc: "gtk_actionable_get_action_target_value", dynlib: lib.}
proc set_action_target_value*(actionable: PActionable; 
    target_value: PGVariant) {.cdecl, importc: "gtk_actionable_set_action_target_value", 
                                  dynlib: lib.}
proc set_action_target*(actionable: PActionable; 
    format_string: CSTRING) {.varargs, cdecl, 
                                importc: "gtk_actionable_set_action_target", 
                                dynlib: lib.}
proc set_detailed_action_name*(actionable: PActionable; 
    detailed_action_name: CSTRING) {.cdecl, 
    importc: "gtk_actionable_set_detailed_action_name", dynlib: lib.}

template TYPE_ACTION_BAR*(): expr = 
  (gtk_action_bar_get_type())

template ACTION_BAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ACTION_BAR, TActionBar))

template ACTION_BAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ACTION_BAR, TActionBarClass))

template IS_ACTION_BAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ACTION_BAR))

template IS_ACTION_BAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ACTION_BAR))

template ACTION_BAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ACTION_BAR, TActionBarClass))

type 
  PActionBar* = ptr TActionBar
  TActionBar* = object of TBin

type 
  PActionBarClass* = ptr TActionBarClass
  TActionBarClass* = object of TBinClass
    ugtk_reserved161: proc () {.cdecl.}
    ugtk_reserved162: proc () {.cdecl.}
    ugtk_reserved163: proc () {.cdecl.}
    ugtk_reserved164: proc () {.cdecl.}

proc action_bar_get_type*(): GType {.cdecl, 
    importc: "gtk_action_bar_get_type", dynlib: lib.}
proc action_bar_new*(): PWidget {.cdecl, 
    importc: "gtk_action_bar_new", dynlib: lib.}
proc get_center_widget*(action_bar: PActionBar): PWidget {.
    cdecl, importc: "gtk_action_bar_get_center_widget", dynlib: lib.}
proc set_center_widget*(action_bar: PActionBar; 
    center_widget: PWidget) {.cdecl, importc: "gtk_action_bar_set_center_widget", 
                                    dynlib: lib.}
proc action_bar_pack_start*(action_bar: PActionBar; 
                                child: PWidget) {.cdecl, 
    importc: "gtk_action_bar_pack_start", dynlib: lib.}
proc action_bar_pack_end*(action_bar: PActionBar; 
                              child: PWidget) {.cdecl, 
    importc: "gtk_action_bar_pack_end", dynlib: lib.}

template TYPE_ADJUSTMENT*(): expr = 
  (gtk_adjustment_get_type())

template ADJUSTMENT_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ADJUSTMENT, TAdjustment))

template ADJUSTMENT_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ADJUSTMENT, TAdjustmentClass))

template IS_ADJUSTMENT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ADJUSTMENT))

template IS_ADJUSTMENT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ADJUSTMENT))

template ADJUSTMENT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ADJUSTMENT, TAdjustmentClass))


type 
  PAdjustmentClass* = ptr TAdjustmentClass
  TAdjustmentClass* = object of TGInitiallyUnownedClass
    changed*: proc (adjustment: PAdjustment) {.cdecl.}
    value_changed*: proc (adjustment: PAdjustment) {.cdecl.}
    ugtk_reserved171: proc () {.cdecl.}
    ugtk_reserved172: proc () {.cdecl.}
    ugtk_reserved173: proc () {.cdecl.}
    ugtk_reserved174: proc () {.cdecl.}

proc adjustment_get_type*(): GType {.cdecl, 
    importc: "gtk_adjustment_get_type", dynlib: lib.}
proc adjustment_new*(value: gdouble; lower: gdouble; upper: gdouble; 
                         step_increment: gdouble; page_increment: gdouble; 
                         page_size: gdouble): PAdjustment {.cdecl, 
    importc: "gtk_adjustment_new", dynlib: lib.}
proc changed*(adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_adjustment_changed", dynlib: lib.}
proc value_changed*(adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_adjustment_value_changed", dynlib: lib.}
proc clamp_page*(adjustment: PAdjustment; lower: gdouble; 
                                upper: gdouble) {.cdecl, 
    importc: "gtk_adjustment_clamp_page", dynlib: lib.}
proc get_value*(adjustment: PAdjustment): gdouble {.
    cdecl, importc: "gtk_adjustment_get_value", dynlib: lib.}
proc set_value*(adjustment: PAdjustment; value: gdouble) {.
    cdecl, importc: "gtk_adjustment_set_value", dynlib: lib.}
proc get_lower*(adjustment: PAdjustment): gdouble {.
    cdecl, importc: "gtk_adjustment_get_lower", dynlib: lib.}
proc set_lower*(adjustment: PAdjustment; lower: gdouble) {.
    cdecl, importc: "gtk_adjustment_set_lower", dynlib: lib.}
proc get_upper*(adjustment: PAdjustment): gdouble {.
    cdecl, importc: "gtk_adjustment_get_upper", dynlib: lib.}
proc set_upper*(adjustment: PAdjustment; upper: gdouble) {.
    cdecl, importc: "gtk_adjustment_set_upper", dynlib: lib.}
proc get_step_increment*(adjustment: PAdjustment): gdouble {.
    cdecl, importc: "gtk_adjustment_get_step_increment", dynlib: lib.}
proc set_step_increment*(adjustment: PAdjustment; 
    step_increment: gdouble) {.cdecl, 
                               importc: "gtk_adjustment_set_step_increment", 
                               dynlib: lib.}
proc get_page_increment*(adjustment: PAdjustment): gdouble {.
    cdecl, importc: "gtk_adjustment_get_page_increment", dynlib: lib.}
proc set_page_increment*(adjustment: PAdjustment; 
    page_increment: gdouble) {.cdecl, 
                               importc: "gtk_adjustment_set_page_increment", 
                               dynlib: lib.}
proc get_page_size*(adjustment: PAdjustment): gdouble {.
    cdecl, importc: "gtk_adjustment_get_page_size", dynlib: lib.}
proc set_page_size*(adjustment: PAdjustment; 
                                   page_size: gdouble) {.cdecl, 
    importc: "gtk_adjustment_set_page_size", dynlib: lib.}
proc configure*(adjustment: PAdjustment; value: gdouble; 
                               lower: gdouble; upper: gdouble; 
                               step_increment: gdouble; 
                               page_increment: gdouble; page_size: gdouble) {.
    cdecl, importc: "gtk_adjustment_configure", dynlib: lib.}
proc get_minimum_increment*(adjustment: PAdjustment): gdouble {.
    cdecl, importc: "gtk_adjustment_get_minimum_increment", dynlib: lib.}

template TYPE_ALIGNMENT*(): expr = 
  (gtk_alignment_get_type())

template ALIGNMENT_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ALIGNMENT, TAlignment))

template ALIGNMENT_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ALIGNMENT, TAlignmentClass))

template IS_ALIGNMENT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ALIGNMENT))

template IS_ALIGNMENT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ALIGNMENT))

template ALIGNMENT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ALIGNMENT, TAlignmentClass))

type 
  PAlignment* = ptr TAlignment
  TAlignment* = object of TBin
    priv21: PAlignmentPrivate

type 
  PAlignmentClass* = ptr TAlignmentClass
  TAlignmentClass* = object of TBinClass
    ugtk_reserved181: proc () {.cdecl.}
    ugtk_reserved182: proc () {.cdecl.}
    ugtk_reserved183: proc () {.cdecl.}
    ugtk_reserved184: proc () {.cdecl.}

proc alignment_get_type*(): GType {.cdecl, 
    importc: "gtk_alignment_get_type", dynlib: lib.}
proc alignment_new*(xalign: gfloat; yalign: gfloat; xscale: gfloat; 
                        yscale: gfloat): PWidget {.cdecl, 
    importc: "gtk_alignment_new", dynlib: lib.}
proc set*(alignment: PAlignment; xalign: gfloat; 
                        yalign: gfloat; xscale: gfloat; yscale: gfloat) {.
    cdecl, importc: "gtk_alignment_set", dynlib: lib.}
proc set_padding*(alignment: PAlignment; 
                                padding_top: guint; padding_bottom: guint; 
                                padding_left: guint; padding_right: guint) {.
    cdecl, importc: "gtk_alignment_set_padding", dynlib: lib.}
proc get_padding*(alignment: PAlignment; 
                                padding_top: Pguint; 
                                padding_bottom: Pguint; 
                                padding_left: Pguint; 
                                padding_right: Pguint) {.cdecl, 
    importc: "gtk_alignment_get_padding", dynlib: lib.}

template TYPE_APP_CHOOSER*(): expr = 
  (gtk_app_chooser_get_type())

template APP_CHOOSER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_APP_CHOOSER, TAppChooser))

template IS_APP_CHOOSER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_APP_CHOOSER))

proc app_chooser_get_type*(): GType {.cdecl, 
    importc: "gtk_app_chooser_get_type", dynlib: lib.}
proc get_app_info*(self: PAppChooser): PGAppInfo {.
    cdecl, importc: "gtk_app_chooser_get_app_info", dynlib: lib.}
proc get_content_type*(self: PAppChooser): CSTRING {.
    cdecl, importc: "gtk_app_chooser_get_content_type", dynlib: lib.}
proc refresh*(self: PAppChooser) {.cdecl, 
    importc: "gtk_app_chooser_refresh", dynlib: lib.}

template TYPE_APP_CHOOSER_DIALOG*(): expr = 
  (gtk_app_chooser_dialog_get_type())

template APP_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_APP_CHOOSER_DIALOG, 
                              TAppChooserDialog))

template APP_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_APP_CHOOSER_DIALOG, 
                           TAppChooserDialogClass))

template IS_APP_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_APP_CHOOSER_DIALOG))

template IS_APP_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_APP_CHOOSER_DIALOG))

template APP_CHOOSER_DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_APP_CHOOSER_DIALOG, 
                             TAppChooserDialogClass))

type 
  PAppChooserDialog* = ptr TAppChooserDialog
  TAppChooserDialog* = object of TDialog
    priv22: PAppChooserDialogPrivate

type 
  PAppChooserDialogClass* = ptr TAppChooserDialogClass
  TAppChooserDialogClass* = object of TDialogClass
    padding*: array[16, gpointer]

proc app_chooser_dialog_get_type*(): GType {.cdecl, 
    importc: "gtk_app_chooser_dialog_get_type", dynlib: lib.}
proc app_chooser_dialog_new*(parent: PWindow; flags: TDialogFlags; 
                                 file: PGFile): PWidget {.cdecl, 
    importc: "gtk_app_chooser_dialog_new", dynlib: lib.}
proc app_chooser_dialog_new_for_content_type*(parent: PWindow; 
    flags: TDialogFlags; content_type: CSTRING): PWidget {.cdecl, 
    importc: "gtk_app_chooser_dialog_new_for_content_type", dynlib: lib.}
proc get_widget*(self: PAppChooserDialog): PWidget {.
    cdecl, importc: "gtk_app_chooser_dialog_get_widget", dynlib: lib.}
proc set_heading*(self: PAppChooserDialog; 
    heading: CSTRING) {.cdecl, 
                          importc: "gtk_app_chooser_dialog_set_heading", 
                          dynlib: lib.}
proc get_heading*(self: PAppChooserDialog): CSTRING {.
    cdecl, importc: "gtk_app_chooser_dialog_get_heading", dynlib: lib.}

template TYPE_BOX*(): expr = 
  (gtk_box_get_type())

template BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BOX, TBox))

template BOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BOX, TBoxClass))

template IS_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BOX))

template IS_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BOX))

template BOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BOX, TBoxClass))

type 
  PBox* = ptr TBox
  TBox* = object of TContainer
    priv23: PBoxPrivate

type 
  PBoxClass* = ptr TBoxClass
  TBoxClass* = object of TContainerClass
    ugtk_reserved191: proc () {.cdecl.}
    ugtk_reserved192: proc () {.cdecl.}
    ugtk_reserved193: proc () {.cdecl.}
    ugtk_reserved194: proc () {.cdecl.}

proc box_get_type*(): GType {.cdecl, importc: "gtk_box_get_type", 
                                  dynlib: lib.}
proc box_new*(orientation: TOrientation; spacing: gint): PWidget {.
    cdecl, importc: "gtk_box_new", dynlib: lib.}
proc box_pack_start*(box: PBox; child: PWidget; 
                         expand: gboolean; fill: gboolean; padding: guint) {.
    cdecl, importc: "gtk_box_pack_start", dynlib: lib.}
proc box_pack_end*(box: PBox; child: PWidget; 
                       expand: gboolean; fill: gboolean; padding: guint) {.
    cdecl, importc: "gtk_box_pack_end", dynlib: lib.}
proc set_homogeneous*(box: PBox; homogeneous: gboolean) {.cdecl, 
    importc: "gtk_box_set_homogeneous", dynlib: lib.}
proc get_homogeneous*(box: PBox): gboolean {.cdecl, 
    importc: "gtk_box_get_homogeneous", dynlib: lib.}
proc set_spacing*(box: PBox; spacing: gint) {.cdecl, 
    importc: "gtk_box_set_spacing", dynlib: lib.}
proc get_spacing*(box: PBox): gint {.cdecl, 
    importc: "gtk_box_get_spacing", dynlib: lib.}
proc set_baseline_position*(box: PBox; 
                                    position: TBaselinePosition) {.cdecl, 
    importc: "gtk_box_set_baseline_position", dynlib: lib.}
proc get_baseline_position*(box: PBox): TBaselinePosition {.
    cdecl, importc: "gtk_box_get_baseline_position", dynlib: lib.}
proc reorder_child*(box: PBox; child: PWidget; 
                            position: gint) {.cdecl, 
    importc: "gtk_box_reorder_child", dynlib: lib.}
proc query_child_packing*(box: PBox; child: PWidget; 
                                  expand: Pgboolean; fill: Pgboolean; 
                                  padding: Pguint; 
                                  pack_type: var TPackType) {.cdecl, 
    importc: "gtk_box_query_child_packing", dynlib: lib.}
proc set_child_packing*(box: PBox; child: PWidget; 
                                expand: gboolean; fill: gboolean; 
                                padding: guint; pack_type: TPackType) {.
    cdecl, importc: "gtk_box_set_child_packing", dynlib: lib.}
proc set_center_widget*(box: PBox; widget: PWidget) {.
    cdecl, importc: "gtk_box_set_center_widget", dynlib: lib.}
proc get_center_widget*(box: PBox): PWidget {.cdecl, 
    importc: "gtk_box_get_center_widget", dynlib: lib.}

template TYPE_APP_CHOOSER_WIDGET*(): expr = 
  (gtk_app_chooser_widget_get_type())

template APP_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_APP_CHOOSER_WIDGET, 
                              TAppChooserWidget))

template APP_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_APP_CHOOSER_WIDGET, 
                           TAppChooserWidgetClass))

template IS_APP_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_APP_CHOOSER_WIDGET))

template IS_APP_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_APP_CHOOSER_WIDGET))

template APP_CHOOSER_WIDGET_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_APP_CHOOSER_WIDGET, 
                             TAppChooserWidgetClass))

type 
  PAppChooserWidget* = ptr TAppChooserWidget
  TAppChooserWidget* = object of TBox
    priv24: PAppChooserWidgetPrivate

type 
  PAppChooserWidgetClass* = ptr TAppChooserWidgetClass
  TAppChooserWidgetClass* = object of TBoxClass
    application_selected*: proc (self: PAppChooserWidget; 
                                 app_info: PGAppInfo) {.cdecl.}
    application_activated*: proc (self: PAppChooserWidget; 
                                  app_info: PGAppInfo) {.cdecl.}
    populate_popup*: proc (self: PAppChooserWidget; menu: PMenu; 
                           app_info: PGAppInfo) {.cdecl.}
    padding*: array[16, gpointer]

proc app_chooser_widget_get_type*(): GType {.cdecl, 
    importc: "gtk_app_chooser_widget_get_type", dynlib: lib.}
proc app_chooser_widget_new*(content_type: CSTRING): PWidget {.
    cdecl, importc: "gtk_app_chooser_widget_new", dynlib: lib.}
proc set_show_default*(self: PAppChooserWidget; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_app_chooser_widget_set_show_default", 
                         dynlib: lib.}
proc get_show_default*(self: PAppChooserWidget): gboolean {.
    cdecl, importc: "gtk_app_chooser_widget_get_show_default", dynlib: lib.}
proc set_show_recommended*(
    self: PAppChooserWidget; setting: gboolean) {.cdecl, 
    importc: "gtk_app_chooser_widget_set_show_recommended", dynlib: lib.}
proc get_show_recommended*(
    self: PAppChooserWidget): gboolean {.cdecl, 
    importc: "gtk_app_chooser_widget_get_show_recommended", dynlib: lib.}
proc set_show_fallback*(self: PAppChooserWidget; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_app_chooser_widget_set_show_fallback", 
                         dynlib: lib.}
proc get_show_fallback*(self: PAppChooserWidget): gboolean {.
    cdecl, importc: "gtk_app_chooser_widget_get_show_fallback", dynlib: lib.}
proc set_show_other*(self: PAppChooserWidget; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_app_chooser_widget_set_show_other", 
                         dynlib: lib.}
proc get_show_other*(self: PAppChooserWidget): gboolean {.
    cdecl, importc: "gtk_app_chooser_widget_get_show_other", dynlib: lib.}
proc set_show_all*(self: PAppChooserWidget; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_app_chooser_widget_set_show_all", 
                         dynlib: lib.}
proc get_show_all*(self: PAppChooserWidget): gboolean {.
    cdecl, importc: "gtk_app_chooser_widget_get_show_all", dynlib: lib.}
proc set_default_text*(self: PAppChooserWidget; 
    text: CSTRING) {.cdecl, 
                       importc: "gtk_app_chooser_widget_set_default_text", 
                       dynlib: lib.}
proc get_default_text*(self: PAppChooserWidget): CSTRING {.
    cdecl, importc: "gtk_app_chooser_widget_get_default_text", dynlib: lib.}

template TYPE_TREE_MODEL*(): expr = 
  (gtk_tree_model_get_type())

template TREE_MODEL_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_MODEL, TTreeModel))

template IS_TREE_MODEL*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_MODEL))

template TREE_MODEL_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_TREE_MODEL, TTreeModelIface))

template TYPE_TREE_ITER*(): expr = 
  (gtk_tree_iter_get_type())

template TYPE_TREE_PATH*(): expr = 
  (gtk_tree_path_get_type())

template TYPE_TREE_ROW_REFERENCE*(): expr = 
  (gtk_tree_row_reference_get_type())

type 
  PTreeIter* = ptr TTreeIter
  TTreeIter*{.final, pure.} = object 
    stamp*: gint
    user_data*: gpointer
    user_data2*: gpointer
    user_data3*: gpointer

type 
  TTreeModelForeachFunc* = proc (model: PTreeModel; 
                                   path: PTreePath; 
                                   iter: PTreeIter; data: gpointer): gboolean {.
      cdecl.}
type 
  TTreeModelFlags* {.size: sizeof(cint).} = enum 
    TREE_MODEL_ITERS_PERSIST = 1 shl 0, TREE_MODEL_LIST_ONLY = 1 shl
        1

type 
  PTreeModelIface* = ptr TTreeModelIface
  TTreeModelIface* = object of TGTypeInterface
    row_changed*: proc (tree_model: PTreeModel; path: PTreePath; 
                        iter: PTreeIter) {.cdecl.}
    row_inserted*: proc (tree_model: PTreeModel; path: PTreePath; 
                         iter: PTreeIter) {.cdecl.}
    row_has_child_toggled*: proc (tree_model: PTreeModel; 
                                  path: PTreePath; iter: PTreeIter) {.
        cdecl.}
    row_deleted*: proc (tree_model: PTreeModel; path: PTreePath) {.
        cdecl.}
    rows_reordered*: proc (tree_model: PTreeModel; 
                           path: PTreePath; iter: PTreeIter; 
                           new_order: Pgint) {.cdecl.}
    get_flags*: proc (tree_model: PTreeModel): TTreeModelFlags {.cdecl.}
    get_n_columns*: proc (tree_model: PTreeModel): gint {.cdecl.}
    get_column_type*: proc (tree_model: PTreeModel; index: gint): GType {.
        cdecl.}
    get_iter*: proc (tree_model: PTreeModel; iter: PTreeIter; 
                     path: PTreePath): gboolean {.cdecl.}
    get_path*: proc (tree_model: PTreeModel; iter: PTreeIter): PTreePath {.
        cdecl.}
    get_value*: proc (tree_model: PTreeModel; iter: PTreeIter; 
                      column: gint; value: PGValue) {.cdecl.}
    iter_next*: proc (tree_model: PTreeModel; iter: PTreeIter): gboolean {.
        cdecl.}
    iter_previous*: proc (tree_model: PTreeModel; iter: PTreeIter): gboolean {.
        cdecl.}
    iter_children*: proc (tree_model: PTreeModel; iter: PTreeIter; 
                          parent: PTreeIter): gboolean {.cdecl.}
    iter_has_child*: proc (tree_model: PTreeModel; iter: PTreeIter): gboolean {.
        cdecl.}
    iter_n_children*: proc (tree_model: PTreeModel; 
                            iter: PTreeIter): gint {.cdecl.}
    iter_nth_child*: proc (tree_model: PTreeModel; 
                           iter: PTreeIter; parent: PTreeIter; 
                           n: gint): gboolean {.cdecl.}
    iter_parent*: proc (tree_model: PTreeModel; iter: PTreeIter; 
                        child: PTreeIter): gboolean {.cdecl.}
    ref_node*: proc (tree_model: PTreeModel; iter: PTreeIter) {.
        cdecl.}
    unref_node*: proc (tree_model: PTreeModel; iter: PTreeIter) {.
        cdecl.}

proc tree_path_new*(): PTreePath {.cdecl, 
    importc: "gtk_tree_path_new", dynlib: lib.}
proc tree_path_new_from_string*(path: CSTRING): PTreePath {.cdecl, 
    importc: "gtk_tree_path_new_from_string", dynlib: lib.}
proc tree_path_new_from_indices*(first_index: gint): PTreePath {.
    varargs, cdecl, importc: "gtk_tree_path_new_from_indices", dynlib: lib.}
proc tree_path_new_from_indicesv*(indices: Pgint; length: gsize): PTreePath {.
    cdecl, importc: "gtk_tree_path_new_from_indicesv", dynlib: lib.}
proc to_string*(path: PTreePath): CSTRING {.cdecl, 
    importc: "gtk_tree_path_to_string", dynlib: lib.}
proc tree_path_new_first*(): PTreePath {.cdecl, 
    importc: "gtk_tree_path_new_first", dynlib: lib.}
proc append_index*(path: PTreePath; index: gint) {.cdecl, 
    importc: "gtk_tree_path_append_index", dynlib: lib.}
proc prepend_index*(path: PTreePath; index: gint) {.
    cdecl, importc: "gtk_tree_path_prepend_index", dynlib: lib.}
proc get_depth*(path: PTreePath): gint {.cdecl, 
    importc: "gtk_tree_path_get_depth", dynlib: lib.}
proc get_indices*(path: PTreePath): Pgint {.cdecl, 
    importc: "gtk_tree_path_get_indices", dynlib: lib.}
proc get_indices_with_depth*(path: PTreePath; 
    depth: Pgint): Pgint {.cdecl, importc: "gtk_tree_path_get_indices_with_depth", 
                                 dynlib: lib.}
proc free*(path: PTreePath) {.cdecl, 
    importc: "gtk_tree_path_free", dynlib: lib.}
proc copy*(path: PTreePath): PTreePath {.cdecl, 
    importc: "gtk_tree_path_copy", dynlib: lib.}
proc tree_path_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_path_get_type", dynlib: lib.}
proc compare*(a: PTreePath; b: PTreePath): gint {.
    cdecl, importc: "gtk_tree_path_compare", dynlib: lib.}
proc next*(path: PTreePath) {.cdecl, 
    importc: "gtk_tree_path_next", dynlib: lib.}
proc prev*(path: PTreePath): gboolean {.cdecl, 
    importc: "gtk_tree_path_prev", dynlib: lib.}
proc up*(path: PTreePath): gboolean {.cdecl, 
    importc: "gtk_tree_path_up", dynlib: lib.}
proc down*(path: PTreePath) {.cdecl, 
    importc: "gtk_tree_path_down", dynlib: lib.}
proc is_ancestor*(path: PTreePath; 
                                descendant: PTreePath): gboolean {.
    cdecl, importc: "gtk_tree_path_is_ancestor", dynlib: lib.}
proc is_descendant*(path: PTreePath; 
                                  ancestor: PTreePath): gboolean {.
    cdecl, importc: "gtk_tree_path_is_descendant", dynlib: lib.}
proc tree_row_reference_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_row_reference_get_type", dynlib: lib.}
proc tree_row_reference_new*(model: PTreeModel; 
                                 path: PTreePath): PTreeRowReference {.
    cdecl, importc: "gtk_tree_row_reference_new", dynlib: lib.}
proc tree_row_reference_new_proxy*(proxy: PGObject; 
    model: PTreeModel; path: PTreePath): PTreeRowReference {.
    cdecl, importc: "gtk_tree_row_reference_new_proxy", dynlib: lib.}
proc get_path*(reference: PTreeRowReference): PTreePath {.
    cdecl, importc: "gtk_tree_row_reference_get_path", dynlib: lib.}
proc get_model*(reference: PTreeRowReference): PTreeModel {.
    cdecl, importc: "gtk_tree_row_reference_get_model", dynlib: lib.}
proc valid*(reference: PTreeRowReference): gboolean {.
    cdecl, importc: "gtk_tree_row_reference_valid", dynlib: lib.}
proc copy*(reference: PTreeRowReference): PTreeRowReference {.
    cdecl, importc: "gtk_tree_row_reference_copy", dynlib: lib.}
proc free*(reference: PTreeRowReference) {.cdecl, 
    importc: "gtk_tree_row_reference_free", dynlib: lib.}
proc tree_row_reference_inserted*(proxy: PGObject; 
                                      path: PTreePath) {.cdecl, 
    importc: "gtk_tree_row_reference_inserted", dynlib: lib.}
proc tree_row_reference_deleted*(proxy: PGObject; path: PTreePath) {.
    cdecl, importc: "gtk_tree_row_reference_deleted", dynlib: lib.}
proc tree_row_reference_reordered*(proxy: PGObject; 
    path: PTreePath; iter: PTreeIter; new_order: Pgint) {.
    cdecl, importc: "gtk_tree_row_reference_reordered", dynlib: lib.}
proc copy*(iter: PTreeIter): PTreeIter {.cdecl, 
    importc: "gtk_tree_iter_copy", dynlib: lib.}
proc free*(iter: PTreeIter) {.cdecl, 
    importc: "gtk_tree_iter_free", dynlib: lib.}
proc tree_iter_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_iter_get_type", dynlib: lib.}
proc tree_model_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_model_get_type", dynlib: lib.}
proc get_flags*(tree_model: PTreeModel): TTreeModelFlags {.
    cdecl, importc: "gtk_tree_model_get_flags", dynlib: lib.}
proc get_n_columns*(tree_model: PTreeModel): gint {.
    cdecl, importc: "gtk_tree_model_get_n_columns", dynlib: lib.}
proc get_column_type*(tree_model: PTreeModel; 
                                     index: gint): GType {.cdecl, 
    importc: "gtk_tree_model_get_column_type", dynlib: lib.}
proc get_iter*(tree_model: PTreeModel; 
                              iter: PTreeIter; path: PTreePath): gboolean {.
    cdecl, importc: "gtk_tree_model_get_iter", dynlib: lib.}
proc get_iter_from_string*(tree_model: PTreeModel; 
    iter: PTreeIter; path_string: CSTRING): gboolean {.cdecl, 
    importc: "gtk_tree_model_get_iter_from_string", dynlib: lib.}
proc get_string_from_iter*(tree_model: PTreeModel; 
    iter: PTreeIter): CSTRING {.cdecl, 
    importc: "gtk_tree_model_get_string_from_iter", dynlib: lib.}
proc get_iter_first*(tree_model: PTreeModel; 
                                    iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_model_get_iter_first", dynlib: lib.}
proc get_path*(tree_model: PTreeModel; 
                              iter: PTreeIter): PTreePath {.cdecl, 
    importc: "gtk_tree_model_get_path", dynlib: lib.}
proc get_value*(tree_model: PTreeModel; 
                               iter: PTreeIter; column: gint; 
                               value: PGValue) {.cdecl, 
    importc: "gtk_tree_model_get_value", dynlib: lib.}
proc iter_previous*(tree_model: PTreeModel; 
                                   iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_model_iter_previous", dynlib: lib.}
proc iter_next*(tree_model: PTreeModel; 
                               iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_model_iter_next", dynlib: lib.}
proc iter_children*(tree_model: PTreeModel; 
                                   iter: PTreeIter; 
                                   parent: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_model_iter_children", dynlib: lib.}
proc iter_has_child*(tree_model: PTreeModel; 
                                    iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_model_iter_has_child", dynlib: lib.}
proc iter_n_children*(tree_model: PTreeModel; 
                                     iter: PTreeIter): gint {.cdecl, 
    importc: "gtk_tree_model_iter_n_children", dynlib: lib.}
proc iter_nth_child*(tree_model: PTreeModel; 
                                    iter: PTreeIter; 
                                    parent: PTreeIter; n: gint): gboolean {.
    cdecl, importc: "gtk_tree_model_iter_nth_child", dynlib: lib.}
proc iter_parent*(tree_model: PTreeModel; 
                                 iter: PTreeIter; child: PTreeIter): gboolean {.
    cdecl, importc: "gtk_tree_model_iter_parent", dynlib: lib.}
proc ref_node*(tree_model: PTreeModel; 
                              iter: PTreeIter) {.cdecl, 
    importc: "gtk_tree_model_ref_node", dynlib: lib.}
proc unref_node*(tree_model: PTreeModel; 
                                iter: PTreeIter) {.cdecl, 
    importc: "gtk_tree_model_unref_node", dynlib: lib.}
proc get*(tree_model: PTreeModel; iter: PTreeIter) {.
    varargs, cdecl, importc: "gtk_tree_model_get", dynlib: lib.}
proc get_valist*(tree_model: PTreeModel; 
                                iter: PTreeIter; var_args: va_list) {.
    cdecl, importc: "gtk_tree_model_get_valist", dynlib: lib.}
proc foreach*(model: PTreeModel; 
                             func: TTreeModelForeachFunc; 
                             user_data: gpointer) {.cdecl, 
    importc: "gtk_tree_model_foreach", dynlib: lib.}
proc row_changed*(tree_model: PTreeModel; 
                                 path: PTreePath; iter: PTreeIter) {.
    cdecl, importc: "gtk_tree_model_row_changed", dynlib: lib.}
proc row_inserted*(tree_model: PTreeModel; 
                                  path: PTreePath; iter: PTreeIter) {.
    cdecl, importc: "gtk_tree_model_row_inserted", dynlib: lib.}
proc row_has_child_toggled*(tree_model: PTreeModel; 
    path: PTreePath; iter: PTreeIter) {.cdecl, 
    importc: "gtk_tree_model_row_has_child_toggled", dynlib: lib.}
proc row_deleted*(tree_model: PTreeModel; 
                                 path: PTreePath) {.cdecl, 
    importc: "gtk_tree_model_row_deleted", dynlib: lib.}
proc rows_reordered*(tree_model: PTreeModel; 
                                    path: PTreePath; 
                                    iter: PTreeIter; new_order: Pgint) {.
    cdecl, importc: "gtk_tree_model_rows_reordered", dynlib: lib.}
proc rows_reordered_with_length*(tree_model: PTreeModel; 
    path: PTreePath; iter: PTreeIter; new_order: Pgint; 
    length: gint) {.cdecl, 
                    importc: "gtk_tree_model_rows_reordered_with_length", 
                    dynlib: lib.}

template TYPE_CELL_EDITABLE*(): expr = 
  (gtk_cell_editable_get_type())

template CELL_EDITABLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_EDITABLE, TCellEditable))

template CELL_EDITABLE_CLASS*(obj: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((obj), TYPE_CELL_EDITABLE, TCellEditableIface))

template IS_CELL_EDITABLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_EDITABLE))

template CELL_EDITABLE_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_CELL_EDITABLE, 
                                 TCellEditableIface))

type 
  PCellEditableIface* = ptr TCellEditableIface
  TCellEditableIface* = object of TGTypeInterface
    editing_done*: proc (cell_editable: PCellEditable) {.cdecl.}
    remove_widget*: proc (cell_editable: PCellEditable) {.cdecl.}
    start_editing*: proc (cell_editable: PCellEditable; 
                          event: PEvent) {.cdecl.}

proc cell_editable_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_editable_get_type", dynlib: lib.}
proc start_editing*(cell_editable: PCellEditable; 
                                      event: PEvent) {.cdecl, 
    importc: "gtk_cell_editable_start_editing", dynlib: lib.}
proc editing_done*(cell_editable: PCellEditable) {.
    cdecl, importc: "gtk_cell_editable_editing_done", dynlib: lib.}
proc remove_widget*(cell_editable: PCellEditable) {.
    cdecl, importc: "gtk_cell_editable_remove_widget", dynlib: lib.}

type 
  TCellRendererState* {.size: sizeof(cint).} = enum 
    CELL_RENDERER_SELECTED = 1 shl 0, CELL_RENDERER_PRELIT = 1 shl
        1, CELL_RENDERER_INSENSITIVE = 1 shl 2, 
    CELL_RENDERER_SORTED = 1 shl 3, CELL_RENDERER_FOCUSED = 1 shl 4, 
    CELL_RENDERER_EXPANDABLE = 1 shl 5, 
    CELL_RENDERER_EXPANDED = 1 shl 6
type 
  TCellRendererMode* {.size: sizeof(cint).} = enum 
    CELL_RENDERER_MODE_INERT, CELL_RENDERER_MODE_ACTIVATABLE, 
    CELL_RENDERER_MODE_EDITABLE
template TYPE_CELL_RENDERER*(): expr = 
  (gtk_cell_renderer_get_type())

template CELL_RENDERER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_RENDERER, TCellRenderer))

template CELL_RENDERER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_RENDERER, 
                           TCellRendererClass))

template IS_CELL_RENDERER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_RENDERER))

template IS_CELL_RENDERER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_RENDERER))

template CELL_RENDERER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_RENDERER, 
                             TCellRendererClass))

type 
  PCellRenderer* = ptr TCellRenderer
  TCellRenderer* = object of TGInitiallyUnowned
    priv25: PCellRendererPrivate

type 
  PCellRendererClass* = ptr TCellRendererClass
  TCellRendererClass* = object of TGInitiallyUnownedClass
    get_request_mode*: proc (cell: PCellRenderer): TSizeRequestMode {.
        cdecl.}
    get_preferred_width*: proc (cell: PCellRenderer; 
                                widget: PWidget; minimum_size: Pgint; 
                                natural_size: Pgint) {.cdecl.}
    get_preferred_height_for_width*: proc (cell: PCellRenderer; 
        widget: PWidget; width: gint; minimum_height: Pgint; 
        natural_height: Pgint) {.cdecl.}
    get_preferred_height*: proc (cell: PCellRenderer; 
                                 widget: PWidget; 
                                 minimum_size: Pgint; 
                                 natural_size: Pgint) {.cdecl.}
    get_preferred_width_for_height*: proc (cell: PCellRenderer; 
        widget: PWidget; height: gint; minimum_width: Pgint; 
        natural_width: Pgint) {.cdecl.}
    get_aligned_area*: proc (cell: PCellRenderer; widget: PWidget; 
                             flags: TCellRendererState; 
                             cell_area: gdk3.PRectangle; 
                             aligned_area: gdk3.PRectangle) {.cdecl.}
    get_size*: proc (cell: PCellRenderer; widget: PWidget; 
                     cell_area: gdk3.PRectangle; x_offset: Pgint; 
                     y_offset: Pgint; width: Pgint; height: Pgint) {.
        cdecl.}
    render*: proc (cell: PCellRenderer; cr: cairo.Pcontext; 
                   widget: PWidget; background_area: gdk3.PRectangle; 
                   cell_area: gdk3.PRectangle; flags: TCellRendererState) {.
        cdecl.}
    activate*: proc (cell: PCellRenderer; event: PEvent; 
                     widget: PWidget; path: CSTRING; 
                     background_area: gdk3.PRectangle; 
                     cell_area: gdk3.PRectangle; flags: TCellRendererState): gboolean {.
        cdecl.}
    start_editing*: proc (cell: PCellRenderer; event: PEvent; 
                          widget: PWidget; path: CSTRING; 
                          background_area: gdk3.PRectangle; 
                          cell_area: gdk3.PRectangle; 
                          flags: TCellRendererState): PCellEditable {.
        cdecl.}
    editing_canceled*: proc (cell: PCellRenderer) {.cdecl.}
    editing_started*: proc (cell: PCellRenderer; 
                            editable: PCellEditable; path: CSTRING) {.
        cdecl.}
    priv26: PCellRendererClassPrivate
    ugtk_reserved202: proc () {.cdecl.}
    ugtk_reserved203: proc () {.cdecl.}
    ugtk_reserved204: proc () {.cdecl.}

proc cell_renderer_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_get_type", dynlib: lib.}
proc get_request_mode*(cell: PCellRenderer): TSizeRequestMode {.
    cdecl, importc: "gtk_cell_renderer_get_request_mode", dynlib: lib.}
proc get_preferred_width*(cell: PCellRenderer; 
    widget: PWidget; minimum_size: Pgint; natural_size: Pgint) {.
    cdecl, importc: "gtk_cell_renderer_get_preferred_width", dynlib: lib.}
proc get_preferred_height_for_width*(
    cell: PCellRenderer; widget: PWidget; width: gint; 
    minimum_height: Pgint; natural_height: Pgint) {.cdecl, 
    importc: "gtk_cell_renderer_get_preferred_height_for_width", dynlib: lib.}
proc get_preferred_height*(cell: PCellRenderer; 
    widget: PWidget; minimum_size: Pgint; natural_size: Pgint) {.
    cdecl, importc: "gtk_cell_renderer_get_preferred_height", dynlib: lib.}
proc get_preferred_width_for_height*(
    cell: PCellRenderer; widget: PWidget; height: gint; 
    minimum_width: Pgint; natural_width: Pgint) {.cdecl, 
    importc: "gtk_cell_renderer_get_preferred_width_for_height", dynlib: lib.}
proc get_preferred_size*(cell: PCellRenderer; 
    widget: PWidget; minimum_size: PRequisition; 
    natural_size: PRequisition) {.cdecl, 
    importc: "gtk_cell_renderer_get_preferred_size", dynlib: lib.}
proc get_aligned_area*(cell: PCellRenderer; 
    widget: PWidget; flags: TCellRendererState; 
    cell_area: gdk3.PRectangle; aligned_area: gdk3.PRectangle) {.cdecl, 
    importc: "gtk_cell_renderer_get_aligned_area", dynlib: lib.}
proc get_size*(cell: PCellRenderer; 
                                 widget: PWidget; 
                                 cell_area: gdk3.PRectangle; 
                                 x_offset: Pgint; y_offset: Pgint; 
                                 width: Pgint; height: Pgint) {.cdecl, 
    importc: "gtk_cell_renderer_get_size", dynlib: lib.}
proc render*(cell: PCellRenderer; cr: cairo.Pcontext; 
                               widget: PWidget; 
                               background_area: gdk3.PRectangle; 
                               cell_area: gdk3.PRectangle; 
                               flags: TCellRendererState) {.cdecl, 
    importc: "gtk_cell_renderer_render", dynlib: lib.}
proc activate*(cell: PCellRenderer; 
                                 event: PEvent; widget: PWidget; 
                                 path: CSTRING; 
                                 background_area: gdk3.PRectangle; 
                                 cell_area: gdk3.PRectangle; 
                                 flags: TCellRendererState): gboolean {.
    cdecl, importc: "gtk_cell_renderer_activate", dynlib: lib.}
proc start_editing*(cell: PCellRenderer; 
                                      event: PEvent; 
                                      widget: PWidget; path: CSTRING; 
                                      background_area: gdk3.PRectangle; 
                                      cell_area: gdk3.PRectangle; 
                                      flags: TCellRendererState): PCellEditable {.
    cdecl, importc: "gtk_cell_renderer_start_editing", dynlib: lib.}
proc set_fixed_size*(cell: PCellRenderer; width: gint; 
    height: gint) {.cdecl, importc: "gtk_cell_renderer_set_fixed_size", 
                    dynlib: lib.}
proc get_fixed_size*(cell: PCellRenderer; 
    width: Pgint; height: Pgint) {.cdecl, 
    importc: "gtk_cell_renderer_get_fixed_size", dynlib: lib.}
proc set_alignment*(cell: PCellRenderer; 
                                      xalign: gfloat; yalign: gfloat) {.cdecl, 
    importc: "gtk_cell_renderer_set_alignment", dynlib: lib.}
proc get_alignment*(cell: PCellRenderer; 
                                      xalign: Pgfloat; yalign: Pgfloat) {.
    cdecl, importc: "gtk_cell_renderer_get_alignment", dynlib: lib.}
proc set_padding*(cell: PCellRenderer; xpad: gint; 
                                    ypad: gint) {.cdecl, 
    importc: "gtk_cell_renderer_set_padding", dynlib: lib.}
proc get_padding*(cell: PCellRenderer; xpad: Pgint; 
                                    ypad: Pgint) {.cdecl, 
    importc: "gtk_cell_renderer_get_padding", dynlib: lib.}
proc set_visible*(cell: PCellRenderer; 
                                    visible: gboolean) {.cdecl, 
    importc: "gtk_cell_renderer_set_visible", dynlib: lib.}
proc get_visible*(cell: PCellRenderer): gboolean {.
    cdecl, importc: "gtk_cell_renderer_get_visible", dynlib: lib.}
proc set_sensitive*(cell: PCellRenderer; 
                                      sensitive: gboolean) {.cdecl, 
    importc: "gtk_cell_renderer_set_sensitive", dynlib: lib.}
proc get_sensitive*(cell: PCellRenderer): gboolean {.
    cdecl, importc: "gtk_cell_renderer_get_sensitive", dynlib: lib.}
proc is_activatable*(cell: PCellRenderer): gboolean {.
    cdecl, importc: "gtk_cell_renderer_is_activatable", dynlib: lib.}
proc stop_editing*(cell: PCellRenderer; 
                                     canceled: gboolean) {.cdecl, 
    importc: "gtk_cell_renderer_stop_editing", dynlib: lib.}
proc underscore_gtk_cell_renderer_calc_offset*(cell: PCellRenderer; 
                                     cell_area: gdk3.PRectangle; 
                                     direction: TTextDirection; width: gint; 
                                     height: gint; x_offset: Pgint; 
                                     y_offset: Pgint) {.cdecl, 
    importc: "_gtk_cell_renderer_calc_offset", dynlib: lib.}
proc get_state*(cell: PCellRenderer; 
                                  widget: PWidget; 
                                  cell_state: TCellRendererState): TStateFlags {.
    cdecl, importc: "gtk_cell_renderer_get_state", dynlib: lib.}
proc set_accessible_type*(
    renderer_class: PCellRendererClass; typ: GType) {.cdecl, 
    importc: "gtk_cell_renderer_class_set_accessible_type", dynlib: lib.}
proc underscore_gtk_cell_renderer_get_accessible_type*(renderer: PCellRenderer): GType {.
    cdecl, importc: "_gtk_cell_renderer_get_accessible_type", dynlib: lib.}

template TYPE_TREE_SORTABLE*(): expr = 
  (gtk_tree_sortable_get_type())

template TREE_SORTABLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_SORTABLE, TTreeSortable))

template TREE_SORTABLE_CLASS*(obj: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((obj), TYPE_TREE_SORTABLE, TTreeSortableIface))

template IS_TREE_SORTABLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_SORTABLE))

template TREE_SORTABLE_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_TREE_SORTABLE, 
                                 TTreeSortableIface))

const 
  TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID* = (- 1)
const 
  TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID* = (- 2)
type 
  TTreeIterCompareFunc* = proc (model: PTreeModel; a: PTreeIter; 
                                  b: PTreeIter; user_data: gpointer): gint {.
      cdecl.}
type 
  PTreeSortableIface* = ptr TTreeSortableIface
  TTreeSortableIface* = object of TGTypeInterface
    sort_column_changed*: proc (sortable: PTreeSortable) {.cdecl.}
    get_sort_column_id*: proc (sortable: PTreeSortable; 
                               sort_column_id: Pgint; 
                               order: var TSortType): gboolean {.cdecl.}
    set_sort_column_id*: proc (sortable: PTreeSortable; 
                               sort_column_id: gint; order: TSortType) {.
        cdecl.}
    set_sort_func*: proc (sortable: PTreeSortable; sort_column_id: gint; 
                          sort_func: TTreeIterCompareFunc; 
                          user_data: gpointer; destroy: TGDestroyNotify) {.
        cdecl.}
    set_default_sort_func*: proc (sortable: PTreeSortable; 
                                  sort_func: TTreeIterCompareFunc; 
                                  user_data: gpointer; destroy: TGDestroyNotify) {.
        cdecl.}
    has_default_sort_func*: proc (sortable: PTreeSortable): gboolean {.
        cdecl.}

proc tree_sortable_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_sortable_get_type", dynlib: lib.}
proc sort_column_changed*(sortable: PTreeSortable) {.
    cdecl, importc: "gtk_tree_sortable_sort_column_changed", dynlib: lib.}
proc get_sort_column_id*(sortable: PTreeSortable; 
    sort_column_id: Pgint; order: var TSortType): gboolean {.cdecl, 
    importc: "gtk_tree_sortable_get_sort_column_id", dynlib: lib.}
proc set_sort_column_id*(sortable: PTreeSortable; 
    sort_column_id: gint; order: TSortType) {.cdecl, 
    importc: "gtk_tree_sortable_set_sort_column_id", dynlib: lib.}
proc set_sort_func*(sortable: PTreeSortable; 
                                      sort_column_id: gint; 
                                      sort_func: TTreeIterCompareFunc; 
                                      user_data: gpointer; 
                                      destroy: TGDestroyNotify) {.cdecl, 
    importc: "gtk_tree_sortable_set_sort_func", dynlib: lib.}
proc set_default_sort_func*(sortable: PTreeSortable; 
    sort_func: TTreeIterCompareFunc; user_data: gpointer; 
    destroy: TGDestroyNotify) {.cdecl, importc: "gtk_tree_sortable_set_default_sort_func", 
                               dynlib: lib.}
proc has_default_sort_func*(sortable: PTreeSortable): gboolean {.
    cdecl, importc: "gtk_tree_sortable_has_default_sort_func", dynlib: lib.}

template TYPE_CELL_AREA*(): expr = 
  (gtk_cell_area_get_type())

template CELL_AREA_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_AREA, TCellArea))

template CELL_AREA_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_AREA, TCellAreaClass))

template IS_CELL_AREA*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_AREA))

template IS_CELL_AREA_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_AREA))

template CELL_AREA_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_AREA, TCellAreaClass))

template CELL_AREA_WARN_INVALID_CELL_PROPERTY_ID*(
    obj, property_id, pspec: expr): expr = 
  G_OBJECT_WARN_INVALID_PSPEC((obj), "cell property id", (property_id), 
                              (pspec))

type 
  TCellCallback* = proc (renderer: PCellRenderer; data: gpointer): gboolean {.
      cdecl.}
type 
  TCellAllocCallback* = proc (renderer: PCellRenderer; 
                                cell_area: gdk3.PRectangle; 
                                cell_background: gdk3.PRectangle; 
                                data: gpointer): gboolean {.cdecl.}
type 
  PCellArea* = ptr TCellArea
  TCellArea* = object of TGInitiallyUnowned
    priv27: PCellAreaPrivate
type 
  PCellAreaContext* = ptr TCellAreaContext
  TCellAreaContext* = object of TGObject
    priv28: PCellAreaContextPrivate

type 
  PCellAreaContextClass* = ptr TCellAreaContextClass
  TCellAreaContextClass* = object of TGObjectClass
    allocate*: proc (context: PCellAreaContext; width: gint; 
                     height: gint) {.cdecl.}
    reset*: proc (context: PCellAreaContext) {.cdecl.}
    get_preferred_height_for_width*: proc (context: PCellAreaContext; 
        width: gint; minimum_height: Pgint; natural_height: Pgint) {.
        cdecl.}
    get_preferred_width_for_height*: proc (context: PCellAreaContext; 
        height: gint; minimum_width: Pgint; natural_width: Pgint) {.
        cdecl.}
    ugtk_reserved211: proc () {.cdecl.}
    ugtk_reserved212: proc () {.cdecl.}
    ugtk_reserved213: proc () {.cdecl.}
    ugtk_reserved214: proc () {.cdecl.}
    ugtk_reserved215: proc () {.cdecl.}
    ugtk_reserved216: proc () {.cdecl.}

type 
  PCellAreaClass* = ptr TCellAreaClass
  TCellAreaClass* = object of TGInitiallyUnownedClass
    add*: proc (area: PCellArea; renderer: PCellRenderer) {.cdecl.}
    remove*: proc (area: PCellArea; renderer: PCellRenderer) {.
        cdecl.}
    foreach*: proc (area: PCellArea; callback: TCellCallback; 
                    callback_data: gpointer) {.cdecl.}
    foreach_alloc*: proc (area: PCellArea; 
                          context: PCellAreaContext; 
                          widget: PWidget; cell_area: gdk3.PRectangle; 
                          background_area: gdk3.PRectangle; 
                          callback: TCellAllocCallback; 
                          callback_data: gpointer) {.cdecl.}
    event*: proc (area: PCellArea; context: PCellAreaContext; 
                  widget: PWidget; event: PEvent; 
                  cell_area: gdk3.PRectangle; flags: TCellRendererState): gint {.
        cdecl.}
    render*: proc (area: PCellArea; context: PCellAreaContext; 
                   widget: PWidget; cr: cairo.Pcontext; 
                   background_area: gdk3.PRectangle; 
                   cell_area: gdk3.PRectangle; flags: TCellRendererState; 
                   paint_focus: gboolean) {.cdecl.}
    apply_attributes*: proc (area: PCellArea; 
                             tree_model: PTreeModel; 
                             iter: PTreeIter; is_expander: gboolean; 
                             is_expanded: gboolean) {.cdecl.}
    create_context*: proc (area: PCellArea): PCellAreaContext {.
        cdecl.}
    copy_context*: proc (area: PCellArea; 
                         context: PCellAreaContext): PCellAreaContext {.
        cdecl.}
    get_request_mode*: proc (area: PCellArea): TSizeRequestMode {.
        cdecl.}
    get_preferred_width*: proc (area: PCellArea; 
                                context: PCellAreaContext; 
                                widget: PWidget; 
                                minimum_width: Pgint; 
                                natural_width: Pgint) {.cdecl.}
    get_preferred_height_for_width*: proc (area: PCellArea; 
        context: PCellAreaContext; widget: PWidget; width: gint; 
        minimum_height: Pgint; natural_height: Pgint) {.cdecl.}
    get_preferred_height*: proc (area: PCellArea; 
                                 context: PCellAreaContext; 
                                 widget: PWidget; 
                                 minimum_height: Pgint; 
                                 natural_height: Pgint) {.cdecl.}
    get_preferred_width_for_height*: proc (area: PCellArea; 
        context: PCellAreaContext; widget: PWidget; height: gint; 
        minimum_width: Pgint; natural_width: Pgint) {.cdecl.}
    set_cell_property*: proc (area: PCellArea; 
                              renderer: PCellRenderer; 
                              property_id: guint; value: PGValue; 
                              pspec: PGParamSpec) {.cdecl.}
    get_cell_property*: proc (area: PCellArea; 
                              renderer: PCellRenderer; 
                              property_id: guint; value: PGValue; 
                              pspec: PGParamSpec) {.cdecl.}
    focus*: proc (area: PCellArea; direction: TDirectionType): gboolean {.
        cdecl.}
    is_activatable*: proc (area: PCellArea): gboolean {.cdecl.}
    activate*: proc (area: PCellArea; context: PCellAreaContext; 
                     widget: PWidget; cell_area: gdk3.PRectangle; 
                     flags: TCellRendererState; edit_only: gboolean): gboolean {.
        cdecl.}
    ugtk_reserved221: proc () {.cdecl.}
    ugtk_reserved222: proc () {.cdecl.}
    ugtk_reserved223: proc () {.cdecl.}
    ugtk_reserved224: proc () {.cdecl.}
    ugtk_reserved225: proc () {.cdecl.}
    ugtk_reserved226: proc () {.cdecl.}
    ugtk_reserved227: proc () {.cdecl.}
    ugtk_reserved228: proc () {.cdecl.}

proc cell_area_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_area_get_type", dynlib: lib.}
proc add*(area: PCellArea; renderer: PCellRenderer) {.
    cdecl, importc: "gtk_cell_area_add", dynlib: lib.}
proc remove*(area: PCellArea; 
                           renderer: PCellRenderer) {.cdecl, 
    importc: "gtk_cell_area_remove", dynlib: lib.}
proc has_renderer*(area: PCellArea; 
                                 renderer: PCellRenderer): gboolean {.
    cdecl, importc: "gtk_cell_area_has_renderer", dynlib: lib.}
proc foreach*(area: PCellArea; callback: TCellCallback; 
                            callback_data: gpointer) {.cdecl, 
    importc: "gtk_cell_area_foreach", dynlib: lib.}
proc foreach_alloc*(area: PCellArea; 
                                  context: PCellAreaContext; 
                                  widget: PWidget; 
                                  cell_area: gdk3.PRectangle; 
                                  background_area: gdk3.PRectangle; 
                                  callback: TCellAllocCallback; 
                                  callback_data: gpointer) {.cdecl, 
    importc: "gtk_cell_area_foreach_alloc", dynlib: lib.}
proc event*(area: PCellArea; 
                          context: PCellAreaContext; 
                          widget: PWidget; event: PEvent; 
                          cell_area: gdk3.PRectangle; 
                          flags: TCellRendererState): gint {.cdecl, 
    importc: "gtk_cell_area_event", dynlib: lib.}
proc render*(area: PCellArea; 
                           context: PCellAreaContext; 
                           widget: PWidget; cr: cairo.Pcontext; 
                           background_area: gdk3.PRectangle; 
                           cell_area: gdk3.PRectangle; 
                           flags: TCellRendererState; paint_focus: gboolean) {.
    cdecl, importc: "gtk_cell_area_render", dynlib: lib.}
proc get_cell_allocation*(area: PCellArea; 
    context: PCellAreaContext; widget: PWidget; 
    renderer: PCellRenderer; cell_area: gdk3.PRectangle; 
    allocation: gdk3.PRectangle) {.cdecl, importc: "gtk_cell_area_get_cell_allocation", 
                                    dynlib: lib.}
proc get_cell_at_position*(area: PCellArea; 
    context: PCellAreaContext; widget: PWidget; 
    cell_area: gdk3.PRectangle; x: gint; y: gint; 
    alloc_area: gdk3.PRectangle): PCellRenderer {.cdecl, 
    importc: "gtk_cell_area_get_cell_at_position", dynlib: lib.}
proc create_context*(area: PCellArea): PCellAreaContext {.
    cdecl, importc: "gtk_cell_area_create_context", dynlib: lib.}
proc copy_context*(area: PCellArea; 
                                 context: PCellAreaContext): PCellAreaContext {.
    cdecl, importc: "gtk_cell_area_copy_context", dynlib: lib.}
proc get_request_mode*(area: PCellArea): TSizeRequestMode {.
    cdecl, importc: "gtk_cell_area_get_request_mode", dynlib: lib.}
proc get_preferred_width*(area: PCellArea; 
    context: PCellAreaContext; widget: PWidget; 
    minimum_width: Pgint; natural_width: Pgint) {.cdecl, 
    importc: "gtk_cell_area_get_preferred_width", dynlib: lib.}
proc get_preferred_height_for_width*(area: PCellArea; 
    context: PCellAreaContext; widget: PWidget; width: gint; 
    minimum_height: Pgint; natural_height: Pgint) {.cdecl, 
    importc: "gtk_cell_area_get_preferred_height_for_width", dynlib: lib.}
proc get_preferred_height*(area: PCellArea; 
    context: PCellAreaContext; widget: PWidget; 
    minimum_height: Pgint; natural_height: Pgint) {.cdecl, 
    importc: "gtk_cell_area_get_preferred_height", dynlib: lib.}
proc get_preferred_width_for_height*(area: PCellArea; 
    context: PCellAreaContext; widget: PWidget; height: gint; 
    minimum_width: Pgint; natural_width: Pgint) {.cdecl, 
    importc: "gtk_cell_area_get_preferred_width_for_height", dynlib: lib.}
proc get_current_path_string*(area: PCellArea): CSTRING {.
    cdecl, importc: "gtk_cell_area_get_current_path_string", dynlib: lib.}
proc apply_attributes*(area: PCellArea; 
                                     tree_model: PTreeModel; 
                                     iter: PTreeIter; 
                                     is_expander: gboolean; 
                                     is_expanded: gboolean) {.cdecl, 
    importc: "gtk_cell_area_apply_attributes", dynlib: lib.}
proc attribute_connect*(area: PCellArea; 
                                      renderer: PCellRenderer; 
                                      attribute: CSTRING; column: gint) {.
    cdecl, importc: "gtk_cell_area_attribute_connect", dynlib: lib.}
proc attribute_disconnect*(area: PCellArea; 
    renderer: PCellRenderer; attribute: CSTRING) {.cdecl, 
    importc: "gtk_cell_area_attribute_disconnect", dynlib: lib.}
proc install_cell_property*(aclass: PCellAreaClass; 
    property_id: guint; pspec: PGParamSpec) {.cdecl, 
    importc: "gtk_cell_area_class_install_cell_property", dynlib: lib.}
proc find_cell_property*(aclass: PCellAreaClass; 
    property_name: CSTRING): PGParamSpec {.cdecl, 
    importc: "gtk_cell_area_class_find_cell_property", dynlib: lib.}
proc list_cell_properties*(aclass: PCellAreaClass; 
    n_properties: Pguint): ptr PGParamSpec {.cdecl, 
    importc: "gtk_cell_area_class_list_cell_properties", dynlib: lib.}
proc add_with_properties*(area: PCellArea; 
    renderer: PCellRenderer; first_prop_name: CSTRING) {.varargs, 
    cdecl, importc: "gtk_cell_area_add_with_properties", dynlib: lib.}
proc cell_set*(area: PCellArea; 
                             renderer: PCellRenderer; 
                             first_prop_name: CSTRING) {.varargs, cdecl, 
    importc: "gtk_cell_area_cell_set", dynlib: lib.}
proc cell_get*(area: PCellArea; 
                             renderer: PCellRenderer; 
                             first_prop_name: CSTRING) {.varargs, cdecl, 
    importc: "gtk_cell_area_cell_get", dynlib: lib.}
proc cell_set_valist*(area: PCellArea; 
                                    renderer: PCellRenderer; 
                                    first_property_name: CSTRING; 
                                    var_args: va_list) {.cdecl, 
    importc: "gtk_cell_area_cell_set_valist", dynlib: lib.}
proc cell_get_valist*(area: PCellArea; 
                                    renderer: PCellRenderer; 
                                    first_property_name: CSTRING; 
                                    var_args: va_list) {.cdecl, 
    importc: "gtk_cell_area_cell_get_valist", dynlib: lib.}
proc cell_set_property*(area: PCellArea; 
                                      renderer: PCellRenderer; 
                                      property_name: CSTRING; 
                                      value: PGValue) {.cdecl, 
    importc: "gtk_cell_area_cell_set_property", dynlib: lib.}
proc cell_get_property*(area: PCellArea; 
                                      renderer: PCellRenderer; 
                                      property_name: CSTRING; 
                                      value: PGValue) {.cdecl, 
    importc: "gtk_cell_area_cell_get_property", dynlib: lib.}
proc is_activatable*(area: PCellArea): gboolean {.cdecl, 
    importc: "gtk_cell_area_is_activatable", dynlib: lib.}
proc activate*(area: PCellArea; 
                             context: PCellAreaContext; 
                             widget: PWidget; 
                             cell_area: gdk3.PRectangle; 
                             flags: TCellRendererState; edit_only: gboolean): gboolean {.
    cdecl, importc: "gtk_cell_area_activate", dynlib: lib.}
proc focus*(area: PCellArea; direction: TDirectionType): gboolean {.
    cdecl, importc: "gtk_cell_area_focus", dynlib: lib.}
proc set_focus_cell*(area: PCellArea; 
                                   renderer: PCellRenderer) {.cdecl, 
    importc: "gtk_cell_area_set_focus_cell", dynlib: lib.}
proc get_focus_cell*(area: PCellArea): PCellRenderer {.
    cdecl, importc: "gtk_cell_area_get_focus_cell", dynlib: lib.}
proc add_focus_sibling*(area: PCellArea; 
                                      renderer: PCellRenderer; 
                                      sibling: PCellRenderer) {.cdecl, 
    importc: "gtk_cell_area_add_focus_sibling", dynlib: lib.}
proc remove_focus_sibling*(area: PCellArea; 
    renderer: PCellRenderer; sibling: PCellRenderer) {.cdecl, 
    importc: "gtk_cell_area_remove_focus_sibling", dynlib: lib.}
proc is_focus_sibling*(area: PCellArea; 
                                     renderer: PCellRenderer; 
                                     sibling: PCellRenderer): gboolean {.
    cdecl, importc: "gtk_cell_area_is_focus_sibling", dynlib: lib.}
proc get_focus_siblings*(area: PCellArea; 
    renderer: PCellRenderer): PGList {.cdecl, 
    importc: "gtk_cell_area_get_focus_siblings", dynlib: lib.}
proc get_focus_from_sibling*(area: PCellArea; 
    renderer: PCellRenderer): PCellRenderer {.cdecl, 
    importc: "gtk_cell_area_get_focus_from_sibling", dynlib: lib.}
proc get_edited_cell*(area: PCellArea): PCellRenderer {.
    cdecl, importc: "gtk_cell_area_get_edited_cell", dynlib: lib.}
proc get_edit_widget*(area: PCellArea): PCellEditable {.
    cdecl, importc: "gtk_cell_area_get_edit_widget", dynlib: lib.}
proc activate_cell*(area: PCellArea; 
                                  widget: PWidget; 
                                  renderer: PCellRenderer; 
                                  event: PEvent; 
                                  cell_area: gdk3.PRectangle; 
                                  flags: TCellRendererState): gboolean {.
    cdecl, importc: "gtk_cell_area_activate_cell", dynlib: lib.}
proc stop_editing*(area: PCellArea; canceled: gboolean) {.
    cdecl, importc: "gtk_cell_area_stop_editing", dynlib: lib.}
proc inner_cell_area*(area: PCellArea; 
                                    widget: PWidget; 
                                    cell_area: gdk3.PRectangle; 
                                    inner_area: gdk3.PRectangle) {.cdecl, 
    importc: "gtk_cell_area_inner_cell_area", dynlib: lib.}
proc request_renderer*(area: PCellArea; 
                                     renderer: PCellRenderer; 
                                     orientation: TOrientation; 
                                     widget: PWidget; for_size: gint; 
                                     minimum_size: Pgint; 
                                     natural_size: Pgint) {.cdecl, 
    importc: "gtk_cell_area_request_renderer", dynlib: lib.}
proc underscore_gtk_cell_area_set_cell_data_func_with_proxy*(area: PCellArea; 
    cell: PCellRenderer; func: TGFunc; func_data: gpointer; 
    destroy: TGDestroyNotify; proxy: gpointer) {.cdecl, 
    importc: "_gtk_cell_area_set_cell_data_func_with_proxy", dynlib: lib.}

template TYPE_TREE_VIEW_COLUMN*(): expr = 
  (gtk_tree_view_column_get_type())

type 
  PTreeViewColumn* = ptr TTreeViewColumn
  TTreeViewColumn* = object of TGInitiallyUnowned
    priv29: PTreeViewColumnPrivate

type 
  PTreeViewColumnClass* = ptr TTreeViewColumnClass
  TTreeViewColumnClass* = object of TGInitiallyUnownedClass
    clicked*: proc (tree_column: PTreeViewColumn) {.cdecl.}
    ugtk_reserved231: proc () {.cdecl.}
    ugtk_reserved232: proc () {.cdecl.}
    ugtk_reserved233: proc () {.cdecl.}
    ugtk_reserved234: proc () {.cdecl.}

template TREE_VIEW_COLUMN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_VIEW_COLUMN, 
                              TTreeViewColumn))

template TREE_VIEW_COLUMN_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TREE_VIEW_COLUMN, 
                           TTreeViewColumnClass))

template IS_TREE_VIEW_COLUMN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_VIEW_COLUMN))

template IS_TREE_VIEW_COLUMN_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TREE_VIEW_COLUMN))

template TREE_VIEW_COLUMN_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TREE_VIEW_COLUMN, 
                             TTreeViewColumnClass))

type 
  TTreeViewColumnSizing* {.size: sizeof(cint).} = enum 
    TREE_VIEW_COLUMN_GROW_ONLY, TREE_VIEW_COLUMN_AUTOSIZE, 
    TREE_VIEW_COLUMN_FIXED
type 
  TTreeCellDataFunc* = proc (tree_column: PTreeViewColumn; 
                               cell: PCellRenderer; 
                               tree_model: PTreeModel; 
                               iter: PTreeIter; data: gpointer) {.cdecl.}
proc tree_view_column_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_view_column_get_type", dynlib: lib.}
proc tree_view_column_new*(): PTreeViewColumn {.cdecl, 
    importc: "gtk_tree_view_column_new", dynlib: lib.}
proc tree_view_column_new_with_area*(area: PCellArea): PTreeViewColumn {.
    cdecl, importc: "gtk_tree_view_column_new_with_area", dynlib: lib.}
proc tree_view_column_new_with_attributes*(title: CSTRING; 
    cell: PCellRenderer): PTreeViewColumn {.varargs, cdecl, 
    importc: "gtk_tree_view_column_new_with_attributes", dynlib: lib.}
proc tree_view_column_pack_start*(tree_column: PTreeViewColumn; 
                                      cell: PCellRenderer; 
                                      expand: gboolean) {.cdecl, 
    importc: "gtk_tree_view_column_pack_start", dynlib: lib.}
proc tree_view_column_pack_end*(tree_column: PTreeViewColumn; 
                                    cell: PCellRenderer; 
                                    expand: gboolean) {.cdecl, 
    importc: "gtk_tree_view_column_pack_end", dynlib: lib.}
proc clear*(tree_column: PTreeViewColumn) {.cdecl, 
    importc: "gtk_tree_view_column_clear", dynlib: lib.}
proc add_attribute*(tree_column: PTreeViewColumn; 
    cell_renderer: PCellRenderer; attribute: CSTRING; column: gint) {.
    cdecl, importc: "gtk_tree_view_column_add_attribute", dynlib: lib.}
proc set_attributes*(tree_column: PTreeViewColumn; 
    cell_renderer: PCellRenderer) {.varargs, cdecl, 
    importc: "gtk_tree_view_column_set_attributes", dynlib: lib.}
proc set_cell_data_func*(
    tree_column: PTreeViewColumn; cell_renderer: PCellRenderer; 
    func: TTreeCellDataFunc; func_data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_tree_view_column_set_cell_data_func", dynlib: lib.}
proc clear_attributes*(
    tree_column: PTreeViewColumn; cell_renderer: PCellRenderer) {.
    cdecl, importc: "gtk_tree_view_column_clear_attributes", dynlib: lib.}
proc set_spacing*(tree_column: PTreeViewColumn; 
    spacing: gint) {.cdecl, importc: "gtk_tree_view_column_set_spacing", 
                     dynlib: lib.}
proc get_spacing*(tree_column: PTreeViewColumn): gint {.
    cdecl, importc: "gtk_tree_view_column_get_spacing", dynlib: lib.}
proc set_visible*(tree_column: PTreeViewColumn; 
    visible: gboolean) {.cdecl, importc: "gtk_tree_view_column_set_visible", 
                         dynlib: lib.}
proc get_visible*(tree_column: PTreeViewColumn): gboolean {.
    cdecl, importc: "gtk_tree_view_column_get_visible", dynlib: lib.}
proc set_resizable*(tree_column: PTreeViewColumn; 
    resizable: gboolean) {.cdecl, 
                           importc: "gtk_tree_view_column_set_resizable", 
                           dynlib: lib.}
proc get_resizable*(tree_column: PTreeViewColumn): gboolean {.
    cdecl, importc: "gtk_tree_view_column_get_resizable", dynlib: lib.}
proc set_sizing*(tree_column: PTreeViewColumn; 
                                      typ: TTreeViewColumnSizing) {.cdecl, 
    importc: "gtk_tree_view_column_set_sizing", dynlib: lib.}
proc get_sizing*(tree_column: PTreeViewColumn): TTreeViewColumnSizing {.
    cdecl, importc: "gtk_tree_view_column_get_sizing", dynlib: lib.}
proc get_x_offset*(tree_column: PTreeViewColumn): gint {.
    cdecl, importc: "gtk_tree_view_column_get_x_offset", dynlib: lib.}
proc get_width*(tree_column: PTreeViewColumn): gint {.
    cdecl, importc: "gtk_tree_view_column_get_width", dynlib: lib.}
proc get_fixed_width*(tree_column: PTreeViewColumn): gint {.
    cdecl, importc: "gtk_tree_view_column_get_fixed_width", dynlib: lib.}
proc set_fixed_width*(tree_column: PTreeViewColumn; 
    fixed_width: gint) {.cdecl, 
                         importc: "gtk_tree_view_column_set_fixed_width", 
                         dynlib: lib.}
proc set_min_width*(tree_column: PTreeViewColumn; 
    min_width: gint) {.cdecl, importc: "gtk_tree_view_column_set_min_width", 
                       dynlib: lib.}
proc get_min_width*(tree_column: PTreeViewColumn): gint {.
    cdecl, importc: "gtk_tree_view_column_get_min_width", dynlib: lib.}
proc set_max_width*(tree_column: PTreeViewColumn; 
    max_width: gint) {.cdecl, importc: "gtk_tree_view_column_set_max_width", 
                       dynlib: lib.}
proc get_max_width*(tree_column: PTreeViewColumn): gint {.
    cdecl, importc: "gtk_tree_view_column_get_max_width", dynlib: lib.}
proc clicked*(tree_column: PTreeViewColumn) {.
    cdecl, importc: "gtk_tree_view_column_clicked", dynlib: lib.}
proc set_title*(tree_column: PTreeViewColumn; 
                                     title: CSTRING) {.cdecl, 
    importc: "gtk_tree_view_column_set_title", dynlib: lib.}
proc get_title*(tree_column: PTreeViewColumn): CSTRING {.
    cdecl, importc: "gtk_tree_view_column_get_title", dynlib: lib.}
proc set_expand*(tree_column: PTreeViewColumn; 
                                      expand: gboolean) {.cdecl, 
    importc: "gtk_tree_view_column_set_expand", dynlib: lib.}
proc get_expand*(tree_column: PTreeViewColumn): gboolean {.
    cdecl, importc: "gtk_tree_view_column_get_expand", dynlib: lib.}
proc set_clickable*(tree_column: PTreeViewColumn; 
    clickable: gboolean) {.cdecl, 
                           importc: "gtk_tree_view_column_set_clickable", 
                           dynlib: lib.}
proc get_clickable*(tree_column: PTreeViewColumn): gboolean {.
    cdecl, importc: "gtk_tree_view_column_get_clickable", dynlib: lib.}
proc set_widget*(tree_column: PTreeViewColumn; 
                                      widget: PWidget) {.cdecl, 
    importc: "gtk_tree_view_column_set_widget", dynlib: lib.}
proc get_widget*(tree_column: PTreeViewColumn): PWidget {.
    cdecl, importc: "gtk_tree_view_column_get_widget", dynlib: lib.}
proc set_alignment*(tree_column: PTreeViewColumn; 
    xalign: gfloat) {.cdecl, importc: "gtk_tree_view_column_set_alignment", 
                      dynlib: lib.}
proc get_alignment*(tree_column: PTreeViewColumn): gfloat {.
    cdecl, importc: "gtk_tree_view_column_get_alignment", dynlib: lib.}
proc set_reorderable*(tree_column: PTreeViewColumn; 
    reorderable: gboolean) {.cdecl, 
                             importc: "gtk_tree_view_column_set_reorderable", 
                             dynlib: lib.}
proc get_reorderable*(tree_column: PTreeViewColumn): gboolean {.
    cdecl, importc: "gtk_tree_view_column_get_reorderable", dynlib: lib.}
proc set_sort_column_id*(
    tree_column: PTreeViewColumn; sort_column_id: gint) {.cdecl, 
    importc: "gtk_tree_view_column_set_sort_column_id", dynlib: lib.}
proc get_sort_column_id*(
    tree_column: PTreeViewColumn): gint {.cdecl, 
    importc: "gtk_tree_view_column_get_sort_column_id", dynlib: lib.}
proc set_sort_indicator*(
    tree_column: PTreeViewColumn; setting: gboolean) {.cdecl, 
    importc: "gtk_tree_view_column_set_sort_indicator", dynlib: lib.}
proc get_sort_indicator*(
    tree_column: PTreeViewColumn): gboolean {.cdecl, 
    importc: "gtk_tree_view_column_get_sort_indicator", dynlib: lib.}
proc set_sort_order*(tree_column: PTreeViewColumn; 
    order: TSortType) {.cdecl, 
                          importc: "gtk_tree_view_column_set_sort_order", 
                          dynlib: lib.}
proc get_sort_order*(tree_column: PTreeViewColumn): TSortType {.
    cdecl, importc: "gtk_tree_view_column_get_sort_order", dynlib: lib.}
proc cell_set_cell_data*(
    tree_column: PTreeViewColumn; tree_model: PTreeModel; 
    iter: PTreeIter; is_expander: gboolean; is_expanded: gboolean) {.
    cdecl, importc: "gtk_tree_view_column_cell_set_cell_data", dynlib: lib.}
proc cell_get_size*(tree_column: PTreeViewColumn; 
    cell_area: gdk3.PRectangle; x_offset: Pgint; y_offset: Pgint; 
    width: Pgint; height: Pgint) {.cdecl, 
    importc: "gtk_tree_view_column_cell_get_size", dynlib: lib.}
proc cell_is_visible*(tree_column: PTreeViewColumn): gboolean {.
    cdecl, importc: "gtk_tree_view_column_cell_is_visible", dynlib: lib.}
proc focus_cell*(tree_column: PTreeViewColumn; 
                                      cell: PCellRenderer) {.cdecl, 
    importc: "gtk_tree_view_column_focus_cell", dynlib: lib.}
proc cell_get_position*(
    tree_column: PTreeViewColumn; cell_renderer: PCellRenderer; 
    x_offset: Pgint; width: Pgint): gboolean {.cdecl, 
    importc: "gtk_tree_view_column_cell_get_position", dynlib: lib.}
proc queue_resize*(tree_column: PTreeViewColumn) {.
    cdecl, importc: "gtk_tree_view_column_queue_resize", dynlib: lib.}
proc get_tree_view*(tree_column: PTreeViewColumn): PWidget {.
    cdecl, importc: "gtk_tree_view_column_get_tree_view", dynlib: lib.}
proc get_button*(tree_column: PTreeViewColumn): PWidget {.
    cdecl, importc: "gtk_tree_view_column_get_button", dynlib: lib.}

template TYPE_TEXT_ATTRIBUTES*(): expr = 
  (gtk_text_attributes_get_type())

type 
  PTextAppearance* = ptr TTextAppearance
  TTextAppearance*{.final, pure.} = object 
    bg_color*: gdk3.TColor
    fg_color*: gdk3.TColor
    rise*: gint
    bitfield41111*: guint
    rgba*: array[2, PRGBA]

type 
  PTextAttributes* = ptr TTextAttributes
  TTextAttributes*{.final, pure.} = object 
    refcount*: guint
    appearance*: TTextAppearance
    justification*: TJustification
    direction*: TTextDirection
    font*: PFontDescription
    font_scale*: gdouble
    left_margin*: gint
    right_margin*: gint
    indent*: gint
    pixels_above_lines*: gint
    pixels_below_lines*: gint
    pixels_inside_wrap*: gint
    tabs*: PTabArray
    wrap_mode*: TWrapMode
    language*: PLanguage
    pg_bg_color*: gdk3.PColor
    bitfield111*: guint
    pg_bg_rgba*: PRGBA
    padding*: array[3, guint]

proc text_attributes_new*(): PTextAttributes {.cdecl, 
    importc: "gtk_text_attributes_new", dynlib: lib.}
proc copy*(src: PTextAttributes): PTextAttributes {.
    cdecl, importc: "gtk_text_attributes_copy", dynlib: lib.}
proc copy_values*(src: PTextAttributes; 
                                      dest: PTextAttributes) {.cdecl, 
    importc: "gtk_text_attributes_copy_values", dynlib: lib.}
proc unref*(values: PTextAttributes) {.cdecl, 
    importc: "gtk_text_attributes_unref", dynlib: lib.}
proc re*(values: PTextAttributes): PTextAttributes {.
    cdecl, importc: "gtk_text_attributes_ref", dynlib: lib.}
proc text_attributes_get_type*(): GType {.cdecl, 
    importc: "gtk_text_attributes_get_type", dynlib: lib.}

template TYPE_TEXT_CHILD_ANCHOR*(): expr = 
  (gtk_text_child_anchor_get_type())

template TEXT_CHILD_ANCHOR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEXT_CHILD_ANCHOR, 
                              TTextChildAnchor))

template TEXT_CHILD_ANCHOR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEXT_CHILD_ANCHOR, 
                           TTextChildAnchorClass))

template IS_TEXT_CHILD_ANCHOR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEXT_CHILD_ANCHOR))

template IS_TEXT_CHILD_ANCHOR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TEXT_CHILD_ANCHOR))

template TEXT_CHILD_ANCHOR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TEXT_CHILD_ANCHOR, 
                             TTextChildAnchorClass))

type 
  PTextChildAnchor* = ptr TTextChildAnchor
  TTextChildAnchor* = object of TGObject
    segment*: gpointer

type 
  PTextChildAnchorClass* = ptr TTextChildAnchorClass
  TTextChildAnchorClass* = object of TGObjectClass
    ugtk_reserved241: proc () {.cdecl.}
    ugtk_reserved242: proc () {.cdecl.}
    ugtk_reserved243: proc () {.cdecl.}
    ugtk_reserved244: proc () {.cdecl.}

proc text_child_anchor_get_type*(): GType {.cdecl, 
    importc: "gtk_text_child_anchor_get_type", dynlib: lib.}
proc text_child_anchor_new*(): PTextChildAnchor {.cdecl, 
    importc: "gtk_text_child_anchor_new", dynlib: lib.}
proc get_widgets*(anchor: PTextChildAnchor): PGList {.
    cdecl, importc: "gtk_text_child_anchor_get_widgets", dynlib: lib.}
proc get_deleted*(anchor: PTextChildAnchor): gboolean {.
    cdecl, importc: "gtk_text_child_anchor_get_deleted", dynlib: lib.}

template TYPE_TEXT_TAG*(): expr = 
  (gtk_text_tag_get_type())

template TEXT_TAG_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEXT_TAG, TTextTag))

template TEXT_TAG_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEXT_TAG, TTextTagClass))

template IS_TEXT_TAG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEXT_TAG))

template IS_TEXT_TAG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TEXT_TAG))

template TEXT_TAG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TEXT_TAG, TTextTagClass))

type 
  PTextTag* = ptr TTextTag
  TTextTag* = object of TGObject
    priv30: PTextTagPrivate
type 
  PTextIter* = ptr TTextIter
  TTextIter*{.final, pure.} = object 
    dummy1*: gpointer
    dummy2*: gpointer
    dummy3*: gint
    dummy4*: gint
    dummy5*: gint
    dummy6*: gint
    dummy7*: gint
    dummy8*: gint
    dummy9*: gpointer
    dummy10*: gpointer
    dummy11*: gint
    dummy12*: gint
    dummy13*: gint
    dummy14*: gpointer

type 
  PTextTagClass* = ptr TTextTagClass
  TTextTagClass* = object of TGObjectClass
    event*: proc (tag: PTextTag; event_obj: PGObject; 
                  event: PEvent; iter: PTextIter): gboolean {.
        cdecl.}
    ugtk_reserved251: proc () {.cdecl.}
    ugtk_reserved252: proc () {.cdecl.}
    ugtk_reserved253: proc () {.cdecl.}
    ugtk_reserved254: proc () {.cdecl.}

proc text_tag_get_type*(): GType {.cdecl, 
    importc: "gtk_text_tag_get_type", dynlib: lib.}
proc text_tag_new*(name: CSTRING): PTextTag {.cdecl, 
    importc: "gtk_text_tag_new", dynlib: lib.}
proc get_priority*(tag: PTextTag): gint {.cdecl, 
    importc: "gtk_text_tag_get_priority", dynlib: lib.}
proc set_priority*(tag: PTextTag; priority: gint) {.cdecl, 
    importc: "gtk_text_tag_set_priority", dynlib: lib.}
proc event*(tag: PTextTag; event_obj: PGObject; 
                         event: PEvent; iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_tag_event", dynlib: lib.}

type 
  TTextSearchFlags* {.size: sizeof(cint).} = enum 
    TEXT_SEARCH_VISIBLE_ONLY = 1 shl 0, 
    TEXT_SEARCH_TEXT_ONLY = 1 shl 1, 
    TEXT_SEARCH_CASE_INSENSITIVE = 1 shl 2
type 
  PTextBuffer* = ptr TTextBuffer
  TTextBuffer* = object of TGObject
    priv31: PTextBufferPrivate
template TYPE_TEXT_ITER*(): expr = 
  (gtk_text_iter_get_type())


proc get_buffer*(iter: PTextIter): PTextBuffer {.
    cdecl, importc: "gtk_text_iter_get_buffer", dynlib: lib.}
proc copy*(iter: PTextIter): PTextIter {.cdecl, 
    importc: "gtk_text_iter_copy", dynlib: lib.}
proc free*(iter: PTextIter) {.cdecl, 
    importc: "gtk_text_iter_free", dynlib: lib.}
proc assign*(iter: PTextIter; other: PTextIter) {.
    cdecl, importc: "gtk_text_iter_assign", dynlib: lib.}
proc text_iter_get_type*(): GType {.cdecl, 
    importc: "gtk_text_iter_get_type", dynlib: lib.}
proc get_offset*(iter: PTextIter): gint {.cdecl, 
    importc: "gtk_text_iter_get_offset", dynlib: lib.}
proc get_line*(iter: PTextIter): gint {.cdecl, 
    importc: "gtk_text_iter_get_line", dynlib: lib.}
proc get_line_offset*(iter: PTextIter): gint {.cdecl, 
    importc: "gtk_text_iter_get_line_offset", dynlib: lib.}
proc get_line_index*(iter: PTextIter): gint {.cdecl, 
    importc: "gtk_text_iter_get_line_index", dynlib: lib.}
proc get_visible_line_offset*(iter: PTextIter): gint {.
    cdecl, importc: "gtk_text_iter_get_visible_line_offset", dynlib: lib.}
proc get_visible_line_index*(iter: PTextIter): gint {.
    cdecl, importc: "gtk_text_iter_get_visible_line_index", dynlib: lib.}
proc get_char*(iter: PTextIter): gunichar {.cdecl, 
    importc: "gtk_text_iter_get_char", dynlib: lib.}
proc get_slice*(start: PTextIter; e: PTextIter): CSTRING {.
    cdecl, importc: "gtk_text_iter_get_slice", dynlib: lib.}
proc get_text*(start: PTextIter; e: PTextIter): CSTRING {.
    cdecl, importc: "gtk_text_iter_get_text", dynlib: lib.}
proc get_visible_slice*(start: PTextIter; 
                                      e: PTextIter): CSTRING {.
    cdecl, importc: "gtk_text_iter_get_visible_slice", dynlib: lib.}
proc get_visible_text*(start: PTextIter; 
                                     e: PTextIter): CSTRING {.cdecl, 
    importc: "gtk_text_iter_get_visible_text", dynlib: lib.}
proc get_pixbuf*(iter: PTextIter): PPixbuf {.cdecl, 
    importc: "gtk_text_iter_get_pixbuf", dynlib: lib.}
proc get_marks*(iter: PTextIter): PGSList {.cdecl, 
    importc: "gtk_text_iter_get_marks", dynlib: lib.}
proc get_child_anchor*(iter: PTextIter): PTextChildAnchor {.
    cdecl, importc: "gtk_text_iter_get_child_anchor", dynlib: lib.}
proc get_toggled_tags*(iter: PTextIter; 
                                     toggled_on: gboolean): PGSList {.
    cdecl, importc: "gtk_text_iter_get_toggled_tags", dynlib: lib.}
proc begins_tag*(iter: PTextIter; tag: PTextTag): gboolean {.
    cdecl, importc: "gtk_text_iter_begins_tag", dynlib: lib.}
proc ends_tag*(iter: PTextIter; tag: PTextTag): gboolean {.
    cdecl, importc: "gtk_text_iter_ends_tag", dynlib: lib.}
proc toggles_tag*(iter: PTextIter; tag: PTextTag): gboolean {.
    cdecl, importc: "gtk_text_iter_toggles_tag", dynlib: lib.}
proc has_tag*(iter: PTextIter; tag: PTextTag): gboolean {.
    cdecl, importc: "gtk_text_iter_has_tag", dynlib: lib.}
proc get_tags*(iter: PTextIter): PGSList {.cdecl, 
    importc: "gtk_text_iter_get_tags", dynlib: lib.}
proc editable*(iter: PTextIter; default_setting: gboolean): gboolean {.
    cdecl, importc: "gtk_text_iter_editable", dynlib: lib.}
proc can_insert*(iter: PTextIter; 
                               default_editability: gboolean): gboolean {.
    cdecl, importc: "gtk_text_iter_can_insert", dynlib: lib.}
proc starts_word*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_starts_word", dynlib: lib.}
proc ends_word*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_ends_word", dynlib: lib.}
proc inside_word*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_inside_word", dynlib: lib.}
proc starts_sentence*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_starts_sentence", dynlib: lib.}
proc ends_sentence*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_ends_sentence", dynlib: lib.}
proc inside_sentence*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_inside_sentence", dynlib: lib.}
proc starts_line*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_starts_line", dynlib: lib.}
proc ends_line*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_ends_line", dynlib: lib.}
proc is_cursor_position*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_is_cursor_position", dynlib: lib.}
proc get_chars_in_line*(iter: PTextIter): gint {.cdecl, 
    importc: "gtk_text_iter_get_chars_in_line", dynlib: lib.}
proc get_bytes_in_line*(iter: PTextIter): gint {.cdecl, 
    importc: "gtk_text_iter_get_bytes_in_line", dynlib: lib.}
proc get_attributes*(iter: PTextIter; 
                                   values: PTextAttributes): gboolean {.
    cdecl, importc: "gtk_text_iter_get_attributes", dynlib: lib.}
proc get_language*(iter: PTextIter): PLanguage {.
    cdecl, importc: "gtk_text_iter_get_language", dynlib: lib.}
proc is_end*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_is_end", dynlib: lib.}
proc is_start*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_is_start", dynlib: lib.}
proc forward_char*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_forward_char", dynlib: lib.}
proc backward_char*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_backward_char", dynlib: lib.}
proc forward_chars*(iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_chars", dynlib: lib.}
proc backward_chars*(iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_chars", dynlib: lib.}
proc forward_line*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_forward_line", dynlib: lib.}
proc backward_line*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_backward_line", dynlib: lib.}
proc forward_lines*(iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_lines", dynlib: lib.}
proc backward_lines*(iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_lines", dynlib: lib.}
proc forward_word_end*(iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_forward_word_end", dynlib: lib.}
proc backward_word_start*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_word_start", dynlib: lib.}
proc forward_word_ends*(iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_word_ends", dynlib: lib.}
proc backward_word_starts*(iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_word_starts", dynlib: lib.}
proc forward_visible_line*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_visible_line", dynlib: lib.}
proc backward_visible_line*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_visible_line", dynlib: lib.}
proc forward_visible_lines*(iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_visible_lines", dynlib: lib.}
proc backward_visible_lines*(iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_visible_lines", dynlib: lib.}
proc forward_visible_word_end*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_visible_word_end", dynlib: lib.}
proc backward_visible_word_start*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_visible_word_start", dynlib: lib.}
proc forward_visible_word_ends*(iter: PTextIter; 
    count: gint): gboolean {.cdecl, importc: "gtk_text_iter_forward_visible_word_ends", 
                             dynlib: lib.}
proc backward_visible_word_starts*(iter: PTextIter; 
    count: gint): gboolean {.cdecl, importc: "gtk_text_iter_backward_visible_word_starts", 
                             dynlib: lib.}
proc forward_sentence_end*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_sentence_end", dynlib: lib.}
proc backward_sentence_start*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_sentence_start", dynlib: lib.}
proc forward_sentence_ends*(iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_sentence_ends", dynlib: lib.}
proc backward_sentence_starts*(iter: PTextIter; 
    count: gint): gboolean {.cdecl, importc: "gtk_text_iter_backward_sentence_starts", 
                             dynlib: lib.}
proc forward_cursor_position*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_cursor_position", dynlib: lib.}
proc backward_cursor_position*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_cursor_position", dynlib: lib.}
proc forward_cursor_positions*(iter: PTextIter; 
    count: gint): gboolean {.cdecl, importc: "gtk_text_iter_forward_cursor_positions", 
                             dynlib: lib.}
proc backward_cursor_positions*(iter: PTextIter; 
    count: gint): gboolean {.cdecl, importc: "gtk_text_iter_backward_cursor_positions", 
                             dynlib: lib.}
proc forward_visible_cursor_position*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_visible_cursor_position", 
    dynlib: lib.}
proc backward_visible_cursor_position*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_visible_cursor_position", 
    dynlib: lib.}
proc forward_visible_cursor_positions*(iter: PTextIter; 
    count: gint): gboolean {.cdecl, importc: "gtk_text_iter_forward_visible_cursor_positions", 
                             dynlib: lib.}
proc backward_visible_cursor_positions*(iter: PTextIter; 
    count: gint): gboolean {.cdecl, importc: "gtk_text_iter_backward_visible_cursor_positions", 
                             dynlib: lib.}
proc set_offset*(iter: PTextIter; char_offset: gint) {.
    cdecl, importc: "gtk_text_iter_set_offset", dynlib: lib.}
proc set_line*(iter: PTextIter; line_number: gint) {.
    cdecl, importc: "gtk_text_iter_set_line", dynlib: lib.}
proc set_line_offset*(iter: PTextIter; char_on_line: gint) {.
    cdecl, importc: "gtk_text_iter_set_line_offset", dynlib: lib.}
proc set_line_index*(iter: PTextIter; byte_on_line: gint) {.
    cdecl, importc: "gtk_text_iter_set_line_index", dynlib: lib.}
proc forward_to_end*(iter: PTextIter) {.cdecl, 
    importc: "gtk_text_iter_forward_to_end", dynlib: lib.}
proc forward_to_line_end*(iter: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_to_line_end", dynlib: lib.}
proc set_visible_line_offset*(iter: PTextIter; 
    char_on_line: gint) {.cdecl, 
                          importc: "gtk_text_iter_set_visible_line_offset", 
                          dynlib: lib.}
proc set_visible_line_index*(iter: PTextIter; 
    byte_on_line: gint) {.cdecl, 
                          importc: "gtk_text_iter_set_visible_line_index", 
                          dynlib: lib.}
proc forward_to_tag_toggle*(iter: PTextIter; 
    tag: PTextTag): gboolean {.cdecl, importc: "gtk_text_iter_forward_to_tag_toggle", 
                                     dynlib: lib.}
proc backward_to_tag_toggle*(iter: PTextIter; 
    tag: PTextTag): gboolean {.cdecl, importc: "gtk_text_iter_backward_to_tag_toggle", 
                                     dynlib: lib.}
type 
  TTextCharPredicate* = proc (ch: gunichar; user_data: gpointer): gboolean {.
      cdecl.}
proc forward_find_char*(iter: PTextIter; 
                                      pred: TTextCharPredicate; 
                                      user_data: gpointer; 
                                      limit: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_forward_find_char", dynlib: lib.}
proc backward_find_char*(iter: PTextIter; 
    pred: TTextCharPredicate; user_data: gpointer; limit: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_backward_find_char", dynlib: lib.}
proc forward_search*(iter: PTextIter; str: CSTRING; 
                                   flags: TTextSearchFlags; 
                                   match_start: PTextIter; 
                                   match_end: PTextIter; 
                                   limit: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_forward_search", dynlib: lib.}
proc backward_search*(iter: PTextIter; str: CSTRING; 
                                    flags: TTextSearchFlags; 
                                    match_start: PTextIter; 
                                    match_end: PTextIter; 
                                    limit: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_backward_search", dynlib: lib.}
proc equal*(lhs: PTextIter; rhs: PTextIter): gboolean {.
    cdecl, importc: "gtk_text_iter_equal", dynlib: lib.}
proc compare*(lhs: PTextIter; rhs: PTextIter): gint {.
    cdecl, importc: "gtk_text_iter_compare", dynlib: lib.}
proc in_range*(iter: PTextIter; start: PTextIter; 
                             e: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_iter_in_range", dynlib: lib.}
proc order*(first: PTextIter; second: PTextIter) {.
    cdecl, importc: "gtk_text_iter_order", dynlib: lib.}

type 
  PTargetPair* = ptr TTargetPair
  TTargetPair*{.final, pure.} = object 
    target*: TGdkAtom
    flags*: guint
    info*: guint

template TYPE_SELECTION_DATA*(): expr = 
  (gtk_selection_data_get_type())

template TYPE_TARGET_LIST*(): expr = 
  (gtk_target_list_get_type())

type 
  PTargetEntry* = ptr TTargetEntry
  TTargetEntry*{.final, pure.} = object 
    target*: CSTRING
    flags*: guint
    info*: guint

proc target_list_get_type*(): GType {.cdecl, 
    importc: "gtk_target_list_get_type", dynlib: lib.}
proc target_list_new*(targets: PTargetEntry; ntargets: guint): PTargetList {.
    cdecl, importc: "gtk_target_list_new", dynlib: lib.}
proc re*(list: PTargetList): PTargetList {.cdecl, 
    importc: "gtk_target_list_ref", dynlib: lib.}
proc unref*(list: PTargetList) {.cdecl, 
    importc: "gtk_target_list_unref", dynlib: lib.}
proc add*(list: PTargetList; target: TGdkAtom; 
                          flags: guint; info: guint) {.cdecl, 
    importc: "gtk_target_list_add", dynlib: lib.}
proc add_text_targets*(list: PTargetList; info: guint) {.
    cdecl, importc: "gtk_target_list_add_text_targets", dynlib: lib.}
proc add_rich_text_targets*(list: PTargetList; 
    info: guint; deserializable: gboolean; buffer: PTextBuffer) {.cdecl, 
    importc: "gtk_target_list_add_rich_text_targets", dynlib: lib.}
proc add_image_targets*(list: PTargetList; info: guint; 
    writable: gboolean) {.cdecl, importc: "gtk_target_list_add_image_targets", 
                          dynlib: lib.}
proc add_uri_targets*(list: PTargetList; info: guint) {.
    cdecl, importc: "gtk_target_list_add_uri_targets", dynlib: lib.}
proc add_table*(list: PTargetList; 
                                targets: PTargetEntry; ntargets: guint) {.
    cdecl, importc: "gtk_target_list_add_table", dynlib: lib.}
proc remove*(list: PTargetList; target: TGdkAtom) {.
    cdecl, importc: "gtk_target_list_remove", dynlib: lib.}
proc find*(list: PTargetList; target: TGdkAtom; 
                           info: Pguint): gboolean {.cdecl, 
    importc: "gtk_target_list_find", dynlib: lib.}
proc target_table_new_from_list*(list: PTargetList; 
                                     n_targets: Pgint): PTargetEntry {.
    cdecl, importc: "gtk_target_table_new_from_list", dynlib: lib.}
proc target_table_free*(targets: PTargetEntry; n_targets: gint) {.
    cdecl, importc: "gtk_target_table_free", dynlib: lib.}
proc selection_owner_set*(widget: PWidget; selection: TGdkAtom; 
                              time: guint32): gboolean {.cdecl, 
    importc: "gtk_selection_owner_set", dynlib: lib.}
proc selection_owner_set_for_display*(display: PGdkDisplay; 
    widget: PWidget; selection: TGdkAtom; time: guint32): gboolean {.
    cdecl, importc: "gtk_selection_owner_set_for_display", dynlib: lib.}
proc selection_add_target*(widget: PWidget; selection: TGdkAtom; 
                               target: TGdkAtom; info: guint) {.cdecl, 
    importc: "gtk_selection_add_target", dynlib: lib.}
proc selection_add_targets*(widget: PWidget; selection: TGdkAtom; 
                                targets: PTargetEntry; ntargets: guint) {.
    cdecl, importc: "gtk_selection_add_targets", dynlib: lib.}
proc selection_clear_targets*(widget: PWidget; selection: TGdkAtom) {.
    cdecl, importc: "gtk_selection_clear_targets", dynlib: lib.}
proc selection_convert*(widget: PWidget; selection: TGdkAtom; 
                            target: TGdkAtom; time: guint32): gboolean {.
    cdecl, importc: "gtk_selection_convert", dynlib: lib.}
proc selection_remove_all*(widget: PWidget) {.cdecl, 
    importc: "gtk_selection_remove_all", dynlib: lib.}
proc get_selection*(selection_data: PSelectionData): TGdkAtom {.
    cdecl, importc: "gtk_selection_data_get_selection", dynlib: lib.}
proc get_target*(selection_data: PSelectionData): TGdkAtom {.
    cdecl, importc: "gtk_selection_data_get_target", dynlib: lib.}
proc get_data_type*(selection_data: PSelectionData): TGdkAtom {.
    cdecl, importc: "gtk_selection_data_get_data_type", dynlib: lib.}
proc get_format*(selection_data: PSelectionData): gint {.
    cdecl, importc: "gtk_selection_data_get_format", dynlib: lib.}
proc get_data*(selection_data: PSelectionData): Pguchar {.
    cdecl, importc: "gtk_selection_data_get_data", dynlib: lib.}
proc get_length*(selection_data: PSelectionData): gint {.
    cdecl, importc: "gtk_selection_data_get_length", dynlib: lib.}
proc get_data_with_length*(
    selection_data: PSelectionData; length: Pgint): Pguchar {.
    cdecl, importc: "gtk_selection_data_get_data_with_length", dynlib: lib.}
proc get_display*(selection_data: PSelectionData): PGdkDisplay {.
    cdecl, importc: "gtk_selection_data_get_display", dynlib: lib.}
proc set*(selection_data: PSelectionData; 
                             typ: TGdkAtom; format: gint; data: Pguchar; 
                             length: gint) {.cdecl, 
    importc: "gtk_selection_data_set", dynlib: lib.}
proc set_text*(selection_data: PSelectionData; 
                                  str: CSTRING; len: gint): gboolean {.
    cdecl, importc: "gtk_selection_data_set_text", dynlib: lib.}
proc get_text*(selection_data: PSelectionData): Pguchar {.
    cdecl, importc: "gtk_selection_data_get_text", dynlib: lib.}
proc set_pixbuf*(selection_data: PSelectionData; 
                                    pixbuf: PPixbuf): gboolean {.cdecl, 
    importc: "gtk_selection_data_set_pixbuf", dynlib: lib.}
proc get_pixbuf*(selection_data: PSelectionData): PPixbuf {.
    cdecl, importc: "gtk_selection_data_get_pixbuf", dynlib: lib.}
proc set_uris*(selection_data: PSelectionData; 
                                  uris: ptr CSTRING): gboolean {.cdecl, 
    importc: "gtk_selection_data_set_uris", dynlib: lib.}
proc get_uris*(selection_data: PSelectionData): ptr CSTRING {.
    cdecl, importc: "gtk_selection_data_get_uris", dynlib: lib.}
proc get_targets*(selection_data: PSelectionData; 
                                     targets: ptr PGdkAtom; 
                                     n_atoms: Pgint): gboolean {.cdecl, 
    importc: "gtk_selection_data_get_targets", dynlib: lib.}
proc targets_include_text*(
    selection_data: PSelectionData): gboolean {.cdecl, 
    importc: "gtk_selection_data_targets_include_text", dynlib: lib.}
proc targets_include_rich_text*(
    selection_data: PSelectionData; buffer: PTextBuffer): gboolean {.
    cdecl, importc: "gtk_selection_data_targets_include_rich_text", 
    dynlib: lib.}
proc targets_include_image*(
    selection_data: PSelectionData; writable: gboolean): gboolean {.
    cdecl, importc: "gtk_selection_data_targets_include_image", dynlib: lib.}
proc targets_include_uri*(
    selection_data: PSelectionData): gboolean {.cdecl, 
    importc: "gtk_selection_data_targets_include_uri", dynlib: lib.}
proc include_text*(targets: PGdkAtom; n_targets: gint): gboolean {.
    cdecl, importc: "gtk_targets_include_text", dynlib: lib.}
proc include_rich_text*(targets: PGdkAtom; n_targets: gint; 
                                    buffer: PTextBuffer): gboolean {.
    cdecl, importc: "gtk_targets_include_rich_text", dynlib: lib.}
proc include_image*(targets: PGdkAtom; n_targets: gint; 
                                writable: gboolean): gboolean {.cdecl, 
    importc: "gtk_targets_include_image", dynlib: lib.}
proc include_uri*(targets: PGdkAtom; n_targets: gint): gboolean {.
    cdecl, importc: "gtk_targets_include_uri", dynlib: lib.}
proc selection_data_get_type*(): GType {.cdecl, 
    importc: "gtk_selection_data_get_type", dynlib: lib.}
proc copy*(data: PSelectionData): PSelectionData {.
    cdecl, importc: "gtk_selection_data_copy", dynlib: lib.}
proc free*(data: PSelectionData) {.cdecl, 
    importc: "gtk_selection_data_free", dynlib: lib.}
proc target_entry_get_type*(): GType {.cdecl, 
    importc: "gtk_target_entry_get_type", dynlib: lib.}
proc entry_new*(target: CSTRING; flags: guint; info: guint): PTargetEntry {.
    cdecl, importc: "gtk_target_entry_new", dynlib: lib.}
proc copy*(data: PTargetEntry): PTargetEntry {.
    cdecl, importc: "gtk_target_entry_copy", dynlib: lib.}
proc free*(data: PTargetEntry) {.cdecl, 
    importc: "gtk_target_entry_free", dynlib: lib.}

type 
  TDestDefaults* {.size: sizeof(cint).} = enum 
    DEST_DEFAULT_MOTION = 1 shl 0, DEST_DEFAULT_HIGHLIGHT = 1 shl 1, 
    DEST_DEFAULT_DROP = 1 shl 2, DEST_DEFAULT_ALL = 0x00000007
type 
  TTargetFlags* {.size: sizeof(cint).} = enum 
    TARGET_SAME_APP = 1 shl 0, TARGET_SAME_WIDGET = 1 shl 1, 
    TARGET_OTHER_APP = 1 shl 2, TARGET_OTHER_WIDGET = 1 shl 3
proc drag_get_data*(widget: PWidget; context: PDragContext; 
                        target: TGdkAtom; time: guint32) {.cdecl, 
    importc: "gtk_drag_get_data", dynlib: lib.}
proc drag_finish*(context: PDragContext; success: gboolean; 
                      del: gboolean; time: guint32) {.cdecl, 
    importc: "gtk_drag_finish", dynlib: lib.}
proc drag_get_source_widget*(context: PDragContext): PWidget {.
    cdecl, importc: "gtk_drag_get_source_widget", dynlib: lib.}
proc drag_highlight*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_highlight", dynlib: lib.}
proc drag_unhighlight*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_unhighlight", dynlib: lib.}
proc drag_dest_set*(widget: PWidget; flags: TDestDefaults; 
                        targets: PTargetEntry; n_targets: gint; 
                        actions: TDragAction) {.cdecl, 
    importc: "gtk_drag_dest_set", dynlib: lib.}
proc drag_dest_set_proxy*(widget: PWidget; 
                              proxy_window: PGdkWindow; 
                              protocol: TDragProtocol; 
                              use_coordinates: gboolean) {.cdecl, 
    importc: "gtk_drag_dest_set_proxy", dynlib: lib.}
proc drag_dest_unset*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_dest_unset", dynlib: lib.}
proc drag_dest_find_target*(widget: PWidget; 
                                context: PDragContext; 
                                target_list: PTargetList): TGdkAtom {.
    cdecl, importc: "gtk_drag_dest_find_target", dynlib: lib.}
proc drag_dest_get_target_list*(widget: PWidget): PTargetList {.
    cdecl, importc: "gtk_drag_dest_get_target_list", dynlib: lib.}
proc drag_dest_set_target_list*(widget: PWidget; 
                                    target_list: PTargetList) {.cdecl, 
    importc: "gtk_drag_dest_set_target_list", dynlib: lib.}
proc drag_dest_add_text_targets*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_dest_add_text_targets", dynlib: lib.}
proc drag_dest_add_image_targets*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_dest_add_image_targets", dynlib: lib.}
proc drag_dest_add_uri_targets*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_dest_add_uri_targets", dynlib: lib.}
proc drag_dest_set_track_motion*(widget: PWidget; 
                                     track_motion: gboolean) {.cdecl, 
    importc: "gtk_drag_dest_set_track_motion", dynlib: lib.}
proc drag_dest_get_track_motion*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_drag_dest_get_track_motion", dynlib: lib.}
proc drag_source_set*(widget: PWidget; 
                          start_button_mask: gdk3.TModifierType; 
                          targets: PTargetEntry; n_targets: gint; 
                          actions: TDragAction) {.cdecl, 
    importc: "gtk_drag_source_set", dynlib: lib.}
proc drag_source_unset*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_source_unset", dynlib: lib.}
proc drag_source_get_target_list*(widget: PWidget): PTargetList {.
    cdecl, importc: "gtk_drag_source_get_target_list", dynlib: lib.}
proc drag_source_set_target_list*(widget: PWidget; 
                                      target_list: PTargetList) {.cdecl, 
    importc: "gtk_drag_source_set_target_list", dynlib: lib.}
proc drag_source_add_text_targets*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_source_add_text_targets", dynlib: lib.}
proc drag_source_add_image_targets*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_source_add_image_targets", dynlib: lib.}
proc drag_source_add_uri_targets*(widget: PWidget) {.cdecl, 
    importc: "gtk_drag_source_add_uri_targets", dynlib: lib.}
proc drag_source_set_icon_pixbuf*(widget: PWidget; 
                                      pixbuf: PPixbuf) {.cdecl, 
    importc: "gtk_drag_source_set_icon_pixbuf", dynlib: lib.}
proc drag_source_set_icon_stock*(widget: PWidget; 
                                     stock_id: CSTRING) {.cdecl, 
    importc: "gtk_drag_source_set_icon_stock", dynlib: lib.}
proc drag_source_set_icon_name*(widget: PWidget; 
                                    icon_name: CSTRING) {.cdecl, 
    importc: "gtk_drag_source_set_icon_name", dynlib: lib.}
proc drag_source_set_icon_gicon*(widget: PWidget; icon: PGIcon) {.
    cdecl, importc: "gtk_drag_source_set_icon_gicon", dynlib: lib.}
proc drag_begin_with_coordinates*(widget: PWidget; 
                                      targets: PTargetList; 
                                      actions: TDragAction; button: gint; 
                                      event: PEvent; x: gint; y: gint): PDragContext {.
    cdecl, importc: "gtk_drag_begin_with_coordinates", dynlib: lib.}
proc drag_begin*(widget: PWidget; targets: PTargetList; 
                     actions: TDragAction; button: gint; event: PEvent): PDragContext {.
    cdecl, importc: "gtk_drag_begin", dynlib: lib.}
proc drag_set_icon_widget*(context: PDragContext; 
                               widget: PWidget; hot_x: gint; hot_y: gint) {.
    cdecl, importc: "gtk_drag_set_icon_widget", dynlib: lib.}
proc drag_set_icon_pixbuf*(context: PDragContext; 
                               pixbuf: PPixbuf; hot_x: gint; hot_y: gint) {.
    cdecl, importc: "gtk_drag_set_icon_pixbuf", dynlib: lib.}
proc drag_set_icon_stock*(context: PDragContext; 
                              stock_id: CSTRING; hot_x: gint; hot_y: gint) {.
    cdecl, importc: "gtk_drag_set_icon_stock", dynlib: lib.}
proc drag_set_icon_surface*(context: PDragContext; 
                                surface: Psurface) {.cdecl, 
    importc: "gtk_drag_set_icon_surface", dynlib: lib.}
proc drag_set_icon_name*(context: PDragContext; 
                             icon_name: CSTRING; hot_x: gint; hot_y: gint) {.
    cdecl, importc: "gtk_drag_set_icon_name", dynlib: lib.}
proc drag_set_icon_gicon*(context: PDragContext; icon: PGIcon; 
                              hot_x: gint; hot_y: gint) {.cdecl, 
    importc: "gtk_drag_set_icon_gicon", dynlib: lib.}
proc drag_set_icon_default*(context: PDragContext) {.cdecl, 
    importc: "gtk_drag_set_icon_default", dynlib: lib.}
proc drag_check_threshold*(widget: PWidget; start_x: gint; 
                               start_y: gint; current_x: gint; current_y: gint): gboolean {.
    cdecl, importc: "gtk_drag_check_threshold", dynlib: lib.}
proc underscore_gtk_drag_source_handle_event*(widget: PWidget; event: PEvent) {.
    cdecl, importc: "_gtk_drag_source_handle_event", dynlib: lib.}
proc underscore_gtk_drag_dest_handle_event*(toplevel: PWidget; event: PEvent) {.
    cdecl, importc: "_gtk_drag_dest_handle_event", dynlib: lib.}

template TYPE_EDITABLE*(): expr = 
  (gtk_editable_get_type())

template EDITABLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_EDITABLE, TEditable))

template IS_EDITABLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_EDITABLE))

template EDITABLE_GET_IFACE*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((inst), TYPE_EDITABLE, 
                                 TEditableInterface))

type 
  PEditableInterface* = ptr TEditableInterface
  TEditableInterface* = object of TGTypeInterface
    insert_text*: proc (editable: PEditable; new_text: CSTRING; 
                        new_text_length: gint; position: Pgint) {.cdecl.}
    delete_text*: proc (editable: PEditable; start_pos: gint; 
                        end_pos: gint) {.cdecl.}
    changed*: proc (editable: PEditable) {.cdecl.}
    do_insert_text*: proc (editable: PEditable; new_text: CSTRING; 
                           new_text_length: gint; position: Pgint) {.cdecl.}
    do_delete_text*: proc (editable: PEditable; start_pos: gint; 
                           end_pos: gint) {.cdecl.}
    get_chars*: proc (editable: PEditable; start_pos: gint; 
                      end_pos: gint): CSTRING {.cdecl.}
    set_selection_bounds*: proc (editable: PEditable; start_pos: gint; 
                                 end_pos: gint) {.cdecl.}
    get_selection_bounds*: proc (editable: PEditable; 
                                 start_pos: Pgint; end_pos: Pgint): gboolean {.
        cdecl.}
    set_position*: proc (editable: PEditable; position: gint) {.cdecl.}
    get_position*: proc (editable: PEditable): gint {.cdecl.}

proc editable_get_type*(): GType {.cdecl, 
    importc: "gtk_editable_get_type", dynlib: lib.}
proc select_region*(editable: PEditable; start_pos: gint; 
                                 end_pos: gint) {.cdecl, 
    importc: "gtk_editable_select_region", dynlib: lib.}
proc get_selection_bounds*(editable: PEditable; 
    start_pos: Pgint; end_pos: Pgint): gboolean {.cdecl, 
    importc: "gtk_editable_get_selection_bounds", dynlib: lib.}
proc insert_text*(editable: PEditable; new_text: CSTRING; 
                               new_text_length: gint; position: Pgint) {.
    cdecl, importc: "gtk_editable_insert_text", dynlib: lib.}
proc delete_text*(editable: PEditable; start_pos: gint; 
                               end_pos: gint) {.cdecl, 
    importc: "gtk_editable_delete_text", dynlib: lib.}
proc get_chars*(editable: PEditable; start_pos: gint; 
                             end_pos: gint): CSTRING {.cdecl, 
    importc: "gtk_editable_get_chars", dynlib: lib.}
proc cut_clipboard*(editable: PEditable) {.cdecl, 
    importc: "gtk_editable_cut_clipboard", dynlib: lib.}
proc copy_clipboard*(editable: PEditable) {.cdecl, 
    importc: "gtk_editable_copy_clipboard", dynlib: lib.}
proc paste_clipboard*(editable: PEditable) {.cdecl, 
    importc: "gtk_editable_paste_clipboard", dynlib: lib.}
proc delete_selection*(editable: PEditable) {.cdecl, 
    importc: "gtk_editable_delete_selection", dynlib: lib.}
proc set_position*(editable: PEditable; position: gint) {.
    cdecl, importc: "gtk_editable_set_position", dynlib: lib.}
proc get_position*(editable: PEditable): gint {.cdecl, 
    importc: "gtk_editable_get_position", dynlib: lib.}
proc set_editable*(editable: PEditable; 
                                is_editable: gboolean) {.cdecl, 
    importc: "gtk_editable_set_editable", dynlib: lib.}
proc get_editable*(editable: PEditable): gboolean {.cdecl, 
    importc: "gtk_editable_get_editable", dynlib: lib.}

template TYPE_IM_CONTEXT*(): expr = 
  (gtk_im_context_get_type())

template IM_CONTEXT_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_IM_CONTEXT, TIMContext))

template IM_CONTEXT_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_IM_CONTEXT, TIMContextClass))

template IS_IM_CONTEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_IM_CONTEXT))

template IS_IM_CONTEXT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_IM_CONTEXT))

template IM_CONTEXT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_IM_CONTEXT, TIMContextClass))

type 
  PIMContext* = ptr TIMContext
  TIMContext* = object of TGObject

type 
  PIMContextClass* = ptr TIMContextClass
  TIMContextClass* = object of TGObjectClass
    preedit_start*: proc (context: PIMContext) {.cdecl.}
    preedit_end*: proc (context: PIMContext) {.cdecl.}
    preedit_changed*: proc (context: PIMContext) {.cdecl.}
    commit*: proc (context: PIMContext; str: CSTRING) {.cdecl.}
    retrieve_surrounding*: proc (context: PIMContext): gboolean {.cdecl.}
    delete_surrounding*: proc (context: PIMContext; offset: gint; 
                               n_chars: gint): gboolean {.cdecl.}
    set_client_window*: proc (context: PIMContext; window: PGdkWindow) {.
        cdecl.}
    get_preedit_string*: proc (context: PIMContext; str: ptr CSTRING; 
                               attrs: ptr PAttrList; 
                               cursor_pos: Pgint) {.cdecl.}
    filter_keypress*: proc (context: PIMContext; event: PEventKey): gboolean {.
        cdecl.}
    focus_in*: proc (context: PIMContext) {.cdecl.}
    focus_out*: proc (context: PIMContext) {.cdecl.}
    reset*: proc (context: PIMContext) {.cdecl.}
    set_cursor_location*: proc (context: PIMContext; 
                                area: gdk3.PRectangle) {.cdecl.}
    set_use_preedit*: proc (context: PIMContext; use_preedit: gboolean) {.
        cdecl.}
    set_surrounding*: proc (context: PIMContext; text: CSTRING; 
                            len: gint; cursor_index: gint) {.cdecl.}
    get_surrounding*: proc (context: PIMContext; text: ptr CSTRING; 
                            cursor_index: Pgint): gboolean {.cdecl.}
    ugtk_reserved261: proc () {.cdecl.}
    ugtk_reserved262: proc () {.cdecl.}
    ugtk_reserved263: proc () {.cdecl.}
    ugtk_reserved264: proc () {.cdecl.}
    ugtk_reserved265: proc () {.cdecl.}
    ugtk_reserved266: proc () {.cdecl.}

proc im_context_get_type*(): GType {.cdecl, 
    importc: "gtk_im_context_get_type", dynlib: lib.}
proc set_client_window*(context: PIMContext; 
    window: PGdkWindow) {.cdecl, 
                             importc: "gtk_im_context_set_client_window", 
                             dynlib: lib.}
proc get_preedit_string*(context: PIMContext; 
    str: ptr CSTRING; attrs: ptr PAttrList; cursor_pos: Pgint) {.
    cdecl, importc: "gtk_im_context_get_preedit_string", dynlib: lib.}
proc filter_keypress*(context: PIMContext; 
                                     event: PEventKey): gboolean {.
    cdecl, importc: "gtk_im_context_filter_keypress", dynlib: lib.}
proc focus_in*(context: PIMContext) {.cdecl, 
    importc: "gtk_im_context_focus_in", dynlib: lib.}
proc focus_out*(context: PIMContext) {.cdecl, 
    importc: "gtk_im_context_focus_out", dynlib: lib.}
proc reset*(context: PIMContext) {.cdecl, 
    importc: "gtk_im_context_reset", dynlib: lib.}
proc set_cursor_location*(context: PIMContext; 
    area: gdk3.PRectangle) {.cdecl, 
                              importc: "gtk_im_context_set_cursor_location", 
                              dynlib: lib.}
proc set_use_preedit*(context: PIMContext; 
                                     use_preedit: gboolean) {.cdecl, 
    importc: "gtk_im_context_set_use_preedit", dynlib: lib.}
proc set_surrounding*(context: PIMContext; 
                                     text: CSTRING; len: gint; 
                                     cursor_index: gint) {.cdecl, 
    importc: "gtk_im_context_set_surrounding", dynlib: lib.}
proc get_surrounding*(context: PIMContext; 
                                     text: ptr CSTRING; 
                                     cursor_index: Pgint): gboolean {.
    cdecl, importc: "gtk_im_context_get_surrounding", dynlib: lib.}
proc delete_surrounding*(context: PIMContext; 
    offset: gint; n_chars: gint): gboolean {.cdecl, 
    importc: "gtk_im_context_delete_surrounding", dynlib: lib.}

const 
  ENTRY_BUFFER_MAX_SIZE* = G_MAXUSHORT
template TYPE_ENTRY_BUFFER*(): expr = 
  (gtk_entry_buffer_get_type())

template ENTRY_BUFFER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ENTRY_BUFFER, TEntryBuffer))

template ENTRY_BUFFER_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ENTRY_BUFFER, TEntryBufferClass))

template IS_ENTRY_BUFFER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ENTRY_BUFFER))

template IS_ENTRY_BUFFER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ENTRY_BUFFER))

template ENTRY_BUFFER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ENTRY_BUFFER, TEntryBufferClass))

type 
  PEntryBuffer* = ptr TEntryBuffer
  TEntryBuffer* = object of TGObject
    priv32: PEntryBufferPrivate

type 
  PEntryBufferClass* = ptr TEntryBufferClass
  TEntryBufferClass* = object of TGObjectClass
    inserted_text*: proc (buffer: PEntryBuffer; position: guint; 
                          chars: CSTRING; n_chars: guint) {.cdecl.}
    deleted_text*: proc (buffer: PEntryBuffer; position: guint; 
                         n_chars: guint) {.cdecl.}
    get_text*: proc (buffer: PEntryBuffer; n_bytes: Pgsize): CSTRING {.
        cdecl.}
    get_length*: proc (buffer: PEntryBuffer): guint {.cdecl.}
    insert_text*: proc (buffer: PEntryBuffer; position: guint; 
                        chars: CSTRING; n_chars: guint): guint {.cdecl.}
    delete_text*: proc (buffer: PEntryBuffer; position: guint; 
                        n_chars: guint): guint {.cdecl.}
    ugtk_reserved271: proc () {.cdecl.}
    ugtk_reserved272: proc () {.cdecl.}
    ugtk_reserved273: proc () {.cdecl.}
    ugtk_reserved274: proc () {.cdecl.}
    ugtk_reserved275: proc () {.cdecl.}
    ugtk_reserved276: proc () {.cdecl.}
    ugtk_reserved277: proc () {.cdecl.}
    ugtk_reserved278: proc () {.cdecl.}

proc entry_buffer_get_type*(): GType {.cdecl, 
    importc: "gtk_entry_buffer_get_type", dynlib: lib.}
proc entry_buffer_new*(initial_chars: CSTRING; n_initial_chars: gint): PEntryBuffer {.
    cdecl, importc: "gtk_entry_buffer_new", dynlib: lib.}
proc get_bytes*(buffer: PEntryBuffer): gsize {.cdecl, 
    importc: "gtk_entry_buffer_get_bytes", dynlib: lib.}
proc get_length*(buffer: PEntryBuffer): guint {.cdecl, 
    importc: "gtk_entry_buffer_get_length", dynlib: lib.}
proc get_text*(buffer: PEntryBuffer): CSTRING {.
    cdecl, importc: "gtk_entry_buffer_get_text", dynlib: lib.}
proc set_text*(buffer: PEntryBuffer; chars: CSTRING; 
                                n_chars: gint) {.cdecl, 
    importc: "gtk_entry_buffer_set_text", dynlib: lib.}
proc set_max_length*(buffer: PEntryBuffer; 
                                      max_length: gint) {.cdecl, 
    importc: "gtk_entry_buffer_set_max_length", dynlib: lib.}
proc get_max_length*(buffer: PEntryBuffer): gint {.
    cdecl, importc: "gtk_entry_buffer_get_max_length", dynlib: lib.}
proc insert_text*(buffer: PEntryBuffer; 
                                   position: guint; chars: CSTRING; 
                                   n_chars: gint): guint {.cdecl, 
    importc: "gtk_entry_buffer_insert_text", dynlib: lib.}
proc delete_text*(buffer: PEntryBuffer; 
                                   position: guint; n_chars: gint): guint {.
    cdecl, importc: "gtk_entry_buffer_delete_text", dynlib: lib.}
proc emit_inserted_text*(buffer: PEntryBuffer; 
    position: guint; chars: CSTRING; n_chars: guint) {.cdecl, 
    importc: "gtk_entry_buffer_emit_inserted_text", dynlib: lib.}
proc emit_deleted_text*(buffer: PEntryBuffer; 
    position: guint; n_chars: guint) {.cdecl, 
    importc: "gtk_entry_buffer_emit_deleted_text", dynlib: lib.}

template TYPE_LIST_STORE*(): expr = 
  (gtk_list_store_get_type())

template LIST_STORE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_LIST_STORE, TListStore))

template LIST_STORE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_LIST_STORE, TListStoreClass))

template IS_LIST_STORE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_LIST_STORE))

template IS_LIST_STORE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_LIST_STORE))

template LIST_STORE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_LIST_STORE, TListStoreClass))

type 
  PListStore* = ptr TListStore
  TListStore* = object of TGObject
    priv33: PListStorePrivate

type 
  PListStoreClass* = ptr TListStoreClass
  TListStoreClass* = object of TGObjectClass
    ugtk_reserved281: proc () {.cdecl.}
    ugtk_reserved282: proc () {.cdecl.}
    ugtk_reserved283: proc () {.cdecl.}
    ugtk_reserved284: proc () {.cdecl.}

proc list_store_get_type*(): GType {.cdecl, 
    importc: "gtk_list_store_get_type", dynlib: lib.}
proc list_store_new*(n_columns: gint): PListStore {.varargs, cdecl, 
    importc: "gtk_list_store_new", dynlib: lib.}
proc list_store_newv*(n_columns: gint; types: PGType): PListStore {.
    cdecl, importc: "gtk_list_store_newv", dynlib: lib.}
proc set_column_types*(list_store: PListStore; 
                                      n_columns: gint; types: PGType) {.
    cdecl, importc: "gtk_list_store_set_column_types", dynlib: lib.}
proc set_value*(list_store: PListStore; 
                               iter: PTreeIter; column: gint; 
                               value: PGValue) {.cdecl, 
    importc: "gtk_list_store_set_value", dynlib: lib.}
proc set*(list_store: PListStore; iter: PTreeIter) {.
    varargs, cdecl, importc: "gtk_list_store_set", dynlib: lib.}
proc set_valuesv*(list_store: PListStore; 
                                 iter: PTreeIter; columns: Pgint; 
                                 values: PGValue; n_values: gint) {.cdecl, 
    importc: "gtk_list_store_set_valuesv", dynlib: lib.}
proc set_valist*(list_store: PListStore; 
                                iter: PTreeIter; var_args: va_list) {.
    cdecl, importc: "gtk_list_store_set_valist", dynlib: lib.}
proc remove*(list_store: PListStore; 
                            iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_list_store_remove", dynlib: lib.}
proc insert*(list_store: PListStore; 
                            iter: PTreeIter; position: gint) {.cdecl, 
    importc: "gtk_list_store_insert", dynlib: lib.}
proc insert_before*(list_store: PListStore; 
                                   iter: PTreeIter; 
                                   sibling: PTreeIter) {.cdecl, 
    importc: "gtk_list_store_insert_before", dynlib: lib.}
proc insert_after*(list_store: PListStore; 
                                  iter: PTreeIter; 
                                  sibling: PTreeIter) {.cdecl, 
    importc: "gtk_list_store_insert_after", dynlib: lib.}
proc insert_with_values*(list_store: PListStore; 
    iter: PTreeIter; position: gint) {.varargs, cdecl, 
    importc: "gtk_list_store_insert_with_values", dynlib: lib.}
proc insert_with_valuesv*(list_store: PListStore; 
    iter: PTreeIter; position: gint; columns: Pgint; 
    values: PGValue; n_values: gint) {.cdecl, 
    importc: "gtk_list_store_insert_with_valuesv", dynlib: lib.}
proc prepend*(list_store: PListStore; 
                             iter: PTreeIter) {.cdecl, 
    importc: "gtk_list_store_prepend", dynlib: lib.}
proc append*(list_store: PListStore; 
                            iter: PTreeIter) {.cdecl, 
    importc: "gtk_list_store_append", dynlib: lib.}
proc clear*(list_store: PListStore) {.cdecl, 
    importc: "gtk_list_store_clear", dynlib: lib.}
proc iter_is_valid*(list_store: PListStore; 
                                   iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_list_store_iter_is_valid", dynlib: lib.}
proc reorder*(store: PListStore; new_order: Pgint) {.
    cdecl, importc: "gtk_list_store_reorder", dynlib: lib.}
proc swap*(store: PListStore; a: PTreeIter; 
                          b: PTreeIter) {.cdecl, 
    importc: "gtk_list_store_swap", dynlib: lib.}
proc move_after*(store: PListStore; 
                                iter: PTreeIter; 
                                position: PTreeIter) {.cdecl, 
    importc: "gtk_list_store_move_after", dynlib: lib.}
proc move_before*(store: PListStore; 
                                 iter: PTreeIter; 
                                 position: PTreeIter) {.cdecl, 
    importc: "gtk_list_store_move_before", dynlib: lib.}

template TYPE_TREE_MODEL_FILTER*(): expr = 
  (gtk_tree_model_filter_get_type())

template TREE_MODEL_FILTER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_MODEL_FILTER, 
                              TTreeModelFilter))

template TREE_MODEL_FILTER_CLASS*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((vtable), TYPE_TREE_MODEL_FILTER, 
                           TTreeModelFilterClass))

template IS_TREE_MODEL_FILTER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_MODEL_FILTER))

template IS_TREE_MODEL_FILTER_CLASS*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((vtable), TYPE_TREE_MODEL_FILTER))

template TREE_MODEL_FILTER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TREE_MODEL_FILTER, 
                             TTreeModelFilterClass))

type 
  TTreeModelFilterVisibleFunc* = proc (model: PTreeModel; 
      iter: PTreeIter; data: gpointer): gboolean {.cdecl.}
type 
  TTreeModelFilterModifyFunc* = proc (model: PTreeModel; 
      iter: PTreeIter; value: PGValue; column: gint; data: gpointer) {.
      cdecl.}
type 
  PTreeModelFilter* = ptr TTreeModelFilter
  TTreeModelFilter* = object of TGObject
    priv34: PTreeModelFilterPrivate

type 
  PTreeModelFilterClass* = ptr TTreeModelFilterClass
  TTreeModelFilterClass* = object of TGObjectClass
    visible*: proc (self: PTreeModelFilter; 
                    child_model: PTreeModel; iter: PTreeIter): gboolean {.
        cdecl.}
    modify*: proc (self: PTreeModelFilter; 
                   child_model: PTreeModel; iter: PTreeIter; 
                   value: PGValue; column: gint) {.cdecl.}
    ugtk_reserved291: proc () {.cdecl.}
    ugtk_reserved292: proc () {.cdecl.}
    ugtk_reserved293: proc () {.cdecl.}
    ugtk_reserved294: proc () {.cdecl.}

proc tree_model_filter_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_model_filter_get_type", dynlib: lib.}
proc filter_new*(child_model: PTreeModel; 
                                root: PTreePath): PTreeModel {.
    cdecl, importc: "gtk_tree_model_filter_new", dynlib: lib.}
proc set_visible_func*(filter: PTreeModelFilter; 
    func: TTreeModelFilterVisibleFunc; data: gpointer; 
    destroy: TGDestroyNotify) {.cdecl, importc: "gtk_tree_model_filter_set_visible_func", 
                               dynlib: lib.}
proc set_modify_func*(filter: PTreeModelFilter; 
    n_columns: gint; types: PGType; func: TTreeModelFilterModifyFunc; 
    data: gpointer; destroy: TGDestroyNotify) {.cdecl, 
    importc: "gtk_tree_model_filter_set_modify_func", dynlib: lib.}
proc set_visible_column*(filter: PTreeModelFilter; 
    column: gint) {.cdecl, 
                    importc: "gtk_tree_model_filter_set_visible_column", 
                    dynlib: lib.}
proc get_model*(filter: PTreeModelFilter): PTreeModel {.
    cdecl, importc: "gtk_tree_model_filter_get_model", dynlib: lib.}
proc convert_child_iter_to_iter*(
    filter: PTreeModelFilter; filter_iter: PTreeIter; 
    child_iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_model_filter_convert_child_iter_to_iter", dynlib: lib.}
proc convert_iter_to_child_iter*(
    filter: PTreeModelFilter; child_iter: PTreeIter; 
    filter_iter: PTreeIter) {.cdecl, importc: "gtk_tree_model_filter_convert_iter_to_child_iter", 
                                    dynlib: lib.}
proc convert_child_path_to_path*(
    filter: PTreeModelFilter; child_path: PTreePath): PTreePath {.
    cdecl, importc: "gtk_tree_model_filter_convert_child_path_to_path", 
    dynlib: lib.}
proc convert_path_to_child_path*(
    filter: PTreeModelFilter; filter_path: PTreePath): PTreePath {.
    cdecl, importc: "gtk_tree_model_filter_convert_path_to_child_path", 
    dynlib: lib.}
proc refilter*(filter: PTreeModelFilter) {.cdecl, 
    importc: "gtk_tree_model_filter_refilter", dynlib: lib.}
proc clear_cache*(filter: PTreeModelFilter) {.
    cdecl, importc: "gtk_tree_model_filter_clear_cache", dynlib: lib.}

template TYPE_ENTRY_COMPLETION*(): expr = 
  (gtk_entry_completion_get_type())

template ENTRY_COMPLETION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ENTRY_COMPLETION, 
                              TEntryCompletion))

template ENTRY_COMPLETION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ENTRY_COMPLETION, 
                           TEntryCompletionClass))

template IS_ENTRY_COMPLETION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ENTRY_COMPLETION))

template IS_ENTRY_COMPLETION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ENTRY_COMPLETION))

template ENTRY_COMPLETION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ENTRY_COMPLETION, 
                             TEntryCompletionClass))

type 
  PEntryCompletion* = ptr TEntryCompletion
  TEntryCompletion* = object of TGObject
    priv35: PEntryCompletionPrivate

type 
  TEntryCompletionMatchFunc* = proc (completion: PEntryCompletion; 
      key: CSTRING; iter: PTreeIter; user_data: gpointer): gboolean {.
      cdecl.}

type 
  PEntryCompletionClass* = ptr TEntryCompletionClass
  TEntryCompletionClass* = object of TGObjectClass
    match_selected*: proc (completion: PEntryCompletion; 
                           model: PTreeModel; iter: PTreeIter): gboolean {.
        cdecl.}
    action_activated*: proc (completion: PEntryCompletion; index: gint) {.
        cdecl.}
    insert_prefix*: proc (completion: PEntryCompletion; 
                          prefix: CSTRING): gboolean {.cdecl.}
    cursor_on_match*: proc (completion: PEntryCompletion; 
                            model: PTreeModel; iter: PTreeIter): gboolean {.
        cdecl.}
    ugtk_reserved300: proc () {.cdecl.}
    ugtk_reserved301: proc () {.cdecl.}
    ugtk_reserved302: proc () {.cdecl.}
    ugtk_reserved303: proc () {.cdecl.}

proc entry_completion_get_type*(): GType {.cdecl, 
    importc: "gtk_entry_completion_get_type", dynlib: lib.}
proc entry_completion_new*(): PEntryCompletion {.cdecl, 
    importc: "gtk_entry_completion_new", dynlib: lib.}
proc entry_completion_new_with_area*(area: PCellArea): PEntryCompletion {.
    cdecl, importc: "gtk_entry_completion_new_with_area", dynlib: lib.}
proc get_entry*(completion: PEntryCompletion): PWidget {.
    cdecl, importc: "gtk_entry_completion_get_entry", dynlib: lib.}
proc set_model*(completion: PEntryCompletion; 
                                     model: PTreeModel) {.cdecl, 
    importc: "gtk_entry_completion_set_model", dynlib: lib.}
proc get_model*(completion: PEntryCompletion): PTreeModel {.
    cdecl, importc: "gtk_entry_completion_get_model", dynlib: lib.}
proc set_match_func*(completion: PEntryCompletion; 
    func: TEntryCompletionMatchFunc; func_data: gpointer; 
    func_notify: TGDestroyNotify) {.cdecl, importc: "gtk_entry_completion_set_match_func", 
                                   dynlib: lib.}
proc set_minimum_key_length*(
    completion: PEntryCompletion; length: gint) {.cdecl, 
    importc: "gtk_entry_completion_set_minimum_key_length", dynlib: lib.}
proc get_minimum_key_length*(
    completion: PEntryCompletion): gint {.cdecl, 
    importc: "gtk_entry_completion_get_minimum_key_length", dynlib: lib.}
proc compute_prefix*(completion: PEntryCompletion; 
    key: cstring): CSTRING {.cdecl, importc: "gtk_entry_completion_compute_prefix", 
                               dynlib: lib.}
proc complete*(completion: PEntryCompletion) {.
    cdecl, importc: "gtk_entry_completion_complete", dynlib: lib.}
proc insert_prefix*(completion: PEntryCompletion) {.
    cdecl, importc: "gtk_entry_completion_insert_prefix", dynlib: lib.}
proc insert_action_text*(
    completion: PEntryCompletion; index: gint; text: CSTRING) {.
    cdecl, importc: "gtk_entry_completion_insert_action_text", dynlib: lib.}
proc insert_action_markup*(
    completion: PEntryCompletion; index: gint; markup: CSTRING) {.
    cdecl, importc: "gtk_entry_completion_insert_action_markup", dynlib: lib.}
proc delete_action*(completion: PEntryCompletion; 
    index: gint) {.cdecl, importc: "gtk_entry_completion_delete_action", 
                    dynlib: lib.}
proc set_inline_completion*(
    completion: PEntryCompletion; inline_completion: gboolean) {.cdecl, 
    importc: "gtk_entry_completion_set_inline_completion", dynlib: lib.}
proc get_inline_completion*(
    completion: PEntryCompletion): gboolean {.cdecl, 
    importc: "gtk_entry_completion_get_inline_completion", dynlib: lib.}
proc set_inline_selection*(
    completion: PEntryCompletion; inline_selection: gboolean) {.cdecl, 
    importc: "gtk_entry_completion_set_inline_selection", dynlib: lib.}
proc get_inline_selection*(
    completion: PEntryCompletion): gboolean {.cdecl, 
    importc: "gtk_entry_completion_get_inline_selection", dynlib: lib.}
proc set_popup_completion*(
    completion: PEntryCompletion; popup_completion: gboolean) {.cdecl, 
    importc: "gtk_entry_completion_set_popup_completion", dynlib: lib.}
proc get_popup_completion*(
    completion: PEntryCompletion): gboolean {.cdecl, 
    importc: "gtk_entry_completion_get_popup_completion", dynlib: lib.}
proc set_popup_set_width*(
    completion: PEntryCompletion; popup_set_width: gboolean) {.cdecl, 
    importc: "gtk_entry_completion_set_popup_set_width", dynlib: lib.}
proc get_popup_set_width*(
    completion: PEntryCompletion): gboolean {.cdecl, 
    importc: "gtk_entry_completion_get_popup_set_width", dynlib: lib.}
proc set_popup_single_match*(
    completion: PEntryCompletion; popup_single_match: gboolean) {.cdecl, 
    importc: "gtk_entry_completion_set_popup_single_match", dynlib: lib.}
proc get_popup_single_match*(
    completion: PEntryCompletion): gboolean {.cdecl, 
    importc: "gtk_entry_completion_get_popup_single_match", dynlib: lib.}
proc get_completion_prefix*(
    completion: PEntryCompletion): CSTRING {.cdecl, 
    importc: "gtk_entry_completion_get_completion_prefix", dynlib: lib.}
proc set_text_column*(completion: PEntryCompletion; 
    column: gint) {.cdecl, importc: "gtk_entry_completion_set_text_column", 
                    dynlib: lib.}
proc get_text_column*(completion: PEntryCompletion): gint {.
    cdecl, importc: "gtk_entry_completion_get_text_column", dynlib: lib.}

template TYPE_IMAGE*(): expr = 
  (gtk_image_get_type())

template IMAGE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_IMAGE, TImage))

template IMAGE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_IMAGE, TImageClass))

template IS_IMAGE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_IMAGE))

template IS_IMAGE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_IMAGE))

template IMAGE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_IMAGE, TImageClass))

type 
  TImageType* {.size: sizeof(cint).} = enum 
    IMAGE_EMPTY, IMAGE_PIXBUF, IMAGE_STOCK, IMAGE_ICON_SET, 
    IMAGE_ANIMATION, IMAGE_ICON_NAME, IMAGE_GICON, 
    IMAGE_SURFACE
type 
  PImage* = ptr TImage
  TImage* = object of TMisc
    priv36: PImagePrivate

type 
  PImageClass* = ptr TImageClass
  TImageClass* = object of TMiscClass
    ugtk_reserved311: proc () {.cdecl.}
    ugtk_reserved312: proc () {.cdecl.}
    ugtk_reserved313: proc () {.cdecl.}
    ugtk_reserved314: proc () {.cdecl.}

proc image_get_type*(): GType {.cdecl, importc: "gtk_image_get_type", 
                                    dynlib: lib.}
proc image_new*(): PWidget {.cdecl, importc: "gtk_image_new", 
    dynlib: lib.}
proc image_new_from_file*(filename: CSTRING): PWidget {.cdecl, 
    importc: "gtk_image_new_from_file", dynlib: lib.}
proc image_new_from_resource*(resource_path: CSTRING): PWidget {.
    cdecl, importc: "gtk_image_new_from_resource", dynlib: lib.}
proc image_new_from_pixbuf*(pixbuf: PPixbuf): PWidget {.cdecl, 
    importc: "gtk_image_new_from_pixbuf", dynlib: lib.}
proc image_new_from_stock*(stock_id: CSTRING; size: TIconSize): PWidget {.
    cdecl, importc: "gtk_image_new_from_stock", dynlib: lib.}
proc image_new_from_icon_set*(icon_set: PIconSet; size: TIconSize): PWidget {.
    cdecl, importc: "gtk_image_new_from_icon_set", dynlib: lib.}
proc image_new_from_animation*(animation: PPixbufAnimation): PWidget {.
    cdecl, importc: "gtk_image_new_from_animation", dynlib: lib.}
proc image_new_from_icon_name*(icon_name: CSTRING; size: TIconSize): PWidget {.
    cdecl, importc: "gtk_image_new_from_icon_name", dynlib: lib.}
proc image_new_from_gicon*(icon: PGIcon; size: TIconSize): PWidget {.
    cdecl, importc: "gtk_image_new_from_gicon", dynlib: lib.}
proc image_new_from_surface*(surface: Psurface): PWidget {.
    cdecl, importc: "gtk_image_new_from_surface", dynlib: lib.}
proc clear*(image: PImage) {.cdecl, 
    importc: "gtk_image_clear", dynlib: lib.}
proc set_from_file*(image: PImage; filename: CSTRING) {.
    cdecl, importc: "gtk_image_set_from_file", dynlib: lib.}
proc set_from_resource*(image: PImage; 
                                  resource_path: CSTRING) {.cdecl, 
    importc: "gtk_image_set_from_resource", dynlib: lib.}
proc set_from_pixbuf*(image: PImage; pixbuf: PPixbuf) {.
    cdecl, importc: "gtk_image_set_from_pixbuf", dynlib: lib.}
proc set_from_stock*(image: PImage; stock_id: CSTRING; 
                               size: TIconSize) {.cdecl, 
    importc: "gtk_image_set_from_stock", dynlib: lib.}
proc set_from_icon_set*(image: PImage; 
                                  icon_set: PIconSet; size: TIconSize) {.
    cdecl, importc: "gtk_image_set_from_icon_set", dynlib: lib.}
proc set_from_animation*(image: PImage; 
                                   animation: PPixbufAnimation) {.cdecl, 
    importc: "gtk_image_set_from_animation", dynlib: lib.}
proc set_from_icon_name*(image: PImage; icon_name: CSTRING; 
                                   size: TIconSize) {.cdecl, 
    importc: "gtk_image_set_from_icon_name", dynlib: lib.}
proc set_from_gicon*(image: PImage; icon: PGIcon; 
                               size: TIconSize) {.cdecl, 
    importc: "gtk_image_set_from_gicon", dynlib: lib.}
proc set_from_surface*(image: PImage; 
                                 surface: Psurface) {.cdecl, 
    importc: "gtk_image_set_from_surface", dynlib: lib.}
proc set_pixel_size*(image: PImage; pixel_size: gint) {.cdecl, 
    importc: "gtk_image_set_pixel_size", dynlib: lib.}
proc get_storage_type*(image: PImage): TImageType {.cdecl, 
    importc: "gtk_image_get_storage_type", dynlib: lib.}
proc get_pixbuf*(image: PImage): PPixbuf {.cdecl, 
    importc: "gtk_image_get_pixbuf", dynlib: lib.}
proc get_stock*(image: PImage; stock_id: ptr CSTRING; 
                          size: PIconSize) {.cdecl, 
    importc: "gtk_image_get_stock", dynlib: lib.}
proc get_icon_set*(image: PImage; 
                             icon_set: ptr PIconSet; 
                             size: PIconSize) {.cdecl, 
    importc: "gtk_image_get_icon_set", dynlib: lib.}
proc get_animation*(image: PImage): PPixbufAnimation {.
    cdecl, importc: "gtk_image_get_animation", dynlib: lib.}
proc get_icon_name*(image: PImage; icon_name: ptr CSTRING; 
                              size: PIconSize) {.cdecl, 
    importc: "gtk_image_get_icon_name", dynlib: lib.}
proc get_gicon*(image: PImage; gicon: ptr PGIcon; 
                          size: PIconSize) {.cdecl, 
    importc: "gtk_image_get_gicon", dynlib: lib.}
proc get_pixel_size*(image: PImage): gint {.cdecl, 
    importc: "gtk_image_get_pixel_size", dynlib: lib.}

template TYPE_ENTRY*(): expr = 
  (gtk_entry_get_type())

template ENTRY_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ENTRY, TEntry))

template ENTRY_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ENTRY, TEntryClass))

template IS_ENTRY*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ENTRY))

template IS_ENTRY_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ENTRY))

template ENTRY_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ENTRY, TEntryClass))

type 
  TEntryIconPosition* {.size: sizeof(cint).} = enum 
    ENTRY_ICON_PRIMARY, ENTRY_ICON_SECONDARY
type 
  PEntry* = ptr TEntry
  TEntry* = object of TWidget
    priv37: PEntryPrivate

type 
  PEntryClass* = ptr TEntryClass
  TEntryClass* = object of TWidgetClass
    populate_popup*: proc (entry: PEntry; popup: PWidget) {.cdecl.}
    activate*: proc (entry: PEntry) {.cdecl.}
    move_cursor*: proc (entry: PEntry; step: TMovementStep; 
                        count: gint; extend_selection: gboolean) {.cdecl.}
    insert_at_cursor*: proc (entry: PEntry; str: CSTRING) {.cdecl.}
    delete_from_cursor*: proc (entry: PEntry; typ: TDeleteType; 
                               count: gint) {.cdecl.}
    backspace*: proc (entry: PEntry) {.cdecl.}
    cut_clipboard*: proc (entry: PEntry) {.cdecl.}
    copy_clipboard*: proc (entry: PEntry) {.cdecl.}
    paste_clipboard*: proc (entry: PEntry) {.cdecl.}
    toggle_overwrite*: proc (entry: PEntry) {.cdecl.}
    get_text_area_size*: proc (entry: PEntry; x: Pgint; y: Pgint; 
                               width: Pgint; height: Pgint) {.cdecl.}
    get_frame_size*: proc (entry: PEntry; x: Pgint; y: Pgint; 
                           width: Pgint; height: Pgint) {.cdecl.}
    ugtk_reserved321: proc () {.cdecl.}
    ugtk_reserved322: proc () {.cdecl.}
    ugtk_reserved323: proc () {.cdecl.}
    ugtk_reserved324: proc () {.cdecl.}
    ugtk_reserved325: proc () {.cdecl.}
    ugtk_reserved326: proc () {.cdecl.}
    ugtk_reserved327: proc () {.cdecl.}

proc entry_get_type*(): GType {.cdecl, importc: "gtk_entry_get_type", 
                                    dynlib: lib.}
proc entry_new*(): PWidget {.cdecl, importc: "gtk_entry_new", 
    dynlib: lib.}
proc entry_new_with_buffer*(buffer: PEntryBuffer): PWidget {.
    cdecl, importc: "gtk_entry_new_with_buffer", dynlib: lib.}
proc get_buffer*(entry: PEntry): PEntryBuffer {.cdecl, 
    importc: "gtk_entry_get_buffer", dynlib: lib.}
proc set_buffer*(entry: PEntry; buffer: PEntryBuffer) {.
    cdecl, importc: "gtk_entry_set_buffer", dynlib: lib.}
proc get_text_area*(entry: PEntry; text_area: gdk3.PRectangle) {.
    cdecl, importc: "gtk_entry_get_text_area", dynlib: lib.}
proc set_visibility*(entry: PEntry; visible: gboolean) {.
    cdecl, importc: "gtk_entry_set_visibility", dynlib: lib.}
proc get_visibility*(entry: PEntry): gboolean {.cdecl, 
    importc: "gtk_entry_get_visibility", dynlib: lib.}
proc set_invisible_char*(entry: PEntry; ch: gunichar) {.cdecl, 
    importc: "gtk_entry_set_invisible_char", dynlib: lib.}
proc get_invisible_char*(entry: PEntry): gunichar {.cdecl, 
    importc: "gtk_entry_get_invisible_char", dynlib: lib.}
proc unset_invisible_char*(entry: PEntry) {.cdecl, 
    importc: "gtk_entry_unset_invisible_char", dynlib: lib.}
proc set_has_frame*(entry: PEntry; setting: gboolean) {.cdecl, 
    importc: "gtk_entry_set_has_frame", dynlib: lib.}
proc get_has_frame*(entry: PEntry): gboolean {.cdecl, 
    importc: "gtk_entry_get_has_frame", dynlib: lib.}
proc set_inner_border*(entry: PEntry; border: PBorder) {.
    cdecl, importc: "gtk_entry_set_inner_border", dynlib: lib.}
proc get_inner_border*(entry: PEntry): PBorder {.cdecl, 
    importc: "gtk_entry_get_inner_border", dynlib: lib.}
proc set_overwrite_mode*(entry: PEntry; overwrite: gboolean) {.
    cdecl, importc: "gtk_entry_set_overwrite_mode", dynlib: lib.}
proc get_overwrite_mode*(entry: PEntry): gboolean {.cdecl, 
    importc: "gtk_entry_get_overwrite_mode", dynlib: lib.}
proc set_max_length*(entry: PEntry; max: gint) {.cdecl, 
    importc: "gtk_entry_set_max_length", dynlib: lib.}
proc get_max_length*(entry: PEntry): gint {.cdecl, 
    importc: "gtk_entry_get_max_length", dynlib: lib.}
proc get_text_length*(entry: PEntry): guint16 {.cdecl, 
    importc: "gtk_entry_get_text_length", dynlib: lib.}
proc set_activates_default*(entry: PEntry; setting: gboolean) {.
    cdecl, importc: "gtk_entry_set_activates_default", dynlib: lib.}
proc get_activates_default*(entry: PEntry): gboolean {.cdecl, 
    importc: "gtk_entry_get_activates_default", dynlib: lib.}
proc set_width_chars*(entry: PEntry; n_chars: gint) {.cdecl, 
    importc: "gtk_entry_set_width_chars", dynlib: lib.}
proc get_width_chars*(entry: PEntry): gint {.cdecl, 
    importc: "gtk_entry_get_width_chars", dynlib: lib.}
proc set_max_width_chars*(entry: PEntry; n_chars: gint) {.
    cdecl, importc: "gtk_entry_set_max_width_chars", dynlib: lib.}
proc get_max_width_chars*(entry: PEntry): gint {.cdecl, 
    importc: "gtk_entry_get_max_width_chars", dynlib: lib.}
proc set_text*(entry: PEntry; text: CSTRING) {.cdecl, 
    importc: "gtk_entry_set_text", dynlib: lib.}
proc get_text*(entry: PEntry): CSTRING {.cdecl, 
    importc: "gtk_entry_get_text", dynlib: lib.}
proc get_layout*(entry: PEntry): Playout {.cdecl, 
    importc: "gtk_entry_get_layout", dynlib: lib.}
proc get_layout_offsets*(entry: PEntry; x: Pgint; 
                                   y: Pgint) {.cdecl, 
    importc: "gtk_entry_get_layout_offsets", dynlib: lib.}
proc set_alignment*(entry: PEntry; xalign: gfloat) {.cdecl, 
    importc: "gtk_entry_set_alignment", dynlib: lib.}
proc get_alignment*(entry: PEntry): gfloat {.cdecl, 
    importc: "gtk_entry_get_alignment", dynlib: lib.}
proc set_completion*(entry: PEntry; 
                               completion: PEntryCompletion) {.cdecl, 
    importc: "gtk_entry_set_completion", dynlib: lib.}
proc get_completion*(entry: PEntry): PEntryCompletion {.
    cdecl, importc: "gtk_entry_get_completion", dynlib: lib.}
proc layout_index_to_text_index*(entry: PEntry; 
    layout_index: gint): gint {.cdecl, importc: "gtk_entry_layout_index_to_text_index", 
                                dynlib: lib.}
proc text_index_to_layout_index*(entry: PEntry; 
    text_index: gint): gint {.cdecl, importc: "gtk_entry_text_index_to_layout_index", 
                              dynlib: lib.}
proc set_cursor_hadjustment*(entry: PEntry; 
    adjustment: PAdjustment) {.cdecl, importc: "gtk_entry_set_cursor_hadjustment", 
                                     dynlib: lib.}
proc get_cursor_hadjustment*(entry: PEntry): PAdjustment {.
    cdecl, importc: "gtk_entry_get_cursor_hadjustment", dynlib: lib.}
proc set_progress_fraction*(entry: PEntry; fraction: gdouble) {.
    cdecl, importc: "gtk_entry_set_progress_fraction", dynlib: lib.}
proc get_progress_fraction*(entry: PEntry): gdouble {.cdecl, 
    importc: "gtk_entry_get_progress_fraction", dynlib: lib.}
proc set_progress_pulse_step*(entry: PEntry; fraction: gdouble) {.
    cdecl, importc: "gtk_entry_set_progress_pulse_step", dynlib: lib.}
proc get_progress_pulse_step*(entry: PEntry): gdouble {.cdecl, 
    importc: "gtk_entry_get_progress_pulse_step", dynlib: lib.}
proc progress_pulse*(entry: PEntry) {.cdecl, 
    importc: "gtk_entry_progress_pulse", dynlib: lib.}
proc get_placeholder_text*(entry: PEntry): CSTRING {.cdecl, 
    importc: "gtk_entry_get_placeholder_text", dynlib: lib.}
proc set_placeholder_text*(entry: PEntry; text: CSTRING) {.
    cdecl, importc: "gtk_entry_set_placeholder_text", dynlib: lib.}
proc set_icon_from_pixbuf*(entry: PEntry; 
                                     icon_pos: TEntryIconPosition; 
                                     pixbuf: PPixbuf) {.cdecl, 
    importc: "gtk_entry_set_icon_from_pixbuf", dynlib: lib.}
proc set_icon_from_stock*(entry: PEntry; 
                                    icon_pos: TEntryIconPosition; 
                                    stock_id: CSTRING) {.cdecl, 
    importc: "gtk_entry_set_icon_from_stock", dynlib: lib.}
proc set_icon_from_icon_name*(entry: PEntry; 
    icon_pos: TEntryIconPosition; icon_name: CSTRING) {.cdecl, 
    importc: "gtk_entry_set_icon_from_icon_name", dynlib: lib.}
proc set_icon_from_gicon*(entry: PEntry; 
                                    icon_pos: TEntryIconPosition; 
                                    icon: PGIcon) {.cdecl, 
    importc: "gtk_entry_set_icon_from_gicon", dynlib: lib.}
proc get_icon_storage_type*(entry: PEntry; 
                                      icon_pos: TEntryIconPosition): TImageType {.
    cdecl, importc: "gtk_entry_get_icon_storage_type", dynlib: lib.}
proc get_icon_pixbuf*(entry: PEntry; 
                                icon_pos: TEntryIconPosition): PPixbuf {.
    cdecl, importc: "gtk_entry_get_icon_pixbuf", dynlib: lib.}
proc get_icon_stock*(entry: PEntry; 
                               icon_pos: TEntryIconPosition): CSTRING {.
    cdecl, importc: "gtk_entry_get_icon_stock", dynlib: lib.}
proc get_icon_name*(entry: PEntry; 
                              icon_pos: TEntryIconPosition): CSTRING {.
    cdecl, importc: "gtk_entry_get_icon_name", dynlib: lib.}
proc get_icon_gicon*(entry: PEntry; 
                               icon_pos: TEntryIconPosition): PGIcon {.
    cdecl, importc: "gtk_entry_get_icon_gicon", dynlib: lib.}
proc set_icon_activatable*(entry: PEntry; 
                                     icon_pos: TEntryIconPosition; 
                                     activatable: gboolean) {.cdecl, 
    importc: "gtk_entry_set_icon_activatable", dynlib: lib.}
proc get_icon_activatable*(entry: PEntry; 
                                     icon_pos: TEntryIconPosition): gboolean {.
    cdecl, importc: "gtk_entry_get_icon_activatable", dynlib: lib.}
proc set_icon_sensitive*(entry: PEntry; 
                                   icon_pos: TEntryIconPosition; 
                                   sensitive: gboolean) {.cdecl, 
    importc: "gtk_entry_set_icon_sensitive", dynlib: lib.}
proc get_icon_sensitive*(entry: PEntry; 
                                   icon_pos: TEntryIconPosition): gboolean {.
    cdecl, importc: "gtk_entry_get_icon_sensitive", dynlib: lib.}
proc get_icon_at_pos*(entry: PEntry; x: gint; y: gint): gint {.
    cdecl, importc: "gtk_entry_get_icon_at_pos", dynlib: lib.}
proc set_icon_tooltip_text*(entry: PEntry; 
                                      icon_pos: TEntryIconPosition; 
                                      tooltip: CSTRING) {.cdecl, 
    importc: "gtk_entry_set_icon_tooltip_text", dynlib: lib.}
proc get_icon_tooltip_text*(entry: PEntry; 
                                      icon_pos: TEntryIconPosition): CSTRING {.
    cdecl, importc: "gtk_entry_get_icon_tooltip_text", dynlib: lib.}
proc set_icon_tooltip_markup*(entry: PEntry; 
    icon_pos: TEntryIconPosition; tooltip: CSTRING) {.cdecl, 
    importc: "gtk_entry_set_icon_tooltip_markup", dynlib: lib.}
proc get_icon_tooltip_markup*(entry: PEntry; 
    icon_pos: TEntryIconPosition): CSTRING {.cdecl, 
    importc: "gtk_entry_get_icon_tooltip_markup", dynlib: lib.}
proc set_icon_drag_source*(entry: PEntry; 
                                     icon_pos: TEntryIconPosition; 
                                     target_list: PTargetList; 
                                     actions: TDragAction) {.cdecl, 
    importc: "gtk_entry_set_icon_drag_source", dynlib: lib.}
proc get_current_icon_drag_source*(entry: PEntry): gint {.
    cdecl, importc: "gtk_entry_get_current_icon_drag_source", dynlib: lib.}
proc get_icon_area*(entry: PEntry; 
                              icon_pos: TEntryIconPosition; 
                              icon_area: gdk3.PRectangle) {.cdecl, 
    importc: "gtk_entry_get_icon_area", dynlib: lib.}
proc im_context_filter_keypress*(entry: PEntry; 
    event: PEventKey): gboolean {.cdecl, 
    importc: "gtk_entry_im_context_filter_keypress", dynlib: lib.}
proc reset_im_context*(entry: PEntry) {.cdecl, 
    importc: "gtk_entry_reset_im_context", dynlib: lib.}
proc set_input_purpose*(entry: PEntry; 
                                  purpose: TInputPurpose) {.cdecl, 
    importc: "gtk_entry_set_input_purpose", dynlib: lib.}
proc get_input_purpose*(entry: PEntry): TInputPurpose {.
    cdecl, importc: "gtk_entry_get_input_purpose", dynlib: lib.}
proc set_input_hints*(entry: PEntry; hints: TInputHints) {.
    cdecl, importc: "gtk_entry_set_input_hints", dynlib: lib.}
proc get_input_hints*(entry: PEntry): TInputHints {.cdecl, 
    importc: "gtk_entry_get_input_hints", dynlib: lib.}
proc set_attributes*(entry: PEntry; attrs: PAttrList) {.
    cdecl, importc: "gtk_entry_set_attributes", dynlib: lib.}
proc get_attributes*(entry: PEntry): PAttrList {.
    cdecl, importc: "gtk_entry_get_attributes", dynlib: lib.}
proc set_tabs*(entry: PEntry; tabs: PTabArray) {.
    cdecl, importc: "gtk_entry_set_tabs", dynlib: lib.}
proc get_tabs*(entry: PEntry): PTabArray {.cdecl, 
    importc: "gtk_entry_get_tabs", dynlib: lib.}

type 
  PTreeViewDropPosition* = ptr TTTreeViewDropPosition
  TTTreeViewDropPosition* {.size: sizeof(cint).} = enum 
    TREE_VIEW_DROP_BEFORE, TREE_VIEW_DROP_AFTER, 
    TREE_VIEW_DROP_INTO_OR_BEFORE, TREE_VIEW_DROP_INTO_OR_AFTER
template TYPE_TREE_VIEW*(): expr = 
  (gtk_tree_view_get_type())

template TREE_VIEW_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_VIEW, TTreeView))

template TREE_VIEW_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TREE_VIEW, TTreeViewClass))

template IS_TREE_VIEW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_VIEW))

template IS_TREE_VIEW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TREE_VIEW))

template TREE_VIEW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TREE_VIEW, TTreeViewClass))

type 
  PTreeView* = ptr TTreeView
  TTreeView* = object of TContainer
    priv38: PTreeViewPrivate

type 
  PTreeViewClass* = ptr TTreeViewClass
  TTreeViewClass* = object of TContainerClass
    row_activated*: proc (tree_view: PTreeView; path: PTreePath; 
                          column: PTreeViewColumn) {.cdecl.}
    test_expand_row*: proc (tree_view: PTreeView; iter: PTreeIter; 
                            path: PTreePath): gboolean {.cdecl.}
    test_collapse_row*: proc (tree_view: PTreeView; 
                              iter: PTreeIter; path: PTreePath): gboolean {.
        cdecl.}
    row_expanded*: proc (tree_view: PTreeView; iter: PTreeIter; 
                         path: PTreePath) {.cdecl.}
    row_collapsed*: proc (tree_view: PTreeView; iter: PTreeIter; 
                          path: PTreePath) {.cdecl.}
    columns_changed*: proc (tree_view: PTreeView) {.cdecl.}
    cursor_changed*: proc (tree_view: PTreeView) {.cdecl.}
    move_cursor*: proc (tree_view: PTreeView; step: TMovementStep; 
                        count: gint): gboolean {.cdecl.}
    select_all*: proc (tree_view: PTreeView): gboolean {.cdecl.}
    unselect_all*: proc (tree_view: PTreeView): gboolean {.cdecl.}
    select_cursor_row*: proc (tree_view: PTreeView; 
                              start_editing: gboolean): gboolean {.cdecl.}
    toggle_cursor_row*: proc (tree_view: PTreeView): gboolean {.cdecl.}
    expand_collapse_cursor_row*: proc (tree_view: PTreeView; 
        logical: gboolean; expand: gboolean; open_all: gboolean): gboolean {.
        cdecl.}
    select_cursor_parent*: proc (tree_view: PTreeView): gboolean {.cdecl.}
    start_interactive_search*: proc (tree_view: PTreeView): gboolean {.
        cdecl.}
    ugtk_reserved331: proc () {.cdecl.}
    ugtk_reserved332: proc () {.cdecl.}
    ugtk_reserved333: proc () {.cdecl.}
    ugtk_reserved334: proc () {.cdecl.}
    ugtk_reserved335: proc () {.cdecl.}
    ugtk_reserved336: proc () {.cdecl.}
    ugtk_reserved337: proc () {.cdecl.}
    ugtk_reserved338: proc () {.cdecl.}

type 
  TTreeViewColumnDropFunc* = proc (tree_view: PTreeView; 
                                     column: PTreeViewColumn; 
                                     prev_column: PTreeViewColumn; 
                                     next_column: PTreeViewColumn; 
                                     data: gpointer): gboolean {.cdecl.}
type 
  TTreeViewMappingFunc* = proc (tree_view: PTreeView; 
                                  path: PTreePath; user_data: gpointer) {.
      cdecl.}
type 
  TTreeViewSearchEqualFunc* = proc (model: PTreeModel; column: gint; 
                                      key: CSTRING; iter: PTreeIter; 
                                      search_data: gpointer): gboolean {.cdecl.}
type 
  TTreeViewRowSeparatorFunc* = proc (model: PTreeModel; 
      iter: PTreeIter; data: gpointer): gboolean {.cdecl.}
  TTreeViewSearchPositionFunc* = proc (tree_view: PTreeView; 
      search_dialog: PWidget; user_data: gpointer) {.cdecl.}
type 
  PTreeSelection* = ptr TTreeSelection
  TTreeSelection* = object of TGObject
    priv39: PTreeSelectionPrivate

type 
  PTreeSelectionClass* = ptr TTreeSelectionClass
  TTreeSelectionClass* = object of TGObjectClass
    changed*: proc (selection: PTreeSelection) {.cdecl.}
    ugtk_reserved341: proc () {.cdecl.}
    ugtk_reserved342: proc () {.cdecl.}
    ugtk_reserved343: proc () {.cdecl.}
    ugtk_reserved344: proc () {.cdecl.}

proc tree_view_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_view_get_type", dynlib: lib.}
proc tree_view_new*(): PWidget {.cdecl, 
    importc: "gtk_tree_view_new", dynlib: lib.}
proc tree_view_new_with_model*(model: PTreeModel): PWidget {.
    cdecl, importc: "gtk_tree_view_new_with_model", dynlib: lib.}
proc get_model*(tree_view: PTreeView): PTreeModel {.
    cdecl, importc: "gtk_tree_view_get_model", dynlib: lib.}
proc set_model*(tree_view: PTreeView; 
                              model: PTreeModel) {.cdecl, 
    importc: "gtk_tree_view_set_model", dynlib: lib.}
proc get_selection*(tree_view: PTreeView): PTreeSelection {.
    cdecl, importc: "gtk_tree_view_get_selection", dynlib: lib.}
proc get_hadjustment*(tree_view: PTreeView): PAdjustment {.
    cdecl, importc: "gtk_tree_view_get_hadjustment", dynlib: lib.}
proc set_hadjustment*(tree_view: PTreeView; 
                                    adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_tree_view_set_hadjustment", dynlib: lib.}
proc get_vadjustment*(tree_view: PTreeView): PAdjustment {.
    cdecl, importc: "gtk_tree_view_get_vadjustment", dynlib: lib.}
proc set_vadjustment*(tree_view: PTreeView; 
                                    adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_tree_view_set_vadjustment", dynlib: lib.}
proc get_headers_visible*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_headers_visible", dynlib: lib.}
proc set_headers_visible*(tree_view: PTreeView; 
    headers_visible: gboolean) {.cdecl, importc: "gtk_tree_view_set_headers_visible", 
                                 dynlib: lib.}
proc columns_autosize*(tree_view: PTreeView) {.cdecl, 
    importc: "gtk_tree_view_columns_autosize", dynlib: lib.}
proc get_headers_clickable*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_headers_clickable", dynlib: lib.}
proc set_headers_clickable*(tree_view: PTreeView; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_tree_view_set_headers_clickable", 
                         dynlib: lib.}
proc set_rules_hint*(tree_view: PTreeView; 
                                   setting: gboolean) {.cdecl, 
    importc: "gtk_tree_view_set_rules_hint", dynlib: lib.}
proc get_rules_hint*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_rules_hint", dynlib: lib.}
proc get_activate_on_single_click*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_activate_on_single_click", dynlib: lib.}
proc set_activate_on_single_click*(tree_view: PTreeView; 
    single: gboolean) {.cdecl, importc: "gtk_tree_view_set_activate_on_single_click", 
                        dynlib: lib.}
proc append_column*(tree_view: PTreeView; 
                                  column: PTreeViewColumn): gint {.
    cdecl, importc: "gtk_tree_view_append_column", dynlib: lib.}
proc remove_column*(tree_view: PTreeView; 
                                  column: PTreeViewColumn): gint {.
    cdecl, importc: "gtk_tree_view_remove_column", dynlib: lib.}
proc insert_column*(tree_view: PTreeView; 
                                  column: PTreeViewColumn; 
                                  position: gint): gint {.cdecl, 
    importc: "gtk_tree_view_insert_column", dynlib: lib.}
proc insert_column_with_attributes*(tree_view: PTreeView; 
    position: gint; title: CSTRING; cell: PCellRenderer): gint {.
    varargs, cdecl, importc: "gtk_tree_view_insert_column_with_attributes", 
    dynlib: lib.}
proc insert_column_with_data_func*(tree_view: PTreeView; 
    position: gint; title: CSTRING; cell: PCellRenderer; 
    func: TTreeCellDataFunc; data: gpointer; dnotify: TGDestroyNotify): gint {.
    cdecl, importc: "gtk_tree_view_insert_column_with_data_func", dynlib: lib.}
proc get_n_columns*(tree_view: PTreeView): guint {.cdecl, 
    importc: "gtk_tree_view_get_n_columns", dynlib: lib.}
proc get_column*(tree_view: PTreeView; n: gint): PTreeViewColumn {.
    cdecl, importc: "gtk_tree_view_get_column", dynlib: lib.}
proc get_columns*(tree_view: PTreeView): PGList {.
    cdecl, importc: "gtk_tree_view_get_columns", dynlib: lib.}
proc move_column_after*(tree_view: PTreeView; 
                                      column: PTreeViewColumn; 
                                      base_column: PTreeViewColumn) {.
    cdecl, importc: "gtk_tree_view_move_column_after", dynlib: lib.}
proc set_expander_column*(tree_view: PTreeView; 
    column: PTreeViewColumn) {.cdecl, importc: "gtk_tree_view_set_expander_column", 
                                     dynlib: lib.}
proc get_expander_column*(tree_view: PTreeView): PTreeViewColumn {.
    cdecl, importc: "gtk_tree_view_get_expander_column", dynlib: lib.}
proc set_column_drag_function*(tree_view: PTreeView; 
    func: TTreeViewColumnDropFunc; user_data: gpointer; 
    destroy: TGDestroyNotify) {.cdecl, importc: "gtk_tree_view_set_column_drag_function", 
                               dynlib: lib.}
proc scroll_to_point*(tree_view: PTreeView; tree_x: gint; 
                                    tree_y: gint) {.cdecl, 
    importc: "gtk_tree_view_scroll_to_point", dynlib: lib.}
proc scroll_to_cell*(tree_view: PTreeView; 
                                   path: PTreePath; 
                                   column: PTreeViewColumn; 
                                   use_align: gboolean; row_align: gfloat; 
                                   col_align: gfloat) {.cdecl, 
    importc: "gtk_tree_view_scroll_to_cell", dynlib: lib.}
proc row_activated*(tree_view: PTreeView; 
                                  path: PTreePath; 
                                  column: PTreeViewColumn) {.cdecl, 
    importc: "gtk_tree_view_row_activated", dynlib: lib.}
proc expand_all*(tree_view: PTreeView) {.cdecl, 
    importc: "gtk_tree_view_expand_all", dynlib: lib.}
proc collapse_all*(tree_view: PTreeView) {.cdecl, 
    importc: "gtk_tree_view_collapse_all", dynlib: lib.}
proc expand_to_path*(tree_view: PTreeView; 
                                   path: PTreePath) {.cdecl, 
    importc: "gtk_tree_view_expand_to_path", dynlib: lib.}
proc expand_row*(tree_view: PTreeView; 
                               path: PTreePath; open_all: gboolean): gboolean {.
    cdecl, importc: "gtk_tree_view_expand_row", dynlib: lib.}
proc collapse_row*(tree_view: PTreeView; 
                                 path: PTreePath): gboolean {.cdecl, 
    importc: "gtk_tree_view_collapse_row", dynlib: lib.}
proc map_expanded_rows*(tree_view: PTreeView; 
                                      func: TTreeViewMappingFunc; 
                                      data: gpointer) {.cdecl, 
    importc: "gtk_tree_view_map_expanded_rows", dynlib: lib.}
proc row_expanded*(tree_view: PTreeView; 
                                 path: PTreePath): gboolean {.cdecl, 
    importc: "gtk_tree_view_row_expanded", dynlib: lib.}
proc set_reorderable*(tree_view: PTreeView; 
                                    reorderable: gboolean) {.cdecl, 
    importc: "gtk_tree_view_set_reorderable", dynlib: lib.}
proc get_reorderable*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_reorderable", dynlib: lib.}
proc set_cursor*(tree_view: PTreeView; 
                               path: PTreePath; 
                               focus_column: PTreeViewColumn; 
                               start_editing: gboolean) {.cdecl, 
    importc: "gtk_tree_view_set_cursor", dynlib: lib.}
proc set_cursor_on_cell*(tree_view: PTreeView; 
    path: PTreePath; focus_column: PTreeViewColumn; 
    focus_cell: PCellRenderer; start_editing: gboolean) {.cdecl, 
    importc: "gtk_tree_view_set_cursor_on_cell", dynlib: lib.}
proc get_cursor*(tree_view: PTreeView; 
                               path: ptr PTreePath; 
                               focus_column: ptr PTreeViewColumn) {.
    cdecl, importc: "gtk_tree_view_get_cursor", dynlib: lib.}
proc get_bin_window*(tree_view: PTreeView): PGdkWindow {.
    cdecl, importc: "gtk_tree_view_get_bin_window", dynlib: lib.}
proc get_path_at_pos*(tree_view: PTreeView; x: gint; 
                                    y: gint; path: ptr PTreePath; 
                                    column: ptr PTreeViewColumn; 
                                    cell_x: Pgint; cell_y: Pgint): gboolean {.
    cdecl, importc: "gtk_tree_view_get_path_at_pos", dynlib: lib.}
proc get_cell_area*(tree_view: PTreeView; 
                                  path: PTreePath; 
                                  column: PTreeViewColumn; 
                                  rect: gdk3.PRectangle) {.cdecl, 
    importc: "gtk_tree_view_get_cell_area", dynlib: lib.}
proc get_background_area*(tree_view: PTreeView; 
    path: PTreePath; column: PTreeViewColumn; 
    rect: gdk3.PRectangle) {.cdecl, 
                              importc: "gtk_tree_view_get_background_area", 
                              dynlib: lib.}
proc get_visible_rect*(tree_view: PTreeView; 
                                     visible_rect: gdk3.PRectangle) {.cdecl, 
    importc: "gtk_tree_view_get_visible_rect", dynlib: lib.}
proc get_visible_range*(tree_view: PTreeView; 
                                      start_path: ptr PTreePath; 
                                      end_path: ptr PTreePath): gboolean {.
    cdecl, importc: "gtk_tree_view_get_visible_range", dynlib: lib.}
proc is_blank_at_pos*(tree_view: PTreeView; x: gint; 
                                    y: gint; path: ptr PTreePath; 
                                    column: ptr PTreeViewColumn; 
                                    cell_x: Pgint; cell_y: Pgint): gboolean {.
    cdecl, importc: "gtk_tree_view_is_blank_at_pos", dynlib: lib.}
proc enable_model_drag_source*(tree_view: PTreeView; 
    start_button_mask: gdk3.TModifierType; targets: PTargetEntry; 
    n_targets: gint; actions: TDragAction) {.cdecl, 
    importc: "gtk_tree_view_enable_model_drag_source", dynlib: lib.}
proc enable_model_drag_dest*(tree_view: PTreeView; 
    targets: PTargetEntry; n_targets: gint; actions: TDragAction) {.
    cdecl, importc: "gtk_tree_view_enable_model_drag_dest", dynlib: lib.}
proc unset_rows_drag_source*(tree_view: PTreeView) {.
    cdecl, importc: "gtk_tree_view_unset_rows_drag_source", dynlib: lib.}
proc unset_rows_drag_dest*(tree_view: PTreeView) {.cdecl, 
    importc: "gtk_tree_view_unset_rows_drag_dest", dynlib: lib.}
proc set_drag_dest_row*(tree_view: PTreeView; 
                                      path: PTreePath; 
                                      pos: TTTreeViewDropPosition) {.cdecl, 
    importc: "gtk_tree_view_set_drag_dest_row", dynlib: lib.}
proc get_drag_dest_row*(tree_view: PTreeView; 
                                      path: ptr PTreePath; 
                                      pos: PTreeViewDropPosition) {.
    cdecl, importc: "gtk_tree_view_get_drag_dest_row", dynlib: lib.}
proc get_dest_row_at_pos*(tree_view: PTreeView; 
    drag_x: gint; drag_y: gint; path: ptr PTreePath; 
    pos: PTreeViewDropPosition): gboolean {.cdecl, 
    importc: "gtk_tree_view_get_dest_row_at_pos", dynlib: lib.}
proc create_row_drag_icon*(tree_view: PTreeView; 
    path: PTreePath): Psurface {.cdecl, 
    importc: "gtk_tree_view_create_row_drag_icon", dynlib: lib.}
proc set_enable_search*(tree_view: PTreeView; 
                                      enable_search: gboolean) {.cdecl, 
    importc: "gtk_tree_view_set_enable_search", dynlib: lib.}
proc get_enable_search*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_enable_search", dynlib: lib.}
proc get_search_column*(tree_view: PTreeView): gint {.
    cdecl, importc: "gtk_tree_view_get_search_column", dynlib: lib.}
proc set_search_column*(tree_view: PTreeView; column: gint) {.
    cdecl, importc: "gtk_tree_view_set_search_column", dynlib: lib.}
proc get_search_equal_func*(tree_view: PTreeView): TTreeViewSearchEqualFunc {.
    cdecl, importc: "gtk_tree_view_get_search_equal_func", dynlib: lib.}
proc set_search_equal_func*(tree_view: PTreeView; 
    search_equal_func: TTreeViewSearchEqualFunc; search_user_data: gpointer; 
    search_destroy: TGDestroyNotify) {.cdecl, importc: "gtk_tree_view_set_search_equal_func", 
                                      dynlib: lib.}
proc get_search_entry*(tree_view: PTreeView): PEntry {.
    cdecl, importc: "gtk_tree_view_get_search_entry", dynlib: lib.}
proc set_search_entry*(tree_view: PTreeView; 
                                     entry: PEntry) {.cdecl, 
    importc: "gtk_tree_view_set_search_entry", dynlib: lib.}
proc get_search_position_func*(tree_view: PTreeView): TTreeViewSearchPositionFunc {.
    cdecl, importc: "gtk_tree_view_get_search_position_func", dynlib: lib.}
proc set_search_position_func*(tree_view: PTreeView; 
    func: TTreeViewSearchPositionFunc; data: gpointer; 
    destroy: TGDestroyNotify) {.cdecl, importc: "gtk_tree_view_set_search_position_func", 
                               dynlib: lib.}
proc convert_widget_to_tree_coords*(tree_view: PTreeView; 
    wx: gint; wy: gint; tx: Pgint; ty: Pgint) {.cdecl, 
    importc: "gtk_tree_view_convert_widget_to_tree_coords", dynlib: lib.}
proc convert_tree_to_widget_coords*(tree_view: PTreeView; 
    tx: gint; ty: gint; wx: Pgint; wy: Pgint) {.cdecl, 
    importc: "gtk_tree_view_convert_tree_to_widget_coords", dynlib: lib.}
proc convert_widget_to_bin_window_coords*(
    tree_view: PTreeView; wx: gint; wy: gint; bx: Pgint; by: Pgint) {.
    cdecl, importc: "gtk_tree_view_convert_widget_to_bin_window_coords", 
    dynlib: lib.}
proc convert_bin_window_to_widget_coords*(
    tree_view: PTreeView; bx: gint; by: gint; wx: Pgint; wy: Pgint) {.
    cdecl, importc: "gtk_tree_view_convert_bin_window_to_widget_coords", 
    dynlib: lib.}
proc convert_tree_to_bin_window_coords*(
    tree_view: PTreeView; tx: gint; ty: gint; bx: Pgint; by: Pgint) {.
    cdecl, importc: "gtk_tree_view_convert_tree_to_bin_window_coords", 
    dynlib: lib.}
proc convert_bin_window_to_tree_coords*(
    tree_view: PTreeView; bx: gint; by: gint; tx: Pgint; ty: Pgint) {.
    cdecl, importc: "gtk_tree_view_convert_bin_window_to_tree_coords", 
    dynlib: lib.}
type 
  TTreeDestroyCountFunc* = proc (tree_view: PTreeView; 
                                   path: PTreePath; children: gint; 
                                   user_data: gpointer) {.cdecl.}
proc set_destroy_count_func*(tree_view: PTreeView; 
    func: TTreeDestroyCountFunc; data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_tree_view_set_destroy_count_func", dynlib: lib.}
proc set_fixed_height_mode*(tree_view: PTreeView; 
    enable: gboolean) {.cdecl, importc: "gtk_tree_view_set_fixed_height_mode", 
                        dynlib: lib.}
proc get_fixed_height_mode*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_fixed_height_mode", dynlib: lib.}
proc set_hover_selection*(tree_view: PTreeView; 
    hover: gboolean) {.cdecl, importc: "gtk_tree_view_set_hover_selection", 
                       dynlib: lib.}
proc get_hover_selection*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_hover_selection", dynlib: lib.}
proc set_hover_expand*(tree_view: PTreeView; 
                                     expand: gboolean) {.cdecl, 
    importc: "gtk_tree_view_set_hover_expand", dynlib: lib.}
proc get_hover_expand*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_hover_expand", dynlib: lib.}
proc set_rubber_banding*(tree_view: PTreeView; 
    enable: gboolean) {.cdecl, importc: "gtk_tree_view_set_rubber_banding", 
                        dynlib: lib.}
proc get_rubber_banding*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_rubber_banding", dynlib: lib.}
proc is_rubber_banding_active*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_is_rubber_banding_active", dynlib: lib.}
proc get_row_separator_func*(tree_view: PTreeView): TTreeViewRowSeparatorFunc {.
    cdecl, importc: "gtk_tree_view_get_row_separator_func", dynlib: lib.}
proc set_row_separator_func*(tree_view: PTreeView; 
    func: TTreeViewRowSeparatorFunc; data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_tree_view_set_row_separator_func", dynlib: lib.}
proc get_grid_lines*(tree_view: PTreeView): TTreeViewGridLines {.
    cdecl, importc: "gtk_tree_view_get_grid_lines", dynlib: lib.}
proc set_grid_lines*(tree_view: PTreeView; 
                                   grid_lines: TTreeViewGridLines) {.cdecl, 
    importc: "gtk_tree_view_set_grid_lines", dynlib: lib.}
proc get_enable_tree_lines*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_enable_tree_lines", dynlib: lib.}
proc set_enable_tree_lines*(tree_view: PTreeView; 
    enabled: gboolean) {.cdecl, 
                         importc: "gtk_tree_view_set_enable_tree_lines", 
                         dynlib: lib.}
proc set_show_expanders*(tree_view: PTreeView; 
    enabled: gboolean) {.cdecl, importc: "gtk_tree_view_set_show_expanders", 
                         dynlib: lib.}
proc get_show_expanders*(tree_view: PTreeView): gboolean {.
    cdecl, importc: "gtk_tree_view_get_show_expanders", dynlib: lib.}
proc set_level_indentation*(tree_view: PTreeView; 
    indentation: gint) {.cdecl, 
                         importc: "gtk_tree_view_set_level_indentation", 
                         dynlib: lib.}
proc get_level_indentation*(tree_view: PTreeView): gint {.
    cdecl, importc: "gtk_tree_view_get_level_indentation", dynlib: lib.}
proc set_tooltip_row*(tree_view: PTreeView; 
                                    tooltip: PTooltip; 
                                    path: PTreePath) {.cdecl, 
    importc: "gtk_tree_view_set_tooltip_row", dynlib: lib.}
proc set_tooltip_cell*(tree_view: PTreeView; 
                                     tooltip: PTooltip; 
                                     path: PTreePath; 
                                     column: PTreeViewColumn; 
                                     cell: PCellRenderer) {.cdecl, 
    importc: "gtk_tree_view_set_tooltip_cell", dynlib: lib.}
proc get_tooltip_context*(tree_view: PTreeView; 
    x: Pgint; y: Pgint; keyboard_tip: gboolean; 
    model: ptr PTreeModel; path: ptr PTreePath; 
    iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_view_get_tooltip_context", dynlib: lib.}
proc set_tooltip_column*(tree_view: PTreeView; 
    column: gint) {.cdecl, importc: "gtk_tree_view_set_tooltip_column", 
                    dynlib: lib.}
proc get_tooltip_column*(tree_view: PTreeView): gint {.
    cdecl, importc: "gtk_tree_view_get_tooltip_column", dynlib: lib.}

template TYPE_COMBO_BOX*(): expr = 
  (gtk_combo_box_get_type())

template COMBO_BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_COMBO_BOX, TComboBox))

template COMBO_BOX_CLASS_TEMPLATE*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((vtable), TYPE_COMBO_BOX, TComboBoxClass))

template IS_COMBO_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_COMBO_BOX))

template IS_COMBO_BOX_CLASS*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((vtable), TYPE_COMBO_BOX))

template COMBO_BOX_GET_CLASS*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((inst), TYPE_COMBO_BOX, TComboBoxClass))

type 
  PComboBox* = ptr TComboBox
  TComboBox* = object of TBin
    priv40: PComboBoxPrivate

type 
  PComboBoxClass* = ptr TComboBoxClass
  TComboBoxClass* = object of TBinClass
    changed*: proc (combo_box: PComboBox) {.cdecl.}
    format_entry_text*: proc (combo_box: PComboBox; path: CSTRING): CSTRING {.
        cdecl.}
    ugtk_reserved351: proc () {.cdecl.}
    ugtk_reserved352: proc () {.cdecl.}
    ugtk_reserved353: proc () {.cdecl.}

proc combo_box_get_type*(): GType {.cdecl, 
    importc: "gtk_combo_box_get_type", dynlib: lib.}
proc combo_box_new*(): PWidget {.cdecl, 
    importc: "gtk_combo_box_new", dynlib: lib.}
proc combo_box_new_with_area*(area: PCellArea): PWidget {.
    cdecl, importc: "gtk_combo_box_new_with_area", dynlib: lib.}
proc combo_box_new_with_area_and_entry*(area: PCellArea): PWidget {.
    cdecl, importc: "gtk_combo_box_new_with_area_and_entry", dynlib: lib.}
proc combo_box_new_with_entry*(): PWidget {.cdecl, 
    importc: "gtk_combo_box_new_with_entry", dynlib: lib.}
proc combo_box_new_with_model*(model: PTreeModel): PWidget {.
    cdecl, importc: "gtk_combo_box_new_with_model", dynlib: lib.}
proc combo_box_new_with_model_and_entry*(model: PTreeModel): PWidget {.
    cdecl, importc: "gtk_combo_box_new_with_model_and_entry", dynlib: lib.}
proc get_wrap_width*(combo_box: PComboBox): gint {.cdecl, 
    importc: "gtk_combo_box_get_wrap_width", dynlib: lib.}
proc set_wrap_width*(combo_box: PComboBox; width: gint) {.
    cdecl, importc: "gtk_combo_box_set_wrap_width", dynlib: lib.}
proc get_row_span_column*(combo_box: PComboBox): gint {.
    cdecl, importc: "gtk_combo_box_get_row_span_column", dynlib: lib.}
proc set_row_span_column*(combo_box: PComboBox; 
    row_span: gint) {.cdecl, importc: "gtk_combo_box_set_row_span_column", 
                      dynlib: lib.}
proc get_column_span_column*(combo_box: PComboBox): gint {.
    cdecl, importc: "gtk_combo_box_get_column_span_column", dynlib: lib.}
proc set_column_span_column*(combo_box: PComboBox; 
    column_span: gint) {.cdecl, 
                         importc: "gtk_combo_box_set_column_span_column", 
                         dynlib: lib.}
proc get_add_tearoffs*(combo_box: PComboBox): gboolean {.
    cdecl, importc: "gtk_combo_box_get_add_tearoffs", dynlib: lib.}
proc set_add_tearoffs*(combo_box: PComboBox; 
                                     add_tearoffs: gboolean) {.cdecl, 
    importc: "gtk_combo_box_set_add_tearoffs", dynlib: lib.}
proc get_title*(combo_box: PComboBox): CSTRING {.cdecl, 
    importc: "gtk_combo_box_get_title", dynlib: lib.}
proc set_title*(combo_box: PComboBox; title: CSTRING) {.
    cdecl, importc: "gtk_combo_box_set_title", dynlib: lib.}
proc get_focus_on_click*(combo: PComboBox): gboolean {.
    cdecl, importc: "gtk_combo_box_get_focus_on_click", dynlib: lib.}
proc set_focus_on_click*(combo: PComboBox; 
    focus_on_click: gboolean) {.cdecl, 
                                importc: "gtk_combo_box_set_focus_on_click", 
                                dynlib: lib.}
proc get_active*(combo_box: PComboBox): gint {.cdecl, 
    importc: "gtk_combo_box_get_active", dynlib: lib.}
proc set_active*(combo_box: PComboBox; index: gint) {.
    cdecl, importc: "gtk_combo_box_set_active", dynlib: lib.}
proc get_active_iter*(combo_box: PComboBox; 
                                    iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_combo_box_get_active_iter", dynlib: lib.}
proc set_active_iter*(combo_box: PComboBox; 
                                    iter: PTreeIter) {.cdecl, 
    importc: "gtk_combo_box_set_active_iter", dynlib: lib.}
proc set_model*(combo_box: PComboBox; 
                              model: PTreeModel) {.cdecl, 
    importc: "gtk_combo_box_set_model", dynlib: lib.}
proc get_model*(combo_box: PComboBox): PTreeModel {.
    cdecl, importc: "gtk_combo_box_get_model", dynlib: lib.}
proc get_row_separator_func*(combo_box: PComboBox): TTreeViewRowSeparatorFunc {.
    cdecl, importc: "gtk_combo_box_get_row_separator_func", dynlib: lib.}
proc set_row_separator_func*(combo_box: PComboBox; 
    func: TTreeViewRowSeparatorFunc; data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_combo_box_set_row_separator_func", dynlib: lib.}
proc set_button_sensitivity*(combo_box: PComboBox; 
    sensitivity: TSensitivityType) {.cdecl, 
    importc: "gtk_combo_box_set_button_sensitivity", dynlib: lib.}
proc get_button_sensitivity*(combo_box: PComboBox): TSensitivityType {.
    cdecl, importc: "gtk_combo_box_get_button_sensitivity", dynlib: lib.}
proc get_has_entry*(combo_box: PComboBox): gboolean {.
    cdecl, importc: "gtk_combo_box_get_has_entry", dynlib: lib.}
proc set_entry_text_column*(combo_box: PComboBox; 
    text_column: gint) {.cdecl, 
                         importc: "gtk_combo_box_set_entry_text_column", 
                         dynlib: lib.}
proc get_entry_text_column*(combo_box: PComboBox): gint {.
    cdecl, importc: "gtk_combo_box_get_entry_text_column", dynlib: lib.}
proc set_popup_fixed_width*(combo_box: PComboBox; 
    fixed: gboolean) {.cdecl, importc: "gtk_combo_box_set_popup_fixed_width", 
                       dynlib: lib.}
proc get_popup_fixed_width*(combo_box: PComboBox): gboolean {.
    cdecl, importc: "gtk_combo_box_get_popup_fixed_width", dynlib: lib.}
proc popup*(combo_box: PComboBox) {.cdecl, 
    importc: "gtk_combo_box_popup", dynlib: lib.}
proc popup_for_device*(combo_box: PComboBox; 
                                     device: PDevice) {.cdecl, 
    importc: "gtk_combo_box_popup_for_device", dynlib: lib.}
proc popdown*(combo_box: PComboBox) {.cdecl, 
    importc: "gtk_combo_box_popdown", dynlib: lib.}
proc get_popup_accessible*(combo_box: PComboBox): atk.PObject {.
    cdecl, importc: "gtk_combo_box_get_popup_accessible", dynlib: lib.}
proc get_id_column*(combo_box: PComboBox): gint {.cdecl, 
    importc: "gtk_combo_box_get_id_column", dynlib: lib.}
proc set_id_column*(combo_box: PComboBox; id_column: gint) {.
    cdecl, importc: "gtk_combo_box_set_id_column", dynlib: lib.}
proc get_active_id*(combo_box: PComboBox): CSTRING {.
    cdecl, importc: "gtk_combo_box_get_active_id", dynlib: lib.}
proc set_active_id*(combo_box: PComboBox; 
                                  active_id: CSTRING): gboolean {.cdecl, 
    importc: "gtk_combo_box_set_active_id", dynlib: lib.}

template TYPE_APP_CHOOSER_BUTTON*(): expr = 
  (gtk_app_chooser_button_get_type())

template APP_CHOOSER_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_APP_CHOOSER_BUTTON, 
                              TAppChooserButton))

template APP_CHOOSER_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_APP_CHOOSER_BUTTON, 
                           TAppChooserButtonClass))

template IS_APP_CHOOSER_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_APP_CHOOSER_BUTTON))

template IS_APP_CHOOSER_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_APP_CHOOSER_BUTTON))

template APP_CHOOSER_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_APP_CHOOSER_BUTTON, 
                             TAppChooserButtonClass))

type 
  PAppChooserButton* = ptr TAppChooserButton
  TAppChooserButton* = object of TComboBox
    priv41: PAppChooserButtonPrivate

type 
  PAppChooserButtonClass* = ptr TAppChooserButtonClass
  TAppChooserButtonClass* = object of TComboBoxClass
    custom_item_activated*: proc (self: PAppChooserButton; 
                                  item_name: CSTRING) {.cdecl.}
    padding*: array[16, gpointer]

proc app_chooser_button_get_type*(): GType {.cdecl, 
    importc: "gtk_app_chooser_button_get_type", dynlib: lib.}
proc app_chooser_button_new*(content_type: CSTRING): PWidget {.
    cdecl, importc: "gtk_app_chooser_button_new", dynlib: lib.}
proc append_separator*(self: PAppChooserButton) {.
    cdecl, importc: "gtk_app_chooser_button_append_separator", dynlib: lib.}
proc append_custom_item*(self: PAppChooserButton; 
    name: CSTRING; label: CSTRING; icon: PGIcon) {.cdecl, 
    importc: "gtk_app_chooser_button_append_custom_item", dynlib: lib.}
proc set_active_custom_item*(
    self: PAppChooserButton; name: CSTRING) {.cdecl, 
    importc: "gtk_app_chooser_button_set_active_custom_item", dynlib: lib.}
proc set_show_dialog_item*(
    self: PAppChooserButton; setting: gboolean) {.cdecl, 
    importc: "gtk_app_chooser_button_set_show_dialog_item", dynlib: lib.}
proc get_show_dialog_item*(
    self: PAppChooserButton): gboolean {.cdecl, 
    importc: "gtk_app_chooser_button_get_show_dialog_item", dynlib: lib.}
proc set_heading*(self: PAppChooserButton; 
    heading: CSTRING) {.cdecl, 
                          importc: "gtk_app_chooser_button_set_heading", 
                          dynlib: lib.}
proc get_heading*(self: PAppChooserButton): CSTRING {.
    cdecl, importc: "gtk_app_chooser_button_get_heading", dynlib: lib.}
proc set_show_default_item*(
    self: PAppChooserButton; setting: gboolean) {.cdecl, 
    importc: "gtk_app_chooser_button_set_show_default_item", dynlib: lib.}
proc get_show_default_item*(
    self: PAppChooserButton): gboolean {.cdecl, 
    importc: "gtk_app_chooser_button_get_show_default_item", dynlib: lib.}

template TYPE_APPLICATION_WINDOW*(): expr = 
  (gtk_application_window_get_type())

template APPLICATION_WINDOW*(inst: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((inst), TYPE_APPLICATION_WINDOW, 
                              TApplicationWindow))

template APPLICATION_WINDOW_CLASS*(class: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((class), TYPE_APPLICATION_WINDOW, 
                           TApplicationWindowClass))

template IS_APPLICATION_WINDOW*(inst: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((inst), TYPE_APPLICATION_WINDOW))

template IS_APPLICATION_WINDOW_CLASS*(class: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((class), TYPE_APPLICATION_WINDOW))

template APPLICATION_WINDOW_GET_CLASS*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((inst), TYPE_APPLICATION_WINDOW, 
                             TApplicationWindowClass))

type 
  PApplicationWindow* = ptr TApplicationWindow
  TApplicationWindow* = object of TWindow
    priv42: PApplicationWindowPrivate

type 
  PApplicationWindowClass* = ptr TApplicationWindowClass
  TApplicationWindowClass* = object of TWindowClass
    padding*: array[14, gpointer]

proc application_window_get_type*(): GType {.cdecl, 
    importc: "gtk_application_window_get_type", dynlib: lib.}
proc window_new*(application: PApplication): PWidget {.
    cdecl, importc: "gtk_application_window_new", dynlib: lib.}
proc set_show_menubar*(
    window: PApplicationWindow; show_menubar: gboolean) {.cdecl, 
    importc: "gtk_application_window_set_show_menubar", dynlib: lib.}
proc get_show_menubar*(window: PApplicationWindow): gboolean {.
    cdecl, importc: "gtk_application_window_get_show_menubar", dynlib: lib.}
proc get_id*(window: PApplicationWindow): guint {.
    cdecl, importc: "gtk_application_window_get_id", dynlib: lib.}

template TYPE_ARROW*(): expr = 
  (gtk_arrow_get_type())

template ARROW_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ARROW, TArrow))

template ARROW_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ARROW, TArrowClass))

template IS_ARROW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ARROW))

template IS_ARROW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ARROW))

template ARROW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ARROW, TArrowClass))

type 
  PArrow* = ptr TArrow
  TArrow* = object of TMisc
    priv43: PArrowPrivate

type 
  PArrowClass* = ptr TArrowClass
  TArrowClass* = object of TMiscClass
    ugtk_reserved361: proc () {.cdecl.}
    ugtk_reserved362: proc () {.cdecl.}
    ugtk_reserved363: proc () {.cdecl.}
    ugtk_reserved364: proc () {.cdecl.}

proc arrow_get_type*(): GType {.cdecl, importc: "gtk_arrow_get_type", 
                                    dynlib: lib.}
proc arrow_new*(arrow_type: TArrowType; shadow_type: TShadowType): PWidget {.
    cdecl, importc: "gtk_arrow_new", dynlib: lib.}
proc set*(arrow: PArrow; arrow_type: TArrowType; 
                    shadow_type: TShadowType) {.cdecl, 
    importc: "gtk_arrow_set", dynlib: lib.}

template TYPE_FRAME*(): expr = 
  (gtk_frame_get_type())

template FRAME_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FRAME, TFrame))

template FRAME_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FRAME, TFrameClass))

template IS_FRAME*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FRAME))

template IS_FRAME_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FRAME))

template FRAME_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FRAME, TFrameClass))

type 
  PFrame* = ptr TFrame
  TFrame* = object of TBin
    priv44: PFramePrivate

type 
  PFrameClass* = ptr TFrameClass
  TFrameClass* = object of TBinClass
    compute_child_allocation*: proc (frame: PFrame; 
                                     allocation: PAllocation) {.cdecl.}
    ugtk_reserved371: proc () {.cdecl.}
    ugtk_reserved372: proc () {.cdecl.}
    ugtk_reserved373: proc () {.cdecl.}
    ugtk_reserved374: proc () {.cdecl.}

proc frame_get_type*(): GType {.cdecl, importc: "gtk_frame_get_type", 
                                    dynlib: lib.}
proc frame_new*(label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_frame_new", dynlib: lib.}
proc set_label*(frame: PFrame; label: CSTRING) {.cdecl, 
    importc: "gtk_frame_set_label", dynlib: lib.}
proc get_label*(frame: PFrame): CSTRING {.cdecl, 
    importc: "gtk_frame_get_label", dynlib: lib.}
proc set_label_widget*(frame: PFrame; 
                                 label_widget: PWidget) {.cdecl, 
    importc: "gtk_frame_set_label_widget", dynlib: lib.}
proc get_label_widget*(frame: PFrame): PWidget {.cdecl, 
    importc: "gtk_frame_get_label_widget", dynlib: lib.}
proc set_label_align*(frame: PFrame; xalign: gfloat; 
                                yalign: gfloat) {.cdecl, 
    importc: "gtk_frame_set_label_align", dynlib: lib.}
proc get_label_align*(frame: PFrame; xalign: Pgfloat; 
                                yalign: Pgfloat) {.cdecl, 
    importc: "gtk_frame_get_label_align", dynlib: lib.}
proc set_shadow_type*(frame: PFrame; typ: TShadowType) {.
    cdecl, importc: "gtk_frame_set_shadow_type", dynlib: lib.}
proc get_shadow_type*(frame: PFrame): TShadowType {.cdecl, 
    importc: "gtk_frame_get_shadow_type", dynlib: lib.}

template TYPE_ASPECT_FRAME*(): expr = 
  (gtk_aspect_frame_get_type())

template ASPECT_FRAME_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ASPECT_FRAME, TAspectFrame))

template ASPECT_FRAME_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ASPECT_FRAME, TAspectFrameClass))

template IS_ASPECT_FRAME*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ASPECT_FRAME))

template IS_ASPECT_FRAME_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ASPECT_FRAME))

template ASPECT_FRAME_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ASPECT_FRAME, TAspectFrameClass))

type 
  PAspectFrame* = ptr TAspectFrame
  TAspectFrame* = object of TFrame 
    priv45: PAspectFramePrivate

type 
  PAspectFrameClass* = ptr TAspectFrameClass
  TAspectFrameClass* = object of TFrameClass
    ugtk_reserved381: proc () {.cdecl.}
    ugtk_reserved382: proc () {.cdecl.}
    ugtk_reserved383: proc () {.cdecl.}
    ugtk_reserved384: proc () {.cdecl.}

proc aspect_frame_get_type*(): GType {.cdecl, 
    importc: "gtk_aspect_frame_get_type", dynlib: lib.}
proc aspect_frame_new*(label: CSTRING; xalign: gfloat; yalign: gfloat; 
                           ratio: gfloat; obey_child: gboolean): PWidget {.
    cdecl, importc: "gtk_aspect_frame_new", dynlib: lib.}
proc set*(aspect_frame: PAspectFrame; xalign: gfloat; 
                           yalign: gfloat; ratio: gfloat; obey_child: gboolean) {.
    cdecl, importc: "gtk_aspect_frame_set", dynlib: lib.}

template TYPE_ASSISTANT*(): expr = 
  (gtk_assistant_get_type())

template ASSISTANT_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_ASSISTANT, TAssistant))

template ASSISTANT_CLASS_TEMPLATE*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((c), TYPE_ASSISTANT, TAssistantClass))

template IS_ASSISTANT*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_ASSISTANT))

template IS_ASSISTANT_CLASS*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_ASSISTANT))

template ASSISTANT_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_ASSISTANT, TAssistantClass))

type 
  TAssistantPageType* {.size: sizeof(cint).} = enum 
    ASSISTANT_PAGE_CONTENT, ASSISTANT_PAGE_INTRO, 
    ASSISTANT_PAGE_CONFIRM, ASSISTANT_PAGE_SUMMARY, 
    ASSISTANT_PAGE_PROGRESS, ASSISTANT_PAGE_CUSTOM
type 
  PAssistant* = ptr TAssistant
  TAssistant* = object of TWindow
    priv46: PAssistantPrivate

type 
  PAssistantClass* = ptr TAssistantClass
  TAssistantClass* = object of TWindowClass
    prepare*: proc (assistant: PAssistant; page: PWidget) {.cdecl.}
    apply*: proc (assistant: PAssistant) {.cdecl.}
    close*: proc (assistant: PAssistant) {.cdecl.}
    cancel*: proc (assistant: PAssistant) {.cdecl.}
    ugtk_reserved391: proc () {.cdecl.}
    ugtk_reserved392: proc () {.cdecl.}
    ugtk_reserved393: proc () {.cdecl.}
    ugtk_reserved394: proc () {.cdecl.}
    ugtk_reserved395: proc () {.cdecl.}

type 
  TAssistantPageFunc* = proc (current_page: gint; data: gpointer): gint {.
      cdecl.}
proc assistant_get_type*(): GType {.cdecl, 
    importc: "gtk_assistant_get_type", dynlib: lib.}
proc assistant_new*(): PWidget {.cdecl, 
    importc: "gtk_assistant_new", dynlib: lib.}
proc next_page*(assistant: PAssistant) {.cdecl, 
    importc: "gtk_assistant_next_page", dynlib: lib.}
proc previous_page*(assistant: PAssistant) {.cdecl, 
    importc: "gtk_assistant_previous_page", dynlib: lib.}
proc get_current_page*(assistant: PAssistant): gint {.
    cdecl, importc: "gtk_assistant_get_current_page", dynlib: lib.}
proc set_current_page*(assistant: PAssistant; 
                                     page_num: gint) {.cdecl, 
    importc: "gtk_assistant_set_current_page", dynlib: lib.}
proc get_n_pages*(assistant: PAssistant): gint {.cdecl, 
    importc: "gtk_assistant_get_n_pages", dynlib: lib.}
proc get_nth_page*(assistant: PAssistant; page_num: gint): PWidget {.
    cdecl, importc: "gtk_assistant_get_nth_page", dynlib: lib.}
proc prepend_page*(assistant: PAssistant; 
                                 page: PWidget): gint {.cdecl, 
    importc: "gtk_assistant_prepend_page", dynlib: lib.}
proc append_page*(assistant: PAssistant; 
                                page: PWidget): gint {.cdecl, 
    importc: "gtk_assistant_append_page", dynlib: lib.}
proc insert_page*(assistant: PAssistant; 
                                page: PWidget; position: gint): gint {.
    cdecl, importc: "gtk_assistant_insert_page", dynlib: lib.}
proc remove_page*(assistant: PAssistant; page_num: gint) {.
    cdecl, importc: "gtk_assistant_remove_page", dynlib: lib.}
proc set_forward_page_func*(assistant: PAssistant; 
    page_func: TAssistantPageFunc; data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_assistant_set_forward_page_func", dynlib: lib.}
proc set_page_type*(assistant: PAssistant; 
                                  page: PWidget; 
                                  typ: TAssistantPageType) {.cdecl, 
    importc: "gtk_assistant_set_page_type", dynlib: lib.}
proc get_page_type*(assistant: PAssistant; 
                                  page: PWidget): TAssistantPageType {.
    cdecl, importc: "gtk_assistant_get_page_type", dynlib: lib.}
proc set_page_title*(assistant: PAssistant; 
                                   page: PWidget; title: CSTRING) {.
    cdecl, importc: "gtk_assistant_set_page_title", dynlib: lib.}
proc get_page_title*(assistant: PAssistant; 
                                   page: PWidget): CSTRING {.cdecl, 
    importc: "gtk_assistant_get_page_title", dynlib: lib.}
proc set_page_header_image*(assistant: PAssistant; 
    page: PWidget; pixbuf: PPixbuf) {.cdecl, 
    importc: "gtk_assistant_set_page_header_image", dynlib: lib.}
proc get_page_header_image*(assistant: PAssistant; 
    page: PWidget): PPixbuf {.cdecl, 
    importc: "gtk_assistant_get_page_header_image", dynlib: lib.}
proc set_page_side_image*(assistant: PAssistant; 
    page: PWidget; pixbuf: PPixbuf) {.cdecl, 
    importc: "gtk_assistant_set_page_side_image", dynlib: lib.}
proc get_page_side_image*(assistant: PAssistant; 
    page: PWidget): PPixbuf {.cdecl, 
    importc: "gtk_assistant_get_page_side_image", dynlib: lib.}
proc set_page_complete*(assistant: PAssistant; 
                                      page: PWidget; complete: gboolean) {.
    cdecl, importc: "gtk_assistant_set_page_complete", dynlib: lib.}
proc get_page_complete*(assistant: PAssistant; 
                                      page: PWidget): gboolean {.cdecl, 
    importc: "gtk_assistant_get_page_complete", dynlib: lib.}
proc add_action_widget*(assistant: PAssistant; 
                                      child: PWidget) {.cdecl, 
    importc: "gtk_assistant_add_action_widget", dynlib: lib.}
proc remove_action_widget*(assistant: PAssistant; 
    child: PWidget) {.cdecl, 
                            importc: "gtk_assistant_remove_action_widget", 
                            dynlib: lib.}
proc update_buttons_state*(assistant: PAssistant) {.cdecl, 
    importc: "gtk_assistant_update_buttons_state", dynlib: lib.}
proc commit*(assistant: PAssistant) {.cdecl, 
    importc: "gtk_assistant_commit", dynlib: lib.}

template TYPE_BUTTON_BOX*(): expr = 
  (gtk_button_box_get_type())

template BUTTON_BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BUTTON_BOX, TButtonBox))

template BUTTON_BOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BUTTON_BOX, TButtonBoxClass))

template IS_BUTTON_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BUTTON_BOX))

template IS_BUTTON_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BUTTON_BOX))

template BUTTON_BOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BUTTON_BOX, TButtonBoxClass))

type 
  PButtonBox* = ptr TButtonBox
  TButtonBox* = object of TBox 
    priv47: PButtonBoxPrivate

type 
  PButtonBoxClass* = ptr TButtonBoxClass
  TButtonBoxClass* = object of TBoxClass
    ugtk_reserved401: proc () {.cdecl.}
    ugtk_reserved402: proc () {.cdecl.}
    ugtk_reserved403: proc () {.cdecl.}
    ugtk_reserved404: proc () {.cdecl.}

proc button_box_get_type*(): GType {.cdecl, 
    importc: "gtk_button_box_get_type", dynlib: lib.}
proc button_box_new*(orientation: TOrientation): PWidget {.cdecl, 
    importc: "gtk_button_box_new", dynlib: lib.}
proc get_layout*(widget: PButtonBox): TButtonBoxStyle {.
    cdecl, importc: "gtk_button_box_get_layout", dynlib: lib.}
proc set_layout*(widget: PButtonBox; 
                                layout_style: TButtonBoxStyle) {.cdecl, 
    importc: "gtk_button_box_set_layout", dynlib: lib.}
proc get_child_secondary*(widget: PButtonBox; 
    child: PWidget): gboolean {.cdecl, importc: "gtk_button_box_get_child_secondary", 
                                      dynlib: lib.}
proc set_child_secondary*(widget: PButtonBox; 
    child: PWidget; is_secondary: gboolean) {.cdecl, 
    importc: "gtk_button_box_set_child_secondary", dynlib: lib.}
proc get_child_non_homogeneous*(widget: PButtonBox; 
    child: PWidget): gboolean {.cdecl, importc: "gtk_button_box_get_child_non_homogeneous", 
                                      dynlib: lib.}
proc set_child_non_homogeneous*(widget: PButtonBox; 
    child: PWidget; non_homogeneous: gboolean) {.cdecl, 
    importc: "gtk_button_box_set_child_non_homogeneous", dynlib: lib.}

type 
  PBindingSet* = ptr TBindingSet
  PBindingEntry* = ptr TBindingEntry
  PBindingArg* = ptr TBindingArg
  PBindingSignal* = ptr TBindingSignal
  TBindingSet*{.final, pure.} = object 
    set_name*: CSTRING
    priority*: gint
    widget_path_pspecs*: PGSList
    widget_class_pspecs*: PGSList
    class_branch_pspecs*: PGSList
    entries*: PBindingEntry
    current*: PBindingEntry
    parsed*: guint

  TBindingEntry*{.final, pure.} = object 
    keyval*: guint
    modifiers*: gdk3.TModifierType
    binding_set*: PBindingSet
    bitfield111*: guint
    set_next*: PBindingEntry
    hash_next*: PBindingEntry
    signals*: PBindingSignal

  dummy_union_name* = object  {.union.}
    long_data*: glong
    double_data*: gdouble
    string_data*: CSTRING

  TBindingArg*{.final, pure.} = object 
    arg_type*: GType
    d*: dummy_union_name

  TBindingSignal*{.final, pure.} = object 
    next*: PBindingSignal
    signal_name*: CSTRING
    n_args*: guint
    args*: PBindingArg

proc binding_set_new*(set_name: CSTRING): PBindingSet {.cdecl, 
    importc: "gtk_binding_set_new", dynlib: lib.}
proc binding_set_by_class*(object_class: gpointer): PBindingSet {.
    cdecl, importc: "gtk_binding_set_by_class", dynlib: lib.}
proc binding_set_find*(set_name: CSTRING): PBindingSet {.cdecl, 
    importc: "gtk_binding_set_find", dynlib: lib.}
proc bindings_activate*(obj: PGObject; keyval: guint; 
                            modifiers: gdk3.TModifierType): gboolean {.cdecl, 
    importc: "gtk_bindings_activate", dynlib: lib.}
proc bindings_activate_event*(obj: PGObject; event: PEventKey): gboolean {.
    cdecl, importc: "gtk_bindings_activate_event", dynlib: lib.}
proc activate*(binding_set: PBindingSet; keyval: guint; 
                               modifiers: gdk3.TModifierType; obj: PGObject): gboolean {.
    cdecl, importc: "gtk_binding_set_activate", dynlib: lib.}
proc binding_entry_skip*(binding_set: PBindingSet; keyval: guint; 
                             modifiers: gdk3.TModifierType) {.cdecl, 
    importc: "gtk_binding_entry_skip", dynlib: lib.}
proc binding_entry_add_signal*(binding_set: PBindingSet; 
                                   keyval: guint; modifiers: gdk3.TModifierType; 
                                   signal_name: CSTRING; n_args: guint) {.
    varargs, cdecl, importc: "gtk_binding_entry_add_signal", dynlib: lib.}
proc binding_entry_add_signall*(binding_set: PBindingSet; 
                                    keyval: guint; modifiers: gdk3.TModifierType; 
                                    signal_name: CSTRING; 
                                    binding_args: PGSList) {.cdecl, 
    importc: "gtk_binding_entry_add_signall", dynlib: lib.}
proc binding_entry_add_signal_from_string*(binding_set: PBindingSet; 
    signal_desc: CSTRING): TGTokenType {.cdecl, 
    importc: "gtk_binding_entry_add_signal_from_string", dynlib: lib.}
proc binding_entry_remove*(binding_set: PBindingSet; keyval: guint; 
                               modifiers: gdk3.TModifierType) {.cdecl, 
    importc: "gtk_binding_entry_remove", dynlib: lib.}
proc add_path*(binding_set: PBindingSet; 
                               path_type: TPathType; 
                               path_pattern: CSTRING; 
                               priority: TPathPriorityType) {.cdecl, 
    importc: "gtk_binding_set_add_path", dynlib: lib.}

template TYPE_BUILDER*(): expr = 
  (gtk_builder_get_type())

template BUILDER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BUILDER, TBuilder))

template BUILDER_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BUILDER, TBuilderClass))

template IS_BUILDER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BUILDER))

template IS_BUILDER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BUILDER))

template BUILDER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BUILDER, TBuilderClass))

template BUILDER_ERROR*(): expr = 
  (gtk_builder_error_quark())

type 
  TBuilderError* {.size: sizeof(cint).} = enum 
    BUILDER_ERROR_INVALID_TYPE_FUNCTION, BUILDER_ERROR_UNHANDLED_TAG, 
    BUILDER_ERROR_MISSING_ATTRIBUTE, BUILDER_ERROR_INVALID_ATTRIBUTE, 
    BUILDER_ERROR_INVALID_TAG, BUILDER_ERROR_MISSING_PROPERTY_VALUE, 
    BUILDER_ERROR_INVALID_VALUE, BUILDER_ERROR_VERSION_MISMATCH, 
    BUILDER_ERROR_DUPLICATE_ID, BUILDER_ERROR_OBJECT_TYPE_REFUSED, 
    BUILDER_ERROR_TEMPLATE_MISMATCH
proc builder_error_quark*(): TGQuark {.cdecl, 
    importc: "gtk_builder_error_quark", dynlib: lib.}

type 
  PBuilderClass* = ptr TBuilderClass
  TBuilderClass* = object of TGObjectClass
    get_type_from_name*: proc (builder: PBuilder; type_name: cstring): GType {.
        cdecl.}
    ugtk_reserved411: proc () {.cdecl.}
    ugtk_reserved412: proc () {.cdecl.}
    ugtk_reserved413: proc () {.cdecl.}
    ugtk_reserved414: proc () {.cdecl.}
    ugtk_reserved415: proc () {.cdecl.}
    ugtk_reserved416: proc () {.cdecl.}
    ugtk_reserved417: proc () {.cdecl.}
    ugtk_reserved418: proc () {.cdecl.}

proc builder_get_type*(): GType {.cdecl, importc: "gtk_builder_get_type", 
                                      dynlib: lib.}
proc builder_new*(): PBuilder {.cdecl, importc: "gtk_builder_new", 
    dynlib: lib.}
proc add_from_file*(builder: PBuilder; filename: CSTRING; 
                                error: ptr PGError): guint {.cdecl, 
    importc: "gtk_builder_add_from_file", dynlib: lib.}
proc add_from_resource*(builder: PBuilder; 
                                    resource_path: CSTRING; 
                                    error: ptr PGError): guint {.cdecl, 
    importc: "gtk_builder_add_from_resource", dynlib: lib.}
proc add_from_string*(builder: PBuilder; buffer: CSTRING; 
                                  length: gsize; error: ptr PGError): guint {.
    cdecl, importc: "gtk_builder_add_from_string", dynlib: lib.}
proc add_objects_from_file*(builder: PBuilder; 
    filename: CSTRING; object_ids: ptr CSTRING; error: ptr PGError): guint {.
    cdecl, importc: "gtk_builder_add_objects_from_file", dynlib: lib.}
proc add_objects_from_resource*(builder: PBuilder; 
    resource_path: CSTRING; object_ids: ptr CSTRING; error: ptr PGError): guint {.
    cdecl, importc: "gtk_builder_add_objects_from_resource", dynlib: lib.}
proc add_objects_from_string*(builder: PBuilder; 
    buffer: CSTRING; length: gsize; object_ids: ptr CSTRING; 
    error: ptr PGError): guint {.cdecl, importc: "gtk_builder_add_objects_from_string", 
                                    dynlib: lib.}
proc get_object*(builder: PBuilder; name: CSTRING): PGObject {.
    cdecl, importc: "gtk_builder_get_object", dynlib: lib.}
proc get_objects*(builder: PBuilder): PGSList {.cdecl, 
    importc: "gtk_builder_get_objects", dynlib: lib.}
proc expose_object*(builder: PBuilder; name: CSTRING; 
                                obj: PGObject) {.cdecl, 
    importc: "gtk_builder_expose_object", dynlib: lib.}
proc connect_signals*(builder: PBuilder; user_data: gpointer) {.
    cdecl, importc: "gtk_builder_connect_signals", dynlib: lib.}
proc connect_signals_full*(builder: PBuilder; 
    func: TBuilderConnectFunc; user_data: gpointer) {.cdecl, 
    importc: "gtk_builder_connect_signals_full", dynlib: lib.}
proc set_translation_domain*(builder: PBuilder; 
    domain: CSTRING) {.cdecl, importc: "gtk_builder_set_translation_domain", 
                         dynlib: lib.}
proc get_translation_domain*(builder: PBuilder): CSTRING {.
    cdecl, importc: "gtk_builder_get_translation_domain", dynlib: lib.}
proc get_type_from_name*(builder: PBuilder; 
                                     type_name: cstring): GType {.cdecl, 
    importc: "gtk_builder_get_type_from_name", dynlib: lib.}
proc value_from_string*(builder: PBuilder; 
                                    pspec: PGParamSpec; string: CSTRING; 
                                    value: PGValue; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_builder_value_from_string", dynlib: lib.}
proc value_from_string_type*(builder: PBuilder; typ: GType; 
    string: CSTRING; value: PGValue; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_builder_value_from_string_type", dynlib: lib.}
proc builder_new_from_file*(filename: CSTRING): PBuilder {.cdecl, 
    importc: "gtk_builder_new_from_file", dynlib: lib.}
proc builder_new_from_resource*(resource_path: CSTRING): PBuilder {.
    cdecl, importc: "gtk_builder_new_from_resource", dynlib: lib.}
proc builder_new_from_string*(string: CSTRING; length: gssize): PBuilder {.
    cdecl, importc: "gtk_builder_new_from_string", dynlib: lib.}
proc add_callback_symbol*(builder: PBuilder; 
                                      callback_name: CSTRING; 
                                      callback_symbol: TGCallback) {.cdecl, 
    importc: "gtk_builder_add_callback_symbol", dynlib: lib.}
proc add_callback_symbols*(builder: PBuilder; 
    first_callback_name: CSTRING; first_callback_symbol: TGCallback) {.
    varargs, cdecl, importc: "gtk_builder_add_callback_symbols", dynlib: lib.}
proc lookup_callback_symbol*(builder: PBuilder; 
    callback_name: CSTRING): TGCallback {.cdecl, 
    importc: "gtk_builder_lookup_callback_symbol", dynlib: lib.}
proc set_application*(builder: PBuilder; 
                                  application: PApplication) {.cdecl, 
    importc: "gtk_builder_set_application", dynlib: lib.}
proc get_application*(builder: PBuilder): PApplication {.
    cdecl, importc: "gtk_builder_get_application", dynlib: lib.}
template BUILDER_WARN_INVALID_CHILD_TYPE*(obj, typ: expr): expr = 
  g_warning("'%s' is not a valid child type of '%s'", type, 
            g_type_name(G_OBJECT_TYPE(obj)))


template TYPE_BUILDABLE*(): expr = 
  (gtk_buildable_get_type())

template BUILDABLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BUILDABLE, TBuildable))

template BUILDABLE_CLASS*(obj: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((obj), TYPE_BUILDABLE, TBuildableIface))

template IS_BUILDABLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BUILDABLE))

template BUILDABLE_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_BUILDABLE, TBuildableIface))

type 
  PBuildableIface* = ptr TBuildableIface
  TBuildableIface* = object of TGTypeInterface
    set_name*: proc (buildable: PBuildable; name: CSTRING) {.cdecl.}
    get_name*: proc (buildable: PBuildable): CSTRING {.cdecl.}
    add_child*: proc (buildable: PBuildable; builder: PBuilder; 
                      child: PGObject; typ: CSTRING) {.cdecl.}
    set_buildable_property*: proc (buildable: PBuildable; 
                                   builder: PBuilder; name: CSTRING; 
                                   value: PGValue) {.cdecl.}
    construct_child*: proc (buildable: PBuildable; 
                            builder: PBuilder; name: CSTRING): PGObject {.
        cdecl.}
    custom_tag_start*: proc (buildable: PBuildable; 
                             builder: PBuilder; child: PGObject; 
                             tagname: CSTRING; parser: PGMarkupParser; 
                             data: Pgpointer): gboolean {.cdecl.}
    custom_tag_end*: proc (buildable: PBuildable; 
                           builder: PBuilder; child: PGObject; 
                           tagname: CSTRING; data: Pgpointer) {.cdecl.}
    custom_finished*: proc (buildable: PBuildable; 
                            builder: PBuilder; child: PGObject; 
                            tagname: CSTRING; data: gpointer) {.cdecl.}
    parser_finished*: proc (buildable: PBuildable; 
                            builder: PBuilder) {.cdecl.}
    get_internal_child*: proc (buildable: PBuildable; 
                               builder: PBuilder; childname: CSTRING): PGObject {.
        cdecl.}

proc buildable_get_type*(): GType {.cdecl, 
    importc: "gtk_buildable_get_type", dynlib: lib.}
proc set_name*(buildable: PBuildable; name: CSTRING) {.
    cdecl, importc: "gtk_buildable_set_name", dynlib: lib.}
proc get_name*(buildable: PBuildable): CSTRING {.cdecl, 
    importc: "gtk_buildable_get_name", dynlib: lib.}
proc add_child*(buildable: PBuildable; 
                              builder: PBuilder; child: PGObject; 
                              typ: CSTRING) {.cdecl, 
    importc: "gtk_buildable_add_child", dynlib: lib.}
proc set_buildable_property*(buildable: PBuildable; 
    builder: PBuilder; name: CSTRING; value: PGValue) {.cdecl, 
    importc: "gtk_buildable_set_buildable_property", dynlib: lib.}
proc construct_child*(buildable: PBuildable; 
                                    builder: PBuilder; name: CSTRING): PGObject {.
    cdecl, importc: "gtk_buildable_construct_child", dynlib: lib.}
proc custom_tag_start*(buildable: PBuildable; 
                                     builder: PBuilder; 
                                     child: PGObject; tagname: CSTRING; 
                                     parser: PGMarkupParser; 
                                     data: Pgpointer): gboolean {.cdecl, 
    importc: "gtk_buildable_custom_tag_start", dynlib: lib.}
proc custom_tag_end*(buildable: PBuildable; 
                                   builder: PBuilder; 
                                   child: PGObject; tagname: CSTRING; 
                                   data: Pgpointer) {.cdecl, 
    importc: "gtk_buildable_custom_tag_end", dynlib: lib.}
proc custom_finished*(buildable: PBuildable; 
                                    builder: PBuilder; 
                                    child: PGObject; tagname: CSTRING; 
                                    data: gpointer) {.cdecl, 
    importc: "gtk_buildable_custom_finished", dynlib: lib.}
proc parser_finished*(buildable: PBuildable; 
                                    builder: PBuilder) {.cdecl, 
    importc: "gtk_buildable_parser_finished", dynlib: lib.}
proc get_internal_child*(buildable: PBuildable; 
    builder: PBuilder; childname: CSTRING): PGObject {.cdecl, 
    importc: "gtk_buildable_get_internal_child", dynlib: lib.}

template TYPE_BUTTON*(): expr = 
  (gtk_button_get_type())

template BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BUTTON, TButton))

template BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BUTTON, TButtonClass))

template IS_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BUTTON))

template IS_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BUTTON))

template BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BUTTON, TButtonClass))

type 
  PButton* = ptr TButton
  TButton* = object of TBin
    priv48: PButtonPrivate

type 
  PButtonClass* = ptr TButtonClass
  TButtonClass* = object of TBinClass
    pressed*: proc (button: PButton) {.cdecl.}
    released*: proc (button: PButton) {.cdecl.}
    clicked*: proc (button: PButton) {.cdecl.}
    enter*: proc (button: PButton) {.cdecl.}
    leave*: proc (button: PButton) {.cdecl.}
    activate*: proc (button: PButton) {.cdecl.}
    ugtk_reserved421: proc () {.cdecl.}
    ugtk_reserved422: proc () {.cdecl.}
    ugtk_reserved423: proc () {.cdecl.}
    ugtk_reserved424: proc () {.cdecl.}

proc button_get_type*(): GType {.cdecl, importc: "gtk_button_get_type", 
                                     dynlib: lib.}
proc button_new*(): PWidget {.cdecl, importc: "gtk_button_new", 
    dynlib: lib.}
proc button_new_with_label*(label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_button_new_with_label", dynlib: lib.}
proc button_new_from_icon_name*(icon_name: CSTRING; size: TIconSize): PWidget {.
    cdecl, importc: "gtk_button_new_from_icon_name", dynlib: lib.}
proc button_new_from_stock*(stock_id: CSTRING): PWidget {.cdecl, 
    importc: "gtk_button_new_from_stock", dynlib: lib.}
proc button_new_with_mnemonic*(label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_button_new_with_mnemonic", dynlib: lib.}
proc clicked*(button: PButton) {.cdecl, 
    importc: "gtk_button_clicked", dynlib: lib.}
proc pressed*(button: PButton) {.cdecl, 
    importc: "gtk_button_pressed", dynlib: lib.}
proc released*(button: PButton) {.cdecl, 
    importc: "gtk_button_released", dynlib: lib.}
proc enter*(button: PButton) {.cdecl, 
    importc: "gtk_button_enter", dynlib: lib.}
proc leave*(button: PButton) {.cdecl, 
    importc: "gtk_button_leave", dynlib: lib.}
proc set_relief*(button: PButton; newstyle: TReliefStyle) {.
    cdecl, importc: "gtk_button_set_relief", dynlib: lib.}
proc get_relief*(button: PButton): TReliefStyle {.cdecl, 
    importc: "gtk_button_get_relief", dynlib: lib.}
proc set_label*(button: PButton; label: CSTRING) {.cdecl, 
    importc: "gtk_button_set_label", dynlib: lib.}
proc get_label*(button: PButton): CSTRING {.cdecl, 
    importc: "gtk_button_get_label", dynlib: lib.}
proc set_use_underline*(button: PButton; 
                                   use_underline: gboolean) {.cdecl, 
    importc: "gtk_button_set_use_underline", dynlib: lib.}
proc get_use_underline*(button: PButton): gboolean {.cdecl, 
    importc: "gtk_button_get_use_underline", dynlib: lib.}
proc set_use_stock*(button: PButton; use_stock: gboolean) {.
    cdecl, importc: "gtk_button_set_use_stock", dynlib: lib.}
proc get_use_stock*(button: PButton): gboolean {.cdecl, 
    importc: "gtk_button_get_use_stock", dynlib: lib.}
proc set_focus_on_click*(button: PButton; 
                                    focus_on_click: gboolean) {.cdecl, 
    importc: "gtk_button_set_focus_on_click", dynlib: lib.}
proc get_focus_on_click*(button: PButton): gboolean {.cdecl, 
    importc: "gtk_button_get_focus_on_click", dynlib: lib.}
proc set_alignment*(button: PButton; xalign: gfloat; 
                               yalign: gfloat) {.cdecl, 
    importc: "gtk_button_set_alignment", dynlib: lib.}
proc get_alignment*(button: PButton; xalign: Pgfloat; 
                               yalign: Pgfloat) {.cdecl, 
    importc: "gtk_button_get_alignment", dynlib: lib.}
proc set_image*(button: PButton; image: PWidget) {.
    cdecl, importc: "gtk_button_set_image", dynlib: lib.}
proc get_image*(button: PButton): PWidget {.cdecl, 
    importc: "gtk_button_get_image", dynlib: lib.}
proc set_image_position*(button: PButton; 
                                    position: TPositionType) {.cdecl, 
    importc: "gtk_button_set_image_position", dynlib: lib.}
proc get_image_position*(button: PButton): TPositionType {.
    cdecl, importc: "gtk_button_get_image_position", dynlib: lib.}
proc set_always_show_image*(button: PButton; 
    always_show: gboolean) {.cdecl, 
                             importc: "gtk_button_set_always_show_image", 
                             dynlib: lib.}
proc get_always_show_image*(button: PButton): gboolean {.
    cdecl, importc: "gtk_button_get_always_show_image", dynlib: lib.}
proc get_event_window*(button: PButton): PGdkWindow {.
    cdecl, importc: "gtk_button_get_event_window", dynlib: lib.}

type 
  TCalendarDisplayOptions* {.size: sizeof(cint).} = enum 
    CALENDAR_SHOW_HEADING = 1 shl 0, 
    CALENDAR_SHOW_DAY_NAMES = 1 shl 1, 
    CALENDAR_NO_MONTH_CHANGE = 1 shl 2, 
    CALENDAR_SHOW_WEEK_NUMBERS = 1 shl 3, 
    CALENDAR_SHOW_DETAILS = 1 shl 5
type 
  PCalendar* = ptr TCalendar
  TCalendar* = object of TWidget
    priv49: PCalendarPrivate

type 
  TCalendarDetailFunc* = proc (calendar: PCalendar; year: guint; 
                                 month: guint; day: guint; user_data: gpointer): CSTRING {.
      cdecl.}
type 
  PCalendarClass* = ptr TCalendarClass
  TCalendarClass* = object of TWidgetClass
    month_changed*: proc (calendar: PCalendar) {.cdecl.}
    day_selected*: proc (calendar: PCalendar) {.cdecl.}
    day_selected_double_click*: proc (calendar: PCalendar) {.cdecl.}
    prev_month*: proc (calendar: PCalendar) {.cdecl.}
    next_month*: proc (calendar: PCalendar) {.cdecl.}
    prev_year*: proc (calendar: PCalendar) {.cdecl.}
    next_year*: proc (calendar: PCalendar) {.cdecl.}
    ugtk_reserved431: proc () {.cdecl.}
    ugtk_reserved432: proc () {.cdecl.}
    ugtk_reserved433: proc () {.cdecl.}
    ugtk_reserved434: proc () {.cdecl.}

template TYPE_CALENDAR*(): expr = 
  (gtk_calendar_get_type())

template CALENDAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CALENDAR, TCalendar))

template CALENDAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CALENDAR, TCalendarClass))

template IS_CALENDAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CALENDAR))

template IS_CALENDAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CALENDAR))

template CALENDAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CALENDAR, TCalendarClass))

proc calendar_get_type*(): GType {.cdecl, 
    importc: "gtk_calendar_get_type", dynlib: lib.}
proc calendar_new*(): PWidget {.cdecl, importc: "gtk_calendar_new", 
    dynlib: lib.}
proc select_month*(calendar: PCalendar; month: guint; 
                                year: guint) {.cdecl, 
    importc: "gtk_calendar_select_month", dynlib: lib.}
proc select_day*(calendar: PCalendar; day: guint) {.cdecl, 
    importc: "gtk_calendar_select_day", dynlib: lib.}
proc mark_day*(calendar: PCalendar; day: guint) {.cdecl, 
    importc: "gtk_calendar_mark_day", dynlib: lib.}
proc unmark_day*(calendar: PCalendar; day: guint) {.cdecl, 
    importc: "gtk_calendar_unmark_day", dynlib: lib.}
proc clear_marks*(calendar: PCalendar) {.cdecl, 
    importc: "gtk_calendar_clear_marks", dynlib: lib.}
proc set_display_options*(calendar: PCalendar; 
    flags: TCalendarDisplayOptions) {.cdecl, 
    importc: "gtk_calendar_set_display_options", dynlib: lib.}
proc get_display_options*(calendar: PCalendar): TCalendarDisplayOptions {.
    cdecl, importc: "gtk_calendar_get_display_options", dynlib: lib.}
proc get_date*(calendar: PCalendar; year: Pguint; 
                            month: Pguint; day: Pguint) {.cdecl, 
    importc: "gtk_calendar_get_date", dynlib: lib.}
proc set_detail_func*(calendar: PCalendar; 
                                   func: TCalendarDetailFunc; 
                                   data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_calendar_set_detail_func", dynlib: lib.}
proc set_detail_width_chars*(calendar: PCalendar; 
    chars: gint) {.cdecl, importc: "gtk_calendar_set_detail_width_chars", 
                   dynlib: lib.}
proc set_detail_height_rows*(calendar: PCalendar; 
    rows: gint) {.cdecl, importc: "gtk_calendar_set_detail_height_rows", 
                  dynlib: lib.}
proc get_detail_width_chars*(calendar: PCalendar): gint {.
    cdecl, importc: "gtk_calendar_get_detail_width_chars", dynlib: lib.}
proc get_detail_height_rows*(calendar: PCalendar): gint {.
    cdecl, importc: "gtk_calendar_get_detail_height_rows", dynlib: lib.}
proc get_day_is_marked*(calendar: PCalendar; day: guint): gboolean {.
    cdecl, importc: "gtk_calendar_get_day_is_marked", dynlib: lib.}

template TYPE_CELL_AREA_BOX*(): expr = 
  (gtk_cell_area_box_get_type())

template CELL_AREA_BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_AREA_BOX, TCellAreaBox))

template CELL_AREA_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_AREA_BOX, 
                           TCellAreaBoxClass))

template IS_CELL_AREA_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_AREA_BOX))

template IS_CELL_AREA_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_AREA_BOX))

template CELL_AREA_BOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_AREA_BOX, 
                             TCellAreaBoxClass))

type 
  PCellAreaBox* = ptr TCellAreaBox
  TCellAreaBox* = object of TCellArea
    priv50: PCellAreaBoxPrivate

type 
  PCellAreaBoxClass* = ptr TCellAreaBoxClass
  TCellAreaBoxClass* = object of TCellAreaClass
    ugtk_reserved441: proc () {.cdecl.}
    ugtk_reserved442: proc () {.cdecl.}
    ugtk_reserved443: proc () {.cdecl.}
    ugtk_reserved444: proc () {.cdecl.}

proc cell_area_box_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_area_box_get_type", dynlib: lib.}
proc cell_area_box_new*(): PCellArea {.cdecl, 
    importc: "gtk_cell_area_box_new", dynlib: lib.}
proc cell_area_box_pack_start*(box: PCellAreaBox; 
                                   renderer: PCellRenderer; 
                                   expand: gboolean; align: gboolean; 
                                   fixed: gboolean) {.cdecl, 
    importc: "gtk_cell_area_box_pack_start", dynlib: lib.}
proc cell_area_box_pack_end*(box: PCellAreaBox; 
                                 renderer: PCellRenderer; 
                                 expand: gboolean; align: gboolean; 
                                 fixed: gboolean) {.cdecl, 
    importc: "gtk_cell_area_box_pack_end", dynlib: lib.}
proc get_spacing*(box: PCellAreaBox): gint {.cdecl, 
    importc: "gtk_cell_area_box_get_spacing", dynlib: lib.}
proc set_spacing*(box: PCellAreaBox; spacing: gint) {.
    cdecl, importc: "gtk_cell_area_box_set_spacing", dynlib: lib.}
proc underscore_gtk_cell_area_box_group_visible*(box: PCellAreaBox; 
    group_idx: gint): gboolean {.cdecl, 
                                 importc: "_gtk_cell_area_box_group_visible", 
                                 dynlib: lib.}

template TYPE_CELL_AREA_CONTEXT*(): expr = 
  (gtk_cell_area_context_get_type())

template CELL_AREA_CONTEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_AREA_CONTEXT, 
                              TCellAreaContext))

template CELL_AREA_CONTEXT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_AREA_CONTEXT, 
                           TCellAreaContextClass))

template IS_CELL_AREA_CONTEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_AREA_CONTEXT))

template IS_CELL_AREA_CONTEXT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_AREA_CONTEXT))

template CELL_AREA_CONTEXT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_AREA_CONTEXT, 
                             TCellAreaContextClass))


proc cell_area_context_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_area_context_get_type", dynlib: lib.}
proc get_area*(context: PCellAreaContext): PCellArea {.
    cdecl, importc: "gtk_cell_area_context_get_area", dynlib: lib.}
proc allocate*(context: PCellAreaContext; 
                                     width: gint; height: gint) {.cdecl, 
    importc: "gtk_cell_area_context_allocate", dynlib: lib.}
proc reset*(context: PCellAreaContext) {.cdecl, 
    importc: "gtk_cell_area_context_reset", dynlib: lib.}
proc get_preferred_width*(
    context: PCellAreaContext; minimum_width: Pgint; 
    natural_width: Pgint) {.cdecl, importc: "gtk_cell_area_context_get_preferred_width", 
                               dynlib: lib.}
proc get_preferred_height*(
    context: PCellAreaContext; minimum_height: Pgint; 
    natural_height: Pgint) {.cdecl, importc: "gtk_cell_area_context_get_preferred_height", 
                                dynlib: lib.}
proc get_preferred_height_for_width*(
    context: PCellAreaContext; width: gint; minimum_height: Pgint; 
    natural_height: Pgint) {.cdecl, importc: "gtk_cell_area_context_get_preferred_height_for_width", 
                                dynlib: lib.}
proc get_preferred_width_for_height*(
    context: PCellAreaContext; height: gint; minimum_width: Pgint; 
    natural_width: Pgint) {.cdecl, importc: "gtk_cell_area_context_get_preferred_width_for_height", 
                               dynlib: lib.}
proc get_allocation*(context: PCellAreaContext; 
    width: Pgint; height: Pgint) {.cdecl, 
    importc: "gtk_cell_area_context_get_allocation", dynlib: lib.}
proc push_preferred_width*(
    context: PCellAreaContext; minimum_width: gint; natural_width: gint) {.
    cdecl, importc: "gtk_cell_area_context_push_preferred_width", dynlib: lib.}
proc push_preferred_height*(
    context: PCellAreaContext; minimum_height: gint; 
    natural_height: gint) {.cdecl, importc: "gtk_cell_area_context_push_preferred_height", 
                            dynlib: lib.}

template TYPE_CELL_LAYOUT*(): expr = 
  (gtk_cell_layout_get_type())

template CELL_LAYOUT_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_LAYOUT, TCellLayout))

template IS_CELL_LAYOUT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_LAYOUT))

template CELL_LAYOUT_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_CELL_LAYOUT, 
                                 TCellLayoutIface))

type 
  TCellLayoutDataFunc* = proc (cell_layout: PCellLayout; 
                                 cell: PCellRenderer; 
                                 tree_model: PTreeModel; 
                                 iter: PTreeIter; data: gpointer) {.
      cdecl.}
type 
  PCellLayoutIface* = ptr TCellLayoutIface
  TCellLayoutIface* = object of TGTypeInterface
    pack_start*: proc (cell_layout: PCellLayout; 
                       cell: PCellRenderer; expand: gboolean) {.cdecl.}
    pack_end*: proc (cell_layout: PCellLayout; 
                     cell: PCellRenderer; expand: gboolean) {.cdecl.}
    clear*: proc (cell_layout: PCellLayout) {.cdecl.}
    add_attribute*: proc (cell_layout: PCellLayout; 
                          cell: PCellRenderer; attribute: CSTRING; 
                          column: gint) {.cdecl.}
    set_cell_data_func*: proc (cell_layout: PCellLayout; 
                               cell: PCellRenderer; 
                               func: TCellLayoutDataFunc; 
                               func_data: gpointer; destroy: TGDestroyNotify) {.
        cdecl.}
    clear_attributes*: proc (cell_layout: PCellLayout; 
                             cell: PCellRenderer) {.cdecl.}
    reorder*: proc (cell_layout: PCellLayout; cell: PCellRenderer; 
                    position: gint) {.cdecl.}
    get_cells*: proc (cell_layout: PCellLayout): PGList {.cdecl.}
    get_area*: proc (cell_layout: PCellLayout): PCellArea {.cdecl.}

proc cell_layout_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_layout_get_type", dynlib: lib.}
proc cell_layout_pack_start*(cell_layout: PCellLayout; 
                                 cell: PCellRenderer; expand: gboolean) {.
    cdecl, importc: "gtk_cell_layout_pack_start", dynlib: lib.}
proc cell_layout_pack_end*(cell_layout: PCellLayout; 
                               cell: PCellRenderer; expand: gboolean) {.
    cdecl, importc: "gtk_cell_layout_pack_end", dynlib: lib.}
proc get_cells*(cell_layout: PCellLayout): PGList {.
    cdecl, importc: "gtk_cell_layout_get_cells", dynlib: lib.}
proc clear*(cell_layout: PCellLayout) {.cdecl, 
    importc: "gtk_cell_layout_clear", dynlib: lib.}
proc set_attributes*(cell_layout: PCellLayout; 
                                     cell: PCellRenderer) {.varargs, 
    cdecl, importc: "gtk_cell_layout_set_attributes", dynlib: lib.}
proc add_attribute*(cell_layout: PCellLayout; 
                                    cell: PCellRenderer; 
                                    attribute: CSTRING; column: gint) {.
    cdecl, importc: "gtk_cell_layout_add_attribute", dynlib: lib.}
proc set_cell_data_func*(cell_layout: PCellLayout; 
    cell: PCellRenderer; func: TCellLayoutDataFunc; 
    func_data: gpointer; destroy: TGDestroyNotify) {.cdecl, 
    importc: "gtk_cell_layout_set_cell_data_func", dynlib: lib.}
proc clear_attributes*(cell_layout: PCellLayout; 
    cell: PCellRenderer) {.cdecl, 
                                 importc: "gtk_cell_layout_clear_attributes", 
                                 dynlib: lib.}
proc reorder*(cell_layout: PCellLayout; 
                              cell: PCellRenderer; position: gint) {.
    cdecl, importc: "gtk_cell_layout_reorder", dynlib: lib.}
proc get_area*(cell_layout: PCellLayout): PCellArea {.
    cdecl, importc: "gtk_cell_layout_get_area", dynlib: lib.}
proc underscore_gtk_cell_layout_buildable_custom_tag_start*(buildable: PBuildable; 
    builder: PBuilder; child: PGObject; tagname: CSTRING; 
    parser: PGMarkupParser; data: Pgpointer): gboolean {.cdecl, 
    importc: "_gtk_cell_layout_buildable_custom_tag_start", dynlib: lib.}
proc underscore_gtk_cell_layout_buildable_custom_tag_end*(buildable: PBuildable; 
    builder: PBuilder; child: PGObject; tagname: CSTRING; 
    data: Pgpointer): gboolean {.cdecl, importc: "_gtk_cell_layout_buildable_custom_tag_end", 
                                    dynlib: lib.}
proc underscore_gtk_cell_layout_buildable_add_child*(buildable: PBuildable; 
    builder: PBuilder; child: PGObject; typ: CSTRING) {.cdecl, 
    importc: "_gtk_cell_layout_buildable_add_child", dynlib: lib.}

template TYPE_CELL_RENDERER_TEXT*(): expr = 
  (gtk_cell_renderer_text_get_type())

template CELL_RENDERER_TEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_RENDERER_TEXT, 
                              TCellRendererText))

template CELL_RENDERER_TEXT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_RENDERER_TEXT, 
                           TCellRendererTextClass))

template IS_CELL_RENDERER_TEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_RENDERER_TEXT))

template IS_CELL_RENDERER_TEXT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_RENDERER_TEXT))

template CELL_RENDERER_TEXT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_RENDERER_TEXT, 
                             TCellRendererTextClass))

type 
  PCellRendererText* = ptr TCellRendererText
  TCellRendererText* = object of TCellRenderer
    priv51: PCellRendererTextPrivate

type 
  PCellRendererTextClass* = ptr TCellRendererTextClass
  TCellRendererTextClass* = object of TCellRendererClass
    edited*: proc (cell_renderer_text: PCellRendererText; 
                   path: CSTRING; new_text: CSTRING) {.cdecl.}
    ugtk_reserved451: proc () {.cdecl.}
    ugtk_reserved452: proc () {.cdecl.}
    ugtk_reserved453: proc () {.cdecl.}
    ugtk_reserved454: proc () {.cdecl.}

proc cell_renderer_text_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_text_get_type", dynlib: lib.}
proc cell_renderer_text_new*(): PCellRenderer {.cdecl, 
    importc: "gtk_cell_renderer_text_new", dynlib: lib.}
proc set_fixed_height_from_font*(
    renderer: PCellRendererText; number_of_rows: gint) {.cdecl, 
    importc: "gtk_cell_renderer_text_set_fixed_height_from_font", dynlib: lib.}

template TYPE_CELL_RENDERER_ACCEL*(): expr = 
  (gtk_cell_renderer_accel_get_type())

template CELL_RENDERER_ACCEL*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_RENDERER_ACCEL, 
                              TCellRendererAccel))

template CELL_RENDERER_ACCEL_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_RENDERER_ACCEL, 
                           TCellRendererAccelClass))

template IS_CELL_RENDERER_ACCEL*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_RENDERER_ACCEL))

template IS_CELL_RENDERER_ACCEL_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_RENDERER_ACCEL))

template CELL_RENDERER_ACCEL_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_RENDERER_ACCEL, 
                             TCellRendererAccelClass))

type 
  TCellRendererAccelMode* {.size: sizeof(cint).} = enum 
    CELL_RENDERER_ACCEL_MODE_GTK, CELL_RENDERER_ACCEL_MODE_OTHER
type 
  PCellRendererAccel* = ptr TCellRendererAccel
  TCellRendererAccel* = object of TCellRendererText
    priv52: PCellRendererAccelPrivate

type 
  PCellRendererAccelClass* = ptr TCellRendererAccelClass
  TCellRendererAccelClass* = object of TCellRendererTextClass
    accel_edited*: proc (accel: PCellRendererAccel; 
                         path_string: CSTRING; accel_key: guint; 
                         accel_mods: gdk3.TModifierType; hardware_keycode: guint) {.
        cdecl.}
    accel_cleared*: proc (accel: PCellRendererAccel; 
                          path_string: CSTRING) {.cdecl.}
    ugtk_reserved460: proc () {.cdecl.}
    ugtk_reserved461: proc () {.cdecl.}
    ugtk_reserved462: proc () {.cdecl.}
    ugtk_reserved463: proc () {.cdecl.}
    ugtk_reserved464: proc () {.cdecl.}

proc cell_renderer_accel_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_accel_get_type", dynlib: lib.}
proc cell_renderer_accel_new*(): PCellRenderer {.cdecl, 
    importc: "gtk_cell_renderer_accel_new", dynlib: lib.}

template TYPE_CELL_RENDERER_COMBO*(): expr = 
  (gtk_cell_renderer_combo_get_type())

template CELL_RENDERER_COMBO*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_RENDERER_COMBO, 
                              TCellRendererCombo))

template CELL_RENDERER_COMBO_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_RENDERER_COMBO, 
                           TCellRendererComboClass))

template IS_CELL_RENDERER_COMBO*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_RENDERER_COMBO))

template IS_CELL_RENDERER_COMBO_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_RENDERER_COMBO))

template CELL_RENDERER_COMBO_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_RENDERER_COMBO, 
                             TCellRendererTextClass))

type 
  PCellRendererCombo* = ptr TCellRendererCombo
  TCellRendererCombo* = object of TCellRendererText
    priv53: PCellRendererComboPrivate

type 
  PCellRendererComboClass* = ptr TCellRendererComboClass
  TCellRendererComboClass* = object of TCellRendererTextClass
    ugtk_reserved471: proc () {.cdecl.}
    ugtk_reserved472: proc () {.cdecl.}
    ugtk_reserved473: proc () {.cdecl.}
    ugtk_reserved474: proc () {.cdecl.}

proc cell_renderer_combo_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_combo_get_type", dynlib: lib.}
proc cell_renderer_combo_new*(): PCellRenderer {.cdecl, 
    importc: "gtk_cell_renderer_combo_new", dynlib: lib.}

template TYPE_CELL_RENDERER_PIXBUF*(): expr = 
  (gtk_cell_renderer_pixbuf_get_type())

template CELL_RENDERER_PIXBUF*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_RENDERER_PIXBUF, 
                              TCellRendererPixbuf))

template CELL_RENDERER_PIXBUF_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_RENDERER_PIXBUF, 
                           TCellRendererPixbufClass))

template IS_CELL_RENDERER_PIXBUF*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_RENDERER_PIXBUF))

template IS_CELL_RENDERER_PIXBUF_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_RENDERER_PIXBUF))

template CELL_RENDERER_PIXBUF_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_RENDERER_PIXBUF, 
                             TCellRendererPixbufClass))

type 
  PCellRendererPixbuf* = ptr TCellRendererPixbuf
  TCellRendererPixbuf* = object of TCellRenderer
    priv54: PCellRendererPixbufPrivate

type 
  PCellRendererPixbufClass* = ptr TCellRendererPixbufClass
  TCellRendererPixbufClass* = object of TCellRendererClass
    ugtk_reserved481: proc () {.cdecl.}
    ugtk_reserved482: proc () {.cdecl.}
    ugtk_reserved483: proc () {.cdecl.}
    ugtk_reserved484: proc () {.cdecl.}

proc cell_renderer_pixbuf_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_pixbuf_get_type", dynlib: lib.}
proc cell_renderer_pixbuf_new*(): PCellRenderer {.cdecl, 
    importc: "gtk_cell_renderer_pixbuf_new", dynlib: lib.}

template TYPE_CELL_RENDERER_PROGRESS*(): expr = 
  (gtk_cell_renderer_progress_get_type())

template CELL_RENDERER_PROGRESS*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_RENDERER_PROGRESS, 
                              TCellRendererProgress))

template CELL_RENDERER_PROGRESS_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_RENDERER_PROGRESS, 
                           TCellRendererProgressClass))

template IS_CELL_RENDERER_PROGRESS*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_RENDERER_PROGRESS))

template IS_CELL_RENDERER_PROGRESS_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_RENDERER_PROGRESS))

template CELL_RENDERER_PROGRESS_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_RENDERER_PROGRESS, 
                             TCellRendererProgressClass))

type 
  PCellRendererProgress* = ptr TCellRendererProgress
  TCellRendererProgress* = object of TCellRenderer
    priv55: PCellRendererProgressPrivate

type 
  PCellRendererProgressClass* = ptr TCellRendererProgressClass
  TCellRendererProgressClass* = object of TCellRendererClass
    ugtk_reserved491: proc () {.cdecl.}
    ugtk_reserved492: proc () {.cdecl.}
    ugtk_reserved493: proc () {.cdecl.}
    ugtk_reserved494: proc () {.cdecl.}

proc cell_renderer_progress_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_progress_get_type", dynlib: lib.}
proc cell_renderer_progress_new*(): PCellRenderer {.cdecl, 
    importc: "gtk_cell_renderer_progress_new", dynlib: lib.}

template TYPE_CELL_RENDERER_SPIN*(): expr = 
  (gtk_cell_renderer_spin_get_type())

template CELL_RENDERER_SPIN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_RENDERER_SPIN, 
                              TCellRendererSpin))

template CELL_RENDERER_SPIN_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_RENDERER_SPIN, 
                           TCellRendererSpinClass))

template IS_CELL_RENDERER_SPIN*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_RENDERER_SPIN))

template IS_CELL_RENDERER_SPIN_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_RENDERER_SPIN))

template CELL_RENDERER_SPIN_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_RENDERER_SPIN, 
                             TCellRendererTextClass))

type 
  PCellRendererSpin* = ptr TCellRendererSpin
  TCellRendererSpin* = object of TCellRendererText
    priv56: PCellRendererSpinPrivate

type 
  PCellRendererSpinClass* = ptr TCellRendererSpinClass
  TCellRendererSpinClass* = object of TCellRendererTextClass
    ugtk_reserved501: proc () {.cdecl.}
    ugtk_reserved502: proc () {.cdecl.}
    ugtk_reserved503: proc () {.cdecl.}
    ugtk_reserved504: proc () {.cdecl.}

proc cell_renderer_spin_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_spin_get_type", dynlib: lib.}
proc cell_renderer_spin_new*(): PCellRenderer {.cdecl, 
    importc: "gtk_cell_renderer_spin_new", dynlib: lib.}

template TYPE_CELL_RENDERER_SPINNER*(): expr = 
  (gtk_cell_renderer_spinner_get_type())

template CELL_RENDERER_SPINNER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_RENDERER_SPINNER, 
                              TCellRendererSpinner))

template CELL_RENDERER_SPINNER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_RENDERER_SPINNER, 
                           TCellRendererSpinnerClass))

template IS_CELL_RENDERER_SPINNER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_RENDERER_SPINNER))

template IS_CELL_RENDERER_SPINNER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_RENDERER_SPINNER))

template CELL_RENDERER_SPINNER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_RENDERER_SPINNER, 
                             TCellRendererSpinnerClass))

type 
  PCellRendererSpinner* = ptr TCellRendererSpinner
  TCellRendererSpinner* = object of TCellRenderer
    priv57: PCellRendererSpinnerPrivate

type 
  PCellRendererSpinnerClass* = ptr TCellRendererSpinnerClass
  TCellRendererSpinnerClass* = object of TCellRendererClass
    ugtk_reserved511: proc () {.cdecl.}
    ugtk_reserved512: proc () {.cdecl.}
    ugtk_reserved513: proc () {.cdecl.}
    ugtk_reserved514: proc () {.cdecl.}

proc cell_renderer_spinner_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_spinner_get_type", dynlib: lib.}
proc cell_renderer_spinner_new*(): PCellRenderer {.cdecl, 
    importc: "gtk_cell_renderer_spinner_new", dynlib: lib.}

template TYPE_CELL_RENDERER_TOGGLE*(): expr = 
  (gtk_cell_renderer_toggle_get_type())

template CELL_RENDERER_TOGGLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_RENDERER_TOGGLE, 
                              TCellRendererToggle))

template CELL_RENDERER_TOGGLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_RENDERER_TOGGLE, 
                           TCellRendererToggleClass))

template IS_CELL_RENDERER_TOGGLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_RENDERER_TOGGLE))

template IS_CELL_RENDERER_TOGGLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_RENDERER_TOGGLE))

template CELL_RENDERER_TOGGLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_RENDERER_TOGGLE, 
                             TCellRendererToggleClass))

type 
  PCellRendererToggle* = ptr TCellRendererToggle
  TCellRendererToggle* = object of TCellRenderer
    priv58: PCellRendererTogglePrivate

type 
  PCellRendererToggleClass* = ptr TCellRendererToggleClass
  TCellRendererToggleClass* = object of TCellRendererClass
    toggled*: proc (cell_renderer_toggle: PCellRendererToggle; 
                    path: CSTRING) {.cdecl.}
    ugtk_reserved521: proc () {.cdecl.}
    ugtk_reserved522: proc () {.cdecl.}
    ugtk_reserved523: proc () {.cdecl.}
    ugtk_reserved524: proc () {.cdecl.}

proc cell_renderer_toggle_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_toggle_get_type", dynlib: lib.}
proc cell_renderer_toggle_new*(): PCellRenderer {.cdecl, 
    importc: "gtk_cell_renderer_toggle_new", dynlib: lib.}
proc get_radio*(toggle: PCellRendererToggle): gboolean {.
    cdecl, importc: "gtk_cell_renderer_toggle_get_radio", dynlib: lib.}
proc set_radio*(toggle: PCellRendererToggle; 
    radio: gboolean) {.cdecl, importc: "gtk_cell_renderer_toggle_set_radio", 
                       dynlib: lib.}
proc get_active*(toggle: PCellRendererToggle): gboolean {.
    cdecl, importc: "gtk_cell_renderer_toggle_get_active", dynlib: lib.}
proc set_active*(toggle: PCellRendererToggle; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_cell_renderer_toggle_set_active", 
                         dynlib: lib.}
proc get_activatable*(
    toggle: PCellRendererToggle): gboolean {.cdecl, 
    importc: "gtk_cell_renderer_toggle_get_activatable", dynlib: lib.}
proc set_activatable*(
    toggle: PCellRendererToggle; setting: gboolean) {.cdecl, 
    importc: "gtk_cell_renderer_toggle_set_activatable", dynlib: lib.}

template TYPE_CELL_VIEW*(): expr = 
  (gtk_cell_view_get_type())

template CELL_VIEW_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_VIEW, TCellView))

template CELL_VIEW_CLASS_TEMPLATE*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((vtable), TYPE_CELL_VIEW, TCellViewClass))

template IS_CELL_VIEW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_VIEW))

template IS_CELL_VIEW_CLASS*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((vtable), TYPE_CELL_VIEW))

template CELL_VIEW_GET_CLASS*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((inst), TYPE_CELL_VIEW, TCellViewClass))

type 
  PCellView* = ptr TCellView
  TCellView* = object of TWidget
    priv59: PCellViewPrivate

type 
  PCellViewClass* = ptr TCellViewClass
  TCellViewClass* = object of TWidgetClass
    ugtk_reserved531: proc () {.cdecl.}
    ugtk_reserved532: proc () {.cdecl.}
    ugtk_reserved533: proc () {.cdecl.}
    ugtk_reserved534: proc () {.cdecl.}

proc cell_view_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_view_get_type", dynlib: lib.}
proc cell_view_new*(): PWidget {.cdecl, 
    importc: "gtk_cell_view_new", dynlib: lib.}
proc cell_view_new_with_context*(area: PCellArea; 
                                     context: PCellAreaContext): PWidget {.
    cdecl, importc: "gtk_cell_view_new_with_context", dynlib: lib.}
proc cell_view_new_with_text*(text: CSTRING): PWidget {.cdecl, 
    importc: "gtk_cell_view_new_with_text", dynlib: lib.}
proc cell_view_new_with_markup*(markup: CSTRING): PWidget {.cdecl, 
    importc: "gtk_cell_view_new_with_markup", dynlib: lib.}
proc cell_view_new_with_pixbuf*(pixbuf: PPixbuf): PWidget {.
    cdecl, importc: "gtk_cell_view_new_with_pixbuf", dynlib: lib.}
proc set_model*(cell_view: PCellView; 
                              model: PTreeModel) {.cdecl, 
    importc: "gtk_cell_view_set_model", dynlib: lib.}
proc get_model*(cell_view: PCellView): PTreeModel {.
    cdecl, importc: "gtk_cell_view_get_model", dynlib: lib.}
proc set_displayed_row*(cell_view: PCellView; 
                                      path: PTreePath) {.cdecl, 
    importc: "gtk_cell_view_set_displayed_row", dynlib: lib.}
proc get_displayed_row*(cell_view: PCellView): PTreePath {.
    cdecl, importc: "gtk_cell_view_get_displayed_row", dynlib: lib.}
proc set_background_rgba*(cell_view: PCellView; 
    rgba: PRGBA) {.cdecl, importc: "gtk_cell_view_set_background_rgba", 
                         dynlib: lib.}
proc get_draw_sensitive*(cell_view: PCellView): gboolean {.
    cdecl, importc: "gtk_cell_view_get_draw_sensitive", dynlib: lib.}
proc set_draw_sensitive*(cell_view: PCellView; 
    draw_sensitive: gboolean) {.cdecl, 
                                importc: "gtk_cell_view_set_draw_sensitive", 
                                dynlib: lib.}
proc get_fit_model*(cell_view: PCellView): gboolean {.
    cdecl, importc: "gtk_cell_view_get_fit_model", dynlib: lib.}
proc set_fit_model*(cell_view: PCellView; 
                                  fit_model: gboolean) {.cdecl, 
    importc: "gtk_cell_view_set_fit_model", dynlib: lib.}
proc get_size_of_row*(cell_view: PCellView; 
                                    path: PTreePath; 
                                    requisition: PRequisition): gboolean {.
    cdecl, importc: "gtk_cell_view_get_size_of_row", dynlib: lib.}
proc set_background_color*(cell_view: PCellView; 
    color: gdk3.PColor) {.cdecl, 
                           importc: "gtk_cell_view_set_background_color", 
                           dynlib: lib.}

template TYPE_TOGGLE_BUTTON*(): expr = 
  (gtk_toggle_button_get_type())

template TOGGLE_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TOGGLE_BUTTON, TToggleButton))

template TOGGLE_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TOGGLE_BUTTON, 
                           TToggleButtonClass))

template IS_TOGGLE_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TOGGLE_BUTTON))

template IS_TOGGLE_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TOGGLE_BUTTON))

template TOGGLE_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TOGGLE_BUTTON, 
                             TToggleButtonClass))

type 
  PToggleButton* = ptr TToggleButton
  TToggleButton* = object of TButton
    priv60: PToggleButtonPrivate

type 
  PToggleButtonClass* = ptr TToggleButtonClass
  TToggleButtonClass* = object of TButtonClass
    toggled*: proc (toggle_button: PToggleButton) {.cdecl.}
    ugtk_reserved541: proc () {.cdecl.}
    ugtk_reserved542: proc () {.cdecl.}
    ugtk_reserved543: proc () {.cdecl.}
    ugtk_reserved544: proc () {.cdecl.}

proc toggle_button_get_type*(): GType {.cdecl, 
    importc: "gtk_toggle_button_get_type", dynlib: lib.}
proc toggle_button_new*(): PWidget {.cdecl, 
    importc: "gtk_toggle_button_new", dynlib: lib.}
proc toggle_button_new_with_label*(label: CSTRING): PWidget {.
    cdecl, importc: "gtk_toggle_button_new_with_label", dynlib: lib.}
proc toggle_button_new_with_mnemonic*(label: CSTRING): PWidget {.
    cdecl, importc: "gtk_toggle_button_new_with_mnemonic", dynlib: lib.}
proc set_mode*(toggle_button: PToggleButton; 
                                 draw_indicator: gboolean) {.cdecl, 
    importc: "gtk_toggle_button_set_mode", dynlib: lib.}
proc get_mode*(toggle_button: PToggleButton): gboolean {.
    cdecl, importc: "gtk_toggle_button_get_mode", dynlib: lib.}
proc set_active*(toggle_button: PToggleButton; 
                                   is_active: gboolean) {.cdecl, 
    importc: "gtk_toggle_button_set_active", dynlib: lib.}
proc get_active*(toggle_button: PToggleButton): gboolean {.
    cdecl, importc: "gtk_toggle_button_get_active", dynlib: lib.}
proc toggled*(toggle_button: PToggleButton) {.cdecl, 
    importc: "gtk_toggle_button_toggled", dynlib: lib.}
proc set_inconsistent*(toggle_button: PToggleButton; 
    setting: gboolean) {.cdecl, importc: "gtk_toggle_button_set_inconsistent", 
                         dynlib: lib.}
proc get_inconsistent*(toggle_button: PToggleButton): gboolean {.
    cdecl, importc: "gtk_toggle_button_get_inconsistent", dynlib: lib.}
proc underscore_gtk_toggle_button_set_active*(toggle_button: PToggleButton; 
                                    is_active: gboolean) {.cdecl, 
    importc: "_gtk_toggle_button_set_active", dynlib: lib.}

template TYPE_CHECK_BUTTON*(): expr = 
  (gtk_check_button_get_type())

template CHECK_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CHECK_BUTTON, TCheckButton))

template CHECK_BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CHECK_BUTTON, TCheckButtonClass))

template IS_CHECK_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CHECK_BUTTON))

template IS_CHECK_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CHECK_BUTTON))

template CHECK_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CHECK_BUTTON, TCheckButtonClass))

type 
  PCheckButton* = ptr TCheckButton
  TCheckButton* = object of TToggleButton

type 
  PCheckButtonClass* = ptr TCheckButtonClass
  TCheckButtonClass* = object of TToggleButtonClass
    draw_indicator*: proc (check_button: PCheckButton; cr: cairo.Pcontext) {.
        cdecl.}
    ugtk_reserved551: proc () {.cdecl.}
    ugtk_reserved552: proc () {.cdecl.}
    ugtk_reserved553: proc () {.cdecl.}
    ugtk_reserved554: proc () {.cdecl.}

proc check_button_get_type*(): GType {.cdecl, 
    importc: "gtk_check_button_get_type", dynlib: lib.}
proc check_button_new*(): PWidget {.cdecl, 
    importc: "gtk_check_button_new", dynlib: lib.}
proc check_button_new_with_label*(label: CSTRING): PWidget {.
    cdecl, importc: "gtk_check_button_new_with_label", dynlib: lib.}
proc check_button_new_with_mnemonic*(label: CSTRING): PWidget {.
    cdecl, importc: "gtk_check_button_new_with_mnemonic", dynlib: lib.}
proc underscore_gtk_check_button_get_props*(check_button: PCheckButton; 
                                  indicator_size: Pgint; 
                                  indicator_spacing: Pgint) {.cdecl, 
    importc: "_gtk_check_button_get_props", dynlib: lib.}

template TYPE_MENU_ITEM*(): expr = 
  (gtk_menu_item_get_type())

template MENU_ITEM_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MENU_ITEM, TMenuItem))

template MENU_ITEM_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MENU_ITEM, TMenuItemClass))

template IS_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MENU_ITEM))

template IS_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MENU_ITEM))

template MENU_ITEM_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MENU_ITEM, TMenuItemClass))

type 
  PMenuItem* = ptr TMenuItem
  TMenuItem* = object of TBin
    priv61: PMenuItemPrivate

type 
  PMenuItemClass* = ptr TMenuItemClass
  TMenuItemClass* = object of TBinClass
    hide_on_activate*: guint
    activate*: proc (menu_item: PMenuItem) {.cdecl.}
    activate_item*: proc (menu_item: PMenuItem) {.cdecl.}
    toggle_size_request*: proc (menu_item: PMenuItem; 
                                requisition: Pgint) {.cdecl.}
    toggle_size_allocate*: proc (menu_item: PMenuItem; allocation: gint) {.
        cdecl.}
    set_label*: proc (menu_item: PMenuItem; label: CSTRING) {.cdecl.}
    get_label*: proc (menu_item: PMenuItem): CSTRING {.cdecl.}
    select*: proc (menu_item: PMenuItem) {.cdecl.}
    deselect*: proc (menu_item: PMenuItem) {.cdecl.}
    ugtk_reserved561: proc () {.cdecl.}
    ugtk_reserved562: proc () {.cdecl.}
    ugtk_reserved563: proc () {.cdecl.}
    ugtk_reserved564: proc () {.cdecl.}

proc menu_item_get_type*(): GType {.cdecl, 
    importc: "gtk_menu_item_get_type", dynlib: lib.}
proc menu_item_new*(): PWidget {.cdecl, 
    importc: "gtk_menu_item_new", dynlib: lib.}
proc menu_item_new_with_label*(label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_menu_item_new_with_label", dynlib: lib.}
proc menu_item_new_with_mnemonic*(label: CSTRING): PWidget {.
    cdecl, importc: "gtk_menu_item_new_with_mnemonic", dynlib: lib.}
proc set_submenu*(menu_item: PMenuItem; 
                                submenu: PWidget) {.cdecl, 
    importc: "gtk_menu_item_set_submenu", dynlib: lib.}
proc get_submenu*(menu_item: PMenuItem): PWidget {.
    cdecl, importc: "gtk_menu_item_get_submenu", dynlib: lib.}
proc select*(menu_item: PMenuItem) {.cdecl, 
    importc: "gtk_menu_item_select", dynlib: lib.}
proc deselect*(menu_item: PMenuItem) {.cdecl, 
    importc: "gtk_menu_item_deselect", dynlib: lib.}
proc activate*(menu_item: PMenuItem) {.cdecl, 
    importc: "gtk_menu_item_activate", dynlib: lib.}
proc toggle_size_request*(menu_item: PMenuItem; 
    requisition: Pgint) {.cdecl, 
                             importc: "gtk_menu_item_toggle_size_request", 
                             dynlib: lib.}
proc toggle_size_allocate*(menu_item: PMenuItem; 
    allocation: gint) {.cdecl, importc: "gtk_menu_item_toggle_size_allocate", 
                        dynlib: lib.}
proc set_right_justified*(menu_item: PMenuItem; 
    right_justified: gboolean) {.cdecl, importc: "gtk_menu_item_set_right_justified", 
                                 dynlib: lib.}
proc get_right_justified*(menu_item: PMenuItem): gboolean {.
    cdecl, importc: "gtk_menu_item_get_right_justified", dynlib: lib.}
proc set_accel_path*(menu_item: PMenuItem; 
                                   accel_path: CSTRING) {.cdecl, 
    importc: "gtk_menu_item_set_accel_path", dynlib: lib.}
proc get_accel_path*(menu_item: PMenuItem): CSTRING {.
    cdecl, importc: "gtk_menu_item_get_accel_path", dynlib: lib.}
proc set_label*(menu_item: PMenuItem; label: CSTRING) {.
    cdecl, importc: "gtk_menu_item_set_label", dynlib: lib.}
proc get_label*(menu_item: PMenuItem): CSTRING {.cdecl, 
    importc: "gtk_menu_item_get_label", dynlib: lib.}
proc set_use_underline*(menu_item: PMenuItem; 
                                      setting: gboolean) {.cdecl, 
    importc: "gtk_menu_item_set_use_underline", dynlib: lib.}
proc get_use_underline*(menu_item: PMenuItem): gboolean {.
    cdecl, importc: "gtk_menu_item_get_use_underline", dynlib: lib.}
proc set_reserve_indicator*(menu_item: PMenuItem; 
    reserve: gboolean) {.cdecl, 
                         importc: "gtk_menu_item_set_reserve_indicator", 
                         dynlib: lib.}
proc get_reserve_indicator*(menu_item: PMenuItem): gboolean {.
    cdecl, importc: "gtk_menu_item_get_reserve_indicator", dynlib: lib.}

template TYPE_CHECK_MENU_ITEM*(): expr = 
  (gtk_check_menu_item_get_type())

template CHECK_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CHECK_MENU_ITEM, 
                              TCheckMenuItem))

template CHECK_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CHECK_MENU_ITEM, 
                           TCheckMenuItemClass))

template IS_CHECK_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CHECK_MENU_ITEM))

template IS_CHECK_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CHECK_MENU_ITEM))

template CHECK_MENU_ITEM_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CHECK_MENU_ITEM, 
                             TCheckMenuItemClass))

type 
  PCheckMenuItem* = ptr TCheckMenuItem
  TCheckMenuItem* = object of TMenuItem
    priv62: PCheckMenuItemPrivate

type 
  PCheckMenuItemClass* = ptr TCheckMenuItemClass
  TCheckMenuItemClass* = object of TMenuItemClass
    toggled*: proc (check_menu_item: PCheckMenuItem) {.cdecl.}
    draw_indicator*: proc (check_menu_item: PCheckMenuItem; 
                           cr: cairo.Pcontext) {.cdecl.}
    ugtk_reserved571: proc () {.cdecl.}
    ugtk_reserved572: proc () {.cdecl.}
    ugtk_reserved573: proc () {.cdecl.}
    ugtk_reserved574: proc () {.cdecl.}

proc check_menu_item_get_type*(): GType {.cdecl, 
    importc: "gtk_check_menu_item_get_type", dynlib: lib.}
proc check_menu_item_new*(): PWidget {.cdecl, 
    importc: "gtk_check_menu_item_new", dynlib: lib.}
proc check_menu_item_new_with_label*(label: CSTRING): PWidget {.
    cdecl, importc: "gtk_check_menu_item_new_with_label", dynlib: lib.}
proc check_menu_item_new_with_mnemonic*(label: CSTRING): PWidget {.
    cdecl, importc: "gtk_check_menu_item_new_with_mnemonic", dynlib: lib.}
proc set_active*(check_menu_item: PCheckMenuItem; 
                                     is_active: gboolean) {.cdecl, 
    importc: "gtk_check_menu_item_set_active", dynlib: lib.}
proc get_active*(check_menu_item: PCheckMenuItem): gboolean {.
    cdecl, importc: "gtk_check_menu_item_get_active", dynlib: lib.}
proc toggled*(check_menu_item: PCheckMenuItem) {.
    cdecl, importc: "gtk_check_menu_item_toggled", dynlib: lib.}
proc set_inconsistent*(
    check_menu_item: PCheckMenuItem; setting: gboolean) {.cdecl, 
    importc: "gtk_check_menu_item_set_inconsistent", dynlib: lib.}
proc get_inconsistent*(
    check_menu_item: PCheckMenuItem): gboolean {.cdecl, 
    importc: "gtk_check_menu_item_get_inconsistent", dynlib: lib.}
proc set_draw_as_radio*(
    check_menu_item: PCheckMenuItem; draw_as_radio: gboolean) {.cdecl, 
    importc: "gtk_check_menu_item_set_draw_as_radio", dynlib: lib.}
proc get_draw_as_radio*(
    check_menu_item: PCheckMenuItem): gboolean {.cdecl, 
    importc: "gtk_check_menu_item_get_draw_as_radio", dynlib: lib.}
proc underscore_gtk_check_menu_item_set_active*(check_menu_item: PCheckMenuItem; 
                                      is_active: gboolean) {.cdecl, 
    importc: "_gtk_check_menu_item_set_active", dynlib: lib.}

template TYPE_CLIPBOARD*(): expr = 
  (gtk_clipboard_get_type())

template CLIPBOARD_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CLIPBOARD, TClipboard))

template IS_CLIPBOARD*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CLIPBOARD))

type 
  TClipboardReceivedFunc* = proc (clipboard: PClipboard; 
                                    selection_data: PSelectionData; 
                                    data: gpointer) {.cdecl.}
type 
  TClipboardTextReceivedFunc* = proc (clipboard: PClipboard; 
      text: CSTRING; data: gpointer) {.cdecl.}
  TClipboardRichTextReceivedFunc* = proc (clipboard: PClipboard; 
      format: TGdkAtom; text: Pguint8; length: gsize; data: gpointer) {.
      cdecl.}
type 
  TClipboardImageReceivedFunc* = proc (clipboard: PClipboard; 
      pixbuf: PPixbuf; data: gpointer) {.cdecl.}
  TClipboardURIReceivedFunc* = proc (clipboard: PClipboard; 
      uris: ptr CSTRING; data: gpointer) {.cdecl.}
type 
  TClipboardTargetsReceivedFunc* = proc (clipboard: PClipboard; 
      atoms: PGdkAtom; n_atoms: gint; data: gpointer) {.cdecl.}
type 
  TClipboardGetFunc* = proc (clipboard: PClipboard; 
                               selection_data: PSelectionData; 
                               info: guint; user_data_or_owner: gpointer) {.
      cdecl.}
type 
  TClipboardClearFunc* = proc (clipboard: PClipboard; 
                                 user_data_or_owner: gpointer) {.cdecl.}
proc clipboard_get_type*(): GType {.cdecl, 
    importc: "gtk_clipboard_get_type", dynlib: lib.}
proc clipboard_get_for_display*(display: PGdkDisplay; 
                                    selection: TGdkAtom): PClipboard {.
    cdecl, importc: "gtk_clipboard_get_for_display", dynlib: lib.}
when not(defined(GDK_MULTIHEAD_SAFE)): 
  proc clipboard_get*(selection: TGdkAtom): PClipboard {.cdecl, 
      importc: "gtk_clipboard_get", dynlib: lib.}
proc get_display*(clipboard: PClipboard): PGdkDisplay {.
    cdecl, importc: "gtk_clipboard_get_display", dynlib: lib.}
proc set_with_data*(clipboard: PClipboard; 
                                  targets: PTargetEntry; 
                                  n_targets: guint; 
                                  get_func: TClipboardGetFunc; 
                                  clear_func: TClipboardClearFunc; 
                                  user_data: gpointer): gboolean {.cdecl, 
    importc: "gtk_clipboard_set_with_data", dynlib: lib.}
proc set_with_owner*(clipboard: PClipboard; 
                                   targets: PTargetEntry; 
                                   n_targets: guint; 
                                   get_func: TClipboardGetFunc; 
                                   clear_func: TClipboardClearFunc; 
                                   owner: PGObject): gboolean {.cdecl, 
    importc: "gtk_clipboard_set_with_owner", dynlib: lib.}
proc get_owner*(clipboard: PClipboard): PGObject {.
    cdecl, importc: "gtk_clipboard_get_owner", dynlib: lib.}
proc clear*(clipboard: PClipboard) {.cdecl, 
    importc: "gtk_clipboard_clear", dynlib: lib.}
proc set_text*(clipboard: PClipboard; text: CSTRING; 
                             len: gint) {.cdecl, 
    importc: "gtk_clipboard_set_text", dynlib: lib.}
proc set_image*(clipboard: PClipboard; 
                              pixbuf: PPixbuf) {.cdecl, 
    importc: "gtk_clipboard_set_image", dynlib: lib.}
proc request_contents*(clipboard: PClipboard; 
                                     target: TGdkAtom; 
                                     callback: TClipboardReceivedFunc; 
                                     user_data: gpointer) {.cdecl, 
    importc: "gtk_clipboard_request_contents", dynlib: lib.}
proc request_text*(clipboard: PClipboard; 
                                 callback: TClipboardTextReceivedFunc; 
                                 user_data: gpointer) {.cdecl, 
    importc: "gtk_clipboard_request_text", dynlib: lib.}
proc request_rich_text*(clipboard: PClipboard; 
                                      buffer: PTextBuffer; callback: TClipboardRichTextReceivedFunc; 
                                      user_data: gpointer) {.cdecl, 
    importc: "gtk_clipboard_request_rich_text", dynlib: lib.}
proc request_image*(clipboard: PClipboard; 
                                  callback: TClipboardImageReceivedFunc; 
                                  user_data: gpointer) {.cdecl, 
    importc: "gtk_clipboard_request_image", dynlib: lib.}
proc request_uris*(clipboard: PClipboard; 
                                 callback: TClipboardURIReceivedFunc; 
                                 user_data: gpointer) {.cdecl, 
    importc: "gtk_clipboard_request_uris", dynlib: lib.}
proc request_targets*(clipboard: PClipboard; callback: TClipboardTargetsReceivedFunc; 
                                    user_data: gpointer) {.cdecl, 
    importc: "gtk_clipboard_request_targets", dynlib: lib.}
proc wait_for_contents*(clipboard: PClipboard; 
                                      target: TGdkAtom): PSelectionData {.
    cdecl, importc: "gtk_clipboard_wait_for_contents", dynlib: lib.}
proc wait_for_text*(clipboard: PClipboard): CSTRING {.
    cdecl, importc: "gtk_clipboard_wait_for_text", dynlib: lib.}
proc wait_for_rich_text*(clipboard: PClipboard; 
    buffer: PTextBuffer; format: PGdkAtom; length: Pgsize): Pguint8 {.
    cdecl, importc: "gtk_clipboard_wait_for_rich_text", dynlib: lib.}
proc wait_for_image*(clipboard: PClipboard): PPixbuf {.
    cdecl, importc: "gtk_clipboard_wait_for_image", dynlib: lib.}
proc wait_for_uris*(clipboard: PClipboard): ptr CSTRING {.
    cdecl, importc: "gtk_clipboard_wait_for_uris", dynlib: lib.}
proc wait_for_targets*(clipboard: PClipboard; 
                                     targets: ptr PGdkAtom; 
                                     n_targets: Pgint): gboolean {.cdecl, 
    importc: "gtk_clipboard_wait_for_targets", dynlib: lib.}
proc wait_is_text_available*(clipboard: PClipboard): gboolean {.
    cdecl, importc: "gtk_clipboard_wait_is_text_available", dynlib: lib.}
proc wait_is_rich_text_available*(clipboard: PClipboard; 
    buffer: PTextBuffer): gboolean {.cdecl, 
    importc: "gtk_clipboard_wait_is_rich_text_available", dynlib: lib.}
proc wait_is_image_available*(clipboard: PClipboard): gboolean {.
    cdecl, importc: "gtk_clipboard_wait_is_image_available", dynlib: lib.}
proc wait_is_uris_available*(clipboard: PClipboard): gboolean {.
    cdecl, importc: "gtk_clipboard_wait_is_uris_available", dynlib: lib.}
proc wait_is_target_available*(clipboard: PClipboard; 
    target: TGdkAtom): gboolean {.cdecl, importc: "gtk_clipboard_wait_is_target_available", 
                                 dynlib: lib.}
proc set_can_store*(clipboard: PClipboard; 
                                  targets: PTargetEntry; n_targets: gint) {.
    cdecl, importc: "gtk_clipboard_set_can_store", dynlib: lib.}
proc store*(clipboard: PClipboard) {.cdecl, 
    importc: "gtk_clipboard_store", dynlib: lib.}
proc underscore_gtk_clipboard_handle_event*(event: PEventOwnerChange) {.cdecl, 
    importc: "_gtk_clipboard_handle_event", dynlib: lib.}
proc underscore_gtk_clipboard_store_all*() {.cdecl, importc: "_gtk_clipboard_store_all", 
                                   dynlib: lib.}

template TYPE_COLOR_BUTTON*(): expr = 
  (gtk_color_button_get_type())

template COLOR_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_COLOR_BUTTON, TColorButton))

template COLOR_BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_COLOR_BUTTON, TColorButtonClass))

template IS_COLOR_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_COLOR_BUTTON))

template IS_COLOR_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_COLOR_BUTTON))

template COLOR_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_COLOR_BUTTON, TColorButtonClass))

type 
  PColorButton* = ptr TColorButton
  TColorButton* = object of TButton
    priv63: PColorButtonPrivate

type 
  PColorButtonClass* = ptr TColorButtonClass
  TColorButtonClass* = object of TButtonClass
    color_set*: proc (cp: PColorButton) {.cdecl.}
    ugtk_reserved581: proc () {.cdecl.}
    ugtk_reserved582: proc () {.cdecl.}
    ugtk_reserved583: proc () {.cdecl.}
    ugtk_reserved584: proc () {.cdecl.}

proc color_button_get_type*(): GType {.cdecl, 
    importc: "gtk_color_button_get_type", dynlib: lib.}
proc color_button_new*(): PWidget {.cdecl, 
    importc: "gtk_color_button_new", dynlib: lib.}
proc color_button_new_with_rgba*(rgba: PRGBA): PWidget {.
    cdecl, importc: "gtk_color_button_new_with_rgba", dynlib: lib.}
proc set_title*(button: PColorButton; title: CSTRING) {.
    cdecl, importc: "gtk_color_button_set_title", dynlib: lib.}
proc get_title*(button: PColorButton): CSTRING {.
    cdecl, importc: "gtk_color_button_get_title", dynlib: lib.}
proc button_new_with_color*(color: gdk3.PColor): PWidget {.
    cdecl, importc: "gtk_color_button_new_with_color", dynlib: lib.}
proc set_color*(button: PColorButton; 
                                 color: gdk3.PColor) {.cdecl, 
    importc: "gtk_color_button_set_color", dynlib: lib.}
proc get_color*(button: PColorButton; 
                                 color: gdk3.PColor) {.cdecl, 
    importc: "gtk_color_button_get_color", dynlib: lib.}
proc set_alpha*(button: PColorButton; alpha: guint16) {.
    cdecl, importc: "gtk_color_button_set_alpha", dynlib: lib.}
proc get_alpha*(button: PColorButton): guint16 {.cdecl, 
    importc: "gtk_color_button_get_alpha", dynlib: lib.}
proc set_use_alpha*(button: PColorButton; 
                                     use_alpha: gboolean) {.cdecl, 
    importc: "gtk_color_button_set_use_alpha", dynlib: lib.}
proc get_use_alpha*(button: PColorButton): gboolean {.
    cdecl, importc: "gtk_color_button_get_use_alpha", dynlib: lib.}
proc set_rgba*(button: PColorButton; rgba: PRGBA) {.
    cdecl, importc: "gtk_color_button_set_rgba", dynlib: lib.}
proc get_rgba*(button: PColorButton; rgba: PRGBA) {.
    cdecl, importc: "gtk_color_button_get_rgba", dynlib: lib.}

template TYPE_COLOR_CHOOSER*(): expr = 
  (gtk_color_chooser_get_type())

template COLOR_CHOOSER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_COLOR_CHOOSER, TColorChooser))

template IS_COLOR_CHOOSER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_COLOR_CHOOSER))

template COLOR_CHOOSER_GET_IFACE*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((inst), TYPE_COLOR_CHOOSER, 
                                 TColorChooserInterface))

type 
  PColorChooserInterface* = ptr TColorChooserInterface
  TColorChooserInterface* = object of TGTypeInterface
    get_rgba*: proc (chooser: PColorChooser; color: PRGBA) {.cdecl.}
    set_rgba*: proc (chooser: PColorChooser; color: PRGBA) {.cdecl.}
    add_palette*: proc (chooser: PColorChooser; 
                        orientation: TOrientation; colors_per_line: gint; 
                        n_colors: gint; colors: PRGBA) {.cdecl.}
    color_activated*: proc (chooser: PColorChooser; color: PRGBA) {.
        cdecl.}
    padding*: array[12, gpointer]

proc color_chooser_get_type*(): GType {.cdecl, 
    importc: "gtk_color_chooser_get_type", dynlib: lib.}
proc get_rgba*(chooser: PColorChooser; 
                                 color: PRGBA) {.cdecl, 
    importc: "gtk_color_chooser_get_rgba", dynlib: lib.}
proc set_rgba*(chooser: PColorChooser; 
                                 color: PRGBA) {.cdecl, 
    importc: "gtk_color_chooser_set_rgba", dynlib: lib.}
proc get_use_alpha*(chooser: PColorChooser): gboolean {.
    cdecl, importc: "gtk_color_chooser_get_use_alpha", dynlib: lib.}
proc set_use_alpha*(chooser: PColorChooser; 
                                      use_alpha: gboolean) {.cdecl, 
    importc: "gtk_color_chooser_set_use_alpha", dynlib: lib.}
proc add_palette*(chooser: PColorChooser; 
                                    orientation: TOrientation; 
                                    colors_per_line: gint; n_colors: gint; 
                                    colors: PRGBA) {.cdecl, 
    importc: "gtk_color_chooser_add_palette", dynlib: lib.}

template TYPE_COLOR_CHOOSER_DIALOG*(): expr = 
  (gtk_color_chooser_dialog_get_type())

template COLOR_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_COLOR_CHOOSER_DIALOG, 
                              TColorChooserDialog))

template COLOR_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_COLOR_CHOOSER_DIALOG, 
                           TColorChooserDialogClass))

template IS_COLOR_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_COLOR_CHOOSER_DIALOG))

template IS_COLOR_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_COLOR_CHOOSER_DIALOG))

template COLOR_CHOOSER_DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_COLOR_CHOOSER_DIALOG, 
                             TColorChooserDialogClass))

type 
  PColorChooserDialog* = ptr TColorChooserDialog
  TColorChooserDialog* = object of TDialog
    priv64: PColorChooserDialogPrivate

type 
  PColorChooserDialogClass* = ptr TColorChooserDialogClass
  TColorChooserDialogClass* = object of TDialogClass
    ugtk_reserved591: proc () {.cdecl.}
    ugtk_reserved592: proc () {.cdecl.}
    ugtk_reserved593: proc () {.cdecl.}
    ugtk_reserved594: proc () {.cdecl.}

proc color_chooser_dialog_get_type*(): GType {.cdecl, 
    importc: "gtk_color_chooser_dialog_get_type", dynlib: lib.}
proc color_chooser_dialog_new*(title: CSTRING; parent: PWindow): PWidget {.
    cdecl, importc: "gtk_color_chooser_dialog_new", dynlib: lib.}

template TYPE_COLOR_CHOOSER_WIDGET*(): expr = 
  (gtk_color_chooser_widget_get_type())

template COLOR_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_COLOR_CHOOSER_WIDGET, 
                              TColorChooserWidget))

template COLOR_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_COLOR_CHOOSER_WIDGET, 
                           TColorChooserWidgetClass))

template IS_COLOR_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_COLOR_CHOOSER_WIDGET))

template IS_COLOR_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_COLOR_CHOOSER_WIDGET))

template COLOR_CHOOSER_WIDGET_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_COLOR_CHOOSER_WIDGET, 
                             TColorChooserWidgetClass))

type 
  PColorChooserWidget* = ptr TColorChooserWidget
  TColorChooserWidget* = object of TBox
    priv65: PColorChooserWidgetPrivate

type 
  PColorChooserWidgetClass* = ptr TColorChooserWidgetClass
  TColorChooserWidgetClass* = object of TBoxClass
    ugtk_reserved601: proc () {.cdecl.}
    ugtk_reserved602: proc () {.cdecl.}
    ugtk_reserved603: proc () {.cdecl.}
    ugtk_reserved604: proc () {.cdecl.}
    ugtk_reserved605: proc () {.cdecl.}
    ugtk_reserved606: proc () {.cdecl.}
    ugtk_reserved607: proc () {.cdecl.}
    ugtk_reserved608: proc () {.cdecl.}

proc color_chooser_widget_get_type*(): GType {.cdecl, 
    importc: "gtk_color_chooser_widget_get_type", dynlib: lib.}
proc color_chooser_widget_new*(): PWidget {.cdecl, 
    importc: "gtk_color_chooser_widget_new", dynlib: lib.}

proc hsv_to_rgb*(h: gdouble; s: gdouble; v: gdouble; r: Pgdouble; 
                     g: Pgdouble; b: Pgdouble) {.cdecl, 
    importc: "gtk_hsv_to_rgb", dynlib: lib.}
proc rgb_to_hsv*(r: gdouble; g: gdouble; b: gdouble; h: Pgdouble; 
                     s: Pgdouble; v: Pgdouble) {.cdecl, 
    importc: "gtk_rgb_to_hsv", dynlib: lib.}

template TYPE_COMBO_BOX_TEXT*(): expr = 
  (gtk_combo_box_text_get_type())

template COMBO_BOX_TEXT_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_COMBO_BOX_TEXT, TComboBoxText))

template COMBO_BOX_TEXT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_COMBO_BOX_TEXT, 
                           TComboBoxTextClass))

template IS_COMBO_BOX_TEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_COMBO_BOX_TEXT))

template IS_COMBO_BOX_TEXT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_COMBO_BOX_TEXT))

template COMBO_BOX_TEXT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_COMBO_BOX_TEXT, 
                             TComboBoxTextClass))

type 
  PComboBoxText* = ptr TComboBoxText
  TComboBoxText* = object of TComboBox
    priv66: PComboBoxTextPrivate

type 
  PComboBoxTextClass* = ptr TComboBoxTextClass
  TComboBoxTextClass* = object of TComboBoxClass
    ugtk_reserved611: proc () {.cdecl.}
    ugtk_reserved612: proc () {.cdecl.}
    ugtk_reserved613: proc () {.cdecl.}
    ugtk_reserved614: proc () {.cdecl.}

proc combo_box_text_get_type*(): GType {.cdecl, 
    importc: "gtk_combo_box_text_get_type", dynlib: lib.}
proc combo_box_text_new*(): PWidget {.cdecl, 
    importc: "gtk_combo_box_text_new", dynlib: lib.}
proc combo_box_text_new_with_entry*(): PWidget {.cdecl, 
    importc: "gtk_combo_box_text_new_with_entry", dynlib: lib.}
proc append_text*(combo_box: PComboBoxText; 
                                     text: CSTRING) {.cdecl, 
    importc: "gtk_combo_box_text_append_text", dynlib: lib.}
proc insert_text*(combo_box: PComboBoxText; 
                                     position: gint; text: CSTRING) {.cdecl, 
    importc: "gtk_combo_box_text_insert_text", dynlib: lib.}
proc prepend_text*(combo_box: PComboBoxText; 
                                      text: CSTRING) {.cdecl, 
    importc: "gtk_combo_box_text_prepend_text", dynlib: lib.}
proc remove*(combo_box: PComboBoxText; position: gint) {.
    cdecl, importc: "gtk_combo_box_text_remove", dynlib: lib.}
proc remove_all*(combo_box: PComboBoxText) {.cdecl, 
    importc: "gtk_combo_box_text_remove_all", dynlib: lib.}
proc get_active_text*(combo_box: PComboBoxText): CSTRING {.
    cdecl, importc: "gtk_combo_box_text_get_active_text", dynlib: lib.}
proc insert*(combo_box: PComboBoxText; 
                                position: gint; id: CSTRING; text: CSTRING) {.
    cdecl, importc: "gtk_combo_box_text_insert", dynlib: lib.}
proc append*(combo_box: PComboBoxText; id: CSTRING; 
                                text: CSTRING) {.cdecl, 
    importc: "gtk_combo_box_text_append", dynlib: lib.}
proc prepend*(combo_box: PComboBoxText; 
                                 id: CSTRING; text: CSTRING) {.cdecl, 
    importc: "gtk_combo_box_text_prepend", dynlib: lib.}

template TYPE_CSS_SECTION*(): expr = 
  (gtk_css_section_get_type())

type 
  TCssSectionType* {.size: sizeof(cint).} = enum 
    CSS_SECTION_DOCUMENT, CSS_SECTION_IMPORT, 
    CSS_SECTION_COLOR_DEFINITION, CSS_SECTION_BINDING_SET, 
    CSS_SECTION_RULESET, CSS_SECTION_SELECTOR, 
    CSS_SECTION_DECLARATION, CSS_SECTION_VALUE, 
    CSS_SECTION_KEYFRAMES
proc css_section_get_type*(): GType {.cdecl, 
    importc: "gtk_css_section_get_type", dynlib: lib.}
proc re*(section: PCssSection): PCssSection {.
    cdecl, importc: "gtk_css_section_ref", dynlib: lib.}
proc unref*(section: PCssSection) {.cdecl, 
    importc: "gtk_css_section_unref", dynlib: lib.}
proc get_section_type*(section: PCssSection): TCssSectionType {.
    cdecl, importc: "gtk_css_section_get_section_type", dynlib: lib.}
proc get_parent*(section: PCssSection): PCssSection {.
    cdecl, importc: "gtk_css_section_get_parent", dynlib: lib.}
proc get_file*(section: PCssSection): PGFile {.cdecl, 
    importc: "gtk_css_section_get_file", dynlib: lib.}
proc get_start_line*(section: PCssSection): guint {.
    cdecl, importc: "gtk_css_section_get_start_line", dynlib: lib.}
proc get_start_position*(section: PCssSection): guint {.
    cdecl, importc: "gtk_css_section_get_start_position", dynlib: lib.}
proc get_end_line*(section: PCssSection): guint {.cdecl, 
    importc: "gtk_css_section_get_end_line", dynlib: lib.}
proc get_end_position*(section: PCssSection): guint {.
    cdecl, importc: "gtk_css_section_get_end_position", dynlib: lib.}

template TYPE_CSS_PROVIDER*(): expr = 
  (gtk_css_provider_get_type())

template CSS_PROVIDER_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_CSS_PROVIDER, TCssProvider))

template CSS_PROVIDER_CLASS_TEMPLATE*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((c), TYPE_CSS_PROVIDER, TCssProviderClass))

template IS_CSS_PROVIDER*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_CSS_PROVIDER))

template IS_CSS_PROVIDER_CLASS*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_CSS_PROVIDER))

template CSS_PROVIDER_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_CSS_PROVIDER, TCssProviderClass))

template CSS_PROVIDER_ERROR*(): expr = 
  (gtk_css_provider_error_quark())

type 
  TCssProviderError* {.size: sizeof(cint).} = enum 
    CSS_PROVIDER_ERROR_FAILED, CSS_PROVIDER_ERROR_SYNTAX, 
    CSS_PROVIDER_ERROR_IMPORT, CSS_PROVIDER_ERROR_NAME, 
    CSS_PROVIDER_ERROR_DEPRECATED, CSS_PROVIDER_ERROR_UNKNOWN_VALUE
proc css_provider_error_quark*(): TGQuark {.cdecl, 
    importc: "gtk_css_provider_error_quark", dynlib: lib.}
type 
  PCssProvider* = ptr TCssProvider
  TCssProvider* = object of TGObject
    priv67: PCssProviderPrivate

type 
  PCssProviderClass* = ptr TCssProviderClass
  TCssProviderClass* = object of TGObjectClass
    parsing_error*: proc (provider: PCssProvider; 
                          section: PCssSection; error: PGError) {.
        cdecl.}
    ugtk_reserved622: proc () {.cdecl.}
    ugtk_reserved623: proc () {.cdecl.}
    ugtk_reserved624: proc () {.cdecl.}

proc css_provider_get_type*(): GType {.cdecl, 
    importc: "gtk_css_provider_get_type", dynlib: lib.}
proc css_provider_new*(): PCssProvider {.cdecl, 
    importc: "gtk_css_provider_new", dynlib: lib.}
proc to_string*(provider: PCssProvider): cstring {.
    cdecl, importc: "gtk_css_provider_to_string", dynlib: lib.}
proc load_from_data*(css_provider: PCssProvider; 
                                      data: CSTRING; length: gssize; 
                                      error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_css_provider_load_from_data", dynlib: lib.}
proc load_from_file*(css_provider: PCssProvider; 
                                      file: PGFile; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_css_provider_load_from_file", dynlib: lib.}
proc load_from_path*(css_provider: PCssProvider; 
                                      path: CSTRING; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_css_provider_load_from_path", dynlib: lib.}
proc css_provider_get_default*(): PCssProvider {.cdecl, 
    importc: "gtk_css_provider_get_default", dynlib: lib.}
proc css_provider_get_named*(name: CSTRING; variant: CSTRING): PCssProvider {.
    cdecl, importc: "gtk_css_provider_get_named", dynlib: lib.}

type 
  TDebugFlag* {.size: sizeof(cint).} = enum 
    DEBUG_MISC = 1 shl 0, DEBUG_PLUGSOCKET = 1 shl 1, 
    DEBUG_TEXT = 1 shl 2, DEBUG_TREE = 1 shl 3, 
    DEBUG_UPDATES = 1 shl 4, DEBUG_KEYBINDINGS = 1 shl 5, 
    DEBUG_MULTIHEAD = 1 shl 6, DEBUG_MODULES = 1 shl 7, 
    DEBUG_GEOMETRY = 1 shl 8, DEBUG_ICONTHEME = 1 shl 9, 
    DEBUG_PRINTING = 1 shl 10, DEBUG_BUILDER = 1 shl 11, 
    DEBUG_SIZE_REQUEST = 1 shl 12, DEBUG_NO_CSS_CACHE = 1 shl 13, 
    DEBUG_BASELINES = 1 shl 14, DEBUG_PIXEL_CACHE = 1 shl 15, 
    DEBUG_NO_PIXEL_CACHE = 1 shl 16
proc get_debug_flags*(): guint {.cdecl, importc: "gtk_get_debug_flags", 
                                     dynlib: lib.}
proc set_debug_flags*(flags: guint) {.cdecl, 
    importc: "gtk_set_debug_flags", dynlib: lib.}

template TYPE_DRAWING_AREA*(): expr = 
  (gtk_drawing_area_get_type())

template DRAWING_AREA_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_DRAWING_AREA, TDrawingArea))

template DRAWING_AREA_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_DRAWING_AREA, TDrawingAreaClass))

template IS_DRAWING_AREA*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_DRAWING_AREA))

template IS_DRAWING_AREA_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_DRAWING_AREA))

template DRAWING_AREA_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_DRAWING_AREA, TDrawingAreaClass))

type 
  PDrawingArea* = ptr TDrawingArea
  TDrawingArea* = object of TWidget
    dummy*: gpointer

type 
  PDrawingAreaClass* = ptr TDrawingAreaClass
  TDrawingAreaClass* = object of TWidgetClass
    ugtk_reserved631: proc () {.cdecl.}
    ugtk_reserved632: proc () {.cdecl.}
    ugtk_reserved633: proc () {.cdecl.}
    ugtk_reserved634: proc () {.cdecl.}

proc drawing_area_get_type*(): GType {.cdecl, 
    importc: "gtk_drawing_area_get_type", dynlib: lib.}
proc drawing_area_new*(): PWidget {.cdecl, 
    importc: "gtk_drawing_area_new", dynlib: lib.}

template TYPE_EVENT_BOX*(): expr = 
  (gtk_event_box_get_type())

template EVENT_BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_EVENT_BOX, TEventBox))

template EVENT_BOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_EVENT_BOX, TEventBoxClass))

template IS_EVENT_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_EVENT_BOX))

template IS_EVENT_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_EVENT_BOX))

template EVENT_BOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_EVENT_BOX, TEventBoxClass))

type 
  PEventBox* = ptr TEventBox
  TEventBox* = object of TBin
    priv68: PEventBoxPrivate

type 
  PEventBoxClass* = ptr TEventBoxClass
  TEventBoxClass* = object of TBinClass
    ugtk_reserved641: proc () {.cdecl.}
    ugtk_reserved642: proc () {.cdecl.}
    ugtk_reserved643: proc () {.cdecl.}
    ugtk_reserved644: proc () {.cdecl.}

proc event_box_get_type*(): GType {.cdecl, 
    importc: "gtk_event_box_get_type", dynlib: lib.}
proc event_box_new*(): PWidget {.cdecl, 
    importc: "gtk_event_box_new", dynlib: lib.}
proc get_visible_window*(event_box: PEventBox): gboolean {.
    cdecl, importc: "gtk_event_box_get_visible_window", dynlib: lib.}
proc set_visible_window*(event_box: PEventBox; 
    visible_window: gboolean) {.cdecl, 
                                importc: "gtk_event_box_set_visible_window", 
                                dynlib: lib.}
proc get_above_child*(event_box: PEventBox): gboolean {.
    cdecl, importc: "gtk_event_box_get_above_child", dynlib: lib.}
proc set_above_child*(event_box: PEventBox; 
                                    above_child: gboolean) {.cdecl, 
    importc: "gtk_event_box_set_above_child", dynlib: lib.}

template TYPE_EXPANDER*(): expr = 
  (gtk_expander_get_type())

template EXPANDER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_EXPANDER, TExpander))

template EXPANDER_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_EXPANDER, TExpanderClass))

template IS_EXPANDER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_EXPANDER))

template IS_EXPANDER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_EXPANDER))

template EXPANDER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_EXPANDER, TExpanderClass))

type 
  PExpander* = ptr TExpander
  TExpander* = object of TBin
    priv69: PExpanderPrivate

type 
  PExpanderClass* = ptr TExpanderClass
  TExpanderClass* = object of TBinClass
    activate*: proc (expander: PExpander) {.cdecl.}
    ugtk_reserved651: proc () {.cdecl.}
    ugtk_reserved652: proc () {.cdecl.}
    ugtk_reserved653: proc () {.cdecl.}
    ugtk_reserved654: proc () {.cdecl.}

proc expander_get_type*(): GType {.cdecl, 
    importc: "gtk_expander_get_type", dynlib: lib.}
proc expander_new*(label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_expander_new", dynlib: lib.}
proc expander_new_with_mnemonic*(label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_expander_new_with_mnemonic", dynlib: lib.}
proc set_expanded*(expander: PExpander; expanded: gboolean) {.
    cdecl, importc: "gtk_expander_set_expanded", dynlib: lib.}
proc get_expanded*(expander: PExpander): gboolean {.cdecl, 
    importc: "gtk_expander_get_expanded", dynlib: lib.}
proc set_spacing*(expander: PExpander; spacing: gint) {.
    cdecl, importc: "gtk_expander_set_spacing", dynlib: lib.}
proc get_spacing*(expander: PExpander): gint {.cdecl, 
    importc: "gtk_expander_get_spacing", dynlib: lib.}
proc set_label*(expander: PExpander; label: CSTRING) {.
    cdecl, importc: "gtk_expander_set_label", dynlib: lib.}
proc get_label*(expander: PExpander): CSTRING {.cdecl, 
    importc: "gtk_expander_get_label", dynlib: lib.}
proc set_use_underline*(expander: PExpander; 
                                     use_underline: gboolean) {.cdecl, 
    importc: "gtk_expander_set_use_underline", dynlib: lib.}
proc get_use_underline*(expander: PExpander): gboolean {.
    cdecl, importc: "gtk_expander_get_use_underline", dynlib: lib.}
proc set_use_markup*(expander: PExpander; 
                                  use_markup: gboolean) {.cdecl, 
    importc: "gtk_expander_set_use_markup", dynlib: lib.}
proc get_use_markup*(expander: PExpander): gboolean {.
    cdecl, importc: "gtk_expander_get_use_markup", dynlib: lib.}
proc set_label_widget*(expander: PExpander; 
                                    label_widget: PWidget) {.cdecl, 
    importc: "gtk_expander_set_label_widget", dynlib: lib.}
proc get_label_widget*(expander: PExpander): PWidget {.
    cdecl, importc: "gtk_expander_get_label_widget", dynlib: lib.}
proc set_label_fill*(expander: PExpander; 
                                  label_fill: gboolean) {.cdecl, 
    importc: "gtk_expander_set_label_fill", dynlib: lib.}
proc get_label_fill*(expander: PExpander): gboolean {.
    cdecl, importc: "gtk_expander_get_label_fill", dynlib: lib.}
proc set_resize_toplevel*(expander: PExpander; 
    resize_toplevel: gboolean) {.cdecl, 
                                 importc: "gtk_expander_set_resize_toplevel", 
                                 dynlib: lib.}
proc get_resize_toplevel*(expander: PExpander): gboolean {.
    cdecl, importc: "gtk_expander_get_resize_toplevel", dynlib: lib.}

template TYPE_FIXED*(): expr = 
  (gtk_fixed_get_type())

template FIXED_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FIXED, TFixed))

template FIXED_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FIXED, TFixedClass))

template IS_FIXED*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FIXED))

template IS_FIXED_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FIXED))

template FIXED_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FIXED, TFixedClass))

type 
  PFixed* = ptr TFixed
  TFixed* = object of TContainer
    priv70: PFixedPrivate

type 
  PFixedClass* = ptr TFixedClass
  TFixedClass* = object of TContainerClass
    ugtk_reserved661: proc () {.cdecl.}
    ugtk_reserved662: proc () {.cdecl.}
    ugtk_reserved663: proc () {.cdecl.}
    ugtk_reserved664: proc () {.cdecl.}

type 
  PFixedChild* = ptr TFixedChild
  TFixedChild* = object of PWidget
    x*: gint
    y*: gint

proc fixed_get_type*(): GType {.cdecl, importc: "gtk_fixed_get_type", 
                                    dynlib: lib.}
proc fixed_new*(): PWidget {.cdecl, importc: "gtk_fixed_new", 
    dynlib: lib.}
proc put*(fixed: PFixed; widget: PWidget; x: gint; 
                    y: gint) {.cdecl, importc: "gtk_fixed_put", dynlib: lib.}
proc move*(fixed: PFixed; widget: PWidget; x: gint; 
                     y: gint) {.cdecl, importc: "gtk_fixed_move", dynlib: lib.}

template TYPE_FILE_FILTER*(): expr = 
  (gtk_file_filter_get_type())

template FILE_FILTER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FILE_FILTER, TFileFilter))

template IS_FILE_FILTER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FILE_FILTER))

type 
  TFileFilterFlags* {.size: sizeof(cint).} = enum 
    FILE_FILTER_FILENAME = 1 shl 0, FILE_FILTER_URI = 1 shl 1, 
    FILE_FILTER_DISPLAY_NAME = 1 shl 2, 
    FILE_FILTER_MIME_TYPE = 1 shl 3
type 
  PFileFilterInfo* = ptr TFileFilterInfo
  TFileFilterInfo*{.final, pure.} = object 
    contains*: TFileFilterFlags
    filename*: CSTRING
    uri*: CSTRING
    display_name*: CSTRING
    mime_type*: CSTRING
type 
  TFileFilterFunc* = proc (filter_info: PFileFilterInfo; 
                             data: gpointer): gboolean {.cdecl.}

proc file_filter_get_type*(): GType {.cdecl, 
    importc: "gtk_file_filter_get_type", dynlib: lib.}
proc file_filter_new*(): PFileFilter {.cdecl, 
    importc: "gtk_file_filter_new", dynlib: lib.}
proc set_name*(filter: PFileFilter; name: CSTRING) {.
    cdecl, importc: "gtk_file_filter_set_name", dynlib: lib.}
proc get_name*(filter: PFileFilter): CSTRING {.cdecl, 
    importc: "gtk_file_filter_get_name", dynlib: lib.}
proc add_mime_type*(filter: PFileFilter; 
                                    mime_type: CSTRING) {.cdecl, 
    importc: "gtk_file_filter_add_mime_type", dynlib: lib.}
proc add_pattern*(filter: PFileFilter; 
                                  pattern: CSTRING) {.cdecl, 
    importc: "gtk_file_filter_add_pattern", dynlib: lib.}
proc add_pixbuf_formats*(filter: PFileFilter) {.cdecl, 
    importc: "gtk_file_filter_add_pixbuf_formats", dynlib: lib.}
proc add_custom*(filter: PFileFilter; 
                                 needed: TFileFilterFlags; 
                                 func: TFileFilterFunc; data: gpointer; 
                                 notify: TGDestroyNotify) {.cdecl, 
    importc: "gtk_file_filter_add_custom", dynlib: lib.}
proc get_needed*(filter: PFileFilter): TFileFilterFlags {.
    cdecl, importc: "gtk_file_filter_get_needed", dynlib: lib.}
proc filter*(filter: PFileFilter; 
                             filter_info: PFileFilterInfo): gboolean {.
    cdecl, importc: "gtk_file_filter_filter", dynlib: lib.}

template TYPE_FILE_CHOOSER*(): expr = 
  (gtk_file_chooser_get_type())

template FILE_CHOOSER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FILE_CHOOSER, TFileChooser))

template IS_FILE_CHOOSER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FILE_CHOOSER))

type 
  TFileChooserAction* {.size: sizeof(cint).} = enum 
    FILE_CHOOSER_ACTION_OPEN, FILE_CHOOSER_ACTION_SAVE, 
    FILE_CHOOSER_ACTION_SELECT_FOLDER, 
    FILE_CHOOSER_ACTION_CREATE_FOLDER
type 
  TFileChooserConfirmation* {.size: sizeof(cint).} = enum 
    FILE_CHOOSER_CONFIRMATION_CONFIRM, 
    FILE_CHOOSER_CONFIRMATION_ACCEPT_FILENAME, 
    FILE_CHOOSER_CONFIRMATION_SELECT_AGAIN
proc file_chooser_get_type*(): GType {.cdecl, 
    importc: "gtk_file_chooser_get_type", dynlib: lib.}
template FILE_CHOOSER_ERROR*(): expr = 
  (gtk_file_chooser_error_quark())

type 
  TFileChooserError* {.size: sizeof(cint).} = enum 
    FILE_CHOOSER_ERROR_NONEXISTENT, FILE_CHOOSER_ERROR_BAD_FILENAME, 
    FILE_CHOOSER_ERROR_ALREADY_EXISTS, 
    FILE_CHOOSER_ERROR_INCOMPLETE_HOSTNAME
proc file_chooser_error_quark*(): TGQuark {.cdecl, 
    importc: "gtk_file_chooser_error_quark", dynlib: lib.}
proc set_action*(chooser: PFileChooser; 
                                  action: TFileChooserAction) {.cdecl, 
    importc: "gtk_file_chooser_set_action", dynlib: lib.}
proc get_action*(chooser: PFileChooser): TFileChooserAction {.
    cdecl, importc: "gtk_file_chooser_get_action", dynlib: lib.}
proc set_local_only*(chooser: PFileChooser; 
                                      local_only: gboolean) {.cdecl, 
    importc: "gtk_file_chooser_set_local_only", dynlib: lib.}
proc get_local_only*(chooser: PFileChooser): gboolean {.
    cdecl, importc: "gtk_file_chooser_get_local_only", dynlib: lib.}
proc set_select_multiple*(chooser: PFileChooser; 
    select_multiple: gboolean) {.cdecl, importc: "gtk_file_chooser_set_select_multiple", 
                                 dynlib: lib.}
proc get_select_multiple*(chooser: PFileChooser): gboolean {.
    cdecl, importc: "gtk_file_chooser_get_select_multiple", dynlib: lib.}
proc set_show_hidden*(chooser: PFileChooser; 
    show_hidden: gboolean) {.cdecl, 
                             importc: "gtk_file_chooser_set_show_hidden", 
                             dynlib: lib.}
proc get_show_hidden*(chooser: PFileChooser): gboolean {.
    cdecl, importc: "gtk_file_chooser_get_show_hidden", dynlib: lib.}
proc set_do_overwrite_confirmation*(
    chooser: PFileChooser; do_overwrite_confirmation: gboolean) {.cdecl, 
    importc: "gtk_file_chooser_set_do_overwrite_confirmation", dynlib: lib.}
proc get_do_overwrite_confirmation*(
    chooser: PFileChooser): gboolean {.cdecl, 
    importc: "gtk_file_chooser_get_do_overwrite_confirmation", dynlib: lib.}
proc set_create_folders*(chooser: PFileChooser; 
    create_folders: gboolean) {.cdecl, importc: "gtk_file_chooser_set_create_folders", 
                                dynlib: lib.}
proc get_create_folders*(chooser: PFileChooser): gboolean {.
    cdecl, importc: "gtk_file_chooser_get_create_folders", dynlib: lib.}
proc set_current_name*(chooser: PFileChooser; 
    name: CSTRING) {.cdecl, importc: "gtk_file_chooser_set_current_name", 
                       dynlib: lib.}
proc get_current_name*(chooser: PFileChooser): CSTRING {.
    cdecl, importc: "gtk_file_chooser_get_current_name", dynlib: lib.}
proc get_filename*(chooser: PFileChooser): CSTRING {.
    cdecl, importc: "gtk_file_chooser_get_filename", dynlib: lib.}
proc set_filename*(chooser: PFileChooser; 
                                    filename: cstring): gboolean {.cdecl, 
    importc: "gtk_file_chooser_set_filename", dynlib: lib.}
proc select_filename*(chooser: PFileChooser; 
    filename: cstring): gboolean {.cdecl, importc: "gtk_file_chooser_select_filename", 
                                   dynlib: lib.}
proc unselect_filename*(chooser: PFileChooser; 
    filename: cstring) {.cdecl, importc: "gtk_file_chooser_unselect_filename", 
                         dynlib: lib.}
proc select_all*(chooser: PFileChooser) {.cdecl, 
    importc: "gtk_file_chooser_select_all", dynlib: lib.}
proc unselect_all*(chooser: PFileChooser) {.cdecl, 
    importc: "gtk_file_chooser_unselect_all", dynlib: lib.}
proc get_filenames*(chooser: PFileChooser): PGSList {.
    cdecl, importc: "gtk_file_chooser_get_filenames", dynlib: lib.}
proc set_current_folder*(chooser: PFileChooser; 
    filename: CSTRING): gboolean {.cdecl, importc: "gtk_file_chooser_set_current_folder", 
                                     dynlib: lib.}
proc get_current_folder*(chooser: PFileChooser): CSTRING {.
    cdecl, importc: "gtk_file_chooser_get_current_folder", dynlib: lib.}
proc get_uri*(chooser: PFileChooser): CSTRING {.
    cdecl, importc: "gtk_file_chooser_get_uri", dynlib: lib.}
proc set_uri*(chooser: PFileChooser; uri: cstring): gboolean {.
    cdecl, importc: "gtk_file_chooser_set_uri", dynlib: lib.}
proc select_uri*(chooser: PFileChooser; uri: cstring): gboolean {.
    cdecl, importc: "gtk_file_chooser_select_uri", dynlib: lib.}
proc unselect_uri*(chooser: PFileChooser; uri: cstring) {.
    cdecl, importc: "gtk_file_chooser_unselect_uri", dynlib: lib.}
proc get_uris*(chooser: PFileChooser): PGSList {.
    cdecl, importc: "gtk_file_chooser_get_uris", dynlib: lib.}
proc set_current_folder_uri*(chooser: PFileChooser; 
    uri: CSTRING): gboolean {.cdecl, importc: "gtk_file_chooser_set_current_folder_uri", 
                                dynlib: lib.}
proc get_current_folder_uri*(chooser: PFileChooser): CSTRING {.
    cdecl, importc: "gtk_file_chooser_get_current_folder_uri", dynlib: lib.}
proc get_file*(chooser: PFileChooser): PGFile {.
    cdecl, importc: "gtk_file_chooser_get_file", dynlib: lib.}
proc set_file*(chooser: PFileChooser; file: PGFile; 
                                error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_file_chooser_set_file", dynlib: lib.}
proc select_file*(chooser: PFileChooser; 
                                   file: PGFile; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_file_chooser_select_file", dynlib: lib.}
proc unselect_file*(chooser: PFileChooser; 
                                     file: PGFile) {.cdecl, 
    importc: "gtk_file_chooser_unselect_file", dynlib: lib.}
proc get_files*(chooser: PFileChooser): PGSList {.
    cdecl, importc: "gtk_file_chooser_get_files", dynlib: lib.}
proc set_current_folder_file*(chooser: PFileChooser; 
    file: PGFile; error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_file_chooser_set_current_folder_file", dynlib: lib.}
proc get_current_folder_file*(chooser: PFileChooser): PGFile {.
    cdecl, importc: "gtk_file_chooser_get_current_folder_file", dynlib: lib.}
proc set_preview_widget*(chooser: PFileChooser; 
    preview_widget: PWidget) {.cdecl, importc: "gtk_file_chooser_set_preview_widget", 
                                     dynlib: lib.}
proc get_preview_widget*(chooser: PFileChooser): PWidget {.
    cdecl, importc: "gtk_file_chooser_get_preview_widget", dynlib: lib.}
proc set_preview_widget_active*(chooser: PFileChooser; 
    active: gboolean) {.cdecl, importc: "gtk_file_chooser_set_preview_widget_active", 
                        dynlib: lib.}
proc get_preview_widget_active*(chooser: PFileChooser): gboolean {.
    cdecl, importc: "gtk_file_chooser_get_preview_widget_active", dynlib: lib.}
proc set_use_preview_label*(chooser: PFileChooser; 
    use_label: gboolean) {.cdecl, 
                           importc: "gtk_file_chooser_set_use_preview_label", 
                           dynlib: lib.}
proc get_use_preview_label*(chooser: PFileChooser): gboolean {.
    cdecl, importc: "gtk_file_chooser_get_use_preview_label", dynlib: lib.}
proc get_preview_filename*(chooser: PFileChooser): cstring {.
    cdecl, importc: "gtk_file_chooser_get_preview_filename", dynlib: lib.}
proc get_preview_uri*(chooser: PFileChooser): cstring {.
    cdecl, importc: "gtk_file_chooser_get_preview_uri", dynlib: lib.}
proc get_preview_file*(chooser: PFileChooser): PGFile {.
    cdecl, importc: "gtk_file_chooser_get_preview_file", dynlib: lib.}
proc set_extra_widget*(chooser: PFileChooser; 
    extra_widget: PWidget) {.cdecl, importc: "gtk_file_chooser_set_extra_widget", 
                                   dynlib: lib.}
proc get_extra_widget*(chooser: PFileChooser): PWidget {.
    cdecl, importc: "gtk_file_chooser_get_extra_widget", dynlib: lib.}
proc add_filter*(chooser: PFileChooser; 
                                  filter: PFileFilter) {.cdecl, 
    importc: "gtk_file_chooser_add_filter", dynlib: lib.}
proc remove_filter*(chooser: PFileChooser; 
                                     filter: PFileFilter) {.cdecl, 
    importc: "gtk_file_chooser_remove_filter", dynlib: lib.}
proc list_filters*(chooser: PFileChooser): PGSList {.
    cdecl, importc: "gtk_file_chooser_list_filters", dynlib: lib.}
proc set_filter*(chooser: PFileChooser; 
                                  filter: PFileFilter) {.cdecl, 
    importc: "gtk_file_chooser_set_filter", dynlib: lib.}
proc get_filter*(chooser: PFileChooser): PFileFilter {.
    cdecl, importc: "gtk_file_chooser_get_filter", dynlib: lib.}
proc add_shortcut_folder*(chooser: PFileChooser; 
    folder: cstring; error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_file_chooser_add_shortcut_folder", dynlib: lib.}
proc remove_shortcut_folder*(chooser: PFileChooser; 
    folder: cstring; error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_file_chooser_remove_shortcut_folder", dynlib: lib.}
proc list_shortcut_folders*(chooser: PFileChooser): PGSList {.
    cdecl, importc: "gtk_file_chooser_list_shortcut_folders", dynlib: lib.}
proc add_shortcut_folder_uri*(chooser: PFileChooser; 
    uri: cstring; error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_file_chooser_add_shortcut_folder_uri", dynlib: lib.}
proc remove_shortcut_folder_uri*(chooser: PFileChooser; 
    uri: cstring; error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_file_chooser_remove_shortcut_folder_uri", dynlib: lib.}
proc list_shortcut_folder_uris*(chooser: PFileChooser): PGSList {.
    cdecl, importc: "gtk_file_chooser_list_shortcut_folder_uris", dynlib: lib.}

template TYPE_FILE_CHOOSER_BUTTON*(): expr = 
  (gtk_file_chooser_button_get_type())

template FILE_CHOOSER_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FILE_CHOOSER_BUTTON, 
                              TFileChooserButton))

template FILE_CHOOSER_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FILE_CHOOSER_BUTTON, 
                           TFileChooserButtonClass))

template IS_FILE_CHOOSER_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FILE_CHOOSER_BUTTON))

template IS_FILE_CHOOSER_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FILE_CHOOSER_BUTTON))

template FILE_CHOOSER_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FILE_CHOOSER_BUTTON, 
                             TFileChooserButtonClass))

type 
  PFileChooserButton* = ptr TFileChooserButton
  TFileChooserButton* = object of TBox
    priv71: PFileChooserButtonPrivate

type 
  PFileChooserButtonClass* = ptr TFileChooserButtonClass
  TFileChooserButtonClass* = object of TBoxClass
    file_set*: proc (fc: PFileChooserButton) {.cdecl.}
    uugtk_reserved1: gpointer
    uugtk_reserved2: gpointer
    uugtk_reserved3: gpointer
    uugtk_reserved4: gpointer

proc file_chooser_button_get_type*(): GType {.cdecl, 
    importc: "gtk_file_chooser_button_get_type", dynlib: lib.}
proc file_chooser_button_new*(title: CSTRING; 
                                  action: TFileChooserAction): PWidget {.
    cdecl, importc: "gtk_file_chooser_button_new", dynlib: lib.}
proc file_chooser_button_new_with_dialog*(dialog: PWidget): PWidget {.
    cdecl, importc: "gtk_file_chooser_button_new_with_dialog", dynlib: lib.}
proc get_title*(button: PFileChooserButton): CSTRING {.
    cdecl, importc: "gtk_file_chooser_button_get_title", dynlib: lib.}
proc set_title*(button: PFileChooserButton; 
    title: CSTRING) {.cdecl, importc: "gtk_file_chooser_button_set_title", 
                        dynlib: lib.}
proc get_width_chars*(button: PFileChooserButton): gint {.
    cdecl, importc: "gtk_file_chooser_button_get_width_chars", dynlib: lib.}
proc set_width_chars*(
    button: PFileChooserButton; n_chars: gint) {.cdecl, 
    importc: "gtk_file_chooser_button_set_width_chars", dynlib: lib.}
proc get_focus_on_click*(
    button: PFileChooserButton): gboolean {.cdecl, 
    importc: "gtk_file_chooser_button_get_focus_on_click", dynlib: lib.}
proc set_focus_on_click*(
    button: PFileChooserButton; focus_on_click: gboolean) {.cdecl, 
    importc: "gtk_file_chooser_button_set_focus_on_click", dynlib: lib.}

template TYPE_FILE_CHOOSER_DIALOG*(): expr = 
  (gtk_file_chooser_dialog_get_type())

template FILE_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FILE_CHOOSER_DIALOG, 
                              TFileChooserDialog))

template FILE_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FILE_CHOOSER_DIALOG, 
                           TFileChooserDialogClass))

template IS_FILE_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FILE_CHOOSER_DIALOG))

template IS_FILE_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FILE_CHOOSER_DIALOG))

template FILE_CHOOSER_DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FILE_CHOOSER_DIALOG, 
                             TFileChooserDialogClass))

type 
  PFileChooserDialog* = ptr TFileChooserDialog
  TFileChooserDialog* = object of TDialog
    priv72: PFileChooserDialogPrivate

type 
  PFileChooserDialogClass* = ptr TFileChooserDialogClass
  TFileChooserDialogClass* = object of TDialogClass
    ugtk_reserved671: proc () {.cdecl.}
    ugtk_reserved672: proc () {.cdecl.}
    ugtk_reserved673: proc () {.cdecl.}
    ugtk_reserved674: proc () {.cdecl.}

proc file_chooser_dialog_get_type*(): GType {.cdecl, 
    importc: "gtk_file_chooser_dialog_get_type", dynlib: lib.}
proc file_chooser_dialog_new*(title: CSTRING; parent: PWindow; 
                                  action: TFileChooserAction; 
                                  first_button_text: CSTRING): PWidget {.
    varargs, cdecl, importc: "gtk_file_chooser_dialog_new", dynlib: lib.}

template TYPE_FILE_CHOOSER_WIDGET*(): expr = 
  (gtk_file_chooser_widget_get_type())

template FILE_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FILE_CHOOSER_WIDGET, 
                              TFileChooserWidget))

template FILE_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FILE_CHOOSER_WIDGET, 
                           TFileChooserWidgetClass))

template IS_FILE_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FILE_CHOOSER_WIDGET))

template IS_FILE_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FILE_CHOOSER_WIDGET))

template FILE_CHOOSER_WIDGET_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FILE_CHOOSER_WIDGET, 
                             TFileChooserWidgetClass))

type 
  PFileChooserWidget* = ptr TFileChooserWidget
  TFileChooserWidget* = object of TBox
    priv73: PFileChooserWidgetPrivate

type 
  PFileChooserWidgetClass* = ptr TFileChooserWidgetClass
  TFileChooserWidgetClass* = object of TBoxClass
    ugtk_reserved681: proc () {.cdecl.}
    ugtk_reserved682: proc () {.cdecl.}
    ugtk_reserved683: proc () {.cdecl.}
    ugtk_reserved684: proc () {.cdecl.}

proc file_chooser_widget_get_type*(): GType {.cdecl, 
    importc: "gtk_file_chooser_widget_get_type", dynlib: lib.}
proc file_chooser_widget_new*(action: TFileChooserAction): PWidget {.
    cdecl, importc: "gtk_file_chooser_widget_new", dynlib: lib.}

template TYPE_FLOW_BOX*(): expr = 
  (gtk_flow_box_get_type())

template FLOW_BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FLOW_BOX, TFlowBox))

template FLOW_BOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FLOW_BOX, TFlowBoxClass))

template IS_FLOW_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FLOW_BOX))

template IS_FLOW_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FLOW_BOX))

template FLOW_BOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FLOW_BOX, TFlowBoxClass))

type 
  PFlowBox* = ptr TFlowBox
  TFlowBox* = object of TContainer

type 
  PFlowBoxChild* = ptr TFlowBoxChild
  TFlowBoxChild* = object of TBin

type 
  PFlowBoxClass* = ptr TFlowBoxClass
  TFlowBoxClass* = object of TContainerClass
    child_activated*: proc (box: PFlowBox; child: PFlowBoxChild) {.
        cdecl.}
    selected_children_changed*: proc (box: PFlowBox) {.cdecl.}
    activate_cursor_child*: proc (box: PFlowBox) {.cdecl.}
    toggle_cursor_child*: proc (box: PFlowBox) {.cdecl.}
    move_cursor*: proc (box: PFlowBox; step: TMovementStep; 
                        count: gint) {.cdecl.}
    select_all*: proc (box: PFlowBox) {.cdecl.}
    unselect_all*: proc (box: PFlowBox) {.cdecl.}
    ugtk_reserved691: proc () {.cdecl.}
    ugtk_reserved692: proc () {.cdecl.}
    ugtk_reserved693: proc () {.cdecl.}
    ugtk_reserved694: proc () {.cdecl.}
    ugtk_reserved695: proc () {.cdecl.}
    ugtk_reserved696: proc () {.cdecl.}

template TYPE_FLOW_BOX_CHILD*(): expr = 
  (gtk_flow_box_child_get_type())

template FLOW_BOX_CHILD_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FLOW_BOX_CHILD, TFlowBoxChild))

template FLOW_BOX_CHILD_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FLOW_BOX_CHILD, 
                           TFlowBoxChildClass))

template IS_FLOW_BOX_CHILD*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FLOW_BOX_CHILD))

template IS_FLOW_BOX_CHILD_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FLOW_BOX_CHILD))

template FLOW_BOX_CHILD_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), EG_TYPE_FLOW_BOX_CHILD, 
                             TFlowBoxChildClass))

type 
  PFlowBoxChildClass* = ptr TFlowBoxChildClass
  TFlowBoxChildClass* = object of TBinClass
    activate*: proc (child: PFlowBoxChild) {.cdecl.}
    ugtk_reserved701: proc () {.cdecl.}
    ugtk_reserved702: proc () {.cdecl.}

proc flow_box_child_get_type*(): GType {.cdecl, 
    importc: "gtk_flow_box_child_get_type", dynlib: lib.}
proc flow_box_child_new*(): PWidget {.cdecl, 
    importc: "gtk_flow_box_child_new", dynlib: lib.}
proc get_index*(child: PFlowBoxChild): gint {.cdecl, 
    importc: "gtk_flow_box_child_get_index", dynlib: lib.}
proc is_selected*(child: PFlowBoxChild): gboolean {.
    cdecl, importc: "gtk_flow_box_child_is_selected", dynlib: lib.}
proc changed*(child: PFlowBoxChild) {.cdecl, 
    importc: "gtk_flow_box_child_changed", dynlib: lib.}
proc flow_box_get_type*(): GType {.cdecl, 
    importc: "gtk_flow_box_get_type", dynlib: lib.}
proc flow_box_new*(): PWidget {.cdecl, importc: "gtk_flow_box_new", 
    dynlib: lib.}
proc set_homogeneous*(box: PFlowBox; homogeneous: gboolean) {.
    cdecl, importc: "gtk_flow_box_set_homogeneous", dynlib: lib.}
proc get_homogeneous*(box: PFlowBox): gboolean {.cdecl, 
    importc: "gtk_flow_box_get_homogeneous", dynlib: lib.}
proc set_row_spacing*(box: PFlowBox; spacing: guint) {.
    cdecl, importc: "gtk_flow_box_set_row_spacing", dynlib: lib.}
proc get_row_spacing*(box: PFlowBox): guint {.cdecl, 
    importc: "gtk_flow_box_get_row_spacing", dynlib: lib.}
proc set_column_spacing*(box: PFlowBox; spacing: guint) {.
    cdecl, importc: "gtk_flow_box_set_column_spacing", dynlib: lib.}
proc get_column_spacing*(box: PFlowBox): guint {.cdecl, 
    importc: "gtk_flow_box_get_column_spacing", dynlib: lib.}
proc set_min_children_per_line*(box: PFlowBox; 
    n_children: guint) {.cdecl, 
                         importc: "gtk_flow_box_set_min_children_per_line", 
                         dynlib: lib.}
proc get_min_children_per_line*(box: PFlowBox): guint {.
    cdecl, importc: "gtk_flow_box_get_min_children_per_line", dynlib: lib.}
proc set_max_children_per_line*(box: PFlowBox; 
    n_children: guint) {.cdecl, 
                         importc: "gtk_flow_box_set_max_children_per_line", 
                         dynlib: lib.}
proc get_max_children_per_line*(box: PFlowBox): guint {.
    cdecl, importc: "gtk_flow_box_get_max_children_per_line", dynlib: lib.}
proc set_activate_on_single_click*(box: PFlowBox; 
    single: gboolean) {.cdecl, 
                        importc: "gtk_flow_box_set_activate_on_single_click", 
                        dynlib: lib.}
proc get_activate_on_single_click*(box: PFlowBox): gboolean {.
    cdecl, importc: "gtk_flow_box_get_activate_on_single_click", dynlib: lib.}
proc insert*(box: PFlowBox; widget: PWidget; 
                          position: gint) {.cdecl, 
    importc: "gtk_flow_box_insert", dynlib: lib.}
proc get_child_at_index*(box: PFlowBox; idx: gint): PFlowBoxChild {.
    cdecl, importc: "gtk_flow_box_get_child_at_index", dynlib: lib.}
type 
  TFlowBoxForeachFunc* = proc (box: PFlowBox; 
                                 child: PFlowBoxChild; 
                                 user_data: gpointer) {.cdecl.}
proc selected_foreach*(box: PFlowBox; 
                                    func: TFlowBoxForeachFunc; 
                                    data: gpointer) {.cdecl, 
    importc: "gtk_flow_box_selected_foreach", dynlib: lib.}
proc get_selected_children*(box: PFlowBox): PGList {.
    cdecl, importc: "gtk_flow_box_get_selected_children", dynlib: lib.}
proc select_child*(box: PFlowBox; 
                                child: PFlowBoxChild) {.cdecl, 
    importc: "gtk_flow_box_select_child", dynlib: lib.}
proc unselect_child*(box: PFlowBox; 
                                  child: PFlowBoxChild) {.cdecl, 
    importc: "gtk_flow_box_unselect_child", dynlib: lib.}
proc select_all*(box: PFlowBox) {.cdecl, 
    importc: "gtk_flow_box_select_all", dynlib: lib.}
proc unselect_all*(box: PFlowBox) {.cdecl, 
    importc: "gtk_flow_box_unselect_all", dynlib: lib.}
proc set_selection_mode*(box: PFlowBox; 
                                      mode: TSelectionMode) {.cdecl, 
    importc: "gtk_flow_box_set_selection_mode", dynlib: lib.}
proc get_selection_mode*(box: PFlowBox): TSelectionMode {.
    cdecl, importc: "gtk_flow_box_get_selection_mode", dynlib: lib.}
proc set_hadjustment*(box: PFlowBox; 
                                   adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_flow_box_set_hadjustment", dynlib: lib.}
proc set_vadjustment*(box: PFlowBox; 
                                   adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_flow_box_set_vadjustment", dynlib: lib.}
type 
  TFlowBoxFilterFunc* = proc (child: PFlowBoxChild; 
                                user_data: gpointer): gboolean {.cdecl.}
proc set_filter_func*(box: PFlowBox; 
                                   filter_func: TFlowBoxFilterFunc; 
                                   user_data: gpointer; 
                                   destroy: TGDestroyNotify) {.cdecl, 
    importc: "gtk_flow_box_set_filter_func", dynlib: lib.}
proc invalidate_filter*(box: PFlowBox) {.cdecl, 
    importc: "gtk_flow_box_invalidate_filter", dynlib: lib.}
type 
  TFlowBoxSortFunc* = proc (child1: PFlowBoxChild; 
                              child2: PFlowBoxChild; user_data: gpointer): gint {.
      cdecl.}
proc set_sort_func*(box: PFlowBox; 
                                 sort_func: TFlowBoxSortFunc; 
                                 user_data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_flow_box_set_sort_func", dynlib: lib.}
proc invalidate_sort*(box: PFlowBox) {.cdecl, 
    importc: "gtk_flow_box_invalidate_sort", dynlib: lib.}

template TYPE_FONT_BUTTON*(): expr = 
  (gtk_font_button_get_type())

template FONT_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FONT_BUTTON, TFontButton))

template FONT_BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FONT_BUTTON, TFontButtonClass))

template IS_FONT_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FONT_BUTTON))

template IS_FONT_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FONT_BUTTON))

template FONT_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FONT_BUTTON, TFontButtonClass))

type 
  PFontButton* = ptr TFontButton
  TFontButton* = object of TButton
    priv74: PFontButtonPrivate

type 
  PFontButtonClass* = ptr TFontButtonClass
  TFontButtonClass* = object of TButtonClass
    font_set*: proc (gfp: PFontButton) {.cdecl.}
    ugtk_reserved711: proc () {.cdecl.}
    ugtk_reserved712: proc () {.cdecl.}
    ugtk_reserved713: proc () {.cdecl.}
    ugtk_reserved714: proc () {.cdecl.}

proc font_button_get_type*(): GType {.cdecl, 
    importc: "gtk_font_button_get_type", dynlib: lib.}
proc font_button_new*(): PWidget {.cdecl, 
    importc: "gtk_font_button_new", dynlib: lib.}
proc font_button_new_with_font*(fontname: CSTRING): PWidget {.
    cdecl, importc: "gtk_font_button_new_with_font", dynlib: lib.}
proc get_title*(font_button: PFontButton): CSTRING {.
    cdecl, importc: "gtk_font_button_get_title", dynlib: lib.}
proc set_title*(font_button: PFontButton; 
                                title: CSTRING) {.cdecl, 
    importc: "gtk_font_button_set_title", dynlib: lib.}
proc get_use_font*(font_button: PFontButton): gboolean {.
    cdecl, importc: "gtk_font_button_get_use_font", dynlib: lib.}
proc set_use_font*(font_button: PFontButton; 
                                   use_font: gboolean) {.cdecl, 
    importc: "gtk_font_button_set_use_font", dynlib: lib.}
proc get_use_size*(font_button: PFontButton): gboolean {.
    cdecl, importc: "gtk_font_button_get_use_size", dynlib: lib.}
proc set_use_size*(font_button: PFontButton; 
                                   use_size: gboolean) {.cdecl, 
    importc: "gtk_font_button_set_use_size", dynlib: lib.}
proc get_font_name*(font_button: PFontButton): CSTRING {.
    cdecl, importc: "gtk_font_button_get_font_name", dynlib: lib.}
proc set_font_name*(font_button: PFontButton; 
                                    fontname: CSTRING): gboolean {.cdecl, 
    importc: "gtk_font_button_set_font_name", dynlib: lib.}
proc get_show_style*(font_button: PFontButton): gboolean {.
    cdecl, importc: "gtk_font_button_get_show_style", dynlib: lib.}
proc set_show_style*(font_button: PFontButton; 
                                     show_style: gboolean) {.cdecl, 
    importc: "gtk_font_button_set_show_style", dynlib: lib.}
proc get_show_size*(font_button: PFontButton): gboolean {.
    cdecl, importc: "gtk_font_button_get_show_size", dynlib: lib.}
proc set_show_size*(font_button: PFontButton; 
                                    show_size: gboolean) {.cdecl, 
    importc: "gtk_font_button_set_show_size", dynlib: lib.}

type 
  TFontFilterFunc* = proc (family: PFontFamily; 
                             face: pango.PFontFace; data: gpointer): gboolean {.
      cdecl.}
template TYPE_FONT_CHOOSER*(): expr = 
  (gtk_font_chooser_get_type())

template FONT_CHOOSER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FONT_CHOOSER, TFontChooser))

template IS_FONT_CHOOSER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FONT_CHOOSER))

template FONT_CHOOSER_GET_IFACE*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((inst), TYPE_FONT_CHOOSER, 
                                 TFontChooserIface))

type 
  PFontChooserIface* = ptr TFontChooserIface
  TFontChooserIface* = object of TGTypeInterface
    get_font_family*: proc (fontchooser: PFontChooser): PFontFamily {.
        cdecl.}
    get_font_face*: proc (fontchooser: PFontChooser): pango.PFontFace {.
        cdecl.}
    get_font_size*: proc (fontchooser: PFontChooser): gint {.cdecl.}
    set_filter_func*: proc (fontchooser: PFontChooser; 
                            filter: TFontFilterFunc; user_data: gpointer; 
                            destroy: TGDestroyNotify) {.cdecl.}
    font_activated*: proc (chooser: PFontChooser; fontname: CSTRING) {.
        cdecl.}
    padding*: array[12, gpointer]

proc font_chooser_get_type*(): GType {.cdecl, 
    importc: "gtk_font_chooser_get_type", dynlib: lib.}
proc get_font_family*(fontchooser: PFontChooser): PFontFamily {.
    cdecl, importc: "gtk_font_chooser_get_font_family", dynlib: lib.}
proc get_font_face*(fontchooser: PFontChooser): pango.PFontFace {.
    cdecl, importc: "gtk_font_chooser_get_font_face", dynlib: lib.}
proc get_font_size*(fontchooser: PFontChooser): gint {.
    cdecl, importc: "gtk_font_chooser_get_font_size", dynlib: lib.}
proc get_font_desc*(fontchooser: PFontChooser): PFontDescription {.
    cdecl, importc: "gtk_font_chooser_get_font_desc", dynlib: lib.}
proc set_font_desc*(fontchooser: PFontChooser; 
                                     font_desc: PFontDescription) {.
    cdecl, importc: "gtk_font_chooser_set_font_desc", dynlib: lib.}
proc get_font*(fontchooser: PFontChooser): CSTRING {.
    cdecl, importc: "gtk_font_chooser_get_font", dynlib: lib.}
proc set_font*(fontchooser: PFontChooser; 
                                fontname: CSTRING) {.cdecl, 
    importc: "gtk_font_chooser_set_font", dynlib: lib.}
proc get_preview_text*(fontchooser: PFontChooser): CSTRING {.
    cdecl, importc: "gtk_font_chooser_get_preview_text", dynlib: lib.}
proc set_preview_text*(fontchooser: PFontChooser; 
    text: CSTRING) {.cdecl, importc: "gtk_font_chooser_set_preview_text", 
                       dynlib: lib.}
proc get_show_preview_entry*(fontchooser: PFontChooser): gboolean {.
    cdecl, importc: "gtk_font_chooser_get_show_preview_entry", dynlib: lib.}
proc set_show_preview_entry*(fontchooser: PFontChooser; 
    show_preview_entry: gboolean) {.cdecl, importc: "gtk_font_chooser_set_show_preview_entry", 
                                    dynlib: lib.}
proc set_filter_func*(fontchooser: PFontChooser; 
    filter: TFontFilterFunc; user_data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_font_chooser_set_filter_func", dynlib: lib.}

template TYPE_FONT_CHOOSER_DIALOG*(): expr = 
  (gtk_font_chooser_dialog_get_type())

template FONT_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FONT_CHOOSER_DIALOG, 
                              TFontChooserDialog))

template FONT_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FONT_CHOOSER_DIALOG, 
                           TFontChooserDialogClass))

template IS_FONT_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FONT_CHOOSER_DIALOG))

template IS_FONT_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FONT_CHOOSER_DIALOG))

template FONT_CHOOSER_DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FONT_CHOOSER_DIALOG, 
                             TFontChooserDialogClass))

type 
  PFontChooserDialog* = ptr TFontChooserDialog
  TFontChooserDialog* = object of TDialog
    priv75: PFontChooserDialogPrivate

type 
  PFontChooserDialogClass* = ptr TFontChooserDialogClass
  TFontChooserDialogClass* = object of TDialogClass
    ugtk_reserved721: proc () {.cdecl.}
    ugtk_reserved722: proc () {.cdecl.}
    ugtk_reserved723: proc () {.cdecl.}
    ugtk_reserved724: proc () {.cdecl.}

proc font_chooser_dialog_get_type*(): GType {.cdecl, 
    importc: "gtk_font_chooser_dialog_get_type", dynlib: lib.}
proc font_chooser_dialog_new*(title: CSTRING; parent: PWindow): PWidget {.
    cdecl, importc: "gtk_font_chooser_dialog_new", dynlib: lib.}

template TYPE_FONT_CHOOSER_WIDGET*(): expr = 
  (gtk_font_chooser_widget_get_type())

template FONT_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FONT_CHOOSER_WIDGET, 
                              TFontChooserWidget))

template FONT_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FONT_CHOOSER_WIDGET, 
                           TFontChooserWidgetClass))

template IS_FONT_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FONT_CHOOSER_WIDGET))

template IS_FONT_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FONT_CHOOSER_WIDGET))

template FONT_CHOOSER_WIDGET_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FONT_CHOOSER_WIDGET, 
                             TFontChooserWidgetClass))

type 
  PFontChooserWidget* = ptr TFontChooserWidget
  TFontChooserWidget* = object of TBox
    priv76: PFontChooserWidgetPrivate

type 
  PFontChooserWidgetClass* = ptr TFontChooserWidgetClass
  TFontChooserWidgetClass* = object of TBoxClass
    ugtk_reserved731: proc () {.cdecl.}
    ugtk_reserved732: proc () {.cdecl.}
    ugtk_reserved733: proc () {.cdecl.}
    ugtk_reserved734: proc () {.cdecl.}
    ugtk_reserved735: proc () {.cdecl.}
    ugtk_reserved736: proc () {.cdecl.}
    ugtk_reserved737: proc () {.cdecl.}
    ugtk_reserved738: proc () {.cdecl.}

proc font_chooser_widget_get_type*(): GType {.cdecl, 
    importc: "gtk_font_chooser_widget_get_type", dynlib: lib.}
proc font_chooser_widget_new*(): PWidget {.cdecl, 
    importc: "gtk_font_chooser_widget_new", dynlib: lib.}

template TYPE_GRID*(): expr = 
  (gtk_grid_get_type())

template GRID_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_GRID, TGrid))

template GRID_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_GRID, TGridClass))

template IS_GRID*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_GRID))

template IS_GRID_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_GRID))

template GRID_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_GRID, TGridClass))

type 
  PGrid* = ptr TGrid
  TGrid* = object of TContainer
    priv77: PGridPrivate

type 
  PGridClass* = ptr TGridClass
  TGridClass* = object of TContainerClass
    ugtk_reserved741: proc () {.cdecl.}
    ugtk_reserved742: proc () {.cdecl.}
    ugtk_reserved743: proc () {.cdecl.}
    ugtk_reserved744: proc () {.cdecl.}
    ugtk_reserved745: proc () {.cdecl.}
    ugtk_reserved746: proc () {.cdecl.}
    ugtk_reserved747: proc () {.cdecl.}
    ugtk_reserved748: proc () {.cdecl.}

proc grid_get_type*(): GType {.cdecl, importc: "gtk_grid_get_type", 
                                   dynlib: lib.}
proc grid_new*(): PWidget {.cdecl, importc: "gtk_grid_new", 
                                      dynlib: lib.}
proc attach*(grid: PGrid; child: PWidget; left: gint; 
                      top: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_grid_attach", dynlib: lib.}
proc attach_next_to*(grid: PGrid; child: PWidget; 
                              sibling: PWidget; side: TPositionType; 
                              width: gint; height: gint) {.cdecl, 
    importc: "gtk_grid_attach_next_to", dynlib: lib.}
proc get_child_at*(grid: PGrid; left: gint; top: gint): PWidget {.
    cdecl, importc: "gtk_grid_get_child_at", dynlib: lib.}
proc insert_row*(grid: PGrid; position: gint) {.cdecl, 
    importc: "gtk_grid_insert_row", dynlib: lib.}
proc insert_column*(grid: PGrid; position: gint) {.cdecl, 
    importc: "gtk_grid_insert_column", dynlib: lib.}
proc remove_row*(grid: PGrid; position: gint) {.cdecl, 
    importc: "gtk_grid_remove_row", dynlib: lib.}
proc remove_column*(grid: PGrid; position: gint) {.cdecl, 
    importc: "gtk_grid_remove_column", dynlib: lib.}
proc insert_next_to*(grid: PGrid; sibling: PWidget; 
                              side: TPositionType) {.cdecl, 
    importc: "gtk_grid_insert_next_to", dynlib: lib.}
proc set_row_homogeneous*(grid: PGrid; homogeneous: gboolean) {.
    cdecl, importc: "gtk_grid_set_row_homogeneous", dynlib: lib.}
proc get_row_homogeneous*(grid: PGrid): gboolean {.cdecl, 
    importc: "gtk_grid_get_row_homogeneous", dynlib: lib.}
proc set_row_spacing*(grid: PGrid; spacing: guint) {.cdecl, 
    importc: "gtk_grid_set_row_spacing", dynlib: lib.}
proc get_row_spacing*(grid: PGrid): guint {.cdecl, 
    importc: "gtk_grid_get_row_spacing", dynlib: lib.}
proc set_column_homogeneous*(grid: PGrid; homogeneous: gboolean) {.
    cdecl, importc: "gtk_grid_set_column_homogeneous", dynlib: lib.}
proc get_column_homogeneous*(grid: PGrid): gboolean {.cdecl, 
    importc: "gtk_grid_get_column_homogeneous", dynlib: lib.}
proc set_column_spacing*(grid: PGrid; spacing: guint) {.cdecl, 
    importc: "gtk_grid_set_column_spacing", dynlib: lib.}
proc get_column_spacing*(grid: PGrid): guint {.cdecl, 
    importc: "gtk_grid_get_column_spacing", dynlib: lib.}
proc set_row_baseline_position*(grid: PGrid; row: gint; 
    pos: TBaselinePosition) {.cdecl, importc: "gtk_grid_set_row_baseline_position", 
                                dynlib: lib.}
proc get_row_baseline_position*(grid: PGrid; row: gint): TBaselinePosition {.
    cdecl, importc: "gtk_grid_get_row_baseline_position", dynlib: lib.}
proc set_baseline_row*(grid: PGrid; row: gint) {.cdecl, 
    importc: "gtk_grid_set_baseline_row", dynlib: lib.}
proc get_baseline_row*(grid: PGrid): gint {.cdecl, 
    importc: "gtk_grid_get_baseline_row", dynlib: lib.}

template TYPE_HEADER_BAR*(): expr = 
  (gtk_header_bar_get_type())

template HEADER_BAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_HEADER_BAR, THeaderBar))

template HEADER_BAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_HEADER_BAR, THeaderBarClass))

template IS_HEADER_BAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_HEADER_BAR))

template IS_HEADER_BAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_HEADER_BAR))

template HEADER_BAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_HEADER_BAR, THeaderBarClass))

type 
  PHeaderBar* = ptr THeaderBar
  THeaderBar* = object of TContainer

type 
  PHeaderBarClass* = ptr THeaderBarClass
  THeaderBarClass* = object of TContainerClass
    ugtk_reserved751: proc () {.cdecl.}
    ugtk_reserved752: proc () {.cdecl.}
    ugtk_reserved753: proc () {.cdecl.}
    ugtk_reserved754: proc () {.cdecl.}

proc header_bar_get_type*(): GType {.cdecl, 
    importc: "gtk_header_bar_get_type", dynlib: lib.}
proc header_bar_new*(): PWidget {.cdecl, 
    importc: "gtk_header_bar_new", dynlib: lib.}
proc set_title*(bar: PHeaderBar; title: CSTRING) {.
    cdecl, importc: "gtk_header_bar_set_title", dynlib: lib.}
proc get_title*(bar: PHeaderBar): CSTRING {.cdecl, 
    importc: "gtk_header_bar_get_title", dynlib: lib.}
proc set_subtitle*(bar: PHeaderBar; subtitle: CSTRING) {.
    cdecl, importc: "gtk_header_bar_set_subtitle", dynlib: lib.}
proc get_subtitle*(bar: PHeaderBar): CSTRING {.cdecl, 
    importc: "gtk_header_bar_get_subtitle", dynlib: lib.}
proc set_custom_title*(bar: PHeaderBar; 
                                      title_widget: PWidget) {.cdecl, 
    importc: "gtk_header_bar_set_custom_title", dynlib: lib.}
proc get_custom_title*(bar: PHeaderBar): PWidget {.
    cdecl, importc: "gtk_header_bar_get_custom_title", dynlib: lib.}
proc header_bar_pack_start*(bar: PHeaderBar; child: PWidget) {.
    cdecl, importc: "gtk_header_bar_pack_start", dynlib: lib.}
proc header_bar_pack_end*(bar: PHeaderBar; child: PWidget) {.
    cdecl, importc: "gtk_header_bar_pack_end", dynlib: lib.}
proc get_show_close_button*(bar: PHeaderBar): gboolean {.
    cdecl, importc: "gtk_header_bar_get_show_close_button", dynlib: lib.}
proc set_show_close_button*(bar: PHeaderBar; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_header_bar_set_show_close_button", 
                         dynlib: lib.}
proc set_has_subtitle*(bar: PHeaderBar; setting: gboolean) {.
    cdecl, importc: "gtk_header_bar_set_has_subtitle", dynlib: lib.}
proc get_has_subtitle*(bar: PHeaderBar): gboolean {.
    cdecl, importc: "gtk_header_bar_get_has_subtitle", dynlib: lib.}
proc set_decoration_layout*(bar: PHeaderBar; 
    layout: CSTRING) {.cdecl, 
                         importc: "gtk_header_bar_set_decoration_layout", 
                         dynlib: lib.}
proc get_decoration_layout*(bar: PHeaderBar): CSTRING {.
    cdecl, importc: "gtk_header_bar_get_decoration_layout", dynlib: lib.}

template TYPE_ICON_FACTORY*(): expr = 
  (gtk_icon_factory_get_type())

template ICON_FACTORY_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ICON_FACTORY, TIconFactory))

template ICON_FACTORY_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ICON_FACTORY, TIconFactoryClass))

template IS_ICON_FACTORY*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ICON_FACTORY))

template IS_ICON_FACTORY_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ICON_FACTORY))

template ICON_FACTORY_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ICON_FACTORY, TIconFactoryClass))

template TYPE_ICON_SET*(): expr = 
  (gtk_icon_set_get_type())

template TYPE_ICON_SOURCE*(): expr = 
  (gtk_icon_source_get_type())

type 
  PIconFactory* = ptr TIconFactory
  TIconFactory* = object of TGObject
    priv78: PIconFactoryPrivate

type 
  PIconFactoryClass* = ptr TIconFactoryClass
  TIconFactoryClass* = object of TGObjectClass
    ugtk_reserved761: proc () {.cdecl.}
    ugtk_reserved762: proc () {.cdecl.}
    ugtk_reserved763: proc () {.cdecl.}
    ugtk_reserved764: proc () {.cdecl.}

proc icon_factory_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_factory_get_type", dynlib: lib.}
proc icon_factory_new*(): PIconFactory {.cdecl, 
    importc: "gtk_icon_factory_new", dynlib: lib.}
proc add*(factory: PIconFactory; stock_id: CSTRING; 
                           icon_set: PIconSet) {.cdecl, 
    importc: "gtk_icon_factory_add", dynlib: lib.}
proc lookup*(factory: PIconFactory; stock_id: CSTRING): PIconSet {.
    cdecl, importc: "gtk_icon_factory_lookup", dynlib: lib.}
proc add_default*(factory: PIconFactory) {.cdecl, 
    importc: "gtk_icon_factory_add_default", dynlib: lib.}
proc remove_default*(factory: PIconFactory) {.cdecl, 
    importc: "gtk_icon_factory_remove_default", dynlib: lib.}
proc icon_factory_lookup_default*(stock_id: CSTRING): PIconSet {.
    cdecl, importc: "gtk_icon_factory_lookup_default", dynlib: lib.}
when not(defined(GDK_MULTIHEAD_SAFE)): 
  proc lookup*(size: TIconSize; width: Pgint; 
                             height: Pgint): gboolean {.cdecl, 
      importc: "gtk_icon_size_lookup", dynlib: lib.}
proc icon_size_lookup_for_settings*(settings: PSettings; 
    size: TIconSize; width: Pgint; height: Pgint): gboolean {.cdecl, 
    importc: "gtk_icon_size_lookup_for_settings", dynlib: lib.}
proc icon_size_register*(name: CSTRING; width: gint; height: gint): TIconSize {.
    cdecl, importc: "gtk_icon_size_register", dynlib: lib.}
proc icon_size_register_alias*(alias: CSTRING; target: TIconSize) {.
    cdecl, importc: "gtk_icon_size_register_alias", dynlib: lib.}
proc icon_size_from_name*(name: CSTRING): TIconSize {.cdecl, 
    importc: "gtk_icon_size_from_name", dynlib: lib.}
proc get_name*(size: TIconSize): CSTRING {.cdecl, 
    importc: "gtk_icon_size_get_name", dynlib: lib.}
proc icon_set_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_set_get_type", dynlib: lib.}
proc icon_set_new*(): PIconSet {.cdecl, importc: "gtk_icon_set_new", 
    dynlib: lib.}
proc icon_set_new_from_pixbuf*(pixbuf: PPixbuf): PIconSet {.
    cdecl, importc: "gtk_icon_set_new_from_pixbuf", dynlib: lib.}
proc re*(icon_set: PIconSet): PIconSet {.cdecl, 
    importc: "gtk_icon_set_ref", dynlib: lib.}
proc unref*(icon_set: PIconSet) {.cdecl, 
    importc: "gtk_icon_set_unref", dynlib: lib.}
proc copy*(icon_set: PIconSet): PIconSet {.cdecl, 
    importc: "gtk_icon_set_copy", dynlib: lib.}
proc render_icon*(icon_set: PIconSet; style: PStyle; 
                               direction: TTextDirection; 
                               state: TStateType; size: TIconSize; 
                               widget: PWidget; detail: CSTRING): PPixbuf {.
    cdecl, importc: "gtk_icon_set_render_icon", dynlib: lib.}
proc add_source*(icon_set: PIconSet; 
                              source: PIconSource) {.cdecl, 
    importc: "gtk_icon_set_add_source", dynlib: lib.}
proc get_sizes*(icon_set: PIconSet; 
                             sizes: ptr PIconSize; n_sizes: Pgint) {.
    cdecl, importc: "gtk_icon_set_get_sizes", dynlib: lib.}
proc icon_source_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_source_get_type", dynlib: lib.}
proc icon_source_new*(): PIconSource {.cdecl, 
    importc: "gtk_icon_source_new", dynlib: lib.}
proc copy*(source: PIconSource): PIconSource {.
    cdecl, importc: "gtk_icon_source_copy", dynlib: lib.}
proc free*(source: PIconSource) {.cdecl, 
    importc: "gtk_icon_source_free", dynlib: lib.}
proc set_filename*(source: PIconSource; 
                                   filename: CSTRING) {.cdecl, 
    importc: "gtk_icon_source_set_filename", dynlib: lib.}
proc set_icon_name*(source: PIconSource; 
                                    icon_name: CSTRING) {.cdecl, 
    importc: "gtk_icon_source_set_icon_name", dynlib: lib.}
proc set_pixbuf*(source: PIconSource; 
                                 pixbuf: PPixbuf) {.cdecl, 
    importc: "gtk_icon_source_set_pixbuf", dynlib: lib.}
proc get_filename*(source: PIconSource): CSTRING {.
    cdecl, importc: "gtk_icon_source_get_filename", dynlib: lib.}
proc get_icon_name*(source: PIconSource): CSTRING {.
    cdecl, importc: "gtk_icon_source_get_icon_name", dynlib: lib.}
proc get_pixbuf*(source: PIconSource): PPixbuf {.
    cdecl, importc: "gtk_icon_source_get_pixbuf", dynlib: lib.}
proc set_direction_wildcarded*(source: PIconSource; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_icon_source_set_direction_wildcarded", 
                         dynlib: lib.}
proc set_state_wildcarded*(source: PIconSource; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_icon_source_set_state_wildcarded", 
                         dynlib: lib.}
proc set_size_wildcarded*(source: PIconSource; 
    setting: gboolean) {.cdecl, 
                         importc: "gtk_icon_source_set_size_wildcarded", 
                         dynlib: lib.}
proc get_size_wildcarded*(source: PIconSource): gboolean {.
    cdecl, importc: "gtk_icon_source_get_size_wildcarded", dynlib: lib.}
proc get_state_wildcarded*(source: PIconSource): gboolean {.
    cdecl, importc: "gtk_icon_source_get_state_wildcarded", dynlib: lib.}
proc get_direction_wildcarded*(source: PIconSource): gboolean {.
    cdecl, importc: "gtk_icon_source_get_direction_wildcarded", dynlib: lib.}
proc set_direction*(source: PIconSource; 
                                    direction: TTextDirection) {.cdecl, 
    importc: "gtk_icon_source_set_direction", dynlib: lib.}
proc set_state*(source: PIconSource; state: TStateType) {.
    cdecl, importc: "gtk_icon_source_set_state", dynlib: lib.}
proc set_size*(source: PIconSource; size: TIconSize) {.
    cdecl, importc: "gtk_icon_source_set_size", dynlib: lib.}
proc get_direction*(source: PIconSource): TTextDirection {.
    cdecl, importc: "gtk_icon_source_get_direction", dynlib: lib.}
proc get_state*(source: PIconSource): TStateType {.
    cdecl, importc: "gtk_icon_source_get_state", dynlib: lib.}
proc get_size*(source: PIconSource): TIconSize {.
    cdecl, importc: "gtk_icon_source_get_size", dynlib: lib.}
proc underscore_gtk_icon_set_invalidate_caches*() {.cdecl, 
    importc: "_gtk_icon_set_invalidate_caches", dynlib: lib.}
proc underscore_gtk_icon_factory_list_ids*(): PGList {.cdecl, 
    importc: "_gtk_icon_factory_list_ids", dynlib: lib.}
proc underscore_gtk_icon_factory_ensure_default_icons*() {.cdecl, 
    importc: "_gtk_icon_factory_ensure_default_icons", dynlib: lib.}

template TYPE_STYLE_PROPERTIES*(): expr = 
  (gtk_style_properties_get_type())

template STYLE_PROPERTIES*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_STYLE_PROPERTIES, 
                              TStyleProperties))

template STYLE_PROPERTIES_CLASS*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((c), TYPE_STYLE_PROPERTIES, 
                           TStylePropertiesClass))

template IS_STYLE_PROPERTIES*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_STYLE_PROPERTIES))

template IS_STYLE_PROPERTIES_CLASS*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_STYLE_PROPERTIES))

template STYLE_PROPERTIES_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_STYLE_PROPERTIES, 
                             TStylePropertiesClass))

type 
  PStyleProperties* = ptr TStyleProperties
  TStyleProperties* = object of TGObject
    priv79: PStylePropertiesPrivate

type 
  PStylePropertiesClass* = ptr TStylePropertiesClass
  TStylePropertiesClass* = object of TGObjectClass
    ugtk_reserved771: proc () {.cdecl.}
    ugtk_reserved772: proc () {.cdecl.}
    ugtk_reserved773: proc () {.cdecl.}
    ugtk_reserved774: proc () {.cdecl.}

type 
  TStylePropertyParser* = proc (string: CSTRING; value: PGValue; 
                                  error: ptr PGError): gboolean {.cdecl.}
proc style_properties_get_type*(): GType {.cdecl, 
    importc: "gtk_style_properties_get_type", dynlib: lib.}
proc style_properties_register_property*(
    parse_func: TStylePropertyParser; pspec: PGParamSpec) {.cdecl, 
    importc: "gtk_style_properties_register_property", dynlib: lib.}
proc style_properties_lookup_property*(property_name: CSTRING; 
    parse_func: ptr TStylePropertyParser; pspec: ptr PGParamSpec): gboolean {.
    cdecl, importc: "gtk_style_properties_lookup_property", dynlib: lib.}
proc style_properties_new*(): PStyleProperties {.cdecl, 
    importc: "gtk_style_properties_new", dynlib: lib.}
proc map_color*(props: PStyleProperties; 
                                     name: CSTRING; 
                                     color: PSymbolicColor) {.cdecl, 
    importc: "gtk_style_properties_map_color", dynlib: lib.}
proc lookup_color*(props: PStyleProperties; 
    name: CSTRING): PSymbolicColor {.cdecl, 
    importc: "gtk_style_properties_lookup_color", dynlib: lib.}
proc set_property*(props: PStyleProperties; 
    property: CSTRING; state: TStateFlags; value: PGValue) {.cdecl, 
    importc: "gtk_style_properties_set_property", dynlib: lib.}
proc set_valist*(props: PStyleProperties; 
                                      state: TStateFlags; args: va_list) {.
    cdecl, importc: "gtk_style_properties_set_valist", dynlib: lib.}
proc set*(props: PStyleProperties; 
                               state: TStateFlags) {.varargs, cdecl, 
    importc: "gtk_style_properties_set", dynlib: lib.}
proc get_property*(props: PStyleProperties; 
    property: CSTRING; state: TStateFlags; value: PGValue): gboolean {.
    cdecl, importc: "gtk_style_properties_get_property", dynlib: lib.}
proc get_valist*(props: PStyleProperties; 
                                      state: TStateFlags; args: va_list) {.
    cdecl, importc: "gtk_style_properties_get_valist", dynlib: lib.}
proc get*(props: PStyleProperties; 
                               state: TStateFlags) {.varargs, cdecl, 
    importc: "gtk_style_properties_get", dynlib: lib.}
proc unset_property*(props: PStyleProperties; 
    property: CSTRING; state: TStateFlags) {.cdecl, 
    importc: "gtk_style_properties_unset_property", dynlib: lib.}
proc clear*(props: PStyleProperties) {.cdecl, 
    importc: "gtk_style_properties_clear", dynlib: lib.}
proc merge*(props: PStyleProperties; 
                                 props_to_merge: PStyleProperties; 
                                 replace: gboolean) {.cdecl, 
    importc: "gtk_style_properties_merge", dynlib: lib.}

template TYPE_STYLE_PROVIDER*(): expr = 
  (gtk_style_provider_get_type())

template STYLE_PROVIDER_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_STYLE_PROVIDER, TStyleProvider))

template IS_STYLE_PROVIDER*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_STYLE_PROVIDER))

template STYLE_PROVIDER_GET_IFACE*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((o), TYPE_STYLE_PROVIDER, 
                                 TStyleProviderIface))

const 
  STYLE_PROVIDER_PRIORITY_FALLBACK* = 1
const 
  STYLE_PROVIDER_PRIORITY_THEME* = 200
const 
  STYLE_PROVIDER_PRIORITY_SETTINGS* = 400
const 
  STYLE_PROVIDER_PRIORITY_APPLICATION* = 600
const 
  STYLE_PROVIDER_PRIORITY_USER* = 800
type 
  PStyleProviderIface* = ptr TStyleProviderIface
  TStyleProviderIface* = object of TGTypeInterface
    get_style*: proc (provider: PStyleProvider; path: PWidgetPath): PStyleProperties {.
        cdecl.}
    get_style_property*: proc (provider: PStyleProvider; 
                               path: PWidgetPath; state: TStateFlags; 
                               pspec: PGParamSpec; value: PGValue): gboolean {.
        cdecl.}
    get_icon_factory*: proc (provider: PStyleProvider; 
                             path: PWidgetPath): PIconFactory {.
        cdecl.}

proc style_provider_get_type*(): GType {.cdecl, 
    importc: "gtk_style_provider_get_type", dynlib: lib.}
proc get_style*(provider: PStyleProvider; 
                                   path: PWidgetPath): PStyleProperties {.
    cdecl, importc: "gtk_style_provider_get_style", dynlib: lib.}
proc get_style_property*(provider: PStyleProvider; 
    path: PWidgetPath; state: TStateFlags; pspec: PGParamSpec; 
    value: PGValue): gboolean {.cdecl, importc: "gtk_style_provider_get_style_property", 
                                   dynlib: lib.}
proc get_icon_factory*(provider: PStyleProvider; 
    path: PWidgetPath): PIconFactory {.cdecl, 
    importc: "gtk_style_provider_get_icon_factory", dynlib: lib.}

template TYPE_STYLE_CONTEXT*(): expr = 
  (gtk_style_context_get_type())

template STYLE_CONTEXT_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_STYLE_CONTEXT, TStyleContext))

template STYLE_CONTEXT_CLASS_TEMPLATE*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((c), TYPE_STYLE_CONTEXT, TStyleContextClass))

template IS_STYLE_CONTEXT*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_STYLE_CONTEXT))

template IS_STYLE_CONTEXT_CLASS*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_STYLE_CONTEXT))

template STYLE_CONTEXT_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_STYLE_CONTEXT, TStyleContextClass))


const 
  STYLE_PROPERTY_BACKGROUND_COLOR* = "background-color"
const 
  STYLE_PROPERTY_COLOR* = "color"
const 
  STYLE_PROPERTY_FONT* = "font"
const 
  STYLE_PROPERTY_PADDING* = "padding"
const 
  STYLE_PROPERTY_BORDER_WIDTH* = "border-width"
const 
  STYLE_PROPERTY_MARGIN* = "margin"
const 
  STYLE_PROPERTY_BORDER_RADIUS* = "border-radius"
const 
  STYLE_PROPERTY_BORDER_STYLE* = "border-style"
const 
  STYLE_PROPERTY_BORDER_COLOR* = "border-color"
const 
  STYLE_PROPERTY_BACKGROUND_IMAGE* = "background-image"
const 
  STYLE_CLASS_CELL* = "cell"
const 
  STYLE_CLASS_DIM_LABEL* = "dim-label"
const 
  STYLE_CLASS_ENTRY* = "entry"
const 
  STYLE_CLASS_COMBOBOX_ENTRY* = "combobox-entry"
const 
  STYLE_CLASS_BUTTON* = "button"
const 
  STYLE_CLASS_LIST* = "list"
const 
  STYLE_CLASS_LIST_ROW* = "list-row"
const 
  STYLE_CLASS_CALENDAR* = "calendar"
const 
  STYLE_CLASS_SLIDER* = "slider"
const 
  STYLE_CLASS_BACKGROUND* = "background"
const 
  STYLE_CLASS_RUBBERBAND* = "rubberband"
const 
  STYLE_CLASS_TOOLTIP* = "tooltip"
const 
  STYLE_CLASS_MENU* = "menu"
const 
  STYLE_CLASS_CONTEXT_MENU* = "context-menu"
const 
  STYLE_CLASS_MENUBAR* = "menubar"
const 
  STYLE_CLASS_MENUITEM* = "menuitem"
const 
  STYLE_CLASS_TOOLBAR* = "toolbar"
const 
  STYLE_CLASS_PRIMARY_TOOLBAR* = "primary-toolbar"
const 
  STYLE_CLASS_INLINE_TOOLBAR* = "inline-toolbar"
const 
  STYLE_CLASS_RADIO* = "radio"
const 
  STYLE_CLASS_CHECK* = "check"
const 
  STYLE_CLASS_DEFAULT* = "default"
const 
  STYLE_CLASS_TROUGH* = "trough"
const 
  STYLE_CLASS_SCROLLBAR* = "scrollbar"
const 
  STYLE_CLASS_SCROLLBARS_JUNCTION* = "scrollbars-junction"
const 
  STYLE_CLASS_SCALE* = "scale"
const 
  STYLE_CLASS_SCALE_HAS_MARKS_ABOVE* = "scale-has-marks-above"
const 
  STYLE_CLASS_SCALE_HAS_MARKS_BELOW* = "scale-has-marks-below"
const 
  STYLE_CLASS_HEADER* = "header"
const 
  STYLE_CLASS_ACCELERATOR* = "accelerator"
const 
  STYLE_CLASS_RAISED* = "raised"
const 
  STYLE_CLASS_LINKED* = "linked"
const 
  STYLE_CLASS_GRIP* = "grip"
const 
  STYLE_CLASS_DOCK* = "dock"
const 
  STYLE_CLASS_PROGRESSBAR* = "progressbar"
const 
  STYLE_CLASS_SPINNER* = "spinner"
const 
  STYLE_CLASS_MARK* = "mark"
const 
  STYLE_CLASS_EXPANDER* = "expander"
const 
  STYLE_CLASS_SPINBUTTON* = "spinbutton"
const 
  STYLE_CLASS_NOTEBOOK* = "notebook"
const 
  STYLE_CLASS_VIEW* = "view"
const 
  STYLE_CLASS_SIDEBAR* = "sidebar"
const 
  STYLE_CLASS_IMAGE* = "image"
const 
  STYLE_CLASS_HIGHLIGHT* = "highlight"
const 
  STYLE_CLASS_FRAME* = "frame"
const 
  STYLE_CLASS_DND* = "dnd"
const 
  STYLE_CLASS_PANE_SEPARATOR* = "pane-separator"
const 
  STYLE_CLASS_SEPARATOR* = "separator"
const 
  STYLE_CLASS_INFO* = "info"
const 
  STYLE_CLASS_WARNING* = "warning"
const 
  STYLE_CLASS_QUESTION* = "question"
const 
  STYLE_CLASS_ERROR* = "error"
const 
  STYLE_CLASS_HORIZONTAL* = "horizontal"
const 
  STYLE_CLASS_VERTICAL* = "vertical"
const 
  STYLE_CLASS_TOP* = "top"
const 
  STYLE_CLASS_BOTTOM* = "bottom"
const 
  STYLE_CLASS_LEFT* = "left"
const 
  STYLE_CLASS_RIGHT* = "right"
const 
  STYLE_CLASS_PULSE* = "pulse"
const 
  STYLE_CLASS_ARROW* = "arrow"
const 
  STYLE_CLASS_OSD* = "osd"
const 
  STYLE_CLASS_LEVEL_BAR* = "level-bar"
const 
  STYLE_CLASS_CURSOR_HANDLE* = "cursor-handle"
const 
  STYLE_CLASS_INSERTION_CURSOR* = "insertion-cursor"
const 
  STYLE_CLASS_TITLEBAR* = "titlebar"
const 
  STYLE_CLASS_NEEDS_ATTENTION* = "needs-attention"
const 
  STYLE_CLASS_SUGGESTED_ACTION* = "suggested-action"
const 
  STYLE_CLASS_DESTRUCTIVE_ACTION* = "destructive-action"
const 
  STYLE_REGION_ROW* = "row"
const 
  STYLE_REGION_COLUMN* = "column"
const 
  STYLE_REGION_COLUMN_HEADER* = "column-header"
const 
  STYLE_REGION_TAB* = "tab"
proc style_context_get_type*(): GType {.cdecl, 
    importc: "gtk_style_context_get_type", dynlib: lib.}
proc style_context_new*(): PStyleContext {.cdecl, 
    importc: "gtk_style_context_new", dynlib: lib.}
proc style_context_add_provider_for_screen*(screen: PGdkScreen; 
    provider: PStyleProvider; priority: guint) {.cdecl, 
    importc: "gtk_style_context_add_provider_for_screen", dynlib: lib.}
proc style_context_remove_provider_for_screen*(screen: PGdkScreen; 
    provider: PStyleProvider) {.cdecl, importc: "gtk_style_context_remove_provider_for_screen", 
                                      dynlib: lib.}
proc add_provider*(context: PStyleContext; 
                                     provider: PStyleProvider; 
                                     priority: guint) {.cdecl, 
    importc: "gtk_style_context_add_provider", dynlib: lib.}
proc remove_provider*(context: PStyleContext; 
    provider: PStyleProvider) {.cdecl, importc: "gtk_style_context_remove_provider", 
                                      dynlib: lib.}
proc save*(context: PStyleContext) {.cdecl, 
    importc: "gtk_style_context_save", dynlib: lib.}
proc restore*(context: PStyleContext) {.cdecl, 
    importc: "gtk_style_context_restore", dynlib: lib.}
proc get_section*(context: PStyleContext; 
                                    property: CSTRING): PCssSection {.
    cdecl, importc: "gtk_style_context_get_section", dynlib: lib.}
proc get_property*(context: PStyleContext; 
                                     property: CSTRING; 
                                     state: TStateFlags; value: PGValue) {.
    cdecl, importc: "gtk_style_context_get_property", dynlib: lib.}
proc get_valist*(context: PStyleContext; 
                                   state: TStateFlags; args: va_list) {.
    cdecl, importc: "gtk_style_context_get_valist", dynlib: lib.}
proc get*(context: PStyleContext; state: TStateFlags) {.
    varargs, cdecl, importc: "gtk_style_context_get", dynlib: lib.}
proc set_state*(context: PStyleContext; 
                                  flags: TStateFlags) {.cdecl, 
    importc: "gtk_style_context_set_state", dynlib: lib.}
proc get_state*(context: PStyleContext): TStateFlags {.
    cdecl, importc: "gtk_style_context_get_state", dynlib: lib.}
proc set_scale*(context: PStyleContext; scale: gint) {.
    cdecl, importc: "gtk_style_context_set_scale", dynlib: lib.}
proc get_scale*(context: PStyleContext): gint {.cdecl, 
    importc: "gtk_style_context_get_scale", dynlib: lib.}
proc state_is_running*(context: PStyleContext; 
    state: TStateType; progress: Pgdouble): gboolean {.cdecl, 
    importc: "gtk_style_context_state_is_running", dynlib: lib.}
proc set_path*(context: PStyleContext; 
                                 path: PWidgetPath) {.cdecl, 
    importc: "gtk_style_context_set_path", dynlib: lib.}
proc get_path*(context: PStyleContext): PWidgetPath {.
    cdecl, importc: "gtk_style_context_get_path", dynlib: lib.}
proc set_parent*(context: PStyleContext; 
                                   parent: PStyleContext) {.cdecl, 
    importc: "gtk_style_context_set_parent", dynlib: lib.}
proc get_parent*(context: PStyleContext): PStyleContext {.
    cdecl, importc: "gtk_style_context_get_parent", dynlib: lib.}
proc list_classes*(context: PStyleContext): PGList {.
    cdecl, importc: "gtk_style_context_list_classes", dynlib: lib.}
proc add_class*(context: PStyleContext; 
                                  class_name: CSTRING) {.cdecl, 
    importc: "gtk_style_context_add_class", dynlib: lib.}
proc remove_class*(context: PStyleContext; 
                                     class_name: CSTRING) {.cdecl, 
    importc: "gtk_style_context_remove_class", dynlib: lib.}
proc has_class*(context: PStyleContext; 
                                  class_name: CSTRING): gboolean {.cdecl, 
    importc: "gtk_style_context_has_class", dynlib: lib.}
proc list_regions*(context: PStyleContext): PGList {.
    cdecl, importc: "gtk_style_context_list_regions", dynlib: lib.}
proc add_region*(context: PStyleContext; 
                                   region_name: CSTRING; 
                                   flags: TRegionFlags) {.cdecl, 
    importc: "gtk_style_context_add_region", dynlib: lib.}
proc remove_region*(context: PStyleContext; 
                                      region_name: CSTRING) {.cdecl, 
    importc: "gtk_style_context_remove_region", dynlib: lib.}
proc has_region*(context: PStyleContext; 
                                   region_name: CSTRING; 
                                   flags_return: var TRegionFlags): gboolean {.
    cdecl, importc: "gtk_style_context_has_region", dynlib: lib.}
proc get_style_property*(context: PStyleContext; 
    property_name: CSTRING; value: PGValue) {.cdecl, 
    importc: "gtk_style_context_get_style_property", dynlib: lib.}
proc get_style_valist*(context: PStyleContext; 
    args: va_list) {.cdecl, importc: "gtk_style_context_get_style_valist", 
                     dynlib: lib.}
proc get_style*(context: PStyleContext) {.varargs, 
    cdecl, importc: "gtk_style_context_get_style", dynlib: lib.}
proc lookup_icon_set*(context: PStyleContext; 
    stock_id: CSTRING): PIconSet {.cdecl, 
    importc: "gtk_style_context_lookup_icon_set", dynlib: lib.}
proc render_icon_pixbuf*(icon_set: PIconSet; 
                                      context: PStyleContext; 
                                      size: TIconSize): PPixbuf {.
    cdecl, importc: "gtk_icon_set_render_icon_pixbuf", dynlib: lib.}
proc render_icon_surface*(icon_set: PIconSet; 
    context: PStyleContext; size: TIconSize; scale: cint; 
    for_window: PGdkWindow): Psurface {.cdecl, 
    importc: "gtk_icon_set_render_icon_surface", dynlib: lib.}
proc set_screen*(context: PStyleContext; 
                                   screen: PGdkScreen) {.cdecl, 
    importc: "gtk_style_context_set_screen", dynlib: lib.}
proc get_screen*(context: PStyleContext): PGdkScreen {.
    cdecl, importc: "gtk_style_context_get_screen", dynlib: lib.}
proc set_frame_clock*(context: PStyleContext; 
    frame_clock: PFrameClock) {.cdecl, importc: "gtk_style_context_set_frame_clock", 
                                      dynlib: lib.}
proc get_frame_clock*(context: PStyleContext): PFrameClock {.
    cdecl, importc: "gtk_style_context_get_frame_clock", dynlib: lib.}
const 
  STYLE_CLASS_READ_ONLY* = "read-only"
proc set_direction*(context: PStyleContext; 
                                      direction: TTextDirection) {.cdecl, 
    importc: "gtk_style_context_set_direction", dynlib: lib.}
proc get_direction*(context: PStyleContext): TTextDirection {.
    cdecl, importc: "gtk_style_context_get_direction", dynlib: lib.}
proc set_junction_sides*(context: PStyleContext; 
    sides: TJunctionSides) {.cdecl, importc: "gtk_style_context_set_junction_sides", 
                               dynlib: lib.}
proc get_junction_sides*(context: PStyleContext): TJunctionSides {.
    cdecl, importc: "gtk_style_context_get_junction_sides", dynlib: lib.}
proc lookup_color*(context: PStyleContext; 
                                     color_name: CSTRING; color: PRGBA): gboolean {.
    cdecl, importc: "gtk_style_context_lookup_color", dynlib: lib.}
proc notify_state_change*(context: PStyleContext; 
    window: PGdkWindow; region_id: gpointer; state: TStateType; 
    state_value: gboolean) {.cdecl, importc: "gtk_style_context_notify_state_change", 
                             dynlib: lib.}
proc cancel_animations*(context: PStyleContext; 
    region_id: gpointer) {.cdecl, 
                           importc: "gtk_style_context_cancel_animations", 
                           dynlib: lib.}
proc scroll_animations*(context: PStyleContext; 
    window: PGdkWindow; dx: gint; dy: gint) {.cdecl, 
    importc: "gtk_style_context_scroll_animations", dynlib: lib.}
proc push_animatable_region*(context: PStyleContext; 
    region_id: gpointer) {.cdecl, importc: "gtk_style_context_push_animatable_region", 
                           dynlib: lib.}
proc pop_animatable_region*(context: PStyleContext) {.
    cdecl, importc: "gtk_style_context_pop_animatable_region", dynlib: lib.}
proc get_color*(context: PStyleContext; 
                                  state: TStateFlags; color: PRGBA) {.
    cdecl, importc: "gtk_style_context_get_color", dynlib: lib.}
proc get_background_color*(context: PStyleContext; 
    state: TStateFlags; color: PRGBA) {.cdecl, 
    importc: "gtk_style_context_get_background_color", dynlib: lib.}
proc get_border_color*(context: PStyleContext; 
    state: TStateFlags; color: PRGBA) {.cdecl, 
    importc: "gtk_style_context_get_border_color", dynlib: lib.}
proc get_font*(context: PStyleContext; 
                                 state: TStateFlags): PFontDescription {.
    cdecl, importc: "gtk_style_context_get_font", dynlib: lib.}
proc get_border*(context: PStyleContext; 
                                   state: TStateFlags; border: PBorder) {.
    cdecl, importc: "gtk_style_context_get_border", dynlib: lib.}
proc get_padding*(context: PStyleContext; 
                                    state: TStateFlags; 
                                    padding: PBorder) {.cdecl, 
    importc: "gtk_style_context_get_padding", dynlib: lib.}
proc get_margin*(context: PStyleContext; 
                                   state: TStateFlags; margin: PBorder) {.
    cdecl, importc: "gtk_style_context_get_margin", dynlib: lib.}
proc invalidate*(context: PStyleContext) {.cdecl, 
    importc: "gtk_style_context_invalidate", dynlib: lib.}
proc style_context_reset_widgets*(screen: PGdkScreen) {.cdecl, 
    importc: "gtk_style_context_reset_widgets", dynlib: lib.}
proc set_background*(context: PStyleContext; 
    window: PGdkWindow) {.cdecl, 
                             importc: "gtk_style_context_set_background", 
                             dynlib: lib.}
proc render_check*(context: PStyleContext; cr: cairo.Pcontext; 
                       x: gdouble; y: gdouble; width: gdouble; height: gdouble) {.
    cdecl, importc: "gtk_render_check", dynlib: lib.}
proc render_option*(context: PStyleContext; cr: cairo.Pcontext; 
                        x: gdouble; y: gdouble; width: gdouble; 
                        height: gdouble) {.cdecl, 
    importc: "gtk_render_option", dynlib: lib.}
proc render_arrow*(context: PStyleContext; cr: cairo.Pcontext; 
                       angle: gdouble; x: gdouble; y: gdouble; size: gdouble) {.
    cdecl, importc: "gtk_render_arrow", dynlib: lib.}
proc render_background*(context: PStyleContext; cr: cairo.Pcontext; 
                            x: gdouble; y: gdouble; width: gdouble; 
                            height: gdouble) {.cdecl, 
    importc: "gtk_render_background", dynlib: lib.}
proc render_frame*(context: PStyleContext; cr: cairo.Pcontext; 
                       x: gdouble; y: gdouble; width: gdouble; height: gdouble) {.
    cdecl, importc: "gtk_render_frame", dynlib: lib.}
proc render_expander*(context: PStyleContext; cr: cairo.Pcontext; 
                          x: gdouble; y: gdouble; width: gdouble; 
                          height: gdouble) {.cdecl, 
    importc: "gtk_render_expander", dynlib: lib.}
proc render_focus*(context: PStyleContext; cr: cairo.Pcontext; 
                       x: gdouble; y: gdouble; width: gdouble; height: gdouble) {.
    cdecl, importc: "gtk_render_focus", dynlib: lib.}
proc render_layout*(context: PStyleContext; cr: cairo.Pcontext; 
                        x: gdouble; y: gdouble; layout: Playout) {.
    cdecl, importc: "gtk_render_layout", dynlib: lib.}
proc render_line*(context: PStyleContext; cr: cairo.Pcontext; 
                      x0: gdouble; y0: gdouble; x1: gdouble; y1: gdouble) {.
    cdecl, importc: "gtk_render_line", dynlib: lib.}
proc render_slider*(context: PStyleContext; cr: cairo.Pcontext; 
                        x: gdouble; y: gdouble; width: gdouble; 
                        height: gdouble; orientation: TOrientation) {.cdecl, 
    importc: "gtk_render_slider", dynlib: lib.}
proc render_frame_gap*(context: PStyleContext; cr: cairo.Pcontext; 
                           x: gdouble; y: gdouble; width: gdouble; 
                           height: gdouble; gap_side: TPositionType; 
                           xy0_gap: gdouble; xy1_gap: gdouble) {.cdecl, 
    importc: "gtk_render_frame_gap", dynlib: lib.}
proc render_extension*(context: PStyleContext; cr: cairo.Pcontext; 
                           x: gdouble; y: gdouble; width: gdouble; 
                           height: gdouble; gap_side: TPositionType) {.
    cdecl, importc: "gtk_render_extension", dynlib: lib.}
proc render_handle*(context: PStyleContext; cr: cairo.Pcontext; 
                        x: gdouble; y: gdouble; width: gdouble; 
                        height: gdouble) {.cdecl, 
    importc: "gtk_render_handle", dynlib: lib.}
proc render_activity*(context: PStyleContext; cr: cairo.Pcontext; 
                          x: gdouble; y: gdouble; width: gdouble; 
                          height: gdouble) {.cdecl, 
    importc: "gtk_render_activity", dynlib: lib.}
proc render_icon_pixbuf*(context: PStyleContext; 
                             source: PIconSource; size: TIconSize): PPixbuf {.
    cdecl, importc: "gtk_render_icon_pixbuf", dynlib: lib.}
proc render_icon*(context: PStyleContext; cr: cairo.Pcontext; 
                      pixbuf: PPixbuf; x: gdouble; y: gdouble) {.cdecl, 
    importc: "gtk_render_icon", dynlib: lib.}
proc render_icon_surface*(context: PStyleContext; cr: cairo.Pcontext; 
                              surface: Psurface; x: gdouble; 
                              y: gdouble) {.cdecl, 
    importc: "gtk_render_icon_surface", dynlib: lib.}
proc render_insertion_cursor*(context: PStyleContext; 
                                  cr: cairo.Pcontext; x: gdouble; y: gdouble; 
                                  layout: Playout; index: cint; 
                                  direction: pango.TDirection) {.cdecl, 
    importc: "gtk_render_insertion_cursor", dynlib: lib.}
proc draw_insertion_cursor*(widget: PWidget; cr: cairo.Pcontext; 
                                location: gdk3.PRectangle; 
                                is_primary: gboolean; 
                                direction: TTextDirection; 
                                draw_arrow: gboolean) {.cdecl, 
    importc: "gtk_draw_insertion_cursor", dynlib: lib.}
proc underscore_gtk_style_context_get_attributes*(attributes: atk.PAttributeSet; 
    context: PStyleContext; flags: TStateFlags): atk.PAttributeSet {.
    cdecl, importc: "_gtk_style_context_get_attributes", dynlib: lib.}

template TYPE_ICON_INFO*(): expr = 
  (gtk_icon_info_get_type())

template ICON_INFO_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ICON_INFO, TIconInfo))

template ICON_INFO_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ICON_INFO, IconInfoClass))

template IS_ICON_INFO*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ICON_INFO))

template IS_ICON_INFO_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ICON_INFO))

template ICON_INFO_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ICON_INFO, IconInfoClass))

template TYPE_ICON_THEME*(): expr = 
  (gtk_icon_theme_get_type())

template ICON_THEME_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ICON_THEME, TIconTheme))

template ICON_THEME_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ICON_THEME, TIconThemeClass))

template IS_ICON_THEME*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ICON_THEME))

template IS_ICON_THEME_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ICON_THEME))

template ICON_THEME_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ICON_THEME, TIconThemeClass))

type 
  PIconTheme* = ptr TIconTheme
  TIconTheme* = object of TGObject
    priv80: PIconThemePrivate

type 
  PIconThemeClass* = ptr TIconThemeClass
  TIconThemeClass* = object of TGObjectClass
    changed*: proc (icon_theme: PIconTheme) {.cdecl.}
    ugtk_reserved781: proc () {.cdecl.}
    ugtk_reserved782: proc () {.cdecl.}
    ugtk_reserved783: proc () {.cdecl.}
    ugtk_reserved784: proc () {.cdecl.}

type 
  TIconLookupFlags* {.size: sizeof(cint).} = enum 
    ICON_LOOKUP_NO_SVG = 1 shl 0, ICON_LOOKUP_FORCE_SVG = 1 shl 1, 
    ICON_LOOKUP_USE_BUILTIN = 1 shl 2, 
    ICON_LOOKUP_GENERIC_FALLBACK = 1 shl 3, 
    ICON_LOOKUP_FORCE_SIZE = 1 shl 4
template ICON_THEME_ERROR*(): expr = 
  gtk_icon_theme_error_quark()

type 
  TIconThemeError* {.size: sizeof(cint).} = enum 
    ICON_THEME_NOT_FOUND, ICON_THEME_FAILED
proc icon_theme_error_quark*(): TGQuark {.cdecl, 
    importc: "gtk_icon_theme_error_quark", dynlib: lib.}
proc icon_theme_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_theme_get_type", dynlib: lib.}
proc icon_theme_new*(): PIconTheme {.cdecl, 
    importc: "gtk_icon_theme_new", dynlib: lib.}
proc icon_theme_get_default*(): PIconTheme {.cdecl, 
    importc: "gtk_icon_theme_get_default", dynlib: lib.}
proc icon_theme_get_for_screen*(screen: PGdkScreen): PIconTheme {.
    cdecl, importc: "gtk_icon_theme_get_for_screen", dynlib: lib.}
proc set_screen*(icon_theme: PIconTheme; 
                                screen: PGdkScreen) {.cdecl, 
    importc: "gtk_icon_theme_set_screen", dynlib: lib.}
proc set_search_path*(icon_theme: PIconTheme; 
                                     path: ptr CSTRING; n_elements: gint) {.
    cdecl, importc: "gtk_icon_theme_set_search_path", dynlib: lib.}
proc get_search_path*(icon_theme: PIconTheme; 
                                     path: var PPgchar; 
                                     n_elements: Pgint) {.cdecl, 
    importc: "gtk_icon_theme_get_search_path", dynlib: lib.}
proc append_search_path*(icon_theme: PIconTheme; 
    path: CSTRING) {.cdecl, importc: "gtk_icon_theme_append_search_path", 
                       dynlib: lib.}
proc prepend_search_path*(icon_theme: PIconTheme; 
    path: CSTRING) {.cdecl, importc: "gtk_icon_theme_prepend_search_path", 
                       dynlib: lib.}
proc set_custom_theme*(icon_theme: PIconTheme; 
                                      theme_name: CSTRING) {.cdecl, 
    importc: "gtk_icon_theme_set_custom_theme", dynlib: lib.}
proc has_icon*(icon_theme: PIconTheme; 
                              icon_name: CSTRING): gboolean {.cdecl, 
    importc: "gtk_icon_theme_has_icon", dynlib: lib.}
proc get_icon_sizes*(icon_theme: PIconTheme; 
                                    icon_name: CSTRING): Pgint {.cdecl, 
    importc: "gtk_icon_theme_get_icon_sizes", dynlib: lib.}
proc lookup_icon*(icon_theme: PIconTheme; 
                                 icon_name: CSTRING; size: gint; 
                                 flags: TIconLookupFlags): PIconInfo {.
    cdecl, importc: "gtk_icon_theme_lookup_icon", dynlib: lib.}
proc lookup_icon_for_scale*(icon_theme: PIconTheme; 
    icon_name: CSTRING; size: gint; scale: gint; flags: TIconLookupFlags): PIconInfo {.
    cdecl, importc: "gtk_icon_theme_lookup_icon_for_scale", dynlib: lib.}
proc choose_icon*(icon_theme: PIconTheme; 
                                 icon_names: ptr CSTRING; size: gint; 
                                 flags: TIconLookupFlags): PIconInfo {.
    cdecl, importc: "gtk_icon_theme_choose_icon", dynlib: lib.}
proc choose_icon_for_scale*(icon_theme: PIconTheme; 
    icon_names: ptr CSTRING; size: gint; scale: gint; 
    flags: TIconLookupFlags): PIconInfo {.cdecl, 
    importc: "gtk_icon_theme_choose_icon_for_scale", dynlib: lib.}
proc load_icon*(icon_theme: PIconTheme; 
                               icon_name: CSTRING; size: gint; 
                               flags: TIconLookupFlags; 
                               error: ptr PGError): PPixbuf {.cdecl, 
    importc: "gtk_icon_theme_load_icon", dynlib: lib.}
proc load_icon_for_scale*(icon_theme: PIconTheme; 
    icon_name: CSTRING; size: gint; scale: gint; flags: TIconLookupFlags; 
    error: ptr PGError): PPixbuf {.cdecl, 
    importc: "gtk_icon_theme_load_icon_for_scale", dynlib: lib.}
proc load_surface*(icon_theme: PIconTheme; 
                                  icon_name: CSTRING; size: gint; 
                                  scale: gint; for_window: PGdkWindow; 
                                  flags: TIconLookupFlags; 
                                  error: ptr PGError): Psurface {.
    cdecl, importc: "gtk_icon_theme_load_surface", dynlib: lib.}
proc lookup_by_gicon*(icon_theme: PIconTheme; 
                                     icon: PGIcon; size: gint; 
                                     flags: TIconLookupFlags): PIconInfo {.
    cdecl, importc: "gtk_icon_theme_lookup_by_gicon", dynlib: lib.}
proc lookup_by_gicon_for_scale*(icon_theme: PIconTheme; 
    icon: PGIcon; size: gint; scale: gint; flags: TIconLookupFlags): PIconInfo {.
    cdecl, importc: "gtk_icon_theme_lookup_by_gicon_for_scale", dynlib: lib.}
proc list_icons*(icon_theme: PIconTheme; 
                                context: CSTRING): PGList {.cdecl, 
    importc: "gtk_icon_theme_list_icons", dynlib: lib.}
proc list_contexts*(icon_theme: PIconTheme): PGList {.
    cdecl, importc: "gtk_icon_theme_list_contexts", dynlib: lib.}
proc get_example_icon_name*(icon_theme: PIconTheme): cstring {.
    cdecl, importc: "gtk_icon_theme_get_example_icon_name", dynlib: lib.}
proc rescan_if_needed*(icon_theme: PIconTheme): gboolean {.
    cdecl, importc: "gtk_icon_theme_rescan_if_needed", dynlib: lib.}
proc icon_theme_add_builtin_icon*(icon_name: CSTRING; size: gint; 
                                      pixbuf: PPixbuf) {.cdecl, 
    importc: "gtk_icon_theme_add_builtin_icon", dynlib: lib.}
proc icon_info_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_info_get_type", dynlib: lib.}
proc copy*(icon_info: PIconInfo): PIconInfo {.cdecl, 
    importc: "gtk_icon_info_copy", dynlib: lib.}
proc free*(icon_info: PIconInfo) {.cdecl, 
    importc: "gtk_icon_info_free", dynlib: lib.}
proc icon_info_new_for_pixbuf*(icon_theme: PIconTheme; 
                                   pixbuf: PPixbuf): PIconInfo {.
    cdecl, importc: "gtk_icon_info_new_for_pixbuf", dynlib: lib.}
proc get_base_size*(icon_info: PIconInfo): gint {.cdecl, 
    importc: "gtk_icon_info_get_base_size", dynlib: lib.}
proc get_base_scale*(icon_info: PIconInfo): gint {.cdecl, 
    importc: "gtk_icon_info_get_base_scale", dynlib: lib.}
proc get_filename*(icon_info: PIconInfo): CSTRING {.
    cdecl, importc: "gtk_icon_info_get_filename", dynlib: lib.}
proc get_builtin_pixbuf*(icon_info: PIconInfo): PPixbuf {.
    cdecl, importc: "gtk_icon_info_get_builtin_pixbuf", dynlib: lib.}
proc is_symbolic*(icon_info: PIconInfo): gboolean {.cdecl, 
    importc: "gtk_icon_info_is_symbolic", dynlib: lib.}
proc load_icon*(icon_info: PIconInfo; 
                              error: ptr PGError): PPixbuf {.cdecl, 
    importc: "gtk_icon_info_load_icon", dynlib: lib.}
proc load_surface*(icon_info: PIconInfo; 
                                 for_window: PGdkWindow; 
                                 error: ptr PGError): Psurface {.
    cdecl, importc: "gtk_icon_info_load_surface", dynlib: lib.}
proc load_icon_async*(icon_info: PIconInfo; 
                                    cancellable: PGCancellable; 
                                    callback: TGAsyncReadyCallback; 
                                    user_data: gpointer) {.cdecl, 
    importc: "gtk_icon_info_load_icon_async", dynlib: lib.}
proc load_icon_finish*(icon_info: PIconInfo; 
                                     res: PGAsyncResult; 
                                     error: ptr PGError): PPixbuf {.
    cdecl, importc: "gtk_icon_info_load_icon_finish", dynlib: lib.}
proc load_symbolic*(icon_info: PIconInfo; fg: PRGBA; 
                                  success_color: PRGBA; 
                                  warning_color: PRGBA; 
                                  error_color: PRGBA; 
                                  was_symbolic: Pgboolean; 
                                  error: ptr PGError): PPixbuf {.
    cdecl, importc: "gtk_icon_info_load_symbolic", dynlib: lib.}
proc load_symbolic_async*(icon_info: PIconInfo; 
    fg: PRGBA; success_color: PRGBA; warning_color: PRGBA; 
    error_color: PRGBA; cancellable: PGCancellable; 
    callback: TGAsyncReadyCallback; user_data: gpointer) {.cdecl, 
    importc: "gtk_icon_info_load_symbolic_async", dynlib: lib.}
proc load_symbolic_finish*(icon_info: PIconInfo; 
    res: PGAsyncResult; was_symbolic: Pgboolean; error: ptr PGError): PPixbuf {.
    cdecl, importc: "gtk_icon_info_load_symbolic_finish", dynlib: lib.}
proc load_symbolic_for_context*(icon_info: PIconInfo; 
    context: PStyleContext; was_symbolic: Pgboolean; 
    error: ptr PGError): PPixbuf {.cdecl, 
    importc: "gtk_icon_info_load_symbolic_for_context", dynlib: lib.}
proc load_symbolic_for_context_async*(
    icon_info: PIconInfo; context: PStyleContext; 
    cancellable: PGCancellable; callback: TGAsyncReadyCallback; 
    user_data: gpointer) {.cdecl, importc: "gtk_icon_info_load_symbolic_for_context_async", 
                           dynlib: lib.}
proc load_symbolic_for_context_finish*(
    icon_info: PIconInfo; res: PGAsyncResult; 
    was_symbolic: Pgboolean; error: ptr PGError): PPixbuf {.cdecl, 
    importc: "gtk_icon_info_load_symbolic_for_context_finish", dynlib: lib.}
proc load_symbolic_for_style*(icon_info: PIconInfo; 
    style: PStyle; state: TStateType; was_symbolic: Pgboolean; 
    error: ptr PGError): PPixbuf {.cdecl, 
    importc: "gtk_icon_info_load_symbolic_for_style", dynlib: lib.}
proc set_raw_coordinates*(icon_info: PIconInfo; 
    raw_coordinates: gboolean) {.cdecl, importc: "gtk_icon_info_set_raw_coordinates", 
                                 dynlib: lib.}
proc get_embedded_rect*(icon_info: PIconInfo; 
                                      rectangle: gdk3.PRectangle): gboolean {.
    cdecl, importc: "gtk_icon_info_get_embedded_rect", dynlib: lib.}
proc get_attach_points*(icon_info: PIconInfo; 
                                      points: ptr PPoint; 
                                      n_points: Pgint): gboolean {.cdecl, 
    importc: "gtk_icon_info_get_attach_points", dynlib: lib.}
proc get_display_name*(icon_info: PIconInfo): CSTRING {.
    cdecl, importc: "gtk_icon_info_get_display_name", dynlib: lib.}
proc underscore_gtk_icon_theme_ensure_builtin_cache*() {.cdecl, 
    importc: "_gtk_icon_theme_ensure_builtin_cache", dynlib: lib.}

template TYPE_TOOLTIP*(): expr = 
  (gtk_tooltip_get_type())

template TOOLTIP_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TOOLTIP, TTooltip))

template IS_TOOLTIP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TOOLTIP))

proc tooltip_get_type*(): GType {.cdecl, importc: "gtk_tooltip_get_type", 
                                      dynlib: lib.}
proc set_markup*(tooltip: PTooltip; markup: CSTRING) {.
    cdecl, importc: "gtk_tooltip_set_markup", dynlib: lib.}
proc set_text*(tooltip: PTooltip; text: CSTRING) {.cdecl, 
    importc: "gtk_tooltip_set_text", dynlib: lib.}
proc set_icon*(tooltip: PTooltip; pixbuf: PPixbuf) {.
    cdecl, importc: "gtk_tooltip_set_icon", dynlib: lib.}
proc set_icon_from_stock*(tooltip: PTooltip; 
                                      stock_id: CSTRING; size: TIconSize) {.
    cdecl, importc: "gtk_tooltip_set_icon_from_stock", dynlib: lib.}
proc set_icon_from_icon_name*(tooltip: PTooltip; 
    icon_name: CSTRING; size: TIconSize) {.cdecl, 
    importc: "gtk_tooltip_set_icon_from_icon_name", dynlib: lib.}
proc set_icon_from_gicon*(tooltip: PTooltip; 
                                      gicon: PGIcon; size: TIconSize) {.
    cdecl, importc: "gtk_tooltip_set_icon_from_gicon", dynlib: lib.}
proc set_custom*(tooltip: PTooltip; 
                             custom_widget: PWidget) {.cdecl, 
    importc: "gtk_tooltip_set_custom", dynlib: lib.}
proc set_tip_area*(tooltip: PTooltip; rect: gdk3.PRectangle) {.
    cdecl, importc: "gtk_tooltip_set_tip_area", dynlib: lib.}
proc tooltip_trigger_tooltip_query*(display: PGdkDisplay) {.cdecl, 
    importc: "gtk_tooltip_trigger_tooltip_query", dynlib: lib.}
proc underscore_gtk_tooltip_focus_in*(widget: PWidget) {.cdecl, 
    importc: "_gtk_tooltip_focus_in", dynlib: lib.}
proc underscore_gtk_tooltip_focus_out*(widget: PWidget) {.cdecl, 
    importc: "_gtk_tooltip_focus_out", dynlib: lib.}
proc underscore_gtk_tooltip_toggle_keyboard_mode*(widget: PWidget) {.cdecl, 
    importc: "_gtk_tooltip_toggle_keyboard_mode", dynlib: lib.}
proc underscore_gtk_tooltip_handle_event*(event: PEvent) {.cdecl, 
    importc: "_gtk_tooltip_handle_event", dynlib: lib.}
proc underscore_gtk_tooltip_hide*(widget: PWidget) {.cdecl, 
    importc: "_gtk_tooltip_hide", dynlib: lib.}
proc underscore_gtk_widget_find_at_coords*(window: PGdkWindow; window_x: gint; 
                                 window_y: gint; widget_x: Pgint; 
                                 widget_y: Pgint): PWidget {.cdecl, 
    importc: "_gtk_widget_find_at_coords", dynlib: lib.}

type 
  PIconView* = ptr TIconView
  TIconView* = object of TContainer
    priv81: PIconViewPrivate

type 
  PIconViewClass* = ptr TIconViewClass
  TIconViewClass* = object of TContainerClass
    item_activated*: proc (icon_view: PIconView; path: PTreePath) {.
        cdecl.}
    selection_changed*: proc (icon_view: PIconView) {.cdecl.}
    select_all*: proc (icon_view: PIconView) {.cdecl.}
    unselect_all*: proc (icon_view: PIconView) {.cdecl.}
    select_cursor_item*: proc (icon_view: PIconView) {.cdecl.}
    toggle_cursor_item*: proc (icon_view: PIconView) {.cdecl.}
    move_cursor*: proc (icon_view: PIconView; step: TMovementStep; 
                        count: gint): gboolean {.cdecl.}
    activate_cursor_item*: proc (icon_view: PIconView): gboolean {.cdecl.}
    ugtk_reserved791: proc () {.cdecl.}
    ugtk_reserved792: proc () {.cdecl.}
    ugtk_reserved793: proc () {.cdecl.}
    ugtk_reserved794: proc () {.cdecl.}

template TYPE_ICON_VIEW*(): expr = 
  (gtk_icon_view_get_type())

template ICON_VIEW_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ICON_VIEW, TIconView))

template ICON_VIEW_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ICON_VIEW, TIconViewClass))

template IS_ICON_VIEW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ICON_VIEW))

template IS_ICON_VIEW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ICON_VIEW))

template ICON_VIEW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ICON_VIEW, TIconViewClass))

type 
  TIconViewForeachFunc* = proc (icon_view: PIconView; 
                                  path: PTreePath; data: gpointer) {.
      cdecl.}
type 
  TIconViewDropPosition* {.size: sizeof(cint).} = enum 
    ICON_VIEW_NO_DROP, ICON_VIEW_DROP_INTO, ICON_VIEW_DROP_LEFT, 
    ICON_VIEW_DROP_RIGHT, ICON_VIEW_DROP_ABOVE, 
    ICON_VIEW_DROP_BELOW

proc icon_view_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_view_get_type", dynlib: lib.}
proc icon_view_new*(): PWidget {.cdecl, 
    importc: "gtk_icon_view_new", dynlib: lib.}
proc icon_view_new_with_area*(area: PCellArea): PWidget {.
    cdecl, importc: "gtk_icon_view_new_with_area", dynlib: lib.}
proc icon_view_new_with_model*(model: PTreeModel): PWidget {.
    cdecl, importc: "gtk_icon_view_new_with_model", dynlib: lib.}
proc set_model*(icon_view: PIconView; 
                              model: PTreeModel) {.cdecl, 
    importc: "gtk_icon_view_set_model", dynlib: lib.}
proc get_model*(icon_view: PIconView): PTreeModel {.
    cdecl, importc: "gtk_icon_view_get_model", dynlib: lib.}
proc set_text_column*(icon_view: PIconView; column: gint) {.
    cdecl, importc: "gtk_icon_view_set_text_column", dynlib: lib.}
proc get_text_column*(icon_view: PIconView): gint {.cdecl, 
    importc: "gtk_icon_view_get_text_column", dynlib: lib.}
proc set_markup_column*(icon_view: PIconView; column: gint) {.
    cdecl, importc: "gtk_icon_view_set_markup_column", dynlib: lib.}
proc get_markup_column*(icon_view: PIconView): gint {.
    cdecl, importc: "gtk_icon_view_get_markup_column", dynlib: lib.}
proc set_pixbuf_column*(icon_view: PIconView; column: gint) {.
    cdecl, importc: "gtk_icon_view_set_pixbuf_column", dynlib: lib.}
proc get_pixbuf_column*(icon_view: PIconView): gint {.
    cdecl, importc: "gtk_icon_view_get_pixbuf_column", dynlib: lib.}
proc set_item_orientation*(icon_view: PIconView; 
    orientation: TOrientation) {.cdecl, importc: "gtk_icon_view_set_item_orientation", 
                                   dynlib: lib.}
proc get_item_orientation*(icon_view: PIconView): TOrientation {.
    cdecl, importc: "gtk_icon_view_get_item_orientation", dynlib: lib.}
proc set_columns*(icon_view: PIconView; columns: gint) {.
    cdecl, importc: "gtk_icon_view_set_columns", dynlib: lib.}
proc get_columns*(icon_view: PIconView): gint {.cdecl, 
    importc: "gtk_icon_view_get_columns", dynlib: lib.}
proc set_item_width*(icon_view: PIconView; 
                                   item_width: gint) {.cdecl, 
    importc: "gtk_icon_view_set_item_width", dynlib: lib.}
proc get_item_width*(icon_view: PIconView): gint {.cdecl, 
    importc: "gtk_icon_view_get_item_width", dynlib: lib.}
proc set_spacing*(icon_view: PIconView; spacing: gint) {.
    cdecl, importc: "gtk_icon_view_set_spacing", dynlib: lib.}
proc get_spacing*(icon_view: PIconView): gint {.cdecl, 
    importc: "gtk_icon_view_get_spacing", dynlib: lib.}
proc set_row_spacing*(icon_view: PIconView; 
                                    row_spacing: gint) {.cdecl, 
    importc: "gtk_icon_view_set_row_spacing", dynlib: lib.}
proc get_row_spacing*(icon_view: PIconView): gint {.cdecl, 
    importc: "gtk_icon_view_get_row_spacing", dynlib: lib.}
proc set_column_spacing*(icon_view: PIconView; 
    column_spacing: gint) {.cdecl, 
                            importc: "gtk_icon_view_set_column_spacing", 
                            dynlib: lib.}
proc get_column_spacing*(icon_view: PIconView): gint {.
    cdecl, importc: "gtk_icon_view_get_column_spacing", dynlib: lib.}
proc set_margin*(icon_view: PIconView; margin: gint) {.
    cdecl, importc: "gtk_icon_view_set_margin", dynlib: lib.}
proc get_margin*(icon_view: PIconView): gint {.cdecl, 
    importc: "gtk_icon_view_get_margin", dynlib: lib.}
proc set_item_padding*(icon_view: PIconView; 
                                     item_padding: gint) {.cdecl, 
    importc: "gtk_icon_view_set_item_padding", dynlib: lib.}
proc get_item_padding*(icon_view: PIconView): gint {.
    cdecl, importc: "gtk_icon_view_get_item_padding", dynlib: lib.}
proc get_path_at_pos*(icon_view: PIconView; x: gint; 
                                    y: gint): PTreePath {.cdecl, 
    importc: "gtk_icon_view_get_path_at_pos", dynlib: lib.}
proc get_item_at_pos*(icon_view: PIconView; x: gint; 
                                    y: gint; path: ptr PTreePath; 
                                    cell: ptr PCellRenderer): gboolean {.
    cdecl, importc: "gtk_icon_view_get_item_at_pos", dynlib: lib.}
proc get_visible_range*(icon_view: PIconView; 
                                      start_path: ptr PTreePath; 
                                      end_path: ptr PTreePath): gboolean {.
    cdecl, importc: "gtk_icon_view_get_visible_range", dynlib: lib.}
proc set_activate_on_single_click*(icon_view: PIconView; 
    single: gboolean) {.cdecl, importc: "gtk_icon_view_set_activate_on_single_click", 
                        dynlib: lib.}
proc get_activate_on_single_click*(icon_view: PIconView): gboolean {.
    cdecl, importc: "gtk_icon_view_get_activate_on_single_click", dynlib: lib.}
proc selected_foreach*(icon_view: PIconView; 
                                     func: TIconViewForeachFunc; 
                                     data: gpointer) {.cdecl, 
    importc: "gtk_icon_view_selected_foreach", dynlib: lib.}
proc set_selection_mode*(icon_view: PIconView; 
    mode: TSelectionMode) {.cdecl, 
                              importc: "gtk_icon_view_set_selection_mode", 
                              dynlib: lib.}
proc get_selection_mode*(icon_view: PIconView): TSelectionMode {.
    cdecl, importc: "gtk_icon_view_get_selection_mode", dynlib: lib.}
proc select_path*(icon_view: PIconView; 
                                path: PTreePath) {.cdecl, 
    importc: "gtk_icon_view_select_path", dynlib: lib.}
proc unselect_path*(icon_view: PIconView; 
                                  path: PTreePath) {.cdecl, 
    importc: "gtk_icon_view_unselect_path", dynlib: lib.}
proc path_is_selected*(icon_view: PIconView; 
                                     path: PTreePath): gboolean {.cdecl, 
    importc: "gtk_icon_view_path_is_selected", dynlib: lib.}
proc get_item_row*(icon_view: PIconView; 
                                 path: PTreePath): gint {.cdecl, 
    importc: "gtk_icon_view_get_item_row", dynlib: lib.}
proc get_item_column*(icon_view: PIconView; 
                                    path: PTreePath): gint {.cdecl, 
    importc: "gtk_icon_view_get_item_column", dynlib: lib.}
proc get_selected_items*(icon_view: PIconView): PGList {.
    cdecl, importc: "gtk_icon_view_get_selected_items", dynlib: lib.}
proc select_all*(icon_view: PIconView) {.cdecl, 
    importc: "gtk_icon_view_select_all", dynlib: lib.}
proc unselect_all*(icon_view: PIconView) {.cdecl, 
    importc: "gtk_icon_view_unselect_all", dynlib: lib.}
proc item_activated*(icon_view: PIconView; 
                                   path: PTreePath) {.cdecl, 
    importc: "gtk_icon_view_item_activated", dynlib: lib.}
proc set_cursor*(icon_view: PIconView; 
                               path: PTreePath; 
                               cell: PCellRenderer; 
                               start_editing: gboolean) {.cdecl, 
    importc: "gtk_icon_view_set_cursor", dynlib: lib.}
proc get_cursor*(icon_view: PIconView; 
                               path: ptr PTreePath; 
                               cell: ptr PCellRenderer): gboolean {.
    cdecl, importc: "gtk_icon_view_get_cursor", dynlib: lib.}
proc scroll_to_path*(icon_view: PIconView; 
                                   path: PTreePath; use_align: gboolean; 
                                   row_align: gfloat; col_align: gfloat) {.
    cdecl, importc: "gtk_icon_view_scroll_to_path", dynlib: lib.}
proc enable_model_drag_source*(icon_view: PIconView; 
    start_button_mask: gdk3.TModifierType; targets: PTargetEntry; 
    n_targets: gint; actions: TDragAction) {.cdecl, 
    importc: "gtk_icon_view_enable_model_drag_source", dynlib: lib.}
proc enable_model_drag_dest*(icon_view: PIconView; 
    targets: PTargetEntry; n_targets: gint; actions: TDragAction) {.
    cdecl, importc: "gtk_icon_view_enable_model_drag_dest", dynlib: lib.}
proc unset_model_drag_source*(icon_view: PIconView) {.
    cdecl, importc: "gtk_icon_view_unset_model_drag_source", dynlib: lib.}
proc unset_model_drag_dest*(icon_view: PIconView) {.cdecl, 
    importc: "gtk_icon_view_unset_model_drag_dest", dynlib: lib.}
proc set_reorderable*(icon_view: PIconView; 
                                    reorderable: gboolean) {.cdecl, 
    importc: "gtk_icon_view_set_reorderable", dynlib: lib.}
proc get_reorderable*(icon_view: PIconView): gboolean {.
    cdecl, importc: "gtk_icon_view_get_reorderable", dynlib: lib.}
proc set_drag_dest_item*(icon_view: PIconView; 
    path: PTreePath; pos: TIconViewDropPosition) {.cdecl, 
    importc: "gtk_icon_view_set_drag_dest_item", dynlib: lib.}
proc get_drag_dest_item*(icon_view: PIconView; 
    path: ptr PTreePath; pos: var TIconViewDropPosition) {.cdecl, 
    importc: "gtk_icon_view_get_drag_dest_item", dynlib: lib.}
proc get_dest_item_at_pos*(icon_view: PIconView; 
    drag_x: gint; drag_y: gint; path: ptr PTreePath; 
    pos: var TIconViewDropPosition): gboolean {.cdecl, 
    importc: "gtk_icon_view_get_dest_item_at_pos", dynlib: lib.}
proc create_drag_icon*(icon_view: PIconView; 
                                     path: PTreePath): Psurface {.
    cdecl, importc: "gtk_icon_view_create_drag_icon", dynlib: lib.}
proc convert_widget_to_bin_window_coords*(
    icon_view: PIconView; wx: gint; wy: gint; bx: Pgint; by: Pgint) {.
    cdecl, importc: "gtk_icon_view_convert_widget_to_bin_window_coords", 
    dynlib: lib.}
proc get_cell_rect*(icon_view: PIconView; 
                                  path: PTreePath; 
                                  cell: PCellRenderer; 
                                  rect: gdk3.PRectangle): gboolean {.cdecl, 
    importc: "gtk_icon_view_get_cell_rect", dynlib: lib.}
proc set_tooltip_item*(icon_view: PIconView; 
                                     tooltip: PTooltip; 
                                     path: PTreePath) {.cdecl, 
    importc: "gtk_icon_view_set_tooltip_item", dynlib: lib.}
proc set_tooltip_cell*(icon_view: PIconView; 
                                     tooltip: PTooltip; 
                                     path: PTreePath; 
                                     cell: PCellRenderer) {.cdecl, 
    importc: "gtk_icon_view_set_tooltip_cell", dynlib: lib.}
proc get_tooltip_context*(icon_view: PIconView; 
    x: Pgint; y: Pgint; keyboard_tip: gboolean; 
    model: ptr PTreeModel; path: ptr PTreePath; 
    iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_icon_view_get_tooltip_context", dynlib: lib.}
proc set_tooltip_column*(icon_view: PIconView; 
    column: gint) {.cdecl, importc: "gtk_icon_view_set_tooltip_column", 
                    dynlib: lib.}
proc get_tooltip_column*(icon_view: PIconView): gint {.
    cdecl, importc: "gtk_icon_view_get_tooltip_column", dynlib: lib.}

type 
  PIMContextInfo* = ptr TIMContextInfo
  TIMContextInfo*{.final, pure.} = object 
    context_id*: CSTRING
    context_name*: CSTRING
    domain*: CSTRING
    domain_dirname*: CSTRING
    default_locales*: CSTRING


const 
  MAX_COMPOSE_LEN* = 7
template TYPE_IM_CONTEXT_SIMPLE*(): expr = 
  (gtk_im_context_simple_get_type())

template IM_CONTEXT_SIMPLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_IM_CONTEXT_SIMPLE, 
                              TIMContextSimple))

template IM_CONTEXT_SIMPLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_IM_CONTEXT_SIMPLE, 
                           TIMContextSimpleClass))

template IS_IM_CONTEXT_SIMPLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_IM_CONTEXT_SIMPLE))

template IS_IM_CONTEXT_SIMPLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_IM_CONTEXT_SIMPLE))

template IM_CONTEXT_SIMPLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_IM_CONTEXT_SIMPLE, 
                             TIMContextSimpleClass))

type 
  PIMContextSimple* = ptr TIMContextSimple
  TIMContextSimple* = object of TIMContext
    priv82: PIMContextSimplePrivate

type 
  PIMContextSimpleClass* = ptr TIMContextSimpleClass
  TIMContextSimpleClass* = object of TIMContextClass

proc im_context_simple_get_type*(): GType {.cdecl, 
    importc: "gtk_im_context_simple_get_type", dynlib: lib.}
proc im_context_simple_new*(): PIMContext {.cdecl, 
    importc: "gtk_im_context_simple_new", dynlib: lib.}
proc add_table*(context_simple: PIMContextSimple; 
                                      data: Pguint16; max_seq_len: gint; 
                                      n_seqs: gint) {.cdecl, 
    importc: "gtk_im_context_simple_add_table", dynlib: lib.}

template TYPE_IM_MULTICONTEXT*(): expr = 
  (gtk_im_multicontext_get_type())

template IM_MULTICONTEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_IM_MULTICONTEXT, 
                              TIMMulticontext))

template IM_MULTICONTEXT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_IM_MULTICONTEXT, 
                           TIMMulticontextClass))

template IS_IM_MULTICONTEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_IM_MULTICONTEXT))

template IS_IM_MULTICONTEXT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_IM_MULTICONTEXT))

template IM_MULTICONTEXT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_IM_MULTICONTEXT, 
                             TIMMulticontextClass))

type 
  PIMMulticontext* = ptr TIMMulticontext
  TIMMulticontext* = object of TIMContext
    priv83: PIMMulticontextPrivate

type 
  PIMMulticontextClass* = ptr TIMMulticontextClass
  TIMMulticontextClass* = object of TIMContextClass
    ugtk_reserved801: proc () {.cdecl.}
    ugtk_reserved802: proc () {.cdecl.}
    ugtk_reserved803: proc () {.cdecl.}
    ugtk_reserved804: proc () {.cdecl.}

proc im_multicontext_get_type*(): GType {.cdecl, 
    importc: "gtk_im_multicontext_get_type", dynlib: lib.}
proc im_multicontext_new*(): PIMContext {.cdecl, 
    importc: "gtk_im_multicontext_new", dynlib: lib.}
proc append_menuitems*(context: PIMMulticontext; 
    menushell: PMenuShell) {.cdecl, importc: "gtk_im_multicontext_append_menuitems", 
                                   dynlib: lib.}
proc get_context_id*(context: PIMMulticontext): cstring {.
    cdecl, importc: "gtk_im_multicontext_get_context_id", dynlib: lib.}
proc set_context_id*(context: PIMMulticontext; 
    context_id: cstring) {.cdecl, 
                           importc: "gtk_im_multicontext_set_context_id", 
                           dynlib: lib.}

template TYPE_INFO_BAR*(): expr = 
  (gtk_info_bar_get_type())

template INFO_BAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_INFO_BAR, TInfoBar))

template INFO_BAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_INFO_BAR, TInfoBarClass))

template IS_INFO_BAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_INFO_BAR))

template IS_INFO_BAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_INFO_BAR))

template INFO_BAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_INFO_BAR, TInfoBarClass))

type 
  PInfoBar* = ptr TInfoBar
  TInfoBar* = object of TBox
    priv84: PInfoBarPrivate

type 
  PInfoBarClass* = ptr TInfoBarClass
  TInfoBarClass* = object of TBoxClass
    response*: proc (info_bar: PInfoBar; response_id: gint) {.cdecl.}
    close*: proc (info_bar: PInfoBar) {.cdecl.}
    ugtk_reserved811: proc () {.cdecl.}
    ugtk_reserved812: proc () {.cdecl.}
    ugtk_reserved813: proc () {.cdecl.}
    ugtk_reserved814: proc () {.cdecl.}

proc info_bar_get_type*(): GType {.cdecl, 
    importc: "gtk_info_bar_get_type", dynlib: lib.}
proc info_bar_new*(): PWidget {.cdecl, importc: "gtk_info_bar_new", 
    dynlib: lib.}
proc info_bar_new_with_buttons*(first_button_text: CSTRING): PWidget {.
    varargs, cdecl, importc: "gtk_info_bar_new_with_buttons", dynlib: lib.}
proc get_action_area*(info_bar: PInfoBar): PWidget {.
    cdecl, importc: "gtk_info_bar_get_action_area", dynlib: lib.}
proc get_content_area*(info_bar: PInfoBar): PWidget {.
    cdecl, importc: "gtk_info_bar_get_content_area", dynlib: lib.}
proc add_action_widget*(info_bar: PInfoBar; 
                                     child: PWidget; response_id: gint) {.
    cdecl, importc: "gtk_info_bar_add_action_widget", dynlib: lib.}
proc add_button*(info_bar: PInfoBar; 
                              button_text: CSTRING; response_id: gint): PWidget {.
    cdecl, importc: "gtk_info_bar_add_button", dynlib: lib.}
proc add_buttons*(info_bar: PInfoBar; 
                               first_button_text: CSTRING) {.varargs, cdecl, 
    importc: "gtk_info_bar_add_buttons", dynlib: lib.}
proc set_response_sensitive*(info_bar: PInfoBar; 
    response_id: gint; setting: gboolean) {.cdecl, 
    importc: "gtk_info_bar_set_response_sensitive", dynlib: lib.}
proc set_default_response*(info_bar: PInfoBar; 
    response_id: gint) {.cdecl, importc: "gtk_info_bar_set_default_response", 
                         dynlib: lib.}
proc response*(info_bar: PInfoBar; response_id: gint) {.
    cdecl, importc: "gtk_info_bar_response", dynlib: lib.}
proc set_message_type*(info_bar: PInfoBar; 
                                    message_type: TMessageType) {.cdecl, 
    importc: "gtk_info_bar_set_message_type", dynlib: lib.}
proc get_message_type*(info_bar: PInfoBar): TMessageType {.
    cdecl, importc: "gtk_info_bar_get_message_type", dynlib: lib.}
proc set_show_close_button*(info_bar: PInfoBar; 
    setting: gboolean) {.cdecl, importc: "gtk_info_bar_set_show_close_button", 
                         dynlib: lib.}
proc get_show_close_button*(info_bar: PInfoBar): gboolean {.
    cdecl, importc: "gtk_info_bar_get_show_close_button", dynlib: lib.}

template TYPE_INVISIBLE*(): expr = 
  (gtk_invisible_get_type())

template INVISIBLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_INVISIBLE, TInvisible))

template INVISIBLE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_INVISIBLE, TInvisibleClass))

template IS_INVISIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_INVISIBLE))

template IS_INVISIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_INVISIBLE))

template INVISIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_INVISIBLE, TInvisibleClass))

type 
  PInvisible* = ptr TInvisible
  TInvisible* = object of TWidget
    priv85: PInvisiblePrivate

type 
  PInvisibleClass* = ptr TInvisibleClass
  TInvisibleClass* = object of TWidgetClass
    ugtk_reserved821: proc () {.cdecl.}
    ugtk_reserved822: proc () {.cdecl.}
    ugtk_reserved823: proc () {.cdecl.}
    ugtk_reserved824: proc () {.cdecl.}

proc invisible_get_type*(): GType {.cdecl, 
    importc: "gtk_invisible_get_type", dynlib: lib.}
proc invisible_new*(): PWidget {.cdecl, 
    importc: "gtk_invisible_new", dynlib: lib.}
proc invisible_new_for_screen*(screen: PGdkScreen): PWidget {.
    cdecl, importc: "gtk_invisible_new_for_screen", dynlib: lib.}
proc set_screen*(invisible: PInvisible; 
                               screen: PGdkScreen) {.cdecl, 
    importc: "gtk_invisible_set_screen", dynlib: lib.}
proc get_screen*(invisible: PInvisible): PGdkScreen {.
    cdecl, importc: "gtk_invisible_get_screen", dynlib: lib.}

template TYPE_LAYOUT*(): expr = 
  (gtk_layout_get_type())

template LAYOUT_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_LAYOUT, TLayout))

template LAYOUT_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_LAYOUT, TLayoutClass))

template IS_LAYOUT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_LAYOUT))

template IS_LAYOUT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_LAYOUT))

template LAYOUT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_LAYOUT, TLayoutClass))

type 
  PLayout* = ptr TLayout
  TLayout* = object of TContainer
    priv86: PLayoutPrivate

type 
  PLayoutClass* = ptr TLayoutClass
  TLayoutClass* = object of TContainerClass
    ugtk_reserved831: proc () {.cdecl.}
    ugtk_reserved832: proc () {.cdecl.}
    ugtk_reserved833: proc () {.cdecl.}
    ugtk_reserved834: proc () {.cdecl.}

proc layout_get_type*(): GType {.cdecl, importc: "gtk_layout_get_type", 
                                     dynlib: lib.}
proc layout_new*(hadjustment: PAdjustment; 
                     vadjustment: PAdjustment): PWidget {.cdecl, 
    importc: "gtk_layout_new", dynlib: lib.}
proc get_bin_window*(layout: PLayout): PGdkWindow {.cdecl, 
    importc: "gtk_layout_get_bin_window", dynlib: lib.}
proc put*(layout: PLayout; child_widget: PWidget; 
                     x: gint; y: gint) {.cdecl, importc: "gtk_layout_put", 
    dynlib: lib.}
proc move*(layout: PLayout; child_widget: PWidget; 
                      x: gint; y: gint) {.cdecl, importc: "gtk_layout_move", 
    dynlib: lib.}
proc set_size*(layout: PLayout; width: guint; height: guint) {.
    cdecl, importc: "gtk_layout_set_size", dynlib: lib.}
proc get_size*(layout: PLayout; width: Pguint; 
                          height: Pguint) {.cdecl, 
    importc: "gtk_layout_get_size", dynlib: lib.}
proc get_hadjustment*(layout: PLayout): PAdjustment {.
    cdecl, importc: "gtk_layout_get_hadjustment", dynlib: lib.}
proc get_vadjustment*(layout: PLayout): PAdjustment {.
    cdecl, importc: "gtk_layout_get_vadjustment", dynlib: lib.}
proc set_hadjustment*(layout: PLayout; 
                                 adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_layout_set_hadjustment", dynlib: lib.}
proc set_vadjustment*(layout: PLayout; 
                                 adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_layout_set_vadjustment", dynlib: lib.}

template TYPE_LEVEL_BAR*(): expr = 
  (gtk_level_bar_get_type())

template LEVEL_BAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_LEVEL_BAR, TLevelBar))

template LEVEL_BAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_LEVEL_BAR, TLevelBarClass))

template IS_LEVEL_BAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_LEVEL_BAR))

template IS_LEVEL_BAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_LEVEL_BAR))

template LEVEL_BAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_LEVEL_BAR, TLevelBarClass))

const 
  LEVEL_BAR_OFFSET_LOW* = "low"
const 
  LEVEL_BAR_OFFSET_HIGH* = "high"
type 
  PLevelBar* = ptr TLevelBar
  TLevelBar* = object of TWidget
    priv87: PLevelBarPrivate

type 
  PLevelBarClass* = ptr TLevelBarClass
  TLevelBarClass* = object of TWidgetClass
    offset_changed*: proc (self: PLevelBar; name: CSTRING) {.cdecl.}
    padding*: array[16, gpointer]

proc level_bar_get_type*(): GType {.cdecl, 
    importc: "gtk_level_bar_get_type", dynlib: lib.}
proc level_bar_new*(): PWidget {.cdecl, 
    importc: "gtk_level_bar_new", dynlib: lib.}
proc level_bar_new_for_interval*(min_value: gdouble; max_value: gdouble): PWidget {.
    cdecl, importc: "gtk_level_bar_new_for_interval", dynlib: lib.}
proc set_mode*(self: PLevelBar; mode: TLevelBarMode) {.
    cdecl, importc: "gtk_level_bar_set_mode", dynlib: lib.}
proc get_mode*(self: PLevelBar): TLevelBarMode {.cdecl, 
    importc: "gtk_level_bar_get_mode", dynlib: lib.}
proc set_value*(self: PLevelBar; value: gdouble) {.cdecl, 
    importc: "gtk_level_bar_set_value", dynlib: lib.}
proc get_value*(self: PLevelBar): gdouble {.cdecl, 
    importc: "gtk_level_bar_get_value", dynlib: lib.}
proc set_min_value*(self: PLevelBar; value: gdouble) {.
    cdecl, importc: "gtk_level_bar_set_min_value", dynlib: lib.}
proc get_min_value*(self: PLevelBar): gdouble {.cdecl, 
    importc: "gtk_level_bar_get_min_value", dynlib: lib.}
proc set_max_value*(self: PLevelBar; value: gdouble) {.
    cdecl, importc: "gtk_level_bar_set_max_value", dynlib: lib.}
proc get_max_value*(self: PLevelBar): gdouble {.cdecl, 
    importc: "gtk_level_bar_get_max_value", dynlib: lib.}
proc set_inverted*(self: PLevelBar; inverted: gboolean) {.
    cdecl, importc: "gtk_level_bar_set_inverted", dynlib: lib.}
proc get_inverted*(self: PLevelBar): gboolean {.cdecl, 
    importc: "gtk_level_bar_get_inverted", dynlib: lib.}
proc add_offset_value*(self: PLevelBar; name: CSTRING; 
                                     value: gdouble) {.cdecl, 
    importc: "gtk_level_bar_add_offset_value", dynlib: lib.}
proc remove_offset_value*(self: PLevelBar; name: CSTRING) {.
    cdecl, importc: "gtk_level_bar_remove_offset_value", dynlib: lib.}
proc get_offset_value*(self: PLevelBar; name: CSTRING; 
                                     value: Pgdouble): gboolean {.cdecl, 
    importc: "gtk_level_bar_get_offset_value", dynlib: lib.}

template TYPE_LINK_BUTTON*(): expr = 
  (gtk_link_button_get_type())

template LINK_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_LINK_BUTTON, TLinkButton))

template IS_LINK_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_LINK_BUTTON))

template LINK_BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_LINK_BUTTON, TLinkButtonClass))

template IS_LINK_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_LINK_BUTTON))

template LINK_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_LINK_BUTTON, TLinkButtonClass))

type 
  PLinkButton* = ptr TLinkButton
  TLinkButton* = object of TButton
    priv88: PLinkButtonPrivate

type 
  PLinkButtonClass* = ptr TLinkButtonClass
  TLinkButtonClass* = object of TButtonClass
    activate_link*: proc (button: PLinkButton): gboolean {.cdecl.}
    ugtk_padding1*: proc () {.cdecl.}
    ugtk_padding2*: proc () {.cdecl.}
    ugtk_padding3*: proc () {.cdecl.}
    ugtk_padding4*: proc () {.cdecl.}

proc link_button_get_type*(): GType {.cdecl, 
    importc: "gtk_link_button_get_type", dynlib: lib.}
proc link_button_new*(uri: CSTRING): PWidget {.cdecl, 
    importc: "gtk_link_button_new", dynlib: lib.}
proc link_button_new_with_label*(uri: CSTRING; label: CSTRING): PWidget {.
    cdecl, importc: "gtk_link_button_new_with_label", dynlib: lib.}
proc get_uri*(link_button: PLinkButton): CSTRING {.
    cdecl, importc: "gtk_link_button_get_uri", dynlib: lib.}
proc set_uri*(link_button: PLinkButton; uri: CSTRING) {.
    cdecl, importc: "gtk_link_button_set_uri", dynlib: lib.}
proc get_visited*(link_button: PLinkButton): gboolean {.
    cdecl, importc: "gtk_link_button_get_visited", dynlib: lib.}
proc set_visited*(link_button: PLinkButton; 
                                  visited: gboolean) {.cdecl, 
    importc: "gtk_link_button_set_visited", dynlib: lib.}

template TYPE_LIST_BOX*(): expr = 
  (gtk_list_box_get_type())

template LIST_BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_LIST_BOX, TListBox))

template LIST_BOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_LIST_BOX, TListBoxClass))

template IS_LIST_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_LIST_BOX))

template IS_LIST_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_LIST_BOX))

template LIST_BOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_LIST_BOX, TListBoxClass))

type 
  PListBox* = ptr TListBox
  TListBox* = object of TContainer
type 
  PListBoxRow* = ptr TListBoxRow
  TListBoxRow* = object of TBin

type 
  PListBoxRowClass* = ptr TListBoxRowClass
  TListBoxRowClass* = object of TBinClass
    activate*: proc (row: PListBoxRow) {.cdecl.}
    ugtk_reserved841: proc () {.cdecl.}
    ugtk_reserved842: proc () {.cdecl.}

type 
  PListBoxClass* = ptr TListBoxClass
  TListBoxClass* = object of TContainerClass
    row_selected*: proc (list_box: PListBox; row: PListBoxRow) {.
        cdecl.}
    row_activated*: proc (list_box: PListBox; row: PListBoxRow) {.
        cdecl.}
    activate_cursor_row*: proc (list_box: PListBox) {.cdecl.}
    toggle_cursor_row*: proc (list_box: PListBox) {.cdecl.}
    move_cursor*: proc (list_box: PListBox; step: TMovementStep; 
                        count: gint) {.cdecl.}
    ugtk_reserved851: proc () {.cdecl.}
    ugtk_reserved852: proc () {.cdecl.}
    ugtk_reserved853: proc () {.cdecl.}
    ugtk_reserved854: proc () {.cdecl.}
    ugtk_reserved855: proc () {.cdecl.}
    ugtk_reserved856: proc () {.cdecl.}

template TYPE_LIST_BOX_ROW*(): expr = 
  (gtk_list_box_row_get_type())

template LIST_BOX_ROW_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_LIST_BOX_ROW, TListBoxRow))

template LIST_BOX_ROW_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_LIST_BOX_ROW, TListBoxRowClass))

template IS_LIST_BOX_ROW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_LIST_BOX_ROW))

template IS_LIST_BOX_ROW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_LIST_BOX_ROW))

template LIST_BOX_ROW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_LIST_BOX_ROW, TListBoxRowClass))


type 
  TListBoxFilterFunc* = proc (row: PListBoxRow; user_data: gpointer): gboolean {.
      cdecl.}
type 
  TListBoxSortFunc* = proc (row1: PListBoxRow; 
                              row2: PListBoxRow; user_data: gpointer): gint {.
      cdecl.}
type 
  TListBoxUpdateHeaderFunc* = proc (row: PListBoxRow; 
                                      before: PListBoxRow; 
                                      user_data: gpointer) {.cdecl.}
proc list_box_row_get_type*(): GType {.cdecl, 
    importc: "gtk_list_box_row_get_type", dynlib: lib.}
proc list_box_row_new*(): PWidget {.cdecl, 
    importc: "gtk_list_box_row_new", dynlib: lib.}
proc get_header*(row: PListBoxRow): PWidget {.
    cdecl, importc: "gtk_list_box_row_get_header", dynlib: lib.}
proc set_header*(row: PListBoxRow; 
                                  header: PWidget) {.cdecl, 
    importc: "gtk_list_box_row_set_header", dynlib: lib.}
proc get_index*(row: PListBoxRow): gint {.cdecl, 
    importc: "gtk_list_box_row_get_index", dynlib: lib.}
proc changed*(row: PListBoxRow) {.cdecl, 
    importc: "gtk_list_box_row_changed", dynlib: lib.}
proc list_box_get_type*(): GType {.cdecl, 
    importc: "gtk_list_box_get_type", dynlib: lib.}
proc prepend*(list_box: PListBox; child: PWidget) {.
    cdecl, importc: "gtk_list_box_prepend", dynlib: lib.}
proc insert*(list_box: PListBox; child: PWidget; 
                          position: gint) {.cdecl, 
    importc: "gtk_list_box_insert", dynlib: lib.}
proc get_selected_row*(list_box: PListBox): PListBoxRow {.
    cdecl, importc: "gtk_list_box_get_selected_row", dynlib: lib.}
proc get_row_at_index*(list_box: PListBox; index: gint): PListBoxRow {.
    cdecl, importc: "gtk_list_box_get_row_at_index", dynlib: lib.}
proc get_row_at_y*(list_box: PListBox; y: gint): PListBoxRow {.
    cdecl, importc: "gtk_list_box_get_row_at_y", dynlib: lib.}
proc select_row*(list_box: PListBox; row: PListBoxRow) {.
    cdecl, importc: "gtk_list_box_select_row", dynlib: lib.}
proc set_placeholder*(list_box: PListBox; 
                                   placeholder: PWidget) {.cdecl, 
    importc: "gtk_list_box_set_placeholder", dynlib: lib.}
proc set_adjustment*(list_box: PListBox; 
                                  adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_list_box_set_adjustment", dynlib: lib.}
proc get_adjustment*(list_box: PListBox): PAdjustment {.
    cdecl, importc: "gtk_list_box_get_adjustment", dynlib: lib.}
proc set_selection_mode*(list_box: PListBox; 
                                      mode: TSelectionMode) {.cdecl, 
    importc: "gtk_list_box_set_selection_mode", dynlib: lib.}
proc get_selection_mode*(list_box: PListBox): TSelectionMode {.
    cdecl, importc: "gtk_list_box_get_selection_mode", dynlib: lib.}
proc set_filter_func*(list_box: PListBox; 
                                   filter_func: TListBoxFilterFunc; 
                                   user_data: gpointer; 
                                   destroy: TGDestroyNotify) {.cdecl, 
    importc: "gtk_list_box_set_filter_func", dynlib: lib.}
proc set_header_func*(list_box: PListBox; 
                                   update_header: TListBoxUpdateHeaderFunc; 
                                   user_data: gpointer; 
                                   destroy: TGDestroyNotify) {.cdecl, 
    importc: "gtk_list_box_set_header_func", dynlib: lib.}
proc invalidate_filter*(list_box: PListBox) {.cdecl, 
    importc: "gtk_list_box_invalidate_filter", dynlib: lib.}
proc invalidate_sort*(list_box: PListBox) {.cdecl, 
    importc: "gtk_list_box_invalidate_sort", dynlib: lib.}
proc invalidate_headers*(list_box: PListBox) {.cdecl, 
    importc: "gtk_list_box_invalidate_headers", dynlib: lib.}
proc set_sort_func*(list_box: PListBox; 
                                 sort_func: TListBoxSortFunc; 
                                 user_data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_list_box_set_sort_func", dynlib: lib.}
proc set_activate_on_single_click*(list_box: PListBox; 
    single: gboolean) {.cdecl, 
                        importc: "gtk_list_box_set_activate_on_single_click", 
                        dynlib: lib.}
proc get_activate_on_single_click*(list_box: PListBox): gboolean {.
    cdecl, importc: "gtk_list_box_get_activate_on_single_click", dynlib: lib.}
proc drag_unhighlight_row*(list_box: PListBox) {.cdecl, 
    importc: "gtk_list_box_drag_unhighlight_row", dynlib: lib.}
proc drag_highlight_row*(list_box: PListBox; 
                                      row: PListBoxRow) {.cdecl, 
    importc: "gtk_list_box_drag_highlight_row", dynlib: lib.}
proc list_box_new*(): PWidget {.cdecl, importc: "gtk_list_box_new", 
    dynlib: lib.}

template TYPE_LOCK_BUTTON*(): expr = 
  (gtk_lock_button_get_type())

template LOCK_BUTTON_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_LOCK_BUTTON, TLockButton))

template LOCK_BUTTON_CLASS_TEMPLATE*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((k), LOCK_BUTTON, TLockButtonClass))

template IS_LOCK_BUTTON*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_LOCK_BUTTON))

template IS_LOCK_BUTTON_CLASS*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((k), TYPE_LOCK_BUTTON))

template LOCK_BUTTON_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_LOCK_BUTTON, TLockButtonClass))

type 
  PLockButton* = ptr TLockButton
  TLockButton* = object of TButton
    priv89: PLockButtonPrivate

type 
  PLockButtonClass* = ptr TLockButtonClass
  TLockButtonClass* = object of TButtonClass
    reserved0: proc () {.cdecl.}
    reserved1: proc () {.cdecl.}
    reserved2: proc () {.cdecl.}
    reserved3: proc () {.cdecl.}
    reserved4: proc () {.cdecl.}
    reserved5: proc () {.cdecl.}
    reserved6: proc () {.cdecl.}
    reserved7: proc () {.cdecl.}

proc lock_button_get_type*(): GType {.cdecl, 
    importc: "gtk_lock_button_get_type", dynlib: lib.}
proc lock_button_new*(permission: PGPermission): PWidget {.cdecl, 
    importc: "gtk_lock_button_new", dynlib: lib.}
proc get_permission*(button: PLockButton): PGPermission {.
    cdecl, importc: "gtk_lock_button_get_permission", dynlib: lib.}
proc set_permission*(button: PLockButton; 
                                     permission: PGPermission) {.cdecl, 
    importc: "gtk_lock_button_set_permission", dynlib: lib.}

const 
  PRIORITY_RESIZE* = (G_PRIORITY_HIGH_IDLE + 10)
type 
  TKeySnoopFunc* = proc (grab_widget: PWidget; event: PEventKey; 
                           func_data: gpointer): gint {.cdecl.}
proc get_major_version*(): guint {.cdecl, 
    importc: "gtk_get_major_version", dynlib: lib.}
proc get_minor_version*(): guint {.cdecl, 
    importc: "gtk_get_minor_version", dynlib: lib.}
proc get_micro_version*(): guint {.cdecl, 
    importc: "gtk_get_micro_version", dynlib: lib.}
proc get_binary_age*(): guint {.cdecl, importc: "gtk_get_binary_age", 
                                    dynlib: lib.}
proc get_interface_age*(): guint {.cdecl, 
    importc: "gtk_get_interface_age", dynlib: lib.}
template gtk_major_version*(): expr = 
  gtk_get_major_version()

template gtk_minor_version*(): expr = 
  gtk_get_minor_version()

template gtk_micro_version*(): expr = 
  gtk_get_micro_version()

template gtk_binary_age*(): expr = 
  gtk_get_binary_age()

template gtk_interface_age*(): expr = 
  gtk_get_interface_age()

proc check_version*(required_major: guint; required_minor: guint; 
                        required_micro: guint): CSTRING {.cdecl, 
    importc: "gtk_check_version", dynlib: lib.}
proc parse_args*(argc: pointer; argv: pointer): gboolean {.
    cdecl, importc: "gtk_parse_args", dynlib: lib.}
proc init*(argc: pointer; argv: pointer) {.cdecl, 
    importc: "gtk_init", dynlib: lib.}
proc init_check*(argc: pointer; argv: pointer): gboolean {.
    cdecl, importc: "gtk_init_check", dynlib: lib.}
proc init_with_args*(argc: var gint; argv: var PPgchar; 
                         parameter_string: CSTRING; 
                         entries: PGOptionEntry; 
                         translation_domain: CSTRING; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_init_with_args", dynlib: lib.}
proc get_option_group*(open_default_display: gboolean): PGOptionGroup {.
    cdecl, importc: "gtk_get_option_group", dynlib: lib.}
when defined(G_OS_WIN32): 
  proc init_abi_check*(argc: var cint; argv: PcstringArray; 
                           num_checks: cint; sizeofWindow: size_t; 
                           sizeofBox: size_t) {.cdecl, 
      importc: "gtk_init_abi_check", dynlib: lib.}
  proc init_check_abi_check*(argc: var cint; argv: PcstringArray; 
                                 num_checks: cint; sizeofWindow: size_t; 
                                 sizeofBox: size_t): gboolean {.cdecl, 
      importc: "gtk_init_check_abi_check", dynlib: lib.}
  template gtk_init*(argc, argv: expr): expr = 
    gtk_init_abi_check(argc, argv, 2, sizeof((TWindow)), sizeof((TBox)))

  template gtk_init_check*(argc, argv: expr): expr = 
    gtk_init_check_abi_check(argc, argv, 2, sizeof((TWindow)), 
                             sizeof((TBox)))

proc disable_setlocale*() {.cdecl, importc: "gtk_disable_setlocale", 
                                dynlib: lib.}
proc get_default_language*(): PLanguage {.cdecl, 
    importc: "gtk_get_default_language", dynlib: lib.}
proc get_locale_direction*(): TTextDirection {.cdecl, 
    importc: "gtk_get_locale_direction", dynlib: lib.}
proc events_pending*(): gboolean {.cdecl, importc: "gtk_events_pending", 
    dynlib: lib.}
proc main_do_event*(event: PEvent) {.cdecl, 
    importc: "gtk_main_do_event", dynlib: lib.}
proc main*() {.cdecl, importc: "gtk_main", dynlib: lib.}
proc main_level*(): guint {.cdecl, importc: "gtk_main_level", dynlib: lib.}
proc main_quit*() {.cdecl, importc: "gtk_main_quit", dynlib: lib.}
proc main_iteration*(): gboolean {.cdecl, importc: "gtk_main_iteration", 
    dynlib: lib.}
proc main_iteration_do*(blocking: gboolean): gboolean {.cdecl, 
    importc: "gtk_main_iteration_do", dynlib: lib.}
proc true*(): gboolean {.cdecl, importc: "gtk_true", dynlib: lib.}
proc false*(): gboolean {.cdecl, importc: "gtk_false", dynlib: lib.}
proc grab_add*(widget: PWidget) {.cdecl, importc: "gtk_grab_add", 
    dynlib: lib.}
proc grab_get_current*(): PWidget {.cdecl, 
    importc: "gtk_grab_get_current", dynlib: lib.}
proc grab_remove*(widget: PWidget) {.cdecl, 
    importc: "gtk_grab_remove", dynlib: lib.}
proc device_grab_add*(widget: PWidget; device: PDevice; 
                          block_others: gboolean) {.cdecl, 
    importc: "gtk_device_grab_add", dynlib: lib.}
proc device_grab_remove*(widget: PWidget; device: PDevice) {.
    cdecl, importc: "gtk_device_grab_remove", dynlib: lib.}
proc key_snooper_install*(snooper: TKeySnoopFunc; func_data: gpointer): guint {.
    cdecl, importc: "gtk_key_snooper_install", dynlib: lib.}
proc key_snooper_remove*(snooper_handler_id: guint) {.cdecl, 
    importc: "gtk_key_snooper_remove", dynlib: lib.}
proc get_current_event*(): PEvent {.cdecl, 
    importc: "gtk_get_current_event", dynlib: lib.}
proc get_current_event_time*(): guint32 {.cdecl, 
    importc: "gtk_get_current_event_time", dynlib: lib.}
proc get_current_event_state*(state: PModifierType): gboolean {.
    cdecl, importc: "gtk_get_current_event_state", dynlib: lib.}
proc get_current_event_device*(): PDevice {.cdecl, 
    importc: "gtk_get_current_event_device", dynlib: lib.}
proc get_event_widget*(event: PEvent): PWidget {.cdecl, 
    importc: "gtk_get_event_widget", dynlib: lib.}
proc propagate_event*(widget: PWidget; event: PEvent) {.cdecl, 
    importc: "gtk_propagate_event", dynlib: lib.}

template TYPE_MENU_BAR*(): expr = 
  (gtk_menu_bar_get_type())

template MENU_BAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MENU_BAR, TMenuBar))

template MENU_BAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MENU_BAR, TMenuBarClass))

template IS_MENU_BAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MENU_BAR))

template IS_MENU_BAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MENU_BAR))

template MENU_BAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MENU_BAR, TMenuBarClass))

type 
  PMenuBar* = ptr TMenuBar
  TMenuBar* = object of TMenuShell
    priv90: PMenuBarPrivate

type 
  PMenuBarClass* = ptr TMenuBarClass
  TMenuBarClass* = object of TMenuShellClass
    ugtk_reserved861: proc () {.cdecl.}
    ugtk_reserved862: proc () {.cdecl.}
    ugtk_reserved863: proc () {.cdecl.}
    ugtk_reserved864: proc () {.cdecl.}

proc menu_bar_get_type*(): GType {.cdecl, 
    importc: "gtk_menu_bar_get_type", dynlib: lib.}
proc menu_bar_new*(): PWidget {.cdecl, importc: "gtk_menu_bar_new", 
    dynlib: lib.}
proc menu_bar_new_from_model*(model: PGMenuModel): PWidget {.
    cdecl, importc: "gtk_menu_bar_new_from_model", dynlib: lib.}
proc get_pack_direction*(menubar: PMenuBar): TPackDirection {.
    cdecl, importc: "gtk_menu_bar_get_pack_direction", dynlib: lib.}
proc set_pack_direction*(menubar: PMenuBar; 
                                      pack_dir: TPackDirection) {.cdecl, 
    importc: "gtk_menu_bar_set_pack_direction", dynlib: lib.}
proc get_child_pack_direction*(menubar: PMenuBar): TPackDirection {.
    cdecl, importc: "gtk_menu_bar_get_child_pack_direction", dynlib: lib.}
proc set_child_pack_direction*(menubar: PMenuBar; 
    child_pack_dir: TPackDirection) {.cdecl, 
    importc: "gtk_menu_bar_set_child_pack_direction", dynlib: lib.}
proc underscore_gtk_menu_bar_cycle_focus*(menubar: PMenuBar; dir: TDirectionType) {.
    cdecl, importc: "_gtk_menu_bar_cycle_focus", dynlib: lib.}
proc underscore_gtk_menu_bar_get_viewable_menu_bars*(window: PWindow): PGList {.
    cdecl, importc: "_gtk_menu_bar_get_viewable_menu_bars", dynlib: lib.}

template TYPE_POPOVER*(): expr = 
  (gtk_popover_get_type())

template POPOVER_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_POPOVER, TPopover))

template POPOVER_CLASS_TEMPLATE*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((c), TYPE_POPOVER, TPopoverClass))

template IS_POPOVER*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_POPOVER))

template IS_POPOVER_CLASS*(o: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((o), TYPE_POPOVER))

template POPOVER_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_POPOVER, TPopoverClass))

type 
  PPopover* = ptr TPopover
  TPopover* = object of TBin
    priv91: PPopoverPrivate

type 
  PPopoverClass* = ptr TPopoverClass
  TPopoverClass* = object of TBinClass
    closed*: proc (popover: PPopover) {.cdecl.}
    reserved: array[10, gpointer]

proc popover_get_type*(): GType {.cdecl, importc: "gtk_popover_get_type", 
                                      dynlib: lib.}
proc popover_new*(relative_to: PWidget): PWidget {.cdecl, 
    importc: "gtk_popover_new", dynlib: lib.}
proc popover_new_from_model*(relative_to: PWidget; 
                                 model: PGMenuModel): PWidget {.
    cdecl, importc: "gtk_popover_new_from_model", dynlib: lib.}
proc set_relative_to*(popover: PPopover; 
                                  relative_to: PWidget) {.cdecl, 
    importc: "gtk_popover_set_relative_to", dynlib: lib.}
proc get_relative_to*(popover: PPopover): PWidget {.
    cdecl, importc: "gtk_popover_get_relative_to", dynlib: lib.}
proc set_pointing_to*(popover: PPopover; 
                                  rect: gdk3.PRectangle) {.cdecl, 
    importc: "gtk_popover_set_pointing_to", dynlib: lib.}
proc get_pointing_to*(popover: PPopover; 
                                  rect: gdk3.PRectangle): gboolean {.cdecl, 
    importc: "gtk_popover_get_pointing_to", dynlib: lib.}
proc set_position*(popover: PPopover; 
                               position: TPositionType) {.cdecl, 
    importc: "gtk_popover_set_position", dynlib: lib.}
proc get_position*(popover: PPopover): TPositionType {.
    cdecl, importc: "gtk_popover_get_position", dynlib: lib.}
proc set_modal*(popover: PPopover; modal: gboolean) {.cdecl, 
    importc: "gtk_popover_set_modal", dynlib: lib.}
proc get_modal*(popover: PPopover): gboolean {.cdecl, 
    importc: "gtk_popover_get_modal", dynlib: lib.}
proc bind_model*(popover: PPopover; model: PGMenuModel; 
                             action_namespace: CSTRING) {.cdecl, 
    importc: "gtk_popover_bind_model", dynlib: lib.}

template TYPE_MENU_BUTTON*(): expr = 
  (gtk_menu_button_get_type())

template MENU_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MENU_BUTTON, TMenuButton))

template MENU_BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MENU_BUTTON, TMenuButtonClass))

template IS_MENU_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MENU_BUTTON))

template IS_MENU_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MENU_BUTTON))

template MENU_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MENU_BUTTON, TMenuButtonClass))

type 
  PMenuButton* = ptr TMenuButton
  TMenuButton* = object of TToggleButton
    priv92: PMenuButtonPrivate

type 
  PMenuButtonClass* = ptr TMenuButtonClass
  TMenuButtonClass* = object of TToggleButtonClass
    ugtk_reserved871: proc () {.cdecl.}
    ugtk_reserved872: proc () {.cdecl.}
    ugtk_reserved873: proc () {.cdecl.}
    ugtk_reserved874: proc () {.cdecl.}

proc menu_button_get_type*(): GType {.cdecl, 
    importc: "gtk_menu_button_get_type", dynlib: lib.}
proc menu_button_new*(): PWidget {.cdecl, 
    importc: "gtk_menu_button_new", dynlib: lib.}
proc set_popup*(menu_button: PMenuButton; 
                                menu: PWidget) {.cdecl, 
    importc: "gtk_menu_button_set_popup", dynlib: lib.}
proc get_popup*(menu_button: PMenuButton): PMenu {.
    cdecl, importc: "gtk_menu_button_get_popup", dynlib: lib.}
proc set_popover*(menu_button: PMenuButton; 
                                  popover: PWidget) {.cdecl, 
    importc: "gtk_menu_button_set_popover", dynlib: lib.}
proc get_popover*(menu_button: PMenuButton): PPopover {.
    cdecl, importc: "gtk_menu_button_get_popover", dynlib: lib.}
proc set_direction*(menu_button: PMenuButton; 
                                    direction: TArrowType) {.cdecl, 
    importc: "gtk_menu_button_set_direction", dynlib: lib.}
proc get_direction*(menu_button: PMenuButton): TArrowType {.
    cdecl, importc: "gtk_menu_button_get_direction", dynlib: lib.}
proc set_menu_model*(menu_button: PMenuButton; 
                                     menu_model: PGMenuModel) {.cdecl, 
    importc: "gtk_menu_button_set_menu_model", dynlib: lib.}
proc get_menu_model*(menu_button: PMenuButton): PGMenuModel {.
    cdecl, importc: "gtk_menu_button_get_menu_model", dynlib: lib.}
proc set_align_widget*(menu_button: PMenuButton; 
    align_widget: PWidget) {.cdecl, importc: "gtk_menu_button_set_align_widget", 
                                   dynlib: lib.}
proc get_align_widget*(menu_button: PMenuButton): PWidget {.
    cdecl, importc: "gtk_menu_button_get_align_widget", dynlib: lib.}
proc set_use_popover*(menu_button: PMenuButton; 
                                      use_popover: gboolean) {.cdecl, 
    importc: "gtk_menu_button_set_use_popover", dynlib: lib.}
proc get_use_popover*(menu_button: PMenuButton): gboolean {.
    cdecl, importc: "gtk_menu_button_get_use_popover", dynlib: lib.}

template TYPE_SIZE_GROUP*(): expr = 
  (gtk_size_group_get_type())

template SIZE_GROUP_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SIZE_GROUP, TSizeGroup))

template SIZE_GROUP_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SIZE_GROUP, TSizeGroupClass))

template IS_SIZE_GROUP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SIZE_GROUP))

template IS_SIZE_GROUP_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SIZE_GROUP))

template SIZE_GROUP_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SIZE_GROUP, TSizeGroupClass))

type 
  PSizeGroup* = ptr TSizeGroup
  TSizeGroup* = object of TGObject
    priv93: PSizeGroupPrivate

type 
  PSizeGroupClass* = ptr TSizeGroupClass
  TSizeGroupClass* = object of TGObjectClass
    ugtk_reserved881: proc () {.cdecl.}
    ugtk_reserved882: proc () {.cdecl.}
    ugtk_reserved883: proc () {.cdecl.}
    ugtk_reserved884: proc () {.cdecl.}

proc size_group_get_type*(): GType {.cdecl, 
    importc: "gtk_size_group_get_type", dynlib: lib.}
proc size_group_new*(mode: TSizeGroupMode): PSizeGroup {.cdecl, 
    importc: "gtk_size_group_new", dynlib: lib.}
proc set_mode*(size_group: PSizeGroup; 
                              mode: TSizeGroupMode) {.cdecl, 
    importc: "gtk_size_group_set_mode", dynlib: lib.}
proc get_mode*(size_group: PSizeGroup): TSizeGroupMode {.
    cdecl, importc: "gtk_size_group_get_mode", dynlib: lib.}
proc set_ignore_hidden*(size_group: PSizeGroup; 
    ignore_hidden: gboolean) {.cdecl, 
                               importc: "gtk_size_group_set_ignore_hidden", 
                               dynlib: lib.}
proc get_ignore_hidden*(size_group: PSizeGroup): gboolean {.
    cdecl, importc: "gtk_size_group_get_ignore_hidden", dynlib: lib.}
proc add_widget*(size_group: PSizeGroup; 
                                widget: PWidget) {.cdecl, 
    importc: "gtk_size_group_add_widget", dynlib: lib.}
proc remove_widget*(size_group: PSizeGroup; 
                                   widget: PWidget) {.cdecl, 
    importc: "gtk_size_group_remove_widget", dynlib: lib.}
proc get_widgets*(size_group: PSizeGroup): PGSList {.
    cdecl, importc: "gtk_size_group_get_widgets", dynlib: lib.}

template TYPE_TOOL_ITEM*(): expr = 
  (gtk_tool_item_get_type())

template TOOL_ITEM_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_TOOL_ITEM, TToolItem))

template TOOL_ITEM_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TOOL_ITEM, TToolItemClass))

template IS_TOOL_ITEM*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_TOOL_ITEM))

template IS_TOOL_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TOOL_ITEM))

template TOOL_ITEM_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_TOOL_ITEM, TToolItemClass))

type 
  PToolItem* = ptr TToolItem
  TToolItem* = object of TBin
    priv94: PToolItemPrivate

type 
  PToolItemClass* = ptr TToolItemClass
  TToolItemClass* = object of TBinClass
    create_menu_proxy*: proc (tool_item: PToolItem): gboolean {.cdecl.}
    toolbar_reconfigured*: proc (tool_item: PToolItem) {.cdecl.}
    ugtk_reserved891: proc () {.cdecl.}
    ugtk_reserved892: proc () {.cdecl.}
    ugtk_reserved893: proc () {.cdecl.}
    ugtk_reserved894: proc () {.cdecl.}

proc tool_item_get_type*(): GType {.cdecl, 
    importc: "gtk_tool_item_get_type", dynlib: lib.}
proc tool_item_new*(): PToolItem {.cdecl, 
    importc: "gtk_tool_item_new", dynlib: lib.}
proc set_homogeneous*(tool_item: PToolItem; 
                                    homogeneous: gboolean) {.cdecl, 
    importc: "gtk_tool_item_set_homogeneous", dynlib: lib.}
proc get_homogeneous*(tool_item: PToolItem): gboolean {.
    cdecl, importc: "gtk_tool_item_get_homogeneous", dynlib: lib.}
proc set_expand*(tool_item: PToolItem; expand: gboolean) {.
    cdecl, importc: "gtk_tool_item_set_expand", dynlib: lib.}
proc get_expand*(tool_item: PToolItem): gboolean {.cdecl, 
    importc: "gtk_tool_item_get_expand", dynlib: lib.}
proc set_tooltip_text*(tool_item: PToolItem; 
                                     text: CSTRING) {.cdecl, 
    importc: "gtk_tool_item_set_tooltip_text", dynlib: lib.}
proc set_tooltip_markup*(tool_item: PToolItem; 
    markup: CSTRING) {.cdecl, importc: "gtk_tool_item_set_tooltip_markup", 
                         dynlib: lib.}
proc set_use_drag_window*(tool_item: PToolItem; 
    use_drag_window: gboolean) {.cdecl, importc: "gtk_tool_item_set_use_drag_window", 
                                 dynlib: lib.}
proc get_use_drag_window*(tool_item: PToolItem): gboolean {.
    cdecl, importc: "gtk_tool_item_get_use_drag_window", dynlib: lib.}
proc set_visible_horizontal*(tool_item: PToolItem; 
    visible_horizontal: gboolean) {.cdecl, importc: "gtk_tool_item_set_visible_horizontal", 
                                    dynlib: lib.}
proc get_visible_horizontal*(tool_item: PToolItem): gboolean {.
    cdecl, importc: "gtk_tool_item_get_visible_horizontal", dynlib: lib.}
proc set_visible_vertical*(tool_item: PToolItem; 
    visible_vertical: gboolean) {.cdecl, importc: "gtk_tool_item_set_visible_vertical", 
                                  dynlib: lib.}
proc get_visible_vertical*(tool_item: PToolItem): gboolean {.
    cdecl, importc: "gtk_tool_item_get_visible_vertical", dynlib: lib.}
proc get_is_important*(tool_item: PToolItem): gboolean {.
    cdecl, importc: "gtk_tool_item_get_is_important", dynlib: lib.}
proc set_is_important*(tool_item: PToolItem; 
                                     is_important: gboolean) {.cdecl, 
    importc: "gtk_tool_item_set_is_important", dynlib: lib.}
proc get_ellipsize_mode*(tool_item: PToolItem): TEllipsizeMode {.
    cdecl, importc: "gtk_tool_item_get_ellipsize_mode", dynlib: lib.}
proc get_icon_size*(tool_item: PToolItem): TIconSize {.
    cdecl, importc: "gtk_tool_item_get_icon_size", dynlib: lib.}
proc get_orientation*(tool_item: PToolItem): TOrientation {.
    cdecl, importc: "gtk_tool_item_get_orientation", dynlib: lib.}
proc get_toolbar_style*(tool_item: PToolItem): TToolbarStyle {.
    cdecl, importc: "gtk_tool_item_get_toolbar_style", dynlib: lib.}
proc get_relief_style*(tool_item: PToolItem): TReliefStyle {.
    cdecl, importc: "gtk_tool_item_get_relief_style", dynlib: lib.}
proc get_text_alignment*(tool_item: PToolItem): gfloat {.
    cdecl, importc: "gtk_tool_item_get_text_alignment", dynlib: lib.}
proc get_text_orientation*(tool_item: PToolItem): TOrientation {.
    cdecl, importc: "gtk_tool_item_get_text_orientation", dynlib: lib.}
proc get_text_size_group*(tool_item: PToolItem): PSizeGroup {.
    cdecl, importc: "gtk_tool_item_get_text_size_group", dynlib: lib.}
proc retrieve_proxy_menu_item*(tool_item: PToolItem): PWidget {.
    cdecl, importc: "gtk_tool_item_retrieve_proxy_menu_item", dynlib: lib.}
proc get_proxy_menu_item*(tool_item: PToolItem; 
    menu_item_id: CSTRING): PWidget {.cdecl, 
    importc: "gtk_tool_item_get_proxy_menu_item", dynlib: lib.}
proc set_proxy_menu_item*(tool_item: PToolItem; 
    menu_item_id: CSTRING; menu_item: PWidget) {.cdecl, 
    importc: "gtk_tool_item_set_proxy_menu_item", dynlib: lib.}
proc rebuild_menu*(tool_item: PToolItem) {.cdecl, 
    importc: "gtk_tool_item_rebuild_menu", dynlib: lib.}
proc toolbar_reconfigured*(tool_item: PToolItem) {.cdecl, 
    importc: "gtk_tool_item_toolbar_reconfigured", dynlib: lib.}
proc underscore_gtk_tool_item_create_menu_proxy*(tool_item: PToolItem): gboolean {.
    cdecl, importc: "_gtk_tool_item_create_menu_proxy", dynlib: lib.}

template TYPE_TOOL_BUTTON*(): expr = 
  (gtk_tool_button_get_type())

template TOOL_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TOOL_BUTTON, TToolButton))

template TOOL_BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TOOL_BUTTON, TToolButtonClass))

template IS_TOOL_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TOOL_BUTTON))

template IS_TOOL_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TOOL_BUTTON))

template TOOL_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TOOL_BUTTON, TToolButtonClass))

type 
  PToolButton* = ptr TToolButton
  TToolButton* = object of TToolItem
    priv95: PToolButtonPrivate

type 
  PToolButtonClass* = ptr TToolButtonClass
  TToolButtonClass* = object of TToolItemClass
    button_type*: GType
    clicked*: proc (tool_item: PToolButton) {.cdecl.}
    ugtk_reserved901: proc () {.cdecl.}
    ugtk_reserved902: proc () {.cdecl.}
    ugtk_reserved903: proc () {.cdecl.}
    ugtk_reserved904: proc () {.cdecl.}

proc tool_button_get_type*(): GType {.cdecl, 
    importc: "gtk_tool_button_get_type", dynlib: lib.}
proc tool_button_new*(icon_widget: PWidget; label: CSTRING): PToolItem {.
    cdecl, importc: "gtk_tool_button_new", dynlib: lib.}
proc tool_button_new_from_stock*(stock_id: CSTRING): PToolItem {.
    cdecl, importc: "gtk_tool_button_new_from_stock", dynlib: lib.}
proc set_label*(button: PToolButton; label: CSTRING) {.
    cdecl, importc: "gtk_tool_button_set_label", dynlib: lib.}
proc get_label*(button: PToolButton): CSTRING {.cdecl, 
    importc: "gtk_tool_button_get_label", dynlib: lib.}
proc set_use_underline*(button: PToolButton; 
    use_underline: gboolean) {.cdecl, 
                               importc: "gtk_tool_button_set_use_underline", 
                               dynlib: lib.}
proc get_use_underline*(button: PToolButton): gboolean {.
    cdecl, importc: "gtk_tool_button_get_use_underline", dynlib: lib.}
proc set_stock_id*(button: PToolButton; 
                                   stock_id: CSTRING) {.cdecl, 
    importc: "gtk_tool_button_set_stock_id", dynlib: lib.}
proc get_stock_id*(button: PToolButton): CSTRING {.
    cdecl, importc: "gtk_tool_button_get_stock_id", dynlib: lib.}
proc set_icon_name*(button: PToolButton; 
                                    icon_name: CSTRING) {.cdecl, 
    importc: "gtk_tool_button_set_icon_name", dynlib: lib.}
proc get_icon_name*(button: PToolButton): CSTRING {.
    cdecl, importc: "gtk_tool_button_get_icon_name", dynlib: lib.}
proc set_icon_widget*(button: PToolButton; 
                                      icon_widget: PWidget) {.cdecl, 
    importc: "gtk_tool_button_set_icon_widget", dynlib: lib.}
proc get_icon_widget*(button: PToolButton): PWidget {.
    cdecl, importc: "gtk_tool_button_get_icon_widget", dynlib: lib.}
proc set_label_widget*(button: PToolButton; 
    label_widget: PWidget) {.cdecl, importc: "gtk_tool_button_set_label_widget", 
                                   dynlib: lib.}
proc get_label_widget*(button: PToolButton): PWidget {.
    cdecl, importc: "gtk_tool_button_get_label_widget", dynlib: lib.}
proc underscore_gtk_tool_button_get_button*(button: PToolButton): PWidget {.
    cdecl, importc: "_gtk_tool_button_get_button", dynlib: lib.}

template TYPE_MENU_TOOL_BUTTON*(): expr = 
  (gtk_menu_tool_button_get_type())

template MENU_TOOL_BUTTON*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_MENU_TOOL_BUTTON, 
                              TMenuToolButton))

template MENU_TOOL_BUTTON_CLASS*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((k), TYPE_MENU_TOOL_BUTTON, 
                           TMenuToolButtonClass))

template IS_MENU_TOOL_BUTTON*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_MENU_TOOL_BUTTON))

template IS_MENU_TOOL_BUTTON_CLASS*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((k), TYPE_MENU_TOOL_BUTTON))

template MENU_TOOL_BUTTON_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_MENU_TOOL_BUTTON, 
                             TMenuToolButtonClass))

type 
  PMenuToolButton* = ptr TMenuToolButton
  TMenuToolButton* = object of TToolButton
    priv96: PMenuToolButtonPrivate

type 
  PMenuToolButtonClass* = ptr TMenuToolButtonClass
  TMenuToolButtonClass* = object of TToolButtonClass
    show_menu*: proc (button: PMenuToolButton) {.cdecl.}
    ugtk_reserved911: proc () {.cdecl.}
    ugtk_reserved912: proc () {.cdecl.}
    ugtk_reserved913: proc () {.cdecl.}
    ugtk_reserved914: proc () {.cdecl.}

proc menu_tool_button_get_type*(): GType {.cdecl, 
    importc: "gtk_menu_tool_button_get_type", dynlib: lib.}
proc menu_tool_button_new*(icon_widget: PWidget; label: CSTRING): PToolItem {.
    cdecl, importc: "gtk_menu_tool_button_new", dynlib: lib.}
proc menu_tool_button_new_from_stock*(stock_id: CSTRING): PToolItem {.
    cdecl, importc: "gtk_menu_tool_button_new_from_stock", dynlib: lib.}
proc set_menu*(button: PMenuToolButton; 
                                    menu: PWidget) {.cdecl, 
    importc: "gtk_menu_tool_button_set_menu", dynlib: lib.}
proc get_menu*(button: PMenuToolButton): PWidget {.
    cdecl, importc: "gtk_menu_tool_button_get_menu", dynlib: lib.}
proc set_arrow_tooltip_text*(
    button: PMenuToolButton; text: CSTRING) {.cdecl, 
    importc: "gtk_menu_tool_button_set_arrow_tooltip_text", dynlib: lib.}
proc set_arrow_tooltip_markup*(
    button: PMenuToolButton; markup: CSTRING) {.cdecl, 
    importc: "gtk_menu_tool_button_set_arrow_tooltip_markup", dynlib: lib.}

template TYPE_MESSAGE_DIALOG*(): expr = 
  (gtk_message_dialog_get_type())

template MESSAGE_DIALOG_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MESSAGE_DIALOG, TMessageDialog))

template MESSAGE_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MESSAGE_DIALOG, 
                           TMessageDialogClass))

template IS_MESSAGE_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MESSAGE_DIALOG))

template IS_MESSAGE_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MESSAGE_DIALOG))

template MESSAGE_DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MESSAGE_DIALOG, 
                             TMessageDialogClass))

type 
  PMessageDialog* = ptr TMessageDialog
  TMessageDialog* = object of TDialog
    priv97: PMessageDialogPrivate

type 
  PMessageDialogClass* = ptr TMessageDialogClass
  TMessageDialogClass* = object of TDialogClass
    ugtk_reserved921: proc () {.cdecl.}
    ugtk_reserved922: proc () {.cdecl.}
    ugtk_reserved923: proc () {.cdecl.}
    ugtk_reserved924: proc () {.cdecl.}

type 
  TButtonsType* {.size: sizeof(cint).} = enum 
    BUTTONS_NONE, BUTTONS_OK, BUTTONS_CLOSE, BUTTONS_CANCEL, 
    BUTTONS_YES_NO, BUTTONS_OK_CANCEL
proc message_dialog_get_type*(): GType {.cdecl, 
    importc: "gtk_message_dialog_get_type", dynlib: lib.}
proc message_dialog_new*(parent: PWindow; flags: TDialogFlags; 
                             typ: TMessageType; buttons: TButtonsType; 
                             message_format: CSTRING): PWidget {.
    varargs, cdecl, importc: "gtk_message_dialog_new", dynlib: lib.}
proc message_dialog_new_with_markup*(parent: PWindow; 
    flags: TDialogFlags; typ: TMessageType; buttons: TButtonsType; 
    message_format: CSTRING): PWidget {.varargs, cdecl, 
    importc: "gtk_message_dialog_new_with_markup", dynlib: lib.}
proc set_image*(dialog: PMessageDialog; 
                                   image: PWidget) {.cdecl, 
    importc: "gtk_message_dialog_set_image", dynlib: lib.}
proc get_image*(dialog: PMessageDialog): PWidget {.
    cdecl, importc: "gtk_message_dialog_get_image", dynlib: lib.}
proc set_markup*(message_dialog: PMessageDialog; 
                                    str: CSTRING) {.cdecl, 
    importc: "gtk_message_dialog_set_markup", dynlib: lib.}
proc format_secondary_text*(
    message_dialog: PMessageDialog; message_format: CSTRING) {.
    varargs, cdecl, importc: "gtk_message_dialog_format_secondary_text", 
    dynlib: lib.}
proc format_secondary_markup*(
    message_dialog: PMessageDialog; message_format: CSTRING) {.
    varargs, cdecl, importc: "gtk_message_dialog_format_secondary_markup", 
    dynlib: lib.}
proc get_message_area*(message_dialog: PMessageDialog): PWidget {.
    cdecl, importc: "gtk_message_dialog_get_message_area", dynlib: lib.}

type 
  TModuleInitFunc* = proc (argc: var gint; argv: var PPgchar) {.cdecl.}
type 
  TModuleDisplayInitFunc* = proc (display: PGdkDisplay) {.cdecl.}

template TYPE_MOUNT_OPERATION*(): expr = 
  (gtk_mount_operation_get_type())

template MOUNT_OPERATION_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_MOUNT_OPERATION, TMountOperation))

template MOUNT_OPERATION_CLASS*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((k), TYPE_MOUNT_OPERATION, 
                           TMountOperationClass))

template IS_MOUNT_OPERATION*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_MOUNT_OPERATION))

template IS_MOUNT_OPERATION_CLASS*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((k), TYPE_MOUNT_OPERATION))

template MOUNT_OPERATION_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_MOUNT_OPERATION, 
                             TMountOperationClass))

type 
  PMountOperation* = ptr TMountOperation
  TMountOperation* = object of TGMountOperation
    priv98: PMountOperationPrivate

type 
  PMountOperationClass* = ptr TMountOperationClass
  TMountOperationClass* = object of TGMountOperationClass
    ugtk_reserved931: proc () {.cdecl.}
    ugtk_reserved932: proc () {.cdecl.}
    ugtk_reserved933: proc () {.cdecl.}
    ugtk_reserved934: proc () {.cdecl.}

proc mount_operation_get_type*(): GType {.cdecl, 
    importc: "gtk_mount_operation_get_type", dynlib: lib.}
proc mount_operation_new*(parent: PWindow): PGMountOperation {.
    cdecl, importc: "gtk_mount_operation_new", dynlib: lib.}
proc is_showing*(op: PMountOperation): gboolean {.
    cdecl, importc: "gtk_mount_operation_is_showing", dynlib: lib.}
proc set_parent*(op: PMountOperation; 
                                     parent: PWindow) {.cdecl, 
    importc: "gtk_mount_operation_set_parent", dynlib: lib.}
proc get_parent*(op: PMountOperation): PWindow {.
    cdecl, importc: "gtk_mount_operation_get_parent", dynlib: lib.}
proc set_screen*(op: PMountOperation; 
                                     screen: PGdkScreen) {.cdecl, 
    importc: "gtk_mount_operation_set_screen", dynlib: lib.}
proc get_screen*(op: PMountOperation): PGdkScreen {.
    cdecl, importc: "gtk_mount_operation_get_screen", dynlib: lib.}

template TYPE_NOTEBOOK*(): expr = 
  (gtk_notebook_get_type())

template NOTEBOOK_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_NOTEBOOK, TNotebook))

template NOTEBOOK_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_NOTEBOOK, TNotebookClass))

template IS_NOTEBOOK*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_NOTEBOOK))

template IS_NOTEBOOK_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_NOTEBOOK))

template NOTEBOOK_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_NOTEBOOK, TNotebookClass))

type 
  TNotebookTab* {.size: sizeof(cint).} = enum 
    NOTEBOOK_TAB_FIRST, NOTEBOOK_TAB_LAST
type 
  PNotebook* = ptr TNotebook
  TNotebook* = object of TContainer
    priv99: PNotebookPrivate

type 
  PNotebookClass* = ptr TNotebookClass
  TNotebookClass* = object of TContainerClass
    switch_page*: proc (notebook: PNotebook; page: PWidget; 
                        page_num: guint) {.cdecl.}
    select_page*: proc (notebook: PNotebook; move_focus: gboolean): gboolean {.
        cdecl.}
    focus_tab*: proc (notebook: PNotebook; typ: TNotebookTab): gboolean {.
        cdecl.}
    change_current_page*: proc (notebook: PNotebook; offset: gint): gboolean {.
        cdecl.}
    move_focus_out*: proc (notebook: PNotebook; 
                           direction: TDirectionType) {.cdecl.}
    reorder_tab*: proc (notebook: PNotebook; 
                        direction: TDirectionType; move_to_last: gboolean): gboolean {.
        cdecl.}
    insert_page*: proc (notebook: PNotebook; child: PWidget; 
                        tab_label: PWidget; menu_label: PWidget; 
                        position: gint): gint {.cdecl.}
    create_window*: proc (notebook: PNotebook; page: PWidget; 
                          x: gint; y: gint): PNotebook {.cdecl.}
    page_reordered*: proc (notebook: PNotebook; child: PWidget; 
                           page_num: guint) {.cdecl.}
    page_removed*: proc (notebook: PNotebook; child: PWidget; 
                         page_num: guint) {.cdecl.}
    page_added*: proc (notebook: PNotebook; child: PWidget; 
                       page_num: guint) {.cdecl.}
    ugtk_reserved941: proc () {.cdecl.}
    ugtk_reserved942: proc () {.cdecl.}
    ugtk_reserved943: proc () {.cdecl.}
    ugtk_reserved944: proc () {.cdecl.}
    ugtk_reserved945: proc () {.cdecl.}
    ugtk_reserved946: proc () {.cdecl.}
    ugtk_reserved947: proc () {.cdecl.}
    ugtk_reserved948: proc () {.cdecl.}

proc notebook_get_type*(): GType {.cdecl, 
    importc: "gtk_notebook_get_type", dynlib: lib.}
proc notebook_new*(): PWidget {.cdecl, importc: "gtk_notebook_new", 
    dynlib: lib.}
proc append_page*(notebook: PNotebook; 
                               child: PWidget; tab_label: PWidget): gint {.
    cdecl, importc: "gtk_notebook_append_page", dynlib: lib.}
proc append_page_menu*(notebook: PNotebook; 
                                    child: PWidget; 
                                    tab_label: PWidget; 
                                    menu_label: PWidget): gint {.cdecl, 
    importc: "gtk_notebook_append_page_menu", dynlib: lib.}
proc prepend_page*(notebook: PNotebook; 
                                child: PWidget; tab_label: PWidget): gint {.
    cdecl, importc: "gtk_notebook_prepend_page", dynlib: lib.}
proc prepend_page_menu*(notebook: PNotebook; 
                                     child: PWidget; 
                                     tab_label: PWidget; 
                                     menu_label: PWidget): gint {.cdecl, 
    importc: "gtk_notebook_prepend_page_menu", dynlib: lib.}
proc insert_page*(notebook: PNotebook; 
                               child: PWidget; tab_label: PWidget; 
                               position: gint): gint {.cdecl, 
    importc: "gtk_notebook_insert_page", dynlib: lib.}
proc insert_page_menu*(notebook: PNotebook; 
                                    child: PWidget; 
                                    tab_label: PWidget; 
                                    menu_label: PWidget; position: gint): gint {.
    cdecl, importc: "gtk_notebook_insert_page_menu", dynlib: lib.}
proc remove_page*(notebook: PNotebook; page_num: gint) {.
    cdecl, importc: "gtk_notebook_remove_page", dynlib: lib.}
proc set_group_name*(notebook: PNotebook; 
                                  group_name: CSTRING) {.cdecl, 
    importc: "gtk_notebook_set_group_name", dynlib: lib.}
proc get_group_name*(notebook: PNotebook): CSTRING {.
    cdecl, importc: "gtk_notebook_get_group_name", dynlib: lib.}
proc get_current_page*(notebook: PNotebook): gint {.cdecl, 
    importc: "gtk_notebook_get_current_page", dynlib: lib.}
proc get_nth_page*(notebook: PNotebook; page_num: gint): PWidget {.
    cdecl, importc: "gtk_notebook_get_nth_page", dynlib: lib.}
proc get_n_pages*(notebook: PNotebook): gint {.cdecl, 
    importc: "gtk_notebook_get_n_pages", dynlib: lib.}
proc page_num*(notebook: PNotebook; child: PWidget): gint {.
    cdecl, importc: "gtk_notebook_page_num", dynlib: lib.}
proc set_current_page*(notebook: PNotebook; page_num: gint) {.
    cdecl, importc: "gtk_notebook_set_current_page", dynlib: lib.}
proc next_page*(notebook: PNotebook) {.cdecl, 
    importc: "gtk_notebook_next_page", dynlib: lib.}
proc prev_page*(notebook: PNotebook) {.cdecl, 
    importc: "gtk_notebook_prev_page", dynlib: lib.}
proc set_show_border*(notebook: PNotebook; 
                                   show_border: gboolean) {.cdecl, 
    importc: "gtk_notebook_set_show_border", dynlib: lib.}
proc get_show_border*(notebook: PNotebook): gboolean {.
    cdecl, importc: "gtk_notebook_get_show_border", dynlib: lib.}
proc set_show_tabs*(notebook: PNotebook; 
                                 show_tabs: gboolean) {.cdecl, 
    importc: "gtk_notebook_set_show_tabs", dynlib: lib.}
proc get_show_tabs*(notebook: PNotebook): gboolean {.cdecl, 
    importc: "gtk_notebook_get_show_tabs", dynlib: lib.}
proc set_tab_pos*(notebook: PNotebook; pos: TPositionType) {.
    cdecl, importc: "gtk_notebook_set_tab_pos", dynlib: lib.}
proc get_tab_pos*(notebook: PNotebook): TPositionType {.
    cdecl, importc: "gtk_notebook_get_tab_pos", dynlib: lib.}
proc set_scrollable*(notebook: PNotebook; 
                                  scrollable: gboolean) {.cdecl, 
    importc: "gtk_notebook_set_scrollable", dynlib: lib.}
proc get_scrollable*(notebook: PNotebook): gboolean {.
    cdecl, importc: "gtk_notebook_get_scrollable", dynlib: lib.}
proc get_tab_hborder*(notebook: PNotebook): guint16 {.
    cdecl, importc: "gtk_notebook_get_tab_hborder", dynlib: lib.}
proc get_tab_vborder*(notebook: PNotebook): guint16 {.
    cdecl, importc: "gtk_notebook_get_tab_vborder", dynlib: lib.}
proc popup_enable*(notebook: PNotebook) {.cdecl, 
    importc: "gtk_notebook_popup_enable", dynlib: lib.}
proc popup_disable*(notebook: PNotebook) {.cdecl, 
    importc: "gtk_notebook_popup_disable", dynlib: lib.}
proc get_tab_label*(notebook: PNotebook; 
                                 child: PWidget): PWidget {.cdecl, 
    importc: "gtk_notebook_get_tab_label", dynlib: lib.}
proc set_tab_label*(notebook: PNotebook; 
                                 child: PWidget; 
                                 tab_label: PWidget) {.cdecl, 
    importc: "gtk_notebook_set_tab_label", dynlib: lib.}
proc set_tab_label_text*(notebook: PNotebook; 
                                      child: PWidget; 
                                      tab_text: CSTRING) {.cdecl, 
    importc: "gtk_notebook_set_tab_label_text", dynlib: lib.}
proc get_tab_label_text*(notebook: PNotebook; 
                                      child: PWidget): CSTRING {.
    cdecl, importc: "gtk_notebook_get_tab_label_text", dynlib: lib.}
proc get_menu_label*(notebook: PNotebook; 
                                  child: PWidget): PWidget {.
    cdecl, importc: "gtk_notebook_get_menu_label", dynlib: lib.}
proc set_menu_label*(notebook: PNotebook; 
                                  child: PWidget; 
                                  menu_label: PWidget) {.cdecl, 
    importc: "gtk_notebook_set_menu_label", dynlib: lib.}
proc set_menu_label_text*(notebook: PNotebook; 
    child: PWidget; menu_text: CSTRING) {.cdecl, 
    importc: "gtk_notebook_set_menu_label_text", dynlib: lib.}
proc get_menu_label_text*(notebook: PNotebook; 
    child: PWidget): CSTRING {.cdecl, 
    importc: "gtk_notebook_get_menu_label_text", dynlib: lib.}
proc reorder_child*(notebook: PNotebook; 
                                 child: PWidget; position: gint) {.
    cdecl, importc: "gtk_notebook_reorder_child", dynlib: lib.}
proc get_tab_reorderable*(notebook: PNotebook; 
    child: PWidget): gboolean {.cdecl, importc: "gtk_notebook_get_tab_reorderable", 
                                      dynlib: lib.}
proc set_tab_reorderable*(notebook: PNotebook; 
    child: PWidget; reorderable: gboolean) {.cdecl, 
    importc: "gtk_notebook_set_tab_reorderable", dynlib: lib.}
proc get_tab_detachable*(notebook: PNotebook; 
                                      child: PWidget): gboolean {.cdecl, 
    importc: "gtk_notebook_get_tab_detachable", dynlib: lib.}
proc set_tab_detachable*(notebook: PNotebook; 
                                      child: PWidget; 
                                      detachable: gboolean) {.cdecl, 
    importc: "gtk_notebook_set_tab_detachable", dynlib: lib.}
proc get_action_widget*(notebook: PNotebook; 
                                     pack_type: TPackType): PWidget {.
    cdecl, importc: "gtk_notebook_get_action_widget", dynlib: lib.}
proc set_action_widget*(notebook: PNotebook; 
                                     widget: PWidget; 
                                     pack_type: TPackType) {.cdecl, 
    importc: "gtk_notebook_set_action_widget", dynlib: lib.}

template TYPE_NUMERABLE_ICON*(): expr = 
  (gtk_numerable_icon_get_type())

template NUMERABLE_ICON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_NUMERABLE_ICON, TNumerableIcon))

template NUMERABLE_ICON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_NUMERABLE_ICON, 
                           TNumerableIconClass))

template IS_NUMERABLE_ICON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_NUMERABLE_ICON))

template IS_NUMERABLE_ICON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_NUMERABLE_ICON))

template NUMERABLE_ICON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_NUMERABLE_ICON, 
                             TNumerableIconClass))

type 
  PNumerableIcon* = ptr TNumerableIcon
  TNumerableIcon* = object of TGEmblemedIcon
    priv100: PNumerableIconPrivate

type 
  PNumerableIconClass* = ptr TNumerableIconClass
  TNumerableIconClass* = object of TGEmblemedIconClass
    padding*: array[16, gpointer]

proc numerable_icon_get_type*(): GType {.cdecl, 
    importc: "gtk_numerable_icon_get_type", dynlib: lib.}
proc numerable_icon_new*(base_icon: PGIcon): PGIcon {.cdecl, 
    importc: "gtk_numerable_icon_new", dynlib: lib.}
proc numerable_icon_new_with_style_context*(base_icon: PGIcon; 
    context: PStyleContext): PGIcon {.cdecl, 
    importc: "gtk_numerable_icon_new_with_style_context", dynlib: lib.}
proc get_style_context*(self: PNumerableIcon): PStyleContext {.
    cdecl, importc: "gtk_numerable_icon_get_style_context", dynlib: lib.}
proc set_style_context*(self: PNumerableIcon; 
    style: PStyleContext) {.cdecl, importc: "gtk_numerable_icon_set_style_context", 
                                  dynlib: lib.}
proc get_count*(self: PNumerableIcon): gint {.cdecl, 
    importc: "gtk_numerable_icon_get_count", dynlib: lib.}
proc set_count*(self: PNumerableIcon; count: gint) {.
    cdecl, importc: "gtk_numerable_icon_set_count", dynlib: lib.}
proc get_label*(self: PNumerableIcon): CSTRING {.
    cdecl, importc: "gtk_numerable_icon_get_label", dynlib: lib.}
proc set_label*(self: PNumerableIcon; 
                                   label: CSTRING) {.cdecl, 
    importc: "gtk_numerable_icon_set_label", dynlib: lib.}
proc set_background_gicon*(self: PNumerableIcon; 
    icon: PGIcon) {.cdecl, 
                       importc: "gtk_numerable_icon_set_background_gicon", 
                       dynlib: lib.}
proc get_background_gicon*(self: PNumerableIcon): PGIcon {.
    cdecl, importc: "gtk_numerable_icon_get_background_gicon", dynlib: lib.}
proc set_background_icon_name*(self: PNumerableIcon; 
    icon_name: CSTRING) {.cdecl, importc: "gtk_numerable_icon_set_background_icon_name", 
                            dynlib: lib.}
proc get_background_icon_name*(self: PNumerableIcon): CSTRING {.
    cdecl, importc: "gtk_numerable_icon_get_background_icon_name", dynlib: lib.}

template TYPE_OFFSCREEN_WINDOW*(): expr = 
  (gtk_offscreen_window_get_type())

template OFFSCREEN_WINDOW*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_OFFSCREEN_WINDOW, 
                              TOffscreenWindow))

template OFFSCREEN_WINDOW_CLASS*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((k), TYPE_OFFSCREEN_WINDOW, 
                           TOffscreenWindowClass))

template IS_OFFSCREEN_WINDOW*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_OFFSCREEN_WINDOW))

template IS_OFFSCREEN_WINDOW_CLASS*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((k), TYPE_OFFSCREEN_WINDOW))

template OFFSCREEN_WINDOW_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_OFFSCREEN_WINDOW, 
                             TOffscreenWindowClass))

type 
  POffscreenWindow* = ptr TOffscreenWindow
  TOffscreenWindow* = object of TWindow

type 
  POffscreenWindowClass* = ptr TOffscreenWindowClass
  TOffscreenWindowClass* = object of TWindowClass
    ugtk_reserved951: proc () {.cdecl.}
    ugtk_reserved952: proc () {.cdecl.}
    ugtk_reserved953: proc () {.cdecl.}
    ugtk_reserved954: proc () {.cdecl.}

proc offscreen_window_get_type*(): GType {.cdecl, 
    importc: "gtk_offscreen_window_get_type", dynlib: lib.}
proc offscreen_window_new*(): PWidget {.cdecl, 
    importc: "gtk_offscreen_window_new", dynlib: lib.}
proc get_surface*(offscreen: POffscreenWindow): Psurface {.
    cdecl, importc: "gtk_offscreen_window_get_surface", dynlib: lib.}
proc get_pixbuf*(offscreen: POffscreenWindow): PPixbuf {.
    cdecl, importc: "gtk_offscreen_window_get_pixbuf", dynlib: lib.}

template TYPE_ORIENTABLE*(): expr = 
  (gtk_orientable_get_type())

template ORIENTABLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ORIENTABLE, TOrientable))

template ORIENTABLE_CLASS*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((vtable), TYPE_ORIENTABLE, TOrientableIface))

template IS_ORIENTABLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ORIENTABLE))

template IS_ORIENTABLE_CLASS*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((vtable), TYPE_ORIENTABLE))

template ORIENTABLE_GET_IFACE*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((inst), TYPE_ORIENTABLE, 
                                 TOrientableIface))

type 
  POrientableIface* = ptr TOrientableIface
  TOrientableIface* = object of TGTypeInterface

proc orientable_get_type*(): GType {.cdecl, 
    importc: "gtk_orientable_get_type", dynlib: lib.}
proc set_orientation*(orientable: POrientable; 
                                     orientation: TOrientation) {.cdecl, 
    importc: "gtk_orientable_set_orientation", dynlib: lib.}
proc get_orientation*(orientable: POrientable): TOrientation {.
    cdecl, importc: "gtk_orientable_get_orientation", dynlib: lib.}

template TYPE_OVERLAY*(): expr = 
  (gtk_overlay_get_type())

template OVERLAY_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_OVERLAY, TOverlay))

template OVERLAY_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_OVERLAY, TOverlayClass))

template IS_OVERLAY*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_OVERLAY))

template IS_OVERLAY_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_OVERLAY))

template OVERLAY_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_OVERLAY, TOverlayClass))

type 
  POverlay* = ptr TOverlay
  TOverlay* = object of TBin
    priv101: POverlayPrivate

type 
  POverlayClass* = ptr TOverlayClass
  TOverlayClass* = object of TBinClass
    get_child_position*: proc (overlay: POverlay; widget: PWidget; 
                               allocation: PAllocation): gboolean {.
        cdecl.}
    ugtk_reserved961: proc () {.cdecl.}
    ugtk_reserved962: proc () {.cdecl.}
    ugtk_reserved963: proc () {.cdecl.}
    ugtk_reserved964: proc () {.cdecl.}
    ugtk_reserved965: proc () {.cdecl.}
    ugtk_reserved966: proc () {.cdecl.}
    ugtk_reserved967: proc () {.cdecl.}
    ugtk_reserved968: proc () {.cdecl.}

proc overlay_get_type*(): GType {.cdecl, importc: "gtk_overlay_get_type", 
                                      dynlib: lib.}
proc overlay_new*(): PWidget {.cdecl, importc: "gtk_overlay_new", 
    dynlib: lib.}
proc add_overlay*(overlay: POverlay; widget: PWidget) {.
    cdecl, importc: "gtk_overlay_add_overlay", dynlib: lib.}

template TYPE_PAPER_SIZE*(): expr = 
  (gtk_paper_size_get_type())

const 
  PAPER_NAME_A3* = "iso_a3"
const 
  PAPER_NAME_A4* = "iso_a4"
const 
  PAPER_NAME_A5* = "iso_a5"
const 
  PAPER_NAME_B5* = "iso_b5"
const 
  PAPER_NAME_LETTER* = "na_letter"
const 
  PAPER_NAME_EXECUTIVE* = "na_executive"
const 
  PAPER_NAME_LEGAL* = "na_legal"
proc paper_size_get_type*(): GType {.cdecl, 
    importc: "gtk_paper_size_get_type", dynlib: lib.}
proc paper_size_new*(name: CSTRING): PPaperSize {.cdecl, 
    importc: "gtk_paper_size_new", dynlib: lib.}
proc paper_size_new_from_ppd*(ppd_name: CSTRING; 
                                  ppd_display_name: CSTRING; width: gdouble; 
                                  height: gdouble): PPaperSize {.cdecl, 
    importc: "gtk_paper_size_new_from_ppd", dynlib: lib.}
proc paper_size_new_custom*(name: CSTRING; display_name: CSTRING; 
                                width: gdouble; height: gdouble; unit: TUnit): PPaperSize {.
    cdecl, importc: "gtk_paper_size_new_custom", dynlib: lib.}
proc copy*(other: PPaperSize): PPaperSize {.cdecl, 
    importc: "gtk_paper_size_copy", dynlib: lib.}
proc free*(size: PPaperSize) {.cdecl, 
    importc: "gtk_paper_size_free", dynlib: lib.}
proc is_equal*(size1: PPaperSize; size2: PPaperSize): gboolean {.
    cdecl, importc: "gtk_paper_size_is_equal", dynlib: lib.}
proc paper_size_get_paper_sizes*(include_custom: gboolean): PGList {.
    cdecl, importc: "gtk_paper_size_get_paper_sizes", dynlib: lib.}
proc get_name*(size: PPaperSize): CSTRING {.cdecl, 
    importc: "gtk_paper_size_get_name", dynlib: lib.}
proc get_display_name*(size: PPaperSize): CSTRING {.
    cdecl, importc: "gtk_paper_size_get_display_name", dynlib: lib.}
proc get_ppd_name*(size: PPaperSize): CSTRING {.cdecl, 
    importc: "gtk_paper_size_get_ppd_name", dynlib: lib.}
proc get_width*(size: PPaperSize; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_paper_size_get_width", dynlib: lib.}
proc get_height*(size: PPaperSize; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_paper_size_get_height", dynlib: lib.}
proc is_custom*(size: PPaperSize): gboolean {.cdecl, 
    importc: "gtk_paper_size_is_custom", dynlib: lib.}
proc set_size*(size: PPaperSize; width: gdouble; 
                              height: gdouble; unit: TUnit) {.cdecl, 
    importc: "gtk_paper_size_set_size", dynlib: lib.}
proc get_default_top_margin*(size: PPaperSize; 
    unit: TUnit): gdouble {.cdecl, importc: "gtk_paper_size_get_default_top_margin", 
                              dynlib: lib.}
proc get_default_bottom_margin*(size: PPaperSize; 
    unit: TUnit): gdouble {.cdecl, importc: "gtk_paper_size_get_default_bottom_margin", 
                              dynlib: lib.}
proc get_default_left_margin*(size: PPaperSize; 
    unit: TUnit): gdouble {.cdecl, importc: "gtk_paper_size_get_default_left_margin", 
                              dynlib: lib.}
proc get_default_right_margin*(size: PPaperSize; 
    unit: TUnit): gdouble {.cdecl, importc: "gtk_paper_size_get_default_right_margin", 
                              dynlib: lib.}
proc paper_size_get_default*(): CSTRING {.cdecl, 
    importc: "gtk_paper_size_get_default", dynlib: lib.}
proc paper_size_new_from_key_file*(key_file: PGKeyFile; 
    group_name: CSTRING; error: ptr PGError): PPaperSize {.cdecl, 
    importc: "gtk_paper_size_new_from_key_file", dynlib: lib.}
proc to_key_file*(size: PPaperSize; 
                                 key_file: PGKeyFile; group_name: CSTRING) {.
    cdecl, importc: "gtk_paper_size_to_key_file", dynlib: lib.}

template TYPE_PAGE_SETUP*(): expr = 
  (gtk_page_setup_get_type())

template PAGE_SETUP_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PAGE_SETUP, TPageSetup))

template IS_PAGE_SETUP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PAGE_SETUP))

proc page_setup_get_type*(): GType {.cdecl, 
    importc: "gtk_page_setup_get_type", dynlib: lib.}
proc page_setup_new*(): PPageSetup {.cdecl, 
    importc: "gtk_page_setup_new", dynlib: lib.}
proc copy*(other: PPageSetup): PPageSetup {.cdecl, 
    importc: "gtk_page_setup_copy", dynlib: lib.}
proc get_orientation*(setup: PPageSetup): TPageOrientation {.
    cdecl, importc: "gtk_page_setup_get_orientation", dynlib: lib.}
proc set_orientation*(setup: PPageSetup; 
                                     orientation: TPageOrientation) {.cdecl, 
    importc: "gtk_page_setup_set_orientation", dynlib: lib.}
proc get_paper_size*(setup: PPageSetup): PPaperSize {.
    cdecl, importc: "gtk_page_setup_get_paper_size", dynlib: lib.}
proc set_paper_size*(setup: PPageSetup; 
                                    size: PPaperSize) {.cdecl, 
    importc: "gtk_page_setup_set_paper_size", dynlib: lib.}
proc get_top_margin*(setup: PPageSetup; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_page_setup_get_top_margin", dynlib: lib.}
proc set_top_margin*(setup: PPageSetup; margin: gdouble; 
                                    unit: TUnit) {.cdecl, 
    importc: "gtk_page_setup_set_top_margin", dynlib: lib.}
proc get_bottom_margin*(setup: PPageSetup; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_page_setup_get_bottom_margin", dynlib: lib.}
proc set_bottom_margin*(setup: PPageSetup; 
    margin: gdouble; unit: TUnit) {.cdecl, importc: "gtk_page_setup_set_bottom_margin", 
                                      dynlib: lib.}
proc get_left_margin*(setup: PPageSetup; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_page_setup_get_left_margin", dynlib: lib.}
proc set_left_margin*(setup: PPageSetup; margin: gdouble; 
                                     unit: TUnit) {.cdecl, 
    importc: "gtk_page_setup_set_left_margin", dynlib: lib.}
proc get_right_margin*(setup: PPageSetup; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_page_setup_get_right_margin", dynlib: lib.}
proc set_right_margin*(setup: PPageSetup; 
                                      margin: gdouble; unit: TUnit) {.cdecl, 
    importc: "gtk_page_setup_set_right_margin", dynlib: lib.}
proc set_paper_size_and_default_margins*(
    setup: PPageSetup; size: PPaperSize) {.cdecl, 
    importc: "gtk_page_setup_set_paper_size_and_default_margins", dynlib: lib.}
proc get_paper_width*(setup: PPageSetup; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_page_setup_get_paper_width", dynlib: lib.}
proc get_paper_height*(setup: PPageSetup; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_page_setup_get_paper_height", dynlib: lib.}
proc get_page_width*(setup: PPageSetup; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_page_setup_get_page_width", dynlib: lib.}
proc get_page_height*(setup: PPageSetup; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_page_setup_get_page_height", dynlib: lib.}
proc page_setup_new_from_file*(file_name: CSTRING; error: ptr PGError): PPageSetup {.
    cdecl, importc: "gtk_page_setup_new_from_file", dynlib: lib.}
proc load_file*(setup: PPageSetup; file_name: cstring; 
                               error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_page_setup_load_file", dynlib: lib.}
proc to_file*(setup: PPageSetup; file_name: cstring; 
                             error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_page_setup_to_file", dynlib: lib.}
proc page_setup_new_from_key_file*(key_file: PGKeyFile; 
    group_name: CSTRING; error: ptr PGError): PPageSetup {.cdecl, 
    importc: "gtk_page_setup_new_from_key_file", dynlib: lib.}
proc load_key_file*(setup: PPageSetup; 
                                   key_file: PGKeyFile; 
                                   group_name: CSTRING; 
                                   error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_page_setup_load_key_file", dynlib: lib.}
proc to_key_file*(setup: PPageSetup; 
                                 key_file: PGKeyFile; group_name: CSTRING) {.
    cdecl, importc: "gtk_page_setup_to_key_file", dynlib: lib.}

template TYPE_PANED*(): expr = 
  (gtk_paned_get_type())

template PANED_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PANED, TPaned))

template PANED_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_PANED, TPanedClass))

template IS_PANED*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PANED))

template IS_PANED_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_PANED))

template PANED_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_PANED, TPanedClass))

type 
  PPaned* = ptr TPaned
  TPaned* = object of TContainer
    priv102: PPanedPrivate

type 
  PPanedClass* = ptr TPanedClass
  TPanedClass* = object of TContainerClass
    cycle_child_focus*: proc (paned: PPaned; reverse: gboolean): gboolean {.
        cdecl.}
    toggle_handle_focus*: proc (paned: PPaned): gboolean {.cdecl.}
    move_handle*: proc (paned: PPaned; scroll: TScrollType): gboolean {.
        cdecl.}
    cycle_handle_focus*: proc (paned: PPaned; reverse: gboolean): gboolean {.
        cdecl.}
    accept_position*: proc (paned: PPaned): gboolean {.cdecl.}
    cancel_position*: proc (paned: PPaned): gboolean {.cdecl.}
    ugtk_reserved971: proc () {.cdecl.}
    ugtk_reserved972: proc () {.cdecl.}
    ugtk_reserved973: proc () {.cdecl.}
    ugtk_reserved974: proc () {.cdecl.}

proc paned_get_type*(): GType {.cdecl, importc: "gtk_paned_get_type", 
                                    dynlib: lib.}
proc paned_new*(orientation: TOrientation): PWidget {.cdecl, 
    importc: "gtk_paned_new", dynlib: lib.}
proc add1*(paned: PPaned; child: PWidget) {.cdecl, 
    importc: "gtk_paned_add1", dynlib: lib.}
proc add2*(paned: PPaned; child: PWidget) {.cdecl, 
    importc: "gtk_paned_add2", dynlib: lib.}
proc pack1*(paned: PPaned; child: PWidget; 
                      resize: gboolean; shrink: gboolean) {.cdecl, 
    importc: "gtk_paned_pack1", dynlib: lib.}
proc pack2*(paned: PPaned; child: PWidget; 
                      resize: gboolean; shrink: gboolean) {.cdecl, 
    importc: "gtk_paned_pack2", dynlib: lib.}
proc get_position*(paned: PPaned): gint {.cdecl, 
    importc: "gtk_paned_get_position", dynlib: lib.}
proc set_position*(paned: PPaned; position: gint) {.cdecl, 
    importc: "gtk_paned_set_position", dynlib: lib.}
proc get_child1*(paned: PPaned): PWidget {.cdecl, 
    importc: "gtk_paned_get_child1", dynlib: lib.}
proc get_child2*(paned: PPaned): PWidget {.cdecl, 
    importc: "gtk_paned_get_child2", dynlib: lib.}
proc get_handle_window*(paned: PPaned): PGdkWindow {.cdecl, 
    importc: "gtk_paned_get_handle_window", dynlib: lib.}

template TYPE_PLACES_SIDEBAR*(): expr = 
  (gtk_places_sidebar_get_type())

template PLACES_SIDEBAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PLACES_SIDEBAR, TPlacesSidebar))

template PLACES_SIDEBAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_PLACES_SIDEBAR, 
                           PlacesSidebarClass))

template IS_PLACES_SIDEBAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PLACES_SIDEBAR))

template IS_PLACES_SIDEBAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_PLACES_SIDEBAR))

template PLACES_SIDEBAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_PLACES_SIDEBAR, 
                             PlacesSidebarClass))

type 
  TPlacesOpenFlags* {.size: sizeof(cint).} = enum 
    PLACES_OPEN_NORMAL = 1 shl 0, PLACES_OPEN_NEW_TAB = 1 shl 1, 
    PLACES_OPEN_NEW_WINDOW = 1 shl 2
proc places_sidebar_get_type*(): GType {.cdecl, 
    importc: "gtk_places_sidebar_get_type", dynlib: lib.}
proc places_sidebar_new*(): PWidget {.cdecl, 
    importc: "gtk_places_sidebar_new", dynlib: lib.}
proc get_open_flags*(sidebar: PPlacesSidebar): TPlacesOpenFlags {.
    cdecl, importc: "gtk_places_sidebar_get_open_flags", dynlib: lib.}
proc set_open_flags*(sidebar: PPlacesSidebar; 
    flags: TPlacesOpenFlags) {.cdecl, importc: "gtk_places_sidebar_set_open_flags", 
                                 dynlib: lib.}
proc get_location*(sidebar: PPlacesSidebar): PGFile {.
    cdecl, importc: "gtk_places_sidebar_get_location", dynlib: lib.}
proc set_location*(sidebar: PPlacesSidebar; 
                                      location: PGFile) {.cdecl, 
    importc: "gtk_places_sidebar_set_location", dynlib: lib.}
proc get_show_desktop*(sidebar: PPlacesSidebar): gboolean {.
    cdecl, importc: "gtk_places_sidebar_get_show_desktop", dynlib: lib.}
proc set_show_desktop*(sidebar: PPlacesSidebar; 
    show_desktop: gboolean) {.cdecl, 
                              importc: "gtk_places_sidebar_set_show_desktop", 
                              dynlib: lib.}
proc get_show_connect_to_server*(
    sidebar: PPlacesSidebar): gboolean {.cdecl, 
    importc: "gtk_places_sidebar_get_show_connect_to_server", dynlib: lib.}
proc set_show_connect_to_server*(
    sidebar: PPlacesSidebar; show_connect_to_server: gboolean) {.cdecl, 
    importc: "gtk_places_sidebar_set_show_connect_to_server", dynlib: lib.}
proc set_local_only*(sidebar: PPlacesSidebar; 
    local_only: gboolean) {.cdecl, 
                            importc: "gtk_places_sidebar_set_local_only", 
                            dynlib: lib.}
proc get_local_only*(sidebar: PPlacesSidebar): gboolean {.
    cdecl, importc: "gtk_places_sidebar_get_local_only", dynlib: lib.}
proc add_shortcut*(sidebar: PPlacesSidebar; 
                                      location: PGFile) {.cdecl, 
    importc: "gtk_places_sidebar_add_shortcut", dynlib: lib.}
proc remove_shortcut*(sidebar: PPlacesSidebar; 
    location: PGFile) {.cdecl, 
                           importc: "gtk_places_sidebar_remove_shortcut", 
                           dynlib: lib.}
proc list_shortcuts*(sidebar: PPlacesSidebar): PGSList {.
    cdecl, importc: "gtk_places_sidebar_list_shortcuts", dynlib: lib.}
proc get_nth_bookmark*(sidebar: PPlacesSidebar; 
    n: gint): PGFile {.cdecl, 
                          importc: "gtk_places_sidebar_get_nth_bookmark", 
                          dynlib: lib.}

template TYPE_PRINT_CONTEXT*(): expr = 
  (gtk_print_context_get_type())

template PRINT_CONTEXT_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PRINT_CONTEXT, TPrintContext))

template IS_PRINT_CONTEXT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PRINT_CONTEXT))

proc print_context_get_type*(): GType {.cdecl, 
    importc: "gtk_print_context_get_type", dynlib: lib.}
proc get_cairo_context*(context: PPrintContext): cairo.Pcontext {.
    cdecl, importc: "gtk_print_context_get_cairo_context", dynlib: lib.}
proc get_page_setup*(context: PPrintContext): PPageSetup {.
    cdecl, importc: "gtk_print_context_get_page_setup", dynlib: lib.}
proc get_width*(context: PPrintContext): gdouble {.
    cdecl, importc: "gtk_print_context_get_width", dynlib: lib.}
proc get_height*(context: PPrintContext): gdouble {.
    cdecl, importc: "gtk_print_context_get_height", dynlib: lib.}
proc get_dpi_x*(context: PPrintContext): gdouble {.
    cdecl, importc: "gtk_print_context_get_dpi_x", dynlib: lib.}
proc get_dpi_y*(context: PPrintContext): gdouble {.
    cdecl, importc: "gtk_print_context_get_dpi_y", dynlib: lib.}
proc get_hard_margins*(context: PPrintContext; 
    top: Pgdouble; bottom: Pgdouble; left: Pgdouble; 
    right: Pgdouble): gboolean {.cdecl, importc: "gtk_print_context_get_hard_margins", 
                                    dynlib: lib.}
proc get_pango_fontmap*(context: PPrintContext): pango.PFontMap {.
    cdecl, importc: "gtk_print_context_get_pango_fontmap", dynlib: lib.}
proc create_pango_context*(context: PPrintContext): pango.Pcontext {.
    cdecl, importc: "gtk_print_context_create_pango_context", dynlib: lib.}
proc create_pango_layout*(context: PPrintContext): Playout {.
    cdecl, importc: "gtk_print_context_create_pango_layout", dynlib: lib.}
proc set_cairo_context*(context: PPrintContext; 
    cr: cairo.Pcontext; dpi_x: cdouble; dpi_y: cdouble) {.cdecl, 
    importc: "gtk_print_context_set_cairo_context", dynlib: lib.}

template TYPE_PRINT_SETTINGS*(): expr = 
  (gtk_print_settings_get_type())

template PRINT_SETTINGS_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PRINT_SETTINGS, TPrintSettings))

template IS_PRINT_SETTINGS*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PRINT_SETTINGS))

type 
  TPrintSettingsFunc* = proc (key: CSTRING; value: CSTRING; 
                                user_data: gpointer) {.cdecl.}
type 
  PPageRange* = ptr TPageRange
  TPageRange*{.final, pure.} = object 
    start*: gint
    e*: gint

proc print_settings_get_type*(): GType {.cdecl, 
    importc: "gtk_print_settings_get_type", dynlib: lib.}
proc print_settings_new*(): PPrintSettings {.cdecl, 
    importc: "gtk_print_settings_new", dynlib: lib.}
proc copy*(other: PPrintSettings): PPrintSettings {.
    cdecl, importc: "gtk_print_settings_copy", dynlib: lib.}
proc print_settings_new_from_file*(file_name: CSTRING; 
    error: ptr PGError): PPrintSettings {.cdecl, 
    importc: "gtk_print_settings_new_from_file", dynlib: lib.}
proc load_file*(settings: PPrintSettings; 
                                   file_name: CSTRING; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_print_settings_load_file", dynlib: lib.}
proc to_file*(settings: PPrintSettings; 
                                 file_name: CSTRING; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_print_settings_to_file", dynlib: lib.}
proc print_settings_new_from_key_file*(key_file: PGKeyFile; 
    group_name: CSTRING; error: ptr PGError): PPrintSettings {.
    cdecl, importc: "gtk_print_settings_new_from_key_file", dynlib: lib.}
proc load_key_file*(settings: PPrintSettings; 
    key_file: PGKeyFile; group_name: CSTRING; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_print_settings_load_key_file", dynlib: lib.}
proc to_key_file*(settings: PPrintSettings; 
                                     key_file: PGKeyFile; 
                                     group_name: CSTRING) {.cdecl, 
    importc: "gtk_print_settings_to_key_file", dynlib: lib.}
proc has_key*(settings: PPrintSettings; 
                                 key: CSTRING): gboolean {.cdecl, 
    importc: "gtk_print_settings_has_key", dynlib: lib.}
proc get*(settings: PPrintSettings; key: CSTRING): CSTRING {.
    cdecl, importc: "gtk_print_settings_get", dynlib: lib.}
proc set*(settings: PPrintSettings; key: CSTRING; 
                             value: CSTRING) {.cdecl, 
    importc: "gtk_print_settings_set", dynlib: lib.}
proc unset*(settings: PPrintSettings; key: CSTRING) {.
    cdecl, importc: "gtk_print_settings_unset", dynlib: lib.}
proc foreach*(settings: PPrintSettings; 
                                 func: TPrintSettingsFunc; 
                                 user_data: gpointer) {.cdecl, 
    importc: "gtk_print_settings_foreach", dynlib: lib.}
proc get_bool*(settings: PPrintSettings; 
                                  key: CSTRING): gboolean {.cdecl, 
    importc: "gtk_print_settings_get_bool", dynlib: lib.}
proc set_bool*(settings: PPrintSettings; 
                                  key: CSTRING; value: gboolean) {.cdecl, 
    importc: "gtk_print_settings_set_bool", dynlib: lib.}
proc get_double*(settings: PPrintSettings; 
                                    key: CSTRING): gdouble {.cdecl, 
    importc: "gtk_print_settings_get_double", dynlib: lib.}
proc get_double_with_default*(
    settings: PPrintSettings; key: CSTRING; def: gdouble): gdouble {.
    cdecl, importc: "gtk_print_settings_get_double_with_default", dynlib: lib.}
proc set_double*(settings: PPrintSettings; 
                                    key: CSTRING; value: gdouble) {.cdecl, 
    importc: "gtk_print_settings_set_double", dynlib: lib.}
proc get_length*(settings: PPrintSettings; 
                                    key: CSTRING; unit: TUnit): gdouble {.
    cdecl, importc: "gtk_print_settings_get_length", dynlib: lib.}
proc set_length*(settings: PPrintSettings; 
                                    key: CSTRING; value: gdouble; 
                                    unit: TUnit) {.cdecl, 
    importc: "gtk_print_settings_set_length", dynlib: lib.}
proc get_int*(settings: PPrintSettings; 
                                 key: CSTRING): gint {.cdecl, 
    importc: "gtk_print_settings_get_int", dynlib: lib.}
proc get_int_with_default*(settings: PPrintSettings; 
    key: CSTRING; def: gint): gint {.cdecl, 
    importc: "gtk_print_settings_get_int_with_default", dynlib: lib.}
proc set_int*(settings: PPrintSettings; 
                                 key: CSTRING; value: gint) {.cdecl, 
    importc: "gtk_print_settings_set_int", dynlib: lib.}
const 
  PRINT_SETTINGS_PRINTER* = "printer"
  PRINT_SETTINGS_ORIENTATION* = "orientation"
  PRINT_SETTINGS_PAPER_FORMAT* = "paper-format"
  PRINT_SETTINGS_PAPER_WIDTH* = "paper-width"
  PRINT_SETTINGS_PAPER_HEIGHT* = "paper-height"
  PRINT_SETTINGS_N_COPIES* = "n-copies"
  PRINT_SETTINGS_DEFAULT_SOURCE* = "default-source"
  PRINT_SETTINGS_QUALITY* = "quality"
  PRINT_SETTINGS_RESOLUTION* = "resolution"
  PRINT_SETTINGS_USE_COLOR* = "use-color"
  PRINT_SETTINGS_DUPLEX* = "duplex"
  PRINT_SETTINGS_COLLATE* = "collate"
  PRINT_SETTINGS_REVERSE* = "reverse"
  PRINT_SETTINGS_MEDIA_TYPE* = "media-type"
  PRINT_SETTINGS_DITHER* = "dither"
  PRINT_SETTINGS_SCALE* = "scale"
  PRINT_SETTINGS_PRINT_PAGES* = "print-pages"
  PRINT_SETTINGS_PAGE_RANGES* = "page-ranges"
  PRINT_SETTINGS_PAGE_SET* = "page-set"
  PRINT_SETTINGS_FINISHINGS* = "finishings"
  PRINT_SETTINGS_NUMBER_UP* = "number-up"
  PRINT_SETTINGS_NUMBER_UP_LAYOUT* = "number-up-layout"
  PRINT_SETTINGS_OUTPUT_BIN* = "output-bin"
  PRINT_SETTINGS_RESOLUTION_X* = "resolution-x"
  PRINT_SETTINGS_RESOLUTION_Y* = "resolution-y"
  PRINT_SETTINGS_PRINTER_LPI* = "printer-lpi"
const 
  PRINT_SETTINGS_OUTPUT_DIR* = "output-dir"
const 
  PRINT_SETTINGS_OUTPUT_BASENAME* = "output-basename"
const 
  PRINT_SETTINGS_OUTPUT_FILE_FORMAT* = "output-file-format"
const 
  PRINT_SETTINGS_OUTPUT_URI* = "output-uri"
  PRINT_SETTINGS_WIN32_DRIVER_VERSION* = "win32-driver-version"
  PRINT_SETTINGS_WIN32_DRIVER_EXTRA* = "win32-driver-extra"
proc get_printer*(settings: PPrintSettings): CSTRING {.
    cdecl, importc: "gtk_print_settings_get_printer", dynlib: lib.}
proc set_printer*(settings: PPrintSettings; 
                                     printer: CSTRING) {.cdecl, 
    importc: "gtk_print_settings_set_printer", dynlib: lib.}
proc get_orientation*(settings: PPrintSettings): TPageOrientation {.
    cdecl, importc: "gtk_print_settings_get_orientation", dynlib: lib.}
proc set_orientation*(settings: PPrintSettings; 
    orientation: TPageOrientation) {.cdecl, 
    importc: "gtk_print_settings_set_orientation", dynlib: lib.}
proc get_paper_size*(settings: PPrintSettings): PPaperSize {.
    cdecl, importc: "gtk_print_settings_get_paper_size", dynlib: lib.}
proc set_paper_size*(settings: PPrintSettings; 
    paper_size: PPaperSize) {.cdecl, importc: "gtk_print_settings_set_paper_size", 
                                    dynlib: lib.}
proc get_paper_width*(settings: PPrintSettings; 
    unit: TUnit): gdouble {.cdecl, 
                              importc: "gtk_print_settings_get_paper_width", 
                              dynlib: lib.}
proc set_paper_width*(settings: PPrintSettings; 
    width: gdouble; unit: TUnit) {.cdecl, importc: "gtk_print_settings_set_paper_width", 
                                     dynlib: lib.}
proc get_paper_height*(settings: PPrintSettings; 
    unit: TUnit): gdouble {.cdecl, 
                              importc: "gtk_print_settings_get_paper_height", 
                              dynlib: lib.}
proc set_paper_height*(settings: PPrintSettings; 
    height: gdouble; unit: TUnit) {.cdecl, importc: "gtk_print_settings_set_paper_height", 
                                      dynlib: lib.}
proc get_use_color*(settings: PPrintSettings): gboolean {.
    cdecl, importc: "gtk_print_settings_get_use_color", dynlib: lib.}
proc set_use_color*(settings: PPrintSettings; 
    use_color: gboolean) {.cdecl, importc: "gtk_print_settings_set_use_color", 
                           dynlib: lib.}
proc get_collate*(settings: PPrintSettings): gboolean {.
    cdecl, importc: "gtk_print_settings_get_collate", dynlib: lib.}
proc set_collate*(settings: PPrintSettings; 
                                     collate: gboolean) {.cdecl, 
    importc: "gtk_print_settings_set_collate", dynlib: lib.}
proc get_reverse*(settings: PPrintSettings): gboolean {.
    cdecl, importc: "gtk_print_settings_get_reverse", dynlib: lib.}
proc set_reverse*(settings: PPrintSettings; 
                                     reverse: gboolean) {.cdecl, 
    importc: "gtk_print_settings_set_reverse", dynlib: lib.}
proc get_duplex*(settings: PPrintSettings): TPrintDuplex {.
    cdecl, importc: "gtk_print_settings_get_duplex", dynlib: lib.}
proc set_duplex*(settings: PPrintSettings; 
                                    duplex: TPrintDuplex) {.cdecl, 
    importc: "gtk_print_settings_set_duplex", dynlib: lib.}
proc get_quality*(settings: PPrintSettings): TPrintQuality {.
    cdecl, importc: "gtk_print_settings_get_quality", dynlib: lib.}
proc set_quality*(settings: PPrintSettings; 
                                     quality: TPrintQuality) {.cdecl, 
    importc: "gtk_print_settings_set_quality", dynlib: lib.}
proc get_n_copies*(settings: PPrintSettings): gint {.
    cdecl, importc: "gtk_print_settings_get_n_copies", dynlib: lib.}
proc set_n_copies*(settings: PPrintSettings; 
                                      num_copies: gint) {.cdecl, 
    importc: "gtk_print_settings_set_n_copies", dynlib: lib.}
proc get_number_up*(settings: PPrintSettings): gint {.
    cdecl, importc: "gtk_print_settings_get_number_up", dynlib: lib.}
proc set_number_up*(settings: PPrintSettings; 
    number_up: gint) {.cdecl, importc: "gtk_print_settings_set_number_up", 
                       dynlib: lib.}
proc get_number_up_layout*(settings: PPrintSettings): TNumberUpLayout {.
    cdecl, importc: "gtk_print_settings_get_number_up_layout", dynlib: lib.}
proc set_number_up_layout*(settings: PPrintSettings; 
    number_up_layout: TNumberUpLayout) {.cdecl, 
    importc: "gtk_print_settings_set_number_up_layout", dynlib: lib.}
proc get_resolution*(settings: PPrintSettings): gint {.
    cdecl, importc: "gtk_print_settings_get_resolution", dynlib: lib.}
proc set_resolution*(settings: PPrintSettings; 
    resolution: gint) {.cdecl, importc: "gtk_print_settings_set_resolution", 
                        dynlib: lib.}
proc get_resolution_x*(settings: PPrintSettings): gint {.
    cdecl, importc: "gtk_print_settings_get_resolution_x", dynlib: lib.}
proc get_resolution_y*(settings: PPrintSettings): gint {.
    cdecl, importc: "gtk_print_settings_get_resolution_y", dynlib: lib.}
proc set_resolution_xy*(settings: PPrintSettings; 
    resolution_x: gint; resolution_y: gint) {.cdecl, 
    importc: "gtk_print_settings_set_resolution_xy", dynlib: lib.}
proc get_printer_lpi*(settings: PPrintSettings): gdouble {.
    cdecl, importc: "gtk_print_settings_get_printer_lpi", dynlib: lib.}
proc set_printer_lpi*(settings: PPrintSettings; 
    lpi: gdouble) {.cdecl, importc: "gtk_print_settings_set_printer_lpi", 
                    dynlib: lib.}
proc get_scale*(settings: PPrintSettings): gdouble {.
    cdecl, importc: "gtk_print_settings_get_scale", dynlib: lib.}
proc set_scale*(settings: PPrintSettings; 
                                   scale: gdouble) {.cdecl, 
    importc: "gtk_print_settings_set_scale", dynlib: lib.}
proc get_print_pages*(settings: PPrintSettings): TPrintPages {.
    cdecl, importc: "gtk_print_settings_get_print_pages", dynlib: lib.}
proc set_print_pages*(settings: PPrintSettings; 
    pages: TPrintPages) {.cdecl, 
                            importc: "gtk_print_settings_set_print_pages", 
                            dynlib: lib.}
proc get_page_ranges*(settings: PPrintSettings; 
    num_ranges: Pgint): PPageRange {.cdecl, 
    importc: "gtk_print_settings_get_page_ranges", dynlib: lib.}
proc set_page_ranges*(settings: PPrintSettings; 
    page_ranges: PPageRange; num_ranges: gint) {.cdecl, 
    importc: "gtk_print_settings_set_page_ranges", dynlib: lib.}
proc get_page_set*(settings: PPrintSettings): TPageSet {.
    cdecl, importc: "gtk_print_settings_get_page_set", dynlib: lib.}
proc set_page_set*(settings: PPrintSettings; 
                                      page_set: TPageSet) {.cdecl, 
    importc: "gtk_print_settings_set_page_set", dynlib: lib.}
proc get_default_source*(settings: PPrintSettings): CSTRING {.
    cdecl, importc: "gtk_print_settings_get_default_source", dynlib: lib.}
proc set_default_source*(settings: PPrintSettings; 
    default_source: CSTRING) {.cdecl, importc: "gtk_print_settings_set_default_source", 
                                 dynlib: lib.}
proc get_media_type*(settings: PPrintSettings): CSTRING {.
    cdecl, importc: "gtk_print_settings_get_media_type", dynlib: lib.}
proc set_media_type*(settings: PPrintSettings; 
    media_type: CSTRING) {.cdecl, 
                             importc: "gtk_print_settings_set_media_type", 
                             dynlib: lib.}
proc get_dither*(settings: PPrintSettings): CSTRING {.
    cdecl, importc: "gtk_print_settings_get_dither", dynlib: lib.}
proc set_dither*(settings: PPrintSettings; 
                                    dither: CSTRING) {.cdecl, 
    importc: "gtk_print_settings_set_dither", dynlib: lib.}
proc get_finishings*(settings: PPrintSettings): CSTRING {.
    cdecl, importc: "gtk_print_settings_get_finishings", dynlib: lib.}
proc set_finishings*(settings: PPrintSettings; 
    finishings: CSTRING) {.cdecl, 
                             importc: "gtk_print_settings_set_finishings", 
                             dynlib: lib.}
proc get_output_bin*(settings: PPrintSettings): CSTRING {.
    cdecl, importc: "gtk_print_settings_get_output_bin", dynlib: lib.}
proc set_output_bin*(settings: PPrintSettings; 
    output_bin: CSTRING) {.cdecl, 
                             importc: "gtk_print_settings_set_output_bin", 
                             dynlib: lib.}

template TYPE_PRINT_OPERATION_PREVIEW*(): expr = 
  (gtk_print_operation_preview_get_type())

template PRINT_OPERATION_PREVIEW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PRINT_OPERATION_PREVIEW, 
                              TPrintOperationPreview))

template IS_PRINT_OPERATION_PREVIEW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PRINT_OPERATION_PREVIEW))

template PRINT_OPERATION_PREVIEW_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_PRINT_OPERATION_PREVIEW, 
                                 TPrintOperationPreviewIface))

type 
  PPrintOperationPreviewIface* = ptr TPrintOperationPreviewIface
  TPrintOperationPreviewIface* = object of TGTypeInterface
    ready*: proc (preview: PPrintOperationPreview; 
                  context: PPrintContext) {.cdecl.}
    got_page_size*: proc (preview: PPrintOperationPreview; 
                          context: PPrintContext; 
                          page_setup: PPageSetup) {.cdecl.}
    render_page*: proc (preview: PPrintOperationPreview; page_nr: gint) {.
        cdecl.}
    is_selected*: proc (preview: PPrintOperationPreview; page_nr: gint): gboolean {.
        cdecl.}
    end_preview*: proc (preview: PPrintOperationPreview) {.cdecl.}
    ugtk_reserved981: proc () {.cdecl.}
    ugtk_reserved982: proc () {.cdecl.}
    ugtk_reserved983: proc () {.cdecl.}
    ugtk_reserved984: proc () {.cdecl.}
    ugtk_reserved985: proc () {.cdecl.}
    ugtk_reserved986: proc () {.cdecl.}
    ugtk_reserved987: proc () {.cdecl.}
    ugtk_reserved988: proc () {.cdecl.}

proc print_operation_preview_get_type*(): GType {.cdecl, 
    importc: "gtk_print_operation_preview_get_type", dynlib: lib.}
proc render_page*(
    preview: PPrintOperationPreview; page_nr: gint) {.cdecl, 
    importc: "gtk_print_operation_preview_render_page", dynlib: lib.}
proc end_preview*(
    preview: PPrintOperationPreview) {.cdecl, 
    importc: "gtk_print_operation_preview_end_preview", dynlib: lib.}
proc is_selected*(
    preview: PPrintOperationPreview; page_nr: gint): gboolean {.cdecl, 
    importc: "gtk_print_operation_preview_is_selected", dynlib: lib.}

template TYPE_PRINT_OPERATION*(): expr = 
  (gtk_print_operation_get_type())

template PRINT_OPERATION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PRINT_OPERATION, 
                              TPrintOperation))

template PRINT_OPERATION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_PRINT_OPERATION, 
                           TPrintOperationClass))

template IS_PRINT_OPERATION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PRINT_OPERATION))

template IS_PRINT_OPERATION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_PRINT_OPERATION))

template PRINT_OPERATION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_PRINT_OPERATION, 
                             TPrintOperationClass))

type 
  TPrintStatus* {.size: sizeof(cint).} = enum 
    PRINT_STATUS_INITIAL, PRINT_STATUS_PREPARING, 
    PRINT_STATUS_GENERATING_DATA, PRINT_STATUS_SENDING_DATA, 
    PRINT_STATUS_PENDING, PRINT_STATUS_PENDING_ISSUE, 
    PRINT_STATUS_PRINTING, PRINT_STATUS_FINISHED, 
    PRINT_STATUS_FINISHED_ABORTED
type 
  TPrintOperationResult* {.size: sizeof(cint).} = enum 
    PRINT_OPERATION_RESULT_ERROR, PRINT_OPERATION_RESULT_APPLY, 
    PRINT_OPERATION_RESULT_CANCEL, PRINT_OPERATION_RESULT_IN_PROGRESS
type 
  TPrintOperationAction* {.size: sizeof(cint).} = enum 
    PRINT_OPERATION_ACTION_PRINT_DIALOG, PRINT_OPERATION_ACTION_PRINT, 
    PRINT_OPERATION_ACTION_PREVIEW, PRINT_OPERATION_ACTION_EXPORT
type 
  PPrintOperation* = ptr TPrintOperation
  TPrintOperation* = object of TGObject
    priv103: PPrintOperationPrivate

type 
  PPrintOperationClass* = ptr TPrintOperationClass
  TPrintOperationClass* = object of TGObjectClass
    done*: proc (operation: PPrintOperation; 
                 result: TPrintOperationResult) {.cdecl.}
    begin_print*: proc (operation: PPrintOperation; 
                        context: PPrintContext) {.cdecl.}
    paginate*: proc (operation: PPrintOperation; 
                     context: PPrintContext): gboolean {.cdecl.}
    request_page_setup*: proc (operation: PPrintOperation; 
                               context: PPrintContext; page_nr: gint; 
                               setup: PPageSetup) {.cdecl.}
    draw_page*: proc (operation: PPrintOperation; 
                      context: PPrintContext; page_nr: gint) {.cdecl.}
    end_print*: proc (operation: PPrintOperation; 
                      context: PPrintContext) {.cdecl.}
    status_changed*: proc (operation: PPrintOperation) {.cdecl.}
    create_custom_widget*: proc (operation: PPrintOperation): PWidget {.
        cdecl.}
    custom_widget_apply*: proc (operation: PPrintOperation; 
                                widget: PWidget) {.cdecl.}
    preview*: proc (operation: PPrintOperation; 
                    preview: PPrintOperationPreview; 
                    context: PPrintContext; parent: PWindow): gboolean {.
        cdecl.}
    update_custom_widget*: proc (operation: PPrintOperation; 
                                 widget: PWidget; 
                                 setup: PPageSetup; 
                                 settings: PPrintSettings) {.cdecl.}
    ugtk_reserved991: proc () {.cdecl.}
    ugtk_reserved992: proc () {.cdecl.}
    ugtk_reserved993: proc () {.cdecl.}
    ugtk_reserved994: proc () {.cdecl.}
    ugtk_reserved995: proc () {.cdecl.}
    ugtk_reserved996: proc () {.cdecl.}
    ugtk_reserved997: proc () {.cdecl.}
    ugtk_reserved998: proc () {.cdecl.}

template PRINT_ERROR*(): expr = 
  gtk_print_error_quark()

type 
  TPrintError* {.size: sizeof(cint).} = enum 
    PRINT_ERROR_GENERAL, PRINT_ERROR_INTERNAL_ERROR, 
    PRINT_ERROR_NOMEM, PRINT_ERROR_INVALID_FILE
proc print_error_quark*(): TGQuark {.cdecl, 
    importc: "gtk_print_error_quark", dynlib: lib.}
proc print_operation_get_type*(): GType {.cdecl, 
    importc: "gtk_print_operation_get_type", dynlib: lib.}
proc print_operation_new*(): PPrintOperation {.cdecl, 
    importc: "gtk_print_operation_new", dynlib: lib.}
proc set_default_page_setup*(op: PPrintOperation; 
    default_page_setup: PPageSetup) {.cdecl, 
    importc: "gtk_print_operation_set_default_page_setup", dynlib: lib.}
proc get_default_page_setup*(op: PPrintOperation): PPageSetup {.
    cdecl, importc: "gtk_print_operation_get_default_page_setup", dynlib: lib.}
proc set_print_settings*(op: PPrintOperation; 
    print_settings: PPrintSettings) {.cdecl, 
    importc: "gtk_print_operation_set_print_settings", dynlib: lib.}
proc get_print_settings*(op: PPrintOperation): PPrintSettings {.
    cdecl, importc: "gtk_print_operation_get_print_settings", dynlib: lib.}
proc set_job_name*(op: PPrintOperation; 
    job_name: CSTRING) {.cdecl, importc: "gtk_print_operation_set_job_name", 
                           dynlib: lib.}
proc set_n_pages*(op: PPrintOperation; n_pages: gint) {.
    cdecl, importc: "gtk_print_operation_set_n_pages", dynlib: lib.}
proc set_current_page*(op: PPrintOperation; 
    current_page: gint) {.cdecl, 
                          importc: "gtk_print_operation_set_current_page", 
                          dynlib: lib.}
proc set_use_full_page*(op: PPrintOperation; 
    full_page: gboolean) {.cdecl, 
                           importc: "gtk_print_operation_set_use_full_page", 
                           dynlib: lib.}
proc set_unit*(op: PPrintOperation; unit: TUnit) {.
    cdecl, importc: "gtk_print_operation_set_unit", dynlib: lib.}
proc set_export_filename*(op: PPrintOperation; 
    filename: CSTRING) {.cdecl, importc: "gtk_print_operation_set_export_filename", 
                           dynlib: lib.}
proc set_track_print_status*(op: PPrintOperation; 
    track_status: gboolean) {.cdecl, importc: "gtk_print_operation_set_track_print_status", 
                              dynlib: lib.}
proc set_show_progress*(op: PPrintOperation; 
    show_progress: gboolean) {.cdecl, importc: "gtk_print_operation_set_show_progress", 
                               dynlib: lib.}
proc set_allow_async*(op: PPrintOperation; 
    allow_async: gboolean) {.cdecl, 
                             importc: "gtk_print_operation_set_allow_async", 
                             dynlib: lib.}
proc set_custom_tab_label*(op: PPrintOperation; 
    label: CSTRING) {.cdecl, 
                        importc: "gtk_print_operation_set_custom_tab_label", 
                        dynlib: lib.}
proc run*(op: PPrintOperation; 
                              action: TPrintOperationAction; 
                              parent: PWindow; error: ptr PGError): TPrintOperationResult {.
    cdecl, importc: "gtk_print_operation_run", dynlib: lib.}
proc get_error*(op: PPrintOperation; 
                                    error: ptr PGError) {.cdecl, 
    importc: "gtk_print_operation_get_error", dynlib: lib.}
proc get_status*(op: PPrintOperation): TPrintStatus {.
    cdecl, importc: "gtk_print_operation_get_status", dynlib: lib.}
proc get_status_string*(op: PPrintOperation): CSTRING {.
    cdecl, importc: "gtk_print_operation_get_status_string", dynlib: lib.}
proc is_finished*(op: PPrintOperation): gboolean {.
    cdecl, importc: "gtk_print_operation_is_finished", dynlib: lib.}
proc cancel*(op: PPrintOperation) {.cdecl, 
    importc: "gtk_print_operation_cancel", dynlib: lib.}
proc draw_page_finish*(op: PPrintOperation) {.cdecl, 
    importc: "gtk_print_operation_draw_page_finish", dynlib: lib.}
proc set_defer_drawing*(op: PPrintOperation) {.
    cdecl, importc: "gtk_print_operation_set_defer_drawing", dynlib: lib.}
proc set_support_selection*(op: PPrintOperation; 
    support_selection: gboolean) {.cdecl, importc: "gtk_print_operation_set_support_selection", 
                                   dynlib: lib.}
proc get_support_selection*(op: PPrintOperation): gboolean {.
    cdecl, importc: "gtk_print_operation_get_support_selection", dynlib: lib.}
proc set_has_selection*(op: PPrintOperation; 
    has_selection: gboolean) {.cdecl, importc: "gtk_print_operation_set_has_selection", 
                               dynlib: lib.}
proc get_has_selection*(op: PPrintOperation): gboolean {.
    cdecl, importc: "gtk_print_operation_get_has_selection", dynlib: lib.}
proc set_embed_page_setup*(op: PPrintOperation; 
    embed: gboolean) {.cdecl, 
                       importc: "gtk_print_operation_set_embed_page_setup", 
                       dynlib: lib.}
proc get_embed_page_setup*(op: PPrintOperation): gboolean {.
    cdecl, importc: "gtk_print_operation_get_embed_page_setup", dynlib: lib.}
proc get_n_pages_to_print*(op: PPrintOperation): gint {.
    cdecl, importc: "gtk_print_operation_get_n_pages_to_print", dynlib: lib.}
proc print_run_page_setup_dialog*(parent: PWindow; 
                                      page_setup: PPageSetup; 
                                      settings: PPrintSettings): PPageSetup {.
    cdecl, importc: "gtk_print_run_page_setup_dialog", dynlib: lib.}
type 
  TPageSetupDoneFunc* = proc (page_setup: PPageSetup; data: gpointer) {.
      cdecl.}
proc print_run_page_setup_dialog_async*(parent: PWindow; 
    page_setup: PPageSetup; settings: PPrintSettings; 
    done_cb: TPageSetupDoneFunc; data: gpointer) {.cdecl, 
    importc: "gtk_print_run_page_setup_dialog_async", dynlib: lib.}

template TYPE_PROGRESS_BAR*(): expr = 
  (gtk_progress_bar_get_type())

template PROGRESS_BAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PROGRESS_BAR, TProgressBar))

template PROGRESS_BAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_PROGRESS_BAR, TProgressBarClass))

template IS_PROGRESS_BAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PROGRESS_BAR))

template IS_PROGRESS_BAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_PROGRESS_BAR))

template PROGRESS_BAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_PROGRESS_BAR, TProgressBarClass))

type 
  PProgressBar* = ptr TProgressBar
  TProgressBar* = object of TWidget
    priv104: PProgressBarPrivate

type 
  PProgressBarClass* = ptr TProgressBarClass
  TProgressBarClass* = object of TWidgetClass
    ugtk_reserved1001*: proc () {.cdecl.}
    ugtk_reserved1002*: proc () {.cdecl.}
    ugtk_reserved1003*: proc () {.cdecl.}
    ugtk_reserved1004*: proc () {.cdecl.}

proc progress_bar_get_type*(): GType {.cdecl, 
    importc: "gtk_progress_bar_get_type", dynlib: lib.}
proc progress_bar_new*(): PWidget {.cdecl, 
    importc: "gtk_progress_bar_new", dynlib: lib.}
proc pulse*(pbar: PProgressBar) {.cdecl, 
    importc: "gtk_progress_bar_pulse", dynlib: lib.}
proc set_text*(pbar: PProgressBar; text: CSTRING) {.
    cdecl, importc: "gtk_progress_bar_set_text", dynlib: lib.}
proc set_fraction*(pbar: PProgressBar; 
                                    fraction: gdouble) {.cdecl, 
    importc: "gtk_progress_bar_set_fraction", dynlib: lib.}
proc set_pulse_step*(pbar: PProgressBar; 
                                      fraction: gdouble) {.cdecl, 
    importc: "gtk_progress_bar_set_pulse_step", dynlib: lib.}
proc set_inverted*(pbar: PProgressBar; 
                                    inverted: gboolean) {.cdecl, 
    importc: "gtk_progress_bar_set_inverted", dynlib: lib.}
proc get_text*(pbar: PProgressBar): CSTRING {.cdecl, 
    importc: "gtk_progress_bar_get_text", dynlib: lib.}
proc get_fraction*(pbar: PProgressBar): gdouble {.
    cdecl, importc: "gtk_progress_bar_get_fraction", dynlib: lib.}
proc get_pulse_step*(pbar: PProgressBar): gdouble {.
    cdecl, importc: "gtk_progress_bar_get_pulse_step", dynlib: lib.}
proc get_inverted*(pbar: PProgressBar): gboolean {.
    cdecl, importc: "gtk_progress_bar_get_inverted", dynlib: lib.}
proc set_ellipsize*(pbar: PProgressBar; 
                                     mode: TEllipsizeMode) {.cdecl, 
    importc: "gtk_progress_bar_set_ellipsize", dynlib: lib.}
proc get_ellipsize*(pbar: PProgressBar): TEllipsizeMode {.
    cdecl, importc: "gtk_progress_bar_get_ellipsize", dynlib: lib.}
proc set_show_text*(pbar: PProgressBar; 
                                     show_text: gboolean) {.cdecl, 
    importc: "gtk_progress_bar_set_show_text", dynlib: lib.}
proc get_show_text*(pbar: PProgressBar): gboolean {.
    cdecl, importc: "gtk_progress_bar_get_show_text", dynlib: lib.}

template TYPE_RADIO_BUTTON*(): expr = 
  (gtk_radio_button_get_type())

template RADIO_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RADIO_BUTTON, TRadioButton))

template RADIO_BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RADIO_BUTTON, TRadioButtonClass))

template IS_RADIO_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RADIO_BUTTON))

template IS_RADIO_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RADIO_BUTTON))

template RADIO_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RADIO_BUTTON, TRadioButtonClass))

type 
  PRadioButton* = ptr TRadioButton
  TRadioButton* = object of TCheckButton
    priv105: PRadioButtonPrivate

type 
  PRadioButtonClass* = ptr TRadioButtonClass
  TRadioButtonClass* = object of TCheckButtonClass
    group_changed*: proc (radio_button: PRadioButton) {.cdecl.}
    ugtk_reserved1011*: proc () {.cdecl.}
    ugtk_reserved1012*: proc () {.cdecl.}
    ugtk_reserved1013*: proc () {.cdecl.}
    ugtk_reserved1014*: proc () {.cdecl.}

proc radio_button_get_type*(): GType {.cdecl, 
    importc: "gtk_radio_button_get_type", dynlib: lib.}
proc radio_button_new*(group: PGSList): PWidget {.cdecl, 
    importc: "gtk_radio_button_new", dynlib: lib.}
proc new_from_widget*(radio_group_member: PRadioButton): PWidget {.
    cdecl, importc: "gtk_radio_button_new_from_widget", dynlib: lib.}
proc radio_button_new_with_label*(group: PGSList; label: CSTRING): PWidget {.
    cdecl, importc: "gtk_radio_button_new_with_label", dynlib: lib.}
proc new_with_label_from_widget*(
    radio_group_member: PRadioButton; label: CSTRING): PWidget {.
    cdecl, importc: "gtk_radio_button_new_with_label_from_widget", dynlib: lib.}
proc radio_button_new_with_mnemonic*(group: PGSList; label: CSTRING): PWidget {.
    cdecl, importc: "gtk_radio_button_new_with_mnemonic", dynlib: lib.}
proc new_with_mnemonic_from_widget*(
    radio_group_member: PRadioButton; label: CSTRING): PWidget {.
    cdecl, importc: "gtk_radio_button_new_with_mnemonic_from_widget", 
    dynlib: lib.}
proc get_group*(radio_button: PRadioButton): PGSList {.
    cdecl, importc: "gtk_radio_button_get_group", dynlib: lib.}
proc set_group*(radio_button: PRadioButton; 
                                 group: PGSList) {.cdecl, 
    importc: "gtk_radio_button_set_group", dynlib: lib.}
proc join_group*(radio_button: PRadioButton; 
                                  group_source: PRadioButton) {.cdecl, 
    importc: "gtk_radio_button_join_group", dynlib: lib.}

template TYPE_RADIO_MENU_ITEM*(): expr = 
  (gtk_radio_menu_item_get_type())

template RADIO_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RADIO_MENU_ITEM, 
                              TRadioMenuItem))

template RADIO_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RADIO_MENU_ITEM, 
                           TRadioMenuItemClass))

template IS_RADIO_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RADIO_MENU_ITEM))

template IS_RADIO_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RADIO_MENU_ITEM))

template RADIO_MENU_ITEM_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RADIO_MENU_ITEM, 
                             TRadioMenuItemClass))

type 
  PRadioMenuItem* = ptr TRadioMenuItem
  TRadioMenuItem* = object of TCheckMenuItem
    priv106: PRadioMenuItemPrivate

type 
  PRadioMenuItemClass* = ptr TRadioMenuItemClass
  TRadioMenuItemClass* = object of TCheckMenuItemClass
    group_changed*: proc (radio_menu_item: PRadioMenuItem) {.cdecl.}
    ugtk_reserved1021*: proc () {.cdecl.}
    ugtk_reserved1022*: proc () {.cdecl.}
    ugtk_reserved1023*: proc () {.cdecl.}
    ugtk_reserved1024*: proc () {.cdecl.}

proc radio_menu_item_get_type*(): GType {.cdecl, 
    importc: "gtk_radio_menu_item_get_type", dynlib: lib.}
proc radio_menu_item_new*(group: PGSList): PWidget {.cdecl, 
    importc: "gtk_radio_menu_item_new", dynlib: lib.}
proc radio_menu_item_new_with_label*(group: PGSList; label: CSTRING): PWidget {.
    cdecl, importc: "gtk_radio_menu_item_new_with_label", dynlib: lib.}
proc radio_menu_item_new_with_mnemonic*(group: PGSList; 
    label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_radio_menu_item_new_with_mnemonic", dynlib: lib.}
proc new_from_widget*(group: PRadioMenuItem): PWidget {.
    cdecl, importc: "gtk_radio_menu_item_new_from_widget", dynlib: lib.}
proc new_with_mnemonic_from_widget*(
    group: PRadioMenuItem; label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_radio_menu_item_new_with_mnemonic_from_widget", dynlib: lib.}
proc new_with_label_from_widget*(
    group: PRadioMenuItem; label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_radio_menu_item_new_with_label_from_widget", dynlib: lib.}
proc get_group*(radio_menu_item: PRadioMenuItem): PGSList {.
    cdecl, importc: "gtk_radio_menu_item_get_group", dynlib: lib.}
proc set_group*(radio_menu_item: PRadioMenuItem; 
                                    group: PGSList) {.cdecl, 
    importc: "gtk_radio_menu_item_set_group", dynlib: lib.}

template TYPE_TOGGLE_TOOL_BUTTON*(): expr = 
  (gtk_toggle_tool_button_get_type())

template TOGGLE_TOOL_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TOGGLE_TOOL_BUTTON, 
                              TToggleToolButton))

template TOGGLE_TOOL_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TOGGLE_TOOL_BUTTON, 
                           TToggleToolButtonClass))

template IS_TOGGLE_TOOL_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TOGGLE_TOOL_BUTTON))

template IS_TOGGLE_TOOL_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TOGGLE_TOOL_BUTTON))

template TOGGLE_TOOL_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TOGGLE_TOOL_BUTTON, 
                             TToggleToolButtonClass))

type 
  PToggleToolButton* = ptr TToggleToolButton
  TToggleToolButton* = object of TToolButton
    priv107: PToggleToolButtonPrivate

type 
  PToggleToolButtonClass* = ptr TToggleToolButtonClass
  TToggleToolButtonClass* = object of TToolButtonClass
    toggled*: proc (button: PToggleToolButton) {.cdecl.}
    ugtk_reserved1031*: proc () {.cdecl.}
    ugtk_reserved1032*: proc () {.cdecl.}
    ugtk_reserved1033*: proc () {.cdecl.}
    ugtk_reserved1034*: proc () {.cdecl.}

proc toggle_tool_button_get_type*(): GType {.cdecl, 
    importc: "gtk_toggle_tool_button_get_type", dynlib: lib.}
proc toggle_tool_button_new*(): PToolItem {.cdecl, 
    importc: "gtk_toggle_tool_button_new", dynlib: lib.}
proc toggle_tool_button_new_from_stock*(stock_id: CSTRING): PToolItem {.
    cdecl, importc: "gtk_toggle_tool_button_new_from_stock", dynlib: lib.}
proc set_active*(button: PToggleToolButton; 
    is_active: gboolean) {.cdecl, 
                           importc: "gtk_toggle_tool_button_set_active", 
                           dynlib: lib.}
proc get_active*(button: PToggleToolButton): gboolean {.
    cdecl, importc: "gtk_toggle_tool_button_get_active", dynlib: lib.}

template TYPE_RADIO_TOOL_BUTTON*(): expr = 
  (gtk_radio_tool_button_get_type())

template RADIO_TOOL_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RADIO_TOOL_BUTTON, 
                              TRadioToolButton))

template RADIO_TOOL_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RADIO_TOOL_BUTTON, 
                           TRadioToolButtonClass))

template IS_RADIO_TOOL_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RADIO_TOOL_BUTTON))

template IS_RADIO_TOOL_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RADIO_TOOL_BUTTON))

template RADIO_TOOL_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RADIO_TOOL_BUTTON, 
                             TRadioToolButtonClass))

type 
  PRadioToolButton* = ptr TRadioToolButton
  TRadioToolButton* = object of TToggleToolButton

type 
  PRadioToolButtonClass* = ptr TRadioToolButtonClass
  TRadioToolButtonClass* = object of TToggleToolButtonClass
    ugtk_reserved1041*: proc () {.cdecl.}
    ugtk_reserved1042*: proc () {.cdecl.}
    ugtk_reserved1043*: proc () {.cdecl.}
    ugtk_reserved1044*: proc () {.cdecl.}

proc radio_tool_button_get_type*(): GType {.cdecl, 
    importc: "gtk_radio_tool_button_get_type", dynlib: lib.}
proc radio_tool_button_new*(group: PGSList): PToolItem {.cdecl, 
    importc: "gtk_radio_tool_button_new", dynlib: lib.}
proc radio_tool_button_new_from_stock*(group: PGSList; 
    stock_id: CSTRING): PToolItem {.cdecl, 
    importc: "gtk_radio_tool_button_new_from_stock", dynlib: lib.}
proc new_from_widget*(group: PRadioToolButton): PToolItem {.
    cdecl, importc: "gtk_radio_tool_button_new_from_widget", dynlib: lib.}
proc new_with_stock_from_widget*(
    group: PRadioToolButton; stock_id: CSTRING): PToolItem {.
    cdecl, importc: "gtk_radio_tool_button_new_with_stock_from_widget", 
    dynlib: lib.}
proc get_group*(button: PRadioToolButton): PGSList {.
    cdecl, importc: "gtk_radio_tool_button_get_group", dynlib: lib.}
proc set_group*(button: PRadioToolButton; 
                                      group: PGSList) {.cdecl, 
    importc: "gtk_radio_tool_button_set_group", dynlib: lib.}

template TYPE_RANGE*(): expr = 
  (gtk_range_get_type())

template RANGE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RANGE, TRange))

template RANGE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RANGE, TRangeClass))

template IS_RANGE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RANGE))

template IS_RANGE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RANGE))

template RANGE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RANGE, TRangeClass))

type 
  PRange* = ptr TRange
  TRange* = object of TWidget
    priv108: PRangePrivate

type 
  PRangeClass* = ptr TRangeClass
  TRangeClass* = object of TWidgetClass
    slider_detail*: CSTRING
    stepper_detail*: CSTRING
    value_changed*: proc (range: PRange) {.cdecl.}
    adjust_bounds*: proc (range: PRange; new_value: gdouble) {.cdecl.}
    move_slider*: proc (range: PRange; scroll: TScrollType) {.cdecl.}
    get_range_border*: proc (range: PRange; border: PBorder) {.
        cdecl.}
    change_value*: proc (range: PRange; scroll: TScrollType; 
                         new_value: gdouble): gboolean {.cdecl.}
    ugtk_reserved1051*: proc () {.cdecl.}
    ugtk_reserved1052*: proc () {.cdecl.}
    ugtk_reserved1053*: proc () {.cdecl.}
    ugtk_reserved1054*: proc () {.cdecl.}

proc range_get_type*(): GType {.cdecl, importc: "gtk_range_get_type", 
                                    dynlib: lib.}
proc set_adjustment*(range: PRange; 
                               adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_range_set_adjustment", dynlib: lib.}
proc get_adjustment*(range: PRange): PAdjustment {.
    cdecl, importc: "gtk_range_get_adjustment", dynlib: lib.}
proc set_inverted*(range: PRange; setting: gboolean) {.cdecl, 
    importc: "gtk_range_set_inverted", dynlib: lib.}
proc get_inverted*(range: PRange): gboolean {.cdecl, 
    importc: "gtk_range_get_inverted", dynlib: lib.}
proc set_flippable*(range: PRange; flippable: gboolean) {.
    cdecl, importc: "gtk_range_set_flippable", dynlib: lib.}
proc get_flippable*(range: PRange): gboolean {.cdecl, 
    importc: "gtk_range_get_flippable", dynlib: lib.}
proc set_slider_size_fixed*(range: PRange; 
                                      size_fixed: gboolean) {.cdecl, 
    importc: "gtk_range_set_slider_size_fixed", dynlib: lib.}
proc get_slider_size_fixed*(range: PRange): gboolean {.cdecl, 
    importc: "gtk_range_get_slider_size_fixed", dynlib: lib.}
proc set_min_slider_size*(range: PRange; min_size: gint) {.
    cdecl, importc: "gtk_range_set_min_slider_size", dynlib: lib.}
proc get_min_slider_size*(range: PRange): gint {.cdecl, 
    importc: "gtk_range_get_min_slider_size", dynlib: lib.}
proc get_range_rect*(range: PRange; 
                               range_rect: gdk3.PRectangle) {.cdecl, 
    importc: "gtk_range_get_range_rect", dynlib: lib.}
proc get_slider_range*(range: PRange; slider_start: Pgint; 
                                 slider_end: Pgint) {.cdecl, 
    importc: "gtk_range_get_slider_range", dynlib: lib.}
proc set_lower_stepper_sensitivity*(range: PRange; 
    sensitivity: TSensitivityType) {.cdecl, 
    importc: "gtk_range_set_lower_stepper_sensitivity", dynlib: lib.}
proc get_lower_stepper_sensitivity*(range: PRange): TSensitivityType {.
    cdecl, importc: "gtk_range_get_lower_stepper_sensitivity", dynlib: lib.}
proc set_upper_stepper_sensitivity*(range: PRange; 
    sensitivity: TSensitivityType) {.cdecl, 
    importc: "gtk_range_set_upper_stepper_sensitivity", dynlib: lib.}
proc get_upper_stepper_sensitivity*(range: PRange): TSensitivityType {.
    cdecl, importc: "gtk_range_get_upper_stepper_sensitivity", dynlib: lib.}
proc set_increments*(range: PRange; step: gdouble; 
                               page: gdouble) {.cdecl, 
    importc: "gtk_range_set_increments", dynlib: lib.}
proc set_range*(range: PRange; min: gdouble; max: gdouble) {.
    cdecl, importc: "gtk_range_set_range", dynlib: lib.}
proc set_value*(range: PRange; value: gdouble) {.cdecl, 
    importc: "gtk_range_set_value", dynlib: lib.}
proc get_value*(range: PRange): gdouble {.cdecl, 
    importc: "gtk_range_get_value", dynlib: lib.}
proc set_show_fill_level*(range: PRange; 
                                    show_fill_level: gboolean) {.cdecl, 
    importc: "gtk_range_set_show_fill_level", dynlib: lib.}
proc get_show_fill_level*(range: PRange): gboolean {.cdecl, 
    importc: "gtk_range_get_show_fill_level", dynlib: lib.}
proc set_restrict_to_fill_level*(range: PRange; 
    restrict_to_fill_level: gboolean) {.cdecl, 
    importc: "gtk_range_set_restrict_to_fill_level", dynlib: lib.}
proc get_restrict_to_fill_level*(range: PRange): gboolean {.
    cdecl, importc: "gtk_range_get_restrict_to_fill_level", dynlib: lib.}
proc set_fill_level*(range: PRange; fill_level: gdouble) {.
    cdecl, importc: "gtk_range_set_fill_level", dynlib: lib.}
proc get_fill_level*(range: PRange): gdouble {.cdecl, 
    importc: "gtk_range_get_fill_level", dynlib: lib.}
proc set_round_digits*(range: PRange; round_digits: gint) {.
    cdecl, importc: "gtk_range_set_round_digits", dynlib: lib.}
proc get_round_digits*(range: PRange): gint {.cdecl, 
    importc: "gtk_range_get_round_digits", dynlib: lib.}

template TYPE_RECENT_INFO*(): expr = 
  (gtk_recent_info_get_type())

template TYPE_RECENT_MANAGER*(): expr = 
  (gtk_recent_manager_get_type())

template RECENT_MANAGER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RECENT_MANAGER, TRecentManager))

template IS_RECENT_MANAGER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RECENT_MANAGER))

template RECENT_MANAGER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RECENT_MANAGER, 
                           TRecentManagerClass))

template IS_RECENT_MANAGER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RECENT_MANAGER))

template RECENT_MANAGER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RECENT_MANAGER, 
                             TRecentManagerClass))

type 
  PRecentData* = ptr TRecentData
  TRecentData*{.final, pure.} = object 
    display_name*: CSTRING
    description*: CSTRING
    mime_type*: CSTRING
    app_name*: CSTRING
    app_exec*: CSTRING
    groups*: ptr CSTRING
    is_private*: gboolean

type 
  PRecentManager* = ptr TRecentManager
  TRecentManager* = object of TGObject
    priv109: PRecentManagerPrivate

type 
  PRecentManagerClass* = ptr TRecentManagerClass
  TRecentManagerClass* = object of TGObjectClass
    changed*: proc (manager: PRecentManager) {.cdecl.}
    ugtk_recent1*: proc () {.cdecl.}
    ugtk_recent2*: proc () {.cdecl.}
    ugtk_recent3*: proc () {.cdecl.}
    ugtk_recent4*: proc () {.cdecl.}

type 
  TRecentManagerError* {.size: sizeof(cint).} = enum 
    RECENT_MANAGER_ERROR_NOT_FOUND, RECENT_MANAGER_ERROR_INVALID_URI, 
    RECENT_MANAGER_ERROR_INVALID_ENCODING, 
    RECENT_MANAGER_ERROR_NOT_REGISTERED, RECENT_MANAGER_ERROR_READ, 
    RECENT_MANAGER_ERROR_WRITE, RECENT_MANAGER_ERROR_UNKNOWN
template RECENT_MANAGER_ERROR*(): expr = 
  (gtk_recent_manager_error_quark())

proc recent_manager_error_quark*(): TGQuark {.cdecl, 
    importc: "gtk_recent_manager_error_quark", dynlib: lib.}
proc recent_manager_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_manager_get_type", dynlib: lib.}
proc recent_manager_new*(): PRecentManager {.cdecl, 
    importc: "gtk_recent_manager_new", dynlib: lib.}
proc recent_manager_get_default*(): PRecentManager {.cdecl, 
    importc: "gtk_recent_manager_get_default", dynlib: lib.}
proc add_item*(manager: PRecentManager; 
                                  uri: CSTRING): gboolean {.cdecl, 
    importc: "gtk_recent_manager_add_item", dynlib: lib.}
proc add_full*(manager: PRecentManager; 
                                  uri: CSTRING; 
                                  recent_data: PRecentData): gboolean {.
    cdecl, importc: "gtk_recent_manager_add_full", dynlib: lib.}
proc remove_item*(manager: PRecentManager; 
                                     uri: CSTRING; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_recent_manager_remove_item", dynlib: lib.}
proc lookup_item*(manager: PRecentManager; 
                                     uri: CSTRING; error: ptr PGError): PRecentInfo {.
    cdecl, importc: "gtk_recent_manager_lookup_item", dynlib: lib.}
proc has_item*(manager: PRecentManager; 
                                  uri: CSTRING): gboolean {.cdecl, 
    importc: "gtk_recent_manager_has_item", dynlib: lib.}
proc move_item*(manager: PRecentManager; 
                                   uri: CSTRING; new_uri: CSTRING; 
                                   error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_recent_manager_move_item", dynlib: lib.}
proc get_items*(manager: PRecentManager): PGList {.
    cdecl, importc: "gtk_recent_manager_get_items", dynlib: lib.}
proc purge_items*(manager: PRecentManager; 
                                     error: ptr PGError): gint {.cdecl, 
    importc: "gtk_recent_manager_purge_items", dynlib: lib.}
proc recent_info_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_info_get_type", dynlib: lib.}
proc re*(info: PRecentInfo): PRecentInfo {.cdecl, 
    importc: "gtk_recent_info_ref", dynlib: lib.}
proc unref*(info: PRecentInfo) {.cdecl, 
    importc: "gtk_recent_info_unref", dynlib: lib.}
proc get_uri*(info: PRecentInfo): CSTRING {.cdecl, 
    importc: "gtk_recent_info_get_uri", dynlib: lib.}
proc get_display_name*(info: PRecentInfo): CSTRING {.
    cdecl, importc: "gtk_recent_info_get_display_name", dynlib: lib.}
proc get_description*(info: PRecentInfo): CSTRING {.
    cdecl, importc: "gtk_recent_info_get_description", dynlib: lib.}
proc get_mime_type*(info: PRecentInfo): CSTRING {.
    cdecl, importc: "gtk_recent_info_get_mime_type", dynlib: lib.}
proc get_added*(info: PRecentInfo): time_t {.cdecl, 
    importc: "gtk_recent_info_get_added", dynlib: lib.}
proc get_modified*(info: PRecentInfo): time_t {.cdecl, 
    importc: "gtk_recent_info_get_modified", dynlib: lib.}
proc get_visited*(info: PRecentInfo): time_t {.cdecl, 
    importc: "gtk_recent_info_get_visited", dynlib: lib.}
proc get_private_hint*(info: PRecentInfo): gboolean {.
    cdecl, importc: "gtk_recent_info_get_private_hint", dynlib: lib.}
proc get_application_info*(info: PRecentInfo; 
    app_name: CSTRING; app_exec: ptr CSTRING; count: Pguint; 
    time: Ptime_t): gboolean {.cdecl, importc: "gtk_recent_info_get_application_info", 
                                   dynlib: lib.}
proc create_app_info*(info: PRecentInfo; 
                                      app_name: CSTRING; 
                                      error: ptr PGError): PGAppInfo {.
    cdecl, importc: "gtk_recent_info_create_app_info", dynlib: lib.}
proc get_applications*(info: PRecentInfo; 
    length: Pgsize): ptr CSTRING {.cdecl, 
    importc: "gtk_recent_info_get_applications", dynlib: lib.}
proc last_application*(info: PRecentInfo): CSTRING {.
    cdecl, importc: "gtk_recent_info_last_application", dynlib: lib.}
proc has_application*(info: PRecentInfo; 
                                      app_name: CSTRING): gboolean {.cdecl, 
    importc: "gtk_recent_info_has_application", dynlib: lib.}
proc get_groups*(info: PRecentInfo; length: Pgsize): ptr CSTRING {.
    cdecl, importc: "gtk_recent_info_get_groups", dynlib: lib.}
proc has_group*(info: PRecentInfo; group_name: CSTRING): gboolean {.
    cdecl, importc: "gtk_recent_info_has_group", dynlib: lib.}
proc get_icon*(info: PRecentInfo; size: gint): PPixbuf {.
    cdecl, importc: "gtk_recent_info_get_icon", dynlib: lib.}
proc get_gicon*(info: PRecentInfo): PGIcon {.cdecl, 
    importc: "gtk_recent_info_get_gicon", dynlib: lib.}
proc get_short_name*(info: PRecentInfo): CSTRING {.
    cdecl, importc: "gtk_recent_info_get_short_name", dynlib: lib.}
proc get_uri_display*(info: PRecentInfo): CSTRING {.
    cdecl, importc: "gtk_recent_info_get_uri_display", dynlib: lib.}
proc get_age*(info: PRecentInfo): gint {.cdecl, 
    importc: "gtk_recent_info_get_age", dynlib: lib.}
proc is_local*(info: PRecentInfo): gboolean {.cdecl, 
    importc: "gtk_recent_info_is_local", dynlib: lib.}
proc exists*(info: PRecentInfo): gboolean {.cdecl, 
    importc: "gtk_recent_info_exists", dynlib: lib.}
proc match*(info_a: PRecentInfo; 
                            info_b: PRecentInfo): gboolean {.cdecl, 
    importc: "gtk_recent_info_match", dynlib: lib.}
proc underscore_gtk_recent_manager_sync*() {.cdecl, importc: "_gtk_recent_manager_sync", 
                                   dynlib: lib.}

template TYPE_RECENT_FILTER*(): expr = 
  (gtk_recent_filter_get_type())

template RECENT_FILTER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RECENT_FILTER, TRecentFilter))

template IS_RECENT_FILTER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RECENT_FILTER))

type 
  TRecentFilterFlags* {.size: sizeof(cint).} = enum 
    RECENT_FILTER_URI = 1 shl 0, RECENT_FILTER_DISPLAY_NAME = 1 shl
        1, RECENT_FILTER_MIME_TYPE = 1 shl 2, 
    RECENT_FILTER_APPLICATION = 1 shl 3, 
    RECENT_FILTER_GROUP = 1 shl 4, RECENT_FILTER_AGE = 1 shl 5
type 
  PRecentFilterInfo* = ptr TRecentFilterInfo
  TRecentFilterInfo*{.final, pure.} = object 
    contains*: TRecentFilterFlags
    uri*: CSTRING
    display_name*: CSTRING
    mime_type*: CSTRING
    applications*: ptr CSTRING
    groups*: ptr CSTRING
    age*: gint
type 
  TRecentFilterFunc* = proc (filter_info: PRecentFilterInfo; 
                               user_data: gpointer): gboolean {.cdecl.}

proc recent_filter_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_filter_get_type", dynlib: lib.}
proc recent_filter_new*(): PRecentFilter {.cdecl, 
    importc: "gtk_recent_filter_new", dynlib: lib.}
proc set_name*(filter: PRecentFilter; name: CSTRING) {.
    cdecl, importc: "gtk_recent_filter_set_name", dynlib: lib.}
proc get_name*(filter: PRecentFilter): CSTRING {.
    cdecl, importc: "gtk_recent_filter_get_name", dynlib: lib.}
proc add_mime_type*(filter: PRecentFilter; 
                                      mime_type: CSTRING) {.cdecl, 
    importc: "gtk_recent_filter_add_mime_type", dynlib: lib.}
proc add_pattern*(filter: PRecentFilter; 
                                    pattern: CSTRING) {.cdecl, 
    importc: "gtk_recent_filter_add_pattern", dynlib: lib.}
proc add_pixbuf_formats*(filter: PRecentFilter) {.
    cdecl, importc: "gtk_recent_filter_add_pixbuf_formats", dynlib: lib.}
proc add_application*(filter: PRecentFilter; 
    application: CSTRING) {.cdecl, 
                              importc: "gtk_recent_filter_add_application", 
                              dynlib: lib.}
proc add_group*(filter: PRecentFilter; 
                                  group: CSTRING) {.cdecl, 
    importc: "gtk_recent_filter_add_group", dynlib: lib.}
proc add_age*(filter: PRecentFilter; days: gint) {.
    cdecl, importc: "gtk_recent_filter_add_age", dynlib: lib.}
proc add_custom*(filter: PRecentFilter; 
                                   needed: TRecentFilterFlags; 
                                   func: TRecentFilterFunc; data: gpointer; 
                                   data_destroy: TGDestroyNotify) {.cdecl, 
    importc: "gtk_recent_filter_add_custom", dynlib: lib.}
proc get_needed*(filter: PRecentFilter): TRecentFilterFlags {.
    cdecl, importc: "gtk_recent_filter_get_needed", dynlib: lib.}
proc filter*(filter: PRecentFilter; 
                               filter_info: PRecentFilterInfo): gboolean {.
    cdecl, importc: "gtk_recent_filter_filter", dynlib: lib.}

template TYPE_RECENT_CHOOSER*(): expr = 
  (gtk_recent_chooser_get_type())

template RECENT_CHOOSER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RECENT_CHOOSER, TRecentChooser))

template IS_RECENT_CHOOSER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RECENT_CHOOSER))

template RECENT_CHOOSER_GET_IFACE*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((inst), TYPE_RECENT_CHOOSER, 
                                 TRecentChooserIface))

type 
  TRecentSortType* {.size: sizeof(cint).} = enum 
    RECENT_SORT_NONE = 0, RECENT_SORT_MRU, RECENT_SORT_LRU, 
    RECENT_SORT_CUSTOM
  TRecentSortFunc* = proc (a: PRecentInfo; b: PRecentInfo; 
                             user_data: gpointer): gint {.cdecl.}
template RECENT_CHOOSER_ERROR*(): expr = 
  (gtk_recent_chooser_error_quark())

type 
  TRecentChooserError* {.size: sizeof(cint).} = enum 
    RECENT_CHOOSER_ERROR_NOT_FOUND, RECENT_CHOOSER_ERROR_INVALID_URI
proc recent_chooser_error_quark*(): TGQuark {.cdecl, 
    importc: "gtk_recent_chooser_error_quark", dynlib: lib.}
type 
  PRecentChooserIface* = ptr TRecentChooserIface
  TRecentChooserIface* = object of TGTypeInterface
    set_current_uri*: proc (chooser: PRecentChooser; uri: CSTRING; 
                            error: ptr PGError): gboolean {.cdecl.}
    get_current_uri*: proc (chooser: PRecentChooser): CSTRING {.cdecl.}
    select_uri*: proc (chooser: PRecentChooser; uri: CSTRING; 
                       error: ptr PGError): gboolean {.cdecl.}
    unselect_uri*: proc (chooser: PRecentChooser; uri: CSTRING) {.
        cdecl.}
    select_all*: proc (chooser: PRecentChooser) {.cdecl.}
    unselect_all*: proc (chooser: PRecentChooser) {.cdecl.}
    get_items*: proc (chooser: PRecentChooser): PGList {.cdecl.}
    get_recent_manager*: proc (chooser: PRecentChooser): PRecentManager {.
        cdecl.}
    add_filter*: proc (chooser: PRecentChooser; 
                       filter: PRecentFilter) {.cdecl.}
    remove_filter*: proc (chooser: PRecentChooser; 
                          filter: PRecentFilter) {.cdecl.}
    list_filters*: proc (chooser: PRecentChooser): PGSList {.cdecl.}
    set_sort_func*: proc (chooser: PRecentChooser; 
                          sort_func: TRecentSortFunc; sort_data: gpointer; 
                          data_destroy: TGDestroyNotify) {.cdecl.}
    item_activated*: proc (chooser: PRecentChooser) {.cdecl.}
    selection_changed*: proc (chooser: PRecentChooser) {.cdecl.}

proc recent_chooser_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_chooser_get_type", dynlib: lib.}
proc set_show_private*(chooser: PRecentChooser; 
    show_private: gboolean) {.cdecl, 
                              importc: "gtk_recent_chooser_set_show_private", 
                              dynlib: lib.}
proc get_show_private*(chooser: PRecentChooser): gboolean {.
    cdecl, importc: "gtk_recent_chooser_get_show_private", dynlib: lib.}
proc set_show_not_found*(chooser: PRecentChooser; 
    show_not_found: gboolean) {.cdecl, importc: "gtk_recent_chooser_set_show_not_found", 
                                dynlib: lib.}
proc get_show_not_found*(chooser: PRecentChooser): gboolean {.
    cdecl, importc: "gtk_recent_chooser_get_show_not_found", dynlib: lib.}
proc set_select_multiple*(chooser: PRecentChooser; 
    select_multiple: gboolean) {.cdecl, importc: "gtk_recent_chooser_set_select_multiple", 
                                 dynlib: lib.}
proc get_select_multiple*(chooser: PRecentChooser): gboolean {.
    cdecl, importc: "gtk_recent_chooser_get_select_multiple", dynlib: lib.}
proc set_limit*(chooser: PRecentChooser; limit: gint) {.
    cdecl, importc: "gtk_recent_chooser_set_limit", dynlib: lib.}
proc get_limit*(chooser: PRecentChooser): gint {.
    cdecl, importc: "gtk_recent_chooser_get_limit", dynlib: lib.}
proc set_local_only*(chooser: PRecentChooser; 
    local_only: gboolean) {.cdecl, 
                            importc: "gtk_recent_chooser_set_local_only", 
                            dynlib: lib.}
proc get_local_only*(chooser: PRecentChooser): gboolean {.
    cdecl, importc: "gtk_recent_chooser_get_local_only", dynlib: lib.}
proc set_show_tips*(chooser: PRecentChooser; 
    show_tips: gboolean) {.cdecl, importc: "gtk_recent_chooser_set_show_tips", 
                           dynlib: lib.}
proc get_show_tips*(chooser: PRecentChooser): gboolean {.
    cdecl, importc: "gtk_recent_chooser_get_show_tips", dynlib: lib.}
proc set_show_icons*(chooser: PRecentChooser; 
    show_icons: gboolean) {.cdecl, 
                            importc: "gtk_recent_chooser_set_show_icons", 
                            dynlib: lib.}
proc get_show_icons*(chooser: PRecentChooser): gboolean {.
    cdecl, importc: "gtk_recent_chooser_get_show_icons", dynlib: lib.}
proc set_sort_type*(chooser: PRecentChooser; 
    sort_type: TRecentSortType) {.cdecl, importc: "gtk_recent_chooser_set_sort_type", 
                                    dynlib: lib.}
proc get_sort_type*(chooser: PRecentChooser): TRecentSortType {.
    cdecl, importc: "gtk_recent_chooser_get_sort_type", dynlib: lib.}
proc set_sort_func*(chooser: PRecentChooser; 
    sort_func: TRecentSortFunc; sort_data: gpointer; 
    data_destroy: TGDestroyNotify) {.cdecl, importc: "gtk_recent_chooser_set_sort_func", 
                                    dynlib: lib.}
proc set_current_uri*(chooser: PRecentChooser; 
    uri: CSTRING; error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_recent_chooser_set_current_uri", dynlib: lib.}
proc get_current_uri*(chooser: PRecentChooser): CSTRING {.
    cdecl, importc: "gtk_recent_chooser_get_current_uri", dynlib: lib.}
proc get_current_item*(chooser: PRecentChooser): PRecentInfo {.
    cdecl, importc: "gtk_recent_chooser_get_current_item", dynlib: lib.}
proc select_uri*(chooser: PRecentChooser; 
                                    uri: CSTRING; error: ptr PGError): gboolean {.
    cdecl, importc: "gtk_recent_chooser_select_uri", dynlib: lib.}
proc unselect_uri*(chooser: PRecentChooser; 
                                      uri: CSTRING) {.cdecl, 
    importc: "gtk_recent_chooser_unselect_uri", dynlib: lib.}
proc select_all*(chooser: PRecentChooser) {.cdecl, 
    importc: "gtk_recent_chooser_select_all", dynlib: lib.}
proc unselect_all*(chooser: PRecentChooser) {.cdecl, 
    importc: "gtk_recent_chooser_unselect_all", dynlib: lib.}
proc get_items*(chooser: PRecentChooser): PGList {.
    cdecl, importc: "gtk_recent_chooser_get_items", dynlib: lib.}
proc get_uris*(chooser: PRecentChooser; 
                                  length: Pgsize): ptr CSTRING {.cdecl, 
    importc: "gtk_recent_chooser_get_uris", dynlib: lib.}
proc add_filter*(chooser: PRecentChooser; 
                                    filter: PRecentFilter) {.cdecl, 
    importc: "gtk_recent_chooser_add_filter", dynlib: lib.}
proc remove_filter*(chooser: PRecentChooser; 
    filter: PRecentFilter) {.cdecl, importc: "gtk_recent_chooser_remove_filter", 
                                   dynlib: lib.}
proc list_filters*(chooser: PRecentChooser): PGSList {.
    cdecl, importc: "gtk_recent_chooser_list_filters", dynlib: lib.}
proc set_filter*(chooser: PRecentChooser; 
                                    filter: PRecentFilter) {.cdecl, 
    importc: "gtk_recent_chooser_set_filter", dynlib: lib.}
proc get_filter*(chooser: PRecentChooser): PRecentFilter {.
    cdecl, importc: "gtk_recent_chooser_get_filter", dynlib: lib.}

template TYPE_RECENT_CHOOSER_DIALOG*(): expr = 
  (gtk_recent_chooser_dialog_get_type())

template RECENT_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RECENT_CHOOSER_DIALOG, 
                              TRecentChooserDialog))

template IS_RECENT_CHOOSER_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RECENT_CHOOSER_DIALOG))

template RECENT_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RECENT_CHOOSER_DIALOG, 
                           TRecentChooserDialogClass))

template IS_RECENT_CHOOSER_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RECENT_CHOOSER_DIALOG))

template RECENT_CHOOSER_DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RECENT_CHOOSER_DIALOG, 
                             TRecentChooserDialogClass))

type 
  PRecentChooserDialog* = ptr TRecentChooserDialog
  TRecentChooserDialog* = object of TDialog
    priv110: PRecentChooserDialogPrivate

type 
  PRecentChooserDialogClass* = ptr TRecentChooserDialogClass
  TRecentChooserDialogClass* = object of TDialogClass
    ugtk_reserved1061*: proc () {.cdecl.}
    ugtk_reserved1062*: proc () {.cdecl.}
    ugtk_reserved1063*: proc () {.cdecl.}
    ugtk_reserved1064*: proc () {.cdecl.}

proc recent_chooser_dialog_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_chooser_dialog_get_type", dynlib: lib.}
proc recent_chooser_dialog_new*(title: CSTRING; parent: PWindow; 
                                    first_button_text: CSTRING): PWidget {.
    varargs, cdecl, importc: "gtk_recent_chooser_dialog_new", dynlib: lib.}
proc recent_chooser_dialog_new_for_manager*(title: CSTRING; 
    parent: PWindow; manager: PRecentManager; 
    first_button_text: CSTRING): PWidget {.varargs, cdecl, 
    importc: "gtk_recent_chooser_dialog_new_for_manager", dynlib: lib.}

template TYPE_RECENT_CHOOSER_MENU*(): expr = 
  (gtk_recent_chooser_menu_get_type())

template RECENT_CHOOSER_MENU*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RECENT_CHOOSER_MENU, 
                              TRecentChooserMenu))

template IS_RECENT_CHOOSER_MENU*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RECENT_CHOOSER_MENU))

template RECENT_CHOOSER_MENU_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RECENT_CHOOSER_MENU, 
                           TRecentChooserMenuClass))

template IS_RECENT_CHOOSER_MENU_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RECENT_CHOOSER_MENU))

template RECENT_CHOOSER_MENU_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RECENT_CHOOSER_MENU, 
                             TRecentChooserMenuClass))

type 
  PRecentChooserMenu* = ptr TRecentChooserMenu
  TRecentChooserMenu* = object of TMenu
    priv111: PRecentChooserMenuPrivate

type 
  PRecentChooserMenuClass* = ptr TRecentChooserMenuClass
  TRecentChooserMenuClass* = object of TMenuClass
    gtk_recent1*: proc () {.cdecl.}
    gtk_recent2*: proc () {.cdecl.}
    gtk_recent3*: proc () {.cdecl.}
    gtk_recent4*: proc () {.cdecl.}

proc recent_chooser_menu_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_chooser_menu_get_type", dynlib: lib.}
proc recent_chooser_menu_new*(): PWidget {.cdecl, 
    importc: "gtk_recent_chooser_menu_new", dynlib: lib.}
proc recent_chooser_menu_new_for_manager*(manager: PRecentManager): PWidget {.
    cdecl, importc: "gtk_recent_chooser_menu_new_for_manager", dynlib: lib.}
proc get_show_numbers*(menu: PRecentChooserMenu): gboolean {.
    cdecl, importc: "gtk_recent_chooser_menu_get_show_numbers", dynlib: lib.}
proc set_show_numbers*(menu: PRecentChooserMenu; 
    show_numbers: gboolean) {.cdecl, importc: "gtk_recent_chooser_menu_set_show_numbers", 
                              dynlib: lib.}

template TYPE_RECENT_CHOOSER_WIDGET*(): expr = 
  (gtk_recent_chooser_widget_get_type())

template RECENT_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RECENT_CHOOSER_WIDGET, 
                              TRecentChooserWidget))

template IS_RECENT_CHOOSER_WIDGET*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RECENT_CHOOSER_WIDGET))

template RECENT_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RECENT_CHOOSER_WIDGET, 
                           TRecentChooserWidgetClass))

template IS_RECENT_CHOOSER_WIDGET_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RECENT_CHOOSER_WIDGET))

template RECENT_CHOOSER_WIDGET_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RECENT_CHOOSER_WIDGET, 
                             TRecentChooserWidgetClass))

type 
  PRecentChooserWidget* = ptr TRecentChooserWidget
  TRecentChooserWidget* = object of TBox
    priv112: PRecentChooserWidgetPrivate

type 
  PRecentChooserWidgetClass* = ptr TRecentChooserWidgetClass
  TRecentChooserWidgetClass* = object of TBoxClass
    ugtk_reserved1071*: proc () {.cdecl.}
    ugtk_reserved1072*: proc () {.cdecl.}
    ugtk_reserved1073*: proc () {.cdecl.}
    ugtk_reserved1074*: proc () {.cdecl.}

proc recent_chooser_widget_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_chooser_widget_get_type", dynlib: lib.}
proc recent_chooser_widget_new*(): PWidget {.cdecl, 
    importc: "gtk_recent_chooser_widget_new", dynlib: lib.}
proc recent_chooser_widget_new_for_manager*(manager: PRecentManager): PWidget {.
    cdecl, importc: "gtk_recent_chooser_widget_new_for_manager", dynlib: lib.}

template TYPE_REVEALER*(): expr = 
  (gtk_revealer_get_type())

template REVEALER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_REVEALER, TRevealer))

template REVEALER_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_REVEALER, TRevealerClass))

template IS_REVEALER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_REVEALER))

template IS_REVEALER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_REVEALER))

template REVEALER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_REVEALER, TRevealerClass))

type 
  TRevealerTransitionType* {.size: sizeof(cint).} = enum 
    REVEALER_TRANSITION_TYPE_NONE, REVEALER_TRANSITION_TYPE_CROSSFADE, 
    REVEALER_TRANSITION_TYPE_SLIDE_RIGHT, 
    REVEALER_TRANSITION_TYPE_SLIDE_LEFT, 
    REVEALER_TRANSITION_TYPE_SLIDE_UP, 
    REVEALER_TRANSITION_TYPE_SLIDE_DOWN
type 
  PRevealer* = ptr TRevealer
  TRevealer* = object of TBin

type 
  PRevealerClass* = ptr TRevealerClass
  TRevealerClass* = object of TBinClass

proc revealer_get_type*(): GType {.cdecl, 
    importc: "gtk_revealer_get_type", dynlib: lib.}
proc revealer_new*(): PWidget {.cdecl, importc: "gtk_revealer_new", 
    dynlib: lib.}
proc get_reveal_child*(revealer: PRevealer): gboolean {.
    cdecl, importc: "gtk_revealer_get_reveal_child", dynlib: lib.}
proc set_reveal_child*(revealer: PRevealer; 
                                    reveal_child: gboolean) {.cdecl, 
    importc: "gtk_revealer_set_reveal_child", dynlib: lib.}
proc get_child_revealed*(revealer: PRevealer): gboolean {.
    cdecl, importc: "gtk_revealer_get_child_revealed", dynlib: lib.}
proc get_transition_duration*(revealer: PRevealer): guint {.
    cdecl, importc: "gtk_revealer_get_transition_duration", dynlib: lib.}
proc set_transition_duration*(revealer: PRevealer; 
    duration: guint) {.cdecl, importc: "gtk_revealer_set_transition_duration", 
                       dynlib: lib.}
proc set_transition_type*(revealer: PRevealer; 
    transition: TRevealerTransitionType) {.cdecl, 
    importc: "gtk_revealer_set_transition_type", dynlib: lib.}
proc get_transition_type*(revealer: PRevealer): TRevealerTransitionType {.
    cdecl, importc: "gtk_revealer_get_transition_type", dynlib: lib.}

template TYPE_SCALE*(): expr = 
  (gtk_scale_get_type())

template SCALE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SCALE, TScale))

template SCALE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SCALE, TScaleClass))

template IS_SCALE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SCALE))

template IS_SCALE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SCALE))

template SCALE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SCALE, TScaleClass))

type 
  PScale* = ptr TScale
  TScale* = object of TRange
    priv113: PScalePrivate

type 
  PScaleClass* = ptr TScaleClass
  TScaleClass* = object of TRangeClass
    format_value*: proc (scale: PScale; value: gdouble): CSTRING {.
        cdecl.}
    draw_value*: proc (scale: PScale) {.cdecl.}
    get_layout_offsets*: proc (scale: PScale; x: Pgint; y: Pgint) {.
        cdecl.}
    ugtk_reserved1081*: proc () {.cdecl.}
    ugtk_reserved1082*: proc () {.cdecl.}
    ugtk_reserved1083*: proc () {.cdecl.}
    ugtk_reserved1084*: proc () {.cdecl.}

proc scale_get_type*(): GType {.cdecl, importc: "gtk_scale_get_type", 
                                    dynlib: lib.}
proc scale_new*(orientation: TOrientation; adjustment: PAdjustment): PWidget {.
    cdecl, importc: "gtk_scale_new", dynlib: lib.}
proc scale_new_with_range*(orientation: TOrientation; min: gdouble; 
                               max: gdouble; step: gdouble): PWidget {.
    cdecl, importc: "gtk_scale_new_with_range", dynlib: lib.}
proc set_digits*(scale: PScale; digits: gint) {.cdecl, 
    importc: "gtk_scale_set_digits", dynlib: lib.}
proc get_digits*(scale: PScale): gint {.cdecl, 
    importc: "gtk_scale_get_digits", dynlib: lib.}
proc set_draw_value*(scale: PScale; draw_value: gboolean) {.
    cdecl, importc: "gtk_scale_set_draw_value", dynlib: lib.}
proc get_draw_value*(scale: PScale): gboolean {.cdecl, 
    importc: "gtk_scale_get_draw_value", dynlib: lib.}
proc set_has_origin*(scale: PScale; has_origin: gboolean) {.
    cdecl, importc: "gtk_scale_set_has_origin", dynlib: lib.}
proc get_has_origin*(scale: PScale): gboolean {.cdecl, 
    importc: "gtk_scale_get_has_origin", dynlib: lib.}
proc set_value_pos*(scale: PScale; pos: TPositionType) {.
    cdecl, importc: "gtk_scale_set_value_pos", dynlib: lib.}
proc get_value_pos*(scale: PScale): TPositionType {.cdecl, 
    importc: "gtk_scale_get_value_pos", dynlib: lib.}
proc get_layout*(scale: PScale): Playout {.cdecl, 
    importc: "gtk_scale_get_layout", dynlib: lib.}
proc get_layout_offsets*(scale: PScale; x: Pgint; 
                                   y: Pgint) {.cdecl, 
    importc: "gtk_scale_get_layout_offsets", dynlib: lib.}
proc add_mark*(scale: PScale; value: gdouble; 
                         position: TPositionType; markup: CSTRING) {.
    cdecl, importc: "gtk_scale_add_mark", dynlib: lib.}
proc clear_marks*(scale: PScale) {.cdecl, 
    importc: "gtk_scale_clear_marks", dynlib: lib.}

template TYPE_SCALE_BUTTON*(): expr = 
  (gtk_scale_button_get_type())

template SCALE_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SCALE_BUTTON, TScaleButton))

template SCALE_BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SCALE_BUTTON, TScaleButtonClass))

template IS_SCALE_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SCALE_BUTTON))

template IS_SCALE_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SCALE_BUTTON))

template SCALE_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SCALE_BUTTON, TScaleButtonClass))

type 
  PScaleButton* = ptr TScaleButton
  TScaleButton* = object of TButton
    priv114: PScaleButtonPrivate

type 
  PScaleButtonClass* = ptr TScaleButtonClass
  TScaleButtonClass* = object of TButtonClass
    value_changed*: proc (button: PScaleButton; value: gdouble) {.cdecl.}
    ugtk_reserved1091*: proc () {.cdecl.}
    ugtk_reserved1092*: proc () {.cdecl.}
    ugtk_reserved1093*: proc () {.cdecl.}
    ugtk_reserved1094*: proc () {.cdecl.}

proc scale_button_get_type*(): GType {.cdecl, 
    importc: "gtk_scale_button_get_type", dynlib: lib.}
proc scale_button_new*(size: TIconSize; min: gdouble; max: gdouble; 
                           step: gdouble; icons: ptr CSTRING): PWidget {.
    cdecl, importc: "gtk_scale_button_new", dynlib: lib.}
proc set_icons*(button: PScaleButton; 
                                 icons: ptr CSTRING) {.cdecl, 
    importc: "gtk_scale_button_set_icons", dynlib: lib.}
proc get_value*(button: PScaleButton): gdouble {.cdecl, 
    importc: "gtk_scale_button_get_value", dynlib: lib.}
proc set_value*(button: PScaleButton; value: gdouble) {.
    cdecl, importc: "gtk_scale_button_set_value", dynlib: lib.}
proc get_adjustment*(button: PScaleButton): PAdjustment {.
    cdecl, importc: "gtk_scale_button_get_adjustment", dynlib: lib.}
proc set_adjustment*(button: PScaleButton; 
                                      adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_scale_button_set_adjustment", dynlib: lib.}
proc get_plus_button*(button: PScaleButton): PWidget {.
    cdecl, importc: "gtk_scale_button_get_plus_button", dynlib: lib.}
proc get_minus_button*(button: PScaleButton): PWidget {.
    cdecl, importc: "gtk_scale_button_get_minus_button", dynlib: lib.}
proc get_popup*(button: PScaleButton): PWidget {.
    cdecl, importc: "gtk_scale_button_get_popup", dynlib: lib.}

template TYPE_SCROLLABLE*(): expr = 
  (gtk_scrollable_get_type())

template SCROLLABLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SCROLLABLE, TScrollable))

template IS_SCROLLABLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SCROLLABLE))

template SCROLLABLE_GET_IFACE*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((inst), TYPE_SCROLLABLE, 
                                 TScrollableInterface))

type 
  PScrollableInterface* = ptr TScrollableInterface
  TScrollableInterface* = object of TGTypeInterface

proc scrollable_get_type*(): GType {.cdecl, 
    importc: "gtk_scrollable_get_type", dynlib: lib.}
proc get_hadjustment*(scrollable: PScrollable): PAdjustment {.
    cdecl, importc: "gtk_scrollable_get_hadjustment", dynlib: lib.}
proc set_hadjustment*(scrollable: PScrollable; 
                                     hadjustment: PAdjustment) {.cdecl, 
    importc: "gtk_scrollable_set_hadjustment", dynlib: lib.}
proc get_vadjustment*(scrollable: PScrollable): PAdjustment {.
    cdecl, importc: "gtk_scrollable_get_vadjustment", dynlib: lib.}
proc set_vadjustment*(scrollable: PScrollable; 
                                     vadjustment: PAdjustment) {.cdecl, 
    importc: "gtk_scrollable_set_vadjustment", dynlib: lib.}
proc get_hscroll_policy*(scrollable: PScrollable): TScrollablePolicy {.
    cdecl, importc: "gtk_scrollable_get_hscroll_policy", dynlib: lib.}
proc set_hscroll_policy*(scrollable: PScrollable; 
    policy: TScrollablePolicy) {.cdecl, importc: "gtk_scrollable_set_hscroll_policy", 
                                   dynlib: lib.}
proc get_vscroll_policy*(scrollable: PScrollable): TScrollablePolicy {.
    cdecl, importc: "gtk_scrollable_get_vscroll_policy", dynlib: lib.}
proc set_vscroll_policy*(scrollable: PScrollable; 
    policy: TScrollablePolicy) {.cdecl, importc: "gtk_scrollable_set_vscroll_policy", 
                                   dynlib: lib.}

template TYPE_SCROLLBAR*(): expr = 
  (gtk_scrollbar_get_type())

template SCROLLBAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SCROLLBAR, TScrollbar))

template SCROLLBAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SCROLLBAR, TScrollbarClass))

template IS_SCROLLBAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SCROLLBAR))

template IS_SCROLLBAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SCROLLBAR))

template SCROLLBAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SCROLLBAR, TScrollbarClass))

type 
  PScrollbar* = ptr TScrollbar
  TScrollbar* = object of TRange

type 
  PScrollbarClass* = ptr TScrollbarClass
  TScrollbarClass* = object of TRangeClass
    ugtk_reserved1101*: proc () {.cdecl.}
    ugtk_reserved1102*: proc () {.cdecl.}
    ugtk_reserved1103*: proc () {.cdecl.}
    ugtk_reserved1104*: proc () {.cdecl.}

proc scrollbar_get_type*(): GType {.cdecl, 
    importc: "gtk_scrollbar_get_type", dynlib: lib.}
proc scrollbar_new*(orientation: TOrientation; 
                        adjustment: PAdjustment): PWidget {.cdecl, 
    importc: "gtk_scrollbar_new", dynlib: lib.}

template TYPE_SCROLLED_WINDOW*(): expr = 
  (gtk_scrolled_window_get_type())

template SCROLLED_WINDOW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SCROLLED_WINDOW, 
                              TScrolledWindow))

template SCROLLED_WINDOW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SCROLLED_WINDOW, 
                           TScrolledWindowClass))

template IS_SCROLLED_WINDOW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SCROLLED_WINDOW))

template IS_SCROLLED_WINDOW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SCROLLED_WINDOW))

template SCROLLED_WINDOW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SCROLLED_WINDOW, 
                             TScrolledWindowClass))

type 
  PScrolledWindow* = ptr TScrolledWindow
  TScrolledWindow* = object of TBin
    priv115: PScrolledWindowPrivate

type 
  PScrolledWindowClass* = ptr TScrolledWindowClass
  TScrolledWindowClass* = object of TBinClass
    scrollbar_spacing*: gint
    scroll_child*: proc (scrolled_window: PScrolledWindow; 
                         scroll: TScrollType; horizontal: gboolean): gboolean {.
        cdecl.}
    move_focus_out*: proc (scrolled_window: PScrolledWindow; 
                           direction: TDirectionType) {.cdecl.}
    ugtk_reserved1111*: proc () {.cdecl.}
    ugtk_reserved1112*: proc () {.cdecl.}
    ugtk_reserved1113*: proc () {.cdecl.}
    ugtk_reserved1114*: proc () {.cdecl.}

proc scrolled_window_get_type*(): GType {.cdecl, 
    importc: "gtk_scrolled_window_get_type", dynlib: lib.}
proc scrolled_window_new*(hadjustment: PAdjustment; 
                              vadjustment: PAdjustment): PWidget {.
    cdecl, importc: "gtk_scrolled_window_new", dynlib: lib.}
proc set_hadjustment*(
    scrolled_window: PScrolledWindow; hadjustment: PAdjustment) {.
    cdecl, importc: "gtk_scrolled_window_set_hadjustment", dynlib: lib.}
proc set_vadjustment*(
    scrolled_window: PScrolledWindow; vadjustment: PAdjustment) {.
    cdecl, importc: "gtk_scrolled_window_set_vadjustment", dynlib: lib.}
proc get_hadjustment*(
    scrolled_window: PScrolledWindow): PAdjustment {.cdecl, 
    importc: "gtk_scrolled_window_get_hadjustment", dynlib: lib.}
proc get_vadjustment*(
    scrolled_window: PScrolledWindow): PAdjustment {.cdecl, 
    importc: "gtk_scrolled_window_get_vadjustment", dynlib: lib.}
proc get_hscrollbar*(
    scrolled_window: PScrolledWindow): PWidget {.cdecl, 
    importc: "gtk_scrolled_window_get_hscrollbar", dynlib: lib.}
proc get_vscrollbar*(
    scrolled_window: PScrolledWindow): PWidget {.cdecl, 
    importc: "gtk_scrolled_window_get_vscrollbar", dynlib: lib.}
proc set_policy*(scrolled_window: PScrolledWindow; 
                                     hscrollbar_policy: TPolicyType; 
                                     vscrollbar_policy: TPolicyType) {.
    cdecl, importc: "gtk_scrolled_window_set_policy", dynlib: lib.}
proc get_policy*(scrolled_window: PScrolledWindow; 
                                     hscrollbar_policy: var TPolicyType; 
                                     vscrollbar_policy: var TPolicyType) {.
    cdecl, importc: "gtk_scrolled_window_get_policy", dynlib: lib.}
proc set_placement*(
    scrolled_window: PScrolledWindow; window_placement: TCornerType) {.
    cdecl, importc: "gtk_scrolled_window_set_placement", dynlib: lib.}
proc unset_placement*(
    scrolled_window: PScrolledWindow) {.cdecl, 
    importc: "gtk_scrolled_window_unset_placement", dynlib: lib.}
proc get_placement*(scrolled_window: PScrolledWindow): TCornerType {.
    cdecl, importc: "gtk_scrolled_window_get_placement", dynlib: lib.}
proc set_shadow_type*(
    scrolled_window: PScrolledWindow; typ: TShadowType) {.cdecl, 
    importc: "gtk_scrolled_window_set_shadow_type", dynlib: lib.}
proc get_shadow_type*(
    scrolled_window: PScrolledWindow): TShadowType {.cdecl, 
    importc: "gtk_scrolled_window_get_shadow_type", dynlib: lib.}
proc add_with_viewport*(
    scrolled_window: PScrolledWindow; child: PWidget) {.cdecl, 
    importc: "gtk_scrolled_window_add_with_viewport", dynlib: lib.}
proc get_min_content_width*(
    scrolled_window: PScrolledWindow): gint {.cdecl, 
    importc: "gtk_scrolled_window_get_min_content_width", dynlib: lib.}
proc set_min_content_width*(
    scrolled_window: PScrolledWindow; width: gint) {.cdecl, 
    importc: "gtk_scrolled_window_set_min_content_width", dynlib: lib.}
proc get_min_content_height*(
    scrolled_window: PScrolledWindow): gint {.cdecl, 
    importc: "gtk_scrolled_window_get_min_content_height", dynlib: lib.}
proc set_min_content_height*(
    scrolled_window: PScrolledWindow; height: gint) {.cdecl, 
    importc: "gtk_scrolled_window_set_min_content_height", dynlib: lib.}
proc set_kinetic_scrolling*(
    scrolled_window: PScrolledWindow; kinetic_scrolling: gboolean) {.
    cdecl, importc: "gtk_scrolled_window_set_kinetic_scrolling", dynlib: lib.}
proc get_kinetic_scrolling*(
    scrolled_window: PScrolledWindow): gboolean {.cdecl, 
    importc: "gtk_scrolled_window_get_kinetic_scrolling", dynlib: lib.}
proc set_capture_button_press*(
    scrolled_window: PScrolledWindow; capture_button_press: gboolean) {.
    cdecl, importc: "gtk_scrolled_window_set_capture_button_press", 
    dynlib: lib.}
proc get_capture_button_press*(
    scrolled_window: PScrolledWindow): gboolean {.cdecl, 
    importc: "gtk_scrolled_window_get_capture_button_press", dynlib: lib.}
proc underscore_gtk_scrolled_window_get_scrollbar_spacing*(
    scrolled_window: PScrolledWindow): gint {.cdecl, 
    importc: "_gtk_scrolled_window_get_scrollbar_spacing", dynlib: lib.}

template TYPE_SEARCH_BAR*(): expr = 
  (gtk_search_bar_get_type())

template SEARCH_BAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SEARCH_BAR, TSearchBar))

template SEARCH_BAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SEARCH_BAR, TSearchBarClass))

template IS_SEARCH_BAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SEARCH_BAR))

template IS_SEARCH_BAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SEARCH_BAR))

template SEARCH_BAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SEARCH_BAR, TSearchBarClass))

type 
  PSearchBar* = ptr TSearchBar
  TSearchBar* = object of TBin

type 
  PSearchBarClass* = ptr TSearchBarClass
  TSearchBarClass* = object of TBinClass
    ugtk_reserved1121*: proc () {.cdecl.}
    ugtk_reserved1122*: proc () {.cdecl.}
    ugtk_reserved1123*: proc () {.cdecl.}
    ugtk_reserved1124*: proc () {.cdecl.}

proc search_bar_get_type*(): GType {.cdecl, 
    importc: "gtk_search_bar_get_type", dynlib: lib.}
proc search_bar_new*(): PWidget {.cdecl, 
    importc: "gtk_search_bar_new", dynlib: lib.}
proc connect_entry*(bar: PSearchBar; entry: PEntry) {.
    cdecl, importc: "gtk_search_bar_connect_entry", dynlib: lib.}
proc get_search_mode*(bar: PSearchBar): gboolean {.cdecl, 
    importc: "gtk_search_bar_get_search_mode", dynlib: lib.}
proc set_search_mode*(bar: PSearchBar; 
                                     search_mode: gboolean) {.cdecl, 
    importc: "gtk_search_bar_set_search_mode", dynlib: lib.}
proc get_show_close_button*(bar: PSearchBar): gboolean {.
    cdecl, importc: "gtk_search_bar_get_show_close_button", dynlib: lib.}
proc set_show_close_button*(bar: PSearchBar; 
    visible: gboolean) {.cdecl, 
                         importc: "gtk_search_bar_set_show_close_button", 
                         dynlib: lib.}
proc handle_event*(bar: PSearchBar; event: PEvent): gboolean {.
    cdecl, importc: "gtk_search_bar_handle_event", dynlib: lib.}

template TYPE_SEARCH_ENTRY*(): expr = 
  (gtk_search_entry_get_type())

template SEARCH_ENTRY_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SEARCH_ENTRY, TSearchEntry))

template SEARCH_ENTRY_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SEARCH_ENTRY, TSearchEntryClass))

template IS_SEARCH_ENTRY*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SEARCH_ENTRY))

template IS_SEARCH_ENTRY_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SEARCH_ENTRY))

template SEARCH_ENTRY_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SEARCH_ENTRY, TSearchEntryClass))

type 
  PSearchEntry* = ptr TSearchEntry
  TSearchEntry* = object of TEntry

type 
  PSearchEntryClass* = ptr TSearchEntryClass
  TSearchEntryClass* = object of TEntryClass
    search_changed*: proc (entry: PSearchEntry) {.cdecl.}
    ugtk_reserved1131*: proc () {.cdecl.}
    ugtk_reserved1132*: proc () {.cdecl.}
    ugtk_reserved1133*: proc () {.cdecl.}

proc search_entry_get_type*(): GType {.cdecl, 
    importc: "gtk_search_entry_get_type", dynlib: lib.}
proc search_entry_new*(): PWidget {.cdecl, 
    importc: "gtk_search_entry_new", dynlib: lib.}

template TYPE_SEPARATOR*(): expr = 
  (gtk_separator_get_type())

template SEPARATOR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SEPARATOR, TSeparator))

template SEPARATOR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SEPARATOR, TSeparatorClass))

template IS_SEPARATOR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SEPARATOR))

template IS_SEPARATOR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SEPARATOR))

template SEPARATOR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SEPARATOR, TSeparatorClass))

type 
  PSeparator* = ptr TSeparator
  TSeparator* = object of TWidget
    priv116: PSeparatorPrivate

type 
  PSeparatorClass* = ptr TSeparatorClass
  TSeparatorClass* = object of TWidgetClass
    ugtk_reserved1141*: proc () {.cdecl.}
    ugtk_reserved1142*: proc () {.cdecl.}
    ugtk_reserved1143*: proc () {.cdecl.}
    ugtk_reserved1144*: proc () {.cdecl.}

proc separator_get_type*(): GType {.cdecl, 
    importc: "gtk_separator_get_type", dynlib: lib.}
proc separator_new*(orientation: TOrientation): PWidget {.cdecl, 
    importc: "gtk_separator_new", dynlib: lib.}

template TYPE_SEPARATOR_MENU_ITEM*(): expr = 
  (gtk_separator_menu_item_get_type())

template SEPARATOR_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SEPARATOR_MENU_ITEM, 
                              TSeparatorMenuItem))

template SEPARATOR_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SEPARATOR_MENU_ITEM, 
                           TSeparatorMenuItemClass))

template IS_SEPARATOR_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SEPARATOR_MENU_ITEM))

template IS_SEPARATOR_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SEPARATOR_MENU_ITEM))

template SEPARATOR_MENU_ITEM_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SEPARATOR_MENU_ITEM, 
                             TSeparatorMenuItemClass))

type 
  PSeparatorMenuItem* = ptr TSeparatorMenuItem
  TSeparatorMenuItem* = object of TMenuItem

type 
  PSeparatorMenuItemClass* = ptr TSeparatorMenuItemClass
  TSeparatorMenuItemClass* = object of TMenuItemClass
    ugtk_reserved1151*: proc () {.cdecl.}
    ugtk_reserved1152*: proc () {.cdecl.}
    ugtk_reserved1153*: proc () {.cdecl.}
    ugtk_reserved1154*: proc () {.cdecl.}

proc separator_menu_item_get_type*(): GType {.cdecl, 
    importc: "gtk_separator_menu_item_get_type", dynlib: lib.}
proc separator_menu_item_new*(): PWidget {.cdecl, 
    importc: "gtk_separator_menu_item_new", dynlib: lib.}

template TYPE_SEPARATOR_TOOL_ITEM*(): expr = 
  (gtk_separator_tool_item_get_type())

template SEPARATOR_TOOL_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SEPARATOR_TOOL_ITEM, 
                              TSeparatorToolItem))

template SEPARATOR_TOOL_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SEPARATOR_TOOL_ITEM, 
                           TSeparatorToolItemClass))

template IS_SEPARATOR_TOOL_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SEPARATOR_TOOL_ITEM))

template IS_SEPARATOR_TOOL_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SEPARATOR_TOOL_ITEM))

template SEPARATOR_TOOL_ITEM_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SEPARATOR_TOOL_ITEM, 
                             TSeparatorToolItemClass))

type 
  PSeparatorToolItem* = ptr TSeparatorToolItem
  TSeparatorToolItem* = object of TToolItem
    priv117: PSeparatorToolItemPrivate

type 
  PSeparatorToolItemClass* = ptr TSeparatorToolItemClass
  TSeparatorToolItemClass* = object of TToolItemClass
    ugtk_reserved1161*: proc () {.cdecl.}
    ugtk_reserved1162*: proc () {.cdecl.}
    ugtk_reserved1163*: proc () {.cdecl.}
    ugtk_reserved1164*: proc () {.cdecl.}

proc separator_tool_item_get_type*(): GType {.cdecl, 
    importc: "gtk_separator_tool_item_get_type", dynlib: lib.}
proc separator_tool_item_new*(): PToolItem {.cdecl, 
    importc: "gtk_separator_tool_item_new", dynlib: lib.}
proc get_draw*(item: PSeparatorToolItem): gboolean {.
    cdecl, importc: "gtk_separator_tool_item_get_draw", dynlib: lib.}
proc set_draw*(item: PSeparatorToolItem; 
    draw: gboolean) {.cdecl, importc: "gtk_separator_tool_item_set_draw", 
                      dynlib: lib.}

template TYPE_SETTINGS*(): expr = 
  (gtk_settings_get_type())

template SETTINGS_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SETTINGS, TSettings))

template SETTINGS_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SETTINGS, TSettingsClass))

template IS_SETTINGS*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SETTINGS))

template IS_SETTINGS_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SETTINGS))

template SETTINGS_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SETTINGS, TSettingsClass))


type 
  PSettingsClass* = ptr TSettingsClass
  TSettingsClass* = object of TGObjectClass
    ugtk_reserved1171*: proc () {.cdecl.}
    ugtk_reserved1172*: proc () {.cdecl.}
    ugtk_reserved1173*: proc () {.cdecl.}
    ugtk_reserved1174*: proc () {.cdecl.}

type 
  PSettingsValue* = ptr TSettingsValue
  TSettingsValue*{.final, pure.} = object 
    origin*: CSTRING
    value*: TGValue

proc settings_get_type*(): GType {.cdecl, 
    importc: "gtk_settings_get_type", dynlib: lib.}
when not(defined(GDK_MULTIHEAD_SAFE)): 
  proc settings_get_default*(): PSettings {.cdecl, 
      importc: "gtk_settings_get_default", dynlib: lib.}
proc settings_get_for_screen*(screen: PGdkScreen): PSettings {.
    cdecl, importc: "gtk_settings_get_for_screen", dynlib: lib.}
proc settings_install_property*(pspec: PGParamSpec) {.cdecl, 
    importc: "gtk_settings_install_property", dynlib: lib.}
proc settings_install_property_parser*(pspec: PGParamSpec; 
    parser: TRcPropertyParser) {.cdecl, importc: "gtk_settings_install_property_parser", 
                                   dynlib: lib.}
proc rc_property_parse_color*(pspec: PGParamSpec; gstring: PGString; 
                                  property_value: PGValue): gboolean {.
    cdecl, importc: "gtk_rc_property_parse_color", dynlib: lib.}
proc rc_property_parse_enum*(pspec: PGParamSpec; gstring: PGString; 
                                 property_value: PGValue): gboolean {.
    cdecl, importc: "gtk_rc_property_parse_enum", dynlib: lib.}
proc rc_property_parse_flags*(pspec: PGParamSpec; gstring: PGString; 
                                  property_value: PGValue): gboolean {.
    cdecl, importc: "gtk_rc_property_parse_flags", dynlib: lib.}
proc rc_property_parse_requisition*(pspec: PGParamSpec; 
    gstring: PGString; property_value: PGValue): gboolean {.cdecl, 
    importc: "gtk_rc_property_parse_requisition", dynlib: lib.}
proc rc_property_parse_border*(pspec: PGParamSpec; 
                                   gstring: PGString; 
                                   property_value: PGValue): gboolean {.
    cdecl, importc: "gtk_rc_property_parse_border", dynlib: lib.}
proc set_property_value*(settings: PSettings; 
                                      name: CSTRING; 
                                      svalue: PSettingsValue) {.cdecl, 
    importc: "gtk_settings_set_property_value", dynlib: lib.}
proc set_string_property*(settings: PSettings; 
    name: CSTRING; v_string: CSTRING; origin: CSTRING) {.cdecl, 
    importc: "gtk_settings_set_string_property", dynlib: lib.}
proc set_long_property*(settings: PSettings; 
                                     name: CSTRING; v_long: glong; 
                                     origin: CSTRING) {.cdecl, 
    importc: "gtk_settings_set_long_property", dynlib: lib.}
proc set_double_property*(settings: PSettings; 
    name: CSTRING; v_double: gdouble; origin: CSTRING) {.cdecl, 
    importc: "gtk_settings_set_double_property", dynlib: lib.}

proc show_uri*(screen: PGdkScreen; uri: CSTRING; timestamp: guint32; 
                   error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_show_uri", dynlib: lib.}

type 
  PRequestedSize* = ptr TRequestedSize
  TRequestedSize*{.final, pure.} = object 
    data*: gpointer
    minimum_size*: gint
    natural_size*: gint

proc distribute_natural_allocation*(extra_space: gint; 
    n_requested_sizes: guint; sizes: PRequestedSize): gint {.cdecl, 
    importc: "gtk_distribute_natural_allocation", dynlib: lib.}

template TYPE_SPIN_BUTTON*(): expr = 
  (gtk_spin_button_get_type())

template SPIN_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SPIN_BUTTON, TSpinButton))

template SPIN_BUTTON_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SPIN_BUTTON, TSpinButtonClass))

template IS_SPIN_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SPIN_BUTTON))

template IS_SPIN_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SPIN_BUTTON))

template SPIN_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SPIN_BUTTON, TSpinButtonClass))

const 
  INPUT_ERROR* = - 1
type 
  TSpinButtonUpdatePolicy* {.size: sizeof(cint).} = enum 
    UPDATE_ALWAYS, UPDATE_IF_VALID
type 
  TSpinType* {.size: sizeof(cint).} = enum 
    SPIN_STEP_FORWARD, SPIN_STEP_BACKWARD, SPIN_PAGE_FORWARD, 
    SPIN_PAGE_BACKWARD, SPIN_HOME, SPIN_END, SPIN_USER_DEFINED
type 
  PSpinButton* = ptr TSpinButton
  TSpinButton* = object of TEntry
    priv118: PSpinButtonPrivate

type 
  PSpinButtonClass* = ptr TSpinButtonClass
  TSpinButtonClass* = object of TEntryClass
    input*: proc (spin_button: PSpinButton; new_value: Pgdouble): gint {.
        cdecl.}
    output*: proc (spin_button: PSpinButton): gint {.cdecl.}
    value_changed*: proc (spin_button: PSpinButton) {.cdecl.}
    change_value*: proc (spin_button: PSpinButton; scroll: TScrollType) {.
        cdecl.}
    wrapped*: proc (spin_button: PSpinButton) {.cdecl.}
    ugtk_reserved1181*: proc () {.cdecl.}
    ugtk_reserved1182*: proc () {.cdecl.}
    ugtk_reserved1183*: proc () {.cdecl.}
    ugtk_reserved1184*: proc () {.cdecl.}

proc spin_button_get_type*(): GType {.cdecl, 
    importc: "gtk_spin_button_get_type", dynlib: lib.}
proc configure*(spin_button: PSpinButton; 
                                adjustment: PAdjustment; 
                                climb_rate: gdouble; digits: guint) {.cdecl, 
    importc: "gtk_spin_button_configure", dynlib: lib.}
proc spin_button_new*(adjustment: PAdjustment; climb_rate: gdouble; 
                          digits: guint): PWidget {.cdecl, 
    importc: "gtk_spin_button_new", dynlib: lib.}
proc spin_button_new_with_range*(min: gdouble; max: gdouble; step: gdouble): PWidget {.
    cdecl, importc: "gtk_spin_button_new_with_range", dynlib: lib.}
proc set_adjustment*(spin_button: PSpinButton; 
                                     adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_spin_button_set_adjustment", dynlib: lib.}
proc get_adjustment*(spin_button: PSpinButton): PAdjustment {.
    cdecl, importc: "gtk_spin_button_get_adjustment", dynlib: lib.}
proc set_digits*(spin_button: PSpinButton; digits: guint) {.
    cdecl, importc: "gtk_spin_button_set_digits", dynlib: lib.}
proc get_digits*(spin_button: PSpinButton): guint {.
    cdecl, importc: "gtk_spin_button_get_digits", dynlib: lib.}
proc set_increments*(spin_button: PSpinButton; 
                                     step: gdouble; page: gdouble) {.cdecl, 
    importc: "gtk_spin_button_set_increments", dynlib: lib.}
proc get_increments*(spin_button: PSpinButton; 
                                     step: Pgdouble; page: Pgdouble) {.
    cdecl, importc: "gtk_spin_button_get_increments", dynlib: lib.}
proc set_range*(spin_button: PSpinButton; min: gdouble; 
                                max: gdouble) {.cdecl, 
    importc: "gtk_spin_button_set_range", dynlib: lib.}
proc get_range*(spin_button: PSpinButton; 
                                min: Pgdouble; max: Pgdouble) {.cdecl, 
    importc: "gtk_spin_button_get_range", dynlib: lib.}
proc get_value*(spin_button: PSpinButton): gdouble {.
    cdecl, importc: "gtk_spin_button_get_value", dynlib: lib.}
proc get_value_as_int*(spin_button: PSpinButton): gint {.
    cdecl, importc: "gtk_spin_button_get_value_as_int", dynlib: lib.}
proc set_value*(spin_button: PSpinButton; value: gdouble) {.
    cdecl, importc: "gtk_spin_button_set_value", dynlib: lib.}
proc set_update_policy*(spin_button: PSpinButton; 
    policy: TSpinButtonUpdatePolicy) {.cdecl, 
    importc: "gtk_spin_button_set_update_policy", dynlib: lib.}
proc get_update_policy*(spin_button: PSpinButton): TSpinButtonUpdatePolicy {.
    cdecl, importc: "gtk_spin_button_get_update_policy", dynlib: lib.}
proc set_numeric*(spin_button: PSpinButton; 
                                  numeric: gboolean) {.cdecl, 
    importc: "gtk_spin_button_set_numeric", dynlib: lib.}
proc get_numeric*(spin_button: PSpinButton): gboolean {.
    cdecl, importc: "gtk_spin_button_get_numeric", dynlib: lib.}
proc spin*(spin_button: PSpinButton; 
                           direction: TSpinType; increment: gdouble) {.
    cdecl, importc: "gtk_spin_button_spin", dynlib: lib.}
proc set_wrap*(spin_button: PSpinButton; wrap: gboolean) {.
    cdecl, importc: "gtk_spin_button_set_wrap", dynlib: lib.}
proc get_wrap*(spin_button: PSpinButton): gboolean {.
    cdecl, importc: "gtk_spin_button_get_wrap", dynlib: lib.}
proc set_snap_to_ticks*(spin_button: PSpinButton; 
    snap_to_ticks: gboolean) {.cdecl, 
                               importc: "gtk_spin_button_set_snap_to_ticks", 
                               dynlib: lib.}
proc get_snap_to_ticks*(spin_button: PSpinButton): gboolean {.
    cdecl, importc: "gtk_spin_button_get_snap_to_ticks", dynlib: lib.}
proc update*(spin_button: PSpinButton) {.cdecl, 
    importc: "gtk_spin_button_update", dynlib: lib.}
proc underscore_gtk_spin_button_get_panels*(spin_button: PSpinButton; 
                                  down_panel: ptr PGdkWindow; 
                                  up_panel: ptr PGdkWindow) {.cdecl, 
    importc: "_gtk_spin_button_get_panels", dynlib: lib.}

template TYPE_SPINNER*(): expr = 
  (gtk_spinner_get_type())

template SPINNER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SPINNER, TSpinner))

template SPINNER_CLASS_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((obj), TYPE_SPINNER, TSpinnerClass))

template IS_SPINNER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SPINNER))

template IS_SPINNER_CLASS*(obj: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((obj), TYPE_SPINNER))

template SPINNER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SPINNER, TSpinnerClass))

type 
  PSpinner* = ptr TSpinner
  TSpinner* = object of TWidget
    priv119: PSpinnerPrivate

type 
  PSpinnerClass* = ptr TSpinnerClass
  TSpinnerClass* = object of TWidgetClass
    ugtk_reserved1191*: proc () {.cdecl.}
    ugtk_reserved1192*: proc () {.cdecl.}
    ugtk_reserved1193*: proc () {.cdecl.}
    ugtk_reserved1194*: proc () {.cdecl.}

proc spinner_get_type*(): GType {.cdecl, importc: "gtk_spinner_get_type", 
                                      dynlib: lib.}
proc spinner_new*(): PWidget {.cdecl, importc: "gtk_spinner_new", 
    dynlib: lib.}
proc start*(spinner: PSpinner) {.cdecl, 
    importc: "gtk_spinner_start", dynlib: lib.}
proc stop*(spinner: PSpinner) {.cdecl, 
    importc: "gtk_spinner_stop", dynlib: lib.}

template TYPE_STACK*(): expr = 
  (gtk_stack_get_type())

template STACK_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_STACK, TStack))

template STACK_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_STACK, TStackClass))

template IS_STACK*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_STACK))

template IS_STACK_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_STACK))

template STACK_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_STACK, TStackClass))

type 
  TStackTransitionType* {.size: sizeof(cint).} = enum 
    STACK_TRANSITION_TYPE_NONE, STACK_TRANSITION_TYPE_CROSSFADE, 
    STACK_TRANSITION_TYPE_SLIDE_RIGHT, 
    STACK_TRANSITION_TYPE_SLIDE_LEFT, STACK_TRANSITION_TYPE_SLIDE_UP, 
    STACK_TRANSITION_TYPE_SLIDE_DOWN, 
    STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT, 
    STACK_TRANSITION_TYPE_SLIDE_UP_DOWN, 
    STACK_TRANSITION_TYPE_OVER_UP, STACK_TRANSITION_TYPE_OVER_DOWN, 
    STACK_TRANSITION_TYPE_OVER_LEFT, STACK_TRANSITION_TYPE_OVER_RIGHT, 
    STACK_TRANSITION_TYPE_UNDER_UP, STACK_TRANSITION_TYPE_UNDER_DOWN, 
    STACK_TRANSITION_TYPE_UNDER_LEFT, 
    STACK_TRANSITION_TYPE_UNDER_RIGHT, 
    STACK_TRANSITION_TYPE_OVER_UP_DOWN
type 
  PStack* = ptr TStack
  TStack* = object of TContainer

type 
  PStackClass* = ptr TStackClass
  TStackClass* = object of TContainerClass

proc stack_get_type*(): GType {.cdecl, importc: "gtk_stack_get_type", 
                                    dynlib: lib.}
proc stack_new*(): PWidget {.cdecl, importc: "gtk_stack_new", 
    dynlib: lib.}
proc add_named*(stack: PStack; child: PWidget; 
                          name: CSTRING) {.cdecl, 
    importc: "gtk_stack_add_named", dynlib: lib.}
proc add_titled*(stack: PStack; child: PWidget; 
                           name: CSTRING; title: CSTRING) {.cdecl, 
    importc: "gtk_stack_add_titled", dynlib: lib.}
proc get_child_by_name*(stack: PStack; name: CSTRING): PWidget {.
    cdecl, importc: "gtk_stack_get_child_by_name", dynlib: lib.}
proc set_visible_child*(stack: PStack; child: PWidget) {.
    cdecl, importc: "gtk_stack_set_visible_child", dynlib: lib.}
proc get_visible_child*(stack: PStack): PWidget {.cdecl, 
    importc: "gtk_stack_get_visible_child", dynlib: lib.}
proc set_visible_child_name*(stack: PStack; name: CSTRING) {.
    cdecl, importc: "gtk_stack_set_visible_child_name", dynlib: lib.}
proc get_visible_child_name*(stack: PStack): CSTRING {.
    cdecl, importc: "gtk_stack_get_visible_child_name", dynlib: lib.}
proc set_visible_child_full*(stack: PStack; name: CSTRING; 
    transition: TStackTransitionType) {.cdecl, 
    importc: "gtk_stack_set_visible_child_full", dynlib: lib.}
proc set_homogeneous*(stack: PStack; homogeneous: gboolean) {.
    cdecl, importc: "gtk_stack_set_homogeneous", dynlib: lib.}
proc get_homogeneous*(stack: PStack): gboolean {.cdecl, 
    importc: "gtk_stack_get_homogeneous", dynlib: lib.}
proc set_transition_duration*(stack: PStack; duration: guint) {.
    cdecl, importc: "gtk_stack_set_transition_duration", dynlib: lib.}
proc get_transition_duration*(stack: PStack): guint {.cdecl, 
    importc: "gtk_stack_get_transition_duration", dynlib: lib.}
proc set_transition_type*(stack: PStack; 
                                    transition: TStackTransitionType) {.
    cdecl, importc: "gtk_stack_set_transition_type", dynlib: lib.}
proc get_transition_type*(stack: PStack): TStackTransitionType {.
    cdecl, importc: "gtk_stack_get_transition_type", dynlib: lib.}
proc get_transition_running*(stack: PStack): gboolean {.cdecl, 
    importc: "gtk_stack_get_transition_running", dynlib: lib.}

template TYPE_STACK_SWITCHER*(): expr = 
  (gtk_stack_switcher_get_type())

template STACK_SWITCHER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_STACK_SWITCHER, TStackSwitcher))

template STACK_SWITCHER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_STACK_SWITCHER, 
                           TStackSwitcherClass))

template IS_STACK_SWITCHER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_STACK_SWITCHER))

template IS_STACK_SWITCHER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_STACK_SWITCHER))

template STACK_SWITCHER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_STACK_SWITCHER, 
                             TStackSwitcherClass))

type 
  PStackSwitcher* = ptr TStackSwitcher
  TStackSwitcher* = object of TBox

type 
  PStackSwitcherClass* = ptr TStackSwitcherClass
  TStackSwitcherClass* = object of TBoxClass
    ugtk_reserved1201*: proc () {.cdecl.}
    ugtk_reserved1202*: proc () {.cdecl.}
    ugtk_reserved1203*: proc () {.cdecl.}
    ugtk_reserved1204*: proc () {.cdecl.}

proc stack_switcher_get_type*(): GType {.cdecl, 
    importc: "gtk_stack_switcher_get_type", dynlib: lib.}
proc stack_switcher_new*(): PWidget {.cdecl, 
    importc: "gtk_stack_switcher_new", dynlib: lib.}
proc set_stack*(switcher: PStackSwitcher; 
                                   stack: PStack) {.cdecl, 
    importc: "gtk_stack_switcher_set_stack", dynlib: lib.}
proc get_stack*(switcher: PStackSwitcher): PStack {.
    cdecl, importc: "gtk_stack_switcher_get_stack", dynlib: lib.}

template TYPE_STATUSBAR*(): expr = 
  (gtk_statusbar_get_type())

template STATUSBAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_STATUSBAR, TStatusbar))

template STATUSBAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_STATUSBAR, TStatusbarClass))

template IS_STATUSBAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_STATUSBAR))

template IS_STATUSBAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_STATUSBAR))

template STATUSBAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_STATUSBAR, TStatusbarClass))

type 
  PStatusbar* = ptr TStatusbar
  TStatusbar* = object of TBox
    priv120: PStatusbarPrivate

type 
  PStatusbarClass* = ptr TStatusbarClass
  TStatusbarClass* = object of TBoxClass
    reserved: gpointer
    text_pushed*: proc (statusbar: PStatusbar; context_id: guint; 
                        text: CSTRING) {.cdecl.}
    text_popped*: proc (statusbar: PStatusbar; context_id: guint; 
                        text: CSTRING) {.cdecl.}
    ugtk_reserved1211*: proc () {.cdecl.}
    ugtk_reserved1212*: proc () {.cdecl.}
    ugtk_reserved1213*: proc () {.cdecl.}
    ugtk_reserved1214*: proc () {.cdecl.}

proc statusbar_get_type*(): GType {.cdecl, 
    importc: "gtk_statusbar_get_type", dynlib: lib.}
proc statusbar_new*(): PWidget {.cdecl, 
    importc: "gtk_statusbar_new", dynlib: lib.}
proc get_context_id*(statusbar: PStatusbar; 
                                   context_description: CSTRING): guint {.
    cdecl, importc: "gtk_statusbar_get_context_id", dynlib: lib.}
proc push*(statusbar: PStatusbar; context_id: guint; 
                         text: CSTRING): guint {.cdecl, 
    importc: "gtk_statusbar_push", dynlib: lib.}
proc pop*(statusbar: PStatusbar; context_id: guint) {.
    cdecl, importc: "gtk_statusbar_pop", dynlib: lib.}
proc remove*(statusbar: PStatusbar; context_id: guint; 
                           message_id: guint) {.cdecl, 
    importc: "gtk_statusbar_remove", dynlib: lib.}
proc remove_all*(statusbar: PStatusbar; context_id: guint) {.
    cdecl, importc: "gtk_statusbar_remove_all", dynlib: lib.}
proc get_message_area*(statusbar: PStatusbar): PWidget {.
    cdecl, importc: "gtk_statusbar_get_message_area", dynlib: lib.}

template TYPE_STATUS_ICON*(): expr = 
  (gtk_status_icon_get_type())

template STATUS_ICON_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_STATUS_ICON, TStatusIcon))

template STATUS_ICON_CLASS_TEMPLATE*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((k), TYPE_STATUS_ICON, TStatusIconClass))

template IS_STATUS_ICON*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_STATUS_ICON))

template IS_STATUS_ICON_CLASS*(k: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((k), TYPE_STATUS_ICON))

template STATUS_ICON_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_STATUS_ICON, TStatusIconClass))

type 
  PStatusIcon* = ptr TStatusIcon
  TStatusIcon* = object of TGObject
    priv121: PStatusIconPrivate

type 
  PStatusIconClass* = ptr TStatusIconClass
  TStatusIconClass* = object of TGObjectClass
    activate*: proc (status_icon: PStatusIcon) {.cdecl.}
    popup_menu*: proc (status_icon: PStatusIcon; button: guint; 
                       activate_time: guint32) {.cdecl.}
    size_changed*: proc (status_icon: PStatusIcon; size: gint): gboolean {.
        cdecl.}
    button_press_event*: proc (status_icon: PStatusIcon; 
                               event: PEventButton): gboolean {.cdecl.}
    button_release_event*: proc (status_icon: PStatusIcon; 
                                 event: PEventButton): gboolean {.cdecl.}
    scroll_event*: proc (status_icon: PStatusIcon; 
                         event: PEventScroll): gboolean {.cdecl.}
    query_tooltip*: proc (status_icon: PStatusIcon; x: gint; y: gint; 
                          keyboard_mode: gboolean; tooltip: PTooltip): gboolean {.
        cdecl.}
    uugtk_reserved1: gpointer
    uugtk_reserved2: gpointer
    uugtk_reserved3: gpointer
    uugtk_reserved4: gpointer

proc status_icon_get_type*(): GType {.cdecl, 
    importc: "gtk_status_icon_get_type", dynlib: lib.}
proc status_icon_new*(): PStatusIcon {.cdecl, 
    importc: "gtk_status_icon_new", dynlib: lib.}
proc status_icon_new_from_pixbuf*(pixbuf: PPixbuf): PStatusIcon {.
    cdecl, importc: "gtk_status_icon_new_from_pixbuf", dynlib: lib.}
proc status_icon_new_from_file*(filename: CSTRING): PStatusIcon {.
    cdecl, importc: "gtk_status_icon_new_from_file", dynlib: lib.}
proc status_icon_new_from_stock*(stock_id: CSTRING): PStatusIcon {.
    cdecl, importc: "gtk_status_icon_new_from_stock", dynlib: lib.}
proc status_icon_new_from_icon_name*(icon_name: CSTRING): PStatusIcon {.
    cdecl, importc: "gtk_status_icon_new_from_icon_name", dynlib: lib.}
proc status_icon_new_from_gicon*(icon: PGIcon): PStatusIcon {.
    cdecl, importc: "gtk_status_icon_new_from_gicon", dynlib: lib.}
proc set_from_pixbuf*(status_icon: PStatusIcon; 
                                      pixbuf: PPixbuf) {.cdecl, 
    importc: "gtk_status_icon_set_from_pixbuf", dynlib: lib.}
proc set_from_file*(status_icon: PStatusIcon; 
                                    filename: CSTRING) {.cdecl, 
    importc: "gtk_status_icon_set_from_file", dynlib: lib.}
proc set_from_stock*(status_icon: PStatusIcon; 
                                     stock_id: CSTRING) {.cdecl, 
    importc: "gtk_status_icon_set_from_stock", dynlib: lib.}
proc set_from_icon_name*(status_icon: PStatusIcon; 
    icon_name: CSTRING) {.cdecl, 
                            importc: "gtk_status_icon_set_from_icon_name", 
                            dynlib: lib.}
proc set_from_gicon*(status_icon: PStatusIcon; 
                                     icon: PGIcon) {.cdecl, 
    importc: "gtk_status_icon_set_from_gicon", dynlib: lib.}
proc get_storage_type*(status_icon: PStatusIcon): TImageType {.
    cdecl, importc: "gtk_status_icon_get_storage_type", dynlib: lib.}
proc get_pixbuf*(status_icon: PStatusIcon): PPixbuf {.
    cdecl, importc: "gtk_status_icon_get_pixbuf", dynlib: lib.}
proc get_stock*(status_icon: PStatusIcon): CSTRING {.
    cdecl, importc: "gtk_status_icon_get_stock", dynlib: lib.}
proc get_icon_name*(status_icon: PStatusIcon): CSTRING {.
    cdecl, importc: "gtk_status_icon_get_icon_name", dynlib: lib.}
proc get_gicon*(status_icon: PStatusIcon): PGIcon {.
    cdecl, importc: "gtk_status_icon_get_gicon", dynlib: lib.}
proc get_size*(status_icon: PStatusIcon): gint {.cdecl, 
    importc: "gtk_status_icon_get_size", dynlib: lib.}
proc set_screen*(status_icon: PStatusIcon; 
                                 screen: PGdkScreen) {.cdecl, 
    importc: "gtk_status_icon_set_screen", dynlib: lib.}
proc get_screen*(status_icon: PStatusIcon): PGdkScreen {.
    cdecl, importc: "gtk_status_icon_get_screen", dynlib: lib.}
proc set_has_tooltip*(status_icon: PStatusIcon; 
                                      has_tooltip: gboolean) {.cdecl, 
    importc: "gtk_status_icon_set_has_tooltip", dynlib: lib.}
proc set_tooltip_text*(status_icon: PStatusIcon; 
    text: CSTRING) {.cdecl, importc: "gtk_status_icon_set_tooltip_text", 
                       dynlib: lib.}
proc set_tooltip_markup*(status_icon: PStatusIcon; 
    markup: CSTRING) {.cdecl, importc: "gtk_status_icon_set_tooltip_markup", 
                         dynlib: lib.}
proc set_title*(status_icon: PStatusIcon; 
                                title: CSTRING) {.cdecl, 
    importc: "gtk_status_icon_set_title", dynlib: lib.}
proc get_title*(status_icon: PStatusIcon): CSTRING {.
    cdecl, importc: "gtk_status_icon_get_title", dynlib: lib.}
proc set_name*(status_icon: PStatusIcon; name: CSTRING) {.
    cdecl, importc: "gtk_status_icon_set_name", dynlib: lib.}
proc set_visible*(status_icon: PStatusIcon; 
                                  visible: gboolean) {.cdecl, 
    importc: "gtk_status_icon_set_visible", dynlib: lib.}
proc get_visible*(status_icon: PStatusIcon): gboolean {.
    cdecl, importc: "gtk_status_icon_get_visible", dynlib: lib.}
proc is_embedded*(status_icon: PStatusIcon): gboolean {.
    cdecl, importc: "gtk_status_icon_is_embedded", dynlib: lib.}
proc status_icon_position_menu*(menu: PMenu; x: Pgint; 
                                    y: Pgint; push_in: Pgboolean; 
                                    user_data: gpointer) {.cdecl, 
    importc: "gtk_status_icon_position_menu", dynlib: lib.}
proc get_geometry*(status_icon: PStatusIcon; 
                                   screen: ptr PGdkScreen; 
                                   area: gdk3.PRectangle; 
                                   orientation: POrientation): gboolean {.
    cdecl, importc: "gtk_status_icon_get_geometry", dynlib: lib.}
proc get_has_tooltip*(status_icon: PStatusIcon): gboolean {.
    cdecl, importc: "gtk_status_icon_get_has_tooltip", dynlib: lib.}
proc get_tooltip_text*(status_icon: PStatusIcon): CSTRING {.
    cdecl, importc: "gtk_status_icon_get_tooltip_text", dynlib: lib.}
proc get_tooltip_markup*(status_icon: PStatusIcon): CSTRING {.
    cdecl, importc: "gtk_status_icon_get_tooltip_markup", dynlib: lib.}
proc get_x11_window_id*(status_icon: PStatusIcon): guint32 {.
    cdecl, importc: "gtk_status_icon_get_x11_window_id", dynlib: lib.}

template TYPE_SWITCH*(): expr = 
  (gtk_switch_get_type())

template SWITCH_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_SWITCH, TSwitch))

template IS_SWITCH*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_SWITCH))

template SWITCH_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_SWITCH, TSwitchClass))

template IS_SWITCH_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_SWITCH))

template SWITCH_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_SWITCH, TSwitchClass))

type 
  PSwitch* = ptr TSwitch
  TSwitch* = object of TWidget
    priv122: PSwitchPrivate

type 
  PSwitchClass* = ptr TSwitchClass
  TSwitchClass* = object of TWidgetClass
    activate*: proc (sw: PSwitch) {.cdecl.}
    uswitch_padding_1*: proc () {.cdecl.}
    uswitch_padding_2*: proc () {.cdecl.}
    uswitch_padding_3*: proc () {.cdecl.}
    uswitch_padding_4*: proc () {.cdecl.}
    uswitch_padding_5*: proc () {.cdecl.}
    uswitch_padding_6*: proc () {.cdecl.}

proc switch_get_type*(): GType {.cdecl, importc: "gtk_switch_get_type", 
                                     dynlib: lib.}
proc switch_new*(): PWidget {.cdecl, importc: "gtk_switch_new", 
    dynlib: lib.}
proc set_active*(sw: PSwitch; is_active: gboolean) {.cdecl, 
    importc: "gtk_switch_set_active", dynlib: lib.}
proc get_active*(sw: PSwitch): gboolean {.cdecl, 
    importc: "gtk_switch_get_active", dynlib: lib.}

type 
  TTextTagTableForeach* = proc (tag: PTextTag; data: gpointer) {.cdecl.}
template TYPE_TEXT_TAG_TABLE*(): expr = 
  (gtk_text_tag_table_get_type())

template TEXT_TAG_TABLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEXT_TAG_TABLE, TTextTagTable))

template TEXT_TAG_TABLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEXT_TAG_TABLE, 
                           TTextTagTableClass))

template IS_TEXT_TAG_TABLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEXT_TAG_TABLE))

template IS_TEXT_TAG_TABLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TEXT_TAG_TABLE))

template TEXT_TAG_TABLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TEXT_TAG_TABLE, 
                             TTextTagTableClass))

type 
  PTextTagTable* = ptr TTextTagTable
  TTextTagTable* = object of TGObject
    priv123: PTextTagTablePrivate

type 
  PTextTagTableClass* = ptr TTextTagTableClass
  TTextTagTableClass* = object of TGObjectClass
    tag_changed*: proc (table: PTextTagTable; tag: PTextTag; 
                        size_changed: gboolean) {.cdecl.}
    tag_added*: proc (table: PTextTagTable; tag: PTextTag) {.cdecl.}
    tag_removed*: proc (table: PTextTagTable; tag: PTextTag) {.
        cdecl.}
    ugtk_reserved1221*: proc () {.cdecl.}
    ugtk_reserved1222*: proc () {.cdecl.}
    ugtk_reserved1223*: proc () {.cdecl.}
    ugtk_reserved1224*: proc () {.cdecl.}

proc text_tag_table_get_type*(): GType {.cdecl, 
    importc: "gtk_text_tag_table_get_type", dynlib: lib.}
proc text_tag_table_new*(): PTextTagTable {.cdecl, 
    importc: "gtk_text_tag_table_new", dynlib: lib.}
proc add*(table: PTextTagTable; tag: PTextTag) {.
    cdecl, importc: "gtk_text_tag_table_add", dynlib: lib.}
proc remove*(table: PTextTagTable; 
                                tag: PTextTag) {.cdecl, 
    importc: "gtk_text_tag_table_remove", dynlib: lib.}
proc lookup*(table: PTextTagTable; name: CSTRING): PTextTag {.
    cdecl, importc: "gtk_text_tag_table_lookup", dynlib: lib.}
proc foreach*(table: PTextTagTable; 
                                 func: TTextTagTableForeach; data: gpointer) {.
    cdecl, importc: "gtk_text_tag_table_foreach", dynlib: lib.}
proc get_size*(table: PTextTagTable): gint {.cdecl, 
    importc: "gtk_text_tag_table_get_size", dynlib: lib.}
proc underscore_gtk_text_tag_table_add_buffer*(table: PTextTagTable; 
                                     buffer: gpointer) {.cdecl, 
    importc: "_gtk_text_tag_table_add_buffer", dynlib: lib.}
proc underscore_gtk_text_tag_table_remove_buffer*(table: PTextTagTable; 
    buffer: gpointer) {.cdecl, importc: "_gtk_text_tag_table_remove_buffer", 
                        dynlib: lib.}

template TYPE_TEXT_MARK*(): expr = 
  (gtk_text_mark_get_type())

template TEXT_MARK_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEXT_MARK, TTextMark))

template TEXT_MARK_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEXT_MARK, TTextMarkClass))

template IS_TEXT_MARK*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEXT_MARK))

template IS_TEXT_MARK_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TEXT_MARK))

template TEXT_MARK_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TEXT_MARK, TTextMarkClass))

type 
  PTextMark* = ptr TTextMark
  TTextMark* = object of TGObject
    segment*: gpointer

type 
  PTextMarkClass* = ptr TTextMarkClass
  TTextMarkClass* = object of TGObjectClass
    ugtk_reserved1231*: proc () {.cdecl.}
    ugtk_reserved1232*: proc () {.cdecl.}
    ugtk_reserved1233*: proc () {.cdecl.}
    ugtk_reserved1234*: proc () {.cdecl.}

proc text_mark_get_type*(): GType {.cdecl, 
    importc: "gtk_text_mark_get_type", dynlib: lib.}
proc text_mark_new*(name: CSTRING; left_gravity: gboolean): PTextMark {.
    cdecl, importc: "gtk_text_mark_new", dynlib: lib.}
proc set_visible*(mark: PTextMark; setting: gboolean) {.
    cdecl, importc: "gtk_text_mark_set_visible", dynlib: lib.}
proc get_visible*(mark: PTextMark): gboolean {.cdecl, 
    importc: "gtk_text_mark_get_visible", dynlib: lib.}
proc get_name*(mark: PTextMark): CSTRING {.cdecl, 
    importc: "gtk_text_mark_get_name", dynlib: lib.}
proc get_deleted*(mark: PTextMark): gboolean {.cdecl, 
    importc: "gtk_text_mark_get_deleted", dynlib: lib.}
proc get_buffer*(mark: PTextMark): PTextBuffer {.
    cdecl, importc: "gtk_text_mark_get_buffer", dynlib: lib.}
proc get_left_gravity*(mark: PTextMark): gboolean {.cdecl, 
    importc: "gtk_text_mark_get_left_gravity", dynlib: lib.}

type 
  TTextBufferTargetInfo* {.size: sizeof(cint).} = enum 
    TEXT_BUFFER_TARGET_INFO_TEXT = - 3
    TEXT_BUFFER_TARGET_INFO_RICH_TEXT = - 2, 
    TEXT_BUFFER_TARGET_INFO_BUFFER_CONTENTS = - 1, 
template TYPE_TEXT_BUFFER*(): expr = 
  (gtk_text_buffer_get_type())

template TEXT_BUFFER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEXT_BUFFER, TTextBuffer))

template TEXT_BUFFER_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEXT_BUFFER, TTextBufferClass))

template IS_TEXT_BUFFER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEXT_BUFFER))

template IS_TEXT_BUFFER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TEXT_BUFFER))

template TEXT_BUFFER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TEXT_BUFFER, TTextBufferClass))


type 
  PTextBufferClass* = ptr TTextBufferClass
  TTextBufferClass* = object of TGObjectClass
    insert_text*: proc (buffer: PTextBuffer; pos: PTextIter; 
                        new_text: CSTRING; new_text_length: gint) {.cdecl.}
    insert_pixbuf*: proc (buffer: PTextBuffer; iter: PTextIter; 
                          pixbuf: PPixbuf) {.cdecl.}
    insert_child_anchor*: proc (buffer: PTextBuffer; 
                                iter: PTextIter; 
                                anchor: PTextChildAnchor) {.cdecl.}
    delete_range*: proc (buffer: PTextBuffer; start: PTextIter; 
                         e: PTextIter) {.cdecl.}
    changed*: proc (buffer: PTextBuffer) {.cdecl.}
    modified_changed*: proc (buffer: PTextBuffer) {.cdecl.}
    mark_set*: proc (buffer: PTextBuffer; location: PTextIter; 
                     mark: PTextMark) {.cdecl.}
    mark_deleted*: proc (buffer: PTextBuffer; mark: PTextMark) {.
        cdecl.}
    apply_tag*: proc (buffer: PTextBuffer; tag: PTextTag; 
                      start: PTextIter; e: PTextIter) {.cdecl.}
    remove_tag*: proc (buffer: PTextBuffer; tag: PTextTag; 
                       start: PTextIter; e: PTextIter) {.cdecl.}
    begin_user_action*: proc (buffer: PTextBuffer) {.cdecl.}
    end_user_action*: proc (buffer: PTextBuffer) {.cdecl.}
    paste_done*: proc (buffer: PTextBuffer; clipboard: PClipboard) {.
        cdecl.}
    ugtk_reserved1241*: proc () {.cdecl.}
    ugtk_reserved1242*: proc () {.cdecl.}
    ugtk_reserved1243*: proc () {.cdecl.}
    ugtk_reserved1244*: proc () {.cdecl.}

proc text_buffer_get_type*(): GType {.cdecl, 
    importc: "gtk_text_buffer_get_type", dynlib: lib.}
proc text_buffer_new*(table: PTextTagTable): PTextBuffer {.
    cdecl, importc: "gtk_text_buffer_new", dynlib: lib.}
proc get_line_count*(buffer: PTextBuffer): gint {.cdecl, 
    importc: "gtk_text_buffer_get_line_count", dynlib: lib.}
proc get_char_count*(buffer: PTextBuffer): gint {.cdecl, 
    importc: "gtk_text_buffer_get_char_count", dynlib: lib.}
proc get_tag_table*(buffer: PTextBuffer): PTextTagTable {.
    cdecl, importc: "gtk_text_buffer_get_tag_table", dynlib: lib.}
proc set_text*(buffer: PTextBuffer; text: CSTRING; 
                               len: gint) {.cdecl, 
    importc: "gtk_text_buffer_set_text", dynlib: lib.}
proc insert*(buffer: PTextBuffer; iter: PTextIter; 
                             text: CSTRING; len: gint) {.cdecl, 
    importc: "gtk_text_buffer_insert", dynlib: lib.}
proc insert_at_cursor*(buffer: PTextBuffer; 
    text: CSTRING; len: gint) {.cdecl, importc: "gtk_text_buffer_insert_at_cursor", 
                                  dynlib: lib.}
proc insert_interactive*(buffer: PTextBuffer; 
    iter: PTextIter; text: CSTRING; len: gint; 
    default_editable: gboolean): gboolean {.cdecl, 
    importc: "gtk_text_buffer_insert_interactive", dynlib: lib.}
proc insert_interactive_at_cursor*(buffer: PTextBuffer; 
    text: CSTRING; len: gint; default_editable: gboolean): gboolean {.cdecl, 
    importc: "gtk_text_buffer_insert_interactive_at_cursor", dynlib: lib.}
proc insert_range*(buffer: PTextBuffer; 
                                   iter: PTextIter; 
                                   start: PTextIter; 
                                   e: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_insert_range", dynlib: lib.}
proc insert_range_interactive*(buffer: PTextBuffer; 
    iter: PTextIter; start: PTextIter; e: PTextIter; 
    default_editable: gboolean): gboolean {.cdecl, 
    importc: "gtk_text_buffer_insert_range_interactive", dynlib: lib.}
proc insert_with_tags*(buffer: PTextBuffer; 
    iter: PTextIter; text: CSTRING; len: gint; 
    first_tag: PTextTag) {.varargs, cdecl, 
                                 importc: "gtk_text_buffer_insert_with_tags", 
                                 dynlib: lib.}
proc insert_with_tags_by_name*(buffer: PTextBuffer; 
    iter: PTextIter; text: CSTRING; len: gint; 
    first_tag_name: CSTRING) {.varargs, cdecl, importc: "gtk_text_buffer_insert_with_tags_by_name", 
                                 dynlib: lib.}
proc delete*(buffer: PTextBuffer; 
                             start: PTextIter; e: PTextIter) {.
    cdecl, importc: "gtk_text_buffer_delete", dynlib: lib.}
proc delete_interactive*(buffer: PTextBuffer; 
    start_iter: PTextIter; end_iter: PTextIter; 
    default_editable: gboolean): gboolean {.cdecl, 
    importc: "gtk_text_buffer_delete_interactive", dynlib: lib.}
proc backspace*(buffer: PTextBuffer; 
                                iter: PTextIter; interactive: gboolean; 
                                default_editable: gboolean): gboolean {.cdecl, 
    importc: "gtk_text_buffer_backspace", dynlib: lib.}
proc get_text*(buffer: PTextBuffer; 
                               start: PTextIter; e: PTextIter; 
                               include_hidden_chars: gboolean): CSTRING {.
    cdecl, importc: "gtk_text_buffer_get_text", dynlib: lib.}
proc get_slice*(buffer: PTextBuffer; 
                                start: PTextIter; e: PTextIter; 
                                include_hidden_chars: gboolean): CSTRING {.
    cdecl, importc: "gtk_text_buffer_get_slice", dynlib: lib.}
proc insert_pixbuf*(buffer: PTextBuffer; 
                                    iter: PTextIter; 
                                    pixbuf: PPixbuf) {.cdecl, 
    importc: "gtk_text_buffer_insert_pixbuf", dynlib: lib.}
proc insert_child_anchor*(buffer: PTextBuffer; 
    iter: PTextIter; anchor: PTextChildAnchor) {.cdecl, 
    importc: "gtk_text_buffer_insert_child_anchor", dynlib: lib.}
proc create_child_anchor*(buffer: PTextBuffer; 
    iter: PTextIter): PTextChildAnchor {.cdecl, 
    importc: "gtk_text_buffer_create_child_anchor", dynlib: lib.}
proc add_mark*(buffer: PTextBuffer; 
                               mark: PTextMark; where: PTextIter) {.
    cdecl, importc: "gtk_text_buffer_add_mark", dynlib: lib.}
proc create_mark*(buffer: PTextBuffer; 
                                  mark_name: CSTRING; 
                                  where: PTextIter; 
                                  left_gravity: gboolean): PTextMark {.
    cdecl, importc: "gtk_text_buffer_create_mark", dynlib: lib.}
proc move_mark*(buffer: PTextBuffer; 
                                mark: PTextMark; where: PTextIter) {.
    cdecl, importc: "gtk_text_buffer_move_mark", dynlib: lib.}
proc delete_mark*(buffer: PTextBuffer; 
                                  mark: PTextMark) {.cdecl, 
    importc: "gtk_text_buffer_delete_mark", dynlib: lib.}
proc get_mark*(buffer: PTextBuffer; name: CSTRING): PTextMark {.
    cdecl, importc: "gtk_text_buffer_get_mark", dynlib: lib.}
proc move_mark_by_name*(buffer: PTextBuffer; 
    name: CSTRING; where: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_move_mark_by_name", dynlib: lib.}
proc delete_mark_by_name*(buffer: PTextBuffer; 
    name: CSTRING) {.cdecl, importc: "gtk_text_buffer_delete_mark_by_name", 
                       dynlib: lib.}
proc get_insert*(buffer: PTextBuffer): PTextMark {.
    cdecl, importc: "gtk_text_buffer_get_insert", dynlib: lib.}
proc get_selection_bound*(buffer: PTextBuffer): PTextMark {.
    cdecl, importc: "gtk_text_buffer_get_selection_bound", dynlib: lib.}
proc place_cursor*(buffer: PTextBuffer; 
                                   where: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_place_cursor", dynlib: lib.}
proc select_range*(buffer: PTextBuffer; 
                                   ins: PTextIter; 
                                   bound: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_select_range", dynlib: lib.}
proc apply_tag*(buffer: PTextBuffer; 
                                tag: PTextTag; start: PTextIter; 
                                e: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_apply_tag", dynlib: lib.}
proc remove_tag*(buffer: PTextBuffer; 
                                 tag: PTextTag; start: PTextIter; 
                                 e: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_remove_tag", dynlib: lib.}
proc apply_tag_by_name*(buffer: PTextBuffer; 
    name: CSTRING; start: PTextIter; e: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_apply_tag_by_name", dynlib: lib.}
proc remove_tag_by_name*(buffer: PTextBuffer; 
    name: CSTRING; start: PTextIter; e: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_remove_tag_by_name", dynlib: lib.}
proc remove_all_tags*(buffer: PTextBuffer; 
                                      start: PTextIter; 
                                      e: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_remove_all_tags", dynlib: lib.}
proc create_tag*(buffer: PTextBuffer; 
                                 tag_name: CSTRING; 
                                 first_property_name: CSTRING): PTextTag {.
    varargs, cdecl, importc: "gtk_text_buffer_create_tag", dynlib: lib.}
proc get_iter_at_line_offset*(buffer: PTextBuffer; 
    iter: PTextIter; line_number: gint; char_offset: gint) {.cdecl, 
    importc: "gtk_text_buffer_get_iter_at_line_offset", dynlib: lib.}
proc get_iter_at_line_index*(buffer: PTextBuffer; 
    iter: PTextIter; line_number: gint; byte_index: gint) {.cdecl, 
    importc: "gtk_text_buffer_get_iter_at_line_index", dynlib: lib.}
proc get_iter_at_offset*(buffer: PTextBuffer; 
    iter: PTextIter; char_offset: gint) {.cdecl, 
    importc: "gtk_text_buffer_get_iter_at_offset", dynlib: lib.}
proc get_iter_at_line*(buffer: PTextBuffer; 
    iter: PTextIter; line_number: gint) {.cdecl, 
    importc: "gtk_text_buffer_get_iter_at_line", dynlib: lib.}
proc get_start_iter*(buffer: PTextBuffer; 
                                     iter: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_get_start_iter", dynlib: lib.}
proc get_end_iter*(buffer: PTextBuffer; 
                                   iter: PTextIter) {.cdecl, 
    importc: "gtk_text_buffer_get_end_iter", dynlib: lib.}
proc get_bounds*(buffer: PTextBuffer; 
                                 start: PTextIter; e: PTextIter) {.
    cdecl, importc: "gtk_text_buffer_get_bounds", dynlib: lib.}
proc get_iter_at_mark*(buffer: PTextBuffer; 
    iter: PTextIter; mark: PTextMark) {.cdecl, 
    importc: "gtk_text_buffer_get_iter_at_mark", dynlib: lib.}
proc get_iter_at_child_anchor*(buffer: PTextBuffer; 
    iter: PTextIter; anchor: PTextChildAnchor) {.cdecl, 
    importc: "gtk_text_buffer_get_iter_at_child_anchor", dynlib: lib.}
proc get_modified*(buffer: PTextBuffer): gboolean {.
    cdecl, importc: "gtk_text_buffer_get_modified", dynlib: lib.}
proc set_modified*(buffer: PTextBuffer; 
                                   setting: gboolean) {.cdecl, 
    importc: "gtk_text_buffer_set_modified", dynlib: lib.}
proc get_has_selection*(buffer: PTextBuffer): gboolean {.
    cdecl, importc: "gtk_text_buffer_get_has_selection", dynlib: lib.}
proc add_selection_clipboard*(buffer: PTextBuffer; 
    clipboard: PClipboard) {.cdecl, importc: "gtk_text_buffer_add_selection_clipboard", 
                                   dynlib: lib.}
proc remove_selection_clipboard*(buffer: PTextBuffer; 
    clipboard: PClipboard) {.cdecl, importc: "gtk_text_buffer_remove_selection_clipboard", 
                                   dynlib: lib.}
proc cut_clipboard*(buffer: PTextBuffer; 
                                    clipboard: PClipboard; 
                                    default_editable: gboolean) {.cdecl, 
    importc: "gtk_text_buffer_cut_clipboard", dynlib: lib.}
proc copy_clipboard*(buffer: PTextBuffer; 
                                     clipboard: PClipboard) {.cdecl, 
    importc: "gtk_text_buffer_copy_clipboard", dynlib: lib.}
proc paste_clipboard*(buffer: PTextBuffer; 
                                      clipboard: PClipboard; 
                                      override_location: PTextIter; 
                                      default_editable: gboolean) {.cdecl, 
    importc: "gtk_text_buffer_paste_clipboard", dynlib: lib.}
proc get_selection_bounds*(buffer: PTextBuffer; 
    start: PTextIter; e: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_buffer_get_selection_bounds", dynlib: lib.}
proc delete_selection*(buffer: PTextBuffer; 
    interactive: gboolean; default_editable: gboolean): gboolean {.cdecl, 
    importc: "gtk_text_buffer_delete_selection", dynlib: lib.}
proc begin_user_action*(buffer: PTextBuffer) {.cdecl, 
    importc: "gtk_text_buffer_begin_user_action", dynlib: lib.}
proc end_user_action*(buffer: PTextBuffer) {.cdecl, 
    importc: "gtk_text_buffer_end_user_action", dynlib: lib.}
proc get_copy_target_list*(buffer: PTextBuffer): PTargetList {.
    cdecl, importc: "gtk_text_buffer_get_copy_target_list", dynlib: lib.}
proc get_paste_target_list*(buffer: PTextBuffer): PTargetList {.
    cdecl, importc: "gtk_text_buffer_get_paste_target_list", dynlib: lib.}
proc underscore_gtk_text_buffer_spew*(buffer: PTextBuffer) {.cdecl, 
    importc: "_gtk_text_buffer_spew", dynlib: lib.}
proc underscore_gtk_text_buffer_get_btree*(buffer: PTextBuffer): PTextBTree {.
    cdecl, importc: "_gtk_text_buffer_get_btree", dynlib: lib.}
proc underscore_gtk_text_buffer_get_line_log_attrs*(buffer: PTextBuffer; 
    anywhere_in_line: PTextIter; char_len: Pgint): pango.PLogAttr {.
    cdecl, importc: "_gtk_text_buffer_get_line_log_attrs", dynlib: lib.}
proc underscore_gtk_text_buffer_notify_will_remove_tag*(buffer: PTextBuffer; 
    tag: PTextTag) {.cdecl, importc: "_gtk_text_buffer_notify_will_remove_tag", 
                           dynlib: lib.}
proc underscore_gtk_text_buffer_get_text_before*(buffer: PTextBuffer; 
    boundary_type: atk.TTextBoundary; position: PTextIter; 
    start: PTextIter; e: PTextIter) {.cdecl, 
    importc: "_gtk_text_buffer_get_text_before", dynlib: lib.}
proc underscore_gtk_text_buffer_get_text_at*(buffer: PTextBuffer; 
                                   boundary_type: atk.TTextBoundary; 
                                   position: PTextIter; 
                                   start: PTextIter; 
                                   e: PTextIter) {.cdecl, 
    importc: "_gtk_text_buffer_get_text_at", dynlib: lib.}
proc underscore_gtk_text_buffer_get_text_after*(buffer: PTextBuffer; 
                                      boundary_type: atk.TTextBoundary; 
                                      position: PTextIter; 
                                      start: PTextIter; 
                                      e: PTextIter) {.cdecl, 
    importc: "_gtk_text_buffer_get_text_after", dynlib: lib.}

type 
  TTextBufferSerializeFunc* = proc (register_buffer: PTextBuffer; 
                                      content_buffer: PTextBuffer; 
                                      start: PTextIter; 
                                      e: PTextIter; length: Pgsize; 
                                      user_data: gpointer): Pguint8 {.cdecl.}
type 
  TTextBufferDeserializeFunc* = proc (register_buffer: PTextBuffer; 
      content_buffer: PTextBuffer; iter: PTextIter; 
      data: Pguint8; length: gsize; create_tags: gboolean; 
      user_data: gpointer; error: ptr PGError): gboolean {.cdecl.}
proc register_serialize_format*(buffer: PTextBuffer; 
    mime_type: CSTRING; function: TTextBufferSerializeFunc; 
    user_data: gpointer; user_data_destroy: TGDestroyNotify): TGdkAtom {.cdecl, 
    importc: "gtk_text_buffer_register_serialize_format", dynlib: lib.}
proc register_serialize_tagset*(buffer: PTextBuffer; 
    tagset_name: CSTRING): TGdkAtom {.cdecl, 
    importc: "gtk_text_buffer_register_serialize_tagset", dynlib: lib.}
proc register_deserialize_format*(buffer: PTextBuffer; 
    mime_type: CSTRING; function: TTextBufferDeserializeFunc; 
    user_data: gpointer; user_data_destroy: TGDestroyNotify): TGdkAtom {.cdecl, 
    importc: "gtk_text_buffer_register_deserialize_format", dynlib: lib.}
proc register_deserialize_tagset*(buffer: PTextBuffer; 
    tagset_name: CSTRING): TGdkAtom {.cdecl, 
    importc: "gtk_text_buffer_register_deserialize_tagset", dynlib: lib.}
proc unregister_serialize_format*(buffer: PTextBuffer; 
    format: TGdkAtom) {.cdecl, importc: "gtk_text_buffer_unregister_serialize_format", 
                       dynlib: lib.}
proc unregister_deserialize_format*(buffer: PTextBuffer; 
    format: TGdkAtom) {.cdecl, importc: "gtk_text_buffer_unregister_deserialize_format", 
                       dynlib: lib.}
proc deserialize_set_can_create_tags*(
    buffer: PTextBuffer; format: TGdkAtom; can_create_tags: gboolean) {.
    cdecl, importc: "gtk_text_buffer_deserialize_set_can_create_tags", 
    dynlib: lib.}
proc deserialize_get_can_create_tags*(
    buffer: PTextBuffer; format: TGdkAtom): gboolean {.cdecl, 
    importc: "gtk_text_buffer_deserialize_get_can_create_tags", dynlib: lib.}
proc get_serialize_formats*(buffer: PTextBuffer; 
    n_formats: Pgint): PGdkAtom {.cdecl, 
    importc: "gtk_text_buffer_get_serialize_formats", dynlib: lib.}
proc get_deserialize_formats*(buffer: PTextBuffer; 
    n_formats: Pgint): PGdkAtom {.cdecl, 
    importc: "gtk_text_buffer_get_deserialize_formats", dynlib: lib.}
proc serialize*(register_buffer: PTextBuffer; 
                                content_buffer: PTextBuffer; 
                                format: TGdkAtom; start: PTextIter; 
                                e: PTextIter; length: Pgsize): Pguint8 {.
    cdecl, importc: "gtk_text_buffer_serialize", dynlib: lib.}
proc deserialize*(register_buffer: PTextBuffer; 
                                  content_buffer: PTextBuffer; 
                                  format: TGdkAtom; iter: PTextIter; 
                                  data: Pguint8; length: gsize; 
                                  error: ptr PGError): gboolean {.cdecl, 
    importc: "gtk_text_buffer_deserialize", dynlib: lib.}

template TYPE_TEXT_VIEW*(): expr = 
  (gtk_text_view_get_type())

template TEXT_VIEW_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEXT_VIEW, TTextView))

template TEXT_VIEW_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEXT_VIEW, TTextViewClass))

template IS_TEXT_VIEW*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEXT_VIEW))

template IS_TEXT_VIEW_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TEXT_VIEW))

template TEXT_VIEW_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TEXT_VIEW, TTextViewClass))

type 
  TTextWindowType* {.size: sizeof(cint).} = enum 
    TEXT_WINDOW_PRIVATE, TEXT_WINDOW_WIDGET, TEXT_WINDOW_TEXT, 
    TEXT_WINDOW_LEFT, TEXT_WINDOW_RIGHT, TEXT_WINDOW_TOP, 
    TEXT_WINDOW_BOTTOM
const 
  TEXT_VIEW_PRIORITY_VALIDATE* = (gdk3.PRIORITY_REDRAW + 5)
type 
  PTextView* = ptr TTextView
  TTextView* = object of TContainer
    priv124: PTextViewPrivate

type 
  PTextViewClass* = ptr TTextViewClass
  TTextViewClass* = object of TContainerClass
    populate_popup*: proc (text_view: PTextView; popup: PWidget) {.
        cdecl.}
    move_cursor*: proc (text_view: PTextView; step: TMovementStep; 
                        count: gint; extend_selection: gboolean) {.cdecl.}
    set_anchor*: proc (text_view: PTextView) {.cdecl.}
    insert_at_cursor*: proc (text_view: PTextView; str: CSTRING) {.
        cdecl.}
    delete_from_cursor*: proc (text_view: PTextView; 
                               typ: TDeleteType; count: gint) {.cdecl.}
    backspace*: proc (text_view: PTextView) {.cdecl.}
    cut_clipboard*: proc (text_view: PTextView) {.cdecl.}
    copy_clipboard*: proc (text_view: PTextView) {.cdecl.}
    paste_clipboard*: proc (text_view: PTextView) {.cdecl.}
    toggle_overwrite*: proc (text_view: PTextView) {.cdecl.}
    create_buffer*: proc (text_view: PTextView): PTextBuffer {.
        cdecl.}
    ugtk_reserved1251*: proc () {.cdecl.}
    ugtk_reserved1252*: proc () {.cdecl.}
    ugtk_reserved1253*: proc () {.cdecl.}
    ugtk_reserved1254*: proc () {.cdecl.}
    ugtk_reserved1255*: proc () {.cdecl.}
    ugtk_reserved1256*: proc () {.cdecl.}
    ugtk_reserved1257*: proc () {.cdecl.}

proc text_view_get_type*(): GType {.cdecl, 
    importc: "gtk_text_view_get_type", dynlib: lib.}
proc text_view_new*(): PWidget {.cdecl, 
    importc: "gtk_text_view_new", dynlib: lib.}
proc text_view_new_with_buffer*(buffer: PTextBuffer): PWidget {.
    cdecl, importc: "gtk_text_view_new_with_buffer", dynlib: lib.}
proc set_buffer*(text_view: PTextView; 
                               buffer: PTextBuffer) {.cdecl, 
    importc: "gtk_text_view_set_buffer", dynlib: lib.}
proc get_buffer*(text_view: PTextView): PTextBuffer {.
    cdecl, importc: "gtk_text_view_get_buffer", dynlib: lib.}
proc scroll_to_iter*(text_view: PTextView; 
                                   iter: PTextIter; 
                                   within_margin: gdouble; 
                                   use_align: gboolean; xalign: gdouble; 
                                   yalign: gdouble): gboolean {.cdecl, 
    importc: "gtk_text_view_scroll_to_iter", dynlib: lib.}
proc scroll_to_mark*(text_view: PTextView; 
                                   mark: PTextMark; 
                                   within_margin: gdouble; 
                                   use_align: gboolean; xalign: gdouble; 
                                   yalign: gdouble) {.cdecl, 
    importc: "gtk_text_view_scroll_to_mark", dynlib: lib.}
proc scroll_mark_onscreen*(text_view: PTextView; 
    mark: PTextMark) {.cdecl, 
                             importc: "gtk_text_view_scroll_mark_onscreen", 
                             dynlib: lib.}
proc move_mark_onscreen*(text_view: PTextView; 
    mark: PTextMark): gboolean {.cdecl, 
    importc: "gtk_text_view_move_mark_onscreen", dynlib: lib.}
proc place_cursor_onscreen*(text_view: PTextView): gboolean {.
    cdecl, importc: "gtk_text_view_place_cursor_onscreen", dynlib: lib.}
proc get_visible_rect*(text_view: PTextView; 
                                     visible_rect: gdk3.PRectangle) {.cdecl, 
    importc: "gtk_text_view_get_visible_rect", dynlib: lib.}
proc set_cursor_visible*(text_view: PTextView; 
    setting: gboolean) {.cdecl, importc: "gtk_text_view_set_cursor_visible", 
                         dynlib: lib.}
proc get_cursor_visible*(text_view: PTextView): gboolean {.
    cdecl, importc: "gtk_text_view_get_cursor_visible", dynlib: lib.}
proc get_cursor_locations*(text_view: PTextView; 
    iter: PTextIter; strong: gdk3.PRectangle; weak: gdk3.PRectangle) {.
    cdecl, importc: "gtk_text_view_get_cursor_locations", dynlib: lib.}
proc get_iter_location*(text_view: PTextView; 
                                      iter: PTextIter; 
                                      location: gdk3.PRectangle) {.cdecl, 
    importc: "gtk_text_view_get_iter_location", dynlib: lib.}
proc get_iter_at_location*(text_view: PTextView; 
    iter: PTextIter; x: gint; y: gint) {.cdecl, 
    importc: "gtk_text_view_get_iter_at_location", dynlib: lib.}
proc get_iter_at_position*(text_view: PTextView; 
    iter: PTextIter; trailing: Pgint; x: gint; y: gint) {.cdecl, 
    importc: "gtk_text_view_get_iter_at_position", dynlib: lib.}
proc get_line_yrange*(text_view: PTextView; 
                                    iter: PTextIter; y: Pgint; 
                                    height: Pgint) {.cdecl, 
    importc: "gtk_text_view_get_line_yrange", dynlib: lib.}
proc get_line_at_y*(text_view: PTextView; 
                                  target_iter: PTextIter; y: gint; 
                                  line_top: Pgint) {.cdecl, 
    importc: "gtk_text_view_get_line_at_y", dynlib: lib.}
proc buffer_to_window_coords*(text_view: PTextView; 
    win: TTextWindowType; buffer_x: gint; buffer_y: gint; 
    window_x: Pgint; window_y: Pgint) {.cdecl, 
    importc: "gtk_text_view_buffer_to_window_coords", dynlib: lib.}
proc window_to_buffer_coords*(text_view: PTextView; 
    win: TTextWindowType; window_x: gint; window_y: gint; 
    buffer_x: Pgint; buffer_y: Pgint) {.cdecl, 
    importc: "gtk_text_view_window_to_buffer_coords", dynlib: lib.}
proc get_hadjustment*(text_view: PTextView): PAdjustment {.
    cdecl, importc: "gtk_text_view_get_hadjustment", dynlib: lib.}
proc get_vadjustment*(text_view: PTextView): PAdjustment {.
    cdecl, importc: "gtk_text_view_get_vadjustment", dynlib: lib.}
proc get_window*(text_view: PTextView; 
                               win: TTextWindowType): PGdkWindow {.cdecl, 
    importc: "gtk_text_view_get_window", dynlib: lib.}
proc get_window_type*(text_view: PTextView; 
                                    window: PGdkWindow): TTextWindowType {.
    cdecl, importc: "gtk_text_view_get_window_type", dynlib: lib.}
proc set_border_window_size*(text_view: PTextView; 
    typ: TTextWindowType; size: gint) {.cdecl, 
    importc: "gtk_text_view_set_border_window_size", dynlib: lib.}
proc get_border_window_size*(text_view: PTextView; 
    typ: TTextWindowType): gint {.cdecl, importc: "gtk_text_view_get_border_window_size", 
                                     dynlib: lib.}
proc forward_display_line*(text_view: PTextView; 
    iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_view_forward_display_line", dynlib: lib.}
proc backward_display_line*(text_view: PTextView; 
    iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_view_backward_display_line", dynlib: lib.}
proc forward_display_line_end*(text_view: PTextView; 
    iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_view_forward_display_line_end", dynlib: lib.}
proc backward_display_line_start*(text_view: PTextView; 
    iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_view_backward_display_line_start", dynlib: lib.}
proc starts_display_line*(text_view: PTextView; 
    iter: PTextIter): gboolean {.cdecl, 
    importc: "gtk_text_view_starts_display_line", dynlib: lib.}
proc move_visually*(text_view: PTextView; 
                                  iter: PTextIter; count: gint): gboolean {.
    cdecl, importc: "gtk_text_view_move_visually", dynlib: lib.}
proc im_context_filter_keypress*(text_view: PTextView; 
    event: PEventKey): gboolean {.cdecl, 
    importc: "gtk_text_view_im_context_filter_keypress", dynlib: lib.}
proc reset_im_context*(text_view: PTextView) {.cdecl, 
    importc: "gtk_text_view_reset_im_context", dynlib: lib.}
proc add_child_at_anchor*(text_view: PTextView; 
    child: PWidget; anchor: PTextChildAnchor) {.cdecl, 
    importc: "gtk_text_view_add_child_at_anchor", dynlib: lib.}
proc add_child_in_window*(text_view: PTextView; 
    child: PWidget; which_window: TTextWindowType; xpos: gint; 
    ypos: gint) {.cdecl, importc: "gtk_text_view_add_child_in_window", 
                  dynlib: lib.}
proc move_child*(text_view: PTextView; 
                               child: PWidget; xpos: gint; ypos: gint) {.
    cdecl, importc: "gtk_text_view_move_child", dynlib: lib.}
proc set_wrap_mode*(text_view: PTextView; 
                                  wrap_mode: TWrapMode) {.cdecl, 
    importc: "gtk_text_view_set_wrap_mode", dynlib: lib.}
proc get_wrap_mode*(text_view: PTextView): TWrapMode {.
    cdecl, importc: "gtk_text_view_get_wrap_mode", dynlib: lib.}
proc set_editable*(text_view: PTextView; setting: gboolean) {.
    cdecl, importc: "gtk_text_view_set_editable", dynlib: lib.}
proc get_editable*(text_view: PTextView): gboolean {.
    cdecl, importc: "gtk_text_view_get_editable", dynlib: lib.}
proc set_overwrite*(text_view: PTextView; 
                                  overwrite: gboolean) {.cdecl, 
    importc: "gtk_text_view_set_overwrite", dynlib: lib.}
proc get_overwrite*(text_view: PTextView): gboolean {.
    cdecl, importc: "gtk_text_view_get_overwrite", dynlib: lib.}
proc set_accepts_tab*(text_view: PTextView; 
                                    accepts_tab: gboolean) {.cdecl, 
    importc: "gtk_text_view_set_accepts_tab", dynlib: lib.}
proc get_accepts_tab*(text_view: PTextView): gboolean {.
    cdecl, importc: "gtk_text_view_get_accepts_tab", dynlib: lib.}
proc set_pixels_above_lines*(text_view: PTextView; 
    pixels_above_lines: gint) {.cdecl, importc: "gtk_text_view_set_pixels_above_lines", 
                                dynlib: lib.}
proc get_pixels_above_lines*(text_view: PTextView): gint {.
    cdecl, importc: "gtk_text_view_get_pixels_above_lines", dynlib: lib.}
proc set_pixels_below_lines*(text_view: PTextView; 
    pixels_below_lines: gint) {.cdecl, importc: "gtk_text_view_set_pixels_below_lines", 
                                dynlib: lib.}
proc get_pixels_below_lines*(text_view: PTextView): gint {.
    cdecl, importc: "gtk_text_view_get_pixels_below_lines", dynlib: lib.}
proc set_pixels_inside_wrap*(text_view: PTextView; 
    pixels_inside_wrap: gint) {.cdecl, importc: "gtk_text_view_set_pixels_inside_wrap", 
                                dynlib: lib.}
proc get_pixels_inside_wrap*(text_view: PTextView): gint {.
    cdecl, importc: "gtk_text_view_get_pixels_inside_wrap", dynlib: lib.}
proc set_justification*(text_view: PTextView; 
                                      justification: TJustification) {.
    cdecl, importc: "gtk_text_view_set_justification", dynlib: lib.}
proc get_justification*(text_view: PTextView): TJustification {.
    cdecl, importc: "gtk_text_view_get_justification", dynlib: lib.}
proc set_left_margin*(text_view: PTextView; 
                                    left_margin: gint) {.cdecl, 
    importc: "gtk_text_view_set_left_margin", dynlib: lib.}
proc get_left_margin*(text_view: PTextView): gint {.cdecl, 
    importc: "gtk_text_view_get_left_margin", dynlib: lib.}
proc set_right_margin*(text_view: PTextView; 
                                     right_margin: gint) {.cdecl, 
    importc: "gtk_text_view_set_right_margin", dynlib: lib.}
proc get_right_margin*(text_view: PTextView): gint {.
    cdecl, importc: "gtk_text_view_get_right_margin", dynlib: lib.}
proc set_indent*(text_view: PTextView; indent: gint) {.
    cdecl, importc: "gtk_text_view_set_indent", dynlib: lib.}
proc get_indent*(text_view: PTextView): gint {.cdecl, 
    importc: "gtk_text_view_get_indent", dynlib: lib.}
proc set_tabs*(text_view: PTextView; 
                             tabs: PTabArray) {.cdecl, 
    importc: "gtk_text_view_set_tabs", dynlib: lib.}
proc get_tabs*(text_view: PTextView): PTabArray {.
    cdecl, importc: "gtk_text_view_get_tabs", dynlib: lib.}
proc get_default_attributes*(text_view: PTextView): PTextAttributes {.
    cdecl, importc: "gtk_text_view_get_default_attributes", dynlib: lib.}
proc set_input_purpose*(text_view: PTextView; 
                                      purpose: TInputPurpose) {.cdecl, 
    importc: "gtk_text_view_set_input_purpose", dynlib: lib.}
proc get_input_purpose*(text_view: PTextView): TInputPurpose {.
    cdecl, importc: "gtk_text_view_get_input_purpose", dynlib: lib.}
proc set_input_hints*(text_view: PTextView; 
                                    hints: TInputHints) {.cdecl, 
    importc: "gtk_text_view_set_input_hints", dynlib: lib.}
proc get_input_hints*(text_view: PTextView): TInputHints {.
    cdecl, importc: "gtk_text_view_get_input_hints", dynlib: lib.}

template TYPE_THEMING_ENGINE*(): expr = 
  (gtk_theming_engine_get_type())

template THEMING_ENGINE_TEMPLATE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_THEMING_ENGINE, TThemingEngine))

template THEMING_ENGINE_CLASS_TEMPLATE*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((c), TYPE_THEMING_ENGINE, TThemingEngineClass))

template IS_THEMING_ENGINE*(o: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_THEMING_ENGINE))

template IS_THEMING_ENGINE_CLASS*(c: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_THEMING_ENGINE))

template THEMING_ENGINE_GET_CLASS*(o: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_THEMING_ENGINE, 
                             TThemingEngineClass))

type 
  PThemingEngine* = ptr TThemingEngine
  TThemingEngine* = object of TGObject
    priv125: PThemingEnginePrivate

type 
  PThemingEngineClass* = ptr TThemingEngineClass
  TThemingEngineClass* = object of TGObjectClass
    render_line*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                        x0: gdouble; y0: gdouble; x1: gdouble; y1: gdouble) {.
        cdecl.}
    render_background*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                              x: gdouble; y: gdouble; width: gdouble; 
                              height: gdouble) {.cdecl.}
    render_frame*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                         x: gdouble; y: gdouble; width: gdouble; 
                         height: gdouble) {.cdecl.}
    render_frame_gap*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                             x: gdouble; y: gdouble; width: gdouble; 
                             height: gdouble; gap_side: TPositionType; 
                             xy0_gap: gdouble; xy1_gap: gdouble) {.cdecl.}
    render_extension*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                             x: gdouble; y: gdouble; width: gdouble; 
                             height: gdouble; gap_side: TPositionType) {.
        cdecl.}
    render_check*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                         x: gdouble; y: gdouble; width: gdouble; 
                         height: gdouble) {.cdecl.}
    render_option*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                          x: gdouble; y: gdouble; width: gdouble; 
                          height: gdouble) {.cdecl.}
    render_arrow*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                         angle: gdouble; x: gdouble; y: gdouble; size: gdouble) {.
        cdecl.}
    render_expander*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                            x: gdouble; y: gdouble; width: gdouble; 
                            height: gdouble) {.cdecl.}
    render_focus*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                         x: gdouble; y: gdouble; width: gdouble; 
                         height: gdouble) {.cdecl.}
    render_layout*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                          x: gdouble; y: gdouble; layout: Playout) {.
        cdecl.}
    render_slider*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                          x: gdouble; y: gdouble; width: gdouble; 
                          height: gdouble; orientation: TOrientation) {.
        cdecl.}
    render_handle*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                          x: gdouble; y: gdouble; width: gdouble; 
                          height: gdouble) {.cdecl.}
    render_activity*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                            x: gdouble; y: gdouble; width: gdouble; 
                            height: gdouble) {.cdecl.}
    render_icon_pixbuf*: proc (engine: PThemingEngine; 
                               source: PIconSource; size: TIconSize): PPixbuf {.
        cdecl.}
    render_icon*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                        pixbuf: PPixbuf; x: gdouble; y: gdouble) {.cdecl.}
    render_icon_surface*: proc (engine: PThemingEngine; cr: cairo.Pcontext; 
                                surface: Psurface; x: gdouble; 
                                y: gdouble) {.cdecl.}
    padding*: array[14, gpointer]

proc theming_engine_get_type*(): GType {.cdecl, 
    importc: "gtk_theming_engine_get_type", dynlib: lib.}
proc theming_engine_register_property*(name_space: CSTRING; 
    parse_func: TStylePropertyParser; pspec: PGParamSpec) {.cdecl, 
    importc: "gtk_theming_engine_register_property", dynlib: lib.}
proc get_property*(engine: PThemingEngine; 
                                      property: CSTRING; 
                                      state: TStateFlags; value: PGValue) {.
    cdecl, importc: "gtk_theming_engine_get_property", dynlib: lib.}
proc get_valist*(engine: PThemingEngine; 
                                    state: TStateFlags; args: va_list) {.
    cdecl, importc: "gtk_theming_engine_get_valist", dynlib: lib.}
proc get*(engine: PThemingEngine; 
                             state: TStateFlags) {.varargs, cdecl, 
    importc: "gtk_theming_engine_get", dynlib: lib.}
proc get_style_property*(engine: PThemingEngine; 
    property_name: CSTRING; value: PGValue) {.cdecl, 
    importc: "gtk_theming_engine_get_style_property", dynlib: lib.}
proc get_style_valist*(engine: PThemingEngine; 
    args: va_list) {.cdecl, importc: "gtk_theming_engine_get_style_valist", 
                     dynlib: lib.}
proc get_style*(engine: PThemingEngine) {.varargs, 
    cdecl, importc: "gtk_theming_engine_get_style", dynlib: lib.}
proc lookup_color*(engine: PThemingEngine; 
                                      color_name: CSTRING; 
                                      color: PRGBA): gboolean {.cdecl, 
    importc: "gtk_theming_engine_lookup_color", dynlib: lib.}
proc get_path*(engine: PThemingEngine): PWidgetPath {.
    cdecl, importc: "gtk_theming_engine_get_path", dynlib: lib.}
proc has_class*(engine: PThemingEngine; 
                                   style_class: CSTRING): gboolean {.cdecl, 
    importc: "gtk_theming_engine_has_class", dynlib: lib.}
proc has_region*(engine: PThemingEngine; 
                                    style_region: CSTRING; 
                                    flags: var TRegionFlags): gboolean {.
    cdecl, importc: "gtk_theming_engine_has_region", dynlib: lib.}
proc get_state*(engine: PThemingEngine): TStateFlags {.
    cdecl, importc: "gtk_theming_engine_get_state", dynlib: lib.}
proc state_is_running*(engine: PThemingEngine; 
    state: TStateType; progress: Pgdouble): gboolean {.cdecl, 
    importc: "gtk_theming_engine_state_is_running", dynlib: lib.}
proc get_direction*(engine: PThemingEngine): TTextDirection {.
    cdecl, importc: "gtk_theming_engine_get_direction", dynlib: lib.}
proc get_junction_sides*(engine: PThemingEngine): TJunctionSides {.
    cdecl, importc: "gtk_theming_engine_get_junction_sides", dynlib: lib.}
proc get_color*(engine: PThemingEngine; 
                                   state: TStateFlags; color: PRGBA) {.
    cdecl, importc: "gtk_theming_engine_get_color", dynlib: lib.}
proc get_background_color*(engine: PThemingEngine; 
    state: TStateFlags; color: PRGBA) {.cdecl, 
    importc: "gtk_theming_engine_get_background_color", dynlib: lib.}
proc get_border_color*(engine: PThemingEngine; 
    state: TStateFlags; color: PRGBA) {.cdecl, 
    importc: "gtk_theming_engine_get_border_color", dynlib: lib.}
proc get_border*(engine: PThemingEngine; 
                                    state: TStateFlags; 
                                    border: PBorder) {.cdecl, 
    importc: "gtk_theming_engine_get_border", dynlib: lib.}
proc get_padding*(engine: PThemingEngine; 
                                     state: TStateFlags; 
                                     padding: PBorder) {.cdecl, 
    importc: "gtk_theming_engine_get_padding", dynlib: lib.}
proc get_margin*(engine: PThemingEngine; 
                                    state: TStateFlags; 
                                    margin: PBorder) {.cdecl, 
    importc: "gtk_theming_engine_get_margin", dynlib: lib.}
proc get_font*(engine: PThemingEngine; 
                                  state: TStateFlags): PFontDescription {.
    cdecl, importc: "gtk_theming_engine_get_font", dynlib: lib.}
proc theming_engine_load*(name: CSTRING): PThemingEngine {.cdecl, 
    importc: "gtk_theming_engine_load", dynlib: lib.}
proc get_screen*(engine: PThemingEngine): PGdkScreen {.
    cdecl, importc: "gtk_theming_engine_get_screen", dynlib: lib.}

template TYPE_TOOLBAR*(): expr = 
  (gtk_toolbar_get_type())

template TOOLBAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TOOLBAR, TToolbar))

template TOOLBAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TOOLBAR, TToolbarClass))

template IS_TOOLBAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TOOLBAR))

template IS_TOOLBAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TOOLBAR))

template TOOLBAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TOOLBAR, TToolbarClass))

type 
  TToolbarSpaceStyle* {.size: sizeof(cint).} = enum 
    TOOLBAR_SPACE_EMPTY, TOOLBAR_SPACE_LINE
type 
  PToolbar* = ptr TToolbar
  TToolbar* = object of TContainer
    priv126: PToolbarPrivate

type 
  PToolbarClass* = ptr TToolbarClass
  TToolbarClass* = object of TContainerClass
    orientation_changed*: proc (toolbar: PToolbar; 
                                orientation: TOrientation) {.cdecl.}
    style_changed*: proc (toolbar: PToolbar; style: TToolbarStyle) {.
        cdecl.}
    popup_context_menu*: proc (toolbar: PToolbar; x: gint; y: gint; 
                               button_number: gint): gboolean {.cdecl.}
    ugtk_reserved1261*: proc () {.cdecl.}
    ugtk_reserved1262*: proc () {.cdecl.}
    ugtk_reserved1263*: proc () {.cdecl.}
    ugtk_reserved1264*: proc () {.cdecl.}

proc toolbar_get_type*(): GType {.cdecl, importc: "gtk_toolbar_get_type", 
                                      dynlib: lib.}
proc toolbar_new*(): PWidget {.cdecl, importc: "gtk_toolbar_new", 
    dynlib: lib.}
proc insert*(toolbar: PToolbar; item: PToolItem; 
                         pos: gint) {.cdecl, importc: "gtk_toolbar_insert", 
                                      dynlib: lib.}
proc get_item_index*(toolbar: PToolbar; 
                                 item: PToolItem): gint {.cdecl, 
    importc: "gtk_toolbar_get_item_index", dynlib: lib.}
proc get_n_items*(toolbar: PToolbar): gint {.cdecl, 
    importc: "gtk_toolbar_get_n_items", dynlib: lib.}
proc get_nth_item*(toolbar: PToolbar; n: gint): PToolItem {.
    cdecl, importc: "gtk_toolbar_get_nth_item", dynlib: lib.}
proc get_show_arrow*(toolbar: PToolbar): gboolean {.cdecl, 
    importc: "gtk_toolbar_get_show_arrow", dynlib: lib.}
proc set_show_arrow*(toolbar: PToolbar; show_arrow: gboolean) {.
    cdecl, importc: "gtk_toolbar_set_show_arrow", dynlib: lib.}
proc get_style*(toolbar: PToolbar): TToolbarStyle {.cdecl, 
    importc: "gtk_toolbar_get_style", dynlib: lib.}
proc set_style*(toolbar: PToolbar; style: TToolbarStyle) {.
    cdecl, importc: "gtk_toolbar_set_style", dynlib: lib.}
proc unset_style*(toolbar: PToolbar) {.cdecl, 
    importc: "gtk_toolbar_unset_style", dynlib: lib.}
proc get_icon_size*(toolbar: PToolbar): TIconSize {.cdecl, 
    importc: "gtk_toolbar_get_icon_size", dynlib: lib.}
proc set_icon_size*(toolbar: PToolbar; 
                                icon_size: TIconSize) {.cdecl, 
    importc: "gtk_toolbar_set_icon_size", dynlib: lib.}
proc unset_icon_size*(toolbar: PToolbar) {.cdecl, 
    importc: "gtk_toolbar_unset_icon_size", dynlib: lib.}
proc get_relief_style*(toolbar: PToolbar): TReliefStyle {.
    cdecl, importc: "gtk_toolbar_get_relief_style", dynlib: lib.}
proc get_drop_index*(toolbar: PToolbar; x: gint; y: gint): gint {.
    cdecl, importc: "gtk_toolbar_get_drop_index", dynlib: lib.}
proc set_drop_highlight_item*(toolbar: PToolbar; 
    tool_item: PToolItem; index: gint) {.cdecl, 
    importc: "gtk_toolbar_set_drop_highlight_item", dynlib: lib.}

template TYPE_TOOL_ITEM_GROUP*(): expr = 
  (gtk_tool_item_group_get_type())

template TOOL_ITEM_GROUP_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST(obj, TYPE_TOOL_ITEM_GROUP, TToolItemGroup))

template TOOL_ITEM_GROUP_CLASS*(cls: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST(cls, TYPE_TOOL_ITEM_GROUP, 
                           TToolItemGroupClass))

template IS_TOOL_ITEM_GROUP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE(obj, TYPE_TOOL_ITEM_GROUP))

template IS_TOOL_ITEM_GROUP_CLASS*(obj: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE(obj, TYPE_TOOL_ITEM_GROUP))

template TOOL_ITEM_GROUP_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TOOL_ITEM_GROUP, 
                             TToolItemGroupClass))

type 
  PToolItemGroup* = ptr TToolItemGroup
  TToolItemGroup* = object of TContainer
    priv127: PToolItemGroupPrivate

type 
  PToolItemGroupClass* = ptr TToolItemGroupClass
  TToolItemGroupClass* = object of TContainerClass
    ugtk_reserved1271*: proc () {.cdecl.}
    ugtk_reserved1272*: proc () {.cdecl.}
    ugtk_reserved1273*: proc () {.cdecl.}
    ugtk_reserved1274*: proc () {.cdecl.}

proc tool_item_group_get_type*(): GType {.cdecl, 
    importc: "gtk_tool_item_group_get_type", dynlib: lib.}
proc tool_item_group_new*(label: CSTRING): PWidget {.cdecl, 
    importc: "gtk_tool_item_group_new", dynlib: lib.}
proc set_label*(group: PToolItemGroup; 
                                    label: CSTRING) {.cdecl, 
    importc: "gtk_tool_item_group_set_label", dynlib: lib.}
proc set_label_widget*(group: PToolItemGroup; 
    label_widget: PWidget) {.cdecl, importc: "gtk_tool_item_group_set_label_widget", 
                                   dynlib: lib.}
proc set_collapsed*(group: PToolItemGroup; 
    collapsed: gboolean) {.cdecl, 
                           importc: "gtk_tool_item_group_set_collapsed", 
                           dynlib: lib.}
proc set_ellipsize*(group: PToolItemGroup; 
    ellipsize: TEllipsizeMode) {.cdecl, importc: "gtk_tool_item_group_set_ellipsize", 
                                     dynlib: lib.}
proc set_header_relief*(group: PToolItemGroup; 
    style: TReliefStyle) {.cdecl, importc: "gtk_tool_item_group_set_header_relief", 
                             dynlib: lib.}
proc get_label*(group: PToolItemGroup): CSTRING {.
    cdecl, importc: "gtk_tool_item_group_get_label", dynlib: lib.}
proc get_label_widget*(group: PToolItemGroup): PWidget {.
    cdecl, importc: "gtk_tool_item_group_get_label_widget", dynlib: lib.}
proc get_collapsed*(group: PToolItemGroup): gboolean {.
    cdecl, importc: "gtk_tool_item_group_get_collapsed", dynlib: lib.}
proc get_ellipsize*(group: PToolItemGroup): TEllipsizeMode {.
    cdecl, importc: "gtk_tool_item_group_get_ellipsize", dynlib: lib.}
proc get_header_relief*(group: PToolItemGroup): TReliefStyle {.
    cdecl, importc: "gtk_tool_item_group_get_header_relief", dynlib: lib.}
proc insert*(group: PToolItemGroup; 
                                 item: PToolItem; position: gint) {.
    cdecl, importc: "gtk_tool_item_group_insert", dynlib: lib.}
proc set_item_position*(group: PToolItemGroup; 
    item: PToolItem; position: gint) {.cdecl, 
    importc: "gtk_tool_item_group_set_item_position", dynlib: lib.}
proc get_item_position*(group: PToolItemGroup; 
    item: PToolItem): gint {.cdecl, importc: "gtk_tool_item_group_get_item_position", 
                                   dynlib: lib.}
proc get_n_items*(group: PToolItemGroup): guint {.
    cdecl, importc: "gtk_tool_item_group_get_n_items", dynlib: lib.}
proc get_nth_item*(group: PToolItemGroup; 
    index: guint): PToolItem {.cdecl, importc: "gtk_tool_item_group_get_nth_item", 
                                     dynlib: lib.}
proc get_drop_item*(group: PToolItemGroup; x: gint; 
    y: gint): PToolItem {.cdecl, 
                                importc: "gtk_tool_item_group_get_drop_item", 
                                dynlib: lib.}

template TYPE_TOOL_PALETTE*(): expr = 
  (gtk_tool_palette_get_type())

template TOOL_PALETTE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST(obj, TYPE_TOOL_PALETTE, TToolPalette))

template TOOL_PALETTE_CLASS_TEMPLATE*(cls: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST(cls, TYPE_TOOL_PALETTE, TToolPaletteClass))

template IS_TOOL_PALETTE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE(obj, TYPE_TOOL_PALETTE))

template IS_TOOL_PALETTE_CLASS*(obj: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE(obj, TYPE_TOOL_PALETTE))

template TOOL_PALETTE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TOOL_PALETTE, TToolPaletteClass))

type 
  TToolPaletteDragTargets* {.size: sizeof(cint).} = enum 
    TOOL_PALETTE_DRAG_ITEMS = (1 shl 0), 
    TOOL_PALETTE_DRAG_GROUPS = (1 shl 1)
type 
  PToolPalette* = ptr TToolPalette
  TToolPalette* = object of TContainer
    priv128: PToolPalettePrivate

type 
  PToolPaletteClass* = ptr TToolPaletteClass
  TToolPaletteClass* = object of TContainerClass
    ugtk_reserved1281*: proc () {.cdecl.}
    ugtk_reserved1282*: proc () {.cdecl.}
    ugtk_reserved1283*: proc () {.cdecl.}
    ugtk_reserved1284*: proc () {.cdecl.}

proc tool_palette_get_type*(): GType {.cdecl, 
    importc: "gtk_tool_palette_get_type", dynlib: lib.}
proc tool_palette_new*(): PWidget {.cdecl, 
    importc: "gtk_tool_palette_new", dynlib: lib.}
proc set_group_position*(palette: PToolPalette; 
    group: PToolItemGroup; position: gint) {.cdecl, 
    importc: "gtk_tool_palette_set_group_position", dynlib: lib.}
proc set_exclusive*(palette: PToolPalette; 
                                     group: PToolItemGroup; 
                                     exclusive: gboolean) {.cdecl, 
    importc: "gtk_tool_palette_set_exclusive", dynlib: lib.}
proc set_expand*(palette: PToolPalette; 
                                  group: PToolItemGroup; 
                                  expand: gboolean) {.cdecl, 
    importc: "gtk_tool_palette_set_expand", dynlib: lib.}
proc get_group_position*(palette: PToolPalette; 
    group: PToolItemGroup): gint {.cdecl, 
    importc: "gtk_tool_palette_get_group_position", dynlib: lib.}
proc get_exclusive*(palette: PToolPalette; 
                                     group: PToolItemGroup): gboolean {.
    cdecl, importc: "gtk_tool_palette_get_exclusive", dynlib: lib.}
proc get_expand*(palette: PToolPalette; 
                                  group: PToolItemGroup): gboolean {.
    cdecl, importc: "gtk_tool_palette_get_expand", dynlib: lib.}
proc set_icon_size*(palette: PToolPalette; 
                                     icon_size: TIconSize) {.cdecl, 
    importc: "gtk_tool_palette_set_icon_size", dynlib: lib.}
proc unset_icon_size*(palette: PToolPalette) {.cdecl, 
    importc: "gtk_tool_palette_unset_icon_size", dynlib: lib.}
proc set_style*(palette: PToolPalette; 
                                 style: TToolbarStyle) {.cdecl, 
    importc: "gtk_tool_palette_set_style", dynlib: lib.}
proc unset_style*(palette: PToolPalette) {.cdecl, 
    importc: "gtk_tool_palette_unset_style", dynlib: lib.}
proc get_icon_size*(palette: PToolPalette): TIconSize {.
    cdecl, importc: "gtk_tool_palette_get_icon_size", dynlib: lib.}
proc get_style*(palette: PToolPalette): TToolbarStyle {.
    cdecl, importc: "gtk_tool_palette_get_style", dynlib: lib.}
proc get_drop_item*(palette: PToolPalette; x: gint; 
                                     y: gint): PToolItem {.cdecl, 
    importc: "gtk_tool_palette_get_drop_item", dynlib: lib.}
proc get_drop_group*(palette: PToolPalette; x: gint; 
                                      y: gint): PToolItemGroup {.cdecl, 
    importc: "gtk_tool_palette_get_drop_group", dynlib: lib.}
proc get_drag_item*(palette: PToolPalette; 
                                     selection: PSelectionData): PWidget {.
    cdecl, importc: "gtk_tool_palette_get_drag_item", dynlib: lib.}
proc set_drag_source*(palette: PToolPalette; 
    targets: TToolPaletteDragTargets) {.cdecl, 
    importc: "gtk_tool_palette_set_drag_source", dynlib: lib.}
proc add_drag_dest*(palette: PToolPalette; 
                                     widget: PWidget; 
                                     flags: TDestDefaults; 
                                     targets: TToolPaletteDragTargets; 
                                     actions: TDragAction) {.cdecl, 
    importc: "gtk_tool_palette_add_drag_dest", dynlib: lib.}
proc get_hadjustment*(palette: PToolPalette): PAdjustment {.
    cdecl, importc: "gtk_tool_palette_get_hadjustment", dynlib: lib.}
proc get_vadjustment*(palette: PToolPalette): PAdjustment {.
    cdecl, importc: "gtk_tool_palette_get_vadjustment", dynlib: lib.}
proc tool_palette_get_drag_target_item*(): PTargetEntry {.cdecl, 
    importc: "gtk_tool_palette_get_drag_target_item", dynlib: lib.}
proc tool_palette_get_drag_target_group*(): PTargetEntry {.cdecl, 
    importc: "gtk_tool_palette_get_drag_target_group", dynlib: lib.}

template TYPE_TOOL_SHELL*(): expr = 
  (gtk_tool_shell_get_type())

template TOOL_SHELL_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TOOL_SHELL, TToolShell))

template IS_TOOL_SHELL*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TOOL_SHELL))

template TOOL_SHELL_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_TOOL_SHELL, TToolShellIface))

type 
  PToolShellIface* = ptr TToolShellIface
  TToolShellIface* = object of TGTypeInterface
    get_icon_size*: proc (shell: PToolShell): TIconSize {.cdecl.}
    get_orientation*: proc (shell: PToolShell): TOrientation {.cdecl.}
    get_style*: proc (shell: PToolShell): TToolbarStyle {.cdecl.}
    get_relief_style*: proc (shell: PToolShell): TReliefStyle {.cdecl.}
    rebuild_menu*: proc (shell: PToolShell) {.cdecl.}
    get_text_orientation*: proc (shell: PToolShell): TOrientation {.
        cdecl.}
    get_text_alignment*: proc (shell: PToolShell): gfloat {.cdecl.}
    get_ellipsize_mode*: proc (shell: PToolShell): TEllipsizeMode {.
        cdecl.}
    get_text_size_group*: proc (shell: PToolShell): PSizeGroup {.
        cdecl.}

proc tool_shell_get_type*(): GType {.cdecl, 
    importc: "gtk_tool_shell_get_type", dynlib: lib.}
proc get_icon_size*(shell: PToolShell): TIconSize {.
    cdecl, importc: "gtk_tool_shell_get_icon_size", dynlib: lib.}
proc get_orientation*(shell: PToolShell): TOrientation {.
    cdecl, importc: "gtk_tool_shell_get_orientation", dynlib: lib.}
proc get_style*(shell: PToolShell): TToolbarStyle {.
    cdecl, importc: "gtk_tool_shell_get_style", dynlib: lib.}
proc get_relief_style*(shell: PToolShell): TReliefStyle {.
    cdecl, importc: "gtk_tool_shell_get_relief_style", dynlib: lib.}
proc rebuild_menu*(shell: PToolShell) {.cdecl, 
    importc: "gtk_tool_shell_rebuild_menu", dynlib: lib.}
proc get_text_orientation*(shell: PToolShell): TOrientation {.
    cdecl, importc: "gtk_tool_shell_get_text_orientation", dynlib: lib.}
proc get_text_alignment*(shell: PToolShell): gfloat {.
    cdecl, importc: "gtk_tool_shell_get_text_alignment", dynlib: lib.}
proc get_ellipsize_mode*(shell: PToolShell): TEllipsizeMode {.
    cdecl, importc: "gtk_tool_shell_get_ellipsize_mode", dynlib: lib.}
proc get_text_size_group*(shell: PToolShell): PSizeGroup {.
    cdecl, importc: "gtk_tool_shell_get_text_size_group", dynlib: lib.}

proc test_init*(argcp: var cint; argvp: var cstringArray) {.varargs, 
    cdecl, importc: "gtk_test_init", dynlib: lib.}
proc test_register_all_types*() {.cdecl, 
                                      importc: "gtk_test_register_all_types", 
                                      dynlib: lib.}
proc test_list_all_types*(n_types: Pguint): PGType {.cdecl, 
    importc: "gtk_test_list_all_types", dynlib: lib.}
proc test_find_widget*(widget: PWidget; label_pattern: CSTRING; 
                           widget_type: GType): PWidget {.cdecl, 
    importc: "gtk_test_find_widget", dynlib: lib.}
proc test_create_widget*(widget_type: GType; 
                             first_property_name: CSTRING): PWidget {.
    varargs, cdecl, importc: "gtk_test_create_widget", dynlib: lib.}
proc test_create_simple_window*(window_title: CSTRING; 
                                    dialog_text: CSTRING): PWidget {.
    cdecl, importc: "gtk_test_create_simple_window", dynlib: lib.}
proc test_display_button_window*(window_title: CSTRING; 
                                     dialog_text: CSTRING): PWidget {.
    varargs, cdecl, importc: "gtk_test_display_button_window", dynlib: lib.}
proc test_slider_set_perc*(widget: PWidget; percentage: cdouble) {.
    cdecl, importc: "gtk_test_slider_set_perc", dynlib: lib.}
proc test_slider_get_value*(widget: PWidget): cdouble {.cdecl, 
    importc: "gtk_test_slider_get_value", dynlib: lib.}
proc test_spin_button_click*(spinner: PSpinButton; button: guint; 
                                 upwards: gboolean): gboolean {.cdecl, 
    importc: "gtk_test_spin_button_click", dynlib: lib.}
proc test_widget_wait_for_draw*(widget: PWidget) {.cdecl, 
    importc: "gtk_test_widget_wait_for_draw", dynlib: lib.}
proc test_widget_click*(widget: PWidget; button: guint; 
                            modifiers: gdk3.TModifierType): gboolean {.cdecl, 
    importc: "gtk_test_widget_click", dynlib: lib.}
proc test_widget_send_key*(widget: PWidget; keyval: guint; 
                               modifiers: gdk3.TModifierType): gboolean {.cdecl, 
    importc: "gtk_test_widget_send_key", dynlib: lib.}
proc test_text_set*(widget: PWidget; string: CSTRING) {.cdecl, 
    importc: "gtk_test_text_set", dynlib: lib.}
proc test_text_get*(widget: PWidget): CSTRING {.cdecl, 
    importc: "gtk_test_text_get", dynlib: lib.}
proc test_find_sibling*(base_widget: PWidget; widget_type: GType): PWidget {.
    cdecl, importc: "gtk_test_find_sibling", dynlib: lib.}
proc test_find_label*(widget: PWidget; label_pattern: CSTRING): PWidget {.
    cdecl, importc: "gtk_test_find_label", dynlib: lib.}

template TYPE_TREE_DRAG_SOURCE*(): expr = 
  (gtk_tree_drag_source_get_type())

template TREE_DRAG_SOURCE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_DRAG_SOURCE, 
                              TTreeDragSource))

template IS_TREE_DRAG_SOURCE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_DRAG_SOURCE))

template TREE_DRAG_SOURCE_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_TREE_DRAG_SOURCE, 
                                 TTreeDragSourceIface))

type 
  PTreeDragSourceIface* = ptr TTreeDragSourceIface
  TTreeDragSourceIface* = object of TGTypeInterface
    row_draggable*: proc (drag_source: PTreeDragSource; 
                          path: PTreePath): gboolean {.cdecl.}
    drag_data_get*: proc (drag_source: PTreeDragSource; 
                          path: PTreePath; 
                          selection_data: PSelectionData): gboolean {.
        cdecl.}
    drag_data_delete*: proc (drag_source: PTreeDragSource; 
                             path: PTreePath): gboolean {.cdecl.}

proc tree_drag_source_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_drag_source_get_type", dynlib: lib.}
proc row_draggable*(drag_source: PTreeDragSource; 
    path: PTreePath): gboolean {.cdecl, 
    importc: "gtk_tree_drag_source_row_draggable", dynlib: lib.}
proc drag_data_delete*(
    drag_source: PTreeDragSource; path: PTreePath): gboolean {.
    cdecl, importc: "gtk_tree_drag_source_drag_data_delete", dynlib: lib.}
proc drag_data_get*(drag_source: PTreeDragSource; 
    path: PTreePath; selection_data: PSelectionData): gboolean {.
    cdecl, importc: "gtk_tree_drag_source_drag_data_get", dynlib: lib.}
template TYPE_TREE_DRAG_DEST*(): expr = 
  (gtk_tree_drag_dest_get_type())

template TREE_DRAG_DEST_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_DRAG_DEST, TTreeDragDest))

template IS_TREE_DRAG_DEST*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_DRAG_DEST))

template TREE_DRAG_DEST_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_TREE_DRAG_DEST, 
                                 TTreeDragDestIface))

type 
  PTreeDragDestIface* = ptr TTreeDragDestIface
  TTreeDragDestIface* = object of TGTypeInterface
    drag_data_received*: proc (drag_dest: PTreeDragDest; 
                               dest: PTreePath; 
                               selection_data: PSelectionData): gboolean {.
        cdecl.}
    row_drop_possible*: proc (drag_dest: PTreeDragDest; 
                              dest_path: PTreePath; 
                              selection_data: PSelectionData): gboolean {.
        cdecl.}

proc tree_drag_dest_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_drag_dest_get_type", dynlib: lib.}
proc drag_data_received*(drag_dest: PTreeDragDest; 
    dest: PTreePath; selection_data: PSelectionData): gboolean {.
    cdecl, importc: "gtk_tree_drag_dest_drag_data_received", dynlib: lib.}
proc row_drop_possible*(drag_dest: PTreeDragDest; 
    dest_path: PTreePath; selection_data: PSelectionData): gboolean {.
    cdecl, importc: "gtk_tree_drag_dest_row_drop_possible", dynlib: lib.}
proc tree_set_row_drag_data*(selection_data: PSelectionData; 
                                 tree_model: PTreeModel; 
                                 path: PTreePath): gboolean {.cdecl, 
    importc: "gtk_tree_set_row_drag_data", dynlib: lib.}
proc tree_get_row_drag_data*(selection_data: PSelectionData; 
                                 tree_model: ptr PTreeModel; 
                                 path: ptr PTreePath): gboolean {.cdecl, 
    importc: "gtk_tree_get_row_drag_data", dynlib: lib.}

template TYPE_TREE_MODEL_SORT*(): expr = 
  (gtk_tree_model_sort_get_type())

template TREE_MODEL_SORT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_MODEL_SORT, 
                              TTreeModelSort))

template TREE_MODEL_SORT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TREE_MODEL_SORT, 
                           TTreeModelSortClass))

template IS_TREE_MODEL_SORT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_MODEL_SORT))

template IS_TREE_MODEL_SORT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TREE_MODEL_SORT))

template TREE_MODEL_SORT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TREE_MODEL_SORT, 
                             TTreeModelSortClass))

type 
  PTreeModelSort* = ptr TTreeModelSort
  TTreeModelSort* = object of TGObject
    priv129: PTreeModelSortPrivate

type 
  PTreeModelSortClass* = ptr TTreeModelSortClass
  TTreeModelSortClass* = object of TGObjectClass
    ugtk_reserved1291*: proc () {.cdecl.}
    ugtk_reserved1292*: proc () {.cdecl.}
    ugtk_reserved1293*: proc () {.cdecl.}
    ugtk_reserved1294*: proc () {.cdecl.}

proc tree_model_sort_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_model_sort_get_type", dynlib: lib.}
proc sort_new_with_model*(child_model: PTreeModel): PTreeModel {.
    cdecl, importc: "gtk_tree_model_sort_new_with_model", dynlib: lib.}
proc get_model*(tree_model: PTreeModelSort): PTreeModel {.
    cdecl, importc: "gtk_tree_model_sort_get_model", dynlib: lib.}
proc convert_child_path_to_path*(
    tree_model_sort: PTreeModelSort; child_path: PTreePath): PTreePath {.
    cdecl, importc: "gtk_tree_model_sort_convert_child_path_to_path", 
    dynlib: lib.}
proc convert_child_iter_to_iter*(
    tree_model_sort: PTreeModelSort; sort_iter: PTreeIter; 
    child_iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_model_sort_convert_child_iter_to_iter", dynlib: lib.}
proc convert_path_to_child_path*(
    tree_model_sort: PTreeModelSort; sorted_path: PTreePath): PTreePath {.
    cdecl, importc: "gtk_tree_model_sort_convert_path_to_child_path", 
    dynlib: lib.}
proc convert_iter_to_child_iter*(
    tree_model_sort: PTreeModelSort; child_iter: PTreeIter; 
    sorted_iter: PTreeIter) {.cdecl, importc: "gtk_tree_model_sort_convert_iter_to_child_iter", 
                                    dynlib: lib.}
proc reset_default_sort_func*(
    tree_model_sort: PTreeModelSort) {.cdecl, 
    importc: "gtk_tree_model_sort_reset_default_sort_func", dynlib: lib.}
proc clear_cache*(tree_model_sort: PTreeModelSort) {.
    cdecl, importc: "gtk_tree_model_sort_clear_cache", dynlib: lib.}
proc iter_is_valid*(tree_model_sort: PTreeModelSort; 
    iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_model_sort_iter_is_valid", dynlib: lib.}

template TYPE_TREE_SELECTION*(): expr = 
  (gtk_tree_selection_get_type())

template TREE_SELECTION_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_SELECTION, TTreeSelection))

template TREE_SELECTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TREE_SELECTION, 
                           TTreeSelectionClass))

template IS_TREE_SELECTION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_SELECTION))

template IS_TREE_SELECTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TREE_SELECTION))

template TREE_SELECTION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TREE_SELECTION, 
                             TTreeSelectionClass))

type 
  TTreeSelectionFunc* = proc (selection: PTreeSelection; 
                                model: PTreeModel; 
                                path: PTreePath; 
                                path_currently_selected: gboolean; 
                                data: gpointer): gboolean {.cdecl.}
type 
  TTreeSelectionForeachFunc* = proc (model: PTreeModel; 
      path: PTreePath; iter: PTreeIter; data: gpointer) {.cdecl.}
proc tree_selection_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_selection_get_type", dynlib: lib.}
proc set_mode*(selection: PTreeSelection; 
                                  typ: TSelectionMode) {.cdecl, 
    importc: "gtk_tree_selection_set_mode", dynlib: lib.}
proc get_mode*(selection: PTreeSelection): TSelectionMode {.
    cdecl, importc: "gtk_tree_selection_get_mode", dynlib: lib.}
proc set_select_function*(selection: PTreeSelection; 
    func: TTreeSelectionFunc; data: gpointer; destroy: TGDestroyNotify) {.
    cdecl, importc: "gtk_tree_selection_set_select_function", dynlib: lib.}
proc get_user_data*(selection: PTreeSelection): gpointer {.
    cdecl, importc: "gtk_tree_selection_get_user_data", dynlib: lib.}
proc get_tree_view*(selection: PTreeSelection): PTreeView {.
    cdecl, importc: "gtk_tree_selection_get_tree_view", dynlib: lib.}
proc get_select_function*(selection: PTreeSelection): TTreeSelectionFunc {.
    cdecl, importc: "gtk_tree_selection_get_select_function", dynlib: lib.}
proc get_selected*(selection: PTreeSelection; 
                                      model: ptr PTreeModel; 
                                      iter: PTreeIter): gboolean {.
    cdecl, importc: "gtk_tree_selection_get_selected", dynlib: lib.}
proc get_selected_rows*(selection: PTreeSelection; 
    model: ptr PTreeModel): PGList {.cdecl, 
    importc: "gtk_tree_selection_get_selected_rows", dynlib: lib.}
proc count_selected_rows*(selection: PTreeSelection): gint {.
    cdecl, importc: "gtk_tree_selection_count_selected_rows", dynlib: lib.}
proc selected_foreach*(selection: PTreeSelection; 
    func: TTreeSelectionForeachFunc; data: gpointer) {.cdecl, 
    importc: "gtk_tree_selection_selected_foreach", dynlib: lib.}
proc select_path*(selection: PTreeSelection; 
                                     path: PTreePath) {.cdecl, 
    importc: "gtk_tree_selection_select_path", dynlib: lib.}
proc unselect_path*(selection: PTreeSelection; 
    path: PTreePath) {.cdecl, 
                             importc: "gtk_tree_selection_unselect_path", 
                             dynlib: lib.}
proc select_iter*(selection: PTreeSelection; 
                                     iter: PTreeIter) {.cdecl, 
    importc: "gtk_tree_selection_select_iter", dynlib: lib.}
proc unselect_iter*(selection: PTreeSelection; 
    iter: PTreeIter) {.cdecl, 
                             importc: "gtk_tree_selection_unselect_iter", 
                             dynlib: lib.}
proc path_is_selected*(selection: PTreeSelection; 
    path: PTreePath): gboolean {.cdecl, 
    importc: "gtk_tree_selection_path_is_selected", dynlib: lib.}
proc iter_is_selected*(selection: PTreeSelection; 
    iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_selection_iter_is_selected", dynlib: lib.}
proc select_all*(selection: PTreeSelection) {.cdecl, 
    importc: "gtk_tree_selection_select_all", dynlib: lib.}
proc unselect_all*(selection: PTreeSelection) {.
    cdecl, importc: "gtk_tree_selection_unselect_all", dynlib: lib.}
proc select_range*(selection: PTreeSelection; 
                                      start_path: PTreePath; 
                                      end_path: PTreePath) {.cdecl, 
    importc: "gtk_tree_selection_select_range", dynlib: lib.}
proc unselect_range*(selection: PTreeSelection; 
    start_path: PTreePath; end_path: PTreePath) {.cdecl, 
    importc: "gtk_tree_selection_unselect_range", dynlib: lib.}

template TYPE_TREE_STORE*(): expr = 
  (gtk_tree_store_get_type())

template TREE_STORE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TREE_STORE, TTreeStore))

template TREE_STORE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TREE_STORE, TTreeStoreClass))

template IS_TREE_STORE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TREE_STORE))

template IS_TREE_STORE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TREE_STORE))

template TREE_STORE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TREE_STORE, TTreeStoreClass))

type 
  PTreeStore* = ptr TTreeStore
  TTreeStore* = object of TGObject
    priv130: PTreeStorePrivate

type 
  PTreeStoreClass* = ptr TTreeStoreClass
  TTreeStoreClass* = object of TGObjectClass
    ugtk_reserved1301*: proc () {.cdecl.}
    ugtk_reserved1302*: proc () {.cdecl.}
    ugtk_reserved1303*: proc () {.cdecl.}
    ugtk_reserved1304*: proc () {.cdecl.}

proc tree_store_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_store_get_type", dynlib: lib.}
proc tree_store_new*(n_columns: gint): PTreeStore {.varargs, cdecl, 
    importc: "gtk_tree_store_new", dynlib: lib.}
proc tree_store_newv*(n_columns: gint; types: PGType): PTreeStore {.
    cdecl, importc: "gtk_tree_store_newv", dynlib: lib.}
proc set_column_types*(tree_store: PTreeStore; 
                                      n_columns: gint; types: PGType) {.
    cdecl, importc: "gtk_tree_store_set_column_types", dynlib: lib.}
proc set_value*(tree_store: PTreeStore; 
                               iter: PTreeIter; column: gint; 
                               value: PGValue) {.cdecl, 
    importc: "gtk_tree_store_set_value", dynlib: lib.}
proc set*(tree_store: PTreeStore; iter: PTreeIter) {.
    varargs, cdecl, importc: "gtk_tree_store_set", dynlib: lib.}
proc set_valuesv*(tree_store: PTreeStore; 
                                 iter: PTreeIter; columns: Pgint; 
                                 values: PGValue; n_values: gint) {.cdecl, 
    importc: "gtk_tree_store_set_valuesv", dynlib: lib.}
proc set_valist*(tree_store: PTreeStore; 
                                iter: PTreeIter; var_args: va_list) {.
    cdecl, importc: "gtk_tree_store_set_valist", dynlib: lib.}
proc remove*(tree_store: PTreeStore; 
                            iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_store_remove", dynlib: lib.}
proc insert*(tree_store: PTreeStore; 
                            iter: PTreeIter; parent: PTreeIter; 
                            position: gint) {.cdecl, 
    importc: "gtk_tree_store_insert", dynlib: lib.}
proc insert_before*(tree_store: PTreeStore; 
                                   iter: PTreeIter; 
                                   parent: PTreeIter; 
                                   sibling: PTreeIter) {.cdecl, 
    importc: "gtk_tree_store_insert_before", dynlib: lib.}
proc insert_after*(tree_store: PTreeStore; 
                                  iter: PTreeIter; 
                                  parent: PTreeIter; 
                                  sibling: PTreeIter) {.cdecl, 
    importc: "gtk_tree_store_insert_after", dynlib: lib.}
proc insert_with_values*(tree_store: PTreeStore; 
    iter: PTreeIter; parent: PTreeIter; position: gint) {.varargs, 
    cdecl, importc: "gtk_tree_store_insert_with_values", dynlib: lib.}
proc insert_with_valuesv*(tree_store: PTreeStore; 
    iter: PTreeIter; parent: PTreeIter; position: gint; 
    columns: Pgint; values: PGValue; n_values: gint) {.cdecl, 
    importc: "gtk_tree_store_insert_with_valuesv", dynlib: lib.}
proc prepend*(tree_store: PTreeStore; 
                             iter: PTreeIter; parent: PTreeIter) {.
    cdecl, importc: "gtk_tree_store_prepend", dynlib: lib.}
proc append*(tree_store: PTreeStore; 
                            iter: PTreeIter; parent: PTreeIter) {.
    cdecl, importc: "gtk_tree_store_append", dynlib: lib.}
proc is_ancestor*(tree_store: PTreeStore; 
                                 iter: PTreeIter; 
                                 descendant: PTreeIter): gboolean {.
    cdecl, importc: "gtk_tree_store_is_ancestor", dynlib: lib.}
proc iter_depth*(tree_store: PTreeStore; 
                                iter: PTreeIter): gint {.cdecl, 
    importc: "gtk_tree_store_iter_depth", dynlib: lib.}
proc clear*(tree_store: PTreeStore) {.cdecl, 
    importc: "gtk_tree_store_clear", dynlib: lib.}
proc iter_is_valid*(tree_store: PTreeStore; 
                                   iter: PTreeIter): gboolean {.cdecl, 
    importc: "gtk_tree_store_iter_is_valid", dynlib: lib.}
proc reorder*(tree_store: PTreeStore; 
                             parent: PTreeIter; new_order: Pgint) {.
    cdecl, importc: "gtk_tree_store_reorder", dynlib: lib.}
proc swap*(tree_store: PTreeStore; a: PTreeIter; 
                          b: PTreeIter) {.cdecl, 
    importc: "gtk_tree_store_swap", dynlib: lib.}
proc move_before*(tree_store: PTreeStore; 
                                 iter: PTreeIter; 
                                 position: PTreeIter) {.cdecl, 
    importc: "gtk_tree_store_move_before", dynlib: lib.}
proc move_after*(tree_store: PTreeStore; 
                                iter: PTreeIter; 
                                position: PTreeIter) {.cdecl, 
    importc: "gtk_tree_store_move_after", dynlib: lib.}

proc license_get_type*(): GType {.cdecl, importc: "gtk_license_get_type", 
                                      dynlib: lib.}
template TYPE_LICENSE*(): expr = 
  (gtk_license_get_type())

proc accel_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_accel_flags_get_type", dynlib: lib.}
template TYPE_ACCEL_FLAGS*(): expr = 
  (gtk_accel_flags_get_type())

proc application_inhibit_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_application_inhibit_flags_get_type", dynlib: lib.}
template TYPE_APPLICATION_INHIBIT_FLAGS*(): expr = 
  (gtk_application_inhibit_flags_get_type())

proc assistant_page_type_get_type*(): GType {.cdecl, 
    importc: "gtk_assistant_page_type_get_type", dynlib: lib.}
template TYPE_ASSISTANT_PAGE_TYPE*(): expr = 
  (gtk_assistant_page_type_get_type())

proc builder_error_get_type*(): GType {.cdecl, 
    importc: "gtk_builder_error_get_type", dynlib: lib.}
template TYPE_BUILDER_ERROR*(): expr = 
  (gtk_builder_error_get_type())

proc calendar_display_options_get_type*(): GType {.cdecl, 
    importc: "gtk_calendar_display_options_get_type", dynlib: lib.}
template TYPE_CALENDAR_DISPLAY_OPTIONS*(): expr = 
  (gtk_calendar_display_options_get_type())

proc cell_renderer_state_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_state_get_type", dynlib: lib.}
template TYPE_CELL_RENDERER_STATE*(): expr = 
  (gtk_cell_renderer_state_get_type())

proc cell_renderer_mode_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_mode_get_type", dynlib: lib.}
template TYPE_CELL_RENDERER_MODE*(): expr = 
  (gtk_cell_renderer_mode_get_type())

proc cell_renderer_accel_mode_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_renderer_accel_mode_get_type", dynlib: lib.}
template TYPE_CELL_RENDERER_ACCEL_MODE*(): expr = 
  (gtk_cell_renderer_accel_mode_get_type())

proc css_provider_error_get_type*(): GType {.cdecl, 
    importc: "gtk_css_provider_error_get_type", dynlib: lib.}
template TYPE_CSS_PROVIDER_ERROR*(): expr = 
  (gtk_css_provider_error_get_type())

proc css_section_type_get_type*(): GType {.cdecl, 
    importc: "gtk_css_section_type_get_type", dynlib: lib.}
template TYPE_CSS_SECTION_TYPE*(): expr = 
  (gtk_css_section_type_get_type())

proc debug_flag_get_type*(): GType {.cdecl, 
    importc: "gtk_debug_flag_get_type", dynlib: lib.}
template TYPE_DEBUG_FLAG*(): expr = 
  (gtk_debug_flag_get_type())

proc dialog_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_dialog_flags_get_type", dynlib: lib.}
template TYPE_DIALOG_FLAGS*(): expr = 
  (gtk_dialog_flags_get_type())

proc response_type_get_type*(): GType {.cdecl, 
    importc: "gtk_response_type_get_type", dynlib: lib.}
template TYPE_RESPONSE_TYPE*(): expr = 
  (gtk_response_type_get_type())

proc dest_defaults_get_type*(): GType {.cdecl, 
    importc: "gtk_dest_defaults_get_type", dynlib: lib.}
template TYPE_DEST_DEFAULTS*(): expr = 
  (gtk_dest_defaults_get_type())

proc target_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_target_flags_get_type", dynlib: lib.}
template TYPE_TARGET_FLAGS*(): expr = 
  (gtk_target_flags_get_type())

proc entry_icon_position_get_type*(): GType {.cdecl, 
    importc: "gtk_entry_icon_position_get_type", dynlib: lib.}
template TYPE_ENTRY_ICON_POSITION*(): expr = 
  (gtk_entry_icon_position_get_type())

proc align_get_type*(): GType {.cdecl, importc: "gtk_align_get_type", 
                                    dynlib: lib.}
template TYPE_ALIGN*(): expr = 
  (gtk_align_get_type())

proc arrow_placement_get_type*(): GType {.cdecl, 
    importc: "gtk_arrow_placement_get_type", dynlib: lib.}
template TYPE_ARROW_PLACEMENT*(): expr = 
  (gtk_arrow_placement_get_type())

proc arrow_type_get_type*(): GType {.cdecl, 
    importc: "gtk_arrow_type_get_type", dynlib: lib.}
template TYPE_ARROW_TYPE*(): expr = 
  (gtk_arrow_type_get_type())

proc attach_options_get_type*(): GType {.cdecl, 
    importc: "gtk_attach_options_get_type", dynlib: lib.}
template TYPE_ATTACH_OPTIONS*(): expr = 
  (gtk_attach_options_get_type())

proc baseline_position_get_type*(): GType {.cdecl, 
    importc: "gtk_baseline_position_get_type", dynlib: lib.}
template TYPE_BASELINE_POSITION*(): expr = 
  (gtk_baseline_position_get_type())

proc button_box_style_get_type*(): GType {.cdecl, 
    importc: "gtk_button_box_style_get_type", dynlib: lib.}
template TYPE_BUTTON_BOX_STYLE*(): expr = 
  (gtk_button_box_style_get_type())

proc delete_type_get_type*(): GType {.cdecl, 
    importc: "gtk_delete_type_get_type", dynlib: lib.}
template TYPE_DELETE_TYPE*(): expr = 
  (gtk_delete_type_get_type())

proc direction_type_get_type*(): GType {.cdecl, 
    importc: "gtk_direction_type_get_type", dynlib: lib.}
template TYPE_DIRECTION_TYPE*(): expr = 
  (gtk_direction_type_get_type())

proc expander_style_get_type*(): GType {.cdecl, 
    importc: "gtk_expander_style_get_type", dynlib: lib.}
template TYPE_EXPANDER_STYLE*(): expr = 
  (gtk_expander_style_get_type())

proc icon_size_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_size_get_type", dynlib: lib.}
template TYPE_ICON_SIZE*(): expr = 
  (gtk_icon_size_get_type())

proc sensitivity_type_get_type*(): GType {.cdecl, 
    importc: "gtk_sensitivity_type_get_type", dynlib: lib.}
template TYPE_SENSITIVITY_TYPE*(): expr = 
  (gtk_sensitivity_type_get_type())

proc text_direction_get_type*(): GType {.cdecl, 
    importc: "gtk_text_direction_get_type", dynlib: lib.}
template TYPE_TEXT_DIRECTION*(): expr = 
  (gtk_text_direction_get_type())

proc justification_get_type*(): GType {.cdecl, 
    importc: "gtk_justification_get_type", dynlib: lib.}
template TYPE_JUSTIFICATION*(): expr = 
  (gtk_justification_get_type())

proc menu_direction_type_get_type*(): GType {.cdecl, 
    importc: "gtk_menu_direction_type_get_type", dynlib: lib.}
template TYPE_MENU_DIRECTION_TYPE*(): expr = 
  (gtk_menu_direction_type_get_type())

proc message_type_get_type*(): GType {.cdecl, 
    importc: "gtk_message_type_get_type", dynlib: lib.}
template TYPE_MESSAGE_TYPE*(): expr = 
  (gtk_message_type_get_type())

proc movement_step_get_type*(): GType {.cdecl, 
    importc: "gtk_movement_step_get_type", dynlib: lib.}
template TYPE_MOVEMENT_STEP*(): expr = 
  (gtk_movement_step_get_type())

proc scroll_step_get_type*(): GType {.cdecl, 
    importc: "gtk_scroll_step_get_type", dynlib: lib.}
template TYPE_SCROLL_STEP*(): expr = 
  (gtk_scroll_step_get_type())

proc orientation_get_type*(): GType {.cdecl, 
    importc: "gtk_orientation_get_type", dynlib: lib.}
template TYPE_ORIENTATION*(): expr = 
  (gtk_orientation_get_type())

proc corner_type_get_type*(): GType {.cdecl, 
    importc: "gtk_corner_type_get_type", dynlib: lib.}
template TYPE_CORNER_TYPE*(): expr = 
  (gtk_corner_type_get_type())

proc pack_type_get_type*(): GType {.cdecl, 
    importc: "gtk_pack_type_get_type", dynlib: lib.}
template TYPE_PACK_TYPE*(): expr = 
  (gtk_pack_type_get_type())

proc path_priority_type_get_type*(): GType {.cdecl, 
    importc: "gtk_path_priority_type_get_type", dynlib: lib.}
template TYPE_PATH_PRIORITY_TYPE*(): expr = 
  (gtk_path_priority_type_get_type())

proc path_type_get_type*(): GType {.cdecl, 
    importc: "gtk_path_type_get_type", dynlib: lib.}
template TYPE_PATH_TYPE*(): expr = 
  (gtk_path_type_get_type())

proc policy_type_get_type*(): GType {.cdecl, 
    importc: "gtk_policy_type_get_type", dynlib: lib.}
template TYPE_POLICY_TYPE*(): expr = 
  (gtk_policy_type_get_type())

proc position_type_get_type*(): GType {.cdecl, 
    importc: "gtk_position_type_get_type", dynlib: lib.}
template TYPE_POSITION_TYPE*(): expr = 
  (gtk_position_type_get_type())

proc relief_style_get_type*(): GType {.cdecl, 
    importc: "gtk_relief_style_get_type", dynlib: lib.}
template TYPE_RELIEF_STYLE*(): expr = 
  (gtk_relief_style_get_type())

proc resize_mode_get_type*(): GType {.cdecl, 
    importc: "gtk_resize_mode_get_type", dynlib: lib.}
template TYPE_RESIZE_MODE*(): expr = 
  (gtk_resize_mode_get_type())

proc scroll_type_get_type*(): GType {.cdecl, 
    importc: "gtk_scroll_type_get_type", dynlib: lib.}
template TYPE_SCROLL_TYPE*(): expr = 
  (gtk_scroll_type_get_type())

proc selection_mode_get_type*(): GType {.cdecl, 
    importc: "gtk_selection_mode_get_type", dynlib: lib.}
template TYPE_SELECTION_MODE*(): expr = 
  (gtk_selection_mode_get_type())

proc shadow_type_get_type*(): GType {.cdecl, 
    importc: "gtk_shadow_type_get_type", dynlib: lib.}
template TYPE_SHADOW_TYPE*(): expr = 
  (gtk_shadow_type_get_type())

proc state_type_get_type*(): GType {.cdecl, 
    importc: "gtk_state_type_get_type", dynlib: lib.}
template TYPE_STATE_TYPE*(): expr = 
  (gtk_state_type_get_type())

proc toolbar_style_get_type*(): GType {.cdecl, 
    importc: "gtk_toolbar_style_get_type", dynlib: lib.}
template TYPE_TOOLBAR_STYLE*(): expr = 
  (gtk_toolbar_style_get_type())

proc window_position_get_type*(): GType {.cdecl, 
    importc: "gtk_window_position_get_type", dynlib: lib.}
template TYPE_WINDOW_POSITION*(): expr = 
  (gtk_window_position_get_type())

proc window_type_get_type*(): GType {.cdecl, 
    importc: "gtk_window_type_get_type", dynlib: lib.}
template TYPE_WINDOW_TYPE*(): expr = 
  (gtk_window_type_get_type())

proc wrap_mode_get_type*(): GType {.cdecl, 
    importc: "gtk_wrap_mode_get_type", dynlib: lib.}
template TYPE_WRAP_MODE*(): expr = 
  (gtk_wrap_mode_get_type())

proc sort_type_get_type*(): GType {.cdecl, 
    importc: "gtk_sort_type_get_type", dynlib: lib.}
template TYPE_SORT_TYPE*(): expr = 
  (gtk_sort_type_get_type())

proc im_preedit_style_get_type*(): GType {.cdecl, 
    importc: "gtk_im_preedit_style_get_type", dynlib: lib.}
template TYPE_IM_PREEDIT_STYLE*(): expr = 
  (gtk_im_preedit_style_get_type())

proc im_status_style_get_type*(): GType {.cdecl, 
    importc: "gtk_im_status_style_get_type", dynlib: lib.}
template TYPE_IM_STATUS_STYLE*(): expr = 
  (gtk_im_status_style_get_type())

proc pack_direction_get_type*(): GType {.cdecl, 
    importc: "gtk_pack_direction_get_type", dynlib: lib.}
template TYPE_PACK_DIRECTION*(): expr = 
  (gtk_pack_direction_get_type())

proc print_pages_get_type*(): GType {.cdecl, 
    importc: "gtk_print_pages_get_type", dynlib: lib.}
template TYPE_PRINT_PAGES*(): expr = 
  (gtk_print_pages_get_type())

proc page_set_get_type*(): GType {.cdecl, 
    importc: "gtk_page_set_get_type", dynlib: lib.}
template TYPE_PAGE_SET*(): expr = 
  (gtk_page_set_get_type())

proc number_up_layout_get_type*(): GType {.cdecl, 
    importc: "gtk_number_up_layout_get_type", dynlib: lib.}
template TYPE_NUMBER_UP_LAYOUT*(): expr = 
  (gtk_number_up_layout_get_type())

proc page_orientation_get_type*(): GType {.cdecl, 
    importc: "gtk_page_orientation_get_type", dynlib: lib.}
template TYPE_PAGE_ORIENTATION*(): expr = 
  (gtk_page_orientation_get_type())

proc print_quality_get_type*(): GType {.cdecl, 
    importc: "gtk_print_quality_get_type", dynlib: lib.}
template TYPE_PRINT_QUALITY*(): expr = 
  (gtk_print_quality_get_type())

proc print_duplex_get_type*(): GType {.cdecl, 
    importc: "gtk_print_duplex_get_type", dynlib: lib.}
template TYPE_PRINT_DUPLEX*(): expr = 
  (gtk_print_duplex_get_type())

proc unit_get_type*(): GType {.cdecl, importc: "gtk_unit_get_type", 
                                   dynlib: lib.}
template TYPE_UNIT*(): expr = 
  (gtk_unit_get_type())

proc tree_view_grid_lines_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_view_grid_lines_get_type", dynlib: lib.}
template TYPE_TREE_VIEW_GRID_LINES*(): expr = 
  (gtk_tree_view_grid_lines_get_type())

proc drag_result_get_type*(): GType {.cdecl, 
    importc: "gtk_drag_result_get_type", dynlib: lib.}
template TYPE_DRAG_RESULT*(): expr = 
  (gtk_drag_result_get_type())

proc size_group_mode_get_type*(): GType {.cdecl, 
    importc: "gtk_size_group_mode_get_type", dynlib: lib.}
template TYPE_SIZE_GROUP_MODE*(): expr = 
  (gtk_size_group_mode_get_type())

proc size_request_mode_get_type*(): GType {.cdecl, 
    importc: "gtk_size_request_mode_get_type", dynlib: lib.}
template TYPE_SIZE_REQUEST_MODE*(): expr = 
  (gtk_size_request_mode_get_type())

proc scrollable_policy_get_type*(): GType {.cdecl, 
    importc: "gtk_scrollable_policy_get_type", dynlib: lib.}
template TYPE_SCROLLABLE_POLICY*(): expr = 
  (gtk_scrollable_policy_get_type())

proc state_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_state_flags_get_type", dynlib: lib.}
template TYPE_STATE_FLAGS*(): expr = 
  (gtk_state_flags_get_type())

proc region_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_region_flags_get_type", dynlib: lib.}
template TYPE_REGION_FLAGS*(): expr = 
  (gtk_region_flags_get_type())

proc junction_sides_get_type*(): GType {.cdecl, 
    importc: "gtk_junction_sides_get_type", dynlib: lib.}
template TYPE_JUNCTION_SIDES*(): expr = 
  (gtk_junction_sides_get_type())

proc border_style_get_type*(): GType {.cdecl, 
    importc: "gtk_border_style_get_type", dynlib: lib.}
template TYPE_BORDER_STYLE*(): expr = 
  (gtk_border_style_get_type())

proc level_bar_mode_get_type*(): GType {.cdecl, 
    importc: "gtk_level_bar_mode_get_type", dynlib: lib.}
template TYPE_LEVEL_BAR_MODE*(): expr = 
  (gtk_level_bar_mode_get_type())

proc input_purpose_get_type*(): GType {.cdecl, 
    importc: "gtk_input_purpose_get_type", dynlib: lib.}
template TYPE_INPUT_PURPOSE*(): expr = 
  (gtk_input_purpose_get_type())

proc input_hints_get_type*(): GType {.cdecl, 
    importc: "gtk_input_hints_get_type", dynlib: lib.}
template TYPE_INPUT_HINTS*(): expr = 
  (gtk_input_hints_get_type())

proc file_chooser_action_get_type*(): GType {.cdecl, 
    importc: "gtk_file_chooser_action_get_type", dynlib: lib.}
template TYPE_FILE_CHOOSER_ACTION*(): expr = 
  (gtk_file_chooser_action_get_type())

proc file_chooser_confirmation_get_type*(): GType {.cdecl, 
    importc: "gtk_file_chooser_confirmation_get_type", dynlib: lib.}
template TYPE_FILE_CHOOSER_CONFIRMATION*(): expr = 
  (gtk_file_chooser_confirmation_get_type())

proc file_chooser_error_get_type*(): GType {.cdecl, 
    importc: "gtk_file_chooser_error_get_type", dynlib: lib.}
template TYPE_FILE_CHOOSER_ERROR*(): expr = 
  (gtk_file_chooser_error_get_type())

proc file_filter_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_file_filter_flags_get_type", dynlib: lib.}
template TYPE_FILE_FILTER_FLAGS*(): expr = 
  (gtk_file_filter_flags_get_type())

proc icon_lookup_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_lookup_flags_get_type", dynlib: lib.}
template TYPE_ICON_LOOKUP_FLAGS*(): expr = 
  (gtk_icon_lookup_flags_get_type())

proc icon_theme_error_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_theme_error_get_type", dynlib: lib.}
template TYPE_ICON_THEME_ERROR*(): expr = 
  (gtk_icon_theme_error_get_type())

proc icon_view_drop_position_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_view_drop_position_get_type", dynlib: lib.}
template TYPE_ICON_VIEW_DROP_POSITION*(): expr = 
  (gtk_icon_view_drop_position_get_type())

proc image_type_get_type*(): GType {.cdecl, 
    importc: "gtk_image_type_get_type", dynlib: lib.}
template TYPE_IMAGE_TYPE*(): expr = 
  (gtk_image_type_get_type())

proc buttons_type_get_type*(): GType {.cdecl, 
    importc: "gtk_buttons_type_get_type", dynlib: lib.}
template TYPE_BUTTONS_TYPE*(): expr = 
  (gtk_buttons_type_get_type())

proc notebook_tab_get_type*(): GType {.cdecl, 
    importc: "gtk_notebook_tab_get_type", dynlib: lib.}
template TYPE_NOTEBOOK_TAB*(): expr = 
  (gtk_notebook_tab_get_type())

proc places_open_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_places_open_flags_get_type", dynlib: lib.}
template TYPE_PLACES_OPEN_FLAGS*(): expr = 
  (gtk_places_open_flags_get_type())

proc print_status_get_type*(): GType {.cdecl, 
    importc: "gtk_print_status_get_type", dynlib: lib.}
template TYPE_PRINT_STATUS*(): expr = 
  (gtk_print_status_get_type())

proc print_operation_result_get_type*(): GType {.cdecl, 
    importc: "gtk_print_operation_result_get_type", dynlib: lib.}
template TYPE_PRINT_OPERATION_RESULT*(): expr = 
  (gtk_print_operation_result_get_type())

proc print_operation_action_get_type*(): GType {.cdecl, 
    importc: "gtk_print_operation_action_get_type", dynlib: lib.}
template TYPE_PRINT_OPERATION_ACTION*(): expr = 
  (gtk_print_operation_action_get_type())

proc print_error_get_type*(): GType {.cdecl, 
    importc: "gtk_print_error_get_type", dynlib: lib.}
template TYPE_PRINT_ERROR*(): expr = 
  (gtk_print_error_get_type())

proc recent_sort_type_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_sort_type_get_type", dynlib: lib.}
template TYPE_RECENT_SORT_TYPE*(): expr = 
  (gtk_recent_sort_type_get_type())

proc recent_chooser_error_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_chooser_error_get_type", dynlib: lib.}
template TYPE_RECENT_CHOOSER_ERROR*(): expr = 
  (gtk_recent_chooser_error_get_type())

proc recent_filter_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_filter_flags_get_type", dynlib: lib.}
template TYPE_RECENT_FILTER_FLAGS*(): expr = 
  (gtk_recent_filter_flags_get_type())

proc recent_manager_error_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_manager_error_get_type", dynlib: lib.}
template TYPE_RECENT_MANAGER_ERROR*(): expr = 
  (gtk_recent_manager_error_get_type())

proc revealer_transition_type_get_type*(): GType {.cdecl, 
    importc: "gtk_revealer_transition_type_get_type", dynlib: lib.}
template TYPE_REVEALER_TRANSITION_TYPE*(): expr = 
  (gtk_revealer_transition_type_get_type())

proc spin_button_update_policy_get_type*(): GType {.cdecl, 
    importc: "gtk_spin_button_update_policy_get_type", dynlib: lib.}
template TYPE_SPIN_BUTTON_UPDATE_POLICY*(): expr = 
  (gtk_spin_button_update_policy_get_type())

proc spin_type_get_type*(): GType {.cdecl, 
    importc: "gtk_spin_type_get_type", dynlib: lib.}
template TYPE_SPIN_TYPE*(): expr = 
  (gtk_spin_type_get_type())

proc stack_transition_type_get_type*(): GType {.cdecl, 
    importc: "gtk_stack_transition_type_get_type", dynlib: lib.}
template TYPE_STACK_TRANSITION_TYPE*(): expr = 
  (gtk_stack_transition_type_get_type())

proc text_buffer_target_info_get_type*(): GType {.cdecl, 
    importc: "gtk_text_buffer_target_info_get_type", dynlib: lib.}
template TYPE_TEXT_BUFFER_TARGET_INFO*(): expr = 
  (gtk_text_buffer_target_info_get_type())

proc text_search_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_text_search_flags_get_type", dynlib: lib.}
template TYPE_TEXT_SEARCH_FLAGS*(): expr = 
  (gtk_text_search_flags_get_type())

proc text_window_type_get_type*(): GType {.cdecl, 
    importc: "gtk_text_window_type_get_type", dynlib: lib.}
template TYPE_TEXT_WINDOW_TYPE*(): expr = 
  (gtk_text_window_type_get_type())

proc toolbar_space_style_get_type*(): GType {.cdecl, 
    importc: "gtk_toolbar_space_style_get_type", dynlib: lib.}
template TYPE_TOOLBAR_SPACE_STYLE*(): expr = 
  (gtk_toolbar_space_style_get_type())

proc tool_palette_drag_targets_get_type*(): GType {.cdecl, 
    importc: "gtk_tool_palette_drag_targets_get_type", dynlib: lib.}
template TYPE_TOOL_PALETTE_DRAG_TARGETS*(): expr = 
  (gtk_tool_palette_drag_targets_get_type())

proc tree_model_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_model_flags_get_type", dynlib: lib.}
template TYPE_TREE_MODEL_FLAGS*(): expr = 
  (gtk_tree_model_flags_get_type())

proc tree_view_drop_position_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_view_drop_position_get_type", dynlib: lib.}
template TYPE_TREE_VIEW_DROP_POSITION*(): expr = 
  (gtk_tree_view_drop_position_get_type())

proc tree_view_column_sizing_get_type*(): GType {.cdecl, 
    importc: "gtk_tree_view_column_sizing_get_type", dynlib: lib.}
template TYPE_TREE_VIEW_COLUMN_SIZING*(): expr = 
  (gtk_tree_view_column_sizing_get_type())

proc widget_help_type_get_type*(): GType {.cdecl, 
    importc: "gtk_widget_help_type_get_type", dynlib: lib.}
template TYPE_WIDGET_HELP_TYPE*(): expr = 
  (gtk_widget_help_type_get_type())

proc rc_flags_get_type*(): GType {.cdecl, 
    importc: "gtk_rc_flags_get_type", dynlib: lib.}
template TYPE_RC_FLAGS*(): expr = 
  (gtk_rc_flags_get_type())

proc rc_token_type_get_type*(): GType {.cdecl, 
    importc: "gtk_rc_token_type_get_type", dynlib: lib.}
template TYPE_RC_TOKEN_TYPE*(): expr = 
  (gtk_rc_token_type_get_type())

proc ui_manager_item_type_get_type*(): GType {.cdecl, 
    importc: "gtk_ui_manager_item_type_get_type", dynlib: lib.}
template TYPE_UI_MANAGER_ITEM_TYPE*(): expr = 
  (gtk_ui_manager_item_type_get_type())


template TYPE_VIEWPORT*(): expr = 
  (gtk_viewport_get_type())

template VIEWPORT_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_VIEWPORT, TViewport))

template VIEWPORT_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_VIEWPORT, TViewportClass))

template IS_VIEWPORT*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_VIEWPORT))

template IS_VIEWPORT_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_VIEWPORT))

template VIEWPORT_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_VIEWPORT, TViewportClass))

type 
  PViewport* = ptr TViewport
  TViewport* = object of TBin
    priv131: PViewportPrivate

type 
  PViewportClass* = ptr TViewportClass
  TViewportClass* = object of TBinClass
    ugtk_reserved1311*: proc () {.cdecl.}
    ugtk_reserved1312*: proc () {.cdecl.}
    ugtk_reserved1313*: proc () {.cdecl.}
    ugtk_reserved1314*: proc () {.cdecl.}

proc viewport_get_type*(): GType {.cdecl, 
    importc: "gtk_viewport_get_type", dynlib: lib.}
proc viewport_new*(hadjustment: PAdjustment; 
                       vadjustment: PAdjustment): PWidget {.cdecl, 
    importc: "gtk_viewport_new", dynlib: lib.}
proc get_hadjustment*(viewport: PViewport): PAdjustment {.
    cdecl, importc: "gtk_viewport_get_hadjustment", dynlib: lib.}
proc get_vadjustment*(viewport: PViewport): PAdjustment {.
    cdecl, importc: "gtk_viewport_get_vadjustment", dynlib: lib.}
proc set_hadjustment*(viewport: PViewport; 
                                   adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_viewport_set_hadjustment", dynlib: lib.}
proc set_vadjustment*(viewport: PViewport; 
                                   adjustment: PAdjustment) {.cdecl, 
    importc: "gtk_viewport_set_vadjustment", dynlib: lib.}
proc set_shadow_type*(viewport: PViewport; 
                                   typ: TShadowType) {.cdecl, 
    importc: "gtk_viewport_set_shadow_type", dynlib: lib.}
proc get_shadow_type*(viewport: PViewport): TShadowType {.
    cdecl, importc: "gtk_viewport_get_shadow_type", dynlib: lib.}
proc get_bin_window*(viewport: PViewport): PGdkWindow {.
    cdecl, importc: "gtk_viewport_get_bin_window", dynlib: lib.}
proc get_view_window*(viewport: PViewport): PGdkWindow {.
    cdecl, importc: "gtk_viewport_get_view_window", dynlib: lib.}

template TYPE_VOLUME_BUTTON*(): expr = 
  (gtk_volume_button_get_type())

template VOLUME_BUTTON_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_VOLUME_BUTTON, TVolumeButton))

template VOLUME_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_VOLUME_BUTTON, 
                           TVolumeButtonClass))

template IS_VOLUME_BUTTON*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_VOLUME_BUTTON))

template IS_VOLUME_BUTTON_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_VOLUME_BUTTON))

template VOLUME_BUTTON_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_VOLUME_BUTTON, 
                             TVolumeButtonClass))

type 
  PVolumeButton* = ptr TVolumeButton
  TVolumeButton* = object of TScaleButton

type 
  PVolumeButtonClass* = ptr TVolumeButtonClass
  TVolumeButtonClass* = object of TScaleButtonClass
    ugtk_reserved1321*: proc () {.cdecl.}
    ugtk_reserved1322*: proc () {.cdecl.}
    ugtk_reserved1323*: proc () {.cdecl.}
    ugtk_reserved1324*: proc () {.cdecl.}

proc volume_button_get_type*(): GType {.cdecl, 
    importc: "gtk_volume_button_get_type", dynlib: lib.}
proc volume_button_new*(): PWidget {.cdecl, 
    importc: "gtk_volume_button_new", dynlib: lib.}

template TYPE_WIDGET_PATH*(): expr = 
  (gtk_widget_path_get_type())

proc widget_path_get_type*(): GType {.cdecl, 
    importc: "gtk_widget_path_get_type", dynlib: lib.}
proc widget_path_new*(): PWidgetPath {.cdecl, 
    importc: "gtk_widget_path_new", dynlib: lib.}
proc copy*(path: PWidgetPath): PWidgetPath {.
    cdecl, importc: "gtk_widget_path_copy", dynlib: lib.}
proc re*(path: PWidgetPath): PWidgetPath {.cdecl, 
    importc: "gtk_widget_path_ref", dynlib: lib.}
proc unref*(path: PWidgetPath) {.cdecl, 
    importc: "gtk_widget_path_unref", dynlib: lib.}
proc free*(path: PWidgetPath) {.cdecl, 
    importc: "gtk_widget_path_free", dynlib: lib.}
proc to_string*(path: PWidgetPath): cstring {.cdecl, 
    importc: "gtk_widget_path_to_string", dynlib: lib.}
proc length*(path: PWidgetPath): gint {.cdecl, 
    importc: "gtk_widget_path_length", dynlib: lib.}
proc append_type*(path: PWidgetPath; typ: GType): gint {.
    cdecl, importc: "gtk_widget_path_append_type", dynlib: lib.}
proc prepend_type*(path: PWidgetPath; typ: GType) {.
    cdecl, importc: "gtk_widget_path_prepend_type", dynlib: lib.}
proc append_with_siblings*(path: PWidgetPath; 
    siblings: PWidgetPath; sibling_index: guint): gint {.cdecl, 
    importc: "gtk_widget_path_append_with_siblings", dynlib: lib.}
proc append_for_widget*(path: PWidgetPath; 
    widget: PWidget): gint {.cdecl, importc: "gtk_widget_path_append_for_widget", 
                                   dynlib: lib.}
proc iter_get_object_type*(path: PWidgetPath; pos: gint): GType {.
    cdecl, importc: "gtk_widget_path_iter_get_object_type", dynlib: lib.}
proc iter_set_object_type*(path: PWidgetPath; pos: gint; 
    typ: GType) {.cdecl, importc: "gtk_widget_path_iter_set_object_type", 
                   dynlib: lib.}
proc iter_get_siblings*(path: PWidgetPath; pos: gint): PWidgetPath {.
    cdecl, importc: "gtk_widget_path_iter_get_siblings", dynlib: lib.}
proc iter_get_sibling_index*(path: PWidgetPath; 
    pos: gint): guint {.cdecl, 
                        importc: "gtk_widget_path_iter_get_sibling_index", 
                        dynlib: lib.}
proc iter_get_name*(path: PWidgetPath; pos: gint): CSTRING {.
    cdecl, importc: "gtk_widget_path_iter_get_name", dynlib: lib.}
proc iter_set_name*(path: PWidgetPath; pos: gint; 
                                    name: CSTRING) {.cdecl, 
    importc: "gtk_widget_path_iter_set_name", dynlib: lib.}
proc iter_has_name*(path: PWidgetPath; pos: gint; 
                                    name: CSTRING): gboolean {.cdecl, 
    importc: "gtk_widget_path_iter_has_name", dynlib: lib.}
proc iter_has_qname*(path: PWidgetPath; pos: gint; 
                                     qname: TGQuark): gboolean {.cdecl, 
    importc: "gtk_widget_path_iter_has_qname", dynlib: lib.}
proc iter_add_class*(path: PWidgetPath; pos: gint; 
                                     name: CSTRING) {.cdecl, 
    importc: "gtk_widget_path_iter_add_class", dynlib: lib.}
proc iter_remove_class*(path: PWidgetPath; pos: gint; 
    name: CSTRING) {.cdecl, importc: "gtk_widget_path_iter_remove_class", 
                       dynlib: lib.}
proc iter_clear_classes*(path: PWidgetPath; pos: gint) {.
    cdecl, importc: "gtk_widget_path_iter_clear_classes", dynlib: lib.}
proc iter_list_classes*(path: PWidgetPath; pos: gint): PGSList {.
    cdecl, importc: "gtk_widget_path_iter_list_classes", dynlib: lib.}
proc iter_has_class*(path: PWidgetPath; pos: gint; 
                                     name: CSTRING): gboolean {.cdecl, 
    importc: "gtk_widget_path_iter_has_class", dynlib: lib.}
proc iter_has_qclass*(path: PWidgetPath; pos: gint; 
                                      qname: TGQuark): gboolean {.cdecl, 
    importc: "gtk_widget_path_iter_has_qclass", dynlib: lib.}
proc iter_add_region*(path: PWidgetPath; pos: gint; 
                                      name: CSTRING; flags: TRegionFlags) {.
    cdecl, importc: "gtk_widget_path_iter_add_region", dynlib: lib.}
proc iter_remove_region*(path: PWidgetPath; pos: gint; 
    name: CSTRING) {.cdecl, importc: "gtk_widget_path_iter_remove_region", 
                       dynlib: lib.}
proc iter_clear_regions*(path: PWidgetPath; pos: gint) {.
    cdecl, importc: "gtk_widget_path_iter_clear_regions", dynlib: lib.}
proc iter_list_regions*(path: PWidgetPath; pos: gint): PGSList {.
    cdecl, importc: "gtk_widget_path_iter_list_regions", dynlib: lib.}
proc iter_has_region*(path: PWidgetPath; pos: gint; 
                                      name: CSTRING; 
                                      flags: var TRegionFlags): gboolean {.
    cdecl, importc: "gtk_widget_path_iter_has_region", dynlib: lib.}
proc iter_has_qregion*(path: PWidgetPath; pos: gint; 
    qname: TGQuark; flags: var TRegionFlags): gboolean {.cdecl, 
    importc: "gtk_widget_path_iter_has_qregion", dynlib: lib.}
proc get_object_type*(path: PWidgetPath): GType {.cdecl, 
    importc: "gtk_widget_path_get_object_type", dynlib: lib.}
proc is_type*(path: PWidgetPath; typ: GType): gboolean {.
    cdecl, importc: "gtk_widget_path_is_type", dynlib: lib.}
proc has_parent*(path: PWidgetPath; typ: GType): gboolean {.
    cdecl, importc: "gtk_widget_path_has_parent", dynlib: lib.}

template TYPE_ACTION*(): expr = 
  (gtk_action_get_type())

template ACTION_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ACTION, TAction))

template ACTION_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ACTION, TActionClass))

template IS_ACTION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ACTION))

template IS_ACTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ACTION))

template ACTION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ACTION, TActionClass))

type 
  PAction* = ptr TAction
  TAction* = object of TGObject
    private_data1*: PActionPrivate

type 
  PActionClass* = ptr TActionClass
  TActionClass* = object of TGObjectClass
    activate*: proc (action: PAction) {.cdecl.}
    menu_item_type*: GType
    toolbar_item_type*: GType
    create_menu_item*: proc (action: PAction): PWidget {.cdecl.}
    create_tool_item*: proc (action: PAction): PWidget {.cdecl.}
    connect_proxy*: proc (action: PAction; proxy: PWidget) {.cdecl.}
    disconnect_proxy*: proc (action: PAction; proxy: PWidget) {.
        cdecl.}
    create_menu*: proc (action: PAction): PWidget {.cdecl.}
    ugtk_reserved1331*: proc () {.cdecl.}
    ugtk_reserved1332*: proc () {.cdecl.}
    ugtk_reserved1333*: proc () {.cdecl.}
    ugtk_reserved1334*: proc () {.cdecl.}

proc action_get_type*(): GType {.cdecl, importc: "gtk_action_get_type", 
                                     dynlib: lib.}
proc action_new*(name: CSTRING; label: CSTRING; tooltip: CSTRING; 
                     stock_id: CSTRING): PAction {.cdecl, 
    importc: "gtk_action_new", dynlib: lib.}
proc get_name*(action: PAction): CSTRING {.cdecl, 
    importc: "gtk_action_get_name", dynlib: lib.}
proc is_sensitive*(action: PAction): gboolean {.cdecl, 
    importc: "gtk_action_is_sensitive", dynlib: lib.}
proc get_sensitive*(action: PAction): gboolean {.cdecl, 
    importc: "gtk_action_get_sensitive", dynlib: lib.}
proc set_sensitive*(action: PAction; sensitive: gboolean) {.
    cdecl, importc: "gtk_action_set_sensitive", dynlib: lib.}
proc is_visible*(action: PAction): gboolean {.cdecl, 
    importc: "gtk_action_is_visible", dynlib: lib.}
proc get_visible*(action: PAction): gboolean {.cdecl, 
    importc: "gtk_action_get_visible", dynlib: lib.}
proc set_visible*(action: PAction; visible: gboolean) {.
    cdecl, importc: "gtk_action_set_visible", dynlib: lib.}
proc activate*(action: PAction) {.cdecl, 
    importc: "gtk_action_activate", dynlib: lib.}
proc create_icon*(action: PAction; icon_size: TIconSize): PWidget {.
    cdecl, importc: "gtk_action_create_icon", dynlib: lib.}
proc create_menu_item*(action: PAction): PWidget {.
    cdecl, importc: "gtk_action_create_menu_item", dynlib: lib.}
proc create_tool_item*(action: PAction): PWidget {.
    cdecl, importc: "gtk_action_create_tool_item", dynlib: lib.}
proc create_menu*(action: PAction): PWidget {.cdecl, 
    importc: "gtk_action_create_menu", dynlib: lib.}
proc get_proxies*(action: PAction): PGSList {.cdecl, 
    importc: "gtk_action_get_proxies", dynlib: lib.}
proc connect_accelerator*(action: PAction) {.cdecl, 
    importc: "gtk_action_connect_accelerator", dynlib: lib.}
proc disconnect_accelerator*(action: PAction) {.cdecl, 
    importc: "gtk_action_disconnect_accelerator", dynlib: lib.}
proc get_accel_path*(action: PAction): CSTRING {.cdecl, 
    importc: "gtk_action_get_accel_path", dynlib: lib.}
proc get_accel_closure*(action: PAction): PGClosure {.
    cdecl, importc: "gtk_action_get_accel_closure", dynlib: lib.}
proc block_activate*(action: PAction) {.cdecl, 
    importc: "gtk_action_block_activate", dynlib: lib.}
proc unblock_activate*(action: PAction) {.cdecl, 
    importc: "gtk_action_unblock_activate", dynlib: lib.}
proc underscore_gtk_action_add_to_proxy_list*(action: PAction; 
                                    proxy: PWidget) {.cdecl, 
    importc: "_gtk_action_add_to_proxy_list", dynlib: lib.}
proc underscore_gtk_action_remove_from_proxy_list*(action: PAction; 
    proxy: PWidget) {.cdecl, 
                            importc: "_gtk_action_remove_from_proxy_list", 
                            dynlib: lib.}
proc underscore_gtk_action_emit_activate*(action: PAction) {.cdecl, 
    importc: "_gtk_action_emit_activate", dynlib: lib.}
proc set_accel_path*(action: PAction; accel_path: CSTRING) {.
    cdecl, importc: "gtk_action_set_accel_path", dynlib: lib.}
proc set_accel_group*(action: PAction; 
                                 accel_group: PAccelGroup) {.cdecl, 
    importc: "gtk_action_set_accel_group", dynlib: lib.}
proc underscore_gtk_action_sync_menu_visible*(action: PAction; 
                                    proxy: PWidget; empty: gboolean) {.
    cdecl, importc: "_gtk_action_sync_menu_visible", dynlib: lib.}
proc set_label*(action: PAction; label: CSTRING) {.cdecl, 
    importc: "gtk_action_set_label", dynlib: lib.}
proc get_label*(action: PAction): CSTRING {.cdecl, 
    importc: "gtk_action_get_label", dynlib: lib.}
proc set_short_label*(action: PAction; short_label: CSTRING) {.
    cdecl, importc: "gtk_action_set_short_label", dynlib: lib.}
proc get_short_label*(action: PAction): CSTRING {.cdecl, 
    importc: "gtk_action_get_short_label", dynlib: lib.}
proc set_tooltip*(action: PAction; tooltip: CSTRING) {.
    cdecl, importc: "gtk_action_set_tooltip", dynlib: lib.}
proc get_tooltip*(action: PAction): CSTRING {.cdecl, 
    importc: "gtk_action_get_tooltip", dynlib: lib.}
proc set_stock_id*(action: PAction; stock_id: CSTRING) {.
    cdecl, importc: "gtk_action_set_stock_id", dynlib: lib.}
proc get_stock_id*(action: PAction): CSTRING {.cdecl, 
    importc: "gtk_action_get_stock_id", dynlib: lib.}
proc set_gicon*(action: PAction; icon: PGIcon) {.cdecl, 
    importc: "gtk_action_set_gicon", dynlib: lib.}
proc get_gicon*(action: PAction): PGIcon {.cdecl, 
    importc: "gtk_action_get_gicon", dynlib: lib.}
proc set_icon_name*(action: PAction; icon_name: CSTRING) {.
    cdecl, importc: "gtk_action_set_icon_name", dynlib: lib.}
proc get_icon_name*(action: PAction): CSTRING {.cdecl, 
    importc: "gtk_action_get_icon_name", dynlib: lib.}
proc set_visible_horizontal*(action: PAction; 
    visible_horizontal: gboolean) {.cdecl, importc: "gtk_action_set_visible_horizontal", 
                                    dynlib: lib.}
proc get_visible_horizontal*(action: PAction): gboolean {.
    cdecl, importc: "gtk_action_get_visible_horizontal", dynlib: lib.}
proc set_visible_vertical*(action: PAction; 
                                      visible_vertical: gboolean) {.cdecl, 
    importc: "gtk_action_set_visible_vertical", dynlib: lib.}
proc get_visible_vertical*(action: PAction): gboolean {.
    cdecl, importc: "gtk_action_get_visible_vertical", dynlib: lib.}
proc set_is_important*(action: PAction; 
                                  is_important: gboolean) {.cdecl, 
    importc: "gtk_action_set_is_important", dynlib: lib.}
proc get_is_important*(action: PAction): gboolean {.cdecl, 
    importc: "gtk_action_get_is_important", dynlib: lib.}
proc set_always_show_image*(action: PAction; 
    always_show: gboolean) {.cdecl, 
                             importc: "gtk_action_set_always_show_image", 
                             dynlib: lib.}
proc get_always_show_image*(action: PAction): gboolean {.
    cdecl, importc: "gtk_action_get_always_show_image", dynlib: lib.}

template TYPE_ACTIVATABLE*(): expr = 
  (gtk_activatable_get_type())

template ACTIVATABLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ACTIVATABLE, TActivatable))

template ACTIVATABLE_CLASS*(obj: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((obj), TYPE_ACTIVATABLE, TActivatableIface))

template IS_ACTIVATABLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ACTIVATABLE))

template ACTIVATABLE_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_ACTIVATABLE, 
                                 TActivatableIface))

type 
  PActivatableIface* = ptr TActivatableIface
  TActivatableIface* = object of TGTypeInterface
    update*: proc (activatable: PActivatable; action: PAction; 
                   property_name: CSTRING) {.cdecl.}
    sync_action_properties*: proc (activatable: PActivatable; 
                                   action: PAction) {.cdecl.}

proc activatable_get_type*(): GType {.cdecl, 
    importc: "gtk_activatable_get_type", dynlib: lib.}
proc sync_action_properties*(activatable: PActivatable; 
    action: PAction) {.cdecl, importc: "gtk_activatable_sync_action_properties", 
                             dynlib: lib.}
proc set_related_action*(activatable: PActivatable; 
    action: PAction) {.cdecl, 
                             importc: "gtk_activatable_set_related_action", 
                             dynlib: lib.}
proc get_related_action*(activatable: PActivatable): PAction {.
    cdecl, importc: "gtk_activatable_get_related_action", dynlib: lib.}
proc set_use_action_appearance*(
    activatable: PActivatable; use_appearance: gboolean) {.cdecl, 
    importc: "gtk_activatable_set_use_action_appearance", dynlib: lib.}
proc get_use_action_appearance*(
    activatable: PActivatable): gboolean {.cdecl, 
    importc: "gtk_activatable_get_use_action_appearance", dynlib: lib.}
proc do_set_related_action*(activatable: PActivatable; 
    action: PAction) {.cdecl, importc: "gtk_activatable_do_set_related_action", 
                             dynlib: lib.}

type 
  TTranslateFunc* = proc (path: CSTRING; func_data: gpointer): CSTRING {.
      cdecl.}
type 
  PStockItem* = ptr TStockItem
  TStockItem*{.final, pure.} = object 
    stock_id*: CSTRING
    label*: CSTRING
    modifier*: gdk3.TModifierType
    keyval*: guint
    translation_domain*: CSTRING

proc gtk_stock_add*(items: PStockItem; n_items: guint) {.cdecl, 
    importc: "gtk_stock_add", dynlib: lib.}
proc stock_add_static*(items: PStockItem; n_items: guint) {.cdecl, 
    importc: "gtk_stock_add_static", dynlib: lib.}
proc stock_lookup*(stock_id: CSTRING; item: PStockItem): gboolean {.
    cdecl, importc: "gtk_stock_lookup", dynlib: lib.}
proc stock_list_ids*(): PGSList {.cdecl, importc: "gtk_stock_list_ids", 
    dynlib: lib.}
proc copy*(item: PStockItem): PStockItem {.cdecl, 
    importc: "gtk_stock_item_copy", dynlib: lib.}
proc free*(item: PStockItem) {.cdecl, 
    importc: "gtk_stock_item_free", dynlib: lib.}
proc stock_set_translate_func*(domain: CSTRING; func: TTranslateFunc; 
                                   data: gpointer; notify: TGDestroyNotify) {.
    cdecl, importc: "gtk_stock_set_translate_func", dynlib: lib.}
type 
  Stock* = cstring
when not(defined(DISABLE_DEPRECATED)): 
  const 
    STOCK_ABOUT* = (cast[Stock]("gtk-about"))
  const 
    STOCK_ADD* = (cast[Stock]("gtk-add"))
  const 
    STOCK_APPLY* = (cast[Stock]("gtk-apply"))
  const 
    STOCK_BOLD* = (cast[Stock]("gtk-bold"))
  const 
    STOCK_CANCEL* = (cast[Stock]("gtk-cancel"))
  const 
    STOCK_CAPS_LOCK_WARNING* = (cast[Stock]("gtk-caps-lock-warning"))
  const 
    STOCK_CDROM* = (cast[Stock]("gtk-cdrom"))
  const 
    STOCK_CLEAR* = (cast[Stock]("gtk-clear"))
  const 
    STOCK_CLOSE* = (cast[Stock]("gtk-close"))
  const 
    STOCK_COLOR_PICKER* = (cast[Stock]("gtk-color-picker"))
  const 
    STOCK_CONNECT* = (cast[Stock]("gtk-connect"))
  const 
    STOCK_CONVERT* = (cast[Stock]("gtk-convert"))
  const 
    STOCK_COPY* = (cast[Stock]("gtk-copy"))
  const 
    STOCK_CUT* = (cast[Stock]("gtk-cut"))
  const 
    STOCK_DELETE* = (cast[Stock]("gtk-delete"))
  const 
    STOCK_DIALOG_AUTHENTICATION* = (
      cast[Stock]("gtk-dialog-authentication"))
  const 
    STOCK_DIALOG_INFO* = (cast[Stock]("gtk-dialog-info"))
  const 
    STOCK_DIALOG_WARNING* = (cast[Stock]("gtk-dialog-warning"))
  const 
    STOCK_DIALOG_ERROR* = (cast[Stock]("gtk-dialog-error"))
  const 
    STOCK_DIALOG_QUESTION* = (cast[Stock]("gtk-dialog-question"))
  const 
    STOCK_DIRECTORY* = (cast[Stock]("gtk-directory"))
  const 
    STOCK_DISCARD* = (cast[Stock]("gtk-discard"))
  const 
    STOCK_DISCONNECT* = (cast[Stock]("gtk-disconnect"))
  const 
    STOCK_DND* = (cast[Stock]("gtk-dnd"))
  const 
    STOCK_DND_MULTIPLE* = (cast[Stock]("gtk-dnd-multiple"))
  const 
    STOCK_EDIT* = (cast[Stock]("gtk-edit"))
  const 
    STOCK_EXECUTE* = (cast[Stock]("gtk-execute"))
  const 
    STOCK_FILE* = (cast[Stock]("gtk-file"))
  const 
    STOCK_FIND* = (cast[Stock]("gtk-find"))
  const 
    STOCK_FIND_AND_REPLACE* = (cast[Stock]("gtk-find-and-replace"))
  const 
    STOCK_FLOPPY* = (cast[Stock]("gtk-floppy"))
  const 
    STOCK_FULLSCREEN* = (cast[Stock]("gtk-fullscreen"))
  const 
    STOCK_GOTO_BOTTOM* = (cast[Stock]("gtk-goto-bottom"))
  const 
    STOCK_GOTO_FIRST* = (cast[Stock]("gtk-goto-first"))
  const 
    STOCK_GOTO_LAST* = (cast[Stock]("gtk-goto-last"))
  const 
    STOCK_GOTO_TOP* = (cast[Stock]("gtk-goto-top"))
  const 
    STOCK_GO_BACK* = (cast[Stock]("gtk-go-back"))
  const 
    STOCK_GO_DOWN* = (cast[Stock]("gtk-go-down"))
  const 
    STOCK_GO_FORWARD* = (cast[Stock]("gtk-go-forward"))
  const 
    STOCK_GO_UP* = (cast[Stock]("gtk-go-up"))
  const 
    STOCK_HARDDISK* = (cast[Stock]("gtk-harddisk"))
  const 
    STOCK_HELP* = (cast[Stock]("gtk-help"))
  const 
    STOCK_HOME* = (cast[Stock]("gtk-home"))
  const 
    STOCK_INDEX* = (cast[Stock]("gtk-index"))
  const 
    STOCK_INDENT* = (cast[Stock]("gtk-indent"))
  const 
    STOCK_INFO* = (cast[Stock]("gtk-info"))
  const 
    STOCK_ITALIC* = (cast[Stock]("gtk-italic"))
  const 
    STOCK_JUMP_TO* = (cast[Stock]("gtk-jump-to"))
  const 
    STOCK_JUSTIFY_CENTER* = (cast[Stock]("gtk-justify-center"))
  const 
    STOCK_JUSTIFY_FILL* = (cast[Stock]("gtk-justify-fill"))
  const 
    STOCK_JUSTIFY_LEFT* = (cast[Stock]("gtk-justify-left"))
  const 
    STOCK_JUSTIFY_RIGHT* = (cast[Stock]("gtk-justify-right"))
  const 
    STOCK_LEAVE_FULLSCREEN* = (cast[Stock]("gtk-leave-fullscreen"))
  const 
    STOCK_MISSING_IMAGE* = (cast[Stock]("gtk-missing-image"))
  const 
    STOCK_MEDIA_FORWARD* = (cast[Stock]("gtk-media-forward"))
  const 
    STOCK_MEDIA_NEXT* = (cast[Stock]("gtk-media-next"))
  const 
    STOCK_MEDIA_PAUSE* = (cast[Stock]("gtk-media-pause"))
  const 
    STOCK_MEDIA_PLAY* = (cast[Stock]("gtk-media-play"))
  const 
    STOCK_MEDIA_PREVIOUS* = (cast[Stock]("gtk-media-previous"))
  const 
    STOCK_MEDIA_RECORD* = (cast[Stock]("gtk-media-record"))
  const 
    STOCK_MEDIA_REWIND* = (cast[Stock]("gtk-media-rewind"))
  const 
    STOCK_MEDIA_STOP* = (cast[Stock]("gtk-media-stop"))
  const 
    STOCK_NETWORK* = (cast[Stock]("gtk-network"))
  const 
    STOCK_NEW* = (cast[Stock]("gtk-new"))
  const 
    STOCK_NO* = (cast[Stock]("gtk-no"))
  const 
    STOCK_OK* = (cast[Stock]("gtk-ok"))
  const 
    STOCK_OPEN* = (cast[Stock]("gtk-open"))
  const 
    STOCK_ORIENTATION_PORTRAIT* = (
      cast[Stock]("gtk-orientation-portrait"))
  const 
    STOCK_ORIENTATION_LANDSCAPE* = (
      cast[Stock]("gtk-orientation-landscape"))
  const 
    STOCK_ORIENTATION_REVERSE_LANDSCAPE* = (
      cast[Stock]("gtk-orientation-reverse-landscape"))
  const 
    STOCK_ORIENTATION_REVERSE_PORTRAIT* = (
      cast[Stock]("gtk-orientation-reverse-portrait"))
  const 
    STOCK_PAGE_SETUP* = (cast[Stock]("gtk-page-setup"))
  const 
    STOCK_PASTE* = (cast[Stock]("gtk-paste"))
  const 
    STOCK_PREFERENCES* = (cast[Stock]("gtk-preferences"))
  const 
    STOCK_PRINT* = (cast[Stock]("gtk-print"))
  const 
    STOCK_PRINT_ERROR* = (cast[Stock]("gtk-print-error"))
  const 
    STOCK_PRINT_PAUSED* = (cast[Stock]("gtk-print-paused"))
  const 
    STOCK_PRINT_PREVIEW* = (cast[Stock]("gtk-print-preview"))
  const 
    STOCK_PRINT_REPORT* = (cast[Stock]("gtk-print-report"))
  const 
    STOCK_PRINT_WARNING* = (cast[Stock]("gtk-print-warning"))
  const 
    STOCK_PROPERTIES* = (cast[Stock]("gtk-properties"))
  const 
    STOCK_QUIT* = (cast[Stock]("gtk-quit"))
  const 
    STOCK_REDO* = (cast[Stock]("gtk-redo"))
  const 
    STOCK_REFRESH* = (cast[Stock]("gtk-refresh"))
  const 
    STOCK_REMOVE* = (cast[Stock]("gtk-remove"))
  const 
    STOCK_REVERT_TO_SAVED* = (cast[Stock]("gtk-revert-to-saved"))
  const 
    STOCK_SAVE* = (cast[Stock]("gtk-save"))
  const 
    STOCK_SAVE_AS* = (cast[Stock]("gtk-save-as"))
  const 
    STOCK_SELECT_ALL* = (cast[Stock]("gtk-select-all"))
  const 
    STOCK_SELECT_COLOR* = (cast[Stock]("gtk-select-color"))
  const 
    STOCK_SELECT_FONT* = (cast[Stock]("gtk-select-font"))
  const 
    STOCK_SORT_ASCENDING* = (cast[Stock]("gtk-sort-ascending"))
  const 
    STOCK_SORT_DESCENDING* = (cast[Stock]("gtk-sort-descending"))
  const 
    STOCK_SPELL_CHECK* = (cast[Stock]("gtk-spell-check"))
  const 
    STOCK_STOP* = (cast[Stock]("gtk-stop"))
  const 
    STOCK_STRIKETHROUGH* = (cast[Stock]("gtk-strikethrough"))
  const 
    STOCK_UNDELETE* = (cast[Stock]("gtk-undelete"))
  const 
    STOCK_UNDERLINE* = (cast[Stock]("gtk-underline"))
  const 
    STOCK_UNDO* = (cast[Stock]("gtk-undo"))
  const 
    STOCK_UNINDENT* = (cast[Stock]("gtk-unindent"))
  const 
    STOCK_YES* = (cast[Stock]("gtk-yes"))
  const 
    STOCK_ZOOM_100* = (cast[Stock]("gtk-zoom-100"))
  const 
    STOCK_ZOOM_FIT* = (cast[Stock]("gtk-zoom-fit"))
  const 
    STOCK_ZOOM_IN* = (cast[Stock]("gtk-zoom-in"))
  const 
    STOCK_ZOOM_OUT* = (cast[Stock]("gtk-zoom-out"))

template TYPE_ACTION_GROUP*(): expr = 
  (gtk_action_group_get_type())

template ACTION_GROUP_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ACTION_GROUP, TActionGroup))

template ACTION_GROUP_CLASS*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((vtable), TYPE_ACTION_GROUP, 
                           TActionGroupClass))

template IS_ACTION_GROUP*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ACTION_GROUP))

template IS_ACTION_GROUP_CLASS*(vtable: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((vtable), TYPE_ACTION_GROUP))

template ACTION_GROUP_GET_CLASS*(inst: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((inst), TYPE_ACTION_GROUP, 
                             TActionGroupClass))

type 
  PActionGroup* = ptr TActionGroup
  TActionGroup* = object of TGObject
    priv132: PActionGroupPrivate

type 
  PActionGroupClass* = ptr TActionGroupClass
  TActionGroupClass* = object of TGObjectClass
    get_action*: proc (action_group: PActionGroup; 
                       action_name: CSTRING): PAction {.cdecl.}
    ugtk_reserved1341*: proc () {.cdecl.}
    ugtk_reserved1342*: proc () {.cdecl.}
    ugtk_reserved1343*: proc () {.cdecl.}
    ugtk_reserved1344*: proc () {.cdecl.}

type 
  PActionEntry* = ptr TActionEntry
  TActionEntry*{.final, pure.} = object 
    name*: CSTRING
    stock_id*: CSTRING
    label*: CSTRING
    accelerator*: CSTRING
    tooltip*: CSTRING
    callback*: TGCallback

type 
  PToggleActionEntry* = ptr TToggleActionEntry
  TToggleActionEntry*{.final, pure.} = object 
    name*: CSTRING
    stock_id*: CSTRING
    label*: CSTRING
    accelerator*: CSTRING
    tooltip*: CSTRING
    callback*: TGCallback
    is_active*: gboolean

type 
  PRadioActionEntry* = ptr TRadioActionEntry
  TRadioActionEntry*{.final, pure.} = object 
    name*: CSTRING
    stock_id*: CSTRING
    label*: CSTRING
    accelerator*: CSTRING
    tooltip*: CSTRING
    value*: gint

proc action_group_get_type*(): GType {.cdecl, 
    importc: "gtk_action_group_get_type", dynlib: lib.}
proc action_group_new*(name: CSTRING): PActionGroup {.cdecl, 
    importc: "gtk_action_group_new", dynlib: lib.}
proc get_name*(action_group: PActionGroup): CSTRING {.
    cdecl, importc: "gtk_action_group_get_name", dynlib: lib.}
proc get_sensitive*(action_group: PActionGroup): gboolean {.
    cdecl, importc: "gtk_action_group_get_sensitive", dynlib: lib.}
proc set_sensitive*(action_group: PActionGroup; 
                                     sensitive: gboolean) {.cdecl, 
    importc: "gtk_action_group_set_sensitive", dynlib: lib.}
proc get_visible*(action_group: PActionGroup): gboolean {.
    cdecl, importc: "gtk_action_group_get_visible", dynlib: lib.}
proc set_visible*(action_group: PActionGroup; 
                                   visible: gboolean) {.cdecl, 
    importc: "gtk_action_group_set_visible", dynlib: lib.}
proc get_accel_group*(action_group: PActionGroup): PAccelGroup {.
    cdecl, importc: "gtk_action_group_get_accel_group", dynlib: lib.}
proc set_accel_group*(action_group: PActionGroup; 
    accel_group: PAccelGroup) {.cdecl, importc: "gtk_action_group_set_accel_group", 
                                      dynlib: lib.}
proc get_action*(action_group: PActionGroup; 
                                  action_name: CSTRING): PAction {.
    cdecl, importc: "gtk_action_group_get_action", dynlib: lib.}
proc list_actions*(action_group: PActionGroup): PGList {.
    cdecl, importc: "gtk_action_group_list_actions", dynlib: lib.}
proc add_action*(action_group: PActionGroup; 
                                  action: PAction) {.cdecl, 
    importc: "gtk_action_group_add_action", dynlib: lib.}
proc add_action_with_accel*(action_group: PActionGroup; 
    action: PAction; accelerator: CSTRING) {.cdecl, 
    importc: "gtk_action_group_add_action_with_accel", dynlib: lib.}
proc remove_action*(action_group: PActionGroup; 
                                     action: PAction) {.cdecl, 
    importc: "gtk_action_group_remove_action", dynlib: lib.}
proc add_actions*(action_group: PActionGroup; 
                                   entries: PActionEntry; 
                                   n_entries: guint; user_data: gpointer) {.
    cdecl, importc: "gtk_action_group_add_actions", dynlib: lib.}
proc add_toggle_actions*(action_group: PActionGroup; 
    entries: PToggleActionEntry; n_entries: guint; user_data: gpointer) {.
    cdecl, importc: "gtk_action_group_add_toggle_actions", dynlib: lib.}
proc add_radio_actions*(action_group: PActionGroup; 
    entries: PRadioActionEntry; n_entries: guint; value: gint; 
    on_change: TGCallback; user_data: gpointer) {.cdecl, 
    importc: "gtk_action_group_add_radio_actions", dynlib: lib.}
proc add_actions_full*(action_group: PActionGroup; 
    entries: PActionEntry; n_entries: guint; user_data: gpointer; 
    destroy: TGDestroyNotify) {.cdecl, 
                               importc: "gtk_action_group_add_actions_full", 
                               dynlib: lib.}
proc add_toggle_actions_full*(
    action_group: PActionGroup; entries: PToggleActionEntry; 
    n_entries: guint; user_data: gpointer; destroy: TGDestroyNotify) {.cdecl, 
    importc: "gtk_action_group_add_toggle_actions_full", dynlib: lib.}
proc add_radio_actions_full*(
    action_group: PActionGroup; entries: PRadioActionEntry; 
    n_entries: guint; value: gint; on_change: TGCallback; user_data: gpointer; 
    destroy: TGDestroyNotify) {.cdecl, importc: "gtk_action_group_add_radio_actions_full", 
                               dynlib: lib.}
proc set_translate_func*(action_group: PActionGroup; 
    func: TTranslateFunc; data: gpointer; notify: TGDestroyNotify) {.cdecl, 
    importc: "gtk_action_group_set_translate_func", dynlib: lib.}
proc set_translation_domain*(
    action_group: PActionGroup; domain: CSTRING) {.cdecl, 
    importc: "gtk_action_group_set_translation_domain", dynlib: lib.}
proc translate_string*(action_group: PActionGroup; 
    string: CSTRING): CSTRING {.cdecl, importc: "gtk_action_group_translate_string", 
                                    dynlib: lib.}
proc underscore_gtk_action_group_emit_connect_proxy*(action_group: PActionGroup; 
    action: PAction; proxy: PWidget) {.cdecl, 
    importc: "_gtk_action_group_emit_connect_proxy", dynlib: lib.}
proc underscore_gtk_action_group_emit_disconnect_proxy*(
    action_group: PActionGroup; action: PAction; 
    proxy: PWidget) {.cdecl, importc: "_gtk_action_group_emit_disconnect_proxy", 
                            dynlib: lib.}
proc underscore_gtk_action_group_emit_pre_activate*(action_group: PActionGroup; 
    action: PAction) {.cdecl, 
                             importc: "_gtk_action_group_emit_pre_activate", 
                             dynlib: lib.}
proc underscore_gtk_action_group_emit_post_activate*(action_group: PActionGroup; 
    action: PAction) {.cdecl, 
                             importc: "_gtk_action_group_emit_post_activate", 
                             dynlib: lib.}

template TYPE_COLOR_SELECTION*(): expr = 
  (gtk_color_selection_get_type())

template COLOR_SELECTION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_COLOR_SELECTION, 
                              TColorSelection))

template COLOR_SELECTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_COLOR_SELECTION, 
                           TColorSelectionClass))

template IS_COLOR_SELECTION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_COLOR_SELECTION))

template IS_COLOR_SELECTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_COLOR_SELECTION))

template COLOR_SELECTION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_COLOR_SELECTION, 
                             TColorSelectionClass))

type 
  TColorSelectionChangePaletteFunc* = proc (colors: gdk3.PColor; 
      n_colors: gint) {.cdecl.}
type 
  TColorSelectionChangePaletteWithScreenFunc* = proc (screen: PGdkScreen; 
      colors: gdk3.PColor; n_colors: gint) {.cdecl.}
type 
  PColorSelection* = ptr TColorSelection
  TColorSelection* = object of TBox
    private_data*: PColorSelectionPrivate

type 
  PColorSelectionClass* = ptr TColorSelectionClass
  TColorSelectionClass* = object of TBoxClass
    color_changed*: proc (color_selection: PColorSelection) {.cdecl.}
    ugtk_reserved1351*: proc () {.cdecl.}
    ugtk_reserved1352*: proc () {.cdecl.}
    ugtk_reserved1353*: proc () {.cdecl.}
    ugtk_reserved1354*: proc () {.cdecl.}

proc color_selection_get_type*(): GType {.cdecl, 
    importc: "gtk_color_selection_get_type", dynlib: lib.}
proc color_selection_new*(): PWidget {.cdecl, 
    importc: "gtk_color_selection_new", dynlib: lib.}
proc get_has_opacity_control*(
    colorsel: PColorSelection): gboolean {.cdecl, 
    importc: "gtk_color_selection_get_has_opacity_control", dynlib: lib.}
proc set_has_opacity_control*(
    colorsel: PColorSelection; has_opacity: gboolean) {.cdecl, 
    importc: "gtk_color_selection_set_has_opacity_control", dynlib: lib.}
proc get_has_palette*(colorsel: PColorSelection): gboolean {.
    cdecl, importc: "gtk_color_selection_get_has_palette", dynlib: lib.}
proc set_has_palette*(colorsel: PColorSelection; 
    has_palette: gboolean) {.cdecl, 
                             importc: "gtk_color_selection_set_has_palette", 
                             dynlib: lib.}
proc set_current_alpha*(colorsel: PColorSelection; 
    alpha: guint16) {.cdecl, importc: "gtk_color_selection_set_current_alpha", 
                      dynlib: lib.}
proc get_current_alpha*(colorsel: PColorSelection): guint16 {.
    cdecl, importc: "gtk_color_selection_get_current_alpha", dynlib: lib.}
proc set_previous_alpha*(colorsel: PColorSelection; 
    alpha: guint16) {.cdecl, 
                      importc: "gtk_color_selection_set_previous_alpha", 
                      dynlib: lib.}
proc get_previous_alpha*(colorsel: PColorSelection): guint16 {.
    cdecl, importc: "gtk_color_selection_get_previous_alpha", dynlib: lib.}
proc set_current_rgba*(colorsel: PColorSelection; 
    rgba: PRGBA) {.cdecl, 
                         importc: "gtk_color_selection_set_current_rgba", 
                         dynlib: lib.}
proc get_current_rgba*(colorsel: PColorSelection; 
    rgba: PRGBA) {.cdecl, 
                         importc: "gtk_color_selection_get_current_rgba", 
                         dynlib: lib.}
proc set_previous_rgba*(colorsel: PColorSelection; 
    rgba: PRGBA) {.cdecl, 
                         importc: "gtk_color_selection_set_previous_rgba", 
                         dynlib: lib.}
proc get_previous_rgba*(colorsel: PColorSelection; 
    rgba: PRGBA) {.cdecl, 
                         importc: "gtk_color_selection_get_previous_rgba", 
                         dynlib: lib.}
proc is_adjusting*(colorsel: PColorSelection): gboolean {.
    cdecl, importc: "gtk_color_selection_is_adjusting", dynlib: lib.}
proc color_selection_palette_from_string*(str: CSTRING; 
    colors: var gdk3.PColor; n_colors: Pgint): gboolean {.cdecl, 
    importc: "gtk_color_selection_palette_from_string", dynlib: lib.}
proc color_selection_palette_to_string*(colors: gdk3.PColor; 
    n_colors: gint): CSTRING {.cdecl, importc: "gtk_color_selection_palette_to_string", 
                                 dynlib: lib.}
proc color_selection_set_change_palette_with_screen_hook*(
    func: TColorSelectionChangePaletteWithScreenFunc): TColorSelectionChangePaletteWithScreenFunc {.
    cdecl, importc: "gtk_color_selection_set_change_palette_with_screen_hook", 
    dynlib: lib.}
proc set_current_color*(colorsel: PColorSelection; 
    color: gdk3.PColor) {.cdecl, 
                           importc: "gtk_color_selection_set_current_color", 
                           dynlib: lib.}
proc get_current_color*(colorsel: PColorSelection; 
    color: gdk3.PColor) {.cdecl, 
                           importc: "gtk_color_selection_get_current_color", 
                           dynlib: lib.}
proc set_previous_color*(colorsel: PColorSelection; 
    color: gdk3.PColor) {.cdecl, 
                           importc: "gtk_color_selection_set_previous_color", 
                           dynlib: lib.}
proc get_previous_color*(colorsel: PColorSelection; 
    color: gdk3.PColor) {.cdecl, 
                           importc: "gtk_color_selection_get_previous_color", 
                           dynlib: lib.}

template TYPE_COLOR_SELECTION_DIALOG*(): expr = 
  (gtk_color_selection_dialog_get_type())

template COLOR_SELECTION_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_COLOR_SELECTION_DIALOG, 
                              TColorSelectionDialog))

template COLOR_SELECTION_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_COLOR_SELECTION_DIALOG, 
                           TColorSelectionDialogClass))

template IS_COLOR_SELECTION_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_COLOR_SELECTION_DIALOG))

template IS_COLOR_SELECTION_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_COLOR_SELECTION_DIALOG))

template COLOR_SELECTION_DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_COLOR_SELECTION_DIALOG, 
                             TColorSelectionDialogClass))

type 
  PColorSelectionDialog* = ptr TColorSelectionDialog
  TColorSelectionDialog* = object of TDialog
    priv133: PColorSelectionDialogPrivate

type 
  PColorSelectionDialogClass* = ptr TColorSelectionDialogClass
  TColorSelectionDialogClass* = object of TDialogClass
    ugtk_reserved1361*: proc () {.cdecl.}
    ugtk_reserved1362*: proc () {.cdecl.}
    ugtk_reserved1363*: proc () {.cdecl.}
    ugtk_reserved1364*: proc () {.cdecl.}

proc color_selection_dialog_get_type*(): GType {.cdecl, 
    importc: "gtk_color_selection_dialog_get_type", dynlib: lib.}
proc color_selection_dialog_new*(title: CSTRING): PWidget {.cdecl, 
    importc: "gtk_color_selection_dialog_new", dynlib: lib.}
proc get_color_selection*(
    colorsel: PColorSelectionDialog): PWidget {.cdecl, 
    importc: "gtk_color_selection_dialog_get_color_selection", dynlib: lib.}

template TYPE_FONT_SELECTION*(): expr = 
  (gtk_font_selection_get_type())

template FONT_SELECTION_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FONT_SELECTION, TFontSelection))

template FONT_SELECTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FONT_SELECTION, 
                           TFontSelectionClass))

template IS_FONT_SELECTION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FONT_SELECTION))

template IS_FONT_SELECTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FONT_SELECTION))

template FONT_SELECTION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FONT_SELECTION, 
                             TFontSelectionClass))

template TYPE_FONT_SELECTION_DIALOG*(): expr = 
  (gtk_font_selection_dialog_get_type())

template FONT_SELECTION_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FONT_SELECTION_DIALOG, 
                              TFontSelectionDialog))

template FONT_SELECTION_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FONT_SELECTION_DIALOG, 
                           TFontSelectionDialogClass))

template IS_FONT_SELECTION_DIALOG*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FONT_SELECTION_DIALOG))

template IS_FONT_SELECTION_DIALOG_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FONT_SELECTION_DIALOG))

template FONT_SELECTION_DIALOG_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FONT_SELECTION_DIALOG, 
                             TFontSelectionDialogClass))

type 
  PFontSelection* = ptr TFontSelection
  TFontSelection* = object of TBox
    priv134: PFontSelectionPrivate

type 
  PFontSelectionClass* = ptr TFontSelectionClass
  TFontSelectionClass* = object of TBoxClass
    ugtk_reserved1371*: proc () {.cdecl.}
    ugtk_reserved1372*: proc () {.cdecl.}
    ugtk_reserved1373*: proc () {.cdecl.}
    ugtk_reserved1374*: proc () {.cdecl.}

type 
  PFontSelectionDialog* = ptr TFontSelectionDialog
  TFontSelectionDialog* = object of TDialog
    priv135: PFontSelectionDialogPrivate

type 
  PFontSelectionDialogClass* = ptr TFontSelectionDialogClass
  TFontSelectionDialogClass* = object of TDialogClass
    ugtk_reserved1381*: proc () {.cdecl.}
    ugtk_reserved1382*: proc () {.cdecl.}
    ugtk_reserved1383*: proc () {.cdecl.}
    ugtk_reserved1384*: proc () {.cdecl.}

proc font_selection_get_type*(): GType {.cdecl, 
    importc: "gtk_font_selection_get_type", dynlib: lib.}
proc font_selection_new*(): PWidget {.cdecl, 
    importc: "gtk_font_selection_new", dynlib: lib.}
proc get_family_list*(fontsel: PFontSelection): PWidget {.
    cdecl, importc: "gtk_font_selection_get_family_list", dynlib: lib.}
proc get_face_list*(fontsel: PFontSelection): PWidget {.
    cdecl, importc: "gtk_font_selection_get_face_list", dynlib: lib.}
proc get_size_entry*(fontsel: PFontSelection): PWidget {.
    cdecl, importc: "gtk_font_selection_get_size_entry", dynlib: lib.}
proc get_size_list*(fontsel: PFontSelection): PWidget {.
    cdecl, importc: "gtk_font_selection_get_size_list", dynlib: lib.}
proc get_preview_entry*(fontsel: PFontSelection): PWidget {.
    cdecl, importc: "gtk_font_selection_get_preview_entry", dynlib: lib.}
proc get_family*(fontsel: PFontSelection): PFontFamily {.
    cdecl, importc: "gtk_font_selection_get_family", dynlib: lib.}
proc get_face*(fontsel: PFontSelection): pango.PFontFace {.
    cdecl, importc: "gtk_font_selection_get_face", dynlib: lib.}
proc get_size*(fontsel: PFontSelection): gint {.
    cdecl, importc: "gtk_font_selection_get_size", dynlib: lib.}
proc get_font_name*(fontsel: PFontSelection): CSTRING {.
    cdecl, importc: "gtk_font_selection_get_font_name", dynlib: lib.}
proc set_font_name*(fontsel: PFontSelection; 
    fontname: CSTRING): gboolean {.cdecl, importc: "gtk_font_selection_set_font_name", 
                                     dynlib: lib.}
proc get_preview_text*(fontsel: PFontSelection): CSTRING {.
    cdecl, importc: "gtk_font_selection_get_preview_text", dynlib: lib.}
proc set_preview_text*(fontsel: PFontSelection; 
    text: CSTRING) {.cdecl, importc: "gtk_font_selection_set_preview_text", 
                       dynlib: lib.}
proc font_selection_dialog_get_type*(): GType {.cdecl, 
    importc: "gtk_font_selection_dialog_get_type", dynlib: lib.}
proc font_selection_dialog_new*(title: CSTRING): PWidget {.cdecl, 
    importc: "gtk_font_selection_dialog_new", dynlib: lib.}
proc get_ok_button*(fsd: PFontSelectionDialog): PWidget {.
    cdecl, importc: "gtk_font_selection_dialog_get_ok_button", dynlib: lib.}
proc get_cancel_button*(
    fsd: PFontSelectionDialog): PWidget {.cdecl, 
    importc: "gtk_font_selection_dialog_get_cancel_button", dynlib: lib.}
proc get_font_selection*(
    fsd: PFontSelectionDialog): PWidget {.cdecl, 
    importc: "gtk_font_selection_dialog_get_font_selection", dynlib: lib.}
proc get_font_name*(fsd: PFontSelectionDialog): CSTRING {.
    cdecl, importc: "gtk_font_selection_dialog_get_font_name", dynlib: lib.}
proc set_font_name*(fsd: PFontSelectionDialog; 
    fontname: CSTRING): gboolean {.cdecl, importc: "gtk_font_selection_dialog_set_font_name", 
                                     dynlib: lib.}
proc get_preview_text*(
    fsd: PFontSelectionDialog): CSTRING {.cdecl, 
    importc: "gtk_font_selection_dialog_get_preview_text", dynlib: lib.}
proc set_preview_text*(
    fsd: PFontSelectionDialog; text: CSTRING) {.cdecl, 
    importc: "gtk_font_selection_dialog_set_preview_text", dynlib: lib.}

template TYPE_SYMBOLIC_COLOR*(): expr = 
  (gtk_symbolic_color_get_type())

proc symbolic_color_get_type*(): GType {.cdecl, 
    importc: "gtk_symbolic_color_get_type", dynlib: lib.}
proc symbolic_color_new_literal*(color: PRGBA): PSymbolicColor {.
    cdecl, importc: "gtk_symbolic_color_new_literal", dynlib: lib.}
proc symbolic_color_new_name*(name: CSTRING): PSymbolicColor {.
    cdecl, importc: "gtk_symbolic_color_new_name", dynlib: lib.}
proc new_shade*(color: PSymbolicColor; 
                                   factor: gdouble): PSymbolicColor {.
    cdecl, importc: "gtk_symbolic_color_new_shade", dynlib: lib.}
proc new_alpha*(color: PSymbolicColor; 
                                   factor: gdouble): PSymbolicColor {.
    cdecl, importc: "gtk_symbolic_color_new_alpha", dynlib: lib.}
proc new_mix*(color1: PSymbolicColor; 
                                 color2: PSymbolicColor; factor: gdouble): PSymbolicColor {.
    cdecl, importc: "gtk_symbolic_color_new_mix", dynlib: lib.}
proc symbolic_color_new_win32*(theme_class: CSTRING; id: gint): PSymbolicColor {.
    cdecl, importc: "gtk_symbolic_color_new_win32", dynlib: lib.}
proc re*(color: PSymbolicColor): PSymbolicColor {.
    cdecl, importc: "gtk_symbolic_color_ref", dynlib: lib.}
proc unref*(color: PSymbolicColor) {.cdecl, 
    importc: "gtk_symbolic_color_unref", dynlib: lib.}
proc to_string*(color: PSymbolicColor): cstring {.
    cdecl, importc: "gtk_symbolic_color_to_string", dynlib: lib.}
proc resolve*(color: PSymbolicColor; 
                                 props: PStyleProperties; 
                                 resolved_color: PRGBA): gboolean {.
    cdecl, importc: "gtk_symbolic_color_resolve", dynlib: lib.}

template TYPE_GRADIENT*(): expr = 
  (gtk_gradient_get_type())

proc gradient_get_type*(): GType {.cdecl, 
    importc: "gtk_gradient_get_type", dynlib: lib.}
proc gradient_new_linear*(x0: gdouble; y0: gdouble; x1: gdouble; 
                              y1: gdouble): PGradient {.cdecl, 
    importc: "gtk_gradient_new_linear", dynlib: lib.}
proc gradient_new_radial*(x0: gdouble; y0: gdouble; radius0: gdouble; 
                              x1: gdouble; y1: gdouble; radius1: gdouble): PGradient {.
    cdecl, importc: "gtk_gradient_new_radial", dynlib: lib.}
proc add_color_stop*(gradient: PGradient; offset: gdouble; 
                                  color: PSymbolicColor) {.cdecl, 
    importc: "gtk_gradient_add_color_stop", dynlib: lib.}
proc re*(gradient: PGradient): PGradient {.cdecl, 
    importc: "gtk_gradient_ref", dynlib: lib.}
proc unref*(gradient: PGradient) {.cdecl, 
    importc: "gtk_gradient_unref", dynlib: lib.}
proc resolve*(gradient: PGradient; 
                           props: PStyleProperties; 
                           resolved_gradient: var Ppattern): gboolean {.
    cdecl, importc: "gtk_gradient_resolve", dynlib: lib.}
proc resolve_for_context*(gradient: PGradient; 
    context: PStyleContext): Ppattern {.cdecl, 
    importc: "gtk_gradient_resolve_for_context", dynlib: lib.}
proc to_string*(gradient: PGradient): cstring {.cdecl, 
    importc: "gtk_gradient_to_string", dynlib: lib.}

template TYPE_HANDLE_BOX*(): expr = 
  (gtk_handle_box_get_type())

template HANDLE_BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_HANDLE_BOX, THandleBox))

template HANDLE_BOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_HANDLE_BOX, THandleBoxClass))

template IS_HANDLE_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_HANDLE_BOX))

template IS_HANDLE_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_HANDLE_BOX))

template HANDLE_BOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_HANDLE_BOX, THandleBoxClass))

type 
  PHandleBox* = ptr THandleBox
  THandleBox* = object of TBin
    priv136: PHandleBoxPrivate

type 
  PHandleBoxClass* = ptr THandleBoxClass
  THandleBoxClass* = object of TBinClass
    child_attached*: proc (handle_box: PHandleBox; child: PWidget) {.
        cdecl.}
    child_detached*: proc (handle_box: PHandleBox; child: PWidget) {.
        cdecl.}
    ugtk_reserved1391*: proc () {.cdecl.}
    ugtk_reserved1392*: proc () {.cdecl.}
    ugtk_reserved1393*: proc () {.cdecl.}
    ugtk_reserved1394*: proc () {.cdecl.}

proc handle_box_get_type*(): GType {.cdecl, 
    importc: "gtk_handle_box_get_type", dynlib: lib.}
proc handle_box_new*(): PWidget {.cdecl, 
    importc: "gtk_handle_box_new", dynlib: lib.}
proc set_shadow_type*(handle_box: PHandleBox; 
                                     typ: TShadowType) {.cdecl, 
    importc: "gtk_handle_box_set_shadow_type", dynlib: lib.}
proc get_shadow_type*(handle_box: PHandleBox): TShadowType {.
    cdecl, importc: "gtk_handle_box_get_shadow_type", dynlib: lib.}
proc set_handle_position*(handle_box: PHandleBox; 
    position: TPositionType) {.cdecl, importc: "gtk_handle_box_set_handle_position", 
                                 dynlib: lib.}
proc get_handle_position*(handle_box: PHandleBox): TPositionType {.
    cdecl, importc: "gtk_handle_box_get_handle_position", dynlib: lib.}
proc set_snap_edge*(handle_box: PHandleBox; 
                                   edge: TPositionType) {.cdecl, 
    importc: "gtk_handle_box_set_snap_edge", dynlib: lib.}
proc get_snap_edge*(handle_box: PHandleBox): TPositionType {.
    cdecl, importc: "gtk_handle_box_get_snap_edge", dynlib: lib.}
proc get_child_detached*(handle_box: PHandleBox): gboolean {.
    cdecl, importc: "gtk_handle_box_get_child_detached", dynlib: lib.}

template TYPE_HBUTTON_BOX*(): expr = 
  (gtk_hbutton_box_get_type())

template HBUTTON_BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_HBUTTON_BOX, THButtonBox))

template HBUTTON_BOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_HBUTTON_BOX, THButtonBoxClass))

template IS_HBUTTON_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_HBUTTON_BOX))

template IS_HBUTTON_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_HBUTTON_BOX))

template HBUTTON_BOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_HBUTTON_BOX, THButtonBoxClass))

type 
  PHButtonBox* = ptr THButtonBox
  THButtonBox* = object of TButtonBox

type 
  PHButtonBoxClass* = ptr THButtonBoxClass
  THButtonBoxClass* = object of TButtonBoxClass

proc hbutton_box_get_type*(): GType {.cdecl, 
    importc: "gtk_hbutton_box_get_type", dynlib: lib.}
proc hbutton_box_new*(): PWidget {.cdecl, 
    importc: "gtk_hbutton_box_new", dynlib: lib.}

template TYPE_HBOX*(): expr = 
  (gtk_hbox_get_type())

template HBOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_HBOX, THBox))

template HBOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_HBOX, THBoxClass))

template IS_HBOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_HBOX))

template IS_HBOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_HBOX))

template HBOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_HBOX, THBoxClass))

type 
  PHBox* = ptr THBox
  THBox* = object of TBox

type 
  PHBoxClass* = ptr THBoxClass
  THBoxClass* = object of TBoxClass

proc hbox_get_type*(): GType {.cdecl, importc: "gtk_hbox_get_type", 
                                   dynlib: lib.}
proc hbox_new*(homogeneous: gboolean; spacing: gint): PWidget {.
    cdecl, importc: "gtk_hbox_new", dynlib: lib.}

template TYPE_HPANED*(): expr = 
  (gtk_hpaned_get_type())

template HPANED_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_HPANED, THPaned))

template HPANED_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_HPANED, THPanedClass))

template IS_HPANED*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_HPANED))

template IS_HPANED_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_HPANED))

template HPANED_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_HPANED, THPanedClass))

type 
  PHPaned* = ptr THPaned
  THPaned* = object of TPaned

type 
  PHPanedClass* = ptr THPanedClass
  THPanedClass* = object of TPanedClass

proc hpaned_get_type*(): GType {.cdecl, importc: "gtk_hpaned_get_type", 
                                     dynlib: lib.}
proc hpaned_new*(): PWidget {.cdecl, importc: "gtk_hpaned_new", 
    dynlib: lib.}

template TYPE_HSV*(): expr = 
  (gtk_hsv_get_type())

template HSV_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_HSV, THSV))

template HSV_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_HSV, THSVClass))

template IS_HSV*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_HSV))

template IS_HSV_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_HSV))

template HSV_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_HSV, THSVClass))

type 
  PHSV* = ptr THSV
  THSV* = object of TWidget
    priv137: PHSVPrivate

type 
  PHSVClass* = ptr THSVClass
  THSVClass* = object of TWidgetClass
    changed*: proc (hsv: PHSV) {.cdecl.}
    move*: proc (hsv: PHSV; typ: TDirectionType) {.cdecl.}
    ugtk_reserved1401*: proc () {.cdecl.}
    ugtk_reserved1402*: proc () {.cdecl.}
    ugtk_reserved1403*: proc () {.cdecl.}
    ugtk_reserved1404*: proc () {.cdecl.}

proc hsv_get_type*(): GType {.cdecl, importc: "gtk_hsv_get_type", 
                                  dynlib: lib.}
proc hsv_new*(): PWidget {.cdecl, importc: "gtk_hsv_new", 
                                     dynlib: lib.}
proc set_color*(hsv: PHSV; h: cdouble; s: cdouble; v: cdouble) {.
    cdecl, importc: "gtk_hsv_set_color", dynlib: lib.}
proc get_color*(hsv: PHSV; h: Pgdouble; s: Pgdouble; 
                        v: Pgdouble) {.cdecl, importc: "gtk_hsv_get_color", 
    dynlib: lib.}
proc set_metrics*(hsv: PHSV; size: gint; ring_width: gint) {.
    cdecl, importc: "gtk_hsv_set_metrics", dynlib: lib.}
proc get_metrics*(hsv: PHSV; size: Pgint; 
                          ring_width: Pgint) {.cdecl, 
    importc: "gtk_hsv_get_metrics", dynlib: lib.}
proc is_adjusting*(hsv: PHSV): gboolean {.cdecl, 
    importc: "gtk_hsv_is_adjusting", dynlib: lib.}

template TYPE_HSCALE*(): expr = 
  (gtk_hscale_get_type())

template HSCALE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_HSCALE, THScale))

template HSCALE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_HSCALE, THScaleClass))

template IS_HSCALE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_HSCALE))

template IS_HSCALE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_HSCALE))

template HSCALE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_HSCALE, THScaleClass))

type 
  PHScale* = ptr THScale
  THScale* = object of TScale

type 
  PHScaleClass* = ptr THScaleClass
  THScaleClass* = object of TScaleClass

proc hscale_get_type*(): GType {.cdecl, importc: "gtk_hscale_get_type", 
                                     dynlib: lib.}
proc hscale_new*(adjustment: PAdjustment): PWidget {.cdecl, 
    importc: "gtk_hscale_new", dynlib: lib.}
proc hscale_new_with_range*(min: gdouble; max: gdouble; step: gdouble): PWidget {.
    cdecl, importc: "gtk_hscale_new_with_range", dynlib: lib.}

template TYPE_HSCROLLBAR*(): expr = 
  (gtk_hscrollbar_get_type())

template HSCROLLBAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_HSCROLLBAR, THScrollbar))

template HSCROLLBAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_HSCROLLBAR, THScrollbarClass))

template IS_HSCROLLBAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_HSCROLLBAR))

template IS_HSCROLLBAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_HSCROLLBAR))

template HSCROLLBAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_HSCROLLBAR, THScrollbarClass))

type 
  PHScrollbar* = ptr THScrollbar
  THScrollbar* = object of TScrollbar

type 
  PHScrollbarClass* = ptr THScrollbarClass
  THScrollbarClass* = object of TScrollbarClass

proc hscrollbar_get_type*(): GType {.cdecl, 
    importc: "gtk_hscrollbar_get_type", dynlib: lib.}
proc hscrollbar_new*(adjustment: PAdjustment): PWidget {.
    cdecl, importc: "gtk_hscrollbar_new", dynlib: lib.}

template TYPE_HSEPARATOR*(): expr = 
  (gtk_hseparator_get_type())

template HSEPARATOR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_HSEPARATOR, THSeparator))

template HSEPARATOR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_HSEPARATOR, THSeparatorClass))

template IS_HSEPARATOR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_HSEPARATOR))

template IS_HSEPARATOR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_HSEPARATOR))

template HSEPARATOR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_HSEPARATOR, THSeparatorClass))

type 
  PHSeparator* = ptr THSeparator
  THSeparator* = object of TSeparator

type 
  PHSeparatorClass* = ptr THSeparatorClass
  THSeparatorClass* = object of TSeparatorClass

proc hseparator_get_type*(): GType {.cdecl, 
    importc: "gtk_hseparator_get_type", dynlib: lib.}
proc hseparator_new*(): PWidget {.cdecl, 
    importc: "gtk_hseparator_new", dynlib: lib.}

template TYPE_IMAGE_MENU_ITEM*(): expr = 
  (gtk_image_menu_item_get_type())

template IMAGE_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_IMAGE_MENU_ITEM, 
                              TImageMenuItem))

template IMAGE_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_IMAGE_MENU_ITEM, 
                           TImageMenuItemClass))

template IS_IMAGE_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_IMAGE_MENU_ITEM))

template IS_IMAGE_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_IMAGE_MENU_ITEM))

template IMAGE_MENU_ITEM_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_IMAGE_MENU_ITEM, 
                             TImageMenuItemClass))

type 
  PImageMenuItem* = ptr TImageMenuItem
  TImageMenuItem* = object of TMenuItem
    priv138: PImageMenuItemPrivate

type 
  PImageMenuItemClass* = ptr TImageMenuItemClass
  TImageMenuItemClass* = object of TMenuItemClass
    ugtk_reserved1411*: proc () {.cdecl.}
    ugtk_reserved1412*: proc () {.cdecl.}
    ugtk_reserved1413*: proc () {.cdecl.}
    ugtk_reserved1414*: proc () {.cdecl.}

proc image_menu_item_get_type*(): GType {.cdecl, 
    importc: "gtk_image_menu_item_get_type", dynlib: lib.}
proc image_menu_item_new*(): PWidget {.cdecl, 
    importc: "gtk_image_menu_item_new", dynlib: lib.}
proc image_menu_item_new_with_label*(label: CSTRING): PWidget {.
    cdecl, importc: "gtk_image_menu_item_new_with_label", dynlib: lib.}
proc image_menu_item_new_with_mnemonic*(label: CSTRING): PWidget {.
    cdecl, importc: "gtk_image_menu_item_new_with_mnemonic", dynlib: lib.}
proc image_menu_item_new_from_stock*(stock_id: CSTRING; 
    accel_group: PAccelGroup): PWidget {.cdecl, 
    importc: "gtk_image_menu_item_new_from_stock", dynlib: lib.}
proc set_always_show_image*(
    image_menu_item: PImageMenuItem; always_show: gboolean) {.cdecl, 
    importc: "gtk_image_menu_item_set_always_show_image", dynlib: lib.}
proc get_always_show_image*(
    image_menu_item: PImageMenuItem): gboolean {.cdecl, 
    importc: "gtk_image_menu_item_get_always_show_image", dynlib: lib.}
proc set_image*(image_menu_item: PImageMenuItem; 
                                    image: PWidget) {.cdecl, 
    importc: "gtk_image_menu_item_set_image", dynlib: lib.}
proc get_image*(image_menu_item: PImageMenuItem): PWidget {.
    cdecl, importc: "gtk_image_menu_item_get_image", dynlib: lib.}
proc set_use_stock*(image_menu_item: PImageMenuItem; 
    use_stock: gboolean) {.cdecl, 
                           importc: "gtk_image_menu_item_set_use_stock", 
                           dynlib: lib.}
proc get_use_stock*(image_menu_item: PImageMenuItem): gboolean {.
    cdecl, importc: "gtk_image_menu_item_get_use_stock", dynlib: lib.}
proc set_accel_group*(
    image_menu_item: PImageMenuItem; accel_group: PAccelGroup) {.
    cdecl, importc: "gtk_image_menu_item_set_accel_group", dynlib: lib.}

template TYPE_TOGGLE_ACTION*(): expr = 
  (gtk_toggle_action_get_type())

template TOGGLE_ACTION_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TOGGLE_ACTION, TToggleAction))

template TOGGLE_ACTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TOGGLE_ACTION, 
                           TToggleActionClass))

template IS_TOGGLE_ACTION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TOGGLE_ACTION))

template IS_TOGGLE_ACTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TOGGLE_ACTION))

template TOGGLE_ACTION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TOGGLE_ACTION, 
                             TToggleActionClass))

type 
  PToggleAction* = ptr TToggleAction
  TToggleAction* = object of TAction
    private_data2*: PToggleActionPrivate

type 
  PToggleActionClass* = ptr TToggleActionClass
  TToggleActionClass* = object of TActionClass
    toggled*: proc (action: PToggleAction) {.cdecl.}
    ugtk_reserved1421*: proc () {.cdecl.}
    ugtk_reserved1422*: proc () {.cdecl.}
    ugtk_reserved1423*: proc () {.cdecl.}
    ugtk_reserved1424*: proc () {.cdecl.}

proc toggle_action_get_type*(): GType {.cdecl, 
    importc: "gtk_toggle_action_get_type", dynlib: lib.}
proc toggle_action_new*(name: CSTRING; label: CSTRING; 
                            tooltip: CSTRING; stock_id: CSTRING): PToggleAction {.
    cdecl, importc: "gtk_toggle_action_new", dynlib: lib.}
proc toggled*(action: PToggleAction) {.cdecl, 
    importc: "gtk_toggle_action_toggled", dynlib: lib.}
proc set_active*(action: PToggleAction; 
                                   is_active: gboolean) {.cdecl, 
    importc: "gtk_toggle_action_set_active", dynlib: lib.}
proc get_active*(action: PToggleAction): gboolean {.
    cdecl, importc: "gtk_toggle_action_get_active", dynlib: lib.}
proc set_draw_as_radio*(action: PToggleAction; 
    draw_as_radio: gboolean) {.cdecl, importc: "gtk_toggle_action_set_draw_as_radio", 
                               dynlib: lib.}
proc get_draw_as_radio*(action: PToggleAction): gboolean {.
    cdecl, importc: "gtk_toggle_action_get_draw_as_radio", dynlib: lib.}
proc underscore_gtk_toggle_action_set_active*(toggle_action: PToggleAction; 
                                    is_active: gboolean) {.cdecl, 
    importc: "_gtk_toggle_action_set_active", dynlib: lib.}

template TYPE_RADIO_ACTION*(): expr = 
  (gtk_radio_action_get_type())

template RADIO_ACTION_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RADIO_ACTION, TRadioAction))

template RADIO_ACTION_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RADIO_ACTION, TRadioActionClass))

template IS_RADIO_ACTION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RADIO_ACTION))

template IS_RADIO_ACTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RADIO_ACTION))

template RADIO_ACTION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RADIO_ACTION, TRadioActionClass))

type 
  PRadioAction* = ptr TRadioAction
  TRadioAction* = object of TToggleAction
    private_data*: PRadioActionPrivate

type 
  PRadioActionClass* = ptr TRadioActionClass
  TRadioActionClass* = object of TToggleActionClass
    changed*: proc (action: PRadioAction; current: PRadioAction) {.
        cdecl.}
    ugtk_reserved1431*: proc () {.cdecl.}
    ugtk_reserved1432*: proc () {.cdecl.}
    ugtk_reserved1433*: proc () {.cdecl.}
    ugtk_reserved1434*: proc () {.cdecl.}

proc radio_action_get_type*(): GType {.cdecl, 
    importc: "gtk_radio_action_get_type", dynlib: lib.}
proc radio_action_new*(name: CSTRING; label: CSTRING; 
                           tooltip: CSTRING; stock_id: CSTRING; 
                           value: gint): PRadioAction {.cdecl, 
    importc: "gtk_radio_action_new", dynlib: lib.}
proc get_group*(action: PRadioAction): PGSList {.
    cdecl, importc: "gtk_radio_action_get_group", dynlib: lib.}
proc set_group*(action: PRadioAction; group: PGSList) {.
    cdecl, importc: "gtk_radio_action_set_group", dynlib: lib.}
proc join_group*(action: PRadioAction; 
                                  group_source: PRadioAction) {.cdecl, 
    importc: "gtk_radio_action_join_group", dynlib: lib.}
proc get_current_value*(action: PRadioAction): gint {.
    cdecl, importc: "gtk_radio_action_get_current_value", dynlib: lib.}
proc set_current_value*(action: PRadioAction; 
    current_value: gint) {.cdecl, 
                           importc: "gtk_radio_action_set_current_value", 
                           dynlib: lib.}

template TYPE_RC_STYLE*(): expr = 
  (gtk_rc_style_get_type())

template RC_STYLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RC_STYLE, TRcStyle))

template RC_STYLE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RC_STYLE, TRcStyleClass))

template IS_RC_STYLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RC_STYLE))

template IS_RC_STYLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RC_STYLE))

template RC_STYLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RC_STYLE, TRcStyleClass))

type 
  TRcFlags* {.size: sizeof(cint).} = enum 
    RC_FG = 1 shl 0, RC_BG = 1 shl 1, RC_TEXT = 1 shl 2, 
    RC_BASE = 1 shl 3
type 
  PRcStyle* = ptr TRcStyle
  TRcStyle* = object of TGObject
    name*: CSTRING
    bg_pixmap_name*: array[5, ptr gchar]
    font_desc*: PFontDescription
    color_flags*: array[5, TRcFlags]
    fg*: array[5, gdk3.TColor]
    bg*: array[5, gdk3.TColor]
    text*: array[5, gdk3.TColor]
    base*: array[5, gdk3.TColor]
    xthickness*: gint
    ythickness*: gint
    rc_properties*: PGArray
    rc_style_lists*: PGSList
    icon_factories*: PGSList
    engine_specified*: guint

type 
  PRcStyleClass* = ptr TRcStyleClass
  TRcStyleClass* = object of TGObjectClass
    create_rc_style*: proc (rc_style: PRcStyle): PRcStyle {.cdecl.}
    parse*: proc (rc_style: PRcStyle; settings: PSettings; 
                  scanner: PGScanner): guint {.cdecl.}
    merge*: proc (dest: PRcStyle; src: PRcStyle) {.cdecl.}
    create_style*: proc (rc_style: PRcStyle): PStyle {.cdecl.}
    ugtk_reserved1441*: proc () {.cdecl.}
    ugtk_reserved1442*: proc () {.cdecl.}
    ugtk_reserved1443*: proc () {.cdecl.}
    ugtk_reserved1444*: proc () {.cdecl.}

proc underscore_gtk_rc_parse_widget_class_path*(pattern: CSTRING): PGSList {.cdecl, 
    importc: "_gtk_rc_parse_widget_class_path", dynlib: lib.}
proc underscore_gtk_rc_free_widget_class_path*(list: PGSList) {.cdecl, 
    importc: "_gtk_rc_free_widget_class_path", dynlib: lib.}
proc underscore_gtk_rc_match_widget_class*(list: PGSList; length: gint; 
                                 path: CSTRING; path_reversed: CSTRING): gboolean {.
    cdecl, importc: "_gtk_rc_match_widget_class", dynlib: lib.}
proc rc_add_default_file*(filename: CSTRING) {.cdecl, 
    importc: "gtk_rc_add_default_file", dynlib: lib.}
proc rc_set_default_files*(filenames: ptr CSTRING) {.cdecl, 
    importc: "gtk_rc_set_default_files", dynlib: lib.}
proc rc_get_default_files*(): ptr CSTRING {.cdecl, 
    importc: "gtk_rc_get_default_files", dynlib: lib.}
proc rc_get_style*(widget: PWidget): PStyle {.cdecl, 
    importc: "gtk_rc_get_style", dynlib: lib.}
proc rc_get_style_by_paths*(settings: PSettings; 
                                widget_path: cstring; class_path: cstring; 
                                typ: GType): PStyle {.cdecl, 
    importc: "gtk_rc_get_style_by_paths", dynlib: lib.}
proc rc_reparse_all_for_settings*(settings: PSettings; 
                                      force_load: gboolean): gboolean {.cdecl, 
    importc: "gtk_rc_reparse_all_for_settings", dynlib: lib.}
proc rc_reset_styles*(settings: PSettings) {.cdecl, 
    importc: "gtk_rc_reset_styles", dynlib: lib.}
proc rc_find_pixmap_in_path*(settings: PSettings; 
                                 scanner: PGScanner; pixmap_file: CSTRING): CSTRING {.
    cdecl, importc: "gtk_rc_find_pixmap_in_path", dynlib: lib.}
proc rc_parse*(filename: CSTRING) {.cdecl, importc: "gtk_rc_parse", 
    dynlib: lib.}
proc rc_parse_string*(rc_string: CSTRING) {.cdecl, 
    importc: "gtk_rc_parse_string", dynlib: lib.}
proc rc_reparse_all*(): gboolean {.cdecl, importc: "gtk_rc_reparse_all", 
    dynlib: lib.}
proc rc_style_get_type*(): GType {.cdecl, 
    importc: "gtk_rc_style_get_type", dynlib: lib.}
proc rc_style_new*(): PRcStyle {.cdecl, importc: "gtk_rc_style_new", 
    dynlib: lib.}
proc copy*(orig: PRcStyle): PRcStyle {.cdecl, 
    importc: "gtk_rc_style_copy", dynlib: lib.}
proc rc_find_module_in_path*(module_file: CSTRING): CSTRING {.cdecl, 
    importc: "gtk_rc_find_module_in_path", dynlib: lib.}
proc rc_get_theme_dir*(): CSTRING {.cdecl, 
    importc: "gtk_rc_get_theme_dir", dynlib: lib.}
proc rc_get_module_dir*(): CSTRING {.cdecl, 
    importc: "gtk_rc_get_module_dir", dynlib: lib.}
proc rc_get_im_module_path*(): CSTRING {.cdecl, 
    importc: "gtk_rc_get_im_module_path", dynlib: lib.}
proc rc_get_im_module_file*(): CSTRING {.cdecl, 
    importc: "gtk_rc_get_im_module_file", dynlib: lib.}
type 
  TRcTokenType* {.size: sizeof(cint).} = enum 
    RC_TOKEN_INVALID = G_TOKEN_LAST, RC_TOKEN_INCLUDE, 
    RC_TOKEN_NORMAL, RC_TOKEN_ACTIVE, RC_TOKEN_PRELIGHT, 
    RC_TOKEN_SELECTED, RC_TOKEN_INSENSITIVE, RC_TOKEN_FG, 
    RC_TOKEN_BG, RC_TOKEN_TEXT, RC_TOKEN_BASE, 
    RC_TOKEN_XTHICKNESS, RC_TOKEN_YTHICKNESS, RC_TOKEN_FONT, 
    RC_TOKEN_FONTSET, RC_TOKEN_FONT_NAME, RC_TOKEN_BG_PIXMAP, 
    RC_TOKEN_PIXMAP_PATH, RC_TOKEN_STYLE, RC_TOKEN_BINDING, 
    RC_TOKEN_BIND, RC_TOKEN_WIDGET, RC_TOKEN_WIDGET_CLASS, 
    RC_TOKEN_CLASS, RC_TOKEN_LOWEST, RC_TOKEN_GTK, 
    RC_TOKEN_APPLICATION, RC_TOKEN_THEME, RC_TOKEN_RC, 
    RC_TOKEN_HIGHEST, RC_TOKEN_ENGINE, RC_TOKEN_MODULE_PATH, 
    RC_TOKEN_IM_MODULE_PATH, RC_TOKEN_IM_MODULE_FILE, 
    RC_TOKEN_STOCK, RC_TOKEN_LTR, RC_TOKEN_RTL, 
    RC_TOKEN_COLOR, RC_TOKEN_UNBIND, RC_TOKEN_LAST
proc rc_scanner_new*(): PGScanner {.cdecl, 
    importc: "gtk_rc_scanner_new", dynlib: lib.}
proc rc_parse_color*(scanner: PGScanner; color: gdk3.PColor): guint {.
    cdecl, importc: "gtk_rc_parse_color", dynlib: lib.}
proc rc_parse_color_full*(scanner: PGScanner; style: PRcStyle; 
                              color: gdk3.PColor): guint {.cdecl, 
    importc: "gtk_rc_parse_color_full", dynlib: lib.}
proc rc_parse_state*(scanner: PGScanner; state: PStateType): guint {.
    cdecl, importc: "gtk_rc_parse_state", dynlib: lib.}
proc rc_parse_priority*(scanner: PGScanner; 
                            priority: var TPathPriorityType): guint {.cdecl, 
    importc: "gtk_rc_parse_priority", dynlib: lib.}
type 
  PRcProperty* = ptr TRcProperty
  TRcProperty*{.final, pure.} = object 
    type_name*: TGQuark
    property_name*: TGQuark
    origin*: CSTRING
    value*: TGValue


template TYPE_RECENT_ACTION*(): expr = 
  (gtk_recent_action_get_type())

template RECENT_ACTION_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RECENT_ACTION, TRecentAction))

template IS_RECENT_ACTION*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RECENT_ACTION))

template RECENT_ACTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RECENT_ACTION, 
                           TRecentActionClass))

template IS_RECENT_ACTION_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RECENT_ACTION))

template RECENT_ACTION_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RECENT_ACTION, 
                             TRecentActionClass))

type 
  PRecentAction* = ptr TRecentAction
  TRecentAction* = object of TAction
    priv139: PRecentActionPrivate

type 
  PRecentActionClass* = ptr TRecentActionClass
  TRecentActionClass* = object of TActionClass
    ugtk_reserved1451*: proc () {.cdecl.}
    ugtk_reserved1452*: proc () {.cdecl.}
    ugtk_reserved1453*: proc () {.cdecl.}
    ugtk_reserved1454*: proc () {.cdecl.}

proc recent_action_get_type*(): GType {.cdecl, 
    importc: "gtk_recent_action_get_type", dynlib: lib.}
proc recent_action_new*(name: CSTRING; label: CSTRING; 
                            tooltip: CSTRING; stock_id: CSTRING): PAction {.
    cdecl, importc: "gtk_recent_action_new", dynlib: lib.}
proc recent_action_new_for_manager*(name: CSTRING; label: CSTRING; 
    tooltip: CSTRING; stock_id: CSTRING; manager: PRecentManager): PAction {.
    cdecl, importc: "gtk_recent_action_new_for_manager", dynlib: lib.}
proc get_show_numbers*(action: PRecentAction): gboolean {.
    cdecl, importc: "gtk_recent_action_get_show_numbers", dynlib: lib.}
proc set_show_numbers*(action: PRecentAction; 
    show_numbers: gboolean) {.cdecl, 
                              importc: "gtk_recent_action_set_show_numbers", 
                              dynlib: lib.}

template TYPE_STYLE*(): expr = 
  (gtk_style_get_type())

template STYLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_STYLE, TStyle))

template STYLE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_STYLE, TStyleClass))

template IS_STYLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_STYLE))

template IS_STYLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_STYLE))

template STYLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_STYLE, TStyleClass))

template STYLE_ATTACHED*(style: expr): expr = 
  (STYLE(style).attach_count > 0)

type 
  PStyle* = ptr TStyle
  TStyle* = object of TGObject
    fg*: array[5, gdk3.TColor]
    bg*: array[5, gdk3.TColor]
    light*: array[5, gdk3.TColor]
    dark*: array[5, gdk3.TColor]
    mid*: array[5, gdk3.TColor]
    text*: array[5, gdk3.TColor]
    base*: array[5, gdk3.TColor]
    text_aa*: array[5, gdk3.TColor]
    black*: gdk3.TColor
    white*: gdk3.TColor
    font_desc*: PFontDescription
    xthickness*: gint
    ythickness*: gint
    background*: array[5, ptr Ppattern]
    attach_count*: gint
    visual*: PGdkVisual
    private_font_desc*: PFontDescription
    rc_style*: PRcStyle
    styles*: PGSList
    property_cache*: PGArray
    icon_factories*: PGSList

type 
  PStyleClass* = ptr TStyleClass
  TStyleClass* = object of TGObjectClass
    realize*: proc (style: PStyle) {.cdecl.}
    unrealize*: proc (style: PStyle) {.cdecl.}
    copy*: proc (style: PStyle; src: PStyle) {.cdecl.}
    clone*: proc (style: PStyle): PStyle {.cdecl.}
    init_from_rc*: proc (style: PStyle; rc_style: PRcStyle) {.
        cdecl.}
    set_background*: proc (style: PStyle; window: PGdkWindow; 
                           state_type: TStateType) {.cdecl.}
    render_icon*: proc (style: PStyle; source: PIconSource; 
                        direction: TTextDirection; state: TStateType; 
                        size: TIconSize; widget: PWidget; 
                        detail: CSTRING): PPixbuf {.cdecl.}
    draw_hline*: proc (style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; widget: PWidget; 
                       detail: CSTRING; x1: gint; x2: gint; y: gint) {.cdecl.}
    draw_vline*: proc (style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; widget: PWidget; 
                       detail: CSTRING; y1: gint; y2: gint; x: gint) {.
        cdecl.}
    draw_shadow*: proc (style: PStyle; cr: cairo.Pcontext; 
                        state_type: TStateType; shadow_type: TShadowType; 
                        widget: PWidget; detail: CSTRING; x: gint; 
                        y: gint; width: gint; height: gint) {.cdecl.}
    draw_arrow*: proc (style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; shadow_type: TShadowType; 
                       widget: PWidget; detail: CSTRING; 
                       arrow_type: TArrowType; fill: gboolean; x: gint; 
                       y: gint; width: gint; height: gint) {.cdecl.}
    draw_diamond*: proc (style: PStyle; cr: cairo.Pcontext; 
                         state_type: TStateType; shadow_type: TShadowType; 
                         widget: PWidget; detail: CSTRING; x: gint; 
                         y: gint; width: gint; height: gint) {.cdecl.}
    draw_box*: proc (style: PStyle; cr: cairo.Pcontext; 
                     state_type: TStateType; shadow_type: TShadowType; 
                     widget: PWidget; detail: CSTRING; x: gint; 
                     y: gint; width: gint; height: gint) {.cdecl.}
    draw_flat_box*: proc (style: PStyle; cr: cairo.Pcontext; 
                          state_type: TStateType; 
                          shadow_type: TShadowType; widget: PWidget; 
                          detail: CSTRING; x: gint; y: gint; width: gint; 
                          height: gint) {.cdecl.}
    draw_check*: proc (style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; shadow_type: TShadowType; 
                       widget: PWidget; detail: CSTRING; x: gint; 
                       y: gint; width: gint; height: gint) {.cdecl.}
    draw_option*: proc (style: PStyle; cr: cairo.Pcontext; 
                        state_type: TStateType; shadow_type: TShadowType; 
                        widget: PWidget; detail: CSTRING; x: gint; 
                        y: gint; width: gint; height: gint) {.cdecl.}
    draw_tab*: proc (style: PStyle; cr: cairo.Pcontext; 
                     state_type: TStateType; shadow_type: TShadowType; 
                     widget: PWidget; detail: CSTRING; x: gint; 
                     y: gint; width: gint; height: gint) {.cdecl.}
    draw_shadow_gap*: proc (style: PStyle; cr: cairo.Pcontext; 
                            state_type: TStateType; 
                            shadow_type: TShadowType; widget: PWidget; 
                            detail: CSTRING; x: gint; y: gint; width: gint; 
                            height: gint; gap_side: TPositionType; 
                            gap_x: gint; gap_width: gint) {.cdecl.}
    draw_box_gap*: proc (style: PStyle; cr: cairo.Pcontext; 
                         state_type: TStateType; shadow_type: TShadowType; 
                         widget: PWidget; detail: CSTRING; x: gint; 
                         y: gint; width: gint; height: gint; 
                         gap_side: TPositionType; gap_x: gint; 
                         gap_width: gint) {.cdecl.}
    draw_extension*: proc (style: PStyle; cr: cairo.Pcontext; 
                           state_type: TStateType; 
                           shadow_type: TShadowType; widget: PWidget; 
                           detail: CSTRING; x: gint; y: gint; width: gint; 
                           height: gint; gap_side: TPositionType) {.cdecl.}
    draw_focus*: proc (style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; widget: PWidget; 
                       detail: CSTRING; x: gint; y: gint; width: gint; 
                       height: gint) {.cdecl.}
    draw_slider*: proc (style: PStyle; cr: cairo.Pcontext; 
                        state_type: TStateType; shadow_type: TShadowType; 
                        widget: PWidget; detail: CSTRING; x: gint; 
                        y: gint; width: gint; height: gint; 
                        orientation: TOrientation) {.cdecl.}
    draw_handle*: proc (style: PStyle; cr: cairo.Pcontext; 
                        state_type: TStateType; shadow_type: TShadowType; 
                        widget: PWidget; detail: CSTRING; x: gint; 
                        y: gint; width: gint; height: gint; 
                        orientation: TOrientation) {.cdecl.}
    draw_expander*: proc (style: PStyle; cr: cairo.Pcontext; 
                          state_type: TStateType; widget: PWidget; 
                          detail: CSTRING; x: gint; y: gint; 
                          expander_style: TExpanderStyle) {.cdecl.}
    draw_layout*: proc (style: PStyle; cr: cairo.Pcontext; 
                        state_type: TStateType; use_text: gboolean; 
                        widget: PWidget; detail: CSTRING; x: gint; 
                        y: gint; layout: Playout) {.cdecl.}
    draw_resize_grip*: proc (style: PStyle; cr: cairo.Pcontext; 
                             state_type: TStateType; widget: PWidget; 
                             detail: CSTRING; edge: TWindowEdge; x: gint; 
                             y: gint; width: gint; height: gint) {.cdecl.}
    draw_spinner*: proc (style: PStyle; cr: cairo.Pcontext; 
                         state_type: TStateType; widget: PWidget; 
                         detail: CSTRING; step: guint; x: gint; y: gint; 
                         width: gint; height: gint) {.cdecl.}
    ugtk_reserved1461*: proc () {.cdecl.}
    ugtk_reserved1462*: proc () {.cdecl.}
    ugtk_reserved1463*: proc () {.cdecl.}
    ugtk_reserved1464*: proc () {.cdecl.}
    ugtk_reserved1465*: proc () {.cdecl.}
    ugtk_reserved1466*: proc () {.cdecl.}
    ugtk_reserved1467*: proc () {.cdecl.}
    ugtk_reserved1468*: proc () {.cdecl.}
    ugtk_reserved1469*: proc () {.cdecl.}
    ugtk_reserved10: proc () {.cdecl.}
    ugtk_reserved11: proc () {.cdecl.}

proc style_get_type*(): GType {.cdecl, importc: "gtk_style_get_type", 
                                    dynlib: lib.}
proc style_new*(): PStyle {.cdecl, importc: "gtk_style_new", 
                                      dynlib: lib.}
proc copy*(style: PStyle): PStyle {.cdecl, 
    importc: "gtk_style_copy", dynlib: lib.}
proc attach*(style: PStyle; window: PGdkWindow): PStyle {.
    cdecl, importc: "gtk_style_attach", dynlib: lib.}
proc detach*(style: PStyle) {.cdecl, 
    importc: "gtk_style_detach", dynlib: lib.}
proc set_background*(style: PStyle; window: PGdkWindow; 
                               state_type: TStateType) {.cdecl, 
    importc: "gtk_style_set_background", dynlib: lib.}
proc apply_default_background*(style: PStyle; cr: cairo.Pcontext; 
    window: PGdkWindow; state_type: TStateType; x: gint; y: gint; 
    width: gint; height: gint) {.cdecl, importc: "gtk_style_apply_default_background", 
                                 dynlib: lib.}
proc lookup_icon_set*(style: PStyle; stock_id: CSTRING): PIconSet {.
    cdecl, importc: "gtk_style_lookup_icon_set", dynlib: lib.}
proc lookup_color*(style: PStyle; color_name: CSTRING; 
                             color: gdk3.PColor): gboolean {.cdecl, 
    importc: "gtk_style_lookup_color", dynlib: lib.}
proc render_icon*(style: PStyle; source: PIconSource; 
                            direction: TTextDirection; state: TStateType; 
                            size: TIconSize; widget: PWidget; 
                            detail: CSTRING): PPixbuf {.cdecl, 
    importc: "gtk_style_render_icon", dynlib: lib.}
proc paint_hline*(style: PStyle; cr: cairo.Pcontext; 
                      state_type: TStateType; widget: PWidget; 
                      detail: CSTRING; x1: gint; x2: gint; y: gint) {.cdecl, 
    importc: "gtk_paint_hline", dynlib: lib.}
proc paint_vline*(style: PStyle; cr: cairo.Pcontext; 
                      state_type: TStateType; widget: PWidget; 
                      detail: CSTRING; y1: gint; y2: gint; x: gint) {.
    cdecl, importc: "gtk_paint_vline", dynlib: lib.}
proc paint_shadow*(style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; shadow_type: TShadowType; 
                       widget: PWidget; detail: CSTRING; x: gint; 
                       y: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_shadow", dynlib: lib.}
proc paint_arrow*(style: PStyle; cr: cairo.Pcontext; 
                      state_type: TStateType; shadow_type: TShadowType; 
                      widget: PWidget; detail: CSTRING; 
                      arrow_type: TArrowType; fill: gboolean; x: gint; 
                      y: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_arrow", dynlib: lib.}
proc paint_diamond*(style: PStyle; cr: cairo.Pcontext; 
                        state_type: TStateType; shadow_type: TShadowType; 
                        widget: PWidget; detail: CSTRING; x: gint; 
                        y: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_diamond", dynlib: lib.}
proc paint_box*(style: PStyle; cr: cairo.Pcontext; 
                    state_type: TStateType; shadow_type: TShadowType; 
                    widget: PWidget; detail: CSTRING; x: gint; 
                    y: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_box", dynlib: lib.}
proc paint_flat_box*(style: PStyle; cr: cairo.Pcontext; 
                         state_type: TStateType; shadow_type: TShadowType; 
                         widget: PWidget; detail: CSTRING; x: gint; 
                         y: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_flat_box", dynlib: lib.}
proc paint_check*(style: PStyle; cr: cairo.Pcontext; 
                      state_type: TStateType; shadow_type: TShadowType; 
                      widget: PWidget; detail: CSTRING; x: gint; 
                      y: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_check", dynlib: lib.}
proc paint_option*(style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; shadow_type: TShadowType; 
                       widget: PWidget; detail: CSTRING; x: gint; 
                       y: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_option", dynlib: lib.}
proc paint_tab*(style: PStyle; cr: cairo.Pcontext; 
                    state_type: TStateType; shadow_type: TShadowType; 
                    widget: PWidget; detail: CSTRING; x: gint; 
                    y: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_tab", dynlib: lib.}
proc paint_shadow_gap*(style: PStyle; cr: cairo.Pcontext; 
                           state_type: TStateType; 
                           shadow_type: TShadowType; widget: PWidget; 
                           detail: CSTRING; x: gint; y: gint; width: gint; 
                           height: gint; gap_side: TPositionType; 
                           gap_x: gint; gap_width: gint) {.cdecl, 
    importc: "gtk_paint_shadow_gap", dynlib: lib.}
proc paint_box_gap*(style: PStyle; cr: cairo.Pcontext; 
                        state_type: TStateType; shadow_type: TShadowType; 
                        widget: PWidget; detail: CSTRING; x: gint; 
                        y: gint; width: gint; height: gint; 
                        gap_side: TPositionType; gap_x: gint; 
                        gap_width: gint) {.cdecl, 
    importc: "gtk_paint_box_gap", dynlib: lib.}
proc paint_extension*(style: PStyle; cr: cairo.Pcontext; 
                          state_type: TStateType; 
                          shadow_type: TShadowType; widget: PWidget; 
                          detail: CSTRING; x: gint; y: gint; width: gint; 
                          height: gint; gap_side: TPositionType) {.cdecl, 
    importc: "gtk_paint_extension", dynlib: lib.}
proc paint_focus*(style: PStyle; cr: cairo.Pcontext; 
                      state_type: TStateType; widget: PWidget; 
                      detail: CSTRING; x: gint; y: gint; width: gint; 
                      height: gint) {.cdecl, importc: "gtk_paint_focus", 
                                      dynlib: lib.}
proc paint_slider*(style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; shadow_type: TShadowType; 
                       widget: PWidget; detail: CSTRING; x: gint; 
                       y: gint; width: gint; height: gint; 
                       orientation: TOrientation) {.cdecl, 
    importc: "gtk_paint_slider", dynlib: lib.}
proc paint_handle*(style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; shadow_type: TShadowType; 
                       widget: PWidget; detail: CSTRING; x: gint; 
                       y: gint; width: gint; height: gint; 
                       orientation: TOrientation) {.cdecl, 
    importc: "gtk_paint_handle", dynlib: lib.}
proc paint_expander*(style: PStyle; cr: cairo.Pcontext; 
                         state_type: TStateType; widget: PWidget; 
                         detail: CSTRING; x: gint; y: gint; 
                         expander_style: TExpanderStyle) {.cdecl, 
    importc: "gtk_paint_expander", dynlib: lib.}
proc paint_layout*(style: PStyle; cr: cairo.Pcontext; 
                       state_type: TStateType; use_text: gboolean; 
                       widget: PWidget; detail: CSTRING; x: gint; 
                       y: gint; layout: Playout) {.cdecl, 
    importc: "gtk_paint_layout", dynlib: lib.}
proc paint_resize_grip*(style: PStyle; cr: cairo.Pcontext; 
                            state_type: TStateType; widget: PWidget; 
                            detail: CSTRING; edge: TWindowEdge; x: gint; 
                            y: gint; width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_resize_grip", dynlib: lib.}
proc paint_spinner*(style: PStyle; cr: cairo.Pcontext; 
                        state_type: TStateType; widget: PWidget; 
                        detail: CSTRING; step: guint; x: gint; y: gint; 
                        width: gint; height: gint) {.cdecl, 
    importc: "gtk_paint_spinner", dynlib: lib.}
proc get_style_property*(style: PStyle; widget_type: GType; 
                                   property_name: CSTRING; value: PGValue) {.
    cdecl, importc: "gtk_style_get_style_property", dynlib: lib.}
proc get_valist*(style: PStyle; widget_type: GType; 
                           first_property_name: CSTRING; var_args: va_list) {.
    cdecl, importc: "gtk_style_get_valist", dynlib: lib.}
proc get*(style: PStyle; widget_type: GType; 
                    first_property_name: CSTRING) {.varargs, cdecl, 
    importc: "gtk_style_get", dynlib: lib.}
proc underscore_gtk_style_new_for_path*(screen: PGdkScreen; path: PWidgetPath): PStyle {.
    cdecl, importc: "_gtk_style_new_for_path", dynlib: lib.}
proc underscore_gtk_style_shade*(a: gdk3.PColor; b: gdk3.PColor; k: gdouble) {.cdecl, 
    importc: "_gtk_style_shade", dynlib: lib.}
proc has_context*(style: PStyle): gboolean {.cdecl, 
    importc: "gtk_style_has_context", dynlib: lib.}
proc style_attach*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_style_attach", dynlib: lib.}
proc has_rc_style*(widget: PWidget): gboolean {.cdecl, 
    importc: "gtk_widget_has_rc_style", dynlib: lib.}
proc set_style*(widget: PWidget; style: PStyle) {.
    cdecl, importc: "gtk_widget_set_style", dynlib: lib.}
proc ensure_style*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_ensure_style", dynlib: lib.}
proc get_style*(widget: PWidget): PStyle {.cdecl, 
    importc: "gtk_widget_get_style", dynlib: lib.}
proc modify_style*(widget: PWidget; style: PRcStyle) {.
    cdecl, importc: "gtk_widget_modify_style", dynlib: lib.}
proc get_modifier_style*(widget: PWidget): PRcStyle {.
    cdecl, importc: "gtk_widget_get_modifier_style", dynlib: lib.}
proc modify_fg*(widget: PWidget; state: TStateType; 
                           color: gdk3.PColor) {.cdecl, 
    importc: "gtk_widget_modify_fg", dynlib: lib.}
proc modify_bg*(widget: PWidget; state: TStateType; 
                           color: gdk3.PColor) {.cdecl, 
    importc: "gtk_widget_modify_bg", dynlib: lib.}
proc modify_text*(widget: PWidget; state: TStateType; 
                             color: gdk3.PColor) {.cdecl, 
    importc: "gtk_widget_modify_text", dynlib: lib.}
proc modify_base*(widget: PWidget; state: TStateType; 
                             color: gdk3.PColor) {.cdecl, 
    importc: "gtk_widget_modify_base", dynlib: lib.}
proc modify_cursor*(widget: PWidget; primary: gdk3.PColor; 
                               secondary: gdk3.PColor) {.cdecl, 
    importc: "gtk_widget_modify_cursor", dynlib: lib.}
proc modify_font*(widget: PWidget; 
                             font_desc: PFontDescription) {.cdecl, 
    importc: "gtk_widget_modify_font", dynlib: lib.}
proc reset_rc_styles*(widget: PWidget) {.cdecl, 
    importc: "gtk_widget_reset_rc_styles", dynlib: lib.}
proc widget_get_default_style*(): PStyle {.cdecl, 
    importc: "gtk_widget_get_default_style", dynlib: lib.}
proc path*(widget: PWidget; path_length: Pguint; 
                      path: ptr CSTRING; path_reversed: ptr CSTRING) {.
    cdecl, importc: "gtk_widget_path", dynlib: lib.}
proc class_path*(widget: PWidget; path_length: Pguint; 
                            path: ptr CSTRING; path_reversed: ptr CSTRING) {.
    cdecl, importc: "gtk_widget_class_path", dynlib: lib.}
proc render_icon*(widget: PWidget; stock_id: CSTRING; 
                             size: TIconSize; detail: CSTRING): PPixbuf {.
    cdecl, importc: "gtk_widget_render_icon", dynlib: lib.}

template TYPE_TABLE*(): expr = 
  (gtk_table_get_type())

template TABLE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TABLE, TTable))

template TABLE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TABLE, TTableClass))

template IS_TABLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TABLE))

template IS_TABLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TABLE))

template TABLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TABLE, TTableClass))

type 
  PTable* = ptr TTable
  TTable* = object of TContainer
    priv140: PTablePrivate

type 
  PTableClass* = ptr TTableClass
  TTableClass* = object of TContainerClass
    ugtk_reserved1471*: proc () {.cdecl.}
    ugtk_reserved1472*: proc () {.cdecl.}
    ugtk_reserved1473*: proc () {.cdecl.}
    ugtk_reserved1474*: proc () {.cdecl.}

type 
  PTableChild* = ptr TTableChild
  TTableChild* = object of PWidget
    left_attach*: guint16
    right_attach*: guint16
    top_attach*: guint16
    bottom_attach*: guint16
    xpadding*: guint16
    ypadding*: guint16
    bitfield6*: guint

type 
  PTableRowCol* = ptr TTableRowCol
  TTableRowCol*{.final, pure.} = object 
    requisition*: guint16
    allocation*: guint16
    spacing*: guint16
    bitfield5*: guint

proc table_get_type*(): GType {.cdecl, importc: "gtk_table_get_type", 
                                    dynlib: lib.}
proc table_new*(rows: guint; columns: guint; homogeneous: gboolean): PWidget {.
    cdecl, importc: "gtk_table_new", dynlib: lib.}
proc resize*(table: PTable; rows: guint; columns: guint) {.
    cdecl, importc: "gtk_table_resize", dynlib: lib.}
proc attach*(table: PTable; child: PWidget; 
                       left_attach: guint; right_attach: guint; 
                       top_attach: guint; bottom_attach: guint; 
                       xoptions: TAttachOptions; yoptions: TAttachOptions; 
                       xpadding: guint; ypadding: guint) {.cdecl, 
    importc: "gtk_table_attach", dynlib: lib.}
proc attach_defaults*(table: PTable; widget: PWidget; 
                                left_attach: guint; right_attach: guint; 
                                top_attach: guint; bottom_attach: guint) {.
    cdecl, importc: "gtk_table_attach_defaults", dynlib: lib.}
proc set_row_spacing*(table: PTable; row: guint; 
                                spacing: guint) {.cdecl, 
    importc: "gtk_table_set_row_spacing", dynlib: lib.}
proc get_row_spacing*(table: PTable; row: guint): guint {.
    cdecl, importc: "gtk_table_get_row_spacing", dynlib: lib.}
proc set_col_spacing*(table: PTable; column: guint; 
                                spacing: guint) {.cdecl, 
    importc: "gtk_table_set_col_spacing", dynlib: lib.}
proc get_col_spacing*(table: PTable; column: guint): guint {.
    cdecl, importc: "gtk_table_get_col_spacing", dynlib: lib.}
proc set_row_spacings*(table: PTable; spacing: guint) {.cdecl, 
    importc: "gtk_table_set_row_spacings", dynlib: lib.}
proc get_default_row_spacing*(table: PTable): guint {.cdecl, 
    importc: "gtk_table_get_default_row_spacing", dynlib: lib.}
proc set_col_spacings*(table: PTable; spacing: guint) {.cdecl, 
    importc: "gtk_table_set_col_spacings", dynlib: lib.}
proc get_default_col_spacing*(table: PTable): guint {.cdecl, 
    importc: "gtk_table_get_default_col_spacing", dynlib: lib.}
proc set_homogeneous*(table: PTable; homogeneous: gboolean) {.
    cdecl, importc: "gtk_table_set_homogeneous", dynlib: lib.}
proc get_homogeneous*(table: PTable): gboolean {.cdecl, 
    importc: "gtk_table_get_homogeneous", dynlib: lib.}
proc get_size*(table: PTable; rows: Pguint; 
                         columns: Pguint) {.cdecl, 
    importc: "gtk_table_get_size", dynlib: lib.}

template TYPE_TEAROFF_MENU_ITEM*(): expr = 
  (gtk_tearoff_menu_item_get_type())

template TEAROFF_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_TEAROFF_MENU_ITEM, 
                              TTearoffMenuItem))

template TEAROFF_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_TEAROFF_MENU_ITEM, 
                           TTearoffMenuItemClass))

template IS_TEAROFF_MENU_ITEM*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_TEAROFF_MENU_ITEM))

template IS_TEAROFF_MENU_ITEM_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_TEAROFF_MENU_ITEM))

template TEAROFF_MENU_ITEM_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_TEAROFF_MENU_ITEM, 
                             TTearoffMenuItemClass))

type 
  PTearoffMenuItem* = ptr TTearoffMenuItem
  TTearoffMenuItem* = object of TMenuItem
    priv141: PTearoffMenuItemPrivate

type 
  PTearoffMenuItemClass* = ptr TTearoffMenuItemClass
  TTearoffMenuItemClass* = object of TMenuItemClass
    ugtk_reserved1481*: proc () {.cdecl.}
    ugtk_reserved1482*: proc () {.cdecl.}
    ugtk_reserved1483*: proc () {.cdecl.}
    ugtk_reserved1484*: proc () {.cdecl.}

proc tearoff_menu_item_get_type*(): GType {.cdecl, 
    importc: "gtk_tearoff_menu_item_get_type", dynlib: lib.}
proc tearoff_menu_item_new*(): PWidget {.cdecl, 
    importc: "gtk_tearoff_menu_item_new", dynlib: lib.}

template TYPE_UI_MANAGER*(): expr = 
  (gtk_ui_manager_get_type())

template UI_MANAGER_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_UI_MANAGER, TUIManager))

template UI_MANAGER_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_UI_MANAGER, TUIManagerClass))

template IS_UI_MANAGER*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_UI_MANAGER))

template IS_UI_MANAGER_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_UI_MANAGER))

template UI_MANAGER_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_UI_MANAGER, TUIManagerClass))

type 
  PUIManager* = ptr TUIManager
  TUIManager* = object of TGObject
    private_data*: PUIManagerPrivate

type 
  PUIManagerClass* = ptr TUIManagerClass
  TUIManagerClass* = object of TGObjectClass
    add_widget*: proc (manager: PUIManager; widget: PWidget) {.
        cdecl.}
    actions_changed*: proc (manager: PUIManager) {.cdecl.}
    connect_proxy*: proc (manager: PUIManager; action: PAction; 
                          proxy: PWidget) {.cdecl.}
    disconnect_proxy*: proc (manager: PUIManager; action: PAction; 
                             proxy: PWidget) {.cdecl.}
    pre_activate*: proc (manager: PUIManager; action: PAction) {.
        cdecl.}
    post_activate*: proc (manager: PUIManager; action: PAction) {.
        cdecl.}
    get_widget*: proc (manager: PUIManager; path: CSTRING): PWidget {.
        cdecl.}
    get_action*: proc (manager: PUIManager; path: CSTRING): PAction {.
        cdecl.}
    ugtk_reserved1491*: proc () {.cdecl.}
    ugtk_reserved1492*: proc () {.cdecl.}
    ugtk_reserved1493*: proc () {.cdecl.}
    ugtk_reserved1494*: proc () {.cdecl.}

type 
  TUIManagerItemType* {.size: sizeof(cint).} = enum 
    UI_MANAGER_AUTO = 0, UI_MANAGER_MENUBAR = 1 shl 0, 
    UI_MANAGER_MENU = 1 shl 1, UI_MANAGER_TOOLBAR = 1 shl 2, 
    UI_MANAGER_PLACEHOLDER = 1 shl 3, UI_MANAGER_POPUP = 1 shl 4, 
    UI_MANAGER_MENUITEM = 1 shl 5, UI_MANAGER_TOOLITEM = 1 shl 6, 
    UI_MANAGER_SEPARATOR = 1 shl 7, UI_MANAGER_ACCELERATOR = 1 shl
        8, UI_MANAGER_POPUP_WITH_ACCELS = 1 shl 9
proc ui_manager_get_type*(): GType {.cdecl, 
    importc: "gtk_ui_manager_get_type", dynlib: lib.}
proc ui_manager_new*(): PUIManager {.cdecl, 
    importc: "gtk_ui_manager_new", dynlib: lib.}
proc set_add_tearoffs*(manager: PUIManager; 
                                      add_tearoffs: gboolean) {.cdecl, 
    importc: "gtk_ui_manager_set_add_tearoffs", dynlib: lib.}
proc get_add_tearoffs*(manager: PUIManager): gboolean {.
    cdecl, importc: "gtk_ui_manager_get_add_tearoffs", dynlib: lib.}
proc insert_action_group*(manager: PUIManager; 
    action_group: PActionGroup; pos: gint) {.cdecl, 
    importc: "gtk_ui_manager_insert_action_group", dynlib: lib.}
proc remove_action_group*(manager: PUIManager; 
    action_group: PActionGroup) {.cdecl, 
    importc: "gtk_ui_manager_remove_action_group", dynlib: lib.}
proc get_action_groups*(manager: PUIManager): PGList {.
    cdecl, importc: "gtk_ui_manager_get_action_groups", dynlib: lib.}
proc get_accel_group*(manager: PUIManager): PAccelGroup {.
    cdecl, importc: "gtk_ui_manager_get_accel_group", dynlib: lib.}
proc get_widget*(manager: PUIManager; path: CSTRING): PWidget {.
    cdecl, importc: "gtk_ui_manager_get_widget", dynlib: lib.}
proc get_toplevels*(manager: PUIManager; 
                                   types: TUIManagerItemType): PGSList {.
    cdecl, importc: "gtk_ui_manager_get_toplevels", dynlib: lib.}
proc get_action*(manager: PUIManager; path: CSTRING): PAction {.
    cdecl, importc: "gtk_ui_manager_get_action", dynlib: lib.}
proc add_ui_from_string*(manager: PUIManager; 
    buffer: CSTRING; length: gssize; error: ptr PGError): guint {.cdecl, 
    importc: "gtk_ui_manager_add_ui_from_string", dynlib: lib.}
proc add_ui_from_file*(manager: PUIManager; 
                                      filename: CSTRING; 
                                      error: ptr PGError): guint {.cdecl, 
    importc: "gtk_ui_manager_add_ui_from_file", dynlib: lib.}
proc add_ui_from_resource*(manager: PUIManager; 
    resource_path: CSTRING; error: ptr PGError): guint {.cdecl, 
    importc: "gtk_ui_manager_add_ui_from_resource", dynlib: lib.}
proc add_ui*(manager: PUIManager; merge_id: guint; 
                            path: CSTRING; name: CSTRING; 
                            action: CSTRING; typ: TUIManagerItemType; 
                            top: gboolean) {.cdecl, 
    importc: "gtk_ui_manager_add_ui", dynlib: lib.}
proc remove_ui*(manager: PUIManager; merge_id: guint) {.
    cdecl, importc: "gtk_ui_manager_remove_ui", dynlib: lib.}
proc get_ui*(manager: PUIManager): CSTRING {.cdecl, 
    importc: "gtk_ui_manager_get_ui", dynlib: lib.}
proc ensure_update*(manager: PUIManager) {.cdecl, 
    importc: "gtk_ui_manager_ensure_update", dynlib: lib.}
proc new_merge_id*(manager: PUIManager): guint {.cdecl, 
    importc: "gtk_ui_manager_new_merge_id", dynlib: lib.}

template TYPE_VBUTTON_BOX*(): expr = 
  (gtk_vbutton_box_get_type())

template VBUTTON_BOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_VBUTTON_BOX, TVButtonBox))

template VBUTTON_BOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_VBUTTON_BOX, TVButtonBoxClass))

template IS_VBUTTON_BOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_VBUTTON_BOX))

template IS_VBUTTON_BOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_VBUTTON_BOX))

template VBUTTON_BOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_VBUTTON_BOX, TVButtonBoxClass))

type 
  PVButtonBox* = ptr TVButtonBox
  TVButtonBox* = object of TButtonBox

type 
  PVButtonBoxClass* = ptr TVButtonBoxClass
  TVButtonBoxClass* = object of TButtonBoxClass

proc vbutton_box_get_type*(): GType {.cdecl, 
    importc: "gtk_vbutton_box_get_type", dynlib: lib.}
proc vbutton_box_new*(): PWidget {.cdecl, 
    importc: "gtk_vbutton_box_new", dynlib: lib.}

template TYPE_VBOX*(): expr = 
  (gtk_vbox_get_type())

template VBOX_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_VBOX, TVBox))

template VBOX_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_VBOX, TVBoxClass))

template IS_VBOX*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_VBOX))

template IS_VBOX_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_VBOX))

template VBOX_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_VBOX, TVBoxClass))

type 
  PVBox* = ptr TVBox
  TVBox* = object of TBox

type 
  PVBoxClass* = ptr TVBoxClass
  TVBoxClass* = object of TBoxClass

proc vbox_get_type*(): GType {.cdecl, importc: "gtk_vbox_get_type", 
                                   dynlib: lib.}
proc vbox_new*(homogeneous: gboolean; spacing: gint): PWidget {.
    cdecl, importc: "gtk_vbox_new", dynlib: lib.}

template TYPE_VPANED*(): expr = 
  (gtk_vpaned_get_type())

template VPANED_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_VPANED, TVPaned))

template VPANED_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_VPANED, TVPanedClass))

template IS_VPANED*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_VPANED))

template IS_VPANED_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_VPANED))

template VPANED_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_VPANED, TVPanedClass))

type 
  PVPaned* = ptr TVPaned
  TVPaned* = object of TPaned

type 
  PVPanedClass* = ptr TVPanedClass
  TVPanedClass* = object of TPanedClass

proc vpaned_get_type*(): GType {.cdecl, importc: "gtk_vpaned_get_type", 
                                     dynlib: lib.}
proc vpaned_new*(): PWidget {.cdecl, importc: "gtk_vpaned_new", 
    dynlib: lib.}

template TYPE_VSCALE*(): expr = 
  (gtk_vscale_get_type())

template VSCALE_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_VSCALE, TVScale))

template VSCALE_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_VSCALE, TVScaleClass))

template IS_VSCALE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_VSCALE))

template IS_VSCALE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_VSCALE))

template VSCALE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_VSCALE, TVScaleClass))

type 
  PVScale* = ptr TVScale
  TVScale* = object of TScale

type 
  PVScaleClass* = ptr TVScaleClass
  TVScaleClass* = object of TScaleClass

proc vscale_get_type*(): GType {.cdecl, importc: "gtk_vscale_get_type", 
                                     dynlib: lib.}
proc vscale_new*(adjustment: PAdjustment): PWidget {.cdecl, 
    importc: "gtk_vscale_new", dynlib: lib.}
proc vscale_new_with_range*(min: gdouble; max: gdouble; step: gdouble): PWidget {.
    cdecl, importc: "gtk_vscale_new_with_range", dynlib: lib.}

template TYPE_VSCROLLBAR*(): expr = 
  (gtk_vscrollbar_get_type())

template VSCROLLBAR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_VSCROLLBAR, TVScrollbar))

template VSCROLLBAR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_VSCROLLBAR, TVScrollbarClass))

template IS_VSCROLLBAR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_VSCROLLBAR))

template IS_VSCROLLBAR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_VSCROLLBAR))

template VSCROLLBAR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_VSCROLLBAR, TVScrollbarClass))

type 
  PVScrollbar* = ptr TVScrollbar
  TVScrollbar* = object of TScrollbar

type 
  PVScrollbarClass* = ptr TVScrollbarClass
  TVScrollbarClass* = object of TScrollbarClass

proc vscrollbar_get_type*(): GType {.cdecl, 
    importc: "gtk_vscrollbar_get_type", dynlib: lib.}
proc vscrollbar_new*(adjustment: PAdjustment): PWidget {.
    cdecl, importc: "gtk_vscrollbar_new", dynlib: lib.}

template TYPE_VSEPARATOR*(): expr = 
  (gtk_vseparator_get_type())

template VSEPARATOR_TEMPLATE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_VSEPARATOR, TVSeparator))

template VSEPARATOR_CLASS_TEMPLATE*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_VSEPARATOR, TVSeparatorClass))

template IS_VSEPARATOR*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_VSEPARATOR))

template IS_VSEPARATOR_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_VSEPARATOR))

template VSEPARATOR_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_VSEPARATOR, TVSeparatorClass))

type 
  PVSeparator* = ptr TVSeparator
  TVSeparator* = object of TSeparator

type 
  PVSeparatorClass* = ptr TVSeparatorClass
  TVSeparatorClass* = object of TSeparatorClass

proc vseparator_get_type*(): GType {.cdecl, 
    importc: "gtk_vseparator_get_type", dynlib: lib.}
proc vseparator_new*(): PWidget {.cdecl, 
    importc: "gtk_vseparator_new", dynlib: lib.}

type 
  P_CellAccessibleParent* = ptr T_CellAccessibleParent
  T_CellAccessibleParent*{.final, pure.} = object 
  
type 
  P_WindowAccessiblePrivate* = ptr T_WindowAccessiblePrivate
  T_WindowAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_TreeViewAccessiblePrivate* = ptr T_TreeViewAccessiblePrivate
  T_TreeViewAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ToplevelAccessiblePrivate* = ptr T_ToplevelAccessiblePrivate
  T_ToplevelAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_TextViewAccessiblePrivate* = ptr T_TextViewAccessiblePrivate
  T_TextViewAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_TextCellAccessiblePrivate* = ptr T_TextCellAccessiblePrivate
  T_TextCellAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_SwitchAccessiblePrivate* = ptr T_SwitchAccessiblePrivate
  T_SwitchAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_StatusbarAccessiblePrivate* = ptr T_StatusbarAccessiblePrivate
  T_StatusbarAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_SpinnerAccessiblePrivate* = ptr T_SpinnerAccessiblePrivate
  T_SpinnerAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_SpinButtonAccessiblePrivate* = ptr T_SpinButtonAccessiblePrivate
  T_SpinButtonAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ScrolledWindowAccessiblePrivate* = ptr T_ScrolledWindowAccessiblePrivate
  T_ScrolledWindowAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ScaleButtonAccessiblePrivate* = ptr T_ScaleButtonAccessiblePrivate
  T_ScaleButtonAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ScaleAccessiblePrivate* = ptr T_ScaleAccessiblePrivate
  T_ScaleAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_RangeAccessiblePrivate* = ptr T_RangeAccessiblePrivate
  T_RangeAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_RadioMenuItemAccessiblePrivate* = ptr T_RadioMenuItemAccessiblePrivate
  T_RadioMenuItemAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_RadioButtonAccessiblePrivate* = ptr T_RadioButtonAccessiblePrivate
  T_RadioButtonAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ProgressBarAccessiblePrivate* = ptr T_ProgressBarAccessiblePrivate
  T_ProgressBarAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_PanedAccessiblePrivate* = ptr T_PanedAccessiblePrivate
  T_PanedAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_NotebookPageAccessiblePrivate* = ptr T_NotebookPageAccessiblePrivate
  T_NotebookPageAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_NotebookAccessiblePrivate* = ptr T_NotebookAccessiblePrivate
  T_NotebookAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_MenuButtonAccessiblePrivate* = ptr T_MenuButtonAccessiblePrivate
  T_MenuButtonAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ToggleButtonAccessiblePrivate* = ptr T_ToggleButtonAccessiblePrivate
  T_ToggleButtonAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_MenuAccessiblePrivate* = ptr T_MenuAccessiblePrivate
  T_MenuAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_MenuShellAccessiblePrivate* = ptr T_MenuShellAccessiblePrivate
  T_MenuShellAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_LockButtonAccessiblePrivate* = ptr T_LockButtonAccessiblePrivate
  T_LockButtonAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ListBoxAccessiblePrivate* = ptr T_ListBoxAccessiblePrivate
  T_ListBoxAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_LinkButtonAccessiblePrivate* = ptr T_LinkButtonAccessiblePrivate
  T_LinkButtonAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_LabelAccessiblePrivate* = ptr T_LabelAccessiblePrivate
  T_LabelAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_LevelBarAccessiblePrivate* = ptr T_LevelBarAccessiblePrivate
  T_LevelBarAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ImageCellAccessiblePrivate* = ptr T_ImageCellAccessiblePrivate
  T_ImageCellAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ImageAccessiblePrivate* = ptr T_ImageAccessiblePrivate
  T_ImageAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_IconViewAccessiblePrivate* = ptr T_IconViewAccessiblePrivate
  T_IconViewAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_FrameAccessiblePrivate* = ptr T_FrameAccessiblePrivate
  T_FrameAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_FlowBoxAccessiblePrivate* = ptr T_FlowBoxAccessiblePrivate
  T_FlowBoxAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ExpanderAccessiblePrivate* = ptr T_ExpanderAccessiblePrivate
  T_ExpanderAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_EntryAccessiblePrivate* = ptr T_EntryAccessiblePrivate
  T_EntryAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ContainerCellAccessiblePrivate* = ptr T_ContainerCellAccessiblePrivate
  T_ContainerCellAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ComboBoxAccessiblePrivate* = ptr T_ComboBoxAccessiblePrivate
  T_ComboBoxAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_CheckMenuItemAccessiblePrivate* = ptr T_CheckMenuItemAccessiblePrivate
  T_CheckMenuItemAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_MenuItemAccessiblePrivate* = ptr T_MenuItemAccessiblePrivate
  T_MenuItemAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ButtonAccessiblePrivate* = ptr T_ButtonAccessiblePrivate
  T_ButtonAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ContainerAccessiblePrivate* = ptr T_ContainerAccessiblePrivate
  T_ContainerAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_BooleanCellAccessiblePrivate* = ptr T_BooleanCellAccessiblePrivate
  T_BooleanCellAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_RendererCellAccessiblePrivate* = ptr T_RendererCellAccessiblePrivate
  T_RendererCellAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_CellAccessiblePrivate* = ptr T_CellAccessiblePrivate
  T_CellAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_ArrowAccessiblePrivate* = ptr T_ArrowAccessiblePrivate
  T_ArrowAccessiblePrivate*{.final, pure.} = object 
  
type 
  P_WidgetAccessiblePrivate* = ptr T_WidgetAccessiblePrivate
  T_WidgetAccessiblePrivate*{.final, pure.} = object 
  
template TYPE_WIDGET_ACCESSIBLE*(): expr = 
  (gtk_widget_accessible_get_type())

template WIDGET_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_WIDGET_ACCESSIBLE, 
                              TWidgetAccessible))

template WIDGET_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_WIDGET_ACCESSIBLE, 
                           TWidgetAccessibleClass))

template IS_WIDGET_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_WIDGET_ACCESSIBLE))

template IS_WIDGET_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_WIDGET_ACCESSIBLE))

template WIDGET_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_WIDGET_ACCESSIBLE, 
                             TWidgetAccessibleClass))

type 
  PWidgetAccessible* = ptr TWidgetAccessible
  TWidgetAccessible* = object of TAccessible
    priv142: PWidgetAccessiblePrivate

type 
  PWidgetAccessibleClass* = ptr TWidgetAccessibleClass
  TWidgetAccessibleClass* = object of TAccessibleClass
    notify_gtk*: proc (obj: PGObject; pspec: PGParamSpec) {.cdecl.}

proc widget_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_widget_accessible_get_type", dynlib: lib.}

template TYPE_ARROW_ACCESSIBLE*(): expr = 
  (gtk_arrow_accessible_get_type())

template ARROW_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ARROW_ACCESSIBLE, 
                              TArrowAccessible))

template ARROW_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ARROW_ACCESSIBLE, 
                           TArrowAccessibleClass))

template IS_ARROW_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ARROW_ACCESSIBLE))

template IS_ARROW_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ARROW_ACCESSIBLE))

template ARROW_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ARROW_ACCESSIBLE, 
                             TArrowAccessibleClass))

type 
  PArrowAccessible* = ptr TArrowAccessible
  TArrowAccessible* = object of TWidgetAccessible
    priv143: PArrowAccessiblePrivate

type 
  PArrowAccessibleClass* = ptr TArrowAccessibleClass
  TArrowAccessibleClass* = object of TWidgetAccessibleClass

proc arrow_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_arrow_accessible_get_type", dynlib: lib.}

template TYPE_CELL_ACCESSIBLE*(): expr = 
  (gtk_cell_accessible_get_type())

template CELL_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_ACCESSIBLE, 
                              TCellAccessible))

template CELL_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CELL_ACCESSIBLE, 
                           TCellAccessibleClass))

template IS_CELL_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_ACCESSIBLE))

template IS_CELL_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CELL_ACCESSIBLE))

template CELL_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CELL_ACCESSIBLE, 
                             TCellAccessibleClass))

type 
  PCellAccessible* = ptr TCellAccessible
  TCellAccessible* = object of TAccessible
    priv144: PCellAccessiblePrivate

type 
  PCellAccessibleClass* = ptr TCellAccessibleClass
  TCellAccessibleClass* = object of TAccessibleClass
    update_cache*: proc (cell: PCellAccessible) {.cdecl.}

proc cell_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_accessible_get_type", dynlib: lib.}

template TYPE_RENDERER_CELL_ACCESSIBLE*(): expr = 
  (gtk_renderer_cell_accessible_get_type())

template RENDERER_CELL_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_RENDERER_CELL_ACCESSIBLE, 
                              TRendererCellAccessible))

template RENDERER_CELL_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_RENDERER_CELL_ACCESSIBLE, 
                           TRendererCellAccessibleClass))

template IS_RENDERER_CELL_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_RENDERER_CELL_ACCESSIBLE))

template IS_RENDERER_CELL_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_RENDERER_CELL_ACCESSIBLE))

template RENDERER_CELL_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_RENDERER_CELL_ACCESSIBLE, 
                             TRendererCellAccessibleClass))

type 
  PRendererCellAccessible* = ptr TRendererCellAccessible
  TRendererCellAccessible* = object of TCellAccessible
    priv145: PRendererCellAccessiblePrivate

type 
  PRendererCellAccessibleClass* = ptr TRendererCellAccessibleClass
  TRendererCellAccessibleClass* = object of TCellAccessibleClass

proc renderer_cell_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_renderer_cell_accessible_get_type", dynlib: lib.}
proc cell_accessible_new*(renderer: PCellRenderer): atk.PObject {.
    cdecl, importc: "gtk_renderer_cell_accessible_new", dynlib: lib.}

template TYPE_BOOLEAN_CELL_ACCESSIBLE*(): expr = 
  (gtk_boolean_cell_accessible_get_type())

template BOOLEAN_CELL_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BOOLEAN_CELL_ACCESSIBLE, 
                              TBooleanCellAccessible))

template BOOLEAN_CELL_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), GAIL_BOOLEAN_CELL, 
                           TBooleanCellAccessibleClass))

template IS_BOOLEAN_CELL_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BOOLEAN_CELL_ACCESSIBLE))

template IS_BOOLEAN_CELL_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BOOLEAN_CELL_ACCESSIBLE))

template BOOLEAN_CELL_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BOOLEAN_CELL_ACCESSIBLE, 
                             TBooleanCellAccessibleClass))

type 
  PBooleanCellAccessible* = ptr TBooleanCellAccessible
  TBooleanCellAccessible* = object of TRendererCellAccessible
    priv146: PBooleanCellAccessiblePrivate

type 
  PBooleanCellAccessibleClass* = ptr TBooleanCellAccessibleClass
  TBooleanCellAccessibleClass* = object of TRendererCellAccessibleClass

proc boolean_cell_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_boolean_cell_accessible_get_type", dynlib: lib.}

template TYPE_CONTAINER_ACCESSIBLE*(): expr = 
  (gtk_container_accessible_get_type())

template CONTAINER_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CONTAINER_ACCESSIBLE, 
                              TContainerAccessible))

template CONTAINER_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CONTAINER_ACCESSIBLE, 
                           TContainerAccessibleClass))

template IS_CONTAINER_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CONTAINER_ACCESSIBLE))

template IS_CONTAINER_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CONTAINER_ACCESSIBLE))

template CONTAINER_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CONTAINER_ACCESSIBLE, 
                             TContainerAccessibleClass))

type 
  PContainerAccessible* = ptr TContainerAccessible
  TContainerAccessible* = object of TWidgetAccessible
    priv147: PContainerAccessiblePrivate

type 
  PContainerAccessibleClass* = ptr TContainerAccessibleClass
  TContainerAccessibleClass* = object of TWidgetAccessibleClass
    add_gtk*: proc (container: PContainer; widget: PWidget; 
                    data: gpointer): gint {.cdecl.}
    remove_gtk*: proc (container: PContainer; widget: PWidget; 
                       data: gpointer): gint {.cdecl.}

proc container_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_container_accessible_get_type", dynlib: lib.}

template TYPE_BUTTON_ACCESSIBLE*(): expr = 
  (gtk_button_accessible_get_type())

template BUTTON_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_BUTTON_ACCESSIBLE, 
                              TButtonAccessible))

template BUTTON_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_BUTTON_ACCESSIBLE, 
                           TButtonAccessibleClass))

template IS_BUTTON_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_BUTTON_ACCESSIBLE))

template IS_BUTTON_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_BUTTON_ACCESSIBLE))

template BUTTON_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_BUTTON_ACCESSIBLE, 
                             TButtonAccessibleClass))

type 
  PButtonAccessible* = ptr TButtonAccessible
  TButtonAccessible* = object of TContainerAccessible
    priv148: PButtonAccessiblePrivate

type 
  PButtonAccessibleClass* = ptr TButtonAccessibleClass
  TButtonAccessibleClass* = object of TContainerAccessibleClass

proc button_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_button_accessible_get_type", dynlib: lib.}

template TYPE_CELL_ACCESSIBLE_PARENT*(): expr = 
  (gtk_cell_accessible_parent_get_type())

template IS_CELL_ACCESSIBLE_PARENT*(obj: expr): expr = 
  G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CELL_ACCESSIBLE_PARENT)

template CELL_ACCESSIBLE_PARENT*(obj: expr): expr = 
  G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CELL_ACCESSIBLE_PARENT, 
                             CellAccessibleParent)

template CELL_ACCESSIBLE_PARENT_GET_IFACE*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TYPE_CELL_ACCESSIBLE_PARENT, 
                                 TCellAccessibleParentIface))

type 
  PCellAccessibleParentIface* = ptr TCellAccessibleParentIface
  TCellAccessibleParentIface* = object of TGTypeInterface
    get_cell_extents*: proc (parent: PCellAccessibleParent; 
                             cell: PCellAccessible; x: Pgint; 
                             y: Pgint; width: Pgint; height: Pgint; 
                             coord_type: TCoordType) {.cdecl.}
    get_cell_area*: proc (parent: PCellAccessibleParent; 
                          cell: PCellAccessible; 
                          cell_rect: gdk3.PRectangle) {.cdecl.}
    grab_focus*: proc (parent: PCellAccessibleParent; 
                       cell: PCellAccessible): gboolean {.cdecl.}
    get_child_index*: proc (parent: PCellAccessibleParent; 
                            cell: PCellAccessible): cint {.cdecl.}
    get_renderer_state*: proc (parent: PCellAccessibleParent; 
                               cell: PCellAccessible): TCellRendererState {.
        cdecl.}
    expand_collapse*: proc (parent: PCellAccessibleParent; 
                            cell: PCellAccessible) {.cdecl.}
    activate*: proc (parent: PCellAccessibleParent; 
                     cell: PCellAccessible) {.cdecl.}
    edit*: proc (parent: PCellAccessibleParent; 
                 cell: PCellAccessible) {.cdecl.}
    update_relationset*: proc (parent: PCellAccessibleParent; 
                               cell: PCellAccessible; 
                               relationset: PRelationSet) {.cdecl.}

proc cell_accessible_parent_get_type*(): GType {.cdecl, 
    importc: "gtk_cell_accessible_parent_get_type", dynlib: lib.}
proc get_cell_extents*(
    parent: PCellAccessibleParent; cell: PCellAccessible; 
    x: Pgint; y: Pgint; width: Pgint; height: Pgint; 
    coord_type: TCoordType) {.cdecl, importc: "gtk_cell_accessible_parent_get_cell_extents", 
                                dynlib: lib.}
proc get_cell_area*(
    parent: PCellAccessibleParent; cell: PCellAccessible; 
    cell_rect: gdk3.PRectangle) {.cdecl, importc: "gtk_cell_accessible_parent_get_cell_area", 
                                   dynlib: lib.}
proc grab_focus*(
    parent: PCellAccessibleParent; cell: PCellAccessible): gboolean {.
    cdecl, importc: "gtk_cell_accessible_parent_grab_focus", dynlib: lib.}
proc get_child_index*(
    parent: PCellAccessibleParent; cell: PCellAccessible): cint {.
    cdecl, importc: "gtk_cell_accessible_parent_get_child_index", dynlib: lib.}
proc get_renderer_state*(
    parent: PCellAccessibleParent; cell: PCellAccessible): TCellRendererState {.
    cdecl, importc: "gtk_cell_accessible_parent_get_renderer_state", 
    dynlib: lib.}
proc expand_collapse*(
    parent: PCellAccessibleParent; cell: PCellAccessible) {.cdecl, 
    importc: "gtk_cell_accessible_parent_expand_collapse", dynlib: lib.}
proc activate*(parent: PCellAccessibleParent; 
    cell: PCellAccessible) {.cdecl, importc: "gtk_cell_accessible_parent_activate", 
                                   dynlib: lib.}
proc edit*(parent: PCellAccessibleParent; 
                                      cell: PCellAccessible) {.cdecl, 
    importc: "gtk_cell_accessible_parent_edit", dynlib: lib.}
proc update_relationset*(
    parent: PCellAccessibleParent; cell: PCellAccessible; 
    relationset: PRelationSet) {.cdecl, 
    importc: "gtk_cell_accessible_parent_update_relationset", dynlib: lib.}

template TYPE_MENU_ITEM_ACCESSIBLE*(): expr = 
  (gtk_menu_item_accessible_get_type())

template MENU_ITEM_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MENU_ITEM_ACCESSIBLE, 
                              TMenuItemAccessible))

template MENU_ITEM_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MENU_ITEM_ACCESSIBLE, 
                           TMenuItemAccessibleClass))

template IS_MENU_ITEM_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MENU_ITEM_ACCESSIBLE))

template IS_MENU_ITEM_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MENU_ITEM_ACCESSIBLE))

template MENU_ITEM_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MENU_ITEM_ACCESSIBLE, 
                             TMenuItemAccessibleClass))

type 
  PMenuItemAccessible* = ptr TMenuItemAccessible
  TMenuItemAccessible* = object of TContainerAccessible
    priv149: PMenuItemAccessiblePrivate

type 
  PMenuItemAccessibleClass* = ptr TMenuItemAccessibleClass
  TMenuItemAccessibleClass* = object of TContainerAccessibleClass

proc menu_item_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_menu_item_accessible_get_type", dynlib: lib.}

template TYPE_CHECK_MENU_ITEM_ACCESSIBLE*(): expr = 
  (gtk_check_menu_item_accessible_get_type())

template CHECK_MENU_ITEM_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CHECK_MENU_ITEM_ACCESSIBLE, 
                              TCheckMenuItemAccessible))

template CHECK_MENU_ITEM_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CHECK_MENU_ITEM_ACCESSIBLE, 
                           TCheckMenuItemAccessibleClass))

template IS_CHECK_MENU_ITEM_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CHECK_MENU_ITEM_ACCESSIBLE))

template IS_CHECK_MENU_ITEM_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CHECK_MENU_ITEM_ACCESSIBLE))

template CHECK_MENU_ITEM_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CHECK_MENU_ITEM_ACCESSIBLE, 
                             TCheckMenuItemAccessibleClass))

type 
  PCheckMenuItemAccessible* = ptr TCheckMenuItemAccessible
  TCheckMenuItemAccessible* = object of TMenuItemAccessible
    priv150: PCheckMenuItemAccessiblePrivate

type 
  PCheckMenuItemAccessibleClass* = ptr TCheckMenuItemAccessibleClass
  TCheckMenuItemAccessibleClass* = object of TMenuItemAccessibleClass

proc check_menu_item_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_check_menu_item_accessible_get_type", dynlib: lib.}

template TYPE_COMBO_BOX_ACCESSIBLE*(): expr = 
  (gtk_combo_box_accessible_get_type())

template COMBO_BOX_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_COMBO_BOX_ACCESSIBLE, 
                              TComboBoxAccessible))

template COMBO_BOX_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_COMBO_BOX_ACCESSIBLE, 
                           TComboBoxAccessibleClass))

template IS_COMBO_BOX_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_COMBO_BOX_ACCESSIBLE))

template IS_COMBO_BOX_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_COMBO_BOX_ACCESSIBLE))

template COMBO_BOX_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_COMBO_BOX_ACCESSIBLE, 
                             TComboBoxAccessibleClass))

type 
  PComboBoxAccessible* = ptr TComboBoxAccessible
  TComboBoxAccessible* = object of TContainerAccessible
    priv151: PComboBoxAccessiblePrivate

type 
  PComboBoxAccessibleClass* = ptr TComboBoxAccessibleClass
  TComboBoxAccessibleClass* = object of TContainerAccessibleClass

proc combo_box_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_combo_box_accessible_get_type", dynlib: lib.}

template TYPE_CONTAINER_CELL_ACCESSIBLE*(): expr = 
  (gtk_container_cell_accessible_get_type())

template CONTAINER_CELL_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_CONTAINER_CELL_ACCESSIBLE, 
                              TContainerCellAccessible))

template CONTAINER_CELL_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_CONTAINER_CELL_ACCESSIBLE, 
                           TContainerCellAccessibleClass))

template IS_CONTAINER_CELL_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_CONTAINER_CELL_ACCESSIBLE))

template IS_CONTAINER_CELL_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_CONTAINER_CELL_ACCESSIBLE))

template CONTAINER_CELL_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_CONTAINER_CELL_ACCESSIBLE, 
                             TContainerCellAccessibleClass))

type 
  PContainerCellAccessible* = ptr TContainerCellAccessible
  TContainerCellAccessible* = object of TCellAccessible
    priv152: PContainerCellAccessiblePrivate

type 
  PContainerCellAccessibleClass* = ptr TContainerCellAccessibleClass
  TContainerCellAccessibleClass* = object of TCellAccessibleClass

proc container_cell_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_container_cell_accessible_get_type", dynlib: lib.}
proc container_cell_accessible_new*(): PContainerCellAccessible {.
    cdecl, importc: "gtk_container_cell_accessible_new", dynlib: lib.}
proc add_child*(
    container: PContainerCellAccessible; child: PCellAccessible) {.
    cdecl, importc: "gtk_container_cell_accessible_add_child", dynlib: lib.}
proc remove_child*(
    container: PContainerCellAccessible; child: PCellAccessible) {.
    cdecl, importc: "gtk_container_cell_accessible_remove_child", dynlib: lib.}
proc get_children*(
    container: PContainerCellAccessible): PGList {.cdecl, 
    importc: "gtk_container_cell_accessible_get_children", dynlib: lib.}

template TYPE_ENTRY_ACCESSIBLE*(): expr = 
  (gtk_entry_accessible_get_type())

template ENTRY_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ENTRY_ACCESSIBLE, 
                              TEntryAccessible))

template ENTRY_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ENTRY_ACCESSIBLE, 
                           TEntryAccessibleClass))

template IS_ENTRY_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ENTRY_ACCESSIBLE))

template IS_ENTRY_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ENTRY_ACCESSIBLE))

template ENTRY_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ENTRY_ACCESSIBLE, 
                             TEntryAccessibleClass))

type 
  PEntryAccessible* = ptr TEntryAccessible
  TEntryAccessible* = object of TWidgetAccessible
    priv153: PEntryAccessiblePrivate

type 
  PEntryAccessibleClass* = ptr TEntryAccessibleClass
  TEntryAccessibleClass* = object of TWidgetAccessibleClass

proc entry_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_entry_accessible_get_type", dynlib: lib.}
proc entry_icon_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_entry_icon_accessible_get_type", dynlib: lib.}

template TYPE_EXPANDER_ACCESSIBLE*(): expr = 
  (gtk_expander_accessible_get_type())

template EXPANDER_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_EXPANDER_ACCESSIBLE, 
                              TExpanderAccessible))

template EXPANDER_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_EXPANDER_ACCESSIBLE, 
                           TExpanderAccessibleClass))

template IS_EXPANDER_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_EXPANDER_ACCESSIBLE))

template IS_EXPANDER_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_EXPANDER_ACCESSIBLE))

template EXPANDER_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_EXPANDER_ACCESSIBLE, 
                             TExpanderAccessibleClass))

type 
  PExpanderAccessible* = ptr TExpanderAccessible
  TExpanderAccessible* = object of TContainerAccessible
    priv154: PExpanderAccessiblePrivate

type 
  PExpanderAccessibleClass* = ptr TExpanderAccessibleClass
  TExpanderAccessibleClass* = object of TContainerAccessibleClass

proc expander_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_expander_accessible_get_type", dynlib: lib.}

template TYPE_FLOW_BOX_ACCESSIBLE*(): expr = 
  (gtk_flow_box_accessible_get_type())

template FLOW_BOX_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FLOW_BOX_ACCESSIBLE, 
                              TFlowBoxAccessible))

template FLOW_BOX_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FLOW_BOX_ACCESSIBLE, 
                           TFlowBoxAccessibleClass))

template IS_FLOW_BOX_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FLOW_BOX_ACCESSIBLE))

template IS_FLOW_BOX_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FLOW_BOX_ACCESSIBLE))

template FLOW_BOX_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FLOW_BOX_ACCESSIBLE, 
                             TFlowBoxAccessibleClass))

type 
  PFlowBoxAccessible* = ptr TFlowBoxAccessible
  TFlowBoxAccessible* = object of TContainerAccessible
    priv155: PFlowBoxAccessiblePrivate

type 
  PFlowBoxAccessibleClass* = ptr TFlowBoxAccessibleClass
  TFlowBoxAccessibleClass* = object of TContainerAccessibleClass

proc flow_box_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_flow_box_accessible_get_type", dynlib: lib.}

template TYPE_FLOW_BOX_CHILD_ACCESSIBLE*(): expr = 
  (gtk_flow_box_child_accessible_get_type())

template FLOW_BOX_CHILD_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FLOW_BOX_CHILD_ACCESSIBLE, 
                              TFlowBoxChildAccessible))

template FLOW_BOX_CHILD_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FLOW_BOX_CHILD_ACCESSIBLE, 
                           TFlowBoxChildAccessibleClass))

template IS_FLOW_BOX_CHILD_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FLOW_BOX_CHILD_ACCESSIBLE))

template IS_FLOW_BOX_CHILD_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FLOW_BOX_CHILD_ACCESSIBLE))

template FLOW_BOX_CHILD_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FLOW_BOX_CHILD_ACCESSIBLE, 
                             TFlowBoxChildAccessibleClass))

type 
  PFlowBoxChildAccessible* = ptr TFlowBoxChildAccessible
  TFlowBoxChildAccessible* = object of TContainerAccessible

type 
  PFlowBoxChildAccessibleClass* = ptr TFlowBoxChildAccessibleClass
  TFlowBoxChildAccessibleClass* = object of TContainerAccessibleClass

proc flow_box_child_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_flow_box_child_accessible_get_type", dynlib: lib.}

template TYPE_FRAME_ACCESSIBLE*(): expr = 
  (gtk_frame_accessible_get_type())

template FRAME_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_FRAME_ACCESSIBLE, 
                              TFrameAccessible))

template FRAME_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_FRAME_ACCESSIBLE, 
                           TFrameAccessibleClass))

template IS_FRAME_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_FRAME_ACCESSIBLE))

template IS_FRAME_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_FRAME_ACCESSIBLE))

template FRAME_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_FRAME_ACCESSIBLE, 
                             TFrameAccessibleClass))

type 
  PFrameAccessible* = ptr TFrameAccessible
  TFrameAccessible* = object of TContainerAccessible
    priv156: PFrameAccessiblePrivate

type 
  PFrameAccessibleClass* = ptr TFrameAccessibleClass
  TFrameAccessibleClass* = object of TContainerAccessibleClass

proc frame_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_frame_accessible_get_type", dynlib: lib.}

template TYPE_ICON_VIEW_ACCESSIBLE*(): expr = 
  (gtk_icon_view_accessible_get_type())

template ICON_VIEW_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_ICON_VIEW_ACCESSIBLE, 
                              TIconViewAccessible))

template ICON_VIEW_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_ICON_VIEW_ACCESSIBLE, 
                           TIconViewAccessibleClass))

template IS_ICON_VIEW_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_ICON_VIEW_ACCESSIBLE))

template IS_ICON_VIEW_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_ICON_VIEW_ACCESSIBLE))

template ICON_VIEW_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_ICON_VIEW_ACCESSIBLE, 
                             TIconViewAccessibleClass))

type 
  PIconViewAccessible* = ptr TIconViewAccessible
  TIconViewAccessible* = object of TContainerAccessible
    priv157: PIconViewAccessiblePrivate

type 
  PIconViewAccessibleClass* = ptr TIconViewAccessibleClass
  TIconViewAccessibleClass* = object of TContainerAccessibleClass

proc icon_view_accessible_get_type*(): GType {.cdecl, 
    importc: "gtk_icon_view_accessible_get_type", dynlib: lib.}

template TYPE_IMAGE_ACCESSIBLE*(): expr = 
  (gtk_image_accessible_get_type())

template IMAGE_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_IMAGE_ACCESSIBLE, 
                              TImageAccessible))

template IMAGE_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_IMAGE_ACCESSIBLE, 
                           TImageAccessibleClass))

template IS_IMAGE_ACCESSIBLE*(obj: expr): expr = 
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_IMAGE_ACCESSIBLE))

template IS_IMAGE_ACCESSIBLE_CLASS*(klass: expr): expr = 
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_IMAGE_ACCESSIBLE))

template IMAGE_ACCESSIBLE_GET_CLASS*(obj: expr): expr = 
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_IMAGE_ACCESSIBLE, 
                             TImageAccessibleClass))

type 
